//build wordnet json data from freebase.com

//get your freebase key at https://code.google.com/apis/console/
var key = "";

// Generated by CoffeeScript 1.6.3
var all_pos, async, do_pos, freebase, fs;

require('dirtyjs');

freebase = require('freebase');

fs = require("fs");

async = require("async");

do_pos = function(pos, cb) {
  var master_query, pos_query, q;
  if (pos == null) {
    pos = "Adverb";
  }
  if (cb == null) {
    cb = console.log;
  }
  master_query = {
    "name": null,
    "type": "/base/wordnet/synset",
    "lexname": [],
    "syntactic_category": pos,
    "gloss": [],
    "word": [{
      "/base/wordnet/word_sense/word": [{
        "/base/wordnet/word/word": []
      }]
    }]
  };
  pos_query = {
    Noun: {
      "hypernym": [],
      "substance_holonym": [],
      "member_holonym": [],
      "part_holonym": [],
      "equivalent_topic": [{
        "optional": true,
        "mid": null,
        "key": [{
          "optional": true,
          "namespace": "/wikipedia/en_title",
          "value": null
        }]
      }],
      "instance": [{
        "optional": true,
        "name": []
      }]
    },
    Adjective: {
      "satellite": []
    },
    Verb: {
      "entailment": [],
      "causes": []
    },
    Adverb: {}
  };
  q = JSON.parse(JSON.stringify(master_query));
  q = Object.merge(q, pos_query[pos]);
  freebase.paginate([q], {
    max: 999999,
    key: key
  }, function(all) {
    all = all.map(function(r) {
      var obj;
      r.word = r.word || [];
      r.gloss = r.gloss[0] || '';
      r.gloss = r.gloss.split(/; /);
      if (pos === "Noun") {
        r.equivalent_topic[0] = r.equivalent_topic[0] || {
          key: {}
        };
        r.equivalent_topic[0].key[0] = r.equivalent_topic[0].key[0] || {};
        r.instance = r.instance || [];
      }
      obj = {
        id: r.name,
        lexname: r.lexname[0],
        syntactic_category: r.syntactic_category,
        description: r.gloss[0],
        words: r.word.map(function(w) {
          return w["/base/wordnet/word_sense/word"][0]["/base/wordnet/word/word"][0];
        })
      };
      if (pos === "Noun") {
        obj.relationships = {
          type_of: r.hypernym,
          made_with: r.substance_holonym,
          members: r.member_holonym,
          parts: r.part_holonym,
          instances: r.instance.map('name')
        };
        obj.same_as = {
          freebase_topic: r.equivalent_topic[0].mid,
          wikipedia_page: r.equivalent_topic[0].key[0].value
        };
      }
      if (pos === "Adjective") {
        obj.similar = r.satellite;
      }
      if (pos === "Verb") {
        obj.assumes = r.entailment;
        obj.causes = r.causes;
      }
      return obj;
    });
    fs.writeFileSync("./" + (pos.toLowerCase()) + ".js", "exports.data= " + (JSON.stringify(all)));
    return cb(all);
  });
};

function doall() {
  do_pos("Adverb", function(r) {
    console.log(r.length + " adverbs");
    do_pos("Adjective", function(r) {
      console.log(r.length + " adjectives");
      do_pos("Verb", function(r) {
        console.log(r.length + " verbs");
        do_pos("Noun", function(r) {
          console.log(r.length + " nouns");
        });
      });
    });
  });
}
doall()
