/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).tf=e.tf||{})}(this,(function(e){"use strict";class t{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class n{refCount(e){return s("refCount")}incRef(e){return s("incRef")}timerAvailable(){return!0}time(e){return s("time")}read(e){return s("read")}readSync(e){return s("readSync")}readToGPU(e,t){return s("readToGPU")}numDataIds(){return s("numDataIds")}disposeData(e,t){return s("disposeData")}write(e,t,n){return s("write")}move(e,t,n,r,a){return s("move")}memory(){return s("memory")}floatPrecision(){return s("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return s("dispose")}}function s(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,o(e,t,n)}function a(e,t,n){return Math.max(e,Math.min(t,n))}function i(e){return e%2==0?e:e+1}function o(e,t,n){const s=e[t];e[t]=e[n],e[n]=s}function l(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t}function u(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function c(e,t,n=""){u(f(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function h(e){u(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function p(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||$(e)&&!n)for(let s=0;s<e.length;++s)p(e[s],t,n);else t.push(e);return t}function d(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function f(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function m(e){return e%1==0}function g(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]}function y(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function b(e,t=(e=>0),n){return new Promise(((s,r)=>{let a=0;const i=()=>{if(e())return void s();a++;const o=t(a);null!=n&&a>=n?r():setTimeout(i,o)};i()}))}function x(e,t){let n=1,s=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==s)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${s} and dim ${t}`);s=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===s){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const r=e.slice();return r[s]=t/n,r}function w(e,t){const n=t.length;return u((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),u(e.every((e=>m(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function v(e,t){const n=[],s=[],r=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||r?null:w(t,e).sort();let i=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[i]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[i]||a[i]>t)&&1===e[t]&&(n.push(e[t]),s.push(t)),a[i]<=t&&i++}1!==e[t]&&(n.push(e[t]),s.push(t))}return{newShape:n,keptDims:s}}function k(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function N(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function I(e,t){for(let n=0;n<e.length;n++){const s=e[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${t} being uploaded contains ${s}.`)}}function S(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function T(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function $(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function C(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function E(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function A(e){return"string"==typeof e||e instanceof String}function R(e){return"boolean"==typeof e}function _(e){return"number"==typeof e}function F(e){return Array.isArray(e)?F(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":_(e)?"float32":A(e)?"string":R(e)?"bool":"float32"}function D(e){return!!(e&&e.constructor&&e.call&&e.apply)}function O(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function M(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let s=t-3;s>=0;--s)n[s]=n[s+1]*e[s+1];return n}function L(e,t,n,s=!1){const r=new Array;if(1===t.length){const a=t[0]*(s?2:1);for(let t=0;t<a;t++)r[t]=n[e+t]}else{const a=t[0],i=t.slice(1),o=i.reduce(((e,t)=>e*t))*(s?2:1);for(let t=0;t<a;t++)r[t]=L(e+t*o,i,n,s)}return r}function z(e,t,n=!1){if(0===e.length)return t[0];const s=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===s)return[];if(s!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return L(0,e,t,n)}function P(e,t){const n=B(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function B(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function W(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return z(e,new Float32Array(n));if("int32"===t)return z(e,new Int32Array(n));if("bool"===t)return z(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)}function V(e){e.forEach((t=>{u(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function U(e,t,n){if(0===t)return 0;if(1===t)return e[0];let s=e[e.length-1];for(let t=0;t<e.length-1;++t)s+=n[t]*e[t];return s}function G(e,t,n){if(0===t)return[];if(1===t)return[e];const s=new Array(t);for(let t=0;t<s.length-1;++t)s[t]=Math.floor(e/n[t]),e-=s[t]*n[t];return s[s.length-1]=e,s}function H(e){return e&&e.then&&"function"==typeof e.then}const j="tfjsflags";class q{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=K,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(X().getBool("IS_TEST")||X().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];X().getBool("IS_TEST")||X().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(H(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if(j in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function K(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function X(){return e.ENV}let Y;function Z(){if(null==Y){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}Y=e}return Y}function J(e,t){const n=function(){const e=Z();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const s=t();return n.set(e,s),n.get(e)}}e.ENV=null;const Q="Abs",ee="Acos",te="Acosh",ne="Add",se="AddN",re="All",ae="Any",ie="ArgMax",oe="ArgMin",le="Asin",ue="Asinh",ce="Atan",he="Atanh",pe="Atan2",de="AvgPool",fe="AvgPoolGrad",me="AvgPool3D",ge="AvgPool3DGrad",ye="BatchMatMul",be="BatchToSpaceND",xe="Bincount",we="BroadcastTo",ve="BroadcastArgs",ke="Cast",Ne="Ceil",Ie="ClipByValue",Se="Complex",Te="ComplexAbs",$e="Concat",Ce="Conv2D",Ee="Conv2DBackpropFilter",Ae="Conv2DBackpropInput",Re="Conv3D",_e="Conv3DBackpropFilterV2",Fe="Conv3DBackpropInputV2",De="Cos",Oe="Cosh",Me="Cumprod",Le="Cumsum",ze="CropAndResize",Pe="DenseBincount",Be="DepthToSpace",We="DepthwiseConv2dNative",Ve="DepthwiseConv2dNativeBackpropFilter",Ue="DepthwiseConv2dNativeBackpropInput",Ge="Diag",He="Dilation2D",je="Dilation2DBackpropInput",qe="Dilation2DBackpropFilter",Ke="RealDiv",Xe="Einsum",Ye="Elu",Ze="EluGrad",Je="Erf",Qe="Equal",et="Exp",tt="ExpandDims",nt="Expm1",st="FFT",rt="Fill",at="FlipLeftRight",it="Floor",ot="FloorDiv",lt="FusedBatchNorm",ut="GatherV2",ct="GatherNd",ht="Greater",pt="GreaterEqual",dt="Identity",ft="IFFT",mt="Imag",gt="IsFinite",yt="IsInf",bt="IsNan",xt="LeakyRelu",wt="Less",vt="LessEqual",kt="LinSpace",Nt="Log",It="Log1p",St="LogicalAnd",Tt="LogicalNot",$t="LogicalOr",Ct="LogSoftmax",Et="LRN",At="LRNGrad",Rt="Max",_t="Maximum",Ft="MaxPool",Dt="MaxPoolGrad",Ot="MaxPool3D",Mt="MaxPool3DGrad",Lt="MaxPoolWithArgmax",zt="Mean",Pt="Min",Bt="Minimum",Wt="MirrorPad",Vt="Mod",Ut="Multinomial",Gt="Multiply",Ht="Neg",jt="NotEqual",qt="NonMaxSuppressionV3",Kt="NonMaxSuppressionV4",Xt="NonMaxSuppressionV5",Yt="OnesLike",Zt="OneHot",Jt="Pack",Qt="PadV2",en="Pow",tn="Prelu",nn="Prod",sn="Range",rn="Real",an="Reciprocal",on="Relu",ln="Reshape",un="ResizeNearestNeighbor",cn="ResizeNearestNeighborGrad",hn="ResizeBilinear",pn="ResizeBilinearGrad",dn="Relu6",fn="Reverse",mn="Round",gn="Rsqrt",yn="ScatterNd",bn="SearchSorted",xn="Select",wn="Selu",vn="Slice",kn="Sin",Nn="Sinh",In="Sign",Sn="Sigmoid",Tn="Softplus",$n="Sqrt",Cn="Sum",En="SpaceToBatchND",An="SplitV",Rn="Softmax",_n="SparseFillEmptyRows",Fn="SparseReshape",Dn="SparseSegmentMean",On="SparseSegmentSum",Mn="SparseToDense",Ln="SquaredDifference",zn="Square",Pn="StridedSlice",Bn="StringNGrams",Wn="StringSplit",Vn="StringToHashBucketFast",Un="Sub",Gn="Tan",Hn="Tanh",jn="Tile",qn="TopK",Kn="Transform",Xn="Transpose",Yn="Unique",Zn="Unpack",Jn="UnsortedSegmentSum",Qn="ZerosLike",es="Step",ts="FromPixels",ns="RotateWithOffset",ss="_FusedMatMul",rs="FusedConv2D",as="FusedDepthwiseConv2D";function is(...e){X().getBool("IS_TEST")||X().getBool("PROD")||console.warn(...e)}const os=J("kernelRegistry",(()=>new Map)),ls=J("gradRegistry",(()=>new Map));function us(e,t){const n=fs(e,t);return os.get(n)}function cs(e){return ls.get(e)}function hs(e){const t=os.entries(),n=[];for(;;){const{done:s,value:r}=t.next();if(s)break;const[a,i]=r,[o]=a.split("_");o===e&&n.push(i)}return n}function ps(e){const{kernelName:t,backendName:n}=e,s=fs(t,n);os.has(s)&&is(`The kernel '${t}' for backend '${n}' is already registered`),os.set(s,e)}function ds(e){const{kernelName:t}=e;ls.has(t)&&X().getBool("DEBUG")&&is(`Overriding the gradient for '${t}'`),ls.set(t,e)}function fs(e,t){return`${t}_${e}`}var ms=ys,gs=null;try{gs=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function ys(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function bs(e){return!0===(e&&e.__isLong__)}ys.prototype.__isLong__,Object.defineProperty(ys.prototype,"__isLong__",{value:!0}),ys.isLong=bs;var xs={},ws={};function vs(e,t){var n,s,r;return t?(r=0<=(e>>>=0)&&e<256)&&(s=ws[e])?s:(n=Ns(e,(0|e)<0?-1:0,!0),r&&(ws[e]=n),n):(r=-128<=(e|=0)&&e<128)&&(s=xs[e])?s:(n=Ns(e,e<0?-1:0,!1),r&&(xs[e]=n),n)}function ks(e,t){if(isNaN(e))return t?_s:Rs;if(t){if(e<0)return _s;if(e>=Cs)return Ls}else{if(e<=-Es)return zs;if(e+1>=Es)return Ms}return e<0?ks(-e,t).neg():Ns(e%$s|0,e/$s|0,t)}function Ns(e,t,n){return new ys(e,t,n)}ys.fromInt=vs,ys.fromNumber=ks,ys.fromBits=Ns;var Is=Math.pow;function Ss(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Rs;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return Ss(e.substring(1),t,n).neg();for(var r=ks(Is(n,8)),a=Rs,i=0;i<e.length;i+=8){var o=Math.min(8,e.length-i),l=parseInt(e.substring(i,i+o),n);if(o<8){var u=ks(Is(n,o));a=a.mul(u).add(ks(l))}else a=(a=a.mul(r)).add(ks(l))}return a.unsigned=t,a}function Ts(e,t){return"number"==typeof e?ks(e,t):"string"==typeof e?Ss(e,t):Ns(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}ys.fromString=Ss,ys.fromValue=Ts;var $s=4294967296,Cs=$s*$s,Es=Cs/2,As=vs(1<<24),Rs=vs(0);ys.ZERO=Rs;var _s=vs(0,!0);ys.UZERO=_s;var Fs=vs(1);ys.ONE=Fs;var Ds=vs(1,!0);ys.UONE=Ds;var Os=vs(-1);ys.NEG_ONE=Os;var Ms=Ns(-1,2147483647,!1);ys.MAX_VALUE=Ms;var Ls=Ns(-1,-1,!0);ys.MAX_UNSIGNED_VALUE=Ls;var zs=Ns(0,-2147483648,!1);ys.MIN_VALUE=zs;var Ps=ys.prototype;Ps.toInt=function(){return this.unsigned?this.low>>>0:this.low},Ps.toNumber=function(){return this.unsigned?(this.high>>>0)*$s+(this.low>>>0):this.high*$s+(this.low>>>0)},Ps.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(zs)){var t=ks(e),n=this.div(t),s=n.mul(t).sub(this);return n.toString(e)+s.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var r=ks(Is(e,6),this.unsigned),a=this,i="";;){var o=a.div(r),l=(a.sub(o.mul(r)).toInt()>>>0).toString(e);if((a=o).isZero())return l+i;for(;l.length<6;)l="0"+l;i=""+l+i}},Ps.getHighBits=function(){return this.high},Ps.getHighBitsUnsigned=function(){return this.high>>>0},Ps.getLowBits=function(){return this.low},Ps.getLowBitsUnsigned=function(){return this.low>>>0},Ps.getNumBitsAbs=function(){if(this.isNegative())return this.eq(zs)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},Ps.isZero=function(){return 0===this.high&&0===this.low},Ps.eqz=Ps.isZero,Ps.isNegative=function(){return!this.unsigned&&this.high<0},Ps.isPositive=function(){return this.unsigned||this.high>=0},Ps.isOdd=function(){return 1==(1&this.low)},Ps.isEven=function(){return 0==(1&this.low)},Ps.equals=function(e){return bs(e)||(e=Ts(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},Ps.eq=Ps.equals,Ps.notEquals=function(e){return!this.eq(e)},Ps.neq=Ps.notEquals,Ps.ne=Ps.notEquals,Ps.lessThan=function(e){return this.comp(e)<0},Ps.lt=Ps.lessThan,Ps.lessThanOrEqual=function(e){return this.comp(e)<=0},Ps.lte=Ps.lessThanOrEqual,Ps.le=Ps.lessThanOrEqual,Ps.greaterThan=function(e){return this.comp(e)>0},Ps.gt=Ps.greaterThan,Ps.greaterThanOrEqual=function(e){return this.comp(e)>=0},Ps.gte=Ps.greaterThanOrEqual,Ps.ge=Ps.greaterThanOrEqual,Ps.compare=function(e){if(bs(e)||(e=Ts(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},Ps.comp=Ps.compare,Ps.negate=function(){return!this.unsigned&&this.eq(zs)?zs:this.not().add(Fs)},Ps.neg=Ps.negate,Ps.add=function(e){bs(e)||(e=Ts(e));var t=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,a=e.high>>>16,i=65535&e.high,o=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=r+(65535&e.low))>>>16,u+=(c+=s+o)>>>16,l+=(u+=n+i)>>>16,l+=t+a,Ns((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Ps.subtract=function(e){return bs(e)||(e=Ts(e)),this.add(e.neg())},Ps.sub=Ps.subtract,Ps.multiply=function(e){if(this.isZero())return Rs;if(bs(e)||(e=Ts(e)),gs)return Ns(gs.mul(this.low,this.high,e.low,e.high),gs.get_high(),this.unsigned);if(e.isZero())return Rs;if(this.eq(zs))return e.isOdd()?zs:Rs;if(e.eq(zs))return this.isOdd()?zs:Rs;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(As)&&e.lt(As))return ks(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,a=e.high>>>16,i=65535&e.high,o=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,p=0;return h+=(p+=r*l)>>>16,c+=(h+=s*l)>>>16,h&=65535,c+=(h+=r*o)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=s*o)>>>16,c&=65535,u+=(c+=r*i)>>>16,u+=t*l+n*o+s*i+r*a,Ns((h&=65535)<<16|(p&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},Ps.mul=Ps.multiply,Ps.divide=function(e){if(bs(e)||(e=Ts(e)),e.isZero())throw Error("division by zero");var t,n,s;if(gs)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?Ns((this.unsigned?gs.div_u:gs.div_s)(this.low,this.high,e.low,e.high),gs.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?_s:Rs;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return _s;if(e.gt(this.shru(1)))return Ds;s=_s}else{if(this.eq(zs))return e.eq(Fs)||e.eq(Os)?zs:e.eq(zs)?Fs:(t=this.shr(1).div(e).shl(1)).eq(Rs)?e.isNegative()?Fs:Os:(n=this.sub(e.mul(t)),s=t.add(n.div(e)));if(e.eq(zs))return this.unsigned?_s:Rs;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();s=Rs}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var r=Math.ceil(Math.log(t)/Math.LN2),a=r<=48?1:Is(2,r-48),i=ks(t),o=i.mul(e);o.isNegative()||o.gt(n);)o=(i=ks(t-=a,this.unsigned)).mul(e);i.isZero()&&(i=Fs),s=s.add(i),n=n.sub(o)}return s},Ps.div=Ps.divide,Ps.modulo=function(e){return bs(e)||(e=Ts(e)),gs?Ns((this.unsigned?gs.rem_u:gs.rem_s)(this.low,this.high,e.low,e.high),gs.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},Ps.mod=Ps.modulo,Ps.rem=Ps.modulo,Ps.not=function(){return Ns(~this.low,~this.high,this.unsigned)},Ps.and=function(e){return bs(e)||(e=Ts(e)),Ns(this.low&e.low,this.high&e.high,this.unsigned)},Ps.or=function(e){return bs(e)||(e=Ts(e)),Ns(this.low|e.low,this.high|e.high,this.unsigned)},Ps.xor=function(e){return bs(e)||(e=Ts(e)),Ns(this.low^e.low,this.high^e.high,this.unsigned)},Ps.shiftLeft=function(e){return bs(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Ns(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Ns(0,this.low<<e-32,this.unsigned)},Ps.shl=Ps.shiftLeft,Ps.shiftRight=function(e){return bs(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Ns(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Ns(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},Ps.shr=Ps.shiftRight,Ps.shiftRightUnsigned=function(e){if(bs(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?Ns(this.low>>>e|t<<32-e,t>>>e,this.unsigned):Ns(32===e?t:t>>>e-32,0,this.unsigned)},Ps.shru=Ps.shiftRightUnsigned,Ps.shr_u=Ps.shiftRightUnsigned,Ps.toSigned=function(){return this.unsigned?Ns(this.low,this.high,!1):this},Ps.toUnsigned=function(){return this.unsigned?this:Ns(this.low,this.high,!0)},Ps.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},Ps.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},Ps.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},ys.fromBytes=function(e,t,n){return n?ys.fromBytesLE(e,t):ys.fromBytesBE(e,t)},ys.fromBytesLE=function(e,t){return new ys(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},ys.fromBytesBE=function(e,t){return new ys(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const Bs=ms||Object.freeze({__proto__:null,default:ms,__moduleExports:ms});function Ws(e){return Bs.fromString(e,!0,16)}const Vs=Ws("c3a5c85c97cb3127"),Us=Ws("b492b66fbe98f273"),Gs=Ws("9ae16a3b2f90404f");function Hs(e){return e.xor(e.shru(47))}function js(e,t,n){const s=e.slice(t,t+n);return Bs.fromBytes(Array.from(s),!0,!0)}function qs(e,t){return js(e,t,8)}function Ks(e,t){return js(e,t,4)}function Xs(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function Ys(e,t,n=Ws("9ddfea08eb382d69")){let s=e.xor(t).mul(n);s=s.xor(s.shru(47));let r=t.xor(s).mul(n);return r=r.xor(r.shru(47)),r=r.mul(n),r}function Zs(e,t,n,s){return function(e,t,n,s,r,a){r=r.add(e),a=Xs(a.add(r).add(s),21);const i=r;return r=(r=r.add(t)).add(n),a=a.add(Xs(r,44)),[r.add(s),a.add(i)]}(qs(e,t),qs(e,t+8),qs(e,t+16),qs(e,t+24),n,s)}function Js(e,t=e.length){const n=Bs.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=Gs.add(2*t),s=qs(e,0).add(Gs),r=qs(e,t-8);return Ys(Xs(r,37).mul(n).add(s),Xs(s,25).add(r).mul(n),n)}if(t>=4){const n=Gs.add(2*t);return Ys(Ks(e,0).shl(3).add(t),Ks(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),s=t+(e[t-1]<<2);return Hs(Gs.mul(n).xor(Vs.mul(s))).mul(Gs)}return Gs}(e,t):function(e,t=e.length){const n=Gs.add(2*t),s=qs(e,0).mul(Us),r=qs(e,8),a=qs(e,t-8).mul(n),i=qs(e,t-16).mul(Gs);return Ys(Xs(s.add(r),43).add(Xs(a,30)).add(i),s.add(Xs(r.add(Gs),18)).add(a),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=Gs.add(2*t),s=qs(e,0).mul(Gs),r=qs(e,8),a=qs(e,t-8).mul(n),i=qs(e,t-16).mul(Gs),o=Xs(s.add(r),43).add(Xs(a,30)).add(i),l=Ys(o,s.add(Xs(r.add(Gs),18)).add(a),n),u=qs(e,16).mul(n),c=qs(e,24),h=o.add(qs(e,t-32)).mul(n),p=l.add(qs(e,t-24)).mul(n);return Ys(Xs(u.add(c),43).add(Xs(h,30)).add(p),u.add(Xs(c.add(s),18)).add(h),n)}(e,t);let s=n,r=n.mul(Us).add(113),a=Hs(r.mul(Gs).add(113)).mul(Gs),i=[Bs.UZERO,Bs.UZERO],o=[Bs.UZERO,Bs.UZERO];s=s.mul(Gs).add(qs(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{s=Xs(s.add(r).add(i[0]).add(qs(e,l+8)),37).mul(Us),r=Xs(r.add(i[1]).add(qs(e,l+48)),42).mul(Us),s=s.xor(o[1]),r=r.add(i[0]).add(qs(e,l+40)),a=Xs(a.add(o[0]),33).mul(Us),i=Zs(e,l,i[1].mul(Us),s.add(o[0])),o=Zs(e,l+32,a.add(o[1]),r.add(qs(e,l+16))),[a,s]=[s,a],l+=64}while(l!==u);const h=Us.add(a.and(255).shl(1));return l=c,o[0]=o[0].add(t-1&63),i[0]=i[0].add(o[0]),o[0]=o[0].add(i[0]),s=Xs(s.add(r).add(i[0]).add(qs(e,l+8)),37).mul(h),r=Xs(r.add(i[1]).add(qs(e,l+48)),42).mul(h),s=s.xor(o[1].mul(9)),r=r.add(i[0].mul(9).add(qs(e,l+40))),a=Xs(a.add(o[0]),33).mul(h),i=Zs(e,l,i[1].mul(h),s.add(o[0])),o=Zs(e,l+32,a.add(o[1]),r.add(qs(e,l+16))),[a,s]=[s,a],Ys(Ys(i[0],o[0],h).add(Hs(r).mul(Vs)).add(a),Ys(i[1],o[1],h).add(s),h)}function Qs(e,t){return"string"===t?sr(e):er([e],t)}function er(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=p(e)),X().getBool("DEBUG")&&I(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function tr(){return X().platform.now()}function nr(e,t){return X().platform.fetch(e,t)}function sr(e,t="utf-8"){return t=t||"utf-8",X().platform.encode(e,t)}function rr(e,t="utf-8"){return t=t||"utf-8",X().platform.decode(e,t)}var ar=Object.freeze({__proto__:null,createScalarValue:Qs,toTypedArray:er,now:tr,fetch:nr,encodeString:sr,decodeString:rr,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,s=0;for(;n>0;)s=Math.random()*n|0,n--,o(e,n,s),o(t,n,s)},clamp:a,nearestLargerEven:i,swap:o,sum:l,randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let s=0;s<e.length;s++){const r=Number(e[s])-Number(t[s]);n+=r*r}return n},assert:u,assertShapesMatch:c,assertNonNull:h,flatten:p,sizeFromShape:d,isScalarShape:function(e){return 0===e.length},arraysEqual:f,isInt:m,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:g,createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:y,repeatedTry:b,inferFromImplicitShape:x,parseAxisParam:w,squeezeShape:v,getTypedArrayFromDType:k,getArrayFromDType:N,checkConversionForErrors:I,isValidDtype:S,hasEncodingLoss:T,isTypedArray:$,bytesPerElement:C,bytesFromStringArray:E,isString:A,isBoolean:R,isNumber:_,inferDtype:F,isFunction:D,nearestDivisor:O,computeStrides:M,toNestedArray:z,makeOnesTypedArray:P,makeZerosTypedArray:B,makeZerosNestedTypedArray:W,assertNonNegativeIntegerDimensions:V,locToIndex:U,indexToLoc:G,isPromise:H,hexToLong:Ws,fingerPrint64:Js});class ir{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new lr)}profileKernel(e,t,n){let s;const r=()=>{s=n()};let a;const i=tr();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(r);else{r();for(const e of s)e.dataSync();a=Promise.resolve({kernelMs:tr()-i})}if(X().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<s.length;t++){const n=s[t];n.data().then((t=>{or(t,n.dtype,e)}))}return{kernelName:e,outputs:s,inputs:t,timeMs:a.then((e=>e.kernelMs)),extraInfo:a.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:s,inputs:r,extraInfo:a}=e;n.forEach((e=>{Promise.all([e.data(),s,a]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],r,n[2])}))}))}}function or(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const s=e[t];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class lr{logKernelProfile(e,t,n,s,r,a){const i="number"==typeof s?y(`${s}ms`,9):s.error,o=y(e,25),l=t.rank,u=t.size,c=y(t.shape.toString(),14);let h="";for(const e in r){const n=r[e];if(null!=n){const s=n.shape||t.shape,r=s.length;h+=`${e}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${i}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function ur(e,t,n,s){const r=M(t),a=function(e,t,n,s){const r=d(t),a=s[s.length-1],i=new Array(a).fill(0),o=t.length,l="complex64"===n?dr(e):e;if(o>1)for(let e=0;e<r/a;e++){const t=e*a;for(let e=0;e<a;e++)i[e]=Math.max(i[e],cr(l[t+e],0,n).length)}return i}(e,t,n,r),i=t.length,o=pr(e,t,n,r,a),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${i}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(o.map((e=>"    "+e)).join("\n")),l.join("\n")}function cr(e,t,n){let s;return s=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:A(e)?`'${e}'`:"bool"===n?hr(e):parseFloat(e.toFixed(7)).toString(),y(s,t)}function hr(e){return 0===e?"false":"true"}function pr(e,t,n,s,r,a=!0){const i="complex64"===n?2:1,o=t[0],l=t.length;if(0===l){if("complex64"===n){return[cr(dr(e)[0],0,n)]}return"bool"===n?[hr(e[0])]:[e[0].toString()]}if(1===l){if(o>20){const t=3*i;let s=Array.from(e.slice(0,t)),a=Array.from(e.slice((o-3)*i,o*i));return"complex64"===n&&(s=dr(s),a=dr(a)),["["+s.map(((e,t)=>cr(e,r[t],n))).join(", ")+", ..., "+a.map(((e,t)=>cr(e,r[o-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?dr(e):Array.from(e)).map(((e,t)=>cr(e,r[t],n))).join(", ")+"]"]}const u=t.slice(1),c=s.slice(1),h=s[0]*i,p=[];if(o>20){for(let t=0;t<3;t++){const s=t*h,a=s+h;p.push(...pr(e.slice(s,a),u,n,c,r,!1))}p.push("...");for(let t=o-3;t<o;t++){const s=t*h,a=s+h;p.push(...pr(e.slice(s,a),u,n,c,r,t===o-1))}}else for(let t=0;t<o;t++){const s=t*h,a=s+h;p.push(...pr(e.slice(s,a),u,n,c,r,t===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let e=1;e<p.length-1;e++)p[e]=" "+p[e]+d;let f=",\n";for(let e=2;e<l;e++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(a?"":f),p}function dr(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class fr{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=d(e),null!=n){const e=n.length;u(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||N(t,this.size),this.strides=M(e)}set(e,...t){0===t.length&&(t=[0]),u(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return mr().makeTensor(this.values,this.shape,this.dtype)}}let mr=null,gr=null,yr=null;class br{constructor(e,t,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=d(e),this.strides=M(e),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return gr.buffer(this.shape,this.dtype,e)}bufferSync(){return gr.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return z(this.shape,e,"complex64"===this.dtype)}arraySync(){return z(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=mr().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>rr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),mr().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=mr().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>rr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await mr().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(mr().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return gr.print(this,e)}clone(){return this.throwIfDisposed(),gr.clone(this)}toString(e=!1){return ur(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),gr.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),mr().makeVariable(this,e,t,n)}}function xr(){return J("Tensor",(()=>br))}Object.defineProperty(br,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),xr();class wr extends br{constructor(e,t,n,s){super(e.shape,e.dtype,e.dataId,s),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!f(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);mr().disposeTensor(this),this.dataId=e.dataId,mr().incRef(this,null)}dispose(){mr().disposeVariable(this),this.isDisposedInternal=!0}}var vr,kr,Nr,Ir,Sr;Object.defineProperty(wr,Symbol.hasInstance,{value:e=>e instanceof br&&null!=e.assign&&e.assign instanceof Function}),(vr=e.Rank||(e.Rank={})).R0="R0",vr.R1="R1",vr.R2="R2",vr.R3="R3",vr.R4="R4",vr.R5="R5",vr.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(kr||(kr={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Nr||(Nr={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Ir||(Ir={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Sr||(Sr={}));const Tr={float32:Ir,int32:kr,bool:Nr,complex64:Sr};function $r(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Tr[e][t]}function Cr(e){return $r(e,"int32")}function Er(e,t){if(e.dtype===t.dtype)return[e,t];const n=$r(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Ar(e,t){u(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function Rr(e,t){return t.some((t=>t.id===e.id))}function _r(e){const t=[];return Fr(e,t,new Set),t}function Fr(e,t,n){if(null==e)return;if(e instanceof br)return void t.push(e);if(s=e,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=e;for(const e in r){const s=r[e];n.has(s)||(n.add(s),Fr(s,t,n))}}var Dr=Object.freeze({__proto__:null,makeTypesMatch:Er,assertTypesMatch:Ar,isTensorInList:Rr,getTensorsInContainer:_r});function Or(e){return null!=e.kernelName}class Mr{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Lr{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Mr}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(is(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new ir(this.backendInstance),!0}setupRegisteredKernels(){hs(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){hs(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const s=t.factory();if(!s||s instanceof n||"function"!=typeof s.then)return this.registry[e]=s,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=s.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,is(`Initialization of backend ${e} failed`),is(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return is(`Initialization of backend ${e} failed`),is(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),s=n.backend,r=this.readSync(t),a=s.refCount(t);s.disposeData(t,!0),n.backend=e,e.move(t,r,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,s=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=e}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Lr.nextTensorId++}nextVariableId(){return Lr.nextVariableId++}clone(e){const t=Pr.runKernel(dt,{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Pr.runKernel(ke,t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=us(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const s=this.backend.numDataIds();let r=0;n.forEach((e=>{r+="complex64"===e.dtype?3:1}));const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],i=s-t-r-a;if(i>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${i} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const s=this.isTapeOn(),r=this.state.numBytes,a=this.state.numTensors;let i,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=Or(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Or(e)){const{kernelName:t,inputs:r,attrs:a}=e;null==this.backendName&&this.backend;const l=us(t,this.backendName);u(null!=l,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),i=()=>{const e=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:a,backend:this.backend});const i=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,i);const u=i.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(s){const e=this.getTensorsForGradient(t,r,u);n=this.saveTensorsForBackwardMode(e)}return u}}else{const{forwardFunc:t}=e,r=e=>{s&&(n=e.map((e=>this.keep(this.clone(e)))))};i=()=>{const e=this.backend.numDataIds();o=this.tidy((()=>t(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,e,n),n}}const{inputs:c,attrs:h}=e,p=Or(e)?null:e.backwardsFunc;let d;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(d=this.profiler.profileKernel(l,c,(()=>i())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(d),t=d.outputs):t=i()})),s&&this.addTapeNode(l,c,t,p,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:d.timeMs,extraInfo:d.extraInfo}),Array.isArray(o)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const s=cs(e);if(null!=s){const e=s.inputsToSave||[],r=s.outputsToSave||[];let a;s.saveAllInputs?(u(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),a=Object.keys(t).map((e=>t[e]))):a=e.map((e=>t[e]));const i=n.filter(((e,t)=>r[t]));return a.concat(i)}return[]}makeTensor(e,t,n,s){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=e;"string"===n&&A(e[0])&&(r=e.map((e=>sr(e))));const a=s.write(r,t,n),i=new br(t,n,a,this.nextTensorId());if(this.trackTensor(i,s),"string"===n){const e=this.state.tensorInfo.get(a),t=E(r);this.state.numBytes+=t-e.bytes,e.bytes=t}return i}makeTensorFromDataId(e,t,n,s){const r={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:s,dtype:r}=e,a=new br(s,r,n,this.nextTensorId());return this.trackTensor(a,t),a}makeVariable(e,t=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==e.dtype&&(e=e.cast(s));const r=new wr(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*C(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof wr||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*C(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,s,r,a){const i={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:r},o=cs(e);null!=o&&(s=o.gradFunc),null!=s&&(i.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],s=B(e.size,e.dtype);return this.makeTensor(s,e.shape,e.dtype)}return e})),s(e.length>1?e:e[0],r,a))),this.state.activeTape.push(i)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=_r(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==s.id||this.track(e)}))}gradients(e,t,n,s=!1){if(u(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));u(r instanceof br,(()=>"The result y returned by f() must be a tensor."));const a=function(e,t,n){const s={},r={};for(let e=0;e<t.length;e++)s[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],i=a.inputs;for(const e in i){const n=i[e];let o=!1;for(let e=0;e<t.length;e++)if(s[n.id]){a.outputs.forEach((e=>s[e.id]=!0)),o=!0,r[a.id]=!0;break}if(o)break}}const a={};a[n.id]=!0;const i={};for(let t=e.length-1;t>=0;t--){const n=e[t],s=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in s)a[s[e].id]=!0,i[n.id]=!0;break}}const o=[];for(let t=0;t<e.length;t++){const n=e[t];if(r[n.id]&&i[n.id]){const e={};for(const t in n.inputs){const r=n.inputs[t];s[r.id]&&(e[t]=r)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,o.push(t)}}return o}(this.state.activeTape,t,r);if(!s&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[r.id]=null==n?function(e){const t=P(d(e),"float32");return Pr.makeTensor(t,e,"float32")}(r.shape):n,function(e,t,n,s){for(let r=t.length-1;r>=0;r--){const a=t[r],i=[];if(a.outputs.forEach((t=>{const n=e[t.id];null!=n?i.push(n):i.push(null)})),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const o=a.gradient(i);for(const t in a.inputs){if(!(t in o))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[t]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${r.dtype}'`);const i=a.inputs[t];if(!f(r.shape,i.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${r.shape}', which does not match the shape of the input '${i.shape}'`);if(null==e[i.id])e[i.id]=r;else{const t=e[i.id];e[i.id]=s(t,r),t.dispose()}}}}(e,a,(e=>this.tidy(e)),Br);const s=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(e){return u(D(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;u(t.every((e=>e instanceof br)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};t.forEach(((e,t)=>{s[t]=e}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=e(...t,r),u(n.value instanceof br,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),u(D(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,s)=>{const r=n.gradFunc(e,s),a=Array.isArray(r)?r:[r];u(a.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),u(a.every((e=>e instanceof br)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const i={};return a.forEach(((e,t)=>{i[t]=()=>e})),i},inputs:s})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=tr(),n=await this.backend.time(e);return n.wallMs=tr()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Mr;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function zr(){const t=Z();if(null==t._tfengine){const e=new q(t);t._tfengine=new Lr(e)}var n;return n=t._tfengine.ENV,e.ENV=n,mr=()=>t._tfengine,t._tfengine}Lr.nextTensorId=0,Lr.nextVariableId=0;const Pr=zr();function Br(e,t){const n={a:e,b:t};return Pr.runKernel(ne,n)}let Wr;function Vr(e){if(void 0!==Wr)return Wr;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1}function Ur(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Gr=Object.freeze({__proto__:null,mockIsMobile:function(e){Wr=e},isMobile:Vr,isBrowser:Ur});const Hr=X();function jr(e,t){let n=e;if($(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const s=[];for(;Array.isArray(n)||$(n)&&"string"!==t;)s.push(n.length),n=n[0];return Array.isArray(e)&&X().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&qr(e,s,[]),s}function qr(e,t,n){if(n=n||[],!Array.isArray(e)&&!$(e))return void u(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));u(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),u(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const s=t.slice(1);for(let t=0;t<e.length;++t)qr(e[t],s,n.concat(t))}function Kr(e,t,n,s){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${s}' must be ${e} tensor, but got ${t} tensor`)}}function Xr(e,t,n,s="numeric"){if(e instanceof br)return Kr(s,e.dtype,t,n),e;let r=F(e);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Kr(s,r,t,n),null==e||!$(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const s=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const a=jr(e,r);$(e)||Array.isArray(e)||(e=[e]);const i="string"!==r?er(e,r):p(e,[],!0);return Pr.makeTensor(i,a,r)}function Yr(e,t,n,s="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,r)=>Xr(e,`${t}[${r}]`,n,s)))}Hr.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),Hr.registerFlag("IS_BROWSER",(()=>Ur())),Hr.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node)),Hr.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),Hr.registerFlag("PROD",(()=>!1)),Hr.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>Hr.getBool("DEBUG"))),Hr.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),Hr.registerFlag("IS_TEST",(()=>!1)),Hr.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),Hr.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),Hr.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const Zr="__op";function Jr(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const s=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+=Zr;const r=(...e)=>{Pr.startScope(n);try{const t=s(...e);return H(t)&&console.error("Cannot return a Promise inside of tidy."),Pr.endScope(t),t}catch(e){throw Pr.endScope(null),e}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Qr=Jr({complex_:function(e,t){const n=Xr(e,"real","complex"),s=Xr(t,"imag","complex");c(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Pr.runKernel(Se,r)}});function ea(e,t,n,s){if(null==s&&(s=F(e)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!$(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){V(t);const e=d(t),s=d(n);u(e===s,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${s}`));for(let e=0;e<n.length;++e){const s=n[e],r=e!==n.length-1||s!==d(t.slice(e));u(n[e]===t[e]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return $(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==s?er(e,s):p(e,[],!0),Pr.makeTensor(e,t,s)}function ta(e,t,n){return ea(e,t,jr(e,n),n)}const na={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};async function sa(e,t){const n=[],s=[],r=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let a=0;a<r.length;++a){const i=r[a],o=Array.isArray(e)?e[a].tensor:e[i];if("float32"!==o.dtype&&"int32"!==o.dtype&&"bool"!==o.dtype&&"string"!==o.dtype&&"complex64"!==o.dtype)throw new Error(`Unsupported dtype in weight '${i}': ${o.dtype}`);const l={name:i,shape:o.shape,dtype:o.dtype};if("string"===o.dtype){const e=new Promise((async e=>{const t=await o.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,s=new Uint8Array(n);let r=0;for(let e=0;e<t.length;e++){const n=t[e],a=new Uint8Array(new Uint32Array([n.length]).buffer);s.set(a,r),r+=4,s.set(n,r),r+=n.length}e(s)}));s.push(e)}else s.push(o.data());null!=t&&(l.group=t),n.push(l)}return{data:aa(await Promise.all(s)),specs:n}}function ra(e,t){const n={};let s,r=0;for(const a of t){const t=a.name,i=a.dtype,o=a.shape,l=d(o);let u;if("quantization"in a){const n=a.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${a.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${a.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==i)throw new Error(`Weight ${a.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${i}.`)}const o=na[n.dtype],c=e.slice(r,r+l*o),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===i)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===s&&(s=da()),u=s(h)}else{if("int32"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}r+=l*o}else if("string"===i){const t=d(a.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(r,r+4))[0];r+=4;const n=new Uint8Array(e.slice(r,r+t));u.push(n),r+=t}}else{const s=na[i],a=e.slice(r,r+l*s);if("float32"===i)u=new Float32Array(a);else if("int32"===i)u=new Int32Array(a);else if("bool"===i)u=new Uint8Array(a);else{if("complex64"!==i)throw new Error(`Unsupported dtype in weight '${t}': ${i}`);{u=new Float32Array(a);const e=new Float32Array(u.length/2),s=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],s[t]=u[2*t+1];const r=ta(e,o,"float32"),i=ta(s,o,"float32");n[t]=Qr(r,i),r.dispose(),i.dispose()}}r+=l*s}"complex64"!==i&&(n[t]=ta(u,o,i))}return n}function aa(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const s=new Uint8Array(t);let r=0;return n.forEach((e=>{s.set(new Uint8Array(e.buffer),r),r+=e.byteLength})),s.buffer}const ia="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function oa(e){return ia?Buffer.byteLength(e):new Blob([e]).size}function la(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let s=0;return e.forEach((e=>{n.set(new Uint8Array(e),s),s+=e.byteLength})),n.buffer}function ua(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function ca(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}async function ha(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),null!=e.weightsManifest){const[s,r]=await t(e.weightsManifest);n.weightSpecs=s,n.weightData=r}return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),n}function pa(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:oa(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:oa(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function da(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return s=>{const r=new ArrayBuffer(4*s.length),a=new Uint32Array(r);for(let r=0;r<s.length;r++){const i=s[r],o=e[n[i>>10]+(1023&i)]+t[i>>10];a[r]=o}return new Float32Array(r)}}class fa{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==fa.instance&&(fa.instance=new fa),fa.instance}static registerSaveRouter(e){fa.getInstance().saveRouters.push(e)}static registerLoadRouter(e){fa.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return fa.getHandlers(e,"save")}static getLoadHandlers(e,t){return fa.getHandlers(e,"load",t)}static getHandlers(e,t,n){const s=[];return("load"===t?fa.getInstance().loadRouters:fa.getInstance().saveRouters).forEach((t=>{const r=t(e,n);null!==r&&s.push(r)})),s}}const ma=e=>fa.getSaveHandlers(e),ga=(e,t)=>fa.getLoadHandlers(e,t),ya="tensorflowjs",ba="models_store",xa="model_info_store";function wa(){if(!X().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function va(e){const t=e.result;t.createObjectStore(ba,{keyPath:"modelPath"}),t.createObjectStore(xa,{keyPath:"modelPath"})}class ka{constructor(e){if(this.indexedDB=wa(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const s=this.indexedDB.open(ya,1);s.onupgradeneeded=()=>va(s),s.onsuccess=()=>{const r=s.result;if(null==t){const t=r.transaction(ba,"readonly"),s=t.objectStore(ba).get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(s.result.modelArtifacts)},s.onerror=e=>(r.close(),n(s.error)),t.oncomplete=()=>r.close()}else{const s=pa(t),a=r.transaction(xa,"readwrite");let i=a.objectStore(xa);const o=i.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction(ba,"readwrite");const o=l.objectStore(ba).put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:s});o.onsuccess=()=>e({modelArtifactsInfo:s}),o.onerror=e=>{i=a.objectStore(xa);const t=i.delete(this.modelPath);t.onsuccess=()=>(r.close(),n(o.error)),t.onerror=e=>(r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=e=>n(s.error)}))}}ka.URL_SCHEME="indexeddb://";const Na=e=>{return X().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(ka.URL_SCHEME)?(t=e.slice(ka.URL_SCHEME.length),new ka(t)):null;var t};fa.registerSaveRouter(Na),fa.registerLoadRouter(Na);class Ia{constructor(){this.indexedDB=wa()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open(ya,1);n.onupgradeneeded=()=>va(n),n.onsuccess=()=>{const s=n.result,r=s.transaction(xa,"readonly"),a=r.objectStore(xa).getAll();a.onsuccess=()=>{const t={};for(const e of a.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},a.onerror=e=>(s.close(),t(a.error)),r.oncomplete=()=>s.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(ka.URL_SCHEME)?t.slice(ka.URL_SCHEME.length):t,new Promise(((t,n)=>{const s=this.indexedDB.open(ya,1);s.onupgradeneeded=()=>va(s),s.onsuccess=()=>{const r=s.result,a=r.transaction(xa,"readwrite"),i=a.objectStore(xa),o=i.get(e);let l;o.onsuccess=()=>{if(null==o.result)return r.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const s=i.delete(e),a=()=>{l=r.transaction(ba,"readwrite");const s=l.objectStore(ba).delete(e);s.onsuccess=()=>t(o.result.modelArtifactsInfo),s.onerror=e=>n(o.error)};s.onsuccess=a,s.onerror=e=>(a(),r.close(),n(o.error))}},o.onerror=e=>(r.close(),n(o.error)),a.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}},s.onerror=e=>n(s.error)}))}}const Sa="/",Ta="tensorflowjs_models",$a="info",Ca="model_topology",Ea="weight_specs",Aa="weight_data",Ra="model_metadata";function _a(e){return{info:[Ta,e,$a].join(Sa),topology:[Ta,e,Ca].join(Sa),weightSpecs:[Ta,e,Ea].join(Sa),weightData:[Ta,e,Aa].join(Sa),modelMetadata:[Ta,e,Ra].join(Sa)}}function Fa(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function Da(e){const t=e.split(Sa);if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join(Sa)}class Oa{constructor(e){if(!X().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=_a(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),s=pa(e);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(ia)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,s=t.length;e<s;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const r={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(e){throw Fa(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const e=JSON.parse(r);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const a=this.LS.getItem(this.keys.weightData);if(null==a)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(ia){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(a),t}}Oa.URL_SCHEME="localstorage://";const Ma=e=>{return X().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Oa.URL_SCHEME)?(t=e.slice(Oa.URL_SCHEME.length),new Oa(t)):null;var t};fa.registerSaveRouter(Ma),fa.registerLoadRouter(Ma);class La{constructor(){u(X().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),u("undefined"==typeof window||void 0!==window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=Ta+Sa,n=Sa+$a;for(let s=0;s<this.LS.length;++s){const r=this.LS.key(s);if(r.startsWith(t)&&r.endsWith(n)){e[Da(r)]=JSON.parse(this.LS.getItem(r))}}return e}async removeModel(e){var t;const n=_a(e=(t=e).startsWith(Oa.URL_SCHEME)?t.slice(Oa.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const s=JSON.parse(this.LS.getItem(n.info));return Fa(n),s}}const za="://";class Pa{constructor(){this.managers={}}static getInstance(){return null==Pa.instance&&(Pa.instance=new Pa),Pa.instance}static registerManager(e,t){u(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith(za)&&(e=e.slice(0,e.indexOf(za))),u(e.length>0,(()=>"scheme must not be an empty string."));const n=Pa.getInstance();u(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=Pa.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(Pa.getInstance().managers)}}function Ba(e){if(-1===e.indexOf(za))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${Pa.getSchemes().join(",")}`);return{scheme:e.split(za)[0],path:e.split(za)[1]}}async function Wa(e,t,n=!1){u(e!==t,(()=>`Old path and new path are the same: '${e}'`));const s=fa.getLoadHandlers(e);u(s.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),u(s.length<2,(()=>`Copying failed because more than one (${s.length}) load handlers for source URL ${e}.`));const r=s[0],a=fa.getSaveHandlers(t);u(a.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),u(a.length<2,(()=>`Copying failed because more than one (${s.length}) save handlers for destination URL ${t}.`));const i=a[0],o=Ba(e).scheme,l=Ba(e).path,c=o===Ba(e).scheme,h=await r.load();n&&c&&await Pa.getManager(o).removeModel(l);const p=await i.save(h);return n&&!c&&await Pa.getManager(o).removeModel(l),p.modelArtifactsInfo}class Va{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(X().get("IS_BROWSER")){X().setPlatform("browser",new Va);try{Pa.registerManager(Oa.URL_SCHEME,new La)}catch(e){}try{Pa.registerManager(ka.URL_SCHEME,new Ia)}catch(e){}}const Ua=()=>require("node-fetch");let Ga;class Ha{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=X().global.fetch?X().global.fetch(e,t):(null==Ga&&(Ga=Ua()),Ga(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function ja(e,t="float32",n){return t=t||"float32",V(e),new fr(e,t,n)}X().get("IS_NODE")&&!X().get("IS_BROWSER")&&X().setPlatform("node",new Ha);const qa=Jr({cast_:function(e,t){const n=Xr(e,"x","cast");if(!S(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:t};return Pr.runKernel(ke,s,r)}});const Ka=Jr({clone_:function(e){const t={x:Xr(e,"x","clone","string_or_numeric")};return Pr.runKernel(dt,t)}});function Xa(e,t=!1){console.log(e.toString(t))}zr();gr={buffer:ja,cast:qa,clone:Ka,print:Xa};function Ya(e){return new Promise((e=>setTimeout(e))).then(e)}class Za{constructor(e){if(!X().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Za.URL_SCHEME)&&(e=e.slice(Za.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=ca(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Ya((()=>r.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Ya((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:pa(e)}}}}Za.URL_SCHEME="downloads://";class Ja{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const s=JSON.parse(n.target.result),r=s.modelTopology;if(null==r)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==s.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:r});const a=ha(s,(e=>this.loadWeights(e)));e(a)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const s of e)t.push(...s.weights),n.push(...s.paths);const s=this.checkManifestAndWeightFiles(e),r=n.map((e=>this.loadWeightsFile(e,s[e])));return Promise.all(r).then((e=>[t,la(e)]))}loadWeightsFile(e,t){return new Promise(((n,s)=>{const r=new FileReader;r.onload=e=>{const t=e.target.result;n(t)},r.onerror=t=>s(`Failed to weights data from file of path '${e}'.`),r.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>ua(e.name))),s={};for(const r of e)r.paths.forEach((e=>{const r=ua(e);if(-1!==t.indexOf(r))throw new Error(`Duplicate file basename found in weights manifest: '${r}'`);if(t.push(r),-1===n.indexOf(r))throw new Error(`Weight file with basename '${r}' is not provided.`);s[e]=this.weightsFiles[n.indexOf(r)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return s}}function Qa(e,t,n,s){!function(e){u(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){u(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),u(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),u(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(e.map((a=>(a.then((a=>{const i=n+ ++r/e.length*(s-n);return t(i),a})),a))))}async function ei(e,t){null==t&&(t={});const n=null==t.fetchFunc?X().platform.fetch:t.fetchFunc,s=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),r=(null==t.onProgress?await Promise.all(s):await Qa(s,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(r):await Qa(r,t.onProgress,.5,1)}async function ti(e,t="",n,s){return ni((e=>ei(e,{requestInit:s})))(e,t,n)}function ni(e){return async(t,n="",s)=>{const r=t.map((()=>!1)),a={},i=null!=s?s.map((()=>!1)):[],o=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=na[l]*d(e.shape),c=()=>{r[t]=!0,null==a[t]&&(a[t]=[]),a[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=s?s.forEach(((t,n)=>{t===e.name&&(c(),i[n]=!0)})):c(),o.push(e.name),n+=u}))})),!i.every((e=>e))){const e=s.filter(((e,t)=>!i[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${o.join(", ")}.`)}const l=r.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const c=await e(u),h={};let p=0;return l.forEach((e=>{const n=t[e].paths.length;let s=0;for(let e=0;e<n;e++)s+=c[p+e].byteLength;const r=new ArrayBuffer(s),i=new Uint8Array(r);let o=0;for(let e=0;e<n;e++){const t=new Uint8Array(c[p+e]);i.set(t,o),o+=t.byteLength}a[e].forEach((e=>{const t=ra(r.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)h[e]=t[e]})),p+=n})),h}}fa.registerSaveRouter((e=>X().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Za.URL_SCHEME)?function(e="model"){return new Za(e)}(e.slice(Za.URL_SCHEME.length)):null));class si{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(u("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=X().platform.fetch,u(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&u(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=ca(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const s=await this.fetch(this.path,t);if(s.ok)return{modelArtifactsInfo:pa(e),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,s=t.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return ha(t,(e=>this.loadWeights(e)))}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),s=e.substring(0,t),r=n>t?e.substring(n):"";return[s+"/",r]}(t),r=this.weightPathPrefix||n,a=[];for(const t of e)a.push(...t.weights);const i=[],o=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(e)):i.push(r+e+s);this.weightUrlConverter&&i.push(...await Promise.all(o));return[a,la(await ei(i,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function ri(e){return null!=e.match(si.URL_SCHEME_REGEX)}si.URL_SCHEME_REGEX=/^https?:\/\//;const ai=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>ri(e))):ri(e),n)return ii(e,t)}return null};function ii(e,t){return new si(e,t)}function oi(e,t){return ii(e,t)}fa.registerSaveRouter(ai),fa.registerLoadRouter(ai);class li{constructor(e){this.modelArtifacts=e}load(){return this.modelArtifacts}}class ui{constructor(e){this.saveHandler=e}save(e){return this.saveHandler(e)}}class ci{constructor(e){e.load&&(this.load=()=>Promise.resolve(e.load())),e.save&&(this.save=t=>Promise.resolve(e.save(t)))}}function hi(e,t,n,s){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new li(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new li({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new li({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:s})}var pi=Object.freeze({__proto__:null,browserFiles:function(e){return new Ja(e)},browserHTTPRequest:oi,concatenateArrayBuffers:la,decodeWeights:ra,encodeWeights:sa,fromMemory:function(e,t,n,s){const r=arguments;return new ci(hi(...r))},fromMemorySync:hi,getLoadHandlers:ga,getModelArtifactsForJSON:ha,getModelArtifactsInfoForJSON:pa,getSaveHandlers:ma,http:ii,isHTTPScheme:ri,loadWeights:ti,registerLoadRouter:e=>fa.registerLoadRouter(e),registerSaveRouter:e=>fa.registerSaveRouter(e),weightsLoaderFactory:ni,withSaveHandler:function(e){return new ui(e)},withSaveHandlerSync:function(e){return new ui(e)},copyModel:async function(e,t){return Wa(e,t,!1)},listModels:async function(){const e=Pa.getSchemes(),t={};for(const n of e){const e=await Pa.getManager(n).listModels();for(const s in e){t[n+za+s]=e[s]}}return t},moveModel:async function(e,t){return Wa(e,t,!0)},removeModel:async function(e){const t=Ba(e);return Pa.getManager(t.scheme).removeModel(t.path)}});const di=Jr({matMul_:function(e,t,n=!1,s=!1){let r=Xr(e,"a","matMul"),a=Xr(t,"b","matMul");[r,a]=Er(r,a);const i={a:r,b:a},o={transposeA:n,transposeB:s};return Pr.runKernel(ye,i,o)}});const fi=Jr({oneHot_:function(e,t,n=1,s=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const r={indices:Xr(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:s};return Pr.runKernel(Zt,r,a)}});function mi(e){X().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function gi(){return Pr}function yi(){return Pr.memory()}function bi(e,t){return Pr.tidy(e,t)}function xi(e){_r(e).forEach((e=>e.dispose()))}function wi(e){return Pr.keep(e)}function vi(e){return Pr.setBackend(e)}function ki(e,t,n=1){return Pr.registerBackend(e,t,n)}function Ni(){return Pr.backend}yr=mi;const Ii=Jr({imag_:function(e){const t={input:Xr(e,"input","imag")};return Pr.runKernel(mt,t)}});const Si=Jr({neg_:function(e){const t={x:Xr(e,"x","neg")};return Pr.runKernel(Ht,t)}});const Ti=Jr({real_:function(e){const t={input:Xr(e,"input","real")};return Pr.runKernel(rn,t)}});const $i=Jr({transpose_:function(e,t,n){const s=Xr(e,"x","transpose");if(null==t&&(t=s.shape.map(((e,t)=>t)).reverse()),u(s.rank===t.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${t}.`)),t.forEach((e=>{u(e>=0&&e<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${t}`))})),s.rank<=1)return s.clone();const r={x:s},a={perm:t};return"complex64"===s.dtype?bi((()=>{let e=Ti(s),t=Ii(s);return e=Pr.runKernel(Xn,{x:e},a),t=Pr.runKernel(Xn,{x:t},a),n&&(t=Si(t)),Qr(e,t)})):Pr.runKernel(Xn,r,a)}});const Ci=Jr({confusionMatrix_:function(e,t,n){const s=Xr(e,"labels","confusionMatrix"),r=Xr(t,"predictions","confusionMatrix");u(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),u(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),u(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),u(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),u(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const a=fi(qa(s,"int32"),n),i=fi(qa(r,"int32"),n),o=$i(a),l=di(o,i);return qa(l,"int32")}});var Ei=Object.freeze({__proto__:null,confusionMatrix:Ci});function Ai(e,t){const n=e.length,s=[];for(let r=0;r<n;r++){const a=n-1-r,i=e[a]||1;(t[t.length-1-r]||1)>1&&1===i&&s.unshift(a)}return s}function Ri(e,t){const n=[];for(let s=0;s<t.length;s++){const r=e[e.length-s-1],a=t.length-s-1,i=t[a];(null==r||1===r&&i>1)&&n.unshift(a)}return n}function _i(e,t){const n=[],s=Math.max(e.length,t.length);for(let r=0;r<s;r++){let s=e[e.length-r-1];null==s&&(s=1);let a=t[t.length-r-1];if(null==a&&(a=1),1===s)n.unshift(a);else if(1===a)n.unshift(s);else{if(s!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(s)}}return n}var Fi=Object.freeze({__proto__:null,getBroadcastDims:Ai,getReductionAxes:Ri,assertAndGetBroadcastShape:_i});function Di(e,t,n){if(h(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const s=jr(e,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return ea(e,t,s,n)}let Oi;function Mi(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,a=!1,i=!1,o=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)a=!0;else if(null!=e.getContext)i=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);o=!0}if(r){const t=2;if(r&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=us(ts,Pr.backendName)){const n={pixels:e},s={numChannels:t};return Pr.runKernel(ts,n,s)}const[l,u]=r?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(i)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)c=e.data;else if(a||r||o){if(null==Oi)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Oi=new OffscreenCanvas(1,1).getContext("2d")}else Oi=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Oi.canvas.width=l,Oi.canvas.height=u,Oi.drawImage(e,0,0,l,u),c=Oi.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return Di(h,[u,l,t],"int32")}function Li(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}const zi=Jr({fromPixels_:Mi});var Pi=Object.freeze({__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(X().getBool("WRAP_TO_IMAGEBITMAP")&&Li(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return Mi(n,t)},toPixels:async function(e,t){let n=Xr(e,"img","toPixels");if(!(e instanceof br)){const e=n;n=qa(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[s,r]=n.shape.slice(0,2),a=2===n.rank?1:n.shape[2];if(a>4||2===a)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${a}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const i=await n.data(),o="float32"===n.dtype?255:1,l=new Uint8ClampedArray(r*s*4);for(let e=0;e<s*r;++e){const t=[0,0,0,255];for(let s=0;s<a;s++){const r=i[e*a+s];if("float32"===n.dtype){if(r<0||r>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${r}.`)}else if("int32"===n.dtype&&(r<0||r>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${r}.`);1===a?(t[0]=r*o,t[1]=r*o,t[2]=r*o):t[s]=r*o}const s=4*e;l[s+0]=Math.round(t[0]),l[s+1]=Math.round(t[1]),l[s+2]=Math.round(t[2]),l[s+3]=Math.round(t[3])}if(null!=t){t.width=r,t.height=s;const e=t.getContext("2d"),n=new ImageData(l,r,s);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:zi});function Bi(e,t){const n=e.shape.length,s=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(s<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${s}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[s-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[s-1]} vs. ${n}`);if(0===d(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const r=t.shape,a=r[r.length-1];let i=1;for(let e=0;e<r.length-1;++e)i*=r[e];const o=e.shape,l=r.slice();l.pop();let u=1;for(let e=a;e<n;++e)u*=o[e],l.push(o[e]);const c=[...M(e.shape).map((e=>e/u)),1].slice(0,a);return[l,i,u,c]}var Wi=Object.freeze({__proto__:null,prepareAndValidate:Bi});function Vi(e,t,n){const s=t.rank>1?t.shape[t.rank-1]:1,r=t.rank>1?t.rank-1:1,a=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(a+` update.rank < ${r}. `);if(e.length<s+(n.rank-r))throw new Error(a+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+e.length-s)throw new Error(a+" update.rank != "+(r+e.length-s));for(let e=0;e<r;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-r;++t)if(n.shape[t+r]!==e[t+s])throw new Error(a+` updates.shape[${t+r}] (${n.shape[t+r]}) != shape[${t+r}] (${e[t+r]})`)}function Ui(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}Vi(n,t,e)}function Gi(e,t,n){const s=t.shape.length,r=s>1?t.shape[s-1]:1,a=n.length;let i=1;for(let e=r;e<a;++e)i*=n[e];const o=r<1?1:r;return{sliceRank:r,numUpdates:d(t.shape)/o,sliceSize:i,strides:[...M(n.slice(0,r)),1],outputSize:d(n)}}var Hi=Object.freeze({__proto__:null,validateUpdateShape:Vi,validateInput:Ui,calculateShapes:Gi});function ji(e,t,n){const s=e.shape.length;u(s===t.length,(()=>`Error in slice${s}D: Length of begin ${t} must match the rank of the array (${s}).`)),u(s===n.length,(()=>`Error in slice${s}D: Length of size ${n} must match the rank of the array (${s}).`));for(let r=0;r<s;++r)u(t[r]+n[r]<=e.shape[r],(()=>`Error in slice${s}D: begin[${r}] + size[${r}] (${t[r]+n[r]}) would overflow input.shape[${r}] (${e.shape[r]})`))}function qi(e,t,n){const s=[];for(let r=0;r<e.length;r++)s[r]=Math.ceil((t[r]-e[r])/n[r]);return s}function Ki(e,t,n,s){const r=[...e];for(let e=r.length;e<s.length;e++)r.push(1);for(let e=0;e<n;e++)0===e?r[t]=1:(r.splice(t,0,1),r.pop());return r}function Xi(e,t,n){return n<=e?n:n-(t-1)}function Yi(e,t){const n=[];for(let s=0;s<e;s++)n.push(t+s);return n}function Zi(e,t,n,s,r){const a=[...r],i=Yi(n,t);for(let r=0;r<a.length;r++)if(i.indexOf(r)>-1)a[r]=0;else{const i=Xi(t,n,r);let o=s[i];e&1<<i&&(o=0),a[r]=o}return a}function Ji(e,t,n,s,r){const i=[...r],o=Yi(n,t);for(let r=0;r<i.length;r++)if(o.indexOf(r)>-1)i[r]=Number.MAX_SAFE_INTEGER;else{const a=Xi(t,n,r);let o=s[a];e&1<<a&&(o=Number.MAX_SAFE_INTEGER),i[r]=o}for(let e=0;e<i.length;e++){const t=r[e];i[e]<0&&(i[e]+=t),i[e]=a(0,i[e],r[e])}return i}function Qi(e,t,n){let s=e[t];return(n&1<<t||null==s)&&(s=1),s}function eo(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=a(0,o,u-1),o}function to(e,t,n,s,r,i){let o=t[r];const l=n[r]||1;(e&1<<r||i&1<<r||null==o)&&(o=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=s[r];return o<0&&(o+=u),o=l>0?a(0,o,u):a(-1,o,u-1),o}function no(e,t,n){let s=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){s=e;break}for(let r=s+1;r<n.length;r++)if(t[r]>0||n[r]!==e[r])return!1;return!0}function so(e,t){let n=e.length>0?e[e.length-1]:1;for(let s=0;s<e.length-1;s++)n+=e[s]*t[s];return n}function ro(e,t,n){let s;const r=e.shape.length;let a;return s="number"==typeof t?[t,...new Array(r-1).fill(0)]:t.length<r?t.concat(new Array(r-t.length).fill(0)):t.slice(),s.forEach((e=>{u(-1!==e,(()=>"slice() does not support negative begin indexing."))})),a=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,a=a.map(((t,n)=>t>=0?t:(u(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-s[n]))),[s,a]}function ao(e,t,n,s,r,a,i,o,l){let u;if(null==s?(u=new Array(t.length),u.fill(1)):u=s,null!=i&&0!=(i&i-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&o)&&h.numAddAxisAfterEllipsis++,1<<e&i&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const p={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let s=0;s<e.dims;s++)if(1<<s&e.ellipsisMask){const r=Math.min(t.dims-(e.dims-s)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<r;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=s}else if(1<<s&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[s]),null!=e.end&&(t.end[n]=e.end[s]),t.strides[n]=e.strides[s],e.beginMask&1<<s&&(t.beginMask|=1<<n),e.endMask&1<<s&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<s?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(s)),t.inputShapeGatherIndicesSparse[n]=s,n++}}(h,p);let d=!0,f=!0,m=!0;const g=[],y=[];for(let t=0;t<e.length;++t){if(0===p.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(p.shrinkAxisMask&1<<t),s=e[t];if(-1===s){g.push(n?1:-1);continue}const r=[p.beginMask&1<<t,p.endMask&1<<t],a=[p.strides[t]>0?0:-1,p.strides[t]>0?s:s-1];if(n&&p.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");m=m&&1===p.strides[t];const i=!!(p.beginMask&1<<t&&p.endMask&1<<t);if(p.beginValid&&p.endValid){if(n){const e=p.begin[t]<0?s+p.begin[t]:p.begin[t];if(p.begin[t]=e,p.end[t]=p.begin[t]+1,e<0||e>=s)throw Error(`slice index ${p.begin[t]} of dimension ${t} out of bounds.`)}else p.begin[t]=io(p.begin[t],0,p.strides[t],s,r,a),p.end[t]=io(p.end[t],1,p.strides[t],s,r,a);const e=1===p.strides[t]&&0===p.begin[t]&&p.end[t]===s;d=d&&e,f=f&&(0===t&&1===p.strides[t]||e)}else d=d&&1===p.strides[t]&&i,f=f&&(0===t&&1===p.strides[t]||i);let o,l=!1;if(p.beginValid&&p.endValid?(o=p.end[t]-p.begin[t],l=!0):n?(o=1,l=!0):i&&s>=0&&(o=p.strides[t]<0?-s:s,l=!0),l){let e;e=0===o||o<0!=p.strides[t]<0?0:Math.trunc(o/p.strides[t])+(o%p.strides[t]!=0?1:0),g.push(e)}else g.push(-1)}for(let e=0;e<p.finalShapeGatherIndices.length;++e){const t=p.finalShapeGatherIndices[e];t>=0?y.push(g[t]):-2===t&&y.push(1)}return{finalShapeSparse:y.filter(((e,t)=>-2!==p.finalShapeGatherIndices[t])),finalShape:y,isIdentity:d,sliceDim0:f,isSimpleSlice:m,begin:p.begin,end:p.end,strides:p.strides}}function io(e,t,n,s,r,a){if(r[t])return n>0?a[t]:a[t+1&1];{const t=e<0?s+e:e;return t<a[0]?a[0]:t>a[1]?a[1]:t}}var oo=Object.freeze({__proto__:null,assertParamsValid:ji,maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},computeOutShape:qi,stridesWithElidedDims:Ki,getNormalizedAxes:function(e,t,n,s,r,a,i,o,l){const u=e.length;let c=new Array(u),h=new Array(u),p=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=Zi(i,l,u,s,e),h=Ji(o,l,u,r,e),p=Ki(a,l,u,e)}else for(let t=0;t<u;t++)c[t]=eo(i,s,a,e,t,l),h[t]=to(o,r,a,e,t,l),p[t]=Qi(a,t,l);return{begin:c,end:h,strides:p}},startIndicesWithElidedDims:Zi,stopIndicesWithElidedDims:Ji,stridesForAxis:Qi,startForAxis:eo,stopForAxis:to,isSliceContinous:no,computeFlatOffset:so,parseSliceParams:ro,sliceInfo:ao});class lo{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class uo{constructor(){this.classNameMap={}}static getMap(){return null==uo.instance&&(uo.instance=new uo),uo.instance}static register(e){uo.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function co(e){u(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),u("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),u(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),uo.register(e)}var ho=Object.freeze({__proto__:null,Serializable:lo,SerializationMap:uo,registerClass:co});function po(){return 32===Pr.backend.floatPrecision()?.001:.1}function fo(e,t,n){let s=!0;if(($(e)||$(t))&&(s=!1),$(e)&&$(t)&&(s=!0),s){const n=e.constructor.name,s=t.constructor.name;if(n!==s)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${s}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=jr(e),s=jr(t);if(!f(n,s))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${s}]`)}const r=$(e)?e:p(e),a=$(t)?t:p(t);if(r.length!==a.length)throw new Error(`Arrays have different lengths actual: ${r.length} vs expected: ${a.length}.\nActual:   ${r}.\nExpected: ${a}.`);for(let e=0;e<a.length;++e){const t=r[e],s=a[e];if(!n(t,s))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${s}.\nActual:   ${r}.\nExpected: ${a}.`)}}function mo(e,t,n){if(null==n&&(n=po()),!go(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)}function go(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var yo=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=po()),fo(e,t,((e,t)=>go(e,t,n)))},testEpsilon:po,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return A(e)||A(e[0])||A(t)||A(t[0])?fo(e,n,((e,t)=>e==t)):fo(e,t,((e,t)=>go(e,t,0)))},expectNumbersClose:mo,expectValuesInRange:function(e,t,n){for(let s=0;s<e.length;s++)if(e[s]<t||e[s]>n)throw new Error(`Value out of range:${e[s]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),s=new Float32Array(t);if(n.length!==s.length)throw new Error(`Expected ArrayBuffer to be of length ${s.length}, but it was ${n.length}`);for(let e=0;e<s.length;e++)if(n[e]!==s[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${s[e]} but got ${n[e]} instead`)},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const s=t[n];Array.isArray(s)?e(s):t[n]=sr(s)}return t}});const bo="3.19.0";const xo=Jr({add_:function(e,t){let n=Xr(e,"a","add"),s=Xr(t,"b","add");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(ne,r)}});const wo=Jr({floorDiv_:function(e,t){let n=Xr(e,"a","floorDiv"),s=Xr(t,"b","floorDiv");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(ot,r)}});const vo=Jr({div_:function(e,t){let n=Xr(e,"a","div"),s=Xr(t,"b","div");if([n,s]=Er(n,s),"int32"===n.dtype&&"int32"===s.dtype)return wo(n,s);const r={a:n,b:s};return Pr.runKernel(Ke,r,{})}});const ko=Jr({mul_:function(e,t){let n=Xr(e,"a","mul"),s=Xr(t,"b","mul");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(Gt,r)}});const No=Jr({abs_:function(e){const t=Xr(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Pr.runKernel(Te,e)}{const e={x:t};return Pr.runKernel(Q,e)}}});const Io=Jr({acos_:function(e){const t={x:Xr(e,"x","acos")};return Pr.runKernel(ee,t)}});const So=Jr({acosh_:function(e){const t={x:Xr(e,"x","acosh")};return Pr.runKernel(te,t)}});const To=Jr({addN_:function(e){u(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),u(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Xr(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!f(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=t;return Pr.runKernel(se,s)}});const $o=Jr({all_:function(e,t=null,n=!1){const s={x:Xr(e,"x","all","bool")},r={axis:t,keepDims:n};return Pr.runKernel(re,s,r)}});const Co=Jr({any_:function(e,t=null,n=!1){const s={x:Xr(e,"x","any","bool")},r={axis:t,keepDims:n};return Pr.runKernel(ae,s,r)}});const Eo=Jr({argMax_:function(e,t=0){const n={x:Xr(e,"x","argMax")},s={axis:t};return Pr.runKernel(ie,n,s)}});const Ao=Jr({argMin_:function(e,t=0){const n={x:Xr(e,"x","argMin")},s={axis:t};return Pr.runKernel(oe,n,s)}});const Ro=Jr({asin_:function(e){const t={x:Xr(e,"x","asin")};return Pr.runKernel(le,t)}});const _o=Jr({asinh_:function(e){const t={x:Xr(e,"x","asinh")};return Pr.runKernel(ue,t)}});const Fo=Jr({atan_:function(e){const t={x:Xr(e,"x","atan")};return Pr.runKernel(ce,t)}});const Do=Jr({atan2_:function(e,t){let n=Xr(e,"a","atan2"),s=Xr(t,"b","atan2");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(pe,r)}});const Oo=Jr({atanh_:function(e){const t={x:Xr(e,"x","atanh")};return Pr.runKernel(he,t)}});function Mo(e,t,n,s,r="NHWC",a){return Po(e,[...t,e[3]],n,a,s,null,null,Ko(r))}function Lo(e,t,n,s,r,a,i="channelsLast"){const[o,l]=Vo(t);let u;if("channelsLast"===i)u=[o,l,e[3],e[3]];else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);u=[o,l,e[1],e[1]]}return Po(e,u,n,s,r,a,!1,i)}function zo(e,t,n,s,r,a,i="NDHWC"){const[o,l,u]=Uo(t);let c,h;if("NDHWC"===i)h="channelsLast",c=[o,l,u,e[4],e[4]];else{if("NCDHW"!==i)throw new Error(`Unknown dataFormat ${i}`);h="channelsFirst",c=[o,l,u,e[1],e[1]]}return Bo(e,c,n,s,r,!1,h,a)}function Po(e,t,n,s,r,a,i=!1,o="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,c,h]=e;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,h,u,c]=e}const[p,d,,f]=t,[m,g]=Vo(n),[y,b]=Vo(s),x=Go(p,y),w=Go(d,b),{padInfo:v,outHeight:k,outWidth:N}=function(e,t,n,s,r,a,i,o,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const r=function(e,t,n,s,r){null==s&&(s=Wo(e,t,n));const a=e[0],i=e[1],o=Ho((a-t+2*s)/n+1,r),l=Ho((i-t+2*s)/n+1,r);return[o,l]}([t,n],a,s,e,o);c=r[0],h=r[1]}else if("same"===e){c=Math.ceil(t/s),h=Math.ceil(n/r);const e=Math.max(0,(c-1)*s+a-t),o=Math.max(0,(h-1)*r+i-n),l=Math.floor(e/2),p=e-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-a+1)/s),h=Math.ceil((n-i+1)/r);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const p="channelsLast"===l?e[1][0]:e[2][0],d="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],m="channelsLast"===l?e[2][1]:e[3][1];u={top:p,bottom:d,left:f,right:m,type:0===p&&0===d&&0===f&&0===m?"VALID":"EXPLICIT"},c=Ho((t-a+p+d)/s+1,o),h=Ho((n-i+f+m)/r+1,o)}}return{padInfo:u,outHeight:c,outWidth:h}}(r,u,c,m,g,x,w,a,o),I=i?f*h:f;let S;return"channelsFirst"===o?S=[l,I,k,N]:"channelsLast"===o&&(S=[l,k,N,I]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:c,inChannels:h,outHeight:k,outWidth:N,outChannels:I,padInfo:v,strideHeight:m,strideWidth:g,filterHeight:p,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:w,dilationHeight:y,dilationWidth:b,inShape:e,outShape:S,filterShape:t}}function Bo(e,t,n,s,r,a=!1,i="channelsLast",o){let[l,u,c,h,p]=[-1,-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h,p]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,p,u,c,h]=e}const[d,f,m,,g]=t,[y,b,x]=Uo(n),[w,v,k]=Uo(s),N=Go(d,w),I=Go(f,v),S=Go(m,k),{padInfo:T,outDepth:$,outHeight:C,outWidth:E}=function(e,t,n,s,r,a,i,o,l,u,c){let h,p,d,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const a=function(e,t,n,s,r,a){null==r&&(r=Wo(e,t,s));const i=e[0],o=e[1],l=e[2],u=Ho((i-t+2*r)/s+1,a),c=Ho((o-t+2*r)/s+1,a),h=Ho((l-t+2*r)/s+1,a);return[u,c,h,n]}([t,n,s,1],o,1,r,e,c);p=a[0],d=a[1],f=a[2]}else if("same"===e){p=Math.ceil(t/r),d=Math.ceil(n/a),f=Math.ceil(s/i);const e=(p-1)*r+o-t,c=(d-1)*a+l-n,m=(f-1)*i+u-s,g=Math.floor(e/2),y=e-g,b=Math.floor(c/2),x=c-b,w=Math.floor(m/2);h={top:b,bottom:x,left:w,right:m-w,front:g,back:y,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},p=Math.ceil((t-o+1)/r),d=Math.ceil((n-l+1)/a),f=Math.ceil((s-u+1)/i)}return{padInfo:h,outDepth:p,outHeight:d,outWidth:f}}(r,u,c,h,y,b,x,N,I,S,o),A=a?g*p:g;let R;return"channelsFirst"===i?R=[l,A,$,C,E]:"channelsLast"===i&&(R=[l,$,C,E,A]),{batchSize:l,dataFormat:i,inDepth:u,inHeight:c,inWidth:h,inChannels:p,outDepth:$,outHeight:C,outWidth:E,outChannels:A,padInfo:T,strideDepth:y,strideHeight:b,strideWidth:x,filterDepth:d,filterHeight:f,filterWidth:m,effectiveFilterDepth:N,effectiveFilterHeight:I,effectiveFilterWidth:S,dilationDepth:w,dilationHeight:v,dilationWidth:k,inShape:e,outShape:R,filterShape:t}}function Wo(e,t,n,s=1){const r=Go(t,s);return Math.floor((e[0]*(n-1)-n+r)/2)}function Vo(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function Uo(e){return"number"==typeof e?[e,e,e]:e}function Go(e,t){return t<=1?e:e+(e-1)*(t-1)}function Ho(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function jo(e){const[t,n,s]=Vo(e);return 1===t&&1===n&&1===s}function qo(e,t){return jo(e)||jo(t)}function Ko(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function Xo(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)u(m(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{u(m(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const Yo=Jr({reshape_:function(e,t){const n={x:Xr(e,"x","reshape","string_or_numeric")},s={shape:t};return Pr.runKernel(ln,n,s)}});const Zo=Jr({avgPool_:function(e,t,n,s,r){const a=Xr(e,"x","avgPool","float32");u(qo(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let i=a,o=!1;3===a.rank&&(o=!0,i=Yo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===i.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`)),Xo("avgPool",s,r);const l={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r};let h=Pr.runKernel(de,l,c);return h=qa(h,a.dtype),o?Yo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Jo=Jr({avgPool3d_:function(e,t,n,s,r,a="NDHWC"){const i=Xr(e,"x","avgPool3d","float32");let o=i,l=!1;4===i.rank&&(l=!0,o=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),u("NDHWC"===a,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),Xo("avgPool3d",s,r);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a};let p=Pr.runKernel(me,c,h);return p=qa(p,o.dtype),l?Yo(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Qo=Jr({concat_:function(e,t=0){u(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=Yr(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return Ka(n[0]);const s=n,r={axis:t};return Pr.runKernel($e,s,r)}});const el=Jr({sigmoid_:function(e){const t={x:Xr(e,"x","sigmoid","float32")};return Pr.runKernel(Sn,t)}});const tl=Jr({slice_:function(e,t,n){const s=Xr(e,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},a={begin:t,size:n};return Pr.runKernel(vn,r,a)}});const nl=Jr({tanh_:function(e){const t={x:Xr(e,"x","tanh","float32")};return Pr.runKernel(Hn,t)}});const sl=Jr({basicLSTMCell_:function(e,t,n,s,r,a){const i=Xr(e,"forgetBias","basicLSTMCell"),o=Xr(t,"lstmKernel","basicLSTMCell"),l=Xr(n,"lstmBias","basicLSTMCell"),u=Xr(s,"data","basicLSTMCell"),c=Xr(r,"c","basicLSTMCell"),h=Xr(a,"h","basicLSTMCell"),p=Qo([u,h],1),d=di(p,o),f=xo(d,l),m=f.shape[0],g=f.shape[1]/4,y=[m,g],b=tl(f,[0,0],y),x=tl(f,[0,g],y),w=tl(f,[0,2*g],y),v=tl(f,[0,3*g],y),k=xo(ko(el(b),nl(x)),ko(c,el(xo(i,w))));return[k,ko(nl(k),el(v))]}});const rl=Jr({batchToSpaceND_:function(e,t,n){const s=Xr(e,"x","batchToSpaceND"),r=t.reduce(((e,t)=>e*t));u(s.rank>=1+t.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${t.length}`)),u(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),u(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${r}`));const a={x:s},i={blockShape:t,crops:n};return Pr.runKernel(be,a,i)}});const al=Jr({batchNorm_:function(e,t,n,s,r,a){null==a&&(a=.001);const i=Xr(e,"x","batchNorm"),o=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;null!=r&&(c=Xr(r,"scale","batchNorm")),null!=s&&(h=Xr(s,"offset","batchNorm")),u(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==c||o.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const p=function(e){let t;return t=0===e.rank||1===e.rank?Yo(e,[1,1,1,e.size]):2===e.rank?Yo(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Yo(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),d={x:p,scale:c,offset:h,mean:o,variance:l},f={varianceEpsilon:a},m=Pr.runKernel(lt,d,f);return Yo(m,i.shape)}});const il=Jr({batchNorm2d_:function(e,t,n,s,r,a){const i=Xr(e,"x","batchNorm"),o=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=r&&(c=Xr(r,"scale","batchNorm")),null!=s&&(h=Xr(s,"offset","batchNorm")),u(2===i.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`)),u(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),u(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),al(i,o,l,h,c,a)}});const ol=Jr({batchNorm3d_:function(e,t,n,s,r,a){const i=Xr(e,"x","batchNorm"),o=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=r&&(c=Xr(r,"scale","batchNorm")),null!=s&&(h=Xr(s,"offset","batchNorm")),u(3===i.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`)),u(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),u(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),al(i,o,l,h,c,a)}});const ll=Jr({batchNorm4d_:function(e,t,n,s,r,a){const i=Xr(e,"x","batchNorm"),o=Xr(t,"mean","batchNorm"),l=Xr(n,"variance","batchNorm");let c,h;return null!=r&&(c=Xr(r,"scale","batchNorm")),null!=s&&(h=Xr(s,"offset","batchNorm")),u(4===i.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`)),u(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),u(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=c&&u(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&u(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),al(i,o,l,h,c,a)}});const ul=Jr({bincount_:function(e,t,n){const s=Xr(e,"x","bincount"),r=Xr(t,"weights","bincount");u("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const a={x:s,weights:r},i={size:n};return Pr.runKernel(xe,a,i)}});const cl=Jr({broadcastArgs_:function(e,t){const n=Xr(e,"s0","broadcastArgs","int32"),s=Xr(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return Pr.runKernel(ve,r)}});const hl=Jr({broadcastTo_:function(e,t){let n=Xr(e,"broadcastTo","x");const s=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Yo(n,e)}const r=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(r[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${t}].`);if(0===a.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return Ka(n);const i={x:n},o={reps:a};return Pr.runKernel(jn,i,o)}});const pl=Jr({ceil_:function(e){const t={x:Xr(e,"x","ceil","float32")};return Pr.runKernel(Ne,t)}});const dl=Jr({clipByValue_:function(e,t,n){const s=Xr(e,"x","clipByValue");u(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const r={x:s},a={clipValueMin:t,clipValueMax:n};return Pr.runKernel(Ie,r,a)}});const fl=Jr({concat1d_:function(e){return Qo(e,0)}});const ml=Jr({concat2d_:function(e,t){return Qo(e,t)}});const gl=Jr({concat3d_:function(e,t){return Qo(e,t)}});const yl=Jr({concat4d_:function(e,t){return Qo(e,t)}});const bl=Jr({conv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=Xr(e,"x","conv2d","float32"),l=Xr(t,"filter","conv2d","float32");let c=o,h=!1;3===o.rank&&(h=!0,c=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),Xo("conv2d",s,i);const p="NHWC"===r?c.shape[3]:c.shape[1];u(p===l.shape[2],(()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${l.shape[2]}.`)),u(qo(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const d={x:c,filter:l},f={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Pr.runKernel(Ce,d,f);return h?Yo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const xl=Jr({conv1d_:function(e,t,n,s,r="NWC",a=1,i){const o=Xr(e,"x","conv1d"),l=Xr(t,"filter","conv1d");let c=o,h=!1;2===o.rank&&(h=!0,c=Yo(o,[1,o.shape[0],o.shape[1]])),u(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),u(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),Xo("conv1d",s,i),u(c.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),u(qo(n,a),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`)),u("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const p=Yo(l,[1,l.shape[0],l.shape[1],l.shape[2]]),d=Yo(c,[c.shape[0],1,c.shape[1],c.shape[2]]),f=bl(d,p,[1,n],s,"NHWC",[1,a],i);return Yo(f,h?[f.shape[2],f.shape[3]]:[f.shape[0],f.shape[2],f.shape[3]])}});const wl=Jr({conv2DBackpropInput_:function(e,t,n,s,r,a="NHWC",i){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,l=t,c=!1;3===t.rank&&(c=!0,l=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2]]),o=[1,e[0],e[1],e[2]]),u(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),u(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),u(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===a?o[3]:o[1],p="NHWC"===a?l.shape[3]:l.shape[1];u(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),u(p===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`)),Xo("conv2dDerInput",r,i);const d={dy:l,filter:n},f={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,inputShape:o},m=Pr.runKernel(Ae,d,f);return c?Yo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const vl=Jr({conv2dTranspose_:function(e,t,n,s,r,a){const i=Xr(e,"x","conv2dTranspose"),o=Xr(t,"filter","conv2dTranspose");return wl(n,i,o,s,r,"NHWC",a)}});const kl=Jr({conv3d_:function(e,t,n,s,r="NDHWC",a=[1,1,1]){const i=Xr(e,"x","conv3d"),o=Xr(t,"filter","conv3d");let l=i,c=!1;4===i.rank&&(c=!0,l=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),u(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),u(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),u(qo(n,a),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),u("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:l,filter:o},p={strides:n,pad:s,dataFormat:r,dilations:a},d=Pr.runKernel(Re,h,p);return c?Yo(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Nl=Jr({conv3DBackpropInput_:function(e,t,n,s,r){u(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let a=e,i=t,o=!1;4===t.rank&&(o=!0,i=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const l=a[4],c=i.shape[4];u(5===a.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`)),u(5===i.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`)),u(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),u(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),u(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:i,filter:n},p={pad:r,strides:s,inputShape:a},d=Pr.runKernel(Fe,h,p);return o?Yo(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Il=Jr({conv3dTranspose_:function(e,t,n,s,r){const a=Xr(e,"x","conv3dTranspose"),i=Xr(t,"filter","conv3dTranspose");return Nl(n,a,i,s,r)}});const Sl=Jr({cos_:function(e){const t={x:Xr(e,"x","cos","float32")};return Pr.runKernel(De,t)}});const Tl=Jr({cosh_:function(e){const t={x:Xr(e,"x","cosh","float32")};return Pr.runKernel(Oe,t)}});const $l=Jr({cumprod_:function(e,t=0,n=!1,s=!1){const r={x:Xr(e,"x","cumprod")},a={axis:t,exclusive:n,reverse:s};return Pr.runKernel(Me,r,a)}});const Cl=Jr({cumsum_:function(e,t=0,n=!1,s=!1){const r={x:Xr(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:s};return Pr.runKernel(Le,r,a)}});const El=Jr({denseBincount_:function(e,t,n,s=!1){const r=Xr(e,"x","denseBincount"),a=Xr(t,"weights","denseBincount");u("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),u(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),u(n>=0,(()=>`size must be non-negative, but got ${n}.`)),u(a.size===r.size||0===a.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${a.shape}.`));const i={x:r,weights:a},o={size:n,binaryOutput:s};return Pr.runKernel(Pe,i,o)}});const Al=Jr({depthToSpace_:function(e,t,n="NHWC"){const s=Xr(e,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],a="NHWC"===n?s.shape[2]:s.shape[3],i="NHWC"===n?s.shape[3]:s.shape[1];u(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),u(r*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${t}  for depthToSpace with input shape\n    ${s.shape}`)),u(a*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${s.shape}`)),u(i%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:t,dataFormat:n};return Pr.runKernel(Be,o,l)}});const Rl=Jr({depthwiseConv2d_:function(e,t,n,s,r="NHWC",a=[1,1],i){const o=Xr(e,"x","depthwiseConv2d","float32"),l=Xr(t,"filter","depthwiseConv2d","float32");let c=o,h=!1;3===o.rank&&(h=!0,c=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),u(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const p="NHWC"===r?c.shape[3]:c.shape[1];u(p===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${p}) must match the inChannels dimension in filter ${l.shape[2]}.`)),Xo("depthwiseConv2d",s,i);const d={x:c,filter:l},f={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i},m=Pr.runKernel(We,d,f);return h?Yo(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const _l=Jr({diag_:function(e){const t={x:Xr(e,"x","diag")};return Pr.runKernel(Ge,t)}});const Fl=Jr({dilation2d_:function(e,t,n,s,r=[1,1],a="NHWC"){const i=Xr(e,"x","dilation2d"),o=Xr(t,"filter","dilation2d");u(3===i.rank||4===i.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`)),u(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),u("NHWC"===a,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`));let l=i,c=!1;3===i.rank&&(l=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:l,filter:o},p={strides:n,pad:s,dilations:r},d=Pr.runKernel(He,h,p);return c?Yo(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});const Dl=Jr({equal_:function(e,t){let n=Xr(e,"a","equal","string_or_numeric"),s=Xr(t,"b","equal","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(Qe,r)}});const Ol=Jr({where_:function(e,t,n){const s=Xr(t,"a","where"),r=Xr(n,"b","where"),a=Xr(e,"condition","where","bool"),i=_i(_i(a.shape,s.shape),r.shape),o={condition:hl(a,i),t:hl(s,i),e:hl(r,i)};return Pr.runKernel(xn,o)}});const Ml=Jr({zerosLike_:function(e){const t={x:Xr(e,"x","zerosLike")};return Pr.runKernel(Qn,t)}});const Ll=Jr({divNoNan_:function(e,t){let n=Xr(e,"a","div"),s=Xr(t,"b","div");[n,s]=Er(n,s);const r=vo(n,s),a=Ml(r),i=Dl(s,a);return Ol(i,a,r)}});const zl=Jr({dot_:function(e,t){const n=Xr(e,"t1","dot"),s=Xr(t,"t2","dot");u(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],a=1===s.rank?s.size:s.shape[0];if(u(r===a,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${a}.`)),1===n.rank&&1===s.rank){const e=Yo(n,[1,-1]),t=Yo(s,[-1,1]),r=di(e,t);return Yo(r,[])}if(1===n.rank&&2===s.rank){const e=Yo(n,[1,-1]),t=Yo(s,[s.shape[0],s.shape[1]]),r=di(e,t);return Yo(r,[r.size])}if(2===n.rank&&1===s.rank){const e=Yo(s,[-1,1]),t=di(n,e);return Yo(t,[t.size])}{const e=Yo(s,[s.shape[0],s.shape[1]]);return di(n,e)}}});const Pl=Jr({einsum_:function(e,...t){const n=t.map(((e,t)=>Xr(e,`tensors${t}`,"einsum"))),s={equation:e};return Pr.runKernel(Xe,n,s)}});const Bl=Jr({elu_:function(e){const t={x:Xr(e,"x","elu","float32")};return Pr.runKernel(Ye,t)}});const Wl=Jr({erf_:function(e){let t=Xr(e,"x","erf");u("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=qa(t,"float32"));const n={x:t};return Pr.runKernel(Je,n)}});function Vl(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function Ul(e,t,n){const s=e.length+t.length,r=[];let a=0,i=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(e[a++]):r.push(t[i++]);return r}function Gl(e,t){const n=[],s=e.length;for(let r=0;r<s;r++)-1===t.indexOf(r)&&n.push(e[r]);return[n,t.map((t=>e[t]))]}function Hl(e,t){return Ul(e,t.map((e=>1)),t)}function jl(e,t,n){u(Vl(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))}function ql(e,t){if(Vl(e,t))return null;const n=[];for(let s=0;s<t;++s)-1===e.indexOf(s)&&n.push(s);return e.forEach((e=>n.push(e))),n}function Kl(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))}function Xl(e,t){const n=[];for(let s=t-e;s<t;++s)n.push(s);return n}const Yl=Jr({max_:function(e,t=null,n=!1){const s={x:Xr(e,"x","max")},r={reductionIndices:t,keepDims:n};return Pr.runKernel(Rt,s,r)}});const Zl=Jr({min_:function(e,t=null,n=!1){const s={x:Xr(e,"x","min")},r={axis:t,keepDims:n};return Pr.runKernel(Pt,s,r)}});const Jl=Jr({pow_:function(e,t){let n=Xr(e,"base","pow"),s=Xr(t,"exp","pow");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(en,r)}});function Ql(e,t){if(($(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&$(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return ea(e,[],[],t)}const eu=Jr({sqrt_:function(e){const t={x:Xr(e,"x","sqrt","float32")};return Pr.runKernel($n,t)}});const tu=Jr({square_:function(e){const t=Xr(e,"x","square");return Pr.runKernel("Square",{x:t},{})}});const nu=Jr({sum_:function(e,t=null,n=!1){let s=Xr(e,"x","sum");"bool"===s.dtype&&(s=qa(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Pr.runKernel(Cn,r,a)}});function su(e,t,n=null){if(0===e.rank)return No(e);if(1!==e.rank&&null===n)return su(Yo(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return nu(No(e),n);if(t===1/0)return Yl(No(e),n);if(t===-1/0)return Zl(No(e),n);if("euclidean"===t||2===t)return eu(nu(Jl(No(e),Ql(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return Yl(nu(No(e),n[0]),n[1]-1);if(t===1/0)return Yl(nu(No(e),n[1]),n[0]);if(t===-1/0)return Zl(nu(No(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return eu(nu(tu(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const ru=Jr({norm_:function(e,t="euclidean",n=null,s=!1){const r=su(e=Xr(e,"x","norm"),t,n);let a=r.shape;if(s){const t=w(n,e.shape);a=Hl(r.shape,t)}return Yo(r,a)}});const au=Jr({euclideanNorm_:function(e,t=null,n=!1){return ru(e,"euclidean",t,n)}});const iu=Jr({exp_:function(e){const t={x:Xr(e,"x","exp")};return Pr.runKernel(et,t)}});const ou=Jr({expandDims_:function(e,t=0){const n=Xr(e,"x","expandDims","string_or_numeric");u(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:t};return Pr.runKernel(tt,s,r)}});const lu=Jr({expm1_:function(e){const t={x:Xr(e,"x","expm1")};return Pr.runKernel(nt,t)}});const uu=Jr({tile_:function(e,t){const n=Xr(e,"x","tile","string_or_numeric");u(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const s={x:n},r={reps:t};return Pr.runKernel(jn,s,r)}});const cu=Jr({eye_:function(e,t,n,s="float32"){null==t&&(t=e);const r=ja([e,t],s),a=e<=t?e:t;for(let e=0;e<a;++e)r.set(1,e,e);const i=Yo(r.toTensor(),[e,t]);if(null==n)return i;if(1===n.length)return uu(ou(i,0),[n[0],1,1]);if(2===n.length)return uu(ou(ou(i,0),0),[n[0],n[1],1,1]);if(3===n.length)return uu(ou(ou(ou(i,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function hu(e,t,n){const s={shape:e,value:t,dtype:n};return Pr.runKernel(rt,{},s)}const pu=Jr({floor_:function(e){const t={x:Xr(e,"x","floor","float32")};return Pr.runKernel(it,t)}});const du=Jr({gather_:function(e,t,n=0,s=0){const r={x:Xr(e,"x","gather"),indices:Xr(t,"indices","gather","int32")},a={axis:n,batchDims:s};return Pr.runKernel(ut,r,a)}});const fu=Jr({greater_:function(e,t){let n=Xr(e,"a","greater","string_or_numeric"),s=Xr(t,"b","greater","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(ht,r)}});const mu=Jr({greaterEqual_:function(e,t){let n=Xr(e,"a","greaterEqual","string_or_numeric"),s=Xr(t,"b","greaterEqual","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(pt,r)}});const gu=Jr({isFinite_:function(e){const t={x:Xr(e,"x","isFinite")};return Pr.runKernel(gt,t)}});const yu=Jr({isInf_:function(e){const t={x:Xr(e,"x","isInf")};return Pr.runKernel(yt,t)}});const bu=Jr({isNaN_:function(e){const t={x:Xr(e,"x","isNaN")};return Pr.runKernel(bt,t)}});const xu=Jr({leakyRelu_:function(e,t=.2){const n={x:Xr(e,"x","leakyRelu")},s={alpha:t};return Pr.runKernel(xt,n,s)}});const wu=Jr({less_:function(e,t){let n=Xr(e,"a","less","string_or_numeric"),s=Xr(t,"b","less","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(wt,r)}});const vu=Jr({lessEqual_:function(e,t){let n=Xr(e,"a","lessEqual","string_or_numeric"),s=Xr(t,"b","lessEqual","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(vt,r)}});function ku(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const s={start:e,stop:t,num:n};return Pr.runKernel(kt,{},s)}const Nu=Jr({localResponseNormalization_:function(e,t=5,n=1,s=1,r=.5){const a=Xr(e,"x","localResponseNormalization");u(4===a.rank||3===a.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`)),u(m(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let i=a,o=!1;3===a.rank&&(o=!0,i=Yo(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const l={x:i},c={depthRadius:t,bias:n,alpha:s,beta:r},h=Pr.runKernel(Et,l,c);return o?Yo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Iu=Jr({log_:function(e){const t={x:Xr(e,"x","log","float32")};return Pr.runKernel(Nt,t)}});const Su=Jr({log1p_:function(e){const t={x:Xr(e,"x","log1p")};return Pr.runKernel(It,t)}});function Tu(e,t){u(D(e),(()=>"The f passed in variableGrads(f) must be a function")),u(null==t||Array.isArray(t)&&t.every((e=>e instanceof wr)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in Pr.registeredVariables)t.push(Pr.registeredVariables[e])}const s=n?t.filter((e=>!e.trainable)):null,r=t.length;t=t.filter((e=>e.trainable)),u(t.length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:a,grads:i}=Pr.gradients(e,t,null,!0);u(i.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),u(0===a.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`));const o={};return t.forEach(((e,t)=>{null!=i[t]&&(o[e.name]=i[t])})),null!=s&&s.forEach((e=>o[e.name]=null)),{value:a,grads:o}}function $u(e){return Pr.customGrad(e)}function Cu(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const Eu=Jr({softplus_:function(e){const t={x:Xr(e,"x","softplus")};return Pr.runKernel(Tn,t)}});const Au=Jr({logSigmoid_:function(e){const t=Xr(e,"x","logSigmoid"),n=$u((e=>({value:Si(Eu(Si(e))),gradFunc:t=>ko(t,el(Si(e)))})));return n(t)}});const Ru=Jr({sub_:function(e,t){let n=Xr(e,"a","sub"),s=Xr(t,"b","sub");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(Un,r)}});const _u=Jr({logSoftmax_:function(e,t=-1){const n=Xr(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const s=$u(((e,n)=>{const s=Yl(e,t,!0),r=Ru(e,s),a=Ru(qa(r,"float32"),Iu(nu(iu(r),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[s]=n,r=iu(s);return Ru(e,ko(nu(e,t,!0),r))}}}));return s(n)}});const Fu=Jr({logSumExp_:function(e,t=null,n=!1){const s=Xr(e,"x","logSumExp"),r=w(t,s.shape),a=Yl(s,r,!0),i=Ru(s,a),o=iu(i),l=nu(o,r),u=Iu(l),c=xo(Yo(a,u.shape),u);if(n){const e=Hl(c.shape,r);return Yo(c,e)}return c}});const Du=Jr({logicalAnd_:function(e,t){const n=Xr(e,"a","logicalAnd","bool"),s=Xr(t,"b","logicalAnd","bool");_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(St,r)}});const Ou=Jr({logicalNot_:function(e){const t={x:Xr(e,"x","logicalNot","bool")};return Pr.runKernel(Tt,t)}});const Mu=Jr({logicalOr_:function(e,t){const n=Xr(e,"a","logicalOr","bool"),s=Xr(t,"b","logicalOr","bool");_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel($t,r)}});const Lu=Jr({logicalXor_:function(e,t){const n=Xr(e,"a","logicalXor","bool"),s=Xr(t,"b","logicalXor","bool");return _i(n.shape,s.shape),Du(Mu(e,t),Ou(Du(e,t)))}}),zu=2147483648;const Pu=Jr({searchSorted_:function(e,t,n="left"){const s=Xr(e,"sortedSequence","searchSorted"),r=Xr(t,"values","searchSorted"),a=s.shape[s.shape.length-1],i=r.shape[r.shape.length-1],o=Yo(s,[-1,a]),l=Yo(r,[-1,i]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(d(l.shape)>=zu)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=zu)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},c={side:n};return Pr.runKernel(bn,u,c)}});function Bu(e,t){return Pu(e,t,"left")}const Wu=Jr({maxPool_:function(e,t,n,s,r){const a=Xr(e,"x","maxPool");let i=a,o=!1;3===a.rank&&(o=!0,i=Yo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===i.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`)),u(qo(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Xo("maxPool",s,r);const l={x:i},c={filterSize:t,strides:n,pad:s,dimRoundingMode:r},h=Pr.runKernel(Ft,l,c);return o?Yo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Vu=Jr({maxPool3d_:function(e,t=[1,1,1],n,s,r,a="NDHWC"){const i=Xr(e,"x","maxPool3d");let o=i,l=!1;4===i.rank&&(l=!0,o=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),u(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),u("NDHWC"===a,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),Xo("maxPool3d",s,r);const c={x:o},h={filterSize:t,strides:n,pad:s,dimRoundingMode:r,dataFormat:a},p=Pr.runKernel(Ot,c,h);return l?Yo(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const Uu=Jr({maxPoolWithArgmax_:function(e,t,n,s,r=!1){const a={x:Xr(e,"x","maxPoolWithArgmax")},i={filterSize:t,strides:n,pad:s,includeBatchInIndex:r},o=Pr.runKernel(Lt,a,i);return{result:o[0],indexes:o[1]}}});const Gu=Jr({maximum_:function(e,t){let n=Xr(e,"a","maximum"),s=Xr(t,"b","maximum");[n,s]=Er(n,s),"bool"===n.dtype&&(n=qa(n,"int32"),s=qa(s,"int32")),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(_t,r)}});const Hu=Jr({mean_:function(e,t=null,n=!1){const s={x:Xr(e,"x","mean")},r={axis:t,keepDims:n};return Pr.runKernel(zt,s,r)}});function ju(e,t="float32"){if("complex64"===t){const t=ju(e,"float32"),n=ju(e,"float32");return Qr(t,n)}const n=B(d(e),t);return Pr.makeTensor(n,e,t)}function qu(e,t="float32"){if("complex64"===t){const t=qu(e,"float32"),n=ju(e,"float32");return Qr(t,n)}const n=P(d(e),t);return Pr.makeTensor(n,e,t)}function Ku(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let s=Xr(e,"x","meshgrid",e instanceof br?e.dtype:"float32");if(void 0===t)return[s];let r=Xr(t,"y","meshgrid",t instanceof br?t.dtype:"float32");const a=d(s.shape),i=d(r.shape);return"xy"===n?(s=Yo(s,[1,-1]),r=Yo(r,[-1,1]),[di(qu([i,1],s.dtype),s),di(r,qu([1,a],r.dtype))]):(s=Yo(s,[-1,1]),r=Yo(r,[1,-1]),[di(s,qu([1,i],s.dtype)),di(qu([a,1],r.dtype),r)])}const Xu=Jr({minimum_:function(e,t){let n=Xr(e,"a","minimum"),s=Xr(t,"b","minimum");[n,s]=Er(n,s),"bool"===n.dtype&&(n=qa(n,"int32"),s=qa(s,"int32")),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(Bt,r)}});const Yu=Jr({mirrorPad_:function(e,t,n){u("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=Xr(e,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");u(t.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${t.length}.`));const r="reflect"===n?1:0;for(let e=0;e<s.rank;e++)u(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),u(t[e][0]>=0&&t[e][0]<=s.shape[e]-r&&t[e][1]>=0&&t[e][1]<=s.shape[e]-r,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${s.shape[e]-r} or less than 0 for input of shape ${s.shape}`));const a={paddings:t,mode:n},i={x:s};return Pr.runKernel(Wt,i,a)}});const Zu=Jr({mod_:function(e,t){let n=Xr(e,"a","mod"),s=Xr(t,"b","mod");[n,s]=Er(n,s);const r={a:n,b:s};return Pr.runKernel(Vt,r)}});const Ju=Jr({moments_:function(e,t=null,n=!1){const s=w(t,(e=Xr(e,"x","moments")).shape),r=Hu(e,s,n);let a=r.shape;n||(a=Hl(r.shape,s));const i=tu(Ru(qa(e,"float32"),Yo(r,a)));return{mean:r,variance:Hu(i,s,n)}}});const Qu=Jr({multiRNNCell_:function(e,t,n,s){const r=Xr(t,"data","multiRNNCell"),a=Yr(n,"c","multiRNNCell"),i=Yr(s,"h","multiRNNCell");let o=r;const l=[];for(let t=0;t<e.length;t++){const n=e[t](o,a[t],i[t]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const ec=Jr({multinomial_:function(e,t,n,s=!1){const r=Xr(e,"logits","multinomial"),a=r.size,i=r.rank;if(a<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);if(i>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${i}`);n=n||Math.random();const o={logits:1===i?Yo(r,[1,-1]):r},l={numSamples:t,seed:n,normalized:s},u=Pr.runKernel(Ut,o,l);return 1===i?Yo(u,[u.size]):u}});const tc=Jr({notEqual_:function(e,t){let n=Xr(e,"a","notEqual","string_or_numeric"),s=Xr(t,"b","notEqual","string_or_numeric");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(jt,r)}});const nc=Jr({onesLike_:function(e){const t={x:Xr(e,"x","onesLike")};return Pr.runKernel(Yt,t)}});const sc=Jr({outerProduct_:function(e,t){const n=Xr(e,"v1","outerProduct"),s=Xr(t,"v2","outerProduct");u(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=Yo(n,[-1,1]),a=Yo(s,[1,-1]);return di(r,a)}});const rc=Jr({pad_:function(e,t,n=0){const s=Xr(e,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:t,constantValue:n},a={x:s};return Pr.runKernel(Qt,a,r)}});const ac=Jr({pad1d_:function(e,t,n=0){return u(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),rc(e,[t],n)}});const ic=Jr({pad2d_:function(e,t,n=0){return u(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),rc(e,t,n)}});const oc=Jr({pad3d_:function(e,t,n=0){return u(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),rc(e,t,n)}});const lc=Jr({pad4d_:function(e,t,n=0){return u(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),rc(e,t,n)}});const uc=Jr({spaceToBatchND_:function(e,t,n){const s=Xr(e,"x","spaceToBatchND");u(s.rank>=1+t.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${t.length}`)),u(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),u(s.shape.reduce(((e,s,r)=>r>0&&r<=t.length?e&&(s+n[r-1][0]+n[r-1][1])%t[r-1]==0:e),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const r={x:s},a={blockShape:t,paddings:n};return Pr.runKernel(En,r,a)}});const cc=Jr({pool_:function(e,t,n,s,r,a,i){null==r&&(r=[1,1]),null==a&&(a=1),0===s&&(s="valid");const o=Xr(e,"x","maxPool");let l=o,c=!1;3===o.rank&&(c=!0,l=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),u(qo(a,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${r}'`));const h=Lo(l.shape,t,a,r,s),p=[h.dilationHeight,h.dilationWidth];let d;d="same"===s?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),s=n.map((e=>Math.floor(e/2))),r=n.map(((e,t)=>e-s[t]));return n.map(((e,t)=>[s[t],r[t]]))}([h.filterHeight,h.filterWidth],p):[[0,0],[0,0]];const f=1===p[0]&&1===p[1],[m,g]=function(e,t,n){const s=n.map((e=>e[0])),r=n.map((e=>e[1])),a=e.concat(s,r),i=t.map(((e,t)=>(e-a[t]%e)%e)),o=r.map(((e,t)=>e+i[t])),l=t.map(((e,t)=>[s[t],o[t]])),u=t.map(((e,t)=>[0,i[t]]));return[l,u]}([h.inHeight,h.inWidth],p,d),y=f?s:"valid",b=f?l:uc(l,p,m),x=("avg"===n?()=>Zo(b,t,a,y,i):()=>Wu(b,t,a,y,i))(),w=f?x:rl(x,p,g);return c?Yo(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const hc=Jr({prelu_:function(e,t){const n={x:Xr(e,"x","prelu"),alpha:Xr(t,"alpha","prelu")};return Pr.runKernel(tn,n)}});const pc=Jr({prod_:function(e,t=null,n=!1){let s=Xr(e,"x","prod");"bool"===s.dtype&&(s=qa(s,"int32"));const r={x:s},a={axis:t,keepDims:n};return Pr.runKernel(nn,r,a)}});const dc=Jr({rand_:function(e,t,n){const s=d(e);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let e=0;e<s;e++)r[e]=t();return Pr.makeTensor(r,e,n)}});var fc="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function mc(e,t){return e(t={exports:{}},t.exports),t.exports}var gc=mc((function(e){!function(e,t,n){function s(e){var t,n=this,s=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var s=.02519603282416938*(t+=e.charCodeAt(n));s-=t=s>>>0,t=(s*=t)>>>0,t+=4294967296*(s-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(e),n.s0<0&&(n.s0+=1),n.s1-=s(e),n.s1<0&&(n.s1+=1),n.s2-=s(e),n.s2<0&&(n.s2+=1),s=null}function r(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new s(e),a=t&&t.state,i=n.next;return i.int32=function(){return 4294967296*n.next()|0},i.double=function(){return i()+11102230246251565e-32*(2097152*i()|0)},i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),yc=mc((function(e){!function(e,t,n){function s(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),bc=mc((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var s=0;s<n.length+64;s++)t.x^=0|n.charCodeAt(s),s==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function r(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),xc=mc((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.x,r=t.i;return e=s[r],n=(e^=e>>>7)^e<<24,n^=(e=s[r+1&7])^e>>>10,n^=(e=s[r+3&7])^e>>>3,n^=(e=s[r+4&7])^e<<7,e=s[r+7&7],n^=(e^=e<<13)^e<<9,s[r]=n,t.i=r+1&7,n},function(e,t){var n,s=[];if(t===(0|t))s[0]=t;else for(t=""+t,n=0;n<t.length;++n)s[7&n]=s[7&n]<<15^t.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n?s[7]=-1:s[n],e.x=s,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function r(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.x&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),wc=mc((function(e){!function(e,t,n){function s(e){var t=this;t.next=function(){var e,n,s=t.w,r=t.X,a=t.i;return t.w=s=s+1640531527|0,n=r[a+34&127],e=r[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=r[a]=n^e,t.i=a,n+(s^s>>>16)|0},function(e,t){var n,s,r,a,i,o=[],l=128;for(t===(0|t)?(s=t,t=null):(t+="\0",s=0,l=Math.max(l,t.length)),r=0,a=-32;a<l;++a)t&&(s^=t.charCodeAt((a+32)%t.length)),0===a&&(i=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,a>=0&&(i=i+1640531527|0,r=0==(n=o[127&a]^=s+i)?r+1:0);for(r>=128&&(o[127&(t&&t.length||0)]=-1),r=127,a=512;a>0;--a)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;e.w=i,e.X=o,e.i=r}(t,e)}function r(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&(a.X&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),vc=mc((function(e){!function(e,t,n){function s(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,s=t.d,r=t.a;return e=e<<25^e>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-s|0,t.d=s<<16^n>>>16^r,t.a=r-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var s=0;s<n.length+20;s++)t.b^=0|n.charCodeAt(s),t.next()}function r(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new s(e),a=t&&t.state,i=function(){return(n.next()>>>0)/4294967296};return i.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},i.int32=n.next,i.quick=i,a&&("object"==typeof a&&r(a,n),i.state=function(){return r(n,{})}),i}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),kc=mc((function(e){!function(t,n,s){var r,a=256,i=s.pow(a,6),o=s.pow(2,52),l=2*o,u=255;function c(e,u,c){var g=[],y=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[e,m(n)]:null==e?function(){try{var e;return r&&(e=r.randomBytes)?e=e(a):(e=new Uint8Array(a),(t.crypto||t.msCrypto).getRandomValues(e)),m(e)}catch(e){var s=t.navigator,i=s&&s.plugins;return[+new Date,t,i,t.screen,m(n)]}}():e,3),g),b=new h(g),x=function(){for(var e=b.g(6),t=i,n=0;e<o;)e=(e+n)*a,t*=a,n=b.g(1);for(;e>=l;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|b.g(4)},x.quick=function(){return b.g(4)/4294967296},x.double=x,f(m(b.S),n),(u.pass||c||function(e,t,n,r){return r&&(r.S&&p(r,b),e.state=function(){return p(b,{})}),n?(s.random=e,t):e})(x,y,"global"in u?u.global:this==s,u.state)}function h(e){var t,n=e.length,s=this,r=0,i=s.i=s.j=0,o=s.S=[];for(n||(e=[n++]);r<a;)o[r]=r++;for(r=0;r<a;r++)o[r]=o[i=u&i+e[r%n]+(t=o[r])],o[i]=t;(s.g=function(e){for(var t,n=0,r=s.i,i=s.j,o=s.S;e--;)t=o[r=u&r+1],n=n*a+o[u&(o[r]=o[i=u&i+t])+(o[i]=t)];return s.i=r,s.j=i,n})(a)}function p(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function d(e,t){var n,s=[],r=typeof e;if(t&&"object"==r)for(n in e)try{s.push(d(e[n],t-1))}catch(e){}return s.length?s:"string"==r?e:e+"\0"}function f(e,t){for(var n,s=e+"",r=0;r<s.length;)t[u&r]=u&(n^=19*t[u&r])+s.charCodeAt(r++);return m(t)}function m(e){return String.fromCharCode.apply(0,e)}if(f(s.random(),n),e.exports){e.exports=c;try{r=require("crypto")}catch(e){}}else s.seedrandom=c}("undefined"!=typeof self?self:fc,[],Math)}));kc.alea=gc,kc.xor128=yc,kc.xorwow=bc,kc.xorshift7=xc,kc.xor4096=wc,kc.tychei=vc;var Nc=kc.alea;class Ic{constructor(e,t,n,s,r){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=r||Math.random();this.random=Nc(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let s,r,a;do{s=2*this.random()-1,r=2*this.random()-1,a=s*s+r*r}while(a>=1||0===a);const i=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*s*i,t=this.mean+this.stdDev*r*i,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Sc{constructor(e,t,n,s){this.alpha=e,this.beta=1/t,this.dtype=n;const r=s||Math.random();this.randu=Nc(r.toString()),this.randn=new Ic(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,s,r,a;for(;;){do{s=this.randn.nextValue(),a=1+this.c*s}while(a<=0);if(a*=a*a,e=s*s,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),r=this.randu(),r<t||Math.log(r)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class Tc{constructor(e=0,t=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Nc(s)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const $c=Jr({randomGamma_:function(e,t,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const a=new Sc(t,n,s,r),i=ja(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Cc=Jr({randomNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const a=new Ic(t,n,s,!1,r),i=ja(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const Ec=Jr({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return Cc(e,0,1,t,n)}});const Ac=Jr({randomUniform_:function(e,t=0,n=1,s="float32",r){const a=ja(e,s),i=new Tc(t,n,null,r);for(let e=0;e<a.values.length;e++)a.values[e]=i.nextValue();return a.toTensor()}});function Rc(e,t,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:e,stop:t,step:n,dtype:s};return Pr.runKernel(sn,{},r)}const _c=Jr({reciprocal_:function(e){const t={x:Xr(e,"x","reciprocal")};return Pr.runKernel(an,t)}});const Fc=Jr({relu_:function(e){const t={x:Xr(e,"x","relu")};return Pr.runKernel(on,t)}});const Dc=Jr({relu6_:function(e){const t={x:Xr(e,"x","relu6")};return Pr.runKernel(dn,t)}});const Oc=Jr({reverse_:function(e,t){const n={x:Xr(e,"x","reverse")},s={dims:t};return Pr.runKernel(fn,n,s)}});const Mc=Jr({reverse1d_:function(e){const t=Xr(e,"x","reverse");return u(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),Oc(t,0)}});const Lc=Jr({reverse2d_:function(e,t){const n=Xr(e,"x","reverse");return u(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Oc(n,t)}});const zc=Jr({reverse3d_:function(e,t){const n=Xr(e,"x","reverse");return u(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Oc(n,t)}});const Pc=Jr({reverse4d_:function(e,t){const n=Xr(e,"x","reverse");return u(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Oc(n,t)}});const Bc=Jr({round_:function(e){const t={x:Xr(e,"x","round")};return Pr.runKernel(mn,t)}});const Wc=Jr({rsqrt_:function(e){const t={x:Xr(e,"x","rsqrt","float32")};return Pr.runKernel(gn,t)}});const Vc=Jr({selu_:function(e){const t={x:Xr(e,"x","selu")};return Pr.runKernel(wn,t)}});const Uc=Jr({separableConv2d_:function(e,t,n,s,r,a=[1,1],i="NHWC"){const o=Xr(e,"x","separableConv2d"),l=Xr(t,"depthwiseFilter","separableConv2d"),c=Xr(n,"pointwiseFilter","separableConv2d");let h=o,p=!1;if(3===o.rank&&(p=!0,h=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");u(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),u(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),u(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),u(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),u(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const d=l.shape[2],f=l.shape[3];u(c.shape[2]===d*f,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${d*f}, but got ${c.shape[2]}.`));const m=Rl(h,l,s,r,i,a),g=bl(m,c,1,"valid",i);return p?Yo(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Gc=async function(e,t){const n=Xr(e,"x","setdiff1d"),s=Xr(t,"y","setdiff1d");u(n.dtype===s.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${s.dtype}).`)),u(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),u(1===s.rank,(()=>`y should be 1D tensor, but got y (${s.shape}).`));const r=await n.data(),a=await s.data(),i=new Set(a);let o=0;for(let e=0;e<r.length;e++)i.has(r[e])||o++;const l=new fr([o],n.dtype),c=new fr([o],"int32");for(let e=0,t=0;e<r.length;e++)i.has(r[e])||(l.values[t]=r[e],c.values[t]=e,t++);return[l.toTensor(),c.toTensor()]};const Hc=Jr({sign_:function(e){const t={x:Xr(e,"x","sign")};return Pr.runKernel(In,t)}});const jc=Jr({sin_:function(e){const t={x:Xr(e,"x","sin","float32")};return Pr.runKernel(kn,t)}});const qc=Jr({sinh_:function(e){const t={x:Xr(e,"x","sinh")};return Pr.runKernel(Nn,t)}});const Kc=Jr({slice1d_:function(e,t,n){const s=Xr(e,"x","slice1d");return u(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),tl(s,[t],[n])}});const Xc=Jr({slice2d_:function(e,t,n){const s=Xr(e,"x","slice2d");return u(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),tl(s,t,n)}});const Yc=Jr({slice3d_:function(e,t,n){const s=Xr(e,"x","slice3d");return u(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),tl(s,t,n)}});const Zc=Jr({slice4d_:function(e,t,n){const s=Xr(e,"x","slice4d");return u(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),tl(s,t,n)}});const Jc=Jr({softmax_:function(e,t=-1){const n=Xr(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const s={logits:n},r={dim:t};return Pr.runKernel(Rn,s,r)}});const Qc=Jr({fft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Pr.runKernel(st,t)}});const eh=Jr({ifft_:function(e){u("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Pr.runKernel(ft,t)}});const th=Jr({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let s;if(t<=2){const r=Yo(e,[n,t]);s=eh(r)}else{const r=[n,2*(t-1)],a=Yo(Ti(e),[n,t]),i=Yo(Ii(e),[n,t]),o=Oc(tl(a,[0,1],[n,t-2]),1),l=ko(Oc(tl(i,[0,1],[n,t-2]),1),Ql(-1)),u=Qo([a,o],1),c=Qo([i,l],1),h=Yo(Qr(u,c),[r[0],r[1]]);s=eh(h)}if(s=Ti(s),3===e.rank&&0!==e.shape[0]){const t=s,n=e.shape[0];s=Yo(s,[n,s.shape[0]/n,s.shape[1]]),t.dispose()}return s}});const nh=Jr({split_:function(e,t,n=0){const s={x:Xr(e,"x","split")},r={numOrSizeSplits:t,axis:n};return Pr.runKernel(An,s,r)}});const sh=Jr({rfft_:function(e,t){u("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const s=e.size/n;let r;if(null!=t&&t<n){const s=e.shape.map((e=>0)),a=e.shape.map((e=>e));a[e.shape.length-1]=t,r=tl(e,s,a),n=t}else if(null!=t&&t>n){const s=e.shape.map((e=>e));s[e.shape.length-1]=t-n,r=Qo([e,ju(s)],e.shape.length-1),n=t}else r=e;const a=Ml(r),i=Yo(Qr(r,a),[s,n]),o=Qc(i),l=Math.floor(n/2)+1,c=Ti(o),h=Ii(o),p=nh(c,[l,n-l],c.shape.length-1),d=nh(h,[l,n-l],h.shape.length-1),f=r.shape.slice();return f[r.shape.length-1]=l,Yo(Qr(p[0],d[0]),f)}});const rh=Jr({squaredDifference_:function(e,t){let n=Xr(e,"a","squaredDifference"),s=Xr(t,"b","squaredDifference");[n,s]=Er(n,s),_i(n.shape,s.shape);const r={a:n,b:s};return Pr.runKernel(Ln,r,{})}});const ah=Jr({squeeze_:function(e,t){const n=Xr(e,"x","squeeze","string_or_numeric");return Yo(n,v(n.shape,t).newShape)}});const ih=Jr({stack_:function(e,t=0){const n=Yr(e,"tensors","stack","string_or_numeric");u(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&u(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:t};return Pr.runKernel(Jt,s,r)}});const oh=Jr({step_:function(e,t=0){const n={x:Xr(e,"x","step")},s={alpha:t};return Pr.runKernel(es,n,s)}});const lh=Jr({stridedSlice_:function(e,t,n,s,r=0,a=0,i=0,o=0,l=0){const u={x:Xr(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:s,beginMask:r,endMask:a,ellipsisMask:i,newAxisMask:o,shrinkAxisMask:l};return Pr.runKernel(Pn,u,c)}});const uh=Jr({tan_:function(e){const t={x:Xr(e,"x","tan","float32")};return Pr.runKernel(Gn,t)}});function ch(e,t){h(e);const n=jr(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return ea(e,null,n,t)}function hh(e,t,n){if(h(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const s=jr(e,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return ea(e,t,s,n)}function ph(e,t,n){if(h(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const s=jr(e,n);if(4!==s.length&&1!==s.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return ea(e,t,s,n)}function dh(e,t,n){if(h(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const s=jr(e,n);if(5!==s.length&&1!==s.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return ea(e,t,s,n)}function fh(e,t,n){if(h(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const s=jr(e,n);if(6!==s.length&&1!==s.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===s.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return ea(e,t=t||s,s,n)}const mh=Jr({topk_:function(e,t=1,n=!0){const s=Xr(e,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${t}`);const a={x:s},i={k:t,sorted:n},[o,l]=Pr.runKernel(qn,a,i);return{values:o,indices:l}}});const gh=Jr({truncatedNormal_:function(e,t=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const a=new Ic(t,n,s,!0,r),i=ja(e,s);for(let e=0;e<i.values.length;e++)i.values[e]=a.nextValue();return i.toTensor()}});const yh=Jr({unique_:function(e,t=0){const n=Xr(e,"x","unique","string_or_numeric");u(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:t},[a,i]=Pr.runKernel(Yn,s,r);return{values:a,indices:i}}});const bh=Jr({unsortedSegmentSum_:function(e,t,n){const s=Xr(e,"x","unsortedSegmentSum"),r=Xr(t,"segmentIds","unsortedSegmentSum","int32");u(m(n),(()=>"numSegments must be of dtype int"));const a={x:s,segmentIds:r},i={numSegments:n};return Pr.runKernel(Jn,a,i)}});const xh=Jr({unstack_:function(e,t=0){const n=Xr(e,"x","unstack","string_or_numeric");u(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:t};return Pr.runKernel(Zn,s,r)}});function wh(e,t){return Pu(e,t,"right")}function vh(e,t=!0,n,s){return Pr.makeVariable(e,t,n,s)}function kh(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const s=ja(e,"int32"),r=ja([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=s.indexToLoc(n[t]),i=t*e.length;r.values.set(a,i)}return r.toTensor()}const Nh=async function(e){const t=Xr(e,"condition","whereAsync","bool"),n=await t.data(),s=kh(t.shape,n);return e!==t&&t.dispose(),s};const Ih=async function(e,t,n){const s=Xr(e,"tensor","boolMask"),r=Xr(t,"mask","boolMask","bool"),a=null==n?0:n,i=r.rank,o=s.shape;u(i>0,(()=>"mask cannot be scalar")),c(o.slice(a,a+i),r.shape,"mask's shape must match the first K dimensions of tensor's shape,");let l=1;for(let e=a;e<a+i;e++)l*=o[e];const h=o.slice(0,a).concat([l],o.slice(a+i)),p=Yo(s,h),d=Yo(r,[-1]),f=await Nh(d),m=ah(f,[1]),g=du(p,m,a);return e!==s&&s.dispose(),t!==r&&r.dispose(),m.dispose(),p.dispose(),d.dispose(),f.dispose(),g};const Sh=Jr({movingAverage_:function(e,t,n,s,r=!0){const a=Xr(e,"v","movingAverage"),i=Xr(t,"x","movingAverage"),o=Xr(n,"decay","movingAverage");Ar(a,i),u(f(a.shape,i.shape),(()=>"Shape mismatch in v and x"));const l=Ql(1),c=Ru(l,o);let h=ko(Ru(i,a),c);if(r){u(null!=s,(()=>"When using zeroDebias: true, step is required."));const e=Xr(s,"step","movingAverage");h=vo(h,Ru(l,Jl(o,e)))}return xo(a,h)}});const Th=Jr({scatterND_:function(e,t,n){const s=Xr(e,"indices","scatterND","int32"),r=Xr(t,"updates","scatterND");Ui(r,s,n);const a={indices:s,updates:r},i={shape:n};return Pr.runKernel(yn,a,i)}});const $h=Jr({sparseToDense_:function(e,t,n,s=0){const r=Xr(e,"sparseIndices","sparseToDense","int32"),a=Xr(t,"sparseValues","sparseToDense","string_or_numeric"),i=Xr(s,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,s){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const r=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const i=t.size;if(0!==t.rank&&(1!==t.rank||i!==r))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${r}]`);if(t.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,a,n,i);const o={sparseIndices:r,sparseValues:a,defaultValue:i},l={outputShape:n};return Pr.runKernel(Mn,o,l)}});const Ch=Jr({gatherND_:function(e,t){const n=Xr(t,"indices","gatherND","int32"),s={params:Xr(e,"x","gatherND","string_or_numeric"),indices:n};return Pr.runKernel(ct,s)}});const Eh=Jr({dropout_:function(e,t,n,s){const r=Xr(e,"x","dropout");if(u("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),u(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof br?r.clone():r;const a=function(e,t){if(null==t)return e.shape.slice();if(f(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let s=0;s<e.shape.length;s++)null==t[s]&&null!=e.shape[s]?n.push(e.shape[s]):n.push(t[s]);return n}return t}(r,n),i=1-t,o=vo(pu(xo(Ac(a,0,1,"float32",s),i)),i);return ko(r,o)}});function Ah(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Rh(e,t,n){const s=1-e%2,r=new Float32Array(e);for(let a=0;a<e;++a){const i=2*Math.PI*a/(e+s-1);r[a]=t-n*Math.cos(i)}return ch(r,"float32")}const _h=async function(e,t,n=1){const s=Xr(e,"predictions","inTopK"),r=Xr(t,"targets","inTopK");u(s.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${s.rank}`)),u(s.rank-1===r.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${s.rank} and targets rank ${r.rank}`)),c(s.shape.slice(0,s.shape.length-1),r.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=s.shape[s.shape.length-1];u(n>0&&n<=a,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`));const i=await s.data(),o=await r.data(),[l,h]=[i.length/a,a],p=k("bool",l);for(let e=0;e<l;e++){const t=e*h,s=i.subarray(t,t+h),r=[];for(let e=0;e<s.length;e++)r.push({value:s[e],index:e});r.sort(((e,t)=>t.value-e.value)),p[e]=0;for(let t=0;t<n;t++)if(r[t].index===o[e]){p[e]=1;break}}return e!==s&&s.dispose(),t!==r&&r.dispose(),ta(p,r.shape,"bool")};const Fh=Jr({conv2DBackpropFilter_:function(e,t,n,s,r,a="NHWC",i){let o=e;3===e.rank&&(o=Yo(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2]])),u(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),u(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),u(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===a?o.shape[3]:o.shape[1],h="NHWC"===a?l.shape[3]:l.shape[1];u(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),u(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),Xo("conv2dDerFilter",r,i);const p={x:o,dy:l},d={strides:s,pad:r,dataFormat:a,dimRoundingMode:i,filterShape:n};return Pr.runKernel(Ee,p,d)}});function Dh(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return ko(e,oh(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Oh(e,t){let n=t;const s=Ri(e.shape,t.shape);return s.length>0&&(n=nu(n,s)),Yo(n,e.shape)}function Mh(e,t,n,s){if("linear"===t)return e;if("relu"===t)return Fc(e);if("elu"===t)return Bl(e);if("relu6"===t)return Dc(e);if("prelu"===t)return hc(e,n);if("leakyrelu"===t)return xu(e,s);if("sigmoid"===t)return el(e);throw new Error(`Unknown fused activation ${t}.`)}const Lh=(e,t)=>!(e>0)||"linear"===t;const zh=Jr({fusedConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(l=l||"linear",!1===Lh(Pr.state.gradientDepth,l)){u("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let p=bl(e,t,n,s,r,a,i);return null!=o&&(p=xo(p,o)),Mh(p,l,c,h)}const p=Xr(e,"x","conv2d","float32"),d=Xr(t,"filter","conv2d","float32");let f=p,m=!1;3===p.rank&&(m=!0,f=Yo(p,[1,p.shape[0],p.shape[1],p.shape[2]])),u(4===f.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===d.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${d.rank}.`)),Xo("fused conv2d",s,i);const g="NHWC"===r?f.shape[3]:f.shape[1];u(d.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${d.shape[2]}.`)),u(qo(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const y=Po(f.shape,d.shape,n,a,s,i);let b,x;if(null!=o&&(b=Xr(o,"bias","fused conv2d"),[b]=Er(b,p),"NHWC"===r?_i(y.outShape,b.shape):(u(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),u(0===b.shape.length||b.shape[0]===y.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${y.outChannels})`)))),null!=c){const e=c.shape;if(u(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)u(1===e[0]||e[0]===y.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${y.outChannels}).`));else if(3===e.length)try{_i(e,y.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${y.outShape}).`;throw Error(n)}x=Xr(c,"prelu weights","fused conv2d")}const w=(e,t)=>{u("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[i,o,c,h]=t,p=Dh(e,c,l);u(jo(a),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`));const d=[wl(o.shape,p,i,n,s),Fh(o,p,i.shape,n,s)];if(null!=h){const e=Oh(h,p);d.push(e)}return d},v={x:f,filter:d,bias:b,preluActivationWeights:x},k={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:h};if(null==o){const e=$u(((e,t,n)=>{let s=Pr.runKernel(rs,v,k);return n([t,e,s]),m&&(s=Yo(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return e(f,d)}{const e=$u(((e,t,n,s)=>{let r=Pr.runKernel(rs,v,k);return s([t,e,r,n]),m&&(r=Yo(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return e(f,d,b)}}});const Ph=Jr({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,s,r,a=[1,1],i){let o=e;3===e.rank&&(o=Yo(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:o,dy:l},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,filterShape:n};return Pr.runKernel(Ve,u,c)}});const Bh=Jr({depthwiseConv2dNativeBackpropInput_:function(e,t,n,s,r,a=[1,1],i){let o=t,l=!1;3===t.rank&&(l=!0,o=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:o,filter:n},c={strides:s,pad:r,dimRoundingMode:i,dilations:a,inputShape:e},h=Pr.runKernel(Ue,u,c);return l?Yo(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Wh=Jr({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:s,dataFormat:r="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:o,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===Lh(Pr.state.gradientDepth,l)){let u=Rl(e,t,n,s,r,a,i);return null!=o&&(u=xo(u,o)),Mh(u,l,c,h)}const p=Xr(e,"x","depthwiseConv2d","float32"),d=Xr(t,"filter","depthwiseConv2d","float32");let f=p,m=!1;3===p.rank&&(m=!0,f=Yo(p,[1,p.shape[0],p.shape[1],p.shape[2]])),u(4===f.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${f.rank}.`)),u(4===d.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${d.rank}.`)),u(f.shape[3]===d.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${f.shape[3]}) must match the inChannels dimension in filter ${d.shape[2]}.`)),null==a&&(a=[1,1]),u(qo(n,a),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),Xo("fused depthwiseConv2d",s,i);const g=Po(f.shape,d.shape,n,a,s,i,!0);let y,b;null!=o&&(y=Xr(o,"bias","fused conv2d"),[y]=Er(y,p),_i(g.outShape,y.shape)),null!=c&&(b=Xr(c,"prelu weights","fused depthwiseConv2d"));const x=(e,t)=>{u(jo(a),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`));const[r,o,c,h]=t,p=Dh(e,c,l),d=Bh(o.shape,p,r,n,s,a,i),f=Ph(o,p,r.shape,n,s,a,i);if(null!=h){return[d,f,Oh(y,p)]}return[d,f]},w={x:f,filter:d,bias:y,preluActivationWeights:b},v={strides:n,pad:s,dataFormat:r,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:h};if(null==o){const e=$u(((e,t,n)=>{let s=Pr.runKernel(as,w,v);return n([t,e,s]),m&&(s=Yo(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}}));return e(f,d)}{const e=$u(((e,t,n,s)=>{let r=Pr.runKernel(as,w,v);return s([t,e,r,n]),m&&(r=Yo(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}}));return e(f,d,y)}}});const Vh=Jr({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:s=!1,bias:r,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:o=.2}){if(!1===Lh(Pr.state.gradientDepth,a)){let l=di(e,t,n,s);return null!=r&&(l=xo(l,r)),Mh(l,a,i,o)}let l=Xr(e,"a","fused matMul"),c=Xr(t,"b","fused matMul");[l,c]=Er(l,c);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],p=s?c.shape[c.rank-1]:c.shape[c.rank-2],f=n?l.shape[l.rank-1]:l.shape[l.rank-2],m=s?c.shape[c.rank-2]:c.shape[c.rank-1],g=l.shape.slice(0,-2),y=c.shape.slice(0,-2),b=d(g),x=d(y);u(h===p,(()=>`Error in fused matMul: inner shapes (${h}) and (${p}) of Tensors with shapes ${l.shape} and ${c.shape} and transposeA=${n} and transposeB=${s} must match.`));const w=_i(l.shape.slice(0,-2),c.shape.slice(0,-2)).concat([f,m]),v=Yo(l,n?[b,h,f]:[b,f,h]),k=Yo(c,s?[x,m,p]:[x,p,m]);let N,I;null!=r&&(N=Xr(r,"bias","fused matMul"),[N]=Er(N,l),_i(w,N.shape)),null!=i&&(I=Xr(i,"prelu weights","fused matMul"));const S=(e,t)=>{const[i,o,l,u]=t,c=Dh(Yo(e,l.shape),l,a);let h,p;if(n||s?!n&&s?(h=di(c,o,!1,!1),p=di(c,i,!0,!1)):n&&!s?(h=di(o,c,!1,!0),p=di(i,c,!1,!1)):(h=di(o,c,!0,!0),p=di(c,i,!0,!0)):(h=di(c,o,!1,!0),p=di(i,c,!0,!1)),null!=r){return[h,p,Oh(u,c)]}return[h,p]},T={a:v,b:k,bias:N,preluActivationWeights:I},$={transposeA:n,transposeB:s,activation:a,leakyreluAlpha:o};if(null==r){const e=$u(((e,t,n)=>{const s=Pr.runKernel(ss,T,$);return n([e,t,s]),{value:Yo(s,w),gradFunc:S}}));return e(v,k)}{const e=$u(((e,t,n,s)=>{const r=Pr.runKernel(ss,T,$);return s([e,t,r,n]),{value:Yo(r,w),gradFunc:S}}));return e(v,k,N)}}});var Uh=Object.freeze({__proto__:null,conv2d:zh,depthwiseConv2d:Wh,matMul:Vh});const Gh=Jr({hammingWindow_:function(e){return Rh(e,.54,.46)}});const Hh=Jr({hannWindow_:function(e){return Rh(e,.5,.5)}});const jh=Jr({frame_:function(e,t,n,s=!1,r=0){let a=0;const i=[];for(;a+t<=e.size;)i.push(tl(e,a,t)),a+=n;if(s)for(;a<e.size;){const s=a+t-e.size,o=Qo([tl(e,a,t-s),hu([s],r)]);i.push(o),a+=n}return 0===i.length?hh([],[0,t]):Yo(Qo(i),[i.length,t])}});const qh=Jr({stft_:function(e,t,n,s,r=Hh){null==s&&(s=Ah(t));const a=jh(e,t,n),i=ko(a,r(t));return sh(i,s)}});const Kh=Jr({cropAndResize_:function(e,t,n,s,r="bilinear",a=0){const i=Xr(e,"image","cropAndResize"),o=Xr(t,"boxes","cropAndResize","float32"),l=Xr(n,"boxInd","cropAndResize","int32"),c=o.shape[0];u(4===i.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`)),u(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${o.shape}.`)),u(1===l.rank&&l.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${o.shape}.`)),u(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),u(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),u("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:i,boxes:o,boxInd:l},p={method:r,extrapolationValue:a,cropSize:s};return Pr.runKernel(ze,h,p)}});const Xh=Jr({flipLeftRight_:function(e){const t=Xr(e,"image","flipLeftRight","float32");u(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Pr.runKernel(at,n,{})}});const Yh=Jr({grayscaleToRGB_:function(e){const t=Xr(e,"image","grayscaleToRGB"),n=t.rank-1,s=t.shape[n];u(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),u(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(t.rank);return r.fill(1,0,n),r[n]=3,uu(t,r)}});const Zh=Jr({rotateWithOffset_:function(e,t,n=0,s=.5){const r=Xr(e,"image","rotateWithOffset","float32");u(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const a={image:r},i={radians:t,fillValue:n,center:s};return Pr.runKernel(ns,a,i)}});function Jh(e,t,n,s,r,a){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),u(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),u(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),u(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),u(1===t.rank,(()=>"scores must be a 1D tensor")),u(t.shape[0]===i,(()=>`scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`)),u(0<=a&&a<=1,(()=>`softNmsSigma must be in [0, 1], but was '${a}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:a}}const Qh=Jr({nonMaxSuppression_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Xr(e,"boxes","nonMaxSuppression","float32"),i=Xr(t,"scores","nonMaxSuppression","float32"),o=Jh(a,i,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Pr.runKernel(qt,{boxes:a,scores:i},l)}});function ep(e,t,n){const s=function(e,t,n){return function(e,t,n){let s=0,r=e.length,a=0,i=!1;for(;s<r;){a=s+(r-s>>>1);const o=n(t,e[a]);o>0?s=a+1:(r=a,i=!o)}return i?s:-s-1}(e,t,n||tp)}(e,t,n),r=s<0?-(s+1):s;e.splice(r,0,t)}function tp(e,t){return e>t?1:e<t?-1:0}function np(e,t,n,s,r){return ap(e,t,n,s,r,0)}function sp(e,t,n,s,r,a){return ap(e,t,n,s,r,0,!1,a,!0)}function rp(e,t,n,s,r,a){return ap(e,t,n,s,r,a,!0)}function ap(e,t,n,s,r,a,i=!1,o=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>r&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(lp);const c=a>0?-.5/a:0,h=[],p=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:a,suppressBeginIndex:i}=t;if(n<r)break;let o=!1;for(let n=h.length-1;n>=i;--n){const i=ip(e,a,h[n]);if(i>=s){o=!0;break}if(t.score=t.score*op(s,c,i),t.score<=r)break}t.suppressBeginIndex=h.length,o||(t.score===n?(h.push(a),p.push(t.score)):t.score>r&&ep(u,t,lp))}const d=h.length,f=n-d;o&&f>0&&(h.push(...new Array(f).fill(0)),p.push(...new Array(f).fill(0)));const m={selectedIndices:h};return i&&(m.selectedScores=p),l&&(m.validOutputs=d),m}function ip(e,t,n){const s=e.subarray(4*t,4*t+4),r=e.subarray(4*n,4*n+4),a=Math.min(s[0],s[2]),i=Math.min(s[1],s[3]),o=Math.max(s[0],s[2]),l=Math.max(s[1],s[3]),u=Math.min(r[0],r[2]),c=Math.min(r[1],r[3]),h=Math.max(r[0],r[2]),p=Math.max(r[1],r[3]),d=(o-a)*(l-i),f=(h-u)*(p-c);if(d<=0||f<=0)return 0;const m=Math.max(a,u),g=Math.max(i,c),y=Math.min(o,h),b=Math.min(l,p),x=Math.max(y-m,0)*Math.max(b-g,0);return x/(d+f-x)}function op(e,t,n){const s=Math.exp(t*n*n);return n<=e?s:0}function lp(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const up=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY){const a=Xr(e,"boxes","nonMaxSuppressionAsync"),i=Xr(t,"scores","nonMaxSuppressionAsync"),o=Jh(a,i,n,s,r);n=o.maxOutputSize,s=o.iouThreshold,r=o.scoreThreshold;const l=await Promise.all([a.data(),i.data()]),u=l[0],c=l[1],{selectedIndices:h}=np(u,c,n,s,r);return a!==e&&a.dispose(),i!==t&&i.dispose(),ch(h,"int32")};const cp=Jr({nonMaxSuppressionWithScore_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Xr(e,"boxes","nonMaxSuppression"),o=Xr(t,"scores","nonMaxSuppression"),l=Jh(i,o,n,s,r,a),u={boxes:i,scores:o},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:a=l.softNmsSigma},h=Pr.runKernel(Xt,u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const hp=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=0){const i=Xr(e,"boxes","nonMaxSuppressionAsync"),o=Xr(t,"scores","nonMaxSuppressionAsync"),l=Jh(i,o,n,s,r,a);n=l.maxOutputSize,s=l.iouThreshold,r=l.scoreThreshold,a=l.softNmsSigma;const u=await Promise.all([i.data(),o.data()]),c=u[0],h=u[1],{selectedIndices:p,selectedScores:d}=rp(c,h,n,s,r,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:ch(p,"int32"),selectedScores:ch(d)}};const pp=Jr({nonMaxSuppressionPadded_:function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Xr(e,"boxes","nonMaxSuppression"),o=Xr(t,"scores","nonMaxSuppression"),l=Jh(i,o,n,s,r,null),u={boxes:i,scores:o},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:a},h=Pr.runKernel(Kt,u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const dp=async function(e,t,n,s=.5,r=Number.NEGATIVE_INFINITY,a=!1){const i=Xr(e,"boxes","nonMaxSuppressionAsync"),o=Xr(t,"scores","nonMaxSuppressionAsync"),l=Jh(i,o,n,s,r,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[p,d]=await Promise.all([i.data(),o.data()]),{selectedIndices:f,validOutputs:m}=sp(p,d,u,c,h,a);return i!==e&&i.dispose(),o!==t&&o.dispose(),{selectedIndices:ch(f,"int32"),validOutputs:Ql(m,"int32")}};const fp=Jr({resizeBilinear_:function(e,t,n=!1,s=!1){const r=Xr(e,"images","resizeBilinear");u(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),u(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),u(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=Yo(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},l={alignCorners:n,halfPixelCenters:s,size:t},c=Pr.runKernel(hn,o,l);return i?Yo(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const mp=Jr({resizeNearestNeighbor_:function(e,t,n=!1,s=!1){const r=Xr(e,"images","resizeNearestNeighbor");u(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),u(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),u("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),u(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let a=r,i=!1;3===r.rank&&(i=!0,a=Yo(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const[]=t,o={images:a},l={alignCorners:n,halfPixelCenters:s,size:t},c=Pr.runKernel(un,o,l);return i?Yo(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const gp=Jr({threshold_:function(e,t="binary",n=!1,s=.5){const r=Xr(e,"image","threshold"),a=r.shape[0]*r.shape[1];let i,o,l,c,h=ko(ch([s]),255);if(u(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),u(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),u("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),u("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===r.shape[2]){[i,o,l]=nh(r,[1,1,1],-1);const e=ko(i,.2989),t=ko(o,.587),n=ko(l,.114);c=xo(xo(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,s,r,a,i,o,l=ch([-1]),u=ch([0]),c=ch([0]);for(let h=0;h<e.size-1;h++){n=tl(e,0,h+1),s=tl(e,h+1),i=vo(nu(n),t),o=vo(nu(s),t);const p=nu(ko(n,Rc(0,n.size)));r=vo(p,nu(n));const d=hu(s.shape,n.size),f=xo(Rc(0,s.size),d),m=ko(s,f);a=vo(nu(m),nu(s));const g=Ru(r,a),y=Ru(r,a),b=ko(i,o);c=ko(ko(b,g),y);const x=fu(c,u);u=Ol(x,c,u),l=Ol(x,ch([h]),l)}return l}(ul(qa(Bc(c),"int32"),ta([]),256),a)}const p=n?vu(c,h):fu(c,h);return qa(ko(p,255),"int32")}});const yp=Jr({transform_:function(e,t,n="nearest",s="constant",r=0,a){const i=Xr(e,"image","transform","float32"),o=Xr(t,"transforms","transform","float32");u(4===i.rank,(()=>`Error in transform: image must be rank 4,but got rank ${i.rank}.`)),u(2===o.rank&&(o.shape[0]===i.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),u(null==a||2===a.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${a}.`));const l={image:i,transforms:o},c={interpolation:n,fillMode:s,fillValue:r,outputShape:a};return Pr.runKernel(Kn,l,c)}});const bp=Jr({bandPart_:function(e,t,n){u(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),u(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=Xr(e,"a","bandPart");u(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[a,i]=s.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=a),n<0&&(n=i);const o=Yo(Rc(0,a,1,"int32"),[-1,1]),l=Rc(0,i,1,"int32"),c=Ru(o,l),h=Du(vu(c,Ql(+t,"int32")),mu(c,Ql(-n,"int32"))),p=ju([a,i],s.dtype);return Yo(ih(xh(Yo(s,[-1,a,i])).map((e=>Ol(h,e,p)))),r)}});const xp=Jr({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,u(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)u(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=nh(e,e.shape[0],0).map((e=>ah(e,[0])));u(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],s=e;for(let t=0;t<e.length;++t)n.push(Pr.tidy((()=>{let e=s[t];if(t>0)for(let s=0;s<t;++s){const t=ko(nu(ko(n[s],e)),n[s]);e=Ru(e,t)}return vo(e,ru(e,"euclidean"))})));return t?ih(n,0):n}});function wp(e,t=!1){return Pr.tidy((()=>{u(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],s=e.shape[1];let r=cu(n),a=Ka(e);const i=hh([[1]],[1,1]);let o=Ka(i);const l=n>=s?s:n;for(let e=0;e<l;++e){const t=a,l=o,u=r;[o,a,r]=Pr.tidy((()=>{const t=tl(a,[e,e],[n-e,1]),l=ru(t),u=tl(a,[e,e],[1,1]),c=Ol(fu(u,0),hh([[-1]]),hh([[1]])),h=Ru(u,ko(c,l)),p=vo(t,h);o=1===p.shape[0]?Ka(i):Qo([i,tl(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=Si(vo(di(c,h),l)),f=tl(a,[e,0],[n-e,s]),m=ko(d,o),g=$i(o);if(0===e)a=Ru(f,di(m,di(g,f)));else{const t=Ru(f,di(m,di(g,f)));a=Qo([tl(a,[0,0],[e,s]),t],0)}const y=$i(m),b=tl(r,[0,e],[n,r.shape[1]-e]);if(0===e)r=Ru(b,di(di(b,o),y));else{const t=Ru(b,di(di(b,o),y));r=Qo([tl(r,[0,0],[n,e]),t],1)}return[o,a,r]})),xi([t,l,u])}return!t&&n>s&&(r=tl(r,[0,0],[n,s]),a=tl(a,[0,0],[s,s])),[r,a]}))}const vp=Jr({qr_:function(e,t=!1){if(u(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return wp(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),s=xh(Yo(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),r=[],a=[];s.forEach((e=>{const[n,s]=wp(e,t);r.push(n),a.push(s)}));return[Yo(ih(r,0),e.shape),Yo(ih(a,0),e.shape)]}}});var kp;(kp=e.Reduction||(e.Reduction={}))[kp.NONE=0]="NONE",kp[kp.MEAN=1]="MEAN",kp[kp.SUM=2]="SUM",kp[kp.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const Np=Jr({computeWeightedLoss_:function(t,n,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const r=Xr(t,"losses","computeWeightedLoss");let a=null;null!=n&&(a=Xr(n,"weights","computeWeightedLoss"));const i=null==a?r:ko(r,a);if(s===e.Reduction.NONE)return i;if(s===e.Reduction.SUM)return nu(i);if(s===e.Reduction.MEAN){if(null==a)return Hu(i);{const e=r.size/a.size,t=vo(nu(i),nu(a));return e>1?vo(t,Ql(e)):t}}if(s===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==a)return vo(nu(i),Ql(r.size));{const e=ko(a,qu(r.shape)),t=qa(nu(tc(e,Ql(0))),"float32");return vo(nu(i),t)}}throw Error(`Unknown reduction: ${s}`)}});const Ip=Jr({absoluteDifference_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Xr(t,"labels","absoluteDifference"),i=Xr(n,"predictions","absoluteDifference");let o=null;null!=s&&(o=Xr(s,"weights","absoluteDifference")),c(a.shape,i.shape,"Error in absoluteDifference: ");const l=No(Ru(a,i));return Np(l,o,r)}});const Sp=Jr({cosineDistance_:function(t,n,s,r,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Xr(t,"labels","cosineDistance"),o=Xr(n,"predictions","cosineDistance");let l=null;null!=r&&(l=Xr(r,"weights","cosineDistance")),c(i.shape,o.shape,"Error in cosineDistance: ");const u=Ql(1),h=Ru(u,nu(ko(i,o),s,!0));return Np(h,l,a)}});const Tp=Jr({hingeLoss_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Xr(t,"labels","hingeLoss");const i=Xr(n,"predictions","hingeLoss");let o=null;null!=s&&(o=Xr(s,"weights","hingeLoss")),c(a.shape,i.shape,"Error in hingeLoss: ");const l=Ql(1);a=Ru(ko(Ql(2),a),l);const u=Fc(Ru(l,ko(a,i)));return Np(u,o,r)}});const $p=Jr({huberLoss_:function(t,n,s,r=1,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Xr(t,"labels","huberLoss"),o=Xr(n,"predictions","huberLoss");let l=null;null!=s&&(l=Xr(s,"weights","huberLoss")),c(i.shape,o.shape,"Error in huberLoss: ");const u=Ql(r),h=No(Ru(o,i)),p=Xu(h,u),d=Ru(h,p),f=xo(ko(Ql(.5),tu(p)),ko(u,d));return Np(f,l,a)}});const Cp=Jr({logLoss_:function(t,n,s,r=1e-7,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=Xr(t,"labels","logLoss"),o=Xr(n,"predictions","logLoss");let l=null;null!=s&&(l=Xr(s,"weights","logLoss")),c(i.shape,o.shape,"Error in logLoss: ");const u=Ql(1),h=Ql(r),p=Si(ko(i,Iu(xo(o,h)))),d=ko(Ru(u,i),Iu(xo(Ru(u,o),h))),f=Ru(p,d);return Np(f,l,a)}});const Ep=Jr({meanSquaredError_:function(t,n,s,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Xr(t,"labels","meanSquaredError"),i=Xr(n,"predictions","meanSquaredError");let o=null;null!=s&&(o=Xr(s,"weights","meanSquaredError")),c(a.shape,i.shape,"Error in meanSquaredError: ");const l=rh(a,i);return Np(l,o,r)}});const Ap=Jr({sigmoidCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=Xr(t,"multiClassLabels","sigmoidCrossEntropy");const o=Xr(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=s&&(l=Xr(s,"weights","sigmoidCrossEntropy")),c(i.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Ql(r),t=Ql(1),n=Ql(.5);i=xo(ko(i,Ru(t,e)),ko(n,e))}const u=function(e,t){const n=Xr(e,"labels","sigmoidCrossEntropyWithLogits"),s=Xr(t,"logits","sigmoidCrossEntropyWithLogits");c(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=Fc(s),a=ko(s,n),i=Su(iu(Si(No(s))));return xo(Ru(r,a),i)}(i,o);return Np(u,l,a)}});const Rp=Jr({softmaxCrossEntropy_:function(t,n,s,r=0,a=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=Xr(t,"onehotLabels","softmaxCrossEntropy");const o=Xr(n,"logits","softmaxCrossEntropy");let l=null;if(null!=s&&(l=Xr(s,"weights","softmaxCrossEntropy")),c(i.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Ql(r),t=Ql(1),n=Ql(i.shape[1]);i=xo(ko(i,Ru(t,e)),vo(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const s=$u(((e,t,s)=>{const r=Fu(t,[n],!0),a=Ru(qa(t,"float32"),r);s([e,a]);const i=Si(ko(a,e));return{value:nu(i,[n]),gradFunc:(e,t)=>{const[s,r]=t,a=Hl(e.shape,[n]);return[ko(Yo(e,a),Ru(qa(s,"float32"),iu(r))),ko(Yo(e,a),Ru(iu(r),qa(s,"float32")))]}}}));return s(e,t)}(i,o);return Np(u,l,a)}});const _p=Jr({sparseFillEmptyRows_:function(e,t,n,s){const r=Xr(e,"indices","sparseFillEmptyRows","int32"),a=Xr(t,"values","sparseFillEmptyRows"),i=Xr(n,"denseShape","sparseFillEmptyRows","int32"),o=Xr(s,"defaultValue","sparseFillEmptyRows",a.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==a.rank)throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);if(1!==i.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${i.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:a,denseShape:i,defaultValue:o},u=Pr.runKernel(_n,l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const Fp=Jr({sparseReshape_:function(e,t,n){const s=Xr(e,"inputIndices","sparseReshape","int32"),r=Xr(t,"inputShape","sparseReshape","int32"),a=Xr(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==a.rank)throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);const i={inputIndices:s,inputShape:r,newShape:a},o=Pr.runKernel(Fn,i);return{outputIndices:o[0],outputShape:o[1]}}});const Dp=Jr({sparseSegmentMean_:function(e,t,n){const s=Xr(e,"data","sparseSegmentMean"),r=Xr(t,"indices","sparseSegmentMean","int32"),a=Xr(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${a.shape}`);const i={data:s,indices:r,segmentIds:a};return Pr.runKernel(Dn,i)}});const Op=Jr({sparseSegmentSum_:function(e,t,n){const s=Xr(e,"data","sparseSegmentSum"),r=Xr(t,"indices","sparseSegmentSum","int32"),a=Xr(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${a.shape}`);const i={data:s,indices:r,segmentIds:a};return Pr.runKernel(On,i)}});const Mp=Jr({stringNGrams_:function(e,t,n,s,r,a,i,o){const l=Xr(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Xr(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:s,leftPad:r,rightPad:a,padWidth:i,preserveShortSequences:o},h={data:l,dataSplits:u},p=Pr.runKernel(Bn,h,c);return{nGrams:p[0],nGramsSplits:p[1]}}});const Lp=Jr({stringSplit_:function(e,t,n=!0){const s=Xr(e,"input","stringSplit","string"),r=Xr(t,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const a={skipEmpty:n},i={input:s,delimiter:r},o=Pr.runKernel(Wn,i,a);return{indices:o[0],values:o[1],shape:o[2]}}});const zp=Jr({stringToHashBucketFast_:function(e,t){const n=Xr(e,"input","stringToHashBucketFast","string"),s={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return Pr.runKernel(Vn,r,s)}}),Pp={fft:Qc,ifft:eh,rfft:sh,irfft:th},Bp={hammingWindow:Gh,hannWindow:Hh,frame:jh,stft:qh},Wp={flipLeftRight:Xh,grayscaleToRGB:Yh,resizeNearestNeighbor:mp,resizeBilinear:fp,rotateWithOffset:Zh,cropAndResize:Kh,nonMaxSuppression:Qh,nonMaxSuppressionAsync:up,nonMaxSuppressionWithScore:cp,nonMaxSuppressionWithScoreAsync:hp,nonMaxSuppressionPadded:pp,nonMaxSuppressionPaddedAsync:dp,threshold:gp,transform:yp},Vp={bandPart:bp,gramSchmidt:xp,qr:vp},Up={absoluteDifference:Ip,computeWeightedLoss:Np,cosineDistance:Sp,hingeLoss:Tp,huberLoss:$p,logLoss:Cp,meanSquaredError:Ep,sigmoidCrossEntropy:Ap,softmaxCrossEntropy:Rp},Gp={sparseFillEmptyRows:_p,sparseReshape:Fp,sparseSegmentMean:Dp,sparseSegmentSum:Op},Hp={stringNGrams:Mp,stringSplit:Lp,stringToHashBucketFast:zp};class jp extends lo{minimize(e,t=!1,n){const{value:s,grads:r}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:r[e.name]})));this.applyGradients(e)}else this.applyGradients(r);return xi(r),t?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return Tu(e,t)}dispose(){null!=this.iterations_&&xi(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ql(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(jp,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class qp extends jp{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Pr.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Pr.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:bi((()=>Ml(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:bi((()=>Ml(s).variable(false)))});const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable,i=this.accumulatedUpdates[n].variable;bi((()=>{const e=xo(ko(a,this.rho),ko(tu(r),1-this.rho)),t=ko(vo(eu(xo(i,this.epsilon)),eu(xo(a,this.epsilon))),r),n=xo(ko(i,this.rho),ko(tu(t),1-this.rho));a.assign(e),i.assign(n);const o=xo(ko(t,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(xi(this.accumulatedGrads.map((e=>e.variable))),xi(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}qp.className="Adadelta",co(qp);class Kp extends jp{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Pr.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:bi((()=>hu(s.shape,this.initialAccumulatorValue).variable(e)))}}const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const a=this.accumulatedGrads[n].variable;bi((()=>{const e=xo(a,tu(r));a.assign(e);const t=xo(ko(vo(r,eu(xo(e,Pr.backend.epsilon()))),-this.learningRate),s);s.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&xi(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}Kp.className="Adagrad",co(Kp);class Xp extends jp{constructor(e,t,n,s=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],bi((()=>{this.accBeta1=Ql(t).variable(),this.accBeta2=Ql(n).variable()})),null==s&&(this.epsilon=Pr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);bi((()=>{const n=Ru(1,this.accBeta1),s=Ru(1,this.accBeta2);t.forEach(((t,r)=>{const a=Pr.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:bi((()=>Ml(a).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${t}/v`,variable:bi((()=>Ml(a).variable(false)))});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=xo(ko(o,this.beta1),ko(i,1-this.beta1)),c=xo(ko(l,this.beta2),ko(tu(i),1-this.beta2)),h=vo(u,n),p=vo(c,s);o.assign(u),l.assign(c);const d=xo(ko(vo(h,xo(eu(p),this.epsilon)),-this.learningRate),a);a.assign(d)})),this.accBeta1.assign(ko(this.accBeta1,this.beta1)),this.accBeta2.assign(ko(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&xi(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&xi(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),bi((()=>{this.accBeta1.assign(Jl(this.beta1,this.iterations_+1)),this.accBeta2.assign(Jl(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}Xp.className="Adam",co(Xp);class Yp extends jp{constructor(e,t,n,s=null,r=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],bi((()=>{this.iteration=Ql(0).variable(),this.accBeta1=Ql(t).variable()})),null==s&&(this.epsilon=Pr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);bi((()=>{const n=Ru(1,this.accBeta1),s=vo(-this.learningRate,xo(ko(this.iteration,this.decay),1));t.forEach(((t,r)=>{const a=Pr.registeredVariables[t];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${t}/m`,variable:Ml(a).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${t}/v`,variable:Ml(a).variable(false)});const i=Array.isArray(e)?e[r].tensor:e[t];if(null==i)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=xo(ko(o,this.beta1),ko(i,1-this.beta1)),c=ko(l,this.beta2),h=No(i),p=Gu(c,h);o.assign(u),l.assign(p);const d=xo(ko(vo(s,n),vo(u,xo(p,this.epsilon))),a);a.assign(d)})),this.iteration.assign(xo(this.iteration,1)),this.accBeta1.assign(ko(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&xi(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&xi(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}Yp.className="Adamax",co(Yp);class Zp extends jp{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const r=Pr.registeredVariables[t];bi((()=>{const e=xo(ko(this.c,s),r);r.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=wi(Ql(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}Zp.className="SGD",co(Zp);class Jp extends Zp{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Ql(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Pr.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:bi((()=>Ml(s).variable(e)))}}const r=this.accumulations[n].variable,a=Array.isArray(e)?e[n].tensor:e[t];null!=a&&bi((()=>{let e;const t=xo(ko(this.m,r),a);e=this.useNesterov?xo(ko(this.c,xo(a,ko(t,this.m))),s):xo(ko(this.c,t),s),r.assign(t),s.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&xi(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}Jp.className="Momentum",co(Jp);class Qp extends jp{constructor(e,t=.9,n=0,s=null,r=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Pr.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const s=Pr.registeredVariables[t],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:bi((()=>Ml(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:bi((()=>Ml(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:bi((()=>Ml(s).variable(r)))});const a=Array.isArray(e)?e[n].tensor:e[t];if(null==a)return;const i=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;bi((()=>{const e=xo(ko(i,this.decay),ko(tu(a),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,r=xo(ko(t,this.decay),ko(a,1-this.decay)),l=vo(ko(a,this.learningRate),eu(Ru(e,xo(tu(r),this.epsilon)))),u=xo(ko(o,this.momentum),l);i.assign(e),t.assign(r),o.assign(u);const c=Ru(s,u);s.assign(c)}else{const e=xo(ko(i,this.decay),ko(tu(a),1-this.decay)),t=xo(ko(o,this.momentum),vo(ko(a,this.learningRate),eu(xo(e,this.epsilon))));i.assign(e),o.assign(t);const n=Ru(s,t);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&xi(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&xi(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&xi(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Qp.className="RMSProp",co(Qp);class ed{static sgd(e){return new Zp(e)}static momentum(e,t,n=!1){return new Jp(e,t,n)}static rmsprop(e,t=.9,n=0,s=null,r=!1){return new Qp(e,t,n,s,r)}static adam(e=.001,t=.9,n=.999,s=null){return new Xp(e,t,n,s)}static adadelta(e=.001,t=.95,n=null){return new qp(e,t,n)}static adamax(e=.002,t=.9,n=.999,s=null,r=0){return new Yp(e,t,n,s,r)}static adagrad(e,t=.1){return new Kp(e,t)}}const td={sgd:ed.sgd,momentum:ed.momentum,adadelta:ed.adadelta,adagrad:ed.adagrad,rmsprop:ed.rmsprop,adamax:ed.adamax,adam:ed.adam},nd="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function sd(){return new Promise((e=>nd((()=>e()))))}function rd(e,t){const n=e[0].length;e.forEach(((e,t)=>{u(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),u(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const s=e[0];e.forEach(((e,r)=>{for(let a=0;a<n;a++)u(a===t||e[a]===s[a],(()=>`Error in concat${n}D: Shape of tensors[${r}] (${e}) does not match the shape of the rest (${s}) along the non-concatenated axis ${r}.`))}))}function ad(e,t){const n=e[0].slice();for(let s=1;s<e.length;s++)n[t]+=e[s][t];return n}function id(e){return e<=30?e:O(e,Math.floor(Math.sqrt(e)))}function od(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]}function ld(e,t,n,s=!0){let r=[];if(s)r=r.concat(t.slice(0)),r.push(e[0]/n),r=r.concat(e.slice(1));else{r=r.concat(e[0]);const n=t.length;for(let s=0;s<n;++s)r=r.concat([e[s+1]/t[s],t[s]]);r=r.concat(e.slice(n+1))}return r}function ud(e,t,n=!0){const s=[];if(n){s.push(t);for(let n=t+1;n<e;++n)n<=2*t?(s.push(n),s.push(n-(t+1))):s.push(n)}else{const n=[],r=[];for(let s=1;s<e;++s)s>=2*t+1||s%2==1?r.push(s):n.push(s);s.push(...n),s.push(0),s.push(...r)}return s}function cd(e,t,n,s=!0){const r=[];s?r.push(e[0]/n):r.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?s?r.push(t[n-1]*e[n]):r.push(e[n]/t[n-1]):r.push(e[n]);return r}function hd(e,t){const n=[0];for(let s=0;s<t;++s)n.push(e[s][0]);return n}function pd(e,t,n){const s=e.slice(0,1);for(let r=0;r<n;++r)s.push(e[r+1]-t[r][0]-t[r][1]);return s}const dd=1.7580993408473768,fd=1.0507009873554805,md=.3275911,gd=.254829592,yd=-.284496736,bd=1.421413741,xd=-1.453152027,wd=1.061405429;function vd(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let s=0;s<n.length;s+=2)n[s]=e[s/2],n[s+1]=t[s/2];return n}function kd(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let s=0;s<e.length;s+=2)t[s/2]=e[s],n[s/2]=e[s+1];return{real:t,imag:n}}function Nd(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Id(e){const t=Math.floor(e.length/4),n=new Float32Array(t),s=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],s[Math.floor(t/4)]=e[t+1];return{real:n,imag:s}}function Sd(e,t){return{real:e[2*t],imag:e[2*t+1]}}function Td(e,t,n,s){e[2*s]=t,e[2*s+1]=n}function $d(e,t){const n=new Float32Array(e/2),s=new Float32Array(e/2);for(let r=0;r<Math.ceil(e/2);r++){const a=(t?2:-2)*Math.PI*(r/e);n[r]=Math.cos(a),s[r]=Math.sin(a)}return{real:n,imag:s}}function Cd(e,t,n){const s=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(s),imag:Math.sin(s)}}const Ed="->",Ad=/->/g;function Rd(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(Ad,"").length)/Ed.length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[s,r]=e.split(Ed);u(-1===s.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const a=s.split(","),i=a.length;if(t!==i)throw new Error(`Expected ${i} input tensors, received ${t}`);if(i>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const o=[];for(let e=0;e<r.length;++e){const t=r[e];if(!a.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===o.indexOf(t)&&o.push(t)}for(let e=0;e<s.length;++e){const t=s[e];-1===o.indexOf(t)&&","!==t&&o.push(t)}const l=new Array(a.length);for(let e=0;e<i;++e){if(new Set(a[e].split("")).size!==a[e].length)throw new Error(`Found duplicate axes in input component ${a[e]}. Support for duplicate axes in input is not implemented yet.`);l[e]=[];for(let t=0;t<a[e].length;++t)l[e].push(o.indexOf(a[e][t]))}const c=o.length,h=[];for(let e=r.length;e<c;++e)h.push(e);return{allDims:o,summedDims:h,idDims:l}}function _d(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const s=[];for(let t=0;t<e;++t)-1===n[t]&&s.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:s}}function Fd(e,t,n){const s=new Array(e);for(let e=0;e<n.length;++e){const r=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===s[t[e][n]]?s[t[e][n]]=r[n]:u(s[t[e][n]]===r[n],(()=>`Expected dimension ${s[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(r)}, but got dimension ${r[n]}`))}}function Dd(e,t){const n=e,s=[];let r=0;0===e.length&&n.push(-1),r=e.length+1;for(let e=0;e<r;++e)s.push([]);const a=[];for(let e=0;e<n.length;++e){const r=Md(t,n[e]);for(const t of r)-1===a.indexOf(t)&&(s[e].push(t),a.push(t))}return{path:n,steps:s}}function Od(e){return e.every(((e,t)=>e===t))}function Md(e,t){const n=[];for(let s=0;s<e.length;++s)0!==e[s].length&&-1===e[s].indexOf(t)&&-1!==t||n.push(s);return n}function Ld(e,t,n=0){let s=[];if("number"==typeof t)u(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),s=new Array(t).fill(e.shape[n]/t);else{const r=t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0);u(r<=1,(()=>"There should be only one negative value in split array."));const a=t.indexOf(-1);if(-1!==a){const s=t.reduce(((e,t)=>t>0?e+t:e));t[a]=e.shape[n]-s}u(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),s=t}return s}function zd(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`}function Pd(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`}function Bd(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`}function Wd(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`}function Vd(e,t){return`size ${e} must be non-negative, not ${t}`}function Ud(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"}function Gd(e,t){return`Input to reshape is a SparseTensor with ${d(e)}\n  dense values, but the requested shape requires a multiple of ${d(t)}. inputShape=${e} outputShape= ${t}`}function Hd(e,t){return`Input to reshape is a tensor with ${d(e)} dense values, but the requested shape has ${d(t)}. inputShape=${e} outputShape=${t}`}function jd(){return"segment ids must be >= 0"}function qd(){return"segment ids are not increasing"}function Kd(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`}function Xd(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}function Yd(e,t){let n,s=!1;for(e<=30?(n=e,s=!0):n=O(e,Math.floor(Math.sqrt(e)));!s;)n>t||n===e?s=!0:n=O(e,n+1);return n}function Zd(e,t,n){const s=[],r=e.length;for(let a=0;a<r;a++)a!==t?s.push(e[a]):s.push(n);return s}function Jd(e,t,n,s){const r=t.shape.length,a=e.shape.length;if(0!==s&&(s<-r||s>r))throw new Error(`Expect batchDims in the range of [-${r}, ${r}], but got ${s}`);if(s<0&&(s+=r),s>a)throw new Error(`batchDims (${s}) must be less than rank(x) (\n    ${a}).`);if(n<s)throw new Error(`batchDims (${s}) must be less than or equal to axis (${n}).`);for(let n=0;n<s;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const i=e.shape[n],o=[];let l=1,u=1,c=1;for(let t=0;t<s;++t)o.push(e.shape[t]),l*=e.shape[t];for(let t=s;t<n;t++)o.push(e.shape[t]),u*=e.shape[t];for(let e=s;e<r;e++)o.push(t.shape[e]);for(let t=n+1;t<a;t++)o.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:i,outputShape:o}}var Qd=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:Yd,computeOutShape:Zd,collectGatherOpShapeInfo:Jd});function ef(e){try{return e.map((e=>rr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}}function tf(e){return e.map((e=>sr(e)))}var nf=Object.freeze({__proto__:null,slice_util:oo,segment_util:Qd,fromUint8ToStringArray:ef,fromStringArrayToUint8:tf,upcastType:$r,axesAreInnerMostDims:Vl,combineLocations:Ul,computeOutAndReduceShapes:Gl,expandShapeToKeepDim:Hl,assertAxesAreInnerMostDims:jl,getAxesPermutation:ql,getUndoAxesPermutation:Kl,getInnerMostAxes:Xl,getBroadcastDims:Ai,getReductionAxes:Ri,assertAndGetBroadcastShape:_i,assertParamsConsistent:rd,computeOutShape:ad,computeDilation2DInfo:Mo,computePool2DInfo:Lo,computePool3DInfo:zo,computeConv2DInfo:Po,computeConv3DInfo:Bo,computeDefaultPad:Wo,tupleValuesAreOne:jo,eitherStridesOrDilationsAreOne:qo,convertConv2DDataFormat:Ko,checkPadOnDimRoundingMode:Xo,getFusedDyActivation:Dh,getFusedBiasGradient:Oh,applyActivation:Mh,shouldFuse:Lh,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:id,getImageCenter:od,getReshaped:ld,getPermuted:ud,getReshapedPermuted:cd,getSliceBeginCoords:hd,getSliceSize:pd,prepareAndValidate:Bi,validateUpdateShape:Vi,validateInput:Ui,calculateShapes:Gi,SELU_SCALEALPHA:dd,SELU_SCALE:fd,ERF_P:md,ERF_A1:gd,ERF_A2:yd,ERF_A3:bd,ERF_A4:xd,ERF_A5:wd,warn:is,log:function(...e){X().getBool("IS_TEST")||X().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:vd,splitRealAndImagArrays:kd,complexWithEvenIndex:Nd,complexWithOddIndex:Id,getComplexWithIndex:Sd,assignToTypedArray:Td,exponents:$d,exponent:Cd,decodeEinsumEquation:Rd,getEinsumPermutation:_d,checkEinsumDimSizes:Fd,getEinsumComputePath:Dd,isIdentityPermutation:Od,prepareSplitSize:Ld,getSparseFillEmptyRowsIndicesDenseShapeMismatch:zd,getSparseFillEmptyRowsNegativeIndexErrorMessage:Pd,getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:Bd,getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:Wd,getSparseReshapeNegativeOutputDimErrorMessage:Vd,getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:Ud,getSparseReshapeInputOutputMultipleErrorMessage:Gd,getSparseReshapeInputOutputMismatchErrorMessage:Hd,getSparseSegmentReductionNegativeSegmentIdsErrorMessage:jd,getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:qd,getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:Kd,getSparseSegmentReductionIndicesOutOfRangeErrorMessage:Xd}),sf=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:np,nonMaxSuppressionV4Impl:sp,nonMaxSuppressionV5Impl:rp,whereImpl:kh});const rf={kernelName:Q,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,oh(qa(n,"float32"),-1))}}},af={kernelName:ee,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=tu(qa(n,"float32")),s=eu(Ru(Ql(1),t));return Si(vo(e,s))}}}},of={kernelName:te,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=eu(Ru(tu(qa(n,"float32")),1));return vo(e,t)}}}},lf={kernelName:ne,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{let t=e;const s=Ri(n.shape,r);return s.length>0&&(t=nu(t,s)),Yo(t,n.shape)},b:()=>{let t=e;const n=Ri(s.shape,r);return n.length>0&&(t=nu(t,n)),Yo(t,s.shape)}}}},uf={kernelName:se,saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach(((t,s)=>{n[s]=()=>e.clone()})),n}},cf={kernelName:ie,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Ml(n)}}},hf={kernelName:oe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Ml(n)}}},pf={kernelName:le,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,eu(Ru(Ql(1),tu(qa(n,"float32")))))}}},df={kernelName:ue,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=eu(xo(Ql(1),tu(qa(n,"float32"))));return vo(e,t)}}}},ff={kernelName:pe,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{const t=xo(tu(n),tu(s));let a=ko(e,vo(s,t));const i=Ri(n.shape,r);return i.length>0&&(a=nu(a,i)),Yo(a,n.shape)},b:()=>{const t=xo(tu(n),tu(s));let a=Si(ko(e,vo(n,t)));const i=Ri(s.shape,r);return i.length>0&&(a=nu(a,i)),Yo(a,s.shape)}}}},mf={kernelName:ce,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,xo(tu(qa(n,"float32")),1))}}},gf={kernelName:he,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,Ru(Ql(1),tu(qa(n,"float32"))))}}};const yf=Jr({avgPool3dGrad_:function(e,t,n,s,r,a){const i=Xr(e,"dy","avgPool3dGrad"),o=Xr(t,"input","avgPool3dGrad");let l=i,c=o,h=!1;4===o.rank&&(h=!0,l=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]]),c=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),u(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),u(5===c.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),Xo("avgPool3dGrad",r,a);const p={dy:l,input:c},d={filterSize:n,strides:s,pad:r,dimRoundingMode:a},f=Pr.runKernel(ge,p,d);return h?Yo(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}}),bf={kernelName:me,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i,dimRoundingMode:o}=n;return{x:()=>yf(e,s,r,a,i,o)}}};const xf=Jr({avgPoolGrad_:function(e,t,n,s,r){const a=Xr(e,"dy","avgPoolGrad"),i=Xr(t,"input","avgPoolGrad");u(i.rank===a.rank,(()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`));let o=i,l=a,c=!1;3===i.rank&&(c=!0,o=Yo(i,[1,i.shape[0],i.shape[1],i.shape[2]]),l=Yo(a,[1,a.shape[0],a.shape[1],a.shape[2]])),u(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),u(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},p={filterSize:n,strides:s,pad:r},d=Pr.runKernel(fe,h,p);return c?Yo(d,[d.shape[1],d.shape[2],d.shape[3]]):d}}),wf={kernelName:de,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{filterSize:r,strides:a,pad:i}=n;return{x:()=>xf(e,s,r,a,i)}}},vf={kernelName:ye,inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[s,r]=t,{transposeA:a,transposeB:i}=n;return a||i?!a&&i?{a:()=>di(e,r,!1,!1),b:()=>di(e,s,!0,!1)}:a&&!i?{a:()=>di(r,e,!1,!0),b:()=>di(s,e,!1,!1)}:{a:()=>di(r,e,!0,!0),b:()=>di(e,s,!0,!0)}:{a:()=>di(e,r,!1,!0),b:()=>di(s,e,!0,!1)}}},kf={kernelName:be,gradFunc:(e,t,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>uc(e,s,r)}}},Nf={kernelName:we,gradFunc:(e,t,n)=>{const s=n,r=s.inputShape,a=s.shape,i=Array.from(a);for(let e=r.length-1;e>=0;e--)if(r[e]===a[e])i[e]=1;else if(1!==r[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${a}].`);const o=[];for(let e=0;e<i.length;e++)i[e]>1&&o.push(e);return{x:()=>nu(e,o,!0)}}},If={kernelName:ke,gradFunc:e=>({x:()=>e.clone()})},Sf={kernelName:Ne,gradFunc:e=>({x:()=>Ml(e)})},Tf={kernelName:Ie,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{clipValueMin:r,clipValueMax:a}=n;return{x:()=>Ol(Du(mu(s,r),vu(s,a)),e,Ml(e))}}},$f={kernelName:Te,inputsToSave:["x"],gradFunc:rf.gradFunc},Cf={kernelName:$e,saveAllInputs:!0,gradFunc:(e,t,n)=>{const s=t.map((e=>e.shape)),{axis:r}=n,a=w(r,t[0].shape)[0],i=s.map((e=>e[a]));return nh(e,i,a).map((e=>()=>e))}},Ef={kernelName:Ce,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{dilations:a,strides:i,pad:o,dataFormat:l}=n;return u(jo(a),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`)),{x:()=>wl(s.shape,e,r,i,o,l),filter:()=>Fh(s,e,r.shape,i,o,l)}}},Af={kernelName:Ae,inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,{strides:a,pad:i,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>bl(e,r,a,i,o,1,l),filter:()=>Fh(e,s,r.shape,a,i,o,l)}}};const Rf=Jr({conv3DBackpropFilter_:function(e,t,n,s,r){let a=e;4===e.rank&&(a=Yo(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=Yo(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),u(5===a.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${a.shape}.`)),u(5===i.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${i.shape}.`)),u(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),u(a.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`)),u(i.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:a,dy:i},l={strides:s,pad:r,filterShape:n};return Pr.runKernel(_e,o,l)}}),_f={kernelName:Re,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a}=n;u(jo(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[i,o]=t;return{x:()=>Nl(i.shape,e,o,r,a),filter:()=>Rf(i,e,o.shape,r,a)}}},Ff={kernelName:De,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(Si(jc(qa(n,"float32"))),e)}}},Df={kernelName:Oe,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(qc(qa(n,"float32")),e)}}},Of={kernelName:Le,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r,exclusive:a,reverse:i}=n;return{x:()=>{const t=ql([r],s.rank);let n=Cl(e,r,a,!i);return null!=t&&(n=$i(n,t)),n}}}},Mf={kernelName:We,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:s,strides:r,pad:a,dimRoundingMode:i}=n,o=null==s?[1,1]:s;u(jo(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,c]=t;return u(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),u(4===c.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`)),u(l.shape[3]===c.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`)),u(qo(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),Xo("depthwiseConv2d",a,i),{x:()=>Bh(l.shape,e,c,r,a,o,i),filter:()=>Ph(l,e,c.shape,r,a,o,i)}}},Lf={kernelName:He,inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[s,r]=t,a={x:s,filter:r,dy:e},i={x:s,filter:r,dy:e};return{x:()=>Pr.runKernel(je,a,n),filter:()=>Pr.runKernel(qe,i,n)}}},zf={kernelName:Ye,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,s={dy:e,y:n};return{x:()=>Pr.runKernel(Ze,s)}}},Pf={kernelName:Je,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=ko(iu(Si(tu(n))),2/Math.sqrt(Math.PI));return{x:()=>ko(e,s)}}},Bf={kernelName:et,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,n)}}},Wf={kernelName:tt,inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>Yo(e,n.shape)}}},Vf={kernelName:nt,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,iu(n))}}},Uf={kernelName:it,gradFunc:e=>({x:()=>Ml(e)})},Gf={kernelName:ot,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{const t=vo(e,qa(s,"float32")),a=Ri(n.shape,r);return a.length>0?Yo(nu(t,a),n.shape):t},b:()=>{let t=ko(e,qa(n,"float32"));const a=Ri(s.shape,r);a.length>0&&(t=Yo(nu(t,a),s.shape));const i=tu(s);return Si(vo(t,qa(i,"float32")))}}}},Hf={kernelName:lt,inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:s}=n,[r,a,i,o]=t,l=null==o?Ql(1):o,u=Ri(a.shape,r.shape),c=[];if(1===a.rank){for(let e=0;e<r.shape.length-1;++e)c.push(r.shape[e]);c.push(1)}const h=Ru(r,a),p=ko(e,l),d=Wc(xo(i,Ql(s))),f=ko(ko(ko(d,d),d),Ql(-.5));return{x:()=>1===a.rank?Yo(ko(ko(e,uu(Yo(d,[1,1,1,a.shape[0]]),c)),l),r.shape):Yo(ko(ko(e,d),l),r.shape),mean:()=>{let e=ko(ko(d,Ql(-1)),p);return 1===a.rank&&(e=nu(e,u)),Yo(e,a.shape)},variance:()=>{let e=ko(ko(f,h),p);return 1===a.rank&&(e=nu(e,u)),Yo(e,a.shape)},scale:()=>{const t=ko(h,d);let n=ko(e,t);return 1===a.rank&&(n=nu(n,u)),Yo(n,a.shape)},offset:()=>{let t=e;return 1===a.rank&&(t=nu(t,u)),Yo(t,a.shape)}}}},jf={kernelName:ut,inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[s,r]=t,{axis:a}=n,i=w(a,s.shape)[0];return{x:()=>{const t=s.shape,n=r.size,o=t.slice(0,i),l=o.length,u=t.slice(a,t.length).slice(1),c=u.length,h=qf(0,l),p=qf(l+1,l+1+c),d=Kf([o,[n],u]),f=Yo(e,d),m=Yo(r,[n]),g=Kf([[l],h,p]),y=$i(f,g);let b=bh(y,m,s.shape[i]);const x=Kl(g);return b=$i(b,x),b},indices:()=>r}}};function qf(e,t){const n=[];for(let s=e;s<t;++s)n.push(s);return n}function Kf(e){const t=[];for(let n=0;n<e.length;++n)for(let s=0;s<e[n].length;++s)t.push(e[n][s]);return t}const Xf={kernelName:pt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>Ml(n),b:()=>Ml(s)}}},Yf={kernelName:dt,gradFunc:e=>({x:()=>qa(e,"float32")})},Zf={kernelName:gt,gradFunc:e=>({x:()=>Ml(e)})},Jf={kernelName:yt,gradFunc:e=>({x:()=>Ml(e)})},Qf={kernelName:bt,gradFunc:e=>({x:()=>Ml(e)})},em={kernelName:xt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{alpha:r}=n,a=fu(s,0);return{x:()=>Ol(a,e,ko(e,r))}}},tm={kernelName:It,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,xo(n,1))}}},nm={kernelName:Nt,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,qa(n,"float32"))}}},sm={kernelName:Ct,inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;return{logits:()=>{const t=iu(s);return Ru(e,ko(nu(e,r,!0),t))}}}};const rm=Jr({localResponseNormalizationBackprop_:function(e,t,n,s=5,r=1,a=1,i=.5){const o={x:e,y:t,dy:n},l={depthRadius:s,bias:r,alpha:a,beta:i};return Pr.runKernel(At,o,l)}}),am={kernelName:Et,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{depthRadius:a,bias:i,alpha:o,beta:l}=n;return{x:()=>rm(s,r,e,a,i,o,l)}}};function im(e,t,n,s){return t.rank<n.rank&&(t=Yo(t,Hl(t.shape,s))),e.rank<n.rank&&(e=Yo(e,Hl(e.shape,s))),{x:()=>ko(e,qa(Dl(n,t),e.dtype))}}const om={kernelName:Rt,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{reductionIndices:r}=s,a=t[0],i=im(e,t[1],a,w(r,a.shape));return{x:()=>i.x()}}},lm={kernelName:_t,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>ko(e,qa(mu(n,s),"float32")),b:()=>ko(e,qa(wu(n,s),"float32"))}}};const um=Jr({maxPool3dGrad_:function(e,t,n,s,r,a,i){const o=Xr(e,"dy","maxPool3dGrad"),l=Xr(t,"input","maxPool3dGrad"),c=Xr(n,"output","maxPool3dGrad");let h=o,p=l,d=c,f=!1;4===l.rank&&(f=!0,h=Yo(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),p=Yo(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),d=Yo(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]])),u(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),u(5===p.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${p.rank}.`)),u(5===d.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${d.rank}.`)),Xo("maxPool3dGrad",a,i);const m={dy:h,input:p,output:d},g={filterSize:s,strides:r,pad:a,dimRoundingMode:i},y=Pr.runKernel(Mt,m,g);return f?Yo(y,[y.shape[1],y.shape[2],y.shape[3],y.shape[4]]):y}}),cm={kernelName:Ot,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=n;return{x:()=>um(e,s,r,a,i,o,l)}}};const hm=Jr({maxPoolGrad_:function(e,t,n,s,r,a,i){const o=Xr(e,"dy","maxPoolGrad"),l=Xr(t,"input","maxPoolGrad"),c=Xr(n,"output","maxPoolGrad");u(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),u(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),u(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),Xo("maxPoolGrad",a,i);const h={dy:o,input:l,output:c},p={filterSize:s,strides:r,pad:a,dimRoundingMode:i};return Pr.runKernel(Dt,h,p)}}),pm={kernelName:Ft,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s,r]=t,{filterSize:a,strides:i,pad:o}=n;return{x:()=>hm(e,s,r,a,i,o)}}},dm={kernelName:Wt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>tl(e,a,s.shape)}}},fm={kernelName:Qt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const s=t[0],{paddings:r}=n,a=r.map((e=>e[0]));return{x:()=>tl(e,a,s.shape)}}},mm={kernelName:en,inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,s,r]=t,a=n,i=s,o=_i(a.shape,i.shape);return{a:()=>{const t=qa(i,"float32");let n=ko(e,ko(t,Jl(a,Ru(t,Ql(1)))));const s=Ri(a.shape,o);return s.length>0&&(n=nu(n,s)),Yo(n,a.shape)},b:()=>{const t=fu(a,0),n=Ol(t,Iu(a),Ml(a));let s=ko(e,ko(r,n));const l=Ri(i.shape,o);return l.length>0&&(s=nu(s,l)),Yo(s,i.shape)}}}};function gm(e,t,n){const s=e.shape.length,r=s-n.length,a=ql(n,s);let i=e;null!=a&&(i=$i(e,a));const o=i.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((e,t)=>e*t),1);o.push(l);let u=function(e,t,n){const s=e.shape.slice();s[n]=1;const r=Yo(t,s),a=$l(e,n,!0,!1),i=$l(e,n,!0,!0),o=ko(a,i);return ko(r,o)}(i.reshape(o),t,r);if(u=u.reshape(i.shape),null!=a){const e=Kl(a);u=$i(u,e)}return u}const ym={kernelName:wn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=fu(n,Ql(0)),s=Ql(dd),r=Ql(fd),a=ko(e,r),i=ko(ko(e,s),iu(qa(n,"float32")));return Ol(t,a,i)}}}},bm={kernelName:En,gradFunc:(e,t,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>rl(e,s,r)}}},xm={kernelName:An,gradFunc:(e,t,n)=>{const{axis:s}=n;return{x:()=>Qo(e,s)}}};const wm=[rf,af,of,lf,uf,cf,hf,pf,df,ff,mf,gf,bf,wf,vf,kf,Nf,If,Sf,Tf,$f,Cf,Af,Ef,_f,Ff,Df,Of,Mf,Lf,{kernelName:Ke,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{const t=vo(e,qa(s,"float32")),a=Ri(n.shape,r);return a.length>0?Yo(nu(t,a),n.shape):t},b:()=>{let t=ko(e,qa(n,"float32"));const a=Ri(s.shape,r);a.length>0&&(t=Yo(nu(t,a),s.shape));const i=tu(s);return Si(vo(t,qa(i,"float32")))}}}},zf,Pf,Bf,Wf,Vf,Gf,Uf,Hf,jf,Xf,Yf,Zf,Jf,Qf,em,tm,nm,sm,am,om,om,lm,cm,pm,{kernelName:zt,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n,a=w(r,s.shape),i=d(Gl(s.shape,a)[1]);return{x:()=>{const t=s.shape.slice();a.forEach((e=>{t[e]=1}));const n=Yo(e,t);return vo(ko(n,qu(s.shape,"float32")),i)}}}},{kernelName:Pt,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const s=n,{axis:r}=s,[a,i]=t,o=im(e,i,a,w(r,a.shape));return{x:()=>o.x()}}},{kernelName:Bt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t;return{a:()=>ko(e,qa(vu(n,s),"float32")),b:()=>ko(e,qa(fu(n,s),"float32"))}}},dm,{kernelName:Vt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{const t=Ri(n.shape,r);return t.length>0?Yo(nu(e,t),n.shape):e},b:()=>{const t=ko(e,Si(pu(vo(n,s)))),a=Ri(s.shape,r);return a.length>0?Yo(nu(t,a),s.shape):t}}}},{kernelName:Gt,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{const t=ko(e,qa(s,"float32")),a=Ri(n.shape,r);return a.length>0?Yo(nu(t,a),n.shape):t},b:()=>{const t=ko(e,qa(n,"float32")),a=Ri(s.shape,r);return a.length>0?Yo(nu(t,a),s.shape):t}}}},{kernelName:Ht,gradFunc:e=>({x:()=>Si(e)})},{kernelName:Zt,inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>ju(n.shape,"float32")}}},{kernelName:Yt,gradFunc:e=>({x:()=>Ml(e)})},{kernelName:Jt,saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:s}=n;return xh(e,s).map((e=>()=>e))}},fm,fm,mm,{kernelName:tn,inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,s]=t,r=fu(n,0);return{x:()=>Ol(r,e,ko(e,s)),alpha:()=>{let t=Ol(r,Ml(e),ko(e,n));const a=Ri(s.shape,e.shape);return a.length>0&&(t=nu(t,a)),Yo(t,s.shape)}}}},{kernelName:nn,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{axis:r}=n;let a=[];return a=null==r?s.shape.map(((e,t)=>t)):"number"==typeof r?[r]:r,{x:()=>gm(s,e,a)}}},{kernelName:an,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,Si(tu(n)))}}},{kernelName:dn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,s=ko(vu(n,6),oh(n));return{x:()=>ko(e,qa(s,"float32"))}}},{kernelName:on,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,qa(oh(n),"float32"))}}},{kernelName:ln,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Yo(e,n.shape)}}},{kernelName:hn,inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Pr.runKernel(pn,r,n)}}},{kernelName:un,inputsToSave:["images"],gradFunc:(e,t,n)=>{const[s]=t,r={dy:e,images:s};return{images:()=>Pr.runKernel(cn,r,n)}}},{kernelName:fn,gradFunc:(e,t,n)=>{const{dims:s}=n,r=w(s,e.shape);return{x:()=>Oc(e,r)}}},{kernelName:mn,gradFunc:e=>({x:()=>Ml(e)})},{kernelName:gn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Si(vo(e,ko(Jl(n,1.5),2)))}}},{kernelName:xn,inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>qa(Ml(n),"float32"),t:()=>ko(e,qa(n,e.dtype)),e:()=>ko(e,qa(Ou(n),e.dtype))}}},ym,{kernelName:Sn,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,ko(n,Ru(Ql(1),n)))}}},{kernelName:In,gradFunc:e=>({x:()=>Ml(e)})},{kernelName:kn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(Sl(qa(n,"float32")),e)}}},{kernelName:Nn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(Tl(qa(n,"float32")),e)}}},{kernelName:vn,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{begin:r,size:a}=n,i=s.shape,[o,l]=ro(s,r,a),u=[];for(let t=0;t<e.rank;t++)u.push([o[t],i[t]-o[t]-l[t]]);return{x:()=>rc(e,u)}}},{kernelName:Rn,outputsToSave:[!0],gradFunc:(e,t,n)=>{const[s]=t,{dim:r}=n,a=ko(e,s);return{logits:()=>Ru(a,ko(nu(a,[r],true),s))}}},{kernelName:Tn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,el(n))}}},bm,bm,xm,xm,{kernelName:$n,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,ko(eu(qa(n,"float32")),2))}}},{kernelName:Ln,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=Ql(2);return{a:()=>ko(e,ko(r,Ru(n,s))),b:()=>ko(e,ko(r,Ru(s,n)))}}},{kernelName:zn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(e,ko(qa(n,"float32"),2))}}},{kernelName:es,gradFunc:e=>({x:()=>Ml(e)})},{kernelName:Un,inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,s]=t,r=_i(n.shape,s.shape);return{a:()=>{let t=e;const s=Ri(n.shape,r);return s.length>0&&(t=nu(t,s)),Yo(t,n.shape)},b:()=>{let t=e;const n=Ri(s.shape,r);return n.length>0&&(t=nu(t,n)),Yo(Si(t),s.shape)}}}},{kernelName:Cn,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,r=s.shape.slice(),{axis:a}=n;w(a,s.shape).forEach((e=>{r[e]=1}));const i=Yo(e,r),o=ko(i,qu(s.shape,"float32"));return{x:()=>o}}},{kernelName:Gn,inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>vo(e,tu(Sl(n)))}}},{kernelName:Hn,outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>ko(Ru(Ql(1),tu(n)),e)}}},{kernelName:jn,inputsToSave:["x"],gradFunc:(e,t,n)=>{const[s]=t,{reps:r}=n;return{x:()=>{let t=Ml(s);if(1===s.rank)for(let n=0;n<r[0];++n)t=xo(t,tl(e,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)t=xo(t,tl(e,[n*s.shape[0],a*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)t=xo(t,tl(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let a=0;a<r[1];++a)for(let i=0;i<r[2];++i)for(let o=0;o<r[3];++o)t=xo(t,tl(e,[n*s.shape[0],a*s.shape[1],i*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return t}}}},{kernelName:Xn,gradFunc:(e,t,n)=>{const s=n,{perm:r}=s,a=Kl(r);return{x:()=>$i(e,a)}}},{kernelName:Zn,gradFunc:(e,t,n)=>{const s=n,{axis:r}=s;return{value:()=>ih(e,r)}}},{kernelName:Jn,inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=Gu(t,Ml(t)),s=du(e,n);let r=mu(t,Ql(0,"int32"));const a=s.rank-r.rank;for(let e=0;e<a;++e)r=ou(r,e+1);r=Du(r,qu(s.shape,"bool"));const i=Ml(s);return Ol(r,s,i)}(e,n)}}},{kernelName:Qn,gradFunc:e=>({x:()=>Ml(e)})}];for(const e of wm)ds(e);xr().prototype.abs=function(){return this.throwIfDisposed(),No(this)},xr().prototype.acos=function(){return this.throwIfDisposed(),Io(this)},xr().prototype.acosh=function(){return this.throwIfDisposed(),So(this)},xr().prototype.add=function(e){return this.throwIfDisposed(),xo(this,e)},xr().prototype.all=function(e,t){return this.throwIfDisposed(),$o(this,e,t)},xr().prototype.any=function(e,t){return this.throwIfDisposed(),Co(this,e,t)},xr().prototype.argMax=function(e){return this.throwIfDisposed(),Eo(this,e)},xr().prototype.argMin=function(e){return this.throwIfDisposed(),Ao(this,e)},xr().prototype.asScalar=function(){return this.throwIfDisposed(),u(1===this.size,(()=>"The array must have only 1 element.")),Yo(this,[])},xr().prototype.asType=function(e){return this.throwIfDisposed(),qa(this,e)},xr().prototype.as1D=function(){return this.throwIfDisposed(),Yo(this,[this.size])},xr().prototype.as2D=function(e,t){return this.throwIfDisposed(),Yo(this,[e,t])},xr().prototype.as3D=function(e,t,n){return this.throwIfDisposed(),Yo(this,[e,t,n])},xr().prototype.as4D=function(e,t,n,s){return this.throwIfDisposed(),Yo(this,[e,t,n,s])},xr().prototype.as5D=function(e,t,n,s,r){return this.throwIfDisposed(),Yo(this,[e,t,n,s,r])},xr().prototype.asin=function(){return this.throwIfDisposed(),Ro(this)},xr().prototype.asinh=function(){return this.throwIfDisposed(),_o(this)},xr().prototype.atan=function(){return this.throwIfDisposed(),Fo(this)},xr().prototype.atan2=function(e){return this.throwIfDisposed(),Do(this,e)},xr().prototype.atanh=function(){return this.throwIfDisposed(),Oo(this)},xr().prototype.avgPool=function(e,t,n,s){return this.throwIfDisposed(),Zo(this,e,t,n,s)},xr().prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),rl(this,e,t)},xr().prototype.batchNorm=function(e,t,n,s,r){return this.throwIfDisposed(),al(this,e,t,n,s,r)},xr().prototype.broadcastTo=function(e){return this.throwIfDisposed(),hl(this,e)},xr().prototype.cast=function(e){return this.throwIfDisposed(),qa(this,e)},xr().prototype.ceil=function(){return this.throwIfDisposed(),pl(this)},xr().prototype.clipByValue=function(e,t){return this.throwIfDisposed(),dl(this,e,t)},xr().prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof br&&(e=[e]),Qo([this,...e],t)},xr().prototype.conv1d=function(e,t,n,s,r,a){return this.throwIfDisposed(),xl(this,e,t,n,s,r,a)},xr().prototype.conv2dTranspose=function(e,t,n,s,r){return this.throwIfDisposed(),vl(this,e,t,n,s,r)},xr().prototype.conv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),bl(this,e,t,n,s,r,a)},xr().prototype.cos=function(){return this.throwIfDisposed(),Sl(this)},xr().prototype.cosh=function(){return this.throwIfDisposed(),Tl(this)},xr().prototype.cumprod=function(e,t,n){return this.throwIfDisposed(),$l(this,e,t,n)},xr().prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),Cl(this,e,t,n)},xr().prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),Al(this,e,t)},xr().prototype.depthwiseConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Rl(this,e,t,n,s,r,a)},xr().prototype.dilation2d=function(e,t,n,s,r){return this.throwIfDisposed(),Fl(this,e,t,n,s,r)},xr().prototype.divNoNan=function(e){return this.throwIfDisposed(),Ll(this,e)},xr().prototype.div=function(e){return this.throwIfDisposed(),vo(this,e)},xr().prototype.dot=function(e){return this.throwIfDisposed(),zl(this,e)},xr().prototype.elu=function(){return this.throwIfDisposed(),Bl(this)},xr().prototype.equal=function(e){return this.throwIfDisposed(),Dl(this,e)},xr().prototype.erf=function(){return this.throwIfDisposed(),Wl(this)},xr().prototype.euclideanNorm=function(e,t){return this.throwIfDisposed(),au(this,e,t)},xr().prototype.exp=function(){return this.throwIfDisposed(),iu(this)},xr().prototype.expandDims=function(e){return this.throwIfDisposed(),ou(this,e)},xr().prototype.expm1=function(){return this.throwIfDisposed(),lu(this)},xr().prototype.fft=function(){return this.throwIfDisposed(),Qc(this)},xr().prototype.flatten=function(){return this.throwIfDisposed(),Yo(this,[this.size])},xr().prototype.floor=function(){return this.throwIfDisposed(),pu(this)},xr().prototype.floorDiv=function(e){return this.throwIfDisposed(),wo(this,e)},xr().prototype.gather=function(e,t){return this.throwIfDisposed(),du(this,e,t)},xr().prototype.greaterEqual=function(e){return this.throwIfDisposed(),mu(this,e)},xr().prototype.greater=function(e){return this.throwIfDisposed(),fu(this,e)},xr().prototype.ifft=function(){return this.throwIfDisposed(),eh(this)},xr().prototype.irfft=function(){return this.throwIfDisposed(),th(this)},xr().prototype.isFinite=function(){return this.throwIfDisposed(),gu(this)},xr().prototype.isInf=function(){return this.throwIfDisposed(),yu(this)},xr().prototype.isNaN=function(){return this.throwIfDisposed(),bu(this)},xr().prototype.leakyRelu=function(e){return this.throwIfDisposed(),xu(this,e)},xr().prototype.lessEqual=function(e){return this.throwIfDisposed(),vu(this,e)},xr().prototype.less=function(e){return this.throwIfDisposed(),wu(this,e)},xr().prototype.localResponseNormalization=function(e,t,n,s){return this.throwIfDisposed(),Nu(this,e,t,n,s)},xr().prototype.logSigmoid=function(){return this.throwIfDisposed(),Au(this)},xr().prototype.logSoftmax=function(e){return this.throwIfDisposed(),_u(this,e)},xr().prototype.logSumExp=function(e,t){return this.throwIfDisposed(),Fu(this,e,t)},xr().prototype.log=function(){return this.throwIfDisposed(),Iu(this)},xr().prototype.log1p=function(){return this.throwIfDisposed(),Su(this)},xr().prototype.logicalAnd=function(e){return this.throwIfDisposed(),Du(this,e)},xr().prototype.logicalNot=function(){return this.throwIfDisposed(),Ou(this)},xr().prototype.logicalOr=function(e){return this.throwIfDisposed(),Mu(this,e)},xr().prototype.logicalXor=function(e){return this.throwIfDisposed(),Lu(this,e)},xr().prototype.matMul=function(e,t,n){return this.throwIfDisposed(),di(this,e,t,n)},xr().prototype.maxPool=function(e,t,n,s){return this.throwIfDisposed(),Wu(this,e,t,n,s)},xr().prototype.max=function(e,t){return this.throwIfDisposed(),Yl(this,e,t)},xr().prototype.maximum=function(e){return this.throwIfDisposed(),Gu(this,e)},xr().prototype.mean=function(e,t){return this.throwIfDisposed(),Hu(this,e,t)},xr().prototype.min=function(e,t){return this.throwIfDisposed(),Zl(this,e,t)},xr().prototype.minimum=function(e){return this.throwIfDisposed(),Xu(this,e)},xr().prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),Yu(this,e,t)},xr().prototype.mod=function(e){return this.throwIfDisposed(),Zu(this,e)},xr().prototype.mul=function(e){return this.throwIfDisposed(),ko(this,e)},xr().prototype.neg=function(){return this.throwIfDisposed(),Si(this)},xr().prototype.norm=function(e,t,n){return this.throwIfDisposed(),ru(this,e,t,n)},xr().prototype.notEqual=function(e){return this.throwIfDisposed(),tc(this,e)},xr().prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),fi(this,e,t,n)},xr().prototype.onesLike=function(){return this.throwIfDisposed(),nc(this)},xr().prototype.pad=function(e,t){return this.throwIfDisposed(),rc(this,e,t)},xr().prototype.pool=function(e,t,n,s,r,a){return this.throwIfDisposed(),cc(this,e,t,n,s,r,a)},xr().prototype.pow=function(e){return this.throwIfDisposed(),Jl(this,e)},xr().prototype.prelu=function(e){return this.throwIfDisposed(),hc(this,e)},xr().prototype.prod=function(e,t){return this.throwIfDisposed(),pc(this,e,t)},xr().prototype.reciprocal=function(){return this.throwIfDisposed(),_c(this)},xr().prototype.relu=function(){return this.throwIfDisposed(),Fc(this)},xr().prototype.relu6=function(){return this.throwIfDisposed(),Dc(this)},xr().prototype.reshapeAs=function(e){return this.throwIfDisposed(),Yo(this,e.shape)},xr().prototype.reshape=function(e){return this.throwIfDisposed(),Yo(this,e)},xr().prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),fp(this,e,t,n)},xr().prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),mp(this,e,t,n)},xr().prototype.reverse=function(e){return this.throwIfDisposed(),Oc(this,e)},xr().prototype.rfft=function(){return this.throwIfDisposed(),sh(this)},xr().prototype.round=function(){return this.throwIfDisposed(),Bc(this)},xr().prototype.rsqrt=function(){return this.throwIfDisposed(),Wc(this)},xr().prototype.selu=function(){return this.throwIfDisposed(),Vc(this)},xr().prototype.separableConv2d=function(e,t,n,s,r,a){return this.throwIfDisposed(),Uc(this,e,t,n,s,r,a)},xr().prototype.sigmoid=function(){return this.throwIfDisposed(),el(this)},xr().prototype.sign=function(){return this.throwIfDisposed(),Hc(this)},xr().prototype.sin=function(){return this.throwIfDisposed(),jc(this)},xr().prototype.sinh=function(){return this.throwIfDisposed(),qc(this)},xr().prototype.slice=function(e,t){return this.throwIfDisposed(),tl(this,e,t)},xr().prototype.softmax=function(e){return this.throwIfDisposed(),Jc(this,e)},xr().prototype.softplus=function(){return this.throwIfDisposed(),Eu(this)},xr().prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),uc(this,e,t)},xr().prototype.split=function(e,t){return this.throwIfDisposed(),nh(this,e,t)},xr().prototype.sqrt=function(){return this.throwIfDisposed(),eu(this)},xr().prototype.square=function(){return this.throwIfDisposed(),tu(this)},xr().prototype.squaredDifference=function(e){return this.throwIfDisposed(),rh(this,e)},xr().prototype.squeeze=function(e){return this.throwIfDisposed(),ah(this,e)},xr().prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof br?[this,e]:[this,...e];return ih(n,t)},xr().prototype.step=function(e){return this.throwIfDisposed(),oh(this,e)},xr().prototype.stridedSlice=function(e,t,n,s,r,a,i,o){return this.throwIfDisposed(),lh(this,e,t,n,s,r,a,i,o)},xr().prototype.sub=function(e){return this.throwIfDisposed(),Ru(this,e)},xr().prototype.sum=function(e,t){return this.throwIfDisposed(),nu(this,e,t)},xr().prototype.tan=function(){return this.throwIfDisposed(),uh(this)},xr().prototype.tanh=function(){return this.throwIfDisposed(),nl(this)},xr().prototype.tile=function(e){return this.throwIfDisposed(),uu(this,e)},xr().prototype.toBool=function(){return this.throwIfDisposed(),qa(this,"bool")},xr().prototype.toFloat=function(){return this.throwIfDisposed(),qa(this,"float32")},xr().prototype.toInt=function(){return this.throwIfDisposed(),qa(this,"int32")},xr().prototype.topk=function(e,t){return this.throwIfDisposed(),mh(this,e,t)},xr().prototype.transpose=function(e){return this.throwIfDisposed(),$i(this,e)},xr().prototype.unique=function(e){return this.throwIfDisposed(),yh(this,e)},xr().prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),bh(this,e,t)},xr().prototype.unstack=function(e){return this.throwIfDisposed(),xh(this,e)},xr().prototype.where=function(e,t){return this.throwIfDisposed(),Ol(e,this,t)},xr().prototype.zerosLike=function(){return this.throwIfDisposed(),Ml(this)};class vm extends Error{constructor(e){super(e),Object.setPrototypeOf(this,vm.prototype)}}class km extends Error{constructor(e){super(e),Object.setPrototypeOf(this,km.prototype)}}class Nm extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Nm.prototype)}}class Im extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Im.prototype)}}class Sm extends Error{constructor(e){super(e),Object.setPrototypeOf(this,Sm.prototype)}}Error;class Tm{constructor(e){this.maxEntries=e||100,this.cache=new Map}get(e){let t;return this.cache.has(e)&&(t=this.cache.get(e),this.cache.delete(e),this.cache.set(e,t)),t}put(e,t){if(this.cache.has(e))this.cache.delete(e);else if(this.cache.size>=this.maxEntries){const e=this.cache.keys().next().value;this.cache.delete(e)}this.cache.set(e,t)}getMaxEntries(){return this.maxEntries}setMaxEntries(e){if(e<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${e}.`);if(this.maxEntries>e)for(let t=0;t<this.maxEntries-e;t++){const e=this.cache.keys().next().value;this.cache.delete(e)}this.maxEntries=e}}function $m(e,t){if(Array.isArray(e)){let n=[];for(let s=0;s<t;s++)n=n.concat(e);return n}{const n=new Array(t);return n.fill(e),n}}function Cm(e,t){if(!e)throw new Sm(t)}function Em(e,t){let n=0;for(const s of e)s===t&&n++;return n}function Am(e){return 1===e.length?e[0]:e}function Rm(e){return Array.isArray(e)?e:[e]}function _m(e){const t=e.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==t[0]?t:"private"+t}function Fm(e){return e.length<=1||-1===e.indexOf("_")?e:e.replace(/[_]+(\w|$)/g,((e,t)=>t.toUpperCase()))}let Dm={};function Om(e){if(null==e)return null;const t={};return t.className=e.getClassName(),t.config=e.getConfig(),t}function Mm(e){if(null!=e&&"object"==typeof e)if(Array.isArray(e))e.forEach((e=>Mm(e)));else{const t=Object.keys(e);for(const n of t){const t=e[n];null!=t&&"object"==typeof t&&(Array.isArray(t)||"ndarray"!==t.type||"number"!=typeof t.value?Mm(t):e[n]=t.value)}}}function Lm(e,t={},n={},s="object",r=!1){if("string"==typeof e){const r=e;let a;if(r in n)a=n[r];else if(r in Dm)a=Dm[r];else if(a=t[r],null==a)throw new Nm(`Unknown ${s}: ${e}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return a}{const a=e;if(null==a.className||null==a.config)throw new Nm(`${s}: Improper config format: ${JSON.stringify(a)}.\n'className' and 'config' must set.`);const i=a.className;let o,l;if(i in n?[o,l]=n[i]:i in Dm?[o,l]=Dm.className:i in t&&([o,l]=t[i]),null==o)throw new Nm(`Unknown ${s}: ${i}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const e={};for(const t of Object.keys(Dm))e[t]=Dm[t];for(const t of Object.keys(n))e[t]=n[t];a.config.customObjects=e;const t=Object.assign({},Dm);for(const e of Object.keys(n))Dm[e]=n[e];Mm(a.config);const s=l(o,a.config,n,r);return Dm=Object.assign({},t),s}{const e=Object.assign({},Dm);for(const e of Object.keys(n))Dm[e]=n[e];const t=new o(a.config);return Dm=Object.assign({},e),t}}}function zm(e,t){return-1*function(e,t){return e<t?-1:e>t?1:0}(e,t)}function Pm(e){if(null==e)return e;const t=[];for(const n of e)-1===t.indexOf(n)&&t.push(n);return t}function Bm(e){if(null==e)throw new Nm(`Invalid value in obj: ${JSON.stringify(e)}`);for(const t in e)if(e.hasOwnProperty(t))return!1;return!0}function Wm(e,t,n){if(null!=n&&e.indexOf(n)<0)throw new Nm(`${n} is not a valid ${t}.  Valid values are ${e} or null/undefined.`)}function Vm(e,t,n=0,s=1/0){return Cm(n>=0),Cm(s>=n),Array.isArray(e)&&e.length>=n&&e.length<=s&&e.every((e=>typeof e===t))}function Um(e,t){Array.isArray(e)?(u(e.length>0,(()=>`${t} is unexpectedly an empty array.`)),e.forEach(((e,n)=>Um(e,`element ${n+1} of ${t}`)))):u(Number.isInteger(e)&&e>0,(()=>`Expected ${t} to be a positive integer, but got ${Gm(e)}.`))}function Gm(e){return null===e?"null":Array.isArray(e)?"["+e.map((e=>Gm(e))).join(",")+"]":"string"==typeof e?`"${e}"`:`${e}`}function Hm(e){return"relu"===e?"relu":"linear"===e?"linear":"elu"===e?"elu":null}let jm=0;function qm(){return jm++}const Km={};function Xm(e=""){return e in Km||(Km[e]=0),Km[e]+=1,e+Km[e].toString()}const Ym=["channelsFirst","channelsLast"],Zm=["nearest","bilinear"],Jm=["valid","same","causal"],Qm=["max","avg"],eg=["sum","mul","concat","ave"],tg=new Map;function ng(e){Wm(Ym,"DataFormat",e)}function sg(e){Wm(Jm,"PaddingMode",e)}function rg(e){Wm(Qm,"PoolMode",e)}const ag=[];function ig(e,t){ag.push(e);try{const e=t();return ag.pop(),e}catch(e){throw ag.pop(),e}}function og(e){if(!cg(e))throw new Error("Not a valid tensor name: '"+e+"'");return(0===ag.length?"":ag.join("/")+"/")+e}function lg(e){if(!cg(e))throw new Error("Not a valid tensor name: '"+e+"'");tg.has(e)||tg.set(e,0);const t=tg.get(e);if(tg.set(e,tg.get(e)+1),t>0){const n=`${e}_${t}`;return tg.set(n,1),n}return e}const ug=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function cg(e){return!!e.match(ug)}function hg(e,t,n){null==t&&(t=0),null==n&&(n=e.length);let s=1;for(let r=t;r<n;++r)s*=e[r];return s}function pg(e){if(0===e.length)return Number.NaN;let t=Number.POSITIVE_INFINITY;for(let n=0;n<e.length;n++){const s=e[n];s<t&&(t=s)}return t}function dg(e){if(0===e.length)return Number.NaN;let t=Number.NEGATIVE_INFINITY;for(let n=0;n<e.length;n++){const s=e[n];s>t&&(t=s)}return t}function fg(e,t){if(t<e)throw new Nm(`end (${t}) < begin (${e}) is forbidden.`);const n=[];for(let s=e;s<t;++s)n.push(s);return n}let mg;function gg(){return null==mg&&(mg=Ni().epsilon()),mg}function yg(e,t){return qa(e,t)}function bg(e,t=-1){const n=e.shape.slice();return t<0&&(t=n.length+t+1),n.splice(t,0,1),Yo(e,n)}function xg(e,t,n){return bi((()=>{switch(e.rank){case 1:return Kc(e,t,n);case 2:return Xc(e,[t,0],[n,e.shape[1]]);case 3:return Yc(e,[t,0,0],[n,e.shape[1],e.shape[2]]);case 4:return Zc(e,[t,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3]]);case 5:return tl(e,[t,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return tl(e,[t,0,0,0,0,0],[n,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new Nm(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function wg(e,t,n){return bi((()=>{switch(e.rank){case 1:return Kc(e,t,n);case 2:return Xc(e,[0,t],[e.shape[0],n]);case 3:return Yc(e,[0,0,t],[e.shape[0],e.shape[1],n]);case 4:return Zc(e,[0,0,0,t],[e.shape[0],e.shape[1],e.shape[2],n]);default:throw new Nm(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function vg(e,t,n,s){return bi((()=>{switch(e.rank){case 1:return Kc(e,t,n);case 2:switch(s){case 1:return xg(e,t,n);case 2:return wg(e,t,n);default:throw new Nm(`The axis is not within the rank of the tensor ${s}`)}case 3:switch(s){case 1:return xg(e,t,n);case 2:return Yc(e,[0,t,0],[e.shape[0],n,e.shape[2]]);case 3:return wg(e,t,n);default:throw new Nm(`The axis is not within the rank of the tensor ${s}`)}case 4:switch(s){case 1:return xg(e,t,n);case 2:return Zc(e,[0,t,0,0],[e.shape[0],n,e.shape[2],e.shape[3]]);case 3:return Zc(e,[0,0,t,0],[e.shape[0],e.shape[1],n,e.shape[3]]);case 4:return wg(e,t,n);default:throw new Nm(`The axis is not within the rank of the tensor ${s}`)}default:throw new Nm(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function kg(e,t=-1){let n;return t<0&&(n=e[0].rank,t=0!==n?n:0),t===e[0].rank&&(t=-1),Qo(e,t)}function Ng(e,t){switch(e.rank){case 1:return fl([e,t]);case 2:return ml([e,t],0);case 3:return gl([e,t],0);case 4:return yl([e,t],0);default:throw new Nm(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}function Ig(e,t){if(Array.isArray(t)||(t=[t]),e.rank!==t.length)throw new Nm(`The length of input n (${t.length}) does not match the number of dimensions in input x (${e.rank})`);return uu(e,t)}function Sg(e,t=0,n=1,s,r){return Cc(e,t,n,s,r)}function Tg(e,t,n,s){if(e.rank<2||t.rank<2)throw new Im(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${t.shape}`);if(t.rank>=3){if(e.shape.slice(-1)[0]!==t.shape.slice(-2)[0])throw new Im(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${t.shape}`)}if(2===e.rank&&2===t.rank){return Vh({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Eg(e.rank,s,"channelsLast"):null,activation:n})}{const r=e.shape.slice(),a=r.pop();e=Yo(e,[-1,a]);const i=t.shape.slice(),o=i.pop(),l=i.pop(),u=[...i,o],c=Array.from({length:t.rank},((e,n)=>0===n?t.rank-2:n<=t.rank-2?n-1:n));t=Yo($i(t,c),[l,-1]);const h=[...r,...u];return Yo(Vh({a:e,b:t,transposeA:!1,transposeB:!1,bias:s?Eg(e.rank,s,"channelsLast"):null,activation:n}),h)}}function $g(e,t,n){return bi((()=>(t=Array.isArray(t)?ch(t,"int32"):qa(t,"int32"),du(e,t,n))))}function Cg(e){return ko(e,e)}function Eg(e,t,n){const s=t.shape;if(1!==t.rank&&t.rank!==e)throw new Nm(`Unexpected bias dimensions: ${t.rank}; expected it to be 1 or ${e}`);if(5===e){if("channelsFirst"===n)return 1===s.length?Yo(t,[1,s[0],1,1,1]):Yo(t,[1,s[3],s[0],s[1],s[2]]);if("channelsLast"===n)return 1===s.length?Yo(t,[1,1,1,1,s[0]]):Yo(t,[1].concat(s))}else if(4===e){if("channelsFirst"===n)return 1===s.length?Yo(t,[1,s[0],1,1]):Yo(t,[1,s[2],s[0],s[1]]);if("channelsLast"===n)return 1===s.length?Yo(t,[1,1,1,s[0]]):Yo(t,[1].concat(s))}else if(3===e){if("channelsFirst"===n)return 1===s.length?Yo(t,[1,s[0],1]):Yo(t,[1,s[1],s[0]]);if("channelsLast"===n)return 1===s.length?Yo(t,[1,1,s[0]]):Yo(t,[1].concat(s))}else if(e<3)return t;throw new Nm(`Unsupported input rank by biasAdd: ${t.rank}`)}function Ag(e,t,n){return bi((()=>(null==n&&(n="channelsLast"),ng(n),xo(e,Eg(e.rank,t,n)))))}function Rg(e,t,n,s){return bi((()=>Eh(e,t,n,s)))}function _g(e,t,n=!1){return n?e():t()}const Fg=["fanIn","fanOut","fanAvg"],Dg=["normal","uniform","truncatedNormal"];class Og extends lo{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class Mg extends Og{apply(e,t){return ju(e,t)}}Mg.className="Zeros",co(Mg);class Lg extends Og{apply(e,t){return qu(e,t)}}Lg.className="Ones",co(Lg);class zg extends Og{constructor(e){if(super(),"object"!=typeof e)throw new Nm(`Expected argument of type ConstantConfig but got ${e}`);if(void 0===e.value)throw new Nm(`config must have value set but got ${e}`);this.value=e.value}apply(e,t){return bi((()=>ko(Ql(this.value),qu(e,t))))}getConfig(){return{value:this.value}}}zg.className="Constant",co(zg);class Pg extends Og{constructor(e){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=e.minval||this.DEFAULT_MINVAL,this.maxval=e.maxval||this.DEFAULT_MAXVAL,this.seed=e.seed}apply(e,t){return Ac(e,this.minval,this.maxval,t)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}Pg.className="RandomUniform",co(Pg);class Bg extends Og{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Im(`randomNormal does not support dType ${t}.`);return Sg(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Bg.className="RandomNormal",co(Bg);class Wg extends Og{constructor(e){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=e.mean||this.DEFAULT_MEAN,this.stddev=e.stddev||this.DEFAULT_STDDEV,this.seed=e.seed}apply(e,t){if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Im(`truncatedNormal does not support dType ${t}.`);return gh(e,this.mean,this.stddev,t,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Wg.className="TruncatedNormal",co(Wg);class Vg extends Og{constructor(e){super(),this.gain=null!=e.gain?e.gain:1}apply(e,t){return bi((()=>{if(2!==e.length||e[0]!==e[1])throw new Nm("Identity matrix initializer can only be used for 2D square matrices.");return ko(this.gain,cu(e[0]))}))}getConfig(){return{gain:this.gain}}}Vg.className="Identity",co(Vg);class Ug extends Og{constructor(e){if(super(),e.scale<0)throw new Nm(`scale must be a positive float. Got: ${e.scale}`);var t;this.scale=null==e.scale?1:e.scale,this.mode=null==e.mode?"fanIn":e.mode,t=this.mode,Wm(Fg,"FanMode",t),this.distribution=null==e.distribution?"normal":e.distribution,function(e){Wm(Dg,"Distribution",e)}(this.distribution),this.seed=e.seed}apply(e,t){const n=function(e,t="channelsLast"){let n,s;if(ng(t),2===e.length)n=e[0],s=e[1];else if(-1!==[3,4,5].indexOf(e.length)){if("channelsFirst"===t){const t=hg(e,2);n=e[1]*t,s=e[0]*t}else if("channelsLast"===t){const t=hg(e,0,e.length-2);n=e[e.length-2]*t,s=e[e.length-1]*t}}else{const t=hg(e);n=Math.sqrt(t),s=Math.sqrt(t)}return[n,s]}(e),s=n[0],r=n[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,s):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(a);if("float32"!==(t=t||"float32")&&"int32"!==t)throw new Im(`${this.getClassName()} does not support dType ${t}.`);return gh(e,0,n,t,this.seed)}{const n=Math.sqrt(3*a);return Ac(e,-n,n,t)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}Ug.className="VarianceScaling",co(Ug);class Gg extends Ug{constructor(e){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}Gg.className="GlorotUniform",co(Gg);class Hg extends Ug{constructor(e){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}Hg.className="GlorotNormal",co(Hg);class jg extends Ug{constructor(e){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}jg.className="HeNormal",co(jg);class qg extends Ug{constructor(e){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}qg.className="HeUniform",co(qg);class Kg extends Ug{constructor(e){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}Kg.className="LeCunNormal",co(Kg);class Xg extends Ug{constructor(e){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==e?null:e.seed})}getClassName(){return Ug.className}}Xg.className="LeCunNormal",co(Xg);class Yg extends Og{constructor(e){if(super(),this.DEFAULT_GAIN=1,this.gain=null==e.gain?this.DEFAULT_GAIN:e.gain,this.seed=e.seed,null!=this.seed)throw new Im("Random seed is not implemented for Orthogonal Initializer yet.")}apply(e,t){return bi((()=>{if(e.length<2)throw new Im("Shape must be at least 2D.");e[0]*e[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${e[0]*e[1]}) elements: Slowness may result.`);const t=Sg(e[0]>e[1]?[e[1],e[0]]:e,0,1,"float32");let n=Vp.gramSchmidt(t);return e[0]>e[1]&&(n=$i(n)),ko(this.gain,n)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}Yg.className="Orthogonal",co(Yg);const Zg={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function Jg(e,t={}){return Lm(e,uo.getMap().classNameMap,t,"initializer")}function Qg(e){return Om(e)}function ey(e){if("string"==typeof e){const t=e in Zg?Zg[e]:e;if("GlorotNormal"===t)return new Hg;if("GlorotUniform"===t)return new Gg;if("HeNormal"===t)return new jg;if("HeUniform"===t)return new qg;if("LeCunNormal"===t)return new Kg;if("LeCunUniform"===t)return new Xg;{const e={};return e.className=t,e.config={},Jg(e)}}return e instanceof Og?e:Jg(e)}function ty(e){return Array.isArray(e)&&Array.isArray(e[0])}function ny(e){return 0===e.length?[]:Array.isArray(e[0])?e:[e]}function sy(e){let t;if(Array.isArray(e)){if(1!==e.length)throw new Nm(`Expected Tensor length to be 1; got ${e.length}`);t=e[0]}else t=e;return t}function ry(e){if(Array.isArray(e)&&Array.isArray(e[0])){if(1===e.length)return e[0];throw new Nm(`Expected exactly 1 Shape; got ${e.length}`)}return e}function ay(e){let t=0;for(const n of e)0===n.shape.length?t+=1:t+=n.shape.reduce(((e,t)=>e*t));return t}const iy="Variable";class oy{constructor(e,t="float32",n="Variable",s=!0,r=null){this.dtype=null==t?"float32":t,this.shape=e.shape,this.id=qm(),n=null==n?iy:n,this.originalName=og(n),this.name=lg(this.originalName),this.trainable_=s,this.constraint=r,this.val=vh(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(e){return this.assertNotDisposed(),function(e,t){if(e.shape.toString()!==t.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(e.shape)+" vs. "+JSON.stringify(t.shape))}(this.val,e),this.val.id!==e.id&&(this.val.assign(e),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(e){this.trainable_=e,this.val.trainable=e}}function ly(e){return e.map((e=>e.read()))}function uy(e){e.forEach((e=>{e[0].write(e[1])}))}class cy{constructor(e){this.dtype=e.dtype,this.shape=e.shape,null!=e.shape?this.ndim=e.shape.length:this.ndim=e.ndim,this.maxNDim=e.maxNDim,this.minNDim=e.minNDim,this.axes=e.axes||{}}}class hy{constructor(e,t,n,s,r,a,i){this.dtype=e,this.shape=t,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=i,this.id=qm(),null!=a&&(this.originalName=og(a),this.name=lg(this.originalName)),this.rank=t.length}}let py=0;class dy{constructor(e,t){this.callArgs=t,this.id=py++,this.outboundLayer=e.outboundLayer,this.inboundLayers=e.inboundLayers,this.nodeIndices=e.nodeIndices,this.tensorIndices=e.tensorIndices,this.inputTensors=e.inputTensors,this.outputTensors=e.outputTensors,this.inputMasks=e.inputMasks,this.outputMasks=e.outputMasks,this.inputShapes=e.inputShapes,this.outputShapes=e.outputShapes;for(const t of e.inboundLayers)null!=t&&t.outboundNodes.push(this);e.outboundLayer.inboundNodes.push(this)}getConfig(){const e=[];for(const t of this.inboundLayers)null!=t?e.push(t.name):e.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:e,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let fy=0;class my extends lo{constructor(e={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=fy++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let t=e.name;if(!t){const e=this.getClassName();t=_m(e)+"_"+Xm(e)}if(this.name=t,this.trainable_=null==e.trainable||e.trainable,null!=e.inputShape||null!=e.batchInputShape){let t;if(null!=e.batchInputShape)t=e.batchInputShape;else if(null!=e.inputShape){let n=null;null!=e.batchSize&&(n=e.batchSize),t=[n].concat(e.inputShape)}this.batchInputShape=t;let n=e.dtype;null==n&&(n=e.inputDType),null==n&&(n="float32"),this.dtype=n}null!=e.weights?this.initialWeights=e.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(e,t){return e.name+"_ib-"+t.toString()}getNodeAtIndex(e,t){if(0===this.inboundNodes.length)throw new km(`The layer has never been called and thus has no defined ${t}.`);if(this.inboundNodes.length<=e)throw new Nm(`Asked to get ${t} at node ${e}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[e]}getInputAt(e){return Am(this.getNodeAtIndex(e,"input").inputTensors)}getOutputAt(e){return Am(this.getNodeAtIndex(e,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new vm(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new vm(`Layer ${this.name} is not connected, no input to return.`);return Am(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new vm(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new vm(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return Am(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((e=>e()))}get updates(){return this._updates}get built(){return this._built}set built(e){this._built=e}get trainable(){return this.trainable_}set trainable(e){this._trainableWeights.forEach((t=>t.trainable=e)),this.trainable_=e}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((e=>e.trainable)):[]}set trainableWeights(e){this._trainableWeights=e}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((e=>!e.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(e){this._nonTrainableWeights=e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(e){if(e=Rm(e),null==this.inputSpec||0===this.inputSpec.length)return;const t=Rm(this.inputSpec);if(e.length!==t.length)throw new Nm(`Layer ${this.name} expects ${t.length} inputs, but it received ${e.length} input tensors. Input received: ${e}`);for(let n=0;n<e.length;n++){const s=e[n],r=t[n];if(null==r)continue;const a=s.rank;if(null!=r.ndim&&a!==r.ndim)throw new Nm(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${a}`);if(null!=r.maxNDim&&a>r.maxNDim)throw new Nm(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${a}`);if(null!=r.minNDim&&a<r.minNDim)throw new Nm(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${a}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new Nm(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const e=s.shape;for(const t in r.axes){const s=Number(t),a=r.axes[t],i=s>=0?e[s]:e[e.length+s];if(null!=a&&-1===[a,null].indexOf(i))throw new Nm(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${a} but got shape ${e}.`)}}if(null!=r.shape)for(let e=0;e<r.shape.length;++e){const t=r.shape[e],a=s.shape[e];if(null!=t&&null!=a&&t!==a)throw new Nm(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(e,t){return e}invokeCallHook(e,t){null!=this._callHook&&this._callHook(e,t)}setCallHook(e){this._callHook=e}clearCallHook(){this._callHook=null}apply(e,t){t=t||{},this.assertNotDisposed();const n=Rm(e);let s=!0;for(const e of n)if(!(e instanceof hy)){s=!1;break}let r=!0;for(const e of n)if(e instanceof hy){r=!1;break}if(s===r)throw new Nm("Arguments to apply() must be all SymbolicTensors or all Tensors");return ig(this.name,(()=>{if(!this.built){this.assertInputCompatibility(e);const t=[];for(const n of Rm(e))t.push(n.shape);this.build(Am(t)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(e),r){let s=this.call(e,t);const r=Rm(s),a=[];for(let e of r)-1!==n.indexOf(e)&&(e=e.clone()),a.push(e);if(s=Am(a),null!=this.activityRegularizer)throw new Im("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(e){e=Rm(e);const t=[];for(const n of e)t.push(n.shape);return Am(t)}(e),s=this.computeOutputShape(n);let r;const a="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(e)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new hy(a,n,this,Rm(e),t,this.name,s))):new hy(a,s,this,Rm(e),t,this.name),this.addInboundNode(e,r,null,null,n,s,t),this._refCount++,null!=this.activityRegularizer)throw new Im("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(e){if(null!=this.batchInputShape)if(e.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(e)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let t=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=e[s]&&e[s]!==n&&(t=!0)})),t&&console.warn(`The shape of the input tensor (${JSON.stringify(e)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new vm(`The layer ${this.name} has never been called and thus has no defined output shape.`);const e=[];for(const t of this.inboundNodes){const n=JSON.stringify(t.outputShapes);-1===e.indexOf(n)&&e.push(n)}if(1===e.length){const e=this.inboundNodes[0].outputShapes;return Array.isArray(e)&&Array.isArray(e[0])&&1===e.length?e[0]:e}throw new vm(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new km(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return ay(this.weights)}build(e){this.built=!0}getWeights(e=!1){return ly(e?this.trainableWeights:this.weights)}setWeights(e){bi((()=>{const t=this.weights;if(t.length!==e.length)throw new Nm(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${e.length}, but the layer was expecting ${t.length} weights. Provided weights: ${e}...`);if(0===t.length)return;const n=[],s=ly(t);for(let r=0;r<s.length;++r){const a=s[r],i=t[r],o=e[r];if(!f(a.shape,o.shape))throw new Nm(`Layer weight shape ${a.shape} not compatible with provided weight shape ${o.shape}`);n.push([i,o])}uy(n)}))}addWeight(e,t,n,s,r,a,i,o){if(-1!==this._addedWeightNames.indexOf(e))throw new Nm(`Duplicate weight name ${e} for layer ${this.name}`);this._addedWeightNames.push(e),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=o?o():ey("zeros"));const l=s.apply(t,n),u=new oy(l,n,e,a,i);return l.dispose(),null!=r&&this.addLoss((()=>r.apply(u.read()))),null==a&&(a=!0),a?this._trainableWeights.push(u):this._nonTrainableWeights.push(u),u}setFastWeightInitDuringBuild(e){this.fastWeightInitDuringBuild=e}addLoss(e){null==e||Array.isArray(e)&&0===e.length||(e=Rm(e),void 0!==this._losses&&null!==this._losses&&this.losses.push(...e))}computeOutputShape(e){return e}computeMask(e,t){if(!this.supportsMasking){if(null!=t){if(!Array.isArray(t))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);t.forEach((e=>{if(null!=e)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return t}addInboundNode(e,t,n,s,r,a,i=null){const o=Rm(e);t=Rm(t),n=Rm(n),s=Rm(s),r=ny(r),a=ny(a);const l=[],u=[],c=[];for(const e of o)l.push(e.sourceLayer),u.push(e.nodeIndex),c.push(e.tensorIndex);new dy({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:c,inputTensors:o,outputTensors:t,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:a},i);for(let e=0;e<t.length;e++)t[e].sourceLayer=this,t[e].nodeIndex=this.inboundNodes.length-1,t[e].tensorIndex=e}getConfig(){const e={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(e.batchInputShape=this.batchInputShape),null!=this.dtype&&(e.dtype=this.dtype),e}disposeWeights(){return this.weights.forEach((e=>e.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let e=0;return 0==--this._refCount&&(e=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:e}}}function gy(e,t,n){if((null==t||null!=n&&n>0)&&(t=e.sourceLayer,n=e.nodeIndex),0===t.inboundNodes.length)return[e];{const e=t.inboundNodes[n];if(0===e.inboundLayers.length)return e.inputTensors;{const t=[];for(let n=0;n<e.inboundLayers.length;n++){const s=gy(e.inputTensors[n],e.inboundLayers[n],e.nodeIndices[n]);for(const e of s)-1===t.indexOf(e)&&t.push(e)}return t}}}class yy extends my{constructor(e){if(super({dtype:e.dtype,name:null!=e.name?e.name:Xm("input").toString()}),null==e.batchSize&&(e.batchSize=null),null==e.sparse&&(e.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=e.sparse,null!=e.inputShape&&null!=e.batchInputShape)throw new Nm("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let t=e.batchInputShape;if(null==t){if(null==e.inputShape)throw new Nm("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");t=[e.batchSize].concat(e.inputShape)}else if(null!=e.batchSize)throw new Nm("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=e.dtype||"float32";this.batchInputShape=t,this.dtype=n,this.inputSpec=[{shape:t}];const s=new hy(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new dy({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[t],outputShapes:[t]})}apply(e,t){throw new Nm(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function by(e){if(null==e.batchShape&&null==e.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=e.batchShape&&null!=e.shape)throw new Nm("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let t=e.batchShape;null!=e.shape&&null==t&&(t=[null].concat(e.shape));let n=e.dtype;null==n&&(n="float32");return new yy({batchInputShape:t,name:e.name,dtype:n,sparse:e.sparse}).inboundNodes[0].outputTensors[0]}yy.className="InputLayer",co(yy);class xy{constructor(e){if(this.id2Value={},this.id2Mask={},this.name2Id={},e instanceof xy)for(const t in e.id2Value)this.id2Value[t]=e.id2Value[t],t in e.id2Mask&&(this.id2Mask[t]=e.id2Mask[t]);else{if(null==e)return;for(const t of e)this.add(t.key,t.value)}}add(e,t,n){if(null!=this.id2Value[e.id])throw new Nm(`Duplicate key: name=${e.name}, id=${e.id}`);return this.id2Value[e.id]=function(e,t){if(null==e.dtype||e.dtype===t.dtype)return t;try{return qa(t,e.dtype)}catch(n){throw new Nm(`The dtype of the feed (${t.dtype}) can not be cast to the dtype of the key '${e.name}' (${e.dtype}).`)}}(e,t),this.name2Id[e.name]=e.id,null!=n&&(this.id2Mask[e.id]=n),this}addFeed(e){this.add(e.key,e.value)}hasKey(e){return null!=this.id2Value[e.id]}names(){return Object.keys(this.name2Id)}getValue(e){if(e instanceof hy){if(null==this.id2Value[e.id])throw new Nm(`Nonexistent key: ${e.name}`);return this.id2Value[e.id]}{const t=this.name2Id[e];if(null==t)throw new Nm(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Value[t]}}getMask(e){if(e instanceof hy){if(null==this.id2Value[e.id])throw new Nm(`Nonexistent key: ${e.name}`);return this.id2Mask[e.id]}{const t=this.name2Id[e];if(null==t)throw new Nm(`Feed dict has no SymbolicTensor name: ${e}`);return this.id2Mask[t]}}disposeMasks(){null!=this.id2Mask&&xi(this.id2Mask)}}const wy=new Tm,vy=new Tm;function ky(e,t,n,s){const r=null!=n&&n.training,a=Array.isArray(e),i=a?e:[e],o=i.map((e=>e.name)),l=[],c=t.names();for(const e of o)-1!==c.indexOf(e)?l.push(t.getValue(e)):l.push(null);null!=s&&(s.maxNumTensors=-1/0,s.minNumTensors=1/0);const h=o.join(",")+"|"+t.names().sort().join(",");let p,d=wy.get(h);if(null==d){const e=function(e,t){u(null!=e&&e.length>0,(()=>"Expected at least one fetch, got none"));let n=[],s={};if(1===e.length){const r=Iy(e[0],t);n=r.sorted,s=r.recipientMap}else{const r=new Set;for(const a of e){const{sorted:e,recipientMap:i}=Iy(a,t);for(const t of e)r.has(t.name)||(n.push(t),r.add(t.name));for(const e in i)null==s[e]&&(s[e]=new Set),i[e].forEach((t=>s[e].add(t)))}}return{sorted:n,recipientCounts:Ny(s)}}(i,t);d=e.sorted,p=e.recipientCounts,wy.put(h,d),vy.put(h,p)}p={},r||Object.assign(p,vy.get(h));const f=new xy(t);for(let e=0;e<d.length;++e){if(null!=s){const e=yi().numTensors;e>s.maxNumTensors&&(s.maxNumTensors=e),e<s.minNumTensors&&(s.minNumTensors=e)}const a=d[e],i=a.sourceLayer;if(i instanceof yy)continue;const u=[],c=[],h=[];let m=!1;for(const e of a.inputs){const n=f.getValue(e),s=f.getMask(e);u.push(n),c.push(s),null!=s&&(m=!0),r||(p[e.name]--,0!==p[e.name]||t.hasKey(e)||-1!==o.indexOf(e.name)||n.isDisposed||!0===e.sourceLayer.stateful||h.push(n))}m&&((n=n||{}).mask=c[0]);const g=Rm(i.apply(u,n));let y=null;i.supportsMasking&&(y=i.computeMask(u,c));const b=Sy(a),x=Array.isArray(b)?b:[b];for(let e=0;e<x.length;++e){f.hasKey(x[e])||f.add(x[e],g[e],Array.isArray(y)?y[0]:y);const t=o.indexOf(x[e].name);-1!==t&&(l[t]=g[e])}r||xi(h)}return f.disposeMasks(),a?l:l[0]}function Ny(e){const t={};for(const n in e)t[n]=e[n].size;return t}function Iy(e,t){const n=new Set,s=[],r={};for(const e of t.names())n.add(e);const a=[],i=[];for(a.push(e);a.length>0;){const e=a[a.length-1];if(n.has(e.name)){a.pop();continue}const t=i[i.length-1]===a.length-1;if(0===e.inputs.length||t)a.pop(),s.push(e),n.add(e.name),t&&i.pop();else{i.push(a.length-1);for(const t of e.inputs)null==r[t.name]&&(r[t.name]=new Set),r[t.name].add(e.name),n.has(t.name)||a.push(t)}}return{sorted:s,recipientMap:r}}function Sy(e){let t;if(1===e.sourceLayer.inboundNodes.length)t=e.sourceLayer.output;else{let n=null;for(let t=0;t<e.sourceLayer.inboundNodes.length;++t)for(const s of e.sourceLayer.inboundNodes[t].outputTensors)if(s.id===e.id){n=t;break}t=e.sourceLayer.getOutputAt(n)}return t}function Ty(e,t){return bi((()=>eu(nu(ko(e,e),t,!0))))}X().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(e){null!=wy&&wy.setMaxEntries(e),null!=vy&&vy.setMaxEntries(e)}));class $y extends lo{getConfig(){return{}}}class Cy extends $y{constructor(e){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return bi((()=>{const t=Ty(e,this.axis),n=dl(t,0,this.maxValue);return ko(e,vo(n,xo(gg(),t)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}Cy.className="MaxNorm",co(Cy);class Ey extends $y{constructor(e){super(),this.defaultAxis=0,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return bi((()=>vo(e,xo(gg(),Ty(e,this.axis)))))}getConfig(){return{axis:this.axis}}}Ey.className="UnitNorm",co(Ey);class Ay extends $y{apply(e){return Fc(e)}}Ay.className="NonNeg",co(Ay);class Ry extends $y{constructor(e){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=e.minValue?e.minValue:this.defaultMinValue,this.maxValue=null!=e.maxValue?e.maxValue:this.defaultMaxValue,this.rate=null!=e.rate?e.rate:this.defaultRate,this.axis=null!=e.axis?e.axis:this.defaultAxis}apply(e){return bi((()=>{const t=Ty(e,this.axis),n=xo(ko(this.rate,dl(t,this.minValue,this.maxValue)),ko(1-this.rate,t));return ko(e,vo(n,xo(gg(),t)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Ry.className="MinMaxNorm",co(Ry);const _y={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Fy(e){return Om(e)}function Dy(e,t={}){return Lm(e,uo.getMap().classNameMap,t,"constraint")}function Oy(e){if(null==e)return null;if("string"==typeof e){return Dy({className:e in _y?_y[e]:e,config:{}})}return e instanceof $y?e:Dy(e)}var My=Object.freeze({__proto__:null,maxNorm:function(e){return new Cy(e)},unitNorm:function(e){return new Ey(e)},nonNeg:function(){return new Ay},minMaxNorm:function(e){return new Ry(e)}});var Ly,zy=Object.freeze({__proto__:null,zeros:function(){return new Mg},ones:function(){return new Lg},constant:function(e){return new zg(e)},randomUniform:function(e){return new Pg(e)},randomNormal:function(e){return new Bg(e)},truncatedNormal:function(e){return new Wg(e)},identity:function(e){return new Vg(e)},varianceScaling:function(e){return new Ug(e)},glorotUniform:function(e){return new Gg(e)},glorotNormal:function(e){return new Hg(e)},heNormal:function(e){return new jg(e)},heUniform:function(e){return new qg(e)},leCunNormal:function(e){return new Kg(e)},leCunUniform:function(e){return new Xg(e)},orthogonal:function(e){return new Yg(e)}});async function Py(e){if(null==e)return;const t=[],n=[],s=[];for(const r in e){const a=e[r];if("number"!=typeof a){const e=a;t.push(e.data()),n.push(r),s.push(e)}}if(t.length>0){const r=await Promise.all(t);for(let t=0;t<r.length;++t)e[n[t]]=r[t][0];xi(s)}}function By(e){if(null!=e)for(const t in e){const n=e[t];"number"!=typeof n&&n.dispose()}}!function(e){e[e.SILENT=0]="SILENT",e[e.VERBOSE=1]="VERBOSE"}(Ly||(Ly={}));class Wy{constructor(){this.validationData=null}setParams(e){this.params=e}async onEpochBegin(e,t){}async onEpochEnd(e,t){}async onBatchBegin(e,t){}async onBatchEnd(e,t){}async onTrainBegin(e){}async onTrainEnd(e){}setModel(e){}}class Vy{constructor(e,t=10){null==e&&(e=[]),this.callbacks=e,this.queueLength=t}append(e){this.callbacks.push(e)}setParams(e){for(const t of this.callbacks)t.setParams(e)}setModel(e){for(const t of this.callbacks)t.setModel(e)}async onEpochBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochBegin(e,t)}async onEpochEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onEpochEnd(e,t)}async onBatchBegin(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchBegin(e,t)}async onBatchEnd(e,t){null==t&&(t={});for(const n of this.callbacks)await n.onBatchEnd(e,t)}async onTrainBegin(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainBegin(e)}async onTrainEnd(e){null==e&&(e={});for(const t of this.callbacks)await t.onTrainEnd(e)}}class Uy extends Wy{constructor(){super()}async onEpochBegin(e){this.seen=0,this.totals={}}async onBatchEnd(e,t){null==t&&(t={});const n=null==t.size?0:t.size;this.seen+=n;for(const e in t){const s=t[e];if("number"==typeof s)this.totals.hasOwnProperty(e)||(this.totals[e]=0),this.totals[e]=this.totals[e]+s*n;else{let t;e in this.totals?t=this.totals[e]:this.totals[e]=0;const r=bi((()=>xo(this.totals[e],ko(s,n))));this.totals[e]=r,null!=t&&t.dispose()}}}async onEpochEnd(e,t){if(null!=t)for(const e of this.params.metrics)null!=this.totals[e]&&("number"==typeof this.totals[e]?t[e]=this.totals[e]/this.seen:bi((()=>{const n=ko(vo(1,this.seen),this.totals[e]);t[e]=n,this.totals[e].dispose(),wi(t[e])})))}}class Gy extends Wy{async onTrainBegin(e){this.epoch=[],this.history={}}async onEpochEnd(e,t){null==t&&(t={}),this.epoch.push(e);for(const e in t)null==this.history[e]&&(this.history[e]=[]),this.history[e].push(t[e])}async syncData(){const e=[],t=[],n=[];for(const s in this.history){const r=this.history[s];for(let a=0;a<r.length;++a)if("number"!=typeof r[a]){const i=r[a];e.push(i.data()),t.push(s),n.push(a)}}const s=await Promise.all(e);for(let e=0;e<s.length;++e){this.history[t[e]][n[e]].dispose(),this.history[t[e]][n[e]]=s[e][0]}}}class Hy extends Wy{constructor(e,t){if(super(),this.currentEpoch=0,this.nowFunc=e.nowFunc,this.nextFrameFunc=e.nextFrameFunc||sd,this.yieldEvery=t||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=e.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");_(this.yieldEvery)&&(this.maybeWait=function(e,t,n){let s,r=null!=n?n():tr();return(...a)=>{const i=null!=n?n():tr();return i-r<t||(r=i,s=e(...a)),s}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=e.onTrainBegin,this.trainEnd=e.onTrainEnd,this.epochBegin=e.onEpochBegin,this.epochEnd=e.onEpochEnd,this.batchBegin=e.onBatchBegin,this.batchEnd=e.onBatchEnd,this.yield=e.onYield}async maybeWait(e,t,n){const s=[];null!=this.yield&&(await Py(n),s.push(this.yield(e,t,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(e,t){this.currentEpoch=e,null!=this.epochBegin&&(await Py(t),await this.epochBegin(e,t))}async onEpochEnd(e,t){const n=[];null!=this.epochEnd&&(await Py(t),n.push(this.epochEnd(e,t))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(e,t){null!=this.batchBegin&&(await Py(t),await this.batchBegin(e,t))}async onBatchEnd(e,t){const n=[];null!=this.batchEnd&&(await Py(t),n.push(this.batchEnd(e,t))),"batch"===this.yieldEvery?n.push(this.nextFrameFunc()):_(this.yieldEvery)&&n.push(this.maybeWait(this.currentEpoch,e,t)),await Promise.all(n)}async onTrainBegin(e){null!=this.trainBegin&&(await Py(e),await this.trainBegin(e))}async onTrainEnd(e){null!=this.trainEnd&&(await Py(e),await this.trainEnd(e))}}function jy(e,t){if(null==e&&(e={}),e instanceof Wy)return[e];if(Array.isArray(e)&&e[0]instanceof Wy)return e;return Rm(e).map((e=>new Hy(e,t)))}class qy{constructor(){}static registerCallbackConstructor(e,t){u(e>=0&&Number.isInteger(e),(()=>`Verbosity level is expected to be an integer >= 0, but got ${e}`)),qy.checkForDuplicate(t),null==qy.constructors[e]&&(qy.constructors[e]=[]),qy.constructors[e].push(t)}static checkForDuplicate(e){for(const t in qy.constructors){qy.constructors[+t].forEach((t=>{if(t===e)throw new Nm("Duplicate callback constructor.")}))}}static clear(){qy.constructors={}}static createCallbacks(e){const t=[];for(const n in qy.constructors){const s=+n;e>=s&&t.push(...qy.constructors[s])}return t.map((e=>new e))}}function Ky(e,t,n,s,r,a,i,o,l){const u=new Gy,c=[new Uy,...qy.createCallbacks(t)];null!=e&&c.push(...e),c.push(u);const h=new Vy(c);return h.setParams({epochs:n,initialEpoch:s,samples:r,steps:a,batchSize:i,verbose:t,doValidation:o,metrics:l}),{callbackList:h,history:u}}function Xy(e,t={},n=!1){return Lm(e,uo.getMap().classNameMap,t,"layer",n)}function Yy(e,t){return bi((()=>{"float32"!==e.dtype&&(e=qa(e,"float32"));const n=nu(Cg(e),t,!0),s=hu(n.shape,gg()),r=eu(Gu(n,s));return vo(e,r)}))}function Zy(e,t){return bi((()=>Hu(Cg(Ru(t,e)),-1)))}function Jy(e,t){return bi((()=>Hu(No(Ru(t,e)),-1)))}function Qy(e,t){return bi((()=>{const n=Ru(e,t),s=dl(No(e),gg(),Number.MAX_VALUE),r=No(vo(n,s));return ko(100,Hu(r,-1))}))}function eb(e,t){return bi((()=>{const n=dl(t,gg(),Number.MAX_VALUE),s=Iu(xo(1,n)),r=dl(e,gg(),Number.MAX_VALUE),a=Iu(xo(1,r));return Hu(Cg(Ru(s,a)),-1)}))}function tb(e,t,n=!1){return bi((()=>{if(n)t=Jc(t);else{const e=nu(t,t.shape.length-1,!0);t=vo(t,e)}return t=dl(t,gg(),1-gg()),Si(nu(ko(qa(e,"float32"),Iu(t)),t.shape.length-1))}))}function nb(e,t,n=!1){return bi((()=>{const s=qa(pu(function(e){const t=[hg(e.shape)];return Yo(e,t)}(e)),"int32"),r=(t=dl(t,gg(),1-gg())).shape;return tb(Yo(fi(s,r[r.length-1]),r),t,n)}))}function sb(e,t){return bi((()=>{let n;return n=dl(t,gg(),1-gg()),n=Iu(vo(n,Ru(1,n))),Hu(function(e,t){if(!f(e.shape,t.shape))throw new Nm(`logits and labels must have the same shape, but got shapes ${JSON.stringify(e.shape)} and ${JSON.stringify(t.shape)}`);return bi((()=>{const n=Fc(t),s=Si(No(t));return xo(Ru(n,ko(t,e)),Su(iu(s)))}))}(e,n),-1)}))}function rb(e,t){return bi((()=>{const n=dl(e,gg(),1),s=dl(t,gg(),1);return nu(ko(e,Iu(vo(n,s))),-1)}))}function ab(e,t){return bi((()=>{const n=Yy(e,-1),s=Yy(t,-1),r=ko(n,s);return Si(nu(r,-1))}))}qy.constructors={};const ib={meanSquaredError:Zy,meanAbsoluteError:Jy,meanAbsolutePercentageError:Qy,meanSquaredLogarithmicError:eb,squaredHinge:function(e,t){return bi((()=>{const n=Gu(0,Ru(1,ko(e,t)));return Hu(Cg(n),-1)}))},hinge:function(e,t){return bi((()=>{const n=Gu(0,Ru(1,ko(e,t)));return Hu(n,-1)}))},categoricalHinge:function(e,t){return bi((()=>{const n=nu(ko(e,t),-1),s=Yl(ko(Ru(1,e),t),-1);return Gu(0,xo(1,Ru(s,n)))}))},logcosh:function(e,t){return bi((()=>{const n=Math.log(2),s=Ru(t,e),r=Ru(xo(s,Eu(ko(-2,s))),n);return Hu(r,-1)}))},categoricalCrossentropy:tb,sparseCategoricalCrossentropy:nb,binaryCrossentropy:sb,kullbackLeiblerDivergence:rb,poisson:function(e,t){return bi((()=>{const n=Iu(xo(gg(),t));return Hu(Ru(t,ko(e,n)),-1)}))},cosineProximity:ab};function ob(e){if("string"==typeof e){if(e in ib)return ib[e];let t=`Unknown loss ${e}`;throw e.toLowerCase().includes("softmaxcrossentropy")&&(t=`Unknown loss ${e}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new Nm(t)}return e}function lb(e,t){return bi((()=>{const n=ko(.5,nc(t)),s=yg(fu(t,n),e.dtype);return Hu(Dl(e,s),-1)}))}function ub(e,t){return bi((()=>yg(Dl(Eo(e,-1),Eo(t,-1)),"float32")))}function cb(e,t){return bi((()=>qa(nu(Du(Dl(e,1),Dl(t,1))),"float32")))}function hb(e,t){return bi((()=>{const n=cb(e,t),s=function(e,t){return bi((()=>qa(nu(Du(Dl(e,0),Dl(t,1))),"float32")))}(e,t),r=xo(n,s);return qa(Ol(fu(r,0),vo(n,r),0),"float32")}))}function pb(e,t){return bi((()=>{const n=cb(e,t),s=function(e,t){return bi((()=>qa(nu(Du(Dl(e,1),Dl(t,0))),"float32")))}(e,t),r=xo(n,s);return qa(Ol(fu(r,0),vo(n,r),0),"float32")}))}function db(e,t){return sb(e,t)}function fb(e,t){return e.rank===t.rank&&(e=ah(e,[e.rank-1])),(t=Eo(t,-1)).dtype!==e.dtype&&(t=qa(t,e.dtype)),qa(Dl(e,t),"float32")}const mb=tb,gb=nb,yb={binaryAccuracy:lb,categoricalAccuracy:ub,precision:hb,categoricalCrossentropy:mb,sparseCategoricalCrossentropy:gb,mse:Zy,MSE:Zy,mae:Jy,MAE:Jy,mape:Qy,MAPE:Qy,cosine:ab};function bb(e){if("string"==typeof e&&e in yb)return yb[e];if("string"!=typeof e&&null!=e)return e;throw new Nm(`Unknown metric ${e}`)}function xb(e){if(Cm(null!==e,`Unknown LossOrMetricFn ${e}`),"string"==typeof e)return e;{let t;for(const n of Object.keys(ib))if(ib[n]===e){t=n;break}if(void 0!==t)return t;for(const n of Object.keys(yb))if(yb[n]===e){t=n;break}return void 0!==t?t:e.name}}const wb=1048576;function vb(e,t,n=!1){if(null==e||"object"!=typeof e||Object.getPrototypeOf(e)!==Object.prototype||!kb(e))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(e);n.length>wb&&console.warn(`User-defined metadata of model "${t}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function kb(e){if(null===e)return!0;if("object"==typeof e){if(Object.getPrototypeOf(e)===Object.prototype){const t=Object.keys(e);for(const n of t){if("string"!=typeof n)return!1;if(!kb(e[n]))return!1}return!0}if(Array.isArray(e)){for(const t of e)if(!kb(t))return!1;return!0}return!1}{const t=typeof e;return"string"===t||"number"===t||"boolean"===t}}function Nb(e,t,n,s=console.log){const r=function(e){let t=!0;const n=[],s=[];for(const t in e.nodesByDepth)n.push(e.nodesByDepth[t]);for(const e of n){if(e.length>1||1===e.length&&e[0].inboundLayers.length>1){t=!1;break}s.push(...e)}if(t)for(const n of e.layers){let e=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(e){t=!1;break}e=!0}if(!t)break}return t}(e),a=["Layer (type)","Input Shape","Output shape","Param #"];let i;if(r?(t=t||90,n=n||[.32,.61,.89,1]):(t=t||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((e=>Math.floor(t*e)))),!r){a.push("Receives inputs"),i=[];for(const t in e.nodesByDepth)i.push(...e.nodesByDepth[t])}s("_".repeat(t)),Ib(a,n,s),s("=".repeat(t));const o=e.layers;for(let e=0;e<o.length;++e)r?Sb(o[e],n,s):Tb(o[e],n,i,s),s((e===o.length-1?"=":"_").repeat(t));e.checkTrainableWeightsConsistency();const l=function(e){let t;t=null!=e.collectedTrainableWeights?ay(e.collectedTrainableWeights):ay(e.trainableWeights);return t}(e),u=ay(e.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(t))}function Ib(e,t,n=console.log){let s="";for(let n=0;n<e.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=e[n],s=s.slice(0,t[n]),s+=" ".repeat(t[n]-s.length);n(s)}function Sb(e,t,n){let s,r;try{r=e.inboundNodes.map((e=>JSON.stringify(e.inputShapes))).join(",")}catch(e){r="multiple"}try{s=JSON.stringify(e.outputShape)}catch(e){s="multiple"}Ib([`${e.name} (${e.getClassName()})`,r,s,e.countParams().toString()],t,n)}function Tb(e,t,n,s){let r,a;try{a=e.inboundNodes.map((e=>JSON.stringify(e.inputShapes))).join(",")}catch(e){a="multiple"}try{r=JSON.stringify(e.outputShape)}catch(e){r="multiple"}const i=[];for(const t of e.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(t)))for(let e=0;e<t.inboundLayers.length;++e){const n=t.inboundLayers[e].name,s=t.nodeIndices[e],r=t.tensorIndices[e];i.push(`${n}[${s}][${r}]`)}const o=e.name,l=e.getClassName(),u=0===i.length?"":i[0];Ib([`${o} (${l})`,a,r,e.countParams().toString(),u],t,s);for(let e=1;e<i.length;++e)Ib(["","","","",i[e]],t,s)}function $b(e,t,n){return("inboundNodes"===e||"outputLayers"===e||"inputLayers"===e)&&0===t&&"string"==typeof n}function Cb(e,t){if(null===e)return null;if("string"==typeof e)return Fm(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];$b(t,r,s)?n.push(s):n.push(Cb(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n];if("name"===n&&"string"==typeof s)t[n]=s;else{const e=Fm(n);t[e]=Cb(s,e)}}return t}}function Eb(e,t){if(null==e)return null;if("string"==typeof e)return _m(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const n=[],s=e.length;for(let r=0;r<s;++r){const s=e[r];$b(t,r,s)?n.push(s):n.push(Eb(s,t))}return n}{const t={};for(const n of Object.keys(e)){const s=e[n],r=_m(n);t[r]="name"!==n&&"className"!==n||"string"!=typeof s?Eb(s,n):s}return t}}const Ab="3.19.0";class Rb extends my{constructor(e){if(super({}),this.containerNodes=new Set,this.name=e.name,null==this.name){const e=this.getClassName().toLowerCase();this.name=Xm(e)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(e.inputs)?this.inputs=e.inputs.slice():this.inputs=[e.inputs],Array.isArray(e.outputs)?this.outputs=e.outputs.slice():this.outputs=[e.outputs],Pm(this.inputs).length!==this.inputs.length)throw new Nm(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((e=>e.name))}`);Pm(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((e=>e.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const e of this.outputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;this.outputLayers.push(t),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const e of this.inputs){const t=e.sourceLayer,n=e.nodeIndex,s=e.tensorIndex;Cm(0===n,"input layer has >1 nodes"),Cm(0===s,"input layer has >1 tensors"),this.inputLayers.push(t),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t];if(!(n instanceof yy))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${e.inputs}. Input ${t} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const e of this.outputLayers)this.outputNames.push(e.name);this.internalInputShapes=this.inputs.map((e=>e.shape)),this.internalOutputShapes=this.outputs.map((e=>e.shape));const t={},n={},s={},r={},a={},i=[],o=(e,t,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=e.sourceLayer,r=e.nodeIndex,l=e.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new km(`The tensor ${e.name} at layer "${s.name}" is part of a cycle.`);if(-1!==t.indexOf(u))return;this.containerNodes.add(Rb.nodeKey(s,r)),s.id in a||(a[s.id]=Object.keys(a).length),-1===n.indexOf(u)&&n.push(u);const c=u.inboundLayers.length;for(let e=0;e<c;e++){const s=u.inputTensors[e],r=u.inboundLayers[e],a=u.nodeIndices[e],i=u.tensorIndices[e];o(s,t,n,r,a,i)}for(t.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);i.push(u)},l=[],u=[];for(const e of this.outputs)o(e,l,u);const c=i.slice().reverse();for(const e of c){n[e.id]=e,e.id in t||(t[e.id]=0);let a=t[e.id];const i=null==s[e.outboundLayer.id]?0:s[e.outboundLayer.id];a=Math.max(a,i),s[e.outboundLayer.id]=a,r[e.outboundLayer.id]=e.outboundLayer,t[e.id]=a;for(let s=0;s<e.inboundLayers.length;s++){const r=e.inboundLayers[s],i=e.nodeIndices[s],o=r.inboundNodes[i],l=null==t[o.id]?0:t[o.id];t[o.id]=Math.max(a+1,l),n[o.id]=o}}const h={};for(const e in t){const s=t[e];s in h||(h[s]=[]),h[s].push(n[e])}const p={};for(const e in s){const t=s[e];t in p||(p[t]=[]),p[t].push(r[e])}let d=Object.keys(p).map((e=>parseInt(e,10))).sort(zm);this.layers=[];for(const e of d){const t=p[e];t.sort(((e,t)=>{const n=a[e.id],s=a[t.id];return n<s?-1:n>s?1:0}));for(const e of t)e instanceof Rb&&this.internalContainerRefs.push(e),this.layers.push(e)}this.layersByDepth=p,d=Object.keys(h).map((e=>parseInt(e,10))).sort(zm);const f=this.inputs.slice(),m=[];for(const e of d)for(const t of h[e]){const e=t.outboundLayer;if(null!=e){for(const n of t.inputTensors)if(-1===f.indexOf(n))throw new km(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${e.name}". The following previous layers were accessed without issue: ${m}`);for(const e of t.outputTensors)f.push(e);m.push(e.name)}}this.nodesByDepth=h;const g=this.layers.map((e=>e.name));for(const e of g){const t=g.filter((t=>t===e)).length;if(1!==t)throw new km(`The name "${e}" is used ${t} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(g))}this.outboundNodes=[],this.inboundNodes=[],new dy({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((e=>null)),outputMasks:this.outputs.map((e=>null)),inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs.map((e=>e.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const e={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const t of this.layers)e.numDisposedVariables+=t.dispose().numDisposedVariables;for(const t of this.internalContainerRefs)e.numDisposedVariables+=t.dispose().numDisposedVariables}return e.refCountAfterDispose=this._refCount,e}get trainable(){return this.trainable_}set trainable(e){this.layers.forEach((t=>{t._trainableWeights.forEach((t=>t.trainable=e))})),this.trainable_=e}get trainableWeights(){if(this._trainableWeights.length>0)throw new Nm("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let e=[];for(const t of this.layers)e=e.concat(t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.layers)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.layers)t.push(...e.trainableWeights);return t.concat(e)}return e}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(e,t=!0){const n={};let s=0;for(const e of this.layers)for(const t of e.weights){if(null!=n[t.originalName])throw new Nm(`Duplicate weight name: ${t.originalName}`);n[t.originalName]=t,s++}const r=[];for(const s in e){let a=s;if(null==n[s]){const e=s.split("/");a=e.slice(0,-2).concat([e[e.length-1]]).join("/")}if(null!=n[a])r.push([n[a],e[s]]);else if(t)throw new Nm(`Provided weight data has no target variable: ${s}`);delete n[a]}if(t){const e=[];for(const t in n)e.push(t);if(e.length>0)throw new Nm(`${e.length} of ${s} weights are not set: ${e}`)}uy(r)}updatedConfig(){const e=this.getConfig(),t={};return t.className=this.getClassName(),t.config=e,t.kerasVersion="tfjs-layers 3.19.0",t.backend="TensorFlow.js",t}toJSON(e,t=!0){const n=Eb(this.updatedConfig());return t?JSON.stringify(n):n}call(e,t){return bi((()=>{e=Rm(e);const n=new xy;for(let t=0;t<this.inputs.length;++t)n.add(this.inputs[t],e[t]);return ky(this.outputs,n,t)}))}computeMask(e,t){return bi((()=>{let n;return e=Rm(e),n=null==t?$m(null,e.length):Rm(t),this.runInternalGraph(e,n)[1]}))}computeOutputShape(e){const t=ny(e);if(t.length!==this.inputLayers.length)throw new Nm(`Invalid inputShape argument ${e}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let e=0;e<t.length;e++){const s=this.inputLayers[e],r=t[e];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(zm);if(s.length>1)for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer;if(-1!==this.inputLayers.map((e=>e.id)).indexOf(t.id))continue;const s=[];for(let t=0;t<e.inboundLayers.length;t++){const r=e.inboundLayers[t],a=e.nodeIndices[t],i=e.tensorIndices[t],o=n[`${r.name}_${a}_${i}`];s.push(o)}const r=ny(t.computeOutputShape(Am(s))),a=t.inboundNodes.indexOf(e);for(let e=0;e<r.length;e++){n[`${t.name}_${a}_${e}`]=r[e]}}}const r=[],a=[];for(let e=0;e<this.outputLayers.length;e++){const t=this.outputLayers[e],n=this.outputLayersNodeIndices[e],s=this.outputLayersTensorIndices[e],r=`${t.name}_${n}_${s}`;a.push(r)}for(let e=0;e<a.length;e++){const t=a[e];Cm(t in n),r.push(n[t])}return Am(r)}runInternalGraph(e,t){null==t&&(t=$m(null,e.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],a=e[s],i=t[s];n[r.id]=[a,i]}const s=Object.keys(this.nodesByDepth).map((e=>parseInt(e,10))).sort(zm);for(const e of s){const t=this.nodesByDepth[e];for(const e of t){const t=e.outboundLayer,s=e.inputTensors,r=e.outputTensors,a=new Array;for(const e of s)e.id in n&&a.push(n[e.id]);if(a.length===s.length){let s,i,o,l,u={};if(null!=e.callArgs&&(u=e.callArgs),1===a.length){const[e,n]=a[0];null==u.mask&&(u.mask=n),o=Rm(t.call(e,u)),l=Rm(t.computeMask(e,n)),s=[e],i=[n]}else s=a.map((e=>e[0])),i=a.map((e=>e[1])),null==u.mask&&(u.mask=i),o=Rm(t.call(s,u)),l=Rm(t.computeMask(s,i));if(t.activityRegularizer)throw new Im("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let e=0;e<r.length;++e){const t=r[e],s=o[e],a=l[e];n[t.id]=[s,a]}}}}const r=[],a=[],i=[];for(const e of this.outputs){Cm(e.id in n,`Could not compute output ${e.name} : ${e.id}`);const[t,s]=n[e.id];i.push(t.shape),r.push(t),a.push(s)}return[r,a,i]}buildNodeConversionMap(e){const t={};let n;for(const e of this.layers){n=e instanceof Rb?1:0;for(let s=0;s<e.inboundNodes.length;s++){const r=Rb.nodeKey(e,s);this.containerNodes.has(r)&&(t[r]=n,n+=1)}}return t}getLayer(e,t){if(null!=t){if(this.layers.length<=t)throw new Nm(`Was asked to retrieve layer at index ${t}, but model only has ${this.layers.length} layer(s).`);return this.layers[t]}if(null==e)throw new Nm("Provide either a layer name or layer index");for(const t of this.layers)if(t.name===e)return t;throw new Nm(`No such layer: ${e}`)}calculateLosses(){return bi((()=>{const e=[];for(const t of this.layers)for(let n=0;n<t.inboundNodes.length;++n){const s=Rb.nodeKey(t,n);this.containerNodes.has(s)&&e.push(...t.calculateLosses())}return e}))}getConfig(){const e={name:this.name},t=this.buildNodeConversionMap(this.layers),n=[];for(const e of this.layers){const s=e.getClassName(),r=e.getConfig(),a=[];for(let n=0;n<e.inboundNodes.length;n++){const s=e.inboundNodes[n],r=Rb.nodeKey(e,n);let i={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),i=s.callArgs}catch(t){console.warn(`Layer ${e.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),i={}}if(s.inboundLayers.length>0){const e=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],a=s.nodeIndices[n],o=s.tensorIndices[n];let l=t[Rb.nodeKey(r,a)];null==l&&(l=0),e.push([r.name,l,o,i])}a.push(e)}}}const i={};i.name=e.name,i.className=s,i.config=r,i.inboundNodes=a,n.push(i)}e.layers=n;const s=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e],r=this.inputLayersNodeIndices[e],a=Rb.nodeKey(n,r);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.inputLayersTensorIndices[e];s.push([n.name,i,o])}e.inputLayers=s;const r=[];for(let e=0;e<this.outputLayers.length;e++){const n=this.outputLayers[e],s=this.outputLayersNodeIndices[e],a=Rb.nodeKey(n,s);if(!this.containerNodes.has(a))continue;let i=t[a];null==i&&(i=0);const o=this.outputLayersTensorIndices[e];r.push([n.name,i,o])}return e.outputLayers=r,e}static fromConfig(e,t,n={},s=!1){const r={},a={};function i(e,t){e.name in a?a[e.name].push(t):a[e.name]=[t]}function o(e,t){const n=[];let s;for(const a of t){const o=a[0],l=a[1],u=a[2];if(s=null==a[3]?{}:a[3],!(o in r))return void i(e,t);const c=r[o];if(c.inboundNodes.length<=l)return void i(e,t);const h=c.inboundNodes[l];n.push(h.outputTensors[u])}n.length>0&&e.apply(Am(n),s)}function l(e){const n=e.name,a=Xy(e,null!=t.customObjects?t.customObjects:{});a.setFastWeightInitDuringBuild(s),r[n]=a;e.inboundNodes.forEach((e=>{if(!(e instanceof Array))throw new Nm(`Corrupted configuration, expected array for nodeData: ${e}`);i(a,e)}))}const u=t.name,c=t.layers;for(const e of c)l(e);for(;!Bm(a);)for(const e of c){const t=r[e.name];if(t.name in a){const e=a[t.name];delete a[t.name];for(const n of e)o(t,n)}}const h=[],p=[],d=t.inputLayers;for(const e of d){const t=e[0],n=e[1],s=e[2];Cm(t in r);const a=r[t].inboundNodes[n].outputTensors;h.push(a[s])}const f=t.outputLayers;for(const e of f){const t=e[0],n=e[1],s=e[2];Cm(t in r);const a=r[t].inboundNodes[n].outputTensors;p.push(a[s])}return new e({inputs:h,outputs:p,name:u})}get stateful(){if(this._stateful)throw new Nm("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const e of this.layers)if(e.stateful)return!0;return!1}resetStates(){bi((()=>{this.layers.forEach((e=>{e.stateful&&e.resetStates()}))}))}}function _b(e,t,n){const s=t.length;if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>null));if(1===s)return Array.isArray(e)&&1===e.length?e:"object"==typeof e&&t[0]in e?[e[t[0]]]:[e];if(Array.isArray(e)){if(e.length!==s)throw new Error(`Provided ${n} is an array of ${e.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return e}if("object"==typeof e&&Object.keys(e).length>0&&"object"==typeof e[Object.keys(e)[0]]){const n=[];return t.forEach((t=>{t in e?n.push(e[t]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${t} keys. Provided ${n} not understood: ${JSON.stringify(e)}`)}function Fb(e,t){return _b(e,t,"classWeight")}async function Db(e,t,n,s){if(null!=t||null!=s)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const t=bi((()=>{if(1===e.shape.length)return Ka(e);if(2===e.shape.length){if(e.shape[1]>1){return Eo(e,1)}if(1===e.shape[1])return Yo(e,[e.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${e.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${e.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),s=Array.from(await t.data());xi(t);const r=[];return s.forEach((e=>{if(null==n[e])throw new Error(`classWeight must contain all classes in the training data. The class ${e} exists in the data but not in classWeight`);r.push(n[e])})),ch(r,"float32")}return null}function Ob(e,t){return ko(e,t)}function Mb(e,t){let n,s;const r=t;n=r.xs,s=r.ys,u(null!=n&&null!=s,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${t}`));const a=Lb("input",e.inputNames,n),i=Lb("output",e.outputNames,s),o=a[0].shape[0];u(a.length===e.inputs.length,(()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`)),u(i.length===e.outputs.length,(()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${i.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`));for(let t=0;t<a.length;t++)u(a[t].shape[0]===o,(()=>`Batch size mismatch: input ${e.inputNames[t]} has ${a[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));for(let t=0;t<i.length;t++)u(i[t].shape[0]===o,(()=>`Batch size mismatch: output ${e.outputNames[t]} has ${i[t].shape[0]}; expected  ${o} based on input ${e.inputNames[0]}.`));return{xs:a,ys:i}}function Lb(e,t,n){if(n instanceof br)return[n];if(Array.isArray(n))return u(n.length===t.length,(()=>`Received an array of ${n.length} Tensors, but expected ${t.length} to match the ${e} keys ${t}.`)),n;{const s=[];for(const r of t){if(null==n[r])throw new Nm(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);s.push(n[r])}return s}}async function zb(e,t,n){const s=null!=n.batchesPerEpoch;if(u(null!=e.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),u(null!=n,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),u(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`)),u(!s||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`)),u(null==n.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const r=null!=n.validationData;let a,i;if(r)if(Pb(n.validationData))u(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`));else{const e=function(e){if(3===e.length)throw new Im("Validation with sample weights is not implemented yet.");return{xs:e[0],ys:e[1]}}(n.validationData);a=e.xs,i=e.ys}const o=e.makeTrainFunction(),l=e.getDedupedMetricsNames();let c;c=r?l.slice().concat(l.map((e=>"val_"+e))):l.slice();const h=jy(n.callbacks,n.yieldEvery),p=null==n.verbose?1:n.verbose,{callbackList:d,history:f}=Ky(h,p,n.epochs,null,null,function(e,t){let n=null;null!=t.batchesPerEpoch?n=t.batchesPerEpoch:Number.isFinite(e.size)&&(n=e.size);return n}(t,n),null,r,c);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let m=null==n.initialEpoch?0:n.initialEpoch,g=await t.iterator();for(;m<n.epochs;){const u={};await d.onEpochBegin(m);let c=0,h=0;for(s||(g=await t.iterator());!s||c<n.batchesPerEpoch;){const t=await g.next();if(s&&t.done){console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=t.value){const{xs:s,ys:r}=Mb(e,t.value),a={};a.batch=h,a.size=s[0].shape[0],await d.onBatchBegin(h,a);const i=[];if(null!=n.classWeight){const t=Fb(n.classWeight,e.outputNames);for(let e=0;e<t.length;++e)i.push(await Db(r[e],null,t[e]))}const u=s.concat(r).concat(i),p=o(u);xi(u);for(let e=0;e<l.length;++e){const t=l[e],n=p[e];a[t]=n,wi(n)}await d.onBatchEnd(h,a),By(a),h++,c++}if(s?c>=n.batchesPerEpoch:t.done){if(r){let t;t=Pb(n.validationData)?Rm(await e.evaluateDataset(n.validationData,{batches:n.validationBatches})):Rm(e.evaluate(a,i,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)u[`val_${e.metricsNames[n]}`]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(m,u),m++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Pb(e){return"function"==typeof e.iterator}function Bb(e){u(e>0&&Number.isInteger(e),(()=>`batchSize is required to be a positive integer, but got ${e}`))}function Wb(e,t,n){return null==e?[null]:Array.isArray(e)?e.map((e=>xg(e,t,n-t))):xg(e,t,n-t)}function Vb(e,t){return bi((()=>null==e?null:Array.isArray(e)?e.map((e=>Vb(e,t))):$g(e,"int32"===t.dtype?t:qa(t,"int32"))))}function Ub(e,t){const n=[];let s=0,r=null;for(;s<e;)r=s+t,r>=e&&(r=e),n.push([s,r]),s=r;return n}async function Gb(e,t,n,s={}){if(e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let a,i,o,l,u,c,h,p,d;e.isTraining=!0;try{const f=null==s.batchSize?32:s.batchSize;Bb(f);const m=!1,g=await e.standardizeUserData(t,n,s.sampleWeight,s.classWeight,m,f);a=g[0],i=g[1],d=g[2];let y,b=!1;if(null!=s.validationData&&s.validationData.length>0){if(b=!0,2!==s.validationData.length)throw 3===s.validationData.length?new Im("validationData including sample weights is not supported yet."):new Nm(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${s.validationData} is invalid.`);u=s.validationData[0],c=s.validationData[1];const t=!0,n=await e.standardizeUserData(u,c,null,null,t,f);h=n[0],p=n[1],y=h.concat(p)}else if(null!=s.validationSplit&&s.validationSplit>0&&s.validationSplit<1){b=!0;const e=Math.floor(a[0].shape[0]*(1-s.validationSplit)),t=a[0].shape[0];h=Wb(a,e,t),o=a,a=Wb(a,0,e),p=Wb(i,e,t),l=i,i=Wb(i,0,e),y=h.concat(p)}else null!=s.validationSteps&&(b=!0);const x=a.concat(i).concat(d);e.checkTrainableWeightsConsistency();const w=e.makeTrainFunction(),v=e.getDedupedMetricsNames();let k,N;b?(e.makeTestFunction(),k=e.testFunction,N=v.slice().concat(v.map((e=>"val_"+e)))):(k=null,y=[],N=v.slice());const I=jy(s.callbacks,s.yieldEvery),S=await async function(e,t,n,s,a,i,o,l,u,c,h,p,d,f,m){null==a&&(a=32),null==i&&(i=1),null==h&&(h=!0),null==d&&(d=0);let g=!1;if(null!=u&&null!=c&&(g=!0),null!=m&&(g=!0,null==f))throw new Nm("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const y=e.checkNumSamples(n,a,f,"steps_per_epoch");let b;null!=y&&(b=fg(0,y)),null==o&&(o=1);const{callbackList:x,history:w}=Ky(l,o,i,d,y,f,a,g,p);x.setModel(e),e.history=w,await x.onTrainBegin(),e.stopTraining_=!1;for(let o=d;o<i;++o){await x.onEpochBegin(o);const i={};if(null!=f)throw new Im("stepsPerEpoch mode is not implemented yet.");{if("batch"===h)throw new Im("batch shuffling is not implemneted yet");h&&r(b);const o=ch(b),l=Ub(y,a);for(let r=0;r<l.length;++r){const h={};if(await x.onBatchBegin(r,h),bi((()=>{const p=l[r][0],d=l[r][1],f=xg(o,p,d-p);h.batch=r,h.size=d-p;const m=Vb(n,f),y=t(m);for(let e=0;e<s.length;++e){const t=s[e],n=y[e];h[t]=n,wi(n)}if(r===l.length-1&&g){const t=e.testLoop(u,c,a);for(let e=0;e<s.length;++e){const n=s[e],r=t[e];wi(r),i["val_"+n]=r}}})),await x.onBatchEnd(r,h),By(h),e.stopTraining_)break}o.dispose()}if(await x.onEpochEnd(o,i),e.stopTraining_)break}return await x.onTrainEnd(),await e.history.syncData(),e.history}(e,w,x,v,f,s.epochs,s.verbose,I,k,y,s.shuffle,N,s.initialEpoch,null,null);return S}finally{e.isTraining=!1,jb(a,t),jb(i,n),jb(o,t),jb(l,n),jb(h,u),jb(p,c),null!=d&&xi(d)}}function Hb(e){const t=[];e instanceof br&&(e=[e]);for(let n=0;n<e.length;++n){const s=e[n];if(1===s.rank)t.push(bg(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");t.push(s)}}return t}function jb(e,t){if(null==e)return;const n=[];if(t instanceof br)n.push(t.id);else if(Array.isArray(t))t.forEach((e=>n.push(e.id)));else if(null!=t)for(const e in t){const s=t[e];n.push(s.id)}const s=[];if(e instanceof br)-1===n.indexOf(e.id)&&s.push(e);else if(Array.isArray(e))e.forEach((e=>{-1===n.indexOf(e.id)&&s.push(e)}));else if(null!=e)for(const t in e){const r=e[t];-1===n.indexOf(r.id)&&s.push(r)}s.forEach((e=>{e.isDisposed||e.dispose()}))}function qb(e){return Array.isArray(e)}function Kb(e){return!function(e){return e instanceof br}(e)&&!qb(e)}function Xb(e,t,n,s=!0,r=""){if(null==t||0===t.length){if(null!=e){let t=!1;if(qb(e)&&e.length>0)t=!0;else if(Kb(e)){for(const n in e)if(e.hasOwnProperty(n)){t=!0;break}}else t=!0;if(t)throw new Nm(`Error when checking model ${r} expected no data, but got ${e}`)}return[]}if(null==e)return t.map((e=>null));let a;if(Kb(e)){a=[];for(const n of t){if(null==e[n])throw new Nm(`No data provided for "${n}". Need data for each key in: ${t}`);a.push(e[n])}}else if(qb(e)){if(e.length!==t.length)throw new Nm(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${t.length} Tensor(s), but instead got the following list of Tensor(s): ${e}`);a=e}else{if(t.length>1)throw new Nm(`The model ${r} expects ${t.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${e.shape}`);a=[e]}if(a=Hb(a),null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Nm(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s). but got array with shape ${i.shape}`);for(let t=0;t<n[e].length;++t){if(0===t&&!s)continue;const a=i.shape[t],o=n[e][t];if(null!=o&&o>=0&&a!==o)throw new Nm(`${r} expected a batch of elements where each example has shape [${n[e].slice(1,n[e].length)}] (i.e.,tensor shape [*,${n[e].slice(1,n[e].length)}]) but the ${r} received an input with ${i.shape[0]} examples, each with shape [${i.shape.slice(1,i.shape.length)}] (tensor shape [${i.shape}])`)}}return a}function Yb(e,t,n,s=!0,r=""){let a;if(Array.isArray(e)){if(e.length!==t.length)throw new Nm(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${t.length} Tensor(s), but instead got ${e.length} Tensors(s).`);a=e}else{if(t.length>1)throw new Nm(`The model expects ${t.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(e.shape)}.`);a=[e]}if(null!=n)for(let e=0;e<t.length;++e){if(null==n[e])continue;const i=a[e];if(i.shape.length!==n[e].length)throw new Nm(`Error when checking ${r}: expected ${t[e]} to have ${n[e].length} dimension(s), but got array with shape ${JSON.stringify(i.shape)}`);for(let a=0;a<n[e].length;++a){if(0===a&&!s)continue;const o=i.shape[a],l=n[e][a];if(null!=l&&l!==o)throw new Nm(`Error when checking ${r}: expected ${t[e]} to have shape ${JSON.stringify(n[e])} but got array with shape ${JSON.stringify(i.shape)}.`)}}}class Zb extends Rb{constructor(e){super(e),this.isTraining=!1}summary(e,t,n=console.log){if(!this.built)throw new Nm("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");Nb(this,e,t,n)}compile(e){if(null==e.loss&&(e.loss=[]),this.loss=e.loss,"string"==typeof e.optimizer)this.optimizer_=function(e){const t={Adagrad:()=>td.adagrad(.01),Adadelta:()=>td.adadelta(1,.95,gg()),Adam:()=>td.adam(.001,.9,.999,gg()),Adamax:()=>td.adamax(.002,.9,.999,gg(),0),RMSProp:()=>td.rmsprop(.001,.9,0,gg()),SGD:()=>td.sgd(.01)};if(t.adagrad=t.Adagrad,t.adadelta=t.Adadelta,t.adam=t.Adam,t.adamax=t.Adamax,t.rmsprop=t.RMSProp,t.sgd=t.SGD,e in t)return t[e]();throw new Nm(`Unknown Optimizer ${e}`)}(e.optimizer),this.isOptimizerOwned=!0;else{if(!(e.optimizer instanceof jp))throw new Nm("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=e.optimizer,this.isOptimizerOwned=!1}let t=[];if(Array.isArray(e.loss)||"string"==typeof e.loss||"function"==typeof e.loss)if(Array.isArray(e.loss)){if(e.loss.length!==this.outputs.length)throw new Nm(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${e.loss}.`);const n=e.loss;t=n.map((e=>ob(e)))}else{const n=ob(e.loss);this.outputs.forEach((e=>{t.push(n)}))}else{e.loss=e.loss;for(const t in e.loss)if(-1===this.outputNames.indexOf(t))throw new Nm(`Unknown entry in loss dictionary: "${t}". Only expected the following keys: ${this.outputNames}`);for(const n of this.outputNames)null==e.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),t.push(ob(e.loss[n]))}this.lossFunctions=t,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let e=0;e<this.outputs.length;++e){const t=this.internalOutputShapes[e],n=this.outputNames[e];this.feedOutputNames.push(n),this.feedOutputShapes.push(t),this.feedLossFns.push(this.lossFunctions[e])}const n=[];this.metrics=e.metrics,this.metricsNames=["loss"],this.metricsTensors=[],ig("loss",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;const t=this.lossFunctions[e];this.outputs.length>1&&(this.metricsTensors.push([t,e]),this.metricsNames.push(this.outputNames[e]+"_loss"))}}));const s=function(e,t){if(null==e||Array.isArray(e)&&0===e.length)return t.map((e=>[]));let n;if("string"==typeof e||"function"==typeof e)n=[e];else{if(!Array.isArray(e)&&"object"!=typeof e)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${e}`);n=e}if(Array.isArray(n))return t.map((e=>n));{const e=[];for(const s of t){let t=n.hasOwnProperty(s)?n[s]:[];Array.isArray(t)||(t=[t]),e.push(t)}return e}}(e.metrics,this.outputNames),r=(e,t,n)=>{this.outputNames.length>1&&(t=this.outputNames[e]+"_"+t),this.metricsNames.push(t),this.metricsTensors.push([n,e])};ig("metric",(()=>{for(let e=0;e<this.outputs.length;++e){if(-1!==n.indexOf(e))continue;(t=>{let n,s,a;for(const i of t){if("string"==typeof i&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(i)){const t=this.internalOutputShapes[e];let r;1===t[t.length-1]||this.lossFunctions[e]===sb?-1!==["accuracy","acc"].indexOf(i)?s=lb:-1!==["crossentropy","ce"].indexOf(i)&&(s=db):this.lossFunctions[e]===nb?-1!==["accuracy","acc"].indexOf(i)?s=fb:-1!==["crossentropy","ce"].indexOf(i)&&(s=gb):-1!==["accuracy","acc"].indexOf(i)?s=ub:-1!==["crossentropy","ce"].indexOf(i)&&(s=mb),-1!==["accuracy","acc"].indexOf(i)?r="acc":-1!==["crossentropy","ce"].indexOf(i)&&(r="ce"),a=s,n=""+r}else{const e=bb(i);a=e,n=""+xb(i)}let t;ig(n,(()=>{t=a})),r(e,n,t)}})(s[e])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(e,t,n={}){const s=null==n.batchSize?32:n.batchSize;Bb(s);const r=this.standardizeUserDataXY(e,t,!0,s);try{const a=r[0].concat(r[1]);this.makeTestFunction();const i=this.testFunction;return Am(this.testLoop(i,a,s,n.verbose,n.steps))}finally{jb(r[0],e),jb(r[1],t)}}async evaluateDataset(e,t){return this.makeTestFunction(),async function(e,t,n){const s=null!=(n=n||{}).batches,r=e.testFunction;let a=[];if(n.verbose>0)throw new Im("Verbose mode is not implemented yet.");u(!s||n.batches>0&&Number.isInteger(n.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(n.batches)}`));const i="function"==typeof t.next?t:await t.iterator();let o=0,l=0;for(;!s||l<n.batches;){const t=await i.next();if(a=bi((()=>{if(t.value){const{xs:n,ys:s}=Mb(e,t.value),i=n.concat(s),u=bi((()=>r(i)));if(xi(i),0===l)for(let e=0;e<u.length;++e)a.push(Ql(0));const c=i[0].shape[0];for(let e=0;e<u.length;++e){const t=u[e],n=a[e];a[e]=bi((()=>xo(a[e],ko(c,t)))),l>0&&xi(n)}xi(u),o+=c,++l}return a})),t.done){s&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${n.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const t=a[e];a[e]=vo(a[e],o),xi(t)}return Am(a)}(this,e,t)}checkNumSamples(e,t,n,s="steps"){let r;if(null!=n){if(r=null,null!=t)throw new Nm(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${t}`)}else{if(null==e)throw new Nm(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(e)?e[0].shape[0]:e.shape[0]}return r}execute(e,t){if(Array.isArray(t)&&0===t.length)throw new Nm("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(t),s=n?t:[t],r=this.retrieveSymbolicTensors(s),a=new xy;if(e instanceof br&&(e=[e]),Array.isArray(e)){if(e.length!==this.inputs.length)throw new Nm(`The number of inputs provided (${e.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let t=0;t<this.inputs.length;++t)a.add(this.inputs[t],e[t])}else for(const t of this.inputs){const n=e[t.name];if(null==n)throw new Nm(`No value is provided for the model's input ${t.name}`);a.add(t,n)}const i=ky(r,a);return n?i:i[0]}retrieveSymbolicTensors(e){const t=$m(null,e.length);let n=e.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],a=r.map((e=>e.name));for(let s=0;s<e.length;++s){const i=a.indexOf(e[s]);if(-1!==i&&(t[s]=r[i],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw t.forEach(((t,s)=>{null==t&&n.push(e[s])})),new Nm(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return t}predictLoop(e,t=32,n=!1){return bi((()=>{const s=this.checkNumSamples(e);if(n)throw new Im("Verbose predictLoop() is not implemented yet.");const r=Ub(s,t),a=this.outputs.map((e=>[]));for(let t=0;t<r.length;++t){bi((()=>{const n=r[t][0],s=r[t][1],a=Wb(e,n,s),i=[];if(Array.isArray(a))for(let e=0;e<a.length;++e)i.push({key:this.inputs[e],value:a[e]});else i.push({key:this.inputs[0],value:a});const o=new xy(i);return ky(this.outputs,o)})).forEach(((e,t)=>a[t].push(e)))}return Am(a.map((e=>Qo(e,0))))}))}predict(e,t={}){const n=Hb(e);Yb(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==t.batchSize?32:t.batchSize;return Bb(s),this.predictLoop(n,s)}finally{jb(n,e)}}predictOnBatch(e){Yb(e,this.inputNames,this.feedInputShapes,!0);const t=(Array.isArray(e)?e[0]:e).shape[0];return this.predictLoop(e,t)}standardizeUserDataXY(e,t,n=!0,s){if(null==this.optimizer_)throw new km("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const r=[];for(let e=0;e<this.feedOutputShapes.length;++e){const t=this.feedOutputShapes[e];this.feedLossFns[e]===nb?r.push(t.slice(0,t.length-1).concat([1])):r.push(t)}if(function(e,t,n){const s=Pm(e.map((e=>e.shape[0])));s.sort();const r=Pm(t.map((e=>e.shape[0])));if(r.sort(),s.length>1)throw new Nm(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(e.map((e=>e.shape)))}`);if(r.length>1)throw new Nm(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((e=>e.shape)))}`);if(s.length>0&&r.length>0&&!f(s,r))throw new Nm(`Input Tensors should have the same number of samples as target Tensors. Found ${s[0]} input sample(s) and ${r[0]} target sample(s).`)}(e=Xb(e,this.feedInputNames,this.feedInputShapes,!1,"input"),t=Xb(t,this.feedOutputNames,r,!1,"target")),function(e,t,n){const s=[Zy,sb,tb];for(let r=0;r<e.length;++r){const a=e[r],i=t[r],o=n[r];if(null!=i){if(i===tb&&1===a.shape[a.shape.length-1])throw new Nm(`You are passing a target array of shape ${a.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(i)){const e=a.shape.slice(1),t=o.slice(1);for(let n=0;n<e.length;++n){const s=e[n],r=t[n];if(null!=r&&s!==r)throw new Nm(`A target Tensor with shape ${a.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(t,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=s&&s>0&&e[0].shape[0]%s!=0)throw new Nm(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${s}. Found: ${e[0].shape[0]} sample(s).`);return[e,t]}async standardizeUserData(e,t,n,s,r=!0,a){const[i,o]=this.standardizeUserDataXY(e,t,r,a);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const e=Fb(s,this.outputNames);l=[];for(let t=0;t<e.length;++t)l.push(await Db(o[t],null,e[t]))}return[i,o,l]}testLoop(e,t,n,s=0,r){return bi((()=>{const a=this.checkNumSamples(t,n,r,"steps"),i=[];if(s>0)throw new Im("Verbose mode is not implemented yet.");if(null!=r)throw new Im("steps mode in testLoop() is not implemented yet");{const s=Ub(a,n),r=ch(fg(0,a));for(let n=0;n<s.length;++n){const a=s[n][0],o=s[n][1],l=xg(r,a,o-a),u=Vb(t,l),c=e(u);if(0===n)for(let e=0;e<c.length;++e)i.push(Ql(0));for(let e=0;e<c.length;++e){const t=c[e];i[e]=xo(i[e],ko(o-a,t))}}for(let e=0;e<i.length;++e)i[e]=vo(i[e],a)}return i}))}getDedupedMetricsNames(){const e=this.metricsNames,t=[];for(let n=0;n<e.length;++n){const s=e[n];let r=s;if(Em(e,s)>1){r+=`_${Em(e.slice(0,n),s)}`}t.push(r)}return t}makeTrainFunction(){return e=>{const t=[],n=e.slice(0,this.inputs.length),s=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],i=this.collectedTrainableWeights.map((e=>e.read()));return[this.optimizer_.minimize((()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:n[t]});const i=new xy(e),o=ky(this.outputs,i,{training:!0});let l;for(let e=0;e<this.lossFunctions.length;++e){let n=(0,this.lossFunctions[e])(s[e],o[e]);null!=r[e]&&(n=Ob(n,r[e]));const a=Hu(n);t.push(a),l=0===e?n:xo(l,n)}for(let e=0;e<this.metricsTensors.length;++e){let n;if(this.outputs.length>1&&e<this.outputs.length)n=t[e];else{const t=this.metricsTensors[e][0],r=this.metricsTensors[e][1];n=Hu(t(s[r],o[r]))}wi(n),a.push(n)}return l=Hu(l),this.calculateLosses().forEach((e=>{l=xo(l,e)})),l}),!0,i)].concat(a)}}makeTestFunction(){this.testFunction=e=>bi((()=>{const t=[];let n;const s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let e=0;e<this.inputs.length;++e)a.push({key:this.inputs[e],value:s[e]});const i=new xy(a),o=ky(this.outputs,i);for(let e=0;e<this.lossFunctions.length;++e){const s=this.lossFunctions[e],a=Hu(s(r[e],o[e]));n=0===e?a:xo(n,a),t.push(n)}for(let e=0;e<this.metricsTensors.length;++e){const n=this.metricsTensors[e][0],s=this.metricsTensors[e][1],a=Hu(n(r[s],o[s]));t.push(a)}return t}))}async fit(e,t,n={}){return Gb(this,e,t,n)}async fitDataset(e,t){return zb(this,e,t)}async trainOnBatch(e,t){const n=await this.standardizeUserData(e,t),s=n[0],r=n[1],a=this.makeTrainFunction()(s.concat(r)),i=[];for(const e of a){const t=await e.data();i.push(t[0])}return xi(a),jb(n[0],e),jb(n[1],t),Am(i)}getNamedWeights(e){const t=[],n=null!=e&&e.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let e=0;e<s.length;++e)n&&!s[e].trainable||t.push({name:s[e].originalName,tensor:r[e]});return t}set stopTraining(e){this.stopTraining_=e}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(e){this.optimizer_!==e&&(this.optimizer_=e,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const t=yi().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=t-yi().numTensors}return e}getLossIdentifiers(){let e;if("string"==typeof this.loss)e=_m(this.loss);else if(Array.isArray(this.loss)){for(const e of this.loss)if("string"!=typeof e)throw new Error("Serialization of non-string loss is not supported.");e=this.loss.map((e=>_m(e)))}else{const t=Object.keys(this.loss);e={};const n=this.loss;for(const s of t){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");e[s]=_m(n[s])}}return e}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[_m(xb(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((e=>_m(xb(e))));{const e={};for(const t in this.metrics)e[t]=_m(xb(this.metrics[t]));return e}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(e){if(null!=e.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=e.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=e.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const t=Xy(Cb(e.optimizer_config));let n,s;if("string"==typeof e.loss)n=Fm(e.loss);else if(Array.isArray(e.loss))n=e.loss.map((e=>Fm(e)));else if(null!=e.loss){n={};for(const t in e.loss)n[t]=Fm(e.loss[t])}if(Array.isArray(e.metrics))s=e.metrics.map((e=>Fm(e)));else if(null!=e.metrics){s={};for(const t in e.metrics)s[t]=Fm(e.metrics[t])}this.compile({loss:n,metrics:s,optimizer:t})}async save(e,t){if("string"==typeof e){const t=ma(e);if(0===t.length)throw new Nm(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Nm(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Nm("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await sa(this.getNamedWeights(t)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.19.0",convertedBy:null};if(null!=t&&t.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const e="optimizer",{data:t,specs:r}=await sa(await this.optimizer.getWeights(),e);n.specs.push(...r),n.data=la([n.data,t])}if(null!=this.userDefinedMetadata){const e=!0;vb(this.userDefinedMetadata,this.name,e),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,e.save(s)}setUserDefinedMetadata(e){vb(e,this.name),this.userDefinedMetadata=e}getUserDefinedMetadata(){return this.userDefinedMetadata}}Zb.className="Model",co(Zb);class Jb extends Zb{}async function Qb(e,t){if(null==t&&(t={}),"string"==typeof e){const n=ga(e,t);if(0===n.length)n.push(oi(e,t));else if(n.length>1)throw new Nm(`Found more than one (${n.length}) load handlers for URL '${e}'`);e=n[0]}return async function(e,t,n){null==n&&(n={});if(null==e.load)throw new Nm("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await e.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const a=null==n.strict||n.strict,i=null!=s.weightData&&null!=s.weightSpecs&&a,o=Xy(Cb(r),t,i),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new Nm("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:e,optimizerWeights:t}=function(e,t){const n=ra(e,t),s={},r=[];return t.forEach((e=>{"optimizer"===e.group?r.push({name:e.name,tensor:n[e.name]}):s[e.name]=n[e.name]})),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(e,a),null!=o.optimizer&&t.length>0&&await o.optimizer.setWeights(t),xi(e),xi(t.map((e=>e.tensor)))}return o}(e,void 0,t)}Jb.className="Functional",co(Jb);class ex extends Zb{constructor(e){if(super({inputs:[],outputs:[]}),e=e||{},this.trainable=!0,this.built=!1,this.name=null!=e.name?e.name:Xm("sequential_"),null!=e.layers)for(const t of e.layers)this.add(t)}checkShape(e){if(e.inboundNodes[0].outputTensors[0].shape.some((e=>e<0)))throw new Nm(`Negative dimension size caused by adding layer ${e.name} with input shape [${e.inboundNodes[0].inputTensors[0].shape}]`)}add(e){const t=e instanceof ex||e instanceof Zb;let n;if(t){if(n=e,1!==n.outputs.length)throw new Nm("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new Nm("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===e.inboundNodes.length){if(null==e.batchInputShape)throw new Nm("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const t=by({batchShape:e.batchInputShape,dtype:e.dtype,name:e.name+"_input"});e.apply(t)}if(t)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==e.inboundNodes.length)throw new Nm(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${e.name} which has ${e.inboundNodes.length} pre-existing inbound connections.`);if(1!==e.inboundNodes[0].outputTensors.length)throw new Nm("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[e.inboundNodes[0].outputTensors[0]],this.inputs=gy(this.outputs[0])}this.inboundNodes=[],new dy({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:$m(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((e=>e.shape)),outputShapes:this.outputs[0].shape})}else{const t=e.apply(this.outputs[0]);if(Array.isArray(t))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(e),this.outputs=[t],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(e),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const e=this.layers.length-1;this.layers[e].outboundNodes=[],this.outputs=[this.layers[e].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(e,t){return null==this.model&&this.build(),this.model.call(e,t)}build(e){if(ry(e),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Zb({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(e,t,n=console.log){this.built||this.build(),super.summary(e,t,n)}setWeights(e){null==this.model&&this.build(),this.model.setWeights(e)}evaluate(e,t,n={}){if(!this.built)throw new km("The model needs to be compiled before being used.");return this.model.evaluate(e,t,n)}async evaluateDataset(e,t){if(!this.built)throw new km("The model needs to be compiled before being used.");return this.model.evaluateDataset(e,t)}predict(e,t={}){return null==this.model&&this.build(),this.model.predict(e,t)}predictOnBatch(e){return null==this.model&&this.build(),this.model.predictOnBatch(e)}compile(e){this.build(),this.model.compile(e),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(e){this.model.optimizer=e}async fit(e,t,n={}){if(!this.built)throw new km("The model needs to be compiled before being used.");return this.model.fit(e,t,n)}async fitDataset(e,t){if(!this.built)throw new km("The model needs to be compiled before being used.");return this.model.fitDataset(e,t)}async trainOnBatch(e,t){return this.model.trainOnBatch(e,t)}static fromConfig(e,t,n={},s=!1){let r,a={};if(t instanceof Array){if(null==t[0].className||"Merge"===t[0].className)throw new Nm("Legacy serialization format not supported yet.");r=t}else u(null!=t.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),r=t.layers,delete t.layers,a=t;const i=new e(a);if(!(i instanceof ex))throw new Im(`Sequential.fromConfig called on non-Sequential input: ${i}`);for(const e of r){const t=Xy(e,void 0,s);s&&t.setFastWeightInitDuringBuild(!0),i.add(t)}return i}set stopTraining(e){if(null==this.model)throw new Nm("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=e}get stopTraining(){if(null==this.model)throw new Nm("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const e=[];for(const t of this.layers){const n={};n.className=t.getClassName(),n.config=t.getConfig(),e.push(n)}return{name:this.name,layers:e}}}function tx(e){return by(e)}ex.className="Sequential",co(ex);class nx extends lo{getConfig(){return{}}}class sx extends nx{apply(e,t=1){return function(e,t=1){if(1!==t)throw new Im(`Support for alpha values other than 1 (${t}) is not implemented yet.`);return Bl(e)}(e,t)}}sx.className="elu",co(sx);class rx extends nx{apply(e){return Vc(e)}}rx.className="selu",co(rx);class ax extends nx{apply(e){return Fc(e)}}ax.className="relu",co(ax);class ix extends nx{apply(e){return bi((()=>Xu(6,Fc(e))))}}ix.className="relu6",co(ix);class ox extends nx{apply(e){return e}}ox.className="linear",co(ox);class lx extends nx{apply(e){return el(e)}}lx.className="sigmoid",co(lx);class ux extends nx{apply(e){return function(e){return bi((()=>{const t=xo(.5,ko(.2,e));return dl(t,0,1)}))}(e)}}ux.className="hardSigmoid",co(ux);class cx extends nx{apply(e){return Eu(e)}}cx.className="softplus",co(cx);class hx extends nx{apply(e){return function(e){return bi((()=>vo(e,xo(No(e),1))))}(e)}}hx.className="softsign",co(hx);class px extends nx{apply(e){return nl(e)}}px.className="tanh",co(px);class dx extends nx{apply(e,t=-1){return Jc(e,t)}}dx.className="softmax",co(dx);class fx extends nx{apply(e,t=-1){return _u(e,t)}}fx.className="logSoftmax",co(fx);class mx extends nx{apply(e,t=1){return bi((()=>ko(el(ko(e,t)),e)))}}mx.className="swish",co(mx);class gx extends nx{apply(e){return bi((()=>ko(e,nl(Eu(e)))))}}function yx(e){return e.getClassName()}function bx(e,t={}){return Lm(e,uo.getMap().classNameMap,t,"activation")}function xx(e){if(null==e){const e={className:"linear",config:{}};return bx(e)}if("string"==typeof e){const t={};return t.className=e,t.config={},bx(t)}return e instanceof nx?e:bx(e)}function wx(e){if(null!=e&&"object"!=typeof e)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${e}`)}gx.className="mish",co(gx);class vx extends lo{}class kx extends vx{constructor(e){super(),wx(e),this.l1=null==e||null==e.l1?.01:e.l1,this.l2=null==e||null==e.l2?.01:e.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return bi((()=>{let t=ju([1]);return this.hasL1&&(t=xo(t,nu(ko(this.l1,No(e))))),this.hasL2&&(t=xo(t,nu(ko(this.l2,Cg(e))))),Yo(t,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(e,t){return new e({l1:t.l1,l2:t.l2})}}kx.className="L1L2",co(kx);const Nx={l1l2:"L1L2"};function Ix(e){return Om(e)}function Sx(e,t={}){return Lm(e,uo.getMap().classNameMap,t,"regularizer")}function Tx(e){if(null==e)return null;if("string"==typeof e){return Sx({className:e in Nx?Nx[e]:e,config:{}})}return e instanceof vx?e:Sx(e)}class $x extends my{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,null!=e&&(this.maxValue=e.maxValue)}call(e,t){e=sy(e);let n=Fc(e);return null!=this.maxValue&&(n=dl(n,0,this.maxValue)),n}computeOutputShape(e){return e}getConfig(){const e={maxValue:this.maxValue},t=super.getConfig();return Object.assign(e,t),e}}$x.className="ReLU",co($x);class Cx extends my{constructor(e){super(null==e?{}:e),this.DEFAULT_ALPHA=.3,null==e&&(e={}),this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=sy(e);return xu(n,this.alpha)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Cx.className="LeakyReLU",co(Cx);class Ex extends my{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==e&&(e={}),this.supportsMasking=!0,this.alphaInitializer=ey(e.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Tx(e.alphaRegularizer),this.alphaConstraint=Oy(e.alphaConstraint),null==e.sharedAxes)this.sharedAxes=null;else if(Array.isArray(e.sharedAxes))this.sharedAxes=e.sharedAxes;else{if("number"!=typeof e.sharedAxes)throw new Nm(`Expected sharedAxes to be a number or an array of numbers, but got ${e.sharedAxes}`);this.sharedAxes=[e.sharedAxes]}}build(e){const t=(e=ry(e)).slice(1);if(null!=this.sharedAxes)for(const e of this.sharedAxes)t[e-1]=1;this.alpha=this.addWeight("alpha",t,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let t=1;t<e.length;++t)n[t]=e[t];this.inputSpec=[new cy({ndim:e.length,axes:n})],this.built=!0}call(e,t){return e=sy(e),hc(e,this.alpha.read())}getConfig(){const e={alphaInitializer:Qg(this.alphaInitializer),alphaRegularizer:Ix(this.alphaRegularizer),alphaConstraint:Fy(this.alphaConstraint),sharedAxes:this.sharedAxes},t=super.getConfig();return Object.assign(e,t),e}}Ex.className="PReLU",co(Ex);class Ax extends my{constructor(e){if(super(null==e?{}:e),this.DEFAULT_ALPHA=1,null==e&&(e={}),null!=e.alpha&&e.alpha!==this.DEFAULT_ALPHA)throw new Im(`Non-default alpha value (${e.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==e.alpha?this.DEFAULT_ALPHA:e.alpha}call(e,t){const n=sy(e);return Bl(n)}computeOutputShape(e){return e}getConfig(){const e={alpha:this.alpha},t=super.getConfig();return Object.assign(e,t),e}}Ax.className="ELU",co(Ax);class Rx extends my{constructor(e){super(null==e?{}:e),this.DEFAULT_THETA=1,null==e&&(e={}),this.theta=null==e.theta?this.DEFAULT_THETA:e.theta}call(e,t){const n=sy(e);return ko(n,qa(fu(n,this.theta),"float32"))}computeOutputShape(e){return e}getConfig(){const e={theta:this.theta},t=super.getConfig();return Object.assign(e,t),e}}Rx.className="ThresholdedReLU",co(Rx);class _x extends my{constructor(e){super(null==e?{}:e),this.DEFAULT_AXIS=1,null==e&&(e={}),this.softmax=(new dx).apply,this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis}call(e,t){const n=sy(e);return this.softmax(n,this.axis)}computeOutputShape(e){return e}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function Fx(e,t,n){if("number"==typeof e)return $m(e,t);if(e.length!==t)throw new Nm(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${e.length} elements.`);for(let r=0;r<t;++r){const a=e[r];if((s=a)!==parseInt(s.toString(),10))throw new Nm(`The ${n} argument must be an integer or tuple of ${t} integers. Received: ${JSON.stringify(e)} including a non-integer number ${a}`)}return e;var s}function Dx(e,t,n,s,r=1){if(null==e)return e;let a;return a="same"===n?e:e-(t+(t-1)*(r-1))+1,Math.floor((a+s-1)/s)}function Ox(e,t,n,s){if(null==e)return null;if("valid"===s)e=e*t+dg([n-t,0]);else{if("same"!==s)throw new Nm(`Unsupport padding mode: ${s}.`);e*=t}return e}function Mx(e,t){return bi((()=>(ng(t),"channelsFirst"===t?$i(e,[0,2,3,1]):e)))}function Lx(e,t){return bi((()=>(ng(t),"channelsFirst"===t?$i(e,[0,2,3,4,1]):e)))}function zx(e,t,n,s=1,r="valid",a,i=1){return bi((()=>{if(null==a&&(a="channelsLast"),ng(a),3!==e.shape.length)throw new Nm(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);if(3!==t.shape.length)throw new Nm(`The kernel for a conv1dWithBias operation should be 3, but is ${t.shape.length} instead`);if(null!=n&&1!==n.shape.length)throw new Nm(`The bias for a conv1dWithBias operation should be 1, but is ${t.shape.length} instead`);if("channelsFirst"===a&&(e=$i(e,[0,2,1])),"causal"===r)throw new Im("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let o=xl(e,t,s,"same"===r?"same":"valid","NWC",i);return null!=n&&(o=Ag(o,n)),o}))}function Px(e,t,n,s=[1,1],r="valid",a,i,o=null){return bi((()=>{if(null==a&&(a="channelsLast"),ng(a),3!==e.rank&&4!==e.rank)throw new Nm(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==t.rank&&4!==t.rank)throw new Nm(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let l=Mx(e,a);if("causal"===r)throw new Im("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return l=zh({x:l,filter:t,strides:s,pad:"same"===r?"same":"valid",dilations:i,dataFormat:"NHWC",bias:n,activation:o}),"channelsFirst"===a&&(l=$i(l,[0,3,1,2])),l}))}function Bx(e,t,n,s=[1,1,1],r="valid",a,i){return bi((()=>{if(null==a&&(a="channelsLast"),ng(a),4!==e.rank&&5!==e.rank)throw new Nm(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);if(4!==t.rank&&5!==t.rank)throw new Nm(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);let o=Lx(e,a);if("causal"===r)throw new Im("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return o=kl(o,t,s,"same"===r?"same":"valid","NDHWC",i),null!=n&&(o=Ag(o,n)),"channelsFirst"===a&&(o=$i(o,[0,4,1,2,3])),o}))}_x.className="Softmax",co(_x);class Wx extends my{constructor(e,t){if(super(t),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Wx.verifyArgs(t),this.rank=e,Um(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new Im(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Fx(t.kernelSize,e,"kernelSize"),this.strides=Fx(null==t.strides?1:t.strides,e,"strides"),this.padding=null==t.padding?"valid":t.padding,sg(this.padding),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,ng(this.dataFormat),this.activation=xx(t.activation),this.useBias=null==t.useBias||t.useBias,this.biasInitializer=ey(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Oy(t.biasConstraint),this.biasRegularizer=Tx(t.biasRegularizer),this.activityRegularizer=Tx(t.activityRegularizer),this.dilationRate=Fx(null==t.dilationRate?1:t.dilationRate,e,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new Nm(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new Nm(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new Nm(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(e){if(Cm("kernelSize"in e,"required key 'kernelSize' not in config"),"number"!=typeof e.kernelSize&&!Vm(e.kernelSize,"number",1,3))throw new Nm(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(e.kernelSize)}.`)}getConfig(){const e={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:yx(this.activation),useBias:this.useBias,biasInitializer:Qg(this.biasInitializer),biasRegularizer:Ix(this.biasRegularizer),activityRegularizer:Ix(this.activityRegularizer),biasConstraint:Fy(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}class Vx extends Wx{constructor(e,t){super(e,t),this.kernel=null,Vx.verifyArgs(t),this.filters=t.filters,Um(this.filters,"filters"),this.kernelInitializer=ey(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Oy(t.kernelConstraint),this.kernelRegularizer=Tx(t.kernelRegularizer)}build(e){e=ry(e);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Nm(`The channel dimension of the input should be defined. Found ${e[t]}`);const n=e[t],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[t]:n}}],this.built=!0}call(e,t){return bi((()=>{let t;e=sy(e);const n=null==this.bias?null:this.bias.read(),s=Hm(this.activation.getClassName());if(null!=s&&2===this.rank)t=Px(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate,s);else{if(1===this.rank)t=zx(e,this.kernel.read(),n,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)t=Px(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new Im("convolutions greater than 3D are not implemented yet.");t=Bx(e,this.kernel.read(),n,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(t=this.activation.apply(t))}return t}))}computeOutputShape(e){e=ry(e);const t=[],n="channelsLast"===this.dataFormat?e.slice(1,e.length-1):e.slice(2);for(let e=0;e<n.length;++e){const s=Dx(n[e],this.kernelSize[e],this.padding,this.strides[e],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[e]);t.push(s)}let s=[e[0]];return"channelsLast"===this.dataFormat?(s=s.concat(t),s.push(this.filters)):(s.push(this.filters),s=s.concat(t)),s}getConfig(){const e={filters:this.filters,kernelInitializer:Qg(this.kernelInitializer),kernelRegularizer:Ix(this.kernelRegularizer),kernelConstraint:Fy(this.kernelConstraint)},t=super.getConfig();return Object.assign(e,t),e}static verifyArgs(e){if(!("filters"in e)||"number"!=typeof e.filters||e.filters<1)throw new Nm(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(e.filters)}`)}}class Ux extends Vx{constructor(e){super(2,e),Ux.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Vm(e.kernelSize,"number",1,2))throw new Nm(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(e.kernelSize)}.`)}}Ux.className="Conv2D",co(Ux);class Gx extends Vx{constructor(e){super(3,e),Gx.verifyArgs(e)}getConfig(){const e=super.getConfig();return delete e.rank,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&(!Array.isArray(e.kernelSize)||1!==e.kernelSize.length&&3!==e.kernelSize.length))throw new Nm(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(e.kernelSize)}.`)}}Gx.className="Conv3D",co(Gx);class Hx extends Ux{constructor(e){if(super(e),this.inputSpec=[new cy({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new Nm(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(4!==(e=ry(e)).length)throw new Nm("Input should have rank 4; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Nm("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new cy({ndim:4,axes:{[t]:n}})],this.built=!0}call(e,t){return bi((()=>{let t=sy(e);if(4!==t.shape.length)throw new Nm(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a;"channelsFirst"===this.dataFormat?(r=2,a=3):(r=1,a=2);const i=n[r],o=n[a],l=this.kernelSize[0],u=this.kernelSize[1],c=this.strides[0],h=this.strides[1],p=[s,Ox(i,c,l,this.padding),Ox(o,h,u,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=$i(t,[0,2,3,1]));let d=vl(t,this.kernel.read(),p,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(d=$i(d,[0,3,1,2])),null!=this.bias&&(d=Ag(d,this.bias.read(),this.dataFormat)),null!=this.activation&&(d=this.activation.apply(d)),d}))}computeOutputShape(e){const t=(e=ry(e)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const a=this.kernelSize[0],i=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return t[n]=this.filters,t[s]=Ox(t[s],o,a,this.padding),t[r]=Ox(t[r],l,i,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}Hx.className="Conv2DTranspose",co(Hx);class jx extends Gx{constructor(e){if(super(e),this.inputSpec=[new cy({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new Nm(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(e){if(5!==(e=ry(e)).length)throw new Nm("Input should have rank 5; Received input shape: "+JSON.stringify(e));const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t])throw new Nm("The channel dimension of the inputs should be defined. Found `None`.");const n=e[t],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new cy({ndim:5,axes:{[t]:n}})],this.built=!0}call(e,t){return bi((()=>{let t=sy(e);if(5!==t.shape.length)throw new Nm(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${t.shape.length}`);const n=t.shape,s=n[0];let r,a,i;"channelsFirst"===this.dataFormat?(i=2,r=3,a=4):(i=1,r=2,a=3);const o=n[i],l=n[r],u=n[a],c=this.kernelSize[0],h=this.kernelSize[1],p=this.kernelSize[2],d=this.strides[0],f=this.strides[1],m=this.strides[2],g=[s,Ox(o,d,c,this.padding),Ox(l,f,h,this.padding),Ox(u,m,p,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(t=$i(t,[0,2,3,4,1]));let y=Il(t,this.kernel.read(),g,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(y=$i(y,[0,4,1,2,3])),null!==this.bias&&(y=Ag(y,this.bias.read(),this.dataFormat)),null!==this.activation&&(y=this.activation.apply(y)),y}))}computeOutputShape(e){const t=(e=ry(e)).slice();let n,s,r,a;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,a=4):(n=4,s=1,r=2,a=3);const i=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],c=this.strides[1],h=this.strides[2];return t[n]=this.filters,t[s]=Ox(t[s],u,i,this.padding),t[r]=Ox(t[r],c,o,this.padding),t[a]=Ox(t[a],h,l,this.padding),t}getConfig(){const e=super.getConfig();return delete e.dilationRate,e}}jx.className="Conv3DTranspose",co(jx);class qx extends Vx{constructor(e,t){if(super(e,t),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==t.filters)throw new Nm("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=t.kernelInitializer||null!=t.kernelRegularizer||null!=t.kernelConstraint)throw new Nm("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=t.padding&&"same"!==t.padding&&"valid"!==t.padding)throw new Nm(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(t.padding)}`);this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=ey(t.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Tx(t.depthwiseRegularizer),this.depthwiseConstraint=Oy(t.depthwiseConstraint),this.pointwiseInitializer=ey(t.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Tx(t.pointwiseRegularizer),this.pointwiseConstraint=Oy(t.pointwiseConstraint)}build(e){if((e=ry(e)).length<this.rank+2)throw new Nm(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(e)}`);const t="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[t]||e[t]<0)throw new Nm(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(e[t])}`);const n=e[t],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let e=0;e<this.rank;++e)r.push(1);r.push(n*this.depthMultiplier,this.filters);const a=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,a,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,a,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,a,this.biasConstraint):this.bias=null,this.inputSpec=[new cy({ndim:this.rank+2,axes:{[t]:n}})],this.built=!0}call(e,t){return bi((()=>{let t;if(e=sy(e),1===this.rank)throw new Im("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=$i(e,[0,2,3,1])),t=Uc(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(t=Ag(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),"channelsFirst"===this.dataFormat&&(t=$i(t,[0,3,1,2])),t}))}getConfig(){const e=super.getConfig();return delete e.rank,delete e.kernelInitializer,delete e.kernelRegularizer,delete e.kernelConstraint,e.depthwiseInitializer=Qg(this.depthwiseInitializer),e.pointwiseInitializer=Qg(this.pointwiseInitializer),e.depthwiseRegularizer=Ix(this.depthwiseRegularizer),e.pointwiseRegularizer=Ix(this.pointwiseRegularizer),e.depthwiseConstraint=Fy(this.depthwiseConstraint),e.pointwiseConstraint=Fy(this.pointwiseConstraint),e}}qx.className="SeparableConv";class Kx extends qx{constructor(e){super(2,e)}}Kx.className="SeparableConv2D",co(Kx);class Xx extends Vx{constructor(e){super(1,e),Xx.verifyArgs(e),this.inputSpec=[{ndim:3}]}getConfig(){const e=super.getConfig();return delete e.rank,delete e.dataFormat,e}static verifyArgs(e){if("number"!=typeof e.kernelSize&&!Vm(e.kernelSize,"number",1,1))throw new Nm(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(e.kernelSize)}.`)}}Xx.className="Conv1D",co(Xx);class Yx extends my{constructor(e){super(e),"number"==typeof e.cropping?this.cropping=[[e.cropping,e.cropping],[e.cropping,e.cropping]]:"number"==typeof e.cropping[0]?this.cropping=[[e.cropping[0],e.cropping[0]],[e.cropping[1],e.cropping[1]]]:this.cropping=e.cropping,this.dataFormat=void 0===e.dataFormat?"channelsLast":e.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(e){return"channelsFirst"===this.dataFormat?[e[0],e[1],e[2]-this.cropping[0][0]-this.cropping[0][1],e[3]-this.cropping[1][0]-this.cropping[1][1]]:[e[0],e[1]-this.cropping[0][0]-this.cropping[0][1],e[2]-this.cropping[1][0]-this.cropping[1][1],e[3]]}call(e,t){return bi((()=>{if(e=sy(e),"channelsLast"===this.dataFormat){const t=vg(e,this.cropping[0][0],e.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return vg(t,this.cropping[1][0],e.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const t=vg(e,this.cropping[0][0],e.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return vg(t,this.cropping[1][0],e.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const e={cropping:this.cropping,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}Yx.className="Cropping2D",co(Yx);class Zx extends my{constructor(e){var t;super(e),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==e.size?this.DEFAULT_SIZE:e.size,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,ng(this.dataFormat),this.interpolation=null==e.interpolation?"nearest":e.interpolation,t=this.interpolation,Wm(Zm,"InterpolationFormat",t)}computeOutputShape(e){if("channelsFirst"===this.dataFormat){const t=null==e[2]?null:this.size[0]*e[2],n=null==e[3]?null:this.size[1]*e[3];return[e[0],e[1],t,n]}{const t=null==e[1]?null:this.size[0]*e[1],n=null==e[2]?null:this.size[1]*e[2];return[e[0],t,n,e[3]]}}call(e,t){return bi((()=>{let t=sy(e);const n=t.shape;if("channelsFirst"===this.dataFormat){t=$i(t,[0,2,3,1]);const e=this.size[0]*n[2],s=this.size[1]*n[3],r="nearest"===this.interpolation?Wp.resizeNearestNeighbor(t,[e,s]):Wp.resizeBilinear(t,[e,s]);return $i(r,[0,3,1,2])}{const e=this.size[0]*n[1],s=this.size[1]*n[2];return"nearest"===this.interpolation?Wp.resizeNearestNeighbor(t,[e,s]):Wp.resizeBilinear(t,[e,s])}}))}getConfig(){const e={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},t=super.getConfig();return Object.assign(e,t),e}}Zx.className="UpSampling2D",co(Zx);class Jx extends Wx{constructor(e){super(2,e),this.depthwiseKernel=null,this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=ey(e.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Oy(e.depthwiseConstraint),this.depthwiseRegularizer=Tx(e.depthwiseRegularizer)}build(e){if((e=ry(e)).length<4)throw new Nm(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(e)}.`);const t="channelsFirst"===this.dataFormat?1:3;if(null==e[t]||e[t]<0)throw new Nm(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${e[t]}).`);const n=e[t],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return bi((()=>{let t=function(e,t,n=[1,1],s="valid",r,a){return bi((()=>{null==r&&(r="channelsLast"),ng(r);let i=Mx(e,r);if(4!==e.rank)throw new Nm(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);if(4!==t.rank)throw new Nm(`depthwiseKernel is required to be 4-D, but is instead ${t.rank}-D`);return i=Rl(i,t,n,"same"===s?"same":"valid","NHWC",a),"channelsFirst"===r&&(i=$i(i,[0,3,1,2])),i}))}(e=sy(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(t=Ag(t,this.bias.read(),this.dataFormat)),null!=this.activation&&(t=this.activation.apply(t)),t}))}computeOutputShape(e){e=ry(e);const t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[1]*this.depthMultiplier:e[3]*this.depthMultiplier,r=Dx(t,this.kernelSize[0],this.padding,this.strides[0]),a=Dx(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[e[0],s,r,a]:[e[0],r,a,s]}getConfig(){const e=super.getConfig();return e.depthMultiplier=this.depthMultiplier,e.depthwiseInitializer=Qg(this.depthwiseInitializer),e.depthwiseRegularizer=Ix(this.depthwiseRegularizer),e.depthwiseConstraint=Fy(this.depthwiseRegularizer),e}}function Qx(e,t,n,s){if(Array.isArray(e)){if(null!=t||null!=n)throw new Nm("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=e.slice(e.length-s,e.length),e=e.slice(0,e.length-s)),e.length>1&&(t=e.slice(1,e.length)),e=e[0]}function r(e){return null==e||Array.isArray(e)?e:[e]}return{inputs:e,initialState:t=r(t),constants:n=r(n)}}function ew(e,t,n,s=!1,r,a,i=!1,o=!1){return bi((()=>{const l=t.shape.length;if(l<3)throw new Nm(`Input should be at least 3D, but is ${l}D.`);const u=[1,0].concat(fg(2,l));if(t=$i(t,u),null!=a)throw new Im("The rnn() functoin of the deeplearn.js backend does not support constants yet.");i&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=qa(qa(r,"bool"),"float32")).rank===l-1&&(r=ou(r,-1)),r=$i(r,u)),s&&(t=Oc(t,0),null!=r&&(r=Oc(r,0)));const c=[];let h,p=n;const d=t.shape[0],f=xh(t);let m,g;null!=r&&(m=xh(r));for(let t=0;t<d;++t){const n=f[t],s=bi((()=>e(n,p)));if(null==r)h=s[0],p=s[1];else{const e=bi((()=>{const e=m[t],n=Ru(nc(e),e);return{output:xo(ko(s[0],e),ko(p[0],n)),newStates:p.map(((t,r)=>xo(ko(s[1][r],e),ko(t,n))))}}));h=e.output,p=e.newStates}o&&c.push(h)}if(o){g=ih(c,1)}return[h,g,p]}))}Jx.className="DepthwiseConv2D",co(Jx);class tw extends my{constructor(e){let t;if(super(e),null==e.cell)throw new Nm("cell property is missing for the constructor of RNN.");if(t=Array.isArray(e.cell)?new uw({cells:e.cell}):e.cell,null==t.stateSize)throw new Nm("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=t,this.returnSequences=null!=e.returnSequences&&e.returnSequences,this.returnState=null!=e.returnState&&e.returnState,this.goBackwards=null!=e.goBackwards&&e.goBackwards,this._stateful=null!=e.stateful&&e.stateful,this.unroll=null!=e.unroll&&e.unroll,this.supportsMasking=!0,this.inputSpec=[new cy({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return fg(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((e=>null))}return this.states_}setStates(e){this.states_=e}computeOutputShape(e){ty(e)&&(e=e[0]);let t=this.cell.stateSize;Array.isArray(t)||(t=[t]);const n=t[0];let s;if(s=this.returnSequences?[e[0],e[1],n]:[e[0],n],this.returnState){const n=[];for(const s of t)n.push([e[0],s]);return[s].concat(n)}return s}computeMask(e,t){return bi((()=>{Array.isArray(t)&&(t=t[0]);const e=this.returnSequences?t:null;if(this.returnState){const t=this.states.map((e=>null));return[e].concat(t)}return e}))}get states(){if(null==this.states_){const e=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,t=[];for(let n=0;n<e;++n)t.push(null);return t}return this.states_}set states(e){this.states_=e}build(e){if(null!=this.numConstants)throw new Im("Constants support is not implemented in RNN yet.");ty(e)&&(e=e[0]);const t=this.stateful?e[0]:null,n=e.slice(2);this.inputSpec[0]=new cy({shape:[t,null,...n]});const s=[e[0]].concat(e.slice(2));let r;if(this.cell.build(s),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!f(this.stateSpec.map((e=>e.shape[e.shape.length-1])),r))throw new Nm(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=r.map((e=>new cy({shape:[null,e]})));this.stateful&&this.resetStates()}resetStates(e,t=!1){bi((()=>{if(!this.stateful)throw new vm("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape[0];if(null==n)throw new Nm("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>ju([n,e]))):this.states_=[ju([n,this.cell.stateSize])];else if(null==e)xi(this.states_),null!=this.keptStates&&(xi(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>ju([n,e]))):this.states_[0]=ju([n,this.cell.stateSize]);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Nm(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);!0===t?this.keptStates.push(this.states_.slice()):xi(this.states_);for(let t=0;t<this.states_.length;++t){const s=e[t],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[n,r];if(!f(s.shape,a))throw new Nm(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map((e=>wi(e.clone())))}))}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Qx(e,n,s,this.numConstants);e=r.inputs,n=r.initialState,s=r.constants;let a=[],i=[];if(null!=n){t.initialState=n,a=a.concat(n),this.stateSpec=[];for(const e of n)this.stateSpec.push(new cy({shape:e.shape}));i=i.concat(this.stateSpec)}null!=s&&(t.constants=s,a=a.concat(s),this.numConstants=s.length);if(a[0]instanceof hy){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return bi((()=>{const n=null==t?null:t.mask,s=null==t?null:t.training;let r=null==t?null:t.initialState;e=sy(e),null==r&&(r=this.stateful?this.states_:this.getInitialState(e));const a=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==a)throw new Nm(`RNN Layer has ${a} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const i={training:s},o=ew(((e,t)=>{const n=this.cell.call([e].concat(t),i);return[n[0],n.slice(1)]}),e,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],c=o[2];this.stateful&&this.resetStates(c,s);const h=this.returnSequences?u:l;return this.returnState?[h].concat(c):h}))}getInitialState(e){return bi((()=>{let t=ju(e.shape);return t=nu(t,[1,2]),t=bg(t),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((e=>e>1?Ig(t,[1,e]):t)):this.cell.stateSize>1?[Ig(t,[1,this.cell.stateSize])]:[t]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(e)}getConfig(){const e=super.getConfig(),t={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(t.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===tw.className&&(t.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,e,t)}static fromConfig(e,t,n={}){const s=Xy(t.cell,n);return new e(Object.assign(t,{cell:s}))}}tw.className="RNN",co(tw);class nw extends my{}class sw extends nw{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Um(this.units,"units"),this.activation=xx(null==e.activation?this.DEFAULT_ACTIVATION:e.activation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=ey(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=ey(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=ey(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Tx(e.kernelRegularizer),this.recurrentRegularizer=Tx(e.recurrentRegularizer),this.biasRegularizer=Tx(e.biasRegularizer),this.kernelConstraint=Oy(e.kernelConstraint),this.recurrentConstraint=Oy(e.recurrentConstraint),this.biasConstraint=Oy(e.biasConstraint),this.dropout=pg([1,dg([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=pg([1,dg([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){e=ry(e),this.kernel=this.addWeight("kernel",[e[e.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return bi((()=>{if(2!==e.length)throw new Nm(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let n=e[1];e=e[0];const s=null!=t.training&&t.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=cw({ones:()=>nc(e),rate:this.dropout,training:s,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=cw({ones:()=>nc(n),rate:this.recurrentDropout,training:s,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,i=this.recurrentDropoutMask;r=Tg(null!=a?ko(e,a):e,this.kernel.read()),null!=this.bias&&(r=Ag(r,this.bias.read())),null!=i&&(n=ko(n,i));let o=xo(r,Tg(n,this.recurrentKernel.read()));return null!=this.activation&&(o=this.activation.apply(o)),[o,o]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:yx(this.activation),useBias:this.useBias,kernelInitializer:Qg(this.kernelInitializer),recurrentInitializer:Qg(this.recurrentInitializer),biasInitializer:Qg(this.biasInitializer),kernelRegularizer:Ix(this.kernelRegularizer),recurrentRegularizer:Ix(this.recurrentRegularizer),biasRegularizer:Ix(this.biasRegularizer),activityRegularizer:Ix(this.activityRegularizer),kernelConstraint:Fy(this.kernelConstraint),recurrentConstraint:Fy(this.recurrentConstraint),biasConstraint:Fy(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},e,t)}}sw.className="SimpleRNNCell",co(sw);class rw extends tw{constructor(e){e.cell=new sw(e),super(e)}call(e,t){return bi((()=>{null!=this.cell.dropoutMask&&(xi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(xi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return new e(t)}}rw.className="SimpleRNN",co(rw);class aw extends nw{constructor(e){if(super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",e.resetAfter)throw new Nm("GRUCell does not support reset_after parameter set to true.");this.units=e.units,Um(this.units,"units"),this.activation=xx(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=xx(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=ey(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=ey(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=ey(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Tx(e.kernelRegularizer),this.recurrentRegularizer=Tx(e.recurrentRegularizer),this.biasRegularizer=Tx(e.biasRegularizer),this.kernelConstraint=Oy(e.kernelConstraint),this.recurrentConstraint=Oy(e.recurrentConstraint),this.biasConstraint=Oy(e.biasConstraint),this.dropout=pg([1,dg([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=pg([1,dg([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.implementation=e.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){const t=(e=ry(e))[e.length-1];this.kernel=this.addWeight("kernel",[t,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,t){return bi((()=>{if(2!==e.length)throw new Nm(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);const n=null!=t.training&&t.training;let s=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=cw({ones:()=>nc(e),rate:this.dropout,training:n,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=cw({ones:()=>nc(s),rate:this.recurrentDropout,training:n,count:3,dropoutFunc:this.dropoutFunc}));const r=this.dropoutMask,a=this.recurrentDropoutMask;let i,o,l;0<this.dropout&&this.dropout<1&&(e=ko(e,r[0]));let u=Tg(e,this.kernel.read());this.useBias&&(u=Ag(u,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(s=ko(s,a[0]));const c=this.recurrentKernel.read(),[h,p]=nh(c,[2*this.units,this.units],c.rank-1),d=Tg(s,h),[f,m,g]=nh(u,3,u.rank-1),[y,b]=nh(d,2,d.rank-1);i=this.recurrentActivation.apply(xo(f,y)),o=this.recurrentActivation.apply(xo(m,b));const x=Tg(ko(o,s),p);l=this.activation.apply(xo(g,x));const w=xo(ko(i,s),ko(xo(1,Si(i)),l));return[w,w]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:yx(this.activation),recurrentActivation:yx(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Qg(this.kernelInitializer),recurrentInitializer:Qg(this.recurrentInitializer),biasInitializer:Qg(this.biasInitializer),kernelRegularizer:Ix(this.kernelRegularizer),recurrentRegularizer:Ix(this.recurrentRegularizer),biasRegularizer:Ix(this.biasRegularizer),activityRegularizer:Ix(this.activityRegularizer),kernelConstraint:Fy(this.kernelConstraint),recurrentConstraint:Fy(this.recurrentConstraint),biasConstraint:Fy(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},e,t)}}aw.className="GRUCell",co(aw);class iw extends tw{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new aw(e),super(e)}call(e,t){return bi((()=>{null!=this.cell.dropoutMask&&(xi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(xi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}iw.className="GRU",co(iw);class ow extends nw{constructor(e){super(e),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=e.units,Um(this.units,"units"),this.activation=xx(void 0===e.activation?this.DEFAULT_ACTIVATION:e.activation),this.recurrentActivation=xx(void 0===e.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:e.recurrentActivation),this.useBias=null==e.useBias||e.useBias,this.kernelInitializer=ey(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=ey(e.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=ey(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=e.unitForgetBias,this.kernelRegularizer=Tx(e.kernelRegularizer),this.recurrentRegularizer=Tx(e.recurrentRegularizer),this.biasRegularizer=Tx(e.biasRegularizer),this.kernelConstraint=Oy(e.kernelConstraint),this.recurrentConstraint=Oy(e.recurrentConstraint),this.biasConstraint=Oy(e.biasConstraint),this.dropout=pg([1,dg([0,null==e.dropout?0:e.dropout])]),this.recurrentDropout=pg([1,dg([0,null==e.recurrentDropout?0:e.recurrentDropout])]),this.dropoutFunc=e.dropoutFunc,this.implementation=e.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(e){var t;const n=(e=ry(e))[e.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const e=this.biasInitializer,n=this.units;s=new((t=class extends Og{apply(t,s){const r=e.apply([n]),a=(new Lg).apply([n]),i=e.apply([2*n]);return Ng(Ng(r,a),i)}}).className="CustomInit",t)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,t){return bi((()=>{const n=null!=t.training&&t.training;if(3!==e.length)throw new Nm(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);let s=e[1];const r=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=cw({ones:()=>nc(e),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=cw({ones:()=>nc(s),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,i=this.recurrentDropoutMask;let o,l,u,c;0<this.dropout&&this.dropout<1&&(e=ko(e,a[0]));let h=Tg(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(s=ko(s,i[0])),h=xo(h,Tg(s,this.recurrentKernel.read())),this.useBias&&(h=Ag(h,this.bias.read()));const[p,d,f,m]=nh(h,4,h.rank-1);o=this.recurrentActivation.apply(p),l=this.recurrentActivation.apply(d),u=xo(ko(l,r),ko(o,this.activation.apply(f))),c=this.recurrentActivation.apply(m);const g=ko(c,this.activation.apply(u));return[g,g,u]}))}getConfig(){const e=super.getConfig(),t={units:this.units,activation:yx(this.activation),recurrentActivation:yx(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Qg(this.kernelInitializer),recurrentInitializer:Qg(this.recurrentInitializer),biasInitializer:Qg(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Ix(this.kernelRegularizer),recurrentRegularizer:Ix(this.recurrentRegularizer),biasRegularizer:Ix(this.biasRegularizer),activityRegularizer:Ix(this.activityRegularizer),kernelConstraint:Fy(this.kernelConstraint),recurrentConstraint:Fy(this.recurrentConstraint),biasConstraint:Fy(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},e,t)}}ow.className="LSTMCell",co(ow);class lw extends tw{constructor(e){0===e.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),e.cell=new ow(e),super(e)}call(e,t){return bi((()=>{null!=this.cell.dropoutMask&&(xi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(xi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}static fromConfig(e,t){return 0===t.implmentation&&(t.implementation=1),new e(t)}}lw.className="LSTM",co(lw);class uw extends nw{constructor(e){super(e),this.cells=e.cells}get stateSize(){const e=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?e.push(...t.stateSize):e.push(t.stateSize);return e}call(e,t){return bi((()=>{let n=e.slice(1);const s=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?s.push(n.splice(0,e.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let a;for(let i=0;i<this.cells.length;++i){const o=this.cells[i];n=s[i],a=0===i?[e[0]].concat(n):[a[0]].concat(n),a=o.call(a,t),r.push(a.slice(1))}n=[];for(const e of r.slice().reverse())n.push(...e);return[a[0]].concat(n)}))}build(e){let t;ty(e)&&(e=e[0]),this.cells.forEach(((n,s)=>{ig(`RNNCell_${s}`,(()=>{n.build(e),t=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,e=[e[0],t]}))})),this.built=!0}getConfig(){const e=super.getConfig(),t={cells:this.cells.map((e=>({className:e.getClassName(),config:e.getConfig()})))};return Object.assign({},e,t)}static fromConfig(e,t,n={}){const s=[];for(const e of t.cells)s.push(Xy(e,n));return new e({cells:s})}get trainableWeights(){if(!this.trainable)return[];const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e}get nonTrainableWeights(){const e=[];for(const t of this.cells)e.push(...t.nonTrainableWeights);if(!this.trainable){const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t.concat(e)}return e}getWeights(){const e=[];for(const t of this.cells)e.push(...t.weights);return ly(e)}setWeights(e){const t=[];for(const n of this.cells){const s=n.weights.length,r=e.splice(s);for(let e=0;e<n.weights.length;++e)t.push([n.weights[e],r[e]])}uy(t)}}function cw(e){const{ones:t,rate:n,training:s=!1,count:r=1,dropoutFunc:a}=e,i=()=>null!=a?a(t(),n):Rg(t(),n),o=()=>_g(i,t,s);if(!r||r<=1)return wi(o().clone());return Array(r).fill(void 0).map(o).map((e=>wi(e.clone())))}uw.className="StackedRNNCells",co(uw);var hw=function(e,t){var n={};for(var s in e)Object.prototype.hasOwnProperty.call(e,s)&&t.indexOf(s)<0&&(n[s]=e[s]);if(null!=e&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(e);r<s.length;r++)t.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(e,s[r])&&(n[s[r]]=e[s[r]])}return n};class pw extends tw{constructor(e){if(e.unroll)throw new Im("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(e.cell))throw new Im("It is not possible at the moment to stack convolutional cells.");super(e),this.inputSpec=[new cy({ndim:5})]}call(e,t){return bi((()=>{if(null!=this.cell.dropoutMask&&(xi(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(xi(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),t&&t.constants)throw new Nm("ConvRNN2D cell does not support constants");const n=null==t?null:t.mask,s=null==t?null:t.training,r=null==t?null:t.initialState;return super.call(e,{mask:n,training:s,initialState:r})}))}computeOutputShape(e){let t=this.computeSingleOutputShape(e);return this.returnSequences||(t=[t[0],...t.slice(2)]),this.returnState&&(t=[t,...Array(2).fill([e[0],...t.slice(-3)])]),t}getInitialState(e){return bi((()=>{const{stateSize:t}=this.cell,n=e.shape,s=this.computeSingleOutputShape(n),r=ju([s[0],...s.slice(2)]);return Array.isArray(t)?Array(t.length).fill(r):[r]}))}resetStates(e,t=!1){bi((()=>{if(!this.stateful)throw new vm("Cannot call resetStates() on an RNN Layer that is not stateful.");const n=this.inputSpec[0].shape,s=this.computeSingleOutputShape(n),r=[s[0],...s.slice(2)];if(null==n[0])throw new Nm("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>ju(r))):this.states_=[ju(r)];else if(null==e)xi(this.states_),null!=this.keptStates&&(xi(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>ju(r))):this.states_[0]=ju(r);else{if(Array.isArray(e)||(e=[e]),e.length!==this.states_.length)throw new Nm(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${e.length} state value(s). Input received: ${e}`);t?this.keptStates.push(this.states_.slice()):xi(this.states_);for(let t=0;t<this.states_.length;++t){const n=e[t],s=r;if(!f(n.shape,s))throw new Nm(`State ${t} is incompatible with layer ${this.name}: expected shape=${s}, received shape=${n.shape}`);this.states_[t]=n}}this.states_=this.states_.map((e=>wi(e.clone())))}))}computeSingleOutputShape(e){const{dataFormat:t,filters:n,kernelSize:s,padding:r,strides:a,dilationRate:i}=this.cell,o="channelsFirst"===t,l=e[o?3:2],u=e[o?4:3],c=Dx(l,s[0],r,a[0],i[0]),h=Dx(u,s[1],r,a[1],i[1]);return[...e.slice(0,2),...o?[n,c,h]:[c,h,n]]}}pw.className="ConvRNN2D";class dw extends ow{constructor(e){const{filters:t,kernelSize:n,strides:s,padding:r,dataFormat:a,dilationRate:i}=e;super(Object.assign({},e,{units:t})),this.filters=t,Um(this.filters,"filters"),this.kernelSize=Fx(n,2,"kernelSize"),this.kernelSize.forEach((e=>Um(e,"kernelSize"))),this.strides=Fx(s||1,2,"strides"),this.strides.forEach((e=>Um(e,"strides"))),this.padding=r||"valid",sg(this.padding),this.dataFormat=a||"channelsLast",ng(this.dataFormat),this.dilationRate=Fx(i||1,2,"dilationRate"),this.dilationRate.forEach((e=>Um(e,"dilationRate")))}build(e){var t;e=ry(e);const n="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[n])throw new Nm(`The channel dimension of the input should be defined. Found ${e[n]}`);const s=e[n],r=this.kernelSize.concat([s,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const n=this.biasInitializer,s=this.filters;e=new((t=class extends Og{apply(e,t){return kg([n.apply([s]),qu([s]),n.apply([2*s])])}}).className="CustomInit",t)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,t){return bi((()=>{if(3!==e.length)throw new Nm(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);const n=t.training||!1,s=e[0],r=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=cw({ones:()=>nc(s),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,o=(e,t,n)=>t&&t[n]?ko(t[n],e):e;let l=o(s,i,0),u=o(s,i,1),c=o(s,i,2),h=o(s,i,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=cw({ones:()=>nc(r),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const p=this.recurrentDropoutMask;let d=o(r,p,0),f=o(r,p,1),m=o(r,p,2),g=o(r,p,3);const[y,b,x,w]=nh(this.kernel.read(),4,3),[v,k,N,I]=this.useBias?nh(this.bias.read(),4):[null,null,null,null];l=this.inputConv(l,y,v,this.padding),u=this.inputConv(u,b,k,this.padding),c=this.inputConv(c,x,N,this.padding),h=this.inputConv(h,w,I,this.padding);const[S,T,$,C]=nh(this.recurrentKernel.read(),4,3);d=this.recurrentConv(d,S),f=this.recurrentConv(f,T),m=this.recurrentConv(m,$),g=this.recurrentConv(g,C);const E=this.recurrentActivation.apply(xo(l,d)),A=this.recurrentActivation.apply(xo(u,f)),R=xo(ko(A,a),ko(E,this.activation.apply(xo(c,m)))),_=ko(this.recurrentActivation.apply(xo(h,g)),this.activation.apply(R));return[_,_,R]}))}getConfig(){const e=super.getConfig(),{units:t}=e,n=hw(e,["units"]),s={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},n,s)}inputConv(e,t,n,s){const r=bl(e,t,this.strides,s||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?Ag(r,n,this.dataFormat):r}recurrentConv(e,t){return bl(e,t,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}dw.className="ConvLSTM2DCell",co(dw);class fw extends pw{constructor(e){const t=new dw(e);super(Object.assign({},e,{cell:t}))}static fromConfig(e,t){return new e(t)}}fw.className="ConvLSTM2D",co(fw);class mw extends my{constructor(e){super(e),this.rate=Math.max(Math.min(e.rate,1),0),this.noiseShape=e.noiseShape,this.seed=e.seed,this.supportsMasking=!0}getNoiseShape(e){if(null==this.noiseShape)return this.noiseShape;const t=e.shape,n=[];for(let e=0;e<this.noiseShape.length;++e)n.push(null==this.noiseShape[e]?t[e]:this.noiseShape[e]);return n}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e);if(0<this.rate&&this.rate<1){const e=null!=t.training&&t.training,s=this.getNoiseShape(n);return _g((()=>Rg(n,this.rate,s,this.seed)),(()=>n),e)}return e}))}getConfig(){const e={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},t=super.getConfig();return Object.assign(e,t),e}dispose(){return super.dispose()}}mw.className="Dropout",co(mw);class gw extends mw{constructor(e){super(e),this.inputSpec=[{ndim:3}]}getNoiseShape(e){const t=e.shape;return[t[0],1,t[2]]}}gw.className="SpatialDropout1D",co(gw);class yw extends my{constructor(e){if(super(e),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==e.batchInputShape&&null==e.inputShape&&null!=e.inputDim){let t=null;null!=e.batchSize&&(t=e.batchSize),this.batchInputShape=[t,e.inputDim]}this.units=e.units,Um(this.units,"units"),this.activation=xx(e.activation),null!=e.useBias&&(this.useBias=e.useBias),this.kernelInitializer=ey(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=ey(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Oy(e.kernelConstraint),this.biasConstraint=Oy(e.biasConstraint),this.kernelRegularizer=Tx(e.kernelRegularizer),this.biasRegularizer=Tx(e.biasRegularizer),this.activityRegularizer=Tx(e.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(e){const t=(e=ry(e))[e.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[t,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:t}}],this.built=!0}computeOutputShape(e){const t=(e=ry(e)).slice();return t[t.length-1]=this.units,t}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e),s=Hm(this.activation.getClassName());let r;return null!=s?r=Tg(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Tg(n,this.kernel.read()),null!=this.bias&&(r=Ag(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const e={units:this.units,activation:yx(this.activation),useBias:this.useBias,kernelInitializer:Qg(this.kernelInitializer),biasInitializer:Qg(this.biasInitializer),kernelRegularizer:Ix(this.kernelRegularizer),biasRegularizer:Ix(this.biasRegularizer),activityRegularizer:Ix(this.activityRegularizer),kernelConstraint:Fy(this.kernelConstraint),biasConstraint:Fy(this.biasConstraint)},t=super.getConfig();return Object.assign(e,t),e}}yw.className="Dense",co(yw);class bw extends my{constructor(e){super(e=e||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=e.dataFormat}computeOutputShape(e){e=ry(e);for(const t of e.slice(1))if(null==t)throw new Nm(`The shape of the input to "Flatten" is not fully defined (got ${e.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[e[0],hg(e,1)]}call(e,t){return bi((()=>{this.invokeCallHook(e,t);let n=sy(e);if("channelsFirst"===this.dataFormat&&n.rank>1){const e=[0];for(let t=2;t<n.rank;++t)e.push(t);e.push(1),n=$i(n,e)}return function(e){if(e.rank<=1)throw new Nm(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const t=[e.shape[0],hg(e.shape,1)];return Yo(e,t)}(n)}))}getConfig(){const e={};null!=this.dataFormat&&(e.dataFormat=this.dataFormat);const t=super.getConfig();return Object.assign(e,t),e}}bw.className="Flatten",co(bw);class xw extends my{constructor(e){super(e),this.supportsMasking=!0,this.activation=xx(e.activation)}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e);return this.activation.apply(n)}))}getConfig(){const e={activation:yx(this.activation)},t=super.getConfig();return Object.assign(e,t),e}}xw.className="Activation",co(xw);class ww extends my{constructor(e){super(e),this.n=e.n,this.inputSpec=[{ndim:2}]}computeOutputShape(e){return[e[0],this.n,e[1]]}call(e,t){return bi((()=>{return e=sy(e),t=e,n=this.n,bi((()=>{if(2!==t.shape.length)throw new Nm(`repeat() expects a rank-2 tensor, but received a rank-${t.shape.length} tensor.`);return Ig(bg(t,1),[1,n,1])}));var t,n}))}getConfig(){const e={n:this.n},t=super.getConfig();return Object.assign(e,t),e}}ww.className="RepeatVector",co(ww);class vw extends my{constructor(e){super(e),this.targetShape=e.targetShape;for(let e=0;e<this.targetShape.length;++e)this.isUnknown(this.targetShape[e])&&(this.targetShape[e]=null)}isUnknown(e){return e<0||null==e}fixUnknownDimension(e,t){const n="Total size of new array must be unchanged.",s=t.slice();let r=1,a=null;for(let e=0;e<s.length;++e){const t=s[e];if(this.isUnknown(t)){if(null!==a)throw new Nm("Can only specifiy one unknown dimension.");a=e}else r*=t}const i=hg(e);if(null!==a){if(0===r||i%r!=0)throw new Nm(n);s[a]=i/r}else if(i!==r)throw new Nm(n);return s}computeOutputShape(e){let t=!1;for(let n=0;n<e.length;++n)if(this.isUnknown(e[n])){t=!0;break}return t?e.slice(0,1).concat(this.targetShape):e.slice(0,1).concat(this.fixUnknownDimension(e.slice(1),this.targetShape))}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return Yo(n,r)}))}getConfig(){const e={targetShape:this.targetShape},t=super.getConfig();return Object.assign(e,t),e}}vw.className="Reshape",co(vw);class kw extends my{constructor(e){if(super(e),null==e.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(e.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${e.dims} instead.`);const t=fg(1,e.dims.length+1);if(!f(e.dims.slice().sort(),t))throw new Error("Invalid permutation `dims`: "+JSON.stringify(e.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=e.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new cy({ndim:this.dims.length+1})]}computeOutputShape(e){const t=(e=ry(e)).slice();return this.dims.forEach(((n,s)=>{t[s+1]=e[n]})),t}call(e,t){return $i(sy(e),this.dimsIncludingBatch)}getConfig(){const e={dims:this.dims},t=super.getConfig();return Object.assign(e,t),e}}kw.className="Permute",co(kw);class Nw extends my{constructor(e){super(null==e?{}:e),this.supportsMasking=!0,this.maskValue=null!=e?null==e.maskValue?0:e.maskValue:0}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={maskValue:this.maskValue};return Object.assign(t,e),t}computeMask(e,t){const n=sy(e);return Co(tc(n,this.maskValue),-1)}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e),s=Co(tc(n,this.maskValue),-1,!0);return ko(n,qa(s,n.dtype))}))}}Nw.className="Masking",co(Nw);class Iw extends my{constructor(e){if(super(e),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==e.batchInputShape&&null==e.inputShape){let t=null;null!=e.batchSize&&(t=e.batchSize),null==e.inputLength?this.batchInputShape=[t,null]:this.batchInputShape=[t].concat(Rm(e.inputLength))}this.inputDim=e.inputDim,Um(this.inputDim,"inputDim"),this.outputDim=e.outputDim,Um(this.outputDim,"outputDim"),this.embeddingsInitializer=ey(e.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Tx(e.embeddingsRegularizer),this.activityRegularizer=Tx(e.activityRegularizer),this.embeddingsConstraint=Oy(e.embeddingsConstraint),this.maskZero=e.maskZero,this.supportsMasking=e.maskZero,this.inputLength=e.inputLength}build(e){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(e){}computeMask(e,t){return bi((()=>this.maskZero?(e=sy(e),tc(e,Ml(e))):null))}computeOutputShape(e){if(e=ry(e),null==this.inputLength)return[...e,this.outputDim];const t=Rm(this.inputLength);if(t.length!==e.length-1)throw new Nm(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);{let n=0;for(let s=0;s<t.length;++s){const r=t[s],a=e[s+1];if(null!=r&&null!=a&&r!==a)throw new Nm(`"inputLength" is ${this.inputLength}, but received input shape has shape ${e}`);null==r&&(t[n]=a),n++}}return[e[0],...t,this.outputDim]}call(e,t){return bi((()=>{this.invokeCallHook(e,t);let n=sy(e);"int32"!==n.dtype&&(n=yg(n,"int32"));const s=$g(this.embeddings.read(),Yo(n,[n.size]));return Yo(s,ry(this.computeOutputShape(n.shape)))}))}getConfig(){const e={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Qg(this.embeddingsInitializer),embeddingsRegularizer:Ix(this.embeddingsRegularizer),activityRegularizer:Ix(this.activityRegularizer),embeddingsConstraint:Fy(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},t=super.getConfig();return Object.assign(e,t),e}}Iw.className="Embedding",co(Iw);class Sw extends my{constructor(e){super(e||{}),this.supportsMasking=!0}mergeFunction(e){throw new Im}computeElementwiseOpOutputShape(e,t){if(null==e||null==t)return null;if(e.length<t.length)return this.computeElementwiseOpOutputShape(t,e);if(0===t.length)return e;const n=e.slice(0,e.length-t.length);for(let s=0;s<t.length;++s){const r=e[e.length-t.length+s],a=t[s];if(null==r||null==a||r<0||a<0)n.push(null);else if(1===r)n.push(a);else if(1===a)n.push(r);else{if(r!==a)throw new Nm("Operands could not be broadcast together with shapes "+JSON.stringify(e)+" "+JSON.stringify(t));n.push(r)}}return n}build(e){if(Array.isArray(e)&&!Array.isArray(e[0])&&(e=[ry(e)]),e.length<2)throw new Nm(`A merge layer should be called on an Array of at least 2 inputs. Got ${e.length} input(s).`);let t=[];for(const n of e)null!=n&&null!==n[0]&&t.push(n[0]);if(t=Pm(t),t.length>1)throw new Nm(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(e)}.`);let n=null==e[0]?null:e[0].slice(1);for(let t=1;t<e.length;++t){const s=null==e[t]?null:e[t].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=e.map((e=>e.length));-1===e.indexOf(null)&&1===Pm(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,t){return bi((()=>{if(this.reshapeRequired){const t=[],n=e.map((e=>e.rank));if(-1===n.indexOf(null)){const s=dg(n);for(let n of e){const e=n.rank;for(let t=0;t<s-e;++t)n=bg(n,1);t.push(n)}return this.mergeFunction(t)}{let n=!1;for(const s of e){const e=s.rank;if(null==e){const e=s.shape,r=e[0],a=e.slice(1).concat([r]);let i=Yo(s,[r].concat(hg(e.slice(1))));i=$i(i,[1,0]),i=Yo(i,a),t.push(i),n=!0}else if(e>1){const r=fg(1,e).concat([0]);t.push($i(s,r)),n=!0}else t.push(s)}let s=this.mergeFunction(t);const r=s.rank;if(n)if(null==r){const e=s.shape,t=e[e.length-1],n=[t].concat(e.slice(0,e.length-1));s=Yo($i(Yo(s,[-1,t]),[1,0]),n)}else if(r>1){const e=[r-1].concat(fg(0,r-1));s=$i(s,e)}return s}}return this.mergeFunction(e)}))}computeOutputShape(e){let t;t=null==e[0]?null:e[0].slice(1);for(let n=1;n<e.length;++n){const s=null==e[n]?null:e[n].slice(1);t=this.computeElementwiseOpOutputShape(t,s)}let n=[];for(const t of e)null!=t&&null!==t[0]&&n.push(t[0]);return n=Pm(n),t=1===n.length?n.concat(t):[null].concat(t),t}computeMask(e,t){return bi((()=>{if(null==t)return null;if(!Array.isArray(t))throw new Nm("`mask` should be an Array");if(!Array.isArray(e))throw new Nm("`inputs` should be an Array");if(t.length!==e.length)throw new Nm(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${t.length})`);if(t.every((e=>null==e)))return null;let n=(t=t.map((e=>null==e?e:ou(e,0))))[0];for(let e=1;e<t.length-1;++e)n=Du(n,t[e]);return n}))}}class Tw extends Sw{constructor(e){super(e)}mergeFunction(e){return bi((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=xo(t,e[n]);return t}))}}Tw.className="Add",co(Tw);class $w extends Sw{constructor(e){super(e)}mergeFunction(e){return bi((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=ko(t,e[n]);return t}))}}$w.className="Multiply",co($w);class Cw extends Sw{constructor(e){super(e)}mergeFunction(e){return bi((()=>{let t=e[0].clone();for(let n=1;n<e.length;++n)t=xo(t,e[n]);return ko(1/e.length,t)}))}}Cw.className="Average",co(Cw);class Ew extends Sw{constructor(e){super(e)}mergeFunction(e){return bi((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Gu(t,e[n]);return t}))}}Ew.className="Maximum",co(Ew);class Aw extends Sw{constructor(e){super(e)}mergeFunction(e){return bi((()=>{let t=e[0];for(let n=1;n<e.length;++n)t=Xu(t,e[n]);return t}))}}Aw.className="Minimum",co(Aw);class Rw extends Sw{constructor(e){super(e),this.DEFAULT_AXIS=-1,null==e&&(e={}),this.axis=null==e.axis?this.DEFAULT_AXIS:e.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){if(!Array.isArray(e)||!Array.isArray(e[0])||1===e.length)throw new Nm("A `Concatenate` layer should be called on a list of at least 2 inputs");let t=!0;for(const n of e)if(null!=n){t=!1;break}if(t)return;const n=[];for(let t=0;t<e.length;++t){const s=e[t].slice();s.splice(this.axis,1);let r=!1;for(const e of n)if(f(e,s)){r=!0;break}r||n.push(s)}if(n.length>1)throw new Nm("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(e))}mergeFunction(e){return bi((()=>kg(e,this.axis)))}computeOutputShape(e){if(!Array.isArray(e)||!Array.isArray(e[0]))throw new Nm("A `Concatenate` layer should be called on a list of inputs.");const t=e,n=t[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const e of t.slice(1)){if(null==n[s]||null==e[s]){n[s]=null;break}n[s]+=e[s]}return n}computeMask(e,t){if(null==t)return null;if(!Array.isArray(t))throw new Nm("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new Nm("`inputs` should be an array for Concatenate");if(t.length!==e.length)throw new Nm(`Mismatch in the length of mask (${t.length}) and the legnth of inputs (${e.length})`);return bi((()=>{let n=!0;if(t.forEach((e=>{null==e||(n=!1)})),n)return null;const s=[];for(let n=0;n<e.length;++n)null==t[n]?s.push(qa(nc(e[n]),"bool")):t[n].rank<e[n].rank?s.push(ou(t[n],-1)):s.push(t[n]);const r=Qo(s,this.axis);return $o(r,-1,!1)}))}getConfig(){const e={axis:this.axis},t=super.getConfig();return Object.assign(e,t),e}}function _w(e,t){for(;e<0;)e+=t;return e}Rw.className="Concatenate",co(Rw);class Fw extends Sw{constructor(e){super(e),this.axes=e.axes,this.normalize=null!=e.normalize&&e.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){u(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0],n=e[1];if(t.length>3||n.length>3)throw new Im("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);if(t[s[0]]!==n[s[1]])throw new Nm(`Dimension incompatibility: ${t[s[0]]} !== ${n[s[1]]}`)}mergeFunction(e){if(2!==e.length)throw new Nm(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let t,n=e[0],s=e[1];return t=Array.isArray(this.axes)?this.axes.map(((t,n)=>_w(t,e[n].shape.length))):[_w(this.axes,n.shape.length),_w(this.axes,s.shape.length)],this.normalize&&(n=Yy(n,t[0]),s=Yy(s,t[1])),function(e,t,n){if(e.shape.length>3||t.shape.length>3)throw new Im("batchDot is not implemented for tensors of 4D or higher rank yet");if(u(e.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`)),u(e.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${t.shape.length}`)),"number"==typeof n&&(n=[n,n]),"complex64"===e.dtype||"complex64"===t.dtype)throw new Im("batchDot is not implemented for complex64-type Tensors yet.");const s=e.shape.length,r=t.shape.length;null==n&&(n=[s-1,r-2]);const a=n;return bi((()=>{let n,i;if(s>r){n=s-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=Yo(t,t.shape.concat(e))}else if(r>s){n=r-s;const t=[];for(let e=0;e<n;++e)t.push(1);e=Yo(e,e.shape.concat(t))}else n=0;if(2===e.shape.length&&2===t.shape.length)i=a[0]===a[1]?nu(ko(e,t),a[0]):nu(ko($i(e,[1,0]),t),a[1]);else{const n=a[0]!==e.shape.length-1,s=a[1]===t.shape.length-1;i=di(e,t,n,s)}if(n>0){let e;e=s>r?s+r-3:s-1;const t=[];for(let s=e;s<e+n;++s)t.push(s);i=ah(i,t)}return 1===i.shape.length&&(i=ou(i,1)),i}))}(n,s,t)}interpretAxes(e,t){let n;return n=Array.isArray(this.axes)?this.axes:[_w(this.axes,e.length),_w(this.axes,t.length)],n}computeOutputShape(e){u(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const t=e[0].slice(),n=e[1].slice();if(t.length>3||n.length>3)throw new Im("Dot layer does not support tensors of 4D or higher rank yet.");const s=this.interpretAxes(t,n);t.splice(s[0],1),n.splice(s[1],1),n.splice(0,1);const r=t.concat(n);return 1===r.length&&r.push(1),r}computeMask(e,t){return null}getConfig(){const e={axes:this.axes,normalize:this.normalize},t=super.getConfig();return Object.assign(e,t),e}}Fw.className="Dot",co(Fw);class Dw extends my{constructor(e){super(e),this.supportsMasking=!0,this.stddev=e.stddev}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={stddev:this.stddev};return Object.assign(t,e),t}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e);return _g((()=>xo(Sg(n.shape,0,this.stddev),n)),(()=>n),t.training||!1)}))}}Dw.className="GaussianNoise",co(Dw);class Ow extends my{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return bi((()=>{this.invokeCallHook(e,t);const n=sy(e);if(this.rate>0&&this.rate<1){return _g((()=>{const e=Math.sqrt(this.rate/(1-this.rate));return ko(n,Sg(n.shape,1,e))}),(()=>n),t.training||!1)}return n}))}}Ow.className="GaussianDropout",co(Ow);class Mw extends my{constructor(e){super(e),this.supportsMasking=!0,this.rate=e.rate,this.noiseShape=e.noiseShape}_getNoiseShape(e){return this.noiseShape||sy(e).shape}computeOutputShape(e){return e}getConfig(){const e=super.getConfig(),t={rate:this.rate};return Object.assign(t,e),t}call(e,t){return bi((()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(e),s=()=>{const t=sy(e),s=-1.7580993408473766;let r=mu(Ac(n),this.rate);r=yg(r,"float32");const a=((1-this.rate)*(1+this.rate*s**2))**-.5,i=-a*s*this.rate,o=xo(ko(t,r),ko(xo(r,-1),s));return xo(ko(o,a),i)};return _g(s,(()=>sy(e)),t.training||!1)}return e}))}}function Lw(e,t,n,s,r,a=.001){let i;if(2===e.rank)i=il(e,t,n,s,r,a);else if(3===e.rank)i=ol(e,t,n,s,r,a);else{if(4!==e.rank)throw new Im(`batchNormalization is not implemented for array of rank ${e.rank} yet`);i=ll(e,t,n,s,r,a)}return i}function zw(e,t,n,s,r=.001){return f(s.slice().sort(),fg(0,e.rank-1))?function(e,t,n,s,r=.001){return bi((()=>{const a=Ju(e,s),i=a.mean,o=a.variance;return[Lw(e,i,o,n,t,r),i,o]}))}(e,t,n,s,r):function(e,t,n,s,r=.001){return bi((()=>{const a=Ju(e,s),i=a.mean,o=a.variance,l=[];for(const t of fg(0,e.rank))-1!==s.indexOf(t)?l.push(1):l.push(e.shape[t]);const u=Yo(i,l),c=Yo(o,l),h=null==t?null:Yo(t,l),p=null==n?null:Yo(n,l);return[Lw(e,u,c,p,h,r),i,o]}))}(e,t,n,s,r)}Mw.className="AlphaDropout",co(Mw);class Pw extends my{constructor(e){null==e&&(e={}),super(e),this.supportsMasking=!0,this.axis=null==e.axis?-1:e.axis,this.momentum=null==e.momentum?.99:e.momentum,this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=ey(e.betaInitializer||"zeros"),this.gammaInitializer=ey(e.gammaInitializer||"ones"),this.movingMeanInitializer=ey(e.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=ey(e.movingVarianceInitializer||"ones"),this.betaConstraint=Oy(e.betaConstraint),this.gammaConstraint=Oy(e.gammaConstraint),this.betaRegularizer=Tx(e.betaRegularizer),this.gammaRegularizer=Tx(e.gammaRegularizer)}build(e){e=ry(e);const t=this.axis>=0?this.axis:this.axis+e.length,n=e[t];if(null==n)throw new Nm(`Axis ${t} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(e)}.`);this.inputSpec=[new cy({ndim:e.length,axes:{[t]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(e,t){return bi((()=>{const n=null!=t.training&&t.training,s=sy(e),r=s.shape,a=r.length,i=fg(0,a),o=this.axis>=0?this.axis:this.axis+a;i.splice(o,1);const l=$m(1,a);l[o]=r[o];const u=i.slice();u.sort();const c=!f(u,fg(0,a).slice(0,a-1));if(!n)return(()=>{if(c){const e=Yo(this.movingMean.read(),l),t=Yo(this.movingVariance.read(),l),n=this.center?Yo(this.beta.read(),l):null,r=this.scale?Yo(this.gamma.read(),l):null;return Lw(s,e,t,n,r,this.epsilon)}return Lw(s,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[h,p,d]=zw(s,this.gamma.read(),this.beta.read(),i,this.epsilon),m=(e,t,n)=>{bi((()=>{const s=1-n,r=e.read(),a=ko(Ru(r,t),s);e.write(Ru(r,a))}))};return(()=>{m(this.movingMean,p,this.momentum),m(this.movingVariance,d,this.momentum)})(),h}))}getConfig(){const e={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Qg(this.betaInitializer),gammaInitializer:Qg(this.gammaInitializer),movingMeanInitializer:Qg(this.movingMeanInitializer),movingVarianceInitializer:Qg(this.movingVarianceInitializer),betaRegularizer:Ix(this.betaRegularizer),gammaRegularizer:Ix(this.gammaRegularizer),betaConstraint:Fy(this.betaConstraint),gammaConstraint:Fy(this.gammaConstraint)},t=super.getConfig();return Object.assign(e,t),e}}Pw.className="BatchNormalization",co(Pw);class Bw extends my{constructor(e){if(null==e&&(e={}),super(e),this.axis=null==e.axis?-1:e.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const e of this.axis)if(!Number.isInteger(e))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==e.epsilon?.001:e.epsilon,this.center=null==e.center||e.center,this.scale=null==e.scale||e.scale,this.betaInitializer=ey(e.betaInitializer||"zeros"),this.gammaInitializer=ey(e.gammaInitializer||"ones"),this.betaRegularizer=Tx(e.betaRegularizer),this.gammaRegularizer=Tx(e.gammaRegularizer),this.supportsMasking=!0}build(e){const t=(e=ry(e)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let e=0;e<this.axis.length;++e)this.axis[e]<0&&(this.axis[e]+=t);for(const e of this.axis)if(e<0||e>=t)throw new Error(`Invalid axis: ${e}`);if(this.axis.length!==Pm(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((t=>e[t]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(e,t){const n=sy(e),s=n.shape,r=s.length;return bi((()=>{let{mean:e,variance:t}=Ju(n,this.axis,!0);const a=$m(1,r);for(const e of this.axis)a[e]=s[e];const i=e=>null!=e&&e.shape.length!==r?Yo(e,a):e;let o=this.scale?i(this.gamma.read()):null,l=this.center?i(this.beta.read()):null;const u=[],c=[];for(let e=0;e<r;++e)-1!==this.axis.indexOf(e)?(u.push(s[e]),c.push(1)):(u.push(1),c.push(s[e]));return e=uu(e,u),t=uu(t,u),null!=o&&(o=uu(o,c)),null!=l&&(l=uu(l,c)),Lw(n,e,t,l,o,this.epsilon)}))}getConfig(){const e={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Qg(this.betaInitializer),gammaInitializer:Qg(this.gammaInitializer),betaRegularizer:Ix(this.betaRegularizer),gammaRegularizer:Ix(this.gammaRegularizer)},t=super.getConfig();return Object.assign(e,t),e}}Bw.className="LayerNormalization",co(Bw);class Ww extends my{constructor(e){if(null==e&&(e={}),super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,null==e.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof e.padding)this.padding=[[e.padding,e.padding],[e.padding,e.padding]];else{if(e.padding=e.padding,2!==e.padding.length)throw new Nm(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${e.padding.length} array.`);let t,n;if("number"==typeof e.padding[0])t=[e.padding[0],e.padding[0]],n=[e.padding[1],e.padding[1]];else{if(e.padding=e.padding,2!==e.padding[0].length)throw new Nm(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${e.padding[0].length} array.`);if(t=e.padding[0],2!==e.padding[1].length)throw new Nm(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${e.padding[1].length} array.`);n=e.padding[1]}this.padding=[t,n]}this.inputSpec=[new cy({ndim:4})]}computeOutputShape(e){let t,n;return e=ry(e),"channelsFirst"===this.dataFormat?(t=null!=e[2]&&e[2]>=0?e[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[3]&&e[3]>=0?e[3]+this.padding[1][0]+this.padding[1][1]:null,[e[0],e[1],t,n]):(t=null!=e[1]&&e[1]>=0?e[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=e[2]&&e[2]>=0?e[2]+this.padding[1][0]+this.padding[1][1]:null,[e[0],t,n,e[3]])}call(e,t){return bi((()=>{return t=sy(e),n=this.padding,s=this.dataFormat,bi((()=>{if(4!==t.rank)throw new Nm(`temporalPadding expects input tensor to be 4-D, but received a ${t.rank}-D tensor.`);if(null==n&&(n=[[1,1],[1,1]]),2!==n.length||2!==n[0].length||2!==n[1].length)throw new Nm("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==s&&(s="channelsLast"),"channelsLast"!==s&&"channelsFirst"!==s)throw new Nm(`Unknown data format: ${s}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===s?[[0,0],[0,0],n[0],n[1]]:[[0,0],n[0],n[1],[0,0]],rc(t,e)}));var t,n,s}))}getConfig(){const e={padding:this.padding,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}function Vw(e,t,n,s,r,a){return bi((()=>{let i;ng(r),rg(a),sg(s),null==n&&(n=[1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Mx(e,r);const o="same"===s?"same":"valid";return i="max"===a?Wu(e,t,n,o):Zo(e,t,n,o),"channelsFirst"===r&&(i=$i(i,[0,3,1,2])),i}))}function Uw(e,t,n,s,r,a){return bi((()=>{let i;ng(r),rg(a),sg(s),null==n&&(n=[1,1,1]),null==s&&(s="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),e=Lx(e,r);const o="same"===s?"same":"valid";return i="max"===a?Vu(e,t,n,o):Jo(e,t,n,o),"channelsFirst"===r&&(i=$i(i,[0,4,1,2,3])),i}))}Ww.className="ZeroPadding2D",co(Ww);class Gw extends my{constructor(e){if(null==e.poolSize&&(e.poolSize=2),super(e),"number"==typeof e.poolSize)this.poolSize=[e.poolSize];else{if(!Array.isArray(e.poolSize)||1!==e.poolSize.length||"number"!=typeof e.poolSize[0])throw new Nm(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.poolSize)}`);this.poolSize=e.poolSize}if(Um(this.poolSize,"poolSize"),null==e.strides)this.strides=this.poolSize;else if("number"==typeof e.strides)this.strides=[e.strides];else{if(!Array.isArray(e.strides)||1!==e.strides.length||"number"!=typeof e.strides[0])throw new Nm(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(e.strides)}`);this.strides=e.strides}Um(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,sg(this.padding),this.inputSpec=[new cy({ndim:3})]}computeOutputShape(e){const t=Dx((e=ry(e))[1],this.poolSize[0],this.padding,this.strides[0]);return[e[0],t,e[2]]}call(e,t){return bi((()=>{this.invokeCallHook(e,t),e=bg(sy(e),2);const n=this.poolingFunction(sy(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return ah(n,[2])}))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides},t=super.getConfig();return Object.assign(e,t),e}}class Hw extends Gw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Vw(e,t,n,s,r,"max")}}Hw.className="MaxPooling1D",co(Hw);class jw extends Gw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Vw(e,t,n,s,r,"avg")}}jw.className="AveragePooling1D",co(jw);class qw extends my{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(2!==e.strides.length)throw new Nm(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides];Um(this.poolSize,"poolSize"),Um(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,ng(this.dataFormat),sg(this.padding),this.inputSpec=[new cy({ndim:4})]}computeOutputShape(e){e=ry(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2];return t=Dx(t,this.poolSize[0],this.padding,this.strides[0]),n=Dx(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n]:[e[0],t,n,e[3]]}call(e,t){return bi((()=>(this.invokeCallHook(e,t),this.poolingFunction(sy(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Kw extends qw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Vw(e,t,n,s,r,"max")}}Kw.className="MaxPooling2D",co(Kw);class Xw extends qw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Vw(e,t,n,s,r,"avg")}}Xw.className="AveragePooling2D",co(Xw);class Yw extends my{constructor(e){if(null==e.poolSize&&(e.poolSize=[2,2,2]),super(e),this.poolSize=Array.isArray(e.poolSize)?e.poolSize:[e.poolSize,e.poolSize,e.poolSize],null==e.strides)this.strides=this.poolSize;else if(Array.isArray(e.strides)){if(3!==e.strides.length)throw new Nm(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${e.strides.length}.`);this.strides=e.strides}else this.strides=[e.strides,e.strides,e.strides];Um(this.poolSize,"poolSize"),Um(this.strides,"strides"),this.padding=null==e.padding?"valid":e.padding,this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,ng(this.dataFormat),sg(this.padding),this.inputSpec=[new cy({ndim:5})]}computeOutputShape(e){e=ry(e);let t="channelsFirst"===this.dataFormat?e[2]:e[1],n="channelsFirst"===this.dataFormat?e[3]:e[2],s="channelsFirst"===this.dataFormat?e[4]:e[3];return t=Dx(t,this.poolSize[0],this.padding,this.strides[0]),n=Dx(n,this.poolSize[1],this.padding,this.strides[1]),s=Dx(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[e[0],e[1],t,n,s]:[e[0],t,n,s,e[4]]}call(e,t){return bi((()=>(this.invokeCallHook(e,t),this.poolingFunction(sy(e),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const e={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class Zw extends Yw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Uw(e,t,n,s,r,"max")}}Zw.className="MaxPooling3D",co(Zw);class Jw extends Yw{constructor(e){super(e)}poolingFunction(e,t,n,s,r){return ng(r),sg(s),Uw(e,t,n,s,r,"avg")}}Jw.className="AveragePooling3D",co(Jw);class Qw extends my{constructor(e){super(e),this.inputSpec=[new cy({ndim:3})]}computeOutputShape(e){return[e[0],e[2]]}call(e,t){throw new Im}}class ev extends Qw{constructor(e){super(e||{})}call(e,t){return bi((()=>{const t=sy(e);return Hu(t,1)}))}}ev.className="GlobalAveragePooling1D",co(ev);class tv extends Qw{constructor(e){super(e||{})}call(e,t){return bi((()=>{const t=sy(e);return Yl(t,1)}))}}tv.className="GlobalMaxPooling1D",co(tv);class nv extends my{constructor(e){super(e),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,ng(this.dataFormat),this.inputSpec=[new cy({ndim:4})]}computeOutputShape(e){return"channelsLast"===this.dataFormat?[e[0],e[3]]:[e[0],e[1]]}call(e,t){throw new Im}getConfig(){const e={dataFormat:this.dataFormat},t=super.getConfig();return Object.assign(e,t),e}}class sv extends nv{call(e,t){return bi((()=>{const t=sy(e);return"channelsLast"===this.dataFormat?Hu(t,[1,2]):Hu(t,[2,3])}))}}sv.className="GlobalAveragePooling2D",co(sv);class rv extends nv{call(e,t){return bi((()=>{const t=sy(e);return"channelsLast"===this.dataFormat?Yl(t,[1,2]):Yl(t,[2,3])}))}}rv.className="GlobalMaxPooling2D",co(rv);class av extends my{constructor(e){super(e),this.layer=e.layer}build(e){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(e){null!=this.layer&&(this.layer.trainable=e)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(e){this.layer.setWeights(e)}getConfig(){const e={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},t=super.getConfig();return Object.assign(e,t),e}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(e)}static fromConfig(e,t,n={}){const s=Xy(t.layer,n);delete t.layer;const r={layer:s};return Object.assign(r,t),new e(r)}}class iv extends av{constructor(e){super(e),this.supportsMasking=!0}build(e){if((e=ry(e)).length<3)throw new Nm(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(e)}`);this.inputSpec=[{shape:e}];const t=[e[0]].concat(e.slice(2));this.layer.built||(this.layer.build(t),this.layer.built=!0),super.build(e)}computeOutputShape(e){const t=[(e=ry(e))[0]].concat(e.slice(2)),n=this.layer.computeOutputShape(t),s=e[1];return[n[0],s].concat(n.slice(1))}call(e,t){return bi((()=>ew(((e,n)=>[sy(this.layer.call(e,t)),[]]),e=sy(e),[],!1,null,null,!1,!0)[1]))}}iv.className="TimeDistributed",co(iv);class ov extends av{constructor(e){super(e);const t=e.layer.getConfig(),n={};n.className=e.layer.getClassName(),n.config=t,this.forwardLayer=Xy(n),t.goBackwards=!0!==t.goBackwards;const s={};var r;if(s.className=e.layer.getClassName(),s.config=t,this.backwardLayer=Xy(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===e.mergeMode?"concat":e.mergeMode,r=this.mergeMode,Wm(eg,"BidirectionalMergeMode",r),e.weights)throw new Im("weights support is not implemented for Bidirectional layer yet.");this._stateful=e.layer.stateful,this.returnSequences=e.layer.returnSequences,this.returnState=e.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=e.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(e){this._trainable=e,null!=this.forwardLayer&&(this.forwardLayer.trainable=e),null!=this.backwardLayer&&(this.backwardLayer.trainable=e)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(e){const t=e.length,n=Math.floor(t/2);this.forwardLayer.setWeights(e.slice(0,n)),this.backwardLayer.setWeights(e.slice(n))}computeOutputShape(e){let t,n,s,r=this.forwardLayer.computeOutputShape(e);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),t=r[0]):t=r[0],"concat"===this.mergeMode?(t[t.length-1]*=2,n=[t]):n=null==this.mergeMode?[t,t.slice()]:[t],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[t].concat(s).concat(s.slice()):Am(n)}apply(e,t){let n=null==t?null:t.initialState,s=null==t?null:t.constants;null==t&&(t={});const r=Qx(e,n,s,this.numConstants);if(e=r.inputs,n=r.initialState,s=r.constants,Array.isArray(e)&&(n=e.slice(1),e=e[0]),(null==n||0===n.length)&&null==s)return super.apply(e,t);const a=[],i=[];if(null!=n){const e=n.length;if(e%2>0)throw new Nm("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");t.initialState=n,a.push(...n);const s=n.map((e=>new cy({shape:e.shape})));this.forwardLayer.stateSpec=s.slice(0,e/2),this.backwardLayer.stateSpec=s.slice(e/2),i.push(...s)}if(null!=s)throw new Im("Support for constants in Bidirectional layers is not implemented yet.");const o=a[0]instanceof hy;for(const e of a)if(e instanceof hy!==o)throw new Nm("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[e].concat(a),s=this.inputSpec.concat(i),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,t);return this.inputSpec=r,o}return super.apply(e,t)}call(e,t){return bi((()=>{const n=t.initialState;let s,r,a,i;if(null==n)s=this.forwardLayer.call(e,t),r=this.backwardLayer.call(e,t);else{const a=n.slice(0,n.length/2),i=n.slice(n.length/2);s=this.forwardLayer.call(e,Object.assign(t,{initialState:a})),r=this.backwardLayer.call(e,Object.assign(t,{initialState:i}))}return this.returnState&&(Array.isArray(s)&&(a=s.slice(1).concat(r.slice(1))),s=s[0],r=r[0]),this.returnSequences&&(r=Oc(r,1)),"concat"===this.mergeMode?i=kg([s,r]):"sum"===this.mergeMode?i=xo(s,r):"ave"===this.mergeMode?i=ko(.5,xo(s,r)):"mul"===this.mergeMode?i=ko(s,r):null==this.mergeMode&&(i=[s,r]),this.returnState?null==this.mergeMode?i.concat(a):[i].concat(a):i}))}resetStates(e){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(e){ig(this.forwardLayer.name,(()=>{this.forwardLayer.build(e)})),ig(this.backwardLayer.name,(()=>{this.backwardLayer.build(e)})),this.built=!0}computeMask(e,t){let n;if(Array.isArray(t)&&(t=t[0]),n=this.returnSequences?null==this.mergeMode?[t,t]:t:null==this.mergeMode?[null,null]:null,this.returnState){const e=this.forwardLayer.states.map((e=>null));return Array.isArray(n)?n.concat(e).concat(e):[n].concat(e).concat(e)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(e){super.setFastWeightInitDuringBuild(e),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(e),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(e)}getConfig(){const e={mergeMode:this.mergeMode},t=super.getConfig();return Object.assign(e,t),e}static fromConfig(e,t){const n=Xy(t.layer);if(delete t.layer,null!=t.numConstants)throw new Im("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=t;return s.layer=n,new e(s)}}function lv(e){return new jw(e)}function uv(e){return new Xw(e)}function cv(e){return new Jw(e)}function hv(e){return new tv(e)}function pv(e){return new rv(e)}function dv(e){return new Hw(e)}function fv(e){return new Kw(e)}ov.className="Bidirectional",co(ov);const mv=hv,gv=pv,yv=dv,bv=fv;var xv=Object.freeze({__proto__:null,inputLayer:function(e){return new yy(e)},elu:function(e){return new Ax(e)},reLU:function(e){return new $x(e)},leakyReLU:function(e){return new Cx(e)},prelu:function(e){return new Ex(e)},softmax:function(e){return new _x(e)},thresholdedReLU:function(e){return new Rx(e)},conv1d:function(e){return new Xx(e)},conv2d:function(e){return new Ux(e)},conv2dTranspose:function(e){return new Hx(e)},conv3d:function(e){return new Gx(e)},conv3dTranspose:function(e){return new jx(e)},separableConv2d:function(e){return new Kx(e)},cropping2D:function(e){return new Yx(e)},upSampling2d:function(e){return new Zx(e)},depthwiseConv2d:function(e){return new Jx(e)},activation:function(e){return new xw(e)},dense:function(e){return new yw(e)},dropout:function(e){return new mw(e)},spatialDropout1d:function(e){return new gw(e)},flatten:function(e){return new bw(e)},repeatVector:function(e){return new ww(e)},reshape:function(e){return new vw(e)},permute:function(e){return new kw(e)},embedding:function(e){return new Iw(e)},add:function(e){return new Tw(e)},average:function(e){return new Cw(e)},concatenate:function(e){return new Rw(e)},maximum:function(e){return new Ew(e)},minimum:function(e){return new Aw(e)},multiply:function(e){return new $w(e)},dot:function(e){return new Fw(e)},batchNormalization:function(e){return new Pw(e)},layerNormalization:function(e){return new Bw(e)},zeroPadding2d:function(e){return new Ww(e)},averagePooling1d:lv,avgPool1d:function(e){return lv(e)},avgPooling1d:function(e){return lv(e)},averagePooling2d:uv,avgPool2d:function(e){return uv(e)},avgPooling2d:function(e){return uv(e)},averagePooling3d:cv,avgPool3d:function(e){return cv(e)},avgPooling3d:function(e){return cv(e)},globalAveragePooling1d:function(e){return new ev(e)},globalAveragePooling2d:function(e){return new sv(e)},globalMaxPooling1d:hv,globalMaxPooling2d:pv,maxPooling1d:dv,maxPooling2d:fv,maxPooling3d:function(e){return new Zw(e)},gru:function(e){return new iw(e)},gruCell:function(e){return new aw(e)},lstm:function(e){return new lw(e)},lstmCell:function(e){return new ow(e)},simpleRNN:function(e){return new rw(e)},simpleRNNCell:function(e){return new sw(e)},convLstm2d:function(e){return new fw(e)},convLstm2dCell:function(e){return new dw(e)},rnn:function(e){return new tw(e)},stackedRNNCells:function(e){return new uw(e)},bidirectional:function(e){return new ov(e)},timeDistributed:function(e){return new iv(e)},globalMaxPool1d:mv,globalMaxPool2d:gv,maxPool1d:yv,maxPool2d:bv,Layer:my,RNN:tw,RNNCell:nw,input:tx,gaussianNoise:function(e){return new Dw(e)},gaussianDropout:function(e){return new Ow(e)},alphaDropout:function(e){return new Mw(e)},masking:function(e){return new Nw(e)}});var wv=Object.freeze({__proto__:null,binaryAccuracy:function(e,t){return lb(e,t)},binaryCrossentropy:function(e,t){return db(e,t)},sparseCategoricalAccuracy:function(e,t){return fb(e,t)},categoricalAccuracy:function(e,t){return ub(e,t)},categoricalCrossentropy:function(e,t){return mb(e,t)},precision:function(e,t){return hb(e,t)},recall:function(e,t){return pb(e,t)},cosineProximity:function(e,t){return ab(e,t)},meanAbsoluteError:function(e,t){return Jy(e,t)},meanAbsolutePercentageError:function(e,t){return Qy(e,t)},MAPE:function(e,t){return Qy(e,t)},mape:function(e,t){return Qy(e,t)},meanSquaredError:function(e,t){return Zy(e,t)},MSE:function(e,t){return Zy(e,t)},mse:function(e,t){return Zy(e,t)}}),vv=Object.freeze({__proto__:null,modelFromJSON:async function(e,t){"modelTopology"in e||(e={modelTopology:e});let n=e.modelTopology;null!=n.model_config&&(n=n.model_config);const s=Xy(Cb(n),t);if(null!=e.weightsManifest){const t=await ti(e.weightsManifest,e.pathPrefix,s.weights.map((e=>e.originalName))),n={};for(const e of s.weights)n[e.originalName]=t[e.originalName];s.loadWeights(n),xi(t)}return s}});var kv=Object.freeze({__proto__:null,l1l2:function(e){return new kx(e)},l1:function(e){return wx(t=e),new kx({l1:null!=t?t.l1:null,l2:0});var t},l2:function(e){return wx(t=e),new kx({l2:null!=t?t.l2:null,l1:0});var t}});class Nv extends Wy{constructor(){super(...arguments),this.model=null}setModel(e){if(!(e instanceof Zb))throw new Error("model must be a LayersModel, not some other Container");this.model=e}}function Iv(e,t){return e<t}function Sv(e,t){return e>t}class Tv extends Nv{constructor(e){if(super(),null==e&&(e={}),e.restoreBestWeights)throw new Im("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=e.monitor||"val_loss",this.minDelta=Math.abs(e.minDelta||0),this.patience=e.patience||0,this.verbose=e.verbose||0,this.mode=e.mode||"auto",this.baseline=e.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=Iv:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=Sv:this.monitorFunc=Iv,this.monitorFunc===Iv&&(this.minDelta*=-1)}async onTrainBegin(e){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===Iv?1/0:-1/0}async onEpochEnd(e,t){await Py(t);const n=this.getMonitorValue(t);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=e,this.model.stopTraining=!0)))}async onTrainEnd(e){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(e){null==e&&(e={});const t=e[this.monitor];return null==t&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(e)}`),t}}const $v={earlyStopping:function(e){return new Tv(e)}};var Cv,Ev;X().registerFlag("KEEP_INTERMEDIATE_TENSORS",(()=>!1),(e=>{e&&console.warn("Keep intermediate tensors is ON. This will print the values of all intermediate tensors during model inference. Not all models support this mode. For details, check e2e/benchmarks/ model_config.js. This significantly impacts performance.")})),function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_QINT16=15]="DT_QINT16",e[e.DT_QUINT16=16]="DT_QUINT16",e[e.DT_UINT16=17]="DT_UINT16",e[e.DT_COMPLEX128=18]="DT_COMPLEX128",e[e.DT_HALF=19]="DT_HALF",e[e.DT_RESOURCE=20]="DT_RESOURCE",e[e.DT_VARIANT=21]="DT_VARIANT",e[e.DT_UINT32=22]="DT_UINT32",e[e.DT_UINT64=23]="DT_UINT64",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF",e[e.DT_QINT16_REF=115]="DT_QINT16_REF",e[e.DT_QUINT16_REF=116]="DT_QUINT16_REF",e[e.DT_UINT16_REF=117]="DT_UINT16_REF",e[e.DT_COMPLEX128_REF=118]="DT_COMPLEX128_REF",e[e.DT_HALF_REF=119]="DT_HALF_REF",e[e.DT_RESOURCE_REF=120]="DT_RESOURCE_REF",e[e.DT_VARIANT_REF=121]="DT_VARIANT_REF",e[e.DT_UINT32_REF=122]="DT_UINT32_REF",e[e.DT_UINT64_REF=123]="DT_UINT64_REF"}(Cv||(Cv={})),function(e){let t;!function(e){e[e.LEGACY=0]="LEGACY",e[e.V1=1]="V1",e[e.V2=2]="V2"}(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))}(Ev||(Ev={}));const Av={};function Rv(e){return Av[e]}function _v(e,t,n,s,r){const a=t.inputParams[e];if(a&&void 0!==a.inputIndexStart){const e=a.inputIndexStart,i=0===a.inputIndexEnd?void 0:void 0===a.inputIndexEnd?e+1:a.inputIndexEnd;if("tensor"===a.type)return Fv(t.inputNames[a.inputIndexStart],n,s,r);if("tensors"===a.type){return t.inputNames.slice(e,i).map((e=>Fv(e,n,s,r)))}const o=Fv(t.inputNames.slice(e)[0],n,s,r),l=o.dataSync();return"number"===a.type?l[0]:z(o.shape,l)}const i=t.attrParams[e];return i&&i.value}function Fv(e,t,n,s){const[r,a]=Mv(e);if(null!=s){const e=s.getHashTableHandleByName(r);if(null!=e)return e}const i=n.currentContextIds.find((e=>!!t[Ov(r,e)]));return void 0!==i?t[Ov(r,i)][a]:void 0}function Dv(e,t){const[n,s,r]=Mv(e);return[Ov(n,t&&t.currentContextId),s,r]}function Ov(e,t){return t?`${e}-${t}`:e}function Mv(e){const t=e.split(":");if(1===t.length)return[e,0,void 0];const n=t[0],s=3===t.length?t[1]:void 0;return[n,Number(t[t.length-1]),s]}function Lv(e,t,n){let s=_v("pad",e,t,n);if("explicit"===s){s=_v("explicitPaddings",e,t,n);const r=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)r[e][0]=s[2*e],r[e][1]=s[2*e+1];return r}return s}function zv(e){return e.kept?e:Ka(e)}var Pv=Object.freeze({__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Bv=Object.freeze({__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsNan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Wv=Object.freeze({__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcatV2",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListLength",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}]},{tfOpName:"TensorListResize",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"size",type:"number"}]}]});var Vv=Object.freeze({__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]});var Uv=Object.freeze({__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomStandardNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]});var Gv=Object.freeze({__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Hv=Object.freeze({__proto__:null,json:[{tfOpName:"LowerBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"UpperBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]});var jv=Object.freeze({__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]});var qv=Object.freeze({__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableSize",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"LookupTableSizeV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]}]});var Kv=Object.freeze({__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]},{tfOpName:"ImageProjectiveTransformV3",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"transforms",type:"tensor"},{start:2,name:"outputShape",type:"number[]"},{start:3,name:"fillValue",type:"number"}],attrs:[{tfName:"interpolation",name:"interpolation",type:"string"},{tfName:"fill_mode",name:"fillMode",type:"string"}]}]});var Xv=Object.freeze({__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]});var Yv=Object.freeze({__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Einsum",category:"matrices",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"equation",name:"equation",type:"string"},{tfName:"N",name:"n",type:"number",defaultValue:2},{tfName:"T",name:"dtype",type:"dtype"}]}]});var Zv=Object.freeze({__proto__:null,json:[{tfOpName:"EuclideanNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",defaultValue:!1}]},{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]});var Jv=Object.freeze({__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumprod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]});var Qv=Object.freeze({__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]});var ek=Object.freeze({__proto__:null,json:[{tfOpName:"SparseFillEmptyRows",category:"sparse",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"denseShape",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}]},{tfOpName:"SparseReshape",category:"sparse",inputs:[{start:0,name:"inputIndices",type:"tensor"},{start:1,name:"inputShape",type:"tensor"},{start:2,name:"newShape",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SparseSegmentMean",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]},{tfOpName:"SparseSegmentSum",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]}]});var tk=Object.freeze({__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]});var nk=Object.freeze({__proto__:null,json:[{tfOpName:"StringNGrams",category:"string",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"dataSplits",type:"tensor"}],attrs:[{tfName:"separator",name:"separator",type:"string"},{tfName:"ngram_widths",name:"nGramWidths",type:"number[]"},{tfName:"left_pad",name:"leftPad",type:"string"},{tfName:"right_pad",name:"rightPad",type:"string"},{tfName:"pad_width",name:"padWidth",type:"number"},{tfName:"preserve_short_sequences",name:"preserveShortSequences",type:"bool"}],outputs:["ngrams","ngrams_splits"]},{tfOpName:"StringSplit",category:"string",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"delimiter",type:"tensor"}],attrs:[{tfName:"skip_empty",name:"skipEmpty",type:"bool"}],outputs:["indices","values","shape"]},{tfOpName:"StringToHashBucketFast",category:"string",inputs:[{start:0,name:"input",type:"tensor"}],attrs:[{tfName:"num_buckets",name:"numBuckets",type:"number"}]}]});var sk=Object.freeze({__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]},{tfOpName:"BroadcastArgs",category:"transformation",inputs:[{start:0,name:"s0",type:"tensor"},{start:1,name:"s1",type:"tensor"}],attrs:[]}]});class rk{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[Pv,Bv,Wv,Vv,Uv,Gv,Hv,jv,qv,Kv,Xv,Yv,Zv,Jv,Qv,ek,tk,nk,sk].map((e=>e.json)));this.opMappers=e.reduce(((e,t)=>(e[t.tfOpName]=t,e)),{})}transformGraph(e,t={}){const n=e.node,s=[],r=[],a=[],i=n.reduce(((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?s.push(e[t.name]):"Const"===t.op?r.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e)),{});let o=[];const l=[];let u={},c={};null!=t&&(u=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(i);h.forEach((e=>{const t=i[e];t.inputNames.forEach(((e,n)=>{const[s,,r]=Dv(e),a=i[s];if(null!=a.outputs){const e=a.outputs.indexOf(r);if(-1!==e){const r=`${s}:${e}`;t.inputNames[n]=r}}t.inputs.push(a),a.children.push(t)}))})),0===Object.keys(c).length?h.forEach((e=>{const t=i[e];0===t.children.length&&l.push(t)})):Object.keys(c).forEach((e=>{const[t]=Dv(e),n=i[t];null!=n&&(n.signatureKey=c[e],l.push(n))})),Object.keys(u).length>0?Object.keys(u).forEach((e=>{const[t]=Dv(e),n=i[t];n&&(n.signatureKey=u[e],o.push(n))})):o=s;let p={};null!=e.library&&null!=e.library.function&&(p=e.library.function.reduce(((e,t)=>(e[t.signature.name]=this.mapFunction(t),e)),{}));const d={nodes:i,inputs:o,outputs:l,weights:r,placeholders:s,signature:t,functions:p};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce(((t,n)=>(t[e[n].name]=n,t)),{})}mapNode(e){const t=Rv(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map((e=>e.startsWith("^")?e.slice(1):e)),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr,outputs:t.outputs};return null!=t.inputs&&(n.inputParams=t.inputs.reduce(((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e)),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce(((t,n)=>{const s=n.type;let r;switch(n.type){case"string":r=ik(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ik(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":r=gk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=gk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":r=lk(e.attr,n.tfName,n.defaultValue||0),void 0===r&&n.tfDeprecatedName&&(r=lk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":r=mk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=mk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":r=ok(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ok(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":r=bk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=bk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":r=fk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=fk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":r=yk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=yk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":r=hk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=hk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":r=pk(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=pk(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":r=ck(e.attr,n.tfName,n.defaultValue),void 0===r&&n.tfDeprecatedName&&(r=ck(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:r,type:s},t}),{})),n}mapFunction(e){const t=e.nodeDef,n=[];let s={};null!=t&&(s=t.reduce(((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e)),{}));const r=[],a=[];e.signature.inputArg.forEach((e=>{const[t]=Dv(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:uk(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,r.push(n),s[t]=n}));Object.keys(s).forEach((e=>{const t=s[e];t.inputNames.forEach(((e,n)=>{const[r,,a]=Dv(e),i=s[r];if(null!=i.outputs){const e=i.outputs.indexOf(a);if(-1!==e){const s=`${r}:${e}`;t.inputNames[n]=s}}t.inputs.push(i),i.children.push(t)}))}));const i=e.ret;e.signature.outputArg.forEach((e=>{const[t,n]=Dv(i[e.name]),r=s[t];null!=r&&(r.defaultOutput=n,a.push(r))}));const o=this.mapArgsToSignature(e);return{nodes:s,inputs:r,outputs:a,weights:n,placeholders:[],signature:o}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce(((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e)),{}),outputs:e.signature.outputArg.reduce(((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t)),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function ak(e,t){const n=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const t=X().global;if(void 0!==t.atob)return t.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return t?n:n.toLowerCase()}function ik(e,t,n,s=!1){const r=e[t];return null!=r?ak(r.s,s):n}function ok(e,t,n){const s=e[t];return s?s.b:n}function lk(e,t,n){const s=e[t]||{},r=null!=s.i?s.i:null!=s.f?s.f:n;return"number"==typeof r?r:parseInt(r,10)}function uk(e){switch("string"==typeof e&&(e=Cv[e]),e){case Cv.DT_FLOAT:case Cv.DT_HALF:return"float32";case Cv.DT_INT32:case Cv.DT_INT64:case Cv.DT_INT8:case Cv.DT_UINT8:return"int32";case Cv.DT_BOOL:return"bool";case Cv.DT_DOUBLE:return"float32";case Cv.DT_STRING:return"string";default:return null}}function ck(e,t,n){const s=e[t];return s&&s.func?s.func.name:n}function hk(e,t,n){const s=e[t];return s&&s.type?uk(s.type):n}function pk(e,t,n){const s=e[t];return s&&s.list&&s.list.type?s.list.type.map((e=>uk(e))):n}function dk(e){if(!e.unknownRank)return null!=e.dim?e.dim.map((e=>"number"==typeof e.size?e.size:parseInt(e.size,10))):[]}function fk(e,t,n){const s=e[t];return s&&s.shape?dk(s.shape):n}function mk(e,t,n){const s=e[t];return s?((s.list.f&&s.list.f.length?s.list.f:s.list.i)||[]).map((e=>"number"==typeof e?e:parseInt(e,10))):n}function gk(e,t,n,s=!1){const r=e[t];return r&&r.list&&r.list.s?r.list.s.map((e=>ak(e,s))):n}function yk(e,t,n){const s=e[t];return s&&s.list&&s.list.shape?s.list.shape.map((e=>dk(e))):n}function bk(e,t,n){const s=e[t];return s&&s.list&&s.list.b?s.list.b:n}class xk{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map((e=>this.getInput(e))),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce(((e,t)=>(e[t]=this.getAttr(t),e)),{}))}getInput(e){return Fv(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return Fv(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return lk(this.node.rawAttrs,e,t);if(null!=n.s)return ik(this.node.rawAttrs,e,t);if(null!=n.b)return ok(this.node.rawAttrs,e,t);if(null!=n.shape)return fk(this.node.rawAttrs,e,t);if(null!=n.type)return hk(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return mk(this.node.rawAttrs,e,t);if(null!=n.list.s)return gk(this.node.rawAttrs,e,t);if(null!=n.list.shape)return yk(this.node.rawAttrs,e,t);if(null!=n.list.b)return bk(this.node.rawAttrs,e,t);if(null!=n.list.type)return pk(this.node.rawAttrs,e,t)}return t}}var wk=Object.freeze({__proto__:null,abs:No,acos:Io,acosh:So,add:xo,addN:To,all:$o,any:Co,argMax:Eo,argMin:Ao,asin:Ro,asinh:_o,atan:Fo,atan2:Do,atanh:Oo,avgPool:Zo,avgPool3d:Jo,basicLSTMCell:sl,batchToSpaceND:rl,batchNorm:al,batchNorm2d:il,batchNorm3d:ol,batchNorm4d:ll,bincount:ul,broadcastArgs:cl,broadcastTo:hl,buffer:ja,cast:qa,ceil:pl,clipByValue:dl,clone:Ka,complex:Qr,concat:Qo,concat1d:fl,concat2d:ml,concat3d:gl,concat4d:yl,conv1d:xl,conv2d:bl,conv2dTranspose:vl,conv3d:kl,conv3dTranspose:Il,cos:Sl,cosh:Tl,cumprod:$l,cumsum:Cl,denseBincount:El,depthToSpace:Al,depthwiseConv2d:Rl,diag:_l,dilation2d:Fl,div:vo,divNoNan:Ll,dot:zl,einsum:Pl,elu:Bl,equal:Dl,erf:Wl,euclideanNorm:au,exp:iu,expandDims:ou,expm1:lu,eye:cu,fill:hu,floor:pu,floorDiv:wo,gather:du,greater:fu,greaterEqual:mu,imag:Ii,isFinite:gu,isInf:yu,isNaN:bu,leakyRelu:xu,less:wu,lessEqual:vu,linspace:ku,localResponseNormalization:Nu,log:Iu,log1p:Su,logSigmoid:Au,logSoftmax:_u,logSumExp:Fu,logicalAnd:Du,logicalNot:Ou,logicalOr:Mu,logicalXor:Lu,lowerBound:Bu,matMul:di,max:Yl,maxPool:Wu,maxPool3d:Vu,maxPoolWithArgmax:Uu,maximum:Gu,mean:Hu,meshgrid:Ku,min:Zl,minimum:Xu,mirrorPad:Yu,mod:Zu,moments:Ju,mul:ko,multiRNNCell:Qu,multinomial:ec,neg:Si,notEqual:tc,oneHot:fi,ones:qu,onesLike:nc,outerProduct:sc,pad:rc,pad1d:ac,pad2d:ic,pad3d:oc,pad4d:lc,pool:cc,pow:Jl,prelu:hc,print:Xa,prod:pc,rand:dc,randomGamma:$c,randomNormal:Cc,randomStandardNormal:Ec,randomUniform:Ac,range:Rc,real:Ti,reciprocal:_c,relu:Fc,relu6:Dc,reshape:Yo,reverse:Oc,reverse1d:Mc,reverse2d:Lc,reverse3d:zc,reverse4d:Pc,round:Bc,rsqrt:Wc,scalar:Ql,selu:Vc,separableConv2d:Uc,setdiff1dAsync:Gc,sigmoid:el,sign:Hc,sin:jc,sinh:qc,slice:tl,slice1d:Kc,slice2d:Xc,slice3d:Yc,slice4d:Zc,softmax:Jc,softplus:Eu,spaceToBatchND:uc,fft:Qc,ifft:eh,irfft:th,rfft:sh,split:nh,sqrt:eu,square:tu,squaredDifference:rh,squeeze:ah,stack:ih,step:oh,stridedSlice:lh,sub:Ru,sum:nu,tan:uh,tanh:nl,tensor:ta,tensor1d:ch,tensor2d:hh,tensor3d:Di,tensor4d:ph,tensor5d:dh,tensor6d:fh,tile:uu,topk:mh,truncatedNormal:gh,unique:yh,unsortedSegmentSum:bh,unstack:xh,upperBound:wh,variable:vh,where:Ol,whereAsync:Nh,zeros:ju,zerosLike:Ml,op:Jr,OP_SCOPE_SUFFIX:Zr,booleanMaskAsync:Ih,transpose:$i,norm:ru,movingAverage:Sh,scatterND:Th,searchSorted:Pu,sparseToDense:$h,gatherND:Ch,dropout:Eh,enclosingPowerOfTwo:Ah,cosineWindow:Rh,inTopKAsync:_h,image:Wp,linalg:Vp,losses:Up,spectral:Pp,fused:Uh,signal:Bp,sparse:Gp,string:Hp});function vk(e,t,n=""){if("number"!=typeof e&&"number"!=typeof t){u(e.length===t.length,(()=>n+` Shapes ${e} and ${t} must match`));for(let s=0;s<e.length;s++){const r=e[s],a=t[s];u(r<0||a<0||r===a,(()=>n+` Shapes ${e} and ${t} must match`))}}}function kk(e){return"number"!=typeof e&&!e.some((e=>e<0))}function Nk(e,t,n){let s=Ik(e,n);const r=!kk(s);if(r&&0===t.length)throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${s}`);if(r&&t.forEach((e=>{s=Ik(e.shape,s)})),!kk(s))throw new Error(`Non-fully-defined elementShape: ${s}`);return s}function Ik(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let s=0;s<e.length;++s){const r=e[s],a=t[s];if(r>=0&&a>=0&&r!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[s]=r>=0?r:a}return n}class Sk{constructor(e,t,n,s,r,a,i){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=s,this.identicalElementShapes=r,this.dynamicSize=a,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=Ql(0),wi(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()})),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map((e=>this.read(e)))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),vk(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,wi(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach(((e,n)=>this.write(e,t[n])))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return ta([],[0].concat(this.elementShape));const n=this.readMany(e);return vk(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),ih(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return ta([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return vk(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),Qo(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,xh(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const s=e.map((e=>(n+=e,n)));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const r=0===n?0:t.size/n,a=[];bi((()=>{t=Yo(t,[1,n,r]);for(let n=0;n<e.length;++n){const i=[0,0===n?0:s[n-1],0],o=[1,e[n],r];a[n]=Yo(tl(t,i,o),this.elementShape)}return a}));const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,a)}}class Tk{constructor(e,t,n,s=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach((e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);vk(t,e.shape,"TensorList shape mismatch: "),wi(e)})),this.idTensor=Ql(0),this.maxNumElements=s,wi(this.idTensor)}get id(){return this.idTensor.id}copy(){return new Tk([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.id)||t.dispose()})),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);vk(e,this.elementShape,"TensorList shape mismatch: ");const s=Nk(this.elementShape,this.tensors,e);return bi((()=>{const e=this.tensors.map((e=>Yo(e,s)));return ih(e,0)}))}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=Nk(this.elementShape,this.tensors,e),s=this.tensors.pop();return vk(s.shape,e,"TensorList shape mismatch: "),Yo(s,n)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(vk(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");wi(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);const t=new Tk([],this.elementShape,this.elementDtype,this.maxNumElements);t.tensors.length=e;for(let n=0;n<Math.min(this.tensors.length,e);++n)t.tensors[n]=this.tensors[n];return t}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);vk(this.tensors[e].shape,t,"TensorList shape mismatch: ");const s=Nk(this.elementShape,this.tensors,t);return Yo(this.tensors[e],s)}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);vk(this.elementShape,t.shape,"TensorList shape mismatch: "),wi(t),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);vk(this.elementShape,n,"TensorList shape mismatch: "),e=e.slice(0,this.size());const s=Nk(this.elementShape,this.tensors,n);return 0===e.length?ta([],[0].concat(s)):bi((()=>{const t=e.map((e=>Yo(this.tensors[e],s)));return ih(t,0)}))}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);vk(this.elementShape,t,"TensorList shape mismatch: ");const n=Nk(this.elementShape,this.tensors,t);return 0===this.size()?ta([],[0].concat(n)):bi((()=>{const e=this.tensors.map((e=>Yo(e,n)));return Qo(e,0)}))}}const $k=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const s=_v("thenBranch",e,t,n),r=_v("elseBranch",e,t,n),a=_v("cond",e,t,n),i=_v("args",e,t,n);return(await a.data())[0]?n.functionMap[s].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap):n.functionMap[r].executeFunctionAsync(i,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const s=_v("body",e,t,n),r=_v("cond",e,t,n),a=_v("args",e,t,n),i=await n.functionMap[r].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),o=a.map((e=>e.id));let l=await i[0].data();i.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||e.dispose()}));let u=a;for(;l[0];){const e=u;u=await n.functionMap[s].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);const t=u.map((e=>e.id));e.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}));const a=await n.functionMap[r].executeFunctionAsync(u,n.tensorArrayMap,n.tensorListMap);l=await a[0].data(),a.forEach((e=>{e.kept||-1!==o.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}))}return u}case"LoopCond":return[zv(_v("pred",e,t,n))];case"Switch":{const s=_v("pred",e,t,n);let r=_v("data",e,t,n);return r.kept||(r=zv(r)),(await s.data())[0]?[void 0,r]:[r,void 0]}case"Merge":{const s=e.inputNames.find((e=>void 0!==Fv(e,t,n)));if(s){return[zv(Fv(s,t,n))]}return}case"Enter":{const s=_v("frameName",e,t,n),r=_v("tensor",e,t,n);return n.enterFrame(s),[zv(r)]}case"Exit":{const s=_v("tensor",e,t,n);return n.exitFrame(),[zv(s)]}case"NextIteration":{const s=_v("tensor",e,t,n);return n.nextIteration(),[zv(s)]}case"TensorArrayV3":{const s=_v("size",e,t,n),r=_v("dtype",e,t,n),a=_v("elementShape",e,t,n),i=_v("dynamicSize",e,t,n),o=_v("clearAfterRead",e,t,n),l=_v("identicalElementShapes",e,t,n),u=_v("name",e,t,n),c=new Sk(u,r,s,a,l,i,o);return n.addTensorArray(c),[c.idTensor,Ql(1)]}case"TensorArrayWriteV3":{const s=_v("tensorArrayId",e,t,n),r=_v("index",e,t,n),a=_v("tensor",e,t,n),i=n.getTensorArray(s.id);return i.write(r,a),[i.idTensor]}case"TensorArrayReadV3":{const s=_v("tensorArrayId",e,t,n),r=_v("index",e,t,n);return[n.getTensorArray(s.id).read(r)]}case"TensorArrayGatherV3":{const s=_v("tensorArrayId",e,t,n),r=_v("indices",e,t,n),a=_v("dtype",e,t,n);return[n.getTensorArray(s.id).gather(r,a)]}case"TensorArrayScatterV3":{const s=_v("tensorArrayId",e,t,n),r=_v("indices",e,t,n),a=_v("tensor",e,t,n),i=n.getTensorArray(s.id);return i.scatter(r,a),[i.idTensor]}case"TensorArrayConcatV3":{const s=_v("tensorArrayId",e,t,n),r=n.getTensorArray(s.id),a=_v("dtype",e,t,n);return[r.concat(a)]}case"TensorArraySplitV3":{const s=_v("tensorArrayId",e,t,n),r=_v("tensor",e,t,n),a=_v("lengths",e,t,n),i=n.getTensorArray(s.id);return i.split(a,r),[i.idTensor]}case"TensorArraySizeV3":{const s=_v("tensorArrayId",e,t,n);return[Ql(n.getTensorArray(s.id).size(),"int32")]}case"TensorArrayCloseV3":{const s=_v("tensorArrayId",e,t,n),r=n.getTensorArray(s.id);return r.clearAndClose(),[r.idTensor]}case"TensorListSetItem":{const s=_v("tensorListId",e,t,n),r=_v("index",e,t,n),a=_v("tensor",e,t,n),i=n.getTensorList(s.id);return i.setItem(r,a),[i.idTensor]}case"TensorListGetItem":{const s=_v("tensorListId",e,t,n),r=_v("index",e,t,n),a=_v("elementShape",e,t,n),i=_v("elementDType",e,t,n);return[n.getTensorList(s.id).getItem(r,a,i)]}case"TensorListScatterV2":case"TensorListScatter":{const s=_v("indices",e,t,n),r=function(e,t,n,s){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const r=Math.max(...t);if(null!=s&&-1!==s&&r>=s)throw new Error(`Max index must be < array size (${r}  vs. ${s})`);const a=new Tk([],n,e.dtype,s),i=xh(e,0);return t.forEach(((e,t)=>{a.setItem(e,i[t])})),a}(_v("tensor",e,t,n),s,_v("elementShape",e,t,n),_v("numElements",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const s=_v("elementShape",e,t,n),r=_v("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const i=_v(a,e,t,n),o=function(e,t,n,s){return new Tk([],e,t,s)}(s,r,0,"TensorListReserve"===e.op?-1:i);return n.addTensorList(o),[o.idTensor]}case"TensorListGather":{const s=_v("tensorListId",e,t,n),r=_v("indices",e,t,n),a=_v("elementShape",e,t,n),i=_v("elementDType",e,t,n);return[n.getTensorList(s.id).gather(r,i,a)]}case"TensorListStack":{const s=_v("tensorListId",e,t,n),r=_v("elementShape",e,t,n),a=_v("elementDType",e,t,n),i=_v("numElements",e,t,n);return[n.getTensorList(s.id).stack(r,a,i)]}case"TensorListFromTensor":{const s=function(e,t,n){const s=e.dtype;if(e.shape.length<1)throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);vk(e.shape.slice(1),t,"TensorList shape mismatch: ");const r=xh(e);return new Tk(r,t,s)}(_v("tensor",e,t,n),_v("elementShape",e,t,n),_v("elementDType",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListConcat":case"TensorListConcatV2":{const s=_v("tensorListId",e,t,n),r=n.getTensorList(s.id),a=_v("dtype",e,t,n),i=_v("elementShape",e,t,n);return[r.concat(a,i)]}case"TensorListPushBack":{const s=_v("tensorListId",e,t,n),r=_v("tensor",e,t,n),a=n.getTensorList(s.id);return a.pushBack(r),[a.idTensor]}case"TensorListPopBack":{const s=_v("tensorListId",e,t,n),r=_v("elementShape",e,t,n),a=_v("elementDType",e,t,n);return[n.getTensorList(s.id).popBack(r,a)]}case"TensorListSplit":{const s=_v("tensor",e,t,n),r=_v("elementShape",e,t,n),a=function(e,t,n){let s=0;const r=t.map((e=>(s+=e,s)));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const a=Ik(e.shape.slice(1),n),i=0===s?0:e.size/s,o=bi((()=>{const n=[];e=Yo(e,[1,s,i]);for(let s=0;s<t.length;++s){const o=[0,0===s?0:r[s-1],0],l=[1,t[s],i];n[s]=Yo(tl(e,o,l),a)}return e.dispose(),n})),l=new Tk([],n,e.dtype,t.length);for(let e=0;e<o.length;e++)l.setItem(e,o[e]);return l}(s,_v("lengths",e,t,n),r);return n.addTensorList(a),[a.idTensor]}case"TensorListLength":{const s=_v("tensorListId",e,t,n);return[Ql(n.getTensorList(s.id).size(),"int32")]}case"TensorListResize":{const s=_v("tensorListId",e,t,n),r=_v("size",e,t,n),a=n.getTensorList(s.id).resize(r);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function Ck(e,t,n){const[s,r]=_v("fusedOps",e,t,n),a="biasadd"===s,i=!a,o="prelu"===r,l="fusedbatchnorm"===s,u=_v("numArgs",e,t,n);if(a){if(o&&2!==u)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!o&&a&&1!==u)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(l)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");const c=_v("strides",e,t,n),h=Lv(e,t,n),p=_v("dataFormat",e,t,n).toUpperCase(),d=_v("dilations",e,t,n);let[f,m]=_v("args",e,t,n);i&&(m=f,f=void 0);return{stride:c,pad:h,dataFormat:p,dilations:d,biasArg:f,preluArg:m,activationFunc:r,leakyreluAlpha:_v("leakyreluAlpha",e,t,n)}}function Ek(e,t,n){return{boxes:_v("boxes",e,t,n),scores:_v("scores",e,t,n),maxOutputSize:_v("maxOutputSize",e,t,n),iouThreshold:_v("iouThreshold",e,t,n),scoreThreshold:_v("scoreThreshold",e,t,n),softNmsSigma:_v("softNmsSigma",e,t,n)}}class Ak{constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=Ql(0),this.tensorMap=new Map,wi(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}tensorSize(){return Ql(this.size(),"int32")}async import(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),bi((()=>{const e=xh(t),s=n.length,r=e.length;u(s===r,(()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${r} elements.`));for(let t=0;t<s;t++){const s=n[t],r=e[t];wi(r),this.tensorMap.set(s,r)}return this.handle}))}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return bi((()=>{const e=[];for(let s=0;s<n.length;s++){const r=n[s],a=this.findWithDefault(r,t);e.push(a)}return ih(e)}))}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`)}}function Rk(e,t,n,s,r=bi){const a=((e,t,n)=>{switch(e.category){case"arithmetic":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[s.add(_v("a",e,t,n),_v("b",e,t,n))];case"AddN":return[s.addN(_v("tensors",e,t,n))];case"FloorMod":case"Mod":return[s.mod(_v("a",e,t,n),_v("b",e,t,n))];case"Mul":return[s.mul(_v("a",e,t,n),_v("b",e,t,n))];case"RealDiv":case"Div":return[s.div(_v("a",e,t,n),_v("b",e,t,n))];case"DivNoNan":return[s.divNoNan(_v("a",e,t,n),_v("b",e,t,n))];case"FloorDiv":return[s.floorDiv(_v("a",e,t,n),_v("b",e,t,n))];case"Sub":return[s.sub(_v("a",e,t,n),_v("b",e,t,n))];case"Minimum":return[s.minimum(_v("a",e,t,n),_v("b",e,t,n))];case"Maximum":return[s.maximum(_v("a",e,t,n),_v("b",e,t,n))];case"Pow":return[s.pow(_v("a",e,t,n),_v("b",e,t,n))];case"SquaredDifference":return[s.squaredDifference(_v("a",e,t,n),_v("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"basic_math":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Abs":case"ComplexAbs":return[s.abs(_v("x",e,t,n))];case"Acos":return[s.acos(_v("x",e,t,n))];case"Acosh":return[s.acosh(_v("x",e,t,n))];case"Asin":return[s.asin(_v("x",e,t,n))];case"Asinh":return[s.asinh(_v("x",e,t,n))];case"Atan":return[s.atan(_v("x",e,t,n))];case"Atan2":return[s.atan2(_v("x",e,t,n),_v("y",e,t,n))];case"Atanh":return[s.atanh(_v("x",e,t,n))];case"Ceil":return[s.ceil(_v("x",e,t,n))];case"Complex":return[s.complex(_v("real",e,t,n),_v("imag",e,t,n))];case"Cos":return[s.cos(_v("x",e,t,n))];case"Cosh":return[s.cosh(_v("x",e,t,n))];case"Elu":return[s.elu(_v("x",e,t,n))];case"Erf":return[s.erf(_v("x",e,t,n))];case"Exp":return[s.exp(_v("x",e,t,n))];case"Expm1":return[s.expm1(_v("x",e,t,n))];case"Floor":return[s.floor(_v("x",e,t,n))];case"Log":return[s.log(_v("x",e,t,n))];case"Log1p":return[s.log1p(_v("x",e,t,n))];case"Imag":return[s.imag(_v("x",e,t,n))];case"Neg":return[s.neg(_v("x",e,t,n))];case"Reciprocal":return[s.reciprocal(_v("x",e,t,n))];case"Real":return[s.real(_v("x",e,t,n))];case"Relu":return[s.relu(_v("x",e,t,n))];case"Round":return[s.round(_v("x",e,t,n))];case"Selu":return[s.selu(_v("x",e,t,n))];case"Sigmoid":return[s.sigmoid(_v("x",e,t,n))];case"Sin":return[s.sin(_v("x",e,t,n))];case"Sign":return[s.sign(_v("x",e,t,n))];case"Sinh":return[s.sinh(_v("x",e,t,n))];case"Softplus":return[s.softplus(_v("x",e,t,n))];case"Sqrt":return[s.sqrt(_v("x",e,t,n))];case"Square":return[s.square(_v("x",e,t,n))];case"Tanh":return[s.tanh(_v("x",e,t,n))];case"Tan":return[s.tan(_v("x",e,t,n))];case"ClipByValue":return[s.clipByValue(_v("x",e,t,n),_v("clipValueMin",e,t,n),_v("clipValueMax",e,t,n))];case"Relu6":return[s.relu6(_v("x",e,t,n))];case"Rsqrt":return[s.rsqrt(Fv(e.inputNames[0],t,n))];case"Prod":return[s.prod(_v("x",e,t,n),_v("axes",e,t,n))];case"LeakyRelu":return[s.leakyRelu(_v("x",e,t,n),_v("alpha",e,t,n))];case"Prelu":return[s.prelu(_v("x",e,t,n),_v("alpha",e,t,n))];case"IsNan":return[s.isNaN(Fv(e.inputNames[0],t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"control":return $k(e,t,n);case"convolution":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Conv1D":{const r=_v("stride",e,t,n),a=_v("pad",e,t,n),i=_v("dataFormat",e,t,n).toUpperCase(),o=_v("dilation",e,t,n);return[s.conv1d(_v("x",e,t,n),_v("filter",e,t,n),r,a,i,o)]}case"Conv2D":{const r=_v("strides",e,t,n),a=Lv(e,t,n),i=_v("dataFormat",e,t,n).toUpperCase(),o=_v("dilations",e,t,n);return[s.conv2d(_v("x",e,t,n),_v("filter",e,t,n),[r[1],r[2]],a,i,[o[1],o[2]])]}case"_FusedConv2D":{const{stride:r,pad:a,dataFormat:i,dilations:o,biasArg:l,preluArg:u,activationFunc:c,leakyreluAlpha:h}=Ck(e,t,n);return[s.fused.conv2d({x:_v("x",e,t,n),filter:_v("filter",e,t,n),strides:[r[1],r[2]],pad:a,dataFormat:i,dilations:[o[1],o[2]],bias:l,activation:c,preluActivationWeights:u,leakyreluAlpha:h})]}case"FusedDepthwiseConv2dNative":{const{stride:r,pad:a,dataFormat:i,dilations:o,biasArg:l,preluArg:u,activationFunc:c,leakyreluAlpha:h}=Ck(e,t,n);return[s.fused.depthwiseConv2d({x:_v("x",e,t,n),filter:_v("filter",e,t,n),strides:[r[1],r[2]],pad:a,dataFormat:i,dilations:[o[1],o[2]],bias:l,activation:c,preluActivationWeights:u,leakyreluAlpha:h})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const r=_v("outputShape",e,t,n),a=_v("strides",e,t,n),i=Lv(e,t,n);return[s.conv2dTranspose(_v("x",e,t,n),_v("filter",e,t,n),r,[a[1],a[2]],i)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const r=_v("strides",e,t,n),a=Lv(e,t,n),i=_v("dilations",e,t,n),o=_v("dataFormat",e,t,n).toUpperCase();return[s.depthwiseConv2d(_v("input",e,t,n),_v("filter",e,t,n),[r[1],r[2]],a,o,[i[1],i[2]])]}case"Conv3D":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("dataFormat",e,t,n).toUpperCase(),o=_v("dilations",e,t,n);return[s.conv3d(_v("x",e,t,n),_v("filter",e,t,n),[r[1],r[2],r[3]],a,i,[o[1],o[2],o[3]])]}case"AvgPool":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("kernelSize",e,t,n);return[s.avgPool(_v("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a)]}case"MaxPool":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("kernelSize",e,t,n);return[s.maxPool(_v("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a)]}case"MaxPoolWithArgmax":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("kernelSize",e,t,n),o=_v("includeBatchInIndex",e,t,n),{result:l,indexes:u}=s.maxPoolWithArgmax(_v("x",e,t,n),[i[1],i[2]],[r[1],r[2]],a,o);return[l,u]}case"AvgPool3D":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("kernelSize",e,t,n);return[s.avgPool3d(_v("x",e,t,n),[i[1],i[2],i[3]],[r[1],r[2],r[3]],a)]}case"MaxPool3D":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("kernelSize",e,t,n);return[s.maxPool3d(_v("x",e,t,n),[i[1],i[2],i[3]],[r[1],r[2],r[3]],a)]}case"Dilation2D":{const r=_v("strides",e,t,n),a=_v("pad",e,t,n),i=_v("dilations",e,t,n),o=r[1],l=r[2],u=i[1],c=i[2];return[s.dilation2d(_v("x",e,t,n),_v("filter",e,t,n),[o,l],a,[u,c],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"creation":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Fill":{const r=_v("shape",e,t,n),a=_v("dtype",e,t,n),i=_v("value",e,t,n);return[s.fill(r,i,a)]}case"LinSpace":{const r=_v("start",e,t,n),a=_v("stop",e,t,n),i=_v("num",e,t,n);return[s.linspace(r,a,i)]}case"Multinomial":{const r=_v("logits",e,t,n),a=_v("numSamples",e,t,n),i=_v("seed",e,t,n);return[s.multinomial(r,a,i)]}case"OneHot":{const r=_v("indices",e,t,n),a=_v("depth",e,t,n),i=_v("onValue",e,t,n),o=_v("offValue",e,t,n);return[s.oneHot(r,a,i,o)]}case"Ones":return[s.ones(_v("shape",e,t,n),_v("dtype",e,t,n))];case"OnesLike":return[s.onesLike(_v("x",e,t,n))];case"RandomStandardNormal":return[s.randomStandardNormal(_v("shape",e,t,n),_v("dtype",e,t,n),_v("seed",e,t,n))];case"RandomUniform":return[s.randomUniform(_v("shape",e,t,n),_v("minval",e,t,n),_v("maxval",e,t,n),_v("dtype",e,t,n))];case"Range":{const r=_v("start",e,t,n),a=_v("stop",e,t,n),i=_v("step",e,t,n);return[s.range(r,a,i,_v("dtype",e,t,n))]}case"TruncatedNormal":{const r=_v("shape",e,t,n),a=_v("mean",e,t,n),i=_v("stdDev",e,t,n),o=_v("seed",e,t,n);return[s.truncatedNormal(r,a,i,_v("dtype",e,t,n),o)]}case"Zeros":return[s.zeros(_v("shape",e,t,n),_v("dtype",e,t,n))];case"ZerosLike":return[s.zerosLike(_v("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"dynamic":return(async(e,t,n,s,r=wk)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=Ek(e,t,n),c=await r.image.nonMaxSuppressionWithScoreAsync(s,a,i,o,l,u);return[c.selectedIndices,c.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=Ek(e,t,n),u=_v("padToMaxOutputSize",e,t,n),c=await r.image.nonMaxSuppressionPaddedAsync(s,a,i,o,l,u);return[c.selectedIndices,c.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:s,scores:a,maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=Ek(e,t,n);return[await r.image.nonMaxSuppressionAsync(s,a,i,o,l)]}case"Where":{const s=r.cast(_v("condition",e,t,n),"bool"),a=[await r.whereAsync(s)];return s.dispose(),a}case"ListDiff":return r.setdiff1dAsync(_v("x",e,t,n),_v("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n);case"evaluation":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"LowerBound":{const r=_v("sortedSequence",e,t,n),a=_v("values",e,t,n);return[s.lowerBound(r,a)]}case"TopKV2":{const r=_v("x",e,t,n),a=_v("k",e,t,n),i=_v("sorted",e,t,n),o=s.topk(r,a,i);return[o.values,o.indices]}case"UpperBound":{const r=_v("sortedSequence",e,t,n),a=_v("values",e,t,n);return[s.upperBound(r,a)]}case"Unique":{const r=_v("x",e,t,n),a=s.unique(r);return[a.values,a.indices]}case"UniqueV2":{const r=_v("x",e,t,n),a=_v("axis",e,t,n),i=s.unique(r,a);return[i.values,i.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"image":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"ResizeBilinear":{const r=_v("images",e,t,n),a=_v("size",e,t,n),i=_v("alignCorners",e,t,n),o=_v("halfPixelCenters",e,t,n);return[s.image.resizeBilinear(r,[a[0],a[1]],i,o)]}case"ResizeNearestNeighbor":{const r=_v("images",e,t,n),a=_v("size",e,t,n),i=_v("alignCorners",e,t,n),o=_v("halfPixelCenters",e,t,n);return[s.image.resizeNearestNeighbor(r,[a[0],a[1]],i,o)]}case"CropAndResize":{const r=_v("image",e,t,n),a=_v("boxes",e,t,n),i=_v("boxInd",e,t,n),o=_v("cropSize",e,t,n),l=_v("method",e,t,n),u=_v("extrapolationValue",e,t,n);return[s.image.cropAndResize(r,a,i,o,l,u)]}case"ImageProjectiveTransformV3":{const r=_v("images",e,t,n),a=_v("transforms",e,t,n),i=_v("outputShape",e,t,n),o=_v("fillValue",e,t,n),l=_v("interpolation",e,t,n),u=_v("fillMode",e,t,n);return[s.image.transform(r,a,l.toLowerCase(),u.toLowerCase(),o,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"graph":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const r=_v("default",e,t,n);return[Fv(e.name,t,n)||r];case"Placeholder":return[Fv(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":case"Snapshot":return[zv(_v("x",e,t,n))];case"IdentityN":return _v("x",e,t,n).map((e=>zv(e)));case"Shape":return[s.tensor1d(_v("x",e,t,n).shape,"int32")];case"ShapeN":return _v("x",e,t,n).map((e=>s.tensor1d(e.shape)));case"Size":return[s.scalar(_v("x",e,t,n).size,"int32")];case"Rank":return[s.scalar(_v("x",e,t,n).rank,"int32")];case"NoOp":return[s.scalar(1)];case"Print":const a=_v("x",e,t,n),i=_v("data",e,t,n),o=_v("message",e,t,n),l=_v("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(o);for(let e=0;e<i.length;e++)console.log(Array.prototype.slice.call(i[e].dataSync()).slice(0,l));return[a];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"logical":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Equal":return[s.equal(_v("a",e,t,n),_v("b",e,t,n))];case"NotEqual":return[s.notEqual(_v("a",e,t,n),_v("b",e,t,n))];case"Greater":return[s.greater(_v("a",e,t,n),_v("b",e,t,n))];case"GreaterEqual":return[s.greaterEqual(_v("a",e,t,n),_v("b",e,t,n))];case"Less":return[s.less(_v("a",e,t,n),_v("b",e,t,n))];case"LessEqual":return[s.lessEqual(_v("a",e,t,n),_v("b",e,t,n))];case"LogicalAnd":return[s.logicalAnd(_v("a",e,t,n),_v("b",e,t,n))];case"LogicalNot":return[s.logicalNot(_v("a",e,t,n))];case"LogicalOr":return[s.logicalOr(_v("a",e,t,n),_v("b",e,t,n))];case"Select":case"SelectV2":return[s.where(_v("condition",e,t,n),_v("a",e,t,n),_v("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"matrices":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[s.matMul(_v("a",e,t,n),_v("b",e,t,n),_v("transposeA",e,t,n),_v("transposeB",e,t,n))];case"Einsum":return[s.einsum(_v("equation",e,t,n),..._v("tensors",e,t,n))];case"Transpose":return[s.transpose(_v("x",e,t,n),_v("perm",e,t,n))];case"_FusedMatMul":const[r,a]=_v("fusedOps",e,t,n),i="biasadd"===r,o="prelu"===a,l=_v("numArgs",e,t,n),u=_v("leakyreluAlpha",e,t,n);if(i){if(o&&2!==l)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!o&&1!==l)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[c,h]=_v("args",e,t,n);return[s.fused.matMul({a:_v("a",e,t,n),b:_v("b",e,t,n),transposeA:_v("transposeA",e,t,n),transposeB:_v("transposeB",e,t,n),bias:c,activation:a,preluActivationWeights:h,leakyreluAlpha:u})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"normalization":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"EuclideanNorm":return[s.euclideanNorm(_v("x",e,t,n),_v("axis",e,t,n),_v("keepDims",e,t,n))];case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[s.batchNorm(_v("x",e,t,n),_v("mean",e,t,n),_v("variance",e,t,n),_v("offset",e,t,n),_v("scale",e,t,n),_v("epsilon",e,t,n))];case"LRN":return[s.localResponseNormalization(_v("x",e,t,n),_v("radius",e,t,n),_v("bias",e,t,n),_v("alpha",e,t,n),_v("beta",e,t,n))];case"Softmax":return[s.softmax(_v("x",e,t,n))];case"LogSoftmax":return[s.logSoftmax(_v("x",e,t,n))];case"SparseToDense":return[s.sparseToDense(_v("sparseIndices",e,t,n),_v("outputShape",e,t,n),_v("sparseValues",e,t,n),_v("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"reduction":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Max":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.max(_v("x",e,t,n),r,a)]}case"Mean":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.mean(_v("x",e,t,n),r,a)]}case"Min":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.min(_v("x",e,t,n),r,a)]}case"Sum":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.sum(_v("x",e,t,n),r,a)]}case"All":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.all(_v("x",e,t,n),r,a)]}case"Any":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.any(_v("x",e,t,n),r,a)]}case"ArgMax":{const r=_v("axis",e,t,n);return[s.argMax(_v("x",e,t,n),r)]}case"ArgMin":{const r=_v("axis",e,t,n);return[s.argMin(_v("x",e,t,n),r)]}case"Prod":{const r=_v("axis",e,t,n),a=_v("keepDims",e,t,n);return[s.prod(_v("x",e,t,n),r,a)]}case"Cumprod":{const r=_v("axis",e,t,n),a=_v("exclusive",e,t,n),i=_v("reverse",e,t,n);return[s.cumprod(_v("x",e,t,n),r,a,i)]}case"Cumsum":{const r=_v("axis",e,t,n),a=_v("exclusive",e,t,n),i=_v("reverse",e,t,n);return[s.cumsum(_v("x",e,t,n),r,a,i)]}case"Bincount":const r=_v("x",e,t,n),a=_v("weights",e,t,n),i=_v("size",e,t,n);return[s.bincount(r,a,i)];case"DenseBincount":{const r=_v("x",e,t,n),a=_v("weights",e,t,n),i=_v("size",e,t,n),o=_v("binaryOutput",e,t,n);return[s.denseBincount(r,a,i,o)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"slice_join":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"ConcatV2":case"Concat":{const r=_v("n",e,t,n),a=_v("axis",e,t,n);let i=_v("tensors",e,t,n);return i=i.slice(0,r),[s.concat(i,a)]}case"Gather":{const r=_v("x",e,t,n),a=_v("indices",e,t,n);return[s.gather(r,s.cast(a,"int32"),0)]}case"GatherV2":{const r=_v("axis",e,t,n),a=_v("batchDims",e,t,n),i=_v("x",e,t,n),o=_v("indices",e,t,n);return[s.gather(i,s.cast(o,"int32"),r,a)]}case"Reverse":{const r=_v("dims",e,t,n),a=[];for(let e=0;e<r.length;e++)r[e]&&a.push(e);const i=_v("x",e,t,n);return[s.reverse(i,a)]}case"ReverseV2":{const r=_v("axis",e,t,n),a=_v("x",e,t,n);return[s.reverse(a,r)]}case"Slice":{const r=_v("begin",e,t,n),a=_v("size",e,t,n);return[s.slice(_v("x",e,t,n),r,a)]}case"StridedSlice":{const r=_v("begin",e,t,n),a=_v("end",e,t,n),i=_v("strides",e,t,n),o=_v("beginMask",e,t,n),l=_v("endMask",e,t,n),u=_v("ellipsisMask",e,t,n),c=_v("newAxisMask",e,t,n),h=_v("shrinkAxisMask",e,t,n),p=_v("x",e,t,n);return[s.stridedSlice(p,r,a,i,o,l,u,c,h)]}case"Pack":return bi((()=>{const r=_v("axis",e,t,n),a=_v("tensors",e,t,n),i=a[0].shape,o=s.squeeze(a[0]).shape,l=a.map((e=>{const t=f(e.shape,i);if(!t&&!f(s.squeeze(e).shape,o))throw new Error("the input tensors shape does not match");return t?e:s.reshape(e,i)}));return[s.stack(l,r)]}));case"Unpack":{const r=_v("axis",e,t,n),a=_v("tensor",e,t,n);return s.unstack(a,r)}case"Tile":{const r=_v("reps",e,t,n);return[s.tile(_v("x",e,t,n),r)]}case"Split":case"SplitV":{const r=_v("axis",e,t,n),a=_v("numOrSizeSplits",e,t,n),i=_v("x",e,t,n);return s.split(i,a,r)}case"ScatterNd":{const r=_v("indices",e,t,n),a=_v("values",e,t,n),i=_v("shape",e,t,n);return[s.scatterND(r,a,i)]}case"GatherNd":{const r=_v("x",e,t,n),a=_v("indices",e,t,n);return[s.gatherND(r,a)]}case"SparseToDense":{const r=_v("sparseIndices",e,t,n),a=_v("outputShape",e,t,n),i=_v("sparseValues",e,t,n),o=_v("defaultValue",e,t,n);return[s.sparseToDense(r,i,a,i.dtype===o.dtype?o:s.cast(o,i.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"sparse":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"SparseFillEmptyRows":{const{outputIndices:r,outputValues:a,emptyRowIndicator:i,reverseIndexMap:o}=s.sparse.sparseFillEmptyRows(_v("indices",e,t,n),_v("values",e,t,n),_v("denseShape",e,t,n),_v("defaultValue",e,t,n));return[r,a,i,o]}case"SparseReshape":{const{outputIndices:r,outputShape:a}=s.sparse.sparseReshape(_v("inputIndices",e,t,n),_v("inputShape",e,t,n),_v("newShape",e,t,n));return[r,a]}case"SparseSegmentMean":return[s.sparse.sparseSegmentMean(_v("data",e,t,n),_v("indices",e,t,n),_v("segmentIds",e,t,n))];case"SparseSegmentSum":return[s.sparse.sparseSegmentSum(_v("data",e,t,n),_v("indices",e,t,n),_v("segmentIds",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"spectral":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"FFT":return[s.fft(_v("x",e,t,n))];case"IFFT":return[s.ifft(_v("x",e,t,n))];case"RFFT":return[s.rfft(_v("x",e,t,n))];case"IRFFT":return[s.irfft(_v("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"string":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"StringNGrams":{const{nGrams:r,nGramsSplits:a}=s.string.stringNGrams(_v("data",e,t,n),_v("dataSplits",e,t,n),_v("separator",e,t,n),_v("nGramWidths",e,t,n),_v("leftPad",e,t,n),_v("rightPad",e,t,n),_v("padWidth",e,t,n),_v("preserveShortSequences",e,t,n));return[r,a]}case"StringSplit":{const{indices:r,values:a,shape:i}=s.string.stringSplit(_v("input",e,t,n),_v("delimiter",e,t,n),_v("skipEmpty",e,t,n));return[r,a,i]}case"StringToHashBucketFast":return[s.string.stringToHashBucketFast(_v("input",e,t,n),_v("numBuckets",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"transformation":return r((()=>((e,t,n,s=wk)=>{switch(e.op){case"Cast":return[s.cast(_v("x",e,t,n),_v("dtype",e,t,n))];case"ExpandDims":{const r=_v("axis",e,t,n);return[s.expandDims(_v("x",e,t,n),r)]}case"Squeeze":{const r=_v("axis",e,t,n);return[s.squeeze(_v("x",e,t,n),r)]}case"Reshape":return[s.reshape(_v("x",e,t,n),_v("shape",e,t,n))];case"MirrorPad":return[s.mirrorPad(_v("x",e,t,n),_v("padding",e,t,n),_v("mode",e,t,n))];case"PadV2":case"Pad":return[s.pad(_v("x",e,t,n),_v("padding",e,t,n),_v("constantValue",e,t,n))];case"SpaceToBatchND":{const r=_v("blockShape",e,t,n),a=_v("paddings",e,t,n);return[s.spaceToBatchND(_v("x",e,t,n),r,a)]}case"BatchToSpaceND":{const r=_v("blockShape",e,t,n),a=_v("crops",e,t,n);return[s.batchToSpaceND(_v("x",e,t,n),r,a)]}case"DepthToSpace":{const r=_v("blockSize",e,t,n),a=_v("dataFormat",e,t,n).toUpperCase();return[s.depthToSpace(_v("x",e,t,n),r,a)]}case"BroadcastTo":return[s.broadcastTo(_v("x",e,t,n),_v("shape",e,t,n))];case"BroadcastArgs":return[s.broadcastArgs(_v("s0",e,t,n),_v("s1",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n)));case"hash_table":return(async(e,t,n,s)=>{switch(e.op){case"HashTable":case"HashTableV2":{const r=_v("keyDType",e,t,n),a=_v("valueDType",e,t,n),i=new Ak(r,a);return s.addHashTable(e.name,i),[i.handle]}case"LookupTableImport":case"LookupTableImportV2":{const r=_v("tableHandle",e,t,n,s),a=_v("keys",e,t,n),i=_v("values",e,t,n),o=s.getHashTableById(r.id);return[await o.import(a,i)]}case"LookupTableFind":case"LookupTableFindV2":{const r=_v("tableHandle",e,t,n,s),a=_v("keys",e,t,n),i=_v("defaultValue",e,t,n),o=s.getHashTableById(r.id);return[await o.find(a,i)]}case"LookupTableSize":case"LookupTableSizeV2":{const r=_v("tableHandle",e,t,n,s);return[s.getHashTableById(r.id).tensorSize()]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,n,s);case"custom":const a=Rv(e.op);if(a&&a.customExecutor)return a.customExecutor(new xk(e,t,n));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,t,n);return H(a)?a.then((e=>[].concat(e))):[].concat(a)}class _k{constructor(e={},t={},n={},s={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=s,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map((e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`)).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function Fk(e,t,n,s){const r=new Set,a=[];let i=null,o=null;const l=new Set,u=Object.keys(e).map((e=>Mv(e)[0]));let c=[];null!=s&&(c=s.map((e=>Mv(e.name)[0])));const h=[...t];for(;h.length>0;){const e=h.pop();(Lk(e)||zk(e)||Pk(e))&&null==i&&(i=e,o=i.children.map((e=>e.name)).filter((e=>r.has(e)))),r.add(e.name),null==n[e.name]&&(-1===u.indexOf(e.name)&&-1===c.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach((e=>{l.has(e.name)||(l.add(e.name),h.push(e))})):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:r,missingInputs:a,dynamicNode:i,syncInputs:o}}const Dk=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],Ok=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],Mk=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2","LookupTableSize","LookupTableSizeV2"];function Lk(e){return Dk.indexOf(e.op)>=0}function zk(e){return Ok.indexOf(e.op)>=0}function Pk(e){return Mk.indexOf(e.op)>=0}class Bk{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this.intermediateTensors={},this.keepTensorForDebug=!1,this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach((t=>{this._functionExecutorMap[t]=new Bk(e.functions[t],this)}))}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map((t=>e[t].map((e=>e.id))));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get outputs(){return this._outputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get inputNodes(){return this._inputs.map((e=>e.signatureKey||e.name))}get outputNodes(){return this._outputs.map((e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t}))}get functions(){return Object.keys(this._functions).reduce(((e,t)=>(e[t]=this._functions[t].signature,e)),{})}getCompilationKey(e,t){const n=e.map((e=>e.name)).sort(),s=t.map((e=>e.name)).sort();return n.join(this.SEPERATOR)+"--"+s.join(this.SEPERATOR)}compile(e,t){const n=Fk(e,t,this.weightMap,this._initNodes),{missingInputs:s,dynamicNode:r,syncInputs:a}=n;if(null!=r)throw new Error(`This execution contains the node '${r.name}', which has the dynamic op '${r.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(s.length>0){const n=t.map((e=>e.name)),r=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${r}]. Missing the following inputs: [${s}]`)}return function(e,t,n){const{usedNodes:s,inputs:r}=n,a=[],i=Object.keys(r).map((e=>Mv(e)[0])).map((t=>e.nodes[t])),o=e.initNodes;i.forEach((e=>{s.has(e.name)&&a.push(e)})),e.weights.forEach((e=>{s.has(e.name)&&a.push(e)})),null!=o&&o.forEach((e=>{s.has(e.name)&&a.push(e)}));const l=new Set,u=[];for(;a.length>0;){const e=a.pop();l.add(e.name),t[e.name]||u.push(e),e.children.forEach((e=>{!l.has(e.name)&&s.has(e.name)&&e.inputs.every((e=>l.has(e.name)))&&a.push(e)}))}return u}(this.graph,this.weightMap,n)}execute(e,t){e=this.mapInputs(e);const n=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=n.map((e=>this.graph.nodes[Mv(e)[0]])),r=t.map((e=>Mv(e)[0]));let a=r.map((e=>this.graph.nodes[e]));this.resetIntermediateTensors(),0===a.length&&(a=this._outputs);const i=this.getCompilationKey(s,a);let o=this.compiledMap.get(i);null==o&&(o=this.compile(e,a),this.compiledMap.set(i,o));const l={},u={};return bi((()=>{const n=new _k(this.weightMap,l,u,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=Mv(t),a=[];a[r]=e[t],s[n]=a}));const a=this.getFrozenTensorIds(s),i={};for(let e=0;e<o.length;e++){const t=o[e];if(!s[t.name]){const e=Rk(t,s,n,this._resourceManager);if(H(e))throw new Error(`The execution of the op '${t.op}' returned a promise. Please use model.executeAsync() instead.`);s[t.name]=e,this.checkTensorForDisposal(t.name,t,s,n,a,r,i)}}return null==this.parent&&n.dispose(a),t.map((e=>Fv(e,s,n)))}))}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map((t=>e[t])).map((e=>e.map((e=>e.id)))));return new Set(t)}checkTensorForDisposal(e,t,n,s,r,a,i){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach((e=>{null!=e&&(i[e.id]=(i[e.id]||0)+t.children.length)})),t.inputs.forEach((e=>{if("control"!==e.category){const a=function(e,t,n){return t[Ov(e,n.currentContextId)]}(e.name,n,s);null!=a&&a.forEach((e=>{if(e&&!e.kept&&!r.has(e.id)){const n=i[e.id];if(1===n){if(this.keepTensorForDebug){const[n,r]=Dv(t.name,s);this.intermediateTensors[n]||(this.intermediateTensors[n]=[]),this.intermediateTensors[n][r]=e}else e.dispose();delete i[e.id]}else null!=n&&i[e.id]--}}))}})))}async executeAsync(e,t){return this._executeAsync(e,t)}disposeIntermediateTensors(){this.intermediateTensors&&(Object.keys(this.intermediateTensors).forEach((e=>this.intermediateTensors[e].forEach((e=>e.dispose())))),this.disposeTensorsMap())}disposeTensorsMap(){this.tensorsMap&&Object.keys(this.tensorsMap).forEach((e=>{this.tensorsMap[e].forEach((e=>{!e||e.kept||e.isDisposed||this.keepIds.has(e.id)||e.dispose()}))}))}getIntermediateTensors(){return this.tensorsMap}resetIntermediateTensors(){for(const e in this.intermediateTensors)this.intermediateTensors[e].forEach((e=>e.dispose())),delete this.intermediateTensors[e]}async _executeAsync(e,t,n=!1,s={},r={}){n||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t));try{this.keepTensorForDebug=X().getBool("KEEP_INTERMEDIATE_TENSORS")}catch(e){console.warn(e.message)}this.resetIntermediateTensors();const a=new _k(this.weightMap,s,r,this.functionExecutorMap);this.tensorsMap=await this.executeWithControlFlow(e,a,t,n);const i=t.map((e=>Fv(e,this.tensorsMap,a))),o=i.map((e=>e.id)),l=Object.keys(e).map((t=>e[t].id));return this.keepIds=new Set([...o,...l,...this.weightIds]),this.keepTensorForDebug||this.disposeTensorsMap(),null==this.parent&&a.dispose(this.keepIds),i}async executeFunctionAsync(e,t,n){const s=e.reduce(((e,t,n)=>(e[this.inputs[n].name]=t,e)),{});return this._executeAsync(s,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,s){const r=Object.keys(e),a=r.map((e=>this.graph.nodes[Mv(e)[0]])),i=n.map((e=>Mv(e)[0]));let o=i.map((e=>this.graph.nodes[e]));0===o.length&&(o=this._outputs);const{usedNodes:l,missingInputs:u,dynamicNode:c,syncInputs:h}=Fk(e,o,this.weightMap,this._initNodes),p=[...a,...this.graph.weights,...this._initNodes||[]].map((e=>({node:e,contexts:t.currentContext}))),d=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,s]=Mv(t),r=[];r[s]=e[t],d[n]=r}));const f={},m=this.getFrozenTensorIds(d),g={};for(;p.length>0;){const e=this.processStack(a,p,t,d,g,m,i,f,l);await Promise.all(e)}null!=c||s||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const y=o.filter((e=>!Lk(e)&&!Fv(e.name,d,t))).map((e=>e.name));if(y.length>0){let e="";throw null!=c&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${h}]`),new Error(`Cannot compute the outputs [${y}] from the provided inputs [${r}]. Consider providing the following inputs: [${u}]. ${e}`)}return d}processStack(e,t,n,s,r,a,i,o,l){const u=[];for(;t.length>0;){const e=t.pop();n.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&_v("isConstant",e.node,s,n)&&([c]=Dv(e.node.name,n)),null==s[e.node.name]){const h=Rk(e.node,s,n,this._resourceManager);c||([c]=Dv(e.node.name,n));const p=n.currentContext;H(h)?u.push(h.then((u=>(s[c]=u,n.currentContext=p,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l),u)))):(s[c]=h,this.checkTensorForDisposal(c,e.node,s,n,a,i,o),this.processChildNodes(e.node,t,n,s,r,l))}else this.processChildNodes(e.node,t,n,s,r,l)}return u}processChildNodes(e,t,n,s,r,a){e.children.forEach((e=>{const[i]=Dv(e.name,n);!r[i]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some((e=>!!Fv(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every((e=>!!Fv(e,s,n)))&&(r[i]=!0,t.push({contexts:n.currentContext,node:e})))}))}dispose(){Object.keys(this.weightMap).forEach((e=>this.weightMap[e].forEach((e=>e.dispose()))))}checkInputShapeAndType(e){Object.keys(e).forEach((t=>{const n=e[t],[s]=Mv(t),r=this.graph.nodes[s];if(r.attrParams.shape&&r.attrParams.shape.value){const e=r.attrParams.shape.value,t=e.length===n.shape.length&&n.shape.every(((t,n)=>-1===e[n]||e[n]===t));u(t,(()=>`The shape of dict['${r.name}'] provided in model.execute(dict) must be [${e}], but was [${n.shape}]`))}r.attrParams.dtype&&r.attrParams.dtype.value&&u(n.dtype===r.attrParams.dtype.value,(()=>`The dtype of dict['${r.name}'] provided in model.execute(dict) must be ${r.attrParams.dtype.value}, but was ${n.dtype}`))}))}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter((e=>{const[t]=Mv(e);return null==this.graph.nodes[t]}));if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map((e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e}),{})}checkOutputs(e){e.forEach((e=>{const[t]=Mv(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)}))}}class Wk{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class Vk{constructor(e,t={},n=pi){this.modelUrl=e,this.loadOptions=t,this.version="n/a",this.io=n,null==t&&(this.loadOptions={}),this.resourceManager=new Wk}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}get modelStructuredOutputKeys(){return this.structuredOutputKeys}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=this.io.browserHTTPRequest(e,this.loadOptions);else{const t=this.io.getLoadHandlers(e,this.loadOptions);if(0===t.length)t.push(this.io.browserHTTPRequest(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=this.handler.load();return H(e)?e.then((e=>this.loadSync(e))):this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n=this.artifacts.signature;if(null!=this.artifacts.userDefinedMetadata){const e=this.artifacts.userDefinedMetadata;null!=e.signature&&(n=e.signature),null!=e.structuredOutputKeys&&(this.structuredOutputKeys=e.structuredOutputKeys)}this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const s=this.io.decodeWeights(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new Bk(rk.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(s),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=rk.Instance.transformGraph(e.modelInitializer);this.initializer=new Bk(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=this.io.getSaveHandlers(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,t){const n=this.execute(e,this.outputNodes);if(this.structuredOutputKeys){const e={};return(n instanceof br?[n]:n).forEach(((t,n)=>e[this.structuredOutputKeys[n]]=t)),e}return n}normalizeInputs(e){if(!(e instanceof br||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce(((t,n,s)=>(t[n]=e[s],t)),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}getIntermediateTensors(){return this.executor.getIntermediateTensors()}disposeIntermediateTensors(){this.executor.disposeIntermediateTensors()}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce(((t,n)=>(t[n]=[e[n]],t)),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}const Uk="3.19.0";function Gk(e,t,n=new Map,s=new Set){if(null==e)return null;if("function"==typeof Blob&&e instanceof Blob)return e.slice();if(s.has(e))throw new Error("Circular references are not supported.");if(n.has(e))return n.get(e);const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep map function may not return both a value and recurse=true.");if(r.recurse){if(Xk(e)){const r=Array.isArray(e)?[]:{};s.add(e);for(const a in e){const i=Gk(e[a],t,n,s);r[a]=i}return s.delete(e),e.__proto__&&(r.__proto__=e.__proto__),r}throw new Error(`Can't recurse into non-iterable type: ${e}`)}return n.set(e,r.value),r.value}function Hk(e,t=qk){return jk(e,t)}function jk(e,t,n=new Set){const s=e[0];if(n.has(s))throw new Error("Circular references are not supported.");const r=t(e);if(r.recurse&&null!==r.value)throw new Error("A deep zip function may not return both a value and recurse=true.");if(r.recurse){if(Xk(s)){const r=Array.isArray(s)?[]:{};n.add(s);for(const a in s){const s=jk(e.map((e=>e[a])),t,n);r[a]=s}return n.delete(s),r}throw new Error(`Can't recurse into non-iterable type: ${s}`)}return r.value}function qk(e){return null===e?null:Xk(e[0])?{value:null,recurse:!0}:{value:e,recurse:!1}}async function Kk(e,t){const n=new Map;Gk(e,t,n);for(const e of Array.from(n.keys())){const t=n.get(e);if(H(t)){const s=await t;n.set(e,s)}}return Gk(e,t,n)}function Xk(e){let t=!1;if(X().get("IS_BROWSER"))t=e instanceof TextDecoder;else{const{StringDecoder:n}=require("string_decoder");t=e instanceof n}return null!=e&&!ArrayBuffer.isView(e)&&(Array.isArray(e)||"object"==typeof e&&!(e instanceof br)&&!(e instanceof Promise)&&!t)}function Yk(e){return function(e,t){return Gk(e,t)}(e,Zk)}function Zk(e){return e instanceof br?{value:e.clone(),recurse:!1}:Xk(e)?{value:null,recurse:!0}:{value:e,recurse:!1}}class Jk{constructor(e){if(this.capacity=e,this.begin=0,this.end=0,null==e)throw new RangeError("Can't create a ring buffer of unknown capacity.");if(e<1)throw new RangeError("Can't create ring buffer of capacity < 1.");this.data=new Array(e),this.doubledCapacity=2*e}wrap(e){for(;e<0;)e+=this.doubledCapacity;return e%this.doubledCapacity}get(e){if(e<0)throw new RangeError("Can't get item at a negative index.");return this.data[e%this.capacity]}set(e,t){if(e<0)throw new RangeError("Can't set item at a negative index.");this.data[e%this.capacity]=t}length(){let e=this.end-this.begin;return e<0&&(e=this.doubledCapacity+e),e}isFull(){return this.length()===this.capacity}isEmpty(){return 0===this.length()}push(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.set(this.end,e),this.end=this.wrap(this.end+1)}pushAll(e){for(const t of e)this.push(t)}pop(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");this.end=this.wrap(this.end-1);const e=this.get(this.end);return this.set(this.end,void 0),e}unshift(e){if(this.isFull())throw new RangeError("Ring buffer is full.");this.begin=this.wrap(this.begin-1),this.set(this.begin,e)}shift(){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const e=this.get(this.begin);return this.set(this.begin,void 0),this.begin=this.wrap(this.begin+1),e}shuffleExcise(e){if(this.isEmpty())throw new RangeError("Ring buffer is empty.");const t=this.wrap(this.begin+e),n=this.get(t);return this.set(t,this.pop()),n}}class Qk extends Jk{constructor(){super(Qk.INITIAL_CAPACITY)}isFull(){return!1}push(e){super.isFull()&&this.expand(),super.push(e)}unshift(e){super.isFull()&&this.expand(),super.unshift(e)}expand(){const e=2*this.capacity,t=new Array(e),n=this.length();for(let e=0;e<n;e++)t[e]=this.get(this.wrap(this.begin+e));this.data=t,this.capacity=e,this.doubledCapacity=2*this.capacity,this.begin=0,this.end=n}}function eN(e){return new rN(e)}function tN(e){return new aN(e)}function nN(e,t){return new gN(e,t)}Qk.INITIAL_CAPACITY=32;class sN{async toArray(){const e=[];let t=await this.next();for(;!t.done;)e.push(t.value),t=await this.next();return e}async toArrayForTest(){const e=this.prefetch(100),t=[];let n=await e.next();for(;!n.done;)t.push(n.value),n=await e.next();return t}async resolveFully(){let e=await this.next();for(;!e.done;)e=await this.next()}async resolveWhile(e){let t=await this.next(),n=e(t.value);for(;!t.done&&n;)t=await this.next(),n=e(t.value)}handleErrors(e){return new pN(this,e)}filter(e){return new cN(this,e)}map(e){return new hN(this,e)}mapAsync(e){return new dN(this,e)}serialMapAsync(e){return new dN(this,e).serial()}flatmap(e){return new mN(this,e)}async forEachAsync(e){return this.map(e).resolveFully()}async serialForEach(e){return this.serialMapAsync(e).resolveWhile((e=>!0===e))}rowMajorBatch(e,t=!0){return new uN(this,e,t)}columnMajorBatch(e,t=!0,n=qk){return this.rowMajorBatch(e,t).map((e=>Hk(e,n)))}concatenate(e,t){return new gN(eN([this,e]),t)}take(e){return e<0||null==e?this:new lN(this,e)}skip(e){return e<0||null==e?this:new oN(this,e)}prefetch(e){return new xN(this,e)}shuffle(e,t){return new wN(this,e,t)}serial(){return new iN(this)}}class rN extends sN{constructor(e){super(),this.items=e,this.trav=0}summary(){return`Array of ${this.items.length} items`}async next(){if(this.trav>=this.items.length)return{value:null,done:!0};const e=this.items[this.trav];return this.trav++,{value:Yk(e),done:!1}}}class aN extends sN{constructor(e){super(),this.nextFn=e}summary(){return"Function call"}async next(){try{return this.nextFn()}catch(e){throw e.message=`Error thrown while iterating through a dataset: ${e.message}`,e}}}class iN extends sN{constructor(e){super(),this.upstream=e,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Serial`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){return this.upstream.next()}}class oN extends sN{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Skip`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;this.count++<this.maxCount;){const e=await this.upstream.next();if(e.done)return e;xi(e.value)}return this.upstream.next()}}class lN extends sN{constructor(e,t){super(),this.upstream=e,this.maxCount=t,this.count=0}summary(){return`${this.upstream.summary()} -> Take`}async next(){return this.count++>=this.maxCount?{value:null,done:!0}:this.upstream.next()}}class uN extends sN{constructor(e,t,n=!0){super(),this.upstream=e,this.batchSize=t,this.enableSmallLastBatch=n,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> RowMajorBatch`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){const e=[];for(;e.length<this.batchSize;){const t=await this.upstream.next();if(t.done)return this.enableSmallLastBatch&&e.length>0?{value:e,done:!1}:{value:null,done:!0};e.push(t.value)}return{value:e,done:!1}}}class cN extends sN{constructor(e,t){super(),this.upstream=e,this.predicate=t,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> Filter`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;){const e=await this.upstream.next();if(e.done||this.predicate(e.value))return e;xi(e.value)}}}class hN extends sN{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Map`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=_r(e.value),n=this.transform(e.value),s=_r(n);for(const e of t)Rr(e,s)||e.dispose();return{value:n,done:!1}}}class pN extends sN{constructor(e,t){super(),this.upstream=e,this.handler=t,this.count=0,this.lastRead=Promise.resolve({value:null,done:!1})}summary(){return`${this.upstream.summary()} -> handleErrors`}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;;)try{return await this.upstream.next()}catch(e){if(!this.handler(e))return{value:null,done:!0}}}}class dN extends sN{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> AsyncMap`}async next(){const e=await this.upstream.next();if(e.done)return{value:null,done:!0};const t=_r(e.value),n=await this.transform(e.value),s=_r(n);for(const e of t)Rr(e,s)||e.dispose();return{value:n,done:!1}}}class fN extends sN{constructor(){super(),this.outputQueue=new Qk,this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}async serialNext(){for(;0===this.outputQueue.length();)if(!await this.pump())return{value:null,done:!0};return{value:this.outputQueue.shift(),done:!1}}}class mN extends fN{constructor(e,t){super(),this.upstream=e,this.transform=t}summary(){return`${this.upstream.summary()} -> Flatmap`}async pump(){const e=await this.upstream.next();if(e.done)return!1;const t=_r(e.value),n=this.transform(e.value),s=_r(n);this.outputQueue.pushAll(n);for(const e of t)Rr(e,s)||e.dispose();return!0}}class gN extends sN{constructor(e,t){super(),this.baseErrorHandler=t,this.lastRead=null,this.iterator=null,this.moreIterators=e}summary(){return"TODO: fill in upstream of chained summaries -> Chained"}async next(){return this.lastRead=this.readFromChain(this.lastRead),this.lastRead}async readFromChain(e){if(await e,null==this.iterator){const e=await this.moreIterators.next();if(e.done)return{value:null,done:!0};this.iterator=e.value,null!=this.baseErrorHandler&&(this.iterator=this.iterator.handleErrors(this.baseErrorHandler))}const t=await this.iterator.next();return t.done?(this.iterator=null,this.readFromChain(e)):t}}var yN;!function(e){e[e.FAIL=0]="FAIL",e[e.SHORTEST=1]="SHORTEST",e[e.LONGEST=2]="LONGEST"}(yN||(yN={}));class bN extends sN{constructor(e,t=yN.FAIL){super(),this.iterators=e,this.mismatchMode=t,this.count=0,this.currentPromise=null}summary(){return"{TODO: fill in upstream of zip summaries} -> Zip"}async nextState(e){await e;let t=0,n=0;const s=await Kk(this.iterators,(function(e){if(e instanceof sN){return{value:e.next().then((e=>(t++,e.done&&n++,e.value))),recurse:!1}}return{value:null,recurse:!0}}));if(t===n)return{value:null,done:!0};if(n>0)switch(this.mismatchMode){case yN.FAIL:throw new Error(`Zipped streams should have the same length. Mismatched at element ${this.count}.`);case yN.SHORTEST:return{value:null,done:!0};case yN.LONGEST:}return this.count++,{value:s,done:!1}}async next(){return this.currentPromise=this.nextState(this.currentPromise),this.currentPromise}}class xN extends sN{constructor(e,t){super(),this.upstream=e,this.bufferSize=t,this.buffer=new Jk(t)}summary(){return`${this.upstream.summary()} -> Prefetch`}refill(){for(;!this.buffer.isFull();){const e=this.upstream.next();this.buffer.push(e)}}next(){return this.refill(),this.buffer.shift()}}class wN extends xN{constructor(e,t,n){super(e,t),this.upstream=e,this.windowSize=t,this.upstreamExhausted=!1,this.random=Nc(n||tr().toString()),this.lastRead=Promise.resolve({value:null,done:!1})}async next(){return this.lastRead=this.lastRead.then((()=>this.serialNext())),this.lastRead}randomInt(e){return Math.floor(this.random()*e)}chooseIndex(){return this.randomInt(this.buffer.length())}async serialNext(){for(this.upstreamExhausted||this.refill();!this.buffer.isEmpty();){const e=this.chooseIndex(),t=await this.buffer.shuffleExcise(e);if(!t.done)return this.refill(),t;this.upstreamExhausted=!0}return{value:null,done:!0}}}class vN{constructor(){this.size=null}batch(e,t=!0){const n=this;let s;return u(e>0,(()=>`batchSize needs to be positive, but it is\n      ${e}`)),s=this.size===1/0||null==this.size?this.size:t?Math.ceil(this.size/e):Math.floor(this.size/e),kN((async()=>(await n.iterator()).columnMajorBatch(e,t,NN)),s)}concatenate(e){const t=this;let n;return n=this.size===1/0||e.size===1/0?1/0:null!=this.size&&null!=e.size?this.size+e.size:null,kN((async()=>(await t.iterator()).concatenate(await e.iterator())),n)}filter(e){const t=this;let n;return n=this.size===1/0?1/0:null,kN((async()=>(await t.iterator()).filter((t=>bi((()=>e(t)))))),n)}async forEachAsync(e){return(await this.iterator()).forEachAsync(e)}map(e){const t=this;return kN((async()=>(await t.iterator()).map((t=>bi((()=>e(t)))))),this.size)}mapAsync(e){const t=this;return kN((async()=>(await t.iterator()).mapAsync(e)),this.size)}prefetch(e){if(null==e)throw new RangeError("`Dataset.prefetch()` requires bufferSize to be specified.");const t=this;return kN((async()=>(await t.iterator()).prefetch(e)),this.size)}repeat(e){const t=this;let n;return n=null!=this.size&&e>0?this.size*e:0===e?0:null!=this.size&&(void 0===e||e<0)?1/0:null,kN((async()=>nN(tN((async()=>({value:await t.iterator(),done:!1}))).take(e))),n)}skip(e){const t=this;let n;return n=null!=this.size&&e>=0&&this.size>=e?this.size-e:null!=this.size&&(this.size<e||void 0===e||e<0)?0:null,kN((async()=>(await t.iterator()).skip(e)),n)}shuffle(e,t,n=!0){if(null==e||e<0)throw null==this.size?new RangeError("`Dataset.shuffle()` requires bufferSize to be specified."):new RangeError(`\`Dataset.shuffle()\` requires bufferSize to be specified.  If your data fits in main memory (for regular JS objects), and/or GPU memory (for \`tf.Tensor\`s), consider setting bufferSize to the dataset size (${this.size} elements)`);const s=this,r=Nc(t||tr().toString());return kN((async()=>{let t=r.int32();return n&&(t+=r.int32()),(await s.iterator()).shuffle(e,t.toString())}),this.size)}take(e){const t=this;let n;return n=null!=this.size&&this.size>e?e:null!=this.size&&this.size<=e?this.size:null,kN((async()=>(await t.iterator()).take(e)),n)}async toArray(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArray()}async toArrayForTest(){if(this.size===1/0)throw new Error("Can not convert infinite data stream to array.");return(await this.iterator()).toArrayForTest()}}function kN(e,t=null){return new class extends vN{constructor(){super(...arguments),this.size=t}async iterator(){return e()}}}function NN(e){if(null===e)return null;const t=e[0];if(null==(n=t)||null===(s=n)||"object"!=typeof s&&"function"!=typeof s||Array.isArray(n)||"object"==typeof n&&n instanceof br||$(n)){return{value:function(e){if(0===e.length)throw new Error("Can't make a batch of zero elements.");return e[0]instanceof br?ih(e):ta(e)}(e),recurse:!1}}var n,s;return{value:null,recurse:!0}}vN.MAX_BUFFER_SIZE=1e4;class IN extends vN{constructor(e){super(),this.input=e}async iterator(){return(await this.input.iterator()).decodeUTF8().split("\n").map((e=>(e.endsWith("\r")&&(e=e.slice(0,-1)),e)))}}const SN='"',TN=Symbol("out"),$N=Symbol("field"),CN=Symbol("quote"),EN=Symbol("quoteafterquote"),AN=Symbol("quoteinquote");class RN extends vN{constructor(e,t){super(),this.input=e,this.hasHeader=!0,this.fullColumnNames=null,this.columnNamesValidated=!1,this.columnConfigs=null,this.configuredColumnsOnly=!1,this.delimiter=",",this.delimWhitespace=!1,this.base=new IN(e),t||(t={}),this.hasHeader=!1!==t.hasHeader,this.fullColumnNames=t.columnNames,this.columnConfigs=t.columnConfigs,this.configuredColumnsOnly=t.configuredColumnsOnly,t.delimWhitespace?(u(null==t.delimiter,(()=>"Delimiter should not be provided when delimWhitespace is true.")),this.delimWhitespace=!0,this.delimiter=" "):this.delimiter=t.delimiter?t.delimiter:","}async columnNames(){return this.columnNamesValidated||await this.setColumnNames(),this.configuredColumnsOnly?Object.keys(this.columnConfigs):this.fullColumnNames}async setColumnNames(){const e=await this.maybeReadHeaderLine();if(!this.fullColumnNames&&!e)throw new Error("Column names must be provided if there is no header line.");this.fullColumnNames&&e&&u(e.length===this.fullColumnNames.length,(()=>"The length of provided columnNames ("+this.fullColumnNames.length.toString()+") does not match the length of the header line read from file ("+e.length.toString()+").")),this.fullColumnNames||(this.fullColumnNames=e);const t=this.fullColumnNames.reduce(((e,t)=>(e[t]=e[t]+1||1,e)),{}),n=Object.keys(t).filter((e=>t[e]>1));if(u(0===n.length,(()=>"Duplicate column names found: "+n.toString())),this.columnConfigs)for(const e of Object.keys(this.columnConfigs)){if(-1===this.fullColumnNames.indexOf(e))throw new Error('The key "'+e+'" provided in columnConfigs does not match any of the column names ('+this.fullColumnNames.toString()+").")}this.columnNamesValidated=!0}async maybeReadHeaderLine(){if(this.hasHeader){const e=await this.base.iterator(),t=await e.next();if(t.done)throw new Error("No data was found for CSV parsing.");const n=t.value;return this.parseRow(n,!1)}return null}async iterator(){this.columnNamesValidated||await this.setColumnNames();let e=await this.base.iterator();return this.hasHeader&&(e=e.skip(1)),e.map((e=>this.makeDataElement(e)))}makeDataElement(e){const t=this.parseRow(e),n={},s={};for(let r=0;r<this.fullColumnNames.length;r++){const a=this.fullColumnNames[r],i=this.columnConfigs?this.columnConfigs[a]:null;if(!this.configuredColumnsOnly||i){const o=t[r];let l=null;if(""===o)if(i&&void 0!==i.default)l=i.default;else{if(i&&(i.required||i.isLabel))throw new Error(`Required column ${a} is empty in this line: ${e}`);l=void 0}else{const e=Number(o);if(isNaN(e))l=i&&"bool"===i.dtype?this.getBoolean(o):o;else if(i&&i.dtype)switch(i.dtype){case"float32":default:l=e;break;case"int32":l=Math.floor(e);break;case"bool":l=this.getBoolean(o)}else l=e}i&&i.isLabel?s[a]=l:n[a]=l}}return 0===Object.keys(s).length?n:{xs:n,ys:s}}getBoolean(e){return"1"===e||"true"===e.toLowerCase()?1:0}parseRow(e,t=!0){const n=[];let s=0;const r=e.length;let a=TN;for(let t=0;t<r;t++)switch(a){case TN:switch(e.charAt(t)){case SN:s=t+1,a=CN;break;case this.delimiter:if(s=t+1," "===this.delimiter&&this.delimWhitespace)break;n.push(""),a=TN;break;default:a=$N,s=t}break;case $N:if(e.charAt(t)===this.delimiter)n.push(e.substring(s,t)),a=TN,s=t+1;break;case CN:if(e.charAt(t)===SN)a=EN;break;case EN:switch(e.charAt(t)){case this.delimiter:n.push(e.substring(s,t-1)),a=TN,s=t+1;break;case SN:a=CN;break;default:a=AN}break;case AN:if(e.charAt(t)===SN)a=CN}if(a===EN?n.push(e.substring(s,r-1)):n.push(e.substring(s)),t&&n.length!==this.fullColumnNames.length)throw new Error(`Invalid row in csv file. Should have ${this.fullColumnNames.length} elements in a row, but got ${n}`);return n}}class _N extends sN{constructor(e){super(),this.microphoneConfig=e,this.isClosed=!1,this.fftSize=e.fftSize||1024;const t=Math.log2(this.fftSize);if(this.fftSize<0||t<4||t>14||!Number.isInteger(t))throw new Error(`Invalid fftSize: it must be a power of 2 between 2 to 4 and 2 to 14, but got ${this.fftSize}`);if(this.numFrames=e.numFramesPerSpectrogram||43,this.sampleRateHz=e.sampleRateHz,this.columnTruncateLength=e.columnTruncateLength||this.fftSize,this.audioTrackConstraints=e.audioTrackConstraints,this.smoothingTimeConstant=e.smoothingTimeConstant||0,this.includeSpectrogram=!1!==e.includeSpectrogram,this.includeWaveform=!0===e.includeWaveform,!this.includeSpectrogram&&!this.includeWaveform)throw new Error("Both includeSpectrogram and includeWaveform are false. At least one type of data should be returned.")}summary(){return"microphone"}static async create(e={}){if(!X().get("IS_BROWSER"))throw new Error("microphone API is only supported in browser environment.");const t=new _N(e);return await t.start(),t}async start(){try{this.stream=await navigator.mediaDevices.getUserMedia({audio:null==this.audioTrackConstraints||this.audioTrackConstraints,video:!1})}catch(e){throw new Error(`Error thrown while initializing video stream: ${e.message}`)}if(!this.stream)throw new Error("Could not obtain audio from microphone.");const e=window.AudioContext||window.webkitAudioContext;if(this.audioContext=new e,this.sampleRateHz){if(this.audioContext.sampleRate!==this.sampleRateHz)throw new Error(`Mismatch in sampling rate: Expected: ${this.sampleRateHz}; Actual: ${this.audioContext.sampleRate}`)}else this.sampleRateHz=this.audioContext.sampleRate;const t=this.audioContext.createMediaStreamSource(this.stream);this.analyser=this.audioContext.createAnalyser(),this.analyser.fftSize=2*this.fftSize,this.analyser.smoothingTimeConstant=this.smoothingTimeConstant,t.connect(this.analyser),this.freqData=new Float32Array(this.fftSize),this.timeData=new Float32Array(this.fftSize)}async next(){if(this.isClosed)return{value:null,done:!0};let e,t;const n=await this.getAudioData();if(this.includeSpectrogram){const t=this.flattenQueue(n.freqDataQueue);e=this.getTensorFromAudioDataArray(t,[this.numFrames,this.columnTruncateLength,1])}if(this.includeWaveform){const e=this.flattenQueue(n.timeDataQueue);t=this.getTensorFromAudioDataArray(e,[this.numFrames*this.fftSize,1])}return{value:{spectrogram:e,waveform:t},done:!1}}async capture(){return(await this.next()).value}async getAudioData(){const e=[],t=[];let n=0;return new Promise((s=>{const r=setInterval((()=>{this.includeSpectrogram&&(this.analyser.getFloatFrequencyData(this.freqData),this.freqData[0]===-1/0&&s({freqDataQueue:e,timeDataQueue:t}),e.push(this.freqData.slice(0,this.columnTruncateLength))),this.includeWaveform&&(this.analyser.getFloatTimeDomainData(this.timeData),t.push(this.timeData.slice())),++n===this.numFrames&&(clearInterval(r),s({freqDataQueue:e,timeDataQueue:t}))}),this.fftSize/this.sampleRateHz*1e3)}))}stop(){this.isClosed||(this.isClosed=!0,this.analyser.disconnect(),this.audioContext.close(),null!=this.stream&&this.stream.getTracks().length>0&&this.stream.getTracks()[0].stop())}toArray(){throw new Error("Can not convert infinite audio stream to array.")}getSampleRate(){return this.sampleRateHz}flattenQueue(e){const t=e[0].length,n=new Float32Array(e.length*t);return e.forEach(((e,s)=>n.set(e,s*t))),n}getTensorFromAudioDataArray(e,t){const n=new Float32Array(d(t));return n.set(e,n.length-e.length),ta(n,t)}}class FN extends sN{constructor(e,t){if(super(),this.webcamVideoElement=e,this.webcamConfig=t,this.isClosed=!0,this.resize=!1,this.needToResize())if(this.resize=!0,this.cropSize=[this.webcamConfig.resizeHeight,this.webcamConfig.resizeWidth],this.cropBoxInd=ch([0],"int32"),this.webcamConfig.centerCrop){const e=1*this.webcamConfig.resizeWidth/this.webcamVideoElement.width,t=1*this.webcamConfig.resizeHeight/this.webcamVideoElement.height,n=(1-e)/2,s=(1-t)/2,r=n+e,a=t+s;this.cropBox=hh([s,n,a,r],[1,4])}else this.cropBox=hh([0,0,1,1],[1,4])}summary(){return"webcam"}static async create(e,t={}){if(!X().get("IS_BROWSER"))throw new Error("tf.data.webcam is only supported in browser environment.");if(!e){if(e=document.createElement("video"),!t.resizeWidth||!t.resizeHeight)throw new Error("Please provide webcam video element, or resizeWidth and resizeHeight to create a hidden video element.");e.width=t.resizeWidth,e.height=t.resizeHeight}const n=new FN(e,t);return await n.start(),n}async start(){this.webcamConfig.facingMode&&u("user"===this.webcamConfig.facingMode||"environment"===this.webcamConfig.facingMode,(()=>`Invalid webcam facing mode: ${this.webcamConfig.facingMode}. Please provide 'user' or 'environment'`));try{this.stream=await navigator.mediaDevices.getUserMedia({video:{deviceId:this.webcamConfig.deviceId,facingMode:this.webcamConfig.facingMode?this.webcamConfig.facingMode:"user",width:this.webcamVideoElement.width,height:this.webcamVideoElement.height}})}catch(e){throw e.message=`Error thrown while initializing video stream: ${e.message}`,e}if(!this.stream)throw new Error("Could not obtain video from webcam.");try{this.webcamVideoElement.srcObject=this.stream}catch(e){console.log(e),this.webcamVideoElement.src=window.URL.createObjectURL(this.stream)}return this.webcamVideoElement.play(),this.isClosed=!1,new Promise((e=>{this.webcamVideoElement.onloadedmetadata=()=>{e()}}))}async next(){if(this.isClosed)return{value:null,done:!0};let e;try{e=zi(this.webcamVideoElement)}catch(e){throw new Error(`Error thrown converting video to pixels: ${JSON.stringify(e)}`)}if(!this.resize)return{value:e,done:!1};try{return{value:this.cropAndResizeFrame(e),done:!1}}catch(e){throw new Error(`Error thrown cropping the video: ${e.message}`)}finally{e.dispose()}}needToResize(){return!(!this.webcamConfig.resizeWidth||!this.webcamConfig.resizeHeight||this.webcamVideoElement.width===this.webcamConfig.resizeWidth&&this.webcamVideoElement.height===this.webcamConfig.resizeHeight)}cropAndResizeFrame(e){return bi((()=>{const t=ou(qa(e,"float32"),0);let n;n=Wp.cropAndResize(t,this.cropBox,this.cropBoxInd,this.cropSize,"bilinear");const s=n.shape;return Yo(n,s.slice(1))}))}async capture(){return(await this.next()).value}stop(){this.stream.getTracks().forEach((e=>e.stop()));try{this.webcamVideoElement.srcObject=null}catch(e){console.log(e),this.webcamVideoElement.src=null}this.isClosed=!0}toArray(){throw new Error("Can not convert infinite video stream to array.")}}class DN{}class ON extends sN{split(e){return new MN(this,e)}}class MN extends ON{constructor(e,t){super(),this.upstream=e,this.impl=new LN(e,t)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class LN extends fN{constructor(e,t){super(),this.upstream=e,this.separator=t,this.carryover=""}summary(){return`${this.upstream.summary()} -> Split('${this.separator}')`}async pump(){const e=await this.upstream.next();if(e.done)return""!==this.carryover&&(this.outputQueue.push(this.carryover),this.carryover="",!0);const t=e.value.split(this.separator);t[0]=this.carryover+t[0];for(const e of t.slice(0,-1))this.outputQueue.push(e);return this.carryover=t[t.length-1],!0}}class zN extends sN{decodeUTF8(){return new PN(this)}}class PN extends ON{constructor(e){super(),this.upstream=e,this.impl=new BN(e)}summary(){return this.impl.summary()}async next(){return this.impl.next()}}class BN extends fN{constructor(e){if(super(),this.upstream=e,X().get("IS_BROWSER"))this.decoder=new TextDecoder("utf-8");else{const{StringDecoder:e}=require("string_decoder");this.decoder=new e("utf8")}}summary(){return`${this.upstream.summary()} -> Utf8`}async pump(){const e=await this.upstream.next();let t,n;return!e.done&&(t=e.value,n=X().get("IS_BROWSER")?this.decoder.decode(t,{stream:!0}):this.decoder.write(Buffer.from(t.buffer)),this.outputQueue.push(n),!0)}}class WN extends zN{constructor(e,t={}){super(),this.file=e,this.options=t,u(e instanceof Uint8Array||!!X().get("IS_BROWSER")&&(e instanceof File||e instanceof Blob),(()=>"FileChunkIterator only supports File, Blob and Uint8Array right now.")),this.offset=t.offset||0,this.chunkSize=t.chunkSize||1048576}summary(){return`FileChunks ${this.file}`}async next(){if(this.offset>=(this.file instanceof Uint8Array?this.file.byteLength:this.file.size))return{value:null,done:!0};const e=new Promise(((e,t)=>{const n=this.offset+this.chunkSize;if(this.file instanceof Uint8Array)e(new Uint8Array(this.file.slice(this.offset,n)));else{const s=new FileReader;s.onload=n=>{let r=s.result;if(r instanceof ArrayBuffer&&(r=new Uint8Array(r)),!(r instanceof Uint8Array))return t(new TypeError("FileReader returned unknown type."));e(r)},s.onabort=e=>t(new Error("Aborted")),s.onerror=e=>t(new Error(e.type));const r=this.file.slice(this.offset,n);s.readAsArrayBuffer(r)}this.offset=n}));return{value:await e,done:!1}}}const VN=e=>({method:e.method,headers:e.headers,body:e.body,mode:e.mode,credentials:e.credentials,cache:e.cache,redirect:e.redirect,referrer:e.referrer,integrity:e.integrity});function UN(e){return"string"==typeof e&&"file://"===e.slice(0,7)}class GN extends DN{constructor(e,t={}){super(),this.input=e,this.options=t}async iterator(){if(UN(this.input)&&X().get("IS_NODE")){const e=require("fs");this.input=e.readFileSync(this.input.slice(7))}return new WN(this.input,this.options)}}class HN extends DN{constructor(e,t={}){super(),this.url=e,this.fileOptions=t}async iterator(){return UN(this.url)?new GN(this.url,this.fileOptions).iterator():async function(e,t={},n){let s,r;"string"==typeof e?s=e:(s=e.url,r=VN(e));const a=await(n||nr)(s,r);if(a.ok){const e=new Uint8Array(await a.arrayBuffer());return new WN(e,t)}throw new Error(a.statusText)}(this.url,this.fileOptions)}}const jN="3.19.0";var qN=Object.freeze({__proto__:null,array:function(e){return kN((async()=>eN(e)),e.length)},Dataset:vN,zip:function(e){if(!Xk(e))throw new Error("The argument to zip() must be an object or array.");let t;if(Array.isArray(e))for(let n=0;n<e.length;n++)t=null==t?e[n].size:Math.min(t,e[n].size);else if(e instanceof Object)for(const n in e)t=null==t?e[n].size:Math.min(t,e[n].size);return kN((async()=>function(e,t=yN.FAIL){return new bN(e,t)}(await Kk(e,(e=>{if(e instanceof vN)return{value:e.iterator(),recurse:!1};if(Xk(e))return{value:null,recurse:!0};throw new Error("Leaves of the structure passed to zip() must be Datasets, not primitives.")})),yN.SHORTEST)),t)},CSVDataset:RN,TextLineDataset:IN,csv:function(e,t={}){return new RN(new HN(e),t)},func:function(e){const t=tN(e);return kN((async()=>t))},generator:function(e){return kN((async()=>{const t=await e();return tN((()=>t.next()))}))},microphone:async function(e){return _N.create(e)},webcam:async function(e,t){return FN.create(e,t)},FileDataSource:GN,URLDataSource:HN,version_data:jN});function KN(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&u("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the CPU backend.`))}))}const XN=kh;class YN extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t(this,gi())}nextDataId(){return YN.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,X().get("IS_NODE")&&is("\n============================\nHi, looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, visit https://github.com/tensorflow/tfjs-node for more details. \n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:n,refCount:1}),s}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&A(n[0])){const r=n.map((e=>sr(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return{dataId:s,shape:e,dtype:t}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,s,r){this.data.set(e,{values:t,dtype:s,refCount:r})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){return vd(this.readSync(n.real.dataId),this.readSync(n.imag.dataId))}return this.data.get(e).values}bufferSync(e){const t=this.readSync(e.dataId);if("string"===e.dtype)try{const n=t.map((e=>rr(e)));return ja(e.shape,e.dtype,n)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return ja(e.shape,e.dtype,t)}makeOutput(e,t,n){return gi().makeTensorFromTensorInfo(this.makeTensorInfo(t,n,e),this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const t=tr();e();return{kernelMs:tr()-t}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){KN([e],"where");const t=this.readSync(e.dataId);return XN(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function ZN(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}YN.nextDataId=0;const JN={kernelName:Q,backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend;KN(t,"abs");let s=new Float32Array(d(t.shape));return s=ZN(n.data.get(t.dataId).values),n.makeOutput(s,t.shape,t.dtype)}};function QN(e){return(t,n,s,r,a)=>{const i=_i(t,n),o=i.length,l=M(i),u=k(a,d(i)),c=t.length,h=n.length,p=M(t),f=M(n),m=Ai(t,i),g=Ai(n,i);if(m.length+g.length===0)for(let t=0;t<u.length;++t)u[t]=e(s[t%s.length],r[t%r.length]);else for(let t=0;t<u.length;++t){const n=G(t,o,l),a=n.slice(-c);m.forEach((e=>a[e]=0));const i=U(a,c,p),d=n.slice(-h);g.forEach((e=>d[e]=0));const y=U(d,h,f);u[t]=e(s[i],r[y])}return[u,i]}}function eI(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=n.makeTensorInfo(s.shape,"complex64");return n.data.get(o.dataId).complexTensorInfos={real:n.makeTensorInfo(s.shape,"float32",a),imag:n.makeTensorInfo(r.shape,"float32",i)},o}const tI={kernelName:Se,backendName:"cpu",kernelFunc:eI};function nI(e,t,n="float32"){if("complex64"===n){return eI({inputs:{real:nI(e,t,"float32"),imag:nI(e,t,"float32")},backend:e})}const s=B(d(t),n);return e.makeTensorInfo(t,n,s)}function sI(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const rI={kernelName:dt,backendName:"cpu",kernelFunc:sI};function aI(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.real,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const iI={kernelName:rn,backendName:"cpu",kernelFunc:aI};function oI(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dtype:a}=s;if("complex64"===a){if("complex64"===r.dtype)return sI({inputs:{x:r},backend:n});const e=nI(n,r.shape,r.dtype),t=oI({inputs:{x:r},backend:n,attrs:{dtype:"float32"}}),s=eI({inputs:{real:t,imag:e},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),s}if("complex64"===r.dtype){const e=aI({inputs:{input:r},backend:n}),t=oI({inputs:{x:e},backend:n,attrs:{dtype:a}});return n.disposeIntermediateTensorInfo(e),t}if(!T(r.dtype,a)){const e=sI({inputs:{x:r},backend:n});return{dataId:e.dataId,shape:e.shape,dtype:a}}if("int32"===a){const e=n.data.get(r.dataId).values,t=Int32Array.from(e);return n.makeTensorInfo(r.shape,"int32",t)}if("bool"===a){const e=n.data.get(r.dataId).values,t=er([0],r.dtype),[s,a]=QN(((e,t)=>e!==t?1:0))(r.shape,[],e,t,"bool");return n.makeTensorInfo(a,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${a}`)}const lI={kernelName:ke,backendName:"cpu",kernelFunc:oI};function uI(e,t,n,s){return null==n?({inputs:n,backend:r})=>{const{a:a,b:i}=n,o=r;KN([a,i],e);const l=o.data.get(a.dataId).values,u=o.data.get(i.dataId).values,c="string"===a.dtype?ef(l):l,h="string"===a.dtype?ef(u):u,p=s||a.dtype,[d,f]=t(a.shape,i.shape,c,h,p);return o.makeTensorInfo(f,p,d)}:({inputs:e,backend:r})=>{const{a:a,b:i}=e,o=r;if("complex64"===a.dtype||"complex64"===i.dtype){const e=oI({inputs:{x:a},backend:o,attrs:{dtype:"complex64"}}),t=o.data.get(e.dataId),s=t.complexTensorInfos.real,r=t.complexTensorInfos.imag,l=o.data.get(s.dataId).values,u=o.data.get(r.dataId).values,c=oI({inputs:{x:i},backend:o,attrs:{dtype:"complex64"}}),h=o.data.get(c.dataId),p=h.complexTensorInfos.real,d=h.complexTensorInfos.imag,f=o.data.get(p.dataId).values,m=o.data.get(d.dataId).values,[g,y,b]=n(a.shape,i.shape,l,u,f,m),x=o.makeTensorInfo(b,"float32",g),w=o.makeTensorInfo(b,"float32",y),v=eI({inputs:{real:x,imag:w},backend:o});return o.disposeIntermediateTensorInfo(e),o.disposeIntermediateTensorInfo(c),o.disposeIntermediateTensorInfo(x),o.disposeIntermediateTensorInfo(w),v}{const e=o.data.get(a.dataId).values,n=o.data.get(i.dataId).values,r=s||a.dtype,[l,u]=t(a.shape,i.shape,e,n,r);return o.makeTensorInfo(u,r,l)}}}function cI(e){return(t,n,s,r,a,i)=>{const o=_i(t,n),l=d(o),u=o.length,c=M(o),h=k("float32",l),p=k("float32",l),f=Ai(t,o),m=Ai(n,o),g=vd(s,r),y=vd(a,i),b=t.length,x=M(t),w=n.length,v=M(n);if(f.length+m.length===0)for(let t=0;t<h.length;t++){const n=t%g.length,s=t%y.length,r=e(g[2*n],g[2*n+1],y[2*s],y[2*s+1]);h[t]=r.real,p[t]=r.imag}else for(let t=0;t<h.length;t++){const n=G(t,u,c),s=n.slice(-b);f.forEach((e=>s[e]=0));const r=U(s,b,x),a=n.slice(-w);m.forEach((e=>a[e]=0));const i=U(a,w,v),o=e(g[2*r],g[2*r+1],y[2*i],y[2*i+1]);h[t]=o.real,p[t]=o.imag}return[h,p,o]}}const hI=QN(((e,t)=>e+t)),pI=cI(((e,t,n,s)=>({real:e+n,imag:t+s}))),dI=uI(ne,hI,pI),fI={kernelName:ne,backendName:"cpu",kernelFunc:dI};function mI(e,t,n,s,r){const a=d(s),i=B(r,n);for(let n=0;n<e.length;n++){const s=e[n];if(s<0)throw new Error("Input x must be non-negative!");s>=r||(i[s]+=a>0?t[n]:1)}return i}function gI(e,t,n,s=!1){const r=e.shape[0],a=e.shape[1],i=ja([r,n],t.dtype);for(let o=0;o<r;o++)for(let r=0;r<a;r++){const a=e.get(o,r);if(a<0)throw new Error("Input x must be non-negative!");a>=n||(s?i.set(1,o,a):t.size>0?i.set(i.get(o,a)+t.get(o,r),o,a):i.set(i.get(o,a)+1,o,a))}return i}function yI(e){return(t,n,s)=>{const r=k(n,t.length);for(let n=0;n<t.length;++n)r[n]=e(t[n],s);return r}}function bI(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(KN(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=d(i.shape),c=n||i.dtype,h=N(c,u);for(let e=0;e<u;++e)h[e]=t(l[e],r);return o.makeTensorInfo(i.shape,c,h)}}function xI(e,t,n){return({inputs:s,attrs:r,backend:a})=>{const{x:i}=s;if(KN(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const o=a,l=o.data.get(i.dataId).values,u=n||i.dtype,c=t(l,u,r);return o.makeTensorInfo(i.shape,u,c)}}const wI=yI((e=>Math.ceil(e))),vI=xI(Ne,wI),kI={kernelName:Ne,backendName:"cpu",kernelFunc:vI};function NI(e,t,n,s){const r=N(n,d(t));if(s&&"string"!==n){let t=0;e.forEach((e=>{const n=d(e.shape);r.set(e.vals,t),t+=n}))}else{let s=0;e.forEach((e=>{const a="string"===n?ef(e.vals):e.vals;let i=0;for(let n=0;n<e.shape[0];++n){const o=n*t[1]+s;for(let t=0;t<e.shape[1];++t)r[o+t]=a[i++]}s+=e.shape[1]}))}return r}const II=QN(((e,t)=>e===t?1:0)),SI=uI(Qe,II,null,"bool"),TI={kernelName:Qe,backendName:"cpu",kernelFunc:SI},$I=yI((e=>Math.exp(e))),CI=xI(et,$I,"float32"),EI={kernelName:et,backendName:"cpu",kernelFunc:CI},AI=yI((e=>Math.expm1(e))),RI=xI(nt,AI),_I={kernelName:nt,backendName:"cpu",kernelFunc:RI},FI=yI((e=>Math.floor(e))),DI=xI(it,FI),OI={kernelName:it,backendName:"cpu",kernelFunc:DI};function MI(e,t,n,s,r,a,i,o,l){const u=ja([s,a],n);for(let n=0;n<s;n++){const s=[];let c=0;for(let t=0;t<r;t++){const a=e[n*r+t];c+=a*i[t],s.push(a)}if(c<0||c>=l/a)throw new Error(`Invalid indices: ${s} does not index into ${o}`);for(let e=0;e<a;e++)u.values[n*a+e]=t.get(...t.indexToLoc(c*a+e))}return u}function LI(e,t,n){const s=ja(n,e.dtype);for(let n=0;n<s.size;++n){const r=s.indexToLoc(n).slice(),a=r[0],i=r[2],o=t.locToIndex([a,i]);r[2]=t.values[o];const l=e.locToIndex(r);0<=l&&l<e.values.length&&(s.values[n]=e.values[l])}return s}const zI=QN(((e,t)=>e>t?1:0)),PI=uI(ht,zI,null,"bool"),BI={kernelName:ht,backendName:"cpu",kernelFunc:PI},WI=QN(((e,t)=>e>=t?1:0)),VI=uI(pt,WI,null,"bool"),UI={kernelName:pt,backendName:"cpu",kernelFunc:VI},GI=QN(((e,t)=>e<t?1:0)),HI=uI(wt,GI,null,"bool"),jI={kernelName:wt,backendName:"cpu",kernelFunc:HI},qI=QN(((e,t)=>e<=t?1:0)),KI=uI(vt,qI,null,"bool"),XI={kernelName:vt,backendName:"cpu",kernelFunc:KI};function YI(e,t,n){const s=(t-e)/(n-1),r=B(n,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const ZI=yI((e=>Math.log(e))),JI=xI(Nt,ZI),QI={kernelName:Nt,backendName:"cpu",kernelFunc:JI};function eS(e,t,n,s){const r=k(s,d(n));for(let n=0;n<r.length;++n){const s=n*t;let a=e[s];for(let n=0;n<t;++n){const t=e[s+n];(Number.isNaN(t)||t>a)&&(a=t)}r[n]=a}return r}const tS=QN(((e,t)=>Math.max(e,t))),nS=uI(_t,tS),sS={kernelName:_t,backendName:"cpu",kernelFunc:nS},rS=QN(((e,t)=>Math.min(e,t))),aS=uI(Bt,rS),iS={kernelName:Bt,backendName:"cpu",kernelFunc:aS},oS=QN(((e,t)=>e*t)),lS=cI(((e,t,n,s)=>({real:e*n-t*s,imag:e*s+t*n}))),uS=uI(Gt,oS,lS),cS={kernelName:Gt,backendName:"cpu",kernelFunc:uS};function hS(e,t,n){const s=Qs(-1,n);return oS([],t,s,e,n)}const pS={kernelName:Ht,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;KN(s,"neg");const r=n.data.get(s.dataId).values,[a,i]=hS(r,s.shape,s.dtype);return n.makeTensorInfo(i,s.dtype,a)}},dS=QN(((e,t)=>e!==t?1:0)),fS=uI(jt,dS,null,"bool"),mS={kernelName:jt,backendName:"cpu",kernelFunc:fS};function gS(e,t,n,s,r){const a=t.length,i=d(t),o=M(t),l=M(r),u=k(n,d(r));for(let t=0;t<i;++t){const n=G(t,a,o),r=new Array(n.length);for(let e=0;e<r.length;e++)r[e]=n[s[e]];u[U(r,a,l)]=e[t]}return u}function yS(e){const{inputs:t,attrs:n,backend:s}=e,{x:r}=t,{perm:a}=n;KN(r,"transpose");const i=r.shape.length,o=new Array(i);for(let e=0;e<o.length;e++)o[e]=r.shape[a[e]];const l=gS(s.data.get(r.dataId).values,r.shape,r.dtype,a,o);return{dataId:s.write(l,o,r.dtype),shape:o,dtype:r.dtype}}const bS={kernelName:Xn,backendName:"cpu",kernelFunc:yS};function xS(e,t,n,s){const[r,a]=Gl(e,s),i=$r(t,"int32"),o=B(d(r),i),l=d(a);for(let e=0;e<o.length;++e){const t=e*l;let s=1;for(let e=0;e<l;++e)s*=n[t+e];o[e]=s}return{outVals:o,outShape:r,outDtype:i}}const wS={kernelName:nn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;KN(r,"prod");const o=r.shape.length,l=w(a,r.shape),u=ql(l,o);let c=l,h=r;const p=[];null!=u&&(h=yS({inputs:{x:r},backend:n,attrs:{perm:u}}),p.push(h),c=Xl(c.length,o));const d=n.data.get(h.dataId).values,{outVals:f,outShape:m,outDtype:g}=xS(h.shape,h.dtype,d,c);let y=m;return i&&(y=Hl(m,l)),p.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(y,g,f)}};function vS(e,t,n,s){if(e===t||e<t&&n<0||t<e&&n>1)return B(0,s);const r=B(Math.abs(Math.ceil((t-e)/n)),s);t<e&&1===n&&(n=-1),r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+n;return r}const kS=yI((e=>1/Math.sqrt(e))),NS=xI(gn,kS),IS={kernelName:gn,backendName:"cpu",kernelFunc:NS};function SS(e,t,n,s,r,a,i,o,l,u){const c=[s/r,r],h=e.values,p=t.values;if(0===s)return ja(n,t.dtype);const d=ja(c,t.dtype);"string"==typeof l||"number"==typeof l?d.values.fill(l):"boolean"==typeof l&&d.values.fill(+l);for(let e=0;e<a;e++){const a=[];let l=0;for(let t=0;t<i;t++){const n=h[e*i+t];a.push(n),l+=n*o[t]}if(l<0||l>=s/r)throw new Error(`Invalid indices: ${a} does not index into ${n}`);for(let n=0;n<r;n++)u?d.values[l*r+n]+=p[e*r+n]:d.values[l*r+n]=0===t.rank?p[0]:p[e*r+n]}return d}const TS=yI((e=>1/(1+Math.exp(-e)))),$S=bI(Sn,(e=>1/(1+Math.exp(-e)))),CS={kernelName:Sn,backendName:"cpu",kernelFunc:$S};function ES(e,t,n,s,r){const a=no(s,t,n),i=d(n),o=M(s);if(a){const n=so(t,o);return"string"===r?e.slice(n,n+i):e.subarray(n,n+i)}const l=ja(s,r,"string"===r?ef(e):e),u=ja(n,r);for(let e=0;e<u.size;++e){const n=u.indexToLoc(e),s=n.map(((e,n)=>e+t[n]));u.set(l.get(...s),...n)}return"string"===r?tf(u.values):u.values}function AS(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s;KN(r,"slice");const[o,l]=ro(r,a,i);ji(r,o,l);const u=ES(n.data.get(r.dataId).values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,u)}const RS={kernelName:vn,backendName:"cpu",kernelFunc:AS};function _S(e,t,n,s,r,a,i){const o=t[0],l=a[0],u=new Array(l),c=new Array(o),h=t[1];if(0===l){if(0!==o)throw new Error(zd(o));return[N(n,0),[0,h],N(r,0),u,c]}let p=!0,d=0;const f=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h];if(n<0)throw new Error(Pd(t,n));if(n>=l)throw new Error(Bd(t,n,l));++f[n],p=p&&n>=d,d=n}let m=!0;for(let e=0;e<l;++e){const t=0===f[e];u[e]=t,m=m&&!t,f[e]=Math.max(f[e],1),e>0&&(f[e]+=f[e-1])}if(m&&p){const t=e,n=s;for(let e=0;e<o;++e)c[e]=e;return[t,[o,h],n,u,c]}{const t=f[l-1],a=N(n,t*h),p=N(r,t),d=new Array(l).fill(0);for(let t=0;t<o;++t){const n=e[t*h],r=d[n],i=(0===n?0:f[n-1])+r;d[n]++;for(let n=0;n<h;++n)a[i*h+n]=e[t*h+n];p[i]=s[t],c[t]=i}for(let e=0;e<l;++e){if(0===d[e]){const t=0===e?0:f[e-1];a[t*h+0]=e;for(let e=1;e<h;++e)a[t*h+e]=0;p[t]=i}}return[a,[t,h],p,u,c]}}function FS(e,t,n,s,r){const a=d(s),i=t[0],o=r.length,l=[];let u=1,c=-1;for(let e=0;e<o;++e){const t=r[e];if(-1===t){if(-1!==c)throw new Error(Wd(c,e));c=e,l.push(1)}else{if(t<0)throw new Error(Vd(e,t));u*=t,l.push(t)}}if(-1!==c){if(u<=0)throw new Error("reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero");const e=Math.trunc(a/u);if(u*e!==a)throw new Error(Gd(s,l));l[c]=e}if(d(l)!==a)throw new Error(Hd(s,l));const h=s.length,p=[];if(h>0){p[h-1]=1;for(let e=h-2;e>=0;--e)p[e]=p[e+1]*s[e+1]}const f=[];if(o>0){f[o-1]=1;for(let e=o-2;e>=0;--e)f[e]=f[e+1]*l[e+1]}const m=N(n,i*o);for(let t=0;t<i;++t){let n=0;for(let s=0;s<h;++s)n+=e[t*h+s]*p[s];for(let e=0;e<o;++e)m[t*o+e]=Math.trunc(n/f[e]),n%=f[e]}return[m,[i,o],l]}function DS(e,t,n,s,r,a=!1,i=0){const o=s.length,l=[t[0],e.length/t[0]],u=l[1],c=o>0?r[o-1]+1:0;if(c<0)throw new Error("segment ids must be >= 0");const h=t.slice();h[0]=c;const p=N(n,h.reduce(((e,t)=>e*t),1));if(0===o)return c>0&&p.fill(i),[p,h];if(c<=0)throw new Error("segment ids must be >= 0");let d=0,f=1,m=0,g=r[d];for(;;){let t=0;if(f<o){if(t=r[f],g===t){++f;continue}if(g>=t)throw new Error("segment ids are not increasing")}if(g<0||g>=c)throw new Error(Kd(g,c));g>m&&p.fill(i,m*u,g*u);for(let t=d;t<f;++t){const n=s[t];if(n<0||n>=l[0])throw new Error(Xd(t,s[t],l[0]));for(let t=0;t<u;t++)p[g*u+t]+=e[n*u+t]}if(a)for(let e=0;e<u;e++)p[g*u+e]/=f-d;if(d=f,++f,m=g+1,g=t,f>o)break}return m<c&&p.fill(i,m*u,c*u),[p,h]}const OS=yI((e=>Math.sqrt(e))),MS=bI($n,(e=>Math.sqrt(e))),LS={kernelName:$n,backendName:"cpu",kernelFunc:MS},zS=QN(((e,t)=>{const n=e-t;return n*n})),PS=uI(Ln,zS),BS={kernelName:Ln,backendName:"cpu",kernelFunc:PS};function WS(e,t,n,s){const r=ja(e,t.dtype);for(let e=0;e<r.size;e++){const a=r.indexToLoc(e),i=new Array(a.length);for(let e=0;e<i.length;e++)i[e]=a[e]*n[e]+s[e];r.set(t.get(...i),...a)}return r}class VS{constructor(e,t,n,s,r,a){this.separator=sr(e),this.nGramWidths=t,this.leftPad=sr(n),this.rightPad=sr(s),this.padWidth=r,this.preserveShort=a}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,t){const n=this.getPadWidth(t);return Math.max(0,e+2*n-t+1)}createNGrams(e,t,n,s,r,a){for(let i=0;i<r;++i){const o=this.getPadWidth(a),l=Math.max(0,o-i),u=Math.max(0,o-(r-(i+1))),c=a-(l+u),h=t+(l>0?0:i-o);let p=0;p+=l*this.leftPad.length;for(let t=0;t<c;++t)p+=e[h+t].length;p+=u*this.rightPad.length;p+=(l+u+c-1)*this.separator.length,n[s+i]=new Uint8Array(p);const d=n[s+i];let f=0;const m=e=>e.forEach((e=>d[f++]=e));for(let e=0;e<l;++e)m(this.leftPad),m(this.separator);for(let t=0;t<c-1;++t)m(e[h+t]),m(this.separator);if(c>0){m(e[h+c-1]);for(let e=0;e<u;++e)m(this.separator),m(this.rightPad)}else{for(let e=0;e<u-1;++e)m(this.rightPad),m(this.separator);m(this.rightPad)}}}compute(e,t){const n=e.length,s=t.length;if(s>0){let e=t[0];if(0!==e)throw new Error(`First split value must be 0, got ${e}`);for(let r=1;r<s;++r){let s=t[r]>=e;if(s=s&&t[r]<=n,!s)throw new Error(`Invalid split value ${t[r]}, must be in [${e}, ${n}]`);e=t[r]}if(e!==n)throw new Error(`Last split value must be data size. Expected ${n}, got ${e}`)}const r=s-1,a=N("int32",s);if(0===n||0===s){const e=new Array(n);for(let e=0;e<=r;++e)a[e]=0;return[e,a]}a[0]=0;for(let e=1;e<=r;++e){const n=t[e]-t[e-1];let s=0;this.nGramWidths.forEach((e=>{s+=this.getNumNGrams(n,e)})),this.preserveShort&&n>0&&0===s&&(s=1),a[e]=a[e-1]+s}const i=new Array(a[r]);for(let n=0;n<r;++n){const s=t[n];let r=a[n];if(this.nGramWidths.forEach((a=>{const o=t[n+1]-t[n],l=this.getNumNGrams(o,a);this.createNGrams(e,s,i,r,l,a),r+=l})),this.preserveShort&&r===a[n]){const a=t[n+1]-t[n];if(0===a)continue;const o=a+2*this.padWidth,l=1;this.createNGrams(e,s,i,r,l,o)}}return[i,a]}}function US(e,t,n,s,r,a,i,o){return new VS(n,s,r,a,i,o).compute(e,t)}function GS(e,t,n,s){if(!e.length)return;if(0===t.length){for(let t=0;t<e.length;++t)s.push(e.subarray(t,t+1));return}if(1===t.length){const r=t[0];let a=e.indexOf(r);for(;-1!==a;){const t=e.subarray(0,a);n&&0===t.length||s.push(t),a=(e=e.subarray(a+1)).indexOf(r)}return void(n&&0===e.length||s.push(e))}let r=0;for(let a=0;a<e.length+1;a++)if(a===e.length||-1!==t.indexOf(e[a])){const t=e.subarray(r,a);n&&0===t.length||s.push(t),r=a+1}}function HS(e,t,n){const s=e.length,r=[];let a=0,i=0;const o=new Array(s);for(let l=0;l<s;++l){const s=r.length;GS(e[l],t,n,r);const u=r.length-s;o[l]=u,a+=u,i=Math.max(i,u)}const l=N("int32",2*a),u=new Array(a),c=[s,i];let h=0;for(let e=0;e<s;++e)for(let t=0;t<o[e];++t)l[2*h]=e,l[2*h+1]=t,u[h]=r[h],++h;return[l,u,c]}function jS(e,t){const n=N("int32",e.length);for(let s=0;s<e.length;++s)n[s]=Js(e[s]).modulo(t).getLowBitsUnsigned();return n}const qS=QN(((e,t)=>e-t)),KS=cI(((e,t,n,s)=>({real:e-n,imag:t-s}))),XS=uI(Un,qS,KS),YS={kernelName:Un,backendName:"cpu",kernelFunc:XS};function ZS(e,t){const n=new Array(e.rank);for(let s=0;s<n.length;s++)n[s]=e.shape[s]*t[s];const s=ja(n,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),r=new Array(e.rank);for(let t=0;t<r.length;t++)r[t]=n[t]%e.shape[t];const a=e.locToIndex(r);s.values[t]=e.values[a]}return s}const JS=(e,t)=>{const n=t.value-e.value;return 0===n?e.index-t.index:n};function QS(e,t,n=0,s=e.length-1){for(;s>n;){if(s-n>600){const r=s-n+1,a=t-n+1,i=Math.log(r),o=.5*Math.exp(2*i/3),l=.5*Math.sqrt(i*o*(r-o)/r)*Math.sign(a-r/2);QS(e,t,Math.max(n,Math.floor(t-a*o/r+l)),Math.min(s,Math.floor(t+(r-a)*o/r+l)))}const r=e[t];let a=n,i=s;for(o(e,n,t),JS(e[s],r)>0&&o(e,n,s);a<i;){for(o(e,a,i),a++,i--;JS(e[a],r)<0;)a+=1;for(;JS(e[i],r)>0;)i-=1}0===JS(e[n],r)?o(e,n,i):(i+=1,o(e,i,s)),i<=t&&(n=i+1),t<=i&&(s=i-1)}}function eT(e,t,n,s,r){const a=t[t.length-1],[i,o]=[e.length/a,a],l=k(n,i*s),u=k("int32",i*s);for(let t=0;t<i;t++){const n=t*o,a=e.subarray(n,n+o);let i=new Array(a.length);a.forEach(((e,t)=>i[t]={value:e,index:t})),s<i.length&&(QS(i,s),i=i.slice(0,s)),r&&i.sort(JS);const c=t*s,h=l.subarray(c,c+s),p=u.subarray(c,c+s);for(let e=0;e<s;e++)h[e]=i[e].value,p[e]=i[e].index}const c=t.slice();return c[c.length-1]=s,[ja(c,n,l),ja(c,"int32",u)]}function tT(e,t,n,s){const r=w(t,n)[0],a=[1,n[0],1];for(let e=0;e<r;e++)a[0]*=n[e];a[1]=n[r];for(let e=r+1;e<n.length;e++)a[2]*=n[e];const i={},o=new Int32Array(n[r]),l=new fr(a,s,e),u=[],c=1===a[0]&&1===a[2];for(let t=0;t<n[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)e.push(l.get(n,t,s));n=e.join(",")}if(void 0!==i[n])o[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,o[t]=e,u.push(t)}}const h=a.slice();h[1]=Object.keys(i).length;const p=new fr(h,s);u.forEach(((e,t)=>{for(let n=0;n<a[0];n++)for(let s=0;s<a[2];s++)p.set(l.get(n,e,s),n,t,s)}));const d=n.slice();return d[r]=h[1],{outputValues:p.values,outputShape:d,indices:o}}var nT=Object.freeze({__proto__:null,simpleAbsImpl:ZN,addImpl:hI,bincountImpl:mI,bincountReduceImpl:gI,ceilImpl:wI,concatImpl:NI,equalImpl:II,expImpl:$I,expm1Impl:AI,floorImpl:FI,gatherNdImpl:MI,gatherV2Impl:LI,greaterImpl:zI,greaterEqualImpl:WI,lessImpl:GI,lessEqualImpl:qI,linSpaceImpl:YI,logImpl:ZI,maxImpl:eS,maximumImpl:tS,minimumImpl:rS,multiplyImpl:oS,negImpl:hS,notEqualImpl:dS,prodImpl:xS,rangeImpl:vS,rsqrtImpl:kS,scatterImpl:SS,sigmoidImpl:TS,sliceImpl:ES,sparseFillEmptyRowsImpl:_S,sparseReshapeImpl:FS,sparseSegmentReductionImpl:DS,sqrtImpl:OS,squaredDifferenceImpl:zS,stridedSliceImpl:WS,stringNGramsImpl:US,stringSplitImpl:HS,stringToHashBucketFastImpl:jS,subImpl:qS,tileImpl:ZS,topKImpl:eT,transposeImpl:gS,uniqueImpl:tT});ki("cpu",(()=>new YN),1);const sT=bI(Ye,(e=>e>=0?e:Math.exp(e)-1)),rT={kernelName:Ye,backendName:"cpu",kernelFunc:sT};function aT(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s;KN([r],"leakyRelu");const i=d(r.shape),o=n.data.get(r.dataId).values,l=k("float32",i);for(let e=0;e<o.length;e++)l[e]=o[e]<0?a*o[e]:o[e];return n.makeTensorInfo(r.shape,"float32",l)}const iT={kernelName:xt,backendName:"cpu",kernelFunc:aT},oT=QN(((e,t)=>e<0?t*e:e));function lT(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t;KN([s,r],"prelu");const a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,[o,l]=oT(s.shape,r.shape,a,i,"float32");return n.makeTensorInfo(l,"float32",o)}const uT={kernelName:tn,backendName:"cpu",kernelFunc:lT},cT=bI(on,(e=>Math.max(0,e))),hT={kernelName:on,backendName:"cpu",kernelFunc:cT},pT=bI(dn,(e=>Math.min(Math.max(0,e),6))),dT={kernelName:dn,backendName:"cpu",kernelFunc:pT};function fT(e,t,n,s,r){if("linear"===n)return sI({inputs:{x:t},backend:e});if("relu"===n)return cT({inputs:{x:t},backend:e});if("elu"===n)return sT({inputs:{x:t},backend:e});if("relu6"===n)return pT({inputs:{x:t},backend:e});if("prelu"===n)return lT({inputs:{x:t,alpha:s},backend:e});if("leakyrelu"===n)return aT({inputs:{x:t},backend:e,attrs:{alpha:r}});if("sigmoid"===n)return $S({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function mT(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=d(r.shape),o=x(a,i),l=d(o);u(i===l,(()=>`The new shape (${o}) has ${l} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`)),n.incRef(r.dataId);const c=n.data.get(r.dataId);if(null!=c.complexTensorInfos){const e=c.complexTensorInfos.real,t=c.complexTensorInfos.imag;e.shape=o,t.shape=o}return{dataId:r.dataId,shape:o,dtype:r.dtype}}const gT={kernelName:ln,backendName:"cpu",kernelFunc:mT};function yT(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;KN([r,a],"matMul");const l=r.shape.length,c=a.shape.length,h=i?r.shape[l-2]:r.shape[l-1],p=o?a.shape[c-1]:a.shape[c-2],f=i?r.shape[l-1]:r.shape[l-2],m=o?a.shape[c-2]:a.shape[c-1],g=r.shape.slice(0,-2),y=a.shape.slice(0,-2),b=d(g),x=d(y),w=_i(r.shape.slice(0,-2),a.shape.slice(0,-2)).concat([f,m]);u(h===p,(()=>`Error in matMul: inner shapes (${h}) and (${p}) of Tensors with shapes ${r.shape} and ${a.shape} and transposeA=${i} and transposeB=${o} must match.`));const v=o?[x,m,p]:[x,p,m],k=mT({inputs:{x:r},backend:n,attrs:{shape:i?[b,h,f]:[b,f,h]}}),N=mT({inputs:{x:a},backend:n,attrs:{shape:v}}),I=i?k.shape[1]:k.shape[2],S=i?k.shape[2]:k.shape[1],T=o?N.shape[1]:N.shape[2],$=Math.max(b,x),C=n.data.get(k.dataId).values,E=n.data.get(N.dataId).values,A=M(k.shape),R=M(N.shape),[_,F,D]=i?[A[0],1,A[1]]:[A[0],A[1],1],[O,L,z]=o?[1,R[1],R[0]]:[R[1],1,R[0]],P=S*T,B=ja([$,S,T],k.dtype),W=B.values,V=n.blockSize;for(let e=0;e<$;e++)for(let t=0;t<S;t+=V)for(let n=0;n<T;n+=V)for(let s=0;s<I;s+=V){const r=Math.min(t+V,S),a=Math.min(n+V,T),i=Math.min(s+V,I);for(let o=t;o<r;o++)for(let t=n;t<a;t++){let n=0;for(let r=s;r<i;r++){const s=Math.min(e,b-1)*_,a=Math.min(e,x-1)*z;n+=C[s+o*F+r*D]*E[r*O+t*L+a]}W[e*P+(o*T+t)]+=n}}return n.disposeIntermediateTensorInfo(k),n.disposeIntermediateTensorInfo(N),n.makeTensorInfo(w,B.dtype,B.values)}const bT={kernelName:ye,backendName:"cpu",kernelFunc:yT};const xT={kernelName:ss,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;let p,d,f;const m=[];p=yT({inputs:{a:r,b:a},attrs:{transposeA:l,transposeB:u},backend:n}),i&&(d=dI({inputs:{a:p,b:i},backend:n}),m.push(p),p=d),c&&(f=fT(n,p,c,o,h),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},wT=bI(ee,(e=>Math.acos(e))),vT={kernelName:ee,backendName:"cpu",kernelFunc:wT},kT=bI(te,(e=>Math.acosh(e))),NT={kernelName:te,backendName:"cpu",kernelFunc:kT};const IT={kernelName:se,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,s=t;KN(t,"addN");const r=s.map((e=>n.data.get(e.dataId).values)),a=ja(s[0].shape,s[0].dtype),i=a.values;for(let e=0;e<s.length;e++){const t=r[e];for(let e=0;e<i.length;e++)i[e]+=t[e]}return n.makeTensorInfo(a.shape,a.dtype,a.values)}};const ST={kernelName:re,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;KN(r,"all");const o=w(a,r.shape);let l=o;const u=ql(l,r.shape.length);let c=r;null!=u&&(c=yS({inputs:{x:r},backend:n,attrs:{perm:u}}),l=Xl(l.length,r.shape.length)),jl("all",l,c.shape.length);const[h,p]=Gl(c.shape,l),f=d(p),m=B(d(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n&&s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=mT({inputs:{x:y},backend:n,attrs:{shape:Hl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const TT={kernelName:ae,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;KN(r,"any");const o=w(a,r.shape);let l=o;const u=ql(l,r.shape.length);let c=r;null!=u&&(c=yS({inputs:{x:r},backend:n,attrs:{perm:u}}),l=Xl(l.length,r.shape.length)),jl("any",l,c.shape.length);const[h,p]=Gl(c.shape,l),f=d(p),m=B(d(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];n=n||s}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=mT({inputs:{x:y},backend:n,attrs:{shape:Hl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const $T={kernelName:ie,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;KN(r,"argMax");let i=w(a,r.shape);const o=ql(i,r.shape.length);let l=r;const u=[];null!=o&&(l=yS({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=Xl(i.length,l.shape.length)),i=[i[0]],jl("argMax",i,l.shape.length);const[c,h]=Gl(l.shape,i),p=B(d(c),"int32"),f=d(h),m=n.data.get(l.dataId).values;for(let e=0;e<p.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r>n&&(n=r,s=e)}p[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",p)}};const CT={kernelName:oe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;KN(r,"argMin");let i=w(a,r.shape);const o=ql(i,r.shape.length);let l=r;const u=[];null!=o&&(l=yS({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=Xl(i.length,l.shape.length)),i=[i[0]],jl("argMin",i,l.shape.length);const[c,h]=Gl(l.shape,i),p=B(d(c),"int32"),f=d(h),m=n.data.get(l.dataId).values;for(let e=0;e<p.length;++e){const t=e*f;let n=m[t],s=0;for(let e=0;e<f;++e){const r=m[t+e];r<n&&(n=r,s=e)}p[e]=s}return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c,"int32",p)}},ET=bI(le,(e=>Math.asin(e))),AT={kernelName:le,backendName:"cpu",kernelFunc:ET},RT=bI(ue,(e=>Math.asinh(e))),_T={kernelName:ue,backendName:"cpu",kernelFunc:RT},FT=bI(ce,(e=>Math.atan(e))),DT={kernelName:ce,backendName:"cpu",kernelFunc:FT},OT=QN(((e,t)=>Math.atan2(e,t))),MT=uI(pe,OT),LT={kernelName:pe,backendName:"cpu",kernelFunc:MT},zT=bI(he,(e=>Math.atanh(e))),PT={kernelName:he,backendName:"cpu",kernelFunc:zT};function BT(e,t,n,s,r,a){const i=r.strideHeight,o=r.strideWidth,l=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,h=r.effectiveFilterWidth,p=r.padInfo.top,d=r.padInfo.left,f="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,m=ja(r.outShape,n),g=m.values,y=r.outShape[1]*r.outShape[2]*r.outShape[3],b=r.outShape[2]*r.outShape[3],x=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*y,m=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outHeight;++y){const w=y*i-p,v=Math.max(0,w),k=Math.min(r.inHeight,c+w),N=n+y*b;for(let n=0;n<r.outWidth;++n){const i=n*o-d,c=Math.max(0,i),p=Math.min(r.inWidth,h+i);let y=f,b=0,w=0;for(let n=v;n<k;n+=l){const r=m+n*s[1];for(let n=c;n<p;n+=u){const i=e[r+n*s[2]+t];"max"===a&&i>y?y=i:"avg"===a&&(b+=i,w++)}if(isNaN(y))break}g[N+n*x+t]="avg"===a?b/w:y}}}return m}function WT(e,t,n,s,r=!1,a=!1){const i=ja(s.outShape,"int32"),o=s.strideHeight,l=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,h=s.effectiveFilterHeight,p=s.effectiveFilterWidth,d=s.padInfo.top,f=s.padInfo.left,m=ja(t,n,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const g=n*o-d;let y=g;for(;y<0;)y+=u;const b=Math.min(s.inHeight,h+g);for(let o=0;o<s.outWidth;++o){const h=o*l-f;let d=h;for(;d<0;)d+=c;const x=Math.min(s.inWidth,p+h);let w=Number.NEGATIVE_INFINITY,v=-1;for(let n=y;n<b;n+=u){const i=n-g;for(let o=d;o<x;o+=c){const l=o-h,u=m.get(e,n,o,t);u>w&&(w=u,v=r?a?((e*s.inHeight+n)*s.inWidth+o)*s.inChannels+t:(n*s.inWidth+o)*s.inChannels+t:i*p+l)}}i.set(v,e,n,o,t)}}return i}function VT(e,t,n,s,r,a){const i=r.strideDepth,o=r.strideHeight,l=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,h=r.dilationWidth,p=r.effectiveFilterDepth,d=r.effectiveFilterHeight,f=r.effectiveFilterWidth,m=r.padInfo.front,g=r.padInfo.top,y=r.padInfo.left,b="max"===a?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,x=ja(r.outShape,n),w=x.values,v=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],k=r.outShape[2]*r.outShape[3]*r.outShape[4],N=r.outShape[3]*r.outShape[4],I=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*v,x=t*s[0];for(let t=0;t<r.inChannels;++t)for(let v=0;v<r.outDepth;++v){const S=v*i-m;let T=S;for(;T<0;)T+=u;const $=Math.min(r.inDepth,p+S),C=n+v*k;for(let n=0;n<r.outHeight;++n){const i=n*o-g;let p=i;for(;p<0;)p+=c;const m=Math.min(r.inHeight,d+i),v=C+n*N;for(let n=0;n<r.outWidth;++n){const i=n*l-y;let o=i;for(;o<0;)o+=h;const d=Math.min(r.inWidth,f+i),g=v+n*I;let k=b,N=0,S=0;for(let n=T;n<$;n+=u){const r=x+n*s[1];for(let n=p;n<m;n+=c){const i=r+n*s[2];for(let n=o;n<d;n+=h){const r=e[i+n*s[3]+t];if("max"===a&&r>k?k=r:"avg"===a&&(N+=r,S++),isNaN(k))break}if(isNaN(k))break}if(isNaN(k))break}w[g+t]="avg"===a?N/S:k}}}}return x}const UT={kernelName:de,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;KN(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(qo(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Lo(r.shape,a,i,1,o,l);let h;if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))h=sI({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=M(r.shape),s=BT(e,r.shape,r.dtype,t,c,"avg");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const GT={kernelName:me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;KN(r,"avgPool3d");const c=zo(r.shape,a,i,1,o,l,u),h=VT(n.data.get(r.dataId).values,r.shape,r.dtype,M(r.shape),c,"avg");return n.makeTensorInfo(h.shape,"float32",h.values)}};const HT={kernelName:ge,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;KN([r,a],"avgPool3DGrad");const c=zo(a.shape,i,o,1,l,u),h=c.strideDepth,p=c.strideHeight,d=c.strideWidth,f=c.filterDepth,m=c.filterHeight,g=c.filterWidth,y=c.dilationDepth,b=c.dilationHeight,x=c.dilationWidth,w=c.effectiveFilterDepth,v=c.effectiveFilterHeight,k=c.effectiveFilterWidth,N=w-1-c.padInfo.front,I=k-1-c.padInfo.left,S=v-1-c.padInfo.top,T=ja(a.shape,"float32"),$=1/(f*m*g),C=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-N,i=s-S,o=r-I;let l=0;for(let n=0;n<w;n+=y){const s=(a+n)/h;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let n=0;n<v;n+=b){const r=(i+n)/p;if(!(r<0||r>=c.outHeight||Math.floor(r)!==r))for(let n=0;n<k;n+=x){const a=(o+n)/d;if(a<0||a>=c.outWidth||Math.floor(a)!==a)continue;l+=C.get(e,s,r,a,t)}}}T.set(l*$,e,n,s,r,t)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};const jT={kernelName:fe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;KN([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Lo(i.shape,o,l,1,u),h=c.strideHeight,p=c.strideWidth,d=c.filterHeight,f=c.filterWidth,m=c.dilationHeight,g=c.dilationWidth,y=c.effectiveFilterHeight,b=c.effectiveFilterWidth,x=b-1-c.padInfo.left,w=y-1-c.padInfo.top,v=ja(i.shape,"float32"),k=1/(d*f),N=n.data.get(r.dataId).values,I=ja(r.shape,"float32",N);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inHeight;++n)for(let s=0;s<c.inWidth;++s){const r=n-w,a=s-x;let i=0;for(let n=0;n<y;n+=m){const s=(r+n)/h;if(!(s<0||s>=c.outHeight||Math.floor(s)!==s))for(let n=0;n<b;n+=g){const r=(a+n)/p;if(r<0||r>=c.outWidth||Math.floor(r)!==r)continue;i+=I.get(e,s,r,t)}}v.set(i*k,e,n,s,t)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const qT={kernelName:lt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,scale:a,offset:i,mean:o,variance:l}=t;u(o.shape.length===l.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==i||o.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==a||o.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks.")),KN([r,o,l,a,i],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const h=n.data.get(r.dataId).values,p=n.data.get(o.dataId).values,d=n.data.get(l.dataId).values,f=a?n.data.get(a.dataId).values:new Float32Array([1]),m=i?n.data.get(i.dataId).values:new Float32Array([0]),g=new Float32Array(h.length),y=m.length,b=f.length,x=d.length,w=p.length;let v=0,k=0,N=0,I=0;for(let e=0;e<h.length;++e)g[e]=m[v++]+(h[e]-p[k++])*f[N++]/Math.sqrt(d[I++]+c),v>=y&&(v=0),k>=w&&(k=0),N>=b&&(N=0),I>=x&&(I=0);return n.makeTensorInfo(r.shape,r.dtype,g)}};const KT={kernelName:be,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;KN([r],"batchToSpaceND");const o=a.reduce(((e,t)=>e*t)),l=ld(r.shape,a,o),u=ud(l.length,a.length),c=cd(r.shape,a,o),h=hd(i,a.length),p=pd(c,i,a.length),d=mT({inputs:{x:r},backend:n,attrs:{shape:l}}),f=yS({inputs:{x:d},backend:n,attrs:{perm:u}}),m=mT({inputs:{x:f},backend:n,attrs:{shape:c}}),g=AS({inputs:{x:m},backend:n,attrs:{begin:h,size:p}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const XT={kernelName:xe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=mI(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,o)}};const YT={kernelName:ve,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{s0:s,s1:r}=t,a=n.data.get(s.dataId).values,i=n.data.get(r.dataId).values,o=_i(Array.from(a),Array.from(i));return n.makeTensorInfo([o.length],"int32",Int32Array.from(o))}},ZT=bI(Ie,((e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})),JT={kernelName:Ie,backendName:"cpu",kernelFunc:ZT},QT={kernelName:Te,backendName:"cpu",kernelFunc:e=>{const{x:t}=e.inputs,n=e.backend,s=new Float32Array(d(t.shape)),r=n.data.get(t.dataId),a=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values;for(let e=0;e<o.length;e++){const t=o[e],n=l[e];s[e]=Math.hypot(t,n)}return n.makeOutput(s,t.shape,"float32")}};function e$(e){const{inputs:t,backend:n}=e,{input:s}=t,r=n.data.get(s.dataId).complexTensorInfos.imag,a=n.data.get(r.dataId).values;return n.makeTensorInfo(r.shape,r.dtype,a)}const t$={kernelName:mt,backendName:"cpu",kernelFunc:e$};function n$(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=w(r,t[0].shape)[0];let i=ad(t.map((e=>e.shape)),a);if(0===d(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>d(e.shape)>0));if(1===o.length)return sI({inputs:{x:o[0]},backend:n});if(rd(o.map((e=>e.shape)),a),"complex64"===o[0].dtype){const e=o.map((e=>aI({inputs:{input:e},backend:n}))),t=o.map((e=>e$({inputs:{input:e},backend:n}))),s=n$({inputs:e,backend:n,attrs:{axis:a}}),r=n$({inputs:t,backend:n,attrs:{axis:a}}),i=eI({inputs:{real:s,imag:r},backend:n});return e.forEach((e=>n.disposeIntermediateTensorInfo(e))),t.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),i}const l=o.map((e=>{const t=d(e.shape.slice(a));return mT({inputs:{x:e},backend:n,attrs:{shape:[-1,t]}})})),u=l.map((e=>({vals:n.data.get(e.dataId).values,shape:e.shape})));i=ad(l.map((e=>e.shape)),1);const c=1===l[0].shape[0],h=NI(u,i,t[0].dtype,c),p=ad(o.map((e=>e.shape)),a),f=n.makeTensorInfo(p,t[0].dtype,h);return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}const s$={kernelName:$e,backendName:"cpu",kernelFunc:n$};function r$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s;KN([r,a],"conv2d");const h=Ko(l),p=Po(r.shape,a.shape,i,u,o,c,!1,h),d=p.filterHeight,f=p.filterWidth,m=p.dilationHeight,g=p.dilationWidth,y=p.padInfo.left,b=p.padInfo.top,x="channelsLast"===p.dataFormat,w=new fr(p.outShape,r.dtype),v=M(r.shape),k=M(a.shape),N=v[0],I=x?v[1]:v[2],S=x?v[2]:1,T=x?1:v[1],$=w.strides[0],C=x?w.strides[1]:w.strides[2],E=x?w.strides[2]:1,A=x?1:w.strides[1],R=n.data.get(r.dataId).values,_=n.data.get(a.dataId).values,F=w.values;for(let e=0;e<p.batchSize;++e){const t=e*N,n=e*$;for(let e=0;e<p.outHeight;++e){const s=n+e*C,r=e*p.strideHeight-b;for(let e=0;e<d;++e){const n=r+e*m;if(n<0||n>=p.inHeight)continue;const a=e*k[0],i=t+n*I;for(let e=0;e<p.outWidth;++e){const t=s+e*E,n=e*p.strideWidth-y;for(let e=0;e<f;++e){const s=n+e*g;if(s<0||s>=p.inWidth)continue;const r=i+s*S;let o=a+e*k[1];for(let e=0;e<p.inChannels;++e){const n=R[r+e*T];for(let e=0;e<p.outChannels;++e)F[t+e*A]+=n*_[o+e];o+=p.outChannels}}}}}}return n.makeTensorInfo(w.shape,w.dtype,F)}const a$={kernelName:Ce,backendName:"cpu",kernelFunc:r$};const i$={kernelName:Ee,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s;KN([r,a],"conv2dBackpropFilter");const h=Ko(l),p=Po(r.shape,c,i,1,o,u,!1,h),{strideHeight:d,strideWidth:f,filterHeight:m,filterWidth:g}=p,y="channelsLast"===p.dataFormat,b=new fr(p.filterShape,"float32"),x=p.padInfo.left,w=p.padInfo.top,v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=new fr(r.shape,r.dtype,v),I=new fr(a.shape,a.dtype,k);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((w-e)/d)),n=Math.min(p.outHeight,(p.inHeight+w-e)/d);for(let s=0;s<g;++s){const r=Math.max(0,Math.ceil((x-s)/f)),a=Math.min(p.outWidth,(p.inWidth+x-s)/f);for(let i=0;i<p.inChannels;++i)for(let o=0;o<p.outChannels;++o){let l=0;for(let u=0;u<p.batchSize;++u)for(let c=t;c<n;++c){const t=e+c*d-w;for(let e=r;e<a;++e){const n=s+e*f-x;l+=y?N.get(u,t,n,i)*I.get(u,c,e,o):N.get(u,i,t,n)*I.get(u,o,c,e)}}b.set(l,e,s,i,o)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const o$={kernelName:Ae,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s;KN([r,a],"conv2dBackpropInput");const h=M(a.shape),p=M(r.shape);let d=Ko(u);const f=Po(i,a.shape,o,1,l,c,!1,d),m=new fr(f.inShape,"float32"),g=m.values,y=n.data.get(r.dataId).values,b=n.data.get(a.dataId).values,[x,w,v]=h,{batchSize:k,filterHeight:N,filterWidth:I,inChannels:S,inHeight:T,inWidth:$,outChannels:C,outHeight:E,outWidth:A,strideHeight:R,strideWidth:_}=f;d=f.dataFormat;const F=N-1-f.padInfo.top,D=I-1-f.padInfo.left,O="channelsLast"===d,L=m.strides[0],z=O?m.strides[1]:m.strides[2],P=O?m.strides[2]:1,B=O?1:m.strides[1],W=p[0],V=O?p[1]:p[2],U=O?p[2]:1,G=O?1:p[1];for(let e=0;e<k;++e)for(let t=0;t<S;++t)for(let n=0;n<T;++n){const s=n-F,r=Math.max(0,Math.ceil(s/R)),a=Math.min(E,(N+s)/R);for(let i=0;i<$;++i){const o=i-D,l=Math.max(0,Math.ceil(o/_)),u=Math.min(A,(I+o)/_);let c=0;for(let n=r;n<a;++n){const r=n*R-s;for(let s=l;s<u;++s){const a=W*e+V*n+U*s,i=x*(N-1-r)+w*(I-1-(s*_-o))+v*t;for(let e=0;e<C;++e){c+=y[a+G*e]*b[i+e]}}}g[L*e+z*n+P*i+B*t]=c}}return n.makeTensorInfo(m.shape,m.dtype,m.values)}};const l$={kernelName:Re,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s;KN([r,a],"conv3d");const u=Bo(r.shape,a.shape,i,l,o),{filterDepth:c,filterHeight:h,filterWidth:p,dilationDepth:d,dilationHeight:f,dilationWidth:m,padInfo:g}=u,y=g.front,b=g.left,x=g.top,w=new fr(u.outShape,r.dtype),v=n.data.get(r.dataId).values,k=n.data.get(a.dataId).values,N=w.values,I=M(r.shape),S=M(a.shape);for(let e=0;e<u.batchSize;++e){const t=e*I[0],n=e*w.strides[0];for(let e=0;e<u.outDepth;++e){const s=n+e*w.strides[1],r=e*u.strideDepth-y;for(let e=0;e<c;++e){const n=r+e*d;if(n<0||n>=u.inDepth)continue;const a=e*S[0],i=t+n*I[1];for(let e=0;e<u.outHeight;++e){const t=s+e*w.strides[2],n=e*u.strideHeight-x;for(let e=0;e<h;++e){const s=n+e*f;if(s<0||s>=u.inHeight)continue;const r=a+e*S[1],o=i+s*I[2];for(let e=0;e<u.outWidth;++e){const n=t+e*u.outChannels,s=e*u.strideWidth-b;for(let e=0;e<p;++e){const t=s+e*m;if(t<0||t>=u.inWidth)continue;const a=r+e*S[2],i=o+t*u.inChannels;let l=a;for(let e=0;e<u.inChannels;++e){const t=v[i+e];for(let e=0;e<u.outChannels;++e)N[n+e]+=t*k[l+e];l+=u.outChannels}}}}}}}}return n.makeTensorInfo(w.shape,w.dtype,w.values)}};const u$={kernelName:_e,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s;KN([r,a],"conv3dBackpropFilterV2");const u=M(r.shape),c=M(a.shape),h=Bo(r.shape,l,i,1,o),p=h.strideDepth,d=h.strideHeight,f=h.strideWidth,m=h.filterDepth,g=h.filterHeight,y=h.filterWidth,b=new fr(h.filterShape,"float32"),x=b.values,[w,v,k,N]=b.strides,I=n.data.get(a.dataId).values,[S,T,$,C]=c,E=n.data.get(r.dataId).values,[A,R,_,F]=u,D=h.padInfo.front,O=h.padInfo.left,L=h.padInfo.top;for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((D-e)/p)),n=Math.min(h.outDepth,(h.inDepth+D-e)/p),s=e*w;for(let r=0;r<g;++r){const a=Math.max(0,Math.ceil((L-r)/d)),i=Math.min(h.outHeight,(h.inHeight+L-r)/d),o=r*v+s;for(let s=0;s<y;++s){const l=Math.max(0,Math.ceil((O-s)/f)),u=Math.min(h.outWidth,(h.inWidth+O-s)/f),c=s*k+o;for(let o=0;o<h.inChannels;++o){const m=o*N+c;for(let c=0;c<h.outChannels;++c){let g=0;for(let m=0;m<h.batchSize;++m){const h=m*A,y=m*S;for(let m=t;m<n;++m){const t=(e+m*p-D)*R+h,n=m*T+y;for(let e=a;e<i;++e){const a=(r+e*d-L)*_+t,i=e*$+n;for(let e=l;e<u;++e){const t=e*C+i;g+=E[(s+e*f-O)*F+a+o]*I[t+c]}}}}x[m+c]=g}}}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const c$={kernelName:Fe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s;KN([r],"conv3dBackpropInputV2");const u=M(r.shape),c=M(a.shape),h=Bo(l,a.shape,o,1,i),p=new fr(h.inShape,"float32"),d=p.values,[f,m,g,y]=p.strides,b=n.data.get(r.dataId).values,[x,w,v,k]=u,N=n.data.get(a.dataId).values,[I,S,T,$]=c,{batchSize:C,filterDepth:E,filterHeight:A,filterWidth:R,inChannels:_,inDepth:F,inHeight:D,inWidth:O,outChannels:L,outDepth:z,outHeight:P,outWidth:B,strideDepth:W,strideHeight:V,strideWidth:U}=h,G=E-1-h.padInfo.front,H=A-1-h.padInfo.top,j=R-1-h.padInfo.left;for(let e=0;e<C;++e)for(let t=0;t<_;++t)for(let n=0;n<F;++n){const s=n-G,r=Math.max(0,Math.ceil(s/W)),a=Math.min(z,(E+s)/W);for(let i=0;i<D;++i){const o=i-H,l=Math.max(0,Math.ceil(o/V)),u=Math.min(P,(A+o)/V);for(let c=0;c<O;++c){const h=c-j,p=Math.max(0,Math.ceil(h/U)),C=Math.min(B,(R+h)/U);let _=0;for(let n=r;n<a;++n){const r=n*W-s;for(let s=l;s<u;++s){const a=s*V-o;for(let i=p;i<C;++i){const o=x*e+w*n+v*s+k*i,l=I*(E-1-r)+S*(A-1-a)+T*(R-1-(i*U-h))+$*t;for(let e=0;e<L;++e){_+=b[o+e]*N[l+e]}}}}d[f*e+m*n+g*i+y*c+t]=_}}}return n.makeTensorInfo(p.shape,p.dtype,p.values)}},h$=bI(De,(e=>Math.cos(e))),p$={kernelName:De,backendName:"cpu",kernelFunc:h$},d$=bI(Oe,(e=>Math.cosh(e))),f$={kernelName:Oe,backendName:"cpu",kernelFunc:d$};const m$={kernelName:ze,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,[c,h,p,d]=r.shape,f=a.shape[0],[m,g]=o,y=ja([f,m,g,d],"float32"),b=n.data.get(a.dataId).values,x=n.data.get(i.dataId).values,w=n.data.get(r.dataId).values,v=M(r.shape),k=M(y.shape);for(let e=0;e<f;e++){const t=4*e,n=b[t],s=b[t+1],r=b[t+2],a=b[t+3],i=x[e];if(i>=c)continue;const o=m>1?(r-n)*(h-1)/(m-1):0,f=g>1?(a-s)*(p-1)/(g-1):0;for(let t=0;t<m;t++){const c=m>1?n*(h-1)+t*o:.5*(n+r)*(h-1);if(c<0||c>h-1)for(let n=0;n<g;n++)for(let s=0;s<d;s++){const r=s+n*k[2]+t*k[1]+e*k[0];y.values[r]=u}else if("bilinear"===l){const n=Math.floor(c),r=Math.ceil(c),o=c-n;for(let l=0;l<g;l++){const c=g>1?s*(p-1)+l*f:.5*(s+a)*(p-1);if(c<0||c>p-1){for(let n=0;n<d;n++){const s=n+l*k[2]+t*k[1]+e*k[0];y.values[s]=u}continue}const h=Math.floor(c),m=Math.ceil(c),b=c-h;for(let s=0;s<d;s++){let a=s+h*v[2]+n*v[1]+i*v[0];const u=w[a];a=s+m*v[2]+n*v[1]+i*v[0];const c=w[a];a=s+h*v[2]+r*v[1]+i*v[0];const p=w[a];a=s+m*v[2]+r*v[1]+i*v[0];const d=u+(c-u)*b,f=p+(w[a]-p)*b;a=s+l*k[2]+t*k[1]+e*k[0],y.values[a]=d+(f-d)*o}}}else for(let n=0;n<g;++n){const r=g>1?s*(p-1)+n*f:.5*(s+a)*(p-1);if(r<0||r>p-1){for(let s=0;s<d;s++){const r=s+n*k[2]+t*k[1]+e*k[0];y.values[r]=u}continue}const o=Math.round(r),l=Math.round(c);for(let s=0;s<d;s++){const r=s+o*v[2]+l*v[1]+i*v[0],a=s+n*k[2]+t*k[1]+e*k[0];y.values[a]=w[r]}}}}return n.makeTensorInfo(y.shape,y.dtype,y.values)}};const g$={kernelName:Me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;KN(r,"cumprod");const l=ql([a],r.shape.length);let u=r;null!=l&&(u=yS({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=Xl(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumprod in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=$r(u.dtype,"int32"),p=P(d(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)p[n]=i?1:f[n];else{const s=g(e,t-1);p[n]=i?f[s]*p[s]:f[n]*p[s]}}const y=n.makeTensorInfo(u.shape,h,p);if(null!=l){const e=yS({inputs:{x:y},backend:n,attrs:{perm:Kl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const y$={kernelName:Le,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;KN(r,"cumsum");const l=ql([a],r.shape.length);let u=r;null!=l&&(u=yS({inputs:{x:r},backend:n,attrs:{perm:l}}));const c=Xl(1,r.shape.length)[0];if(c!==u.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${u.shape.length-1} but got axis=${c}`);const h=$r(u.dtype,"int32"),p=B(d(u.shape),h),f=n.data.get(u.dataId).values,m=u.shape[u.shape.length-1],g=o?(e,t)=>e+m-t-1:(e,t)=>e+t;for(let e=0;e<f.length;e+=m)for(let t=0;t<m;t++){const n=g(e,t);if(0===t)p[n]=i?0:f[n];else{const s=g(e,t-1);p[n]=i?f[s]+p[s]:f[n]+p[s]}}const y=n.makeTensorInfo(u.shape,h,p);if(null!=l){const e=yS({inputs:{x:y},backend:n,attrs:{perm:Kl(l)}});return n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(u),e}return y}};const b$={kernelName:Pe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=mI(n.data.get(r.dataId).values,n.data.get(a.dataId).values,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,e)}if(2===r.shape.length){const e=gI(n.bufferSync(r),n.bufferSync(a),i,o);return n.makeTensorInfo(e.shape,a.dtype,e.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};const x$={kernelName:Be,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s;u("NHWC"===i,(()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`));const o=r.shape[0],l=r.shape[1],c=r.shape[2],h=r.shape[3],p=l*a,d=c*a,f=h/(a*a),m=n.data.get(r.dataId).values,g=new Float32Array(o*p*d*f);let y=0;for(let e=0;e<o;++e)for(let t=0;t<p;++t){const n=Math.floor(t/a),s=t%a;for(let t=0;t<d;++t){const r=Math.floor(t/a),i=(s*a+t%a)*f;for(let t=0;t<f;++t){const s=t+i+h*(r+c*(n+l*e));g[y++]=m[s]}}}return n.makeTensorInfo([o,p,d,f],r.dtype,g)}};function w$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l,dimRoundingMode:c}=s;KN([r,a],"depthwiseConv2DNative");const h=M(r.shape),p=M(a.shape);let d=l;null==d&&(d=[1,1]),u(qo(i,d),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${d}'`));const f=Po(r.shape,a.shape,i,d,o,c,!0),{filterHeight:m,filterWidth:g,dilationHeight:y,dilationWidth:b,padInfo:x}=f,w=x.left,v=x.top,k=f.outChannels/f.inChannels,N=new fr(f.outShape,r.dtype),I=n.data.get(r.dataId).values,S=n.data.get(a.dataId).values,T=N.values;for(let e=0;e<f.batchSize;++e){const t=e*h[0],n=e*N.strides[0];for(let e=0;e<f.outHeight;++e){const s=n+e*N.strides[1],r=e*f.strideHeight-v;for(let e=0;e<m;++e){const n=r+e*y;if(n<0||n>=f.inHeight)continue;const a=e*p[0],i=t+n*h[1];for(let e=0;e<f.outWidth;++e){const t=s+e*N.strides[2],n=e*f.strideWidth-w;for(let e=0;e<g;++e){const s=n+e*b;if(s<0||s>=f.inWidth)continue;const r=a+e*p[1],o=i+s*f.inChannels;let l=t,u=r;for(let e=0;e<f.inChannels;++e){const t=I[o+e];for(let e=0;e<k;++e)T[l+e]+=t*S[u+e];l+=k,u+=k}}}}}}return n.makeTensorInfo(N.shape,N.dtype,N.values)}const v$={kernelName:We,backendName:"cpu",kernelFunc:w$};const k$={kernelName:Ve,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s;KN([r,a],"depthwiseConv2dNativeBackpropFilter");const h=Po(r.shape,c,i,o,l,u,!0),{strideHeight:p,strideWidth:d,filterHeight:f,filterWidth:m}=h,g=new fr(h.filterShape,"float32"),y=h.padInfo.left,b=h.padInfo.top,x=h.outChannels/h.inChannels,w=n.data.get(r.dataId).values,v=new fr(r.shape,r.dtype,w),k=n.data.get(a.dataId).values,N=new fr(a.shape,a.dtype,k);for(let e=0;e<f;++e){const t=Math.max(0,Math.ceil((b-e)/p)),n=Math.min(h.outHeight,(h.inHeight+b-e)/p);for(let s=0;s<m;++s){const r=Math.max(0,Math.ceil((y-s)/d)),a=Math.min(h.outWidth,(h.inWidth+y-s)/d);for(let i=0;i<h.outChannels;++i){const o=Math.trunc(i/x),l=i%x;let u=0;for(let l=0;l<h.batchSize;++l)for(let c=t;c<n;++c){const t=e+c*p-b;for(let e=r;e<a;++e){const n=s+e*d-y;u+=v.get(l,t,n,o)*N.get(l,c,e,i)}}g.set(u,e,s,o,l)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const N$={kernelName:Ue,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s;KN([r,a],"depthwiseConv2DNativeBackpropInput");const h=M(r.shape),p=M(a.shape),d=Po(c,a.shape,i,o,l,u,!0),f=new fr(d.inShape,"float32"),m=f.values,[g,y,b]=f.strides,x=n.data.get(r.dataId).values,[w,v,k]=h,N=n.data.get(a.dataId).values,[I,S,T]=p,{batchSize:$,filterHeight:C,filterWidth:E,inChannels:A,inHeight:R,inWidth:_,outChannels:F,outHeight:D,outWidth:O,strideHeight:L,strideWidth:z}=d,P=C-1-d.padInfo.top,B=E-1-d.padInfo.left,W=F/A;for(let e=0;e<$;++e)for(let t=0;t<A;++t)for(let n=0;n<R;++n){const s=n-P,r=Math.max(0,Math.ceil(s/L)),a=Math.min(D,(C+s)/L);for(let i=0;i<_;++i){const o=i-B,l=Math.max(0,Math.ceil(o/z)),u=Math.min(O,(E+o)/z);let c=0;for(let n=r;n<a;++n){const r=n*L-s;for(let s=l;s<u;++s){const a=w*e+v*n+k*s,i=I*(C-1-r)+S*(E-1-(s*z-o))+T*t;for(let e=0;e<W;++e){c+=x[a+(t*W+e)]*N[i+e]}}}m[g*e+y*n+b*i+t]=c}}return n.makeTensorInfo(f.shape,f.dtype,f.values)}};const I$={kernelName:Ge,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=d(s.shape),a=n.data.get(s.dataId).values,i=ja([r,r],s.dtype),o=i.values;for(let e=0;e<a.length;e++)o[e*r+e]=a[e];const l=[...s.shape,...s.shape];return n.makeTensorInfo(l,i.dtype,i.values)}},S$={kernelName:He,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r}=e,{strides:a,pad:i,dilations:o}=n,l=t,u=l.data.get(s.dataId).values,c=s.shape.length,h=l.data.get(r.dataId).values,p=r.shape.length,{batchSize:f,inHeight:m,inWidth:g,inChannels:y,outHeight:b,outWidth:x,padInfo:w,strideHeight:v,strideWidth:k,filterHeight:I,filterWidth:S,dilationHeight:T,dilationWidth:$,outShape:C}=Mo(s.shape,r.shape,a,i,"NHWC",o),E=d(C),A=C.length,R=N(s.dtype,E);for(let e=0;e<f;++e)for(let t=0;t<b;++t){const n=t*v-w.top;for(let a=0;a<x;++a){const i=a*k-w.left;for(let o=0;o<y;++o){let l=Number.MIN_SAFE_INTEGER;for(let t=0;t<I;++t){const a=n+t*T;if(a>=0&&a<m)for(let n=0;n<S;++n){const d=i+n*$;if(d>=0&&d<g){const i=U([e,a,d,o],c,M(s.shape)),f=U([t,n,o],p,M(r.shape)),m=u[i]+h[f];m>l&&(l=m)}}}R[U([e,t,a,o],A,M(C))]=l}}}return{dataId:l.write(er(R,s.dtype),C,s.dtype),shape:C,dtype:s.dtype}}},T$={kernelName:qe,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:l}=n,c=t,h=z(s.shape,c.data.get(s.dataId).values),p=z(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:S,outShape:T}=Mo(s.shape,r.shape,i,o,"NHWC",l);u(a.rank===T.length,(()=>`Error in Dilation2DBackpropFilter, dy must have the same rank as output ${T.length}, but got ${a.rank}`));const $=z(T,c.data.get(a.dataId).values),C=W(r.shape,r.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=0,l=0;for(let t=0;t<k;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*S;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=t,l=n)}}}C[o][l][a]+=$[e][t][s][a]}}}return{dataId:c.write(er(C,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},$$={kernelName:je,backendName:"cpu",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,filter:r,dy:a}=e,{strides:i,pad:o,dilations:l}=n,c=t,h=z(s.shape,c.data.get(s.dataId).values),p=z(r.shape,c.data.get(r.dataId).values),{batchSize:d,inHeight:f,inWidth:m,inChannels:g,outHeight:y,outWidth:b,padInfo:x,strideHeight:w,strideWidth:v,filterHeight:k,filterWidth:N,dilationHeight:I,dilationWidth:S,outShape:T}=Mo(s.shape,r.shape,i,o,"NHWC",l);u(a.rank===T.length,(()=>`Error in Dilation2DBackpropInput, dy must have the same rank as output ${T.length}, but got ${a.rank}`));const $=z(T,c.data.get(a.dataId).values),C=W(s.shape,s.dtype);for(let e=0;e<d;++e)for(let t=0;t<y;++t){const n=t*w-x.top;for(let s=0;s<b;++s){const r=s*v-x.left;for(let a=0;a<g;++a){let i=Number.MIN_SAFE_INTEGER,o=n<0?0:n,l=r<0?0:r;for(let t=0;t<k;++t){const s=n+t*I;if(s>=0&&s<f)for(let n=0;n<N;++n){const u=r+n*S;if(u>=0&&u<m){const r=h[e][s][u][a]+p[t][n][a];r>i&&(i=r,o=s,l=u)}}}C[e][o][l][a]+=$[e][t][s][a]}}}return{dataId:c.write(er(C,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function C$(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;let o;KN(r,"sum"),o="bool"===r.dtype?oI({inputs:{x:r},backend:n,attrs:{dtype:"int32"}}):sI({inputs:{x:r},backend:n});const l=o.shape.length,u=w(a,o.shape),c=ql(u,l);let h=u,p=o;null!=c&&(p=yS({inputs:{x:o},backend:n,attrs:{perm:c}}),h=Xl(h.length,l)),jl("sum",h,p.shape.length);const[f,m]=Gl(p.shape,h);let g=nI(n,f,$r(p.dtype,"int32"));const y=d(m),b=n.data.get(g.dataId).values,x=n.data.get(p.dataId).values;for(let e=0;e<b.length;++e){const t=e*y;let n=0;for(let e=0;e<y;++e)n+=x[t+e];b[e]=n}if(i){const e=g;g=mT({inputs:{x:g},backend:n,attrs:{shape:Hl(g.shape,u)}}),n.disposeIntermediateTensorInfo(e)}return n.disposeIntermediateTensorInfo(o),null!=c&&n.disposeIntermediateTensorInfo(p),g}const E$={kernelName:Cn,backendName:"cpu",kernelFunc:C$};const A$={kernelName:Xe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=Rd(r,a.length);Fd(i.length,l,a);const{path:u,steps:c}=Dd(o,l),h=c.length;let p=null,d=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=_d(d,l[t]);let r;Od(e)?r=a[t]:(r=yS({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);f(r.shape,i)||(r=mT({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=uS({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=C$({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-d),keepDims:!1}}),m.push(p)),d--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}};const R$={kernelName:Ze,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{dy:s,y:r}=t;KN([s,r],"eluGrad");const a=new Float32Array(d(r.shape)),i=n.data.get(r.dataId).values,o=n.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];a[e]=t>=1?o[e]:o[e]*(t+1)}return n.makeTensorInfo(r.shape,"float32",a)}},_$=bI(Je,(e=>{const t=Math.sign(e),n=Math.abs(e),s=1/(1+.3275911*n);return t*(1-((((1.061405429*s-1.453152027)*s+1.421413741)*s-.284496736)*s+.254829592)*s*Math.exp(-n*n))})),F$={kernelName:Je,backendName:"cpu",kernelFunc:_$};function D$(e){const{inputs:t,backend:n,attrs:s}=e,{input:r}=t,{dim:a}=s,i=r.shape.length,o=r.shape.slice();let l=a;return a<0&&(u(-(i+1)<=a,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),l=i+a+1),o.splice(l,0,1),mT({inputs:{x:r},backend:n,attrs:{shape:o}})}const O$={kernelName:tt,backendName:"cpu",kernelFunc:D$},M$=QN(((e,t)=>e/t)),L$=uI(Ke,M$),z$={kernelName:Ke,backendName:"cpu",kernelFunc:L$};function P$(e,t,n){const s=e.shape,r=s[0],a=s[1],i=n.data.get(e.dataId),o=i.complexTensorInfos.real,l=i.complexTensorInfos.imag,u=[r,a],c=d(u),h=k("float32",c),p=k("float32",c);for(let e=0;e<r;e++){const s=AS({inputs:{x:o},backend:n,attrs:{begin:[e,0],size:[1,a]}}),r=AS({inputs:{x:l},backend:n,attrs:{begin:[e,0],size:[1,a]}}),i=eI({inputs:{real:s,imag:r},backend:n}),{real:u,imag:c}=B$(i,t,n),d=vd(u,c);for(let t=0;t<a;t++){const n=Sd(d,t);h[e*a+t]=n.real,p[e*a+t]=n.imag}n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(i)}const f=n.makeTensorInfo(u,"float32",h),m=n.makeTensorInfo(u,"float32",p),g=eI({inputs:{real:f,imag:m},backend:n});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}function B$(e,t,n){const s=d(e.shape),r=n.data.get(e.dataId),a=n.data.get(r.complexTensorInfos.real.dataId).values,i=n.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((o=s)&o-1)){const r=W$(a,i,s,t,n),o=[e.shape[0],e.shape[1]];if(t){const e=n.makeTensorInfo(o,"float32",r.real),t=n.makeTensorInfo(o,"float32",r.imag),a=n.makeTensorInfo([],"float32",Qs(s,"float32")),i=sI({inputs:{x:a},backend:n}),l=z$.kernelFunc({inputs:{a:e,b:a},backend:n}),u=z$.kernelFunc({inputs:{a:t,b:i},backend:n}),c=n.data.get(l.dataId).values,h=n.data.get(u.dataId).values;return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),{real:c,imag:h}}return r}{const e=function(e,t,n){const s=new Float32Array(2*t);for(let r=0;r<t;r++){let a=0,i=0;for(let s=0;s<t;s++){const o=Cd(r*s,t,n),l=Sd(e,s);a+=l.real*o.real-l.imag*o.imag,i+=l.real*o.imag+l.imag*o.real}n&&(a/=t,i/=t),Td(s,a,i,r)}return s}(vd(a,i),s,t);return kd(e)}var o}function W$(e,t,n,s,r){if(1===n)return{real:e,imag:t};const a=vd(e,t),i=n/2,o=Nd(a),l=o.real,u=o.imag,c=[l.length],h=r.makeTensorInfo(c,"float32",l),p=r.makeTensorInfo(c,"float32",u),d=eI({inputs:{real:h,imag:p},backend:r}),f=Id(a),m=f.real,g=f.imag,y=[m.length],b=r.makeTensorInfo(y,"float32",m),x=r.makeTensorInfo(y,"float32",g),w=eI({inputs:{real:b,imag:x},backend:r}),v=W$(l,u,i,s,r),k=v.real,N=v.imag,I=[k.length],S=r.makeTensorInfo(I,"float32",k),T=r.makeTensorInfo(I,"float32",N),$=eI({inputs:{real:S,imag:T},backend:r}),C=W$(m,g,i,s,r),E=C.real,A=C.imag,R=[E.length],_=r.makeTensorInfo(R,"float32",E),F=r.makeTensorInfo(R,"float32",A),D=eI({inputs:{real:_,imag:F},backend:r}),O=$d(n,s),M=[O.real.length],L=r.makeTensorInfo(M,"float32",O.real),z=r.makeTensorInfo(M,"float32",O.imag),P=eI({inputs:{real:L,imag:z},backend:r}),B=uS({inputs:{a:P,b:D},backend:r}),W=dI({inputs:{a:$,b:B},backend:r}),V=XS({inputs:{a:$,b:B},backend:r}),U=aI({inputs:{input:W},backend:r}),G=aI({inputs:{input:V},backend:r}),H=e$({inputs:{input:W},backend:r}),j=e$({inputs:{input:V},backend:r}),q=n$({inputs:[U,G],backend:r,attrs:{axis:0}}),K=n$({inputs:[H,j],backend:r,attrs:{axis:0}}),X=r.data.get(q.dataId).values,Y=r.data.get(K.dataId).values;return r.disposeIntermediateTensorInfo(h),r.disposeIntermediateTensorInfo(p),r.disposeIntermediateTensorInfo(d),r.disposeIntermediateTensorInfo(b),r.disposeIntermediateTensorInfo(x),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(T),r.disposeIntermediateTensorInfo($),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(F),r.disposeIntermediateTensorInfo(D),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(z),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(B),r.disposeIntermediateTensorInfo(W),r.disposeIntermediateTensorInfo(V),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(H),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(K),{real:X,imag:Y}}const V$={kernelName:st,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=d(s.shape),a=s.shape[s.shape.length-1],i=mT({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=P$(i,!1,n),l=mT({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}};function U$(e){const{backend:t,attrs:n}=e,{shape:s,value:r,dtype:a}=n,i=a||F(r),o=N(i,d(s));return function(e,t,n){e.fill(t)}(o,r),t.makeTensorInfo(s,i,o)}const G$={kernelName:rt,backendName:"cpu",kernelFunc:U$};const H$={kernelName:at,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,r=n,a=k(s.dtype,d(s.shape)),[i,o,l,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*l*o*u;for(let e=0;e<o;e++){const n=e*(l*u);for(let e=0;e<l;e++){const s=e*u;for(let r=0;r<u;r++){const i=Math.round(l-e-1),o=t+n+s+r;let h=c[o];if(i>=0&&i<l){h=c[t+n+i*u+r]}a[o]=h}}}}return{dataId:r.write(a,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},j$=QN(((e,t)=>Math.floor(e/t))),q$=uI(ot,j$,null,"int32"),K$={kernelName:ot,backendName:"cpu",kernelFunc:q$};const X$={kernelName:rs,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=r$({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;if("NCHW"===c&&1===i.shape.length&&1!==i.shape[0]){const e=mT({inputs:{x:i},backend:n,attrs:{shape:[i.shape[0],1,1]}});m=dI({inputs:{a:m,b:e},backend:n}),n.disposeIntermediateTensorInfo(e)}else m=dI({inputs:{a:m,b:i},backend:n});n.disposeIntermediateTensorInfo(e)}if(d){const e=m;if("NCHW"===c&&"prelu"===d&&1===o.shape.length&&1!==o.shape[0]){const e=mT({inputs:{x:o},backend:n,attrs:{shape:[o.shape[0],1,1]}});m=fT(n,m,d,e,f),n.disposeIntermediateTensorInfo(e)}else m=fT(n,m,d,o,f);n.disposeIntermediateTensorInfo(e)}return m}};const Y$={kernelName:as,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s;let m=w$({inputs:{x:r,filter:a},backend:n,attrs:{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p}});if(i){const e=m;m=dI({inputs:{a:m,b:i},backend:n}),n.disposeIntermediateTensorInfo(e)}if(d){const e=m;m=fT(n,m,d,o,f),n.disposeIntermediateTensorInfo(e)}return m}};const Z$={kernelName:ct,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=d(s.shape),i=r.shape,o=i[i.length-1],[l,u,c,h]=Bi(s,r);if(0===u)return n.makeTensorInfo(l,s.dtype,[]);const p=MI(n.data.get(r.dataId).values,n.bufferSync(s),s.dtype,u,o,c,h,s.shape,a);return n.makeTensorInfo(l,s.dtype,p.values)}};const J$={kernelName:ut,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s;KN([r,a],"gatherV2");const l=w(i,r.shape)[0],c=n.data.get(a.dataId).values,h=r.shape[l];for(let e=0;e<c.length;++e){const t=c[e];u(t<=h-1&&t>=0,(()=>`GatherV2: the index value ${t} is not in [0, ${h-1}]`))}let p=o;null==o&&(p=0);const f=d(a.shape),m=Jd(r,a,l,p),g=mT({inputs:{x:r},backend:n,attrs:{shape:[m.batchSize,m.outerSize,m.dimSize,m.sliceSize]}}),y=mT({inputs:{x:a},backend:n,attrs:{shape:[m.batchSize,f/m.batchSize]}}),b=[m.batchSize,m.outerSize,f/m.batchSize,m.sliceSize],x=n.bufferSync(y),v=LI(n.bufferSync(g),x,b);return n.disposeIntermediateTensorInfo(g),n.disposeIntermediateTensorInfo(y),n.makeTensorInfo(m.outputShape,v.dtype,v.values)}};const Q$={kernelName:ft,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t,r=d(s.shape),a=s.shape[s.shape.length-1],i=mT({inputs:{x:s},backend:n,attrs:{shape:[r/a,a]}}),o=P$(i,!0,n),l=mT({inputs:{x:o},backend:n,attrs:{shape:s.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(o),l}},eC=bI(gt,(e=>Number.isFinite(e)?1:0),"bool"),tC={kernelName:gt,backendName:"cpu",kernelFunc:eC},nC=bI(yt,(e=>Math.abs(e)===1/0?1:0),"bool"),sC={kernelName:yt,backendName:"cpu",kernelFunc:nC},rC=bI(bt,(e=>Number.isNaN(e)?1:0),"bool"),aC={kernelName:bt,backendName:"cpu",kernelFunc:rC};const iC={kernelName:kt,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=YI(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},oC=bI(It,(e=>Math.log1p(e))),lC={kernelName:It,backendName:"cpu",kernelFunc:oC},uC=QN(((e,t)=>e&&t)),cC=uI(St,uC,null,"bool"),hC={kernelName:St,backendName:"cpu",kernelFunc:cC},pC=bI(Tt,(e=>e?0:1),"bool"),dC={kernelName:Tt,backendName:"cpu",kernelFunc:pC},fC=QN(((e,t)=>e||t)),mC=uI($t,fC,null,"bool"),gC={kernelName:$t,backendName:"cpu",kernelFunc:mC};const yC={kernelName:Et,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s;KN(r,"LRN");const u=r.shape[3],c=u-1,h=n.data.get(r.dataId).values,p=d(r.shape),f=new Float32Array(p);function m(e){const t=e%u;let n=e-t+Math.max(0,t-a);const s=e-t+Math.min(t+a,c);let r=0;for(;n<=s;n++){const e=h[n];r+=e*e}return r}for(let e=0;e<p;e++){const t=m(e),n=h[e]*Math.pow(i+o*t,-l);f[e]=n}return n.makeTensorInfo(r.shape,r.dtype,f)}};const bC={kernelName:At,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s;KN(i,"LRNGrad");const h=d(i.shape),p=i.shape[3],f=n.data.get(i.dataId).values,m=n.data.get(r.dataId).values,g=n.data.get(a.dataId).values,y=new Float32Array(h),b=h;for(let e=0;e<b;e++){const t=e%p,n=e-t+Math.max(0,t-o),s=e-t+Math.min(p,t+o+1);let r=0;for(let e=n;e<s;e++)r+=Math.pow(m[e],2);r=u*r+l;for(let t=n;t<s;t++){let n=-2*u*c*m[t]*g[e]/r;e===t&&(n+=Math.pow(r,-c)),n*=f[e],y[t]+=n}}return n.makeTensorInfo(i.shape,r.dtype,y)}};function xC(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=n;let l=r.shape;const u=l.length,c=w(a,l);let h=c;const p=ql(h,u);let f=o.data.get(r.dataId).values;if(null!=p){const e=new Array(u);for(let t=0;t<e.length;t++)e[t]=l[p[t]];f=gS(f,l,r.dtype,p,e),h=Xl(h.length,u),l=e}KN(r,"max"),jl("max",h,u);const[m,g]=Gl(l,h),y=eS(f,d(g),m,r.dtype),b=o.write(y,m,r.dtype);let x=m;if(i){x=Hl(m,c)}return{dataId:b,shape:x,dtype:r.dtype}}const wC={kernelName:Rt,backendName:"cpu",kernelFunc:xC};const vC={kernelName:Ft,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;KN(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(qo(i,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Lo(r.shape,a,i,1,o,l);let h;if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))h=sI({inputs:{x:r},backend:n});else{const e=n.data.get(r.dataId).values,t=M(r.shape),s=BT(e,r.shape,r.dtype,t,c,"max");h=n.makeTensorInfo(c.outShape,r.dtype,s.values)}return h}};const kC={kernelName:Ot,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s;KN(r,"maxPool3d");const c=zo(r.shape,a,i,1,o,l,u),h=VT(n.data.get(r.dataId).values,r.shape,r.dtype,M(r.shape),c,"max");return n.makeTensorInfo(h.shape,"float32",h.values)}};const NC={kernelName:Mt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,{filterSize:i,strides:o,pad:l,dimRoundingMode:u}=s;KN([r,a],"maxPool3DGrad");const c=zo(a.shape,i,o,1,l,u),h=function(e,t){const n=ja(t.outShape,"int32"),s=t.strideDepth,r=t.strideHeight,a=t.strideWidth,i=t.dilationDepth,o=t.dilationHeight,l=t.dilationWidth,u=t.effectiveFilterDepth,c=t.effectiveFilterHeight,h=t.effectiveFilterWidth,p=t.padInfo.front,d=t.padInfo.top,f=t.padInfo.left;for(let m=0;m<t.batchSize;++m)for(let g=0;g<t.inChannels;++g)for(let y=0;y<t.outDepth;++y){const b=y*s-p;let x=b;for(;x<0;)x+=i;const w=Math.min(t.inDepth,u+b);for(let s=0;s<t.outHeight;++s){const u=s*r-d;let p=u;for(;p<0;)p+=o;const v=Math.min(t.inHeight,c+u);for(let r=0;r<t.outWidth;++r){const d=r*a-f;let k=d;for(;k<0;)k+=l;const N=Math.min(t.inWidth,h+d);let I=Number.NEGATIVE_INFINITY,S=-1;for(let t=x;t<w;t+=i){const n=t-b;for(let s=p;s<v;s+=o){const r=s-u;for(let a=k;a<N;a+=l){const i=a-d,o=e.get(m,t,s,a,g);o>=I&&(I=o,S=n*c*h+r*c+i)}}}n.set(S,m,y,s,r,g)}}}return n}(n.bufferSync(a),c),p=c.strideDepth,d=c.strideHeight,f=c.strideWidth,m=c.dilationDepth,g=c.dilationHeight,y=c.dilationWidth,b=c.effectiveFilterDepth,x=c.effectiveFilterHeight,w=c.effectiveFilterWidth,v=b-1-c.padInfo.front,k=w-1-c.padInfo.left,N=x-1-c.padInfo.top,I=ja(a.shape,"float32"),S=n.bufferSync(r);for(let e=0;e<c.batchSize;++e)for(let t=0;t<c.inChannels;++t)for(let n=0;n<c.inDepth;++n)for(let s=0;s<c.inHeight;++s)for(let r=0;r<c.inWidth;++r){const a=n-v,i=s-N,o=r-k;let l=0;for(let n=0;n<b;n+=m){const s=(a+n)/p;if(!(s<0||s>=c.outDepth||Math.floor(s)!==s))for(let r=0;r<x;r+=g){const a=(i+r)/d;if(!(a<0||a>=c.outHeight||Math.floor(a)!==a))for(let i=0;i<w;i+=y){const u=(o+i)/f;if(u<0||u>=c.outWidth||Math.floor(u)!==u)continue;const p=b*x*w-1-h.get(e,s,a,u,t)===n*x*w+r*w+i?1:0;if(0===p)continue;l+=S.get(e,s,a,u,t)*p}}}I.set(l,e,n,s,r,t)}return n.makeTensorInfo(I.shape,I.dtype,I.values)}};const IC={kernelName:Dt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;KN([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Lo(o.shape,l,u,1,c,h),d=n.data.get(o.dataId).values,f=ja(p.outShape,o.dtype,WT(d,o.shape,o.dtype,p).values),m=p.strideHeight,g=p.strideWidth,y=p.dilationHeight,b=p.dilationWidth,x=p.effectiveFilterHeight,w=p.effectiveFilterWidth,v=w-1-p.padInfo.left,k=x-1-p.padInfo.top,N=ja(o.shape,"float32"),I=n.data.get(r.dataId).values,S=ja(r.shape,"float32",I);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let s=0;s<p.inWidth;++s){const r=n-k,a=s-v;let i=0;for(let n=0;n<x;n+=y){const s=(r+n)/m;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let r=0;r<w;r+=b){const o=(a+r)/g;if(o<0||o>=p.outWidth||Math.floor(o)!==o)continue;const l=x*w-1-f.get(e,s,o,t)===n*w+r?1:0;if(0===l)continue;i+=S.get(e,s,o,t)*l}}N.set(i,e,n,s,t)}return n.makeTensorInfo(N.shape,N.dtype,N.values)}};const SC={kernelName:Lt,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;KN(s,"MaxPoolWithArgmax");const u=l.data.get(s.dataId).values,c=Lo(s.shape,r,a,[1,1],i),[h,p]=function(e,t,n,s,r){const a=BT(e,0,n,M(t),r,"max"),i=WT(e,t,n,r,!0,s);return[a.values,i.values]}(u,s.shape,s.dtype,o,c),d=l.write(h,c.outShape,s.dtype),f=l.write(p,c.outShape,s.dtype);return[{dataId:d,shape:c.outShape,dtype:s.dtype},{dataId:f,shape:c.outShape,dtype:"int32"}]}};const TC={kernelName:zt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=w(a,r.shape),l=d(Gl(r.shape,o)[1]),u=[],c=n.makeTensorInfo([],"float32",new Float32Array([l]));u.push(c);const h=oI({inputs:{x:r},backend:n,attrs:{dtype:"float32"}});u.push(h);const p=L$({inputs:{a:h,b:c},backend:n});u.push(p);const f=C$({inputs:{x:p},backend:n,attrs:{axis:a,keepDims:i}});return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),f}};const $C={kernelName:Pt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;KN(r,"min");const o=w(a,r.shape);let l=o;const u=ql(l,r.shape.length);let c=r;null!=u&&(c=yS({inputs:{x:r},backend:n,attrs:{perm:u}}),l=Xl(l.length,r.shape.length)),jl("min",l,c.shape.length);const[h,p]=Gl(c.shape,l),f=d(p),m=B(d(h),c.dtype),g=n.data.get(c.dataId).values;for(let e=0;e<m.length;++e){const t=e*f;let n=g[t];for(let e=0;e<f;++e){const s=g[t+e];(Number.isNaN(s)||s<n)&&(n=s)}m[e]=n}null!=u&&n.disposeIntermediateTensorInfo(c);const y=n.makeTensorInfo(h,c.dtype,m);if(i){const e=mT({inputs:{x:y},backend:n,attrs:{shape:Hl(h,o)}});return n.disposeIntermediateTensorInfo(y),e}return y}};const CC={kernelName:Wt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,mode:i}=s;KN(r,"mirrorPad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=a.map(((e,t)=>e[0]+r.shape[t])),c="reflect"===i?0:1,h=n.data.get(r.dataId).values,p=r.shape.length,f=M(r.shape),m=d(o),g=o.length,y=M(o),b=k(r.dtype,m);for(let e=0;e<m;e++){let t=G(e,g,y);for(let e=0;e<g;e++)t[e]<l[e]?t[e]=2*l[e]-t[e]-c:t[e]>=u[e]&&(t[e]=2*(u[e]-1)-t[e]+c);t=t.map(((e,t)=>e-l[t]));const n=U(t,p,f);b[e]=h[n]}return{dataId:n.write(b,o,r.dtype),shape:o,dtype:r.dtype}}},EC=QN(((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t})),AC=uI(Vt,EC),RC={kernelName:Vt,backendName:"cpu",kernelFunc:AC};function _C(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=r.shape.length;let o=a;if(-1===o&&(o=i-1),o!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${o}`);const l=w([o],r.shape),u=xC({inputs:{x:r},backend:n,attrs:{reductionIndices:l,keepDims:!1}}),c=Hl(u.shape,l),h=mT({inputs:{x:u},backend:n,attrs:{shape:c}}),p=XS({inputs:{a:r,b:h},backend:n}),d=CI({inputs:{x:p},backend:n}),f=C$({inputs:{x:d},backend:n,attrs:{axis:l,keepDims:!1}}),m=mT({inputs:{x:f},backend:n,attrs:{shape:c}}),g=L$({inputs:{a:d,b:m},backend:n});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}const FC={kernelName:Rn,backendName:"cpu",kernelFunc:_C};const DC={kernelName:Ut,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s;KN(r,"multinomial");const l=o?r:_C({inputs:{logits:r},backend:n,attrs:{dim:-1}}),u=l.shape[0],c=l.shape[1],h=n.data.get(l.dataId).values,p=[u,a],f=B(d(p),"int32");for(let e=0;e<u;++e){const t=e*c,n=new Float32Array(c-1);n[0]=h[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+h[t+e];const s=Nc(i.toString()),r=e*a;for(let e=0;e<a;++e){const t=s();f[r+e]=n.length;for(let s=0;s<n.length;s++)if(t<n[s]){f[r+e]=s;break}}}return o||n.disposeIntermediateTensorInfo(l),n.makeTensorInfo(p,"int32",f)}},OC=np;const MC={kernelName:qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s;KN(r,"NonMaxSuppression");const u=n.data.get(r.dataId).values,c=n.data.get(a.dataId).values,{selectedIndices:h}=OC(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},LC=sp;const zC={kernelName:Kt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s;KN(r,"NonMaxSuppressionPadded");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,{selectedIndices:p,validOutputs:d}=LC(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},PC=rp;const BC={kernelName:Xt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s;KN(r,"NonMaxSuppressionWithScore");const c=n.data.get(r.dataId).values,h=n.data.get(a.dataId).values,p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=PC(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};const WC={kernelName:Zt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s;KN(r,"oneHot");const l=d(r.shape),u=new Float32Array(l*a);u.fill(o);const c=n.data.get(r.dataId).values;for(let e=0;e<l;++e)c[e]>=0&&c[e]<a&&(u[e*a+c[e]]=i);return n.makeTensorInfo([...r.shape,a],"int32",u)}};function VC(e){const{inputs:t,backend:n}=e,{x:s}=t;if("string"===s.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===s.dtype){const e=aI({inputs:{input:s},backend:n}),t=VC({inputs:{x:e},backend:n}),r=e$({inputs:{input:s},backend:n}),a=VC({inputs:{x:r},backend:n}),i=eI({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return U$({backend:n,attrs:{shape:s.shape,value:0,dtype:s.dtype}})}const UC={kernelName:Qn,backendName:"cpu",kernelFunc:VC};const GC={kernelName:Yt,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===r.dtype){const t=aI({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=e$({inputs:{input:r},backend:s}),i=VC({inputs:{x:a},backend:s}),o=eI({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return U$({backend:s,attrs:{shape:r.shape,value:1,dtype:r.dtype}})}};function HC(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return D$({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach((e=>{c(a,e.shape,"All tensors passed to stack must have matching shapes"),u(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],l=n$({inputs:t.map((e=>{const t=D$({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t})),backend:n,attrs:{axis:r}});return o.forEach((e=>n.disposeIntermediateTensorInfo(e))),l}const jC={kernelName:Jt,backendName:"cpu",kernelFunc:HC};const qC={kernelName:Qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;KN(r,"pad");const o=a.map(((e,t)=>e[0]+r.shape[t]+e[1])),l=a.map((e=>e[0])),u=n.data.get(r.dataId).values,c=d(r.shape),h=r.shape.length,p=M(r.shape),f=d(o),m=o.length,g=M(o),y=k(r.dtype,f);0!==i&&y.fill(i);for(let e=0;e<c;e++){y[U(G(e,h,p).map(((e,t)=>e+l[t])),m,g)]=u[e]}return{dataId:n.write(y,o,r.dtype),shape:o,dtype:r.dtype}}},KC=QN(((e,t)=>Math.pow(e,t))),XC=uI(en,KC),YC={kernelName:en,backendName:"cpu",kernelFunc:XC};const ZC={kernelName:sn,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,dtype:a,step:i}=n,o=vS(s,r,i,a);return t.makeTensorInfo([o.length],a,o)}},JC=bI(an,(e=>1/e)),QC={kernelName:an,backendName:"cpu",kernelFunc:JC};const eE={kernelName:hn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;KN(r,"resizeBilinear");const l=M(r.shape),[u,c]=o,[h,p,f,m]=r.shape,g=n.data.get(r.dataId).values,y=new Float32Array(d([h,u,c,m])),b=[a&&u>1?p-1:p,a&&c>1?f-1:f],x=[a&&u>1?u-1:u,a&&c>1?c-1:c];let w=0;const v=b[0]/x[0],k=b[1]/x[1];for(let e=0;e<h;e++)for(let t=0;t<u;t++){let n;n=i?v*(t+.5)-.5:v*t;const s=Math.max(0,Math.floor(n)),r=n-s,a=Math.min(p-1,Math.ceil(n)),o=e*l[0]+s*l[1],u=e*l[0]+a*l[1];for(let e=0;e<c;e++){let t;t=i?k*(e+.5)-.5:k*e;const n=Math.max(0,Math.floor(t)),s=t-n,a=Math.min(f-1,Math.ceil(t)),c=o+n*l[2],h=u+n*l[2],p=o+a*l[2],d=u+a*l[2];for(let e=0;e<m;e++){const t=g[c+e],n=g[h+e],a=t+(g[p+e]-t)*s,i=a+(n+(g[d+e]-n)*s-a)*r;y[w++]=i}}}return n.makeTensorInfo([h,u,c,m],"float32",y)}};const tE={kernelName:pn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;KN([a,r],"resizeBilinearGrad");const o=M(r.shape),[l,u,c,h]=r.shape,[,p,d]=a.shape,f=new Float32Array(l*u*c*h),m=[i&&p>1?u-1:u,i&&d>1?c-1:c],g=[i&&p>1?p-1:p,i&&d>1?d-1:d],y=m[0]/g[0],b=m[1]/g[1],x=n.data.get(a.dataId).values;let w=0;for(let e=0;e<l;e++){const t=e*o[0];for(let e=0;e<p;e++){const n=e*y,s=Math.floor(n),r=Math.min(Math.ceil(n),u-1),a=t+s*o[1],i=t+r*o[1],l=n-s,p=1-l;for(let e=0;e<d;e++){const t=e*b,n=Math.floor(t),s=Math.min(Math.ceil(t),c-1),r=t-n,u=1-r,d=a+n*o[2],m=a+s*o[2],g=i+n*o[2],y=i+s*o[2],v=p*u,k=p*r,N=l*u,I=l*r;for(let e=0;e<h;e++){const t=x[w++];f[d+e]+=t*v,f[m+e]+=t*k,f[g+e]+=t*N,f[y+e]+=t*I}}}}return n.makeTensorInfo([l,c,u,h],"float32",f)}};const nE={kernelName:un,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s;KN(r,"resizeNearestNeighbor");const l=M(r.shape),[u,c]=o,[h,p,d,f]=r.shape,m=n.data.get(r.dataId).values,g=new Float32Array(h*u*c*f),y=[a&&u>1?p-1:p,a&&c>1?d-1:d],b=[a&&u>1?u-1:u,a&&c>1?c-1:c],x=y[0]/b[0],w=y[1]/b[1];let v=0;for(let e=0;e<h;e++){const t=e*l[0];for(let e=0;e<u;e++){const n=i?x*(e+.5):x*e;let s=Math.min(p-1,a?Math.round(n):Math.floor(n));i&&(s=Math.max(0,s));const r=t+s*l[1];for(let e=0;e<c;e++){const t=i?w*(e+.5):w*e;let n=Math.min(d-1,a?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const s=r+n*l[2];for(let e=0;e<f;e++){const t=m[s+e];g[v++]=t}}}}return n.makeTensorInfo([h,u,c,f],r.dtype,g)}};const sE={kernelName:cn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s;KN([a,r],"resizeNearestNeighborGrad");const o=M(r.shape),l=M(a.shape),[u,c,h,p]=r.shape,[,d,f]=a.shape,m=new Float32Array(u*c*h*p),g=n.data.get(a.dataId).values,y=[i&&d>1?c-1:c,i&&f>1?h-1:h],b=[i&&d>1?d-1:d,i&&f>1?f-1:f],x=y[0]/b[0],w=y[1]/b[1],v=1/x,k=1/w,N=2*Math.ceil(v)+2,I=2*Math.ceil(k)+2;for(let e=0;e<u;e++){const t=e*o[0];for(let e=0;e<c;e++){const n=t+e*o[1],s=Math.floor(e*v),r=Math.floor(s-N/2);for(let s=0;s<h;s++){const a=n+s*o[2],u=Math.floor(s*k),y=Math.floor(u-I/2);for(let n=0;n<p;n++){let o=0;for(let a=0;a<N;a++){const u=a+r;if(u<0||u>=d)continue;const p=t+u*l[1],m=u*x;if(e===Math.min(c-1,i?Math.round(m):Math.floor(m)))for(let e=0;e<I;e++){const t=e+y;if(t<0||t>=f)continue;const r=p+t*l[2],a=t*w;s===Math.min(h-1,i?Math.round(a):Math.floor(a))&&(o+=g[r+n])}}m[a+n]=o}}}}return n.makeTensorInfo(r.shape,r.dtype,m)}};const rE={kernelName:fn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s;KN(r,"reverse");const i=r.shape.length,o=w(a,r.shape);if(0===i)return sI({inputs:{x:r},backend:n});const l=new fr(r.shape,r.dtype),u=n.bufferSync(r);for(let e=0;e<l.size;e++){const t=l.indexToLoc(e),n=t.slice();o.forEach((e=>n[e]=r.shape[e]-1-n[e])),l.set(u.get(...n),...t)}return n.makeTensorInfo(l.shape,l.dtype,l.values)}},aE={kernelName:ns,backendName:"cpu",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=k(s.dtype,d(s.shape)),[u,c,h,p]=s.shape,[f,m]=od(i,c,h),g=Math.sin(r),y=Math.cos(r),b=o.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*h*c*p;for(let e=0;e<c;e++){const n=e*(h*p);for(let s=0;s<h;s++){const r=s*p;for(let i=0;i<p;i++){const o=[u,e,s,i],d=o[2],x=o[1];let w=(d-f)*y-(x-m)*g,v=(d-f)*g+(x-m)*y;w=Math.round(w+f),v=Math.round(v+m);let k=a;if("number"!=typeof a&&(k=3===i?255:a[i]),w>=0&&w<h&&v>=0&&v<c){k=b[t+v*(h*p)+w*p+i]}l[t+n+r+i]=k}}}}return{dataId:o.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},iE=bI(mn,(e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})),oE={kernelName:mn,backendName:"cpu",kernelFunc:iE};const lE={kernelName:yn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Gi(0,r,i),p=SS(n.bufferSync(r),n.bufferSync(a),i,h,u,l,o,c,0,!0);return n.makeTensorInfo(i,p.dtype,p.values)}};function uE(e,t){let n=0,s=e.length,r=0;for(;n<s;)r=Math.floor((n+s)/2),e[r]<t?n=r+1:s=r;return s}function cE(e,t){let n=0,s=e.length,r=0;for(;n<s;)r=Math.floor((n+s)/2),e[r]<=t?n=r+1:s=r;return s}const hE={kernelName:bn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sortedSequence:r,values:a}=t,{side:i}=s,o=function(e,t,n,s,r,a){const i=N("int32",n*r);for(let o=0;o<n;++o){const n=e.slice(o*s,(o+1)*s),l=o*r;for(let e=0;e<r;++e)i[l+e]="left"===a?uE(n,t[e+l]):cE(n,t[e+l])}return i}(n.data.get(r.dataId).values,n.data.get(a.dataId).values,r.shape[0],r.shape[1],a.shape[1],i);return n.makeTensorInfo(a.shape,"int32",o)}};const pE={kernelName:xn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{condition:s,t:r,e:a}=t;KN([s,r,a],"select");const i=s.shape.length,o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=$r(r.dtype,a.dtype),h=B(d(r.shape),c);let p=0;const f=0===i||i>1||1===r.shape.length?1:d(r.shape.slice(1));for(let e=0;e<o.length;e++)for(let t=0;t<f;t++)1===o[e]?h[p++]=l[e]:h[p++]=u[e];return n.makeTensorInfo(r.shape,c,h)}},dE=bI(wn,(e=>e>=0?1.0507009873554805*e:1.7580993408473768*(Math.exp(e)-1))),fE={kernelName:wn,backendName:"cpu",kernelFunc:dE},mE=bI(In,(e=>e<0?-1:e>0?1:0)),gE={kernelName:In,backendName:"cpu",kernelFunc:mE},yE=bI(kn,(e=>Math.sin(e))),bE={kernelName:kn,backendName:"cpu",kernelFunc:yE},xE=bI(Nn,(e=>Math.sinh(e))),wE={kernelName:Nn,backendName:"cpu",kernelFunc:xE},vE=Math.log(1.1920928955078125e-7)+2,kE=bI(Tn,(e=>{const t=e>-vE,n=e<vE,s=Math.exp(e);let r;return r=n?s:t?e:Math.log(1+s),r})),NE={kernelName:Tn,backendName:"cpu",kernelFunc:kE};const IE={kernelName:En,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,paddings:i}=s;KN([r],"spaceToBatchND");const o=d(a),l=[[0,0]];l.push(...i);for(let e=1+a.length;e<r.shape.length;++e)l.push([0,0]);const u=qC.kernelFunc({inputs:{x:r},backend:n,attrs:{paddings:l,constantValue:0}}),c=ld(u.shape,a,o,!1),h=ud(c.length,a.length,!1),p=cd(u.shape,a,o,!1),f=mT({inputs:{x:u},backend:n,attrs:{shape:c}}),m=yS({inputs:{x:f},backend:n,attrs:{perm:h}}),g=mT({inputs:{x:m},backend:n,attrs:{shape:p}});return n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),g}};const SE={kernelName:_n,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:s,values:r,denseShape:a,defaultValue:i}=t;if(1!==a.shape.length)throw new Error(`Dense shape must be a vector, saw:\n        ${a.shape}`);if(2!==s.shape.length)throw new Error(`Indices must be a matrix, saw:\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Values must be a vector, saw:\n        ${r.shape}`);if(0!==i.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${i.shape}`);const o=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,u=n.data.get(a.dataId).values,c=n.data.get(i.dataId).values[0],[h,p,d,f,m]=_S(o,s.shape,s.dtype,l,r.dtype,u,c);return[n.makeTensorInfo(p,s.dtype,h),n.makeTensorInfo([p[0]],r.dtype,d),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],s.dtype,new Int32Array(m))]}};const TE={kernelName:Fn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:s,inputShape:r,newShape:a}=t;if(2!==s.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${r.shape}`);if(1!==a.shape.length)throw new Error(`Target shape should be a vector but received shape ${a.shape}`);const i=Array.from(n.data.get(r.dataId).values),o=n.data.get(s.dataId).values,l=Array.from(n.data.get(a.dataId).values),[u,c,h]=FS(o,s.shape,s.dtype,i,l);return[n.makeTensorInfo(c,s.dtype,u),n.makeTensorInfo([h.length],a.dtype,new Int32Array(h))]}};const $E={kernelName:Dn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:s,indices:r,segmentIds:a}=t;if(s.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n          ${r.shape}`);if(1!==a.shape.length)throw new Error(`Segment ids should be a vector but received shape\n          ${a.shape}`);if(r.shape[0]!==a.shape[0])throw new Error("segmentIds and indices should have same size.");const i=n.data.get(s.dataId).values,o=n.data.get(r.dataId).values,l=n.data.get(a.dataId).values,[u,c]=DS(i,s.shape,s.dtype,o,l,!0);return n.makeTensorInfo(c,s.dtype,u)}};const CE={kernelName:On,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:s,indices:r,segmentIds:a}=t;if(s.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.shape.length)throw new Error(`Indices should be a vector but received shape\n         ${r.shape}`);if(1!==a.shape.length)throw new Error(`Segment ids should be a vector but received shape\n         ${a.shape}`);if(r.shape[0]!==a.shape[0])throw new Error("segmentIds and indices should have same size.");const i=n.data.get(s.dataId).values,o=n.data.get(r.dataId).values,l=n.data.get(a.dataId).values,[u,c]=DS(i,s.shape,s.dtype,o,l);return n.makeTensorInfo(c,s.dtype,u)}};const EE={kernelName:Mn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{sparseIndices:r,sparseValues:a,defaultValue:i}=t,{outputShape:o}=s,{sliceRank:l,numUpdates:u,sliceSize:c,strides:h,outputSize:p}=Gi(0,r,o),d=!1,f=n.bufferSync(r);let m;switch(a.dtype){case"bool":m=SS(f,n.bufferSync(a),o,p,c,u,l,h,Boolean(n.data.get(i.dataId).values[0]),d);break;case"float32":m=SS(f,n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],d);break;case"int32":m=SS(f,n.bufferSync(a),o,p,c,u,l,h,n.data.get(i.dataId).values[0],d);break;case"string":m=SS(f,n.bufferSync(a),o,p,c,u,l,h,rr(n.data.get(i.dataId).values[0]),d);break;default:throw new Error(`Unsupported type ${a.dtype}`)}return n.makeTensorInfo(o,m.dtype,m.values)}};const AE={kernelName:An,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{numOrSizeSplits:a,axis:i}=s,o=w(i,r.shape)[0],l=Ld(r,a,o),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return l.map((e=>{const t=[...c];t[o]=e;const s=AS({inputs:{x:r},backend:n,attrs:{begin:u,size:t}});return u[o]+=e,s}))}},RE={kernelName:zn,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,s=t;KN(n,"square");const r=s.data.get(n.dataId).values,a=new Float32Array(r.length);for(let e=0;e<r.length;++e){const t=r[e];a[e]=t*t}return{dataId:s.write(a,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},_E=bI(es,((e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})),FE={kernelName:es,backendName:"cpu",kernelFunc:_E};const DE={kernelName:Pn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,end:i,strides:o,beginMask:l,endMask:c,ellipsisMask:h,newAxisMask:p,shrinkAxisMask:d}=s;KN(r,"stridedSlice");const{finalShapeSparse:f,finalShape:m,isIdentity:g,sliceDim0:y,isSimpleSlice:b,begin:x,end:w,strides:v}=ao(r.shape,a,i,o,l,c,h,p,d);let k;if(g)k=mT({inputs:{x:r},backend:n,attrs:{shape:m}});else if(y||b){u(r.shape.length>=1,(()=>`Input must have rank at least 1, got: ${r.shape.length}`));const e=qi(x,w,v),t=AS({inputs:{x:r},backend:n,attrs:{begin:x,size:e}});k=mT({inputs:{x:t},backend:n,attrs:{shape:m}}),n.disposeIntermediateTensorInfo(t)}else{const e=WS(f,n.bufferSync(r),v,x);k=n.makeTensorInfo(m,e.dtype,e.values)}return k}};const OE={kernelName:Bn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{separator:r,nGramWidths:a,leftPad:i,rightPad:o,padWidth:l,preserveShortSequences:u}=s,{data:c,dataSplits:h}=t,p=n.data.get(c.dataId).values,d=n.data.get(h.dataId).values,[f,m]=US(p,d,r,a,i,o,l,u);return[n.makeTensorInfo([f.length],"string",f),n.makeTensorInfo(h.shape,"int32",m)]}};const ME={kernelName:Wn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{skipEmpty:r}=s,{input:a,delimiter:i}=t;if("string"!==a.dtype)throw new Error("Input must be of datatype string");if(1!==a.shape.length)throw new Error(`Input must be a vector, got shape: ${a.shape}`);if(0!==i.shape.length)throw new Error(`Delimiter must be a scalar, got shape: ${i.shape}`);const o=n.data.get(a.dataId).values,l=n.data.get(i.dataId).values[0],[u,c,h]=HS(o,l,r),p=c.length;return[n.makeTensorInfo([p,2],"int32",u),n.makeTensorInfo([p],"string",c),n.makeTensorInfo([2],"int32",new Int32Array(h))]}};const LE={kernelName:Vn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{numBuckets:r}=s,{input:a}=t;if("string"!==a.dtype)throw new Error("Input must be of datatype string");if(r<=0)throw new Error("Number of buckets must be at least 1");const i=jS(n.data.get(a.dataId).values,r);return n.makeTensorInfo(a.shape,"int32",i)}},zE=bI(Gn,(e=>Math.tan(e))),PE={kernelName:Gn,backendName:"cpu",kernelFunc:zE},BE=bI(Hn,(e=>Math.tanh(e)));const WE={kernelName:jn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reps:a}=s;KN(r,"tile");const i=ZS(n.bufferSync(r),a);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const VE={kernelName:qn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{k:a,sorted:i}=s;KN(r,"topk");const o=n.data.get(r.dataId).values,[l,u]=eT(o,r.shape,r.dtype,a,i);return[n.makeTensorInfo(l.shape,l.dtype,l.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const UE={kernelName:Kn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{image:r,transforms:a}=t,{interpolation:i,fillMode:o,fillValue:l,outputShape:u}=n,[c,h,p,f]=r.shape,[m,g]=null!=u?u:[h,p],y=[c,m,g,f],b=M(r.shape),x=b[0],w=b[1],v=b[2],N=k(r.dtype,d(y));N.fill(l);const I=s.data.get(r.dataId).values,S=s.data.get(a.dataId).values;for(let e=0;e<c;++e){const t=1===a.shape[0]?S:S.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let s=0;s<g;++s)for(let r=0;r<f;++r){let a;const u=t[6]*s+t[7]*n+1;if(0===u)continue;const c=(t[0]*s+t[1]*n+t[2])/u,d=(t[3]*s+t[4]*n+t[5])/u,f=GE(c,p,o),m=GE(d,h,o);switch(i){case"nearest":a=jE(I,h,p,x,w,v,e,m,f,r,l);break;case"bilinear":a=qE(I,h,p,x,w,v,e,m,f,r,l);break;default:throw new Error(`Error in Transform: Expect 'nearest' or 'bilinear', but got ${i}`)}N[e*x+n*w+s*v+r]=a}return s.makeTensorInfo(y,r.dtype,N)}return{dataId:s.write(N,y,r.dtype),shape:r.shape,dtype:r.dtype}}};function GE(e,t,n){switch(n){case"reflect":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=2*t;n<e&&(n=e*Math.trunc(-n/e)+n),n=n<-t?n+e:-n-1}else if(n>t-1)if(t<=1)n=0;else{const e=2*t;n-=e*Math.trunc(n/e),n>=t&&(n=e-n-1)}return a(0,n,t-1)}(e,t);case"wrap":return function(e,t){let n=e;if(n<0)if(t<=1)n=0;else{const e=t-1;n+=t*(Math.trunc(-n/e)+1)}else if(n>t-1)if(t<=1)n=0;else{const e=t-1;n-=t*Math.trunc(n/e)}return a(0,n,t-1)}(e,t);case"nearest":return function(e,t){return a(0,e,t-1)}(e,t);default:return function(e,t){return e}(e)}}function HE(e,t,n,s,r,a,i,o,l,u,c){return 0<=o&&o<t&&0<=l&&l<n?e[i*s+o*r+l*a+u]:c}function jE(e,t,n,s,r,a,i,o,l,u,c){return HE(e,t,n,s,r,a,i,Math.round(o),Math.round(l),u,c)}function qE(e,t,n,s,r,a,i,o,l,u,c){const h=Math.floor(o),p=Math.floor(l),d=h+1,f=p+1;return(d-o)*((f-l)*HE(e,t,n,s,r,a,i,h,p,u,c)+(l-p)*HE(e,t,n,s,r,a,i,h,f,u,c))+(o-h)*((f-l)*HE(e,t,n,s,r,a,i,d,p,u,c)+(l-p)*HE(e,t,n,s,r,a,i,d,f,u,c))}const KE={kernelName:Yn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:s}=e,{axis:r}=n,{x:a}=t;KN(a,"unique");const i=s.data.get(a.dataId).values,{outputValues:o,outputShape:l,indices:u}=tT(i,r,a.shape,a.dtype);return[s.makeTensorInfo(l,a.dtype,o),s.makeTensorInfo([u.length],"int32",u)]}};const XE={kernelName:Zn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{value:r}=t;let{axis:a}=s;a<0&&(a+=r.shape.length);const i=r.shape.length,o=r.shape[a],l=new Array(i-1);let u=0;for(let e=0;e<i;e++)e!==a&&(l[u++]=r.shape[e]);const c=new Array(i).fill(0),h=r.shape.slice();h[a]=1;const p=new Array(o);for(let e=0;e<p.length;e++){c[a]=e;const t=AS({inputs:{x:r},backend:n,attrs:{begin:c,size:h}});p[e]=mT({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const YE={kernelName:Jn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,segmentIds:a}=t,{numSegments:i}=s;KN(r,"unsortedSegmentSum");const o=[],l=[],u=r.shape.length-a.shape.length;let c=a;for(let e=0;e<u;++e){const t=D$({inputs:{input:c},backend:n,attrs:{dim:e+1}});c=t,l.push(t)}for(let e=0;e<i;++e){const t=Qs(e,"int32"),s=n.makeTensorInfo([],"int32",t),a=SI({inputs:{a:s,b:c},backend:n}),i=oI({inputs:{x:a},backend:n,attrs:{dtype:"float32"}}),u=uS({inputs:{a:i,b:r},backend:n}),h=C$({inputs:{x:u},backend:n,attrs:{axis:0,keepDims:!1}});o.push(h),l.push(s),l.push(a),l.push(i),l.push(u),l.push(h)}const h=HC({inputs:o,backend:n,attrs:{axis:0}});return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),h}},ZE=[xT,JN,vT,NT,fI,IT,ST,TT,$T,CT,AT,_T,DT,LT,PT,UT,GT,HT,jT,bT,qT,KT,XT,YT,lI,kI,JT,tI,QT,s$,a$,i$,o$,l$,u$,c$,p$,f$,m$,g$,y$,b$,x$,v$,k$,N$,I$,S$,T$,$$,A$,rT,R$,TI,F$,EI,O$,_I,V$,G$,H$,OI,K$,X$,Y$,Z$,J$,BI,UI,rI,Q$,t$,tC,sC,aC,iT,jI,XI,iC,QI,lC,hC,dC,gC,yC,bC,wC,sS,vC,kC,NC,IC,SC,TC,$C,iS,CC,RC,DC,cS,pS,MC,zC,BC,mS,WC,GC,jC,qC,YC,uT,wS,ZC,iI,z$,QC,hT,dT,gT,eE,tE,nE,sE,rE,aE,oE,IS,lE,hE,pE,fE,CS,gE,bE,wE,RS,FC,NE,IE,SE,TE,$E,CE,EE,AE,LS,RE,BS,FE,DE,OE,ME,LE,YS,E$,PE,{kernelName:Hn,backendName:"cpu",kernelFunc:BE},WE,VE,UE,bS,KE,XE,YE,UC];for(const e of ZE)ps(e);const JE={},QE={alpha:!1,antialias:!1,premultipliedAlpha:!1,preserveDrawingBuffer:!1,depth:!1,stencil:!1,failIfMajorPerformanceCaveat:!0};function eA(e,t){if(!(e in JE)||null!=t){const n=function(e,t){if(1!==e&&2!==e)throw new Error("Cannot get WebGL rendering context, WebGL is disabled.");const n=null==t?function(e){if("undefined"!=typeof OffscreenCanvas&&2===e)return new OffscreenCanvas(300,150);if("undefined"!=typeof document)return document.createElement("canvas");throw new Error("Cannot create a canvas in this context")}(e):t;if(n.addEventListener("webglcontextlost",(t=>{t.preventDefault(),delete JE[e]}),!1),1===e)return n.getContext("webgl",QE)||n.getContext("experimental-webgl",QE);return n.getContext("webgl2",QE)}(e,t);if(null===n)return console.log("Could not get context for WebGL version",e),null;JE[e]=n}const n=JE[e];return null==n||n.isContextLost()?(delete JE[e],eA(e)):(n.disable(n.DEPTH_TEST),n.disable(n.STENCIL_TEST),n.disable(n.BLEND),n.disable(n.DITHER),n.disable(n.POLYGON_OFFSET_FILL),n.disable(n.SAMPLE_COVERAGE),n.enable(n.SCISSOR_TEST),n.enable(n.CULL_FACE),n.cullFace(n.BACK),JE[e])}var tA,nA,sA;function rA(e,t){return[t,e]}function aA(e){const t=d(e);return g(Math.ceil(t/4))}function iA(e,t){return[Math.max(1,Math.ceil(t/2)),Math.max(1,Math.ceil(e/2))]}function oA(e,t){const n=e;let s,r,a,i,o,l,u,c,h,p;return 2===X().getNumber("WEBGL_VERSION")?(s=n.R32F,r=n.R16F,a=n.RGBA16F,i=n.RGBA32F,o=n.RED,u=4,c=1,h=n.HALF_FLOAT,p=n.FLOAT,l=n.RGBA8):(s=e.RGBA,r=e.RGBA,a=e.RGBA,i=n.RGBA,o=e.RGBA,u=4,c=4,h=null!=t?t.HALF_FLOAT_OES:null,p=e.FLOAT,l=e.RGBA),{internalFormatFloat:s,internalFormatHalfFloat:r,internalFormatPackedHalfFloat:a,internalFormatPackedFloat:i,textureFormatFloat:o,downloadTextureFormat:l,downloadUnpackNumChannels:u,defaultNumChannels:c,textureTypeHalfFloat:h,textureTypeFloat:p}}function lA(e,t){const n=t();return X().getBool("DEBUG")&&function(e){const t=e.getError();if(t!==e.NO_ERROR)throw new Error("WebGL Error: "+function(e,t){switch(t){case e.NO_ERROR:return"NO_ERROR";case e.INVALID_ENUM:return"INVALID_ENUM";case e.INVALID_VALUE:return"INVALID_VALUE";case e.INVALID_OPERATION:return"INVALID_OPERATION";case e.INVALID_FRAMEBUFFER_OPERATION:return"INVALID_FRAMEBUFFER_OPERATION";case e.OUT_OF_MEMORY:return"OUT_OF_MEMORY";case e.CONTEXT_LOST_WEBGL:return"CONTEXT_LOST_WEBGL";default:return`Unknown error code ${t}`}}(e,t))}(e),n}!function(e){e[e.DENSE=0]="DENSE",e[e.SHARED_BATCH=1]="SHARED_BATCH"}(tA||(tA={})),function(e){e[e.RENDER=0]="RENDER",e[e.UPLOAD=1]="UPLOAD",e[e.PIXELS=2]="PIXELS",e[e.DOWNLOAD=3]="DOWNLOAD"}(nA||(nA={})),function(e){e[e.UNPACKED_FLOAT16=0]="UNPACKED_FLOAT16",e[e.UNPACKED_FLOAT32=1]="UNPACKED_FLOAT32",e[e.PACKED_4X1_UNSIGNED_BYTE=2]="PACKED_4X1_UNSIGNED_BYTE",e[e.PACKED_2X2_FLOAT32=3]="PACKED_2X2_FLOAT32",e[e.PACKED_2X2_FLOAT16=4]="PACKED_2X2_FLOAT16"}(sA||(sA={}));function uA(e){return!!(X().getBool("WEBGL_RENDER_FLOAT32_ENABLED")||0===e||5.96e-8<Math.abs(e)&&Math.abs(e)<65504)}function cA(e,t){return xA(e,(()=>e.getExtension(t)),'Extension "'+t+'" not supported on this browser.')}const hA=/ERROR: [0-9]+:([0-9]+):/g;function pA(e,t){const n=hA.exec(t);if(null==n)return console.log(`Couldn't parse line number in error: ${t}`),void console.log(e);const s=+n[1],r=e.split("\n"),a=r.length.toString().length+2,i=r.map(((e,t)=>y((t+1).toString(),a)+e));let o=0;for(let e=0;e<i.length;e++)o=Math.max(i[e].length,o);const l=i.slice(0,s-1),u=i.slice(s-1,s),c=i.slice(s);console.log(l.join("\n")),console.log(t.split("\n")[0]),console.log(`%c ${y(u[0],o)}`,"border:1px solid red; background-color:#e3d2d2; color:#a61717"),console.log(c.join("\n"))}function dA(e,t){if(lA(e,(()=>e.validateProgram(t))),!1===e.getProgramParameter(t,e.VALIDATE_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Shader program validation failed.")}function fA(e,t,n,s,r,a,i){const o=e.getAttribLocation(t,n);return-1!==o&&(lA(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,s))),lA(e,(()=>e.vertexAttribPointer(o,r,e.FLOAT,!1,a,i))),lA(e,(()=>e.enableVertexAttribArray(o))),!0)}function mA(e,t,n,s){lA(e,(()=>function(e,t,n){wA(e,n),lA(e,(()=>e.activeTexture(e.TEXTURE0+n))),lA(e,(()=>e.bindTexture(e.TEXTURE_2D,t)))}(e,t,s))),lA(e,(()=>e.uniform1i(n,s)))}function gA(e,t,n){lA(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,n))),lA(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,t,0)))}function yA(e,t){lA(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,t))),lA(e,(()=>e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,null,0)))}function bA(e){const t=e.checkFramebufferStatus(e.FRAMEBUFFER);if(t!==e.FRAMEBUFFER_COMPLETE)throw new Error("Error binding framebuffer: "+function(e,t){switch(t){case e.FRAMEBUFFER_INCOMPLETE_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT:return"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT";case e.FRAMEBUFFER_INCOMPLETE_DIMENSIONS:return"FRAMEBUFFER_INCOMPLETE_DIMENSIONS";case e.FRAMEBUFFER_UNSUPPORTED:return"FRAMEBUFFER_UNSUPPORTED";default:return`unknown error ${t}`}}(e,t))}function xA(e,t,n){const s=lA(e,(()=>t()));if(null==s)throw new Error(n);return s}function wA(e,t){const n=e.MAX_COMBINED_TEXTURE_IMAGE_UNITS-1,s=t+e.TEXTURE0;if(s<e.TEXTURE0||s>n){throw new Error(`textureUnit must be in ${`[gl.TEXTURE0, gl.TEXTURE${n}]`}.`)}}function vA(e,t=2){return d(e.slice(0,e.length-t))}function kA(e){if(0===e.length)throw Error("Cannot get rows and columns of an empty shape array.");return[e.length>1?e[e.length-2]:1,e[e.length-1]]}function NA(e){let t=[1,1,1];return 0===e.length||1===e.length&&1===e[0]||(t=[vA(e),...kA(e)]),t}function IA(e){return e%2==0}function SA(e,t){if(f(e=e.slice(-2),t=t.slice(-2)))return!0;if(!e.length||!t.length)return!0;if(0===e[0]||0===e[1]||0===t[0]||0===t[1])return!0;if(e.length!==t.length){const n=e.slice(-1)[0],s=t.slice(-1)[0];if(n===s)return!0;if(IA(n)&&IA(s)&&(1===e[0]||1===t[0]))return!0}return e[1]===t[1]&&IA(e[0])&&IA(t[0])}let TA,$A;function CA(e,t){return null!=e.getExtension(t)}function EA(e){try{if(null!=eA(e))return!0}catch(e){return console.log("Error when getting WebGL context: ",e),!1}return!1}function AA(e){if(0===e)return!1;const t=eA(e);if(1!==e){if(CA(t,"EXT_color_buffer_float"))return RA(t);const e="EXT_color_buffer_half_float";if(CA(t,e)){const n=t.getExtension(e);return function(e,t){const n=oA(e,t),s=e.createTexture();e.bindTexture(e.TEXTURE_2D,s);const r=1,a=1;e.texImage2D(e.TEXTURE_2D,0,n.internalFormatHalfFloat,r,a,0,n.textureFormatFloat,n.textureTypeHalfFloat,null);const i=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,i),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,s,0);const o=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(s),e.deleteFramebuffer(i),o}(t,n)}return!1}if(!CA(t,"OES_texture_float"))return!1;if(!CA(t,"WEBGL_color_buffer_float"))return!1;return RA(t)}function RA(e){const t=oA(e),n=e.createTexture();e.bindTexture(e.TEXTURE_2D,n);e.texImage2D(e.TEXTURE_2D,0,t.internalFormatFloat,1,1,0,t.textureFormatFloat,t.textureTypeFloat,null);const s=e.createFramebuffer();e.bindFramebuffer(e.FRAMEBUFFER,s),e.framebufferTexture2D(e.FRAMEBUFFER,e.COLOR_ATTACHMENT0,e.TEXTURE_2D,n,0);const r=e.checkFramebufferStatus(e.FRAMEBUFFER)===e.FRAMEBUFFER_COMPLETE;return e.bindTexture(e.TEXTURE_2D,null),e.bindFramebuffer(e.FRAMEBUFFER,null),e.deleteTexture(n),e.deleteFramebuffer(s),r}function _A(e,t){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&u("complex64"!==e.dtype,(()=>`${t} does not support complex64 tensors in the WebGL backend.`))}))}const FA=X();function DA(){let e,t,n,s,r,a,i,o,l,u;return 2===X().getNumber("WEBGL_VERSION")?(e="#version 300 es",t="in",n="out",s="in",r="texture",a="outputColor",i="out vec4 outputColor;",o="\n      bool isnan_custom(float val) {\n        uint floatToUint = floatBitsToUint(val);\n        return (floatToUint & 0x7fffffffu) > 0x7f800000u;\n      }\n\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan_custom(val.x),\n          isnan_custom(val.y), isnan_custom(val.z), isnan_custom(val.w));\n      }\n\n      #define isnan(value) isnan_custom(value)\n    ",l="",u="\n      #define round(value) newRound(value)\n      int newRound(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 newRound(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "):(e="",t="attribute",n="varying",s="varying",r="texture2D",a="gl_FragColor",i="",o="\n      #define isnan(value) isnan_custom(value)\n      bool isnan_custom(float val) {\n        return (val > 0. || val < 1. || val == 0.) ? false : true;\n      }\n      bvec4 isnan_custom(vec4 val) {\n        return bvec4(isnan(val.x), isnan(val.y), isnan(val.z), isnan(val.w));\n      }\n    ",l="\n      uniform float INFINITY;\n\n      bool isinf(float val) {\n        return abs(val) == INFINITY;\n      }\n      bvec4 isinf(vec4 val) {\n        return equal(abs(val), vec4(INFINITY));\n      }\n    ",u="\n      int round(float value) {\n        return int(floor(value + 0.5));\n      }\n\n      ivec4 round(vec4 value) {\n        return ivec4(floor(value + vec4(0.5)));\n      }\n    "),{version:e,attribute:t,varyingVs:n,varyingFs:s,texture2D:r,output:a,defineOutput:i,defineSpecialNaN:o,defineSpecialInf:l,defineRound:u}}function OA(e,t,n="index"){const s=M(t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / ${t}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${t}`:`index -= ${e[r]} * ${t}`};`)).join("")}function MA(e,t,n="index"){const s=M(t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / outShapeStrides[${r}]`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * outShapeStrides[${r}]`:`index -= ${e[r]} * outShapeStrides[${r}]`};`)).join("")}function LA(e,t,n="index"){const s=function(e,t){const n=e.length,s=e.map((e=>`${t}[${e}]`)),r=new Array(n-1);r[n-2]=s[n-1];for(let e=n-3;e>=0;--e)r[e]=`(${r[e+1]} * ${s[e+1]})`;return r}(e.map(((e,t)=>t)),t);return s.map(((t,r)=>`${`int ${e[r]} = ${n} / ${s[r]}`}; ${r===s.length-1?`int ${e[r+1]} = ${n} - ${e[r]} * ${s[r]}`:`index -= ${e[r]} * ${s[r]}`};`)).join("")}function zA(e){const t=M(e).map((e=>e.toString()));return`\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * ${t[0]} + coords.y * ${t[1]} + coords.z;\n  }\n`}FA.registerFlag("HAS_WEBGL",(()=>FA.getNumber("WEBGL_VERSION")>0)),FA.registerFlag("WEBGL_VERSION",(()=>EA(2)?2:EA(1)?1:0)),FA.registerFlag("WEBGL_CHECK_NUMERICAL_PROBLEMS",(()=>!1)),FA.registerFlag("WEBGL_BUFFER_SUPPORTED",(()=>2===FA.get("WEBGL_VERSION"))),FA.registerFlag("WEBGL_CPU_FORWARD",(()=>!0)),FA.registerFlag("WEBGL_FORCE_F16_TEXTURES",(()=>!1)),FA.registerFlag("WEBGL_PACK",(()=>FA.getBool("HAS_WEBGL"))),FA.registerFlag("WEBGL_PACK_NORMALIZATION",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_CLIP",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_DEPTHWISECONV",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_BINARY_OPERATIONS",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_UNARY_OPERATIONS",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_ARRAY_OPERATIONS",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_IMAGE_OPERATIONS",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_PACK_REDUCE",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_LAZILY_UNPACK",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_CONV_IM2COL",(()=>FA.getBool("WEBGL_PACK"))),FA.registerFlag("WEBGL_MAX_TEXTURE_SIZE",(()=>function(e){if(null==TA){const t=eA(e);TA=t.getParameter(t.MAX_TEXTURE_SIZE)}return TA}(FA.getNumber("WEBGL_VERSION")))),FA.registerFlag("WEBGL_MAX_TEXTURES_IN_SHADER",(()=>function(e){if(null==$A){const t=eA(e);$A=t.getParameter(t.MAX_TEXTURE_IMAGE_UNITS)}return Math.min(16,$A)}(FA.getNumber("WEBGL_VERSION")))),FA.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION",(()=>{const e=FA.getNumber("WEBGL_VERSION");return 0===e?0:function(e){if(0===e)return 0;let t;const n=eA(e);return t=CA(n,"EXT_disjoint_timer_query_webgl2")&&2===e?2:CA(n,"EXT_disjoint_timer_query")?1:0,t}(e)})),FA.registerFlag("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE",(()=>FA.getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0&&!Vr())),FA.registerFlag("WEBGL_RENDER_FLOAT32_CAPABLE",(()=>function(e){if(0===e)return!1;const t=eA(e);if(1===e){if(!CA(t,"OES_texture_float"))return!1}else if(!CA(t,"EXT_color_buffer_float"))return!1;return RA(t)}(FA.getNumber("WEBGL_VERSION")))),FA.registerFlag("WEBGL_RENDER_FLOAT32_ENABLED",(()=>!FA.getBool("WEBGL_FORCE_F16_TEXTURES")&&FA.getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))),FA.registerFlag("WEBGL_DOWNLOAD_FLOAT_ENABLED",(()=>AA(FA.getNumber("WEBGL_VERSION")))),FA.registerFlag("WEBGL_FENCE_API_ENABLED",(()=>{return 2===(e=FA.getNumber("WEBGL_VERSION"))&&null!=eA(e).fenceSync;var e})),FA.registerFlag("WEBGL_SIZE_UPLOAD_UNIFORM",(()=>FA.getBool("WEBGL_RENDER_FLOAT32_ENABLED")?4:0)),FA.registerFlag("WEBGL_DELETE_TEXTURE_THRESHOLD",(()=>-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_DELETE_TEXTURE_THRESHOLD must be -1 (indicating never delete) or at least 0, but got ${e}.`)})),FA.registerFlag("WEBGL_FLUSH_THRESHOLD",(()=>Vr()?1:-1),(e=>{if(e<0&&-1!==e)throw new Error(`WEBGL_FLUSH_THRESHOLD must be -1 (indicating never manual flush) or at least 0, but got ${e}.`)})),FA.registerFlag("CPU_HANDOFF_SIZE_THRESHOLD",(()=>128)),FA.registerFlag("WEBGL_USE_SHAPES_UNIFORMS",(()=>!1)),FA.registerFlag("TOPK_LAST_DIM_CPU_HANDOFF_SIZE_THRESHOLD",(()=>1e5)),FA.registerFlag("TOPK_K_CPU_HANDOFF_THRESHOLD",(()=>128));const PA="\n  const float FLOAT_MAX = 1.70141184e38;\n  const float FLOAT_MIN = 1.17549435e-38;\n\n  lowp vec4 encode_float(highp float v) {\n    if (isnan(v)) {\n      return vec4(255, 255, 255, 255);\n    }\n\n    highp float av = abs(v);\n\n    if(av < FLOAT_MIN) {\n      return vec4(0.0, 0.0, 0.0, 0.0);\n    } else if(v > FLOAT_MAX) {\n      return vec4(0.0, 0.0, 128.0, 127.0) / 255.0;\n    } else if(v < -FLOAT_MAX) {\n      return vec4(0.0, 0.0,  128.0, 255.0) / 255.0;\n    }\n\n    highp vec4 c = vec4(0,0,0,0);\n\n    highp float e = floor(log2(av));\n    highp float m = exp2(fract(log2(av))) - 1.0;\n\n    c[2] = floor(128.0 * m);\n    m -= c[2] / 128.0;\n    c[1] = floor(32768.0 * m);\n    m -= c[1] / 32768.0;\n    c[0] = floor(8388608.0 * m);\n\n    highp float ebias = e + 127.0;\n    c[3] = floor(ebias / 2.0);\n    ebias -= c[3] * 2.0;\n    c[2] += floor(ebias) * 128.0;\n\n    c[3] += 128.0 * step(0.0, -v);\n\n    return c / 255.0;\n  }\n",{getBroadcastDims:BA}=nf;function WA(e,t,n){const s=[];if(e.forEach((e=>{const t=d(e.shapeInfo.logicalShape);if(e.shapeInfo.isUniform?s.push(`uniform float ${e.name}${t>1?`[${t}]`:""};`):(s.push(`uniform sampler2D ${e.name};`),s.push(`uniform int offset${e.name};`)),n.enableShapeUniforms){const{uniformShape:t}=JA(n.packedInputs,e.shapeInfo.logicalShape,e.shapeInfo.texShape);switch(t.length){case 1:s.push(`uniform int ${e.name}Shape;`);break;case 2:s.push(`uniform ivec2 ${e.name}Shape;`);break;case 3:s.push(`uniform ivec3 ${e.name}Shape;`);break;case 4:s.push(`uniform ivec4 ${e.name}Shape;`)}s.push(`uniform ivec2 ${e.name}TexShape;`)}})),n.enableShapeUniforms){switch(t.logicalShape.length){case 1:s.push("uniform int outShape;");break;case 2:s.push("uniform ivec2 outShape;"),s.push("uniform int outShapeStrides;");break;case 3:s.push("uniform ivec3 outShape;"),s.push("uniform ivec2 outShapeStrides;");break;case 4:s.push("uniform ivec4 outShape;"),s.push("uniform ivec3 outShapeStrides;")}s.push("uniform ivec2 outTexShape;")}n.customUniforms&&n.customUniforms.forEach((e=>{s.push(`uniform ${e.type} ${e.name}${e.arrayIndex?`[${e.arrayIndex}]`:""};`)}));const r=s.join("\n"),a=e.map((e=>function(e,t,n=!1,s){let r="";r+=n?UA(e,s):VA(e,s);const a=e.shapeInfo.logicalShape,i=t.logicalShape;a.length<=i.length&&(r+=n?function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=e.shapeInfo.logicalShape.length,i=t.logicalShape.length,o=BA(e.shapeInfo.logicalShape,t.logicalShape),l=ZA(i),u=i-a;let c;const h=["x","y","z","w","u","v"];c=0===a?"":i<2&&o.length>=1?"coords = 0;":o.map((e=>`coords.${h[e+u]} = 0;`)).join("\n");let p="";p=i<2&&a>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${h[t+u]}`)).join(", ");let f="return outputValue;";const m=1===d(e.shapeInfo.logicalShape),g=1===d(t.logicalShape);if(1!==a||m||g){if(m&&!g)f=1===i?"\n        return vec4(outputValue.x, outputValue.x, 0., 0.);\n      ":"\n        return vec4(outputValue.x);\n      ";else if(o.length){const e=a-2,t=a-1;o.indexOf(e)>-1&&o.indexOf(t)>-1?f="return vec4(outputValue.x);":o.indexOf(e)>-1?f="return vec4(outputValue.x, outputValue.y, outputValue.x, outputValue.y);":o.indexOf(t)>-1&&(f="return vec4(outputValue.xx, outputValue.zz);")}}else f="\n      return vec4(outputValue.xy, outputValue.xy);\n    ";return`\n    vec4 ${r}() {\n      ${l} coords = getOutputCoords();\n      ${c}\n      vec4 outputValue = get${s}(${p});\n      ${f}\n    }\n  `}(e,t):function(e,t){const n=e.name,s=n.charAt(0).toUpperCase()+n.slice(1),r="get"+s+"AtOutCoords",a=t.texShape,i=e.shapeInfo.texShape,o=e.shapeInfo.logicalShape.length,l=t.logicalShape.length;if(!e.shapeInfo.isUniform&&o===l&&null==e.shapeInfo.flatOffset&&f(i,a))return`\n      float ${r}() {\n        return sampleTexture(${n}, resultUV);\n      }\n    `;const u=ZA(l),c=BA(e.shapeInfo.logicalShape,t.logicalShape),h=l-o;let p;const d=["x","y","z","w","u","v"];p=0===o?"":l<2&&c.length>=1?"coords = 0;":c.map((e=>`coords.${d[e+h]} = 0;`)).join("\n");let m="";m=l<2&&o>0?"coords":e.shapeInfo.logicalShape.map(((e,t)=>`coords.${d[t+h]}`)).join(", ");return`\n    float ${r}() {\n      ${u} coords = getOutputCoords();\n      ${p}\n      return get${s}(${m});\n    }\n  `}(e,t));return r}(e,t,n.packedInputs,n.enableShapeUniforms))).join("\n"),i=t.texShape,o=DA(),l=function(e){return`\n    float sampleTexture(sampler2D textureSampler, vec2 uv) {\n      return ${e.texture2D}(textureSampler, uv).r;\n    }\n  `}(o);let u,c,h=function(e){return`${e.version}\n    precision highp float;\n    precision highp int;\n    precision highp sampler2D;\n    ${e.varyingFs} vec2 resultUV;\n    ${e.defineOutput}\n    const vec2 halfCR = vec2(0.5, 0.5);\n\n    struct ivec5\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n    };\n\n    struct ivec6\n    {\n      int x;\n      int y;\n      int z;\n      int w;\n      int u;\n      int v;\n    };\n\n    uniform float NAN;\n    ${e.defineSpecialNaN}\n    ${e.defineSpecialInf}\n    ${e.defineRound}\n\n    int imod(int x, int y) {\n      return x - y * (x / y);\n    }\n\n    int idiv(int a, int b, float sign) {\n      int res = a / b;\n      int mod = imod(a, b);\n      if (sign < 0. && mod != 0) {\n        res -= 1;\n      }\n      return res;\n    }\n\n    //Based on the work of Dave Hoskins\n    //https://www.shadertoy.com/view/4djSRW\n    #define HASHSCALE1 443.8975\n    float random(float seed){\n      vec2 p = resultUV * seed;\n      vec3 p3  = fract(vec3(p.xyx) * HASHSCALE1);\n      p3 += dot(p3, p3.yzx + 19.19);\n      return fract((p3.x + p3.y) * p3.z);\n    }\n\n    ${GA}\n    ${HA}\n    ${jA}\n  `}(o);t.isPacked?(u=function(e,t,n){switch(e.length){case 0:return KA();case 1:return function(e,t,n){const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(1===s[0])return n?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ceil(float(outTexShape[1]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.x * ${s[1]}.0);\n      }\n    `;if(1===s[1])return n?"\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ceil(float(outTexShape[0]) / 2.0));\n      }\n    ":`\n      int getOutputCoords() {\n        return 2 * int(resultUV.y * ${s[0]}.0);\n      }\n    `;if(n)return"\n    int getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      return 2 * (resTexRC.x * packedTexShape[1] + resTexRC.y);\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      return 2 * (resTexRC.x * ${s[1]} + resTexRC.y);\n    }\n  `}(0,t,n);case 2:return function(e,t,n){const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)];if(f(e,t))return n?"\n      ivec2 getOutputCoords() {\n        ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n        return 2 * ivec2(resultUV.yx * vec2(packedTexShape[0], packedTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return 2 * ivec2(resultUV.yx * vec2(${s[0]}, ${s[1]}));\n      }\n    `;const r=Math.ceil(e[1]/2);if(n)return"\n    ivec2 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec2(r, c);\n    }\n  `}(e,t,n);case 3:return function(e,t,n){if(n)return"\n    ivec3 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      int texelsInLogicalRow = int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec3(b, r, c);\n    }\n  ";const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[2]/2),a=r*Math.ceil(e[1]/2);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec3(b, r, c);\n    }\n  `}(e,t,n);default:return function(e,t,n){if(n)return"\n    ivec4 getOutputCoords() {\n      ivec2 packedTexShape = ivec2(ceil(float(outTexShape[0]) / 2.0), ceil(float(outTexShape[1]) / 2.0));\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(packedTexShape[0], packedTexShape[1]));\n      int index = resTexRC.x * packedTexShape[1] + resTexRC.y;\n\n      int texelsInLogicalRow = int(ceil(float(outShape[3]) / 2.0));\n      int texelsInBatch = texelsInLogicalRow * int(ceil(float(outShape[2]) / 2.0));\n      int texelsInBatchN = texelsInBatch * outShape[1];\n\n      int b2 = index / texelsInBatchN;\n      index -= b2 * texelsInBatchN;\n\n      int b = index / texelsInBatch;\n      index -= b * texelsInBatch;\n\n      int r = 2 * (index / texelsInLogicalRow);\n      int c = imod(index, texelsInLogicalRow) * 2;\n\n      return ivec4(b2, b, r, c);\n    }\n  ";const s=[Math.ceil(t[0]/2),Math.ceil(t[1]/2)],r=Math.ceil(e[e.length-1]/2),a=r*Math.ceil(e[e.length-2]/2);let i=a,o="",l="b, r, c";for(let t=2;t<e.length-1;t++)i*=e[e.length-t-1],o=`\n      int b${t} = index / ${i};\n      index -= b${t} * ${i};\n    `+o,l=`b${t}, `+l;return`\n    ivec${e.length} getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${s[0]}, ${s[1]}));\n      int index = resTexRC.x * ${s[1]} + resTexRC.y;\n\n      ${o}\n\n      int b = index / ${a};\n      index -= b * ${a};\n\n      int r = 2 * (index / ${r});\n      int c = imod(index, ${r}) * 2;\n\n      return ivec${e.length}(${l});\n    }\n  `}(e,t,n)}}(t.logicalShape,i,n.enableShapeUniforms),c=function(e){return`\n    void setOutput(vec4 val) {\n      ${e.output} = val;\n    }\n  `}(o)):(u=function(e,t,n){switch(e.length){case 0:return KA();case 1:return function(e,t,n){if(1===t[0])return n?"\n      int getOutputCoords() {\n        return int(resultUV.x * float(outTexShape[1]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.x * ${t[1]}.0);\n      }\n    `;if(1===t[1])return n?"\n      int getOutputCoords() {\n        return int(resultUV.y * float(outTexShape[0]));\n      }\n    ":`\n      int getOutputCoords() {\n        return int(resultUV.y * ${t[0]}.0);\n      }\n    `;if(n)return"\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      return resTexRC.x * outTexShape[1] + resTexRC.y;\n    }\n  ";return`\n    int getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      return resTexRC.x * ${t[1]} + resTexRC.y;\n    }\n  `}(0,t,n);case 2:return function(e,t,n){if(f(e,t))return n?"\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(outTexShape[0], outTexShape[1]));\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        return ivec2(resultUV.yx * vec2(${t[0]}, ${t[1]}));\n      }\n    `;if(1===e[1])return n?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(index, 0);\n      }\n    `;if(1===e[0])return n?"\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(outTexShape[0], outTexShape[1]));\n        int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n        return ivec2(0, index);\n      }\n    ":`\n      ivec2 getOutputCoords() {\n        ivec2 resTexRC = ivec2(resultUV.yx *\n                               vec2(${t[0]}, ${t[1]}));\n        int index = resTexRC.x * ${t[1]} + resTexRC.y;\n        return ivec2(0, index);\n      }\n    `;if(n)return"\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      int r = index / outShape[1];\n      int c = index - r * outShape[1];\n      return ivec2(r, c);\n    }\n  ";return`\n    ivec2 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      int r = index / ${e[1]};\n      int c = index - r * ${e[1]};\n      return ivec2(r, c);\n    }\n  `}(e,t,n);case 3:return function(e,t,n){if(n){return`\n  ivec3 getOutputCoords() {\n    ivec2 resTexRC = ivec2(resultUV.yx *\n                           vec2(outTexShape[0], outTexShape[1]));\n    int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n    ${MA(["r","c","d"],e)}\n    return ivec3(r, c, d);\n  }\n`}const s=OA(["r","c","d"],e);return`\n    ivec3 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n                             vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${s}\n      return ivec3(r, c, d);\n    }\n  `}(e,t,n);case 4:return function(e,t,n){if(n){return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(outTexShape[0], outTexShape[1]));\n      int index = resTexRC.x * outTexShape[1] + resTexRC.y;\n      ${MA(["r","c","d","d2"],e)}\n      return ivec4(r, c, d, d2);\n    }\n  `}const s=OA(["r","c","d","d2"],e);return`\n    ivec4 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n      ${s}\n      return ivec4(r, c, d, d2);\n    }\n  `}(e,t,n);case 5:return function(e,t){const n=OA(["r","c","d","d2","d3"],e);return`\n    ivec5 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx * vec2(${t[0]},\n                             ${t[1]}));\n\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec5 outShape = ivec5(r, c, d, d2, d3);\n      return outShape;\n    }\n  `}(e,t);case 6:return function(e,t){const n=OA(["r","c","d","d2","d3","d4"],e);return`\n    ivec6 getOutputCoords() {\n      ivec2 resTexRC = ivec2(resultUV.yx *\n        vec2(${t[0]}, ${t[1]}));\n      int index = resTexRC.x * ${t[1]} + resTexRC.y;\n\n      ${n}\n\n      ivec6 result = ivec6(r, c, d, d2, d3, d4);\n      return result;\n    }\n  `}(e,t);default:throw new Error(`${e.length}-D output sampling is not yet supported`)}}(t.logicalShape,i,n.enableShapeUniforms),c=function(e){return`\n    void setOutput(float val) {\n      ${e.output} = vec4(val, 0, 0, 0);\n    }\n  `}(o)),n.packedInputs&&(h+=qA);return[h,l,c,r,u,a,n.userCode].join("\n")}function VA(e,t=!1){const n=e.shapeInfo.logicalShape;switch(n.length){case 0:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`float ${s}() {return ${n};}`;const[r,a]=e.shapeInfo.texShape;if(1===r&&1===a)return`\n      float ${s}() {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const i=XA(n);if(t)return`\n    float ${s}() {\n      vec2 uv = uvFromFlat(${n}TexShape[0], ${n}TexShape[1], ${i});\n      return sampleTexture(${n}, uv);\n    }\n  `;const[o,l]=e.shapeInfo.texShape;return`\n    float ${s}() {\n      vec2 uv = uvFromFlat(${o}, ${l}, ${i});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e,t);case 1:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1);if(e.shapeInfo.isUniform)return`\n      float ${s}(int index) {\n        ${YA(e)}\n      }\n    `;const r=e.shapeInfo.texShape,a=r[0],i=r[1];if(1===i&&1===a)return`\n      float ${s}(int index) {\n        return sampleTexture(${n}, halfCR);\n      }\n    `;const o=XA(n);if(1===i)return t?`\n      float ${s}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${o}) + 0.5) / float(${n}TexShape[0]));\n        return sampleTexture(${n}, uv);\n      }\n    `:`\n      float ${s}(int index) {\n        vec2 uv = vec2(0.5, (float(index + ${o}) + 0.5) / ${a}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(1===a)return t?`\n      float ${s}(int index) {\n        vec2 uv = vec2((float(index + ${o}) + 0.5) / float(${n}TexShape[1]), 0.5);\n        return sampleTexture(${n}, uv);\n      }\n    `:`\n      float ${s}(int index) {\n        vec2 uv = vec2((float(index + ${o}) + 0.5) / ${i}.0, 0.5);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(t)return`\n    float ${s}(int index) {\n      vec2 uv = uvFromFlat(${n}TexShape[0], ${n}TexShape[1], index + ${o});\n      return sampleTexture(${n}, uv);\n    }\n  `;return`\n    float ${s}(int index) {\n      vec2 uv = uvFromFlat(${a}, ${i}, index + ${o});\n      return sampleTexture(${n}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape;if(null!=a&&f(n,a)){if(t)return`\n      float ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `;const e=a[0];return`\n    float ${r}(int row, int col) {\n      vec2 uv = (vec2(col, row) + halfCR) / vec2(${a[1]}.0, ${e}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `}const{newShape:i,keptDims:o}=v(n),l=i;if(l.length<n.length){const n=["row","col"];return`\n      ${VA(QA(e,l),t)}\n      float ${r}(int row, int col) {\n        return ${r}(${eR(n,o)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col) {\n        int index = round(dot(vec2(row, col), vec2(${n[1]}, 1)));\n        ${YA(e)}\n      }\n    `;const u=a[0],c=a[1],h=XA(s);if(1===c)return t?`\n      float ${r}(int row, int col) {\n        float index = dot(vec3(row, col, ${h}), vec3(${s}Shape[1], 1, 1));\n        vec2 uv = vec2(0.5, (index + 0.5) / float(${s}TexShape[0]));\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col) {\n      float index = dot(vec3(row, col, ${h}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2(0.5, (index + 0.5) / ${u}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `;if(1===u)return t?`\n      float ${r}(int row, int col) {\n        float index = dot(vec3(row, col, ${h}), vec3(${s}Shape[1], 1, 1));\n        vec2 uv = vec2((index + 0.5) / float(${s}TexShape[1]), 0.5);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col) {\n      float index = dot(vec3(row, col, ${h}), vec3(${n[1]}, 1, 1));\n      vec2 uv = vec2((index + 0.5) / ${c}.0, 0.5);\n      return sampleTexture(${s}, uv);\n    }\n  `;if(t)return`\n      float ${r}(int row, int col) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${s}Shape[1] + col + ${h};\n        vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index);\n        return sampleTexture(${s}, uv);\n      }\n    `;return`\n  float ${r}(int row, int col) {\n    // Explicitly use integer operations as dot() only works on floats.\n    int index = row * ${n[1]} + col + ${h};\n    vec2 uv = uvFromFlat(${u}, ${c}, index);\n    return sampleTexture(${s}, uv);\n  }\n`}(e,t);case 3:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=n[1]*n[2],i=n[2],{newShape:o,keptDims:l}=v(n),u=o;if(u.length<n.length){const n=["row","col","depth"];return`\n        ${VA(QA(e,u),t)}\n        float ${r}(int row, int col, int depth) {\n          return ${r}(${eR(n,l)});\n        }\n      `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth) {\n        int index = round(dot(vec3(row, col, depth),\n                          vec3(${a}, ${i}, 1)));\n        ${YA(e)}\n      }\n    `;const c=e.shapeInfo.texShape,h=c[0],p=c[1],d=e.shapeInfo.flatOffset;if(p===a&&null==d)return t?`\n      float ${r}(int row, int col, int depth) {\n        int stride1 = ${s}Shape[2];\n        float texR = float(row);\n        float texC = dot(vec2(col, depth), vec2(stride1, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n        float ${r}(int row, int col, int depth) {\n          float texR = float(row);\n          float texC = dot(vec2(col, depth), vec2(${i}, 1));\n          vec2 uv = (vec2(texC, texR) + halfCR) /\n                     vec2(${p}.0, ${h}.0);\n          return sampleTexture(${s}, uv);\n        }\n      `;if(p===i&&null==d)return t?`\n      float ${r}(int row, int col, int depth) {\n        float texR = dot(vec2(row, col), vec2(${s}Shape[1], 1));\n        float texC = float(depth);\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n    float ${r}(int row, int col, int depth) {\n      float texR = dot(vec2(row, col), vec2(${n[1]}, 1));\n      float texC = float(depth);\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${p}.0, ${h}.0);\n      return sampleTexture(${s}, uv);\n    }\n  `;const f=XA(s);if(t)return`\n    float ${r}(int row, int col, int depth) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int stride0 = ${s}Shape[1] * ${s}Shape[2];\n      int stride1 = ${s}Shape[2];\n      int index = row * ${a} + col * ${i} + depth + ${f};\n      vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index);\n      return sampleTexture(${s}, uv);\n    }\n    `;return`\n      float ${r}(int row, int col, int depth) {\n        // Explicitly use integer operations as dot() only works on floats.\n        int index = row * ${a} + col * ${i} + depth + ${f};\n        vec2 uv = uvFromFlat(${h}, ${p}, index);\n        return sampleTexture(${s}, uv);\n      }\n  `}(e,t);case 4:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=n[3],i=n[2]*a,o=n[1]*i,{newShape:l,keptDims:u}=v(n);if(l.length<n.length){const n=["row","col","depth","depth2"];return`\n      ${VA(QA(e,l),t)}\n      float ${r}(int row, int col, int depth, int depth2) {\n        return ${r}(${eR(n,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${r}(int row, int col, int depth, int depth2) {\n        int index = round(dot(vec4(row, col, depth, depth2),\n                          vec4(${o}, ${i}, ${a}, 1)));\n        ${YA(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1],f=`int stride2 = ${s}Shape[3];`,m=`int stride1 = ${s}Shape[2] * stride2;`,g=`int stride0 = ${s}Shape[1] * stride1;`;if(d===o&&null==c)return t?`\n      float ${r}(int row, int col, int depth, int depth2) {\n        ${f}\n        ${m}\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(stride1, stride2, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = float(row);\n        float texC =\n            dot(vec3(col, depth, depth2),\n                vec3(${i}, ${a}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${s}, uv);\n      }\n    `;if(d===a&&null==c)return t?`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${s}Shape[1] * ${s}Shape[2], ${s}Shape[2], 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${s}TexShape[1], ${s}TexShape[0]);\n        return sampleTexture(${s}, uv);\n      }\n    `:`\n      float ${r}(int row, int col, int depth, int depth2) {\n        float texR = dot(vec3(row, col, depth),\n                         vec3(${n[1]*n[2]}, ${n[2]}, 1));\n        float texC = float(depth2);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${s}, uv);\n      }\n    `;const y=XA(s);if(t)return`\n    float ${r}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      ${f}\n      ${m}\n      ${g}\n      int index = row * stride0 + col * stride1 +\n          depth * stride2 + depth2;\n      vec2 uv = uvFromFlat(${s}TexShape[0], ${s}TexShape[1], index + ${y});\n      return sampleTexture(${s}, uv);\n    }\n  `;return`\n    float ${r}(int row, int col, int depth, int depth2) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} +\n          depth * ${a} + depth2;\n      vec2 uv = uvFromFlat(${p}, ${d}, index + ${y});\n      return sampleTexture(${s}, uv);\n    }\n  `}(e,t);case 5:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=t[4],a=t[3]*r,i=t[2]*a,o=t[1]*i,{newShape:l,keptDims:u}=v(t);if(l.length<t.length){const t=["row","col","depth","depth2","depth3"];return`\n      ${VA(QA(e,l))}\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        return ${s}(${eR(t,u)});\n      }\n    `}if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float index = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${o}, ${i}, ${a}, ${r})) +\n          depth3;\n        ${YA(e)}\n      }\n    `;const c=e.shapeInfo.flatOffset,h=e.shapeInfo.texShape,p=h[0],d=h[1];if(d===o&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n                         vec4(${i}, ${a}, ${r}, 1));\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(d===r&&null==c)return`\n      float ${s}(int row, int col, int depth, int depth2, int depth3) {\n        float texR = dot(\n          vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]},\n               ${t[2]*t[3]}, ${t[3]}, 1));\n        int texC = depth3;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${d}.0, ${p}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const f=XA(n);return`\n    float ${s}(int row, int col, int depth, int depth2, int depth3) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${o} + col * ${i} + depth * ${a} +\n          depth2 * ${r} + depth3 + ${f};\n      vec2 uv = uvFromFlat(${p}, ${d}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);case 6:return function(e){const t=e.shapeInfo.logicalShape,n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),{newShape:r,keptDims:a}=v(t);if(r.length<t.length){const t=["row","col","depth","depth2","depth3","depth4"];return`\n      ${VA(QA(e,r))}\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        return ${s}(${eR(t,a)});\n      }\n    `}const i=t[5],o=t[4]*i,l=t[3]*o,u=t[2]*l,c=t[1]*u;if(e.shapeInfo.isUniform)return`\n      float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n        int index = round(dot(\n          vec4(row, col, depth, depth2),\n          vec4(${c}, ${u}, ${l}, ${o})) +\n          dot(\n            vec2(depth3, depth4),\n            vec2(${i}, 1)));\n        ${YA(e)}\n      }\n    `;const h=e.shapeInfo.flatOffset,p=e.shapeInfo.texShape,d=p[0],f=p[1];if(f===c&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        int texR = row;\n        float texC = dot(vec4(col, depth, depth2, depth3),\n          vec4(${u}, ${l}, ${o}, ${i})) +\n               float(depth4);\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                   vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;if(f===i&&null==h)return`\n      float ${s}(int row, int col, int depth,\n                    int depth2, int depth3, int depth4) {\n        float texR = dot(vec4(row, col, depth, depth2),\n          vec4(${t[1]*t[2]*t[3]*t[4]},\n               ${t[2]*t[3]*t[4]},\n               ${t[3]*t[4]},\n               ${t[4]})) + float(depth3);\n        int texC = depth4;\n        vec2 uv = (vec2(texC, texR) + halfCR) /\n                  vec2(${f}.0, ${d}.0);\n        return sampleTexture(${n}, uv);\n      }\n    `;const m=XA(n);return`\n    float ${s}(int row, int col, int depth,\n                  int depth2, int depth3, int depth4) {\n      // Explicitly use integer operations as dot() only works on floats.\n      int index = row * ${c} + col * ${u} + depth * ${l} +\n          depth2 * ${o} + depth3 * ${i} + depth4 + ${m};\n      vec2 uv = uvFromFlat(${d}, ${f}, index);\n      return sampleTexture(${n}, uv);\n    }\n  `}(e);default:throw new Error(`${n.length}-D input sampling is not yet supported`)}}function UA(e,t){switch(e.shapeInfo.logicalShape.length){case 0:return function(e){const t=e.name,n="get"+t.charAt(0).toUpperCase()+t.slice(1),s=DA();return`\n    vec4 ${n}() {\n      return ${s.texture2D}(${t}, halfCR);\n    }\n  `}(e);case 1:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=e.shapeInfo.texShape,a=DA();if(t)return`\n    vec4 ${s}(int index) {\n      ivec2 packedTexShape = ivec2(ceil(float(${n}TexShape[0]) / 2.0), ceil(float(${n}TexShape[1]) / 2.0));\n      vec2 uv = packedUVfrom1D(\n        packedTexShape[0], packedTexShape[1], index);\n      return ${a.texture2D}(${n}, uv);\n    }\n  `;const i=[Math.ceil(r[0]/2),Math.ceil(r[1]/2)];return`\n    vec4 ${s}(int index) {\n      vec2 uv = packedUVfrom1D(\n        ${i[0]}, ${i[1]}, index);\n      return ${a.texture2D}(${n}, uv);\n    }\n  `}(e,t);case 2:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=a[0],o=a[1],l=DA();if(null!=a&&f(n,a))return t?`\n      vec4 ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${s}TexShape[1], ${s}TexShape[0]);\n\n        return ${l.texture2D}(${s}, uv);\n      }\n    `:`\n      vec4 ${r}(int row, int col) {\n        vec2 uv = (vec2(col, row) + halfCR) / vec2(${o}.0, ${i}.0);\n\n        return ${l.texture2D}(${s}, uv);\n      }\n    `;if(t)return`\n    vec4 ${r}(int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${s}TexShape[0]) / 2.0), ceil(float(${s}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${s}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom2D(valuesPerRow, packedTexShape[0], packedTexShape[1], row, col);\n      return ${l.texture2D}(${s}, uv);\n    }\n  `;const u=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)],c=Math.ceil(n[1]/2);return`\n    vec4 ${r}(int row, int col) {\n      vec2 uv = packedUVfrom2D(${c}, ${u[0]}, ${u[1]}, row, col);\n      return ${l.texture2D}(${s}, uv);\n    }\n  `}(e,t);case 3:return function(e,t){const n=e.shapeInfo.logicalShape,s=e.name,r="get"+s.charAt(0).toUpperCase()+s.slice(1),a=e.shapeInfo.texShape,i=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)];if(1===n[0]){const s=[1,2],a=["b","row","col"];return`\n        ${UA(QA(e,n.slice(1)),t)}\n        vec4 ${r}(int b, int row, int col) {\n          return ${r}(${eR(a,s)});\n        }\n      `}const o=DA();if(t)return`\n    vec4 ${r}(int b, int row, int col) {\n      ivec2 packedTexShape = ivec2(ceil(float(${s}TexShape[0]) / 2.0), ceil(float(${s}TexShape[1]) / 2.0));\n      int valuesPerRow = int(ceil(float(${s}Shape[2]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${s}Shape[1]) / 2.0));\n      vec2 uv = packedUVfrom3D(\n        packedTexShape[0], packedTexShape[1], texelsInBatch, valuesPerRow, b, row, col);\n      return ${o.texture2D}(${s}, uv);\n    }\n  `;const l=i[0],u=i[1],c=Math.ceil(n[2]/2),h=c*Math.ceil(n[1]/2);return`\n    vec4 ${r}(int b, int row, int col) {\n      vec2 uv = packedUVfrom3D(\n        ${l}, ${u}, ${h}, ${c}, b, row, col);\n      return ${o.texture2D}(${s}, uv);\n    }\n  `}(e,t);default:return function(e,t){const n=e.name,s="get"+n.charAt(0).toUpperCase()+n.slice(1),r=DA();if(t)return`\n    vec4 ${s}(int b2, int b, int row, int col) {\n      int valuesPerRow = int(ceil(float(${n}Shape[3]) / 2.0));\n      int texelsInBatch = valuesPerRow * int(ceil(float(${n}Shape[2]) / 2.0));\n      int index = b * texelsInBatch + (row / 2) * valuesPerRow + (col / 2);\n      texelsInBatch *= ${n}Shape[1];\n      index = b2 * texelsInBatch + index;\n      ivec2 packedTexShape = ivec2(ceil(float(${n}TexShape[0]) / 2.0), ceil(float(${n}TexShape[1]) / 2.0));\n      int texR = index / packedTexShape[1];\n      int texC = index - texR * packedTexShape[1];\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(packedTexShape[1], packedTexShape[0]); return ${r.texture2D}(${n}, uv);\n    }\n  `;const a=e.shapeInfo.logicalShape,i=a.length,o=e.shapeInfo.texShape,l=[Math.ceil(o[0]/2),Math.ceil(o[1]/2)],u=l[0],c=l[1],h=Math.ceil(a[i-1]/2);let p=h*Math.ceil(a[i-2]/2),d="int b, int row, int col",f=`b * ${p} + (row / 2) * ${h} + (col / 2)`;for(let e=2;e<i-1;e++)d=`int b${e}, `+d,p*=a[i-e-1],f=`b${e} * ${p} + `+f;return`\n    vec4 ${s}(${d}) {\n      int index = ${f};\n      int texR = index / ${c};\n      int texC = index - texR * ${c};\n      vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${c}, ${u});\n      return ${r.texture2D}(${n}, uv);\n    }\n  `}(e,t)}}const GA="\nvec2 uvFromFlat(int texNumR, int texNumC, int index) {\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\nvec2 packedUVfrom1D(int texNumR, int texNumC, int index) {\n  int texelIndex = index / 2;\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",HA="\nvec2 packedUVfrom2D(int texelsInLogicalRow, int texNumR,\n  int texNumC, int row, int col) {\n  int texelIndex = (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = texelIndex / texNumC;\n  int texC = texelIndex - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",jA="\nvec2 packedUVfrom3D(int texNumR, int texNumC,\n    int texelsInBatch, int texelsInLogicalRow, int b,\n    int row, int col) {\n  int index = b * texelsInBatch + (row / 2) * texelsInLogicalRow + (col / 2);\n  int texR = index / texNumC;\n  int texC = index - texR * texNumC;\n  return (vec2(texC, texR) + halfCR) / vec2(texNumC, texNumR);\n}\n",qA="\n  float getChannel(vec4 frag, vec2 innerDims) {\n    vec2 modCoord = mod(innerDims, 2.);\n    return modCoord.x == 0. ?\n      (modCoord.y == 0. ? frag.r : frag.g) :\n      (modCoord.y == 0. ? frag.b : frag.a);\n  }\n  float getChannel(vec4 frag, int dim) {\n    float modCoord = mod(float(dim), 2.);\n    return modCoord == 0. ? frag.r : frag.g;\n  }\n";function KA(){return"\n    int getOutputCoords() {\n      return 0;\n    }\n  "}function XA(e){return`offset${e}`}function YA(e){const t=e.name,n=d(e.shapeInfo.logicalShape);return n<2?`return ${t};`:`\n    for (int i = 0; i < ${n}; i++) {\n      if (i == index) {\n        return ${t}[i];\n      }\n    }\n  `}function ZA(e){if(e<=1)return"int";if(2===e)return"ivec2";if(3===e)return"ivec3";if(4===e)return"ivec4";if(5===e)return"ivec5";if(6===e)return"ivec6";throw Error(`GPU for rank ${e} is not yet supported`)}function JA(e,t,n){const{newShape:s,keptDims:r}=v(t),a=t.length,i=e&&3===a&&1===t[0],o=i?t.slice(1):s,l=!e&&a>1&&!f(t,n)&&s.length<a||i;return{useSqueezeShape:l,uniformShape:l?o:t,keptDims:r}}function QA(e,t){const n=JSON.parse(JSON.stringify(e));return n.shapeInfo.logicalShape=t,n}function eR(e,t){return t.map((t=>e[t])).join(", ")}function tR(e,t,n,s){const r=n.map(((e,n)=>{const s={logicalShape:e.shape,texShape:e.isUniform?null:e.texData.texShape,isUniform:e.isUniform,isPacked:!e.isUniform&&e.texData.isPacked,flatOffset:null};return null!=e.texData&&null!=e.texData.slice&&e.texData.slice.flatOffset>0&&(s.flatOffset=e.texData.slice.flatOffset),{name:t.variableNames[n],shapeInfo:s}})),a=r.map((e=>e.shapeInfo)),i={logicalShape:s.shape,texShape:s.texData.texShape,isUniform:!1,isPacked:s.texData.isPacked,flatOffset:null},o=WA(r,i,t),l=function(e,t){const n=xA(e,(()=>e.createShader(e.FRAGMENT_SHADER)),"Unable to create fragment WebGLShader.");if(lA(e,(()=>e.shaderSource(n,t))),lA(e,(()=>e.compileShader(n))),X().get("ENGINE_COMPILE_ONLY"))return n;if(!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw pA(t,e.getShaderInfoLog(n)),new Error("Failed to compile fragment shader.");return n}(e.gl,o),u=e.createProgram(l);return X().get("ENGINE_COMPILE_ONLY")?{program:t,fragmentShader:l,source:o,webGLProgram:u,inShapeInfos:a,outShapeInfo:i,uniformLocations:null,customUniformLocations:null,infLoc:null,nanLoc:null,inShapesLocations:null,inTexShapesLocations:null,outShapeLocation:null,outShapeStridesLocation:null,outTexShapeLocation:null}:Object.assign({program:t,fragmentShader:l,source:o,webGLProgram:u,inShapeInfos:a,outShapeInfo:i},nR(e,t,u))}function nR(e,t,n){const s={},r={},a={},i=[];let o,l,u,c=null,h=null;h=e.getUniformLocation(n,"NAN",!1),1===X().getNumber("WEBGL_VERSION")&&(c=e.getUniformLocation(n,"INFINITY",!1));const p=!1;for(let i=0;i<t.variableNames.length;i++){const o=t.variableNames[i];s[o]=e.getUniformLocation(n,o,p),s[`offset${o}`]=e.getUniformLocation(n,`offset${o}`,p),t.enableShapeUniforms&&(r[`${o}Shape`]=e.getUniformLocation(n,`${o}Shape`,p),a[`${o}TexShape`]=e.getUniformLocation(n,`${o}TexShape`,p))}return t.enableShapeUniforms&&(o=e.getUniformLocation(n,"outShape",p),u=e.getUniformLocation(n,"outShapeStrides",p),l=e.getUniformLocation(n,"outTexShape",p)),t.customUniforms&&t.customUniforms.forEach(((t,s)=>{i[s]=e.getUniformLocation(n,t.name,p)})),{uniformLocations:s,customUniformLocations:i,infLoc:c,nanLoc:h,inShapesLocations:r,inTexShapesLocations:a,outShapeLocation:o,outShapeStridesLocation:u,outTexShapeLocation:l}}function sR(e,t){if(e.length!==t.length)throw Error(`Binary was compiled with ${e.length} inputs, but was executed with ${t.length} inputs`);e.forEach(((e,n)=>{const s=e.logicalShape,r=t[n],a=r.shape;if(!f(s,a))throw Error(`Binary was compiled with different shapes than the current args. Shapes ${s} and ${a} must match`);if(e.isUniform&&r.isUniform)return;const i=e.texShape,o=r.isUniform?null:r.texData.texShape;if(!f(i,o))throw Error(`Binary was compiled with different texture shapes than the current args. Shape ${i} and ${o} must match`)}))}function rR(e){return X().getBool("WEBGL_USE_SHAPES_UNIFORMS")&&e<=4}class aR{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outPackingScheme=tA.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=DA();this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?MA(["r","c","d"],e):OA(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getA(rc.x, rc.y, rc.z);\n        }\n\n        ${t.output} = result;\n      }\n    `}}class iR{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outPackingScheme=tA.DENSE,this.customUniforms=[{name:"texShape",type:"ivec2"}];const t=DA();this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length),this.userCode=`\n      ivec3 outCoordsFromFlatIndex(int index) {\n        ${this.enableShapeUniforms?MA(["r","c","d"],e):OA(["r","c","d"],e)}\n        return ivec3(r, c, d);\n      }\n\n      void main() {\n        ivec2 resTexRC = ivec2(resultUV.yx * vec2(texShape[0], texShape[1]));\n        int index = 4 * (resTexRC.x * texShape[1] + resTexRC.y);\n\n        vec4 result = vec4(0.);\n\n        for (int i=0; i<4; i++) {\n          int flatIndex = index + i;\n          ivec3 rc = outCoordsFromFlatIndex(flatIndex);\n          result[i] = getChannel(getA(rc.x, rc.y, rc.z), vec2(rc.y, rc.z));\n        }\n\n        ${t.output} = result;\n      }\n    `}}class oR{constructor(e){this.variableNames=["A"],this.outTexUsage=nA.DOWNLOAD;const t=DA();this.outputShape=e,this.userCode=`\n      ${PA}\n\n      void main() {\n        float x = getAAtOutCoords();\n        ${t.output} = encode_float(x);\n      }\n    `}}class lR{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outTexUsage=nA.DOWNLOAD;const t=DA();this.outputShape=e,this.userCode=`\n      ${PA}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n        float x = getChannel(getAAtOutCoords(), vec2(coords.y, coords.z));\n        ${t.output} = encode_float(x);\n      }\n    `}}class uR{constructor(e,t=!1){this.variableNames=["A"],this.customUniforms=[{name:"texShape",type:"ivec2"}];const n=DA();this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length);let s="result";t&&(s="floor(result * 255. + 0.5)"),this.userCode=`\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":zA(e)}\n\n      void main() {\n        ivec3 coords = getOutputCoords();\n\n        int flatIndex = getFlatIndex(coords);\n        int offset = imod(flatIndex, 4);\n\n        flatIndex = idiv(flatIndex, 4, 1.);\n\n        int r = flatIndex / texShape[1];\n        int c = imod(flatIndex, texShape[1]);\n        vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n        vec4 values = ${n.texture2D}(A, uv);\n\n        float result;\n\n        if(offset == 0) {\n          result = values[0];\n        } else if(offset == 1) {\n          result = values[1];\n        } else if(offset == 2) {\n          result = values[2];\n        } else {\n          result = values[3];\n        }\n\n        ${n.output} = vec4(${s}, 0., 0., 0.);\n      }\n    `}}class cR{constructor(e,t=!1){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.customUniforms=[{name:"texShape",type:"ivec2"}];const n=DA();this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length);let s="",r="result";t&&(r="floor(result * 255. + 0.5)");for(let t=0;t<=1;t++)for(let r=0;r<=1;r++){const a=2*t+r;s+=`\n          localCoords = coords;\n          if(localCoords[2] + ${r} < ${this.enableShapeUniforms?"outShape[2]":`${e[2]}`}) {\n          localCoords[2] += ${r};\n          if (localCoords[1] + ${t} < ${this.enableShapeUniforms?"outShape[1]":`${e[1]}`}) {\n            localCoords[1] += ${t};\n\n            flatIndex = getFlatIndex(localCoords);\n            offset = imod(flatIndex, 4);\n\n            flatIndex = idiv(flatIndex, 4, 1.);\n\n            int r = flatIndex / texShape[1];\n            int c = imod(flatIndex, texShape[1]);\n            vec2 uv = (vec2(c, r) + halfCR) / vec2(texShape[1], texShape[0]);\n            values = ${n.texture2D}(A, uv);\n\n            if (offset == 0) {\n              result[${a}] = values[0];\n            } else if (offset == 1) {\n              result[${a}] = values[1];\n            } else if (offset == 2) {\n              result[${a}] = values[2];\n            } else {\n              result[${a}] = values[3];\n            }\n          }\n        }\n        `}this.userCode=`\n        ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":zA(e)}\n\n        void main() {\n          ivec3 coords = getOutputCoords();\n\n          vec4 result = vec4(0.);\n          int flatIndex, r, c, offset;\n          ivec3 localCoords;\n          vec2 uv;\n          vec4 values;\n\n          ${s}\n\n          ${n.output} = ${r};\n        }\n    `}}function hR(e){const t=DA();return function(e,t){const n=xA(e,(()=>e.createShader(e.VERTEX_SHADER)),"Unable to create vertex WebGLShader.");if(lA(e,(()=>e.shaderSource(n,t))),lA(e,(()=>e.compileShader(n))),!1===e.getShaderParameter(n,e.COMPILE_STATUS))throw console.log(e.getShaderInfoLog(n)),new Error("Failed to compile vertex shader.");return n}(e,`${t.version}\n    precision highp float;\n    ${t.attribute} vec3 clipSpacePos;\n    ${t.attribute} vec2 uv;\n    ${t.varyingVs} vec2 resultUV;\n\n    void main() {\n      gl_Position = vec4(clipSpacePos, 1);\n      resultUV = uv;\n    }`)}function pR(e){return function(e,t){const n=xA(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return lA(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n))),lA(e,(()=>e.bufferData(e.ARRAY_BUFFER,t,e.STATIC_DRAW))),n}(e,new Float32Array([-1,1,0,0,1,-1,-1,0,0,0,1,1,0,1,1,1,-1,0,1,0]))}function dR(e){return function(e,t){const n=xA(e,(()=>e.createBuffer()),"Unable to create WebGLBuffer");return lA(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,n))),lA(e,(()=>e.bufferData(e.ELEMENT_ARRAY_BUFFER,t,e.STATIC_DRAW))),n}(e,new Uint16Array([0,1,2,2,1,3]))}function fR(e,t,n,s,r,a){!function(e,t){const n=X().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(e<=0||t<=0)throw new Error(`Requested texture size [${e}x${t}] is invalid.`);if(e>n||t>n)throw new Error(`Requested texture size [${e}x${t}] greater than WebGL maximum on this browser / GPU [${n}x${n}].`)}(t,n);const i=function(e){return xA(e,(()=>e.createTexture()),"Unable to create WebGLTexture.")}(e),o=e.TEXTURE_2D;return lA(e,(()=>e.bindTexture(o,i))),lA(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_S,e.CLAMP_TO_EDGE))),lA(e,(()=>e.texParameteri(o,e.TEXTURE_WRAP_T,e.CLAMP_TO_EDGE))),lA(e,(()=>e.texParameteri(o,e.TEXTURE_MIN_FILTER,e.NEAREST))),lA(e,(()=>e.texParameteri(o,e.TEXTURE_MAG_FILTER,e.NEAREST))),1===X().getNumber("WEBGL_VERSION")?lA(e,(()=>e.texImage2D(o,0,s,t,n,0,r,a,null))):lA(e,(()=>e.texStorage2D(o,1,s,t,n))),lA(e,(()=>e.bindTexture(e.TEXTURE_2D,null))),{texture:i,texShape:[n,t]}}function mR(e){return e.internalFormatFloat}function gR(e){return e.internalFormatHalfFloat}function yR(e){return e.downloadTextureFormat}function bR(e){return e.internalFormatPackedFloat}function xR(e){return e.internalFormatPackedHalfFloat}function wR(e,t,n,s,r,a,i,o){const l=e,u=new Float32Array(function(e,t){const[n,s]=iA(e,t);return n*s*4}(a,i));return l.bindBuffer(l.PIXEL_PACK_BUFFER,t),l.getBufferSubData(l.PIXEL_PACK_BUFFER,0,u),l.bindBuffer(l.PIXEL_PACK_BUFFER,null),u}class vR{constructor(e){this.outputTexture=null,this.program=null,this.disposed=!1,this.vertexAttrsAreBound=!1,this.itemsToPoll=[];const t=X().getNumber("WEBGL_VERSION");null!=e?(this.gl=e,function(e,t){JE[e]=t}(t,e)):this.gl=eA(t);let n="WEBGL_color_buffer_float";const s="EXT_color_buffer_half_float";if(this.parallelCompilationExtension=this.gl.getExtension("KHR_parallel_shader_compile"),1===X().getNumber("WEBGL_VERSION")){const e="OES_texture_float",t="OES_texture_half_float";if(this.textureFloatExtension=cA(this.gl,e),CA(this.gl,t))this.textureHalfFloatExtension=cA(this.gl,t);else if(X().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support half float textures, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.");if(this.colorBufferFloatExtension=this.gl.getExtension(n),CA(this.gl,s))this.colorBufferHalfFloatExtension=cA(this.gl,s);else if(X().get("WEBGL_FORCE_F16_TEXTURES"))throw new Error("GL context does not support color renderable half floats, yet the environment flag WEBGL_FORCE_F16_TEXTURES is set to true.")}else if(n="EXT_color_buffer_float",CA(this.gl,n))this.colorBufferFloatExtension=this.gl.getExtension(n);else{if(!CA(this.gl,s))throw new Error("GL context does not support color renderable floats");this.colorBufferHalfFloatExtension=this.gl.getExtension(s)}this.vertexBuffer=pR(this.gl),this.indexBuffer=dR(this.gl),this.framebuffer=function(e){return xA(e,(()=>e.createFramebuffer()),"Unable to create WebGLFramebuffer.")}(this.gl),this.textureConfig=oA(this.gl,this.textureHalfFloatExtension)}get debug(){return X().getBool("DEBUG")}dispose(){if(this.disposed)return;null!=this.program&&console.warn("Disposing a GPGPUContext that still has a bound WebGLProgram. This is probably a resource leak, delete the program with GPGPUContext.deleteProgram before disposing."),null!=this.outputTexture&&console.warn("Disposing a GPGPUContext that still has a bound output matrix texture.  This is probably a resource leak, delete the output matrix texture with GPGPUContext.deleteMatrixTexture before disposing.");const e=this.gl;lA(e,(()=>e.finish())),lA(e,(()=>e.bindFramebuffer(e.FRAMEBUFFER,null))),lA(e,(()=>e.deleteFramebuffer(this.framebuffer))),lA(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,null))),lA(e,(()=>e.bindBuffer(e.ELEMENT_ARRAY_BUFFER,null))),lA(e,(()=>e.deleteBuffer(this.indexBuffer))),this.disposed=!0}createFloat32MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=rA(t,n);return fR(e,r,a,mR(s),s.textureFormatFloat,e.FLOAT)}(this.gl,e,t,this.textureConfig)}createFloat16MatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=rA(t,n);return fR(e,r,a,gR(s),s.textureFormatFloat,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createUnsignedBytesMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=rA(t,n);return fR(e,r,a,yR(s),e.RGBA,e.UNSIGNED_BYTE)}(this.gl,e,t,this.textureConfig)}uploadPixelDataToTexture(e,t){this.throwIfDisposed(),function(e,t,n){lA(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),n.data instanceof Uint8Array?2===X().getNumber("WEBGL_VERSION")?lA(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,n.width,n.height,e.RGBA,e.UNSIGNED_BYTE,n.data))):lA(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,n.width,n.height,0,e.RGBA,e.UNSIGNED_BYTE,n.data))):2===X().getNumber("WEBGL_VERSION")?lA(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,e.RGBA,e.UNSIGNED_BYTE,n))):lA(e,(()=>e.texImage2D(e.TEXTURE_2D,0,e.RGBA,e.RGBA,e.UNSIGNED_BYTE,n))),lA(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}(this.gl,e,t)}uploadDenseMatrixToTexture(e,t,n,s){this.throwIfDisposed(),function(e,t,n,s,r,a){let i,o,l;lA(e,(()=>e.bindTexture(e.TEXTURE_2D,t))),r instanceof Uint8Array?(i=new Uint8Array(n*s*4),o=e.UNSIGNED_BYTE,l=e.RGBA):(i=new Float32Array(n*s*4),o=e.FLOAT,l=a.internalFormatPackedFloat),i.set(r),2===X().getNumber("WEBGL_VERSION")?lA(e,(()=>e.texSubImage2D(e.TEXTURE_2D,0,0,0,n,s,e.RGBA,o,i))):lA(e,(()=>e.texImage2D(e.TEXTURE_2D,0,l,n,s,0,e.RGBA,o,i))),lA(e,(()=>e.bindTexture(e.TEXTURE_2D,null)))}(this.gl,e,t,n,s,this.textureConfig)}createFloat16PackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=iA(t,n);return fR(e,r,a,xR(s),e.RGBA,s.textureTypeHalfFloat)}(this.gl,e,t,this.textureConfig)}createPackedMatrixTexture(e,t){return this.throwIfDisposed(),function(e,t,n,s){const[r,a]=iA(t,n);return fR(e,r,a,bR(s),e.RGBA,e.FLOAT)}(this.gl,e,t,this.textureConfig)}deleteMatrixTexture(e){this.throwIfDisposed(),this.outputTexture===e&&(yA(this.gl,this.framebuffer),this.outputTexture=null),lA(this.gl,(()=>this.gl.deleteTexture(e)))}downloadByteEncodedFloatMatrixFromOutputTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>function(e,t,n,s){const[r,a]=rA(t,n),i=new Uint8Array(t*n*4);return lA(e,(()=>e.readPixels(0,0,r,a,s.downloadTextureFormat,e.UNSIGNED_BYTE,i))),new Float32Array(i.buffer)}(this.gl,t,n,this.textureConfig)))}downloadPackedMatrixFromBuffer(e,t,n,s,r,a){return wR(this.gl,e,0,0,0,r,a,this.textureConfig)}downloadFloat32MatrixFromBuffer(e,t){return function(e,t,n){const s=e,r=new Float32Array(n);return s.bindBuffer(s.PIXEL_PACK_BUFFER,t),s.getBufferSubData(s.PIXEL_PACK_BUFFER,0,r),s.bindBuffer(s.PIXEL_PACK_BUFFER,null),r}(this.gl,e,t)}createBufferFromTexture(e,t,n){this.bindTextureToFrameBuffer(e);const s=function(e,t,n,s){const r=e.createBuffer();lA(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,r)));const a=16*t*n;return lA(e,(()=>e.bufferData(e.PIXEL_PACK_BUFFER,a,e.STREAM_READ))),lA(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,0))),lA(e,(()=>e.bindBuffer(e.PIXEL_PACK_BUFFER,null))),r}(this.gl,t,n,this.textureConfig);return this.unbindTextureToFrameBuffer(),s}createAndWaitForFence(){const e=this.createFence(this.gl);return this.pollFence(e)}createFence(e){let t,n;if(X().getBool("WEBGL_FENCE_API_ENABLED")){const s=e,r=s.fenceSync(s.SYNC_GPU_COMMANDS_COMPLETE,0);e.flush(),n=()=>{const e=s.clientWaitSync(r,0,0);return e===s.ALREADY_SIGNALED||e===s.CONDITION_SATISFIED},t=r}else X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")>0?(t=this.beginQuery(),this.endQuery(),n=()=>this.isQueryAvailable(t,X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))):n=()=>!0;return{query:t,isFencePassed:n}}downloadMatrixFromPackedTexture(e,t,n){return this.downloadMatrixDriver(e,(()=>function(e,t,n){const s=new Float32Array(t*n*4);return lA(e,(()=>e.readPixels(0,0,n,t,e.RGBA,e.FLOAT,s))),s}(this.gl,t,n)))}createProgram(e){this.throwIfDisposed();const t=this.gl;null==this.vertexShader&&(this.vertexShader=hR(t));const n=function(e){return xA(e,(()=>e.createProgram()),"Unable to create WebGLProgram.")}(t);return lA(t,(()=>t.attachShader(n,this.vertexShader))),lA(t,(()=>t.attachShader(n,e))),function(e,t){if(lA(e,(()=>e.linkProgram(t))),!X().get("ENGINE_COMPILE_ONLY")&&!1===e.getProgramParameter(t,e.LINK_STATUS))throw console.log(e.getProgramInfoLog(t)),new Error("Failed to link vertex and fragment shaders.")}(t,n),this.debug&&dA(t,n),this.vertexAttrsAreBound||(this.setProgram(n),this.vertexAttrsAreBound=function(e,t,n){return lA(e,(()=>e.bindBuffer(e.ARRAY_BUFFER,n))),fA(e,t,"clipSpacePos",n,3,20,0)&&fA(e,t,"uv",n,2,20,12)}(t,this.program,this.vertexBuffer)),n}deleteProgram(e){this.throwIfDisposed(),e===this.program&&(this.program=null),null!=e&&lA(this.gl,(()=>this.gl.deleteProgram(e)))}setProgram(e){this.throwIfDisposed(),this.program=e,null!=this.program&&this.debug&&dA(this.gl,this.program),lA(this.gl,(()=>this.gl.useProgram(e)))}getUniformLocation(e,t,n=!0){return this.throwIfDisposed(),n?function(e,t,n){return xA(e,(()=>e.getUniformLocation(t,n)),'uniform "'+n+'" not present in program.')}(this.gl,e,t):function(e,t,n){return e.getUniformLocation(t,n)}(this.gl,e,t)}getAttributeLocation(e,t){return this.throwIfDisposed(),lA(this.gl,(()=>this.gl.getAttribLocation(e,t)))}getUniformLocationNoThrow(e,t){return this.throwIfDisposed(),this.gl.getUniformLocation(e,t)}setInputMatrixTexture(e,t,n){this.throwIfDisposed(),this.throwIfNoProgram(),mA(this.gl,e,t,n)}setOutputMatrixTexture(e,t,n){this.setOutputMatrixTextureDriver(e,n,t)}setOutputPackedMatrixTexture(e,t,n){this.throwIfDisposed();const[s,r]=iA(t,n);this.setOutputMatrixTextureDriver(e,s,r)}setOutputMatrixWriteRegion(e,t,n,s){this.setOutputMatrixWriteRegionDriver(n,e,s,t)}setOutputPackedMatrixWriteRegion(e,t,n,s){throw new Error("setOutputPackedMatrixWriteRegion not implemented.")}debugValidate(){null!=this.program&&dA(this.gl,this.program),bA(this.gl)}executeProgram(){this.throwIfDisposed(),this.throwIfNoProgram();const e=this.gl;this.debug&&this.debugValidate(),lA(e,(()=>e.drawElements(e.TRIANGLES,6,e.UNSIGNED_SHORT,0)))}blockUntilAllProgramsCompleted(){this.throwIfDisposed(),lA(this.gl,(()=>this.gl.finish()))}getQueryTimerExtension(){return null==this.disjointQueryTimerExtension&&(this.disjointQueryTimerExtension=cA(this.gl,2===X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")?"EXT_disjoint_timer_query_webgl2":"EXT_disjoint_timer_query")),this.disjointQueryTimerExtension}getQueryTimerExtensionWebGL2(){return this.getQueryTimerExtension()}getQueryTimerExtensionWebGL1(){return this.getQueryTimerExtension()}beginQuery(){if(2===X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2(),n=e.createQuery();return e.beginQuery(t.TIME_ELAPSED_EXT,n),n}const e=this.getQueryTimerExtensionWebGL1(),t=e.createQueryEXT();return e.beginQueryEXT(e.TIME_ELAPSED_EXT,t),t}endQuery(){if(2===X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")){const e=this.gl,t=this.getQueryTimerExtensionWebGL2();return void e.endQuery(t.TIME_ELAPSED_EXT)}const e=this.getQueryTimerExtensionWebGL1();e.endQueryEXT(e.TIME_ELAPSED_EXT)}async waitForQueryAndGetTime(e){return await b((()=>this.disposed||this.isQueryAvailable(e,X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION")))),this.getQueryTime(e,X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_VERSION"))}getQueryTime(e,t){if(0===t)return null;if(2===t){const t=this.gl;return t.getQueryParameter(e,t.QUERY_RESULT)/1e6}{const t=this.getQueryTimerExtensionWebGL1();return t.getQueryObjectEXT(e,t.QUERY_RESULT_EXT)/1e6}}isQueryAvailable(e,t){if(0===t)return!0;if(2===t){const t=this.gl,n=this.getQueryTimerExtensionWebGL2(),s=t.getQueryParameter(e,t.QUERY_RESULT_AVAILABLE);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(n.GPU_DISJOINT_EXT)),s&&!this.disjoint}{const t=this.getQueryTimerExtensionWebGL1(),n=t.getQueryObjectEXT(e,t.QUERY_RESULT_AVAILABLE_EXT);return null==this.disjoint&&(this.disjoint=this.gl.getParameter(t.GPU_DISJOINT_EXT)),n&&!this.disjoint}}pollFence(e){return new Promise((t=>{this.addItemToPoll((()=>e.isFencePassed()),(()=>t()))}))}pollItems(){const e=function(e){let t=0;for(;t<e.length;++t){if(!e[t]())break}return t-1}(this.itemsToPoll.map((e=>e.isDoneFn)));for(let t=0;t<=e;++t){const{resolveFn:e}=this.itemsToPoll[t];e()}this.itemsToPoll=this.itemsToPoll.slice(e+1)}addItemToPoll(e,t){this.itemsToPoll.push({isDoneFn:e,resolveFn:t}),this.itemsToPoll.length>1||b((()=>(this.pollItems(),0===this.itemsToPoll.length)))}bindTextureToFrameBuffer(e){this.throwIfDisposed(),gA(this.gl,e,this.framebuffer),this.debug&&bA(this.gl)}unbindTextureToFrameBuffer(){null!=this.outputTexture?(gA(this.gl,this.outputTexture,this.framebuffer),this.debug&&bA(this.gl)):yA(this.gl,this.framebuffer)}downloadMatrixDriver(e,t){this.bindTextureToFrameBuffer(e);const n=t();return this.unbindTextureToFrameBuffer(),n}setOutputMatrixTextureDriver(e,t,n){this.throwIfDisposed();const s=this.gl;gA(s,e,this.framebuffer),this.debug&&bA(s),this.outputTexture=e,lA(s,(()=>s.viewport(0,0,t,n))),lA(s,(()=>s.scissor(0,0,t,n)))}setOutputMatrixWriteRegionDriver(e,t,n,s){this.throwIfDisposed(),lA(this.gl,(()=>this.gl.scissor(e,t,n,s)))}throwIfDisposed(){if(this.disposed)throw new Error("Attempted to use disposed GPGPUContext.")}throwIfNoProgram(){if(null==this.program)throw new Error("No GPU program is currently set.")}}const{addImpl:kR,bincountImpl:NR,bincountReduceImpl:IR,ceilImpl:SR,concatImpl:TR,equalImpl:$R,expImpl:CR,expm1Impl:ER,floorImpl:AR,gatherNdImpl:RR,gatherV2Impl:_R,greaterImpl:FR,greaterEqualImpl:DR,lessImpl:OR,lessEqualImpl:MR,linSpaceImpl:LR,logImpl:zR,maxImpl:PR,maximumImpl:BR,minimumImpl:WR,multiplyImpl:VR,negImpl:UR,notEqualImpl:GR,prodImpl:HR,rangeImpl:jR,rsqrtImpl:qR,scatterImpl:KR,sigmoidImpl:XR,simpleAbsImpl:YR,sliceImpl:ZR,sparseFillEmptyRowsImpl:JR,sparseReshapeImpl:QR,sparseSegmentReductionImpl:e_,sqrtImpl:t_,stridedSliceImpl:n_,stringNGramsImpl:s_,stringSplitImpl:r_,stringToHashBucketFastImpl:a_,subImpl:i_,tileImpl:o_,topKImpl:l_,transposeImpl:u_,uniqueImpl:c_}=nT;function h_(e,t){return["x","y","z","w","u","v"].slice(0,t).map((t=>`${e}.${t}`))}function p_(e,t){return 1===t?[e]:h_(e,t)}class d_{constructor(e){if(this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0,this.outputShape=e,this.rank=e.length,this.enableShapeUniforms=rR(this.outputShape.length),0===this.rank)this.userCode="\n        void main() {\n          setOutput(vec4(getA(), 0., 0., 0.));\n        }\n      ";else{const e=p_("rc",this.rank),t=ZA(this.rank),n=this.getOutOfBoundsCondition(e),s=this.getSetup(e),r=this.getOutput(e);this.userCode=`\n        void main() {\n          ${t} rc = getOutputCoords();\n\n          if(${n}) {\n            setOutput(vec4(0));\n          } else {\n            ${s}\n\n            setOutput(vec4(${r}));\n          }\n        }\n      `}}getSourceCoordsArr(e){const t=[];for(let n=0;n<=1;n++)for(let s=0;s<=1;s++){let r=`${0===n?"r":"rp1"}, ${0===s?"c":"cp1"}`;for(let t=2;t<this.rank;t++)r=`${e[e.length-1-t]},`+r;t.push(r)}return t}getOutOfBoundsCondition(e){if(1===this.rank)return`rc > ${this.enableShapeUniforms?"outShape":this.outputShape[0]}`;let t="";for(let n=this.rank-2;n<this.rank;n++)t+=`${e[n]} >= ${this.enableShapeUniforms?`outShape[${n}]`:this.outputShape[n]}`,n<this.rank-1&&(t+="||");return t}getSetup(e){if(1===this.rank)return"";const t=e.slice(-2),n=this.enableShapeUniforms?`outShape[${this.rank} - 1]`:this.outputShape[this.rank-1],s=this.enableShapeUniforms?`outShape[${this.rank} - 2]`:this.outputShape[this.rank-2];return`\n      int r = ${t[0]};\n      int c = ${t[1]};\n      int rp1 = r + 1;\n      int cp1 = c + 1;\n\n      bool cEdge = cp1 >= ${n};\n      bool rEdge = rp1 >= ${s};\n    `}getOutput(e){const t=this.getSourceCoordsArr(e);if(1===this.rank){return`getA(rc), (rc + 1 >= ${this.enableShapeUniforms?"outShape":this.outputShape[0]} ? 0. : getA(rc + 1)), 0, 0`}return`getA(${t[0]}),\n            cEdge ? 0. : getA(${t[1]}),\n            rEdge ? 0. : getA(${t[2]}),\n            rEdge || cEdge ? 0. : getA(${t[3]})`}}class f_{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec3"}],this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length);let n="";for(let e=0;e<4;e++){let t="thisRC = rc;";e%2==1&&(t+="thisRC.z += 1;"),e>1&&(t+="thisRC.y += 1;"),n+=`\n        ${t}\n        ${e>0?"if(thisRC.y < rows && thisRC.z < cols){":""}\n          int flatIndex = getFlatIndex(thisRC);\n\n          ivec3 inputRC = inputCoordsFromReshapedOutCoords(flatIndex);\n          vec2 inputRCInnerDims = vec2(float(inputRC.y),float(inputRC.z));\n\n          result[${e}] =\n            getChannel(getA(inputRC.x, inputRC.y, inputRC.z), inputRCInnerDims);\n        ${e>0?"}":""}\n      `}var s,r;this.userCode=`\n      ${s=t,r=this.enableShapeUniforms,`\n    ivec3 inputCoordsFromReshapedOutCoords(int index) {\n      ${r?LA(["r","c","d"],"inputShape"):OA(["r","c","d"],s)}\n      return ivec3(r, c, d);\n    }\n  `}\n      ${this.enableShapeUniforms?"\n  int getFlatIndex(ivec3 coords) {\n    return coords.x * outShapeStrides[0] + coords.y * outShapeStrides[1] + coords.z;\n  }\n":zA(e)}\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0.);\n\n        ivec3 thisRC;\n        int rows = ${this.enableShapeUniforms?"outShape[1]":e[1]};\n        int cols = ${this.enableShapeUniforms?"outShape[2]":e[2]};\n\n        ${n}\n\n        setOutput(result);\n      }\n    `}}class m_{constructor(e){this.gpgpu=e,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0,this.freeTextures={},this.logEnabled=!1,this.usedTextures={}}acquireTexture(e,t,n){const s=y_(t,n),r=b_(e,s,n);r in this.freeTextures||(this.freeTextures[r]=[]),r in this.usedTextures||(this.usedTextures[r]=[]);const a=g_(e,s,this.gpgpu.gl,this.gpgpu.textureConfig,n);if(this.freeTextures[r].length>0){this.numFreeTextures--,this.numUsedTextures++,this._numBytesFree-=a,this.log();const e=this.freeTextures[r].shift();return this.usedTextures[r].push(e),e}let i;return s===sA.PACKED_2X2_FLOAT32?i=this.gpgpu.createPackedMatrixTexture(e[0],e[1]):s===sA.PACKED_2X2_FLOAT16?i=this.gpgpu.createFloat16PackedMatrixTexture(e[0],e[1]):s===sA.UNPACKED_FLOAT32?i=this.gpgpu.createFloat32MatrixTexture(e[0],e[1]):s===sA.UNPACKED_FLOAT16?i=this.gpgpu.createFloat16MatrixTexture(e[0],e[1]):s===sA.PACKED_4X1_UNSIGNED_BYTE&&(i=this.gpgpu.createUnsignedBytesMatrixTexture(e[0],e[1])),this.usedTextures[r].push(i),this.numUsedTextures++,this._numBytesAllocated+=a,this.log(),i}releaseTexture(e,t,n,s){if(null==this.freeTextures)return;const r=y_(n,s),a=b_(t,r,s);a in this.freeTextures||(this.freeTextures[a]=[]);const i=g_(t,r,this.gpgpu.gl,this.gpgpu.textureConfig,s),o=X().get("WEBGL_DELETE_TEXTURE_THRESHOLD");-1!==o&&this._numBytesAllocated>o?(this.gpgpu.deleteMatrixTexture(e.texture),this._numBytesAllocated-=i):(this.freeTextures[a].push(e),this.numFreeTextures++,this._numBytesFree+=i),this.numUsedTextures--;const l=this.usedTextures[a],u=l.indexOf(e);if(u<0)throw new Error("Cannot release a texture that was never provided by this texture manager");l.splice(u,1),this.log()}log(){if(!this.logEnabled)return;const e=this.numFreeTextures+this.numUsedTextures;console.log("Free/Used",`${this.numFreeTextures} / ${this.numUsedTextures}`,`(${e})`);const t=this._numBytesFree/this._numBytesAllocated;console.log(`Bytes allocated: ${this._numBytesAllocated}`),console.log(`Bytes unused: ${this._numBytesFree} (${Math.round(100*t)}%)`)}get numBytesAllocated(){return this._numBytesAllocated}get numBytesFree(){return this._numBytesFree}getNumUsedTextures(){return this.numUsedTextures}getNumFreeTextures(){return this.numFreeTextures}dispose(){if(null!=this.freeTextures){for(const e in this.freeTextures)this.freeTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e.texture)}));for(const e in this.usedTextures)this.usedTextures[e].forEach((e=>{this.gpgpu.deleteMatrixTexture(e.texture)}));this.freeTextures=null,this.usedTextures=null,this.numUsedTextures=0,this.numFreeTextures=0,this._numBytesAllocated=0,this._numBytesFree=0}}}function g_(e,t,n,s,r){const a=function(e,t){switch(e){case sA.PACKED_2X2_FLOAT32:return bR(t);case sA.PACKED_2X2_FLOAT16:return xR(t);case sA.UNPACKED_FLOAT32:return mR(t);case sA.UNPACKED_FLOAT16:return gR(t);case sA.PACKED_4X1_UNSIGNED_BYTE:return yR(t);default:throw new Error(`Unknown physical texture type ${e}`)}}(t,s);let i;if(r){const[t,n]=iA(e[0],e[1]);i=t*n}else{const[t,n]=rA(e[0],e[1]);i=t*n}const o=function(e,t){const n=e;if(t===n.R32F)return 4;if(t===n.R16F)return 2;if(t===n.RGBA32F)return 16;if(t===e.RGBA)return 16;if(t===n.RGBA16F)return 8;if(t===n.RGBA8)return 4;throw new Error(`Unknown internal format ${t}`)}(n,a);return i*o}function y_(e,t){if(e===nA.UPLOAD)return sA.PACKED_2X2_FLOAT32;if(e===nA.RENDER||null==e)return function(e){return X().getBool("WEBGL_RENDER_FLOAT32_ENABLED")?e?sA.PACKED_2X2_FLOAT32:sA.UNPACKED_FLOAT32:e?sA.PACKED_2X2_FLOAT16:sA.UNPACKED_FLOAT16}(t);if(e===nA.DOWNLOAD||e===nA.PIXELS)return sA.PACKED_4X1_UNSIGNED_BYTE;throw new Error(`Unknown logical texture type ${e}`)}function b_(e,t,n){return`${e[0]}_${e[1]}_${t}_${n}`}class x_{constructor(e,t){this.variableNames=["A"],this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length),this.userCode=`\n      float unaryOperation(float x) {\n        ${t}\n      }\n\n      void main() {\n        float x = getAAtOutCoords();\n        float y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}const w_="return abs(x);";const v_="return x;";class k_{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length),this.userCode=`\n      vec4 unaryOperation(vec4 x) {\n        ${t}\n      }\n\n      void main() {\n        vec4 x = getAAtOutCoords();\n        vec4 y = unaryOperation(x);\n\n        setOutput(y);\n      }\n    `}}class N_{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!1,this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length);const t=e.length,n=p_("rc",t),s=ZA(t),r=function(e,t){if(1===e)return"rc";let n="";for(let s=0;s<e;s++)n+=t[s],s<e-1&&(n+=",");return n}(t,n),a=n.slice(-2),i=t<=1?"rc":`vec2(${a.join(",")})`;this.userCode=`\n      void main() {\n        ${s} rc = getOutputCoords();\n        vec4 packedInput = getA(${r});\n\n        setOutput(getChannel(packedInput, ${i}));\n      }\n    `}}const I_=kh,S_={};const T_=X().getNumber("CPU_HANDOFF_SIZE_THRESHOLD");class $_ extends n{constructor(e){if(super(),this.pendingRead=new WeakMap,this.pendingDisposal=new WeakSet,this.dataRefCount=new WeakMap,this.numBytesInGPU=0,this.uploadWaitMs=0,this.downloadWaitMs=0,this.lastGlFlushTime=0,this.warnedAboutMemory=!1,this.pendingDeletes=0,this.disposed=!1,!X().getBool("HAS_WEBGL"))throw new Error("WebGL is not supported on this device");let n;if(null!=e){if(e instanceof vR)n=e;else{const t=eA(X().getNumber("WEBGL_VERSION"),e);n=new vR(t)}this.binaryCache={},this.gpgpuCreatedLocally=!1}else{const e=eA(X().getNumber("WEBGL_VERSION"));n=new vR(e),this.binaryCache=((s=X().getNumber("WEBGL_VERSION"))in S_||(S_[s]={}),S_[s]),this.gpgpuCreatedLocally=!0}var s;this.gpgpu=n,this.canvas=this.gpgpu.gl.canvas,this.textureManager=new m_(this.gpgpu),this.numMBBeforeWarning=null==X().global.screen?1024:X().global.screen.height*X().global.screen.width*window.devicePixelRatio*600/1024/1024,this.texData=new t(this,gi())}nextDataId(){return $_.nextDataId++}numDataIds(){return this.texData.numDataIds()-this.pendingDeletes}write(e,t,n){if((X().getBool("WEBGL_CHECK_NUMERICAL_PROBLEMS")||X().getBool("DEBUG"))&&this.checkNumericalProblems(e),"complex64"===n&&null!=e)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");const s={id:this.nextDataId()};return this.texData.set(s,{shape:t,dtype:n,values:e,usage:nA.UPLOAD,refCount:1}),s}refCount(e){if(this.texData.has(e)){return this.texData.get(e).refCount}return 0}incRef(e){this.texData.get(e).refCount++}decRef(e){if(this.texData.has(e)){this.texData.get(e).refCount--}}move(e,t,n,s,r){if(X().getBool("DEBUG")&&this.checkNumericalProblems(t),"complex64"===s)throw new Error("Cannot write to a complex64 dtype. Please use tf.complex(real, imag).");this.texData.set(e,{shape:n,dtype:s,values:t,usage:nA.UPLOAD,refCount:r})}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}readSync(e){const t=this.texData.get(e),{values:n,dtype:s,complexTensorInfos:r,slice:a,shape:i,isPacked:o}=t;if(null!=a){let t;t=o?new k_(i,v_):new x_(i,v_);const n=this.runWebGLProgram(t,[{dataId:e,shape:i,dtype:s}],s),r=this.readSync(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if("string"===s)return n;const l=null!=this.activeTimers;let u,c;if(l&&(u=tr()),"complex64"===s){c=vd(this.readSync(r.real.dataId),this.readSync(r.imag.dataId))}else c=this.getValuesFromTexture(e);return l&&(this.downloadWaitMs+=tr()-u),this.convertAndCacheOnCPU(e,c)}async read(e){if(this.pendingRead.has(e)){const t=this.pendingRead.get(e);return new Promise((e=>t.push(e)))}const t=this.texData.get(e),{values:n,shape:s,slice:r,dtype:a,complexTensorInfos:i,isPacked:o}=t;if(null!=r){let t;t=o?new k_(s,v_):new x_(s,v_);const n=this.runWebGLProgram(t,[{dataId:e,shape:s,dtype:a}],a),r=this.read(n.dataId);return this.disposeIntermediateTensorInfo(n),r}if(null!=n)return this.convertAndCacheOnCPU(e);if(X().getBool("DEBUG")&&!X().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")&&2===X().getNumber("WEBGL_VERSION"))throw new Error("tensor.data() with WEBGL_DOWNLOAD_FLOAT_ENABLED=false and WEBGL_VERSION=2 not yet supported.");let l,u,c=null;if("complex64"!==a&&X().get("WEBGL_BUFFER_SUPPORTED")){l=this.decode(e);const t=this.texData.get(l.dataId);c=this.gpgpu.createBufferFromTexture(t.texture.texture,...aA(s))}if(this.pendingRead.set(e,[]),"complex64"!==a&&await this.gpgpu.createAndWaitForFence(),"complex64"===a){const e=await Promise.all([this.read(i.real.dataId),this.read(i.imag.dataId)]);u=vd(e[0],e[1])}else if(null==c)u=this.getValuesFromTexture(e);else{const e=d(s);u=this.gpgpu.downloadFloat32MatrixFromBuffer(c,e)}if(null!=l&&this.disposeIntermediateTensorInfo(l),null!=c){const e=this.gpgpu.gl;lA(e,(()=>e.deleteBuffer(c)))}const h=this.convertAndCacheOnCPU(e,u),p=this.pendingRead.get(e);return this.pendingRead.delete(e),p.forEach((e=>e(h))),this.pendingDisposal.has(e)&&(this.pendingDisposal.delete(e),this.disposeData(e)&&gi().removeDataId(e,this),this.pendingDeletes--),h}readToGPU(e,t={}){const n=this.texData.get(e),{values:s,shape:r,slice:a,dtype:i,isPacked:o,texture:l}=n;if("complex64"===i)throw new Error("Does not support reading texture for complex64 dtype.");if(null!=a){let n;n=o?new k_(r,v_):new x_(r,v_);const s=this.runWebGLProgram(n,[{dataId:e,shape:r,dtype:i}],i),a=this.readToGPU(s,t);return this.disposeIntermediateTensorInfo(s),a}if(null==l)throw null!=s?new Error("Data is not on GPU but on CPU."):new Error("There is no data on GPU or CPU.");const u=this.decode(e,t.customTexShape),c=gi().makeTensorFromTensorInfo(u),h=this.texData.get(u.dataId);return Object.assign({tensorRef:c},h.texture)}bufferSync(e){const t=this.readSync(e.dataId);if("string"===e.dtype)try{const n=t.map((e=>rr(e)));return ja(e.shape,e.dtype,n)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return ja(e.shape,e.dtype,t)}checkNumericalProblems(e){if(null!=e)for(let t=0;t<e.length;t++){const n=e[t];if(!uA(n)){if(X().getBool("WEBGL_RENDER_FLOAT32_CAPABLE"))throw Error(`The value ${n} cannot be represented with your current settings. Consider enabling float32 rendering: 'tf.env().set('WEBGL_RENDER_FLOAT32_ENABLED', true);'`);throw Error(`The value ${n} cannot be represented on this device.`)}}}getValuesFromTexture(e){const{shape:t,dtype:n,isPacked:s}=this.texData.get(e),r=d(t);if(X().getBool("WEBGL_DOWNLOAD_FLOAT_ENABLED")){const n=this.decode(e),s=this.texData.get(n.dataId),a=this.gpgpu.downloadMatrixFromPackedTexture(s.texture.texture,...aA(t)).subarray(0,r);return this.disposeIntermediateTensorInfo(n),a}const a=X().getBool("WEBGL_PACK")&&!0===s,i=a?NA(t):t,o=a?new lR(i):new oR(i),l=this.runWebGLProgram(o,[{shape:i,dtype:n,dataId:e}],"float32"),u=this.texData.get(l.dataId),c=this.gpgpu.downloadByteEncodedFloatMatrixFromOutputTexture(u.texture.texture,u.texShape[0],u.texShape[1]).subarray(0,r);return this.disposeIntermediateTensorInfo(l),c}timerAvailable(){return X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0}time(e){const t=this.activeTimers,n=[];let s=!1;null==this.programTimersStack?(this.programTimersStack=n,s=!0):this.activeTimers.push(n),this.activeTimers=n,e();const r=p(this.activeTimers.map((e=>e.query))).filter((e=>null!=e)),a=p(this.activeTimers.map((e=>e.name))).filter((e=>null!=e));this.activeTimers=t,s&&(this.programTimersStack=null);const i={uploadWaitMs:this.uploadWaitMs,downloadWaitMs:this.downloadWaitMs,kernelMs:null,wallMs:null};return(async()=>{if(X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0){const e=await Promise.all(r);i.kernelMs=l(e),i.getExtraProfileInfo=()=>e.map(((e,t)=>({name:a[t],ms:e}))).map((e=>`${e.name}: ${e.ms}`)).join(", ")}else i.kernelMs={error:"WebGL query timers are not supported in this environment."};return this.uploadWaitMs=0,this.downloadWaitMs=0,i})()}memory(){return{unreliable:!1,numBytesInGPU:this.numBytesInGPU,numBytesInGPUAllocated:this.textureManager.numBytesAllocated,numBytesInGPUFree:this.textureManager.numBytesFree}}startTimer(){return X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?this.gpgpu.beginQuery():{startMs:tr(),endMs:null}}endTimer(e){return X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0?(this.gpgpu.endQuery(),e):(e.endMs=tr(),e)}async getQueryTime(e){if(X().getNumber("WEBGL_DISJOINT_QUERY_TIMER_EXTENSION_RELIABLE")>0)return this.gpgpu.waitForQueryAndGetTime(e);const t=e;return t.endMs-t.startMs}disposeData(e,t=!1){if(this.pendingDisposal.has(e))return!1;if(!this.texData.has(e))return!0;if(t?this.texData.get(e).refCount=0:this.texData.get(e).refCount--,!t&&this.texData.get(e).refCount>0)return!1;if(this.pendingRead.has(e))return this.pendingDisposal.add(e),this.pendingDeletes++,!1;this.releaseGPUData(e);const{complexTensorInfos:n}=this.texData.get(e);return null!=n&&(this.disposeData(n.real.dataId,t),this.disposeData(n.imag.dataId,t)),this.texData.delete(e),!0}releaseGPUData(e){const{texture:t,dtype:n,texShape:s,usage:r,isPacked:a,slice:i}=this.texData.get(e),o=i&&i.origDataId||e,l=this.dataRefCount.get(o);l>1?this.dataRefCount.set(o,l-1):(this.dataRefCount.delete(o),null!=t&&(this.numBytesInGPU-=this.computeBytes(s,n),this.textureManager.releaseTexture(t,s,r,a)));const u=this.texData.get(e);u.texture=null,u.texShape=null,u.isPacked=!1,u.slice=null}getTexture(e){return this.uploadToGPU(e),this.texData.get(e).texture.texture}getDataInfo(e){return this.texData.get(e)}shouldExecuteOnCPU(e,t=T_){return X().getBool("WEBGL_CPU_FORWARD")&&e.every((e=>null==this.texData.get(e.dataId).texture&&d(e.shape)<t))}getGPGPUContext(){return this.gpgpu}where(e){is("tf.where() in webgl locks the UI thread. Call tf.whereAsync() instead");const t=e.dataSync();return I_(e.shape,t)}packedUnaryOp(e,t,n){const s=new k_(e.shape,t),r=this.compileAndRun(s,[e],n);return gi().makeTensorFromTensorInfo(r)}abs(e){if(this.shouldExecuteOnCPU([e])&&"complex64"!==e.dtype){const t=YR(this.texData.get(e.dataId).values);return this.makeOutput(e.shape,e.dtype,t)}if(X().getBool("WEBGL_PACK_UNARY_OPERATIONS"))return this.packedUnaryOp(e,w_,e.dtype);const t=new x_(e.shape,w_),n=this.compileAndRun(t,[e]);return gi().makeTensorFromTensorInfo(n)}makeTensorInfo(e,t,n){let s;if("string"===t&&null!=n&&n.length>0&&A(n[0])){const r=n.map((e=>sr(e)));s=this.write(r,e,t)}else s=this.write(n,e,t);return this.texData.get(s).usage=null,{dataId:s,shape:e,dtype:t}}makeOutput(e,t,n){return gi().makeTensorFromTensorInfo(this.makeTensorInfo(e,t,n),this)}unpackTensor(e){const t=new N_(e.shape);return this.runWebGLProgram(t,[e],e.dtype)}packTensor(e){const t=new d_(e.shape);return this.runWebGLProgram(t,[e],e.dtype,null,!0)}packedReshape(e,t){const n=[vA(e.shape),...kA(e.shape)],s={dtype:e.dtype,shape:n,dataId:e.dataId},r=[vA(t),...kA(t)],a=new f_(r,n),i=[n],o=this.runWebGLProgram(a,[s],e.dtype,i,!0);return{dataId:o.dataId,shape:t,dtype:o.dtype}}decode(e,t){const n=this.texData.get(e),{isPacked:s,shape:r,dtype:a}=n;if(null!=t){u(d(r)<=t[0]*t[1]*4,(()=>"customTexShape is too small. Row * Column * 4 should be equal or larger than the size of the tensor data."))}const i=NA(r);let o;o=s?new iR(i):new aR(i);const l=[null!=t?t:aA(i)];return{dtype:a,shape:r,dataId:this.runWebGLProgram(o,[{shape:i,dtype:a,dataId:e}],a,l,!0,t).dataId}}runWebGLProgram(e,t,n,s,r=!1,a){const i=this.makeTensorInfo(e.outputShape,n),o=this.texData.get(i.dataId);if(e.packedOutput&&(o.isPacked=!0),e.outPackingScheme===tA.DENSE){const t=null!=a?a:aA(e.outputShape);o.texShape=t.map((e=>2*e))}if(null!=e.outTexUsage&&(o.usage=e.outTexUsage),0===d(i.shape))return o.values=k(i.dtype,0),i;const l=[],u=t.map((t=>{if("complex64"===t.dtype)throw new Error("GPGPUProgram does not support complex64 input. For complex64 dtypes, please separate the program into real and imaginary parts.");let n=this.texData.get(t.dataId);if(null==n.texture){if(!e.packedInputs&&d(t.shape)<=X().getNumber("WEBGL_SIZE_UPLOAD_UNIFORM"))return{shape:t.shape,texData:null,isUniform:!0,uniformValues:n.values};e.packedInputs&&(n.isPacked=!0,n.shape=t.shape)}if(this.uploadToGPU(t.dataId),!!n.isPacked!=!!e.packedInputs)t=n.isPacked?this.unpackTensor(t):this.packTensor(t),l.push(t),n=this.texData.get(t.dataId);else if(n.isPacked&&!SA(n.shape,t.shape)){const e=t,s=t.shape;t.shape=n.shape,t=this.packedReshape(t,s),l.push(t),n=this.texData.get(t.dataId),e.shape=s}return{shape:t.shape,texData:n,isUniform:!1}}));this.uploadToGPU(i.dataId);const c={shape:i.shape,texData:o,isUniform:!1},h=function(e,t,n){let s="";t.concat(n).forEach((t=>{const r=null!=t.texData&&null!=t.texData.slice&&t.texData.slice.flatOffset>0;if(e.enableShapeUniforms&&!t.isUniform){const a=t.texData.texShape,{useSqueezeShape:i,uniformShape:o,keptDims:l}=JA(e.packedInputs,t.shape,a);let u="",c="",h="";if(1===o.length&&e.packedInputs){const e=[Math.ceil(a[0]/2),Math.ceil(a[1]/2)];u=`${e[0]>1}_${e[1]>1}`}else if(2!==o.length||e.packedInputs){if(o.length>2&&!e.packedInputs){const e=M(o);h=`${e[0]===a[1]}_${e[e.length-1]===a[1]}`}}else c=`${o[0]>1}_${o[1]>1}`;const p=t.shape.length,m=2===o.length&&f(t.shape,a),g=1===d(t.shape),y=Ai(t.shape,n.shape),b=!e.packedInputs&&p===n.shape.length&&f(a,n.texData.texShape),x=e.packedInputs||o.length>2?"":`${a[0]>1}_${a[1]>1}`;s+=`${p}_${b}_${i?l:""}_${o.length}_${g}_${y}_${m}_${u}_${c}_${h}_${x}_${r}`}else{const e=t.isUniform?"uniform":t.texData.texShape;s+=`${t.shape}_${e}_${r}`}}));const r=e.userCode;let a=e.constructor.name;return a+="_"+s+"_"+r+`${X().getNumber("WEBGL_VERSION")}`,a}(e,u,c),p=this.getAndSaveBinary(h,(()=>tR(this.gpgpu,e,u,c))),m=null!=this.activeTimers;let g;m&&(g=this.startTimer()),X().get("ENGINE_COMPILE_ONLY")||function(e,t,n,s,r){t.program.enableShapeUniforms||(sR(t.inShapeInfos,n),sR([t.outShapeInfo],[s]));const a=s.texData.texture,i=s.texData.texShape;s.texData.isPacked?e.setOutputPackedMatrixTexture(a.texture,i[0],i[1]):e.setOutputMatrixTexture(a.texture,i[0],i[1]),e.setProgram(t.webGLProgram),1===X().getNumber("WEBGL_VERSION")&&null!==t.infLoc&&e.gl.uniform1f(t.infLoc,1/0),null!==t.nanLoc&&e.gl.uniform1f(t.nanLoc,NaN),n.forEach(((n,s)=>{const r=t.program.variableNames[s],a=t.uniformLocations[r],i=t.uniformLocations[`offset${r}`],o=t.inShapesLocations[`${r}Shape`],l=t.inTexShapesLocations[`${r}TexShape`];if(o){const{uniformShape:s}=JA(t.program.packedInputs,n.shape,n.texData.texShape);switch(s.length){case 1:e.gl.uniform1iv(o,new Int32Array(s));break;case 2:e.gl.uniform2iv(o,new Int32Array(s));break;case 3:e.gl.uniform3iv(o,new Int32Array(s));break;case 4:e.gl.uniform4iv(o,new Int32Array(s))}}if(l&&e.gl.uniform2i(l,n.texData.texShape[0],n.texData.texShape[1]),null!=a)if(n.isUniform)if(d(n.shape)<2)e.gl.uniform1f(a,n.uniformValues[0]);else{let t=n.uniformValues;t instanceof Float32Array||(t=new Float32Array(t)),e.gl.uniform1fv(a,t)}else null!=n.texData.slice&&null!=i&&e.gl.uniform1i(i,n.texData.slice.flatOffset),e.setInputMatrixTexture(n.texData.texture.texture,a,s)}));const o=t.outShapeLocation;if(o)switch(s.shape.length){case 1:e.gl.uniform1iv(o,new Int32Array(s.shape));break;case 2:e.gl.uniform2iv(o,new Int32Array(s.shape));break;case 3:e.gl.uniform3iv(o,new Int32Array(s.shape));break;case 4:e.gl.uniform4iv(o,new Int32Array(s.shape))}if(t.outShapeStridesLocation){const n=M(s.shape);switch(s.shape.length){case 2:e.gl.uniform1iv(t.outShapeStridesLocation,new Int32Array(n));break;case 3:e.gl.uniform2iv(t.outShapeStridesLocation,new Int32Array(n));break;case 4:e.gl.uniform3iv(t.outShapeStridesLocation,new Int32Array(n))}}t.outTexShapeLocation&&e.gl.uniform2i(t.outTexShapeLocation,s.texData.texShape[0],s.texData.texShape[1]),t.program.customUniforms&&r&&t.program.customUniforms.forEach(((n,s)=>{const a=t.customUniformLocations[s],i=r[s];if("float"===n.type)e.gl.uniform1fv(a,i);else if("vec2"===n.type)e.gl.uniform2fv(a,i);else if("vec3"===n.type)e.gl.uniform3fv(a,i);else if("vec4"===n.type)e.gl.uniform4fv(a,i);else if("int"===n.type)e.gl.uniform1iv(a,i);else if("ivec2"===n.type)e.gl.uniform2iv(a,i);else if("ivec3"===n.type)e.gl.uniform3iv(a,i);else{if("ivec4"!==n.type)throw Error(`uniform type ${n.type} is not supported yet.`);e.gl.uniform4iv(a,i)}})),e.executeProgram()}(this.gpgpu,p,u,c,s),l.forEach((e=>this.disposeIntermediateTensorInfo(e))),m&&(g=this.endTimer(g),this.activeTimers.push({name:e.constructor.name,query:this.getQueryTime(g)}));const y=X().get("WEBGL_FLUSH_THRESHOLD");if(y>0){const e=tr();e-this.lastGlFlushTime>y&&(this.gpgpu.gl.flush(),this.lastGlFlushTime=e)}if(!X().getBool("WEBGL_LAZILY_UNPACK")&&o.isPacked&&!1===r){const e=this.unpackTensor(i);return this.disposeIntermediateTensorInfo(i),e}return i}compileAndRun(e,t,n,s,r=!1){n=n||t[0].dtype;return this.runWebGLProgram(e,t,n,s,r)}getAndSaveBinary(e,t){return e in this.binaryCache||(this.binaryCache[e]=t()),this.binaryCache[e]}getTextureManager(){return this.textureManager}dispose(){if(!this.disposed){if(!X().getBool("IS_TEST")){Object.keys(this.binaryCache).forEach((e=>{this.gpgpu.deleteProgram(this.binaryCache[e].webGLProgram),delete this.binaryCache[e]}))}this.textureManager.dispose(),null!=this.canvas&&"undefined"!=typeof HTMLCanvasElement&&this.canvas instanceof HTMLCanvasElement?this.canvas.remove():this.canvas=null,this.gpgpuCreatedLocally&&(this.gpgpu.program=null,this.gpgpu.dispose()),this.disposed=!0}}floatPrecision(){return null==this.floatPrecisionValue&&(this.floatPrecisionValue=bi((()=>{if(!X().get("WEBGL_RENDER_FLOAT32_ENABLED")){const e=X().getBool("DEBUG");X().set("DEBUG",!1);const t=this.abs(Ql(1e-8)).dataSync()[0];if(X().set("DEBUG",e),t>0)return 32}return 16}))),this.floatPrecisionValue}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}uploadToGPU(e){const t=this.texData.get(e),{shape:n,dtype:s,values:r,texture:a,usage:o,isPacked:l}=t;if(null!=a)return;const u=null!=this.activeTimers;let c;u&&(c=tr());let h=t.texShape;if(null==h&&(h=function(e,t=!1){let n=X().getNumber("WEBGL_MAX_TEXTURE_SIZE");if(t&&(n*=2,1===(e=e.map(((t,n)=>n>=e.length-2?i(e[n]):e[n]))).length&&(e=[2,e[0]])),2!==e.length){const t=v(e);e=t.newShape}let s=d(e);if(e.length<=1&&s<=n)return[1,s];if(2===e.length&&e[0]<=n&&e[1]<=n)return e;if(3===e.length&&e[0]*e[1]<=n&&e[2]<=n)return[e[0]*e[1],e[2]];if(3===e.length&&e[0]<=n&&e[1]*e[2]<=n)return[e[0],e[1]*e[2]];if(4===e.length&&e[0]*e[1]*e[2]<=n&&e[3]<=n)return[e[0]*e[1]*e[2],e[3]];if(4===e.length&&e[0]<=n&&e[1]*e[2]*e[3]<=n)return[e[0],e[1]*e[2]*e[3]];if(t){const t=vA(e);let n=2,r=2;return e.length&&([n,r]=kA(e)),s=t*(n/2)*(r/2),g(s).map((e=>2*e))}return g(s)}(n,l),t.texShape=h),null!=r){const e=NA(n);let a,i=h[1],o=h[0];const p=r instanceof Uint8Array||r instanceof Uint8ClampedArray;!l&&p||([i,o]=iA(h[0],h[1])),a=l?new cR(e,p):new uR(e,p);const d=p?[o,i]:h,f=this.makeTensorInfo(d,s),m=this.texData.get(f.dataId);m.usage=p?nA.PIXELS:nA.UPLOAD,m.texShape=d,this.gpgpu.uploadDenseMatrixToTexture(this.getTexture(f.dataId),i,o,r);const g=[[o,i]],y=!0,b=this.runWebGLProgram(a,[f],s,g,y),x=this.texData.get(b.dataId);t.texShape=x.texShape,t.isPacked=x.isPacked,t.usage=x.usage,X().get("ENGINE_COMPILE_ONLY")?this.disposeData(b.dataId):(t.texture=x.texture,t.values=null,this.texData.delete(b.dataId)),this.disposeIntermediateTensorInfo(f),u&&(this.uploadWaitMs+=tr()-c)}else{const e=this.acquireTexture(h,o,s,l);t.texture=e}}convertAndCacheOnCPU(e,t){const n=this.texData.get(e),{dtype:s}=n;return this.releaseGPUData(e),null!=t&&(n.values=function(e,t){if("float32"===t||"complex64"===t)return e;if("int32"===t||"bool"===t){const n="int32"===t?new Int32Array(e.length):new Uint8Array(e.length);for(let t=0;t<n.length;++t)n[t]=Math.round(e[t]);return n}throw new Error(`Unknown dtype ${t}`)}(t,s)),n.values}acquireTexture(e,t,n,s){if(this.numBytesInGPU+=this.computeBytes(e,n),!this.warnedAboutMemory&&this.numBytesInGPU>1024*this.numMBBeforeWarning*1024){const e=(this.numBytesInGPU/1024/1024).toFixed(2);this.warnedAboutMemory=!0,console.warn(`High memory usage in GPU: ${e} MB, most likely due to a memory leak`)}return this.textureManager.acquireTexture(e,t,s)}computeBytes(e,t){return e[0]*e[1]*C(t)}checkCompileCompletion(){for(const[,e]of Object.entries(this.binaryCache))this.checkCompletion_(e)}async checkCompileCompletionAsync(){const e=[];if(this.gpgpu.parallelCompilationExtension){for(const[,t]of Object.entries(this.binaryCache))e.push(this.checkCompletionAsync_(t));return Promise.all(e)}for(const[,t]of Object.entries(this.binaryCache)){const n=new Promise((e=>{try{this.checkCompletion_(t),e(!0)}catch(e){throw e}}));e.push(n)}return Promise.all(e)}async checkCompletionAsync_(e){return this.gpgpu.gl.getProgramParameter(e.webGLProgram,this.gpgpu.parallelCompilationExtension.COMPLETION_STATUS_KHR)?this.checkCompletion_(e):(await sd(),this.checkCompletionAsync_(e))}checkCompletion_(e){if(!1===this.gpgpu.gl.getProgramParameter(e.webGLProgram,this.gpgpu.gl.LINK_STATUS)){if(console.log(this.gpgpu.gl.getProgramInfoLog(e.webGLProgram)),!1===this.gpgpu.gl.getShaderParameter(e.fragmentShader,this.gpgpu.gl.COMPILE_STATUS))throw pA(e.source,this.gpgpu.gl.getShaderInfoLog(e.fragmentShader)),new Error("Failed to compile fragment shader.");throw new Error("Failed to link vertex and fragment shaders.")}return!0}getUniformLocations(){for(const[,e]of Object.entries(this.binaryCache)){const{uniformLocations:t,customUniformLocations:n,infLoc:s,nanLoc:r,inShapesLocations:a,inTexShapesLocations:i,outShapeLocation:o,outShapeStridesLocation:l,outTexShapeLocation:u}=nR(this.gpgpu,e.program,e.webGLProgram);e.uniformLocations=t,e.customUniformLocations=n,e.infLoc=s,e.nanLoc=r,e.inShapesLocations=a,e.inTexShapesLocations=i,e.outShapeLocation=o,e.outShapeStridesLocation=l,e.outTexShapeLocation=u}}}$_.nextDataId=0;Ur()&&ki("webgl",(()=>new $_),2);class C_{constructor(e,t,n){this.variableNames=["A","B"],this.outputShape=_i(t,n),this.enableShapeUniforms=rR(this.outputShape.length),this.userCode=`\n      float binaryOperation(float a, float b) {\n        ${e}\n      }\n\n      void main() {\n        float a = getAAtOutCoords();\n        float b = getBAtOutCoords();\n        setOutput(binaryOperation(a, b));\n      }\n    `}}class E_{constructor(e,t,n,s=!1){this.variableNames=["A","B"],this.supportsBroadcasting=!0,this.packedInputs=!0,this.packedOutput=!0,this.outputShape=_i(t,n);const r=this.outputShape.length;this.enableShapeUniforms=rR(r);let a="";if(s)if(0===r||1===d(this.outputShape))a="\n          result.y = 0.;\n          result.z = 0.;\n          result.w = 0.;\n        ";else{if(a=`\n          ${ZA(r)} coords = getOutputCoords();\n        `,1===r)this.enableShapeUniforms?a+="\n            result.y = (coords + 1) >= outShape ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          ":a+=`\n            result.y = (coords + 1) >= ${this.outputShape[0]} ? 0. : result.y;\n            result.z = 0.;\n            result.w = 0.;\n          `;else{const e=p_("coords",r);this.enableShapeUniforms?a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= outShape[${r} - 2];\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= outShape[${r} - 1];\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `:a+=`\n            bool nextRowOutOfBounds =\n              (${e[r-2]} + 1) >= ${this.outputShape[r-2]};\n            bool nextColOutOfBounds =\n              (${e[r-1]} + 1) >= ${this.outputShape[r-1]};\n            result.y = nextColOutOfBounds ? 0. : result.y;\n            result.z = nextRowOutOfBounds ? 0. : result.z;\n            result.w = nextColOutOfBounds || nextRowOutOfBounds ? 0. : result.w;\n          `}}this.userCode=`\n      vec4 binaryOperation(vec4 a, vec4 b) {\n        ${e}\n      }\n\n      void main() {\n        vec4 a = getAAtOutCoords();\n        vec4 b = getBAtOutCoords();\n\n        vec4 result = binaryOperation(a, b);\n        ${a}\n\n        setOutput(result);\n      }\n    `}}function A_(e){const{inputs:t,backend:n}=e,{x:s}=t;return n.incRef(s.dataId),{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}const R_={kernelName:dt,backendName:"webgl",kernelFunc:A_};function __(e){const{inputs:t,backend:n}=e,{real:s,imag:r}=t,a=n.makeTensorInfo(s.shape,"complex64"),i=n.texData.get(a.dataId),o=A_({inputs:{x:s},backend:n}),l=A_({inputs:{x:r},backend:n});return i.complexTensorInfos={real:o,imag:l},a}const F_={kernelName:Se,backendName:"webgl",kernelFunc:__},D_="return (a < 0.) ? b * a : a;",O_="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const M_={kernelName:xt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{alpha:a}=s,i=n.makeTensorInfo([],"float32",Qs(a,"float32")),o=X().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new E_(O_,r.shape,i.shape):new C_(D_,r.shape,i.shape),l=n.runWebGLProgram(o,[r,i],"float32");return n.disposeIntermediateTensorInfo(i),l}},L_="return (a < 0.) ? b * a : a;",z_="\n  vec4 aLessThanZero = vec4(lessThan(a, vec4(0.)));\n  return (aLessThanZero * (b * a)) + ((vec4(1.0) - aLessThanZero) * a);\n";const P_={kernelName:tn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s,alpha:r}=t,a=X().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new E_(z_,s.shape,r.shape):new C_(L_,s.shape,r.shape);return n.runWebGLProgram(a,[s,r],"float32")}};function B_({opSnippet:e,packedOpSnippet:t,cpuKernelImpl:n,dtype:s}){return({inputs:r,backend:a})=>{const{x:i}=r,o=a,l=s||i.dtype;if(o.shouldExecuteOnCPU([i])&&null!=n){const e=o.texData.get(i.dataId),t=n(e.values,l);return o.makeTensorInfo(i.shape,l,t)}let u;return u=X().getBool("WEBGL_PACK_UNARY_OPERATIONS")&&null!=t?new k_(i.shape,t):new x_(i.shape,e),o.runWebGLProgram(u,[i],l)}}function W_({opSnippet:e,packedOpSnippet:t,checkOutOfBounds:n=!1,supportsComplex:s=!1,cpuKernelImpl:r,dtype:a}){return({inputs:i,backend:o})=>{const{a:l,b:u}=i,c=o;if(s&&"complex64"===l.dtype){const t=c.texData.get(l.dataId),n=c.texData.get(u.dataId),[s,r]=[[t.complexTensorInfos.real,n.complexTensorInfos.real],[t.complexTensorInfos.imag,n.complexTensorInfos.imag]].map((t=>{const[n,s]=t,r={dataId:n.dataId,dtype:n.dtype,shape:l.shape},a={dataId:s.dataId,dtype:s.dtype,shape:u.shape},i=new C_(e,l.shape,u.shape);return c.runWebGLProgram(i,[r,a],$r(n.dtype,s.dtype))})),a=__({inputs:{real:s,imag:r},backend:c});return c.disposeIntermediateTensorInfo(s),c.disposeIntermediateTensorInfo(r),a}const h=a||$r(l.dtype,u.dtype);if(("string"===l.dtype||"string"===u.dtype||c.shouldExecuteOnCPU([l,u]))&&null!=r){const e=c.texData.get(l.dataId).values,t=c.texData.get(u.dataId).values,n="string"===l.dtype?ef(e):e,s="string"===l.dtype?ef(t):t,[a,i]=r(l.shape,u.shape,n,s,h),o=c.makeTensorInfo(i,h);return c.texData.get(o.dataId).values=a,o}let p;return p=X().getBool("WEBGL_PACK_BINARY_OPERATIONS")&&null!=t?new E_(t,l.shape,u.shape,n):new C_(e,l.shape,u.shape),c.runWebGLProgram(p,[l,u],h)}}function V_(e,t=!1){if("linear"===e)return"return x;";if("relu"===e)return t?"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n";if("elu"===e)return t?"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n":"return (x >= 0.0) ? x : (exp(x) - 1.0);";if("relu6"===e)return t?"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n":"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n";if("prelu"===e)return t?z_:L_;if("leakyrelu"===e)return t?O_:D_;if("sigmoid"===e)return"return 1.0 / (1.0 + exp(-1.0 * x));";throw new Error(`Activation ${e} has not been implemented for the WebGL backend.`)}class U_{constructor(e,t,n,s=!1,r=!1,a=!1,i=null,o=!1,l=!1){this.variableNames=["matrixA","matrixB"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=n,this.enableShapeUniforms=rR(this.outputShape.length);const u=s?e[1]:e[2],c=Math.ceil(u/2),h=s?"i * 2, rc.y":"rc.y, i * 2",p=r?"rc.z, i * 2":"i * 2, rc.z",d=s?["a.xxyy","a.zzww"]:["a.xxzz","a.yyww"],f=r?["b.xzxz","b.ywyw"]:["b.xyxy","b.zwzw"];let m="",g="";i&&(m=o?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${i}\n        }`:l?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${i}\n        }`:`vec4 activation(vec4 x) {\n          ${i}\n        }`,g="result = activation(result);");const y=a?"result += getBiasAtOutCoords();":"";a&&this.variableNames.push("bias"),o&&this.variableNames.push("preluActivationWeights"),l&&this.variableNames.push("leakyreluAlpha");let b="rc.x",x="rc.x";e[0]<t[0]?b=`int(min(float(rc.x), ${e[0]-1}.))`:t[0]<e[0]&&(x=`int(min(float(rc.x), ${t[0]-1}.))`),this.userCode=`\n      ${m}\n      // Don't use uniform for sharedDimensionPacked for performance.\n      const float sharedDimension = ${c}.0;\n\n      vec4 dot2x2ARowBCol(ivec3 rc) {\n        vec4 result = vec4(0);\n        for (int i = 0; i < ${c}; i++) {\n          int batchA = ${b};\n          int batchB = ${x};\n          vec4 a = getMatrixA(batchA, ${h});\n          vec4 b = getMatrixB(batchB, ${p});\n\n          // These swizzled products need to be separately added.\n          // See: https://github.com/tensorflow/tfjs/issues/1735\n          result += (${d[0]} * ${f[0]});\n          result += (${d[1]} * ${f[1]});\n        }\n        return result;\n      }\n\n      void main() {\n        ivec3 rc = getOutputCoords();\n        vec4 result = dot2x2ARowBCol(rc);\n\n        ${y}\n\n        ${g}\n\n        setOutput(result);\n      }\n    `}}const G_="return areal * breal - aimag * bimag;",H_="return areal * bimag + aimag * breal;";class j_{constructor(e,t,n){this.variableNames=["AReal","AImag","BReal","BImag"],this.outputShape=_i(t,n),this.userCode=`\n      float binaryOpComplex(\n          float areal, float aimag, float breal, float bimag) {\n        ${e}\n      }\n\n      void main() {\n        float areal = getARealAtOutCoords();\n        float aimag = getAImagAtOutCoords();\n        float breal = getBRealAtOutCoords();\n        float bimag = getBImagAtOutCoords();\n        setOutput(binaryOpComplex(areal, aimag, breal, bimag));\n      }\n    `}}const q_="return a * b;";function K_(e){const{inputs:t,backend:n}=e,{a:s,b:r}=t,a=$r(s.dtype,r.dtype);if("complex64"===s.dtype){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),a=new j_(G_,s.shape,r.shape),i=new j_(H_,s.shape,r.shape),o=[{dataId:e.complexTensorInfos.real.dataId,dtype:e.complexTensorInfos.real.dtype,shape:s.shape},{dataId:e.complexTensorInfos.imag.dataId,dtype:e.complexTensorInfos.imag.dtype,shape:s.shape},{dataId:t.complexTensorInfos.real.dataId,dtype:t.complexTensorInfos.real.dtype,shape:r.shape},{dataId:t.complexTensorInfos.imag.dataId,dtype:t.complexTensorInfos.imag.dtype,shape:r.shape}],l=n.runWebGLProgram(a,o,"float32"),u=n.runWebGLProgram(i,o,"float32"),c=__({inputs:{real:l,imag:u},backend:n});return n.disposeIntermediateTensorInfo(l),n.disposeIntermediateTensorInfo(u),c}if(n.shouldExecuteOnCPU([s,r])){const e=n.texData.get(s.dataId),t=n.texData.get(r.dataId),[i,o]=VR(s.shape,r.shape,e.values,t.values,a),l=n.makeTensorInfo(o,a);return n.texData.get(l.dataId).values=i,l}let i;return i=X().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new E_(q_,s.shape,r.shape):new C_(q_,s.shape,r.shape),n.runWebGLProgram(i,[s,r],a)}const X_={kernelName:Gt,backendName:"webgl",kernelFunc:K_};function Y_(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{shape:a}=s,i=n,o=d(r.shape),l=x(a,o),c=d(l);u(o===c,(()=>`The new shape (${l}) has ${c} elements and the old shape (${r.shape}) has ${o} elements. The new shape and old shape must have the same number of elements.`));const h=i.texData.get(r.dataId);return!h.isPacked||SA(r.shape,l)||null!==h.texture&&SA(h.shape,l)?(i.incRef(r.dataId),{dataId:r.dataId,shape:l,dtype:r.dtype}):function(e,t,n){const s=[vA(e.shape),...kA(e.shape)],r={dtype:e.dtype,shape:s,dataId:e.dataId},a=[vA(t),...kA(t)],i=new f_(a,s),o=[s],l=n.runWebGLProgram(i,[r],e.dtype,o,!0);return{dataId:l.dataId,shape:t,dtype:l.dtype}}(r,l,i)}const Z_={kernelName:ln,backendName:"webgl",kernelFunc:Y_};class J_{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];const i=4*Math.floor(n/4),o=n%4;let l="sumValue += dot(values, ones);";if(null!=t){const e=1/t;l=`sumValue += dot(values * ${m(e)?e.toPrecision(2):e}, ones);`}let u="";r%n>0&&(u=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return 0.0;\n        }\n      `),this.userCode=`\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${u}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        float sumValue = 0.0;\n\n        for (int i = 0; i < ${i}; i += 4) {\n          int inIdx = inOffset + i;\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${l}\n        }\n\n        int inIdx = inOffset + ${i};\n        if (${1===o}) {\n          vec4 values = vec4(getValue(batch, inIdx), 0.0, 0.0, 0.0);\n\n          ${l}\n        } else if (${2===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1), 0.0, 0.0);\n\n          ${l}\n        } else if (${3===o}) {\n          vec4 values = vec4(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2), 0.0);\n\n          ${l}\n        }\n        setOutput(sumValue);\n      }\n    `}}class Q_{constructor(e,t){this.variableNames=["x"];const{windowSize:n,batchSize:s,inSize:r,outSize:a}=e;this.outputShape=[s,a];let i="0.0",o="";"prod"===t?i="1.0":"min"===t?(i="1.0 / 1e-20",o="min"):"max"===t&&(i="-1.0 / 1e-20",o="max");let l=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"sum"===t?l="sumValue":"prod"===t?l="prodValue":"all"===t?l="allValue":"any"===t&&(l="anyValue");const u=4*Math.floor(n/4),c=n%4;let h=`\n      if (${"sum"===t}) {\n        sumValue += dot(values, ones);\n      } else if (${"prod"===t}) {\n        vec2 tmp = vec2(values[0], values[1]) * vec2(values[2], values[3]);\n        prodValue *= tmp[0] * tmp[1];\n      } else {\n        minMaxValue = ${o}(values, minMaxValue);\n        if (${"min"===t} || ${"max"===t}) {\n          minMaxValue = ${o}(values, minMaxValue);\n          bvec4 isNaN = isnan(values);\n          if (isNaN.r || isNaN.g || isNaN.b || isNaN.a) {\n            minMaxValue = vec4(NAN);\n          }\n        }\n      }\n    `,p="vec4";"all"===t?(i="1.0",h="\n        bool reducedAllValue = all(values);\n        float floatedReducedAllValue = float(reducedAllValue);\n        allValue = float(allValue >= 1.0 && floatedReducedAllValue >= 1.0);\n      ",p="bvec4"):"any"===t&&(i="0.0",h="\n        bool reducedAnyValue = any(values);\n        float floatedReducedAnyValue = float(reducedAnyValue);\n        anyValue = float(anyValue >= 1.0 || floatedReducedAnyValue >= 1.0);\n      ",p="bvec4");let d="";r%n>0&&(d=`\n        if (inIdx < 0 || inIdx >= ${r}) {\n          return initializationValue;\n        }\n      `),this.userCode=`\n      const float initializationValue = ${i};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float getValue(int batch, int inIdx) {\n        ${d}\n        return getX(batch, inIdx);\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${n};\n\n        vec4 minMaxValue = vec4(${i});\n        float prodValue = 1.0;\n        float sumValue = 0.0;\n        float allValue = 1.0;\n        float anyValue = 0.0;\n\n        for (int i = 0; i < ${u}; i += 4) {\n          int inIdx = inOffset + i;\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            getValue(batch, inIdx + 3)\n          );\n\n          ${h}\n        }\n\n        int inIdx = inOffset + ${u};\n        if (${1===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            initializationValue,\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${2===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            initializationValue,\n            initializationValue\n          );\n\n          ${h}\n        } else if (${3===c}) {\n          ${p} values = ${p}(\n            getValue(batch, inIdx),\n            getValue(batch, inIdx + 1),\n            getValue(batch, inIdx + 2),\n            initializationValue\n          );\n\n          ${h}\n        }\n        setOutput(${l});\n      }\n    `}}function eF(e,t,n,s){const r=function(e){const t=[];for(;0===t.length||1!==t[t.length-1].outSize;){const n=t.length?t[t.length-1].outSize:e[1],s=id(n);t.push({inSize:n,windowSize:s,outSize:Math.ceil(n/s)})}return t}(e.shape);let a=e;for(let i=0;i<r.length;i++){const{inSize:o,windowSize:l,outSize:u}=r[i];let c,h;c="mean"===n?0===i?new J_({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},o):new J_({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u}):new Q_({windowSize:l,inSize:o,batchSize:e.shape[0],outSize:u},n),h=a,a=s.runWebGLProgram(c,[a],t),h.dataId!==e.dataId&&s.disposeIntermediateTensorInfo(h)}return a}class tF{constructor(e,t){this.variableNames=["A"];const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];this.outputShape=n,this.rank=n.length;const s=ZA(this.rank),r=function(e){const t=e.length;if(t>6)throw Error(`Transpose for rank ${t} is not yet supported`);const n=["resRC.x","resRC.y","resRC.z","resRC.w","resRC.u","resRC.v"],s=new Array(t);for(let t=0;t<e.length;t++)s[e[t]]=n[t];return s.join()}(t);this.userCode=`\n    void main() {\n      ${s} resRC = getOutputCoords();\n      setOutput(getA(${r}));\n    }\n    `}}class nF{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0;const n=new Array(e.length);for(let s=0;s<n.length;s++)n[s]=e[t[s]];if(this.outputShape=n,this.rank=n.length,this.rank>6)throw Error(`Packed transpose for rank ${this.rank} is not yet supported.`);const s=ZA(this.rank),r=h_("rc",this.rank),a=new Array(this.rank);for(let e=0;e<t.length;e++)a[t[e]]=r[e];const i=`vec2(${a.slice(-2).join()})`,o=`++${r[this.rank-1]} < ${n[this.rank-1]}`,l=`getChannel(getA(${a.join()}), ${i})`;this.userCode=`\n    void main() {\n      ${s} rc = getOutputCoords();\n      vec4 result = vec4(0.);\n      result[0] = ${l};\n      if(${o}) {\n        result[1] = ${l};\n      }\n      --${r[this.rank-1]};\n      if(++${r[this.rank-2]} < ${n[this.rank-2]}) {\n        result[2] = ${l};\n        if(${o}) {\n          result[3] = ${l};\n        }\n      }\n      setOutput(result);\n    }\n    `}}function sF(e,t,n){const s=X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new nF(e.shape,t):new tF(e.shape,t);return n.runWebGLProgram(s,[e],e.dtype)}function rF(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s;return function(e,t,n,s){const r=t,a=e.shape.length,i=w(r,e.shape);let o=i;const l=ql(o,a),u=null!=l;let c=e;u&&(c=sF(e,l,s),o=Xl(o.length,a)),jl("sum",o,a);const[h,p]=Gl(c.shape,o);let f=h;n&&(f=Hl(h,i));const m=d(p),g=Y_({inputs:{x:c},attrs:{shape:[d(e.shape)/m,m]},backend:s}),y=eF(g,Cr(e.dtype),"sum",s),b=Y_({inputs:{x:y},attrs:{shape:f},backend:s});return s.disposeIntermediateTensorInfo(g),s.disposeIntermediateTensorInfo(y),u&&s.disposeIntermediateTensorInfo(c),b}(r,a,i,n)}const aF={kernelName:Cn,backendName:"webgl",kernelFunc:rF};function iF(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{perm:a}=s,i=n,o=r.shape.length,l=new Array(o);for(let e=0;e<l.length;e++)l[e]=r.shape[a[e]];let u;if(i.shouldExecuteOnCPU([r])){const e=i.texData.get(r.dataId).values,t=u_(e,r.shape,r.dtype,a,l);u=i.makeTensorInfo(l,r.dtype);i.texData.get(u.dataId).values=t}else u=sF(r,a,i);return u}const oF={kernelName:Xn,backendName:"webgl",kernelFunc:iF};function lF({a:e,b:t,transposeA:n,transposeB:s,backend:r,bias:a=null,preluActivationWeights:i=null,leakyreluAlpha:o=0,activation:l=null}){const c=e.shape.length,h=t.shape.length,p=n?e.shape[c-2]:e.shape[c-1],f=s?t.shape[h-1]:t.shape[h-2],m=n?e.shape[c-1]:e.shape[c-2],g=s?t.shape[h-2]:t.shape[h-1],y=e.shape.slice(0,-2),b=t.shape.slice(0,-2),x=d(y),w=d(b),v=_i(e.shape.slice(0,-2),t.shape.slice(0,-2)).concat([m,g]);u(p===f,(()=>`Error in matMul: inner shapes (${p}) and (${f}) of Tensors with shapes ${e.shape} and ${t.shape} and transposeA=${n} and transposeB=${s} must match.`));const k=n?[x,p,m]:[x,m,p],N=s?[w,g,f]:[w,f,g],I=Y_({inputs:{x:e},backend:r,attrs:{shape:k}}),S=Y_({inputs:{x:t},backend:r,attrs:{shape:N}}),T=[I,S],$=Math.max(x,w),C=n?I.shape[1]:I.shape[2],E=null!=a,A=null!=i,R="leakyrelu"===l,_=null!=l?V_(l,!0):null;let F;if((1===m||1===g)&&C>1e3&&!1===(E||A||R||null!=_)){let e=I,t=S;n&&(e=iF({inputs:{x:I},backend:r,attrs:{perm:[0,2,1]}}),T.push(e)),s&&(t=iF({inputs:{x:S},backend:r,attrs:{perm:[0,2,1]}}),T.push(t));const a=1===g;let i=e;1!==g&&(i=Y_({inputs:{x:e},backend:r,attrs:{shape:[$,C,1]}}),T.push(i));const o=1===g?2:1;let l=t;a&&(l=Y_({inputs:{x:t},backend:r,attrs:{shape:[$,1,C]}}),T.push(l));const u=K_({inputs:{a:i,b:l},backend:r});F=rF({inputs:{x:u},backend:r,attrs:{axis:o,keepDims:!0}}),T.push(u)}else{const l=$r(e.dtype,t.dtype),u=new U_(k,N,[$,m,g],n,s,E,_,A,R),c=[I,S];if(null!=a&&c.push(a),A&&c.push(i),R){const e=r.makeTensorInfo([],"float32",Qs(o,"float32"));c.push(e),T.push(e)}F=r.runWebGLProgram(u,c,l)}const D=Y_({inputs:{x:F},backend:r,attrs:{shape:v}});T.push(F);for(const e of T)r.disposeIntermediateTensorInfo(e);return D}const uF={kernelName:ss,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a,bias:i,preluActivationWeights:o}=t,{transposeA:l,transposeB:u,activation:c,leakyreluAlpha:h}=s;return lF({a:r,b:a,transposeA:l,transposeB:u,backend:n,bias:i,preluActivationWeights:o,leakyreluAlpha:h,activation:c})}},cF="return abs(x);";const hF={kernelName:Q,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])&&"complex64"!==s.dtype){const e=n.texData.get(s.dataId),t=YR(e.values);return n.makeTensorInfo(s.shape,s.dtype,t)}let r;return r=X().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new k_(s.shape,cF):new x_(s.shape,cF),n.runWebGLProgram(r,[s],s.dtype)}},pF=B_({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return acos(x);\n"}),dF={kernelName:ee,backendName:"webgl",kernelFunc:pF},fF=B_({opSnippet:"if (isnan(x)) return x;\n  if (x < 1.0) return NAN;\nreturn log(x + sqrt(x * x - 1.0));"}),mF={kernelName:te,backendName:"webgl",kernelFunc:fF},gF="return a + b;",yF=W_({opSnippet:gF,packedOpSnippet:gF,supportsComplex:!0,cpuKernelImpl:kR}),bF={kernelName:ne,backendName:"webgl",kernelFunc:yF};class xF{constructor(e,t){this.outputShape=[],this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`float v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        float result = ${s};\n        setOutput(result);\n      }\n    `}}class wF{constructor(e,t){this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.variableNames=t.map(((e,t)=>`T${t}`));const n=[];this.variableNames.forEach((e=>{n.push(`vec4 v${e} = get${e}AtOutCoords();`)}));const s=this.variableNames.map((e=>`v${e}`)).join(" + ");this.userCode=`\n      void main() {\n        ${n.join("\n        ")}\n\n        vec4 result = ${s};\n        setOutput(result);\n      }\n    `}}const vF={kernelName:se,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,r=n;if(1===r.length)return A_({inputs:{x:r[0]},backend:s});if(r.length>X().get("WEBGL_MAX_TEXTURES_IN_SHADER")){const t=Math.floor(r.length/2),n=e({inputs:r.slice(0,t),backend:s}),a=e({inputs:r.slice(t),backend:s});return e({inputs:[n,a],backend:s})}const a=r.map((e=>e.dtype)).reduce(((e,t)=>$r(e,t))),i=r.map((e=>e.shape)),o=X().getBool("WEBGL_PACK")?new wF(r[0].shape,i):new xF(r[0].shape,i);return s.runWebGLProgram(o,r,a)}};const kF={kernelName:re,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=ql(u,o);let h=r;null!=c&&(h=iF({inputs:{x:r},backend:n,attrs:{perm:c}}),u=Xl(u.length,o)),jl("all",u,o);const[p,f]=Gl(h.shape,u),m=Y_({inputs:{x:h},backend:n,attrs:{shape:[-1,d(f)]}}),g=eF(m,m.dtype,"all",n);let y;if(i){y=Y_({inputs:{x:g},backend:n,attrs:{shape:Hl(p,l)}})}else y=Y_({inputs:{x:g},backend:n,attrs:{shape:p}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};const NF={kernelName:ae,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=ql(u,o);let h=r;null!=c&&(h=iF({inputs:{x:r},backend:n,attrs:{perm:c}}),u=Xl(u.length,o)),jl("any",u,o);const[p,f]=Gl(h.shape,u),m=Y_({inputs:{x:h},backend:n,attrs:{shape:[-1,d(f)]}}),g=eF(m,m.dtype,"any",n);let y;if(i){y=Y_({inputs:{x:g},backend:n,attrs:{shape:Hl(p,l)}})}else y=Y_({inputs:{x:g},backend:n,attrs:{shape:p}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}};class IF{constructor(e,t,n){this.variableNames=["A"];const{windowSize:s,batchSize:r,outSize:a}=e;n||this.variableNames.push("bestIndicesA"),this.outputShape=[r,a];const i="max"===t?">":"<",o=n?"inOffset + i;":"round(getBestIndicesA(batch, inOffset + i));";this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n        int outIdx = coords[1];\n        int inOffset = outIdx * ${s};\n\n        int bestIndex = inOffset;\n        float bestValue = getA(batch, bestIndex);\n\n        for (int i = 0; i < ${s}; i++) {\n          int inIdx = ${o};\n          float candidate = getA(batch, inIdx);\n          if (candidate ${i} bestValue) {\n            bestValue = candidate;\n            bestIndex = inIdx;\n          }\n        }\n        setOutput(float(bestIndex));\n      }\n    `}}class SF{constructor(e,t,n,s){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,u(e.length>2,(()=>`Packed arg${n.charAt(0).toUpperCase()+n.slice(1)} supports only inputs with rank above 2.`));const r=e[e.length-1],a=Math.ceil(r/t);this.outputShape=e.slice(0,-1),a>1&&this.outputShape.push(a),s||this.variableNames.push("bestIndicesA");const i=this.outputShape,o=i.length,l=ZA(o),c=p_("coords",o);let h,p;if(1===a){p=o+1;const e=ZA(p);h=`\n        ${e} sourceLocR = ${e}(${c.join()}, 0);\n        ++${c[o-1]};\n        ${e} sourceLocG = ${e}(${c.join()}, 0);\n        ++${c[o-2]};\n        ${e} sourceLocA = ${e}(${c.join()}, 0);\n        --${c[o-1]};\n        ${e} sourceLocB = ${e}(${c.join()}, 0);\n        --${c[o-2]};`}else p=o,h=`\n        ${l} sourceLocR = coords;\n        ++${c[o-1]};\n        ${l} sourceLocG = coords;\n        ++${c[o-2]};\n        ${l} sourceLocA = coords;\n        --${c[o-1]};\n        ${l} sourceLocB = coords;\n        --${c[o-2]};`;const d=["x","y","z","w","u","v"].slice(0,p),f="."+d[p-1],m=d.map((e=>"int "+e)),g=p_("sourceLocR",p-1).concat("inIdx.r"),y=p_("sourceLocG",p-1).concat("inIdx.g"),b=p_("sourceLocB",p-1).concat("inIdx.b"),x=p_("sourceLocA",p-1).concat("inIdx.a"),w="max"===n?"greaterThan":"lessThan",v=s?"":`\n          inIdx = round(vec4(getBestIndicesAChannel(${g.join()}),\n                             getBestIndicesAChannel(${y.join()}),\n                             getBestIndicesAChannel(${b.join()}),\n                             getBestIndicesAChannel(${x.join()})));`,k=`vec4(\n            getAChannel(${g.join()}),\n            hasNextCol ? getAChannel(${y.join()}) : 0.,\n            hasNextRow ? getAChannel(${b.join()}) : 0.,\n            hasNextRow && hasNextCol ? getAChannel(${x.join()}) : 0.)`,N=s?"":`\n      float getBestIndicesAChannel(${m.join()}) {\n        return getChannel(getBestIndicesA(${d.join()}),\n                                          vec2(${d.slice(-2).join()}));\n      }`;this.userCode=`\n      float getAChannel(${m.join()}) {\n        return getChannel(getA(${d.join()}),\n                               vec2(${d.slice(-2).join()}));\n      }\n      ${N}\n      void main() {\n        ${l} coords = getOutputCoords();\n        bool hasNextCol = ${c[o-1]} < ${i[o-1]-1};\n        bool hasNextRow = ${c[o-2]} < ${i[o-2]-1};\n        ${h}\n        ivec4 srcIdx = ivec4(sourceLocR${f}, sourceLocG${f},\n          sourceLocB${f}, sourceLocA${f}) * ${t};\n        ivec4 inIdx = srcIdx;\n        vec4 bestIndex = vec4(inIdx);\n        vec4 bestValue = ${k};\n\n        for (int i = 0; i < ${t}; i++) {\n          inIdx = srcIdx;\n          ${v}\n          vec4 candidate = ${k};\n          bvec4 nan = isnan(candidate);\n          bvec4 replace = bvec4(\n            vec4(${w}(candidate, bestValue)) * (vec4(1.0) - vec4(nan)));\n\n          bestValue = vec4(replace.x  ? candidate.x : bestValue.x,\n                           replace.y  ? candidate.y : bestValue.y,\n                           replace.z  ? candidate.z : bestValue.z,\n                           replace.w  ? candidate.w : bestValue.w);\n          bestIndex = mix(bestIndex, vec4(inIdx), vec4(replace));\n          srcIdx++;\n        }\n        setOutput(bestIndex);\n      }\n    `}}function TF(e,t,n,s=null){let r=t.shape[0],a=t.shape[1];null!=s&&(r=s.shape[0],a=s.shape[1]);const i=id(a),o={windowSize:i,inSize:a,batchSize:r,outSize:Math.ceil(a/i)},l=new IF(o,n,null==s),u=[t];null!=s&&u.push(s);const c=e.runWebGLProgram(l,u,"int32");if(1===c.shape[1])return c;const h=TF(e,t,n,c);return e.disposeIntermediateTensorInfo(c),h}function $F(e,t,n,s=null){const r=null!=s?s.shape:t.shape,a=id(r[r.length-1]),i=new SF(r,a,n,null==s),o=null==s?[t]:[t,s],l=e.runWebGLProgram(i,o,"int32");if(l.shape.length===t.shape.length){const s=$F(e,t,n,l);return e.disposeIntermediateTensorInfo(l),s}return l}function CF(e,t,n,s){const r=[n];if(jl("arg"+s.charAt(0).toUpperCase()+s.slice(1),r,t.shape.length),!X().getBool("WEBGL_PACK_REDUCE")||t.shape.length<=2){const n=[],a=e.texData.get(t.dataId);let i=t;null!==a&&a.isPacked&&(i=e.unpackTensor(t),n.push(i));const[o,l]=Gl(i.shape,r),u=d(l),c=Y_({inputs:{x:i},backend:e,attrs:{shape:[-1,u]}});n.push(c);const h=TF(e,c,s);n.push(h);const p=Y_({inputs:{x:h},backend:e,attrs:{shape:o}});return n.forEach((t=>e.disposeIntermediateTensorInfo(t))),p}return $F(e,t,s)}const EF={kernelName:ie,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=w(a,r.shape);const o=ql(i,r.shape.length);let l=r;const u=[];null!=o&&(l=iF({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=Xl(i.length,l.shape.length)),jl("argMax",[i[0]],l.shape.length);const c=CF(n,l,i[0],"max");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}};const AF={kernelName:oe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a}=s;let i=w(a,r.shape);const o=ql(i,r.shape.length);let l=r;const u=[];null!=o&&(l=iF({inputs:{x:r},backend:n,attrs:{perm:o}}),u.push(l),i=Xl(i.length,l.shape.length)),jl("argMin",[i[0]],l.shape.length);const c=CF(n,l,i[0],"min");return u.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}},RF=B_({opSnippet:"if (isnan(x)) return x;\n  if (abs(x) > 1.) {\n    return NAN;\n  }\n  return asin(x);\n"}),_F={kernelName:le,backendName:"webgl",kernelFunc:RF},FF=B_({opSnippet:"if (isnan(x)) return x;return log(x + sqrt(x * x + 1.0));"}),DF={kernelName:ue,backendName:"webgl",kernelFunc:FF},OF=B_({opSnippet:"if (isnan(x)) return x;\n  return atan(x);\n"}),MF={kernelName:ce,backendName:"webgl",kernelFunc:OF},LF=W_({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return atan(a, b);\n",packedOpSnippet:"\n  vec4 result = atan(a, b);\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),zF={kernelName:pe,backendName:"webgl",kernelFunc:LF},PF=B_({opSnippet:"if (isnan(x)) return x;\n  if ((x < -1.0) || (x > 1.0)) return NAN;\nreturn (log(1.0 + x) - log(1.0 - x)) / 2.0;"}),BF={kernelName:he,backendName:"webgl",kernelFunc:PF};class WF{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideHeight,o=e.strideWidth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterHeight,h=e.effectiveFilterWidth,p=e.padInfo.top,d=e.padInfo.left;this.outputShape=e.outShape;const f="avg"===t,m=`((batch  * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + d`,g=`(xR * ${e.inWidth} + xC) * ${e.inChannels} + d`;let y="0.0";if(f||(y="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec2 strides = ivec2(${i}, ${o});\n        const ivec2 pads = ivec2(${p}, ${d});\n\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int batch = coords[0];\n          int d = coords[3];\n\n          ivec2 xRCCorner = coords.yz * strides - pads;\n          int xRCorner = xRCCorner.x;\n          int xCCorner = xRCCorner.y;\n\n          // max/min x(?, ?, d) to get y(yR, yC, d).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n          float avgValue = 0.0;\n\n          for (int wR = 0; wR < ${c};\n              wR += ${l}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${h};\n                wC += ${u}) {\n              int xC = xCCorner + wC;\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float value = getX(batch, xR, xC, d);\n\n              // If a min / max value has already been found, use it. If not,\n              // use the current value.\n              float currMinMaxValue = mix(\n                  value, minMaxValue, minMaxValueFound);\n              if (value ${t} currMinMaxValue) {\n                minMaxValue = value;\n                minMaxValueFound = 1.0;\n                minMaxPosition = ${s?r?m:g:`wR * ${h} + wC`};\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let b=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(b="avgValue / count");const x=4*Math.floor(a/4),w=a%4,v=`\n      if (${f}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec2 strides = ivec2(${i}, ${o});\n      const ivec2 pads = ivec2(${p}, ${d});\n      const float initializationValue = ${y};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xR, int xC, int d) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xR, xC, d);\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d = coords[3];\n\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // max/min x(?, ?, d) to get y(yR, yC, d).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${y});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wR = 0; wR < ${c};\n            wR += ${l}) {\n          int xR = xRCorner + wR;\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${x}; wC += 4) {\n            int xC = xCCorner + wC * ${u};\n\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              getValue(batch, xR, xC + 3 * ${u}, d)\n            );\n\n            ${v}\n          }\n\n          int xC = xCCorner + ${x};\n          if (${1===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              initializationValue,\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${2===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              initializationValue,\n              initializationValue\n            );\n\n            ${v}\n          } else if (${3===w}) {\n            vec4 values = vec4(\n              getValue(batch, xR, xC, d),\n              getValue(batch, xR, xC + ${u}, d),\n              getValue(batch, xR, xC + 2 * ${u}, d),\n              initializationValue\n            );\n\n            ${v}\n          }\n        }\n        setOutput(${b});\n      }\n    `}}class VF{constructor(e,t,n,s=!1,r=!1){if(this.variableNames=["x"],"avg"===t&&n)throw new Error("Cannot compute positions for average pool.");const a=e.filterWidth,i=e.strideDepth,o=e.strideHeight,l=e.strideWidth,u=e.dilationDepth,c=e.dilationHeight,h=e.dilationWidth,p=e.effectiveFilterDepth,d=e.effectiveFilterHeight,f=e.effectiveFilterWidth,m=e.padInfo.front,g=e.padInfo.top,y=e.padInfo.left;this.outputShape=e.outShape;const b="avg"===t;let x="0.0";if(b||(x="-1.0 / 1e-20"),n){const t=">=";return void(this.userCode=`\n        const ivec3 strides =\n            ivec3(${i}, ${o}, ${l});\n        const ivec3 pads = ivec3(${m}, ${g}, ${y});\n\n        void main() {\n          ivec5 coords = getOutputCoords();\n          int batch = coords.x;\n          int ch = coords.u;\n\n          ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n          int xDCorner = xCorner.x;\n          int xRCorner = xCorner.y;\n          int xCCorner = xCorner.z;\n\n          // max/min x(?, ?, ?, ch) to get y(yD, yR, yC, ch).\n          // ? = to be determined\n          float minMaxValue = 0.0;\n          float minMaxValueFound = 0.0;\n          int minMaxPosition = 0;\n\n          for (int wD = 0; wD < ${p};\n              wD += ${u}) {\n            int xD = xDCorner + wD;\n\n            if (xD < 0 || xD >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int wR = 0; wR < ${d};\n                wR += ${c}) {\n              int xR = xRCorner + wR;\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int wC = 0; wC < ${f};\n                  wC += ${h}) {\n                int xC = xCCorner + wC;\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float value = getX(batch, xD, xR, xC, ch);\n\n                // If a min / max value has already been found, use it. If not,\n                // use the current value.\n                float currMinMaxValue = mix(\n                    value, minMaxValue, minMaxValueFound);\n                if (value ${t} currMinMaxValue) {\n                  minMaxValue = value;\n                  minMaxValueFound = 1.0;\n                  minMaxPosition = ${s?r?`(((batch * ${e.inDepth} + xD) * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`((xD * ${e.inHeight} + xR) * ${e.inWidth} + xC) * ${e.inChannels} + ch`:`wD * ${d} * ${f} +\n                      wR * ${f} + wC`};\n                }\n              }\n            }\n          }\n          setOutput(float(minMaxPosition));\n        }\n      `)}let w=`${t}(${t}(${t}(minMaxValue[0], minMaxValue[1]), minMaxValue[2]), minMaxValue[3])`;"avg"===t&&(w="avgValue / count");const v=4*Math.floor(a/4),k=a%4,N=`\n      if (${b}) {\n        avgValue += dot(values, ones);\n      } else {\n        minMaxValue = max(values, minMaxValue);\n      }\n    `;this.userCode=`\n      const ivec3 strides =\n        ivec3(${i}, ${o}, ${l});\n      const ivec3 pads = ivec3(${m}, ${g}, ${y});\n      const float initializationValue = ${x};\n      const vec4 ones = vec4(1.0, 1.0, 1.0, 1.0);\n\n      float count = 0.0;\n\n      float getValue(int batch, int xD, int xR, int xC, int ch) {\n        if (xC < 0 || xC >= ${e.inWidth}) {\n          return initializationValue;\n        }\n        count += 1.0;\n        return getX(batch, xD, xR, xC, ch);\n      }\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 xCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xDCorner = xCorner.x;\n        int xRCorner = xCorner.y;\n        int xCCorner = xCorner.z;\n\n        // max/min x(?, ?, ?, d) to get y(yD, yR, yC, ch).\n        // ? = to be determined\n        vec4 minMaxValue = vec4(${x});\n        float avgValue = 0.0;\n        count = 0.0;\n\n        for (int wD = 0; wD < ${p};\n            wD += ${u}) {\n          int xD = xDCorner + wD;\n\n          if (xD < 0 || xD >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${d};\n            wR += ${c}) {\n            int xR = xRCorner + wR;\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${v}; wC += 4) {\n              int xC = xCCorner + wC * ${h};\n\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                getValue(batch, xD, xR, xC + 3 * ${h}, ch)\n              );\n\n              ${N}\n            }\n\n            int xC = xCCorner + ${v};\n            if (${1===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                initializationValue,\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${2===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                initializationValue,\n                initializationValue\n              );\n\n              ${N}\n            } else if (${3===k}) {\n              vec4 values = vec4(\n                getValue(batch, xD, xR, xC, ch),\n                getValue(batch, xD, xR, xC + ${h}, ch),\n                getValue(batch, xD, xR, xC + 2 * ${h}, ch),\n                initializationValue\n              );\n\n              ${N}\n            }\n          }\n          setOutput(${w});\n        }\n      }\n    `}}const UF={kernelName:de,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;_A(r,"avgPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(qo(i,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Lo(r.shape,a,i,1,o,l);if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))return A_({inputs:{x:r},backend:n});const h=new WF(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};const GF={kernelName:me,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dimRoundingMode:l,dataFormat:u}=s,c=zo(r.shape,a,i,[1,1,1],o,l,u),h=new VF(c,"avg",!1);return n.runWebGLProgram(h,[r],"float32")}};class HF{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterHeight,l=e.effectiveFilterWidth,u=o-1-e.padInfo.top,c=l-1-e.padInfo.left,h=1/(t*n);this.userCode=`\n      const ivec2 pads = ivec2(${u}, ${c});\n      const float avgMultiplier = float(${h});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${o};\n            wR += ${a}) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${l};\n            wC+= ${i}) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n\n            dotProd += dyValue * avgMultiplier;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class jF{constructor(e){this.variableNames=["dy"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.effectiveFilterDepth,h=e.effectiveFilterHeight,p=e.effectiveFilterWidth,d=c-1-e.padInfo.front,f=h-1-e.padInfo.top,m=p-1-e.padInfo.left,g=1/(t*n*s);this.userCode=`\n      const ivec3 pads = ivec3(${d}, ${f}, ${m});\n      const float avgMultiplier = float(${g});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, d) with pos mask(:, :, :, ch) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${c};\n            wD += ${o}) {\n          float dyD = float(dyDCorner + wD) / ${r}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${h};\n              wR += ${l}) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${p};\n                wC += ${u}) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n\n              dotProd += dyValue * avgMultiplier;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const qF={kernelName:ge,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=zo(i.shape,o,l,[1,1,1],u,c),p=new jF(h);return n.runWebGLProgram(p,[r],i.dtype)}};const KF={kernelName:fe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a;_A([r,a],"avgPoolGrad");const{filterSize:o,strides:l,pad:u}=s,c=Lo(i.shape,o,l,1,u),h=new HF(c);return n.runWebGLProgram(h,[r],i.dtype)}};const XF={kernelName:ye,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{a:r,b:a}=t,{transposeA:i,transposeB:o}=s;return lF({a:r,b:a,transposeA:i,transposeB:o,backend:n})}};class YF{constructor(e,t,n,s,r,a){this.outputShape=[],this.variableNames=["x","mean","variance"],_i(e,t),_i(e,n);let i="0.0";null!=s&&(_i(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="1.0";null!=r&&(_i(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        float x = getXAtOutCoords();\n        float mean = getMeanAtOutCoords();\n        float variance = getVarianceAtOutCoords();\n        float offset = ${i};\n        float scale = ${o};\n        float inv = scale * inversesqrt(variance + float(${a}));\n        setOutput(dot(vec3(x, -mean, offset), vec3(inv, inv, 1)));\n      }\n    `}}class ZF{constructor(e,t,n,s,r,a){this.packedInputs=!0,this.packedOutput=!0,this.variableNames=["x","mean","variance"],_i(e,t),_i(e,n);let i="vec4(0.0)";null!=s&&(_i(e,s),this.variableNames.push("offset"),i="getOffsetAtOutCoords()");let o="vec4(1.0)";null!=r&&(_i(e,r),this.variableNames.push("scale"),o="getScaleAtOutCoords()"),this.outputShape=e,this.userCode=`\n      void main() {\n        vec4 offset = ${i};\n        vec4 scale = ${o};\n\n        vec4 x = getXAtOutCoords();\n        vec4 mean = getMeanAtOutCoords();\n        vec4 variance = getVarianceAtOutCoords();\n\n        vec4 inv = scale * inversesqrt(variance + vec4(${a}));\n\n        setOutput((x - mean) * inv + offset);\n      }\n    `}}const JF={kernelName:lt,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s,mean:r,variance:a,offset:i,scale:o}=e;u(r.shape.length===a.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),u(null==i||r.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),u(null==o||r.shape.length===o.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));let{varianceEpsilon:l}=n;null==l&&(l=.001);const c=[s,r,a];let h=null;null!=i&&(h=i.shape,c.push(i));let p=null;null!=o&&(p=o.shape,c.push(o));const d=X().getBool("WEBGL_PACK_NORMALIZATION")?new ZF(s.shape,r.shape,a.shape,h,p,l):new YF(s.shape,r.shape,a.shape,h,p,l);return t.runWebGLProgram(d,c,c[0].dtype)}};class QF{constructor(e){this.variableNames=["source"],this.outputShape=e,this.rank=e.length;const t=ZA(this.rank);this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const n=function(e){if(1===e)return"sourceLoc";if(e<=6)return eD.slice(0,e).map((e=>"sourceLoc."+e)).join(",");throw Error(`Slicing for rank ${e} is not yet supported`)}(this.rank);let s;s=`\n        ${t} sourceLoc;\n        ${t} coords = getOutputCoords();\n        ${e.map(((e,t)=>`sourceLoc.${eD[t]} = start[${t}] + coords.${eD[t]};`)).join("\n")}\n      `,this.userCode=`\n      void main() {\n        ${s}\n        setOutput(getSource(${n}));\n      }\n    `}}const eD=["x","y","z","w","u","v"];class tD{constructor(e){this.variableNames=["source"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=e,this.rank=e.length,this.customUniforms=[{name:"start",arrayIndex:this.rank,type:"int"}];const t=ZA(this.rank),n=p_("coords",this.rank),s=p_("sourceLoc",this.rank),r=1===this.rank?"sourceLoc":`vec2(${s.slice(-2).join()})`,a=`getChannel(getSource(${s.join()}), ${r})`,i=`\n      result.x = ${a};\n      if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n        ++${s[this.rank-1]};\n        result.y = ${a};\n        --${s[this.rank-1]};\n      }\n    `,o=1===this.rank?"":`\n      --${n[this.rank-1]};\n      if (++${n[this.rank-2]} < ${e[this.rank-2]}) {\n        ++${s[this.rank-2]};\n        result.z = ${a};\n        if (++${n[this.rank-1]} < ${e[this.rank-1]}) {\n          ++${s[this.rank-1]};\n          result.w = ${a};\n        }\n      }\n    `,l=this.rank<=4?`sourceLoc = coords +\n            ${t}(${e.map(((e,t)=>`start[${t}]`)).join()});`:e.map(((e,t)=>`${s[t]} = ${n[t]} + start[${t}];`)).join("\n");this.userCode=`\n      void main() {\n        ${t} coords = getOutputCoords();\n        ${t} sourceLoc;\n        ${l}\n        vec4 result = vec4(0.);\n        ${i}\n        ${o}\n        setOutput(result);\n      }\n    `}}function nD(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{begin:a,size:i}=s,[o,l]=ro(r,a,i);if(ji(r,o,l),0===d(l))return n.makeTensorInfo(l,r.dtype,[]);if(n.shouldExecuteOnCPU([r])||"string"===r.dtype){const e=n.texData.get(r.dataId),t=ZR(e.values,o,l,r.shape,r.dtype);return n.makeTensorInfo(l,r.dtype,t)}const{isPacked:u}=n.texData.get(r.dataId),c=no(r.shape,o,l);if(u||!c){const e=X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new tD(l):new QF(l),t=[o];return n.runWebGLProgram(e,[r],r.dtype,t)}return n.uploadToGPU(r.dataId),function(e,t,n,s){const r=s.texData.get(e.dataId),a=s.makeTensorInfo(n,e.dtype),i=s.texData.get(a.dataId);Object.assign(i,r),i.refCount=1,i.shape=n,i.dtype=e.dtype;let o=so(t,M(e.shape));r.slice&&(o+=r.slice.flatOffset),i.slice={flatOffset:o,origDataId:r.slice&&r.slice.origDataId||e.dataId};const l=s.dataRefCount.get(i.slice.origDataId)||1;return s.dataRefCount.set(i.slice.origDataId,l+1),a}(r,o,l,n)}const sD={kernelName:vn,backendName:"webgl",kernelFunc:nD},rD={kernelName:be,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockShape:a,crops:i}=s;u(r.shape.length<=4,(()=>"batchToSpaceND for rank > 4 with a WebGL backend not implemented yet"));const o=a.reduce(((e,t)=>e*t)),l=ld(r.shape,a,o),c=ud(l.length,a.length),h=cd(r.shape,a,o),p=hd(i,a.length),d=pd(h,i,a.length),f=[],m=Y_({inputs:{x:r},backend:n,attrs:{shape:l}}),g=iF({inputs:{x:m},backend:n,attrs:{perm:c}}),y=Y_({inputs:{x:g},backend:n,attrs:{shape:h}}),b=nD({inputs:{x:y},backend:n,attrs:{begin:p,size:d}});return f.push(m),f.push(g),f.push(y),f.forEach((e=>n.disposeIntermediateTensorInfo(e))),b}};const aD={kernelName:xe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i}=s,o=n.readSync(r.dataId),l=n.readSync(a.dataId),u=NR(o,l,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,u)}};const iD={kernelName:ve,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{s0:s,s1:r}=t,a=n.readSync(s.dataId),i=n.readSync(r.dataId),o=_i(Array.from(a),Array.from(i));return n.makeTensorInfo([o.length],"int32",Int32Array.from(o))}},oD=W_({opSnippet:"return float(a != b);",cpuKernelImpl:GR,dtype:"bool"}),lD={kernelName:jt,backendName:"webgl",kernelFunc:oD};function uD(e){const{inputs:t,backend:n}=e,{input:s}=t;return A_({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.real},backend:n})}const cD={kernelName:rn,backendName:"webgl",kernelFunc:uD};const hD={kernelName:ke,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s,attrs:r}=t,{x:a}=n,{dtype:i}=r;if("complex64"===i){if("complex64"===a.dtype)return A_({inputs:{x:a},backend:s});const t=ju(a.shape),n=e({inputs:{x:a},backend:s,attrs:{dtype:"float32"}}),r=__({inputs:{real:n,imag:t},backend:s});return t.dispose(),s.disposeIntermediateTensorInfo(n),r}if("complex64"===a.dtype){const t=uD({inputs:{input:a},backend:s}),n=e({inputs:{x:t},backend:s,attrs:{dtype:i}});return s.disposeIntermediateTensorInfo(t),n}if(!T(a.dtype,i)){const e=A_({inputs:{x:a},backend:s});return{dataId:e.dataId,shape:e.shape,dtype:i}}if("int32"===i)return function(e,t){const n=new x_(e.shape,"return float(int(x));"),s=t.runWebGLProgram(n,[e],"int32");return{dataId:s.dataId,shape:s.shape,dtype:s.dtype}}(a,s);if("bool"===i){const e=s.makeTensorInfo([],"bool",k("bool",1)),t=oD({inputs:{a:a,b:e},backend:s});return s.disposeIntermediateTensorInfo(e),t}throw new Error(`Error in Cast: failed to cast ${a.dtype} to ${i}`)}},pD="return ceil(x);",dD=B_({opSnippet:pD,packedOpSnippet:pD,cpuKernelImpl:SR}),fD={kernelName:Ne,backendName:"webgl",kernelFunc:dD};class mD{constructor(e){this.variableNames=["A"],this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n\n      void main() {\n        float value = getAAtOutCoords();\n        if (isnan(value)) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, minVal, maxVal));\n      }\n    "}}class gD{constructor(e){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"minVal",type:"float"},{name:"maxVal",type:"float"}],this.outputShape=e,this.userCode="\n      void main() {\n        vec4 value = getAAtOutCoords();\n\n        if (any(isnan(value))) {\n          setOutput(value);\n          return;\n        }\n\n        setOutput(clamp(value, vec4(minVal), vec4(maxVal)));\n      }\n    "}}const yD={kernelName:Ie,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{clipValueMin:a,clipValueMax:i}=s;let o;o=X().getBool("WEBGL_PACK_CLIP")?new gD(r.shape):new mD(r.shape);const l=[[a],[i]];return n.runWebGLProgram(o,[r],r.dtype,l)}};class bD{constructor(e){this.variableNames=["real","imag"],this.outputShape=e,this.userCode="\n      void main() {\n        float re = abs(getRealAtOutCoords());\n        float im = abs(getImagAtOutCoords());\n        float mx = max(re, im);\n\n        // sadly the length function in glsl is not underflow-safe\n        // (at least not on Intel GPUs). So the safe solution is\n        // to ensure underflow-safety in all cases.\n        setOutput(\n          mx == 0.0 ? 0.0 : mx * length(vec2(1, min(re, im)/mx))\n        );\n      }\n    "}}function xD(e,t){return{dataId:t.dataId,dtype:t.dtype,shape:e.shape}}const wD={kernelName:Te,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=n.texData.get(s.dataId),a=new bD(s.shape),i=[xD(s,r.complexTensorInfos.real),xD(s,r.complexTensorInfos.imag)];return n.runWebGLProgram(a,i,i[0].dtype)}};class vD{constructor(e){this.outputShape=[],this.outputShape=ad(e,1),this.variableNames=e.map(((e,t)=>`T${t}`));const t=new Array(e.length-1);t[0]=e[0][1];for(let n=1;n<t.length;n++)t[n]=t[n-1]+e[n][1];const n=[`if (yC < ${t[0]}) setOutput(getT0(yR, yC));`];for(let e=1;e<t.length;e++){const s=t[e-1];n.push(`else if (yC < ${t[e]}) setOutput(getT${e}(yR, yC-${s}));`)}const s=t.length,r=t[t.length-1];n.push(`else setOutput(getT${s}(yR, yC-${r}));`),this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int yR = coords.x;\n        int yC = coords.y;\n\n        ${n.join("\n        ")}\n      }\n    `}}class kD{constructor(e,t){this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[],this.outputShape=ad(e,t);const n=this.outputShape,s=n.length,r=ZA(s),a=p_("coords",s),i=["x","y","z","w","u","v"].slice(0,s);this.variableNames=e.map(((e,t)=>`T${t}`));const o=new Array(e.length-1);o[0]=e[0][t];for(let n=1;n<o.length;n++)o[n]=o[n-1]+e[n][t];const l=i[t],u=i.slice(-2),c=i.join();let h=`if (${l} < ${o[0]}) {\n        return getChannel(\n            getT0(${c}), vec2(${u.join()}));\n        }`;for(let e=1;e<o.length;e++){const t=o[e-1];h+=`\n        if (${l} < ${o[e]}  && ${l} >= ${o[e-1]}) {\n          return getChannel(\n            getT${e}(${ND(i,l,t)}),\n            vec2(${ND(u,l,t)}));\n        }`}const p=o.length,d=o[o.length-1];h+=`\n        return getChannel(\n          getT${p}(${ND(i,l,d)}),\n          vec2(${ND(u,l,d)}));`,this.userCode=`\n      float getValue(${i.map((e=>"int "+e))}) {\n        ${h}\n      }\n\n      void main() {\n        ${r} coords = getOutputCoords();\n        vec4 result = vec4(getValue(${a}), 0., 0., 0.);\n\n        ${a[s-1]} = ${a[s-1]} + 1;\n        if (${a[s-1]} < ${n[s-1]}) {\n          result.g = getValue(${a});\n        }\n\n        ${a[s-2]} = ${a[s-2]} + 1;\n        if (${a[s-2]} < ${n[s-2]}) {\n          result.a = getValue(${a});\n        }\n\n        ${a[s-1]} = ${a[s-1]} - 1;\n        if (${a[s-2]} < ${n[s-2]} &&\n            ${a[s-1]} < ${n[s-1]}) {\n          result.b = getValue(${a});\n        }\n        setOutput(result);\n      }\n    `}}function ND(e,t,n){const s=e.indexOf(t);return e.map(((e,t)=>t===s?`${e} - ${n}`:e)).join()}function ID(e){const{inputs:t,backend:n}=e,{input:s}=t;return A_({inputs:{x:n.texData.get(s.dataId).complexTensorInfos.imag},backend:n})}const SD={kernelName:mt,backendName:"webgl",kernelFunc:ID};function TD(e,t,n){const s=e[0].dtype;if("complex64"===s){const s=e.map((e=>uD({inputs:{input:e},backend:n}))),r=e.map((e=>ID({inputs:{input:e},backend:n}))),a=TD(s,t,n),i=TD(r,t,n),o=__({inputs:{real:a,imag:i},backend:n});return s.forEach((e=>n.disposeIntermediateTensorInfo(e))),r.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.disposeIntermediateTensorInfo(a),n.disposeIntermediateTensorInfo(i),o}let r=n.shouldExecuteOnCPU(e);if("string"===s&&(r=!0),r){const r=e.map((e=>{const s=d(e.shape.slice(t));return Y_({inputs:{x:e},backend:n,attrs:{shape:[-1,s]}})})),a=r.map((e=>({vals:n.readSync(e.dataId),shape:e.shape}))),i=ad(r.map((e=>e.shape)),1),o=1===r[0].shape[0],l=TR(a,i,s,o),u=ad(e.map((e=>e.shape)),t),c=n.makeTensorInfo(u,s,l);return r.forEach((e=>n.disposeIntermediateTensorInfo(e))),c}const a=X().getNumber("WEBGL_MAX_TEXTURES_IN_SHADER");if(e.length>a){const s=[];for(let r=0;r<e.length;r+=a){const i=e.slice(r,r+a);s.push(TD(i,t,n))}const r=TD(s,t,n);for(const e of s)n.disposeIntermediateTensorInfo(e);return r}if(X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")&&e[0].shape.length>1){const r=new kD(e.map((e=>e.shape)),t);return n.runWebGLProgram(r,e,s)}const{tensors2D:i,outShape:o}=function(e,t,n){const s=ad(e.map((e=>e.shape)),t);return{tensors2D:e.map((e=>Y_({inputs:{x:e},attrs:{shape:[-1,d(e.shape.slice(t))]},backend:n}))),outShape:s}}(e,t,n),l=new vD(i.map((e=>e.shape))),u=n.runWebGLProgram(l,i,s);i.forEach((e=>n.disposeIntermediateTensorInfo(e)));const c=Y_({inputs:{x:u},attrs:{shape:o},backend:n});return n.disposeIntermediateTensorInfo(u),c}function $D(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s,a=w(r,t[0].shape)[0],i=ad(t.map((e=>e.shape)),a);if(0===d(i))return n.makeTensorInfo(i,t[0].dtype,[]);const o=t.filter((e=>d(e.shape)>0));if(1===o.length)return A_({inputs:{x:o[0]},backend:n});return rd(o.map((e=>e.shape)),a),TD(o,a,n)}const CD={kernelName:$e,backendName:"webgl",kernelFunc:$D};class ED{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.outputShape=e.outShape;const a=e.padInfo.top,i=e.padInfo.left,o=e.strideHeight,l=e.strideWidth,u=e.dilationHeight,c=e.dilationWidth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4,m="channelsLast"===e.dataFormat,g=m?1:2,y=m?2:3,b=m?3:1;let x="",w="";n&&(x=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,w="result = activation(result);");const v=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${x}\n\n      const ivec2 strides = ivec2(${o}, ${l});\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d2 = coords[${b}];\n\n        ivec2 xRCCorner =\n            ivec2(coords[${g}], coords[${y}]) * strides - pads;\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, d2) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${h}; wR++) {\n          int xR = xRCorner + wR * ${u};\n\n          if (xR < 0 || xR >= ${e.inHeight}) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${p}; wC++) {\n            int xC = xCCorner + wC * ${c};\n\n            if (xC < 0 || xC >= ${e.inWidth}) {\n              continue;\n            }\n\n            for (int d1 = 0; d1 < ${d}; d1 += 4) {\n              vec4 wValues = vec4(\n                getW(wR, wC, d1, d2),\n                getW(wR, wC, d1 + 1, d2),\n                getW(wR, wC, d1 + 2, d2),\n                getW(wR, wC, d1 + 3, d2)\n              );\n\n              if (${m}) {\n                vec4 xValues = vec4(\n                  getX(batch, xR, xC, d1),\n                  getX(batch, xR, xC, d1 + 1),\n                  getX(batch, xR, xC, d1 + 2),\n                  getX(batch, xR, xC, d1 + 3)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec4 xValues = vec4(\n                  getX(batch, d1, xR, xC),\n                  getX(batch, d1 + 1, xR, xC),\n                  getX(batch, d1 + 2, xR, xC),\n                  getX(batch, d1 + 3, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n\n            if (${1===f}) {\n\n              if (${m}) {\n                dotProd +=\n                    getX(batch, xR, xC, ${d}) *\n                    getW(wR, wC, ${d}, d2);\n              } else {\n                dotProd +=\n                    getX(batch, ${d}, xR, xC) *\n                    getW(wR, wC, ${d}, d2);\n              }\n\n            } else if (${2===f}) {\n              vec2 wValues = vec2(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2)\n              );\n\n              if (${m}) {\n                vec2 xValues = vec2(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec2 xValues = vec2(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            } else if (${3===f}) {\n              vec3 wValues = vec3(\n                getW(wR, wC, ${d}, d2),\n                getW(wR, wC, ${d} + 1, d2),\n                getW(wR, wC, ${d} + 2, d2)\n              );\n\n              if (${m}) {\n                vec3 xValues = vec3(\n                  getX(batch, xR, xC, ${d}),\n                  getX(batch, xR, xC, ${d} + 1),\n                  getX(batch, xR, xC, ${d} + 2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else {\n                vec3 xValues = vec3(\n                  getX(batch, ${d}, xR, xC),\n                  getX(batch, ${d} + 1, xR, xC),\n                  getX(batch, ${d} + 2, xR, xC)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n\n            }\n          }\n        }\n\n        float result = dotProd;\n        ${v}\n        ${w}\n        setOutput(result);\n      }\n    `}}class AD{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const t=e.padInfo.front,n=e.padInfo.top,s=e.padInfo.left,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=e.dilationDepth,l=e.dilationHeight,u=e.dilationWidth,c=e.filterDepth,h=e.filterHeight,p=e.filterWidth,d=4*Math.floor(e.inChannels/4),f=e.inChannels%4;this.userCode=`\n      const ivec3 strides = ivec3(${r}, ${a}, ${i});\n      const ivec3 pads = ivec3(${t}, ${n}, ${s});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d2 = coords.u;\n\n        ivec3 xFRCCorner = ivec3(coords.y, coords.z, coords.w) * strides - pads;\n        int xFCorner = xFRCCorner.x;\n        int xRCorner = xFRCCorner.y;\n        int xCCorner = xFRCCorner.z;\n\n        // Convolve x(?, ?, ?, d1) with w(:, :, :, d1, d2) to get\n        // y(yF, yR, yC, d2). ? = to be determined. : = across all\n        // values in that axis.\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${c}; wF++) {\n          int xF = xFCorner + wF * ${o};\n\n          if (xF < 0 || xF >= ${e.inDepth}) {\n            continue;\n          }\n\n          for (int wR = 0; wR < ${h}; wR++) {\n            int xR = xRCorner + wR * ${l};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int wC = 0; wC < ${p}; wC++) {\n              int xC = xCCorner + wC * ${u};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              for (int d1 = 0; d1 < ${d}; d1 += 4) {\n                vec4 xValues = vec4(\n                  getX(batch, xF, xR, xC, d1),\n                  getX(batch, xF, xR, xC, d1 + 1),\n                  getX(batch, xF, xR, xC, d1 + 2),\n                  getX(batch, xF, xR, xC, d1 + 3)\n                );\n                vec4 wValues = vec4(\n                  getW(wF, wR, wC, d1, d2),\n                  getW(wF, wR, wC, d1 + 1, d2),\n                  getW(wF, wR, wC, d1 + 2, d2),\n                  getW(wF, wR, wC, d1 + 3, d2)\n                );\n\n                dotProd += dot(xValues, wValues);\n              }\n\n              if (${1===f}) {\n                dotProd +=\n                  getX(batch, xF, xR, xC, ${d}) *\n                  getW(wF, wR, wC, ${d}, d2);\n              } else if (${2===f}) {\n                vec2 xValues = vec2(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1)\n                );\n                vec2 wValues = vec2(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              } else if (${3===f}) {\n                vec3 xValues = vec3(\n                  getX(batch, xF, xR, xC, ${d}),\n                  getX(batch, xF, xR, xC, ${d} + 1),\n                  getX(batch, xF, xR, xC, ${d} + 2)\n                );\n                vec3 wValues = vec3(\n                  getW(wF, wR, wC, ${d}, d2),\n                  getW(wF, wR, wC, ${d} + 1, d2),\n                  getW(wF, wR, wC, ${d} + 2, d2)\n                );\n                dotProd += dot(xValues, wValues);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class RD{constructor(e,t){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"inputShape",type:"ivec4"},{name:"pad",type:"ivec2"},{name:"stride",type:"ivec2"},{name:"dilation",type:"ivec2"},{name:"inChannels",type:"int"},{name:"itemsPerBlockRow",type:"int"},{name:"outWidth",type:"int"}],this.outputShape=e,this.enableShapeUniforms=rR(this.outputShape.length);const{dataFormat:n}=t,s=DA(),r="channelsLast"===n,a=r?1:2,i=r?2:3,o=this.enableShapeUniforms?"if(blockIndex < outShape[2] && pos < outShape[1]) {":`if(blockIndex < ${e[2]} && pos < ${e[1]}) {`;let l="";for(let e=0;e<=1;e++)for(let t=0;t<=1;t++)l+=`\n          blockIndex = rc.z + ${t};\n          pos = rc.y + ${e};\n\n          ${o}\n            offsetY = int(blockIndex / outWidth) * stride[0] - pad[0];\n            d0 = offsetY + dilation[0] * (pos / itemsPerBlockRow);\n\n            if(d0 < inputShape[${a}] && d0 >= 0) {\n              // Use custom imod instead mod. On Intel GPU, mod may generate\n              // unexpected value.\n              // https://github.com/tensorflow/tfjs/issues/5447\n              offsetX = imod(blockIndex, outWidth) * stride[1] - pad[1];\n              d1 = offsetX + dilation[1] * (imod(pos, itemsPerBlockRow) /\n                  inChannels);\n\n              if(d1 < inputShape[${i}] && d1 >= 0) {\n\n                ch = imod(pos, inChannels);\n\n                if (${r}) {\n                  innerDims = vec2(d1, ch);\n                  result[${2*e+t}] = getChannel(\n                    getA(rc.x, d0, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                } else {\n                  innerDims = vec2(d0, d1);\n                  result[${2*e+t}] = getChannel(\n                    getA(rc.x, ch, int(innerDims.x),\n                    int(innerDims.y)), innerDims);\n                }\n              }\n            }\n          }\n        `;this.userCode=`\n      void main() {\n        ivec3 rc = getOutputCoords();\n\n        vec4 result = vec4(0);\n\n        int blockIndex, pos, offsetY, d0, offsetX, d1, ch;\n        vec2 innerDims;\n\n        ${l}\n\n        ${s.output} = result;\n      }\n    `}}function _D(e,t){const n=e.length;return n>=3?t?[...e.slice(0,-3),e[n-3]*e[n-2],e[n-1]]:[...e.slice(0,-3),e[n-3],e[n-2]*e[n-1]]:!t&&1===n&&e[0]>1?[e[0],1]:null}function FD({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const l=e.shape,c=s.texData.get(e.dataId),h=n.inChannels,p=l[0]*l[1]*l[2],d=n.outChannels,m="channelsLast"===n.dataFormat;let g;const y=[];if(null!=a){const e=_D(a.shape,m);null!=e&&(a=Y_({inputs:{x:a},backend:s,attrs:{shape:e}}),y.push(a))}if(null!=r){const e=_D(r.shape,m);null!=e&&(r=Y_({inputs:{x:r},backend:s,attrs:{shape:e}}),y.push(r))}if(!((1===p||1===d)&&h>1e3)&&c.isPacked&&m&&null!=c.texture&&l[2]%2!=0&&f(c.shape.slice(-3),l.slice(-3))){const h=l[0]*l[1]*(l[2]+1),p={dataId:e.dataId,shape:[1,h,n.inChannels],dtype:e.dtype},d=c.shape;c.shape=c.shape.slice(),c.shape[c.shape.length-2]++,u(SA(c.shape,p.shape),(()=>`packed reshape ${c.shape} to ${p.shape} isn't free`));const f=Y_({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}});y.push(f);const m=lF({a:p,b:f,backend:s,transposeA:false,transposeB:false,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i}),b=s.texData.get(m.dataId);u(b.isPacked,(()=>"batchMatMul result is expected to be packed")),c.shape=d,b.shape=n.outShape,g=A_({inputs:{x:m},backend:s}),g.shape=n.outShape,y.push(m)}else{const l=n.outHeight*n.outWidth,u=Y_({inputs:{x:e},backend:s,attrs:{shape:m?[n.batchSize,l,n.inChannels]:[n.batchSize,n.inChannels,l]}}),c=Y_({inputs:{x:t},backend:s,attrs:{shape:[1,n.inChannels,n.outChannels]}}),h=lF({a:m?u:c,b:m?c:u,transposeA:!m,transposeB:false,backend:s,bias:r,activation:o,preluActivationWeights:a,leakyreluAlpha:i});g=Y_({inputs:{x:h},backend:s,attrs:{shape:n.outShape}}),y.push(u),y.push(c),y.push(h)}for(const e of y)s.disposeIntermediateTensorInfo(e);return g}function DD({x:e,filter:t,convInfo:n,backend:s,bias:r=null,preluActivationWeights:a=null,leakyreluAlpha:i=0,activation:o=null}){const{filterWidth:l,filterHeight:u,inChannels:c,outWidth:h,outHeight:p,dataFormat:f}=n,m="channelsLast"===f,g=l*u*c,y=p*h,b=[n.batchSize,g,y],x=[];if(null!=a){const e=_D(a.shape,m);null!=e&&(a=Y_({inputs:{x:a},backend:s,attrs:{shape:e}}),x.push(a))}if(null!=r){const e=_D(r.shape,m);null!=e&&(r=Y_({inputs:{x:r},backend:s,attrs:{shape:e}}),x.push(r))}const w=Y_({inputs:{x:t},backend:s,attrs:{shape:[1,g,d(t.shape)/g]}});x.push(w);const v=new RD(b,n),k=[e.shape,[n.padInfo.top,n.padInfo.left],[n.strideHeight,n.strideWidth],[n.dilationHeight,n.dilationWidth],[n.inChannels],[n.filterWidth*n.inChannels],[n.outWidth]],N=s.runWebGLProgram(v,[e],"float32",k),I=Y_({inputs:{x:N},backend:s,attrs:{shape:b}});x.push(N),x.push(I);const S=null!=r,T=null!=a,$="leakyrelu"===o,C=o?V_(o,!0):null,E=new U_(m?I.shape:w.shape,m?w.shape:I.shape,m?[n.batchSize,y,n.outChannels]:[n.batchSize,n.outChannels,y],!0,!1,S,C,T,$),A=m?[I,w]:[w,I];if(r&&A.push(r),T&&A.push(a),$){const e=s.makeTensorInfo([],"float32",Qs(i,"float32"));A.push(e),x.push(e)}const R=s.runWebGLProgram(E,A,"float32"),_=Y_({inputs:{x:R},backend:s,attrs:{shape:n.outShape}});x.push(R);for(const e of x)s.disposeIntermediateTensorInfo(e);return _}const OD={kernelName:Ce,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dataFormat:l,dilations:u,dimRoundingMode:c}=s,h=Ko(l),p=Po(r.shape,a.shape,i,u,o,c,!1,h);let d;if(1!==p.filterHeight||1!==p.filterWidth||1!==p.dilationHeight||1!==p.dilationWidth||1!==p.strideHeight||1!==p.strideWidth||"SAME"!==p.padInfo.type&&"VALID"!==p.padInfo.type)if(X().getBool("WEBGL_CONV_IM2COL"))d=DD({x:r,filter:a,convInfo:p,backend:n});else{const e=new ED(p);d=n.runWebGLProgram(e,[r,a],"float32")}else d=FD({x:r,filter:a,convInfo:p,backend:n});const f=Y_({inputs:{x:d},backend:n,attrs:{shape:p.outShape}});return n.disposeIntermediateTensorInfo(d),f}};class MD{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a="channelsLast"===e.dataFormat;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int d2 = coords.w;\n\n        // Convolve x(?, ?, d1) with dy(:, :, d2) to get dw(wR, wC, d1, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              if (${a}) {\n                float dyValue = getDy(b, yR, yC, d2);\n                float xValue = getX(b, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              } else {\n                float dyValue = getDy(b, d2, yR, yC);\n                float xValue = getX(b, d1, xR, xC);\n                dotProd += (xValue * dyValue);\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class LD{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a="channelsLast"===e.dataFormat,i=t-1-e.padInfo.top,o=n-1-e.padInfo.left,l=a?1:2,u=a?2:3,c=a?3:1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[${c}];\n\n        ivec2 dyCorner = ivec2(coords[${l}], coords[${u}]) - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        // Convolve dy(?, ?, d2) with w(:, :, d1, d2) to compute dx(xR, xC, d1).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n\n              if (${a}) {\n                float xValue = getDy(batch, idyR, idyC, d2);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              } else {\n                float xValue = getDy(batch, d2, idyR, idyC);\n                float wValue = getW(wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class zD{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.padInfo.front,a=e.padInfo.top,i=e.padInfo.left;this.userCode=`\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int wF = coords.x;\n        int wR = coords.y;\n        int wC = coords.z;\n        int d1 = coords.w;\n        int d2 = coords.u;\n\n        float dotProd = 0.0;\n\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yF = 0; yF < ${e.outDepth}; yF++) {\n            int xF = wF + yF * ${t} - ${r};\n\n            if (xF < 0 || xF >= ${e.inDepth}) {\n              continue;\n            }\n\n            for (int yR = 0; yR < ${e.outHeight}; yR++) {\n              int xR = wR + yR * ${n} - ${a};\n\n              if (xR < 0 || xR >= ${e.inHeight}) {\n                continue;\n              }\n\n              for (int yC = 0; yC < ${e.outWidth}; yC++) {\n                int xC = wC + yC * ${s} - ${i};\n\n                if (xC < 0 || xC >= ${e.inWidth}) {\n                  continue;\n                }\n\n                float dyValue = getDy(b, yF, yR, yC, d2);\n                float xValue = getX(b, xF, xR, xC, d1);\n                dotProd += (xValue * dyValue);\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class PD{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterDepth,n=e.filterHeight,s=e.filterWidth,r=e.strideDepth,a=e.strideHeight,i=e.strideWidth,o=t-1-e.padInfo.front,l=n-1-e.padInfo.top,u=s-1-e.padInfo.left;this.userCode=`\n      const ivec3 pads = ivec3(${o}, ${l}, ${u});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.u;\n\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyFCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        float dotProd = 0.0;\n        for (int wF = 0; wF < ${t}; wF++) {\n          float dyF = float(dyFCorner + wF) / ${r}.0;\n\n          if (dyF < 0.0 || dyF >= ${e.outDepth}.0 || fract(dyF) > 0.0) {\n            continue;\n          }\n          int idyF = int(dyF);\n\n          int wFPerm = ${t} - 1 - wF;\n\n          for (int wR = 0; wR < ${n}; wR++) {\n            float dyR = float(dyRCorner + wR) / ${a}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n              fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            int wRPerm = ${n} - 1 - wR;\n\n            for (int wC = 0; wC < ${s}; wC++) {\n              float dyC = float(dyCCorner + wC) / ${i}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              int wCPerm = ${s} - 1 - wC;\n\n              for (int d2 = 0; d2 < ${e.outChannels}; d2++) {\n                float xValue = getDy(batch, idyF, idyR, idyC, d2);\n                float wValue = getW(wFPerm, wRPerm, wCPerm, d1, d2);\n                dotProd += xValue * wValue;\n              }\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const BD={kernelName:Ee,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,dataFormat:l,dimRoundingMode:u,filterShape:c}=s,h=Ko(l),p=Po(r.shape,c,i,1,o,u,!1,h),d=new MD(p);return n.runWebGLProgram(d,[r,a],"float32")}};const WD={kernelName:Ae,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{inputShape:i,strides:o,pad:l,dataFormat:u,dimRoundingMode:c}=s,h=Ko(u),p=Po(i,a.shape,o,1,l,c,!1,h),d=new LD(p);return n.runWebGLProgram(d,[r,a],"float32")}};const VD={kernelName:Re,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Bo(r.shape,a.shape,i,l,o),c=new AD(u);return n.runWebGLProgram(c,[r,a],"float32")}};const UD={kernelName:_e,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,pad:o,filterShape:l}=s,u=Bo(r.shape,l,i,1,o),c=new zD(u);return n.runWebGLProgram(c,[r,a],"float32")}};const GD={kernelName:Fe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{pad:i,strides:o,inputShape:l}=s,u=Bo(l,a.shape,o,1,i),c=new PD(u);return n.runWebGLProgram(c,[r,a],"float32")}},HD=B_({opSnippet:"if (isnan(x)) return x;\n  return cos(x);\n"}),jD={kernelName:De,backendName:"webgl",kernelFunc:HD},qD=B_({opSnippet:"\n  float e2x = exp(-x);\n  return (e2x + 1.0 / e2x) / 2.0;\n"}),KD={kernelName:Oe,backendName:"webgl",kernelFunc:qD};class XD{constructor(e,t,n,s,r){this.variableNames=["Image","Boxes","BoxInd"],this.outputShape=[];const[a,i,o,l]=e,[u]=t,[c,h]=n;this.outputShape=[u,c,h,l];const p="bilinear"===s?1:0,[d,f]=[i-1+".0",o-1+".0"],[m,g,y]=c>1?[""+(i-1)/(c-1),"(y2-y1) * height_ratio",`y1*${d} + float(y)*(height_scale)`]:["0.0","0.0",`0.5 * (y1+y2) * ${d}`],[b,x,w]=h>1?[""+(o-1)/(h-1),"(x2-x1) * width_ratio",`x1*${f} + float(x)*(width_scale)`]:["0.0","0.0",`0.5 * (x1+x2) * ${f}`];this.userCode=`\n      const float height_ratio = float(${m});\n      const float width_ratio = float(${b});\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int y = coords[1];\n        int x = coords[2];\n        int d = coords[3];\n\n        // get box vals\n        float y1 = getBoxes(b,0);\n        float x1 = getBoxes(b,1);\n        float y2 = getBoxes(b,2);\n        float x2 = getBoxes(b,3);\n\n        // get image in batch index\n        int bInd = round(getBoxInd(b));\n        if(bInd < 0 || bInd >= ${a}) {\n          return;\n        }\n\n        float height_scale = ${g};\n        float width_scale = ${x};\n\n        float in_y = ${y};\n        if( in_y < 0.0 || in_y > ${d} ) {\n          setOutput(float(${r}));\n          return;\n        }\n        float in_x = ${w};\n        if( in_x < 0.0 || in_x > ${f} ) {\n          setOutput(float(${r}));\n          return;\n        }\n\n        vec2 sourceFracIndexCR = vec2(in_x,in_y);\n        if(${p} == 1) {\n          // Compute the four integer indices.\n          ivec2 sourceFloorCR = ivec2(sourceFracIndexCR);\n          ivec2 sourceCeilCR = ivec2(ceil(sourceFracIndexCR));\n\n          float topLeft = getImage(b, sourceFloorCR.y, sourceFloorCR.x, d);\n          float bottomLeft = getImage(b, sourceCeilCR.y, sourceFloorCR.x, d);\n          float topRight = getImage(b, sourceFloorCR.y, sourceCeilCR.x, d);\n          float bottomRight = getImage(b, sourceCeilCR.y, sourceCeilCR.x, d);\n\n          vec2 fracCR = sourceFracIndexCR - vec2(sourceFloorCR);\n\n          float top = topLeft + (topRight - topLeft) * fracCR.x;\n          float bottom = bottomLeft + (bottomRight - bottomLeft) * fracCR.x;\n          float newValue = top + (bottom - top) * fracCR.y;\n          setOutput(newValue);\n        } else {\n          // Compute the coordinators of nearest neighbor point.\n          ivec2 sourceNearestCR = ivec2(floor(\n            sourceFracIndexCR + vec2(0.5,0.5)));\n          float newValue = getImage(b, sourceNearestCR.y, sourceNearestCR.x, d);\n          setOutput(newValue);\n        }\n      }\n    `}}const YD={kernelName:ze,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{image:r,boxes:a,boxInd:i}=t,{cropSize:o,method:l,extrapolationValue:u}=s,c=new XD(r.shape,a.shape,o,l,u);return n.runWebGLProgram(c,[r,a,i],"float32")}};var ZD;!function(e){e.Prod="*",e.Sum="+"}(ZD||(ZD={}));class JD{constructor(e,t,n,s){this.op=e,this.outputShape=t,this.variableNames=["x"],this.customUniforms=[{name:"index",type:"float"}];const r=this.outputShape.length,a=this.op===ZD.Prod?"1.0":"0.0",i=n?a:`getX(${QD(r,"coords",this.op)})`,o=this.outputShape[this.outputShape.length-1];let l="",u="";n?(l=s?"end != "+(o-1):"end != 0",u=s?"end + 1":"end - 1"):(l=s?`end + pow2 < ${o}`:"end >= pow2",u=s?"end + pow2":"end - pow2"),this.userCode=`\n      void main() {\n        ${ZA(r)} coords = getOutputCoords();\n        int end = ${eO(r,"coords",this.op)};\n        float val = ${i};\n        int pow2 = int(pow(2.0, index));\n        if (${l}) {\n          int idx = ${u};\n          ${eO(r,"coords",this.op)} = idx;\n          val ${this.op}= getX(${QD(r,"coords",this.op)});\n        }\n        setOutput(val);\n      }\n    `}}function QD(e,t,n){if(1===e)return`${t}`;if(2===e)return`${t}.x, ${t}.y`;if(3===e)return`${t}.x, ${t}.y, ${t}.z`;if(4===e)return`${t}.x, ${t}.y, ${t}.z, ${t}.w`;throw new Error(`Cumulative ${n} for rank ${e} is not yet supported`)}function eO(e,t,n){if(1===e)return`${t}`;if(2===e)return`${t}.y`;if(3===e)return`${t}.z`;if(4===e)return`${t}.w`;throw new Error(`Cumulative ${n} for rank ${e} is not yet supported`)}function tO(e,t,n,s,r,a){const i=t.shape.length,o=ql([s],i);let l=t;null!=o&&(l=iF({inputs:{x:t},backend:n,attrs:{perm:o}}));const u=Xl(1,i)[0];if(u!==i-1)throw new Error(`WebGL cumprod shader expects an inner-most axis=${t.shape.length-1} but got axis=${s}`);const c=l.shape[u];let h=A_({inputs:{x:l},backend:n});for(let t=0;t<=Math.ceil(Math.log2(c))-1;t++){const s=new JD(e,l.shape,!1,a),r=[[t]],i=h;h=n.runWebGLProgram(s,[h],h.dtype,r),n.disposeIntermediateTensorInfo(i)}if(r){const t=new JD(e,l.shape,r,a),s=h;h=n.runWebGLProgram(t,[h],h.dtype),n.disposeIntermediateTensorInfo(s)}if(null!=o){const e=iF({inputs:{x:h},backend:n,attrs:{perm:Kl(o)}});return n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(l),e}return h}const nO={kernelName:Me,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;return tO(ZD.Prod,r,n,a,i,o)}};const sO={kernelName:Le,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,exclusive:i,reverse:o}=s;return tO(ZD.Sum,r,n,a,i,o)}};const rO={kernelName:Pe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,weights:a}=t,{size:i,binaryOutput:o}=s;if(1===r.shape.length){const e=n.readSync(r.dataId),t=n.readSync(a.dataId),s=NR(e,t,a.dtype,a.shape,i);return n.makeTensorInfo([i],a.dtype,s)}if(2===r.shape.length){const e=n.bufferSync(r),t=n.bufferSync(a),s=IR(e,t,i,o);return n.makeTensorInfo(s.shape,a.dtype,s.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${r.shape.length}.`)}};class aO{constructor(e,t,n){this.variableNames=["x"],this.outputShape=[],this.outputShape=e,this.blockSize=t,this.dataFormat=n,this.userCode=`\n    void main() {\n      ivec4 coords = getOutputCoords();\n      int b = coords[0];\n      int h = ${this.getHeightCoordString()};\n      int w = ${this.getWidthCoordString()};\n      int d = ${this.getDepthCoordString()};\n\n      int in_h = h / ${t};\n      int offset_h = imod(h, ${t});\n      int in_w = w / ${t};\n      int offset_w = imod(w, ${t});\n      int offset_d = (offset_h * ${t} + offset_w) *\n        ${this.getOutputDepthSize()};\n      int in_d = d + offset_d;\n\n      float result = ${this.getInputSamplingString()};\n      setOutput(result);\n    }\n  `}getHeightCoordString(){return"NHWC"===this.dataFormat?"coords[1]":"coords[2]"}getWidthCoordString(){return"NHWC"===this.dataFormat?"coords[2]":"coords[3]"}getDepthCoordString(){return"NHWC"===this.dataFormat?"coords[3]":"coords[1]"}getOutputDepthSize(){return"NHWC"===this.dataFormat?this.outputShape[3]:this.outputShape[1]}getInputSamplingString(){return"NHWC"===this.dataFormat?"getX(b, in_h, in_w, in_d)":"getX(b, in_d, in_h, in_w)"}}const iO={kernelName:Be,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{blockSize:a,dataFormat:i}=s,o=r.shape[0],l=("NHWC"===i?r.shape[1]:r.shape[2])*a,u=("NHWC"===i?r.shape[2]:r.shape[3])*a,c=("NHWC"===i?r.shape[3]:r.shape[1])/(a*a),h=new aO("NHWC"===i?[o,l,u,c]:[o,c,l,u],a,i);return n.runWebGLProgram(h,[r],r.dtype)}};class oO{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=rR(this.outputShape.length);const a=e.filterHeight,i=e.filterWidth,o=e.outChannels/e.inChannels;let l="",u="";n&&(l=s?`float activation(float a) {\n          float b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`float activation(float a) {\n          float b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`\n          float activation(float x) {\n            ${n}\n          }\n        `,u="result = activation(result);");const c=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${l}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${o};\n        int q = d2 - d1 * ${o};\n\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        // Convolve x(?, ?, d1) with w(:, :, d1, q) to get y(yR, yC, d2).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        // TO DO(dsmilkov): Flatten the two for loops and vec4 the operations.\n        for (int wR = 0; wR < ${a}; wR++) {\n          int xR = xRCorner + wR * dilations[0];\n\n          if (xR < 0 || xR >= inDims[0]) {\n            continue;\n          }\n\n          for (int wC = 0; wC < ${i}; wC++) {\n            int xC = xCCorner + wC * dilations[1];\n\n            if (xC < 0 || xC >= inDims[1]) {\n              continue;\n            }\n\n            float xVal = getX(batch, xR, xC, d1);\n            float wVal = getW(wR, wC, d1, q);\n            dotProd += xVal * wVal;\n          }\n        }\n\n        float result = dotProd;\n        ${c}\n        ${u}\n        setOutput(result);\n      }\n    `}}class lO{constructor(e,t=!1,n=null,s=!1,r=!1){this.variableNames=["x","W"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"pads",type:"ivec2"},{name:"strides",type:"ivec2"},{name:"dilations",type:"ivec2"},{name:"inDims",type:"ivec2"}],this.outputShape=e.outShape,this.enableShapeUniforms=rR(this.outputShape.length);const a=e.outChannels/e.inChannels,o=e.padInfo.left,l=e.strideWidth,u=e.dilationWidth,c=e.filterHeight,h=e.filterWidth,p=h;let d="\n      int xR; int xC; int xCOffset;\n      vec4 wTexel; vec4 previous; vec4 final;";for(let e=0;e<h;e++)d+=`\n          vec4 xTexelC${2*e};\n          int xTexelC${2*e}Ready;\n          vec4 xTexelC${2*e+1};\n          int xTexelC${2*e+1}Ready;\n          vec4 xC${e};`;d+=`\n    for (int r = 0; r < ${c}; r++) {\n      `;for(let e=0;e<h;e++)d+=`\n          xTexelC${2*e} = vec4(0.0);\n          xTexelC${2*e}Ready = 0;\n          xTexelC${2*e+1} = vec4(0.0);\n          xTexelC${2*e+1}Ready = 0;\n          xC${e} = vec4(0.0);`;d+="\n        xR = xRCorner + r * dilations[0];\n        if (xR >=0 && xR < inDims[0]) {\n      ";for(let e=0;e<(p+1)/2;e++){const t=2*e;if(d+=`\n          xC = xCCorner + ${t*u};\n          `,1===l){if(t<h&&(o%2==1?(d+=`\n                xCOffset = xC + 1;\n                if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xCOffset, d1);\n\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n              `,d+=1===u&&t>0?`\n                xC${t} = vec4(xTexelC${t-2}.zw, xTexelC${t}.xy);\n                `:`\n                  xCOffset = xC + 1 - 2;\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1]) {\n                    previous = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      previous.zw = vec2(0.0);\n                    }\n\n                    xC${t} = vec4(previous.zw, xTexelC${t}.xy);\n                  } else {\n                    xC${t} = vec4(0.0, 0.0, xTexelC${t}.xy);\n                  }\n                  `):d+=`\n                if (xC >= 0 && xC < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                xC${t} = xTexelC${t};\n                `,t+1<h)){const e=o%2==0?i(u):u;u%2==0&&o%2==1||u%2!=0&&o%2!=1?(d+=`\n                  xCOffset = xC + imod(pads[1], 2) + ${e};\n\n                  if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                    xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n\n                    // Need to manually clear unused channels in case\n                    // we're reading from recycled texture.\n                    if (xCOffset + 1 >= inDims[1]) {\n                      xTexelC${t+1}.zw = vec2(0.0);\n                    }\n                    xTexelC${t+1}Ready = 1;\n                  }\n                  `,u>1&&(d+=`\n                    xCOffset -= 2;\n                    if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t}Ready == 0) {\n                      xTexelC${t} = getX(batch, xR, xCOffset, d1);\n                      xTexelC${t}Ready = 1;\n                    }\n                    `),d+=`\n                  xC${t+1} = vec4(xTexelC${t}.zw, xTexelC${t+1}.xy);\n                  `):d+=1===e?`\n                    xC${t+1} = xTexelC${t};\n                    `:`\n                    xCOffset = xC + ${e};\n\n                    if (xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                      xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n                      if (xCOffset + 1 >= inDims[1]) {\n                        xTexelC${t+1}.zw = vec2(0.0);\n                      }\n                      xTexelC${t+1}Ready = 1;\n                    }\n\n                    xC${t+1} = xTexelC${t+1};\n                    `}}else t<h&&(o%2==1?(d+=`\n                xCOffset = xC + 1 - strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xCOffset, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                if(xC + 1 >= 0 && xC + 1 < inDims[1] && xTexelC${t+1}Ready == 0) {\n                  xTexelC${t+1} = getX(batch, xR, xC + 1, d1);\n                  // Need to manually clear unused channels in case\n                  // we're reading from recycled texture.\n                  if (xC + 2 >= inDims[1]) {\n                    xTexelC${t+1}.zw = vec2(0.0);\n                  }\n                  xTexelC${t+1}Ready = 1;\n                }\n\n                xC${t} = vec4(xTexelC${t}.zw, xTexelC${t+1}.zw);\n              `,t+1<h&&(d+=`\n                  final = vec4(0.0);\n                  xCOffset = xC + 1 + strides[1];\n                  if(xCOffset >= 0 && xCOffset < inDims[1]) {\n                    final = getX(batch, xR, xCOffset, d1);\n                  }\n                  xC${t+1} = vec4(xTexelC${t+1}.xy, final.xy);\n                `)):(d+=`\n                if(xC >= 0 && xC < inDims[1] && xTexelC${t}Ready == 0) {\n                  xTexelC${t} = getX(batch, xR, xC, d1);\n                  if (xC + 1 >= inDims[1]) {\n                    xTexelC${t}.zw = vec2(0.0);\n                  }\n                  xTexelC${t}Ready = 1;\n                }\n\n                xCOffset = xC + strides[1];\n                if(xCOffset >= 0 && xCOffset < inDims[1] && xTexelC${t+1}Ready == 0) {\n                  xTexelC${t+1} = getX(batch, xR, xCOffset, d1);\n                  if (xCOffset + 1 >= inDims[1]) {\n                    xTexelC${t+1}.zw = vec2(0.);\n                  }\n                  xTexelC${t+1}Ready = 1;\n                }\n\n                xC${t} = vec4(\n                  xTexelC${t}.xy, xTexelC${t+1}.xy);\n              `,t+1<h&&(d+=`\n                  xC${t+1} = vec4(xTexelC${t}.zw, xTexelC${t+1}.zw);\n                `)));t<h&&(d+=`\n            wTexel = getW(r, ${t}, d1, q);\n            dotProd += xC${t} * vec4(wTexel.xz, wTexel.xz);\n          `,t+1<h&&(d+=`\n              wTexel = getW(r, ${t+1}, d1, q);\n              dotProd += xC${t+1} * vec4(wTexel.xz, wTexel.xz);\n            `))}d+="\n    }\n  ",d+="\n      }\n    ";let f="",m="";n&&(f=s?`vec4 activation(vec4 a) {\n          vec4 b = getPreluActivationWeightsAtOutCoords();\n          ${n}\n        }`:r?`vec4 activation(vec4 a) {\n          vec4 b = getLeakyreluAlphaAtOutCoords();\n          ${n}\n        }`:`vec4 activation(vec4 x) {\n          ${n}\n        }`,m="result = activation(result);");const g=t?"result += getBiasAtOutCoords();":"";t&&this.variableNames.push("bias"),s&&this.variableNames.push("preluActivationWeights"),r&&this.variableNames.push("leakyreluAlpha"),this.userCode=`\n      ${f}\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        ivec2 xRCCorner = coords.yz * strides - pads;\n        int d2 = coords.w;\n        int d1 = d2 / ${a};\n        int q = d2 - d1 * ${a};\n        int xRCorner = xRCCorner.x;\n        int xCCorner = xRCCorner.y;\n\n        //intialize dotProd with a small epsilon seems to reduce GPU accuracy loss.\n        vec4 dotProd = vec4(0.000000000000001);\n\n        ${d}\n\n        vec4 result = dotProd - vec4(0.000000000000001);\n        ${g}\n        ${m}\n        setOutput(result);\n      }\n    `}}const uO={kernelName:We,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l,dimRoundingMode:c}=s;let h=l;null==h&&(h=[1,1]),u(qo(i,h),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${i} and dilations '${h}'`));const p=Po(r.shape,a.shape,i,h,o,c,!0);let d;d=X().getBool("WEBGL_PACK_DEPTHWISECONV")&&p.strideWidth<=2&&p.outChannels/p.inChannels==1?new lO(p):new oO(p);const f=[[p.padInfo.top,p.padInfo.left],[p.strideHeight,p.strideWidth],[p.dilationHeight,p.dilationWidth],[p.inHeight,p.inWidth]];return n.runWebGLProgram(d,[r,a],"float32",f)}};class cO{constructor(e){this.variableNames=["x","dy"],this.outputShape=e.filterShape;const t=e.strideHeight,n=e.strideWidth,s=e.padInfo.top,r=e.padInfo.left,a=e.outChannels/e.inChannels;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int wR = coords.x;\n        int wC = coords.y;\n        int d1 = coords.z;\n        int dm = coords.w;\n        int d2 = d1 * ${a} + dm;\n\n        float dotProd = 0.0;\n\n        // TO DO: Vec4 over the batch size\n        for (int b = 0; b < ${e.batchSize}; b++) {\n          for (int yR = 0; yR < ${e.outHeight}; yR++) {\n            int xR = wR + yR * ${t} - ${s};\n\n            if (xR < 0 || xR >= ${e.inHeight}) {\n              continue;\n            }\n\n            for (int yC = 0; yC < ${e.outWidth}; yC++) {\n              int xC = wC + yC * ${n} - ${r};\n\n              if (xC < 0 || xC >= ${e.inWidth}) {\n                continue;\n              }\n\n              float dyValue = getDy(b, yR, yC, d2);\n              float xValue = getX(b, xR, xC, d1);\n              dotProd += (xValue * dyValue);\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class hO{constructor(e){this.variableNames=["dy","W"],this.outputShape=e.inShape;const t=e.filterHeight,n=e.filterWidth,s=e.strideHeight,r=e.strideWidth,a=t-1-e.padInfo.top,i=n-1-e.padInfo.left,o=e.outChannels/e.inChannels;this.userCode=`\n      const ivec2 pads = ivec2(${a}, ${i});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords[0];\n        int d1 = coords[3];\n        ivec2 dyCorner = coords.yz - pads;\n        int dyRCorner = dyCorner.x;\n        int dyCCorner = dyCorner.y;\n\n        float dotProd = 0.0;\n\n        for (int wR = 0; wR < ${t}; wR++) {\n          float dyR = float(dyRCorner + wR) / ${s}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          int wRPerm = ${t} - 1 - wR;\n\n          for (int wC = 0; wC < ${n}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${r}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            int wCPerm = ${n} - 1 - wC;\n\n            // TO DO: Vec4 over the channelMul\n            for (int dm = 0; dm < ${o}; dm++) {\n              int d2 = d1 * ${o} + dm;\n              float xValue = getDy(batch, idyR, idyC, d2);\n              float wValue = getW(wRPerm, wCPerm, d1, dm);\n              dotProd += xValue * wValue;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const pO={kernelName:Ve,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,dy:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,filterShape:c}=s,h=Po(r.shape,c,i,o,l,u,!0),p=new cO(h);return n.runWebGLProgram(p,[r,a],"float32")}};const dO={kernelName:Ue,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,filter:a}=t,{strides:i,dilations:o,pad:l,dimRoundingMode:u,inputShape:c}=s,h=Po(c,a.shape,i,o,l,u,!0),p=new hO(h);return n.runWebGLProgram(p,[r,a],"float32")}};class fO{constructor(e){this.variableNames=["X"],this.outputShape=[e,e],this.userCode="\n      void main() {\n          ivec2 coords = getOutputCoords();\n          float val = coords[0] == coords[1] ? getX(coords[0]) : 0.0;\n          setOutput(val);\n      }\n    "}}const mO={kernelName:Ge,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t,r=[...s.shape,...s.shape],a=d(s.shape),i=Y_({inputs:{x:s},backend:n,attrs:{shape:[a]}}),o=new fO(a),l=n.runWebGLProgram(o,[i],i.dtype),u=Y_({inputs:{x:l},backend:n,attrs:{shape:r}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(l),u}};class gO{constructor(e){this.variableNames=["x","W"],this.outputShape=e.outShape;const{inHeight:t,inWidth:n,padInfo:s,strideHeight:r,strideWidth:a,filterHeight:i,filterWidth:o,dilationHeight:l,dilationWidth:u}=e,{top:c,left:h}=s;this.userCode=`\n      const ivec2 strides = ivec2(${r}, ${a});\n      const ivec2 pads = ivec2(${c}, ${h});\n      const float neg_infinity = -3.4e38;\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int batch = coords.x;\n        int d1 = coords.w;\n        ivec2 outTopLeftCorner =\n            coords.yz * strides - pads;\n        int hBeg = outTopLeftCorner.x;\n        int wBeg = outTopLeftCorner.y;\n\n        float curVal = neg_infinity;\n        for (int h = 0; h < ${i}; h++) {\n          int hIn = hBeg + h * ${l};\n\n          if (hIn >= 0 && hIn < ${t}) {\n            for (int w = 0; w < ${o}; w++) {\n              int wIn = wBeg + w * ${u};\n\n              if (wIn >= 0 && wIn < ${n}) {\n                float xVal = getX(batch, hIn, wIn, d1);\n                float wVal = getW(h, w, d1);\n\n                float val = xVal + wVal;\n                if (val > curVal) {\n                  curVal = val;\n                }\n              }\n            }\n          }\n        }\n\n        float result = curVal;\n        setOutput(result);\n      }\n    `}}const yO={kernelName:He,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a}=t,{strides:i,pad:o,dilations:l}=s,u=Mo(r.shape,a.shape,i,o,"NHWC",l);let c;const h=new gO(u);c=n.runWebGLProgram(h,[r,a],"float32");const p=Y_({inputs:{x:c},backend:n,attrs:{shape:u.outShape}});return n.disposeIntermediateTensorInfo(c),p}};const bO={kernelName:Xe,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{equation:r}=s,a=t,{allDims:i,summedDims:o,idDims:l}=Rd(r,a.length);Fd(i.length,l,a);const{path:u,steps:c}=Dd(o,l),h=c.length;let p=null,d=i.length;const m=[];for(let e=0;e<h;++e){for(const t of c[e]){const{permutationIndices:e,expandDims:s}=_d(d,l[t]);let r;Od(e)?r=a[t]:(r=iF({inputs:{x:a[t]},backend:n,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);f(r.shape,i)||(r=Y_({inputs:{x:r},backend:n,attrs:{shape:i}}),m.push(r)),null===p?p=r:(p=K_({inputs:{a:r,b:p},backend:n}),m.push(p))}e<h-1&&(u[e]>=0&&(p=rF({inputs:{x:p},backend:n,attrs:{axis:u[e]-(i.length-d),keepDims:!1}}),m.push(p)),d--)}for(const e of m)e!==p&&n.disposeIntermediateTensorInfo(e);return p}},xO=B_({opSnippet:"return (x >= 0.0) ? x : (exp(x) - 1.0);",packedOpSnippet:"\n  vec4 result;\n\n  result.r = (x.r >= 0.0) ? x.r : (exp(x.r) - 1.0);\n  result.g = (x.g >= 0.0) ? x.g : (exp(x.g) - 1.0);\n  result.b = (x.b >= 0.0) ? x.b : (exp(x.b) - 1.0);\n  result.a = (x.a >= 0.0) ? x.a : (exp(x.a) - 1.0);\n\n  return result;\n"}),wO={kernelName:Ye,backendName:"webgl",kernelFunc:xO},vO={kernelName:Ze,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n}=e,{dy:s,y:r}=t,a=X().getBool("WEBGL_PACK_BINARY_OPERATIONS")?new E_("\n  vec4 bGTEZero = vec4(greaterThanEqual(b, vec4(0.)));\n  return (bGTEZero * a) + ((vec4(1.0) - bGTEZero) * (a * (b + vec4(1.0))));\n",s.shape,r.shape):new C_("return (b >= 1.0) ? a : a * (b + 1.0);",s.shape,r.shape);return n.runWebGLProgram(a,[s,r],s.dtype)}},kO=W_({opSnippet:"return float(a == b);",packedOpSnippet:"\n  return vec4(equal(a, b));\n",dtype:"bool",cpuKernelImpl:$R}),NO={kernelName:Qe,backendName:"webgl",kernelFunc:kO},IO=B_({opSnippet:`\n  // Error function is calculated approximately with elementary function.\n  // See "Handbook of Mathematical Functions with Formulas,\n  // Graphs, and Mathematical Tables", Abramowitz and Stegun.\n  float p = ${md};\n  float a1 = ${gd};\n  float a2 = ${yd};\n  float a3 = ${bd};\n  float a4 = ${xd};\n  float a5 = ${wd};\n\n  float sign = sign(x);\n  x = abs(x);\n  float t = 1.0 / (1.0 + p * x);\n  return sign * (1.0 - (((((a5*t + a4)*t) + a3)*t + a2)*t + a1)*t*exp(-x*x));\n`}),SO={kernelName:Je,backendName:"webgl",kernelFunc:IO},TO=B_({opSnippet:"if (isnan(x)) return x;\n  return exp(x);\n",packedOpSnippet:"\n  vec4 result = exp(x);\n  bvec4 isNaN = isnan(x);\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n",cpuKernelImpl:CR,dtype:"float32"}),$O={kernelName:et,backendName:"webgl",kernelFunc:TO};function CO(e){const{inputs:t,attrs:n,backend:s}=e,{dim:r}=n,{input:a}=t,i=a.shape.length,o=a.shape.slice();let l=r;return r<0&&(u(-(i+1)<=r,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),l=i+r+1),o.splice(l,0,1),Y_({inputs:{x:a},backend:s,attrs:{shape:o}})}const EO={kernelName:tt,backendName:"webgl",kernelFunc:CO},AO="return exp(x) - 1.0;",RO=B_({opSnippet:AO,packedOpSnippet:AO,cpuKernelImpl:ER}),_O={kernelName:nt,backendName:"webgl",kernelFunc:RO};class FO{constructor(e,t,n){this.variableNames=["real","imag"];const s=t[1];this.outputShape=t;const r=n?`2.0 * ${Math.PI}`:`-2.0 * ${Math.PI}`,a=n?`${s}.0`:"1.0";let i;if("real"===e)i="return real * expR - imag * expI;";else{if("imag"!==e)throw new Error(`FFT component must be either "real" or "imag", got ${e}.`);i="return real * expI + imag * expR;"}this.userCode=`\n      const float exponentMultiplier = ${r};\n\n      float unaryOpComplex(float real, float expR, float imag, float expI) {\n        ${i}\n      }\n\n      float mulMatDFT(int batch, int index) {\n        float indexRatio = float(index) / float(${s});\n        float exponentMultiplierTimesIndexRatio =\n            exponentMultiplier * indexRatio;\n\n        float result = 0.0;\n\n        for (int i = 0; i < ${s}; i++) {\n          // x = (-2|2 * PI / N) * index * i;\n          float x = exponentMultiplierTimesIndexRatio * float(i);\n          float expR = cos(x);\n          float expI = sin(x);\n          float real = getReal(batch, i);\n          float imag = getImag(batch, i);\n\n          result +=\n              unaryOpComplex(real, expR, imag, expI) / ${a};\n        }\n\n        return result;\n      }\n\n      void main() {\n        ivec2 coords = getOutputCoords();\n        setOutput(mulMatDFT(coords[0], coords[1]));\n      }\n    `}}function DO(e,t,n){const s=n.texData.get(e.dataId),r=d(e.shape),a=e.shape[e.shape.length-1],i=Y_({inputs:{x:e},backend:n,attrs:{shape:[r/a,a]}}),o=i.shape,l=new FO("real",o,t),u=new FO("imag",o,t),c=[{dataId:s.complexTensorInfos.real.dataId,dtype:s.complexTensorInfos.real.dtype,shape:o},{dataId:s.complexTensorInfos.imag.dataId,dtype:s.complexTensorInfos.imag.dtype,shape:o}],h=n.runWebGLProgram(l,c,"float32"),p=n.runWebGLProgram(u,c,"float32"),f=__({inputs:{real:h,imag:p},backend:n});n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p);const m=Y_({inputs:{x:f},backend:n,attrs:{shape:e.shape}});return n.disposeIntermediateTensorInfo(i),n.disposeIntermediateTensorInfo(f),m}const OO={kernelName:st,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return DO(s,!1,n)}};class MO{constructor(e,t){this.outputShape=[],this.customUniforms=[{name:"value",type:"float"}],this.variableNames=["x"],this.outputShape=e,this.userCode="\n      void main() {\n        // Input can be obtained from uniform value.\n        setOutput(value);\n      }\n    "}}function LO(e){const{backend:t,attrs:n}=e,{shape:s,value:r}=n;let{dtype:a}=n;if(a=a||F(r),"string"===a){const e=N(a,d(s));return e.fill(r),t.makeTensorInfo(s,a,e)}{const e=new MO(s,r),n=[[r]];return t.runWebGLProgram(e,[],a,n)}}const zO={kernelName:rt,backendName:"webgl",kernelFunc:LO};class PO{constructor(e){this.variableNames=["Image"],this.outputShape=[];const t=e[2];this.outputShape=e,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n\n          int coordX = ${t} - x - 1;\n          float outputValue;\n          if(coordX >= 0 && coordX < ${t}) {\n            outputValue = getImage(coords[0], coords[1], coordX, coords[3]);\n          } else {\n            outputValue = getImage(coords[0], coords[1], coords[2], coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const BO={kernelName:at,backendName:"webgl",kernelFunc:({inputs:e,backend:t})=>{const{image:n}=e,s=t,r=new PO(n.shape);return s.runWebGLProgram(r,[n],n.dtype)}},WO="return floor(x);",VO=B_({opSnippet:WO,packedOpSnippet:WO,cpuKernelImpl:AR}),UO={kernelName:it,backendName:"webgl",kernelFunc:VO},GO=W_({opSnippet:"\n  float s = sign(a) * sign(b);\n  int ia = round(a);\n  int ib = round(b);\n  if (ib != 0) {\n    // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n    return float(idiv(ia, ib, s));\n  } else {\n    return NAN;\n  }\n",packedOpSnippet:"\n  ivec4 ia = round(a);\n  ivec4 ib = round(b);\n  bvec4 cond = notEqual(ib, ivec4(0));\n  ivec4 result = ivec4(0);\n  vec4 s = sign(a) * sign(b);\n\n  // Windows (D3D) wants guaranteed non-zero int division at compile-time.\n  if (cond[0]) {\n    result[0] = idiv(ia[0], ib[0], s[0]);\n  }\n  if (cond[1]) {\n    result[1] = idiv(ia[1], ib[1], s[1]);\n  }\n  if (cond[2]) {\n    result[2] = idiv(ia[2], ib[2], s[2]);\n  }\n  if (cond[3]) {\n    result[3] = idiv(ia[3], ib[3], s[3]);\n  }\n  return vec4(result);\n",dtype:"int32"}),HO={kernelName:ot,backendName:"webgl",kernelFunc:GO};class jO{constructor(e){this.variableNames=["A"];const t=DA(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n        vec2 uv = (vec2(texC, texR) + halfCR) / vec2(${s}.0, ${n}.0);\n\n        vec4 values = ${t.texture2D}(A, uv);\n        float value;\n        if (depth == 0) {\n          value = values.r;\n        } else if (depth == 1) {\n          value = values.g;\n        } else if (depth == 2) {\n          value = values.b;\n        } else if (depth == 3) {\n          value = values.a;\n        }\n\n        setOutput(floor(value * 255.0 + 0.5));\n      }\n    `}}class qO{constructor(e){this.variableNames=["A"],this.packedInputs=!1,this.packedOutput=!0;const t=DA(),[n,s]=e;this.outputShape=e,this.userCode=`\n      void main() {\n        ivec3 coords = getOutputCoords();\n        int texR = coords[0];\n        int texC = coords[1];\n        int depth = coords[2];\n\n        vec4 result = vec4(0.);\n\n        for(int row=0; row<=1; row++) {\n          for(int col=0; col<=1; col++) {\n            texC = coords[1] + row;\n            depth = coords[2] + col;\n\n            vec2 uv = (vec2(texC, texR) + halfCR) /\n                       vec2(${s}.0, ${n}.0);\n            vec4 values = ${t.texture2D}(A, uv);\n            float value;\n            if (depth == 0) {\n              value = values.r;\n            } else if (depth == 1) {\n              value = values.g;\n            } else if (depth == 2) {\n              value = values.b;\n            } else if (depth == 3) {\n              value = values.a;\n            }\n\n            result[row * 2 + col] = floor(value * 255.0 + 0.5);\n          }\n        }\n\n        ${t.output} = result;\n      }\n    `}}const KO={kernelName:ts,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e;let{pixels:r}=t;const{numChannels:a}=s,i="undefined"!=typeof HTMLVideoElement&&r instanceof HTMLVideoElement,o="undefined"!=typeof HTMLImageElement&&r instanceof HTMLImageElement,[l,u]=i?[r.videoWidth,r.videoHeight]:[r.width,r.height],c=[u,l],h=[u,l,a];(o||i)&&(null==XO&&(XO=document.createElement("canvas").getContext("2d")),XO.canvas.width=l,XO.canvas.height=u,XO.drawImage(r,0,0,l,u),r=XO.canvas);const p=n.makeTensorInfo(c,"int32");n.texData.get(p.dataId).usage=nA.PIXELS,n.gpgpu.uploadPixelDataToTexture(n.getTexture(p.dataId),r);const d=X().getBool("WEBGL_PACK")?new qO(h):new jO(h),f=n.runWebGLProgram(d,[p],"int32");return n.disposeData(p.dataId),f}};let XO;const YO={kernelName:rs,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:u,dataFormat:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=Ko(c),g=Po(r.shape,a.shape,l,h,u,p,!1,m);let y;const b=[];if(1!==g.filterHeight||1!==g.filterWidth||1!==g.dilationHeight||1!==g.dilationWidth||1!==g.strideHeight||1!==g.strideWidth||"SAME"!==g.padInfo.type&&"VALID"!==g.padInfo.type)if(X().getBool("WEBGL_CONV_IM2COL"))y=DD({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});else{const e=null!=i,t=null!=o,s="leakyrelu"===d,l=d?V_(d,!1):null,u=new ED(g,e,l,t,s),h=[r,a],p=(e,t)=>{if("NCHW"===t&&1===e.shape.length&&1!==e.shape[0]){const t=Y_({inputs:{x:e},backend:n,attrs:{shape:[e.shape[0],1,1]}});return b.push(t),t}return e};if(e&&h.push(p(i,c)),t&&h.push(p(o,c)),s){const e=n.makeTensorInfo([],"float32",Qs(f,"float32"));h.push(e),b.push(e)}y=n.runWebGLProgram(u,h,"float32")}else y=FD({x:r,filter:a,convInfo:g,backend:n,bias:i,activation:d,preluActivationWeights:o,leakyreluAlpha:f});const x=Y_({inputs:{x:y},backend:n,attrs:{shape:g.outShape}});return b.push(y),b.forEach((e=>n.disposeIntermediateTensorInfo(e))),x}};const ZO={kernelName:as,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,filter:a,bias:i,preluActivationWeights:o}=t,{strides:l,pad:c,dilations:h,dimRoundingMode:p,activation:d,leakyreluAlpha:f}=s,m=[];let g=h;null==g&&(g=[1,1]),u(qo(l,g),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${l} and dilations '${g}'`));const y=Po(r.shape,a.shape,l,g,c,p,!0),b=X().getBool("WEBGL_PACK_DEPTHWISECONV")&&y.strideWidth<=2&&y.outChannels/y.inChannels==1,x=d?V_(d,b):null,w=[r,a],v=null!=i,k=null!=o,N="leakyrelu"===d;if(v&&w.push(i),k&&w.push(o),N){const e=n.makeTensorInfo([],"float32",Qs(f,"float32"));w.push(e),m.push(e)}let I;I=b?new lO(y,v,x,k,N):new oO(y,v,x,k,N);const S=[[y.padInfo.top,y.padInfo.left],[y.strideHeight,y.strideWidth],[y.dilationHeight,y.dilationWidth],[y.inHeight,y.inWidth]],T=n.runWebGLProgram(I,w,"float32",S);return m.forEach((e=>n.disposeIntermediateTensorInfo(e))),T}};class JO{constructor(e,t,n,s){this.sliceDim=e,this.strides=t,this.paramsShape=s,this.variableNames=["x","indices"],this.outputShape=n;const r=ZA(t.length),a=ZA(n.length),i=this.sliceDim>1?"strides[j]":"strides",o=ZA(s.length),l=s.length>1?"paramsShape[j]":"paramsShape";this.userCode=`\n        ${r} strides = ${r}(${this.strides});\n        ${o} paramsShape = ${o}(${this.paramsShape});\n         void main() {\n          ${a} coords = getOutputCoords();\n          int flattenIndex = 0;\n          bool out_of_bounds = false;\n          for (int j = 0; j < ${this.sliceDim}; j++) {\n            int index = round(getIndices(coords[0], j));\n            out_of_bounds = out_of_bounds || index < 0;\n            out_of_bounds = out_of_bounds || index >= ${l};\n            flattenIndex += index * ${i};\n          }\n          setOutput(out_of_bounds ? 0.0 : getX(flattenIndex, coords[1]));\n        }\n      `}}const QO={kernelName:ct,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{params:s,indices:r}=t,a=r.shape,i=a[a.length-1],o=d(s.shape),[l,u,c,h]=Bi(s,r),p=Y_({inputs:{x:r},backend:n,attrs:{shape:[u,i]}}),f=Y_({inputs:{x:s},backend:n,attrs:{shape:[d(s.shape)/c,c]}});if(n.shouldExecuteOnCPU([s,r])||"string"===s.dtype){const e=n.readSync(r.dataId),t=n.bufferSync(s),a=RR(e,t,s.dtype,u,i,c,h,s.shape,o);return n.makeTensorInfo(l,s.dtype,a.values)}const m=new JO(i,h,[u,c],s.shape),g=n.runWebGLProgram(m,[f,p],f.dtype),y=Y_({inputs:{x:g},backend:n,attrs:{shape:l}});return n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(g),y}};class eM{constructor(e,t){this.variableNames=["A","indices"],this.outputShape=t,this.rank=t.length;const n=ZA(this.rank),s=function(e,t){const n=["resRC.x","resRC.y","resRC.z","resRC.w"],s=[];for(let t=0;t<e.length;t++)2===t?s.push("index"):s.push(`${n[t]}`);return s.join()}(e);this.userCode=`\n      void main() {\n        ${n} resRC = getOutputCoords();\n        int index = int(getIndices(resRC.x, resRC.z));\n        float inBounds = (index >= 0) && (index < ${e[2]}) ? 1.0 : 0.0;\n        setOutput(inBounds * getA(${s}));\n      }\n    `}}function tM(e){const{inputs:t,backend:n,attrs:s}=e,{x:r,indices:a}=t,{axis:i,batchDims:o}=s,l=w(i,r.shape)[0];if(X().get("DEBUG")){const e=n.readSync(a.dataId),t=r.shape[l];for(let n=0;n<e.length;++n){const s=e[n];u(s<=t-1&&s>=0,(()=>`GatherV2: the index value ${s} is not in [0, ${t-1}]`))}}const c=Jd(r,a,l,o),h=d(a.shape),p=[],f=Y_({inputs:{x:r},backend:n,attrs:{shape:[c.batchSize,c.outerSize,c.dimSize,c.sliceSize]}}),m=Y_({inputs:{x:a},backend:n,attrs:{shape:[c.batchSize,h/c.batchSize]}});p.push(f),p.push(m);const g=[c.batchSize,c.outerSize,h/c.batchSize,c.sliceSize];if(n.shouldExecuteOnCPU([r,a])||"string"===r.dtype){const e=n.bufferSync(m),t=n.bufferSync(f),s=_R(t,e,g);return p.forEach((e=>n.disposeIntermediateTensorInfo(e))),n.makeTensorInfo(c.outputShape,s.dtype,s.values)}const y=new eM(f.shape,g),b=n.runWebGLProgram(y,[f,m],f.dtype);p.push(b);const x=Y_({inputs:{x:b},backend:n,attrs:{shape:c.outputShape}});return p.forEach((e=>n.disposeIntermediateTensorInfo(e))),x}const nM={kernelName:ut,backendName:"webgl",kernelFunc:tM},sM=W_({opSnippet:"return float(a > b);",packedOpSnippet:"\n  return vec4(greaterThan(a, b));\n",cpuKernelImpl:FR,dtype:"bool"}),rM={kernelName:ht,backendName:"webgl",kernelFunc:sM},aM=W_({opSnippet:"return float(a >= b);",packedOpSnippet:"\n  return vec4(greaterThanEqual(a, b));\n",dtype:"bool",cpuKernelImpl:DR}),iM={kernelName:pt,backendName:"webgl",kernelFunc:aM};const oM={kernelName:ft,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{input:s}=t;return DO(s,!0,n)}},lM=B_({opSnippet:"return float(!isnan(x) && !isinf(x));",dtype:"bool"}),uM={kernelName:gt,backendName:"webgl",kernelFunc:lM},cM=B_({opSnippet:"return float(isinf(x));",dtype:"bool"}),hM={kernelName:yt,backendName:"webgl",kernelFunc:cM},pM=B_({opSnippet:"return float(isnan(x));",dtype:"bool"}),dM={kernelName:bt,backendName:"webgl",kernelFunc:pM},fM=W_({opSnippet:"return float(a < b);",packedOpSnippet:"\n  return vec4(lessThan(a, b));\n",cpuKernelImpl:OR,dtype:"bool"}),mM={kernelName:wt,backendName:"webgl",kernelFunc:fM},gM=W_({opSnippet:"return float(a <= b);",packedOpSnippet:"\n  return vec4(lessThanEqual(a, b));\n",cpuKernelImpl:MR,dtype:"bool"}),yM={kernelName:vt,backendName:"webgl",kernelFunc:gM};const bM={kernelName:kt,backendName:"webgl",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:s,stop:r,num:a}=n,i=LR(s,r,a);return t.makeTensorInfo([i.length],"float32",i)}},xM=B_({opSnippet:"if (isnan(x)) return x;\n  return x < 0.0 ? 0./0. : log(x);\n",packedOpSnippet:"\n  vec4 result = log(x);\n  bvec4 isNaN = isnan(x);\n  result.r = isNaN.r ? x.r : (x.r < 0.0 ? 0./0. : result.r);\n  result.g = isNaN.g ? x.g : (x.g < 0.0 ? 0./0. : result.g);\n  result.b = isNaN.b ? x.b : (x.b < 0.0 ? 0./0. : result.b);\n  result.a = isNaN.a ? x.a : (x.a < 0.0 ? 0./0. : result.a);\n  return result;\n",cpuKernelImpl:zR}),wM={kernelName:Nt,backendName:"webgl",kernelFunc:xM},vM=B_({opSnippet:"if (isnan(x)) return x;\n  return log(1.0 + x);\n"}),kM={kernelName:It,backendName:"webgl",kernelFunc:vM},NM=W_({opSnippet:"return float(a >= 1.0 && b >= 1.0);",packedOpSnippet:"\n  return vec4(\n    vec4(greaterThanEqual(a, vec4(1.0))) *\n    vec4(greaterThanEqual(b, vec4(1.0))));\n",dtype:"bool"}),IM={kernelName:St,backendName:"webgl",kernelFunc:NM},SM=B_({opSnippet:"return float(!(x >= 1.0));"}),TM={kernelName:Tt,backendName:"webgl",kernelFunc:SM},$M=W_({opSnippet:"return float(a >= 1.0 || b >= 1.0);",packedOpSnippet:"\n  return min(\n    vec4(greaterThanEqual(a, vec4(1.0))) +\n    vec4(greaterThanEqual(b, vec4(1.0))),\n    vec4(1.0));\n",dtype:"bool"}),CM={kernelName:$t,backendName:"webgl",kernelFunc:$M};class EM{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[];const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n        int d = coords[3];\n        float x = getX(b, r, c, d);\n        float sum = 0.0;\n        for (int j = -${a}; j <= ${a}; j++) {\n          int idx = d + j;\n          if (idx >= 0 && idx <=  ${i}) {\n            float z = getX(b, r, c, idx);\n            sum += z * z;\n          }\n        }\n        float val = x * ${o};\n        setOutput(val);\n      }\n    `}}class AM{constructor(e,t,n,s,r){this.variableNames=["x"],this.outputShape=[],this.packedInputs=!0,this.packedOutput=!0;const a=t,i=e[3]-1;let o;this.outputShape=e;const l=`float(${n}) + float(${s}) * sum`;o=.5===r?`inversesqrt(${l})`:1===r?`1.0/(${l})`:`exp(log(${l}) * float(-${r}));`,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords.x;\n        int r = coords.y;\n        int c = coords.z;\n        int d = coords.w;\n\n        bool hasNextCol = d < ${this.outputShape[3]};\n        bool hasNextRow = c < ${this.outputShape[2]};\n\n        vec4 sum = vec4(0.);\n        vec4 xFragAtOutputCoords = getX(b, r, c, d);\n\n        vec4 xAtOutputCoords = vec4(\n          getChannel(xFragAtOutputCoords, vec2(c, d)),\n          hasNextCol ?\n            getChannel(xFragAtOutputCoords, vec2(c, d + 1)) : 0.0,\n          hasNextRow ?\n            getChannel(xFragAtOutputCoords , vec2(c + 1, d)) : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getChannel(xFragAtOutputCoords, vec2(c + 1, d + 1)) : 0.0\n        );\n\n        int firstChannel = d - ${a};\n        vec2 cache = vec2(0.);\n        if(firstChannel >= 0){\n          vec4 firstChannelFrag = getX(b, r, c, firstChannel);\n          cache.x = getChannel(firstChannelFrag, vec2(c, firstChannel));\n            if(hasNextRow){\n              cache.y = getChannel(firstChannelFrag, vec2(c + 1, firstChannel));\n            }\n        }\n\n        ivec2 depth = ivec2(d, d + 1);\n        for (int j = - ${a}; j <= ${a}; j++) {\n          ivec2 idx = depth + j;\n          bvec2 aboveLowerBound = greaterThanEqual(idx, ivec2(0));\n          bvec2 belowUpperBound = lessThanEqual(idx, ivec2(${i}));\n\n          bool depthInRange = aboveLowerBound.x && belowUpperBound.x;\n          bool depthPlusOneInRange = aboveLowerBound.y && belowUpperBound.y;\n\n          if(depthInRange || depthPlusOneInRange){\n            vec4 z = vec4(0.);\n            vec4 xFragAtCurrentDepth;\n            z.xz = cache.xy;\n            if(depthPlusOneInRange && hasNextCol){\n              xFragAtCurrentDepth = idx.y != d ?\n                getX(b, r, c, idx.y) : xFragAtOutputCoords;\n              z.y = getChannel(xFragAtCurrentDepth, vec2(c, idx.y));\n              if(hasNextRow){\n                z.w = getChannel(xFragAtCurrentDepth, vec2(c + 1, idx.y));\n              }\n            }\n            cache.xy = z.yw;\n            sum += z * z;\n          }\n        }\n        vec4 result = xAtOutputCoords * ${o};\n        setOutput(result);\n      }\n    `}}const RM={kernelName:Et,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{depthRadius:a,bias:i,alpha:o,beta:l}=s,u=X().getBool("WEBGL_PACK_NORMALIZATION")?new AM(r.shape,a,i,o,l):new EM(r.shape,a,i,o,l);return n.runWebGLProgram(u,[r],r.dtype)}};class _M{constructor(e,t,n,s,r){this.variableNames=["inputImage","outputImage","dy"],this.outputShape=[],this.outputShape=e,this.depth=e[3],this.depthRadius=t,this.bias=n,this.alpha=s,this.beta=r,this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int r = coords[1];\n        int c = coords[2];\n\n        float result = 0.0;\n        for (int d = 0; d < ${this.depth}; ++d) {\n          int depthBegin = int(max(0.0, float(d - ${t})));\n          int depthEnd = int(min(float(${this.depth}),\n              float(d + ${t} + 1)));\n\n          const int MIN_DEPTH_BEGIN = 0;\n          const int MAX_DEPTH_END = ${this.depth};\n\n          float norm = 0.0;\n          for (int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k) {\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd) {\n              norm += getInputImage(b, r, c, k) * getInputImage(b, r, c, k);\n            }\n            else {\n              break;\n            }\n          }\n\n          norm = float(${s}) * norm + float(${n});\n\n          for(int k = MIN_DEPTH_BEGIN; k < MAX_DEPTH_END; ++k){\n            if (k < depthBegin){\n              continue;\n            }\n            else if (k >= depthBegin && k < depthEnd){\n              float dyi = -2.0 * float(${s})\n                * float(${r})\n                * getInputImage(b ,r ,c, k) * getOutputImage(b, r, c, d)\n                / norm;\n              if (k == d) {\n                dyi += pow(norm, -1.0 * ${r});\n              }\n              if (k == coords[3]) {\n                dyi *= getDy(b, r, c, d);\n                result += dyi;\n              }\n            }\n            else {\n              break;\n            }\n          }\n      }\n      setOutput(result);\n      }\n    `}}const FM={kernelName:At,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r,y:a,dy:i}=t,{depthRadius:o,bias:l,alpha:u,beta:c}=s,h=new _M(r.shape,o,l,u,c);return n.runWebGLProgram(h,[r,a,i],r.dtype)}};function DM(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{reductionIndices:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=ql(u,o),h=null!=c,p=n.shouldExecuteOnCPU([r]);let f=r;if(h){if(p){const e=n.texData.get(f.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=r.shape[c[e]];const s=u_(e,r.shape,r.dtype,c,t);f=n.makeTensorInfo(t,r.dtype);n.texData.get(f.dataId).values=s}else f=sF(r,c,n);u=Xl(u.length,o)}jl("max",u,o);const[m,g]=Gl(f.shape,u);let y,b=m;if(i&&(b=Hl(m,l)),p){const e=n.texData.get(f.dataId).values,t=PR(e,d(g),b,r.dtype);y=n.makeTensorInfo(b,r.dtype);n.texData.get(y.dataId).values=t}else y=function(e,t,n,s){const r=d(t),a=Y_({inputs:{x:e},attrs:{shape:[d(e.shape)/r,r]},backend:s}),i=eF(a,e.dtype,"max",s),o=Y_({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(f,g,b,n);return h&&n.disposeIntermediateTensorInfo(f),y}const OM={kernelName:Rt,backendName:"webgl",kernelFunc:DM},MM=W_({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return max(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(max(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:BR}),LM={kernelName:_t,backendName:"webgl",kernelFunc:MM};const zM={kernelName:Ft,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t;_A(r,"maxPool");const{filterSize:a,strides:i,pad:o,dimRoundingMode:l}=s;u(qo(i,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${i} and dilations '1'`));const c=Lo(r.shape,a,i,1,o,l);if(1===c.filterWidth&&1===c.filterHeight&&f(c.inShape,c.outShape))return A_({inputs:{x:r},backend:n});const h=new WF(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};const PM={kernelName:Ot,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{filterSize:a,strides:i,pad:o,dataFormat:l,dimRoundingMode:u}=s,c=zo(r.shape,a,i,[1,1,1],o,u,l),h=new VF(c,"max",!1);return n.runWebGLProgram(h,[r],r.dtype)}};class BM{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideHeight,n=e.strideWidth,s=e.dilationHeight,r=e.effectiveFilterHeight,a=e.effectiveFilterWidth,i=r-1-e.padInfo.top,o=a-1-e.padInfo.left,l=r*a-1;this.userCode=`\n      const ivec2 pads = ivec2(${i}, ${o});\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n\n        ivec2 dyRCCorner = coords.yz - pads;\n        int dyRCorner = dyRCCorner.x;\n        int dyCCorner = dyRCCorner.y;\n\n        // Convolve dy(?, ?, d) with pos mask(:, :, d) to get dx(xR, xC, d).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n        for (int wR = 0; wR < ${r};\n          wR += ${s}) {\n          float dyR = float(dyRCorner + wR) / ${t}.0;\n\n          if (dyR < 0.0 || dyR >= ${e.outHeight}.0 || fract(dyR) > 0.0) {\n            continue;\n          }\n          int idyR = int(dyR);\n\n          for (int wC = 0; wC < ${a}; wC++) {\n            float dyC = float(dyCCorner + wC) / ${n}.0;\n\n            if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                fract(dyC) > 0.0) {\n              continue;\n            }\n            int idyC = int(dyC);\n\n            float dyValue = getDy(b, idyR, idyC, d);\n            int maxPosValue = ${l} - int(getMaxPos(b, idyR, idyC, d));\n\n            // Get the current value, check it against the value from the\n            // position matrix.\n            int curPosValue = wR * ${a} + wC;\n            float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n            dotProd += dyValue * mask;\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}class WM{constructor(e){this.variableNames=["dy","maxPos"],this.outputShape=e.inShape;const t=e.strideDepth,n=e.strideHeight,s=e.strideWidth,r=e.dilationDepth,a=e.dilationHeight,i=e.dilationWidth,o=e.effectiveFilterDepth,l=e.effectiveFilterHeight,u=e.effectiveFilterWidth,c=o-1-e.padInfo.front,h=l-1-e.padInfo.top,p=u-1-e.padInfo.left,d=o*l*u-1;this.userCode=`\n      const ivec3 pads = ivec3(${c}, ${h}, ${p});\n\n      void main() {\n        ivec5 coords = getOutputCoords();\n        int batch = coords.x;\n        int ch = coords.u;\n\n        ivec3 dyCorner = ivec3(coords.y, coords.z, coords.w) - pads;\n        int dyDCorner = dyCorner.x;\n        int dyRCorner = dyCorner.y;\n        int dyCCorner = dyCorner.z;\n\n        // Convolve dy(?, ?, ?, ch) with pos mask(:, :, :, d) to get\n        // dx(xD, xR, xC, ch).\n        // ? = to be determined. : = across all values in that axis.\n        float dotProd = 0.0;\n\n        for (int wD = 0; wD < ${o};\n           wD += ${r}) {\n          float dyD = float(dyDCorner + wD) / ${t}.0;\n\n          if (dyD < 0.0 || dyD >= ${e.outDepth}.0 || fract(dyD) > 0.0) {\n            continue;\n          }\n          int idyD = int(dyD);\n\n          for (int wR = 0; wR < ${l};\n              wR += ${a}) {\n            float dyR = float(dyRCorner + wR) / ${n}.0;\n\n            if (dyR < 0.0 || dyR >= ${e.outHeight}.0 ||\n                fract(dyR) > 0.0) {\n              continue;\n            }\n            int idyR = int(dyR);\n\n            for (int wC = 0; wC < ${u};\n                wC += ${i}) {\n              float dyC = float(dyCCorner + wC) / ${s}.0;\n\n              if (dyC < 0.0 || dyC >= ${e.outWidth}.0 ||\n                  fract(dyC) > 0.0) {\n                continue;\n              }\n              int idyC = int(dyC);\n\n              float dyValue = getDy(batch, idyD, idyR, idyC, ch);\n              int maxPosValue = ${d} -\n                  int(getMaxPos(batch, idyD, idyR, idyC, ch));\n\n              // Get the current value, check it against the value from the\n              // position matrix.\n              int curPosValue =\n                  wD * ${l} * ${u} +\n                  wR * ${u} + wC;\n              float mask = float(maxPosValue == curPosValue ? 1.0 : 0.0);\n\n              dotProd += dyValue * mask;\n            }\n          }\n        }\n        setOutput(dotProd);\n      }\n    `}}const VM={kernelName:Mt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a}=t,i=a,{filterSize:o,strides:l,pad:u,dimRoundingMode:c}=s,h=zo(i.shape,o,l,[1,1,1],u,c),p=new VF(h,"max",!0),d=n.runWebGLProgram(p,[i],i.dtype),f=new WM(h),m=n.runWebGLProgram(f,[r,d],i.dtype);return n.disposeIntermediateTensorInfo(d),m}};const UM={kernelName:Dt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{dy:r,input:a,output:i}=t,o=a;_A([a,i],"maxPoolGrad");const{filterSize:l,strides:u,pad:c,dimRoundingMode:h}=s,p=Lo(o.shape,l,u,1,c,h),d=new WF(p,"max",!0),f=n.runWebGLProgram(d,[o],o.dtype),m=new BM(p),g=n.runWebGLProgram(m,[r,f],o.dtype);return n.disposeIntermediateTensorInfo(f),g}};const GM={kernelName:Lt,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{filterSize:r,strides:a,pad:i,includeBatchInIndex:o}=t,l=n;u(4===s.shape.length,(()=>`Error in maxPool: input must be rank 4 but got rank ${s.shape.length}.`));const c=[1,1];u(qo(a,c),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${a} and dilations '${c}'`));const h=Lo(s.shape,r,a,c,i),[p,d]=function(e,t,n,s){let r=new WF(n,"max",!1);const a=s.runWebGLProgram(r,[e],"float32");return r=new WF(n,"max",!0,!0,t),[a,s.runWebGLProgram(r,[e],"float32")]}(s,o,h,l);return[p,d]}};const HM={kernelName:zt,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{x:s}=e,{keepDims:r,axis:a}=t,i=n,o=s.shape.length,l=w(a,s.shape);let u=l;const c=ql(u,o),h=null!=c,p=i.shouldExecuteOnCPU([s]),f=[];let m=s;if(h){if(p){const e=i.texData.get(m.dataId).values,t=new Array(o);for(let e=0;e<t.length;e++)t[e]=s.shape[c[e]];const n=u_(e,s.shape,s.dtype,c,t);m=i.makeTensorInfo(t,s.dtype);i.texData.get(m.dataId).values=n}else m=sF(s,c,i);f.push(m),u=Xl(u.length,o)}jl("sum",u,o);const[g,y]=Gl(m.shape,u);let b=g;r&&(b=Hl(g,l));const x=function(e,t,n,s){const r=d(t),a=Y_({inputs:{x:e},attrs:{shape:[d(e.shape)/r,r]},backend:s}),i=eF(a,"float32","mean",s),o=Y_({inputs:{x:i},attrs:{shape:n},backend:s});return s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}(m,y,b,i);for(const e of f)i.disposeIntermediateTensorInfo(e);return x}};const jM={kernelName:Pt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=w(a,r.shape);let u=l;const c=ql(u,o);let h=r;null!=c&&(h=iF({inputs:{x:r},backend:n,attrs:{perm:c}}),u=Xl(u.length,r.shape.length)),jl("min",u,o);const[p,f]=Gl(h.shape,u),m=Y_({inputs:{x:h},backend:n,attrs:{shape:[-1,d(f)]}}),g=eF(m,m.dtype,"min",n);let y;if(i){y=Y_({inputs:{x:g},backend:n,attrs:{shape:Hl(p,l)}})}else y=Y_({inputs:{x:g},backend:n,attrs:{shape:p}});return n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(g),null!=c&&n.disposeIntermediateTensorInfo(h),y}},qM=W_({opSnippet:"\n  if (isnan(a)) return a;\n  if (isnan(b)) return b;\n\n  return min(a, b);\n",packedOpSnippet:"\n  vec4 result = vec4(min(a, b));\n  vec4 isNaN = min(vec4(isnan(a)) + vec4(isnan(b)), vec4(1.0));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n",cpuKernelImpl:WR}),KM={kernelName:Bt,backendName:"webgl",kernelFunc:qM};class XM{constructor(e,t,n){this.variableNames=["x"],this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=ZA(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s),l="reflect"===n?0:1;this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        for (int i = 0; i < ${s}; i++) {\n          if (outC[i] < start[i]) {\n            outC[i] = start[i] * 2 - outC[i] - ${l};\n          } else if(outC[i] >= end[i]) {\n            outC[i] = (end[i] - 1) * 2 - outC[i] + ${l};\n          }\n        }\n        ${r} coords = outC - start;\n        setOutput(getX(${o}));\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start) {\n            outC = start * 2 - outC - ${l};\n          } else if(outC >= end) {\n            outC = (end - 1) * 2 - outC + ${l};\n          }\n          setOutput(getX(outC - start));\n        }\n      `}}class YM{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=ZA(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=p_("rc",s),l=p_("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h="reflect"===n?0:1;let p="";if(1===s){const e=`\n        ${r} source = rc;\n        if (source < start) {\n          source = start * 2 - source - ${h};\n        } else if (source >= end) {\n          source = (end - 1) * 2 - source + ${h};\n        }\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n      `}else{const e=`\n        ${r} source = rc;\n        ${r} lt = ${r}(lessThan(source, start));\n        ${r} gte = ${r}(greaterThanEqual(source, end));\n        ${r} orig = 1 - (lt + gte);\n        source = orig * source +\n                lt * (start * 2 - source - ${h}) +\n                gte * ((end - 1) * 2 - source + ${h});\n        source -= start;\n      `;p=`\n        ${r} rc = outputLoc;\n        ${e}\n        result[0] = getChannel(getX(${l.join()}), ${c});\n        ${o[s-1]} += 1;\n        if(${u}) {\n          ${e}\n          result[1] = getChannel(getX(${l.join()}), ${c});\n        }\n        rc = outputLoc;\n        ${o[s-2]} += 1;\n        if(${o[s-2]} < ${this.outputShape[s-2]}) {\n          ${e}\n          result[2] = getChannel(getX(${l.join()}), ${c});\n          ${o[s-1]} += 1;\n          if(${u}) {\n            ${e}\n            result[3] = getChannel(getX(${l.join()}), ${c});\n          }\n        }\n      `}this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${p}\n        setOutput(result);\n      }\n    `}}const ZM={kernelName:Wt,backendName:"webgl",kernelFunc:({inputs:e,backend:t,attrs:n})=>{const{x:s}=e,{paddings:r,mode:a}=n,i=X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new YM(s.shape,r,a):new XM(s.shape,r,a);return t.runWebGLProgram(i,[s],s.dtype)}},JM=W_({opSnippet:"if (b == 0.0) return NAN;\n  return mod(a, b);",packedOpSnippet:"\n  vec4 result = mod(a, b);\n  vec4 isNaN = vec4(equal(b, vec4(0.0)));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),QM={kernelName:Vt,backendName:"webgl",kernelFunc:JM};class eL{constructor(e,t,n){this.variableNames=["probs"],this.customUniforms=[{name:"seed",type:"float"}],this.outputShape=[e,n],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int batch = coords[0];\n\n        float r = random(seed);\n        float cdf = 0.0;\n\n        for (int i = 0; i < ${t-1}; i++) {\n          cdf += getProbs(batch, i);\n\n          if (r < cdf) {\n            setOutput(float(i));\n            return;\n          }\n        }\n\n        // If no other event happened, last event happened.\n        setOutput(float(${t-1}));\n      }\n    `}}const tL=W_({opSnippet:"\nif (a == b) {\n  return 1.0;\n};\nreturn a / b;",packedOpSnippet:"\n  // vec4 one = vec4(equal(a, b));\n  // return one + (vec4(1.0) - one) * a / b;\n  vec4 result = a / b;\n  if(a.x == b.x) {\n    result.x = 1.;\n  }\n  if(a.y == b.y) {\n    result.y = 1.;\n  }\n  if(a.z == b.z) {\n    result.z = 1.;\n  }\n  if(a.w == b.w) {\n    result.w = 1.;\n  }\n\n  return result;\n",checkOutOfBounds:!0}),nL={kernelName:Ke,backendName:"webgl",kernelFunc:tL},sL="return a - b;",rL=W_({opSnippet:sL,packedOpSnippet:sL,supportsComplex:!0,cpuKernelImpl:i_}),aL={kernelName:Un,backendName:"webgl",kernelFunc:rL};function iL(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{dim:a}=s,i=w([a],r.shape),o=DM({inputs:{x:r},backend:n,attrs:{reductionIndices:i,keepDims:!1}}),l=Hl(o.shape,i),u=Y_({inputs:{x:o},backend:n,attrs:{shape:l}}),c=rL({inputs:{a:r,b:u},backend:n}),h=TO({inputs:{x:c},backend:n}),p=rF({inputs:{x:h},backend:n,attrs:{axis:i,keepDims:!1}}),d=Y_({inputs:{x:p},backend:n,attrs:{shape:l}}),f=tL({inputs:{a:h,b:d},backend:n});return n.disposeIntermediateTensorInfo(o),n.disposeIntermediateTensorInfo(u),n.disposeIntermediateTensorInfo(c),n.disposeIntermediateTensorInfo(h),n.disposeIntermediateTensorInfo(p),n.disposeIntermediateTensorInfo(d),f}const oL={kernelName:Rn,backendName:"webgl",kernelFunc:iL};const lL={kernelName:Ut,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{logits:r}=t,{numSamples:a,seed:i,normalized:o}=s,l=o?r:iL({inputs:{logits:r},backend:n,attrs:{dim:r.shape.length-1}}),u=l.shape[0],c=l.shape[1],h=new eL(u,c,a),p=[[i]],d=n.runWebGLProgram(h,[l],"int32",p);return o||n.disposeIntermediateTensorInfo(l),d}};const uL={kernelName:Ht,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:s}=t;if(n.shouldExecuteOnCPU([s])){const e=n.texData.get(s.dataId),[t,r]=UR(e.values,s.shape,s.dtype);return n.makeTensorInfo(r,s.dtype,t)}let r;return r=X().getBool("WEBGL_PACK_UNARY_OPERATIONS")?new k_(s.shape,"\n  vec4 result = -x;\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"):new x_(s.shape,"if (isnan(x)) return x;\n  return -x;\n"),n.runWebGLProgram(r,[s],s.dtype)}},cL=np;const hL={kernelName:qt,backendName:"webgl",kernelFunc:function(e){is("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l}=s,u=n.readSync(r.dataId),c=n.readSync(a.dataId),{selectedIndices:h}=cL(u,c,i,o,l);return n.makeTensorInfo([h.length],"int32",new Int32Array(h))}},pL=sp;const dL={kernelName:Kt,backendName:"webgl",kernelFunc:function(e){is("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,padToMaxOutputSize:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),{selectedIndices:p,validOutputs:d}=pL(c,h,i,o,l,u);return[n.makeTensorInfo([p.length],"int32",new Int32Array(p)),n.makeTensorInfo([],"int32",new Int32Array([d]))]}},fL=rp;const mL={kernelName:Xt,backendName:"webgl",kernelFunc:function(e){is("tf.nonMaxSuppression() in webgl locks the UI thread. Call tf.nonMaxSuppressionAsync() instead");const{inputs:t,backend:n,attrs:s}=e,{boxes:r,scores:a}=t,{maxOutputSize:i,iouThreshold:o,scoreThreshold:l,softNmsSigma:u}=s,c=n.readSync(r.dataId),h=n.readSync(a.dataId),p=i,d=o,f=l,m=u,{selectedIndices:g,selectedScores:y}=fL(c,h,p,d,f,m);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([y.length],"float32",new Float32Array(y))]}};class gL{constructor(e,t,n,s){this.variableNames=["indices"],this.outputShape=[e,t],this.userCode=`\n      void main() {\n        ivec2 coords = getOutputCoords();\n        int index = round(getIndices(coords.x));\n        setOutput(mix(float(${s}), float(${n}),\n                      float(index == coords.y)));\n      }\n    `}}const yL={kernelName:Zt,backendName:"webgl",kernelFunc:e=>{const{inputs:t,backend:n,attrs:s}=e,{indices:r}=t,{depth:a,onValue:i,offValue:o}=s,l=d(r.shape),u=new gL(l,a,i,o),c=Y_({inputs:{x:r},backend:n,attrs:{shape:[l]}}),h=n.runWebGLProgram(u,[c],r.dtype);n.disposeIntermediateTensorInfo(c);const p=Y_({inputs:{x:h},backend:n,attrs:{shape:[...r.shape,a]}});return n.disposeIntermediateTensorInfo(h),p}};function bL(e){const{inputs:t,backend:n}=e,{x:s}=t;if("complex64"===s.dtype){const e=uD({inputs:{input:s},backend:n}),t=bL({inputs:{x:e},backend:n}),r=ID({inputs:{input:s},backend:n}),a=bL({inputs:{x:r},backend:n}),i=__({inputs:{real:t,imag:a},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(r),n.disposeIntermediateTensorInfo(a),i}return LO({attrs:{shape:s.shape,dtype:s.dtype,value:"string"===s.dtype?"":0},backend:n})}const xL={kernelName:Qn,backendName:"webgl",kernelFunc:bL};const wL={kernelName:Yt,backendName:"webgl",kernelFunc:function e(t){const{inputs:n,backend:s}=t,{x:r}=n;if("string"===r.dtype)throw new Error("onesLike is not supported under string dtype");if("complex64"===r.dtype){const t=uD({inputs:{input:r},backend:s}),n=e({inputs:{x:t},backend:s}),a=ID({inputs:{input:r},backend:s}),i=bL({inputs:{x:a},backend:s}),o=__({inputs:{real:n,imag:i},backend:s});return s.disposeIntermediateTensorInfo(t),s.disposeIntermediateTensorInfo(n),s.disposeIntermediateTensorInfo(a),s.disposeIntermediateTensorInfo(i),o}return LO({attrs:{shape:r.shape,dtype:r.dtype,value:1},backend:s})}};const vL={kernelName:Jt,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{axis:r}=s;if(1===t.length)return CO({inputs:{input:t[0]},backend:n,attrs:{dim:r}});const a=t[0].shape,i=t[0].dtype;t.forEach((e=>{c(a,e.shape,"All tensors passed to stack must have matching shapes"),u(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const o=[],l=$D({inputs:t.map((e=>{const t=CO({inputs:{input:e},backend:n,attrs:{dim:r}});return o.push(t),t})),backend:n,attrs:{axis:r}});return o.forEach((e=>n.disposeIntermediateTensorInfo(e))),l}};class kL{constructor(e,t,n){this.variableNames=["x"],this.customUniforms=[{name:"value",type:"float"}],this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=ZA(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=["coords[0]","coords[1]","coords[2]","coords[3]"].slice(0,s);this.userCode=1!==s?`\n      ${r} start = ${r}(${a});\n      ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outC = getOutputCoords();\n        if (any(lessThan(outC, start)) || any(greaterThanEqual(outC, end))) {\n          setOutput(value);\n        } else {\n          ${r} coords = outC - start;\n          setOutput(getX(${o}));\n        }\n      }\n    `:`\n        int start = ${a};\n        int end = ${i};\n\n        void main() {\n          int outC = getOutputCoords();\n          if (outC < start || outC >= end) {\n            setOutput(value);\n          } else {\n            setOutput(getX(outC - start));\n          }\n        }\n      `}}class NL{constructor(e,t,n){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0,this.customUniforms=[{name:"value",type:"float"}],this.outputShape=t.map(((t,n)=>t[0]+e[n]+t[1]));const s=e.length,r=ZA(s),a=t.map((e=>e[0])).join(","),i=t.map(((t,n)=>t[0]+e[n])).join(","),o=p_("rc",s),l=p_("source",s),u=`${o[s-1]} < ${this.outputShape[s-1]}`,c=1===s?"source":`vec2(${l.slice(-2).join()})`,h=[`${r} rc = outputLoc;`,`${o[s-1]} += 1;\n       if(${u}) {\n      `,1===s?"":`}\n       rc = outputLoc;\n       ${o[s-2]} += 1;\n       if(${o[s-2]} < ${this.outputShape[s-2]}) {`,1===s?"":`  ${o[s-1]} += 1;\n         if(${u}) {`],p=1===s?"rc < start || rc >= end":"any(lessThan(rc, start)) || any(greaterThanEqual(rc, end))";let d="";for(let e=0,t=1===s?2:4;e<t;e++)d+=`\n        ${h[e]}\n        if (${p}) {\n          result[${e}] = float(value);\n        } else {\n          ${r} source = rc - start;\n          result[${e}] = getChannel(getX(${l.join()}), ${c});\n        }\n      `;d+=1===s?"} ":"}}",this.userCode=`\n      const ${r} start = ${r}(${a});\n      const ${r} end = ${r}(${i});\n\n      void main() {\n        ${r} outputLoc = getOutputCoords();\n        vec4 result = vec4(0.);\n        ${d}\n        setOutput(result);\n      }\n    `}}const IL=e=>{const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{paddings:a,constantValue:i}=s;if(0===d(r.shape)){const e=a.map(((e,t)=>e[0]+r.shape[t]+e[1]));return LO({backend:n,attrs:{shape:e,value:i,dtype:r.dtype}})}const o=X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new NL(r.shape,a,i):new kL(r.shape,a,i),l=[[i]];return n.runWebGLProgram(o,[r],r.dtype,l)},SL={kernelName:Qt,backendName:"webgl",kernelFunc:IL},TL=W_({opSnippet:"\n  if(a < 0.0 && floor(b) < b){\n    return NAN;\n  }\n  if (b == 0.0) {\n    return 1.0;\n  }\n  return (round(mod(b, 2.0)) != 1) ?\n      pow(abs(a), b) : sign(a) * pow(abs(a), b);\n",packedOpSnippet:"\n  // isModRound1 has 1 for components with round(mod(b, 2.0)) == 1, 0 otherwise.\n  vec4 isModRound1 = vec4(equal(round(mod(b, 2.0)), ivec4(1)));\n  vec4 multiplier = sign(a) * isModRound1 + (vec4(1.0) - isModRound1);\n  vec4 result = multiplier * pow(abs(a), b);\n\n  // Ensure that a^0 = 1, including 0^0 = 1 as this correspond to TF and JS\n  bvec4 isExpZero = equal(b, vec4(0.0));\n  result.r = isExpZero.r ? 1.0 : result.r;\n  result.g = isExpZero.g ? 1.0 : result.g;\n  result.b = isExpZero.b ? 1.0 : result.b;\n  result.a = isExpZero.a ? 1.0 : result.a;\n\n  vec4 isNaN = vec4(lessThan(a, vec4(0.0))) * vec4(lessThan(floor(b), b));\n  \n  result.r = isNaN.r > 0. ? NAN : result.r;\n  result.g = isNaN.g > 0. ? NAN : result.g;\n  result.b = isNaN.b > 0. ? NAN : result.b;\n  result.a = isNaN.a > 0. ? NAN : result.a;\n\n  return result;\n"}),$L={kernelName:en,backendName:"webgl",kernelFunc:TL};const CL={kernelName:nn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{axis:a,keepDims:i}=s,o=r.shape.length,l=[],u=w(a,r.shape);let c=u;const h=ql(c,o);let p,f=r;if(null!=h&&(f=iF({inputs:{x:r},backend:n,attrs:{perm:h}}),c=Xl(c.length,o),l.push(f)),jl("prod",c,o),n.shouldExecuteOnCPU([f])){const e=n.texData.get(f.dataId).values,{outVals:t,outShape:s,outDtype:r}=HR(f.shape,f.dtype,e,c);p=n.makeTensorInfo(s,r,t)}else{const[e,t]=Gl(f.shape,c),s=d(t),a=Y_({inputs:{x:f},backend:n,attrs:{shape:[-1,s]}}),i=eF(a,Cr(r.dtype),"prod",n);p=Y_({inputs:{x:i},backend:n,attrs:{shape:e}}),l.push(a),l.push(i)}if(i){l.push(p);const e=Hl(p.shape,u);p=Y_({inputs:{x:p},backend:n,attrs:{shape:e}})}return l.forEach((e=>n.disposeIntermediateTensorInfo(e))),p}},EL=e=>{const{backend:t,attrs:n}=e,{start:s,stop:r,step:a,dtype:i}=n,o=jR(s,r,a,i);return t.makeTensorInfo([o.length],i,o)},AL={kernelName:sn,backendName:"webgl",kernelFunc:EL},RL=B_({opSnippet:"return 1.0 / x;"}),_L={kernelName:an,backendName:"webgl",kernelFunc:RL},FL=B_({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : x;\n",packedOpSnippet:"\n  vec4 result = x * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),DL={kernelName:on,backendName:"webgl",kernelFunc:FL},OL=B_({opSnippet:"if (isnan(x)) return x;\n  return (x < 0.0) ? 0.0 : min(6.0, x);\n",packedOpSnippet:"\n  vec4 result = min(x, vec4(6.)) * vec4(greaterThanEqual(x, vec4(0.0)));\n  bvec4 isNaN = isnan(x);\n\n  result.r = isNaN.r ? x.r : result.r;\n  result.g = isNaN.g ? x.g : result.g;\n  result.b = isNaN.b ? x.b : result.b;\n  result.a = isNaN.a ? x.a : result.a;\n\n  return result;\n"}),ML={kernelName:dn,backendName:"webgl",kernelFunc:OL};class LL{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC - vec2(0.5)":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec2 sourceFloorRC = ivec2(max(sourceFracIndexRC, vec2(0.0)));\n        ivec2 sourceCeilRC = ivec2(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        float topLeft = getA(b, sourceFloorRC.x, sourceFloorRC.y, d);\n        float bottomLeft = getA(b, sourceCeilRC.x, sourceFloorRC.y, d);\n        float topRight = getA(b, sourceFloorRC.x, sourceCeilRC.y, d);\n        float bottomRight = getA(b, sourceCeilRC.x, sourceCeilRC.y, d);\n\n        vec2 fracRC = sourceFracIndexRC - vec2(sourceFloorRC);\n\n        float top = topLeft + (topRight - topLeft) * fracRC.y;\n        float bottom = bottomLeft + (bottomRight - bottomLeft) * fracRC.y;\n        float newValue = top + (bottom - top) * fracRC.x;\n\n        setOutput(newValue);\n      }\n    `}}class zL{constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n];let h;h=r?"(vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC - vec3(0.5)":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${h};\n\n        // Compute the four integer indices.\n        ivec3 sourceFloorRC = ivec3(max(sourceFracIndexRC, vec3(0.0)));\n        ivec3 sourceCeilRC = ivec3(\n          min(inputShapeRC - 1.0, ceil(sourceFracIndexRC)));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        // In parallel, construct four corners for all four components in\n        // packed 2x2 cell.\n        vec4 topLeft = vec4(\n          getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 bottomLeft = vec4(\n          getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceFloorRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceFloorRC.z, d + 1) : 0.0);\n\n        vec4 topRight = vec4(\n          getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceFloorRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceFloorRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec4 bottomRight = vec4(\n          getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d),\n          hasNextCol ? getAValue(b, sourceCeilRC.x, sourceCeilRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceCeilRC.x, sourceCeilRC.z, d + 1) : 0.0);\n\n        vec3 fracRC = sourceFracIndexRC - vec3(sourceFloorRC);\n\n        vec4 top = mix(topLeft, topRight, fracRC.yyzz);\n        vec4 bottom = mix(bottomLeft, bottomRight, fracRC.yyzz);\n        vec4 newValue = mix(top, bottom, fracRC.x);\n\n        setOutput(newValue);\n      }\n    `}}const PL={kernelName:hn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=X().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new zL(r.shape,l,u,a,i):new LL(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],"float32")}};class BL{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(startRLerp - float(winHeight / 2));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(startCLerp - float(winWidth / 2));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float dxR = float(dyR) * heightScale;\n            int topDxRIndex = int(floor(dxR));\n            int bottomDxRIndex = int(min(ceil(dxR), ${s-1}.0));\n            float dxRLerp = dxR - float(topDxRIndex);\n            float inverseDxRLerp = 1.0 - dxRLerp;\n\n            float dxC = float(dyC) * widthScale;\n            int leftDxCIndex = int(floor(dxC));\n            int rightDxCIndex = int(min(ceil(dxC), ${r-1}.0));\n            float dxCLerp = dxC - float(leftDxCIndex);\n            float inverseDxCLerp = 1.0 - dxCLerp;\n\n            if (r == topDxRIndex && c == leftDxCIndex) {\n              // topLeft\n              accumulator +=\n                getDy(b, dyR, dyC, d) * inverseDxRLerp * inverseDxCLerp;\n            }\n\n            if (r == topDxRIndex && c == rightDxCIndex) {\n              // topRight\n              accumulator += getDy(b, dyR, dyC, d) * inverseDxRLerp * dxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == leftDxCIndex) {\n              // bottomLeft\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * inverseDxCLerp;\n            }\n\n            if (r == bottomDxRIndex && c == rightDxCIndex) {\n              // bottomRight\n              accumulator += getDy(b, dyR, dyC, d) * dxRLerp * dxCLerp;\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const WL={kernelName:pn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new BL(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class VL{constructor(e,t,n,s,r){this.variableNames=["A"],this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec2(yRC) + vec2(0.5)) * effectiveInputOverOutputRatioRC, vec2(0.0))":"vec2(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec2 effectiveInputOverOutputRatioRC = vec2(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]});\n      const vec2 inputShapeRC = vec2(${i}.0, ${o}.0);\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        ivec2 yRC = coords.yz;\n\n        // Fractional source index.\n        vec2 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec2 sourceNearestRC = ivec2(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n        float newValue = getA(b, sourceNearestRC.x, sourceNearestRC.y, d);\n\n        setOutput(newValue);\n      }\n    `}}class UL{constructor(e,t,n,s,r){this.variableNames=["A"],this.packedInputs=!0,this.packedOutput=!0,this.outputShape=[];const[a,i,o,l]=e;this.outputShape=[a,t,n,l];const u=[s&&t>1?i-1:i,s&&n>1?o-1:o],c=[s&&t>1?t-1:t,s&&n>1?n-1:n],h=s?"0.5":"0.0";let p;p=r?"max((vec3(yRC) + vec3(0.5)) * effectiveInputOverOutputRatioRC, vec3(0.0))":"vec3(yRC) * effectiveInputOverOutputRatioRC",this.userCode=`\n      const vec3 effectiveInputOverOutputRatioRC = vec3(\n          ${u[0]/c[0]},\n          ${u[1]/c[1]},\n          ${u[1]/c[1]});\n      const vec3 inputShapeRC = vec3(${i}.0, ${o}.0,\n                                     ${o}.0);\n\n      float getAValue(int b, int r, int c, int d) {\n        return getChannel(getA(b, r, c, d), vec2(c, d));\n      }\n\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        // Calculate values for next column in yRC.z.\n        ivec3 yRC = coords.yzz + ivec3(0, 0, 1);\n\n        // Fractional source index.\n        vec3 sourceFracIndexRC = ${p};\n\n        // Compute the coordinators of nearest neighbor point.\n        ivec3 sourceNearestRC = ivec3(\n          min(inputShapeRC - 1.0, floor(sourceFracIndexRC + ${h})));\n\n        // Should we calculate next column and row elements in 2x2 packed cell.\n        bool hasNextCol = d < ${l-1};\n        bool hasNextRow = coords.z < ${n-1};\n\n        vec4 newValue = vec4(\n          getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d),\n          hasNextCol ? getAValue(b, sourceNearestRC.x, sourceNearestRC.y, d + 1)\n                     : 0.0,\n          hasNextRow ? getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d)\n                     : 0.0,\n          (hasNextRow && hasNextCol) ?\n            getAValue(b, sourceNearestRC.x, sourceNearestRC.z, d + 1) : 0.0);\n\n        setOutput(newValue);\n      }\n    `}}const GL={kernelName:un,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r}=t,{alignCorners:a,halfPixelCenters:i,size:o}=s,[l,u]=o,c=X().getBool("WEBGL_PACK_IMAGE_OPERATIONS")?new UL(r.shape,l,u,a,i):new VL(r.shape,l,u,a,i);return n.runWebGLProgram(c,[r],r.dtype)}};class HL{constructor(e,t,n){this.variableNames=["dy"],this.outputShape=[],this.outputShape=t;const[,s,r]=t,[,a,i]=e,o=[n&&a>1?s-1:s,n&&i>1?r-1:r],l=[n&&a>1?a-1:a,n&&i>1?i-1:i],u=o[0]/l[0],c=o[1]/l[1],h=1/u,p=1/c,d=2*Math.ceil(h)+2,f=2*Math.ceil(p)+2;this.userCode=`\n      void main() {\n        ivec4 coords = getOutputCoords();\n        int b = coords[0];\n        int d = coords[3];\n        int r = coords[1];\n        int c = coords[2];\n\n        float accumulator = 0.0;\n\n        const float heightScale = float(${u});\n        const float widthScale = float(${c});\n\n        const float invHeightScale = float(${h});\n        const float invWidthScale = float(${p});\n\n        const int winHeight = int(${d});\n        const int winWidth = int(${f});\n\n        // Compute bounds for where in dy we will look\n        float startRLerp = floor(float(r) * invHeightScale);\n        int startDyR = int(floor(startRLerp - float(winHeight / 2)));\n\n        float startCLerp = floor(float(c) * invWidthScale);\n        int startDyC = int(floor(startCLerp - float(winWidth / 2)));\n\n        // Loop over dy\n        for (int dyROffset = 0; dyROffset < winHeight; dyROffset++) {\n          int dyR = dyROffset + startDyR;\n\n          // Guard against the window exceeding the bounds of dy\n          if (dyR < 0 || dyR >= ${a}) {\n            continue;\n          }\n\n          for (int dyCOffset = 0; dyCOffset < winWidth; dyCOffset++) {\n            int dyC = dyCOffset + startDyC;\n\n            // Guard against the window exceeding the bounds of dy\n            if (dyC < 0 || dyC >= ${i}) {\n              continue;\n            }\n\n            float sourceFracRow =\n              float(${o[0]}) *\n                (float(dyR) / float(${l[0]}));\n\n            float sourceFracCol =\n                float(${o[1]}) *\n                  (float(dyC) / float(${l[1]}));\n\n            int sourceNearestRow = int(min(\n                float(int(${s}) - 1),\n                ${n} ? float(round(sourceFracRow)) :\n                                  float(floor(sourceFracRow))));\n\n            int sourceNearestCol = int(min(\n                float(int(${r}) - 1),\n                ${n} ? float(round(sourceFracCol)) :\n                                  float(floor(sourceFracCol))));\n\n            if (r == sourceNearestRow && c == sourceNearestCol) {\n              accumulator += getDy(b, dyR, dyC, d);\n            }\n          }\n        }\n        // End loop over dy\n\n        setOutput(accumulator);\n      }\n    `}}const jL={kernelName:cn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{images:r,dy:a}=t,{alignCorners:i}=s,o=new HL(a.shape,r.shape,i);return n.runWebGLProgram(o,[a],a.dtype)}};class qL{constructor(e,t){this.variableNames=["x"];const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);if(this.outputShape=e,1===n)return void(this.userCode=`\n        void main() {\n          int coord = getOutputCoords();\n          setOutput(getX(${e[0]} - coord - 1));\n        }\n      `);const s=e.map(((n,s)=>(n=>-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - coords[${n}] - 1`:`coords[${n}]`)(s))).join(","),r=ZA(n);this.userCode=`\n      void main() {\n        ${r} coords = getOutputCoords();\n        setOutput(getX(${s}));\n      }\n    `}}class KL{constructor(e,t){this.variableNames=["x"],this.packedInputs=!0,this.packedOutput=!0;const n=e.length;if(n>4)throw new Error(`WebGL backend: Reverse of rank-${n} tensor is not yet supported`);this.outputShape=e;const s=p_("rc",n),r=`${s[n-1]} + 1 < ${this.outputShape[n-1]}`,a=`${s[n-2]} + 1 < ${this.outputShape[n-2]}`,i=ZA(n);function o(n){const s=e.map(((s,r)=>function(n,s){return-1!==t.indexOf(n)&&1!==e[n]?`${e[n]} - ${s[n]} - 1`:`${s[n]}`}(r,n)));return`getChannel(getX(${s.join(",")}), vec2(${s.slice(-2).join(",")}))`}this.userCode=1===n?`\n        void main(){\n          int rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = getChannel(getX(${e[0]} - rc - 1),\n            ${e[0]} - rc - 1);\n          if(${r}){\n              result.g = getChannel(getX(${e[0]} - (rc  + 1) - 1),\n                ${e[0]} - (rc  + 1) - 1);\n          }\n          setOutput(result);\n        }\n      `:`\n        void main() {\n          ${i} rc = getOutputCoords();\n          vec4 result = vec4(0.);\n          result.r = ${function(e){return o(e)}(s.slice())};\n          if(${r}){\n            result.g = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",o(e)}(s.slice())};\n          }\n          if(${a}) {\n            result.b = ${function(e){return e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            if(${r}) {\n              result.a = ${function(e){return e[n-1]="("+e[n-1]+" + 1)",e[n-2]="("+e[n-2]+" + 1)",o(e)}(s.slice())};\n            }\n          }\n          setOutput(result);\n        }\n    `}}const XL={kernelName:fn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{x:r}=t,{dims:a}=s,i=r.shape.length,o=w(a,r.shape);if(0===i)return A_({inputs:{x:r},backend:n});const l=X().getBool("WEBGL_PACK_ARRAY_OPERATIONS")?new KL(r.shape,o):new qL(r.shape,o);return n.runWebGLProgram(l,[r],r.dtype)}};class YL{constructor(e,t){this.variableNames=["Image"],this.outputShape=[],this.customUniforms=[{name:"params",type:"vec4"}];const n=e[1],s=e[2];this.outputShape=e;let r="";r="number"==typeof t?`float outputValue = ${t.toFixed(2)};`:`\n        vec3 fill = vec3(${t.join(",")});\n        float outputValue = fill[coords[3]];`,this.userCode=`\n        void main() {\n          ivec4 coords = getOutputCoords();\n          int x = coords[2];\n          int y = coords[1];\n          float coordXFloat = (float(x) - params[0]) * params[3] -\n            (float(y) - params[1]) * params[2];\n          float coordYFloat = (float(x) - params[0]) * params[2] +\n            (float(y) - params[1]) * params[3];\n          int coordX = int(round(coordXFloat + params[0]));\n          int coordY = int(round(coordYFloat + params[1]));\n          ${r}\n          if(coordX >= 0 && coordX < ${s} && coordY >= 0 && coordY < ${n}) {\n            outputValue = getImage(coords[0], coordY, coordX, coords[3]);\n          }\n          setOutput(outputValue);\n        }\n    `}}const ZL={kernelName:ns,backendName:"webgl",kernelFunc:({inputs:e,attrs:t,backend:n})=>{const{image:s}=e,{radians:r,fillValue:a,center:i}=t,o=n,l=new YL(s.shape,a),[u,c]=od(i,s.shape[1],s.shape[2]),h=[[u,c,Math.sin(r),Math.cos(r)]];return o.runWebGLProgram(l,[s],s.dtype,h)}},JL=B_({opSnippet:"\n  // OpenGL ES does not support round function.\n  // The algorithm is based on banker's rounding.\n  float base = floor(x);\n  if ((x - base) < 0.5) {\n    return floor(x);\n  } else if ((x - base) > 0.5) {\n    return ceil(x);\n  } else {\n    if (mod(base, 2.0) == 0.0) {\n      return base;\n    } else {\n      return base + 1.0;\n    }\n  }\n"}),QL={kernelName:mn,backendName:"webgl",kernelFunc:JL},ez=B_({opSnippet:"return inversesqrt(x);",cpuKernelImpl:qR}),tz={kernelName:gn,backendName:"webgl",kernelFunc:ez};class nz{constructor(e,t,n,s,r,a,i=!0){this.variableNames=["updates","indices","defaultValue"],this.outputShape=a;const o=ZA(r.length),l=ZA(a.length);let u="";1===n?u="i":2===n&&(u="i, j");const c=`getIndices(${u})`;let h="";1===s?h="i":2===s&&(h="i, coords[1]");const p=`getUpdates(${h})`,d=t>1?"strides[j]":"strides";this.userCode=`\n        ${o} strides = ${o}(${r});\n\n        void main() {\n          ${l} coords = getOutputCoords();\n          float sum = 0.0;\n          bool found = false;\n          for (int i = 0; i < ${e}; i++) {\n            int flattenedIndex = 0;\n            for (int j = 0; j < ${t}; j++) {\n              int index = round(${c});\n              flattenedIndex += index * ${d};\n            }\n            if (flattenedIndex == coords[0]) {\n              sum += ${p};\n              found = true;\n            }\n          }\n          setOutput(mix(getDefaultValue(), sum, float(found)));\n        }\n      `}}const sz={kernelName:yn,backendName:"webgl",kernelFunc:function(e){const{inputs:t,backend:n,attrs:s}=e,{indices:r,updates:a}=t,{shape:i}=s,{sliceRank:o,numUpdates:l,sliceSize:u,strides:c,outputSize:h}=Gi(0,r,i),p=[h/u,u];if(0===h)return n.makeTensorInfo(i,r.dtype);const d=Y_({inputs:{x:r},backend:n,attrs:{shape:[l,o]}}),f=Y_({inputs:{x:a},backend:n,attrs:{shape:[l,u]}}),m=n.makeTensorInfo([],"float32",new Float32Array([0])),g=new nz(l,o,d.shape.length,f.shape.length,c,p),y=n.runWebGLProgram(g,[f,d,m],f.dtype),b=Y_({inputs:{x:y},backend:n,attrs:{shape:i}});return n.disposeIntermediateTensorInfo(d),n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(y),n.disposeIntermediateTensorInfo(m),b}};class rz{constructor(e,t,n,s){this.variableNames=["sortedSequence","values"],this.customUniforms=[{name:"numInputs",type:"int"}],this.outputShape=[e,n];const r=`for (int i = 0; i < ${Math.ceil(Math.log2(t+1))}; ++i) { if (left >= right) break;`,a=2===X().getNumber("WEBGL_VERSION")?"while (left < right) {":r,i="left"===s?"<":"<=";this.userCode=`\n       int findBound(int batch, float value) {\n         int left = 0;\n         int right = numInputs;\n         int mid;\n 