/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import*as t from"@tensorflow/tfjs-core";import{util as e,backend as n,tidy as s,tensor1d as r,serialization as i,zeros as a,ones as o,mul as l,scalar as u,randomUniform as h,truncatedNormal as c,eye as p,linalg as d,transpose as f,dispose as g,memory as m,cast as b,env as y,nextFrame as w,add as k,div as v,keep as x,train as S,clone as N,argMax as E,reshape as I,Tensor as A,Optimizer as $,io as C,sum as T,abs as z,relu as _,clipByValue as D,leakyRelu as F,prelu as M,elu as L,greater as R,any as O,notEqual as B,zerosLike as P,greaterEqual as W,moments as U}from"@tensorflow/tfjs-core";class K extends Error{constructor(t){super(t),Object.setPrototypeOf(this,K.prototype)}}class V extends Error{constructor(t){super(t),Object.setPrototypeOf(this,V.prototype)}}class q extends Error{constructor(t){super(t),Object.setPrototypeOf(this,q.prototype)}}class j extends Error{constructor(t){super(t),Object.setPrototypeOf(this,j.prototype)}}class G extends Error{constructor(t){super(t),Object.setPrototypeOf(this,G.prototype)}}class H{constructor(t){this.maxEntries=t||100,this.cache=new Map}get(t){let e;return this.cache.has(t)&&(e=this.cache.get(t),this.cache.delete(t),this.cache.set(t,e)),e}put(t,e){if(this.cache.has(t))this.cache.delete(t);else if(this.cache.size>=this.maxEntries){const t=this.cache.keys().next().value;this.cache.delete(t)}this.cache.set(t,e)}getMaxEntries(){return this.maxEntries}setMaxEntries(t){if(t<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${t}.`);if(this.maxEntries>t)for(let e=0;e<this.maxEntries-t;e++){const t=this.cache.keys().next().value;this.cache.delete(t)}this.maxEntries=t}}function J(t,e){if(Array.isArray(t)){let n=[];for(let s=0;s<e;s++)n=n.concat(t);return n}{const n=new Array(e);return n.fill(t),n}}function Z(t,e){if(!t)throw new G(e)}function Y(t,e){let n=0;for(const s of t)s===e&&n++;return n}function X(t){return 1===t.length?t[0]:t}function Q(t){return Array.isArray(t)?t:[t]}function tt(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function et(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,((t,e)=>e.toUpperCase()))}let nt={};function st(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function rt(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach((t=>rt(t)));else{const e=Object.keys(t);for(const n of e){const e=t[n];null!=e&&"object"==typeof e&&(Array.isArray(e)||"ndarray"!==e.type||"number"!=typeof e.value?rt(e):t[n]=e.value)}}}function it(t,e={},n={},s="object",r=!1){if("string"==typeof t){const r=t;let i;if(r in n)i=n[r];else if(r in nt)i=nt[r];else if(i=e[r],null==i)throw new q(`Unknown ${s}: ${t}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return i}{const i=t;if(null==i.className||null==i.config)throw new q(`${s}: Improper config format: ${JSON.stringify(i)}.\n'className' and 'config' must set.`);const a=i.className;let o,l;if(a in n?[o,l]=n[a]:a in nt?[o,l]=nt.className:a in e&&([o,l]=e[a]),null==o)throw new q(`Unknown ${s}: ${a}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=l){const t={};for(const e of Object.keys(nt))t[e]=nt[e];for(const e of Object.keys(n))t[e]=n[e];i.config.customObjects=t;const e=Object.assign({},nt);for(const t of Object.keys(n))nt[t]=n[t];rt(i.config);const s=l(o,i.config,n,r);return nt=Object.assign({},e),s}{const t=Object.assign({},nt);for(const t of Object.keys(n))nt[t]=n[t];const e=new o(i.config);return nt=Object.assign({},t),e}}}function at(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function ot(t){if(null==t)return t;const e=[];for(const n of t)-1===e.indexOf(n)&&e.push(n);return e}function lt(t){if(null==t)throw new q(`Invalid value in obj: ${JSON.stringify(t)}`);for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function ut(t,e,n){if(null!=n&&t.indexOf(n)<0)throw new q(`${n} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function ht(t,e,n=0,s=1/0){return Z(n>=0),Z(s>=n),Array.isArray(t)&&t.length>=n&&t.length<=s&&t.every((t=>typeof t===e))}function ct(t,n){Array.isArray(t)?(e.assert(t.length>0,(()=>`${n} is unexpectedly an empty array.`)),t.forEach(((t,e)=>ct(t,`element ${e+1} of ${n}`)))):e.assert(Number.isInteger(t)&&t>0,(()=>`Expected ${n} to be a positive integer, but got ${pt(t)}.`))}function pt(t){return null===t?"null":Array.isArray(t)?"["+t.map((t=>pt(t))).join(",")+"]":"string"==typeof t?`"${t}"`:`${t}`}function dt(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}let ft=0;function gt(){return ft++}const mt={};function bt(t=""){return t in mt||(mt[t]=0),mt[t]+=1,t+mt[t].toString()}const yt=["channelsFirst","channelsLast"],wt=["nearest","bilinear"],kt=["valid","same","causal"],vt=["max","avg"],xt=["sum","mul","concat","ave"],St=new Map;function Nt(t){ut(yt,"DataFormat",t)}function Et(t){ut(kt,"PaddingMode",t)}function It(t){ut(vt,"PoolMode",t)}const At=[];function $t(t,e){At.push(t);try{const t=e();return At.pop(),t}catch(t){throw At.pop(),t}}function Ct(t){if(!_t(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===At.length?"":At.join("/")+"/")+t}function Tt(t){if(!_t(t))throw new Error("Not a valid tensor name: '"+t+"'");St.has(t)||St.set(t,0);const e=St.get(t);if(St.set(t,St.get(t)+1),e>0){const n=`${t}_${e}`;return St.set(n,1),n}return t}const zt=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function _t(t){return!!t.match(zt)}function Dt(t,e,n){null==e&&(e=0),null==n&&(n=t.length);let s=1;for(let r=e;r<n;++r)s*=t[r];return s}function Ft(t){if(0===t.length)return Number.NaN;let e=Number.POSITIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s<e&&(e=s)}return e}function Mt(t){if(0===t.length)return Number.NaN;let e=Number.NEGATIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s>e&&(e=s)}return e}function Lt(t,e){if(e<t)throw new q(`end (${e}) < begin (${t}) is forbidden.`);const n=[];for(let s=t;s<e;++s)n.push(s);return n}let Rt;function Ot(){return null==Rt&&(Rt=n().epsilon()),Rt}function Bt(e,n){return t.cast(e,n)}function Pt(e,n=-1){const s=e.shape.slice();return n<0&&(n=s.length+n+1),s.splice(n,0,1),t.reshape(e,s)}function Wt(e,n,r){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:return t.slice2d(e,[n,0],[r,e.shape[1]]);case 3:return t.slice3d(e,[n,0,0],[r,e.shape[1],e.shape[2]]);case 4:return t.slice4d(e,[n,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3]]);case 5:return t.slice(e,[n,0,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3],e.shape[4]]);case 6:return t.slice(e,[n,0,0,0,0,0],[r,e.shape[1],e.shape[2],e.shape[3],e.shape[4],e.shape[5]]);default:throw new q(`sliceAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Ut(e,n,r){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:return t.slice2d(e,[0,n],[e.shape[0],r]);case 3:return t.slice3d(e,[0,0,n],[e.shape[0],e.shape[1],r]);case 4:return t.slice4d(e,[0,0,0,n],[e.shape[0],e.shape[1],e.shape[2],r]);default:throw new q(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Kt(e,n,r,i){return s((()=>{switch(e.rank){case 1:return t.slice1d(e,n,r);case 2:switch(i){case 1:return Wt(e,n,r);case 2:return Ut(e,n,r);default:throw new q(`The axis is not within the rank of the tensor ${i}`)}case 3:switch(i){case 1:return Wt(e,n,r);case 2:return t.slice3d(e,[0,n,0],[e.shape[0],r,e.shape[2]]);case 3:return Ut(e,n,r);default:throw new q(`The axis is not within the rank of the tensor ${i}`)}case 4:switch(i){case 1:return Wt(e,n,r);case 2:return t.slice4d(e,[0,n,0,0],[e.shape[0],r,e.shape[2],e.shape[3]]);case 3:return t.slice4d(e,[0,0,n,0],[e.shape[0],e.shape[1],r,e.shape[3]]);case 4:return Ut(e,n,r);default:throw new q(`The axis is not within the rank of the tensor ${i}`)}default:throw new q(`sliceAlongLastAxis() received an unsupported tensor rank: ${e.rank}`)}}))}function Vt(e,n=-1){let s;return n<0&&(s=e[0].rank,n=0!==s?s:0),n===e[0].rank&&(n=-1),t.concat(e,n)}function qt(e,n){switch(e.rank){case 1:return t.concat1d([e,n]);case 2:return t.concat2d([e,n],0);case 3:return t.concat3d([e,n],0);case 4:return t.concat4d([e,n],0);default:throw new q(`concatAlongFirstAxis() received an unsupported tensor rank: ${e.rank}`)}}function jt(e,n){if(Array.isArray(n)||(n=[n]),e.rank!==n.length)throw new q(`The length of input n (${n.length}) does not match the number of dimensions in input x (${e.rank})`);return t.tile(e,n)}function Gt(e,n=0,s=1,r,i){return t.randomNormal(e,n,s,r,i)}function Ht(e,n,s,r){if(e.rank<2||n.rank<2)throw new j(`dot requires both inputs to be rank >= 2 but got x shape = ${e.shape} and y shape = ${n.shape}`);if(n.rank>=3){if(e.shape.slice(-1)[0]!==n.shape.slice(-2)[0])throw new j(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${e.shape} and  y shape = ${n.shape}`)}if(2===e.rank&&2===n.rank){const i=!1,a=!1;return t.fused.matMul({a:e,b:n,transposeA:i,transposeB:a,bias:r?Yt(e.rank,r,"channelsLast"):null,activation:s})}{const i=e.shape.slice(),a=i.pop();e=t.reshape(e,[-1,a]);const o=n.shape.slice(),l=o.pop(),u=o.pop(),h=[...o,l],c=Array.from({length:n.rank},((t,e)=>0===e?n.rank-2:e<=n.rank-2?e-1:e));n=t.reshape(t.transpose(n,c),[u,-1]);const p=[...i,...h],d=!1,f=!1;return t.reshape(t.fused.matMul({a:e,b:n,transposeA:d,transposeB:f,bias:r?Yt(e.rank,r,"channelsLast"):null,activation:s}),p)}}function Jt(e,n,i){return s((()=>(n=Array.isArray(n)?r(n,"int32"):t.cast(n,"int32"),t.gather(e,n,i))))}function Zt(e){return t.mul(e,e)}function Yt(e,n,s){const r=n.shape;if(1!==n.rank&&n.rank!==e)throw new q(`Unexpected bias dimensions: ${n.rank}; expected it to be 1 or ${e}`);if(5===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1,1,1]):t.reshape(n,[1,r[3],r[0],r[1],r[2]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(4===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1,1]):t.reshape(n,[1,r[2],r[0],r[1]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(3===e){if("channelsFirst"===s)return 1===r.length?t.reshape(n,[1,r[0],1]):t.reshape(n,[1,r[1],r[0]]);if("channelsLast"===s)return 1===r.length?t.reshape(n,[1,1,r[0]]):t.reshape(n,[1].concat(r))}else if(e<3)return n;throw new q(`Unsupported input rank by biasAdd: ${n.rank}`)}function Xt(e,n,r){return s((()=>(null==r&&(r="channelsLast"),Nt(r),t.add(e,Yt(e.rank,n,r)))))}function Qt(e,n,r,i){return s((()=>t.dropout(e,n,r,i)))}function te(t,e,n=!1){return n?t():e()}const ee=["fanIn","fanOut","fanAvg"],ne=["normal","uniform","truncatedNormal"];class se extends i.Serializable{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class re extends se{apply(t,e){return a(t,e)}}re.className="Zeros",i.registerClass(re);class ie extends se{apply(t,e){return o(t,e)}}ie.className="Ones",i.registerClass(ie);class ae extends se{constructor(t){if(super(),"object"!=typeof t)throw new q(`Expected argument of type ConstantConfig but got ${t}`);if(void 0===t.value)throw new q(`config must have value set but got ${t}`);this.value=t.value}apply(t,e){return s((()=>l(u(this.value),o(t,e))))}getConfig(){return{value:this.value}}}ae.className="Constant",i.registerClass(ae);class oe extends se{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,e){return h(t,this.minval,this.maxval,e)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}oe.className="RandomUniform",i.registerClass(oe);class le extends se{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new j(`randomNormal does not support dType ${e}.`);return Gt(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}le.className="RandomNormal",i.registerClass(le);class ue extends se{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new j(`truncatedNormal does not support dType ${e}.`);return c(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}ue.className="TruncatedNormal",i.registerClass(ue);class he extends se{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,e){return s((()=>{if(2!==t.length||t[0]!==t[1])throw new q("Identity matrix initializer can only be used for 2D square matrices.");return l(this.gain,p(t[0]))}))}getConfig(){return{gain:this.gain}}}he.className="Identity",i.registerClass(he);class ce extends se{constructor(t){if(super(),t.scale<0)throw new q(`scale must be a positive float. Got: ${t.scale}`);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,ut(ee,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){ut(ne,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,e){const n=function(t,e="channelsLast"){let n,s;if(Nt(e),2===t.length)n=t[0],s=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=Dt(t,2);n=t[1]*e,s=t[0]*e}else if("channelsLast"===e){const e=Dt(t,0,t.length-2);n=t[t.length-2]*e,s=t[t.length-1]*e}}else{const e=Dt(t);n=Math.sqrt(e),s=Math.sqrt(e)}return[n,s]}(t),s=n[0],r=n[1];let i=this.scale;if("fanIn"===this.mode?i/=Math.max(1,s):"fanOut"===this.mode?i/=Math.max(1,r):i/=Math.max(1,(s+r)/2),"normal"===this.distribution){const n=Math.sqrt(i);if("float32"!==(e=e||"float32")&&"int32"!==e)throw new j(`${this.getClassName()} does not support dType ${e}.`);return c(t,0,n,e,this.seed)}{const n=Math.sqrt(3*i);return h(t,-n,n,e)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}ce.className="VarianceScaling",i.registerClass(ce);class pe extends ce{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return ce.className}}pe.className="GlorotUniform",i.registerClass(pe);class de extends ce{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return ce.className}}de.className="GlorotNormal",i.registerClass(de);class fe extends ce{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return ce.className}}fe.className="HeNormal",i.registerClass(fe);class ge extends ce{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return ce.className}}ge.className="HeUniform",i.registerClass(ge);class me extends ce{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return ce.className}}me.className="LeCunNormal",i.registerClass(me);class be extends ce{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return ce.className}}be.className="LeCunNormal",i.registerClass(be);class ye extends se{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new j("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,e){return s((()=>{if(t.length<2)throw new j("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const e=Gt(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let n=d.gramSchmidt(e);return t[0]>t[1]&&(n=f(n)),l(this.gain,n)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}ye.className="Orthogonal",i.registerClass(ye);const we={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function ke(t,e={}){return it(t,i.SerializationMap.getMap().classNameMap,e,"initializer")}function ve(t){return st(t)}function xe(t){if("string"==typeof t){const e=t in we?we[t]:t;if("GlorotNormal"===e)return new de;if("GlorotUniform"===e)return new pe;if("HeNormal"===e)return new fe;if("HeUniform"===e)return new ge;if("LeCunNormal"===e)return new me;if("LeCunUniform"===e)return new be;{const t={};return t.className=e,t.config={},ke(t)}}return t instanceof se?t:ke(t)}function Se(t){return Array.isArray(t)&&Array.isArray(t[0])}function Ne(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function Ee(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new q(`Expected Tensor length to be 1; got ${t.length}`);e=t[0]}else e=t;return e}function Ie(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return t[0];throw new q(`Expected exactly 1 Shape; got ${t.length}`)}return t}function Ae(t){let e=0;for(const n of t)0===n.shape.length?e+=1:e+=n.shape.reduce(((t,e)=>t*e));return e}class $e{constructor(e,n="float32",s="Variable",r=!0,i=null){this.dtype=null==n?"float32":n,this.shape=e.shape,this.id=gt(),s=null==s?"Variable":s,this.originalName=Ct(s),this.name=Tt(this.originalName),this.trainable_=r,this.constraint=i,this.val=t.variable(e,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function Ce(t){return t.map((t=>t.read()))}function Te(t){t.forEach((t=>{t[0].write(t[1])}))}class ze{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class _e{constructor(t,e,n,s,r,i,a){this.dtype=t,this.shape=e,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=a,this.id=gt(),null!=i&&(this.originalName=Ct(i),this.name=Tt(this.originalName)),this.rank=e.length}}let De=0;class Fe{constructor(t,e){this.callArgs=e,this.id=De++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Me=0;class Le extends i.Serializable{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Me++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=tt(t)+"_"+bt(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let n=null;null!=t.batchSize&&(n=t.batchSize),e=[n].concat(t.inputShape)}this.batchInputShape=e;let n=t.dtype;null==n&&(n=t.inputDType),null==n&&(n="float32"),this.dtype=n}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new V(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new q(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return X(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return X(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new K(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new K(`Layer ${this.name} is not connected, no input to return.`);return X(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new K(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new K(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return X(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((t=>t()))}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach((e=>e.trainable=t)),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((t=>t.trainable)):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((t=>!t.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=Q(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=Q(this.inputSpec);if(t.length!==e.length)throw new q(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: ${t}`);for(let n=0;n<t.length;n++){const s=t[n],r=e[n];if(null==r)continue;const i=s.rank;if(null!=r.ndim&&i!==r.ndim)throw new q(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${i}`);if(null!=r.maxNDim&&i>r.maxNDim)throw new q(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${i}`);if(null!=r.minNDim&&i<r.minNDim)throw new q(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${i}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new q(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const e in r.axes){const s=Number(e),i=r.axes[e],a=s>=0?t[s]:t[t.length+s];if(null!=i&&-1===[i,null].indexOf(a))throw new q(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${i} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const e=r.shape[t],i=s.shape[t];if(null!=e&&null!=i&&e!==i)throw new q(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const n=Q(t);let s=!0;for(const t of n)if(!(t instanceof _e)){s=!1;break}let r=!0;for(const t of n)if(t instanceof _e){r=!1;break}if(s===r)throw new q("Arguments to apply() must be all SymbolicTensors or all Tensors");return $t(this.name,(()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const n of Q(t))e.push(n.shape);this.build(X(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(t),r){let s=this.call(t,e);const r=Q(s),i=[];for(let t of r)-1!==n.indexOf(t)&&(t=t.clone()),i.push(t);if(s=X(i),null!=this.activityRegularizer)throw new j("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(t){t=Q(t);const e=[];for(const n of t)e.push(n.shape);return X(e)}(t),s=this.computeOutputShape(n);let r;const i="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new _e(i,n,this,Q(t),e,this.name,s))):new _e(i,s,this,Q(t),e,this.name),this.addInboundNode(t,r,null,null,n,s,e),this._refCount++,null!=this.activityRegularizer)throw new j("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(t)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let e=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=t[s]&&t[s]!==n&&(e=!0)})),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new K(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const n=JSON.stringify(e.outputShapes);-1===t.indexOf(n)&&t.push(n)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new K(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new V(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return Ae(this.weights)}build(t){this.built=!0}getWeights(t=!1){return Ce(t?this.trainableWeights:this.weights)}setWeights(t){s((()=>{const n=this.weights;if(n.length!==t.length)throw new q(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${n.length} weights. Provided weights: ${t}...`);if(0===n.length)return;const s=[],r=Ce(n);for(let i=0;i<r.length;++i){const a=r[i],o=n[i],l=t[i];if(!e.arraysEqual(a.shape,l.shape))throw new q(`Layer weight shape ${a.shape} not compatible with provided weight shape ${l.shape}`);s.push([o,l])}Te(s)}))}addWeight(t,e,n,s,r,i,a,o){if(-1!==this._addedWeightNames.indexOf(t))throw new q(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=o?o():xe("zeros"));const l=s.apply(e,n),u=new $e(l,n,t,i,a);return l.dispose(),null!=r&&this.addLoss((()=>r.apply(u.read()))),null==i&&(i=!0),i?this._trainableWeights.push(u):this._nonTrainableWeights.push(u),u}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=Q(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach((t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return e}addInboundNode(t,e,n,s,r,i,a=null){const o=Q(t);e=Q(e),n=Q(n),s=Q(s),r=Ne(r),i=Ne(i);const l=[],u=[],h=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),h.push(t.tensorIndex);new Fe({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:h,inputTensors:o,outputTensors:e,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:i},a);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach((t=>t.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}function Re(t,e,n){if((null==e||null!=n&&n>0)&&(e=t.sourceLayer,n=t.nodeIndex),0===e.inboundNodes.length)return[t];{const t=e.inboundNodes[n];if(0===t.inboundLayers.length)return t.inputTensors;{const e=[];for(let n=0;n<t.inboundLayers.length;n++){const s=Re(t.inputTensors[n],t.inboundLayers[n],t.nodeIndices[n]);for(const t of s)-1===e.indexOf(t)&&e.push(t)}return e}}}class Oe extends Le{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:bt("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new q("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new q("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new q("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=t.dtype||"float32";this.batchInputShape=e,this.dtype=n,this.inputSpec=[{shape:e}];const s=new _e(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Fe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new q(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function Be(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new q("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let n=t.dtype;null==n&&(n="float32");return new Oe({batchInputShape:e,name:t.name,dtype:n,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}Oe.className="InputLayer",i.registerClass(Oe);class Pe{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof Pe)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,e,n){if(null!=this.id2Value[t.id])throw new q(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,e){if(null==t.dtype||t.dtype===e.dtype)return e;try{return b(e,t.dtype)}catch(n){throw new q(`The dtype of the feed (${e.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,e),this.name2Id[t.name]=t.id,null!=n&&(this.id2Mask[t.id]=n),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof _e){if(null==this.id2Value[t.id])throw new q(`Nonexistent key: ${t.name}`);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new q(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Value[e]}}getMask(t){if(t instanceof _e){if(null==this.id2Value[t.id])throw new q(`Nonexistent key: ${t.name}`);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new q(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&g(this.id2Mask)}}const We=new H,Ue=new H;function Ke(t,n,s,r){const i=null!=s&&s.training,a=Array.isArray(t),o=a?t:[t],l=o.map((t=>t.name)),u=[],h=n.names();for(const t of l)-1!==h.indexOf(t)?u.push(n.getValue(t)):u.push(null);null!=r&&(r.maxNumTensors=-1/0,r.minNumTensors=1/0);const c=l.join(",")+"|"+n.names().sort().join(",");let p,d=We.get(c);if(null==d){const t=function(t,n){e.assert(null!=t&&t.length>0,(()=>"Expected at least one fetch, got none"));let s=[],r={};if(1===t.length){const e=qe(t[0],n);s=e.sorted,r=e.recipientMap}else{const e=new Set;for(const i of t){const{sorted:t,recipientMap:a}=qe(i,n);for(const n of t)e.has(n.name)||(s.push(n),e.add(n.name));for(const t in a)null==r[t]&&(r[t]=new Set),a[t].forEach((e=>r[t].add(e)))}}return{sorted:s,recipientCounts:Ve(r)}}(o,n);d=t.sorted,p=t.recipientCounts,We.put(c,d),Ue.put(c,p)}p={},i||Object.assign(p,Ue.get(c));const f=new Pe(n);for(let t=0;t<d.length;++t){if(null!=r){const t=m().numTensors;t>r.maxNumTensors&&(r.maxNumTensors=t),t<r.minNumTensors&&(r.minNumTensors=t)}const e=d[t],a=e.sourceLayer;if(a instanceof Oe)continue;const o=[],h=[],c=[];let b=!1;for(const t of e.inputs){const e=f.getValue(t),s=f.getMask(t);o.push(e),h.push(s),null!=s&&(b=!0),i||(p[t.name]--,0!==p[t.name]||n.hasKey(t)||-1!==l.indexOf(t.name)||e.isDisposed||!0===t.sourceLayer.stateful||c.push(e))}b&&((s=s||{}).mask=h[0]);const y=Q(a.apply(o,s));let w=null;a.supportsMasking&&(w=a.computeMask(o,h));const k=je(e),v=Array.isArray(k)?k:[k];for(let t=0;t<v.length;++t){f.hasKey(v[t])||f.add(v[t],y[t],Array.isArray(w)?w[0]:w);const e=l.indexOf(v[t].name);-1!==e&&(u[e]=y[t])}i||g(c)}return f.disposeMasks(),a?u:u[0]}function Ve(t){const e={};for(const n in t)e[n]=t[n].size;return e}function qe(t,e){const n=new Set,s=[],r={};for(const t of e.names())n.add(t);const i=[],a=[];for(i.push(t);i.length>0;){const t=i[i.length-1];if(n.has(t.name)){i.pop();continue}const e=a[a.length-1]===i.length-1;if(0===t.inputs.length||e)i.pop(),s.push(t),n.add(t.name),e&&a.pop();else{a.push(i.length-1);for(const e of t.inputs)null==r[e.name]&&(r[e.name]=new Set),r[e.name].add(t.name),n.has(e.name)||i.push(e)}}return{sorted:s,recipientMap:r}}function je(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let n=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const s of t.sourceLayer.inboundNodes[e].outputTensors)if(s.id===t.id){n=e;break}e=t.sourceLayer.getOutputAt(n)}return e}y().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(t){null!=We&&We.setMaxEntries(t),null!=Ue&&Ue.setMaxEntries(t)}));function Ge(t){throw new Error(`'${t}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function He(t,e){if(!t)throw new Error("string"==typeof e?e:e())}function Je(t,e,n=""){He(Qe(t,e),(()=>n+` Shapes ${t} and ${e} must match`))}function Ze(t){He(null!=t,(()=>"The input to the tensor constructor must be a non-null value."))}function Ye(t,e=[],n=!1){if(null==e&&(e=[]),Array.isArray(t)||sn(t)&&!n)for(let s=0;s<t.length;++s)Ye(t[s],e,n);else e.push(t);return e}function Xe(t){if(0===t.length)return 1;let e=t[0];for(let n=1;n<t.length;n++)e*=t[n];return e}function Qe(t,e){if(t===e)return!0;if(null==t||null==e)return!1;if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(t[n]!==e[n])return!1;return!0}function tn(t){return t%1==0}function en(t,e){return e<=t.length?t:t+" ".repeat(e-t.length)}function nn(t,e){const n=e.length;return He((t=null==t?e.map(((t,e)=>e)):[].concat(t)).every((t=>t>=-n&&t<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${t}`)),He(t.every((t=>tn(t))),(()=>`All values in axis param must be integers but got axis ${t}`)),t.map((t=>t<0?n+t:t))}function sn(t){return t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray}function rn(t){if("float32"===t||"int32"===t)return 4;if("complex64"===t)return 8;if("bool"===t)return 1;throw new Error(`Unknown dtype ${t}`)}function an(t){return"string"==typeof t||t instanceof String}function on(t){return Array.isArray(t)?on(t[0]):t instanceof Float32Array?"float32":t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray?"int32":"number"==typeof t?"float32":an(t)?"string":function(t){return"boolean"==typeof t}(t)?"bool":"float32"}function ln(t){return!!(t&&t.constructor&&t.call&&t.apply)}function un(t){const e=t.length;if(e<2)return[];const n=new Array(e-1);n[e-2]=t[e-1];for(let s=e-3;s>=0;--s)n[s]=n[s+1]*t[s+1];return n}function hn(t,e,n,s=!1){const r=new Array;if(1===e.length){const i=e[0]*(s?2:1);for(let e=0;e<i;e++)r[e]=n[t+e]}else{const i=e[0],a=e.slice(1),o=a.reduce(((t,e)=>t*e))*(s?2:1);for(let e=0;e<i;e++)r[e]=hn(t+e*o,a,n,s)}return r}function cn(t,e,n=!1){if(0===t.length)return e[0];const s=t.reduce(((t,e)=>t*e))*(n?2:1);if(0===s)return[];if(s!==e.length)throw new Error(`[${t}] does not match the input size ${e.length}${n?" for a complex tensor":""}.`);return hn(0,t,e,n)}function pn(t,e){const n=dn(t,e);for(let t=0;t<n.length;t++)n[t]=1;return n}function dn(t,e){if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e)return new Uint8Array(t);throw new Error(`Unknown data type ${e}`)}function fn(t){t.forEach((e=>{He(Number.isInteger(e)&&e>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${t}].`))}))}function gn(t){return t&&t.then&&"function"==typeof t.then}class mn{constructor(t){this.global=t,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=bn,this.populateURLFlags()}setPlatform(t,e){null!=this.platform&&(yn().getBool("IS_TEST")||yn().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=t,this.platform=e}registerFlag(t,e,n){if(this.flagRegistry[t]={evaluationFn:e,setHook:n},null!=this.urlFlags[t]){const e=this.urlFlags[t];yn().getBool("IS_TEST")||yn().getBool("PROD")||console.warn(`Setting feature override from URL ${t}: ${e}.`),this.set(t,e)}}async getAsync(t){return t in this.flags||(this.flags[t]=await this.evaluateFlag(t)),this.flags[t]}get(t){if(t in this.flags)return this.flags[t];const e=this.evaluateFlag(t);if(gn(e))throw new Error(`Flag ${t} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[t]=e,this.flags[t]}getNumber(t){return this.get(t)}getBool(t){return this.get(t)}getFlags(){return this.flags}get features(){return this.flags}set(t,e){if(null==this.flagRegistry[t])throw new Error(`Cannot set flag ${t} as it has not been registered.`);this.flags[t]=e,null!=this.flagRegistry[t].setHook&&this.flagRegistry[t].setHook(e)}evaluateFlag(t){if(null==this.flagRegistry[t])throw new Error(`Cannot evaluate flag '${t}': no evaluation function found.`);return this.flagRegistry[t].evaluationFn()}setFlags(t){this.flags=Object.assign({},t)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const t=this.getQueryParams(this.global.location.search);if("tfjsflags"in t){t.tfjsflags.split(",").forEach((t=>{const[e,n]=t.split(":");this.urlFlags[e]=function(t,e){if("true"===(e=e.toLowerCase())||"false"===e)return"true"===e;if(""+ +e===e)return+e;throw new Error(`Could not parse value flag value ${e} for flag ${t}.`)}(e,n)}))}}}function bn(t){const e={};return t.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((t,...n)=>(function(t,e,n){t[decodeURIComponent(e)]=decodeURIComponent(n||"")}(e,n[0],n[1]),n.join("=")))),e}function yn(){return kn}let wn,kn=null;function vn(){if(null==wn){let t;if("undefined"!=typeof window)t=window;else if("undefined"!=typeof global)t=global;else if("undefined"!=typeof process)t=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");t=self}wn=t}return wn}function xn(t,e){const n=function(){const t=vn();return null==t._tfGlobals&&(t._tfGlobals=new Map),t._tfGlobals}();if(n.has(t))return n.get(t);{const s=e();return n.set(t,s),n.get(t)}}function Sn(...t){yn().getBool("IS_TEST")||yn().getBool("PROD")||console.warn(...t)}const Nn=xn("kernelRegistry",(()=>new Map)),En=xn("gradRegistry",(()=>new Map));function In(t,e){const n=function(t,e){return`${e}_${t}`}(t,e);return Nn.get(n)}function An(t){return En.get(t)}function $n(t){const e=Nn.entries(),n=[];for(;;){const{done:s,value:r}=e.next();if(s)break;const[i,a]=r,[o]=i.split("_");o===t&&n.push(a)}return n}function Cn(t){const{kernelName:e}=t;En.has(e)&&yn().getBool("DEBUG")&&Sn(`Overriding the gradient for '${e}'`),En.set(e,t)}var Tn=_n,zn=null;try{zn=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(t){}function _n(t,e,n){this.low=0|t,this.high=0|e,this.unsigned=!!n}function Dn(t){return!0===(t&&t.__isLong__)}_n.prototype.__isLong__,Object.defineProperty(_n.prototype,"__isLong__",{value:!0}),_n.isLong=Dn;var Fn={},Mn={};function Ln(t,e){var n,s,r;return e?(r=0<=(t>>>=0)&&t<256)&&(s=Mn[t])?s:(n=On(t,(0|t)<0?-1:0,!0),r&&(Mn[t]=n),n):(r=-128<=(t|=0)&&t<128)&&(s=Fn[t])?s:(n=On(t,t<0?-1:0,!1),r&&(Fn[t]=n),n)}function Rn(t,e){if(isNaN(t))return e?Gn:jn;if(e){if(t<0)return Gn;if(t>=Kn)return Xn}else{if(t<=-Vn)return Qn;if(t+1>=Vn)return Yn}return t<0?Rn(-t,e).neg():On(t%Un|0,t/Un|0,e)}function On(t,e,n){return new _n(t,e,n)}_n.fromInt=Ln,_n.fromNumber=Rn,_n.fromBits=On;var Bn=Math.pow;function Pn(t,e,n){if(0===t.length)throw Error("empty string");if("NaN"===t||"Infinity"===t||"+Infinity"===t||"-Infinity"===t)return jn;if("number"==typeof e?(n=e,e=!1):e=!!e,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=t.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return Pn(t.substring(1),e,n).neg();for(var r=Rn(Bn(n,8)),i=jn,a=0;a<t.length;a+=8){var o=Math.min(8,t.length-a),l=parseInt(t.substring(a,a+o),n);if(o<8){var u=Rn(Bn(n,o));i=i.mul(u).add(Rn(l))}else i=(i=i.mul(r)).add(Rn(l))}return i.unsigned=e,i}function Wn(t,e){return"number"==typeof t?Rn(t,e):"string"==typeof t?Pn(t,e):On(t.low,t.high,"boolean"==typeof e?e:t.unsigned)}_n.fromString=Pn,_n.fromValue=Wn;var Un=4294967296,Kn=Un*Un,Vn=Kn/2,qn=Ln(1<<24),jn=Ln(0);_n.ZERO=jn;var Gn=Ln(0,!0);_n.UZERO=Gn;var Hn=Ln(1);_n.ONE=Hn;var Jn=Ln(1,!0);_n.UONE=Jn;var Zn=Ln(-1);_n.NEG_ONE=Zn;var Yn=On(-1,2147483647,!1);_n.MAX_VALUE=Yn;var Xn=On(-1,-1,!0);_n.MAX_UNSIGNED_VALUE=Xn;var Qn=On(0,-2147483648,!1);_n.MIN_VALUE=Qn;var ts=_n.prototype;ts.toInt=function(){return this.unsigned?this.low>>>0:this.low},ts.toNumber=function(){return this.unsigned?(this.high>>>0)*Un+(this.low>>>0):this.high*Un+(this.low>>>0)},ts.toString=function(t){if((t=t||10)<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Qn)){var e=Rn(t),n=this.div(e),s=n.mul(e).sub(this);return n.toString(t)+s.toInt().toString(t)}return"-"+this.neg().toString(t)}for(var r=Rn(Bn(t,6),this.unsigned),i=this,a="";;){var o=i.div(r),l=(i.sub(o.mul(r)).toInt()>>>0).toString(t);if((i=o).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},ts.getHighBits=function(){return this.high},ts.getHighBitsUnsigned=function(){return this.high>>>0},ts.getLowBits=function(){return this.low},ts.getLowBitsUnsigned=function(){return this.low>>>0},ts.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Qn)?64:this.neg().getNumBitsAbs();for(var t=0!=this.high?this.high:this.low,e=31;e>0&&0==(t&1<<e);e--);return 0!=this.high?e+33:e+1},ts.isZero=function(){return 0===this.high&&0===this.low},ts.eqz=ts.isZero,ts.isNegative=function(){return!this.unsigned&&this.high<0},ts.isPositive=function(){return this.unsigned||this.high>=0},ts.isOdd=function(){return 1==(1&this.low)},ts.isEven=function(){return 0==(1&this.low)},ts.equals=function(t){return Dn(t)||(t=Wn(t)),(this.unsigned===t.unsigned||this.high>>>31!=1||t.high>>>31!=1)&&(this.high===t.high&&this.low===t.low)},ts.eq=ts.equals,ts.notEquals=function(t){return!this.eq(t)},ts.neq=ts.notEquals,ts.ne=ts.notEquals,ts.lessThan=function(t){return this.comp(t)<0},ts.lt=ts.lessThan,ts.lessThanOrEqual=function(t){return this.comp(t)<=0},ts.lte=ts.lessThanOrEqual,ts.le=ts.lessThanOrEqual,ts.greaterThan=function(t){return this.comp(t)>0},ts.gt=ts.greaterThan,ts.greaterThanOrEqual=function(t){return this.comp(t)>=0},ts.gte=ts.greaterThanOrEqual,ts.ge=ts.greaterThanOrEqual,ts.compare=function(t){if(Dn(t)||(t=Wn(t)),this.eq(t))return 0;var e=this.isNegative(),n=t.isNegative();return e&&!n?-1:!e&&n?1:this.unsigned?t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1:this.sub(t).isNegative()?-1:1},ts.comp=ts.compare,ts.negate=function(){return!this.unsigned&&this.eq(Qn)?Qn:this.not().add(Hn)},ts.neg=ts.negate,ts.add=function(t){Dn(t)||(t=Wn(t));var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=0,u=0,h=0,c=0;return h+=(c+=r+(65535&t.low))>>>16,u+=(h+=s+o)>>>16,l+=(u+=n+a)>>>16,l+=e+i,On((h&=65535)<<16|(c&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},ts.subtract=function(t){return Dn(t)||(t=Wn(t)),this.add(t.neg())},ts.sub=ts.subtract,ts.multiply=function(t){if(this.isZero())return jn;if(Dn(t)||(t=Wn(t)),zn)return On(zn.mul(this.low,this.high,t.low,t.high),zn.get_high(),this.unsigned);if(t.isZero())return jn;if(this.eq(Qn))return t.isOdd()?Qn:jn;if(t.eq(Qn))return this.isOdd()?Qn:jn;if(this.isNegative())return t.isNegative()?this.neg().mul(t.neg()):this.neg().mul(t).neg();if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(qn)&&t.lt(qn))return Rn(this.toNumber()*t.toNumber(),this.unsigned);var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=65535&t.low,u=0,h=0,c=0,p=0;return c+=(p+=r*l)>>>16,h+=(c+=s*l)>>>16,c&=65535,h+=(c+=r*o)>>>16,u+=(h+=n*l)>>>16,h&=65535,u+=(h+=s*o)>>>16,h&=65535,u+=(h+=r*a)>>>16,u+=e*l+n*o+s*a+r*i,On((c&=65535)<<16|(p&=65535),(u&=65535)<<16|(h&=65535),this.unsigned)},ts.mul=ts.multiply,ts.divide=function(t){if(Dn(t)||(t=Wn(t)),t.isZero())throw Error("division by zero");var e,n,s;if(zn)return this.unsigned||-2147483648!==this.high||-1!==t.low||-1!==t.high?On((this.unsigned?zn.div_u:zn.div_s)(this.low,this.high,t.low,t.high),zn.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Gn:jn;if(this.unsigned){if(t.unsigned||(t=t.toUnsigned()),t.gt(this))return Gn;if(t.gt(this.shru(1)))return Jn;s=Gn}else{if(this.eq(Qn))return t.eq(Hn)||t.eq(Zn)?Qn:t.eq(Qn)?Hn:(e=this.shr(1).div(t).shl(1)).eq(jn)?t.isNegative()?Hn:Zn:(n=this.sub(t.mul(e)),s=e.add(n.div(t)));if(t.eq(Qn))return this.unsigned?Gn:jn;if(this.isNegative())return t.isNegative()?this.neg().div(t.neg()):this.neg().div(t).neg();if(t.isNegative())return this.div(t.neg()).neg();s=jn}for(n=this;n.gte(t);){e=Math.max(1,Math.floor(n.toNumber()/t.toNumber()));for(var r=Math.ceil(Math.log(e)/Math.LN2),i=r<=48?1:Bn(2,r-48),a=Rn(e),o=a.mul(t);o.isNegative()||o.gt(n);)o=(a=Rn(e-=i,this.unsigned)).mul(t);a.isZero()&&(a=Hn),s=s.add(a),n=n.sub(o)}return s},ts.div=ts.divide,ts.modulo=function(t){return Dn(t)||(t=Wn(t)),zn?On((this.unsigned?zn.rem_u:zn.rem_s)(this.low,this.high,t.low,t.high),zn.get_high(),this.unsigned):this.sub(this.div(t).mul(t))},ts.mod=ts.modulo,ts.rem=ts.modulo,ts.not=function(){return On(~this.low,~this.high,this.unsigned)},ts.and=function(t){return Dn(t)||(t=Wn(t)),On(this.low&t.low,this.high&t.high,this.unsigned)},ts.or=function(t){return Dn(t)||(t=Wn(t)),On(this.low|t.low,this.high|t.high,this.unsigned)},ts.xor=function(t){return Dn(t)||(t=Wn(t)),On(this.low^t.low,this.high^t.high,this.unsigned)},ts.shiftLeft=function(t){return Dn(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?On(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned):On(0,this.low<<t-32,this.unsigned)},ts.shl=ts.shiftLeft,ts.shiftRight=function(t){return Dn(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?On(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned):On(this.high>>t-32,this.high>=0?0:-1,this.unsigned)},ts.shr=ts.shiftRight,ts.shiftRightUnsigned=function(t){if(Dn(t)&&(t=t.toInt()),0===(t&=63))return this;var e=this.high;return t<32?On(this.low>>>t|e<<32-t,e>>>t,this.unsigned):On(32===t?e:e>>>t-32,0,this.unsigned)},ts.shru=ts.shiftRightUnsigned,ts.shr_u=ts.shiftRightUnsigned,ts.toSigned=function(){return this.unsigned?On(this.low,this.high,!1):this},ts.toUnsigned=function(){return this.unsigned?this:On(this.low,this.high,!0)},ts.toBytes=function(t){return t?this.toBytesLE():this.toBytesBE()},ts.toBytesLE=function(){var t=this.high,e=this.low;return[255&e,e>>>8&255,e>>>16&255,e>>>24,255&t,t>>>8&255,t>>>16&255,t>>>24]},ts.toBytesBE=function(){var t=this.high,e=this.low;return[t>>>24,t>>>16&255,t>>>8&255,255&t,e>>>24,e>>>16&255,e>>>8&255,255&e]},_n.fromBytes=function(t,e,n){return n?_n.fromBytesLE(t,e):_n.fromBytesBE(t,e)},_n.fromBytesLE=function(t,e){return new _n(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,e)},_n.fromBytesBE=function(t,e){return new _n(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],e)};const es=Tn||Object.assign(Object.create(null),Tn,{default:Tn});function ns(t){return es.fromString(t,!0,16)}function ss(t,e){if("string"===e)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(t)&&(t=Ye(t)),yn().getBool("DEBUG")&&function(t,e){for(let n=0;n<t.length;n++){const s=t[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${e} being uploaded contains ${s}.`)}}(t,e),function(t,e){return t instanceof Float32Array&&"float32"===e||t instanceof Int32Array&&"int32"===e||t instanceof Uint8Array&&"bool"===e}(t,e))return t;if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e){const e=new Uint8Array(t.length);for(let n=0;n<e.length;++n)0!==Math.round(t[n])&&(e[n]=1);return e}throw new Error(`Unknown data type ${e}`)}function rs(){return yn().platform.now()}function is(t,e="utf-8"){return e=e||"utf-8",yn().platform.decode(t,e)}ns("c3a5c85c97cb3127"),ns("b492b66fbe98f273"),ns("9ae16a3b2f90404f");class as{constructor(t,e){this.backendTimer=t,this.logger=e,null==e&&(this.logger=new ls)}profileKernel(t,e,n){let s;const r=()=>{s=n()};let i;const a=rs();if(this.backendTimer.timerAvailable())i=this.backendTimer.time(r);else{r();for(const t of s)t.dataSync();i=Promise.resolve({kernelMs:rs()-a})}if(yn().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let e=0;e<s.length;e++){const n=s[e];n.data().then((e=>{os(e,n.dtype,t)}))}return{kernelName:t,outputs:s,inputs:e,timeMs:i.then((t=>t.kernelMs)),extraInfo:i.then((t=>null!=t.getExtraProfileInfo?t.getExtraProfileInfo():""))}}logKernelProfile(t){const{kernelName:e,outputs:n,timeMs:s,inputs:r,extraInfo:i}=t;n.forEach((t=>{Promise.all([t.data(),s,i]).then((n=>{this.logger.logKernelProfile(e,t,n[0],n[1],r,n[2])}))}))}}function os(t,e,n){if("float32"!==e)return!1;for(let e=0;e<t.length;e++){const s=t[e];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class ls{logKernelProfile(t,e,n,s,r,i){const a="number"==typeof s?en(`${s}ms`,9):s.error,o=en(t,25),l=e.rank,u=e.size,h=en(e.shape.toString(),14);let c="";for(const t in r){const n=r[t];if(null!=n){const s=n.shape||e.shape,r=s.length;c+=`${t}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${a}\t%c${l}D ${h}\t%c${u}\t%c${c}\t%c${i}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function us(t,e,n,s){const r=un(e),i=function(t,e,n,s){const r=Xe(e),i=s[s.length-1],a=new Array(i).fill(0),o=e.length,l="complex64"===n?ds(t):t;if(o>1)for(let t=0;t<r/i;t++){const e=t*i;for(let t=0;t<i;t++)a[t]=Math.max(a[t],hs(l[e+t],0,n).length)}return a}(t,e,n,r),a=e.length,o=ps(t,e,n,r,i),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${e}]`),l.push("  values:")),l.push(o.map((t=>"    "+t)).join("\n")),l.join("\n")}function hs(t,e,n){let s;return s=Array.isArray(t)?`${parseFloat(t[0].toFixed(7))} + ${parseFloat(t[1].toFixed(7))}j`:an(t)?`'${t}'`:"bool"===n?cs(t):parseFloat(t.toFixed(7)).toString(),en(s,e)}function cs(t){return 0===t?"false":"true"}function ps(t,e,n,s,r,i=!0){const a="complex64"===n?2:1,o=e[0],l=e.length;if(0===l){if("complex64"===n){return[hs(ds(t)[0],0,n)]}return"bool"===n?[cs(t[0])]:[t[0].toString()]}if(1===l){if(o>20){const e=3*a;let s=Array.from(t.slice(0,e)),i=Array.from(t.slice((o-3)*a,o*a));return"complex64"===n&&(s=ds(s),i=ds(i)),["["+s.map(((t,e)=>hs(t,r[e],n))).join(", ")+", ..., "+i.map(((t,e)=>hs(t,r[o-3+e],n))).join(", ")+"]"]}return["["+("complex64"===n?ds(t):Array.from(t)).map(((t,e)=>hs(t,r[e],n))).join(", ")+"]"]}const u=e.slice(1),h=s.slice(1),c=s[0]*a,p=[];if(o>20){for(let e=0;e<3;e++){const s=e*c,i=s+c;p.push(...ps(t.slice(s,i),u,n,h,r,!1))}p.push("...");for(let e=o-3;e<o;e++){const s=e*c,i=s+c;p.push(...ps(t.slice(s,i),u,n,h,r,e===o-1))}}else for(let e=0;e<o;e++){const s=e*c,i=s+c;p.push(...ps(t.slice(s,i),u,n,h,r,e===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let t=1;t<p.length-1;t++)p[t]=" "+p[t]+d;let f=",\n";for(let t=2;t<l;t++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(i?"":f),p}function ds(t){const e=[];for(let n=0;n<t.length;n+=2)e.push([t[n],t[n+1]]);return e}class fs{constructor(t,e,n){if(this.dtype=e,this.shape=t.slice(),this.size=Xe(t),null!=n){const t=n.length;He(t===this.size,(()=>`Length of values '${t}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===e)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else if("bool"===t)n=new Uint8Array(e);else{if("string"!==t)throw new Error(`Unknown data type ${t}`);n=new Array(e)}return n}(e,this.size),this.strides=un(t)}set(t,...e){0===e.length&&(e=[0]),He(e.length===this.rank,(()=>`The number of provided coordinates (${e.length}) must match the rank (${this.rank})`));const n=this.locToIndex(e);this.values[n]=t}get(...t){0===t.length&&(t=[0]);let e=0;for(const n of t){if(n<0||n>=this.shape[e]){const e=`Requested out of range element at ${t}.   Buffer shape=${this.shape}`;throw new Error(e)}e++}let n=t[t.length-1];for(let e=0;e<t.length-1;++e)n+=this.strides[e]*t[e];return this.values[n]}locToIndex(t){if(0===this.rank)return 0;if(1===this.rank)return t[0];let e=t[t.length-1];for(let n=0;n<t.length-1;++n)e+=this.strides[n]*t[n];return e}indexToLoc(t){if(0===this.rank)return[];if(1===this.rank)return[t];const e=new Array(this.shape.length);for(let n=0;n<e.length-1;++n)e[n]=Math.floor(t/this.strides[n]),t-=e[n]*this.strides[n];return e[e.length-1]=t,e}get rank(){return this.shape.length}toTensor(){return gs().makeTensor(this.values,this.shape,this.dtype)}}let gs=null;class ms{constructor(t,e,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=t.slice(),this.dtype=e||"float32",this.size=Xe(t),this.strides=un(t),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const t=await this.data();return null.buffer(this.shape,this.dtype,t)}bufferSync(){return null.buffer(this.shape,this.dtype,this.dataSync())}async array(){const t=await this.data();return cn(this.shape,t,"complex64"===this.dtype)}arraySync(){return cn(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const t=gs().read(this.dataId);if("string"===this.dtype){const e=await t;try{return e.map((t=>is(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return t}dataToGPU(t){return this.throwIfDisposed(),gs().readToGPU(this.dataId,t)}dataSync(){this.throwIfDisposed();const t=gs().readSync(this.dataId);if("string"===this.dtype)try{return t.map((t=>is(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return t}async bytes(){this.throwIfDisposed();const t=await gs().read(this.dataId);return"string"===this.dtype?t:new Uint8Array(t.buffer)}dispose(){this.isDisposed||(gs().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(t=!1){return null.print(this,t)}clone(){return this.throwIfDisposed(),null.clone(this)}toString(t=!1){return us(this.dataSync(),this.shape,this.dtype,t)}cast(t){return this.throwIfDisposed(),null.cast(this,t)}variable(t=!0,e,n){return this.throwIfDisposed(),gs().makeVariable(this,t,e,n)}}Object.defineProperty(ms,Symbol.hasInstance,{value:t=>!!t&&null!=t.data&&null!=t.dataSync&&null!=t.throwIfDisposed}),xn("Tensor",(()=>ms));class bs extends ms{constructor(t,e,n,s){super(t.shape,t.dtype,t.dataId,s),this.trainable=e,this.name=n}assign(t){if(t.dtype!==this.dtype)throw new Error(`dtype of the new value (${t.dtype}) and previous value (${this.dtype}) must match`);if(!Qe(t.shape,this.shape))throw new Error(`shape of the new value (${t.shape}) and previous value (${this.shape}) must match`);gs().disposeTensor(this),this.dataId=t.dataId,gs().incRef(this,null)}dispose(){gs().disposeVariable(this),this.isDisposedInternal=!0}}var ys,ws,ks,vs,xs;Object.defineProperty(bs,Symbol.hasInstance,{value:t=>t instanceof ms&&null!=t.assign&&t.assign instanceof Function}),function(t){t.R0="R0",t.R1="R1",t.R2="R2",t.R3="R3",t.R4="R4",t.R5="R5",t.R6="R6"}(ys||(ys={})),function(t){t.float32="float32",t.int32="int32",t.bool="int32",t.complex64="complex64"}(ws||(ws={})),function(t){t.float32="float32",t.int32="int32",t.bool="bool",t.complex64="complex64"}(ks||(ks={})),function(t){t.float32="float32",t.int32="float32",t.bool="float32",t.complex64="complex64"}(vs||(vs={})),function(t){t.float32="complex64",t.int32="complex64",t.bool="complex64",t.complex64="complex64"}(xs||(xs={}));const Ss={float32:vs,int32:ws,bool:ks,complex64:xs};function Ns(t,e){if(t.dtype===e.dtype)return[t,e];const n=function(t,e){if("string"===t||"string"===e){if("string"===t&&"string"===e)return"string";throw new Error(`Can not upcast ${t} with ${e}`)}return Ss[t][e]}(t.dtype,e.dtype);return[t.cast(n),e.cast(n)]}function Es(t){const e=[];return Is(t,e,new Set),e}function Is(t,e,n){if(null==t)return;if(t instanceof ms)return void e.push(t);if(s=t,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=t;for(const t in r){const s=r[t];n.has(s)||(n.add(s),Is(s,e,n))}}function As(t){return null!=t.kernelName}class $s{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((t=>t.name))))}}}dispose(){for(const t in this.registeredVariables)this.registeredVariables[t].dispose()}}class Cs{constructor(t){this.ENV=t,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new $s}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:t,asyncInit:e}=this.initializeBackendsAndReturnBest();if(e)throw new Error(`The highest priority backend '${t}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(t)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(t){if(!(t in this.registry)){if(!(t in this.registryFactory))return null;{const{asyncInit:e}=this.initializeBackend(t);if(e)return null}}return this.registry[t]}findBackendFactory(t){return t in this.registryFactory?this.registryFactory[t].factory:null}registerBackend(t,e,n=1){return t in this.registryFactory?(Sn(`${t} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[t]={factory:e,priority:n},!0)}async setBackend(t){if(null==this.registryFactory[t])throw new Error(`Backend name '${t}' not found in registry`);if(this.backendName=t,null==this.registry[t]){this.backendInstance=null;const{success:e,asyncInit:n}=this.initializeBackend(t);if(!(n?await e:e))return!1}return this.backendInstance=this.registry[t],this.setupRegisteredKernels(),this.profiler=new as(this.backendInstance),!0}setupRegisteredKernels(){$n(this.backendName).forEach((t=>{null!=t.setupFunc&&t.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(t){$n(t).forEach((e=>{null!=e.disposeFunc&&e.disposeFunc(this.registry[t])}))}initializeBackend(t){const e=this.registryFactory[t];if(null==e)throw new Error(`Cannot initialize backend ${t}, no registration found.`);try{const n=e.factory();if(!n||n instanceof class{refCount(t){return Ge("refCount")}incRef(t){return Ge("incRef")}timerAvailable(){return!0}time(t){return Ge("time")}read(t){return Ge("read")}readSync(t){return Ge("readSync")}readToGPU(t,e){return Ge("readToGPU")}numDataIds(){return Ge("numDataIds")}disposeData(t,e){return Ge("disposeData")}write(t,e,n){return Ge("write")}move(t,e,n,s,r){return Ge("move")}memory(){return Ge("memory")}floatPrecision(){return Ge("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return Ge("dispose")}}||"function"!=typeof n.then)return this.registry[t]=n,{success:!0,asyncInit:!1};{const e=++this.pendingBackendInitId,s=n.then((n=>!(e<this.pendingBackendInitId)&&(this.registry[t]=n,this.pendingBackendInit=null,!0))).catch((n=>(e<this.pendingBackendInitId||(this.pendingBackendInit=null,Sn(`Initialization of backend ${t} failed`),Sn(n.stack||n.message)),!1)));return this.pendingBackendInit=s,{success:s,asyncInit:!0}}}catch(e){return Sn(`Initialization of backend ${t} failed`),Sn(e.stack||e.message),{success:!1,asyncInit:!1}}}removeBackend(t){if(!(t in this.registryFactory))throw new Error(`${t} backend not found in registry`);this.backendName===t&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,t in this.registry&&(this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t]),delete this.registryFactory[t],this.backendName===t&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((t,e)=>this.registryFactory[e].priority-this.registryFactory[t].priority))}initializeBackendsAndReturnBest(){const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(t,e){const n=this.state.tensorInfo.get(e),s=n.backend,r=this.readSync(e),i=s.refCount(e);s.disposeData(e,!0),n.backend=t,t.move(e,r,n.shape,n.dtype,i),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(t,e){let n,s=null;if(null==e){if("function"!=typeof t)throw new Error("Please provide a function to tidy()");e=t}else{if("string"!=typeof t&&!(t instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof e)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=t}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=e(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(t,e,n){t();try{const t=n();return e(),t}catch(t){throw e(),t}}nextTensorId(){return Cs.nextTensorId++}nextVariableId(){return Cs.nextVariableId++}clone(t){const e=Ts.runKernel("Identity",{x:t}),n={x:t};return this.addTapeNode(this.state.activeScope.name,n,[e],(t=>({x:()=>{const e={x:t},n={dtype:"float32"};return Ts.runKernel("Cast",e,n)}})),[],{}),e}runKernel(t,e,n){null==this.backendName&&this.backend;if(!(null!=In(t,this.backendName)))throw new Error(`Kernel '${t}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:t,inputs:e,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(t,e,n){const s=this.backend.numDataIds();let r=0;n.forEach((t=>{r+="complex64"===t.dtype?3:1}));const i=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=s-e-r-i;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${t}'`)}runKernelFunc(t){let e,n=[];const s=this.isTapeOn(),r=this.state.numBytes,i=this.state.numTensors;let a,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=As(t)?t.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(As(t)){const{kernelName:e,inputs:r,attrs:i}=t;null==this.backendName&&this.backend;const l=In(e,this.backendName);He(null!=l,(()=>`Cannot find registered kernel '${e}' for backend '${this.backendName}'`)),a=()=>{const t=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:i,backend:this.backend});const a=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(e,t,a);const u=a.map((t=>null!=t.rank?t:this.makeTensorFromTensorInfo(t)));if(s){const t=this.getTensorsForGradient(e,r,u);n=this.saveTensorsForBackwardMode(t)}return u}}else{const{forwardFunc:e}=t,r=t=>{s&&(n=t.map((t=>this.keep(this.clone(t)))))};a=()=>{const t=this.backend.numDataIds();o=this.tidy((()=>e(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,t,n),n}}const{inputs:u,attrs:h}=t,c=As(t)?null:t.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(l,u,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),e=p.outputs):e=a()})),s&&this.addTapeNode(l,u,e,c,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-i,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(u).map((t=>null!=u[t]?u[t].shape:null)),outputShapes:e.map((t=>t.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(o)?e:e[0]}saveTensorsForBackwardMode(t){const e=t.map((t=>this.keep(this.clone(t))));return e}getTensorsForGradient(t,e,n){const s=An(t);if(null!=s){const t=s.inputsToSave||[],r=s.outputsToSave||[];let i;s.saveAllInputs?(He(Array.isArray(e),(()=>"saveAllInputs is true, expected inputs to be an array.")),i=Object.keys(e).map((t=>e[t]))):i=t.map((t=>e[t]));const a=n.filter(((t,e)=>r[e]));return i.concat(a)}return[]}makeTensor(t,e,n,s){if(null==t)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=t;"string"===n&&an(t[0])&&(r=t.map((t=>function(t,e="utf-8"){return e=e||"utf-8",yn().platform.encode(t,e)}(t))));const i=s.write(r,e,n),a=new ms(e,n,i,this.nextTensorId());if(this.trackTensor(a,s),"string"===n){const t=this.state.tensorInfo.get(i),e=function(t){if(null==t)return 0;let e=0;return t.forEach((t=>e+=t.length)),e}(r);this.state.numBytes+=e-t.bytes,t.bytes=e}return a}makeTensorFromDataId(t,e,n,s){const r={dataId:t,shape:e,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(t,e){const{dataId:n,shape:s,dtype:r}=t,i=new ms(s,r,n,this.nextTensorId());return this.trackTensor(i,e),i}makeVariable(t,e=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==t.dtype&&(t=t.cast(s));const r=new bs(t,e,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(t,e){this.state.numTensors++,"string"===t.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==t.dtype&&"string"!==t.dtype&&(n=t.size*rn(t.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(t.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(t.dataId,{backend:e||this.backend,dtype:t.dtype,shape:t.shape,bytes:n})),t instanceof bs||this.track(t)}incRef(t,e){this.trackTensor(t,e),this.backend.incRef(t.dataId)}removeDataId(t,e){this.state.tensorInfo.has(t)&&this.state.tensorInfo.get(t).backend===e&&(this.state.tensorInfo.delete(t),this.state.numDataBuffers--)}disposeTensor(t){if(!this.state.tensorInfo.has(t.dataId))return;const e=this.state.tensorInfo.get(t.dataId);if(this.state.numTensors--,"string"===t.dtype&&(this.state.numStringTensors--,this.state.numBytes-=e.bytes),"complex64"!==t.dtype&&"string"!==t.dtype){const e=t.size*rn(t.dtype);this.state.numBytes-=e}e.backend.disposeData(t.dataId)&&this.removeDataId(t.dataId,e.backend)}disposeVariables(){for(const t in this.state.registeredVariables){const e=this.state.registeredVariables[t];this.disposeVariable(e)}}disposeVariable(t){this.disposeTensor(t),null!=this.state.registeredVariables[t.name]&&delete this.state.registeredVariables[t.name]}memory(){const t=this.backend.memory();return t.numTensors=this.state.numTensors,t.numDataBuffers=this.state.numDataBuffers,t.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(t.unreliable=!0,null==t.reasons&&(t.reasons=[]),t.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),t}async profile(t){this.state.profiling=!0;const e=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await t(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((t=>t.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-e,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const t of this.state.activeProfile.kernels)t.kernelTimeMs=await t.kernelTimeMs,t.extraInfo=await t.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(t,e,n,s,r,i){const a={id:this.state.nextTapeNodeId++,kernelName:t,inputs:e,outputs:n,saved:r},o=An(t);null!=o&&(s=o.gradFunc),null!=s&&(a.gradient=t=>(t=t.map(((t,e)=>{if(null==t){const t=n[e],s=dn(t.size,t.dtype);return this.makeTensor(s,t.shape,t.dtype)}return t})),s(t.length>1?t:t[0],r,i))),this.state.activeTape.push(a)}keep(t){return t.kept=!0,t}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(t){const e={track:[],name:"unnamed scope",id:this.state.nextScopeId++};t&&(e.name=t),this.state.scopeStack.push(e),this.state.activeScope=e}endScope(t){const e=Es(t),n=new Set(e.map((t=>t.id)));for(let t=0;t<this.state.activeScope.track.length;t++){const e=this.state.activeScope.track[t];e.kept||n.has(e.id)||e.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],e.forEach((t=>{t.kept||t.scopeId!==s.id||this.track(t)}))}gradients(t,e,n,s=!1){if(He(e.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",t)));He(r instanceof ms,(()=>"The result y returned by f() must be a tensor."));const i=function(t,e,n){const s={},r={};for(let t=0;t<e.length;t++)s[e[t].id]=!0;for(let n=0;n<t.length;n++){const i=t[n],a=i.inputs;for(const t in a){const n=a[t];let o=!1;for(let t=0;t<e.length;t++)if(s[n.id]){i.outputs.forEach((t=>s[t.id]=!0)),o=!0,r[i.id]=!0;break}if(o)break}}const i={};i[n.id]=!0;const a={};for(let e=t.length-1;e>=0;e--){const n=t[e],s=n.inputs;for(let t=0;t<n.outputs.length;t++)if(i[n.outputs[t].id]){for(const t in s)i[s[t].id]=!0,a[n.id]=!0;break}}const o=[];for(let e=0;e<t.length;e++){const n=t[e];if(r[n.id]&&a[n.id]){const t={};for(const e in n.inputs){const r=n.inputs[e];s[r.id]&&(t[e]=r)}const e=Object.assign({},n);e.inputs=t,e.outputs=n.outputs,o.push(e)}}return o}(this.state.activeTape,e,r);if(!s&&0===i.length&&e.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const t={};t[r.id]=null==n?function(t){const e=pn(Xe(t),"float32");return Ts.makeTensor(e,t,"float32")}(r.shape):n,function(t,e,n,s){for(let r=e.length-1;r>=0;r--){const i=e[r],a=[];if(i.outputs.forEach((e=>{const n=t[e.id];null!=n?a.push(n):a.push(null)})),null==i.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${i.kernelName}.`);const o=i.gradient(a);for(const e in i.inputs){if(!(e in o))throw new Error(`Cannot backprop through input ${e}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[e]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input ${e} must have 'float32' dtype, but has '${r.dtype}'`);const a=i.inputs[e];if(!Qe(r.shape,a.shape))throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input '${e}' has shape '${r.shape}', which does not match the shape of the input '${a.shape}'`);if(null==t[a.id])t[a.id]=r;else{const e=t[a.id];t[a.id]=s(e,r),e.dispose()}}}}(t,i,(t=>this.tidy(t)),zs);const s=e.map((e=>t[e.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((t=>{for(const e of t.saved)e.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(t){return He(ln(t),(()=>"The f passed in customGrad(f) must be a function.")),(...e)=>{let n;He(e.every((t=>t instanceof ms)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};e.forEach(((t,e)=>{s[e]=t}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=t(...e,r),He(n.value instanceof ms,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),He(ln(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(t,s)=>{const r=n.gradFunc(t,s),i=Array.isArray(r)?r:[r];He(i.length===e.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),He(i.every((t=>t instanceof ms)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return i.forEach(((t,e)=>{a[e]=()=>t})),a},inputs:s})}}readSync(t){return this.state.tensorInfo.get(t).backend.readSync(t)}read(t){return this.state.tensorInfo.get(t).backend.read(t)}readToGPU(t,e){return this.state.tensorInfo.get(t).backend.readToGPU(t,e)}async time(t){const e=rs(),n=await this.backend.time(t);return n.wallMs=rs()-e,n}track(t){return null!=this.state.activeScope&&(t.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(t)),t}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new $s;for(const t in this.registry)this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}Cs.nextTensorId=0,Cs.nextVariableId=0;const Ts=function(){const t=vn();if(null==t._tfengine){const e=new mn(t);t._tfengine=new Cs(e)}var e;return e=t._tfengine.ENV,kn=e,gs=()=>t._tfengine,t._tfengine}();function zs(t,e){const n={a:t,b:e};return Ts.runKernel("Add",n)}function _s(t,e){let n=t;if(sn(t))return"string"===e?[]:[t.length];if(!Array.isArray(t))return[];const s=[];for(;Array.isArray(n)||sn(n)&&"string"!==e;)s.push(n.length),n=n[0];return Array.isArray(t)&&yn().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Ds(t,s,[]),s}function Ds(t,e,n){if(n=n||[],!Array.isArray(t)&&!sn(t))return void He(0===e.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${e[0]} elements`));He(e.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${t.length} elements`)),He(t.length===e[0],(()=>`Element arr[${n.join("][")}] should have ${e[0]} elements, but has ${t.length} elements`));const s=e.slice(1);for(let e=0;e<t.length;++e)Ds(t[e],s,n.concat(e))}function Fs(t,e,n,s){if("string_or_numeric"!==t){if(null==t)throw new Error("Expected dtype cannot be null.");if("numeric"!==t&&t!==e||"numeric"===t&&"string"===e)throw new Error(`Argument '${n}' passed to '${s}' must be ${t} tensor, but got ${e} tensor`)}}function Ms(t,e,n,s="numeric"){if(t instanceof ms)return Fs(s,t.dtype,e,n),t;let r=on(t);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Fs(s,r,e,n),null==t||!sn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t){const s=null==t?"null":t.constructor.name;throw new Error(`Argument '${e}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const i=_s(t,r);sn(t)||Array.isArray(t)||(t=[t]);const a="string"!==r?ss(t,r):Ye(t,[],!0);return Ts.makeTensor(a,i,r)}function Ls(t,e,n,s="numeric"){if(!Array.isArray(t))throw new Error(`Argument ${e} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return t.map(((t,r)=>Ms(t,`${e}[${r}]`,n,s)))}function Rs(t){const e=Object.keys(t);if(1!==e.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${e.length} keys.`);let n=e[0];const s=t[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...t)=>{Ts.startScope(n);try{const e=s(...t);return gn(e)&&console.error("Cannot return a Promise inside of tidy."),Ts.endScope(e),e}catch(t){throw Ts.endScope(null),t}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Os=Rs({cast_:function(t,e){const n=Ms(t,"x","cast");if(!function(t){return"bool"===t||"complex64"===t||"float32"===t||"int32"===t||"string"===t}(e))throw new Error(`Failed to cast to unknown dtype ${e}`);if("string"===e&&"string"!==n.dtype||"string"!==e&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:e};return Ts.runKernel("Cast",s,r)}});const Bs=Rs({mul_:function(t,e){let n=Ms(t,"a","mul"),s=Ms(e,"b","mul");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Multiply",r)}});const Ps=Rs({step_:function(t,e=0){const n={x:Ms(t,"x","step")},s={alpha:e};return Ts.runKernel("Step",n,s)}}),Ws={kernelName:"Abs",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,Ps(Os(n,"float32"),-1))}}};const Us=Rs({floorDiv_:function(t,e){let n=Ms(t,"a","floorDiv"),s=Ms(e,"b","floorDiv");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("FloorDiv",r)}});const Ks=Rs({div_:function(t,e){let n=Ms(t,"a","div"),s=Ms(e,"b","div");if([n,s]=Ns(n,s),"int32"===n.dtype&&"int32"===s.dtype)return Us(n,s);const r={a:n,b:s};return Ts.runKernel("RealDiv",r,{})}});const Vs=Rs({neg_:function(t){const e={x:Ms(t,"x","neg")};return Ts.runKernel("Neg",e)}});function qs(t,e,n,s){if(null==s&&(s=on(t)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!sn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=e){fn(e);const t=Xe(e),s=Xe(n);He(t===s,(()=>`Based on the provided shape, [${e}], the tensor should have ${t} values but has ${s}`));for(let t=0;t<n.length;++t){const s=n[t],r=t!==n.length-1||s!==Xe(e.slice(t));He(n[t]===e[t]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${e}). `))}}return sn(t)||Array.isArray(t)||(t=[t]),e=e||n,t="string"!==s?ss(t,s):Ye(t,[],!0),Ts.makeTensor(t,e,s)}function js(t,e){if((sn(t)&&"string"!==e||Array.isArray(t))&&"complex64"!==e)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===e&&sn(t)&&!(t instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return qs(t,[],[],e)}const Gs=Rs({sqrt_:function(t){const e={x:Ms(t,"x","sqrt","float32")};return Ts.runKernel("Sqrt",e)}});const Hs=Rs({square_:function(t){const e=Ms(t,"x","square");return Ts.runKernel("Square",{x:e},{})}});const Js=Rs({sub_:function(t,e){let n=Ms(t,"a","sub"),s=Ms(e,"b","sub");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Sub",r)}}),Zs={kernelName:"Acos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Hs(Os(n,"float32")),s=Gs(Js(js(1),e));return Vs(Ks(t,s))}}}},Ys={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Gs(Js(Hs(Os(n,"float32")),1));return Ks(t,e)}}}};function Xs(t,e){const n=[];for(let s=0;s<e.length;s++){const r=t[t.length-s-1],i=e.length-s-1,a=e[i];(null==r||1===r&&a>1)&&n.unshift(i)}return n}function Qs(t,e){const n=[],s=Math.max(t.length,e.length);for(let r=0;r<s;r++){let s=t[t.length-r-1];null==s&&(s=1);let i=e[e.length-r-1];if(null==i&&(i=1),1===s)n.unshift(i);else if(1===i)n.unshift(s);else{if(s!==i){throw Error(`Operands could not be broadcast together with shapes ${t} and ${e}.`)}n.unshift(s)}}return n}const tr=Rs({reshape_:function(t,e){const n={x:Ms(t,"x","reshape","string_or_numeric")},s={shape:e};return Ts.runKernel("Reshape",n,s)}});const er=Rs({sum_:function(t,e=null,n=!1){let s=Ms(t,"x","sum");"bool"===s.dtype&&(s=Os(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ts.runKernel("Sum",r,i)}}),nr={kernelName:"Add",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{let e=t;const s=Xs(n.shape,r);return s.length>0&&(e=er(e,s)),tr(e,n.shape)},b:()=>{let e=t;const n=Xs(s.shape,r);return n.length>0&&(e=er(e,n)),tr(e,s.shape)}}}},sr={kernelName:"AddN",saveAllInputs:!0,gradFunc:(t,e)=>{const n={};return e.forEach(((e,s)=>{n[s]=()=>t.clone()})),n}};const rr=Rs({zerosLike_:function(t){const e={x:Ms(t,"x","zerosLike")};return Ts.runKernel("ZerosLike",e)}}),ir={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>rr(n)}}},ar={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>rr(n)}}},or={kernelName:"Asin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Gs(Js(js(1),Hs(Os(n,"float32")))))}}};const lr=Rs({add_:function(t,e){let n=Ms(t,"a","add"),s=Ms(e,"b","add");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Add",r)}}),ur={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Gs(lr(js(1),Hs(Os(n,"float32"))));return Ks(t,e)}}}},hr={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{const e=lr(Hs(n),Hs(s));let i=Bs(t,Ks(s,e));const a=Xs(n.shape,r);return a.length>0&&(i=er(i,a)),tr(i,n.shape)},b:()=>{const e=lr(Hs(n),Hs(s));let i=Vs(Bs(t,Ks(n,e)));const a=Xs(s.shape,r);return a.length>0&&(i=er(i,a)),tr(i,s.shape)}}}},cr={kernelName:"Atan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,lr(Hs(Os(n,"float32")),1))}}},pr={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Js(js(1),Hs(Os(n,"float32"))))}}};function dr(t,e,n,s,r,i,a=!1,o="channelsLast"){let[l,u,h,c]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,h,c]=t;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,c,u,h]=t}const[p,d,,f]=e,[g,m]=fr(n),[b,y]=fr(s),w=gr(p,b),k=gr(d,y),{padInfo:v,outHeight:x,outWidth:S}=function(t,e,n,s,r,i,a,o,l){let u,h,c;if("number"==typeof t){u={top:t,bottom:t,left:t,right:t,type:0===t?"VALID":"NUMBER"};const r=function(t,e,n,s,r){null==s&&(s=function(t,e,n,s=1){const r=gr(e,s);return Math.floor((t[0]*(n-1)-n+r)/2)}(t,e,n));const i=t[0],a=t[1],o=mr((i-e+2*s)/n+1,r),l=mr((a-e+2*s)/n+1,r);return[o,l]}([e,n],i,s,t,o);h=r[0],c=r[1]}else if("same"===t){h=Math.ceil(e/s),c=Math.ceil(n/r);const t=Math.max(0,(h-1)*s+i-e),o=Math.max(0,(c-1)*r+a-n),l=Math.floor(t/2),p=t-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===t)u={top:0,bottom:0,left:0,right:0,type:"VALID"},h=Math.ceil((e-i+1)/s),c=Math.ceil((n-a+1)/r);else{if("object"!=typeof t)throw Error(`Unknown padding parameter: ${t}`);{const p="channelsLast"===l?t[1][0]:t[2][0],d="channelsLast"===l?t[1][1]:t[2][1],f="channelsLast"===l?t[2][0]:t[3][0],g="channelsLast"===l?t[2][1]:t[3][1];u={top:p,bottom:d,left:f,right:g,type:0===p&&0===d&&0===f&&0===g?"VALID":"EXPLICIT"},h=mr((e-i+p+d)/s+1,o),c=mr((n-a+f+g)/r+1,o)}}return{padInfo:u,outHeight:h,outWidth:c}}(r,u,h,g,m,w,k,i,o),N=a?f*c:f;let E;return"channelsFirst"===o?E=[l,N,x,S]:"channelsLast"===o&&(E=[l,x,S,N]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:h,inChannels:c,outHeight:x,outWidth:S,outChannels:N,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:p,filterWidth:d,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:t,outShape:E,filterShape:e}}function fr(t){return"number"==typeof t?[t,t,t]:2===t.length?[t[0],t[1],1]:t}function gr(t,e){return e<=1?t:t+(t-1)*(e-1)}function mr(t,e){if(!e)return Math.trunc(t);switch(e){case"round":return Math.round(t);case"ceil":return Math.ceil(t);case"floor":return Math.floor(t);default:throw new Error(`Unknown roundingMode ${e}`)}}function br(t){const[e,n,s]=fr(t);return 1===e&&1===n&&1===s}function yr(t,e){return br(t)||br(e)}function wr(t,e,n){if(null!=n){if("string"==typeof e)throw Error(`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`);if("number"==typeof e)He(tn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`));else{if("object"!=typeof e)throw Error(`Error in ${t}: Unknown padding parameter: ${e}`);e.forEach((e=>{e.forEach((e=>{He(tn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`))}))}))}}}const kr=Rs({avgPool3dGrad_:function(t,e,n,s,r,i){const a=Ms(t,"dy","avgPool3dGrad"),o=Ms(e,"input","avgPool3dGrad");let l=a,u=o,h=!1;4===o.rank&&(h=!0,l=tr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]]),u=tr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),He(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),He(5===u.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${u.rank}.`)),wr("avgPool3dGrad",r,i);const c={dy:l,input:u},p={filterSize:n,strides:s,pad:r,dimRoundingMode:i},d=Ts.runKernel("AvgPool3DGrad",c,p);return h?tr(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}}),vr={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a,dimRoundingMode:o}=n;return{x:()=>kr(t,s,r,i,a,o)}}};const xr=Rs({avgPoolGrad_:function(t,e,n,s,r){const i=Ms(t,"dy","avgPoolGrad"),a=Ms(e,"input","avgPoolGrad");He(a.rank===i.rank,(()=>`Rank of input (${a.rank}) does not match rank of dy (${i.rank})`));let o=a,l=i,u=!1;3===a.rank&&(u=!0,o=tr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),l=tr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),He(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),He(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},c={filterSize:n,strides:s,pad:r},p=Ts.runKernel("AvgPoolGrad",h,c);return u?tr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),Sr={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a}=n;return{x:()=>xr(t,s,r,i,a)}}};const Nr=Rs({matMul_:function(t,e,n=!1,s=!1){let r=Ms(t,"a","matMul"),i=Ms(e,"b","matMul");[r,i]=Ns(r,i);const a={a:r,b:i},o={transposeA:n,transposeB:s};return Ts.runKernel("BatchMatMul",a,o)}}),Er={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(t,e,n)=>{const[s,r]=e,{transposeA:i,transposeB:a}=n;return i||a?!i&&a?{a:()=>Nr(t,r,!1,!1),b:()=>Nr(t,s,!0,!1)}:i&&!a?{a:()=>Nr(r,t,!1,!0),b:()=>Nr(s,t,!1,!1)}:{a:()=>Nr(r,t,!0,!0),b:()=>Nr(t,s,!0,!0)}:{a:()=>Nr(t,r,!1,!0),b:()=>Nr(s,t,!0,!1)}}};const Ir=Rs({spaceToBatchND_:function(t,e,n){const s=Ms(t,"x","spaceToBatchND");He(s.rank>=1+e.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${e.length}`)),He(n.length===e.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${e.length}`)),He(s.shape.reduce(((t,s,r)=>r>0&&r<=e.length?t&&(s+n[r-1][0]+n[r-1][1])%e[r-1]==0:t),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${e.toString()}`));const r={x:s},i={blockShape:e,paddings:n};return Ts.runKernel("SpaceToBatchND",r,i)}}),Ar={kernelName:"BatchToSpaceND",gradFunc:(t,e,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>Ir(t,s,r)}}},$r={kernelName:"BroadcastTo",gradFunc:(t,e,n)=>{const s=n,r=s.inputShape,i=s.shape,a=Array.from(i);for(let t=r.length-1;t>=0;t--)if(r[t]===i[t])a[t]=1;else if(1!==r[t])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${i}].`);const o=[];for(let t=0;t<a.length;t++)a[t]>1&&o.push(t);return{x:()=>er(t,o,!0)}}},Cr={kernelName:"Cast",gradFunc:t=>({x:()=>t.clone()})},Tr={kernelName:"Ceil",gradFunc:t=>({x:()=>rr(t)})};const zr=Rs({greaterEqual_:function(t,e){let n=Ms(t,"a","greaterEqual","string_or_numeric"),s=Ms(e,"b","greaterEqual","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("GreaterEqual",r)}});const _r=Rs({lessEqual_:function(t,e){let n=Ms(t,"a","lessEqual","string_or_numeric"),s=Ms(e,"b","lessEqual","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("LessEqual",r)}});const Dr=Rs({logicalAnd_:function(t,e){const n=Ms(t,"a","logicalAnd","bool"),s=Ms(e,"b","logicalAnd","bool");Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("LogicalAnd",r)}});const Fr=Rs({clone_:function(t){const e={x:Ms(t,"x","clone","string_or_numeric")};return Ts.runKernel("Identity",e)}});const Mr=Rs({broadcastTo_:function(t,e){let n=Ms(t,"broadcastTo","x");const s=n.shape;if(e.some((t=>!(t>0)||t%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${e}].`);if(e.length<n.rank)throw new Error(`broadcastTo(): shape.length=${e.length} < input.rank=${n.rank}.`);if(e.length>n.rank){const t=n.shape.slice();for(;t.length<e.length;)t.unshift(1);n=tr(n,t)}const r=n.shape,i=Array.from(e);for(let t=e.length-1;t>=0;t--)if(r[t]===e[t])i[t]=1;else if(1!==n.shape[t])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${e}].`);if(0===i.map(((t,e)=>t>1?e:-1)).filter((t=>t>=0)).length)return Fr(n);const a={x:n},o={reps:i};return Ts.runKernel("Tile",a,o)}});const Lr=Rs({where_:function(t,e,n){const s=Ms(e,"a","where"),r=Ms(n,"b","where"),i=Ms(t,"condition","where","bool"),a=Qs(Qs(i.shape,s.shape),r.shape),o={condition:Mr(i,a),t:Mr(s,a),e:Mr(r,a)};return Ts.runKernel("Select",o)}}),Rr={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{clipValueMin:r,clipValueMax:i}=n;return{x:()=>Lr(Dr(zr(s,r),_r(s,i)),t,rr(t))}}},Or={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:Ws.gradFunc};const Br=Rs({split_:function(t,e,n=0){const s={x:Ms(t,"x","split")},r={numOrSizeSplits:e,axis:n};return Ts.runKernel("SplitV",s,r)}}),Pr={kernelName:"Concat",saveAllInputs:!0,gradFunc:(t,e,n)=>{const s=e.map((t=>t.shape)),{axis:r}=n,i=nn(r,e[0].shape)[0],a=s.map((t=>t[i]));return Br(t,a,i).map((t=>()=>t))}};const Wr=Rs({conv2DBackpropFilter_:function(t,e,n,s,r,i="NHWC",a){let o=t;3===t.rank&&(o=tr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=tr(e,[1,e.shape[0],e.shape[1],e.shape[2]])),He(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),He(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),He(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const u="NHWC"===i?o.shape[3]:o.shape[1],h="NHWC"===i?l.shape[3]:l.shape[1];He(u===n[2],(()=>`Error in conv2dDerFilter: depth of input ${u}) must match input depth in filter (${n[2]}.`)),He(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),wr("conv2dDerFilter",r,a);const c={x:o,dy:l},p={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,filterShape:n};return Ts.runKernel("Conv2DBackpropFilter",c,p)}});const Ur=Rs({conv2DBackpropInput_:function(t,e,n,s,r,i="NHWC",a){He(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let o=t,l=e,u=!1;3===e.rank&&(u=!0,l=tr(e,[1,e.shape[0],e.shape[1],e.shape[2]]),o=[1,t[0],t[1],t[2]]),He(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),He(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),He(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===i?o[3]:o[1],c="NHWC"===i?l.shape[3]:l.shape[1];He(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),He(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),wr("conv2dDerInput",r,a);const p={dy:l,filter:n},d={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,inputShape:o},f=Ts.runKernel("Conv2DBackpropInput",p,d);return u?tr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Kr={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{dilations:i,strides:a,pad:o,dataFormat:l}=n;return He(br(i),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`)),{x:()=>Ur(s.shape,t,r,a,o,l),filter:()=>Wr(s,t,r.shape,a,o,l)}}};const Vr=Rs({conv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Ms(t,"x","conv2d","float32"),l=Ms(e,"filter","conv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=tr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),He(4===u.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${u.rank}.`)),He(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),wr("conv2d",s,a);const c="NHWC"===r?u.shape[3]:u.shape[1];He(c===l.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${l.shape[2]}.`)),He(yr(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ts.runKernel("Conv2D",p,d);return h?tr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),qr={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{strides:i,pad:a,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>Vr(t,r,i,a,o,1,l),filter:()=>Wr(t,s,r.shape,i,a,o,l)}}};const jr=Rs({conv3DBackpropFilter_:function(t,e,n,s,r){let i=t;4===t.rank&&(i=tr(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]));let a=e;4===a.rank&&(a=tr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]])),He(5===i.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${i.shape}.`)),He(5===a.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${a.shape}.`)),He(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),He(i.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${i.shape[4]}) must match input depth in filter (${n[3]}.`)),He(a.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${a.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:i,dy:a},l={strides:s,pad:r,filterShape:n};return Ts.runKernel("Conv3DBackpropFilterV2",o,l)}});const Gr=Rs({conv3DBackpropInput_:function(t,e,n,s,r){He(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let i=t,a=e,o=!1;4===e.rank&&(o=!0,a=tr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]),i=[1,t[0],t[1],t[2],t[3]]);const l=i[4],u=a.shape[4];He(5===i.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${i.length}.`)),He(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),He(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),He(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),He(u===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${u}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},c={pad:r,strides:s,inputShape:i},p=Ts.runKernel("Conv3DBackpropInputV2",h,c);return o?tr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Hr={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i}=n;He(br(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[a,o]=e;return{x:()=>Gr(a.shape,t,o,r,i),filter:()=>jr(a,t,o.shape,r,i)}}};const Jr=Rs({sin_:function(t){const e={x:Ms(t,"x","sin","float32")};return Ts.runKernel("Sin",e)}}),Zr={kernelName:"Cos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(Vs(Jr(Os(n,"float32"))),t)}}};const Yr=Rs({sinh_:function(t){const e={x:Ms(t,"x","sinh")};return Ts.runKernel("Sinh",e)}}),Xr={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(Yr(Os(n,"float32")),t)}}};function Qr(t,e){return function(t,e,n){const s=t.length+e.length,r=[];let i=0,a=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(t[i++]):r.push(e[a++]);return r}(t,e.map((t=>1)),e)}function ti(t,e){if(function(t,e){for(let n=0;n<t.length;++n)if(t[t.length-n-1]!==e-1-n)return!1;return!0}(t,e))return null;const n=[];for(let s=0;s<e;++s)-1===t.indexOf(s)&&n.push(s);return t.forEach((t=>n.push(t))),n}function ei(t){return t.map(((t,e)=>[e,t])).sort(((t,e)=>t[1]-e[1])).map((t=>t[0]))}const ni=Rs({cumsum_:function(t,e=0,n=!1,s=!1){const r={x:Ms(t,"x","cumsum")},i={axis:e,exclusive:n,reverse:s};return Ts.runKernel("Cumsum",r,i)}});function si(t,e){return Ts.tidy(t,e)}function ri(t){Es(t).forEach((t=>t.dispose()))}const ii=Rs({complex_:function(t,e){const n=Ms(t,"real","complex"),s=Ms(e,"imag","complex");Je(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ts.runKernel("Complex",r)}});const ai=Rs({imag_:function(t){const e={input:Ms(t,"input","imag")};return Ts.runKernel("Imag",e)}});const oi=Rs({real_:function(t){const e={input:Ms(t,"input","real")};return Ts.runKernel("Real",e)}});const li=Rs({transpose_:function(t,e,n){const s=Ms(t,"x","transpose");if(null==e&&(e=s.shape.map(((t,e)=>e)).reverse()),He(s.rank===e.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${e}.`)),e.forEach((t=>{He(t>=0&&t<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${e}`))})),s.rank<=1)return s.clone();const r={x:s},i={perm:e};return"complex64"===s.dtype?si((()=>{let t=oi(s),e=ai(s);return t=Ts.runKernel("Transpose",{x:t},i),e=Ts.runKernel("Transpose",{x:e},i),n&&(e=Vs(e)),ii(t,e)})):Ts.runKernel("Transpose",r,i)}}),ui={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r,exclusive:i,reverse:a}=n;return{x:()=>{const e=ti([r],s.rank);let n=ni(t,r,i,!a);return null!=e&&(n=li(n,e)),n}}}};const hi=Rs({depthwiseConv2dNativeBackpropFilter_:function(t,e,n,s,r,i=[1,1],a){let o=t;3===t.rank&&(o=tr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=tr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={x:o,dy:l},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,filterShape:n};return Ts.runKernel("DepthwiseConv2dNativeBackpropFilter",u,h)}});const ci=Rs({depthwiseConv2dNativeBackpropInput_:function(t,e,n,s,r,i=[1,1],a){let o=e,l=!1;3===e.rank&&(l=!0,o=tr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={dy:o,filter:n},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,inputShape:t},c=Ts.runKernel("DepthwiseConv2dNativeBackpropInput",u,h);return l?tr(c,[c.shape[1],c.shape[2],c.shape[3]]):c}}),pi={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i,dimRoundingMode:a}=n,o=null==s?[1,1]:s;He(br(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,u]=e;return He(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),He(4===u.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${u.rank}.`)),He(l.shape[3]===u.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),He(yr(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),wr("depthwiseConv2d",i,a),{x:()=>ci(l.shape,t,u,r,i,o,a),filter:()=>hi(l,t,u.shape,r,i,o,a)}}},di={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,i={x:s,filter:r,dy:t},a={x:s,filter:r,dy:t};return{x:()=>Ts.runKernel("Dilation2DBackpropInput",i,n),filter:()=>Ts.runKernel("Dilation2DBackpropFilter",a,n)}}},fi={kernelName:"Elu",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e,s={dy:t,y:n};return{x:()=>Ts.runKernel("EluGrad",s)}}};const gi=Rs({exp_:function(t){const e={x:Ms(t,"x","exp")};return Ts.runKernel("Exp",e)}}),mi={kernelName:"Erf",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Bs(gi(Vs(Hs(n))),2/Math.sqrt(Math.PI));return{x:()=>Bs(t,s)}}},bi={kernelName:"Exp",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,n)}}},yi={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(t,e)=>{const[n]=e;return{input:()=>tr(t,n.shape)}}},wi={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,gi(n))}}},ki={kernelName:"Floor",gradFunc:t=>({x:()=>rr(t)})},vi={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{const e=Ks(t,Os(s,"float32")),i=Xs(n.shape,r);return i.length>0?tr(er(e,i),n.shape):e},b:()=>{let e=Bs(t,Os(n,"float32"));const i=Xs(s.shape,r);i.length>0&&(e=tr(er(e,i),s.shape));const a=Hs(s);return Vs(Ks(e,Os(a,"float32")))}}}};const xi=Rs({rsqrt_:function(t){const e={x:Ms(t,"x","rsqrt","float32")};return Ts.runKernel("Rsqrt",e)}});const Si=Rs({tile_:function(t,e){const n=Ms(t,"x","tile","string_or_numeric");He(n.rank===e.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${e}.`));const s={x:n},r={reps:e};return Ts.runKernel("Tile",s,r)}}),Ni={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(t,e,n)=>{const{varianceEpsilon:s}=n,[r,i,a,o]=e,l=null==o?js(1):o,u=Xs(i.shape,r.shape),h=[];if(1===i.rank){for(let t=0;t<r.shape.length-1;++t)h.push(r.shape[t]);h.push(1)}const c=Js(r,i),p=Bs(t,l),d=xi(lr(a,js(s))),f=Bs(Bs(Bs(d,d),d),js(-.5));return{x:()=>1===i.rank?tr(Bs(Bs(t,Si(tr(d,[1,1,1,i.shape[0]]),h)),l),r.shape):tr(Bs(Bs(t,d),l),r.shape),mean:()=>{let t=Bs(Bs(d,js(-1)),p);return 1===i.rank&&(t=er(t,u)),tr(t,i.shape)},variance:()=>{let t=Bs(Bs(f,c),p);return 1===i.rank&&(t=er(t,u)),tr(t,i.shape)},scale:()=>{const e=Bs(c,d);let n=Bs(t,e);return 1===i.rank&&(n=er(n,u)),tr(n,i.shape)},offset:()=>{let e=t;return 1===i.rank&&(e=er(e,u)),tr(e,i.shape)}}}};const Ei=Rs({unsortedSegmentSum_:function(t,e,n){const s=Ms(t,"x","unsortedSegmentSum"),r=Ms(e,"segmentIds","unsortedSegmentSum","int32");He(tn(n),(()=>"numSegments must be of dtype int"));const i={x:s,segmentIds:r},a={numSegments:n};return Ts.runKernel("UnsortedSegmentSum",i,a)}}),Ii={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(t,e,n)=>{const[s,r]=e,{axis:i}=n,a=nn(i,s.shape)[0];return{x:()=>{const e=s.shape,n=r.size,o=e.slice(0,a),l=o.length,u=e.slice(i,e.length).slice(1),h=u.length,c=Ai(0,l),p=Ai(l+1,l+1+h),d=$i([o,[n],u]),f=tr(t,d),g=tr(r,[n]),m=$i([[l],c,p]),b=li(f,m);let y=Ei(b,g,s.shape[a]);const w=ei(m);return y=li(y,w),y},indices:()=>r}}};function Ai(t,e){const n=[];for(let s=t;s<e;++s)n.push(s);return n}function $i(t){const e=[];for(let n=0;n<t.length;++n)for(let s=0;s<t[n].length;++s)e.push(t[n][s]);return e}const Ci={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>rr(n),b:()=>rr(s)}}},Ti={kernelName:"Identity",gradFunc:t=>({x:()=>Os(t,"float32")})},zi={kernelName:"IsFinite",gradFunc:t=>({x:()=>rr(t)})},_i={kernelName:"IsInf",gradFunc:t=>({x:()=>rr(t)})},Di={kernelName:"IsNan",gradFunc:t=>({x:()=>rr(t)})};const Fi=Rs({greater_:function(t,e){let n=Ms(t,"a","greater","string_or_numeric"),s=Ms(e,"b","greater","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("Greater",r)}}),Mi={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{alpha:r}=n,i=Fi(s,0);return{x:()=>Lr(i,t,Bs(t,r))}}},Li={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,lr(n,1))}}},Ri={kernelName:"Log",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Os(n,"float32"))}}},Oi={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;return{logits:()=>{const e=gi(s);return Js(t,Bs(er(t,r,!0),e))}}}};const Bi=Rs({localResponseNormalizationBackprop_:function(t,e,n,s=5,r=1,i=1,a=.5){const o={x:t,y:e,dy:n},l={depthRadius:s,bias:r,alpha:i,beta:a};return Ts.runKernel("LRNGrad",o,l)}}),Pi={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{depthRadius:i,bias:a,alpha:o,beta:l}=n;return{x:()=>Bi(s,r,t,i,a,o,l)}}};const Wi=Rs({equal_:function(t,e){let n=Ms(t,"a","equal","string_or_numeric"),s=Ms(e,"b","equal","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("Equal",r)}});function Ui(t,e,n,s){return e.rank<n.rank&&(e=tr(e,Qr(e.shape,s))),t.rank<n.rank&&(t=tr(t,Qr(t.shape,s))),{x:()=>Bs(t,Os(Wi(n,e),t.dtype))}}const Ki={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{reductionIndices:r}=s,i=e[0],a=Ui(t,e[1],i,nn(r,i.shape));return{x:()=>a.x()}}};const Vi=Rs({less_:function(t,e){let n=Ms(t,"a","less","string_or_numeric"),s=Ms(e,"b","less","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("Less",r)}}),qi={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Bs(t,Os(zr(n,s),"float32")),b:()=>Bs(t,Os(Vi(n,s),"float32"))}}};const ji=Rs({maxPool3dGrad_:function(t,e,n,s,r,i,a){const o=Ms(t,"dy","maxPool3dGrad"),l=Ms(e,"input","maxPool3dGrad"),u=Ms(n,"output","maxPool3dGrad");let h=o,c=l,p=u,d=!1;4===l.rank&&(d=!0,h=tr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),c=tr(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),p=tr(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),He(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),He(5===c.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),He(5===p.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${p.rank}.`)),wr("maxPool3dGrad",i,a);const f={dy:h,input:c,output:p},g={filterSize:s,strides:r,pad:i,dimRoundingMode:a},m=Ts.runKernel("MaxPool3DGrad",f,g);return d?tr(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Gi={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o,dimRoundingMode:l}=n;return{x:()=>ji(t,s,r,i,a,o,l)}}};const Hi=Rs({maxPoolGrad_:function(t,e,n,s,r,i,a){const o=Ms(t,"dy","maxPoolGrad"),l=Ms(e,"input","maxPoolGrad"),u=Ms(n,"output","maxPoolGrad");He(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),He(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),He(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),wr("maxPoolGrad",i,a);const h={dy:o,input:l,output:u},c={filterSize:s,strides:r,pad:i,dimRoundingMode:a};return Ts.runKernel("MaxPoolGrad",h,c)}}),Ji={kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o}=n;return{x:()=>Hi(t,s,r,i,a,o)}}};function Zi(t,e="float32"){if("complex64"===e){const e=Zi(t,"float32"),n=Zi(t,"float32");return ii(e,n)}const n=dn(Xe(t),e);return Ts.makeTensor(n,t,e)}function Yi(t,e="float32"){if("complex64"===e){const e=Yi(t,"float32"),n=Zi(t,"float32");return ii(e,n)}const n=pn(Xe(t),e);return Ts.makeTensor(n,t,e)}const Xi={kernelName:"Mean",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n,i=nn(r,s.shape),a=function(t,e){const n=[],s=t.length;for(let r=0;r<s;r++)-1===e.indexOf(r)&&n.push(t[r]);return[n,e.map((e=>t[e]))]}(s.shape,i),o=Xe(a[1]);return{x:()=>{const e=s.shape.slice();i.forEach((t=>{e[t]=1}));const n=tr(t,e);return Ks(Bs(n,Yi(s.shape,"float32")),o)}}}},Qi={kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{axis:r}=s,[i,a]=e,o=Ui(t,a,i,nn(r,i.shape));return{x:()=>o.x()}}},ta={kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Bs(t,Os(_r(n,s),"float32")),b:()=>Bs(t,Os(Fi(n,s),"float32"))}}};const ea=Rs({slice_:function(t,e,n){const s=Ms(t,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},i={begin:e,size:n};return Ts.runKernel("Slice",r,i)}}),na={kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>ea(t,i,s.shape)}}};const sa=Rs({floor_:function(t){const e={x:Ms(t,"x","floor","float32")};return Ts.runKernel("Floor",e)}}),ra={kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{const e=Xs(n.shape,r);return e.length>0?tr(er(t,e),n.shape):t},b:()=>{const e=Bs(t,Vs(sa(Ks(n,s)))),i=Xs(s.shape,r);return i.length>0?tr(er(e,i),s.shape):e}}}},ia={kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{const e=Bs(t,Os(s,"float32")),i=Xs(n.shape,r);return i.length>0?tr(er(e,i),n.shape):e},b:()=>{const e=Bs(t,Os(n,"float32")),i=Xs(s.shape,r);return i.length>0?tr(er(e,i),s.shape):e}}}},aa={kernelName:"Neg",gradFunc:t=>({x:()=>Vs(t)})},oa={kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(t,e)=>{const n=e[0];return{indices:()=>Zi(n.shape,"float32")}}},la={kernelName:"OnesLike",gradFunc:t=>({x:()=>rr(t)})};const ua=Rs({unstack_:function(t,e=0){const n=Ms(t,"x","unstack","string_or_numeric");He(e>=-n.shape.length&&e<n.shape.length,(()=>`Axis = ${e} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:e};return Ts.runKernel("Unpack",s,r)}}),ha={kernelName:"Pack",saveAllInputs:!0,gradFunc:(t,e,n)=>{const{axis:s}=n;return ua(t,s).map((t=>()=>t))}},ca={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>ea(t,i,s.shape)}}};const pa=Rs({log_:function(t){const e={x:Ms(t,"x","log","float32")};return Ts.runKernel("Log",e)}});const da=Rs({pow_:function(t,e){let n=Ms(t,"base","pow"),s=Ms(e,"exp","pow");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Pow",r)}}),fa={kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(t,e)=>{const[n,s,r]=e,i=n,a=s,o=Qs(i.shape,a.shape);return{a:()=>{const e=Os(a,"float32");let n=Bs(t,Bs(e,da(i,Js(e,js(1)))));const s=Xs(i.shape,o);return s.length>0&&(n=er(n,s)),tr(n,i.shape)},b:()=>{const e=Fi(i,0),n=Lr(e,pa(i),rr(i));let s=Bs(t,Bs(r,n));const l=Xs(a.shape,o);return l.length>0&&(s=er(s,l)),tr(s,a.shape)}}}},ga={kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(t,e)=>{const[n,s]=e,r=Fi(n,0);return{x:()=>Lr(r,t,Bs(t,s)),alpha:()=>{let e=Lr(r,rr(t),Bs(t,n));const i=Xs(s.shape,t.shape);return i.length>0&&(e=er(e,i)),tr(e,s.shape)}}}};const ma=yn();ma.registerFlag("DEBUG",(()=>!1),(t=>{t&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),ma.registerFlag("IS_BROWSER",(()=>"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope)),ma.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),ma.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),ma.registerFlag("PROD",(()=>!1)),ma.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>ma.getBool("DEBUG"))),ma.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),ma.registerFlag("IS_TEST",(()=>!1)),ma.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),ma.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),ma.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const ba="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function ya(t){return ba?Buffer.byteLength(t):new Blob([t]).size}function wa(t){if(1===t.length)return t[0];let e=0;t.forEach((t=>{e+=t.byteLength}));const n=new Uint8Array(e);let s=0;return t.forEach((t=>{n.set(new Uint8Array(t),s),s+=t.byteLength})),n.buffer}function ka(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,weightsManifest:e};return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),n}function va(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==t.modelTopology?0:ya(JSON.stringify(t.modelTopology)),weightSpecsBytes:null==t.weightSpecs?0:ya(JSON.stringify(t.weightSpecs)),weightDataBytes:null==t.weightData?0:t.weightData.byteLength}}class xa{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==xa.instance&&(xa.instance=new xa),xa.instance}static registerSaveRouter(t){xa.getInstance().saveRouters.push(t)}static registerLoadRouter(t){xa.getInstance().loadRouters.push(t)}static getSaveHandlers(t){return xa.getHandlers(t,"save")}static getLoadHandlers(t,e){return xa.getHandlers(t,"load",e)}static getHandlers(t,e,n){const s=[];return("load"===e?xa.getInstance().loadRouters:xa.getInstance().saveRouters).forEach((e=>{const r=e(t,n);null!==r&&s.push(r)})),s}}class Sa{constructor(t){if(this.indexedDB=function(){if(!yn().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const t="undefined"==typeof window?self:window,e=t.indexedDB||t.mozIndexedDB||t.webkitIndexedDB||t.msIndexedDB||t.shimIndexedDB;if(null==e)throw new Error("The current browser does not appear to support IndexedDB.");return e}(),null==t||!t)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=t}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,t)}async load(){return this.databaseAction(this.modelPath)}databaseAction(t,e){return new Promise(((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>function(t){const e=t.result;e.createObjectStore("models_store",{keyPath:"modelPath"}),e.createObjectStore("model_info_store",{keyPath:"modelPath"})}(s),s.onsuccess=()=>{const r=s.result;if(null==e){const e=r.transaction("models_store","readonly"),s=e.objectStore("models_store").get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));t(s.result.modelArtifacts)},s.onerror=t=>(r.close(),n(s.error)),e.oncomplete=()=>r.close()}else{const s=va(e),i=r.transaction("model_info_store","readwrite");let a=i.objectStore("model_info_store");const o=a.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction("models_store","readwrite");const o=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:e,modelArtifactsInfo:s});o.onsuccess=()=>t({modelArtifactsInfo:s}),o.onerror=t=>{a=i.objectStore("model_info_store");const e=a.delete(this.modelPath);e.onsuccess=()=>(r.close(),n(o.error)),e.onerror=t=>(r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),i.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=t=>n(s.error)}))}}Sa.URL_SCHEME="indexeddb://";const Na=t=>{return yn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Sa.URL_SCHEME)?(e=t.slice(Sa.URL_SCHEME.length),new Sa(e)):null;var e};xa.registerSaveRouter(Na),xa.registerLoadRouter(Na);const Ea="tensorflowjs_models",Ia="info",Aa="model_topology",$a="weight_specs",Ca="weight_data",Ta="model_metadata";class za{constructor(t){if(!yn().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==t||!t)throw new Error("For local storage, modelPath must not be null, undefined or empty.");var e;this.modelPath=t,this.keys=(e=this.modelPath,{info:[Ea,e,Ia].join("/"),topology:[Ea,e,Aa].join("/"),weightSpecs:[Ea,e,$a].join("/"),weightData:[Ea,e,Ca].join("/"),modelMetadata:[Ea,e,Ta].join("/")})}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const e=JSON.stringify(t.modelTopology),n=JSON.stringify(t.weightSpecs),s=va(t);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,e),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(t){if(ba)return Buffer.from(t).toString("base64");const e=new Uint8Array(t);let n="";for(let t=0,s=e.length;t<s;t++)n+=String.fromCharCode(e[t]);return btoa(n)}(t.weightData));const r={format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,signature:null!=t.signature?t.signature:void 0,userDefinedMetadata:null!=t.userDefinedMetadata?t.userDefinedMetadata:void 0,modelInitializer:null!=t.modelInitializer?t.modelInitializer:void 0,trainingConfig:null!=t.trainingConfig?t.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(t){throw function(t){for(const e of Object.values(t))window.localStorage.removeItem(e)}(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const t=JSON.parse(this.LS.getItem(this.keys.info));if(null==t)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==t.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const e={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);e.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);e.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const t=JSON.parse(r);e.format=t.format,e.generatedBy=t.generatedBy,e.convertedBy=t.convertedBy,null!=t.signature&&(e.signature=t.signature),null!=t.userDefinedMetadata&&(e.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(e.modelInitializer=t.modelInitializer),null!=t.trainingConfig&&(e.trainingConfig=t.trainingConfig)}const i=this.LS.getItem(this.keys.weightData);if(null==i)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return e.weightData=function(t){if(ba){const e=Buffer.from(t,"base64");return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}const e=atob(t),n=new Uint8Array(e.length);for(let t=0;t<e.length;++t)n.set([e.charCodeAt(t)],t);return n.buffer}(i),e}}za.URL_SCHEME="localstorage://";const _a=t=>{return yn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(za.URL_SCHEME)?(e=t.slice(za.URL_SCHEME.length),new za(e)):null;var e};xa.registerSaveRouter(_a),xa.registerLoadRouter(_a);function Da(t){return new Promise((t=>setTimeout(t))).then(t)}class Fa{constructor(t){if(!yn().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");t.startsWith(Fa.URL_SCHEME)&&(t=t.slice(Fa.URL_SCHEME.length)),null!=t&&0!==t.length||(t="model"),this.modelJsonFileName=t+".json",this.weightDataFileName=t+".weights.bin"}async save(t){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const e=window.URL.createObjectURL(new Blob([t.weightData],{type:"application/octet-stream"}));if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=ka(t,[{paths:["./"+this.weightDataFileName],weights:t.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Da((()=>r.dispatchEvent(new MouseEvent("click")))),null!=t.weightData){const t=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;t.download=this.weightDataFileName,t.href=e,await Da((()=>t.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:va(t)}}}}Fa.URL_SCHEME="downloads://";function Ma(t,e,n,s){!function(t){He(null!=t&&Array.isArray(t)&&t.length>0,(()=>"promises must be a none empty array"))}(t),function(t,e){He(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${t}`)),He(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${e}`)),He(e>=t,(()=>`startFraction must be no more than endFraction, but got startFraction ${t} and endFraction ${e}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(t.map((i=>(i.then((i=>{const a=n+ ++r/t.length*(s-n);return e(a),i})),i))))}xa.registerSaveRouter((t=>yn().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Fa.URL_SCHEME)?function(t="model"){return new Fa(t)}(t.slice(Fa.URL_SCHEME.length)):null));class La{constructor(t,e){if(this.DEFAULT_METHOD="POST",null==e&&(e={}),this.weightPathPrefix=e.weightPathPrefix,this.onProgress=e.onProgress,this.weightUrlConverter=e.weightUrlConverter,null!=e.fetchFunc?(He("function"==typeof e.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=e.fetchFunc):this.fetch=yn().platform.fetch,He(null!=t&&t.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(t)&&He(2===t.length,(()=>`URL paths for http must have a length of 2, (actual length is ${t.length}).`)),this.path=t,null!=e.requestInit&&null!=e.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=e.requestInit||{}}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const e=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);e.body=new FormData;const n=ka(t,[{paths:["./model.weights.bin"],weights:t.weightSpecs}]);e.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=t.weightData&&e.body.append("model.weights.bin",new Blob([t.weightData],{type:"application/octet-stream"}),"model.weights.bin");const s=await this.fetch(this.path,e);if(s.ok)return{modelArtifactsInfo:va(t),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async load(){const t=await this.fetch(this.path,this.requestInit);if(!t.ok)throw new Error(`Request to ${this.path} failed with status code ${t.status}. Please verify this URL points to the model JSON of the model to load.`);let e;try{e=await t.json()}catch(t){let e=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?e+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":e+=" Please make sure the server is serving valid JSON for this request.",new Error(e)}const n=e.modelTopology,s=e.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return async function(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy};if(null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),null!=t.weightsManifest){const[s,r]=await e(t.weightsManifest);n.weightSpecs=s,n.weightData=r}return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),n}(e,(t=>this.loadWeights(t)))}async loadWeights(t){const e=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(t){const e=t.lastIndexOf("/"),n=t.lastIndexOf("?"),s=t.substring(0,e),r=n>e?t.substring(n):"";return[s+"/",r]}(e),r=this.weightPathPrefix||n,i=[];for(const e of t)i.push(...e.weights);const a=[],o=[];for(const e of t)for(const t of e.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(t)):a.push(r+t+s);this.weightUrlConverter&&a.push(...await Promise.all(o));const l=await async function(t,e){null==e&&(e={});const n=null==e.fetchFunc?yn().platform.fetch:e.fetchFunc,s=t.map((t=>n(t,e.requestInit,{isBinary:!0}))),r=(null==e.onProgress?await Promise.all(s):await Ma(s,e.onProgress,0,.5)).map((t=>t.arrayBuffer()));return null==e.onProgress?await Promise.all(r):await Ma(r,e.onProgress,.5,1)}(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress});return[i,wa(l)]}}function Ra(t){return null!=t.match(La.URL_SCHEME_REGEX)}La.URL_SCHEME_REGEX=/^https?:\/\//;const Oa=(t,e)=>{if("undefined"==typeof fetch&&(null==e||null==e.fetchFunc))return null;{let n=!0;if(n=Array.isArray(t)?t.every((t=>Ra(t))):Ra(t),n)return function(t,e){return new La(t,e)}(t,e)}return null};xa.registerSaveRouter(Oa),xa.registerLoadRouter(Oa);const Ba=Rs({oneHot_:function(t,e,n=1,s=0){if(e<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${e}`);const r={indices:Ms(t,"indices","oneHot","int32")},i={depth:e,onValue:n,offValue:s};return Ts.runKernel("OneHot",r,i)}});let Pa;function Wa(t,e,n){if(e.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if(t.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${t.rank}.`);if("int32"!==e.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${e.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===e.size)throw new Error(`Indices specified for empty output. indices shape: ${e.shape}`);if(0===t.size)throw new Error(`Updates specified for empty output. updates shape: ${t.shape}`)}!function(t,e,n){const s=e.rank>1?e.shape[e.rank-1]:1,r=e.rank>1?e.rank-1:1,i=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${e.shape}, shape: ${t}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(i+` update.rank < ${r}. `);if(t.length<s+(n.rank-r))throw new Error(i+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+t.length-s)throw new Error(i+" update.rank != "+(r+t.length-s));for(let t=0;t<r;++t)if(n.shape[t]!==e.shape[t])throw new Error(i+` updates.shape[${t}] (${n.shape[t]}) != indices.shape[${t}] (${e.shape[t]}).`);for(let e=0;e<n.rank-r;++e)if(n.shape[e+r]!==t[e+s])throw new Error(i+` updates.shape[${e+r}] (${n.shape[e+r]}) != shape[${e+r}] (${t[e+r]})`)}(n,e,t)}Rs({confusionMatrix_:function(t,e,n){const s=Ms(t,"labels","confusionMatrix"),r=Ms(e,"predictions","confusionMatrix");He(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),He(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),He(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),He(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),He(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const i=Ba(Os(s,"int32"),n),a=Ba(Os(r,"int32"),n),o=li(i),l=Nr(o,a);return Os(l,"int32")}}),Rs({fromPixels_:function(t,e=3){if(e>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==t)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,i=!1,a=!1,o=!1;if(t.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&t instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&t instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement)i=!0;else if(null!=t.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${t.constructor.name}`);o=!0}if(r){const e=2;if(r&&t.readyState<e)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=In("FromPixels",Ts.backendName)){const n={pixels:t},s={numChannels:e};return Ts.runKernel("FromPixels",n,s)}const[l,u]=r?[t.videoWidth,t.videoHeight]:[t.width,t.height];let h,c;if(a)h=t.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)h=t.data;else if(i||r||o){if(null==Pa)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Pa=new OffscreenCanvas(1,1).getContext("2d")}else Pa=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Pa.canvas.width=l,Pa.canvas.height=u,Pa.drawImage(t,0,0,l,u),h=Pa.getImageData(0,0,l,u).data}if(4===e)c=new Int32Array(h);else{const t=l*u;c=new Int32Array(t*e);for(let n=0;n<t;n++)for(let t=0;t<e;++t)c[n*e+t]=h[4*n+t]}return function(t,e,n){if(Ze(t),null!=e&&3!==e.length)throw new Error("tensor3d() requires shape to have three numbers");const s=_s(t,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return qs(t,e,s,n)}(c,[u,l,e],"int32")}});class Ua{constructor(){this.classNameMap={}}static getMap(){return null==Ua.instance&&(Ua.instance=new Ua),Ua.instance}static register(t){Ua.getMap().classNameMap[t.className]=[t,t.fromConfig]}}function Ka(t){He(null!=t.className,(()=>"Class being registered does not have the static className property defined.")),He("string"==typeof t.className,(()=>"className is required to be a string, but got type "+typeof t.className)),He(t.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Ua.register(t)}const Va=Rs({abs_:function(t){const e=Ms(t,"x","abs");if("complex64"===e.dtype){const t={x:e};return Ts.runKernel("ComplexAbs",t)}{const t={x:e};return Ts.runKernel("Abs",t)}}});Rs({acos_:function(t){const e={x:Ms(t,"x","acos")};return Ts.runKernel("Acos",e)}}),Rs({acosh_:function(t){const e={x:Ms(t,"x","acosh")};return Ts.runKernel("Acosh",e)}}),Rs({addN_:function(t){He(Array.isArray(t),(()=>"The argument passed to tf.addN() must be a list of tensors")),He(t.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${t.length}`));const e=t.map(((t,e)=>Ms(t,`tensors${e}`,"addN"))),n=e[0];e.forEach((t=>{if(t.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),e.forEach((t=>{if(!Qe(t.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=e;return Ts.runKernel("AddN",s)}}),Rs({all_:function(t,e=null,n=!1){const s={x:Ms(t,"x","all","bool")},r={axis:e,keepDims:n};return Ts.runKernel("All",s,r)}}),Rs({any_:function(t,e=null,n=!1){const s={x:Ms(t,"x","any","bool")},r={axis:e,keepDims:n};return Ts.runKernel("Any",s,r)}}),Rs({argMax_:function(t,e=0){const n={x:Ms(t,"x","argMax")},s={axis:e};return Ts.runKernel("ArgMax",n,s)}}),Rs({argMin_:function(t,e=0){const n={x:Ms(t,"x","argMin")},s={axis:e};return Ts.runKernel("ArgMin",n,s)}}),Rs({asin_:function(t){const e={x:Ms(t,"x","asin")};return Ts.runKernel("Asin",e)}}),Rs({asinh_:function(t){const e={x:Ms(t,"x","asinh")};return Ts.runKernel("Asinh",e)}}),Rs({atan_:function(t){const e={x:Ms(t,"x","atan")};return Ts.runKernel("Atan",e)}}),Rs({atan2_:function(t,e){let n=Ms(t,"a","atan2"),s=Ms(e,"b","atan2");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Atan2",r)}}),Rs({atanh_:function(t){const e={x:Ms(t,"x","atanh")};return Ts.runKernel("Atanh",e)}});const qa=Rs({avgPool_:function(t,e,n,s,r){const i=Ms(t,"x","avgPool","float32");He(yr(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=i,o=!1;3===i.rank&&(o=!0,a=tr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),He(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),wr("avgPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r};let h=Ts.runKernel("AvgPool",l,u);return h=Os(h,i.dtype),o?tr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Rs({avgPool3d_:function(t,e,n,s,r,i="NDHWC"){const a=Ms(t,"x","avgPool3d","float32");let o=a,l=!1;4===a.rank&&(l=!0,o=tr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),He(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),He("NDHWC"===i,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),wr("avgPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i};let c=Ts.runKernel("AvgPool3D",u,h);return c=Os(c,o.dtype),l?tr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const ja=Rs({concat_:function(t,e=0){He(t.length>=1,(()=>"Pass at least one tensor to concat"));const n=Ls(t,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((t=>{if("complex64"!==t.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${t.dtype}. `)})),1===n.length)return Fr(n[0]);const s=n,r={axis:e};return Ts.runKernel("Concat",s,r)}});const Ga=Rs({sigmoid_:function(t){const e={x:Ms(t,"x","sigmoid","float32")};return Ts.runKernel("Sigmoid",e)}});const Ha=Rs({tanh_:function(t){const e={x:Ms(t,"x","tanh","float32")};return Ts.runKernel("Tanh",e)}});Rs({basicLSTMCell_:function(t,e,n,s,r,i){const a=Ms(t,"forgetBias","basicLSTMCell"),o=Ms(e,"lstmKernel","basicLSTMCell"),l=Ms(n,"lstmBias","basicLSTMCell"),u=Ms(s,"data","basicLSTMCell"),h=Ms(r,"c","basicLSTMCell"),c=Ms(i,"h","basicLSTMCell"),p=ja([u,c],1),d=Nr(p,o),f=lr(d,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=ea(f,[0,0],b),w=ea(f,[0,m],b),k=ea(f,[0,2*m],b),v=ea(f,[0,3*m],b),x=lr(Bs(Ga(y),Ha(w)),Bs(h,Ga(lr(a,k))));return[x,Bs(Ha(x),Ga(v))]}});const Ja=Rs({batchToSpaceND_:function(t,e,n){const s=Ms(t,"x","batchToSpaceND"),r=e.reduce(((t,e)=>t*e));He(s.rank>=1+e.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${e.length}`)),He(n.length===e.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${e.length}`)),He(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${e.join(" * ")} === ${r}`));const i={x:s},a={blockShape:e,crops:n};return Ts.runKernel("BatchToSpaceND",i,a)}});const Za=Rs({batchNorm_:function(t,e,n,s,r,i){null==i&&(i=.001);const a=Ms(t,"x","batchNorm"),o=Ms(e,"mean","batchNorm"),l=Ms(n,"variance","batchNorm");let u,h;null!=r&&(u=Ms(r,"scale","batchNorm")),null!=s&&(h=Ms(s,"offset","batchNorm")),He(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),He(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),He(null==u||o.rank===u.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(t){let e;return e=0===t.rank||1===t.rank?tr(t,[1,1,1,t.size]):2===t.rank?tr(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?tr(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t,e}(a),p={x:c,scale:u,offset:h,mean:o,variance:l},d={varianceEpsilon:i},f=Ts.runKernel("FusedBatchNorm",p,d);return tr(f,a.shape)}});Rs({batchNorm2d_:function(t,e,n,s,r,i){const a=Ms(t,"x","batchNorm"),o=Ms(e,"mean","batchNorm"),l=Ms(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ms(r,"scale","batchNorm")),null!=s&&(h=Ms(s,"offset","batchNorm")),He(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),He(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),He(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=u&&He(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=h&&He(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Za(a,o,l,h,u,i)}}),Rs({batchNorm3d_:function(t,e,n,s,r,i){const a=Ms(t,"x","batchNorm"),o=Ms(e,"mean","batchNorm"),l=Ms(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ms(r,"scale","batchNorm")),null!=s&&(h=Ms(s,"offset","batchNorm")),He(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),He(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),He(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=u&&He(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=h&&He(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Za(a,o,l,h,u,i)}}),Rs({batchNorm4d_:function(t,e,n,s,r,i){const a=Ms(t,"x","batchNorm"),o=Ms(e,"mean","batchNorm"),l=Ms(n,"variance","batchNorm");let u,h;return null!=r&&(u=Ms(r,"scale","batchNorm")),null!=s&&(h=Ms(s,"offset","batchNorm")),He(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),He(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),He(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=u&&He(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=h&&He(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Za(a,o,l,h,u,i)}});const Ya=Rs({bincount_:function(t,e,n){const s=Ms(t,"x","bincount"),r=Ms(e,"weights","bincount");He("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),He(n>=0,(()=>`size must be non-negative, but got ${n}.`)),He(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const i={x:s,weights:r},a={size:n};return Ts.runKernel("Bincount",i,a)}});function Xa(t,e="float32",n){return e=e||"float32",fn(t),new fs(t,e,n)}Rs({broadcastArgs_:function(t,e){const n=Ms(t,"s0","broadcastArgs","int32"),s=Ms(e,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return Ts.runKernel("BroadcastArgs",r)}}),Rs({ceil_:function(t){const e={x:Ms(t,"x","ceil","float32")};return Ts.runKernel("Ceil",e)}}),Rs({clipByValue_:function(t,e,n){const s=Ms(t,"x","clipByValue");He(e<=n,(()=>`Error in clip: min (${e}) must be less than or equal to max (${n}).`));const r={x:s},i={clipValueMin:e,clipValueMax:n};return Ts.runKernel("ClipByValue",r,i)}}),Rs({concat1d_:function(t){return ja(t,0)}}),Rs({concat2d_:function(t,e){return ja(t,e)}}),Rs({concat3d_:function(t,e){return ja(t,e)}}),Rs({concat4d_:function(t,e){return ja(t,e)}}),Rs({conv1d_:function(t,e,n,s,r="NWC",i=1,a){const o=Ms(t,"x","conv1d"),l=Ms(e,"filter","conv1d");let u=o,h=!1;2===o.rank&&(h=!0,u=tr(o,[1,o.shape[0],o.shape[1]])),He(3===u.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${u.rank}.`)),He(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),wr("conv1d",s,a),He(u.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${u.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),He(yr(n,i),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${i}'`)),He("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const c=tr(l,[1,l.shape[0],l.shape[1],l.shape[2]]),p=tr(u,[u.shape[0],1,u.shape[1],u.shape[2]]),d=Vr(p,c,[1,n],s,"NHWC",[1,i],a);return tr(d,h?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}}),Rs({conv2dTranspose_:function(t,e,n,s,r,i){const a=Ms(t,"x","conv2dTranspose"),o=Ms(e,"filter","conv2dTranspose");return Ur(n,a,o,s,r,"NHWC",i)}}),Rs({conv3d_:function(t,e,n,s,r="NDHWC",i=[1,1,1]){const a=Ms(t,"x","conv3d"),o=Ms(e,"filter","conv3d");let l=a,u=!1;4===a.rank&&(u=!0,l=tr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),He(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),He(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),He(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),He(yr(n,i),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),He("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:l,filter:o},c={strides:n,pad:s,dataFormat:r,dilations:i},p=Ts.runKernel("Conv3D",h,c);return u?tr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Rs({conv3dTranspose_:function(t,e,n,s,r){const i=Ms(t,"x","conv3dTranspose"),a=Ms(e,"filter","conv3dTranspose");return Gr(n,i,a,s,r)}});const Qa=Rs({cos_:function(t){const e={x:Ms(t,"x","cos","float32")};return Ts.runKernel("Cos",e)}});const to=Rs({cosh_:function(t){const e={x:Ms(t,"x","cosh","float32")};return Ts.runKernel("Cosh",e)}});const eo=Rs({cumprod_:function(t,e=0,n=!1,s=!1){const r={x:Ms(t,"x","cumprod")},i={axis:e,exclusive:n,reverse:s};return Ts.runKernel("Cumprod",r,i)}});Rs({denseBincount_:function(t,e,n,s=!1){const r=Ms(t,"x","denseBincount"),i=Ms(e,"weights","denseBincount");He("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),He(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),He(n>=0,(()=>`size must be non-negative, but got ${n}.`)),He(i.size===r.size||0===i.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${i.shape}.`));const a={x:r,weights:i},o={size:n,binaryOutput:s};return Ts.runKernel("DenseBincount",a,o)}}),Rs({depthToSpace_:function(t,e,n="NHWC"){const s=Ms(t,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],i="NHWC"===n?s.shape[2]:s.shape[3],a="NHWC"===n?s.shape[3]:s.shape[1];He(e>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${e}`)),He(r*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${e}  for depthToSpace with input shape\n    ${s.shape}`)),He(i*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${i} and ${e} for depthToSpace with input shape\n        ${s.shape}`)),He(a%(e*e)==0,(()=>`Dimension size must be evenly divisible by ${e*e} but is ${a} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:e,dataFormat:n};return Ts.runKernel("DepthToSpace",o,l)}});const no=Rs({depthwiseConv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Ms(t,"x","depthwiseConv2d","float32"),l=Ms(e,"filter","depthwiseConv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=tr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),He(4===u.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${u.rank}.`)),He(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const c="NHWC"===r?u.shape[3]:u.shape[1];He(c===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${l.shape[2]}.`)),wr("depthwiseConv2d",s,a);const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ts.runKernel("DepthwiseConv2dNative",p,d);return h?tr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});Rs({diag_:function(t){const e={x:Ms(t,"x","diag")};return Ts.runKernel("Diag",e)}}),Rs({dilation2d_:function(t,e,n,s,r=[1,1],i="NHWC"){const a=Ms(t,"x","dilation2d"),o=Ms(e,"filter","dilation2d");He(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),He(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),He("NHWC"===i,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${i}`));let l=a,u=!1;3===a.rank&&(l=tr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),u=!0);const h={x:l,filter:o},c={strides:n,pad:s,dilations:r},p=Ts.runKernel("Dilation2D",h,c);return u?tr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),Rs({divNoNan_:function(t,e){let n=Ms(t,"a","div"),s=Ms(e,"b","div");[n,s]=Ns(n,s);const r=Ks(n,s),i=rr(r),a=Wi(s,i);return Lr(a,i,r)}}),Rs({dot_:function(t,e){const n=Ms(t,"t1","dot"),s=Ms(e,"t2","dot");He(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],i=1===s.rank?s.size:s.shape[0];if(He(r===i,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${i}.`)),1===n.rank&&1===s.rank){const t=tr(n,[1,-1]),e=tr(s,[-1,1]),r=Nr(t,e);return tr(r,[])}if(1===n.rank&&2===s.rank){const t=tr(n,[1,-1]),e=tr(s,[s.shape[0],s.shape[1]]),r=Nr(t,e);return tr(r,[r.size])}if(2===n.rank&&1===s.rank){const t=tr(s,[-1,1]),e=Nr(n,t);return tr(e,[e.size])}{const t=tr(s,[s.shape[0],s.shape[1]]);return Nr(n,t)}}}),Rs({einsum_:function(t,...e){const n=e.map(((t,e)=>Ms(t,`tensors${e}`,"einsum"))),s={equation:t};return Ts.runKernel("Einsum",n,s)}});const so=Rs({elu_:function(t){const e={x:Ms(t,"x","elu","float32")};return Ts.runKernel("Elu",e)}});Rs({erf_:function(t){let e=Ms(t,"x","erf");He("int32"===e.dtype||"float32"===e.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===e.dtype&&(e=Os(e,"float32"));const n={x:e};return Ts.runKernel("Erf",n)}});const ro=Rs({max_:function(t,e=null,n=!1){const s={x:Ms(t,"x","max")},r={reductionIndices:e,keepDims:n};return Ts.runKernel("Max",s,r)}});const io=Rs({min_:function(t,e=null,n=!1){const s={x:Ms(t,"x","min")},r={axis:e,keepDims:n};return Ts.runKernel("Min",s,r)}});function ao(t,e,n=null){if(0===t.rank)return Va(t);if(1!==t.rank&&null===n)return ao(tr(t,[-1]),e,n);if(1===t.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===e)return er(Va(t),n);if(e===1/0)return ro(Va(t),n);if(e===-1/0)return io(Va(t),n);if("euclidean"===e||2===e)return Gs(er(da(Va(t),js(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}if(Array.isArray(n)&&2===n.length){if(1===e)return ro(er(Va(t),n[0]),n[1]-1);if(e===1/0)return ro(er(Va(t),n[1]),n[0]);if(e===-1/0)return io(er(Va(t),n[1]),n[0]);if("fro"===e||"euclidean"===e)return Gs(er(Hs(t),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const oo=Rs({norm_:function(t,e="euclidean",n=null,s=!1){const r=ao(t=Ms(t,"x","norm"),e,n);let i=r.shape;if(s){const e=nn(n,t.shape);i=Qr(r.shape,e)}return tr(r,i)}});Rs({euclideanNorm_:function(t,e=null,n=!1){return oo(t,"euclidean",e,n)}});const lo=Rs({expandDims_:function(t,e=0){const n=Ms(t,"x","expandDims","string_or_numeric");He(e<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:e};return Ts.runKernel("ExpandDims",s,r)}});Rs({expm1_:function(t){const e={x:Ms(t,"x","expm1")};return Ts.runKernel("Expm1",e)}});const uo=Rs({eye_:function(t,e,n,s="float32"){null==e&&(e=t);const r=Xa([t,e],s),i=t<=e?t:e;for(let t=0;t<i;++t)r.set(1,t,t);const a=tr(r.toTensor(),[t,e]);if(null==n)return a;if(1===n.length)return Si(lo(a,0),[n[0],1,1]);if(2===n.length)return Si(lo(lo(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return Si(lo(lo(lo(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function ho(t,e,n){const s={shape:t,value:e,dtype:n};return Ts.runKernel("Fill",{},s)}const co=Rs({gather_:function(t,e,n=0,s=0){const r={x:Ms(t,"x","gather"),indices:Ms(e,"indices","gather","int32")},i={axis:n,batchDims:s};return Ts.runKernel("GatherV2",r,i)}});Rs({isFinite_:function(t){const e={x:Ms(t,"x","isFinite")};return Ts.runKernel("IsFinite",e)}}),Rs({isInf_:function(t){const e={x:Ms(t,"x","isInf")};return Ts.runKernel("IsInf",e)}}),Rs({isNaN_:function(t){const e={x:Ms(t,"x","isNaN")};return Ts.runKernel("IsNan",e)}});const po=Rs({leakyRelu_:function(t,e=.2){const n={x:Ms(t,"x","leakyRelu")},s={alpha:e};return Ts.runKernel("LeakyRelu",n,s)}});Rs({localResponseNormalization_:function(t,e=5,n=1,s=1,r=.5){const i=Ms(t,"x","localResponseNormalization");He(4===i.rank||3===i.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${i.rank}.`)),He(tn(e),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${e}.`));let a=i,o=!1;3===i.rank&&(o=!0,a=tr(i,[1,i.shape[0],i.shape[1],i.shape[2]]));const l={x:a},u={depthRadius:e,bias:n,alpha:s,beta:r},h=Ts.runKernel("LRN",l,u);return o?tr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const fo=Rs({log1p_:function(t){const e={x:Ms(t,"x","log1p")};return Ts.runKernel("Log1p",e)}});function go(t){return Ts.customGrad(t)}const mo=Rs({softplus_:function(t){const e={x:Ms(t,"x","softplus")};return Ts.runKernel("Softplus",e)}});Rs({logSigmoid_:function(t){const e=Ms(t,"x","logSigmoid"),n=go((t=>({value:Vs(mo(Vs(t))),gradFunc:e=>Bs(e,Ga(Vs(t)))})));return n(e)}}),Rs({logSoftmax_:function(t,e=-1){const n=Ms(t,"logits","logSoftmax");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${e}`);const s=go(((t,n)=>{const s=ro(t,e,!0),r=Js(t,s),i=Js(Os(r,"float32"),pa(er(gi(r),e,!0)));n([i]);return{value:i,gradFunc:(t,n)=>{const[s]=n,r=gi(s);return Js(t,Bs(er(t,e,!0),r))}}}));return s(n)}});const bo=Rs({logSumExp_:function(t,e=null,n=!1){const s=Ms(t,"x","logSumExp"),r=nn(e,s.shape),i=ro(s,r,!0),a=Js(s,i),o=gi(a),l=er(o,r),u=pa(l),h=lr(tr(i,u.shape),u);if(n){const t=Qr(h.shape,r);return tr(h,t)}return h}});const yo=Rs({logicalNot_:function(t){const e={x:Ms(t,"x","logicalNot","bool")};return Ts.runKernel("LogicalNot",e)}});const wo=Rs({logicalOr_:function(t,e){const n=Ms(t,"a","logicalOr","bool"),s=Ms(e,"b","logicalOr","bool");Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("LogicalOr",r)}});Rs({logicalXor_:function(t,e){const n=Ms(t,"a","logicalXor","bool"),s=Ms(e,"b","logicalXor","bool");return Qs(n.shape,s.shape),Dr(wo(t,e),yo(Dr(t,e)))}});Rs({searchSorted_:function(t,e,n="left"){const s=Ms(t,"sortedSequence","searchSorted"),r=Ms(e,"values","searchSorted"),i=s.shape[s.shape.length-1],a=r.shape[r.shape.length-1],o=tr(s,[-1,i]),l=tr(r,[-1,a]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(Xe(l.shape)>=2147483648)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=2147483648)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},h={side:n};return Ts.runKernel("SearchSorted",u,h)}});const ko=Rs({maxPool_:function(t,e,n,s,r){const i=Ms(t,"x","maxPool");let a=i,o=!1;3===i.rank&&(o=!0,a=tr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),He(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),He(yr(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),wr("maxPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r},h=Ts.runKernel("MaxPool",l,u);return o?tr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Rs({maxPool3d_:function(t,e=[1,1,1],n,s,r,i="NDHWC"){const a=Ms(t,"x","maxPool3d");let o=a,l=!1;4===a.rank&&(l=!0,o=tr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),He(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),He("NDHWC"===i,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),wr("maxPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i},c=Ts.runKernel("MaxPool3D",u,h);return l?tr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}}),Rs({maxPoolWithArgmax_:function(t,e,n,s,r=!1){const i={x:Ms(t,"x","maxPoolWithArgmax")},a={filterSize:e,strides:n,pad:s,includeBatchInIndex:r},o=Ts.runKernel("MaxPoolWithArgmax",i,a);return{result:o[0],indexes:o[1]}}});const vo=Rs({maximum_:function(t,e){let n=Ms(t,"a","maximum"),s=Ms(e,"b","maximum");[n,s]=Ns(n,s),"bool"===n.dtype&&(n=Os(n,"int32"),s=Os(s,"int32")),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("Maximum",r)}});const xo=Rs({mean_:function(t,e=null,n=!1){const s={x:Ms(t,"x","mean")},r={axis:e,keepDims:n};return Ts.runKernel("Mean",s,r)}});const So=Rs({minimum_:function(t,e){let n=Ms(t,"a","minimum"),s=Ms(e,"b","minimum");[n,s]=Ns(n,s),"bool"===n.dtype&&(n=Os(n,"int32"),s=Os(s,"int32")),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("Minimum",r)}});Rs({mirrorPad_:function(t,e,n){He("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=Ms(t,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");He(e.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${e.length}.`));const r="reflect"===n?1:0;for(let t=0;t<s.rank;t++)He(2===e[t].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),He(e[t][0]>=0&&e[t][0]<=s.shape[t]-r&&e[t][1]>=0&&e[t][1]<=s.shape[t]-r,(()=>`Padding in dimension ${t} cannot be greater than or equal to ${s.shape[t]-r} or less than 0 for input of shape ${s.shape}`));const i={paddings:e,mode:n},a={x:s};return Ts.runKernel("MirrorPad",a,i)}}),Rs({mod_:function(t,e){let n=Ms(t,"a","mod"),s=Ms(e,"b","mod");[n,s]=Ns(n,s);const r={a:n,b:s};return Ts.runKernel("Mod",r)}}),Rs({moments_:function(t,e=null,n=!1){const s=nn(e,(t=Ms(t,"x","moments")).shape),r=xo(t,s,n);let i=r.shape;n||(i=Qr(r.shape,s));const a=Hs(Js(Os(t,"float32"),tr(r,i)));return{mean:r,variance:xo(a,s,n)}}}),Rs({multiRNNCell_:function(t,e,n,s){const r=Ms(e,"data","multiRNNCell"),i=Ls(n,"c","multiRNNCell"),a=Ls(s,"h","multiRNNCell");let o=r;const l=[];for(let e=0;e<t.length;e++){const n=t[e](o,i[e],a[e]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],h=[];for(let t=0;t<l.length;t+=2)u.push(l[t]),h.push(l[t+1]);return[u,h]}}),Rs({multinomial_:function(t,e,n,s=!1){const r=Ms(t,"logits","multinomial"),i=r.size,a=r.rank;if(i<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${i}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const o={logits:1===a?tr(r,[1,-1]):r},l={numSamples:e,seed:n,normalized:s},u=Ts.runKernel("Multinomial",o,l);return 1===a?tr(u,[u.size]):u}});const No=Rs({notEqual_:function(t,e){let n=Ms(t,"a","notEqual","string_or_numeric"),s=Ms(e,"b","notEqual","string_or_numeric");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("NotEqual",r)}});Rs({onesLike_:function(t){const e={x:Ms(t,"x","onesLike")};return Ts.runKernel("OnesLike",e)}}),Rs({outerProduct_:function(t,e){const n=Ms(t,"v1","outerProduct"),s=Ms(e,"v2","outerProduct");He(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=tr(n,[-1,1]),i=tr(s,[1,-1]);return Nr(r,i)}});const Eo=Rs({pad_:function(t,e,n=0){const s=Ms(t,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:e,constantValue:n},i={x:s};return Ts.runKernel("PadV2",i,r)}});Rs({pad1d_:function(t,e,n=0){return He(2===e.length,(()=>"Invalid number of paddings. Must be length of 2.")),Eo(t,[e],n)}}),Rs({pad2d_:function(t,e,n=0){return He(2===e.length&&2===e[0].length&&2===e[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Eo(t,e,n)}}),Rs({pad3d_:function(t,e,n=0){return He(3===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Eo(t,e,n)}}),Rs({pad4d_:function(t,e,n=0){return He(4===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length&&2===e[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Eo(t,e,n)}}),Rs({pool_:function(t,e,n,s,r,i,a){null==r&&(r=[1,1]),null==i&&(i=1),0===s&&(s="valid");const o=Ms(t,"x","maxPool");let l=o,u=!1;3===o.rank&&(u=!0,l=tr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),He(yr(i,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${i} and dilations '${r}'`));const h=function(t,e,n,s,r,i,a="channelsLast"){const[o,l]=fr(e);let u;if("channelsLast"===a)u=[o,l,t[3],t[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[o,l,t[1],t[1]]}return dr(t,u,n,s,r,i,!1,a)}(l.shape,e,i,r,s),c=[h.dilationHeight,h.dilationWidth];let p;p="same"===s?function(t,e){const n=t.map(((t,n)=>t+(t-1)*(e[n]-1))).map((t=>t-1)),s=n.map((t=>Math.floor(t/2))),r=n.map(((t,e)=>t-s[e]));return n.map(((t,e)=>[s[e],r[e]]))}([h.filterHeight,h.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[f,g]=function(t,e,n){const s=n.map((t=>t[0])),r=n.map((t=>t[1])),i=t.concat(s,r),a=e.map(((t,e)=>(t-i[e]%t)%t)),o=r.map(((t,e)=>t+a[e])),l=e.map(((t,e)=>[s[e],o[e]])),u=e.map(((t,e)=>[0,a[e]]));return[l,u]}([h.inHeight,h.inWidth],c,p),m=d?s:"valid",b=d?l:Ir(l,c,f),y=("avg"===n?()=>qa(b,e,i,m,a):()=>ko(b,e,i,m,a))(),w=d?y:Ja(y,c,g);return u?tr(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Io=Rs({prelu_:function(t,e){const n={x:Ms(t,"x","prelu"),alpha:Ms(e,"alpha","prelu")};return Ts.runKernel("Prelu",n)}});Rs({prod_:function(t,e=null,n=!1){let s=Ms(t,"x","prod");"bool"===s.dtype&&(s=Os(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ts.runKernel("Prod",r,i)}}),Rs({rand_:function(t,e,n){const s=Xe(t);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let t=0;t<s;t++)r[t]=e();return Ts.makeTensor(r,t,n)}});var Ao="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function $o(t){if(t.__esModule)return t;var e=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(t).forEach((function(n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})})),e}function Co(t){var e={exports:{}};return t(e,e.exports),e.exports}var To=Co((function(t){!function(t,e,n){function s(t){var e,n=this,s=(e=4022871197,function(t){t=String(t);for(var n=0;n<t.length;n++){var s=.02519603282416938*(e+=t.charCodeAt(n));s-=e=s>>>0,e=(s*=e)>>>0,e+=4294967296*(s-=e)}return 2.3283064365386963e-10*(e>>>0)});n.next=function(){var t=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=t-(n.c=0|t)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(t),n.s0<0&&(n.s0+=1),n.s1-=s(t),n.s1<0&&(n.s1+=1),n.s2-=s(t),n.s2<0&&(n.s2+=1),s=null}function r(t,e){return e.c=t.c,e.s0=t.s0,e.s1=t.s1,e.s2=t.s2,e}function i(t,e){var n=new s(t),i=e&&e.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.alea=i}(0,t,!1)})),zo=Co((function(t){!function(t,e,n){function s(t){var e=this,n="";e.x=0,e.y=0,e.z=0,e.w=0,e.next=function(){var t=e.x^e.x<<11;return e.x=e.y,e.y=e.z,e.z=e.w,e.w^=e.w>>>19^t^t>>>8},t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor128=i}(0,t,!1)})),_o=Co((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.x^e.x>>>2;return e.x=e.y,e.y=e.z,e.z=e.w,e.w=e.v,(e.d=e.d+362437|0)+(e.v=e.v^e.v<<4^t^t<<1)|0},e.x=0,e.y=0,e.z=0,e.w=0,e.v=0,t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),s==n.length&&(e.d=e.x<<10^e.x>>>4),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e.v=t.v,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorwow=i}(0,t,!1)})),Do=Co((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.x,r=e.i;return t=s[r],n=(t^=t>>>7)^t<<24,n^=(t=s[r+1&7])^t>>>10,n^=(t=s[r+3&7])^t>>>3,n^=(t=s[r+4&7])^t<<7,t=s[r+7&7],n^=(t^=t<<13)^t<<9,s[r]=n,e.i=r+1&7,n},function(t,e){var n,s=[];if(e===(0|e))s[0]=e;else for(e=""+e,n=0;n<e.length;++n)s[7&n]=s[7&n]<<15^e.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n&&(s[7]=-1),t.x=s,t.i=0,n=256;n>0;--n)t.next()}(e,t)}function r(t,e){return e.x=t.x.slice(),e.i=t.i,e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.x&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorshift7=i}(0,t,!1)})),Fo=Co((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.w,r=e.X,i=e.i;return e.w=s=s+1640531527|0,n=r[i+34&127],t=r[i=i+1&127],n^=n<<13,t^=t<<17,n^=n>>>15,t^=t>>>12,n=r[i]=n^t,e.i=i,n+(s^s>>>16)|0},function(t,e){var n,s,r,i,a,o=[],l=128;for(e===(0|e)?(s=e,e=null):(e+="\0",s=0,l=Math.max(l,e.length)),r=0,i=-32;i<l;++i)e&&(s^=e.charCodeAt((i+32)%e.length)),0===i&&(a=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,i>=0&&(a=a+1640531527|0,r=0==(n=o[127&i]^=s+a)?r+1:0);for(r>=128&&(o[127&(e&&e.length||0)]=-1),r=127,i=512;i>0;--i)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;t.w=a,t.X=o,t.i=r}(e,t)}function r(t,e){return e.i=t.i,e.w=t.w,e.X=t.X.slice(),e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.X&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor4096=i}(0,t,!1)})),Mo=Co((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.b,n=e.c,s=e.d,r=e.a;return t=t<<25^t>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-t|0,e.b=t=t<<20^t>>>12^n,e.c=n=n-s|0,e.d=s<<16^n>>>16^r,e.a=r-t|0},e.a=0,e.b=0,e.c=-1640531527,e.d=1367130551,t===Math.floor(t)?(e.a=t/4294967296|0,e.b=0|t):n+=t;for(var s=0;s<n.length+20;s++)e.b^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.tychei=i}(0,t,!1)})),Lo=$o({__proto__:null,default:{}}),Ro=Co((function(t){!function(e,n,s){var r,i=256,a=s.pow(i,6),o=s.pow(2,52),l=2*o,u=255;function h(t,u,h){var m=[],b=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[t,g(n)]:null==t?function(){try{var t;return r&&(t=r.randomBytes)?t=t(i):(t=new Uint8Array(i),(e.crypto||e.msCrypto).getRandomValues(t)),g(t)}catch(t){var s=e.navigator,a=s&&s.plugins;return[+new Date,e,a,e.screen,g(n)]}}():t,3),m),y=new c(m),w=function(){for(var t=y.g(6),e=a,n=0;t<o;)t=(t+n)*i,e*=i,n=y.g(1);for(;t>=l;)t/=2,e/=2,n>>>=1;return(t+n)/e};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,f(g(y.S),n),(u.pass||h||function(t,e,n,r){return r&&(r.S&&p(r,y),t.state=function(){return p(y,{})}),n?(s.random=t,e):t})(w,b,"global"in u?u.global:this==s,u.state)}function c(t){var e,n=t.length,s=this,r=0,a=s.i=s.j=0,o=s.S=[];for(n||(t=[n++]);r<i;)o[r]=r++;for(r=0;r<i;r++)o[r]=o[a=u&a+t[r%n]+(e=o[r])],o[a]=e;(s.g=function(t){for(var e,n=0,r=s.i,a=s.j,o=s.S;t--;)e=o[r=u&r+1],n=n*i+o[u&(o[r]=o[a=u&a+e])+(o[a]=e)];return s.i=r,s.j=a,n})(i)}function p(t,e){return e.i=t.i,e.j=t.j,e.S=t.S.slice(),e}function d(t,e){var n,s=[],r=typeof t;if(e&&"object"==r)for(n in t)try{s.push(d(t[n],e-1))}catch(t){}return s.length?s:"string"==r?t:t+"\0"}function f(t,e){for(var n,s=t+"",r=0;r<s.length;)e[u&r]=u&(n^=19*e[u&r])+s.charCodeAt(r++);return g(e)}function g(t){return String.fromCharCode.apply(0,t)}if(f(s.random(),n),t.exports){t.exports=h;try{r=Lo}catch(t){}}else s.seedrandom=h}("undefined"!=typeof self?self:Ao,[],Math)}));Ro.alea=To,Ro.xor128=zo,Ro.xorwow=_o,Ro.xorshift7=Do,Ro.xor4096=Fo,Ro.tychei=Mo;var Oo=Ro;class Bo{constructor(t,e,n,s,r){this.mean=t,this.stdDev=e,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const i=r||Math.random();this.random=Oo.alea(i.toString())}nextValue(){if(!isNaN(this.nextVal)){const t=this.nextVal;return this.nextVal=NaN,t}let t,e,n=!1;for(;!n;){let s,r,i;do{s=2*this.random()-1,r=2*this.random()-1,i=s*s+r*r}while(i>=1||0===i);const a=Math.sqrt(-2*Math.log(i)/i);t=this.mean+this.stdDev*s*a,e=this.mean+this.stdDev*r*a,this.truncated&&!this.isValidTruncated(t)||(n=!0)}return this.truncated&&!this.isValidTruncated(e)||(this.nextVal=this.convertValue(e)),this.convertValue(t)}convertValue(t){return null==this.dtype||"float32"===this.dtype?t:Math.round(t)}isValidTruncated(t){return t<=this.upper&&t>=this.lower}}class Po{constructor(t,e,n,s){this.alpha=t,this.beta=1/e,this.dtype=n;const r=s||Math.random();this.randu=Oo.alea(r.toString()),this.randn=new Bo(0,1,n,!1,this.randu()),this.d=t<1?t+2/3:t-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let t,e,n,s,r,i;for(;;){do{s=this.randn.nextValue(),i=1+this.c*s}while(i<=0);if(i*=i*i,t=s*s,e=1-.331*t*t,n=.5*t+this.d*(1-i+Math.log(i)),r=this.randu(),r<e||Math.log(r)<n)break}return i=1/this.beta*this.d*i,this.alpha<1&&(i*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(i)}convertValue(t){return"float32"===this.dtype?t:Math.round(t)}}class Wo{constructor(t=0,e=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=t,this.range=e-t,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${t} - ${e} <= 1 and dtype is not float`);this.random=Oo.alea(s)}convertValue(t){return this.canReturnFloat()?t:Math.round(t)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}Rs({randomGamma_:function(t,e,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const i=new Po(e,n,s,r),a=Xa(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});const Uo=Rs({randomNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const i=new Bo(e,n,s,!1,r),a=Xa(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});Rs({randomStandardNormal_:function(t,e,n){if(null!=e&&"bool"===e)throw new Error(`Unsupported data type ${e}`);return Uo(t,0,1,e,n)}});const Ko=Rs({randomUniform_:function(t,e=0,n=1,s="float32",r){const i=Xa(t,s),a=new Wo(e,n,null,r);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});function Vo(t,e,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:t,stop:e,step:n,dtype:s};return Ts.runKernel("Range",{},r)}Rs({reciprocal_:function(t){const e={x:Ms(t,"x","reciprocal")};return Ts.runKernel("Reciprocal",e)}});const qo=Rs({relu_:function(t){const e={x:Ms(t,"x","relu")};return Ts.runKernel("Relu",e)}});const jo=Rs({relu6_:function(t){const e={x:Ms(t,"x","relu6")};return Ts.runKernel("Relu6",e)}});const Go=Rs({reverse_:function(t,e){const n={x:Ms(t,"x","reverse")},s={dims:e};return Ts.runKernel("Reverse",n,s)}});Rs({reverse1d_:function(t){const e=Ms(t,"x","reverse");return He(1===e.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${e.rank}.`)),Go(e,0)}}),Rs({reverse2d_:function(t,e){const n=Ms(t,"x","reverse");return He(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Go(n,e)}}),Rs({reverse3d_:function(t,e){const n=Ms(t,"x","reverse");return He(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Go(n,e)}}),Rs({reverse4d_:function(t,e){const n=Ms(t,"x","reverse");return He(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Go(n,e)}});const Ho=Rs({round_:function(t){const e={x:Ms(t,"x","round")};return Ts.runKernel("Round",e)}});Rs({selu_:function(t){const e={x:Ms(t,"x","selu")};return Ts.runKernel("Selu",e)}}),Rs({separableConv2d_:function(t,e,n,s,r,i=[1,1],a="NHWC"){const o=Ms(t,"x","separableConv2d"),l=Ms(e,"depthwiseFilter","separableConv2d"),u=Ms(n,"pointwiseFilter","separableConv2d");let h=o,c=!1;if(3===o.rank&&(c=!0,h=tr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");He(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),He(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),He(4===u.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),He(1===u.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${u.shape[0]}.`)),He(1===u.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${u.shape[1]}.`));const p=l.shape[2],d=l.shape[3];He(u.shape[2]===p*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*d}, but got ${u.shape[2]}.`));const f=no(h,l,s,r,a,i),g=Vr(f,u,1,"valid",a);return c?tr(g,[g.shape[1],g.shape[2],g.shape[3]]):g}}),Rs({sign_:function(t){const e={x:Ms(t,"x","sign")};return Ts.runKernel("Sign",e)}}),Rs({slice1d_:function(t,e,n){const s=Ms(t,"x","slice1d");return He(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),ea(s,[e],[n])}}),Rs({slice2d_:function(t,e,n){const s=Ms(t,"x","slice2d");return He(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),ea(s,e,n)}}),Rs({slice3d_:function(t,e,n){const s=Ms(t,"x","slice3d");return He(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),ea(s,e,n)}}),Rs({slice4d_:function(t,e,n){const s=Ms(t,"x","slice4d");return He(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),ea(s,e,n)}}),Rs({softmax_:function(t,e=-1){const n=Ms(t,"logits","softmax","float32");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${e}`);const s={logits:n},r={dim:e};return Ts.runKernel("Softmax",s,r)}});const Jo=Rs({fft_:function(t){He("complex64"===t.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ts.runKernel("FFT",e)}});const Zo=Rs({ifft_:function(t){He("complex64"===t.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ts.runKernel("IFFT",e)}});Rs({irfft_:function(t){const e=t.shape[t.shape.length-1],n=t.size/e;let s;if(e<=2){const r=tr(t,[n,e]);s=Zo(r)}else{const r=[n,2*(e-1)],i=tr(oi(t),[n,e]),a=tr(ai(t),[n,e]),o=Go(ea(i,[0,1],[n,e-2]),1),l=Bs(Go(ea(a,[0,1],[n,e-2]),1),js(-1)),u=ja([i,o],1),h=ja([a,l],1),c=tr(ii(u,h),[r[0],r[1]]);s=Zo(c)}if(s=oi(s),3===t.rank&&0!==t.shape[0]){const e=s,n=t.shape[0];s=tr(s,[n,s.shape[0]/n,s.shape[1]]),e.dispose()}return s}});const Yo=Rs({rfft_:function(t,e){He("float32"===t.dtype,(()=>`The dtype for rfft() must be real value but got ${t.dtype}`));let n=t.shape[t.shape.length-1];const s=t.size/n;let r;if(null!=e&&e<n){const s=t.shape.map((t=>0)),i=t.shape.map((t=>t));i[t.shape.length-1]=e,r=ea(t,s,i),n=e}else if(null!=e&&e>n){const s=t.shape.map((t=>t));s[t.shape.length-1]=e-n,r=ja([t,Zi(s)],t.shape.length-1),n=e}else r=t;const i=rr(r),a=tr(ii(r,i),[s,n]),o=Jo(a),l=Math.floor(n/2)+1,u=oi(o),h=ai(o),c=Br(u,[l,n-l],u.shape.length-1),p=Br(h,[l,n-l],h.shape.length-1),d=r.shape.slice();return d[r.shape.length-1]=l,tr(ii(c[0],p[0]),d)}});const Xo=Rs({squaredDifference_:function(t,e){let n=Ms(t,"a","squaredDifference"),s=Ms(e,"b","squaredDifference");[n,s]=Ns(n,s),Qs(n.shape,s.shape);const r={a:n,b:s};return Ts.runKernel("SquaredDifference",r,{})}});const Qo=Rs({squeeze_:function(t,e){const n=Ms(t,"x","squeeze","string_or_numeric");return tr(n,function(t,e){const n=[],s=[],r=null!=e&&Array.isArray(e)&&0===e.length,i=null==e||r?null:nn(e,t).sort();let a=0;for(let e=0;e<t.length;++e){if(null!=i){if(i[a]===e&&1!==t[e])throw new Error(`Can't squeeze axis ${e} since its dim '${t[e]}' is not 1`);(null==i[a]||i[a]>e)&&1===t[e]&&(n.push(t[e]),s.push(e)),i[a]<=e&&a++}1!==t[e]&&(n.push(t[e]),s.push(e))}return{newShape:n,keptDims:s}}(n.shape,e).newShape)}});const tl=Rs({stack_:function(t,e=0){const n=Ls(t,"tensors","stack","string_or_numeric");He(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&He(e<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:e};return Ts.runKernel("Pack",s,r)}});function el(t,e){Ze(t);const n=_s(t,e);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return qs(t,null,n,e)}function nl(t,e,n){if(Ze(t),null!=e&&2!==e.length)throw new Error("tensor2d() requires shape to have two numbers");const s=_s(t,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return qs(t,e,s,n)}function sl(t,e,n){const s=1-t%2,r=new Float32Array(t);for(let i=0;i<t;++i){const a=2*Math.PI*i/(t+s-1);r[i]=e-n*Math.cos(a)}return el(r,"float32")}function rl(t,e,n){if(null==n||"linear"===n)return t;if("relu"===n)return Bs(t,Ps(e));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function il(t,e){let n=e;const s=Xs(t.shape,e.shape);return s.length>0&&(n=er(n,s)),tr(n,t.shape)}function al(t,e,n,s){if("linear"===e)return t;if("relu"===e)return qo(t);if("elu"===e)return so(t);if("relu6"===e)return jo(t);if("prelu"===e)return Io(t,n);if("leakyrelu"===e)return po(t,s);if("sigmoid"===e)return Ga(t);throw new Error(`Unknown fused activation ${e}.`)}Rs({stridedSlice_:function(t,e,n,s,r=0,i=0,a=0,o=0,l=0){const u={x:Ms(t,"x","stridedSlice","string_or_numeric")},h={begin:e,end:n,strides:s,beginMask:r,endMask:i,ellipsisMask:a,newAxisMask:o,shrinkAxisMask:l};return Ts.runKernel("StridedSlice",u,h)}}),Rs({tan_:function(t){const e={x:Ms(t,"x","tan","float32")};return Ts.runKernel("Tan",e)}}),Rs({topk_:function(t,e=1,n=!0){const s=Ms(t,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(e<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${e}`);if(e>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${e}`);const i={x:s},a={k:e,sorted:n},[o,l]=Ts.runKernel("TopK",i,a);return{values:o,indices:l}}}),Rs({truncatedNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const i=new Bo(e,n,s,!0,r),a=Xa(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}}),Rs({unique_:function(t,e=0){const n=Ms(t,"x","unique","string_or_numeric");He(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:e},[i,a]=Ts.runKernel("Unique",s,r);return{values:i,indices:a}}}),Rs({movingAverage_:function(t,e,n,s,r=!0){const i=Ms(t,"v","movingAverage"),a=Ms(e,"x","movingAverage"),o=Ms(n,"decay","movingAverage");var l,u;u=a,He((l=i).dtype===u.dtype,(()=>`The dtypes of the first(${l.dtype}) and second(${u.dtype}) input must match`)),He(Qe(i.shape,a.shape),(()=>"Shape mismatch in v and x"));const h=js(1),c=Js(h,o);let p=Bs(Js(a,i),c);if(r){He(null!=s,(()=>"When using zeroDebias: true, step is required."));const t=Ms(s,"step","movingAverage");p=Ks(p,Js(h,da(o,t)))}return lr(i,p)}}),Rs({scatterND_:function(t,e,n){const s=Ms(t,"indices","scatterND","int32"),r=Ms(e,"updates","scatterND");Wa(r,s,n);const i={indices:s,updates:r},a={shape:n};return Ts.runKernel("ScatterNd",i,a)}}),Rs({sparseToDense_:function(t,e,n,s=0){const r=Ms(t,"sparseIndices","sparseToDense","int32"),i=Ms(e,"sparseValues","sparseToDense","string_or_numeric"),a=Ms(s,"defaultValue","sparseToDense",i.dtype);!function(t,e,n,s){if("int32"!==t.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${t.shape}.`);const r=t.rank>0?t.shape[0]:1,i=t.rank>1?t.shape[1]:1;if(n.length!==i)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${i}.`);const a=e.size;if(0!==e.rank&&(1!==e.rank||a!==r))throw new Error(`sparseValues has incorrect shape ${e.shape}, should be [] or [${r}]`);if(e.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,i,n,a);const o={sparseIndices:r,sparseValues:i,defaultValue:a},l={outputShape:n};return Ts.runKernel("SparseToDense",o,l)}}),Rs({gatherND_:function(t,e){const n=Ms(e,"indices","gatherND","int32"),s={params:Ms(t,"x","gatherND","string_or_numeric"),indices:n};return Ts.runKernel("GatherNd",s)}}),Rs({dropout_:function(t,e,n,s){const r=Ms(t,"x","dropout");if(He("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),He(e>=0&&e<1,(()=>`rate must be a float in the range [0, 1), but got ${e}.`)),0===e)return t instanceof ms?r.clone():r;const i=function(t,e){if(null==e)return t.shape.slice();if(Qe(t.shape,e))return e;if(t.shape.length===e.length){const n=[];for(let s=0;s<t.shape.length;s++)null==e[s]&&null!=t.shape[s]?n.push(t.shape[s]):n.push(e[s]);return n}return e}(r,n),a=1-e,o=Ks(sa(lr(Ko(i,0,1,"float32",s),a)),a);return Bs(r,o)}});const ol=(t,e)=>!(t>0)||"linear"===e;Rs({fusedConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(l=l||"linear",!1===ol(Ts.state.gradientDepth,l)){He("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Vr(t,e,n,s,r,i,a);return null!=o&&(c=lr(c,o)),al(c,l,u,h)}const c=Ms(t,"x","conv2d","float32"),p=Ms(e,"filter","conv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=tr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),He(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),He(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),wr("fused conv2d",s,a);const g="NHWC"===r?d.shape[3]:d.shape[1];He(p.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${p.shape[2]}.`)),He(yr(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const m=dr(d.shape,p.shape,n,i,s,a);let b,y;if(null!=o&&(b=Ms(o,"bias","fused conv2d"),[b]=Ns(b,c),"NHWC"===r?Qs(m.outShape,b.shape):(He(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),He(0===b.shape.length||b.shape[0]===m.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${m.outChannels})`)))),null!=u){const t=u.shape;if(He(t.length<=1||3===t.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${t.length}.`)),1===t.length)He(1===t[0]||t[0]===m.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the number of output channels (${m.outChannels}).`));else if(3===t.length)try{Qs(t,m.outShape)}catch(e){const n=`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the output shape of the conv2d (${m.outShape}).`;throw Error(n)}y=Ms(u,"prelu weights","fused conv2d")}const w=(t,e)=>{He("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[a,o,u,h]=e,c=rl(t,u,l);He(br(i),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`));const p=[Ur(o.shape,c,a,n,s),Wr(o,c,a.shape,n,s)];if(null!=h){const t=il(h,c);p.push(t)}return p},k={x:d,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=go(((t,e,n)=>{let s=Ts.runKernel("FusedConv2D",k,v);return n([e,t,s]),f&&(s=tr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return t(d,p)}{const t=go(((t,e,n,s)=>{let r=Ts.runKernel("FusedConv2D",k,v);return s([e,t,r,n]),f&&(r=tr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return t(d,p,b)}}}),Rs({fusedDepthwiseConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(!1===ol(Ts.state.gradientDepth,l)){let c=no(t,e,n,s,r,i,a);return null!=o&&(c=lr(c,o)),al(c,l,u,h)}const c=Ms(t,"x","depthwiseConv2d","float32"),p=Ms(e,"filter","depthwiseConv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=tr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),He(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),He(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),He(d.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==i&&(i=[1,1]),He(yr(n,i),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),wr("fused depthwiseConv2d",s,a);const g=dr(d.shape,p.shape,n,i,s,a,!0);let m,b;null!=o&&(m=Ms(o,"bias","fused conv2d"),[m]=Ns(m,c),Qs(g.outShape,m.shape)),null!=u&&(b=Ms(u,"prelu weights","fused depthwiseConv2d"));const y=(t,e)=>{He(br(i),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${i}'`));const[r,o,u,h]=e,c=rl(t,u,l),p=ci(o.shape,c,r,n,s,i,a),d=hi(o,c,r.shape,n,s,i,a);if(null!=h){return[p,d,il(m,c)]}return[p,d]},w={x:d,filter:p,bias:m,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=go(((t,e,n)=>{let s=Ts.runKernel("FusedDepthwiseConv2D",w,k);return n([e,t,s]),f&&(s=tr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:y}}));return t(d,p)}{const t=go(((t,e,n,s)=>{let r=Ts.runKernel("FusedDepthwiseConv2D",w,k);return s([e,t,r,n]),f&&(r=tr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:y}}));return t(d,p,m)}}}),Rs({fusedMatMul_:function({a:t,b:e,transposeA:n=!1,transposeB:s=!1,bias:r,activation:i="linear",preluActivationWeights:a,leakyreluAlpha:o=.2}){if(!1===ol(Ts.state.gradientDepth,i)){let l=Nr(t,e,n,s);return null!=r&&(l=lr(l,r)),al(l,i,a,o)}let l=Ms(t,"a","fused matMul"),u=Ms(e,"b","fused matMul");[l,u]=Ns(l,u);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],c=s?u.shape[u.rank-1]:u.shape[u.rank-2],p=n?l.shape[l.rank-1]:l.shape[l.rank-2],d=s?u.shape[u.rank-2]:u.shape[u.rank-1],f=l.shape.slice(0,-2),g=u.shape.slice(0,-2),m=Xe(f),b=Xe(g);He(h===c,(()=>`Error in fused matMul: inner shapes (${h}) and (${c}) of Tensors with shapes ${l.shape} and ${u.shape} and transposeA=${n} and transposeB=${s} must match.`));const y=Qs(l.shape.slice(0,-2),u.shape.slice(0,-2)).concat([p,d]),w=tr(l,n?[m,h,p]:[m,p,h]),k=tr(u,s?[b,d,c]:[b,c,d]);let v,x;null!=r&&(v=Ms(r,"bias","fused matMul"),[v]=Ns(v,l),Qs(y,v.shape)),null!=a&&(x=Ms(a,"prelu weights","fused matMul"));const S=(t,e)=>{const[a,o,l,u]=e,h=rl(tr(t,l.shape),l,i);let c,p;if(n||s?!n&&s?(c=Nr(h,o,!1,!1),p=Nr(h,a,!0,!1)):n&&!s?(c=Nr(o,h,!1,!0),p=Nr(a,h,!1,!1)):(c=Nr(o,h,!0,!0),p=Nr(h,a,!0,!0)):(c=Nr(h,o,!1,!0),p=Nr(a,h,!0,!1)),null!=r){return[c,p,il(u,h)]}return[c,p]},N={a:w,b:k,bias:v,preluActivationWeights:x},E={transposeA:n,transposeB:s,activation:i,leakyreluAlpha:o};if(null==r){const t=go(((t,e,n)=>{const s=Ts.runKernel("_FusedMatMul",N,E);return n([t,e,s]),{value:tr(s,y),gradFunc:S}}));return t(w,k)}{const t=go(((t,e,n,s)=>{const r=Ts.runKernel("_FusedMatMul",N,E);return s([t,e,r,n]),{value:tr(r,y),gradFunc:S}}));return t(w,k,v)}}}),Rs({hammingWindow_:function(t){return sl(t,.54,.46)}});const ll=Rs({hannWindow_:function(t){return sl(t,.5,.5)}});const ul=Rs({frame_:function(t,e,n,s=!1,r=0){let i=0;const a=[];for(;i+e<=t.size;)a.push(ea(t,i,e)),i+=n;if(s)for(;i<t.size;){const s=i+e-t.size,o=ja([ea(t,i,e-s),ho([s],r)]);a.push(o),i+=n}return 0===a.length?nl([],[0,e]):tr(ja(a),[a.length,e])}});function hl(t,e,n,s,r,i){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==i&&(i=0);const a=t.shape[0];return n=Math.min(n,a),He(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),He(2===t.rank,(()=>`boxes must be a 2D tensor, but was of rank '${t.rank}'`)),He(4===t.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${t.shape[1]}`)),He(1===e.rank,(()=>"scores must be a 1D tensor")),He(e.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${e.shape[0]}`)),He(0<=i&&i<=1,(()=>`softNmsSigma must be in [0, 1], but was '${i}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:i}}function cl(t,e=!1){return Ts.tidy((()=>{He(2===t.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${t.shape.length}D Tensor.`));const n=t.shape[0],s=t.shape[1];let r=uo(n),i=Fr(t);const a=nl([[1]],[1,1]);let o=Fr(a);const l=n>=s?s:n;for(let t=0;t<l;++t){const e=i,l=o,u=r;[o,i,r]=Ts.tidy((()=>{const e=ea(i,[t,t],[n-t,1]),l=oo(e),u=ea(i,[t,t],[1,1]),h=Lr(Fi(u,0),nl([[-1]]),nl([[1]])),c=Js(u,Bs(h,l)),p=Ks(e,c);o=1===p.shape[0]?Fr(a):ja([a,ea(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=Vs(Ks(Nr(h,c),l)),f=ea(i,[t,0],[n-t,s]),g=Bs(d,o),m=li(o);if(0===t)i=Js(f,Nr(g,Nr(m,f)));else{const e=Js(f,Nr(g,Nr(m,f)));i=ja([ea(i,[0,0],[t,s]),e],0)}const b=li(g),y=ea(r,[0,t],[n,r.shape[1]-t]);if(0===t)r=Js(y,Nr(Nr(y,o),b));else{const e=Js(y,Nr(Nr(y,o),b));r=ja([ea(r,[0,0],[n,t]),e],1)}return[o,i,r]})),ri([e,l,u])}return!e&&n>s&&(r=ea(r,[0,0],[n,s]),i=ea(i,[0,0],[s,s])),[r,i]}))}var pl;Rs({stft_:function(t,e,n,s,r=ll){var i;null==s&&(i=e,s=Math.floor(Math.pow(2,Math.ceil(Math.log(i)/Math.log(2)))));const a=ul(t,e,n),o=Bs(a,r(e));return Yo(o,s)}}),Rs({cropAndResize_:function(t,e,n,s,r="bilinear",i=0){const a=Ms(t,"image","cropAndResize"),o=Ms(e,"boxes","cropAndResize","float32"),l=Ms(n,"boxInd","cropAndResize","int32"),u=o.shape[0];He(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),He(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${u},4] but had shape ${o.shape}.`)),He(1===l.rank&&l.shape[0]===u,(()=>`Error in cropAndResize: boxInd must be have size [${u}] but had shape ${o.shape}.`)),He(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),He(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),He("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:a,boxes:o,boxInd:l},c={method:r,extrapolationValue:i,cropSize:s};return Ts.runKernel("CropAndResize",h,c)}}),Rs({flipLeftRight_:function(t){const e=Ms(t,"image","flipLeftRight","float32");He(4===e.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${e.rank}.`));const n={image:e};return Ts.runKernel("FlipLeftRight",n,{})}}),Rs({grayscaleToRGB_:function(t){const e=Ms(t,"image","grayscaleToRGB"),n=e.rank-1,s=e.shape[n];He(e.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${e.rank}.`)),He(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(e.rank);return r.fill(1,0,n),r[n]=3,Si(e,r)}}),Rs({rotateWithOffset_:function(t,e,n=0,s=.5){const r=Ms(t,"image","rotateWithOffset","float32");He(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const i={image:r},a={radians:e,fillValue:n,center:s};return Ts.runKernel("RotateWithOffset",i,a)}}),Rs({nonMaxSuppression_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const i=Ms(t,"boxes","nonMaxSuppression","float32"),a=Ms(e,"scores","nonMaxSuppression","float32"),o=hl(i,a,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ts.runKernel("NonMaxSuppressionV3",{boxes:i,scores:a},l)}}),Rs({nonMaxSuppressionWithScore_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=0){const a=Ms(t,"boxes","nonMaxSuppression"),o=Ms(e,"scores","nonMaxSuppression"),l=hl(a,o,n,s,r,i),u={boxes:a,scores:o},h={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:i=l.softNmsSigma},c=Ts.runKernel("NonMaxSuppressionV5",u,h);return{selectedIndices:c[0],selectedScores:c[1]}}}),Rs({nonMaxSuppressionPadded_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=!1){const a=Ms(t,"boxes","nonMaxSuppression"),o=Ms(e,"scores","nonMaxSuppression"),l=hl(a,o,n,s,r,null),u={boxes:a,scores:o},h={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:i},c=Ts.runKernel("NonMaxSuppressionV4",u,h);return{selectedIndices:c[0],validOutputs:c[1]}}}),Rs({resizeBilinear_:function(t,e,n=!1,s=!1){const r=Ms(t,"images","resizeBilinear");He(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),He(2===e.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${e}.`)),He(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=tr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ts.runKernel("ResizeBilinear",o,l);return a?tr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Rs({resizeNearestNeighbor_:function(t,e,n=!1,s=!1){const r=Ms(t,"images","resizeNearestNeighbor");He(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),He(2===e.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${e}.`)),He("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),He(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=tr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ts.runKernel("ResizeNearestNeighbor",o,l);return a?tr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Rs({threshold_:function(t,e="binary",n=!1,s=.5){const r=Ms(t,"image","threshold"),i=r.shape[0]*r.shape[1];let a,o,l,u,h=Bs(el([s]),255);if(He(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),He(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),He("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),He("otsu"===e||"binary"===e,(()=>`Method must be binary or otsu, but was ${e}`)),3===r.shape[2]){[a,o,l]=Br(r,[1,1,1],-1);const t=Bs(a,.2989),e=Bs(o,.587),n=Bs(l,.114);u=lr(lr(t,e),n)}else u=t;if("otsu"===e){h=function(t,e){let n,s,r,i,a,o,l=el([-1]),u=el([0]),h=el([0]);for(let c=0;c<t.size-1;c++){n=ea(t,0,c+1),s=ea(t,c+1),a=Ks(er(n),e),o=Ks(er(s),e);const p=er(Bs(n,Vo(0,n.size)));r=Ks(p,er(n));const d=ho(s.shape,n.size),f=lr(Vo(0,s.size),d),g=Bs(s,f);i=Ks(er(g),er(s));const m=Js(r,i),b=Js(r,i),y=Bs(a,o);h=Bs(Bs(y,m),b);const w=Fi(h,u);u=Lr(w,h,u),l=Lr(w,el([c]),l)}return l}(Ya(Os(Ho(u),"int32"),qs(c=[],p,_s(c,d),d),256),i)}var c,p,d;const f=n?_r(u,h):Fi(u,h);return Os(Bs(f,255),"int32")}}),Rs({transform_:function(t,e,n="nearest",s="constant",r=0,i){const a=Ms(t,"image","transform","float32"),o=Ms(e,"transforms","transform","float32");He(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),He(2===o.rank&&(o.shape[0]===a.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),He(null==i||2===i.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${i}.`));const l={image:a,transforms:o},u={interpolation:n,fillMode:s,fillValue:r,outputShape:i};return Ts.runKernel("Transform",l,u)}}),Rs({bandPart_:function(t,e,n){He(e%1==0,(()=>`bandPart(): numLower must be an integer, got ${e}.`)),He(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=Ms(t,"a","bandPart");He(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[i,a]=s.shape.slice(-2);if(!(e<=i))throw new Error(`bandPart(): numLower (${e}) must not be greater than the number of rows (${i}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);e<0&&(e=i),n<0&&(n=a);const o=tr(Vo(0,i,1,"int32"),[-1,1]),l=Vo(0,a,1,"int32"),u=Js(o,l),h=Dr(_r(u,js(+e,"int32")),zr(u,js(-n,"int32"))),c=Zi([i,a],s.dtype);return tr(tl(ua(tr(s,[-1,i,a])).map((t=>Lr(h,t,c)))),r)}}),Rs({gramSchmidt_:function(t){let e;if(Array.isArray(t)){e=!1,He(null!=t&&t.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=t[0].shape[0];for(let e=1;e<t.length;++e)He(t[e].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${t[e].shape[0]} vs. ${n})`))}else e=!0,t=Br(t,t.shape[0],0).map((t=>Qo(t,[0])));He(t.length<=t[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${t.length}) exceeds number of dimensions (${t[0].shape[0]}).`));const n=[],s=t;for(let e=0;e<t.length;++e)n.push(Ts.tidy((()=>{let t=s[e];if(e>0)for(let s=0;s<e;++s){const e=Bs(er(Bs(n[s],t)),n[s]);t=Js(t,e)}return Ks(t,oo(t,"euclidean"))})));return e?tl(n,0):n}}),Rs({qr_:function(t,e=!1){if(He(t.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${t.rank}`)),2===t.rank)return cl(t,e);{const n=t.shape.slice(0,t.shape.length-2).reduce(((t,e)=>t*e)),s=ua(tr(t,[n,t.shape[t.shape.length-2],t.shape[t.shape.length-1]]),0),r=[],i=[];s.forEach((t=>{const[n,s]=cl(t,e);r.push(n),i.push(s)}));return[tr(tl(r,0),t.shape),tr(tl(i,0),t.shape)]}}}),function(t){t[t.NONE=0]="NONE",t[t.MEAN=1]="MEAN",t[t.SUM=2]="SUM",t[t.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(pl||(pl={}));const dl=Rs({computeWeightedLoss_:function(t,e,n=pl.SUM_BY_NONZERO_WEIGHTS){const s=Ms(t,"losses","computeWeightedLoss");let r=null;null!=e&&(r=Ms(e,"weights","computeWeightedLoss"));const i=null==r?s:Bs(s,r);if(n===pl.NONE)return i;if(n===pl.SUM)return er(i);if(n===pl.MEAN){if(null==r)return xo(i);{const t=s.size/r.size,e=Ks(er(i),er(r));return t>1?Ks(e,js(t)):e}}if(n===pl.SUM_BY_NONZERO_WEIGHTS){if(null==r)return Ks(er(i),js(s.size));{const t=Bs(r,Yi(s.shape)),e=Os(er(No(t,js(0))),"float32");return Ks(er(i),e)}}throw Error(`Unknown reduction: ${n}`)}});Rs({absoluteDifference_:function(t,e,n,s=pl.SUM_BY_NONZERO_WEIGHTS){const r=Ms(t,"labels","absoluteDifference"),i=Ms(e,"predictions","absoluteDifference");let a=null;null!=n&&(a=Ms(n,"weights","absoluteDifference")),Je(r.shape,i.shape,"Error in absoluteDifference: ");const o=Va(Js(r,i));return dl(o,a,s)}}),Rs({cosineDistance_:function(t,e,n,s,r=pl.SUM_BY_NONZERO_WEIGHTS){const i=Ms(t,"labels","cosineDistance"),a=Ms(e,"predictions","cosineDistance");let o=null;null!=s&&(o=Ms(s,"weights","cosineDistance")),Je(i.shape,a.shape,"Error in cosineDistance: ");const l=js(1),u=Js(l,er(Bs(i,a),n,!0));return dl(u,o,r)}}),Rs({hingeLoss_:function(t,e,n,s=pl.SUM_BY_NONZERO_WEIGHTS){let r=Ms(t,"labels","hingeLoss");const i=Ms(e,"predictions","hingeLoss");let a=null;null!=n&&(a=Ms(n,"weights","hingeLoss")),Je(r.shape,i.shape,"Error in hingeLoss: ");const o=js(1);r=Js(Bs(js(2),r),o);const l=qo(Js(o,Bs(r,i)));return dl(l,a,s)}}),Rs({huberLoss_:function(t,e,n,s=1,r=pl.SUM_BY_NONZERO_WEIGHTS){const i=Ms(t,"labels","huberLoss"),a=Ms(e,"predictions","huberLoss");let o=null;null!=n&&(o=Ms(n,"weights","huberLoss")),Je(i.shape,a.shape,"Error in huberLoss: ");const l=js(s),u=Va(Js(a,i)),h=So(u,l),c=Js(u,h),p=lr(Bs(js(.5),Hs(h)),Bs(l,c));return dl(p,o,r)}}),Rs({logLoss_:function(t,e,n,s=1e-7,r=pl.SUM_BY_NONZERO_WEIGHTS){const i=Ms(t,"labels","logLoss"),a=Ms(e,"predictions","logLoss");let o=null;null!=n&&(o=Ms(n,"weights","logLoss")),Je(i.shape,a.shape,"Error in logLoss: ");const l=js(1),u=js(s),h=Vs(Bs(i,pa(lr(a,u)))),c=Bs(Js(l,i),pa(lr(Js(l,a),u))),p=Js(h,c);return dl(p,o,r)}}),Rs({meanSquaredError_:function(t,e,n,s=pl.SUM_BY_NONZERO_WEIGHTS){const r=Ms(t,"labels","meanSquaredError"),i=Ms(e,"predictions","meanSquaredError");let a=null;null!=n&&(a=Ms(n,"weights","meanSquaredError")),Je(r.shape,i.shape,"Error in meanSquaredError: ");const o=Xo(r,i);return dl(o,a,s)}}),Rs({sigmoidCrossEntropy_:function(t,e,n,s=0,r=pl.SUM_BY_NONZERO_WEIGHTS){let i=Ms(t,"multiClassLabels","sigmoidCrossEntropy");const a=Ms(e,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=Ms(n,"weights","sigmoidCrossEntropy")),Je(i.shape,a.shape,"Error in sigmoidCrossEntropy: "),s>0){const t=js(s),e=js(1),n=js(.5);i=lr(Bs(i,Js(e,t)),Bs(n,t))}const l=function(t,e){const n=Ms(t,"labels","sigmoidCrossEntropyWithLogits"),s=Ms(e,"logits","sigmoidCrossEntropyWithLogits");Je(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=qo(s),i=Bs(s,n),a=fo(gi(Vs(Va(s))));return lr(Js(r,i),a)}(i,a);return dl(l,o,r)}}),Rs({softmaxCrossEntropy_:function(t,e,n,s=0,r=pl.SUM_BY_NONZERO_WEIGHTS){let i=Ms(t,"onehotLabels","softmaxCrossEntropy");const a=Ms(e,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=Ms(n,"weights","softmaxCrossEntropy")),Je(i.shape,a.shape,"Error in softmaxCrossEntropy: "),s>0){const t=js(s),e=js(1),n=js(i.shape[1]);i=lr(Bs(i,Js(e,t)),Ks(t,n))}const l=function(t,e,n=-1){if(-1===n&&(n=e.rank-1),n!==e.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${e.rank} and dim was ${n}`);const s=go(((t,e,s)=>{const r=bo(e,[n],!0),i=Js(Os(e,"float32"),r);s([t,i]);const a=Vs(Bs(i,t));return{value:er(a,[n]),gradFunc:(t,e)=>{const[s,r]=e,i=Qr(t.shape,[n]);return[Bs(tr(t,i),Js(Os(s,"float32"),gi(r))),Bs(tr(t,i),Js(gi(r),Os(s,"float32")))]}}}));return s(t,e)}(i,a);return dl(l,o,r)}}),Rs({sparseFillEmptyRows_:function(t,e,n,s){const r=Ms(t,"indices","sparseFillEmptyRows","int32"),i=Ms(e,"values","sparseFillEmptyRows"),a=Ms(n,"denseShape","sparseFillEmptyRows","int32"),o=Ms(s,"defaultValue","sparseFillEmptyRows",i.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==i.rank)throw new Error(`Values should be Tensor1D but received shape ${i.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:i,denseShape:a,defaultValue:o},u=Ts.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}}),Rs({sparseReshape_:function(t,e,n){const s=Ms(t,"inputIndices","sparseReshape","int32"),r=Ms(e,"inputShape","sparseReshape","int32"),i=Ms(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==i.rank)throw new Error(`New shape should be Tensor1D but received shape ${i.shape}`);const a={inputIndices:s,inputShape:r,newShape:i},o=Ts.runKernel("SparseReshape",a);return{outputIndices:o[0],outputShape:o[1]}}}),Rs({sparseSegmentMean_:function(t,e,n){const s=Ms(t,"data","sparseSegmentMean"),r=Ms(e,"indices","sparseSegmentMean","int32"),i=Ms(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ts.runKernel("SparseSegmentMean",a)}}),Rs({sparseSegmentSum_:function(t,e,n){const s=Ms(t,"data","sparseSegmentSum"),r=Ms(e,"indices","sparseSegmentSum","int32"),i=Ms(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ts.runKernel("SparseSegmentSum",a)}}),Rs({stringNGrams_:function(t,e,n,s,r,i,a,o){const l=Ms(t,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Ms(e,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const h={separator:n,nGramWidths:s,leftPad:r,rightPad:i,padWidth:a,preserveShortSequences:o},c={data:l,dataSplits:u},p=Ts.runKernel("StringNGrams",c,h);return{nGrams:p[0],nGramsSplits:p[1]}}}),Rs({stringSplit_:function(t,e,n=!0){const s=Ms(t,"input","stringSplit","string"),r=Ms(e,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const i={skipEmpty:n},a={input:s,delimiter:r},o=Ts.runKernel("StringSplit",a,i);return{indices:o[0],values:o[1],shape:o[2]}}}),Rs({stringToHashBucketFast_:function(t,e){const n=Ms(t,"input","stringToHashBucketFast","string"),s={numBuckets:e};if(e<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return Ts.runKernel("StringToHashBucketFast",r,s)}});class fl extends class{getClassName(){return this.constructor.className}static fromConfig(t,e){return new t(e)}}{minimize(t,e=!1,n){const{value:s,grads:r}=this.computeGradients(t,n);if(null!=n){const t=n.map((t=>({name:t.name,tensor:r[t.name]})));this.applyGradients(t)}else this.applyGradients(r);return ri(r),e?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(t,e){return function(t,e){He(ln(t),(()=>"The f passed in variableGrads(f) must be a function")),He(null==e||Array.isArray(e)&&e.every((t=>t instanceof bs)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=e;if(!n){e=[];for(const t in Ts.registeredVariables)e.push(Ts.registeredVariables[t])}const s=n?e.filter((t=>!t.trainable)):null,r=e.length;He((e=e.filter((t=>t.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:i,grads:a}=Ts.gradients(t,e,null,!0);He(a.some((t=>null!=t)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),He(0===i.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${i.rank} tensor`));const o={};return e.forEach(((t,e)=>{null!=a[e]&&(o[t.name]=a[e])})),null!=s&&s.forEach((t=>o[t.name]=null)),{value:i,grads:o}}(t,e)}dispose(){null!=this.iterations_&&ri(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:js(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(t){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(t){return this.iterations_=(await t[0].tensor.data())[0],t.slice(1)}}Object.defineProperty(fl,Symbol.hasInstance,{value:t=>null!=t.minimize&&null!=t.computeGradients&&null!=t.applyGradients});class gl extends fl{constructor(t,e,n=null){super(),this.learningRate=t,this.rho=e,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ts.backend.epsilon())}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ts.registeredVariables[e];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${e}/accum_grad`,variable:si((()=>rr(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${e}/accum_var`,variable:si((()=>rr(s).variable(false)))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;si((()=>{const t=lr(Bs(i,this.rho),Bs(Hs(r),1-this.rho)),e=Bs(Ks(Gs(lr(a,this.epsilon)),Gs(lr(i,this.epsilon))),r),n=lr(Bs(a,this.rho),Bs(Hs(e),1-this.rho));i.assign(t),a.assign(n);const o=lr(Bs(e,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(ri(this.accumulatedGrads.map((t=>t.variable))),ri(this.accumulatedUpdates.map((t=>t.variable))))}async getWeights(){const t=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){const e=(t=await this.extractIterations(t)).length/2;this.accumulatedGrads=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedUpdates=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.rho,e.epsilon)}}gl.className="Adadelta",Ka(gl);class ml extends fl{constructor(t,e=.1){super(),this.learningRate=t,this.initialAccumulatorValue=e,this.accumulatedGrads=[]}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ts.registeredVariables[e];if(null==this.accumulatedGrads[n]){const t=!1;this.accumulatedGrads[n]={originalName:`${e}/accumulator`,variable:si((()=>ho(s.shape,this.initialAccumulatorValue).variable(t)))}}const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable;si((()=>{const t=lr(i,Hs(r));i.assign(t);const e=lr(Bs(Ks(r,Gs(lr(t,Ts.backend.epsilon()))),-this.learningRate),s);s.assign(e)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&ri(this.accumulatedGrads.map((t=>t.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulatedGrads=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(t,e){return new t(e.learningRate,e.initialAccumulatorValue)}}ml.className="Adagrad",Ka(ml);class bl extends fl{constructor(t,e,n,s=null){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],si((()=>{this.accBeta1=js(e).variable(),this.accBeta2=js(n).variable()})),null==s&&(this.epsilon=Ts.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);si((()=>{const n=Js(1,this.accBeta1),s=Js(1,this.accBeta2);e.forEach(((e,r)=>{const i=Ts.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:si((()=>rr(i).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${e}/v`,variable:si((()=>rr(i).variable(false)))});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=lr(Bs(o,this.beta1),Bs(a,1-this.beta1)),h=lr(Bs(l,this.beta2),Bs(Hs(a),1-this.beta2)),c=Ks(u,n),p=Ks(h,s);o.assign(u),l.assign(h);const d=lr(Bs(Ks(c,lr(Gs(p),this.epsilon)),-this.learningRate),i);i.assign(d)})),this.accBeta1.assign(Bs(this.accBeta1,this.beta1)),this.accBeta2.assign(Bs(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&ri(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedSecondMoment&&ri(this.accumulatedSecondMoment.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t),si((()=>{this.accBeta1.assign(da(this.beta1,this.iterations_+1)),this.accBeta2.assign(da(this.beta2,this.iterations_+1))}));const e=t.length/2;this.accumulatedFirstMoment=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedSecondMoment=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon)}}bl.className="Adam",Ka(bl);class yl extends fl{constructor(t,e,n,s=null,r=0){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],si((()=>{this.iteration=js(0).variable(),this.accBeta1=js(e).variable()})),null==s&&(this.epsilon=Ts.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);si((()=>{const n=Js(1,this.accBeta1),s=Ks(-this.learningRate,lr(Bs(this.iteration,this.decay),1));e.forEach(((e,r)=>{const i=Ts.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:rr(i).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${e}/v`,variable:rr(i).variable(false)});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=lr(Bs(o,this.beta1),Bs(a,1-this.beta1)),h=Bs(l,this.beta2),c=Va(a),p=vo(h,c);o.assign(u),l.assign(p);const d=lr(Bs(Ks(s,n),Ks(u,lr(p,this.epsilon))),i);i.assign(d)})),this.iteration.assign(lr(this.iteration,1)),this.accBeta1.assign(Bs(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&ri(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedWeightedInfNorm&&ri(this.accumulatedWeightedInfNorm.map((t=>t.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon,e.decay)}}yl.className="Adamax",Ka(yl);class wl extends fl{constructor(t){super(),this.learningRate=t,this.setLearningRate(t)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Array.isArray(t)?t[n].tensor:t[e];if(null==s)return;const r=Ts.registeredVariables[e];si((()=>{const t=lr(Bs(this.c,s),r);r.assign(t)}))})),this.incrementIterations()}setLearningRate(t){var e;this.learningRate=t,null!=this.c&&this.c.dispose(),this.c=(e=js(-t),Ts.keep(e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(t){if(0!==(t=await this.extractIterations(t)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(t,e){return new t(e.learningRate)}}wl.className="SGD",Ka(wl);class kl extends wl{constructor(t,e,n=!1){super(t),this.learningRate=t,this.momentum=e,this.useNesterov=n,this.accumulations=[],this.m=js(this.momentum)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ts.registeredVariables[e];if(null==this.accumulations[n]){const t=!1;this.accumulations[n]={originalName:`${e}/momentum`,variable:si((()=>rr(s).variable(t)))}}const r=this.accumulations[n].variable,i=Array.isArray(t)?t[n].tensor:t[e];null!=i&&si((()=>{let t;const e=lr(Bs(this.m,r),i);t=this.useNesterov?lr(Bs(this.c,lr(i,Bs(e,this.m))),s):lr(Bs(this.c,e),s),r.assign(e),s.assign(t)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&ri(this.accumulations.map((t=>t.variable)))}setMomentum(t){this.momentum=t}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulations=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(t,e){return new t(e.learningRate,e.momentum,e.useNesterov)}}kl.className="Momentum",Ka(kl);class vl extends fl{constructor(t,e=.9,n=0,s=null,r=!1){if(super(),this.learningRate=t,this.decay=e,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ts.backend.epsilon()),null==t)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ts.registeredVariables[e],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${e}/rms`,variable:si((()=>rr(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${e}/momentum`,variable:si((()=>rr(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${e}/mg`,variable:si((()=>rr(s).variable(r)))});const i=Array.isArray(t)?t[n].tensor:t[e];if(null==i)return;const a=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;si((()=>{const t=lr(Bs(a,this.decay),Bs(Hs(i),1-this.decay));if(this.centered){const e=this.accumulatedMeanGrads[n].variable,r=lr(Bs(e,this.decay),Bs(i,1-this.decay)),l=Ks(Bs(i,this.learningRate),Gs(Js(t,lr(Hs(r),this.epsilon)))),u=lr(Bs(o,this.momentum),l);a.assign(t),e.assign(r),o.assign(u);const h=Js(s,u);s.assign(h)}else{const t=lr(Bs(a,this.decay),Bs(Hs(i),1-this.decay)),e=lr(Bs(o,this.momentum),Ks(Bs(i,this.learningRate),Gs(lr(t,this.epsilon))));a.assign(t),o.assign(e);const n=Js(s,e);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&ri(this.accumulatedMeanSquares.map((t=>t.variable))),null!=this.accumulatedMeanGrads&&this.centered&&ri(this.accumulatedMeanGrads.map((t=>t.variable))),null!=this.accumulatedMoments&&ri(this.accumulatedMoments.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&t.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);const e=this.centered?t.length/3:t.length/2,n=!1;this.accumulatedMeanSquares=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.accumulatedMoments=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=t.slice(2*e,3*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(t,e){return new t(e.learningRate,e.decay,e.momentum,e.epsilon,e.centered)}}vl.className="RMSProp",Ka(vl),"undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate&&setImmediate;function xl(t,e,n){const s=t.shape.length,r=s-n.length,i=ti(n,s);let a=t;null!=i&&(a=li(t,i));const o=a.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((t,e)=>t*e),1);o.push(l);let u=function(t,e,n){const s=t.shape.slice();s[n]=1;const r=tr(e,s),i=eo(t,n,!0,!1),a=eo(t,n,!0,!0),o=Bs(i,a);return Bs(r,o)}(a.reshape(o),e,r);if(u=u.reshape(a.shape),null!=i){const t=ei(i);u=li(u,t)}return u}const Sl={kernelName:"SpaceToBatchND",gradFunc:(t,e,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Ja(t,s,r)}}},Nl={kernelName:"SplitV",gradFunc:(t,e,n)=>{const{axis:s}=n;return{x:()=>ja(t,s)}}};const El=[Ws,Zs,Ys,nr,sr,ir,ar,or,ur,hr,cr,pr,vr,Sr,Er,Ar,$r,Cr,Tr,Rr,Or,Pr,qr,Kr,Hr,Zr,Xr,ui,pi,di,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{const e=Ks(t,Os(s,"float32")),i=Xs(n.shape,r);return i.length>0?tr(er(e,i),n.shape):e},b:()=>{let e=Bs(t,Os(n,"float32"));const i=Xs(s.shape,r);i.length>0&&(e=tr(er(e,i),s.shape));const a=Hs(s);return Vs(Ks(e,Os(a,"float32")))}}}},fi,mi,bi,yi,wi,vi,ki,Ni,Ii,Ci,Ti,zi,_i,Di,Mi,Li,Ri,Oi,Pi,Ki,Ki,qi,Gi,Ji,Xi,Qi,ta,na,ra,ia,aa,oa,la,ha,ca,ca,fa,ga,{kernelName:"Prod",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;let i=[];return i=null==r?s.shape.map(((t,e)=>e)):"number"==typeof r?[r]:r,{x:()=>xl(s,t,i)}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Vs(Hs(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Bs(_r(n,6),Ps(n));return{x:()=>Bs(t,Os(s,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,Os(Ps(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>tr(t,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ts.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ts.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:"Reverse",gradFunc:(t,e,n)=>{const{dims:s}=n,r=nn(s,t.shape);return{x:()=>Go(t,r)}}},{kernelName:"Round",gradFunc:t=>({x:()=>rr(t)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Vs(Ks(t,Bs(da(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(t,e)=>{const[n]=e;return{condition:()=>Os(rr(n),"float32"),t:()=>Bs(t,Os(n,t.dtype)),e:()=>Bs(t,Os(yo(n),t.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Fi(n,js(0)),s=js(1.7580993408473768),r=js(1.0507009873554805),i=Bs(t,r),a=Bs(Bs(t,s),gi(Os(n,"float32")));return Lr(e,i,a)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,Bs(n,Js(js(1),n)))}}},{kernelName:"Sign",gradFunc:t=>({x:()=>rr(t)})},{kernelName:"Sin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(Qa(Os(n,"float32")),t)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(to(Os(n,"float32")),t)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{begin:r,size:i}=n,a=s.shape,[o,l]=function(t,e,n){let s;const r=t.shape.length;let i;return s="number"==typeof e?[e,...new Array(r-1).fill(0)]:e.length<r?e.concat(new Array(r-e.length).fill(0)):e.slice(),s.forEach((t=>{He(-1!==t,(()=>"slice() does not support negative begin indexing."))})),i=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,i=i.map(((e,n)=>e>=0?e:(He(-1===e,(()=>`Negative size values should be exactly -1 but got ${e} for the slice() size at index ${n}.`)),t.shape[n]-s[n]))),[s,i]}(s,r,i),u=[];for(let e=0;e<t.rank;e++)u.push([o[e],a[e]-o[e]-l[e]]);return{x:()=>Eo(t,u)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{dim:r}=n,i=Bs(t,s);return{logits:()=>Js(i,Bs(er(i,[r],true),s))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,Ga(n))}}},Sl,Sl,Nl,Nl,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Bs(Gs(Os(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=js(2);return{a:()=>Bs(t,Bs(r,Js(n,s))),b:()=>Bs(t,Bs(r,Js(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(t,Bs(Os(n,"float32"),2))}}},{kernelName:"Step",gradFunc:t=>({x:()=>rr(t)})},{kernelName:"Sub",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Qs(n.shape,s.shape);return{a:()=>{let e=t;const s=Xs(n.shape,r);return s.length>0&&(e=er(e,s)),tr(e,n.shape)},b:()=>{let e=t;const n=Xs(s.shape,r);return n.length>0&&(e=er(e,n)),tr(Vs(e),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,r=s.shape.slice(),{axis:i}=n;nn(i,s.shape).forEach((t=>{r[t]=1}));const a=tr(t,r),o=Bs(a,Yi(s.shape,"float32"));return{x:()=>o}}},{kernelName:"Tan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Ks(t,Hs(Qa(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Bs(Js(js(1),Hs(n)),t)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{reps:r}=n;return{x:()=>{let e=rr(s);if(1===s.rank)for(let n=0;n<r[0];++n)e=lr(e,ea(t,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)e=lr(e,ea(t,[n*s.shape[0],i*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)e=lr(e,ea(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)for(let o=0;o<r[3];++o)e=lr(e,ea(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return e}}}},{kernelName:"Transpose",gradFunc:(t,e,n)=>{const s=n,{perm:r}=s,i=ei(r);return{x:()=>li(t,i)}}},{kernelName:"Unpack",gradFunc:(t,e,n)=>{const s=n,{axis:r}=s;return{value:()=>tl(t,r)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>function(t,e){const n=vo(e,rr(e)),s=co(t,n);let r=zr(e,js(0,"int32"));const i=s.rank-r.rank;for(let t=0;t<i;++t)r=lo(r,t+1);r=Dr(r,Yi(s.shape,"bool"));const a=rr(s);return Lr(r,s,a)}(t,n)}}},{kernelName:"ZerosLike",gradFunc:t=>({x:()=>rr(t)})}];for(const t of El)Cn(t);function Il(e,n){return s((()=>t.sqrt(t.sum(t.mul(e,e),n,!0))))}class Al extends i.Serializable{getConfig(){return{}}}class $l extends Al{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>{const n=Il(e,this.axis),s=t.clipByValue(n,0,this.maxValue);return t.mul(e,t.div(s,t.add(Ot(),n)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}$l.className="MaxNorm",i.registerClass($l);class Cl extends Al{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>t.div(e,t.add(Ot(),Il(e,this.axis)))))}getConfig(){return{axis:this.axis}}}Cl.className="UnitNorm",i.registerClass(Cl);class Tl extends Al{apply(e){return t.relu(e)}}Tl.className="NonNeg",i.registerClass(Tl);class zl extends Al{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(e){return s((()=>{const n=Il(e,this.axis),s=t.add(t.mul(this.rate,t.clipByValue(n,this.minValue,this.maxValue)),t.mul(1-this.rate,n));return t.mul(e,t.div(s,t.add(Ot(),n)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}zl.className="MinMaxNorm",i.registerClass(zl);const _l={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Dl(t){return st(t)}function Fl(t,e={}){return it(t,i.SerializationMap.getMap().classNameMap,e,"constraint")}function Ml(t){if(null==t)return null;if("string"==typeof t){return Fl({className:t in _l?_l[t]:t,config:{}})}return t instanceof Al?t:Fl(t)}var Ll={__proto__:null,maxNorm:function(t){return new $l(t)},unitNorm:function(t){return new Cl(t)},nonNeg:function(){return new Tl},minMaxNorm:function(t){return new zl(t)}};var Rl,Ol={__proto__:null,zeros:function(){return new re},ones:function(){return new ie},constant:function(t){return new ae(t)},randomUniform:function(t){return new oe(t)},randomNormal:function(t){return new le(t)},truncatedNormal:function(t){return new ue(t)},identity:function(t){return new he(t)},varianceScaling:function(t){return new ce(t)},glorotUniform:function(t){return new pe(t)},glorotNormal:function(t){return new de(t)},heNormal:function(t){return new fe(t)},heUniform:function(t){return new ge(t)},leCunNormal:function(t){return new me(t)},leCunUniform:function(t){return new be(t)},orthogonal:function(t){return new ye(t)}};async function Bl(t){if(null==t)return;const e=[],n=[],s=[];for(const r in t){const i=t[r];if("number"!=typeof i){const t=i;e.push(t.data()),n.push(r),s.push(t)}}if(e.length>0){const r=await Promise.all(e);for(let e=0;e<r.length;++e)t[n[e]]=r[e][0];g(s)}}function Pl(t){if(null!=t)for(const e in t){const n=t[e];"number"!=typeof n&&n.dispose()}}!function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(Rl||(Rl={}));class Wl{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class Ul{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class Kl extends Wl{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,e){null==e&&(e={});const n=null==e.size?0:e.size;this.seen+=n;for(const t in e){const r=e[t];if("number"==typeof r)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+r*n;else{let e;t in this.totals?e=this.totals[t]:this.totals[t]=0;const i=s((()=>k(this.totals[t],l(r,n))));this.totals[t]=i,null!=e&&e.dispose()}}}async onEpochEnd(t,e){if(null!=e)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?e[t]=this.totals[t]/this.seen:s((()=>{const n=l(v(1,this.seen),this.totals[t]);e[t]=n,this.totals[t].dispose(),x(e[t])})))}}class Vl extends Wl{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],n=[];for(const s in this.history){const r=this.history[s];for(let i=0;i<r.length;++i)if("number"!=typeof r[i]){const a=r[i];t.push(a.data()),e.push(s),n.push(i)}}const s=await Promise.all(t);for(let t=0;t<s.length;++t){this.history[e[t]][n[t]].dispose(),this.history[e[t]][n[t]]=s[t][0]}}}class ql extends Wl{constructor(t,n){if(super(),this.currentEpoch=0,this.nowFunc=t.nowFunc,this.nextFrameFunc=t.nextFrameFunc||w,this.yieldEvery=n||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");e.isNumber(this.yieldEvery)&&(this.maybeWait=function(t,n,s){let r,i=null!=s?s():e.now();return(...a)=>{const o=null!=s?s():e.now();return o-i<n||(i=o,r=t(...a)),r}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,e,n){const s=[];null!=this.yield&&(await Bl(n),s.push(this.yield(t,e,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await Bl(e),await this.epochBegin(t,e))}async onEpochEnd(t,e){const n=[];null!=this.epochEnd&&(await Bl(e),n.push(this.epochEnd(t,e))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(t,e){null!=this.batchBegin&&(await Bl(e),await this.batchBegin(t,e))}async onBatchEnd(t,n){const s=[];null!=this.batchEnd&&(await Bl(n),s.push(this.batchEnd(t,n))),"batch"===this.yieldEvery?s.push(this.nextFrameFunc()):e.isNumber(this.yieldEvery)&&s.push(this.maybeWait(this.currentEpoch,t,n)),await Promise.all(s)}async onTrainBegin(t){null!=this.trainBegin&&(await Bl(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await Bl(t),await this.trainEnd(t))}}function jl(t,e){if(null==t&&(t={}),t instanceof Wl)return[t];if(Array.isArray(t)&&t[0]instanceof Wl)return t;return Q(t).map((t=>new ql(t,e)))}class Gl{constructor(){}static registerCallbackConstructor(t,n){e.assert(t>=0&&Number.isInteger(t),(()=>`Verbosity level is expected to be an integer >= 0, but got ${t}`)),Gl.checkForDuplicate(n),null==Gl.constructors[t]&&(Gl.constructors[t]=[]),Gl.constructors[t].push(n)}static checkForDuplicate(t){for(const e in Gl.constructors){Gl.constructors[+e].forEach((e=>{if(e===t)throw new q("Duplicate callback constructor.")}))}}static clear(){Gl.constructors={}}static createCallbacks(t){const e=[];for(const n in Gl.constructors){const s=+n;t>=s&&e.push(...Gl.constructors[s])}return e.map((t=>new t))}}function Hl(t,e,n,s,r,i,a,o,l){const u=new Vl,h=[new Kl,...Gl.createCallbacks(e)];null!=t&&h.push(...t),h.push(u);const c=new Ul(h);return c.setParams({epochs:n,initialEpoch:s,samples:r,steps:i,batchSize:a,verbose:e,doValidation:o,metrics:l}),{callbackList:c,history:u}}function Jl(t,e={},n=!1){return it(t,i.SerializationMap.getMap().classNameMap,e,"layer",n)}function Zl(e,n){return s((()=>{"float32"!==e.dtype&&(e=t.cast(e,"float32"));const s=t.sum(Zt(e),n,!0),r=t.fill(s.shape,Ot()),i=t.sqrt(t.maximum(s,r));return t.div(e,i)}))}function Yl(e,n){return s((()=>t.mean(Zt(t.sub(n,e)),-1)))}function Xl(e,n){return s((()=>t.mean(t.abs(t.sub(n,e)),-1)))}function Ql(e,n){return s((()=>{const s=t.sub(e,n),r=t.clipByValue(t.abs(e),Ot(),Number.MAX_VALUE),i=t.abs(t.div(s,r));return t.mul(100,t.mean(i,-1))}))}function tu(e,n,r=!1){return s((()=>{if(r)n=t.softmax(n);else{const e=t.sum(n,n.shape.length-1,!0);n=t.div(n,e)}return n=t.clipByValue(n,Ot(),1-Ot()),t.neg(t.sum(t.mul(t.cast(e,"float32"),t.log(n)),n.shape.length-1))}))}function eu(e,n,r=!1){return s((()=>{const s=t.cast(t.floor(function(e){const n=[Dt(e.shape)];return t.reshape(e,n)}(e)),"int32"),i=(n=t.clipByValue(n,Ot(),1-Ot())).shape;return tu(t.reshape(t.oneHot(s,i[i.length-1]),i),n,r)}))}function nu(n,r){return s((()=>{let i;return i=t.clipByValue(r,Ot(),1-Ot()),i=t.log(t.div(i,t.sub(1,i))),t.mean(function(n,r){if(!e.arraysEqual(n.shape,r.shape))throw new q(`logits and labels must have the same shape, but got shapes ${JSON.stringify(n.shape)} and ${JSON.stringify(r.shape)}`);return s((()=>{const e=t.relu(r),s=t.neg(t.abs(r));return t.add(t.sub(e,t.mul(r,n)),t.log1p(t.exp(s)))}))}(n,i),-1)}))}function su(e,n){return s((()=>{const s=Zl(e,-1),r=Zl(n,-1),i=t.mul(s,r);return t.neg(t.sum(i,-1))}))}Gl.constructors={};const ru={meanSquaredError:Yl,meanAbsoluteError:Xl,meanAbsolutePercentageError:Ql,meanSquaredLogarithmicError:function(e,n){return s((()=>{const s=t.clipByValue(n,Ot(),Number.MAX_VALUE),r=t.log(t.add(1,s)),i=t.clipByValue(e,Ot(),Number.MAX_VALUE),a=t.log(t.add(1,i));return t.mean(Zt(t.sub(r,a)),-1)}))},squaredHinge:function(e,n){return s((()=>{const s=t.maximum(0,t.sub(1,t.mul(e,n)));return t.mean(Zt(s),-1)}))},hinge:function(e,n){return s((()=>{const s=t.maximum(0,t.sub(1,t.mul(e,n)));return t.mean(s,-1)}))},categoricalHinge:function(e,n){return s((()=>{const s=t.sum(t.mul(e,n),-1),r=t.max(t.mul(t.sub(1,e),n),-1);return t.maximum(0,t.add(1,t.sub(r,s)))}))},logcosh:function(e,n){return s((()=>{const s=Math.log(2),r=t.sub(n,e),i=t.sub(t.add(r,t.softplus(t.mul(-2,r))),s);return t.mean(i,-1)}))},categoricalCrossentropy:tu,sparseCategoricalCrossentropy:eu,binaryCrossentropy:nu,kullbackLeiblerDivergence:function(e,n){return s((()=>{const s=t.clipByValue(e,Ot(),1),r=t.clipByValue(n,Ot(),1);return t.sum(t.mul(e,t.log(t.div(s,r))),-1)}))},poisson:function(e,n){return s((()=>{const s=t.log(t.add(Ot(),n));return t.mean(t.sub(n,t.mul(e,s)),-1)}))},cosineProximity:su};function iu(t){if("string"==typeof t){if(t in ru)return ru[t];let e=`Unknown loss ${t}`;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new q(e)}return t}function au(e,n){return s((()=>{const s=t.mul(.5,t.onesLike(n)),r=Bt(t.greater(n,s),e.dtype);return t.mean(t.equal(e,r),-1)}))}function ou(e,n){return s((()=>Bt(t.equal(t.argMax(e,-1),t.argMax(n,-1)),"float32")))}function lu(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,1),t.equal(n,1))),"float32")))}function uu(e,n){return s((()=>{const r=lu(e,n),i=function(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,0),t.equal(n,1))),"float32")))}(e,n),a=t.add(r,i);return t.cast(t.where(t.greater(a,0),t.div(r,a),0),"float32")}))}function hu(e,n){return s((()=>{const r=lu(e,n),i=function(e,n){return s((()=>t.cast(t.sum(t.logicalAnd(t.equal(e,1),t.equal(n,0))),"float32")))}(e,n),a=t.add(r,i);return t.cast(t.where(t.greater(a,0),t.div(r,a),0),"float32")}))}function cu(t,e){return nu(t,e)}function pu(e,n){return e.rank===n.rank&&(e=t.squeeze(e,[e.rank-1])),(n=t.argMax(n,-1)).dtype!==e.dtype&&(n=t.cast(n,e.dtype)),t.cast(t.equal(e,n),"float32")}const du=tu,fu=eu,gu={binaryAccuracy:au,categoricalAccuracy:ou,precision:uu,categoricalCrossentropy:du,sparseCategoricalCrossentropy:fu,mse:Yl,MSE:Yl,mae:Xl,MAE:Xl,mape:Ql,MAPE:Ql,cosine:su};function mu(t){if("string"==typeof t&&t in gu)return gu[t];if("string"!=typeof t&&null!=t)return t;throw new q(`Unknown metric ${t}`)}function bu(t){if(Z(null!==t,`Unknown LossOrMetricFn ${t}`),"string"==typeof t)return t;{let e;for(const n of Object.keys(ru))if(ru[n]===t){e=n;break}if(void 0!==e)return e;for(const n of Object.keys(gu))if(gu[n]===t){e=n;break}return void 0!==e?e:t.name}}function yu(t,e,n=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!wu(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(t);n.length>1048576&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function wu(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const e=Object.keys(t);for(const n of e){if("string"!=typeof n)return!1;if(!wu(t[n]))return!1}return!0}if(Array.isArray(t)){for(const e of t)if(!wu(e))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}function ku(t,e,n,s=console.log){const r=function(t){let e=!0;const n=[],s=[];for(const e in t.nodesByDepth)n.push(t.nodesByDepth[e]);for(const t of n){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}s.push(...t)}if(e)for(const n of t.layers){let t=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),i=["Layer (type)","Input Shape","Output shape","Param #"];let a;if(r?(e=e||90,n=n||[.32,.61,.89,1]):(e=e||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((t=>Math.floor(e*t)))),!r){i.push("Receives inputs"),a=[];for(const e in t.nodesByDepth)a.push(...t.nodesByDepth[e])}s("_".repeat(e)),vu(i,n,s),s("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)r?xu(o[t],n,s):Su(o[t],n,a,s),s((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?Ae(t.collectedTrainableWeights):Ae(t.trainableWeights);return e}(t),u=Ae(t.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(e))}function vu(t,e,n=console.log){let s="";for(let n=0;n<t.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=t[n],s=s.slice(0,e[n]),s+=" ".repeat(e[n]-s.length);n(s)}function xu(t,e,n){let s,r;try{r=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){r="multiple"}try{s=JSON.stringify(t.outputShape)}catch(t){s="multiple"}vu([`${t.name} (${t.getClassName()})`,r,s,t.countParams().toString()],e,n)}function Su(t,e,n,s){let r,i;try{i=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){i="multiple"}try{r=JSON.stringify(t.outputShape)}catch(t){r="multiple"}const a=[];for(const e of t.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const n=e.inboundLayers[t].name,s=e.nodeIndices[t],r=e.tensorIndices[t];a.push(`${n}[${s}][${r}]`)}const o=t.name,l=t.getClassName(),u=0===a.length?"":a[0];vu([`${o} (${l})`,i,r,t.countParams().toString(),u],e,s);for(let t=1;t<a.length;++t)vu(["","","","",a[t]],e,s)}function Nu(t,e,n){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof n}function Eu(t,e){if(null===t)return null;if("string"==typeof t)return et(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Nu(e,r,s)?n.push(s):n.push(Eu(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n];if("name"===n&&"string"==typeof s)e[n]=s;else{const t=et(n);e[t]=Eu(s,t)}}return e}}function Iu(t,e){if(null==t)return null;if("string"==typeof t)return tt(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Nu(e,r,s)?n.push(s):n.push(Iu(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n],r=tt(n);e[r]="name"!==n&&"className"!==n||"string"!=typeof s?Iu(s,n):s}return e}}const Au="3.19.0";class $u extends Le{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=bt(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],ot(this.inputs).length!==this.inputs.length)throw new q(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((t=>t.name))}`);ot(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((t=>t.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const t of this.inputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;Z(0===n,"input layer has >1 nodes"),Z(0===s,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e];if(!(n instanceof Oe))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map((t=>t.shape)),this.internalOutputShapes=this.outputs.map((t=>t.shape));const e={},n={},s={},r={},i={},a=[],o=(t,e,n,s,r,l)=>{null!=s&&null!=r&&null!=l||(s=t.sourceLayer,r=t.nodeIndex,l=t.tensorIndex);const u=s.inboundNodes[r];if(-1!==n.indexOf(u))throw new V(`The tensor ${t.name} at layer "${s.name}" is part of a cycle.`);if(-1!==e.indexOf(u))return;this.containerNodes.add($u.nodeKey(s,r)),s.id in i||(i[s.id]=Object.keys(i).length),-1===n.indexOf(u)&&n.push(u);const h=u.inboundLayers.length;for(let t=0;t<h;t++){const s=u.inputTensors[t],r=u.inboundLayers[t],i=u.nodeIndices[t],a=u.tensorIndices[t];o(s,e,n,r,i,a)}for(e.push(u);n.indexOf(u)>=0;)n.splice(n.indexOf(u),1);a.push(u)},l=[],u=[];for(const t of this.outputs)o(t,l,u);const h=a.slice().reverse();for(const t of h){n[t.id]=t,t.id in e||(e[t.id]=0);let i=e[t.id];const a=null==s[t.outboundLayer.id]?0:s[t.outboundLayer.id];i=Math.max(i,a),s[t.outboundLayer.id]=i,r[t.outboundLayer.id]=t.outboundLayer,e[t.id]=i;for(let s=0;s<t.inboundLayers.length;s++){const r=t.inboundLayers[s],a=t.nodeIndices[s],o=r.inboundNodes[a],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(i+1,l),n[o.id]=o}}const c={};for(const t in e){const s=e[t];s in c||(c[s]=[]),c[s].push(n[t])}const p={};for(const t in s){const e=s[t];e in p||(p[e]=[]),p[e].push(r[t])}let d=Object.keys(p).map((t=>parseInt(t,10))).sort(at);this.layers=[];for(const t of d){const e=p[t];e.sort(((t,e)=>{const n=i[t.id],s=i[e.id];return n<s?-1:n>s?1:0}));for(const t of e)t instanceof $u&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=p,d=Object.keys(c).map((t=>parseInt(t,10))).sort(at);const f=this.inputs.slice(),g=[];for(const t of d)for(const e of c[t]){const t=e.outboundLayer;if(null!=t){for(const n of e.inputTensors)if(-1===f.indexOf(n))throw new V(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${t.name}". The following previous layers were accessed without issue: ${g}`);for(const t of e.outputTensors)f.push(t);g.push(t.name)}}this.nodesByDepth=c;const m=this.layers.map((t=>t.name));for(const t of m){const e=m.filter((e=>e===t)).length;if(1!==e)throw new V(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(m))}this.outboundNodes=[],this.inboundNodes=[],new Fe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((t=>null)),outputMasks:this.outputs.map((t=>null)),inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs.map((t=>t.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach((e=>{e._trainableWeights.forEach((e=>e.trainable=t))})),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new q("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const n={};let s=0;for(const t of this.layers)for(const e of t.weights){if(null!=n[e.originalName])throw new q(`Duplicate weight name: ${e.originalName}`);n[e.originalName]=e,s++}const r=[];for(const s in t){let i=s;if(null==n[s]){const t=s.split("/");i=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=n[i])r.push([n[i],t[s]]);else if(e)throw new q(`Provided weight data has no target variable: ${s}`);delete n[i]}if(e){const t=[];for(const e in n)t.push(e);if(t.length>0)throw new q(`${t.length} of ${s} weights are not set: ${t}`)}Te(r)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 3.19.0",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const n=Iu(this.updatedConfig());return e?JSON.stringify(n):n}call(t,e){return s((()=>{t=Q(t);const n=new Pe;for(let e=0;e<this.inputs.length;++e)n.add(this.inputs[e],t[e]);return Ke(this.outputs,n,e)}))}computeMask(t,e){return s((()=>{let n;return t=Q(t),n=null==e?J(null,t.length):Q(e),this.runInternalGraph(t,n)[1]}))}computeOutputShape(t){const e=Ne(t);if(e.length!==this.inputLayers.length)throw new q(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let t=0;t<e.length;t++){const s=this.inputLayers[t],r=e[t];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(at);if(s.length>1)for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map((t=>t.id)).indexOf(e.id))continue;const s=[];for(let e=0;e<t.inboundLayers.length;e++){const r=t.inboundLayers[e],i=t.nodeIndices[e],a=t.tensorIndices[e],o=n[`${r.name}_${i}_${a}`];s.push(o)}const r=Ne(e.computeOutputShape(X(s))),i=e.inboundNodes.indexOf(t);for(let t=0;t<r.length;t++){n[`${e.name}_${i}_${t}`]=r[t]}}}const r=[],i=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],n=this.outputLayersNodeIndices[t],s=this.outputLayersTensorIndices[t],r=`${e.name}_${n}_${s}`;i.push(r)}for(let t=0;t<i.length;t++){const e=i[t];Z(e in n),r.push(n[e])}return X(r)}runInternalGraph(t,e){null==e&&(e=J(null,t.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],i=t[s],a=e[s];n[r.id]=[i,a]}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(at);for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,s=t.inputTensors,r=t.outputTensors,i=new Array;for(const t of s)t.id in n&&i.push(n[t.id]);if(i.length===s.length){let s,a,o,l,u={};if(null!=t.callArgs&&(u=t.callArgs),1===i.length){const[t,n]=i[0];null==u.mask&&(u.mask=n),o=Q(e.call(t,u)),l=Q(e.computeMask(t,n)),s=[t],a=[n]}else s=i.map((t=>t[0])),a=i.map((t=>t[1])),null==u.mask&&(u.mask=a),o=Q(e.call(s,u)),l=Q(e.computeMask(s,a));if(e.activityRegularizer)throw new j("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<r.length;++t){const e=r[t],s=o[t],i=l[t];n[e.id]=[s,i]}}}}const r=[],i=[],a=[];for(const t of this.outputs){Z(t.id in n,`Could not compute output ${t.name} : ${t.id}`);const[e,s]=n[t.id];a.push(e.shape),r.push(e),i.push(s)}return[r,i,a]}buildNodeConversionMap(t){const e={};let n;for(const t of this.layers){n=t instanceof $u?1:0;for(let s=0;s<t.inboundNodes.length;s++){const r=$u.nodeKey(t,s);this.containerNodes.has(r)&&(e[r]=n,n+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new q(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new q("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new q(`No such layer: ${t}`)}calculateLosses(){return s((()=>{const t=[];for(const e of this.layers)for(let n=0;n<e.inboundNodes.length;++n){const s=$u.nodeKey(e,n);this.containerNodes.has(s)&&t.push(...e.calculateLosses())}return t}))}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),n=[];for(const t of this.layers){const s=t.getClassName(),r=t.getConfig(),i=[];for(let n=0;n<t.inboundNodes.length;n++){const s=t.inboundNodes[n],r=$u.nodeKey(t,n);let a={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),a=s.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),a={}}if(s.inboundLayers.length>0){const t=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],i=s.nodeIndices[n],o=s.tensorIndices[n];let l=e[$u.nodeKey(r,i)];null==l&&(l=0),t.push([r.name,l,o,a])}i.push(t)}}}const a={};a.name=t.name,a.className=s,a.config=r,a.inboundNodes=i,n.push(a)}t.layers=n;const s=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t],r=this.inputLayersNodeIndices[t],i=$u.nodeKey(n,r);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.inputLayersTensorIndices[t];s.push([n.name,a,o])}t.inputLayers=s;const r=[];for(let t=0;t<this.outputLayers.length;t++){const n=this.outputLayers[t],s=this.outputLayersNodeIndices[t],i=$u.nodeKey(n,s);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.outputLayersTensorIndices[t];r.push([n.name,a,o])}return t.outputLayers=r,t}static fromConfig(t,e,n={},s=!1){const r={},i={};function a(t,e){t.name in i?i[t.name].push(e):i[t.name]=[e]}function o(t,e){const n=[];let s;for(const i of e){const o=i[0],l=i[1],u=i[2];if(s=null==i[3]?{}:i[3],!(o in r))return void a(t,e);const h=r[o];if(h.inboundNodes.length<=l)return void a(t,e);const c=h.inboundNodes[l];n.push(c.outputTensors[u])}n.length>0&&t.apply(X(n),s)}function l(t){const n=t.name,i=Jl(t,null!=e.customObjects?e.customObjects:{});i.setFastWeightInitDuringBuild(s),r[n]=i;t.inboundNodes.forEach((t=>{if(!(t instanceof Array))throw new q(`Corrupted configuration, expected array for nodeData: ${t}`);a(i,t)}))}const u=e.name,h=e.layers;for(const t of h)l(t);for(;!lt(i);)for(const t of h){const e=r[t.name];if(e.name in i){const t=i[e.name];delete i[e.name];for(const n of t)o(e,n)}}const c=[],p=[],d=e.inputLayers;for(const t of d){const e=t[0],n=t[1],s=t[2];Z(e in r);const i=r[e].inboundNodes[n].outputTensors;c.push(i[s])}const f=e.outputLayers;for(const t of f){const e=t[0],n=t[1],s=t[2];Z(e in r);const i=r[e].inboundNodes[n].outputTensors;p.push(i[s])}return new t({inputs:c,outputs:p,name:u})}get stateful(){if(this._stateful)throw new q("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){s((()=>{this.layers.forEach((t=>{t.stateful&&t.resetStates()}))}))}}function Cu(t,e){return function(t,e,n){const s=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>null));if(1===s)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==s)throw new Error(`Provided ${n} is an array of ${t.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const n=[];return e.forEach((e=>{e in t?n.push(t[e]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${e} keys. Provided ${n} not understood: ${JSON.stringify(t)}`)}(t,e,"classWeight")}async function Tu(t,e,n,i){if(null!=e||null!=i)throw new Error("Support sampleWeight is not implemented yet");if(null!=n){const e=s((()=>{if(1===t.shape.length)return N(t);if(2===t.shape.length){if(t.shape[1]>1){return E(t,1)}if(1===t.shape[1])return I(t,[t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),i=Array.from(await e.data());g(e);const a=[];return i.forEach((t=>{if(null==n[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);a.push(n[t])})),r(a,"float32")}return null}function zu(t,e){return l(t,e)}function _u(e,n){let s,r;const i=n;s=i.xs,r=i.ys,t.util.assert(null!=s&&null!=r,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${n}`));const a=Du("input",e.inputNames,s),o=Du("output",e.outputNames,r),l=a[0].shape[0];t.util.assert(a.length===e.inputs.length,(()=>`LayersModel has ${e.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(e.inputNames)})`)),t.util.assert(o.length===e.outputs.length,(()=>`LayersModel has ${e.outputs.length} outputs, but the dataset provides ${o.length} outputs.  (Expected output keys: ${JSON.stringify(e.outputNames)})`));for(let n=0;n<a.length;n++)t.util.assert(a[n].shape[0]===l,(()=>`Batch size mismatch: input ${e.inputNames[n]} has ${a[n].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`));for(let n=0;n<o.length;n++)t.util.assert(o[n].shape[0]===l,(()=>`Batch size mismatch: output ${e.outputNames[n]} has ${o[n].shape[0]}; expected  ${l} based on input ${e.inputNames[0]}.`));return{xs:a,ys:o}}function Du(e,n,s){if(s instanceof t.Tensor)return[s];if(Array.isArray(s))return t.util.assert(s.length===n.length,(()=>`Received an array of ${s.length} Tensors, but expected ${n.length} to match the ${e} keys ${n}.`)),s;{const t=[];for(const r of n){if(null==s[r])throw new q(`The feature data generated by the dataset lacks the required ${e} key '${r}'.`);t.push(s[r])}return t}}async function Fu(e,n,s){const r=null!=s.batchesPerEpoch;if(t.util.assert(null!=e.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),t.util.assert(null!=s,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),t.util.assert(null!=s.epochs&&s.epochs>0&&Number.isInteger(s.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${s.epochs}`)),t.util.assert(!r||s.batchesPerEpoch>0&&Number.isInteger(s.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${s.batchesPerEpoch}`)),t.util.assert(null==s.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),e.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");e.isTraining=!0;try{const i=null!=s.validationData;let a,o;if(i)if(Mu(s.validationData))t.util.assert(null==s.validationBatches||s.validationBatches>0&&Number.isInteger(s.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${s.validationBatches}`));else{const t=function(t){if(3===t.length)throw new j("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(s.validationData);a=t.xs,o=t.ys}const l=e.makeTrainFunction(),u=e.getDedupedMetricsNames();let h;h=i?u.slice().concat(u.map((t=>"val_"+t))):u.slice();const c=jl(s.callbacks,s.yieldEvery),p=null==s.verbose?1:s.verbose,{callbackList:d,history:f}=Hl(c,p,s.epochs,null,null,function(t,e){let n=null;null!=e.batchesPerEpoch?n=e.batchesPerEpoch:Number.isFinite(t.size)&&(n=t.size);return n}(n,s),null,i,h);d.setModel(e),e.history=f,await d.onTrainBegin(),e.stopTraining_=!1;let g=null==s.initialEpoch?0:s.initialEpoch,m=await n.iterator();for(;g<s.epochs;){const h={};await d.onEpochBegin(g);let c=0,p=0;for(r||(m=await n.iterator());!r||c<s.batchesPerEpoch;){const n=await m.next();if(r&&n.done){console.warn(`You provided \`batchesPerEpoch\` as ${s.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+s.batchesPerEpoch*s.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=n.value){const{xs:r,ys:i}=_u(e,n.value),a={};a.batch=p,a.size=r[0].shape[0],await d.onBatchBegin(p,a);const o=[];if(null!=s.classWeight){const t=Cu(s.classWeight,e.outputNames);for(let e=0;e<t.length;++e)o.push(await Tu(i[e],null,t[e]))}const h=r.concat(i).concat(o),f=l(h);t.dispose(h);for(let e=0;e<u.length;++e){const n=u[e],s=f[e];a[n]=s,t.keep(s)}await d.onBatchEnd(p,a),Pl(a),p++,c++}if(r?c>=s.batchesPerEpoch:n.done){if(i){let t;t=Mu(s.validationData)?Q(await e.evaluateDataset(s.validationData,{batches:s.validationBatches})):Q(e.evaluate(a,o,{batchSize:null==s.validationBatchSize?32:s.validationBatchSize,verbose:0}));for(let n=0;n<e.metricsNames.length;++n)h[`val_${e.metricsNames[n]}`]=t[n]}break}if(e.stopTraining_)break}if(await d.onEpochEnd(g,h),g++,e.stopTraining_)break}return await d.onTrainEnd(),await e.history.syncData(),e.history}finally{e.isTraining=!1}}function Mu(t){return"function"==typeof t.iterator}function Lu(e){t.util.assert(e>0&&Number.isInteger(e),(()=>`batchSize is required to be a positive integer, but got ${e}`))}function Ru(t,e,n){return null==t?[null]:Array.isArray(t)?t.map((t=>Wt(t,e,n-e))):Wt(t,e,n-e)}function Ou(e,n){return t.tidy((()=>null==e?null:Array.isArray(e)?e.map((t=>Ou(t,n))):Jt(e,"int32"===n.dtype?n:t.cast(n,"int32"))))}function Bu(t,e){const n=[];let s=0,r=null;for(;s<t;)r=s+e,r>=t&&(r=t),n.push([s,r]),s=r;return n}async function Pu(n,s,i,a={}){if(n.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let o,l,u,h,c,p,d,f,g;n.isTraining=!0;try{const m=null==a.batchSize?32:a.batchSize;Lu(m);const b=!1,y=await n.standardizeUserData(s,i,a.sampleWeight,a.classWeight,b,m);o=y[0],l=y[1],g=y[2];let w,k=!1;if(null!=a.validationData&&a.validationData.length>0){if(k=!0,2!==a.validationData.length)throw 3===a.validationData.length?new j("validationData including sample weights is not supported yet."):new q(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${a.validationData} is invalid.`);c=a.validationData[0],p=a.validationData[1];const t=!0,e=await n.standardizeUserData(c,p,null,null,t,m);d=e[0],f=e[1],w=d.concat(f)}else if(null!=a.validationSplit&&a.validationSplit>0&&a.validationSplit<1){k=!0;const t=Math.floor(o[0].shape[0]*(1-a.validationSplit)),e=o[0].shape[0];d=Ru(o,t,e),u=o,o=Ru(o,0,t),f=Ru(l,t,e),h=l,l=Ru(l,0,t),w=d.concat(f)}else null!=a.validationSteps&&(k=!0);const v=o.concat(l).concat(g);n.checkTrainableWeightsConsistency();const x=n.makeTrainFunction(),S=n.getDedupedMetricsNames();let N,E;k?(n.makeTestFunction(),N=n.testFunction,E=S.slice().concat(S.map((t=>"val_"+t)))):(N=null,w=[],E=S.slice());const I=jl(a.callbacks,a.yieldEvery),A=await async function(n,s,i,a,o,l,u,h,c,p,d,f,g,m,b){null==o&&(o=32),null==l&&(l=1),null==d&&(d=!0),null==g&&(g=0);let y=!1;if(null!=c&&null!=p&&(y=!0),null!=b&&(y=!0,null==m))throw new q("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const w=n.checkNumSamples(i,o,m,"steps_per_epoch");let k;null!=w&&(k=Lt(0,w)),null==u&&(u=1);const{callbackList:v,history:x}=Hl(h,u,l,g,w,m,o,y,f);v.setModel(n),n.history=x,await v.onTrainBegin(),n.stopTraining_=!1;for(let u=g;u<l;++u){await v.onEpochBegin(u);const l={};if(null!=m)throw new j("stepsPerEpoch mode is not implemented yet.");{if("batch"===d)throw new j("batch shuffling is not implemneted yet");d&&e.shuffle(k);const u=r(k),h=Bu(w,o);for(let e=0;e<h.length;++e){const r={};if(await v.onBatchBegin(e,r),t.tidy((()=>{const d=h[e][0],f=h[e][1],g=Wt(u,d,f-d);r.batch=e,r.size=f-d;const m=Ou(i,g),b=s(m);for(let e=0;e<a.length;++e){const n=a[e],s=b[e];r[n]=s,t.keep(s)}if(e===h.length-1&&y){const e=n.testLoop(c,p,o);for(let n=0;n<a.length;++n){const s=a[n],r=e[n];t.keep(r),l["val_"+s]=r}}})),await v.onBatchEnd(e,r),Pl(r),n.stopTraining_)break}u.dispose()}if(await v.onEpochEnd(u,l),n.stopTraining_)break}return await v.onTrainEnd(),await n.history.syncData(),n.history}(n,x,v,S,m,a.epochs,a.verbose,I,N,w,a.shuffle,E,a.initialEpoch,null,null);return A}finally{n.isTraining=!1,Uu(o,s),Uu(l,i),Uu(u,s),Uu(h,i),Uu(d,c),Uu(f,p),null!=g&&t.dispose(g)}}function Wu(t){const e=[];t instanceof A&&(t=[t]);for(let n=0;n<t.length;++n){const s=t[n];if(1===s.rank)e.push(Pt(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");e.push(s)}}return e}function Uu(t,e){if(null==t)return;const n=[];if(e instanceof A)n.push(e.id);else if(Array.isArray(e))e.forEach((t=>n.push(t.id)));else if(null!=e)for(const t in e){const s=e[t];n.push(s.id)}const s=[];if(t instanceof A)-1===n.indexOf(t.id)&&s.push(t);else if(Array.isArray(t))t.forEach((t=>{-1===n.indexOf(t.id)&&s.push(t)}));else if(null!=t)for(const e in t){const r=t[e];-1===n.indexOf(r.id)&&s.push(r)}s.forEach((t=>{t.isDisposed||t.dispose()}))}function Ku(t){return Array.isArray(t)}function Vu(t){return!function(t){return t instanceof A}(t)&&!Ku(t)}function qu(t,e,n,s=!0,r=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(Ku(t)&&t.length>0)e=!0;else if(Vu(t)){for(const n in t)if(t.hasOwnProperty(n)){e=!0;break}}else e=!0;if(e)throw new q(`Error when checking model ${r} expected no data, but got ${t}`)}return[]}if(null==t)return e.map((t=>null));let i;if(Vu(t)){i=[];for(const n of e){if(null==t[n])throw new q(`No data provided for "${n}". Need data for each key in: ${e}`);i.push(t[n])}}else if(Ku(t)){if(t.length!==e.length)throw new q(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): ${t}`);i=t}else{if(e.length>1)throw new q(`The model ${r} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${t.shape}`);i=[t]}if(i=Wu(i),null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new q(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s). but got array with shape ${a.shape}`);for(let e=0;e<n[t].length;++e){if(0===e&&!s)continue;const i=a.shape[e],o=n[t][e];if(null!=o&&o>=0&&i!==o)throw new q(`${r} expected a batch of elements where each example has shape [${n[t].slice(1,n[t].length)}] (i.e.,tensor shape [*,${n[t].slice(1,n[t].length)}]) but the ${r} received an input with ${a.shape[0]} examples, each with shape [${a.shape.slice(1,a.shape.length)}] (tensor shape [${a.shape}])`)}}return i}function ju(t,e,n,s=!0,r=""){let i;if(Array.isArray(t)){if(t.length!==e.length)throw new q(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);i=t}else{if(e.length>1)throw new q(`The model expects ${e.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(t.shape)}.`);i=[t]}if(null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const a=i[t];if(a.shape.length!==n[t].length)throw new q(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s), but got array with shape ${JSON.stringify(a.shape)}`);for(let i=0;i<n[t].length;++i){if(0===i&&!s)continue;const o=a.shape[i],l=n[t][i];if(null!=l&&l!==o)throw new q(`Error when checking ${r}: expected ${e[t]} to have shape ${JSON.stringify(n[t])} but got array with shape ${JSON.stringify(a.shape)}.`)}}}class Gu extends $u{constructor(t){super(t),this.isTraining=!1}summary(t,e,n=console.log){if(!this.built)throw new q("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");ku(this,t,e,n)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const e={Adagrad:()=>S.adagrad(.01),Adadelta:()=>S.adadelta(1,.95,Ot()),Adam:()=>S.adam(.001,.9,.999,Ot()),Adamax:()=>S.adamax(.002,.9,.999,Ot(),0),RMSProp:()=>S.rmsprop(.001,.9,0,Ot()),SGD:()=>S.sgd(.01)};if(e.adagrad=e.Adagrad,e.adadelta=e.Adadelta,e.adam=e.Adam,e.adamax=e.Adamax,e.rmsprop=e.RMSProp,e.sgd=e.SGD,t in e)return e[t]();throw new q(`Unknown Optimizer ${t}`)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof $))throw new q("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let e=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new q(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const n=t.loss;e=n.map((t=>iu(t)))}else{const n=iu(t.loss);this.outputs.forEach((t=>{e.push(n)}))}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new q(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: ${this.outputNames}`);for(const n of this.outputNames)null==t.loss[n]&&console.warn(`Output "${n}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${n} during training`),e.push(iu(t.loss[n]))}this.lossFunctions=e,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],n=this.outputNames[t];this.feedOutputNames.push(n),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const n=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],$t("loss",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}}));const s=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>[]));let n;if("string"==typeof t||"function"==typeof t)n=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${t}`);n=t}if(Array.isArray(n))return e.map((t=>n));{const t=[];for(const s of e){let e=n.hasOwnProperty(s)?n[s]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),r=(t,e,n)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([n,t])};$t("metric",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;(e=>{let n,s,i;for(const a of e){if("string"==typeof a&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(a)){const e=this.internalOutputShapes[t];let r;1===e[e.length-1]||this.lossFunctions[t]===nu?-1!==["accuracy","acc"].indexOf(a)?s=au:-1!==["crossentropy","ce"].indexOf(a)&&(s=cu):this.lossFunctions[t]===eu?-1!==["accuracy","acc"].indexOf(a)?s=pu:-1!==["crossentropy","ce"].indexOf(a)&&(s=fu):-1!==["accuracy","acc"].indexOf(a)?s=ou:-1!==["crossentropy","ce"].indexOf(a)&&(s=du),-1!==["accuracy","acc"].indexOf(a)?r="acc":-1!==["crossentropy","ce"].indexOf(a)&&(r="ce"),i=s,n=""+r}else{const t=mu(a);i=t,n=""+bu(a)}let e;$t(n,(()=>{e=i})),r(t,n,e)}})(s[t])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,n={}){const s=null==n.batchSize?32:n.batchSize;Lu(s);const r=this.standardizeUserDataXY(t,e,!0,s);try{const i=r[0].concat(r[1]);this.makeTestFunction();const a=this.testFunction;return X(this.testLoop(a,i,s,n.verbose,n.steps))}finally{Uu(r[0],t),Uu(r[1],e)}}async evaluateDataset(e,n){return this.makeTestFunction(),async function(e,n,s){const r=null!=(s=s||{}).batches,i=e.testFunction;let a=[];if(s.verbose>0)throw new j("Verbose mode is not implemented yet.");t.util.assert(!r||s.batches>0&&Number.isInteger(s.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(s.batches)}`));const o="function"==typeof n.next?n:await n.iterator();let l=0,h=0;for(;!r||h<s.batches;){const n=await o.next();if(a=t.tidy((()=>{if(n.value){const{xs:s,ys:r}=_u(e,n.value),o=s.concat(r),c=t.tidy((()=>i(o)));if(t.dispose(o),0===h)for(let t=0;t<c.length;++t)a.push(u(0));const p=o[0].shape[0];for(let e=0;e<c.length;++e){const n=c[e],s=a[e];a[e]=t.tidy((()=>t.add(a[e],t.mul(p,n)))),h>0&&t.dispose(s)}t.dispose(c),l+=p,++h}return a})),n.done){r&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${s.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let e=0;e<a.length;++e){const n=a[e];a[e]=t.div(a[e],l),t.dispose(n)}return X(a)}(this,e,n)}checkNumSamples(t,e,n,s="steps"){let r;if(null!=n){if(r=null,null!=e)throw new q(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${e}`)}else{if(null==t)throw new q(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return r}execute(t,e){if(Array.isArray(e)&&0===e.length)throw new q("`outputs` is an empty Array, which is not allowed.");const n=Array.isArray(e),s=n?e:[e],r=this.retrieveSymbolicTensors(s),i=new Pe;if(t instanceof A&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new q(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)i.add(this.inputs[e],t[e])}else for(const e of this.inputs){const n=t[e.name];if(null==n)throw new q(`No value is provided for the model's input ${e.name}`);i.add(e,n)}const a=Ke(r,i);return n?a:a[0]}retrieveSymbolicTensors(t){const e=J(null,t.length);let n=t.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],i=r.map((t=>t.name));for(let s=0;s<t.length;++s){const a=i.indexOf(t[s]);if(-1!==a&&(e[s]=r[a],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw e.forEach(((e,s)=>{null==e&&n.push(t[s])})),new q(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return e}predictLoop(e,n=32,s=!1){return t.tidy((()=>{const r=this.checkNumSamples(e);if(s)throw new j("Verbose predictLoop() is not implemented yet.");const i=Bu(r,n),a=this.outputs.map((t=>[]));for(let n=0;n<i.length;++n){t.tidy((()=>{const t=i[n][0],s=i[n][1],r=Ru(e,t,s),a=[];if(Array.isArray(r))for(let t=0;t<r.length;++t)a.push({key:this.inputs[t],value:r[t]});else a.push({key:this.inputs[0],value:r});const o=new Pe(a);return Ke(this.outputs,o)})).forEach(((t,e)=>a[e].push(t)))}return X(a.map((e=>t.concat(e,0))))}))}predict(t,e={}){const n=Wu(t);ju(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==e.batchSize?32:e.batchSize;return Lu(s),this.predictLoop(n,s)}finally{Uu(n,t)}}predictOnBatch(t){ju(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,n,s=!0,r){if(null==this.optimizer_)throw new V("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const i=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===eu?i.push(e.slice(0,e.length-1).concat([1])):i.push(e)}if(function(t,n,s){const r=ot(t.map((t=>t.shape[0])));r.sort();const i=ot(n.map((t=>t.shape[0])));if(i.sort(),r.length>1)throw new q(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((t=>t.shape)))}`);if(i.length>1)throw new q(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(n.map((t=>t.shape)))}`);if(r.length>0&&i.length>0&&!e.arraysEqual(r,i))throw new q(`Input Tensors should have the same number of samples as target Tensors. Found ${r[0]} input sample(s) and ${i[0]} target sample(s).`)}(t=qu(t,this.feedInputNames,this.feedInputShapes,!1,"input"),n=qu(n,this.feedOutputNames,i,!1,"target")),function(t,e,n){const s=[Yl,nu,tu];for(let r=0;r<t.length;++r){const i=t[r],a=e[r],o=n[r];if(null!=a){if(a===tu&&1===i.shape[i.shape.length-1])throw new q(`You are passing a target array of shape ${i.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(a)){const t=i.shape.slice(1),e=o.slice(1);for(let n=0;n<t.length;++n){const s=t[n],r=e[n];if(null!=r&&s!==r)throw new q(`A target Tensor with shape ${i.shape} was passed for an output of shape ${o}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(n,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=r&&r>0&&t[0].shape[0]%r!=0)throw new q(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${r}. Found: ${t[0].shape[0]} sample(s).`);return[t,n]}async standardizeUserData(t,e,n,s,r=!0,i){const[a,o]=this.standardizeUserDataXY(t,e,r,i);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const t=Cu(s,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await Tu(o[e],null,t[e]))}return[a,o,l]}testLoop(e,n,s,i=0,a){return t.tidy((()=>{const o=this.checkNumSamples(n,s,a,"steps"),l=[];if(i>0)throw new j("Verbose mode is not implemented yet.");if(null!=a)throw new j("steps mode in testLoop() is not implemented yet");{const i=Bu(o,s),a=r(Lt(0,o));for(let s=0;s<i.length;++s){const r=i[s][0],o=i[s][1],h=Wt(a,r,o-r),c=Ou(n,h),p=e(c);if(0===s)for(let t=0;t<p.length;++t)l.push(u(0));for(let e=0;e<p.length;++e){const n=p[e];l[e]=t.add(l[e],t.mul(o-r,n))}}for(let e=0;e<l.length;++e)l[e]=t.div(l[e],o)}return l}))}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let n=0;n<t.length;++n){const s=t[n];let r=s;if(Y(t,s)>1){r+=`_${Y(t.slice(0,n),s)}`}e.push(r)}return e}makeTrainFunction(){return e=>{const n=[],s=e.slice(0,this.inputs.length),r=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),i=e.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],o=this.collectedTrainableWeights.map((t=>t.read()));return[this.optimizer_.minimize((()=>{const e=[];for(let t=0;t<this.inputs.length;++t)e.push({key:this.inputs[t],value:s[t]});const o=new Pe(e),l=Ke(this.outputs,o,{training:!0});let u;for(let e=0;e<this.lossFunctions.length;++e){let s=(0,this.lossFunctions[e])(r[e],l[e]);null!=i[e]&&(s=zu(s,i[e]));const a=t.mean(s);n.push(a),u=0===e?s:t.add(u,s)}for(let e=0;e<this.metricsTensors.length;++e){let s;if(this.outputs.length>1&&e<this.outputs.length)s=n[e];else{const n=this.metricsTensors[e][0],i=this.metricsTensors[e][1];s=t.mean(n(r[i],l[i]))}t.keep(s),a.push(s)}return u=t.mean(u),this.calculateLosses().forEach((e=>{u=t.add(u,e)})),u}),!0,o)].concat(a)}}makeTestFunction(){this.testFunction=e=>t.tidy((()=>{const n=[];let s;const r=e.slice(0,this.inputs.length),i=e.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:r[t]});const o=new Pe(a),l=Ke(this.outputs,o);for(let e=0;e<this.lossFunctions.length;++e){const r=this.lossFunctions[e],a=t.mean(r(i[e],l[e]));s=0===e?a:t.add(s,a),n.push(s)}for(let e=0;e<this.metricsTensors.length;++e){const s=this.metricsTensors[e][0],r=this.metricsTensors[e][1],a=t.mean(s(i[r],l[r]));n.push(a)}return n}))}async fit(t,e,n={}){return Pu(this,t,e,n)}async fitDataset(t,e){return Fu(this,t,e)}async trainOnBatch(e,n){const s=await this.standardizeUserData(e,n),r=s[0],i=s[1],a=this.makeTrainFunction()(r.concat(i)),o=[];for(const t of a){const e=await t.data();o.push(e[0])}return t.dispose(a),Uu(s[0],e),Uu(s[1],n),X(o)}getNamedWeights(t){const e=[],n=null!=t&&t.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let t=0;t<s.length;++t)n&&!s[t].trainable||e.push({name:s[t].originalName,tensor:r[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const e=super.dispose();if(0===e.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const n=t.memory().numTensors;this.optimizer_.dispose(),e.numDisposedVariables+=n-t.memory().numTensors}return e}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=tt(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map((t=>tt(t)))}else{const e=Object.keys(this.loss);t={};const n=this.loss;for(const s of e){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");t[s]=tt(n[s])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[tt(bu(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((t=>tt(bu(t))));{const t={};for(const e in this.metrics)t[e]=tt(bu(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=Jl(Eu(t.optimizer_config));let n,s;if("string"==typeof t.loss)n=et(t.loss);else if(Array.isArray(t.loss))n=t.loss.map((t=>et(t)));else if(null!=t.loss){n={};for(const e in t.loss)n[e]=et(t.loss[e])}if(Array.isArray(t.metrics))s=t.metrics.map((t=>et(t)));else if(null!=t.metrics){s={};for(const e in t.metrics)s[e]=et(t.metrics[e])}this.compile({loss:n,metrics:s,optimizer:e})}async save(t,e){if("string"==typeof t){const e=C.getSaveHandlers(t);if(0===e.length)throw new q(`Cannot find any save handlers for URL '${t}'`);if(e.length>1)throw new q(`Found more than one (${e.length}) save handlers for URL '${t}'`);t=e[0]}if(null==t.save)throw new q("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const n=await C.encodeWeights(this.getNamedWeights(e)),s={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.19.0",convertedBy:null};if(null!=e&&e.includeOptimizer&&null!=this.optimizer){s.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:e,specs:r}=await C.encodeWeights(await this.optimizer.getWeights(),t);n.specs.push(...r),n.data=C.concatenateArrayBuffers([n.data,e])}if(null!=this.userDefinedMetadata){const t=!0;yu(this.userDefinedMetadata,this.name,t),s.userDefinedMetadata=this.userDefinedMetadata}return s.weightData=n.data,s.weightSpecs=n.specs,t.save(s)}setUserDefinedMetadata(t){yu(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}Gu.className="Model",i.registerClass(Gu);class Hu extends Gu{}async function Ju(t,e){if(null==e&&(e={}),"string"==typeof t){const n=C.getLoadHandlers(t,e);if(0===n.length)n.push(C.browserHTTPRequest(t,e));else if(n.length>1)throw new q(`Found more than one (${n.length}) load handlers for URL '${t}'`);t=n[0]}return async function(t,e,n){null==n&&(n={});if(null==t.load)throw new q("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const s=await t.load();let r=s.modelTopology;null!=r.model_config&&(r=r.model_config);const i=null==n.strict||n.strict,a=null!=s.weightData&&null!=s.weightSpecs&&i,o=Jl(Eu(r),e,a),l=s.trainingConfig;null!=l&&o.loadTrainingConfig(l);null!=s.userDefinedMetadata&&o.setUserDefinedMetadata(s.userDefinedMetadata);if(null!=s.weightData){if(null==s.weightSpecs)throw new q("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:e}=function(t,e){const n=C.decodeWeights(t,e),s={},r=[];return e.forEach((t=>{"optimizer"===t.group?r.push({name:t.name,tensor:n[t.name]}):s[t.name]=n[t.name]})),{modelWeights:s,optimizerWeights:r}}(s.weightData,s.weightSpecs);o.loadWeights(t,i),null!=o.optimizer&&e.length>0&&await o.optimizer.setWeights(e),g(t),g(e.map((t=>t.tensor)))}return o}(t,void 0,e)}Hu.className="Functional",i.registerClass(Hu);class Zu extends Gu{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:bt("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some((t=>t<0)))throw new q(`Negative dimension size caused by adding layer ${t.name} with input shape [${t.inboundNodes[0].inputTensors[0].shape}]`)}add(t){const e=t instanceof Zu||t instanceof Gu;let n;if(e){if(n=t,1!==n.outputs.length)throw new q("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new q("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new q("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=Be({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==t.inboundNodes.length)throw new q(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new q("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=Re(this.outputs[0])}this.inboundNodes=[],new Fe({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:J(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(Ie(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Gu({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,n=console.log){this.built||this.build(),super.summary(t,e,n)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,n={}){if(!this.built)throw new V("The model needs to be compiled before being used.");return this.model.evaluate(t,e,n)}async evaluateDataset(t,e){if(!this.built)throw new V("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,n={}){if(!this.built)throw new V("The model needs to be compiled before being used.");return this.model.fit(t,e,n)}async fitDataset(t,e){if(!this.built)throw new V("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,n,s={},r=!1){let i,a={};if(n instanceof Array){if(null==n[0].className||"Merge"===n[0].className)throw new q("Legacy serialization format not supported yet.");i=n}else e.assert(null!=n.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),i=n.layers,delete n.layers,a=n;const o=new t(a);if(!(o instanceof Zu))throw new j(`Sequential.fromConfig called on non-Sequential input: ${o}`);for(const t of i){const e=Jl(t,void 0,r);r&&e.setFastWeightInitDuringBuild(!0),o.add(e)}return o}set stopTraining(t){if(null==this.model)throw new q("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new q("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const n={};n.className=e.getClassName(),n.config=e.getConfig(),t.push(n)}return{name:this.name,layers:t}}}function Yu(t){return new Gu(t)}function Xu(t){return new Zu(t)}function Qu(t,e){return null==e&&(e={}),Ju(t,e)}function th(t){return Be(t)}function eh(t,e){Gl.registerCallbackConstructor(t,e)}Zu.className="Sequential",i.registerClass(Zu);class nh extends i.Serializable{getConfig(){return{}}}class sh extends nh{apply(e,n=1){return function(e,n=1){if(1!==n)throw new j(`Support for alpha values other than 1 (${n}) is not implemented yet.`);return t.elu(e)}(e,n)}}sh.className="elu",i.registerClass(sh);class rh extends nh{apply(e){return t.selu(e)}}rh.className="selu",i.registerClass(rh);class ih extends nh{apply(e){return t.relu(e)}}ih.className="relu",i.registerClass(ih);class ah extends nh{apply(e){return s((()=>t.minimum(6,t.relu(e))))}}ah.className="relu6",i.registerClass(ah);class oh extends nh{apply(t){return t}}oh.className="linear",i.registerClass(oh);class lh extends nh{apply(e){return t.sigmoid(e)}}lh.className="sigmoid",i.registerClass(lh);class uh extends nh{apply(e){return function(e){return s((()=>{const n=t.add(.5,t.mul(.2,e));return t.clipByValue(n,0,1)}))}(e)}}uh.className="hardSigmoid",i.registerClass(uh);class hh extends nh{apply(e){return t.softplus(e)}}hh.className="softplus",i.registerClass(hh);class ch extends nh{apply(e){return function(e){return s((()=>t.div(e,t.add(t.abs(e),1))))}(e)}}ch.className="softsign",i.registerClass(ch);class ph extends nh{apply(e){return t.tanh(e)}}ph.className="tanh",i.registerClass(ph);class dh extends nh{apply(e,n=-1){return t.softmax(e,n)}}dh.className="softmax",i.registerClass(dh);class fh extends nh{apply(e,n=-1){return t.logSoftmax(e,n)}}fh.className="logSoftmax",i.registerClass(fh);class gh extends nh{apply(e,n=1){return s((()=>t.mul(t.sigmoid(t.mul(e,n)),e)))}}gh.className="swish",i.registerClass(gh);class mh extends nh{apply(e){return s((()=>t.mul(e,t.tanh(t.softplus(e)))))}}function bh(t){return t.getClassName()}function yh(t,e={}){return it(t,i.SerializationMap.getMap().classNameMap,e,"activation")}function wh(t){if(null==t){const t={className:"linear",config:{}};return yh(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},yh(e)}return t instanceof nh?t:yh(t)}function kh(t){if(null!=t&&"object"!=typeof t)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${t}`)}mh.className="mish",i.registerClass(mh);class vh extends i.Serializable{}class xh extends vh{constructor(t){super(),kh(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(e){return s((()=>{let n=a([1]);return this.hasL1&&(n=k(n,T(t.mul(this.l1,z(e))))),this.hasL2&&(n=k(n,T(t.mul(this.l2,Zt(e))))),t.reshape(n,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}xh.className="L1L2",i.registerClass(xh);const Sh={l1l2:"L1L2"};function Nh(t){return st(t)}function Eh(t,e={}){return it(t,i.SerializationMap.getMap().classNameMap,e,"regularizer")}function Ih(t){if(null==t)return null;if("string"==typeof t){return Eh({className:t in Sh?Sh[t]:t,config:{}})}return t instanceof vh?t:Eh(t)}class Ah extends Le{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,e){t=Ee(t);let n=_(t);return null!=this.maxValue&&(n=D(n,0,this.maxValue)),n}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}Ah.className="ReLU",i.registerClass(Ah);class $h extends Le{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=Ee(t);return F(n,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}$h.className="LeakyReLU",i.registerClass($h);class Ch extends Le{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=xe(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Ih(t.alphaRegularizer),this.alphaConstraint=Ml(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new q(`Expected sharedAxes to be a number or an array of numbers, but got ${t.sharedAxes}`);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=Ie(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)n[e]=t[e];this.inputSpec=[new ze({ndim:t.length,axes:n})],this.built=!0}call(t,e){return t=Ee(t),M(t,this.alpha.read())}getConfig(){const t={alphaInitializer:ve(this.alphaInitializer),alphaRegularizer:Nh(this.alphaRegularizer),alphaConstraint:Dl(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}Ch.className="PReLU",i.registerClass(Ch);class Th extends Le{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new j(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,e){const n=Ee(t);return L(n)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Th.className="ELU",i.registerClass(Th);class zh extends Le{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,e){const n=Ee(t);return l(n,b(R(n,this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}zh.className="ThresholdedReLU",i.registerClass(zh);class _h extends Le{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new dh).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const n=Ee(t);return this.softmax(n,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Dh(t,e,n){if("number"==typeof t)return J(t,e);if(t.length!==e)throw new q(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let r=0;r<e;++r){const i=t[r];if((s=i)!==parseInt(s.toString(),10))throw new q(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number ${i}`)}return t;var s}function Fh(t,e,n,s,r=1){if(null==t)return t;let i;return i="same"===n?t:t-(e+(e-1)*(r-1))+1,Math.floor((i+s-1)/s)}function Mh(t,e,n,s){if(null==t)return null;if("valid"===s)t=t*e+Mt([n-e,0]);else{if("same"!==s)throw new q(`Unsupport padding mode: ${s}.`);t*=e}return t}function Lh(e,n){return s((()=>(Nt(n),"channelsFirst"===n?t.transpose(e,[0,2,3,1]):e)))}function Rh(e,n){return s((()=>(Nt(n),"channelsFirst"===n?t.transpose(e,[0,2,3,4,1]):e)))}function Oh(e,n,r,i=[1,1],a="valid",o,l,u=null){return s((()=>{if(null==o&&(o="channelsLast"),Nt(o),3!==e.rank&&4!==e.rank)throw new q(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${e.rank}.`);if(3!==n.rank&&4!==n.rank)throw new q(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${e.rank}.`);let s=Lh(e,o);if("causal"===a)throw new j("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return s=t.fused.conv2d({x:s,filter:n,strides:i,pad:"same"===a?"same":"valid",dilations:l,dataFormat:"NHWC",bias:r,activation:u}),"channelsFirst"===o&&(s=t.transpose(s,[0,3,1,2])),s}))}_h.className="Softmax",i.registerClass(_h);class Bh extends Le{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Bh.verifyArgs(e),this.rank=t,ct(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new j(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Dh(e.kernelSize,t,"kernelSize"),this.strides=Dh(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,Et(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,Nt(this.dataFormat),this.activation=wh(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=xe(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Ml(e.biasConstraint),this.biasRegularizer=Ih(e.biasRegularizer),this.activityRegularizer=Ih(e.activityRegularizer),this.dilationRate=Dh(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new q(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new q(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new q(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(t){if(Z("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!ht(t.kernelSize,"number",1,3))throw new q(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:bh(this.activation),useBias:this.useBias,biasInitializer:ve(this.biasInitializer),biasRegularizer:Nh(this.biasRegularizer),activityRegularizer:Nh(this.activityRegularizer),biasConstraint:Dl(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class Ph extends Bh{constructor(t,e){super(t,e),this.kernel=null,Ph.verifyArgs(e),this.filters=e.filters,ct(this.filters,"filters"),this.kernelInitializer=xe(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Ml(e.kernelConstraint),this.kernelRegularizer=Ih(e.kernelRegularizer)}build(t){t=Ie(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new q(`The channel dimension of the input should be defined. Found ${t[e]}`);const n=t[e],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:n}}],this.built=!0}call(e,n){return s((()=>{let n;e=Ee(e);const r=null==this.bias?null:this.bias.read(),i=dt(this.activation.getClassName());if(null!=i&&2===this.rank)n=Oh(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate,i);else{if(1===this.rank)n=function(e,n,r,i=1,a="valid",o,l=1){return s((()=>{if(null==o&&(o="channelsLast"),Nt(o),3!==e.shape.length)throw new q(`The input of a conv1dWithBias operation should be 3, but is ${e.shape.length} instead.`);if(3!==n.shape.length)throw new q(`The kernel for a conv1dWithBias operation should be 3, but is ${n.shape.length} instead`);if(null!=r&&1!==r.shape.length)throw new q(`The bias for a conv1dWithBias operation should be 1, but is ${n.shape.length} instead`);if("channelsFirst"===o&&(e=t.transpose(e,[0,2,1])),"causal"===a)throw new j("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let s=t.conv1d(e,n,i,"same"===a?"same":"valid","NWC",l);return null!=r&&(s=Xt(s,r)),s}))}(e,this.kernel.read(),r,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)n=Oh(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new j("convolutions greater than 3D are not implemented yet.");n=function(e,n,r,i=[1,1,1],a="valid",o,l){return s((()=>{if(null==o&&(o="channelsLast"),Nt(o),4!==e.rank&&5!==e.rank)throw new q(`conv3dWithBias expects input to be of rank 4 or 5, but received ${e.rank}.`);if(4!==n.rank&&5!==n.rank)throw new q(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${e.rank}.`);let s=Rh(e,o);if("causal"===a)throw new j("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return s=t.conv3d(s,n,i,"same"===a?"same":"valid","NDHWC",l),null!=r&&(s=Xt(s,r)),"channelsFirst"===o&&(s=t.transpose(s,[0,4,1,2,3])),s}))}(e,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(n=this.activation.apply(n))}return n}))}computeOutputShape(t){t=Ie(t);const e=[],n="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<n.length;++t){const s=Fh(n[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(s)}let s=[t[0]];return"channelsLast"===this.dataFormat?(s=s.concat(e),s.push(this.filters)):(s.push(this.filters),s=s.concat(e)),s}getConfig(){const t={filters:this.filters,kernelInitializer:ve(this.kernelInitializer),kernelRegularizer:Nh(this.kernelRegularizer),kernelConstraint:Dl(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new q(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(t.filters)}`)}}class Wh extends Ph{constructor(t){super(2,t),Wh.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!ht(t.kernelSize,"number",1,2))throw new q(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}Wh.className="Conv2D",i.registerClass(Wh);class Uh extends Ph{constructor(t){super(3,t),Uh.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new q(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}Uh.className="Conv3D",i.registerClass(Uh);class Kh extends Wh{constructor(t){if(super(t),this.inputSpec=[new ze({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new q(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(4!==(t=Ie(t)).length)throw new q("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new q("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new ze({ndim:4,axes:{[e]:n}})],this.built=!0}call(e,n){return t.tidy((()=>{let n=Ee(e);if(4!==n.shape.length)throw new q(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);const s=n.shape,r=s[0];let i,a;"channelsFirst"===this.dataFormat?(i=2,a=3):(i=1,a=2);const o=s[i],l=s[a],u=this.kernelSize[0],h=this.kernelSize[1],c=this.strides[0],p=this.strides[1],d=[r,Mh(o,c,u,this.padding),Mh(l,p,h,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(n=t.transpose(n,[0,2,3,1]));let f=t.conv2dTranspose(n,this.kernel.read(),d,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(f=t.transpose(f,[0,3,1,2])),null!=this.bias&&(f=Xt(f,this.bias.read(),this.dataFormat)),null!=this.activation&&(f=this.activation.apply(f)),f}))}computeOutputShape(t){const e=(t=Ie(t)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const i=this.kernelSize[0],a=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[n]=this.filters,e[s]=Mh(e[s],o,i,this.padding),e[r]=Mh(e[r],l,a,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Kh.className="Conv2DTranspose",i.registerClass(Kh);class Vh extends Uh{constructor(t){if(super(t),this.inputSpec=[new ze({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new q(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(5!==(t=Ie(t)).length)throw new q("Input should have rank 5; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new q("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new ze({ndim:5,axes:{[e]:n}})],this.built=!0}call(e,n){return t.tidy((()=>{let n=Ee(e);if(5!==n.shape.length)throw new q(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${n.shape.length}`);const s=n.shape,r=s[0];let i,a,o;"channelsFirst"===this.dataFormat?(o=2,i=3,a=4):(o=1,i=2,a=3);const l=s[o],u=s[i],h=s[a],c=this.kernelSize[0],p=this.kernelSize[1],d=this.kernelSize[2],f=this.strides[0],g=this.strides[1],m=this.strides[2],b=[r,Mh(l,f,c,this.padding),Mh(u,g,p,this.padding),Mh(h,m,d,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(n=t.transpose(n,[0,2,3,4,1]));let y=t.conv3dTranspose(n,this.kernel.read(),b,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(y=t.transpose(y,[0,4,1,2,3])),null!==this.bias&&(y=Xt(y,this.bias.read(),this.dataFormat)),null!==this.activation&&(y=this.activation.apply(y)),y}))}computeOutputShape(t){const e=(t=Ie(t)).slice();let n,s,r,i;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,i=4):(n=4,s=1,r=2,i=3);const a=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],h=this.strides[1],c=this.strides[2];return e[n]=this.filters,e[s]=Mh(e[s],u,a,this.padding),e[r]=Mh(e[r],h,o,this.padding),e[i]=Mh(e[i],c,l,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Vh.className="Conv3DTranspose",i.registerClass(Vh);class qh extends Ph{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new q("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new q("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new q(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(e.padding)}`);this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=xe(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Ih(e.depthwiseRegularizer),this.depthwiseConstraint=Ml(e.depthwiseConstraint),this.pointwiseInitializer=xe(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Ih(e.pointwiseRegularizer),this.pointwiseConstraint=Ml(e.pointwiseConstraint)}build(t){if((t=Ie(t)).length<this.rank+2)throw new q(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(t)}`);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new q(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(t[e])}`);const n=t[e],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let t=0;t<this.rank;++t)r.push(1);r.push(n*this.depthMultiplier,this.filters);const i=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,i,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,i,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,i,this.biasConstraint):this.bias=null,this.inputSpec=[new ze({ndim:this.rank+2,axes:{[e]:n}})],this.built=!0}call(e,n){return s((()=>{let n;if(e=Ee(e),1===this.rank)throw new j("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(e=t.transpose(e,[0,2,3,1])),n=t.separableConv2d(e,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(n=Xt(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),"channelsFirst"===this.dataFormat&&(n=t.transpose(n,[0,3,1,2])),n}))}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=ve(this.depthwiseInitializer),t.pointwiseInitializer=ve(this.pointwiseInitializer),t.depthwiseRegularizer=Nh(this.depthwiseRegularizer),t.pointwiseRegularizer=Nh(this.pointwiseRegularizer),t.depthwiseConstraint=Dl(this.depthwiseConstraint),t.pointwiseConstraint=Dl(this.pointwiseConstraint),t}}qh.className="SeparableConv";class jh extends qh{constructor(t){super(2,t)}}jh.className="SeparableConv2D",i.registerClass(jh);class Gh extends Ph{constructor(t){super(1,t),Gh.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!ht(t.kernelSize,"number",1,1))throw new q(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}Gh.className="Conv1D",i.registerClass(Gh);class Hh extends Le{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,e){return s((()=>{if(t=Ee(t),"channelsLast"===this.dataFormat){const e=Kt(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return Kt(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=Kt(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return Kt(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}Hh.className="Cropping2D",i.registerClass(Hh);class Jh extends Le{constructor(t){var e;super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Nt(this.dataFormat),this.interpolation=null==t.interpolation?"nearest":t.interpolation,e=this.interpolation,ut(wt,"InterpolationFormat",e)}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],n=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,n]}{const e=null==t[1]?null:this.size[0]*t[1],n=null==t[2]?null:this.size[1]*t[2];return[t[0],e,n,t[3]]}}call(e,n){return t.tidy((()=>{let n=Ee(e);const s=n.shape;if("channelsFirst"===this.dataFormat){n=t.transpose(n,[0,2,3,1]);const e=this.size[0]*s[2],r=this.size[1]*s[3],i="nearest"===this.interpolation?t.image.resizeNearestNeighbor(n,[e,r]):t.image.resizeBilinear(n,[e,r]);return t.transpose(i,[0,3,1,2])}{const e=this.size[0]*s[1],r=this.size[1]*s[2];return"nearest"===this.interpolation?t.image.resizeNearestNeighbor(n,[e,r]):t.image.resizeBilinear(n,[e,r])}}))}getConfig(){const t={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},e=super.getConfig();return Object.assign(t,e),t}}Jh.className="UpSampling2D",i.registerClass(Jh);class Zh extends Bh{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=xe(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Ml(t.depthwiseConstraint),this.depthwiseRegularizer=Ih(t.depthwiseRegularizer)}build(t){if((t=Ie(t)).length<4)throw new q(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new q(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const n=t[e],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{let n=function(e,n,r=[1,1],i="valid",a,o){return s((()=>{null==a&&(a="channelsLast"),Nt(a);let s=Lh(e,a);if(4!==e.rank)throw new q(`Input for depthwiseConv2d is required to be 4-D, but is instead ${e.rank}-D`);if(4!==n.rank)throw new q(`depthwiseKernel is required to be 4-D, but is instead ${n.rank}-D`);return s=t.depthwiseConv2d(s,n,r,"same"===i?"same":"valid","NHWC",o),"channelsFirst"===a&&(s=t.transpose(s,[0,3,1,2])),s}))}(e=Ee(e),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(n=Xt(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),n}))}computeOutputShape(t){t=Ie(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,r=Fh(e,this.kernelSize[0],this.padding,this.strides[0]),i=Fh(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],s,r,i]:[t[0],r,i,s]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=ve(this.depthwiseInitializer),t.depthwiseRegularizer=Nh(this.depthwiseRegularizer),t.depthwiseConstraint=Dl(this.depthwiseRegularizer),t}}function Yh(t,e,n,s){if(Array.isArray(t)){if(null!=e||null!=n)throw new q("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=t.slice(t.length-s,t.length),t=t.slice(0,t.length-s)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function r(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=r(e),constants:n=r(n)}}function Xh(e,n,s,r=!1,i,a,o=!1,l=!1){return t.tidy((()=>{const u=n.shape.length;if(u<3)throw new q(`Input should be at least 3D, but is ${u}D.`);const h=[1,0].concat(Lt(2,u));if(n=t.transpose(n,h),null!=a)throw new j("The rnn() functoin of the deeplearn.js backend does not support constants yet.");o&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=i&&((i=t.cast(t.cast(i,"bool"),"float32")).rank===u-1&&(i=t.expandDims(i,-1)),i=t.transpose(i,h)),r&&(n=t.reverse(n,0),null!=i&&(i=t.reverse(i,0)));const c=[];let p,d=s;const f=n.shape[0],g=t.unstack(n);let m,b;null!=i&&(m=t.unstack(i));for(let n=0;n<f;++n){const s=g[n],r=t.tidy((()=>e(s,d)));if(null==i)p=r[0],d=r[1];else{const e=t.tidy((()=>{const e=m[n],s=t.sub(t.onesLike(e),e);return{output:t.add(t.mul(r[0],e),t.mul(d[0],s)),newStates:d.map(((n,i)=>t.add(t.mul(r[1][i],e),t.mul(n,s))))}}));p=e.output,d=e.newStates}l&&c.push(p)}if(l){const e=1;b=t.stack(c,e)}return[p,b,d]}))}Zh.className="DepthwiseConv2D",i.registerClass(Zh);class Qh extends Le{constructor(t){let e;if(super(t),null==t.cell)throw new q("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new oc({cells:t.cell}):t.cell,null==e.stateSize)throw new q("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new ze({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return Lt(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((t=>null))}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){Se(t)&&(t=t[0]);let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const n=e[0];let s;if(s=this.returnSequences?[t[0],t[1],n]:[t[0],n],this.returnState){const n=[];for(const s of e)n.push([t[0],s]);return[s].concat(n)}return s}computeMask(e,n){return t.tidy((()=>{Array.isArray(n)&&(n=n[0]);const t=this.returnSequences?n:null;if(this.returnState){const e=this.states.map((t=>null));return[t].concat(e)}return t}))}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let n=0;n<t;++n)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new j("Constants support is not implemented in RNN yet.");Se(t)&&(t=t[0]);const n=this.stateful?t[0]:null,s=t.slice(2);this.inputSpec[0]=new ze({shape:[n,null,...s]});const r=[t[0]].concat(t.slice(2));let i;if(this.cell.build(r),i=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!e.arraysEqual(this.stateSpec.map((t=>t.shape[t.shape.length-1])),i))throw new q(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=i.map((t=>new ze({shape:[null,t]})));this.stateful&&this.resetStates()}resetStates(n,r=!1){s((()=>{if(!this.stateful)throw new K("Cannot call resetStates() on an RNN Layer that is not stateful.");const s=this.inputSpec[0].shape[0];if(null==s)throw new q("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>t.zeros([s,e]))):this.states_=[t.zeros([s,this.cell.stateSize])];else if(null==n)t.dispose(this.states_),null!=this.keptStates&&(t.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((e=>t.zeros([s,e]))):this.states_[0]=t.zeros([s,this.cell.stateSize]);else{if(Array.isArray(n)||(n=[n]),n.length!==this.states_.length)throw new q(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${n.length} state value(s). Input received: ${n}`);!0===r?this.keptStates.push(this.states_.slice()):t.dispose(this.states_);for(let t=0;t<this.states_.length;++t){const r=n[t],i=Array.isArray(this.cell.stateSize)?this.cell.stateSize[t]:this.cell.stateSize,a=[s,i];if(!e.arraysEqual(r.shape,a))throw new q(`State ${t} is incompatible with layer ${this.name}: expected shape=${a}, received shape=${r.shape}`);this.states_[t]=r}}this.states_=this.states_.map((e=>t.keep(e.clone())))}))}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Yh(t,n,s,this.numConstants);t=r.inputs,n=r.initialState,s=r.constants;let i=[],a=[];if(null!=n){e.initialState=n,i=i.concat(n),this.stateSpec=[];for(const t of n)this.stateSpec.push(new ze({shape:t.shape}));a=a.concat(this.stateSpec)}null!=s&&(e.constants=s,i=i.concat(s),this.numConstants=s.length);if(i[0]instanceof _e){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,e){return s((()=>{const n=null==e?null:e.mask,s=null==e?null:e.training;let r=null==e?null:e.initialState;t=Ee(t),null==r&&(r=this.stateful?this.states_:this.getInitialState(t));const i=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==i)throw new q(`RNN Layer has ${i} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const a={training:s},o=Xh(((t,e)=>{const n=this.cell.call([t].concat(e),a);return[n[0],n.slice(1)]}),t,r,this.goBackwards,n,null,this.unroll,this.returnSequences),l=o[0],u=o[1],h=o[2];this.stateful&&this.resetStates(h,s);const c=this.returnSequences?u:l;return this.returnState?[c].concat(h):c}))}getInitialState(e){return s((()=>{let n=t.zeros(e.shape);return n=t.sum(n,[1,2]),n=Pt(n),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((t=>t>1?jt(n,[1,t]):n)):this.cell.stateSize>1?[jt(n,[1,this.cell.stateSize])]:[n]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===Qh.className&&(e.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,t,e)}static fromConfig(t,e,n={}){const s=Jl(e.cell,n);return new t(Object.assign(e,{cell:s}))}}Qh.className="RNN",i.registerClass(Qh);class tc extends Le{}class ec extends tc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,ct(this.units,"units"),this.activation=wh(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=xe(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=xe(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=xe(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ih(t.kernelRegularizer),this.recurrentRegularizer=Ih(t.recurrentRegularizer),this.biasRegularizer=Ih(t.biasRegularizer),this.kernelConstraint=Ml(t.kernelConstraint),this.recurrentConstraint=Ml(t.recurrentConstraint),this.biasConstraint=Ml(t.biasConstraint),this.dropout=Ft([1,Mt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Ft([1,Mt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=Ie(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{if(2!==e.length)throw new q(`SimpleRNNCell expects 2 input Tensors, got ${e.length}.`);let s=e[1];e=e[0];const r=null!=n.training&&n.training;let i;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=lc({ones:()=>t.onesLike(e),rate:this.dropout,training:r,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=lc({ones:()=>t.onesLike(s),rate:this.recurrentDropout,training:r,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,o=this.recurrentDropoutMask;i=Ht(null!=a?t.mul(e,a):e,this.kernel.read()),null!=this.bias&&(i=Xt(i,this.bias.read())),null!=o&&(s=t.mul(s,o));let l=t.add(i,Ht(s,this.recurrentKernel.read()));return null!=this.activation&&(l=this.activation.apply(l)),[l,l]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:bh(this.activation),useBias:this.useBias,kernelInitializer:ve(this.kernelInitializer),recurrentInitializer:ve(this.recurrentInitializer),biasInitializer:ve(this.biasInitializer),kernelRegularizer:Nh(this.kernelRegularizer),recurrentRegularizer:Nh(this.recurrentRegularizer),biasRegularizer:Nh(this.biasRegularizer),activityRegularizer:Nh(this.activityRegularizer),kernelConstraint:Dl(this.kernelConstraint),recurrentConstraint:Dl(this.recurrentConstraint),biasConstraint:Dl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},t,e)}}ec.className="SimpleRNNCell",i.registerClass(ec);class nc extends Qh{constructor(t){t.cell=new ec(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return new t(e)}}nc.className="SimpleRNN",i.registerClass(nc);class sc extends tc{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new q("GRUCell does not support reset_after parameter set to true.");this.units=t.units,ct(this.units,"units"),this.activation=wh(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=wh(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=xe(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=xe(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=xe(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ih(t.kernelRegularizer),this.recurrentRegularizer=Ih(t.recurrentRegularizer),this.biasRegularizer=Ih(t.biasRegularizer),this.kernelConstraint=Ml(t.kernelConstraint),this.recurrentConstraint=Ml(t.recurrentConstraint),this.biasConstraint=Ml(t.biasConstraint),this.dropout=Ft([1,Mt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Ft([1,Mt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=Ie(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(e,n){return s((()=>{if(2!==e.length)throw new q(`GRUCell expects 2 input Tensors (inputs, h, c), got ${e.length}.`);const s=null!=n.training&&n.training;let r=e[1];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=lc({ones:()=>t.onesLike(e),rate:this.dropout,training:s,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=lc({ones:()=>t.onesLike(r),rate:this.recurrentDropout,training:s,count:3,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,a=this.recurrentDropoutMask;let o,l,u;0<this.dropout&&this.dropout<1&&(e=t.mul(e,i[0]));let h=Ht(e,this.kernel.read());this.useBias&&(h=Xt(h,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(r=t.mul(r,a[0]));const c=this.recurrentKernel.read(),[p,d]=t.split(c,[2*this.units,this.units],c.rank-1),f=Ht(r,p),[g,m,b]=t.split(h,3,h.rank-1),[y,w]=t.split(f,2,f.rank-1);o=this.recurrentActivation.apply(t.add(g,y)),l=this.recurrentActivation.apply(t.add(m,w));const k=Ht(t.mul(l,r),d);u=this.activation.apply(t.add(b,k));const v=t.add(t.mul(o,r),t.mul(t.add(1,t.neg(o)),u));return[v,v]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:bh(this.activation),recurrentActivation:bh(this.recurrentActivation),useBias:this.useBias,kernelInitializer:ve(this.kernelInitializer),recurrentInitializer:ve(this.recurrentInitializer),biasInitializer:ve(this.biasInitializer),kernelRegularizer:Nh(this.kernelRegularizer),recurrentRegularizer:Nh(this.recurrentRegularizer),biasRegularizer:Nh(this.biasRegularizer),activityRegularizer:Nh(this.activityRegularizer),kernelConstraint:Dl(this.kernelConstraint),recurrentConstraint:Dl(this.recurrentConstraint),biasConstraint:Dl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},t,e)}}sc.className="GRUCell",i.registerClass(sc);class rc extends Qh{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new sc(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}rc.className="GRU",i.registerClass(rc);class ic extends tc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,ct(this.units,"units"),this.activation=wh(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=wh(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=xe(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=xe(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=xe(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=Ih(t.kernelRegularizer),this.recurrentRegularizer=Ih(t.recurrentRegularizer),this.biasRegularizer=Ih(t.biasRegularizer),this.kernelConstraint=Ml(t.kernelConstraint),this.recurrentConstraint=Ml(t.recurrentConstraint),this.biasConstraint=Ml(t.biasConstraint),this.dropout=Ft([1,Mt([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=Ft([1,Mt([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const n=(t=Ie(t))[t.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,n=this.units;s=new((e=class extends se{apply(e,s){const r=t.apply([n]),i=(new ie).apply([n]),a=t.apply([2*n]);return qt(qt(r,i),a)}}).className="CustomInit",e)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(e,n){return s((()=>{const s=null!=n.training&&n.training;if(3!==e.length)throw new q(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);let r=e[1];const i=e[2];e=e[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=lc({ones:()=>t.onesLike(e),rate:this.dropout,training:s,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=lc({ones:()=>t.onesLike(r),rate:this.recurrentDropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const a=this.dropoutMask,o=this.recurrentDropoutMask;let l,u,h,c;0<this.dropout&&this.dropout<1&&(e=t.mul(e,a[0]));let p=Ht(e,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(r=t.mul(r,o[0])),p=t.add(p,Ht(r,this.recurrentKernel.read())),this.useBias&&(p=Xt(p,this.bias.read()));const[d,f,g,m]=t.split(p,4,p.rank-1);l=this.recurrentActivation.apply(d),u=this.recurrentActivation.apply(f),h=t.add(t.mul(u,i),t.mul(l,this.activation.apply(g))),c=this.recurrentActivation.apply(m);const b=t.mul(c,this.activation.apply(h));return[b,b,h]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:bh(this.activation),recurrentActivation:bh(this.recurrentActivation),useBias:this.useBias,kernelInitializer:ve(this.kernelInitializer),recurrentInitializer:ve(this.recurrentInitializer),biasInitializer:ve(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Nh(this.kernelRegularizer),recurrentRegularizer:Nh(this.recurrentRegularizer),biasRegularizer:Nh(this.biasRegularizer),activityRegularizer:Nh(this.activityRegularizer),kernelConstraint:Dl(this.kernelConstraint),recurrentConstraint:Dl(this.recurrentConstraint),biasConstraint:Dl(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},t,e)}}ic.className="LSTMCell",i.registerClass(ic);class ac extends Qh{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new ic(t),super(t)}call(e,n){return s((()=>{null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}ac.className="LSTM",i.registerClass(ac);class oc extends tc{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,e){return s((()=>{let n=t.slice(1);const s=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?s.push(n.splice(0,t.stateSize.length)):s.push(n.splice(0,1));s.reverse();const r=[];let i;for(let a=0;a<this.cells.length;++a){const o=this.cells[a];n=s[a],i=0===a?[t[0]].concat(n):[i[0]].concat(n),i=o.call(i,e),r.push(i.slice(1))}n=[];for(const t of r.slice().reverse())n.push(...t);return[i[0]].concat(n)}))}build(t){let e;Se(t)&&(t=t[0]),this.cells.forEach(((n,s)=>{$t(`RNNCell_${s}`,(()=>{n.build(t),e=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,t=[t[0],e]}))})),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map((t=>({className:t.getClassName(),config:t.getConfig()})))};return Object.assign({},t,e)}static fromConfig(t,e,n={}){const s=[];for(const t of e.cells)s.push(Jl(t,n));return new t({cells:s})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return Ce(t)}setWeights(t){const e=[];for(const n of this.cells){const s=n.weights.length,r=t.splice(s);for(let t=0;t<n.weights.length;++t)e.push([n.weights[t],r[t]])}Te(e)}}function lc(e){const{ones:n,rate:s,training:r=!1,count:i=1,dropoutFunc:a}=e,o=()=>null!=a?a(n(),s):Qt(n(),s),l=()=>te(o,n,r);if(!i||i<=1)return t.keep(l().clone());return Array(i).fill(void 0).map(l).map((e=>t.keep(e.clone())))}oc.className="StackedRNNCells",i.registerClass(oc);var uc=function(t,e){var n={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(n[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(t);r<s.length;r++)e.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(n[s[r]]=t[s[r]])}return n};class hc extends Qh{constructor(t){if(t.unroll)throw new j("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new j("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new ze({ndim:5})]}call(e,n){return t.tidy((()=>{if(null!=this.cell.dropoutMask&&(t.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(t.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),n&&n.constants)throw new q("ConvRNN2D cell does not support constants");const s=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(e,{mask:s,training:r,initialState:i})}))}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(e){return t.tidy((()=>{const{stateSize:n}=this.cell,s=e.shape,r=this.computeSingleOutputShape(s),i=[r[0],...r.slice(2)],a=t.zeros(i);return Array.isArray(n)?Array(n.length).fill(a):[a]}))}resetStates(n,s=!1){t.tidy((()=>{if(!this.stateful)throw new K("Cannot call resetStates() on an RNN Layer that is not stateful.");const r=this.inputSpec[0].shape,i=this.computeSingleOutputShape(r),a=[i[0],...i.slice(2)];if(null==r[0])throw new q("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>t.zeros(a))):this.states_=[t.zeros(a)];else if(null==n)t.dispose(this.states_),null!=this.keptStates&&(t.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>t.zeros(a))):this.states_[0]=t.zeros(a);else{if(Array.isArray(n)||(n=[n]),n.length!==this.states_.length)throw new q(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${n.length} state value(s). Input received: ${n}`);s?this.keptStates.push(this.states_.slice()):t.dispose(this.states_);for(let t=0;t<this.states_.length;++t){const s=n[t],r=a;if(!e.arraysEqual(s.shape,r))throw new q(`State ${t} is incompatible with layer ${this.name}: expected shape=${r}, received shape=${s.shape}`);this.states_[t]=s}}this.states_=this.states_.map((e=>t.keep(e.clone())))}))}computeSingleOutputShape(t){const{dataFormat:e,filters:n,kernelSize:s,padding:r,strides:i,dilationRate:a}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],h=Fh(l,s[0],r,i[0],a[0]),c=Fh(u,s[1],r,i[1],a[1]);return[...t.slice(0,2),...o?[n,h,c]:[h,c,n]]}}hc.className="ConvRNN2D";class cc extends ic{constructor(t){const{filters:e,kernelSize:n,strides:s,padding:r,dataFormat:i,dilationRate:a}=t;super(Object.assign({},t,{units:e})),this.filters=e,ct(this.filters,"filters"),this.kernelSize=Dh(n,2,"kernelSize"),this.kernelSize.forEach((t=>ct(t,"kernelSize"))),this.strides=Dh(s||1,2,"strides"),this.strides.forEach((t=>ct(t,"strides"))),this.padding=r||"valid",Et(this.padding),this.dataFormat=i||"channelsLast",Nt(this.dataFormat),this.dilationRate=Dh(a||1,2,"dilationRate"),this.dilationRate.forEach((t=>ct(t,"dilationRate")))}build(e){var n;e=Ie(e);const s="channelsFirst"===this.dataFormat?1:e.length-1;if(null==e[s])throw new q(`The channel dimension of the input should be defined. Found ${e[s]}`);const r=e[s],i=this.kernelSize.concat([r,4*this.filters]);this.kernel=this.addWeight("kernel",i,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const a=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",a,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let e;if(this.unitForgetBias){const s=this.biasInitializer,r=this.filters;e=new((n=class extends se{apply(e,n){return Vt([s.apply([r]),t.ones([r]),s.apply([2*r])])}}).className="CustomInit",n)}else e=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,e,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(e,n){return t.tidy((()=>{if(3!==e.length)throw new q(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${e.length}.`);const s=n.training||!1,r=e[0],i=e[1],a=e[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=lc({ones:()=>t.onesLike(r),rate:this.dropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const o=this.dropoutMask,l=(e,n,s)=>n&&n[s]?t.mul(n[s],e):e;let u=l(r,o,0),h=l(r,o,1),c=l(r,o,2),p=l(r,o,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=lc({ones:()=>t.onesLike(i),rate:this.recurrentDropout,training:s,count:4,dropoutFunc:this.dropoutFunc}));const d=this.recurrentDropoutMask;let f=l(i,d,0),g=l(i,d,1),m=l(i,d,2),b=l(i,d,3);const[y,w,k,v]=t.split(this.kernel.read(),4,3),[x,S,N,E]=this.useBias?t.split(this.bias.read(),4):[null,null,null,null];u=this.inputConv(u,y,x,this.padding),h=this.inputConv(h,w,S,this.padding),c=this.inputConv(c,k,N,this.padding),p=this.inputConv(p,v,E,this.padding);const[I,A,$,C]=t.split(this.recurrentKernel.read(),4,3);f=this.recurrentConv(f,I),g=this.recurrentConv(g,A),m=this.recurrentConv(m,$),b=this.recurrentConv(b,C);const T=this.recurrentActivation.apply(t.add(u,f)),z=this.recurrentActivation.apply(t.add(h,g)),_=t.add(t.mul(z,a),t.mul(T,this.activation.apply(t.add(c,m)))),D=t.mul(this.recurrentActivation.apply(t.add(p,b)),this.activation.apply(_));return[D,D,_]}))}getConfig(){const t=super.getConfig(),e=uc(t,["units"]),n={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},e,n)}inputConv(e,n,s,r){const i=t.conv2d(e,n,this.strides,r||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return s?Xt(i,s,this.dataFormat):i}recurrentConv(e,n){return t.conv2d(e,n,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}cc.className="ConvLSTM2DCell",t.serialization.registerClass(cc);class pc extends hc{constructor(t){const e=new cc(t);super(Object.assign({},t,{cell:e}))}static fromConfig(t,e){return new t(e)}}pc.className="ConvLSTM2D",t.serialization.registerClass(pc);class dc extends Le{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,n=[];for(let t=0;t<this.noiseShape.length;++t)n.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return n}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t);if(0<this.rate&&this.rate<1){const t=null!=e.training&&e.training,s=this.getNoiseShape(n);return te((()=>Qt(n,this.rate,s,this.seed)),(()=>n),t)}return t}))}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}dc.className="Dropout",i.registerClass(dc);class fc extends dc{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}fc.className="SpatialDropout1D",i.registerClass(fc);class gc extends Le{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,ct(this.units,"units"),this.activation=wh(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=xe(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=xe(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Ml(t.kernelConstraint),this.biasConstraint=Ml(t.biasConstraint),this.kernelRegularizer=Ih(t.kernelRegularizer),this.biasRegularizer=Ih(t.biasRegularizer),this.activityRegularizer=Ih(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=Ie(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=Ie(t)).slice();return e[e.length-1]=this.units,e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t),s=dt(this.activation.getClassName());let r;return null!=s?r=Ht(n,this.kernel.read(),s,this.bias?this.bias.read():null):(r=Ht(n,this.kernel.read()),null!=this.bias&&(r=Xt(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const t={units:this.units,activation:bh(this.activation),useBias:this.useBias,kernelInitializer:ve(this.kernelInitializer),biasInitializer:ve(this.biasInitializer),kernelRegularizer:Nh(this.kernelRegularizer),biasRegularizer:Nh(this.biasRegularizer),activityRegularizer:Nh(this.activityRegularizer),kernelConstraint:Dl(this.kernelConstraint),biasConstraint:Dl(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}gc.className="Dense",i.registerClass(gc);class mc extends Le{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=Ie(t);for(const e of t.slice(1))if(null==e)throw new q(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],Dt(t,1)]}call(e,n){return s((()=>{this.invokeCallHook(e,n);let s=Ee(e);if("channelsFirst"===this.dataFormat&&s.rank>1){const t=[0];for(let e=2;e<s.rank;++e)t.push(e);t.push(1),s=f(s,t)}return function(e){if(e.rank<=1)throw new q(`batchFlatten requires a minimum rank of 2. Got rank: ${e.rank}.`);const n=[e.shape[0],Dt(e.shape,1)];return t.reshape(e,n)}(s)}))}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}mc.className="Flatten",i.registerClass(mc);class bc extends Le{constructor(t){super(t),this.supportsMasking=!0,this.activation=wh(t.activation)}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t);return this.activation.apply(n)}))}getConfig(){const t={activation:bh(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}bc.className="Activation",i.registerClass(bc);class yc extends Le{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,e){return s((()=>{return t=Ee(t),e=t,n=this.n,s((()=>{if(2!==e.shape.length)throw new q(`repeat() expects a rank-2 tensor, but received a rank-${e.shape.length} tensor.`);return jt(Pt(e,1),[1,n,1])}));var e,n}))}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}yc.className="RepeatVector",i.registerClass(yc);class wc extends Le{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const n="Total size of new array must be unchanged.",s=e.slice();let r=1,i=null;for(let t=0;t<s.length;++t){const e=s[t];if(this.isUnknown(e)){if(null!==i)throw new q("Can only specifiy one unknown dimension.");i=t}else r*=e}const a=Dt(t);if(null!==i){if(0===r||a%r!=0)throw new q(n);s[i]=a/r}else if(a!==r)throw new q(n);return s}computeOutputShape(t){let e=!1;for(let n=0;n<t.length;++n)if(this.isUnknown(t[n])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t),s=n.shape,r=s.slice(0,1).concat(this.fixUnknownDimension(s.slice(1),this.targetShape));return I(n,r)}))}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}wc.className="Reshape",i.registerClass(wc);class kc extends Le{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${t.dims} instead.`);const n=Lt(1,t.dims.length+1);if(!e.arraysEqual(t.dims.slice().sort(),n))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new ze({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=Ie(t)).slice();return this.dims.forEach(((n,s)=>{e[s+1]=t[n]})),e}call(t,e){return f(Ee(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}kc.className="Permute",i.registerClass(kc);class vc extends Le{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,e){const n=Ee(t);return O(B(n,this.maskValue),-1)}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t),s=O(B(n,this.maskValue),-1,!0);return l(n,b(s,n.dtype))}))}}vc.className="Masking",i.registerClass(vc);class xc extends Le{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(Q(t.inputLength))}this.inputDim=t.inputDim,ct(this.inputDim,"inputDim"),this.outputDim=t.outputDim,ct(this.outputDim,"outputDim"),this.embeddingsInitializer=xe(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Ih(t.embeddingsRegularizer),this.activityRegularizer=Ih(t.activityRegularizer),this.embeddingsConstraint=Ml(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,e){return s((()=>this.maskZero?(t=Ee(t),B(t,P(t))):null))}computeOutputShape(t){if(t=Ie(t),null==this.inputLength)return[...t,this.outputDim];const e=Q(this.inputLength);if(e.length!==t.length-1)throw new q(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);{let n=0;for(let s=0;s<e.length;++s){const r=e[s],i=t[s+1];if(null!=r&&null!=i&&r!==i)throw new q(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);null==r&&(e[n]=i),n++}}return[t[0],...e,this.outputDim]}call(t,e){return s((()=>{this.invokeCallHook(t,e);let n=Ee(t);"int32"!==n.dtype&&(n=Bt(n,"int32"));const s=Jt(this.embeddings.read(),I(n,[n.size]));return I(s,Ie(this.computeOutputShape(n.shape)))}))}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:ve(this.embeddingsInitializer),embeddingsRegularizer:Nh(this.embeddingsRegularizer),activityRegularizer:Nh(this.activityRegularizer),embeddingsConstraint:Dl(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}xc.className="Embedding",i.registerClass(xc);class Sc extends Le{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new j}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const n=t.slice(0,t.length-e.length);for(let s=0;s<e.length;++s){const r=t[t.length-e.length+s],i=e[s];if(null==r||null==i||r<0||i<0)n.push(null);else if(1===r)n.push(i);else if(1===i)n.push(r);else{if(r!==i)throw new q("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));n.push(r)}}return n}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[Ie(t)]),t.length<2)throw new q(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const n of t)null!=n&&null!==n[0]&&e.push(n[0]);if(e=ot(e),e.length>1)throw new q(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let n=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const s=null==t[e]?null:t[e].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=t.map((t=>t.length));-1===t.indexOf(null)&&1===ot(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(e,n){return s((()=>{if(this.reshapeRequired){const n=[],s=e.map((t=>t.rank));if(-1===s.indexOf(null)){const t=Mt(s);for(let s of e){const e=s.rank;for(let n=0;n<t-e;++n)s=Pt(s,1);n.push(s)}return this.mergeFunction(n)}{let s=!1;for(const r of e){const e=r.rank;if(null==e){const e=r.shape,i=e[0],a=e.slice(1).concat([i]);let o=t.reshape(r,[i].concat(Dt(e.slice(1))));o=t.transpose(o,[1,0]),o=t.reshape(o,a),n.push(o),s=!0}else if(e>1){const i=Lt(1,e).concat([0]);n.push(t.transpose(r,i)),s=!0}else n.push(r)}let r=this.mergeFunction(n);const i=r.rank;if(s)if(null==i){const e=r.shape,n=e[e.length-1],s=[n].concat(e.slice(0,e.length-1));r=t.reshape(t.transpose(t.reshape(r,[-1,n]),[1,0]),s)}else if(i>1){const e=[i-1].concat(Lt(0,i-1));r=t.transpose(r,e)}return r}}return this.mergeFunction(e)}))}computeOutputShape(t){let e;e=null==t[0]?null:t[0].slice(1);for(let n=1;n<t.length;++n){const s=null==t[n]?null:t[n].slice(1);e=this.computeElementwiseOpOutputShape(e,s)}let n=[];for(const e of t)null!=e&&null!==e[0]&&n.push(e[0]);return n=ot(n),e=1===n.length?n.concat(e):[null].concat(e),e}computeMask(e,n){return t.tidy((()=>{if(null==n)return null;if(!Array.isArray(n))throw new q("`mask` should be an Array");if(!Array.isArray(e))throw new q("`inputs` should be an Array");if(n.length!==e.length)throw new q(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${e.length} vs ${n.length})`);if(n.every((t=>null==t)))return null;let s=(n=n.map((e=>null==e?e:t.expandDims(e,0))))[0];for(let e=1;e<n.length-1;++e)s=t.logicalAnd(s,n[e]);return s}))}}class Nc extends Sc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.add(n,e[s]);return n}))}}Nc.className="Add",i.registerClass(Nc);class Ec extends Sc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.mul(n,e[s]);return n}))}}Ec.className="Multiply",i.registerClass(Ec);class Ic extends Sc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0].clone();for(let s=1;s<e.length;++s)n=t.add(n,e[s]);return t.mul(1/e.length,n)}))}}Ic.className="Average",i.registerClass(Ic);class Ac extends Sc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0];for(let s=1;s<e.length;++s)n=t.maximum(n,e[s]);return n}))}}Ac.className="Maximum",i.registerClass(Ac);class $c extends Sc{constructor(t){super(t)}mergeFunction(e){return s((()=>{let n=e[0];for(let s=1;s<e.length;++s)n=t.minimum(n,e[s]);return n}))}}$c.className="Minimum",i.registerClass($c);class Cc extends Sc{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new q("A `Concatenate` layer should be called on a list of at least 2 inputs");let n=!0;for(const e of t)if(null!=e){n=!1;break}if(n)return;const s=[];for(let n=0;n<t.length;++n){const r=t[n].slice();r.splice(this.axis,1);let i=!1;for(const t of s)if(e.arraysEqual(t,r)){i=!0;break}i||s.push(r)}if(s.length>1)throw new q("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return s((()=>Vt(t,this.axis)))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new q("A `Concatenate` layer should be called on a list of inputs.");const e=t,n=e[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==n[s]||null==t[s]){n[s]=null;break}n[s]+=t[s]}return n}computeMask(e,n){if(null==n)return null;if(!Array.isArray(n))throw new q("`mask` should be an array for Concatenate");if(!Array.isArray(e))throw new q("`inputs` should be an array for Concatenate");if(n.length!==e.length)throw new q(`Mismatch in the length of mask (${n.length}) and the legnth of inputs (${e.length})`);return t.tidy((()=>{let s=!0;if(n.forEach((t=>{null==t||(s=!1)})),s)return null;const r=[];for(let s=0;s<e.length;++s)null==n[s]?r.push(t.cast(t.onesLike(e[s]),"bool")):n[s].rank<e[s].rank?r.push(t.expandDims(n[s],-1)):r.push(n[s]);const i=t.concat(r,this.axis);return t.all(i,-1,!1)}))}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Tc(t,e){for(;t<0;)t+=e;return t}Cc.className="Concatenate",i.registerClass(Cc);class zc extends Sc{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(e){t.util.assert(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const n=e[0],s=e[1];if(n.length>3||s.length>3)throw new j("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(n,s);if(n[r[0]]!==s[r[1]])throw new q(`Dimension incompatibility: ${n[r[0]]} !== ${s[r[1]]}`)}mergeFunction(e){if(2!==e.length)throw new q(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${e.length} input(s).`);let n,s=e[0],r=e[1];return n=Array.isArray(this.axes)?this.axes.map(((t,n)=>Tc(t,e[n].shape.length))):[Tc(this.axes,s.shape.length),Tc(this.axes,r.shape.length)],this.normalize&&(s=Zl(s,n[0]),r=Zl(r,n[1])),function(e,n,s){if(e.shape.length>3||n.shape.length>3)throw new j("batchDot is not implemented for tensors of 4D or higher rank yet");if(t.util.assert(e.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${e.shape.length}`)),t.util.assert(e.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${n.shape.length}`)),"number"==typeof s&&(s=[s,s]),"complex64"===e.dtype||"complex64"===n.dtype)throw new j("batchDot is not implemented for complex64-type Tensors yet.");const r=e.shape.length,i=n.shape.length;null==s&&(s=[r-1,i-2]);const a=s;return t.tidy((()=>{let s,o;if(r>i){s=r-i;const e=[];for(let t=0;t<s;++t)e.push(1);n=t.reshape(n,n.shape.concat(e))}else if(i>r){s=i-r;const n=[];for(let t=0;t<s;++t)n.push(1);e=t.reshape(e,e.shape.concat(n))}else s=0;if(2===e.shape.length&&2===n.shape.length)o=a[0]===a[1]?t.sum(t.mul(e,n),a[0]):t.sum(t.mul(t.transpose(e,[1,0]),n),a[1]);else{const s=a[0]!==e.shape.length-1,r=a[1]===n.shape.length-1;o=t.matMul(e,n,s,r)}if(s>0){let e;e=r>i?r+i-3:r-1;const n=[];for(let t=e;t<e+s;++t)n.push(t);o=t.squeeze(o,n)}return 1===o.shape.length&&(o=t.expandDims(o,1)),o}))}(s,r,n)}interpretAxes(t,e){let n;return n=Array.isArray(this.axes)?this.axes:[Tc(this.axes,t.length),Tc(this.axes,e.length)],n}computeOutputShape(e){t.util.assert(Array.isArray(e)&&2===e.length&&Array.isArray(e[0])&&Array.isArray(e[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const n=e[0].slice(),s=e[1].slice();if(n.length>3||s.length>3)throw new j("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(n,s);n.splice(r[0],1),s.splice(r[1],1),s.splice(0,1);const i=n.concat(s);return 1===i.length&&i.push(1),i}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}zc.className="Dot",i.registerClass(zc);class _c extends Le{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t);return te((()=>k(Gt(n.shape,0,this.stddev),n)),(()=>n),e.training||!1)}))}}_c.className="GaussianNoise",i.registerClass(_c);class Dc extends Le{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return s((()=>{this.invokeCallHook(t,e);const n=Ee(t);if(this.rate>0&&this.rate<1){return te((()=>{const t=Math.sqrt(this.rate/(1-this.rate));return l(n,Gt(n.shape,1,t))}),(()=>n),e.training||!1)}return n}))}}Dc.className="GaussianDropout",i.registerClass(Dc);class Fc extends Le{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||Ee(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,e){return s((()=>{if(this.rate<1&&this.rate>0){const n=this._getNoiseShape(t),s=()=>{const e=Ee(t),s=-1.7580993408473766;let r=W(h(n),this.rate);r=Bt(r,"float32");const i=((1-this.rate)*(1+this.rate*s**2))**-.5,a=-i*s*this.rate,o=k(l(e,r),l(k(r,-1),s));return k(l(o,i),a)};return te(s,(()=>Ee(t)),e.training||!1)}return t}))}}function Mc(e,n,s,r,i,a=.001){let o;if(2===e.rank)o=t.batchNorm2d(e,n,s,r,i,a);else if(3===e.rank)o=t.batchNorm3d(e,n,s,r,i,a);else{if(4!==e.rank)throw new j(`batchNormalization is not implemented for array of rank ${e.rank} yet`);o=t.batchNorm4d(e,n,s,r,i,a)}return o}function Lc(n,r,i,a,o=.001){return e.arraysEqual(a.slice().sort(),Lt(0,n.rank-1))?function(e,n,r,i,a=.001){return s((()=>{const s=t.moments(e,i),o=s.mean,l=s.variance;return[Mc(e,o,l,r,n,a),o,l]}))}(n,r,i,a,o):function(e,n,r,i,a=.001){return s((()=>{const s=t.moments(e,i),o=s.mean,l=s.variance,u=[];for(const t of Lt(0,e.rank))-1!==i.indexOf(t)?u.push(1):u.push(e.shape[t]);const h=I(o,u),c=I(l,u),p=null==n?null:I(n,u),d=null==r?null:I(r,u);return[Mc(e,h,c,d,p,a),o,l]}))}(n,r,i,a,o)}Fc.className="AlphaDropout",i.registerClass(Fc);class Rc extends Le{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=xe(t.betaInitializer||"zeros"),this.gammaInitializer=xe(t.gammaInitializer||"ones"),this.movingMeanInitializer=xe(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=xe(t.movingVarianceInitializer||"ones"),this.betaConstraint=Ml(t.betaConstraint),this.gammaConstraint=Ml(t.gammaConstraint),this.betaRegularizer=Ih(t.betaRegularizer),this.gammaRegularizer=Ih(t.gammaRegularizer)}build(t){t=Ie(t);const e=this.axis>=0?this.axis:this.axis+t.length,n=t[e];if(null==n)throw new q(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(t)}.`);this.inputSpec=[new ze({ndim:t.length,axes:{[e]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(n,r){return s((()=>{const s=null!=r.training&&r.training,i=Ee(n),a=i.shape,o=a.length,l=Lt(0,o),u=this.axis>=0?this.axis:this.axis+o;l.splice(u,1);const h=J(1,o);h[u]=a[u];const c=l.slice();c.sort();const p=!e.arraysEqual(c,Lt(0,o).slice(0,o-1));if(!s)return(()=>{if(p){const t=I(this.movingMean.read(),h),e=I(this.movingVariance.read(),h),n=this.center?I(this.beta.read(),h):null,s=this.scale?I(this.gamma.read(),h):null;return Mc(i,t,e,n,s,this.epsilon)}return Mc(i,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[d,f,g]=Lc(i,this.gamma.read(),this.beta.read(),l,this.epsilon),m=(e,n,s)=>{t.tidy((()=>{const r=1-s,i=e.read(),a=t.mul(t.sub(i,n),r);e.write(t.sub(i,a))}))};return(()=>{m(this.movingMean,f,this.momentum),m(this.movingVariance,g,this.momentum)})(),d}))}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:ve(this.betaInitializer),gammaInitializer:ve(this.gammaInitializer),movingMeanInitializer:ve(this.movingMeanInitializer),movingVarianceInitializer:ve(this.movingVarianceInitializer),betaRegularizer:Nh(this.betaRegularizer),gammaRegularizer:Nh(this.gammaRegularizer),betaConstraint:Dl(this.betaConstraint),gammaConstraint:Dl(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}Rc.className="BatchNormalization",i.registerClass(Rc);class Oc extends Le{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const t of this.axis)if(!Number.isInteger(t))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=xe(t.betaInitializer||"zeros"),this.gammaInitializer=xe(t.gammaInitializer||"ones"),this.betaRegularizer=Ih(t.betaRegularizer),this.gammaRegularizer=Ih(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=Ie(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error(`Invalid axis: ${t}`);if(this.axis.length!==ot(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((e=>t[e]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(e,n){const r=Ee(e),i=r.shape,a=i.length;return s((()=>{let{mean:e,variance:n}=U(r,this.axis,!0);const s=J(1,a);for(const t of this.axis)s[t]=i[t];const o=e=>null!=e&&e.shape.length!==a?t.reshape(e,s):e;let l=this.scale?o(this.gamma.read()):null,u=this.center?o(this.beta.read()):null;const h=[],c=[];for(let t=0;t<a;++t)-1!==this.axis.indexOf(t)?(h.push(i[t]),c.push(1)):(h.push(1),c.push(i[t]));return e=t.tile(e,h),n=t.tile(n,h),null!=l&&(l=t.tile(l,c)),null!=u&&(u=t.tile(u,c)),Mc(r,e,n,u,l,this.epsilon)}))}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:ve(this.betaInitializer),gammaInitializer:ve(this.gammaInitializer),betaRegularizer:Nh(this.betaRegularizer),gammaRegularizer:Nh(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}Oc.className="LayerNormalization",i.registerClass(Oc);class Bc extends Le{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new q(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,n;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],n=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new q(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new q(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);n=t.padding[1]}this.padding=[e,n]}this.inputSpec=[new ze({ndim:4})]}computeOutputShape(t){let e,n;return t=Ie(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,n]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,n,t[3]])}call(e,n){return s((()=>{return n=Ee(e),r=this.padding,i=this.dataFormat,s((()=>{if(4!==n.rank)throw new q(`temporalPadding expects input tensor to be 4-D, but received a ${n.rank}-D tensor.`);if(null==r&&(r=[[1,1],[1,1]]),2!==r.length||2!==r[0].length||2!==r[1].length)throw new q("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==i&&(i="channelsLast"),"channelsLast"!==i&&"channelsFirst"!==i)throw new q(`Unknown data format: ${i}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let e;return e="channelsFirst"===i?[[0,0],[0,0],r[0],r[1]]:[[0,0],r[0],r[1],[0,0]],t.pad(n,e)}));var n,r,i}))}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function Pc(e,n,r,i,a,o){return s((()=>{let s;Nt(a),It(o),Et(i),null==r&&(r=[1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),e=Lh(e,a);const l="same"===i?"same":"valid";return s="max"===o?t.maxPool(e,n,r,l):t.avgPool(e,n,r,l),"channelsFirst"===a&&(s=t.transpose(s,[0,3,1,2])),s}))}function Wc(e,n,r,i,a,o){return s((()=>{let s;Nt(a),It(o),Et(i),null==r&&(r=[1,1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),e=Rh(e,a);const l="same"===i?"same":"valid";return s="max"===o?t.maxPool3d(e,n,r,l):t.avgPool3d(e,n,r,l),"channelsFirst"===a&&(s=t.transpose(s,[0,4,1,2,3])),s}))}Bc.className="ZeroPadding2D",i.registerClass(Bc);class Uc extends Le{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new q(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.poolSize)}`);this.poolSize=t.poolSize}if(ct(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new q(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.strides)}`);this.strides=t.strides}ct(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,Et(this.padding),this.inputSpec=[new ze({ndim:3})]}computeOutputShape(t){const e=Fh((t=Ie(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(e,n){return s((()=>{this.invokeCallHook(e,n),e=Pt(Ee(e),2);const s=this.poolingFunction(Ee(e),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return t.squeeze(s,[2])}))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class Kc extends Uc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Pc(t,e,n,s,r,"max")}}Kc.className="MaxPooling1D",i.registerClass(Kc);class Vc extends Uc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Pc(t,e,n,s,r,"avg")}}Vc.className="AveragePooling1D",i.registerClass(Vc);class qc extends Le{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new q(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides];ct(this.poolSize,"poolSize"),ct(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Nt(this.dataFormat),Et(this.padding),this.inputSpec=[new ze({ndim:4})]}computeOutputShape(t){t=Ie(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2];return e=Fh(e,this.poolSize[0],this.padding,this.strides[0]),n=Fh(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n]:[t[0],e,n,t[3]]}call(t,e){return s((()=>(this.invokeCallHook(t,e),this.poolingFunction(Ee(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class jc extends qc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Pc(t,e,n,s,r,"max")}}jc.className="MaxPooling2D",i.registerClass(jc);class Gc extends qc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Pc(t,e,n,s,r,"avg")}}Gc.className="AveragePooling2D",i.registerClass(Gc);class Hc extends Le{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new q(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];ct(this.poolSize,"poolSize"),ct(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Nt(this.dataFormat),Et(this.padding),this.inputSpec=[new ze({ndim:5})]}computeOutputShape(t){t=Ie(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[4]:t[3];return e=Fh(e,this.poolSize[0],this.padding,this.strides[0]),n=Fh(n,this.poolSize[1],this.padding,this.strides[1]),s=Fh(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n,s]:[t[0],e,n,s,t[4]]}call(t,e){return s((()=>(this.invokeCallHook(t,e),this.poolingFunction(Ee(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Jc extends Hc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Wc(t,e,n,s,r,"max")}}Jc.className="MaxPooling3D",i.registerClass(Jc);class Zc extends Hc{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return Nt(r),Et(s),Wc(t,e,n,s,r,"avg")}}Zc.className="AveragePooling3D",i.registerClass(Zc);class Yc extends Le{constructor(t){super(t),this.inputSpec=[new ze({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new j}}class Xc extends Yc{constructor(t){super(t||{})}call(e,n){return s((()=>{const n=Ee(e);return t.mean(n,1)}))}}Xc.className="GlobalAveragePooling1D",i.registerClass(Xc);class Qc extends Yc{constructor(t){super(t||{})}call(e,n){return s((()=>{const n=Ee(e);return t.max(n,1)}))}}Qc.className="GlobalMaxPooling1D",i.registerClass(Qc);class tp extends Le{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,Nt(this.dataFormat),this.inputSpec=[new ze({ndim:4})]}computeOutputShape(t){return"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new j}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class ep extends tp{call(e,n){return s((()=>{const n=Ee(e);return"channelsLast"===this.dataFormat?t.mean(n,[1,2]):t.mean(n,[2,3])}))}}ep.className="GlobalAveragePooling2D",i.registerClass(ep);class np extends tp{call(e,n){return s((()=>{const n=Ee(e);return"channelsLast"===this.dataFormat?t.max(n,[1,2]):t.max(n,[2,3])}))}}np.className="GlobalMaxPooling2D",i.registerClass(np);class sp extends Le{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,n={}){const s=Jl(e.layer,n);delete e.layer;const r={layer:s};return Object.assign(r,e),new t(r)}}class rp extends sp{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=Ie(t)).length<3)throw new q(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(t)}`);this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=Ie(t))[0]].concat(t.slice(2)),n=this.layer.computeOutputShape(e),s=t[1];return[n[0],s].concat(n.slice(1))}call(t,e){return s((()=>Xh(((t,n)=>[Ee(this.layer.call(t,e)),[]]),t=Ee(t),[],!1,null,null,!1,!0)[1]))}}rp.className="TimeDistributed",i.registerClass(rp);class ip extends sp{constructor(t){super(t);const e=t.layer.getConfig(),n={};n.className=t.layer.getClassName(),n.config=e,this.forwardLayer=Jl(n),e.goBackwards=!0!==e.goBackwards;const s={};var r;if(s.className=t.layer.getClassName(),s.config=e,this.backwardLayer=Jl(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,r=this.mergeMode,ut(xt,"BidirectionalMergeMode",r),t.weights)throw new j("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,n=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,n)),this.backwardLayer.setWeights(t.slice(n))}computeOutputShape(t){let e,n,s,r=this.forwardLayer.computeOutputShape(t);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),e=r[0]):e=r[0],"concat"===this.mergeMode?(e[e.length-1]*=2,n=[e]):n=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[e].concat(s).concat(s.slice()):X(n)}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Yh(t,n,s,this.numConstants);if(t=r.inputs,n=r.initialState,s=r.constants,Array.isArray(t)&&(n=t.slice(1),t=t[0]),(null==n||0===n.length)&&null==s)return super.apply(t,e);const i=[],a=[];if(null!=n){const t=n.length;if(t%2>0)throw new q("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=n,i.push(...n);const s=n.map((t=>new ze({shape:t.shape})));this.forwardLayer.stateSpec=s.slice(0,t/2),this.backwardLayer.stateSpec=s.slice(t/2),a.push(...s)}if(null!=s)throw new j("Support for constants in Bidirectional layers is not implemented yet.");const o=i[0]instanceof _e;for(const t of i)if(t instanceof _e!==o)throw new q("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(o){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(e,n){return s((()=>{const s=n.initialState;let r,i,a,o;if(null==s)r=this.forwardLayer.call(e,n),i=this.backwardLayer.call(e,n);else{const t=s.slice(0,s.length/2),a=s.slice(s.length/2);r=this.forwardLayer.call(e,Object.assign(n,{initialState:t})),i=this.backwardLayer.call(e,Object.assign(n,{initialState:a}))}return this.returnState&&(Array.isArray(r)&&(a=r.slice(1).concat(i.slice(1))),r=r[0],i=i[0]),this.returnSequences&&(i=t.reverse(i,1)),"concat"===this.mergeMode?o=Vt([r,i]):"sum"===this.mergeMode?o=t.add(r,i):"ave"===this.mergeMode?o=t.mul(.5,t.add(r,i)):"mul"===this.mergeMode?o=t.mul(r,i):null==this.mergeMode&&(o=[r,i]),this.returnState?null==this.mergeMode?o.concat(a):[o].concat(a):o}))}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){$t(this.forwardLayer.name,(()=>{this.forwardLayer.build(t)})),$t(this.backwardLayer.name,(()=>{this.backwardLayer.build(t)})),this.built=!0}computeMask(t,e){let n;if(Array.isArray(e)&&(e=e[0]),n=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map((t=>null));return Array.isArray(n)?n.concat(t).concat(t):[n].concat(t).concat(t)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const n=Jl(e.layer);if(delete e.layer,null!=e.numConstants)throw new j("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=e;return s.layer=n,new t(s)}}function ap(t){return new Vc(t)}function op(t){return new Gc(t)}function lp(t){return new Zc(t)}function up(t){return new Qc(t)}function hp(t){return new np(t)}function cp(t){return new Kc(t)}function pp(t){return new jc(t)}ip.className="Bidirectional",i.registerClass(ip);var dp={__proto__:null,inputLayer:function(t){return new Oe(t)},elu:function(t){return new Th(t)},reLU:function(t){return new Ah(t)},leakyReLU:function(t){return new $h(t)},prelu:function(t){return new Ch(t)},softmax:function(t){return new _h(t)},thresholdedReLU:function(t){return new zh(t)},conv1d:function(t){return new Gh(t)},conv2d:function(t){return new Wh(t)},conv2dTranspose:function(t){return new Kh(t)},conv3d:function(t){return new Uh(t)},conv3dTranspose:function(t){return new Vh(t)},separableConv2d:function(t){return new jh(t)},cropping2D:function(t){return new Hh(t)},upSampling2d:function(t){return new Jh(t)},depthwiseConv2d:function(t){return new Zh(t)},activation:function(t){return new bc(t)},dense:function(t){return new gc(t)},dropout:function(t){return new dc(t)},spatialDropout1d:function(t){return new fc(t)},flatten:function(t){return new mc(t)},repeatVector:function(t){return new yc(t)},reshape:function(t){return new wc(t)},permute:function(t){return new kc(t)},embedding:function(t){return new xc(t)},add:function(t){return new Nc(t)},average:function(t){return new Ic(t)},concatenate:function(t){return new Cc(t)},maximum:function(t){return new Ac(t)},minimum:function(t){return new $c(t)},multiply:function(t){return new Ec(t)},dot:function(t){return new zc(t)},batchNormalization:function(t){return new Rc(t)},layerNormalization:function(t){return new Oc(t)},zeroPadding2d:function(t){return new Bc(t)},averagePooling1d:ap,avgPool1d:function(t){return ap(t)},avgPooling1d:function(t){return ap(t)},averagePooling2d:op,avgPool2d:function(t){return op(t)},avgPooling2d:function(t){return op(t)},averagePooling3d:lp,avgPool3d:function(t){return lp(t)},avgPooling3d:function(t){return lp(t)},globalAveragePooling1d:function(t){return new Xc(t)},globalAveragePooling2d:function(t){return new ep(t)},globalMaxPooling1d:up,globalMaxPooling2d:hp,maxPooling1d:cp,maxPooling2d:pp,maxPooling3d:function(t){return new Jc(t)},gru:function(t){return new rc(t)},gruCell:function(t){return new sc(t)},lstm:function(t){return new ac(t)},lstmCell:function(t){return new ic(t)},simpleRNN:function(t){return new nc(t)},simpleRNNCell:function(t){return new ec(t)},convLstm2d:function(t){return new pc(t)},convLstm2dCell:function(t){return new cc(t)},rnn:function(t){return new Qh(t)},stackedRNNCells:function(t){return new oc(t)},bidirectional:function(t){return new ip(t)},timeDistributed:function(t){return new rp(t)},globalMaxPool1d:up,globalMaxPool2d:hp,maxPool1d:cp,maxPool2d:pp,Layer:Le,RNN:Qh,RNNCell:tc,input:th,gaussianNoise:function(t){return new _c(t)},gaussianDropout:function(t){return new Dc(t)},alphaDropout:function(t){return new Fc(t)},masking:function(t){return new vc(t)}};var fp={__proto__:null,binaryAccuracy:function(t,e){return au(t,e)},binaryCrossentropy:function(t,e){return cu(t,e)},sparseCategoricalAccuracy:function(t,e){return pu(t,e)},categoricalAccuracy:function(t,e){return ou(t,e)},categoricalCrossentropy:function(t,e){return du(t,e)},precision:function(t,e){return uu(t,e)},recall:function(t,e){return hu(t,e)},cosineProximity:function(t,e){return su(t,e)},meanAbsoluteError:function(t,e){return Xl(t,e)},meanAbsolutePercentageError:function(t,e){return Ql(t,e)},MAPE:function(t,e){return Ql(t,e)},mape:function(t,e){return Ql(t,e)},meanSquaredError:function(t,e){return Yl(t,e)},MSE:function(t,e){return Yl(t,e)},mse:function(t,e){return Yl(t,e)}},gp={__proto__:null,modelFromJSON:async function(t,e){"modelTopology"in t||(t={modelTopology:t});let n=t.modelTopology;null!=n.model_config&&(n=n.model_config);const s=Jl(Eu(n),e);if(null!=t.weightsManifest){const e=await C.loadWeights(t.weightsManifest,t.pathPrefix,s.weights.map((t=>t.originalName))),n={};for(const t of s.weights)n[t.originalName]=e[t.originalName];s.loadWeights(n),g(e)}return s}};var mp={__proto__:null,l1l2:function(t){return new xh(t)},l1:function(t){return kh(e=t),new xh({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return kh(e=t),new xh({l2:null!=e?e.l2:null,l1:0});var e}};class bp extends Wl{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof Gu))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function yp(t,e){return t<e}function wp(t,e){return t>e}class kp extends bp{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new j("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=yp:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=wp:this.monitorFunc=yp,this.monitorFunc===yp&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===yp?1/0:-1/0}async onEpochEnd(t,e){await Bl(e);const n=this.getMonitorValue(e);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(t)}`),e}}const vp={earlyStopping:function(t){return new kp(t)}};export{bp as Callback,Ul as CallbackList,ql as CustomCallback,kp as EarlyStopping,Vl as History,ze as InputSpec,$e as LayerVariable,Gu as LayersModel,Qh as RNN,Zu as Sequential,_e as SymbolicTensor,vp as callbacks,Ll as constraints,Ol as initializers,th as input,dp as layers,Qu as loadLayersModel,fp as metrics,Yu as model,gp as models,eh as registerCallbackConstructor,mp as regularizers,Xu as sequential,Au as version_layers};
//# sourceMappingURL=tf-layers.fesm.min.js.map
