/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],e):e((t="undefined"!=typeof globalThis?globalThis:t||self).tf=t.tf||{},t.tf)}(this,(function(t,e){"use strict";function n(t){if(t&&t.__esModule)return t;var e=Object.create(null);return t&&Object.keys(t).forEach((function(n){if("default"!==n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})}})),e.default=t,e}var s=n(e);class r extends Error{constructor(t){super(t),Object.setPrototypeOf(this,r.prototype)}}class i extends Error{constructor(t){super(t),Object.setPrototypeOf(this,i.prototype)}}class a extends Error{constructor(t){super(t),Object.setPrototypeOf(this,a.prototype)}}class o extends Error{constructor(t){super(t),Object.setPrototypeOf(this,o.prototype)}}class l extends Error{constructor(t){super(t),Object.setPrototypeOf(this,l.prototype)}}class u{constructor(t){this.maxEntries=t||100,this.cache=new Map}get(t){let e;return this.cache.has(t)&&(e=this.cache.get(t),this.cache.delete(t),this.cache.set(t,e)),e}put(t,e){if(this.cache.has(t))this.cache.delete(t);else if(this.cache.size>=this.maxEntries){const t=this.cache.keys().next().value;this.cache.delete(t)}this.cache.set(t,e)}getMaxEntries(){return this.maxEntries}setMaxEntries(t){if(t<0)throw new Error(`The maxEntries of LRU caches must be at least 0, but got ${t}.`);if(this.maxEntries>t)for(let e=0;e<this.maxEntries-t;e++){const t=this.cache.keys().next().value;this.cache.delete(t)}this.maxEntries=t}}function h(t,e){if(Array.isArray(t)){let n=[];for(let s=0;s<e;s++)n=n.concat(t);return n}{const n=new Array(e);return n.fill(t),n}}function c(t,e){if(!t)throw new l(e)}function p(t,e){let n=0;for(const s of t)s===e&&n++;return n}function d(t){return 1===t.length?t[0]:t}function f(t){return Array.isArray(t)?t:[t]}function g(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function m(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,((t,e)=>e.toUpperCase()))}let b={};function y(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function w(t){if(null!=t&&"object"==typeof t)if(Array.isArray(t))t.forEach((t=>w(t)));else{const e=Object.keys(t);for(const n of e){const e=t[n];null!=e&&"object"==typeof e&&(Array.isArray(e)||"ndarray"!==e.type||"number"!=typeof e.value?w(e):t[n]=e.value)}}}function k(t,e={},n={},s="object",r=!1){if("string"==typeof t){const r=t;let i;if(r in n)i=n[r];else if(r in b)i=b[r];else if(i=e[r],null==i)throw new a(`Unknown ${s}: ${t}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return i}{const i=t;if(null==i.className||null==i.config)throw new a(`${s}: Improper config format: ${JSON.stringify(i)}.\n'className' and 'config' must set.`);const o=i.className;let l,u;if(o in n?[l,u]=n[o]:o in b?[l,u]=b.className:o in e&&([l,u]=e[o]),null==l)throw new a(`Unknown ${s}: ${o}. This may be due to one of the following reasons:\n1. The ${s} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${s} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=u){const t={};for(const e of Object.keys(b))t[e]=b[e];for(const e of Object.keys(n))t[e]=n[e];i.config.customObjects=t;const e=Object.assign({},b);for(const t of Object.keys(n))b[t]=n[t];w(i.config);const s=u(l,i.config,n,r);return b=Object.assign({},e),s}{const t=Object.assign({},b);for(const t of Object.keys(n))b[t]=n[t];const e=new l(i.config);return b=Object.assign({},t),e}}}function v(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function x(t){if(null==t)return t;const e=[];for(const n of t)-1===e.indexOf(n)&&e.push(n);return e}function S(t){if(null==t)throw new a(`Invalid value in obj: ${JSON.stringify(t)}`);for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function N(t,e,n){if(null!=n&&t.indexOf(n)<0)throw new a(`${n} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function E(t,e,n=0,s=1/0){return c(n>=0),c(s>=n),Array.isArray(t)&&t.length>=n&&t.length<=s&&t.every((t=>typeof t===e))}function I(t,n){Array.isArray(t)?(e.util.assert(t.length>0,(()=>`${n} is unexpectedly an empty array.`)),t.forEach(((t,e)=>I(t,`element ${e+1} of ${n}`)))):e.util.assert(Number.isInteger(t)&&t>0,(()=>`Expected ${n} to be a positive integer, but got ${A(t)}.`))}function A(t){return null===t?"null":Array.isArray(t)?"["+t.map((t=>A(t))).join(",")+"]":"string"==typeof t?`"${t}"`:`${t}`}function $(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}let z=0;function C(){return z++}const T={};function _(t=""){return t in T||(T[t]=0),T[t]+=1,t+T[t].toString()}const D=["channelsFirst","channelsLast"],F=["nearest","bilinear"],M=["valid","same","causal"],L=["max","avg"],R=["sum","mul","concat","ave"],O=new Map;function B(t){N(D,"DataFormat",t)}function P(t){N(M,"PaddingMode",t)}function W(t){N(L,"PoolMode",t)}const U=[];function K(t,e){U.push(t);try{const t=e();return U.pop(),t}catch(t){throw U.pop(),t}}function V(t){if(!G(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===U.length?"":U.join("/")+"/")+t}function q(t){if(!G(t))throw new Error("Not a valid tensor name: '"+t+"'");O.has(t)||O.set(t,0);const e=O.get(t);if(O.set(t,O.get(t)+1),e>0){const n=`${t}_${e}`;return O.set(n,1),n}return t}const j=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function G(t){return!!t.match(j)}function H(t,e,n){null==e&&(e=0),null==n&&(n=t.length);let s=1;for(let r=e;r<n;++r)s*=t[r];return s}function J(t){if(0===t.length)return Number.NaN;let e=Number.POSITIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s<e&&(e=s)}return e}function Z(t){if(0===t.length)return Number.NaN;let e=Number.NEGATIVE_INFINITY;for(let n=0;n<t.length;n++){const s=t[n];s>e&&(e=s)}return e}function Y(t,e){if(e<t)throw new a(`end (${e}) < begin (${t}) is forbidden.`);const n=[];for(let s=t;s<e;++s)n.push(s);return n}let X;function Q(){return null==X&&(X=e.backend().epsilon()),X}function tt(t,e){return s.cast(t,e)}function et(t,e=-1){const n=t.shape.slice();return e<0&&(e=n.length+e+1),n.splice(e,0,1),s.reshape(t,n)}function nt(t,n,r){return e.tidy((()=>{switch(t.rank){case 1:return s.slice1d(t,n,r);case 2:return s.slice2d(t,[n,0],[r,t.shape[1]]);case 3:return s.slice3d(t,[n,0,0],[r,t.shape[1],t.shape[2]]);case 4:return s.slice4d(t,[n,0,0,0],[r,t.shape[1],t.shape[2],t.shape[3]]);case 5:return s.slice(t,[n,0,0,0,0],[r,t.shape[1],t.shape[2],t.shape[3],t.shape[4]]);case 6:return s.slice(t,[n,0,0,0,0,0],[r,t.shape[1],t.shape[2],t.shape[3],t.shape[4],t.shape[5]]);default:throw new a(`sliceAlongFirstAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function st(t,n,r){return e.tidy((()=>{switch(t.rank){case 1:return s.slice1d(t,n,r);case 2:return s.slice2d(t,[0,n],[t.shape[0],r]);case 3:return s.slice3d(t,[0,0,n],[t.shape[0],t.shape[1],r]);case 4:return s.slice4d(t,[0,0,0,n],[t.shape[0],t.shape[1],t.shape[2],r]);default:throw new a(`sliceAlongLastAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function rt(t,n,r,i){return e.tidy((()=>{switch(t.rank){case 1:return s.slice1d(t,n,r);case 2:switch(i){case 1:return nt(t,n,r);case 2:return st(t,n,r);default:throw new a(`The axis is not within the rank of the tensor ${i}`)}case 3:switch(i){case 1:return nt(t,n,r);case 2:return s.slice3d(t,[0,n,0],[t.shape[0],r,t.shape[2]]);case 3:return st(t,n,r);default:throw new a(`The axis is not within the rank of the tensor ${i}`)}case 4:switch(i){case 1:return nt(t,n,r);case 2:return s.slice4d(t,[0,n,0,0],[t.shape[0],r,t.shape[2],t.shape[3]]);case 3:return s.slice4d(t,[0,0,n,0],[t.shape[0],t.shape[1],r,t.shape[3]]);case 4:return st(t,n,r);default:throw new a(`The axis is not within the rank of the tensor ${i}`)}default:throw new a(`sliceAlongLastAxis() received an unsupported tensor rank: ${t.rank}`)}}))}function it(t,e=-1){let n;return e<0&&(n=t[0].rank,e=0!==n?n:0),e===t[0].rank&&(e=-1),s.concat(t,e)}function at(t,e){switch(t.rank){case 1:return s.concat1d([t,e]);case 2:return s.concat2d([t,e],0);case 3:return s.concat3d([t,e],0);case 4:return s.concat4d([t,e],0);default:throw new a(`concatAlongFirstAxis() received an unsupported tensor rank: ${t.rank}`)}}function ot(t,e){if(Array.isArray(e)||(e=[e]),t.rank!==e.length)throw new a(`The length of input n (${e.length}) does not match the number of dimensions in input x (${t.rank})`);return s.tile(t,e)}function lt(t,e=0,n=1,r,i){return s.randomNormal(t,e,n,r,i)}function ut(t,e,n,r){if(t.rank<2||e.rank<2)throw new o(`dot requires both inputs to be rank >= 2 but got x shape = ${t.shape} and y shape = ${e.shape}`);if(e.rank>=3){if(t.shape.slice(-1)[0]!==e.shape.slice(-2)[0])throw new o(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${t.shape} and  y shape = ${e.shape}`)}if(2===t.rank&&2===e.rank){const i=!1,a=!1;return s.fused.matMul({a:t,b:e,transposeA:i,transposeB:a,bias:r?pt(t.rank,r,"channelsLast"):null,activation:n})}{const i=t.shape.slice(),a=i.pop();t=s.reshape(t,[-1,a]);const o=e.shape.slice(),l=o.pop(),u=o.pop(),h=[...o,l],c=Array.from({length:e.rank},((t,n)=>0===n?e.rank-2:n<=e.rank-2?n-1:n));e=s.reshape(s.transpose(e,c),[u,-1]);const p=[...i,...h],d=!1,f=!1;return s.reshape(s.fused.matMul({a:t,b:e,transposeA:d,transposeB:f,bias:r?pt(t.rank,r,"channelsLast"):null,activation:n}),p)}}function ht(t,n,r){return e.tidy((()=>(n=Array.isArray(n)?e.tensor1d(n,"int32"):s.cast(n,"int32"),s.gather(t,n,r))))}function ct(t){return s.mul(t,t)}function pt(t,e,n){const r=e.shape;if(1!==e.rank&&e.rank!==t)throw new a(`Unexpected bias dimensions: ${e.rank}; expected it to be 1 or ${t}`);if(5===t){if("channelsFirst"===n)return 1===r.length?s.reshape(e,[1,r[0],1,1,1]):s.reshape(e,[1,r[3],r[0],r[1],r[2]]);if("channelsLast"===n)return 1===r.length?s.reshape(e,[1,1,1,1,r[0]]):s.reshape(e,[1].concat(r))}else if(4===t){if("channelsFirst"===n)return 1===r.length?s.reshape(e,[1,r[0],1,1]):s.reshape(e,[1,r[2],r[0],r[1]]);if("channelsLast"===n)return 1===r.length?s.reshape(e,[1,1,1,r[0]]):s.reshape(e,[1].concat(r))}else if(3===t){if("channelsFirst"===n)return 1===r.length?s.reshape(e,[1,r[0],1]):s.reshape(e,[1,r[1],r[0]]);if("channelsLast"===n)return 1===r.length?s.reshape(e,[1,1,r[0]]):s.reshape(e,[1].concat(r))}else if(t<3)return e;throw new a(`Unsupported input rank by biasAdd: ${e.rank}`)}function dt(t,n,r){return e.tidy((()=>(null==r&&(r="channelsLast"),B(r),s.add(t,pt(t.rank,n,r)))))}function ft(t,n,r,i){return e.tidy((()=>s.dropout(t,n,r,i)))}function gt(t,e,n=!1){return n?t():e()}const mt=["fanIn","fanOut","fanAvg"],bt=["normal","uniform","truncatedNormal"];class yt extends e.serialization.Serializable{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class wt extends yt{apply(t,n){return e.zeros(t,n)}}wt.className="Zeros",e.serialization.registerClass(wt);class kt extends yt{apply(t,n){return e.ones(t,n)}}kt.className="Ones",e.serialization.registerClass(kt);class vt extends yt{constructor(t){if(super(),"object"!=typeof t)throw new a(`Expected argument of type ConstantConfig but got ${t}`);if(void 0===t.value)throw new a(`config must have value set but got ${t}`);this.value=t.value}apply(t,n){return e.tidy((()=>e.mul(e.scalar(this.value),e.ones(t,n))))}getConfig(){return{value:this.value}}}vt.className="Constant",e.serialization.registerClass(vt);class xt extends yt{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,n){return e.randomUniform(t,this.minval,this.maxval,n)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}xt.className="RandomUniform",e.serialization.registerClass(xt);class St extends yt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new o(`randomNormal does not support dType ${e}.`);return lt(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}St.className="RandomNormal",e.serialization.registerClass(St);class Nt extends yt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,n){if("float32"!==(n=n||"float32")&&"int32"!==n)throw new o(`truncatedNormal does not support dType ${n}.`);return e.truncatedNormal(t,this.mean,this.stddev,n,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Nt.className="TruncatedNormal",e.serialization.registerClass(Nt);class Et extends yt{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,n){return e.tidy((()=>{if(2!==t.length||t[0]!==t[1])throw new a("Identity matrix initializer can only be used for 2D square matrices.");return e.mul(this.gain,e.eye(t[0]))}))}getConfig(){return{gain:this.gain}}}Et.className="Identity",e.serialization.registerClass(Et);class It extends yt{constructor(t){if(super(),t.scale<0)throw new a(`scale must be a positive float. Got: ${t.scale}`);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,N(mt,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){N(bt,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,n){const s=function(t,e="channelsLast"){let n,s;if(B(e),2===t.length)n=t[0],s=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=H(t,2);n=t[1]*e,s=t[0]*e}else if("channelsLast"===e){const e=H(t,0,t.length-2);n=t[t.length-2]*e,s=t[t.length-1]*e}}else{const e=H(t);n=Math.sqrt(e),s=Math.sqrt(e)}return[n,s]}(t),r=s[0],i=s[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,r):"fanOut"===this.mode?a/=Math.max(1,i):a/=Math.max(1,(r+i)/2),"normal"===this.distribution){const s=Math.sqrt(a);if("float32"!==(n=n||"float32")&&"int32"!==n)throw new o(`${this.getClassName()} does not support dType ${n}.`);return e.truncatedNormal(t,0,s,n,this.seed)}{const s=Math.sqrt(3*a);return e.randomUniform(t,-s,s,n)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}It.className="VarianceScaling",e.serialization.registerClass(It);class At extends It{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return It.className}}At.className="GlorotUniform",e.serialization.registerClass(At);class $t extends It{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return It.className}}$t.className="GlorotNormal",e.serialization.registerClass($t);class zt extends It{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return It.className}}zt.className="HeNormal",e.serialization.registerClass(zt);class Ct extends It{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return It.className}}Ct.className="HeUniform",e.serialization.registerClass(Ct);class Tt extends It{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return It.className}}Tt.className="LeCunNormal",e.serialization.registerClass(Tt);class _t extends It{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return It.className}}_t.className="LeCunNormal",e.serialization.registerClass(_t);class Dt extends yt{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new o("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,n){return e.tidy((()=>{if(t.length<2)throw new o("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const n=lt(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let s=e.linalg.gramSchmidt(n);return t[0]>t[1]&&(s=e.transpose(s)),e.mul(this.gain,s)}))}getConfig(){return{gain:this.gain,seed:this.seed}}}Dt.className="Orthogonal",e.serialization.registerClass(Dt);const Ft={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function Mt(t,n={}){return k(t,e.serialization.SerializationMap.getMap().classNameMap,n,"initializer")}function Lt(t){return y(t)}function Rt(t){if("string"==typeof t){const e=t in Ft?Ft[t]:t;if("GlorotNormal"===e)return new $t;if("GlorotUniform"===e)return new At;if("HeNormal"===e)return new zt;if("HeUniform"===e)return new Ct;if("LeCunNormal"===e)return new Tt;if("LeCunUniform"===e)return new _t;{const t={};return t.className=e,t.config={},Mt(t)}}return t instanceof yt?t:Mt(t)}function Ot(t){return Array.isArray(t)&&Array.isArray(t[0])}function Bt(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function Pt(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new a(`Expected Tensor length to be 1; got ${t.length}`);e=t[0]}else e=t;return e}function Wt(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return t[0];throw new a(`Expected exactly 1 Shape; got ${t.length}`)}return t}function Ut(t){let e=0;for(const n of t)0===n.shape.length?e+=1:e+=n.shape.reduce(((t,e)=>t*e));return e}const Kt="Variable";class Vt{constructor(t,e="float32",n="Variable",r=!0,i=null){this.dtype=null==e?"float32":e,this.shape=t.shape,this.id=C(),n=null==n?Kt:n,this.originalName=V(n),this.name=q(this.originalName),this.trainable_=r,this.constraint=i,this.val=s.variable(t,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function qt(t){return t.map((t=>t.read()))}function jt(t){t.forEach((t=>{t[0].write(t[1])}))}class Gt{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class Ht{constructor(t,e,n,s,r,i,a){this.dtype=t,this.shape=e,this.sourceLayer=n,this.inputs=s,this.callArgs=r,this.outputTensorIndex=a,this.id=C(),null!=i&&(this.originalName=V(i),this.name=q(this.originalName)),this.rank=e.length}}let Jt=0;class Zt{constructor(t,e){this.callArgs=e,this.id=Jt++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let Yt=0;class Xt extends e.serialization.Serializable{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=Yt++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=g(t)+"_"+_(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let n=null;null!=t.batchSize&&(n=t.batchSize),e=[n].concat(t.inputShape)}this.batchInputShape=e;let n=t.dtype;null==n&&(n=t.inputDType),null==n&&(n="float32"),this.dtype=n}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new i(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new a(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return d(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return d(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new r(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use \`getInputAt(nodeIndex)\` instead.`);if(0===this.inboundNodes.length)throw new r(`Layer ${this.name} is not connected, no input to return.`);return d(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new r(`Layer ${this.name} has no inbound nodes.`);if(this.inboundNodes.length>1)throw new r(`Layer ${this.name} has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use \`getOutputAt(nodeIndex)\` instead.`);return d(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map((t=>t()))}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach((e=>e.trainable=t)),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter((t=>t.trainable)):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter((t=>!t.trainable)).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=f(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=f(this.inputSpec);if(t.length!==e.length)throw new a(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: ${t}`);for(let n=0;n<t.length;n++){const s=t[n],r=e[n];if(null==r)continue;const i=s.rank;if(null!=r.ndim&&i!==r.ndim)throw new a(`Input ${n} is incompatible with layer ${this.name}: expected ndim=${r.ndim}, found ndim=${i}`);if(null!=r.maxNDim&&i>r.maxNDim)throw new a(`Input ${n} is incompatible with layer ${this.name}: expected max_ndim=${r.maxNDim}, found ndim=${i}`);if(null!=r.minNDim&&i<r.minNDim)throw new a(`Input ${n} is incompatible with layer ${this.name}: expected min_ndim=${r.minNDim}, found ndim=${i}.`);if(null!=r.dtype&&s.dtype!==r.dtype)throw new a(`Input ${n} is incompatible with layer ${this.name} : expected dtype=${r.dtype}, found dtype=${s.dtype}.`);if(r.axes){const t=s.shape;for(const e in r.axes){const s=Number(e),i=r.axes[e],o=s>=0?t[s]:t[t.length+s];if(null!=i&&-1===[i,null].indexOf(o))throw new a(`Input ${n} is incompatible with layer ${this.name}: expected axis ${s} of input shape to have value ${i} but got shape ${t}.`)}}if(null!=r.shape)for(let t=0;t<r.shape.length;++t){const e=r.shape[t],i=s.shape[t];if(null!=e&&null!=i&&e!==i)throw new a(`Input ${n} is incompatible with layer ${this.name}: expected shape=${r.shape}, found shape=${s.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const n=f(t);let s=!0;for(const t of n)if(!(t instanceof Ht)){s=!1;break}let r=!0;for(const t of n)if(t instanceof Ht){r=!1;break}if(s===r)throw new a("Arguments to apply() must be all SymbolicTensors or all Tensors");return K(this.name,(()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const n of f(t))e.push(n.shape);this.build(d(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&r&&(this._refCount=1)}if(this.assertInputCompatibility(t),r){let s=this.call(t,e);const r=f(s),i=[];for(let t of r)-1!==n.indexOf(t)&&(t=t.clone()),i.push(t);if(s=d(i),null!=this.activityRegularizer)throw new o("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return s}{const n=function(t){t=f(t);const e=[];for(const n of t)e.push(n.shape);return d(e)}(t),s=this.computeOutputShape(n);let r;const i="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?n[0]:n),r=null!=s&&s.length>0&&Array.isArray(s[0])?s.map(((n,s)=>new Ht(i,n,this,f(t),e,this.name,s))):new Ht(i,s,this,f(t),e,this.name),this.addInboundNode(t,r,null,null,n,s,e),this._refCount++,null!=this.activityRegularizer)throw new o("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return r}}))}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn(`The rank of the input tensor provided (shape: ${JSON.stringify(t)}) does not match that of the batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer ${this.name}`);else{let e=!1;this.batchInputShape.forEach(((n,s)=>{null!=n&&null!=t[s]&&t[s]!==n&&(e=!0)})),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: ${JSON.stringify(this.batchInputShape)}`)}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new r(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const n=JSON.stringify(e.outputShapes);-1===t.indexOf(n)&&t.push(n)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new r(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new i(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return Ut(this.weights)}build(t){this.built=!0}getWeights(t=!1){return qt(t?this.trainableWeights:this.weights)}setWeights(t){e.tidy((()=>{const n=this.weights;if(n.length!==t.length)throw new a(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${n.length} weights. Provided weights: ${t}...`);if(0===n.length)return;const s=[],r=qt(n);for(let i=0;i<r.length;++i){const o=r[i],l=n[i],u=t[i];if(!e.util.arraysEqual(o.shape,u.shape))throw new a(`Layer weight shape ${o.shape} not compatible with provided weight shape ${u.shape}`);s.push([l,u])}jt(s)}))}addWeight(t,e,n,s,r,i,o,l){if(-1!==this._addedWeightNames.indexOf(t))throw new a(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==n&&(n="float32"),this.fastWeightInitDuringBuild&&(s=null!=l?l():Rt("zeros"));const u=s.apply(e,n),h=new Vt(u,n,t,i,o);return u.dispose(),null!=r&&this.addLoss((()=>r.apply(h.read()))),null==i&&(i=!0),i?this._trainableWeights.push(h):this._nonTrainableWeights.push(h),h}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=f(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach((t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)}))}return null}return e}addInboundNode(t,e,n,s,r,i,a=null){const o=f(t);e=f(e),n=f(n),s=f(s),r=Bt(r),i=Bt(i);const l=[],u=[],h=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),h.push(t.tensorIndex);new Zt({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:h,inputTensors:o,outputTensors:e,inputMasks:n,outputMasks:s,inputShapes:r,outputShapes:i},a);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach((t=>t.dispose())),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}function Qt(t,e,n){if((null==e||null!=n&&n>0)&&(e=t.sourceLayer,n=t.nodeIndex),0===e.inboundNodes.length)return[t];{const t=e.inboundNodes[n];if(0===t.inboundLayers.length)return t.inputTensors;{const e=[];for(let n=0;n<t.inboundLayers.length;n++){const s=Qt(t.inputTensors[n],t.inboundLayers[n],t.nodeIndices[n]);for(const t of s)-1===e.indexOf(t)&&e.push(t)}return e}}}class te extends Xt{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:_("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new a("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new a("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new a("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const n=t.dtype||"float32";this.batchInputShape=e,this.dtype=n,this.inputSpec=[{shape:e}];const s=new Ht(this.dtype,this.batchInputShape,this,[],{},this.name);s.nodeIndex=0,s.tensorIndex=0,new Zt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[s],outputTensors:[s],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new a(`Cannot pass any input to an InputLayer's apply() method. InputLayer name: ${this.name}`)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function ee(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new a("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let n=t.dtype;null==n&&(n="float32");return new te({batchInputShape:e,name:t.name,dtype:n,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}te.className="InputLayer",e.serialization.registerClass(te);class ne{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof ne)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,n,s){if(null!=this.id2Value[t.id])throw new a(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,n){if(null==t.dtype||t.dtype===n.dtype)return n;try{return e.cast(n,t.dtype)}catch(e){throw new a(`The dtype of the feed (${n.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,n),this.name2Id[t.name]=t.id,null!=s&&(this.id2Mask[t.id]=s),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof Ht){if(null==this.id2Value[t.id])throw new a(`Nonexistent key: ${t.name}`);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new a(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Value[e]}}getMask(t){if(t instanceof Ht){if(null==this.id2Value[t.id])throw new a(`Nonexistent key: ${t.name}`);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new a(`Feed dict has no SymbolicTensor name: ${t}`);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&e.dispose(this.id2Mask)}}const se=new u,re=new u;function ie(t,n,s,r){const i=null!=s&&s.training,a=Array.isArray(t),o=a?t:[t],l=o.map((t=>t.name)),u=[],h=n.names();for(const t of l)-1!==h.indexOf(t)?u.push(n.getValue(t)):u.push(null);null!=r&&(r.maxNumTensors=-1/0,r.minNumTensors=1/0);const c=l.join(",")+"|"+n.names().sort().join(",");let p,d=se.get(c);if(null==d){const t=function(t,n){e.util.assert(null!=t&&t.length>0,(()=>"Expected at least one fetch, got none"));let s=[],r={};if(1===t.length){const e=oe(t[0],n);s=e.sorted,r=e.recipientMap}else{const e=new Set;for(const i of t){const{sorted:t,recipientMap:a}=oe(i,n);for(const n of t)e.has(n.name)||(s.push(n),e.add(n.name));for(const t in a)null==r[t]&&(r[t]=new Set),a[t].forEach((e=>r[t].add(e)))}}return{sorted:s,recipientCounts:ae(r)}}(o,n);d=t.sorted,p=t.recipientCounts,se.put(c,d),re.put(c,p)}p={},i||Object.assign(p,re.get(c));const g=new ne(n);for(let t=0;t<d.length;++t){if(null!=r){const t=e.memory().numTensors;t>r.maxNumTensors&&(r.maxNumTensors=t),t<r.minNumTensors&&(r.minNumTensors=t)}const a=d[t],o=a.sourceLayer;if(o instanceof te)continue;const h=[],c=[],m=[];let b=!1;for(const t of a.inputs){const e=g.getValue(t),s=g.getMask(t);h.push(e),c.push(s),null!=s&&(b=!0),i||(p[t.name]--,0!==p[t.name]||n.hasKey(t)||-1!==l.indexOf(t.name)||e.isDisposed||!0===t.sourceLayer.stateful||m.push(e))}b&&((s=s||{}).mask=c[0]);const y=f(o.apply(h,s));let w=null;o.supportsMasking&&(w=o.computeMask(h,c));const k=le(a),v=Array.isArray(k)?k:[k];for(let t=0;t<v.length;++t){g.hasKey(v[t])||g.add(v[t],y[t],Array.isArray(w)?w[0]:w);const e=l.indexOf(v[t].name);-1!==e&&(u[e]=y[t])}i||e.dispose(m)}return g.disposeMasks(),a?u:u[0]}function ae(t){const e={};for(const n in t)e[n]=t[n].size;return e}function oe(t,e){const n=new Set,s=[],r={};for(const t of e.names())n.add(t);const i=[],a=[];for(i.push(t);i.length>0;){const t=i[i.length-1];if(n.has(t.name)){i.pop();continue}const e=a[a.length-1]===i.length-1;if(0===t.inputs.length||e)i.pop(),s.push(t),n.add(t.name),e&&a.pop();else{a.push(i.length-1);for(const e of t.inputs)null==r[e.name]&&(r[e.name]=new Set),r[e.name].add(t.name),n.has(e.name)||i.push(e)}}return{sorted:s,recipientMap:r}}function le(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let n=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const s of t.sourceLayer.inboundNodes[e].outputTensors)if(s.id===t.id){n=e;break}e=t.sourceLayer.getOutputAt(n)}return e}e.env().registerFlag("TOPOLOGICAL_SORT_CACHE_MAX_ENTRIES",(()=>100),(function(t){null!=se&&se.setMaxEntries(t),null!=re&&re.setMaxEntries(t)}));const ue="Acos",he="Acosh",ce="Add",pe="AddN",de="ArgMax",fe="ArgMin",ge="Asin",me="Asinh",be="Atan",ye="Atanh",we="Atan2",ke="AvgPool",ve="AvgPool3D",xe="BatchMatMul",Se="BatchToSpaceND",Ne="Cast",Ee="Ceil",Ie="ClipByValue",Ae="ComplexAbs",$e="Concat",ze="Conv2D",Ce="Conv2DBackpropInput",Te="Conv3D",_e="Cosh",De="Cumsum",Fe="DepthwiseConv2dNative",Me="Dilation2D",Le="RealDiv",Re="ExpandDims",Oe="Expm1",Be="Floor",Pe="FloorDiv",We="FusedBatchNorm",Ue="GatherV2",Ke="GreaterEqual",Ve="Identity",qe="IsFinite",je="IsInf",Ge="IsNan",He="LeakyRelu",Je="Log1p",Ze="Maximum",Ye="MaxPool",Xe="MaxPool3D",Qe="Mean",tn="Minimum",en="MirrorPad",nn="Multiply",sn="OnesLike",rn="OneHot",an="Pack",on="PadV2",ln="Prelu",un="Prod",hn="Reciprocal",cn="Relu",pn="Reshape",dn="ResizeNearestNeighbor",fn="ResizeBilinear",gn="Relu6",mn="Reverse",bn="Round",yn="Rsqrt",wn="Select",kn="Selu",vn="Slice",xn="Sinh",Sn="Sign",Nn="Sigmoid",En="Softplus",In="Sqrt",An="SpaceToBatchND",$n="SplitV",zn="Softmax",Cn="SquaredDifference",Tn="Tanh",_n="Tile",Dn="Transpose",Fn="Unpack",Mn="UnsortedSegmentSum",Ln="ZerosLike",Rn="Step",On="FromPixels",Bn="_FusedMatMul",Pn="FusedConv2D",Wn="FusedDepthwiseConv2D";function Un(t){throw new Error(`'${t}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function Kn(t,e){if(!t)throw new Error("string"==typeof e?e:e())}function Vn(t,e,n=""){Kn(Hn(t,e),(()=>n+` Shapes ${t} and ${e} must match`))}function qn(t){Kn(null!=t,(()=>"The input to the tensor constructor must be a non-null value."))}function jn(t,e=[],n=!1){if(null==e&&(e=[]),Array.isArray(t)||Xn(t)&&!n)for(let s=0;s<t.length;++s)jn(t[s],e,n);else e.push(t);return e}function Gn(t){if(0===t.length)return 1;let e=t[0];for(let n=1;n<t.length;n++)e*=t[n];return e}function Hn(t,e){if(t===e)return!0;if(null==t||null==e)return!1;if(t.length!==e.length)return!1;for(let n=0;n<t.length;n++)if(t[n]!==e[n])return!1;return!0}function Jn(t){return t%1==0}function Zn(t,e){return e<=t.length?t:t+" ".repeat(e-t.length)}function Yn(t,e){const n=e.length;return Kn((t=null==t?e.map(((t,e)=>e)):[].concat(t)).every((t=>t>=-n&&t<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${t}`)),Kn(t.every((t=>Jn(t))),(()=>`All values in axis param must be integers but got axis ${t}`)),t.map((t=>t<0?n+t:t))}function Xn(t){return t instanceof Float32Array||t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray}function Qn(t){if("float32"===t||"int32"===t)return 4;if("complex64"===t)return 8;if("bool"===t)return 1;throw new Error(`Unknown dtype ${t}`)}function ts(t){return"string"==typeof t||t instanceof String}function es(t){return Array.isArray(t)?es(t[0]):t instanceof Float32Array?"float32":t instanceof Int32Array||t instanceof Uint8Array||t instanceof Uint8ClampedArray?"int32":"number"==typeof t?"float32":ts(t)?"string":function(t){return"boolean"==typeof t}(t)?"bool":"float32"}function ns(t){return!!(t&&t.constructor&&t.call&&t.apply)}function ss(t){const e=t.length;if(e<2)return[];const n=new Array(e-1);n[e-2]=t[e-1];for(let s=e-3;s>=0;--s)n[s]=n[s+1]*t[s+1];return n}function rs(t,e,n,s=!1){const r=new Array;if(1===e.length){const i=e[0]*(s?2:1);for(let e=0;e<i;e++)r[e]=n[t+e]}else{const i=e[0],a=e.slice(1),o=a.reduce(((t,e)=>t*e))*(s?2:1);for(let e=0;e<i;e++)r[e]=rs(t+e*o,a,n,s)}return r}function is(t,e,n=!1){if(0===t.length)return e[0];const s=t.reduce(((t,e)=>t*e))*(n?2:1);if(0===s)return[];if(s!==e.length)throw new Error(`[${t}] does not match the input size ${e.length}${n?" for a complex tensor":""}.`);return rs(0,t,e,n)}function as(t,e){const n=os(t,e);for(let t=0;t<n.length;t++)n[t]=1;return n}function os(t,e){if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e)return new Uint8Array(t);throw new Error(`Unknown data type ${e}`)}function ls(t){t.forEach((e=>{Kn(Number.isInteger(e)&&e>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${t}].`))}))}function us(t){return t&&t.then&&"function"==typeof t.then}const hs="tfjsflags";class cs{constructor(t){this.global=t,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=ps,this.populateURLFlags()}setPlatform(t,e){null!=this.platform&&(ds().getBool("IS_TEST")||ds().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`)),this.platformName=t,this.platform=e}registerFlag(t,e,n){if(this.flagRegistry[t]={evaluationFn:e,setHook:n},null!=this.urlFlags[t]){const e=this.urlFlags[t];ds().getBool("IS_TEST")||ds().getBool("PROD")||console.warn(`Setting feature override from URL ${t}: ${e}.`),this.set(t,e)}}async getAsync(t){return t in this.flags||(this.flags[t]=await this.evaluateFlag(t)),this.flags[t]}get(t){if(t in this.flags)return this.flags[t];const e=this.evaluateFlag(t);if(us(e))throw new Error(`Flag ${t} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[t]=e,this.flags[t]}getNumber(t){return this.get(t)}getBool(t){return this.get(t)}getFlags(){return this.flags}get features(){return this.flags}set(t,e){if(null==this.flagRegistry[t])throw new Error(`Cannot set flag ${t} as it has not been registered.`);this.flags[t]=e,null!=this.flagRegistry[t].setHook&&this.flagRegistry[t].setHook(e)}evaluateFlag(t){if(null==this.flagRegistry[t])throw new Error(`Cannot evaluate flag '${t}': no evaluation function found.`);return this.flagRegistry[t].evaluationFn()}setFlags(t){this.flags=Object.assign({},t)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const t=this.getQueryParams(this.global.location.search);if(hs in t){t.tfjsflags.split(",").forEach((t=>{const[e,n]=t.split(":");this.urlFlags[e]=function(t,e){if("true"===(e=e.toLowerCase())||"false"===e)return"true"===e;if(""+ +e===e)return+e;throw new Error(`Could not parse value flag value ${e} for flag ${t}.`)}(e,n)}))}}}function ps(t){const e={};return t.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((t,...n)=>(function(t,e,n){t[decodeURIComponent(e)]=decodeURIComponent(n||"")}(e,n[0],n[1]),n.join("=")))),e}function ds(){return gs}let fs,gs=null;function ms(){if(null==fs){let t;if("undefined"!=typeof window)t=window;else if("undefined"!=typeof global)t=global;else if("undefined"!=typeof process)t=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");t=self}fs=t}return fs}function bs(t,e){const n=function(){const t=ms();return null==t._tfGlobals&&(t._tfGlobals=new Map),t._tfGlobals}();if(n.has(t))return n.get(t);{const s=e();return n.set(t,s),n.get(t)}}function ys(...t){ds().getBool("IS_TEST")||ds().getBool("PROD")||console.warn(...t)}const ws=bs("kernelRegistry",(()=>new Map)),ks=bs("gradRegistry",(()=>new Map));function vs(t,e){const n=function(t,e){return`${e}_${t}`}(t,e);return ws.get(n)}function xs(t){return ks.get(t)}function Ss(t){const e=ws.entries(),n=[];for(;;){const{done:s,value:r}=e.next();if(s)break;const[i,a]=r,[o]=i.split("_");o===t&&n.push(a)}return n}function Ns(t){const{kernelName:e}=t;ks.has(e)&&ds().getBool("DEBUG")&&ys(`Overriding the gradient for '${e}'`),ks.set(e,t)}var Es=As,Is=null;try{Is=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(t){}function As(t,e,n){this.low=0|t,this.high=0|e,this.unsigned=!!n}function $s(t){return!0===(t&&t.__isLong__)}As.prototype.__isLong__,Object.defineProperty(As.prototype,"__isLong__",{value:!0}),As.isLong=$s;var zs={},Cs={};function Ts(t,e){var n,s,r;return e?(r=0<=(t>>>=0)&&t<256)&&(s=Cs[t])?s:(n=Ds(t,(0|t)<0?-1:0,!0),r&&(Cs[t]=n),n):(r=-128<=(t|=0)&&t<128)&&(s=zs[t])?s:(n=Ds(t,t<0?-1:0,!1),r&&(zs[t]=n),n)}function _s(t,e){if(isNaN(t))return e?Us:Ws;if(e){if(t<0)return Us;if(t>=Os)return Gs}else{if(t<=-Bs)return Hs;if(t+1>=Bs)return js}return t<0?_s(-t,e).neg():Ds(t%Rs|0,t/Rs|0,e)}function Ds(t,e,n){return new As(t,e,n)}As.fromInt=Ts,As.fromNumber=_s,As.fromBits=Ds;var Fs=Math.pow;function Ms(t,e,n){if(0===t.length)throw Error("empty string");if("NaN"===t||"Infinity"===t||"+Infinity"===t||"-Infinity"===t)return Ws;if("number"==typeof e?(n=e,e=!1):e=!!e,(n=n||10)<2||36<n)throw RangeError("radix");var s;if((s=t.indexOf("-"))>0)throw Error("interior hyphen");if(0===s)return Ms(t.substring(1),e,n).neg();for(var r=_s(Fs(n,8)),i=Ws,a=0;a<t.length;a+=8){var o=Math.min(8,t.length-a),l=parseInt(t.substring(a,a+o),n);if(o<8){var u=_s(Fs(n,o));i=i.mul(u).add(_s(l))}else i=(i=i.mul(r)).add(_s(l))}return i.unsigned=e,i}function Ls(t,e){return"number"==typeof t?_s(t,e):"string"==typeof t?Ms(t,e):Ds(t.low,t.high,"boolean"==typeof e?e:t.unsigned)}As.fromString=Ms,As.fromValue=Ls;var Rs=4294967296,Os=Rs*Rs,Bs=Os/2,Ps=Ts(1<<24),Ws=Ts(0);As.ZERO=Ws;var Us=Ts(0,!0);As.UZERO=Us;var Ks=Ts(1);As.ONE=Ks;var Vs=Ts(1,!0);As.UONE=Vs;var qs=Ts(-1);As.NEG_ONE=qs;var js=Ds(-1,2147483647,!1);As.MAX_VALUE=js;var Gs=Ds(-1,-1,!0);As.MAX_UNSIGNED_VALUE=Gs;var Hs=Ds(0,-2147483648,!1);As.MIN_VALUE=Hs;var Js=As.prototype;Js.toInt=function(){return this.unsigned?this.low>>>0:this.low},Js.toNumber=function(){return this.unsigned?(this.high>>>0)*Rs+(this.low>>>0):this.high*Rs+(this.low>>>0)},Js.toString=function(t){if((t=t||10)<2||36<t)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Hs)){var e=_s(t),n=this.div(e),s=n.mul(e).sub(this);return n.toString(t)+s.toInt().toString(t)}return"-"+this.neg().toString(t)}for(var r=_s(Fs(t,6),this.unsigned),i=this,a="";;){var o=i.div(r),l=(i.sub(o.mul(r)).toInt()>>>0).toString(t);if((i=o).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Js.getHighBits=function(){return this.high},Js.getHighBitsUnsigned=function(){return this.high>>>0},Js.getLowBits=function(){return this.low},Js.getLowBitsUnsigned=function(){return this.low>>>0},Js.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Hs)?64:this.neg().getNumBitsAbs();for(var t=0!=this.high?this.high:this.low,e=31;e>0&&0==(t&1<<e);e--);return 0!=this.high?e+33:e+1},Js.isZero=function(){return 0===this.high&&0===this.low},Js.eqz=Js.isZero,Js.isNegative=function(){return!this.unsigned&&this.high<0},Js.isPositive=function(){return this.unsigned||this.high>=0},Js.isOdd=function(){return 1==(1&this.low)},Js.isEven=function(){return 0==(1&this.low)},Js.equals=function(t){return $s(t)||(t=Ls(t)),(this.unsigned===t.unsigned||this.high>>>31!=1||t.high>>>31!=1)&&(this.high===t.high&&this.low===t.low)},Js.eq=Js.equals,Js.notEquals=function(t){return!this.eq(t)},Js.neq=Js.notEquals,Js.ne=Js.notEquals,Js.lessThan=function(t){return this.comp(t)<0},Js.lt=Js.lessThan,Js.lessThanOrEqual=function(t){return this.comp(t)<=0},Js.lte=Js.lessThanOrEqual,Js.le=Js.lessThanOrEqual,Js.greaterThan=function(t){return this.comp(t)>0},Js.gt=Js.greaterThan,Js.greaterThanOrEqual=function(t){return this.comp(t)>=0},Js.gte=Js.greaterThanOrEqual,Js.ge=Js.greaterThanOrEqual,Js.compare=function(t){if($s(t)||(t=Ls(t)),this.eq(t))return 0;var e=this.isNegative(),n=t.isNegative();return e&&!n?-1:!e&&n?1:this.unsigned?t.high>>>0>this.high>>>0||t.high===this.high&&t.low>>>0>this.low>>>0?-1:1:this.sub(t).isNegative()?-1:1},Js.comp=Js.compare,Js.negate=function(){return!this.unsigned&&this.eq(Hs)?Hs:this.not().add(Ks)},Js.neg=Js.negate,Js.add=function(t){$s(t)||(t=Ls(t));var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=0,u=0,h=0,c=0;return h+=(c+=r+(65535&t.low))>>>16,u+=(h+=s+o)>>>16,l+=(u+=n+a)>>>16,l+=e+i,Ds((h&=65535)<<16|(c&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Js.subtract=function(t){return $s(t)||(t=Ls(t)),this.add(t.neg())},Js.sub=Js.subtract,Js.multiply=function(t){if(this.isZero())return Ws;if($s(t)||(t=Ls(t)),Is)return Ds(Is.mul(this.low,this.high,t.low,t.high),Is.get_high(),this.unsigned);if(t.isZero())return Ws;if(this.eq(Hs))return t.isOdd()?Hs:Ws;if(t.eq(Hs))return this.isOdd()?Hs:Ws;if(this.isNegative())return t.isNegative()?this.neg().mul(t.neg()):this.neg().mul(t).neg();if(t.isNegative())return this.mul(t.neg()).neg();if(this.lt(Ps)&&t.lt(Ps))return _s(this.toNumber()*t.toNumber(),this.unsigned);var e=this.high>>>16,n=65535&this.high,s=this.low>>>16,r=65535&this.low,i=t.high>>>16,a=65535&t.high,o=t.low>>>16,l=65535&t.low,u=0,h=0,c=0,p=0;return c+=(p+=r*l)>>>16,h+=(c+=s*l)>>>16,c&=65535,h+=(c+=r*o)>>>16,u+=(h+=n*l)>>>16,h&=65535,u+=(h+=s*o)>>>16,h&=65535,u+=(h+=r*a)>>>16,u+=e*l+n*o+s*a+r*i,Ds((c&=65535)<<16|(p&=65535),(u&=65535)<<16|(h&=65535),this.unsigned)},Js.mul=Js.multiply,Js.divide=function(t){if($s(t)||(t=Ls(t)),t.isZero())throw Error("division by zero");var e,n,s;if(Is)return this.unsigned||-2147483648!==this.high||-1!==t.low||-1!==t.high?Ds((this.unsigned?Is.div_u:Is.div_s)(this.low,this.high,t.low,t.high),Is.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Us:Ws;if(this.unsigned){if(t.unsigned||(t=t.toUnsigned()),t.gt(this))return Us;if(t.gt(this.shru(1)))return Vs;s=Us}else{if(this.eq(Hs))return t.eq(Ks)||t.eq(qs)?Hs:t.eq(Hs)?Ks:(e=this.shr(1).div(t).shl(1)).eq(Ws)?t.isNegative()?Ks:qs:(n=this.sub(t.mul(e)),s=e.add(n.div(t)));if(t.eq(Hs))return this.unsigned?Us:Ws;if(this.isNegative())return t.isNegative()?this.neg().div(t.neg()):this.neg().div(t).neg();if(t.isNegative())return this.div(t.neg()).neg();s=Ws}for(n=this;n.gte(t);){e=Math.max(1,Math.floor(n.toNumber()/t.toNumber()));for(var r=Math.ceil(Math.log(e)/Math.LN2),i=r<=48?1:Fs(2,r-48),a=_s(e),o=a.mul(t);o.isNegative()||o.gt(n);)o=(a=_s(e-=i,this.unsigned)).mul(t);a.isZero()&&(a=Ks),s=s.add(a),n=n.sub(o)}return s},Js.div=Js.divide,Js.modulo=function(t){return $s(t)||(t=Ls(t)),Is?Ds((this.unsigned?Is.rem_u:Is.rem_s)(this.low,this.high,t.low,t.high),Is.get_high(),this.unsigned):this.sub(this.div(t).mul(t))},Js.mod=Js.modulo,Js.rem=Js.modulo,Js.not=function(){return Ds(~this.low,~this.high,this.unsigned)},Js.and=function(t){return $s(t)||(t=Ls(t)),Ds(this.low&t.low,this.high&t.high,this.unsigned)},Js.or=function(t){return $s(t)||(t=Ls(t)),Ds(this.low|t.low,this.high|t.high,this.unsigned)},Js.xor=function(t){return $s(t)||(t=Ls(t)),Ds(this.low^t.low,this.high^t.high,this.unsigned)},Js.shiftLeft=function(t){return $s(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Ds(this.low<<t,this.high<<t|this.low>>>32-t,this.unsigned):Ds(0,this.low<<t-32,this.unsigned)},Js.shl=Js.shiftLeft,Js.shiftRight=function(t){return $s(t)&&(t=t.toInt()),0==(t&=63)?this:t<32?Ds(this.low>>>t|this.high<<32-t,this.high>>t,this.unsigned):Ds(this.high>>t-32,this.high>=0?0:-1,this.unsigned)},Js.shr=Js.shiftRight,Js.shiftRightUnsigned=function(t){if($s(t)&&(t=t.toInt()),0===(t&=63))return this;var e=this.high;return t<32?Ds(this.low>>>t|e<<32-t,e>>>t,this.unsigned):Ds(32===t?e:e>>>t-32,0,this.unsigned)},Js.shru=Js.shiftRightUnsigned,Js.shr_u=Js.shiftRightUnsigned,Js.toSigned=function(){return this.unsigned?Ds(this.low,this.high,!1):this},Js.toUnsigned=function(){return this.unsigned?this:Ds(this.low,this.high,!0)},Js.toBytes=function(t){return t?this.toBytesLE():this.toBytesBE()},Js.toBytesLE=function(){var t=this.high,e=this.low;return[255&e,e>>>8&255,e>>>16&255,e>>>24,255&t,t>>>8&255,t>>>16&255,t>>>24]},Js.toBytesBE=function(){var t=this.high,e=this.low;return[t>>>24,t>>>16&255,t>>>8&255,255&t,e>>>24,e>>>16&255,e>>>8&255,255&e]},As.fromBytes=function(t,e,n){return n?As.fromBytesLE(t,e):As.fromBytesBE(t,e)},As.fromBytesLE=function(t,e){return new As(t[0]|t[1]<<8|t[2]<<16|t[3]<<24,t[4]|t[5]<<8|t[6]<<16|t[7]<<24,e)},As.fromBytesBE=function(t,e){return new As(t[4]<<24|t[5]<<16|t[6]<<8|t[7],t[0]<<24|t[1]<<16|t[2]<<8|t[3],e)};const Zs=Es||Object.assign(Object.create(null),Es,{default:Es});function Ys(t){return Zs.fromString(t,!0,16)}function Xs(t,e){if("string"===e)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(t)&&(t=jn(t)),ds().getBool("DEBUG")&&function(t,e){for(let n=0;n<t.length;n++){const s=t[n];if(isNaN(s)||!isFinite(s))throw Error(`A tensor of type ${e} being uploaded contains ${s}.`)}}(t,e),function(t,e){return t instanceof Float32Array&&"float32"===e||t instanceof Int32Array&&"int32"===e||t instanceof Uint8Array&&"bool"===e}(t,e))return t;if(null==e||"float32"===e||"complex64"===e)return new Float32Array(t);if("int32"===e)return new Int32Array(t);if("bool"===e){const e=new Uint8Array(t.length);for(let n=0;n<e.length;++n)0!==Math.round(t[n])&&(e[n]=1);return e}throw new Error(`Unknown data type ${e}`)}function Qs(){return ds().platform.now()}function tr(t,e="utf-8"){return e=e||"utf-8",ds().platform.decode(t,e)}Ys("c3a5c85c97cb3127"),Ys("b492b66fbe98f273"),Ys("9ae16a3b2f90404f");class er{constructor(t,e){this.backendTimer=t,this.logger=e,null==e&&(this.logger=new sr)}profileKernel(t,e,n){let s;const r=()=>{s=n()};let i;const a=Qs();if(this.backendTimer.timerAvailable())i=this.backendTimer.time(r);else{r();for(const t of s)t.dataSync();i=Promise.resolve({kernelMs:Qs()-a})}if(ds().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let e=0;e<s.length;e++){const n=s[e];n.data().then((e=>{nr(e,n.dtype,t)}))}return{kernelName:t,outputs:s,inputs:e,timeMs:i.then((t=>t.kernelMs)),extraInfo:i.then((t=>null!=t.getExtraProfileInfo?t.getExtraProfileInfo():""))}}logKernelProfile(t){const{kernelName:e,outputs:n,timeMs:s,inputs:r,extraInfo:i}=t;n.forEach((t=>{Promise.all([t.data(),s,i]).then((n=>{this.logger.logKernelProfile(e,t,n[0],n[1],r,n[2])}))}))}}function nr(t,e,n){if("float32"!==e)return!1;for(let e=0;e<t.length;e++){const s=t[e];if(isNaN(s)||!isFinite(s))return console.warn(`Found ${s} in the result of '${n}'`),!0}return!1}class sr{logKernelProfile(t,e,n,s,r,i){const a="number"==typeof s?Zn(`${s}ms`,9):s.error,o=Zn(t,25),l=e.rank,u=e.size,h=Zn(e.shape.toString(),14);let c="";for(const t in r){const n=r[t];if(null!=n){const s=n.shape||e.shape,r=s.length;c+=`${t}: ${r}D ${r>0?s:""} `}}console.log(`%c${o}\t%c${a}\t%c${l}D ${h}\t%c${u}\t%c${c}\t%c${i}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function rr(t,e,n,s){const r=ss(e),i=function(t,e,n,s){const r=Gn(e),i=s[s.length-1],a=new Array(i).fill(0),o=e.length,l="complex64"===n?lr(t):t;if(o>1)for(let t=0;t<r/i;t++){const e=t*i;for(let t=0;t<i;t++)a[t]=Math.max(a[t],ir(l[e+t],0,n).length)}return a}(t,e,n,r),a=e.length,o=or(t,e,n,r,i),l=["Tensor"];return s&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${e}]`),l.push("  values:")),l.push(o.map((t=>"    "+t)).join("\n")),l.join("\n")}function ir(t,e,n){let s;return s=Array.isArray(t)?`${parseFloat(t[0].toFixed(7))} + ${parseFloat(t[1].toFixed(7))}j`:ts(t)?`'${t}'`:"bool"===n?ar(t):parseFloat(t.toFixed(7)).toString(),Zn(s,e)}function ar(t){return 0===t?"false":"true"}function or(t,e,n,s,r,i=!0){const a="complex64"===n?2:1,o=e[0],l=e.length;if(0===l){if("complex64"===n){return[ir(lr(t)[0],0,n)]}return"bool"===n?[ar(t[0])]:[t[0].toString()]}if(1===l){if(o>20){const e=3*a;let s=Array.from(t.slice(0,e)),i=Array.from(t.slice((o-3)*a,o*a));return"complex64"===n&&(s=lr(s),i=lr(i)),["["+s.map(((t,e)=>ir(t,r[e],n))).join(", ")+", ..., "+i.map(((t,e)=>ir(t,r[o-3+e],n))).join(", ")+"]"]}return["["+("complex64"===n?lr(t):Array.from(t)).map(((t,e)=>ir(t,r[e],n))).join(", ")+"]"]}const u=e.slice(1),h=s.slice(1),c=s[0]*a,p=[];if(o>20){for(let e=0;e<3;e++){const s=e*c,i=s+c;p.push(...or(t.slice(s,i),u,n,h,r,!1))}p.push("...");for(let e=o-3;e<o;e++){const s=e*c,i=s+c;p.push(...or(t.slice(s,i),u,n,h,r,e===o-1))}}else for(let e=0;e<o;e++){const s=e*c,i=s+c;p.push(...or(t.slice(s,i),u,n,h,r,e===o-1))}const d=2===l?",":"";p[0]="["+p[0]+d;for(let t=1;t<p.length-1;t++)p[t]=" "+p[t]+d;let f=",\n";for(let t=2;t<l;t++)f+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(i?"":f),p}function lr(t){const e=[];for(let n=0;n<t.length;n+=2)e.push([t[n],t[n+1]]);return e}class ur{constructor(t,e,n){if(this.dtype=e,this.shape=t.slice(),this.size=Gn(t),null!=n){const t=n.length;Kn(t===this.size,(()=>`Length of values '${t}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===e)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(t,e){let n=null;if(null==t||"float32"===t)n=new Float32Array(e);else if("int32"===t)n=new Int32Array(e);else if("bool"===t)n=new Uint8Array(e);else{if("string"!==t)throw new Error(`Unknown data type ${t}`);n=new Array(e)}return n}(e,this.size),this.strides=ss(t)}set(t,...e){0===e.length&&(e=[0]),Kn(e.length===this.rank,(()=>`The number of provided coordinates (${e.length}) must match the rank (${this.rank})`));const n=this.locToIndex(e);this.values[n]=t}get(...t){0===t.length&&(t=[0]);let e=0;for(const n of t){if(n<0||n>=this.shape[e]){const e=`Requested out of range element at ${t}.   Buffer shape=${this.shape}`;throw new Error(e)}e++}let n=t[t.length-1];for(let e=0;e<t.length-1;++e)n+=this.strides[e]*t[e];return this.values[n]}locToIndex(t){if(0===this.rank)return 0;if(1===this.rank)return t[0];let e=t[t.length-1];for(let n=0;n<t.length-1;++n)e+=this.strides[n]*t[n];return e}indexToLoc(t){if(0===this.rank)return[];if(1===this.rank)return[t];const e=new Array(this.shape.length);for(let n=0;n<e.length-1;++n)e[n]=Math.floor(t/this.strides[n]),t-=e[n]*this.strides[n];return e[e.length-1]=t,e}get rank(){return this.shape.length}toTensor(){return hr().makeTensor(this.values,this.shape,this.dtype)}}let hr=null,cr=null;class pr{constructor(t,e,n,s){this.kept=!1,this.isDisposedInternal=!1,this.shape=t.slice(),this.dtype=e||"float32",this.size=Gn(t),this.strides=ss(t),this.dataId=n,this.id=s,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const t=await this.data();return cr.buffer(this.shape,this.dtype,t)}bufferSync(){return cr.buffer(this.shape,this.dtype,this.dataSync())}async array(){const t=await this.data();return is(this.shape,t,"complex64"===this.dtype)}arraySync(){return is(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const t=hr().read(this.dataId);if("string"===this.dtype){const e=await t;try{return e.map((t=>tr(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return t}dataToGPU(t){return this.throwIfDisposed(),hr().readToGPU(this.dataId,t)}dataSync(){this.throwIfDisposed();const t=hr().readSync(this.dataId);if("string"===this.dtype)try{return t.map((t=>tr(t)))}catch(t){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return t}async bytes(){this.throwIfDisposed();const t=await hr().read(this.dataId);return"string"===this.dtype?t:new Uint8Array(t.buffer)}dispose(){this.isDisposed||(hr().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(t=!1){return cr.print(this,t)}clone(){return this.throwIfDisposed(),cr.clone(this)}toString(t=!1){return rr(this.dataSync(),this.shape,this.dtype,t)}cast(t){return this.throwIfDisposed(),cr.cast(this,t)}variable(t=!0,e,n){return this.throwIfDisposed(),hr().makeVariable(this,t,e,n)}}Object.defineProperty(pr,Symbol.hasInstance,{value:t=>!!t&&null!=t.data&&null!=t.dataSync&&null!=t.throwIfDisposed}),bs("Tensor",(()=>pr));class dr extends pr{constructor(t,e,n,s){super(t.shape,t.dtype,t.dataId,s),this.trainable=e,this.name=n}assign(t){if(t.dtype!==this.dtype)throw new Error(`dtype of the new value (${t.dtype}) and previous value (${this.dtype}) must match`);if(!Hn(t.shape,this.shape))throw new Error(`shape of the new value (${t.shape}) and previous value (${this.shape}) must match`);hr().disposeTensor(this),this.dataId=t.dataId,hr().incRef(this,null)}dispose(){hr().disposeVariable(this),this.isDisposedInternal=!0}}var fr,gr,mr,br,yr;Object.defineProperty(dr,Symbol.hasInstance,{value:t=>t instanceof pr&&null!=t.assign&&t.assign instanceof Function}),function(t){t.R0="R0",t.R1="R1",t.R2="R2",t.R3="R3",t.R4="R4",t.R5="R5",t.R6="R6"}(fr||(fr={})),function(t){t.float32="float32",t.int32="int32",t.bool="int32",t.complex64="complex64"}(gr||(gr={})),function(t){t.float32="float32",t.int32="int32",t.bool="bool",t.complex64="complex64"}(mr||(mr={})),function(t){t.float32="float32",t.int32="float32",t.bool="float32",t.complex64="complex64"}(br||(br={})),function(t){t.float32="complex64",t.int32="complex64",t.bool="complex64",t.complex64="complex64"}(yr||(yr={}));const wr={float32:br,int32:gr,bool:mr,complex64:yr};function kr(t,e){if(t.dtype===e.dtype)return[t,e];const n=function(t,e){if("string"===t||"string"===e){if("string"===t&&"string"===e)return"string";throw new Error(`Can not upcast ${t} with ${e}`)}return wr[t][e]}(t.dtype,e.dtype);return[t.cast(n),e.cast(n)]}function vr(t){const e=[];return xr(t,e,new Set),e}function xr(t,e,n){if(null==t)return;if(t instanceof pr)return void e.push(t);if(s=t,!Array.isArray(s)&&"object"!=typeof s)return;var s;const r=t;for(const t in r){const s=r[t];n.has(s)||(n.add(s),xr(s,e,n))}}function Sr(t){return null!=t.kernelName}class Nr{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((t=>t.name))))}}}dispose(){for(const t in this.registeredVariables)this.registeredVariables[t].dispose()}}class Er{constructor(t){this.ENV=t,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Nr}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:t,asyncInit:e}=this.initializeBackendsAndReturnBest();if(e)throw new Error(`The highest priority backend '${t}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(t)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(t){if(!(t in this.registry)){if(!(t in this.registryFactory))return null;{const{asyncInit:e}=this.initializeBackend(t);if(e)return null}}return this.registry[t]}findBackendFactory(t){return t in this.registryFactory?this.registryFactory[t].factory:null}registerBackend(t,e,n=1){return t in this.registryFactory?(ys(`${t} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[t]={factory:e,priority:n},!0)}async setBackend(t){if(null==this.registryFactory[t])throw new Error(`Backend name '${t}' not found in registry`);if(this.backendName=t,null==this.registry[t]){this.backendInstance=null;const{success:e,asyncInit:n}=this.initializeBackend(t);if(!(n?await e:e))return!1}return this.backendInstance=this.registry[t],this.setupRegisteredKernels(),this.profiler=new er(this.backendInstance),!0}setupRegisteredKernels(){Ss(this.backendName).forEach((t=>{null!=t.setupFunc&&t.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(t){Ss(t).forEach((e=>{null!=e.disposeFunc&&e.disposeFunc(this.registry[t])}))}initializeBackend(t){const e=this.registryFactory[t];if(null==e)throw new Error(`Cannot initialize backend ${t}, no registration found.`);try{const n=e.factory();if(!n||n instanceof class{refCount(t){return Un("refCount")}incRef(t){return Un("incRef")}timerAvailable(){return!0}time(t){return Un("time")}read(t){return Un("read")}readSync(t){return Un("readSync")}readToGPU(t,e){return Un("readToGPU")}numDataIds(){return Un("numDataIds")}disposeData(t,e){return Un("disposeData")}write(t,e,n){return Un("write")}move(t,e,n,s,r){return Un("move")}memory(){return Un("memory")}floatPrecision(){return Un("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return Un("dispose")}}||"function"!=typeof n.then)return this.registry[t]=n,{success:!0,asyncInit:!1};{const e=++this.pendingBackendInitId,s=n.then((n=>!(e<this.pendingBackendInitId)&&(this.registry[t]=n,this.pendingBackendInit=null,!0))).catch((n=>(e<this.pendingBackendInitId||(this.pendingBackendInit=null,ys(`Initialization of backend ${t} failed`),ys(n.stack||n.message)),!1)));return this.pendingBackendInit=s,{success:s,asyncInit:!0}}}catch(e){return ys(`Initialization of backend ${t} failed`),ys(e.stack||e.message),{success:!1,asyncInit:!1}}}removeBackend(t){if(!(t in this.registryFactory))throw new Error(`${t} backend not found in registry`);this.backendName===t&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,t in this.registry&&(this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t]),delete this.registryFactory[t],this.backendName===t&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((t,e)=>this.registryFactory[e].priority-this.registryFactory[t].priority))}initializeBackendsAndReturnBest(){const t=this.getSortedBackends();for(let e=0;e<t.length;e++){const n=t[e],{success:s,asyncInit:r}=this.initializeBackend(n);if(r||s)return{name:n,asyncInit:r}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(t,e){const n=this.state.tensorInfo.get(e),s=n.backend,r=this.readSync(e),i=s.refCount(e);s.disposeData(e,!0),n.backend=t,t.move(e,r,n.shape,n.dtype,i),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(t,e){let n,s=null;if(null==e){if("function"!=typeof t)throw new Error("Please provide a function to tidy()");e=t}else{if("string"!=typeof t&&!(t instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof e)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");s=t}return this.scopedRun((()=>this.startScope(s)),(()=>this.endScope(n)),(()=>(n=e(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(t,e,n){t();try{const t=n();return e(),t}catch(t){throw e(),t}}nextTensorId(){return Er.nextTensorId++}nextVariableId(){return Er.nextVariableId++}clone(t){const e=Ir.runKernel(Ve,{x:t}),n={x:t};return this.addTapeNode(this.state.activeScope.name,n,[e],(t=>({x:()=>{const e={x:t},n={dtype:"float32"};return Ir.runKernel(Ne,e,n)}})),[],{}),e}runKernel(t,e,n){null==this.backendName&&this.backend;if(!(null!=vs(t,this.backendName)))throw new Error(`Kernel '${t}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:t,inputs:e,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(t,e,n){const s=this.backend.numDataIds();let r=0;n.forEach((t=>{r+="complex64"===t.dtype?3:1}));const i=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=s-e-r-i;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${t}'`)}runKernelFunc(t){let e,n=[];const s=this.isTapeOn(),r=this.state.numBytes,i=this.state.numTensors;let a,o;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const l=Sr(t)?t.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Sr(t)){const{kernelName:e,inputs:r,attrs:i}=t;null==this.backendName&&this.backend;const l=vs(e,this.backendName);Kn(null!=l,(()=>`Cannot find registered kernel '${e}' for backend '${this.backendName}'`)),a=()=>{const t=this.backend.numDataIds();o=l.kernelFunc({inputs:r,attrs:i,backend:this.backend});const a=Array.isArray(o)?o:[o];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(e,t,a);const u=a.map((t=>null!=t.rank?t:this.makeTensorFromTensorInfo(t)));if(s){const t=this.getTensorsForGradient(e,r,u);n=this.saveTensorsForBackwardMode(t)}return u}}else{const{forwardFunc:e}=t,r=t=>{s&&(n=t.map((t=>this.keep(this.clone(t)))))};a=()=>{const t=this.backend.numDataIds();o=this.tidy((()=>e(this.backend,r)));const n=Array.isArray(o)?o:[o];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(l,t,n),n}}const{inputs:u,attrs:h}=t,c=Sr(t)?null:t.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(l,u,(()=>a())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),e=p.outputs):e=a()})),s&&this.addTapeNode(l,u,e,c,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:l,bytesAdded:this.state.numBytes-r,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-i,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(u).map((t=>null!=u[t]?u[t].shape:null)),outputShapes:e.map((t=>t.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(o)?e:e[0]}saveTensorsForBackwardMode(t){const e=t.map((t=>this.keep(this.clone(t))));return e}getTensorsForGradient(t,e,n){const s=xs(t);if(null!=s){const t=s.inputsToSave||[],r=s.outputsToSave||[];let i;s.saveAllInputs?(Kn(Array.isArray(e),(()=>"saveAllInputs is true, expected inputs to be an array.")),i=Object.keys(e).map((t=>e[t]))):i=t.map((t=>e[t]));const a=n.filter(((t,e)=>r[e]));return i.concat(a)}return[]}makeTensor(t,e,n,s){if(null==t)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",s=s||this.backend;let r=t;"string"===n&&ts(t[0])&&(r=t.map((t=>function(t,e="utf-8"){return e=e||"utf-8",ds().platform.encode(t,e)}(t))));const i=s.write(r,e,n),a=new pr(e,n,i,this.nextTensorId());if(this.trackTensor(a,s),"string"===n){const t=this.state.tensorInfo.get(i),e=function(t){if(null==t)return 0;let e=0;return t.forEach((t=>e+=t.length)),e}(r);this.state.numBytes+=e-t.bytes,t.bytes=e}return a}makeTensorFromDataId(t,e,n,s){const r={dataId:t,shape:e,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(r,s)}makeTensorFromTensorInfo(t,e){const{dataId:n,shape:s,dtype:r}=t,i=new pr(s,r,n,this.nextTensorId());return this.trackTensor(i,e),i}makeVariable(t,e=!0,n,s){n=n||this.nextVariableId().toString(),null!=s&&s!==t.dtype&&(t=t.cast(s));const r=new dr(t,e,n,this.nextTensorId());if(null!=this.state.registeredVariables[r.name])throw new Error(`Variable with name ${r.name} was already registered`);return this.state.registeredVariables[r.name]=r,this.incRef(r,this.backend),r}trackTensor(t,e){this.state.numTensors++,"string"===t.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==t.dtype&&"string"!==t.dtype&&(n=t.size*Qn(t.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(t.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(t.dataId,{backend:e||this.backend,dtype:t.dtype,shape:t.shape,bytes:n})),t instanceof dr||this.track(t)}incRef(t,e){this.trackTensor(t,e),this.backend.incRef(t.dataId)}removeDataId(t,e){this.state.tensorInfo.has(t)&&this.state.tensorInfo.get(t).backend===e&&(this.state.tensorInfo.delete(t),this.state.numDataBuffers--)}disposeTensor(t){if(!this.state.tensorInfo.has(t.dataId))return;const e=this.state.tensorInfo.get(t.dataId);if(this.state.numTensors--,"string"===t.dtype&&(this.state.numStringTensors--,this.state.numBytes-=e.bytes),"complex64"!==t.dtype&&"string"!==t.dtype){const e=t.size*Qn(t.dtype);this.state.numBytes-=e}e.backend.disposeData(t.dataId)&&this.removeDataId(t.dataId,e.backend)}disposeVariables(){for(const t in this.state.registeredVariables){const e=this.state.registeredVariables[t];this.disposeVariable(e)}}disposeVariable(t){this.disposeTensor(t),null!=this.state.registeredVariables[t.name]&&delete this.state.registeredVariables[t.name]}memory(){const t=this.backend.memory();return t.numTensors=this.state.numTensors,t.numDataBuffers=this.state.numDataBuffers,t.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(t.unreliable=!0,null==t.reasons&&(t.reasons=[]),t.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),t}async profile(t){this.state.profiling=!0;const e=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await t(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((t=>t.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-e,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const t of this.state.activeProfile.kernels)t.kernelTimeMs=await t.kernelTimeMs,t.extraInfo=await t.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(t,e,n,s,r,i){const a={id:this.state.nextTapeNodeId++,kernelName:t,inputs:e,outputs:n,saved:r},o=xs(t);null!=o&&(s=o.gradFunc),null!=s&&(a.gradient=t=>(t=t.map(((t,e)=>{if(null==t){const t=n[e],s=os(t.size,t.dtype);return this.makeTensor(s,t.shape,t.dtype)}return t})),s(t.length>1?t:t[0],r,i))),this.state.activeTape.push(a)}keep(t){return t.kept=!0,t}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(t){const e={track:[],name:"unnamed scope",id:this.state.nextScopeId++};t&&(e.name=t),this.state.scopeStack.push(e),this.state.activeScope=e}endScope(t){const e=vr(t),n=new Set(e.map((t=>t.id)));for(let t=0;t<this.state.activeScope.track.length;t++){const e=this.state.activeScope.track[t];e.kept||n.has(e.id)||e.dispose()}const s=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],e.forEach((t=>{t.kept||t.scopeId!==s.id||this.track(t)}))}gradients(t,e,n,s=!1){if(Kn(e.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const r=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",t)));Kn(r instanceof pr,(()=>"The result y returned by f() must be a tensor."));const i=function(t,e,n){const s={},r={};for(let t=0;t<e.length;t++)s[e[t].id]=!0;for(let n=0;n<t.length;n++){const i=t[n],a=i.inputs;for(const t in a){const n=a[t];let o=!1;for(let t=0;t<e.length;t++)if(s[n.id]){i.outputs.forEach((t=>s[t.id]=!0)),o=!0,r[i.id]=!0;break}if(o)break}}const i={};i[n.id]=!0;const a={};for(let e=t.length-1;e>=0;e--){const n=t[e],s=n.inputs;for(let t=0;t<n.outputs.length;t++)if(i[n.outputs[t].id]){for(const t in s)i[s[t].id]=!0,a[n.id]=!0;break}}const o=[];for(let e=0;e<t.length;e++){const n=t[e];if(r[n.id]&&a[n.id]){const t={};for(const e in n.inputs){const r=n.inputs[e];s[r.id]&&(t[e]=r)}const e=Object.assign({},n);e.inputs=t,e.outputs=n.outputs,o.push(e)}}return o}(this.state.activeTape,e,r);if(!s&&0===i.length&&e.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const t={};t[r.id]=null==n?function(t){const e=as(Gn(t),"float32");return Ir.makeTensor(e,t,"float32")}(r.shape):n,function(t,e,n,s){for(let r=e.length-1;r>=0;r--){const i=e[r],a=[];if(i.outputs.forEach((e=>{const n=t[e.id];null!=n?a.push(n):a.push(null)})),null==i.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${i.kernelName}.`);const o=i.gradient(a);for(const e in i.inputs){if(!(e in o))throw new Error(`Cannot backprop through input ${e}. Available gradients found: ${Object.keys(o)}.`);const r=n((()=>o[e]()));if("float32"!==r.dtype)throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input ${e} must have 'float32' dtype, but has '${r.dtype}'`);const a=i.inputs[e];if(!Hn(r.shape,a.shape))throw new Error(`Error in gradient for op ${i.kernelName}. The gradient of input '${e}' has shape '${r.shape}', which does not match the shape of the input '${a.shape}'`);if(null==t[a.id])t[a.id]=r;else{const e=t[a.id];t[a.id]=s(e,r),e.dispose()}}}}(t,i,(t=>this.tidy(t)),Ar);const s=e.map((e=>t[e.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((t=>{for(const e of t.saved)e.dispose()})),this.state.activeTape=null),{value:r,grads:s}}))}customGrad(t){return Kn(ns(t),(()=>"The f passed in customGrad(f) must be a function.")),(...e)=>{let n;Kn(e.every((t=>t instanceof pr)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const s={};e.forEach(((t,e)=>{s[e]=t}));return this.runKernelFunc({forwardFunc:(s,r)=>(n=t(...e,r),Kn(n.value instanceof pr,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),Kn(ns(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(t,s)=>{const r=n.gradFunc(t,s),i=Array.isArray(r)?r:[r];Kn(i.length===e.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),Kn(i.every((t=>t instanceof pr)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const a={};return i.forEach(((t,e)=>{a[e]=()=>t})),a},inputs:s})}}readSync(t){return this.state.tensorInfo.get(t).backend.readSync(t)}read(t){return this.state.tensorInfo.get(t).backend.read(t)}readToGPU(t,e){return this.state.tensorInfo.get(t).backend.readToGPU(t,e)}async time(t){const e=Qs(),n=await this.backend.time(t);return n.wallMs=Qs()-e,n}track(t){return null!=this.state.activeScope&&(t.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(t)),t}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Nr;for(const t in this.registry)this.disposeRegisteredKernels(t),this.registry[t].dispose(),delete this.registry[t];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}Er.nextTensorId=0,Er.nextVariableId=0;const Ir=function(){const t=ms();if(null==t._tfengine){const e=new cs(t);t._tfengine=new Er(e)}var e;return e=t._tfengine.ENV,gs=e,hr=()=>t._tfengine,t._tfengine}();function Ar(t,e){const n={a:t,b:e};return Ir.runKernel(ce,n)}function $r(t,e){let n=t;if(Xn(t))return"string"===e?[]:[t.length];if(!Array.isArray(t))return[];const s=[];for(;Array.isArray(n)||Xn(n)&&"string"!==e;)s.push(n.length),n=n[0];return Array.isArray(t)&&ds().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&zr(t,s,[]),s}function zr(t,e,n){if(n=n||[],!Array.isArray(t)&&!Xn(t))return void Kn(0===e.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${e[0]} elements`));Kn(e.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${t.length} elements`)),Kn(t.length===e[0],(()=>`Element arr[${n.join("][")}] should have ${e[0]} elements, but has ${t.length} elements`));const s=e.slice(1);for(let e=0;e<t.length;++e)zr(t[e],s,n.concat(e))}function Cr(t,e,n,s){if("string_or_numeric"!==t){if(null==t)throw new Error("Expected dtype cannot be null.");if("numeric"!==t&&t!==e||"numeric"===t&&"string"===e)throw new Error(`Argument '${n}' passed to '${s}' must be ${t} tensor, but got ${e} tensor`)}}function Tr(t,e,n,s="numeric"){if(t instanceof pr)return Cr(s,t.dtype,e,n),t;let r=es(t);if("string"!==r&&["bool","int32","float32"].indexOf(s)>=0&&(r=s),Cr(s,r,e,n),null==t||!Xn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t){const s=null==t?"null":t.constructor.name;throw new Error(`Argument '${e}' passed to '${n}' must be a Tensor or TensorLike, but got '${s}'`)}const i=$r(t,r);Xn(t)||Array.isArray(t)||(t=[t]);const a="string"!==r?Xs(t,r):jn(t,[],!0);return Ir.makeTensor(a,i,r)}function _r(t,e,n,s="numeric"){if(!Array.isArray(t))throw new Error(`Argument ${e} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return t.map(((t,r)=>Tr(t,`${e}[${r}]`,n,s)))}function Dr(t){const e=Object.keys(t);if(1!==e.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${e.length} keys.`);let n=e[0];const s=t[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const r=(...t)=>{Ir.startScope(n);try{const e=s(...t);return us(e)&&console.error("Cannot return a Promise inside of tidy."),Ir.endScope(e),e}catch(t){throw Ir.endScope(null),t}};return Object.defineProperty(r,"name",{value:n,configurable:!0}),r}const Fr=Dr({cast_:function(t,e){const n=Tr(t,"x","cast");if(!function(t){return"bool"===t||"complex64"===t||"float32"===t||"int32"===t||"string"===t}(e))throw new Error(`Failed to cast to unknown dtype ${e}`);if("string"===e&&"string"!==n.dtype||"string"!==e&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const s={x:n},r={dtype:e};return Ir.runKernel(Ne,s,r)}});const Mr=Dr({mul_:function(t,e){let n=Tr(t,"a","mul"),s=Tr(e,"b","mul");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel(nn,r)}});const Lr=Dr({step_:function(t,e=0){const n={x:Tr(t,"x","step")},s={alpha:e};return Ir.runKernel(Rn,n,s)}}),Rr={kernelName:"Abs",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Lr(Fr(n,"float32"),-1))}}};const Or=Dr({floorDiv_:function(t,e){let n=Tr(t,"a","floorDiv"),s=Tr(e,"b","floorDiv");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel(Pe,r)}});const Br=Dr({div_:function(t,e){let n=Tr(t,"a","div"),s=Tr(e,"b","div");if([n,s]=kr(n,s),"int32"===n.dtype&&"int32"===s.dtype)return Or(n,s);const r={a:n,b:s};return Ir.runKernel(Le,r,{})}});const Pr=Dr({neg_:function(t){const e={x:Tr(t,"x","neg")};return Ir.runKernel("Neg",e)}});function Wr(t,e,n,s){if(null==s&&(s=es(t)),"complex64"===s)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!Xn(t)&&!Array.isArray(t)&&"number"!=typeof t&&"boolean"!=typeof t&&"string"!=typeof t)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=e){ls(e);const t=Gn(e),s=Gn(n);Kn(t===s,(()=>`Based on the provided shape, [${e}], the tensor should have ${t} values but has ${s}`));for(let t=0;t<n.length;++t){const s=n[t],r=t!==n.length-1||s!==Gn(e.slice(t));Kn(n[t]===e[t]||!r,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${e}). `))}}return Xn(t)||Array.isArray(t)||(t=[t]),e=e||n,t="string"!==s?Xs(t,s):jn(t,[],!0),Ir.makeTensor(t,e,s)}function Ur(t,e){if((Xn(t)&&"string"!==e||Array.isArray(t))&&"complex64"!==e)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===e&&Xn(t)&&!(t instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Wr(t,[],[],e)}const Kr=Dr({sqrt_:function(t){const e={x:Tr(t,"x","sqrt","float32")};return Ir.runKernel(In,e)}});const Vr=Dr({square_:function(t){const e=Tr(t,"x","square");return Ir.runKernel("Square",{x:e},{})}});const qr=Dr({sub_:function(t,e){let n=Tr(t,"a","sub"),s=Tr(e,"b","sub");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel("Sub",r)}}),jr={kernelName:ue,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Vr(Fr(n,"float32")),s=Kr(qr(Ur(1),e));return Pr(Br(t,s))}}}},Gr={kernelName:he,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Kr(qr(Vr(Fr(n,"float32")),1));return Br(t,e)}}}};function Hr(t,e){const n=[];for(let s=0;s<e.length;s++){const r=t[t.length-s-1],i=e.length-s-1,a=e[i];(null==r||1===r&&a>1)&&n.unshift(i)}return n}function Jr(t,e){const n=[],s=Math.max(t.length,e.length);for(let r=0;r<s;r++){let s=t[t.length-r-1];null==s&&(s=1);let i=e[e.length-r-1];if(null==i&&(i=1),1===s)n.unshift(i);else if(1===i)n.unshift(s);else{if(s!==i){throw Error(`Operands could not be broadcast together with shapes ${t} and ${e}.`)}n.unshift(s)}}return n}const Zr=Dr({reshape_:function(t,e){const n={x:Tr(t,"x","reshape","string_or_numeric")},s={shape:e};return Ir.runKernel(pn,n,s)}});const Yr=Dr({sum_:function(t,e=null,n=!1){let s=Tr(t,"x","sum");"bool"===s.dtype&&(s=Fr(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ir.runKernel("Sum",r,i)}}),Xr={kernelName:ce,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{let e=t;const s=Hr(n.shape,r);return s.length>0&&(e=Yr(e,s)),Zr(e,n.shape)},b:()=>{let e=t;const n=Hr(s.shape,r);return n.length>0&&(e=Yr(e,n)),Zr(e,s.shape)}}}},Qr={kernelName:pe,saveAllInputs:!0,gradFunc:(t,e)=>{const n={};return e.forEach(((e,s)=>{n[s]=()=>t.clone()})),n}};const ti=Dr({zerosLike_:function(t){const e={x:Tr(t,"x","zerosLike")};return Ir.runKernel(Ln,e)}}),ei={kernelName:de,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>ti(n)}}},ni={kernelName:fe,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>ti(n)}}},si={kernelName:ge,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,Kr(qr(Ur(1),Vr(Fr(n,"float32")))))}}};const ri=Dr({add_:function(t,e){let n=Tr(t,"a","add"),s=Tr(e,"b","add");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel(ce,r)}}),ii={kernelName:me,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Kr(ri(Ur(1),Vr(Fr(n,"float32"))));return Br(t,e)}}}},ai={kernelName:we,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{const e=ri(Vr(n),Vr(s));let i=Mr(t,Br(s,e));const a=Hr(n.shape,r);return a.length>0&&(i=Yr(i,a)),Zr(i,n.shape)},b:()=>{const e=ri(Vr(n),Vr(s));let i=Pr(Mr(t,Br(n,e)));const a=Hr(s.shape,r);return a.length>0&&(i=Yr(i,a)),Zr(i,s.shape)}}}},oi={kernelName:be,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,ri(Vr(Fr(n,"float32")),1))}}},li={kernelName:ye,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,qr(Ur(1),Vr(Fr(n,"float32"))))}}};function ui(t,e,n,s,r,i,a=!1,o="channelsLast"){let[l,u,h,c]=[-1,-1,-1,-1];if("channelsLast"===o)[l,u,h,c]=t;else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);[l,c,u,h]=t}const[p,d,,f]=e,[g,m]=hi(n),[b,y]=hi(s),w=ci(p,b),k=ci(d,y),{padInfo:v,outHeight:x,outWidth:S}=function(t,e,n,s,r,i,a,o,l){let u,h,c;if("number"==typeof t){u={top:t,bottom:t,left:t,right:t,type:0===t?"VALID":"NUMBER"};const r=function(t,e,n,s,r){null==s&&(s=function(t,e,n,s=1){const r=ci(e,s);return Math.floor((t[0]*(n-1)-n+r)/2)}(t,e,n));const i=t[0],a=t[1],o=pi((i-e+2*s)/n+1,r),l=pi((a-e+2*s)/n+1,r);return[o,l]}([e,n],i,s,t,o);h=r[0],c=r[1]}else if("same"===t){h=Math.ceil(e/s),c=Math.ceil(n/r);const t=Math.max(0,(h-1)*s+i-e),o=Math.max(0,(c-1)*r+a-n),l=Math.floor(t/2),p=t-l,d=Math.floor(o/2);u={top:l,bottom:p,left:d,right:o-d,type:"SAME"}}else if("valid"===t)u={top:0,bottom:0,left:0,right:0,type:"VALID"},h=Math.ceil((e-i+1)/s),c=Math.ceil((n-a+1)/r);else{if("object"!=typeof t)throw Error(`Unknown padding parameter: ${t}`);{const p="channelsLast"===l?t[1][0]:t[2][0],d="channelsLast"===l?t[1][1]:t[2][1],f="channelsLast"===l?t[2][0]:t[3][0],g="channelsLast"===l?t[2][1]:t[3][1];u={top:p,bottom:d,left:f,right:g,type:0===p&&0===d&&0===f&&0===g?"VALID":"EXPLICIT"},h=pi((e-i+p+d)/s+1,o),c=pi((n-a+f+g)/r+1,o)}}return{padInfo:u,outHeight:h,outWidth:c}}(r,u,h,g,m,w,k,i,o),N=a?f*c:f;let E;return"channelsFirst"===o?E=[l,N,x,S]:"channelsLast"===o&&(E=[l,x,S,N]),{batchSize:l,dataFormat:o,inHeight:u,inWidth:h,inChannels:c,outHeight:x,outWidth:S,outChannels:N,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:p,filterWidth:d,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:t,outShape:E,filterShape:e}}function hi(t){return"number"==typeof t?[t,t,t]:2===t.length?[t[0],t[1],1]:t}function ci(t,e){return e<=1?t:t+(t-1)*(e-1)}function pi(t,e){if(!e)return Math.trunc(t);switch(e){case"round":return Math.round(t);case"ceil":return Math.ceil(t);case"floor":return Math.floor(t);default:throw new Error(`Unknown roundingMode ${e}`)}}function di(t){const[e,n,s]=hi(t);return 1===e&&1===n&&1===s}function fi(t,e){return di(t)||di(e)}function gi(t,e,n){if(null!=n){if("string"==typeof e)throw Error(`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`);if("number"==typeof e)Kn(Jn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`));else{if("object"!=typeof e)throw Error(`Error in ${t}: Unknown padding parameter: ${e}`);e.forEach((e=>{e.forEach((e=>{Kn(Jn(e),(()=>`Error in ${t}: pad must be an integer when using dimRoundingMode ${n} but got pad ${e}.`))}))}))}}}const mi=Dr({avgPool3dGrad_:function(t,e,n,s,r,i){const a=Tr(t,"dy","avgPool3dGrad"),o=Tr(e,"input","avgPool3dGrad");let l=a,u=o,h=!1;4===o.rank&&(h=!0,l=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]]),u=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),Kn(5===l.rank,(()=>`Error in avgPool3dGrad: dy must be rank 5 but got rank ${l.rank}.`)),Kn(5===u.rank,(()=>`Error in avgPool3dGrad: input must be rank 5 but got rank ${u.rank}.`)),gi("avgPool3dGrad",r,i);const c={dy:l,input:u},p={filterSize:n,strides:s,pad:r,dimRoundingMode:i},d=Ir.runKernel("AvgPool3DGrad",c,p);return h?Zr(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}}),bi={kernelName:ve,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a,dimRoundingMode:o}=n;return{x:()=>mi(t,s,r,i,a,o)}}};const yi=Dr({avgPoolGrad_:function(t,e,n,s,r){const i=Tr(t,"dy","avgPoolGrad"),a=Tr(e,"input","avgPoolGrad");Kn(a.rank===i.rank,(()=>`Rank of input (${a.rank}) does not match rank of dy (${i.rank})`));let o=a,l=i,u=!1;3===a.rank&&(u=!0,o=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),l=Zr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===l.rank,(()=>`Error in avgPoolGrad: dy must be rank 4 but got rank ${l.rank}.`)),Kn(4===o.rank,(()=>`Error in avgPoolGrad: input must be rank 4 but got rank ${o.rank}.`));const h={dy:l,input:o},c={filterSize:n,strides:s,pad:r},p=Ir.runKernel("AvgPoolGrad",h,c);return u?Zr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),wi={kernelName:ke,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{filterSize:r,strides:i,pad:a}=n;return{x:()=>yi(t,s,r,i,a)}}};const ki=Dr({matMul_:function(t,e,n=!1,s=!1){let r=Tr(t,"a","matMul"),i=Tr(e,"b","matMul");[r,i]=kr(r,i);const a={a:r,b:i},o={transposeA:n,transposeB:s};return Ir.runKernel(xe,a,o)}}),vi={kernelName:xe,inputsToSave:["a","b"],gradFunc:(t,e,n)=>{const[s,r]=e,{transposeA:i,transposeB:a}=n;return i||a?!i&&a?{a:()=>ki(t,r,!1,!1),b:()=>ki(t,s,!0,!1)}:i&&!a?{a:()=>ki(r,t,!1,!0),b:()=>ki(s,t,!1,!1)}:{a:()=>ki(r,t,!0,!0),b:()=>ki(t,s,!0,!0)}:{a:()=>ki(t,r,!1,!0),b:()=>ki(s,t,!0,!1)}}};const xi=Dr({spaceToBatchND_:function(t,e,n){const s=Tr(t,"x","spaceToBatchND");Kn(s.rank>=1+e.length,(()=>`input rank ${s.rank} should be > than [blockShape] ${e.length}`)),Kn(n.length===e.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${e.length}`)),Kn(s.shape.reduce(((t,s,r)=>r>0&&r<=e.length?t&&(s+n[r-1][0]+n[r-1][1])%e[r-1]==0:t),!0),(()=>`input spatial dimensions ${s.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${e.toString()}`));const r={x:s},i={blockShape:e,paddings:n};return Ir.runKernel(An,r,i)}}),Si={kernelName:Se,gradFunc:(t,e,n)=>{const{blockShape:s,crops:r}=n;return{x:()=>xi(t,s,r)}}},Ni={kernelName:"BroadcastTo",gradFunc:(t,e,n)=>{const s=n,r=s.inputShape,i=s.shape,a=Array.from(i);for(let t=r.length-1;t>=0;t--)if(r[t]===i[t])a[t]=1;else if(1!==r[t])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${i}].`);const o=[];for(let t=0;t<a.length;t++)a[t]>1&&o.push(t);return{x:()=>Yr(t,o,!0)}}},Ei={kernelName:Ne,gradFunc:t=>({x:()=>t.clone()})},Ii={kernelName:Ee,gradFunc:t=>({x:()=>ti(t)})};const Ai=Dr({greaterEqual_:function(t,e){let n=Tr(t,"a","greaterEqual","string_or_numeric"),s=Tr(e,"b","greaterEqual","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel(Ke,r)}});const $i=Dr({lessEqual_:function(t,e){let n=Tr(t,"a","lessEqual","string_or_numeric"),s=Tr(e,"b","lessEqual","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("LessEqual",r)}});const zi=Dr({logicalAnd_:function(t,e){const n=Tr(t,"a","logicalAnd","bool"),s=Tr(e,"b","logicalAnd","bool");Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("LogicalAnd",r)}});const Ci=Dr({clone_:function(t){const e={x:Tr(t,"x","clone","string_or_numeric")};return Ir.runKernel(Ve,e)}});const Ti=Dr({broadcastTo_:function(t,e){let n=Tr(t,"broadcastTo","x");const s=n.shape;if(e.some((t=>!(t>0)||t%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${e}].`);if(e.length<n.rank)throw new Error(`broadcastTo(): shape.length=${e.length} < input.rank=${n.rank}.`);if(e.length>n.rank){const t=n.shape.slice();for(;t.length<e.length;)t.unshift(1);n=Zr(n,t)}const r=n.shape,i=Array.from(e);for(let t=e.length-1;t>=0;t--)if(r[t]===e[t])i[t]=1;else if(1!==n.shape[t])throw new Error(`broadcastTo(): [${s}] cannot be broadcast to [${e}].`);if(0===i.map(((t,e)=>t>1?e:-1)).filter((t=>t>=0)).length)return Ci(n);const a={x:n},o={reps:i};return Ir.runKernel(_n,a,o)}});const _i=Dr({where_:function(t,e,n){const s=Tr(e,"a","where"),r=Tr(n,"b","where"),i=Tr(t,"condition","where","bool"),a=Jr(Jr(i.shape,s.shape),r.shape),o={condition:Ti(i,a),t:Ti(s,a),e:Ti(r,a)};return Ir.runKernel(wn,o)}}),Di={kernelName:Ie,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{clipValueMin:r,clipValueMax:i}=n;return{x:()=>_i(zi(Ai(s,r),$i(s,i)),t,ti(t))}}},Fi={kernelName:Ae,inputsToSave:["x"],gradFunc:Rr.gradFunc};const Mi=Dr({split_:function(t,e,n=0){const s={x:Tr(t,"x","split")},r={numOrSizeSplits:e,axis:n};return Ir.runKernel($n,s,r)}}),Li={kernelName:$e,saveAllInputs:!0,gradFunc:(t,e,n)=>{const s=e.map((t=>t.shape)),{axis:r}=n,i=Yn(r,e[0].shape)[0],a=s.map((t=>t[i]));return Mi(t,a,i).map((t=>()=>t))}};const Ri=Dr({conv2DBackpropFilter_:function(t,e,n,s,r,i="NHWC",a){let o=t;3===t.rank&&(o=Zr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2]])),Kn(4===o.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${o.shape}.`)),Kn(4===l.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${l.shape}.`)),Kn(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const u="NHWC"===i?o.shape[3]:o.shape[1],h="NHWC"===i?l.shape[3]:l.shape[1];Kn(u===n[2],(()=>`Error in conv2dDerFilter: depth of input ${u}) must match input depth in filter (${n[2]}.`)),Kn(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),gi("conv2dDerFilter",r,a);const c={x:o,dy:l},p={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,filterShape:n};return Ir.runKernel("Conv2DBackpropFilter",c,p)}});const Oi=Dr({conv2DBackpropInput_:function(t,e,n,s,r,i="NHWC",a){Kn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let o=t,l=e,u=!1;3===e.rank&&(u=!0,l=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2]]),o=[1,t[0],t[1],t[2]]),Kn(4===o.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${o.length}.`)),Kn(4===l.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${l.rank}`)),Kn(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===i?o[3]:o[1],c="NHWC"===i?l.shape[3]:l.shape[1];Kn(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),Kn(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),gi("conv2dDerInput",r,a);const p={dy:l,filter:n},d={strides:s,pad:r,dataFormat:i,dimRoundingMode:a,inputShape:o},f=Ir.runKernel(Ce,p,d);return u?Zr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Bi={kernelName:ze,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{dilations:i,strides:a,pad:o,dataFormat:l}=n;return Kn(di(i),(()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`)),{x:()=>Oi(s.shape,t,r,a,o,l),filter:()=>Ri(s,t,r.shape,a,o,l)}}};const Pi=Dr({conv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Tr(t,"x","conv2d","float32"),l=Tr(e,"filter","conv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(4===u.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${u.rank}.`)),Kn(4===l.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${l.rank}.`)),gi("conv2d",s,a);const c="NHWC"===r?u.shape[3]:u.shape[1];Kn(c===l.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${l.shape[2]}.`)),Kn(fi(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ir.runKernel(ze,p,d);return h?Zr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}}),Wi={kernelName:Ce,inputsToSave:["dy","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,{strides:i,pad:a,dataFormat:o,dimRoundingMode:l}=n;return{dy:()=>Pi(t,r,i,a,o,1,l),filter:()=>Ri(t,s,r.shape,i,a,o,l)}}};const Ui=Dr({conv3DBackpropFilter_:function(t,e,n,s,r){let i=t;4===t.rank&&(i=Zr(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]));let a=e;4===a.rank&&(a=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]])),Kn(5===i.rank,(()=>`Error in conv3dDerFilter: input must be rank 5, but got shape ${i.shape}.`)),Kn(5===a.rank,(()=>`Error in conv3dDerFilter: dy must be rank 5, but got shape ${a.shape}.`)),Kn(5===n.length,(()=>`Error in conv3dDerFilter: filterShape must be length 5, but got ${n}.`)),Kn(i.shape[4]===n[3],(()=>`Error in conv3dDerFilter: depth of input ${i.shape[4]}) must match input depth in filter (${n[3]}.`)),Kn(a.shape[4]===n[4],(()=>`Error in conv3dDerFilter: depth of dy (${a.shape[4]}) must match output depth for filter (${n[4]}).`));const o={x:i,dy:a},l={strides:s,pad:r,filterShape:n};return Ir.runKernel("Conv3DBackpropFilterV2",o,l)}});const Ki=Dr({conv3DBackpropInput_:function(t,e,n,s,r){Kn(t.length===e.rank,(()=>`Length of inShape (${t.length}) and rank of dy (${e.rank}) must match`));let i=t,a=e,o=!1;4===e.rank&&(o=!0,a=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]),i=[1,t[0],t[1],t[2],t[3]]);const l=i[4],u=a.shape[4];Kn(5===i.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${i.length}.`)),Kn(5===a.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${a.rank}`)),Kn(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),Kn(l===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`)),Kn(u===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${u}) must match output depth for filter ${n.shape[4]}.`));const h={dy:a,filter:n},c={pad:r,strides:s,inputShape:i},p=Ir.runKernel("Conv3DBackpropInputV2",h,c);return o?Zr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Vi={kernelName:Te,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i}=n;Kn(di(s),(()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${s}'`));const[a,o]=e;return{x:()=>Ki(a.shape,t,o,r,i),filter:()=>Ui(a,t,o.shape,r,i)}}};const qi=Dr({sin_:function(t){const e={x:Tr(t,"x","sin","float32")};return Ir.runKernel("Sin",e)}}),ji={kernelName:"Cos",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(Pr(qi(Fr(n,"float32"))),t)}}};const Gi=Dr({sinh_:function(t){const e={x:Tr(t,"x","sinh")};return Ir.runKernel(xn,e)}}),Hi={kernelName:_e,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(Gi(Fr(n,"float32")),t)}}};function Ji(t,e){return function(t,e,n){const s=t.length+e.length,r=[];let i=0,a=0;for(let o=0;o<s;o++)-1===n.indexOf(o)?r.push(t[i++]):r.push(e[a++]);return r}(t,e.map((t=>1)),e)}function Zi(t,e){if(function(t,e){for(let n=0;n<t.length;++n)if(t[t.length-n-1]!==e-1-n)return!1;return!0}(t,e))return null;const n=[];for(let s=0;s<e;++s)-1===t.indexOf(s)&&n.push(s);return t.forEach((t=>n.push(t))),n}function Yi(t){return t.map(((t,e)=>[e,t])).sort(((t,e)=>t[1]-e[1])).map((t=>t[0]))}const Xi=Dr({cumsum_:function(t,e=0,n=!1,s=!1){const r={x:Tr(t,"x","cumsum")},i={axis:e,exclusive:n,reverse:s};return Ir.runKernel(De,r,i)}});function Qi(t,e){return Ir.tidy(t,e)}function ta(t){vr(t).forEach((t=>t.dispose()))}const ea=Dr({complex_:function(t,e){const n=Tr(t,"real","complex"),s=Tr(e,"imag","complex");Vn(n.shape,s.shape,`real and imag shapes, ${n.shape} and ${s.shape}, must match in call to tf.complex().`);const r={real:n,imag:s};return Ir.runKernel("Complex",r)}});const na=Dr({imag_:function(t){const e={input:Tr(t,"input","imag")};return Ir.runKernel("Imag",e)}});const sa=Dr({real_:function(t){const e={input:Tr(t,"input","real")};return Ir.runKernel("Real",e)}});const ra=Dr({transpose_:function(t,e,n){const s=Tr(t,"x","transpose");if(null==e&&(e=s.shape.map(((t,e)=>e)).reverse()),Kn(s.rank===e.length,(()=>`Error in transpose: rank of input ${s.rank} must match length of perm ${e}.`)),e.forEach((t=>{Kn(t>=0&&t<s.rank,(()=>"All entries in 'perm' must be between 0 and "+(s.rank-1)+` but got ${e}`))})),s.rank<=1)return s.clone();const r={x:s},i={perm:e};return"complex64"===s.dtype?Qi((()=>{let t=sa(s),e=na(s);return t=Ir.runKernel(Dn,{x:t},i),e=Ir.runKernel(Dn,{x:e},i),n&&(e=Pr(e)),ea(t,e)})):Ir.runKernel(Dn,r,i)}}),ia={kernelName:De,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r,exclusive:i,reverse:a}=n;return{x:()=>{const e=Zi([r],s.rank);let n=Xi(t,r,i,!a);return null!=e&&(n=ra(n,e)),n}}}};const aa=Dr({depthwiseConv2dNativeBackpropFilter_:function(t,e,n,s,r,i=[1,1],a){let o=t;3===t.rank&&(o=Zr(t,[1,t.shape[0],t.shape[1],t.shape[2]]));let l=e;3===l.rank&&(l=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={x:o,dy:l},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,filterShape:n};return Ir.runKernel("DepthwiseConv2dNativeBackpropFilter",u,h)}});const oa=Dr({depthwiseConv2dNativeBackpropInput_:function(t,e,n,s,r,i=[1,1],a){let o=e,l=!1;3===e.rank&&(l=!0,o=Zr(e,[1,e.shape[0],e.shape[1],e.shape[2]]));const u={dy:o,filter:n},h={strides:s,pad:r,dimRoundingMode:a,dilations:i,inputShape:t},c=Ir.runKernel("DepthwiseConv2dNativeBackpropInput",u,h);return l?Zr(c,[c.shape[1],c.shape[2],c.shape[3]]):c}}),la={kernelName:Fe,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const{dilations:s,strides:r,pad:i,dimRoundingMode:a}=n,o=null==s?[1,1]:s;Kn(di(o),(()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[l,u]=e;return Kn(4===l.rank,(()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`)),Kn(4===u.rank,(()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${u.rank}.`)),Kn(l.shape[3]===u.shape[2],(()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${u.shape[2]}.`)),Kn(fi(r,o),(()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${r} and dilations '${o}'.`)),gi("depthwiseConv2d",i,a),{x:()=>oa(l.shape,t,u,r,i,o,a),filter:()=>aa(l,t,u.shape,r,i,o,a)}}},ua={kernelName:Me,inputsToSave:["x","filter"],gradFunc:(t,e,n)=>{const[s,r]=e,i={x:s,filter:r,dy:t},a={x:s,filter:r,dy:t};return{x:()=>Ir.runKernel("Dilation2DBackpropInput",i,n),filter:()=>Ir.runKernel("Dilation2DBackpropFilter",a,n)}}},ha={kernelName:"Elu",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e,s={dy:t,y:n};return{x:()=>Ir.runKernel("EluGrad",s)}}};const ca=Dr({exp_:function(t){const e={x:Tr(t,"x","exp")};return Ir.runKernel("Exp",e)}}),pa={kernelName:"Erf",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Mr(ca(Pr(Vr(n))),2/Math.sqrt(Math.PI));return{x:()=>Mr(t,s)}}},da={kernelName:"Exp",outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,n)}}},fa={kernelName:Re,inputsToSave:["input"],gradFunc:(t,e)=>{const[n]=e;return{input:()=>Zr(t,n.shape)}}},ga={kernelName:Oe,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,ca(n))}}},ma={kernelName:Be,gradFunc:t=>({x:()=>ti(t)})},ba={kernelName:Pe,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{const e=Br(t,Fr(s,"float32")),i=Hr(n.shape,r);return i.length>0?Zr(Yr(e,i),n.shape):e},b:()=>{let e=Mr(t,Fr(n,"float32"));const i=Hr(s.shape,r);i.length>0&&(e=Zr(Yr(e,i),s.shape));const a=Vr(s);return Pr(Br(e,Fr(a,"float32")))}}}};const ya=Dr({rsqrt_:function(t){const e={x:Tr(t,"x","rsqrt","float32")};return Ir.runKernel(yn,e)}});const wa=Dr({tile_:function(t,e){const n=Tr(t,"x","tile","string_or_numeric");Kn(n.rank===e.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${e}.`));const s={x:n},r={reps:e};return Ir.runKernel(_n,s,r)}}),ka={kernelName:We,inputsToSave:["x","mean","variance","scale"],gradFunc:(t,e,n)=>{const{varianceEpsilon:s}=n,[r,i,a,o]=e,l=null==o?Ur(1):o,u=Hr(i.shape,r.shape),h=[];if(1===i.rank){for(let t=0;t<r.shape.length-1;++t)h.push(r.shape[t]);h.push(1)}const c=qr(r,i),p=Mr(t,l),d=ya(ri(a,Ur(s))),f=Mr(Mr(Mr(d,d),d),Ur(-.5));return{x:()=>1===i.rank?Zr(Mr(Mr(t,wa(Zr(d,[1,1,1,i.shape[0]]),h)),l),r.shape):Zr(Mr(Mr(t,d),l),r.shape),mean:()=>{let t=Mr(Mr(d,Ur(-1)),p);return 1===i.rank&&(t=Yr(t,u)),Zr(t,i.shape)},variance:()=>{let t=Mr(Mr(f,c),p);return 1===i.rank&&(t=Yr(t,u)),Zr(t,i.shape)},scale:()=>{const e=Mr(c,d);let n=Mr(t,e);return 1===i.rank&&(n=Yr(n,u)),Zr(n,i.shape)},offset:()=>{let e=t;return 1===i.rank&&(e=Yr(e,u)),Zr(e,i.shape)}}}};const va=Dr({unsortedSegmentSum_:function(t,e,n){const s=Tr(t,"x","unsortedSegmentSum"),r=Tr(e,"segmentIds","unsortedSegmentSum","int32");Kn(Jn(n),(()=>"numSegments must be of dtype int"));const i={x:s,segmentIds:r},a={numSegments:n};return Ir.runKernel(Mn,i,a)}}),xa={kernelName:Ue,inputsToSave:["x","indices"],gradFunc:(t,e,n)=>{const[s,r]=e,{axis:i}=n,a=Yn(i,s.shape)[0];return{x:()=>{const e=s.shape,n=r.size,o=e.slice(0,a),l=o.length,u=e.slice(i,e.length).slice(1),h=u.length,c=Sa(0,l),p=Sa(l+1,l+1+h),d=Na([o,[n],u]),f=Zr(t,d),g=Zr(r,[n]),m=Na([[l],c,p]),b=ra(f,m);let y=va(b,g,s.shape[a]);const w=Yi(m);return y=ra(y,w),y},indices:()=>r}}};function Sa(t,e){const n=[];for(let s=t;s<e;++s)n.push(s);return n}function Na(t){const e=[];for(let n=0;n<t.length;++n)for(let s=0;s<t[n].length;++s)e.push(t[n][s]);return e}const Ea={kernelName:Ke,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>ti(n),b:()=>ti(s)}}},Ia={kernelName:Ve,gradFunc:t=>({x:()=>Fr(t,"float32")})},Aa={kernelName:qe,gradFunc:t=>({x:()=>ti(t)})},$a={kernelName:je,gradFunc:t=>({x:()=>ti(t)})},za={kernelName:Ge,gradFunc:t=>({x:()=>ti(t)})};const Ca=Dr({greater_:function(t,e){let n=Tr(t,"a","greater","string_or_numeric"),s=Tr(e,"b","greater","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("Greater",r)}}),Ta={kernelName:He,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{alpha:r}=n,i=Ca(s,0);return{x:()=>_i(i,t,Mr(t,r))}}},_a={kernelName:Je,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,ri(n,1))}}},Da={kernelName:"Log",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,Fr(n,"float32"))}}},Fa={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;return{logits:()=>{const e=ca(s);return qr(t,Mr(Yr(t,r,!0),e))}}}};const Ma=Dr({localResponseNormalizationBackprop_:function(t,e,n,s=5,r=1,i=1,a=.5){const o={x:t,y:e,dy:n},l={depthRadius:s,bias:r,alpha:i,beta:a};return Ir.runKernel("LRNGrad",o,l)}}),La={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{depthRadius:i,bias:a,alpha:o,beta:l}=n;return{x:()=>Ma(s,r,t,i,a,o,l)}}};const Ra=Dr({equal_:function(t,e){let n=Tr(t,"a","equal","string_or_numeric"),s=Tr(e,"b","equal","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("Equal",r)}});function Oa(t,e,n,s){return e.rank<n.rank&&(e=Zr(e,Ji(e.shape,s))),t.rank<n.rank&&(t=Zr(t,Ji(t.shape,s))),{x:()=>Mr(t,Fr(Ra(n,e),t.dtype))}}const Ba={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{reductionIndices:r}=s,i=e[0],a=Oa(t,e[1],i,Yn(r,i.shape));return{x:()=>a.x()}}};const Pa=Dr({less_:function(t,e){let n=Tr(t,"a","less","string_or_numeric"),s=Tr(e,"b","less","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("Less",r)}}),Wa={kernelName:Ze,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Mr(t,Fr(Ai(n,s),"float32")),b:()=>Mr(t,Fr(Pa(n,s),"float32"))}}};const Ua=Dr({maxPool3dGrad_:function(t,e,n,s,r,i,a){const o=Tr(t,"dy","maxPool3dGrad"),l=Tr(e,"input","maxPool3dGrad"),u=Tr(n,"output","maxPool3dGrad");let h=o,c=l,p=u,d=!1;4===l.rank&&(d=!0,h=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]]),c=Zr(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),p=Zr(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),Kn(5===h.rank,(()=>`Error in maxPool3dGrad: dy must be rank 5 but got rank ${h.rank}.`)),Kn(5===c.rank,(()=>`Error in maxPool3dGrad: input must be rank 5 but got rank ${c.rank}.`)),Kn(5===p.rank,(()=>`Error in maxPool3dGrad: output must be rank 5 but got rank ${p.rank}.`)),gi("maxPool3dGrad",i,a);const f={dy:h,input:c,output:p},g={filterSize:s,strides:r,pad:i,dimRoundingMode:a},m=Ir.runKernel("MaxPool3DGrad",f,g);return d?Zr(m,[m.shape[1],m.shape[2],m.shape[3],m.shape[4]]):m}}),Ka={kernelName:Xe,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o,dimRoundingMode:l}=n;return{x:()=>Ua(t,s,r,i,a,o,l)}}};const Va=Dr({maxPoolGrad_:function(t,e,n,s,r,i,a){const o=Tr(t,"dy","maxPoolGrad"),l=Tr(e,"input","maxPoolGrad"),u=Tr(n,"output","maxPoolGrad");Kn(l.rank===o.rank,(()=>`Rank of input (${l.rank}) does not match rank of dy (${o.rank})`)),Kn(4===o.rank,(()=>`Error in maxPoolGrad: dy must be rank 4 but got rank ${o.rank}.`)),Kn(4===l.rank,(()=>`Error in maxPoolGrad: input must be rank 4 but got rank ${l.rank}.`)),gi("maxPoolGrad",i,a);const h={dy:o,input:l,output:u},c={filterSize:s,strides:r,pad:i,dimRoundingMode:a};return Ir.runKernel("MaxPoolGrad",h,c)}}),qa={kernelName:Ye,inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s,r]=e,{filterSize:i,strides:a,pad:o}=n;return{x:()=>Va(t,s,r,i,a,o)}}};function ja(t,e="float32"){if("complex64"===e){const e=ja(t,"float32"),n=ja(t,"float32");return ea(e,n)}const n=os(Gn(t),e);return Ir.makeTensor(n,t,e)}function Ga(t,e="float32"){if("complex64"===e){const e=Ga(t,"float32"),n=ja(t,"float32");return ea(e,n)}const n=as(Gn(t),e);return Ir.makeTensor(n,t,e)}const Ha={kernelName:Qe,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n,i=Yn(r,s.shape),a=function(t,e){const n=[],s=t.length;for(let r=0;r<s;r++)-1===e.indexOf(r)&&n.push(t[r]);return[n,e.map((e=>t[e]))]}(s.shape,i),o=Gn(a[1]);return{x:()=>{const e=s.shape.slice();i.forEach((t=>{e[t]=1}));const n=Zr(t,e);return Br(Mr(n,Ga(s.shape,"float32")),o)}}}},Ja={kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(t,e,n)=>{const s=n,{axis:r}=s,[i,a]=e,o=Oa(t,a,i,Yn(r,i.shape));return{x:()=>o.x()}}},Za={kernelName:tn,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e;return{a:()=>Mr(t,Fr($i(n,s),"float32")),b:()=>Mr(t,Fr(Ca(n,s),"float32"))}}};const Ya=Dr({slice_:function(t,e,n){const s=Tr(t,"x","slice","string_or_numeric");if(0===s.rank)throw new Error("Slicing scalar is not possible");const r={x:s},i={begin:e,size:n};return Ir.runKernel(vn,r,i)}}),Xa={kernelName:en,inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>Ya(t,i,s.shape)}}};const Qa=Dr({floor_:function(t){const e={x:Tr(t,"x","floor","float32")};return Ir.runKernel(Be,e)}}),to={kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{const e=Hr(n.shape,r);return e.length>0?Zr(Yr(t,e),n.shape):t},b:()=>{const e=Mr(t,Pr(Qa(Br(n,s)))),i=Hr(s.shape,r);return i.length>0?Zr(Yr(e,i),s.shape):e}}}},eo={kernelName:nn,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{const e=Mr(t,Fr(s,"float32")),i=Hr(n.shape,r);return i.length>0?Zr(Yr(e,i),n.shape):e},b:()=>{const e=Mr(t,Fr(n,"float32")),i=Hr(s.shape,r);return i.length>0?Zr(Yr(e,i),s.shape):e}}}},no={kernelName:"Neg",gradFunc:t=>({x:()=>Pr(t)})},so={kernelName:rn,inputsToSave:["indices"],gradFunc:(t,e)=>{const n=e[0];return{indices:()=>ja(n.shape,"float32")}}},ro={kernelName:sn,gradFunc:t=>({x:()=>ti(t)})};const io=Dr({unstack_:function(t,e=0){const n=Tr(t,"x","unstack","string_or_numeric");Kn(e>=-n.shape.length&&e<n.shape.length,(()=>`Axis = ${e} is not in [-${n.shape.length}, ${n.shape.length})`));const s={value:n},r={axis:e};return Ir.runKernel(Fn,s,r)}}),ao={kernelName:an,saveAllInputs:!0,gradFunc:(t,e,n)=>{const{axis:s}=n;return io(t,s).map((t=>()=>t))}},oo={kernelName:on,inputsToSave:["x"],gradFunc:(t,e,n)=>{const s=e[0],{paddings:r}=n,i=r.map((t=>t[0]));return{x:()=>Ya(t,i,s.shape)}}};const lo=Dr({log_:function(t){const e={x:Tr(t,"x","log","float32")};return Ir.runKernel("Log",e)}});const uo=Dr({pow_:function(t,e){let n=Tr(t,"base","pow"),s=Tr(e,"exp","pow");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel("Pow",r)}}),ho={kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(t,e)=>{const[n,s,r]=e,i=n,a=s,o=Jr(i.shape,a.shape);return{a:()=>{const e=Fr(a,"float32");let n=Mr(t,Mr(e,uo(i,qr(e,Ur(1)))));const s=Hr(i.shape,o);return s.length>0&&(n=Yr(n,s)),Zr(n,i.shape)},b:()=>{const e=Ca(i,0),n=_i(e,lo(i),ti(i));let s=Mr(t,Mr(r,n));const l=Hr(a.shape,o);return l.length>0&&(s=Yr(s,l)),Zr(s,a.shape)}}}},co={kernelName:ln,inputsToSave:["x","alpha"],gradFunc:(t,e)=>{const[n,s]=e,r=Ca(n,0);return{x:()=>_i(r,t,Mr(t,s)),alpha:()=>{let e=_i(r,ti(t),Mr(t,n));const i=Hr(s.shape,t.shape);return i.length>0&&(e=Yr(e,i)),Zr(e,s.shape)}}}};const po=ds();po.registerFlag("DEBUG",(()=>!1),(t=>{t&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),po.registerFlag("IS_BROWSER",(()=>"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope)),po.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),po.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),po.registerFlag("PROD",(()=>!1)),po.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>po.getBool("DEBUG"))),po.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),po.registerFlag("IS_TEST",(()=>!1)),po.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),po.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),po.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const fo="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function go(t){return fo?Buffer.byteLength(t):new Blob([t]).size}function mo(t){if(1===t.length)return t[0];let e=0;t.forEach((t=>{e+=t.byteLength}));const n=new Uint8Array(e);let s=0;return t.forEach((t=>{n.set(new Uint8Array(t),s),s+=t.byteLength})),n.buffer}function bo(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,weightsManifest:e};return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),n}function yo(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==t.modelTopology?0:go(JSON.stringify(t.modelTopology)),weightSpecsBytes:null==t.weightSpecs?0:go(JSON.stringify(t.weightSpecs)),weightDataBytes:null==t.weightData?0:t.weightData.byteLength}}class wo{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==wo.instance&&(wo.instance=new wo),wo.instance}static registerSaveRouter(t){wo.getInstance().saveRouters.push(t)}static registerLoadRouter(t){wo.getInstance().loadRouters.push(t)}static getSaveHandlers(t){return wo.getHandlers(t,"save")}static getLoadHandlers(t,e){return wo.getHandlers(t,"load",e)}static getHandlers(t,e,n){const s=[];return("load"===e?wo.getInstance().loadRouters:wo.getInstance().saveRouters).forEach((e=>{const r=e(t,n);null!==r&&s.push(r)})),s}}const ko="models_store",vo="model_info_store";class xo{constructor(t){if(this.indexedDB=function(){if(!ds().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const t="undefined"==typeof window?self:window,e=t.indexedDB||t.mozIndexedDB||t.webkitIndexedDB||t.msIndexedDB||t.shimIndexedDB;if(null==e)throw new Error("The current browser does not appear to support IndexedDB.");return e}(),null==t||!t)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=t}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,t)}async load(){return this.databaseAction(this.modelPath)}databaseAction(t,e){return new Promise(((t,n)=>{const s=this.indexedDB.open("tensorflowjs",1);s.onupgradeneeded=()=>function(t){const e=t.result;e.createObjectStore(ko,{keyPath:"modelPath"}),e.createObjectStore(vo,{keyPath:"modelPath"})}(s),s.onsuccess=()=>{const r=s.result;if(null==e){const e=r.transaction(ko,"readonly"),s=e.objectStore(ko).get(this.modelPath);s.onsuccess=()=>{if(null==s.result)return r.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));t(s.result.modelArtifacts)},s.onerror=t=>(r.close(),n(s.error)),e.oncomplete=()=>r.close()}else{const s=yo(e),i=r.transaction(vo,"readwrite");let a=i.objectStore(vo);const o=a.put({modelPath:this.modelPath,modelArtifactsInfo:s});let l;o.onsuccess=()=>{l=r.transaction(ko,"readwrite");const o=l.objectStore(ko).put({modelPath:this.modelPath,modelArtifacts:e,modelArtifactsInfo:s});o.onsuccess=()=>t({modelArtifactsInfo:s}),o.onerror=t=>{a=i.objectStore(vo);const e=a.delete(this.modelPath);e.onsuccess=()=>(r.close(),n(o.error)),e.onerror=t=>(r.close(),n(o.error))}},o.onerror=t=>(r.close(),n(o.error)),i.oncomplete=()=>{null==l?r.close():l.oncomplete=()=>r.close()}}},s.onerror=t=>n(s.error)}))}}xo.URL_SCHEME="indexeddb://";const So=t=>{return ds().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(xo.URL_SCHEME)?(e=t.slice(xo.URL_SCHEME.length),new xo(e)):null;var e};wo.registerSaveRouter(So),wo.registerLoadRouter(So);const No="/",Eo="tensorflowjs_models",Io="info",Ao="model_topology",$o="weight_specs",zo="weight_data",Co="model_metadata";class To{constructor(t){if(!ds().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==t||!t)throw new Error("For local storage, modelPath must not be null, undefined or empty.");var e;this.modelPath=t,this.keys=(e=this.modelPath,{info:[Eo,e,Io].join(No),topology:[Eo,e,Ao].join(No),weightSpecs:[Eo,e,$o].join(No),weightData:[Eo,e,zo].join(No),modelMetadata:[Eo,e,Co].join(No)})}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const e=JSON.stringify(t.modelTopology),n=JSON.stringify(t.weightSpecs),s=yo(t);try{this.LS.setItem(this.keys.info,JSON.stringify(s)),this.LS.setItem(this.keys.topology,e),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(t){if(fo)return Buffer.from(t).toString("base64");const e=new Uint8Array(t);let n="";for(let t=0,s=e.length;t<s;t++)n+=String.fromCharCode(e[t]);return btoa(n)}(t.weightData));const r={format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy,signature:null!=t.signature?t.signature:void 0,userDefinedMetadata:null!=t.userDefinedMetadata?t.userDefinedMetadata:void 0,modelInitializer:null!=t.modelInitializer?t.modelInitializer:void 0,trainingConfig:null!=t.trainingConfig?t.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(r)),{modelArtifactsInfo:s}}catch(t){throw function(t){for(const e of Object.values(t))window.localStorage.removeItem(e)}(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${s.modelTopologyBytes}, weightSpecsBytes=${s.weightSpecsBytes}, weightDataBytes=${s.weightDataBytes}.`)}}}async load(){const t=JSON.parse(this.LS.getItem(this.keys.info));if(null==t)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==t.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const e={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);e.modelTopology=n;const s=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==s)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);e.weightSpecs=s;const r=this.LS.getItem(this.keys.modelMetadata);if(null!=r){const t=JSON.parse(r);e.format=t.format,e.generatedBy=t.generatedBy,e.convertedBy=t.convertedBy,null!=t.signature&&(e.signature=t.signature),null!=t.userDefinedMetadata&&(e.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(e.modelInitializer=t.modelInitializer),null!=t.trainingConfig&&(e.trainingConfig=t.trainingConfig)}const i=this.LS.getItem(this.keys.weightData);if(null==i)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return e.weightData=function(t){if(fo){const e=Buffer.from(t,"base64");return e.buffer.slice(e.byteOffset,e.byteOffset+e.byteLength)}const e=atob(t),n=new Uint8Array(e.length);for(let t=0;t<e.length;++t)n.set([e.charCodeAt(t)],t);return n.buffer}(i),e}}To.URL_SCHEME="localstorage://";const _o=t=>{return ds().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(To.URL_SCHEME)?(e=t.slice(To.URL_SCHEME.length),new To(e)):null;var e};wo.registerSaveRouter(_o),wo.registerLoadRouter(_o);function Do(t){return new Promise((t=>setTimeout(t))).then(t)}class Fo{constructor(t){if(!ds().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");t.startsWith(Fo.URL_SCHEME)&&(t=t.slice(Fo.URL_SCHEME.length)),null!=t&&0!==t.length||(t="model"),this.modelJsonFileName=t+".json",this.weightDataFileName=t+".weights.bin"}async save(t){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const e=window.URL.createObjectURL(new Blob([t.weightData],{type:"application/octet-stream"}));if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=bo(t,[{paths:["./"+this.weightDataFileName],weights:t.weightSpecs}]),s=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),r=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(r.download=this.modelJsonFileName,r.href=s,await Do((()=>r.dispatchEvent(new MouseEvent("click")))),null!=t.weightData){const t=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;t.download=this.weightDataFileName,t.href=e,await Do((()=>t.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:yo(t)}}}}Fo.URL_SCHEME="downloads://";function Mo(t,e,n,s){!function(t){Kn(null!=t&&Array.isArray(t)&&t.length>0,(()=>"promises must be a none empty array"))}(t),function(t,e){Kn(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${t}`)),Kn(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${e}`)),Kn(e>=t,(()=>`startFraction must be no more than endFraction, but got startFraction ${t} and endFraction ${e}`))}(n=null==n?0:n,s=null==s?1:s);let r=0;return Promise.all(t.map((i=>(i.then((i=>{const a=n+ ++r/t.length*(s-n);return e(a),i})),i))))}wo.registerSaveRouter((t=>ds().getBool("IS_BROWSER")&&!Array.isArray(t)&&t.startsWith(Fo.URL_SCHEME)?function(t="model"){return new Fo(t)}(t.slice(Fo.URL_SCHEME.length)):null));class Lo{constructor(t,e){if(this.DEFAULT_METHOD="POST",null==e&&(e={}),this.weightPathPrefix=e.weightPathPrefix,this.onProgress=e.onProgress,this.weightUrlConverter=e.weightUrlConverter,null!=e.fetchFunc?(Kn("function"==typeof e.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=e.fetchFunc):this.fetch=ds().platform.fetch,Kn(null!=t&&t.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(t)&&Kn(2===t.length,(()=>`URL paths for http must have a length of 2, (actual length is ${t.length}).`)),this.path=t,null!=e.requestInit&&null!=e.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=e.requestInit||{}}async save(t){if(t.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const e=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);e.body=new FormData;const n=bo(t,[{paths:["./model.weights.bin"],weights:t.weightSpecs}]);e.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=t.weightData&&e.body.append("model.weights.bin",new Blob([t.weightData],{type:"application/octet-stream"}),"model.weights.bin");const s=await this.fetch(this.path,e);if(s.ok)return{modelArtifactsInfo:yo(t),responses:[s]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${s.status}.`)}async load(){const t=await this.fetch(this.path,this.requestInit);if(!t.ok)throw new Error(`Request to ${this.path} failed with status code ${t.status}. Please verify this URL points to the model JSON of the model to load.`);let e;try{e=await t.json()}catch(t){let e=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?e+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":e+=" Please make sure the server is serving valid JSON for this request.",new Error(e)}const n=e.modelTopology,s=e.weightsManifest;if(null==n&&null==s)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return async function(t,e){const n={modelTopology:t.modelTopology,format:t.format,generatedBy:t.generatedBy,convertedBy:t.convertedBy};if(null!=t.trainingConfig&&(n.trainingConfig=t.trainingConfig),null!=t.weightsManifest){const[s,r]=await e(t.weightsManifest);n.weightSpecs=s,n.weightData=r}return null!=t.signature&&(n.signature=t.signature),null!=t.userDefinedMetadata&&(n.userDefinedMetadata=t.userDefinedMetadata),null!=t.modelInitializer&&(n.modelInitializer=t.modelInitializer),n}(e,(t=>this.loadWeights(t)))}async loadWeights(t){const e=Array.isArray(this.path)?this.path[1]:this.path,[n,s]=function(t){const e=t.lastIndexOf("/"),n=t.lastIndexOf("?"),s=t.substring(0,e),r=n>e?t.substring(n):"";return[s+"/",r]}(e),r=this.weightPathPrefix||n,i=[];for(const e of t)i.push(...e.weights);const a=[],o=[];for(const e of t)for(const t of e.paths)null!=this.weightUrlConverter?o.push(this.weightUrlConverter(t)):a.push(r+t+s);this.weightUrlConverter&&a.push(...await Promise.all(o));const l=await async function(t,e){null==e&&(e={});const n=null==e.fetchFunc?ds().platform.fetch:e.fetchFunc,s=t.map((t=>n(t,e.requestInit,{isBinary:!0}))),r=(null==e.onProgress?await Promise.all(s):await Mo(s,e.onProgress,0,.5)).map((t=>t.arrayBuffer()));return null==e.onProgress?await Promise.all(r):await Mo(r,e.onProgress,.5,1)}(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress});return[i,mo(l)]}}function Ro(t){return null!=t.match(Lo.URL_SCHEME_REGEX)}Lo.URL_SCHEME_REGEX=/^https?:\/\//;const Oo=(t,e)=>{if("undefined"==typeof fetch&&(null==e||null==e.fetchFunc))return null;{let n=!0;if(n=Array.isArray(t)?t.every((t=>Ro(t))):Ro(t),n)return function(t,e){return new Lo(t,e)}(t,e)}return null};wo.registerSaveRouter(Oo),wo.registerLoadRouter(Oo);const Bo=Dr({oneHot_:function(t,e,n=1,s=0){if(e<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${e}`);const r={indices:Tr(t,"indices","oneHot","int32")},i={depth:e,onValue:n,offValue:s};return Ir.runKernel(rn,r,i)}});let Po;function Wo(t,e,n){if(e.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${e.rank}.`);if(t.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${t.rank}.`);if("int32"!==e.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${e.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===e.size)throw new Error(`Indices specified for empty output. indices shape: ${e.shape}`);if(0===t.size)throw new Error(`Updates specified for empty output. updates shape: ${t.shape}`)}!function(t,e,n){const s=e.rank>1?e.shape[e.rank-1]:1,r=e.rank>1?e.rank-1:1,i=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${e.shape}, shape: ${t}, sliceDim: ${s}, and batchDim: ${r}.`;if(n.rank<r)throw new Error(i+` update.rank < ${r}. `);if(t.length<s+(n.rank-r))throw new Error(i+` Output shape length < ${s+(n.rank-r)}`);if(n.rank!==r+t.length-s)throw new Error(i+" update.rank != "+(r+t.length-s));for(let t=0;t<r;++t)if(n.shape[t]!==e.shape[t])throw new Error(i+` updates.shape[${t}] (${n.shape[t]}) != indices.shape[${t}] (${e.shape[t]}).`);for(let e=0;e<n.rank-r;++e)if(n.shape[e+r]!==t[e+s])throw new Error(i+` updates.shape[${e+r}] (${n.shape[e+r]}) != shape[${e+r}] (${t[e+r]})`)}(n,e,t)}Dr({confusionMatrix_:function(t,e,n){const s=Tr(t,"labels","confusionMatrix"),r=Tr(e,"predictions","confusionMatrix");Kn(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),Kn(1===s.rank,(()=>`Expected the rank of labels to be 1, but got ${s.rank}`)),Kn(1===r.rank,(()=>`Expected the rank of predictions to be 1, but got ${r.rank}`)),Kn(s.shape[0]===r.shape[0],(()=>`Mismatch in the number of examples: ${s.shape[0]} vs. ${r.shape[0]}. Labels and predictions should have the same number of elements.`)),Kn(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const i=Bo(Fr(s,"int32"),n),a=Bo(Fr(r,"int32"),n),o=ra(i),l=ki(o,a);return Fr(l,"int32")}}),Dr({fromPixels_:function(t,e=3){if(e>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==t)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,s=!1,r=!1,i=!1,a=!1,o=!1;if(t.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&t instanceof ImageData)s=!0;else if("undefined"!=typeof HTMLVideoElement&&t instanceof HTMLVideoElement)r=!0;else if("undefined"!=typeof HTMLImageElement&&t instanceof HTMLImageElement)i=!0;else if(null!=t.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&t instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${t.constructor.name}`);o=!0}if(r){const e=2;if(r&&t.readyState<e)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=vs(On,Ir.backendName)){const n={pixels:t},s={numChannels:e};return Ir.runKernel(On,n,s)}const[l,u]=r?[t.videoWidth,t.videoHeight]:[t.width,t.height];let h,c;if(a)h=t.getContext("2d").getImageData(0,0,l,u).data;else if(s||n)h=t.data;else if(i||r||o){if(null==Po)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Po=new OffscreenCanvas(1,1).getContext("2d")}else Po=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Po.canvas.width=l,Po.canvas.height=u,Po.drawImage(t,0,0,l,u),h=Po.getImageData(0,0,l,u).data}if(4===e)c=new Int32Array(h);else{const t=l*u;c=new Int32Array(t*e);for(let n=0;n<t;n++)for(let t=0;t<e;++t)c[n*e+t]=h[4*n+t]}return function(t,e,n){if(qn(t),null!=e&&3!==e.length)throw new Error("tensor3d() requires shape to have three numbers");const s=$r(t,n);if(3!==s.length&&1!==s.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Wr(t,e,s,n)}(c,[u,l,e],"int32")}});class Uo{constructor(){this.classNameMap={}}static getMap(){return null==Uo.instance&&(Uo.instance=new Uo),Uo.instance}static register(t){Uo.getMap().classNameMap[t.className]=[t,t.fromConfig]}}function Ko(t){Kn(null!=t.className,(()=>"Class being registered does not have the static className property defined.")),Kn("string"==typeof t.className,(()=>"className is required to be a string, but got type "+typeof t.className)),Kn(t.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Uo.register(t)}const Vo=Dr({abs_:function(t){const e=Tr(t,"x","abs");if("complex64"===e.dtype){const t={x:e};return Ir.runKernel(Ae,t)}{const t={x:e};return Ir.runKernel("Abs",t)}}});Dr({acos_:function(t){const e={x:Tr(t,"x","acos")};return Ir.runKernel(ue,e)}}),Dr({acosh_:function(t){const e={x:Tr(t,"x","acosh")};return Ir.runKernel(he,e)}}),Dr({addN_:function(t){Kn(Array.isArray(t),(()=>"The argument passed to tf.addN() must be a list of tensors")),Kn(t.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${t.length}`));const e=t.map(((t,e)=>Tr(t,`tensors${e}`,"addN"))),n=e[0];e.forEach((t=>{if(t.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),e.forEach((t=>{if(!Hn(t.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const s=e;return Ir.runKernel(pe,s)}}),Dr({all_:function(t,e=null,n=!1){const s={x:Tr(t,"x","all","bool")},r={axis:e,keepDims:n};return Ir.runKernel("All",s,r)}}),Dr({any_:function(t,e=null,n=!1){const s={x:Tr(t,"x","any","bool")},r={axis:e,keepDims:n};return Ir.runKernel("Any",s,r)}}),Dr({argMax_:function(t,e=0){const n={x:Tr(t,"x","argMax")},s={axis:e};return Ir.runKernel(de,n,s)}}),Dr({argMin_:function(t,e=0){const n={x:Tr(t,"x","argMin")},s={axis:e};return Ir.runKernel(fe,n,s)}}),Dr({asin_:function(t){const e={x:Tr(t,"x","asin")};return Ir.runKernel(ge,e)}}),Dr({asinh_:function(t){const e={x:Tr(t,"x","asinh")};return Ir.runKernel(me,e)}}),Dr({atan_:function(t){const e={x:Tr(t,"x","atan")};return Ir.runKernel(be,e)}}),Dr({atan2_:function(t,e){let n=Tr(t,"a","atan2"),s=Tr(e,"b","atan2");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel(we,r)}}),Dr({atanh_:function(t){const e={x:Tr(t,"x","atanh")};return Ir.runKernel(ye,e)}});const qo=Dr({avgPool_:function(t,e,n,s,r){const i=Tr(t,"x","avgPool","float32");Kn(fi(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let a=i,o=!1;3===i.rank&&(o=!0,a=Zr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===a.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${a.rank}.`)),gi("avgPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r};let h=Ir.runKernel(ke,l,u);return h=Fr(h,i.dtype),o?Zr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Dr({avgPool3d_:function(t,e,n,s,r,i="NDHWC"){const a=Tr(t,"x","avgPool3d","float32");let o=a,l=!1;4===a.rank&&(l=!0,o=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===o.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${o.rank}.`)),Kn("NDHWC"===i,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),gi("avgPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i};let c=Ir.runKernel(ve,u,h);return c=Fr(c,o.dtype),l?Zr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const jo=Dr({concat_:function(t,e=0){Kn(t.length>=1,(()=>"Pass at least one tensor to concat"));const n=_r(t,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((t=>{if("complex64"!==t.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${t.dtype}. `)})),1===n.length)return Ci(n[0]);const s=n,r={axis:e};return Ir.runKernel($e,s,r)}});const Go=Dr({sigmoid_:function(t){const e={x:Tr(t,"x","sigmoid","float32")};return Ir.runKernel(Nn,e)}});const Ho=Dr({tanh_:function(t){const e={x:Tr(t,"x","tanh","float32")};return Ir.runKernel(Tn,e)}});Dr({basicLSTMCell_:function(t,e,n,s,r,i){const a=Tr(t,"forgetBias","basicLSTMCell"),o=Tr(e,"lstmKernel","basicLSTMCell"),l=Tr(n,"lstmBias","basicLSTMCell"),u=Tr(s,"data","basicLSTMCell"),h=Tr(r,"c","basicLSTMCell"),c=Tr(i,"h","basicLSTMCell"),p=jo([u,c],1),d=ki(p,o),f=ri(d,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=Ya(f,[0,0],b),w=Ya(f,[0,m],b),k=Ya(f,[0,2*m],b),v=Ya(f,[0,3*m],b),x=ri(Mr(Go(y),Ho(w)),Mr(h,Go(ri(a,k))));return[x,Mr(Ho(x),Go(v))]}});const Jo=Dr({batchToSpaceND_:function(t,e,n){const s=Tr(t,"x","batchToSpaceND"),r=e.reduce(((t,e)=>t*e));Kn(s.rank>=1+e.length,(()=>`input rank is ${s.rank} but should be > than blockShape.length ${e.length}`)),Kn(n.length===e.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${e.length}`)),Kn(s.shape[0]%r==0,(()=>`input tensor batch is ${s.shape[0]} but is not divisible by the product of the elements of blockShape ${e.join(" * ")} === ${r}`));const i={x:s},a={blockShape:e,crops:n};return Ir.runKernel(Se,i,a)}});const Zo=Dr({batchNorm_:function(t,e,n,s,r,i){null==i&&(i=.001);const a=Tr(t,"x","batchNorm"),o=Tr(e,"mean","batchNorm"),l=Tr(n,"variance","batchNorm");let u,h;null!=r&&(u=Tr(r,"scale","batchNorm")),null!=s&&(h=Tr(s,"offset","batchNorm")),Kn(o.rank===l.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),Kn(null==h||o.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),Kn(null==u||o.rank===u.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(t){let e;return e=0===t.rank||1===t.rank?Zr(t,[1,1,1,t.size]):2===t.rank?Zr(t,[1,1,t.shape[0],t.shape[1]]):3===t.rank?Zr(t,[1,t.shape[0],t.shape[1],t.shape[2]]):t,e}(a),p={x:c,scale:u,offset:h,mean:o,variance:l},d={varianceEpsilon:i},f=Ir.runKernel(We,p,d);return Zr(f,a.shape)}});Dr({batchNorm2d_:function(t,e,n,s,r,i){const a=Tr(t,"x","batchNorm"),o=Tr(e,"mean","batchNorm"),l=Tr(n,"variance","batchNorm");let u,h;return null!=r&&(u=Tr(r,"scale","batchNorm")),null!=s&&(h=Tr(s,"offset","batchNorm")),Kn(2===a.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${a.rank}.`)),Kn(2===o.rank||1===o.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${o.rank}.`)),Kn(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Zo(a,o,l,h,u,i)}}),Dr({batchNorm3d_:function(t,e,n,s,r,i){const a=Tr(t,"x","batchNorm"),o=Tr(e,"mean","batchNorm"),l=Tr(n,"variance","batchNorm");let u,h;return null!=r&&(u=Tr(r,"scale","batchNorm")),null!=s&&(h=Tr(s,"offset","batchNorm")),Kn(3===a.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${a.rank}.`)),Kn(3===o.rank||1===o.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${o.rank}.`)),Kn(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Zo(a,o,l,h,u,i)}}),Dr({batchNorm4d_:function(t,e,n,s,r,i){const a=Tr(t,"x","batchNorm"),o=Tr(e,"mean","batchNorm"),l=Tr(n,"variance","batchNorm");let u,h;return null!=r&&(u=Tr(r,"scale","batchNorm")),null!=s&&(h=Tr(s,"offset","batchNorm")),Kn(4===a.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${a.rank}.`)),Kn(4===o.rank||1===o.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${o.rank}.`)),Kn(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`)),null!=u&&Kn(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=h&&Kn(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Zo(a,o,l,h,u,i)}});const Yo=Dr({bincount_:function(t,e,n){const s=Tr(t,"x","bincount"),r=Tr(e,"weights","bincount");Kn("int32"===s.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${s.dtype}`)),Kn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Kn(r.size===s.size||0===r.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${s.shape}, weights shape: ${r.shape}.`));const i={x:s,weights:r},a={size:n};return Ir.runKernel("Bincount",i,a)}});function Xo(t,e="float32",n){return e=e||"float32",ls(t),new ur(t,e,n)}Dr({broadcastArgs_:function(t,e){const n=Tr(t,"s0","broadcastArgs","int32"),s=Tr(e,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==s.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${s.rank}`);const r={s0:n,s1:s};return Ir.runKernel("BroadcastArgs",r)}}),Dr({ceil_:function(t){const e={x:Tr(t,"x","ceil","float32")};return Ir.runKernel(Ee,e)}}),Dr({clipByValue_:function(t,e,n){const s=Tr(t,"x","clipByValue");Kn(e<=n,(()=>`Error in clip: min (${e}) must be less than or equal to max (${n}).`));const r={x:s},i={clipValueMin:e,clipValueMax:n};return Ir.runKernel(Ie,r,i)}}),Dr({concat1d_:function(t){return jo(t,0)}}),Dr({concat2d_:function(t,e){return jo(t,e)}}),Dr({concat3d_:function(t,e){return jo(t,e)}}),Dr({concat4d_:function(t,e){return jo(t,e)}}),Dr({conv1d_:function(t,e,n,s,r="NWC",i=1,a){const o=Tr(t,"x","conv1d"),l=Tr(e,"filter","conv1d");let u=o,h=!1;2===o.rank&&(h=!0,u=Zr(o,[1,o.shape[0],o.shape[1]])),Kn(3===u.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${u.rank}.`)),Kn(3===l.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${l.rank}.`)),gi("conv1d",s,a),Kn(u.shape[2]===l.shape[1],(()=>`Error in conv1d: depth of input (${u.shape[2]}) must match input depth for filter ${l.shape[1]}.`)),Kn(fi(n,i),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${i}'`)),Kn("NWC"===r,(()=>`Error in conv1d: got dataFormat of ${r} but only NWC is currently supported.`));const c=Zr(l,[1,l.shape[0],l.shape[1],l.shape[2]]),p=Zr(u,[u.shape[0],1,u.shape[1],u.shape[2]]),d=Pi(p,c,[1,n],s,"NHWC",[1,i],a);return Zr(d,h?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}}),Dr({conv2dTranspose_:function(t,e,n,s,r,i){const a=Tr(t,"x","conv2dTranspose"),o=Tr(e,"filter","conv2dTranspose");return Oi(n,a,o,s,r,"NHWC",i)}}),Dr({conv3d_:function(t,e,n,s,r="NDHWC",i=[1,1,1]){const a=Tr(t,"x","conv3d"),o=Tr(e,"filter","conv3d");let l=a,u=!1;4===a.rank&&(u=!0,l=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===l.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`)),Kn(5===o.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${o.rank}.`)),Kn(l.shape[4]===o.shape[3],(()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${o.shape[3]}.`)),Kn(fi(n,i),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),Kn("NDHWC"===r,(()=>`Error in conv3d: got dataFormat of ${r} but only NDHWC is currently supported.`));const h={x:l,filter:o},c={strides:n,pad:s,dataFormat:r,dilations:i},p=Ir.runKernel(Te,h,c);return u?Zr(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}}),Dr({conv3dTranspose_:function(t,e,n,s,r){const i=Tr(t,"x","conv3dTranspose"),a=Tr(e,"filter","conv3dTranspose");return Ki(n,i,a,s,r)}});const Qo=Dr({cos_:function(t){const e={x:Tr(t,"x","cos","float32")};return Ir.runKernel("Cos",e)}});const tl=Dr({cosh_:function(t){const e={x:Tr(t,"x","cosh","float32")};return Ir.runKernel(_e,e)}});const el=Dr({cumprod_:function(t,e=0,n=!1,s=!1){const r={x:Tr(t,"x","cumprod")},i={axis:e,exclusive:n,reverse:s};return Ir.runKernel("Cumprod",r,i)}});Dr({denseBincount_:function(t,e,n,s=!1){const r=Tr(t,"x","denseBincount"),i=Tr(e,"weights","denseBincount");Kn("int32"===r.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${r.dtype}`)),Kn(r.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${r.rank}.`)),Kn(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Kn(i.size===r.size||0===i.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${r.shape}, weights shape: ${i.shape}.`));const a={x:r,weights:i},o={size:n,binaryOutput:s};return Ir.runKernel("DenseBincount",a,o)}}),Dr({depthToSpace_:function(t,e,n="NHWC"){const s=Tr(t,"x","depthToSpace","float32"),r="NHWC"===n?s.shape[1]:s.shape[2],i="NHWC"===n?s.shape[2]:s.shape[3],a="NHWC"===n?s.shape[3]:s.shape[1];Kn(e>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${e}`)),Kn(r*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${r} and ${e}  for depthToSpace with input shape\n    ${s.shape}`)),Kn(i*e>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${i} and ${e} for depthToSpace with input shape\n        ${s.shape}`)),Kn(a%(e*e)==0,(()=>`Dimension size must be evenly divisible by ${e*e} but is ${a} for depthToSpace with input shape ${s.shape}`));const o={x:s},l={blockSize:e,dataFormat:n};return Ir.runKernel("DepthToSpace",o,l)}});const nl=Dr({depthwiseConv2d_:function(t,e,n,s,r="NHWC",i=[1,1],a){const o=Tr(t,"x","depthwiseConv2d","float32"),l=Tr(e,"filter","depthwiseConv2d","float32");let u=o,h=!1;3===o.rank&&(h=!0,u=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(4===u.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${u.rank}.`)),Kn(4===l.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${l.rank}.`));const c="NHWC"===r?u.shape[3]:u.shape[1];Kn(c===l.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${l.shape[2]}.`)),gi("depthwiseConv2d",s,a);const p={x:u,filter:l},d={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a},f=Ir.runKernel(Fe,p,d);return h?Zr(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});Dr({diag_:function(t){const e={x:Tr(t,"x","diag")};return Ir.runKernel("Diag",e)}}),Dr({dilation2d_:function(t,e,n,s,r=[1,1],i="NHWC"){const a=Tr(t,"x","dilation2d"),o=Tr(e,"filter","dilation2d");Kn(3===a.rank||4===a.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${a.rank}.`)),Kn(3===o.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${o.rank}.`)),Kn("NHWC"===i,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${i}`));let l=a,u=!1;3===a.rank&&(l=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2]]),u=!0);const h={x:l,filter:o},c={strides:n,pad:s,dilations:r},p=Ir.runKernel(Me,h,c);return u?Zr(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),Dr({divNoNan_:function(t,e){let n=Tr(t,"a","div"),s=Tr(e,"b","div");[n,s]=kr(n,s);const r=Br(n,s),i=ti(r),a=Ra(s,i);return _i(a,i,r)}}),Dr({dot_:function(t,e){const n=Tr(t,"t1","dot"),s=Tr(e,"t2","dot");Kn(!(1!==n.rank&&2!==n.rank||1!==s.rank&&2!==s.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${s.rank}.`));const r=1===n.rank?n.size:n.shape[1],i=1===s.rank?s.size:s.shape[0];if(Kn(r===i,(()=>`Error in dot: inner dimensions of inputs must match, but got ${r} and ${i}.`)),1===n.rank&&1===s.rank){const t=Zr(n,[1,-1]),e=Zr(s,[-1,1]),r=ki(t,e);return Zr(r,[])}if(1===n.rank&&2===s.rank){const t=Zr(n,[1,-1]),e=Zr(s,[s.shape[0],s.shape[1]]),r=ki(t,e);return Zr(r,[r.size])}if(2===n.rank&&1===s.rank){const t=Zr(s,[-1,1]),e=ki(n,t);return Zr(e,[e.size])}{const t=Zr(s,[s.shape[0],s.shape[1]]);return ki(n,t)}}}),Dr({einsum_:function(t,...e){const n=e.map(((t,e)=>Tr(t,`tensors${e}`,"einsum"))),s={equation:t};return Ir.runKernel("Einsum",n,s)}});const sl=Dr({elu_:function(t){const e={x:Tr(t,"x","elu","float32")};return Ir.runKernel("Elu",e)}});Dr({erf_:function(t){let e=Tr(t,"x","erf");Kn("int32"===e.dtype||"float32"===e.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===e.dtype&&(e=Fr(e,"float32"));const n={x:e};return Ir.runKernel("Erf",n)}});const rl=Dr({max_:function(t,e=null,n=!1){const s={x:Tr(t,"x","max")},r={reductionIndices:e,keepDims:n};return Ir.runKernel("Max",s,r)}});const il=Dr({min_:function(t,e=null,n=!1){const s={x:Tr(t,"x","min")},r={axis:e,keepDims:n};return Ir.runKernel("Min",s,r)}});function al(t,e,n=null){if(0===t.rank)return Vo(t);if(1!==t.rank&&null===n)return al(Zr(t,[-1]),e,n);if(1===t.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===e)return Yr(Vo(t),n);if(e===1/0)return rl(Vo(t),n);if(e===-1/0)return il(Vo(t),n);if("euclidean"===e||2===e)return Kr(Yr(uo(Vo(t),Ur(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}if(Array.isArray(n)&&2===n.length){if(1===e)return rl(Yr(Vo(t),n[0]),n[1]-1);if(e===1/0)return rl(Yr(Vo(t),n[1]),n[0]);if(e===-1/0)return il(Yr(Vo(t),n[1]),n[0]);if("fro"===e||"euclidean"===e)return Kr(Yr(Vr(t),n));throw new Error(`Error in norm: invalid ord value: ${e}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const ol=Dr({norm_:function(t,e="euclidean",n=null,s=!1){const r=al(t=Tr(t,"x","norm"),e,n);let i=r.shape;if(s){const e=Yn(n,t.shape);i=Ji(r.shape,e)}return Zr(r,i)}});Dr({euclideanNorm_:function(t,e=null,n=!1){return ol(t,"euclidean",e,n)}});const ll=Dr({expandDims_:function(t,e=0){const n=Tr(t,"x","expandDims","string_or_numeric");Kn(e<=n.rank,(()=>"Axis must be <= rank of the tensor"));const s={input:n},r={dim:e};return Ir.runKernel(Re,s,r)}});Dr({expm1_:function(t){const e={x:Tr(t,"x","expm1")};return Ir.runKernel(Oe,e)}});const ul=Dr({eye_:function(t,e,n,s="float32"){null==e&&(e=t);const r=Xo([t,e],s),i=t<=e?t:e;for(let t=0;t<i;++t)r.set(1,t,t);const a=Zr(r.toTensor(),[t,e]);if(null==n)return a;if(1===n.length)return wa(ll(a,0),[n[0],1,1]);if(2===n.length)return wa(ll(ll(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return wa(ll(ll(ll(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function hl(t,e,n){const s={shape:t,value:e,dtype:n};return Ir.runKernel("Fill",{},s)}const cl=Dr({gather_:function(t,e,n=0,s=0){const r={x:Tr(t,"x","gather"),indices:Tr(e,"indices","gather","int32")},i={axis:n,batchDims:s};return Ir.runKernel(Ue,r,i)}});Dr({isFinite_:function(t){const e={x:Tr(t,"x","isFinite")};return Ir.runKernel(qe,e)}}),Dr({isInf_:function(t){const e={x:Tr(t,"x","isInf")};return Ir.runKernel(je,e)}}),Dr({isNaN_:function(t){const e={x:Tr(t,"x","isNaN")};return Ir.runKernel(Ge,e)}});const pl=Dr({leakyRelu_:function(t,e=.2){const n={x:Tr(t,"x","leakyRelu")},s={alpha:e};return Ir.runKernel(He,n,s)}});Dr({localResponseNormalization_:function(t,e=5,n=1,s=1,r=.5){const i=Tr(t,"x","localResponseNormalization");Kn(4===i.rank||3===i.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${i.rank}.`)),Kn(Jn(e),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${e}.`));let a=i,o=!1;3===i.rank&&(o=!0,a=Zr(i,[1,i.shape[0],i.shape[1],i.shape[2]]));const l={x:a},u={depthRadius:e,bias:n,alpha:s,beta:r},h=Ir.runKernel("LRN",l,u);return o?Zr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const dl=Dr({log1p_:function(t){const e={x:Tr(t,"x","log1p")};return Ir.runKernel(Je,e)}});function fl(t){return Ir.customGrad(t)}const gl=Dr({softplus_:function(t){const e={x:Tr(t,"x","softplus")};return Ir.runKernel(En,e)}});Dr({logSigmoid_:function(t){const e=Tr(t,"x","logSigmoid"),n=fl((t=>({value:Pr(gl(Pr(t))),gradFunc:e=>Mr(e,Go(Pr(t)))})));return n(e)}}),Dr({logSoftmax_:function(t,e=-1){const n=Tr(t,"logits","logSoftmax");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${e}`);const s=fl(((t,n)=>{const s=rl(t,e,!0),r=qr(t,s),i=qr(Fr(r,"float32"),lo(Yr(ca(r),e,!0)));n([i]);return{value:i,gradFunc:(t,n)=>{const[s]=n,r=ca(s);return qr(t,Mr(Yr(t,e,!0),r))}}}));return s(n)}});const ml=Dr({logSumExp_:function(t,e=null,n=!1){const s=Tr(t,"x","logSumExp"),r=Yn(e,s.shape),i=rl(s,r,!0),a=qr(s,i),o=ca(a),l=Yr(o,r),u=lo(l),h=ri(Zr(i,u.shape),u);if(n){const t=Ji(h.shape,r);return Zr(h,t)}return h}});const bl=Dr({logicalNot_:function(t){const e={x:Tr(t,"x","logicalNot","bool")};return Ir.runKernel("LogicalNot",e)}});const yl=Dr({logicalOr_:function(t,e){const n=Tr(t,"a","logicalOr","bool"),s=Tr(e,"b","logicalOr","bool");Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("LogicalOr",r)}});Dr({logicalXor_:function(t,e){const n=Tr(t,"a","logicalXor","bool"),s=Tr(e,"b","logicalXor","bool");return Jr(n.shape,s.shape),zi(yl(t,e),bl(zi(t,e)))}});const wl=2147483648;Dr({searchSorted_:function(t,e,n="left"){const s=Tr(t,"sortedSequence","searchSorted"),r=Tr(e,"values","searchSorted"),i=s.shape[s.shape.length-1],a=r.shape[r.shape.length-1],o=Zr(s,[-1,i]),l=Zr(r,[-1,a]);if(o.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(o.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(Gn(l.shape)>=wl)throw new Error("values tensor size must less than 2147483648");if(o.shape[1]>=wl)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${o.shape[1]}`);const u={sortedSequence:o,values:l},h={side:n};return Ir.runKernel("SearchSorted",u,h)}});const kl=Dr({maxPool_:function(t,e,n,s,r){const i=Tr(t,"x","maxPool");let a=i,o=!1;3===i.rank&&(o=!0,a=Zr(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Kn(4===a.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${a.rank}.`)),Kn(fi(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),gi("maxPool",s,r);const l={x:a},u={filterSize:e,strides:n,pad:s,dimRoundingMode:r},h=Ir.runKernel(Ye,l,u);return o?Zr(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});Dr({maxPool3d_:function(t,e=[1,1,1],n,s,r,i="NDHWC"){const a=Tr(t,"x","maxPool3d");let o=a,l=!1;4===a.rank&&(l=!0,o=Zr(a,[1,a.shape[0],a.shape[1],a.shape[2],a.shape[3]])),Kn(5===o.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${o.rank}.`)),Kn("NDHWC"===i,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${i}`)),gi("maxPool3d",s,r);const u={x:o},h={filterSize:e,strides:n,pad:s,dimRoundingMode:r,dataFormat:i},c=Ir.runKernel(Xe,u,h);return l?Zr(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}}),Dr({maxPoolWithArgmax_:function(t,e,n,s,r=!1){const i={x:Tr(t,"x","maxPoolWithArgmax")},a={filterSize:e,strides:n,pad:s,includeBatchInIndex:r},o=Ir.runKernel("MaxPoolWithArgmax",i,a);return{result:o[0],indexes:o[1]}}});const vl=Dr({maximum_:function(t,e){let n=Tr(t,"a","maximum"),s=Tr(e,"b","maximum");[n,s]=kr(n,s),"bool"===n.dtype&&(n=Fr(n,"int32"),s=Fr(s,"int32")),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel(Ze,r)}});const xl=Dr({mean_:function(t,e=null,n=!1){const s={x:Tr(t,"x","mean")},r={axis:e,keepDims:n};return Ir.runKernel(Qe,s,r)}});const Sl=Dr({minimum_:function(t,e){let n=Tr(t,"a","minimum"),s=Tr(e,"b","minimum");[n,s]=kr(n,s),"bool"===n.dtype&&(n=Fr(n,"int32"),s=Fr(s,"int32")),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel(tn,r)}});Dr({mirrorPad_:function(t,e,n){Kn("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const s=Tr(t,"x","mirrorPad");if(0===s.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");Kn(e.length===s.rank,(()=>`Padding doesn't match input. Must be ${s.rank}. Got ${e.length}.`));const r="reflect"===n?1:0;for(let t=0;t<s.rank;t++)Kn(2===e[t].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Kn(e[t][0]>=0&&e[t][0]<=s.shape[t]-r&&e[t][1]>=0&&e[t][1]<=s.shape[t]-r,(()=>`Padding in dimension ${t} cannot be greater than or equal to ${s.shape[t]-r} or less than 0 for input of shape ${s.shape}`));const i={paddings:e,mode:n},a={x:s};return Ir.runKernel(en,a,i)}}),Dr({mod_:function(t,e){let n=Tr(t,"a","mod"),s=Tr(e,"b","mod");[n,s]=kr(n,s);const r={a:n,b:s};return Ir.runKernel("Mod",r)}}),Dr({moments_:function(t,e=null,n=!1){const s=Yn(e,(t=Tr(t,"x","moments")).shape),r=xl(t,s,n);let i=r.shape;n||(i=Ji(r.shape,s));const a=Vr(qr(Fr(t,"float32"),Zr(r,i)));return{mean:r,variance:xl(a,s,n)}}}),Dr({multiRNNCell_:function(t,e,n,s){const r=Tr(e,"data","multiRNNCell"),i=_r(n,"c","multiRNNCell"),a=_r(s,"h","multiRNNCell");let o=r;const l=[];for(let e=0;e<t.length;e++){const n=t[e](o,i[e],a[e]);l.push(n[0]),l.push(n[1]),o=n[1]}const u=[],h=[];for(let t=0;t<l.length;t+=2)u.push(l[t]),h.push(l[t+1]);return[u,h]}}),Dr({multinomial_:function(t,e,n,s=!1){const r=Tr(t,"logits","multinomial"),i=r.size,a=r.rank;if(i<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${i}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const o={logits:1===a?Zr(r,[1,-1]):r},l={numSamples:e,seed:n,normalized:s},u=Ir.runKernel("Multinomial",o,l);return 1===a?Zr(u,[u.size]):u}});const Nl=Dr({notEqual_:function(t,e){let n=Tr(t,"a","notEqual","string_or_numeric"),s=Tr(e,"b","notEqual","string_or_numeric");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel("NotEqual",r)}});Dr({onesLike_:function(t){const e={x:Tr(t,"x","onesLike")};return Ir.runKernel(sn,e)}}),Dr({outerProduct_:function(t,e){const n=Tr(t,"v1","outerProduct"),s=Tr(e,"v2","outerProduct");Kn(1===n.rank&&1===s.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${s.rank}.`));const r=Zr(n,[-1,1]),i=Zr(s,[1,-1]);return ki(r,i)}});const El=Dr({pad_:function(t,e,n=0){const s=Tr(t,"x","pad");if(0===s.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const r={paddings:e,constantValue:n},i={x:s};return Ir.runKernel(on,i,r)}});Dr({pad1d_:function(t,e,n=0){return Kn(2===e.length,(()=>"Invalid number of paddings. Must be length of 2.")),El(t,[e],n)}}),Dr({pad2d_:function(t,e,n=0){return Kn(2===e.length&&2===e[0].length&&2===e[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),El(t,e,n)}}),Dr({pad3d_:function(t,e,n=0){return Kn(3===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),El(t,e,n)}}),Dr({pad4d_:function(t,e,n=0){return Kn(4===e.length&&2===e[0].length&&2===e[1].length&&2===e[2].length&&2===e[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),El(t,e,n)}}),Dr({pool_:function(t,e,n,s,r,i,a){null==r&&(r=[1,1]),null==i&&(i=1),0===s&&(s="valid");const o=Tr(t,"x","maxPool");let l=o,u=!1;3===o.rank&&(u=!0,l=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),Kn(fi(i,r),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${i} and dilations '${r}'`));const h=function(t,e,n,s,r,i,a="channelsLast"){const[o,l]=hi(e);let u;if("channelsLast"===a)u=[o,l,t[3],t[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[o,l,t[1],t[1]]}return ui(t,u,n,s,r,i,!1,a)}(l.shape,e,i,r,s),c=[h.dilationHeight,h.dilationWidth];let p;p="same"===s?function(t,e){const n=t.map(((t,n)=>t+(t-1)*(e[n]-1))).map((t=>t-1)),s=n.map((t=>Math.floor(t/2))),r=n.map(((t,e)=>t-s[e]));return n.map(((t,e)=>[s[e],r[e]]))}([h.filterHeight,h.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[f,g]=function(t,e,n){const s=n.map((t=>t[0])),r=n.map((t=>t[1])),i=t.concat(s,r),a=e.map(((t,e)=>(t-i[e]%t)%t)),o=r.map(((t,e)=>t+a[e])),l=e.map(((t,e)=>[s[e],o[e]])),u=e.map(((t,e)=>[0,a[e]]));return[l,u]}([h.inHeight,h.inWidth],c,p),m=d?s:"valid",b=d?l:xi(l,c,f),y=("avg"===n?()=>qo(b,e,i,m,a):()=>kl(b,e,i,m,a))(),w=d?y:Jo(y,c,g);return u?Zr(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Il=Dr({prelu_:function(t,e){const n={x:Tr(t,"x","prelu"),alpha:Tr(e,"alpha","prelu")};return Ir.runKernel(ln,n)}});Dr({prod_:function(t,e=null,n=!1){let s=Tr(t,"x","prod");"bool"===s.dtype&&(s=Fr(s,"int32"));const r={x:s},i={axis:e,keepDims:n};return Ir.runKernel(un,r,i)}}),Dr({rand_:function(t,e,n){const s=Gn(t);let r=null;if(null==n||"float32"===n)r=new Float32Array(s);else if("int32"===n)r=new Int32Array(s);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);r=new Uint8Array(s)}for(let t=0;t<s;t++)r[t]=e();return Ir.makeTensor(r,t,n)}});var Al="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function $l(t){if(t.__esModule)return t;var e=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(t).forEach((function(n){var s=Object.getOwnPropertyDescriptor(t,n);Object.defineProperty(e,n,s.get?s:{enumerable:!0,get:function(){return t[n]}})})),e}function zl(t){var e={exports:{}};return t(e,e.exports),e.exports}var Cl=zl((function(t){!function(t,e,n){function s(t){var e,n=this,s=(e=4022871197,function(t){t=String(t);for(var n=0;n<t.length;n++){var s=.02519603282416938*(e+=t.charCodeAt(n));s-=e=s>>>0,e=(s*=e)>>>0,e+=4294967296*(s-=e)}return 2.3283064365386963e-10*(e>>>0)});n.next=function(){var t=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=t-(n.c=0|t)},n.c=1,n.s0=s(" "),n.s1=s(" "),n.s2=s(" "),n.s0-=s(t),n.s0<0&&(n.s0+=1),n.s1-=s(t),n.s1<0&&(n.s1+=1),n.s2-=s(t),n.s2<0&&(n.s2+=1),s=null}function r(t,e){return e.c=t.c,e.s0=t.s0,e.s1=t.s1,e.s2=t.s2,e}function i(t,e){var n=new s(t),i=e&&e.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.alea=i}(0,t,!1)})),Tl=zl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.x=0,e.y=0,e.z=0,e.w=0,e.next=function(){var t=e.x^e.x<<11;return e.x=e.y,e.y=e.z,e.z=e.w,e.w^=e.w>>>19^t^t>>>8},t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor128=i}(0,t,!1)})),_l=zl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.x^e.x>>>2;return e.x=e.y,e.y=e.z,e.z=e.w,e.w=e.v,(e.d=e.d+362437|0)+(e.v=e.v^e.v<<4^t^t<<1)|0},e.x=0,e.y=0,e.z=0,e.w=0,e.v=0,t===(0|t)?e.x=t:n+=t;for(var s=0;s<n.length+64;s++)e.x^=0|n.charCodeAt(s),s==n.length&&(e.d=e.x<<10^e.x>>>4),e.next()}function r(t,e){return e.x=t.x,e.y=t.y,e.z=t.z,e.w=t.w,e.v=t.v,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorwow=i}(0,t,!1)})),Dl=zl((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.x,r=e.i;return t=s[r],n=(t^=t>>>7)^t<<24,n^=(t=s[r+1&7])^t>>>10,n^=(t=s[r+3&7])^t>>>3,n^=(t=s[r+4&7])^t<<7,t=s[r+7&7],n^=(t^=t<<13)^t<<9,s[r]=n,e.i=r+1&7,n},function(t,e){var n,s=[];if(e===(0|e))s[0]=e;else for(e=""+e,n=0;n<e.length;++n)s[7&n]=s[7&n]<<15^e.charCodeAt(n)+s[n+1&7]<<13;for(;s.length<8;)s.push(0);for(n=0;n<8&&0===s[n];++n);for(8==n&&(s[7]=-1),t.x=s,t.i=0,n=256;n>0;--n)t.next()}(e,t)}function r(t,e){return e.x=t.x.slice(),e.i=t.i,e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.x&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xorshift7=i}(0,t,!1)})),Fl=zl((function(t){!function(t,e,n){function s(t){var e=this;e.next=function(){var t,n,s=e.w,r=e.X,i=e.i;return e.w=s=s+1640531527|0,n=r[i+34&127],t=r[i=i+1&127],n^=n<<13,t^=t<<17,n^=n>>>15,t^=t>>>12,n=r[i]=n^t,e.i=i,n+(s^s>>>16)|0},function(t,e){var n,s,r,i,a,o=[],l=128;for(e===(0|e)?(s=e,e=null):(e+="\0",s=0,l=Math.max(l,e.length)),r=0,i=-32;i<l;++i)e&&(s^=e.charCodeAt((i+32)%e.length)),0===i&&(a=s),s^=s<<10,s^=s>>>15,s^=s<<4,s^=s>>>13,i>=0&&(a=a+1640531527|0,r=0==(n=o[127&i]^=s+a)?r+1:0);for(r>=128&&(o[127&(e&&e.length||0)]=-1),r=127,i=512;i>0;--i)s=o[r+34&127],n=o[r=r+1&127],s^=s<<13,n^=n<<17,s^=s>>>15,n^=n>>>12,o[r]=s^n;t.w=a,t.X=o,t.i=r}(e,t)}function r(t,e){return e.i=t.i,e.w=t.w,e.X=t.X.slice(),e}function i(t,e){null==t&&(t=+new Date);var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&(i.X&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.xor4096=i}(0,t,!1)})),Ml=zl((function(t){!function(t,e,n){function s(t){var e=this,n="";e.next=function(){var t=e.b,n=e.c,s=e.d,r=e.a;return t=t<<25^t>>>7^n,n=n-s|0,s=s<<24^s>>>8^r,r=r-t|0,e.b=t=t<<20^t>>>12^n,e.c=n=n-s|0,e.d=s<<16^n>>>16^r,e.a=r-t|0},e.a=0,e.b=0,e.c=-1640531527,e.d=1367130551,t===Math.floor(t)?(e.a=t/4294967296|0,e.b=0|t):n+=t;for(var s=0;s<n.length+20;s++)e.b^=0|n.charCodeAt(s),e.next()}function r(t,e){return e.a=t.a,e.b=t.b,e.c=t.c,e.d=t.d,e}function i(t,e){var n=new s(t),i=e&&e.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var t=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===t);return t},a.int32=n.next,a.quick=a,i&&("object"==typeof i&&r(i,n),a.state=function(){return r(n,{})}),a}e&&e.exports?e.exports=i:n&&n.amd?n((function(){return i})):this.tychei=i}(0,t,!1)})),Ll=$l({__proto__:null,default:{}}),Rl=zl((function(t){!function(e,n,s){var r,i=256,a=s.pow(i,6),o=s.pow(2,52),l=2*o,u=255;function h(t,u,h){var m=[],b=f(d((u=1==u?{entropy:!0}:u||{}).entropy?[t,g(n)]:null==t?function(){try{var t;return r&&(t=r.randomBytes)?t=t(i):(t=new Uint8Array(i),(e.crypto||e.msCrypto).getRandomValues(t)),g(t)}catch(t){var s=e.navigator,a=s&&s.plugins;return[+new Date,e,a,e.screen,g(n)]}}():t,3),m),y=new c(m),w=function(){for(var t=y.g(6),e=a,n=0;t<o;)t=(t+n)*i,e*=i,n=y.g(1);for(;t>=l;)t/=2,e/=2,n>>>=1;return(t+n)/e};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,f(g(y.S),n),(u.pass||h||function(t,e,n,r){return r&&(r.S&&p(r,y),t.state=function(){return p(y,{})}),n?(s.random=t,e):t})(w,b,"global"in u?u.global:this==s,u.state)}function c(t){var e,n=t.length,s=this,r=0,a=s.i=s.j=0,o=s.S=[];for(n||(t=[n++]);r<i;)o[r]=r++;for(r=0;r<i;r++)o[r]=o[a=u&a+t[r%n]+(e=o[r])],o[a]=e;(s.g=function(t){for(var e,n=0,r=s.i,a=s.j,o=s.S;t--;)e=o[r=u&r+1],n=n*i+o[u&(o[r]=o[a=u&a+e])+(o[a]=e)];return s.i=r,s.j=a,n})(i)}function p(t,e){return e.i=t.i,e.j=t.j,e.S=t.S.slice(),e}function d(t,e){var n,s=[],r=typeof t;if(e&&"object"==r)for(n in t)try{s.push(d(t[n],e-1))}catch(t){}return s.length?s:"string"==r?t:t+"\0"}function f(t,e){for(var n,s=t+"",r=0;r<s.length;)e[u&r]=u&(n^=19*e[u&r])+s.charCodeAt(r++);return g(e)}function g(t){return String.fromCharCode.apply(0,t)}if(f(s.random(),n),t.exports){t.exports=h;try{r=Ll}catch(t){}}else s.seedrandom=h}("undefined"!=typeof self?self:Al,[],Math)}));Rl.alea=Cl,Rl.xor128=Tl,Rl.xorwow=_l,Rl.xorshift7=Dl,Rl.xor4096=Fl,Rl.tychei=Ml;var Ol=Rl;class Bl{constructor(t,e,n,s,r){this.mean=t,this.stdDev=e,this.dtype=n,this.nextVal=NaN,this.truncated=s,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const i=r||Math.random();this.random=Ol.alea(i.toString())}nextValue(){if(!isNaN(this.nextVal)){const t=this.nextVal;return this.nextVal=NaN,t}let t,e,n=!1;for(;!n;){let s,r,i;do{s=2*this.random()-1,r=2*this.random()-1,i=s*s+r*r}while(i>=1||0===i);const a=Math.sqrt(-2*Math.log(i)/i);t=this.mean+this.stdDev*s*a,e=this.mean+this.stdDev*r*a,this.truncated&&!this.isValidTruncated(t)||(n=!0)}return this.truncated&&!this.isValidTruncated(e)||(this.nextVal=this.convertValue(e)),this.convertValue(t)}convertValue(t){return null==this.dtype||"float32"===this.dtype?t:Math.round(t)}isValidTruncated(t){return t<=this.upper&&t>=this.lower}}class Pl{constructor(t,e,n,s){this.alpha=t,this.beta=1/e,this.dtype=n;const r=s||Math.random();this.randu=Ol.alea(r.toString()),this.randn=new Bl(0,1,n,!1,this.randu()),this.d=t<1?t+2/3:t-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let t,e,n,s,r,i;for(;;){do{s=this.randn.nextValue(),i=1+this.c*s}while(i<=0);if(i*=i*i,t=s*s,e=1-.331*t*t,n=.5*t+this.d*(1-i+Math.log(i)),r=this.randu(),r<e||Math.log(r)<n)break}return i=1/this.beta*this.d*i,this.alpha<1&&(i*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(i)}convertValue(t){return"float32"===this.dtype?t:Math.round(t)}}class Wl{constructor(t=0,e=1,n,s){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=t,this.range=e-t,this.dtype=n,null==s&&(s=Math.random()),"number"==typeof s&&(s=s.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${t} - ${e} <= 1 and dtype is not float`);this.random=Ol.alea(s)}convertValue(t){return this.canReturnFloat()?t:Math.round(t)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}Dr({randomGamma_:function(t,e,n=1,s="float32",r){if(null==n&&(n=1),null==s&&(s="float32"),"float32"!==s&&"int32"!==s)throw new Error(`Unsupported data type ${s}`);const i=new Pl(e,n,s,r),a=Xo(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});const Ul=Dr({randomNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error(`Unsupported data type ${s}`);const i=new Bl(e,n,s,!1,r),a=Xo(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}});Dr({randomStandardNormal_:function(t,e,n){if(null!=e&&"bool"===e)throw new Error(`Unsupported data type ${e}`);return Ul(t,0,1,e,n)}});const Kl=Dr({randomUniform_:function(t,e=0,n=1,s="float32",r){const i=Xo(t,s),a=new Wl(e,n,null,r);for(let t=0;t<i.values.length;t++)i.values[t]=a.nextValue();return i.toTensor()}});function Vl(t,e,n=1,s="float32"){if(0===n)throw new Error("Cannot have a step of zero");const r={start:t,stop:e,step:n,dtype:s};return Ir.runKernel("Range",{},r)}Dr({reciprocal_:function(t){const e={x:Tr(t,"x","reciprocal")};return Ir.runKernel(hn,e)}});const ql=Dr({relu_:function(t){const e={x:Tr(t,"x","relu")};return Ir.runKernel(cn,e)}});const jl=Dr({relu6_:function(t){const e={x:Tr(t,"x","relu6")};return Ir.runKernel(gn,e)}});const Gl=Dr({reverse_:function(t,e){const n={x:Tr(t,"x","reverse")},s={dims:e};return Ir.runKernel(mn,n,s)}});Dr({reverse1d_:function(t){const e=Tr(t,"x","reverse");return Kn(1===e.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${e.rank}.`)),Gl(e,0)}}),Dr({reverse2d_:function(t,e){const n=Tr(t,"x","reverse");return Kn(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),Gl(n,e)}}),Dr({reverse3d_:function(t,e){const n=Tr(t,"x","reverse");return Kn(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),Gl(n,e)}}),Dr({reverse4d_:function(t,e){const n=Tr(t,"x","reverse");return Kn(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),Gl(n,e)}});const Hl=Dr({round_:function(t){const e={x:Tr(t,"x","round")};return Ir.runKernel(bn,e)}});Dr({selu_:function(t){const e={x:Tr(t,"x","selu")};return Ir.runKernel(kn,e)}}),Dr({separableConv2d_:function(t,e,n,s,r,i=[1,1],a="NHWC"){const o=Tr(t,"x","separableConv2d"),l=Tr(e,"depthwiseFilter","separableConv2d"),u=Tr(n,"pointwiseFilter","separableConv2d");let h=o,c=!1;if(3===o.rank&&(c=!0,h=Zr(o,[1,o.shape[0],o.shape[1],o.shape[2]])),"NCHW"===a)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");Kn(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),Kn(4===l.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`)),Kn(4===u.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`)),Kn(1===u.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${u.shape[0]}.`)),Kn(1===u.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${u.shape[1]}.`));const p=l.shape[2],d=l.shape[3];Kn(u.shape[2]===p*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*d}, but got ${u.shape[2]}.`));const f=nl(h,l,s,r,a,i),g=Pi(f,u,1,"valid",a);return c?Zr(g,[g.shape[1],g.shape[2],g.shape[3]]):g}}),Dr({sign_:function(t){const e={x:Tr(t,"x","sign")};return Ir.runKernel(Sn,e)}}),Dr({slice1d_:function(t,e,n){const s=Tr(t,"x","slice1d");return Kn(1===s.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${s.rank} tensor`)),Ya(s,[e],[n])}}),Dr({slice2d_:function(t,e,n){const s=Tr(t,"x","slice2d");return Kn(2===s.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${s.rank} tensor`)),Ya(s,e,n)}}),Dr({slice3d_:function(t,e,n){const s=Tr(t,"x","slice3d");return Kn(3===s.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${s.rank} tensor`)),Ya(s,e,n)}}),Dr({slice4d_:function(t,e,n){const s=Tr(t,"x","slice4d");return Kn(4===s.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${s.rank} tensor`)),Ya(s,e,n)}}),Dr({softmax_:function(t,e=-1){const n=Tr(t,"logits","softmax","float32");if(-1===e&&(e=n.rank-1),e!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${e}`);const s={logits:n},r={dim:e};return Ir.runKernel(zn,s,r)}});const Jl=Dr({fft_:function(t){Kn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ir.runKernel("FFT",e)}});const Zl=Dr({ifft_:function(t){Kn("complex64"===t.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${t.dtype}.`));const e={input:t};return Ir.runKernel("IFFT",e)}});Dr({irfft_:function(t){const e=t.shape[t.shape.length-1],n=t.size/e;let s;if(e<=2){const r=Zr(t,[n,e]);s=Zl(r)}else{const r=[n,2*(e-1)],i=Zr(sa(t),[n,e]),a=Zr(na(t),[n,e]),o=Gl(Ya(i,[0,1],[n,e-2]),1),l=Mr(Gl(Ya(a,[0,1],[n,e-2]),1),Ur(-1)),u=jo([i,o],1),h=jo([a,l],1),c=Zr(ea(u,h),[r[0],r[1]]);s=Zl(c)}if(s=sa(s),3===t.rank&&0!==t.shape[0]){const e=s,n=t.shape[0];s=Zr(s,[n,s.shape[0]/n,s.shape[1]]),e.dispose()}return s}});const Yl=Dr({rfft_:function(t,e){Kn("float32"===t.dtype,(()=>`The dtype for rfft() must be real value but got ${t.dtype}`));let n=t.shape[t.shape.length-1];const s=t.size/n;let r;if(null!=e&&e<n){const s=t.shape.map((t=>0)),i=t.shape.map((t=>t));i[t.shape.length-1]=e,r=Ya(t,s,i),n=e}else if(null!=e&&e>n){const s=t.shape.map((t=>t));s[t.shape.length-1]=e-n,r=jo([t,ja(s)],t.shape.length-1),n=e}else r=t;const i=ti(r),a=Zr(ea(r,i),[s,n]),o=Jl(a),l=Math.floor(n/2)+1,u=sa(o),h=na(o),c=Mi(u,[l,n-l],u.shape.length-1),p=Mi(h,[l,n-l],h.shape.length-1),d=r.shape.slice();return d[r.shape.length-1]=l,Zr(ea(c[0],p[0]),d)}});const Xl=Dr({squaredDifference_:function(t,e){let n=Tr(t,"a","squaredDifference"),s=Tr(e,"b","squaredDifference");[n,s]=kr(n,s),Jr(n.shape,s.shape);const r={a:n,b:s};return Ir.runKernel(Cn,r,{})}});const Ql=Dr({squeeze_:function(t,e){const n=Tr(t,"x","squeeze","string_or_numeric");return Zr(n,function(t,e){const n=[],s=[],r=null!=e&&Array.isArray(e)&&0===e.length,i=null==e||r?null:Yn(e,t).sort();let a=0;for(let e=0;e<t.length;++e){if(null!=i){if(i[a]===e&&1!==t[e])throw new Error(`Can't squeeze axis ${e} since its dim '${t[e]}' is not 1`);(null==i[a]||i[a]>e)&&1===t[e]&&(n.push(t[e]),s.push(e)),i[a]<=e&&a++}1!==t[e]&&(n.push(t[e]),s.push(e))}return{newShape:n,keptDims:s}}(n.shape,e).newShape)}});const tu=Dr({stack_:function(t,e=0){const n=_r(t,"tensors","stack","string_or_numeric");Kn(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&Kn(e<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const s=n,r={axis:e};return Ir.runKernel(an,s,r)}});function eu(t,e){qn(t);const n=$r(t,e);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Wr(t,null,n,e)}function nu(t,e,n){if(qn(t),null!=e&&2!==e.length)throw new Error("tensor2d() requires shape to have two numbers");const s=$r(t,n);if(2!==s.length&&1!==s.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===s.length&&null==e)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Wr(t,e,s,n)}function su(t,e,n){const s=1-t%2,r=new Float32Array(t);for(let i=0;i<t;++i){const a=2*Math.PI*i/(t+s-1);r[i]=e-n*Math.cos(a)}return eu(r,"float32")}function ru(t,e,n){if(null==n||"linear"===n)return t;if("relu"===n)return Mr(t,Lr(e));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function iu(t,e){let n=e;const s=Hr(t.shape,e.shape);return s.length>0&&(n=Yr(n,s)),Zr(n,t.shape)}function au(t,e,n,s){if("linear"===e)return t;if("relu"===e)return ql(t);if("elu"===e)return sl(t);if("relu6"===e)return jl(t);if("prelu"===e)return Il(t,n);if("leakyrelu"===e)return pl(t,s);if("sigmoid"===e)return Go(t);throw new Error(`Unknown fused activation ${e}.`)}Dr({stridedSlice_:function(t,e,n,s,r=0,i=0,a=0,o=0,l=0){const u={x:Tr(t,"x","stridedSlice","string_or_numeric")},h={begin:e,end:n,strides:s,beginMask:r,endMask:i,ellipsisMask:a,newAxisMask:o,shrinkAxisMask:l};return Ir.runKernel("StridedSlice",u,h)}}),Dr({tan_:function(t){const e={x:Tr(t,"x","tan","float32")};return Ir.runKernel("Tan",e)}}),Dr({topk_:function(t,e=1,n=!0){const s=Tr(t,"x","topk");if(0===s.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const r=s.shape[s.shape.length-1];if(e<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${e}`);if(e>r)throw new Error(`'k' passed to topk() must be <= the last dimension (${r}) but got ${e}`);const i={x:s},a={k:e,sorted:n},[o,l]=Ir.runKernel("TopK",i,a);return{values:o,indices:l}}}),Dr({truncatedNormal_:function(t,e=0,n=1,s,r){if(null!=s&&"bool"===s)throw new Error("Unsupported data type $ { dtype }");const i=new Bl(e,n,s,!0,r),a=Xo(t,s);for(let t=0;t<a.values.length;t++)a.values[t]=i.nextValue();return a.toTensor()}}),Dr({unique_:function(t,e=0){const n=Tr(t,"x","unique","string_or_numeric");Kn(n.rank>0,(()=>"The input tensor must be at least 1D"));const s={x:n},r={axis:e},[i,a]=Ir.runKernel("Unique",s,r);return{values:i,indices:a}}}),Dr({movingAverage_:function(t,e,n,s,r=!0){const i=Tr(t,"v","movingAverage"),a=Tr(e,"x","movingAverage"),o=Tr(n,"decay","movingAverage");var l,u;u=a,Kn((l=i).dtype===u.dtype,(()=>`The dtypes of the first(${l.dtype}) and second(${u.dtype}) input must match`)),Kn(Hn(i.shape,a.shape),(()=>"Shape mismatch in v and x"));const h=Ur(1),c=qr(h,o);let p=Mr(qr(a,i),c);if(r){Kn(null!=s,(()=>"When using zeroDebias: true, step is required."));const t=Tr(s,"step","movingAverage");p=Br(p,qr(h,uo(o,t)))}return ri(i,p)}}),Dr({scatterND_:function(t,e,n){const s=Tr(t,"indices","scatterND","int32"),r=Tr(e,"updates","scatterND");Wo(r,s,n);const i={indices:s,updates:r},a={shape:n};return Ir.runKernel("ScatterNd",i,a)}}),Dr({sparseToDense_:function(t,e,n,s=0){const r=Tr(t,"sparseIndices","sparseToDense","int32"),i=Tr(e,"sparseValues","sparseToDense","string_or_numeric"),a=Tr(s,"defaultValue","sparseToDense",i.dtype);!function(t,e,n,s){if("int32"!==t.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${t.shape}.`);const r=t.rank>0?t.shape[0]:1,i=t.rank>1?t.shape[1]:1;if(n.length!==i)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${i}.`);const a=e.size;if(0!==e.rank&&(1!==e.rank||a!==r))throw new Error(`sparseValues has incorrect shape ${e.shape}, should be [] or [${r}]`);if(e.dtype!==s.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(r,i,n,a);const o={sparseIndices:r,sparseValues:i,defaultValue:a},l={outputShape:n};return Ir.runKernel("SparseToDense",o,l)}}),Dr({gatherND_:function(t,e){const n=Tr(e,"indices","gatherND","int32"),s={params:Tr(t,"x","gatherND","string_or_numeric"),indices:n};return Ir.runKernel("GatherNd",s)}}),Dr({dropout_:function(t,e,n,s){const r=Tr(t,"x","dropout");if(Kn("float32"===r.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${r.dtype} tensor instead.`)),Kn(e>=0&&e<1,(()=>`rate must be a float in the range [0, 1), but got ${e}.`)),0===e)return t instanceof pr?r.clone():r;const i=function(t,e){if(null==e)return t.shape.slice();if(Hn(t.shape,e))return e;if(t.shape.length===e.length){const n=[];for(let s=0;s<t.shape.length;s++)null==e[s]&&null!=t.shape[s]?n.push(t.shape[s]):n.push(e[s]);return n}return e}(r,n),a=1-e,o=Br(Qa(ri(Kl(i,0,1,"float32",s),a)),a);return Mr(r,o)}});const ou=(t,e)=>!(t>0)||"linear"===e;Dr({fusedConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(l=l||"linear",!1===ou(Ir.state.gradientDepth,l)){Kn("NHWC"===r,(()=>`Error in fused conv2d: got dataFormat of ${r} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Pi(t,e,n,s,r,i,a);return null!=o&&(c=ri(c,o)),au(c,l,u,h)}const c=Tr(t,"x","conv2d","float32"),p=Tr(e,"filter","conv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=Zr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Kn(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),Kn(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),gi("fused conv2d",s,a);const g="NHWC"===r?d.shape[3]:d.shape[1];Kn(p.shape[2]===g,(()=>`Error in conv2d: depth of input (${g}) must match input depth for filter ${p.shape[2]}.`)),Kn(fi(n,i),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`));const m=ui(d.shape,p.shape,n,i,s,a);let b,y;if(null!=o&&(b=Tr(o,"bias","fused conv2d"),[b]=kr(b,c),"NHWC"===r?Jr(m.outShape,b.shape):(Kn(b.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${b.shape.length}.`)),Kn(0===b.shape.length||b.shape[0]===m.outChannels||1===b.shape[0],(()=>`Error in fused conv2d: bias shape (${b.shape}) is not compatible with the number of output channels (${m.outChannels})`)))),null!=u){const t=u.shape;if(Kn(t.length<=1||3===t.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${t.length}.`)),1===t.length)Kn(1===t[0]||t[0]===m.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the number of output channels (${m.outChannels}).`));else if(3===t.length)try{Jr(t,m.outShape)}catch(e){const n=`Error in fused conv2d: PReLU activation weights (${t}) is not compatible with the output shape of the conv2d (${m.outShape}).`;throw Error(n)}y=Tr(u,"prelu weights","fused conv2d")}const w=(t,e)=>{Kn("NHWC"===r,(()=>`Error in gradient of fused conv2D: got dataFormat of ${r} but only NHWC is currently supported.`));const[a,o,u,h]=e,c=ru(t,u,l);Kn(di(i),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${i}'`));const p=[Oi(o.shape,c,a,n,s),Ri(o,c,a.shape,n,s)];if(null!=h){const t=iu(h,c);p.push(t)}return p},k={x:d,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=fl(((t,e,n)=>{let s=Ir.runKernel(Pn,k,v);return n([e,t,s]),f&&(s=Zr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return t(d,p)}{const t=fl(((t,e,n,s)=>{let r=Ir.runKernel(Pn,k,v);return s([e,t,r,n]),f&&(r=Zr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return t(d,p,b)}}}),Dr({fusedDepthwiseConv2d_:function({x:t,filter:e,strides:n,pad:s,dataFormat:r="NHWC",dilations:i=[1,1],dimRoundingMode:a,bias:o,activation:l="linear",preluActivationWeights:u,leakyreluAlpha:h}){if(!1===ou(Ir.state.gradientDepth,l)){let c=nl(t,e,n,s,r,i,a);return null!=o&&(c=ri(c,o)),au(c,l,u,h)}const c=Tr(t,"x","depthwiseConv2d","float32"),p=Tr(e,"filter","depthwiseConv2d","float32");let d=c,f=!1;3===c.rank&&(f=!0,d=Zr(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Kn(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),Kn(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),Kn(d.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==i&&(i=[1,1]),Kn(fi(n,i),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`)),gi("fused depthwiseConv2d",s,a);const g=ui(d.shape,p.shape,n,i,s,a,!0);let m,b;null!=o&&(m=Tr(o,"bias","fused conv2d"),[m]=kr(m,c),Jr(g.outShape,m.shape)),null!=u&&(b=Tr(u,"prelu weights","fused depthwiseConv2d"));const y=(t,e)=>{Kn(di(i),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${i}'`));const[r,o,u,h]=e,c=ru(t,u,l),p=oa(o.shape,c,r,n,s,i,a),d=aa(o,c,r.shape,n,s,i,a);if(null!=h){return[p,d,iu(m,c)]}return[p,d]},w={x:d,filter:p,bias:m,preluActivationWeights:b},k={strides:n,pad:s,dataFormat:r,dilations:i,dimRoundingMode:a,activation:l,leakyreluAlpha:h};if(null==o){const t=fl(((t,e,n)=>{let s=Ir.runKernel(Wn,w,k);return n([e,t,s]),f&&(s=Zr(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:y}}));return t(d,p)}{const t=fl(((t,e,n,s)=>{let r=Ir.runKernel(Wn,w,k);return s([e,t,r,n]),f&&(r=Zr(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:y}}));return t(d,p,m)}}}),Dr({fusedMatMul_:function({a:t,b:e,transposeA:n=!1,transposeB:s=!1,bias:r,activation:i="linear",preluActivationWeights:a,leakyreluAlpha:o=.2}){if(!1===ou(Ir.state.gradientDepth,i)){let l=ki(t,e,n,s);return null!=r&&(l=ri(l,r)),au(l,i,a,o)}let l=Tr(t,"a","fused matMul"),u=Tr(e,"b","fused matMul");[l,u]=kr(l,u);const h=n?l.shape[l.rank-2]:l.shape[l.rank-1],c=s?u.shape[u.rank-1]:u.shape[u.rank-2],p=n?l.shape[l.rank-1]:l.shape[l.rank-2],d=s?u.shape[u.rank-2]:u.shape[u.rank-1],f=l.shape.slice(0,-2),g=u.shape.slice(0,-2),m=Gn(f),b=Gn(g);Kn(h===c,(()=>`Error in fused matMul: inner shapes (${h}) and (${c}) of Tensors with shapes ${l.shape} and ${u.shape} and transposeA=${n} and transposeB=${s} must match.`));const y=Jr(l.shape.slice(0,-2),u.shape.slice(0,-2)).concat([p,d]),w=Zr(l,n?[m,h,p]:[m,p,h]),k=Zr(u,s?[b,d,c]:[b,c,d]);let v,x;null!=r&&(v=Tr(r,"bias","fused matMul"),[v]=kr(v,l),Jr(y,v.shape)),null!=a&&(x=Tr(a,"prelu weights","fused matMul"));const S=(t,e)=>{const[a,o,l,u]=e,h=ru(Zr(t,l.shape),l,i);let c,p;if(n||s?!n&&s?(c=ki(h,o,!1,!1),p=ki(h,a,!0,!1)):n&&!s?(c=ki(o,h,!1,!0),p=ki(a,h,!1,!1)):(c=ki(o,h,!0,!0),p=ki(h,a,!0,!0)):(c=ki(h,o,!1,!0),p=ki(a,h,!0,!1)),null!=r){return[c,p,iu(u,h)]}return[c,p]},N={a:w,b:k,bias:v,preluActivationWeights:x},E={transposeA:n,transposeB:s,activation:i,leakyreluAlpha:o};if(null==r){const t=fl(((t,e,n)=>{const s=Ir.runKernel(Bn,N,E);return n([t,e,s]),{value:Zr(s,y),gradFunc:S}}));return t(w,k)}{const t=fl(((t,e,n,s)=>{const r=Ir.runKernel(Bn,N,E);return s([t,e,r,n]),{value:Zr(r,y),gradFunc:S}}));return t(w,k,v)}}}),Dr({hammingWindow_:function(t){return su(t,.54,.46)}});const lu=Dr({hannWindow_:function(t){return su(t,.5,.5)}});const uu=Dr({frame_:function(t,e,n,s=!1,r=0){let i=0;const a=[];for(;i+e<=t.size;)a.push(Ya(t,i,e)),i+=n;if(s)for(;i<t.size;){const s=i+e-t.size,o=jo([Ya(t,i,e-s),hl([s],r)]);a.push(o),i+=n}return 0===a.length?nu([],[0,e]):Zr(jo(a),[a.length,e])}});function hu(t,e,n,s,r,i){null==s&&(s=.5),null==r&&(r=Number.NEGATIVE_INFINITY),null==i&&(i=0);const a=t.shape[0];return n=Math.min(n,a),Kn(0<=s&&s<=1,(()=>`iouThreshold must be in [0, 1], but was '${s}'`)),Kn(2===t.rank,(()=>`boxes must be a 2D tensor, but was of rank '${t.rank}'`)),Kn(4===t.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${t.shape[1]}`)),Kn(1===e.rank,(()=>"scores must be a 1D tensor")),Kn(e.shape[0]===a,(()=>`scores has incompatible shape with boxes. Expected ${a}, but was ${e.shape[0]}`)),Kn(0<=i&&i<=1,(()=>`softNmsSigma must be in [0, 1], but was '${i}'`)),{maxOutputSize:n,iouThreshold:s,scoreThreshold:r,softNmsSigma:i}}function cu(t,e=!1){return Ir.tidy((()=>{Kn(2===t.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${t.shape.length}D Tensor.`));const n=t.shape[0],s=t.shape[1];let r=ul(n),i=Ci(t);const a=nu([[1]],[1,1]);let o=Ci(a);const l=n>=s?s:n;for(let t=0;t<l;++t){const e=i,l=o,u=r;[o,i,r]=Ir.tidy((()=>{const e=Ya(i,[t,t],[n-t,1]),l=ol(e),u=Ya(i,[t,t],[1,1]),h=_i(Ca(u,0),nu([[-1]]),nu([[1]])),c=qr(u,Mr(h,l)),p=Br(e,c);o=1===p.shape[0]?Ci(a):jo([a,Ya(p,[1,0],[p.shape[0]-1,p.shape[1]])],0);const d=Pr(Br(ki(h,c),l)),f=Ya(i,[t,0],[n-t,s]),g=Mr(d,o),m=ra(o);if(0===t)i=qr(f,ki(g,ki(m,f)));else{const e=qr(f,ki(g,ki(m,f)));i=jo([Ya(i,[0,0],[t,s]),e],0)}const b=ra(g),y=Ya(r,[0,t],[n,r.shape[1]-t]);if(0===t)r=qr(y,ki(ki(y,o),b));else{const e=qr(y,ki(ki(y,o),b));r=jo([Ya(r,[0,0],[n,t]),e],1)}return[o,i,r]})),ta([e,l,u])}return!e&&n>s&&(r=Ya(r,[0,0],[n,s]),i=Ya(i,[0,0],[s,s])),[r,i]}))}var pu;Dr({stft_:function(t,e,n,s,r=lu){var i;null==s&&(i=e,s=Math.floor(Math.pow(2,Math.ceil(Math.log(i)/Math.log(2)))));const a=uu(t,e,n),o=Mr(a,r(e));return Yl(o,s)}}),Dr({cropAndResize_:function(t,e,n,s,r="bilinear",i=0){const a=Tr(t,"image","cropAndResize"),o=Tr(e,"boxes","cropAndResize","float32"),l=Tr(n,"boxInd","cropAndResize","int32"),u=o.shape[0];Kn(4===a.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${a.rank}.`)),Kn(2===o.rank&&4===o.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${u},4] but had shape ${o.shape}.`)),Kn(1===l.rank&&l.shape[0]===u,(()=>`Error in cropAndResize: boxInd must be have size [${u}] but had shape ${o.shape}.`)),Kn(2===s.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${s.length}.`)),Kn(s[0]>=1&&s[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${s}`)),Kn("bilinear"===r||"nearest"===r,(()=>`method must be bilinear or nearest, but was ${r}`));const h={image:a,boxes:o,boxInd:l},c={method:r,extrapolationValue:i,cropSize:s};return Ir.runKernel("CropAndResize",h,c)}}),Dr({flipLeftRight_:function(t){const e=Tr(t,"image","flipLeftRight","float32");Kn(4===e.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${e.rank}.`));const n={image:e};return Ir.runKernel("FlipLeftRight",n,{})}}),Dr({grayscaleToRGB_:function(t){const e=Tr(t,"image","grayscaleToRGB"),n=e.rank-1,s=e.shape[n];Kn(e.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${e.rank}.`)),Kn(1===s,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${s}.`));const r=new Array(e.rank);return r.fill(1,0,n),r[n]=3,wa(e,r)}}),Dr({rotateWithOffset_:function(t,e,n=0,s=.5){const r=Tr(t,"image","rotateWithOffset","float32");Kn(4===r.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${r.rank}.`));const i={image:r},a={radians:e,fillValue:n,center:s};return Ir.runKernel("RotateWithOffset",i,a)}}),Dr({nonMaxSuppression_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY){const i=Tr(t,"boxes","nonMaxSuppression","float32"),a=Tr(e,"scores","nonMaxSuppression","float32"),o=hu(i,a,n,s,r),l={maxOutputSize:n=o.maxOutputSize,iouThreshold:s=o.iouThreshold,scoreThreshold:r=o.scoreThreshold};return Ir.runKernel("NonMaxSuppressionV3",{boxes:i,scores:a},l)}}),Dr({nonMaxSuppressionWithScore_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=0){const a=Tr(t,"boxes","nonMaxSuppression"),o=Tr(e,"scores","nonMaxSuppression"),l=hu(a,o,n,s,r,i),u={boxes:a,scores:o},h={maxOutputSize:n=l.maxOutputSize,iouThreshold:s=l.iouThreshold,scoreThreshold:r=l.scoreThreshold,softNmsSigma:i=l.softNmsSigma},c=Ir.runKernel("NonMaxSuppressionV5",u,h);return{selectedIndices:c[0],selectedScores:c[1]}}}),Dr({nonMaxSuppressionPadded_:function(t,e,n,s=.5,r=Number.NEGATIVE_INFINITY,i=!1){const a=Tr(t,"boxes","nonMaxSuppression"),o=Tr(e,"scores","nonMaxSuppression"),l=hu(a,o,n,s,r,null),u={boxes:a,scores:o},h={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:i},c=Ir.runKernel("NonMaxSuppressionV4",u,h);return{selectedIndices:c[0],validOutputs:c[1]}}}),Dr({resizeBilinear_:function(t,e,n=!1,s=!1){const r=Tr(t,"images","resizeBilinear");Kn(3===r.rank||4===r.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${r.rank}.`)),Kn(2===e.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${e}.`)),Kn(!1===s||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=Zr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ir.runKernel(fn,o,l);return a?Zr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Dr({resizeNearestNeighbor_:function(t,e,n=!1,s=!1){const r=Tr(t,"images","resizeNearestNeighbor");Kn(3===r.rank||4===r.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${r.rank}.`)),Kn(2===e.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${e}.`)),Kn("float32"===r.dtype||"int32"===r.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),Kn(!1===s||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let i=r,a=!1;3===r.rank&&(a=!0,i=Zr(r,[1,r.shape[0],r.shape[1],r.shape[2]]));const o={images:i},l={alignCorners:n,halfPixelCenters:s,size:e},u=Ir.runKernel(dn,o,l);return a?Zr(u,[u.shape[1],u.shape[2],u.shape[3]]):u}}),Dr({threshold_:function(t,e="binary",n=!1,s=.5){const r=Tr(t,"image","threshold"),i=r.shape[0]*r.shape[1];let a,o,l,u,h=Mr(eu([s]),255);if(Kn(3===r.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${r.rank}.`)),Kn(3===r.shape[2]||1===r.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${r.shape[2]}.`)),Kn("int32"===r.dtype||"float32"===r.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${r.dtype}.`)),Kn("otsu"===e||"binary"===e,(()=>`Method must be binary or otsu, but was ${e}`)),3===r.shape[2]){[a,o,l]=Mi(r,[1,1,1],-1);const t=Mr(a,.2989),e=Mr(o,.587),n=Mr(l,.114);u=ri(ri(t,e),n)}else u=t;if("otsu"===e){h=function(t,e){let n,s,r,i,a,o,l=eu([-1]),u=eu([0]),h=eu([0]);for(let c=0;c<t.size-1;c++){n=Ya(t,0,c+1),s=Ya(t,c+1),a=Br(Yr(n),e),o=Br(Yr(s),e);const p=Yr(Mr(n,Vl(0,n.size)));r=Br(p,Yr(n));const d=hl(s.shape,n.size),f=ri(Vl(0,s.size),d),g=Mr(s,f);i=Br(Yr(g),Yr(s));const m=qr(r,i),b=qr(r,i),y=Mr(a,o);h=Mr(Mr(y,m),b);const w=Ca(h,u);u=_i(w,h,u),l=_i(w,eu([c]),l)}return l}(Yo(Fr(Hl(u),"int32"),Wr(c=[],p,$r(c,d),d),256),i)}var c,p,d;const f=n?$i(u,h):Ca(u,h);return Fr(Mr(f,255),"int32")}}),Dr({transform_:function(t,e,n="nearest",s="constant",r=0,i){const a=Tr(t,"image","transform","float32"),o=Tr(e,"transforms","transform","float32");Kn(4===a.rank,(()=>`Error in transform: image must be rank 4,but got rank ${a.rank}.`)),Kn(2===o.rank&&(o.shape[0]===a.shape[0]||1===o.shape[0])&&8===o.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),Kn(null==i||2===i.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${i}.`));const l={image:a,transforms:o},u={interpolation:n,fillMode:s,fillValue:r,outputShape:i};return Ir.runKernel("Transform",l,u)}}),Dr({bandPart_:function(t,e,n){Kn(e%1==0,(()=>`bandPart(): numLower must be an integer, got ${e}.`)),Kn(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const s=Tr(t,"a","bandPart");Kn(s.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${s.rank}.`));const r=s.shape,[i,a]=s.shape.slice(-2);if(!(e<=i))throw new Error(`bandPart(): numLower (${e}) must not be greater than the number of rows (${i}).`);if(!(n<=a))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${a}).`);e<0&&(e=i),n<0&&(n=a);const o=Zr(Vl(0,i,1,"int32"),[-1,1]),l=Vl(0,a,1,"int32"),u=qr(o,l),h=zi($i(u,Ur(+e,"int32")),Ai(u,Ur(-n,"int32"))),c=ja([i,a],s.dtype);return Zr(tu(io(Zr(s,[-1,i,a])).map((t=>_i(h,t,c)))),r)}}),Dr({gramSchmidt_:function(t){let e;if(Array.isArray(t)){e=!1,Kn(null!=t&&t.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=t[0].shape[0];for(let e=1;e<t.length;++e)Kn(t[e].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${t[e].shape[0]} vs. ${n})`))}else e=!0,t=Mi(t,t.shape[0],0).map((t=>Ql(t,[0])));Kn(t.length<=t[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${t.length}) exceeds number of dimensions (${t[0].shape[0]}).`));const n=[],s=t;for(let e=0;e<t.length;++e)n.push(Ir.tidy((()=>{let t=s[e];if(e>0)for(let s=0;s<e;++s){const e=Mr(Yr(Mr(n[s],t)),n[s]);t=qr(t,e)}return Br(t,ol(t,"euclidean"))})));return e?tu(n,0):n}}),Dr({qr_:function(t,e=!1){if(Kn(t.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${t.rank}`)),2===t.rank)return cu(t,e);{const n=t.shape.slice(0,t.shape.length-2).reduce(((t,e)=>t*e)),s=io(Zr(t,[n,t.shape[t.shape.length-2],t.shape[t.shape.length-1]]),0),r=[],i=[];s.forEach((t=>{const[n,s]=cu(t,e);r.push(n),i.push(s)}));return[Zr(tu(r,0),t.shape),Zr(tu(i,0),t.shape)]}}}),function(t){t[t.NONE=0]="NONE",t[t.MEAN=1]="MEAN",t[t.SUM=2]="SUM",t[t.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(pu||(pu={}));const du=Dr({computeWeightedLoss_:function(t,e,n=pu.SUM_BY_NONZERO_WEIGHTS){const s=Tr(t,"losses","computeWeightedLoss");let r=null;null!=e&&(r=Tr(e,"weights","computeWeightedLoss"));const i=null==r?s:Mr(s,r);if(n===pu.NONE)return i;if(n===pu.SUM)return Yr(i);if(n===pu.MEAN){if(null==r)return xl(i);{const t=s.size/r.size,e=Br(Yr(i),Yr(r));return t>1?Br(e,Ur(t)):e}}if(n===pu.SUM_BY_NONZERO_WEIGHTS){if(null==r)return Br(Yr(i),Ur(s.size));{const t=Mr(r,Ga(s.shape)),e=Fr(Yr(Nl(t,Ur(0))),"float32");return Br(Yr(i),e)}}throw Error(`Unknown reduction: ${n}`)}});Dr({absoluteDifference_:function(t,e,n,s=pu.SUM_BY_NONZERO_WEIGHTS){const r=Tr(t,"labels","absoluteDifference"),i=Tr(e,"predictions","absoluteDifference");let a=null;null!=n&&(a=Tr(n,"weights","absoluteDifference")),Vn(r.shape,i.shape,"Error in absoluteDifference: ");const o=Vo(qr(r,i));return du(o,a,s)}}),Dr({cosineDistance_:function(t,e,n,s,r=pu.SUM_BY_NONZERO_WEIGHTS){const i=Tr(t,"labels","cosineDistance"),a=Tr(e,"predictions","cosineDistance");let o=null;null!=s&&(o=Tr(s,"weights","cosineDistance")),Vn(i.shape,a.shape,"Error in cosineDistance: ");const l=Ur(1),u=qr(l,Yr(Mr(i,a),n,!0));return du(u,o,r)}}),Dr({hingeLoss_:function(t,e,n,s=pu.SUM_BY_NONZERO_WEIGHTS){let r=Tr(t,"labels","hingeLoss");const i=Tr(e,"predictions","hingeLoss");let a=null;null!=n&&(a=Tr(n,"weights","hingeLoss")),Vn(r.shape,i.shape,"Error in hingeLoss: ");const o=Ur(1);r=qr(Mr(Ur(2),r),o);const l=ql(qr(o,Mr(r,i)));return du(l,a,s)}}),Dr({huberLoss_:function(t,e,n,s=1,r=pu.SUM_BY_NONZERO_WEIGHTS){const i=Tr(t,"labels","huberLoss"),a=Tr(e,"predictions","huberLoss");let o=null;null!=n&&(o=Tr(n,"weights","huberLoss")),Vn(i.shape,a.shape,"Error in huberLoss: ");const l=Ur(s),u=Vo(qr(a,i)),h=Sl(u,l),c=qr(u,h),p=ri(Mr(Ur(.5),Vr(h)),Mr(l,c));return du(p,o,r)}}),Dr({logLoss_:function(t,e,n,s=1e-7,r=pu.SUM_BY_NONZERO_WEIGHTS){const i=Tr(t,"labels","logLoss"),a=Tr(e,"predictions","logLoss");let o=null;null!=n&&(o=Tr(n,"weights","logLoss")),Vn(i.shape,a.shape,"Error in logLoss: ");const l=Ur(1),u=Ur(s),h=Pr(Mr(i,lo(ri(a,u)))),c=Mr(qr(l,i),lo(ri(qr(l,a),u))),p=qr(h,c);return du(p,o,r)}}),Dr({meanSquaredError_:function(t,e,n,s=pu.SUM_BY_NONZERO_WEIGHTS){const r=Tr(t,"labels","meanSquaredError"),i=Tr(e,"predictions","meanSquaredError");let a=null;null!=n&&(a=Tr(n,"weights","meanSquaredError")),Vn(r.shape,i.shape,"Error in meanSquaredError: ");const o=Xl(r,i);return du(o,a,s)}}),Dr({sigmoidCrossEntropy_:function(t,e,n,s=0,r=pu.SUM_BY_NONZERO_WEIGHTS){let i=Tr(t,"multiClassLabels","sigmoidCrossEntropy");const a=Tr(e,"logits","sigmoidCrossEntropy");let o=null;if(null!=n&&(o=Tr(n,"weights","sigmoidCrossEntropy")),Vn(i.shape,a.shape,"Error in sigmoidCrossEntropy: "),s>0){const t=Ur(s),e=Ur(1),n=Ur(.5);i=ri(Mr(i,qr(e,t)),Mr(n,t))}const l=function(t,e){const n=Tr(t,"labels","sigmoidCrossEntropyWithLogits"),s=Tr(e,"logits","sigmoidCrossEntropyWithLogits");Vn(n.shape,s.shape,"Error in sigmoidCrossEntropyWithLogits: ");const r=ql(s),i=Mr(s,n),a=dl(ca(Pr(Vo(s))));return ri(qr(r,i),a)}(i,a);return du(l,o,r)}}),Dr({softmaxCrossEntropy_:function(t,e,n,s=0,r=pu.SUM_BY_NONZERO_WEIGHTS){let i=Tr(t,"onehotLabels","softmaxCrossEntropy");const a=Tr(e,"logits","softmaxCrossEntropy");let o=null;if(null!=n&&(o=Tr(n,"weights","softmaxCrossEntropy")),Vn(i.shape,a.shape,"Error in softmaxCrossEntropy: "),s>0){const t=Ur(s),e=Ur(1),n=Ur(i.shape[1]);i=ri(Mr(i,qr(e,t)),Br(t,n))}const l=function(t,e,n=-1){if(-1===n&&(n=e.rank-1),n!==e.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${e.rank} and dim was ${n}`);const s=fl(((t,e,s)=>{const r=ml(e,[n],!0),i=qr(Fr(e,"float32"),r);s([t,i]);const a=Pr(Mr(i,t));return{value:Yr(a,[n]),gradFunc:(t,e)=>{const[s,r]=e,i=Ji(t.shape,[n]);return[Mr(Zr(t,i),qr(Fr(s,"float32"),ca(r))),Mr(Zr(t,i),qr(ca(r),Fr(s,"float32")))]}}}));return s(t,e)}(i,a);return du(l,o,r)}}),Dr({sparseFillEmptyRows_:function(t,e,n,s){const r=Tr(t,"indices","sparseFillEmptyRows","int32"),i=Tr(e,"values","sparseFillEmptyRows"),a=Tr(n,"denseShape","sparseFillEmptyRows","int32"),o=Tr(s,"defaultValue","sparseFillEmptyRows",i.dtype);if(2!==r.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==i.rank)throw new Error(`Values should be Tensor1D but received shape ${i.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==o.rank)throw new Error(`Default value should be a scalar but received shape ${o.shape}`);const l={indices:r,values:i,denseShape:a,defaultValue:o},u=Ir.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}}),Dr({sparseReshape_:function(t,e,n){const s=Tr(t,"inputIndices","sparseReshape","int32"),r=Tr(e,"inputShape","sparseReshape","int32"),i=Tr(n,"newShape","sparseReshape","int32");if(2!==s.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==r.rank)throw new Error(`Input shape should be Tensor1D but received shape ${r.shape}`);if(1!==i.rank)throw new Error(`New shape should be Tensor1D but received shape ${i.shape}`);const a={inputIndices:s,inputShape:r,newShape:i},o=Ir.runKernel("SparseReshape",a);return{outputIndices:o[0],outputShape:o[1]}}}),Dr({sparseSegmentMean_:function(t,e,n){const s=Tr(t,"data","sparseSegmentMean"),r=Tr(e,"indices","sparseSegmentMean","int32"),i=Tr(n,"segmentIds","sparseSegmentMean","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ir.runKernel("SparseSegmentMean",a)}}),Dr({sparseSegmentSum_:function(t,e,n){const s=Tr(t,"data","sparseSegmentSum"),r=Tr(e,"indices","sparseSegmentSum","int32"),i=Tr(n,"segmentIds","sparseSegmentSum","int32");if(s.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==r.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${r.shape}`);if(1!==i.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${i.shape}`);const a={data:s,indices:r,segmentIds:i};return Ir.runKernel("SparseSegmentSum",a)}}),Dr({stringNGrams_:function(t,e,n,s,r,i,a,o){const l=Tr(t,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Tr(e,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const h={separator:n,nGramWidths:s,leftPad:r,rightPad:i,padWidth:a,preserveShortSequences:o},c={data:l,dataSplits:u},p=Ir.runKernel("StringNGrams",c,h);return{nGrams:p[0],nGramsSplits:p[1]}}}),Dr({stringSplit_:function(t,e,n=!0){const s=Tr(t,"input","stringSplit","string"),r=Tr(e,"delimiter","stringSplit","string");if(1!==s.rank)throw new Error(`Input should be Tensor1D but received shape ${s.shape}`);if(0!==r.rank)throw new Error(`Delimiter should be a scalar but received shape ${r.shape}`);const i={skipEmpty:n},a={input:s,delimiter:r},o=Ir.runKernel("StringSplit",a,i);return{indices:o[0],values:o[1],shape:o[2]}}}),Dr({stringToHashBucketFast_:function(t,e){const n=Tr(t,"input","stringToHashBucketFast","string"),s={numBuckets:e};if(e<=0)throw new Error("Number of buckets must be at least 1");const r={input:n};return Ir.runKernel("StringToHashBucketFast",r,s)}});class fu extends class{getClassName(){return this.constructor.className}static fromConfig(t,e){return new t(e)}}{minimize(t,e=!1,n){const{value:s,grads:r}=this.computeGradients(t,n);if(null!=n){const t=n.map((t=>({name:t.name,tensor:r[t.name]})));this.applyGradients(t)}else this.applyGradients(r);return ta(r),e?s:(s.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(t,e){return function(t,e){Kn(ns(t),(()=>"The f passed in variableGrads(f) must be a function")),Kn(null==e||Array.isArray(e)&&e.every((t=>t instanceof dr)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=e;if(!n){e=[];for(const t in Ir.registeredVariables)e.push(Ir.registeredVariables[t])}const s=n?e.filter((t=>!t.trainable)):null,r=e.length;Kn((e=e.filter((t=>t.trainable))).length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${r} variables is trainable.`));const{value:i,grads:a}=Ir.gradients(t,e,null,!0);Kn(a.some((t=>null!=t)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),Kn(0===i.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${i.rank} tensor`));const o={};return e.forEach(((t,e)=>{null!=a[e]&&(o[t.name]=a[e])})),null!=s&&s.forEach((t=>o[t.name]=null)),{value:i,grads:o}}(t,e)}dispose(){null!=this.iterations_&&ta(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ur(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(t){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(t){return this.iterations_=(await t[0].tensor.data())[0],t.slice(1)}}Object.defineProperty(fu,Symbol.hasInstance,{value:t=>null!=t.minimize&&null!=t.computeGradients&&null!=t.applyGradients});class gu extends fu{constructor(t,e,n=null){super(),this.learningRate=t,this.rho=e,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ir.backend.epsilon())}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ir.registeredVariables[e];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${e}/accum_grad`,variable:Qi((()=>ti(s).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${e}/accum_var`,variable:Qi((()=>ti(s).variable(false)))});const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;Qi((()=>{const t=ri(Mr(i,this.rho),Mr(Vr(r),1-this.rho)),e=Mr(Br(Kr(ri(a,this.epsilon)),Kr(ri(i,this.epsilon))),r),n=ri(Mr(a,this.rho),Mr(Vr(e),1-this.rho));i.assign(t),a.assign(n);const o=ri(Mr(e,-this.learningRate),s);s.assign(o)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(ta(this.accumulatedGrads.map((t=>t.variable))),ta(this.accumulatedUpdates.map((t=>t.variable))))}async getWeights(){const t=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){const e=(t=await this.extractIterations(t)).length/2;this.accumulatedGrads=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedUpdates=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.rho,e.epsilon)}}gu.className="Adadelta",Ko(gu);class mu extends fu{constructor(t,e=.1){super(),this.learningRate=t,this.initialAccumulatorValue=e,this.accumulatedGrads=[]}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ir.registeredVariables[e];if(null==this.accumulatedGrads[n]){const t=!1;this.accumulatedGrads[n]={originalName:`${e}/accumulator`,variable:Qi((()=>hl(s.shape,this.initialAccumulatorValue).variable(t)))}}const r=Array.isArray(t)?t[n].tensor:t[e];if(null==r)return;const i=this.accumulatedGrads[n].variable;Qi((()=>{const t=ri(i,Vr(r));i.assign(t);const e=ri(Mr(Br(r,Kr(ri(t,Ir.backend.epsilon()))),-this.learningRate),s);s.assign(e)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&ta(this.accumulatedGrads.map((t=>t.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulatedGrads=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(t,e){return new t(e.learningRate,e.initialAccumulatorValue)}}mu.className="Adagrad",Ko(mu);class bu extends fu{constructor(t,e,n,s=null){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],Qi((()=>{this.accBeta1=Ur(e).variable(),this.accBeta2=Ur(n).variable()})),null==s&&(this.epsilon=Ir.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);Qi((()=>{const n=qr(1,this.accBeta1),s=qr(1,this.accBeta2);e.forEach(((e,r)=>{const i=Ir.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:Qi((()=>ti(i).variable(false)))}),null==this.accumulatedSecondMoment[r]&&(this.accumulatedSecondMoment[r]={originalName:`${e}/v`,variable:Qi((()=>ti(i).variable(false)))});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedSecondMoment[r].variable,u=ri(Mr(o,this.beta1),Mr(a,1-this.beta1)),h=ri(Mr(l,this.beta2),Mr(Vr(a),1-this.beta2)),c=Br(u,n),p=Br(h,s);o.assign(u),l.assign(h);const d=ri(Mr(Br(c,ri(Kr(p),this.epsilon)),-this.learningRate),i);i.assign(d)})),this.accBeta1.assign(Mr(this.accBeta1,this.beta1)),this.accBeta2.assign(Mr(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&ta(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedSecondMoment&&ta(this.accumulatedSecondMoment.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t),Qi((()=>{this.accBeta1.assign(uo(this.beta1,this.iterations_+1)),this.accBeta2.assign(uo(this.beta2,this.iterations_+1))}));const e=t.length/2;this.accumulatedFirstMoment=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)}))),this.accumulatedSecondMoment=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon)}}bu.className="Adam",Ko(bu);class yu extends fu{constructor(t,e,n,s=null,r=0){super(),this.learningRate=t,this.beta1=e,this.beta2=n,this.epsilon=s,this.decay=r,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],Qi((()=>{this.iteration=Ur(0).variable(),this.accBeta1=Ur(e).variable()})),null==s&&(this.epsilon=Ir.backend.epsilon())}applyGradients(t){const e=Array.isArray(t)?t.map((t=>t.name)):Object.keys(t);Qi((()=>{const n=qr(1,this.accBeta1),s=Br(-this.learningRate,ri(Mr(this.iteration,this.decay),1));e.forEach(((e,r)=>{const i=Ir.registeredVariables[e];null==this.accumulatedFirstMoment[r]&&(this.accumulatedFirstMoment[r]={originalName:`${e}/m`,variable:ti(i).variable(false)}),null==this.accumulatedWeightedInfNorm[r]&&(this.accumulatedWeightedInfNorm[r]={originalName:`${e}/v`,variable:ti(i).variable(false)});const a=Array.isArray(t)?t[r].tensor:t[e];if(null==a)return;const o=this.accumulatedFirstMoment[r].variable,l=this.accumulatedWeightedInfNorm[r].variable,u=ri(Mr(o,this.beta1),Mr(a,1-this.beta1)),h=Mr(l,this.beta2),c=Vo(a),p=vl(h,c);o.assign(u),l.assign(p);const d=ri(Mr(Br(s,n),Br(u,ri(p,this.epsilon))),i);i.assign(d)})),this.iteration.assign(ri(this.iteration,1)),this.accBeta1.assign(Mr(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&ta(this.accumulatedFirstMoment.map((t=>t.variable))),null!=this.accumulatedWeightedInfNorm&&ta(this.accumulatedWeightedInfNorm.map((t=>t.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(t){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(t,e){return new t(e.learningRate,e.beta1,e.beta2,e.epsilon,e.decay)}}yu.className="Adamax",Ko(yu);class wu extends fu{constructor(t){super(),this.learningRate=t,this.setLearningRate(t)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Array.isArray(t)?t[n].tensor:t[e];if(null==s)return;const r=Ir.registeredVariables[e];Qi((()=>{const t=ri(Mr(this.c,s),r);r.assign(t)}))})),this.incrementIterations()}setLearningRate(t){var e;this.learningRate=t,null!=this.c&&this.c.dispose(),this.c=(e=Ur(-t),Ir.keep(e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(t){if(0!==(t=await this.extractIterations(t)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(t,e){return new t(e.learningRate)}}wu.className="SGD",Ko(wu);class ku extends wu{constructor(t,e,n=!1){super(t),this.learningRate=t,this.momentum=e,this.useNesterov=n,this.accumulations=[],this.m=Ur(this.momentum)}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ir.registeredVariables[e];if(null==this.accumulations[n]){const t=!1;this.accumulations[n]={originalName:`${e}/momentum`,variable:Qi((()=>ti(s).variable(t)))}}const r=this.accumulations[n].variable,i=Array.isArray(t)?t[n].tensor:t[e];null!=i&&Qi((()=>{let t;const e=ri(Mr(this.m,r),i);t=this.useNesterov?ri(Mr(this.c,ri(i,Mr(e,this.m))),s):ri(Mr(this.c,e),s),r.assign(e),s.assign(t)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&ta(this.accumulations.map((t=>t.variable)))}setMomentum(t){this.momentum=t}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);this.accumulations=t.map((t=>({originalName:t.name,variable:t.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(t,e){return new t(e.learningRate,e.momentum,e.useNesterov)}}ku.className="Momentum",Ko(ku);class vu extends fu{constructor(t,e=.9,n=0,s=null,r=!1){if(super(),this.learningRate=t,this.decay=e,this.momentum=n,this.epsilon=s,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=r,null==s&&(this.epsilon=Ir.backend.epsilon()),null==t)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(t){(Array.isArray(t)?t.map((t=>t.name)):Object.keys(t)).forEach(((e,n)=>{const s=Ir.registeredVariables[e],r=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${e}/rms`,variable:Qi((()=>ti(s).variable(r)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${e}/momentum`,variable:Qi((()=>ti(s).variable(r)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${e}/mg`,variable:Qi((()=>ti(s).variable(r)))});const i=Array.isArray(t)?t[n].tensor:t[e];if(null==i)return;const a=this.accumulatedMeanSquares[n].variable,o=this.accumulatedMoments[n].variable;Qi((()=>{const t=ri(Mr(a,this.decay),Mr(Vr(i),1-this.decay));if(this.centered){const e=this.accumulatedMeanGrads[n].variable,r=ri(Mr(e,this.decay),Mr(i,1-this.decay)),l=Br(Mr(i,this.learningRate),Kr(qr(t,ri(Vr(r),this.epsilon)))),u=ri(Mr(o,this.momentum),l);a.assign(t),e.assign(r),o.assign(u);const h=qr(s,u);s.assign(h)}else{const t=ri(Mr(a,this.decay),Mr(Vr(i),1-this.decay)),e=ri(Mr(o,this.momentum),Br(Mr(i,this.learningRate),Kr(ri(t,this.epsilon))));a.assign(t),o.assign(e);const n=qr(s,e);s.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&ta(this.accumulatedMeanSquares.map((t=>t.variable))),null!=this.accumulatedMeanGrads&&this.centered&&ta(this.accumulatedMeanGrads.map((t=>t.variable))),null!=this.accumulatedMoments&&ta(this.accumulatedMoments.map((t=>t.variable)))}async getWeights(){const t=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&t.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(t.map((t=>({name:t.originalName,tensor:t.variable}))))}async setWeights(t){t=await this.extractIterations(t);const e=this.centered?t.length/3:t.length/2,n=!1;this.accumulatedMeanSquares=t.slice(0,e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.accumulatedMoments=t.slice(e,2*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=t.slice(2*e,3*e).map((t=>({originalName:t.name,variable:t.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(t,e){return new t(e.learningRate,e.decay,e.momentum,e.epsilon,e.centered)}}vu.className="RMSProp",Ko(vu),"undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate&&setImmediate;function xu(t,e,n){const s=t.shape.length,r=s-n.length,i=Zi(n,s);let a=t;null!=i&&(a=ra(t,i));const o=a.shape.slice(),l=o.splice(s-n.length,n.length).reduce(((t,e)=>t*e),1);o.push(l);let u=function(t,e,n){const s=t.shape.slice();s[n]=1;const r=Zr(e,s),i=el(t,n,!0,!1),a=el(t,n,!0,!0),o=Mr(i,a);return Mr(r,o)}(a.reshape(o),e,r);if(u=u.reshape(a.shape),null!=i){const t=Yi(i);u=ra(u,t)}return u}const Su={kernelName:An,gradFunc:(t,e,n)=>{const{blockShape:s,paddings:r}=n;return{x:()=>Jo(t,s,r)}}},Nu={kernelName:$n,gradFunc:(t,e,n)=>{const{axis:s}=n;return{x:()=>jo(t,s)}}};const Eu=[Rr,jr,Gr,Xr,Qr,ei,ni,si,ii,ai,oi,li,bi,wi,vi,Si,Ni,Ei,Ii,Di,Fi,Li,Wi,Bi,Vi,ji,Hi,ia,la,ua,{kernelName:Le,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{const e=Br(t,Fr(s,"float32")),i=Hr(n.shape,r);return i.length>0?Zr(Yr(e,i),n.shape):e},b:()=>{let e=Mr(t,Fr(n,"float32"));const i=Hr(s.shape,r);i.length>0&&(e=Zr(Yr(e,i),s.shape));const a=Vr(s);return Pr(Br(e,Fr(a,"float32")))}}}},ha,pa,da,fa,ga,ba,ma,ka,xa,Ea,Ia,Aa,$a,za,Ta,_a,Da,Fa,La,Ba,Ba,Wa,Ka,qa,Ha,Ja,Za,Xa,to,eo,no,so,ro,ao,oo,oo,ho,co,{kernelName:un,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{axis:r}=n;let i=[];return i=null==r?s.shape.map(((t,e)=>e)):"number"==typeof r?[r]:r,{x:()=>xu(s,t,i)}}},{kernelName:hn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,Pr(Vr(n)))}}},{kernelName:gn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e,s=Mr($i(n,6),Lr(n));return{x:()=>Mr(t,Fr(s,"float32"))}}},{kernelName:cn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Fr(Lr(n),"float32"))}}},{kernelName:pn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Zr(t,n.shape)}}},{kernelName:fn,inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ir.runKernel("ResizeBilinearGrad",r,n)}}},{kernelName:dn,inputsToSave:["images"],gradFunc:(t,e,n)=>{const[s]=e,r={dy:t,images:s};return{images:()=>Ir.runKernel("ResizeNearestNeighborGrad",r,n)}}},{kernelName:mn,gradFunc:(t,e,n)=>{const{dims:s}=n,r=Yn(s,t.shape);return{x:()=>Gl(t,r)}}},{kernelName:bn,gradFunc:t=>({x:()=>ti(t)})},{kernelName:yn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Pr(Br(t,Mr(uo(n,1.5),2)))}}},{kernelName:wn,inputsToSave:["condition"],gradFunc:(t,e)=>{const[n]=e;return{condition:()=>Fr(ti(n),"float32"),t:()=>Mr(t,Fr(n,t.dtype)),e:()=>Mr(t,Fr(bl(n),t.dtype))}}},{kernelName:kn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>{const e=Ca(n,Ur(0)),s=Ur(1.7580993408473768),r=Ur(1.0507009873554805),i=Mr(t,r),a=Mr(Mr(t,s),ca(Fr(n,"float32")));return _i(e,i,a)}}}},{kernelName:Nn,outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Mr(n,qr(Ur(1),n)))}}},{kernelName:Sn,gradFunc:t=>({x:()=>ti(t)})},{kernelName:"Sin",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(Qo(Fr(n,"float32")),t)}}},{kernelName:xn,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(tl(Fr(n,"float32")),t)}}},{kernelName:vn,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{begin:r,size:i}=n,a=s.shape,[o,l]=function(t,e,n){let s;const r=t.shape.length;let i;return s="number"==typeof e?[e,...new Array(r-1).fill(0)]:e.length<r?e.concat(new Array(r-e.length).fill(0)):e.slice(),s.forEach((t=>{Kn(-1!==t,(()=>"slice() does not support negative begin indexing."))})),i=null==n?new Array(r).fill(-1):"number"==typeof n?[n,...new Array(r-1).fill(-1)]:n.length<r?n.concat(new Array(r-n.length).fill(-1)):n,i=i.map(((e,n)=>e>=0?e:(Kn(-1===e,(()=>`Negative size values should be exactly -1 but got ${e} for the slice() size at index ${n}.`)),t.shape[n]-s[n]))),[s,i]}(s,r,i),u=[];for(let e=0;e<t.rank;e++)u.push([o[e],a[e]-o[e]-l[e]]);return{x:()=>El(t,u)}}},{kernelName:zn,outputsToSave:[!0],gradFunc:(t,e,n)=>{const[s]=e,{dim:r}=n,i=Mr(t,s);return{logits:()=>qr(i,Mr(Yr(i,[r],true),s))}}},{kernelName:En,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Go(n))}}},Su,Su,Nu,Nu,{kernelName:In,inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,Mr(Kr(Fr(n,"float32")),2))}}},{kernelName:Cn,inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Ur(2);return{a:()=>Mr(t,Mr(r,qr(n,s))),b:()=>Mr(t,Mr(r,qr(s,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(t,Mr(Fr(n,"float32"),2))}}},{kernelName:Rn,gradFunc:t=>({x:()=>ti(t)})},{kernelName:"Sub",inputsToSave:["a","b"],gradFunc:(t,e)=>{const[n,s]=e,r=Jr(n.shape,s.shape);return{a:()=>{let e=t;const s=Hr(n.shape,r);return s.length>0&&(e=Yr(e,s)),Zr(e,n.shape)},b:()=>{let e=t;const n=Hr(s.shape,r);return n.length>0&&(e=Yr(e,n)),Zr(Pr(e),s.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,r=s.shape.slice(),{axis:i}=n;Yn(i,s.shape).forEach((t=>{r[t]=1}));const a=Zr(t,r),o=Mr(a,Ga(s.shape,"float32"));return{x:()=>o}}},{kernelName:"Tan",inputsToSave:["x"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Br(t,Vr(Qo(n)))}}},{kernelName:Tn,outputsToSave:[!0],gradFunc:(t,e)=>{const[n]=e;return{x:()=>Mr(qr(Ur(1),Vr(n)),t)}}},{kernelName:_n,inputsToSave:["x"],gradFunc:(t,e,n)=>{const[s]=e,{reps:r}=n;return{x:()=>{let e=ti(s);if(1===s.rank)for(let n=0;n<r[0];++n)e=ri(e,Ya(t,[n*s.shape[0]],[s.shape[0]]));else if(2===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)e=ri(e,Ya(t,[n*s.shape[0],i*s.shape[1]],[s.shape[0],s.shape[1]]));else if(3===s.rank)for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)e=ri(e,Ya(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2]],[s.shape[0],s.shape[1],s.shape[2]]));else{if(4!==s.rank)throw new Error(`Gradient for tile operation is not implemented for rank-${s.rank} tensors yet.`);for(let n=0;n<r[0];++n)for(let i=0;i<r[1];++i)for(let a=0;a<r[2];++a)for(let o=0;o<r[3];++o)e=ri(e,Ya(t,[n*s.shape[0],i*s.shape[1],a*s.shape[2],o*s.shape[3]],[s.shape[0],s.shape[1],s.shape[2],s.shape[3]]))}return e}}}},{kernelName:Dn,gradFunc:(t,e,n)=>{const s=n,{perm:r}=s,i=Yi(r);return{x:()=>ra(t,i)}}},{kernelName:Fn,gradFunc:(t,e,n)=>{const s=n,{axis:r}=s;return{value:()=>tu(t,r)}}},{kernelName:Mn,inputsToSave:["segmentIds"],gradFunc:(t,e)=>{const[n]=e;return{x:()=>function(t,e){const n=vl(e,ti(e)),s=cl(t,n);let r=Ai(e,Ur(0,"int32"));const i=s.rank-r.rank;for(let t=0;t<i;++t)r=ll(r,t+1);r=zi(r,Ga(s.shape,"bool"));const a=ti(s);return _i(r,s,a)}(t,n)}}},{kernelName:Ln,gradFunc:t=>({x:()=>ti(t)})}];for(const t of Eu)Ns(t);function Iu(t,n){return e.tidy((()=>s.sqrt(s.sum(s.mul(t,t),n,!0))))}class Au extends e.serialization.Serializable{getConfig(){return{}}}class $u extends Au{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>{const e=Iu(t,this.axis),n=s.clipByValue(e,0,this.maxValue);return s.mul(t,s.div(n,s.add(Q(),e)))}))}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}$u.className="MaxNorm",e.serialization.registerClass($u);class zu extends Au{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>s.div(t,s.add(Q(),Iu(t,this.axis)))))}getConfig(){return{axis:this.axis}}}zu.className="UnitNorm",e.serialization.registerClass(zu);class Cu extends Au{apply(t){return s.relu(t)}}Cu.className="NonNeg",e.serialization.registerClass(Cu);class Tu extends Au{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy((()=>{const e=Iu(t,this.axis),n=s.add(s.mul(this.rate,s.clipByValue(e,this.minValue,this.maxValue)),s.mul(1-this.rate,e));return s.mul(t,s.div(n,s.add(Q(),e)))}))}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}Tu.className="MinMaxNorm",e.serialization.registerClass(Tu);const _u={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function Du(t){return y(t)}function Fu(t,n={}){return k(t,e.serialization.SerializationMap.getMap().classNameMap,n,"constraint")}function Mu(t){if(null==t)return null;if("string"==typeof t){return Fu({className:t in _u?_u[t]:t,config:{}})}return t instanceof Au?t:Fu(t)}var Lu={__proto__:null,maxNorm:function(t){return new $u(t)},unitNorm:function(t){return new zu(t)},nonNeg:function(){return new Cu},minMaxNorm:function(t){return new Tu(t)}};var Ru,Ou={__proto__:null,zeros:function(){return new wt},ones:function(){return new kt},constant:function(t){return new vt(t)},randomUniform:function(t){return new xt(t)},randomNormal:function(t){return new St(t)},truncatedNormal:function(t){return new Nt(t)},identity:function(t){return new Et(t)},varianceScaling:function(t){return new It(t)},glorotUniform:function(t){return new At(t)},glorotNormal:function(t){return new $t(t)},heNormal:function(t){return new zt(t)},heUniform:function(t){return new Ct(t)},leCunNormal:function(t){return new Tt(t)},leCunUniform:function(t){return new _t(t)},orthogonal:function(t){return new Dt(t)}};async function Bu(t){if(null==t)return;const n=[],s=[],r=[];for(const e in t){const i=t[e];if("number"!=typeof i){const t=i;n.push(t.data()),s.push(e),r.push(t)}}if(n.length>0){const i=await Promise.all(n);for(let e=0;e<i.length;++e)t[s[e]]=i[e][0];e.dispose(r)}}function Pu(t){if(null!=t)for(const e in t){const n=t[e];"number"!=typeof n&&n.dispose()}}!function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(Ru||(Ru={}));class Wu{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class Uu{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const n of this.callbacks)await n.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class Ku extends Wu{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,n){null==n&&(n={});const s=null==n.size?0:n.size;this.seen+=s;for(const t in n){const r=n[t];if("number"==typeof r)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+r*s;else{let n;t in this.totals?n=this.totals[t]:this.totals[t]=0;const i=e.tidy((()=>e.add(this.totals[t],e.mul(r,s))));this.totals[t]=i,null!=n&&n.dispose()}}}async onEpochEnd(t,n){if(null!=n)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?n[t]=this.totals[t]/this.seen:e.tidy((()=>{const s=e.mul(e.div(1,this.seen),this.totals[t]);n[t]=s,this.totals[t].dispose(),e.keep(n[t])})))}}class Vu extends Wu{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],n=[];for(const s in this.history){const r=this.history[s];for(let i=0;i<r.length;++i)if("number"!=typeof r[i]){const a=r[i];t.push(a.data()),e.push(s),n.push(i)}}const s=await Promise.all(t);for(let t=0;t<s.length;++t){this.history[e[t]][n[t]].dispose(),this.history[e[t]][n[t]]=s[t][0]}}}class qu extends Wu{constructor(t,n){if(super(),this.currentEpoch=0,this.nowFunc=t.nowFunc,this.nextFrameFunc=t.nextFrameFunc||e.nextFrame,this.yieldEvery=n||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");e.util.isNumber(this.yieldEvery)&&(this.maybeWait=function(t,n,s){let r,i=null!=s?s():e.util.now();return(...a)=>{const o=null!=s?s():e.util.now();return o-i<n||(i=o,r=t(...a)),r}}(this.maybeWait.bind(this),this.yieldEvery,this.nowFunc)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,e,n){const s=[];null!=this.yield&&(await Bu(n),s.push(this.yield(t,e,n))),s.push(this.nextFrameFunc()),await Promise.all(s)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await Bu(e),await this.epochBegin(t,e))}async onEpochEnd(t,e){const n=[];null!=this.epochEnd&&(await Bu(e),n.push(this.epochEnd(t,e))),"epoch"===this.yieldEvery&&n.push(this.nextFrameFunc()),await Promise.all(n)}async onBatchBegin(t,e){null!=this.batchBegin&&(await Bu(e),await this.batchBegin(t,e))}async onBatchEnd(t,n){const s=[];null!=this.batchEnd&&(await Bu(n),s.push(this.batchEnd(t,n))),"batch"===this.yieldEvery?s.push(this.nextFrameFunc()):e.util.isNumber(this.yieldEvery)&&s.push(this.maybeWait(this.currentEpoch,t,n)),await Promise.all(s)}async onTrainBegin(t){null!=this.trainBegin&&(await Bu(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await Bu(t),await this.trainEnd(t))}}function ju(t,e){if(null==t&&(t={}),t instanceof Wu)return[t];if(Array.isArray(t)&&t[0]instanceof Wu)return t;return f(t).map((t=>new qu(t,e)))}class Gu{constructor(){}static registerCallbackConstructor(t,n){e.util.assert(t>=0&&Number.isInteger(t),(()=>`Verbosity level is expected to be an integer >= 0, but got ${t}`)),Gu.checkForDuplicate(n),null==Gu.constructors[t]&&(Gu.constructors[t]=[]),Gu.constructors[t].push(n)}static checkForDuplicate(t){for(const e in Gu.constructors){Gu.constructors[+e].forEach((e=>{if(e===t)throw new a("Duplicate callback constructor.")}))}}static clear(){Gu.constructors={}}static createCallbacks(t){const e=[];for(const n in Gu.constructors){const s=+n;t>=s&&e.push(...Gu.constructors[s])}return e.map((t=>new t))}}function Hu(t,e,n,s,r,i,a,o,l){const u=new Vu,h=[new Ku,...Gu.createCallbacks(e)];null!=t&&h.push(...t),h.push(u);const c=new Uu(h);return c.setParams({epochs:n,initialEpoch:s,samples:r,steps:i,batchSize:a,verbose:e,doValidation:o,metrics:l}),{callbackList:c,history:u}}function Ju(t,n={},s=!1){return k(t,e.serialization.SerializationMap.getMap().classNameMap,n,"layer",s)}function Zu(t,n){return e.tidy((()=>{"float32"!==t.dtype&&(t=s.cast(t,"float32"));const e=s.sum(ct(t),n,!0),r=s.fill(e.shape,Q()),i=s.sqrt(s.maximum(e,r));return s.div(t,i)}))}function Yu(t,n){return e.tidy((()=>s.mean(ct(s.sub(n,t)),-1)))}function Xu(t,n){return e.tidy((()=>s.mean(s.abs(s.sub(n,t)),-1)))}function Qu(t,n){return e.tidy((()=>{const e=s.sub(t,n),r=s.clipByValue(s.abs(t),Q(),Number.MAX_VALUE),i=s.abs(s.div(e,r));return s.mul(100,s.mean(i,-1))}))}function th(t,n,r=!1){return e.tidy((()=>{if(r)n=s.softmax(n);else{const t=s.sum(n,n.shape.length-1,!0);n=s.div(n,t)}return n=s.clipByValue(n,Q(),1-Q()),s.neg(s.sum(s.mul(s.cast(t,"float32"),s.log(n)),n.shape.length-1))}))}function eh(t,n,r=!1){return e.tidy((()=>{const e=s.cast(s.floor(function(t){const e=[H(t.shape)];return s.reshape(t,e)}(t)),"int32"),i=(n=s.clipByValue(n,Q(),1-Q())).shape;return th(s.reshape(s.oneHot(e,i[i.length-1]),i),n,r)}))}function nh(t,n){return e.tidy((()=>{let r;return r=s.clipByValue(n,Q(),1-Q()),r=s.log(s.div(r,s.sub(1,r))),s.mean(function(t,n){if(!e.util.arraysEqual(t.shape,n.shape))throw new a(`logits and labels must have the same shape, but got shapes ${JSON.stringify(t.shape)} and ${JSON.stringify(n.shape)}`);return e.tidy((()=>{const e=s.relu(n),r=s.neg(s.abs(n));return s.add(s.sub(e,s.mul(n,t)),s.log1p(s.exp(r)))}))}(t,r),-1)}))}function sh(t,n){return e.tidy((()=>{const e=Zu(t,-1),r=Zu(n,-1),i=s.mul(e,r);return s.neg(s.sum(i,-1))}))}Gu.constructors={};const rh={meanSquaredError:Yu,meanAbsoluteError:Xu,meanAbsolutePercentageError:Qu,meanSquaredLogarithmicError:function(t,n){return e.tidy((()=>{const e=s.clipByValue(n,Q(),Number.MAX_VALUE),r=s.log(s.add(1,e)),i=s.clipByValue(t,Q(),Number.MAX_VALUE),a=s.log(s.add(1,i));return s.mean(ct(s.sub(r,a)),-1)}))},squaredHinge:function(t,n){return e.tidy((()=>{const e=s.maximum(0,s.sub(1,s.mul(t,n)));return s.mean(ct(e),-1)}))},hinge:function(t,n){return e.tidy((()=>{const e=s.maximum(0,s.sub(1,s.mul(t,n)));return s.mean(e,-1)}))},categoricalHinge:function(t,n){return e.tidy((()=>{const e=s.sum(s.mul(t,n),-1),r=s.max(s.mul(s.sub(1,t),n),-1);return s.maximum(0,s.add(1,s.sub(r,e)))}))},logcosh:function(t,n){return e.tidy((()=>{const e=Math.log(2),r=s.sub(n,t),i=s.sub(s.add(r,s.softplus(s.mul(-2,r))),e);return s.mean(i,-1)}))},categoricalCrossentropy:th,sparseCategoricalCrossentropy:eh,binaryCrossentropy:nh,kullbackLeiblerDivergence:function(t,n){return e.tidy((()=>{const e=s.clipByValue(t,Q(),1),r=s.clipByValue(n,Q(),1);return s.sum(s.mul(t,s.log(s.div(e,r))),-1)}))},poisson:function(t,n){return e.tidy((()=>{const e=s.log(s.add(Q(),n));return s.mean(s.sub(n,s.mul(t,e)),-1)}))},cosineProximity:sh};function ih(t){if("string"==typeof t){if(t in rh)return rh[t];let e=`Unknown loss ${t}`;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new a(e)}return t}function ah(t,n){return e.tidy((()=>{const e=s.mul(.5,s.onesLike(n)),r=tt(s.greater(n,e),t.dtype);return s.mean(s.equal(t,r),-1)}))}function oh(t,n){return e.tidy((()=>tt(s.equal(s.argMax(t,-1),s.argMax(n,-1)),"float32")))}function lh(t,n){return e.tidy((()=>s.cast(s.sum(s.logicalAnd(s.equal(t,1),s.equal(n,1))),"float32")))}function uh(t,n){return e.tidy((()=>{const r=lh(t,n),i=function(t,n){return e.tidy((()=>s.cast(s.sum(s.logicalAnd(s.equal(t,0),s.equal(n,1))),"float32")))}(t,n),a=s.add(r,i);return s.cast(s.where(s.greater(a,0),s.div(r,a),0),"float32")}))}function hh(t,n){return e.tidy((()=>{const r=lh(t,n),i=function(t,n){return e.tidy((()=>s.cast(s.sum(s.logicalAnd(s.equal(t,1),s.equal(n,0))),"float32")))}(t,n),a=s.add(r,i);return s.cast(s.where(s.greater(a,0),s.div(r,a),0),"float32")}))}function ch(t,e){return nh(t,e)}function ph(t,e){return t.rank===e.rank&&(t=s.squeeze(t,[t.rank-1])),(e=s.argMax(e,-1)).dtype!==t.dtype&&(e=s.cast(e,t.dtype)),s.cast(s.equal(t,e),"float32")}const dh=th,fh=eh,gh={binaryAccuracy:ah,categoricalAccuracy:oh,precision:uh,categoricalCrossentropy:dh,sparseCategoricalCrossentropy:fh,mse:Yu,MSE:Yu,mae:Xu,MAE:Xu,mape:Qu,MAPE:Qu,cosine:sh};function mh(t){if("string"==typeof t&&t in gh)return gh[t];if("string"!=typeof t&&null!=t)return t;throw new a(`Unknown metric ${t}`)}function bh(t){if(c(null!==t,`Unknown LossOrMetricFn ${t}`),"string"==typeof t)return t;{let e;for(const n of Object.keys(rh))if(rh[n]===t){e=n;break}if(void 0!==e)return e;for(const n of Object.keys(gh))if(gh[n]===t){e=n;break}return void 0!==e?e:t.name}}const yh=1048576;function wh(t,e,n=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!kh(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(n){const n=JSON.stringify(t);n.length>yh&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${n.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function kh(t){if(null===t)return!0;if("object"==typeof t){if(Object.getPrototypeOf(t)===Object.prototype){const e=Object.keys(t);for(const n of e){if("string"!=typeof n)return!1;if(!kh(t[n]))return!1}return!0}if(Array.isArray(t)){for(const e of t)if(!kh(e))return!1;return!0}return!1}{const e=typeof t;return"string"===e||"number"===e||"boolean"===e}}function vh(t,e,n,s=console.log){const r=function(t){let e=!0;const n=[],s=[];for(const e in t.nodesByDepth)n.push(t.nodesByDepth[e]);for(const t of n){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}s.push(...t)}if(e)for(const n of t.layers){let t=!1;for(const r of n.inboundNodes)if(-1!==s.indexOf(r)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),i=["Layer (type)","Input Shape","Output shape","Param #"];let a;if(r?(e=e||90,n=n||[.32,.61,.89,1]):(e=e||115,n=n||[.24,.48,.7,.8,1]),n[n.length-1]<=1&&(n=n.map((t=>Math.floor(e*t)))),!r){i.push("Receives inputs"),a=[];for(const e in t.nodesByDepth)a.push(...t.nodesByDepth[e])}s("_".repeat(e)),xh(i,n,s),s("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)r?Sh(o[t],n,s):Nh(o[t],n,a,s),s((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?Ut(t.collectedTrainableWeights):Ut(t.trainableWeights);return e}(t),u=Ut(t.nonTrainableWeights);s(`Total params: ${l+u}`),s(`Trainable params: ${l}`),s(`Non-trainable params: ${u}`),s("_".repeat(e))}function xh(t,e,n=console.log){let s="";for(let n=0;n<t.length;++n)n>0&&(s=s.slice(0,s.length-1)+" "),s+=t[n],s=s.slice(0,e[n]),s+=" ".repeat(e[n]-s.length);n(s)}function Sh(t,e,n){let s,r;try{r=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){r="multiple"}try{s=JSON.stringify(t.outputShape)}catch(t){s="multiple"}xh([`${t.name} (${t.getClassName()})`,r,s,t.countParams().toString()],e,n)}function Nh(t,e,n,s){let r,i;try{i=t.inboundNodes.map((t=>JSON.stringify(t.inputShapes))).join(",")}catch(t){i="multiple"}try{r=JSON.stringify(t.outputShape)}catch(t){r="multiple"}const a=[];for(const e of t.inboundNodes)if(!(null!=n&&n.length>0&&-1===n.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const n=e.inboundLayers[t].name,s=e.nodeIndices[t],r=e.tensorIndices[t];a.push(`${n}[${s}][${r}]`)}const o=t.name,l=t.getClassName(),u=0===a.length?"":a[0];xh([`${o} (${l})`,i,r,t.countParams().toString(),u],e,s);for(let t=1;t<a.length;++t)xh(["","","","",a[t]],e,s)}function Eh(t,e,n){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof n}function Ih(t,e){if(null===t)return null;if("string"==typeof t)return m(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Eh(e,r,s)?n.push(s):n.push(Ih(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n];if("name"===n&&"string"==typeof s)e[n]=s;else{const t=m(n);e[t]=Ih(s,t)}}return e}}function Ah(t,e){if(null==t)return null;if("string"==typeof t)return g(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const n=[],s=t.length;for(let r=0;r<s;++r){const s=t[r];Eh(e,r,s)?n.push(s):n.push(Ah(s,e))}return n}{const e={};for(const n of Object.keys(t)){const s=t[n],r=g(n);e[r]="name"!==n&&"className"!==n||"string"!=typeof s?Ah(s,n):s}return e}}const $h="3.19.0";class zh extends Xt{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=_(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],x(this.inputs).length!==this.inputs.length)throw new a(`The list of inputs passed to the model is redundant. All inputs should only appear once. Found: ${this.inputs.map((t=>t.name))}`);x(this.outputs).length!==this.outputs.length&&console.warn(`The list of outputs passed to the model is redundant. All outputs should only appear once. Found: ${this.outputs.map((t=>t.name))}`),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(n),this.outputLayersTensorIndices.push(s)}for(const t of this.inputs){const e=t.sourceLayer,n=t.nodeIndex,s=t.tensorIndex;c(0===n,"input layer has >1 nodes"),c(0===s,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(n),this.inputLayersTensorIndices.push(s)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const n=this.inputLayers[e];if(!(n instanceof te))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${n.getClassName()}.`);this.inputNames.push(n.name),this.feedInputShapes.push(n.batchInputShape),this.feedInputNames.push(n.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map((t=>t.shape)),this.internalOutputShapes=this.outputs.map((t=>t.shape));const e={},n={},s={},r={},o={},l=[],u=(t,e,n,s,r,a)=>{null!=s&&null!=r&&null!=a||(s=t.sourceLayer,r=t.nodeIndex,a=t.tensorIndex);const h=s.inboundNodes[r];if(-1!==n.indexOf(h))throw new i(`The tensor ${t.name} at layer "${s.name}" is part of a cycle.`);if(-1!==e.indexOf(h))return;this.containerNodes.add(zh.nodeKey(s,r)),s.id in o||(o[s.id]=Object.keys(o).length),-1===n.indexOf(h)&&n.push(h);const c=h.inboundLayers.length;for(let t=0;t<c;t++){const s=h.inputTensors[t],r=h.inboundLayers[t],i=h.nodeIndices[t],a=h.tensorIndices[t];u(s,e,n,r,i,a)}for(e.push(h);n.indexOf(h)>=0;)n.splice(n.indexOf(h),1);l.push(h)},h=[],p=[];for(const t of this.outputs)u(t,h,p);const d=l.slice().reverse();for(const t of d){n[t.id]=t,t.id in e||(e[t.id]=0);let i=e[t.id];const a=null==s[t.outboundLayer.id]?0:s[t.outboundLayer.id];i=Math.max(i,a),s[t.outboundLayer.id]=i,r[t.outboundLayer.id]=t.outboundLayer,e[t.id]=i;for(let s=0;s<t.inboundLayers.length;s++){const r=t.inboundLayers[s],a=t.nodeIndices[s],o=r.inboundNodes[a],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(i+1,l),n[o.id]=o}}const f={};for(const t in e){const s=e[t];s in f||(f[s]=[]),f[s].push(n[t])}const g={};for(const t in s){const e=s[t];e in g||(g[e]=[]),g[e].push(r[t])}let m=Object.keys(g).map((t=>parseInt(t,10))).sort(v);this.layers=[];for(const t of m){const e=g[t];e.sort(((t,e)=>{const n=o[t.id],s=o[e.id];return n<s?-1:n>s?1:0}));for(const t of e)t instanceof zh&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=g,m=Object.keys(f).map((t=>parseInt(t,10))).sort(v);const b=this.inputs.slice(),y=[];for(const t of m)for(const e of f[t]){const t=e.outboundLayer;if(null!=t){for(const n of e.inputTensors)if(-1===b.indexOf(n))throw new i(`Graph disconnected: cannot obtain value for tensor ${n} at layer "${t.name}". The following previous layers were accessed without issue: ${y}`);for(const t of e.outputTensors)b.push(t);y.push(t.name)}}this.nodesByDepth=f;const w=this.layers.map((t=>t.name));for(const t of w){const e=w.filter((e=>e===t)).length;if(1!==e)throw new i(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(w))}this.outboundNodes=[],this.inboundNodes=[],new Zt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map((t=>null)),outputMasks:this.outputs.map((t=>null)),inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs.map((t=>t.shape))}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach((e=>{e._trainableWeights.forEach((e=>e.trainable=t))})),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new a("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const n={};let s=0;for(const t of this.layers)for(const e of t.weights){if(null!=n[e.originalName])throw new a(`Duplicate weight name: ${e.originalName}`);n[e.originalName]=e,s++}const r=[];for(const s in t){let i=s;if(null==n[s]){const t=s.split("/");i=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=n[i])r.push([n[i],t[s]]);else if(e)throw new a(`Provided weight data has no target variable: ${s}`);delete n[i]}if(e){const t=[];for(const e in n)t.push(e);if(t.length>0)throw new a(`${t.length} of ${s} weights are not set: ${t}`)}jt(r)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 3.19.0",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const n=Ah(this.updatedConfig());return e?JSON.stringify(n):n}call(t,n){return e.tidy((()=>{t=f(t);const e=new ne;for(let n=0;n<this.inputs.length;++n)e.add(this.inputs[n],t[n]);return ie(this.outputs,e,n)}))}computeMask(t,n){return e.tidy((()=>{let e;return t=f(t),e=null==n?h(null,t.length):f(n),this.runInternalGraph(t,e)[1]}))}computeOutputShape(t){const e=Bt(t);if(e.length!==this.inputLayers.length)throw new a(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const n={};for(let t=0;t<e.length;t++){const s=this.inputLayers[t],r=e[t];n[s.name+"_0_0"]=r}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(v);if(s.length>1)for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map((t=>t.id)).indexOf(e.id))continue;const s=[];for(let e=0;e<t.inboundLayers.length;e++){const r=t.inboundLayers[e],i=t.nodeIndices[e],a=t.tensorIndices[e],o=n[`${r.name}_${i}_${a}`];s.push(o)}const r=Bt(e.computeOutputShape(d(s))),i=e.inboundNodes.indexOf(t);for(let t=0;t<r.length;t++){n[`${e.name}_${i}_${t}`]=r[t]}}}const r=[],i=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],n=this.outputLayersNodeIndices[t],s=this.outputLayersTensorIndices[t],r=`${e.name}_${n}_${s}`;i.push(r)}for(let t=0;t<i.length;t++){const e=i[t];c(e in n),r.push(n[e])}return d(r)}runInternalGraph(t,e){null==e&&(e=h(null,t.length));const n={};for(let s=0;s<this.inputs.length;++s){const r=this.inputs[s],i=t[s],a=e[s];n[r.id]=[i,a]}const s=Object.keys(this.nodesByDepth).map((t=>parseInt(t,10))).sort(v);for(const t of s){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,s=t.inputTensors,r=t.outputTensors,i=new Array;for(const t of s)t.id in n&&i.push(n[t.id]);if(i.length===s.length){let s,a,l,u,h={};if(null!=t.callArgs&&(h=t.callArgs),1===i.length){const[t,n]=i[0];null==h.mask&&(h.mask=n),l=f(e.call(t,h)),u=f(e.computeMask(t,n)),s=[t],a=[n]}else s=i.map((t=>t[0])),a=i.map((t=>t[1])),null==h.mask&&(h.mask=a),l=f(e.call(s,h)),u=f(e.computeMask(s,a));if(e.activityRegularizer)throw new o("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<r.length;++t){const e=r[t],s=l[t],i=u[t];n[e.id]=[s,i]}}}}const r=[],i=[],a=[];for(const t of this.outputs){c(t.id in n,`Could not compute output ${t.name} : ${t.id}`);const[e,s]=n[t.id];a.push(e.shape),r.push(e),i.push(s)}return[r,i,a]}buildNodeConversionMap(t){const e={};let n;for(const t of this.layers){n=t instanceof zh?1:0;for(let s=0;s<t.inboundNodes.length;s++){const r=zh.nodeKey(t,s);this.containerNodes.has(r)&&(e[r]=n,n+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new a(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new a("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new a(`No such layer: ${t}`)}calculateLosses(){return e.tidy((()=>{const t=[];for(const e of this.layers)for(let n=0;n<e.inboundNodes.length;++n){const s=zh.nodeKey(e,n);this.containerNodes.has(s)&&t.push(...e.calculateLosses())}return t}))}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),n=[];for(const t of this.layers){const s=t.getClassName(),r=t.getConfig(),i=[];for(let n=0;n<t.inboundNodes.length;n++){const s=t.inboundNodes[n],r=zh.nodeKey(t,n);let a={};if(this.containerNodes.has(r)){if(s.callArgs)try{JSON.stringify(s.callArgs),a=s.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: ${s.callArgs}. They will not be included in the serialized model (and thus will be missing at deserialization time).`),a={}}if(s.inboundLayers.length>0){const t=[];for(let n=0;n<s.inboundLayers.length;n++){const r=s.inboundLayers[n],i=s.nodeIndices[n],o=s.tensorIndices[n];let l=e[zh.nodeKey(r,i)];null==l&&(l=0),t.push([r.name,l,o,a])}i.push(t)}}}const a={};a.name=t.name,a.className=s,a.config=r,a.inboundNodes=i,n.push(a)}t.layers=n;const s=[];for(let t=0;t<this.inputLayers.length;t++){const n=this.inputLayers[t],r=this.inputLayersNodeIndices[t],i=zh.nodeKey(n,r);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.inputLayersTensorIndices[t];s.push([n.name,a,o])}t.inputLayers=s;const r=[];for(let t=0;t<this.outputLayers.length;t++){const n=this.outputLayers[t],s=this.outputLayersNodeIndices[t],i=zh.nodeKey(n,s);if(!this.containerNodes.has(i))continue;let a=e[i];null==a&&(a=0);const o=this.outputLayersTensorIndices[t];r.push([n.name,a,o])}return t.outputLayers=r,t}static fromConfig(t,e,n={},s=!1){const r={},i={};function o(t,e){t.name in i?i[t.name].push(e):i[t.name]=[e]}function l(t,e){const n=[];let s;for(const i of e){const a=i[0],l=i[1],u=i[2];if(s=null==i[3]?{}:i[3],!(a in r))return void o(t,e);const h=r[a];if(h.inboundNodes.length<=l)return void o(t,e);const c=h.inboundNodes[l];n.push(c.outputTensors[u])}n.length>0&&t.apply(d(n),s)}function u(t){const n=t.name,i=Ju(t,null!=e.customObjects?e.customObjects:{});i.setFastWeightInitDuringBuild(s),r[n]=i;t.inboundNodes.forEach((t=>{if(!(t instanceof Array))throw new a(`Corrupted configuration, expected array for nodeData: ${t}`);o(i,t)}))}const h=e.name,p=e.layers;for(const t of p)u(t);for(;!S(i);)for(const t of p){const e=r[t.name];if(e.name in i){const t=i[e.name];delete i[e.name];for(const n of t)l(e,n)}}const f=[],g=[],m=e.inputLayers;for(const t of m){const e=t[0],n=t[1],s=t[2];c(e in r);const i=r[e].inboundNodes[n].outputTensors;f.push(i[s])}const b=e.outputLayers;for(const t of b){const e=t[0],n=t[1],s=t[2];c(e in r);const i=r[e].inboundNodes[n].outputTensors;g.push(i[s])}return new t({inputs:f,outputs:g,name:h})}get stateful(){if(this._stateful)throw new a("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){e.tidy((()=>{this.layers.forEach((t=>{t.stateful&&t.resetStates()}))}))}}function Ch(t,e){return function(t,e,n){const s=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>null));if(1===s)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==s)throw new Error(`Provided ${n} is an array of ${t.length} element(s), but the model has ${s} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const n=[];return e.forEach((e=>{e in t?n.push(t[e]):n.push(null)})),n}throw new Error(`The model has multiple (${s}) outputs, so ${n} must be either an array with ${s} elements or an object with ${e} keys. Provided ${n} not understood: ${JSON.stringify(t)}`)}(t,e,"classWeight")}async function Th(t,n,s,r){if(null!=n||null!=r)throw new Error("Support sampleWeight is not implemented yet");if(null!=s){const n=e.tidy((()=>{if(1===t.shape.length)return e.clone(t);if(2===t.shape.length){if(t.shape[1]>1){const n=1;return e.argMax(t,n)}if(1===t.shape[1])return e.reshape(t,[t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)})),r=Array.from(await n.data());e.dispose(n);const i=[];return r.forEach((t=>{if(null==s[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);i.push(s[t])})),e.tensor1d(i,"float32")}return null}function _h(t,n){return e.mul(t,n)}function Dh(t,e){let n,r;const i=e;n=i.xs,r=i.ys,s.util.assert(null!=n&&null!=r,(()=>`A Dataset iterator for fitDataset() is expected to generate objects of the form \`{xs: xVal, ys: yVal}\`, where the two values may be \`tf.Tensor\`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates ${e}`));const a=Fh("input",t.inputNames,n),o=Fh("output",t.outputNames,r),l=a[0].shape[0];s.util.assert(a.length===t.inputs.length,(()=>`LayersModel has ${t.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: ${JSON.stringify(t.inputNames)})`)),s.util.assert(o.length===t.outputs.length,(()=>`LayersModel has ${t.outputs.length} outputs, but the dataset provides ${o.length} outputs.  (Expected output keys: ${JSON.stringify(t.outputNames)})`));for(let e=0;e<a.length;e++)s.util.assert(a[e].shape[0]===l,(()=>`Batch size mismatch: input ${t.inputNames[e]} has ${a[e].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`));for(let e=0;e<o.length;e++)s.util.assert(o[e].shape[0]===l,(()=>`Batch size mismatch: output ${t.outputNames[e]} has ${o[e].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`));return{xs:a,ys:o}}function Fh(t,e,n){if(n instanceof s.Tensor)return[n];if(Array.isArray(n))return s.util.assert(n.length===e.length,(()=>`Received an array of ${n.length} Tensors, but expected ${e.length} to match the ${t} keys ${e}.`)),n;{const s=[];for(const r of e){if(null==n[r])throw new a(`The feature data generated by the dataset lacks the required ${t} key '${r}'.`);s.push(n[r])}return s}}async function Mh(t,e,n){const r=null!=n.batchesPerEpoch;if(s.util.assert(null!=t.optimizer,(()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig).")),s.util.assert(null!=n,(()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call.")),s.util.assert(null!=n.epochs&&n.epochs>0&&Number.isInteger(n.epochs),(()=>`For fitDataset(), config.epochs is expected to be a positive integer, but got ${n.epochs}`)),s.util.assert(!r||n.batchesPerEpoch>0&&Number.isInteger(n.batchesPerEpoch),(()=>`For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got ${n.batchesPerEpoch}`)),s.util.assert(null==n.validationSplit,(()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead.")),t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");t.isTraining=!0;try{const i=null!=n.validationData;let a,l;if(i)if(Lh(n.validationData))s.util.assert(null==n.validationBatches||n.validationBatches>0&&Number.isInteger(n.validationBatches),(()=>`For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got ${n.validationBatches}`));else{const t=function(t){if(3===t.length)throw new o("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(n.validationData);a=t.xs,l=t.ys}const u=t.makeTrainFunction(),h=t.getDedupedMetricsNames();let c;c=i?h.slice().concat(h.map((t=>"val_"+t))):h.slice();const p=ju(n.callbacks,n.yieldEvery),d=null==n.verbose?1:n.verbose,{callbackList:g,history:m}=Hu(p,d,n.epochs,null,null,function(t,e){let n=null;null!=e.batchesPerEpoch?n=e.batchesPerEpoch:Number.isFinite(t.size)&&(n=t.size);return n}(e,n),null,i,c);g.setModel(t),t.history=m,await g.onTrainBegin(),t.stopTraining_=!1;let b=null==n.initialEpoch?0:n.initialEpoch,y=await e.iterator();for(;b<n.epochs;){const o={};await g.onEpochBegin(b);let c=0,p=0;for(r||(y=await e.iterator());!r||c<n.batchesPerEpoch;){const e=await y.next();if(r&&e.done){console.warn(`You provided \`batchesPerEpoch\` as ${n.batchesPerEpoch}, but your dataset iterator ran out of data after ${c} batches; interrupting training. Make sure that your dataset can generate at least \`batchesPerEpoch * epochs\` batches (in this case, `+n.batchesPerEpoch*n.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=e.value){const{xs:r,ys:i}=Dh(t,e.value),a={};a.batch=p,a.size=r[0].shape[0],await g.onBatchBegin(p,a);const o=[];if(null!=n.classWeight){const e=Ch(n.classWeight,t.outputNames);for(let t=0;t<e.length;++t)o.push(await Th(i[t],null,e[t]))}const l=r.concat(i).concat(o),d=u(l);s.dispose(l);for(let t=0;t<h.length;++t){const e=h[t],n=d[t];a[e]=n,s.keep(n)}await g.onBatchEnd(p,a),Pu(a),p++,c++}if(r?c>=n.batchesPerEpoch:e.done){if(i){let e;e=Lh(n.validationData)?f(await t.evaluateDataset(n.validationData,{batches:n.validationBatches})):f(t.evaluate(a,l,{batchSize:null==n.validationBatchSize?32:n.validationBatchSize,verbose:0}));for(let n=0;n<t.metricsNames.length;++n)o[`val_${t.metricsNames[n]}`]=e[n]}break}if(t.stopTraining_)break}if(await g.onEpochEnd(b,o),b++,t.stopTraining_)break}return await g.onTrainEnd(),await t.history.syncData(),t.history}finally{t.isTraining=!1}}function Lh(t){return"function"==typeof t.iterator}function Rh(t){s.util.assert(t>0&&Number.isInteger(t),(()=>`batchSize is required to be a positive integer, but got ${t}`))}function Oh(t,e,n){return null==t?[null]:Array.isArray(t)?t.map((t=>nt(t,e,n-e))):nt(t,e,n-e)}function Bh(t,e){return s.tidy((()=>null==t?null:Array.isArray(t)?t.map((t=>Bh(t,e))):ht(t,"int32"===e.dtype?e:s.cast(e,"int32"))))}function Ph(t,e){const n=[];let s=0,r=null;for(;s<t;)r=s+e,r>=t&&(r=t),n.push([s,r]),s=r;return n}async function Wh(t,n,r,i={}){if(t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let l,u,h,c,p,d,f,g,m;t.isTraining=!0;try{const b=null==i.batchSize?32:i.batchSize;Rh(b);const y=!1,w=await t.standardizeUserData(n,r,i.sampleWeight,i.classWeight,y,b);l=w[0],u=w[1],m=w[2];let k,v=!1;if(null!=i.validationData&&i.validationData.length>0){if(v=!0,2!==i.validationData.length)throw 3===i.validationData.length?new o("validationData including sample weights is not supported yet."):new a(`When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; ${i.validationData} is invalid.`);p=i.validationData[0],d=i.validationData[1];const e=!0,n=await t.standardizeUserData(p,d,null,null,e,b);f=n[0],g=n[1],k=f.concat(g)}else if(null!=i.validationSplit&&i.validationSplit>0&&i.validationSplit<1){v=!0;const t=Math.floor(l[0].shape[0]*(1-i.validationSplit)),e=l[0].shape[0];f=Oh(l,t,e),h=l,l=Oh(l,0,t),g=Oh(u,t,e),c=u,u=Oh(u,0,t),k=f.concat(g)}else null!=i.validationSteps&&(v=!0);const x=l.concat(u).concat(m);t.checkTrainableWeightsConsistency();const S=t.makeTrainFunction(),N=t.getDedupedMetricsNames();let E,I;v?(t.makeTestFunction(),E=t.testFunction,I=N.slice().concat(N.map((t=>"val_"+t)))):(E=null,k=[],I=N.slice());const A=ju(i.callbacks,i.yieldEvery),$=await async function(t,n,r,i,l,u,h,c,p,d,f,g,m,b,y){null==l&&(l=32),null==u&&(u=1),null==f&&(f=!0),null==m&&(m=0);let w=!1;if(null!=p&&null!=d&&(w=!0),null!=y&&(w=!0,null==b))throw new a("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const k=t.checkNumSamples(r,l,b,"steps_per_epoch");let v;null!=k&&(v=Y(0,k)),null==h&&(h=1);const{callbackList:x,history:S}=Hu(c,h,u,m,k,b,l,w,g);x.setModel(t),t.history=S,await x.onTrainBegin(),t.stopTraining_=!1;for(let a=m;a<u;++a){await x.onEpochBegin(a);const u={};if(null!=b)throw new o("stepsPerEpoch mode is not implemented yet.");{if("batch"===f)throw new o("batch shuffling is not implemneted yet");f&&e.util.shuffle(v);const a=e.tensor1d(v),h=Ph(k,l);for(let e=0;e<h.length;++e){const o={};if(await x.onBatchBegin(e,o),s.tidy((()=>{const c=h[e][0],f=h[e][1],g=nt(a,c,f-c);o.batch=e,o.size=f-c;const m=Bh(r,g),b=n(m);for(let t=0;t<i.length;++t){const e=i[t],n=b[t];o[e]=n,s.keep(n)}if(e===h.length-1&&w){const e=t.testLoop(p,d,l);for(let t=0;t<i.length;++t){const n=i[t],r=e[t];s.keep(r),u["val_"+n]=r}}})),await x.onBatchEnd(e,o),Pu(o),t.stopTraining_)break}a.dispose()}if(await x.onEpochEnd(a,u),t.stopTraining_)break}return await x.onTrainEnd(),await t.history.syncData(),t.history}(t,S,x,N,b,i.epochs,i.verbose,A,E,k,i.shuffle,I,i.initialEpoch,null,null);return $}finally{t.isTraining=!1,Kh(l,n),Kh(u,r),Kh(h,n),Kh(c,r),Kh(f,p),Kh(g,d),null!=m&&s.dispose(m)}}function Uh(t){const n=[];t instanceof e.Tensor&&(t=[t]);for(let e=0;e<t.length;++e){const s=t[e];if(1===s.rank)n.push(et(s,1));else{if(0===s.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");n.push(s)}}return n}function Kh(t,n){if(null==t)return;const s=[];if(n instanceof e.Tensor)s.push(n.id);else if(Array.isArray(n))n.forEach((t=>s.push(t.id)));else if(null!=n)for(const t in n){const e=n[t];s.push(e.id)}const r=[];if(t instanceof e.Tensor)-1===s.indexOf(t.id)&&r.push(t);else if(Array.isArray(t))t.forEach((t=>{-1===s.indexOf(t.id)&&r.push(t)}));else if(null!=t)for(const e in t){const n=t[e];-1===s.indexOf(n.id)&&r.push(n)}r.forEach((t=>{t.isDisposed||t.dispose()}))}function Vh(t){return Array.isArray(t)}function qh(t){return!function(t){return t instanceof e.Tensor}(t)&&!Vh(t)}function jh(t,e,n,s=!0,r=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(Vh(t)&&t.length>0)e=!0;else if(qh(t)){for(const n in t)if(t.hasOwnProperty(n)){e=!0;break}}else e=!0;if(e)throw new a(`Error when checking model ${r} expected no data, but got ${t}`)}return[]}if(null==t)return e.map((t=>null));let i;if(qh(t)){i=[];for(const n of e){if(null==t[n])throw new a(`No data provided for "${n}". Need data for each key in: ${e}`);i.push(t[n])}}else if(Vh(t)){if(t.length!==e.length)throw new a(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): ${t}`);i=t}else{if(e.length>1)throw new a(`The model ${r} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape ${t.shape}`);i=[t]}if(i=Uh(i),null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const o=i[t];if(o.shape.length!==n[t].length)throw new a(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s). but got array with shape ${o.shape}`);for(let e=0;e<n[t].length;++e){if(0===e&&!s)continue;const i=o.shape[e],l=n[t][e];if(null!=l&&l>=0&&i!==l)throw new a(`${r} expected a batch of elements where each example has shape [${n[t].slice(1,n[t].length)}] (i.e.,tensor shape [*,${n[t].slice(1,n[t].length)}]) but the ${r} received an input with ${o.shape[0]} examples, each with shape [${o.shape.slice(1,o.shape.length)}] (tensor shape [${o.shape}])`)}}return i}function Gh(t,e,n,s=!0,r=""){let i;if(Array.isArray(t)){if(t.length!==e.length)throw new a(`Error when checking model ${r}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);i=t}else{if(e.length>1)throw new a(`The model expects ${e.length} ${r} Tensors, but only received one Tensor. Found: array with shape ${JSON.stringify(t.shape)}.`);i=[t]}if(null!=n)for(let t=0;t<e.length;++t){if(null==n[t])continue;const o=i[t];if(o.shape.length!==n[t].length)throw new a(`Error when checking ${r}: expected ${e[t]} to have ${n[t].length} dimension(s), but got array with shape ${JSON.stringify(o.shape)}`);for(let i=0;i<n[t].length;++i){if(0===i&&!s)continue;const l=o.shape[i],u=n[t][i];if(null!=u&&u!==l)throw new a(`Error when checking ${r}: expected ${e[t]} to have shape ${JSON.stringify(n[t])} but got array with shape ${JSON.stringify(o.shape)}.`)}}}class Hh extends zh{constructor(t){super(t),this.isTraining=!1}summary(t,e,n=console.log){if(!this.built)throw new a("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");vh(this,t,e,n)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const n={Adagrad:()=>e.train.adagrad(.01),Adadelta:()=>e.train.adadelta(1,.95,Q()),Adam:()=>e.train.adam(.001,.9,.999,Q()),Adamax:()=>e.train.adamax(.002,.9,.999,Q(),0),RMSProp:()=>e.train.rmsprop(.001,.9,0,Q()),SGD:()=>e.train.sgd(.01)};if(n.adagrad=n.Adagrad,n.adadelta=n.Adadelta,n.adam=n.Adam,n.adamax=n.Adamax,n.rmsprop=n.RMSProp,n.sgd=n.SGD,t in n)return n[t]();throw new a(`Unknown Optimizer ${t}`)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof e.Optimizer))throw new a("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let n=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new a(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const e=t.loss;n=e.map((t=>ih(t)))}else{const e=ih(t.loss);this.outputs.forEach((t=>{n.push(e)}))}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new a(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: ${this.outputNames}`);for(const e of this.outputNames)null==t.loss[e]&&console.warn(`Output "${e}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${e} during training`),n.push(ih(t.loss[e]))}this.lossFunctions=n,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],n=this.outputNames[t];this.feedOutputNames.push(n),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const s=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],K("loss",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==s.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}}));const r=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map((t=>[]));let n;if("string"==typeof t||"function"==typeof t)n=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError(`Type of metrics argument not understood. Expected an string,function, Array, or Object, found: ${t}`);n=t}if(Array.isArray(n))return e.map((t=>n));{const t=[];for(const s of e){let e=n.hasOwnProperty(s)?n[s]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),i=(t,e,n)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([n,t])};K("metric",(()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==s.indexOf(t))continue;(e=>{let n,s,r;for(const a of e){if("string"==typeof a&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(a)){const e=this.internalOutputShapes[t];let i;1===e[e.length-1]||this.lossFunctions[t]===nh?-1!==["accuracy","acc"].indexOf(a)?s=ah:-1!==["crossentropy","ce"].indexOf(a)&&(s=ch):this.lossFunctions[t]===eh?-1!==["accuracy","acc"].indexOf(a)?s=ph:-1!==["crossentropy","ce"].indexOf(a)&&(s=fh):-1!==["accuracy","acc"].indexOf(a)?s=oh:-1!==["crossentropy","ce"].indexOf(a)&&(s=dh),-1!==["accuracy","acc"].indexOf(a)?i="acc":-1!==["crossentropy","ce"].indexOf(a)&&(i="ce"),r=s,n=""+i}else{const t=mh(a);r=t,n=""+bh(a)}let e;K(n,(()=>{e=r})),i(t,n,e)}})(r[t])}})),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,n={}){const s=null==n.batchSize?32:n.batchSize;Rh(s);const r=this.standardizeUserDataXY(t,e,!0,s);try{const i=r[0].concat(r[1]);this.makeTestFunction();const a=this.testFunction;return d(this.testLoop(a,i,s,n.verbose,n.steps))}finally{Kh(r[0],t),Kh(r[1],e)}}async evaluateDataset(t,n){return this.makeTestFunction(),async function(t,n,r){const i=null!=(r=r||{}).batches,a=t.testFunction;let l=[];if(r.verbose>0)throw new o("Verbose mode is not implemented yet.");s.util.assert(!i||r.batches>0&&Number.isInteger(r.batches),(()=>`Test loop expects \`batches\` to be a positive integer, but received ${JSON.stringify(r.batches)}`));const u="function"==typeof n.next?n:await n.iterator();let h=0,c=0;for(;!i||c<r.batches;){const n=await u.next();if(l=s.tidy((()=>{if(n.value){const{xs:r,ys:i}=Dh(t,n.value),o=r.concat(i),u=s.tidy((()=>a(o)));if(s.dispose(o),0===c)for(let t=0;t<u.length;++t)l.push(e.scalar(0));const p=o[0].shape[0];for(let t=0;t<u.length;++t){const e=u[t],n=l[t];l[t]=s.tidy((()=>s.add(l[t],s.mul(p,e)))),c>0&&s.dispose(n)}s.dispose(u),h+=p,++c}return l})),n.done){i&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${r.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let t=0;t<l.length;++t){const e=l[t];l[t]=s.div(l[t],h),s.dispose(e)}return d(l)}(this,t,n)}checkNumSamples(t,e,n,s="steps"){let r;if(null!=n){if(r=null,null!=e)throw new a(`If ${s} is set, batchSize must be null or undefined.Got batchSize = ${e}`)}else{if(null==t)throw new a(`Either the input data should have a defined shape, or ${s} shoud be specified.`);r=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return r}execute(t,n){if(Array.isArray(n)&&0===n.length)throw new a("`outputs` is an empty Array, which is not allowed.");const s=Array.isArray(n),r=s?n:[n],i=this.retrieveSymbolicTensors(r),o=new ne;if(t instanceof e.Tensor&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new a(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)o.add(this.inputs[e],t[e])}else for(const e of this.inputs){const n=t[e.name];if(null==n)throw new a(`No value is provided for the model's input ${e.name}`);o.add(e,n)}const l=ie(i,o);return s?l:l[0]}retrieveSymbolicTensors(t){const e=h(null,t.length);let n=t.length;for(const s of this.layers){const r=Array.isArray(s.output)?s.output:[s.output],i=r.map((t=>t.name));for(let s=0;s<t.length;++s){const a=i.indexOf(t[s]);if(-1!==a&&(e[s]=r[a],n--),0===n)break}if(0===n)break}if(n>0){const n=[];throw e.forEach(((e,s)=>{null==e&&n.push(t[s])})),new a(`Cannot find SymbolicTensors for output name(s): ${JSON.stringify(n)}`)}return e}predictLoop(t,e=32,n=!1){return s.tidy((()=>{const r=this.checkNumSamples(t);if(n)throw new o("Verbose predictLoop() is not implemented yet.");const i=Ph(r,e),a=this.outputs.map((t=>[]));for(let e=0;e<i.length;++e){s.tidy((()=>{const n=i[e][0],s=i[e][1],r=Oh(t,n,s),a=[];if(Array.isArray(r))for(let t=0;t<r.length;++t)a.push({key:this.inputs[t],value:r[t]});else a.push({key:this.inputs[0],value:r});const o=new ne(a);return ie(this.outputs,o)})).forEach(((t,e)=>a[e].push(t)))}return d(a.map((t=>s.concat(t,0))))}))}predict(t,e={}){const n=Uh(t);Gh(n,this.inputNames,this.feedInputShapes,!1);try{const s=null==e.batchSize?32:e.batchSize;return Rh(s),this.predictLoop(n,s)}finally{Kh(n,t)}}predictOnBatch(t){Gh(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,n,s=!0,r){if(null==this.optimizer_)throw new i("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const o=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===eh?o.push(e.slice(0,e.length-1).concat([1])):o.push(e)}if(function(t,n,s){const r=x(t.map((t=>t.shape[0])));r.sort();const i=x(n.map((t=>t.shape[0])));if(i.sort(),r.length>1)throw new a(`All input Tensors (x) should have the same number of samples. Got array shapes: ${JSON.stringify(t.map((t=>t.shape)))}`);if(i.length>1)throw new a(`All target Tensors (y) should have the same number of samples. Got array shapes: ${JSON.stringify(n.map((t=>t.shape)))}`);if(r.length>0&&i.length>0&&!e.util.arraysEqual(r,i))throw new a(`Input Tensors should have the same number of samples as target Tensors. Found ${r[0]} input sample(s) and ${i[0]} target sample(s).`)}(t=jh(t,this.feedInputNames,this.feedInputShapes,!1,"input"),n=jh(n,this.feedOutputNames,o,!1,"target")),function(t,e,n){const s=[Yu,nh,th];for(let r=0;r<t.length;++r){const i=t[r],o=e[r],l=n[r];if(null!=o){if(o===th&&1===i.shape[i.shape.length-1])throw new a(`You are passing a target array of shape ${i.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==s.indexOf(o)){const t=i.shape.slice(1),e=l.slice(1);for(let n=0;n<t.length;++n){const s=t[n],r=e[n];if(null!=r&&s!==r)throw new a(`A target Tensor with shape ${i.shape} was passed for an output of shape ${l}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(n,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=r&&r>0&&t[0].shape[0]%r!=0)throw new a(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${r}. Found: ${t[0].shape[0]} sample(s).`);return[t,n]}async standardizeUserData(t,e,n,s,r=!0,i){const[a,o]=this.standardizeUserDataXY(t,e,r,i);if(null!=n)throw new Error("sample weight is not supported yet.");let l=null;if(null!=s){const t=Ch(s,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await Th(o[e],null,t[e]))}return[a,o,l]}testLoop(t,n,r,i=0,a){return s.tidy((()=>{const l=this.checkNumSamples(n,r,a,"steps"),u=[];if(i>0)throw new o("Verbose mode is not implemented yet.");if(null!=a)throw new o("steps mode in testLoop() is not implemented yet");{const i=Ph(l,r),a=e.tensor1d(Y(0,l));for(let r=0;r<i.length;++r){const o=i[r][0],l=i[r][1],h=nt(a,o,l-o),c=Bh(n,h),p=t(c);if(0===r)for(let t=0;t<p.length;++t)u.push(e.scalar(0));for(let t=0;t<p.length;++t){const e=p[t];u[t]=s.add(u[t],s.mul(l-o,e))}}for(let t=0;t<u.length;++t)u[t]=s.div(u[t],l)}return u}))}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let n=0;n<t.length;++n){const s=t[n];let r=s;if(p(t,s)>1){r+=`_${p(t.slice(0,n),s)}`}e.push(r)}return e}makeTrainFunction(){return t=>{const e=[],n=t.slice(0,this.inputs.length),r=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),i=t.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],o=this.collectedTrainableWeights.map((t=>t.read()));return[this.optimizer_.minimize((()=>{const t=[];for(let e=0;e<this.inputs.length;++e)t.push({key:this.inputs[e],value:n[e]});const o=new ne(t),l=ie(this.outputs,o,{training:!0});let u;for(let t=0;t<this.lossFunctions.length;++t){let n=(0,this.lossFunctions[t])(r[t],l[t]);null!=i[t]&&(n=_h(n,i[t]));const a=s.mean(n);e.push(a),u=0===t?n:s.add(u,n)}for(let t=0;t<this.metricsTensors.length;++t){let n;if(this.outputs.length>1&&t<this.outputs.length)n=e[t];else{const e=this.metricsTensors[t][0],i=this.metricsTensors[t][1];n=s.mean(e(r[i],l[i]))}s.keep(n),a.push(n)}return u=s.mean(u),this.calculateLosses().forEach((t=>{u=s.add(u,t)})),u}),!0,o)].concat(a)}}makeTestFunction(){this.testFunction=t=>s.tidy((()=>{const e=[];let n;const r=t.slice(0,this.inputs.length),i=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:r[t]});const o=new ne(a),l=ie(this.outputs,o);for(let t=0;t<this.lossFunctions.length;++t){const r=this.lossFunctions[t],a=s.mean(r(i[t],l[t]));n=0===t?a:s.add(n,a),e.push(n)}for(let t=0;t<this.metricsTensors.length;++t){const n=this.metricsTensors[t][0],r=this.metricsTensors[t][1],a=s.mean(n(i[r],l[r]));e.push(a)}return e}))}async fit(t,e,n={}){return Wh(this,t,e,n)}async fitDataset(t,e){return Mh(this,t,e)}async trainOnBatch(t,e){const n=await this.standardizeUserData(t,e),r=n[0],i=n[1],a=this.makeTrainFunction()(r.concat(i)),o=[];for(const t of a){const e=await t.data();o.push(e[0])}return s.dispose(a),Kh(n[0],t),Kh(n[1],e),d(o)}getNamedWeights(t){const e=[],n=null!=t&&t.trainableOnly,s=n?this.trainableWeights:this.weights,r=this.getWeights(n);for(let t=0;t<s.length;++t)n&&!s[t].trainable||e.push({name:s[t].originalName,tensor:r[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const t=super.dispose();if(0===t.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const e=s.memory().numTensors;this.optimizer_.dispose(),t.numDisposedVariables+=e-s.memory().numTensors}return t}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=g(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map((t=>g(t)))}else{const e=Object.keys(this.loss);t={};const n=this.loss;for(const s of e){if("string"!=typeof n[s])throw new Error("Serialization of non-string loss is not supported.");t[s]=g(n[s])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[g(bh(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map((t=>g(bh(t))));{const t={};for(const e in this.metrics)t[e]=g(bh(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=Ju(Ih(t.optimizer_config));let n,s;if("string"==typeof t.loss)n=m(t.loss);else if(Array.isArray(t.loss))n=t.loss.map((t=>m(t)));else if(null!=t.loss){n={};for(const e in t.loss)n[e]=m(t.loss[e])}if(Array.isArray(t.metrics))s=t.metrics.map((t=>m(t)));else if(null!=t.metrics){s={};for(const e in t.metrics)s[e]=m(t.metrics[e])}this.compile({loss:n,metrics:s,optimizer:e})}async save(t,n){if("string"==typeof t){const n=e.io.getSaveHandlers(t);if(0===n.length)throw new a(`Cannot find any save handlers for URL '${t}'`);if(n.length>1)throw new a(`Found more than one (${n.length}) save handlers for URL '${t}'`);t=n[0]}if(null==t.save)throw new a("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const s=await e.io.encodeWeights(this.getNamedWeights(n)),r={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v3.19.0",convertedBy:null};if(null!=n&&n.includeOptimizer&&null!=this.optimizer){r.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:n,specs:i}=await e.io.encodeWeights(await this.optimizer.getWeights(),t);s.specs.push(...i),s.data=e.io.concatenateArrayBuffers([s.data,n])}if(null!=this.userDefinedMetadata){const t=!0;wh(this.userDefinedMetadata,this.name,t),r.userDefinedMetadata=this.userDefinedMetadata}return r.weightData=s.data,r.weightSpecs=s.specs,t.save(r)}setUserDefinedMetadata(t){wh(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}Hh.className="Model",e.serialization.registerClass(Hh);class Jh extends Hh{}async function Zh(t,n){if(null==n&&(n={}),"string"==typeof t){const s=e.io.getLoadHandlers(t,n);if(0===s.length)s.push(e.io.browserHTTPRequest(t,n));else if(s.length>1)throw new a(`Found more than one (${s.length}) load handlers for URL '${t}'`);t=s[0]}return async function(t,n,s){null==s&&(s={});if(null==t.load)throw new a("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const r=await t.load();let i=r.modelTopology;null!=i.model_config&&(i=i.model_config);const o=null==s.strict||s.strict,l=null!=r.weightData&&null!=r.weightSpecs&&o,u=Ju(Ih(i),n,l),h=r.trainingConfig;null!=h&&u.loadTrainingConfig(h);null!=r.userDefinedMetadata&&u.setUserDefinedMetadata(r.userDefinedMetadata);if(null!=r.weightData){if(null==r.weightSpecs)throw new a("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:n}=function(t,n){const s=e.io.decodeWeights(t,n),r={},i=[];return n.forEach((t=>{"optimizer"===t.group?i.push({name:t.name,tensor:s[t.name]}):r[t.name]=s[t.name]})),{modelWeights:r,optimizerWeights:i}}(r.weightData,r.weightSpecs);u.loadWeights(t,o),null!=u.optimizer&&n.length>0&&await u.optimizer.setWeights(n),e.dispose(t),e.dispose(n.map((t=>t.tensor)))}return u}(t,void 0,n)}Jh.className="Functional",e.serialization.registerClass(Jh);class Yh extends Hh{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:_("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some((t=>t<0)))throw new a(`Negative dimension size caused by adding layer ${t.name} with input shape [${t.inboundNodes[0].inputTensors[0].shape}]`)}add(t){const e=t instanceof Yh||t instanceof Hh;let n;if(e){if(n=t,1!==n.outputs.length)throw new a("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==n.inputs.length)throw new a("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new a("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=ee({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=n.outputs,this.inputs=n.inputs;else{if(1!==t.inboundNodes.length)throw new a(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new a("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=Qt(this.outputs[0])}this.inboundNodes=[],new Zt({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:h(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map((t=>t.shape)),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(Wt(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new Hh({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,n=console.log){this.built||this.build(),super.summary(t,e,n)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,n={}){if(!this.built)throw new i("The model needs to be compiled before being used.");return this.model.evaluate(t,e,n)}async evaluateDataset(t,e){if(!this.built)throw new i("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,n={}){if(!this.built)throw new i("The model needs to be compiled before being used.");return this.model.fit(t,e,n)}async fitDataset(t,e){if(!this.built)throw new i("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,n,s={},r=!1){let i,l={};if(n instanceof Array){if(null==n[0].className||"Merge"===n[0].className)throw new a("Legacy serialization format not supported yet.");i=n}else e.util.assert(null!=n.layers,(()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field.")),i=n.layers,delete n.layers,l=n;const u=new t(l);if(!(u instanceof Yh))throw new o(`Sequential.fromConfig called on non-Sequential input: ${u}`);for(const t of i){const e=Ju(t,void 0,r);r&&e.setFastWeightInitDuringBuild(!0),u.add(e)}return u}set stopTraining(t){if(null==this.model)throw new a("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new a("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const n={};n.className=e.getClassName(),n.config=e.getConfig(),t.push(n)}return{name:this.name,layers:t}}}function Xh(t){return ee(t)}Yh.className="Sequential",e.serialization.registerClass(Yh);class Qh extends e.serialization.Serializable{getConfig(){return{}}}class tc extends Qh{apply(t,e=1){return function(t,e=1){if(1!==e)throw new o(`Support for alpha values other than 1 (${e}) is not implemented yet.`);return s.elu(t)}(t,e)}}tc.className="elu",e.serialization.registerClass(tc);class ec extends Qh{apply(t){return s.selu(t)}}ec.className="selu",e.serialization.registerClass(ec);class nc extends Qh{apply(t){return s.relu(t)}}nc.className="relu",e.serialization.registerClass(nc);class sc extends Qh{apply(t){return e.tidy((()=>s.minimum(6,s.relu(t))))}}sc.className="relu6",e.serialization.registerClass(sc);class rc extends Qh{apply(t){return t}}rc.className="linear",e.serialization.registerClass(rc);class ic extends Qh{apply(t){return s.sigmoid(t)}}ic.className="sigmoid",e.serialization.registerClass(ic);class ac extends Qh{apply(t){return function(t){return e.tidy((()=>{const e=s.add(.5,s.mul(.2,t));return s.clipByValue(e,0,1)}))}(t)}}ac.className="hardSigmoid",e.serialization.registerClass(ac);class oc extends Qh{apply(t){return s.softplus(t)}}oc.className="softplus",e.serialization.registerClass(oc);class lc extends Qh{apply(t){return function(t){return e.tidy((()=>s.div(t,s.add(s.abs(t),1))))}(t)}}lc.className="softsign",e.serialization.registerClass(lc);class uc extends Qh{apply(t){return s.tanh(t)}}uc.className="tanh",e.serialization.registerClass(uc);class hc extends Qh{apply(t,e=-1){return s.softmax(t,e)}}hc.className="softmax",e.serialization.registerClass(hc);class cc extends Qh{apply(t,e=-1){return s.logSoftmax(t,e)}}cc.className="logSoftmax",e.serialization.registerClass(cc);class pc extends Qh{apply(t,n=1){return e.tidy((()=>s.mul(s.sigmoid(s.mul(t,n)),t)))}}pc.className="swish",e.serialization.registerClass(pc);class dc extends Qh{apply(t){return e.tidy((()=>s.mul(t,s.tanh(s.softplus(t)))))}}function fc(t){return t.getClassName()}function gc(t,n={}){return k(t,e.serialization.SerializationMap.getMap().classNameMap,n,"activation")}function mc(t){if(null==t){const t={className:"linear",config:{}};return gc(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},gc(e)}return t instanceof Qh?t:gc(t)}function bc(t){if(null!=t&&"object"!=typeof t)throw new Error(`Argument to L1L2 regularizer's constructor is expected to be an object, but received: ${t}`)}dc.className="mish",e.serialization.registerClass(dc);class yc extends e.serialization.Serializable{}class wc extends yc{constructor(t){super(),bc(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(t){return e.tidy((()=>{let n=e.zeros([1]);return this.hasL1&&(n=e.add(n,e.sum(s.mul(this.l1,e.abs(t))))),this.hasL2&&(n=e.add(n,e.sum(s.mul(this.l2,ct(t))))),s.reshape(n,[])}))}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}wc.className="L1L2",e.serialization.registerClass(wc);const kc={l1l2:"L1L2"};function vc(t){return y(t)}function xc(t,n={}){return k(t,e.serialization.SerializationMap.getMap().classNameMap,n,"regularizer")}function Sc(t){if(null==t)return null;if("string"==typeof t){return xc({className:t in kc?kc[t]:t,config:{}})}return t instanceof yc?t:xc(t)}class Nc extends Xt{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,n){t=Pt(t);let s=e.relu(t);return null!=this.maxValue&&(s=e.clipByValue(s,0,this.maxValue)),s}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}Nc.className="ReLU",e.serialization.registerClass(Nc);class Ec extends Xt{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,n){const s=Pt(t);return e.leakyRelu(s,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Ec.className="LeakyReLU",e.serialization.registerClass(Ec);class Ic extends Xt{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=Rt(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Sc(t.alphaRegularizer),this.alphaConstraint=Mu(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new a(`Expected sharedAxes to be a number or an array of numbers, but got ${t.sharedAxes}`);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=Wt(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const n={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)n[e]=t[e];this.inputSpec=[new Gt({ndim:t.length,axes:n})],this.built=!0}call(t,n){return t=Pt(t),e.prelu(t,this.alpha.read())}getConfig(){const t={alphaInitializer:Lt(this.alphaInitializer),alphaRegularizer:vc(this.alphaRegularizer),alphaConstraint:Du(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}Ic.className="PReLU",e.serialization.registerClass(Ic);class Ac extends Xt{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new o(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,n){const s=Pt(t);return e.elu(s)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Ac.className="ELU",e.serialization.registerClass(Ac);class $c extends Xt{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,n){const s=Pt(t);return e.mul(s,e.cast(e.greater(s,this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}$c.className="ThresholdedReLU",e.serialization.registerClass($c);class zc extends Xt{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new hc).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const n=Pt(t);return this.softmax(n,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Cc(t,e,n){if("number"==typeof t)return h(t,e);if(t.length!==e)throw new a(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let r=0;r<e;++r){const i=t[r];if((s=i)!==parseInt(s.toString(),10))throw new a(`The ${n} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number ${i}`)}return t;var s}function Tc(t,e,n,s,r=1){if(null==t)return t;let i;return i="same"===n?t:t-(e+(e-1)*(r-1))+1,Math.floor((i+s-1)/s)}function _c(t,e,n,s){if(null==t)return null;if("valid"===s)t=t*e+Z([n-e,0]);else{if("same"!==s)throw new a(`Unsupport padding mode: ${s}.`);t*=e}return t}function Dc(t,n){return e.tidy((()=>(B(n),"channelsFirst"===n?s.transpose(t,[0,2,3,1]):t)))}function Fc(t,n){return e.tidy((()=>(B(n),"channelsFirst"===n?s.transpose(t,[0,2,3,4,1]):t)))}function Mc(t,n,r,i=[1,1],l="valid",u,h,c=null){return e.tidy((()=>{if(null==u&&(u="channelsLast"),B(u),3!==t.rank&&4!==t.rank)throw new a(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${t.rank}.`);if(3!==n.rank&&4!==n.rank)throw new a(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${t.rank}.`);let e=Dc(t,u);if("causal"===l)throw new o("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return e=s.fused.conv2d({x:e,filter:n,strides:i,pad:"same"===l?"same":"valid",dilations:h,dataFormat:"NHWC",bias:r,activation:c}),"channelsFirst"===u&&(e=s.transpose(e,[0,3,1,2])),e}))}zc.className="Softmax",e.serialization.registerClass(zc);class Lc extends Xt{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",Lc.verifyArgs(e),this.rank=t,I(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new o(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=Cc(e.kernelSize,t,"kernelSize"),this.strides=Cc(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,P(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,B(this.dataFormat),this.activation=mc(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=Rt(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=Mu(e.biasConstraint),this.biasRegularizer=Sc(e.biasRegularizer),this.activityRegularizer=Sc(e.activityRegularizer),this.dilationRate=Cc(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new a(`dilationRate must be a number or an array of a single number for 1D convolution, but received ${JSON.stringify(this.dilationRate)}`);if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new a(`dilationRate must be a number or array of two numbers for 2D convolution, but received ${JSON.stringify(this.dilationRate)}`)}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new a(`dilationRate must be a number or array of three numbers for 3D convolution, but received ${JSON.stringify(this.dilationRate)}`)}static verifyArgs(t){if(c("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!E(t.kernelSize,"number",1,3))throw new a(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:fc(this.activation),useBias:this.useBias,biasInitializer:Lt(this.biasInitializer),biasRegularizer:vc(this.biasRegularizer),activityRegularizer:vc(this.activityRegularizer),biasConstraint:Du(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class Rc extends Lc{constructor(t,e){super(t,e),this.kernel=null,Rc.verifyArgs(e),this.filters=e.filters,I(this.filters,"filters"),this.kernelInitializer=Rt(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=Mu(e.kernelConstraint),this.kernelRegularizer=Sc(e.kernelRegularizer)}build(t){t=Wt(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new a(`The channel dimension of the input should be defined. Found ${t[e]}`);const n=t[e],s=this.kernelSize.concat([n,this.filters]);this.kernel=this.addWeight("kernel",s,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:n}}],this.built=!0}call(t,n){return e.tidy((()=>{let n;t=Pt(t);const r=null==this.bias?null:this.bias.read(),i=$(this.activation.getClassName());if(null!=i&&2===this.rank)n=Mc(t,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate,i);else{if(1===this.rank)n=function(t,n,r,i=1,l="valid",u,h=1){return e.tidy((()=>{if(null==u&&(u="channelsLast"),B(u),3!==t.shape.length)throw new a(`The input of a conv1dWithBias operation should be 3, but is ${t.shape.length} instead.`);if(3!==n.shape.length)throw new a(`The kernel for a conv1dWithBias operation should be 3, but is ${n.shape.length} instead`);if(null!=r&&1!==r.shape.length)throw new a(`The bias for a conv1dWithBias operation should be 1, but is ${n.shape.length} instead`);if("channelsFirst"===u&&(t=s.transpose(t,[0,2,1])),"causal"===l)throw new o("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let e=s.conv1d(t,n,i,"same"===l?"same":"valid","NWC",h);return null!=r&&(e=dt(e,r)),e}))}(t,this.kernel.read(),r,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)n=Mc(t,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new o("convolutions greater than 3D are not implemented yet.");n=function(t,n,r,i=[1,1,1],l="valid",u,h){return e.tidy((()=>{if(null==u&&(u="channelsLast"),B(u),4!==t.rank&&5!==t.rank)throw new a(`conv3dWithBias expects input to be of rank 4 or 5, but received ${t.rank}.`);if(4!==n.rank&&5!==n.rank)throw new a(`conv3dWithBias expects kernel to be of rank 4 or 5, but received ${t.rank}.`);let e=Fc(t,u);if("causal"===l)throw new o("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return e=s.conv3d(e,n,i,"same"===l?"same":"valid","NDHWC",h),null!=r&&(e=dt(e,r)),"channelsFirst"===u&&(e=s.transpose(e,[0,4,1,2,3])),e}))}(t,this.kernel.read(),r,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(n=this.activation.apply(n))}return n}))}computeOutputShape(t){t=Wt(t);const e=[],n="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<n.length;++t){const s=Tc(n[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(s)}let s=[t[0]];return"channelsLast"===this.dataFormat?(s=s.concat(e),s.push(this.filters)):(s.push(this.filters),s=s.concat(e)),s}getConfig(){const t={filters:this.filters,kernelInitializer:Lt(this.kernelInitializer),kernelRegularizer:vc(this.kernelRegularizer),kernelConstraint:Du(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new a(`Convolution layer expected config.filters to be a 'number' > 0 but got ${JSON.stringify(t.filters)}`)}}class Oc extends Rc{constructor(t){super(2,t),Oc.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!E(t.kernelSize,"number",1,2))throw new a(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}Oc.className="Conv2D",e.serialization.registerClass(Oc);class Bc extends Rc{constructor(t){super(3,t),Bc.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new a(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}Bc.className="Conv3D",e.serialization.registerClass(Bc);class Pc extends Oc{constructor(t){if(super(t),this.inputSpec=[new Gt({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new a(`Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(4!==(t=Wt(t)).length)throw new a("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new a("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Gt({ndim:4,axes:{[e]:n}})],this.built=!0}call(t,e){return s.tidy((()=>{let e=Pt(t);if(4!==e.shape.length)throw new a(`Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${e.shape.length}`);const n=e.shape,r=n[0];let i,o;"channelsFirst"===this.dataFormat?(i=2,o=3):(i=1,o=2);const l=n[i],u=n[o],h=this.kernelSize[0],c=this.kernelSize[1],p=this.strides[0],d=this.strides[1],f=[r,_c(l,p,h,this.padding),_c(u,d,c,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(e=s.transpose(e,[0,2,3,1]));let g=s.conv2dTranspose(e,this.kernel.read(),f,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(g=s.transpose(g,[0,3,1,2])),null!=this.bias&&(g=dt(g,this.bias.read(),this.dataFormat)),null!=this.activation&&(g=this.activation.apply(g)),g}))}computeOutputShape(t){const e=(t=Wt(t)).slice();let n,s,r;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3):(n=3,s=1,r=2);const i=this.kernelSize[0],a=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[n]=this.filters,e[s]=_c(e[s],o,i,this.padding),e[r]=_c(e[r],l,a,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Pc.className="Conv2DTranspose",e.serialization.registerClass(Pc);class Wc extends Bc{constructor(t){if(super(t),this.inputSpec=[new Gt({ndim:5})],"same"!==this.padding&&"valid"!==this.padding)throw new a(`Conv3DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode ${this.padding}`)}build(t){if(5!==(t=Wt(t)).length)throw new a("Input should have rank 5; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new a("The channel dimension of the inputs should be defined. Found `None`.");const n=t[e],s=this.kernelSize.concat([this.filters,n]);this.kernel=this.addWeight("kernel",s,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new Gt({ndim:5,axes:{[e]:n}})],this.built=!0}call(t,e){return s.tidy((()=>{let e=Pt(t);if(5!==e.shape.length)throw new a(`Conv3DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-${e.shape.length}`);const n=e.shape,r=n[0];let i,o,l;"channelsFirst"===this.dataFormat?(l=2,i=3,o=4):(l=1,i=2,o=3);const u=n[l],h=n[i],c=n[o],p=this.kernelSize[0],d=this.kernelSize[1],f=this.kernelSize[2],g=this.strides[0],m=this.strides[1],b=this.strides[2],y=[r,_c(u,g,p,this.padding),_c(h,m,d,this.padding),_c(c,b,f,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(e=s.transpose(e,[0,2,3,4,1]));let w=s.conv3dTranspose(e,this.kernel.read(),y,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(w=s.transpose(w,[0,4,1,2,3])),null!==this.bias&&(w=dt(w,this.bias.read(),this.dataFormat)),null!==this.activation&&(w=this.activation.apply(w)),w}))}computeOutputShape(t){const e=(t=Wt(t)).slice();let n,s,r,i;"channelsFirst"===this.dataFormat?(n=1,s=2,r=3,i=4):(n=4,s=1,r=2,i=3);const a=this.kernelSize[0],o=this.kernelSize[1],l=this.kernelSize[2],u=this.strides[0],h=this.strides[1],c=this.strides[2];return e[n]=this.filters,e[s]=_c(e[s],u,a,this.padding),e[r]=_c(e[r],h,o,this.padding),e[i]=_c(e[i],c,l,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}Wc.className="Conv3DTranspose",e.serialization.registerClass(Wc);class Uc extends Rc{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new a("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new a("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new a(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received ${JSON.stringify(e.padding)}`);this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Rt(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Sc(e.depthwiseRegularizer),this.depthwiseConstraint=Mu(e.depthwiseConstraint),this.pointwiseInitializer=Rt(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Sc(e.pointwiseRegularizer),this.pointwiseConstraint=Mu(e.pointwiseConstraint)}build(t){if((t=Wt(t)).length<this.rank+2)throw new a(`Inputs to SeparableConv${this.rank}D should have rank ${this.rank+2}, but received input shape: ${JSON.stringify(t)}`);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new a(`The channel dimension of the inputs should be defined, but found ${JSON.stringify(t[e])}`);const n=t[e],s=this.kernelSize.concat([n,this.depthMultiplier]),r=[];for(let t=0;t<this.rank;++t)r.push(1);r.push(n*this.depthMultiplier,this.filters);const i=!0;this.depthwiseKernel=this.addWeight("depthwise_kernel",s,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,i,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",r,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,i,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,i,this.biasConstraint):this.bias=null,this.inputSpec=[new Gt({ndim:this.rank+2,axes:{[e]:n}})],this.built=!0}call(t,n){return e.tidy((()=>{let e;if(t=Pt(t),1===this.rank)throw new o("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(t=s.transpose(t,[0,2,3,1])),e=s.separableConv2d(t,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(e=dt(e,this.bias.read(),this.dataFormat)),null!=this.activation&&(e=this.activation.apply(e)),"channelsFirst"===this.dataFormat&&(e=s.transpose(e,[0,3,1,2])),e}))}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=Lt(this.depthwiseInitializer),t.pointwiseInitializer=Lt(this.pointwiseInitializer),t.depthwiseRegularizer=vc(this.depthwiseRegularizer),t.pointwiseRegularizer=vc(this.pointwiseRegularizer),t.depthwiseConstraint=Du(this.depthwiseConstraint),t.pointwiseConstraint=Du(this.pointwiseConstraint),t}}Uc.className="SeparableConv";class Kc extends Uc{constructor(t){super(2,t)}}Kc.className="SeparableConv2D",e.serialization.registerClass(Kc);class Vc extends Rc{constructor(t){super(1,t),Vc.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!E(t.kernelSize,"number",1,1))throw new a(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}Vc.className="Conv1D",e.serialization.registerClass(Vc);class qc extends Xt{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,n){return e.tidy((()=>{if(t=Pt(t),"channelsLast"===this.dataFormat){const e=rt(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return rt(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=rt(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return rt(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}}))}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}qc.className="Cropping2D",e.serialization.registerClass(qc);class jc extends Xt{constructor(t){var e;super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,B(this.dataFormat),this.interpolation=null==t.interpolation?"nearest":t.interpolation,e=this.interpolation,N(F,"InterpolationFormat",e)}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],n=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,n]}{const e=null==t[1]?null:this.size[0]*t[1],n=null==t[2]?null:this.size[1]*t[2];return[t[0],e,n,t[3]]}}call(t,e){return s.tidy((()=>{let e=Pt(t);const n=e.shape;if("channelsFirst"===this.dataFormat){e=s.transpose(e,[0,2,3,1]);const t=this.size[0]*n[2],r=this.size[1]*n[3],i="nearest"===this.interpolation?s.image.resizeNearestNeighbor(e,[t,r]):s.image.resizeBilinear(e,[t,r]);return s.transpose(i,[0,3,1,2])}{const t=this.size[0]*n[1],r=this.size[1]*n[2];return"nearest"===this.interpolation?s.image.resizeNearestNeighbor(e,[t,r]):s.image.resizeBilinear(e,[t,r])}}))}getConfig(){const t={size:this.size,dataFormat:this.dataFormat,interpolation:this.interpolation},e=super.getConfig();return Object.assign(t,e),t}}jc.className="UpSampling2D",e.serialization.registerClass(jc);class Gc extends Lc{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Rt(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=Mu(t.depthwiseConstraint),this.depthwiseRegularizer=Sc(t.depthwiseRegularizer)}build(t){if((t=Wt(t)).length<4)throw new a(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new a(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const n=t[e],s=[this.kernelSize[0],this.kernelSize[1],n,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",s,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[n*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{let n=function(t,n,r=[1,1],i="valid",o,l){return e.tidy((()=>{null==o&&(o="channelsLast"),B(o);let e=Dc(t,o);if(4!==t.rank)throw new a(`Input for depthwiseConv2d is required to be 4-D, but is instead ${t.rank}-D`);if(4!==n.rank)throw new a(`depthwiseKernel is required to be 4-D, but is instead ${n.rank}-D`);return e=s.depthwiseConv2d(e,n,r,"same"===i?"same":"valid","NHWC",l),"channelsFirst"===o&&(e=s.transpose(e,[0,3,1,2])),e}))}(t=Pt(t),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(n=dt(n,this.bias.read(),this.dataFormat)),null!=this.activation&&(n=this.activation.apply(n)),n}))}computeOutputShape(t){t=Wt(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,r=Tc(e,this.kernelSize[0],this.padding,this.strides[0]),i=Tc(n,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],s,r,i]:[t[0],r,i,s]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=Lt(this.depthwiseInitializer),t.depthwiseRegularizer=vc(this.depthwiseRegularizer),t.depthwiseConstraint=Du(this.depthwiseRegularizer),t}}function Hc(t,e,n,s){if(Array.isArray(t)){if(null!=e||null!=n)throw new a("When inputs is an array, neither initialState or constants should be provided");null!=s&&(n=t.slice(t.length-s,t.length),t=t.slice(0,t.length-s)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function r(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=r(e),constants:n=r(n)}}function Jc(t,e,n,r=!1,i,l,u=!1,h=!1){return s.tidy((()=>{const c=e.shape.length;if(c<3)throw new a(`Input should be at least 3D, but is ${c}D.`);const p=[1,0].concat(Y(2,c));if(e=s.transpose(e,p),null!=l)throw new o("The rnn() functoin of the deeplearn.js backend does not support constants yet.");u&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=i&&((i=s.cast(s.cast(i,"bool"),"float32")).rank===c-1&&(i=s.expandDims(i,-1)),i=s.transpose(i,p)),r&&(e=s.reverse(e,0),null!=i&&(i=s.reverse(i,0)));const d=[];let f,g=n;const m=e.shape[0],b=s.unstack(e);let y,w;null!=i&&(y=s.unstack(i));for(let e=0;e<m;++e){const n=b[e],r=s.tidy((()=>t(n,g)));if(null==i)f=r[0],g=r[1];else{const t=s.tidy((()=>{const t=y[e],n=s.sub(s.onesLike(t),t);return{output:s.add(s.mul(r[0],t),s.mul(g[0],n)),newStates:g.map(((e,i)=>s.add(s.mul(r[1][i],t),s.mul(e,n))))}}));f=t.output,g=t.newStates}h&&d.push(f)}if(h){const t=1;w=s.stack(d,t)}return[f,w,g]}))}Gc.className="DepthwiseConv2D",e.serialization.registerClass(Gc);class Zc extends Xt{constructor(t){let e;if(super(t),null==t.cell)throw new a("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new rp({cells:t.cell}):t.cell,null==e.stateSize)throw new a("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new Gt({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return Y(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map((t=>null))}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){Ot(t)&&(t=t[0]);let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const n=e[0];let s;if(s=this.returnSequences?[t[0],t[1],n]:[t[0],n],this.returnState){const n=[];for(const s of e)n.push([t[0],s]);return[s].concat(n)}return s}computeMask(t,e){return s.tidy((()=>{Array.isArray(e)&&(e=e[0]);const t=this.returnSequences?e:null;if(this.returnState){const e=this.states.map((t=>null));return[t].concat(e)}return t}))}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let n=0;n<t;++n)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new o("Constants support is not implemented in RNN yet.");Ot(t)&&(t=t[0]);const n=this.stateful?t[0]:null,s=t.slice(2);this.inputSpec[0]=new Gt({shape:[n,null,...s]});const r=[t[0]].concat(t.slice(2));let i;if(this.cell.build(r),i=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!e.util.arraysEqual(this.stateSpec.map((t=>t.shape[t.shape.length-1])),i))throw new a(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is ${this.cell.stateSize}`)}else this.stateSpec=i.map((t=>new Gt({shape:[null,t]})));this.stateful&&this.resetStates()}resetStates(t,n=!1){e.tidy((()=>{if(!this.stateful)throw new r("Cannot call resetStates() on an RNN Layer that is not stateful.");const i=this.inputSpec[0].shape[0];if(null==i)throw new a("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((t=>s.zeros([i,t]))):this.states_=[s.zeros([i,this.cell.stateSize])];else if(null==t)s.dispose(this.states_),null!=this.keptStates&&(s.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((t=>s.zeros([i,t]))):this.states_[0]=s.zeros([i,this.cell.stateSize]);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new a(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: ${t}`);!0===n?this.keptStates.push(this.states_.slice()):s.dispose(this.states_);for(let n=0;n<this.states_.length;++n){const s=t[n],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[n]:this.cell.stateSize,o=[i,r];if(!e.util.arraysEqual(s.shape,o))throw new a(`State ${n} is incompatible with layer ${this.name}: expected shape=${o}, received shape=${s.shape}`);this.states_[n]=s}}this.states_=this.states_.map((t=>s.keep(t.clone())))}))}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Hc(t,n,s,this.numConstants);t=r.inputs,n=r.initialState,s=r.constants;let i=[],a=[];if(null!=n){e.initialState=n,i=i.concat(n),this.stateSpec=[];for(const t of n)this.stateSpec.push(new Gt({shape:t.shape}));a=a.concat(this.stateSpec)}null!=s&&(e.constants=s,i=i.concat(s),this.numConstants=s.length);if(i[0]instanceof Ht){const n=[t].concat(i),s=this.inputSpec.concat(a),r=this.inputSpec;this.inputSpec=s;const o=super.apply(n,e);return this.inputSpec=r,o}return super.apply(t,e)}call(t,n){return e.tidy((()=>{const e=null==n?null:n.mask,s=null==n?null:n.training;let r=null==n?null:n.initialState;t=Pt(t),null==r&&(r=this.stateful?this.states_:this.getInitialState(t));const i=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(r.length!==i)throw new a(`RNN Layer has ${i} state(s) but was passed ${r.length} initial state(s).`);this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const o={training:s},l=Jc(((t,e)=>{const n=this.cell.call([t].concat(e),o);return[n[0],n.slice(1)]}),t,r,this.goBackwards,e,null,this.unroll,this.returnSequences),u=l[0],h=l[1],c=l[2];this.stateful&&this.resetStates(c,s);const p=this.returnSequences?h:u;return this.returnState?[p].concat(c):p}))}getInitialState(t){return e.tidy((()=>{let e=s.zeros(t.shape);return e=s.sum(e,[1,2]),e=et(e),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map((t=>t>1?ot(e,[1,t]):e)):this.cell.stateSize>1?[ot(e,[1,this.cell.stateSize])]:[e]}))}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const n=this.cell.getConfig();return this.getClassName()===Zc.className&&(e.cell={className:this.cell.getClassName(),config:n}),Object.assign({},n,t,e)}static fromConfig(t,e,n={}){const s=Ju(e.cell,n);return new t(Object.assign(e,{cell:s}))}}Zc.className="RNN",e.serialization.registerClass(Zc);class Yc extends Xt{}class Xc extends Yc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,I(this.units,"units"),this.activation=mc(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Rt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Rt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Rt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Sc(t.kernelRegularizer),this.recurrentRegularizer=Sc(t.recurrentRegularizer),this.biasRegularizer=Sc(t.biasRegularizer),this.kernelConstraint=Mu(t.kernelConstraint),this.recurrentConstraint=Mu(t.recurrentConstraint),this.biasConstraint=Mu(t.biasConstraint),this.dropout=J([1,Z([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=J([1,Z([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=Wt(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{if(2!==t.length)throw new a(`SimpleRNNCell expects 2 input Tensors, got ${t.length}.`);let e=t[1];t=t[0];const r=null!=n.training&&n.training;let i;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ip({ones:()=>s.onesLike(t),rate:this.dropout,training:r,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ip({ones:()=>s.onesLike(e),rate:this.recurrentDropout,training:r,dropoutFunc:this.dropoutFunc}));const o=this.dropoutMask,l=this.recurrentDropoutMask;i=ut(null!=o?s.mul(t,o):t,this.kernel.read()),null!=this.bias&&(i=dt(i,this.bias.read())),null!=l&&(e=s.mul(e,l));let u=s.add(i,ut(e,this.recurrentKernel.read()));return null!=this.activation&&(u=this.activation.apply(u)),[u,u]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:fc(this.activation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:vc(this.kernelRegularizer),recurrentRegularizer:vc(this.recurrentRegularizer),biasRegularizer:vc(this.biasRegularizer),activityRegularizer:vc(this.activityRegularizer),kernelConstraint:Du(this.kernelConstraint),recurrentConstraint:Du(this.recurrentConstraint),biasConstraint:Du(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},t,e)}}Xc.className="SimpleRNNCell",e.serialization.registerClass(Xc);class Qc extends Zc{constructor(t){t.cell=new Xc(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(s.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(s.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:r,initialState:i})}))}static fromConfig(t,e){return new t(e)}}Qc.className="SimpleRNN",e.serialization.registerClass(Qc);class tp extends Yc{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new a("GRUCell does not support reset_after parameter set to true.");this.units=t.units,I(this.units,"units"),this.activation=mc(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=mc(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Rt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Rt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Rt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Sc(t.kernelRegularizer),this.recurrentRegularizer=Sc(t.recurrentRegularizer),this.biasRegularizer=Sc(t.biasRegularizer),this.kernelConstraint=Mu(t.kernelConstraint),this.recurrentConstraint=Mu(t.recurrentConstraint),this.biasConstraint=Mu(t.biasConstraint),this.dropout=J([1,Z([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=J([1,Z([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=Wt(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,n){return e.tidy((()=>{if(2!==t.length)throw new a(`GRUCell expects 2 input Tensors (inputs, h, c), got ${t.length}.`);const e=null!=n.training&&n.training;let r=t[1];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ip({ones:()=>s.onesLike(t),rate:this.dropout,training:e,count:3,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ip({ones:()=>s.onesLike(r),rate:this.recurrentDropout,training:e,count:3,dropoutFunc:this.dropoutFunc}));const i=this.dropoutMask,o=this.recurrentDropoutMask;let l,u,h;0<this.dropout&&this.dropout<1&&(t=s.mul(t,i[0]));let c=ut(t,this.kernel.read());this.useBias&&(c=dt(c,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(r=s.mul(r,o[0]));const p=this.recurrentKernel.read(),[d,f]=s.split(p,[2*this.units,this.units],p.rank-1),g=ut(r,d),[m,b,y]=s.split(c,3,c.rank-1),[w,k]=s.split(g,2,g.rank-1);l=this.recurrentActivation.apply(s.add(m,w)),u=this.recurrentActivation.apply(s.add(b,k));const v=ut(s.mul(u,r),f);h=this.activation.apply(s.add(y,v));const x=s.add(s.mul(l,r),s.mul(s.add(1,s.neg(l)),h));return[x,x]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:fc(this.activation),recurrentActivation:fc(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:vc(this.kernelRegularizer),recurrentRegularizer:vc(this.recurrentRegularizer),biasRegularizer:vc(this.biasRegularizer),activityRegularizer:vc(this.activityRegularizer),kernelConstraint:Du(this.kernelConstraint),recurrentConstraint:Du(this.recurrentConstraint),biasConstraint:Du(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},t,e)}}tp.className="GRUCell",e.serialization.registerClass(tp);class ep extends Zc{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new tp(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(s.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(s.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}ep.className="GRU",e.serialization.registerClass(ep);class np extends Yc{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,I(this.units,"units"),this.activation=mc(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=mc(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Rt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Rt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Rt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=Sc(t.kernelRegularizer),this.recurrentRegularizer=Sc(t.recurrentRegularizer),this.biasRegularizer=Sc(t.biasRegularizer),this.kernelConstraint=Mu(t.kernelConstraint),this.recurrentConstraint=Mu(t.recurrentConstraint),this.biasConstraint=Mu(t.biasConstraint),this.dropout=J([1,Z([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=J([1,Z([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.dropoutFunc=t.dropoutFunc,this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const n=(t=Wt(t))[t.length-1];let s;if(this.kernel=this.addWeight("kernel",[n,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,n=this.units;s=new((e=class extends yt{apply(e,s){const r=t.apply([n]),i=(new kt).apply([n]),a=t.apply([2*n]);return at(at(r,i),a)}}).className="CustomInit",e)}else s=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,s,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(t,n){return e.tidy((()=>{const e=null!=n.training&&n.training;if(3!==t.length)throw new a(`LSTMCell expects 3 input Tensors (inputs, h, c), got ${t.length}.`);let r=t[1];const i=t[2];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ip({ones:()=>s.onesLike(t),rate:this.dropout,training:e,count:4,dropoutFunc:this.dropoutFunc})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ip({ones:()=>s.onesLike(r),rate:this.recurrentDropout,training:e,count:4,dropoutFunc:this.dropoutFunc}));const o=this.dropoutMask,l=this.recurrentDropoutMask;let u,h,c,p;0<this.dropout&&this.dropout<1&&(t=s.mul(t,o[0]));let d=ut(t,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(r=s.mul(r,l[0])),d=s.add(d,ut(r,this.recurrentKernel.read())),this.useBias&&(d=dt(d,this.bias.read()));const[f,g,m,b]=s.split(d,4,d.rank-1);u=this.recurrentActivation.apply(f),h=this.recurrentActivation.apply(g),c=s.add(s.mul(h,i),s.mul(u,this.activation.apply(m))),p=this.recurrentActivation.apply(b);const y=s.mul(p,this.activation.apply(c));return[y,y,c]}))}getConfig(){const t=super.getConfig(),e={units:this.units,activation:fc(this.activation),recurrentActivation:fc(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),recurrentInitializer:Lt(this.recurrentInitializer),biasInitializer:Lt(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:vc(this.kernelRegularizer),recurrentRegularizer:vc(this.recurrentRegularizer),biasRegularizer:vc(this.biasRegularizer),activityRegularizer:vc(this.activityRegularizer),kernelConstraint:Du(this.kernelConstraint),recurrentConstraint:Du(this.recurrentConstraint),biasConstraint:Du(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},t,e)}}np.className="LSTMCell",e.serialization.registerClass(np);class sp extends Zc{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new np(t),super(t)}call(t,n){return e.tidy((()=>{null!=this.cell.dropoutMask&&(s.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(s.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const e=null==n?null:n.mask,r=null==n?null:n.training,i=null==n?null:n.initialState;return super.call(t,{mask:e,training:r,initialState:i})}))}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}sp.className="LSTM",e.serialization.registerClass(sp);class rp extends Yc{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,n){return e.tidy((()=>{let e=t.slice(1);const s=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?s.push(e.splice(0,t.stateSize.length)):s.push(e.splice(0,1));s.reverse();const r=[];let i;for(let a=0;a<this.cells.length;++a){const o=this.cells[a];e=s[a],i=0===a?[t[0]].concat(e):[i[0]].concat(e),i=o.call(i,n),r.push(i.slice(1))}e=[];for(const t of r.slice().reverse())e.push(...t);return[i[0]].concat(e)}))}build(t){let e;Ot(t)&&(t=t[0]),this.cells.forEach(((n,s)=>{K(`RNNCell_${s}`,(()=>{n.build(t),e=Array.isArray(n.stateSize)?n.stateSize[0]:n.stateSize,t=[t[0],e]}))})),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map((t=>({className:t.getClassName(),config:t.getConfig()})))};return Object.assign({},t,e)}static fromConfig(t,e,n={}){const s=[];for(const t of e.cells)s.push(Ju(t,n));return new t({cells:s})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return qt(t)}setWeights(t){const e=[];for(const n of this.cells){const s=n.weights.length,r=t.splice(s);for(let t=0;t<n.weights.length;++t)e.push([n.weights[t],r[t]])}jt(e)}}function ip(t){const{ones:e,rate:n,training:r=!1,count:i=1,dropoutFunc:a}=t,o=()=>null!=a?a(e(),n):ft(e(),n),l=()=>gt(o,e,r);if(!i||i<=1)return s.keep(l().clone());return Array(i).fill(void 0).map(l).map((t=>s.keep(t.clone())))}rp.className="StackedRNNCells",e.serialization.registerClass(rp);var ap=function(t,e){var n={};for(var s in t)Object.prototype.hasOwnProperty.call(t,s)&&e.indexOf(s)<0&&(n[s]=t[s]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var r=0;for(s=Object.getOwnPropertySymbols(t);r<s.length;r++)e.indexOf(s[r])<0&&Object.prototype.propertyIsEnumerable.call(t,s[r])&&(n[s[r]]=t[s[r]])}return n};class op extends Zc{constructor(t){if(t.unroll)throw new o("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new o("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new Gt({ndim:5})]}call(t,e){return s.tidy((()=>{if(null!=this.cell.dropoutMask&&(s.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(s.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),e&&e.constants)throw new a("ConvRNN2D cell does not support constants");const n=null==e?null:e.mask,r=null==e?null:e.training,i=null==e?null:e.initialState;return super.call(t,{mask:n,training:r,initialState:i})}))}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(t){return s.tidy((()=>{const{stateSize:e}=this.cell,n=t.shape,r=this.computeSingleOutputShape(n),i=[r[0],...r.slice(2)],a=s.zeros(i);return Array.isArray(e)?Array(e.length).fill(a):[a]}))}resetStates(t,n=!1){s.tidy((()=>{if(!this.stateful)throw new r("Cannot call resetStates() on an RNN Layer that is not stateful.");const i=this.inputSpec[0].shape,o=this.computeSingleOutputShape(i),l=[o[0],...o.slice(2)];if(null==i[0])throw new a("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>s.zeros(l))):this.states_=[s.zeros(l)];else if(null==t)s.dispose(this.states_),null!=this.keptStates&&(s.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map((()=>s.zeros(l))):this.states_[0]=s.zeros(l);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new a(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: ${t}`);n?this.keptStates.push(this.states_.slice()):s.dispose(this.states_);for(let n=0;n<this.states_.length;++n){const s=t[n],r=l;if(!e.util.arraysEqual(s.shape,r))throw new a(`State ${n} is incompatible with layer ${this.name}: expected shape=${r}, received shape=${s.shape}`);this.states_[n]=s}}this.states_=this.states_.map((t=>s.keep(t.clone())))}))}computeSingleOutputShape(t){const{dataFormat:e,filters:n,kernelSize:s,padding:r,strides:i,dilationRate:a}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],h=Tc(l,s[0],r,i[0],a[0]),c=Tc(u,s[1],r,i[1],a[1]);return[...t.slice(0,2),...o?[n,h,c]:[h,c,n]]}}op.className="ConvRNN2D";class lp extends np{constructor(t){const{filters:e,kernelSize:n,strides:s,padding:r,dataFormat:i,dilationRate:a}=t;super(Object.assign({},t,{units:e})),this.filters=e,I(this.filters,"filters"),this.kernelSize=Cc(n,2,"kernelSize"),this.kernelSize.forEach((t=>I(t,"kernelSize"))),this.strides=Cc(s||1,2,"strides"),this.strides.forEach((t=>I(t,"strides"))),this.padding=r||"valid",P(this.padding),this.dataFormat=i||"channelsLast",B(this.dataFormat),this.dilationRate=Cc(a||1,2,"dilationRate"),this.dilationRate.forEach((t=>I(t,"dilationRate")))}build(t){var e;t=Wt(t);const n="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[n])throw new a(`The channel dimension of the input should be defined. Found ${t[n]}`);const r=t[n],i=this.kernelSize.concat([r,4*this.filters]);this.kernel=this.addWeight("kernel",i,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const o=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",o,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let t;if(this.unitForgetBias){const n=this.biasInitializer,r=this.filters;t=new((e=class extends yt{apply(t,e){return it([n.apply([r]),s.ones([r]),n.apply([2*r])])}}).className="CustomInit",e)}else t=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,t,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(t,e){return s.tidy((()=>{if(3!==t.length)throw new a(`ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got ${t.length}.`);const n=e.training||!1,r=t[0],i=t[1],o=t[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=ip({ones:()=>s.onesLike(r),rate:this.dropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const l=this.dropoutMask,u=(t,e,n)=>e&&e[n]?s.mul(e[n],t):t;let h=u(r,l,0),c=u(r,l,1),p=u(r,l,2),d=u(r,l,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=ip({ones:()=>s.onesLike(i),rate:this.recurrentDropout,training:n,count:4,dropoutFunc:this.dropoutFunc}));const f=this.recurrentDropoutMask;let g=u(i,f,0),m=u(i,f,1),b=u(i,f,2),y=u(i,f,3);const[w,k,v,x]=s.split(this.kernel.read(),4,3),[S,N,E,I]=this.useBias?s.split(this.bias.read(),4):[null,null,null,null];h=this.inputConv(h,w,S,this.padding),c=this.inputConv(c,k,N,this.padding),p=this.inputConv(p,v,E,this.padding),d=this.inputConv(d,x,I,this.padding);const[A,$,z,C]=s.split(this.recurrentKernel.read(),4,3);g=this.recurrentConv(g,A),m=this.recurrentConv(m,$),b=this.recurrentConv(b,z),y=this.recurrentConv(y,C);const T=this.recurrentActivation.apply(s.add(h,g)),_=this.recurrentActivation.apply(s.add(c,m)),D=s.add(s.mul(_,o),s.mul(T,this.activation.apply(s.add(p,b)))),F=s.mul(this.recurrentActivation.apply(s.add(d,y)),this.activation.apply(D));return[F,F,D]}))}getConfig(){const t=super.getConfig(),e=ap(t,["units"]),n={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},e,n)}inputConv(t,e,n,r){const i=s.conv2d(t,e,this.strides,r||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return n?dt(i,n,this.dataFormat):i}recurrentConv(t,e){return s.conv2d(t,e,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}lp.className="ConvLSTM2DCell",s.serialization.registerClass(lp);class up extends op{constructor(t){const e=new lp(t);super(Object.assign({},t,{cell:e}))}static fromConfig(t,e){return new t(e)}}up.className="ConvLSTM2D",s.serialization.registerClass(up);class hp extends Xt{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,n=[];for(let t=0;t<this.noiseShape.length;++t)n.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return n}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Pt(t);if(0<this.rate&&this.rate<1){const t=null!=n.training&&n.training,s=this.getNoiseShape(e);return gt((()=>ft(e,this.rate,s,this.seed)),(()=>e),t)}return t}))}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}hp.className="Dropout",e.serialization.registerClass(hp);class cp extends hp{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}cp.className="SpatialDropout1D",e.serialization.registerClass(cp);class pp extends Xt{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,I(this.units,"units"),this.activation=mc(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=Rt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Rt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=Mu(t.kernelConstraint),this.biasConstraint=Mu(t.biasConstraint),this.kernelRegularizer=Sc(t.kernelRegularizer),this.biasRegularizer=Sc(t.biasRegularizer),this.activityRegularizer=Sc(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=Wt(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=Wt(t)).slice();return e[e.length-1]=this.units,e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Pt(t),s=$(this.activation.getClassName());let r;return null!=s?r=ut(e,this.kernel.read(),s,this.bias?this.bias.read():null):(r=ut(e,this.kernel.read()),null!=this.bias&&(r=dt(r,this.bias.read())),null!=this.activation&&(r=this.activation.apply(r))),r}))}getConfig(){const t={units:this.units,activation:fc(this.activation),useBias:this.useBias,kernelInitializer:Lt(this.kernelInitializer),biasInitializer:Lt(this.biasInitializer),kernelRegularizer:vc(this.kernelRegularizer),biasRegularizer:vc(this.biasRegularizer),activityRegularizer:vc(this.activityRegularizer),kernelConstraint:Du(this.kernelConstraint),biasConstraint:Du(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}pp.className="Dense",e.serialization.registerClass(pp);class dp extends Xt{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=Wt(t);for(const e of t.slice(1))if(null==e)throw new a(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],H(t,1)]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);let r=Pt(t);if("channelsFirst"===this.dataFormat&&r.rank>1){const t=[0];for(let e=2;e<r.rank;++e)t.push(e);t.push(1),r=e.transpose(r,t)}return function(t){if(t.rank<=1)throw new a(`batchFlatten requires a minimum rank of 2. Got rank: ${t.rank}.`);const e=[t.shape[0],H(t.shape,1)];return s.reshape(t,e)}(r)}))}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}dp.className="Flatten",e.serialization.registerClass(dp);class fp extends Xt{constructor(t){super(t),this.supportsMasking=!0,this.activation=mc(t.activation)}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const e=Pt(t);return this.activation.apply(e)}))}getConfig(){const t={activation:fc(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}fp.className="Activation",e.serialization.registerClass(fp);class gp extends Xt{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,n){return e.tidy((()=>{return t=Pt(t),n=t,s=this.n,e.tidy((()=>{if(2!==n.shape.length)throw new a(`repeat() expects a rank-2 tensor, but received a rank-${n.shape.length} tensor.`);return ot(et(n,1),[1,s,1])}));var n,s}))}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}gp.className="RepeatVector",e.serialization.registerClass(gp);class mp extends Xt{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const n="Total size of new array must be unchanged.",s=e.slice();let r=1,i=null;for(let t=0;t<s.length;++t){const e=s[t];if(this.isUnknown(e)){if(null!==i)throw new a("Can only specifiy one unknown dimension.");i=t}else r*=e}const o=H(t);if(null!==i){if(0===r||o%r!=0)throw new a(n);s[i]=o/r}else if(o!==r)throw new a(n);return s}computeOutputShape(t){let e=!1;for(let n=0;n<t.length;++n)if(this.isUnknown(t[n])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Pt(t),r=s.shape,i=r.slice(0,1).concat(this.fixUnknownDimension(r.slice(1),this.targetShape));return e.reshape(s,i)}))}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}mp.className="Reshape",e.serialization.registerClass(mp);class bp extends Xt{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error(`Permute constructor requires \`dims\` to be an Array, but received ${t.dims} instead.`);const n=Y(1,t.dims.length+1);if(!e.util.arraysEqual(t.dims.slice().sort(),n))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new Gt({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=Wt(t)).slice();return this.dims.forEach(((n,s)=>{e[s+1]=t[n]})),e}call(t,n){return e.transpose(Pt(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}bp.className="Permute",e.serialization.registerClass(bp);class yp extends Xt{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,n){const s=Pt(t);return e.any(e.notEqual(s,this.maskValue),-1)}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Pt(t),r=e.any(e.notEqual(s,this.maskValue),-1,!0);return e.mul(s,e.cast(r,s.dtype))}))}}yp.className="Masking",e.serialization.registerClass(yp);class wp extends Xt{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(f(t.inputLength))}this.inputDim=t.inputDim,I(this.inputDim,"inputDim"),this.outputDim=t.outputDim,I(this.outputDim,"outputDim"),this.embeddingsInitializer=Rt(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Sc(t.embeddingsRegularizer),this.activityRegularizer=Sc(t.activityRegularizer),this.embeddingsConstraint=Mu(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,n){return e.tidy((()=>this.maskZero?(t=Pt(t),e.notEqual(t,e.zerosLike(t))):null))}computeOutputShape(t){if(t=Wt(t),null==this.inputLength)return[...t,this.outputDim];const e=f(this.inputLength);if(e.length!==t.length-1)throw new a(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);{let n=0;for(let s=0;s<e.length;++s){const r=e[s],i=t[s+1];if(null!=r&&null!=i&&r!==i)throw new a(`"inputLength" is ${this.inputLength}, but received input shape has shape ${t}`);null==r&&(e[n]=i),n++}}return[t[0],...e,this.outputDim]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);let s=Pt(t);"int32"!==s.dtype&&(s=tt(s,"int32"));const r=ht(this.embeddings.read(),e.reshape(s,[s.size]));return e.reshape(r,Wt(this.computeOutputShape(s.shape)))}))}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Lt(this.embeddingsInitializer),embeddingsRegularizer:vc(this.embeddingsRegularizer),activityRegularizer:vc(this.activityRegularizer),embeddingsConstraint:Du(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}wp.className="Embedding",e.serialization.registerClass(wp);class kp extends Xt{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new o}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const n=t.slice(0,t.length-e.length);for(let s=0;s<e.length;++s){const r=t[t.length-e.length+s],i=e[s];if(null==r||null==i||r<0||i<0)n.push(null);else if(1===r)n.push(i);else if(1===i)n.push(r);else{if(r!==i)throw new a("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));n.push(r)}}return n}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[Wt(t)]),t.length<2)throw new a(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const n of t)null!=n&&null!==n[0]&&e.push(n[0]);if(e=x(e),e.length>1)throw new a(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let n=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const s=null==t[e]?null:t[e].slice(1);n=this.computeElementwiseOpOutputShape(n,s)}const s=t.map((t=>t.length));-1===t.indexOf(null)&&1===x(s).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(t,n){return e.tidy((()=>{if(this.reshapeRequired){const e=[],n=t.map((t=>t.rank));if(-1===n.indexOf(null)){const s=Z(n);for(let n of t){const t=n.rank;for(let e=0;e<s-t;++e)n=et(n,1);e.push(n)}return this.mergeFunction(e)}{let n=!1;for(const r of t){const t=r.rank;if(null==t){const t=r.shape,i=t[0],a=t.slice(1).concat([i]);let o=s.reshape(r,[i].concat(H(t.slice(1))));o=s.transpose(o,[1,0]),o=s.reshape(o,a),e.push(o),n=!0}else if(t>1){const i=Y(1,t).concat([0]);e.push(s.transpose(r,i)),n=!0}else e.push(r)}let r=this.mergeFunction(e);const i=r.rank;if(n)if(null==i){const t=r.shape,e=t[t.length-1],n=[e].concat(t.slice(0,t.length-1));r=s.reshape(s.transpose(s.reshape(r,[-1,e]),[1,0]),n)}else if(i>1){const t=[i-1].concat(Y(0,i-1));r=s.transpose(r,t)}return r}}return this.mergeFunction(t)}))}computeOutputShape(t){let e;e=null==t[0]?null:t[0].slice(1);for(let n=1;n<t.length;++n){const s=null==t[n]?null:t[n].slice(1);e=this.computeElementwiseOpOutputShape(e,s)}let n=[];for(const e of t)null!=e&&null!==e[0]&&n.push(e[0]);return n=x(n),e=1===n.length?n.concat(e):[null].concat(e),e}computeMask(t,e){return s.tidy((()=>{if(null==e)return null;if(!Array.isArray(e))throw new a("`mask` should be an Array");if(!Array.isArray(t))throw new a("`inputs` should be an Array");if(e.length!==t.length)throw new a(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${t.length} vs ${e.length})`);if(e.every((t=>null==t)))return null;let n=(e=e.map((t=>null==t?t:s.expandDims(t,0))))[0];for(let t=1;t<e.length-1;++t)n=s.logicalAnd(n,e[t]);return n}))}}class vp extends kp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=s.add(e,t[n]);return e}))}}vp.className="Add",e.serialization.registerClass(vp);class xp extends kp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=s.mul(e,t[n]);return e}))}}xp.className="Multiply",e.serialization.registerClass(xp);class Sp extends kp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0].clone();for(let n=1;n<t.length;++n)e=s.add(e,t[n]);return s.mul(1/t.length,e)}))}}Sp.className="Average",e.serialization.registerClass(Sp);class Np extends kp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0];for(let n=1;n<t.length;++n)e=s.maximum(e,t[n]);return e}))}}Np.className="Maximum",e.serialization.registerClass(Np);class Ep extends kp{constructor(t){super(t)}mergeFunction(t){return e.tidy((()=>{let e=t[0];for(let n=1;n<t.length;++n)e=s.minimum(e,t[n]);return e}))}}Ep.className="Minimum",e.serialization.registerClass(Ep);class Ip extends kp{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new a("A `Concatenate` layer should be called on a list of at least 2 inputs");let n=!0;for(const e of t)if(null!=e){n=!1;break}if(n)return;const s=[];for(let n=0;n<t.length;++n){const r=t[n].slice();r.splice(this.axis,1);let i=!1;for(const t of s)if(e.util.arraysEqual(t,r)){i=!0;break}i||s.push(r)}if(s.length>1)throw new a("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return e.tidy((()=>it(t,this.axis)))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new a("A `Concatenate` layer should be called on a list of inputs.");const e=t,n=e[0].slice(),s=this.axis<0?n.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==n[s]||null==t[s]){n[s]=null;break}n[s]+=t[s]}return n}computeMask(t,e){if(null==e)return null;if(!Array.isArray(e))throw new a("`mask` should be an array for Concatenate");if(!Array.isArray(t))throw new a("`inputs` should be an array for Concatenate");if(e.length!==t.length)throw new a(`Mismatch in the length of mask (${e.length}) and the legnth of inputs (${t.length})`);return s.tidy((()=>{let n=!0;if(e.forEach((t=>{null==t||(n=!1)})),n)return null;const r=[];for(let n=0;n<t.length;++n)null==e[n]?r.push(s.cast(s.onesLike(t[n]),"bool")):e[n].rank<t[n].rank?r.push(s.expandDims(e[n],-1)):r.push(e[n]);const i=s.concat(r,this.axis);return s.all(i,-1,!1)}))}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Ap(t,e){for(;t<0;)t+=e;return t}Ip.className="Concatenate",e.serialization.registerClass(Ip);class $p extends kp{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){s.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const e=t[0],n=t[1];if(e.length>3||n.length>3)throw new o("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(e,n);if(e[r[0]]!==n[r[1]])throw new a(`Dimension incompatibility: ${e[r[0]]} !== ${n[r[1]]}`)}mergeFunction(t){if(2!==t.length)throw new a(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${t.length} input(s).`);let e,n=t[0],r=t[1];return e=Array.isArray(this.axes)?this.axes.map(((e,n)=>Ap(e,t[n].shape.length))):[Ap(this.axes,n.shape.length),Ap(this.axes,r.shape.length)],this.normalize&&(n=Zu(n,e[0]),r=Zu(r,e[1])),function(t,e,n){if(t.shape.length>3||e.shape.length>3)throw new o("batchDot is not implemented for tensors of 4D or higher rank yet");if(s.util.assert(t.shape.length>=2,(()=>`batchDot requires the rank of x to be >= 2, but got ${t.shape.length}`)),s.util.assert(t.shape.length>=2,(()=>`batchDot requires the rank of y to be >= 2, but got ${e.shape.length}`)),"number"==typeof n&&(n=[n,n]),"complex64"===t.dtype||"complex64"===e.dtype)throw new o("batchDot is not implemented for complex64-type Tensors yet.");const r=t.shape.length,i=e.shape.length;null==n&&(n=[r-1,i-2]);const a=n;return s.tidy((()=>{let n,o;if(r>i){n=r-i;const t=[];for(let e=0;e<n;++e)t.push(1);e=s.reshape(e,e.shape.concat(t))}else if(i>r){n=i-r;const e=[];for(let t=0;t<n;++t)e.push(1);t=s.reshape(t,t.shape.concat(e))}else n=0;if(2===t.shape.length&&2===e.shape.length)o=a[0]===a[1]?s.sum(s.mul(t,e),a[0]):s.sum(s.mul(s.transpose(t,[1,0]),e),a[1]);else{const n=a[0]!==t.shape.length-1,r=a[1]===e.shape.length-1;o=s.matMul(t,e,n,r)}if(n>0){let t;t=r>i?r+i-3:r-1;const e=[];for(let s=t;s<t+n;++s)e.push(s);o=s.squeeze(o,e)}return 1===o.shape.length&&(o=s.expandDims(o,1)),o}))}(n,r,e)}interpretAxes(t,e){let n;return n=Array.isArray(this.axes)?this.axes:[Ap(this.axes,t.length),Ap(this.axes,e.length)],n}computeOutputShape(t){s.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),(()=>"A `Dot` layer should be called on a list of exactly 2 inputs."));const e=t[0].slice(),n=t[1].slice();if(e.length>3||n.length>3)throw new o("Dot layer does not support tensors of 4D or higher rank yet.");const r=this.interpretAxes(e,n);e.splice(r[0],1),n.splice(r[1],1),n.splice(0,1);const i=e.concat(n);return 1===i.length&&i.push(1),i}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}$p.className="Dot",e.serialization.registerClass($p);class zp extends Xt{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Pt(t);return gt((()=>e.add(lt(s.shape,0,this.stddev),s)),(()=>s),n.training||!1)}))}}zp.className="GaussianNoise",e.serialization.registerClass(zp);class Cp extends Xt{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n);const s=Pt(t);if(this.rate>0&&this.rate<1){return gt((()=>{const t=Math.sqrt(this.rate/(1-this.rate));return e.mul(s,lt(s.shape,1,t))}),(()=>s),n.training||!1)}return s}))}}Cp.className="GaussianDropout",e.serialization.registerClass(Cp);class Tp extends Xt{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||Pt(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,n){return e.tidy((()=>{if(this.rate<1&&this.rate>0){const s=this._getNoiseShape(t),r=()=>{const n=Pt(t),r=-1.7580993408473766;let i=e.greaterEqual(e.randomUniform(s),this.rate);i=tt(i,"float32");const a=((1-this.rate)*(1+this.rate*r**2))**-.5,o=-a*r*this.rate,l=e.add(e.mul(n,i),e.mul(e.add(i,-1),r));return e.add(e.mul(l,a),o)};return gt(r,(()=>Pt(t)),n.training||!1)}return t}))}}function _p(t,e,n,r,i,a=.001){let l;if(2===t.rank)l=s.batchNorm2d(t,e,n,r,i,a);else if(3===t.rank)l=s.batchNorm3d(t,e,n,r,i,a);else{if(4!==t.rank)throw new o(`batchNormalization is not implemented for array of rank ${t.rank} yet`);l=s.batchNorm4d(t,e,n,r,i,a)}return l}function Dp(t,n,r,i,a=.001){return e.util.arraysEqual(i.slice().sort(),Y(0,t.rank-1))?function(t,n,r,i,a=.001){return e.tidy((()=>{const e=s.moments(t,i),o=e.mean,l=e.variance;return[_p(t,o,l,r,n,a),o,l]}))}(t,n,r,i,a):function(t,n,r,i,a=.001){return e.tidy((()=>{const o=s.moments(t,i),l=o.mean,u=o.variance,h=[];for(const e of Y(0,t.rank))-1!==i.indexOf(e)?h.push(1):h.push(t.shape[e]);const c=e.reshape(l,h),p=e.reshape(u,h),d=null==n?null:e.reshape(n,h),f=null==r?null:e.reshape(r,h);return[_p(t,c,p,f,d,a),l,u]}))}(t,n,r,i,a)}Tp.className="AlphaDropout",e.serialization.registerClass(Tp);class Fp extends Xt{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Rt(t.betaInitializer||"zeros"),this.gammaInitializer=Rt(t.gammaInitializer||"ones"),this.movingMeanInitializer=Rt(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Rt(t.movingVarianceInitializer||"ones"),this.betaConstraint=Mu(t.betaConstraint),this.gammaConstraint=Mu(t.gammaConstraint),this.betaRegularizer=Sc(t.betaRegularizer),this.gammaRegularizer=Sc(t.gammaRegularizer)}build(t){t=Wt(t);const e=this.axis>=0?this.axis:this.axis+t.length,n=t[e];if(null==n)throw new a(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape ${JSON.stringify(t)}.`);this.inputSpec=[new Gt({ndim:t.length,axes:{[e]:n}})];const s=[n];this.scale&&(this.gamma=this.addWeight("gamma",s,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",s,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",s,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",s,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(t,n){return e.tidy((()=>{const r=null!=n.training&&n.training,i=Pt(t),a=i.shape,o=a.length,l=Y(0,o),u=this.axis>=0?this.axis:this.axis+o;l.splice(u,1);const c=h(1,o);c[u]=a[u];const p=l.slice();p.sort();const d=!e.util.arraysEqual(p,Y(0,o).slice(0,o-1));if(!r)return(()=>{if(d){const t=e.reshape(this.movingMean.read(),c),n=e.reshape(this.movingVariance.read(),c),s=this.center?e.reshape(this.beta.read(),c):null,r=this.scale?e.reshape(this.gamma.read(),c):null;return _p(i,t,n,s,r,this.epsilon)}return _p(i,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[f,g,m]=Dp(i,this.gamma.read(),this.beta.read(),l,this.epsilon),b=(t,e,n)=>{s.tidy((()=>{const r=1-n,i=t.read(),a=s.mul(s.sub(i,e),r);t.write(s.sub(i,a))}))};return(()=>{b(this.movingMean,g,this.momentum),b(this.movingVariance,m,this.momentum)})(),f}))}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Lt(this.betaInitializer),gammaInitializer:Lt(this.gammaInitializer),movingMeanInitializer:Lt(this.movingMeanInitializer),movingVarianceInitializer:Lt(this.movingVarianceInitializer),betaRegularizer:vc(this.betaRegularizer),gammaRegularizer:vc(this.gammaRegularizer),betaConstraint:Du(this.betaConstraint),gammaConstraint:Du(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}Fp.className="BatchNormalization",e.serialization.registerClass(Fp);class Mp extends Xt{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error(`Expected axis to be an integer, but received ${this.axis}`)}else{if(!Array.isArray(this.axis))throw new Error(`Expected axis to be an integer or an array of integers, but received ${JSON.stringify(this.axis)}`);for(const t of this.axis)if(!Number.isInteger(t))throw new Error(`Expected axis to be an array of integers, but received ${JSON.stringify(this.axis)}`)}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Rt(t.betaInitializer||"zeros"),this.gammaInitializer=Rt(t.gammaInitializer||"ones"),this.betaRegularizer=Sc(t.betaRegularizer),this.gammaRegularizer=Sc(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=Wt(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error(`Invalid axis: ${t}`);if(this.axis.length!==x(this.axis).length)throw new Error(`Found duplicate axes in: ${this.axis}`);const n=this.axis.map((e=>t[e]));this.scale?this.gamma=this.addWeight("gamma",n,"float32",this.gammaInitializer,this.gammaRegularizer,true):this.gamma=null,this.center?this.beta=this.addWeight("beta",n,"float32",this.betaInitializer,this.betaRegularizer,true):this.beta=null,this.built=!0}call(t,n){const r=Pt(t),i=r.shape,a=i.length;return e.tidy((()=>{let{mean:t,variance:n}=e.moments(r,this.axis,!0);const o=h(1,a);for(const t of this.axis)o[t]=i[t];const l=t=>null!=t&&t.shape.length!==a?s.reshape(t,o):t;let u=this.scale?l(this.gamma.read()):null,c=this.center?l(this.beta.read()):null;const p=[],d=[];for(let t=0;t<a;++t)-1!==this.axis.indexOf(t)?(p.push(i[t]),d.push(1)):(p.push(1),d.push(i[t]));return t=s.tile(t,p),n=s.tile(n,p),null!=u&&(u=s.tile(u,d)),null!=c&&(c=s.tile(c,d)),_p(r,t,n,c,u,this.epsilon)}))}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Lt(this.betaInitializer),gammaInitializer:Lt(this.gammaInitializer),betaRegularizer:vc(this.betaRegularizer),gammaRegularizer:vc(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}Mp.className="LayerNormalization",e.serialization.registerClass(Mp);class Lp extends Xt{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new a(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,n;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],n=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new a(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new a(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);n=t.padding[1]}this.padding=[e,n]}this.inputSpec=[new Gt({ndim:4})]}computeOutputShape(t){let e,n;return t=Wt(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,n]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,n=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,n,t[3]])}call(t,n){return e.tidy((()=>{return n=Pt(t),r=this.padding,i=this.dataFormat,e.tidy((()=>{if(4!==n.rank)throw new a(`temporalPadding expects input tensor to be 4-D, but received a ${n.rank}-D tensor.`);if(null==r&&(r=[[1,1],[1,1]]),2!==r.length||2!==r[0].length||2!==r[1].length)throw new a("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==i&&(i="channelsLast"),"channelsLast"!==i&&"channelsFirst"!==i)throw new a(`Unknown data format: ${i}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let t;return t="channelsFirst"===i?[[0,0],[0,0],r[0],r[1]]:[[0,0],r[0],r[1],[0,0]],s.pad(n,t)}));var n,r,i}))}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function Rp(t,n,r,i,a,o){return e.tidy((()=>{let e;B(a),W(o),P(i),null==r&&(r=[1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),t=Dc(t,a);const l="same"===i?"same":"valid";return e="max"===o?s.maxPool(t,n,r,l):s.avgPool(t,n,r,l),"channelsFirst"===a&&(e=s.transpose(e,[0,3,1,2])),e}))}function Op(t,n,r,i,a,o){return e.tidy((()=>{let e;B(a),W(o),P(i),null==r&&(r=[1,1,1]),null==i&&(i="valid"),null==a&&(a="channelsLast"),null==o&&(o="max"),t=Fc(t,a);const l="same"===i?"same":"valid";return e="max"===o?s.maxPool3d(t,n,r,l):s.avgPool3d(t,n,r,l),"channelsFirst"===a&&(e=s.transpose(e,[0,4,1,2,3])),e}))}Lp.className="ZeroPadding2D",e.serialization.registerClass(Lp);class Bp extends Xt{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new a(`poolSize for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.poolSize)}`);this.poolSize=t.poolSize}if(I(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new a(`strides for 1D convolutional layer must be a number or an Array of a single number, but received ${JSON.stringify(t.strides)}`);this.strides=t.strides}I(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,P(this.padding),this.inputSpec=[new Gt({ndim:3})]}computeOutputShape(t){const e=Tc((t=Wt(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(t,n){return e.tidy((()=>{this.invokeCallHook(t,n),t=et(Pt(t),2);const e=this.poolingFunction(Pt(t),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return s.squeeze(e,[2])}))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class Pp extends Bp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Rp(t,e,n,s,r,"max")}}Pp.className="MaxPooling1D",e.serialization.registerClass(Pp);class Wp extends Bp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Rp(t,e,n,s,r,"avg")}}Wp.className="AveragePooling1D",e.serialization.registerClass(Wp);class Up extends Xt{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new a(`If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides];I(this.poolSize,"poolSize"),I(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,B(this.dataFormat),P(this.padding),this.inputSpec=[new Gt({ndim:4})]}computeOutputShape(t){t=Wt(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2];return e=Tc(e,this.poolSize[0],this.padding,this.strides[0]),n=Tc(n,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n]:[t[0],e,n,t[3]]}call(t,n){return e.tidy((()=>(this.invokeCallHook(t,n),this.poolingFunction(Pt(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Kp extends Up{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Rp(t,e,n,s,r,"max")}}Kp.className="MaxPooling2D",e.serialization.registerClass(Kp);class Vp extends Up{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Rp(t,e,n,s,r,"avg")}}Vp.className="AveragePooling2D",e.serialization.registerClass(Vp);class qp extends Xt{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new a(`If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length ${t.strides.length}.`);this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];I(this.poolSize,"poolSize"),I(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,B(this.dataFormat),P(this.padding),this.inputSpec=[new Gt({ndim:5})]}computeOutputShape(t){t=Wt(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],n="channelsFirst"===this.dataFormat?t[3]:t[2],s="channelsFirst"===this.dataFormat?t[4]:t[3];return e=Tc(e,this.poolSize[0],this.padding,this.strides[0]),n=Tc(n,this.poolSize[1],this.padding,this.strides[1]),s=Tc(s,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,n,s]:[t[0],e,n,s,t[4]]}call(t,n){return e.tidy((()=>(this.invokeCallHook(t,n),this.poolingFunction(Pt(t),this.poolSize,this.strides,this.padding,this.dataFormat))))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class jp extends qp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Op(t,e,n,s,r,"max")}}jp.className="MaxPooling3D",e.serialization.registerClass(jp);class Gp extends qp{constructor(t){super(t)}poolingFunction(t,e,n,s,r){return B(r),P(s),Op(t,e,n,s,r,"avg")}}Gp.className="AveragePooling3D",e.serialization.registerClass(Gp);class Hp extends Xt{constructor(t){super(t),this.inputSpec=[new Gt({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new o}}class Jp extends Hp{constructor(t){super(t||{})}call(t,n){return e.tidy((()=>{const e=Pt(t);return s.mean(e,1)}))}}Jp.className="GlobalAveragePooling1D",e.serialization.registerClass(Jp);class Zp extends Hp{constructor(t){super(t||{})}call(t,n){return e.tidy((()=>{const e=Pt(t);return s.max(e,1)}))}}Zp.className="GlobalMaxPooling1D",e.serialization.registerClass(Zp);class Yp extends Xt{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,B(this.dataFormat),this.inputSpec=[new Gt({ndim:4})]}computeOutputShape(t){return"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new o}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class Xp extends Yp{call(t,n){return e.tidy((()=>{const e=Pt(t);return"channelsLast"===this.dataFormat?s.mean(e,[1,2]):s.mean(e,[2,3])}))}}Xp.className="GlobalAveragePooling2D",e.serialization.registerClass(Xp);class Qp extends Yp{call(t,n){return e.tidy((()=>{const e=Pt(t);return"channelsLast"===this.dataFormat?s.max(e,[1,2]):s.max(e,[2,3])}))}}Qp.className="GlobalMaxPooling2D",e.serialization.registerClass(Qp);class td extends Xt{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,n={}){const s=Ju(e.layer,n);delete e.layer;const r={layer:s};return Object.assign(r,e),new t(r)}}class ed extends td{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=Wt(t)).length<3)throw new a(`TimeDistributed layer expects an input shape >= 3D, but received input shape ${JSON.stringify(t)}`);this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=Wt(t))[0]].concat(t.slice(2)),n=this.layer.computeOutputShape(e),s=t[1];return[n[0],s].concat(n.slice(1))}call(t,n){return e.tidy((()=>Jc(((t,e)=>[Pt(this.layer.call(t,n)),[]]),t=Pt(t),[],!1,null,null,!1,!0)[1]))}}ed.className="TimeDistributed",e.serialization.registerClass(ed);class nd extends td{constructor(t){super(t);const e=t.layer.getConfig(),n={};n.className=t.layer.getClassName(),n.config=e,this.forwardLayer=Ju(n),e.goBackwards=!0!==e.goBackwards;const s={};var r;if(s.className=t.layer.getClassName(),s.config=e,this.backwardLayer=Ju(s),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,r=this.mergeMode,N(R,"BidirectionalMergeMode",r),t.weights)throw new o("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,n=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,n)),this.backwardLayer.setWeights(t.slice(n))}computeOutputShape(t){let e,n,s,r=this.forwardLayer.computeOutputShape(t);return Array.isArray(r)&&Array.isArray(r[0])||(r=[r]),this.returnState?(s=r.slice(1),e=r[0]):e=r[0],"concat"===this.mergeMode?(e[e.length-1]*=2,n=[e]):n=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?n.concat(s).concat(s.slice()):[e].concat(s).concat(s.slice()):d(n)}apply(t,e){let n=null==e?null:e.initialState,s=null==e?null:e.constants;null==e&&(e={});const r=Hc(t,n,s,this.numConstants);if(t=r.inputs,n=r.initialState,s=r.constants,Array.isArray(t)&&(n=t.slice(1),t=t[0]),(null==n||0===n.length)&&null==s)return super.apply(t,e);const i=[],l=[];if(null!=n){const t=n.length;if(t%2>0)throw new a("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=n,i.push(...n);const s=n.map((t=>new Gt({shape:t.shape})));this.forwardLayer.stateSpec=s.slice(0,t/2),this.backwardLayer.stateSpec=s.slice(t/2),l.push(...s)}if(null!=s)throw new o("Support for constants in Bidirectional layers is not implemented yet.");const u=i[0]instanceof Ht;for(const t of i)if(t instanceof Ht!==u)throw new a("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(u){const n=[t].concat(i),s=this.inputSpec.concat(l),r=this.inputSpec;this.inputSpec=s;const a=super.apply(n,e);return this.inputSpec=r,a}return super.apply(t,e)}call(t,n){return e.tidy((()=>{const e=n.initialState;let r,i,a,o;if(null==e)r=this.forwardLayer.call(t,n),i=this.backwardLayer.call(t,n);else{const s=e.slice(0,e.length/2),a=e.slice(e.length/2);r=this.forwardLayer.call(t,Object.assign(n,{initialState:s})),i=this.backwardLayer.call(t,Object.assign(n,{initialState:a}))}return this.returnState&&(Array.isArray(r)&&(a=r.slice(1).concat(i.slice(1))),r=r[0],i=i[0]),this.returnSequences&&(i=s.reverse(i,1)),"concat"===this.mergeMode?o=it([r,i]):"sum"===this.mergeMode?o=s.add(r,i):"ave"===this.mergeMode?o=s.mul(.5,s.add(r,i)):"mul"===this.mergeMode?o=s.mul(r,i):null==this.mergeMode&&(o=[r,i]),this.returnState?null==this.mergeMode?o.concat(a):[o].concat(a):o}))}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){K(this.forwardLayer.name,(()=>{this.forwardLayer.build(t)})),K(this.backwardLayer.name,(()=>{this.backwardLayer.build(t)})),this.built=!0}computeMask(t,e){let n;if(Array.isArray(e)&&(e=e[0]),n=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map((t=>null));return Array.isArray(n)?n.concat(t).concat(t):[n].concat(t).concat(t)}return n}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const n=Ju(e.layer);if(delete e.layer,null!=e.numConstants)throw new o("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const s=e;return s.layer=n,new t(s)}}function sd(t){return new Wp(t)}function rd(t){return new Vp(t)}function id(t){return new Gp(t)}function ad(t){return new Zp(t)}function od(t){return new Qp(t)}function ld(t){return new Pp(t)}function ud(t){return new Kp(t)}nd.className="Bidirectional",e.serialization.registerClass(nd);var hd={__proto__:null,inputLayer:function(t){return new te(t)},elu:function(t){return new Ac(t)},reLU:function(t){return new Nc(t)},leakyReLU:function(t){return new Ec(t)},prelu:function(t){return new Ic(t)},softmax:function(t){return new zc(t)},thresholdedReLU:function(t){return new $c(t)},conv1d:function(t){return new Vc(t)},conv2d:function(t){return new Oc(t)},conv2dTranspose:function(t){return new Pc(t)},conv3d:function(t){return new Bc(t)},conv3dTranspose:function(t){return new Wc(t)},separableConv2d:function(t){return new Kc(t)},cropping2D:function(t){return new qc(t)},upSampling2d:function(t){return new jc(t)},depthwiseConv2d:function(t){return new Gc(t)},activation:function(t){return new fp(t)},dense:function(t){return new pp(t)},dropout:function(t){return new hp(t)},spatialDropout1d:function(t){return new cp(t)},flatten:function(t){return new dp(t)},repeatVector:function(t){return new gp(t)},reshape:function(t){return new mp(t)},permute:function(t){return new bp(t)},embedding:function(t){return new wp(t)},add:function(t){return new vp(t)},average:function(t){return new Sp(t)},concatenate:function(t){return new Ip(t)},maximum:function(t){return new Np(t)},minimum:function(t){return new Ep(t)},multiply:function(t){return new xp(t)},dot:function(t){return new $p(t)},batchNormalization:function(t){return new Fp(t)},layerNormalization:function(t){return new Mp(t)},zeroPadding2d:function(t){return new Lp(t)},averagePooling1d:sd,avgPool1d:function(t){return sd(t)},avgPooling1d:function(t){return sd(t)},averagePooling2d:rd,avgPool2d:function(t){return rd(t)},avgPooling2d:function(t){return rd(t)},averagePooling3d:id,avgPool3d:function(t){return id(t)},avgPooling3d:function(t){return id(t)},globalAveragePooling1d:function(t){return new Jp(t)},globalAveragePooling2d:function(t){return new Xp(t)},globalMaxPooling1d:ad,globalMaxPooling2d:od,maxPooling1d:ld,maxPooling2d:ud,maxPooling3d:function(t){return new jp(t)},gru:function(t){return new ep(t)},gruCell:function(t){return new tp(t)},lstm:function(t){return new sp(t)},lstmCell:function(t){return new np(t)},simpleRNN:function(t){return new Qc(t)},simpleRNNCell:function(t){return new Xc(t)},convLstm2d:function(t){return new up(t)},convLstm2dCell:function(t){return new lp(t)},rnn:function(t){return new Zc(t)},stackedRNNCells:function(t){return new rp(t)},bidirectional:function(t){return new nd(t)},timeDistributed:function(t){return new ed(t)},globalMaxPool1d:ad,globalMaxPool2d:od,maxPool1d:ld,maxPool2d:ud,Layer:Xt,RNN:Zc,RNNCell:Yc,input:Xh,gaussianNoise:function(t){return new zp(t)},gaussianDropout:function(t){return new Cp(t)},alphaDropout:function(t){return new Tp(t)},masking:function(t){return new yp(t)}};var cd={__proto__:null,binaryAccuracy:function(t,e){return ah(t,e)},binaryCrossentropy:function(t,e){return ch(t,e)},sparseCategoricalAccuracy:function(t,e){return ph(t,e)},categoricalAccuracy:function(t,e){return oh(t,e)},categoricalCrossentropy:function(t,e){return dh(t,e)},precision:function(t,e){return uh(t,e)},recall:function(t,e){return hh(t,e)},cosineProximity:function(t,e){return sh(t,e)},meanAbsoluteError:function(t,e){return Xu(t,e)},meanAbsolutePercentageError:function(t,e){return Qu(t,e)},MAPE:function(t,e){return Qu(t,e)},mape:function(t,e){return Qu(t,e)},meanSquaredError:function(t,e){return Yu(t,e)},MSE:function(t,e){return Yu(t,e)},mse:function(t,e){return Yu(t,e)}},pd={__proto__:null,modelFromJSON:async function(t,n){"modelTopology"in t||(t={modelTopology:t});let s=t.modelTopology;null!=s.model_config&&(s=s.model_config);const r=Ju(Ih(s),n);if(null!=t.weightsManifest){const n=await e.io.loadWeights(t.weightsManifest,t.pathPrefix,r.weights.map((t=>t.originalName))),s={};for(const t of r.weights)s[t.originalName]=n[t.originalName];r.loadWeights(s),e.dispose(n)}return r}};var dd={__proto__:null,l1l2:function(t){return new wc(t)},l1:function(t){return bc(e=t),new wc({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return bc(e=t),new wc({l2:null!=e?e.l2:null,l1:0});var e}};class fd extends Wu{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof Hh))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function gd(t,e){return t<e}function md(t,e){return t>e}class bd extends fd{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new o("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=gd:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=md:this.monitorFunc=gd,this.monitorFunc===gd&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===gd?1/0:-1/0}async onEpochEnd(t,e){await Bu(e);const n=this.getMonitorValue(e);null!=n&&(this.monitorFunc(n-this.minDelta,this.best)?(this.best=n,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: ${Object.keys(t)}`),e}}const yd={earlyStopping:function(t){return new bd(t)}};t.Callback=fd,t.CallbackList=Uu,t.CustomCallback=qu,t.EarlyStopping=bd,t.History=Vu,t.InputSpec=Gt,t.LayerVariable=Vt,t.LayersModel=Hh,t.RNN=Zc,t.Sequential=Yh,t.SymbolicTensor=Ht,t.callbacks=yd,t.constraints=Lu,t.initializers=Ou,t.input=Xh,t.layers=hd,t.loadLayersModel=function(t,e){return null==e&&(e={}),Zh(t,e)},t.metrics=cd,t.model=function(t){return new Hh(t)},t.models=pd,t.registerCallbackConstructor=function(t,e){Gu.registerCallbackConstructor(t,e)},t.regularizers=dd,t.sequential=function(t){return new Yh(t)},t.version_layers=$h,Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-layers.es2017.min.js.map
