/**
 * @license
 * Copyright 2018 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { upcastType } from './types';
describe('upcastType', () => {
    it('upcasts bool to bool', () => {
        expect(upcastType('bool', 'bool')).toBe('bool');
    });
    it('upcasts bool/int32 to int32', () => {
        expect(upcastType('bool', 'int32')).toBe('int32');
        expect(upcastType('int32', 'int32')).toBe('int32');
    });
    it('upcasts bool/int32/float32 to float32', () => {
        expect(upcastType('bool', 'float32')).toBe('float32');
        expect(upcastType('int32', 'float32')).toBe('float32');
        expect(upcastType('float32', 'float32')).toBe('float32');
    });
    it('upcasts bool/int32/float32/complex64 to complex64', () => {
        expect(upcastType('bool', 'complex64')).toBe('complex64');
        expect(upcastType('int32', 'complex64')).toBe('complex64');
        expect(upcastType('float32', 'complex64')).toBe('complex64');
        expect(upcastType('complex64', 'complex64')).toBe('complex64');
    });
    it('fails to upcast anything other than string with string', () => {
        expect(() => upcastType('bool', 'string')).toThrowError();
        expect(() => upcastType('int32', 'string')).toThrowError();
        expect(() => upcastType('float32', 'string')).toThrowError();
        expect(() => upcastType('complex64', 'string')).toThrowError();
        // Ok upcasting string to string.
        expect(upcastType('string', 'string')).toBe('string');
    });
});
//# sourceMappingURL=data:application/json;base64,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