/**
 * @license
 * Copyright 2018 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
// So typings can propagate.
import { AdadeltaOptimizer } from './optimizers/adadelta_optimizer';
import { AdagradOptimizer } from './optimizers/adagrad_optimizer';
import { AdamOptimizer } from './optimizers/adam_optimizer';
import { AdamaxOptimizer } from './optimizers/adamax_optimizer';
import { MomentumOptimizer } from './optimizers/momentum_optimizer';
import { OptimizerConstructors } from './optimizers/optimizer_constructors';
import { RMSPropOptimizer } from './optimizers/rmsprop_optimizer';
import { SGDOptimizer } from './optimizers/sgd_optimizer';
// tslint:disable-next-line:no-unused-expression
[MomentumOptimizer, SGDOptimizer, AdadeltaOptimizer, AdagradOptimizer,
    RMSPropOptimizer, AdamaxOptimizer, AdamOptimizer];
export const train = {
    sgd: OptimizerConstructors.sgd,
    momentum: OptimizerConstructors.momentum,
    adadelta: OptimizerConstructors.adadelta,
    adagrad: OptimizerConstructors.adagrad,
    rmsprop: OptimizerConstructors.rmsprop,
    adamax: OptimizerConstructors.adamax,
    adam: OptimizerConstructors.adam
};
//# sourceMappingURL=data:application/json;base64,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