/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
class e{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}}class t{refCount(e){return n("refCount")}incRef(e){return n("incRef")}timerAvailable(){return!0}time(e){return n("time")}read(e){return n("read")}readSync(e){return n("readSync")}readToGPU(e,t){return n("readToGPU")}numDataIds(){return n("numDataIds")}disposeData(e,t){return n("disposeData")}write(e,t,r){return n("write")}move(e,t,r,s,o){return n("move")}memory(){return n("memory")}floatPrecision(){return n("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return n("dispose")}}function n(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,o(e,t,n)}function s(e,t,n){return Math.max(e,Math.min(t,n))}function o(e,t,n){const r=e[t];e[t]=e[n],e[n]=r}function a(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function i(e,t,n=""){a(h(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function l(e){a(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function u(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||k(e)&&!n)for(let r=0;r<e.length;++r)u(e[r],t,n);else t.push(e);return t}function c(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function h(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function d(e){return e%1==0}function f(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function p(e,t){const n=t.length;return a((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),a(e.every((e=>d(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function g(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,o=null==t||s?null:p(t,e).sort();let a=0;for(let t=0;t<e.length;++t){if(null!=o){if(o[a]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==o[a]||o[a]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),o[a]<=t&&a++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}function m(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function b(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function y(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}function w(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function k(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function v(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function x(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function E(e){return"string"==typeof e||e instanceof String}function S(e){return"boolean"==typeof e}function $(e){return"number"==typeof e}function A(e){return Array.isArray(e)?A(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":$(e)?"float32":E(e)?"string":S(e)?"bool":"float32"}function _(e){return!!(e&&e.constructor&&e.call&&e.apply)}function I(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function M(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function N(e,t,n,r=!1){const s=new Array;if(1===t.length){const o=t[0]*(r?2:1);for(let t=0;t<o;t++)s[t]=n[e+t]}else{const o=t[0],a=t.slice(1),i=a.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<o;t++)s[t]=N(e+t*i,a,n,r)}return s}function T(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return N(0,e,t,n)}function D(e,t){const n=R(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function R(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function F(e){e.forEach((t=>{a(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function C(e){return e&&e.then&&"function"==typeof e.then}class B{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=P,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(O().getBool("IS_TEST")||O().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];O().getBool("IS_TEST")||O().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(C(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function P(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function O(){return z}let L,z=null;function W(){if(null==L){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}L=e}return L}function K(e,t){const n=function(){const e=W();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}const U="Abs",q="Acos",G="Acosh",H="Add",V="AddN",j="All",J="Any",Z="ArgMax",Y="ArgMin",X="Asin",Q="Asinh",ee="Atan",te="Atanh",ne="Atan2",re="AvgPool",se="AvgPoolGrad",oe="AvgPool3D",ae="AvgPool3DGrad",ie="BatchMatMul",le="BatchToSpaceND",ue="Bincount",ce="BroadcastTo",he="BroadcastArgs",de="Cast",fe="Ceil",pe="ClipByValue",ge="Complex",me="ComplexAbs",be="Concat",ye="Conv2D",we="Conv2DBackpropFilter",ke="Conv2DBackpropInput",ve="Conv3D",xe="Conv3DBackpropFilterV2",Ee="Conv3DBackpropInputV2",Se="Cos",$e="Cosh",Ae="Cumprod",_e="Cumsum",Ie="CropAndResize",Me="DenseBincount",Ne="DepthToSpace",Te="DepthwiseConv2dNative",De="DepthwiseConv2dNativeBackpropFilter",Re="DepthwiseConv2dNativeBackpropInput",Fe="Diag",Ce="Dilation2D",Be="Dilation2DBackpropInput",Pe="Dilation2DBackpropFilter",Oe="RealDiv",Le="Einsum",ze="Elu",We="EluGrad",Ke="Erf",Ue="Equal",qe="Exp",Ge="ExpandDims",He="Expm1",Ve="FFT",je="Fill",Je="FlipLeftRight",Ze="Floor",Ye="FloorDiv",Xe="FusedBatchNorm",Qe="GatherV2",et="GatherNd",tt="Greater",nt="GreaterEqual",rt="Identity",st="IFFT",ot="Imag",at="IsFinite",it="IsInf",lt="IsNan",ut="LeakyRelu",ct="Less",ht="LessEqual",dt="LinSpace",ft="Log",pt="Log1p",gt="LogicalAnd",mt="LogicalNot",bt="LogicalOr",yt="LogicalXor",wt="LogSoftmax",kt="LowerBound",vt="LRN",xt="LRNGrad",Et="Max",St="Maximum",$t="MaxPool",At="MaxPoolGrad",_t="MaxPool3D",It="MaxPool3DGrad",Mt="MaxPoolWithArgmax",Nt="Mean",Tt="Min",Dt="Minimum",Rt="MirrorPad",Ft="Mod",Ct="Multinomial",Bt="Multiply",Pt="Neg",Ot="NotEqual",Lt="NonMaxSuppressionV3",zt="NonMaxSuppressionV4",Wt="NonMaxSuppressionV5",Kt="OnesLike",Ut="OneHot",qt="Pack",Gt="PadV2",Ht="Pool",Vt="Pow",jt="Prelu",Jt="Prod",Zt="Range",Yt="Real",Xt="Reciprocal",Qt="Relu",en="Reshape",tn="ResizeNearestNeighbor",nn="ResizeNearestNeighborGrad",rn="ResizeBilinear",sn="ResizeBilinearGrad",on="Relu6",an="Reverse",ln="Round",un="Rsqrt",cn="ScatterNd",hn="SearchSorted",dn="Select",fn="Selu",pn="Slice",gn="Sin",mn="Sinh",bn="Sign",yn="Sigmoid",wn="Softplus",kn="Sqrt",vn="Sum",xn="SpaceToBatchND",En="SplitV",Sn="Softmax",$n="SparseFillEmptyRows",An="SparseReshape",_n="SparseSegmentMean",In="SparseSegmentSum",Mn="SparseToDense",Nn="SquaredDifference",Tn="Square",Dn="StridedSlice",Rn="StringNGrams",Fn="StringSplit",Cn="StringToHashBucketFast",Bn="Sub",Pn="Tan",On="Tanh",Ln="Tile",zn="TopK",Wn="Transform",Kn="Transpose",Un="Unique",qn="Unpack",Gn="UnsortedSegmentSum",Hn="UpperBound",Vn="ZerosLike",jn="Step",Jn="FromPixels",Zn="RotateWithOffset",Yn="_FusedMatMul",Xn="FusedConv2D",Qn="FusedDepthwiseConv2D";function er(...e){O().getBool("IS_TEST")||O().getBool("PROD")||console.warn(...e)}const tr=K("kernelRegistry",(()=>new Map)),nr=K("gradRegistry",(()=>new Map));function rr(e,t){const n=hr(e,t);return tr.get(n)}function sr(e){return nr.get(e)}function or(e){const t=tr.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[o,a]=s,[i]=o.split("_");i===e&&n.push(a)}return n}function ar(e){const{kernelName:t,backendName:n}=e,r=hr(t,n);tr.has(r)&&er(`The kernel '${t}' for backend '${n}' is already registered`),tr.set(r,e)}function ir(e){const{kernelName:t}=e;nr.has(t)&&O().getBool("DEBUG")&&er(`Overriding the gradient for '${t}'`),nr.set(t,e)}function lr(e,t){const n=hr(e,t);if(!tr.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);tr.delete(n)}function ur(e){if(!nr.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);nr.delete(e)}function cr(e,t){or(e).forEach((e=>{ar(Object.assign({},e,{backendName:t}))}))}function hr(e,t){return`${t}_${e}`}var dr=pr,fr=null;try{fr=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function pr(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function gr(e){return!0===(e&&e.__isLong__)}pr.prototype.__isLong__,Object.defineProperty(pr.prototype,"__isLong__",{value:!0}),pr.isLong=gr;var mr={},br={};function yr(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=br[e])?r:(n=kr(e,(0|e)<0?-1:0,!0),s&&(br[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=mr[e])?r:(n=kr(e,e<0?-1:0,!1),s&&(mr[e]=n),n)}function wr(e,t){if(isNaN(e))return t?Mr:Ir;if(t){if(e<0)return Mr;if(e>=$r)return Fr}else{if(e<=-Ar)return Cr;if(e+1>=Ar)return Rr}return e<0?wr(-e,t).neg():kr(e%Sr|0,e/Sr|0,t)}function kr(e,t,n){return new pr(e,t,n)}pr.fromInt=yr,pr.fromNumber=wr,pr.fromBits=kr;var vr=Math.pow;function xr(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Ir;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return xr(e.substring(1),t,n).neg();for(var s=wr(vr(n,8)),o=Ir,a=0;a<e.length;a+=8){var i=Math.min(8,e.length-a),l=parseInt(e.substring(a,a+i),n);if(i<8){var u=wr(vr(n,i));o=o.mul(u).add(wr(l))}else o=(o=o.mul(s)).add(wr(l))}return o.unsigned=t,o}function Er(e,t){return"number"==typeof e?wr(e,t):"string"==typeof e?xr(e,t):kr(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}pr.fromString=xr,pr.fromValue=Er;var Sr=4294967296,$r=Sr*Sr,Ar=$r/2,_r=yr(1<<24),Ir=yr(0);pr.ZERO=Ir;var Mr=yr(0,!0);pr.UZERO=Mr;var Nr=yr(1);pr.ONE=Nr;var Tr=yr(1,!0);pr.UONE=Tr;var Dr=yr(-1);pr.NEG_ONE=Dr;var Rr=kr(-1,2147483647,!1);pr.MAX_VALUE=Rr;var Fr=kr(-1,-1,!0);pr.MAX_UNSIGNED_VALUE=Fr;var Cr=kr(0,-2147483648,!1);pr.MIN_VALUE=Cr;var Br=pr.prototype;Br.toInt=function(){return this.unsigned?this.low>>>0:this.low},Br.toNumber=function(){return this.unsigned?(this.high>>>0)*Sr+(this.low>>>0):this.high*Sr+(this.low>>>0)},Br.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(Cr)){var t=wr(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=wr(vr(e,6),this.unsigned),o=this,a="";;){var i=o.div(s),l=(o.sub(i.mul(s)).toInt()>>>0).toString(e);if((o=i).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Br.getHighBits=function(){return this.high},Br.getHighBitsUnsigned=function(){return this.high>>>0},Br.getLowBits=function(){return this.low},Br.getLowBitsUnsigned=function(){return this.low>>>0},Br.getNumBitsAbs=function(){if(this.isNegative())return this.eq(Cr)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},Br.isZero=function(){return 0===this.high&&0===this.low},Br.eqz=Br.isZero,Br.isNegative=function(){return!this.unsigned&&this.high<0},Br.isPositive=function(){return this.unsigned||this.high>=0},Br.isOdd=function(){return 1==(1&this.low)},Br.isEven=function(){return 0==(1&this.low)},Br.equals=function(e){return gr(e)||(e=Er(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},Br.eq=Br.equals,Br.notEquals=function(e){return!this.eq(e)},Br.neq=Br.notEquals,Br.ne=Br.notEquals,Br.lessThan=function(e){return this.comp(e)<0},Br.lt=Br.lessThan,Br.lessThanOrEqual=function(e){return this.comp(e)<=0},Br.lte=Br.lessThanOrEqual,Br.le=Br.lessThanOrEqual,Br.greaterThan=function(e){return this.comp(e)>0},Br.gt=Br.greaterThan,Br.greaterThanOrEqual=function(e){return this.comp(e)>=0},Br.gte=Br.greaterThanOrEqual,Br.ge=Br.greaterThanOrEqual,Br.compare=function(e){if(gr(e)||(e=Er(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},Br.comp=Br.compare,Br.negate=function(){return!this.unsigned&&this.eq(Cr)?Cr:this.not().add(Nr)},Br.neg=Br.negate,Br.add=function(e){gr(e)||(e=Er(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=s+(65535&e.low))>>>16,u+=(c+=r+i)>>>16,l+=(u+=n+a)>>>16,l+=t+o,kr((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Br.subtract=function(e){return gr(e)||(e=Er(e)),this.add(e.neg())},Br.sub=Br.subtract,Br.multiply=function(e){if(this.isZero())return Ir;if(gr(e)||(e=Er(e)),fr)return kr(fr.mul(this.low,this.high,e.low,e.high),fr.get_high(),this.unsigned);if(e.isZero())return Ir;if(this.eq(Cr))return e.isOdd()?Cr:Ir;if(e.eq(Cr))return this.isOdd()?Cr:Ir;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(_r)&&e.lt(_r))return wr(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,d=0;return h+=(d+=s*l)>>>16,c+=(h+=r*l)>>>16,h&=65535,c+=(h+=s*i)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=r*i)>>>16,c&=65535,u+=(c+=s*a)>>>16,u+=t*l+n*i+r*a+s*o,kr((h&=65535)<<16|(d&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},Br.mul=Br.multiply,Br.divide=function(e){if(gr(e)||(e=Er(e)),e.isZero())throw Error("division by zero");var t,n,r;if(fr)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?kr((this.unsigned?fr.div_u:fr.div_s)(this.low,this.high,e.low,e.high),fr.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?Mr:Ir;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return Mr;if(e.gt(this.shru(1)))return Tr;r=Mr}else{if(this.eq(Cr))return e.eq(Nr)||e.eq(Dr)?Cr:e.eq(Cr)?Nr:(t=this.shr(1).div(e).shl(1)).eq(Ir)?e.isNegative()?Nr:Dr:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(Cr))return this.unsigned?Mr:Ir;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=Ir}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),o=s<=48?1:vr(2,s-48),a=wr(t),i=a.mul(e);i.isNegative()||i.gt(n);)i=(a=wr(t-=o,this.unsigned)).mul(e);a.isZero()&&(a=Nr),r=r.add(a),n=n.sub(i)}return r},Br.div=Br.divide,Br.modulo=function(e){return gr(e)||(e=Er(e)),fr?kr((this.unsigned?fr.rem_u:fr.rem_s)(this.low,this.high,e.low,e.high),fr.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},Br.mod=Br.modulo,Br.rem=Br.modulo,Br.not=function(){return kr(~this.low,~this.high,this.unsigned)},Br.and=function(e){return gr(e)||(e=Er(e)),kr(this.low&e.low,this.high&e.high,this.unsigned)},Br.or=function(e){return gr(e)||(e=Er(e)),kr(this.low|e.low,this.high|e.high,this.unsigned)},Br.xor=function(e){return gr(e)||(e=Er(e)),kr(this.low^e.low,this.high^e.high,this.unsigned)},Br.shiftLeft=function(e){return gr(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?kr(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):kr(0,this.low<<e-32,this.unsigned)},Br.shl=Br.shiftLeft,Br.shiftRight=function(e){return gr(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?kr(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):kr(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},Br.shr=Br.shiftRight,Br.shiftRightUnsigned=function(e){if(gr(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?kr(this.low>>>e|t<<32-e,t>>>e,this.unsigned):kr(32===e?t:t>>>e-32,0,this.unsigned)},Br.shru=Br.shiftRightUnsigned,Br.shr_u=Br.shiftRightUnsigned,Br.toSigned=function(){return this.unsigned?kr(this.low,this.high,!1):this},Br.toUnsigned=function(){return this.unsigned?this:kr(this.low,this.high,!0)},Br.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},Br.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},Br.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},pr.fromBytes=function(e,t,n){return n?pr.fromBytesLE(e,t):pr.fromBytesBE(e,t)},pr.fromBytesLE=function(e,t){return new pr(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},pr.fromBytesBE=function(e,t){return new pr(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const Pr=dr||Object.assign(Object.create(null),dr,{default:dr});function Or(e){return Pr.fromString(e,!0,16)}const Lr=Or("c3a5c85c97cb3127"),zr=Or("b492b66fbe98f273"),Wr=Or("9ae16a3b2f90404f");function Kr(e){return e.xor(e.shru(47))}function Ur(e,t,n){const r=e.slice(t,t+n);return Pr.fromBytes(Array.from(r),!0,!0)}function qr(e,t){return Ur(e,t,8)}function Gr(e,t){return Ur(e,t,4)}function Hr(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function Vr(e,t,n=Or("9ddfea08eb382d69")){let r=e.xor(t).mul(n);r=r.xor(r.shru(47));let s=t.xor(r).mul(n);return s=s.xor(s.shru(47)),s=s.mul(n),s}function jr(e,t,n,r){return function(e,t,n,r,s,o){s=s.add(e),o=Hr(o.add(s).add(r),21);const a=s;return s=(s=s.add(t)).add(n),o=o.add(Hr(s,44)),[s.add(r),o.add(a)]}(qr(e,t),qr(e,t+8),qr(e,t+16),qr(e,t+24),n,r)}function Jr(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=u(e)),O().getBool("DEBUG")&&y(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function Zr(){return O().platform.now()}function Yr(e,t="utf-8"){return t=t||"utf-8",O().platform.encode(e,t)}function Xr(e,t="utf-8"){return t=t||"utf-8",O().platform.decode(e,t)}var Qr={__proto__:null,createScalarValue:function(e,t){return"string"===t?Yr(e):Jr([e],t)},toTypedArray:Jr,now:Zr,fetch:function(e,t){return O().platform.fetch(e,t)},encodeString:Yr,decodeString:Xr,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,r=0;for(;n>0;)r=Math.random()*n|0,n--,o(e,n,r),o(t,n,r)},clamp:s,nearestLargerEven:function(e){return e%2==0?e:e+1},swap:o,sum:function(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t},randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let r=0;r<e.length;r++){const s=Number(e[r])-Number(t[r]);n+=s*s}return n},assert:a,assertShapesMatch:i,assertNonNull:l,flatten:u,sizeFromShape:c,isScalarShape:function(e){return 0===e.length},arraysEqual:h,isInt:d,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:function(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]},createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:f,repeatedTry:function(e,t=(e=>0),n){return new Promise(((r,s)=>{let o=0;const a=()=>{if(e())return void r();o++;const i=t(o);null!=n&&o>=n?s():setTimeout(a,i)};a()}))},inferFromImplicitShape:function(e,t){let n=1,r=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==r)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${r} and dim ${t}`);r=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===r){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const s=e.slice();return s[r]=t/n,s},parseAxisParam:p,squeezeShape:g,getTypedArrayFromDType:m,getArrayFromDType:b,checkConversionForErrors:y,isValidDtype:w,hasEncodingLoss:function(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))},isTypedArray:k,bytesPerElement:v,bytesFromStringArray:x,isString:E,isBoolean:S,isNumber:$,inferDtype:A,isFunction:_,nearestDivisor:I,computeStrides:M,toNestedArray:T,makeOnesTypedArray:D,makeZerosTypedArray:R,makeZerosNestedTypedArray:function(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return T(e,new Float32Array(n));if("int32"===t)return T(e,new Int32Array(n));if("bool"===t)return T(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)},assertNonNegativeIntegerDimensions:F,locToIndex:function(e,t,n){if(0===t)return 0;if(1===t)return e[0];let r=e[e.length-1];for(let t=0;t<e.length-1;++t)r+=n[t]*e[t];return r},indexToLoc:function(e,t,n){if(0===t)return[];if(1===t)return[e];const r=new Array(t);for(let t=0;t<r.length-1;++t)r[t]=Math.floor(e/n[t]),e-=r[t]*n[t];return r[r.length-1]=e,r},isPromise:C,hexToLong:Or,fingerPrint64:function(e,t=e.length){const n=Pr.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=Wr.add(2*t),r=qr(e,0).add(Wr),s=qr(e,t-8);return Vr(Hr(s,37).mul(n).add(r),Hr(r,25).add(s).mul(n),n)}if(t>=4){const n=Wr.add(2*t);return Vr(Gr(e,0).shl(3).add(t),Gr(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),r=t+(e[t-1]<<2);return Kr(Wr.mul(n).xor(Lr.mul(r))).mul(Wr)}return Wr}(e,t):function(e,t=e.length){const n=Wr.add(2*t),r=qr(e,0).mul(zr),s=qr(e,8),o=qr(e,t-8).mul(n),a=qr(e,t-16).mul(Wr);return Vr(Hr(r.add(s),43).add(Hr(o,30)).add(a),r.add(Hr(s.add(Wr),18)).add(o),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=Wr.add(2*t),r=qr(e,0).mul(Wr),s=qr(e,8),o=qr(e,t-8).mul(n),a=qr(e,t-16).mul(Wr),i=Hr(r.add(s),43).add(Hr(o,30)).add(a),l=Vr(i,r.add(Hr(s.add(Wr),18)).add(o),n),u=qr(e,16).mul(n),c=qr(e,24),h=i.add(qr(e,t-32)).mul(n),d=l.add(qr(e,t-24)).mul(n);return Vr(Hr(u.add(c),43).add(Hr(h,30)).add(d),u.add(Hr(c.add(r),18)).add(h),n)}(e,t);let r=n,s=n.mul(zr).add(113),o=Kr(s.mul(Wr).add(113)).mul(Wr),a=[Pr.UZERO,Pr.UZERO],i=[Pr.UZERO,Pr.UZERO];r=r.mul(Wr).add(qr(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{r=Hr(r.add(s).add(a[0]).add(qr(e,l+8)),37).mul(zr),s=Hr(s.add(a[1]).add(qr(e,l+48)),42).mul(zr),r=r.xor(i[1]),s=s.add(a[0]).add(qr(e,l+40)),o=Hr(o.add(i[0]),33).mul(zr),a=jr(e,l,a[1].mul(zr),r.add(i[0])),i=jr(e,l+32,o.add(i[1]),s.add(qr(e,l+16))),[o,r]=[r,o],l+=64}while(l!==u);const h=zr.add(o.and(255).shl(1));return l=c,i[0]=i[0].add(t-1&63),a[0]=a[0].add(i[0]),i[0]=i[0].add(a[0]),r=Hr(r.add(s).add(a[0]).add(qr(e,l+8)),37).mul(h),s=Hr(s.add(a[1]).add(qr(e,l+48)),42).mul(h),r=r.xor(i[1].mul(9)),s=s.add(a[0].mul(9).add(qr(e,l+40))),o=Hr(o.add(i[0]),33).mul(h),a=jr(e,l,a[1].mul(h),r.add(i[0])),i=jr(e,l+32,o.add(i[1]),s.add(qr(e,l+16))),[o,r]=[r,o],Vr(Vr(a[0],i[0],h).add(Kr(s).mul(Lr)).add(o),Vr(a[1],i[1],h).add(r),h)}};class es{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new ns)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let o;const a=Zr();if(this.backendTimer.timerAvailable())o=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();o=Promise.resolve({kernelMs:Zr()-a})}if(O().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{ts(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:o.then((e=>e.kernelMs)),extraInfo:o.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:o}=e;n.forEach((e=>{Promise.all([e.data(),r,o]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function ts(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class ns{logKernelProfile(e,t,n,r,s,o){const a="number"==typeof r?f(`${r}ms`,9):r.error,i=f(e,25),l=t.rank,u=t.size,c=f(t.shape.toString(),14);let h="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;h+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${a}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${o}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function rs(e,t,n,r){const s=M(t),o=function(e,t,n,r){const s=c(t),o=r[r.length-1],a=new Array(o).fill(0),i=t.length,l="complex64"===n?is(e):e;if(i>1)for(let e=0;e<s/o;e++){const t=e*o;for(let e=0;e<o;e++)a[e]=Math.max(a[e],ss(l[t+e],0,n).length)}return a}(e,t,n,s),a=t.length,i=as(e,t,n,s,o),l=["Tensor"];return r&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(i.map((e=>"    "+e)).join("\n")),l.join("\n")}function ss(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:E(e)?`'${e}'`:"bool"===n?os(e):parseFloat(e.toFixed(7)).toString(),f(r,t)}function os(e){return 0===e?"false":"true"}function as(e,t,n,r,s,o=!0){const a="complex64"===n?2:1,i=t[0],l=t.length;if(0===l){if("complex64"===n){return[ss(is(e)[0],0,n)]}return"bool"===n?[os(e[0])]:[e[0].toString()]}if(1===l){if(i>20){const t=3*a;let r=Array.from(e.slice(0,t)),o=Array.from(e.slice((i-3)*a,i*a));return"complex64"===n&&(r=is(r),o=is(o)),["["+r.map(((e,t)=>ss(e,s[t],n))).join(", ")+", ..., "+o.map(((e,t)=>ss(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?is(e):Array.from(e)).map(((e,t)=>ss(e,s[t],n))).join(", ")+"]"]}const u=t.slice(1),c=r.slice(1),h=r[0]*a,d=[];if(i>20){for(let t=0;t<3;t++){const r=t*h,o=r+h;d.push(...as(e.slice(r,o),u,n,c,s,!1))}d.push("...");for(let t=i-3;t<i;t++){const r=t*h,o=r+h;d.push(...as(e.slice(r,o),u,n,c,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*h,o=r+h;d.push(...as(e.slice(r,o),u,n,c,s,t===i-1))}const f=2===l?",":"";d[0]="["+d[0]+f;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+f;let p=",\n";for(let e=2;e<l;e++)p+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(o?"":p),d}function is(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class ls{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=c(e),null!=n){const e=n.length;a(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||b(t,this.size),this.strides=M(e)}set(e,...t){0===t.length&&(t=[0]),a(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return us().makeTensor(this.values,this.shape,this.dtype)}}let us=null,cs=null;class hs{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=c(e),this.strides=M(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return cs.buffer(this.shape,this.dtype,e)}bufferSync(){return cs.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return T(this.shape,e,"complex64"===this.dtype)}arraySync(){return T(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=us().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>Xr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),us().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=us().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>Xr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await us().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(us().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return cs.print(this,e)}clone(){return this.throwIfDisposed(),cs.clone(this)}toString(e=!1){return rs(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),cs.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),us().makeVariable(this,e,t,n)}}Object.defineProperty(hs,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),K("Tensor",(()=>hs));class ds extends hs{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!h(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);us().disposeTensor(this),this.dataId=e.dataId,us().incRef(this,null)}dispose(){us().disposeVariable(this),this.isDisposedInternal=!0}}var fs,ps,gs,ms,bs;Object.defineProperty(ds,Symbol.hasInstance,{value:e=>e instanceof hs&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}(fs||(fs={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(ps||(ps={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(gs||(gs={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(ms||(ms={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(bs||(bs={}));const ys={float32:ms,int32:ps,bool:gs,complex64:bs};function ws(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return ys[e][t]}function ks(e){return ws(e,"int32")}function vs(e,t){if(e.dtype===t.dtype)return[e,t];const n=ws(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function xs(e,t){a(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function Es(e){const t=[];return Ss(e,t,new Set),t}function Ss(e,t,n){if(null==e)return;if(e instanceof hs)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),Ss(r,t,n))}}var $s={__proto__:null,makeTypesMatch:vs,assertTypesMatch:xs,isTensorInList:function(e,t){return t.some((t=>t.id===e.id))},getTensorsInContainer:Es};function As(e){return null!=e.kernelName}class _s{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Is{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new _s}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(er(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new es(this.backendInstance),!0}setupRegisteredKernels(){or(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){or(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const n=this.registryFactory[e];if(null==n)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const r=n.factory();if(!r||r instanceof t||"function"!=typeof r.then)return this.registry[e]=r,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=r.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,er(`Initialization of backend ${e} failed`),er(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return er(`Initialization of backend ${e} failed`),er(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),o=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,o),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Is.nextTensorId++}nextVariableId(){return Is.nextVariableId++}clone(e){const t=Ns.runKernel("Identity",{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Ns.runKernel("Cast",t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=rr(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const o=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=r-t-s-o;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,o=this.state.numTensors;let i,l;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=As(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(As(e)){const{kernelName:t,inputs:s,attrs:o}=e;null==this.backendName&&this.backend;const u=rr(t,this.backendName);a(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),i=()=>{const e=this.backend.numDataIds();l=u.kernelFunc({inputs:s,attrs:o,backend:this.backend});const a=Array.isArray(l)?l:[l];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,a);const i=a.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(r){const e=this.getTensorsForGradient(t,s,i);n=this.saveTensorsForBackwardMode(e)}return i}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};i=()=>{const e=this.backend.numDataIds();l=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(l)?l:[l];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,d=As(e)?null:e.backwardsFunc;let f;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(f=this.profiler.profileKernel(u,c,(()=>i())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(f),t=f.outputs):t=i()})),r&&this.addTapeNode(u,c,t,d,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-o,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:f.timeMs,extraInfo:f.extraInfo}),Array.isArray(l)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const r=sr(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let o;r.saveAllInputs?(a(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),o=Object.keys(t).map((e=>t[e]))):o=e.map((e=>t[e]));const i=n.filter(((e,t)=>s[t]));return o.concat(i)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&E(e[0])&&(s=e.map((e=>Yr(e))));const o=r.write(s,t,n),a=new hs(t,n,o,this.nextTensorId());if(this.trackTensor(a,r),"string"===n){const e=this.state.tensorInfo.get(o),t=x(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return a}makeTensorFromDataId(e,t,n,r){const s={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(s,r)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:r,dtype:s}=e,o=new hs(r,s,n,this.nextTensorId());return this.trackTensor(o,t),o}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new ds(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*v(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof ds||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*v(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,o){const a={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=sr(e);null!=i&&(r=i.gradFunc),null!=r&&(a.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=R(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,o))),this.state.activeTape.push(a)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=Es(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(a(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));a(s instanceof hs,(()=>"The result y returned by f() must be a tensor."));const o=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const o=e[n],a=o.inputs;for(const e in a){const n=a[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){o.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[o.id]=!0;break}if(i)break}}const o={};o[n.id]=!0;const a={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(o[n.outputs[e].id]){for(const e in r)o[r[e].id]=!0,a[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&a[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===o.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=D(c(e),"float32");return Ns.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const o=t[s],a=[];if(o.outputs.forEach((t=>{const n=e[t.id];null!=n?a.push(n):a.push(null)})),null==o.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${o.kernelName}.`);const i=o.gradient(a);for(const t in o.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const a=o.inputs[t];if(!h(s.shape,a.shape))throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${a.shape}'`);if(null==e[a.id])e[a.id]=s;else{const t=e[a.id];e[a.id]=r(t,s),t.dispose()}}}}(e,o,(e=>this.tidy(e)),Ts);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return a(_(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;a(t.every((e=>e instanceof hs)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),a(n.value instanceof hs,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),a(_(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),o=Array.isArray(s)?s:[s];a(o.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),a(o.every((e=>e instanceof hs)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const i={};return o.forEach(((e,t)=>{i[t]=()=>e})),i},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=Zr(),n=await this.backend.time(e);return n.wallMs=Zr()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new _s;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Ms(){const e=W();if(null==e._tfengine){const t=new B(e);e._tfengine=new Is(t)}var t;return t=e._tfengine.ENV,z=t,us=()=>e._tfengine,e._tfengine}Is.nextTensorId=0,Is.nextVariableId=0;const Ns=Ms();function Ts(e,t){const n={a:e,b:t};return Ns.runKernel("Add",n)}let Ds;function Rs(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Fs={__proto__:null,mockIsMobile:function(e){Ds=e},isMobile:function(e){if(void 0!==Ds)return Ds;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1},isBrowser:Rs};const Cs=O();function Bs(e,t){let n=e;if(k(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||k(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&O().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Ps(e,r,[]),r}function Ps(e,t,n){if(n=n||[],!Array.isArray(e)&&!k(e))return void a(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));a(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),a(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)Ps(e[t],r,n.concat(t))}function Os(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Ls(e,t,n,r="numeric"){if(e instanceof hs)return Os(r,e.dtype,t,n),e;let s=A(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Os(r,s,t,n),null==e||!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const o=Bs(e,s);k(e)||Array.isArray(e)||(e=[e]);const a="string"!==s?Jr(e,s):u(e,[],!0);return Ns.makeTensor(a,o,s)}function zs(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Ls(e,`${t}[${s}]`,n,r)))}Cs.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),Cs.registerFlag("IS_BROWSER",(()=>Rs())),Cs.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),Cs.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),Cs.registerFlag("PROD",(()=>!1)),Cs.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>Cs.getBool("DEBUG"))),Cs.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),Cs.registerFlag("IS_TEST",(()=>!1)),Cs.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),Cs.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),Cs.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const Ws="__op";function Ks(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const s=(...e)=>{Ns.startScope(n);try{const t=r(...e);return C(t)&&console.error("Cannot return a Promise inside of tidy."),Ns.endScope(t),t}catch(e){throw Ns.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const Us=Ks({complex_:function(e,t){const n=Ls(e,"real","complex"),r=Ls(t,"imag","complex");i(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return Ns.runKernel("Complex",s)}});function qs(e,t,n,r){if(null==r&&(r=A(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){F(t);const e=c(t),r=c(n);a(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==c(t.slice(e));a(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return k(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?Jr(e,r):u(e,[],!0),Ns.makeTensor(e,t,r)}function Gs(e,t,n){return qs(e,t,Bs(e,n),n)}const Hs={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};function Vs(e,t){const n={};let r,s=0;for(const o of t){const t=o.name,a=o.dtype,i=o.shape,l=c(i);let u;if("quantization"in o){const n=o.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${o.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${o.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==a)throw new Error(`Weight ${o.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${a}.`)}const i=Hs[n.dtype],c=e.slice(s,s+l*i),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===a)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===r&&(r=no()),u=r(h)}else{if("int32"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}s+=l*i}else if("string"===a){const t=c(o.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(s,s+4))[0];s+=4;const n=new Uint8Array(e.slice(s,s+t));u.push(n),s+=t}}else{const r=Hs[a],o=e.slice(s,s+l*r);if("float32"===a)u=new Float32Array(o);else if("int32"===a)u=new Int32Array(o);else if("bool"===a)u=new Uint8Array(o);else{if("complex64"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);{u=new Float32Array(o);const e=new Float32Array(u.length/2),r=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],r[t]=u[2*t+1];const s=Gs(e,i,"float32"),a=Gs(r,i,"float32");n[t]=Us(s,a),s.dispose(),a.dispose()}}s+=l*r}"complex64"!==a&&(n[t]=Gs(u,i,a))}return n}function js(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const r=new Uint8Array(t);let s=0;return n.forEach((e=>{r.set(new Uint8Array(e.buffer),s),s+=e.byteLength})),r.buffer}const Js="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function Zs(e){return Js?Buffer.byteLength(e):new Blob([e]).size}function Ys(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let r=0;return e.forEach((e=>{n.set(new Uint8Array(e),r),r+=e.byteLength})),n.buffer}function Xs(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function Qs(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}async function eo(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),null!=e.weightsManifest){const[r,s]=await t(e.weightsManifest);n.weightSpecs=r,n.weightData=s}return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),n}function to(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:Zs(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:Zs(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function no(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return r=>{const s=new ArrayBuffer(4*r.length),o=new Uint32Array(s);for(let s=0;s<r.length;s++){const a=r[s],i=e[n[a>>10]+(1023&a)]+t[a>>10];o[s]=i}return new Float32Array(s)}}class ro{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==ro.instance&&(ro.instance=new ro),ro.instance}static registerSaveRouter(e){ro.getInstance().saveRouters.push(e)}static registerLoadRouter(e){ro.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return ro.getHandlers(e,"save")}static getLoadHandlers(e,t){return ro.getHandlers(e,"load",t)}static getHandlers(e,t,n){const r=[];return("load"===t?ro.getInstance().loadRouters:ro.getInstance().saveRouters).forEach((t=>{const s=t(e,n);null!==s&&r.push(s)})),r}}function so(){if(!O().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function oo(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class ao{constructor(e){if(this.indexedDB=so(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>oo(r),r.onsuccess=()=>{const s=r.result;if(null==t){const t=s.transaction("models_store","readonly"),r=t.objectStore("models_store").get(this.modelPath);r.onsuccess=()=>{if(null==r.result)return s.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(r.result.modelArtifacts)},r.onerror=e=>(s.close(),n(r.error)),t.oncomplete=()=>s.close()}else{const r=to(t),o=s.transaction("model_info_store","readwrite");let a=o.objectStore("model_info_store");const i=a.put({modelPath:this.modelPath,modelArtifactsInfo:r});let l;i.onsuccess=()=>{l=s.transaction("models_store","readwrite");const i=l.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:r});i.onsuccess=()=>e({modelArtifactsInfo:r}),i.onerror=e=>{a=o.objectStore("model_info_store");const t=a.delete(this.modelPath);t.onsuccess=()=>(s.close(),n(i.error)),t.onerror=e=>(s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}}},r.onerror=e=>n(r.error)}))}}ao.URL_SCHEME="indexeddb://";const io=e=>{return O().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(ao.URL_SCHEME)?(t=e.slice(ao.URL_SCHEME.length),new ao(t)):null;var t};ro.registerSaveRouter(io),ro.registerLoadRouter(io);class lo{constructor(){this.indexedDB=so()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>oo(n),n.onsuccess=()=>{const r=n.result,s=r.transaction("model_info_store","readonly"),o=s.objectStore("model_info_store").getAll();o.onsuccess=()=>{const t={};for(const e of o.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},o.onerror=e=>(r.close(),t(o.error)),s.oncomplete=()=>r.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(ao.URL_SCHEME)?t.slice(ao.URL_SCHEME.length):t,new Promise(((t,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>oo(r),r.onsuccess=()=>{const s=r.result,o=s.transaction("model_info_store","readwrite"),a=o.objectStore("model_info_store"),i=a.get(e);let l;i.onsuccess=()=>{if(null==i.result)return s.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const r=a.delete(e),o=()=>{l=s.transaction("models_store","readwrite");const r=l.objectStore("models_store").delete(e);r.onsuccess=()=>t(i.result.modelArtifactsInfo),r.onerror=e=>n(i.error)};r.onsuccess=o,r.onerror=e=>(o(),s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}},r.onerror=e=>n(r.error)}))}}const uo="tensorflowjs_models",co="info",ho="model_topology",fo="weight_specs",po="weight_data",go="model_metadata";function mo(e){return{info:[uo,e,co].join("/"),topology:[uo,e,ho].join("/"),weightSpecs:[uo,e,fo].join("/"),weightData:[uo,e,po].join("/"),modelMetadata:[uo,e,go].join("/")}}function bo(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function yo(e){const t=e.split("/");if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join("/")}class wo{constructor(e){if(!O().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=mo(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),r=to(e);try{this.LS.setItem(this.keys.info,JSON.stringify(r)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(Js)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,r=t.length;e<r;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const s={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(s)),{modelArtifactsInfo:r}}catch(e){throw bo(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${r.modelTopologyBytes}, weightSpecsBytes=${r.weightSpecsBytes}, weightDataBytes=${r.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const r=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==r)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=r;const s=this.LS.getItem(this.keys.modelMetadata);if(null!=s){const e=JSON.parse(s);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const o=this.LS.getItem(this.keys.weightData);if(null==o)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(Js){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(o),t}}wo.URL_SCHEME="localstorage://";const ko=e=>{return O().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(wo.URL_SCHEME)?(t=e.slice(wo.URL_SCHEME.length),new wo(t)):null;var t};ro.registerSaveRouter(ko),ro.registerLoadRouter(ko);class vo{constructor(){a(O().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),a("undefined"==typeof window||"undefined"!=typeof window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=uo+"/",n="/"+co;for(let r=0;r<this.LS.length;++r){const s=this.LS.key(r);if(s.startsWith(t)&&s.endsWith(n)){e[yo(s)]=JSON.parse(this.LS.getItem(s))}}return e}async removeModel(e){var t;const n=mo(e=(t=e).startsWith(wo.URL_SCHEME)?t.slice(wo.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const r=JSON.parse(this.LS.getItem(n.info));return bo(n),r}}class xo{constructor(){this.managers={}}static getInstance(){return null==xo.instance&&(xo.instance=new xo),xo.instance}static registerManager(e,t){a(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),a(e.length>0,(()=>"scheme must not be an empty string."));const n=xo.getInstance();a(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=xo.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(xo.getInstance().managers)}}function Eo(e){if(-1===e.indexOf("://"))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${xo.getSchemes().join(",")}`);return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function So(e,t,n=!1){a(e!==t,(()=>`Old path and new path are the same: '${e}'`));const r=ro.getLoadHandlers(e);a(r.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),a(r.length<2,(()=>`Copying failed because more than one (${r.length}) load handlers for source URL ${e}.`));const s=r[0],o=ro.getSaveHandlers(t);a(o.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),a(o.length<2,(()=>`Copying failed because more than one (${r.length}) save handlers for destination URL ${t}.`));const i=o[0],l=Eo(e).scheme,u=Eo(e).path,c=l===Eo(e).scheme,h=await s.load();n&&c&&await xo.getManager(l).removeModel(u);const d=await i.save(h);return n&&!c&&await xo.getManager(l).removeModel(u),d.modelArtifactsInfo}class $o{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(O().get("IS_BROWSER")){O().setPlatform("browser",new $o);try{xo.registerManager(wo.URL_SCHEME,new vo)}catch(e){}try{xo.registerManager(ao.URL_SCHEME,new lo)}catch(e){}}const Ao=()=>require("node-fetch");let _o;class Io{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=O().global.fetch?O().global.fetch(e,t):(null==_o&&(_o=Ao()),_o(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Mo(e,t="float32",n){return t=t||"float32",F(e),new ls(e,t,n)}O().get("IS_NODE")&&!O().get("IS_BROWSER")&&O().setPlatform("node",new Io);const No=Ks({cast_:function(e,t){const n=Ls(e,"x","cast");if(!w(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return Ns.runKernel("Cast",r,s)}});const To=Ks({clone_:function(e){const t={x:Ls(e,"x","clone","string_or_numeric")};return Ns.runKernel("Identity",t)}});function Do(e,t=!1){console.log(e.toString(t))}Ms();cs={buffer:Mo,cast:No,clone:To,print:Do};function Ro(e){return new Promise((e=>setTimeout(e))).then(e)}class Fo{constructor(e){if(!O().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Fo.URL_SCHEME)&&(e=e.slice(Fo.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=Qs(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),r=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),s=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(s.download=this.modelJsonFileName,s.href=r,await Ro((()=>s.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Ro((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:to(e)}}}}Fo.URL_SCHEME="downloads://";class Co{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const r=JSON.parse(n.target.result),s=r.modelTopology;if(null==s)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==r.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:s});const o=eo(r,(e=>this.loadWeights(e)));e(o)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const r of e)t.push(...r.weights),n.push(...r.paths);const r=this.checkManifestAndWeightFiles(e),s=n.map((e=>this.loadWeightsFile(e,r[e])));return Promise.all(s).then((e=>[t,Ys(e)]))}loadWeightsFile(e,t){return new Promise(((n,r)=>{const s=new FileReader;s.onload=e=>{const t=e.target.result;n(t)},s.onerror=t=>r(`Failed to weights data from file of path '${e}'.`),s.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>Xs(e.name))),r={};for(const s of e)s.paths.forEach((e=>{const s=Xs(e);if(-1!==t.indexOf(s))throw new Error(`Duplicate file basename found in weights manifest: '${s}'`);if(t.push(s),-1===n.indexOf(s))throw new Error(`Weight file with basename '${s}' is not provided.`);r[e]=this.weightsFiles[n.indexOf(s)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return r}}function Bo(e,t,n,r){!function(e){a(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){a(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),a(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),a(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,r=null==r?1:r);let s=0;return Promise.all(e.map((o=>(o.then((o=>{const a=n+ ++s/e.length*(r-n);return t(a),o})),o))))}async function Po(e,t){null==t&&(t={});const n=null==t.fetchFunc?O().platform.fetch:t.fetchFunc,r=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),s=(null==t.onProgress?await Promise.all(r):await Bo(r,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(s):await Bo(s,t.onProgress,.5,1)}function Oo(e){return async(t,n="",r)=>{const s=t.map((()=>!1)),o={},a=null!=r?r.map((()=>!1)):[],i=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=Hs[l]*c(e.shape),h=()=>{s[t]=!0,null==o[t]&&(o[t]=[]),o[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=r?r.forEach(((t,n)=>{t===e.name&&(h(),a[n]=!0)})):h(),i.push(e.name),n+=u}))})),!a.every((e=>e))){const e=r.filter(((e,t)=>!a[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${i.join(", ")}.`)}const l=s.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const h=await e(u),d={};let f=0;return l.forEach((e=>{const n=t[e].paths.length;let r=0;for(let e=0;e<n;e++)r+=h[f+e].byteLength;const s=new ArrayBuffer(r),a=new Uint8Array(s);let i=0;for(let e=0;e<n;e++){const t=new Uint8Array(h[f+e]);a.set(t,i),i+=t.byteLength}o[e].forEach((e=>{const t=Vs(s.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)d[e]=t[e]})),f+=n})),d}}ro.registerSaveRouter((e=>O().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Fo.URL_SCHEME)?function(e="model"){return new Fo(e)}(e.slice(Fo.URL_SCHEME.length)):null));class Lo{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(a("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=O().platform.fetch,a(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&a(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=Qs(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:to(e),responses:[r]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,r=t.weightsManifest;if(null==n&&null==r)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return eo(t,(e=>this.loadWeights(e)))}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,r]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),r=e.substring(0,t),s=n>t?e.substring(n):"";return[r+"/",s]}(t),s=this.weightPathPrefix||n,o=[];for(const t of e)o.push(...t.weights);const a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(s+e+r);this.weightUrlConverter&&a.push(...await Promise.all(i));return[o,Ys(await Po(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function zo(e){return null!=e.match(Lo.URL_SCHEME_REGEX)}Lo.URL_SCHEME_REGEX=/^https?:\/\//;const Wo=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>zo(e))):zo(e),n)return Ko(e,t)}return null};function Ko(e,t){return new Lo(e,t)}ro.registerSaveRouter(Wo),ro.registerLoadRouter(Wo);class Uo{constructor(e){this.modelArtifacts=e}load(){return this.modelArtifacts}}class qo{constructor(e){this.saveHandler=e}save(e){return this.saveHandler(e)}}class Go{constructor(e){e.load&&(this.load=()=>Promise.resolve(e.load())),e.save&&(this.save=t=>Promise.resolve(e.save(t)))}}function Ho(e,t,n,r){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new Uo(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Uo({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new Uo({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:r})}var Vo={__proto__:null,browserFiles:function(e){return new Co(e)},browserHTTPRequest:function(e,t){return Ko(e,t)},concatenateArrayBuffers:Ys,decodeWeights:Vs,encodeWeights:async function(e,t){const n=[],r=[],s=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let o=0;o<s.length;++o){const a=s[o],i=Array.isArray(e)?e[o].tensor:e[a];if("float32"!==i.dtype&&"int32"!==i.dtype&&"bool"!==i.dtype&&"string"!==i.dtype&&"complex64"!==i.dtype)throw new Error(`Unsupported dtype in weight '${a}': ${i.dtype}`);const l={name:a,shape:i.shape,dtype:i.dtype};if("string"===i.dtype){const e=new Promise((async e=>{const t=await i.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,r=new Uint8Array(n);let s=0;for(let e=0;e<t.length;e++){const n=t[e],o=new Uint8Array(new Uint32Array([n.length]).buffer);r.set(o,s),s+=4,r.set(n,s),s+=n.length}e(r)}));r.push(e)}else r.push(i.data());null!=t&&(l.group=t),n.push(l)}return{data:js(await Promise.all(r)),specs:n}},fromMemory:function(e,t,n,r){const s=arguments;return new Go(Ho(...s))},fromMemorySync:Ho,getLoadHandlers:(e,t)=>ro.getLoadHandlers(e,t),getModelArtifactsForJSON:eo,getModelArtifactsInfoForJSON:to,getSaveHandlers:e=>ro.getSaveHandlers(e),http:Ko,isHTTPScheme:zo,loadWeights:async function(e,t="",n,r){return Oo((e=>Po(e,{requestInit:r})))(e,t,n)},registerLoadRouter:e=>ro.registerLoadRouter(e),registerSaveRouter:e=>ro.registerSaveRouter(e),weightsLoaderFactory:Oo,withSaveHandler:function(e){return new qo(e)},withSaveHandlerSync:function(e){return new qo(e)},copyModel:async function(e,t){return So(e,t,!1)},listModels:async function(){const e=xo.getSchemes(),t={};for(const n of e){const e=await xo.getManager(n).listModels();for(const r in e){t[n+"://"+r]=e[r]}}return t},moveModel:async function(e,t){return So(e,t,!0)},removeModel:async function(e){const t=Eo(e);return xo.getManager(t.scheme).removeModel(t.path)}};const jo=Ks({matMul_:function(e,t,n=!1,r=!1){let s=Ls(e,"a","matMul"),o=Ls(t,"b","matMul");[s,o]=vs(s,o);const a={a:s,b:o},i={transposeA:n,transposeB:r};return Ns.runKernel("BatchMatMul",a,i)}});const Jo=Ks({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Ls(e,"indices","oneHot","int32")},o={depth:t,onValue:n,offValue:r};return Ns.runKernel("OneHot",s,o)}});function Zo(){O().set("PROD",!0)}function Yo(){O().set("DEBUG",!0)}function Xo(){O().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")}function Qo(e){O().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function ea(){Ns.disposeVariables()}function ta(){return Ns}function na(){return Ns.memory()}function ra(e){return Ns.profile(e)}function sa(e,t){return Ns.tidy(e,t)}function oa(e){Es(e).forEach((e=>e.dispose()))}function aa(e){return Ns.keep(e)}function ia(e){return Ns.time(e)}function la(e){return Ns.setBackend(e)}function ua(){return Ns.ready()}function ca(){return Ns.backendName}function ha(e){Ns.removeBackend(e)}function da(e){return Ns.findBackend(e)}function fa(e){return Ns.findBackendFactory(e)}function pa(e,t,n=1){return Ns.registerBackend(e,t,n)}function ga(){return Ns.backend}function ma(e,t){O().setPlatform(e,t)}const ba=Ks({imag_:function(e){const t={input:Ls(e,"input","imag")};return Ns.runKernel("Imag",t)}});const ya=Ks({neg_:function(e){const t={x:Ls(e,"x","neg")};return Ns.runKernel("Neg",t)}});const wa=Ks({real_:function(e){const t={input:Ls(e,"input","real")};return Ns.runKernel("Real",t)}});const ka=Ks({transpose_:function(e,t,n){const r=Ls(e,"x","transpose");if(null==t&&(t=r.shape.map(((e,t)=>t)).reverse()),a(r.rank===t.length,(()=>`Error in transpose: rank of input ${r.rank} must match length of perm ${t}.`)),t.forEach((e=>{a(e>=0&&e<r.rank,(()=>"All entries in 'perm' must be between 0 and "+(r.rank-1)+` but got ${t}`))})),r.rank<=1)return r.clone();const s={x:r},o={perm:t};return"complex64"===r.dtype?sa((()=>{let e=wa(r),t=ba(r);return e=Ns.runKernel("Transpose",{x:e},o),t=Ns.runKernel("Transpose",{x:t},o),n&&(t=ya(t)),Us(e,t)})):Ns.runKernel("Transpose",s,o)}});var va={__proto__:null,confusionMatrix:Ks({confusionMatrix_:function(e,t,n){const r=Ls(e,"labels","confusionMatrix"),s=Ls(t,"predictions","confusionMatrix");a(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),a(1===r.rank,(()=>`Expected the rank of labels to be 1, but got ${r.rank}`)),a(1===s.rank,(()=>`Expected the rank of predictions to be 1, but got ${s.rank}`)),a(r.shape[0]===s.shape[0],(()=>`Mismatch in the number of examples: ${r.shape[0]} vs. ${s.shape[0]}. Labels and predictions should have the same number of elements.`)),a(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const o=Jo(No(r,"int32"),n),i=Jo(No(s,"int32"),n),l=ka(o),u=jo(l,i);return No(u,"int32")}})};function xa(e,t){const n=e.length,r=[];for(let s=0;s<n;s++){const o=n-1-s,a=e[o]||1;(t[t.length-1-s]||1)>1&&1===a&&r.unshift(o)}return r}function Ea(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],o=t.length-r-1,a=t[o];(null==s||1===s&&a>1)&&n.unshift(o)}return n}function Sa(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let o=t[t.length-s-1];if(null==o&&(o=1),1===r)n.unshift(o);else if(1===o)n.unshift(r);else{if(r!==o){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}var $a={__proto__:null,getBroadcastDims:xa,getReductionAxes:Ea,assertAndGetBroadcastShape:Sa};function Aa(e,t,n){if(l(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Bs(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return qs(e,t,r,n)}let _a;function Ia(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,r=!1,s=!1,o=!1,a=!1,i=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)r=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)s=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)o=!0;else if(null!=e.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);i=!0}if(s){const t=2;if(s&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=rr("FromPixels",Ns.backendName)){const n={pixels:e},r={numChannels:t};return Ns.runKernel("FromPixels",n,r)}const[l,u]=s?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(a)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(r||n)c=e.data;else if(o||s||i){if(null==_a)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");_a=new OffscreenCanvas(1,1).getContext("2d")}else _a=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});_a.canvas.width=l,_a.canvas.height=u,_a.drawImage(e,0,0,l,u),c=_a.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return Aa(h,[u,l,t],"int32")}function Ma(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}var Na={__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(O().getBool("WRAP_TO_IMAGEBITMAP")&&Ma(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return Ia(n,t)},toPixels:async function(e,t){let n=Ls(e,"img","toPixels");if(!(e instanceof hs)){const e=n;n=No(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[r,s]=n.shape.slice(0,2),o=2===n.rank?1:n.shape[2];if(o>4||2===o)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${o}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const a=await n.data(),i="float32"===n.dtype?255:1,l=new Uint8ClampedArray(s*r*4);for(let e=0;e<r*s;++e){const t=[0,0,0,255];for(let r=0;r<o;r++){const s=a[e*o+r];if("float32"===n.dtype){if(s<0||s>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${s}.`)}else if("int32"===n.dtype&&(s<0||s>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${s}.`);1===o?(t[0]=s*i,t[1]=s*i,t[2]=s*i):t[r]=s*i}const r=4*e;l[r+0]=Math.round(t[0]),l[r+1]=Math.round(t[1]),l[r+2]=Math.round(t[2]),l[r+3]=Math.round(t[3])}if(null!=t){t.width=s,t.height=r;const e=t.getContext("2d"),n=new ImageData(l,s,r);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:Ks({fromPixels_:Ia})};function Ta(e,t){const n=e.shape.length,r=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(r<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${r}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[r-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[r-1]} vs. ${n}`);if(0===c(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const s=t.shape,o=s[s.length-1];let a=1;for(let e=0;e<s.length-1;++e)a*=s[e];const i=e.shape,l=s.slice();l.pop();let u=1;for(let e=o;e<n;++e)u*=i[e],l.push(i[e]);const h=[...M(e.shape).map((e=>e/u)),1].slice(0,o);return[l,a,u,h]}var Da={__proto__:null,prepareAndValidate:Ta};function Ra(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,o=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(o+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(o+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(o+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(o+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(o+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}function Fa(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}Ra(n,t,e)}function Ca(e,t,n){const r=t.shape.length,s=r>1?t.shape[r-1]:1,o=n.length;let a=1;for(let e=s;e<o;++e)a*=n[e];const i=s<1?1:s;return{sliceRank:s,numUpdates:c(t.shape)/i,sliceSize:a,strides:[...M(n.slice(0,s)),1],outputSize:c(n)}}var Ba={__proto__:null,validateUpdateShape:Ra,validateInput:Fa,calculateShapes:Ca};function Pa(e,t,n,r){const s=[...e];for(let e=s.length;e<r.length;e++)s.push(1);for(let e=0;e<n;e++)0===e?s[t]=1:(s.splice(t,0,1),s.pop());return s}function Oa(e,t,n){return n<=e?n:n-(t-1)}function La(e,t){const n=[];for(let r=0;r<e;r++)n.push(t+r);return n}function za(e,t,n,r,s){const o=[...s],a=La(n,t);for(let s=0;s<o.length;s++)if(a.indexOf(s)>-1)o[s]=0;else{const a=Oa(t,n,s);let i=r[a];e&1<<a&&(i=0),o[s]=i}return o}function Wa(e,t,n,r,o){const a=[...o],i=La(n,t);for(let s=0;s<a.length;s++)if(i.indexOf(s)>-1)a[s]=Number.MAX_SAFE_INTEGER;else{const o=Oa(t,n,s);let i=r[o];e&1<<o&&(i=Number.MAX_SAFE_INTEGER),a[s]=i}for(let e=0;e<a.length;e++){const t=o[e];a[e]<0&&(a[e]+=t),a[e]=s(0,a[e],o[e])}return a}function Ka(e,t,n){let r=e[t];return(n&1<<t||null==r)&&(r=1),r}function Ua(e,t,n,r,o,a){let i=t[o];const l=n[o]||1;(e&1<<o||a&1<<o||null==i)&&(i=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=r[o];return i<0&&(i+=u),i=s(0,i,u-1),i}function qa(e,t,n,r,o,a){let i=t[o];const l=n[o]||1;(e&1<<o||a&1<<o||null==i)&&(i=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=r[o];return i<0&&(i+=u),i=l>0?s(0,i,u):s(-1,i,u-1),i}function Ga(e,t,n,r,s,o){if(s[t])return n>0?o[t]:o[t+1&1];{const t=e<0?r+e:e;return t<o[0]?o[0]:t>o[1]?o[1]:t}}var Ha={__proto__:null,assertParamsValid:function(e,t,n){const r=e.shape.length;a(r===t.length,(()=>`Error in slice${r}D: Length of begin ${t} must match the rank of the array (${r}).`)),a(r===n.length,(()=>`Error in slice${r}D: Length of size ${n} must match the rank of the array (${r}).`));for(let s=0;s<r;++s)a(t[s]+n[s]<=e.shape[s],(()=>`Error in slice${r}D: begin[${s}] + size[${s}] (${t[s]+n[s]}) would overflow input.shape[${s}] (${e.shape[s]})`))},maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},computeOutShape:function(e,t,n){const r=[];for(let s=0;s<e.length;s++)r[s]=Math.ceil((t[s]-e[s])/n[s]);return r},stridesWithElidedDims:Pa,getNormalizedAxes:function(e,t,n,r,s,o,a,i,l){const u=e.length;let c=new Array(u),h=new Array(u),d=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=za(a,l,u,r,e),h=Wa(i,l,u,s,e),d=Pa(o,l,u,e)}else for(let t=0;t<u;t++)c[t]=Ua(a,r,o,e,t,l),h[t]=qa(i,s,o,e,t,l),d[t]=Ka(o,t,l);return{begin:c,end:h,strides:d}},startIndicesWithElidedDims:za,stopIndicesWithElidedDims:Wa,stridesForAxis:Ka,startForAxis:Ua,stopForAxis:qa,isSliceContinous:function(e,t,n){let r=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){r=e;break}for(let s=r+1;s<n.length;s++)if(t[s]>0||n[s]!==e[s])return!1;return!0},computeFlatOffset:function(e,t){let n=e.length>0?e[e.length-1]:1;for(let r=0;r<e.length-1;r++)n+=e[r]*t[r];return n},parseSliceParams:function(e,t,n){let r;const s=e.shape.length;let o;return r="number"==typeof t?[t,...new Array(s-1).fill(0)]:t.length<s?t.concat(new Array(s-t.length).fill(0)):t.slice(),r.forEach((e=>{a(-1!==e,(()=>"slice() does not support negative begin indexing."))})),o=null==n?new Array(s).fill(-1):"number"==typeof n?[n,...new Array(s-1).fill(-1)]:n.length<s?n.concat(new Array(s-n.length).fill(-1)):n,o=o.map(((t,n)=>t>=0?t:(a(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-r[n]))),[r,o]},sliceInfo:function(e,t,n,r,s,o,a,i,l){let u;if(null==r?(u=new Array(t.length),u.fill(1)):u=r,null!=a&&0!=(a&a-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&i)&&h.numAddAxisAfterEllipsis++,1<<e&a&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const d={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let r=0;r<e.dims;r++)if(1<<r&e.ellipsisMask){const s=Math.min(t.dims-(e.dims-r)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<s;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=r}else if(1<<r&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[r]),null!=e.end&&(t.end[n]=e.end[r]),t.strides[n]=e.strides[r],e.beginMask&1<<r&&(t.beginMask|=1<<n),e.endMask&1<<r&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<r?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(r)),t.inputShapeGatherIndicesSparse[n]=r,n++}}(h,d);let f=!0,p=!0,g=!0;const m=[],b=[];for(let t=0;t<e.length;++t){if(0===d.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(d.shrinkAxisMask&1<<t),r=e[t];if(-1===r){m.push(n?1:-1);continue}const s=[d.beginMask&1<<t,d.endMask&1<<t],o=[d.strides[t]>0?0:-1,d.strides[t]>0?r:r-1];if(n&&d.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");g=g&&1===d.strides[t];const a=!!(d.beginMask&1<<t&&d.endMask&1<<t);if(d.beginValid&&d.endValid){if(n){const e=d.begin[t]<0?r+d.begin[t]:d.begin[t];if(d.begin[t]=e,d.end[t]=d.begin[t]+1,e<0||e>=r)throw Error(`slice index ${d.begin[t]} of dimension ${t} out of bounds.`)}else d.begin[t]=Ga(d.begin[t],0,d.strides[t],r,s,o),d.end[t]=Ga(d.end[t],1,d.strides[t],r,s,o);const e=1===d.strides[t]&&0===d.begin[t]&&d.end[t]===r;f=f&&e,p=p&&(0===t&&1===d.strides[t]||e)}else f=f&&1===d.strides[t]&&a,p=p&&(0===t&&1===d.strides[t]||a);let i,l=!1;if(d.beginValid&&d.endValid?(i=d.end[t]-d.begin[t],l=!0):n?(i=1,l=!0):a&&r>=0&&(i=d.strides[t]<0?-r:r,l=!0),l){let e;e=0===i||i<0!=d.strides[t]<0?0:Math.trunc(i/d.strides[t])+(i%d.strides[t]!=0?1:0),m.push(e)}else m.push(-1)}for(let e=0;e<d.finalShapeGatherIndices.length;++e){const t=d.finalShapeGatherIndices[e];t>=0?b.push(m[t]):-2===t&&b.push(1)}return{finalShapeSparse:b.filter(((e,t)=>-2!==d.finalShapeGatherIndices[t])),finalShape:b,isIdentity:f,sliceDim0:p,isSimpleSlice:g,begin:d.begin,end:d.end,strides:d.strides}}};class Va{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class ja{constructor(){this.classNameMap={}}static getMap(){return null==ja.instance&&(ja.instance=new ja),ja.instance}static register(e){ja.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function Ja(e){a(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),a("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),a(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),ja.register(e)}var Za={__proto__:null,Serializable:Va,SerializationMap:ja,registerClass:Ja};function Ya(){return 32===Ns.backend.floatPrecision()?.001:.1}function Xa(e,t,n){let r=!0;if((k(e)||k(t))&&(r=!1),k(e)&&k(t)&&(r=!0),r){const n=e.constructor.name,r=t.constructor.name;if(n!==r)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${r}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=Bs(e),r=Bs(t);if(!h(n,r))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${r}]`)}const s=k(e)?e:u(e),o=k(t)?t:u(t);if(s.length!==o.length)throw new Error(`Arrays have different lengths actual: ${s.length} vs expected: ${o.length}.\nActual:   ${s}.\nExpected: ${o}.`);for(let e=0;e<o.length;++e){const t=s[e],r=o[e];if(!n(t,r))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${r}.\nActual:   ${s}.\nExpected: ${o}.`)}}function Qa(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var ei={__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=Ya()),Xa(e,t,((e,t)=>Qa(e,t,n)))},testEpsilon:Ya,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return E(e)||E(e[0])||E(t)||E(t[0])?Xa(e,n,((e,t)=>e==t)):Xa(e,t,((e,t)=>Qa(e,t,0)))},expectNumbersClose:function(e,t,n){if(null==n&&(n=Ya()),!Qa(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)},expectValuesInRange:function(e,t,n){for(let r=0;r<e.length;r++)if(e[r]<t||e[r]>n)throw new Error(`Value out of range:${e[r]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),r=new Float32Array(t);if(n.length!==r.length)throw new Error(`Expected ArrayBuffer to be of length ${r.length}, but it was ${n.length}`);for(let e=0;e<r.length;e++)if(n[e]!==r[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${r[e]} but got ${n[e]} instead`)},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const r=t[n];Array.isArray(r)?e(r):t[n]=Yr(r)}return t}};const ti="3.19.0";const ni=Ks({add_:function(e,t){let n=Ls(e,"a","add"),r=Ls(t,"b","add");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Add",s)}});const ri=Ks({floorDiv_:function(e,t){let n=Ls(e,"a","floorDiv"),r=Ls(t,"b","floorDiv");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("FloorDiv",s)}});const si=Ks({div_:function(e,t){let n=Ls(e,"a","div"),r=Ls(t,"b","div");if([n,r]=vs(n,r),"int32"===n.dtype&&"int32"===r.dtype)return ri(n,r);const s={a:n,b:r};return Ns.runKernel("RealDiv",s,{})}});const oi=Ks({mul_:function(e,t){let n=Ls(e,"a","mul"),r=Ls(t,"b","mul");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Multiply",s)}});const ai=Ks({abs_:function(e){const t=Ls(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Ns.runKernel("ComplexAbs",e)}{const e={x:t};return Ns.runKernel("Abs",e)}}});const ii=Ks({acos_:function(e){const t={x:Ls(e,"x","acos")};return Ns.runKernel("Acos",t)}});const li=Ks({acosh_:function(e){const t={x:Ls(e,"x","acosh")};return Ns.runKernel("Acosh",t)}});const ui=Ks({addN_:function(e){a(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),a(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Ls(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!h(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return Ns.runKernel("AddN",r)}});const ci=Ks({all_:function(e,t=null,n=!1){const r={x:Ls(e,"x","all","bool")},s={axis:t,keepDims:n};return Ns.runKernel("All",r,s)}});const hi=Ks({any_:function(e,t=null,n=!1){const r={x:Ls(e,"x","any","bool")},s={axis:t,keepDims:n};return Ns.runKernel("Any",r,s)}});const di=Ks({argMax_:function(e,t=0){const n={x:Ls(e,"x","argMax")},r={axis:t};return Ns.runKernel("ArgMax",n,r)}});const fi=Ks({argMin_:function(e,t=0){const n={x:Ls(e,"x","argMin")},r={axis:t};return Ns.runKernel("ArgMin",n,r)}});const pi=Ks({asin_:function(e){const t={x:Ls(e,"x","asin")};return Ns.runKernel("Asin",t)}});const gi=Ks({asinh_:function(e){const t={x:Ls(e,"x","asinh")};return Ns.runKernel("Asinh",t)}});const mi=Ks({atan_:function(e){const t={x:Ls(e,"x","atan")};return Ns.runKernel("Atan",t)}});const bi=Ks({atan2_:function(e,t){let n=Ls(e,"a","atan2"),r=Ls(t,"b","atan2");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Atan2",s)}});const yi=Ks({atanh_:function(e){const t={x:Ls(e,"x","atanh")};return Ns.runKernel("Atanh",t)}});function wi(e,t,n,r,s,o,a="channelsLast"){const[i,l]=Ei(t);let u;if("channelsLast"===a)u=[i,l,e[3],e[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[i,l,e[1],e[1]]}return ki(e,u,n,r,s,o,!1,a)}function ki(e,t,n,r,s,o,a=!1,i="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,h,u,c]=e}const[d,f,,p]=t,[g,m]=Ei(n),[b,y]=Ei(r),w=$i(d,b),k=$i(f,y),{padInfo:v,outHeight:x,outWidth:E}=function(e,t,n,r,s,o,a,i,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=xi(e,t,n));const o=e[0],a=e[1],i=Ai((o-t+2*r)/n+1,s),l=Ai((a-t+2*r)/n+1,s);return[i,l]}([t,n],o,r,e,i);c=s[0],h=s[1]}else if("same"===e){c=Math.ceil(t/r),h=Math.ceil(n/s);const e=Math.max(0,(c-1)*r+o-t),i=Math.max(0,(h-1)*s+a-n),l=Math.floor(e/2),d=e-l,f=Math.floor(i/2);u={top:l,bottom:d,left:f,right:i-f,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-o+1)/r),h=Math.ceil((n-a+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const d="channelsLast"===l?e[1][0]:e[2][0],f="channelsLast"===l?e[1][1]:e[2][1],p="channelsLast"===l?e[2][0]:e[3][0],g="channelsLast"===l?e[2][1]:e[3][1];u={top:d,bottom:f,left:p,right:g,type:0===d&&0===f&&0===p&&0===g?"VALID":"EXPLICIT"},c=Ai((t-o+d+f)/r+1,i),h=Ai((n-a+p+g)/s+1,i)}}return{padInfo:u,outHeight:c,outWidth:h}}(s,u,c,g,m,w,k,o,i),S=a?p*h:p;let $;return"channelsFirst"===i?$=[l,S,x,E]:"channelsLast"===i&&($=[l,x,E,S]),{batchSize:l,dataFormat:i,inHeight:u,inWidth:c,inChannels:h,outHeight:x,outWidth:E,outChannels:S,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:d,filterWidth:f,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:e,outShape:$,filterShape:t}}function vi(e,t,n,r,s,o=!1,a="channelsLast",i){let[l,u,c,h,d]=[-1,-1,-1,-1,-1];if("channelsLast"===a)[l,u,c,h,d]=e;else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);[l,d,u,c,h]=e}const[f,p,g,,m]=t,[b,y,w]=Si(n),[k,v,x]=Si(r),E=$i(f,k),S=$i(p,v),$=$i(g,x),{padInfo:A,outDepth:_,outHeight:I,outWidth:M}=function(e,t,n,r,s,o,a,i,l,u,c){let h,d,f,p;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const o=function(e,t,n,r,s,o){null==s&&(s=xi(e,t,r));const a=e[0],i=e[1],l=e[2],u=Ai((a-t+2*s)/r+1,o),c=Ai((i-t+2*s)/r+1,o),h=Ai((l-t+2*s)/r+1,o);return[u,c,h,n]}([t,n,r,1],i,1,s,e,c);d=o[0],f=o[1],p=o[2]}else if("same"===e){d=Math.ceil(t/s),f=Math.ceil(n/o),p=Math.ceil(r/a);const e=(d-1)*s+i-t,c=(f-1)*o+l-n,g=(p-1)*a+u-r,m=Math.floor(e/2),b=e-m,y=Math.floor(c/2),w=c-y,k=Math.floor(g/2);h={top:y,bottom:w,left:k,right:g-k,front:m,back:b,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((t-i+1)/s),f=Math.ceil((n-l+1)/o),p=Math.ceil((r-u+1)/a)}return{padInfo:h,outDepth:d,outHeight:f,outWidth:p}}(s,u,c,h,b,y,w,E,S,$,i),N=o?m*d:m;let T;return"channelsFirst"===a?T=[l,N,_,I,M]:"channelsLast"===a&&(T=[l,_,I,M,N]),{batchSize:l,dataFormat:a,inDepth:u,inHeight:c,inWidth:h,inChannels:d,outDepth:_,outHeight:I,outWidth:M,outChannels:N,padInfo:A,strideDepth:b,strideHeight:y,strideWidth:w,filterDepth:f,filterHeight:p,filterWidth:g,effectiveFilterDepth:E,effectiveFilterHeight:S,effectiveFilterWidth:$,dilationDepth:k,dilationHeight:v,dilationWidth:x,inShape:e,outShape:T,filterShape:t}}function xi(e,t,n,r=1){const s=$i(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}function Ei(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function Si(e){return"number"==typeof e?[e,e,e]:e}function $i(e,t){return t<=1?e:e+(e-1)*(t-1)}function Ai(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function _i(e){const[t,n,r]=Ei(e);return 1===t&&1===n&&1===r}function Ii(e,t){return _i(e)||_i(t)}function Mi(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function Ni(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)a(d(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{a(d(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const Ti=Ks({reshape_:function(e,t){const n={x:Ls(e,"x","reshape","string_or_numeric")},r={shape:t};return Ns.runKernel("Reshape",n,r)}});const Di=Ks({avgPool_:function(e,t,n,r,s){const o=Ls(e,"x","avgPool","float32");a(Ii(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let i=o,l=!1;3===o.rank&&(l=!0,i=Ti(o,[1,o.shape[0],o.shape[1],o.shape[2]])),a(4===i.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`)),Ni("avgPool",r,s);const u={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let h=Ns.runKernel("AvgPool",u,c);return h=No(h,o.dtype),l?Ti(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Ri=Ks({avgPool3d_:function(e,t,n,r,s,o="NDHWC"){const i=Ls(e,"x","avgPool3d","float32");let l=i,u=!1;4===i.rank&&(u=!0,l=Ti(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===l.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${l.rank}.`)),a("NDHWC"===o,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Ni("avgPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o};let d=Ns.runKernel("AvgPool3D",c,h);return d=No(d,l.dtype),u?Ti(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Fi=Ks({concat_:function(e,t=0){a(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=zs(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return To(n[0]);const r=n,s={axis:t};return Ns.runKernel("Concat",r,s)}});const Ci=Ks({sigmoid_:function(e){const t={x:Ls(e,"x","sigmoid","float32")};return Ns.runKernel("Sigmoid",t)}});const Bi=Ks({slice_:function(e,t,n){const r=Ls(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},o={begin:t,size:n};return Ns.runKernel("Slice",s,o)}});const Pi=Ks({tanh_:function(e){const t={x:Ls(e,"x","tanh","float32")};return Ns.runKernel("Tanh",t)}});const Oi=Ks({basicLSTMCell_:function(e,t,n,r,s,o){const a=Ls(e,"forgetBias","basicLSTMCell"),i=Ls(t,"lstmKernel","basicLSTMCell"),l=Ls(n,"lstmBias","basicLSTMCell"),u=Ls(r,"data","basicLSTMCell"),c=Ls(s,"c","basicLSTMCell"),h=Ls(o,"h","basicLSTMCell"),d=Fi([u,h],1),f=jo(d,i),p=ni(f,l),g=p.shape[0],m=p.shape[1]/4,b=[g,m],y=Bi(p,[0,0],b),w=Bi(p,[0,m],b),k=Bi(p,[0,2*m],b),v=Bi(p,[0,3*m],b),x=ni(oi(Ci(y),Pi(w)),oi(c,Ci(ni(a,k))));return[x,oi(Pi(x),Ci(v))]}});const Li=Ks({batchToSpaceND_:function(e,t,n){const r=Ls(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));a(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),a(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),a(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const o={x:r},i={blockShape:t,crops:n};return Ns.runKernel("BatchToSpaceND",o,i)}});const zi=Ks({batchNorm_:function(e,t,n,r,s,o){null==o&&(o=.001);const i=Ls(e,"x","batchNorm"),l=Ls(t,"mean","batchNorm"),u=Ls(n,"variance","batchNorm");let c,h;null!=s&&(c=Ls(s,"scale","batchNorm")),null!=r&&(h=Ls(r,"offset","batchNorm")),a(l.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),a(null==h||l.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),a(null==c||l.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const d=function(e){let t;return t=0===e.rank||1===e.rank?Ti(e,[1,1,1,e.size]):2===e.rank?Ti(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Ti(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),f={x:d,scale:c,offset:h,mean:l,variance:u},p={varianceEpsilon:o},g=Ns.runKernel("FusedBatchNorm",f,p);return Ti(g,i.shape)}});const Wi=Ks({batchNorm2d_:function(e,t,n,r,s,o){const i=Ls(e,"x","batchNorm"),l=Ls(t,"mean","batchNorm"),u=Ls(n,"variance","batchNorm");let c,h;return null!=s&&(c=Ls(s,"scale","batchNorm")),null!=r&&(h=Ls(r,"offset","batchNorm")),a(2===i.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`)),a(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${l.rank}.`)),a(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),zi(i,l,u,h,c,o)}});const Ki=Ks({batchNorm3d_:function(e,t,n,r,s,o){const i=Ls(e,"x","batchNorm"),l=Ls(t,"mean","batchNorm"),u=Ls(n,"variance","batchNorm");let c,h;return null!=s&&(c=Ls(s,"scale","batchNorm")),null!=r&&(h=Ls(r,"offset","batchNorm")),a(3===i.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`)),a(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${l.rank}.`)),a(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),zi(i,l,u,h,c,o)}});const Ui=Ks({batchNorm4d_:function(e,t,n,r,s,o){const i=Ls(e,"x","batchNorm"),l=Ls(t,"mean","batchNorm"),u=Ls(n,"variance","batchNorm");let c,h;return null!=s&&(c=Ls(s,"scale","batchNorm")),null!=r&&(h=Ls(r,"offset","batchNorm")),a(4===i.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`)),a(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${l.rank}.`)),a(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),zi(i,l,u,h,c,o)}});const qi=Ks({bincount_:function(e,t,n){const r=Ls(e,"x","bincount"),s=Ls(t,"weights","bincount");a("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),a(n>=0,(()=>`size must be non-negative, but got ${n}.`)),a(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const o={x:r,weights:s},i={size:n};return Ns.runKernel("Bincount",o,i)}});const Gi=Ks({broadcastArgs_:function(e,t){const n=Ls(e,"s0","broadcastArgs","int32"),r=Ls(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return Ns.runKernel("BroadcastArgs",s)}});const Hi=Ks({broadcastTo_:function(e,t){let n=Ls(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Ti(n,e)}const s=n.shape,o=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])o[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===o.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return To(n);const a={x:n},i={reps:o};return Ns.runKernel("Tile",a,i)}});const Vi=Ks({ceil_:function(e){const t={x:Ls(e,"x","ceil","float32")};return Ns.runKernel("Ceil",t)}});const ji=Ks({clipByValue_:function(e,t,n){const r=Ls(e,"x","clipByValue");a(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},o={clipValueMin:t,clipValueMax:n};return Ns.runKernel("ClipByValue",s,o)}});const Ji=Ks({concat1d_:function(e){return Fi(e,0)}});const Zi=Ks({concat2d_:function(e,t){return Fi(e,t)}});const Yi=Ks({concat3d_:function(e,t){return Fi(e,t)}});const Xi=Ks({concat4d_:function(e,t){return Fi(e,t)}});const Qi=Ks({conv2d_:function(e,t,n,r,s="NHWC",o=[1,1],i){const l=Ls(e,"x","conv2d","float32"),u=Ls(t,"filter","conv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=Ti(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),a(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),Ni("conv2d",r,i);const d="NHWC"===s?c.shape[3]:c.shape[1];a(d===u.shape[2],(()=>`Error in conv2d: depth of input (${d}) must match input depth for filter ${u.shape[2]}.`)),a(Ii(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const f={x:c,filter:u},p={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i},g=Ns.runKernel("Conv2D",f,p);return h?Ti(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const el=Ks({conv1d_:function(e,t,n,r,s="NWC",o=1,i){const l=Ls(e,"x","conv1d"),u=Ls(t,"filter","conv1d");let c=l,h=!1;2===l.rank&&(h=!0,c=Ti(l,[1,l.shape[0],l.shape[1]])),a(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),a(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),Ni("conv1d",r,i),a(c.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),a(Ii(n,o),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${o}'`)),a("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const d=Ti(u,[1,u.shape[0],u.shape[1],u.shape[2]]),f=Ti(c,[c.shape[0],1,c.shape[1],c.shape[2]]),p=Qi(f,d,[1,n],r,"NHWC",[1,o],i);return Ti(p,h?[p.shape[2],p.shape[3]]:[p.shape[0],p.shape[2],p.shape[3]])}});const tl=Ks({conv2DBackpropInput_:function(e,t,n,r,s,o="NHWC",i){a(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let l=e,u=t,c=!1;3===t.rank&&(c=!0,u=Ti(t,[1,t.shape[0],t.shape[1],t.shape[2]]),l=[1,e[0],e[1],e[2]]),a(4===l.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${l.length}.`)),a(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),a(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===o?l[3]:l[1],d="NHWC"===o?u.shape[3]:u.shape[1];a(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),a(d===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${d}) must match output depth for filter ${n.shape[3]}.`)),Ni("conv2dDerInput",s,i);const f={dy:u,filter:n},p={strides:r,pad:s,dataFormat:o,dimRoundingMode:i,inputShape:l},g=Ns.runKernel("Conv2DBackpropInput",f,p);return c?Ti(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const nl=Ks({conv2dTranspose_:function(e,t,n,r,s,o){const a=Ls(e,"x","conv2dTranspose"),i=Ls(t,"filter","conv2dTranspose");return tl(n,a,i,r,s,"NHWC",o)}});const rl=Ks({conv3d_:function(e,t,n,r,s="NDHWC",o=[1,1,1]){const i=Ls(e,"x","conv3d"),l=Ls(t,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=Ti(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),a(5===l.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${l.rank}.`)),a(u.shape[4]===l.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${l.shape[3]}.`)),a(Ii(n,o),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),a("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const h={x:u,filter:l},d={strides:n,pad:r,dataFormat:s,dilations:o},f=Ns.runKernel("Conv3D",h,d);return c?Ti(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const sl=Ks({conv3DBackpropInput_:function(e,t,n,r,s){a(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,i=t,l=!1;4===t.rank&&(l=!0,i=Ti(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),o=[1,e[0],e[1],e[2],e[3]]);const u=o[4],c=i.shape[4];a(5===o.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${o.length}.`)),a(5===i.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`)),a(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),a(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),a(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:i,filter:n},d={pad:s,strides:r,inputShape:o},f=Ns.runKernel("Conv3DBackpropInputV2",h,d);return l?Ti(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const ol=Ks({conv3dTranspose_:function(e,t,n,r,s){const o=Ls(e,"x","conv3dTranspose"),a=Ls(t,"filter","conv3dTranspose");return sl(n,o,a,r,s)}});const al=Ks({cos_:function(e){const t={x:Ls(e,"x","cos","float32")};return Ns.runKernel("Cos",t)}});const il=Ks({cosh_:function(e){const t={x:Ls(e,"x","cosh","float32")};return Ns.runKernel("Cosh",t)}});const ll=Ks({cumprod_:function(e,t=0,n=!1,r=!1){const s={x:Ls(e,"x","cumprod")},o={axis:t,exclusive:n,reverse:r};return Ns.runKernel("Cumprod",s,o)}});const ul=Ks({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Ls(e,"x","cumsum")},o={axis:t,exclusive:n,reverse:r};return Ns.runKernel("Cumsum",s,o)}});const cl=Ks({denseBincount_:function(e,t,n,r=!1){const s=Ls(e,"x","denseBincount"),o=Ls(t,"weights","denseBincount");a("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),a(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),a(n>=0,(()=>`size must be non-negative, but got ${n}.`)),a(o.size===s.size||0===o.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${o.shape}.`));const i={x:s,weights:o},l={size:n,binaryOutput:r};return Ns.runKernel("DenseBincount",i,l)}});const hl=Ks({depthToSpace_:function(e,t,n="NHWC"){const r=Ls(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],o="NHWC"===n?r.shape[2]:r.shape[3],i="NHWC"===n?r.shape[3]:r.shape[1];a(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),a(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),a(o*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${o} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),a(i%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${r.shape}`));const l={x:r},u={blockSize:t,dataFormat:n};return Ns.runKernel("DepthToSpace",l,u)}});const dl=Ks({depthwiseConv2d_:function(e,t,n,r,s="NHWC",o=[1,1],i){const l=Ls(e,"x","depthwiseConv2d","float32"),u=Ls(t,"filter","depthwiseConv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=Ti(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),a(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`));const d="NHWC"===s?c.shape[3]:c.shape[1];a(d===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${d}) must match the inChannels dimension in filter ${u.shape[2]}.`)),Ni("depthwiseConv2d",r,i);const f={x:c,filter:u},p={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i},g=Ns.runKernel("DepthwiseConv2dNative",f,p);return h?Ti(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const fl=Ks({diag_:function(e){const t={x:Ls(e,"x","diag")};return Ns.runKernel("Diag",t)}});const pl=Ks({dilation2d_:function(e,t,n,r,s=[1,1],o="NHWC"){const i=Ls(e,"x","dilation2d"),l=Ls(t,"filter","dilation2d");a(3===i.rank||4===i.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`)),a(3===l.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${l.rank}.`)),a("NHWC"===o,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${o}`));let u=i,c=!1;3===i.rank&&(u=Ti(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:l},d={strides:n,pad:r,dilations:s},f=Ns.runKernel("Dilation2D",h,d);return c?Ti(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});const gl=Ks({equal_:function(e,t){let n=Ls(e,"a","equal","string_or_numeric"),r=Ls(t,"b","equal","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("Equal",s)}});const ml=Ks({where_:function(e,t,n){const r=Ls(t,"a","where"),s=Ls(n,"b","where"),o=Ls(e,"condition","where","bool"),a=Sa(Sa(o.shape,r.shape),s.shape),i={condition:Hi(o,a),t:Hi(r,a),e:Hi(s,a)};return Ns.runKernel("Select",i)}});const bl=Ks({zerosLike_:function(e){const t={x:Ls(e,"x","zerosLike")};return Ns.runKernel("ZerosLike",t)}});const yl=Ks({divNoNan_:function(e,t){let n=Ls(e,"a","div"),r=Ls(t,"b","div");[n,r]=vs(n,r);const s=si(n,r),o=bl(s),a=gl(r,o);return ml(a,o,s)}});const wl=Ks({dot_:function(e,t){const n=Ls(e,"t1","dot"),r=Ls(t,"t2","dot");a(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],o=1===r.rank?r.size:r.shape[0];if(a(s===o,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${o}.`)),1===n.rank&&1===r.rank){const e=Ti(n,[1,-1]),t=Ti(r,[-1,1]),s=jo(e,t);return Ti(s,[])}if(1===n.rank&&2===r.rank){const e=Ti(n,[1,-1]),t=Ti(r,[r.shape[0],r.shape[1]]),s=jo(e,t);return Ti(s,[s.size])}if(2===n.rank&&1===r.rank){const e=Ti(r,[-1,1]),t=jo(n,e);return Ti(t,[t.size])}{const e=Ti(r,[r.shape[0],r.shape[1]]);return jo(n,e)}}});const kl=Ks({einsum_:function(e,...t){const n=t.map(((e,t)=>Ls(e,`tensors${t}`,"einsum"))),r={equation:e};return Ns.runKernel("Einsum",n,r)}});const vl=Ks({elu_:function(e){const t={x:Ls(e,"x","elu","float32")};return Ns.runKernel("Elu",t)}});const xl=Ks({erf_:function(e){let t=Ls(e,"x","erf");a("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=No(t,"float32"));const n={x:t};return Ns.runKernel("Erf",n)}});function El(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function Sl(e,t,n){const r=e.length+t.length,s=[];let o=0,a=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[o++]):s.push(t[a++]);return s}function $l(e,t){return Sl(e,t.map((e=>1)),t)}const Al=Ks({max_:function(e,t=null,n=!1){const r={x:Ls(e,"x","max")},s={reductionIndices:t,keepDims:n};return Ns.runKernel("Max",r,s)}});const _l=Ks({min_:function(e,t=null,n=!1){const r={x:Ls(e,"x","min")},s={axis:t,keepDims:n};return Ns.runKernel("Min",r,s)}});const Il=Ks({pow_:function(e,t){let n=Ls(e,"base","pow"),r=Ls(t,"exp","pow");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Pow",s)}});function Ml(e,t){if((k(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&k(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return qs(e,[],[],t)}const Nl=Ks({sqrt_:function(e){const t={x:Ls(e,"x","sqrt","float32")};return Ns.runKernel("Sqrt",t)}});const Tl=Ks({square_:function(e){const t=Ls(e,"x","square");return Ns.runKernel("Square",{x:t},{})}});const Dl=Ks({sum_:function(e,t=null,n=!1){let r=Ls(e,"x","sum");"bool"===r.dtype&&(r=No(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return Ns.runKernel("Sum",s,o)}});function Rl(e,t,n=null){if(0===e.rank)return ai(e);if(1!==e.rank&&null===n)return Rl(Ti(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Dl(ai(e),n);if(t===1/0)return Al(ai(e),n);if(t===-1/0)return _l(ai(e),n);if("euclidean"===t||2===t)return Nl(Dl(Il(ai(e),Ml(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return Al(Dl(ai(e),n[0]),n[1]-1);if(t===1/0)return Al(Dl(ai(e),n[1]),n[0]);if(t===-1/0)return _l(Dl(ai(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Nl(Dl(Tl(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Fl=Ks({norm_:function(e,t="euclidean",n=null,r=!1){const s=Rl(e=Ls(e,"x","norm"),t,n);let o=s.shape;if(r){const t=p(n,e.shape);o=$l(s.shape,t)}return Ti(s,o)}});const Cl=Ks({euclideanNorm_:function(e,t=null,n=!1){return Fl(e,"euclidean",t,n)}});const Bl=Ks({exp_:function(e){const t={x:Ls(e,"x","exp")};return Ns.runKernel("Exp",t)}});const Pl=Ks({expandDims_:function(e,t=0){const n=Ls(e,"x","expandDims","string_or_numeric");a(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return Ns.runKernel("ExpandDims",r,s)}});const Ol=Ks({expm1_:function(e){const t={x:Ls(e,"x","expm1")};return Ns.runKernel("Expm1",t)}});const Ll=Ks({tile_:function(e,t){const n=Ls(e,"x","tile","string_or_numeric");a(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return Ns.runKernel("Tile",r,s)}});const zl=Ks({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=Mo([e,t],r),o=e<=t?e:t;for(let e=0;e<o;++e)s.set(1,e,e);const a=Ti(s.toTensor(),[e,t]);if(null==n)return a;if(1===n.length)return Ll(Pl(a,0),[n[0],1,1]);if(2===n.length)return Ll(Pl(Pl(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return Ll(Pl(Pl(Pl(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Wl(e,t,n){const r={shape:e,value:t,dtype:n};return Ns.runKernel("Fill",{},r)}const Kl=Ks({floor_:function(e){const t={x:Ls(e,"x","floor","float32")};return Ns.runKernel("Floor",t)}});const Ul=Ks({gather_:function(e,t,n=0,r=0){const s={x:Ls(e,"x","gather"),indices:Ls(t,"indices","gather","int32")},o={axis:n,batchDims:r};return Ns.runKernel("GatherV2",s,o)}});const ql=Ks({greater_:function(e,t){let n=Ls(e,"a","greater","string_or_numeric"),r=Ls(t,"b","greater","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("Greater",s)}});const Gl=Ks({greaterEqual_:function(e,t){let n=Ls(e,"a","greaterEqual","string_or_numeric"),r=Ls(t,"b","greaterEqual","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("GreaterEqual",s)}});const Hl=Ks({isFinite_:function(e){const t={x:Ls(e,"x","isFinite")};return Ns.runKernel("IsFinite",t)}});const Vl=Ks({isInf_:function(e){const t={x:Ls(e,"x","isInf")};return Ns.runKernel("IsInf",t)}});const jl=Ks({isNaN_:function(e){const t={x:Ls(e,"x","isNaN")};return Ns.runKernel("IsNan",t)}});const Jl=Ks({leakyRelu_:function(e,t=.2){const n={x:Ls(e,"x","leakyRelu")},r={alpha:t};return Ns.runKernel("LeakyRelu",n,r)}});const Zl=Ks({less_:function(e,t){let n=Ls(e,"a","less","string_or_numeric"),r=Ls(t,"b","less","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("Less",s)}});const Yl=Ks({lessEqual_:function(e,t){let n=Ls(e,"a","lessEqual","string_or_numeric"),r=Ls(t,"b","lessEqual","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("LessEqual",s)}});function Xl(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return Ns.runKernel("LinSpace",{},r)}const Ql=Ks({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const o=Ls(e,"x","localResponseNormalization");a(4===o.rank||3===o.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${o.rank}.`)),a(d(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let i=o,l=!1;3===o.rank&&(l=!0,i=Ti(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const u={x:i},c={depthRadius:t,bias:n,alpha:r,beta:s},h=Ns.runKernel("LRN",u,c);return l?Ti(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const eu=Ks({log_:function(e){const t={x:Ls(e,"x","log","float32")};return Ns.runKernel("Log",t)}});const tu=Ks({log1p_:function(e){const t={x:Ls(e,"x","log1p")};return Ns.runKernel("Log1p",t)}});function nu(e){return a(_(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const r=Ls(t,"x","tf.grad","string_or_numeric"),s=null!=n?Ls(n,"dy","tf.grad"):null;return Ns.tidy((()=>{const{value:t,grads:n}=Ns.gradients((()=>e(r)),[r],s);return null!=s&&i(t.shape,s.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),lu(n),n[0]}))}}function ru(e){return a(_(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{a(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const r=zs(t,"args","tf.grads","string_or_numeric"),s=null!=n?Ls(n,"dy","tf.grads"):null;return Ns.tidy((()=>{const{value:t,grads:n}=Ns.gradients((()=>e(...r)),r,s);return null!=s&&i(t.shape,s.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),lu(n),n}))}}function su(e){return a(_(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{a(t instanceof hs,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),a(null==n||n instanceof hs,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:r,value:s}=Ns.gradients((()=>e(t)),[t],n);return lu(r),{grad:r[0],value:s}}}function ou(e){return a(_(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{a(Array.isArray(t)&&t.every((e=>e instanceof hs)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),a(null==n||n instanceof hs,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const r=Ns.gradients((()=>e(...t)),t,n);return null!=n&&i(r.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),lu(r.grads),r}}function au(e,t){a(_(e),(()=>"The f passed in variableGrads(f) must be a function")),a(null==t||Array.isArray(t)&&t.every((e=>e instanceof ds)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in Ns.registeredVariables)t.push(Ns.registeredVariables[e])}const r=n?t.filter((e=>!e.trainable)):null,s=t.length;t=t.filter((e=>e.trainable)),a(t.length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${s} variables is trainable.`));const{value:o,grads:i}=Ns.gradients(e,t,null,!0);a(i.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),a(0===o.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${o.rank} tensor`));const l={};return t.forEach(((e,t)=>{null!=i[t]&&(l[e.name]=i[t])})),null!=r&&r.forEach((e=>l[e.name]=null)),{value:o,grads:l}}function iu(e){return Ns.customGrad(e)}function lu(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const uu=Ks({softplus_:function(e){const t={x:Ls(e,"x","softplus")};return Ns.runKernel("Softplus",t)}});const cu=Ks({logSigmoid_:function(e){const t=Ls(e,"x","logSigmoid"),n=iu((e=>({value:ya(uu(ya(e))),gradFunc:t=>oi(t,Ci(ya(e)))})));return n(t)}});const hu=Ks({sub_:function(e,t){let n=Ls(e,"a","sub"),r=Ls(t,"b","sub");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Sub",s)}});const du=Ks({logSoftmax_:function(e,t=-1){const n=Ls(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const r=iu(((e,n)=>{const r=Al(e,t,!0),s=hu(e,r),o=hu(No(s,"float32"),eu(Dl(Bl(s),t,!0)));n([o]);return{value:o,gradFunc:(e,n)=>{const[r]=n,s=Bl(r);return hu(e,oi(Dl(e,t,!0),s))}}}));return r(n)}});const fu=Ks({logSumExp_:function(e,t=null,n=!1){const r=Ls(e,"x","logSumExp"),s=p(t,r.shape),o=Al(r,s,!0),a=hu(r,o),i=Bl(a),l=Dl(i,s),u=eu(l),c=ni(Ti(o,u.shape),u);if(n){const e=$l(c.shape,s);return Ti(c,e)}return c}});const pu=Ks({logicalAnd_:function(e,t){const n=Ls(e,"a","logicalAnd","bool"),r=Ls(t,"b","logicalAnd","bool");Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("LogicalAnd",s)}});const gu=Ks({logicalNot_:function(e){const t={x:Ls(e,"x","logicalNot","bool")};return Ns.runKernel("LogicalNot",t)}});const mu=Ks({logicalOr_:function(e,t){const n=Ls(e,"a","logicalOr","bool"),r=Ls(t,"b","logicalOr","bool");Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("LogicalOr",s)}});const bu=Ks({logicalXor_:function(e,t){const n=Ls(e,"a","logicalXor","bool"),r=Ls(t,"b","logicalXor","bool");return Sa(n.shape,r.shape),pu(mu(e,t),gu(pu(e,t)))}});const yu=Ks({searchSorted_:function(e,t,n="left"){const r=Ls(e,"sortedSequence","searchSorted"),s=Ls(t,"values","searchSorted"),o=r.shape[r.shape.length-1],a=s.shape[s.shape.length-1],i=Ti(r,[-1,o]),l=Ti(s,[-1,a]);if(i.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(i.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(c(l.shape)>=2147483648)throw new Error("values tensor size must less than 2147483648");if(i.shape[1]>=2147483648)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${i.shape[1]}`);const u={sortedSequence:i,values:l},h={side:n};return Ns.runKernel("SearchSorted",u,h)}});function wu(e,t){return yu(e,t,"left")}const ku=Ks({maxPool_:function(e,t,n,r,s){const o=Ls(e,"x","maxPool");let i=o,l=!1;3===o.rank&&(l=!0,i=Ti(o,[1,o.shape[0],o.shape[1],o.shape[2]])),a(4===i.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`)),a(Ii(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Ni("maxPool",r,s);const u={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s},h=Ns.runKernel("MaxPool",u,c);return l?Ti(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const vu=Ks({maxPool3d_:function(e,t=[1,1,1],n,r,s,o="NDHWC"){const i=Ls(e,"x","maxPool3d");let l=i,u=!1;4===i.rank&&(u=!0,l=Ti(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===l.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${l.rank}.`)),a("NDHWC"===o,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Ni("maxPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o},d=Ns.runKernel("MaxPool3D",c,h);return u?Ti(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const xu=Ks({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const o={x:Ls(e,"x","maxPoolWithArgmax")},a={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=Ns.runKernel("MaxPoolWithArgmax",o,a);return{result:i[0],indexes:i[1]}}});const Eu=Ks({maximum_:function(e,t){let n=Ls(e,"a","maximum"),r=Ls(t,"b","maximum");[n,r]=vs(n,r),"bool"===n.dtype&&(n=No(n,"int32"),r=No(r,"int32")),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("Maximum",s)}});const Su=Ks({mean_:function(e,t=null,n=!1){const r={x:Ls(e,"x","mean")},s={axis:t,keepDims:n};return Ns.runKernel("Mean",r,s)}});function $u(e,t="float32"){if("complex64"===t){const t=$u(e,"float32"),n=$u(e,"float32");return Us(t,n)}const n=R(c(e),t);return Ns.makeTensor(n,e,t)}function Au(e,t="float32"){if("complex64"===t){const t=Au(e,"float32"),n=$u(e,"float32");return Us(t,n)}const n=D(c(e),t);return Ns.makeTensor(n,e,t)}function _u(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Ls(e,"x","meshgrid",e instanceof hs?e.dtype:"float32");if(void 0===t)return[r];let s=Ls(t,"y","meshgrid",t instanceof hs?t.dtype:"float32");const o=c(r.shape),a=c(s.shape);return"xy"===n?(r=Ti(r,[1,-1]),s=Ti(s,[-1,1]),[jo(Au([a,1],r.dtype),r),jo(s,Au([1,o],s.dtype))]):(r=Ti(r,[-1,1]),s=Ti(s,[1,-1]),[jo(r,Au([1,a],r.dtype)),jo(Au([o,1],s.dtype),s)])}const Iu=Ks({minimum_:function(e,t){let n=Ls(e,"a","minimum"),r=Ls(t,"b","minimum");[n,r]=vs(n,r),"bool"===n.dtype&&(n=No(n,"int32"),r=No(r,"int32")),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("Minimum",s)}});const Mu=Ks({mirrorPad_:function(e,t,n){a("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Ls(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");a(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)a(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),a(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const o={paddings:t,mode:n},i={x:r};return Ns.runKernel("MirrorPad",i,o)}});const Nu=Ks({mod_:function(e,t){let n=Ls(e,"a","mod"),r=Ls(t,"b","mod");[n,r]=vs(n,r);const s={a:n,b:r};return Ns.runKernel("Mod",s)}});const Tu=Ks({moments_:function(e,t=null,n=!1){const r=p(t,(e=Ls(e,"x","moments")).shape),s=Su(e,r,n);let o=s.shape;n||(o=$l(s.shape,r));const a=Tl(hu(No(e,"float32"),Ti(s,o)));return{mean:s,variance:Su(a,r,n)}}});const Du=Ks({multiRNNCell_:function(e,t,n,r){const s=Ls(t,"data","multiRNNCell"),o=zs(n,"c","multiRNNCell"),a=zs(r,"h","multiRNNCell");let i=s;const l=[];for(let t=0;t<e.length;t++){const n=e[t](i,o[t],a[t]);l.push(n[0]),l.push(n[1]),i=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const Ru=Ks({multinomial_:function(e,t,n,r=!1){const s=Ls(e,"logits","multinomial"),o=s.size,a=s.rank;if(o<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${o}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const i={logits:1===a?Ti(s,[1,-1]):s},l={numSamples:t,seed:n,normalized:r},u=Ns.runKernel("Multinomial",i,l);return 1===a?Ti(u,[u.size]):u}});const Fu=Ks({notEqual_:function(e,t){let n=Ls(e,"a","notEqual","string_or_numeric"),r=Ls(t,"b","notEqual","string_or_numeric");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("NotEqual",s)}});const Cu=Ks({onesLike_:function(e){const t={x:Ls(e,"x","onesLike")};return Ns.runKernel("OnesLike",t)}});const Bu=Ks({outerProduct_:function(e,t){const n=Ls(e,"v1","outerProduct"),r=Ls(t,"v2","outerProduct");a(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=Ti(n,[-1,1]),o=Ti(r,[1,-1]);return jo(s,o)}});const Pu=Ks({pad_:function(e,t,n=0){const r=Ls(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},o={x:r};return Ns.runKernel("PadV2",o,s)}});const Ou=Ks({pad1d_:function(e,t,n=0){return a(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),Pu(e,[t],n)}});const Lu=Ks({pad2d_:function(e,t,n=0){return a(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Pu(e,t,n)}});const zu=Ks({pad3d_:function(e,t,n=0){return a(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Pu(e,t,n)}});const Wu=Ks({pad4d_:function(e,t,n=0){return a(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Pu(e,t,n)}});const Ku=Ks({spaceToBatchND_:function(e,t,n){const r=Ls(e,"x","spaceToBatchND");a(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),a(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),a(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},o={blockShape:t,paddings:n};return Ns.runKernel("SpaceToBatchND",s,o)}});const Uu=Ks({pool_:function(e,t,n,r,s,o,i){null==s&&(s=[1,1]),null==o&&(o=1),0===r&&(r="valid");const l=Ls(e,"x","maxPool");let u=l,c=!1;3===l.rank&&(c=!0,u=Ti(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(Ii(o,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${o} and dilations '${s}'`));const h=wi(u.shape,t,o,s,r),d=[h.dilationHeight,h.dilationWidth];let f;f="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([h.filterHeight,h.filterWidth],d):[[0,0],[0,0]];const p=1===d[0]&&1===d[1],[g,m]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),o=e.concat(r,s),a=t.map(((e,t)=>(e-o[t]%e)%e)),i=s.map(((e,t)=>e+a[t])),l=t.map(((e,t)=>[r[t],i[t]])),u=t.map(((e,t)=>[0,a[t]]));return[l,u]}([h.inHeight,h.inWidth],d,f),b=p?r:"valid",y=p?u:Ku(u,d,g),w=("avg"===n?()=>Di(y,t,o,b,i):()=>ku(y,t,o,b,i))(),k=p?w:Li(w,d,m);return c?Ti(k,[k.shape[1],k.shape[2],k.shape[3]]):k}});const qu=Ks({prelu_:function(e,t){const n={x:Ls(e,"x","prelu"),alpha:Ls(t,"alpha","prelu")};return Ns.runKernel("Prelu",n)}});const Gu=Ks({prod_:function(e,t=null,n=!1){let r=Ls(e,"x","prod");"bool"===r.dtype&&(r=No(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return Ns.runKernel("Prod",s,o)}});const Hu=Ks({rand_:function(e,t,n){const r=c(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return Ns.makeTensor(s,e,n)}});var Vu="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function ju(e){var t={exports:{}};return e(t,t.exports),t.exports}var Ju=ju((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function o(e,t){var n=new r(e),o=t&&t.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.alea=o}(0,e,!1)})),Zu=ju((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor128=o}(0,e,!1)})),Yu=ju((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorwow=o}(0,e,!1)})),Xu=ju((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.x&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorshift7=o}(0,e,!1)})),Qu=ju((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,o=t.i;return t.w=r=r+1640531527|0,n=s[o+34&127],e=s[o=o+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[o]=n^e,t.i=o,n+(r^r>>>16)|0},function(e,t){var n,r,s,o,a,i=[],l=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,l=Math.max(l,t.length)),s=0,o=-32;o<l;++o)t&&(r^=t.charCodeAt((o+32)%t.length)),0===o&&(a=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,o>=0&&(a=a+1640531527|0,s=0==(n=i[127&o]^=r+a)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,o=512;o>0;--o)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=a,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.X&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor4096=o}(0,e,!1)})),ec=ju((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.tychei=o}(0,e,!1)})),tc=ju((function(e){!function(t,n,r){var s,o=256,a=r.pow(o,6),i=r.pow(2,52),l=2*i,u=255;function c(e,u,c){var m=[],b=p(f((u=1==u?{entropy:!0}:u||{}).entropy?[e,g(n)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(o):(e=new Uint8Array(o),(t.crypto||t.msCrypto).getRandomValues(e)),g(e)}catch(e){var r=t.navigator,a=r&&r.plugins;return[+new Date,t,a,t.screen,g(n)]}}():e,3),m),y=new h(m),w=function(){for(var e=y.g(6),t=a,n=0;e<i;)e=(e+n)*o,t*=o,n=y.g(1);for(;e>=l;)e/=2,t/=2,n>>>=1;return(e+n)/t};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,p(g(y.S),n),(u.pass||c||function(e,t,n,s){return s&&(s.S&&d(s,y),e.state=function(){return d(y,{})}),n?(r.random=e,t):e})(w,b,"global"in u?u.global:this==r,u.state)}function h(e){var t,n=e.length,r=this,s=0,a=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<o;)i[s]=s++;for(s=0;s<o;s++)i[s]=i[a=u&a+e[s%n]+(t=i[s])],i[a]=t;(r.g=function(e){for(var t,n=0,s=r.i,a=r.j,i=r.S;e--;)t=i[s=u&s+1],n=n*o+i[u&(i[s]=i[a=u&a+t])+(i[a]=t)];return r.i=s,r.j=a,n})(o)}function d(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function f(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(f(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function p(e,t){for(var n,r=e+"",s=0;s<r.length;)t[u&s]=u&(n^=19*t[u&s])+r.charCodeAt(s++);return g(t)}function g(e){return String.fromCharCode.apply(0,e)}if(p(r.random(),n),e.exports){e.exports=c;try{s=require("crypto")}catch(e){}}else r.seedrandom=c}("undefined"!=typeof self?self:Vu,[],Math)}));tc.alea=Ju,tc.xor128=Zu,tc.xorwow=Yu,tc.xorshift7=Xu,tc.xor4096=Qu,tc.tychei=ec;var nc=tc;class rc{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const o=s||Math.random();this.random=nc.alea(o.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,o;do{r=2*this.random()-1,s=2*this.random()-1,o=r*r+s*s}while(o>=1||0===o);const a=Math.sqrt(-2*Math.log(o)/o);e=this.mean+this.stdDev*r*a,t=this.mean+this.stdDev*s*a,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class sc{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=nc.alea(s.toString()),this.randn=new rc(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,o;for(;;){do{r=this.randn.nextValue(),o=1+this.c*r}while(o<=0);if(o*=o*o,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-o+Math.log(o)),s=this.randu(),s<t||Math.log(s)<n)break}return o=1/this.beta*this.d*o,this.alpha<1&&(o*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(o)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class oc{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=nc.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const ac=Ks({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const o=new sc(t,n,r,s),a=Mo(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const ic=Ks({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const o=new rc(t,n,r,!1,s),a=Mo(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const lc=Ks({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return ic(e,0,1,t,n)}});const uc=Ks({randomUniform_:function(e,t=0,n=1,r="float32",s){const o=Mo(e,r),a=new oc(t,n,null,s);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});function cc(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return Ns.runKernel("Range",{},s)}const hc=Ks({reciprocal_:function(e){const t={x:Ls(e,"x","reciprocal")};return Ns.runKernel("Reciprocal",t)}});const dc=Ks({relu_:function(e){const t={x:Ls(e,"x","relu")};return Ns.runKernel("Relu",t)}});const fc=Ks({relu6_:function(e){const t={x:Ls(e,"x","relu6")};return Ns.runKernel("Relu6",t)}});const pc=Ks({reverse_:function(e,t){const n={x:Ls(e,"x","reverse")},r={dims:t};return Ns.runKernel("Reverse",n,r)}});const gc=Ks({reverse1d_:function(e){const t=Ls(e,"x","reverse");return a(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),pc(t,0)}});const mc=Ks({reverse2d_:function(e,t){const n=Ls(e,"x","reverse");return a(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),pc(n,t)}});const bc=Ks({reverse3d_:function(e,t){const n=Ls(e,"x","reverse");return a(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),pc(n,t)}});const yc=Ks({reverse4d_:function(e,t){const n=Ls(e,"x","reverse");return a(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),pc(n,t)}});const wc=Ks({round_:function(e){const t={x:Ls(e,"x","round")};return Ns.runKernel("Round",t)}});const kc=Ks({rsqrt_:function(e){const t={x:Ls(e,"x","rsqrt","float32")};return Ns.runKernel("Rsqrt",t)}});const vc=Ks({selu_:function(e){const t={x:Ls(e,"x","selu")};return Ns.runKernel("Selu",t)}});const xc=Ks({separableConv2d_:function(e,t,n,r,s,o=[1,1],i="NHWC"){const l=Ls(e,"x","separableConv2d"),u=Ls(t,"depthwiseFilter","separableConv2d"),c=Ls(n,"pointwiseFilter","separableConv2d");let h=l,d=!1;if(3===l.rank&&(d=!0,h=Ti(l,[1,l.shape[0],l.shape[1],l.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");a(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),a(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),a(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),a(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),a(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const f=u.shape[2],p=u.shape[3];a(c.shape[2]===f*p,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${f*p}, but got ${c.shape[2]}.`));const g=dl(h,u,r,s,i,o),m=Qi(g,c,1,"valid",i);return d?Ti(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Ec=async function(e,t){const n=Ls(e,"x","setdiff1d"),r=Ls(t,"y","setdiff1d");a(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),a(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),a(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),o=await r.data(),i=new Set(o);let l=0;for(let e=0;e<s.length;e++)i.has(s[e])||l++;const u=new ls([l],n.dtype),c=new ls([l],"int32");for(let e=0,t=0;e<s.length;e++)i.has(s[e])||(u.values[t]=s[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const Sc=Ks({sign_:function(e){const t={x:Ls(e,"x","sign")};return Ns.runKernel("Sign",t)}});const $c=Ks({sin_:function(e){const t={x:Ls(e,"x","sin","float32")};return Ns.runKernel("Sin",t)}});const Ac=Ks({sinh_:function(e){const t={x:Ls(e,"x","sinh")};return Ns.runKernel("Sinh",t)}});const _c=Ks({slice1d_:function(e,t,n){const r=Ls(e,"x","slice1d");return a(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),Bi(r,[t],[n])}});const Ic=Ks({slice2d_:function(e,t,n){const r=Ls(e,"x","slice2d");return a(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),Bi(r,t,n)}});const Mc=Ks({slice3d_:function(e,t,n){const r=Ls(e,"x","slice3d");return a(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),Bi(r,t,n)}});const Nc=Ks({slice4d_:function(e,t,n){const r=Ls(e,"x","slice4d");return a(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),Bi(r,t,n)}});const Tc=Ks({softmax_:function(e,t=-1){const n=Ls(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return Ns.runKernel("Softmax",r,s)}});const Dc=Ks({fft_:function(e){a("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Ns.runKernel("FFT",t)}});const Rc=Ks({ifft_:function(e){a("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Ns.runKernel("IFFT",t)}});const Fc=Ks({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=Ti(e,[n,t]);r=Rc(s)}else{const s=[n,2*(t-1)],o=Ti(wa(e),[n,t]),a=Ti(ba(e),[n,t]),i=pc(Bi(o,[0,1],[n,t-2]),1),l=oi(pc(Bi(a,[0,1],[n,t-2]),1),Ml(-1)),u=Fi([o,i],1),c=Fi([a,l],1),h=Ti(Us(u,c),[s[0],s[1]]);r=Rc(h)}if(r=wa(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=Ti(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const Cc=Ks({split_:function(e,t,n=0){const r={x:Ls(e,"x","split")},s={numOrSizeSplits:t,axis:n};return Ns.runKernel("SplitV",r,s)}});const Bc=Ks({rfft_:function(e,t){a("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),o=e.shape.map((e=>e));o[e.shape.length-1]=t,s=Bi(e,r,o),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=Fi([e,$u(r)],e.shape.length-1),n=t}else s=e;const o=bl(s),i=Ti(Us(s,o),[r,n]),l=Dc(i),u=Math.floor(n/2)+1,c=wa(l),h=ba(l),d=Cc(c,[u,n-u],c.shape.length-1),f=Cc(h,[u,n-u],h.shape.length-1),p=s.shape.slice();return p[s.shape.length-1]=u,Ti(Us(d[0],f[0]),p)}});const Pc=Ks({squaredDifference_:function(e,t){let n=Ls(e,"a","squaredDifference"),r=Ls(t,"b","squaredDifference");[n,r]=vs(n,r),Sa(n.shape,r.shape);const s={a:n,b:r};return Ns.runKernel("SquaredDifference",s,{})}});const Oc=Ks({squeeze_:function(e,t){const n=Ls(e,"x","squeeze","string_or_numeric");return Ti(n,g(n.shape,t).newShape)}});const Lc=Ks({stack_:function(e,t=0){const n=zs(e,"tensors","stack","string_or_numeric");a(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&a(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return Ns.runKernel("Pack",r,s)}});const zc=Ks({step_:function(e,t=0){const n={x:Ls(e,"x","step")},r={alpha:t};return Ns.runKernel("Step",n,r)}});const Wc=Ks({stridedSlice_:function(e,t,n,r,s=0,o=0,a=0,i=0,l=0){const u={x:Ls(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:r,beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};return Ns.runKernel("StridedSlice",u,c)}});const Kc=Ks({tan_:function(e){const t={x:Ls(e,"x","tan","float32")};return Ns.runKernel("Tan",t)}});function Uc(e,t){l(e);const n=Bs(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return qs(e,null,n,t)}function qc(e,t,n){if(l(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Bs(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return qs(e,t,r,n)}function Gc(e,t,n){if(l(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Bs(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return qs(e,t,r,n)}function Hc(e,t,n){if(l(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Bs(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return qs(e,t,r,n)}function Vc(e,t,n){if(l(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Bs(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return qs(e,t=t||r,r,n)}const jc=Ks({topk_:function(e,t=1,n=!0){const r=Ls(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const o={x:r},a={k:t,sorted:n},[i,l]=Ns.runKernel("TopK",o,a);return{values:i,indices:l}}});const Jc=Ks({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const o=new rc(t,n,r,!0,s),a=Mo(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Zc=Ks({unique_:function(e,t=0){const n=Ls(e,"x","unique","string_or_numeric");a(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[o,i]=Ns.runKernel("Unique",r,s);return{values:o,indices:i}}});const Yc=Ks({unsortedSegmentSum_:function(e,t,n){const r=Ls(e,"x","unsortedSegmentSum"),s=Ls(t,"segmentIds","unsortedSegmentSum","int32");a(d(n),(()=>"numSegments must be of dtype int"));const o={x:r,segmentIds:s},i={numSegments:n};return Ns.runKernel("UnsortedSegmentSum",o,i)}});const Xc=Ks({unstack_:function(e,t=0){const n=Ls(e,"x","unstack","string_or_numeric");a(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return Ns.runKernel("Unpack",r,s)}});function Qc(e,t){return yu(e,t,"right")}function eh(e,t=!0,n,r){return Ns.makeVariable(e,t,n,r)}function th(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=Mo(e,"int32"),s=Mo([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const o=r.indexToLoc(n[t]),a=t*e.length;s.values.set(o,a)}return s.toTensor()}const nh=async function(e){const t=Ls(e,"condition","whereAsync","bool"),n=await t.data(),r=th(t.shape,n);return e!==t&&t.dispose(),r};const rh=async function(e,t,n){const r=Ls(e,"tensor","boolMask"),s=Ls(t,"mask","boolMask","bool"),o=null==n?0:n,l=s.rank,u=r.shape;a(l>0,(()=>"mask cannot be scalar")),i(u.slice(o,o+l),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=o;e<o+l;e++)c*=u[e];const h=u.slice(0,o).concat([c],u.slice(o+l)),d=Ti(r,h),f=Ti(s,[-1]),p=await nh(f),g=Oc(p,[1]),m=Ul(d,g,o);return e!==r&&r.dispose(),t!==s&&s.dispose(),g.dispose(),d.dispose(),f.dispose(),p.dispose(),m};const sh=Ks({movingAverage_:function(e,t,n,r,s=!0){const o=Ls(e,"v","movingAverage"),i=Ls(t,"x","movingAverage"),l=Ls(n,"decay","movingAverage");xs(o,i),a(h(o.shape,i.shape),(()=>"Shape mismatch in v and x"));const u=Ml(1),c=hu(u,l);let d=oi(hu(i,o),c);if(s){a(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Ls(r,"step","movingAverage");d=si(d,hu(u,Il(l,e)))}return ni(o,d)}});const oh=Ks({scatterND_:function(e,t,n){const r=Ls(e,"indices","scatterND","int32"),s=Ls(t,"updates","scatterND");Fa(s,r,n);const o={indices:r,updates:s},a={shape:n};return Ns.runKernel("ScatterNd",o,a)}});const ah=Ks({sparseToDense_:function(e,t,n,r=0){const s=Ls(e,"sparseIndices","sparseToDense","int32"),o=Ls(t,"sparseValues","sparseToDense","string_or_numeric"),a=Ls(r,"defaultValue","sparseToDense",o.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,o=e.rank>1?e.shape[1]:1;if(n.length!==o)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${o}.`);const a=t.size;if(0!==t.rank&&(1!==t.rank||a!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,o,n,a);const i={sparseIndices:s,sparseValues:o,defaultValue:a},l={outputShape:n};return Ns.runKernel("SparseToDense",i,l)}});const ih=Ks({gatherND_:function(e,t){const n=Ls(t,"indices","gatherND","int32"),r={params:Ls(e,"x","gatherND","string_or_numeric"),indices:n};return Ns.runKernel("GatherNd",r)}});const lh=Ks({dropout_:function(e,t,n,r){const s=Ls(e,"x","dropout");if(a("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),a(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof hs?s.clone():s;const o=function(e,t){if(null==t)return e.shape.slice();if(h(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),i=1-t,l=si(Kl(ni(uc(o,0,1,"float32",r),i)),i);return oi(s,l)}});function uh(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function ch(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let o=0;o<e;++o){const a=2*Math.PI*o/(e+r-1);s[o]=t-n*Math.cos(a)}return Uc(s,"float32")}const hh=async function(e,t,n=1){const r=Ls(e,"predictions","inTopK"),s=Ls(t,"targets","inTopK");a(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),a(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),i(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const o=r.shape[r.shape.length-1];a(n>0&&n<=o,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${o}), but got ${n}`));const l=await r.data(),u=await s.data(),[c,h]=[l.length/o,o],d=m("bool",c);for(let e=0;e<c;e++){const t=e*h,r=l.subarray(t,t+h),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),d[e]=0;for(let t=0;t<n;t++)if(s[t].index===u[e]){d[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),Gs(d,s.shape,"bool")};const dh=Ks({conv2DBackpropFilter_:function(e,t,n,r,s,o="NHWC",i){let l=e;3===e.rank&&(l=Ti(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=Ti(t,[1,t.shape[0],t.shape[1],t.shape[2]])),a(4===l.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${l.shape}.`)),a(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),a(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===o?l.shape[3]:l.shape[1],h="NHWC"===o?u.shape[3]:u.shape[1];a(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),a(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),Ni("conv2dDerFilter",s,i);const d={x:l,dy:u},f={strides:r,pad:s,dataFormat:o,dimRoundingMode:i,filterShape:n};return Ns.runKernel("Conv2DBackpropFilter",d,f)}});function fh(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return oi(e,zc(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function ph(e,t){let n=t;const r=Ea(e.shape,t.shape);return r.length>0&&(n=Dl(n,r)),Ti(n,e.shape)}function gh(e,t,n,r){if("linear"===t)return e;if("relu"===t)return dc(e);if("elu"===t)return vl(e);if("relu6"===t)return fc(e);if("prelu"===t)return qu(e,n);if("leakyrelu"===t)return Jl(e,r);if("sigmoid"===t)return Ci(e);throw new Error(`Unknown fused activation ${t}.`)}const mh=(e,t)=>!(e>0)||"linear"===t;const bh=Ks({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===mh(Ns.state.gradientDepth,u)){a("NHWC"===s,(()=>`Error in fused conv2d: got dataFormat of ${s} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let d=Qi(e,t,n,r,s,o,i);return null!=l&&(d=ni(d,l)),gh(d,u,c,h)}const d=Ls(e,"x","conv2d","float32"),f=Ls(t,"filter","conv2d","float32");let p=d,g=!1;3===d.rank&&(g=!0,p=Ti(d,[1,d.shape[0],d.shape[1],d.shape[2]])),a(4===p.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${p.rank}.`)),a(4===f.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${f.rank}.`)),Ni("fused conv2d",r,i);const m="NHWC"===s?p.shape[3]:p.shape[1];a(f.shape[2]===m,(()=>`Error in conv2d: depth of input (${m}) must match input depth for filter ${f.shape[2]}.`)),a(Ii(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const b=ki(p.shape,f.shape,n,o,r,i);let y,w;if(null!=l&&(y=Ls(l,"bias","fused conv2d"),[y]=vs(y,d),"NHWC"===s?Sa(b.outShape,y.shape):(a(y.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${y.shape.length}.`)),a(0===y.shape.length||y.shape[0]===b.outChannels||1===y.shape[0],(()=>`Error in fused conv2d: bias shape (${y.shape}) is not compatible with the number of output channels (${b.outChannels})`)))),null!=c){const e=c.shape;if(a(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)a(1===e[0]||e[0]===b.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${b.outChannels}).`));else if(3===e.length)try{Sa(e,b.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${b.outShape}).`;throw Error(n)}w=Ls(c,"prelu weights","fused conv2d")}const k=(e,t)=>{a("NHWC"===s,(()=>`Error in gradient of fused conv2D: got dataFormat of ${s} but only NHWC is currently supported.`));const[i,l,c,h]=t,d=fh(e,c,u);a(_i(o),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${o}'`));const f=[tl(l.shape,d,i,n,r),dh(l,d,i.shape,n,r)];if(null!=h){const e=ph(h,d);f.push(e)}return f},v={x:p,filter:f,bias:y,preluActivationWeights:w},x={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){const e=iu(((e,t,n)=>{let r=Ns.runKernel("FusedConv2D",v,x);return n([t,e,r]),g&&(r=Ti(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:k}}));return e(p,f)}{const e=iu(((e,t,n,r)=>{let s=Ns.runKernel("FusedConv2D",v,x);return r([t,e,s,n]),g&&(s=Ti(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:k}}));return e(p,f,y)}}});const yh=Ks({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,o=[1,1],a){let i=e;3===e.rank&&(i=Ti(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Ti(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:i,dy:l},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,filterShape:n};return Ns.runKernel("DepthwiseConv2dNativeBackpropFilter",u,c)}});const wh=Ks({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,o=[1,1],a){let i=t,l=!1;3===t.rank&&(l=!0,i=Ti(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:i,filter:n},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,inputShape:e},h=Ns.runKernel("DepthwiseConv2dNativeBackpropInput",u,c);return l?Ti(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const kh=Ks({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===mh(Ns.state.gradientDepth,u)){let a=dl(e,t,n,r,s,o,i);return null!=l&&(a=ni(a,l)),gh(a,u,c,h)}const d=Ls(e,"x","depthwiseConv2d","float32"),f=Ls(t,"filter","depthwiseConv2d","float32");let p=d,g=!1;3===d.rank&&(g=!0,p=Ti(d,[1,d.shape[0],d.shape[1],d.shape[2]])),a(4===p.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${p.rank}.`)),a(4===f.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${f.rank}.`)),a(p.shape[3]===f.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${p.shape[3]}) must match the inChannels dimension in filter ${f.shape[2]}.`)),null==o&&(o=[1,1]),a(Ii(n,o),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),Ni("fused depthwiseConv2d",r,i);const m=ki(p.shape,f.shape,n,o,r,i,!0);let b,y;null!=l&&(b=Ls(l,"bias","fused conv2d"),[b]=vs(b,d),Sa(m.outShape,b.shape)),null!=c&&(y=Ls(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{a(_i(o),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[s,l,c,h]=t,d=fh(e,c,u),f=wh(l.shape,d,s,n,r,o,i),p=yh(l,d,s.shape,n,r,o,i);if(null!=h){return[f,p,ph(b,d)]}return[f,p]},k={x:p,filter:f,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){const e=iu(((e,t,n)=>{let r=Ns.runKernel("FusedDepthwiseConv2D",k,v);return n([t,e,r]),g&&(r=Ti(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return e(p,f)}{const e=iu(((e,t,n,r)=>{let s=Ns.runKernel("FusedDepthwiseConv2D",k,v);return r([t,e,s,n]),g&&(s=Ti(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return e(p,f,b)}}});const vh=Ks({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:o="linear",preluActivationWeights:i,leakyreluAlpha:l=.2}){if(!1===mh(Ns.state.gradientDepth,o)){let a=jo(e,t,n,r);return null!=s&&(a=ni(a,s)),gh(a,o,i,l)}let u=Ls(e,"a","fused matMul"),h=Ls(t,"b","fused matMul");[u,h]=vs(u,h);const d=n?u.shape[u.rank-2]:u.shape[u.rank-1],f=r?h.shape[h.rank-1]:h.shape[h.rank-2],p=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=r?h.shape[h.rank-2]:h.shape[h.rank-1],m=u.shape.slice(0,-2),b=h.shape.slice(0,-2),y=c(m),w=c(b);a(d===f,(()=>`Error in fused matMul: inner shapes (${d}) and (${f}) of Tensors with shapes ${u.shape} and ${h.shape} and transposeA=${n} and transposeB=${r} must match.`));const k=Sa(u.shape.slice(0,-2),h.shape.slice(0,-2)).concat([p,g]),v=Ti(u,n?[y,d,p]:[y,p,d]),x=Ti(h,r?[w,g,f]:[w,f,g]);let E,S;null!=s&&(E=Ls(s,"bias","fused matMul"),[E]=vs(E,u),Sa(k,E.shape)),null!=i&&(S=Ls(i,"prelu weights","fused matMul"));const $=(e,t)=>{const[a,i,l,u]=t,c=fh(Ti(e,l.shape),l,o);let h,d;if(n||r?!n&&r?(h=jo(c,i,!1,!1),d=jo(c,a,!0,!1)):n&&!r?(h=jo(i,c,!1,!0),d=jo(a,c,!1,!1)):(h=jo(i,c,!0,!0),d=jo(c,a,!0,!0)):(h=jo(c,i,!1,!0),d=jo(a,c,!0,!1)),null!=s){return[h,d,ph(u,c)]}return[h,d]},A={a:v,b:x,bias:E,preluActivationWeights:S},_={transposeA:n,transposeB:r,activation:o,leakyreluAlpha:l};if(null==s){const e=iu(((e,t,n)=>{const r=Ns.runKernel("_FusedMatMul",A,_);return n([e,t,r]),{value:Ti(r,k),gradFunc:$}}));return e(v,x)}{const e=iu(((e,t,n,r)=>{const s=Ns.runKernel("_FusedMatMul",A,_);return r([e,t,s,n]),{value:Ti(s,k),gradFunc:$}}));return e(v,x,E)}}});var xh={__proto__:null,conv2d:bh,depthwiseConv2d:kh,matMul:vh};const Eh=Ks({hammingWindow_:function(e){return ch(e,.54,.46)}});const Sh=Ks({hannWindow_:function(e){return ch(e,.5,.5)}});const $h=Ks({frame_:function(e,t,n,r=!1,s=0){let o=0;const a=[];for(;o+t<=e.size;)a.push(Bi(e,o,t)),o+=n;if(r)for(;o<e.size;){const r=o+t-e.size,i=Fi([Bi(e,o,t-r),Wl([r],s)]);a.push(i),o+=n}return 0===a.length?qc([],[0,t]):Ti(Fi(a),[a.length,t])}});const Ah=Ks({stft_:function(e,t,n,r,s=Sh){null==r&&(r=uh(t));const o=$h(e,t,n),a=oi(o,s(t));return Bc(a,r)}});const _h=Ks({cropAndResize_:function(e,t,n,r,s="bilinear",o=0){const i=Ls(e,"image","cropAndResize"),l=Ls(t,"boxes","cropAndResize","float32"),u=Ls(n,"boxInd","cropAndResize","int32"),c=l.shape[0];a(4===i.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`)),a(2===l.rank&&4===l.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${l.shape}.`)),a(1===u.rank&&u.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${l.shape}.`)),a(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),a(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),a("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const h={image:i,boxes:l,boxInd:u},d={method:s,extrapolationValue:o,cropSize:r};return Ns.runKernel("CropAndResize",h,d)}});const Ih=Ks({flipLeftRight_:function(e){const t=Ls(e,"image","flipLeftRight","float32");a(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Ns.runKernel("FlipLeftRight",n,{})}});const Mh=Ks({grayscaleToRGB_:function(e){const t=Ls(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];a(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),a(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,Ll(t,s)}});const Nh=Ks({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Ls(e,"image","rotateWithOffset","float32");a(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const o={image:s},i={radians:t,fillValue:n,center:r};return Ns.runKernel("RotateWithOffset",o,i)}});function Th(e,t,n,r,s,o){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==o&&(o=0);const i=e.shape[0];return n=Math.min(n,i),a(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),a(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),a(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),a(1===t.rank,(()=>"scores must be a 1D tensor")),a(t.shape[0]===i,(()=>`scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`)),a(0<=o&&o<=1,(()=>`softNmsSigma must be in [0, 1], but was '${o}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:o}}const Dh=Ks({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Ls(e,"boxes","nonMaxSuppression","float32"),a=Ls(t,"scores","nonMaxSuppression","float32"),i=Th(o,a,n,r,s),l={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return Ns.runKernel("NonMaxSuppressionV3",{boxes:o,scores:a},l)}});function Rh(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,o=0,a=!1;for(;r<s;){o=r+(s-r>>>1);const i=n(t,e[o]);i>0?r=o+1:(s=o,a=!i)}return a?r:-r-1}(e,t,n||Fh)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function Fh(e,t){return e>t?1:e<t?-1:0}function Ch(e,t,n,r,s){return Oh(e,t,n,r,s,0)}function Bh(e,t,n,r,s,o){return Oh(e,t,n,r,s,0,!1,o,!0)}function Ph(e,t,n,r,s,o){return Oh(e,t,n,r,s,o,!0)}function Oh(e,t,n,r,s,o,a=!1,i=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>s&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(Wh);const c=o>0?-.5/o:0,h=[],d=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:o,suppressBeginIndex:a}=t;if(n<s)break;let i=!1;for(let n=h.length-1;n>=a;--n){const a=Lh(e,o,h[n]);if(a>=r){i=!0;break}if(t.score=t.score*zh(r,c,a),t.score<=s)break}t.suppressBeginIndex=h.length,i||(t.score===n?(h.push(o),d.push(t.score)):t.score>s&&Rh(u,t,Wh))}const f=h.length,p=n-f;i&&p>0&&(h.push(...new Array(p).fill(0)),d.push(...new Array(p).fill(0)));const g={selectedIndices:h};return a&&(g.selectedScores=d),l&&(g.validOutputs=f),g}function Lh(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),o=Math.min(r[0],r[2]),a=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),l=Math.max(r[1],r[3]),u=Math.min(s[0],s[2]),c=Math.min(s[1],s[3]),h=Math.max(s[0],s[2]),d=Math.max(s[1],s[3]),f=(i-o)*(l-a),p=(h-u)*(d-c);if(f<=0||p<=0)return 0;const g=Math.max(o,u),m=Math.max(a,c),b=Math.min(i,h),y=Math.min(l,d),w=Math.max(b-g,0)*Math.max(y-m,0);return w/(f+p-w)}function zh(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function Wh(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Kh=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Ls(e,"boxes","nonMaxSuppressionAsync"),a=Ls(t,"scores","nonMaxSuppressionAsync"),i=Th(o,a,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const l=await Promise.all([o.data(),a.data()]),u=l[0],c=l[1],{selectedIndices:h}=Ch(u,c,n,r,s);return o!==e&&o.dispose(),a!==t&&a.dispose(),Uc(h,"int32")};const Uh=Ks({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Ls(e,"boxes","nonMaxSuppression"),i=Ls(t,"scores","nonMaxSuppression"),l=Th(a,i,n,r,s,o),u={boxes:a,scores:i},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:r=l.iouThreshold,scoreThreshold:s=l.scoreThreshold,softNmsSigma:o=l.softNmsSigma},h=Ns.runKernel("NonMaxSuppressionV5",u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const qh=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Ls(e,"boxes","nonMaxSuppressionAsync"),i=Ls(t,"scores","nonMaxSuppressionAsync"),l=Th(a,i,n,r,s,o);n=l.maxOutputSize,r=l.iouThreshold,s=l.scoreThreshold,o=l.softNmsSigma;const u=await Promise.all([a.data(),i.data()]),c=u[0],h=u[1],{selectedIndices:d,selectedScores:f}=Ph(c,h,n,r,s,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Uc(d,"int32"),selectedScores:Uc(f)}};const Gh=Ks({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Ls(e,"boxes","nonMaxSuppression"),i=Ls(t,"scores","nonMaxSuppression"),l=Th(a,i,n,r,s,null),u={boxes:a,scores:i},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:o},h=Ns.runKernel("NonMaxSuppressionV4",u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const Hh=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Ls(e,"boxes","nonMaxSuppressionAsync"),i=Ls(t,"scores","nonMaxSuppressionAsync"),l=Th(a,i,n,r,s,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[d,f]=await Promise.all([a.data(),i.data()]),{selectedIndices:p,validOutputs:g}=Bh(d,f,u,c,h,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Uc(p,"int32"),validOutputs:Ml(g,"int32")}};const Vh=Ks({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Ls(e,"images","resizeBilinear");a(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),a(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),a(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let o=s,i=!1;3===s.rank&&(i=!0,o=Ti(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=Ns.runKernel("ResizeBilinear",l,u);return i?Ti(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const jh=Ks({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Ls(e,"images","resizeNearestNeighbor");a(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),a(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),a("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),a(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let o=s,i=!1;3===s.rank&&(i=!0,o=Ti(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=Ns.runKernel("ResizeNearestNeighbor",l,u);return i?Ti(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Jh=Ks({threshold_:function(e,t="binary",n=!1,r=.5){const s=Ls(e,"image","threshold"),o=s.shape[0]*s.shape[1];let i,l,u,c,h=oi(Uc([r]),255);if(a(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),a(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),a("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),a("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[i,l,u]=Cc(s,[1,1,1],-1);const e=oi(i,.2989),t=oi(l,.587),n=oi(u,.114);c=ni(ni(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,r,s,o,a,i,l=Uc([-1]),u=Uc([0]),c=Uc([0]);for(let h=0;h<e.size-1;h++){n=Bi(e,0,h+1),r=Bi(e,h+1),a=si(Dl(n),t),i=si(Dl(r),t);const d=Dl(oi(n,cc(0,n.size)));s=si(d,Dl(n));const f=Wl(r.shape,n.size),p=ni(cc(0,r.size),f),g=oi(r,p);o=si(Dl(g),Dl(r));const m=hu(s,o),b=hu(s,o),y=oi(a,i);c=oi(oi(y,m),b);const w=ql(c,u);u=ml(w,c,u),l=ml(w,Uc([h]),l)}return l}(qi(No(wc(c),"int32"),Gs([]),256),o)}const d=n?Yl(c,h):ql(c,h);return No(oi(d,255),"int32")}});const Zh=Ks({transform_:function(e,t,n="nearest",r="constant",s=0,o){const i=Ls(e,"image","transform","float32"),l=Ls(t,"transforms","transform","float32");a(4===i.rank,(()=>`Error in transform: image must be rank 4,but got rank ${i.rank}.`)),a(2===l.rank&&(l.shape[0]===i.shape[0]||1===l.shape[0])&&8===l.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),a(null==o||2===o.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${o}.`));const u={image:i,transforms:l},c={interpolation:n,fillMode:r,fillValue:s,outputShape:o};return Ns.runKernel("Transform",u,c)}});const Yh=Ks({bandPart_:function(e,t,n){a(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),a(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Ls(e,"a","bandPart");a(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[o,i]=r.shape.slice(-2);if(!(t<=o))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${o}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=o),n<0&&(n=i);const l=Ti(cc(0,o,1,"int32"),[-1,1]),u=cc(0,i,1,"int32"),c=hu(l,u),h=pu(Yl(c,Ml(+t,"int32")),Gl(c,Ml(-n,"int32"))),d=$u([o,i],r.dtype);return Ti(Lc(Xc(Ti(r,[-1,o,i])).map((e=>ml(h,e,d)))),s)}});const Xh=Ks({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,a(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)a(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=Cc(e,e.shape[0],0).map((e=>Oc(e,[0])));a(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(Ns.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=oi(Dl(oi(n[r],e)),n[r]);e=hu(e,t)}return si(e,Fl(e,"euclidean"))})));return t?Lc(n,0):n}});function Qh(e,t=!1){return Ns.tidy((()=>{a(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=zl(n),o=To(e);const i=qc([[1]],[1,1]);let l=To(i);const u=n>=r?r:n;for(let e=0;e<u;++e){const t=o,a=l,u=s;[l,o,s]=Ns.tidy((()=>{const t=Bi(o,[e,e],[n-e,1]),a=Fl(t),u=Bi(o,[e,e],[1,1]),c=ml(ql(u,0),qc([[-1]]),qc([[1]])),h=hu(u,oi(c,a)),d=si(t,h);l=1===d.shape[0]?To(i):Fi([i,Bi(d,[1,0],[d.shape[0]-1,d.shape[1]])],0);const f=ya(si(jo(c,h),a)),p=Bi(o,[e,0],[n-e,r]),g=oi(f,l),m=ka(l);if(0===e)o=hu(p,jo(g,jo(m,p)));else{const t=hu(p,jo(g,jo(m,p)));o=Fi([Bi(o,[0,0],[e,r]),t],0)}const b=ka(g),y=Bi(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=hu(y,jo(jo(y,l),b));else{const t=hu(y,jo(jo(y,l),b));s=Fi([Bi(s,[0,0],[n,e]),t],1)}return[l,o,s]})),oa([t,a,u])}return!t&&n>r&&(s=Bi(s,[0,0],[n,r]),o=Bi(o,[0,0],[r,r])),[s,o]}))}const ed=Ks({qr_:function(e,t=!1){if(a(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Qh(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Xc(Ti(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],o=[];r.forEach((e=>{const[n,r]=Qh(e,t);s.push(n),o.push(r)}));return[Ti(Lc(s,0),e.shape),Ti(Lc(o,0),e.shape)]}}});var td;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(td||(td={}));const nd=Ks({computeWeightedLoss_:function(e,t,n=td.SUM_BY_NONZERO_WEIGHTS){const r=Ls(e,"losses","computeWeightedLoss");let s=null;null!=t&&(s=Ls(t,"weights","computeWeightedLoss"));const o=null==s?r:oi(r,s);if(n===td.NONE)return o;if(n===td.SUM)return Dl(o);if(n===td.MEAN){if(null==s)return Su(o);{const e=r.size/s.size,t=si(Dl(o),Dl(s));return e>1?si(t,Ml(e)):t}}if(n===td.SUM_BY_NONZERO_WEIGHTS){if(null==s)return si(Dl(o),Ml(r.size));{const e=oi(s,Au(r.shape)),t=No(Dl(Fu(e,Ml(0))),"float32");return si(Dl(o),t)}}throw Error(`Unknown reduction: ${n}`)}});const rd=Ks({absoluteDifference_:function(e,t,n,r=td.SUM_BY_NONZERO_WEIGHTS){const s=Ls(e,"labels","absoluteDifference"),o=Ls(t,"predictions","absoluteDifference");let a=null;null!=n&&(a=Ls(n,"weights","absoluteDifference")),i(s.shape,o.shape,"Error in absoluteDifference: ");const l=ai(hu(s,o));return nd(l,a,r)}});const sd=Ks({cosineDistance_:function(e,t,n,r,s=td.SUM_BY_NONZERO_WEIGHTS){const o=Ls(e,"labels","cosineDistance"),a=Ls(t,"predictions","cosineDistance");let l=null;null!=r&&(l=Ls(r,"weights","cosineDistance")),i(o.shape,a.shape,"Error in cosineDistance: ");const u=Ml(1),c=hu(u,Dl(oi(o,a),n,!0));return nd(c,l,s)}});const od=Ks({hingeLoss_:function(e,t,n,r=td.SUM_BY_NONZERO_WEIGHTS){let s=Ls(e,"labels","hingeLoss");const o=Ls(t,"predictions","hingeLoss");let a=null;null!=n&&(a=Ls(n,"weights","hingeLoss")),i(s.shape,o.shape,"Error in hingeLoss: ");const l=Ml(1);s=hu(oi(Ml(2),s),l);const u=dc(hu(l,oi(s,o)));return nd(u,a,r)}});const ad=Ks({huberLoss_:function(e,t,n,r=1,s=td.SUM_BY_NONZERO_WEIGHTS){const o=Ls(e,"labels","huberLoss"),a=Ls(t,"predictions","huberLoss");let l=null;null!=n&&(l=Ls(n,"weights","huberLoss")),i(o.shape,a.shape,"Error in huberLoss: ");const u=Ml(r),c=ai(hu(a,o)),h=Iu(c,u),d=hu(c,h),f=ni(oi(Ml(.5),Tl(h)),oi(u,d));return nd(f,l,s)}});const id=Ks({logLoss_:function(e,t,n,r=1e-7,s=td.SUM_BY_NONZERO_WEIGHTS){const o=Ls(e,"labels","logLoss"),a=Ls(t,"predictions","logLoss");let l=null;null!=n&&(l=Ls(n,"weights","logLoss")),i(o.shape,a.shape,"Error in logLoss: ");const u=Ml(1),c=Ml(r),h=ya(oi(o,eu(ni(a,c)))),d=oi(hu(u,o),eu(ni(hu(u,a),c))),f=hu(h,d);return nd(f,l,s)}});const ld=Ks({meanSquaredError_:function(e,t,n,r=td.SUM_BY_NONZERO_WEIGHTS){const s=Ls(e,"labels","meanSquaredError"),o=Ls(t,"predictions","meanSquaredError");let a=null;null!=n&&(a=Ls(n,"weights","meanSquaredError")),i(s.shape,o.shape,"Error in meanSquaredError: ");const l=Pc(s,o);return nd(l,a,r)}});const ud=Ks({sigmoidCrossEntropy_:function(e,t,n,r=0,s=td.SUM_BY_NONZERO_WEIGHTS){let o=Ls(e,"multiClassLabels","sigmoidCrossEntropy");const a=Ls(t,"logits","sigmoidCrossEntropy");let l=null;if(null!=n&&(l=Ls(n,"weights","sigmoidCrossEntropy")),i(o.shape,a.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Ml(r),t=Ml(1),n=Ml(.5);o=ni(oi(o,hu(t,e)),oi(n,e))}const u=function(e,t){const n=Ls(e,"labels","sigmoidCrossEntropyWithLogits"),r=Ls(t,"logits","sigmoidCrossEntropyWithLogits");i(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=dc(r),o=oi(r,n),a=tu(Bl(ya(ai(r))));return ni(hu(s,o),a)}(o,a);return nd(u,l,s)}});const cd=Ks({softmaxCrossEntropy_:function(e,t,n,r=0,s=td.SUM_BY_NONZERO_WEIGHTS){let o=Ls(e,"onehotLabels","softmaxCrossEntropy");const a=Ls(t,"logits","softmaxCrossEntropy");let l=null;if(null!=n&&(l=Ls(n,"weights","softmaxCrossEntropy")),i(o.shape,a.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Ml(r),t=Ml(1),n=Ml(o.shape[1]);o=ni(oi(o,hu(t,e)),si(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const r=iu(((e,t,r)=>{const s=fu(t,[n],!0),o=hu(No(t,"float32"),s);r([e,o]);const a=ya(oi(o,e));return{value:Dl(a,[n]),gradFunc:(e,t)=>{const[r,s]=t,o=$l(e.shape,[n]);return[oi(Ti(e,o),hu(No(r,"float32"),Bl(s))),oi(Ti(e,o),hu(Bl(s),No(r,"float32")))]}}}));return r(e,t)}(o,a);return nd(u,l,s)}});const hd=Ks({sparseFillEmptyRows_:function(e,t,n,r){const s=Ls(e,"indices","sparseFillEmptyRows","int32"),o=Ls(t,"values","sparseFillEmptyRows"),a=Ls(n,"denseShape","sparseFillEmptyRows","int32"),i=Ls(r,"defaultValue","sparseFillEmptyRows",o.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==o.rank)throw new Error(`Values should be Tensor1D but received shape ${o.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const l={indices:s,values:o,denseShape:a,defaultValue:i},u=Ns.runKernel("SparseFillEmptyRows",l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const dd=Ks({sparseReshape_:function(e,t,n){const r=Ls(e,"inputIndices","sparseReshape","int32"),s=Ls(t,"inputShape","sparseReshape","int32"),o=Ls(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==o.rank)throw new Error(`New shape should be Tensor1D but received shape ${o.shape}`);const a={inputIndices:r,inputShape:s,newShape:o},i=Ns.runKernel("SparseReshape",a);return{outputIndices:i[0],outputShape:i[1]}}});const fd=Ks({sparseSegmentMean_:function(e,t,n){const r=Ls(e,"data","sparseSegmentMean"),s=Ls(t,"indices","sparseSegmentMean","int32"),o=Ls(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return Ns.runKernel("SparseSegmentMean",a)}});const pd=Ks({sparseSegmentSum_:function(e,t,n){const r=Ls(e,"data","sparseSegmentSum"),s=Ls(t,"indices","sparseSegmentSum","int32"),o=Ls(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return Ns.runKernel("SparseSegmentSum",a)}});const gd=Ks({stringNGrams_:function(e,t,n,r,s,o,a,i){const l=Ls(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Ls(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:r,leftPad:s,rightPad:o,padWidth:a,preserveShortSequences:i},h={data:l,dataSplits:u},d=Ns.runKernel("StringNGrams",h,c);return{nGrams:d[0],nGramsSplits:d[1]}}});const md=Ks({stringSplit_:function(e,t,n=!0){const r=Ls(e,"input","stringSplit","string"),s=Ls(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const o={skipEmpty:n},a={input:r,delimiter:s},i=Ns.runKernel("StringSplit",a,o);return{indices:i[0],values:i[1],shape:i[2]}}});const bd=Ks({stringToHashBucketFast_:function(e,t){const n=Ls(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return Ns.runKernel("StringToHashBucketFast",s,r)}}),yd={fft:Dc,ifft:Rc,rfft:Bc,irfft:Fc},wd={hammingWindow:Eh,hannWindow:Sh,frame:$h,stft:Ah},kd={flipLeftRight:Ih,grayscaleToRGB:Mh,resizeNearestNeighbor:jh,resizeBilinear:Vh,rotateWithOffset:Nh,cropAndResize:_h,nonMaxSuppression:Dh,nonMaxSuppressionAsync:Kh,nonMaxSuppressionWithScore:Uh,nonMaxSuppressionWithScoreAsync:qh,nonMaxSuppressionPadded:Gh,nonMaxSuppressionPaddedAsync:Hh,threshold:Jh,transform:Zh},vd={bandPart:Yh,gramSchmidt:Xh,qr:ed},xd={absoluteDifference:rd,computeWeightedLoss:nd,cosineDistance:sd,hingeLoss:od,huberLoss:ad,logLoss:id,meanSquaredError:ld,sigmoidCrossEntropy:ud,softmaxCrossEntropy:cd},Ed={sparseFillEmptyRows:hd,sparseReshape:dd,sparseSegmentMean:fd,sparseSegmentSum:pd},Sd={stringNGrams:gd,stringSplit:md,stringToHashBucketFast:bd};class $d extends Va{minimize(e,t=!1,n){const{value:r,grads:s}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:s[e.name]})));this.applyGradients(e)}else this.applyGradients(s);return oa(s),t?r:(r.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return au(e,t)}dispose(){null!=this.iterations_&&oa(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ml(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty($d,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class Ad extends $d{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=Ns.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Ns.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:sa((()=>bl(r).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:sa((()=>bl(r).variable(false)))});const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;sa((()=>{const e=ni(oi(o,this.rho),oi(Tl(s),1-this.rho)),t=oi(si(Nl(ni(a,this.epsilon)),Nl(ni(o,this.epsilon))),s),n=ni(oi(a,this.rho),oi(Tl(t),1-this.rho));o.assign(e),a.assign(n);const i=ni(oi(t,-this.learningRate),r);r.assign(i)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(oa(this.accumulatedGrads.map((e=>e.variable))),oa(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}Ad.className="Adadelta",Ja(Ad);class _d extends $d{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Ns.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:sa((()=>Wl(r.shape,this.initialAccumulatorValue).variable(e)))}}const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable;sa((()=>{const e=ni(o,Tl(s));o.assign(e);const t=ni(oi(si(s,Nl(ni(e,Ns.backend.epsilon()))),-this.learningRate),r);r.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&oa(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}_d.className="Adagrad",Ja(_d);class Id extends $d{constructor(e,t,n,r=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],sa((()=>{this.accBeta1=Ml(t).variable(),this.accBeta2=Ml(n).variable()})),null==r&&(this.epsilon=Ns.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);sa((()=>{const n=hu(1,this.accBeta1),r=hu(1,this.accBeta2);t.forEach(((t,s)=>{const o=Ns.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:sa((()=>bl(o).variable(false)))}),null==this.accumulatedSecondMoment[s]&&(this.accumulatedSecondMoment[s]={originalName:`${t}/v`,variable:sa((()=>bl(o).variable(false)))});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedSecondMoment[s].variable,u=ni(oi(i,this.beta1),oi(a,1-this.beta1)),c=ni(oi(l,this.beta2),oi(Tl(a),1-this.beta2)),h=si(u,n),d=si(c,r);i.assign(u),l.assign(c);const f=ni(oi(si(h,ni(Nl(d),this.epsilon)),-this.learningRate),o);o.assign(f)})),this.accBeta1.assign(oi(this.accBeta1,this.beta1)),this.accBeta2.assign(oi(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&oa(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&oa(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),sa((()=>{this.accBeta1.assign(Il(this.beta1,this.iterations_+1)),this.accBeta2.assign(Il(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}Id.className="Adam",Ja(Id);class Md extends $d{constructor(e,t,n,r=null,s=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.decay=s,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],sa((()=>{this.iteration=Ml(0).variable(),this.accBeta1=Ml(t).variable()})),null==r&&(this.epsilon=Ns.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);sa((()=>{const n=hu(1,this.accBeta1),r=si(-this.learningRate,ni(oi(this.iteration,this.decay),1));t.forEach(((t,s)=>{const o=Ns.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:bl(o).variable(false)}),null==this.accumulatedWeightedInfNorm[s]&&(this.accumulatedWeightedInfNorm[s]={originalName:`${t}/v`,variable:bl(o).variable(false)});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedWeightedInfNorm[s].variable,u=ni(oi(i,this.beta1),oi(a,1-this.beta1)),c=oi(l,this.beta2),h=ai(a),d=Eu(c,h);i.assign(u),l.assign(d);const f=ni(oi(si(r,n),si(u,ni(d,this.epsilon))),o);o.assign(f)})),this.iteration.assign(ni(this.iteration,1)),this.accBeta1.assign(oi(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&oa(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&oa(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}Md.className="Adamax",Ja(Md);class Nd extends $d{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const s=Ns.registeredVariables[t];sa((()=>{const e=ni(oi(this.c,r),s);s.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=aa(Ml(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}Nd.className="SGD",Ja(Nd);class Td extends Nd{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Ml(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Ns.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:sa((()=>bl(r).variable(e)))}}const s=this.accumulations[n].variable,o=Array.isArray(e)?e[n].tensor:e[t];null!=o&&sa((()=>{let e;const t=ni(oi(this.m,s),o);e=this.useNesterov?ni(oi(this.c,ni(o,oi(t,this.m))),r):ni(oi(this.c,t),r),s.assign(t),r.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&oa(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}Td.className="Momentum",Ja(Td);class Dd extends $d{constructor(e,t=.9,n=0,r=null,s=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=r,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=s,null==r&&(this.epsilon=Ns.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Ns.registeredVariables[t],s=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:sa((()=>bl(r).variable(s)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:sa((()=>bl(r).variable(s)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:sa((()=>bl(r).variable(s)))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;sa((()=>{const e=ni(oi(a,this.decay),oi(Tl(o),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,s=ni(oi(t,this.decay),oi(o,1-this.decay)),l=si(oi(o,this.learningRate),Nl(hu(e,ni(Tl(s),this.epsilon)))),u=ni(oi(i,this.momentum),l);a.assign(e),t.assign(s),i.assign(u);const c=hu(r,u);r.assign(c)}else{const e=ni(oi(a,this.decay),oi(Tl(o),1-this.decay)),t=ni(oi(i,this.momentum),si(oi(o,this.learningRate),Nl(ni(e,this.epsilon))));a.assign(e),i.assign(t);const n=hu(r,t);r.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&oa(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&oa(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&oa(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Dd.className="RMSProp",Ja(Dd);class Rd{static sgd(e){return new Nd(e)}static momentum(e,t,n=!1){return new Td(e,t,n)}static rmsprop(e,t=.9,n=0,r=null,s=!1){return new Dd(e,t,n,r,s)}static adam(e=.001,t=.9,n=.999,r=null){return new Id(e,t,n,r)}static adadelta(e=.001,t=.95,n=null){return new Ad(e,t,n)}static adamax(e=.002,t=.9,n=.999,r=null,s=0){return new Md(e,t,n,r,s)}static adagrad(e,t=.1){return new _d(e,t)}}const Fd={sgd:Rd.sgd,momentum:Rd.momentum,adadelta:Rd.adadelta,adagrad:Rd.adagrad,rmsprop:Rd.rmsprop,adamax:Rd.adamax,adam:Rd.adam},Cd="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();function Bd(){return new Promise((e=>Cd((()=>e()))))}const Pd=/->/g;function Od(e,t){const n=[];for(let r=0;r<e.length;++r)0!==e[r].length&&-1===e[r].indexOf(t)&&-1!==t||n.push(r);return n}var Ld={__proto__:null,slice_util:Ha,segment_util:{__proto__:null,segOpComputeOptimalWindowSize:function(e,t){let n,r=!1;for(e<=30?(n=e,r=!0):n=I(e,Math.floor(Math.sqrt(e)));!r;)n>t||n===e?r=!0:n=I(e,n+1);return n},computeOutShape:function(e,t,n){const r=[],s=e.length;for(let o=0;o<s;o++)o!==t?r.push(e[o]):r.push(n);return r},collectGatherOpShapeInfo:function(e,t,n,r){const s=t.shape.length,o=e.shape.length;if(0!==r&&(r<-s||r>s))throw new Error(`Expect batchDims in the range of [-${s}, ${s}], but got ${r}`);if(r<0&&(r+=s),r>o)throw new Error(`batchDims (${r}) must be less than rank(x) (\n    ${o}).`);if(n<r)throw new Error(`batchDims (${r}) must be less than or equal to axis (${n}).`);for(let n=0;n<r;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const a=e.shape[n],i=[];let l=1,u=1,c=1;for(let t=0;t<r;++t)i.push(e.shape[t]),l*=e.shape[t];for(let t=r;t<n;t++)i.push(e.shape[t]),u*=e.shape[t];for(let e=r;e<s;e++)i.push(t.shape[e]);for(let t=n+1;t<o;t++)i.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:a,outputShape:i}}},fromUint8ToStringArray:function(e){try{return e.map((e=>Xr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}},fromStringArrayToUint8:function(e){return e.map((e=>Yr(e)))},upcastType:ws,axesAreInnerMostDims:El,combineLocations:Sl,computeOutAndReduceShapes:function(e,t){const n=[],r=e.length;for(let s=0;s<r;s++)-1===t.indexOf(s)&&n.push(e[s]);return[n,t.map((t=>e[t]))]},expandShapeToKeepDim:$l,assertAxesAreInnerMostDims:function(e,t,n){a(El(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))},getAxesPermutation:function(e,t){if(El(e,t))return null;const n=[];for(let r=0;r<t;++r)-1===e.indexOf(r)&&n.push(r);return e.forEach((e=>n.push(e))),n},getUndoAxesPermutation:function(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))},getInnerMostAxes:function(e,t){const n=[];for(let r=t-e;r<t;++r)n.push(r);return n},getBroadcastDims:xa,getReductionAxes:Ea,assertAndGetBroadcastShape:Sa,assertParamsConsistent:function(e,t){const n=e[0].length;e.forEach(((e,t)=>{a(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),a(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const r=e[0];e.forEach(((e,s)=>{for(let o=0;o<n;o++)a(o===t||e[o]===r[o],(()=>`Error in concat${n}D: Shape of tensors[${s}] (${e}) does not match the shape of the rest (${r}) along the non-concatenated axis ${s}.`))}))},computeOutShape:function(e,t){const n=e[0].slice();for(let r=1;r<e.length;r++)n[t]+=e[r][t];return n},computeDilation2DInfo:function(e,t,n,r,s="NHWC",o){return ki(e,[...t,e[3]],n,o,r,null,null,Mi(s))},computePool2DInfo:wi,computePool3DInfo:function(e,t,n,r,s,o,a="NDHWC"){const[i,l,u]=Si(t);let c,h;if("NDHWC"===a)h="channelsLast",c=[i,l,u,e[4],e[4]];else{if("NCDHW"!==a)throw new Error(`Unknown dataFormat ${a}`);h="channelsFirst",c=[i,l,u,e[1],e[1]]}return vi(e,c,n,r,s,!1,h,o)},computeConv2DInfo:ki,computeConv3DInfo:vi,computeDefaultPad:xi,tupleValuesAreOne:_i,eitherStridesOrDilationsAreOne:Ii,convertConv2DDataFormat:Mi,checkPadOnDimRoundingMode:Ni,getFusedDyActivation:fh,getFusedBiasGradient:ph,applyActivation:gh,shouldFuse:mh,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:function(e){return e<=30?e:I(e,Math.floor(Math.sqrt(e)))},getImageCenter:function(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]},getReshaped:function(e,t,n,r=!0){let s=[];if(r)s=s.concat(t.slice(0)),s.push(e[0]/n),s=s.concat(e.slice(1));else{s=s.concat(e[0]);const n=t.length;for(let r=0;r<n;++r)s=s.concat([e[r+1]/t[r],t[r]]);s=s.concat(e.slice(n+1))}return s},getPermuted:function(e,t,n=!0){const r=[];if(n){r.push(t);for(let n=t+1;n<e;++n)n<=2*t?(r.push(n),r.push(n-(t+1))):r.push(n)}else{const n=[],s=[];for(let r=1;r<e;++r)r>=2*t+1||r%2==1?s.push(r):n.push(r);r.push(...n),r.push(0),r.push(...s)}return r},getReshapedPermuted:function(e,t,n,r=!0){const s=[];r?s.push(e[0]/n):s.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?r?s.push(t[n-1]*e[n]):s.push(e[n]/t[n-1]):s.push(e[n]);return s},getSliceBeginCoords:function(e,t){const n=[0];for(let r=0;r<t;++r)n.push(e[r][0]);return n},getSliceSize:function(e,t,n){const r=e.slice(0,1);for(let s=0;s<n;++s)r.push(e[s+1]-t[s][0]-t[s][1]);return r},prepareAndValidate:Ta,validateUpdateShape:Ra,validateInput:Fa,calculateShapes:Ca,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:1.0507009873554805,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:er,log:function(...e){O().getBool("IS_TEST")||O().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:function(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let r=0;r<n.length;r+=2)n[r]=e[r/2],n[r+1]=t[r/2];return n},splitRealAndImagArrays:function(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let r=0;r<e.length;r+=2)t[r/2]=e[r],n[r/2]=e[r+1];return{real:t,imag:n}},complexWithEvenIndex:function(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},complexWithOddIndex:function(e){const t=Math.floor(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},getComplexWithIndex:function(e,t){return{real:e[2*t],imag:e[2*t+1]}},assignToTypedArray:function(e,t,n,r){e[2*r]=t,e[2*r+1]=n},exponents:function(e,t){const n=new Float32Array(e/2),r=new Float32Array(e/2);for(let s=0;s<Math.ceil(e/2);s++){const o=(t?2:-2)*Math.PI*(s/e);n[s]=Math.cos(o),r[s]=Math.sin(o)}return{real:n,imag:r}},exponent:function(e,t,n){const r=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(r),imag:Math.sin(r)}},decodeEinsumEquation:function(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(Pd,"").length)/"->".length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[r,s]=e.split("->");a(-1===r.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const o=r.split(","),i=o.length;if(t!==i)throw new Error(`Expected ${i} input tensors, received ${t}`);if(i>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const l=[];for(let e=0;e<s.length;++e){const t=s[e];if(!o.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===l.indexOf(t)&&l.push(t)}for(let e=0;e<r.length;++e){const t=r[e];-1===l.indexOf(t)&&","!==t&&l.push(t)}const u=new Array(o.length);for(let e=0;e<i;++e){if(new Set(o[e].split("")).size!==o[e].length)throw new Error(`Found duplicate axes in input component ${o[e]}. Support for duplicate axes in input is not implemented yet.`);u[e]=[];for(let t=0;t<o[e].length;++t)u[e].push(l.indexOf(o[e][t]))}const c=l.length,h=[];for(let e=s.length;e<c;++e)h.push(e);return{allDims:l,summedDims:h,idDims:u}},getEinsumPermutation:function(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const r=[];for(let t=0;t<e;++t)-1===n[t]&&r.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:r}},checkEinsumDimSizes:function(e,t,n){const r=new Array(e);for(let e=0;e<n.length;++e){const s=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===r[t[e][n]]?r[t[e][n]]=s[n]:a(r[t[e][n]]===s[n],(()=>`Expected dimension ${r[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(s)}, but got dimension ${s[n]}`))}},getEinsumComputePath:function(e,t){const n=e,r=[];let s=0;0===e.length&&n.push(-1),s=e.length+1;for(let e=0;e<s;++e)r.push([]);const o=[];for(let e=0;e<n.length;++e){const s=Od(t,n[e]);for(const t of s)-1===o.indexOf(t)&&(r[e].push(t),o.push(t))}return{path:n,steps:r}},isIdentityPermutation:function(e){return e.every(((e,t)=>e===t))},prepareSplitSize:function(e,t,n=0){let r=[];if("number"==typeof t)a(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),r=new Array(t).fill(e.shape[n]/t);else{a(t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0)<=1,(()=>"There should be only one negative value in split array."));const s=t.indexOf(-1);if(-1!==s){const r=t.reduce(((e,t)=>t>0?e+t:e));t[s]=e.shape[n]-r}a(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),r=t}return r},getSparseFillEmptyRowsIndicesDenseShapeMismatch:function(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`},getSparseFillEmptyRowsNegativeIndexErrorMessage:function(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`},getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:function(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`},getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:function(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`},getSparseReshapeNegativeOutputDimErrorMessage:function(e,t){return`size ${e} must be non-negative, not ${t}`},getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:function(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"},getSparseReshapeInputOutputMultipleErrorMessage:function(e,t){return`Input to reshape is a SparseTensor with ${c(e)}\n  dense values, but the requested shape requires a multiple of ${c(t)}. inputShape=${e} outputShape= ${t}`},getSparseReshapeInputOutputMismatchErrorMessage:function(e,t){return`Input to reshape is a tensor with ${c(e)} dense values, but the requested shape has ${c(t)}. inputShape=${e} outputShape=${t}`},getSparseSegmentReductionNegativeSegmentIdsErrorMessage:function(){return"segment ids must be >= 0"},getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:function(){return"segment ids are not increasing"},getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:function(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`},getSparseSegmentReductionIndicesOutOfRangeErrorMessage:function(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}},zd={__proto__:null,nonMaxSuppressionV3Impl:Ch,nonMaxSuppressionV4Impl:Bh,nonMaxSuppressionV5Impl:Ph,whereImpl:th};export{U as Abs,q as Acos,G as Acosh,Ad as AdadeltaOptimizer,_d as AdagradOptimizer,Id as AdamOptimizer,Md as AdamaxOptimizer,H as Add,V as AddN,j as All,J as Any,Z as ArgMax,Y as ArgMin,X as Asin,Q as Asinh,ee as Atan,ne as Atan2,te as Atanh,re as AvgPool,oe as AvgPool3D,ae as AvgPool3DGrad,se as AvgPoolGrad,ie as BatchMatMul,le as BatchToSpaceND,ue as Bincount,he as BroadcastArgs,ce as BroadcastTo,de as Cast,fe as Ceil,pe as ClipByValue,ge as Complex,me as ComplexAbs,be as Concat,ye as Conv2D,we as Conv2DBackpropFilter,ke as Conv2DBackpropInput,ve as Conv3D,xe as Conv3DBackpropFilterV2,Ee as Conv3DBackpropInputV2,Se as Cos,$e as Cosh,Ie as CropAndResize,Ae as Cumprod,_e as Cumsum,e as DataStorage,Me as DenseBincount,Ne as DepthToSpace,Te as DepthwiseConv2dNative,De as DepthwiseConv2dNativeBackpropFilter,Re as DepthwiseConv2dNativeBackpropInput,Fe as Diag,Ce as Dilation2D,Pe as Dilation2DBackpropFilter,Be as Dilation2DBackpropInput,z as ENV,Le as Einsum,ze as Elu,We as EluGrad,B as Environment,Ue as Equal,Ke as Erf,qe as Exp,Ge as ExpandDims,He as Expm1,Ve as FFT,je as Fill,Je as FlipLeftRight,Ze as Floor,Ye as FloorDiv,Jn as FromPixels,Xe as FusedBatchNorm,Xn as FusedConv2D,Qn as FusedDepthwiseConv2D,et as GatherNd,Qe as GatherV2,tt as Greater,nt as GreaterEqual,st as IFFT,rt as Identity,ot as Imag,at as IsFinite,it as IsInf,lt as IsNan,t as KernelBackend,vt as LRN,xt as LRNGrad,ut as LeakyRelu,ct as Less,ht as LessEqual,dt as LinSpace,ft as Log,pt as Log1p,wt as LogSoftmax,gt as LogicalAnd,mt as LogicalNot,bt as LogicalOr,yt as LogicalXor,kt as LowerBound,Et as Max,$t as MaxPool,_t as MaxPool3D,It as MaxPool3DGrad,At as MaxPoolGrad,Mt as MaxPoolWithArgmax,St as Maximum,Nt as Mean,Tt as Min,Dt as Minimum,Rt as MirrorPad,Ft as Mod,Td as MomentumOptimizer,Ct as Multinomial,Bt as Multiply,Pt as Neg,Lt as NonMaxSuppressionV3,zt as NonMaxSuppressionV4,Wt as NonMaxSuppressionV5,Ot as NotEqual,Ws as OP_SCOPE_SUFFIX,Ut as OneHot,Kt as OnesLike,$d as Optimizer,Rd as OptimizerConstructors,qt as Pack,Gt as PadV2,Ht as Pool,Vt as Pow,jt as Prelu,Jt as Prod,Dd as RMSPropOptimizer,Zt as Range,fs as Rank,Yt as Real,Oe as RealDiv,Xt as Reciprocal,td as Reduction,Qt as Relu,on as Relu6,en as Reshape,rn as ResizeBilinear,sn as ResizeBilinearGrad,tn as ResizeNearestNeighbor,nn as ResizeNearestNeighborGrad,an as Reverse,Zn as RotateWithOffset,ln as Round,un as Rsqrt,Nd as SGDOptimizer,cn as ScatterNd,hn as SearchSorted,dn as Select,fn as Selu,yn as Sigmoid,bn as Sign,gn as Sin,mn as Sinh,pn as Slice,Sn as Softmax,wn as Softplus,xn as SpaceToBatchND,$n as SparseFillEmptyRows,An as SparseReshape,_n as SparseSegmentMean,In as SparseSegmentSum,Mn as SparseToDense,En as SplitV,kn as Sqrt,Tn as Square,Nn as SquaredDifference,jn as Step,Dn as StridedSlice,Rn as StringNGrams,Fn as StringSplit,Cn as StringToHashBucketFast,Bn as Sub,vn as Sum,Pn as Tan,On as Tanh,hs as Tensor,ls as TensorBuffer,Ln as Tile,zn as TopK,Wn as Transform,Kn as Transpose,Un as Unique,qn as Unpack,Gn as UnsortedSegmentSum,Hn as UpperBound,ds as Variable,Vn as ZerosLike,Yn as _FusedMatMul,ai as abs,ii as acos,li as acosh,ni as add,ui as addN,ci as all,hi as any,di as argMax,fi as argMin,pi as asin,gi as asinh,mi as atan,bi as atan2,yi as atanh,Di as avgPool,Ri as avgPool3d,ga as backend,Ld as backend_util,Oi as basicLSTMCell,zi as batchNorm,Wi as batchNorm2d,Ki as batchNorm3d,Ui as batchNorm4d,Li as batchToSpaceND,qi as bincount,rh as booleanMaskAsync,Gi as broadcastArgs,Hi as broadcastTo,$a as broadcast_util,Na as browser,Mo as buffer,No as cast,Vi as ceil,ji as clipByValue,To as clone,Us as complex,Fi as concat,Ji as concat1d,Zi as concat2d,Yi as concat3d,Xi as concat4d,el as conv1d,Qi as conv2d,nl as conv2dTranspose,rl as conv3d,ol as conv3dTranspose,cr as copyRegisteredKernels,al as cos,il as cosh,ch as cosineWindow,ll as cumprod,ul as cumsum,iu as customGrad,cl as denseBincount,Qo as deprecationWarn,hl as depthToSpace,dl as depthwiseConv2d,Fs as device_util,fl as diag,pl as dilation2d,Xo as disableDeprecationWarnings,oa as dispose,ea as disposeVariables,si as div,yl as divNoNan,wl as dot,lh as dropout,kl as einsum,vl as elu,Yo as enableDebugMode,Zo as enableProdMode,uh as enclosingPowerOfTwo,ta as engine,O as env,gl as equal,xl as erf,Cl as euclideanNorm,Bl as exp,Pl as expandDims,Ol as expm1,zl as eye,Dc as fft,Wl as fill,da as findBackend,fa as findBackendFactory,Kl as floor,ri as floorDiv,xh as fused,Ul as gather,ih as gatherND,Da as gather_util,ca as getBackend,sr as getGradient,rr as getKernel,or as getKernelsForBackend,nu as grad,ru as grads,ql as greater,Gl as greaterEqual,Rc as ifft,ba as imag,kd as image,hh as inTopKAsync,Vo as io,Fc as irfft,Hl as isFinite,Vl as isInf,jl as isNaN,aa as keep,zd as kernel_impls,Jl as leakyRelu,Zl as less,Yl as lessEqual,vd as linalg,Xl as linspace,Ql as localResponseNormalization,eu as log,tu as log1p,cu as logSigmoid,du as logSoftmax,fu as logSumExp,pu as logicalAnd,gu as logicalNot,mu as logicalOr,bu as logicalXor,xd as losses,wu as lowerBound,jo as matMul,va as math,Al as max,ku as maxPool,vu as maxPool3d,xu as maxPoolWithArgmax,Eu as maximum,Su as mean,na as memory,_u as meshgrid,_l as min,Iu as minimum,Mu as mirrorPad,Nu as mod,Tu as moments,sh as movingAverage,oi as mul,Du as multiRNNCell,Ru as multinomial,ya as neg,Bd as nextFrame,Fl as norm,Fu as notEqual,Jo as oneHot,Au as ones,Cu as onesLike,Ks as op,Bu as outerProduct,Pu as pad,Ou as pad1d,Lu as pad2d,zu as pad3d,Wu as pad4d,Uu as pool,Il as pow,qu as prelu,Do as print,Gu as prod,ra as profile,Hu as rand,ac as randomGamma,ic as randomNormal,lc as randomStandardNormal,uc as randomUniform,cc as range,ua as ready,wa as real,hc as reciprocal,pa as registerBackend,ir as registerGradient,ar as registerKernel,dc as relu,fc as relu6,ha as removeBackend,Ti as reshape,pc as reverse,gc as reverse1d,mc as reverse2d,bc as reverse3d,yc as reverse4d,Bc as rfft,wc as round,kc as rsqrt,Ml as scalar,oh as scatterND,Ba as scatter_util,yu as searchSorted,vc as selu,xc as separableConv2d,Za as serialization,la as setBackend,ma as setPlatform,Ec as setdiff1dAsync,Ci as sigmoid,Sc as sign,wd as signal,$c as sin,Ac as sinh,Bi as slice,_c as slice1d,Ic as slice2d,Mc as slice3d,Nc as slice4d,Ha as slice_util,Tc as softmax,uu as softplus,Ku as spaceToBatchND,Ed as sparse,ah as sparseToDense,yd as spectral,Cc as split,Nl as sqrt,Tl as square,Pc as squaredDifference,Oc as squeeze,Lc as stack,zc as step,Wc as stridedSlice,Sd as string,hu as sub,Dl as sum,ks as sumOutType,Kc as tan,Pi as tanh,Gs as tensor,Uc as tensor1d,qc as tensor2d,Aa as tensor3d,Gc as tensor4d,Hc as tensor5d,Vc as tensor6d,$s as tensor_util,ei as test_util,sa as tidy,Ll as tile,ia as time,jc as topk,Fd as train,ka as transpose,Jc as truncatedNormal,Zc as unique,ur as unregisterGradient,lr as unregisterKernel,Yc as unsortedSegmentSum,Xc as unstack,ws as upcastType,Qc as upperBound,Qr as util,su as valueAndGrad,ou as valueAndGrads,eh as variable,au as variableGrads,ti as version_core,ml as where,nh as whereAsync,$u as zeros,bl as zerosLike};
//# sourceMappingURL=tf-core.fesm.min.js.map
