/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).tf=e.tf||{})}(this,(function(e){"use strict";class t{refCount(e){return n("refCount")}incRef(e){return n("incRef")}timerAvailable(){return!0}time(e){return n("time")}read(e){return n("read")}readSync(e){return n("readSync")}readToGPU(e,t){return n("readToGPU")}numDataIds(){return n("numDataIds")}disposeData(e,t){return n("disposeData")}write(e,t,r){return n("write")}move(e,t,r,s,o){return n("move")}memory(){return n("memory")}floatPrecision(){return n("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return n("dispose")}}function n(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0;for(;t>0;)n=Math.random()*t|0,t--,o(e,t,n)}function s(e,t,n){return Math.max(e,Math.min(t,n))}function o(e,t,n){const r=e[t];e[t]=e[n],e[n]=r}function a(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function i(e,t,n=""){a(h(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function l(e){a(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function u(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||k(e)&&!n)for(let r=0;r<e.length;++r)u(e[r],t,n);else t.push(e);return t}function c(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function h(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function d(e){return e%1==0}function p(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function f(e,t){const n=t.length;return a((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),a(e.every((e=>d(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function g(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,o=null==t||s?null:f(t,e).sort();let a=0;for(let t=0;t<e.length;++t){if(null!=o){if(o[a]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==o[a]||o[a]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),o[a]<=t&&a++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}function m(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}function b(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}function y(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}function w(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function k(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function v(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function x(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}function E(e){return"string"==typeof e||e instanceof String}function S(e){return"boolean"==typeof e}function $(e){return"number"==typeof e}function A(e){return Array.isArray(e)?A(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":$(e)?"float32":E(e)?"string":S(e)?"bool":"float32"}function I(e){return!!(e&&e.constructor&&e.call&&e.apply)}function N(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function _(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function M(e,t,n,r=!1){const s=new Array;if(1===t.length){const o=t[0]*(r?2:1);for(let t=0;t<o;t++)s[t]=n[e+t]}else{const o=t[0],a=t.slice(1),i=a.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<o;t++)s[t]=M(e+t*i,a,n,r)}return s}function T(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return M(0,e,t,n)}function D(e,t){const n=R(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function R(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function B(e){e.forEach((t=>{a(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function F(e){return e&&e.then&&"function"==typeof e.then}const C="tfjsflags";class P{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=O,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(F(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if(C in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function O(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function L(){return e.ENV}let z;function W(){if(null==z){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}z=e}return z}function q(e,t){const n=function(){const e=W();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}e.ENV=null;const K="Acos",U="Acosh",G="Add",H="AddN",V="ArgMax",j="ArgMin",J="Asin",Z="Asinh",Y="Atan",X="Atanh",Q="Atan2",ee="AvgPool",te="AvgPool3D",ne="BatchMatMul",re="BatchToSpaceND",se="Bincount",oe="BroadcastArgs",ae="Cast",ie="Ceil",le="ClipByValue",ue="Complex",ce="ComplexAbs",he="Concat",de="Conv2D",pe="Conv2DBackpropFilter",fe="Conv2DBackpropInput",ge="Conv3D",me="Conv3DBackpropInputV2",be="Cosh",ye="Cumprod",we="Cumsum",ke="CropAndResize",ve="DenseBincount",xe="DepthToSpace",Ee="DepthwiseConv2dNative",Se="DepthwiseConv2dNativeBackpropFilter",$e="DepthwiseConv2dNativeBackpropInput",Ae="Diag",Ie="Dilation2D",Ne="RealDiv",_e="Einsum",Me="Equal",Te="ExpandDims",De="Expm1",Re="Fill",Be="FlipLeftRight",Fe="Floor",Ce="FloorDiv",Pe="FusedBatchNorm",Oe="GatherV2",Le="GatherNd",ze="Greater",We="GreaterEqual",qe="Identity",Ke="IFFT",Ue="Imag",Ge="IsFinite",He="IsInf",Ve="IsNan",je="LeakyRelu",Je="Less",Ze="LessEqual",Ye="LinSpace",Xe="Log1p",Qe="LogicalAnd",et="LogicalNot",tt="LogicalOr",nt="Maximum",rt="MaxPool",st="MaxPool3D",ot="MaxPoolWithArgmax",at="Mean",it="Minimum",lt="MirrorPad",ut="Multinomial",ct="Multiply",ht="NotEqual",dt="NonMaxSuppressionV3",pt="NonMaxSuppressionV4",ft="NonMaxSuppressionV5",gt="OnesLike",mt="OneHot",bt="Pack",yt="PadV2",wt="Prelu",kt="Prod",vt="Range",xt="Real",Et="Reciprocal",St="Relu",$t="Reshape",At="ResizeNearestNeighbor",It="ResizeBilinear",Nt="Relu6",_t="Reverse",Mt="Round",Tt="Rsqrt",Dt="ScatterNd",Rt="SearchSorted",Bt="Select",Ft="Selu",Ct="Slice",Pt="Sinh",Ot="Sign",Lt="Sigmoid",zt="Softplus",Wt="Sqrt",qt="SpaceToBatchND",Kt="SplitV",Ut="Softmax",Gt="SparseFillEmptyRows",Ht="SparseReshape",Vt="SparseSegmentMean",jt="SparseSegmentSum",Jt="SparseToDense",Zt="SquaredDifference",Yt="StridedSlice",Xt="StringNGrams",Qt="StringSplit",en="StringToHashBucketFast",tn="Tanh",nn="Tile",rn="TopK",sn="Transform",on="Transpose",an="Unique",ln="Unpack",un="UnsortedSegmentSum",cn="ZerosLike",hn="Step",dn="FromPixels",pn="RotateWithOffset",fn="_FusedMatMul",gn="FusedConv2D",mn="FusedDepthwiseConv2D";function bn(...e){L().getBool("IS_TEST")||L().getBool("PROD")||console.warn(...e)}const yn=q("kernelRegistry",(()=>new Map)),wn=q("gradRegistry",(()=>new Map));function kn(e,t){const n=Sn(e,t);return yn.get(n)}function vn(e){return wn.get(e)}function xn(e){const t=yn.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[o,a]=s,[i]=o.split("_");i===e&&n.push(a)}return n}function En(e){const{kernelName:t,backendName:n}=e,r=Sn(t,n);yn.has(r)&&bn(`The kernel '${t}' for backend '${n}' is already registered`),yn.set(r,e)}function Sn(e,t){return`${t}_${e}`}var $n=In,An=null;try{An=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function In(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function Nn(e){return!0===(e&&e.__isLong__)}In.prototype.__isLong__,Object.defineProperty(In.prototype,"__isLong__",{value:!0}),In.isLong=Nn;var _n={},Mn={};function Tn(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=Mn[e])?r:(n=Rn(e,(0|e)<0?-1:0,!0),s&&(Mn[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=_n[e])?r:(n=Rn(e,e<0?-1:0,!1),s&&(_n[e]=n),n)}function Dn(e,t){if(isNaN(e))return t?qn:Wn;if(t){if(e<0)return qn;if(e>=On)return Vn}else{if(e<=-Ln)return jn;if(e+1>=Ln)return Hn}return e<0?Dn(-e,t).neg():Rn(e%Pn|0,e/Pn|0,t)}function Rn(e,t,n){return new In(e,t,n)}In.fromInt=Tn,In.fromNumber=Dn,In.fromBits=Rn;var Bn=Math.pow;function Fn(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return Wn;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return Fn(e.substring(1),t,n).neg();for(var s=Dn(Bn(n,8)),o=Wn,a=0;a<e.length;a+=8){var i=Math.min(8,e.length-a),l=parseInt(e.substring(a,a+i),n);if(i<8){var u=Dn(Bn(n,i));o=o.mul(u).add(Dn(l))}else o=(o=o.mul(s)).add(Dn(l))}return o.unsigned=t,o}function Cn(e,t){return"number"==typeof e?Dn(e,t):"string"==typeof e?Fn(e,t):Rn(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}In.fromString=Fn,In.fromValue=Cn;var Pn=4294967296,On=Pn*Pn,Ln=On/2,zn=Tn(1<<24),Wn=Tn(0);In.ZERO=Wn;var qn=Tn(0,!0);In.UZERO=qn;var Kn=Tn(1);In.ONE=Kn;var Un=Tn(1,!0);In.UONE=Un;var Gn=Tn(-1);In.NEG_ONE=Gn;var Hn=Rn(-1,2147483647,!1);In.MAX_VALUE=Hn;var Vn=Rn(-1,-1,!0);In.MAX_UNSIGNED_VALUE=Vn;var jn=Rn(0,-2147483648,!1);In.MIN_VALUE=jn;var Jn=In.prototype;Jn.toInt=function(){return this.unsigned?this.low>>>0:this.low},Jn.toNumber=function(){return this.unsigned?(this.high>>>0)*Pn+(this.low>>>0):this.high*Pn+(this.low>>>0)},Jn.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(jn)){var t=Dn(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=Dn(Bn(e,6),this.unsigned),o=this,a="";;){var i=o.div(s),l=(o.sub(i.mul(s)).toInt()>>>0).toString(e);if((o=i).isZero())return l+a;for(;l.length<6;)l="0"+l;a=""+l+a}},Jn.getHighBits=function(){return this.high},Jn.getHighBitsUnsigned=function(){return this.high>>>0},Jn.getLowBits=function(){return this.low},Jn.getLowBitsUnsigned=function(){return this.low>>>0},Jn.getNumBitsAbs=function(){if(this.isNegative())return this.eq(jn)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},Jn.isZero=function(){return 0===this.high&&0===this.low},Jn.eqz=Jn.isZero,Jn.isNegative=function(){return!this.unsigned&&this.high<0},Jn.isPositive=function(){return this.unsigned||this.high>=0},Jn.isOdd=function(){return 1==(1&this.low)},Jn.isEven=function(){return 0==(1&this.low)},Jn.equals=function(e){return Nn(e)||(e=Cn(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},Jn.eq=Jn.equals,Jn.notEquals=function(e){return!this.eq(e)},Jn.neq=Jn.notEquals,Jn.ne=Jn.notEquals,Jn.lessThan=function(e){return this.comp(e)<0},Jn.lt=Jn.lessThan,Jn.lessThanOrEqual=function(e){return this.comp(e)<=0},Jn.lte=Jn.lessThanOrEqual,Jn.le=Jn.lessThanOrEqual,Jn.greaterThan=function(e){return this.comp(e)>0},Jn.gt=Jn.greaterThan,Jn.greaterThanOrEqual=function(e){return this.comp(e)>=0},Jn.gte=Jn.greaterThanOrEqual,Jn.ge=Jn.greaterThanOrEqual,Jn.compare=function(e){if(Nn(e)||(e=Cn(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},Jn.comp=Jn.compare,Jn.negate=function(){return!this.unsigned&&this.eq(jn)?jn:this.not().add(Kn)},Jn.neg=Jn.negate,Jn.add=function(e){Nn(e)||(e=Cn(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=0,u=0,c=0,h=0;return c+=(h+=s+(65535&e.low))>>>16,u+=(c+=r+i)>>>16,l+=(u+=n+a)>>>16,l+=t+o,Rn((c&=65535)<<16|(h&=65535),(l&=65535)<<16|(u&=65535),this.unsigned)},Jn.subtract=function(e){return Nn(e)||(e=Cn(e)),this.add(e.neg())},Jn.sub=Jn.subtract,Jn.multiply=function(e){if(this.isZero())return Wn;if(Nn(e)||(e=Cn(e)),An)return Rn(An.mul(this.low,this.high,e.low,e.high),An.get_high(),this.unsigned);if(e.isZero())return Wn;if(this.eq(jn))return e.isOdd()?jn:Wn;if(e.eq(jn))return this.isOdd()?jn:Wn;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(zn)&&e.lt(zn))return Dn(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,o=e.high>>>16,a=65535&e.high,i=e.low>>>16,l=65535&e.low,u=0,c=0,h=0,d=0;return h+=(d+=s*l)>>>16,c+=(h+=r*l)>>>16,h&=65535,c+=(h+=s*i)>>>16,u+=(c+=n*l)>>>16,c&=65535,u+=(c+=r*i)>>>16,c&=65535,u+=(c+=s*a)>>>16,u+=t*l+n*i+r*a+s*o,Rn((h&=65535)<<16|(d&=65535),(u&=65535)<<16|(c&=65535),this.unsigned)},Jn.mul=Jn.multiply,Jn.divide=function(e){if(Nn(e)||(e=Cn(e)),e.isZero())throw Error("division by zero");var t,n,r;if(An)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?Rn((this.unsigned?An.div_u:An.div_s)(this.low,this.high,e.low,e.high),An.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?qn:Wn;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return qn;if(e.gt(this.shru(1)))return Un;r=qn}else{if(this.eq(jn))return e.eq(Kn)||e.eq(Gn)?jn:e.eq(jn)?Kn:(t=this.shr(1).div(e).shl(1)).eq(Wn)?e.isNegative()?Kn:Gn:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(jn))return this.unsigned?qn:Wn;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=Wn}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),o=s<=48?1:Bn(2,s-48),a=Dn(t),i=a.mul(e);i.isNegative()||i.gt(n);)i=(a=Dn(t-=o,this.unsigned)).mul(e);a.isZero()&&(a=Kn),r=r.add(a),n=n.sub(i)}return r},Jn.div=Jn.divide,Jn.modulo=function(e){return Nn(e)||(e=Cn(e)),An?Rn((this.unsigned?An.rem_u:An.rem_s)(this.low,this.high,e.low,e.high),An.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},Jn.mod=Jn.modulo,Jn.rem=Jn.modulo,Jn.not=function(){return Rn(~this.low,~this.high,this.unsigned)},Jn.and=function(e){return Nn(e)||(e=Cn(e)),Rn(this.low&e.low,this.high&e.high,this.unsigned)},Jn.or=function(e){return Nn(e)||(e=Cn(e)),Rn(this.low|e.low,this.high|e.high,this.unsigned)},Jn.xor=function(e){return Nn(e)||(e=Cn(e)),Rn(this.low^e.low,this.high^e.high,this.unsigned)},Jn.shiftLeft=function(e){return Nn(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Rn(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Rn(0,this.low<<e-32,this.unsigned)},Jn.shl=Jn.shiftLeft,Jn.shiftRight=function(e){return Nn(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Rn(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Rn(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},Jn.shr=Jn.shiftRight,Jn.shiftRightUnsigned=function(e){if(Nn(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?Rn(this.low>>>e|t<<32-e,t>>>e,this.unsigned):Rn(32===e?t:t>>>e-32,0,this.unsigned)},Jn.shru=Jn.shiftRightUnsigned,Jn.shr_u=Jn.shiftRightUnsigned,Jn.toSigned=function(){return this.unsigned?Rn(this.low,this.high,!1):this},Jn.toUnsigned=function(){return this.unsigned?this:Rn(this.low,this.high,!0)},Jn.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},Jn.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},Jn.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},In.fromBytes=function(e,t,n){return n?In.fromBytesLE(e,t):In.fromBytesBE(e,t)},In.fromBytesLE=function(e,t){return new In(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},In.fromBytesBE=function(e,t){return new In(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const Zn=$n||Object.assign(Object.create(null),$n,{default:$n});function Yn(e){return Zn.fromString(e,!0,16)}const Xn=Yn("c3a5c85c97cb3127"),Qn=Yn("b492b66fbe98f273"),er=Yn("9ae16a3b2f90404f");function tr(e){return e.xor(e.shru(47))}function nr(e,t,n){const r=e.slice(t,t+n);return Zn.fromBytes(Array.from(r),!0,!0)}function rr(e,t){return nr(e,t,8)}function sr(e,t){return nr(e,t,4)}function or(e,t){return 0===t?e:e.shru(t).or(e.shl(64-t))}function ar(e,t,n=Yn("9ddfea08eb382d69")){let r=e.xor(t).mul(n);r=r.xor(r.shru(47));let s=t.xor(r).mul(n);return s=s.xor(s.shru(47)),s=s.mul(n),s}function ir(e,t,n,r){return function(e,t,n,r,s,o){s=s.add(e),o=or(o.add(s).add(r),21);const a=s;return s=(s=s.add(t)).add(n),o=o.add(or(s,44)),[s.add(r),o.add(a)]}(rr(e,t),rr(e,t+8),rr(e,t+16),rr(e,t+24),n,r)}function lr(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=u(e)),L().getBool("DEBUG")&&y(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function ur(){return L().platform.now()}function cr(e,t="utf-8"){return t=t||"utf-8",L().platform.encode(e,t)}function hr(e,t="utf-8"){return t=t||"utf-8",L().platform.decode(e,t)}var dr={__proto__:null,createScalarValue:function(e,t){return"string"===t?cr(e):lr([e],t)},toTypedArray:lr,now:ur,fetch:function(e,t){return L().platform.fetch(e,t)},encodeString:cr,decodeString:hr,shuffle:r,shuffleCombo:function(e,t){if(e.length!==t.length)throw new Error(`Array sizes must match to be shuffled together First array length was ${e.length}Second array length was ${t.length}`);let n=e.length,r=0;for(;n>0;)r=Math.random()*n|0,n--,o(e,n,r),o(t,n,r)},clamp:s,nearestLargerEven:function(e){return e%2==0?e:e+1},swap:o,sum:function(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t},randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let r=0;r<e.length;r++){const s=Number(e[r])-Number(t[r]);n+=s*s}return n},assert:a,assertShapesMatch:i,assertNonNull:l,flatten:u,sizeFromShape:c,isScalarShape:function(e){return 0===e.length},arraysEqual:h,isInt:d,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:function(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]},createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:p,repeatedTry:function(e,t=(e=>0),n){return new Promise(((r,s)=>{let o=0;const a=()=>{if(e())return void r();o++;const i=t(o);null!=n&&o>=n?s():setTimeout(a,i)};a()}))},inferFromImplicitShape:function(e,t){let n=1,r=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==r)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${r} and dim ${t}`);r=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===r){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const s=e.slice();return s[r]=t/n,s},parseAxisParam:f,squeezeShape:g,getTypedArrayFromDType:m,getArrayFromDType:b,checkConversionForErrors:y,isValidDtype:w,hasEncodingLoss:function(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))},isTypedArray:k,bytesPerElement:v,bytesFromStringArray:x,isString:E,isBoolean:S,isNumber:$,inferDtype:A,isFunction:I,nearestDivisor:N,computeStrides:_,toNestedArray:T,makeOnesTypedArray:D,makeZerosTypedArray:R,makeZerosNestedTypedArray:function(e,t){const n=e.reduce(((e,t)=>e*t),1);if(null==t||"float32"===t)return T(e,new Float32Array(n));if("int32"===t)return T(e,new Int32Array(n));if("bool"===t)return T(e,new Uint8Array(n));throw new Error(`Unknown data type ${t}`)},assertNonNegativeIntegerDimensions:B,locToIndex:function(e,t,n){if(0===t)return 0;if(1===t)return e[0];let r=e[e.length-1];for(let t=0;t<e.length-1;++t)r+=n[t]*e[t];return r},indexToLoc:function(e,t,n){if(0===t)return[];if(1===t)return[e];const r=new Array(t);for(let t=0;t<r.length-1;++t)r[t]=Math.floor(e/n[t]),e-=r[t]*n[t];return r[r.length-1]=e,r},isPromise:F,hexToLong:Yn,fingerPrint64:function(e,t=e.length){const n=Zn.fromNumber(81,!0);if(t<=32)return t<=16?function(e,t=e.length){if(t>=8){const n=er.add(2*t),r=rr(e,0).add(er),s=rr(e,t-8);return ar(or(s,37).mul(n).add(r),or(r,25).add(s).mul(n),n)}if(t>=4){const n=er.add(2*t);return ar(sr(e,0).shl(3).add(t),sr(e,t-4),n)}if(t>0){const n=e[0]+(e[t>>1]<<8),r=t+(e[t-1]<<2);return tr(er.mul(n).xor(Xn.mul(r))).mul(er)}return er}(e,t):function(e,t=e.length){const n=er.add(2*t),r=rr(e,0).mul(Qn),s=rr(e,8),o=rr(e,t-8).mul(n),a=rr(e,t-16).mul(er);return ar(or(r.add(s),43).add(or(o,30)).add(a),r.add(or(s.add(er),18)).add(o),n)}(e,t);if(t<=64)return function(e,t=e.length){const n=er.add(2*t),r=rr(e,0).mul(er),s=rr(e,8),o=rr(e,t-8).mul(n),a=rr(e,t-16).mul(er),i=or(r.add(s),43).add(or(o,30)).add(a),l=ar(i,r.add(or(s.add(er),18)).add(o),n),u=rr(e,16).mul(n),c=rr(e,24),h=i.add(rr(e,t-32)).mul(n),d=l.add(rr(e,t-24)).mul(n);return ar(or(u.add(c),43).add(or(h,30)).add(d),u.add(or(c.add(r),18)).add(h),n)}(e,t);let r=n,s=n.mul(Qn).add(113),o=tr(s.mul(er).add(113)).mul(er),a=[Zn.UZERO,Zn.UZERO],i=[Zn.UZERO,Zn.UZERO];r=r.mul(er).add(rr(e,0));let l=0;const u=64*(t-1>>6),c=u+(t-1&63)-63;do{r=or(r.add(s).add(a[0]).add(rr(e,l+8)),37).mul(Qn),s=or(s.add(a[1]).add(rr(e,l+48)),42).mul(Qn),r=r.xor(i[1]),s=s.add(a[0]).add(rr(e,l+40)),o=or(o.add(i[0]),33).mul(Qn),a=ir(e,l,a[1].mul(Qn),r.add(i[0])),i=ir(e,l+32,o.add(i[1]),s.add(rr(e,l+16))),[o,r]=[r,o],l+=64}while(l!==u);const h=Qn.add(o.and(255).shl(1));return l=c,i[0]=i[0].add(t-1&63),a[0]=a[0].add(i[0]),i[0]=i[0].add(a[0]),r=or(r.add(s).add(a[0]).add(rr(e,l+8)),37).mul(h),s=or(s.add(a[1]).add(rr(e,l+48)),42).mul(h),r=r.xor(i[1].mul(9)),s=s.add(a[0].mul(9).add(rr(e,l+40))),o=or(o.add(i[0]),33).mul(h),a=ir(e,l,a[1].mul(h),r.add(i[0])),i=ir(e,l+32,o.add(i[1]),s.add(rr(e,l+16))),[o,r]=[r,o],ar(ar(a[0],i[0],h).add(tr(s).mul(Xn)).add(o),ar(a[1],i[1],h).add(r),h)}};class pr{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new gr)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let o;const a=ur();if(this.backendTimer.timerAvailable())o=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();o=Promise.resolve({kernelMs:ur()-a})}if(L().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{fr(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:o.then((e=>e.kernelMs)),extraInfo:o.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:o}=e;n.forEach((e=>{Promise.all([e.data(),r,o]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function fr(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class gr{logKernelProfile(e,t,n,r,s,o){const a="number"==typeof r?p(`${r}ms`,9):r.error,i=p(e,25),l=t.rank,u=t.size,c=p(t.shape.toString(),14);let h="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;h+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${a}\t%c${l}D ${c}\t%c${u}\t%c${h}\t%c${o}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function mr(e,t,n,r){const s=_(t),o=function(e,t,n,r){const s=c(t),o=r[r.length-1],a=new Array(o).fill(0),i=t.length,l="complex64"===n?kr(e):e;if(i>1)for(let e=0;e<s/o;e++){const t=e*o;for(let e=0;e<o;e++)a[e]=Math.max(a[e],br(l[t+e],0,n).length)}return a}(e,t,n,s),a=t.length,i=wr(e,t,n,s,o),l=["Tensor"];return r&&(l.push(`  dtype: ${n}`),l.push(`  rank: ${a}`),l.push(`  shape: [${t}]`),l.push("  values:")),l.push(i.map((e=>"    "+e)).join("\n")),l.join("\n")}function br(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:E(e)?`'${e}'`:"bool"===n?yr(e):parseFloat(e.toFixed(7)).toString(),p(r,t)}function yr(e){return 0===e?"false":"true"}function wr(e,t,n,r,s,o=!0){const a="complex64"===n?2:1,i=t[0],l=t.length;if(0===l){if("complex64"===n){return[br(kr(e)[0],0,n)]}return"bool"===n?[yr(e[0])]:[e[0].toString()]}if(1===l){if(i>20){const t=3*a;let r=Array.from(e.slice(0,t)),o=Array.from(e.slice((i-3)*a,i*a));return"complex64"===n&&(r=kr(r),o=kr(o)),["["+r.map(((e,t)=>br(e,s[t],n))).join(", ")+", ..., "+o.map(((e,t)=>br(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?kr(e):Array.from(e)).map(((e,t)=>br(e,s[t],n))).join(", ")+"]"]}const u=t.slice(1),c=r.slice(1),h=r[0]*a,d=[];if(i>20){for(let t=0;t<3;t++){const r=t*h,o=r+h;d.push(...wr(e.slice(r,o),u,n,c,s,!1))}d.push("...");for(let t=i-3;t<i;t++){const r=t*h,o=r+h;d.push(...wr(e.slice(r,o),u,n,c,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*h,o=r+h;d.push(...wr(e.slice(r,o),u,n,c,s,t===i-1))}const p=2===l?",":"";d[0]="["+d[0]+p;for(let e=1;e<d.length-1;e++)d[e]=" "+d[e]+p;let f=",\n";for(let e=2;e<l;e++)f+="\n";return d[d.length-1]=" "+d[d.length-1]+"]"+(o?"":f),d}function kr(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class vr{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=c(e),null!=n){const e=n.length;a(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||b(t,this.size),this.strides=_(e)}set(e,...t){0===t.length&&(t=[0]),a(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return xr().makeTensor(this.values,this.shape,this.dtype)}}let xr=null,Er=null;class Sr{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=c(e),this.strides=_(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return Er.buffer(this.shape,this.dtype,e)}bufferSync(){return Er.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return T(this.shape,e,"complex64"===this.dtype)}arraySync(){return T(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=xr().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>hr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),xr().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=xr().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>hr(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await xr().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(xr().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return Er.print(this,e)}clone(){return this.throwIfDisposed(),Er.clone(this)}toString(e=!1){return mr(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),Er.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),xr().makeVariable(this,e,t,n)}}Object.defineProperty(Sr,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),q("Tensor",(()=>Sr));class $r extends Sr{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!h(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);xr().disposeTensor(this),this.dataId=e.dataId,xr().incRef(this,null)}dispose(){xr().disposeVariable(this),this.isDisposedInternal=!0}}var Ar,Ir,Nr,_r,Mr;Object.defineProperty($r,Symbol.hasInstance,{value:e=>e instanceof Sr&&null!=e.assign&&e.assign instanceof Function}),e.Rank=void 0,(Ar=e.Rank||(e.Rank={})).R0="R0",Ar.R1="R1",Ar.R2="R2",Ar.R3="R3",Ar.R4="R4",Ar.R5="R5",Ar.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Ir||(Ir={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Nr||(Nr={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(_r||(_r={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Mr||(Mr={}));const Tr={float32:_r,int32:Ir,bool:Nr,complex64:Mr};function Dr(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Tr[e][t]}function Rr(e,t){if(e.dtype===t.dtype)return[e,t];const n=Dr(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Br(e,t){a(e.dtype===t.dtype,(()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`))}function Fr(e){const t=[];return Cr(e,t,new Set),t}function Cr(e,t,n){if(null==e)return;if(e instanceof Sr)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),Cr(r,t,n))}}var Pr={__proto__:null,makeTypesMatch:Rr,assertTypesMatch:Br,isTensorInList:function(e,t){return t.some((t=>t.id===e.id))},getTensorsInContainer:Fr};function Or(e){return null!=e.kernelName}class Lr{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class zr{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Lr}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(bn(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new pr(this.backendInstance),!0}setupRegisteredKernels(){xn(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){xn(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const n=this.registryFactory[e];if(null==n)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const r=n.factory();if(!r||r instanceof t||"function"!=typeof r.then)return this.registry[e]=r,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=r.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,bn(`Initialization of backend ${e} failed`),bn(n.stack||n.message)),!1)));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return bn(`Initialization of backend ${e} failed`),bn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),o=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,o),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return zr.nextTensorId++}nextVariableId(){return zr.nextVariableId++}clone(e){const t=qr.runKernel(qe,{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return qr.runKernel(ae,t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=kn(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const o=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=r-t-s-o;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,o=this.state.numTensors;let i,l;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=Or(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Or(e)){const{kernelName:t,inputs:s,attrs:o}=e;null==this.backendName&&this.backend;const u=kn(t,this.backendName);a(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),i=()=>{const e=this.backend.numDataIds();l=u.kernelFunc({inputs:s,attrs:o,backend:this.backend});const a=Array.isArray(l)?l:[l];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,a);const i=a.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(r){const e=this.getTensorsForGradient(t,s,i);n=this.saveTensorsForBackwardMode(e)}return i}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};i=()=>{const e=this.backend.numDataIds();l=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(l)?l:[l];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:c,attrs:h}=e,d=Or(e)?null:e.backwardsFunc;let p;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(p=this.profiler.profileKernel(u,c,(()=>i())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(p),t=p.outputs):t=i()})),r&&this.addTapeNode(u,c,t,d,n,h),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-o,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(c).map((e=>null!=c[e]?c[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:p.timeMs,extraInfo:p.extraInfo}),Array.isArray(l)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const r=vn(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let o;r.saveAllInputs?(a(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),o=Object.keys(t).map((e=>t[e]))):o=e.map((e=>t[e]));const i=n.filter(((e,t)=>s[t]));return o.concat(i)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&E(e[0])&&(s=e.map((e=>cr(e))));const o=r.write(s,t,n),a=new Sr(t,n,o,this.nextTensorId());if(this.trackTensor(a,r),"string"===n){const e=this.state.tensorInfo.get(o),t=x(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return a}makeTensorFromDataId(e,t,n,r){const s={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(s,r)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:r,dtype:s}=e,o=new Sr(r,s,n,this.nextTensorId());return this.trackTensor(o,t),o}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new $r(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*v(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof $r||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*v(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,o){const a={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=vn(e);null!=i&&(r=i.gradFunc),null!=r&&(a.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=R(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,o))),this.state.activeTape.push(a)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=Fr(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(a(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));a(s instanceof Sr,(()=>"The result y returned by f() must be a tensor."));const o=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const o=e[n],a=o.inputs;for(const e in a){const n=a[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){o.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[o.id]=!0;break}if(i)break}}const o={};o[n.id]=!0;const a={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(o[n.outputs[e].id]){for(const e in r)o[r[e].id]=!0,a[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&a[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===o.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=D(c(e),"float32");return qr.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const o=t[s],a=[];if(o.outputs.forEach((t=>{const n=e[t.id];null!=n?a.push(n):a.push(null)})),null==o.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${o.kernelName}.`);const i=o.gradient(a);for(const t in o.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const a=o.inputs[t];if(!h(s.shape,a.shape))throw new Error(`Error in gradient for op ${o.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${a.shape}'`);if(null==e[a.id])e[a.id]=s;else{const t=e[a.id];e[a.id]=r(t,s),t.dispose()}}}}(e,o,(e=>this.tidy(e)),Kr);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return a(I(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;a(t.every((e=>e instanceof Sr)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),a(n.value instanceof Sr,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),a(I(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),o=Array.isArray(s)?s:[s];a(o.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),a(o.every((e=>e instanceof Sr)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const i={};return o.forEach(((e,t)=>{i[t]=()=>e})),i},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=ur(),n=await this.backend.time(e);return n.wallMs=ur()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Lr;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Wr(){const t=W();if(null==t._tfengine){const e=new P(t);t._tfengine=new zr(e)}var n;return n=t._tfengine.ENV,e.ENV=n,xr=()=>t._tfengine,t._tfengine}zr.nextTensorId=0,zr.nextVariableId=0;const qr=Wr();function Kr(e,t){const n={a:e,b:t};return qr.runKernel(G,n)}let Ur;function Gr(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Hr={__proto__:null,mockIsMobile:function(e){Ur=e},isMobile:function(e){if(void 0!==Ur)return Ur;if(e||"undefined"!=typeof navigator&&null!=navigator){if(e||(e=navigator),"ReactNative"===e.product)return!0;const t=e.userAgent||e.vendor||("undefined"!=typeof window?window.opera:"");if(!t){const t=e;return t.userAgentData&&t.userAgentData.mobile}return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(t)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(t.substr(0,4))}return!1},isBrowser:Gr};const Vr=L();function jr(e,t){let n=e;if(k(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||k(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&L().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&Jr(e,r,[]),r}function Jr(e,t,n){if(n=n||[],!Array.isArray(e)&&!k(e))return void a(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));a(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),a(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)Jr(e[t],r,n.concat(t))}function Zr(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Yr(e,t,n,r="numeric"){if(e instanceof Sr)return Zr(r,e.dtype,t,n),e;let s=A(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Zr(r,s,t,n),null==e||!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const o=jr(e,s);k(e)||Array.isArray(e)||(e=[e]);const a="string"!==s?lr(e,s):u(e,[],!0);return qr.makeTensor(a,o,s)}function Xr(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Yr(e,`${t}[${s}]`,n,r)))}Vr.registerFlag("DEBUG",(()=>!1),(e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")})),Vr.registerFlag("IS_BROWSER",(()=>Gr())),Vr.registerFlag("IS_NODE",(()=>"undefined"!=typeof process&&"undefined"!=typeof process.versions&&"undefined"!=typeof process.versions.node)),Vr.registerFlag("IS_CHROME",(()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor))),Vr.registerFlag("PROD",(()=>!1)),Vr.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",(()=>Vr.getBool("DEBUG"))),Vr.registerFlag("DEPRECATION_WARNINGS_ENABLED",(()=>!0)),Vr.registerFlag("IS_TEST",(()=>!1)),Vr.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",(()=>!0)),Vr.registerFlag("WRAP_TO_IMAGEBITMAP",(()=>!1)),Vr.registerFlag("ENGINE_COMPILE_ONLY",(()=>!1));const Qr="__op";function es(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+=Qr;const s=(...e)=>{qr.startScope(n);try{const t=r(...e);return F(t)&&console.error("Cannot return a Promise inside of tidy."),qr.endScope(t),t}catch(e){throw qr.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const ts=es({complex_:function(e,t){const n=Yr(e,"real","complex"),r=Yr(t,"imag","complex");i(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return qr.runKernel(ue,s)}});function ns(e,t,n,r){if(null==r&&(r=A(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){B(t);const e=c(t),r=c(n);a(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==c(t.slice(e));a(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return k(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?lr(e,r):u(e,[],!0),qr.makeTensor(e,t,r)}function rs(e,t,n){return ns(e,t,jr(e,n),n)}const ss={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};function os(e,t){const n={};let r,s=0;for(const o of t){const t=o.name,a=o.dtype,i=o.shape,l=c(i);let u;if("quantization"in o){const n=o.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${o.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${o.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==a)throw new Error(`Weight ${o.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${a}.`)}const i=ss[n.dtype],c=e.slice(s,s+l*i),h="uint8"===n.dtype?new Uint8Array(c):new Uint16Array(c);if("float32"===a)if("uint8"===n.dtype||"uint16"===n.dtype){u=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===r&&(r=fs()),u=r(h)}else{if("int32"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);u=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];u[e]=Math.round(t*n.scale+n.min)}}s+=l*i}else if("string"===a){const t=c(o.shape);u=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(s,s+4))[0];s+=4;const n=new Uint8Array(e.slice(s,s+t));u.push(n),s+=t}}else{const r=ss[a],o=e.slice(s,s+l*r);if("float32"===a)u=new Float32Array(o);else if("int32"===a)u=new Int32Array(o);else if("bool"===a)u=new Uint8Array(o);else{if("complex64"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);{u=new Float32Array(o);const e=new Float32Array(u.length/2),r=new Float32Array(u.length/2);for(let t=0;t<e.length;t++)e[t]=u[2*t],r[t]=u[2*t+1];const s=rs(e,i,"float32"),a=rs(r,i,"float32");n[t]=ts(s,a),s.dispose(),a.dispose()}}s+=l*r}"complex64"!==a&&(n[t]=rs(u,i,a))}return n}function as(e){if(null===e)throw new Error(`Invalid input value: ${JSON.stringify(e)}`);let t=0;const n=[];e.forEach((e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error(`Unsupported TypedArray subtype: ${e.constructor.name}`)}));const r=new Uint8Array(t);let s=0;return n.forEach((e=>{r.set(new Uint8Array(e.buffer),s),s+=e.byteLength})),r.buffer}const is="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function ls(e){return is?Buffer.byteLength(e):new Blob([e]).size}function us(e){if(1===e.length)return e[0];let t=0;e.forEach((e=>{t+=e.byteLength}));const n=new Uint8Array(t);let r=0;return e.forEach((e=>{n.set(new Uint8Array(e),r),r+=e.byteLength})),n.buffer}function cs(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function hs(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:t};return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),n}async function ds(e,t){const n={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};if(null!=e.trainingConfig&&(n.trainingConfig=e.trainingConfig),null!=e.weightsManifest){const[r,s]=await t(e.weightsManifest);n.weightSpecs=r,n.weightData=s}return null!=e.signature&&(n.signature=e.signature),null!=e.userDefinedMetadata&&(n.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(n.modelInitializer=e.modelInitializer),n}function ps(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:ls(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:ls(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function fs(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return r=>{const s=new ArrayBuffer(4*r.length),o=new Uint32Array(s);for(let s=0;s<r.length;s++){const a=r[s],i=e[n[a>>10]+(1023&a)]+t[a>>10];o[s]=i}return new Float32Array(s)}}class gs{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==gs.instance&&(gs.instance=new gs),gs.instance}static registerSaveRouter(e){gs.getInstance().saveRouters.push(e)}static registerLoadRouter(e){gs.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return gs.getHandlers(e,"save")}static getLoadHandlers(e,t){return gs.getHandlers(e,"load",t)}static getHandlers(e,t,n){const r=[];return("load"===t?gs.getInstance().loadRouters:gs.getInstance().saveRouters).forEach((t=>{const s=t(e,n);null!==s&&r.push(s)})),r}}const ms="tensorflowjs",bs="models_store",ys="model_info_store";function ws(){if(!L().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function ks(e){const t=e.result;t.createObjectStore(bs,{keyPath:"modelPath"}),t.createObjectStore(ys,{keyPath:"modelPath"})}class vs{constructor(e){if(this.indexedDB=ws(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise(((e,n)=>{const r=this.indexedDB.open(ms,1);r.onupgradeneeded=()=>ks(r),r.onsuccess=()=>{const s=r.result;if(null==t){const t=s.transaction(bs,"readonly"),r=t.objectStore(bs).get(this.modelPath);r.onsuccess=()=>{if(null==r.result)return s.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(r.result.modelArtifacts)},r.onerror=e=>(s.close(),n(r.error)),t.oncomplete=()=>s.close()}else{const r=ps(t),o=s.transaction(ys,"readwrite");let a=o.objectStore(ys);const i=a.put({modelPath:this.modelPath,modelArtifactsInfo:r});let l;i.onsuccess=()=>{l=s.transaction(bs,"readwrite");const i=l.objectStore(bs).put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:r});i.onsuccess=()=>e({modelArtifactsInfo:r}),i.onerror=e=>{a=o.objectStore(ys);const t=a.delete(this.modelPath);t.onsuccess=()=>(s.close(),n(i.error)),t.onerror=e=>(s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}}},r.onerror=e=>n(r.error)}))}}vs.URL_SCHEME="indexeddb://";const xs=e=>{return L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(vs.URL_SCHEME)?(t=e.slice(vs.URL_SCHEME.length),new vs(t)):null;var t};gs.registerSaveRouter(xs),gs.registerLoadRouter(xs);class Es{constructor(){this.indexedDB=ws()}async listModels(){return new Promise(((e,t)=>{const n=this.indexedDB.open(ms,1);n.onupgradeneeded=()=>ks(n),n.onsuccess=()=>{const r=n.result,s=r.transaction(ys,"readonly"),o=s.objectStore(ys).getAll();o.onsuccess=()=>{const t={};for(const e of o.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},o.onerror=e=>(r.close(),t(o.error)),s.oncomplete=()=>r.close()},n.onerror=e=>t(n.error)}))}async removeModel(e){var t;return e=(t=e).startsWith(vs.URL_SCHEME)?t.slice(vs.URL_SCHEME.length):t,new Promise(((t,n)=>{const r=this.indexedDB.open(ms,1);r.onupgradeneeded=()=>ks(r),r.onsuccess=()=>{const s=r.result,o=s.transaction(ys,"readwrite"),a=o.objectStore(ys),i=a.get(e);let l;i.onsuccess=()=>{if(null==i.result)return s.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const r=a.delete(e),o=()=>{l=s.transaction(bs,"readwrite");const r=l.objectStore(bs).delete(e);r.onsuccess=()=>t(i.result.modelArtifactsInfo),r.onerror=e=>n(i.error)};r.onsuccess=o,r.onerror=e=>(o(),s.close(),n(i.error))}},i.onerror=e=>(s.close(),n(i.error)),o.oncomplete=()=>{null==l?s.close():l.oncomplete=()=>s.close()}},r.onerror=e=>n(r.error)}))}}const Ss="/",$s="tensorflowjs_models",As="info",Is="model_topology",Ns="weight_specs",_s="weight_data",Ms="model_metadata";function Ts(e){return{info:[$s,e,As].join(Ss),topology:[$s,e,Is].join(Ss),weightSpecs:[$s,e,Ns].join(Ss),weightData:[$s,e,_s].join(Ss),modelMetadata:[$s,e,Ms].join(Ss)}}function Ds(e){for(const t of Object.values(e))window.localStorage.removeItem(t)}function Rs(e){const t=e.split(Ss);if(t.length<3)throw new Error(`Invalid key format: ${e}`);return t.slice(1,t.length-1).join(Ss)}class Bs{constructor(e){if(!L().getBool("IS_BROWSER")||"undefined"==typeof window||"undefined"==typeof window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=Ts(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),r=ps(e);try{this.LS.setItem(this.keys.info,JSON.stringify(r)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(is)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,r=t.length;e<r;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const s={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,signature:null!=e.signature?e.signature:void 0,userDefinedMetadata:null!=e.userDefinedMetadata?e.userDefinedMetadata:void 0,modelInitializer:null!=e.modelInitializer?e.modelInitializer:void 0,trainingConfig:null!=e.trainingConfig?e.trainingConfig:void 0};return this.LS.setItem(this.keys.modelMetadata,JSON.stringify(s)),{modelArtifactsInfo:r}}catch(e){throw Ds(this.keys),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${r.modelTopologyBytes}, weightSpecsBytes=${r.weightSpecsBytes}, weightDataBytes=${r.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const r=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==r)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=r;const s=this.LS.getItem(this.keys.modelMetadata);if(null!=s){const e=JSON.parse(s);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer),null!=e.trainingConfig&&(t.trainingConfig=e.trainingConfig)}const o=this.LS.getItem(this.keys.weightData);if(null==o)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(is){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(o),t}}Bs.URL_SCHEME="localstorage://";const Fs=e=>{return L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Bs.URL_SCHEME)?(t=e.slice(Bs.URL_SCHEME.length),new Bs(t)):null;var t};gs.registerSaveRouter(Fs),gs.registerLoadRouter(Fs);class Cs{constructor(){a(L().getBool("IS_BROWSER"),(()=>"Current environment is not a web browser")),a("undefined"==typeof window||"undefined"!=typeof window.localStorage,(()=>"Current browser does not appear to support localStorage")),this.LS=window.localStorage}async listModels(){const e={},t=$s+Ss,n=Ss+As;for(let r=0;r<this.LS.length;++r){const s=this.LS.key(r);if(s.startsWith(t)&&s.endsWith(n)){e[Rs(s)]=JSON.parse(this.LS.getItem(s))}}return e}async removeModel(e){var t;const n=Ts(e=(t=e).startsWith(Bs.URL_SCHEME)?t.slice(Bs.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const r=JSON.parse(this.LS.getItem(n.info));return Ds(n),r}}const Ps="://";class Os{constructor(){this.managers={}}static getInstance(){return null==Os.instance&&(Os.instance=new Os),Os.instance}static registerManager(e,t){a(null!=e,(()=>"scheme must not be undefined or null.")),e.endsWith(Ps)&&(e=e.slice(0,e.indexOf(Ps))),a(e.length>0,(()=>"scheme must not be an empty string."));const n=Os.getInstance();a(null==n.managers[e],(()=>`A model store manager is already registered for scheme '${e}'.`)),n.managers[e]=t}static getManager(e){const t=Os.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(Os.getInstance().managers)}}function Ls(e){if(-1===e.indexOf(Ps))throw new Error(`The url string provided does not contain a scheme. Supported schemes are: ${Os.getSchemes().join(",")}`);return{scheme:e.split(Ps)[0],path:e.split(Ps)[1]}}async function zs(e,t,n=!1){a(e!==t,(()=>`Old path and new path are the same: '${e}'`));const r=gs.getLoadHandlers(e);a(r.length>0,(()=>`Copying failed because no load handler is found for source URL ${e}.`)),a(r.length<2,(()=>`Copying failed because more than one (${r.length}) load handlers for source URL ${e}.`));const s=r[0],o=gs.getSaveHandlers(t);a(o.length>0,(()=>`Copying failed because no save handler is found for destination URL ${t}.`)),a(o.length<2,(()=>`Copying failed because more than one (${r.length}) save handlers for destination URL ${t}.`));const i=o[0],l=Ls(e).scheme,u=Ls(e).path,c=l===Ls(e).scheme,h=await s.load();n&&c&&await Os.getManager(l).removeModel(u);const d=await i.save(h);return n&&!c&&await Os.getManager(l).removeModel(u),d.modelArtifactsInfo}class Ws{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Browser's encoder only supports utf-8, but got ${t}`);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(L().get("IS_BROWSER")){L().setPlatform("browser",new Ws);try{Os.registerManager(Bs.URL_SCHEME,new Cs)}catch(e){}try{Os.registerManager(vs.URL_SCHEME,new Es)}catch(e){}}const qs=()=>require("node-fetch");let Ks;class Us{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=L().global.fetch?L().global.fetch(e,t):(null==Ks&&(Ks=qs()),Ks(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error(`Node built-in encoder only supports utf-8, but got ${t}`);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function Gs(e,t="float32",n){return t=t||"float32",B(e),new vr(e,t,n)}L().get("IS_NODE")&&!L().get("IS_BROWSER")&&L().setPlatform("node",new Us);const Hs=es({cast_:function(e,t){const n=Yr(e,"x","cast");if(!w(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return qr.runKernel(ae,r,s)}});const Vs=es({clone_:function(e){const t={x:Yr(e,"x","clone","string_or_numeric")};return qr.runKernel(qe,t)}});function js(e,t=!1){console.log(e.toString(t))}Wr();Er={buffer:Gs,cast:Hs,clone:Vs,print:js};function Js(e){return new Promise((e=>setTimeout(e))).then(e)}class Zs{constructor(e){if(!L().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(Zs.URL_SCHEME)&&(e=e.slice(Zs.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelJsonFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=hs(e,[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}]),r=window.URL.createObjectURL(new Blob([JSON.stringify(n)],{type:"application/json"})),s=null==this.modelJsonAnchor?document.createElement("a"):this.modelJsonAnchor;if(s.download=this.modelJsonFileName,s.href=r,await Js((()=>s.dispatchEvent(new MouseEvent("click")))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await Js((()=>e.dispatchEvent(new MouseEvent("click"))))}return{modelArtifactsInfo:ps(e)}}}}Zs.URL_SCHEME="downloads://";class Ys{constructor(e){if(null==e||e.length<1)throw new Error(`When calling browserFiles, at least 1 file is required, but received ${e}`);this.jsonFile=e[0],this.weightsFiles=e.slice(1)}async load(){return new Promise(((e,t)=>{const n=new FileReader;n.onload=n=>{const r=JSON.parse(n.target.result),s=r.modelTopology;if(null==s)return void t(new Error(`modelTopology field is missing from file ${this.jsonFile.name}`));if(null==r.weightsManifest)return void t(new Error(`weightManifest field is missing from file ${this.jsonFile.name}`));if(0===this.weightsFiles.length)return void e({modelTopology:s});const o=ds(r,(e=>this.loadWeights(e)));e(o)},n.onerror=e=>t(`Failed to read model topology and weights manifest JSON from file '${this.jsonFile.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),n.readAsText(this.jsonFile)}))}loadWeights(e){const t=[],n=[];for(const r of e)t.push(...r.weights),n.push(...r.paths);const r=this.checkManifestAndWeightFiles(e),s=n.map((e=>this.loadWeightsFile(e,r[e])));return Promise.all(s).then((e=>[t,us(e)]))}loadWeightsFile(e,t){return new Promise(((n,r)=>{const s=new FileReader;s.onload=e=>{const t=e.target.result;n(t)},s.onerror=t=>r(`Failed to weights data from file of path '${e}'.`),s.readAsArrayBuffer(t)}))}checkManifestAndWeightFiles(e){const t=[],n=this.weightsFiles.map((e=>cs(e.name))),r={};for(const s of e)s.paths.forEach((e=>{const s=cs(e);if(-1!==t.indexOf(s))throw new Error(`Duplicate file basename found in weights manifest: '${s}'`);if(t.push(s),-1===n.indexOf(s))throw new Error(`Weight file with basename '${s}' is not provided.`);r[e]=this.weightsFiles[n.indexOf(s)]}));if(t.length!==this.weightsFiles.length)throw new Error(`Mismatch in the number of files in weights manifest (${t.length}) and the number of weight files provided (${this.weightsFiles.length}).`);return r}}function Xs(e,t,n,r){!function(e){a(null!=e&&Array.isArray(e)&&e.length>0,(()=>"promises must be a none empty array"))}(e),function(e,t){a(e>=0&&e<=1,(()=>`Progress fraction must be in range [0, 1], but got startFraction ${e}`)),a(t>=0&&t<=1,(()=>`Progress fraction must be in range [0, 1], but got endFraction ${t}`)),a(t>=e,(()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction ${t}`))}(n=null==n?0:n,r=null==r?1:r);let s=0;return Promise.all(e.map((o=>(o.then((o=>{const a=n+ ++s/e.length*(r-n);return t(a),o})),o))))}async function Qs(e,t){null==t&&(t={});const n=null==t.fetchFunc?L().platform.fetch:t.fetchFunc,r=e.map((e=>n(e,t.requestInit,{isBinary:!0}))),s=(null==t.onProgress?await Promise.all(r):await Xs(r,t.onProgress,0,.5)).map((e=>e.arrayBuffer()));return null==t.onProgress?await Promise.all(s):await Xs(s,t.onProgress,.5,1)}function eo(e){return async(t,n="",r)=>{const s=t.map((()=>!1)),o={},a=null!=r?r.map((()=>!1)):[],i=[];if(t.forEach(((e,t)=>{let n=0;e.weights.forEach((e=>{const l="quantization"in e?e.quantization.dtype:e.dtype,u=ss[l]*c(e.shape),h=()=>{s[t]=!0,null==o[t]&&(o[t]=[]),o[t].push({manifestEntry:e,groupOffset:n,sizeBytes:u})};null!=r?r.forEach(((t,n)=>{t===e.name&&(h(),a[n]=!0)})):h(),i.push(e.name),n+=u}))})),!a.every((e=>e))){const e=r.filter(((e,t)=>!a[t]));throw new Error(`Could not find weights in manifest with names: ${e.join(", ")}. \nManifest JSON has weights with names: ${i.join(", ")}.`)}const l=s.reduce(((e,t,n)=>(t&&e.push(n),e)),[]),u=[];l.forEach((e=>{t[e].paths.forEach((e=>{const t=n+(n.endsWith("/")?"":"/")+e;u.push(t)}))}));const h=await e(u),d={};let p=0;return l.forEach((e=>{const n=t[e].paths.length;let r=0;for(let e=0;e<n;e++)r+=h[p+e].byteLength;const s=new ArrayBuffer(r),a=new Uint8Array(s);let i=0;for(let e=0;e<n;e++){const t=new Uint8Array(h[p+e]);a.set(t,i),i+=t.byteLength}o[e].forEach((e=>{const t=os(s.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)d[e]=t[e]})),p+=n})),d}}gs.registerSaveRouter((e=>L().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Zs.URL_SCHEME)?function(e="model"){return new Zs(e)}(e.slice(Zs.URL_SCHEME.length)):null));class to{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(a("function"==typeof t.fetchFunc,(()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)")),this.fetch=t.fetchFunc):this.fetch=L().platform.fetch,a(null!=e&&e.length>0,(()=>"URL path for http must not be null, undefined or empty.")),Array.isArray(e)&&a(2===e.length,(()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`)),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=hs(e,[{paths:["./model.weights.bin"],weights:e.weightSpecs}]);t.body.append("model.json",new Blob([JSON.stringify(n)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const r=await this.fetch(this.path,t);if(r.ok)return{modelArtifactsInfo:ps(e),responses:[r]};throw new Error(`BrowserHTTPRequest.save() failed due to HTTP response status ${r.status}.`)}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code ${e.status}. Please verify this URL points to the model JSON of the model to load.`);let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,r=t.weightsManifest;if(null==n&&null==r)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);return ds(t,(e=>this.loadWeights(e)))}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,r]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),r=e.substring(0,t),s=n>t?e.substring(n):"";return[r+"/",s]}(t),s=this.weightPathPrefix||n,o=[];for(const t of e)o.push(...t.weights);const a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(s+e+r);this.weightUrlConverter&&a.push(...await Promise.all(i));return[o,us(await Qs(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function no(e){return null!=e.match(to.URL_SCHEME_REGEX)}to.URL_SCHEME_REGEX=/^https?:\/\//;const ro=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every((e=>no(e))):no(e),n)return so(e,t)}return null};function so(e,t){return new to(e,t)}gs.registerSaveRouter(ro),gs.registerLoadRouter(ro);class oo{constructor(e){this.modelArtifacts=e}load(){return this.modelArtifacts}}class ao{constructor(e){this.saveHandler=e}save(e){return this.saveHandler(e)}}class io{constructor(e){e.load&&(this.load=()=>Promise.resolve(e.load())),e.save&&(this.save=t=>Promise.resolve(e.save(t)))}}function lo(e,t,n,r){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new oo(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new oo({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new oo({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:r})}var uo={__proto__:null,browserFiles:function(e){return new Ys(e)},browserHTTPRequest:function(e,t){return so(e,t)},concatenateArrayBuffers:us,decodeWeights:os,encodeWeights:async function(e,t){const n=[],r=[],s=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);for(let o=0;o<s.length;++o){const a=s[o],i=Array.isArray(e)?e[o].tensor:e[a];if("float32"!==i.dtype&&"int32"!==i.dtype&&"bool"!==i.dtype&&"string"!==i.dtype&&"complex64"!==i.dtype)throw new Error(`Unsupported dtype in weight '${a}': ${i.dtype}`);const l={name:a,shape:i.shape,dtype:i.dtype};if("string"===i.dtype){const e=new Promise((async e=>{const t=await i.bytes(),n=t.reduce(((e,t)=>e+t.length),0)+4*t.length,r=new Uint8Array(n);let s=0;for(let e=0;e<t.length;e++){const n=t[e],o=new Uint8Array(new Uint32Array([n.length]).buffer);r.set(o,s),s+=4,r.set(n,s),s+=n.length}e(r)}));r.push(e)}else r.push(i.data());null!=t&&(l.group=t),n.push(l)}return{data:as(await Promise.all(r)),specs:n}},fromMemory:function(e,t,n,r){const s=arguments;return new io(lo(...s))},fromMemorySync:lo,getLoadHandlers:(e,t)=>gs.getLoadHandlers(e,t),getModelArtifactsForJSON:ds,getModelArtifactsInfoForJSON:ps,getSaveHandlers:e=>gs.getSaveHandlers(e),http:so,isHTTPScheme:no,loadWeights:async function(e,t="",n,r){return eo((e=>Qs(e,{requestInit:r})))(e,t,n)},registerLoadRouter:e=>gs.registerLoadRouter(e),registerSaveRouter:e=>gs.registerSaveRouter(e),weightsLoaderFactory:eo,withSaveHandler:function(e){return new ao(e)},withSaveHandlerSync:function(e){return new ao(e)},copyModel:async function(e,t){return zs(e,t,!1)},listModels:async function(){const e=Os.getSchemes(),t={};for(const n of e){const e=await Os.getManager(n).listModels();for(const r in e){t[n+Ps+r]=e[r]}}return t},moveModel:async function(e,t){return zs(e,t,!0)},removeModel:async function(e){const t=Ls(e);return Os.getManager(t.scheme).removeModel(t.path)}};const co=es({matMul_:function(e,t,n=!1,r=!1){let s=Yr(e,"a","matMul"),o=Yr(t,"b","matMul");[s,o]=Rr(s,o);const a={a:s,b:o},i={transposeA:n,transposeB:r};return qr.runKernel(ne,a,i)}});const ho=es({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Yr(e,"indices","oneHot","int32")},o={depth:t,onValue:n,offValue:r};return qr.runKernel(mt,s,o)}});function po(e,t){return qr.tidy(e,t)}function fo(e){Fr(e).forEach((e=>e.dispose()))}function go(e){return qr.keep(e)}const mo=es({imag_:function(e){const t={input:Yr(e,"input","imag")};return qr.runKernel(Ue,t)}});const bo=es({neg_:function(e){const t={x:Yr(e,"x","neg")};return qr.runKernel("Neg",t)}});const yo=es({real_:function(e){const t={input:Yr(e,"input","real")};return qr.runKernel(xt,t)}});const wo=es({transpose_:function(e,t,n){const r=Yr(e,"x","transpose");if(null==t&&(t=r.shape.map(((e,t)=>t)).reverse()),a(r.rank===t.length,(()=>`Error in transpose: rank of input ${r.rank} must match length of perm ${t}.`)),t.forEach((e=>{a(e>=0&&e<r.rank,(()=>"All entries in 'perm' must be between 0 and "+(r.rank-1)+` but got ${t}`))})),r.rank<=1)return r.clone();const s={x:r},o={perm:t};return"complex64"===r.dtype?po((()=>{let e=yo(r),t=mo(r);return e=qr.runKernel(on,{x:e},o),t=qr.runKernel(on,{x:t},o),n&&(t=bo(t)),ts(e,t)})):qr.runKernel(on,s,o)}});var ko={__proto__:null,confusionMatrix:es({confusionMatrix_:function(e,t,n){const r=Yr(e,"labels","confusionMatrix"),s=Yr(t,"predictions","confusionMatrix");a(null==n||n>0&&Number.isInteger(n),(()=>`If provided, numClasses must be a positive integer, but got ${n}`)),a(1===r.rank,(()=>`Expected the rank of labels to be 1, but got ${r.rank}`)),a(1===s.rank,(()=>`Expected the rank of predictions to be 1, but got ${s.rank}`)),a(r.shape[0]===s.shape[0],(()=>`Mismatch in the number of examples: ${r.shape[0]} vs. ${s.shape[0]}. Labels and predictions should have the same number of elements.`)),a(n>0&&Number.isInteger(n),(()=>`numClasses is required to be a positive integer, but got ${n}`));const o=ho(Hs(r,"int32"),n),i=ho(Hs(s,"int32"),n),l=wo(o),u=co(l,i);return Hs(u,"int32")}})};function vo(e,t){const n=e.length,r=[];for(let s=0;s<n;s++){const o=n-1-s,a=e[o]||1;(t[t.length-1-s]||1)>1&&1===a&&r.unshift(o)}return r}function xo(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],o=t.length-r-1,a=t[o];(null==s||1===s&&a>1)&&n.unshift(o)}return n}function Eo(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let o=t[t.length-s-1];if(null==o&&(o=1),1===r)n.unshift(o);else if(1===o)n.unshift(r);else{if(r!==o){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}var So={__proto__:null,getBroadcastDims:vo,getReductionAxes:xo,assertAndGetBroadcastShape:Eo};function $o(e,t,n){if(l(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=jr(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return ns(e,t,r,n)}let Ao;function Io(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,r=!1,s=!1,o=!1,a=!1,i=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)r=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)s=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)o=!0;else if(null!=e.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error(`pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was ${e.constructor.name}`);i=!0}if(s){const t=2;if(s&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=kn(dn,qr.backendName)){const n={pixels:e},r={numChannels:t};return qr.runKernel(dn,n,r)}const[l,u]=s?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(a)c=e.getContext("2d").getImageData(0,0,l,u).data;else if(r||n)c=e.data;else if(o||s||i){if(null==Ao)if("undefined"==typeof document){if("undefined"==typeof OffscreenCanvas||"undefined"==typeof OffscreenCanvasRenderingContext2D)throw new Error("Cannot parse input in current context. Reason: OffscreenCanvas Context2D rendering is not supported.");Ao=new OffscreenCanvas(1,1).getContext("2d")}else Ao=document.createElement("canvas").getContext("2d",{willReadFrequently:!0});Ao.canvas.width=l,Ao.canvas.height=u,Ao.drawImage(e,0,0,l,u),c=Ao.getImageData(0,0,l,u).data}if(4===t)h=new Int32Array(c);else{const e=l*u;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return $o(h,[u,l,t],"int32")}function No(e){return"undefined"!=typeof window&&"undefined"!=typeof ImageBitmap&&window.hasOwnProperty("createImageBitmap")&&!(e instanceof ImageBitmap)&&function(e){return null!=e&&0!==e.width&&0!==e.height}(e)&&!function(e){return null!=e&&e.data instanceof Uint8Array}(e)}var _o={__proto__:null,fromPixelsAsync:async function(e,t=3){let n=null;if(L().getBool("WRAP_TO_IMAGEBITMAP")&&No(e)){let t;try{t=await createImageBitmap(e,{premultiplyAlpha:"none"})}catch(e){t=null}n=null!=t&&t.width===e.width&&t.height===e.height?t:e}else n=e;return Io(n,t)},toPixels:async function(e,t){let n=Yr(e,"img","toPixels");if(!(e instanceof Sr)){const e=n;n=Hs(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[r,s]=n.shape.slice(0,2),o=2===n.rank?1:n.shape[2];if(o>4||2===o)throw new Error(`toPixels only supports depth of size 1, 3 or 4 but got ${o}`);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const a=await n.data(),i="float32"===n.dtype?255:1,l=new Uint8ClampedArray(s*r*4);for(let e=0;e<r*s;++e){const t=[0,0,0,255];for(let r=0;r<o;r++){const s=a[e*o+r];if("float32"===n.dtype){if(s<0||s>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${s}.`)}else if("int32"===n.dtype&&(s<0||s>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${s}.`);1===o?(t[0]=s*i,t[1]=s*i,t[2]=s*i):t[r]=s*i}const r=4*e;l[r+0]=Math.round(t[0]),l[r+1]=Math.round(t[1]),l[r+2]=Math.round(t[2]),l[r+3]=Math.round(t[3])}if(null!=t){t.width=s,t.height=r;const e=t.getContext("2d"),n=new ImageData(l,s,r);e.putImageData(n,0,0)}return n!==e&&n.dispose(),l},fromPixels:es({fromPixels_:Io})};function Mo(e,t){const n=e.shape.length,r=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(r<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${r}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[r-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[r-1]} vs. ${n}`);if(0===c(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const s=t.shape,o=s[s.length-1];let a=1;for(let e=0;e<s.length-1;++e)a*=s[e];const i=e.shape,l=s.slice();l.pop();let u=1;for(let e=o;e<n;++e)u*=i[e],l.push(i[e]);const h=[..._(e.shape).map((e=>e/u)),1].slice(0,o);return[l,a,u,h]}var To={__proto__:null,prepareAndValidate:Mo};function Do(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,o=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(o+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(o+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(o+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(o+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(o+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}function Ro(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}Do(n,t,e)}function Bo(e,t,n){const r=t.shape.length,s=r>1?t.shape[r-1]:1,o=n.length;let a=1;for(let e=s;e<o;++e)a*=n[e];const i=s<1?1:s;return{sliceRank:s,numUpdates:c(t.shape)/i,sliceSize:a,strides:[..._(n.slice(0,s)),1],outputSize:c(n)}}var Fo={__proto__:null,validateUpdateShape:Do,validateInput:Ro,calculateShapes:Bo};function Co(e,t,n,r){const s=[...e];for(let e=s.length;e<r.length;e++)s.push(1);for(let e=0;e<n;e++)0===e?s[t]=1:(s.splice(t,0,1),s.pop());return s}function Po(e,t,n){return n<=e?n:n-(t-1)}function Oo(e,t){const n=[];for(let r=0;r<e;r++)n.push(t+r);return n}function Lo(e,t,n,r,s){const o=[...s],a=Oo(n,t);for(let s=0;s<o.length;s++)if(a.indexOf(s)>-1)o[s]=0;else{const a=Po(t,n,s);let i=r[a];e&1<<a&&(i=0),o[s]=i}return o}function zo(e,t,n,r,o){const a=[...o],i=Oo(n,t);for(let s=0;s<a.length;s++)if(i.indexOf(s)>-1)a[s]=Number.MAX_SAFE_INTEGER;else{const o=Po(t,n,s);let i=r[o];e&1<<o&&(i=Number.MAX_SAFE_INTEGER),a[s]=i}for(let e=0;e<a.length;e++){const t=o[e];a[e]<0&&(a[e]+=t),a[e]=s(0,a[e],o[e])}return a}function Wo(e,t,n){let r=e[t];return(n&1<<t||null==r)&&(r=1),r}function qo(e,t,n,r,o,a){let i=t[o];const l=n[o]||1;(e&1<<o||a&1<<o||null==i)&&(i=l>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const u=r[o];return i<0&&(i+=u),i=s(0,i,u-1),i}function Ko(e,t,n,r,o,a){let i=t[o];const l=n[o]||1;(e&1<<o||a&1<<o||null==i)&&(i=l>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const u=r[o];return i<0&&(i+=u),i=l>0?s(0,i,u):s(-1,i,u-1),i}function Uo(e,t,n,r,s,o){if(s[t])return n>0?o[t]:o[t+1&1];{const t=e<0?r+e:e;return t<o[0]?o[0]:t>o[1]?o[1]:t}}var Go={__proto__:null,assertParamsValid:function(e,t,n){const r=e.shape.length;a(r===t.length,(()=>`Error in slice${r}D: Length of begin ${t} must match the rank of the array (${r}).`)),a(r===n.length,(()=>`Error in slice${r}D: Length of size ${n} must match the rank of the array (${r}).`));for(let s=0;s<r;++s)a(t[s]+n[s]<=e.shape[s],(()=>`Error in slice${r}D: begin[${s}] + size[${s}] (${t[s]+n[s]}) would overflow input.shape[${s}] (${e.shape[s]})`))},maskToAxes:function(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t},computeOutShape:function(e,t,n){const r=[];for(let s=0;s<e.length;s++)r[s]=Math.ceil((t[s]-e[s])/n[s]);return r},stridesWithElidedDims:Co,getNormalizedAxes:function(e,t,n,r,s,o,a,i,l){const u=e.length;let c=new Array(u),h=new Array(u),d=new Array(u);if(t.length&&n>0){const l=t[0],u=n+1;c=Lo(a,l,u,r,e),h=zo(i,l,u,s,e),d=Co(o,l,u,e)}else for(let t=0;t<u;t++)c[t]=qo(a,r,o,e,t,l),h[t]=Ko(i,s,o,e,t,l),d[t]=Wo(o,t,l);return{begin:c,end:h,strides:d}},startIndicesWithElidedDims:Lo,stopIndicesWithElidedDims:zo,stridesForAxis:Wo,startForAxis:qo,stopForAxis:Ko,isSliceContinous:function(e,t,n){let r=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){r=e;break}for(let s=r+1;s<n.length;s++)if(t[s]>0||n[s]!==e[s])return!1;return!0},computeFlatOffset:function(e,t){let n=e.length>0?e[e.length-1]:1;for(let r=0;r<e.length-1;r++)n+=e[r]*t[r];return n},parseSliceParams:function(e,t,n){let r;const s=e.shape.length;let o;return r="number"==typeof t?[t,...new Array(s-1).fill(0)]:t.length<s?t.concat(new Array(s-t.length).fill(0)):t.slice(),r.forEach((e=>{a(-1!==e,(()=>"slice() does not support negative begin indexing."))})),o=null==n?new Array(s).fill(-1):"number"==typeof n?[n,...new Array(s-1).fill(-1)]:n.length<s?n.concat(new Array(s-n.length).fill(-1)):n,o=o.map(((t,n)=>t>=0?t:(a(-1===t,(()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`)),e.shape[n]-r[n]))),[r,o]},sliceInfo:function(e,t,n,r,s,o,a,i,l){let u;if(null==r?(u=new Array(t.length),u.fill(1)):u=r,null!=a&&0!=(a&a-1))throw new Error("Multiple ellipses in slice is not allowed.");let c=!1;const h={dims:u.length,numAddAxisAfterEllipsis:0,begin:t.slice(),end:n.slice(),strides:u.slice(),beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};for(let e=0;e<h.dims;e++)c&&0!=(1<<e&i)&&h.numAddAxisAfterEllipsis++,1<<e&a&&(c=!0);c||(h.ellipsisMask|=1<<h.dims,h.dims++);const d={dims:e.length,beginMask:0,endMask:0,beginValid:!1,endValid:!1};!function(e,t){t.beginMask=0,t.endMask=0,t.shrinkAxisMask=0;let n=0;t.beginValid=null!=e.begin,t.endValid=null!=e.end,t.begin=new Array(t.dims),t.end=new Array(t.dims),t.strides=new Array(t.dims),t.finalShapeGatherIndices=[],t.finalShapeGatherIndicesSparse=[],t.inputShapeGatherIndicesSparse=new Array(t.dims);for(let r=0;r<e.dims;r++)if(1<<r&e.ellipsisMask){const s=Math.min(t.dims-(e.dims-r)+1+e.numAddAxisAfterEllipsis,t.dims);for(;n<s;n++)t.begin[n]=0,t.end[n]=0,t.strides[n]=1,t.beginMask|=1<<n,t.endMask|=1<<n,t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(-1),t.inputShapeGatherIndicesSparse[n]=r}else if(1<<r&e.newAxisMask)t.finalShapeGatherIndices.push(-2),t.finalShapeGatherIndicesSparse.push(-1);else{if(n===t.begin.length)throw Error(`Index out of range using input dim ${n}; input has only ${t.dims} dims, ${t.begin.length}.`);null!=e.begin&&(t.begin[n]=e.begin[r]),null!=e.end&&(t.end[n]=e.end[r]),t.strides[n]=e.strides[r],e.beginMask&1<<r&&(t.beginMask|=1<<n),e.endMask&1<<r&&(t.endMask|=1<<n),e.shrinkAxisMask&1<<r?(t.finalShapeGatherIndices.push(-1),t.finalShapeGatherIndicesSparse.push(-1),t.shrinkAxisMask|=1<<n):(t.finalShapeGatherIndices.push(n),t.finalShapeGatherIndicesSparse.push(r)),t.inputShapeGatherIndicesSparse[n]=r,n++}}(h,d);let p=!0,f=!0,g=!0;const m=[],b=[];for(let t=0;t<e.length;++t){if(0===d.strides[t])throw Error(`strides[${t}] must be non-zero`);const n=!!(d.shrinkAxisMask&1<<t),r=e[t];if(-1===r){m.push(n?1:-1);continue}const s=[d.beginMask&1<<t,d.endMask&1<<t],o=[d.strides[t]>0?0:-1,d.strides[t]>0?r:r-1];if(n&&d.strides[t]<=0)throw Error("only stride 1 allowed on non-range indexing.");g=g&&1===d.strides[t];const a=!!(d.beginMask&1<<t&&d.endMask&1<<t);if(d.beginValid&&d.endValid){if(n){const e=d.begin[t]<0?r+d.begin[t]:d.begin[t];if(d.begin[t]=e,d.end[t]=d.begin[t]+1,e<0||e>=r)throw Error(`slice index ${d.begin[t]} of dimension ${t} out of bounds.`)}else d.begin[t]=Uo(d.begin[t],0,d.strides[t],r,s,o),d.end[t]=Uo(d.end[t],1,d.strides[t],r,s,o);const e=1===d.strides[t]&&0===d.begin[t]&&d.end[t]===r;p=p&&e,f=f&&(0===t&&1===d.strides[t]||e)}else p=p&&1===d.strides[t]&&a,f=f&&(0===t&&1===d.strides[t]||a);let i,l=!1;if(d.beginValid&&d.endValid?(i=d.end[t]-d.begin[t],l=!0):n?(i=1,l=!0):a&&r>=0&&(i=d.strides[t]<0?-r:r,l=!0),l){let e;e=0===i||i<0!=d.strides[t]<0?0:Math.trunc(i/d.strides[t])+(i%d.strides[t]!=0?1:0),m.push(e)}else m.push(-1)}for(let e=0;e<d.finalShapeGatherIndices.length;++e){const t=d.finalShapeGatherIndices[e];t>=0?b.push(m[t]):-2===t&&b.push(1)}return{finalShapeSparse:b.filter(((e,t)=>-2!==d.finalShapeGatherIndices[t])),finalShape:b,isIdentity:p,sliceDim0:f,isSimpleSlice:g,begin:d.begin,end:d.end,strides:d.strides}}};class Ho{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class Vo{constructor(){this.classNameMap={}}static getMap(){return null==Vo.instance&&(Vo.instance=new Vo),Vo.instance}static register(e){Vo.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function jo(e){a(null!=e.className,(()=>"Class being registered does not have the static className property defined.")),a("string"==typeof e.className,(()=>"className is required to be a string, but got type "+typeof e.className)),a(e.className.length>0,(()=>"Class being registered has an empty-string as its className, which is disallowed.")),Vo.register(e)}var Jo={__proto__:null,Serializable:Ho,SerializationMap:Vo,registerClass:jo};function Zo(){return 32===qr.backend.floatPrecision()?.001:.1}function Yo(e,t,n){let r=!0;if((k(e)||k(t))&&(r=!1),k(e)&&k(t)&&(r=!0),r){const n=e.constructor.name,r=t.constructor.name;if(n!==r)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: ${r}`)}if(Array.isArray(e)&&Array.isArray(t)){const n=jr(e),r=jr(t);if(!h(n,r))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${r}]`)}const s=k(e)?e:u(e),o=k(t)?t:u(t);if(s.length!==o.length)throw new Error(`Arrays have different lengths actual: ${s.length} vs expected: ${o.length}.\nActual:   ${s}.\nExpected: ${o}.`);for(let e=0;e<o.length;++e){const t=s[e],r=o[e];if(!n(t,r))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${r}.\nActual:   ${s}.\nExpected: ${o}.`)}}function Xo(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var Qo={__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=Zo()),Yo(e,t,((e,t)=>Xo(e,t,n)))},testEpsilon:Zo,expectPromiseToFail:function(e,t){e().then((()=>t.fail()),(()=>t()))},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return E(e)||E(e[0])||E(t)||E(t[0])?Yo(e,n,((e,t)=>e==t)):Yo(e,t,((e,t)=>Xo(e,t,0)))},expectNumbersClose:function(e,t,n){if(null==n&&(n=Zo()),!Xo(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)},expectValuesInRange:function(e,t,n){for(let r=0;r<e.length;r++)if(e[r]<t||e[r]>n)throw new Error(`Value out of range:${e[r]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){const n=new Float32Array(e),r=new Float32Array(t);if(n.length!==r.length)throw new Error(`Expected ArrayBuffer to be of length ${r.length}, but it was ${n.length}`);for(let e=0;e<r.length;e++)if(n[e]!==r[e])throw new Error(`Expected ArrayBuffer value at ${e} to be ${r[e]} but got ${n[e]} instead`)},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const r=t[n];Array.isArray(r)?e(r):t[n]=cr(r)}return t}};const ea=es({add_:function(e,t){let n=Yr(e,"a","add"),r=Yr(t,"b","add");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel(G,s)}});const ta=es({floorDiv_:function(e,t){let n=Yr(e,"a","floorDiv"),r=Yr(t,"b","floorDiv");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel(Ce,s)}});const na=es({div_:function(e,t){let n=Yr(e,"a","div"),r=Yr(t,"b","div");if([n,r]=Rr(n,r),"int32"===n.dtype&&"int32"===r.dtype)return ta(n,r);const s={a:n,b:r};return qr.runKernel(Ne,s,{})}});const ra=es({mul_:function(e,t){let n=Yr(e,"a","mul"),r=Yr(t,"b","mul");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel(ct,s)}});const sa=es({abs_:function(e){const t=Yr(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return qr.runKernel(ce,e)}{const e={x:t};return qr.runKernel("Abs",e)}}});const oa=es({acos_:function(e){const t={x:Yr(e,"x","acos")};return qr.runKernel(K,t)}});const aa=es({acosh_:function(e){const t={x:Yr(e,"x","acosh")};return qr.runKernel(U,t)}});const ia=es({addN_:function(e){a(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),a(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Yr(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!h(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return qr.runKernel(H,r)}});const la=es({all_:function(e,t=null,n=!1){const r={x:Yr(e,"x","all","bool")},s={axis:t,keepDims:n};return qr.runKernel("All",r,s)}});const ua=es({any_:function(e,t=null,n=!1){const r={x:Yr(e,"x","any","bool")},s={axis:t,keepDims:n};return qr.runKernel("Any",r,s)}});const ca=es({argMax_:function(e,t=0){const n={x:Yr(e,"x","argMax")},r={axis:t};return qr.runKernel(V,n,r)}});const ha=es({argMin_:function(e,t=0){const n={x:Yr(e,"x","argMin")},r={axis:t};return qr.runKernel(j,n,r)}});const da=es({asin_:function(e){const t={x:Yr(e,"x","asin")};return qr.runKernel(J,t)}});const pa=es({asinh_:function(e){const t={x:Yr(e,"x","asinh")};return qr.runKernel(Z,t)}});const fa=es({atan_:function(e){const t={x:Yr(e,"x","atan")};return qr.runKernel(Y,t)}});const ga=es({atan2_:function(e,t){let n=Yr(e,"a","atan2"),r=Yr(t,"b","atan2");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel(Q,s)}});const ma=es({atanh_:function(e){const t={x:Yr(e,"x","atanh")};return qr.runKernel(X,t)}});function ba(e,t,n,r,s,o,a="channelsLast"){const[i,l]=va(t);let u;if("channelsLast"===a)u=[i,l,e[3],e[3]];else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);u=[i,l,e[1],e[1]]}return ya(e,u,n,r,s,o,!1,a)}function ya(e,t,n,r,s,o,a=!1,i="channelsLast"){let[l,u,c,h]=[-1,-1,-1,-1];if("channelsLast"===i)[l,u,c,h]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[l,h,u,c]=e}const[d,p,,f]=t,[g,m]=va(n),[b,y]=va(r),w=Ea(d,b),k=Ea(p,y),{padInfo:v,outHeight:x,outWidth:E}=function(e,t,n,r,s,o,a,i,l){let u,c,h;if("number"==typeof e){u={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=ka(e,t,n));const o=e[0],a=e[1],i=Sa((o-t+2*r)/n+1,s),l=Sa((a-t+2*r)/n+1,s);return[i,l]}([t,n],o,r,e,i);c=s[0],h=s[1]}else if("same"===e){c=Math.ceil(t/r),h=Math.ceil(n/s);const e=Math.max(0,(c-1)*r+o-t),i=Math.max(0,(h-1)*s+a-n),l=Math.floor(e/2),d=e-l,p=Math.floor(i/2);u={top:l,bottom:d,left:p,right:i-p,type:"SAME"}}else if("valid"===e)u={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-o+1)/r),h=Math.ceil((n-a+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const d="channelsLast"===l?e[1][0]:e[2][0],p="channelsLast"===l?e[1][1]:e[2][1],f="channelsLast"===l?e[2][0]:e[3][0],g="channelsLast"===l?e[2][1]:e[3][1];u={top:d,bottom:p,left:f,right:g,type:0===d&&0===p&&0===f&&0===g?"VALID":"EXPLICIT"},c=Sa((t-o+d+p)/r+1,i),h=Sa((n-a+f+g)/s+1,i)}}return{padInfo:u,outHeight:c,outWidth:h}}(s,u,c,g,m,w,k,o,i),S=a?f*h:f;let $;return"channelsFirst"===i?$=[l,S,x,E]:"channelsLast"===i&&($=[l,x,E,S]),{batchSize:l,dataFormat:i,inHeight:u,inWidth:c,inChannels:h,outHeight:x,outWidth:E,outChannels:S,padInfo:v,strideHeight:g,strideWidth:m,filterHeight:d,filterWidth:p,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:e,outShape:$,filterShape:t}}function wa(e,t,n,r,s,o=!1,a="channelsLast",i){let[l,u,c,h,d]=[-1,-1,-1,-1,-1];if("channelsLast"===a)[l,u,c,h,d]=e;else{if("channelsFirst"!==a)throw new Error(`Unknown dataFormat ${a}`);[l,d,u,c,h]=e}const[p,f,g,,m]=t,[b,y,w]=xa(n),[k,v,x]=xa(r),E=Ea(p,k),S=Ea(f,v),$=Ea(g,x),{padInfo:A,outDepth:I,outHeight:N,outWidth:_}=function(e,t,n,r,s,o,a,i,l,u,c){let h,d,p,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const o=function(e,t,n,r,s,o){null==s&&(s=ka(e,t,r));const a=e[0],i=e[1],l=e[2],u=Sa((a-t+2*s)/r+1,o),c=Sa((i-t+2*s)/r+1,o),h=Sa((l-t+2*s)/r+1,o);return[u,c,h,n]}([t,n,r,1],i,1,s,e,c);d=o[0],p=o[1],f=o[2]}else if("same"===e){d=Math.ceil(t/s),p=Math.ceil(n/o),f=Math.ceil(r/a);const e=(d-1)*s+i-t,c=(p-1)*o+l-n,g=(f-1)*a+u-r,m=Math.floor(e/2),b=e-m,y=Math.floor(c/2),w=c-y,k=Math.floor(g/2);h={top:y,bottom:w,left:k,right:g-k,front:m,back:b,type:"SAME"}}else{if("valid"!==e)throw Error(`Unknown padding parameter: ${e}`);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((t-i+1)/s),p=Math.ceil((n-l+1)/o),f=Math.ceil((r-u+1)/a)}return{padInfo:h,outDepth:d,outHeight:p,outWidth:f}}(s,u,c,h,b,y,w,E,S,$,i),M=o?m*d:m;let T;return"channelsFirst"===a?T=[l,M,I,N,_]:"channelsLast"===a&&(T=[l,I,N,_,M]),{batchSize:l,dataFormat:a,inDepth:u,inHeight:c,inWidth:h,inChannels:d,outDepth:I,outHeight:N,outWidth:_,outChannels:M,padInfo:A,strideDepth:b,strideHeight:y,strideWidth:w,filterDepth:p,filterHeight:f,filterWidth:g,effectiveFilterDepth:E,effectiveFilterHeight:S,effectiveFilterWidth:$,dilationDepth:k,dilationHeight:v,dilationWidth:x,inShape:e,outShape:T,filterShape:t}}function ka(e,t,n,r=1){const s=Ea(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}function va(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function xa(e){return"number"==typeof e?[e,e,e]:e}function Ea(e,t){return t<=1?e:e+(e-1)*(t-1)}function Sa(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function $a(e){const[t,n,r]=va(e);return 1===t&&1===n&&1===r}function Aa(e,t){return $a(e)||$a(t)}function Ia(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error(`Unknown dataFormat ${e}`)}function Na(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)a(d(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{a(d(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const _a=es({reshape_:function(e,t){const n={x:Yr(e,"x","reshape","string_or_numeric")},r={shape:t};return qr.runKernel($t,n,r)}});const Ma=es({avgPool_:function(e,t,n,r,s){const o=Yr(e,"x","avgPool","float32");a(Aa(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let i=o,l=!1;3===o.rank&&(l=!0,i=_a(o,[1,o.shape[0],o.shape[1],o.shape[2]])),a(4===i.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`)),Na("avgPool",r,s);const u={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let h=qr.runKernel(ee,u,c);return h=Hs(h,o.dtype),l?_a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Ta=es({avgPool3d_:function(e,t,n,r,s,o="NDHWC"){const i=Yr(e,"x","avgPool3d","float32");let l=i,u=!1;4===i.rank&&(u=!0,l=_a(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===l.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${l.rank}.`)),a("NDHWC"===o,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Na("avgPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o};let d=qr.runKernel(te,c,h);return d=Hs(d,l.dtype),u?_a(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const Da=es({concat_:function(e,t=0){a(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=Xr(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return Vs(n[0]);const r=n,s={axis:t};return qr.runKernel(he,r,s)}});const Ra=es({sigmoid_:function(e){const t={x:Yr(e,"x","sigmoid","float32")};return qr.runKernel(Lt,t)}});const Ba=es({slice_:function(e,t,n){const r=Yr(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},o={begin:t,size:n};return qr.runKernel(Ct,s,o)}});const Fa=es({tanh_:function(e){const t={x:Yr(e,"x","tanh","float32")};return qr.runKernel(tn,t)}});const Ca=es({basicLSTMCell_:function(e,t,n,r,s,o){const a=Yr(e,"forgetBias","basicLSTMCell"),i=Yr(t,"lstmKernel","basicLSTMCell"),l=Yr(n,"lstmBias","basicLSTMCell"),u=Yr(r,"data","basicLSTMCell"),c=Yr(s,"c","basicLSTMCell"),h=Yr(o,"h","basicLSTMCell"),d=Da([u,h],1),p=co(d,i),f=ea(p,l),g=f.shape[0],m=f.shape[1]/4,b=[g,m],y=Ba(f,[0,0],b),w=Ba(f,[0,m],b),k=Ba(f,[0,2*m],b),v=Ba(f,[0,3*m],b),x=ea(ra(Ra(y),Fa(w)),ra(c,Ra(ea(a,k))));return[x,ra(Fa(x),Ra(v))]}});const Pa=es({batchToSpaceND_:function(e,t,n){const r=Yr(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));a(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),a(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),a(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const o={x:r},i={blockShape:t,crops:n};return qr.runKernel(re,o,i)}});const Oa=es({batchNorm_:function(e,t,n,r,s,o){null==o&&(o=.001);const i=Yr(e,"x","batchNorm"),l=Yr(t,"mean","batchNorm"),u=Yr(n,"variance","batchNorm");let c,h;null!=s&&(c=Yr(s,"scale","batchNorm")),null!=r&&(h=Yr(r,"offset","batchNorm")),a(l.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),a(null==h||l.rank===h.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),a(null==c||l.rank===c.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const d=function(e){let t;return t=0===e.rank||1===e.rank?_a(e,[1,1,1,e.size]):2===e.rank?_a(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?_a(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),p={x:d,scale:c,offset:h,mean:l,variance:u},f={varianceEpsilon:o},g=qr.runKernel(Pe,p,f);return _a(g,i.shape)}});const La=es({batchNorm2d_:function(e,t,n,r,s,o){const i=Yr(e,"x","batchNorm"),l=Yr(t,"mean","batchNorm"),u=Yr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Yr(s,"scale","batchNorm")),null!=r&&(h=Yr(r,"offset","batchNorm")),a(2===i.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${i.rank}.`)),a(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${l.rank}.`)),a(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(2===c.rank||1===c.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(2===h.rank||1===h.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`)),Oa(i,l,u,h,c,o)}});const za=es({batchNorm3d_:function(e,t,n,r,s,o){const i=Yr(e,"x","batchNorm"),l=Yr(t,"mean","batchNorm"),u=Yr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Yr(s,"scale","batchNorm")),null!=r&&(h=Yr(r,"offset","batchNorm")),a(3===i.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${i.rank}.`)),a(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${l.rank}.`)),a(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(3===c.rank||1===c.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(3===h.rank||1===h.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`)),Oa(i,l,u,h,c,o)}});const Wa=es({batchNorm4d_:function(e,t,n,r,s,o){const i=Yr(e,"x","batchNorm"),l=Yr(t,"mean","batchNorm"),u=Yr(n,"variance","batchNorm");let c,h;return null!=s&&(c=Yr(s,"scale","batchNorm")),null!=r&&(h=Yr(r,"offset","batchNorm")),a(4===i.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${i.rank}.`)),a(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${l.rank}.`)),a(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=c&&a(4===c.rank||1===c.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`)),null!=h&&a(4===h.rank||1===h.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`)),Oa(i,l,u,h,c,o)}});const qa=es({bincount_:function(e,t,n){const r=Yr(e,"x","bincount"),s=Yr(t,"weights","bincount");a("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),a(n>=0,(()=>`size must be non-negative, but got ${n}.`)),a(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const o={x:r,weights:s},i={size:n};return qr.runKernel(se,o,i)}});const Ka=es({broadcastArgs_:function(e,t){const n=Yr(e,"s0","broadcastArgs","int32"),r=Yr(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return qr.runKernel(oe,s)}});const Ua=es({broadcastTo_:function(e,t){let n=Yr(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=_a(n,e)}const s=n.shape,o=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])o[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===o.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return Vs(n);const a={x:n},i={reps:o};return qr.runKernel(nn,a,i)}});const Ga=es({ceil_:function(e){const t={x:Yr(e,"x","ceil","float32")};return qr.runKernel(ie,t)}});const Ha=es({clipByValue_:function(e,t,n){const r=Yr(e,"x","clipByValue");a(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},o={clipValueMin:t,clipValueMax:n};return qr.runKernel(le,s,o)}});const Va=es({concat1d_:function(e){return Da(e,0)}});const ja=es({concat2d_:function(e,t){return Da(e,t)}});const Ja=es({concat3d_:function(e,t){return Da(e,t)}});const Za=es({concat4d_:function(e,t){return Da(e,t)}});const Ya=es({conv2d_:function(e,t,n,r,s="NHWC",o=[1,1],i){const l=Yr(e,"x","conv2d","float32"),u=Yr(t,"filter","conv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=_a(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(4===c.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`)),a(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),Na("conv2d",r,i);const d="NHWC"===s?c.shape[3]:c.shape[1];a(d===u.shape[2],(()=>`Error in conv2d: depth of input (${d}) must match input depth for filter ${u.shape[2]}.`)),a(Aa(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const p={x:c,filter:u},f={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i},g=qr.runKernel(de,p,f);return h?_a(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Xa=es({conv1d_:function(e,t,n,r,s="NWC",o=1,i){const l=Yr(e,"x","conv1d"),u=Yr(t,"filter","conv1d");let c=l,h=!1;2===l.rank&&(h=!0,c=_a(l,[1,l.shape[0],l.shape[1]])),a(3===c.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`)),a(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),Na("conv1d",r,i),a(c.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),a(Aa(n,o),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${o}'`)),a("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const d=_a(u,[1,u.shape[0],u.shape[1],u.shape[2]]),p=_a(c,[c.shape[0],1,c.shape[1],c.shape[2]]),f=Ya(p,d,[1,n],r,"NHWC",[1,o],i);return _a(f,h?[f.shape[2],f.shape[3]]:[f.shape[0],f.shape[2],f.shape[3]])}});const Qa=es({conv2DBackpropInput_:function(e,t,n,r,s,o="NHWC",i){a(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let l=e,u=t,c=!1;3===t.rank&&(c=!0,u=_a(t,[1,t.shape[0],t.shape[1],t.shape[2]]),l=[1,e[0],e[1],e[2]]),a(4===l.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${l.length}.`)),a(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),a(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const h="NHWC"===o?l[3]:l[1],d="NHWC"===o?u.shape[3]:u.shape[1];a(h===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${h}) must match input depth for filter ${n.shape[2]}.`)),a(d===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${d}) must match output depth for filter ${n.shape[3]}.`)),Na("conv2dDerInput",s,i);const p={dy:u,filter:n},f={strides:r,pad:s,dataFormat:o,dimRoundingMode:i,inputShape:l},g=qr.runKernel(fe,p,f);return c?_a(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const ei=es({conv2dTranspose_:function(e,t,n,r,s,o){const a=Yr(e,"x","conv2dTranspose"),i=Yr(t,"filter","conv2dTranspose");return Qa(n,a,i,r,s,"NHWC",o)}});const ti=es({conv3d_:function(e,t,n,r,s="NDHWC",o=[1,1,1]){const i=Yr(e,"x","conv3d"),l=Yr(t,"filter","conv3d");let u=i,c=!1;4===i.rank&&(c=!0,u=_a(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),a(5===l.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${l.rank}.`)),a(u.shape[4]===l.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${l.shape[3]}.`)),a(Aa(n,o),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),a("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const h={x:u,filter:l},d={strides:n,pad:r,dataFormat:s,dilations:o},p=qr.runKernel(ge,h,d);return c?_a(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const ni=es({conv3DBackpropInput_:function(e,t,n,r,s){a(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let o=e,i=t,l=!1;4===t.rank&&(l=!0,i=_a(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),o=[1,e[0],e[1],e[2],e[3]]);const u=o[4],c=i.shape[4];a(5===o.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${o.length}.`)),a(5===i.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${i.rank}`)),a(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),a(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),a(c===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`));const h={dy:i,filter:n},d={pad:s,strides:r,inputShape:o},p=qr.runKernel(me,h,d);return l?_a(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const ri=es({conv3dTranspose_:function(e,t,n,r,s){const o=Yr(e,"x","conv3dTranspose"),a=Yr(t,"filter","conv3dTranspose");return ni(n,o,a,r,s)}});const si=es({cos_:function(e){const t={x:Yr(e,"x","cos","float32")};return qr.runKernel("Cos",t)}});const oi=es({cosh_:function(e){const t={x:Yr(e,"x","cosh","float32")};return qr.runKernel(be,t)}});const ai=es({cumprod_:function(e,t=0,n=!1,r=!1){const s={x:Yr(e,"x","cumprod")},o={axis:t,exclusive:n,reverse:r};return qr.runKernel(ye,s,o)}});const ii=es({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Yr(e,"x","cumsum")},o={axis:t,exclusive:n,reverse:r};return qr.runKernel(we,s,o)}});const li=es({denseBincount_:function(e,t,n,r=!1){const s=Yr(e,"x","denseBincount"),o=Yr(t,"weights","denseBincount");a("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),a(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),a(n>=0,(()=>`size must be non-negative, but got ${n}.`)),a(o.size===s.size||0===o.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${o.shape}.`));const i={x:s,weights:o},l={size:n,binaryOutput:r};return qr.runKernel(ve,i,l)}});const ui=es({depthToSpace_:function(e,t,n="NHWC"){const r=Yr(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],o="NHWC"===n?r.shape[2]:r.shape[3],i="NHWC"===n?r.shape[3]:r.shape[1];a(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),a(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),a(o*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${o} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),a(i%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${r.shape}`));const l={x:r},u={blockSize:t,dataFormat:n};return qr.runKernel(xe,l,u)}});const ci=es({depthwiseConv2d_:function(e,t,n,r,s="NHWC",o=[1,1],i){const l=Yr(e,"x","depthwiseConv2d","float32"),u=Yr(t,"filter","depthwiseConv2d","float32");let c=l,h=!1;3===l.rank&&(h=!0,c=_a(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(4===c.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`)),a(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`));const d="NHWC"===s?c.shape[3]:c.shape[1];a(d===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${d}) must match the inChannels dimension in filter ${u.shape[2]}.`)),Na("depthwiseConv2d",r,i);const p={x:c,filter:u},f={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i},g=qr.runKernel(Ee,p,f);return h?_a(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const hi=es({diag_:function(e){const t={x:Yr(e,"x","diag")};return qr.runKernel(Ae,t)}});const di=es({dilation2d_:function(e,t,n,r,s=[1,1],o="NHWC"){const i=Yr(e,"x","dilation2d"),l=Yr(t,"filter","dilation2d");a(3===i.rank||4===i.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${i.rank}.`)),a(3===l.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${l.rank}.`)),a("NHWC"===o,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${o}`));let u=i,c=!1;3===i.rank&&(u=_a(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:u,filter:l},d={strides:n,pad:r,dilations:s},p=qr.runKernel(Ie,h,d);return c?_a(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const pi=es({equal_:function(e,t){let n=Yr(e,"a","equal","string_or_numeric"),r=Yr(t,"b","equal","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(Me,s)}});const fi=es({where_:function(e,t,n){const r=Yr(t,"a","where"),s=Yr(n,"b","where"),o=Yr(e,"condition","where","bool"),a=Eo(Eo(o.shape,r.shape),s.shape),i={condition:Ua(o,a),t:Ua(r,a),e:Ua(s,a)};return qr.runKernel(Bt,i)}});const gi=es({zerosLike_:function(e){const t={x:Yr(e,"x","zerosLike")};return qr.runKernel(cn,t)}});const mi=es({divNoNan_:function(e,t){let n=Yr(e,"a","div"),r=Yr(t,"b","div");[n,r]=Rr(n,r);const s=na(n,r),o=gi(s),a=pi(r,o);return fi(a,o,s)}});const bi=es({dot_:function(e,t){const n=Yr(e,"t1","dot"),r=Yr(t,"t2","dot");a(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],o=1===r.rank?r.size:r.shape[0];if(a(s===o,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${o}.`)),1===n.rank&&1===r.rank){const e=_a(n,[1,-1]),t=_a(r,[-1,1]),s=co(e,t);return _a(s,[])}if(1===n.rank&&2===r.rank){const e=_a(n,[1,-1]),t=_a(r,[r.shape[0],r.shape[1]]),s=co(e,t);return _a(s,[s.size])}if(2===n.rank&&1===r.rank){const e=_a(r,[-1,1]),t=co(n,e);return _a(t,[t.size])}{const e=_a(r,[r.shape[0],r.shape[1]]);return co(n,e)}}});const yi=es({einsum_:function(e,...t){const n=t.map(((e,t)=>Yr(e,`tensors${t}`,"einsum"))),r={equation:e};return qr.runKernel(_e,n,r)}});const wi=es({elu_:function(e){const t={x:Yr(e,"x","elu","float32")};return qr.runKernel("Elu",t)}});const ki=es({erf_:function(e){let t=Yr(e,"x","erf");a("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=Hs(t,"float32"));const n={x:t};return qr.runKernel("Erf",n)}});function vi(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function xi(e,t,n){const r=e.length+t.length,s=[];let o=0,a=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[o++]):s.push(t[a++]);return s}function Ei(e,t){return xi(e,t.map((e=>1)),t)}const Si=es({max_:function(e,t=null,n=!1){const r={x:Yr(e,"x","max")},s={reductionIndices:t,keepDims:n};return qr.runKernel("Max",r,s)}});const $i=es({min_:function(e,t=null,n=!1){const r={x:Yr(e,"x","min")},s={axis:t,keepDims:n};return qr.runKernel("Min",r,s)}});const Ai=es({pow_:function(e,t){let n=Yr(e,"base","pow"),r=Yr(t,"exp","pow");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel("Pow",s)}});function Ii(e,t){if((k(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&k(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return ns(e,[],[],t)}const Ni=es({sqrt_:function(e){const t={x:Yr(e,"x","sqrt","float32")};return qr.runKernel(Wt,t)}});const _i=es({square_:function(e){const t=Yr(e,"x","square");return qr.runKernel("Square",{x:t},{})}});const Mi=es({sum_:function(e,t=null,n=!1){let r=Yr(e,"x","sum");"bool"===r.dtype&&(r=Hs(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return qr.runKernel("Sum",s,o)}});function Ti(e,t,n=null){if(0===e.rank)return sa(e);if(1!==e.rank&&null===n)return Ti(_a(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Mi(sa(e),n);if(t===1/0)return Si(sa(e),n);if(t===-1/0)return $i(sa(e),n);if("euclidean"===t||2===t)return Ni(Mi(Ai(sa(e),Ii(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return Si(Mi(sa(e),n[0]),n[1]-1);if(t===1/0)return Si(Mi(sa(e),n[1]),n[0]);if(t===-1/0)return $i(Mi(sa(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Ni(Mi(_i(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Di=es({norm_:function(e,t="euclidean",n=null,r=!1){const s=Ti(e=Yr(e,"x","norm"),t,n);let o=s.shape;if(r){const t=f(n,e.shape);o=Ei(s.shape,t)}return _a(s,o)}});const Ri=es({euclideanNorm_:function(e,t=null,n=!1){return Di(e,"euclidean",t,n)}});const Bi=es({exp_:function(e){const t={x:Yr(e,"x","exp")};return qr.runKernel("Exp",t)}});const Fi=es({expandDims_:function(e,t=0){const n=Yr(e,"x","expandDims","string_or_numeric");a(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return qr.runKernel(Te,r,s)}});const Ci=es({expm1_:function(e){const t={x:Yr(e,"x","expm1")};return qr.runKernel(De,t)}});const Pi=es({tile_:function(e,t){const n=Yr(e,"x","tile","string_or_numeric");a(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return qr.runKernel(nn,r,s)}});const Oi=es({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=Gs([e,t],r),o=e<=t?e:t;for(let e=0;e<o;++e)s.set(1,e,e);const a=_a(s.toTensor(),[e,t]);if(null==n)return a;if(1===n.length)return Pi(Fi(a,0),[n[0],1,1]);if(2===n.length)return Pi(Fi(Fi(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return Pi(Fi(Fi(Fi(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Li(e,t,n){const r={shape:e,value:t,dtype:n};return qr.runKernel(Re,{},r)}const zi=es({floor_:function(e){const t={x:Yr(e,"x","floor","float32")};return qr.runKernel(Fe,t)}});const Wi=es({gather_:function(e,t,n=0,r=0){const s={x:Yr(e,"x","gather"),indices:Yr(t,"indices","gather","int32")},o={axis:n,batchDims:r};return qr.runKernel(Oe,s,o)}});const qi=es({greater_:function(e,t){let n=Yr(e,"a","greater","string_or_numeric"),r=Yr(t,"b","greater","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(ze,s)}});const Ki=es({greaterEqual_:function(e,t){let n=Yr(e,"a","greaterEqual","string_or_numeric"),r=Yr(t,"b","greaterEqual","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(We,s)}});const Ui=es({isFinite_:function(e){const t={x:Yr(e,"x","isFinite")};return qr.runKernel(Ge,t)}});const Gi=es({isInf_:function(e){const t={x:Yr(e,"x","isInf")};return qr.runKernel(He,t)}});const Hi=es({isNaN_:function(e){const t={x:Yr(e,"x","isNaN")};return qr.runKernel(Ve,t)}});const Vi=es({leakyRelu_:function(e,t=.2){const n={x:Yr(e,"x","leakyRelu")},r={alpha:t};return qr.runKernel(je,n,r)}});const ji=es({less_:function(e,t){let n=Yr(e,"a","less","string_or_numeric"),r=Yr(t,"b","less","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(Je,s)}});const Ji=es({lessEqual_:function(e,t){let n=Yr(e,"a","lessEqual","string_or_numeric"),r=Yr(t,"b","lessEqual","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(Ze,s)}});const Zi=es({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const o=Yr(e,"x","localResponseNormalization");a(4===o.rank||3===o.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${o.rank}.`)),a(d(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let i=o,l=!1;3===o.rank&&(l=!0,i=_a(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const u={x:i},c={depthRadius:t,bias:n,alpha:r,beta:s},h=qr.runKernel("LRN",u,c);return l?_a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Yi=es({log_:function(e){const t={x:Yr(e,"x","log","float32")};return qr.runKernel("Log",t)}});const Xi=es({log1p_:function(e){const t={x:Yr(e,"x","log1p")};return qr.runKernel(Xe,t)}});function Qi(e,t){a(I(e),(()=>"The f passed in variableGrads(f) must be a function")),a(null==t||Array.isArray(t)&&t.every((e=>e instanceof $r)),(()=>"The varList passed in variableGrads(f, varList) must be an array of variables"));const n=null!=t;if(!n){t=[];for(const e in qr.registeredVariables)t.push(qr.registeredVariables[e])}const r=n?t.filter((e=>!e.trainable)):null,s=t.length;t=t.filter((e=>e.trainable)),a(t.length>0,(()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${s} variables is trainable.`));const{value:o,grads:i}=qr.gradients(e,t,null,!0);a(i.some((e=>null!=e)),(()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize().")),a(0===o.rank,(()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${o.rank} tensor`));const l={};return t.forEach(((e,t)=>{null!=i[t]&&(l[e.name]=i[t])})),null!=r&&r.forEach((e=>l[e.name]=null)),{value:o,grads:l}}function el(e){return qr.customGrad(e)}function tl(e){if(e.filter((e=>null==e)).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const nl=es({softplus_:function(e){const t={x:Yr(e,"x","softplus")};return qr.runKernel(zt,t)}});const rl=es({logSigmoid_:function(e){const t=Yr(e,"x","logSigmoid"),n=el((e=>({value:bo(nl(bo(e))),gradFunc:t=>ra(t,Ra(bo(e)))})));return n(t)}});const sl=es({sub_:function(e,t){let n=Yr(e,"a","sub"),r=Yr(t,"b","sub");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel("Sub",s)}});const ol=es({logSoftmax_:function(e,t=-1){const n=Yr(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const r=el(((e,n)=>{const r=Si(e,t,!0),s=sl(e,r),o=sl(Hs(s,"float32"),Yi(Mi(Bi(s),t,!0)));n([o]);return{value:o,gradFunc:(e,n)=>{const[r]=n,s=Bi(r);return sl(e,ra(Mi(e,t,!0),s))}}}));return r(n)}});const al=es({logSumExp_:function(e,t=null,n=!1){const r=Yr(e,"x","logSumExp"),s=f(t,r.shape),o=Si(r,s,!0),a=sl(r,o),i=Bi(a),l=Mi(i,s),u=Yi(l),c=ea(_a(o,u.shape),u);if(n){const e=Ei(c.shape,s);return _a(c,e)}return c}});const il=es({logicalAnd_:function(e,t){const n=Yr(e,"a","logicalAnd","bool"),r=Yr(t,"b","logicalAnd","bool");Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(Qe,s)}});const ll=es({logicalNot_:function(e){const t={x:Yr(e,"x","logicalNot","bool")};return qr.runKernel(et,t)}});const ul=es({logicalOr_:function(e,t){const n=Yr(e,"a","logicalOr","bool"),r=Yr(t,"b","logicalOr","bool");Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(tt,s)}});const cl=es({logicalXor_:function(e,t){const n=Yr(e,"a","logicalXor","bool"),r=Yr(t,"b","logicalXor","bool");return Eo(n.shape,r.shape),il(ul(e,t),ll(il(e,t)))}}),hl=2147483648;const dl=es({searchSorted_:function(e,t,n="left"){const r=Yr(e,"sortedSequence","searchSorted"),s=Yr(t,"values","searchSorted"),o=r.shape[r.shape.length-1],a=s.shape[s.shape.length-1],i=_a(r,[-1,o]),l=_a(s,[-1,a]);if(i.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(i.shape[0]!==l.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(c(l.shape)>=hl)throw new Error("values tensor size must less than 2147483648");if(i.shape[1]>=hl)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${i.shape[1]}`);const u={sortedSequence:i,values:l},h={side:n};return qr.runKernel(Rt,u,h)}});const pl=es({maxPool_:function(e,t,n,r,s){const o=Yr(e,"x","maxPool");let i=o,l=!1;3===o.rank&&(l=!0,i=_a(o,[1,o.shape[0],o.shape[1],o.shape[2]])),a(4===i.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`)),a(Aa(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Na("maxPool",r,s);const u={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:s},h=qr.runKernel(rt,u,c);return l?_a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const fl=es({maxPool3d_:function(e,t=[1,1,1],n,r,s,o="NDHWC"){const i=Yr(e,"x","maxPool3d");let l=i,u=!1;4===i.rank&&(u=!0,l=_a(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),a(5===l.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${l.rank}.`)),a("NDHWC"===o,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${o}`)),Na("maxPool3d",r,s);const c={x:l},h={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:o},d=qr.runKernel(st,c,h);return u?_a(d,[d.shape[1],d.shape[2],d.shape[3],d.shape[4]]):d}});const gl=es({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const o={x:Yr(e,"x","maxPoolWithArgmax")},a={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=qr.runKernel(ot,o,a);return{result:i[0],indexes:i[1]}}});const ml=es({maximum_:function(e,t){let n=Yr(e,"a","maximum"),r=Yr(t,"b","maximum");[n,r]=Rr(n,r),"bool"===n.dtype&&(n=Hs(n,"int32"),r=Hs(r,"int32")),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(nt,s)}});const bl=es({mean_:function(e,t=null,n=!1){const r={x:Yr(e,"x","mean")},s={axis:t,keepDims:n};return qr.runKernel(at,r,s)}});function yl(e,t="float32"){if("complex64"===t){const t=yl(e,"float32"),n=yl(e,"float32");return ts(t,n)}const n=R(c(e),t);return qr.makeTensor(n,e,t)}function wl(e,t="float32"){if("complex64"===t){const t=wl(e,"float32"),n=yl(e,"float32");return ts(t,n)}const n=D(c(e),t);return qr.makeTensor(n,e,t)}const kl=es({minimum_:function(e,t){let n=Yr(e,"a","minimum"),r=Yr(t,"b","minimum");[n,r]=Rr(n,r),"bool"===n.dtype&&(n=Hs(n,"int32"),r=Hs(r,"int32")),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(it,s)}});const vl=es({mirrorPad_:function(e,t,n){a("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Yr(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");a(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)a(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),a(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const o={paddings:t,mode:n},i={x:r};return qr.runKernel(lt,i,o)}});const xl=es({mod_:function(e,t){let n=Yr(e,"a","mod"),r=Yr(t,"b","mod");[n,r]=Rr(n,r);const s={a:n,b:r};return qr.runKernel("Mod",s)}});const El=es({moments_:function(e,t=null,n=!1){const r=f(t,(e=Yr(e,"x","moments")).shape),s=bl(e,r,n);let o=s.shape;n||(o=Ei(s.shape,r));const a=_i(sl(Hs(e,"float32"),_a(s,o)));return{mean:s,variance:bl(a,r,n)}}});const Sl=es({multiRNNCell_:function(e,t,n,r){const s=Yr(t,"data","multiRNNCell"),o=Xr(n,"c","multiRNNCell"),a=Xr(r,"h","multiRNNCell");let i=s;const l=[];for(let t=0;t<e.length;t++){const n=e[t](i,o[t],a[t]);l.push(n[0]),l.push(n[1]),i=n[1]}const u=[],c=[];for(let e=0;e<l.length;e+=2)u.push(l[e]),c.push(l[e+1]);return[u,c]}});const $l=es({multinomial_:function(e,t,n,r=!1){const s=Yr(e,"logits","multinomial"),o=s.size,a=s.rank;if(o<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${o}.`);if(a>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${a}`);n=n||Math.random();const i={logits:1===a?_a(s,[1,-1]):s},l={numSamples:t,seed:n,normalized:r},u=qr.runKernel(ut,i,l);return 1===a?_a(u,[u.size]):u}});const Al=es({notEqual_:function(e,t){let n=Yr(e,"a","notEqual","string_or_numeric"),r=Yr(t,"b","notEqual","string_or_numeric");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(ht,s)}});const Il=es({onesLike_:function(e){const t={x:Yr(e,"x","onesLike")};return qr.runKernel(gt,t)}});const Nl=es({outerProduct_:function(e,t){const n=Yr(e,"v1","outerProduct"),r=Yr(t,"v2","outerProduct");a(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=_a(n,[-1,1]),o=_a(r,[1,-1]);return co(s,o)}});const _l=es({pad_:function(e,t,n=0){const r=Yr(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},o={x:r};return qr.runKernel(yt,o,s)}});const Ml=es({pad1d_:function(e,t,n=0){return a(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),_l(e,[t],n)}});const Tl=es({pad2d_:function(e,t,n=0){return a(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_l(e,t,n)}});const Dl=es({pad3d_:function(e,t,n=0){return a(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_l(e,t,n)}});const Rl=es({pad4d_:function(e,t,n=0){return a(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),_l(e,t,n)}});const Bl=es({spaceToBatchND_:function(e,t,n){const r=Yr(e,"x","spaceToBatchND");a(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),a(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),a(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},o={blockShape:t,paddings:n};return qr.runKernel(qt,s,o)}});const Fl=es({pool_:function(e,t,n,r,s,o,i){null==s&&(s=[1,1]),null==o&&(o=1),0===r&&(r="valid");const l=Yr(e,"x","maxPool");let u=l,c=!1;3===l.rank&&(c=!0,u=_a(l,[1,l.shape[0],l.shape[1],l.shape[2]])),a(Aa(o,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${o} and dilations '${s}'`));const h=ba(u.shape,t,o,s,r),d=[h.dilationHeight,h.dilationWidth];let p;p="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([h.filterHeight,h.filterWidth],d):[[0,0],[0,0]];const f=1===d[0]&&1===d[1],[g,m]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),o=e.concat(r,s),a=t.map(((e,t)=>(e-o[t]%e)%e)),i=s.map(((e,t)=>e+a[t])),l=t.map(((e,t)=>[r[t],i[t]])),u=t.map(((e,t)=>[0,a[t]]));return[l,u]}([h.inHeight,h.inWidth],d,p),b=f?r:"valid",y=f?u:Bl(u,d,g),w=("avg"===n?()=>Ma(y,t,o,b,i):()=>pl(y,t,o,b,i))(),k=f?w:Pa(w,d,m);return c?_a(k,[k.shape[1],k.shape[2],k.shape[3]]):k}});const Cl=es({prelu_:function(e,t){const n={x:Yr(e,"x","prelu"),alpha:Yr(t,"alpha","prelu")};return qr.runKernel(wt,n)}});const Pl=es({prod_:function(e,t=null,n=!1){let r=Yr(e,"x","prod");"bool"===r.dtype&&(r=Hs(r,"int32"));const s={x:r},o={axis:t,keepDims:n};return qr.runKernel(kt,s,o)}});const Ol=es({rand_:function(e,t,n){const r=c(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return qr.makeTensor(s,e,n)}});var Ll="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function zl(e){var t={exports:{}};return e(t,t.exports),t.exports}var Wl=zl((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function o(e,t){var n=new r(e),o=t&&t.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.alea=o}(0,e,!1)})),ql=zl((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor128=o}(0,e,!1)})),Kl=zl((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorwow=o}(0,e,!1)})),Ul=zl((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.x&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xorshift7=o}(0,e,!1)})),Gl=zl((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,o=t.i;return t.w=r=r+1640531527|0,n=s[o+34&127],e=s[o=o+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[o]=n^e,t.i=o,n+(r^r>>>16)|0},function(e,t){var n,r,s,o,a,i=[],l=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,l=Math.max(l,t.length)),s=0,o=-32;o<l;++o)t&&(r^=t.charCodeAt((o+32)%t.length)),0===o&&(a=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,o>=0&&(a=a+1640531527|0,s=0==(n=i[127&o]^=r+a)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,o=512;o>0;--o)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=a,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function o(e,t){null==e&&(e=+new Date);var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&(o.X&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.xor4096=o}(0,e,!1)})),Hl=zl((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function o(e,t){var n=new r(e),o=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,o&&("object"==typeof o&&s(o,n),a.state=function(){return s(n,{})}),a}t&&t.exports?t.exports=o:n&&n.amd?n((function(){return o})):this.tychei=o}(0,e,!1)})),Vl=zl((function(e){!function(t,n,r){var s,o=256,a=r.pow(o,6),i=r.pow(2,52),l=2*i,u=255;function c(e,u,c){var m=[],b=f(p((u=1==u?{entropy:!0}:u||{}).entropy?[e,g(n)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(o):(e=new Uint8Array(o),(t.crypto||t.msCrypto).getRandomValues(e)),g(e)}catch(e){var r=t.navigator,a=r&&r.plugins;return[+new Date,t,a,t.screen,g(n)]}}():e,3),m),y=new h(m),w=function(){for(var e=y.g(6),t=a,n=0;e<i;)e=(e+n)*o,t*=o,n=y.g(1);for(;e>=l;)e/=2,t/=2,n>>>=1;return(e+n)/t};return w.int32=function(){return 0|y.g(4)},w.quick=function(){return y.g(4)/4294967296},w.double=w,f(g(y.S),n),(u.pass||c||function(e,t,n,s){return s&&(s.S&&d(s,y),e.state=function(){return d(y,{})}),n?(r.random=e,t):e})(w,b,"global"in u?u.global:this==r,u.state)}function h(e){var t,n=e.length,r=this,s=0,a=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<o;)i[s]=s++;for(s=0;s<o;s++)i[s]=i[a=u&a+e[s%n]+(t=i[s])],i[a]=t;(r.g=function(e){for(var t,n=0,s=r.i,a=r.j,i=r.S;e--;)t=i[s=u&s+1],n=n*o+i[u&(i[s]=i[a=u&a+t])+(i[a]=t)];return r.i=s,r.j=a,n})(o)}function d(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function p(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(p(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function f(e,t){for(var n,r=e+"",s=0;s<r.length;)t[u&s]=u&(n^=19*t[u&s])+r.charCodeAt(s++);return g(t)}function g(e){return String.fromCharCode.apply(0,e)}if(f(r.random(),n),e.exports){e.exports=c;try{s=require("crypto")}catch(e){}}else r.seedrandom=c}("undefined"!=typeof self?self:Ll,[],Math)}));Vl.alea=Wl,Vl.xor128=ql,Vl.xorwow=Kl,Vl.xorshift7=Ul,Vl.xor4096=Gl,Vl.tychei=Hl;var jl=Vl;class Jl{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const o=s||Math.random();this.random=jl.alea(o.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,o;do{r=2*this.random()-1,s=2*this.random()-1,o=r*r+s*s}while(o>=1||0===o);const a=Math.sqrt(-2*Math.log(o)/o);e=this.mean+this.stdDev*r*a,t=this.mean+this.stdDev*s*a,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Zl{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=jl.alea(s.toString()),this.randn=new Jl(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,o;for(;;){do{r=this.randn.nextValue(),o=1+this.c*r}while(o<=0);if(o*=o*o,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-o+Math.log(o)),s=this.randu(),s<t||Math.log(s)<n)break}return o=1/this.beta*this.d*o,this.alpha<1&&(o*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(o)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class Yl{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=jl.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const Xl=es({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const o=new Zl(t,n,r,s),a=Gs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Ql=es({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const o=new Jl(t,n,r,!1,s),a=Gs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const eu=es({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return Ql(e,0,1,t,n)}});const tu=es({randomUniform_:function(e,t=0,n=1,r="float32",s){const o=Gs(e,r),a=new Yl(t,n,null,s);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});function nu(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return qr.runKernel(vt,{},s)}const ru=es({reciprocal_:function(e){const t={x:Yr(e,"x","reciprocal")};return qr.runKernel(Et,t)}});const su=es({relu_:function(e){const t={x:Yr(e,"x","relu")};return qr.runKernel(St,t)}});const ou=es({relu6_:function(e){const t={x:Yr(e,"x","relu6")};return qr.runKernel(Nt,t)}});const au=es({reverse_:function(e,t){const n={x:Yr(e,"x","reverse")},r={dims:t};return qr.runKernel(_t,n,r)}});const iu=es({reverse1d_:function(e){const t=Yr(e,"x","reverse");return a(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),au(t,0)}});const lu=es({reverse2d_:function(e,t){const n=Yr(e,"x","reverse");return a(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),au(n,t)}});const uu=es({reverse3d_:function(e,t){const n=Yr(e,"x","reverse");return a(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),au(n,t)}});const cu=es({reverse4d_:function(e,t){const n=Yr(e,"x","reverse");return a(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),au(n,t)}});const hu=es({round_:function(e){const t={x:Yr(e,"x","round")};return qr.runKernel(Mt,t)}});const du=es({rsqrt_:function(e){const t={x:Yr(e,"x","rsqrt","float32")};return qr.runKernel(Tt,t)}});const pu=es({selu_:function(e){const t={x:Yr(e,"x","selu")};return qr.runKernel(Ft,t)}});const fu=es({separableConv2d_:function(e,t,n,r,s,o=[1,1],i="NHWC"){const l=Yr(e,"x","separableConv2d"),u=Yr(t,"depthwiseFilter","separableConv2d"),c=Yr(n,"pointwiseFilter","separableConv2d");let h=l,d=!1;if(3===l.rank&&(d=!0,h=_a(l,[1,l.shape[0],l.shape[1],l.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");a(4===h.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`)),a(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),a(4===c.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),a(1===c.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`)),a(1===c.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`));const p=u.shape[2],f=u.shape[3];a(c.shape[2]===p*f,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*f}, but got ${c.shape[2]}.`));const g=ci(h,u,r,s,i,o),m=Ya(g,c,1,"valid",i);return d?_a(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const gu=async function(e,t){const n=Yr(e,"x","setdiff1d"),r=Yr(t,"y","setdiff1d");a(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),a(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),a(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),o=await r.data(),i=new Set(o);let l=0;for(let e=0;e<s.length;e++)i.has(s[e])||l++;const u=new vr([l],n.dtype),c=new vr([l],"int32");for(let e=0,t=0;e<s.length;e++)i.has(s[e])||(u.values[t]=s[e],c.values[t]=e,t++);return[u.toTensor(),c.toTensor()]};const mu=es({sign_:function(e){const t={x:Yr(e,"x","sign")};return qr.runKernel(Ot,t)}});const bu=es({sin_:function(e){const t={x:Yr(e,"x","sin","float32")};return qr.runKernel("Sin",t)}});const yu=es({sinh_:function(e){const t={x:Yr(e,"x","sinh")};return qr.runKernel(Pt,t)}});const wu=es({slice1d_:function(e,t,n){const r=Yr(e,"x","slice1d");return a(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),Ba(r,[t],[n])}});const ku=es({slice2d_:function(e,t,n){const r=Yr(e,"x","slice2d");return a(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),Ba(r,t,n)}});const vu=es({slice3d_:function(e,t,n){const r=Yr(e,"x","slice3d");return a(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),Ba(r,t,n)}});const xu=es({slice4d_:function(e,t,n){const r=Yr(e,"x","slice4d");return a(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),Ba(r,t,n)}});const Eu=es({softmax_:function(e,t=-1){const n=Yr(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return qr.runKernel(Ut,r,s)}});const Su=es({fft_:function(e){a("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return qr.runKernel("FFT",t)}});const $u=es({ifft_:function(e){a("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return qr.runKernel(Ke,t)}});const Au=es({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=_a(e,[n,t]);r=$u(s)}else{const s=[n,2*(t-1)],o=_a(yo(e),[n,t]),a=_a(mo(e),[n,t]),i=au(Ba(o,[0,1],[n,t-2]),1),l=ra(au(Ba(a,[0,1],[n,t-2]),1),Ii(-1)),u=Da([o,i],1),c=Da([a,l],1),h=_a(ts(u,c),[s[0],s[1]]);r=$u(h)}if(r=yo(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=_a(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const Iu=es({split_:function(e,t,n=0){const r={x:Yr(e,"x","split")},s={numOrSizeSplits:t,axis:n};return qr.runKernel(Kt,r,s)}});const Nu=es({rfft_:function(e,t){a("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),o=e.shape.map((e=>e));o[e.shape.length-1]=t,s=Ba(e,r,o),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=Da([e,yl(r)],e.shape.length-1),n=t}else s=e;const o=gi(s),i=_a(ts(s,o),[r,n]),l=Su(i),u=Math.floor(n/2)+1,c=yo(l),h=mo(l),d=Iu(c,[u,n-u],c.shape.length-1),p=Iu(h,[u,n-u],h.shape.length-1),f=s.shape.slice();return f[s.shape.length-1]=u,_a(ts(d[0],p[0]),f)}});const _u=es({squaredDifference_:function(e,t){let n=Yr(e,"a","squaredDifference"),r=Yr(t,"b","squaredDifference");[n,r]=Rr(n,r),Eo(n.shape,r.shape);const s={a:n,b:r};return qr.runKernel(Zt,s,{})}});const Mu=es({squeeze_:function(e,t){const n=Yr(e,"x","squeeze","string_or_numeric");return _a(n,g(n.shape,t).newShape)}});const Tu=es({stack_:function(e,t=0){const n=Xr(e,"tensors","stack","string_or_numeric");a(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&a(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return qr.runKernel(bt,r,s)}});const Du=es({step_:function(e,t=0){const n={x:Yr(e,"x","step")},r={alpha:t};return qr.runKernel(hn,n,r)}});const Ru=es({stridedSlice_:function(e,t,n,r,s=0,o=0,a=0,i=0,l=0){const u={x:Yr(e,"x","stridedSlice","string_or_numeric")},c={begin:t,end:n,strides:r,beginMask:s,endMask:o,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:l};return qr.runKernel(Yt,u,c)}});const Bu=es({tan_:function(e){const t={x:Yr(e,"x","tan","float32")};return qr.runKernel("Tan",t)}});function Fu(e,t){l(e);const n=jr(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return ns(e,null,n,t)}function Cu(e,t,n){if(l(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=jr(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return ns(e,t,r,n)}const Pu=es({topk_:function(e,t=1,n=!0){const r=Yr(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const o={x:r},a={k:t,sorted:n},[i,l]=qr.runKernel(rn,o,a);return{values:i,indices:l}}});const Ou=es({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const o=new Jl(t,n,r,!0,s),a=Gs(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});const Lu=es({unique_:function(e,t=0){const n=Yr(e,"x","unique","string_or_numeric");a(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[o,i]=qr.runKernel(an,r,s);return{values:o,indices:i}}});const zu=es({unsortedSegmentSum_:function(e,t,n){const r=Yr(e,"x","unsortedSegmentSum"),s=Yr(t,"segmentIds","unsortedSegmentSum","int32");a(d(n),(()=>"numSegments must be of dtype int"));const o={x:r,segmentIds:s},i={numSegments:n};return qr.runKernel(un,o,i)}});const Wu=es({unstack_:function(e,t=0){const n=Yr(e,"x","unstack","string_or_numeric");a(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return qr.runKernel(ln,r,s)}});function qu(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=Gs(e,"int32"),s=Gs([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const o=r.indexToLoc(n[t]),a=t*e.length;s.values.set(o,a)}return s.toTensor()}const Ku=async function(e){const t=Yr(e,"condition","whereAsync","bool"),n=await t.data(),r=qu(t.shape,n);return e!==t&&t.dispose(),r};const Uu=async function(e,t,n){const r=Yr(e,"tensor","boolMask"),s=Yr(t,"mask","boolMask","bool"),o=null==n?0:n,l=s.rank,u=r.shape;a(l>0,(()=>"mask cannot be scalar")),i(u.slice(o,o+l),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=o;e<o+l;e++)c*=u[e];const h=u.slice(0,o).concat([c],u.slice(o+l)),d=_a(r,h),p=_a(s,[-1]),f=await Ku(p),g=Mu(f,[1]),m=Wi(d,g,o);return e!==r&&r.dispose(),t!==s&&s.dispose(),g.dispose(),d.dispose(),p.dispose(),f.dispose(),m};const Gu=es({movingAverage_:function(e,t,n,r,s=!0){const o=Yr(e,"v","movingAverage"),i=Yr(t,"x","movingAverage"),l=Yr(n,"decay","movingAverage");Br(o,i),a(h(o.shape,i.shape),(()=>"Shape mismatch in v and x"));const u=Ii(1),c=sl(u,l);let d=ra(sl(i,o),c);if(s){a(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Yr(r,"step","movingAverage");d=na(d,sl(u,Ai(l,e)))}return ea(o,d)}});const Hu=es({scatterND_:function(e,t,n){const r=Yr(e,"indices","scatterND","int32"),s=Yr(t,"updates","scatterND");Ro(s,r,n);const o={indices:r,updates:s},a={shape:n};return qr.runKernel(Dt,o,a)}});const Vu=es({sparseToDense_:function(e,t,n,r=0){const s=Yr(e,"sparseIndices","sparseToDense","int32"),o=Yr(t,"sparseValues","sparseToDense","string_or_numeric"),a=Yr(r,"defaultValue","sparseToDense",o.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,o=e.rank>1?e.shape[1]:1;if(n.length!==o)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${o}.`);const a=t.size;if(0!==t.rank&&(1!==t.rank||a!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,o,n,a);const i={sparseIndices:s,sparseValues:o,defaultValue:a},l={outputShape:n};return qr.runKernel(Jt,i,l)}});const ju=es({gatherND_:function(e,t){const n=Yr(t,"indices","gatherND","int32"),r={params:Yr(e,"x","gatherND","string_or_numeric"),indices:n};return qr.runKernel(Le,r)}});const Ju=es({dropout_:function(e,t,n,r){const s=Yr(e,"x","dropout");if(a("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),a(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof Sr?s.clone():s;const o=function(e,t){if(null==t)return e.shape.slice();if(h(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),i=1-t,l=na(zi(ea(tu(o,0,1,"float32",r),i)),i);return ra(s,l)}});function Zu(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Yu(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let o=0;o<e;++o){const a=2*Math.PI*o/(e+r-1);s[o]=t-n*Math.cos(a)}return Fu(s,"float32")}const Xu=async function(e,t,n=1){const r=Yr(e,"predictions","inTopK"),s=Yr(t,"targets","inTopK");a(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),a(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),i(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const o=r.shape[r.shape.length-1];a(n>0&&n<=o,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${o}), but got ${n}`));const l=await r.data(),u=await s.data(),[c,h]=[l.length/o,o],d=m("bool",c);for(let e=0;e<c;e++){const t=e*h,r=l.subarray(t,t+h),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),d[e]=0;for(let t=0;t<n;t++)if(s[t].index===u[e]){d[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),rs(d,s.shape,"bool")};const Qu=es({conv2DBackpropFilter_:function(e,t,n,r,s,o="NHWC",i){let l=e;3===e.rank&&(l=_a(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=_a(t,[1,t.shape[0],t.shape[1],t.shape[2]])),a(4===l.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${l.shape}.`)),a(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),a(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const c="NHWC"===o?l.shape[3]:l.shape[1],h="NHWC"===o?u.shape[3]:u.shape[1];a(c===n[2],(()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`)),a(h===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${h}) must match output depth for filter (${n[3]}).`)),Na("conv2dDerFilter",s,i);const d={x:l,dy:u},p={strides:r,pad:s,dataFormat:o,dimRoundingMode:i,filterShape:n};return qr.runKernel(pe,d,p)}});function ec(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return ra(e,Du(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function tc(e,t){let n=t;const r=xo(e.shape,t.shape);return r.length>0&&(n=Mi(n,r)),_a(n,e.shape)}function nc(e,t,n,r){if("linear"===t)return e;if("relu"===t)return su(e);if("elu"===t)return wi(e);if("relu6"===t)return ou(e);if("prelu"===t)return Cl(e,n);if("leakyrelu"===t)return Vi(e,r);if("sigmoid"===t)return Ra(e);throw new Error(`Unknown fused activation ${t}.`)}const rc=(e,t)=>!(e>0)||"linear"===t;const sc=es({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(u=u||"linear",!1===rc(qr.state.gradientDepth,u)){a("NHWC"===s,(()=>`Error in fused conv2d: got dataFormat of ${s} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let d=Ya(e,t,n,r,s,o,i);return null!=l&&(d=ea(d,l)),nc(d,u,c,h)}const d=Yr(e,"x","conv2d","float32"),p=Yr(t,"filter","conv2d","float32");let f=d,g=!1;3===d.rank&&(g=!0,f=_a(d,[1,d.shape[0],d.shape[1],d.shape[2]])),a(4===f.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${f.rank}.`)),a(4===p.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${p.rank}.`)),Na("fused conv2d",r,i);const m="NHWC"===s?f.shape[3]:f.shape[1];a(p.shape[2]===m,(()=>`Error in conv2d: depth of input (${m}) must match input depth for filter ${p.shape[2]}.`)),a(Aa(n,o),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`));const b=ya(f.shape,p.shape,n,o,r,i);let y,w;if(null!=l&&(y=Yr(l,"bias","fused conv2d"),[y]=Rr(y,d),"NHWC"===s?Eo(b.outShape,y.shape):(a(y.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${y.shape.length}.`)),a(0===y.shape.length||y.shape[0]===b.outChannels||1===y.shape[0],(()=>`Error in fused conv2d: bias shape (${y.shape}) is not compatible with the number of output channels (${b.outChannels})`)))),null!=c){const e=c.shape;if(a(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)a(1===e[0]||e[0]===b.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${b.outChannels}).`));else if(3===e.length)try{Eo(e,b.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${b.outShape}).`;throw Error(n)}w=Yr(c,"prelu weights","fused conv2d")}const k=(e,t)=>{a("NHWC"===s,(()=>`Error in gradient of fused conv2D: got dataFormat of ${s} but only NHWC is currently supported.`));const[i,l,c,h]=t,d=ec(e,c,u);a($a(o),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${o}'`));const p=[Qa(l.shape,d,i,n,r),Qu(l,d,i.shape,n,r)];if(null!=h){const e=tc(h,d);p.push(e)}return p},v={x:f,filter:p,bias:y,preluActivationWeights:w},x={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){const e=el(((e,t,n)=>{let r=qr.runKernel(gn,v,x);return n([t,e,r]),g&&(r=_a(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:k}}));return e(f,p)}{const e=el(((e,t,n,r)=>{let s=qr.runKernel(gn,v,x);return r([t,e,s,n]),g&&(s=_a(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:k}}));return e(f,p,y)}}});const oc=es({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,o=[1,1],a){let i=e;3===e.rank&&(i=_a(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=_a(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={x:i,dy:l},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,filterShape:n};return qr.runKernel(Se,u,c)}});const ac=es({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,o=[1,1],a){let i=t,l=!1;3===t.rank&&(l=!0,i=_a(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const u={dy:i,filter:n},c={strides:r,pad:s,dimRoundingMode:a,dilations:o,inputShape:e},h=qr.runKernel($e,u,c);return l?_a(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const ic=es({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:o=[1,1],dimRoundingMode:i,bias:l,activation:u="linear",preluActivationWeights:c,leakyreluAlpha:h}){if(!1===rc(qr.state.gradientDepth,u)){let a=ci(e,t,n,r,s,o,i);return null!=l&&(a=ea(a,l)),nc(a,u,c,h)}const d=Yr(e,"x","depthwiseConv2d","float32"),p=Yr(t,"filter","depthwiseConv2d","float32");let f=d,g=!1;3===d.rank&&(g=!0,f=_a(d,[1,d.shape[0],d.shape[1],d.shape[2]])),a(4===f.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${f.rank}.`)),a(4===p.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${p.rank}.`)),a(f.shape[3]===p.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${f.shape[3]}) must match the inChannels dimension in filter ${p.shape[2]}.`)),null==o&&(o=[1,1]),a(Aa(n,o),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${o}'`)),Na("fused depthwiseConv2d",r,i);const m=ya(f.shape,p.shape,n,o,r,i,!0);let b,y;null!=l&&(b=Yr(l,"bias","fused conv2d"),[b]=Rr(b,d),Eo(m.outShape,b.shape)),null!=c&&(y=Yr(c,"prelu weights","fused depthwiseConv2d"));const w=(e,t)=>{a($a(o),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${o}'`));const[s,l,c,h]=t,d=ec(e,c,u),p=ac(l.shape,d,s,n,r,o,i),f=oc(l,d,s.shape,n,r,o,i);if(null!=h){return[p,f,tc(b,d)]}return[p,f]},k={x:f,filter:p,bias:b,preluActivationWeights:y},v={strides:n,pad:r,dataFormat:s,dilations:o,dimRoundingMode:i,activation:u,leakyreluAlpha:h};if(null==l){const e=el(((e,t,n)=>{let r=qr.runKernel(mn,k,v);return n([t,e,r]),g&&(r=_a(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:w}}));return e(f,p)}{const e=el(((e,t,n,r)=>{let s=qr.runKernel(mn,k,v);return r([t,e,s,n]),g&&(s=_a(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:w}}));return e(f,p,b)}}});const lc=es({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:o="linear",preluActivationWeights:i,leakyreluAlpha:l=.2}){if(!1===rc(qr.state.gradientDepth,o)){let a=co(e,t,n,r);return null!=s&&(a=ea(a,s)),nc(a,o,i,l)}let u=Yr(e,"a","fused matMul"),h=Yr(t,"b","fused matMul");[u,h]=Rr(u,h);const d=n?u.shape[u.rank-2]:u.shape[u.rank-1],p=r?h.shape[h.rank-1]:h.shape[h.rank-2],f=n?u.shape[u.rank-1]:u.shape[u.rank-2],g=r?h.shape[h.rank-2]:h.shape[h.rank-1],m=u.shape.slice(0,-2),b=h.shape.slice(0,-2),y=c(m),w=c(b);a(d===p,(()=>`Error in fused matMul: inner shapes (${d}) and (${p}) of Tensors with shapes ${u.shape} and ${h.shape} and transposeA=${n} and transposeB=${r} must match.`));const k=Eo(u.shape.slice(0,-2),h.shape.slice(0,-2)).concat([f,g]),v=_a(u,n?[y,d,f]:[y,f,d]),x=_a(h,r?[w,g,p]:[w,p,g]);let E,S;null!=s&&(E=Yr(s,"bias","fused matMul"),[E]=Rr(E,u),Eo(k,E.shape)),null!=i&&(S=Yr(i,"prelu weights","fused matMul"));const $=(e,t)=>{const[a,i,l,u]=t,c=ec(_a(e,l.shape),l,o);let h,d;if(n||r?!n&&r?(h=co(c,i,!1,!1),d=co(c,a,!0,!1)):n&&!r?(h=co(i,c,!1,!0),d=co(a,c,!1,!1)):(h=co(i,c,!0,!0),d=co(c,a,!0,!0)):(h=co(c,i,!1,!0),d=co(a,c,!0,!1)),null!=s){return[h,d,tc(u,c)]}return[h,d]},A={a:v,b:x,bias:E,preluActivationWeights:S},I={transposeA:n,transposeB:r,activation:o,leakyreluAlpha:l};if(null==s){const e=el(((e,t,n)=>{const r=qr.runKernel(fn,A,I);return n([e,t,r]),{value:_a(r,k),gradFunc:$}}));return e(v,x)}{const e=el(((e,t,n,r)=>{const s=qr.runKernel(fn,A,I);return r([e,t,s,n]),{value:_a(s,k),gradFunc:$}}));return e(v,x,E)}}});var uc={__proto__:null,conv2d:sc,depthwiseConv2d:ic,matMul:lc};const cc=es({hammingWindow_:function(e){return Yu(e,.54,.46)}});const hc=es({hannWindow_:function(e){return Yu(e,.5,.5)}});const dc=es({frame_:function(e,t,n,r=!1,s=0){let o=0;const a=[];for(;o+t<=e.size;)a.push(Ba(e,o,t)),o+=n;if(r)for(;o<e.size;){const r=o+t-e.size,i=Da([Ba(e,o,t-r),Li([r],s)]);a.push(i),o+=n}return 0===a.length?Cu([],[0,t]):_a(Da(a),[a.length,t])}});const pc=es({stft_:function(e,t,n,r,s=hc){null==r&&(r=Zu(t));const o=dc(e,t,n),a=ra(o,s(t));return Nu(a,r)}});const fc=es({cropAndResize_:function(e,t,n,r,s="bilinear",o=0){const i=Yr(e,"image","cropAndResize"),l=Yr(t,"boxes","cropAndResize","float32"),u=Yr(n,"boxInd","cropAndResize","int32"),c=l.shape[0];a(4===i.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`)),a(2===l.rank&&4===l.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${l.shape}.`)),a(1===u.rank&&u.shape[0]===c,(()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${l.shape}.`)),a(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),a(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),a("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const h={image:i,boxes:l,boxInd:u},d={method:s,extrapolationValue:o,cropSize:r};return qr.runKernel(ke,h,d)}});const gc=es({flipLeftRight_:function(e){const t=Yr(e,"image","flipLeftRight","float32");a(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return qr.runKernel(Be,n,{})}});const mc=es({grayscaleToRGB_:function(e){const t=Yr(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];a(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),a(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,Pi(t,s)}});const bc=es({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Yr(e,"image","rotateWithOffset","float32");a(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const o={image:s},i={radians:t,fillValue:n,center:r};return qr.runKernel(pn,o,i)}});function yc(e,t,n,r,s,o){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==o&&(o=0);const i=e.shape[0];return n=Math.min(n,i),a(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),a(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),a(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),a(1===t.rank,(()=>"scores must be a 1D tensor")),a(t.shape[0]===i,(()=>`scores has incompatible shape with boxes. Expected ${i}, but was ${t.shape[0]}`)),a(0<=o&&o<=1,(()=>`softNmsSigma must be in [0, 1], but was '${o}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:o}}const wc=es({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Yr(e,"boxes","nonMaxSuppression","float32"),a=Yr(t,"scores","nonMaxSuppression","float32"),i=yc(o,a,n,r,s),l={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return qr.runKernel(dt,{boxes:o,scores:a},l)}});function kc(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,o=0,a=!1;for(;r<s;){o=r+(s-r>>>1);const i=n(t,e[o]);i>0?r=o+1:(s=o,a=!i)}return a?r:-r-1}(e,t,n||vc)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function vc(e,t){return e>t?1:e<t?-1:0}function xc(e,t,n,r,s){return $c(e,t,n,r,s,0)}function Ec(e,t,n,r,s,o){return $c(e,t,n,r,s,0,!1,o,!0)}function Sc(e,t,n,r,s,o){return $c(e,t,n,r,s,o,!0)}function $c(e,t,n,r,s,o,a=!1,i=!1,l=!1){const u=[];for(let e=0;e<t.length;e++)t[e]>s&&u.push({score:t[e],boxIndex:e,suppressBeginIndex:0});u.sort(Nc);const c=o>0?-.5/o:0,h=[],d=[];for(;h.length<n&&u.length>0;){const t=u.pop(),{score:n,boxIndex:o,suppressBeginIndex:a}=t;if(n<s)break;let i=!1;for(let n=h.length-1;n>=a;--n){const a=Ac(e,o,h[n]);if(a>=r){i=!0;break}if(t.score=t.score*Ic(r,c,a),t.score<=s)break}t.suppressBeginIndex=h.length,i||(t.score===n?(h.push(o),d.push(t.score)):t.score>s&&kc(u,t,Nc))}const p=h.length,f=n-p;i&&f>0&&(h.push(...new Array(f).fill(0)),d.push(...new Array(f).fill(0)));const g={selectedIndices:h};return a&&(g.selectedScores=d),l&&(g.validOutputs=p),g}function Ac(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),o=Math.min(r[0],r[2]),a=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),l=Math.max(r[1],r[3]),u=Math.min(s[0],s[2]),c=Math.min(s[1],s[3]),h=Math.max(s[0],s[2]),d=Math.max(s[1],s[3]),p=(i-o)*(l-a),f=(h-u)*(d-c);if(p<=0||f<=0)return 0;const g=Math.max(o,u),m=Math.max(a,c),b=Math.min(i,h),y=Math.min(l,d),w=Math.max(b-g,0)*Math.max(y-m,0);return w/(p+f-w)}function Ic(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function Nc(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const _c=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const o=Yr(e,"boxes","nonMaxSuppressionAsync"),a=Yr(t,"scores","nonMaxSuppressionAsync"),i=yc(o,a,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const l=await Promise.all([o.data(),a.data()]),u=l[0],c=l[1],{selectedIndices:h}=xc(u,c,n,r,s);return o!==e&&o.dispose(),a!==t&&a.dispose(),Fu(h,"int32")};const Mc=es({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Yr(e,"boxes","nonMaxSuppression"),i=Yr(t,"scores","nonMaxSuppression"),l=yc(a,i,n,r,s,o),u={boxes:a,scores:i},c={maxOutputSize:n=l.maxOutputSize,iouThreshold:r=l.iouThreshold,scoreThreshold:s=l.scoreThreshold,softNmsSigma:o=l.softNmsSigma},h=qr.runKernel(ft,u,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const Tc=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=0){const a=Yr(e,"boxes","nonMaxSuppressionAsync"),i=Yr(t,"scores","nonMaxSuppressionAsync"),l=yc(a,i,n,r,s,o);n=l.maxOutputSize,r=l.iouThreshold,s=l.scoreThreshold,o=l.softNmsSigma;const u=await Promise.all([a.data(),i.data()]),c=u[0],h=u[1],{selectedIndices:d,selectedScores:p}=Sc(c,h,n,r,s,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Fu(d,"int32"),selectedScores:Fu(p)}};const Dc=es({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Yr(e,"boxes","nonMaxSuppression"),i=Yr(t,"scores","nonMaxSuppression"),l=yc(a,i,n,r,s,null),u={boxes:a,scores:i},c={maxOutputSize:l.maxOutputSize,iouThreshold:l.iouThreshold,scoreThreshold:l.scoreThreshold,padToMaxOutputSize:o},h=qr.runKernel(pt,u,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const Rc=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,o=!1){const a=Yr(e,"boxes","nonMaxSuppressionAsync"),i=Yr(t,"scores","nonMaxSuppressionAsync"),l=yc(a,i,n,r,s,null),u=l.maxOutputSize,c=l.iouThreshold,h=l.scoreThreshold,[d,p]=await Promise.all([a.data(),i.data()]),{selectedIndices:f,validOutputs:g}=Ec(d,p,u,c,h,o);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:Fu(f,"int32"),validOutputs:Ii(g,"int32")}};const Bc=es({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Yr(e,"images","resizeBilinear");a(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),a(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),a(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let o=s,i=!1;3===s.rank&&(i=!0,o=_a(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=qr.runKernel(It,l,u);return i?_a(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Fc=es({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Yr(e,"images","resizeNearestNeighbor");a(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),a(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),a("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),a(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let o=s,i=!1;3===s.rank&&(i=!0,o=_a(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const l={images:o},u={alignCorners:n,halfPixelCenters:r,size:t},c=qr.runKernel(At,l,u);return i?_a(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const Cc=es({threshold_:function(e,t="binary",n=!1,r=.5){const s=Yr(e,"image","threshold"),o=s.shape[0]*s.shape[1];let i,l,u,c,h=ra(Fu([r]),255);if(a(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),a(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),a("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),a("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[i,l,u]=Iu(s,[1,1,1],-1);const e=ra(i,.2989),t=ra(l,.587),n=ra(u,.114);c=ea(ea(e,t),n)}else c=e;if("otsu"===t){h=function(e,t){let n,r,s,o,a,i,l=Fu([-1]),u=Fu([0]),c=Fu([0]);for(let h=0;h<e.size-1;h++){n=Ba(e,0,h+1),r=Ba(e,h+1),a=na(Mi(n),t),i=na(Mi(r),t);const d=Mi(ra(n,nu(0,n.size)));s=na(d,Mi(n));const p=Li(r.shape,n.size),f=ea(nu(0,r.size),p),g=ra(r,f);o=na(Mi(g),Mi(r));const m=sl(s,o),b=sl(s,o),y=ra(a,i);c=ra(ra(y,m),b);const w=qi(c,u);u=fi(w,c,u),l=fi(w,Fu([h]),l)}return l}(qa(Hs(hu(c),"int32"),rs([]),256),o)}const d=n?Ji(c,h):qi(c,h);return Hs(ra(d,255),"int32")}});const Pc=es({transform_:function(e,t,n="nearest",r="constant",s=0,o){const i=Yr(e,"image","transform","float32"),l=Yr(t,"transforms","transform","float32");a(4===i.rank,(()=>`Error in transform: image must be rank 4,but got rank ${i.rank}.`)),a(2===l.rank&&(l.shape[0]===i.shape[0]||1===l.shape[0])&&8===l.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),a(null==o||2===o.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${o}.`));const u={image:i,transforms:l},c={interpolation:n,fillMode:r,fillValue:s,outputShape:o};return qr.runKernel(sn,u,c)}});const Oc=es({bandPart_:function(e,t,n){a(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),a(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Yr(e,"a","bandPart");a(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[o,i]=r.shape.slice(-2);if(!(t<=o))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${o}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=o),n<0&&(n=i);const l=_a(nu(0,o,1,"int32"),[-1,1]),u=nu(0,i,1,"int32"),c=sl(l,u),h=il(Ji(c,Ii(+t,"int32")),Ki(c,Ii(-n,"int32"))),d=yl([o,i],r.dtype);return _a(Tu(Wu(_a(r,[-1,o,i])).map((e=>fi(h,e,d)))),s)}});const Lc=es({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,a(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)a(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=Iu(e,e.shape[0],0).map((e=>Mu(e,[0])));a(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(qr.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=ra(Mi(ra(n[r],e)),n[r]);e=sl(e,t)}return na(e,Di(e,"euclidean"))})));return t?Tu(n,0):n}});function zc(e,t=!1){return qr.tidy((()=>{a(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=Oi(n),o=Vs(e);const i=Cu([[1]],[1,1]);let l=Vs(i);const u=n>=r?r:n;for(let e=0;e<u;++e){const t=o,a=l,u=s;[l,o,s]=qr.tidy((()=>{const t=Ba(o,[e,e],[n-e,1]),a=Di(t),u=Ba(o,[e,e],[1,1]),c=fi(qi(u,0),Cu([[-1]]),Cu([[1]])),h=sl(u,ra(c,a)),d=na(t,h);l=1===d.shape[0]?Vs(i):Da([i,Ba(d,[1,0],[d.shape[0]-1,d.shape[1]])],0);const p=bo(na(co(c,h),a)),f=Ba(o,[e,0],[n-e,r]),g=ra(p,l),m=wo(l);if(0===e)o=sl(f,co(g,co(m,f)));else{const t=sl(f,co(g,co(m,f)));o=Da([Ba(o,[0,0],[e,r]),t],0)}const b=wo(g),y=Ba(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=sl(y,co(co(y,l),b));else{const t=sl(y,co(co(y,l),b));s=Da([Ba(s,[0,0],[n,e]),t],1)}return[l,o,s]})),fo([t,a,u])}return!t&&n>r&&(s=Ba(s,[0,0],[n,r]),o=Ba(o,[0,0],[r,r])),[s,o]}))}const Wc=es({qr_:function(e,t=!1){if(a(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return zc(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Wu(_a(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],o=[];r.forEach((e=>{const[n,r]=zc(e,t);s.push(n),o.push(r)}));return[_a(Tu(s,0),e.shape),_a(Tu(o,0),e.shape)]}}});var qc;e.Reduction=void 0,(qc=e.Reduction||(e.Reduction={}))[qc.NONE=0]="NONE",qc[qc.MEAN=1]="MEAN",qc[qc.SUM=2]="SUM",qc[qc.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const Kc=es({computeWeightedLoss_:function(t,n,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const s=Yr(t,"losses","computeWeightedLoss");let o=null;null!=n&&(o=Yr(n,"weights","computeWeightedLoss"));const a=null==o?s:ra(s,o);if(r===e.Reduction.NONE)return a;if(r===e.Reduction.SUM)return Mi(a);if(r===e.Reduction.MEAN){if(null==o)return bl(a);{const e=s.size/o.size,t=na(Mi(a),Mi(o));return e>1?na(t,Ii(e)):t}}if(r===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==o)return na(Mi(a),Ii(s.size));{const e=ra(o,wl(s.shape)),t=Hs(Mi(Al(e,Ii(0))),"float32");return na(Mi(a),t)}}throw Error(`Unknown reduction: ${r}`)}});const Uc=es({absoluteDifference_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const o=Yr(t,"labels","absoluteDifference"),a=Yr(n,"predictions","absoluteDifference");let l=null;null!=r&&(l=Yr(r,"weights","absoluteDifference")),i(o.shape,a.shape,"Error in absoluteDifference: ");const u=sa(sl(o,a));return Kc(u,l,s)}});const Gc=es({cosineDistance_:function(t,n,r,s,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Yr(t,"labels","cosineDistance"),l=Yr(n,"predictions","cosineDistance");let u=null;null!=s&&(u=Yr(s,"weights","cosineDistance")),i(a.shape,l.shape,"Error in cosineDistance: ");const c=Ii(1),h=sl(c,Mi(ra(a,l),r,!0));return Kc(h,u,o)}});const Hc=es({hingeLoss_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let o=Yr(t,"labels","hingeLoss");const a=Yr(n,"predictions","hingeLoss");let l=null;null!=r&&(l=Yr(r,"weights","hingeLoss")),i(o.shape,a.shape,"Error in hingeLoss: ");const u=Ii(1);o=sl(ra(Ii(2),o),u);const c=su(sl(u,ra(o,a)));return Kc(c,l,s)}});const Vc=es({huberLoss_:function(t,n,r,s=1,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Yr(t,"labels","huberLoss"),l=Yr(n,"predictions","huberLoss");let u=null;null!=r&&(u=Yr(r,"weights","huberLoss")),i(a.shape,l.shape,"Error in huberLoss: ");const c=Ii(s),h=sa(sl(l,a)),d=kl(h,c),p=sl(h,d),f=ea(ra(Ii(.5),_i(d)),ra(c,p));return Kc(f,u,o)}});const jc=es({logLoss_:function(t,n,r,s=1e-7,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const a=Yr(t,"labels","logLoss"),l=Yr(n,"predictions","logLoss");let u=null;null!=r&&(u=Yr(r,"weights","logLoss")),i(a.shape,l.shape,"Error in logLoss: ");const c=Ii(1),h=Ii(s),d=bo(ra(a,Yi(ea(l,h)))),p=ra(sl(c,a),Yi(ea(sl(c,l),h))),f=sl(d,p);return Kc(f,u,o)}});const Jc=es({meanSquaredError_:function(t,n,r,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const o=Yr(t,"labels","meanSquaredError"),a=Yr(n,"predictions","meanSquaredError");let l=null;null!=r&&(l=Yr(r,"weights","meanSquaredError")),i(o.shape,a.shape,"Error in meanSquaredError: ");const u=_u(o,a);return Kc(u,l,s)}});const Zc=es({sigmoidCrossEntropy_:function(t,n,r,s=0,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Yr(t,"multiClassLabels","sigmoidCrossEntropy");const l=Yr(n,"logits","sigmoidCrossEntropy");let u=null;if(null!=r&&(u=Yr(r,"weights","sigmoidCrossEntropy")),i(a.shape,l.shape,"Error in sigmoidCrossEntropy: "),s>0){const e=Ii(s),t=Ii(1),n=Ii(.5);a=ea(ra(a,sl(t,e)),ra(n,e))}const c=function(e,t){const n=Yr(e,"labels","sigmoidCrossEntropyWithLogits"),r=Yr(t,"logits","sigmoidCrossEntropyWithLogits");i(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=su(r),o=ra(r,n),a=Xi(Bi(bo(sa(r))));return ea(sl(s,o),a)}(a,l);return Kc(c,u,o)}});const Yc=es({softmaxCrossEntropy_:function(t,n,r,s=0,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let a=Yr(t,"onehotLabels","softmaxCrossEntropy");const l=Yr(n,"logits","softmaxCrossEntropy");let u=null;if(null!=r&&(u=Yr(r,"weights","softmaxCrossEntropy")),i(a.shape,l.shape,"Error in softmaxCrossEntropy: "),s>0){const e=Ii(s),t=Ii(1),n=Ii(a.shape[1]);a=ea(ra(a,sl(t,e)),na(e,n))}const c=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const r=el(((e,t,r)=>{const s=al(t,[n],!0),o=sl(Hs(t,"float32"),s);r([e,o]);const a=bo(ra(o,e));return{value:Mi(a,[n]),gradFunc:(e,t)=>{const[r,s]=t,o=Ei(e.shape,[n]);return[ra(_a(e,o),sl(Hs(r,"float32"),Bi(s))),ra(_a(e,o),sl(Bi(s),Hs(r,"float32")))]}}}));return r(e,t)}(a,l);return Kc(c,u,o)}});const Xc=es({sparseFillEmptyRows_:function(e,t,n,r){const s=Yr(e,"indices","sparseFillEmptyRows","int32"),o=Yr(t,"values","sparseFillEmptyRows"),a=Yr(n,"denseShape","sparseFillEmptyRows","int32"),i=Yr(r,"defaultValue","sparseFillEmptyRows",o.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==o.rank)throw new Error(`Values should be Tensor1D but received shape ${o.shape}`);if(1!==a.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${a.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const l={indices:s,values:o,denseShape:a,defaultValue:i},u=qr.runKernel(Gt,l);return{outputIndices:u[0],outputValues:u[1],emptyRowIndicator:u[2],reverseIndexMap:u[3]}}});const Qc=es({sparseReshape_:function(e,t,n){const r=Yr(e,"inputIndices","sparseReshape","int32"),s=Yr(t,"inputShape","sparseReshape","int32"),o=Yr(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==o.rank)throw new Error(`New shape should be Tensor1D but received shape ${o.shape}`);const a={inputIndices:r,inputShape:s,newShape:o},i=qr.runKernel(Ht,a);return{outputIndices:i[0],outputShape:i[1]}}});const eh=es({sparseSegmentMean_:function(e,t,n){const r=Yr(e,"data","sparseSegmentMean"),s=Yr(t,"indices","sparseSegmentMean","int32"),o=Yr(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return qr.runKernel(Vt,a)}});const th=es({sparseSegmentSum_:function(e,t,n){const r=Yr(e,"data","sparseSegmentSum"),s=Yr(t,"indices","sparseSegmentSum","int32"),o=Yr(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==o.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${o.shape}`);const a={data:r,indices:s,segmentIds:o};return qr.runKernel(jt,a)}});const nh=es({stringNGrams_:function(e,t,n,r,s,o,a,i){const l=Yr(e,"data","stringNGrams","string");if("string"!==l.dtype)throw new Error("Data must be of datatype string");if(1!==l.shape.length)throw new Error(`Data must be a vector, saw: ${l.shape}`);const u=Yr(t,"dataSplits","stringNGrams");if("int32"!==u.dtype)throw new Error("Data splits must be of datatype int32");const c={separator:n,nGramWidths:r,leftPad:s,rightPad:o,padWidth:a,preserveShortSequences:i},h={data:l,dataSplits:u},d=qr.runKernel(Xt,h,c);return{nGrams:d[0],nGramsSplits:d[1]}}});const rh=es({stringSplit_:function(e,t,n=!0){const r=Yr(e,"input","stringSplit","string"),s=Yr(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const o={skipEmpty:n},a={input:r,delimiter:s},i=qr.runKernel(Qt,a,o);return{indices:i[0],values:i[1],shape:i[2]}}});const sh=es({stringToHashBucketFast_:function(e,t){const n=Yr(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return qr.runKernel(en,s,r)}}),oh={fft:Su,ifft:$u,rfft:Nu,irfft:Au},ah={hammingWindow:cc,hannWindow:hc,frame:dc,stft:pc},ih={flipLeftRight:gc,grayscaleToRGB:mc,resizeNearestNeighbor:Fc,resizeBilinear:Bc,rotateWithOffset:bc,cropAndResize:fc,nonMaxSuppression:wc,nonMaxSuppressionAsync:_c,nonMaxSuppressionWithScore:Mc,nonMaxSuppressionWithScoreAsync:Tc,nonMaxSuppressionPadded:Dc,nonMaxSuppressionPaddedAsync:Rc,threshold:Cc,transform:Pc},lh={bandPart:Oc,gramSchmidt:Lc,qr:Wc},uh={absoluteDifference:Uc,computeWeightedLoss:Kc,cosineDistance:Gc,hingeLoss:Hc,huberLoss:Vc,logLoss:jc,meanSquaredError:Jc,sigmoidCrossEntropy:Zc,softmaxCrossEntropy:Yc},ch={sparseFillEmptyRows:Xc,sparseReshape:Qc,sparseSegmentMean:eh,sparseSegmentSum:th},hh={stringNGrams:nh,stringSplit:rh,stringToHashBucketFast:sh};class dh extends Ho{minimize(e,t=!1,n){const{value:r,grads:s}=this.computeGradients(e,n);if(null!=n){const e=n.map((e=>({name:e.name,tensor:s[e.name]})));this.applyGradients(e)}else this.applyGradients(s);return fo(s),t?r:(r.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return Qi(e,t)}dispose(){null!=this.iterations_&&fo(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ii(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error(`setWeights() is not implemented for this optimizer class ${this.getClassName()}`)}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(dh,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class ph extends dh{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=qr.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=qr.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:`${t}/accum_grad`,variable:po((()=>gi(r).variable(false)))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:`${t}/accum_var`,variable:po((()=>gi(r).variable(false)))});const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;po((()=>{const e=ea(ra(o,this.rho),ra(_i(s),1-this.rho)),t=ra(na(Ni(ea(a,this.epsilon)),Ni(ea(o,this.epsilon))),s),n=ea(ra(a,this.rho),ra(_i(t),1-this.rho));o.assign(e),a.assign(n);const i=ea(ra(t,-this.learningRate),r);r.assign(i)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(fo(this.accumulatedGrads.map((e=>e.variable))),fo(this.accumulatedUpdates.map((e=>e.variable))))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedUpdates=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}ph.className="Adadelta",jo(ph);class fh extends dh{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=qr.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:`${t}/accumulator`,variable:po((()=>Li(r.shape,this.initialAccumulatorValue).variable(e)))}}const s=Array.isArray(e)?e[n].tensor:e[t];if(null==s)return;const o=this.accumulatedGrads[n].variable;po((()=>{const e=ea(o,_i(s));o.assign(e);const t=ea(ra(na(s,Ni(ea(e,qr.backend.epsilon()))),-this.learningRate),r);r.assign(t)}))})),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&fo(this.accumulatedGrads.map((e=>e.variable)))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}fh.className="Adagrad",jo(fh);class gh extends dh{constructor(e,t,n,r=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],po((()=>{this.accBeta1=Ii(t).variable(),this.accBeta2=Ii(n).variable()})),null==r&&(this.epsilon=qr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);po((()=>{const n=sl(1,this.accBeta1),r=sl(1,this.accBeta2);t.forEach(((t,s)=>{const o=qr.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:po((()=>gi(o).variable(false)))}),null==this.accumulatedSecondMoment[s]&&(this.accumulatedSecondMoment[s]={originalName:`${t}/v`,variable:po((()=>gi(o).variable(false)))});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedSecondMoment[s].variable,u=ea(ra(i,this.beta1),ra(a,1-this.beta1)),c=ea(ra(l,this.beta2),ra(_i(a),1-this.beta2)),h=na(u,n),d=na(c,r);i.assign(u),l.assign(c);const p=ea(ra(na(h,ea(Ni(d),this.epsilon)),-this.learningRate),o);o.assign(p)})),this.accBeta1.assign(ra(this.accBeta1,this.beta1)),this.accBeta2.assign(ra(this.accBeta2,this.beta2))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&fo(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedSecondMoment&&fo(this.accumulatedSecondMoment.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e),po((()=>{this.accBeta1.assign(Ai(this.beta1,this.iterations_+1)),this.accBeta2.assign(Ai(this.beta2,this.iterations_+1))}));const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)}))),this.accumulatedSecondMoment=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}gh.className="Adam",jo(gh);class mh extends dh{constructor(e,t,n,r=null,s=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.decay=s,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],po((()=>{this.iteration=Ii(0).variable(),this.accBeta1=Ii(t).variable()})),null==r&&(this.epsilon=qr.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map((e=>e.name)):Object.keys(e);po((()=>{const n=sl(1,this.accBeta1),r=na(-this.learningRate,ea(ra(this.iteration,this.decay),1));t.forEach(((t,s)=>{const o=qr.registeredVariables[t];null==this.accumulatedFirstMoment[s]&&(this.accumulatedFirstMoment[s]={originalName:`${t}/m`,variable:gi(o).variable(false)}),null==this.accumulatedWeightedInfNorm[s]&&(this.accumulatedWeightedInfNorm[s]={originalName:`${t}/v`,variable:gi(o).variable(false)});const a=Array.isArray(e)?e[s].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[s].variable,l=this.accumulatedWeightedInfNorm[s].variable,u=ea(ra(i,this.beta1),ra(a,1-this.beta1)),c=ra(l,this.beta2),h=sa(a),d=ml(c,h);i.assign(u),l.assign(d);const p=ea(ra(na(r,n),na(u,ea(d,this.epsilon))),o);o.assign(p)})),this.iteration.assign(ea(this.iteration,1)),this.accBeta1.assign(ra(this.accBeta1,this.beta1))})),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&fo(this.accumulatedFirstMoment.map((e=>e.variable))),null!=this.accumulatedWeightedInfNorm&&fo(this.accumulatedWeightedInfNorm.map((e=>e.variable)))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}mh.className="Adamax",jo(mh);class bh extends dh{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const s=qr.registeredVariables[t];po((()=>{const e=ea(ra(this.c,r),s);s.assign(e)}))})),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=go(Ii(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}bh.className="SGD",jo(bh);class yh extends bh{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Ii(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=qr.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:`${t}/momentum`,variable:po((()=>gi(r).variable(e)))}}const s=this.accumulations[n].variable,o=Array.isArray(e)?e[n].tensor:e[t];null!=o&&po((()=>{let e;const t=ea(ra(this.m,s),o);e=this.useNesterov?ea(ra(this.c,ea(o,ra(t,this.m))),r):ea(ra(this.c,t),r),s.assign(t),r.assign(e)}))})),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&fo(this.accumulations.map((e=>e.variable)))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map((e=>({originalName:e.name,variable:e.tensor.variable(false)})))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}yh.className="Momentum",jo(yh);class wh extends dh{constructor(e,t=.9,n=0,r=null,s=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=r,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=s,null==r&&(this.epsilon=qr.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map((e=>e.name)):Object.keys(e)).forEach(((t,n)=>{const r=qr.registeredVariables[t],s=!1;null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:`${t}/rms`,variable:po((()=>gi(r).variable(s)))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:`${t}/momentum`,variable:po((()=>gi(r).variable(s)))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:`${t}/mg`,variable:po((()=>gi(r).variable(s)))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const a=this.accumulatedMeanSquares[n].variable,i=this.accumulatedMoments[n].variable;po((()=>{const e=ea(ra(a,this.decay),ra(_i(o),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,s=ea(ra(t,this.decay),ra(o,1-this.decay)),l=na(ra(o,this.learningRate),Ni(sl(e,ea(_i(s),this.epsilon)))),u=ea(ra(i,this.momentum),l);a.assign(e),t.assign(s),i.assign(u);const c=sl(r,u);r.assign(c)}else{const e=ea(ra(a,this.decay),ra(_i(o),1-this.decay)),t=ea(ra(i,this.momentum),na(ra(o,this.learningRate),Ni(ea(e,this.epsilon))));a.assign(e),i.assign(t);const n=sl(r,t);r.assign(n)}}))})),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&fo(this.accumulatedMeanSquares.map((e=>e.variable))),null!=this.accumulatedMeanGrads&&this.centered&&fo(this.accumulatedMeanGrads.map((e=>e.variable))),null!=this.accumulatedMoments&&fo(this.accumulatedMoments.map((e=>e.variable)))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map((e=>({name:e.originalName,tensor:e.variable}))))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2,n=!1;this.accumulatedMeanSquares=e.slice(0,t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.accumulatedMoments=e.slice(t,2*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map((e=>({originalName:e.name,variable:e.tensor.variable(n)}))))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}wh.className="RMSProp",jo(wh);class kh{static sgd(e){return new bh(e)}static momentum(e,t,n=!1){return new yh(e,t,n)}static rmsprop(e,t=.9,n=0,r=null,s=!1){return new wh(e,t,n,r,s)}static adam(e=.001,t=.9,n=.999,r=null){return new gh(e,t,n,r)}static adadelta(e=.001,t=.95,n=null){return new ph(e,t,n)}static adamax(e=.002,t=.9,n=.999,r=null,s=0){return new mh(e,t,n,r,s)}static adagrad(e,t=.1){return new fh(e,t)}}const vh={sgd:kh.sgd,momentum:kh.momentum,adadelta:kh.adadelta,adagrad:kh.adagrad,rmsprop:kh.rmsprop,adamax:kh.adamax,adam:kh.adam},xh="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();const Eh="->",Sh=/->/g;function $h(e,t){const n=[];for(let r=0;r<e.length;++r)0!==e[r].length&&-1===e[r].indexOf(t)&&-1!==t||n.push(r);return n}var Ah={__proto__:null,slice_util:Go,segment_util:{__proto__:null,segOpComputeOptimalWindowSize:function(e,t){let n,r=!1;for(e<=30?(n=e,r=!0):n=N(e,Math.floor(Math.sqrt(e)));!r;)n>t||n===e?r=!0:n=N(e,n+1);return n},computeOutShape:function(e,t,n){const r=[],s=e.length;for(let o=0;o<s;o++)o!==t?r.push(e[o]):r.push(n);return r},collectGatherOpShapeInfo:function(e,t,n,r){const s=t.shape.length,o=e.shape.length;if(0!==r&&(r<-s||r>s))throw new Error(`Expect batchDims in the range of [-${s}, ${s}], but got ${r}`);if(r<0&&(r+=s),r>o)throw new Error(`batchDims (${r}) must be less than rank(x) (\n    ${o}).`);if(n<r)throw new Error(`batchDims (${r}) must be less than or equal to axis (${n}).`);for(let n=0;n<r;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const a=e.shape[n],i=[];let l=1,u=1,c=1;for(let t=0;t<r;++t)i.push(e.shape[t]),l*=e.shape[t];for(let t=r;t<n;t++)i.push(e.shape[t]),u*=e.shape[t];for(let e=r;e<s;e++)i.push(t.shape[e]);for(let t=n+1;t<o;t++)i.push(e.shape[t]),c*=e.shape[t];return{batchSize:l,sliceSize:c,outerSize:u,dimSize:a,outputShape:i}}},fromUint8ToStringArray:function(e){try{return e.map((e=>hr(e)))}catch(e){throw new Error(`Failed to decode encoded string bytes into utf-8, error: ${e}`)}},fromStringArrayToUint8:function(e){return e.map((e=>cr(e)))},upcastType:Dr,axesAreInnerMostDims:vi,combineLocations:xi,computeOutAndReduceShapes:function(e,t){const n=[],r=e.length;for(let s=0;s<r;s++)-1===t.indexOf(s)&&n.push(e[s]);return[n,t.map((t=>e[t]))]},expandShapeToKeepDim:Ei,assertAxesAreInnerMostDims:function(e,t,n){a(vi(t,n),(()=>`${e} supports only inner-most axes for now. Got axes ${t} and rank-${n} input.`))},getAxesPermutation:function(e,t){if(vi(e,t))return null;const n=[];for(let r=0;r<t;++r)-1===e.indexOf(r)&&n.push(r);return e.forEach((e=>n.push(e))),n},getUndoAxesPermutation:function(e){return e.map(((e,t)=>[t,e])).sort(((e,t)=>e[1]-t[1])).map((e=>e[0]))},getInnerMostAxes:function(e,t){const n=[];for(let r=t-e;r<t;++r)n.push(r);return n},getBroadcastDims:vo,getReductionAxes:xo,assertAndGetBroadcastShape:Eo,assertParamsConsistent:function(e,t){const n=e[0].length;e.forEach(((e,t)=>{a(e.length===n,(()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`))})),a(t>=0&&t<n,(()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`));const r=e[0];e.forEach(((e,s)=>{for(let o=0;o<n;o++)a(o===t||e[o]===r[o],(()=>`Error in concat${n}D: Shape of tensors[${s}] (${e}) does not match the shape of the rest (${r}) along the non-concatenated axis ${s}.`))}))},computeOutShape:function(e,t){const n=e[0].slice();for(let r=1;r<e.length;r++)n[t]+=e[r][t];return n},computeDilation2DInfo:function(e,t,n,r,s="NHWC",o){return ya(e,[...t,e[3]],n,o,r,null,null,Ia(s))},computePool2DInfo:ba,computePool3DInfo:function(e,t,n,r,s,o,a="NDHWC"){const[i,l,u]=xa(t);let c,h;if("NDHWC"===a)h="channelsLast",c=[i,l,u,e[4],e[4]];else{if("NCDHW"!==a)throw new Error(`Unknown dataFormat ${a}`);h="channelsFirst",c=[i,l,u,e[1],e[1]]}return wa(e,c,n,r,s,!1,h,o)},computeConv2DInfo:ya,computeConv3DInfo:wa,computeDefaultPad:ka,tupleValuesAreOne:$a,eitherStridesOrDilationsAreOne:Aa,convertConv2DDataFormat:Ia,checkPadOnDimRoundingMode:Na,getFusedDyActivation:ec,getFusedBiasGradient:tc,applyActivation:nc,shouldFuse:rc,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:function(e){return e<=30?e:N(e,Math.floor(Math.sqrt(e)))},getImageCenter:function(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]},getReshaped:function(e,t,n,r=!0){let s=[];if(r)s=s.concat(t.slice(0)),s.push(e[0]/n),s=s.concat(e.slice(1));else{s=s.concat(e[0]);const n=t.length;for(let r=0;r<n;++r)s=s.concat([e[r+1]/t[r],t[r]]);s=s.concat(e.slice(n+1))}return s},getPermuted:function(e,t,n=!0){const r=[];if(n){r.push(t);for(let n=t+1;n<e;++n)n<=2*t?(r.push(n),r.push(n-(t+1))):r.push(n)}else{const n=[],s=[];for(let r=1;r<e;++r)r>=2*t+1||r%2==1?s.push(r):n.push(r);r.push(...n),r.push(0),r.push(...s)}return r},getReshapedPermuted:function(e,t,n,r=!0){const s=[];r?s.push(e[0]/n):s.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?r?s.push(t[n-1]*e[n]):s.push(e[n]/t[n-1]):s.push(e[n]);return s},getSliceBeginCoords:function(e,t){const n=[0];for(let r=0;r<t;++r)n.push(e[r][0]);return n},getSliceSize:function(e,t,n){const r=e.slice(0,1);for(let s=0;s<n;++s)r.push(e[s+1]-t[s][0]-t[s][1]);return r},prepareAndValidate:Mo,validateUpdateShape:Do,validateInput:Ro,calculateShapes:Bo,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:1.0507009873554805,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:bn,log:function(...e){L().getBool("IS_TEST")||L().getBool("PROD")||console.log(...e)},mergeRealAndImagArrays:function(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let r=0;r<n.length;r+=2)n[r]=e[r/2],n[r+1]=t[r/2];return n},splitRealAndImagArrays:function(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let r=0;r<e.length;r+=2)t[r/2]=e[r],n[r/2]=e[r+1];return{real:t,imag:n}},complexWithEvenIndex:function(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},complexWithOddIndex:function(e){const t=Math.floor(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},getComplexWithIndex:function(e,t){return{real:e[2*t],imag:e[2*t+1]}},assignToTypedArray:function(e,t,n,r){e[2*r]=t,e[2*r+1]=n},exponents:function(e,t){const n=new Float32Array(e/2),r=new Float32Array(e/2);for(let s=0;s<Math.ceil(e/2);s++){const o=(t?2:-2)*Math.PI*(s/e);n[s]=Math.cos(o),r[s]=Math.sin(o)}return{real:n,imag:r}},exponent:function(e,t,n){const r=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(r),imag:Math.sin(r)}},decodeEinsumEquation:function(e,t){const n=((e=e.replace(/\s/g,"")).length-e.replace(Sh,"").length)/Eh.length;if(n<1)throw new Error("Equations without an arrow are not supported.");if(n>1)throw new Error('Equation must contain exactly one arrow ("->").');const[r,s]=e.split(Eh);a(-1===r.indexOf("..."),(()=>'The ellipsis notation ("...") is not supported yet.'));const o=r.split(","),i=o.length;if(t!==i)throw new Error(`Expected ${i} input tensors, received ${t}`);if(i>2)throw new Error("Support for more than 2 input tensors is not implemented yet.");const l=[];for(let e=0;e<s.length;++e){const t=s[e];if(!o.some((e=>-1!==e.indexOf(t))))throw new Error(`Output subscripts contain the label ${t} not present in the input subscripts.`);-1===l.indexOf(t)&&l.push(t)}for(let e=0;e<r.length;++e){const t=r[e];-1===l.indexOf(t)&&","!==t&&l.push(t)}const u=new Array(o.length);for(let e=0;e<i;++e){if(new Set(o[e].split("")).size!==o[e].length)throw new Error(`Found duplicate axes in input component ${o[e]}. Support for duplicate axes in input is not implemented yet.`);u[e]=[];for(let t=0;t<o[e].length;++t)u[e].push(l.indexOf(o[e][t]))}const c=l.length,h=[];for(let e=s.length;e<c;++e)h.push(e);return{allDims:l,summedDims:h,idDims:u}},getEinsumPermutation:function(e,t){let n=new Array(e);n.fill(-1);for(let e=0;e<t.length;++e)n[t[e]]=e;const r=[];for(let t=0;t<e;++t)-1===n[t]&&r.push(t);return n=n.filter((e=>-1!==e)),{permutationIndices:n,expandDims:r}},checkEinsumDimSizes:function(e,t,n){const r=new Array(e);for(let e=0;e<n.length;++e){const s=n[e].shape;for(let n=0;n<t[e].length;++n)void 0===r[t[e][n]]?r[t[e][n]]=s[n]:a(r[t[e][n]]===s[n],(()=>`Expected dimension ${r[t[e][n]]} at axis ${n} of input shaped ${JSON.stringify(s)}, but got dimension ${s[n]}`))}},getEinsumComputePath:function(e,t){const n=e,r=[];let s=0;0===e.length&&n.push(-1),s=e.length+1;for(let e=0;e<s;++e)r.push([]);const o=[];for(let e=0;e<n.length;++e){const s=$h(t,n[e]);for(const t of s)-1===o.indexOf(t)&&(r[e].push(t),o.push(t))}return{path:n,steps:r}},isIdentityPermutation:function(e){return e.every(((e,t)=>e===t))},prepareSplitSize:function(e,t,n=0){let r=[];if("number"==typeof t)a(e.shape[n]%t==0,(()=>"Number of splits must evenly divide the axis.")),r=new Array(t).fill(e.shape[n]/t);else{a(t.reduce(((e,t)=>(-1===t&&(e+=1),e)),0)<=1,(()=>"There should be only one negative value in split array."));const s=t.indexOf(-1);if(-1!==s){const r=t.reduce(((e,t)=>t>0?e+t:e));t[s]=e.shape[n]-r}a(e.shape[n]===t.reduce(((e,t)=>e+t)),(()=>"The sum of sizes must match the size of the axis dimension.")),r=t}return r},getSparseFillEmptyRowsIndicesDenseShapeMismatch:function(e){return`Received SparseTensor with denseShape[0] = 0 but\n  indices.shape[0] = ${e}`},getSparseFillEmptyRowsNegativeIndexErrorMessage:function(e,t){return`indices(${e}, 0) is invalid: ${t} < 0`},getSparseFillEmptyRowsOutOfRangeIndexErrorMessage:function(e,t,n){return`indices(${e}, 0) is invalid: ${t} >= ${n}`},getSparseReshapeMultipleNegativeOneOutputDimErrorMessage:function(e,t){return`only one output dimension may be -1, not both ${e} and ${t}`},getSparseReshapeNegativeOutputDimErrorMessage:function(e,t){return`size ${e} must be non-negative, not ${t}`},getSparseReshapeEmptyTensorZeroOutputDimErrorMessage:function(){return"reshape cannot infer the missing input size for an empty tensor unless all specified input sizes are non-zero"},getSparseReshapeInputOutputMultipleErrorMessage:function(e,t){return`Input to reshape is a SparseTensor with ${c(e)}\n  dense values, but the requested shape requires a multiple of ${c(t)}. inputShape=${e} outputShape= ${t}`},getSparseReshapeInputOutputMismatchErrorMessage:function(e,t){return`Input to reshape is a tensor with ${c(e)} dense values, but the requested shape has ${c(t)}. inputShape=${e} outputShape=${t}`},getSparseSegmentReductionNegativeSegmentIdsErrorMessage:function(){return"segment ids must be >= 0"},getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage:function(){return"segment ids are not increasing"},getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage:function(e,t){return`Segment id ${e} out of range [0, ${t}), possibly because segmentIds input is not sorted.`},getSparseSegmentReductionIndicesOutOfRangeErrorMessage:function(e,t,n){return`Bad: indices[${e}] == ${t} out of range [0, ${n})`}},Ih={__proto__:null,nonMaxSuppressionV3Impl:xc,nonMaxSuppressionV4Impl:Ec,nonMaxSuppressionV5Impl:Sc,whereImpl:qu};e.Abs="Abs",e.Acos=K,e.Acosh=U,e.AdadeltaOptimizer=ph,e.AdagradOptimizer=fh,e.AdamOptimizer=gh,e.AdamaxOptimizer=mh,e.Add=G,e.AddN=H,e.All="All",e.Any="Any",e.ArgMax=V,e.ArgMin=j,e.Asin=J,e.Asinh=Z,e.Atan=Y,e.Atan2=Q,e.Atanh=X,e.AvgPool=ee,e.AvgPool3D=te,e.AvgPool3DGrad="AvgPool3DGrad",e.AvgPoolGrad="AvgPoolGrad",e.BatchMatMul=ne,e.BatchToSpaceND=re,e.Bincount=se,e.BroadcastArgs=oe,e.BroadcastTo="BroadcastTo",e.Cast=ae,e.Ceil=ie,e.ClipByValue=le,e.Complex=ue,e.ComplexAbs=ce,e.Concat=he,e.Conv2D=de,e.Conv2DBackpropFilter=pe,e.Conv2DBackpropInput=fe,e.Conv3D=ge,e.Conv3DBackpropFilterV2="Conv3DBackpropFilterV2",e.Conv3DBackpropInputV2=me,e.Cos="Cos",e.Cosh=be,e.CropAndResize=ke,e.Cumprod=ye,e.Cumsum=we,e.DataStorage=class{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}},e.DenseBincount=ve,e.DepthToSpace=xe,e.DepthwiseConv2dNative=Ee,e.DepthwiseConv2dNativeBackpropFilter=Se,e.DepthwiseConv2dNativeBackpropInput=$e,e.Diag=Ae,e.Dilation2D=Ie,e.Dilation2DBackpropFilter="Dilation2DBackpropFilter",e.Dilation2DBackpropInput="Dilation2DBackpropInput",e.Einsum=_e,e.Elu="Elu",e.EluGrad="EluGrad",e.Environment=P,e.Equal=Me,e.Erf="Erf",e.Exp="Exp",e.ExpandDims=Te,e.Expm1=De,e.FFT="FFT",e.Fill=Re,e.FlipLeftRight=Be,e.Floor=Fe,e.FloorDiv=Ce,e.FromPixels=dn,e.FusedBatchNorm=Pe,e.FusedConv2D=gn,e.FusedDepthwiseConv2D=mn,e.GatherNd=Le,e.GatherV2=Oe,e.Greater=ze,e.GreaterEqual=We,e.IFFT=Ke,e.Identity=qe,e.Imag=Ue,e.IsFinite=Ge,e.IsInf=He,e.IsNan=Ve,e.KernelBackend=t,e.LRN="LRN",e.LRNGrad="LRNGrad",e.LeakyRelu=je,e.Less=Je,e.LessEqual=Ze,e.LinSpace=Ye,e.Log="Log",e.Log1p=Xe,e.LogSoftmax="LogSoftmax",e.LogicalAnd=Qe,e.LogicalNot=et,e.LogicalOr=tt,e.LogicalXor="LogicalXor",e.LowerBound="LowerBound",e.Max="Max",e.MaxPool=rt,e.MaxPool3D=st,e.MaxPool3DGrad="MaxPool3DGrad",e.MaxPoolGrad="MaxPoolGrad",e.MaxPoolWithArgmax=ot,e.Maximum=nt,e.Mean=at,e.Min="Min",e.Minimum=it,e.MirrorPad=lt,e.Mod="Mod",e.MomentumOptimizer=yh,e.Multinomial=ut,e.Multiply=ct,e.Neg="Neg",e.NonMaxSuppressionV3=dt,e.NonMaxSuppressionV4=pt,e.NonMaxSuppressionV5=ft,e.NotEqual=ht,e.OP_SCOPE_SUFFIX=Qr,e.OneHot=mt,e.OnesLike=gt,e.Optimizer=dh,e.OptimizerConstructors=kh,e.Pack=bt,e.PadV2=yt,e.Pool="Pool",e.Pow="Pow",e.Prelu=wt,e.Prod=kt,e.RMSPropOptimizer=wh,e.Range=vt,e.Real=xt,e.RealDiv=Ne,e.Reciprocal=Et,e.Relu=St,e.Relu6=Nt,e.Reshape=$t,e.ResizeBilinear=It,e.ResizeBilinearGrad="ResizeBilinearGrad",e.ResizeNearestNeighbor=At,e.ResizeNearestNeighborGrad="ResizeNearestNeighborGrad",e.Reverse=_t,e.RotateWithOffset=pn,e.Round=Mt,e.Rsqrt=Tt,e.SGDOptimizer=bh,e.ScatterNd=Dt,e.SearchSorted=Rt,e.Select=Bt,e.Selu=Ft,e.Sigmoid=Lt,e.Sign=Ot,e.Sin="Sin",e.Sinh=Pt,e.Slice=Ct,e.Softmax=Ut,e.Softplus=zt,e.SpaceToBatchND=qt,e.SparseFillEmptyRows=Gt,e.SparseReshape=Ht,e.SparseSegmentMean=Vt,e.SparseSegmentSum=jt,e.SparseToDense=Jt,e.SplitV=Kt,e.Sqrt=Wt,e.Square="Square",e.SquaredDifference=Zt,e.Step=hn,e.StridedSlice=Yt,e.StringNGrams=Xt,e.StringSplit=Qt,e.StringToHashBucketFast=en,e.Sub="Sub",e.Sum="Sum",e.Tan="Tan",e.Tanh=tn,e.Tensor=Sr,e.TensorBuffer=vr,e.Tile=nn,e.TopK=rn,e.Transform=sn,e.Transpose=on,e.Unique=an,e.Unpack=ln,e.UnsortedSegmentSum=un,e.UpperBound="UpperBound",e.Variable=$r,e.ZerosLike=cn,e._FusedMatMul=fn,e.abs=sa,e.acos=oa,e.acosh=aa,e.add=ea,e.addN=ia,e.all=la,e.any=ua,e.argMax=ca,e.argMin=ha,e.asin=da,e.asinh=pa,e.atan=fa,e.atan2=ga,e.atanh=ma,e.avgPool=Ma,e.avgPool3d=Ta,e.backend=function(){return qr.backend},e.backend_util=Ah,e.basicLSTMCell=Ca,e.batchNorm=Oa,e.batchNorm2d=La,e.batchNorm3d=za,e.batchNorm4d=Wa,e.batchToSpaceND=Pa,e.bincount=qa,e.booleanMaskAsync=Uu,e.broadcastArgs=Ka,e.broadcastTo=Ua,e.broadcast_util=So,e.browser=_o,e.buffer=Gs,e.cast=Hs,e.ceil=Ga,e.clipByValue=Ha,e.clone=Vs,e.complex=ts,e.concat=Da,e.concat1d=Va,e.concat2d=ja,e.concat3d=Ja,e.concat4d=Za,e.conv1d=Xa,e.conv2d=Ya,e.conv2dTranspose=ei,e.conv3d=ti,e.conv3dTranspose=ri,e.copyRegisteredKernels=function(e,t){xn(e).forEach((e=>{En(Object.assign({},e,{backendName:t}))}))},e.cos=si,e.cosh=oi,e.cosineWindow=Yu,e.cumprod=ai,e.cumsum=ii,e.customGrad=el,e.denseBincount=li,e.deprecationWarn=function(e){L().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")},e.depthToSpace=ui,e.depthwiseConv2d=ci,e.device_util=Hr,e.diag=hi,e.dilation2d=di,e.disableDeprecationWarnings=function(){L().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},e.dispose=fo,e.disposeVariables=function(){qr.disposeVariables()},e.div=na,e.divNoNan=mi,e.dot=bi,e.dropout=Ju,e.einsum=yi,e.elu=wi,e.enableDebugMode=function(){L().set("DEBUG",!0)},e.enableProdMode=function(){L().set("PROD",!0)},e.enclosingPowerOfTwo=Zu,e.engine=function(){return qr},e.env=L,e.equal=pi,e.erf=ki,e.euclideanNorm=Ri,e.exp=Bi,e.expandDims=Fi,e.expm1=Ci,e.eye=Oi,e.fft=Su,e.fill=Li,e.findBackend=function(e){return qr.findBackend(e)},e.findBackendFactory=function(e){return qr.findBackendFactory(e)},e.floor=zi,e.floorDiv=ta,e.fused=uc,e.gather=Wi,e.gatherND=ju,e.gather_util=To,e.getBackend=function(){return qr.backendName},e.getGradient=vn,e.getKernel=kn,e.getKernelsForBackend=xn,e.grad=function(e){return a(I(e),(()=>"The f passed in grad(f) must be a function")),(t,n)=>{const r=Yr(t,"x","tf.grad","string_or_numeric"),s=null!=n?Yr(n,"dy","tf.grad"):null;return qr.tidy((()=>{const{value:t,grads:n}=qr.gradients((()=>e(r)),[r],s);return null!=s&&i(t.shape,s.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),tl(n),n[0]}))}},e.grads=function(e){return a(I(e),(()=>"The f passed in grads(f) must be a function")),(t,n)=>{a(Array.isArray(t),(()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s"));const r=Xr(t,"args","tf.grads","string_or_numeric"),s=null!=n?Yr(n,"dy","tf.grads"):null;return qr.tidy((()=>{const{value:t,grads:n}=qr.gradients((()=>e(...r)),r,s);return null!=s&&i(t.shape,s.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),tl(n),n}))}},e.greater=qi,e.greaterEqual=Ki,e.ifft=$u,e.imag=mo,e.image=ih,e.inTopKAsync=Xu,e.io=uo,e.irfft=Au,e.isFinite=Ui,e.isInf=Gi,e.isNaN=Hi,e.keep=go,e.kernel_impls=Ih,e.leakyRelu=Vi,e.less=ji,e.lessEqual=Ji,e.linalg=lh,e.linspace=function(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return qr.runKernel(Ye,{},r)},e.localResponseNormalization=Zi,e.log=Yi,e.log1p=Xi,e.logSigmoid=rl,e.logSoftmax=ol,e.logSumExp=al,e.logicalAnd=il,e.logicalNot=ll,e.logicalOr=ul,e.logicalXor=cl,e.losses=uh,e.lowerBound=function(e,t){return dl(e,t,"left")},e.matMul=co,e.math=ko,e.max=Si,e.maxPool=pl,e.maxPool3d=fl,e.maxPoolWithArgmax=gl,e.maximum=ml,e.mean=bl,e.memory=function(){return qr.memory()},e.meshgrid=function(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Yr(e,"x","meshgrid",e instanceof Sr?e.dtype:"float32");if(void 0===t)return[r];let s=Yr(t,"y","meshgrid",t instanceof Sr?t.dtype:"float32");const o=c(r.shape),a=c(s.shape);return"xy"===n?(r=_a(r,[1,-1]),s=_a(s,[-1,1]),[co(wl([a,1],r.dtype),r),co(s,wl([1,o],s.dtype))]):(r=_a(r,[-1,1]),s=_a(s,[1,-1]),[co(r,wl([1,a],r.dtype)),co(wl([o,1],s.dtype),s)])},e.min=$i,e.minimum=kl,e.mirrorPad=vl,e.mod=xl,e.moments=El,e.movingAverage=Gu,e.mul=ra,e.multiRNNCell=Sl,e.multinomial=$l,e.neg=bo,e.nextFrame=function(){return new Promise((e=>xh((()=>e()))))},e.norm=Di,e.notEqual=Al,e.oneHot=ho,e.ones=wl,e.onesLike=Il,e.op=es,e.outerProduct=Nl,e.pad=_l,e.pad1d=Ml,e.pad2d=Tl,e.pad3d=Dl,e.pad4d=Rl,e.pool=Fl,e.pow=Ai,e.prelu=Cl,e.print=js,e.prod=Pl,e.profile=function(e){return qr.profile(e)},e.rand=Ol,e.randomGamma=Xl,e.randomNormal=Ql,e.randomStandardNormal=eu,e.randomUniform=tu,e.range=nu,e.ready=function(){return qr.ready()},e.real=yo,e.reciprocal=ru,e.registerBackend=function(e,t,n=1){return qr.registerBackend(e,t,n)},e.registerGradient=function(e){const{kernelName:t}=e;wn.has(t)&&L().getBool("DEBUG")&&bn(`Overriding the gradient for '${t}'`),wn.set(t,e)},e.registerKernel=En,e.relu=su,e.relu6=ou,e.removeBackend=function(e){qr.removeBackend(e)},e.reshape=_a,e.reverse=au,e.reverse1d=iu,e.reverse2d=lu,e.reverse3d=uu,e.reverse4d=cu,e.rfft=Nu,e.round=hu,e.rsqrt=du,e.scalar=Ii,e.scatterND=Hu,e.scatter_util=Fo,e.searchSorted=dl,e.selu=pu,e.separableConv2d=fu,e.serialization=Jo,e.setBackend=function(e){return qr.setBackend(e)},e.setPlatform=function(e,t){L().setPlatform(e,t)},e.setdiff1dAsync=gu,e.sigmoid=Ra,e.sign=mu,e.signal=ah,e.sin=bu,e.sinh=yu,e.slice=Ba,e.slice1d=wu,e.slice2d=ku,e.slice3d=vu,e.slice4d=xu,e.slice_util=Go,e.softmax=Eu,e.softplus=nl,e.spaceToBatchND=Bl,e.sparse=ch,e.sparseToDense=Vu,e.spectral=oh,e.split=Iu,e.sqrt=Ni,e.square=_i,e.squaredDifference=_u,e.squeeze=Mu,e.stack=Tu,e.step=Du,e.stridedSlice=Ru,e.string=hh,e.sub=sl,e.sum=Mi,e.sumOutType=function(e){return Dr(e,"int32")},e.tan=Bu,e.tanh=Fa,e.tensor=rs,e.tensor1d=Fu,e.tensor2d=Cu,e.tensor3d=$o,e.tensor4d=function(e,t,n){if(l(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=jr(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return ns(e,t,r,n)},e.tensor5d=function(e,t,n){if(l(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=jr(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return ns(e,t,r,n)},e.tensor6d=function(e,t,n){if(l(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=jr(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return ns(e,t=t||r,r,n)},e.tensor_util=Pr,e.test_util=Qo,e.tidy=po,e.tile=Pi,e.time=function(e){return qr.time(e)},e.topk=Pu,e.train=vh,e.transpose=wo,e.truncatedNormal=Ou,e.unique=Lu,e.unregisterGradient=function(e){if(!wn.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);wn.delete(e)},e.unregisterKernel=function(e,t){const n=Sn(e,t);if(!yn.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);yn.delete(n)},e.unsortedSegmentSum=zu,e.unstack=Wu,e.upcastType=Dr,e.upperBound=function(e,t){return dl(e,t,"right")},e.util=dr,e.valueAndGrad=function(e){return a(I(e),(()=>"The f passed in valueAndGrad(f) must be a function")),(t,n)=>{a(t instanceof Sr,(()=>"The x passed in valueAndGrad(f)(x) must be a tensor")),a(null==n||n instanceof Sr,(()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor"));const{grads:r,value:s}=qr.gradients((()=>e(t)),[t],n);return tl(r),{grad:r[0],value:s}}},e.valueAndGrads=function(e){return a(I(e),(()=>"The f passed in valueAndGrads(f) must be a function")),(t,n)=>{a(Array.isArray(t)&&t.every((e=>e instanceof Sr)),(()=>"The args passed in valueAndGrads(f)(args) must be array of tensors")),a(null==n||n instanceof Sr,(()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor"));const r=qr.gradients((()=>e(...t)),t,n);return null!=n&&i(r.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),tl(r.grads),r}},e.variable=function(e,t=!0,n,r){return qr.makeVariable(e,t,n,r)},e.variableGrads=Qi,e.version_core="3.19.0",e.where=fi,e.whereAsync=Ku,e.zeros=yl,e.zerosLike=gi,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-core.es2017.min.js.map
