import { assert } from '../util';
/**
 * Prepare the split size array. When the input is a number, the axis is evenly
 * divided among the split size. When the input contains the negative value, the
 * rest of the axis is allocated toward that.
 */
export function prepareSplitSize(x, numOrSizeSplits, axis = 0) {
    let splitSizes = [];
    if (typeof (numOrSizeSplits) === 'number') {
        assert(x.shape[axis] % numOrSizeSplits === 0, () => 'Number of splits must evenly divide the axis.');
        splitSizes =
            new Array(numOrSizeSplits).fill(x.shape[axis] / numOrSizeSplits);
    }
    else {
        const numOfNegs = numOrSizeSplits.reduce((count, value) => {
            if (value === -1) {
                count += 1;
            }
            return count;
        }, 0);
        assert(numOfNegs <= 1, () => 'There should be only one negative value in split array.');
        const negIndex = numOrSizeSplits.indexOf(-1);
        // Allow the number of split array to be -1, which indicates the rest
        // of dimension is allocated to that split.
        if (negIndex !== -1) {
            const total = numOrSizeSplits.reduce((a, b) => b > 0 ? a + b : a);
            numOrSizeSplits[negIndex] = x.shape[axis] - total;
        }
        assert(x.shape[axis] === numOrSizeSplits.reduce((a, b) => a + b), () => 'The sum of sizes must match the size of the axis dimension.');
        splitSizes = numOrSizeSplits;
    }
    return splitSizes;
}
//# sourceMappingURL=data:application/json;base64,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