/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import * as tf from './index';
/**
 * Returns an image used in various image related tests as a 4d tensor.
 *
 * The image is 8x8 and looks like this:
 * https://drive.google.com/file/d/1Y0AsFZ2w9HsWgJfm8f2uDOGY7A4IHjcK/view?usp=sharing
 *
 */
export function getTestImageAsTensor4d() {
    return tf.tensor4d([
        156, 100, 111, 255, 171, 120, 117, 255, 183, 138, 109, 255, 200, 155,
        98, 255, 212, 157, 75, 255, 224, 156, 55, 255, 241, 153, 43, 255,
        230, 133, 18, 255, 168, 129, 130, 255, 186, 152, 140, 255, 202, 174,
        137, 255, 220, 190, 128, 255, 230, 193, 104, 255, 241, 188, 82, 255,
        250, 177, 64, 255, 233, 148, 31, 255, 179, 176, 159, 255, 199, 198,
        168, 255, 211, 216, 162, 255, 225, 228, 151, 255, 235, 227, 128, 255,
        243, 220, 106, 255, 247, 201, 81, 255, 222, 164, 41, 255, 163, 208,
        187, 255, 179, 226, 194, 255, 184, 234, 181, 255, 191, 239, 165, 255,
        201, 236, 142, 255, 213, 230, 126, 255, 218, 210, 103, 255, 191, 170,
        61, 255, 108, 214, 202, 255, 119, 226, 206, 255, 121, 231, 192, 255,
        130, 235, 179, 255, 141, 232, 162, 255, 155, 226, 146, 255, 162, 206,
        127, 255, 135, 166, 86, 255, 55, 207, 212, 255, 62, 217, 213, 255,
        64, 219, 201, 255, 76, 225, 193, 255, 87, 220, 175, 255, 94, 206,
        156, 255, 98, 181, 135, 255, 71, 143, 97, 255, 18, 200, 224, 255,
        19, 204, 222, 255, 19, 203, 211, 255, 30, 209, 205, 255, 35, 200,
        186, 255, 37, 177, 164, 255, 39, 150, 141, 255, 15, 115, 105, 255,
        0, 193, 228, 255, 0, 192, 221, 255, 0, 189, 209, 255, 0, 194,
        204, 255, 4, 182, 186, 255, 3, 158, 162, 255, 6, 133, 140, 255,
        0, 102, 113, 255
    ], [1, 8, 8, 4]);
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW1hZ2VfdGVzdF91dGlsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vdGZqcy1jb3JlL3NyYy9pbWFnZV90ZXN0X3V0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7Ozs7Ozs7Ozs7Ozs7OztHQWVHO0FBRUgsT0FBTyxLQUFLLEVBQUUsTUFBTSxTQUFTLENBQUM7QUFFOUI7Ozs7OztHQU1HO0FBQ0gsTUFBTSxVQUFVLHNCQUFzQjtJQUNwQyxPQUFPLEVBQUUsQ0FBQyxRQUFRLENBQ2Q7UUFDRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLEVBQUUsRUFBRyxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxFQUFFLEVBQUcsR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFHLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxDQUFDLEVBQUksR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQyxFQUFJLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsRUFBSSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDLEVBQUksR0FBRztRQUNwRSxHQUFHLEVBQUUsR0FBRyxFQUFFLENBQUMsRUFBSSxHQUFHLEVBQUUsR0FBRyxFQUFFLEdBQUcsRUFBRSxDQUFDLEVBQUksR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHLEVBQUUsQ0FBQyxFQUFJLEdBQUcsRUFBRSxHQUFHLEVBQUUsR0FBRztRQUNwRSxDQUFDLEVBQUksR0FBRyxFQUFFLEdBQUcsRUFBRSxHQUFHO0tBQ25CLEVBQ0QsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3BCLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgMjAyMSBHb29nbGUgTExDLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKiA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICovXG5cbmltcG9ydCAqIGFzIHRmIGZyb20gJy4vaW5kZXgnO1xuXG4vKipcbiAqIFJldHVybnMgYW4gaW1hZ2UgdXNlZCBpbiB2YXJpb3VzIGltYWdlIHJlbGF0ZWQgdGVzdHMgYXMgYSA0ZCB0ZW5zb3IuXG4gKlxuICogVGhlIGltYWdlIGlzIDh4OCBhbmQgbG9va3MgbGlrZSB0aGlzOlxuICogaHR0cHM6Ly9kcml2ZS5nb29nbGUuY29tL2ZpbGUvZC8xWTBBc0ZaMnc5SHNXZ0pmbThmMnVET0dZN0E0SUhqY0svdmlldz91c3A9c2hhcmluZ1xuICpcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIGdldFRlc3RJbWFnZUFzVGVuc29yNGQoKSB7XG4gIHJldHVybiB0Zi50ZW5zb3I0ZChcbiAgICAgIFtcbiAgICAgICAgMTU2LCAxMDAsIDExMSwgMjU1LCAxNzEsIDEyMCwgMTE3LCAyNTUsIDE4MywgMTM4LCAxMDksIDI1NSwgMjAwLCAxNTUsXG4gICAgICAgIDk4LCAgMjU1LCAyMTIsIDE1NywgNzUsICAyNTUsIDIyNCwgMTU2LCA1NSwgIDI1NSwgMjQxLCAxNTMsIDQzLCAgMjU1LFxuICAgICAgICAyMzAsIDEzMywgMTgsICAyNTUsIDE2OCwgMTI5LCAxMzAsIDI1NSwgMTg2LCAxNTIsIDE0MCwgMjU1LCAyMDIsIDE3NCxcbiAgICAgICAgMTM3LCAyNTUsIDIyMCwgMTkwLCAxMjgsIDI1NSwgMjMwLCAxOTMsIDEwNCwgMjU1LCAyNDEsIDE4OCwgODIsICAyNTUsXG4gICAgICAgIDI1MCwgMTc3LCA2NCwgIDI1NSwgMjMzLCAxNDgsIDMxLCAgMjU1LCAxNzksIDE3NiwgMTU5LCAyNTUsIDE5OSwgMTk4LFxuICAgICAgICAxNjgsIDI1NSwgMjExLCAyMTYsIDE2MiwgMjU1LCAyMjUsIDIyOCwgMTUxLCAyNTUsIDIzNSwgMjI3LCAxMjgsIDI1NSxcbiAgICAgICAgMjQzLCAyMjAsIDEwNiwgMjU1LCAyNDcsIDIwMSwgODEsICAyNTUsIDIyMiwgMTY0LCA0MSwgIDI1NSwgMTYzLCAyMDgsXG4gICAgICAgIDE4NywgMjU1LCAxNzksIDIyNiwgMTk0LCAyNTUsIDE4NCwgMjM0LCAxODEsIDI1NSwgMTkxLCAyMzksIDE2NSwgMjU1LFxuICAgICAgICAyMDEsIDIzNiwgMTQyLCAyNTUsIDIxMywgMjMwLCAxMjYsIDI1NSwgMjE4LCAyMTAsIDEwMywgMjU1LCAxOTEsIDE3MCxcbiAgICAgICAgNjEsICAyNTUsIDEwOCwgMjE0LCAyMDIsIDI1NSwgMTE5LCAyMjYsIDIwNiwgMjU1LCAxMjEsIDIzMSwgMTkyLCAyNTUsXG4gICAgICAgIDEzMCwgMjM1LCAxNzksIDI1NSwgMTQxLCAyMzIsIDE2MiwgMjU1LCAxNTUsIDIyNiwgMTQ2LCAyNTUsIDE2MiwgMjA2LFxuICAgICAgICAxMjcsIDI1NSwgMTM1LCAxNjYsIDg2LCAgMjU1LCA1NSwgIDIwNywgMjEyLCAyNTUsIDYyLCAgMjE3LCAyMTMsIDI1NSxcbiAgICAgICAgNjQsICAyMTksIDIwMSwgMjU1LCA3NiwgIDIyNSwgMTkzLCAyNTUsIDg3LCAgMjIwLCAxNzUsIDI1NSwgOTQsICAyMDYsXG4gICAgICAgIDE1NiwgMjU1LCA5OCwgIDE4MSwgMTM1LCAyNTUsIDcxLCAgMTQzLCA5NywgIDI1NSwgMTgsICAyMDAsIDIyNCwgMjU1LFxuICAgICAgICAxOSwgIDIwNCwgMjIyLCAyNTUsIDE5LCAgMjAzLCAyMTEsIDI1NSwgMzAsICAyMDksIDIwNSwgMjU1LCAzNSwgIDIwMCxcbiAgICAgICAgMTg2LCAyNTUsIDM3LCAgMTc3LCAxNjQsIDI1NSwgMzksICAxNTAsIDE0MSwgMjU1LCAxNSwgIDExNSwgMTA1LCAyNTUsXG4gICAgICAgIDAsICAgMTkzLCAyMjgsIDI1NSwgMCwgICAxOTIsIDIyMSwgMjU1LCAwLCAgIDE4OSwgMjA5LCAyNTUsIDAsICAgMTk0LFxuICAgICAgICAyMDQsIDI1NSwgNCwgICAxODIsIDE4NiwgMjU1LCAzLCAgIDE1OCwgMTYyLCAyNTUsIDYsICAgMTMzLCAxNDAsIDI1NSxcbiAgICAgICAgMCwgICAxMDIsIDExMywgMjU1XG4gICAgICBdLFxuICAgICAgWzEsIDgsIDgsIDRdKTtcbn1cbiJdfQ==