/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import*as e from"@tensorflow/tfjs-core";import{env as t,util as n,clone as r,scalar as s,keep as a,tensor as o,stack as i,concat as u,unstack as p,tidy as l,reshape as c,slice as h,io as d,Tensor as m}from"@tensorflow/tfjs-core";var f,y;t().registerFlag("KEEP_INTERMEDIATE_TENSORS",(()=>!1),(e=>{e&&console.warn("Keep intermediate tensors is ON. This will print the values of all intermediate tensors during model inference. Not all models support this mode. For details, check e2e/benchmarks/ model_config.js. This significantly impacts performance.")})),function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_QINT16=15]="DT_QINT16",e[e.DT_QUINT16=16]="DT_QUINT16",e[e.DT_UINT16=17]="DT_UINT16",e[e.DT_COMPLEX128=18]="DT_COMPLEX128",e[e.DT_HALF=19]="DT_HALF",e[e.DT_RESOURCE=20]="DT_RESOURCE",e[e.DT_VARIANT=21]="DT_VARIANT",e[e.DT_UINT32=22]="DT_UINT32",e[e.DT_UINT64=23]="DT_UINT64",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF",e[e.DT_QINT16_REF=115]="DT_QINT16_REF",e[e.DT_QUINT16_REF=116]="DT_QUINT16_REF",e[e.DT_UINT16_REF=117]="DT_UINT16_REF",e[e.DT_COMPLEX128_REF=118]="DT_COMPLEX128_REF",e[e.DT_HALF_REF=119]="DT_HALF_REF",e[e.DT_RESOURCE_REF=120]="DT_RESOURCE_REF",e[e.DT_VARIANT_REF=121]="DT_VARIANT_REF",e[e.DT_UINT32_REF=122]="DT_UINT32_REF",e[e.DT_UINT64_REF=123]="DT_UINT64_REF"}(f||(f={})),function(e){var t;(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))[t.LEGACY=0]="LEGACY",t[t.V1=1]="V1",t[t.V2=2]="V2"}(y||(y={}));const g={};function b(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};g[e]=n}function x(e){return g[e]}function N(e){delete g[e]}function w(e,t,r,s,a){const o=t.inputParams[e];if(o&&void 0!==o.inputIndexStart){const e=o.inputIndexStart,i=0===o.inputIndexEnd?void 0:void 0===o.inputIndexEnd?e+1:o.inputIndexEnd;if("tensor"===o.type)return k(t.inputNames[o.inputIndexStart],r,s,a);if("tensors"===o.type){return t.inputNames.slice(e,i).map((e=>k(e,r,s,a)))}const u=k(t.inputNames.slice(e)[0],r,s,a),p=u.dataSync();return"number"===o.type?p[0]:n.toNestedArray(u.shape,p)}const i=t.attrParams[e];return i&&i.value}function k(e,t,n,r){const[s,a]=_(e);if(null!=r){const e=r.getHashTableHandleByName(s);if(null!=e)return e}const o=n.currentContextIds.find((e=>!!t[v(s,e)]));return void 0!==o?t[v(s,o)][a]:void 0}function T(e,t){const[n,r,s]=_(e);return[v(n,t&&t.currentContextId),r,s]}function v(e,t){return t?`${e}-${t}`:e}function _(e){const t=e.split(":");if(1===t.length)return[e,0,void 0];const n=t[0],r=3===t.length?t[1]:void 0;return[n,Number(t[t.length-1]),r]}function S(e,t,n){let r=w("pad",e,t,n);if("explicit"===r){r=w("explicitPaddings",e,t,n);const s=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)s[e][0]=r[2*e],s[e][1]=r[2*e+1];return s}return r}function E(e){return e.kept?e:r(e)}var $={__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var I={__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsNan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var D={__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcatV2",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListLength",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}]},{tfOpName:"TensorListResize",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"size",type:"number"}]}]};var A={__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]};var O={__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomStandardNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]};var M={__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var C={__proto__:null,json:[{tfOpName:"LowerBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"UpperBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]};var F={__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]};var V={__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableSize",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"LookupTableSizeV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]}]};var z={__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]},{tfOpName:"ImageProjectiveTransformV3",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"transforms",type:"tensor"},{start:2,name:"outputShape",type:"number[]"},{start:3,name:"fillValue",type:"number"}],attrs:[{tfName:"interpolation",name:"interpolation",type:"string"},{tfName:"fill_mode",name:"fillMode",type:"string"}]}]};var R={__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var L={__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Einsum",category:"matrices",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"equation",name:"equation",type:"string"},{tfName:"N",name:"n",type:"number",defaultValue:2},{tfName:"T",name:"dtype",type:"dtype"}]}]};var B={__proto__:null,json:[{tfOpName:"EuclideanNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",defaultValue:!1}]},{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]};var P={__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumprod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]};var K={__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]};var q={__proto__:null,json:[{tfOpName:"SparseFillEmptyRows",category:"sparse",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"denseShape",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}]},{tfOpName:"SparseReshape",category:"sparse",inputs:[{start:0,name:"inputIndices",type:"tensor"},{start:1,name:"inputShape",type:"tensor"},{start:2,name:"newShape",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SparseSegmentMean",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]},{tfOpName:"SparseSegmentSum",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]}]};var U={__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]};var W={__proto__:null,json:[{tfOpName:"StringNGrams",category:"string",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"dataSplits",type:"tensor"}],attrs:[{tfName:"separator",name:"separator",type:"string"},{tfName:"ngram_widths",name:"nGramWidths",type:"number[]"},{tfName:"left_pad",name:"leftPad",type:"string"},{tfName:"right_pad",name:"rightPad",type:"string"},{tfName:"pad_width",name:"padWidth",type:"number"},{tfName:"preserve_short_sequences",name:"preserveShortSequences",type:"bool"}],outputs:["ngrams","ngrams_splits"]},{tfOpName:"StringSplit",category:"string",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"delimiter",type:"tensor"}],attrs:[{tfName:"skip_empty",name:"skipEmpty",type:"bool"}],outputs:["indices","values","shape"]},{tfOpName:"StringToHashBucketFast",category:"string",inputs:[{start:0,name:"input",type:"tensor"}],attrs:[{tfName:"num_buckets",name:"numBuckets",type:"number"}]}]};var H={__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]},{tfOpName:"BroadcastArgs",category:"transformation",inputs:[{start:0,name:"s0",type:"tensor"},{start:1,name:"s1",type:"tensor"}],attrs:[]}]};class j{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[$,I,D,A,O,M,C,F,V,z,R,L,B,P,K,q,U,W,H].map((e=>e.json)));this.opMappers=e.reduce(((e,t)=>(e[t.tfOpName]=t,e)),{})}transformGraph(e,t={}){const n=e.node,r=[],s=[],a=[],o=n.reduce(((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?r.push(e[t.name]):"Const"===t.op?s.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e)),{});let i=[];const u=[];let p={},l={};null!=t&&(p=this.mapSignatureEntries(t.inputs),l=this.mapSignatureEntries(t.outputs));const c=Object.keys(o);c.forEach((e=>{const t=o[e];t.inputNames.forEach(((e,n)=>{const[r,,s]=T(e),a=o[r];if(null!=a.outputs){const e=a.outputs.indexOf(s);if(-1!==e){const s=`${r}:${e}`;t.inputNames[n]=s}}t.inputs.push(a),a.children.push(t)}))})),0===Object.keys(l).length?c.forEach((e=>{const t=o[e];0===t.children.length&&u.push(t)})):Object.keys(l).forEach((e=>{const[t]=T(e),n=o[t];null!=n&&(n.signatureKey=l[e],u.push(n))})),Object.keys(p).length>0?Object.keys(p).forEach((e=>{const[t]=T(e),n=o[t];n&&(n.signatureKey=p[e],i.push(n))})):i=r;let h={};null!=e.library&&null!=e.library.function&&(h=e.library.function.reduce(((e,t)=>(e[t.signature.name]=this.mapFunction(t),e)),{}));const d={nodes:o,inputs:i,outputs:u,weights:s,placeholders:r,signature:t,functions:h};return a.length>0&&(d.initNodes=a),d}mapSignatureEntries(e){return Object.keys(e||{}).reduce(((t,n)=>(t[e[n].name]=n,t)),{})}mapNode(e){const t=x(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map((e=>e.startsWith("^")?e.slice(1):e)),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr,outputs:t.outputs};return null!=t.inputs&&(n.inputParams=t.inputs.reduce(((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e)),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce(((t,n)=>{const r=n.type;let s;switch(n.type){case"string":s=Z(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=Z(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":s=ae(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=ae(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":s=Y(e.attr,n.tfName,n.defaultValue||0),void 0===s&&n.tfDeprecatedName&&(s=Y(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":s=se(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=se(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":s=Q(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=Q(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":s=ie(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=ie(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":s=re(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=re(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":s=oe(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=oe(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":s=ee(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=ee(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":s=te(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=te(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":s=J(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=J(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:s,type:r},t}),{})),n}mapFunction(e){const t=e.nodeDef,n=[];let r={};null!=t&&(r=t.reduce(((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e)),{}));const s=[],a=[];e.signature.inputArg.forEach((e=>{const[t]=T(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:X(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,s.push(n),r[t]=n}));Object.keys(r).forEach((e=>{const t=r[e];t.inputNames.forEach(((e,n)=>{const[s,,a]=T(e),o=r[s];if(null!=o.outputs){const e=o.outputs.indexOf(a);if(-1!==e){const r=`${s}:${e}`;t.inputNames[n]=r}}t.inputs.push(o),o.children.push(t)}))}));const o=e.ret;e.signature.outputArg.forEach((e=>{const[t,n]=T(o[e.name]),s=r[t];null!=s&&(s.defaultOutput=n,a.push(s))}));const i=this.mapArgsToSignature(e);return{nodes:r,inputs:s,outputs:a,weights:n,placeholders:[],signature:i}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce(((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e)),{}),outputs:e.signature.outputArg.reduce(((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t)),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function G(e,n){const r=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const n=t().global;if("undefined"!=typeof n.atob)return n.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return n?r:r.toLowerCase()}function Z(e,t,n,r=!1){const s=e[t];return null!=s?G(s.s,r):n}function Q(e,t,n){const r=e[t];return r?r.b:n}function Y(e,t,n){const r=e[t]||{},s=null!=r.i?r.i:null!=r.f?r.f:n;return"number"==typeof s?s:parseInt(s,10)}function X(e){switch("string"==typeof e&&(e=f[e]),e){case f.DT_FLOAT:case f.DT_HALF:return"float32";case f.DT_INT32:case f.DT_INT64:case f.DT_INT8:case f.DT_UINT8:return"int32";case f.DT_BOOL:return"bool";case f.DT_DOUBLE:return"float32";case f.DT_STRING:return"string";default:return null}}function J(e,t,n){const r=e[t];return r&&r.func?r.func.name:n}function ee(e,t,n){const r=e[t];return r&&r.type?X(r.type):n}function te(e,t,n){const r=e[t];return r&&r.list&&r.list.type?r.list.type.map((e=>X(e))):n}function ne(e){if(!e.unknownRank)return null!=e.dim?e.dim.map((e=>"number"==typeof e.size?e.size:parseInt(e.size,10))):[]}function re(e,t,n){const r=e[t];return r&&r.shape?ne(r.shape):n}function se(e,t,n){const r=e[t];return r?((r.list.f&&r.list.f.length?r.list.f:r.list.i)||[]).map((e=>"number"==typeof e?e:parseInt(e,10))):n}function ae(e,t,n,r=!1){const s=e[t];return s&&s.list&&s.list.s?s.list.s.map((e=>G(e,r))):n}function oe(e,t,n){const r=e[t];return r&&r.list&&r.list.shape?r.list.shape.map((e=>ne(e))):n}function ie(e,t,n){const r=e[t];return r&&r.list&&r.list.b?r.list.b:n}class ue{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map((e=>this.getInput(e))),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce(((e,t)=>(e[t]=this.getAttr(t),e)),{}))}getInput(e){return k(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return k(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return Y(this.node.rawAttrs,e,t);if(null!=n.s)return Z(this.node.rawAttrs,e,t);if(null!=n.b)return Q(this.node.rawAttrs,e,t);if(null!=n.shape)return re(this.node.rawAttrs,e,t);if(null!=n.type)return ee(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return se(this.node.rawAttrs,e,t);if(null!=n.list.s)return ae(this.node.rawAttrs,e,t);if(null!=n.list.shape)return oe(this.node.rawAttrs,e,t);if(null!=n.list.b)return ie(this.node.rawAttrs,e,t);if(null!=n.list.type)return te(this.node.rawAttrs,e,t)}return t}}function pe(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function le(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function ce(e,t,n=""){le(fe(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function he(e){le(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function de(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||xe(e)&&!n)for(let r=0;r<e.length;++r)de(e[r],t,n);else t.push(e);return t}function me(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function fe(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function ye(e){return e%1==0}function ge(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function be(e,t){const n=t.length;return le((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),le(e.every((e=>ye(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function xe(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function Ne(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function we(e){return"string"==typeof e||e instanceof String}function ke(e){return Array.isArray(e)?ke(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":"number"==typeof e?"float32":we(e)?"string":function(e){return"boolean"==typeof e}(e)?"bool":"float32"}function Te(e){return!!(e&&e.constructor&&e.call&&e.apply)}function ve(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function _e(e,t,n,r=!1){const s=new Array;if(1===t.length){const a=t[0]*(r?2:1);for(let t=0;t<a;t++)s[t]=n[e+t]}else{const a=t[0],o=t.slice(1),i=o.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<a;t++)s[t]=_e(e+t*i,o,n,r)}return s}function Se(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return _e(0,e,t,n)}function Ee(e,t){const n=$e(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function $e(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function Ie(e){e.forEach((t=>{le(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function De(e){return e&&e.then&&"function"==typeof e.then}class Ae{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=Oe,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(Me().getBool("IS_TEST")||Me().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];Me().getBool("IS_TEST")||Me().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(De(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function Oe(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function Me(){return Fe}let Ce,Fe=null;function Ve(){if(null==Ce){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}Ce=e}return Ce}function ze(e,t){const n=function(){const e=Ve();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}function Re(...e){Me().getBool("IS_TEST")||Me().getBool("PROD")||console.warn(...e)}const Le=ze("kernelRegistry",(()=>new Map)),Be=ze("gradRegistry",(()=>new Map));function Pe(e,t){const n=function(e,t){return`${t}_${e}`}(e,t);return Le.get(n)}function Ke(e){return Be.get(e)}function qe(e){const t=Le.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[a,o]=s,[i]=a.split("_");i===e&&n.push(o)}return n}var Ue=He,We=null;try{We=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function He(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function je(e){return!0===(e&&e.__isLong__)}He.prototype.__isLong__,Object.defineProperty(He.prototype,"__isLong__",{value:!0}),He.isLong=je;var Ge={},Ze={};function Qe(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=Ze[e])?r:(n=Xe(e,(0|e)<0?-1:0,!0),s&&(Ze[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=Ge[e])?r:(n=Xe(e,e<0?-1:0,!1),s&&(Ge[e]=n),n)}function Ye(e,t){if(isNaN(e))return t?it:ot;if(t){if(e<0)return it;if(e>=rt)return ht}else{if(e<=-st)return dt;if(e+1>=st)return ct}return e<0?Ye(-e,t).neg():Xe(e%nt|0,e/nt|0,t)}function Xe(e,t,n){return new He(e,t,n)}He.fromInt=Qe,He.fromNumber=Ye,He.fromBits=Xe;var Je=Math.pow;function et(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return ot;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return et(e.substring(1),t,n).neg();for(var s=Ye(Je(n,8)),a=ot,o=0;o<e.length;o+=8){var i=Math.min(8,e.length-o),u=parseInt(e.substring(o,o+i),n);if(i<8){var p=Ye(Je(n,i));a=a.mul(p).add(Ye(u))}else a=(a=a.mul(s)).add(Ye(u))}return a.unsigned=t,a}function tt(e,t){return"number"==typeof e?Ye(e,t):"string"==typeof e?et(e,t):Xe(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}He.fromString=et,He.fromValue=tt;var nt=4294967296,rt=nt*nt,st=rt/2,at=Qe(1<<24),ot=Qe(0);He.ZERO=ot;var it=Qe(0,!0);He.UZERO=it;var ut=Qe(1);He.ONE=ut;var pt=Qe(1,!0);He.UONE=pt;var lt=Qe(-1);He.NEG_ONE=lt;var ct=Xe(-1,2147483647,!1);He.MAX_VALUE=ct;var ht=Xe(-1,-1,!0);He.MAX_UNSIGNED_VALUE=ht;var dt=Xe(0,-2147483648,!1);He.MIN_VALUE=dt;var mt=He.prototype;mt.toInt=function(){return this.unsigned?this.low>>>0:this.low},mt.toNumber=function(){return this.unsigned?(this.high>>>0)*nt+(this.low>>>0):this.high*nt+(this.low>>>0)},mt.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(dt)){var t=Ye(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=Ye(Je(e,6),this.unsigned),a=this,o="";;){var i=a.div(s),u=(a.sub(i.mul(s)).toInt()>>>0).toString(e);if((a=i).isZero())return u+o;for(;u.length<6;)u="0"+u;o=""+u+o}},mt.getHighBits=function(){return this.high},mt.getHighBitsUnsigned=function(){return this.high>>>0},mt.getLowBits=function(){return this.low},mt.getLowBitsUnsigned=function(){return this.low>>>0},mt.getNumBitsAbs=function(){if(this.isNegative())return this.eq(dt)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},mt.isZero=function(){return 0===this.high&&0===this.low},mt.eqz=mt.isZero,mt.isNegative=function(){return!this.unsigned&&this.high<0},mt.isPositive=function(){return this.unsigned||this.high>=0},mt.isOdd=function(){return 1==(1&this.low)},mt.isEven=function(){return 0==(1&this.low)},mt.equals=function(e){return je(e)||(e=tt(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},mt.eq=mt.equals,mt.notEquals=function(e){return!this.eq(e)},mt.neq=mt.notEquals,mt.ne=mt.notEquals,mt.lessThan=function(e){return this.comp(e)<0},mt.lt=mt.lessThan,mt.lessThanOrEqual=function(e){return this.comp(e)<=0},mt.lte=mt.lessThanOrEqual,mt.le=mt.lessThanOrEqual,mt.greaterThan=function(e){return this.comp(e)>0},mt.gt=mt.greaterThan,mt.greaterThanOrEqual=function(e){return this.comp(e)>=0},mt.gte=mt.greaterThanOrEqual,mt.ge=mt.greaterThanOrEqual,mt.compare=function(e){if(je(e)||(e=tt(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},mt.comp=mt.compare,mt.negate=function(){return!this.unsigned&&this.eq(dt)?dt:this.not().add(ut)},mt.neg=mt.negate,mt.add=function(e){je(e)||(e=tt(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,a=e.high>>>16,o=65535&e.high,i=e.low>>>16,u=0,p=0,l=0,c=0;return l+=(c+=s+(65535&e.low))>>>16,p+=(l+=r+i)>>>16,u+=(p+=n+o)>>>16,u+=t+a,Xe((l&=65535)<<16|(c&=65535),(u&=65535)<<16|(p&=65535),this.unsigned)},mt.subtract=function(e){return je(e)||(e=tt(e)),this.add(e.neg())},mt.sub=mt.subtract,mt.multiply=function(e){if(this.isZero())return ot;if(je(e)||(e=tt(e)),We)return Xe(We.mul(this.low,this.high,e.low,e.high),We.get_high(),this.unsigned);if(e.isZero())return ot;if(this.eq(dt))return e.isOdd()?dt:ot;if(e.eq(dt))return this.isOdd()?dt:ot;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(at)&&e.lt(at))return Ye(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,a=e.high>>>16,o=65535&e.high,i=e.low>>>16,u=65535&e.low,p=0,l=0,c=0,h=0;return c+=(h+=s*u)>>>16,l+=(c+=r*u)>>>16,c&=65535,l+=(c+=s*i)>>>16,p+=(l+=n*u)>>>16,l&=65535,p+=(l+=r*i)>>>16,l&=65535,p+=(l+=s*o)>>>16,p+=t*u+n*i+r*o+s*a,Xe((c&=65535)<<16|(h&=65535),(p&=65535)<<16|(l&=65535),this.unsigned)},mt.mul=mt.multiply,mt.divide=function(e){if(je(e)||(e=tt(e)),e.isZero())throw Error("division by zero");var t,n,r;if(We)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?Xe((this.unsigned?We.div_u:We.div_s)(this.low,this.high,e.low,e.high),We.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?it:ot;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return it;if(e.gt(this.shru(1)))return pt;r=it}else{if(this.eq(dt))return e.eq(ut)||e.eq(lt)?dt:e.eq(dt)?ut:(t=this.shr(1).div(e).shl(1)).eq(ot)?e.isNegative()?ut:lt:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(dt))return this.unsigned?it:ot;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=ot}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),a=s<=48?1:Je(2,s-48),o=Ye(t),i=o.mul(e);i.isNegative()||i.gt(n);)i=(o=Ye(t-=a,this.unsigned)).mul(e);o.isZero()&&(o=ut),r=r.add(o),n=n.sub(i)}return r},mt.div=mt.divide,mt.modulo=function(e){return je(e)||(e=tt(e)),We?Xe((this.unsigned?We.rem_u:We.rem_s)(this.low,this.high,e.low,e.high),We.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},mt.mod=mt.modulo,mt.rem=mt.modulo,mt.not=function(){return Xe(~this.low,~this.high,this.unsigned)},mt.and=function(e){return je(e)||(e=tt(e)),Xe(this.low&e.low,this.high&e.high,this.unsigned)},mt.or=function(e){return je(e)||(e=tt(e)),Xe(this.low|e.low,this.high|e.high,this.unsigned)},mt.xor=function(e){return je(e)||(e=tt(e)),Xe(this.low^e.low,this.high^e.high,this.unsigned)},mt.shiftLeft=function(e){return je(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Xe(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):Xe(0,this.low<<e-32,this.unsigned)},mt.shl=mt.shiftLeft,mt.shiftRight=function(e){return je(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?Xe(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):Xe(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},mt.shr=mt.shiftRight,mt.shiftRightUnsigned=function(e){if(je(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?Xe(this.low>>>e|t<<32-e,t>>>e,this.unsigned):Xe(32===e?t:t>>>e-32,0,this.unsigned)},mt.shru=mt.shiftRightUnsigned,mt.shr_u=mt.shiftRightUnsigned,mt.toSigned=function(){return this.unsigned?Xe(this.low,this.high,!1):this},mt.toUnsigned=function(){return this.unsigned?this:Xe(this.low,this.high,!0)},mt.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},mt.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},mt.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},He.fromBytes=function(e,t,n){return n?He.fromBytesLE(e,t):He.fromBytesBE(e,t)},He.fromBytesLE=function(e,t){return new He(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},He.fromBytesBE=function(e,t){return new He(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const ft=Ue||Object.assign(Object.create(null),Ue,{default:Ue});function yt(e){return ft.fromString(e,!0,16)}function gt(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=de(e)),Me().getBool("DEBUG")&&function(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function bt(){return Me().platform.now()}function xt(e,t="utf-8"){return t=t||"utf-8",Me().platform.decode(e,t)}yt("c3a5c85c97cb3127"),yt("b492b66fbe98f273"),yt("9ae16a3b2f90404f");class Nt{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new kt)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let a;const o=bt();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();a=Promise.resolve({kernelMs:bt()-o})}if(Me().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{wt(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:a.then((e=>e.kernelMs)),extraInfo:a.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:a}=e;n.forEach((e=>{Promise.all([e.data(),r,a]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function wt(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class kt{logKernelProfile(e,t,n,r,s,a){const o="number"==typeof r?ge(`${r}ms`,9):r.error,i=ge(e,25),u=t.rank,p=t.size,l=ge(t.shape.toString(),14);let c="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;c+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${o}\t%c${u}D ${l}\t%c${p}\t%c${c}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function Tt(e,t,n,r){const s=ve(t),a=function(e,t,n,r){const s=me(t),a=r[r.length-1],o=new Array(a).fill(0),i=t.length,u="complex64"===n?Et(e):e;if(i>1)for(let e=0;e<s/a;e++){const t=e*a;for(let e=0;e<a;e++)o[e]=Math.max(o[e],vt(u[t+e],0,n).length)}return o}(e,t,n,s),o=t.length,i=St(e,t,n,s,a),u=["Tensor"];return r&&(u.push(`  dtype: ${n}`),u.push(`  rank: ${o}`),u.push(`  shape: [${t}]`),u.push("  values:")),u.push(i.map((e=>"    "+e)).join("\n")),u.join("\n")}function vt(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:we(e)?`'${e}'`:"bool"===n?_t(e):parseFloat(e.toFixed(7)).toString(),ge(r,t)}function _t(e){return 0===e?"false":"true"}function St(e,t,n,r,s,a=!0){const o="complex64"===n?2:1,i=t[0],u=t.length;if(0===u){if("complex64"===n){return[vt(Et(e)[0],0,n)]}return"bool"===n?[_t(e[0])]:[e[0].toString()]}if(1===u){if(i>20){const t=3*o;let r=Array.from(e.slice(0,t)),a=Array.from(e.slice((i-3)*o,i*o));return"complex64"===n&&(r=Et(r),a=Et(a)),["["+r.map(((e,t)=>vt(e,s[t],n))).join(", ")+", ..., "+a.map(((e,t)=>vt(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?Et(e):Array.from(e)).map(((e,t)=>vt(e,s[t],n))).join(", ")+"]"]}const p=t.slice(1),l=r.slice(1),c=r[0]*o,h=[];if(i>20){for(let t=0;t<3;t++){const r=t*c,a=r+c;h.push(...St(e.slice(r,a),p,n,l,s,!1))}h.push("...");for(let t=i-3;t<i;t++){const r=t*c,a=r+c;h.push(...St(e.slice(r,a),p,n,l,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*c,a=r+c;h.push(...St(e.slice(r,a),p,n,l,s,t===i-1))}const d=2===u?",":"";h[0]="["+h[0]+d;for(let e=1;e<h.length-1;e++)h[e]=" "+h[e]+d;let m=",\n";for(let e=2;e<u;e++)m+="\n";return h[h.length-1]=" "+h[h.length-1]+"]"+(a?"":m),h}function Et(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class $t{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=me(e),null!=n){const e=n.length;le(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}(t,this.size),this.strides=ve(e)}set(e,...t){0===t.length&&(t=[0]),le(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return It().makeTensor(this.values,this.shape,this.dtype)}}let It=null;class Dt{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=me(e),this.strides=ve(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return null.buffer(this.shape,this.dtype,e)}bufferSync(){return null.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return Se(this.shape,e,"complex64"===this.dtype)}arraySync(){return Se(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=It().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>xt(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),It().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=It().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>xt(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await It().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(It().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return null.print(this,e)}clone(){return this.throwIfDisposed(),null.clone(this)}toString(e=!1){return Tt(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),null.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),It().makeVariable(this,e,t,n)}}Object.defineProperty(Dt,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),ze("Tensor",(()=>Dt));class At extends Dt{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!fe(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);It().disposeTensor(this),this.dataId=e.dataId,It().incRef(this,null)}dispose(){It().disposeVariable(this),this.isDisposedInternal=!0}}var Ot,Mt,Ct,Ft,Vt;Object.defineProperty(At,Symbol.hasInstance,{value:e=>e instanceof Dt&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}(Ot||(Ot={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(Mt||(Mt={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Ct||(Ct={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Ft||(Ft={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(Vt||(Vt={}));const zt={float32:Ft,int32:Mt,bool:Ct,complex64:Vt};function Rt(e,t){if(e.dtype===t.dtype)return[e,t];const n=function(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return zt[e][t]}(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Lt(e){const t=[];return Bt(e,t,new Set),t}function Bt(e,t,n){if(null==e)return;if(e instanceof Dt)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),Bt(r,t,n))}}function Pt(e){return null!=e.kernelName}class Kt{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class qt{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Kt}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(Re(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new Nt(this.backendInstance),!0}setupRegisteredKernels(){qe(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){qe(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const n=t.factory();if(!n||n instanceof class{refCount(e){return pe("refCount")}incRef(e){return pe("incRef")}timerAvailable(){return!0}time(e){return pe("time")}read(e){return pe("read")}readSync(e){return pe("readSync")}readToGPU(e,t){return pe("readToGPU")}numDataIds(){return pe("numDataIds")}disposeData(e,t){return pe("disposeData")}write(e,t,n){return pe("write")}move(e,t,n,r,s){return pe("move")}memory(){return pe("memory")}floatPrecision(){return pe("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return pe("dispose")}}||"function"!=typeof n.then)return this.registry[e]=n,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,r=n.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,Re(`Initialization of backend ${e} failed`),Re(n.stack||n.message)),!1)));return this.pendingBackendInit=r,{success:r,asyncInit:!0}}}catch(t){return Re(`Initialization of backend ${e} failed`),Re(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),a=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return qt.nextTensorId++}nextVariableId(){return qt.nextVariableId++}clone(e){const t=Ut.runKernel("Identity",{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Ut.runKernel("Cast",t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=Pe(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],o=r-t-s-a;if(o>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${o} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,a=this.state.numTensors;let o,i;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=Pt(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(Pt(e)){const{kernelName:t,inputs:s,attrs:a}=e;null==this.backendName&&this.backend;const u=Pe(t,this.backendName);le(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),o=()=>{const e=this.backend.numDataIds();i=u.kernelFunc({inputs:s,attrs:a,backend:this.backend});const o=Array.isArray(i)?i:[i];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,o);const p=o.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(r){const e=this.getTensorsForGradient(t,s,p);n=this.saveTensorsForBackwardMode(e)}return p}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};o=()=>{const e=this.backend.numDataIds();i=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(i)?i:[i];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:p,attrs:l}=e,c=Pt(e)?null:e.backwardsFunc;let h;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(h=this.profiler.profileKernel(u,p,(()=>o())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(h),t=h.outputs):t=o()})),r&&this.addTapeNode(u,p,t,c,n,l),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(p).map((e=>null!=p[e]?p[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:h.timeMs,extraInfo:h.extraInfo}),Array.isArray(i)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const r=Ke(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let a;r.saveAllInputs?(le(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),a=Object.keys(t).map((e=>t[e]))):a=e.map((e=>t[e]));const o=n.filter(((e,t)=>s[t]));return a.concat(o)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&we(e[0])&&(s=e.map((e=>function(e,t="utf-8"){return t=t||"utf-8",Me().platform.encode(e,t)}(e))));const a=r.write(s,t,n),o=new Dt(t,n,a,this.nextTensorId());if(this.trackTensor(o,r),"string"===n){const e=this.state.tensorInfo.get(a),t=function(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return o}makeTensorFromDataId(e,t,n,r){const s={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(s,r)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:r,dtype:s}=e,a=new Dt(r,s,n,this.nextTensorId());return this.trackTensor(a,t),a}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new At(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*Ne(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof At||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*Ne(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,a){const o={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=Ke(e);null!=i&&(r=i.gradFunc),null!=r&&(o.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=$e(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,a))),this.state.activeTape.push(o)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=Lt(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(le(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));le(s instanceof Dt,(()=>"The result y returned by f() must be a tensor."));const a=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],o=a.inputs;for(const e in o){const n=o[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){a.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[a.id]=!0;break}if(i)break}}const a={};a[n.id]=!0;const o={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in r)a[r[e].id]=!0,o[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&o[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=Ee(me(e),"float32");return Ut.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const a=t[s],o=[];if(a.outputs.forEach((t=>{const n=e[t.id];null!=n?o.push(n):o.push(null)})),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const i=a.gradient(o);for(const t in a.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const o=a.inputs[t];if(!fe(s.shape,o.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${o.shape}'`);if(null==e[o.id])e[o.id]=s;else{const t=e[o.id];e[o.id]=r(t,s),t.dispose()}}}}(e,a,(e=>this.tidy(e)),Wt);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return le(Te(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;le(t.every((e=>e instanceof Dt)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),le(n.value instanceof Dt,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),le(Te(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),a=Array.isArray(s)?s:[s];le(a.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),le(a.every((e=>e instanceof Dt)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const o={};return a.forEach(((e,t)=>{o[t]=()=>e})),o},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=bt(),n=await this.backend.time(e);return n.wallMs=bt()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Kt;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}qt.nextTensorId=0,qt.nextVariableId=0;const Ut=function(){const e=Ve();if(null==e._tfengine){const t=new Ae(e);e._tfengine=new qt(t)}var t;return t=e._tfengine.ENV,Fe=t,It=()=>e._tfengine,e._tfengine}();function Wt(e,t){const n={a:e,b:t};return Ut.runKernel("Add",n)}function Ht(e,t){let n=e;if(xe(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||xe(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&Me().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&jt(e,r,[]),r}function jt(e,t,n){if(n=n||[],!Array.isArray(e)&&!xe(e))return void le(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));le(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),le(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)jt(e[t],r,n.concat(t))}function Gt(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Zt(e,t,n,r="numeric"){if(e instanceof Dt)return Gt(r,e.dtype,t,n),e;let s=ke(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Gt(r,s,t,n),null==e||!xe(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const a=Ht(e,s);xe(e)||Array.isArray(e)||(e=[e]);const o="string"!==s?gt(e,s):de(e,[],!0);return Ut.makeTensor(o,a,s)}function Qt(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Zt(e,`${t}[${s}]`,n,r)))}function Yt(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const s=(...e)=>{Ut.startScope(n);try{const t=r(...e);return De(t)&&console.error("Cannot return a Promise inside of tidy."),Ut.endScope(t),t}catch(e){throw Ut.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const Xt=Yt({abs_:function(e){const t=Zt(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Ut.runKernel("ComplexAbs",e)}{const e={x:t};return Ut.runKernel("Abs",e)}}});const Jt=Yt({acos_:function(e){const t={x:Zt(e,"x","acos")};return Ut.runKernel("Acos",t)}});const en=Yt({acosh_:function(e){const t={x:Zt(e,"x","acosh")};return Ut.runKernel("Acosh",t)}});const tn=Yt({add_:function(e,t){let n=Zt(e,"a","add"),r=Zt(t,"b","add");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Add",s)}});const nn=Yt({addN_:function(e){le(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),le(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Zt(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!fe(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return Ut.runKernel("AddN",r)}});const rn=Yt({all_:function(e,t=null,n=!1){const r={x:Zt(e,"x","all","bool")},s={axis:t,keepDims:n};return Ut.runKernel("All",r,s)}});const sn=Yt({any_:function(e,t=null,n=!1){const r={x:Zt(e,"x","any","bool")},s={axis:t,keepDims:n};return Ut.runKernel("Any",r,s)}});const an=Yt({argMax_:function(e,t=0){const n={x:Zt(e,"x","argMax")},r={axis:t};return Ut.runKernel("ArgMax",n,r)}});const on=Yt({argMin_:function(e,t=0){const n={x:Zt(e,"x","argMin")},r={axis:t};return Ut.runKernel("ArgMin",n,r)}});const un=Yt({asin_:function(e){const t={x:Zt(e,"x","asin")};return Ut.runKernel("Asin",t)}});const pn=Yt({asinh_:function(e){const t={x:Zt(e,"x","asinh")};return Ut.runKernel("Asinh",t)}});const ln=Yt({atan_:function(e){const t={x:Zt(e,"x","atan")};return Ut.runKernel("Atan",t)}});const cn=Yt({atan2_:function(e,t){let n=Zt(e,"a","atan2"),r=Zt(t,"b","atan2");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Atan2",s)}});const hn=Yt({atanh_:function(e){const t={x:Zt(e,"x","atanh")};return Ut.runKernel("Atanh",t)}});const dn=Yt({cast_:function(e,t){const n=Zt(e,"x","cast");if(!function(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return Ut.runKernel("Cast",r,s)}});function mn(e,t,n,r,s,a,o=!1,i="channelsLast"){let[u,p,l,c]=[-1,-1,-1,-1];if("channelsLast"===i)[u,p,l,c]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[u,c,p,l]=e}const[h,d,,m]=t,[f,y]=fn(n),[g,b]=fn(r),x=yn(h,g),N=yn(d,b),{padInfo:w,outHeight:k,outWidth:T}=function(e,t,n,r,s,a,o,i,u){let p,l,c;if("number"==typeof e){p={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=function(e,t,n,r=1){const s=yn(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}(e,t,n));const a=e[0],o=e[1],i=gn((a-t+2*r)/n+1,s),u=gn((o-t+2*r)/n+1,s);return[i,u]}([t,n],a,r,e,i);l=s[0],c=s[1]}else if("same"===e){l=Math.ceil(t/r),c=Math.ceil(n/s);const e=Math.max(0,(l-1)*r+a-t),i=Math.max(0,(c-1)*s+o-n),u=Math.floor(e/2),h=e-u,d=Math.floor(i/2);p={top:u,bottom:h,left:d,right:i-d,type:"SAME"}}else if("valid"===e)p={top:0,bottom:0,left:0,right:0,type:"VALID"},l=Math.ceil((t-a+1)/r),c=Math.ceil((n-o+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const h="channelsLast"===u?e[1][0]:e[2][0],d="channelsLast"===u?e[1][1]:e[2][1],m="channelsLast"===u?e[2][0]:e[3][0],f="channelsLast"===u?e[2][1]:e[3][1];p={top:h,bottom:d,left:m,right:f,type:0===h&&0===d&&0===m&&0===f?"VALID":"EXPLICIT"},l=gn((t-a+h+d)/r+1,i),c=gn((n-o+m+f)/s+1,i)}}return{padInfo:p,outHeight:l,outWidth:c}}(s,p,l,f,y,x,N,a,i),v=o?m*c:m;let _;return"channelsFirst"===i?_=[u,v,k,T]:"channelsLast"===i&&(_=[u,k,T,v]),{batchSize:u,dataFormat:i,inHeight:p,inWidth:l,inChannels:c,outHeight:k,outWidth:T,outChannels:v,padInfo:w,strideHeight:f,strideWidth:y,filterHeight:h,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:N,dilationHeight:g,dilationWidth:b,inShape:e,outShape:_,filterShape:t}}function fn(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function yn(e,t){return t<=1?e:e+(e-1)*(t-1)}function gn(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function bn(e){const[t,n,r]=fn(e);return 1===t&&1===n&&1===r}function xn(e,t){return bn(e)||bn(t)}function Nn(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)le(ye(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{le(ye(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const wn=Yt({reshape_:function(e,t){const n={x:Zt(e,"x","reshape","string_or_numeric")},r={shape:t};return Ut.runKernel("Reshape",n,r)}});const kn=Yt({avgPool_:function(e,t,n,r,s){const a=Zt(e,"x","avgPool","float32");le(xn(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let o=a,i=!1;3===a.rank&&(i=!0,o=wn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),le(4===o.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${o.rank}.`)),Nn("avgPool",r,s);const u={x:o},p={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let l=Ut.runKernel("AvgPool",u,p);return l=dn(l,a.dtype),i?wn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const Tn=Yt({avgPool3d_:function(e,t,n,r,s,a="NDHWC"){const o=Zt(e,"x","avgPool3d","float32");let i=o,u=!1;4===o.rank&&(u=!0,i=wn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),le(5===i.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${i.rank}.`)),le("NDHWC"===a,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),Nn("avgPool3d",r,s);const p={x:i},l={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:a};let c=Ut.runKernel("AvgPool3D",p,l);return c=dn(c,i.dtype),u?wn(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const vn=Yt({clone_:function(e){const t={x:Zt(e,"x","clone","string_or_numeric")};return Ut.runKernel("Identity",t)}});const _n=Yt({concat_:function(e,t=0){le(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=Qt(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return vn(n[0]);const r=n,s={axis:t};return Ut.runKernel("Concat",r,s)}});const Sn=Yt({matMul_:function(e,t,n=!1,r=!1){let s=Zt(e,"a","matMul"),a=Zt(t,"b","matMul");[s,a]=Rt(s,a);const o={a:s,b:a},i={transposeA:n,transposeB:r};return Ut.runKernel("BatchMatMul",o,i)}});const En=Yt({mul_:function(e,t){let n=Zt(e,"a","mul"),r=Zt(t,"b","mul");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Multiply",s)}});const $n=Yt({sigmoid_:function(e){const t={x:Zt(e,"x","sigmoid","float32")};return Ut.runKernel("Sigmoid",t)}});const In=Yt({slice_:function(e,t,n){const r=Zt(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},a={begin:t,size:n};return Ut.runKernel("Slice",s,a)}});const Dn=Yt({tanh_:function(e){const t={x:Zt(e,"x","tanh","float32")};return Ut.runKernel("Tanh",t)}});const An=Yt({basicLSTMCell_:function(e,t,n,r,s,a){const o=Zt(e,"forgetBias","basicLSTMCell"),i=Zt(t,"lstmKernel","basicLSTMCell"),u=Zt(n,"lstmBias","basicLSTMCell"),p=Zt(r,"data","basicLSTMCell"),l=Zt(s,"c","basicLSTMCell"),c=Zt(a,"h","basicLSTMCell"),h=_n([p,c],1),d=Sn(h,i),m=tn(d,u),f=m.shape[0],y=m.shape[1]/4,g=[f,y],b=In(m,[0,0],g),x=In(m,[0,y],g),N=In(m,[0,2*y],g),w=In(m,[0,3*y],g),k=tn(En($n(b),Dn(x)),En(l,$n(tn(o,N))));return[k,En(Dn(k),$n(w))]}});const On=Yt({batchToSpaceND_:function(e,t,n){const r=Zt(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));le(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),le(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),le(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const a={x:r},o={blockShape:t,crops:n};return Ut.runKernel("BatchToSpaceND",a,o)}});const Mn=Yt({batchNorm_:function(e,t,n,r,s,a){null==a&&(a=.001);const o=Zt(e,"x","batchNorm"),i=Zt(t,"mean","batchNorm"),u=Zt(n,"variance","batchNorm");let p,l;null!=s&&(p=Zt(s,"scale","batchNorm")),null!=r&&(l=Zt(r,"offset","batchNorm")),le(i.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),le(null==l||i.rank===l.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),le(null==p||i.rank===p.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(e){let t;return t=0===e.rank||1===e.rank?wn(e,[1,1,1,e.size]):2===e.rank?wn(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?wn(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(o),h={x:c,scale:p,offset:l,mean:i,variance:u},d={varianceEpsilon:a},m=Ut.runKernel("FusedBatchNorm",h,d);return wn(m,o.shape)}});const Cn=Yt({batchNorm2d_:function(e,t,n,r,s,a){const o=Zt(e,"x","batchNorm"),i=Zt(t,"mean","batchNorm"),u=Zt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Zt(s,"scale","batchNorm")),null!=r&&(l=Zt(r,"offset","batchNorm")),le(2===o.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${o.rank}.`)),le(2===i.rank||1===i.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${i.rank}.`)),le(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=p&&le(2===p.rank||1===p.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${p.rank}.`)),null!=l&&le(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${l.rank}.`)),Mn(o,i,u,l,p,a)}});const Fn=Yt({batchNorm3d_:function(e,t,n,r,s,a){const o=Zt(e,"x","batchNorm"),i=Zt(t,"mean","batchNorm"),u=Zt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Zt(s,"scale","batchNorm")),null!=r&&(l=Zt(r,"offset","batchNorm")),le(3===o.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${o.rank}.`)),le(3===i.rank||1===i.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${i.rank}.`)),le(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=p&&le(3===p.rank||1===p.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${p.rank}.`)),null!=l&&le(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${l.rank}.`)),Mn(o,i,u,l,p,a)}});const Vn=Yt({batchNorm4d_:function(e,t,n,r,s,a){const o=Zt(e,"x","batchNorm"),i=Zt(t,"mean","batchNorm"),u=Zt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Zt(s,"scale","batchNorm")),null!=r&&(l=Zt(r,"offset","batchNorm")),le(4===o.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${o.rank}.`)),le(4===i.rank||1===i.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${i.rank}.`)),le(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=p&&le(4===p.rank||1===p.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${p.rank}.`)),null!=l&&le(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${l.rank}.`)),Mn(o,i,u,l,p,a)}});const zn=Yt({bincount_:function(e,t,n){const r=Zt(e,"x","bincount"),s=Zt(t,"weights","bincount");le("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),le(n>=0,(()=>`size must be non-negative, but got ${n}.`)),le(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const a={x:r,weights:s},o={size:n};return Ut.runKernel("Bincount",a,o)}});const Rn=Yt({broadcastArgs_:function(e,t){const n=Zt(e,"s0","broadcastArgs","int32"),r=Zt(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return Ut.runKernel("BroadcastArgs",s)}});const Ln=Yt({broadcastTo_:function(e,t){let n=Zt(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=wn(n,e)}const s=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===a.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return vn(n);const o={x:n},i={reps:a};return Ut.runKernel("Tile",o,i)}});function Bn(e,t="float32",n){return t=t||"float32",Ie(e),new $t(e,t,n)}const Pn=Yt({ceil_:function(e){const t={x:Zt(e,"x","ceil","float32")};return Ut.runKernel("Ceil",t)}});const Kn=Yt({clipByValue_:function(e,t,n){const r=Zt(e,"x","clipByValue");le(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},a={clipValueMin:t,clipValueMax:n};return Ut.runKernel("ClipByValue",s,a)}});const qn=Yt({complex_:function(e,t){const n=Zt(e,"real","complex"),r=Zt(t,"imag","complex");ce(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return Ut.runKernel("Complex",s)}});const Un=Yt({concat1d_:function(e){return _n(e,0)}});const Wn=Yt({concat2d_:function(e,t){return _n(e,t)}});const Hn=Yt({concat3d_:function(e,t){return _n(e,t)}});const jn=Yt({concat4d_:function(e,t){return _n(e,t)}});const Gn=Yt({conv2d_:function(e,t,n,r,s="NHWC",a=[1,1],o){const i=Zt(e,"x","conv2d","float32"),u=Zt(t,"filter","conv2d","float32");let p=i,l=!1;3===i.rank&&(l=!0,p=wn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),le(4===p.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${p.rank}.`)),le(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),Nn("conv2d",r,o);const c="NHWC"===s?p.shape[3]:p.shape[1];le(c===u.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${u.shape[2]}.`)),le(xn(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const h={x:p,filter:u},d={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o},m=Ut.runKernel("Conv2D",h,d);return l?wn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Zn=Yt({conv1d_:function(e,t,n,r,s="NWC",a=1,o){const i=Zt(e,"x","conv1d"),u=Zt(t,"filter","conv1d");let p=i,l=!1;2===i.rank&&(l=!0,p=wn(i,[1,i.shape[0],i.shape[1]])),le(3===p.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${p.rank}.`)),le(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),Nn("conv1d",r,o),le(p.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${p.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),le(xn(n,a),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`)),le("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const c=wn(u,[1,u.shape[0],u.shape[1],u.shape[2]]),h=wn(p,[p.shape[0],1,p.shape[1],p.shape[2]]),d=Gn(h,c,[1,n],r,"NHWC",[1,a],o);return wn(d,l?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}});const Qn=Yt({conv2DBackpropInput_:function(e,t,n,r,s,a="NHWC",o){le(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let i=e,u=t,p=!1;3===t.rank&&(p=!0,u=wn(t,[1,t.shape[0],t.shape[1],t.shape[2]]),i=[1,e[0],e[1],e[2]]),le(4===i.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${i.length}.`)),le(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),le(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const l="NHWC"===a?i[3]:i[1],c="NHWC"===a?u.shape[3]:u.shape[1];le(l===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[2]}.`)),le(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),Nn("conv2dDerInput",s,o);const h={dy:u,filter:n},d={strides:r,pad:s,dataFormat:a,dimRoundingMode:o,inputShape:i},m=Ut.runKernel("Conv2DBackpropInput",h,d);return p?wn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Yn=Yt({conv2dTranspose_:function(e,t,n,r,s,a){const o=Zt(e,"x","conv2dTranspose"),i=Zt(t,"filter","conv2dTranspose");return Qn(n,o,i,r,s,"NHWC",a)}});const Xn=Yt({conv3d_:function(e,t,n,r,s="NDHWC",a=[1,1,1]){const o=Zt(e,"x","conv3d"),i=Zt(t,"filter","conv3d");let u=o,p=!1;4===o.rank&&(p=!0,u=wn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),le(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),le(5===i.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${i.rank}.`)),le(u.shape[4]===i.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${i.shape[3]}.`)),le(xn(n,a),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),le("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const l={x:u,filter:i},c={strides:n,pad:r,dataFormat:s,dilations:a},h=Ut.runKernel("Conv3D",l,c);return p?wn(h,[h.shape[1],h.shape[2],h.shape[3],h.shape[4]]):h}});const Jn=Yt({conv3DBackpropInput_:function(e,t,n,r,s){le(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let a=e,o=t,i=!1;4===t.rank&&(i=!0,o=wn(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const u=a[4],p=o.shape[4];le(5===a.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`)),le(5===o.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${o.rank}`)),le(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),le(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),le(p===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[4]}.`));const l={dy:o,filter:n},c={pad:s,strides:r,inputShape:a},h=Ut.runKernel("Conv3DBackpropInputV2",l,c);return i?wn(h,[h.shape[1],h.shape[2],h.shape[3],h.shape[4]]):h}});const er=Yt({conv3dTranspose_:function(e,t,n,r,s){const a=Zt(e,"x","conv3dTranspose"),o=Zt(t,"filter","conv3dTranspose");return Jn(n,a,o,r,s)}});const tr=Yt({cos_:function(e){const t={x:Zt(e,"x","cos","float32")};return Ut.runKernel("Cos",t)}});const nr=Yt({cosh_:function(e){const t={x:Zt(e,"x","cosh","float32")};return Ut.runKernel("Cosh",t)}});const rr=Yt({cumprod_:function(e,t=0,n=!1,r=!1){const s={x:Zt(e,"x","cumprod")},a={axis:t,exclusive:n,reverse:r};return Ut.runKernel("Cumprod",s,a)}});const sr=Yt({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Zt(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:r};return Ut.runKernel("Cumsum",s,a)}});const ar=Yt({denseBincount_:function(e,t,n,r=!1){const s=Zt(e,"x","denseBincount"),a=Zt(t,"weights","denseBincount");le("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),le(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),le(n>=0,(()=>`size must be non-negative, but got ${n}.`)),le(a.size===s.size||0===a.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${a.shape}.`));const o={x:s,weights:a},i={size:n,binaryOutput:r};return Ut.runKernel("DenseBincount",o,i)}});const or=Yt({depthToSpace_:function(e,t,n="NHWC"){const r=Zt(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],a="NHWC"===n?r.shape[2]:r.shape[3],o="NHWC"===n?r.shape[3]:r.shape[1];le(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),le(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),le(a*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),le(o%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${o} for depthToSpace with input shape ${r.shape}`));const i={x:r},u={blockSize:t,dataFormat:n};return Ut.runKernel("DepthToSpace",i,u)}});const ir=Yt({depthwiseConv2d_:function(e,t,n,r,s="NHWC",a=[1,1],o){const i=Zt(e,"x","depthwiseConv2d","float32"),u=Zt(t,"filter","depthwiseConv2d","float32");let p=i,l=!1;3===i.rank&&(l=!0,p=wn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),le(4===p.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${p.rank}.`)),le(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`));const c="NHWC"===s?p.shape[3]:p.shape[1];le(c===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${u.shape[2]}.`)),Nn("depthwiseConv2d",r,o);const h={x:p,filter:u},d={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o},m=Ut.runKernel("DepthwiseConv2dNative",h,d);return l?wn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const ur=Yt({diag_:function(e){const t={x:Zt(e,"x","diag")};return Ut.runKernel("Diag",t)}});const pr=Yt({dilation2d_:function(e,t,n,r,s=[1,1],a="NHWC"){const o=Zt(e,"x","dilation2d"),i=Zt(t,"filter","dilation2d");le(3===o.rank||4===o.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${o.rank}.`)),le(3===i.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${i.rank}.`)),le("NHWC"===a,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`));let u=o,p=!1;3===o.rank&&(u=wn(o,[1,o.shape[0],o.shape[1],o.shape[2]]),p=!0);const l={x:u,filter:i},c={strides:n,pad:r,dilations:s},h=Ut.runKernel("Dilation2D",l,c);return p?wn(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const lr=Yt({floorDiv_:function(e,t){let n=Zt(e,"a","floorDiv"),r=Zt(t,"b","floorDiv");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("FloorDiv",s)}});const cr=Yt({div_:function(e,t){let n=Zt(e,"a","div"),r=Zt(t,"b","div");if([n,r]=Rt(n,r),"int32"===n.dtype&&"int32"===r.dtype)return lr(n,r);const s={a:n,b:r};return Ut.runKernel("RealDiv",s,{})}});function hr(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let a=t[t.length-s-1];if(null==a&&(a=1),1===r)n.unshift(a);else if(1===a)n.unshift(r);else{if(r!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}const dr=Yt({equal_:function(e,t){let n=Zt(e,"a","equal","string_or_numeric"),r=Zt(t,"b","equal","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("Equal",s)}});const mr=Yt({where_:function(e,t,n){const r=Zt(t,"a","where"),s=Zt(n,"b","where"),a=Zt(e,"condition","where","bool"),o=hr(hr(a.shape,r.shape),s.shape),i={condition:Ln(a,o),t:Ln(r,o),e:Ln(s,o)};return Ut.runKernel("Select",i)}});const fr=Yt({zerosLike_:function(e){const t={x:Zt(e,"x","zerosLike")};return Ut.runKernel("ZerosLike",t)}});const yr=Yt({divNoNan_:function(e,t){let n=Zt(e,"a","div"),r=Zt(t,"b","div");[n,r]=Rt(n,r);const s=cr(n,r),a=fr(s),o=dr(r,a);return mr(o,a,s)}});const gr=Yt({dot_:function(e,t){const n=Zt(e,"t1","dot"),r=Zt(t,"t2","dot");le(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],a=1===r.rank?r.size:r.shape[0];if(le(s===a,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${a}.`)),1===n.rank&&1===r.rank){const e=wn(n,[1,-1]),t=wn(r,[-1,1]),s=Sn(e,t);return wn(s,[])}if(1===n.rank&&2===r.rank){const e=wn(n,[1,-1]),t=wn(r,[r.shape[0],r.shape[1]]),s=Sn(e,t);return wn(s,[s.size])}if(2===n.rank&&1===r.rank){const e=wn(r,[-1,1]),t=Sn(n,e);return wn(t,[t.size])}{const e=wn(r,[r.shape[0],r.shape[1]]);return Sn(n,e)}}});const br=Yt({einsum_:function(e,...t){const n=t.map(((e,t)=>Zt(e,`tensors${t}`,"einsum"))),r={equation:e};return Ut.runKernel("Einsum",n,r)}});const xr=Yt({elu_:function(e){const t={x:Zt(e,"x","elu","float32")};return Ut.runKernel("Elu",t)}});const Nr=Yt({erf_:function(e){let t=Zt(e,"x","erf");le("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=dn(t,"float32"));const n={x:t};return Ut.runKernel("Erf",n)}});function wr(e,t){return function(e,t,n){const r=e.length+t.length,s=[];let a=0,o=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[a++]):s.push(t[o++]);return s}(e,t.map((e=>1)),t)}const kr=Yt({max_:function(e,t=null,n=!1){const r={x:Zt(e,"x","max")},s={reductionIndices:t,keepDims:n};return Ut.runKernel("Max",r,s)}});const Tr=Yt({min_:function(e,t=null,n=!1){const r={x:Zt(e,"x","min")},s={axis:t,keepDims:n};return Ut.runKernel("Min",r,s)}});const vr=Yt({pow_:function(e,t){let n=Zt(e,"base","pow"),r=Zt(t,"exp","pow");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Pow",s)}});function _r(e,t,n,r){if(null==r&&(r=ke(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!xe(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){Ie(t);const e=me(t),r=me(n);le(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==me(t.slice(e));le(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return xe(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?gt(e,r):de(e,[],!0),Ut.makeTensor(e,t,r)}function Sr(e,t){if((xe(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&xe(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return _r(e,[],[],t)}const Er=Yt({sqrt_:function(e){const t={x:Zt(e,"x","sqrt","float32")};return Ut.runKernel("Sqrt",t)}});const $r=Yt({square_:function(e){const t=Zt(e,"x","square");return Ut.runKernel("Square",{x:t},{})}});const Ir=Yt({sum_:function(e,t=null,n=!1){let r=Zt(e,"x","sum");"bool"===r.dtype&&(r=dn(r,"int32"));const s={x:r},a={axis:t,keepDims:n};return Ut.runKernel("Sum",s,a)}});function Dr(e,t,n=null){if(0===e.rank)return Xt(e);if(1!==e.rank&&null===n)return Dr(wn(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Ir(Xt(e),n);if(t===1/0)return kr(Xt(e),n);if(t===-1/0)return Tr(Xt(e),n);if("euclidean"===t||2===t)return Er(Ir(vr(Xt(e),Sr(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return kr(Ir(Xt(e),n[0]),n[1]-1);if(t===1/0)return kr(Ir(Xt(e),n[1]),n[0]);if(t===-1/0)return Tr(Ir(Xt(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return Er(Ir($r(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const Ar=Yt({norm_:function(e,t="euclidean",n=null,r=!1){const s=Dr(e=Zt(e,"x","norm"),t,n);let a=s.shape;if(r){const t=be(n,e.shape);a=wr(s.shape,t)}return wn(s,a)}});const Or=Yt({euclideanNorm_:function(e,t=null,n=!1){return Ar(e,"euclidean",t,n)}});const Mr=Yt({exp_:function(e){const t={x:Zt(e,"x","exp")};return Ut.runKernel("Exp",t)}});const Cr=Yt({expandDims_:function(e,t=0){const n=Zt(e,"x","expandDims","string_or_numeric");le(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return Ut.runKernel("ExpandDims",r,s)}});const Fr=Yt({expm1_:function(e){const t={x:Zt(e,"x","expm1")};return Ut.runKernel("Expm1",t)}});const Vr=Yt({tile_:function(e,t){const n=Zt(e,"x","tile","string_or_numeric");le(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return Ut.runKernel("Tile",r,s)}});const zr=Yt({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=Bn([e,t],r),a=e<=t?e:t;for(let e=0;e<a;++e)s.set(1,e,e);const o=wn(s.toTensor(),[e,t]);if(null==n)return o;if(1===n.length)return Vr(Cr(o,0),[n[0],1,1]);if(2===n.length)return Vr(Cr(Cr(o,0),0),[n[0],n[1],1,1]);if(3===n.length)return Vr(Cr(Cr(Cr(o,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Rr(e,t,n){const r={shape:e,value:t,dtype:n};return Ut.runKernel("Fill",{},r)}const Lr=Yt({floor_:function(e){const t={x:Zt(e,"x","floor","float32")};return Ut.runKernel("Floor",t)}});const Br=Yt({gather_:function(e,t,n=0,r=0){const s={x:Zt(e,"x","gather"),indices:Zt(t,"indices","gather","int32")},a={axis:n,batchDims:r};return Ut.runKernel("GatherV2",s,a)}});const Pr=Yt({greater_:function(e,t){let n=Zt(e,"a","greater","string_or_numeric"),r=Zt(t,"b","greater","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("Greater",s)}});const Kr=Yt({greaterEqual_:function(e,t){let n=Zt(e,"a","greaterEqual","string_or_numeric"),r=Zt(t,"b","greaterEqual","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("GreaterEqual",s)}});const qr=Yt({imag_:function(e){const t={input:Zt(e,"input","imag")};return Ut.runKernel("Imag",t)}});const Ur=Yt({isFinite_:function(e){const t={x:Zt(e,"x","isFinite")};return Ut.runKernel("IsFinite",t)}});const Wr=Yt({isInf_:function(e){const t={x:Zt(e,"x","isInf")};return Ut.runKernel("IsInf",t)}});const Hr=Yt({isNaN_:function(e){const t={x:Zt(e,"x","isNaN")};return Ut.runKernel("IsNan",t)}});const jr=Yt({leakyRelu_:function(e,t=.2){const n={x:Zt(e,"x","leakyRelu")},r={alpha:t};return Ut.runKernel("LeakyRelu",n,r)}});const Gr=Yt({less_:function(e,t){let n=Zt(e,"a","less","string_or_numeric"),r=Zt(t,"b","less","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("Less",s)}});const Zr=Yt({lessEqual_:function(e,t){let n=Zt(e,"a","lessEqual","string_or_numeric"),r=Zt(t,"b","lessEqual","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("LessEqual",s)}});const Qr=Yt({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const a=Zt(e,"x","localResponseNormalization");le(4===a.rank||3===a.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`)),le(ye(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let o=a,i=!1;3===a.rank&&(i=!0,o=wn(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:o},p={depthRadius:t,bias:n,alpha:r,beta:s},l=Ut.runKernel("LRN",u,p);return i?wn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const Yr=Yt({log_:function(e){const t={x:Zt(e,"x","log","float32")};return Ut.runKernel("Log",t)}});const Xr=Yt({log1p_:function(e){const t={x:Zt(e,"x","log1p")};return Ut.runKernel("Log1p",t)}});function Jr(e){return Ut.customGrad(e)}const es=Yt({neg_:function(e){const t={x:Zt(e,"x","neg")};return Ut.runKernel("Neg",t)}});const ts=Yt({softplus_:function(e){const t={x:Zt(e,"x","softplus")};return Ut.runKernel("Softplus",t)}});const ns=Yt({logSigmoid_:function(e){const t=Zt(e,"x","logSigmoid"),n=Jr((e=>({value:es(ts(es(e))),gradFunc:t=>En(t,$n(es(e)))})));return n(t)}});const rs=Yt({sub_:function(e,t){let n=Zt(e,"a","sub"),r=Zt(t,"b","sub");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Sub",s)}});const ss=Yt({logSoftmax_:function(e,t=-1){const n=Zt(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const r=Jr(((e,n)=>{const r=kr(e,t,!0),s=rs(e,r),a=rs(dn(s,"float32"),Yr(Ir(Mr(s),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[r]=n,s=Mr(r);return rs(e,En(Ir(e,t,!0),s))}}}));return r(n)}});const as=Yt({logSumExp_:function(e,t=null,n=!1){const r=Zt(e,"x","logSumExp"),s=be(t,r.shape),a=kr(r,s,!0),o=rs(r,a),i=Mr(o),u=Ir(i,s),p=Yr(u),l=tn(wn(a,p.shape),p);if(n){const e=wr(l.shape,s);return wn(l,e)}return l}});const os=Yt({logicalAnd_:function(e,t){const n=Zt(e,"a","logicalAnd","bool"),r=Zt(t,"b","logicalAnd","bool");hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("LogicalAnd",s)}});const is=Yt({logicalNot_:function(e){const t={x:Zt(e,"x","logicalNot","bool")};return Ut.runKernel("LogicalNot",t)}});const us=Yt({logicalOr_:function(e,t){const n=Zt(e,"a","logicalOr","bool"),r=Zt(t,"b","logicalOr","bool");hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("LogicalOr",s)}});const ps=Yt({logicalXor_:function(e,t){const n=Zt(e,"a","logicalXor","bool"),r=Zt(t,"b","logicalXor","bool");return hr(n.shape,r.shape),os(us(e,t),is(os(e,t)))}});const ls=Yt({searchSorted_:function(e,t,n="left"){const r=Zt(e,"sortedSequence","searchSorted"),s=Zt(t,"values","searchSorted"),a=r.shape[r.shape.length-1],o=s.shape[s.shape.length-1],i=wn(r,[-1,a]),u=wn(s,[-1,o]);if(i.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(i.shape[0]!==u.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(me(u.shape)>=2147483648)throw new Error("values tensor size must less than 2147483648");if(i.shape[1]>=2147483648)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${i.shape[1]}`);const p={sortedSequence:i,values:u},l={side:n};return Ut.runKernel("SearchSorted",p,l)}});const cs=Yt({maxPool_:function(e,t,n,r,s){const a=Zt(e,"x","maxPool");let o=a,i=!1;3===a.rank&&(i=!0,o=wn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),le(4===o.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${o.rank}.`)),le(xn(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),Nn("maxPool",r,s);const u={x:o},p={filterSize:t,strides:n,pad:r,dimRoundingMode:s},l=Ut.runKernel("MaxPool",u,p);return i?wn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const hs=Yt({maxPool3d_:function(e,t=[1,1,1],n,r,s,a="NDHWC"){const o=Zt(e,"x","maxPool3d");let i=o,u=!1;4===o.rank&&(u=!0,i=wn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),le(5===i.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${i.rank}.`)),le("NDHWC"===a,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),Nn("maxPool3d",r,s);const p={x:i},l={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:a},c=Ut.runKernel("MaxPool3D",p,l);return u?wn(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const ds=Yt({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const a={x:Zt(e,"x","maxPoolWithArgmax")},o={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=Ut.runKernel("MaxPoolWithArgmax",a,o);return{result:i[0],indexes:i[1]}}});const ms=Yt({maximum_:function(e,t){let n=Zt(e,"a","maximum"),r=Zt(t,"b","maximum");[n,r]=Rt(n,r),"bool"===n.dtype&&(n=dn(n,"int32"),r=dn(r,"int32")),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("Maximum",s)}});const fs=Yt({mean_:function(e,t=null,n=!1){const r={x:Zt(e,"x","mean")},s={axis:t,keepDims:n};return Ut.runKernel("Mean",r,s)}});function ys(e,t="float32"){if("complex64"===t){const t=ys(e,"float32"),n=ys(e,"float32");return qn(t,n)}const n=$e(me(e),t);return Ut.makeTensor(n,e,t)}function gs(e,t="float32"){if("complex64"===t){const t=gs(e,"float32"),n=ys(e,"float32");return qn(t,n)}const n=Ee(me(e),t);return Ut.makeTensor(n,e,t)}const bs=Yt({minimum_:function(e,t){let n=Zt(e,"a","minimum"),r=Zt(t,"b","minimum");[n,r]=Rt(n,r),"bool"===n.dtype&&(n=dn(n,"int32"),r=dn(r,"int32")),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("Minimum",s)}});const xs=Yt({mirrorPad_:function(e,t,n){le("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Zt(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");le(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)le(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),le(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const a={paddings:t,mode:n},o={x:r};return Ut.runKernel("MirrorPad",o,a)}});const Ns=Yt({mod_:function(e,t){let n=Zt(e,"a","mod"),r=Zt(t,"b","mod");[n,r]=Rt(n,r);const s={a:n,b:r};return Ut.runKernel("Mod",s)}});const ws=Yt({moments_:function(e,t=null,n=!1){const r=be(t,(e=Zt(e,"x","moments")).shape),s=fs(e,r,n);let a=s.shape;n||(a=wr(s.shape,r));const o=$r(rs(dn(e,"float32"),wn(s,a)));return{mean:s,variance:fs(o,r,n)}}});const ks=Yt({multiRNNCell_:function(e,t,n,r){const s=Zt(t,"data","multiRNNCell"),a=Qt(n,"c","multiRNNCell"),o=Qt(r,"h","multiRNNCell");let i=s;const u=[];for(let t=0;t<e.length;t++){const n=e[t](i,a[t],o[t]);u.push(n[0]),u.push(n[1]),i=n[1]}const p=[],l=[];for(let e=0;e<u.length;e+=2)p.push(u[e]),l.push(u[e+1]);return[p,l]}});const Ts=Yt({multinomial_:function(e,t,n,r=!1){const s=Zt(e,"logits","multinomial"),a=s.size,o=s.rank;if(a<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);if(o>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${o}`);n=n||Math.random();const i={logits:1===o?wn(s,[1,-1]):s},u={numSamples:t,seed:n,normalized:r},p=Ut.runKernel("Multinomial",i,u);return 1===o?wn(p,[p.size]):p}});const vs=Yt({notEqual_:function(e,t){let n=Zt(e,"a","notEqual","string_or_numeric"),r=Zt(t,"b","notEqual","string_or_numeric");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("NotEqual",s)}});const _s=Yt({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Zt(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:r};return Ut.runKernel("OneHot",s,a)}});const Ss=Yt({onesLike_:function(e){const t={x:Zt(e,"x","onesLike")};return Ut.runKernel("OnesLike",t)}});const Es=Yt({outerProduct_:function(e,t){const n=Zt(e,"v1","outerProduct"),r=Zt(t,"v2","outerProduct");le(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=wn(n,[-1,1]),a=wn(r,[1,-1]);return Sn(s,a)}});const $s=Yt({pad_:function(e,t,n=0){const r=Zt(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},a={x:r};return Ut.runKernel("PadV2",a,s)}});const Is=Yt({pad1d_:function(e,t,n=0){return le(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),$s(e,[t],n)}});const Ds=Yt({pad2d_:function(e,t,n=0){return le(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),$s(e,t,n)}});const As=Yt({pad3d_:function(e,t,n=0){return le(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),$s(e,t,n)}});const Os=Yt({pad4d_:function(e,t,n=0){return le(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),$s(e,t,n)}});const Ms=Yt({spaceToBatchND_:function(e,t,n){const r=Zt(e,"x","spaceToBatchND");le(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),le(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),le(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},a={blockShape:t,paddings:n};return Ut.runKernel("SpaceToBatchND",s,a)}});const Cs=Yt({pool_:function(e,t,n,r,s,a,o){null==s&&(s=[1,1]),null==a&&(a=1),0===r&&(r="valid");const i=Zt(e,"x","maxPool");let u=i,p=!1;3===i.rank&&(p=!0,u=wn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),le(xn(a,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${s}'`));const l=function(e,t,n,r,s,a,o="channelsLast"){const[i,u]=fn(t);let p;if("channelsLast"===o)p=[i,u,e[3],e[3]];else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);p=[i,u,e[1],e[1]]}return mn(e,p,n,r,s,a,!1,o)}(u.shape,t,a,s,r),c=[l.dilationHeight,l.dilationWidth];let h;h="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([l.filterHeight,l.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[m,f]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),a=e.concat(r,s),o=t.map(((e,t)=>(e-a[t]%e)%e)),i=s.map(((e,t)=>e+o[t])),u=t.map(((e,t)=>[r[t],i[t]])),p=t.map(((e,t)=>[0,o[t]]));return[u,p]}([l.inHeight,l.inWidth],c,h),y=d?r:"valid",g=d?u:Ms(u,c,m),b=("avg"===n?()=>kn(g,t,a,y,o):()=>cs(g,t,a,y,o))(),x=d?b:On(b,c,f);return p?wn(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const Fs=Yt({prelu_:function(e,t){const n={x:Zt(e,"x","prelu"),alpha:Zt(t,"alpha","prelu")};return Ut.runKernel("Prelu",n)}});const Vs=Yt({prod_:function(e,t=null,n=!1){let r=Zt(e,"x","prod");"bool"===r.dtype&&(r=dn(r,"int32"));const s={x:r},a={axis:t,keepDims:n};return Ut.runKernel("Prod",s,a)}});const zs=Yt({rand_:function(e,t,n){const r=me(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return Ut.makeTensor(s,e,n)}});var Rs="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function Ls(e){if(e.__esModule)return e;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(e).forEach((function(n){var r=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,r.get?r:{enumerable:!0,get:function(){return e[n]}})})),t}function Bs(e){var t={exports:{}};return e(t,t.exports),t.exports}var Ps=Bs((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new r(e),a=t&&t.state,o=n.next;return o.int32=function(){return 4294967296*n.next()|0},o.double=function(){return o()+11102230246251565e-32*(2097152*o()|0)},o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),Ks=Bs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),qs=Bs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),Us=Bs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&(a.x&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),Ws=Bs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,a=t.i;return t.w=r=r+1640531527|0,n=s[a+34&127],e=s[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[a]=n^e,t.i=a,n+(r^r>>>16)|0},function(e,t){var n,r,s,a,o,i=[],u=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,u=Math.max(u,t.length)),s=0,a=-32;a<u;++a)t&&(r^=t.charCodeAt((a+32)%t.length)),0===a&&(o=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,a>=0&&(o=o+1640531527|0,s=0==(n=i[127&a]^=r+o)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,a=512;a>0;--a)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=o,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&(a.X&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),Hs=Bs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),js=Ls({__proto__:null,default:{}}),Gs=Bs((function(e){!function(t,n,r){var s,a=256,o=r.pow(a,6),i=r.pow(2,52),u=2*i,p=255;function l(e,p,l){var y=[],g=m(d((p=1==p?{entropy:!0}:p||{}).entropy?[e,f(n)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(a):(e=new Uint8Array(a),(t.crypto||t.msCrypto).getRandomValues(e)),f(e)}catch(e){var r=t.navigator,o=r&&r.plugins;return[+new Date,t,o,t.screen,f(n)]}}():e,3),y),b=new c(y),x=function(){for(var e=b.g(6),t=o,n=0;e<i;)e=(e+n)*a,t*=a,n=b.g(1);for(;e>=u;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|b.g(4)},x.quick=function(){return b.g(4)/4294967296},x.double=x,m(f(b.S),n),(p.pass||l||function(e,t,n,s){return s&&(s.S&&h(s,b),e.state=function(){return h(b,{})}),n?(r.random=e,t):e})(x,g,"global"in p?p.global:this==r,p.state)}function c(e){var t,n=e.length,r=this,s=0,o=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<a;)i[s]=s++;for(s=0;s<a;s++)i[s]=i[o=p&o+e[s%n]+(t=i[s])],i[o]=t;(r.g=function(e){for(var t,n=0,s=r.i,o=r.j,i=r.S;e--;)t=i[s=p&s+1],n=n*a+i[p&(i[s]=i[o=p&o+t])+(i[o]=t)];return r.i=s,r.j=o,n})(a)}function h(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function d(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(d(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function m(e,t){for(var n,r=e+"",s=0;s<r.length;)t[p&s]=p&(n^=19*t[p&s])+r.charCodeAt(s++);return f(t)}function f(e){return String.fromCharCode.apply(0,e)}if(m(r.random(),n),e.exports){e.exports=l;try{s=js}catch(e){}}else r.seedrandom=l}("undefined"!=typeof self?self:Rs,[],Math)}));Gs.alea=Ps,Gs.xor128=Ks,Gs.xorwow=qs,Gs.xorshift7=Us,Gs.xor4096=Ws,Gs.tychei=Hs;var Zs=Gs;class Qs{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=s||Math.random();this.random=Zs.alea(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,a;do{r=2*this.random()-1,s=2*this.random()-1,a=r*r+s*s}while(a>=1||0===a);const o=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*r*o,t=this.mean+this.stdDev*s*o,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Ys{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=Zs.alea(s.toString()),this.randn=new Qs(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,a;for(;;){do{r=this.randn.nextValue(),a=1+this.c*r}while(a<=0);if(a*=a*a,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),s=this.randu(),s<t||Math.log(s)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class Xs{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Zs.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const Js=Yt({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const a=new Ys(t,n,r,s),o=Bn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const ea=Yt({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const a=new Qs(t,n,r,!1,s),o=Bn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const ta=Yt({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return ea(e,0,1,t,n)}});const na=Yt({randomUniform_:function(e,t=0,n=1,r="float32",s){const a=Bn(e,r),o=new Xs(t,n,null,s);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});function ra(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return Ut.runKernel("Range",{},s)}const sa=Yt({real_:function(e){const t={input:Zt(e,"input","real")};return Ut.runKernel("Real",t)}});const aa=Yt({reciprocal_:function(e){const t={x:Zt(e,"x","reciprocal")};return Ut.runKernel("Reciprocal",t)}});const oa=Yt({relu_:function(e){const t={x:Zt(e,"x","relu")};return Ut.runKernel("Relu",t)}});const ia=Yt({relu6_:function(e){const t={x:Zt(e,"x","relu6")};return Ut.runKernel("Relu6",t)}});const ua=Yt({reverse_:function(e,t){const n={x:Zt(e,"x","reverse")},r={dims:t};return Ut.runKernel("Reverse",n,r)}});const pa=Yt({reverse1d_:function(e){const t=Zt(e,"x","reverse");return le(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),ua(t,0)}});const la=Yt({reverse2d_:function(e,t){const n=Zt(e,"x","reverse");return le(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),ua(n,t)}});const ca=Yt({reverse3d_:function(e,t){const n=Zt(e,"x","reverse");return le(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),ua(n,t)}});const ha=Yt({reverse4d_:function(e,t){const n=Zt(e,"x","reverse");return le(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),ua(n,t)}});const da=Yt({round_:function(e){const t={x:Zt(e,"x","round")};return Ut.runKernel("Round",t)}});const ma=Yt({rsqrt_:function(e){const t={x:Zt(e,"x","rsqrt","float32")};return Ut.runKernel("Rsqrt",t)}});const fa=Yt({selu_:function(e){const t={x:Zt(e,"x","selu")};return Ut.runKernel("Selu",t)}});const ya=Yt({separableConv2d_:function(e,t,n,r,s,a=[1,1],o="NHWC"){const i=Zt(e,"x","separableConv2d"),u=Zt(t,"depthwiseFilter","separableConv2d"),p=Zt(n,"pointwiseFilter","separableConv2d");let l=i,c=!1;if(3===i.rank&&(c=!0,l=wn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),"NCHW"===o)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");le(4===l.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${l.rank}.`)),le(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),le(4===p.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),le(1===p.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${p.shape[0]}.`)),le(1===p.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${p.shape[1]}.`));const h=u.shape[2],d=u.shape[3];le(p.shape[2]===h*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${h*d}, but got ${p.shape[2]}.`));const m=ir(l,u,r,s,o,a),f=Gn(m,p,1,"valid",o);return c?wn(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});const ga=async function(e,t){const n=Zt(e,"x","setdiff1d"),r=Zt(t,"y","setdiff1d");le(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),le(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),le(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),a=await r.data(),o=new Set(a);let i=0;for(let e=0;e<s.length;e++)o.has(s[e])||i++;const u=new $t([i],n.dtype),p=new $t([i],"int32");for(let e=0,t=0;e<s.length;e++)o.has(s[e])||(u.values[t]=s[e],p.values[t]=e,t++);return[u.toTensor(),p.toTensor()]};const ba=Yt({sign_:function(e){const t={x:Zt(e,"x","sign")};return Ut.runKernel("Sign",t)}});const xa=Yt({sin_:function(e){const t={x:Zt(e,"x","sin","float32")};return Ut.runKernel("Sin",t)}});const Na=Yt({sinh_:function(e){const t={x:Zt(e,"x","sinh")};return Ut.runKernel("Sinh",t)}});const wa=Yt({slice1d_:function(e,t,n){const r=Zt(e,"x","slice1d");return le(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),In(r,[t],[n])}});const ka=Yt({slice2d_:function(e,t,n){const r=Zt(e,"x","slice2d");return le(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),In(r,t,n)}});const Ta=Yt({slice3d_:function(e,t,n){const r=Zt(e,"x","slice3d");return le(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),In(r,t,n)}});const va=Yt({slice4d_:function(e,t,n){const r=Zt(e,"x","slice4d");return le(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),In(r,t,n)}});const _a=Yt({softmax_:function(e,t=-1){const n=Zt(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return Ut.runKernel("Softmax",r,s)}});const Sa=Yt({fft_:function(e){le("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Ut.runKernel("FFT",t)}});const Ea=Yt({ifft_:function(e){le("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Ut.runKernel("IFFT",t)}});const $a=Yt({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=wn(e,[n,t]);r=Ea(s)}else{const s=[n,2*(t-1)],a=wn(sa(e),[n,t]),o=wn(qr(e),[n,t]),i=ua(In(a,[0,1],[n,t-2]),1),u=En(ua(In(o,[0,1],[n,t-2]),1),Sr(-1)),p=_n([a,i],1),l=_n([o,u],1),c=wn(qn(p,l),[s[0],s[1]]);r=Ea(c)}if(r=sa(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=wn(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const Ia=Yt({split_:function(e,t,n=0){const r={x:Zt(e,"x","split")},s={numOrSizeSplits:t,axis:n};return Ut.runKernel("SplitV",r,s)}});const Da=Yt({rfft_:function(e,t){le("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),a=e.shape.map((e=>e));a[e.shape.length-1]=t,s=In(e,r,a),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=_n([e,ys(r)],e.shape.length-1),n=t}else s=e;const a=fr(s),o=wn(qn(s,a),[r,n]),i=Sa(o),u=Math.floor(n/2)+1,p=sa(i),l=qr(i),c=Ia(p,[u,n-u],p.shape.length-1),h=Ia(l,[u,n-u],l.shape.length-1),d=s.shape.slice();return d[s.shape.length-1]=u,wn(qn(c[0],h[0]),d)}});const Aa=Yt({squaredDifference_:function(e,t){let n=Zt(e,"a","squaredDifference"),r=Zt(t,"b","squaredDifference");[n,r]=Rt(n,r),hr(n.shape,r.shape);const s={a:n,b:r};return Ut.runKernel("SquaredDifference",s,{})}});const Oa=Yt({squeeze_:function(e,t){const n=Zt(e,"x","squeeze","string_or_numeric");return wn(n,function(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||s?null:be(t,e).sort();let o=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[o]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[o]||a[o]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),a[o]<=t&&o++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}(n.shape,t).newShape)}});const Ma=Yt({stack_:function(e,t=0){const n=Qt(e,"tensors","stack","string_or_numeric");le(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&le(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return Ut.runKernel("Pack",r,s)}});const Ca=Yt({step_:function(e,t=0){const n={x:Zt(e,"x","step")},r={alpha:t};return Ut.runKernel("Step",n,r)}});const Fa=Yt({stridedSlice_:function(e,t,n,r,s=0,a=0,o=0,i=0,u=0){const p={x:Zt(e,"x","stridedSlice","string_or_numeric")},l={begin:t,end:n,strides:r,beginMask:s,endMask:a,ellipsisMask:o,newAxisMask:i,shrinkAxisMask:u};return Ut.runKernel("StridedSlice",p,l)}});const Va=Yt({tan_:function(e){const t={x:Zt(e,"x","tan","float32")};return Ut.runKernel("Tan",t)}});function za(e,t,n){return _r(e,t,Ht(e,n),n)}function Ra(e,t){he(e);const n=Ht(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return _r(e,null,n,t)}function La(e,t,n){if(he(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Ht(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return _r(e,t,r,n)}const Ba=Yt({topk_:function(e,t=1,n=!0){const r=Zt(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const a={x:r},o={k:t,sorted:n},[i,u]=Ut.runKernel("TopK",a,o);return{values:i,indices:u}}});const Pa=Yt({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const a=new Qs(t,n,r,!0,s),o=Bn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const Ka=Yt({unique_:function(e,t=0){const n=Zt(e,"x","unique","string_or_numeric");le(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[a,o]=Ut.runKernel("Unique",r,s);return{values:a,indices:o}}});const qa=Yt({unsortedSegmentSum_:function(e,t,n){const r=Zt(e,"x","unsortedSegmentSum"),s=Zt(t,"segmentIds","unsortedSegmentSum","int32");le(ye(n),(()=>"numSegments must be of dtype int"));const a={x:r,segmentIds:s},o={numSegments:n};return Ut.runKernel("UnsortedSegmentSum",a,o)}});const Ua=Yt({unstack_:function(e,t=0){const n=Zt(e,"x","unstack","string_or_numeric");le(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return Ut.runKernel("Unpack",r,s)}});const Wa=async function(e){const t=Zt(e,"condition","whereAsync","bool"),n=await t.data(),r=function(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=Bn(e,"int32"),s=Bn([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=r.indexToLoc(n[t]),o=t*e.length;s.values.set(a,o)}return s.toTensor()}(t.shape,n);return e!==t&&t.dispose(),r};const Ha=async function(e,t,n){const r=Zt(e,"tensor","boolMask"),s=Zt(t,"mask","boolMask","bool"),a=null==n?0:n,o=s.rank,i=r.shape;le(o>0,(()=>"mask cannot be scalar")),ce(i.slice(a,a+o),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let u=1;for(let e=a;e<a+o;e++)u*=i[e];const p=i.slice(0,a).concat([u],i.slice(a+o)),l=wn(r,p),c=wn(s,[-1]),h=await Wa(c),d=Oa(h,[1]),m=Br(l,d,a);return e!==r&&r.dispose(),t!==s&&s.dispose(),d.dispose(),l.dispose(),c.dispose(),h.dispose(),m};const ja=Yt({transpose_:function(e,t,n){const r=Zt(e,"x","transpose");if(null==t&&(t=r.shape.map(((e,t)=>t)).reverse()),le(r.rank===t.length,(()=>`Error in transpose: rank of input ${r.rank} must match length of perm ${t}.`)),t.forEach((e=>{le(e>=0&&e<r.rank,(()=>"All entries in 'perm' must be between 0 and "+(r.rank-1)+` but got ${t}`))})),r.rank<=1)return r.clone();const s={x:r},a={perm:t};return"complex64"===r.dtype?(o=()=>{let e=sa(r),t=qr(r);return e=Ut.runKernel("Transpose",{x:e},a),t=Ut.runKernel("Transpose",{x:t},a),n&&(t=es(t)),qn(e,t)},Ut.tidy(o,i)):Ut.runKernel("Transpose",s,a);var o,i}});const Ga=Yt({movingAverage_:function(e,t,n,r,s=!0){const a=Zt(e,"v","movingAverage"),o=Zt(t,"x","movingAverage"),i=Zt(n,"decay","movingAverage");var u,p;p=o,le((u=a).dtype===p.dtype,(()=>`The dtypes of the first(${u.dtype}) and second(${p.dtype}) input must match`)),le(fe(a.shape,o.shape),(()=>"Shape mismatch in v and x"));const l=Sr(1),c=rs(l,i);let h=En(rs(o,a),c);if(s){le(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Zt(r,"step","movingAverage");h=cr(h,rs(l,vr(i,e)))}return tn(a,h)}});function Za(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}!function(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,a=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(a+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(a+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(a+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(a+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}(n,t,e)}const Qa=Yt({scatterND_:function(e,t,n){const r=Zt(e,"indices","scatterND","int32"),s=Zt(t,"updates","scatterND");Za(s,r,n);const a={indices:r,updates:s},o={shape:n};return Ut.runKernel("ScatterNd",a,o)}});const Ya=Yt({sparseToDense_:function(e,t,n,r=0){const s=Zt(e,"sparseIndices","sparseToDense","int32"),a=Zt(t,"sparseValues","sparseToDense","string_or_numeric"),o=Zt(r,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const o=t.size;if(0!==t.rank&&(1!==t.rank||o!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,a,n,o);const i={sparseIndices:s,sparseValues:a,defaultValue:o},u={outputShape:n};return Ut.runKernel("SparseToDense",i,u)}});const Xa=Yt({gatherND_:function(e,t){const n=Zt(t,"indices","gatherND","int32"),r={params:Zt(e,"x","gatherND","string_or_numeric"),indices:n};return Ut.runKernel("GatherNd",r)}});const Ja=Yt({dropout_:function(e,t,n,r){const s=Zt(e,"x","dropout");if(le("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),le(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof Dt?s.clone():s;const a=function(e,t){if(null==t)return e.shape.slice();if(fe(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),o=1-t,i=cr(Lr(tn(na(a,0,1,"float32",r),o)),o);return En(s,i)}});function eo(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function to(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let a=0;a<e;++a){const o=2*Math.PI*a/(e+r-1);s[a]=t-n*Math.cos(o)}return Ra(s,"float32")}const no=async function(e,t,n=1){const r=Zt(e,"predictions","inTopK"),s=Zt(t,"targets","inTopK");le(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),le(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),ce(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=r.shape[r.shape.length-1];le(n>0&&n<=a,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`));const o=await r.data(),i=await s.data(),[u,p]=[o.length/a,a],l=function(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}("bool",u);for(let e=0;e<u;e++){const t=e*p,r=o.subarray(t,t+p),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),l[e]=0;for(let t=0;t<n;t++)if(s[t].index===i[e]){l[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),za(l,s.shape,"bool")};const ro=Yt({conv2DBackpropFilter_:function(e,t,n,r,s,a="NHWC",o){let i=e;3===e.rank&&(i=wn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=wn(t,[1,t.shape[0],t.shape[1],t.shape[2]])),le(4===i.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${i.shape}.`)),le(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),le(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const p="NHWC"===a?i.shape[3]:i.shape[1],l="NHWC"===a?u.shape[3]:u.shape[1];le(p===n[2],(()=>`Error in conv2dDerFilter: depth of input ${p}) must match input depth in filter (${n[2]}.`)),le(l===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${l}) must match output depth for filter (${n[3]}).`)),Nn("conv2dDerFilter",s,o);const c={x:i,dy:u},h={strides:r,pad:s,dataFormat:a,dimRoundingMode:o,filterShape:n};return Ut.runKernel("Conv2DBackpropFilter",c,h)}});function so(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return En(e,Ca(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function ao(e,t){let n=t;const r=function(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],a=t.length-r-1,o=t[a];(null==s||1===s&&o>1)&&n.unshift(a)}return n}(e.shape,t.shape);return r.length>0&&(n=Ir(n,r)),wn(n,e.shape)}function oo(e,t,n,r){if("linear"===t)return e;if("relu"===t)return oa(e);if("elu"===t)return xr(e);if("relu6"===t)return ia(e);if("prelu"===t)return Fs(e,n);if("leakyrelu"===t)return jr(e,r);if("sigmoid"===t)return $n(e);throw new Error(`Unknown fused activation ${t}.`)}const io=(e,t)=>!(e>0)||"linear"===t;const uo=Yt({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:a=[1,1],dimRoundingMode:o,bias:i,activation:u="linear",preluActivationWeights:p,leakyreluAlpha:l}){if(u=u||"linear",!1===io(Ut.state.gradientDepth,u)){le("NHWC"===s,(()=>`Error in fused conv2d: got dataFormat of ${s} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Gn(e,t,n,r,s,a,o);return null!=i&&(c=tn(c,i)),oo(c,u,p,l)}const c=Zt(e,"x","conv2d","float32"),h=Zt(t,"filter","conv2d","float32");let d=c,m=!1;3===c.rank&&(m=!0,d=wn(c,[1,c.shape[0],c.shape[1],c.shape[2]])),le(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),le(4===h.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${h.rank}.`)),Nn("fused conv2d",r,o);const f="NHWC"===s?d.shape[3]:d.shape[1];le(h.shape[2]===f,(()=>`Error in conv2d: depth of input (${f}) must match input depth for filter ${h.shape[2]}.`)),le(xn(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const y=mn(d.shape,h.shape,n,a,r,o);let g,b;if(null!=i&&(g=Zt(i,"bias","fused conv2d"),[g]=Rt(g,c),"NHWC"===s?hr(y.outShape,g.shape):(le(g.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${g.shape.length}.`)),le(0===g.shape.length||g.shape[0]===y.outChannels||1===g.shape[0],(()=>`Error in fused conv2d: bias shape (${g.shape}) is not compatible with the number of output channels (${y.outChannels})`)))),null!=p){const e=p.shape;if(le(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)le(1===e[0]||e[0]===y.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${y.outChannels}).`));else if(3===e.length)try{hr(e,y.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${y.outShape}).`;throw Error(n)}b=Zt(p,"prelu weights","fused conv2d")}const x=(e,t)=>{le("NHWC"===s,(()=>`Error in gradient of fused conv2D: got dataFormat of ${s} but only NHWC is currently supported.`));const[o,i,p,l]=t,c=so(e,p,u);le(bn(a),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`));const h=[Qn(i.shape,c,o,n,r),ro(i,c,o.shape,n,r)];if(null!=l){const e=ao(l,c);h.push(e)}return h},N={x:d,filter:h,bias:g,preluActivationWeights:b},w={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o,activation:u,leakyreluAlpha:l};if(null==i){const e=Jr(((e,t,n)=>{let r=Ut.runKernel("FusedConv2D",N,w);return n([t,e,r]),m&&(r=wn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}}));return e(d,h)}{const e=Jr(((e,t,n,r)=>{let s=Ut.runKernel("FusedConv2D",N,w);return r([t,e,s,n]),m&&(s=wn(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}}));return e(d,h,g)}}});const po=Yt({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,a=[1,1],o){let i=e;3===e.rank&&(i=wn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=wn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const p={x:i,dy:u},l={strides:r,pad:s,dimRoundingMode:o,dilations:a,filterShape:n};return Ut.runKernel("DepthwiseConv2dNativeBackpropFilter",p,l)}});const lo=Yt({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,a=[1,1],o){let i=t,u=!1;3===t.rank&&(u=!0,i=wn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const p={dy:i,filter:n},l={strides:r,pad:s,dimRoundingMode:o,dilations:a,inputShape:e},c=Ut.runKernel("DepthwiseConv2dNativeBackpropInput",p,l);return u?wn(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const co=Yt({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:a=[1,1],dimRoundingMode:o,bias:i,activation:u="linear",preluActivationWeights:p,leakyreluAlpha:l}){if(!1===io(Ut.state.gradientDepth,u)){let c=ir(e,t,n,r,s,a,o);return null!=i&&(c=tn(c,i)),oo(c,u,p,l)}const c=Zt(e,"x","depthwiseConv2d","float32"),h=Zt(t,"filter","depthwiseConv2d","float32");let d=c,m=!1;3===c.rank&&(m=!0,d=wn(c,[1,c.shape[0],c.shape[1],c.shape[2]])),le(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),le(4===h.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${h.rank}.`)),le(d.shape[3]===h.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${h.shape[2]}.`)),null==a&&(a=[1,1]),le(xn(n,a),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),Nn("fused depthwiseConv2d",r,o);const f=mn(d.shape,h.shape,n,a,r,o,!0);let y,g;null!=i&&(y=Zt(i,"bias","fused conv2d"),[y]=Rt(y,c),hr(f.outShape,y.shape)),null!=p&&(g=Zt(p,"prelu weights","fused depthwiseConv2d"));const b=(e,t)=>{le(bn(a),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`));const[s,i,p,l]=t,c=so(e,p,u),h=lo(i.shape,c,s,n,r,a,o),d=po(i,c,s.shape,n,r,a,o);if(null!=l){return[h,d,ao(y,c)]}return[h,d]},x={x:d,filter:h,bias:y,preluActivationWeights:g},N={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o,activation:u,leakyreluAlpha:l};if(null==i){const e=Jr(((e,t,n)=>{let r=Ut.runKernel("FusedDepthwiseConv2D",x,N);return n([t,e,r]),m&&(r=wn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:b}}));return e(d,h)}{const e=Jr(((e,t,n,r)=>{let s=Ut.runKernel("FusedDepthwiseConv2D",x,N);return r([t,e,s,n]),m&&(s=wn(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:b}}));return e(d,h,y)}}});var ho={__proto__:null,conv2d:uo,depthwiseConv2d:co,matMul:Yt({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:a="linear",preluActivationWeights:o,leakyreluAlpha:i=.2}){if(!1===io(Ut.state.gradientDepth,a)){let u=Sn(e,t,n,r);return null!=s&&(u=tn(u,s)),oo(u,a,o,i)}let u=Zt(e,"a","fused matMul"),p=Zt(t,"b","fused matMul");[u,p]=Rt(u,p);const l=n?u.shape[u.rank-2]:u.shape[u.rank-1],c=r?p.shape[p.rank-1]:p.shape[p.rank-2],h=n?u.shape[u.rank-1]:u.shape[u.rank-2],d=r?p.shape[p.rank-2]:p.shape[p.rank-1],m=u.shape.slice(0,-2),f=p.shape.slice(0,-2),y=me(m),g=me(f);le(l===c,(()=>`Error in fused matMul: inner shapes (${l}) and (${c}) of Tensors with shapes ${u.shape} and ${p.shape} and transposeA=${n} and transposeB=${r} must match.`));const b=hr(u.shape.slice(0,-2),p.shape.slice(0,-2)).concat([h,d]),x=wn(u,n?[y,l,h]:[y,h,l]),N=wn(p,r?[g,d,c]:[g,c,d]);let w,k;null!=s&&(w=Zt(s,"bias","fused matMul"),[w]=Rt(w,u),hr(b,w.shape)),null!=o&&(k=Zt(o,"prelu weights","fused matMul"));const T=(e,t)=>{const[o,i,u,p]=t,l=so(wn(e,u.shape),u,a);let c,h;if(n||r?!n&&r?(c=Sn(l,i,!1,!1),h=Sn(l,o,!0,!1)):n&&!r?(c=Sn(i,l,!1,!0),h=Sn(o,l,!1,!1)):(c=Sn(i,l,!0,!0),h=Sn(l,o,!0,!0)):(c=Sn(l,i,!1,!0),h=Sn(o,l,!0,!1)),null!=s){return[c,h,ao(p,l)]}return[c,h]},v={a:x,b:N,bias:w,preluActivationWeights:k},_={transposeA:n,transposeB:r,activation:a,leakyreluAlpha:i};if(null==s){const e=Jr(((e,t,n)=>{const r=Ut.runKernel("_FusedMatMul",v,_);return n([e,t,r]),{value:wn(r,b),gradFunc:T}}));return e(x,N)}{const e=Jr(((e,t,n,r)=>{const s=Ut.runKernel("_FusedMatMul",v,_);return r([e,t,s,n]),{value:wn(s,b),gradFunc:T}}));return e(x,N,w)}}})};const mo=Yt({hammingWindow_:function(e){return to(e,.54,.46)}});const fo=Yt({hannWindow_:function(e){return to(e,.5,.5)}});const yo=Yt({frame_:function(e,t,n,r=!1,s=0){let a=0;const o=[];for(;a+t<=e.size;)o.push(In(e,a,t)),a+=n;if(r)for(;a<e.size;){const r=a+t-e.size,i=_n([In(e,a,t-r),Rr([r],s)]);o.push(i),a+=n}return 0===o.length?La([],[0,t]):wn(_n(o),[o.length,t])}});const go=Yt({stft_:function(e,t,n,r,s=fo){null==r&&(r=eo(t));const a=yo(e,t,n),o=En(a,s(t));return Da(o,r)}});const bo=Yt({cropAndResize_:function(e,t,n,r,s="bilinear",a=0){const o=Zt(e,"image","cropAndResize"),i=Zt(t,"boxes","cropAndResize","float32"),u=Zt(n,"boxInd","cropAndResize","int32"),p=i.shape[0];le(4===o.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${o.rank}.`)),le(2===i.rank&&4===i.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${p},4] but had shape ${i.shape}.`)),le(1===u.rank&&u.shape[0]===p,(()=>`Error in cropAndResize: boxInd must be have size [${p}] but had shape ${i.shape}.`)),le(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),le(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),le("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const l={image:o,boxes:i,boxInd:u},c={method:s,extrapolationValue:a,cropSize:r};return Ut.runKernel("CropAndResize",l,c)}});const xo=Yt({flipLeftRight_:function(e){const t=Zt(e,"image","flipLeftRight","float32");le(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Ut.runKernel("FlipLeftRight",n,{})}});const No=Yt({grayscaleToRGB_:function(e){const t=Zt(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];le(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),le(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,Vr(t,s)}});const wo=Yt({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Zt(e,"image","rotateWithOffset","float32");le(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const a={image:s},o={radians:t,fillValue:n,center:r};return Ut.runKernel("RotateWithOffset",a,o)}});function ko(e,t,n,r,s,a){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==a&&(a=0);const o=e.shape[0];return n=Math.min(n,o),le(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),le(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),le(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),le(1===t.rank,(()=>"scores must be a 1D tensor")),le(t.shape[0]===o,(()=>`scores has incompatible shape with boxes. Expected ${o}, but was ${t.shape[0]}`)),le(0<=a&&a<=1,(()=>`softNmsSigma must be in [0, 1], but was '${a}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:a}}const To=Yt({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const a=Zt(e,"boxes","nonMaxSuppression","float32"),o=Zt(t,"scores","nonMaxSuppression","float32"),i=ko(a,o,n,r,s),u={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return Ut.runKernel("NonMaxSuppressionV3",{boxes:a,scores:o},u)}});function vo(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,a=0,o=!1;for(;r<s;){a=r+(s-r>>>1);const i=n(t,e[a]);i>0?r=a+1:(s=a,o=!i)}return o?r:-r-1}(e,t,n||_o)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function _o(e,t){return e>t?1:e<t?-1:0}function So(e,t,n,r,s,a,o=!1,i=!1,u=!1){const p=[];for(let e=0;e<t.length;e++)t[e]>s&&p.push({score:t[e],boxIndex:e,suppressBeginIndex:0});p.sort(Io);const l=a>0?-.5/a:0,c=[],h=[];for(;c.length<n&&p.length>0;){const t=p.pop(),{score:n,boxIndex:a,suppressBeginIndex:o}=t;if(n<s)break;let i=!1;for(let n=c.length-1;n>=o;--n){const o=Eo(e,a,c[n]);if(o>=r){i=!0;break}if(t.score=t.score*$o(r,l,o),t.score<=s)break}t.suppressBeginIndex=c.length,i||(t.score===n?(c.push(a),h.push(t.score)):t.score>s&&vo(p,t,Io))}const d=c.length,m=n-d;i&&m>0&&(c.push(...new Array(m).fill(0)),h.push(...new Array(m).fill(0)));const f={selectedIndices:c};return o&&(f.selectedScores=h),u&&(f.validOutputs=d),f}function Eo(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),a=Math.min(r[0],r[2]),o=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),u=Math.max(r[1],r[3]),p=Math.min(s[0],s[2]),l=Math.min(s[1],s[3]),c=Math.max(s[0],s[2]),h=Math.max(s[1],s[3]),d=(i-a)*(u-o),m=(c-p)*(h-l);if(d<=0||m<=0)return 0;const f=Math.max(a,p),y=Math.max(o,l),g=Math.min(i,c),b=Math.min(u,h),x=Math.max(g-f,0)*Math.max(b-y,0);return x/(d+m-x)}function $o(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function Io(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const Do=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const a=Zt(e,"boxes","nonMaxSuppressionAsync"),o=Zt(t,"scores","nonMaxSuppressionAsync"),i=ko(a,o,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const u=await Promise.all([a.data(),o.data()]),p=u[0],l=u[1],{selectedIndices:c}=function(e,t,n,r,s){return So(e,t,n,r,s,0)}(p,l,n,r,s);return a!==e&&a.dispose(),o!==t&&o.dispose(),Ra(c,"int32")};const Ao=Yt({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=0){const o=Zt(e,"boxes","nonMaxSuppression"),i=Zt(t,"scores","nonMaxSuppression"),u=ko(o,i,n,r,s,a),p={boxes:o,scores:i},l={maxOutputSize:n=u.maxOutputSize,iouThreshold:r=u.iouThreshold,scoreThreshold:s=u.scoreThreshold,softNmsSigma:a=u.softNmsSigma},c=Ut.runKernel("NonMaxSuppressionV5",p,l);return{selectedIndices:c[0],selectedScores:c[1]}}});const Oo=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=0){const o=Zt(e,"boxes","nonMaxSuppressionAsync"),i=Zt(t,"scores","nonMaxSuppressionAsync"),u=ko(o,i,n,r,s,a);n=u.maxOutputSize,r=u.iouThreshold,s=u.scoreThreshold,a=u.softNmsSigma;const p=await Promise.all([o.data(),i.data()]),l=p[0],c=p[1],{selectedIndices:h,selectedScores:d}=function(e,t,n,r,s,a){return So(e,t,n,r,s,a,!0)}(l,c,n,r,s,a);return o!==e&&o.dispose(),i!==t&&i.dispose(),{selectedIndices:Ra(h,"int32"),selectedScores:Ra(d)}};const Mo=Yt({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=!1){const o=Zt(e,"boxes","nonMaxSuppression"),i=Zt(t,"scores","nonMaxSuppression"),u=ko(o,i,n,r,s,null),p={boxes:o,scores:i},l={maxOutputSize:u.maxOutputSize,iouThreshold:u.iouThreshold,scoreThreshold:u.scoreThreshold,padToMaxOutputSize:a},c=Ut.runKernel("NonMaxSuppressionV4",p,l);return{selectedIndices:c[0],validOutputs:c[1]}}});const Co=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=!1){const o=Zt(e,"boxes","nonMaxSuppressionAsync"),i=Zt(t,"scores","nonMaxSuppressionAsync"),u=ko(o,i,n,r,s,null),p=u.maxOutputSize,l=u.iouThreshold,c=u.scoreThreshold,[h,d]=await Promise.all([o.data(),i.data()]),{selectedIndices:m,validOutputs:f}=function(e,t,n,r,s,a){return So(e,t,n,r,s,0,!1,a,!0)}(h,d,p,l,c,a);return o!==e&&o.dispose(),i!==t&&i.dispose(),{selectedIndices:Ra(m,"int32"),validOutputs:Sr(f,"int32")}};const Fo=Yt({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Zt(e,"images","resizeBilinear");le(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),le(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),le(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let a=s,o=!1;3===s.rank&&(o=!0,a=wn(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:a},u={alignCorners:n,halfPixelCenters:r,size:t},p=Ut.runKernel("ResizeBilinear",i,u);return o?wn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const Vo=Yt({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Zt(e,"images","resizeNearestNeighbor");le(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),le(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),le("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),le(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let a=s,o=!1;3===s.rank&&(o=!0,a=wn(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:a},u={alignCorners:n,halfPixelCenters:r,size:t},p=Ut.runKernel("ResizeNearestNeighbor",i,u);return o?wn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const zo=Yt({threshold_:function(e,t="binary",n=!1,r=.5){const s=Zt(e,"image","threshold"),a=s.shape[0]*s.shape[1];let o,i,u,p,l=En(Ra([r]),255);if(le(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),le(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),le("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),le("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[o,i,u]=Ia(s,[1,1,1],-1);const e=En(o,.2989),t=En(i,.587),n=En(u,.114);p=tn(tn(e,t),n)}else p=e;if("otsu"===t){l=function(e,t){let n,r,s,a,o,i,u=Ra([-1]),p=Ra([0]),l=Ra([0]);for(let c=0;c<e.size-1;c++){n=In(e,0,c+1),r=In(e,c+1),o=cr(Ir(n),t),i=cr(Ir(r),t);const h=Ir(En(n,ra(0,n.size)));s=cr(h,Ir(n));const d=Rr(r.shape,n.size),m=tn(ra(0,r.size),d),f=En(r,m);a=cr(Ir(f),Ir(r));const y=rs(s,a),g=rs(s,a),b=En(o,i);l=En(En(b,y),g);const x=Pr(l,p);p=mr(x,l,p),u=mr(x,Ra([c]),u)}return u}(zn(dn(da(p),"int32"),za([]),256),a)}const c=n?Zr(p,l):Pr(p,l);return dn(En(c,255),"int32")}});const Ro=Yt({transform_:function(e,t,n="nearest",r="constant",s=0,a){const o=Zt(e,"image","transform","float32"),i=Zt(t,"transforms","transform","float32");le(4===o.rank,(()=>`Error in transform: image must be rank 4,but got rank ${o.rank}.`)),le(2===i.rank&&(i.shape[0]===o.shape[0]||1===i.shape[0])&&8===i.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),le(null==a||2===a.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${a}.`));const u={image:o,transforms:i},p={interpolation:n,fillMode:r,fillValue:s,outputShape:a};return Ut.runKernel("Transform",u,p)}});const Lo=Yt({bandPart_:function(e,t,n){le(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),le(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Zt(e,"a","bandPart");le(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[a,o]=r.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=o))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${o}).`);t<0&&(t=a),n<0&&(n=o);const i=wn(ra(0,a,1,"int32"),[-1,1]),u=ra(0,o,1,"int32"),p=rs(i,u),l=os(Zr(p,Sr(+t,"int32")),Kr(p,Sr(-n,"int32"))),c=ys([a,o],r.dtype);return wn(Ma(Ua(wn(r,[-1,a,o])).map((e=>mr(l,e,c)))),s)}});const Bo=Yt({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,le(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)le(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=Ia(e,e.shape[0],0).map((e=>Oa(e,[0])));le(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(Ut.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=En(Ir(En(n[r],e)),n[r]);e=rs(e,t)}return cr(e,Ar(e,"euclidean"))})));return t?Ma(n,0):n}});function Po(e,t=!1){return Ut.tidy((()=>{le(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=zr(n),a=vn(e);const o=La([[1]],[1,1]);let i=vn(o);const u=n>=r?r:n;for(let e=0;e<u;++e){const t=a,u=i,p=s;[i,a,s]=Ut.tidy((()=>{const t=In(a,[e,e],[n-e,1]),u=Ar(t),p=In(a,[e,e],[1,1]),l=mr(Pr(p,0),La([[-1]]),La([[1]])),c=rs(p,En(l,u)),h=cr(t,c);i=1===h.shape[0]?vn(o):_n([o,In(h,[1,0],[h.shape[0]-1,h.shape[1]])],0);const d=es(cr(Sn(l,c),u)),m=In(a,[e,0],[n-e,r]),f=En(d,i),y=ja(i);if(0===e)a=rs(m,Sn(f,Sn(y,m)));else{const t=rs(m,Sn(f,Sn(y,m)));a=_n([In(a,[0,0],[e,r]),t],0)}const g=ja(f),b=In(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=rs(b,Sn(Sn(b,i),g));else{const t=rs(b,Sn(Sn(b,i),g));s=_n([In(s,[0,0],[n,e]),t],1)}return[i,a,s]})),Lt([t,u,p]).forEach((e=>e.dispose()))}return!t&&n>r&&(s=In(s,[0,0],[n,r]),a=In(a,[0,0],[r,r])),[s,a]}))}const Ko=Yt({qr_:function(e,t=!1){if(le(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Po(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Ua(wn(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],a=[];r.forEach((e=>{const[n,r]=Po(e,t);s.push(n),a.push(r)}));return[wn(Ma(s,0),e.shape),wn(Ma(a,0),e.shape)]}}});var qo;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(qo||(qo={}));const Uo=Yt({computeWeightedLoss_:function(e,t,n=qo.SUM_BY_NONZERO_WEIGHTS){const r=Zt(e,"losses","computeWeightedLoss");let s=null;null!=t&&(s=Zt(t,"weights","computeWeightedLoss"));const a=null==s?r:En(r,s);if(n===qo.NONE)return a;if(n===qo.SUM)return Ir(a);if(n===qo.MEAN){if(null==s)return fs(a);{const e=r.size/s.size,t=cr(Ir(a),Ir(s));return e>1?cr(t,Sr(e)):t}}if(n===qo.SUM_BY_NONZERO_WEIGHTS){if(null==s)return cr(Ir(a),Sr(r.size));{const e=En(s,gs(r.shape)),t=dn(Ir(vs(e,Sr(0))),"float32");return cr(Ir(a),t)}}throw Error(`Unknown reduction: ${n}`)}});const Wo=Yt({absoluteDifference_:function(e,t,n,r=qo.SUM_BY_NONZERO_WEIGHTS){const s=Zt(e,"labels","absoluteDifference"),a=Zt(t,"predictions","absoluteDifference");let o=null;null!=n&&(o=Zt(n,"weights","absoluteDifference")),ce(s.shape,a.shape,"Error in absoluteDifference: ");const i=Xt(rs(s,a));return Uo(i,o,r)}});const Ho=Yt({cosineDistance_:function(e,t,n,r,s=qo.SUM_BY_NONZERO_WEIGHTS){const a=Zt(e,"labels","cosineDistance"),o=Zt(t,"predictions","cosineDistance");let i=null;null!=r&&(i=Zt(r,"weights","cosineDistance")),ce(a.shape,o.shape,"Error in cosineDistance: ");const u=Sr(1),p=rs(u,Ir(En(a,o),n,!0));return Uo(p,i,s)}});const jo=Yt({hingeLoss_:function(e,t,n,r=qo.SUM_BY_NONZERO_WEIGHTS){let s=Zt(e,"labels","hingeLoss");const a=Zt(t,"predictions","hingeLoss");let o=null;null!=n&&(o=Zt(n,"weights","hingeLoss")),ce(s.shape,a.shape,"Error in hingeLoss: ");const i=Sr(1);s=rs(En(Sr(2),s),i);const u=oa(rs(i,En(s,a)));return Uo(u,o,r)}});const Go=Yt({huberLoss_:function(e,t,n,r=1,s=qo.SUM_BY_NONZERO_WEIGHTS){const a=Zt(e,"labels","huberLoss"),o=Zt(t,"predictions","huberLoss");let i=null;null!=n&&(i=Zt(n,"weights","huberLoss")),ce(a.shape,o.shape,"Error in huberLoss: ");const u=Sr(r),p=Xt(rs(o,a)),l=bs(p,u),c=rs(p,l),h=tn(En(Sr(.5),$r(l)),En(u,c));return Uo(h,i,s)}});const Zo=Yt({logLoss_:function(e,t,n,r=1e-7,s=qo.SUM_BY_NONZERO_WEIGHTS){const a=Zt(e,"labels","logLoss"),o=Zt(t,"predictions","logLoss");let i=null;null!=n&&(i=Zt(n,"weights","logLoss")),ce(a.shape,o.shape,"Error in logLoss: ");const u=Sr(1),p=Sr(r),l=es(En(a,Yr(tn(o,p)))),c=En(rs(u,a),Yr(tn(rs(u,o),p))),h=rs(l,c);return Uo(h,i,s)}});const Qo=Yt({meanSquaredError_:function(e,t,n,r=qo.SUM_BY_NONZERO_WEIGHTS){const s=Zt(e,"labels","meanSquaredError"),a=Zt(t,"predictions","meanSquaredError");let o=null;null!=n&&(o=Zt(n,"weights","meanSquaredError")),ce(s.shape,a.shape,"Error in meanSquaredError: ");const i=Aa(s,a);return Uo(i,o,r)}});const Yo=Yt({sigmoidCrossEntropy_:function(e,t,n,r=0,s=qo.SUM_BY_NONZERO_WEIGHTS){let a=Zt(e,"multiClassLabels","sigmoidCrossEntropy");const o=Zt(t,"logits","sigmoidCrossEntropy");let i=null;if(null!=n&&(i=Zt(n,"weights","sigmoidCrossEntropy")),ce(a.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Sr(r),t=Sr(1),n=Sr(.5);a=tn(En(a,rs(t,e)),En(n,e))}const u=function(e,t){const n=Zt(e,"labels","sigmoidCrossEntropyWithLogits"),r=Zt(t,"logits","sigmoidCrossEntropyWithLogits");ce(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=oa(r),a=En(r,n),o=Xr(Mr(es(Xt(r))));return tn(rs(s,a),o)}(a,o);return Uo(u,i,s)}});const Xo=Yt({softmaxCrossEntropy_:function(e,t,n,r=0,s=qo.SUM_BY_NONZERO_WEIGHTS){let a=Zt(e,"onehotLabels","softmaxCrossEntropy");const o=Zt(t,"logits","softmaxCrossEntropy");let i=null;if(null!=n&&(i=Zt(n,"weights","softmaxCrossEntropy")),ce(a.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Sr(r),t=Sr(1),n=Sr(a.shape[1]);a=tn(En(a,rs(t,e)),cr(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const r=Jr(((e,t,r)=>{const s=as(t,[n],!0),a=rs(dn(t,"float32"),s);r([e,a]);const o=es(En(a,e));return{value:Ir(o,[n]),gradFunc:(e,t)=>{const[r,s]=t,a=wr(e.shape,[n]);return[En(wn(e,a),rs(dn(r,"float32"),Mr(s))),En(wn(e,a),rs(Mr(s),dn(r,"float32")))]}}}));return r(e,t)}(a,o);return Uo(u,i,s)}});const Jo=Yt({sparseFillEmptyRows_:function(e,t,n,r){const s=Zt(e,"indices","sparseFillEmptyRows","int32"),a=Zt(t,"values","sparseFillEmptyRows"),o=Zt(n,"denseShape","sparseFillEmptyRows","int32"),i=Zt(r,"defaultValue","sparseFillEmptyRows",a.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==a.rank)throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);if(1!==o.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${o.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const u={indices:s,values:a,denseShape:o,defaultValue:i},p=Ut.runKernel("SparseFillEmptyRows",u);return{outputIndices:p[0],outputValues:p[1],emptyRowIndicator:p[2],reverseIndexMap:p[3]}}});const ei=Yt({sparseReshape_:function(e,t,n){const r=Zt(e,"inputIndices","sparseReshape","int32"),s=Zt(t,"inputShape","sparseReshape","int32"),a=Zt(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==a.rank)throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);const o={inputIndices:r,inputShape:s,newShape:a},i=Ut.runKernel("SparseReshape",o);return{outputIndices:i[0],outputShape:i[1]}}});const ti=Yt({sparseSegmentMean_:function(e,t,n){const r=Zt(e,"data","sparseSegmentMean"),s=Zt(t,"indices","sparseSegmentMean","int32"),a=Zt(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${a.shape}`);const o={data:r,indices:s,segmentIds:a};return Ut.runKernel("SparseSegmentMean",o)}});const ni=Yt({sparseSegmentSum_:function(e,t,n){const r=Zt(e,"data","sparseSegmentSum"),s=Zt(t,"indices","sparseSegmentSum","int32"),a=Zt(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${a.shape}`);const o={data:r,indices:s,segmentIds:a};return Ut.runKernel("SparseSegmentSum",o)}});const ri=Yt({stringNGrams_:function(e,t,n,r,s,a,o,i){const u=Zt(e,"data","stringNGrams","string");if("string"!==u.dtype)throw new Error("Data must be of datatype string");if(1!==u.shape.length)throw new Error(`Data must be a vector, saw: ${u.shape}`);const p=Zt(t,"dataSplits","stringNGrams");if("int32"!==p.dtype)throw new Error("Data splits must be of datatype int32");const l={separator:n,nGramWidths:r,leftPad:s,rightPad:a,padWidth:o,preserveShortSequences:i},c={data:u,dataSplits:p},h=Ut.runKernel("StringNGrams",c,l);return{nGrams:h[0],nGramsSplits:h[1]}}});const si=Yt({stringSplit_:function(e,t,n=!0){const r=Zt(e,"input","stringSplit","string"),s=Zt(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const a={skipEmpty:n},o={input:r,delimiter:s},i=Ut.runKernel("StringSplit",o,a);return{indices:i[0],values:i[1],shape:i[2]}}});const ai=Yt({stringToHashBucketFast_:function(e,t){const n=Zt(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return Ut.runKernel("StringToHashBucketFast",s,r)}});var oi={__proto__:null,abs:Xt,acos:Jt,acosh:en,add:tn,addN:nn,all:rn,any:sn,argMax:an,argMin:on,asin:un,asinh:pn,atan:ln,atan2:cn,atanh:hn,avgPool:kn,avgPool3d:Tn,basicLSTMCell:An,batchToSpaceND:On,batchNorm:Mn,batchNorm2d:Cn,batchNorm3d:Fn,batchNorm4d:Vn,bincount:zn,broadcastArgs:Rn,broadcastTo:Ln,buffer:Bn,cast:dn,ceil:Pn,clipByValue:Kn,clone:vn,complex:qn,concat:_n,concat1d:Un,concat2d:Wn,concat3d:Hn,concat4d:jn,conv1d:Zn,conv2d:Gn,conv2dTranspose:Yn,conv3d:Xn,conv3dTranspose:er,cos:tr,cosh:nr,cumprod:rr,cumsum:sr,denseBincount:ar,depthToSpace:or,depthwiseConv2d:ir,diag:ur,dilation2d:pr,div:cr,divNoNan:yr,dot:gr,einsum:br,elu:xr,equal:dr,erf:Nr,euclideanNorm:Or,exp:Mr,expandDims:Cr,expm1:Fr,eye:zr,fill:Rr,floor:Lr,floorDiv:lr,gather:Br,greater:Pr,greaterEqual:Kr,imag:qr,isFinite:Ur,isInf:Wr,isNaN:Hr,leakyRelu:jr,less:Gr,lessEqual:Zr,linspace:function(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return Ut.runKernel("LinSpace",{},r)},localResponseNormalization:Qr,log:Yr,log1p:Xr,logSigmoid:ns,logSoftmax:ss,logSumExp:as,logicalAnd:os,logicalNot:is,logicalOr:us,logicalXor:ps,lowerBound:function(e,t){return ls(e,t,"left")},matMul:Sn,max:kr,maxPool:cs,maxPool3d:hs,maxPoolWithArgmax:ds,maximum:ms,mean:fs,meshgrid:function(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Zt(e,"x","meshgrid",e instanceof Dt?e.dtype:"float32");if(void 0===t)return[r];let s=Zt(t,"y","meshgrid",t instanceof Dt?t.dtype:"float32");const a=me(r.shape),o=me(s.shape);return"xy"===n?(r=wn(r,[1,-1]),s=wn(s,[-1,1]),[Sn(gs([o,1],r.dtype),r),Sn(s,gs([1,a],s.dtype))]):(r=wn(r,[-1,1]),s=wn(s,[1,-1]),[Sn(r,gs([1,o],r.dtype)),Sn(gs([a,1],s.dtype),s)])},min:Tr,minimum:bs,mirrorPad:xs,mod:Ns,moments:ws,mul:En,multiRNNCell:ks,multinomial:Ts,neg:es,notEqual:vs,oneHot:_s,ones:gs,onesLike:Ss,outerProduct:Es,pad:$s,pad1d:Is,pad2d:Ds,pad3d:As,pad4d:Os,pool:Cs,pow:vr,prelu:Fs,print:function(e,t=!1){console.log(e.toString(t))},prod:Vs,rand:zs,randomGamma:Js,randomNormal:ea,randomStandardNormal:ta,randomUniform:na,range:ra,real:sa,reciprocal:aa,relu:oa,relu6:ia,reshape:wn,reverse:ua,reverse1d:pa,reverse2d:la,reverse3d:ca,reverse4d:ha,round:da,rsqrt:ma,scalar:Sr,selu:fa,separableConv2d:ya,setdiff1dAsync:ga,sigmoid:$n,sign:ba,sin:xa,sinh:Na,slice:In,slice1d:wa,slice2d:ka,slice3d:Ta,slice4d:va,softmax:_a,softplus:ts,spaceToBatchND:Ms,fft:Sa,ifft:Ea,irfft:$a,rfft:Da,split:Ia,sqrt:Er,square:$r,squaredDifference:Aa,squeeze:Oa,stack:Ma,step:Ca,stridedSlice:Fa,sub:rs,sum:Ir,tan:Va,tanh:Dn,tensor:za,tensor1d:Ra,tensor2d:La,tensor3d:function(e,t,n){if(he(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Ht(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return _r(e,t,r,n)},tensor4d:function(e,t,n){if(he(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Ht(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return _r(e,t,r,n)},tensor5d:function(e,t,n){if(he(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Ht(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return _r(e,t,r,n)},tensor6d:function(e,t,n){if(he(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Ht(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return _r(e,t=t||r,r,n)},tile:Vr,topk:Ba,truncatedNormal:Pa,unique:Ka,unsortedSegmentSum:qa,unstack:Ua,upperBound:function(e,t){return ls(e,t,"right")},variable:function(e,t=!0,n,r){return Ut.makeVariable(e,t,n,r)},where:mr,whereAsync:Wa,zeros:ys,zerosLike:fr,op:Yt,OP_SCOPE_SUFFIX:"__op",booleanMaskAsync:Ha,transpose:ja,norm:Ar,movingAverage:Ga,scatterND:Qa,searchSorted:ls,sparseToDense:Ya,gatherND:Xa,dropout:Ja,enclosingPowerOfTwo:eo,cosineWindow:to,inTopKAsync:no,image:{flipLeftRight:xo,grayscaleToRGB:No,resizeNearestNeighbor:Vo,resizeBilinear:Fo,rotateWithOffset:wo,cropAndResize:bo,nonMaxSuppression:To,nonMaxSuppressionAsync:Do,nonMaxSuppressionWithScore:Ao,nonMaxSuppressionWithScoreAsync:Oo,nonMaxSuppressionPadded:Mo,nonMaxSuppressionPaddedAsync:Co,threshold:zo,transform:Ro},linalg:{bandPart:Lo,gramSchmidt:Bo,qr:Ko},losses:{absoluteDifference:Wo,computeWeightedLoss:Uo,cosineDistance:Ho,hingeLoss:jo,huberLoss:Go,logLoss:Zo,meanSquaredError:Qo,sigmoidCrossEntropy:Yo,softmaxCrossEntropy:Xo},spectral:{fft:Sa,ifft:Ea,rfft:Da,irfft:$a},fused:ho,signal:{hammingWindow:mo,hannWindow:fo,frame:yo,stft:go},sparse:{sparseFillEmptyRows:Jo,sparseReshape:ei,sparseSegmentMean:ti,sparseSegmentSum:ni},string:{stringNGrams:ri,stringSplit:si,stringToHashBucketFast:ai}};function ii(e,t,r=""){if("number"!=typeof e&&"number"!=typeof t){n.assert(e.length===t.length,(()=>r+` Shapes ${e} and ${t} must match`));for(let s=0;s<e.length;s++){const a=e[s],o=t[s];n.assert(a<0||o<0||a===o,(()=>r+` Shapes ${e} and ${t} must match`))}}}function ui(e){return"number"!=typeof e&&!e.some((e=>e<0))}function pi(e,t,n){let r=li(e,n);const s=!ui(r);if(s&&0===t.length)throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${r}`);if(s&&t.forEach((e=>{r=li(e.shape,r)})),!ui(r))throw new Error(`Non-fully-defined elementShape: ${r}`);return r}function li(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let r=0;r<e.length;++r){const s=e[r],a=t[r];if(s>=0&&a>=0&&s!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[r]=s>=0?s:a}return n}class ci{constructor(e,t,n,r,o,i,u){this.name=e,this.dtype=t,this.maxSize=n,this.elementShape=r,this.identicalElementShapes=o,this.dynamicSize=i,this.clearAfterRead=u,this.tensors=[],this.closed_=!1,this.idTensor=s(0),a(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()})),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map((e=>this.read(e)))}write(e,t){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const n=this.tensors[e]||{};if(t.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${t.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=t.shape),ii(this.elementShape,t.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),n.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(n.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);n.tensor=t,a(t),n.written=!0,this.tensors[e]=n}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach(((e,n)=>this.write(e,t[n])))}gather(e,t){if(t&&t!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${t}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return o([],[0].concat(this.elementShape));const n=this.readMany(e);return ii(this.elementShape,n[0].shape,"TensorArray shape mismatch: "),i(n,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return o([],[0].concat(this.elementShape));const t=[];for(let e=0;e<this.size();e++)t.push(e);const n=this.readMany(t);return ii(this.elementShape,n[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${n[0].shape})`),u(n,0)}scatter(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);if(e.length!==t.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${t.shape[0]}`);const n=Math.max(...e);if(!this.dynamicSize&&n>=this.maxSize)throw new Error(`Max index must be < array size (${n}  vs. ${this.maxSize})`);this.writeMany(e,p(t,0))}split(e,t){if(t.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${t.dtype}`);let n=0;const r=e.map((e=>(n+=e,n)));if(n!==t.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${n}, and tensor's shape is: ${t.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const s=0===n?0:t.size/n,a=[];l((()=>{t=c(t,[1,n,s]);for(let n=0;n<e.length;++n){const o=[0,0===n?0:r[n-1],0],i=[1,e[n],s];a[n]=c(h(t,o,i),this.elementShape)}return a}));const o=[];for(let t=0;t<e.length;t++)o[t]=t;this.writeMany(o,a)}}class hi{constructor(e,t,n,r=-1){this.tensors=e,this.elementShape=t,this.elementDtype=n,null!=e&&e.forEach((e=>{if(n!==e.dtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${e.dtype}`);ii(t,e.shape,"TensorList shape mismatch: "),a(e)})),this.idTensor=s(0),this.maxNumElements=r,a(this.idTensor)}get id(){return this.idTensor.id}copy(){return new hi([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.id)||t.dispose()})),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,t,n=-1){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(-1!==n&&this.tensors.length!==n)throw new Error(`Operation expected a list with ${n} elements but got a list with ${this.tensors.length} elements.`);ii(e,this.elementShape,"TensorList shape mismatch: ");const r=pi(this.elementShape,this.tensors,e);return l((()=>{const e=this.tensors.map((e=>c(e,r)));return i(e,0)}))}popBack(e,t){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const n=pi(this.elementShape,this.tensors,e),r=this.tensors.pop();return ii(r.shape,e,"TensorList shape mismatch: "),c(r,n)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(ii(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");a(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);const t=new hi([],this.elementShape,this.elementDtype,this.maxNumElements);t.tensors.length=e;for(let n=0;n<Math.min(this.tensors.length,e);++n)t.tensors[n]=this.tensors[n];return t}getItem(e,t,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);ii(this.tensors[e].shape,t,"TensorList shape mismatch: ");const r=pi(this.elementShape,this.tensors,t);return c(this.tensors[e],r)}setItem(e,t){if(t.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);ii(this.elementShape,t.shape,"TensorList shape mismatch: "),a(t),this.tensors[e]=t}gather(e,t,n){if(t!==this.elementDtype)throw new Error(`Invalid data types; op elements ${t}, but list elements ${this.elementDtype}`);ii(this.elementShape,n,"TensorList shape mismatch: "),e=e.slice(0,this.size());const r=pi(this.elementShape,this.tensors,n);return 0===e.length?o([],[0].concat(r)):l((()=>{const t=e.map((e=>c(this.tensors[e],r)));return i(t,0)}))}concat(e,t){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);ii(this.elementShape,t,"TensorList shape mismatch: ");const n=pi(this.elementShape,this.tensors,t);return 0===this.size()?o([],[0].concat(n)):l((()=>{const e=this.tensors.map((e=>c(e,n)));return u(e,0)}))}}const di=async(e,t,n)=>{switch(e.op){case"If":case"StatelessIf":{const r=w("thenBranch",e,t,n),s=w("elseBranch",e,t,n),a=w("cond",e,t,n),o=w("args",e,t,n);return(await a.data())[0]?n.functionMap[r].executeFunctionAsync(o,n.tensorArrayMap,n.tensorListMap):n.functionMap[s].executeFunctionAsync(o,n.tensorArrayMap,n.tensorListMap)}case"While":case"StatelessWhile":{const r=w("body",e,t,n),s=w("cond",e,t,n),a=w("args",e,t,n),o=await n.functionMap[s].executeFunctionAsync(a,n.tensorArrayMap,n.tensorListMap),i=a.map((e=>e.id));let u=await o[0].data();o.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||e.dispose()}));let p=a;for(;u[0];){const e=p;p=await n.functionMap[r].executeFunctionAsync(p,n.tensorArrayMap,n.tensorListMap);const t=p.map((e=>e.id));e.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}));const a=await n.functionMap[s].executeFunctionAsync(p,n.tensorArrayMap,n.tensorListMap);u=await a[0].data(),a.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||-1!==t.indexOf(e.id)||e.dispose()}))}return p}case"LoopCond":return[E(w("pred",e,t,n))];case"Switch":{const r=w("pred",e,t,n);let s=w("data",e,t,n);return s.kept||(s=E(s)),(await r.data())[0]?[void 0,s]:[s,void 0]}case"Merge":{const r=e.inputNames.find((e=>void 0!==k(e,t,n)));if(r){return[E(k(r,t,n))]}return}case"Enter":{const r=w("frameName",e,t,n),s=w("tensor",e,t,n);return n.enterFrame(r),[E(s)]}case"Exit":{const r=w("tensor",e,t,n);return n.exitFrame(),[E(r)]}case"NextIteration":{const r=w("tensor",e,t,n);return n.nextIteration(),[E(r)]}case"TensorArrayV3":{const r=w("size",e,t,n),a=w("dtype",e,t,n),o=w("elementShape",e,t,n),i=w("dynamicSize",e,t,n),u=w("clearAfterRead",e,t,n),p=w("identicalElementShapes",e,t,n),l=w("name",e,t,n),c=new ci(l,a,r,o,p,i,u);return n.addTensorArray(c),[c.idTensor,s(1)]}case"TensorArrayWriteV3":{const r=w("tensorArrayId",e,t,n),s=w("index",e,t,n),a=w("tensor",e,t,n),o=n.getTensorArray(r.id);return o.write(s,a),[o.idTensor]}case"TensorArrayReadV3":{const r=w("tensorArrayId",e,t,n),s=w("index",e,t,n);return[n.getTensorArray(r.id).read(s)]}case"TensorArrayGatherV3":{const r=w("tensorArrayId",e,t,n),s=w("indices",e,t,n),a=w("dtype",e,t,n);return[n.getTensorArray(r.id).gather(s,a)]}case"TensorArrayScatterV3":{const r=w("tensorArrayId",e,t,n),s=w("indices",e,t,n),a=w("tensor",e,t,n),o=n.getTensorArray(r.id);return o.scatter(s,a),[o.idTensor]}case"TensorArrayConcatV3":{const r=w("tensorArrayId",e,t,n),s=n.getTensorArray(r.id),a=w("dtype",e,t,n);return[s.concat(a)]}case"TensorArraySplitV3":{const r=w("tensorArrayId",e,t,n),s=w("tensor",e,t,n),a=w("lengths",e,t,n),o=n.getTensorArray(r.id);return o.split(a,s),[o.idTensor]}case"TensorArraySizeV3":{const r=w("tensorArrayId",e,t,n),a=n.getTensorArray(r.id);return[s(a.size(),"int32")]}case"TensorArrayCloseV3":{const r=w("tensorArrayId",e,t,n),s=n.getTensorArray(r.id);return s.clearAndClose(),[s.idTensor]}case"TensorListSetItem":{const r=w("tensorListId",e,t,n),s=w("index",e,t,n),a=w("tensor",e,t,n),o=n.getTensorList(r.id);return o.setItem(s,a),[o.idTensor]}case"TensorListGetItem":{const r=w("tensorListId",e,t,n),s=w("index",e,t,n),a=w("elementShape",e,t,n),o=w("elementDType",e,t,n);return[n.getTensorList(r.id).getItem(s,a,o)]}case"TensorListScatterV2":case"TensorListScatter":{const r=w("indices",e,t,n),s=function(e,t,n,r){if(t.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${t.length} vs. ${e.shape[0]}`);const s=Math.max(...t);if(null!=r&&-1!==r&&s>=r)throw new Error(`Max index must be < array size (${s}  vs. ${r})`);const a=new hi([],n,e.dtype,r),o=p(e,0);return t.forEach(((e,t)=>{a.setItem(e,o[t])})),a}(w("tensor",e,t,n),r,w("elementShape",e,t,n),w("numElements",e,t,n));return n.addTensorList(s),[s.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const r=w("elementShape",e,t,n),s=w("elementDType",e,t,n);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const o=w(a,e,t,n),i=function(e,t,n,r){return new hi([],e,t,r)}(r,s,0,"TensorListReserve"===e.op?-1:o);return n.addTensorList(i),[i.idTensor]}case"TensorListGather":{const r=w("tensorListId",e,t,n),s=w("indices",e,t,n),a=w("elementShape",e,t,n),o=w("elementDType",e,t,n);return[n.getTensorList(r.id).gather(s,o,a)]}case"TensorListStack":{const r=w("tensorListId",e,t,n),s=w("elementShape",e,t,n),a=w("elementDType",e,t,n),o=w("numElements",e,t,n);return[n.getTensorList(r.id).stack(s,a,o)]}case"TensorListFromTensor":{const r=function(e,t,n){const r=e.dtype;if(e.shape.length<1)throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);if(e.dtype!==n)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${n}`);ii(e.shape.slice(1),t,"TensorList shape mismatch: ");const s=p(e);return new hi(s,t,r)}(w("tensor",e,t,n),w("elementShape",e,t,n),w("elementDType",e,t,n));return n.addTensorList(r),[r.idTensor]}case"TensorListConcat":case"TensorListConcatV2":{const r=w("tensorListId",e,t,n),s=n.getTensorList(r.id),a=w("dtype",e,t,n),o=w("elementShape",e,t,n);return[s.concat(a,o)]}case"TensorListPushBack":{const r=w("tensorListId",e,t,n),s=w("tensor",e,t,n),a=n.getTensorList(r.id);return a.pushBack(s),[a.idTensor]}case"TensorListPopBack":{const r=w("tensorListId",e,t,n),s=w("elementShape",e,t,n),a=w("elementDType",e,t,n);return[n.getTensorList(r.id).popBack(s,a)]}case"TensorListSplit":{const r=w("tensor",e,t,n),s=w("elementShape",e,t,n),a=function(e,t,n){let r=0;const s=t.map((e=>(r+=e,r)));if(r!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${r}, and tensor's shape is: ${e.shape}`);const a=li(e.shape.slice(1),n),o=0===r?0:e.size/r,i=l((()=>{const n=[];e=c(e,[1,r,o]);for(let r=0;r<t.length;++r){const i=[0,0===r?0:s[r-1],0],u=[1,t[r],o];n[r]=c(h(e,i,u),a)}return e.dispose(),n})),u=new hi([],n,e.dtype,t.length);for(let e=0;e<i.length;e++)u.setItem(e,i[e]);return u}(r,w("lengths",e,t,n),s);return n.addTensorList(a),[a.idTensor]}case"TensorListLength":{const r=w("tensorListId",e,t,n),a=n.getTensorList(r.id);return[s(a.size(),"int32")]}case"TensorListResize":{const r=w("tensorListId",e,t,n),s=w("size",e,t,n),a=n.getTensorList(r.id).resize(s);return n.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function mi(e,t,n){const[r,s]=w("fusedOps",e,t,n),a="biasadd"===r,o=!a,i="prelu"===s,u="fusedbatchnorm"===r,p=w("numArgs",e,t,n);if(a){if(i&&2!==p)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&a&&1!==p)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(u)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");const l=w("strides",e,t,n),c=S(e,t,n),h=w("dataFormat",e,t,n).toUpperCase(),d=w("dilations",e,t,n);let[m,f]=w("args",e,t,n);o&&(f=m,m=void 0);return{stride:l,pad:c,dataFormat:h,dilations:d,biasArg:m,preluArg:f,activationFunc:s,leakyreluAlpha:w("leakyreluAlpha",e,t,n)}}function fi(e,t,n){return{boxes:w("boxes",e,t,n),scores:w("scores",e,t,n),maxOutputSize:w("maxOutputSize",e,t,n),iouThreshold:w("iouThreshold",e,t,n),scoreThreshold:w("scoreThreshold",e,t,n),softNmsSigma:w("softNmsSigma",e,t,n)}}class yi{constructor(e,t){this.keyDType=e,this.valueDType=t,this.handle=s(0),this.tensorMap=new Map,a(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}tensorSize(){return Sr(this.size(),"int32")}async import(e,t){this.checkKeyAndValueTensor(e,t);const r=await e.data();return this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),l((()=>{const e=p(t),s=r.length,o=e.length;n.assert(s===o,(()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${o} elements.`));for(let t=0;t<s;t++){const n=r[t],s=e[t];a(s),this.tensorMap.set(n,s)}return this.handle}))}async find(e,t){this.checkKeyAndValueTensor(e,t);const n=await e.data();return l((()=>{const e=[];for(let r=0;r<n.length;r++){const s=n[r],a=this.findWithDefault(s,t);e.push(a)}return i(e)}))}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`)}}function gi(t,r,s,a,o=e.tidy){const i=((e,t,r)=>{switch(e.category){case"arithmetic":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[r.add(w("a",e,t,n),w("b",e,t,n))];case"AddN":return[r.addN(w("tensors",e,t,n))];case"FloorMod":case"Mod":return[r.mod(w("a",e,t,n),w("b",e,t,n))];case"Mul":return[r.mul(w("a",e,t,n),w("b",e,t,n))];case"RealDiv":case"Div":return[r.div(w("a",e,t,n),w("b",e,t,n))];case"DivNoNan":return[r.divNoNan(w("a",e,t,n),w("b",e,t,n))];case"FloorDiv":return[r.floorDiv(w("a",e,t,n),w("b",e,t,n))];case"Sub":return[r.sub(w("a",e,t,n),w("b",e,t,n))];case"Minimum":return[r.minimum(w("a",e,t,n),w("b",e,t,n))];case"Maximum":return[r.maximum(w("a",e,t,n),w("b",e,t,n))];case"Pow":return[r.pow(w("a",e,t,n),w("b",e,t,n))];case"SquaredDifference":return[r.squaredDifference(w("a",e,t,n),w("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"basic_math":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Abs":case"ComplexAbs":return[r.abs(w("x",e,t,n))];case"Acos":return[r.acos(w("x",e,t,n))];case"Acosh":return[r.acosh(w("x",e,t,n))];case"Asin":return[r.asin(w("x",e,t,n))];case"Asinh":return[r.asinh(w("x",e,t,n))];case"Atan":return[r.atan(w("x",e,t,n))];case"Atan2":return[r.atan2(w("x",e,t,n),w("y",e,t,n))];case"Atanh":return[r.atanh(w("x",e,t,n))];case"Ceil":return[r.ceil(w("x",e,t,n))];case"Complex":return[r.complex(w("real",e,t,n),w("imag",e,t,n))];case"Cos":return[r.cos(w("x",e,t,n))];case"Cosh":return[r.cosh(w("x",e,t,n))];case"Elu":return[r.elu(w("x",e,t,n))];case"Erf":return[r.erf(w("x",e,t,n))];case"Exp":return[r.exp(w("x",e,t,n))];case"Expm1":return[r.expm1(w("x",e,t,n))];case"Floor":return[r.floor(w("x",e,t,n))];case"Log":return[r.log(w("x",e,t,n))];case"Log1p":return[r.log1p(w("x",e,t,n))];case"Imag":return[r.imag(w("x",e,t,n))];case"Neg":return[r.neg(w("x",e,t,n))];case"Reciprocal":return[r.reciprocal(w("x",e,t,n))];case"Real":return[r.real(w("x",e,t,n))];case"Relu":return[r.relu(w("x",e,t,n))];case"Round":return[r.round(w("x",e,t,n))];case"Selu":return[r.selu(w("x",e,t,n))];case"Sigmoid":return[r.sigmoid(w("x",e,t,n))];case"Sin":return[r.sin(w("x",e,t,n))];case"Sign":return[r.sign(w("x",e,t,n))];case"Sinh":return[r.sinh(w("x",e,t,n))];case"Softplus":return[r.softplus(w("x",e,t,n))];case"Sqrt":return[r.sqrt(w("x",e,t,n))];case"Square":return[r.square(w("x",e,t,n))];case"Tanh":return[r.tanh(w("x",e,t,n))];case"Tan":return[r.tan(w("x",e,t,n))];case"ClipByValue":return[r.clipByValue(w("x",e,t,n),w("clipValueMin",e,t,n),w("clipValueMax",e,t,n))];case"Relu6":return[r.relu6(w("x",e,t,n))];case"Rsqrt":return[r.rsqrt(k(e.inputNames[0],t,n))];case"Prod":return[r.prod(w("x",e,t,n),w("axes",e,t,n))];case"LeakyRelu":return[r.leakyRelu(w("x",e,t,n),w("alpha",e,t,n))];case"Prelu":return[r.prelu(w("x",e,t,n),w("alpha",e,t,n))];case"IsNan":return[r.isNaN(k(e.inputNames[0],t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"control":return di(e,t,r);case"convolution":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Conv1D":{const s=w("stride",e,t,n),a=w("pad",e,t,n),o=w("dataFormat",e,t,n).toUpperCase(),i=w("dilation",e,t,n);return[r.conv1d(w("x",e,t,n),w("filter",e,t,n),s,a,o,i)]}case"Conv2D":{const s=w("strides",e,t,n),a=S(e,t,n),o=w("dataFormat",e,t,n).toUpperCase(),i=w("dilations",e,t,n);return[r.conv2d(w("x",e,t,n),w("filter",e,t,n),[s[1],s[2]],a,o,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:a,dataFormat:o,dilations:i,biasArg:u,preluArg:p,activationFunc:l,leakyreluAlpha:c}=mi(e,t,n);return[r.fused.conv2d({x:w("x",e,t,n),filter:w("filter",e,t,n),strides:[s[1],s[2]],pad:a,dataFormat:o,dilations:[i[1],i[2]],bias:u,activation:l,preluActivationWeights:p,leakyreluAlpha:c})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:a,dataFormat:o,dilations:i,biasArg:u,preluArg:p,activationFunc:l,leakyreluAlpha:c}=mi(e,t,n);return[r.fused.depthwiseConv2d({x:w("x",e,t,n),filter:w("filter",e,t,n),strides:[s[1],s[2]],pad:a,dataFormat:o,dilations:[i[1],i[2]],bias:u,activation:l,preluActivationWeights:p,leakyreluAlpha:c})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=w("outputShape",e,t,n),a=w("strides",e,t,n),o=S(e,t,n);return[r.conv2dTranspose(w("x",e,t,n),w("filter",e,t,n),s,[a[1],a[2]],o)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=w("strides",e,t,n),a=S(e,t,n),o=w("dilations",e,t,n),i=w("dataFormat",e,t,n).toUpperCase();return[r.depthwiseConv2d(w("input",e,t,n),w("filter",e,t,n),[s[1],s[2]],a,i,[o[1],o[2]])]}case"Conv3D":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("dataFormat",e,t,n).toUpperCase(),i=w("dilations",e,t,n);return[r.conv3d(w("x",e,t,n),w("filter",e,t,n),[s[1],s[2],s[3]],a,o,[i[1],i[2],i[3]])]}case"AvgPool":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("kernelSize",e,t,n);return[r.avgPool(w("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a)]}case"MaxPool":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("kernelSize",e,t,n);return[r.maxPool(w("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a)]}case"MaxPoolWithArgmax":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("kernelSize",e,t,n),i=w("includeBatchInIndex",e,t,n),{result:u,indexes:p}=r.maxPoolWithArgmax(w("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a,i);return[u,p]}case"AvgPool3D":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("kernelSize",e,t,n);return[r.avgPool3d(w("x",e,t,n),[o[1],o[2],o[3]],[s[1],s[2],s[3]],a)]}case"MaxPool3D":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("kernelSize",e,t,n);return[r.maxPool3d(w("x",e,t,n),[o[1],o[2],o[3]],[s[1],s[2],s[3]],a)]}case"Dilation2D":{const s=w("strides",e,t,n),a=w("pad",e,t,n),o=w("dilations",e,t,n),i=s[1],u=s[2],p=o[1],l=o[2];return[r.dilation2d(w("x",e,t,n),w("filter",e,t,n),[i,u],a,[p,l],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"creation":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Fill":{const s=w("shape",e,t,n),a=w("dtype",e,t,n),o=w("value",e,t,n);return[r.fill(s,o,a)]}case"LinSpace":{const s=w("start",e,t,n),a=w("stop",e,t,n),o=w("num",e,t,n);return[r.linspace(s,a,o)]}case"Multinomial":{const s=w("logits",e,t,n),a=w("numSamples",e,t,n),o=w("seed",e,t,n);return[r.multinomial(s,a,o)]}case"OneHot":{const s=w("indices",e,t,n),a=w("depth",e,t,n),o=w("onValue",e,t,n),i=w("offValue",e,t,n);return[r.oneHot(s,a,o,i)]}case"Ones":return[r.ones(w("shape",e,t,n),w("dtype",e,t,n))];case"OnesLike":return[r.onesLike(w("x",e,t,n))];case"RandomStandardNormal":return[r.randomStandardNormal(w("shape",e,t,n),w("dtype",e,t,n),w("seed",e,t,n))];case"RandomUniform":return[r.randomUniform(w("shape",e,t,n),w("minval",e,t,n),w("maxval",e,t,n),w("dtype",e,t,n))];case"Range":{const s=w("start",e,t,n),a=w("stop",e,t,n),o=w("step",e,t,n);return[r.range(s,a,o,w("dtype",e,t,n))]}case"TruncatedNormal":{const s=w("shape",e,t,n),a=w("mean",e,t,n),o=w("stdDev",e,t,n),i=w("seed",e,t,n);return[r.truncatedNormal(s,a,o,w("dtype",e,t,n),i)]}case"Zeros":return[r.zeros(w("shape",e,t,n),w("dtype",e,t,n))];case"ZerosLike":return[r.zerosLike(w("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"dynamic":return(async(e,t,n,r,s=oi)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:u,softNmsSigma:p}=fi(e,t,n),l=await s.image.nonMaxSuppressionWithScoreAsync(r,a,o,i,u,p);return[l.selectedIndices,l.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:u}=fi(e,t,n),p=w("padToMaxOutputSize",e,t,n),l=await s.image.nonMaxSuppressionPaddedAsync(r,a,o,i,u,p);return[l.selectedIndices,l.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:u}=fi(e,t,n);return[await s.image.nonMaxSuppressionAsync(r,a,o,i,u)]}case"Where":{const r=s.cast(w("condition",e,t,n),"bool"),a=[await s.whereAsync(r)];return r.dispose(),a}case"ListDiff":return s.setdiff1dAsync(w("x",e,t,n),w("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r);case"evaluation":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"LowerBound":{const s=w("sortedSequence",e,t,n),a=w("values",e,t,n);return[r.lowerBound(s,a)]}case"TopKV2":{const s=w("x",e,t,n),a=w("k",e,t,n),o=w("sorted",e,t,n),i=r.topk(s,a,o);return[i.values,i.indices]}case"UpperBound":{const s=w("sortedSequence",e,t,n),a=w("values",e,t,n);return[r.upperBound(s,a)]}case"Unique":{const s=w("x",e,t,n),a=r.unique(s);return[a.values,a.indices]}case"UniqueV2":{const s=w("x",e,t,n),a=w("axis",e,t,n),o=r.unique(s,a);return[o.values,o.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"image":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"ResizeBilinear":{const s=w("images",e,t,n),a=w("size",e,t,n),o=w("alignCorners",e,t,n),i=w("halfPixelCenters",e,t,n);return[r.image.resizeBilinear(s,[a[0],a[1]],o,i)]}case"ResizeNearestNeighbor":{const s=w("images",e,t,n),a=w("size",e,t,n),o=w("alignCorners",e,t,n),i=w("halfPixelCenters",e,t,n);return[r.image.resizeNearestNeighbor(s,[a[0],a[1]],o,i)]}case"CropAndResize":{const s=w("image",e,t,n),a=w("boxes",e,t,n),o=w("boxInd",e,t,n),i=w("cropSize",e,t,n),u=w("method",e,t,n),p=w("extrapolationValue",e,t,n);return[r.image.cropAndResize(s,a,o,i,u,p)]}case"ImageProjectiveTransformV3":{const s=w("images",e,t,n),a=w("transforms",e,t,n),o=w("outputShape",e,t,n),i=w("fillValue",e,t,n),u=w("interpolation",e,t,n),p=w("fillMode",e,t,n);return[r.image.transform(s,a,u.toLowerCase(),p.toLowerCase(),i,o)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"graph":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const s=w("default",e,t,n);return[k(e.name,t,n)||s];case"Placeholder":return[k(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":case"Snapshot":return[E(w("x",e,t,n))];case"IdentityN":return w("x",e,t,n).map((e=>E(e)));case"Shape":return[r.tensor1d(w("x",e,t,n).shape,"int32")];case"ShapeN":return w("x",e,t,n).map((e=>r.tensor1d(e.shape)));case"Size":return[r.scalar(w("x",e,t,n).size,"int32")];case"Rank":return[r.scalar(w("x",e,t,n).rank,"int32")];case"NoOp":return[r.scalar(1)];case"Print":const a=w("x",e,t,n),o=w("data",e,t,n),i=w("message",e,t,n),u=w("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let e=0;e<o.length;e++)console.log(Array.prototype.slice.call(o[e].dataSync()).slice(0,u));return[a];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"logical":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Equal":return[r.equal(w("a",e,t,n),w("b",e,t,n))];case"NotEqual":return[r.notEqual(w("a",e,t,n),w("b",e,t,n))];case"Greater":return[r.greater(w("a",e,t,n),w("b",e,t,n))];case"GreaterEqual":return[r.greaterEqual(w("a",e,t,n),w("b",e,t,n))];case"Less":return[r.less(w("a",e,t,n),w("b",e,t,n))];case"LessEqual":return[r.lessEqual(w("a",e,t,n),w("b",e,t,n))];case"LogicalAnd":return[r.logicalAnd(w("a",e,t,n),w("b",e,t,n))];case"LogicalNot":return[r.logicalNot(w("a",e,t,n))];case"LogicalOr":return[r.logicalOr(w("a",e,t,n),w("b",e,t,n))];case"Select":case"SelectV2":return[r.where(w("condition",e,t,n),w("a",e,t,n),w("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"matrices":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[r.matMul(w("a",e,t,n),w("b",e,t,n),w("transposeA",e,t,n),w("transposeB",e,t,n))];case"Einsum":return[r.einsum(w("equation",e,t,n),...w("tensors",e,t,n))];case"Transpose":return[r.transpose(w("x",e,t,n),w("perm",e,t,n))];case"_FusedMatMul":const[s,a]=w("fusedOps",e,t,n),o="biasadd"===s,i="prelu"===a,u=w("numArgs",e,t,n),p=w("leakyreluAlpha",e,t,n);if(o){if(i&&2!==u)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==u)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[l,c]=w("args",e,t,n);return[r.fused.matMul({a:w("a",e,t,n),b:w("b",e,t,n),transposeA:w("transposeA",e,t,n),transposeB:w("transposeB",e,t,n),bias:l,activation:a,preluActivationWeights:c,leakyreluAlpha:p})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"normalization":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"EuclideanNorm":return[r.euclideanNorm(w("x",e,t,n),w("axis",e,t,n),w("keepDims",e,t,n))];case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[r.batchNorm(w("x",e,t,n),w("mean",e,t,n),w("variance",e,t,n),w("offset",e,t,n),w("scale",e,t,n),w("epsilon",e,t,n))];case"LRN":return[r.localResponseNormalization(w("x",e,t,n),w("radius",e,t,n),w("bias",e,t,n),w("alpha",e,t,n),w("beta",e,t,n))];case"Softmax":return[r.softmax(w("x",e,t,n))];case"LogSoftmax":return[r.logSoftmax(w("x",e,t,n))];case"SparseToDense":return[r.sparseToDense(w("sparseIndices",e,t,n),w("outputShape",e,t,n),w("sparseValues",e,t,n),w("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"reduction":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Max":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.max(w("x",e,t,n),s,a)]}case"Mean":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.mean(w("x",e,t,n),s,a)]}case"Min":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.min(w("x",e,t,n),s,a)]}case"Sum":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.sum(w("x",e,t,n),s,a)]}case"All":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.all(w("x",e,t,n),s,a)]}case"Any":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.any(w("x",e,t,n),s,a)]}case"ArgMax":{const s=w("axis",e,t,n);return[r.argMax(w("x",e,t,n),s)]}case"ArgMin":{const s=w("axis",e,t,n);return[r.argMin(w("x",e,t,n),s)]}case"Prod":{const s=w("axis",e,t,n),a=w("keepDims",e,t,n);return[r.prod(w("x",e,t,n),s,a)]}case"Cumprod":{const s=w("axis",e,t,n),a=w("exclusive",e,t,n),o=w("reverse",e,t,n);return[r.cumprod(w("x",e,t,n),s,a,o)]}case"Cumsum":{const s=w("axis",e,t,n),a=w("exclusive",e,t,n),o=w("reverse",e,t,n);return[r.cumsum(w("x",e,t,n),s,a,o)]}case"Bincount":const s=w("x",e,t,n),a=w("weights",e,t,n),o=w("size",e,t,n);return[r.bincount(s,a,o)];case"DenseBincount":{const s=w("x",e,t,n),a=w("weights",e,t,n),o=w("size",e,t,n),i=w("binaryOutput",e,t,n);return[r.denseBincount(s,a,o,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"slice_join":return o((()=>((e,t,r,s=oi)=>{switch(e.op){case"ConcatV2":case"Concat":{const n=w("n",e,t,r),a=w("axis",e,t,r);let o=w("tensors",e,t,r);return o=o.slice(0,n),[s.concat(o,a)]}case"Gather":{const n=w("x",e,t,r),a=w("indices",e,t,r);return[s.gather(n,s.cast(a,"int32"),0)]}case"GatherV2":{const n=w("axis",e,t,r),a=w("batchDims",e,t,r),o=w("x",e,t,r),i=w("indices",e,t,r);return[s.gather(o,s.cast(i,"int32"),n,a)]}case"Reverse":{const n=w("dims",e,t,r),a=[];for(let e=0;e<n.length;e++)n[e]&&a.push(e);const o=w("x",e,t,r);return[s.reverse(o,a)]}case"ReverseV2":{const n=w("axis",e,t,r),a=w("x",e,t,r);return[s.reverse(a,n)]}case"Slice":{const n=w("begin",e,t,r),a=w("size",e,t,r);return[s.slice(w("x",e,t,r),n,a)]}case"StridedSlice":{const n=w("begin",e,t,r),a=w("end",e,t,r),o=w("strides",e,t,r),i=w("beginMask",e,t,r),u=w("endMask",e,t,r),p=w("ellipsisMask",e,t,r),l=w("newAxisMask",e,t,r),c=w("shrinkAxisMask",e,t,r),h=w("x",e,t,r);return[s.stridedSlice(h,n,a,o,i,u,p,l,c)]}case"Pack":return l((()=>{const a=w("axis",e,t,r),o=w("tensors",e,t,r),i=o[0].shape,u=s.squeeze(o[0]).shape,p=o.map((e=>{const t=n.arraysEqual(e.shape,i);if(!t&&!n.arraysEqual(s.squeeze(e).shape,u))throw new Error("the input tensors shape does not match");return t?e:s.reshape(e,i)}));return[s.stack(p,a)]}));case"Unpack":{const n=w("axis",e,t,r),a=w("tensor",e,t,r);return s.unstack(a,n)}case"Tile":{const n=w("reps",e,t,r);return[s.tile(w("x",e,t,r),n)]}case"Split":case"SplitV":{const n=w("axis",e,t,r),a=w("numOrSizeSplits",e,t,r),o=w("x",e,t,r);return s.split(o,a,n)}case"ScatterNd":{const n=w("indices",e,t,r),a=w("values",e,t,r),o=w("shape",e,t,r);return[s.scatterND(n,a,o)]}case"GatherNd":{const n=w("x",e,t,r),a=w("indices",e,t,r);return[s.gatherND(n,a)]}case"SparseToDense":{const n=w("sparseIndices",e,t,r),a=w("outputShape",e,t,r),o=w("sparseValues",e,t,r),i=w("defaultValue",e,t,r);return[s.sparseToDense(n,o,a,o.dtype===i.dtype?i:s.cast(i,o.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"sparse":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"SparseFillEmptyRows":{const{outputIndices:s,outputValues:a,emptyRowIndicator:o,reverseIndexMap:i}=r.sparse.sparseFillEmptyRows(w("indices",e,t,n),w("values",e,t,n),w("denseShape",e,t,n),w("defaultValue",e,t,n));return[s,a,o,i]}case"SparseReshape":{const{outputIndices:s,outputShape:a}=r.sparse.sparseReshape(w("inputIndices",e,t,n),w("inputShape",e,t,n),w("newShape",e,t,n));return[s,a]}case"SparseSegmentMean":return[r.sparse.sparseSegmentMean(w("data",e,t,n),w("indices",e,t,n),w("segmentIds",e,t,n))];case"SparseSegmentSum":return[r.sparse.sparseSegmentSum(w("data",e,t,n),w("indices",e,t,n),w("segmentIds",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"spectral":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"FFT":return[r.fft(w("x",e,t,n))];case"IFFT":return[r.ifft(w("x",e,t,n))];case"RFFT":return[r.rfft(w("x",e,t,n))];case"IRFFT":return[r.irfft(w("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"string":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"StringNGrams":{const{nGrams:s,nGramsSplits:a}=r.string.stringNGrams(w("data",e,t,n),w("dataSplits",e,t,n),w("separator",e,t,n),w("nGramWidths",e,t,n),w("leftPad",e,t,n),w("rightPad",e,t,n),w("padWidth",e,t,n),w("preserveShortSequences",e,t,n));return[s,a]}case"StringSplit":{const{indices:s,values:a,shape:o}=r.string.stringSplit(w("input",e,t,n),w("delimiter",e,t,n),w("skipEmpty",e,t,n));return[s,a,o]}case"StringToHashBucketFast":return[r.string.stringToHashBucketFast(w("input",e,t,n),w("numBuckets",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"transformation":return o((()=>((e,t,n,r=oi)=>{switch(e.op){case"Cast":return[r.cast(w("x",e,t,n),w("dtype",e,t,n))];case"ExpandDims":{const s=w("axis",e,t,n);return[r.expandDims(w("x",e,t,n),s)]}case"Squeeze":{const s=w("axis",e,t,n);return[r.squeeze(w("x",e,t,n),s)]}case"Reshape":return[r.reshape(w("x",e,t,n),w("shape",e,t,n))];case"MirrorPad":return[r.mirrorPad(w("x",e,t,n),w("padding",e,t,n),w("mode",e,t,n))];case"PadV2":case"Pad":return[r.pad(w("x",e,t,n),w("padding",e,t,n),w("constantValue",e,t,n))];case"SpaceToBatchND":{const s=w("blockShape",e,t,n),a=w("paddings",e,t,n);return[r.spaceToBatchND(w("x",e,t,n),s,a)]}case"BatchToSpaceND":{const s=w("blockShape",e,t,n),a=w("crops",e,t,n);return[r.batchToSpaceND(w("x",e,t,n),s,a)]}case"DepthToSpace":{const s=w("blockSize",e,t,n),a=w("dataFormat",e,t,n).toUpperCase();return[r.depthToSpace(w("x",e,t,n),s,a)]}case"BroadcastTo":return[r.broadcastTo(w("x",e,t,n),w("shape",e,t,n))];case"BroadcastArgs":return[r.broadcastArgs(w("s0",e,t,n),w("s1",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r)));case"hash_table":return(async(e,t,n,r)=>{switch(e.op){case"HashTable":case"HashTableV2":{const s=w("keyDType",e,t,n),a=w("valueDType",e,t,n),o=new yi(s,a);return r.addHashTable(e.name,o),[o.handle]}case"LookupTableImport":case"LookupTableImportV2":{const s=w("tableHandle",e,t,n,r),a=w("keys",e,t,n),o=w("values",e,t,n),i=r.getHashTableById(s.id);return[await i.import(a,o)]}case"LookupTableFind":case"LookupTableFindV2":{const s=w("tableHandle",e,t,n,r),a=w("keys",e,t,n),o=w("defaultValue",e,t,n),i=r.getHashTableById(s.id);return[await i.find(a,o)]}case"LookupTableSize":case"LookupTableSizeV2":{const s=w("tableHandle",e,t,n,r);return[r.getHashTableById(s.id).tensorSize()]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,t,r,a);case"custom":const s=x(e.op);if(s&&s.customExecutor)return s.customExecutor(new ue(e,t,r));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(t,r,s);return e.util.isPromise(i)?i.then((e=>[].concat(e))):[].concat(i)}class bi{constructor(e={},t={},n={},r={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=r,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map((e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`)).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function xi(e,t,n,r){const s=new Set,a=[];let o=null,i=null;const u=new Set,p=Object.keys(e).map((e=>_(e)[0]));let l=[];null!=r&&(l=r.map((e=>_(e.name)[0])));const c=[...t];for(;c.length>0;){const e=c.pop();(Ti(e)||vi(e)||_i(e))&&null==o&&(o=e,i=o.children.map((e=>e.name)).filter((e=>s.has(e)))),s.add(e.name),null==n[e.name]&&(-1===p.indexOf(e.name)&&-1===l.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach((e=>{u.has(e.name)||(u.add(e.name),c.push(e))})):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:s,missingInputs:a,dynamicNode:o,syncInputs:i}}const Ni=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],wi=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],ki=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2","LookupTableSize","LookupTableSizeV2"];function Ti(e){return Ni.indexOf(e.op)>=0}function vi(e){return wi.indexOf(e.op)>=0}function _i(e){return ki.indexOf(e.op)>=0}class Si{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this.intermediateTensors={},this.keepTensorForDebug=!1,this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach((t=>{this._functionExecutorMap[t]=new Si(e.functions[t],this)}))}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map((t=>e[t].map((e=>e.id))));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get outputs(){return this._outputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get inputNodes(){return this._inputs.map((e=>e.signatureKey||e.name))}get outputNodes(){return this._outputs.map((e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t}))}get functions(){return Object.keys(this._functions).reduce(((e,t)=>(e[t]=this._functions[t].signature,e)),{})}getCompilationKey(e,t){const n=e.map((e=>e.name)).sort(),r=t.map((e=>e.name)).sort();return n.join(this.SEPERATOR)+"--"+r.join(this.SEPERATOR)}compile(e,t){const n=xi(e,t,this.weightMap,this._initNodes),{missingInputs:r,dynamicNode:s,syncInputs:a}=n;if(null!=s)throw new Error(`This execution contains the node '${s.name}', which has the dynamic op '${s.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(r.length>0){const n=t.map((e=>e.name)),s=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${s}]. Missing the following inputs: [${r}]`)}return function(e,t,n){const{usedNodes:r,inputs:s}=n,a=[],o=Object.keys(s).map((e=>_(e)[0])).map((t=>e.nodes[t])),i=e.initNodes;o.forEach((e=>{r.has(e.name)&&a.push(e)})),e.weights.forEach((e=>{r.has(e.name)&&a.push(e)})),null!=i&&i.forEach((e=>{r.has(e.name)&&a.push(e)}));const u=new Set,p=[];for(;a.length>0;){const e=a.pop();u.add(e.name),t[e.name]||p.push(e),e.children.forEach((e=>{!u.has(e.name)&&r.has(e.name)&&e.inputs.every((e=>u.has(e.name)))&&a.push(e)}))}return p}(this.graph,this.weightMap,n)}execute(e,t){e=this.mapInputs(e);const r=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),t=this.mapOutputs(t),this.checkOutputs(t);const s=r.map((e=>this.graph.nodes[_(e)[0]])),a=t.map((e=>_(e)[0]));let o=a.map((e=>this.graph.nodes[e]));this.resetIntermediateTensors(),0===o.length&&(o=this._outputs);const i=this.getCompilationKey(s,o);let u=this.compiledMap.get(i);null==u&&(u=this.compile(e,o),this.compiledMap.set(i,u));const p={},c={};return l((()=>{const r=new bi(this.weightMap,p,c,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=_(t),a=[];a[r]=e[t],s[n]=a}));const o=this.getFrozenTensorIds(s),i={};for(let e=0;e<u.length;e++){const t=u[e];if(!s[t.name]){const e=gi(t,s,r,this._resourceManager);if(n.isPromise(e))throw new Error(`The execution of the op '${t.op}' returned a promise. Please use model.executeAsync() instead.`);s[t.name]=e,this.checkTensorForDisposal(t.name,t,s,r,o,a,i)}}return null==this.parent&&r.dispose(o),t.map((e=>k(e,s,r)))}))}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map((t=>e[t])).map((e=>e.map((e=>e.id)))));return new Set(t)}checkTensorForDisposal(e,t,n,r,s,a,o){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach((e=>{null!=e&&(o[e.id]=(o[e.id]||0)+t.children.length)})),t.inputs.forEach((e=>{if("control"!==e.category){const a=function(e,t,n){return t[v(e,n.currentContextId)]}(e.name,n,r);null!=a&&a.forEach((e=>{if(e&&!e.kept&&!s.has(e.id)){const n=o[e.id];if(1===n){if(this.keepTensorForDebug){const[n,s]=T(t.name,r);this.intermediateTensors[n]||(this.intermediateTensors[n]=[]),this.intermediateTensors[n][s]=e}else e.dispose();delete o[e.id]}else null!=n&&o[e.id]--}}))}})))}async executeAsync(e,t){return this._executeAsync(e,t)}disposeIntermediateTensors(){this.intermediateTensors&&(Object.keys(this.intermediateTensors).forEach((e=>this.intermediateTensors[e].forEach((e=>e.dispose())))),this.disposeTensorsMap())}disposeTensorsMap(){this.tensorsMap&&Object.keys(this.tensorsMap).forEach((e=>{this.tensorsMap[e].forEach((e=>{!e||e.kept||e.isDisposed||this.keepIds.has(e.id)||e.dispose()}))}))}getIntermediateTensors(){return this.tensorsMap}resetIntermediateTensors(){for(const e in this.intermediateTensors)this.intermediateTensors[e].forEach((e=>e.dispose())),delete this.intermediateTensors[e]}async _executeAsync(e,n,r=!1,s={},a={}){r||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),n=this.mapOutputs(n),this.checkOutputs(n));try{this.keepTensorForDebug=t().getBool("KEEP_INTERMEDIATE_TENSORS")}catch(e){console.warn(e.message)}this.resetIntermediateTensors();const o=new bi(this.weightMap,s,a,this.functionExecutorMap);this.tensorsMap=await this.executeWithControlFlow(e,o,n,r);const i=n.map((e=>k(e,this.tensorsMap,o))),u=i.map((e=>e.id)),p=Object.keys(e).map((t=>e[t].id));return this.keepIds=new Set([...u,...p,...this.weightIds]),this.keepTensorForDebug||this.disposeTensorsMap(),null==this.parent&&o.dispose(this.keepIds),i}async executeFunctionAsync(e,t,n){const r=e.reduce(((e,t,n)=>(e[this.inputs[n].name]=t,e)),{});return this._executeAsync(r,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,r){const s=Object.keys(e),a=s.map((e=>this.graph.nodes[_(e)[0]])),o=n.map((e=>_(e)[0]));let i=o.map((e=>this.graph.nodes[e]));0===i.length&&(i=this._outputs);const{usedNodes:u,missingInputs:p,dynamicNode:l,syncInputs:c}=xi(e,i,this.weightMap,this._initNodes),h=[...a,...this.graph.weights,...this._initNodes||[]].map((e=>({node:e,contexts:t.currentContext}))),d=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=_(t),s=[];s[r]=e[t],d[n]=s}));const m={},f=this.getFrozenTensorIds(d),y={};for(;h.length>0;){const e=this.processStack(a,h,t,d,y,f,o,m,u);await Promise.all(e)}null!=l||r||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const g=i.filter((e=>!Ti(e)&&!k(e.name,d,t))).map((e=>e.name));if(g.length>0){let e="";throw null!=l&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${c}]`),new Error(`Cannot compute the outputs [${g}] from the provided inputs [${s}]. Consider providing the following inputs: [${p}]. ${e}`)}return d}processStack(e,t,r,s,a,o,i,u,p){const l=[];for(;t.length>0;){const e=t.pop();r.currentContext=e.contexts;let c="";if("Enter"===e.node.op&&w("isConstant",e.node,s,r)&&([c]=T(e.node.name,r)),null==s[e.node.name]){const h=gi(e.node,s,r,this._resourceManager);c||([c]=T(e.node.name,r));const d=r.currentContext;n.isPromise(h)?l.push(h.then((n=>(s[c]=n,r.currentContext=d,this.checkTensorForDisposal(c,e.node,s,r,o,i,u),this.processChildNodes(e.node,t,r,s,a,p),n)))):(s[c]=h,this.checkTensorForDisposal(c,e.node,s,r,o,i,u),this.processChildNodes(e.node,t,r,s,a,p))}else this.processChildNodes(e.node,t,r,s,a,p)}return l}processChildNodes(e,t,n,r,s,a){e.children.forEach((e=>{const[o]=T(e.name,n);!s[o]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some((e=>!!k(e,r,n)))&&(s[o]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every((e=>!!k(e,r,n)))&&(s[o]=!0,t.push({contexts:n.currentContext,node:e})))}))}dispose(){Object.keys(this.weightMap).forEach((e=>this.weightMap[e].forEach((e=>e.dispose()))))}checkInputShapeAndType(e){Object.keys(e).forEach((t=>{const r=e[t],[s]=_(t),a=this.graph.nodes[s];if(a.attrParams.shape&&a.attrParams.shape.value){const e=a.attrParams.shape.value,t=e.length===r.shape.length&&r.shape.every(((t,n)=>-1===e[n]||e[n]===t));n.assert(t,(()=>`The shape of dict['${a.name}'] provided in model.execute(dict) must be [${e}], but was [${r.shape}]`))}a.attrParams.dtype&&a.attrParams.dtype.value&&n.assert(r.dtype===a.attrParams.dtype.value,(()=>`The dtype of dict['${a.name}'] provided in model.execute(dict) must be ${a.attrParams.dtype.value}, but was ${r.dtype}`))}))}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter((e=>{const[t]=_(e);return null==this.graph.nodes[t]}));if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map((e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e}),{})}checkOutputs(e){e.forEach((e=>{const[t]=_(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)}))}}class Ei{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class $i{constructor(e,t={},n=d){this.modelUrl=e,this.loadOptions=t,this.version="n/a",this.io=n,null==t&&(this.loadOptions={}),this.resourceManager=new Ei}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}get modelStructuredOutputKeys(){return this.structuredOutputKeys}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=this.io.browserHTTPRequest(e,this.loadOptions);else{const t=this.io.getLoadHandlers(e,this.loadOptions);if(0===t.length)t.push(this.io.browserHTTPRequest(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=this.handler.load();return n.isPromise(e)?e.then((e=>this.loadSync(e))):this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n=this.artifacts.signature;if(null!=this.artifacts.userDefinedMetadata){const e=this.artifacts.userDefinedMetadata;null!=e.signature&&(n=e.signature),null!=e.structuredOutputKeys&&(this.structuredOutputKeys=e.structuredOutputKeys)}this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const r=this.io.decodeWeights(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new Si(j.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(r),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=j.Instance.transformGraph(e.modelInitializer);this.initializer=new Si(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=this.io.getSaveHandlers(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,t){const n=this.execute(e,this.outputNodes);if(this.structuredOutputKeys){const e={};return(n instanceof m?[n]:n).forEach(((t,n)=>e[this.structuredOutputKeys[n]]=t)),e}return n}normalizeInputs(e){if(!(e instanceof m||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce(((t,n,r)=>(t[n]=e[r],t)),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}getIntermediateTensors(){return this.executor.getIntermediateTensors()}disposeIntermediateTensors(){this.executor.disposeIntermediateTensors()}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce(((t,n)=>(t[n]=[e[n]],t)),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}async function Ii(e,t={},n=d){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==t&&(t={}),t.fromTFHub&&"string"==typeof e&&(e=function(e){e.endsWith("/")||(e+="/");return`${e}model.json?tfjs-format=file`}(e));const r=new $i(e,t,n);return await r.load(),r}function Di(e){if(null==e)throw new Error("modelUrl in loadGraphModelSync() cannot be null. Please provide a url or an IOHandler that loads the model");if(!e.load)throw new Error(`modelUrl IO Handler ${e} has no load function`);const t=new $i(e);return t.load(),t}const Ai="3.19.0";export{$i as GraphModel,N as deregisterOp,Ii as loadGraphModel,Di as loadGraphModelSync,b as registerOp,Ai as version_converter};
//# sourceMappingURL=tf-converter.fesm.min.js.map
