/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).tf=e.tf||{},e.tf)}(this,(function(e,t){"use strict";function n(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(n){if("default"!==n){var r=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,r.get?r:{enumerable:!0,get:function(){return e[n]}})}})),t.default=e,t}var r=n(t);var s,a;t.env().registerFlag("KEEP_INTERMEDIATE_TENSORS",(()=>!1),(e=>{e&&console.warn("Keep intermediate tensors is ON. This will print the values of all intermediate tensors during model inference. Not all models support this mode. For details, check e2e/benchmarks/ model_config.js. This significantly impacts performance.")})),function(e){e[e.DT_INVALID=0]="DT_INVALID",e[e.DT_FLOAT=1]="DT_FLOAT",e[e.DT_DOUBLE=2]="DT_DOUBLE",e[e.DT_INT32=3]="DT_INT32",e[e.DT_UINT8=4]="DT_UINT8",e[e.DT_INT16=5]="DT_INT16",e[e.DT_INT8=6]="DT_INT8",e[e.DT_STRING=7]="DT_STRING",e[e.DT_COMPLEX64=8]="DT_COMPLEX64",e[e.DT_INT64=9]="DT_INT64",e[e.DT_BOOL=10]="DT_BOOL",e[e.DT_QINT8=11]="DT_QINT8",e[e.DT_QUINT8=12]="DT_QUINT8",e[e.DT_QINT32=13]="DT_QINT32",e[e.DT_BFLOAT16=14]="DT_BFLOAT16",e[e.DT_QINT16=15]="DT_QINT16",e[e.DT_QUINT16=16]="DT_QUINT16",e[e.DT_UINT16=17]="DT_UINT16",e[e.DT_COMPLEX128=18]="DT_COMPLEX128",e[e.DT_HALF=19]="DT_HALF",e[e.DT_RESOURCE=20]="DT_RESOURCE",e[e.DT_VARIANT=21]="DT_VARIANT",e[e.DT_UINT32=22]="DT_UINT32",e[e.DT_UINT64=23]="DT_UINT64",e[e.DT_FLOAT_REF=101]="DT_FLOAT_REF",e[e.DT_DOUBLE_REF=102]="DT_DOUBLE_REF",e[e.DT_INT32_REF=103]="DT_INT32_REF",e[e.DT_UINT8_REF=104]="DT_UINT8_REF",e[e.DT_INT16_REF=105]="DT_INT16_REF",e[e.DT_INT8_REF=106]="DT_INT8_REF",e[e.DT_STRING_REF=107]="DT_STRING_REF",e[e.DT_COMPLEX64_REF=108]="DT_COMPLEX64_REF",e[e.DT_INT64_REF=109]="DT_INT64_REF",e[e.DT_BOOL_REF=110]="DT_BOOL_REF",e[e.DT_QINT8_REF=111]="DT_QINT8_REF",e[e.DT_QUINT8_REF=112]="DT_QUINT8_REF",e[e.DT_QINT32_REF=113]="DT_QINT32_REF",e[e.DT_BFLOAT16_REF=114]="DT_BFLOAT16_REF",e[e.DT_QINT16_REF=115]="DT_QINT16_REF",e[e.DT_QUINT16_REF=116]="DT_QUINT16_REF",e[e.DT_UINT16_REF=117]="DT_UINT16_REF",e[e.DT_COMPLEX128_REF=118]="DT_COMPLEX128_REF",e[e.DT_HALF_REF=119]="DT_HALF_REF",e[e.DT_RESOURCE_REF=120]="DT_RESOURCE_REF",e[e.DT_VARIANT_REF=121]="DT_VARIANT_REF",e[e.DT_UINT32_REF=122]="DT_UINT32_REF",e[e.DT_UINT64_REF=123]="DT_UINT64_REF"}(s||(s={})),function(e){var t;(t=e.CheckpointFormatVersion||(e.CheckpointFormatVersion={}))[t.LEGACY=0]="LEGACY",t[t.V1=1]="V1",t[t.V2=2]="V2"}(a||(a={}));const o={};function i(e){return o[e]}function u(e,n,r,s,a){const o=n.inputParams[e];if(o&&void 0!==o.inputIndexStart){const e=o.inputIndexStart,i=0===o.inputIndexEnd?void 0:void 0===o.inputIndexEnd?e+1:o.inputIndexEnd;if("tensor"===o.type)return p(n.inputNames[o.inputIndexStart],r,s,a);if("tensors"===o.type){return n.inputNames.slice(e,i).map((e=>p(e,r,s,a)))}const u=p(n.inputNames.slice(e)[0],r,s,a),l=u.dataSync();return"number"===o.type?l[0]:t.util.toNestedArray(u.shape,l)}const i=n.attrParams[e];return i&&i.value}function p(e,t,n,r){const[s,a]=h(e);if(null!=r){const e=r.getHashTableHandleByName(s);if(null!=e)return e}const o=n.currentContextIds.find((e=>!!t[c(s,e)]));return void 0!==o?t[c(s,o)][a]:void 0}function l(e,t){const[n,r,s]=h(e);return[c(n,t&&t.currentContextId),r,s]}function c(e,t){return t?`${e}-${t}`:e}function h(e){const t=e.split(":");if(1===t.length)return[e,0,void 0];const n=t[0],r=3===t.length?t[1]:void 0;return[n,Number(t[t.length-1]),r]}function d(e,t,n){let r=u("pad",e,t,n);if("explicit"===r){r=u("explicitPaddings",e,t,n);const s=[[0,0],[0,0],[0,0],[0,0]];for(let e=0;e<4;e++)s[e][0]=r[2*e],s[e][1]=r[2*e+1];return s}return r}function m(e){return e.kept?e:t.clone(e)}var f={__proto__:null,json:[{tfOpName:"Add",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddV2",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AddN",category:"arithmetic",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"BiasAdd",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"Sub",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"RealDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Div",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"DivNoNan",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorDiv",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mul",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Maximum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Minimum",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Pow",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SquaredDifference",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Mod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"FloorMod",category:"arithmetic",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var y={__proto__:null,json:[{tfOpName:"Abs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atan2",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ceil",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ClipByValue",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"clipValueMin",type:"number"},{start:2,name:"clipValueMax",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Complex",category:"basic_math",inputs:[{start:0,name:"real",type:"tensor"},{start:1,name:"imag",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ComplexAbs",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cos",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Cosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Elu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Exp",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Floor",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Imag",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Neg",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Real",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"Tout",name:"outputType",type:"dtype",notSupported:!0}]},{tfOpName:"Prelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"alpha",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Relu6",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Selu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sigmoid",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sin",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Rsqrt",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Square",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Tanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Sign",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Round",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Expm1",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Log1p",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Reciprocal",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Softplus",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Asinh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Acosh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Atanh",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Erf",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Prod",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axes",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LeakyRelu",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"alpha",name:"alpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"IsNan",category:"basic_math",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var g={__proto__:null,json:[{tfOpName:"EmptyTensorList",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"maxNumElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"LoopCond",category:"control",inputs:[{start:0,name:"pred",type:"tensor"}]},{tfOpName:"Switch",category:"control",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"pred",type:"tensor"}]},{tfOpName:"Merge",category:"control",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}]},{tfOpName:"Enter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"frame_name",name:"frameName",type:"string"},{tfName:"is_constant",name:"isConstant",type:"bool"}]},{tfOpName:"Exit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NextIteration",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayV3",category:"control",inputs:[{start:0,name:"size",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"dynamic_size",name:"dynamicSize",type:"bool"},{tfName:"clear_after_read",name:"clearAfterRead",type:"bool"},{tfName:"identical_element_shapes",name:"identicalElementShapes",type:"bool"},{tfName:"tensor_array_name",name:"name",type:"string"}]},{tfOpName:"TensorArrayWriteV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayReadV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"TensorArrayGatherV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape",name:"elementShape",type:"shape"}]},{tfOpName:"TensorArrayScatterV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"tensor",type:"tensor"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArrayConcatV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"element_shape_except0",name:"elementShapeExcept0",type:"shape",notSupported:!0}]},{tfOpName:"TensorArraySplitV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"tensor",type:"tensor"},{start:2,name:"lengths",type:"number[]"},{start:3,name:"flowIn",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"TensorArraySizeV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"},{start:1,name:"flowIn",type:"number"}]},{tfOpName:"TensorArrayCloseV3",category:"control",inputs:[{start:0,name:"tensorArrayId",type:"tensor"}]},{tfOpName:"StatelessIf",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"If",category:"control",inputs:[{start:0,name:"cond",type:"tensor"},{start:1,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"then_branch",name:"thenBranch",type:"func"},{tfName:"else_branch",name:"elseBranch",type:"func"}]},{tfOpName:"StatelessWhile",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"While",category:"control",inputs:[{start:0,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"cond",name:"cond",type:"func"},{tfName:"body",name:"body",type:"func"}]},{tfOpName:"TensorListScatter",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListScatterV2",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"},{start:3,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGather",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"indices",type:"number[]"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListGetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListSetItem",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"index",type:"number"},{start:2,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListReserve",category:"control",inputs:[{start:0,name:"elementShape",type:"shape"},{start:1,name:"numElements",type:"number"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListFromTensor",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListStack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"},{tfName:"num_elements",name:"numElements",type:"dtype"}]},{tfOpName:"TensorListSplit",category:"control",inputs:[{start:0,name:"tensor",type:"tensor"},{start:1,name:"elementShape",type:"shape"},{start:2,name:"lengths",type:"number[]"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcat",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListConcatV2",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}],attrs:[{tfName:"element_shape",name:"elementShape",type:"shape"},{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPopBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"elementShape",type:"shape"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListPushBack",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"tensor",type:"tensor"}],attrs:[{tfName:"element_dtype",name:"elementDType",type:"dtype"}]},{tfOpName:"TensorListLength",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"}]},{tfOpName:"TensorListResize",category:"control",inputs:[{start:0,name:"tensorListId",type:"tensor"},{start:1,name:"size",type:"number"}]}]};var b={__proto__:null,json:[{tfOpName:"AvgPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[],notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPoolWithArgmax",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"include_batch_in_index",name:"includeBatchInIndex",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"AvgPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MaxPool3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"ksize",name:"kernelSize",type:"number[]"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Conv1D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"stride",name:"stride",type:"number"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NWC"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"dilation",name:"dilation",type:"number",defaultValue:1}]},{tfOpName:"Conv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"useCudnnOnGpu",name:"useCudnnOnGpu",type:"bool"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"_FusedConv2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"use_cudnn_on_gpu",name:"useCudnnOnGpu",type:"bool",defaultValue:!0},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2}]},{tfOpName:"Conv2DBackpropInput",category:"convolution",inputs:[{start:2,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:0,name:"outputShape",type:"number[]"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]",notSupported:!0}]},{tfOpName:"DepthwiseConv2d",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"DepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"FusedDepthwiseConv2dNative",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]",defaultValue:[1,1,1,1]},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"explicit_paddings",name:"explicitPaddings",type:"number[]",defaultValue:[]}]},{tfOpName:"Conv3D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"padding",name:"pad",type:"string"},{tfName:"data_format",name:"dataFormat",type:"string",defaultValue:"NHWC"},{tfName:"dilations",name:"dilations",type:"number[]"}]},{tfOpName:"Dilation2D",category:"convolution",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"filter",type:"tensor"}],attrs:[{tfName:"strides",name:"strides",type:"number[]"},{tfName:"rates",name:"dilations",type:"number[]"},{tfName:"padding",name:"pad",type:"string"}]}]};var x={__proto__:null,json:[{tfOpName:"Fill",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"},{start:1,name:"value",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"LinSpace",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"num",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"OneHot",category:"creation",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"depth",type:"number"},{start:2,name:"onValue",type:"number",defaultValue:1},{start:3,name:"offValue",type:"number",defaultValue:0}],attrs:[{tfName:"axis",name:"axis",type:"number",notSupported:!0},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Ones",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"OnesLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"RandomStandardNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"RandomUniform",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"minval",name:"minval",type:"number",defaultValue:0},{tfName:"maxval",name:"maxval",type:"number",defaultValue:1},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"seed",name:"seed",type:"number",defaultValue:0},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Range",category:"creation",inputs:[{start:0,name:"start",type:"number"},{start:1,name:"stop",type:"number"},{start:2,name:"step",type:"number",defaultValue:0}],attrs:[{tfName:"Tidx",name:"dtype",type:"dtype"}]},{tfOpName:"TruncatedNormal",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"means",name:"mean",type:"number",defaultValue:0},{tfName:"stddev",name:"stdDev",type:"number",defaultValue:1},{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number",defaultValue:0,notSupported:!0},{tfName:"dtype",name:"dtype",type:"dtype"},{tfName:"T",name:"T",type:"number",notSupported:!0}]},{tfOpName:"Zeros",category:"creation",inputs:[{start:0,name:"shape",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"ZerosLike",category:"creation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype"}]},{tfOpName:"Multinomial",category:"creation",inputs:[{start:0,name:"logits",type:"tensor"},{start:1,name:"numSamples",type:"number"}],attrs:[{tfName:"seed",name:"seed",type:"number"},{tfName:"seed2",name:"seed2",type:"number"},{tfName:"T",name:"dtype",type:"dtype"},{tfName:"output_dtype",name:"output_dtype",type:"dtype"}]}]};var N={__proto__:null,json:[{tfOpName:"NonMaxSuppressionV2",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV3",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}]},{tfOpName:"NonMaxSuppressionV4",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0},{tfName:"T_threshold",name:"threshold",type:"dtype",notSupported:!0},{tfName:"pad_to_max_output_size",name:"padToMaxOutputSize",type:"bool"}]},{tfOpName:"NonMaxSuppressionV5",category:"dynamic",inputs:[{start:0,name:"boxes",type:"tensor"},{start:1,name:"scores",type:"tensor"},{start:2,name:"maxOutputSize",type:"number"},{start:3,name:"iouThreshold",type:"number"},{start:4,name:"scoreThreshold",type:"number"},{start:5,name:"softNmsSigma",type:"number"}]},{tfOpName:"Where",category:"dynamic",inputs:[{start:0,name:"condition",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ListDiff",category:"dynamic",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"y",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var w={__proto__:null,json:[{tfOpName:"LowerBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"TopKV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"k",type:"number"}],attrs:[{tfName:"sorted",name:"sorted",type:"bool"}]},{tfOpName:"UpperBound",category:"evaluation",inputs:[{start:0,name:"sortedSequence",type:"tensor"},{start:1,name:"values",type:"tensor"}]},{tfOpName:"Unique",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"UniqueV2",category:"evaluation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]}]};var k={__proto__:null,json:[{tfOpName:"PlaceholderWithDefault",category:"graph",inputs:[{start:0,name:"default",type:"tensor"}],attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Placeholder",category:"graph",attrs:[{tfName:"shape",name:"shape",type:"shape"},{tfName:"dtype",name:"dtype",type:"dtype"}]},{tfOpName:"Const",category:"graph"},{tfOpName:"Identity",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IdentityN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Snapshot",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Rank",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Size",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"Shape",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"ShapeN",category:"graph",inputs:[{start:0,end:0,name:"x",type:"tensors"}]},{tfOpName:"Print",category:"graph",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"data",type:"tensors"}],attrs:[{tfName:"message",name:"message",type:"string"},{tfName:"first_n",name:"firstN",type:"number",notSupported:!0},{tfName:"summarize",name:"summarize",type:"number",defaultValue:3}]},{tfOpName:"NoOp",category:"graph",inputs:[]},{tfOpName:"StopGradient",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"FakeQuantWithMinMaxVars",category:"graph",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"min",name:"min",type:"number"},{tfName:"max",name:"max",type:"number"}]}]};var T={__proto__:null,json:[{tfOpName:"HashTable",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"HashTableV2",category:"hash_table",inputs:[],attrs:[{tfName:"shared_name",name:"sharedName",type:"string"},{tfName:"use_node_name_sharing",name:"useNodeNameSharing",type:"bool"},{tfName:"key_dtype",name:"keyDType",type:"dtype"},{tfName:"value_dtype",name:"valueDType",type:"dtype"}]},{tfOpName:"LookupTableImport",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableImportV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"values",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFind",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableFindV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"},{start:1,name:"keys",type:"tensor"},{start:2,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"Tin",name:"tIn",type:"dtype",notSupported:!0},{tfName:"Tout",name:"tOut",type:"dtype",notSupported:!0}]},{tfOpName:"LookupTableSize",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]},{tfOpName:"LookupTableSizeV2",category:"hash_table",inputs:[{start:0,name:"tableHandle",type:"tensor"}]}]};var v={__proto__:null,json:[{tfOpName:"ResizeBilinear",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"ResizeNearestNeighbor",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"size",type:"number[]"}],attrs:[{tfName:"align_corners",name:"alignCorners",type:"bool"},{tfName:"half_pixel_centers",name:"halfPixelCenters",type:"bool"},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"CropAndResize",category:"image",inputs:[{start:0,name:"image",type:"tensor"},{start:1,name:"boxes",type:"tensor"},{start:2,name:"boxInd",type:"tensor"},{start:3,name:"cropSize",type:"number[]"}],attrs:[{tfName:"method",name:"method",type:"string"},{tfName:"extrapolation_value",name:"extrapolationValue",type:"number"}]},{tfOpName:"ImageProjectiveTransformV3",category:"image",inputs:[{start:0,name:"images",type:"tensor"},{start:1,name:"transforms",type:"tensor"},{start:2,name:"outputShape",type:"number[]"},{start:3,name:"fillValue",type:"number"}],attrs:[{tfName:"interpolation",name:"interpolation",type:"string"},{tfName:"fill_mode",name:"fillMode",type:"string"}]}]};var _={__proto__:null,json:[{tfOpName:"Equal",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"NotEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Greater",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"GreaterEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Less",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LessEqual",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalAnd",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalNot",category:"logical",inputs:[{start:0,name:"a",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"LogicalOr",category:"logical",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Select",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SelectV2",category:"logical",inputs:[{start:0,name:"condition",type:"tensor"},{start:1,name:"a",type:"tensor"},{start:2,name:"b",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]}]};var S={__proto__:null,json:[{tfOpName:"_FusedMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"},{start:2,end:0,name:"args",type:"tensors"}],attrs:[{tfName:"num_args",name:"numArgs",type:"number"},{tfName:"fused_ops",name:"fusedOps",type:"string[]",defaultValue:[]},{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:1e-4},{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"leakyrelu_alpha",name:"leakyreluAlpha",type:"number",defaultValue:.2},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"MatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"transpose_a",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"transpose_b",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMul",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"BatchMatMulV2",category:"matrices",inputs:[{start:0,name:"a",type:"tensor"},{start:1,name:"b",type:"tensor"}],attrs:[{tfName:"adj_x",name:"transposeA",type:"bool",defaultValue:!1},{tfName:"adj_y",name:"transposeB",type:"bool",defaultValue:!1},{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Transpose",category:"matrices",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"perm",type:"number[]"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"Einsum",category:"matrices",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"equation",name:"equation",type:"string"},{tfName:"N",name:"n",type:"number",defaultValue:2},{tfName:"T",name:"dtype",type:"dtype"}]}]};var E={__proto__:null,json:[{tfOpName:"EuclideanNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool",defaultValue:!1}]},{tfOpName:"FusedBatchNorm",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV2",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"FusedBatchNormV3",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"scale",type:"tensor"},{start:2,name:"offset",type:"tensor"},{start:3,name:"mean",type:"tensor"},{start:4,name:"variance",type:"tensor"}],attrs:[{tfName:"epsilon",name:"epsilon",type:"number",defaultValue:.001},{tfName:"data_format",name:"dataFormat",type:"string",notSupported:!0}]},{tfOpName:"LRN",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"depth_radius",name:"radius",type:"number",defaultValue:5},{tfName:"bias",name:"bias",type:"number",defaultValue:1},{tfName:"alpha",name:"alpha",type:"number",defaultValue:1},{tfName:"beta",name:"beta",type:"number",defaultValue:.5}]},{tfOpName:"Softmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"LogSoftmax",category:"normalization",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"SparseToDense",category:"normalization",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!0,notSupported:!0}]}]};var $={__proto__:null,json:[{tfOpName:"Bincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}]},{tfOpName:"DenseBincount",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"size",type:"number"},{start:2,name:"weights",type:"tensor"}],attrs:[{tfName:"binary_output",name:"binaryOutput",type:"bool"}]},{tfOpName:"Max",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Mean",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Min",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Sum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"All",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Any",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"ArgMax",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"ArgMin",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"Prod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}],attrs:[{tfName:"keep_dims",name:"keepDims",type:"bool"}]},{tfOpName:"Cumprod",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]},{tfOpName:"Cumsum",category:"reduction",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}],attrs:[{tfName:"exclusive",name:"exclusive",type:"bool"},{tfName:"reverse",name:"reverse",type:"bool"}]}]};var I={__proto__:null,json:[{tfOpName:"ConcatV2",category:"slice_join",inputs:[{start:0,end:-1,name:"tensors",type:"tensors"},{start:-1,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"Concat",category:"slice_join",inputs:[{start:1,end:0,name:"tensors",type:"tensors"},{start:0,name:"axis",type:"number"}],attrs:[{tfName:"N",name:"n",type:"number",defaultValue:2}]},{tfOpName:"GatherV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"axis",type:"number",defaultValue:0}],attrs:[{tfName:"batch_dims",name:"batchDims",type:"number",defaultValue:0}]},{tfOpName:"Gather",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",notSupported:!0}]},{tfOpName:"Reverse",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"dims",type:"bool[]"}]},{tfOpName:"ReverseV2",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number[]"}]},{tfOpName:"Slice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"size",type:"number[]"}]},{tfOpName:"StridedSlice",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"begin",type:"number[]"},{start:2,name:"end",type:"number[]"},{start:3,name:"strides",type:"number[]"}],attrs:[{tfName:"begin_mask",name:"beginMask",type:"number",defaultValue:0},{tfName:"end_mask",name:"endMask",type:"number",defaultValue:0},{tfName:"new_axis_mask",name:"newAxisMask",type:"number",defaultValue:0},{tfName:"ellipsis_mask",name:"ellipsisMask",type:"number",defaultValue:0},{tfName:"shrink_axis_mask",name:"shrinkAxisMask",type:"number",defaultValue:0}]},{tfOpName:"Pack",category:"slice_join",inputs:[{start:0,end:0,name:"tensors",type:"tensors"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0}]},{tfOpName:"Unpack",category:"slice_join",inputs:[{start:0,name:"tensor",type:"tensor"}],attrs:[{tfName:"axis",name:"axis",type:"number",defaultValue:0},{tfName:"num",name:"num",type:"number",defaultValue:0,notSupported:!0}]},{tfOpName:"Tile",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"reps",type:"number[]"}]},{tfOpName:"Split",category:"slice_join",inputs:[{start:0,name:"axis",type:"number",defaultValue:0},{start:1,name:"x",type:"tensor"}],attrs:[{tfName:"num_split",name:"numOrSizeSplits",type:"number",defaultValue:1}]},{tfOpName:"SplitV",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"numOrSizeSplits",type:"number[]"},{start:2,name:"axis",type:"number",defaultValue:0}]},{tfOpName:"ScatterNd",category:"slice_join",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"shape",type:"number[]"}]},{tfOpName:"GatherNd",category:"slice_join",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"indices",type:"tensor"}]},{tfOpName:"SparseToDense",category:"slice_join",inputs:[{start:0,name:"sparseIndices",type:"tensor"},{start:1,name:"outputShape",type:"number[]"},{start:2,name:"sparseValues",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}],attrs:[{tfName:"validate_indices",name:"validateIndices",type:"bool",defaultValue:!1,notSupported:!0}]}]};var D={__proto__:null,json:[{tfOpName:"SparseFillEmptyRows",category:"sparse",inputs:[{start:0,name:"indices",type:"tensor"},{start:1,name:"values",type:"tensor"},{start:2,name:"denseShape",type:"tensor"},{start:3,name:"defaultValue",type:"tensor"}]},{tfOpName:"SparseReshape",category:"sparse",inputs:[{start:0,name:"inputIndices",type:"tensor"},{start:1,name:"inputShape",type:"tensor"},{start:2,name:"newShape",type:"tensor"}],attrs:[{tfName:"T",name:"dtype",type:"dtype",notSupported:!0}]},{tfOpName:"SparseSegmentMean",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]},{tfOpName:"SparseSegmentSum",category:"sparse",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"indices",type:"tensor"},{start:2,name:"segmentIds",type:"tensor"}]}]};var O={__proto__:null,json:[{tfOpName:"FFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"IFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"}]},{tfOpName:"RFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]},{tfOpName:"IRFFT",category:"spectral",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"fft_length",type:"number",notSupported:!0}]}]};var A={__proto__:null,json:[{tfOpName:"StringNGrams",category:"string",inputs:[{start:0,name:"data",type:"tensor"},{start:1,name:"dataSplits",type:"tensor"}],attrs:[{tfName:"separator",name:"separator",type:"string"},{tfName:"ngram_widths",name:"nGramWidths",type:"number[]"},{tfName:"left_pad",name:"leftPad",type:"string"},{tfName:"right_pad",name:"rightPad",type:"string"},{tfName:"pad_width",name:"padWidth",type:"number"},{tfName:"preserve_short_sequences",name:"preserveShortSequences",type:"bool"}],outputs:["ngrams","ngrams_splits"]},{tfOpName:"StringSplit",category:"string",inputs:[{start:0,name:"input",type:"tensor"},{start:1,name:"delimiter",type:"tensor"}],attrs:[{tfName:"skip_empty",name:"skipEmpty",type:"bool"}],outputs:["indices","values","shape"]},{tfOpName:"StringToHashBucketFast",category:"string",inputs:[{start:0,name:"input",type:"tensor"}],attrs:[{tfName:"num_buckets",name:"numBuckets",type:"number"}]}]};var M={__proto__:null,json:[{tfOpName:"Cast",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"SrcT",name:"sdtype",type:"dtype",notSupported:!0},{tfName:"DstT",name:"dtype",type:"dtype"}]},{tfOpName:"ExpandDims",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"axis",type:"number"}]},{tfOpName:"MirrorPad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"mode",name:"mode",type:"string"}]},{tfOpName:"Pad",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"}],attrs:[{tfName:"constant_value",name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"PadV2",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"padding",type:"number[]"},{start:2,name:"constantValue",type:"number",defaultValue:0}]},{tfOpName:"Reshape",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}]},{tfOpName:"Squeeze",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"axis",tfDeprecatedName:"squeeze_dims",name:"axis",type:"number[]"}]},{tfOpName:"SpaceToBatchND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"paddings",type:"number[]"}]},{tfOpName:"BatchToSpaceND",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"blockShape",type:"number[]"},{start:2,name:"crops",type:"number[]"}]},{tfOpName:"DepthToSpace",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"}],attrs:[{tfName:"block_size",name:"blockSize",type:"number"},{tfName:"data_format",name:"dataFormat",type:"string"}]},{tfOpName:"BroadcastTo",category:"transformation",inputs:[{start:0,name:"x",type:"tensor"},{start:1,name:"shape",type:"number[]"}],attrs:[]},{tfOpName:"BroadcastArgs",category:"transformation",inputs:[{start:0,name:"s0",type:"tensor"},{start:1,name:"s1",type:"tensor"}],attrs:[]}]};class C{static get Instance(){return this._instance||(this._instance=new this)}constructor(){const e=[].concat(...[f,y,g,b,x,N,w,k,T,v,_,S,E,$,I,D,O,A,M].map((e=>e.json)));this.opMappers=e.reduce(((e,t)=>(e[t.tfOpName]=t,e)),{})}transformGraph(e,t={}){const n=e.node,r=[],s=[],a=[],o=n.reduce(((e,t)=>(e[t.name]=this.mapNode(t),t.op.startsWith("Placeholder")?r.push(e[t.name]):"Const"===t.op?s.push(e[t.name]):null!=t.input&&0!==t.input.length||a.push(e[t.name]),e)),{});let i=[];const u=[];let p={},c={};null!=t&&(p=this.mapSignatureEntries(t.inputs),c=this.mapSignatureEntries(t.outputs));const h=Object.keys(o);h.forEach((e=>{const t=o[e];t.inputNames.forEach(((e,n)=>{const[r,,s]=l(e),a=o[r];if(null!=a.outputs){const e=a.outputs.indexOf(s);if(-1!==e){const s=`${r}:${e}`;t.inputNames[n]=s}}t.inputs.push(a),a.children.push(t)}))})),0===Object.keys(c).length?h.forEach((e=>{const t=o[e];0===t.children.length&&u.push(t)})):Object.keys(c).forEach((e=>{const[t]=l(e),n=o[t];null!=n&&(n.signatureKey=c[e],u.push(n))})),Object.keys(p).length>0?Object.keys(p).forEach((e=>{const[t]=l(e),n=o[t];n&&(n.signatureKey=p[e],i.push(n))})):i=r;let d={};null!=e.library&&null!=e.library.function&&(d=e.library.function.reduce(((e,t)=>(e[t.signature.name]=this.mapFunction(t),e)),{}));const m={nodes:o,inputs:i,outputs:u,weights:s,placeholders:r,signature:t,functions:d};return a.length>0&&(m.initNodes=a),m}mapSignatureEntries(e){return Object.keys(e||{}).reduce(((t,n)=>(t[e[n].name]=n,t)),{})}mapNode(e){const t=i(e.op)||this.opMappers[e.op]||{};null==e.attr&&(e.attr={});const n={name:e.name,op:e.op,category:t.category,inputNames:(e.input||[]).map((e=>e.startsWith("^")?e.slice(1):e)),inputs:[],children:[],inputParams:{},attrParams:{},rawAttrs:e.attr,outputs:t.outputs};return null!=t.inputs&&(n.inputParams=t.inputs.reduce(((e,t)=>(e[t.name]={type:t.type,inputIndexStart:t.start,inputIndexEnd:t.end},e)),{})),null!=t.attrs&&(n.attrParams=t.attrs.reduce(((t,n)=>{const r=n.type;let s;switch(n.type){case"string":s=V(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=V(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"string[]":s=j(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=j(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number":s=R(e.attr,n.tfName,n.defaultValue||0),void 0===s&&n.tfDeprecatedName&&(s=R(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"number[]":s=W(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=W(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool":s=z(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=z(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"bool[]":s=G(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=G(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape":s=U(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=U(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"shape[]":s=H(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=H(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype":s=P(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=P(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"dtype[]":s=K(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=K(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"func":s=B(e.attr,n.tfName,n.defaultValue),void 0===s&&n.tfDeprecatedName&&(s=B(e.attr,n.tfDeprecatedName,n.defaultValue));break;case"tensor":case"tensors":break;default:throw new Error(`Unsupported param type: ${n.type} for op: ${e.op}`)}return t[n.name]={value:s,type:r},t}),{})),n}mapFunction(e){const t=e.nodeDef,n=[];let r={};null!=t&&(r=t.reduce(((e,t)=>(e[t.name]=this.mapNode(t),"Const"===t.op&&n.push(e[t.name]),e)),{}));const s=[],a=[];e.signature.inputArg.forEach((e=>{const[t]=l(e.name),n={name:t,op:"Placeholder",inputs:[],inputNames:[],category:"graph",inputParams:{},attrParams:{dtype:{value:L(e.type),type:"dtype"}},children:[]};n.signatureKey=e.name,s.push(n),r[t]=n}));Object.keys(r).forEach((e=>{const t=r[e];t.inputNames.forEach(((e,n)=>{const[s,,a]=l(e),o=r[s];if(null!=o.outputs){const e=o.outputs.indexOf(a);if(-1!==e){const r=`${s}:${e}`;t.inputNames[n]=r}}t.inputs.push(o),o.children.push(t)}))}));const o=e.ret;e.signature.outputArg.forEach((e=>{const[t,n]=l(o[e.name]),s=r[t];null!=s&&(s.defaultOutput=n,a.push(s))}));const i=this.mapArgsToSignature(e);return{nodes:r,inputs:s,outputs:a,weights:n,placeholders:[],signature:i}}mapArgsToSignature(e){return{methodName:e.signature.name,inputs:e.signature.inputArg.reduce(((e,t)=>(e[t.name]=this.mapArgToTensorInfo(t),e)),{}),outputs:e.signature.outputArg.reduce(((t,n)=>(t[n.name]=this.mapArgToTensorInfo(n,e.ret),t)),{})}}mapArgToTensorInfo(e,t){let n=e.name;return null!=t&&(n=t[n]),{name:n,dtype:e.type}}}function F(e,n){const r=Array.isArray(e)?String.fromCharCode.apply(null,e):function(e){const n=t.env().global;if("undefined"!=typeof n.atob)return n.atob(e);if("undefined"!=typeof Buffer)return new Buffer(e,"base64").toString();throw new Error("Unable to decode base64 in this environment. Missing built-in atob() or Buffer()")}(e);return n?r:r.toLowerCase()}function V(e,t,n,r=!1){const s=e[t];return null!=s?F(s.s,r):n}function z(e,t,n){const r=e[t];return r?r.b:n}function R(e,t,n){const r=e[t]||{},s=null!=r.i?r.i:null!=r.f?r.f:n;return"number"==typeof s?s:parseInt(s,10)}function L(e){switch("string"==typeof e&&(e=s[e]),e){case s.DT_FLOAT:case s.DT_HALF:return"float32";case s.DT_INT32:case s.DT_INT64:case s.DT_INT8:case s.DT_UINT8:return"int32";case s.DT_BOOL:return"bool";case s.DT_DOUBLE:return"float32";case s.DT_STRING:return"string";default:return null}}function B(e,t,n){const r=e[t];return r&&r.func?r.func.name:n}function P(e,t,n){const r=e[t];return r&&r.type?L(r.type):n}function K(e,t,n){const r=e[t];return r&&r.list&&r.list.type?r.list.type.map((e=>L(e))):n}function q(e){if(!e.unknownRank)return null!=e.dim?e.dim.map((e=>"number"==typeof e.size?e.size:parseInt(e.size,10))):[]}function U(e,t,n){const r=e[t];return r&&r.shape?q(r.shape):n}function W(e,t,n){const r=e[t];return r?((r.list.f&&r.list.f.length?r.list.f:r.list.i)||[]).map((e=>"number"==typeof e?e:parseInt(e,10))):n}function j(e,t,n,r=!1){const s=e[t];return s&&s.list&&s.list.s?s.list.s.map((e=>F(e,r))):n}function H(e,t,n){const r=e[t];return r&&r.list&&r.list.shape?r.list.shape.map((e=>q(e))):n}function G(e,t,n){const r=e[t];return r&&r.list&&r.list.b?r.list.b:n}class Z{constructor(e,t,n){this.node=e,this.tensorMap=t,this.context=n,this.inputs=[],this.attrs={},this.inputs=e.inputNames.map((e=>this.getInput(e))),null!=e.rawAttrs&&(this.attrs=Object.keys(e.rawAttrs).reduce(((e,t)=>(e[t]=this.getAttr(t),e)),{}))}getInput(e){return p(e,this.tensorMap,this.context)}getAttr(e,t){const n=this.node.rawAttrs[e];if(null!=n.tensor)return p(e,this.tensorMap,this.context);if(null!=n.i||null!=n.f)return R(this.node.rawAttrs,e,t);if(null!=n.s)return V(this.node.rawAttrs,e,t);if(null!=n.b)return z(this.node.rawAttrs,e,t);if(null!=n.shape)return U(this.node.rawAttrs,e,t);if(null!=n.type)return P(this.node.rawAttrs,e,t);if(null!=n.list){if(null!=n.list.i||null!=n.list.f)return W(this.node.rawAttrs,e,t);if(null!=n.list.s)return j(this.node.rawAttrs,e,t);if(null!=n.list.shape)return H(this.node.rawAttrs,e,t);if(null!=n.list.b)return G(this.node.rawAttrs,e,t);if(null!=n.list.type)return K(this.node.rawAttrs,e,t)}return t}}function Q(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function Y(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function X(e,t,n=""){Y(ne(e,t),(()=>n+` Shapes ${e} and ${t} must match`))}function J(e){Y(null!=e,(()=>"The input to the tensor constructor must be a non-null value."))}function ee(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||oe(e)&&!n)for(let r=0;r<e.length;++r)ee(e[r],t,n);else t.push(e);return t}function te(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function ne(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function re(e){return e%1==0}function se(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function ae(e,t){const n=t.length;return Y((e=null==e?t.map(((e,t)=>t)):[].concat(e)).every((e=>e>=-n&&e<n)),(()=>`All values in axis param must be in range [-${n}, ${n}) but got axis ${e}`)),Y(e.every((e=>re(e))),(()=>`All values in axis param must be integers but got axis ${e}`)),e.map((e=>e<0?n+e:e))}function oe(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray}function ie(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error(`Unknown dtype ${e}`)}function ue(e){return"string"==typeof e||e instanceof String}function pe(e){return Array.isArray(e)?pe(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array||e instanceof Uint8ClampedArray?"int32":"number"==typeof e?"float32":ue(e)?"string":function(e){return"boolean"==typeof e}(e)?"bool":"float32"}function le(e){return!!(e&&e.constructor&&e.call&&e.apply)}function ce(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function he(e,t,n,r=!1){const s=new Array;if(1===t.length){const a=t[0]*(r?2:1);for(let t=0;t<a;t++)s[t]=n[e+t]}else{const a=t[0],o=t.slice(1),i=o.reduce(((e,t)=>e*t))*(r?2:1);for(let t=0;t<a;t++)s[t]=he(e+t*i,o,n,r)}return s}function de(e,t,n=!1){if(0===e.length)return t[0];const r=e.reduce(((e,t)=>e*t))*(n?2:1);if(0===r)return[];if(r!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}${n?" for a complex tensor":""}.`);return he(0,e,t,n)}function me(e,t){const n=fe(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function fe(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error(`Unknown data type ${t}`)}function ye(e){e.forEach((t=>{Y(Number.isInteger(t)&&t>=0,(()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`))}))}function ge(e){return e&&e.then&&"function"==typeof e.then}const be="tfjsflags";class xe{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.getQueryParams=Ne,this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&(we().getBool("IS_TEST")||we().getBool("PROD")||console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${e}.`)),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];we().getBool("IS_TEST")||we().getBool("PROD")||console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(ge(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if("undefined"==typeof this.global||"undefined"==typeof this.global.location||"undefined"==typeof this.global.location.search)return;const e=this.getQueryParams(this.global.location.search);if(be in e){e.tfjsflags.split(",").forEach((e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)}))}}}function Ne(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,((e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("=")))),t}function we(){return Te}let ke,Te=null;function ve(){if(null==ke){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}ke=e}return ke}function _e(e,t){const n=function(){const e=ve();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}const Se="Cast",Ee="Identity",$e="Tile",Ie="Transpose",De="_FusedMatMul",Oe="FusedConv2D",Ae="FusedDepthwiseConv2D";function Me(...e){we().getBool("IS_TEST")||we().getBool("PROD")||console.warn(...e)}const Ce=_e("kernelRegistry",(()=>new Map)),Fe=_e("gradRegistry",(()=>new Map));function Ve(e,t){const n=function(e,t){return`${t}_${e}`}(e,t);return Ce.get(n)}function ze(e){return Fe.get(e)}function Re(e){const t=Ce.entries(),n=[];for(;;){const{done:r,value:s}=t.next();if(r)break;const[a,o]=s,[i]=a.split("_");i===e&&n.push(o)}return n}var Le=Pe,Be=null;try{Be=new WebAssembly.Instance(new WebAssembly.Module(new Uint8Array([0,97,115,109,1,0,0,0,1,13,2,96,0,1,127,96,4,127,127,127,127,1,127,3,7,6,0,1,1,1,1,1,6,6,1,127,1,65,0,11,7,50,6,3,109,117,108,0,1,5,100,105,118,95,115,0,2,5,100,105,118,95,117,0,3,5,114,101,109,95,115,0,4,5,114,101,109,95,117,0,5,8,103,101,116,95,104,105,103,104,0,0,10,191,1,6,4,0,35,0,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,126,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,127,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,128,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,129,34,4,66,32,135,167,36,0,32,4,167,11,36,1,1,126,32,0,173,32,1,173,66,32,134,132,32,2,173,32,3,173,66,32,134,132,130,34,4,66,32,135,167,36,0,32,4,167,11])),{}).exports}catch(e){}function Pe(e,t,n){this.low=0|e,this.high=0|t,this.unsigned=!!n}function Ke(e){return!0===(e&&e.__isLong__)}Pe.prototype.__isLong__,Object.defineProperty(Pe.prototype,"__isLong__",{value:!0}),Pe.isLong=Ke;var qe={},Ue={};function We(e,t){var n,r,s;return t?(s=0<=(e>>>=0)&&e<256)&&(r=Ue[e])?r:(n=He(e,(0|e)<0?-1:0,!0),s&&(Ue[e]=n),n):(s=-128<=(e|=0)&&e<128)&&(r=qe[e])?r:(n=He(e,e<0?-1:0,!1),s&&(qe[e]=n),n)}function je(e,t){if(isNaN(e))return t?nt:tt;if(t){if(e<0)return nt;if(e>=Xe)return it}else{if(e<=-Je)return ut;if(e+1>=Je)return ot}return e<0?je(-e,t).neg():He(e%Ye|0,e/Ye|0,t)}function He(e,t,n){return new Pe(e,t,n)}Pe.fromInt=We,Pe.fromNumber=je,Pe.fromBits=He;var Ge=Math.pow;function Ze(e,t,n){if(0===e.length)throw Error("empty string");if("NaN"===e||"Infinity"===e||"+Infinity"===e||"-Infinity"===e)return tt;if("number"==typeof t?(n=t,t=!1):t=!!t,(n=n||10)<2||36<n)throw RangeError("radix");var r;if((r=e.indexOf("-"))>0)throw Error("interior hyphen");if(0===r)return Ze(e.substring(1),t,n).neg();for(var s=je(Ge(n,8)),a=tt,o=0;o<e.length;o+=8){var i=Math.min(8,e.length-o),u=parseInt(e.substring(o,o+i),n);if(i<8){var p=je(Ge(n,i));a=a.mul(p).add(je(u))}else a=(a=a.mul(s)).add(je(u))}return a.unsigned=t,a}function Qe(e,t){return"number"==typeof e?je(e,t):"string"==typeof e?Ze(e,t):He(e.low,e.high,"boolean"==typeof t?t:e.unsigned)}Pe.fromString=Ze,Pe.fromValue=Qe;var Ye=4294967296,Xe=Ye*Ye,Je=Xe/2,et=We(1<<24),tt=We(0);Pe.ZERO=tt;var nt=We(0,!0);Pe.UZERO=nt;var rt=We(1);Pe.ONE=rt;var st=We(1,!0);Pe.UONE=st;var at=We(-1);Pe.NEG_ONE=at;var ot=He(-1,2147483647,!1);Pe.MAX_VALUE=ot;var it=He(-1,-1,!0);Pe.MAX_UNSIGNED_VALUE=it;var ut=He(0,-2147483648,!1);Pe.MIN_VALUE=ut;var pt=Pe.prototype;pt.toInt=function(){return this.unsigned?this.low>>>0:this.low},pt.toNumber=function(){return this.unsigned?(this.high>>>0)*Ye+(this.low>>>0):this.high*Ye+(this.low>>>0)},pt.toString=function(e){if((e=e||10)<2||36<e)throw RangeError("radix");if(this.isZero())return"0";if(this.isNegative()){if(this.eq(ut)){var t=je(e),n=this.div(t),r=n.mul(t).sub(this);return n.toString(e)+r.toInt().toString(e)}return"-"+this.neg().toString(e)}for(var s=je(Ge(e,6),this.unsigned),a=this,o="";;){var i=a.div(s),u=(a.sub(i.mul(s)).toInt()>>>0).toString(e);if((a=i).isZero())return u+o;for(;u.length<6;)u="0"+u;o=""+u+o}},pt.getHighBits=function(){return this.high},pt.getHighBitsUnsigned=function(){return this.high>>>0},pt.getLowBits=function(){return this.low},pt.getLowBitsUnsigned=function(){return this.low>>>0},pt.getNumBitsAbs=function(){if(this.isNegative())return this.eq(ut)?64:this.neg().getNumBitsAbs();for(var e=0!=this.high?this.high:this.low,t=31;t>0&&0==(e&1<<t);t--);return 0!=this.high?t+33:t+1},pt.isZero=function(){return 0===this.high&&0===this.low},pt.eqz=pt.isZero,pt.isNegative=function(){return!this.unsigned&&this.high<0},pt.isPositive=function(){return this.unsigned||this.high>=0},pt.isOdd=function(){return 1==(1&this.low)},pt.isEven=function(){return 0==(1&this.low)},pt.equals=function(e){return Ke(e)||(e=Qe(e)),(this.unsigned===e.unsigned||this.high>>>31!=1||e.high>>>31!=1)&&(this.high===e.high&&this.low===e.low)},pt.eq=pt.equals,pt.notEquals=function(e){return!this.eq(e)},pt.neq=pt.notEquals,pt.ne=pt.notEquals,pt.lessThan=function(e){return this.comp(e)<0},pt.lt=pt.lessThan,pt.lessThanOrEqual=function(e){return this.comp(e)<=0},pt.lte=pt.lessThanOrEqual,pt.le=pt.lessThanOrEqual,pt.greaterThan=function(e){return this.comp(e)>0},pt.gt=pt.greaterThan,pt.greaterThanOrEqual=function(e){return this.comp(e)>=0},pt.gte=pt.greaterThanOrEqual,pt.ge=pt.greaterThanOrEqual,pt.compare=function(e){if(Ke(e)||(e=Qe(e)),this.eq(e))return 0;var t=this.isNegative(),n=e.isNegative();return t&&!n?-1:!t&&n?1:this.unsigned?e.high>>>0>this.high>>>0||e.high===this.high&&e.low>>>0>this.low>>>0?-1:1:this.sub(e).isNegative()?-1:1},pt.comp=pt.compare,pt.negate=function(){return!this.unsigned&&this.eq(ut)?ut:this.not().add(rt)},pt.neg=pt.negate,pt.add=function(e){Ke(e)||(e=Qe(e));var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,a=e.high>>>16,o=65535&e.high,i=e.low>>>16,u=0,p=0,l=0,c=0;return l+=(c+=s+(65535&e.low))>>>16,p+=(l+=r+i)>>>16,u+=(p+=n+o)>>>16,u+=t+a,He((l&=65535)<<16|(c&=65535),(u&=65535)<<16|(p&=65535),this.unsigned)},pt.subtract=function(e){return Ke(e)||(e=Qe(e)),this.add(e.neg())},pt.sub=pt.subtract,pt.multiply=function(e){if(this.isZero())return tt;if(Ke(e)||(e=Qe(e)),Be)return He(Be.mul(this.low,this.high,e.low,e.high),Be.get_high(),this.unsigned);if(e.isZero())return tt;if(this.eq(ut))return e.isOdd()?ut:tt;if(e.eq(ut))return this.isOdd()?ut:tt;if(this.isNegative())return e.isNegative()?this.neg().mul(e.neg()):this.neg().mul(e).neg();if(e.isNegative())return this.mul(e.neg()).neg();if(this.lt(et)&&e.lt(et))return je(this.toNumber()*e.toNumber(),this.unsigned);var t=this.high>>>16,n=65535&this.high,r=this.low>>>16,s=65535&this.low,a=e.high>>>16,o=65535&e.high,i=e.low>>>16,u=65535&e.low,p=0,l=0,c=0,h=0;return c+=(h+=s*u)>>>16,l+=(c+=r*u)>>>16,c&=65535,l+=(c+=s*i)>>>16,p+=(l+=n*u)>>>16,l&=65535,p+=(l+=r*i)>>>16,l&=65535,p+=(l+=s*o)>>>16,p+=t*u+n*i+r*o+s*a,He((c&=65535)<<16|(h&=65535),(p&=65535)<<16|(l&=65535),this.unsigned)},pt.mul=pt.multiply,pt.divide=function(e){if(Ke(e)||(e=Qe(e)),e.isZero())throw Error("division by zero");var t,n,r;if(Be)return this.unsigned||-2147483648!==this.high||-1!==e.low||-1!==e.high?He((this.unsigned?Be.div_u:Be.div_s)(this.low,this.high,e.low,e.high),Be.get_high(),this.unsigned):this;if(this.isZero())return this.unsigned?nt:tt;if(this.unsigned){if(e.unsigned||(e=e.toUnsigned()),e.gt(this))return nt;if(e.gt(this.shru(1)))return st;r=nt}else{if(this.eq(ut))return e.eq(rt)||e.eq(at)?ut:e.eq(ut)?rt:(t=this.shr(1).div(e).shl(1)).eq(tt)?e.isNegative()?rt:at:(n=this.sub(e.mul(t)),r=t.add(n.div(e)));if(e.eq(ut))return this.unsigned?nt:tt;if(this.isNegative())return e.isNegative()?this.neg().div(e.neg()):this.neg().div(e).neg();if(e.isNegative())return this.div(e.neg()).neg();r=tt}for(n=this;n.gte(e);){t=Math.max(1,Math.floor(n.toNumber()/e.toNumber()));for(var s=Math.ceil(Math.log(t)/Math.LN2),a=s<=48?1:Ge(2,s-48),o=je(t),i=o.mul(e);i.isNegative()||i.gt(n);)i=(o=je(t-=a,this.unsigned)).mul(e);o.isZero()&&(o=rt),r=r.add(o),n=n.sub(i)}return r},pt.div=pt.divide,pt.modulo=function(e){return Ke(e)||(e=Qe(e)),Be?He((this.unsigned?Be.rem_u:Be.rem_s)(this.low,this.high,e.low,e.high),Be.get_high(),this.unsigned):this.sub(this.div(e).mul(e))},pt.mod=pt.modulo,pt.rem=pt.modulo,pt.not=function(){return He(~this.low,~this.high,this.unsigned)},pt.and=function(e){return Ke(e)||(e=Qe(e)),He(this.low&e.low,this.high&e.high,this.unsigned)},pt.or=function(e){return Ke(e)||(e=Qe(e)),He(this.low|e.low,this.high|e.high,this.unsigned)},pt.xor=function(e){return Ke(e)||(e=Qe(e)),He(this.low^e.low,this.high^e.high,this.unsigned)},pt.shiftLeft=function(e){return Ke(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?He(this.low<<e,this.high<<e|this.low>>>32-e,this.unsigned):He(0,this.low<<e-32,this.unsigned)},pt.shl=pt.shiftLeft,pt.shiftRight=function(e){return Ke(e)&&(e=e.toInt()),0==(e&=63)?this:e<32?He(this.low>>>e|this.high<<32-e,this.high>>e,this.unsigned):He(this.high>>e-32,this.high>=0?0:-1,this.unsigned)},pt.shr=pt.shiftRight,pt.shiftRightUnsigned=function(e){if(Ke(e)&&(e=e.toInt()),0===(e&=63))return this;var t=this.high;return e<32?He(this.low>>>e|t<<32-e,t>>>e,this.unsigned):He(32===e?t:t>>>e-32,0,this.unsigned)},pt.shru=pt.shiftRightUnsigned,pt.shr_u=pt.shiftRightUnsigned,pt.toSigned=function(){return this.unsigned?He(this.low,this.high,!1):this},pt.toUnsigned=function(){return this.unsigned?this:He(this.low,this.high,!0)},pt.toBytes=function(e){return e?this.toBytesLE():this.toBytesBE()},pt.toBytesLE=function(){var e=this.high,t=this.low;return[255&t,t>>>8&255,t>>>16&255,t>>>24,255&e,e>>>8&255,e>>>16&255,e>>>24]},pt.toBytesBE=function(){var e=this.high,t=this.low;return[e>>>24,e>>>16&255,e>>>8&255,255&e,t>>>24,t>>>16&255,t>>>8&255,255&t]},Pe.fromBytes=function(e,t,n){return n?Pe.fromBytesLE(e,t):Pe.fromBytesBE(e,t)},Pe.fromBytesLE=function(e,t){return new Pe(e[0]|e[1]<<8|e[2]<<16|e[3]<<24,e[4]|e[5]<<8|e[6]<<16|e[7]<<24,t)},Pe.fromBytesBE=function(e,t){return new Pe(e[4]<<24|e[5]<<16|e[6]<<8|e[7],e[0]<<24|e[1]<<16|e[2]<<8|e[3],t)};const lt=Le||Object.assign(Object.create(null),Le,{default:Le});function ct(e){return lt.fromString(e,!0,16)}function ht(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=ee(e)),we().getBool("DEBUG")&&function(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error(`Unknown data type ${t}`)}function dt(){return we().platform.now()}function mt(e,t="utf-8"){return t=t||"utf-8",we().platform.decode(e,t)}ct("c3a5c85c97cb3127"),ct("b492b66fbe98f273"),ct("9ae16a3b2f90404f");class ft{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new gt)}profileKernel(e,t,n){let r;const s=()=>{r=n()};let a;const o=dt();if(this.backendTimer.timerAvailable())a=this.backendTimer.time(s);else{s();for(const e of r)e.dataSync();a=Promise.resolve({kernelMs:dt()-o})}if(we().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then((t=>{yt(t,n.dtype,e)}))}return{kernelName:e,outputs:r,inputs:t,timeMs:a.then((e=>e.kernelMs)),extraInfo:a.then((e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():""))}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:s,extraInfo:a}=e;n.forEach((e=>{Promise.all([e.data(),r,a]).then((n=>{this.logger.logKernelProfile(t,e,n[0],n[1],s,n[2])}))}))}}function yt(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class gt{logKernelProfile(e,t,n,r,s,a){const o="number"==typeof r?se(`${r}ms`,9):r.error,i=se(e,25),u=t.rank,p=t.size,l=se(t.shape.toString(),14);let c="";for(const e in s){const n=s[e];if(null!=n){const r=n.shape||t.shape,s=r.length;c+=`${e}: ${s}D ${s>0?r:""} `}}console.log(`%c${i}\t%c${o}\t%c${u}D ${l}\t%c${p}\t%c${c}\t%c${a}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function bt(e,t,n,r){const s=ce(t),a=function(e,t,n,r){const s=te(t),a=r[r.length-1],o=new Array(a).fill(0),i=t.length,u="complex64"===n?kt(e):e;if(i>1)for(let e=0;e<s/a;e++){const t=e*a;for(let e=0;e<a;e++)o[e]=Math.max(o[e],xt(u[t+e],0,n).length)}return o}(e,t,n,s),o=t.length,i=wt(e,t,n,s,a),u=["Tensor"];return r&&(u.push(`  dtype: ${n}`),u.push(`  rank: ${o}`),u.push(`  shape: [${t}]`),u.push("  values:")),u.push(i.map((e=>"    "+e)).join("\n")),u.join("\n")}function xt(e,t,n){let r;return r=Array.isArray(e)?`${parseFloat(e[0].toFixed(7))} + ${parseFloat(e[1].toFixed(7))}j`:ue(e)?`'${e}'`:"bool"===n?Nt(e):parseFloat(e.toFixed(7)).toString(),se(r,t)}function Nt(e){return 0===e?"false":"true"}function wt(e,t,n,r,s,a=!0){const o="complex64"===n?2:1,i=t[0],u=t.length;if(0===u){if("complex64"===n){return[xt(kt(e)[0],0,n)]}return"bool"===n?[Nt(e[0])]:[e[0].toString()]}if(1===u){if(i>20){const t=3*o;let r=Array.from(e.slice(0,t)),a=Array.from(e.slice((i-3)*o,i*o));return"complex64"===n&&(r=kt(r),a=kt(a)),["["+r.map(((e,t)=>xt(e,s[t],n))).join(", ")+", ..., "+a.map(((e,t)=>xt(e,s[i-3+t],n))).join(", ")+"]"]}return["["+("complex64"===n?kt(e):Array.from(e)).map(((e,t)=>xt(e,s[t],n))).join(", ")+"]"]}const p=t.slice(1),l=r.slice(1),c=r[0]*o,h=[];if(i>20){for(let t=0;t<3;t++){const r=t*c,a=r+c;h.push(...wt(e.slice(r,a),p,n,l,s,!1))}h.push("...");for(let t=i-3;t<i;t++){const r=t*c,a=r+c;h.push(...wt(e.slice(r,a),p,n,l,s,t===i-1))}}else for(let t=0;t<i;t++){const r=t*c,a=r+c;h.push(...wt(e.slice(r,a),p,n,l,s,t===i-1))}const d=2===u?",":"";h[0]="["+h[0]+d;for(let e=1;e<h.length-1;e++)h[e]=" "+h[e]+d;let m=",\n";for(let e=2;e<u;e++)m+="\n";return h[h.length-1]=" "+h[h.length-1]+"]"+(a?"":m),h}function kt(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class Tt{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=te(e),null!=n){const e=n.length;Y(e===this.size,(()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`))}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||function(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error(`Unknown data type ${e}`);n=new Array(t)}return n}(t,this.size),this.strides=ce(e)}set(e,...t){0===t.length&&(t=[0]),Y(t.length===this.rank,(()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`));const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=${this.shape}`;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return vt().makeTensor(this.values,this.shape,this.dtype)}}let vt=null,_t=null;class St{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=te(e),this.strides=ce(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return _t.buffer(this.shape,this.dtype,e)}bufferSync(){return _t.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return de(this.shape,e,"complex64"===this.dtype)}arraySync(){return de(this.shape,this.dataSync(),"complex64"===this.dtype)}async data(){this.throwIfDisposed();const e=vt().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map((e=>mt(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataToGPU(e){return this.throwIfDisposed(),vt().readToGPU(this.dataId,e)}dataSync(){this.throwIfDisposed();const e=vt().readSync(this.dataId);if("string"===this.dtype)try{return e.map((e=>mt(e)))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await vt().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(vt().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return _t.print(this,e)}clone(){return this.throwIfDisposed(),_t.clone(this)}toString(e=!1){return bt(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),_t.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),vt().makeVariable(this,e,t,n)}}Object.defineProperty(St,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed}),_e("Tensor",(()=>St));class Et extends St{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!ne(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);vt().disposeTensor(this),this.dataId=e.dataId,vt().incRef(this,null)}dispose(){vt().disposeVariable(this),this.isDisposedInternal=!0}}var $t,It,Dt,Ot,At;Object.defineProperty(Et,Symbol.hasInstance,{value:e=>e instanceof St&&null!=e.assign&&e.assign instanceof Function}),function(e){e.R0="R0",e.R1="R1",e.R2="R2",e.R3="R3",e.R4="R4",e.R5="R5",e.R6="R6"}($t||($t={})),function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(It||(It={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(Dt||(Dt={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(Ot||(Ot={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(At||(At={}));const Mt={float32:Ot,int32:It,bool:Dt,complex64:At};function Ct(e,t){if(e.dtype===t.dtype)return[e,t];const n=function(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return Mt[e][t]}(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function Ft(e){const t=[];return Vt(e,t,new Set),t}function Vt(e,t,n){if(null==e)return;if(e instanceof St)return void t.push(e);if(r=e,!Array.isArray(r)&&"object"!=typeof r)return;var r;const s=e;for(const e in s){const r=s[e];n.has(r)||(n.add(r),Vt(r,t,n))}}function zt(e){return null!=e.kernelName}class Rt{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map((e=>e.name))))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Lt{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new Rt}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then((()=>{}));if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(Me(`${e} backend was already registered. Reusing existing backend factory.`),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new ft(this.backendInstance),!0}setupRegisteredKernels(){Re(this.backendName).forEach((e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)}))}disposeRegisteredKernels(e){Re(e).forEach((t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])}))}initializeBackend(e){const t=this.registryFactory[e];if(null==t)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const n=t.factory();if(!n||n instanceof class{refCount(e){return Q("refCount")}incRef(e){return Q("incRef")}timerAvailable(){return!0}time(e){return Q("time")}read(e){return Q("read")}readSync(e){return Q("readSync")}readToGPU(e,t){return Q("readToGPU")}numDataIds(){return Q("numDataIds")}disposeData(e,t){return Q("disposeData")}write(e,t,n){return Q("write")}move(e,t,n,r,s){return Q("move")}memory(){return Q("memory")}floatPrecision(){return Q("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}dispose(){return Q("dispose")}}||"function"!=typeof n.then)return this.registry[e]=n,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,r=n.then((n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0))).catch((n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,Me(`Initialization of backend ${e} failed`),Me(n.stack||n.message)),!1)));return this.pendingBackendInit=r,{success:r,asyncInit:!0}}}catch(t){return Me(`Initialization of backend ${e} failed`),Me(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(`${e} backend not found in registry`);this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort(((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority))}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:s}=this.initializeBackend(n);if(s||r)return{name:n,asyncInit:s}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,s=this.readSync(t),a=r.refCount(t);r.disposeData(t,!0),n.backend=e,e.move(t,s,n.shape,n.dtype,a),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun((()=>this.startScope(r)),(()=>this.endScope(n)),(()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n)))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Lt.nextTensorId++}nextVariableId(){return Lt.nextVariableId++}clone(e){const t=Bt.runKernel(Ee,{x:e}),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],(e=>({x:()=>{const t={x:e},n={dtype:"float32"};return Bt.runKernel(Se,t,n)}})),[],{}),t}runKernel(e,t,n){null==this.backendName&&this.backend;if(!(null!=Ve(e,this.backendName)))throw new Error(`Kernel '${e}' not registered for backend '${this.backendName}'`);return this.runKernelFunc({kernelName:e,inputs:t,attrs:n})}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let s=0;n.forEach((e=>{s+="complex64"===e.dtype?3:1}));const a=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],o=r-t-s-a;if(o>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${o} data ids) after running '${e}'`)}runKernelFunc(e){let t,n=[];const r=this.isTapeOn(),s=this.state.numBytes,a=this.state.numTensors;let o,i;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const u=zt(e)?e.kernelName:null!=this.state.activeScope?this.state.activeScope.name:"";if(zt(e)){const{kernelName:t,inputs:s,attrs:a}=e;null==this.backendName&&this.backend;const u=Ve(t,this.backendName);Y(null!=u,(()=>`Cannot find registered kernel '${t}' for backend '${this.backendName}'`)),o=()=>{const e=this.backend.numDataIds();i=u.kernelFunc({inputs:s,attrs:a,backend:this.backend});const o=Array.isArray(i)?i:[i];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(t,e,o);const p=o.map((e=>null!=e.rank?e:this.makeTensorFromTensorInfo(e)));if(r){const e=this.getTensorsForGradient(t,s,p);n=this.saveTensorsForBackwardMode(e)}return p}}else{const{forwardFunc:t}=e,s=e=>{r&&(n=e.map((e=>this.keep(this.clone(e)))))};o=()=>{const e=this.backend.numDataIds();i=this.tidy((()=>t(this.backend,s)));const n=Array.isArray(i)?i:[i];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(u,e,n),n}}const{inputs:p,attrs:l}=e,c=zt(e)?null:e.backwardsFunc;let h;return this.scopedRun((()=>this.state.kernelDepth++),(()=>this.state.kernelDepth--),(()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(h=this.profiler.profileKernel(u,p,(()=>o())),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(h),t=h.outputs):t=o()})),r&&this.addTapeNode(u,p,t,c,n,l),this.state.profiling&&this.state.activeProfile.kernels.push({name:u,bytesAdded:this.state.numBytes-s,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-a,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(p).map((e=>null!=p[e]?p[e].shape:null)),outputShapes:t.map((e=>e.shape)),kernelTimeMs:h.timeMs,extraInfo:h.extraInfo}),Array.isArray(i)?t:t[0]}saveTensorsForBackwardMode(e){const t=e.map((e=>this.keep(this.clone(e))));return t}getTensorsForGradient(e,t,n){const r=ze(e);if(null!=r){const e=r.inputsToSave||[],s=r.outputsToSave||[];let a;r.saveAllInputs?(Y(Array.isArray(t),(()=>"saveAllInputs is true, expected inputs to be an array.")),a=Object.keys(t).map((e=>t[e]))):a=e.map((e=>t[e]));const o=n.filter(((e,t)=>s[t]));return a.concat(o)}return[]}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let s=e;"string"===n&&ue(e[0])&&(s=e.map((e=>function(e,t="utf-8"){return t=t||"utf-8",we().platform.encode(e,t)}(e))));const a=r.write(s,t,n),o=new St(t,n,a,this.nextTensorId());if(this.trackTensor(o,r),"string"===n){const e=this.state.tensorInfo.get(a),t=function(e){if(null==e)return 0;let t=0;return e.forEach((e=>t+=e.length)),t}(s);this.state.numBytes+=t-e.bytes,e.bytes=t}return o}makeTensorFromDataId(e,t,n,r){const s={dataId:e,shape:t,dtype:n=n||"float32"};return this.makeTensorFromTensorInfo(s,r)}makeTensorFromTensorInfo(e,t){const{dataId:n,shape:r,dtype:s}=e,a=new St(r,s,n,this.nextTensorId());return this.trackTensor(a,t),a}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const s=new Et(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[s.name])throw new Error(`Variable with name ${s.name} was already registered`);return this.state.registeredVariables[s.name]=s,this.incRef(s,this.backend),s}trackTensor(e,t){this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*ie(e.dtype)),this.state.numBytes+=n,this.state.tensorInfo.has(e.dataId)||(this.state.numDataBuffers++,this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n})),e instanceof Et||this.track(e)}incRef(e,t){this.trackTensor(e,t),this.backend.incRef(e.dataId)}removeDataId(e,t){this.state.tensorInfo.has(e)&&this.state.tensorInfo.get(e).backend===t&&(this.state.tensorInfo.delete(e),this.state.numDataBuffers--)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;const t=this.state.tensorInfo.get(e.dataId);if(this.state.numTensors--,"string"===e.dtype&&(this.state.numStringTensors--,this.state.numBytes-=t.bytes),"complex64"!==e.dtype&&"string"!==e.dtype){const t=e.size*ie(e.dtype);this.state.numBytes-=t}t.backend.disposeData(e.dataId)&&this.removeDataId(e.dataId,t.backend)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map((e=>e.totalBytesSnapshot))),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,s,a){const o={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:s},i=ze(e);null!=i&&(r=i.gradFunc),null!=r&&(o.gradient=e=>(e=e.map(((e,t)=>{if(null==e){const e=n[t],r=fe(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e})),r(e.length>1?e:e[0],s,a))),this.state.activeTape.push(o)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=Ft(e),n=new Set(t.map((e=>e.id)));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach((e=>{e.kept||e.scopeId!==r.id||this.track(e)}))}gradients(e,t,n,r=!1){if(Y(t.length>0,(()=>"gradients() received an empty list of xs.")),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const s=this.scopedRun((()=>this.startTape()),(()=>this.endTape()),(()=>this.tidy("forward",e)));Y(s instanceof St,(()=>"The result y returned by f() must be a tensor."));const a=function(e,t,n){const r={},s={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const a=e[n],o=a.inputs;for(const e in o){const n=o[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){a.outputs.forEach((e=>r[e.id]=!0)),i=!0,s[a.id]=!0;break}if(i)break}}const a={};a[n.id]=!0;const o={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(a[n.outputs[e].id]){for(const e in r)a[r[e].id]=!0,o[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(s[n.id]&&o[n.id]){const e={};for(const t in n.inputs){const s=n.inputs[t];r[s.id]&&(e[t]=s)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,s);if(!r&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",(()=>{const e={};e[s.id]=null==n?function(e){const t=me(te(e),"float32");return Bt.makeTensor(t,e,"float32")}(s.shape):n,function(e,t,n,r){for(let s=t.length-1;s>=0;s--){const a=t[s],o=[];if(a.outputs.forEach((t=>{const n=e[t.id];null!=n?o.push(n):o.push(null)})),null==a.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${a.kernelName}.`);const i=a.gradient(o);for(const t in a.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const s=n((()=>i[t]()));if("float32"!==s.dtype)throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${s.dtype}'`);const o=a.inputs[t];if(!ne(s.shape,o.shape))throw new Error(`Error in gradient for op ${a.kernelName}. The gradient of input '${t}' has shape '${s.shape}', which does not match the shape of the input '${o.shape}'`);if(null==e[o.id])e[o.id]=s;else{const t=e[o.id];e[o.id]=r(t,s),t.dispose()}}}}(e,a,(e=>this.tidy(e)),Pt);const r=t.map((t=>e[t.id]));return 0===this.state.gradientDepth&&(this.state.activeTape.forEach((e=>{for(const t of e.saved)t.dispose()})),this.state.activeTape=null),{value:s,grads:r}}))}customGrad(e){return Y(le(e),(()=>"The f passed in customGrad(f) must be a function.")),(...t)=>{let n;Y(t.every((e=>e instanceof St)),(()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors"));const r={};t.forEach(((e,t)=>{r[t]=e}));return this.runKernelFunc({forwardFunc:(r,s)=>(n=e(...t,s),Y(n.value instanceof St,(()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor")),Y(le(n.gradFunc),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function.")),n.value),backwardsFunc:(e,r)=>{const s=n.gradFunc(e,r),a=Array.isArray(s)?s:[s];Y(a.length===t.length,(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...).")),Y(a.every((e=>e instanceof St)),(()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors."));const o={};return a.forEach(((e,t)=>{o[t]=()=>e})),o},inputs:r})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}readToGPU(e,t){return this.state.tensorInfo.get(e).backend.readToGPU(e,t)}async time(e){const t=dt(),n=await this.backend.time(e);return n.wallMs=dt()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new Rt;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}Lt.nextTensorId=0,Lt.nextVariableId=0;const Bt=function(){const e=ve();if(null==e._tfengine){const t=new xe(e);e._tfengine=new Lt(t)}var t;return t=e._tfengine.ENV,Te=t,vt=()=>e._tfengine,e._tfengine}();function Pt(e,t){const n={a:e,b:t};return Bt.runKernel("Add",n)}function Kt(e,t){let n=e;if(oe(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||oe(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&we().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&qt(e,r,[]),r}function qt(e,t,n){if(n=n||[],!Array.isArray(e)&&!oe(e))return void Y(0===t.length,(()=>`Element arr[${n.join("][")}] is a primitive, but should be an array/TypedArray of ${t[0]} elements`));Y(t.length>0,(()=>`Element arr[${n.join("][")}] should be a primitive, but is an array of ${e.length} elements`)),Y(e.length===t[0],(()=>`Element arr[${n.join("][")}] should have ${t[0]} elements, but has ${e.length} elements`));const r=t.slice(1);for(let t=0;t<e.length;++t)qt(e[t],r,n.concat(t))}function Ut(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function Wt(e,t,n,r="numeric"){if(e instanceof St)return Ut(r,e.dtype,t,n),e;let s=pe(e);if("string"!==s&&["bool","int32","float32"].indexOf(r)>=0&&(s=r),Ut(r,s,t,n),null==e||!oe(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const a=Kt(e,s);oe(e)||Array.isArray(e)||(e=[e]);const o="string"!==s?ht(e,s):ee(e,[],!0);return Bt.makeTensor(o,a,s)}function jt(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map(((e,s)=>Wt(e,`${t}[${s}]`,n,r)))}const Ht="__op";function Gt(e){const t=Object.keys(e);if(1!==t.length)throw new Error(`Please provide an object with a single key (operation name) mapping to a function. Got an object with ${t.length} keys.`);let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+=Ht;const s=(...e)=>{Bt.startScope(n);try{const t=r(...e);return ge(t)&&console.error("Cannot return a Promise inside of tidy."),Bt.endScope(t),t}catch(e){throw Bt.endScope(null),e}};return Object.defineProperty(s,"name",{value:n,configurable:!0}),s}const Zt=Gt({abs_:function(e){const t=Wt(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return Bt.runKernel("ComplexAbs",e)}{const e={x:t};return Bt.runKernel("Abs",e)}}});const Qt=Gt({acos_:function(e){const t={x:Wt(e,"x","acos")};return Bt.runKernel("Acos",t)}});const Yt=Gt({acosh_:function(e){const t={x:Wt(e,"x","acosh")};return Bt.runKernel("Acosh",t)}});const Xt=Gt({add_:function(e,t){let n=Wt(e,"a","add"),r=Wt(t,"b","add");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Add",s)}});const Jt=Gt({addN_:function(e){Y(Array.isArray(e),(()=>"The argument passed to tf.addN() must be a list of tensors")),Y(e.length>=1,(()=>`Must pass at least one tensor to tf.addN(), but got ${e.length}`));const t=e.map(((e,t)=>Wt(e,`tensors${t}`,"addN"))),n=t[0];t.forEach((e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")})),t.forEach((e=>{if(!ne(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")}));const r=t;return Bt.runKernel("AddN",r)}});const en=Gt({all_:function(e,t=null,n=!1){const r={x:Wt(e,"x","all","bool")},s={axis:t,keepDims:n};return Bt.runKernel("All",r,s)}});const tn=Gt({any_:function(e,t=null,n=!1){const r={x:Wt(e,"x","any","bool")},s={axis:t,keepDims:n};return Bt.runKernel("Any",r,s)}});const nn=Gt({argMax_:function(e,t=0){const n={x:Wt(e,"x","argMax")},r={axis:t};return Bt.runKernel("ArgMax",n,r)}});const rn=Gt({argMin_:function(e,t=0){const n={x:Wt(e,"x","argMin")},r={axis:t};return Bt.runKernel("ArgMin",n,r)}});const sn=Gt({asin_:function(e){const t={x:Wt(e,"x","asin")};return Bt.runKernel("Asin",t)}});const an=Gt({asinh_:function(e){const t={x:Wt(e,"x","asinh")};return Bt.runKernel("Asinh",t)}});const on=Gt({atan_:function(e){const t={x:Wt(e,"x","atan")};return Bt.runKernel("Atan",t)}});const un=Gt({atan2_:function(e,t){let n=Wt(e,"a","atan2"),r=Wt(t,"b","atan2");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Atan2",s)}});const pn=Gt({atanh_:function(e){const t={x:Wt(e,"x","atanh")};return Bt.runKernel("Atanh",t)}});const ln=Gt({cast_:function(e,t){const n=Wt(e,"x","cast");if(!function(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}(t))throw new Error(`Failed to cast to unknown dtype ${t}`);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},s={dtype:t};return Bt.runKernel(Se,r,s)}});function cn(e,t,n,r,s,a,o=!1,i="channelsLast"){let[u,p,l,c]=[-1,-1,-1,-1];if("channelsLast"===i)[u,p,l,c]=e;else{if("channelsFirst"!==i)throw new Error(`Unknown dataFormat ${i}`);[u,c,p,l]=e}const[h,d,,m]=t,[f,y]=hn(n),[g,b]=hn(r),x=dn(h,g),N=dn(d,b),{padInfo:w,outHeight:k,outWidth:T}=function(e,t,n,r,s,a,o,i,u){let p,l,c;if("number"==typeof e){p={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,s){null==r&&(r=function(e,t,n,r=1){const s=dn(t,r);return Math.floor((e[0]*(n-1)-n+s)/2)}(e,t,n));const a=e[0],o=e[1],i=mn((a-t+2*r)/n+1,s),u=mn((o-t+2*r)/n+1,s);return[i,u]}([t,n],a,r,e,i);l=s[0],c=s[1]}else if("same"===e){l=Math.ceil(t/r),c=Math.ceil(n/s);const e=Math.max(0,(l-1)*r+a-t),i=Math.max(0,(c-1)*s+o-n),u=Math.floor(e/2),h=e-u,d=Math.floor(i/2);p={top:u,bottom:h,left:d,right:i-d,type:"SAME"}}else if("valid"===e)p={top:0,bottom:0,left:0,right:0,type:"VALID"},l=Math.ceil((t-a+1)/r),c=Math.ceil((n-o+1)/s);else{if("object"!=typeof e)throw Error(`Unknown padding parameter: ${e}`);{const h="channelsLast"===u?e[1][0]:e[2][0],d="channelsLast"===u?e[1][1]:e[2][1],m="channelsLast"===u?e[2][0]:e[3][0],f="channelsLast"===u?e[2][1]:e[3][1];p={top:h,bottom:d,left:m,right:f,type:0===h&&0===d&&0===m&&0===f?"VALID":"EXPLICIT"},l=mn((t-a+h+d)/r+1,i),c=mn((n-o+m+f)/s+1,i)}}return{padInfo:p,outHeight:l,outWidth:c}}(s,p,l,f,y,x,N,a,i),v=o?m*c:m;let _;return"channelsFirst"===i?_=[u,v,k,T]:"channelsLast"===i&&(_=[u,k,T,v]),{batchSize:u,dataFormat:i,inHeight:p,inWidth:l,inChannels:c,outHeight:k,outWidth:T,outChannels:v,padInfo:w,strideHeight:f,strideWidth:y,filterHeight:h,filterWidth:d,effectiveFilterHeight:x,effectiveFilterWidth:N,dilationHeight:g,dilationWidth:b,inShape:e,outShape:_,filterShape:t}}function hn(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function dn(e,t){return t<=1?e:e+(e-1)*(t-1)}function mn(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error(`Unknown roundingMode ${t}`)}}function fn(e){const[t,n,r]=hn(e);return 1===t&&1===n&&1===r}function yn(e,t){return fn(e)||fn(t)}function gn(e,t,n){if(null!=n){if("string"==typeof t)throw Error(`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`);if("number"==typeof t)Y(re(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`));else{if("object"!=typeof t)throw Error(`Error in ${e}: Unknown padding parameter: ${t}`);t.forEach((t=>{t.forEach((t=>{Y(re(t),(()=>`Error in ${e}: pad must be an integer when using dimRoundingMode ${n} but got pad ${t}.`))}))}))}}}const bn=Gt({reshape_:function(e,t){const n={x:Wt(e,"x","reshape","string_or_numeric")},r={shape:t};return Bt.runKernel("Reshape",n,r)}});const xn=Gt({avgPool_:function(e,t,n,r,s){const a=Wt(e,"x","avgPool","float32");Y(yn(n,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`));let o=a,i=!1;3===a.rank&&(i=!0,o=bn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),Y(4===o.rank,(()=>`Error in avgPool: x must be rank 4 but got rank ${o.rank}.`)),gn("avgPool",r,s);const u={x:o},p={filterSize:t,strides:n,pad:r,dimRoundingMode:s};let l=Bt.runKernel("AvgPool",u,p);return l=ln(l,a.dtype),i?bn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const Nn=Gt({avgPool3d_:function(e,t,n,r,s,a="NDHWC"){const o=Wt(e,"x","avgPool3d","float32");let i=o,u=!1;4===o.rank&&(u=!0,i=bn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),Y(5===i.rank,(()=>`Error in avgPool3d: x must be rank 5 but got rank ${i.rank}.`)),Y("NDHWC"===a,(()=>`Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),gn("avgPool3d",r,s);const p={x:i},l={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:a};let c=Bt.runKernel("AvgPool3D",p,l);return c=ln(c,i.dtype),u?bn(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const wn=Gt({clone_:function(e){const t={x:Wt(e,"x","clone","string_or_numeric")};return Bt.runKernel(Ee,t)}});const kn=Gt({concat_:function(e,t=0){Y(e.length>=1,(()=>"Pass at least one tensor to concat"));const n=jt(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach((e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)})),1===n.length)return wn(n[0]);const r=n,s={axis:t};return Bt.runKernel("Concat",r,s)}});const Tn=Gt({matMul_:function(e,t,n=!1,r=!1){let s=Wt(e,"a","matMul"),a=Wt(t,"b","matMul");[s,a]=Ct(s,a);const o={a:s,b:a},i={transposeA:n,transposeB:r};return Bt.runKernel("BatchMatMul",o,i)}});const vn=Gt({mul_:function(e,t){let n=Wt(e,"a","mul"),r=Wt(t,"b","mul");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Multiply",s)}});const _n=Gt({sigmoid_:function(e){const t={x:Wt(e,"x","sigmoid","float32")};return Bt.runKernel("Sigmoid",t)}});const Sn=Gt({slice_:function(e,t,n){const r=Wt(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const s={x:r},a={begin:t,size:n};return Bt.runKernel("Slice",s,a)}});const En=Gt({tanh_:function(e){const t={x:Wt(e,"x","tanh","float32")};return Bt.runKernel("Tanh",t)}});const $n=Gt({basicLSTMCell_:function(e,t,n,r,s,a){const o=Wt(e,"forgetBias","basicLSTMCell"),i=Wt(t,"lstmKernel","basicLSTMCell"),u=Wt(n,"lstmBias","basicLSTMCell"),p=Wt(r,"data","basicLSTMCell"),l=Wt(s,"c","basicLSTMCell"),c=Wt(a,"h","basicLSTMCell"),h=kn([p,c],1),d=Tn(h,i),m=Xt(d,u),f=m.shape[0],y=m.shape[1]/4,g=[f,y],b=Sn(m,[0,0],g),x=Sn(m,[0,y],g),N=Sn(m,[0,2*y],g),w=Sn(m,[0,3*y],g),k=Xt(vn(_n(b),En(x)),vn(l,_n(Xt(o,N))));return[k,vn(En(k),_n(w))]}});const In=Gt({batchToSpaceND_:function(e,t,n){const r=Wt(e,"x","batchToSpaceND"),s=t.reduce(((e,t)=>e*t));Y(r.rank>=1+t.length,(()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`)),Y(n.length===t.length,(()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`)),Y(r.shape[0]%s==0,(()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${s}`));const a={x:r},o={blockShape:t,crops:n};return Bt.runKernel("BatchToSpaceND",a,o)}});const Dn=Gt({batchNorm_:function(e,t,n,r,s,a){null==a&&(a=.001);const o=Wt(e,"x","batchNorm"),i=Wt(t,"mean","batchNorm"),u=Wt(n,"variance","batchNorm");let p,l;null!=s&&(p=Wt(s,"scale","batchNorm")),null!=r&&(l=Wt(r,"offset","batchNorm")),Y(i.rank===u.rank,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),Y(null==l||i.rank===l.rank,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),Y(null==p||i.rank===p.rank,(()=>"Batch normalization gradient requires mean and scale to have equal ranks."));const c=function(e){let t;return t=0===e.rank||1===e.rank?bn(e,[1,1,1,e.size]):2===e.rank?bn(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?bn(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(o),h={x:c,scale:p,offset:l,mean:i,variance:u},d={varianceEpsilon:a},m=Bt.runKernel("FusedBatchNorm",h,d);return bn(m,o.shape)}});const On=Gt({batchNorm2d_:function(e,t,n,r,s,a){const o=Wt(e,"x","batchNorm"),i=Wt(t,"mean","batchNorm"),u=Wt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Wt(s,"scale","batchNorm")),null!=r&&(l=Wt(r,"offset","batchNorm")),Y(2===o.rank,(()=>`Error in batchNorm2D: x must be rank 2 but got rank ${o.rank}.`)),Y(2===i.rank||1===i.rank,(()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${i.rank}.`)),Y(2===u.rank||1===u.rank,(()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${u.rank}.`)),null!=p&&Y(2===p.rank||1===p.rank,(()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${p.rank}.`)),null!=l&&Y(2===l.rank||1===l.rank,(()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${l.rank}.`)),Dn(o,i,u,l,p,a)}});const An=Gt({batchNorm3d_:function(e,t,n,r,s,a){const o=Wt(e,"x","batchNorm"),i=Wt(t,"mean","batchNorm"),u=Wt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Wt(s,"scale","batchNorm")),null!=r&&(l=Wt(r,"offset","batchNorm")),Y(3===o.rank,(()=>`Error in batchNorm3D: x must be rank 3 but got rank ${o.rank}.`)),Y(3===i.rank||1===i.rank,(()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${i.rank}.`)),Y(3===u.rank||1===u.rank,(()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${u.rank}.`)),null!=p&&Y(3===p.rank||1===p.rank,(()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${p.rank}.`)),null!=l&&Y(3===l.rank||1===l.rank,(()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${l.rank}.`)),Dn(o,i,u,l,p,a)}});const Mn=Gt({batchNorm4d_:function(e,t,n,r,s,a){const o=Wt(e,"x","batchNorm"),i=Wt(t,"mean","batchNorm"),u=Wt(n,"variance","batchNorm");let p,l;return null!=s&&(p=Wt(s,"scale","batchNorm")),null!=r&&(l=Wt(r,"offset","batchNorm")),Y(4===o.rank,(()=>`Error in batchNorm4D: x must be rank 4 but got rank ${o.rank}.`)),Y(4===i.rank||1===i.rank,(()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${i.rank}.`)),Y(4===u.rank||1===u.rank,(()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${u.rank}.`)),null!=p&&Y(4===p.rank||1===p.rank,(()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${p.rank}.`)),null!=l&&Y(4===l.rank||1===l.rank,(()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${l.rank}.`)),Dn(o,i,u,l,p,a)}});const Cn=Gt({bincount_:function(e,t,n){const r=Wt(e,"x","bincount"),s=Wt(t,"weights","bincount");Y("int32"===r.dtype,(()=>`Error in bincount: input dtype must be int32, but got ${r.dtype}`)),Y(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Y(s.size===r.size||0===s.size,(()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: ${s.shape}.`));const a={x:r,weights:s},o={size:n};return Bt.runKernel("Bincount",a,o)}});const Fn=Gt({broadcastArgs_:function(e,t){const n=Wt(e,"s0","broadcastArgs","int32"),r=Wt(t,"s1","broadcastArgs","int32");if(1!==n.rank)throw new Error(`broadcastArgs(): first input must be a vector (rank=1). Has rank ${n.rank}`);if(1!==r.rank)throw new Error(`broadcastArgs(): second input must be a vector (rank=1). Has rank ${r.rank}`);const s={s0:n,s1:r};return Bt.runKernel("BroadcastArgs",s)}});const Vn=Gt({broadcastTo_:function(e,t){let n=Wt(e,"broadcastTo","x");const r=n.shape;if(t.some((e=>!(e>0)||e%1!=0)))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=bn(n,e)}const s=n.shape,a=Array.from(t);for(let e=t.length-1;e>=0;e--)if(s[e]===t[e])a[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===a.map(((e,t)=>e>1?t:-1)).filter((e=>e>=0)).length)return wn(n);const o={x:n},i={reps:a};return Bt.runKernel($e,o,i)}});function zn(e,t="float32",n){return t=t||"float32",ye(e),new Tt(e,t,n)}const Rn=Gt({ceil_:function(e){const t={x:Wt(e,"x","ceil","float32")};return Bt.runKernel("Ceil",t)}});const Ln=Gt({clipByValue_:function(e,t,n){const r=Wt(e,"x","clipByValue");Y(t<=n,(()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`));const s={x:r},a={clipValueMin:t,clipValueMax:n};return Bt.runKernel("ClipByValue",s,a)}});const Bn=Gt({complex_:function(e,t){const n=Wt(e,"real","complex"),r=Wt(t,"imag","complex");X(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const s={real:n,imag:r};return Bt.runKernel("Complex",s)}});const Pn=Gt({concat1d_:function(e){return kn(e,0)}});const Kn=Gt({concat2d_:function(e,t){return kn(e,t)}});const qn=Gt({concat3d_:function(e,t){return kn(e,t)}});const Un=Gt({concat4d_:function(e,t){return kn(e,t)}});const Wn=Gt({conv2d_:function(e,t,n,r,s="NHWC",a=[1,1],o){const i=Wt(e,"x","conv2d","float32"),u=Wt(t,"filter","conv2d","float32");let p=i,l=!1;3===i.rank&&(l=!0,p=bn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Y(4===p.rank,(()=>`Error in conv2d: input must be rank 4, but got rank ${p.rank}.`)),Y(4===u.rank,(()=>`Error in conv2d: filter must be rank 4, but got rank ${u.rank}.`)),gn("conv2d",r,o);const c="NHWC"===s?p.shape[3]:p.shape[1];Y(c===u.shape[2],(()=>`Error in conv2d: depth of input (${c}) must match input depth for filter ${u.shape[2]}.`)),Y(yn(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const h={x:p,filter:u},d={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o},m=Bt.runKernel("Conv2D",h,d);return l?bn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const jn=Gt({conv1d_:function(e,t,n,r,s="NWC",a=1,o){const i=Wt(e,"x","conv1d"),u=Wt(t,"filter","conv1d");let p=i,l=!1;2===i.rank&&(l=!0,p=bn(i,[1,i.shape[0],i.shape[1]])),Y(3===p.rank,(()=>`Error in conv1d: input must be rank 3, but got rank ${p.rank}.`)),Y(3===u.rank,(()=>`Error in conv1d: filter must be rank 3, but got rank ${u.rank}.`)),gn("conv1d",r,o),Y(p.shape[2]===u.shape[1],(()=>`Error in conv1d: depth of input (${p.shape[2]}) must match input depth for filter ${u.shape[1]}.`)),Y(yn(n,a),(()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`)),Y("NWC"===s,(()=>`Error in conv1d: got dataFormat of ${s} but only NWC is currently supported.`));const c=bn(u,[1,u.shape[0],u.shape[1],u.shape[2]]),h=bn(p,[p.shape[0],1,p.shape[1],p.shape[2]]),d=Wn(h,c,[1,n],r,"NHWC",[1,a],o);return bn(d,l?[d.shape[2],d.shape[3]]:[d.shape[0],d.shape[2],d.shape[3]])}});const Hn=Gt({conv2DBackpropInput_:function(e,t,n,r,s,a="NHWC",o){Y(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let i=e,u=t,p=!1;3===t.rank&&(p=!0,u=bn(t,[1,t.shape[0],t.shape[1],t.shape[2]]),i=[1,e[0],e[1],e[2]]),Y(4===i.length,(()=>`Error in conv2dDerInput: inShape must be length 4, but got length ${i.length}.`)),Y(4===u.rank,(()=>`Error in conv2dDerInput: dy must be rank 4, but got rank ${u.rank}`)),Y(4===n.rank,(()=>`Error in conv2dDerInput: filter must be rank 4, but got rank ${n.rank}`));const l="NHWC"===a?i[3]:i[1],c="NHWC"===a?u.shape[3]:u.shape[1];Y(l===n.shape[2],(()=>`Error in conv2dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[2]}.`)),Y(c===n.shape[3],(()=>`Error in conv2dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[3]}.`)),gn("conv2dDerInput",s,o);const h={dy:u,filter:n},d={strides:r,pad:s,dataFormat:a,dimRoundingMode:o,inputShape:i},m=Bt.runKernel("Conv2DBackpropInput",h,d);return p?bn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Gn=Gt({conv2dTranspose_:function(e,t,n,r,s,a){const o=Wt(e,"x","conv2dTranspose"),i=Wt(t,"filter","conv2dTranspose");return Hn(n,o,i,r,s,"NHWC",a)}});const Zn=Gt({conv3d_:function(e,t,n,r,s="NDHWC",a=[1,1,1]){const o=Wt(e,"x","conv3d"),i=Wt(t,"filter","conv3d");let u=o,p=!1;4===o.rank&&(p=!0,u=bn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),Y(5===u.rank,(()=>`Error in conv3d: input must be rank 5, but got rank ${u.rank}.`)),Y(5===i.rank,(()=>`Error in conv3d: filter must be rank 5, but got rank ${i.rank}.`)),Y(u.shape[4]===i.shape[3],(()=>`Error in conv3d: depth of input (${u.shape[4]}) must match input depth for filter ${i.shape[3]}.`)),Y(yn(n,a),(()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),Y("NDHWC"===s,(()=>`Error in conv3d: got dataFormat of ${s} but only NDHWC is currently supported.`));const l={x:u,filter:i},c={strides:n,pad:r,dataFormat:s,dilations:a},h=Bt.runKernel("Conv3D",l,c);return p?bn(h,[h.shape[1],h.shape[2],h.shape[3],h.shape[4]]):h}});const Qn=Gt({conv3DBackpropInput_:function(e,t,n,r,s){Y(e.length===t.rank,(()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`));let a=e,o=t,i=!1;4===t.rank&&(i=!0,o=bn(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const u=a[4],p=o.shape[4];Y(5===a.length,(()=>`Error in conv3dDerInput: inShape must be length 5, but got length ${a.length}.`)),Y(5===o.rank,(()=>`Error in conv3dDerInput: dy must be rank 5, but got rank ${o.rank}`)),Y(5===n.rank,(()=>`Error in conv3dDerInput: filter must be rank 5, but got rank ${n.rank}`)),Y(u===n.shape[3],(()=>`Error in conv3dDerInput: depth of input (${u}) must match input depth for filter ${n.shape[3]}.`)),Y(p===n.shape[4],(()=>`Error in conv3dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[4]}.`));const l={dy:o,filter:n},c={pad:s,strides:r,inputShape:a},h=Bt.runKernel("Conv3DBackpropInputV2",l,c);return i?bn(h,[h.shape[1],h.shape[2],h.shape[3],h.shape[4]]):h}});const Yn=Gt({conv3dTranspose_:function(e,t,n,r,s){const a=Wt(e,"x","conv3dTranspose"),o=Wt(t,"filter","conv3dTranspose");return Qn(n,a,o,r,s)}});const Xn=Gt({cos_:function(e){const t={x:Wt(e,"x","cos","float32")};return Bt.runKernel("Cos",t)}});const Jn=Gt({cosh_:function(e){const t={x:Wt(e,"x","cosh","float32")};return Bt.runKernel("Cosh",t)}});const er=Gt({cumprod_:function(e,t=0,n=!1,r=!1){const s={x:Wt(e,"x","cumprod")},a={axis:t,exclusive:n,reverse:r};return Bt.runKernel("Cumprod",s,a)}});const tr=Gt({cumsum_:function(e,t=0,n=!1,r=!1){const s={x:Wt(e,"x","cumsum")},a={axis:t,exclusive:n,reverse:r};return Bt.runKernel("Cumsum",s,a)}});const nr=Gt({denseBincount_:function(e,t,n,r=!1){const s=Wt(e,"x","denseBincount"),a=Wt(t,"weights","denseBincount");Y("int32"===s.dtype,(()=>`Error in denseBincount: input dtype must be int32, but got ${s.dtype}`)),Y(s.rank<=2,(()=>`Error in denseBincount: input must be at most rank 2, but got rank ${s.rank}.`)),Y(n>=0,(()=>`size must be non-negative, but got ${n}.`)),Y(a.size===s.size||0===a.size,(()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${s.shape}, weights shape: ${a.shape}.`));const o={x:s,weights:a},i={size:n,binaryOutput:r};return Bt.runKernel("DenseBincount",o,i)}});const rr=Gt({depthToSpace_:function(e,t,n="NHWC"){const r=Wt(e,"x","depthToSpace","float32"),s="NHWC"===n?r.shape[1]:r.shape[2],a="NHWC"===n?r.shape[2]:r.shape[3],o="NHWC"===n?r.shape[3]:r.shape[1];Y(t>1,(()=>`blockSize should be > 1 for depthToSpace, but was: ${t}`)),Y(s*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${s} and ${t}  for depthToSpace with input shape\n    ${r.shape}`)),Y(a*t>=0,(()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${r.shape}`)),Y(o%(t*t)==0,(()=>`Dimension size must be evenly divisible by ${t*t} but is ${o} for depthToSpace with input shape ${r.shape}`));const i={x:r},u={blockSize:t,dataFormat:n};return Bt.runKernel("DepthToSpace",i,u)}});const sr=Gt({depthwiseConv2d_:function(e,t,n,r,s="NHWC",a=[1,1],o){const i=Wt(e,"x","depthwiseConv2d","float32"),u=Wt(t,"filter","depthwiseConv2d","float32");let p=i,l=!1;3===i.rank&&(l=!0,p=bn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Y(4===p.rank,(()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${p.rank}.`)),Y(4===u.rank,(()=>`Error in depthwiseConv2d: filter must be rank 4, but got rank ${u.rank}.`));const c="NHWC"===s?p.shape[3]:p.shape[1];Y(c===u.shape[2],(()=>`Error in depthwiseConv2d: number of input channels (${c}) must match the inChannels dimension in filter ${u.shape[2]}.`)),gn("depthwiseConv2d",r,o);const h={x:p,filter:u},d={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o},m=Bt.runKernel("DepthwiseConv2dNative",h,d);return l?bn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const ar=Gt({diag_:function(e){const t={x:Wt(e,"x","diag")};return Bt.runKernel("Diag",t)}});const or=Gt({dilation2d_:function(e,t,n,r,s=[1,1],a="NHWC"){const o=Wt(e,"x","dilation2d"),i=Wt(t,"filter","dilation2d");Y(3===o.rank||4===o.rank,(()=>`Error in dilation2d: input must be rank 3 or 4, but got rank ${o.rank}.`)),Y(3===i.rank,(()=>`Error in dilation2d: filter must be rank 3, but got rank ${i.rank}.`)),Y("NHWC"===a,(()=>`Error in dilation2d: Only NHWC is currently supported, but got dataFormat of ${a}`));let u=o,p=!1;3===o.rank&&(u=bn(o,[1,o.shape[0],o.shape[1],o.shape[2]]),p=!0);const l={x:u,filter:i},c={strides:n,pad:r,dilations:s},h=Bt.runKernel("Dilation2D",l,c);return p?bn(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const ir=Gt({floorDiv_:function(e,t){let n=Wt(e,"a","floorDiv"),r=Wt(t,"b","floorDiv");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("FloorDiv",s)}});const ur=Gt({div_:function(e,t){let n=Wt(e,"a","div"),r=Wt(t,"b","div");if([n,r]=Ct(n,r),"int32"===n.dtype&&"int32"===r.dtype)return ir(n,r);const s={a:n,b:r};return Bt.runKernel("RealDiv",s,{})}});function pr(e,t){const n=[],r=Math.max(e.length,t.length);for(let s=0;s<r;s++){let r=e[e.length-s-1];null==r&&(r=1);let a=t[t.length-s-1];if(null==a&&(a=1),1===r)n.unshift(a);else if(1===a)n.unshift(r);else{if(r!==a){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}const lr=Gt({equal_:function(e,t){let n=Wt(e,"a","equal","string_or_numeric"),r=Wt(t,"b","equal","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("Equal",s)}});const cr=Gt({where_:function(e,t,n){const r=Wt(t,"a","where"),s=Wt(n,"b","where"),a=Wt(e,"condition","where","bool"),o=pr(pr(a.shape,r.shape),s.shape),i={condition:Vn(a,o),t:Vn(r,o),e:Vn(s,o)};return Bt.runKernel("Select",i)}});const hr=Gt({zerosLike_:function(e){const t={x:Wt(e,"x","zerosLike")};return Bt.runKernel("ZerosLike",t)}});const dr=Gt({divNoNan_:function(e,t){let n=Wt(e,"a","div"),r=Wt(t,"b","div");[n,r]=Ct(n,r);const s=ur(n,r),a=hr(s),o=lr(r,a);return cr(o,a,s)}});const mr=Gt({dot_:function(e,t){const n=Wt(e,"t1","dot"),r=Wt(t,"t2","dot");Y(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),(()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`));const s=1===n.rank?n.size:n.shape[1],a=1===r.rank?r.size:r.shape[0];if(Y(s===a,(()=>`Error in dot: inner dimensions of inputs must match, but got ${s} and ${a}.`)),1===n.rank&&1===r.rank){const e=bn(n,[1,-1]),t=bn(r,[-1,1]),s=Tn(e,t);return bn(s,[])}if(1===n.rank&&2===r.rank){const e=bn(n,[1,-1]),t=bn(r,[r.shape[0],r.shape[1]]),s=Tn(e,t);return bn(s,[s.size])}if(2===n.rank&&1===r.rank){const e=bn(r,[-1,1]),t=Tn(n,e);return bn(t,[t.size])}{const e=bn(r,[r.shape[0],r.shape[1]]);return Tn(n,e)}}});const fr=Gt({einsum_:function(e,...t){const n=t.map(((e,t)=>Wt(e,`tensors${t}`,"einsum"))),r={equation:e};return Bt.runKernel("Einsum",n,r)}});const yr=Gt({elu_:function(e){const t={x:Wt(e,"x","elu","float32")};return Bt.runKernel("Elu",t)}});const gr=Gt({erf_:function(e){let t=Wt(e,"x","erf");Y("int32"===t.dtype||"float32"===t.dtype,(()=>"Input dtype must be `int32` or `float32`.")),"int32"===t.dtype&&(t=ln(t,"float32"));const n={x:t};return Bt.runKernel("Erf",n)}});function br(e,t){return function(e,t,n){const r=e.length+t.length,s=[];let a=0,o=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?s.push(e[a++]):s.push(t[o++]);return s}(e,t.map((e=>1)),t)}const xr=Gt({max_:function(e,t=null,n=!1){const r={x:Wt(e,"x","max")},s={reductionIndices:t,keepDims:n};return Bt.runKernel("Max",r,s)}});const Nr=Gt({min_:function(e,t=null,n=!1){const r={x:Wt(e,"x","min")},s={axis:t,keepDims:n};return Bt.runKernel("Min",r,s)}});const wr=Gt({pow_:function(e,t){let n=Wt(e,"base","pow"),r=Wt(t,"exp","pow");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Pow",s)}});function kr(e,t,n,r){if(null==r&&(r=pe(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!oe(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){ye(t);const e=te(t),r=te(n);Y(e===r,(()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`));for(let e=0;e<n.length;++e){const r=n[e],s=e!==n.length-1||r!==te(t.slice(e));Y(n[e]===t[e]||!s,(()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `))}}return oe(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?ht(e,r):ee(e,[],!0),Bt.makeTensor(e,t,r)}function Tr(e,t){if((oe(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&oe(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return kr(e,[],[],t)}const vr=Gt({sqrt_:function(e){const t={x:Wt(e,"x","sqrt","float32")};return Bt.runKernel("Sqrt",t)}});const _r=Gt({square_:function(e){const t=Wt(e,"x","square");return Bt.runKernel("Square",{x:t},{})}});const Sr=Gt({sum_:function(e,t=null,n=!1){let r=Wt(e,"x","sum");"bool"===r.dtype&&(r=ln(r,"int32"));const s={x:r},a={axis:t,keepDims:n};return Bt.runKernel("Sum",s,a)}});function Er(e,t,n=null){if(0===e.rank)return Zt(e);if(1!==e.rank&&null===n)return Er(bn(e,[-1]),t,n);if(1===e.rank||"number"==typeof n||Array.isArray(n)&&1===n.length){if(1===t)return Sr(Zt(e),n);if(t===1/0)return xr(Zt(e),n);if(t===-1/0)return Nr(Zt(e),n);if("euclidean"===t||2===t)return vr(Sr(wr(Zt(e),Tr(2,"int32")),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}if(Array.isArray(n)&&2===n.length){if(1===t)return xr(Sr(Zt(e),n[0]),n[1]-1);if(t===1/0)return xr(Sr(Zt(e),n[1]),n[0]);if(t===-1/0)return Nr(Sr(Zt(e),n[1]),n[0]);if("fro"===t||"euclidean"===t)return vr(Sr(_r(e),n));throw new Error(`Error in norm: invalid ord value: ${t}`)}throw new Error(`Error in norm: invalid axis: ${n}`)}const $r=Gt({norm_:function(e,t="euclidean",n=null,r=!1){const s=Er(e=Wt(e,"x","norm"),t,n);let a=s.shape;if(r){const t=ae(n,e.shape);a=br(s.shape,t)}return bn(s,a)}});const Ir=Gt({euclideanNorm_:function(e,t=null,n=!1){return $r(e,"euclidean",t,n)}});const Dr=Gt({exp_:function(e){const t={x:Wt(e,"x","exp")};return Bt.runKernel("Exp",t)}});const Or=Gt({expandDims_:function(e,t=0){const n=Wt(e,"x","expandDims","string_or_numeric");Y(t<=n.rank,(()=>"Axis must be <= rank of the tensor"));const r={input:n},s={dim:t};return Bt.runKernel("ExpandDims",r,s)}});const Ar=Gt({expm1_:function(e){const t={x:Wt(e,"x","expm1")};return Bt.runKernel("Expm1",t)}});const Mr=Gt({tile_:function(e,t){const n=Wt(e,"x","tile","string_or_numeric");Y(n.rank===t.length,(()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`));const r={x:n},s={reps:t};return Bt.runKernel($e,r,s)}});const Cr=Gt({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const s=zn([e,t],r),a=e<=t?e:t;for(let e=0;e<a;++e)s.set(1,e,e);const o=bn(s.toTensor(),[e,t]);if(null==n)return o;if(1===n.length)return Mr(Or(o,0),[n[0],1,1]);if(2===n.length)return Mr(Or(Or(o,0),0),[n[0],n[1],1,1]);if(3===n.length)return Mr(Or(Or(Or(o,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Fr(e,t,n){const r={shape:e,value:t,dtype:n};return Bt.runKernel("Fill",{},r)}const Vr=Gt({floor_:function(e){const t={x:Wt(e,"x","floor","float32")};return Bt.runKernel("Floor",t)}});const zr=Gt({gather_:function(e,t,n=0,r=0){const s={x:Wt(e,"x","gather"),indices:Wt(t,"indices","gather","int32")},a={axis:n,batchDims:r};return Bt.runKernel("GatherV2",s,a)}});const Rr=Gt({greater_:function(e,t){let n=Wt(e,"a","greater","string_or_numeric"),r=Wt(t,"b","greater","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("Greater",s)}});const Lr=Gt({greaterEqual_:function(e,t){let n=Wt(e,"a","greaterEqual","string_or_numeric"),r=Wt(t,"b","greaterEqual","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("GreaterEqual",s)}});const Br=Gt({imag_:function(e){const t={input:Wt(e,"input","imag")};return Bt.runKernel("Imag",t)}});const Pr=Gt({isFinite_:function(e){const t={x:Wt(e,"x","isFinite")};return Bt.runKernel("IsFinite",t)}});const Kr=Gt({isInf_:function(e){const t={x:Wt(e,"x","isInf")};return Bt.runKernel("IsInf",t)}});const qr=Gt({isNaN_:function(e){const t={x:Wt(e,"x","isNaN")};return Bt.runKernel("IsNan",t)}});const Ur=Gt({leakyRelu_:function(e,t=.2){const n={x:Wt(e,"x","leakyRelu")},r={alpha:t};return Bt.runKernel("LeakyRelu",n,r)}});const Wr=Gt({less_:function(e,t){let n=Wt(e,"a","less","string_or_numeric"),r=Wt(t,"b","less","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("Less",s)}});const jr=Gt({lessEqual_:function(e,t){let n=Wt(e,"a","lessEqual","string_or_numeric"),r=Wt(t,"b","lessEqual","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("LessEqual",s)}});const Hr=Gt({localResponseNormalization_:function(e,t=5,n=1,r=1,s=.5){const a=Wt(e,"x","localResponseNormalization");Y(4===a.rank||3===a.rank,(()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`)),Y(re(t),(()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`));let o=a,i=!1;3===a.rank&&(i=!0,o=bn(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const u={x:o},p={depthRadius:t,bias:n,alpha:r,beta:s},l=Bt.runKernel("LRN",u,p);return i?bn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const Gr=Gt({log_:function(e){const t={x:Wt(e,"x","log","float32")};return Bt.runKernel("Log",t)}});const Zr=Gt({log1p_:function(e){const t={x:Wt(e,"x","log1p")};return Bt.runKernel("Log1p",t)}});function Qr(e){return Bt.customGrad(e)}const Yr=Gt({neg_:function(e){const t={x:Wt(e,"x","neg")};return Bt.runKernel("Neg",t)}});const Xr=Gt({softplus_:function(e){const t={x:Wt(e,"x","softplus")};return Bt.runKernel("Softplus",t)}});const Jr=Gt({logSigmoid_:function(e){const t=Wt(e,"x","logSigmoid"),n=Qr((e=>({value:Yr(Xr(Yr(e))),gradFunc:t=>vn(t,_n(Yr(e)))})));return n(t)}});const es=Gt({sub_:function(e,t){let n=Wt(e,"a","sub"),r=Wt(t,"b","sub");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Sub",s)}});const ts=Gt({logSoftmax_:function(e,t=-1){const n=Wt(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);const r=Qr(((e,n)=>{const r=xr(e,t,!0),s=es(e,r),a=es(ln(s,"float32"),Gr(Sr(Dr(s),t,!0)));n([a]);return{value:a,gradFunc:(e,n)=>{const[r]=n,s=Dr(r);return es(e,vn(Sr(e,t,!0),s))}}}));return r(n)}});const ns=Gt({logSumExp_:function(e,t=null,n=!1){const r=Wt(e,"x","logSumExp"),s=ae(t,r.shape),a=xr(r,s,!0),o=es(r,a),i=Dr(o),u=Sr(i,s),p=Gr(u),l=Xt(bn(a,p.shape),p);if(n){const e=br(l.shape,s);return bn(l,e)}return l}});const rs=Gt({logicalAnd_:function(e,t){const n=Wt(e,"a","logicalAnd","bool"),r=Wt(t,"b","logicalAnd","bool");pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("LogicalAnd",s)}});const ss=Gt({logicalNot_:function(e){const t={x:Wt(e,"x","logicalNot","bool")};return Bt.runKernel("LogicalNot",t)}});const as=Gt({logicalOr_:function(e,t){const n=Wt(e,"a","logicalOr","bool"),r=Wt(t,"b","logicalOr","bool");pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("LogicalOr",s)}});const os=Gt({logicalXor_:function(e,t){const n=Wt(e,"a","logicalXor","bool"),r=Wt(t,"b","logicalXor","bool");return pr(n.shape,r.shape),rs(as(e,t),ss(rs(e,t)))}}),is=2147483648;const us=Gt({searchSorted_:function(e,t,n="left"){const r=Wt(e,"sortedSequence","searchSorted"),s=Wt(t,"values","searchSorted"),a=r.shape[r.shape.length-1],o=s.shape[s.shape.length-1],i=bn(r,[-1,a]),u=bn(s,[-1,o]);if(i.rank<2)throw new Error("Sorted input argument must be at least 2-dimensional");if(i.shape[0]!==u.shape[0])throw new Error("Leading dimension of 'sortedSequence' and 'values' must match.");if(te(u.shape)>=is)throw new Error("values tensor size must less than 2147483648");if(i.shape[1]>=is)throw new Error(`trailing dim_size must less than 2147483648 for int32 output type, was ${i.shape[1]}`);const p={sortedSequence:i,values:u},l={side:n};return Bt.runKernel("SearchSorted",p,l)}});const ps=Gt({maxPool_:function(e,t,n,r,s){const a=Wt(e,"x","maxPool");let o=a,i=!1;3===a.rank&&(i=!0,o=bn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),Y(4===o.rank,(()=>`Error in maxPool: input must be rank 4 but got rank ${o.rank}.`)),Y(yn(n,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`)),gn("maxPool",r,s);const u={x:o},p={filterSize:t,strides:n,pad:r,dimRoundingMode:s},l=Bt.runKernel("MaxPool",u,p);return i?bn(l,[l.shape[1],l.shape[2],l.shape[3]]):l}});const ls=Gt({maxPool3d_:function(e,t=[1,1,1],n,r,s,a="NDHWC"){const o=Wt(e,"x","maxPool3d");let i=o,u=!1;4===o.rank&&(u=!0,i=bn(o,[1,o.shape[0],o.shape[1],o.shape[2],o.shape[3]])),Y(5===i.rank,(()=>`Error in maxPool3d: x must be rank 5 but got rank ${i.rank}.`)),Y("NDHWC"===a,(()=>`Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of ${a}`)),gn("maxPool3d",r,s);const p={x:i},l={filterSize:t,strides:n,pad:r,dimRoundingMode:s,dataFormat:a},c=Bt.runKernel("MaxPool3D",p,l);return u?bn(c,[c.shape[1],c.shape[2],c.shape[3],c.shape[4]]):c}});const cs=Gt({maxPoolWithArgmax_:function(e,t,n,r,s=!1){const a={x:Wt(e,"x","maxPoolWithArgmax")},o={filterSize:t,strides:n,pad:r,includeBatchInIndex:s},i=Bt.runKernel("MaxPoolWithArgmax",a,o);return{result:i[0],indexes:i[1]}}});const hs=Gt({maximum_:function(e,t){let n=Wt(e,"a","maximum"),r=Wt(t,"b","maximum");[n,r]=Ct(n,r),"bool"===n.dtype&&(n=ln(n,"int32"),r=ln(r,"int32")),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("Maximum",s)}});const ds=Gt({mean_:function(e,t=null,n=!1){const r={x:Wt(e,"x","mean")},s={axis:t,keepDims:n};return Bt.runKernel("Mean",r,s)}});function ms(e,t="float32"){if("complex64"===t){const t=ms(e,"float32"),n=ms(e,"float32");return Bn(t,n)}const n=fe(te(e),t);return Bt.makeTensor(n,e,t)}function fs(e,t="float32"){if("complex64"===t){const t=fs(e,"float32"),n=ms(e,"float32");return Bn(t,n)}const n=me(te(e),t);return Bt.makeTensor(n,e,t)}const ys=Gt({minimum_:function(e,t){let n=Wt(e,"a","minimum"),r=Wt(t,"b","minimum");[n,r]=Ct(n,r),"bool"===n.dtype&&(n=ln(n,"int32"),r=ln(r,"int32")),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("Minimum",s)}});const gs=Gt({mirrorPad_:function(e,t,n){Y("reflect"===n||"symmetric"===n,(()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`));const r=Wt(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");Y(t.length===r.rank,(()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`));const s="reflect"===n?1:0;for(let e=0;e<r.rank;e++)Y(2===t[e].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Y(t[e][0]>=0&&t[e][0]<=r.shape[e]-s&&t[e][1]>=0&&t[e][1]<=r.shape[e]-s,(()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-s} or less than 0 for input of shape ${r.shape}`));const a={paddings:t,mode:n},o={x:r};return Bt.runKernel("MirrorPad",o,a)}});const bs=Gt({mod_:function(e,t){let n=Wt(e,"a","mod"),r=Wt(t,"b","mod");[n,r]=Ct(n,r);const s={a:n,b:r};return Bt.runKernel("Mod",s)}});const xs=Gt({moments_:function(e,t=null,n=!1){const r=ae(t,(e=Wt(e,"x","moments")).shape),s=ds(e,r,n);let a=s.shape;n||(a=br(s.shape,r));const o=_r(es(ln(e,"float32"),bn(s,a)));return{mean:s,variance:ds(o,r,n)}}});const Ns=Gt({multiRNNCell_:function(e,t,n,r){const s=Wt(t,"data","multiRNNCell"),a=jt(n,"c","multiRNNCell"),o=jt(r,"h","multiRNNCell");let i=s;const u=[];for(let t=0;t<e.length;t++){const n=e[t](i,a[t],o[t]);u.push(n[0]),u.push(n[1]),i=n[1]}const p=[],l=[];for(let e=0;e<u.length;e+=2)p.push(u[e]),l.push(u[e+1]);return[p,l]}});const ws=Gt({multinomial_:function(e,t,n,r=!1){const s=Wt(e,"logits","multinomial"),a=s.size,o=s.rank;if(a<2)throw new Error(`Error in multinomial: you need at least 2 outcomes, but got ${a}.`);if(o>2)throw new Error(`Rank of probabilities must be 1 or 2, but is ${o}`);n=n||Math.random();const i={logits:1===o?bn(s,[1,-1]):s},u={numSamples:t,seed:n,normalized:r},p=Bt.runKernel("Multinomial",i,u);return 1===o?bn(p,[p.size]):p}});const ks=Gt({notEqual_:function(e,t){let n=Wt(e,"a","notEqual","string_or_numeric"),r=Wt(t,"b","notEqual","string_or_numeric");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("NotEqual",s)}});const Ts=Gt({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error(`Error in oneHot: depth must be >=2, but it is ${t}`);const s={indices:Wt(e,"indices","oneHot","int32")},a={depth:t,onValue:n,offValue:r};return Bt.runKernel("OneHot",s,a)}});const vs=Gt({onesLike_:function(e){const t={x:Wt(e,"x","onesLike")};return Bt.runKernel("OnesLike",t)}});const _s=Gt({outerProduct_:function(e,t){const n=Wt(e,"v1","outerProduct"),r=Wt(t,"v2","outerProduct");Y(1===n.rank&&1===r.rank,(()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`));const s=bn(n,[-1,1]),a=bn(r,[1,-1]);return Tn(s,a)}});const Ss=Gt({pad_:function(e,t,n=0){const r=Wt(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const s={paddings:t,constantValue:n},a={x:r};return Bt.runKernel("PadV2",a,s)}});const Es=Gt({pad1d_:function(e,t,n=0){return Y(2===t.length,(()=>"Invalid number of paddings. Must be length of 2.")),Ss(e,[t],n)}});const $s=Gt({pad2d_:function(e,t,n=0){return Y(2===t.length&&2===t[0].length&&2===t[1].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Ss(e,t,n)}});const Is=Gt({pad3d_:function(e,t,n=0){return Y(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Ss(e,t,n)}});const Ds=Gt({pad4d_:function(e,t,n=0){return Y(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,(()=>"Invalid number of paddings. Must be length of 2 each.")),Ss(e,t,n)}});const Os=Gt({spaceToBatchND_:function(e,t,n){const r=Wt(e,"x","spaceToBatchND");Y(r.rank>=1+t.length,(()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`)),Y(n.length===t.length,(()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`)),Y(r.shape.reduce(((e,r,s)=>s>0&&s<=t.length?e&&(r+n[s-1][0]+n[s-1][1])%t[s-1]==0:e),!0),(()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`));const s={x:r},a={blockShape:t,paddings:n};return Bt.runKernel("SpaceToBatchND",s,a)}});const As=Gt({pool_:function(e,t,n,r,s,a,o){null==s&&(s=[1,1]),null==a&&(a=1),0===r&&(r="valid");const i=Wt(e,"x","maxPool");let u=i,p=!1;3===i.rank&&(p=!0,u=bn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),Y(yn(a,s),(()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${s}'`));const l=function(e,t,n,r,s,a,o="channelsLast"){const[i,u]=hn(t);let p;if("channelsLast"===o)p=[i,u,e[3],e[3]];else{if("channelsFirst"!==o)throw new Error(`Unknown dataFormat ${o}`);p=[i,u,e[1],e[1]]}return cn(e,p,n,r,s,a,!1,o)}(u.shape,t,a,s,r),c=[l.dilationHeight,l.dilationWidth];let h;h="same"===r?function(e,t){const n=e.map(((e,n)=>e+(e-1)*(t[n]-1))).map((e=>e-1)),r=n.map((e=>Math.floor(e/2))),s=n.map(((e,t)=>e-r[t]));return n.map(((e,t)=>[r[t],s[t]]))}([l.filterHeight,l.filterWidth],c):[[0,0],[0,0]];const d=1===c[0]&&1===c[1],[m,f]=function(e,t,n){const r=n.map((e=>e[0])),s=n.map((e=>e[1])),a=e.concat(r,s),o=t.map(((e,t)=>(e-a[t]%e)%e)),i=s.map(((e,t)=>e+o[t])),u=t.map(((e,t)=>[r[t],i[t]])),p=t.map(((e,t)=>[0,o[t]]));return[u,p]}([l.inHeight,l.inWidth],c,h),y=d?r:"valid",g=d?u:Os(u,c,m),b=("avg"===n?()=>xn(g,t,a,y,o):()=>ps(g,t,a,y,o))(),x=d?b:In(b,c,f);return p?bn(x,[x.shape[1],x.shape[2],x.shape[3]]):x}});const Ms=Gt({prelu_:function(e,t){const n={x:Wt(e,"x","prelu"),alpha:Wt(t,"alpha","prelu")};return Bt.runKernel("Prelu",n)}});const Cs=Gt({prod_:function(e,t=null,n=!1){let r=Wt(e,"x","prod");"bool"===r.dtype&&(r=ln(r,"int32"));const s={x:r},a={axis:t,keepDims:n};return Bt.runKernel("Prod",s,a)}});const Fs=Gt({rand_:function(e,t,n){const r=te(e);let s=null;if(null==n||"float32"===n)s=new Float32Array(r);else if("int32"===n)s=new Int32Array(r);else{if("bool"!==n)throw new Error(`Unknown data type ${n}`);s=new Uint8Array(r)}for(let e=0;e<r;e++)s[e]=t();return Bt.makeTensor(s,e,n)}});var Vs="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:{};function zs(e){if(e.__esModule)return e;var t=Object.defineProperty({},"__esModule",{value:!0});return Object.keys(e).forEach((function(n){var r=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,r.get?r:{enumerable:!0,get:function(){return e[n]}})})),t}function Rs(e){var t={exports:{}};return e(t,t.exports),t.exports}var Ls=Rs((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=String(e);for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function s(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function a(e,t){var n=new r(e),a=t&&t.state,o=n.next;return o.int32=function(){return 4294967296*n.next()|0},o.double=function(){return o()+11102230246251565e-32*(2097152*o()|0)},o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.alea=a}(0,e,!1)})),Bs=Rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor128=a}(0,e,!1)})),Ps=Rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function s(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorwow=a}(0,e,!1)})),Ks=Rs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,s=t.i;return e=r[s],n=(e^=e>>>7)^e<<24,n^=(e=r[s+1&7])^e>>>10,n^=(e=r[s+3&7])^e>>>3,n^=(e=r[s+4&7])^e<<7,e=r[s+7&7],n^=(e^=e<<13)^e<<9,r[s]=n,t.i=s+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n&&(r[7]=-1),e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function s(e,t){return t.x=e.x.slice(),t.i=e.i,t}function a(e,t){null==e&&(e=+new Date);var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&(a.x&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xorshift7=a}(0,e,!1)})),qs=Rs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,s=t.X,a=t.i;return t.w=r=r+1640531527|0,n=s[a+34&127],e=s[a=a+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=s[a]=n^e,t.i=a,n+(r^r>>>16)|0},function(e,t){var n,r,s,a,o,i=[],u=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,u=Math.max(u,t.length)),s=0,a=-32;a<u;++a)t&&(r^=t.charCodeAt((a+32)%t.length)),0===a&&(o=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,a>=0&&(o=o+1640531527|0,s=0==(n=i[127&a]^=r+o)?s+1:0);for(s>=128&&(i[127&(t&&t.length||0)]=-1),s=127,a=512;a>0;--a)r=i[s+34&127],n=i[s=s+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[s]=r^n;e.w=o,e.X=i,e.i=s}(t,e)}function s(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function a(e,t){null==e&&(e=+new Date);var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&(a.X&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.xor4096=a}(0,e,!1)})),Us=Rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,s=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^s,s=s-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^s,t.a=s-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function s(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function a(e,t){var n=new r(e),a=t&&t.state,o=function(){return(n.next()>>>0)/4294967296};return o.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},o.int32=n.next,o.quick=o,a&&("object"==typeof a&&s(a,n),o.state=function(){return s(n,{})}),o}t&&t.exports?t.exports=a:n&&n.amd?n((function(){return a})):this.tychei=a}(0,e,!1)})),Ws=zs({__proto__:null,default:{}}),js=Rs((function(e){!function(t,n,r){var s,a=256,o=r.pow(a,6),i=r.pow(2,52),u=2*i,p=255;function l(e,p,l){var y=[],g=m(d((p=1==p?{entropy:!0}:p||{}).entropy?[e,f(n)]:null==e?function(){try{var e;return s&&(e=s.randomBytes)?e=e(a):(e=new Uint8Array(a),(t.crypto||t.msCrypto).getRandomValues(e)),f(e)}catch(e){var r=t.navigator,o=r&&r.plugins;return[+new Date,t,o,t.screen,f(n)]}}():e,3),y),b=new c(y),x=function(){for(var e=b.g(6),t=o,n=0;e<i;)e=(e+n)*a,t*=a,n=b.g(1);for(;e>=u;)e/=2,t/=2,n>>>=1;return(e+n)/t};return x.int32=function(){return 0|b.g(4)},x.quick=function(){return b.g(4)/4294967296},x.double=x,m(f(b.S),n),(p.pass||l||function(e,t,n,s){return s&&(s.S&&h(s,b),e.state=function(){return h(b,{})}),n?(r.random=e,t):e})(x,g,"global"in p?p.global:this==r,p.state)}function c(e){var t,n=e.length,r=this,s=0,o=r.i=r.j=0,i=r.S=[];for(n||(e=[n++]);s<a;)i[s]=s++;for(s=0;s<a;s++)i[s]=i[o=p&o+e[s%n]+(t=i[s])],i[o]=t;(r.g=function(e){for(var t,n=0,s=r.i,o=r.j,i=r.S;e--;)t=i[s=p&s+1],n=n*a+i[p&(i[s]=i[o=p&o+t])+(i[o]=t)];return r.i=s,r.j=o,n})(a)}function h(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function d(e,t){var n,r=[],s=typeof e;if(t&&"object"==s)for(n in e)try{r.push(d(e[n],t-1))}catch(e){}return r.length?r:"string"==s?e:e+"\0"}function m(e,t){for(var n,r=e+"",s=0;s<r.length;)t[p&s]=p&(n^=19*t[p&s])+r.charCodeAt(s++);return f(t)}function f(e){return String.fromCharCode.apply(0,e)}if(m(r.random(),n),e.exports){e.exports=l;try{s=Ws}catch(e){}}else r.seedrandom=l}("undefined"!=typeof self?self:Vs,[],Math)}));js.alea=Ls,js.xor128=Bs,js.xorwow=Ps,js.xorshift7=Ks,js.xor4096=qs,js.tychei=Us;var Hs=js;class Gs{constructor(e,t,n,r,s){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const a=s||Math.random();this.random=Hs.alea(a.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,s,a;do{r=2*this.random()-1,s=2*this.random()-1,a=r*r+s*s}while(a>=1||0===a);const o=Math.sqrt(-2*Math.log(a)/a);e=this.mean+this.stdDev*r*o,t=this.mean+this.stdDev*s*o,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class Zs{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const s=r||Math.random();this.randu=Hs.alea(s.toString()),this.randn=new Gs(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,s,a;for(;;){do{r=this.randn.nextValue(),a=1+this.c*r}while(a<=0);if(a*=a*a,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-a+Math.log(a)),s=this.randu(),s<t||Math.log(s)<n)break}return a=1/this.beta*this.d*a,this.alpha<1&&(a*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(a)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class Qs{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=Hs.alea(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const Ys=Gt({randomGamma_:function(e,t,n=1,r="float32",s){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error(`Unsupported data type ${r}`);const a=new Zs(t,n,r,s),o=zn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const Xs=Gt({randomNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error(`Unsupported data type ${r}`);const a=new Gs(t,n,r,!1,s),o=zn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const Js=Gt({randomStandardNormal_:function(e,t,n){if(null!=t&&"bool"===t)throw new Error(`Unsupported data type ${t}`);return Xs(e,0,1,t,n)}});const ea=Gt({randomUniform_:function(e,t=0,n=1,r="float32",s){const a=zn(e,r),o=new Qs(t,n,null,s);for(let e=0;e<a.values.length;e++)a.values[e]=o.nextValue();return a.toTensor()}});function ta(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const s={start:e,stop:t,step:n,dtype:r};return Bt.runKernel("Range",{},s)}const na=Gt({real_:function(e){const t={input:Wt(e,"input","real")};return Bt.runKernel("Real",t)}});const ra=Gt({reciprocal_:function(e){const t={x:Wt(e,"x","reciprocal")};return Bt.runKernel("Reciprocal",t)}});const sa=Gt({relu_:function(e){const t={x:Wt(e,"x","relu")};return Bt.runKernel("Relu",t)}});const aa=Gt({relu6_:function(e){const t={x:Wt(e,"x","relu6")};return Bt.runKernel("Relu6",t)}});const oa=Gt({reverse_:function(e,t){const n={x:Wt(e,"x","reverse")},r={dims:t};return Bt.runKernel("Reverse",n,r)}});const ia=Gt({reverse1d_:function(e){const t=Wt(e,"x","reverse");return Y(1===t.rank,(()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`)),oa(t,0)}});const ua=Gt({reverse2d_:function(e,t){const n=Wt(e,"x","reverse");return Y(2===n.rank,(()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`)),oa(n,t)}});const pa=Gt({reverse3d_:function(e,t){const n=Wt(e,"x","reverse");return Y(3===n.rank,(()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`)),oa(n,t)}});const la=Gt({reverse4d_:function(e,t){const n=Wt(e,"x","reverse");return Y(4===n.rank,(()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`)),oa(n,t)}});const ca=Gt({round_:function(e){const t={x:Wt(e,"x","round")};return Bt.runKernel("Round",t)}});const ha=Gt({rsqrt_:function(e){const t={x:Wt(e,"x","rsqrt","float32")};return Bt.runKernel("Rsqrt",t)}});const da=Gt({selu_:function(e){const t={x:Wt(e,"x","selu")};return Bt.runKernel("Selu",t)}});const ma=Gt({separableConv2d_:function(e,t,n,r,s,a=[1,1],o="NHWC"){const i=Wt(e,"x","separableConv2d"),u=Wt(t,"depthwiseFilter","separableConv2d"),p=Wt(n,"pointwiseFilter","separableConv2d");let l=i,c=!1;if(3===i.rank&&(c=!0,l=bn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),"NCHW"===o)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");Y(4===l.rank,(()=>`Error in separableConv2d: input must be rank 4, but got rank ${l.rank}.`)),Y(4===u.rank,(()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${u.rank}.`)),Y(4===p.rank,(()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${u.rank}.`)),Y(1===p.shape[0],(()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${p.shape[0]}.`)),Y(1===p.shape[1],(()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${p.shape[1]}.`));const h=u.shape[2],d=u.shape[3];Y(p.shape[2]===h*d,(()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${h*d}, but got ${p.shape[2]}.`));const m=sr(l,u,r,s,o,a),f=Wn(m,p,1,"valid",o);return c?bn(f,[f.shape[1],f.shape[2],f.shape[3]]):f}});const fa=async function(e,t){const n=Wt(e,"x","setdiff1d"),r=Wt(t,"y","setdiff1d");Y(n.dtype===r.dtype,(()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`)),Y(1===n.rank,(()=>`x should be 1D tensor, but got x (${n.shape}).`)),Y(1===r.rank,(()=>`y should be 1D tensor, but got y (${r.shape}).`));const s=await n.data(),a=await r.data(),o=new Set(a);let i=0;for(let e=0;e<s.length;e++)o.has(s[e])||i++;const u=new Tt([i],n.dtype),p=new Tt([i],"int32");for(let e=0,t=0;e<s.length;e++)o.has(s[e])||(u.values[t]=s[e],p.values[t]=e,t++);return[u.toTensor(),p.toTensor()]};const ya=Gt({sign_:function(e){const t={x:Wt(e,"x","sign")};return Bt.runKernel("Sign",t)}});const ga=Gt({sin_:function(e){const t={x:Wt(e,"x","sin","float32")};return Bt.runKernel("Sin",t)}});const ba=Gt({sinh_:function(e){const t={x:Wt(e,"x","sinh")};return Bt.runKernel("Sinh",t)}});const xa=Gt({slice1d_:function(e,t,n){const r=Wt(e,"x","slice1d");return Y(1===r.rank,(()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`)),Sn(r,[t],[n])}});const Na=Gt({slice2d_:function(e,t,n){const r=Wt(e,"x","slice2d");return Y(2===r.rank,(()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`)),Sn(r,t,n)}});const wa=Gt({slice3d_:function(e,t,n){const r=Wt(e,"x","slice3d");return Y(3===r.rank,(()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`)),Sn(r,t,n)}});const ka=Gt({slice4d_:function(e,t,n){const r=Wt(e,"x","slice4d");return Y(4===r.rank,(()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`)),Sn(r,t,n)}});const Ta=Gt({softmax_:function(e,t=-1){const n=Wt(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},s={dim:t};return Bt.runKernel("Softmax",r,s)}});const va=Gt({fft_:function(e){Y("complex64"===e.dtype,(()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Bt.runKernel("FFT",t)}});const _a=Gt({ifft_:function(e){Y("complex64"===e.dtype,(()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`));const t={input:e};return Bt.runKernel("IFFT",t)}});const Sa=Gt({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const s=bn(e,[n,t]);r=_a(s)}else{const s=[n,2*(t-1)],a=bn(na(e),[n,t]),o=bn(Br(e),[n,t]),i=oa(Sn(a,[0,1],[n,t-2]),1),u=vn(oa(Sn(o,[0,1],[n,t-2]),1),Tr(-1)),p=kn([a,i],1),l=kn([o,u],1),c=bn(Bn(p,l),[s[0],s[1]]);r=_a(c)}if(r=na(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=bn(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const Ea=Gt({split_:function(e,t,n=0){const r={x:Wt(e,"x","split")},s={numOrSizeSplits:t,axis:n};return Bt.runKernel("SplitV",r,s)}});const $a=Gt({rfft_:function(e,t){Y("float32"===e.dtype,(()=>`The dtype for rfft() must be real value but got ${e.dtype}`));let n=e.shape[e.shape.length-1];const r=e.size/n;let s;if(null!=t&&t<n){const r=e.shape.map((e=>0)),a=e.shape.map((e=>e));a[e.shape.length-1]=t,s=Sn(e,r,a),n=t}else if(null!=t&&t>n){const r=e.shape.map((e=>e));r[e.shape.length-1]=t-n,s=kn([e,ms(r)],e.shape.length-1),n=t}else s=e;const a=hr(s),o=bn(Bn(s,a),[r,n]),i=va(o),u=Math.floor(n/2)+1,p=na(i),l=Br(i),c=Ea(p,[u,n-u],p.shape.length-1),h=Ea(l,[u,n-u],l.shape.length-1),d=s.shape.slice();return d[s.shape.length-1]=u,bn(Bn(c[0],h[0]),d)}});const Ia=Gt({squaredDifference_:function(e,t){let n=Wt(e,"a","squaredDifference"),r=Wt(t,"b","squaredDifference");[n,r]=Ct(n,r),pr(n.shape,r.shape);const s={a:n,b:r};return Bt.runKernel("SquaredDifference",s,{})}});const Da=Gt({squeeze_:function(e,t){const n=Wt(e,"x","squeeze","string_or_numeric");return bn(n,function(e,t){const n=[],r=[],s=null!=t&&Array.isArray(t)&&0===t.length,a=null==t||s?null:ae(t,e).sort();let o=0;for(let t=0;t<e.length;++t){if(null!=a){if(a[o]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==a[o]||a[o]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),a[o]<=t&&o++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}(n.shape,t).newShape)}});const Oa=Gt({stack_:function(e,t=0){const n=jt(e,"tensors","stack","string_or_numeric");Y(n.length>=1,(()=>"Pass at least one tensor to tf.stack")),n.length>0&&Y(t<=n[0].rank,(()=>"Axis must be <= rank of the tensor"));const r=n,s={axis:t};return Bt.runKernel("Pack",r,s)}});const Aa=Gt({step_:function(e,t=0){const n={x:Wt(e,"x","step")},r={alpha:t};return Bt.runKernel("Step",n,r)}});const Ma=Gt({stridedSlice_:function(e,t,n,r,s=0,a=0,o=0,i=0,u=0){const p={x:Wt(e,"x","stridedSlice","string_or_numeric")},l={begin:t,end:n,strides:r,beginMask:s,endMask:a,ellipsisMask:o,newAxisMask:i,shrinkAxisMask:u};return Bt.runKernel("StridedSlice",p,l)}});const Ca=Gt({tan_:function(e){const t={x:Wt(e,"x","tan","float32")};return Bt.runKernel("Tan",t)}});function Fa(e,t,n){return kr(e,t,Kt(e,n),n)}function Va(e,t){J(e);const n=Kt(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return kr(e,null,n,t)}function za(e,t,n){if(J(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Kt(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return kr(e,t,r,n)}const Ra=Gt({topk_:function(e,t=1,n=!0){const r=Wt(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const s=r.shape[r.shape.length-1];if(t<0)throw new Error(`'k' passed to topk() must be >= 0 but got ${t}`);if(t>s)throw new Error(`'k' passed to topk() must be <= the last dimension (${s}) but got ${t}`);const a={x:r},o={k:t,sorted:n},[i,u]=Bt.runKernel("TopK",a,o);return{values:i,indices:u}}});const La=Gt({truncatedNormal_:function(e,t=0,n=1,r,s){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const a=new Gs(t,n,r,!0,s),o=zn(e,r);for(let e=0;e<o.values.length;e++)o.values[e]=a.nextValue();return o.toTensor()}});const Ba=Gt({unique_:function(e,t=0){const n=Wt(e,"x","unique","string_or_numeric");Y(n.rank>0,(()=>"The input tensor must be at least 1D"));const r={x:n},s={axis:t},[a,o]=Bt.runKernel("Unique",r,s);return{values:a,indices:o}}});const Pa=Gt({unsortedSegmentSum_:function(e,t,n){const r=Wt(e,"x","unsortedSegmentSum"),s=Wt(t,"segmentIds","unsortedSegmentSum","int32");Y(re(n),(()=>"numSegments must be of dtype int"));const a={x:r,segmentIds:s},o={numSegments:n};return Bt.runKernel("UnsortedSegmentSum",a,o)}});const Ka=Gt({unstack_:function(e,t=0){const n=Wt(e,"x","unstack","string_or_numeric");Y(t>=-n.shape.length&&t<n.shape.length,(()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`));const r={value:n},s={axis:t};return Bt.runKernel("Unpack",r,s)}});const qa=async function(e){const t=Wt(e,"condition","whereAsync","bool"),n=await t.data(),r=function(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=zn(e,"int32"),s=zn([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const a=r.indexToLoc(n[t]),o=t*e.length;s.values.set(a,o)}return s.toTensor()}(t.shape,n);return e!==t&&t.dispose(),r};const Ua=async function(e,t,n){const r=Wt(e,"tensor","boolMask"),s=Wt(t,"mask","boolMask","bool"),a=null==n?0:n,o=s.rank,i=r.shape;Y(o>0,(()=>"mask cannot be scalar")),X(i.slice(a,a+o),s.shape,"mask's shape must match the first K dimensions of tensor's shape,");let u=1;for(let e=a;e<a+o;e++)u*=i[e];const p=i.slice(0,a).concat([u],i.slice(a+o)),l=bn(r,p),c=bn(s,[-1]),h=await qa(c),d=Da(h,[1]),m=zr(l,d,a);return e!==r&&r.dispose(),t!==s&&s.dispose(),d.dispose(),l.dispose(),c.dispose(),h.dispose(),m};const Wa=Gt({transpose_:function(e,t,n){const r=Wt(e,"x","transpose");if(null==t&&(t=r.shape.map(((e,t)=>t)).reverse()),Y(r.rank===t.length,(()=>`Error in transpose: rank of input ${r.rank} must match length of perm ${t}.`)),t.forEach((e=>{Y(e>=0&&e<r.rank,(()=>"All entries in 'perm' must be between 0 and "+(r.rank-1)+` but got ${t}`))})),r.rank<=1)return r.clone();const s={x:r},a={perm:t};return"complex64"===r.dtype?(o=()=>{let e=na(r),t=Br(r);return e=Bt.runKernel(Ie,{x:e},a),t=Bt.runKernel(Ie,{x:t},a),n&&(t=Yr(t)),Bn(e,t)},Bt.tidy(o,i)):Bt.runKernel(Ie,s,a);var o,i}});const ja=Gt({movingAverage_:function(e,t,n,r,s=!0){const a=Wt(e,"v","movingAverage"),o=Wt(t,"x","movingAverage"),i=Wt(n,"decay","movingAverage");var u,p;p=o,Y((u=a).dtype===p.dtype,(()=>`The dtypes of the first(${u.dtype}) and second(${p.dtype}) input must match`)),Y(ne(a.shape,o.shape),(()=>"Shape mismatch in v and x"));const l=Tr(1),c=es(l,i);let h=vn(es(o,a),c);if(s){Y(null!=r,(()=>"When using zeroDebias: true, step is required."));const e=Wt(r,"step","movingAverage");h=ur(h,es(l,wr(i,e)))}return Xt(a,h)}});function Ha(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error(`The dtype of 'indices' should be int32, but got dtype: ${t.dtype}`);if(n.length<1)throw new Error(`Output rank must be greater or equal to 1, but got shape: ${n}`);if(0===n.length){if(0===t.size)throw new Error(`Indices specified for empty output. indices shape: ${t.shape}`);if(0===e.size)throw new Error(`Updates specified for empty output. updates shape: ${e.shape}`)}!function(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,s=t.rank>1?t.rank-1:1,a=`Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: ${n.shape}, indices.shape: ${t.shape}, shape: ${e}, sliceDim: ${r}, and batchDim: ${s}.`;if(n.rank<s)throw new Error(a+` update.rank < ${s}. `);if(e.length<r+(n.rank-s))throw new Error(a+` Output shape length < ${r+(n.rank-s)}`);if(n.rank!==s+e.length-r)throw new Error(a+" update.rank != "+(s+e.length-r));for(let e=0;e<s;++e)if(n.shape[e]!==t.shape[e])throw new Error(a+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-s;++t)if(n.shape[t+s]!==e[t+r])throw new Error(a+` updates.shape[${t+s}] (${n.shape[t+s]}) != shape[${t+s}] (${e[t+s]})`)}(n,t,e)}const Ga=Gt({scatterND_:function(e,t,n){const r=Wt(e,"indices","scatterND","int32"),s=Wt(t,"updates","scatterND");Ha(s,r,n);const a={indices:r,updates:s},o={shape:n};return Bt.runKernel("ScatterNd",a,o)}});const Za=Gt({sparseToDense_:function(e,t,n,r=0){const s=Wt(e,"sparseIndices","sparseToDense","int32"),a=Wt(t,"sparseValues","sparseToDense","string_or_numeric"),o=Wt(r,"defaultValue","sparseToDense",a.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const s=e.rank>0?e.shape[0]:1,a=e.rank>1?e.shape[1]:1;if(n.length!==a)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${a}.`);const o=t.size;if(0!==t.rank&&(1!==t.rank||o!==s))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${s}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(s,a,n,o);const i={sparseIndices:s,sparseValues:a,defaultValue:o},u={outputShape:n};return Bt.runKernel("SparseToDense",i,u)}});const Qa=Gt({gatherND_:function(e,t){const n=Wt(t,"indices","gatherND","int32"),r={params:Wt(e,"x","gatherND","string_or_numeric"),indices:n};return Bt.runKernel("GatherNd",r)}});const Ya=Gt({dropout_:function(e,t,n,r){const s=Wt(e,"x","dropout");if(Y("float32"===s.dtype,(()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${s.dtype} tensor instead.`)),Y(t>=0&&t<1,(()=>`rate must be a float in the range [0, 1), but got ${t}.`)),0===t)return e instanceof St?s.clone():s;const a=function(e,t){if(null==t)return e.shape.slice();if(ne(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(s,n),o=1-t,i=ur(Vr(Xt(ea(a,0,1,"float32",r),o)),o);return vn(s,i)}});function Xa(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function Ja(e,t,n){const r=1-e%2,s=new Float32Array(e);for(let a=0;a<e;++a){const o=2*Math.PI*a/(e+r-1);s[a]=t-n*Math.cos(o)}return Va(s,"float32")}const eo=async function(e,t,n=1){const r=Wt(e,"predictions","inTopK"),s=Wt(t,"targets","inTopK");Y(r.rank>1,(()=>`inTopK() expects the predictions to be of rank 2 or higher, but got ${r.rank}`)),Y(r.rank-1===s.rank,(()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${s.rank}`)),X(r.shape.slice(0,r.shape.length-1),s.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const a=r.shape[r.shape.length-1];Y(n>0&&n<=a,(()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${a}), but got ${n}`));const o=await r.data(),i=await s.data(),[u,p]=[o.length/a,a],l=function(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error(`Unknown data type ${e}`);n=new Uint8Array(t)}return n}("bool",u);for(let e=0;e<u;e++){const t=e*p,r=o.subarray(t,t+p),s=[];for(let e=0;e<r.length;e++)s.push({value:r[e],index:e});s.sort(((e,t)=>t.value-e.value)),l[e]=0;for(let t=0;t<n;t++)if(s[t].index===i[e]){l[e]=1;break}}return e!==r&&r.dispose(),t!==s&&s.dispose(),Fa(l,s.shape,"bool")};const to=Gt({conv2DBackpropFilter_:function(e,t,n,r,s,a="NHWC",o){let i=e;3===e.rank&&(i=bn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=bn(t,[1,t.shape[0],t.shape[1],t.shape[2]])),Y(4===i.rank,(()=>`Error in conv2dDerFilter: input must be rank 4, but got shape ${i.shape}.`)),Y(4===u.rank,(()=>`Error in conv2dDerFilter: dy must be rank 4, but got shape ${u.shape}.`)),Y(4===n.length,(()=>`Error in conv2dDerFilter: filterShape must be length 4, but got ${n}.`));const p="NHWC"===a?i.shape[3]:i.shape[1],l="NHWC"===a?u.shape[3]:u.shape[1];Y(p===n[2],(()=>`Error in conv2dDerFilter: depth of input ${p}) must match input depth in filter (${n[2]}.`)),Y(l===n[3],(()=>`Error in conv2dDerFilter: depth of dy (${l}) must match output depth for filter (${n[3]}).`)),gn("conv2dDerFilter",s,o);const c={x:i,dy:u},h={strides:r,pad:s,dataFormat:a,dimRoundingMode:o,filterShape:n};return Bt.runKernel("Conv2DBackpropFilter",c,h)}});function no(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return vn(e,Aa(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function ro(e,t){let n=t;const r=function(e,t){const n=[];for(let r=0;r<t.length;r++){const s=e[e.length-r-1],a=t.length-r-1,o=t[a];(null==s||1===s&&o>1)&&n.unshift(a)}return n}(e.shape,t.shape);return r.length>0&&(n=Sr(n,r)),bn(n,e.shape)}function so(e,t,n,r){if("linear"===t)return e;if("relu"===t)return sa(e);if("elu"===t)return yr(e);if("relu6"===t)return aa(e);if("prelu"===t)return Ms(e,n);if("leakyrelu"===t)return Ur(e,r);if("sigmoid"===t)return _n(e);throw new Error(`Unknown fused activation ${t}.`)}const ao=(e,t)=>!(e>0)||"linear"===t;const oo=Gt({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:a=[1,1],dimRoundingMode:o,bias:i,activation:u="linear",preluActivationWeights:p,leakyreluAlpha:l}){if(u=u||"linear",!1===ao(Bt.state.gradientDepth,u)){Y("NHWC"===s,(()=>`Error in fused conv2d: got dataFormat of ${s} but only NHWC is currently supported for the case of gradient depth is 0 and the activation is not linear.`));let c=Wn(e,t,n,r,s,a,o);return null!=i&&(c=Xt(c,i)),so(c,u,p,l)}const c=Wt(e,"x","conv2d","float32"),h=Wt(t,"filter","conv2d","float32");let d=c,m=!1;3===c.rank&&(m=!0,d=bn(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Y(4===d.rank,(()=>`Error in fused conv2d: input must be rank 4, but got rank ${d.rank}.`)),Y(4===h.rank,(()=>`Error in fused conv2d: filter must be rank 4, but got rank ${h.rank}.`)),gn("fused conv2d",r,o);const f="NHWC"===s?d.shape[3]:d.shape[1];Y(h.shape[2]===f,(()=>`Error in conv2d: depth of input (${f}) must match input depth for filter ${h.shape[2]}.`)),Y(yn(n,a),(()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`));const y=cn(d.shape,h.shape,n,a,r,o);let g,b;if(null!=i&&(g=Wt(i,"bias","fused conv2d"),[g]=Ct(g,c),"NHWC"===s?pr(y.outShape,g.shape):(Y(g.shape.length<=1,(()=>`Error in fused conv2d: only supports scalar or 1-D Tensor bias for NCHW format but got the bias of rank-${g.shape.length}.`)),Y(0===g.shape.length||g.shape[0]===y.outChannels||1===g.shape[0],(()=>`Error in fused conv2d: bias shape (${g.shape}) is not compatible with the number of output channels (${y.outChannels})`)))),null!=p){const e=p.shape;if(Y(e.length<=1||3===e.length,(()=>`Error in fused conv2d: only supports scalar, 1-D Tensor or 3-D Tensor PReLU activation weights but got a tensor of rank-${e.length}.`)),1===e.length)Y(1===e[0]||e[0]===y.outChannels,(()=>`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the number of output channels (${y.outChannels}).`));else if(3===e.length)try{pr(e,y.outShape)}catch(t){const n=`Error in fused conv2d: PReLU activation weights (${e}) is not compatible with the output shape of the conv2d (${y.outShape}).`;throw Error(n)}b=Wt(p,"prelu weights","fused conv2d")}const x=(e,t)=>{Y("NHWC"===s,(()=>`Error in gradient of fused conv2D: got dataFormat of ${s} but only NHWC is currently supported.`));const[o,i,p,l]=t,c=no(e,p,u);Y(fn(a),(()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`));const h=[Hn(i.shape,c,o,n,r),to(i,c,o.shape,n,r)];if(null!=l){const e=ro(l,c);h.push(e)}return h},N={x:d,filter:h,bias:g,preluActivationWeights:b},w={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o,activation:u,leakyreluAlpha:l};if(null==i){const e=Qr(((e,t,n)=>{let r=Bt.runKernel(Oe,N,w);return n([t,e,r]),m&&(r=bn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:x}}));return e(d,h)}{const e=Qr(((e,t,n,r)=>{let s=Bt.runKernel(Oe,N,w);return r([t,e,s,n]),m&&(s=bn(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:x}}));return e(d,h,g)}}});const io=Gt({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,s,a=[1,1],o){let i=e;3===e.rank&&(i=bn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=bn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const p={x:i,dy:u},l={strides:r,pad:s,dimRoundingMode:o,dilations:a,filterShape:n};return Bt.runKernel("DepthwiseConv2dNativeBackpropFilter",p,l)}});const uo=Gt({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,s,a=[1,1],o){let i=t,u=!1;3===t.rank&&(u=!0,i=bn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const p={dy:i,filter:n},l={strides:r,pad:s,dimRoundingMode:o,dilations:a,inputShape:e},c=Bt.runKernel("DepthwiseConv2dNativeBackpropInput",p,l);return u?bn(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const po=Gt({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:s="NHWC",dilations:a=[1,1],dimRoundingMode:o,bias:i,activation:u="linear",preluActivationWeights:p,leakyreluAlpha:l}){if(!1===ao(Bt.state.gradientDepth,u)){let c=sr(e,t,n,r,s,a,o);return null!=i&&(c=Xt(c,i)),so(c,u,p,l)}const c=Wt(e,"x","depthwiseConv2d","float32"),h=Wt(t,"filter","depthwiseConv2d","float32");let d=c,m=!1;3===c.rank&&(m=!0,d=bn(c,[1,c.shape[0],c.shape[1],c.shape[2]])),Y(4===d.rank,(()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${d.rank}.`)),Y(4===h.rank,(()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${h.rank}.`)),Y(d.shape[3]===h.shape[2],(()=>`Error in fused depthwiseConv2d: number of input channels (${d.shape[3]}) must match the inChannels dimension in filter ${h.shape[2]}.`)),null==a&&(a=[1,1]),Y(yn(n,a),(()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`)),gn("fused depthwiseConv2d",r,o);const f=cn(d.shape,h.shape,n,a,r,o,!0);let y,g;null!=i&&(y=Wt(i,"bias","fused conv2d"),[y]=Ct(y,c),pr(f.outShape,y.shape)),null!=p&&(g=Wt(p,"prelu weights","fused depthwiseConv2d"));const b=(e,t)=>{Y(fn(a),(()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`));const[s,i,p,l]=t,c=no(e,p,u),h=uo(i.shape,c,s,n,r,a,o),d=io(i,c,s.shape,n,r,a,o);if(null!=l){return[h,d,ro(y,c)]}return[h,d]},x={x:d,filter:h,bias:y,preluActivationWeights:g},N={strides:n,pad:r,dataFormat:s,dilations:a,dimRoundingMode:o,activation:u,leakyreluAlpha:l};if(null==i){const e=Qr(((e,t,n)=>{let r=Bt.runKernel(Ae,x,N);return n([t,e,r]),m&&(r=bn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:b}}));return e(d,h)}{const e=Qr(((e,t,n,r)=>{let s=Bt.runKernel(Ae,x,N);return r([t,e,s,n]),m&&(s=bn(s,[s.shape[1],s.shape[2],s.shape[3]])),{value:s,gradFunc:b}}));return e(d,h,y)}}});var lo={__proto__:null,conv2d:oo,depthwiseConv2d:po,matMul:Gt({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:s,activation:a="linear",preluActivationWeights:o,leakyreluAlpha:i=.2}){if(!1===ao(Bt.state.gradientDepth,a)){let u=Tn(e,t,n,r);return null!=s&&(u=Xt(u,s)),so(u,a,o,i)}let u=Wt(e,"a","fused matMul"),p=Wt(t,"b","fused matMul");[u,p]=Ct(u,p);const l=n?u.shape[u.rank-2]:u.shape[u.rank-1],c=r?p.shape[p.rank-1]:p.shape[p.rank-2],h=n?u.shape[u.rank-1]:u.shape[u.rank-2],d=r?p.shape[p.rank-2]:p.shape[p.rank-1],m=u.shape.slice(0,-2),f=p.shape.slice(0,-2),y=te(m),g=te(f);Y(l===c,(()=>`Error in fused matMul: inner shapes (${l}) and (${c}) of Tensors with shapes ${u.shape} and ${p.shape} and transposeA=${n} and transposeB=${r} must match.`));const b=pr(u.shape.slice(0,-2),p.shape.slice(0,-2)).concat([h,d]),x=bn(u,n?[y,l,h]:[y,h,l]),N=bn(p,r?[g,d,c]:[g,c,d]);let w,k;null!=s&&(w=Wt(s,"bias","fused matMul"),[w]=Ct(w,u),pr(b,w.shape)),null!=o&&(k=Wt(o,"prelu weights","fused matMul"));const T=(e,t)=>{const[o,i,u,p]=t,l=no(bn(e,u.shape),u,a);let c,h;if(n||r?!n&&r?(c=Tn(l,i,!1,!1),h=Tn(l,o,!0,!1)):n&&!r?(c=Tn(i,l,!1,!0),h=Tn(o,l,!1,!1)):(c=Tn(i,l,!0,!0),h=Tn(l,o,!0,!0)):(c=Tn(l,i,!1,!0),h=Tn(o,l,!0,!1)),null!=s){return[c,h,ro(p,l)]}return[c,h]},v={a:x,b:N,bias:w,preluActivationWeights:k},_={transposeA:n,transposeB:r,activation:a,leakyreluAlpha:i};if(null==s){const e=Qr(((e,t,n)=>{const r=Bt.runKernel(De,v,_);return n([e,t,r]),{value:bn(r,b),gradFunc:T}}));return e(x,N)}{const e=Qr(((e,t,n,r)=>{const s=Bt.runKernel(De,v,_);return r([e,t,s,n]),{value:bn(s,b),gradFunc:T}}));return e(x,N,w)}}})};const co=Gt({hammingWindow_:function(e){return Ja(e,.54,.46)}});const ho=Gt({hannWindow_:function(e){return Ja(e,.5,.5)}});const mo=Gt({frame_:function(e,t,n,r=!1,s=0){let a=0;const o=[];for(;a+t<=e.size;)o.push(Sn(e,a,t)),a+=n;if(r)for(;a<e.size;){const r=a+t-e.size,i=kn([Sn(e,a,t-r),Fr([r],s)]);o.push(i),a+=n}return 0===o.length?za([],[0,t]):bn(kn(o),[o.length,t])}});const fo=Gt({stft_:function(e,t,n,r,s=ho){null==r&&(r=Xa(t));const a=mo(e,t,n),o=vn(a,s(t));return $a(o,r)}});const yo=Gt({cropAndResize_:function(e,t,n,r,s="bilinear",a=0){const o=Wt(e,"image","cropAndResize"),i=Wt(t,"boxes","cropAndResize","float32"),u=Wt(n,"boxInd","cropAndResize","int32"),p=i.shape[0];Y(4===o.rank,(()=>`Error in cropAndResize: image must be rank 4,but got rank ${o.rank}.`)),Y(2===i.rank&&4===i.shape[1],(()=>`Error in cropAndResize: boxes must be have size [${p},4] but had shape ${i.shape}.`)),Y(1===u.rank&&u.shape[0]===p,(()=>`Error in cropAndResize: boxInd must be have size [${p}] but had shape ${i.shape}.`)),Y(2===r.length,(()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`)),Y(r[0]>=1&&r[1]>=1,(()=>`cropSize must be atleast [1,1], but was ${r}`)),Y("bilinear"===s||"nearest"===s,(()=>`method must be bilinear or nearest, but was ${s}`));const l={image:o,boxes:i,boxInd:u},c={method:s,extrapolationValue:a,cropSize:r};return Bt.runKernel("CropAndResize",l,c)}});const go=Gt({flipLeftRight_:function(e){const t=Wt(e,"image","flipLeftRight","float32");Y(4===t.rank,(()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`));const n={image:t};return Bt.runKernel("FlipLeftRight",n,{})}});const bo=Gt({grayscaleToRGB_:function(e){const t=Wt(e,"image","grayscaleToRGB"),n=t.rank-1,r=t.shape[n];Y(t.rank>=2,(()=>`Error in grayscaleToRGB: images must be at least rank 2, but got rank ${t.rank}.`)),Y(1===r,(()=>`Error in grayscaleToRGB: last dimension of a grayscale image should be size 1, but got size ${r}.`));const s=new Array(t.rank);return s.fill(1,0,n),s[n]=3,Mr(t,s)}});const xo=Gt({rotateWithOffset_:function(e,t,n=0,r=.5){const s=Wt(e,"image","rotateWithOffset","float32");Y(4===s.rank,(()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${s.rank}.`));const a={image:s},o={radians:t,fillValue:n,center:r};return Bt.runKernel("RotateWithOffset",a,o)}});function No(e,t,n,r,s,a){null==r&&(r=.5),null==s&&(s=Number.NEGATIVE_INFINITY),null==a&&(a=0);const o=e.shape[0];return n=Math.min(n,o),Y(0<=r&&r<=1,(()=>`iouThreshold must be in [0, 1], but was '${r}'`)),Y(2===e.rank,(()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`)),Y(4===e.shape[1],(()=>`boxes must have 4 columns, but 2nd dimension was ${e.shape[1]}`)),Y(1===t.rank,(()=>"scores must be a 1D tensor")),Y(t.shape[0]===o,(()=>`scores has incompatible shape with boxes. Expected ${o}, but was ${t.shape[0]}`)),Y(0<=a&&a<=1,(()=>`softNmsSigma must be in [0, 1], but was '${a}'`)),{maxOutputSize:n,iouThreshold:r,scoreThreshold:s,softNmsSigma:a}}const wo=Gt({nonMaxSuppression_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const a=Wt(e,"boxes","nonMaxSuppression","float32"),o=Wt(t,"scores","nonMaxSuppression","float32"),i=No(a,o,n,r,s),u={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:s=i.scoreThreshold};return Bt.runKernel("NonMaxSuppressionV3",{boxes:a,scores:o},u)}});function ko(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,s=e.length,a=0,o=!1;for(;r<s;){a=r+(s-r>>>1);const i=n(t,e[a]);i>0?r=a+1:(s=a,o=!i)}return o?r:-r-1}(e,t,n||To)}(e,t,n),s=r<0?-(r+1):r;e.splice(s,0,t)}function To(e,t){return e>t?1:e<t?-1:0}function vo(e,t,n,r,s,a,o=!1,i=!1,u=!1){const p=[];for(let e=0;e<t.length;e++)t[e]>s&&p.push({score:t[e],boxIndex:e,suppressBeginIndex:0});p.sort(Eo);const l=a>0?-.5/a:0,c=[],h=[];for(;c.length<n&&p.length>0;){const t=p.pop(),{score:n,boxIndex:a,suppressBeginIndex:o}=t;if(n<s)break;let i=!1;for(let n=c.length-1;n>=o;--n){const o=_o(e,a,c[n]);if(o>=r){i=!0;break}if(t.score=t.score*So(r,l,o),t.score<=s)break}t.suppressBeginIndex=c.length,i||(t.score===n?(c.push(a),h.push(t.score)):t.score>s&&ko(p,t,Eo))}const d=c.length,m=n-d;i&&m>0&&(c.push(...new Array(m).fill(0)),h.push(...new Array(m).fill(0)));const f={selectedIndices:c};return o&&(f.selectedScores=h),u&&(f.validOutputs=d),f}function _o(e,t,n){const r=e.subarray(4*t,4*t+4),s=e.subarray(4*n,4*n+4),a=Math.min(r[0],r[2]),o=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),u=Math.max(r[1],r[3]),p=Math.min(s[0],s[2]),l=Math.min(s[1],s[3]),c=Math.max(s[0],s[2]),h=Math.max(s[1],s[3]),d=(i-a)*(u-o),m=(c-p)*(h-l);if(d<=0||m<=0)return 0;const f=Math.max(a,p),y=Math.max(o,l),g=Math.min(i,c),b=Math.min(u,h),x=Math.max(g-f,0)*Math.max(b-y,0);return x/(d+m-x)}function So(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function Eo(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const $o=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY){const a=Wt(e,"boxes","nonMaxSuppressionAsync"),o=Wt(t,"scores","nonMaxSuppressionAsync"),i=No(a,o,n,r,s);n=i.maxOutputSize,r=i.iouThreshold,s=i.scoreThreshold;const u=await Promise.all([a.data(),o.data()]),p=u[0],l=u[1],{selectedIndices:c}=function(e,t,n,r,s){return vo(e,t,n,r,s,0)}(p,l,n,r,s);return a!==e&&a.dispose(),o!==t&&o.dispose(),Va(c,"int32")};const Io=Gt({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=0){const o=Wt(e,"boxes","nonMaxSuppression"),i=Wt(t,"scores","nonMaxSuppression"),u=No(o,i,n,r,s,a),p={boxes:o,scores:i},l={maxOutputSize:n=u.maxOutputSize,iouThreshold:r=u.iouThreshold,scoreThreshold:s=u.scoreThreshold,softNmsSigma:a=u.softNmsSigma},c=Bt.runKernel("NonMaxSuppressionV5",p,l);return{selectedIndices:c[0],selectedScores:c[1]}}});const Do=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=0){const o=Wt(e,"boxes","nonMaxSuppressionAsync"),i=Wt(t,"scores","nonMaxSuppressionAsync"),u=No(o,i,n,r,s,a);n=u.maxOutputSize,r=u.iouThreshold,s=u.scoreThreshold,a=u.softNmsSigma;const p=await Promise.all([o.data(),i.data()]),l=p[0],c=p[1],{selectedIndices:h,selectedScores:d}=function(e,t,n,r,s,a){return vo(e,t,n,r,s,a,!0)}(l,c,n,r,s,a);return o!==e&&o.dispose(),i!==t&&i.dispose(),{selectedIndices:Va(h,"int32"),selectedScores:Va(d)}};const Oo=Gt({nonMaxSuppressionPadded_:function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=!1){const o=Wt(e,"boxes","nonMaxSuppression"),i=Wt(t,"scores","nonMaxSuppression"),u=No(o,i,n,r,s,null),p={boxes:o,scores:i},l={maxOutputSize:u.maxOutputSize,iouThreshold:u.iouThreshold,scoreThreshold:u.scoreThreshold,padToMaxOutputSize:a},c=Bt.runKernel("NonMaxSuppressionV4",p,l);return{selectedIndices:c[0],validOutputs:c[1]}}});const Ao=async function(e,t,n,r=.5,s=Number.NEGATIVE_INFINITY,a=!1){const o=Wt(e,"boxes","nonMaxSuppressionAsync"),i=Wt(t,"scores","nonMaxSuppressionAsync"),u=No(o,i,n,r,s,null),p=u.maxOutputSize,l=u.iouThreshold,c=u.scoreThreshold,[h,d]=await Promise.all([o.data(),i.data()]),{selectedIndices:m,validOutputs:f}=function(e,t,n,r,s,a){return vo(e,t,n,r,s,0,!1,a,!0)}(h,d,p,l,c,a);return o!==e&&o.dispose(),i!==t&&i.dispose(),{selectedIndices:Va(m,"int32"),validOutputs:Tr(f,"int32")}};const Mo=Gt({resizeBilinear_:function(e,t,n=!1,r=!1){const s=Wt(e,"images","resizeBilinear");Y(3===s.rank||4===s.rank,(()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${s.rank}.`)),Y(2===t.length,(()=>`Error in resizeBilinear: new shape must 2D, but got shape ${t}.`)),Y(!1===r||!1===n,(()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false."));let a=s,o=!1;3===s.rank&&(o=!0,a=bn(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:a},u={alignCorners:n,halfPixelCenters:r,size:t},p=Bt.runKernel("ResizeBilinear",i,u);return o?bn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const Co=Gt({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const s=Wt(e,"images","resizeNearestNeighbor");Y(3===s.rank||4===s.rank,(()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${s.rank}.`)),Y(2===t.length,(()=>`Error in resizeNearestNeighbor: new shape must 2D, but got shape ${t}.`)),Y("float32"===s.dtype||"int32"===s.dtype,(()=>"`images` must have `int32` or `float32` as dtype")),Y(!1===r||!1===n,(()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false."));let a=s,o=!1;3===s.rank&&(o=!0,a=bn(s,[1,s.shape[0],s.shape[1],s.shape[2]]));const i={images:a},u={alignCorners:n,halfPixelCenters:r,size:t},p=Bt.runKernel("ResizeNearestNeighbor",i,u);return o?bn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});const Fo=Gt({threshold_:function(e,t="binary",n=!1,r=.5){const s=Wt(e,"image","threshold"),a=s.shape[0]*s.shape[1];let o,i,u,p,l=vn(Va([r]),255);if(Y(3===s.rank,(()=>`Error in threshold: image must be rank 3,but got rank ${s.rank}.`)),Y(3===s.shape[2]||1===s.shape[2],(()=>`Error in threshold: image color channel must be equal to 3 or 1but got ${s.shape[2]}.`)),Y("int32"===s.dtype||"float32"===s.dtype,(()=>`Error in dtype: image dtype must be int32 or float32,but got dtype ${s.dtype}.`)),Y("otsu"===t||"binary"===t,(()=>`Method must be binary or otsu, but was ${t}`)),3===s.shape[2]){[o,i,u]=Ea(s,[1,1,1],-1);const e=vn(o,.2989),t=vn(i,.587),n=vn(u,.114);p=Xt(Xt(e,t),n)}else p=e;if("otsu"===t){l=function(e,t){let n,r,s,a,o,i,u=Va([-1]),p=Va([0]),l=Va([0]);for(let c=0;c<e.size-1;c++){n=Sn(e,0,c+1),r=Sn(e,c+1),o=ur(Sr(n),t),i=ur(Sr(r),t);const h=Sr(vn(n,ta(0,n.size)));s=ur(h,Sr(n));const d=Fr(r.shape,n.size),m=Xt(ta(0,r.size),d),f=vn(r,m);a=ur(Sr(f),Sr(r));const y=es(s,a),g=es(s,a),b=vn(o,i);l=vn(vn(b,y),g);const x=Rr(l,p);p=cr(x,l,p),u=cr(x,Va([c]),u)}return u}(Cn(ln(ca(p),"int32"),Fa([]),256),a)}const c=n?jr(p,l):Rr(p,l);return ln(vn(c,255),"int32")}});const Vo=Gt({transform_:function(e,t,n="nearest",r="constant",s=0,a){const o=Wt(e,"image","transform","float32"),i=Wt(t,"transforms","transform","float32");Y(4===o.rank,(()=>`Error in transform: image must be rank 4,but got rank ${o.rank}.`)),Y(2===i.rank&&(i.shape[0]===o.shape[0]||1===i.shape[0])&&8===i.shape[1],(()=>"Error in transform: Input transform should be batch x 8 or 1 x 8")),Y(null==a||2===a.length,(()=>`Error in transform: outputShape must be [height, width] or null, but got ${a}.`));const u={image:o,transforms:i},p={interpolation:n,fillMode:r,fillValue:s,outputShape:a};return Bt.runKernel("Transform",u,p)}});const zo=Gt({bandPart_:function(e,t,n){Y(t%1==0,(()=>`bandPart(): numLower must be an integer, got ${t}.`)),Y(n%1==0,(()=>`bandPart(): numUpper must be an integer, got ${n}.`));const r=Wt(e,"a","bandPart");Y(r.rank>=2,(()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`));const s=r.shape,[a,o]=r.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=o))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${o}).`);t<0&&(t=a),n<0&&(n=o);const i=bn(ta(0,a,1,"int32"),[-1,1]),u=ta(0,o,1,"int32"),p=es(i,u),l=rs(jr(p,Tr(+t,"int32")),Lr(p,Tr(-n,"int32"))),c=ms([a,o],r.dtype);return bn(Oa(Ka(bn(r,[-1,a,o])).map((e=>cr(l,e,c)))),s)}});const Ro=Gt({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,Y(null!=e&&e.length>0,(()=>"Gram-Schmidt process: input must not be null, undefined, or empty"));const n=e[0].shape[0];for(let t=1;t<e.length;++t)Y(e[t].shape[0]===n,(()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`))}else t=!0,e=Ea(e,e.shape[0],0).map((e=>Da(e,[0])));Y(e.length<=e[0].shape[0],(()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`));const n=[],r=e;for(let t=0;t<e.length;++t)n.push(Bt.tidy((()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=vn(Sr(vn(n[r],e)),n[r]);e=es(e,t)}return ur(e,$r(e,"euclidean"))})));return t?Oa(n,0):n}});function Lo(e,t=!1){return Bt.tidy((()=>{Y(2===e.shape.length,(()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`));const n=e.shape[0],r=e.shape[1];let s=Cr(n),a=wn(e);const o=za([[1]],[1,1]);let i=wn(o);const u=n>=r?r:n;for(let e=0;e<u;++e){const t=a,u=i,p=s;[i,a,s]=Bt.tidy((()=>{const t=Sn(a,[e,e],[n-e,1]),u=$r(t),p=Sn(a,[e,e],[1,1]),l=cr(Rr(p,0),za([[-1]]),za([[1]])),c=es(p,vn(l,u)),h=ur(t,c);i=1===h.shape[0]?wn(o):kn([o,Sn(h,[1,0],[h.shape[0]-1,h.shape[1]])],0);const d=Yr(ur(Tn(l,c),u)),m=Sn(a,[e,0],[n-e,r]),f=vn(d,i),y=Wa(i);if(0===e)a=es(m,Tn(f,Tn(y,m)));else{const t=es(m,Tn(f,Tn(y,m)));a=kn([Sn(a,[0,0],[e,r]),t],0)}const g=Wa(f),b=Sn(s,[0,e],[n,s.shape[1]-e]);if(0===e)s=es(b,Tn(Tn(b,i),g));else{const t=es(b,Tn(Tn(b,i),g));s=kn([Sn(s,[0,0],[n,e]),t],1)}return[i,a,s]})),Ft([t,u,p]).forEach((e=>e.dispose()))}return!t&&n>r&&(s=Sn(s,[0,0],[n,r]),a=Sn(a,[0,0],[r,r])),[s,a]}))}const Bo=Gt({qr_:function(e,t=!1){if(Y(e.rank>=2,(()=>`qr() requires input tensor to have a rank >= 2, but got rank ${e.rank}`)),2===e.rank)return Lo(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce(((e,t)=>e*t)),r=Ka(bn(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),s=[],a=[];r.forEach((e=>{const[n,r]=Lo(e,t);s.push(n),a.push(r)}));return[bn(Oa(s,0),e.shape),bn(Oa(a,0),e.shape)]}}});var Po;!function(e){e[e.NONE=0]="NONE",e[e.MEAN=1]="MEAN",e[e.SUM=2]="SUM",e[e.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS"}(Po||(Po={}));const Ko=Gt({computeWeightedLoss_:function(e,t,n=Po.SUM_BY_NONZERO_WEIGHTS){const r=Wt(e,"losses","computeWeightedLoss");let s=null;null!=t&&(s=Wt(t,"weights","computeWeightedLoss"));const a=null==s?r:vn(r,s);if(n===Po.NONE)return a;if(n===Po.SUM)return Sr(a);if(n===Po.MEAN){if(null==s)return ds(a);{const e=r.size/s.size,t=ur(Sr(a),Sr(s));return e>1?ur(t,Tr(e)):t}}if(n===Po.SUM_BY_NONZERO_WEIGHTS){if(null==s)return ur(Sr(a),Tr(r.size));{const e=vn(s,fs(r.shape)),t=ln(Sr(ks(e,Tr(0))),"float32");return ur(Sr(a),t)}}throw Error(`Unknown reduction: ${n}`)}});const qo=Gt({absoluteDifference_:function(e,t,n,r=Po.SUM_BY_NONZERO_WEIGHTS){const s=Wt(e,"labels","absoluteDifference"),a=Wt(t,"predictions","absoluteDifference");let o=null;null!=n&&(o=Wt(n,"weights","absoluteDifference")),X(s.shape,a.shape,"Error in absoluteDifference: ");const i=Zt(es(s,a));return Ko(i,o,r)}});const Uo=Gt({cosineDistance_:function(e,t,n,r,s=Po.SUM_BY_NONZERO_WEIGHTS){const a=Wt(e,"labels","cosineDistance"),o=Wt(t,"predictions","cosineDistance");let i=null;null!=r&&(i=Wt(r,"weights","cosineDistance")),X(a.shape,o.shape,"Error in cosineDistance: ");const u=Tr(1),p=es(u,Sr(vn(a,o),n,!0));return Ko(p,i,s)}});const Wo=Gt({hingeLoss_:function(e,t,n,r=Po.SUM_BY_NONZERO_WEIGHTS){let s=Wt(e,"labels","hingeLoss");const a=Wt(t,"predictions","hingeLoss");let o=null;null!=n&&(o=Wt(n,"weights","hingeLoss")),X(s.shape,a.shape,"Error in hingeLoss: ");const i=Tr(1);s=es(vn(Tr(2),s),i);const u=sa(es(i,vn(s,a)));return Ko(u,o,r)}});const jo=Gt({huberLoss_:function(e,t,n,r=1,s=Po.SUM_BY_NONZERO_WEIGHTS){const a=Wt(e,"labels","huberLoss"),o=Wt(t,"predictions","huberLoss");let i=null;null!=n&&(i=Wt(n,"weights","huberLoss")),X(a.shape,o.shape,"Error in huberLoss: ");const u=Tr(r),p=Zt(es(o,a)),l=ys(p,u),c=es(p,l),h=Xt(vn(Tr(.5),_r(l)),vn(u,c));return Ko(h,i,s)}});const Ho=Gt({logLoss_:function(e,t,n,r=1e-7,s=Po.SUM_BY_NONZERO_WEIGHTS){const a=Wt(e,"labels","logLoss"),o=Wt(t,"predictions","logLoss");let i=null;null!=n&&(i=Wt(n,"weights","logLoss")),X(a.shape,o.shape,"Error in logLoss: ");const u=Tr(1),p=Tr(r),l=Yr(vn(a,Gr(Xt(o,p)))),c=vn(es(u,a),Gr(Xt(es(u,o),p))),h=es(l,c);return Ko(h,i,s)}});const Go=Gt({meanSquaredError_:function(e,t,n,r=Po.SUM_BY_NONZERO_WEIGHTS){const s=Wt(e,"labels","meanSquaredError"),a=Wt(t,"predictions","meanSquaredError");let o=null;null!=n&&(o=Wt(n,"weights","meanSquaredError")),X(s.shape,a.shape,"Error in meanSquaredError: ");const i=Ia(s,a);return Ko(i,o,r)}});const Zo=Gt({sigmoidCrossEntropy_:function(e,t,n,r=0,s=Po.SUM_BY_NONZERO_WEIGHTS){let a=Wt(e,"multiClassLabels","sigmoidCrossEntropy");const o=Wt(t,"logits","sigmoidCrossEntropy");let i=null;if(null!=n&&(i=Wt(n,"weights","sigmoidCrossEntropy")),X(a.shape,o.shape,"Error in sigmoidCrossEntropy: "),r>0){const e=Tr(r),t=Tr(1),n=Tr(.5);a=Xt(vn(a,es(t,e)),vn(n,e))}const u=function(e,t){const n=Wt(e,"labels","sigmoidCrossEntropyWithLogits"),r=Wt(t,"logits","sigmoidCrossEntropyWithLogits");X(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const s=sa(r),a=vn(r,n),o=Zr(Dr(Yr(Zt(r))));return Xt(es(s,a),o)}(a,o);return Ko(u,i,s)}});const Qo=Gt({softmaxCrossEntropy_:function(e,t,n,r=0,s=Po.SUM_BY_NONZERO_WEIGHTS){let a=Wt(e,"onehotLabels","softmaxCrossEntropy");const o=Wt(t,"logits","softmaxCrossEntropy");let i=null;if(null!=n&&(i=Wt(n,"weights","softmaxCrossEntropy")),X(a.shape,o.shape,"Error in softmaxCrossEntropy: "),r>0){const e=Tr(r),t=Tr(1),n=Tr(a.shape[1]);a=Xt(vn(a,es(t,e)),ur(e,n))}const u=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was ${n}`);const r=Qr(((e,t,r)=>{const s=ns(t,[n],!0),a=es(ln(t,"float32"),s);r([e,a]);const o=Yr(vn(a,e));return{value:Sr(o,[n]),gradFunc:(e,t)=>{const[r,s]=t,a=br(e.shape,[n]);return[vn(bn(e,a),es(ln(r,"float32"),Dr(s))),vn(bn(e,a),es(Dr(s),ln(r,"float32")))]}}}));return r(e,t)}(a,o);return Ko(u,i,s)}});const Yo=Gt({sparseFillEmptyRows_:function(e,t,n,r){const s=Wt(e,"indices","sparseFillEmptyRows","int32"),a=Wt(t,"values","sparseFillEmptyRows"),o=Wt(n,"denseShape","sparseFillEmptyRows","int32"),i=Wt(r,"defaultValue","sparseFillEmptyRows",a.dtype);if(2!==s.rank)throw new Error(`Indices should be Tensor2D but received shape\n        ${s.shape}`);if(1!==a.rank)throw new Error(`Values should be Tensor1D but received shape ${a.shape}`);if(1!==o.rank)throw new Error(`Dense shape should be Tensor1D but received shape ${o.shape}`);if(0!==i.rank)throw new Error(`Default value should be a scalar but received shape ${i.shape}`);const u={indices:s,values:a,denseShape:o,defaultValue:i},p=Bt.runKernel("SparseFillEmptyRows",u);return{outputIndices:p[0],outputValues:p[1],emptyRowIndicator:p[2],reverseIndexMap:p[3]}}});const Xo=Gt({sparseReshape_:function(e,t,n){const r=Wt(e,"inputIndices","sparseReshape","int32"),s=Wt(t,"inputShape","sparseReshape","int32"),a=Wt(n,"newShape","sparseReshape","int32");if(2!==r.rank)throw new Error(`Input indices should be Tensor2D but received shape\n        ${r.shape}`);if(1!==s.rank)throw new Error(`Input shape should be Tensor1D but received shape ${s.shape}`);if(1!==a.rank)throw new Error(`New shape should be Tensor1D but received shape ${a.shape}`);const o={inputIndices:r,inputShape:s,newShape:a},i=Bt.runKernel("SparseReshape",o);return{outputIndices:i[0],outputShape:i[1]}}});const Jo=Gt({sparseSegmentMean_:function(e,t,n){const r=Wt(e,"data","sparseSegmentMean"),s=Wt(t,"indices","sparseSegmentMean","int32"),a=Wt(n,"segmentIds","sparseSegmentMean","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n          ${s.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n          ${a.shape}`);const o={data:r,indices:s,segmentIds:a};return Bt.runKernel("SparseSegmentMean",o)}});const ei=Gt({sparseSegmentSum_:function(e,t,n){const r=Wt(e,"data","sparseSegmentSum"),s=Wt(t,"indices","sparseSegmentSum","int32"),a=Wt(n,"segmentIds","sparseSegmentSum","int32");if(r.rank<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.rank)throw new Error(`Indices should be Tensor1D but received shape\n         ${s.shape}`);if(1!==a.rank)throw new Error(`Segment ids should be Tensor1D but received shape\n         ${a.shape}`);const o={data:r,indices:s,segmentIds:a};return Bt.runKernel("SparseSegmentSum",o)}});const ti=Gt({stringNGrams_:function(e,t,n,r,s,a,o,i){const u=Wt(e,"data","stringNGrams","string");if("string"!==u.dtype)throw new Error("Data must be of datatype string");if(1!==u.shape.length)throw new Error(`Data must be a vector, saw: ${u.shape}`);const p=Wt(t,"dataSplits","stringNGrams");if("int32"!==p.dtype)throw new Error("Data splits must be of datatype int32");const l={separator:n,nGramWidths:r,leftPad:s,rightPad:a,padWidth:o,preserveShortSequences:i},c={data:u,dataSplits:p},h=Bt.runKernel("StringNGrams",c,l);return{nGrams:h[0],nGramsSplits:h[1]}}});const ni=Gt({stringSplit_:function(e,t,n=!0){const r=Wt(e,"input","stringSplit","string"),s=Wt(t,"delimiter","stringSplit","string");if(1!==r.rank)throw new Error(`Input should be Tensor1D but received shape ${r.shape}`);if(0!==s.rank)throw new Error(`Delimiter should be a scalar but received shape ${s.shape}`);const a={skipEmpty:n},o={input:r,delimiter:s},i=Bt.runKernel("StringSplit",o,a);return{indices:i[0],values:i[1],shape:i[2]}}});const ri=Gt({stringToHashBucketFast_:function(e,t){const n=Wt(e,"input","stringToHashBucketFast","string"),r={numBuckets:t};if(t<=0)throw new Error("Number of buckets must be at least 1");const s={input:n};return Bt.runKernel("StringToHashBucketFast",s,r)}});var si={__proto__:null,abs:Zt,acos:Qt,acosh:Yt,add:Xt,addN:Jt,all:en,any:tn,argMax:nn,argMin:rn,asin:sn,asinh:an,atan:on,atan2:un,atanh:pn,avgPool:xn,avgPool3d:Nn,basicLSTMCell:$n,batchToSpaceND:In,batchNorm:Dn,batchNorm2d:On,batchNorm3d:An,batchNorm4d:Mn,bincount:Cn,broadcastArgs:Fn,broadcastTo:Vn,buffer:zn,cast:ln,ceil:Rn,clipByValue:Ln,clone:wn,complex:Bn,concat:kn,concat1d:Pn,concat2d:Kn,concat3d:qn,concat4d:Un,conv1d:jn,conv2d:Wn,conv2dTranspose:Gn,conv3d:Zn,conv3dTranspose:Yn,cos:Xn,cosh:Jn,cumprod:er,cumsum:tr,denseBincount:nr,depthToSpace:rr,depthwiseConv2d:sr,diag:ar,dilation2d:or,div:ur,divNoNan:dr,dot:mr,einsum:fr,elu:yr,equal:lr,erf:gr,euclideanNorm:Ir,exp:Dr,expandDims:Or,expm1:Ar,eye:Cr,fill:Fr,floor:Vr,floorDiv:ir,gather:zr,greater:Rr,greaterEqual:Lr,imag:Br,isFinite:Pr,isInf:Kr,isNaN:qr,leakyRelu:Ur,less:Wr,lessEqual:jr,linspace:function(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return Bt.runKernel("LinSpace",{},r)},localResponseNormalization:Hr,log:Gr,log1p:Zr,logSigmoid:Jr,logSoftmax:ts,logSumExp:ns,logicalAnd:rs,logicalNot:ss,logicalOr:as,logicalXor:os,lowerBound:function(e,t){return us(e,t,"left")},matMul:Tn,max:xr,maxPool:ps,maxPool3d:ls,maxPoolWithArgmax:cs,maximum:hs,mean:ds,meshgrid:function(e,t,{indexing:n="xy"}={}){if("xy"!==n&&"ij"!==n)throw new TypeError(`${n} is not a valid third argument to meshgrid`);if(void 0===e)return[];let r=Wt(e,"x","meshgrid",e instanceof St?e.dtype:"float32");if(void 0===t)return[r];let s=Wt(t,"y","meshgrid",t instanceof St?t.dtype:"float32");const a=te(r.shape),o=te(s.shape);return"xy"===n?(r=bn(r,[1,-1]),s=bn(s,[-1,1]),[Tn(fs([o,1],r.dtype),r),Tn(s,fs([1,a],s.dtype))]):(r=bn(r,[-1,1]),s=bn(s,[1,-1]),[Tn(r,fs([1,o],r.dtype)),Tn(fs([a,1],s.dtype),s)])},min:Nr,minimum:ys,mirrorPad:gs,mod:bs,moments:xs,mul:vn,multiRNNCell:Ns,multinomial:ws,neg:Yr,notEqual:ks,oneHot:Ts,ones:fs,onesLike:vs,outerProduct:_s,pad:Ss,pad1d:Es,pad2d:$s,pad3d:Is,pad4d:Ds,pool:As,pow:wr,prelu:Ms,print:function(e,t=!1){console.log(e.toString(t))},prod:Cs,rand:Fs,randomGamma:Ys,randomNormal:Xs,randomStandardNormal:Js,randomUniform:ea,range:ta,real:na,reciprocal:ra,relu:sa,relu6:aa,reshape:bn,reverse:oa,reverse1d:ia,reverse2d:ua,reverse3d:pa,reverse4d:la,round:ca,rsqrt:ha,scalar:Tr,selu:da,separableConv2d:ma,setdiff1dAsync:fa,sigmoid:_n,sign:ya,sin:ga,sinh:ba,slice:Sn,slice1d:xa,slice2d:Na,slice3d:wa,slice4d:ka,softmax:Ta,softplus:Xr,spaceToBatchND:Os,fft:va,ifft:_a,irfft:Sa,rfft:$a,split:Ea,sqrt:vr,square:_r,squaredDifference:Ia,squeeze:Da,stack:Oa,step:Aa,stridedSlice:Ma,sub:es,sum:Sr,tan:Ca,tanh:En,tensor:Fa,tensor1d:Va,tensor2d:za,tensor3d:function(e,t,n){if(J(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Kt(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return kr(e,t,r,n)},tensor4d:function(e,t,n){if(J(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Kt(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return kr(e,t,r,n)},tensor5d:function(e,t,n){if(J(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Kt(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return kr(e,t,r,n)},tensor6d:function(e,t,n){if(J(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Kt(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return kr(e,t=t||r,r,n)},tile:Mr,topk:Ra,truncatedNormal:La,unique:Ba,unsortedSegmentSum:Pa,unstack:Ka,upperBound:function(e,t){return us(e,t,"right")},variable:function(e,t=!0,n,r){return Bt.makeVariable(e,t,n,r)},where:cr,whereAsync:qa,zeros:ms,zerosLike:hr,op:Gt,OP_SCOPE_SUFFIX:Ht,booleanMaskAsync:Ua,transpose:Wa,norm:$r,movingAverage:ja,scatterND:Ga,searchSorted:us,sparseToDense:Za,gatherND:Qa,dropout:Ya,enclosingPowerOfTwo:Xa,cosineWindow:Ja,inTopKAsync:eo,image:{flipLeftRight:go,grayscaleToRGB:bo,resizeNearestNeighbor:Co,resizeBilinear:Mo,rotateWithOffset:xo,cropAndResize:yo,nonMaxSuppression:wo,nonMaxSuppressionAsync:$o,nonMaxSuppressionWithScore:Io,nonMaxSuppressionWithScoreAsync:Do,nonMaxSuppressionPadded:Oo,nonMaxSuppressionPaddedAsync:Ao,threshold:Fo,transform:Vo},linalg:{bandPart:zo,gramSchmidt:Ro,qr:Bo},losses:{absoluteDifference:qo,computeWeightedLoss:Ko,cosineDistance:Uo,hingeLoss:Wo,huberLoss:jo,logLoss:Ho,meanSquaredError:Go,sigmoidCrossEntropy:Zo,softmaxCrossEntropy:Qo},spectral:{fft:va,ifft:_a,rfft:$a,irfft:Sa},fused:lo,signal:{hammingWindow:co,hannWindow:ho,frame:mo,stft:fo},sparse:{sparseFillEmptyRows:Yo,sparseReshape:Xo,sparseSegmentMean:Jo,sparseSegmentSum:ei},string:{stringNGrams:ti,stringSplit:ni,stringToHashBucketFast:ri}};function ai(e,n,r=""){if("number"!=typeof e&&"number"!=typeof n){t.util.assert(e.length===n.length,(()=>r+` Shapes ${e} and ${n} must match`));for(let s=0;s<e.length;s++){const a=e[s],o=n[s];t.util.assert(a<0||o<0||a===o,(()=>r+` Shapes ${e} and ${n} must match`))}}}function oi(e){return"number"!=typeof e&&!e.some((e=>e<0))}function ii(e,t,n){let r=ui(e,n);const s=!oi(r);if(s&&0===t.length)throw new Error(`Tried to calculate elements of an empty list with non-fully-defined elementShape: ${r}`);if(s&&t.forEach((e=>{r=ui(e.shape,r)})),!oi(r))throw new Error(`Non-fully-defined elementShape: ${r}`);return r}function ui(e,t){if("number"==typeof e)return t;if("number"==typeof t)return e;if(e.length!==t.length)throw new Error(`Incompatible ranks during merge: ${e} vs. ${t}`);const n=[];for(let r=0;r<e.length;++r){const s=e[r],a=t[r];if(s>=0&&a>=0&&s!==a)throw new Error(`Incompatible shape during merge: ${e} vs. ${t}`);n[r]=s>=0?s:a}return n}class pi{constructor(e,n,r,s,a,o,i){this.name=e,this.dtype=n,this.maxSize=r,this.elementShape=s,this.identicalElementShapes=a,this.dynamicSize=o,this.clearAfterRead=i,this.tensors=[],this.closed_=!1,this.idTensor=t.scalar(0),t.keep(this.idTensor)}get id(){return this.idTensor.id}get closed(){return this.closed_}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.tensor.id)||t.tensor.dispose()})),this.tensors=[],this.closed_=!0,this.idTensor.dispose()}size(){return this.tensors.length}read(e){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||e>=this.size())throw new Error(`Tried to read from index ${e}, but array size is: ${this.size()}`);const t=this.tensors[e];if(t.cleared)throw new Error(`TensorArray ${this.name}: Could not read index ${e} twice because it was cleared after a previous read (perhaps try setting clear_after_read = false?).`);return this.clearAfterRead&&(t.cleared=!0),t.read=!0,t.tensor}readMany(e){return e.map((e=>this.read(e)))}write(e,n){if(this.closed_)throw new Error(`TensorArray ${this.name} has already been closed.`);if(e<0||!this.dynamicSize&&e>=this.maxSize)throw new Error(`Tried to write to index ${e}, but array is not resizeable and size is: ${this.maxSize}`);const r=this.tensors[e]||{};if(n.dtype!==this.dtype)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e},\n          because the value dtype is ${n.dtype}, but TensorArray dtype is ${this.dtype}.`);if(0!==this.size()||null!=this.elementShape&&0!==this.elementShape.length||(this.elementShape=n.shape),ai(this.elementShape,n.shape,`TensorArray ${this.name}: Could not write to TensorArray index ${e}.`),r.read)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been read.`);if(r.written)throw new Error(`TensorArray ${this.name}: Could not write to TensorArray index ${e}, because it has already been written.`);r.tensor=n,t.keep(n),r.written=!0,this.tensors[e]=r}writeMany(e,t){if(e.length!==t.length)throw new Error(`TensorArray ${this.name}: could not write multiple tensors,because the index size: ${e.length} is not the same as tensors size: ${t.length}.`);e.forEach(((e,n)=>this.write(e,t[n])))}gather(e,n){if(n&&n!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but gather requested dtype ${n}`);if(e)e=e.slice(0,this.size());else{e=[];for(let t=0;t<this.size();t++)e.push(t)}if(0===e.length)return t.tensor([],[0].concat(this.elementShape));const r=this.readMany(e);return ai(this.elementShape,r[0].shape,"TensorArray shape mismatch: "),t.stack(r,0)}concat(e){if(e&&e!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but concat requested dtype ${e}`);if(0===this.size())return t.tensor([],[0].concat(this.elementShape));const n=[];for(let e=0;e<this.size();e++)n.push(e);const r=this.readMany(n);return ai(this.elementShape,r[0].shape,`TensorArray shape mismatch: tensor array shape (${this.elementShape}) vs first tensor shape (${r[0].shape})`),t.concat(r,0)}scatter(e,n){if(n.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${n.dtype}`);if(e.length!==n.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${e.length} vs. ${n.shape[0]}`);const r=Math.max(...e);if(!this.dynamicSize&&r>=this.maxSize)throw new Error(`Max index must be < array size (${r}  vs. ${this.maxSize})`);this.writeMany(e,t.unstack(n,0))}split(e,n){if(n.dtype!==this.dtype)throw new Error(`TensorArray dtype is ${this.dtype} but tensor has dtype ${n.dtype}`);let r=0;const s=e.map((e=>(r+=e,r)));if(r!==n.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${r}, and tensor's shape is: ${n.shape}`);if(!this.dynamicSize&&e.length!==this.maxSize)throw new Error(`TensorArray's size is not equal to the size of lengths (${this.maxSize} vs. ${e.length}), and the TensorArray is not marked as dynamically resizeable`);const a=0===r?0:n.size/r,o=[];t.tidy((()=>{n=t.reshape(n,[1,r,a]);for(let r=0;r<e.length;++r){const i=[0,0===r?0:s[r-1],0],u=[1,e[r],a];o[r]=t.reshape(t.slice(n,i,u),this.elementShape)}return o}));const i=[];for(let t=0;t<e.length;t++)i[t]=t;this.writeMany(i,o)}}class li{constructor(e,n,r,s=-1){this.tensors=e,this.elementShape=n,this.elementDtype=r,null!=e&&e.forEach((e=>{if(r!==e.dtype)throw new Error(`Invalid data types; op elements ${r}, but list elements ${e.dtype}`);ai(n,e.shape,"TensorList shape mismatch: "),t.keep(e)})),this.idTensor=t.scalar(0),this.maxNumElements=s,t.keep(this.idTensor)}get id(){return this.idTensor.id}copy(){return new li([...this.tensors],this.elementShape,this.elementDtype)}clearAndClose(e){this.tensors.forEach((t=>{null!=e&&e.has(t.id)||t.dispose()})),this.tensors.length=0,this.idTensor.dispose()}size(){return this.tensors.length}stack(e,n,r=-1){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(-1!==r&&this.tensors.length!==r)throw new Error(`Operation expected a list with ${r} elements but got a list with ${this.tensors.length} elements.`);ai(e,this.elementShape,"TensorList shape mismatch: ");const s=ii(this.elementShape,this.tensors,e);return t.tidy((()=>{const e=this.tensors.map((e=>t.reshape(e,s)));return t.stack(e,0)}))}popBack(e,n){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);if(0===this.size())throw new Error("Trying to pop from an empty list.");const r=ii(this.elementShape,this.tensors,e),s=this.tensors.pop();return ai(s.shape,e,"TensorList shape mismatch: "),t.reshape(s,r)}pushBack(e){if(e.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${this.elementDtype}`);if(ai(e.shape,this.elementShape,"TensorList shape mismatch: "),this.maxNumElements===this.size())throw new Error("Trying to push element into a full list.");t.keep(e),this.tensors.push(e)}resize(e){if(e<0)throw new Error(`TensorListResize expects size to be non-negative. Got: ${e}`);if(-1!==this.maxNumElements&&e>this.maxNumElements)throw new Error(`TensorListResize input size ${e} is greater maxNumElement ${this.maxNumElements}.`);const t=new li([],this.elementShape,this.elementDtype,this.maxNumElements);t.tensors.length=e;for(let n=0;n<Math.min(this.tensors.length,e);++n)t.tensors[n]=this.tensors[n];return t}getItem(e,n,r){if(r!==this.elementDtype)throw new Error(`Invalid data types; op elements ${r}, but list elements ${this.elementDtype}`);if(e<0||e>this.tensors.length)throw new Error(`Trying to access element ${e} in a list with ${this.tensors.length} elements.`);if(null==this.tensors[e])throw new Error(`element at index ${e} is null.`);ai(this.tensors[e].shape,n,"TensorList shape mismatch: ");const s=ii(this.elementShape,this.tensors,n);return t.reshape(this.tensors[e],s)}setItem(e,n){if(n.dtype!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n.dtype}, but list elements ${this.elementDtype}`);if(e<0||-1!==this.maxNumElements&&e>=this.maxNumElements)throw new Error(`Trying to set element ${e} in a list with max ${this.maxNumElements} elements.`);ai(this.elementShape,n.shape,"TensorList shape mismatch: "),t.keep(n),this.tensors[e]=n}gather(e,n,r){if(n!==this.elementDtype)throw new Error(`Invalid data types; op elements ${n}, but list elements ${this.elementDtype}`);ai(this.elementShape,r,"TensorList shape mismatch: "),e=e.slice(0,this.size());const s=ii(this.elementShape,this.tensors,r);return 0===e.length?t.tensor([],[0].concat(s)):t.tidy((()=>{const n=e.map((e=>t.reshape(this.tensors[e],s)));return t.stack(n,0)}))}concat(e,n){if(e&&e!==this.elementDtype)throw new Error(`TensorList dtype is ${this.elementDtype} but concat requested dtype ${e}`);ai(this.elementShape,n,"TensorList shape mismatch: ");const r=ii(this.elementShape,this.tensors,n);return 0===this.size()?t.tensor([],[0].concat(r)):t.tidy((()=>{const e=this.tensors.map((e=>t.reshape(e,r)));return t.concat(e,0)}))}}const ci=async(e,n,r)=>{switch(e.op){case"If":case"StatelessIf":{const t=u("thenBranch",e,n,r),s=u("elseBranch",e,n,r),a=u("cond",e,n,r),o=u("args",e,n,r);return(await a.data())[0]?r.functionMap[t].executeFunctionAsync(o,r.tensorArrayMap,r.tensorListMap):r.functionMap[s].executeFunctionAsync(o,r.tensorArrayMap,r.tensorListMap)}case"While":case"StatelessWhile":{const t=u("body",e,n,r),s=u("cond",e,n,r),a=u("args",e,n,r),o=await r.functionMap[s].executeFunctionAsync(a,r.tensorArrayMap,r.tensorListMap),i=a.map((e=>e.id));let p=await o[0].data();o.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||e.dispose()}));let l=a;for(;p[0];){const e=l;l=await r.functionMap[t].executeFunctionAsync(l,r.tensorArrayMap,r.tensorListMap);const n=l.map((e=>e.id));e.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||-1!==n.indexOf(e.id)||e.dispose()}));const a=await r.functionMap[s].executeFunctionAsync(l,r.tensorArrayMap,r.tensorListMap);p=await a[0].data(),a.forEach((e=>{e.kept||-1!==i.indexOf(e.id)||-1!==n.indexOf(e.id)||e.dispose()}))}return l}case"LoopCond":return[m(u("pred",e,n,r))];case"Switch":{const t=u("pred",e,n,r);let s=u("data",e,n,r);return s.kept||(s=m(s)),(await t.data())[0]?[void 0,s]:[s,void 0]}case"Merge":{const t=e.inputNames.find((e=>void 0!==p(e,n,r)));if(t){return[m(p(t,n,r))]}return}case"Enter":{const t=u("frameName",e,n,r),s=u("tensor",e,n,r);return r.enterFrame(t),[m(s)]}case"Exit":{const t=u("tensor",e,n,r);return r.exitFrame(),[m(t)]}case"NextIteration":{const t=u("tensor",e,n,r);return r.nextIteration(),[m(t)]}case"TensorArrayV3":{const s=u("size",e,n,r),a=u("dtype",e,n,r),o=u("elementShape",e,n,r),i=u("dynamicSize",e,n,r),p=u("clearAfterRead",e,n,r),l=u("identicalElementShapes",e,n,r),c=u("name",e,n,r),h=new pi(c,a,s,o,l,i,p);return r.addTensorArray(h),[h.idTensor,t.scalar(1)]}case"TensorArrayWriteV3":{const t=u("tensorArrayId",e,n,r),s=u("index",e,n,r),a=u("tensor",e,n,r),o=r.getTensorArray(t.id);return o.write(s,a),[o.idTensor]}case"TensorArrayReadV3":{const t=u("tensorArrayId",e,n,r),s=u("index",e,n,r);return[r.getTensorArray(t.id).read(s)]}case"TensorArrayGatherV3":{const t=u("tensorArrayId",e,n,r),s=u("indices",e,n,r),a=u("dtype",e,n,r);return[r.getTensorArray(t.id).gather(s,a)]}case"TensorArrayScatterV3":{const t=u("tensorArrayId",e,n,r),s=u("indices",e,n,r),a=u("tensor",e,n,r),o=r.getTensorArray(t.id);return o.scatter(s,a),[o.idTensor]}case"TensorArrayConcatV3":{const t=u("tensorArrayId",e,n,r),s=r.getTensorArray(t.id),a=u("dtype",e,n,r);return[s.concat(a)]}case"TensorArraySplitV3":{const t=u("tensorArrayId",e,n,r),s=u("tensor",e,n,r),a=u("lengths",e,n,r),o=r.getTensorArray(t.id);return o.split(a,s),[o.idTensor]}case"TensorArraySizeV3":{const s=u("tensorArrayId",e,n,r),a=r.getTensorArray(s.id);return[t.scalar(a.size(),"int32")]}case"TensorArrayCloseV3":{const t=u("tensorArrayId",e,n,r),s=r.getTensorArray(t.id);return s.clearAndClose(),[s.idTensor]}case"TensorListSetItem":{const t=u("tensorListId",e,n,r),s=u("index",e,n,r),a=u("tensor",e,n,r),o=r.getTensorList(t.id);return o.setItem(s,a),[o.idTensor]}case"TensorListGetItem":{const t=u("tensorListId",e,n,r),s=u("index",e,n,r),a=u("elementShape",e,n,r),o=u("elementDType",e,n,r);return[r.getTensorList(t.id).getItem(s,a,o)]}case"TensorListScatterV2":case"TensorListScatter":{const s=u("indices",e,n,r),a=function(e,n,r,s){if(n.length!==e.shape[0])throw new Error(`Expected len(indices) == tensor.shape[0], but saw: ${n.length} vs. ${e.shape[0]}`);const a=Math.max(...n);if(null!=s&&-1!==s&&a>=s)throw new Error(`Max index must be < array size (${a}  vs. ${s})`);const o=new li([],r,e.dtype,s),i=t.unstack(e,0);return n.forEach(((e,t)=>{o.setItem(e,i[t])})),o}(u("tensor",e,n,r),s,u("elementShape",e,n,r),u("numElements",e,n,r));return r.addTensorList(a),[a.idTensor]}case"TensorListReserve":case"EmptyTensorList":{const t=u("elementShape",e,n,r),s=u("elementDType",e,n,r);let a;a="TensorListReserve"===e.op?"numElements":"maxNumElements";const o=u(a,e,n,r),i=function(e,t,n,r){return new li([],e,t,r)}(t,s,0,"TensorListReserve"===e.op?-1:o);return r.addTensorList(i),[i.idTensor]}case"TensorListGather":{const t=u("tensorListId",e,n,r),s=u("indices",e,n,r),a=u("elementShape",e,n,r),o=u("elementDType",e,n,r);return[r.getTensorList(t.id).gather(s,o,a)]}case"TensorListStack":{const t=u("tensorListId",e,n,r),s=u("elementShape",e,n,r),a=u("elementDType",e,n,r),o=u("numElements",e,n,r);return[r.getTensorList(t.id).stack(s,a,o)]}case"TensorListFromTensor":{const s=function(e,n,r){const s=e.dtype;if(e.shape.length<1)throw new Error(`Tensor must be at least a vector, but saw shape: ${e.shape}`);if(e.dtype!==r)throw new Error(`Invalid data types; op elements ${e.dtype}, but list elements ${r}`);ai(e.shape.slice(1),n,"TensorList shape mismatch: ");const a=t.unstack(e);return new li(a,n,s)}(u("tensor",e,n,r),u("elementShape",e,n,r),u("elementDType",e,n,r));return r.addTensorList(s),[s.idTensor]}case"TensorListConcat":case"TensorListConcatV2":{const t=u("tensorListId",e,n,r),s=r.getTensorList(t.id),a=u("dtype",e,n,r),o=u("elementShape",e,n,r);return[s.concat(a,o)]}case"TensorListPushBack":{const t=u("tensorListId",e,n,r),s=u("tensor",e,n,r),a=r.getTensorList(t.id);return a.pushBack(s),[a.idTensor]}case"TensorListPopBack":{const t=u("tensorListId",e,n,r),s=u("elementShape",e,n,r),a=u("elementDType",e,n,r);return[r.getTensorList(t.id).popBack(s,a)]}case"TensorListSplit":{const s=u("tensor",e,n,r),a=u("elementShape",e,n,r),o=function(e,n,r){let s=0;const a=n.map((e=>(s+=e,s)));if(s!==e.shape[0])throw new Error(`Expected sum of lengths to be equal to\n          tensor.shape[0], but sum of lengths is\n        ${s}, and tensor's shape is: ${e.shape}`);const o=ui(e.shape.slice(1),r),i=0===s?0:e.size/s,u=t.tidy((()=>{const r=[];e=t.reshape(e,[1,s,i]);for(let s=0;s<n.length;++s){const u=[0,0===s?0:a[s-1],0],p=[1,n[s],i];r[s]=t.reshape(t.slice(e,u,p),o)}return e.dispose(),r})),p=new li([],r,e.dtype,n.length);for(let e=0;e<u.length;e++)p.setItem(e,u[e]);return p}(s,u("lengths",e,n,r),a);return r.addTensorList(o),[o.idTensor]}case"TensorListLength":{const s=u("tensorListId",e,n,r),a=r.getTensorList(s.id);return[t.scalar(a.size(),"int32")]}case"TensorListResize":{const t=u("tensorListId",e,n,r),s=u("size",e,n,r),a=r.getTensorList(t.id).resize(s);return r.addTensorList(a),[a.idTensor]}default:throw TypeError(`Node type ${e.op} is not implemented`)}};function hi(e,t,n){const[r,s]=u("fusedOps",e,t,n),a="biasadd"===r,o=!a,i="prelu"===s,p="fusedbatchnorm"===r,l=u("numArgs",e,t,n);if(a){if(i&&2!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&a&&1!==l)throw new Error("FusedConv2d and DepthwiseConv2d with BiasAdd must have one extra argument: bias.")}if(p)throw new Error("FusedConv2d and DepthwiseConv2d with FusedBatchNorm is not supported");const c=u("strides",e,t,n),h=d(e,t,n),m=u("dataFormat",e,t,n).toUpperCase(),f=u("dilations",e,t,n);let[y,g]=u("args",e,t,n);o&&(g=y,y=void 0);return{stride:c,pad:h,dataFormat:m,dilations:f,biasArg:y,preluArg:g,activationFunc:s,leakyreluAlpha:u("leakyreluAlpha",e,t,n)}}function di(e,t,n){return{boxes:u("boxes",e,t,n),scores:u("scores",e,t,n),maxOutputSize:u("maxOutputSize",e,t,n),iouThreshold:u("iouThreshold",e,t,n),scoreThreshold:u("scoreThreshold",e,t,n),softNmsSigma:u("softNmsSigma",e,t,n)}}class mi{constructor(e,n){this.keyDType=e,this.valueDType=n,this.handle=t.scalar(0),this.tensorMap=new Map,t.keep(this.handle)}get id(){return this.handle.id}clearAndClose(){this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),this.handle.dispose()}size(){return this.tensorMap.size}tensorSize(){return Tr(this.size(),"int32")}async import(e,n){this.checkKeyAndValueTensor(e,n);const r=await e.data();return this.tensorMap.forEach((e=>e.dispose())),this.tensorMap.clear(),t.tidy((()=>{const e=t.unstack(n),s=r.length,a=e.length;t.util.assert(s===a,(()=>`The number of elements doesn't match, keys has ${s} elements, the values has ${a} elements.`));for(let n=0;n<s;n++){const s=r[n],a=e[n];t.keep(a),this.tensorMap.set(s,a)}return this.handle}))}async find(e,n){this.checkKeyAndValueTensor(e,n);const r=await e.data();return t.tidy((()=>{const e=[];for(let t=0;t<r.length;t++){const s=r[t],a=this.findWithDefault(s,n);e.push(a)}return t.stack(e)}))}findWithDefault(e,t){const n=this.tensorMap.get(e);return null!=n?n:t}checkKeyAndValueTensor(e,t){if(e.dtype!==this.keyDType)throw new Error(`Expect key dtype ${this.keyDType}, but got ${e.dtype}`);if(t.dtype!==this.valueDType)throw new Error(`Expect value dtype ${this.valueDType}, but got ${t.dtype}`)}}function fi(e,n,s,a,o=r.tidy){const l=((e,n,r)=>{switch(e.category){case"arithmetic":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"BiasAdd":case"AddV2":case"Add":return[r.add(u("a",e,t,n),u("b",e,t,n))];case"AddN":return[r.addN(u("tensors",e,t,n))];case"FloorMod":case"Mod":return[r.mod(u("a",e,t,n),u("b",e,t,n))];case"Mul":return[r.mul(u("a",e,t,n),u("b",e,t,n))];case"RealDiv":case"Div":return[r.div(u("a",e,t,n),u("b",e,t,n))];case"DivNoNan":return[r.divNoNan(u("a",e,t,n),u("b",e,t,n))];case"FloorDiv":return[r.floorDiv(u("a",e,t,n),u("b",e,t,n))];case"Sub":return[r.sub(u("a",e,t,n),u("b",e,t,n))];case"Minimum":return[r.minimum(u("a",e,t,n),u("b",e,t,n))];case"Maximum":return[r.maximum(u("a",e,t,n),u("b",e,t,n))];case"Pow":return[r.pow(u("a",e,t,n),u("b",e,t,n))];case"SquaredDifference":return[r.squaredDifference(u("a",e,t,n),u("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"basic_math":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Abs":case"ComplexAbs":return[r.abs(u("x",e,t,n))];case"Acos":return[r.acos(u("x",e,t,n))];case"Acosh":return[r.acosh(u("x",e,t,n))];case"Asin":return[r.asin(u("x",e,t,n))];case"Asinh":return[r.asinh(u("x",e,t,n))];case"Atan":return[r.atan(u("x",e,t,n))];case"Atan2":return[r.atan2(u("x",e,t,n),u("y",e,t,n))];case"Atanh":return[r.atanh(u("x",e,t,n))];case"Ceil":return[r.ceil(u("x",e,t,n))];case"Complex":return[r.complex(u("real",e,t,n),u("imag",e,t,n))];case"Cos":return[r.cos(u("x",e,t,n))];case"Cosh":return[r.cosh(u("x",e,t,n))];case"Elu":return[r.elu(u("x",e,t,n))];case"Erf":return[r.erf(u("x",e,t,n))];case"Exp":return[r.exp(u("x",e,t,n))];case"Expm1":return[r.expm1(u("x",e,t,n))];case"Floor":return[r.floor(u("x",e,t,n))];case"Log":return[r.log(u("x",e,t,n))];case"Log1p":return[r.log1p(u("x",e,t,n))];case"Imag":return[r.imag(u("x",e,t,n))];case"Neg":return[r.neg(u("x",e,t,n))];case"Reciprocal":return[r.reciprocal(u("x",e,t,n))];case"Real":return[r.real(u("x",e,t,n))];case"Relu":return[r.relu(u("x",e,t,n))];case"Round":return[r.round(u("x",e,t,n))];case"Selu":return[r.selu(u("x",e,t,n))];case"Sigmoid":return[r.sigmoid(u("x",e,t,n))];case"Sin":return[r.sin(u("x",e,t,n))];case"Sign":return[r.sign(u("x",e,t,n))];case"Sinh":return[r.sinh(u("x",e,t,n))];case"Softplus":return[r.softplus(u("x",e,t,n))];case"Sqrt":return[r.sqrt(u("x",e,t,n))];case"Square":return[r.square(u("x",e,t,n))];case"Tanh":return[r.tanh(u("x",e,t,n))];case"Tan":return[r.tan(u("x",e,t,n))];case"ClipByValue":return[r.clipByValue(u("x",e,t,n),u("clipValueMin",e,t,n),u("clipValueMax",e,t,n))];case"Relu6":return[r.relu6(u("x",e,t,n))];case"Rsqrt":return[r.rsqrt(p(e.inputNames[0],t,n))];case"Prod":return[r.prod(u("x",e,t,n),u("axes",e,t,n))];case"LeakyRelu":return[r.leakyRelu(u("x",e,t,n),u("alpha",e,t,n))];case"Prelu":return[r.prelu(u("x",e,t,n),u("alpha",e,t,n))];case"IsNan":return[r.isNaN(p(e.inputNames[0],t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"control":return ci(e,n,r);case"convolution":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Conv1D":{const s=u("stride",e,t,n),a=u("pad",e,t,n),o=u("dataFormat",e,t,n).toUpperCase(),i=u("dilation",e,t,n);return[r.conv1d(u("x",e,t,n),u("filter",e,t,n),s,a,o,i)]}case"Conv2D":{const s=u("strides",e,t,n),a=d(e,t,n),o=u("dataFormat",e,t,n).toUpperCase(),i=u("dilations",e,t,n);return[r.conv2d(u("x",e,t,n),u("filter",e,t,n),[s[1],s[2]],a,o,[i[1],i[2]])]}case"_FusedConv2D":{const{stride:s,pad:a,dataFormat:o,dilations:i,biasArg:p,preluArg:l,activationFunc:c,leakyreluAlpha:h}=hi(e,t,n);return[r.fused.conv2d({x:u("x",e,t,n),filter:u("filter",e,t,n),strides:[s[1],s[2]],pad:a,dataFormat:o,dilations:[i[1],i[2]],bias:p,activation:c,preluActivationWeights:l,leakyreluAlpha:h})]}case"FusedDepthwiseConv2dNative":{const{stride:s,pad:a,dataFormat:o,dilations:i,biasArg:p,preluArg:l,activationFunc:c,leakyreluAlpha:h}=hi(e,t,n);return[r.fused.depthwiseConv2d({x:u("x",e,t,n),filter:u("filter",e,t,n),strides:[s[1],s[2]],pad:a,dataFormat:o,dilations:[i[1],i[2]],bias:p,activation:c,preluActivationWeights:l,leakyreluAlpha:h})]}case"Conv2DBackpropInput":case"Conv2dTranspose":{const s=u("outputShape",e,t,n),a=u("strides",e,t,n),o=d(e,t,n);return[r.conv2dTranspose(u("x",e,t,n),u("filter",e,t,n),s,[a[1],a[2]],o)]}case"DepthwiseConv2dNative":case"DepthwiseConv2d":{const s=u("strides",e,t,n),a=d(e,t,n),o=u("dilations",e,t,n),i=u("dataFormat",e,t,n).toUpperCase();return[r.depthwiseConv2d(u("input",e,t,n),u("filter",e,t,n),[s[1],s[2]],a,i,[o[1],o[2]])]}case"Conv3D":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("dataFormat",e,t,n).toUpperCase(),i=u("dilations",e,t,n);return[r.conv3d(u("x",e,t,n),u("filter",e,t,n),[s[1],s[2],s[3]],a,o,[i[1],i[2],i[3]])]}case"AvgPool":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("kernelSize",e,t,n);return[r.avgPool(u("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a)]}case"MaxPool":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("kernelSize",e,t,n);return[r.maxPool(u("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a)]}case"MaxPoolWithArgmax":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("kernelSize",e,t,n),i=u("includeBatchInIndex",e,t,n),{result:p,indexes:l}=r.maxPoolWithArgmax(u("x",e,t,n),[o[1],o[2]],[s[1],s[2]],a,i);return[p,l]}case"AvgPool3D":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("kernelSize",e,t,n);return[r.avgPool3d(u("x",e,t,n),[o[1],o[2],o[3]],[s[1],s[2],s[3]],a)]}case"MaxPool3D":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("kernelSize",e,t,n);return[r.maxPool3d(u("x",e,t,n),[o[1],o[2],o[3]],[s[1],s[2],s[3]],a)]}case"Dilation2D":{const s=u("strides",e,t,n),a=u("pad",e,t,n),o=u("dilations",e,t,n),i=s[1],p=s[2],l=o[1],c=o[2];return[r.dilation2d(u("x",e,t,n),u("filter",e,t,n),[i,p],a,[l,c],"NHWC")]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"creation":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Fill":{const s=u("shape",e,t,n),a=u("dtype",e,t,n),o=u("value",e,t,n);return[r.fill(s,o,a)]}case"LinSpace":{const s=u("start",e,t,n),a=u("stop",e,t,n),o=u("num",e,t,n);return[r.linspace(s,a,o)]}case"Multinomial":{const s=u("logits",e,t,n),a=u("numSamples",e,t,n),o=u("seed",e,t,n);return[r.multinomial(s,a,o)]}case"OneHot":{const s=u("indices",e,t,n),a=u("depth",e,t,n),o=u("onValue",e,t,n),i=u("offValue",e,t,n);return[r.oneHot(s,a,o,i)]}case"Ones":return[r.ones(u("shape",e,t,n),u("dtype",e,t,n))];case"OnesLike":return[r.onesLike(u("x",e,t,n))];case"RandomStandardNormal":return[r.randomStandardNormal(u("shape",e,t,n),u("dtype",e,t,n),u("seed",e,t,n))];case"RandomUniform":return[r.randomUniform(u("shape",e,t,n),u("minval",e,t,n),u("maxval",e,t,n),u("dtype",e,t,n))];case"Range":{const s=u("start",e,t,n),a=u("stop",e,t,n),o=u("step",e,t,n);return[r.range(s,a,o,u("dtype",e,t,n))]}case"TruncatedNormal":{const s=u("shape",e,t,n),a=u("mean",e,t,n),o=u("stdDev",e,t,n),i=u("seed",e,t,n);return[r.truncatedNormal(s,a,o,u("dtype",e,t,n),i)]}case"Zeros":return[r.zeros(u("shape",e,t,n),u("dtype",e,t,n))];case"ZerosLike":return[r.zerosLike(u("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"dynamic":return(async(e,t,n,r,s=si)=>{switch(e.op){case"NonMaxSuppressionV5":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:u,softNmsSigma:p}=di(e,t,n),l=await s.image.nonMaxSuppressionWithScoreAsync(r,a,o,i,u,p);return[l.selectedIndices,l.selectedScores]}case"NonMaxSuppressionV4":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:p}=di(e,t,n),l=u("padToMaxOutputSize",e,t,n),c=await s.image.nonMaxSuppressionPaddedAsync(r,a,o,i,p,l);return[c.selectedIndices,c.validOutputs]}case"NonMaxSuppressionV3":case"NonMaxSuppressionV2":{const{boxes:r,scores:a,maxOutputSize:o,iouThreshold:i,scoreThreshold:u}=di(e,t,n);return[await s.image.nonMaxSuppressionAsync(r,a,o,i,u)]}case"Where":{const r=s.cast(u("condition",e,t,n),"bool"),a=[await s.whereAsync(r)];return r.dispose(),a}case"ListDiff":return s.setdiff1dAsync(u("x",e,t,n),u("y",e,t,n));default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r);case"evaluation":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"LowerBound":{const s=u("sortedSequence",e,t,n),a=u("values",e,t,n);return[r.lowerBound(s,a)]}case"TopKV2":{const s=u("x",e,t,n),a=u("k",e,t,n),o=u("sorted",e,t,n),i=r.topk(s,a,o);return[i.values,i.indices]}case"UpperBound":{const s=u("sortedSequence",e,t,n),a=u("values",e,t,n);return[r.upperBound(s,a)]}case"Unique":{const s=u("x",e,t,n),a=r.unique(s);return[a.values,a.indices]}case"UniqueV2":{const s=u("x",e,t,n),a=u("axis",e,t,n),o=r.unique(s,a);return[o.values,o.indices]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"image":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"ResizeBilinear":{const s=u("images",e,t,n),a=u("size",e,t,n),o=u("alignCorners",e,t,n),i=u("halfPixelCenters",e,t,n);return[r.image.resizeBilinear(s,[a[0],a[1]],o,i)]}case"ResizeNearestNeighbor":{const s=u("images",e,t,n),a=u("size",e,t,n),o=u("alignCorners",e,t,n),i=u("halfPixelCenters",e,t,n);return[r.image.resizeNearestNeighbor(s,[a[0],a[1]],o,i)]}case"CropAndResize":{const s=u("image",e,t,n),a=u("boxes",e,t,n),o=u("boxInd",e,t,n),i=u("cropSize",e,t,n),p=u("method",e,t,n),l=u("extrapolationValue",e,t,n);return[r.image.cropAndResize(s,a,o,i,p,l)]}case"ImageProjectiveTransformV3":{const s=u("images",e,t,n),a=u("transforms",e,t,n),o=u("outputShape",e,t,n),i=u("fillValue",e,t,n),p=u("interpolation",e,t,n),l=u("fillMode",e,t,n);return[r.image.transform(s,a,p.toLowerCase(),l.toLowerCase(),i,o)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"graph":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Const":return t[e.name];case"PlaceholderWithDefault":const s=u("default",e,t,n);return[p(e.name,t,n)||s];case"Placeholder":return[p(e.name,t,n)];case"Identity":case"StopGradient":case"FakeQuantWithMinMaxVars":case"Snapshot":return[m(u("x",e,t,n))];case"IdentityN":return u("x",e,t,n).map((e=>m(e)));case"Shape":return[r.tensor1d(u("x",e,t,n).shape,"int32")];case"ShapeN":return u("x",e,t,n).map((e=>r.tensor1d(e.shape)));case"Size":return[r.scalar(u("x",e,t,n).size,"int32")];case"Rank":return[r.scalar(u("x",e,t,n).rank,"int32")];case"NoOp":return[r.scalar(1)];case"Print":const a=u("x",e,t,n),o=u("data",e,t,n),i=u("message",e,t,n),l=u("summarize",e,t,n);console.warn("The graph has a tf.print() operation,usually used for debugging, which slows down performance."),console.log(i);for(let e=0;e<o.length;e++)console.log(Array.prototype.slice.call(o[e].dataSync()).slice(0,l));return[a];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"logical":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Equal":return[r.equal(u("a",e,t,n),u("b",e,t,n))];case"NotEqual":return[r.notEqual(u("a",e,t,n),u("b",e,t,n))];case"Greater":return[r.greater(u("a",e,t,n),u("b",e,t,n))];case"GreaterEqual":return[r.greaterEqual(u("a",e,t,n),u("b",e,t,n))];case"Less":return[r.less(u("a",e,t,n),u("b",e,t,n))];case"LessEqual":return[r.lessEqual(u("a",e,t,n),u("b",e,t,n))];case"LogicalAnd":return[r.logicalAnd(u("a",e,t,n),u("b",e,t,n))];case"LogicalNot":return[r.logicalNot(u("a",e,t,n))];case"LogicalOr":return[r.logicalOr(u("a",e,t,n),u("b",e,t,n))];case"Select":case"SelectV2":return[r.where(u("condition",e,t,n),u("a",e,t,n),u("b",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"matrices":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"BatchMatMul":case"BatchMatMulV2":case"MatMul":return[r.matMul(u("a",e,t,n),u("b",e,t,n),u("transposeA",e,t,n),u("transposeB",e,t,n))];case"Einsum":return[r.einsum(u("equation",e,t,n),...u("tensors",e,t,n))];case"Transpose":return[r.transpose(u("x",e,t,n),u("perm",e,t,n))];case"_FusedMatMul":const[s,a]=u("fusedOps",e,t,n),o="biasadd"===s,i="prelu"===a,p=u("numArgs",e,t,n),l=u("leakyreluAlpha",e,t,n);if(o){if(i&&2!==p)throw new Error("Fused MatMul with BiasAdd and Prelu must have two extra arguments: bias and alpha.");if(!i&&1!==p)throw new Error("Fused MatMul with BiasAdd must have one extra argument: bias.")}const[c,h]=u("args",e,t,n);return[r.fused.matMul({a:u("a",e,t,n),b:u("b",e,t,n),transposeA:u("transposeA",e,t,n),transposeB:u("transposeB",e,t,n),bias:c,activation:a,preluActivationWeights:h,leakyreluAlpha:l})];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"normalization":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"EuclideanNorm":return[r.euclideanNorm(u("x",e,t,n),u("axis",e,t,n),u("keepDims",e,t,n))];case"FusedBatchNorm":case"FusedBatchNormV2":case"FusedBatchNormV3":return[r.batchNorm(u("x",e,t,n),u("mean",e,t,n),u("variance",e,t,n),u("offset",e,t,n),u("scale",e,t,n),u("epsilon",e,t,n))];case"LRN":return[r.localResponseNormalization(u("x",e,t,n),u("radius",e,t,n),u("bias",e,t,n),u("alpha",e,t,n),u("beta",e,t,n))];case"Softmax":return[r.softmax(u("x",e,t,n))];case"LogSoftmax":return[r.logSoftmax(u("x",e,t,n))];case"SparseToDense":return[r.sparseToDense(u("sparseIndices",e,t,n),u("outputShape",e,t,n),u("sparseValues",e,t,n),u("defaultValue",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"reduction":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Max":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.max(u("x",e,t,n),s,a)]}case"Mean":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.mean(u("x",e,t,n),s,a)]}case"Min":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.min(u("x",e,t,n),s,a)]}case"Sum":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.sum(u("x",e,t,n),s,a)]}case"All":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.all(u("x",e,t,n),s,a)]}case"Any":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.any(u("x",e,t,n),s,a)]}case"ArgMax":{const s=u("axis",e,t,n);return[r.argMax(u("x",e,t,n),s)]}case"ArgMin":{const s=u("axis",e,t,n);return[r.argMin(u("x",e,t,n),s)]}case"Prod":{const s=u("axis",e,t,n),a=u("keepDims",e,t,n);return[r.prod(u("x",e,t,n),s,a)]}case"Cumprod":{const s=u("axis",e,t,n),a=u("exclusive",e,t,n),o=u("reverse",e,t,n);return[r.cumprod(u("x",e,t,n),s,a,o)]}case"Cumsum":{const s=u("axis",e,t,n),a=u("exclusive",e,t,n),o=u("reverse",e,t,n);return[r.cumsum(u("x",e,t,n),s,a,o)]}case"Bincount":const s=u("x",e,t,n),a=u("weights",e,t,n),o=u("size",e,t,n);return[r.bincount(s,a,o)];case"DenseBincount":{const s=u("x",e,t,n),a=u("weights",e,t,n),o=u("size",e,t,n),i=u("binaryOutput",e,t,n);return[r.denseBincount(s,a,o,i)]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"slice_join":return o((()=>((e,n,r,s=si)=>{switch(e.op){case"ConcatV2":case"Concat":{const t=u("n",e,n,r),a=u("axis",e,n,r);let o=u("tensors",e,n,r);return o=o.slice(0,t),[s.concat(o,a)]}case"Gather":{const t=u("x",e,n,r),a=u("indices",e,n,r);return[s.gather(t,s.cast(a,"int32"),0)]}case"GatherV2":{const t=u("axis",e,n,r),a=u("batchDims",e,n,r),o=u("x",e,n,r),i=u("indices",e,n,r);return[s.gather(o,s.cast(i,"int32"),t,a)]}case"Reverse":{const t=u("dims",e,n,r),a=[];for(let e=0;e<t.length;e++)t[e]&&a.push(e);const o=u("x",e,n,r);return[s.reverse(o,a)]}case"ReverseV2":{const t=u("axis",e,n,r),a=u("x",e,n,r);return[s.reverse(a,t)]}case"Slice":{const t=u("begin",e,n,r),a=u("size",e,n,r);return[s.slice(u("x",e,n,r),t,a)]}case"StridedSlice":{const t=u("begin",e,n,r),a=u("end",e,n,r),o=u("strides",e,n,r),i=u("beginMask",e,n,r),p=u("endMask",e,n,r),l=u("ellipsisMask",e,n,r),c=u("newAxisMask",e,n,r),h=u("shrinkAxisMask",e,n,r),d=u("x",e,n,r);return[s.stridedSlice(d,t,a,o,i,p,l,c,h)]}case"Pack":return t.tidy((()=>{const a=u("axis",e,n,r),o=u("tensors",e,n,r),i=o[0].shape,p=s.squeeze(o[0]).shape,l=o.map((e=>{const n=t.util.arraysEqual(e.shape,i);if(!n&&!t.util.arraysEqual(s.squeeze(e).shape,p))throw new Error("the input tensors shape does not match");return n?e:s.reshape(e,i)}));return[s.stack(l,a)]}));case"Unpack":{const t=u("axis",e,n,r),a=u("tensor",e,n,r);return s.unstack(a,t)}case"Tile":{const t=u("reps",e,n,r);return[s.tile(u("x",e,n,r),t)]}case"Split":case"SplitV":{const t=u("axis",e,n,r),a=u("numOrSizeSplits",e,n,r),o=u("x",e,n,r);return s.split(o,a,t)}case"ScatterNd":{const t=u("indices",e,n,r),a=u("values",e,n,r),o=u("shape",e,n,r);return[s.scatterND(t,a,o)]}case"GatherNd":{const t=u("x",e,n,r),a=u("indices",e,n,r);return[s.gatherND(t,a)]}case"SparseToDense":{const t=u("sparseIndices",e,n,r),a=u("outputShape",e,n,r),o=u("sparseValues",e,n,r),i=u("defaultValue",e,n,r);return[s.sparseToDense(t,o,a,o.dtype===i.dtype?i:s.cast(i,o.dtype))]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"sparse":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"SparseFillEmptyRows":{const{outputIndices:s,outputValues:a,emptyRowIndicator:o,reverseIndexMap:i}=r.sparse.sparseFillEmptyRows(u("indices",e,t,n),u("values",e,t,n),u("denseShape",e,t,n),u("defaultValue",e,t,n));return[s,a,o,i]}case"SparseReshape":{const{outputIndices:s,outputShape:a}=r.sparse.sparseReshape(u("inputIndices",e,t,n),u("inputShape",e,t,n),u("newShape",e,t,n));return[s,a]}case"SparseSegmentMean":return[r.sparse.sparseSegmentMean(u("data",e,t,n),u("indices",e,t,n),u("segmentIds",e,t,n))];case"SparseSegmentSum":return[r.sparse.sparseSegmentSum(u("data",e,t,n),u("indices",e,t,n),u("segmentIds",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"spectral":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"FFT":return[r.fft(u("x",e,t,n))];case"IFFT":return[r.ifft(u("x",e,t,n))];case"RFFT":return[r.rfft(u("x",e,t,n))];case"IRFFT":return[r.irfft(u("x",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"string":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"StringNGrams":{const{nGrams:s,nGramsSplits:a}=r.string.stringNGrams(u("data",e,t,n),u("dataSplits",e,t,n),u("separator",e,t,n),u("nGramWidths",e,t,n),u("leftPad",e,t,n),u("rightPad",e,t,n),u("padWidth",e,t,n),u("preserveShortSequences",e,t,n));return[s,a]}case"StringSplit":{const{indices:s,values:a,shape:o}=r.string.stringSplit(u("input",e,t,n),u("delimiter",e,t,n),u("skipEmpty",e,t,n));return[s,a,o]}case"StringToHashBucketFast":return[r.string.stringToHashBucketFast(u("input",e,t,n),u("numBuckets",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"transformation":return o((()=>((e,t,n,r=si)=>{switch(e.op){case"Cast":return[r.cast(u("x",e,t,n),u("dtype",e,t,n))];case"ExpandDims":{const s=u("axis",e,t,n);return[r.expandDims(u("x",e,t,n),s)]}case"Squeeze":{const s=u("axis",e,t,n);return[r.squeeze(u("x",e,t,n),s)]}case"Reshape":return[r.reshape(u("x",e,t,n),u("shape",e,t,n))];case"MirrorPad":return[r.mirrorPad(u("x",e,t,n),u("padding",e,t,n),u("mode",e,t,n))];case"PadV2":case"Pad":return[r.pad(u("x",e,t,n),u("padding",e,t,n),u("constantValue",e,t,n))];case"SpaceToBatchND":{const s=u("blockShape",e,t,n),a=u("paddings",e,t,n);return[r.spaceToBatchND(u("x",e,t,n),s,a)]}case"BatchToSpaceND":{const s=u("blockShape",e,t,n),a=u("crops",e,t,n);return[r.batchToSpaceND(u("x",e,t,n),s,a)]}case"DepthToSpace":{const s=u("blockSize",e,t,n),a=u("dataFormat",e,t,n).toUpperCase();return[r.depthToSpace(u("x",e,t,n),s,a)]}case"BroadcastTo":return[r.broadcastTo(u("x",e,t,n),u("shape",e,t,n))];case"BroadcastArgs":return[r.broadcastArgs(u("s0",e,t,n),u("s1",e,t,n))];default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r)));case"hash_table":return(async(e,t,n,r)=>{switch(e.op){case"HashTable":case"HashTableV2":{const s=u("keyDType",e,t,n),a=u("valueDType",e,t,n),o=new mi(s,a);return r.addHashTable(e.name,o),[o.handle]}case"LookupTableImport":case"LookupTableImportV2":{const s=u("tableHandle",e,t,n,r),a=u("keys",e,t,n),o=u("values",e,t,n),i=r.getHashTableById(s.id);return[await i.import(a,o)]}case"LookupTableFind":case"LookupTableFindV2":{const s=u("tableHandle",e,t,n,r),a=u("keys",e,t,n),o=u("defaultValue",e,t,n),i=r.getHashTableById(s.id);return[await i.find(a,o)]}case"LookupTableSize":case"LookupTableSizeV2":{const s=u("tableHandle",e,t,n,r);return[r.getHashTableById(s.id).tensorSize()]}default:throw TypeError(`Node type ${e.op} is not implemented`)}})(e,n,r,a);case"custom":const s=i(e.op);if(s&&s.customExecutor)return s.customExecutor(new Z(e,n,r));throw TypeError(`Custom op ${e.op} is not registered.`);default:throw TypeError(`Unknown op '${e.op}'. File an issue at https://github.com/tensorflow/tfjs/issues so we can add it, or register a custom execution with tf.registerOp()`)}})(e,n,s);return r.util.isPromise(l)?l.then((e=>[].concat(e))):[].concat(l)}class yi{constructor(e={},t={},n={},r={}){this.weightMap=e,this.tensorArrayMap=t,this.tensorListMap=n,this.functionMap=r,this.rootContext={id:0,frameName:"",iterationId:0},this.contexts=[this.rootContext],this.lastId=0,this.generateCurrentContextIds()}newFrame(e,t){return{id:e,frameName:t,iterationId:0}}set currentContext(e){this.contexts!==e&&(this.contexts=e,this.generateCurrentContextIds())}get currentContext(){return this.contexts}get currentContextId(){return this._currentContextIds[0]}get currentContextIds(){return this._currentContextIds}generateCurrentContextIds(){const e=[];for(let t=0;t<this.contexts.length-1;t++){const n=this.contexts.slice(0,this.contexts.length-t);e.push(this.contextIdforContexts(n))}e.push(""),this._currentContextIds=e}contextIdforContexts(e){return e?e.map((e=>0===e.id&&0===e.iterationId?"":`${e.frameName}-${e.iterationId}`)).join("/"):""}enterFrame(e){this.contexts&&(this.lastId++,this.contexts=this.contexts.slice(),this.contexts.push(this.newFrame(this.lastId,e)),this._currentContextIds.unshift(this.contextIdforContexts(this.contexts)))}exitFrame(){if(!(this.contexts&&this.contexts.length>1))throw new Error("Cannot exit frame, the context is empty");this.contexts=this.contexts.slice(),this.contexts.splice(-1),this.currentContextIds.shift()}nextIteration(){if(!(this.contexts&&this.contexts.length>0))throw new Error("Cannot increase frame iteration, the context is empty");{this.contexts=this.contexts.slice(),this.lastId++;const e=Object.assign({},this.contexts[this.contexts.length-1]);e.iterationId+=1,e.id=this.lastId,this.contexts.splice(-1,1,e),this._currentContextIds.splice(0,1,this.contextIdforContexts(this.contexts))}}getWeight(e){return this.weightMap[e]}addTensorArray(e){this.tensorArrayMap[e.id]=e}getTensorArray(e){return this.tensorArrayMap[e]}addTensorList(e){this.tensorListMap[e.id]=e}getTensorList(e){return this.tensorListMap[e]}dispose(e){for(const t in this.tensorArrayMap)this.tensorArrayMap[t].clearAndClose(e);for(const t in this.tensorListMap)this.tensorListMap[t].clearAndClose(e)}}function gi(e,t,n,r){const s=new Set,a=[];let o=null,i=null;const u=new Set,p=Object.keys(e).map((e=>h(e)[0]));let l=[];null!=r&&(l=r.map((e=>h(e.name)[0])));const c=[...t];for(;c.length>0;){const e=c.pop();(wi(e)||ki(e)||Ti(e))&&null==o&&(o=e,i=o.children.map((e=>e.name)).filter((e=>s.has(e)))),s.add(e.name),null==n[e.name]&&(-1===p.indexOf(e.name)&&-1===l.indexOf(e.name)&&(0!==e.inputs.length?e.inputs.forEach((e=>{u.has(e.name)||(u.add(e.name),c.push(e))})):a.push(e.name)))}return{inputs:e,outputs:t,usedNodes:s,missingInputs:a,dynamicNode:o,syncInputs:i}}const bi=["Switch","Merge","Enter","Exit","NextIteration","StatelessIf","StatelessWhile","if","While"],xi=["NonMaxSuppressionV2","NonMaxSuppressionV3","NonMaxSuppressionV5","Where"],Ni=["HashTable","HashTableV2","LookupTableImport","LookupTableImportV2","LookupTableFind","LookupTableFindV2","LookupTableSize","LookupTableSizeV2"];function wi(e){return bi.indexOf(e.op)>=0}function ki(e){return xi.indexOf(e.op)>=0}function Ti(e){return Ni.indexOf(e.op)>=0}class vi{constructor(e,t){this.graph=e,this.parent=t,this.compiledMap=new Map,this._weightMap={},this.SEPERATOR=",",this._functions={},this._functionExecutorMap={},this.intermediateTensors={},this.keepTensorForDebug=!1,this._outputs=e.outputs,this._inputs=e.inputs,this._initNodes=e.initNodes,this._signature=e.signature,this._functions=e.functions,null!=e.functions&&Object.keys(e.functions).forEach((t=>{this._functionExecutorMap[t]=new vi(e.functions[t],this)}))}get weightIds(){return this.parent?this.parent.weightIds:this._weightIds}get functionExecutorMap(){return this.parent?this.parent.functionExecutorMap:this._functionExecutorMap}get weightMap(){return this.parent?this.parent.weightMap:this._weightMap}set weightMap(e){const t=Object.keys(e).map((t=>e[t].map((e=>e.id))));this._weightIds=[].concat(...t),this._weightMap=e}set resourceManager(e){this._resourceManager=e}get inputs(){return this._inputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get outputs(){return this._outputs.map((e=>({name:e.name,shape:e.attrParams.shape?e.attrParams.shape.value:void 0,dtype:e.attrParams.dtype?e.attrParams.dtype.value:void 0})))}get inputNodes(){return this._inputs.map((e=>e.signatureKey||e.name))}get outputNodes(){return this._outputs.map((e=>{const t=e.signatureKey||e.name;return e.defaultOutput?`${t}:${e.defaultOutput}`:t}))}get functions(){return Object.keys(this._functions).reduce(((e,t)=>(e[t]=this._functions[t].signature,e)),{})}getCompilationKey(e,t){const n=e.map((e=>e.name)).sort(),r=t.map((e=>e.name)).sort();return n.join(this.SEPERATOR)+"--"+r.join(this.SEPERATOR)}compile(e,t){const n=gi(e,t,this.weightMap,this._initNodes),{missingInputs:r,dynamicNode:s,syncInputs:a}=n;if(null!=s)throw new Error(`This execution contains the node '${s.name}', which has the dynamic op '${s.op}'. Please use model.executeAsync() instead. Alternatively, to avoid the dynamic ops, specify the inputs [${a}]`);if(r.length>0){const n=t.map((e=>e.name)),s=Object.keys(e);throw new Error(`Cannot compute the outputs [${n}] from the provided inputs [${s}]. Missing the following inputs: [${r}]`)}return function(e,t,n){const{usedNodes:r,inputs:s}=n,a=[],o=Object.keys(s).map((e=>h(e)[0])).map((t=>e.nodes[t])),i=e.initNodes;o.forEach((e=>{r.has(e.name)&&a.push(e)})),e.weights.forEach((e=>{r.has(e.name)&&a.push(e)})),null!=i&&i.forEach((e=>{r.has(e.name)&&a.push(e)}));const u=new Set,p=[];for(;a.length>0;){const e=a.pop();u.add(e.name),t[e.name]||p.push(e),e.children.forEach((e=>{!u.has(e.name)&&r.has(e.name)&&e.inputs.every((e=>u.has(e.name)))&&a.push(e)}))}return p}(this.graph,this.weightMap,n)}execute(e,n){e=this.mapInputs(e);const r=Object.keys(e).sort();this.checkInputs(e),this.checkInputShapeAndType(e),n=this.mapOutputs(n),this.checkOutputs(n);const s=r.map((e=>this.graph.nodes[h(e)[0]])),a=n.map((e=>h(e)[0]));let o=a.map((e=>this.graph.nodes[e]));this.resetIntermediateTensors(),0===o.length&&(o=this._outputs);const i=this.getCompilationKey(s,o);let u=this.compiledMap.get(i);null==u&&(u=this.compile(e,o),this.compiledMap.set(i,u));const l={},c={};return t.tidy((()=>{const r=new yi(this.weightMap,l,c,this.functionExecutorMap),s=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=h(t),a=[];a[r]=e[t],s[n]=a}));const o=this.getFrozenTensorIds(s),i={};for(let e=0;e<u.length;e++){const n=u[e];if(!s[n.name]){const e=fi(n,s,r,this._resourceManager);if(t.util.isPromise(e))throw new Error(`The execution of the op '${n.op}' returned a promise. Please use model.executeAsync() instead.`);s[n.name]=e,this.checkTensorForDisposal(n.name,n,s,r,o,a,i)}}return null==this.parent&&r.dispose(o),n.map((e=>p(e,s,r)))}))}getFrozenTensorIds(e){const t=[].concat.apply([],Object.keys(e).map((t=>e[t])).map((e=>e.map((e=>e.id)))));return new Set(t)}checkTensorForDisposal(e,t,n,r,s,a,o){"control"!==t.category&&-1===a.indexOf(e)&&(n[e].forEach((e=>{null!=e&&(o[e.id]=(o[e.id]||0)+t.children.length)})),t.inputs.forEach((e=>{if("control"!==e.category){const a=function(e,t,n){return t[c(e,n.currentContextId)]}(e.name,n,r);null!=a&&a.forEach((e=>{if(e&&!e.kept&&!s.has(e.id)){const n=o[e.id];if(1===n){if(this.keepTensorForDebug){const[n,s]=l(t.name,r);this.intermediateTensors[n]||(this.intermediateTensors[n]=[]),this.intermediateTensors[n][s]=e}else e.dispose();delete o[e.id]}else null!=n&&o[e.id]--}}))}})))}async executeAsync(e,t){return this._executeAsync(e,t)}disposeIntermediateTensors(){this.intermediateTensors&&(Object.keys(this.intermediateTensors).forEach((e=>this.intermediateTensors[e].forEach((e=>e.dispose())))),this.disposeTensorsMap())}disposeTensorsMap(){this.tensorsMap&&Object.keys(this.tensorsMap).forEach((e=>{this.tensorsMap[e].forEach((e=>{!e||e.kept||e.isDisposed||this.keepIds.has(e.id)||e.dispose()}))}))}getIntermediateTensors(){return this.tensorsMap}resetIntermediateTensors(){for(const e in this.intermediateTensors)this.intermediateTensors[e].forEach((e=>e.dispose())),delete this.intermediateTensors[e]}async _executeAsync(e,n,r=!1,s={},a={}){r||(e=this.mapInputs(e),this.checkInputs(e),this.checkInputShapeAndType(e),n=this.mapOutputs(n),this.checkOutputs(n));try{this.keepTensorForDebug=t.env().getBool("KEEP_INTERMEDIATE_TENSORS")}catch(e){console.warn(e.message)}this.resetIntermediateTensors();const o=new yi(this.weightMap,s,a,this.functionExecutorMap);this.tensorsMap=await this.executeWithControlFlow(e,o,n,r);const i=n.map((e=>p(e,this.tensorsMap,o))),u=i.map((e=>e.id)),l=Object.keys(e).map((t=>e[t].id));return this.keepIds=new Set([...u,...l,...this.weightIds]),this.keepTensorForDebug||this.disposeTensorsMap(),null==this.parent&&o.dispose(this.keepIds),i}async executeFunctionAsync(e,t,n){const r=e.reduce(((e,t,n)=>(e[this.inputs[n].name]=t,e)),{});return this._executeAsync(r,this.outputNodes,!0,t,n)}async executeWithControlFlow(e,t,n,r){const s=Object.keys(e),a=s.map((e=>this.graph.nodes[h(e)[0]])),o=n.map((e=>h(e)[0]));let i=o.map((e=>this.graph.nodes[e]));0===i.length&&(i=this._outputs);const{usedNodes:u,missingInputs:l,dynamicNode:c,syncInputs:d}=gi(e,i,this.weightMap,this._initNodes),m=[...a,...this.graph.weights,...this._initNodes||[]].map((e=>({node:e,contexts:t.currentContext}))),f=Object.assign({},this.weightMap);Object.keys(e).forEach((t=>{const[n,r]=h(t),s=[];s[r]=e[t],f[n]=s}));const y={},g=this.getFrozenTensorIds(f),b={};for(;m.length>0;){const e=this.processStack(a,m,t,f,b,g,o,y,u);await Promise.all(e)}null!=c||r||console.warn("This model execution did not contain any nodes with control flow or dynamic output shapes. You can use model.execute() instead.");const x=i.filter((e=>!wi(e)&&!p(e.name,f,t))).map((e=>e.name));if(x.length>0){let e="";throw null!=c&&(e=`Alternatively, to avoid the dynamic ops, use model.execute() and specify the inputs [${d}]`),new Error(`Cannot compute the outputs [${x}] from the provided inputs [${s}]. Consider providing the following inputs: [${l}]. ${e}`)}return f}processStack(e,n,r,s,a,o,i,p,c){const h=[];for(;n.length>0;){const e=n.pop();r.currentContext=e.contexts;let d="";if("Enter"===e.node.op&&u("isConstant",e.node,s,r)&&([d]=l(e.node.name,r)),null==s[e.node.name]){const u=fi(e.node,s,r,this._resourceManager);d||([d]=l(e.node.name,r));const m=r.currentContext;t.util.isPromise(u)?h.push(u.then((t=>(s[d]=t,r.currentContext=m,this.checkTensorForDisposal(d,e.node,s,r,o,i,p),this.processChildNodes(e.node,n,r,s,a,c),t)))):(s[d]=u,this.checkTensorForDisposal(d,e.node,s,r,o,i,p),this.processChildNodes(e.node,n,r,s,a,c))}else this.processChildNodes(e.node,n,r,s,a,c)}return h}processChildNodes(e,t,n,r,s,a){e.children.forEach((e=>{const[o]=l(e.name,n);!s[o]&&a.has(e.name)&&("Merge"===e.op?e.inputNames.some((e=>!!p(e,r,n)))&&(s[o]=!0,t.push({contexts:n.currentContext,node:e})):e.inputNames.every((e=>!!p(e,r,n)))&&(s[o]=!0,t.push({contexts:n.currentContext,node:e})))}))}dispose(){Object.keys(this.weightMap).forEach((e=>this.weightMap[e].forEach((e=>e.dispose()))))}checkInputShapeAndType(e){Object.keys(e).forEach((n=>{const r=e[n],[s]=h(n),a=this.graph.nodes[s];if(a.attrParams.shape&&a.attrParams.shape.value){const e=a.attrParams.shape.value,n=e.length===r.shape.length&&r.shape.every(((t,n)=>-1===e[n]||e[n]===t));t.util.assert(n,(()=>`The shape of dict['${a.name}'] provided in model.execute(dict) must be [${e}], but was [${r.shape}]`))}a.attrParams.dtype&&a.attrParams.dtype.value&&t.util.assert(r.dtype===a.attrParams.dtype.value,(()=>`The dtype of dict['${a.name}'] provided in model.execute(dict) must be ${a.attrParams.dtype.value}, but was ${r.dtype}`))}))}mapInputs(e){const t={};for(const n in e)if(null!=this._signature&&null!=this._signature.inputs&&null!=this._signature.inputs[n]){t[this._signature.inputs[n].name]=e[n]}else t[n]=e[n];return t}checkInputs(e){const t=Object.keys(e).filter((e=>{const[t]=h(e);return null==this.graph.nodes[t]}));if(t.length>0)throw new Error(`The dict provided in model.execute(dict) has keys: [${t}] that are not part of graph`)}mapOutputs(e){return e.map((e=>{if(null!=this._signature&&null!=this._signature.outputs&&null!=this._signature.outputs[e]){return this._signature.outputs[e].name}return e}),{})}checkOutputs(e){e.forEach((e=>{const[t]=h(e);if(!this.graph.nodes[t])throw new Error(`The output '${e}' is not found in the graph`)}))}}class _i{constructor(e={},t={}){this.hashTableNameToHandle=e,this.hashTableMap=t}addHashTable(e,t){this.hashTableNameToHandle[e]=t.handle,this.hashTableMap[t.id]=t}getHashTableHandleByName(e){return this.hashTableNameToHandle[e]}getHashTableById(e){return this.hashTableMap[e]}dispose(){for(const e in this.hashTableMap)this.hashTableMap[e].clearAndClose(),delete this.hashTableMap[e];for(const e in this.hashTableNameToHandle)this.hashTableNameToHandle[e].dispose(),delete this.hashTableNameToHandle[e]}}class Si{constructor(e,n={},r=t.io){this.modelUrl=e,this.loadOptions=n,this.version="n/a",this.io=r,null==n&&(this.loadOptions={}),this.resourceManager=new _i}get modelVersion(){return this.version}get inputNodes(){return this.executor.inputNodes}get outputNodes(){return this.executor.outputNodes}get inputs(){return this.executor.inputs}get outputs(){return this.executor.outputs}get weights(){return this.executor.weightMap}get metadata(){return this.artifacts.userDefinedMetadata}get modelSignature(){return this.signature}get modelStructuredOutputKeys(){return this.structuredOutputKeys}findIOHandler(){const e=this.modelUrl;if(null!=e.load)this.handler=e;else if(null!=this.loadOptions.requestInit)this.handler=this.io.browserHTTPRequest(e,this.loadOptions);else{const t=this.io.getLoadHandlers(e,this.loadOptions);if(0===t.length)t.push(this.io.browserHTTPRequest(e,this.loadOptions));else if(t.length>1)throw new Error(`Found more than one (${t.length}) load handlers for URL '${[e]}'`);this.handler=t[0]}}load(){if(this.findIOHandler(),null==this.handler.load)throw new Error("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const e=this.handler.load();return t.util.isPromise(e)?e.then((e=>this.loadSync(e))):this.loadSync(e)}loadSync(e){this.artifacts=e;const t=this.artifacts.modelTopology;let n=this.artifacts.signature;if(null!=this.artifacts.userDefinedMetadata){const e=this.artifacts.userDefinedMetadata;null!=e.signature&&(n=e.signature),null!=e.structuredOutputKeys&&(this.structuredOutputKeys=e.structuredOutputKeys)}this.signature=n,this.version=`${t.versions.producer}.${t.versions.minConsumer}`;const r=this.io.decodeWeights(this.artifacts.weightData,this.artifacts.weightSpecs);if(this.executor=new vi(C.Instance.transformGraph(t,this.signature)),this.executor.weightMap=this.convertTensorMapToTensorsMap(r),this.executor.resourceManager=this.resourceManager,null!=e.modelInitializer&&null!=e.modelInitializer.node){const t=C.Instance.transformGraph(e.modelInitializer);this.initializer=new vi(t),this.initializer.weightMap=this.executor.weightMap,this.initializer.resourceManager=this.resourceManager,this.initializer.executeAsync({},[])}return!0}async save(e,t){if("string"==typeof e){const t=this.io.getSaveHandlers(e);if(0===t.length)throw new Error(`Cannot find any save handlers for URL '${e}'`);if(t.length>1)throw new Error(`Found more than one (${t.length}) save handlers for URL '${e}'`);e=t[0]}if(null==e.save)throw new Error("GraphModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");return e.save(this.artifacts)}predict(e,n){const r=this.execute(e,this.outputNodes);if(this.structuredOutputKeys){const e=r instanceof t.Tensor?[r]:r,n={};return e.forEach(((e,t)=>n[this.structuredOutputKeys[t]]=e)),n}return r}normalizeInputs(e){if(!(e instanceof t.Tensor||Array.isArray(e)))return e;if((e=Array.isArray(e)?e:[e]).length!==this.inputNodes.length)throw new Error(`Input tensor count mismatch,the graph model has ${this.inputNodes.length} placeholders, while there are ${e.length} input tensors.`);return this.inputNodes.reduce(((t,n,r)=>(t[n]=e[r],t)),{})}normalizeOutputs(e){return e=e||this.outputNodes,Array.isArray(e)?e:[e]}execute(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=this.executor.execute(e,t);return n.length>1?n:n[0]}async executeAsync(e,t){e=this.normalizeInputs(e),t=this.normalizeOutputs(t);const n=await this.executor.executeAsync(e,t);return n.length>1?n:n[0]}getIntermediateTensors(){return this.executor.getIntermediateTensors()}disposeIntermediateTensors(){this.executor.disposeIntermediateTensors()}convertTensorMapToTensorsMap(e){return Object.keys(e).reduce(((t,n)=>(t[n]=[e[n]],t)),{})}dispose(){this.executor.dispose(),this.initializer&&this.initializer.dispose(),this.resourceManager.dispose()}}e.GraphModel=Si,e.deregisterOp=function(e){delete o[e]},e.loadGraphModel=async function(e,n={},r=t.io){if(null==e)throw new Error("modelUrl in loadGraphModel() cannot be null. Please provide a url or an IOHandler that loads the model");null==n&&(n={}),n.fromTFHub&&"string"==typeof e&&(e=function(e){e.endsWith("/")||(e+="/");return`${e}model.json?tfjs-format=file`}(e));const s=new Si(e,n,r);return await s.load(),s},e.loadGraphModelSync=function(e){if(null==e)throw new Error("modelUrl in loadGraphModelSync() cannot be null. Please provide a url or an IOHandler that loads the model");if(!e.load)throw new Error(`modelUrl IO Handler ${e} has no load function`);const t=new Si(e);return t.load(),t},e.registerOp=function(e,t){const n={tfOpName:e,category:"custom",inputs:[],attrs:[],customExecutor:t};o[e]=n},e.version_converter="3.19.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-converter.es2017.min.js.map
