/**
 * @license
 * Copyright 2019 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * =============================================================================
 */
/** DataType enum. */
export var DataType;
(function (DataType) {
    // Not a legal value for DataType.  Used to indicate a DataType field
    // has not been set.
    DataType[DataType["DT_INVALID"] = 0] = "DT_INVALID";
    // Data types that all computation devices are expected to be
    // capable to support.
    DataType[DataType["DT_FLOAT"] = 1] = "DT_FLOAT";
    DataType[DataType["DT_DOUBLE"] = 2] = "DT_DOUBLE";
    DataType[DataType["DT_INT32"] = 3] = "DT_INT32";
    DataType[DataType["DT_UINT8"] = 4] = "DT_UINT8";
    DataType[DataType["DT_INT16"] = 5] = "DT_INT16";
    DataType[DataType["DT_INT8"] = 6] = "DT_INT8";
    DataType[DataType["DT_STRING"] = 7] = "DT_STRING";
    DataType[DataType["DT_COMPLEX64"] = 8] = "DT_COMPLEX64";
    DataType[DataType["DT_INT64"] = 9] = "DT_INT64";
    DataType[DataType["DT_BOOL"] = 10] = "DT_BOOL";
    DataType[DataType["DT_QINT8"] = 11] = "DT_QINT8";
    DataType[DataType["DT_QUINT8"] = 12] = "DT_QUINT8";
    DataType[DataType["DT_QINT32"] = 13] = "DT_QINT32";
    DataType[DataType["DT_BFLOAT16"] = 14] = "DT_BFLOAT16";
    DataType[DataType["DT_QINT16"] = 15] = "DT_QINT16";
    DataType[DataType["DT_QUINT16"] = 16] = "DT_QUINT16";
    DataType[DataType["DT_UINT16"] = 17] = "DT_UINT16";
    DataType[DataType["DT_COMPLEX128"] = 18] = "DT_COMPLEX128";
    DataType[DataType["DT_HALF"] = 19] = "DT_HALF";
    DataType[DataType["DT_RESOURCE"] = 20] = "DT_RESOURCE";
    DataType[DataType["DT_VARIANT"] = 21] = "DT_VARIANT";
    DataType[DataType["DT_UINT32"] = 22] = "DT_UINT32";
    DataType[DataType["DT_UINT64"] = 23] = "DT_UINT64";
    // Do not use!  These are only for parameters.  Every enum above
    // should have a corresponding value below (verified by types_test).
    DataType[DataType["DT_FLOAT_REF"] = 101] = "DT_FLOAT_REF";
    DataType[DataType["DT_DOUBLE_REF"] = 102] = "DT_DOUBLE_REF";
    DataType[DataType["DT_INT32_REF"] = 103] = "DT_INT32_REF";
    DataType[DataType["DT_UINT8_REF"] = 104] = "DT_UINT8_REF";
    DataType[DataType["DT_INT16_REF"] = 105] = "DT_INT16_REF";
    DataType[DataType["DT_INT8_REF"] = 106] = "DT_INT8_REF";
    DataType[DataType["DT_STRING_REF"] = 107] = "DT_STRING_REF";
    DataType[DataType["DT_COMPLEX64_REF"] = 108] = "DT_COMPLEX64_REF";
    DataType[DataType["DT_INT64_REF"] = 109] = "DT_INT64_REF";
    DataType[DataType["DT_BOOL_REF"] = 110] = "DT_BOOL_REF";
    DataType[DataType["DT_QINT8_REF"] = 111] = "DT_QINT8_REF";
    DataType[DataType["DT_QUINT8_REF"] = 112] = "DT_QUINT8_REF";
    DataType[DataType["DT_QINT32_REF"] = 113] = "DT_QINT32_REF";
    DataType[DataType["DT_BFLOAT16_REF"] = 114] = "DT_BFLOAT16_REF";
    DataType[DataType["DT_QINT16_REF"] = 115] = "DT_QINT16_REF";
    DataType[DataType["DT_QUINT16_REF"] = 116] = "DT_QUINT16_REF";
    DataType[DataType["DT_UINT16_REF"] = 117] = "DT_UINT16_REF";
    DataType[DataType["DT_COMPLEX128_REF"] = 118] = "DT_COMPLEX128_REF";
    DataType[DataType["DT_HALF_REF"] = 119] = "DT_HALF_REF";
    DataType[DataType["DT_RESOURCE_REF"] = 120] = "DT_RESOURCE_REF";
    DataType[DataType["DT_VARIANT_REF"] = 121] = "DT_VARIANT_REF";
    DataType[DataType["DT_UINT32_REF"] = 122] = "DT_UINT32_REF";
    DataType[DataType["DT_UINT64_REF"] = 123] = "DT_UINT64_REF";
})(DataType || (DataType = {}));
export var SaverDef;
(function (SaverDef) {
    /** CheckpointFormatVersion enum. */
    let CheckpointFormatVersion;
    (function (CheckpointFormatVersion) {
        CheckpointFormatVersion[CheckpointFormatVersion["LEGACY"] = 0] = "LEGACY";
        CheckpointFormatVersion[CheckpointFormatVersion["V1"] = 1] = "V1";
        CheckpointFormatVersion[CheckpointFormatVersion["V2"] = 2] = "V2";
    })(CheckpointFormatVersion = SaverDef.CheckpointFormatVersion || (SaverDef.CheckpointFormatVersion = {}));
})(SaverDef || (SaverDef = {}));
//# sourceMappingURL=data:application/json;base64,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