/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
// Import shared functionality from tfjs-backend-cpu without triggering
// side effects.
// tslint:disable-next-line: no-imports-from-dist
import * as shared from '@tensorflow/tfjs-backend-cpu/dist/shared';
const { addImpl: addImplCPU, bincountImpl: bincountImplCPU, bincountReduceImpl: bincountReduceImplCPU, ceilImpl: ceilImplCPU, concatImpl: concatImplCPU, equalImpl: equalImplCPU, expImpl: expImplCPU, expm1Impl: expm1ImplCPU, floorImpl: floorImplCPU, gatherNdImpl: gatherNdImplCPU, gatherV2Impl: gatherV2ImplCPU, greaterImpl: greaterImplCPU, greaterEqualImpl: greaterEqualImplCPU, lessImpl: lessImplCPU, lessEqualImpl: lessEqualImplCPU, linSpaceImpl: linSpaceImplCPU, logImpl: logImplCPU, maxImpl: maxImplCPU, maximumImpl: maximumImplCPU, minimumImpl: minimumImplCPU, multiplyImpl: multiplyImplCPU, negImpl: negImplCPU, notEqualImpl: notEqualImplCPU, prodImpl: prodImplCPU, rangeImpl: rangeImplCPU, rsqrtImpl: rsqrtImplCPU, scatterImpl: scatterImplCPU, sigmoidImpl: sigmoidImplCPU, simpleAbsImpl: simpleAbsImplCPU, sliceImpl: sliceImplCPU, sparseFillEmptyRowsImpl: sparseFillEmptyRowsImplCPU, sparseReshapeImpl: sparseReshapeImplCPU, sparseSegmentReductionImpl: sparseSegmentReductionImplCPU, sqrtImpl: sqrtImplCPU, stridedSliceImpl: stridedSliceImplCPU, stringNGramsImpl: stringNGramsImplCPU, stringSplitImpl: stringSplitImplCPU, stringToHashBucketFastImpl: stringToHashBucketFastImplCPU, subImpl: subImplCPU, tileImpl: tileImplCPU, topKImpl: topKImplCPU, transposeImpl: transposeImplCPU, uniqueImpl: uniqueImplCPU, } = shared;
export { addImplCPU, bincountImplCPU, bincountReduceImplCPU, ceilImplCPU, concatImplCPU, equalImplCPU, expImplCPU, expm1ImplCPU, floorImplCPU, gatherNdImplCPU, gatherV2ImplCPU, greaterEqualImplCPU, greaterImplCPU, lessEqualImplCPU, lessImplCPU, linSpaceImplCPU, logImplCPU, maxImplCPU, maximumImplCPU, minimumImplCPU, multiplyImplCPU, negImplCPU, notEqualImplCPU, prodImplCPU, scatterImplCPU, sigmoidImplCPU, simpleAbsImplCPU, sliceImplCPU, sparseFillEmptyRowsImplCPU, sparseReshapeImplCPU, sparseSegmentReductionImplCPU, sqrtImplCPU, stridedSliceImplCPU, stringNGramsImplCPU, stringSplitImplCPU, stringToHashBucketFastImplCPU, subImplCPU, rangeImplCPU, rsqrtImplCPU, tileImplCPU, topKImplCPU, transposeImplCPU, uniqueImplCPU, };
//# sourceMappingURL=data:application/json;base64,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