import { getCoordsDataType } from './shader_compiler';
export class GatherNDProgram {
    constructor(sliceDim, strides, shape, paramsShape) {
        this.sliceDim = sliceDim;
        this.strides = strides;
        this.paramsShape = paramsShape;
        this.variableNames = ['x', 'indices'];
        this.outputShape = shape;
        const stridesType = getCoordsDataType(strides.length);
        const dtype = getCoordsDataType(shape.length);
        const strideString = this.sliceDim > 1 ? 'strides[j]' : 'strides';
        const paramsShapeType = getCoordsDataType(paramsShape.length);
        const paramsShapeString = paramsShape.length > 1 ? 'paramsShape[j]' : 'paramsShape';
        this.userCode = `
        ${stridesType} strides = ${stridesType}(${this.strides});
        ${paramsShapeType} paramsShape = ${paramsShapeType}(${this.paramsShape});
         void main() {
          ${dtype} coords = getOutputCoords();
          int flattenIndex = 0;
          bool out_of_bounds = false;
          for (int j = 0; j < ${this.sliceDim}; j++) {
            int index = round(getIndices(coords[0], j));
            out_of_bounds = out_of_bounds || index < 0;
            out_of_bounds = out_of_bounds || index >= ${paramsShapeString};
            flattenIndex += index * ${strideString};
          }
          setOutput(out_of_bounds ? 0.0 : getX(flattenIndex, coords[1]));
        }
      `;
    }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2F0aGVyX25kX2dwdS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3RmanMtYmFja2VuZC13ZWJnbC9zcmMvZ2F0aGVyX25kX2dwdS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFpQkEsT0FBTyxFQUFDLGlCQUFpQixFQUFDLE1BQU0sbUJBQW1CLENBQUM7QUFFcEQsTUFBTSxPQUFPLGVBQWU7SUFJMUIsWUFDWSxRQUFnQixFQUFVLE9BQWlCLEVBQUUsS0FBZSxFQUM1RCxXQUFxQjtRQURyQixhQUFRLEdBQVIsUUFBUSxDQUFRO1FBQVUsWUFBTyxHQUFQLE9BQU8sQ0FBVTtRQUMzQyxnQkFBVyxHQUFYLFdBQVcsQ0FBVTtRQUxqQyxrQkFBYSxHQUFHLENBQUMsR0FBRyxFQUFFLFNBQVMsQ0FBQyxDQUFDO1FBTS9CLElBQUksQ0FBQyxXQUFXLEdBQUcsS0FBSyxDQUFDO1FBQ3pCLE1BQU0sV0FBVyxHQUFHLGlCQUFpQixDQUFDLE9BQU8sQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN0RCxNQUFNLEtBQUssR0FBRyxpQkFBaUIsQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUM7UUFDOUMsTUFBTSxZQUFZLEdBQUcsSUFBSSxDQUFDLFFBQVEsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxDQUFDLENBQUMsU0FBUyxDQUFDO1FBQ2xFLE1BQU0sZUFBZSxHQUFHLGlCQUFpQixDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUM5RCxNQUFNLGlCQUFpQixHQUFHLFdBQVcsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsYUFBYSxDQUFDO1FBQ3BGLElBQUksQ0FBQyxRQUFRLEdBQUc7VUFDVixXQUFXLGNBQWMsV0FBVyxJQUFJLElBQUksQ0FBQyxPQUFPO1VBQ3BELGVBQWUsa0JBQWtCLGVBQWUsSUFBSSxJQUFJLENBQUMsV0FBVzs7WUFFbEUsS0FBSzs7O2dDQUdlLElBQUksQ0FBQyxRQUFROzs7d0RBR1csaUJBQWlCO3NDQUNuQyxZQUFZOzs7O09BSTNDLENBQUM7SUFDTixDQUFDO0NBQ0YiLCJzb3VyY2VzQ29udGVudCI6WyIvKipcbiAqIEBsaWNlbnNlXG4gKiBDb3B5cmlnaHQgMjAxOCBHb29nbGUgTExDLiBBbGwgUmlnaHRzIFJlc2VydmVkLlxuICogTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKTtcbiAqIHlvdSBtYXkgbm90IHVzZSB0aGlzIGZpbGUgZXhjZXB0IGluIGNvbXBsaWFuY2Ugd2l0aCB0aGUgTGljZW5zZS5cbiAqIFlvdSBtYXkgb2J0YWluIGEgY29weSBvZiB0aGUgTGljZW5zZSBhdFxuICpcbiAqIGh0dHA6Ly93d3cuYXBhY2hlLm9yZy9saWNlbnNlcy9MSUNFTlNFLTIuMFxuICpcbiAqIFVubGVzcyByZXF1aXJlZCBieSBhcHBsaWNhYmxlIGxhdyBvciBhZ3JlZWQgdG8gaW4gd3JpdGluZywgc29mdHdhcmVcbiAqIGRpc3RyaWJ1dGVkIHVuZGVyIHRoZSBMaWNlbnNlIGlzIGRpc3RyaWJ1dGVkIG9uIGFuIFwiQVMgSVNcIiBCQVNJUyxcbiAqIFdJVEhPVVQgV0FSUkFOVElFUyBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBlaXRoZXIgZXhwcmVzcyBvciBpbXBsaWVkLlxuICogU2VlIHRoZSBMaWNlbnNlIGZvciB0aGUgc3BlY2lmaWMgbGFuZ3VhZ2UgZ292ZXJuaW5nIHBlcm1pc3Npb25zIGFuZFxuICogbGltaXRhdGlvbnMgdW5kZXIgdGhlIExpY2Vuc2UuXG4gKiA9PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PT09PVxuICovXG5pbXBvcnQge0dQR1BVUHJvZ3JhbX0gZnJvbSAnLi9ncGdwdV9tYXRoJztcbmltcG9ydCB7Z2V0Q29vcmRzRGF0YVR5cGV9IGZyb20gJy4vc2hhZGVyX2NvbXBpbGVyJztcblxuZXhwb3J0IGNsYXNzIEdhdGhlck5EUHJvZ3JhbSBpbXBsZW1lbnRzIEdQR1BVUHJvZ3JhbSB7XG4gIHZhcmlhYmxlTmFtZXMgPSBbJ3gnLCAnaW5kaWNlcyddO1xuICBvdXRwdXRTaGFwZTogbnVtYmVyW107XG4gIHVzZXJDb2RlOiBzdHJpbmc7XG4gIGNvbnN0cnVjdG9yKFxuICAgICAgcHJpdmF0ZSBzbGljZURpbTogbnVtYmVyLCBwcml2YXRlIHN0cmlkZXM6IG51bWJlcltdLCBzaGFwZTogbnVtYmVyW10sXG4gICAgICBwcml2YXRlIHBhcmFtc1NoYXBlOiBudW1iZXJbXSkge1xuICAgIHRoaXMub3V0cHV0U2hhcGUgPSBzaGFwZTtcbiAgICBjb25zdCBzdHJpZGVzVHlwZSA9IGdldENvb3Jkc0RhdGFUeXBlKHN0cmlkZXMubGVuZ3RoKTtcbiAgICBjb25zdCBkdHlwZSA9IGdldENvb3Jkc0RhdGFUeXBlKHNoYXBlLmxlbmd0aCk7XG4gICAgY29uc3Qgc3RyaWRlU3RyaW5nID0gdGhpcy5zbGljZURpbSA+IDEgPyAnc3RyaWRlc1tqXScgOiAnc3RyaWRlcyc7XG4gICAgY29uc3QgcGFyYW1zU2hhcGVUeXBlID0gZ2V0Q29vcmRzRGF0YVR5cGUocGFyYW1zU2hhcGUubGVuZ3RoKTtcbiAgICBjb25zdCBwYXJhbXNTaGFwZVN0cmluZyA9IHBhcmFtc1NoYXBlLmxlbmd0aCA+IDEgPyAncGFyYW1zU2hhcGVbal0nIDogJ3BhcmFtc1NoYXBlJztcbiAgICB0aGlzLnVzZXJDb2RlID0gYFxuICAgICAgICAke3N0cmlkZXNUeXBlfSBzdHJpZGVzID0gJHtzdHJpZGVzVHlwZX0oJHt0aGlzLnN0cmlkZXN9KTtcbiAgICAgICAgJHtwYXJhbXNTaGFwZVR5cGV9IHBhcmFtc1NoYXBlID0gJHtwYXJhbXNTaGFwZVR5cGV9KCR7dGhpcy5wYXJhbXNTaGFwZX0pO1xuICAgICAgICAgdm9pZCBtYWluKCkge1xuICAgICAgICAgICR7ZHR5cGV9IGNvb3JkcyA9IGdldE91dHB1dENvb3JkcygpO1xuICAgICAgICAgIGludCBmbGF0dGVuSW5kZXggPSAwO1xuICAgICAgICAgIGJvb2wgb3V0X29mX2JvdW5kcyA9IGZhbHNlO1xuICAgICAgICAgIGZvciAoaW50IGogPSAwOyBqIDwgJHt0aGlzLnNsaWNlRGltfTsgaisrKSB7XG4gICAgICAgICAgICBpbnQgaW5kZXggPSByb3VuZChnZXRJbmRpY2VzKGNvb3Jkc1swXSwgaikpO1xuICAgICAgICAgICAgb3V0X29mX2JvdW5kcyA9IG91dF9vZl9ib3VuZHMgfHwgaW5kZXggPCAwO1xuICAgICAgICAgICAgb3V0X29mX2JvdW5kcyA9IG91dF9vZl9ib3VuZHMgfHwgaW5kZXggPj0gJHtwYXJhbXNTaGFwZVN0cmluZ307XG4gICAgICAgICAgICBmbGF0dGVuSW5kZXggKz0gaW5kZXggKiAke3N0cmlkZVN0cmluZ307XG4gICAgICAgICAgfVxuICAgICAgICAgIHNldE91dHB1dChvdXRfb2ZfYm91bmRzID8gMC4wIDogZ2V0WChmbGF0dGVuSW5kZXgsIGNvb3Jkc1sxXSkpO1xuICAgICAgICB9XG4gICAgICBgO1xuICB9XG59XG4iXX0=