/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import{util as e,kernel_impls as t,KernelBackend as n,DataStorage as a,engine as s,env as r,backend_util as o,buffer as i,Abs as d,Complex as c,Identity as l,Real as p,Cast as u,Add as h,Ceil as f,Equal as m,Exp as k,Expm1 as g,Floor as I,Greater as b,GreaterEqual as y,Less as N,LessEqual as x,Log as T,Maximum as S,Minimum as v,Multiply as F,Neg as M,NotEqual as A,Transpose as w,upcastType as D,Prod as E,Rsqrt as z,Sigmoid as W,slice_util as H,Slice as C,Sqrt as P,SquaredDifference as R,Sub as $,TensorBuffer as O,registerBackend as V,Elu as G,LeakyRelu as B,Prelu as q,Relu as L,Relu6 as _,Reshape as U,BatchMatMul as Z,broadcast_util as K,_FusedMatMul as j,Acos as Y,Acosh as J,AddN as Q,All as X,Any as ee,ArgMax as te,ArgMin as ne,Asin as ae,Asinh as se,Atan as re,Atan2 as oe,Atanh as ie,AvgPool as de,AvgPool3D as ce,AvgPool3DGrad as le,AvgPoolGrad as pe,FusedBatchNorm as ue,BatchToSpaceND as he,Bincount as fe,BroadcastArgs as me,ClipByValue as ke,ComplexAbs as ge,Imag as Ie,Concat as be,Conv2D as ye,Conv2DBackpropFilter as Ne,Conv2DBackpropInput as xe,Conv3D as Te,Conv3DBackpropFilterV2 as Se,Conv3DBackpropInputV2 as ve,Cos as Fe,Cosh as Me,CropAndResize as Ae,Cumprod as we,Cumsum as De,DenseBincount as Ee,DepthToSpace as ze,DepthwiseConv2dNative as We,DepthwiseConv2dNativeBackpropFilter as He,DepthwiseConv2dNativeBackpropInput as Ce,Diag as Pe,Dilation2D as Re,Dilation2DBackpropFilter as $e,Dilation2DBackpropInput as Oe,Sum as Ve,Einsum as Ge,EluGrad as Be,Erf as qe,ExpandDims as Le,RealDiv as _e,FFT as Ue,Fill as Ze,FlipLeftRight as Ke,FloorDiv as je,FusedConv2D as Ye,FusedDepthwiseConv2D as Je,GatherNd as Qe,GatherV2 as Xe,IFFT as et,IsFinite as tt,IsInf as nt,IsNan as at,LinSpace as st,Log1p as rt,LogicalAnd as ot,LogicalNot as it,LogicalOr as dt,LRN as ct,LRNGrad as lt,Max as pt,MaxPool as ut,MaxPool3D as ht,MaxPool3DGrad as ft,MaxPoolGrad as mt,MaxPoolWithArgmax as kt,Mean as gt,Min as It,MirrorPad as bt,Mod as yt,Softmax as Nt,Multinomial as xt,NonMaxSuppressionV3 as Tt,NonMaxSuppressionV4 as St,NonMaxSuppressionV5 as vt,OneHot as Ft,ZerosLike as Mt,OnesLike as At,Pack as wt,PadV2 as Dt,Pow as Et,Range as zt,Reciprocal as Wt,ResizeBilinear as Ht,ResizeBilinearGrad as Ct,ResizeNearestNeighbor as Pt,ResizeNearestNeighborGrad as Rt,Reverse as $t,RotateWithOffset as Ot,Round as Vt,ScatterNd as Gt,SearchSorted as Bt,Select as qt,Selu as Lt,Sign as _t,Sin as Ut,Sinh as Zt,Softplus as Kt,SpaceToBatchND as jt,SparseFillEmptyRows as Yt,SparseReshape as Jt,SparseSegmentMean as Qt,SparseSegmentSum as Xt,SparseToDense as en,SplitV as tn,Square as nn,Step as an,StridedSlice as sn,StringNGrams as rn,StringSplit as on,StringToHashBucketFast as dn,Tan as cn,Tanh as ln,Tile as pn,TopK as un,Transform as hn,Unique as fn,Unpack as mn,UnsortedSegmentSum as kn,registerKernel as gn}from"@tensorflow/tfjs-core";import*as In from"seedrandom";function bn(t,n){Array.isArray(t)||(t=[t]),t.forEach((t=>{null!=t&&e.assert("complex64"!==t.dtype,(()=>`${n} does not support complex64 tensors in the CPU backend.`))}))}const yn=t.whereImpl;class Nn extends n{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new a(this,s())}nextDataId(){return Nn.nextDataId++}write(e,t,n){this.firstUse&&(this.firstUse=!1,r().get("IS_NODE")&&o.warn("\n============================\nHi, looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, visit https://github.com/tensorflow/tfjs-node for more details. \n============================"));const a={id:this.nextDataId()};return this.data.set(a,{values:e,dtype:n,refCount:1}),a}makeTensorInfo(t,n,a){let s;if("string"===n&&null!=a&&a.length>0&&e.isString(a[0])){const r=a.map((t=>e.encodeString(t)));s=this.write(r,t,n)}else s=this.write(a,t,n);return{dataId:s,shape:t,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:t,complexTensorInfos:n}=this.data.get(e);if("complex64"===t){const e=this.readSync(n.real.dataId),t=this.readSync(n.imag.dataId);return o.mergeRealAndImagArrays(e,t)}return this.data.get(e).values}bufferSync(t){const n=this.readSync(t.dataId);if("string"===t.dtype)try{const a=n.map((t=>e.decodeString(t)));return i(t.shape,t.dtype,a)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return i(t.shape,t.dtype,n)}makeOutput(e,t,n){return s().makeTensorFromTensorInfo(this.makeTensorInfo(t,n,e),this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(t){const n=e.now();t();return{kernelMs:e.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){bn([e],"where");const t=this.readSync(e.dataId);return yn(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function xn(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}Nn.nextDataId=0;const Tn={kernelName:d,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend;bn(n,"abs");let s=new Float32Array(e.sizeFromShape(n.shape));return s=xn(a.data.get(n.dataId).values),a.makeOutput(s,n.shape,n.dtype)}};function Sn(t){return(n,a,s,r,i)=>{const d=o.assertAndGetBroadcastShape(n,a),c=d.length,l=e.computeStrides(d),p=e.sizeFromShape(d),u=e.getTypedArrayFromDType(i,p),h=n.length,f=a.length,m=e.computeStrides(n),k=e.computeStrides(a),g=o.getBroadcastDims(n,d),I=o.getBroadcastDims(a,d);if(g.length+I.length===0)for(let e=0;e<u.length;++e)u[e]=t(s[e%s.length],r[e%r.length]);else for(let n=0;n<u.length;++n){const a=e.indexToLoc(n,c,l),o=a.slice(-h);g.forEach((e=>o[e]=0));const i=e.locToIndex(o,h,m),d=a.slice(-f);I.forEach((e=>d[e]=0));const p=e.locToIndex(d,f,k);u[n]=t(s[i],r[p])}return[u,d]}}function vn(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,r=n.data.get(a.dataId).values,o=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",r),imag:n.makeTensorInfo(s.shape,"float32",o)},i}const Fn={kernelName:c,backendName:"cpu",kernelFunc:vn};function Mn(t,n,a="float32"){if("complex64"===a){return vn({inputs:{real:Mn(t,n,"float32"),imag:Mn(t,n,"float32")},backend:t})}const s=e.makeZerosTypedArray(e.sizeFromShape(n),a);return t.makeTensorInfo(n,a,s)}function An(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const wn={kernelName:l,backendName:"cpu",kernelFunc:An};function Dn(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const En={kernelName:p,backendName:"cpu",kernelFunc:Dn};function zn(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{dtype:o}=s;if("complex64"===o){if("complex64"===r.dtype)return An({inputs:{x:r},backend:a});const e=Mn(a,r.shape,r.dtype),t=zn({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),n=vn({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===r.dtype){const e=Dn({inputs:{input:r},backend:a}),t=zn({inputs:{x:e},backend:a,attrs:{dtype:o}});return a.disposeIntermediateTensorInfo(e),t}if(!e.hasEncodingLoss(r.dtype,o)){const e=An({inputs:{x:r},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:o}}if("int32"===o){const e=a.data.get(r.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(r.shape,"int32",t)}if("bool"===o){const t=a.data.get(r.dataId).values,n=e.toTypedArray([0],r.dtype),[s,o]=Sn(((e,t)=>e!==t?1:0))(r.shape,[],t,n,"bool");return a.makeTensorInfo(o,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${o}`)}const Wn={kernelName:u,backendName:"cpu",kernelFunc:zn};function Hn(e,t,n,a){return null==n?({inputs:n,backend:s})=>{const{a:r,b:i}=n,d=s;bn([r,i],e);const c=d.data.get(r.dataId).values,l=d.data.get(i.dataId).values,p="string"===r.dtype?o.fromUint8ToStringArray(c):c,u="string"===r.dtype?o.fromUint8ToStringArray(l):l,h=a||r.dtype,[f,m]=t(r.shape,i.shape,p,u,h);return d.makeTensorInfo(m,h,f)}:({inputs:e,backend:s})=>{const{a:r,b:o}=e,i=s;if("complex64"===r.dtype||"complex64"===o.dtype){const e=zn({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),a=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,d=i.data.get(a.dataId).values,c=i.data.get(s.dataId).values,l=zn({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(l.dataId),u=p.complexTensorInfos.real,h=p.complexTensorInfos.imag,f=i.data.get(u.dataId).values,m=i.data.get(h.dataId).values,[k,g,I]=n(r.shape,o.shape,d,c,f,m),b=i.makeTensorInfo(I,"float32",k),y=i.makeTensorInfo(I,"float32",g),N=vn({inputs:{real:b,imag:y},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(l),i.disposeIntermediateTensorInfo(b),i.disposeIntermediateTensorInfo(y),N}{const e=i.data.get(r.dataId).values,n=i.data.get(o.dataId).values,s=a||r.dtype,[d,c]=t(r.shape,o.shape,e,n,s);return i.makeTensorInfo(c,s,d)}}}function Cn(t){return(n,a,s,r,i,d)=>{const c=o.assertAndGetBroadcastShape(n,a),l=e.sizeFromShape(c),p=c.length,u=e.computeStrides(c),h=e.getTypedArrayFromDType("float32",l),f=e.getTypedArrayFromDType("float32",l),m=o.getBroadcastDims(n,c),k=o.getBroadcastDims(a,c),g=o.mergeRealAndImagArrays(s,r),I=o.mergeRealAndImagArrays(i,d),b=n.length,y=e.computeStrides(n),N=a.length,x=e.computeStrides(a);if(m.length+k.length===0)for(let e=0;e<h.length;e++){const n=e%g.length,a=e%I.length,s=t(g[2*n],g[2*n+1],I[2*a],I[2*a+1]);h[e]=s.real,f[e]=s.imag}else for(let n=0;n<h.length;n++){const a=e.indexToLoc(n,p,u),s=a.slice(-b);m.forEach((e=>s[e]=0));const r=e.locToIndex(s,b,y),o=a.slice(-N);k.forEach((e=>o[e]=0));const i=e.locToIndex(o,N,x),d=t(g[2*r],g[2*r+1],I[2*i],I[2*i+1]);h[n]=d.real,f[n]=d.imag}return[h,f,c]}}const Pn=Sn(((e,t)=>e+t)),Rn=Hn(h,Pn,Cn(((e,t,n,a)=>({real:e+n,imag:t+a})))),$n={kernelName:h,backendName:"cpu",kernelFunc:Rn};function On(t,n,a,s,r){const o=e.sizeFromShape(s),i=e.makeZerosTypedArray(r,a);for(let e=0;e<t.length;e++){const a=t[e];if(a<0)throw new Error("Input x must be non-negative!");a>=r||(i[a]+=o>0?n[e]:1)}return i}function Vn(e,t,n,a=!1){const s=e.shape[0],r=e.shape[1],o=i([s,n],t.dtype);for(let i=0;i<s;i++)for(let s=0;s<r;s++){const r=e.get(i,s);if(r<0)throw new Error("Input x must be non-negative!");r>=n||(a?o.set(1,i,r):t.size>0?o.set(o.get(i,r)+t.get(i,s),i,r):o.set(o.get(i,r)+1,i,r))}return o}function Gn(t){return(n,a,s)=>{const r=e.getTypedArrayFromDType(a,n.length);for(let e=0;e<n.length;++e)r[e]=t(n[e],s);return r}}function Bn(t,n,a){return({inputs:s,attrs:r,backend:o})=>{const{x:i}=s;if(bn(i,t),"string"===i.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");const d=o,c=d.data.get(i.dataId).values,l=e.sizeFromShape(i.shape),p=a||i.dtype,u=e.getArrayFromDType(p,l);for(let e=0;e<l;++e)u[e]=n(c[e],r);return d.makeTensorInfo(i.shape,p,u)}}function qn(e,t,n){return({inputs:a,attrs:s,backend:r})=>{const{x:o}=a;if(bn(o,e),"string"===o.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const i=r,d=i.data.get(o.dataId).values,c=n||o.dtype,l=t(d,c,s);return i.makeTensorInfo(o.shape,c,l)}}const Ln=Gn((e=>Math.ceil(e))),_n={kernelName:f,backendName:"cpu",kernelFunc:qn(f,Ln)};function Un(t,n,a,s){const r=e.getArrayFromDType(a,e.sizeFromShape(n));if(s&&"string"!==a){let n=0;t.forEach((t=>{const a=e.sizeFromShape(t.shape);r.set(t.vals,n),n+=a}))}else{let e=0;t.forEach((t=>{const s="string"===a?o.fromUint8ToStringArray(t.vals):t.vals;let i=0;for(let a=0;a<t.shape[0];++a){const o=a*n[1]+e;for(let e=0;e<t.shape[1];++e)r[o+e]=s[i++]}e+=t.shape[1]}))}return r}const Zn=Sn(((e,t)=>e===t?1:0)),Kn=Hn(m,Zn,null,"bool"),jn={kernelName:m,backendName:"cpu",kernelFunc:Kn},Yn=Gn((e=>Math.exp(e))),Jn=qn(k,Yn,"float32"),Qn={kernelName:k,backendName:"cpu",kernelFunc:Jn},Xn=Gn((e=>Math.expm1(e))),ea={kernelName:g,backendName:"cpu",kernelFunc:qn(g,Xn)},ta=Gn((e=>Math.floor(e))),na={kernelName:I,backendName:"cpu",kernelFunc:qn(I,ta)};function aa(e,t,n,a,s,r,o,d,c){const l=i([a,r],n);for(let n=0;n<a;n++){const a=[];let i=0;for(let t=0;t<s;t++){const r=e[n*s+t];i+=r*o[t],a.push(r)}if(i<0||i>=c/r)throw new Error(`Invalid indices: ${a} does not index into ${d}`);for(let e=0;e<r;e++)l.values[n*r+e]=t.get(...t.indexToLoc(i*r+e))}return l}function sa(e,t,n){const a=i(n,e.dtype);for(let n=0;n<a.size;++n){const s=a.indexToLoc(n).slice(),r=s[0],o=s[2],i=t.locToIndex([r,o]);s[2]=t.values[i];const d=e.locToIndex(s);0<=d&&d<e.values.length&&(a.values[n]=e.values[d])}return a}const ra=Sn(((e,t)=>e>t?1:0)),oa={kernelName:b,backendName:"cpu",kernelFunc:Hn(b,ra,null,"bool")},ia=Sn(((e,t)=>e>=t?1:0)),da={kernelName:y,backendName:"cpu",kernelFunc:Hn(y,ia,null,"bool")},ca=Sn(((e,t)=>e<t?1:0)),la={kernelName:N,backendName:"cpu",kernelFunc:Hn(N,ca,null,"bool")},pa=Sn(((e,t)=>e<=t?1:0)),ua={kernelName:x,backendName:"cpu",kernelFunc:Hn(x,pa,null,"bool")};function ha(t,n,a){const s=(n-t)/(a-1),r=e.makeZerosTypedArray(a,"float32");r[0]=t;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const fa=Gn((e=>Math.log(e))),ma={kernelName:T,backendName:"cpu",kernelFunc:qn(T,fa)};function ka(t,n,a,s){const r=e.getTypedArrayFromDType(s,e.sizeFromShape(a));for(let e=0;e<r.length;++e){const a=e*n;let s=t[a];for(let e=0;e<n;++e){const n=t[a+e];(Number.isNaN(n)||n>s)&&(s=n)}r[e]=s}return r}const ga=Sn(((e,t)=>Math.max(e,t))),Ia={kernelName:S,backendName:"cpu",kernelFunc:Hn(S,ga)},ba=Sn(((e,t)=>Math.min(e,t))),ya={kernelName:v,backendName:"cpu",kernelFunc:Hn(v,ba)},Na=Sn(((e,t)=>e*t)),xa=Cn(((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n}))),Ta=Hn(F,Na,xa),Sa={kernelName:F,backendName:"cpu",kernelFunc:Ta};function va(t,n,a){const s=e.createScalarValue(-1,a);return Na([],n,s,t,a)}const Fa={kernelName:M,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:a}=t;bn(a,"neg");const s=n.data.get(a.dataId).values,[r,o]=va(s,a.shape,a.dtype);return n.makeTensorInfo(o,a.dtype,r)}},Ma=Sn(((e,t)=>e!==t?1:0)),Aa={kernelName:A,backendName:"cpu",kernelFunc:Hn(A,Ma,null,"bool")};function wa(t,n,a,s,r){const o=n.length,i=e.sizeFromShape(n),d=e.computeStrides(n),c=e.computeStrides(r),l=e.getTypedArrayFromDType(a,e.sizeFromShape(r));for(let n=0;n<i;++n){const a=e.indexToLoc(n,o,d),r=new Array(a.length);for(let e=0;e<r.length;e++)r[e]=a[s[e]];l[e.locToIndex(r,o,c)]=t[n]}return l}function Da(e){const{inputs:t,attrs:n,backend:a}=e,{x:s}=t,{perm:r}=n;bn(s,"transpose");const o=s.shape.length,i=new Array(o);for(let e=0;e<i.length;e++)i[e]=s.shape[r[e]];const d=wa(a.data.get(s.dataId).values,s.shape,s.dtype,r,i);return{dataId:a.write(d,i,s.dtype),shape:i,dtype:s.dtype}}const Ea={kernelName:w,backendName:"cpu",kernelFunc:Da};function za(t,n,a,s){const[r,i]=o.computeOutAndReduceShapes(t,s),d=D(n,"int32"),c=e.makeZerosTypedArray(e.sizeFromShape(r),d),l=e.sizeFromShape(i);for(let e=0;e<c.length;++e){const t=e*l;let n=1;for(let e=0;e<l;++e)n*=a[t+e];c[e]=n}return{outVals:c,outShape:r,outDtype:d}}const Wa={kernelName:E,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s;bn(r,"prod");const c=r.shape.length,l=e.parseAxisParam(i,r.shape),p=o.getAxesPermutation(l,c);let u=l,h=r;const f=[];null!=p&&(h=Da({inputs:{x:r},backend:a,attrs:{perm:p}}),f.push(h),u=o.getInnerMostAxes(u.length,c));const m=a.data.get(h.dataId).values,{outVals:k,outShape:g,outDtype:I}=za(h.shape,h.dtype,m,u);let b=g;return d&&(b=o.expandShapeToKeepDim(g,l)),f.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(b,I,k)}};function Ha(t,n,a,s){if(t===n||t<n&&a<0||n<t&&a>1)return e.makeZerosTypedArray(0,s);const r=Math.abs(Math.ceil((n-t)/a)),o=e.makeZerosTypedArray(r,s);n<t&&1===a&&(a=-1),o[0]=t;for(let e=1;e<o.length;e++)o[e]=o[e-1]+a;return o}const Ca=Gn((e=>1/Math.sqrt(e))),Pa={kernelName:z,backendName:"cpu",kernelFunc:qn(z,Ca)};function Ra(e,t,n,a,s,r,o,d,c,l){const p=[a/s,s],u=e.values,h=t.values;if(0===a)return i(n,t.dtype);const f=i(p,t.dtype);"string"==typeof c||"number"==typeof c?f.values.fill(c):"boolean"==typeof c&&f.values.fill(+c);for(let e=0;e<r;e++){const r=[];let i=0;for(let t=0;t<o;t++){const n=u[e*o+t];r.push(n),i+=n*d[t]}if(i<0||i>=a/s)throw new Error(`Invalid indices: ${r} does not index into ${n}`);for(let n=0;n<s;n++)l?f.values[i*s+n]+=h[e*s+n]:f.values[i*s+n]=0===t.rank?h[0]:h[e*s+n]}return f}const $a=Gn((e=>1/(1+Math.exp(-e)))),Oa=Bn(W,(e=>1/(1+Math.exp(-e)))),Va={kernelName:W,backendName:"cpu",kernelFunc:Oa};function Ga(t,n,a,s,r){const d=H.isSliceContinous(s,n,a),c=e.sizeFromShape(a),l=e.computeStrides(s);if(d){const e=H.computeFlatOffset(n,l);return"string"===r?t.slice(e,e+c):t.subarray(e,e+c)}const p="string"===r?o.fromUint8ToStringArray(t):t,u=i(s,r,p),h=i(a,r);for(let e=0;e<h.size;++e){const t=h.indexToLoc(e),a=t.map(((e,t)=>e+n[t]));h.set(u.get(...a),...t)}return"string"===r?o.fromStringArrayToUint8(h.values):h.values}function Ba(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{begin:r,size:o}=a;bn(s,"slice");const[i,d]=H.parseSliceParams(s,r,o);H.assertParamsValid(s,i,d);const c=Ga(n.data.get(s.dataId).values,i,d,s.shape,s.dtype);return n.makeTensorInfo(d,s.dtype,c)}const qa={kernelName:C,backendName:"cpu",kernelFunc:Ba};function La(t,n,a,s,r,i,d){const c=n[0],l=i[0],p=new Array(l),u=new Array(c),h=n[1];if(0===l){if(0!==c)throw new Error(o.getSparseFillEmptyRowsIndicesDenseShapeMismatch(c));return[e.getArrayFromDType(a,0),[0,h],e.getArrayFromDType(r,0),p,u]}let f=!0,m=0;const k=new Array(l).fill(0);for(let e=0;e<c;++e){const n=t[e*h];if(n<0)throw new Error(o.getSparseFillEmptyRowsNegativeIndexErrorMessage(e,n));if(n>=l)throw new Error(o.getSparseFillEmptyRowsOutOfRangeIndexErrorMessage(e,n,l));++k[n],f=f&&n>=m,m=n}let g=!0;for(let e=0;e<l;++e){const t=0===k[e];p[e]=t,g=g&&!t,k[e]=Math.max(k[e],1),e>0&&(k[e]+=k[e-1])}if(g&&f){const e=t,n=s;for(let e=0;e<c;++e)u[e]=e;return[e,[c,h],n,p,u]}{const n=k[l-1],o=e.getArrayFromDType(a,n*h),i=e.getArrayFromDType(r,n),f=new Array(l).fill(0);for(let e=0;e<c;++e){const n=t[e*h],a=f[n],r=(0===n?0:k[n-1])+a;f[n]++;for(let n=0;n<h;++n)o[r*h+n]=t[e*h+n];i[r]=s[e],u[e]=r}for(let e=0;e<l;++e){if(0===f[e]){const t=0===e?0:k[e-1];o[t*h+0]=e;for(let e=1;e<h;++e)o[t*h+e]=0;i[t]=d}}return[o,[n,h],i,p,u]}}function _a(t,n,a,s,r){const i=e.sizeFromShape(s),d=n[0],c=r.length,l=[];let p=1,u=-1;for(let e=0;e<c;++e){const t=r[e];if(-1===t){if(-1!==u)throw new Error(o.getSparseReshapeMultipleNegativeOneOutputDimErrorMessage(u,e));u=e,l.push(1)}else{if(t<0)throw new Error(o.getSparseReshapeNegativeOutputDimErrorMessage(e,t));p*=t,l.push(t)}}if(-1!==u){if(p<=0)throw new Error(o.getSparseReshapeEmptyTensorZeroOutputDimErrorMessage());const e=Math.trunc(i/p);if(p*e!==i)throw new Error(o.getSparseReshapeInputOutputMultipleErrorMessage(s,l));l[u]=e}if(e.sizeFromShape(l)!==i)throw new Error(o.getSparseReshapeInputOutputMismatchErrorMessage(s,l));const h=s.length,f=[];if(h>0){f[h-1]=1;for(let e=h-2;e>=0;--e)f[e]=f[e+1]*s[e+1]}const m=[];if(c>0){m[c-1]=1;for(let e=c-2;e>=0;--e)m[e]=m[e+1]*l[e+1]}const k=e.getArrayFromDType(a,d*c);for(let e=0;e<d;++e){let n=0;for(let a=0;a<h;++a)n+=t[e*h+a]*f[a];for(let t=0;t<c;++t)k[e*c+t]=Math.trunc(n/m[t]),n%=m[t]}return[k,[d,c],l]}function Ua(t,n,a,s,r,i=!1,d=0){const c=s.length,l=[n[0],t.length/n[0]],p=l[1],u=c>0?r[c-1]+1:0;if(u<0)throw new Error(o.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());const h=n.slice();h[0]=u;const f=h.reduce(((e,t)=>e*t),1),m=e.getArrayFromDType(a,f);if(0===c)return u>0&&m.fill(d),[m,h];if(u<=0)throw new Error(o.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());let k=0,g=1,I=0,b=r[k];for(;;){let e=0;if(g<c){if(e=r[g],b===e){++g;continue}if(b>=e)throw new Error(o.getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage())}if(b<0||b>=u)throw new Error(o.getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage(b,u));b>I&&m.fill(d,I*p,b*p);for(let e=k;e<g;++e){const n=s[e];if(n<0||n>=l[0])throw new Error(o.getSparseSegmentReductionIndicesOutOfRangeErrorMessage(e,s[e],l[0]));for(let e=0;e<p;e++)m[b*p+e]+=t[n*p+e]}if(i)for(let e=0;e<p;e++)m[b*p+e]/=g-k;if(k=g,++g,I=b+1,b=e,g>c)break}return I<u&&m.fill(d,I*p,u*p),[m,h]}const Za=Gn((e=>Math.sqrt(e))),Ka={kernelName:P,backendName:"cpu",kernelFunc:Bn(P,(e=>Math.sqrt(e)))},ja=Sn(((e,t)=>{const n=e-t;return n*n})),Ya={kernelName:R,backendName:"cpu",kernelFunc:Hn(R,ja)};function Ja(e,t,n,a){const s=i(e,t.dtype);for(let e=0;e<s.size;e++){const r=s.indexToLoc(e),o=new Array(r.length);for(let e=0;e<o.length;e++)o[e]=r[e]*n[e]+a[e];s.set(t.get(...o),...r)}return s}class Qa{constructor(t,n,a,s,r,o){this.separator=e.encodeString(t),this.nGramWidths=n,this.leftPad=e.encodeString(a),this.rightPad=e.encodeString(s),this.padWidth=r,this.preserveShort=o}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,t){const n=this.getPadWidth(t);return Math.max(0,e+2*n-t+1)}createNGrams(e,t,n,a,s,r){for(let o=0;o<s;++o){const i=this.getPadWidth(r),d=Math.max(0,i-o),c=Math.max(0,i-(s-(o+1))),l=r-(d+c),p=t+(d>0?0:o-i);let u=0;u+=d*this.leftPad.length;for(let t=0;t<l;++t)u+=e[p+t].length;u+=c*this.rightPad.length;u+=(d+c+l-1)*this.separator.length,n[a+o]=new Uint8Array(u);const h=n[a+o];let f=0;const m=e=>e.forEach((e=>h[f++]=e));for(let e=0;e<d;++e)m(this.leftPad),m(this.separator);for(let t=0;t<l-1;++t)m(e[p+t]),m(this.separator);if(l>0){m(e[p+l-1]);for(let e=0;e<c;++e)m(this.separator),m(this.rightPad)}else{for(let e=0;e<c-1;++e)m(this.rightPad),m(this.separator);m(this.rightPad)}}}compute(t,n){const a=t.length,s=n.length;if(s>0){let e=n[0];if(0!==e)throw new Error(`First split value must be 0, got ${e}`);for(let t=1;t<s;++t){let s=n[t]>=e;if(s=s&&n[t]<=a,!s)throw new Error(`Invalid split value ${n[t]}, must be in [${e}, ${a}]`);e=n[t]}if(e!==a)throw new Error(`Last split value must be data size. Expected ${a}, got ${e}`)}const r=s-1,o=e.getArrayFromDType("int32",s);if(0===a||0===s){const e=new Array(a);for(let e=0;e<=r;++e)o[e]=0;return[e,o]}o[0]=0;for(let e=1;e<=r;++e){const t=n[e]-n[e-1];let a=0;this.nGramWidths.forEach((e=>{a+=this.getNumNGrams(t,e)})),this.preserveShort&&t>0&&0===a&&(a=1),o[e]=o[e-1]+a}const i=new Array(o[r]);for(let e=0;e<r;++e){const a=n[e];let s=o[e];if(this.nGramWidths.forEach((r=>{const o=n[e+1]-n[e],d=this.getNumNGrams(o,r);this.createNGrams(t,a,i,s,d,r),s+=d})),this.preserveShort&&s===o[e]){const r=n[e+1]-n[e];if(0===r)continue;const o=r+2*this.padWidth,d=1;this.createNGrams(t,a,i,s,d,o)}}return[i,o]}}function Xa(e,t,n,a,s,r,o,i){return new Qa(n,a,s,r,o,i).compute(e,t)}function es(e,t,n,a){if(!e.length)return;if(0===t.length){for(let t=0;t<e.length;++t)a.push(e.subarray(t,t+1));return}if(1===t.length){const s=t[0];let r=e.indexOf(s);for(;-1!==r;){const t=e.subarray(0,r);n&&0===t.length||a.push(t),r=(e=e.subarray(r+1)).indexOf(s)}return void(n&&0===e.length||a.push(e))}let s=0;for(let r=0;r<e.length+1;r++)if(r===e.length||-1!==t.indexOf(e[r])){const t=e.subarray(s,r);n&&0===t.length||a.push(t),s=r+1}}function ts(t,n,a){const s=t.length,r=[];let o=0,i=0;const d=new Array(s);for(let e=0;e<s;++e){const s=r.length;es(t[e],n,a,r);const c=r.length-s;d[e]=c,o+=c,i=Math.max(i,c)}const c=e.getArrayFromDType("int32",2*o),l=new Array(o),p=[s,i];let u=0;for(let e=0;e<s;++e)for(let t=0;t<d[e];++t)c[2*u]=e,c[2*u+1]=t,l[u]=r[u],++u;return[c,l,p]}function ns(t,n){const a=e.getArrayFromDType("int32",t.length);for(let s=0;s<t.length;++s)a[s]=e.fingerPrint64(t[s]).modulo(n).getLowBitsUnsigned();return a}const as=Sn(((e,t)=>e-t)),ss=Hn($,as,Cn(((e,t,n,a)=>({real:e-n,imag:t-a})))),rs={kernelName:$,backendName:"cpu",kernelFunc:ss};function os(e,t){const n=new Array(e.rank);for(let a=0;a<n.length;a++)n[a]=e.shape[a]*t[a];const a=i(n,e.dtype);for(let t=0;t<a.values.length;++t){const n=a.indexToLoc(t),s=new Array(e.rank);for(let t=0;t<s.length;t++)s[t]=n[t]%e.shape[t];const r=e.locToIndex(s);a.values[t]=e.values[r]}return a}const is=(e,t)=>{const n=t.value-e.value;return 0===n?e.index-t.index:n};function ds(t,n,a=0,s=t.length-1){for(;s>a;){if(s-a>600){const e=s-a+1,r=n-a+1,o=Math.log(e),i=.5*Math.exp(2*o/3),d=.5*Math.sqrt(o*i*(e-i)/e)*Math.sign(r-e/2);ds(t,n,Math.max(a,Math.floor(n-r*i/e+d)),Math.min(s,Math.floor(n+(e-r)*i/e+d)))}const r=t[n];let o=a,i=s;for(e.swap(t,a,n),is(t[s],r)>0&&e.swap(t,a,s);o<i;){for(e.swap(t,o,i),o++,i--;is(t[o],r)<0;)o+=1;for(;is(t[i],r)>0;)i-=1}0===is(t[a],r)?e.swap(t,a,i):(i+=1,e.swap(t,i,s)),i<=n&&(a=i+1),n<=i&&(s=i-1)}}function cs(t,n,a,s,r){const o=n[n.length-1],[d,c]=[t.length/o,o],l=e.getTypedArrayFromDType(a,d*s),p=e.getTypedArrayFromDType("int32",d*s);for(let e=0;e<d;e++){const n=e*c,a=t.subarray(n,n+c);let o=new Array(a.length);a.forEach(((e,t)=>o[t]={value:e,index:t})),s<o.length&&(ds(o,s),o=o.slice(0,s)),r&&o.sort(is);const i=e*s,d=l.subarray(i,i+s),u=p.subarray(i,i+s);for(let e=0;e<s;e++)d[e]=o[e].value,u[e]=o[e].index}const u=n.slice();return u[u.length-1]=s,[i(u,a,l),i(u,"int32",p)]}function ls(t,n,a,s){const r=e.parseAxisParam(n,a)[0],o=[1,a[0],1];for(let e=0;e<r;e++)o[0]*=a[e];o[1]=a[r];for(let e=r+1;e<a.length;e++)o[2]*=a[e];const i={},d=new Int32Array(a[r]),c=new O(o,s,t),l=[],p=1===o[0]&&1===o[2];for(let e=0;e<a[r];e++){let n;if(p)n=t[e].toString();else{const t=[];for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)t.push(c.get(n,e,a));n=t.join(",")}if(void 0!==i[n])d[e]=i[n];else{const t=Object.keys(i).length;i[n]=t,d[e]=t,l.push(e)}}const u=o.slice();u[1]=Object.keys(i).length;const h=new O(u,s);l.forEach(((e,t)=>{for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)h.set(c.get(n,e,a),n,t,a)}));const f=a.slice();return f[r]=u[1],{outputValues:h.values,outputShape:f,indices:d}}var ps={__proto__:null,simpleAbsImpl:xn,addImpl:Pn,bincountImpl:On,bincountReduceImpl:Vn,ceilImpl:Ln,concatImpl:Un,equalImpl:Zn,expImpl:Yn,expm1Impl:Xn,floorImpl:ta,gatherNdImpl:aa,gatherV2Impl:sa,greaterImpl:ra,greaterEqualImpl:ia,lessImpl:ca,lessEqualImpl:pa,linSpaceImpl:ha,logImpl:fa,maxImpl:ka,maximumImpl:ga,minimumImpl:ba,multiplyImpl:Na,negImpl:va,notEqualImpl:Ma,prodImpl:za,rangeImpl:Ha,rsqrtImpl:Ca,scatterImpl:Ra,sigmoidImpl:$a,sliceImpl:Ga,sparseFillEmptyRowsImpl:La,sparseReshapeImpl:_a,sparseSegmentReductionImpl:Ua,sqrtImpl:Za,squaredDifferenceImpl:ja,stridedSliceImpl:Ja,stringNGramsImpl:Xa,stringSplitImpl:ts,stringToHashBucketFastImpl:ns,subImpl:as,tileImpl:os,topKImpl:cs,transposeImpl:wa,uniqueImpl:ls};const us="3.19.0";V("cpu",(()=>new Nn),1);const hs=Bn(G,(e=>e>=0?e:Math.exp(e)-1)),fs={kernelName:G,backendName:"cpu",kernelFunc:hs};function ms(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{alpha:o}=s;bn([r],"leakyRelu");const i=e.sizeFromShape(r.shape),d=a.data.get(r.dataId).values,c=e.getTypedArrayFromDType("float32",i);for(let e=0;e<d.length;e++)c[e]=d[e]<0?o*d[e]:d[e];return a.makeTensorInfo(r.shape,"float32",c)}const ks={kernelName:B,backendName:"cpu",kernelFunc:ms},gs=Sn(((e,t)=>e<0?t*e:e));function Is(e){const{inputs:t,backend:n}=e,{x:a,alpha:s}=t;bn([a,s],"prelu");const r=n.data.get(a.dataId).values,o=n.data.get(s.dataId).values,[i,d]=gs(a.shape,s.shape,r,o,"float32");return n.makeTensorInfo(d,"float32",i)}const bs={kernelName:q,backendName:"cpu",kernelFunc:Is},ys=Bn(L,(e=>Math.max(0,e))),Ns={kernelName:L,backendName:"cpu",kernelFunc:ys},xs=Bn(_,(e=>Math.min(Math.max(0,e),6))),Ts={kernelName:_,backendName:"cpu",kernelFunc:xs};function Ss(e,t,n,a,s){if("linear"===n)return An({inputs:{x:t},backend:e});if("relu"===n)return ys({inputs:{x:t},backend:e});if("elu"===n)return hs({inputs:{x:t},backend:e});if("relu6"===n)return xs({inputs:{x:t},backend:e});if("prelu"===n)return Is({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return ms({inputs:{x:t},backend:e,attrs:{alpha:s}});if("sigmoid"===n)return Oa({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function vs(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{shape:o}=s,i=e.sizeFromShape(r.shape),d=e.inferFromImplicitShape(o,i),c=e.sizeFromShape(d);e.assert(i===c,(()=>`The new shape (${d}) has ${c} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`)),a.incRef(r.dataId);const l=a.data.get(r.dataId);if(null!=l.complexTensorInfos){const e=l.complexTensorInfos.real,t=l.complexTensorInfos.imag;e.shape=d,t.shape=d}return{dataId:r.dataId,shape:d,dtype:r.dtype}}const Fs={kernelName:U,backendName:"cpu",kernelFunc:vs};function Ms(t){const{inputs:n,backend:a,attrs:s}=t,{a:r,b:o}=n,{transposeA:d,transposeB:c}=s;bn([r,o],"matMul");const l=r.shape.length,p=o.shape.length,u=d?r.shape[l-2]:r.shape[l-1],h=c?o.shape[p-1]:o.shape[p-2],f=d?r.shape[l-1]:r.shape[l-2],m=c?o.shape[p-2]:o.shape[p-1],k=r.shape.slice(0,-2),g=o.shape.slice(0,-2),I=e.sizeFromShape(k),b=e.sizeFromShape(g),y=K.assertAndGetBroadcastShape(r.shape.slice(0,-2),o.shape.slice(0,-2)).concat([f,m]);e.assert(u===h,(()=>`Error in matMul: inner shapes (${u}) and (${h}) of Tensors with shapes ${r.shape} and ${o.shape} and transposeA=${d} and transposeB=${c} must match.`));const N=c?[b,m,h]:[b,h,m],x=vs({inputs:{x:r},backend:a,attrs:{shape:d?[I,u,f]:[I,f,u]}}),T=vs({inputs:{x:o},backend:a,attrs:{shape:N}}),S=d?x.shape[1]:x.shape[2],v=d?x.shape[2]:x.shape[1],F=c?T.shape[1]:T.shape[2],M=Math.max(I,b),A=a.data.get(x.dataId).values,w=a.data.get(T.dataId).values,D=e.computeStrides(x.shape),E=e.computeStrides(T.shape),[z,W,H]=d?[D[0],1,D[1]]:[D[0],D[1],1],[C,P,R]=c?[1,E[1],E[0]]:[E[1],1,E[0]],$=v*F,O=i([M,v,F],x.dtype),V=O.values,G=a.blockSize;for(let e=0;e<M;e++)for(let t=0;t<v;t+=G)for(let n=0;n<F;n+=G)for(let a=0;a<S;a+=G){const s=Math.min(t+G,v),r=Math.min(n+G,F),o=Math.min(a+G,S);for(let i=t;i<s;i++)for(let t=n;t<r;t++){let n=0;for(let s=a;s<o;s++){const a=Math.min(e,I-1)*z,r=Math.min(e,b-1)*R;n+=A[a+i*W+s*H]*w[s*C+t*P+r]}V[e*$+(i*F+t)]+=n}}return a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(T),a.makeTensorInfo(y,O.dtype,O.values)}const As={kernelName:Z,backendName:"cpu",kernelFunc:Ms};const ws={kernelName:j,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:r,bias:o,preluActivationWeights:i}=t,{transposeA:d,transposeB:c,activation:l,leakyreluAlpha:p}=a;let u,h,f;const m=[];u=Ms({inputs:{a:s,b:r},attrs:{transposeA:d,transposeB:c},backend:n}),o&&(h=Rn({inputs:{a:u,b:o},backend:n}),m.push(u),u=h),l&&(f=Ss(n,u,l,i,p),m.push(u),u=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return u}},Ds={kernelName:Y,backendName:"cpu",kernelFunc:Bn(Y,(e=>Math.acos(e)))},Es={kernelName:J,backendName:"cpu",kernelFunc:Bn(J,(e=>Math.acosh(e)))};const zs={kernelName:Q,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,a=t;bn(t,"addN");const s=a.map((e=>n.data.get(e.dataId).values)),r=i(a[0].shape,a[0].dtype),o=r.values;for(let e=0;e<a.length;e++){const t=s[e];for(let e=0;e<o.length;e++)o[e]+=t[e]}return n.makeTensorInfo(r.shape,r.dtype,r.values)}};const Ws={kernelName:X,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s;bn(r,"all");const c=e.parseAxisParam(i,r.shape);let l=c;const p=o.getAxesPermutation(l,r.shape.length);let u=r;null!=p&&(u=Da({inputs:{x:r},backend:a,attrs:{perm:p}}),l=o.getInnerMostAxes(l.length,r.shape.length)),o.assertAxesAreInnerMostDims("all",l,u.shape.length);const[h,f]=o.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),g=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n&&a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const I=a.makeTensorInfo(h,u.dtype,k);if(d){const e=vs({inputs:{x:I},backend:a,attrs:{shape:o.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(I),e}return I}};const Hs={kernelName:ee,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s;bn(r,"any");const c=e.parseAxisParam(i,r.shape);let l=c;const p=o.getAxesPermutation(l,r.shape.length);let u=r;null!=p&&(u=Da({inputs:{x:r},backend:a,attrs:{perm:p}}),l=o.getInnerMostAxes(l.length,r.shape.length)),o.assertAxesAreInnerMostDims("any",l,u.shape.length);const[h,f]=o.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),g=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n||a}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const I=a.makeTensorInfo(h,u.dtype,k);if(d){const e=vs({inputs:{x:I},backend:a,attrs:{shape:o.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(I),e}return I}};const Cs={kernelName:te,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i}=s;bn(r,"argMax");let d=e.parseAxisParam(i,r.shape);const c=o.getAxesPermutation(d,r.shape.length);let l=r;const p=[];null!=c&&(l=Da({inputs:{x:r},backend:a,attrs:{perm:c}}),p.push(l),d=o.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],o.assertAxesAreInnerMostDims("argMax",d,l.shape.length);const[u,h]=o.computeOutAndReduceShapes(l.shape,d),f=e.sizeFromShape(u),m=e.makeZerosTypedArray(f,"int32"),k=e.sizeFromShape(h),g=a.data.get(l.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s>n&&(n=s,a=e)}m[e]=a}return p.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(u,"int32",m)}};const Ps={kernelName:ne,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i}=s;bn(r,"argMin");let d=e.parseAxisParam(i,r.shape);const c=o.getAxesPermutation(d,r.shape.length);let l=r;const p=[];null!=c&&(l=Da({inputs:{x:r},backend:a,attrs:{perm:c}}),p.push(l),d=o.getInnerMostAxes(d.length,l.shape.length)),d=[d[0]],o.assertAxesAreInnerMostDims("argMin",d,l.shape.length);const[u,h]=o.computeOutAndReduceShapes(l.shape,d),f=e.sizeFromShape(u),m=e.makeZerosTypedArray(f,"int32"),k=e.sizeFromShape(h),g=a.data.get(l.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s<n&&(n=s,a=e)}m[e]=a}return p.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(u,"int32",m)}},Rs={kernelName:ae,backendName:"cpu",kernelFunc:Bn(ae,(e=>Math.asin(e)))},$s={kernelName:se,backendName:"cpu",kernelFunc:Bn(se,(e=>Math.asinh(e)))},Os={kernelName:re,backendName:"cpu",kernelFunc:Bn(re,(e=>Math.atan(e)))},Vs={kernelName:oe,backendName:"cpu",kernelFunc:Hn(oe,Sn(((e,t)=>Math.atan2(e,t))))},Gs={kernelName:ie,backendName:"cpu",kernelFunc:Bn(ie,(e=>Math.atanh(e)))};function Bs(e,t,n,a,s,r){const o=s.strideHeight,d=s.strideWidth,c=s.dilationHeight,l=s.dilationWidth,p=s.effectiveFilterHeight,u=s.effectiveFilterWidth,h=s.padInfo.top,f=s.padInfo.left,m="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=i(s.outShape,n),g=k.values,I=s.outShape[1]*s.outShape[2]*s.outShape[3],b=s.outShape[2]*s.outShape[3],y=s.outShape[3];for(let t=0;t<s.batchSize;++t){const n=t*I,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let k=0;k<s.outHeight;++k){const I=k*o-h,N=Math.max(0,I),x=Math.min(s.inHeight,p+I),T=n+k*b;for(let n=0;n<s.outWidth;++n){const o=n*d-f,p=Math.max(0,o),h=Math.min(s.inWidth,u+o);let k=m,I=0,b=0;for(let n=N;n<x;n+=c){const s=i+n*a[1];for(let n=p;n<h;n+=l){const o=e[s+n*a[2]+t];"max"===r&&o>k?k=o:"avg"===r&&(I+=o,b++)}if(isNaN(k))break}g[T+n*y+t]="avg"===r?I/b:k}}}return k}function qs(e,t,n,a,s=!1,r=!1){const o=i(a.outShape,"int32"),d=a.strideHeight,c=a.strideWidth,l=a.dilationHeight,p=a.dilationWidth,u=a.effectiveFilterHeight,h=a.effectiveFilterWidth,f=a.padInfo.top,m=a.padInfo.left,k=i(t,n,e);for(let e=0;e<a.batchSize;++e)for(let t=0;t<a.inChannels;++t)for(let n=0;n<a.outHeight;++n){const i=n*d-f;let g=i;for(;g<0;)g+=l;const I=Math.min(a.inHeight,u+i);for(let d=0;d<a.outWidth;++d){const u=d*c-m;let f=u;for(;f<0;)f+=p;const b=Math.min(a.inWidth,h+u);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=g;n<I;n+=l){const o=n-i;for(let i=f;i<b;i+=p){const d=i-u,c=k.get(e,n,i,t);c>y&&(y=c,N=s?r?((e*a.inHeight+n)*a.inWidth+i)*a.inChannels+t:(n*a.inWidth+i)*a.inChannels+t:o*h+d)}}o.set(N,e,n,d,t)}}return o}function Ls(e,t,n,a,s,r){const o=s.strideDepth,d=s.strideHeight,c=s.strideWidth,l=s.dilationDepth,p=s.dilationHeight,u=s.dilationWidth,h=s.effectiveFilterDepth,f=s.effectiveFilterHeight,m=s.effectiveFilterWidth,k=s.padInfo.front,g=s.padInfo.top,I=s.padInfo.left,b="max"===r?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=i(s.outShape,n),N=y.values,x=s.outShape[1]*s.outShape[2]*s.outShape[3]*s.outShape[4],T=s.outShape[2]*s.outShape[3]*s.outShape[4],S=s.outShape[3]*s.outShape[4],v=s.outShape[4];for(let t=0;t<s.batchSize;++t){const n=t*x,i=t*a[0];for(let t=0;t<s.inChannels;++t)for(let y=0;y<s.outDepth;++y){const x=y*o-k;let F=x;for(;F<0;)F+=l;const M=Math.min(s.inDepth,h+x),A=n+y*T;for(let n=0;n<s.outHeight;++n){const o=n*d-g;let h=o;for(;h<0;)h+=p;const k=Math.min(s.inHeight,f+o),y=A+n*S;for(let n=0;n<s.outWidth;++n){const o=n*c-I;let d=o;for(;d<0;)d+=u;const f=Math.min(s.inWidth,m+o),g=y+n*v;let x=b,T=0,S=0;for(let n=F;n<M;n+=l){const s=i+n*a[1];for(let n=h;n<k;n+=p){const o=s+n*a[2];for(let n=d;n<f;n+=u){const s=e[o+n*a[3]+t];if("max"===r&&s>x?x=s:"avg"===r&&(T+=s,S++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[g+t]="avg"===r?T/S:x}}}}return y}const _s={kernelName:de,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n;bn(r,"avgPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(o.eitherStridesOrDilationsAreOne(d,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${d} and dilations '1'`));const p=o.computePool2DInfo(r.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=An({inputs:{x:r},backend:a});else{const t=a.data.get(r.dataId).values,n=e.computeStrides(r.shape),s=Bs(t,r.shape,r.dtype,n,p,"avg");u=a.makeTensorInfo(p.outShape,r.dtype,s.values)}return u}};const Us={kernelName:ce,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;bn(r,"avgPool3d");const u=o.computePool3DInfo(r.shape,i,d,1,c,l,p),h=Ls(a.data.get(r.dataId).values,r.shape,r.dtype,e.computeStrides(r.shape),u,"avg");return a.makeTensorInfo(h.shape,"float32",h.values)}};const Zs={kernelName:le,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:r}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;bn([s,r],"avgPool3DGrad");const u=o.computePool3DInfo(r.shape,d,c,1,l,p),h=u.strideDepth,f=u.strideHeight,m=u.strideWidth,k=u.filterDepth,g=u.filterHeight,I=u.filterWidth,b=u.dilationDepth,y=u.dilationHeight,N=u.dilationWidth,x=u.effectiveFilterDepth,T=u.effectiveFilterHeight,S=u.effectiveFilterWidth,v=x-1-u.padInfo.front,F=S-1-u.padInfo.left,M=T-1-u.padInfo.top,A=i(r.shape,"float32"),w=1/(k*g*I),D=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const r=n-v,o=a-M,i=s-F;let d=0;for(let n=0;n<x;n+=b){const a=(r+n)/h;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let n=0;n<T;n+=y){const s=(o+n)/f;if(!(s<0||s>=u.outHeight||Math.floor(s)!==s))for(let n=0;n<S;n+=N){const r=(i+n)/m;if(r<0||r>=u.outWidth||Math.floor(r)!==r)continue;d+=D.get(e,a,s,r,t)}}}A.set(d*w,e,n,a,s,t)}return n.makeTensorInfo(A.shape,A.dtype,A.values)}};const Ks={kernelName:pe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:r}=t,d=r;bn([s,r],"avgPoolGrad");const{filterSize:c,strides:l,pad:p}=a,u=o.computePool2DInfo(d.shape,c,l,1,p),h=u.strideHeight,f=u.strideWidth,m=u.filterHeight,k=u.filterWidth,g=u.dilationHeight,I=u.dilationWidth,b=u.effectiveFilterHeight,y=u.effectiveFilterWidth,N=y-1-u.padInfo.left,x=b-1-u.padInfo.top,T=i(d.shape,"float32"),S=1/(m*k),v=n.data.get(s.dataId).values,F=i(s.shape,"float32",v);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inHeight;++n)for(let a=0;a<u.inWidth;++a){const s=n-x,r=a-N;let o=0;for(let n=0;n<b;n+=g){const a=(s+n)/h;if(!(a<0||a>=u.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=I){const s=(r+n)/f;if(s<0||s>=u.outWidth||Math.floor(s)!==s)continue;o+=F.get(e,a,s,t)}}T.set(o*S,e,n,a,t)}return n.makeTensorInfo(T.shape,T.dtype,T.values)}};const js={kernelName:ue,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,scale:o,offset:i,mean:d,variance:c}=n;e.assert(d.shape.length===c.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),e.assert(null==i||d.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),e.assert(null==o||d.shape.length===o.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks.")),bn([r,d,c,o,i],"batchNorm");let{varianceEpsilon:l}=s;null==l&&(l=.001);const p=a.data.get(r.dataId).values,u=a.data.get(d.dataId).values,h=a.data.get(c.dataId).values,f=o?a.data.get(o.dataId).values:new Float32Array([1]),m=i?a.data.get(i.dataId).values:new Float32Array([0]),k=new Float32Array(p.length),g=m.length,I=f.length,b=h.length,y=u.length;let N=0,x=0,T=0,S=0;for(let e=0;e<p.length;++e)k[e]=m[N++]+(p[e]-u[x++])*f[T++]/Math.sqrt(h[S++]+l),N>=g&&(N=0),x>=y&&(x=0),T>=I&&(T=0),S>=b&&(S=0);return a.makeTensorInfo(r.shape,r.dtype,k)}};const Ys={kernelName:he,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{blockShape:r,crops:i}=a;bn([s],"batchToSpaceND");const d=r.reduce(((e,t)=>e*t)),c=o.getReshaped(s.shape,r,d),l=o.getPermuted(c.length,r.length),p=o.getReshapedPermuted(s.shape,r,d),u=o.getSliceBeginCoords(i,r.length),h=o.getSliceSize(p,i,r.length),f=vs({inputs:{x:s},backend:n,attrs:{shape:c}}),m=Da({inputs:{x:f},backend:n,attrs:{perm:l}}),k=vs({inputs:{x:m},backend:n,attrs:{shape:p}}),g=Ba({inputs:{x:k},backend:n,attrs:{begin:u,size:h}});return n.disposeIntermediateTensorInfo(f),n.disposeIntermediateTensorInfo(m),n.disposeIntermediateTensorInfo(k),g}};const Js={kernelName:fe,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o}=a,i=On(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,i)}};const Qs={kernelName:me,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{s0:a,s1:s}=t,r=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,d=o.assertAndGetBroadcastShape(Array.from(r),Array.from(i));return n.makeTensorInfo([d.length],"int32",Int32Array.from(d))}},Xs={kernelName:ke,backendName:"cpu",kernelFunc:Bn(ke,((e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e}))},er={kernelName:ge,backendName:"cpu",kernelFunc:t=>{const{x:n}=t.inputs,a=t.backend,s=new Float32Array(e.sizeFromShape(n.shape)),r=a.data.get(n.dataId),o=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,d=a.data.get(o.dataId).values,c=a.data.get(i.dataId).values;for(let e=0;e<d.length;e++){const t=d[e],n=c[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function tr(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const nr={kernelName:Ie,backendName:"cpu",kernelFunc:tr};function ar(t){const{inputs:n,backend:a,attrs:s}=t,{axis:r}=s,i=e.parseAxisParam(r,n[0].shape)[0];let d=o.computeOutShape(n.map((e=>e.shape)),i);if(0===e.sizeFromShape(d))return a.makeTensorInfo(d,n[0].dtype,[]);const c=n.filter((t=>e.sizeFromShape(t.shape)>0));if(1===c.length)return An({inputs:{x:c[0]},backend:a});const l=c.map((e=>e.shape));if(o.assertParamsConsistent(l,i),"complex64"===c[0].dtype){const e=c.map((e=>Dn({inputs:{input:e},backend:a}))),t=c.map((e=>tr({inputs:{input:e},backend:a}))),n=ar({inputs:e,backend:a,attrs:{axis:i}}),s=ar({inputs:t,backend:a,attrs:{axis:i}}),r=vn({inputs:{real:n,imag:s},backend:a});return e.forEach((e=>a.disposeIntermediateTensorInfo(e))),t.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),r}const p=c.map((t=>{const n=e.sizeFromShape(t.shape.slice(i));return vs({inputs:{x:t},backend:a,attrs:{shape:[-1,n]}})})),u=p.map((e=>({vals:a.data.get(e.dataId).values,shape:e.shape})));d=o.computeOutShape(p.map((e=>e.shape)),1);const h=1===p[0].shape[0],f=Un(u,d,n[0].dtype,h),m=o.computeOutShape(c.map((e=>e.shape)),i),k=a.makeTensorInfo(m,n[0].dtype,f);return p.forEach((e=>a.disposeIntermediateTensorInfo(e))),k}const sr={kernelName:be,backendName:"cpu",kernelFunc:ar};function rr(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,filter:i}=n,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}=s;bn([r,i],"conv2d");const h=o.convertConv2DDataFormat(l),f=o.computeConv2DInfo(r.shape,i.shape,d,p,c,u,!1,h),m=f.filterHeight,k=f.filterWidth,g=f.dilationHeight,I=f.dilationWidth,b=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,x=new O(f.outShape,r.dtype),T=e.computeStrides(r.shape),S=e.computeStrides(i.shape),v=T[0],F=N?T[1]:T[2],M=N?T[2]:1,A=N?1:T[1],w=x.strides[0],D=N?x.strides[1]:x.strides[2],E=N?x.strides[2]:1,z=N?1:x.strides[1],W=a.data.get(r.dataId).values,H=a.data.get(i.dataId).values,C=x.values;for(let e=0;e<f.batchSize;++e){const t=e*v,n=e*w;for(let e=0;e<f.outHeight;++e){const a=n+e*D,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*g;if(n<0||n>=f.inHeight)continue;const r=e*S[0],o=t+n*F;for(let e=0;e<f.outWidth;++e){const t=a+e*E,n=e*f.strideWidth-b;for(let e=0;e<k;++e){const a=n+e*I;if(a<0||a>=f.inWidth)continue;const s=o+a*M;let i=r+e*S[1];for(let e=0;e<f.inChannels;++e){const n=W[s+e*A];for(let e=0;e<f.outChannels;++e)C[t+e*z]+=n*H[i+e];i+=f.outChannels}}}}}}return a.makeTensorInfo(x.shape,x.dtype,C)}const or={kernelName:ye,backendName:"cpu",kernelFunc:rr};const ir={kernelName:Ne,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:r}=t,{strides:i,pad:d,dataFormat:c,dimRoundingMode:l,filterShape:p}=a;bn([s,r],"conv2dBackpropFilter");const u=o.convertConv2DDataFormat(c),h=o.computeConv2DInfo(s.shape,p,i,1,d,l,!1,u),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:g}=h,I="channelsLast"===h.dataFormat,b=new O(h.filterShape,"float32"),y=h.padInfo.left,N=h.padInfo.top,x=n.data.get(s.dataId).values,T=n.data.get(r.dataId).values,S=new O(s.shape,s.dtype,x),v=new O(r.shape,r.dtype,T);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((N-e)/f)),n=Math.min(h.outHeight,(h.inHeight+N-e)/f);for(let a=0;a<g;++a){const s=Math.max(0,Math.ceil((y-a)/m)),r=Math.min(h.outWidth,(h.inWidth+y-a)/m);for(let o=0;o<h.inChannels;++o)for(let i=0;i<h.outChannels;++i){let d=0;for(let c=0;c<h.batchSize;++c)for(let l=t;l<n;++l){const t=e+l*f-N;for(let e=s;e<r;++e){const n=a+e*m-y;d+=I?S.get(c,t,n,o)*v.get(c,l,e,i):S.get(c,o,t,n)*v.get(c,i,l,e)}}b.set(d,e,a,o,i)}}}return n.makeTensorInfo(b.shape,b.dtype,b.values)}};const dr={kernelName:xe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:r,filter:i}=n,{inputShape:d,strides:c,pad:l,dataFormat:p,dimRoundingMode:u}=s;bn([r,i],"conv2dBackpropInput");const h=e.computeStrides(i.shape),f=e.computeStrides(r.shape);let m=o.convertConv2DDataFormat(p);const k=o.computeConv2DInfo(d,i.shape,c,1,l,u,!1,m),g=new O(k.inShape,"float32"),I=g.values,b=a.data.get(r.dataId).values,y=a.data.get(i.dataId).values,[N,x,T]=h,{batchSize:S,filterHeight:v,filterWidth:F,inChannels:M,inHeight:A,inWidth:w,outChannels:D,outHeight:E,outWidth:z,strideHeight:W,strideWidth:H}=k;m=k.dataFormat;const C=v-1-k.padInfo.top,P=F-1-k.padInfo.left,R="channelsLast"===m,$=g.strides[0],V=R?g.strides[1]:g.strides[2],G=R?g.strides[2]:1,B=R?1:g.strides[1],q=f[0],L=R?f[1]:f[2],_=R?f[2]:1,U=R?1:f[1];for(let e=0;e<S;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-C,s=Math.max(0,Math.ceil(a/W)),r=Math.min(E,(v+a)/W);for(let o=0;o<w;++o){const i=o-P,d=Math.max(0,Math.ceil(i/H)),c=Math.min(z,(F+i)/H);let l=0;for(let n=s;n<r;++n){const s=n*W-a;for(let a=d;a<c;++a){const r=q*e+L*n+_*a,o=N*(v-1-s)+x*(F-1-(a*H-i))+T*t;for(let e=0;e<D;++e){l+=b[r+U*e]*y[o+e]}}}I[$*e+V*n+G*o+B*t]=l}}return a.makeTensorInfo(g.shape,g.dtype,g.values)}};const cr={kernelName:Te,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,filter:i}=n,{strides:d,pad:c,dilations:l}=s;bn([r,i],"conv3d");const p=o.computeConv3DInfo(r.shape,i.shape,d,l,c),{filterDepth:u,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:g,padInfo:I}=p,b=I.front,y=I.left,N=I.top,x=new O(p.outShape,r.dtype),T=a.data.get(r.dataId).values,S=a.data.get(i.dataId).values,v=x.values,F=e.computeStrides(r.shape),M=e.computeStrides(i.shape);for(let e=0;e<p.batchSize;++e){const t=e*F[0],n=e*x.strides[0];for(let e=0;e<p.outDepth;++e){const a=n+e*x.strides[1],s=e*p.strideDepth-b;for(let e=0;e<u;++e){const n=s+e*m;if(n<0||n>=p.inDepth)continue;const r=e*M[0],o=t+n*F[1];for(let e=0;e<p.outHeight;++e){const t=a+e*x.strides[2],n=e*p.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=p.inHeight)continue;const s=r+e*M[1],i=o+a*F[2];for(let e=0;e<p.outWidth;++e){const n=t+e*p.outChannels,a=e*p.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*g;if(t<0||t>=p.inWidth)continue;const r=s+e*M[2],o=i+t*p.inChannels;let d=r;for(let e=0;e<p.inChannels;++e){const t=T[o+e];for(let e=0;e<p.outChannels;++e)v[n+e]+=t*S[d+e];d+=p.outChannels}}}}}}}}return a.makeTensorInfo(x.shape,x.dtype,x.values)}};const lr={kernelName:Se,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,dy:i}=n,{strides:d,pad:c,filterShape:l}=s;bn([r,i],"conv3dBackpropFilterV2");const p=e.computeStrides(r.shape),u=e.computeStrides(i.shape),h=o.computeConv3DInfo(r.shape,l,d,1,c),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,g=h.filterDepth,I=h.filterHeight,b=h.filterWidth,y=new O(h.filterShape,"float32"),N=y.values,[x,T,S,v]=y.strides,F=a.data.get(i.dataId).values,[M,A,w,D]=u,E=a.data.get(r.dataId).values,[z,W,H,C]=p,P=h.padInfo.front,R=h.padInfo.left,$=h.padInfo.top;for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((P-e)/f)),n=Math.min(h.outDepth,(h.inDepth+P-e)/f),a=e*x;for(let s=0;s<I;++s){const r=Math.max(0,Math.ceil(($-s)/m)),o=Math.min(h.outHeight,(h.inHeight+$-s)/m),i=s*T+a;for(let a=0;a<b;++a){const d=Math.max(0,Math.ceil((R-a)/k)),c=Math.min(h.outWidth,(h.inWidth+R-a)/k),l=a*S+i;for(let i=0;i<h.inChannels;++i){const p=i*v+l;for(let l=0;l<h.outChannels;++l){let u=0;for(let p=0;p<h.batchSize;++p){const h=p*z,g=p*M;for(let p=t;p<n;++p){const t=(e+p*f-P)*W+h,n=p*A+g;for(let e=r;e<o;++e){const r=(s+e*m-$)*H+t,o=e*w+n;for(let e=d;e<c;++e){const t=e*D+o;u+=E[(a+e*k-R)*C+r+i]*F[t+l]}}}}N[p+l]=u}}}}}return a.makeTensorInfo(y.shape,y.dtype,y.values)}};const pr={kernelName:ve,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:r,filter:i}=n,{pad:d,strides:c,inputShape:l}=s;bn([r],"conv3dBackpropInputV2");const p=e.computeStrides(r.shape),u=e.computeStrides(i.shape),h=o.computeConv3DInfo(l,i.shape,c,1,d),f=new O(h.inShape,"float32"),m=f.values,[k,g,I,b]=f.strides,y=a.data.get(r.dataId).values,[N,x,T,S]=p,v=a.data.get(i.dataId).values,[F,M,A,w]=u,{batchSize:D,filterDepth:E,filterHeight:z,filterWidth:W,inChannels:H,inDepth:C,inHeight:P,inWidth:R,outChannels:$,outDepth:V,outHeight:G,outWidth:B,strideDepth:q,strideHeight:L,strideWidth:_}=h,U=E-1-h.padInfo.front,Z=z-1-h.padInfo.top,K=W-1-h.padInfo.left;for(let e=0;e<D;++e)for(let t=0;t<H;++t)for(let n=0;n<C;++n){const a=n-U,s=Math.max(0,Math.ceil(a/q)),r=Math.min(V,(E+a)/q);for(let o=0;o<P;++o){const i=o-Z,d=Math.max(0,Math.ceil(i/L)),c=Math.min(G,(z+i)/L);for(let l=0;l<R;++l){const p=l-K,u=Math.max(0,Math.ceil(p/_)),h=Math.min(B,(W+p)/_);let f=0;for(let n=s;n<r;++n){const s=n*q-a;for(let a=d;a<c;++a){const r=a*L-i;for(let o=u;o<h;++o){const i=N*e+x*n+T*a+S*o,d=F*(E-1-s)+M*(z-1-r)+A*(W-1-(o*_-p))+w*t;for(let e=0;e<$;++e){f+=y[i+e]*v[d+e]}}}}m[k*e+g*n+I*o+b*l+t]=f}}}return a.makeTensorInfo(f.shape,f.dtype,f.values)}},ur={kernelName:Fe,backendName:"cpu",kernelFunc:Bn(Fe,(e=>Math.cos(e)))},hr={kernelName:Me,backendName:"cpu",kernelFunc:Bn(Me,(e=>Math.cosh(e)))};const fr={kernelName:Ae,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{image:r,boxes:o,boxInd:d}=n,{cropSize:c,method:l,extrapolationValue:p}=s,[u,h,f,m]=r.shape,k=o.shape[0],[g,I]=c,b=i([k,g,I,m],"float32"),y=a.data.get(o.dataId).values,N=a.data.get(d.dataId).values,x=a.data.get(r.dataId).values,T=e.computeStrides(r.shape),S=e.computeStrides(b.shape);for(let e=0;e<k;e++){const t=4*e,n=y[t],a=y[t+1],s=y[t+2],r=y[t+3],o=N[e];if(o>=u)continue;const i=g>1?(s-n)*(h-1)/(g-1):0,d=I>1?(r-a)*(f-1)/(I-1):0;for(let t=0;t<g;t++){const c=g>1?n*(h-1)+t*i:.5*(n+s)*(h-1);if(c<0||c>h-1)for(let n=0;n<I;n++)for(let a=0;a<m;a++){const s=a+n*S[2]+t*S[1]+e*S[0];b.values[s]=p}else if("bilinear"===l){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let c=0;c<I;c++){const l=I>1?a*(f-1)+c*d:.5*(a+r)*(f-1);if(l<0||l>f-1){for(let n=0;n<m;n++){const a=n+c*S[2]+t*S[1]+e*S[0];b.values[a]=p}continue}const u=Math.floor(l),h=Math.ceil(l),k=l-u;for(let a=0;a<m;a++){let r=a+u*T[2]+n*T[1]+o*T[0];const d=x[r];r=a+h*T[2]+n*T[1]+o*T[0];const l=x[r];r=a+u*T[2]+s*T[1]+o*T[0];const p=x[r];r=a+h*T[2]+s*T[1]+o*T[0];const f=d+(l-d)*k,m=p+(x[r]-p)*k;r=a+c*S[2]+t*S[1]+e*S[0],b.values[r]=f+(m-f)*i}}}else for(let n=0;n<I;++n){const s=I>1?a*(f-1)+n*d:.5*(a+r)*(f-1);if(s<0||s>f-1){for(let a=0;a<m;a++){const s=a+n*S[2]+t*S[1]+e*S[0];b.values[s]=p}continue}const i=Math.round(s),l=Math.round(c);for(let a=0;a<m;a++){const s=a+i*T[2]+l*T[1]+o*T[0],r=a+n*S[2]+t*S[1]+e*S[0];b.values[r]=x[s]}}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const mr={kernelName:we,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,exclusive:d,reverse:c}=s;bn(r,"cumprod");const l=o.getAxesPermutation([i],r.shape.length);let p=r;null!=l&&(p=Da({inputs:{x:r},backend:a,attrs:{perm:l}}));const u=o.getInnerMostAxes(1,r.shape.length)[0];if(u!==p.shape.length-1)throw new Error(`backend.cumprod in CPU expects an inner-most axis=${p.shape.length-1} but got axis=${u}`);const h=D(p.dtype,"int32"),f=e.makeOnesTypedArray(e.sizeFromShape(p.shape),h),m=a.data.get(p.dataId).values,k=p.shape[p.shape.length-1],g=c?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=g(e,t);if(0===t)f[n]=d?1:m[n];else{const a=g(e,t-1);f[n]=d?m[a]*f[a]:m[n]*f[a]}}const I=a.makeTensorInfo(p.shape,h,f);if(null!=l){const e=Da({inputs:{x:I},backend:a,attrs:{perm:o.getUndoAxesPermutation(l)}});return a.disposeIntermediateTensorInfo(I),a.disposeIntermediateTensorInfo(p),e}return I}};const kr={kernelName:De,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,exclusive:d,reverse:c}=s;bn(r,"cumsum");const l=o.getAxesPermutation([i],r.shape.length);let p=r;null!=l&&(p=Da({inputs:{x:r},backend:a,attrs:{perm:l}}));const u=o.getInnerMostAxes(1,r.shape.length)[0];if(u!==p.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${p.shape.length-1} but got axis=${u}`);const h=D(p.dtype,"int32"),f=e.makeZerosTypedArray(e.sizeFromShape(p.shape),h),m=a.data.get(p.dataId).values,k=p.shape[p.shape.length-1],g=c?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=g(e,t);if(0===t)f[n]=d?0:m[n];else{const a=g(e,t-1);f[n]=d?m[a]+f[a]:m[n]+f[a]}}const I=a.makeTensorInfo(p.shape,h,f);if(null!=l){const e=Da({inputs:{x:I},backend:a,attrs:{perm:o.getUndoAxesPermutation(l)}});return a.disposeIntermediateTensorInfo(I),a.disposeIntermediateTensorInfo(p),e}return I}};const gr={kernelName:Ee,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o,binaryOutput:i}=a;if(1===s.shape.length){const e=On(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,e)}if(2===s.shape.length){const e=Vn(n.bufferSync(s),n.bufferSync(r),o,i);return n.makeTensorInfo(e.shape,r.dtype,e.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${s.shape.length}.`)}};const Ir={kernelName:ze,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{blockSize:o,dataFormat:i}=s;e.assert("NHWC"===i,(()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`));const d=r.shape[0],c=r.shape[1],l=r.shape[2],p=r.shape[3],u=c*o,h=l*o,f=p/(o*o),m=a.data.get(r.dataId).values,k=new Float32Array(d*u*h*f);let g=0;for(let e=0;e<d;++e)for(let t=0;t<u;++t){const n=Math.floor(t/o),a=t%o;for(let t=0;t<h;++t){const s=Math.floor(t/o),r=(a*o+t%o)*f;for(let t=0;t<f;++t){const a=t+r+p*(s+l*(n+c*e));k[g++]=m[a]}}}return a.makeTensorInfo([d,u,h,f],r.dtype,k)}};function br(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,filter:i}=n,{strides:d,pad:c,dilations:l,dimRoundingMode:p}=s;bn([r,i],"depthwiseConv2DNative");const u=e.computeStrides(r.shape),h=e.computeStrides(i.shape);let f=l;null==f&&(f=[1,1]),e.assert(o.eitherStridesOrDilationsAreOne(d,f),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${d} and dilations '${f}'`));const m=o.computeConv2DInfo(r.shape,i.shape,d,f,c,p,!0),{filterHeight:k,filterWidth:g,dilationHeight:I,dilationWidth:b,padInfo:y}=m,N=y.left,x=y.top,T=m.outChannels/m.inChannels,S=new O(m.outShape,r.dtype),v=a.data.get(r.dataId).values,F=a.data.get(i.dataId).values,M=S.values;for(let e=0;e<m.batchSize;++e){const t=e*u[0],n=e*S.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*S.strides[1],s=e*m.strideHeight-x;for(let e=0;e<k;++e){const n=s+e*I;if(n<0||n>=m.inHeight)continue;const r=e*h[0],o=t+n*u[1];for(let e=0;e<m.outWidth;++e){const t=a+e*S.strides[2],n=e*m.strideWidth-N;for(let e=0;e<g;++e){const a=n+e*b;if(a<0||a>=m.inWidth)continue;const s=r+e*h[1],i=o+a*m.inChannels;let d=t,c=s;for(let e=0;e<m.inChannels;++e){const t=v[i+e];for(let e=0;e<T;++e)M[d+e]+=t*F[c+e];d+=T,c+=T}}}}}}return a.makeTensorInfo(S.shape,S.dtype,S.values)}const yr={kernelName:We,backendName:"cpu",kernelFunc:br};const Nr={kernelName:He,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,dy:r}=t,{strides:i,dilations:d,pad:c,dimRoundingMode:l,filterShape:p}=a;bn([s,r],"depthwiseConv2dNativeBackpropFilter");const u=o.computeConv2DInfo(s.shape,p,i,d,c,l,!0),{strideHeight:h,strideWidth:f,filterHeight:m,filterWidth:k}=u,g=new O(u.filterShape,"float32"),I=u.padInfo.left,b=u.padInfo.top,y=u.outChannels/u.inChannels,N=n.data.get(s.dataId).values,x=new O(s.shape,s.dtype,N),T=n.data.get(r.dataId).values,S=new O(r.shape,r.dtype,T);for(let e=0;e<m;++e){const t=Math.max(0,Math.ceil((b-e)/h)),n=Math.min(u.outHeight,(u.inHeight+b-e)/h);for(let a=0;a<k;++a){const s=Math.max(0,Math.ceil((I-a)/f)),r=Math.min(u.outWidth,(u.inWidth+I-a)/f);for(let o=0;o<u.outChannels;++o){const i=Math.trunc(o/y),d=o%y;let c=0;for(let d=0;d<u.batchSize;++d)for(let l=t;l<n;++l){const t=e+l*h-b;for(let e=s;e<r;++e){const n=a+e*f-I;c+=x.get(d,t,n,i)*S.get(d,l,e,o)}}g.set(c,e,a,i,d)}}}return n.makeTensorInfo(g.shape,g.dtype,g.values)}};const xr={kernelName:Ce,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{dy:r,filter:i}=n,{strides:d,dilations:c,pad:l,dimRoundingMode:p,inputShape:u}=s;bn([r,i],"depthwiseConv2DNativeBackpropInput");const h=e.computeStrides(r.shape),f=e.computeStrides(i.shape),m=o.computeConv2DInfo(u,i.shape,d,c,l,p,!0),k=new O(m.inShape,"float32"),g=k.values,[I,b,y]=k.strides,N=a.data.get(r.dataId).values,[x,T,S]=h,v=a.data.get(i.dataId).values,[F,M,A]=f,{batchSize:w,filterHeight:D,filterWidth:E,inChannels:z,inHeight:W,inWidth:H,outChannels:C,outHeight:P,outWidth:R,strideHeight:$,strideWidth:V}=m,G=D-1-m.padInfo.top,B=E-1-m.padInfo.left,q=C/z;for(let e=0;e<w;++e)for(let t=0;t<z;++t)for(let n=0;n<W;++n){const a=n-G,s=Math.max(0,Math.ceil(a/$)),r=Math.min(P,(D+a)/$);for(let o=0;o<H;++o){const i=o-B,d=Math.max(0,Math.ceil(i/V)),c=Math.min(R,(E+i)/V);let l=0;for(let n=s;n<r;++n){const s=n*$-a;for(let a=d;a<c;++a){const r=x*e+T*n+S*a,o=F*(D-1-s)+M*(E-1-(a*V-i))+A*t;for(let e=0;e<q;++e){l+=N[r+(t*q+e)]*v[o+e]}}}g[I*e+b*n+y*o+t]=l}}return a.makeTensorInfo(k.shape,k.dtype,k.values)}};const Tr={kernelName:Pe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{x:s}=n,r=e.sizeFromShape(s.shape),o=a.data.get(s.dataId).values,d=i([r,r],s.dtype),c=d.values;for(let e=0;e<o.length;e++)c[e*r+e]=o[e];const l=[...s.shape,...s.shape];return a.makeTensorInfo(l,d.dtype,d.values)}},Sr={kernelName:Re,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:r}=t,{strides:i,pad:d,dilations:c}=a,l=n,p=l.data.get(s.dataId).values,u=s.shape.length,h=l.data.get(r.dataId).values,f=r.shape.length,{batchSize:m,inHeight:k,inWidth:g,inChannels:I,outHeight:b,outWidth:y,padInfo:N,strideHeight:x,strideWidth:T,filterHeight:S,filterWidth:v,dilationHeight:F,dilationWidth:M,outShape:A}=o.computeDilation2DInfo(s.shape,r.shape,i,d,"NHWC",c),w=e.sizeFromShape(A),D=A.length,E=e.getArrayFromDType(s.dtype,w);for(let t=0;t<m;++t)for(let n=0;n<b;++n){const a=n*x-N.top;for(let o=0;o<y;++o){const i=o*T-N.left;for(let d=0;d<I;++d){let c=Number.MIN_SAFE_INTEGER;for(let n=0;n<S;++n){const o=a+n*F;if(o>=0&&o<k)for(let a=0;a<v;++a){const l=i+a*M;if(l>=0&&l<g){const i=e.locToIndex([t,o,l,d],u,e.computeStrides(s.shape)),m=e.locToIndex([n,a,d],f,e.computeStrides(r.shape)),k=p[i]+h[m];k>c&&(c=k)}}}E[e.locToIndex([t,n,o,d],D,e.computeStrides(A))]=c}}}return{dataId:l.write(e.toTypedArray(E,s.dtype),A,s.dtype),shape:A,dtype:s.dtype}}},vr={kernelName:$e,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:r,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(r.shape,p.data.get(r.dataId).values),{batchSize:f,inHeight:m,inWidth:k,inChannels:g,outHeight:I,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:S,dilationHeight:v,dilationWidth:F,outShape:M}=o.computeDilation2DInfo(s.shape,r.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,(()=>`Error in ${$e}, dy must have the same rank as output ${M.length}, but got ${i.rank}`));const A=e.toNestedArray(M,p.data.get(i.dataId).values),w=e.makeZerosNestedTypedArray(r.shape,r.dtype);for(let e=0;e<f;++e)for(let t=0;t<I;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let r=0;r<g;++r){let o=Number.MIN_SAFE_INTEGER,i=0,d=0;for(let t=0;t<T;++t){const a=n+t*v;if(a>=0&&a<m)for(let n=0;n<S;++n){const c=s+n*F;if(c>=0&&c<k){const s=u[e][a][c][r]+h[t][n][r];s>o&&(o=s,i=t,d=n)}}}w[i][d][r]+=A[e][t][a][r]}}}return{dataId:p.write(e.toTypedArray(w,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Fr={kernelName:Oe,backendName:"cpu",kernelFunc:({inputs:t,backend:n,attrs:a})=>{const{x:s,filter:r,dy:i}=t,{strides:d,pad:c,dilations:l}=a,p=n,u=e.toNestedArray(s.shape,p.data.get(s.dataId).values),h=e.toNestedArray(r.shape,p.data.get(r.dataId).values),{batchSize:f,inHeight:m,inWidth:k,inChannels:g,outHeight:I,outWidth:b,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:T,filterWidth:S,dilationHeight:v,dilationWidth:F,outShape:M}=o.computeDilation2DInfo(s.shape,r.shape,d,c,"NHWC",l);e.assert(i.rank===M.length,(()=>`Error in ${Oe}, dy must have the same rank as output ${M.length}, but got ${i.rank}`));const A=e.toNestedArray(M,p.data.get(i.dataId).values),w=e.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<f;++e)for(let t=0;t<I;++t){const n=t*N-y.top;for(let a=0;a<b;++a){const s=a*x-y.left;for(let r=0;r<g;++r){let o=Number.MIN_SAFE_INTEGER,i=n<0?0:n,d=s<0?0:s;for(let t=0;t<T;++t){const a=n+t*v;if(a>=0&&a<m)for(let n=0;n<S;++n){const c=s+n*F;if(c>=0&&c<k){const s=u[e][a][c][r]+h[t][n][r];s>o&&(o=s,i=a,d=c)}}}w[e][i][d][r]+=A[e][t][a][r]}}}return{dataId:p.write(e.toTypedArray(w,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function Mr(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s;let c;bn(r,"sum"),c="bool"===r.dtype?zn({inputs:{x:r},backend:a,attrs:{dtype:"int32"}}):An({inputs:{x:r},backend:a});const l=c.shape.length,p=e.parseAxisParam(i,c.shape),u=o.getAxesPermutation(p,l);let h=p,f=c;null!=u&&(f=Da({inputs:{x:c},backend:a,attrs:{perm:u}}),h=o.getInnerMostAxes(h.length,l)),o.assertAxesAreInnerMostDims("sum",h,f.shape.length);const[m,k]=o.computeOutAndReduceShapes(f.shape,h);let g=Mn(a,m,o.upcastType(f.dtype,"int32"));const I=e.sizeFromShape(k),b=a.data.get(g.dataId).values,y=a.data.get(f.dataId).values;for(let e=0;e<b.length;++e){const t=e*I;let n=0;for(let e=0;e<I;++e)n+=y[t+e];b[e]=n}if(d){const e=g;g=vs({inputs:{x:g},backend:a,attrs:{shape:o.expandShapeToKeepDim(g.shape,p)}}),a.disposeIntermediateTensorInfo(e)}return a.disposeIntermediateTensorInfo(c),null!=u&&a.disposeIntermediateTensorInfo(f),g}const Ar={kernelName:Ve,backendName:"cpu",kernelFunc:Mr};const wr={kernelName:Ge,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{equation:r}=s,i=n,{allDims:d,summedDims:c,idDims:l}=o.decodeEinsumEquation(r,i.length);o.checkEinsumDimSizes(d.length,l,i);const{path:p,steps:u}=o.getEinsumComputePath(c,l),h=u.length;let f=null,m=d.length;const k=[];for(let t=0;t<h;++t){for(const n of u[t]){const{permutationIndices:t,expandDims:s}=o.getEinsumPermutation(m,l[n]);let r;o.isIdentityPermutation(t)?r=i[n]:(r=Da({inputs:{x:i[n]},backend:a,attrs:{perm:t}}),k.push(r));const d=r.shape.slice();for(let e=0;e<s.length;++e)d.splice(s[e],0,1);e.arraysEqual(r.shape,d)||(r=vs({inputs:{x:r},backend:a,attrs:{shape:d}}),k.push(r)),null===f?f=r:(f=Ta({inputs:{a:r,b:f},backend:a}),k.push(f))}t<h-1&&(p[t]>=0&&(f=Mr({inputs:{x:f},backend:a,attrs:{axis:p[t]-(d.length-m),keepDims:!1}}),k.push(f)),m--)}for(const e of k)e!==f&&a.disposeIntermediateTensorInfo(e);return f}};const Dr={kernelName:Be,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{dy:s,y:r}=n;bn([s,r],"eluGrad");const o=new Float32Array(e.sizeFromShape(r.shape)),i=a.data.get(r.dataId).values,d=a.data.get(s.dataId).values;for(let e=0;e<i.length;++e){const t=i[e];o[e]=t>=1?d[e]:d[e]*(t+1)}return a.makeTensorInfo(r.shape,"float32",o)}},Er=o.ERF_P,zr=o.ERF_A1,Wr=o.ERF_A2,Hr=o.ERF_A3,Cr=o.ERF_A4,Pr=o.ERF_A5,Rr=Bn(qe,(e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+Er*n);return t*(1-((((Pr*a+Cr)*a+Hr)*a+Wr)*a+zr)*a*Math.exp(-n*n))})),$r={kernelName:qe,backendName:"cpu",kernelFunc:Rr};function Or(t){const{inputs:n,backend:a,attrs:s}=t,{input:r}=n,{dim:o}=s,i=r.shape.length,d=r.shape.slice();let c=o;return o<0&&(e.assert(-(i+1)<=o,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),c=i+o+1),d.splice(c,0,1),vs({inputs:{x:r},backend:a,attrs:{shape:d}})}const Vr={kernelName:Le,backendName:"cpu",kernelFunc:Or},Gr=Hn(_e,Sn(((e,t)=>e/t))),Br={kernelName:_e,backendName:"cpu",kernelFunc:Gr};function qr(t,n,a){const s=t.shape,r=s[0],i=s[1],d=a.data.get(t.dataId),c=d.complexTensorInfos.real,l=d.complexTensorInfos.imag,p=[r,i],u=e.sizeFromShape(p),h=e.getTypedArrayFromDType("float32",u),f=e.getTypedArrayFromDType("float32",u);for(let e=0;e<r;e++){const t=Ba({inputs:{x:c},backend:a,attrs:{begin:[e,0],size:[1,i]}}),s=Ba({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,i]}}),r=vn({inputs:{real:t,imag:s},backend:a}),{real:d,imag:p}=Lr(r,n,a),u=o.mergeRealAndImagArrays(d,p);for(let t=0;t<i;t++){const n=o.getComplexWithIndex(u,t);h[e*i+t]=n.real,f[e*i+t]=n.imag}a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(r)}const m=a.makeTensorInfo(p,"float32",h),k=a.makeTensorInfo(p,"float32",f),g=vn({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}function Lr(t,n,a){const s=e.sizeFromShape(t.shape),r=a.data.get(t.dataId),i=a.data.get(r.complexTensorInfos.real.dataId).values,d=a.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((c=s)&c-1)){const r=_r(i,d,s,n,a),o=[t.shape[0],t.shape[1]];if(n){const t=a.makeTensorInfo(o,"float32",r.real),n=a.makeTensorInfo(o,"float32",r.imag),i=a.makeTensorInfo([],"float32",e.createScalarValue(s,"float32")),d=An({inputs:{x:i},backend:a}),c=Br.kernelFunc({inputs:{a:t,b:i},backend:a}),l=Br.kernelFunc({inputs:{a:n,b:d},backend:a}),p=a.data.get(c.dataId).values,u=a.data.get(l.dataId).values;return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(c),a.disposeIntermediateTensorInfo(l),{real:p,imag:u}}return r}{const e=function(e,t,n){const a=new Float32Array(2*t);for(let s=0;s<t;s++){let r=0,i=0;for(let a=0;a<t;a++){const d=o.exponent(s*a,t,n),c=o.getComplexWithIndex(e,a);r+=c.real*d.real-c.imag*d.imag,i+=c.real*d.imag+c.imag*d.real}n&&(r/=t,i/=t),o.assignToTypedArray(a,r,i,s)}return a}(o.mergeRealAndImagArrays(i,d),s,n);return o.splitRealAndImagArrays(e)}var c}function _r(e,t,n,a,s){if(1===n)return{real:e,imag:t};const r=o.mergeRealAndImagArrays(e,t),i=n/2,d=o.complexWithEvenIndex(r),c=d.real,l=d.imag,p=[c.length],u=s.makeTensorInfo(p,"float32",c),h=s.makeTensorInfo(p,"float32",l),f=vn({inputs:{real:u,imag:h},backend:s}),m=o.complexWithOddIndex(r),k=m.real,g=m.imag,I=[k.length],b=s.makeTensorInfo(I,"float32",k),y=s.makeTensorInfo(I,"float32",g),N=vn({inputs:{real:b,imag:y},backend:s}),x=_r(c,l,i,a,s),T=x.real,S=x.imag,v=[T.length],F=s.makeTensorInfo(v,"float32",T),M=s.makeTensorInfo(v,"float32",S),A=vn({inputs:{real:F,imag:M},backend:s}),w=_r(k,g,i,a,s),D=w.real,E=w.imag,z=[D.length],W=s.makeTensorInfo(z,"float32",D),H=s.makeTensorInfo(z,"float32",E),C=vn({inputs:{real:W,imag:H},backend:s}),P=o.exponents(n,a),R=[P.real.length],$=s.makeTensorInfo(R,"float32",P.real),O=s.makeTensorInfo(R,"float32",P.imag),V=vn({inputs:{real:$,imag:O},backend:s}),G=Ta({inputs:{a:V,b:C},backend:s}),B=Rn({inputs:{a:A,b:G},backend:s}),q=ss({inputs:{a:A,b:G},backend:s}),L=Dn({inputs:{input:B},backend:s}),_=Dn({inputs:{input:q},backend:s}),U=tr({inputs:{input:B},backend:s}),Z=tr({inputs:{input:q},backend:s}),K=ar({inputs:[L,_],backend:s,attrs:{axis:0}}),j=ar({inputs:[U,Z],backend:s,attrs:{axis:0}}),Y=s.data.get(K.dataId).values,J=s.data.get(j.dataId).values;return s.disposeIntermediateTensorInfo(u),s.disposeIntermediateTensorInfo(h),s.disposeIntermediateTensorInfo(f),s.disposeIntermediateTensorInfo(b),s.disposeIntermediateTensorInfo(y),s.disposeIntermediateTensorInfo(N),s.disposeIntermediateTensorInfo(F),s.disposeIntermediateTensorInfo(M),s.disposeIntermediateTensorInfo(A),s.disposeIntermediateTensorInfo(W),s.disposeIntermediateTensorInfo(H),s.disposeIntermediateTensorInfo(C),s.disposeIntermediateTensorInfo($),s.disposeIntermediateTensorInfo(O),s.disposeIntermediateTensorInfo(V),s.disposeIntermediateTensorInfo(G),s.disposeIntermediateTensorInfo(B),s.disposeIntermediateTensorInfo(q),s.disposeIntermediateTensorInfo(L),s.disposeIntermediateTensorInfo(U),s.disposeIntermediateTensorInfo(_),s.disposeIntermediateTensorInfo(Z),s.disposeIntermediateTensorInfo(K),s.disposeIntermediateTensorInfo(j),{real:Y,imag:J}}const Ur={kernelName:Ue,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,r=e.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=vs({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),d=qr(i,!1,a),c=vs({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}};function Zr(t){const{backend:n,attrs:a}=t,{shape:s,value:r,dtype:o}=a,i=o||e.inferDtype(r),d=e.getArrayFromDType(i,e.sizeFromShape(s));return function(e,t,n){e.fill(t)}(d,r),n.makeTensorInfo(s,i,d)}const Kr={kernelName:Ze,backendName:"cpu",kernelFunc:Zr};const jr={kernelName:Ke,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,r=a,o=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[i,d,c,l]=s.shape,p=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*c*d*l;for(let e=0;e<d;e++){const n=e*(c*l);for(let e=0;e<c;e++){const a=e*l;for(let s=0;s<l;s++){const r=Math.round(c-e-1),i=t+n+a+s;let d=p[i];if(r>=0&&r<c){d=p[t+n+r*l+s]}o[i]=d}}}}return{dataId:r.write(o,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Yr={kernelName:je,backendName:"cpu",kernelFunc:Hn(je,Sn(((e,t)=>Math.floor(e/t))),null,"int32")};const Jr={kernelName:Ye,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:f}=a;let m=rr({inputs:{x:s,filter:r},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(o){const e=m;if("NCHW"===l&&1===o.shape.length&&1!==o.shape[0]){const e=vs({inputs:{x:o},backend:n,attrs:{shape:[o.shape[0],1,1]}});m=Rn({inputs:{a:m,b:e},backend:n}),n.disposeIntermediateTensorInfo(e)}else m=Rn({inputs:{a:m,b:o},backend:n});n.disposeIntermediateTensorInfo(e)}if(h){const e=m;if("NCHW"===l&&"prelu"===h&&1===i.shape.length&&1!==i.shape[0]){const e=vs({inputs:{x:i},backend:n,attrs:{shape:[i.shape[0],1,1]}});m=Ss(n,m,h,e,f),n.disposeIntermediateTensorInfo(e)}else m=Ss(n,m,h,i,f);n.disposeIntermediateTensorInfo(e)}return m}};const Qr={kernelName:Je,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u,activation:h,leakyreluAlpha:f}=a;let m=br({inputs:{x:s,filter:r},backend:n,attrs:{strides:d,pad:c,dataFormat:l,dilations:p,dimRoundingMode:u}});if(o){const e=m;m=Rn({inputs:{a:m,b:o},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=Ss(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const Xr={kernelName:Qe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{params:s,indices:r}=n,i=e.sizeFromShape(s.shape),d=r.shape,c=d[d.length-1],[l,p,u,h]=o.prepareAndValidate(s,r);if(0===p)return a.makeTensorInfo(l,s.dtype,[]);const f=aa(a.data.get(r.dataId).values,a.bufferSync(s),s.dtype,p,c,u,h,s.shape,i);return a.makeTensorInfo(l,s.dtype,f.values)}};const eo={kernelName:Xe,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,indices:i}=n,{axis:d,batchDims:c}=s;bn([r,i],"gatherV2");const l=e.parseAxisParam(d,r.shape)[0],p=a.data.get(i.dataId).values,u=r.shape[l];for(let t=0;t<p.length;++t){const n=p[t];e.assert(n<=u-1&&n>=0,(()=>`GatherV2: the index value ${n} is not in [0, ${u-1}]`))}let h=c;null==c&&(h=0);const f=e.sizeFromShape(i.shape),m=o.segment_util.collectGatherOpShapeInfo(r,i,l,h),k=vs({inputs:{x:r},backend:a,attrs:{shape:[m.batchSize,m.outerSize,m.dimSize,m.sliceSize]}}),g=vs({inputs:{x:i},backend:a,attrs:{shape:[m.batchSize,f/m.batchSize]}}),I=[m.batchSize,m.outerSize,f/m.batchSize,m.sliceSize],b=a.bufferSync(g),y=sa(a.bufferSync(k),b,I);return a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(g),a.makeTensorInfo(m.outputShape,y.dtype,y.values)}};const to={kernelName:et,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{input:s}=n,r=e.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=vs({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),d=qr(i,!0,a),c=vs({inputs:{x:d},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),c}},no={kernelName:tt,backendName:"cpu",kernelFunc:Bn(tt,(e=>Number.isFinite(e)?1:0),"bool")},ao={kernelName:nt,backendName:"cpu",kernelFunc:Bn(nt,(e=>Math.abs(e)===1/0?1:0),"bool")},so={kernelName:at,backendName:"cpu",kernelFunc:Bn(at,(e=>Number.isNaN(e)?1:0),"bool")};const ro={kernelName:st,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:r}=n,o=ha(a,s,r);return t.makeTensorInfo([o.length],"float32",o)}},oo={kernelName:rt,backendName:"cpu",kernelFunc:Bn(rt,(e=>Math.log1p(e)))},io={kernelName:ot,backendName:"cpu",kernelFunc:Hn(ot,Sn(((e,t)=>e&&t)),null,"bool")},co={kernelName:it,backendName:"cpu",kernelFunc:Bn(it,(e=>e?0:1),"bool")},lo={kernelName:dt,backendName:"cpu",kernelFunc:Hn(dt,Sn(((e,t)=>e||t)),null,"bool")};const po={kernelName:ct,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{depthRadius:o,bias:i,alpha:d,beta:c}=s;bn(r,"LRN");const l=r.shape[3],p=l-1,u=a.data.get(r.dataId).values,h=e.sizeFromShape(r.shape),f=new Float32Array(h);function m(e){const t=e%l;let n=e-t+Math.max(0,t-o);const a=e-t+Math.min(t+o,p);let s=0;for(;n<=a;n++){const e=u[n];s+=e*e}return s}for(let e=0;e<h;e++){const t=m(e),n=u[e]*Math.pow(i+d*t,-c);f[e]=n}return a.makeTensorInfo(r.shape,r.dtype,f)}};const uo={kernelName:lt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,y:o,dy:i}=n,{depthRadius:d,bias:c,alpha:l,beta:p}=s;bn(i,"LRNGrad");const u=e.sizeFromShape(i.shape),h=i.shape[3],f=a.data.get(i.dataId).values,m=a.data.get(r.dataId).values,k=a.data.get(o.dataId).values,g=new Float32Array(u),I=u;for(let e=0;e<I;e++){const t=e%h,n=e-t+Math.max(0,t-d),a=e-t+Math.min(h,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(m[e],2);s=l*s+c;for(let t=n;t<a;t++){let n=-2*l*p*m[t]*k[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=f[e],g[t]+=n}}return a.makeTensorInfo(i.shape,r.dtype,g)}};function ho(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{reductionIndices:i,keepDims:d}=s,c=a;let l=r.shape;const p=l.length,u=e.parseAxisParam(i,l);let h=u;const f=o.getAxesPermutation(h,p);let m=c.data.get(r.dataId).values;if(null!=f){const e=new Array(p);for(let t=0;t<e.length;t++)e[t]=l[f[t]];m=wa(m,l,r.dtype,f,e),h=o.getInnerMostAxes(h.length,p),l=e}bn(r,"max"),o.assertAxesAreInnerMostDims("max",h,p);const[k,g]=o.computeOutAndReduceShapes(l,h),I=ka(m,e.sizeFromShape(g),k,r.dtype),b=c.write(I,k,r.dtype);let y=k;if(d){y=o.expandShapeToKeepDim(k,u)}return{dataId:b,shape:y,dtype:r.dtype}}const fo={kernelName:pt,backendName:"cpu",kernelFunc:ho};const mo={kernelName:ut,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n;bn(r,"maxPool");const{filterSize:i,strides:d,pad:c,dimRoundingMode:l}=s;e.assert(o.eitherStridesOrDilationsAreOne(d,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${d} and dilations '1'`));const p=o.computePool2DInfo(r.shape,i,d,1,c,l);let u;if(1===p.filterWidth&&1===p.filterHeight&&e.arraysEqual(p.inShape,p.outShape))u=An({inputs:{x:r},backend:a});else{const t=a.data.get(r.dataId).values,n=e.computeStrides(r.shape),s=Bs(t,r.shape,r.dtype,n,p,"max");u=a.makeTensorInfo(p.outShape,r.dtype,s.values)}return u}};const ko={kernelName:ht,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{filterSize:i,strides:d,pad:c,dimRoundingMode:l,dataFormat:p}=s;bn(r,"maxPool3d");const u=o.computePool3DInfo(r.shape,i,d,1,c,l,p),h=Ls(a.data.get(r.dataId).values,r.shape,r.dtype,e.computeStrides(r.shape),u,"max");return a.makeTensorInfo(h.shape,"float32",h.values)}};const go={kernelName:ft,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:r}=t,{filterSize:d,strides:c,pad:l,dimRoundingMode:p}=a;bn([s,r],"maxPool3DGrad");const u=o.computePool3DInfo(r.shape,d,c,1,l,p),h=function(e,t){const n=i(t.outShape,"int32"),a=t.strideDepth,s=t.strideHeight,r=t.strideWidth,o=t.dilationDepth,d=t.dilationHeight,c=t.dilationWidth,l=t.effectiveFilterDepth,p=t.effectiveFilterHeight,u=t.effectiveFilterWidth,h=t.padInfo.front,f=t.padInfo.top,m=t.padInfo.left;for(let i=0;i<t.batchSize;++i)for(let k=0;k<t.inChannels;++k)for(let g=0;g<t.outDepth;++g){const I=g*a-h;let b=I;for(;b<0;)b+=o;const y=Math.min(t.inDepth,l+I);for(let a=0;a<t.outHeight;++a){const l=a*s-f;let h=l;for(;h<0;)h+=d;const N=Math.min(t.inHeight,p+l);for(let s=0;s<t.outWidth;++s){const f=s*r-m;let x=f;for(;x<0;)x+=c;const T=Math.min(t.inWidth,u+f);let S=Number.NEGATIVE_INFINITY,v=-1;for(let t=b;t<y;t+=o){const n=t-I;for(let a=h;a<N;a+=d){const s=a-l;for(let r=x;r<T;r+=c){const o=r-f,d=e.get(i,t,a,r,k);d>=S&&(S=d,v=n*p*u+s*p+o)}}}n.set(v,i,g,a,s,k)}}}return n}(n.bufferSync(r),u),f=u.strideDepth,m=u.strideHeight,k=u.strideWidth,g=u.dilationDepth,I=u.dilationHeight,b=u.dilationWidth,y=u.effectiveFilterDepth,N=u.effectiveFilterHeight,x=u.effectiveFilterWidth,T=y-1-u.padInfo.front,S=x-1-u.padInfo.left,v=N-1-u.padInfo.top,F=i(r.shape,"float32"),M=n.bufferSync(s);for(let e=0;e<u.batchSize;++e)for(let t=0;t<u.inChannels;++t)for(let n=0;n<u.inDepth;++n)for(let a=0;a<u.inHeight;++a)for(let s=0;s<u.inWidth;++s){const r=n-T,o=a-v,i=s-S;let d=0;for(let n=0;n<y;n+=g){const a=(r+n)/f;if(!(a<0||a>=u.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=I){const r=(o+s)/m;if(!(r<0||r>=u.outHeight||Math.floor(r)!==r))for(let o=0;o<x;o+=b){const c=(i+o)/k;if(c<0||c>=u.outWidth||Math.floor(c)!==c)continue;const l=y*N*x-1-h.get(e,a,r,c,t)===n*N*x+s*x+o?1:0;if(0===l)continue;d+=M.get(e,a,r,c,t)*l}}}F.set(d,e,n,a,s,t)}return n.makeTensorInfo(F.shape,F.dtype,F.values)}};const Io={kernelName:mt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{dy:s,input:r,output:d}=t,c=r;bn([r,d],"maxPoolGrad");const{filterSize:l,strides:p,pad:u,dimRoundingMode:h}=a,f=o.computePool2DInfo(c.shape,l,p,1,u,h),m=n.data.get(c.dataId).values,k=i(f.outShape,c.dtype,qs(m,c.shape,c.dtype,f).values),g=f.strideHeight,I=f.strideWidth,b=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,x=f.effectiveFilterWidth,T=x-1-f.padInfo.left,S=N-1-f.padInfo.top,v=i(c.shape,"float32"),F=n.data.get(s.dataId).values,M=i(s.shape,"float32",F);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-S,r=a-T;let o=0;for(let n=0;n<N;n+=b){const a=(s+n)/g;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(r+s)/I;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const d=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;if(0===d)continue;o+=M.get(e,a,i,t)*d}}v.set(o,e,n,a,t)}return n.makeTensorInfo(v.shape,v.dtype,v.values)}};const bo={kernelName:kt,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{x:s}=t,{filterSize:r,strides:i,pad:d,includeBatchInIndex:c}=n,l=a;bn(s,"MaxPoolWithArgmax");const p=l.data.get(s.dataId).values,u=o.computePool2DInfo(s.shape,r,i,[1,1],d),[h,f]=function(t,n,a,s,r){const o=Bs(t,0,a,e.computeStrides(n),r,"max"),i=qs(t,n,a,r,!0,s);return[o.values,i.values]}(p,s.shape,s.dtype,c,u),m=l.write(h,u.outShape,s.dtype),k=l.write(f,u.outShape,s.dtype);return[{dataId:m,shape:u.outShape,dtype:s.dtype},{dataId:k,shape:u.outShape,dtype:"int32"}]}};const yo={kernelName:gt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s,c=e.parseAxisParam(i,r.shape),l=o.computeOutAndReduceShapes(r.shape,c)[1],p=e.sizeFromShape(l),u=[],h=a.makeTensorInfo([],"float32",new Float32Array([p]));u.push(h);const f=zn({inputs:{x:r},backend:a,attrs:{dtype:"float32"}});u.push(f);const m=Gr({inputs:{a:f,b:h},backend:a});u.push(m);const k=Mr({inputs:{x:m},backend:a,attrs:{axis:i,keepDims:d}});return u.forEach((e=>a.disposeIntermediateTensorInfo(e))),k}};const No={kernelName:It,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{axis:i,keepDims:d}=s;bn(r,"min");const c=e.parseAxisParam(i,r.shape);let l=c;const p=o.getAxesPermutation(l,r.shape.length);let u=r;null!=p&&(u=Da({inputs:{x:r},backend:a,attrs:{perm:p}}),l=o.getInnerMostAxes(l.length,r.shape.length)),o.assertAxesAreInnerMostDims("min",l,u.shape.length);const[h,f]=o.computeOutAndReduceShapes(u.shape,l),m=e.sizeFromShape(f),k=e.makeZerosTypedArray(e.sizeFromShape(h),u.dtype),g=a.data.get(u.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];(Number.isNaN(a)||a<n)&&(n=a)}k[e]=n}null!=p&&a.disposeIntermediateTensorInfo(u);const I=a.makeTensorInfo(h,u.dtype,k);if(d){const e=vs({inputs:{x:I},backend:a,attrs:{shape:o.expandShapeToKeepDim(h,c)}});return a.disposeIntermediateTensorInfo(I),e}return I}};const xo={kernelName:bt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{paddings:o,mode:i}=s;bn(r,"mirrorPad");const d=o.map(((e,t)=>e[0]+r.shape[t]+e[1])),c=o.map((e=>e[0])),l=o.map(((e,t)=>e[0]+r.shape[t])),p="reflect"===i?0:1,u=a.data.get(r.dataId).values,h=r.shape.length,f=e.computeStrides(r.shape),m=e.sizeFromShape(d),k=d.length,g=e.computeStrides(d),I=e.getTypedArrayFromDType(r.dtype,m);for(let t=0;t<m;t++){let n=e.indexToLoc(t,k,g);for(let e=0;e<k;e++)n[e]<c[e]?n[e]=2*c[e]-n[e]-p:n[e]>=l[e]&&(n[e]=2*(l[e]-1)-n[e]+p);n=n.map(((e,t)=>e-c[t]));const a=e.locToIndex(n,h,f);I[t]=u[a]}return{dataId:a.write(I,d,r.dtype),shape:d,dtype:r.dtype}}},To={kernelName:yt,backendName:"cpu",kernelFunc:Hn(yt,Sn(((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t})))};function So(t){const{inputs:n,backend:a,attrs:s}=t,{logits:r}=n,{dim:i}=s,d=r.shape.length;let c=i;if(-1===c&&(c=d-1),c!==d-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${d} and dim was ${c}`);const l=e.parseAxisParam([c],r.shape),p=ho({inputs:{x:r},backend:a,attrs:{reductionIndices:l,keepDims:!1}}),u=o.expandShapeToKeepDim(p.shape,l),h=vs({inputs:{x:p},backend:a,attrs:{shape:u}}),f=ss({inputs:{a:r,b:h},backend:a}),m=Jn({inputs:{x:f},backend:a}),k=Mr({inputs:{x:m},backend:a,attrs:{axis:l,keepDims:!1}}),g=vs({inputs:{x:k},backend:a,attrs:{shape:u}}),I=Gr({inputs:{a:m,b:g},backend:a});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(g),I}const vo={kernelName:Nt,backendName:"cpu",kernelFunc:So};const Fo={kernelName:xt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{logits:r}=n,{numSamples:o,seed:i,normalized:d}=s;bn(r,"multinomial");const c=d?r:So({inputs:{logits:r},backend:a,attrs:{dim:-1}}),l=c.shape[0],p=c.shape[1],u=a.data.get(c.dataId).values,h=[l,o],f=e.makeZerosTypedArray(e.sizeFromShape(h),"int32");for(let e=0;e<l;++e){const t=e*p,n=new Float32Array(p-1);n[0]=u[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+u[t+e];const a=In.alea(i.toString()),s=e*o;for(let e=0;e<o;++e){const t=a();f[s+e]=n.length;for(let a=0;a<n.length;a++)if(t<n[a]){f[s+e]=a;break}}}return d||a.disposeIntermediateTensorInfo(c),a.makeTensorInfo(h,"int32",f)}},Mo=t.nonMaxSuppressionV3Impl;const Ao={kernelName:Tt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:r}=t,{maxOutputSize:o,iouThreshold:i,scoreThreshold:d}=a;bn(s,"NonMaxSuppression");const c=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,{selectedIndices:p}=Mo(c,l,o,i,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},wo=t.nonMaxSuppressionV4Impl;const Do={kernelName:St,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:r}=t,{maxOutputSize:o,iouThreshold:i,scoreThreshold:d,padToMaxOutputSize:c}=a;bn(s,"NonMaxSuppressionPadded");const l=n.data.get(s.dataId).values,p=n.data.get(r.dataId).values,{selectedIndices:u,validOutputs:h}=wo(l,p,o,i,d,c);return[n.makeTensorInfo([u.length],"int32",new Int32Array(u)),n.makeTensorInfo([],"int32",new Int32Array([h]))]}},Eo=t.nonMaxSuppressionV5Impl;const zo={kernelName:vt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:r}=t,{maxOutputSize:o,iouThreshold:i,scoreThreshold:d,softNmsSigma:c}=a;bn(s,"NonMaxSuppressionWithScore");const l=n.data.get(s.dataId).values,p=n.data.get(r.dataId).values,u=o,h=i,f=d,m=c,{selectedIndices:k,selectedScores:g}=Eo(l,p,u,h,f,m);return[n.makeTensorInfo([k.length],"int32",new Int32Array(k)),n.makeTensorInfo([g.length],"float32",new Float32Array(g))]}};const Wo={kernelName:Ft,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{indices:r}=n,{depth:o,onValue:i,offValue:d}=s;bn(r,"oneHot");const c=e.sizeFromShape(r.shape),l=new Float32Array(c*o);l.fill(d);const p=a.data.get(r.dataId).values;for(let e=0;e<c;++e)p[e]>=0&&p[e]<o&&(l[e*o+p[e]]=i);return a.makeTensorInfo([...r.shape,o],"int32",l)}};function Ho(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=Dn({inputs:{input:a},backend:n}),t=Ho({inputs:{x:e},backend:n}),s=tr({inputs:{input:a},backend:n}),r=Ho({inputs:{x:s},backend:n}),o=vn({inputs:{real:t,imag:r},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),o}return Zr({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const Co={kernelName:Mt,backendName:"cpu",kernelFunc:Ho};const Po={kernelName:At,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=Dn({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),r=tr({inputs:{input:s},backend:a}),o=Ho({inputs:{x:r},backend:a}),i=vn({inputs:{real:n,imag:o},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(o),i}return Zr({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function Ro(t){const{inputs:n,backend:a,attrs:s}=t,{axis:r}=s;if(1===n.length)return Or({inputs:{input:n[0]},backend:a,attrs:{dim:r}});const o=n[0].shape,i=n[0].dtype;n.forEach((t=>{e.assertShapesMatch(o,t.shape,"All tensors passed to stack must have matching shapes"),e.assert(i===t.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const d=[],c=ar({inputs:n.map((e=>{const t=Or({inputs:{input:e},backend:a,attrs:{dim:r}});return d.push(t),t})),backend:a,attrs:{axis:r}});return d.forEach((e=>a.disposeIntermediateTensorInfo(e))),c}const $o={kernelName:wt,backendName:"cpu",kernelFunc:Ro};const Oo={kernelName:Dt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{paddings:o,constantValue:i}=s;bn(r,"pad");const d=o.map(((e,t)=>e[0]+r.shape[t]+e[1])),c=o.map((e=>e[0])),l=a.data.get(r.dataId).values,p=e.sizeFromShape(r.shape),u=r.shape.length,h=e.computeStrides(r.shape),f=e.sizeFromShape(d),m=d.length,k=e.computeStrides(d),g=e.getTypedArrayFromDType(r.dtype,f);0!==i&&g.fill(i);for(let t=0;t<p;t++){const n=e.indexToLoc(t,u,h).map(((e,t)=>e+c[t]));g[e.locToIndex(n,m,k)]=l[t]}return{dataId:a.write(g,d,r.dtype),shape:d,dtype:r.dtype}}},Vo={kernelName:Et,backendName:"cpu",kernelFunc:Hn(Et,Sn(((e,t)=>Math.pow(e,t))))};const Go={kernelName:zt,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:r,step:o}=n,i=Ha(a,s,o,r);return t.makeTensorInfo([i.length],r,i)}},Bo={kernelName:Wt,backendName:"cpu",kernelFunc:Bn(Wt,(e=>1/e))};const qo={kernelName:Ht,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:r}=n,{alignCorners:o,halfPixelCenters:i,size:d}=s;bn(r,"resizeBilinear");const c=e.computeStrides(r.shape),[l,p]=d,[u,h,f,m]=r.shape,k=a.data.get(r.dataId).values,g=new Float32Array(e.sizeFromShape([u,l,p,m])),I=[o&&l>1?h-1:h,o&&p>1?f-1:f],b=[o&&l>1?l-1:l,o&&p>1?p-1:p];let y=0;const N=I[0]/b[0],x=I[1]/b[1];for(let e=0;e<u;e++)for(let t=0;t<l;t++){let n;n=i?N*(t+.5)-.5:N*t;const a=Math.max(0,Math.floor(n)),s=n-a,r=Math.min(h-1,Math.ceil(n)),o=e*c[0]+a*c[1],d=e*c[0]+r*c[1];for(let e=0;e<p;e++){let t;t=i?x*(e+.5)-.5:x*e;const n=Math.max(0,Math.floor(t)),a=t-n,r=Math.min(f-1,Math.ceil(t)),l=o+n*c[2],p=d+n*c[2],u=o+r*c[2],h=d+r*c[2];for(let e=0;e<m;e++){const t=k[l+e],n=k[p+e],r=t+(k[u+e]-t)*a,o=r+(n+(k[h+e]-n)*a-r)*s;g[y++]=o}}}return a.makeTensorInfo([u,l,p,m],"float32",g)}};const Lo={kernelName:Ct,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:r,dy:o}=n,{alignCorners:i}=s;bn([o,r],"resizeBilinearGrad");const d=e.computeStrides(r.shape),[c,l,p,u]=r.shape,[,h,f]=o.shape,m=new Float32Array(c*l*p*u),k=[i&&h>1?l-1:l,i&&f>1?p-1:p],g=[i&&h>1?h-1:h,i&&f>1?f-1:f],I=k[0]/g[0],b=k[1]/g[1],y=a.data.get(o.dataId).values;let N=0;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<h;e++){const n=e*I,a=Math.floor(n),s=Math.min(Math.ceil(n),l-1),r=t+a*d[1],o=t+s*d[1],i=n-a,c=1-i;for(let e=0;e<f;e++){const t=e*b,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,l=1-s,h=r+n*d[2],f=r+a*d[2],k=o+n*d[2],g=o+a*d[2],I=c*l,x=c*s,T=i*l,S=i*s;for(let e=0;e<u;e++){const t=y[N++];m[h+e]+=t*I,m[f+e]+=t*x,m[k+e]+=t*T,m[g+e]+=t*S}}}}return a.makeTensorInfo([c,p,l,u],"float32",m)}};const _o={kernelName:Pt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:r}=n,{alignCorners:o,halfPixelCenters:i,size:d}=s;bn(r,"resizeNearestNeighbor");const c=e.computeStrides(r.shape),[l,p]=d,[u,h,f,m]=r.shape,k=a.data.get(r.dataId).values,g=new Float32Array(u*l*p*m),I=[o&&l>1?h-1:h,o&&p>1?f-1:f],b=[o&&l>1?l-1:l,o&&p>1?p-1:p],y=I[0]/b[0],N=I[1]/b[1];let x=0;for(let e=0;e<u;e++){const t=e*c[0];for(let e=0;e<l;e++){const n=i?y*(e+.5):y*e;let a=Math.min(h-1,o?Math.round(n):Math.floor(n));i&&(a=Math.max(0,a));const s=t+a*c[1];for(let e=0;e<p;e++){const t=i?N*(e+.5):N*e;let n=Math.min(f-1,o?Math.round(t):Math.floor(t));i&&(n=Math.max(0,n));const a=s+n*c[2];for(let e=0;e<m;e++){const t=k[a+e];g[x++]=t}}}}return a.makeTensorInfo([u,l,p,m],r.dtype,g)}};const Uo={kernelName:Rt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{images:r,dy:o}=n,{alignCorners:i}=s;bn([o,r],"resizeNearestNeighborGrad");const d=e.computeStrides(r.shape),c=e.computeStrides(o.shape),[l,p,u,h]=r.shape,[,f,m]=o.shape,k=new Float32Array(l*p*u*h),g=a.data.get(o.dataId).values,I=[i&&f>1?p-1:p,i&&m>1?u-1:u],b=[i&&f>1?f-1:f,i&&m>1?m-1:m],y=I[0]/b[0],N=I[1]/b[1],x=1/y,T=1/N,S=2*Math.ceil(x)+2,v=2*Math.ceil(T)+2;for(let e=0;e<l;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*x),s=Math.floor(a-S/2);for(let a=0;a<u;a++){const r=n+a*d[2],o=Math.floor(a*T),l=Math.floor(o-v/2);for(let n=0;n<h;n++){let o=0;for(let r=0;r<S;r++){const d=r+s;if(d<0||d>=f)continue;const h=t+d*c[1],k=d*y;if(e===Math.min(p-1,i?Math.round(k):Math.floor(k)))for(let e=0;e<v;e++){const t=e+l;if(t<0||t>=m)continue;const s=h+t*c[2],r=t*N;a===Math.min(u-1,i?Math.round(r):Math.floor(r))&&(o+=g[s+n])}}k[r+n]=o}}}}return a.makeTensorInfo(r.shape,r.dtype,k)}};const Zo={kernelName:$t,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{dims:o}=s;bn(r,"reverse");const i=r.shape.length,d=e.parseAxisParam(o,r.shape);if(0===i)return An({inputs:{x:r},backend:a});const c=new O(r.shape,r.dtype),l=a.bufferSync(r);for(let e=0;e<c.size;e++){const t=c.indexToLoc(e),n=t.slice();d.forEach((e=>n[e]=r.shape[e]-1-n[e])),c.set(l.get(...n),...t)}return a.makeTensorInfo(c.shape,c.dtype,c.values)}},Ko={kernelName:Ot,backendName:"cpu",kernelFunc:({inputs:t,attrs:n,backend:a})=>{const{image:s}=t,{radians:r,fillValue:i,center:d}=n,c=a,l=e.getTypedArrayFromDType(s.dtype,e.sizeFromShape(s.shape)),[p,u,h,f]=s.shape,[m,k]=o.getImageCenter(d,u,h),g=Math.sin(r),I=Math.cos(r),b=c.data.get(s.dataId).values;for(let e=0;e<p;e++){const t=e*h*u*f;for(let e=0;e<u;e++){const n=e*(h*f);for(let a=0;a<h;a++){const s=a*f;for(let r=0;r<f;r++){const o=[p,e,a,r],d=o[2],c=o[1];let y=(d-m)*I-(c-k)*g,N=(d-m)*g+(c-k)*I;y=Math.round(y+m),N=Math.round(N+k);let x=i;if("number"!=typeof i&&(x=3===r?255:i[r]),y>=0&&y<h&&N>=0&&N<u){x=b[t+N*(h*f)+y*f+r]}l[t+n+s+r]=x}}}}return{dataId:c.write(l,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},jo={kernelName:Vt,backendName:"cpu",kernelFunc:Bn(Vt,(e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1}))};const Yo={kernelName:Gt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{indices:s,updates:r}=t,{shape:i}=a,{sliceRank:d,numUpdates:c,sliceSize:l,strides:p,outputSize:u}=o.calculateShapes(r,s,i),h=Ra(n.bufferSync(s),n.bufferSync(r),i,u,l,c,d,p,0,!0);return n.makeTensorInfo(i,h.dtype,h.values)}};function Jo(e,t){let n=0,a=e.length,s=0;for(;n<a;)s=Math.floor((n+a)/2),e[s]<t?n=s+1:a=s;return a}function Qo(e,t){let n=0,a=e.length,s=0;for(;n<a;)s=Math.floor((n+a)/2),e[s]<=t?n=s+1:a=s;return a}const Xo={kernelName:Bt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{sortedSequence:r,values:o}=n,{side:i}=s,d=function(t,n,a,s,r,o){const i=e.getArrayFromDType("int32",a*r);for(let e=0;e<a;++e){const a=t.slice(e*s,(e+1)*s),d=e*r;for(let e=0;e<r;++e)i[d+e]="left"===o?Jo(a,n[e+d]):Qo(a,n[e+d])}return i}(a.data.get(r.dataId).values,a.data.get(o.dataId).values,r.shape[0],r.shape[1],o.shape[1],i);return a.makeTensorInfo(o.shape,"int32",d)}};const ei={kernelName:qt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a}=t,{condition:s,t:r,e:o}=n;bn([s,r,o],"select");const i=s.shape.length,d=a.data.get(s.dataId).values,c=a.data.get(r.dataId).values,l=a.data.get(o.dataId).values,p=D(r.dtype,o.dtype),u=e.makeZerosTypedArray(e.sizeFromShape(r.shape),p);let h=0;const f=0===i||i>1||1===r.shape.length?1:e.sizeFromShape(r.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<f;t++)1===d[e]?u[h++]=c[e]:u[h++]=l[e];return a.makeTensorInfo(r.shape,p,u)}},ti=o.SELU_SCALEALPHA,ni=o.SELU_SCALE,ai={kernelName:Lt,backendName:"cpu",kernelFunc:Bn(Lt,(e=>e>=0?ni*e:ti*(Math.exp(e)-1)))},si={kernelName:_t,backendName:"cpu",kernelFunc:Bn(_t,(e=>e<0?-1:e>0?1:0))},ri={kernelName:Ut,backendName:"cpu",kernelFunc:Bn(Ut,(e=>Math.sin(e)))},oi={kernelName:Zt,backendName:"cpu",kernelFunc:Bn(Zt,(e=>Math.sinh(e)))},ii=Math.log(1.1920928955078125e-7)+2,di={kernelName:Kt,backendName:"cpu",kernelFunc:Bn(Kt,(e=>{const t=e>-ii,n=e<ii,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s}))};const ci={kernelName:jt,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{blockShape:i,paddings:d}=s;bn([r],"spaceToBatchND");const c=e.sizeFromShape(i),l=[[0,0]];l.push(...d);for(let e=1+i.length;e<r.shape.length;++e)l.push([0,0]);const p=Oo.kernelFunc({inputs:{x:r},backend:a,attrs:{paddings:l,constantValue:0}}),u=o.getReshaped(p.shape,i,c,!1),h=o.getPermuted(u.length,i.length,!1),f=o.getReshapedPermuted(p.shape,i,c,!1),m=vs({inputs:{x:p},backend:a,attrs:{shape:u}}),k=Da({inputs:{x:m},backend:a,attrs:{perm:h}}),g=vs({inputs:{x:k},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}};const li={kernelName:Yt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:a,values:s,denseShape:r,defaultValue:o}=t;if(1!==r.shape.length)throw new Error(`Dense shape must be a vector, saw:\n        ${r.shape}`);if(2!==a.shape.length)throw new Error(`Indices must be a matrix, saw:\n        ${a.shape}`);if(1!==s.shape.length)throw new Error(`Values must be a vector, saw:\n        ${s.shape}`);if(0!==o.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${o.shape}`);const i=n.data.get(a.dataId).values,d=n.data.get(s.dataId).values,c=n.data.get(r.dataId).values,l=n.data.get(o.dataId).values[0],[p,u,h,f,m]=La(i,a.shape,a.dtype,d,s.dtype,c,l);return[n.makeTensorInfo(u,a.dtype,p),n.makeTensorInfo([u[0]],s.dtype,h),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],a.dtype,new Int32Array(m))]}};const pi={kernelName:Jt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:a,inputShape:s,newShape:r}=t;if(2!==a.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${a.shape}`);if(1!==s.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Target shape should be a vector but received shape ${r.shape}`);const o=Array.from(n.data.get(s.dataId).values),i=n.data.get(a.dataId).values,d=Array.from(n.data.get(r.dataId).values),[c,l,p]=_a(i,a.shape,a.dtype,o,d);return[n.makeTensorInfo(l,a.dtype,c),n.makeTensorInfo([p.length],r.dtype,new Int32Array(p))]}};const ui={kernelName:Qt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error(`Indices should be a vector but received shape\n          ${s.shape}`);if(1!==r.shape.length)throw new Error(`Segment ids should be a vector but received shape\n          ${r.shape}`);if(s.shape[0]!==r.shape[0])throw new Error("segmentIds and indices should have same size.");const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,d=n.data.get(r.dataId).values,[c,l]=Ua(o,a.shape,a.dtype,i,d,!0);return n.makeTensorInfo(l,a.dtype,c)}};const hi={kernelName:Xt,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error(`Indices should be a vector but received shape\n         ${s.shape}`);if(1!==r.shape.length)throw new Error(`Segment ids should be a vector but received shape\n         ${r.shape}`);if(s.shape[0]!==r.shape[0])throw new Error("segmentIds and indices should have same size.");const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,d=n.data.get(r.dataId).values,[c,l]=Ua(o,a.shape,a.dtype,i,d);return n.makeTensorInfo(l,a.dtype,c)}};const fi={kernelName:en,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{sparseIndices:r,sparseValues:i,defaultValue:d}=n,{outputShape:c}=s,{sliceRank:l,numUpdates:p,sliceSize:u,strides:h,outputSize:f}=o.calculateShapes(i,r,c),m=!1,k=a.bufferSync(r);let g;switch(i.dtype){case"bool":g=Ra(k,a.bufferSync(i),c,f,u,p,l,h,Boolean(a.data.get(d.dataId).values[0]),m);break;case"float32":g=Ra(k,a.bufferSync(i),c,f,u,p,l,h,a.data.get(d.dataId).values[0],m);break;case"int32":g=Ra(k,a.bufferSync(i),c,f,u,p,l,h,a.data.get(d.dataId).values[0],m);break;case"string":g=Ra(k,a.bufferSync(i),c,f,u,p,l,h,e.decodeString(a.data.get(d.dataId).values[0]),m);break;default:throw new Error(`Unsupported type ${i.dtype}`)}return a.makeTensorInfo(c,g.dtype,g.values)}};const mi={kernelName:tn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{numOrSizeSplits:i,axis:d}=s,c=e.parseAxisParam(d,r.shape)[0],l=o.prepareSplitSize(r,i,c),p=new Array(r.shape.length).fill(0),u=r.shape.slice();return l.map((e=>{const t=[...u];t[c]=e;const n=Ba({inputs:{x:r},backend:a,attrs:{begin:p,size:t}});return p[c]+=e,n}))}},ki={kernelName:nn,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,a=t;bn(n,"square");const s=a.data.get(n.dataId).values,r=new Float32Array(s.length);for(let e=0;e<s.length;++e){const t=s[e];r[e]=t*t}return{dataId:a.write(r,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},gi={kernelName:an,backendName:"cpu",kernelFunc:Bn(an,((e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha}))};const Ii={kernelName:sn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r}=n,{begin:o,end:i,strides:d,beginMask:c,endMask:l,ellipsisMask:p,newAxisMask:u,shrinkAxisMask:h}=s;bn(r,"stridedSlice");const{finalShapeSparse:f,finalShape:m,isIdentity:k,sliceDim0:g,isSimpleSlice:I,begin:b,end:y,strides:N}=H.sliceInfo(r.shape,o,i,d,c,l,p,u,h);let x;if(k)x=vs({inputs:{x:r},backend:a,attrs:{shape:m}});else if(g||I){e.assert(r.shape.length>=1,(()=>`Input must have rank at least 1, got: ${r.shape.length}`));const t=H.computeOutShape(b,y,N),n=Ba({inputs:{x:r},backend:a,attrs:{begin:b,size:t}});x=vs({inputs:{x:n},backend:a,attrs:{shape:m}}),a.disposeIntermediateTensorInfo(n)}else{const e=Ja(f,a.bufferSync(r),N,b);x=a.makeTensorInfo(m,e.dtype,e.values)}return x}};const bi={kernelName:rn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{separator:s,nGramWidths:r,leftPad:o,rightPad:i,padWidth:d,preserveShortSequences:c}=a,{data:l,dataSplits:p}=t,u=n.data.get(l.dataId).values,h=n.data.get(p.dataId).values,[f,m]=Xa(u,h,s,r,o,i,d,c);return[n.makeTensorInfo([f.length],"string",f),n.makeTensorInfo(p.shape,"int32",m)]}};const yi={kernelName:on,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{skipEmpty:s}=a,{input:r,delimiter:o}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(1!==r.shape.length)throw new Error(`Input must be a vector, got shape: ${r.shape}`);if(0!==o.shape.length)throw new Error(`Delimiter must be a scalar, got shape: ${o.shape}`);const i=n.data.get(r.dataId).values,d=n.data.get(o.dataId).values[0],[c,l,p]=ts(i,d,s),u=l.length;return[n.makeTensorInfo([u,2],"int32",c),n.makeTensorInfo([u],"string",l),n.makeTensorInfo([2],"int32",new Int32Array(p))]}};const Ni={kernelName:dn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{numBuckets:s}=a,{input:r}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(s<=0)throw new Error("Number of buckets must be at least 1");const o=ns(n.data.get(r.dataId).values,s);return n.makeTensorInfo(r.shape,"int32",o)}},xi={kernelName:cn,backendName:"cpu",kernelFunc:Bn(cn,(e=>Math.tan(e)))},Ti=Bn(ln,(e=>Math.tanh(e)));const Si={kernelName:hn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,attrs:a,backend:s}=t,{image:r,transforms:o}=n,{interpolation:i,fillMode:d,fillValue:c,outputShape:l}=a,[p,u,h,f]=r.shape,[m,k]=null!=l?l:[u,h],g=[p,m,k,f],I=e.computeStrides(r.shape),b=I[0],y=I[1],N=I[2],x=e.getTypedArrayFromDType(r.dtype,e.sizeFromShape(g));x.fill(c);const T=s.data.get(r.dataId).values,S=s.data.get(o.dataId).values;for(let e=0;e<p;++e){const t=1===o.shape[0]?S:S.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let a=0;a<k;++a)for(let s=0;s<f;++s){let r;const o=t[6]*a+t[7]*n+1;if(0===o)continue;const l=(t[0]*a+t[1]*n+t[2])/o,p=(t[3]*a+t[4]*n+t[5])/o,f=vi(l,h,d),m=vi(p,u,d);switch(i){case"nearest":r=Mi(T,u,h,b,y,N,e,m,f,s,c);break;case"bilinear":r=Ai(T,u,h,b,y,N,e,m,f,s,c);break;default:throw new Error(`Error in Transform: Expect 'nearest' or 'bilinear', but got ${i}`)}x[e*b+n*y+a*N+s]=r}return s.makeTensorInfo(g,r.dtype,x)}return{dataId:s.write(x,g,r.dtype),shape:r.shape,dtype:r.dtype}}};function vi(t,n,a){switch(a){case"reflect":return function(t,n){let a=t;if(a<0)if(n<=1)a=0;else{const e=2*n;a<e&&(a=e*Math.trunc(-a/e)+a),a=a<-n?a+e:-a-1}else if(a>n-1)if(n<=1)a=0;else{const e=2*n;a-=e*Math.trunc(a/e),a>=n&&(a=e-a-1)}return e.clamp(0,a,n-1)}(t,n);case"wrap":return function(t,n){let a=t;if(a<0)if(n<=1)a=0;else{const e=n-1;a+=n*(Math.trunc(-a/e)+1)}else if(a>n-1)if(n<=1)a=0;else{const e=n-1;a-=n*Math.trunc(a/e)}return e.clamp(0,a,n-1)}(t,n);case"nearest":return function(t,n){return e.clamp(0,t,n-1)}(t,n);default:return function(e,t){return e}(t)}}function Fi(e,t,n,a,s,r,o,i,d,c,l){return 0<=i&&i<t&&0<=d&&d<n?e[o*a+i*s+d*r+c]:l}function Mi(e,t,n,a,s,r,o,i,d,c,l){return Fi(e,t,n,a,s,r,o,Math.round(i),Math.round(d),c,l)}function Ai(e,t,n,a,s,r,o,i,d,c,l){const p=Math.floor(i),u=Math.floor(d),h=p+1,f=u+1;return(h-i)*((f-d)*Fi(e,t,n,a,s,r,o,p,u,c,l)+(d-u)*Fi(e,t,n,a,s,r,o,p,f,c,l))+(i-p)*((f-d)*Fi(e,t,n,a,s,r,o,h,u,c,l)+(d-u)*Fi(e,t,n,a,s,r,o,h,f,c,l))}const wi=[ws,Tn,Ds,Es,$n,zs,Ws,Hs,Cs,Ps,Rs,$s,Os,Vs,Gs,_s,Us,Zs,Ks,As,js,Ys,Js,Qs,Wn,_n,Xs,Fn,er,sr,or,ir,dr,cr,lr,pr,ur,hr,fr,mr,kr,gr,Ir,yr,Nr,xr,Tr,Sr,vr,Fr,wr,fs,Dr,jn,$r,Qn,Vr,ea,Ur,Kr,jr,na,Yr,Jr,Qr,Xr,eo,oa,da,wn,to,nr,no,ao,so,ks,la,ua,ro,ma,oo,io,co,lo,po,uo,fo,Ia,mo,ko,go,Io,bo,yo,No,ya,xo,To,Fo,Sa,Fa,Ao,Do,zo,Aa,Wo,Po,$o,Oo,Vo,bs,Wa,Go,En,Br,Bo,Ns,Ts,Fs,qo,Lo,_o,Uo,Zo,Ko,jo,Pa,Yo,Xo,ei,ai,Va,si,ri,oi,qa,vo,di,ci,li,pi,ui,hi,fi,mi,Ka,ki,Ya,gi,Ii,bi,yi,Ni,rs,Ar,xi,{kernelName:ln,backendName:"cpu",kernelFunc:Ti},{kernelName:pn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{reps:r}=a;bn(s,"tile");const o=os(n.bufferSync(s),r);return n.makeTensorInfo(o.shape,o.dtype,o.values)}},{kernelName:un,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{k:r,sorted:o}=a;bn(s,"topk");const i=n.data.get(s.dataId).values,[d,c]=cs(i,s.shape,s.dtype,r,o);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(c.shape,c.dtype,c.values)]}},Si,Ea,{kernelName:fn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:a}=e,{axis:s}=n,{x:r}=t;bn(r,"unique");const o=a.data.get(r.dataId).values,{outputValues:i,outputShape:d,indices:c}=ls(o,s,r.shape,r.dtype);return[a.makeTensorInfo(d,r.dtype,i),a.makeTensorInfo([c.length],"int32",c)]}},{kernelName:mn,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:r}=a;r<0&&(r+=s.shape.length);const o=s.shape.length,i=s.shape[r],d=new Array(o-1);let c=0;for(let e=0;e<o;e++)e!==r&&(d[c++]=s.shape[e]);const l=new Array(o).fill(0),p=s.shape.slice();p[r]=1;const u=new Array(i);for(let e=0;e<u.length;e++){l[r]=e;const t=Ba({inputs:{x:s},backend:n,attrs:{begin:l,size:p}});u[e]=vs({inputs:{x:t},backend:n,attrs:{shape:d}}),n.disposeIntermediateTensorInfo(t)}return u}},{kernelName:kn,backendName:"cpu",kernelFunc:function(t){const{inputs:n,backend:a,attrs:s}=t,{x:r,segmentIds:o}=n,{numSegments:i}=s;bn(r,"unsortedSegmentSum");const d=[],c=[],l=r.shape.length-o.shape.length;let p=o;for(let e=0;e<l;++e){const t=Or({inputs:{input:p},backend:a,attrs:{dim:e+1}});p=t,c.push(t)}for(let t=0;t<i;++t){const n=e.createScalarValue(t,"int32"),s=a.makeTensorInfo([],"int32",n),o=Kn({inputs:{a:s,b:p},backend:a}),i=zn({inputs:{x:o},backend:a,attrs:{dtype:"float32"}}),l=Ta({inputs:{a:i,b:r},backend:a}),u=Mr({inputs:{x:l},backend:a,attrs:{axis:0,keepDims:!1}});d.push(u),c.push(s),c.push(o),c.push(i),c.push(l),c.push(u)}const u=Ro({inputs:d,backend:a,attrs:{axis:0}});return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),u}},Co];for(const e of wi)gn(e);export{Nn as MathBackendCPU,ps as shared,us as version_cpu};
//# sourceMappingURL=tf-backend-cpu.fesm.min.js.map
