/**
 * @license
 * Copyright 2022 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports,require("@tensorflow/tfjs-core"),require("seedrandom")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core","seedrandom"],t):t((e="undefined"!=typeof globalThis?globalThis:e||self).tf=e.tf||{},e.tf,e.seedrandom)}(this,(function(e,t,n){"use strict";function a(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(n){if("default"!==n){var a=Object.getOwnPropertyDescriptor(e,n);Object.defineProperty(t,n,a.get?a:{enumerable:!0,get:function(){return e[n]}})}})),t.default=e,t}var s=a(n);function r(e,n){Array.isArray(e)||(e=[e]),e.forEach((e=>{null!=e&&t.util.assert("complex64"!==e.dtype,(()=>`${n} does not support complex64 tensors in the CPU backend.`))}))}const o=t.kernel_impls.whereImpl;class i extends t.KernelBackend{constructor(){super(),this.blockSize=48,this.firstUse=!0,this.data=new t.DataStorage(this,t.engine())}nextDataId(){return i.nextDataId++}write(e,n,a){this.firstUse&&(this.firstUse=!1,t.env().get("IS_NODE")&&t.backend_util.warn("\n============================\nHi, looks like you are running TensorFlow.js in Node.js. To speed things up dramatically, install our node backend, visit https://github.com/tensorflow/tfjs-node for more details. \n============================"));const s={id:this.nextDataId()};return this.data.set(s,{values:e,dtype:a,refCount:1}),s}makeTensorInfo(e,n,a){let s;if("string"===n&&null!=a&&a.length>0&&t.util.isString(a[0])){const r=a.map((e=>t.util.encodeString(e)));s=this.write(r,e,n)}else s=this.write(a,e,n);return{dataId:s,shape:e,dtype:n}}refCount(e){if(this.data.has(e)){return this.data.get(e).refCount}return 0}incRef(e){this.data.get(e).refCount++}decRef(e){if(this.data.has(e)){this.data.get(e).refCount--}}move(e,t,n,a,s){this.data.set(e,{values:t,dtype:a,refCount:s})}numDataIds(){return this.data.numDataIds()}async read(e){return this.readSync(e)}readSync(e){const{dtype:n,complexTensorInfos:a}=this.data.get(e);if("complex64"===n){const e=this.readSync(a.real.dataId),n=this.readSync(a.imag.dataId);return t.backend_util.mergeRealAndImagArrays(e,n)}return this.data.get(e).values}bufferSync(e){const n=this.readSync(e.dataId);if("string"===e.dtype)try{const a=n.map((e=>t.util.decodeString(e)));return t.buffer(e.shape,e.dtype,a)}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8")}return t.buffer(e.shape,e.dtype,n)}makeOutput(e,n,a){return t.engine().makeTensorFromTensorInfo(this.makeTensorInfo(n,a,e),this)}disposeData(e,t=!1){if(this.data.has(e)){if(this.data.get(e).refCount--,!t&&this.data.get(e).refCount>0)return!1;const{complexTensorInfos:n}=this.data.get(e);null!=n&&(this.disposeData(n.real.dataId,!0),this.disposeData(n.imag.dataId,!0)),this.data.delete(e)}return!0}disposeIntermediateTensorInfo(e){this.disposeData(e.dataId)}async time(e){const n=t.util.now();e();return{kernelMs:t.util.now()-n}}memory(){return{unreliable:!0,reasons:["The reported memory is an upper bound. Due to automatic garbage collection, the true allocated memory may be less."]}}where(e){r([e],"where");const t=this.readSync(e.dataId);return o(e.shape,t)}dispose(){}floatPrecision(){return 32}epsilon(){return super.epsilon()}}function l(e){const t=new Float32Array(e.length);for(let n=0;n<e.length;++n)t[n]=Math.abs(e[n]);return t}i.nextDataId=0;const d={kernelName:t.Abs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,a=e.backend;r(n,"abs");let s=new Float32Array(t.util.sizeFromShape(n.shape));return s=l(a.data.get(n.dataId).values),a.makeOutput(s,n.shape,n.dtype)}};function u(e){return(n,a,s,r,o)=>{const i=t.backend_util.assertAndGetBroadcastShape(n,a),l=i.length,d=t.util.computeStrides(i),u=t.util.sizeFromShape(i),c=t.util.getTypedArrayFromDType(o,u),p=n.length,h=a.length,f=t.util.computeStrides(n),m=t.util.computeStrides(a),k=t.backend_util.getBroadcastDims(n,i),g=t.backend_util.getBroadcastDims(a,i);if(k.length+g.length===0)for(let t=0;t<c.length;++t)c[t]=e(s[t%s.length],r[t%r.length]);else for(let n=0;n<c.length;++n){const a=t.util.indexToLoc(n,l,d),o=a.slice(-p);k.forEach((e=>o[e]=0));const i=t.util.locToIndex(o,p,f),u=a.slice(-h);g.forEach((e=>u[e]=0));const b=t.util.locToIndex(u,h,m);c[n]=e(s[i],r[b])}return[c,i]}}function c(e){const{inputs:t,backend:n}=e,{real:a,imag:s}=t,r=n.data.get(a.dataId).values,o=n.data.get(s.dataId).values,i=n.makeTensorInfo(a.shape,"complex64");return n.data.get(i.dataId).complexTensorInfos={real:n.makeTensorInfo(a.shape,"float32",r),imag:n.makeTensorInfo(s.shape,"float32",o)},i}const p={kernelName:t.Complex,backendName:"cpu",kernelFunc:c};function h(e,n,a="float32"){if("complex64"===a){return c({inputs:{real:h(e,n,"float32"),imag:h(e,n,"float32")},backend:e})}const s=t.util.makeZerosTypedArray(t.util.sizeFromShape(n),a);return e.makeTensorInfo(n,a,s)}function f(e){const{inputs:t,backend:n}=e,{x:a}=t;return n.incRef(a.dataId),{dataId:a.dataId,shape:a.shape,dtype:a.dtype}}const m={kernelName:t.Identity,backendName:"cpu",kernelFunc:f};function k(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.real,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const g={kernelName:t.Real,backendName:"cpu",kernelFunc:k};function b(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{dtype:o}=s;if("complex64"===o){if("complex64"===r.dtype)return f({inputs:{x:r},backend:a});const e=h(a,r.shape,r.dtype),t=b({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),n=c({inputs:{real:t,imag:e},backend:a});return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(t),n}if("complex64"===r.dtype){const e=k({inputs:{input:r},backend:a}),t=b({inputs:{x:e},backend:a,attrs:{dtype:o}});return a.disposeIntermediateTensorInfo(e),t}if(!t.util.hasEncodingLoss(r.dtype,o)){const e=f({inputs:{x:r},backend:a});return{dataId:e.dataId,shape:e.shape,dtype:o}}if("int32"===o){const e=a.data.get(r.dataId).values,t=Int32Array.from(e);return a.makeTensorInfo(r.shape,"int32",t)}if("bool"===o){const e=a.data.get(r.dataId).values,n=t.util.toTypedArray([0],r.dtype),[s,o]=u(((e,t)=>e!==t?1:0))(r.shape,[],e,n,"bool");return a.makeTensorInfo(o,"bool",s)}throw new Error(`Error in Cast: failed to cast ${r.dtype} to ${o}`)}const I={kernelName:t.Cast,backendName:"cpu",kernelFunc:b};function y(e,n,a,s){return null==a?({inputs:a,backend:o})=>{const{a:i,b:l}=a,d=o;r([i,l],e);const u=d.data.get(i.dataId).values,c=d.data.get(l.dataId).values,p="string"===i.dtype?t.backend_util.fromUint8ToStringArray(u):u,h="string"===i.dtype?t.backend_util.fromUint8ToStringArray(c):c,f=s||i.dtype,[m,k]=n(i.shape,l.shape,p,h,f);return d.makeTensorInfo(k,f,m)}:({inputs:e,backend:t})=>{const{a:r,b:o}=e,i=t;if("complex64"===r.dtype||"complex64"===o.dtype){const e=b({inputs:{x:r},backend:i,attrs:{dtype:"complex64"}}),t=i.data.get(e.dataId),n=t.complexTensorInfos.real,s=t.complexTensorInfos.imag,l=i.data.get(n.dataId).values,d=i.data.get(s.dataId).values,u=b({inputs:{x:o},backend:i,attrs:{dtype:"complex64"}}),p=i.data.get(u.dataId),h=p.complexTensorInfos.real,f=p.complexTensorInfos.imag,m=i.data.get(h.dataId).values,k=i.data.get(f.dataId).values,[g,I,y]=a(r.shape,o.shape,l,d,m,k),N=i.makeTensorInfo(y,"float32",g),x=i.makeTensorInfo(y,"float32",I),S=c({inputs:{real:N,imag:x},backend:i});return i.disposeIntermediateTensorInfo(e),i.disposeIntermediateTensorInfo(u),i.disposeIntermediateTensorInfo(N),i.disposeIntermediateTensorInfo(x),S}{const e=i.data.get(r.dataId).values,t=i.data.get(o.dataId).values,a=s||r.dtype,[l,d]=n(r.shape,o.shape,e,t,a);return i.makeTensorInfo(d,a,l)}}}function N(e){return(n,a,s,r,o,i)=>{const l=t.backend_util.assertAndGetBroadcastShape(n,a),d=t.util.sizeFromShape(l),u=l.length,c=t.util.computeStrides(l),p=t.util.getTypedArrayFromDType("float32",d),h=t.util.getTypedArrayFromDType("float32",d),f=t.backend_util.getBroadcastDims(n,l),m=t.backend_util.getBroadcastDims(a,l),k=t.backend_util.mergeRealAndImagArrays(s,r),g=t.backend_util.mergeRealAndImagArrays(o,i),b=n.length,I=t.util.computeStrides(n),y=a.length,N=t.util.computeStrides(a);if(f.length+m.length===0)for(let t=0;t<p.length;t++){const n=t%k.length,a=t%g.length,s=e(k[2*n],k[2*n+1],g[2*a],g[2*a+1]);p[t]=s.real,h[t]=s.imag}else for(let n=0;n<p.length;n++){const a=t.util.indexToLoc(n,u,c),s=a.slice(-b);f.forEach((e=>s[e]=0));const r=t.util.locToIndex(s,b,I),o=a.slice(-y);m.forEach((e=>o[e]=0));const i=t.util.locToIndex(o,y,N),l=e(k[2*r],k[2*r+1],g[2*i],g[2*i+1]);p[n]=l.real,h[n]=l.imag}return[p,h,l]}}const x=u(((e,t)=>e+t)),S=N(((e,t,n,a)=>({real:e+n,imag:t+a}))),T=y(t.Add,x,S),v={kernelName:t.Add,backendName:"cpu",kernelFunc:T};function F(e,n,a,s,r){const o=t.util.sizeFromShape(s),i=t.util.makeZerosTypedArray(r,a);for(let t=0;t<e.length;t++){const a=e[t];if(a<0)throw new Error("Input x must be non-negative!");a>=r||(i[a]+=o>0?n[t]:1)}return i}function M(e,n,a,s=!1){const r=e.shape[0],o=e.shape[1],i=t.buffer([r,a],n.dtype);for(let t=0;t<r;t++)for(let r=0;r<o;r++){const o=e.get(t,r);if(o<0)throw new Error("Input x must be non-negative!");o>=a||(s?i.set(1,t,o):n.size>0?i.set(i.get(t,o)+n.get(t,r),t,o):i.set(i.get(t,o)+1,t,o))}return i}function A(e){return(n,a,s)=>{const r=t.util.getTypedArrayFromDType(a,n.length);for(let t=0;t<n.length;++t)r[t]=e(n[t],s);return r}}function w(e,n,a){return({inputs:s,attrs:o,backend:i})=>{const{x:l}=s;if(r(l,e),"string"===l.dtype||"string"===a)throw new Error("unaryKernelFunc does not support string input/output");const d=i,u=d.data.get(l.dataId).values,c=t.util.sizeFromShape(l.shape),p=a||l.dtype,h=t.util.getArrayFromDType(p,c);for(let e=0;e<c;++e)h[e]=n(u[e],o);return d.makeTensorInfo(l.shape,p,h)}}function D(e,t,n){return({inputs:a,attrs:s,backend:o})=>{const{x:i}=a;if(r(i,e),"string"===i.dtype||"string"===n)throw new Error("unaryKernelFunc does not support string input/output");const l=o,d=l.data.get(i.dataId).values,u=n||i.dtype,c=t(d,u,s);return l.makeTensorInfo(i.shape,u,c)}}const _=A((e=>Math.ceil(e))),E=D(t.Ceil,_),z={kernelName:t.Ceil,backendName:"cpu",kernelFunc:E};function W(e,n,a,s){const r=t.util.getArrayFromDType(a,t.util.sizeFromShape(n));if(s&&"string"!==a){let n=0;e.forEach((e=>{const a=t.util.sizeFromShape(e.shape);r.set(e.vals,n),n+=a}))}else{let s=0;e.forEach((e=>{const o="string"===a?t.backend_util.fromUint8ToStringArray(e.vals):e.vals;let i=0;for(let t=0;t<e.shape[0];++t){const a=t*n[1]+s;for(let t=0;t<e.shape[1];++t)r[a+t]=o[i++]}s+=e.shape[1]}))}return r}const C=u(((e,t)=>e===t?1:0)),H=y(t.Equal,C,null,"bool"),P={kernelName:t.Equal,backendName:"cpu",kernelFunc:H},R=A((e=>Math.exp(e))),B=D(t.Exp,R,"float32"),O={kernelName:t.Exp,backendName:"cpu",kernelFunc:B},$=A((e=>Math.expm1(e))),G=D(t.Expm1,$),L={kernelName:t.Expm1,backendName:"cpu",kernelFunc:G},V=A((e=>Math.floor(e))),q=D(t.Floor,V),U={kernelName:t.Floor,backendName:"cpu",kernelFunc:q};function Z(e,n,a,s,r,o,i,l,d){const u=t.buffer([s,o],a);for(let t=0;t<s;t++){const a=[];let s=0;for(let n=0;n<r;n++){const o=e[t*r+n];s+=o*i[n],a.push(o)}if(s<0||s>=d/o)throw new Error(`Invalid indices: ${a} does not index into ${l}`);for(let e=0;e<o;e++)u.values[t*o+e]=n.get(...n.indexToLoc(s*o+e))}return u}function j(e,n,a){const s=t.buffer(a,e.dtype);for(let t=0;t<s.size;++t){const a=s.indexToLoc(t).slice(),r=a[0],o=a[2],i=n.locToIndex([r,o]);a[2]=n.values[i];const l=e.locToIndex(a);0<=l&&l<e.values.length&&(s.values[t]=e.values[l])}return s}const K=u(((e,t)=>e>t?1:0)),Y=y(t.Greater,K,null,"bool"),J={kernelName:t.Greater,backendName:"cpu",kernelFunc:Y},Q=u(((e,t)=>e>=t?1:0)),X=y(t.GreaterEqual,Q,null,"bool"),ee={kernelName:t.GreaterEqual,backendName:"cpu",kernelFunc:X},te=u(((e,t)=>e<t?1:0)),ne=y(t.Less,te,null,"bool"),ae={kernelName:t.Less,backendName:"cpu",kernelFunc:ne},se=u(((e,t)=>e<=t?1:0)),re=y(t.LessEqual,se,null,"bool"),oe={kernelName:t.LessEqual,backendName:"cpu",kernelFunc:re};function ie(e,n,a){const s=(n-e)/(a-1),r=t.util.makeZerosTypedArray(a,"float32");r[0]=e;for(let e=1;e<r.length;e++)r[e]=r[e-1]+s;return r}const le=A((e=>Math.log(e))),de=D(t.Log,le),ue={kernelName:t.Log,backendName:"cpu",kernelFunc:de};function ce(e,n,a,s){const r=t.util.getTypedArrayFromDType(s,t.util.sizeFromShape(a));for(let t=0;t<r.length;++t){const a=t*n;let s=e[a];for(let t=0;t<n;++t){const n=e[a+t];(Number.isNaN(n)||n>s)&&(s=n)}r[t]=s}return r}const pe=u(((e,t)=>Math.max(e,t))),he=y(t.Maximum,pe),fe={kernelName:t.Maximum,backendName:"cpu",kernelFunc:he},me=u(((e,t)=>Math.min(e,t))),ke=y(t.Minimum,me),ge={kernelName:t.Minimum,backendName:"cpu",kernelFunc:ke},be=u(((e,t)=>e*t)),Ie=N(((e,t,n,a)=>({real:e*n-t*a,imag:e*a+t*n}))),ye=y(t.Multiply,be,Ie),Ne={kernelName:t.Multiply,backendName:"cpu",kernelFunc:ye};function xe(e,n,a){const s=t.util.createScalarValue(-1,a);return be([],n,s,e,a)}const Se={kernelName:t.Neg,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{x:a}=t;r(a,"neg");const s=n.data.get(a.dataId).values,[o,i]=xe(s,a.shape,a.dtype);return n.makeTensorInfo(i,a.dtype,o)}},Te=u(((e,t)=>e!==t?1:0)),ve=y(t.NotEqual,Te,null,"bool"),Fe={kernelName:t.NotEqual,backendName:"cpu",kernelFunc:ve};function Me(e,n,a,s,r){const o=n.length,i=t.util.sizeFromShape(n),l=t.util.computeStrides(n),d=t.util.computeStrides(r),u=t.util.getTypedArrayFromDType(a,t.util.sizeFromShape(r));for(let n=0;n<i;++n){const a=t.util.indexToLoc(n,o,l),r=new Array(a.length);for(let e=0;e<r.length;e++)r[e]=a[s[e]];u[t.util.locToIndex(r,o,d)]=e[n]}return u}function Ae(e){const{inputs:t,attrs:n,backend:a}=e,{x:s}=t,{perm:o}=n;r(s,"transpose");const i=s.shape.length,l=new Array(i);for(let e=0;e<l.length;e++)l[e]=s.shape[o[e]];const d=Me(a.data.get(s.dataId).values,s.shape,s.dtype,o,l);return{dataId:a.write(d,l,s.dtype),shape:l,dtype:s.dtype}}const we={kernelName:t.Transpose,backendName:"cpu",kernelFunc:Ae};function De(e,n,a,s){const[r,o]=t.backend_util.computeOutAndReduceShapes(e,s),i=t.upcastType(n,"int32"),l=t.util.makeZerosTypedArray(t.util.sizeFromShape(r),i),d=t.util.sizeFromShape(o);for(let e=0;e<l.length;++e){const t=e*d;let n=1;for(let e=0;e<d;++e)n*=a[t+e];l[e]=n}return{outVals:l,outShape:r,outDtype:i}}const _e={kernelName:t.Prod,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,keepDims:l}=s;r(o,"prod");const d=o.shape.length,u=t.util.parseAxisParam(i,o.shape),c=t.backend_util.getAxesPermutation(u,d);let p=u,h=o;const f=[];null!=c&&(h=Ae({inputs:{x:o},backend:a,attrs:{perm:c}}),f.push(h),p=t.backend_util.getInnerMostAxes(p.length,d));const m=a.data.get(h.dataId).values,{outVals:k,outShape:g,outDtype:b}=De(h.shape,h.dtype,m,p);let I=g;return l&&(I=t.backend_util.expandShapeToKeepDim(g,u)),f.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(I,b,k)}};function Ee(e,n,a,s){if(e===n||e<n&&a<0||n<e&&a>1)return t.util.makeZerosTypedArray(0,s);const r=Math.abs(Math.ceil((n-e)/a)),o=t.util.makeZerosTypedArray(r,s);n<e&&1===a&&(a=-1),o[0]=e;for(let e=1;e<o.length;e++)o[e]=o[e-1]+a;return o}const ze=A((e=>1/Math.sqrt(e))),We=D(t.Rsqrt,ze),Ce={kernelName:t.Rsqrt,backendName:"cpu",kernelFunc:We};function He(e,n,a,s,r,o,i,l,d,u){const c=[s/r,r],p=e.values,h=n.values;if(0===s)return t.buffer(a,n.dtype);const f=t.buffer(c,n.dtype);"string"==typeof d||"number"==typeof d?f.values.fill(d):"boolean"==typeof d&&f.values.fill(+d);for(let e=0;e<o;e++){const t=[];let o=0;for(let n=0;n<i;n++){const a=p[e*i+n];t.push(a),o+=a*l[n]}if(o<0||o>=s/r)throw new Error(`Invalid indices: ${t} does not index into ${a}`);for(let t=0;t<r;t++)u?f.values[o*r+t]+=h[e*r+t]:f.values[o*r+t]=0===n.rank?h[0]:h[e*r+t]}return f}const Pe=A((e=>1/(1+Math.exp(-e)))),Re=w(t.Sigmoid,(e=>1/(1+Math.exp(-e)))),Be={kernelName:t.Sigmoid,backendName:"cpu",kernelFunc:Re};function Oe(e,n,a,s,r){const o=t.slice_util.isSliceContinous(s,n,a),i=t.util.sizeFromShape(a),l=t.util.computeStrides(s);if(o){const a=t.slice_util.computeFlatOffset(n,l);return"string"===r?e.slice(a,a+i):e.subarray(a,a+i)}const d="string"===r?t.backend_util.fromUint8ToStringArray(e):e,u=t.buffer(s,r,d),c=t.buffer(a,r);for(let e=0;e<c.size;++e){const t=c.indexToLoc(e),a=t.map(((e,t)=>e+n[t]));c.set(u.get(...a),...t)}return"string"===r?t.backend_util.fromStringArrayToUint8(c.values):c.values}function $e(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{begin:i,size:l}=s;r(o,"slice");const[d,u]=t.slice_util.parseSliceParams(o,i,l);t.slice_util.assertParamsValid(o,d,u);const c=Oe(a.data.get(o.dataId).values,d,u,o.shape,o.dtype);return a.makeTensorInfo(u,o.dtype,c)}const Ge={kernelName:t.Slice,backendName:"cpu",kernelFunc:$e};function Le(e,n,a,s,r,o,i){const l=n[0],d=o[0],u=new Array(d),c=new Array(l),p=n[1];if(0===d){if(0!==l)throw new Error(t.backend_util.getSparseFillEmptyRowsIndicesDenseShapeMismatch(l));return[t.util.getArrayFromDType(a,0),[0,p],t.util.getArrayFromDType(r,0),u,c]}let h=!0,f=0;const m=new Array(d).fill(0);for(let n=0;n<l;++n){const a=e[n*p];if(a<0)throw new Error(t.backend_util.getSparseFillEmptyRowsNegativeIndexErrorMessage(n,a));if(a>=d)throw new Error(t.backend_util.getSparseFillEmptyRowsOutOfRangeIndexErrorMessage(n,a,d));++m[a],h=h&&a>=f,f=a}let k=!0;for(let e=0;e<d;++e){const t=0===m[e];u[e]=t,k=k&&!t,m[e]=Math.max(m[e],1),e>0&&(m[e]+=m[e-1])}if(k&&h){const t=e,n=s;for(let e=0;e<l;++e)c[e]=e;return[t,[l,p],n,u,c]}{const n=m[d-1],o=t.util.getArrayFromDType(a,n*p),h=t.util.getArrayFromDType(r,n),f=new Array(d).fill(0);for(let t=0;t<l;++t){const n=e[t*p],a=f[n],r=(0===n?0:m[n-1])+a;f[n]++;for(let n=0;n<p;++n)o[r*p+n]=e[t*p+n];h[r]=s[t],c[t]=r}for(let e=0;e<d;++e){if(0===f[e]){const t=0===e?0:m[e-1];o[t*p+0]=e;for(let e=1;e<p;++e)o[t*p+e]=0;h[t]=i}}return[o,[n,p],h,u,c]}}function Ve(e,n,a,s,r){const o=t.util.sizeFromShape(s),i=n[0],l=r.length,d=[];let u=1,c=-1;for(let e=0;e<l;++e){const n=r[e];if(-1===n){if(-1!==c)throw new Error(t.backend_util.getSparseReshapeMultipleNegativeOneOutputDimErrorMessage(c,e));c=e,d.push(1)}else{if(n<0)throw new Error(t.backend_util.getSparseReshapeNegativeOutputDimErrorMessage(e,n));u*=n,d.push(n)}}if(-1!==c){if(u<=0)throw new Error(t.backend_util.getSparseReshapeEmptyTensorZeroOutputDimErrorMessage());const e=Math.trunc(o/u);if(u*e!==o)throw new Error(t.backend_util.getSparseReshapeInputOutputMultipleErrorMessage(s,d));d[c]=e}if(t.util.sizeFromShape(d)!==o)throw new Error(t.backend_util.getSparseReshapeInputOutputMismatchErrorMessage(s,d));const p=s.length,h=[];if(p>0){h[p-1]=1;for(let e=p-2;e>=0;--e)h[e]=h[e+1]*s[e+1]}const f=[];if(l>0){f[l-1]=1;for(let e=l-2;e>=0;--e)f[e]=f[e+1]*d[e+1]}const m=t.util.getArrayFromDType(a,i*l);for(let t=0;t<i;++t){let n=0;for(let a=0;a<p;++a)n+=e[t*p+a]*h[a];for(let e=0;e<l;++e)m[t*l+e]=Math.trunc(n/f[e]),n%=f[e]}return[m,[i,l],d]}function qe(e,n,a,s,r,o=!1,i=0){const l=s.length,d=[n[0],e.length/n[0]],u=d[1],c=l>0?r[l-1]+1:0;if(c<0)throw new Error(t.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());const p=n.slice();p[0]=c;const h=p.reduce(((e,t)=>e*t),1),f=t.util.getArrayFromDType(a,h);if(0===l)return c>0&&f.fill(i),[f,p];if(c<=0)throw new Error(t.backend_util.getSparseSegmentReductionNegativeSegmentIdsErrorMessage());let m=0,k=1,g=0,b=r[m];for(;;){let n=0;if(k<l){if(n=r[k],b===n){++k;continue}if(b>=n)throw new Error(t.backend_util.getSparseSegmentReductionNonIncreasingSegmentIdsErrorMessage())}if(b<0||b>=c)throw new Error(t.backend_util.getSparseSegmentReductionSegmentIdOutOfRangeErrorMessage(b,c));b>g&&f.fill(i,g*u,b*u);for(let n=m;n<k;++n){const a=s[n];if(a<0||a>=d[0])throw new Error(t.backend_util.getSparseSegmentReductionIndicesOutOfRangeErrorMessage(n,s[n],d[0]));for(let t=0;t<u;t++)f[b*u+t]+=e[a*u+t]}if(o)for(let e=0;e<u;e++)f[b*u+e]/=k-m;if(m=k,++k,g=b+1,b=n,k>l)break}return g<c&&f.fill(i,g*u,c*u),[f,p]}const Ue=A((e=>Math.sqrt(e))),Ze=w(t.Sqrt,(e=>Math.sqrt(e))),je={kernelName:t.Sqrt,backendName:"cpu",kernelFunc:Ze},Ke=u(((e,t)=>{const n=e-t;return n*n})),Ye=y(t.SquaredDifference,Ke),Je={kernelName:t.SquaredDifference,backendName:"cpu",kernelFunc:Ye};function Qe(e,n,a,s){const r=t.buffer(e,n.dtype);for(let e=0;e<r.size;e++){const t=r.indexToLoc(e),o=new Array(t.length);for(let e=0;e<o.length;e++)o[e]=t[e]*a[e]+s[e];r.set(n.get(...o),...t)}return r}class Xe{constructor(e,n,a,s,r,o){this.separator=t.util.encodeString(e),this.nGramWidths=n,this.leftPad=t.util.encodeString(a),this.rightPad=t.util.encodeString(s),this.padWidth=r,this.preserveShort=o}getPadWidth(e){return Math.min(this.padWidth<0?e-1:this.padWidth,e-1)}getNumNGrams(e,t){const n=this.getPadWidth(t);return Math.max(0,e+2*n-t+1)}createNGrams(e,t,n,a,s,r){for(let o=0;o<s;++o){const i=this.getPadWidth(r),l=Math.max(0,i-o),d=Math.max(0,i-(s-(o+1))),u=r-(l+d),c=t+(l>0?0:o-i);let p=0;p+=l*this.leftPad.length;for(let t=0;t<u;++t)p+=e[c+t].length;p+=d*this.rightPad.length;p+=(l+d+u-1)*this.separator.length,n[a+o]=new Uint8Array(p);const h=n[a+o];let f=0;const m=e=>e.forEach((e=>h[f++]=e));for(let e=0;e<l;++e)m(this.leftPad),m(this.separator);for(let t=0;t<u-1;++t)m(e[c+t]),m(this.separator);if(u>0){m(e[c+u-1]);for(let e=0;e<d;++e)m(this.separator),m(this.rightPad)}else{for(let e=0;e<d-1;++e)m(this.rightPad),m(this.separator);m(this.rightPad)}}}compute(e,n){const a=e.length,s=n.length;if(s>0){let e=n[0];if(0!==e)throw new Error(`First split value must be 0, got ${e}`);for(let t=1;t<s;++t){let s=n[t]>=e;if(s=s&&n[t]<=a,!s)throw new Error(`Invalid split value ${n[t]}, must be in [${e}, ${a}]`);e=n[t]}if(e!==a)throw new Error(`Last split value must be data size. Expected ${a}, got ${e}`)}const r=s-1,o=t.util.getArrayFromDType("int32",s);if(0===a||0===s){const e=new Array(a);for(let e=0;e<=r;++e)o[e]=0;return[e,o]}o[0]=0;for(let e=1;e<=r;++e){const t=n[e]-n[e-1];let a=0;this.nGramWidths.forEach((e=>{a+=this.getNumNGrams(t,e)})),this.preserveShort&&t>0&&0===a&&(a=1),o[e]=o[e-1]+a}const i=new Array(o[r]);for(let t=0;t<r;++t){const a=n[t];let s=o[t];if(this.nGramWidths.forEach((r=>{const o=n[t+1]-n[t],l=this.getNumNGrams(o,r);this.createNGrams(e,a,i,s,l,r),s+=l})),this.preserveShort&&s===o[t]){const r=n[t+1]-n[t];if(0===r)continue;const o=r+2*this.padWidth,l=1;this.createNGrams(e,a,i,s,l,o)}}return[i,o]}}function et(e,t,n,a,s,r,o,i){return new Xe(n,a,s,r,o,i).compute(e,t)}function tt(e,t,n,a){if(!e.length)return;if(0===t.length){for(let t=0;t<e.length;++t)a.push(e.subarray(t,t+1));return}if(1===t.length){const s=t[0];let r=e.indexOf(s);for(;-1!==r;){const t=e.subarray(0,r);n&&0===t.length||a.push(t),r=(e=e.subarray(r+1)).indexOf(s)}return void(n&&0===e.length||a.push(e))}let s=0;for(let r=0;r<e.length+1;r++)if(r===e.length||-1!==t.indexOf(e[r])){const t=e.subarray(s,r);n&&0===t.length||a.push(t),s=r+1}}function nt(e,n,a){const s=e.length,r=[];let o=0,i=0;const l=new Array(s);for(let t=0;t<s;++t){const s=r.length;tt(e[t],n,a,r);const d=r.length-s;l[t]=d,o+=d,i=Math.max(i,d)}const d=t.util.getArrayFromDType("int32",2*o),u=new Array(o),c=[s,i];let p=0;for(let e=0;e<s;++e)for(let t=0;t<l[e];++t)d[2*p]=e,d[2*p+1]=t,u[p]=r[p],++p;return[d,u,c]}function at(e,n){const a=t.util.getArrayFromDType("int32",e.length);for(let s=0;s<e.length;++s)a[s]=t.util.fingerPrint64(e[s]).modulo(n).getLowBitsUnsigned();return a}const st=u(((e,t)=>e-t)),rt=N(((e,t,n,a)=>({real:e-n,imag:t-a}))),ot=y(t.Sub,st,rt),it={kernelName:t.Sub,backendName:"cpu",kernelFunc:ot};function lt(e,n){const a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=e.shape[t]*n[t];const s=t.buffer(a,e.dtype);for(let t=0;t<s.values.length;++t){const n=s.indexToLoc(t),a=new Array(e.rank);for(let t=0;t<a.length;t++)a[t]=n[t]%e.shape[t];const r=e.locToIndex(a);s.values[t]=e.values[r]}return s}const dt=(e,t)=>{const n=t.value-e.value;return 0===n?e.index-t.index:n};function ut(e,n,a=0,s=e.length-1){for(;s>a;){if(s-a>600){const t=s-a+1,r=n-a+1,o=Math.log(t),i=.5*Math.exp(2*o/3),l=.5*Math.sqrt(o*i*(t-i)/t)*Math.sign(r-t/2);ut(e,n,Math.max(a,Math.floor(n-r*i/t+l)),Math.min(s,Math.floor(n+(t-r)*i/t+l)))}const r=e[n];let o=a,i=s;for(t.util.swap(e,a,n),dt(e[s],r)>0&&t.util.swap(e,a,s);o<i;){for(t.util.swap(e,o,i),o++,i--;dt(e[o],r)<0;)o+=1;for(;dt(e[i],r)>0;)i-=1}0===dt(e[a],r)?t.util.swap(e,a,i):(i+=1,t.util.swap(e,i,s)),i<=n&&(a=i+1),n<=i&&(s=i-1)}}function ct(e,n,a,s,r){const o=n[n.length-1],[i,l]=[e.length/o,o],d=t.util.getTypedArrayFromDType(a,i*s),u=t.util.getTypedArrayFromDType("int32",i*s);for(let t=0;t<i;t++){const n=t*l,a=e.subarray(n,n+l);let o=new Array(a.length);a.forEach(((e,t)=>o[t]={value:e,index:t})),s<o.length&&(ut(o,s),o=o.slice(0,s)),r&&o.sort(dt);const i=t*s,c=d.subarray(i,i+s),p=u.subarray(i,i+s);for(let e=0;e<s;e++)c[e]=o[e].value,p[e]=o[e].index}const c=n.slice();return c[c.length-1]=s,[t.buffer(c,a,d),t.buffer(c,"int32",u)]}function pt(e,n,a,s){const r=t.util.parseAxisParam(n,a)[0],o=[1,a[0],1];for(let e=0;e<r;e++)o[0]*=a[e];o[1]=a[r];for(let e=r+1;e<a.length;e++)o[2]*=a[e];const i={},l=new Int32Array(a[r]),d=new t.TensorBuffer(o,s,e),u=[],c=1===o[0]&&1===o[2];for(let t=0;t<a[r];t++){let n;if(c)n=e[t].toString();else{const e=[];for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)e.push(d.get(n,t,a));n=e.join(",")}if(void 0!==i[n])l[t]=i[n];else{const e=Object.keys(i).length;i[n]=e,l[t]=e,u.push(t)}}const p=o.slice();p[1]=Object.keys(i).length;const h=new t.TensorBuffer(p,s);u.forEach(((e,t)=>{for(let n=0;n<o[0];n++)for(let a=0;a<o[2];a++)h.set(d.get(n,e,a),n,t,a)}));const f=a.slice();return f[r]=p[1],{outputValues:h.values,outputShape:f,indices:l}}var ht={__proto__:null,simpleAbsImpl:l,addImpl:x,bincountImpl:F,bincountReduceImpl:M,ceilImpl:_,concatImpl:W,equalImpl:C,expImpl:R,expm1Impl:$,floorImpl:V,gatherNdImpl:Z,gatherV2Impl:j,greaterImpl:K,greaterEqualImpl:Q,lessImpl:te,lessEqualImpl:se,linSpaceImpl:ie,logImpl:le,maxImpl:ce,maximumImpl:pe,minimumImpl:me,multiplyImpl:be,negImpl:xe,notEqualImpl:Te,prodImpl:De,rangeImpl:Ee,rsqrtImpl:ze,scatterImpl:He,sigmoidImpl:Pe,sliceImpl:Oe,sparseFillEmptyRowsImpl:Le,sparseReshapeImpl:Ve,sparseSegmentReductionImpl:qe,sqrtImpl:Ue,squaredDifferenceImpl:Ke,stridedSliceImpl:Qe,stringNGramsImpl:et,stringSplitImpl:nt,stringToHashBucketFastImpl:at,subImpl:st,tileImpl:lt,topKImpl:ct,transposeImpl:Me,uniqueImpl:pt};t.registerBackend("cpu",(()=>new i),1);const ft=w(t.Elu,(e=>e>=0?e:Math.exp(e)-1)),mt={kernelName:t.Elu,backendName:"cpu",kernelFunc:ft};function kt(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{alpha:i}=s;r([o],"leakyRelu");const l=t.util.sizeFromShape(o.shape),d=a.data.get(o.dataId).values,u=t.util.getTypedArrayFromDType("float32",l);for(let e=0;e<d.length;e++)u[e]=d[e]<0?i*d[e]:d[e];return a.makeTensorInfo(o.shape,"float32",u)}const gt={kernelName:t.LeakyRelu,backendName:"cpu",kernelFunc:kt},bt=u(((e,t)=>e<0?t*e:e));function It(e){const{inputs:t,backend:n}=e,{x:a,alpha:s}=t;r([a,s],"prelu");const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,[l,d]=bt(a.shape,s.shape,o,i,"float32");return n.makeTensorInfo(d,"float32",l)}const yt={kernelName:t.Prelu,backendName:"cpu",kernelFunc:It},Nt=w(t.Relu,(e=>Math.max(0,e))),xt={kernelName:t.Relu,backendName:"cpu",kernelFunc:Nt},St=w(t.Relu6,(e=>Math.min(Math.max(0,e),6))),Tt={kernelName:t.Relu6,backendName:"cpu",kernelFunc:St};function vt(e,t,n,a,s){if("linear"===n)return f({inputs:{x:t},backend:e});if("relu"===n)return Nt({inputs:{x:t},backend:e});if("elu"===n)return ft({inputs:{x:t},backend:e});if("relu6"===n)return St({inputs:{x:t},backend:e});if("prelu"===n)return It({inputs:{x:t,alpha:a},backend:e});if("leakyrelu"===n)return kt({inputs:{x:t},backend:e,attrs:{alpha:s}});if("sigmoid"===n)return Re({inputs:{x:t},backend:e});throw new Error(`Activation ${n} has not been implemented for the CPU backend.`)}function Ft(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{shape:o}=s,i=t.util.sizeFromShape(r.shape),l=t.util.inferFromImplicitShape(o,i),d=t.util.sizeFromShape(l);t.util.assert(i===d,(()=>`The new shape (${l}) has ${d} elements and the old shape (${r.shape}) has ${i} elements. The new shape and old shape must have the same number of elements.`)),a.incRef(r.dataId);const u=a.data.get(r.dataId);if(null!=u.complexTensorInfos){const e=u.complexTensorInfos.real,t=u.complexTensorInfos.imag;e.shape=l,t.shape=l}return{dataId:r.dataId,shape:l,dtype:r.dtype}}const Mt={kernelName:t.Reshape,backendName:"cpu",kernelFunc:Ft};function At(e){const{inputs:n,backend:a,attrs:s}=e,{a:o,b:i}=n,{transposeA:l,transposeB:d}=s;r([o,i],"matMul");const u=o.shape.length,c=i.shape.length,p=l?o.shape[u-2]:o.shape[u-1],h=d?i.shape[c-1]:i.shape[c-2],f=l?o.shape[u-1]:o.shape[u-2],m=d?i.shape[c-2]:i.shape[c-1],k=o.shape.slice(0,-2),g=i.shape.slice(0,-2),b=t.util.sizeFromShape(k),I=t.util.sizeFromShape(g),y=t.broadcast_util.assertAndGetBroadcastShape(o.shape.slice(0,-2),i.shape.slice(0,-2)).concat([f,m]);t.util.assert(p===h,(()=>`Error in matMul: inner shapes (${p}) and (${h}) of Tensors with shapes ${o.shape} and ${i.shape} and transposeA=${l} and transposeB=${d} must match.`));const N=d?[I,m,h]:[I,h,m],x=Ft({inputs:{x:o},backend:a,attrs:{shape:l?[b,p,f]:[b,f,p]}}),S=Ft({inputs:{x:i},backend:a,attrs:{shape:N}}),T=l?x.shape[1]:x.shape[2],v=l?x.shape[2]:x.shape[1],F=d?S.shape[1]:S.shape[2],M=Math.max(b,I),A=a.data.get(x.dataId).values,w=a.data.get(S.dataId).values,D=t.util.computeStrides(x.shape),_=t.util.computeStrides(S.shape),[E,z,W]=l?[D[0],1,D[1]]:[D[0],D[1],1],[C,H,P]=d?[1,_[1],_[0]]:[_[1],1,_[0]],R=v*F,B=t.buffer([M,v,F],x.dtype),O=B.values,$=a.blockSize;for(let e=0;e<M;e++)for(let t=0;t<v;t+=$)for(let n=0;n<F;n+=$)for(let a=0;a<T;a+=$){const s=Math.min(t+$,v),r=Math.min(n+$,F),o=Math.min(a+$,T);for(let i=t;i<s;i++)for(let t=n;t<r;t++){let n=0;for(let s=a;s<o;s++){const a=Math.min(e,b-1)*E,r=Math.min(e,I-1)*P;n+=A[a+i*z+s*W]*w[s*C+t*H+r]}O[e*R+(i*F+t)]+=n}}return a.disposeIntermediateTensorInfo(x),a.disposeIntermediateTensorInfo(S),a.makeTensorInfo(y,B.dtype,B.values)}const wt={kernelName:t.BatchMatMul,backendName:"cpu",kernelFunc:At};const Dt={kernelName:t._FusedMatMul,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{a:s,b:r,bias:o,preluActivationWeights:i}=t,{transposeA:l,transposeB:d,activation:u,leakyreluAlpha:c}=a;let p,h,f;const m=[];p=At({inputs:{a:s,b:r},attrs:{transposeA:l,transposeB:d},backend:n}),o&&(h=T({inputs:{a:p,b:o},backend:n}),m.push(p),p=h),u&&(f=vt(n,p,u,i,c),m.push(p),p=f);for(const e of m)n.disposeIntermediateTensorInfo(e);return p}},_t=w(t.Acos,(e=>Math.acos(e))),Et={kernelName:t.Acos,backendName:"cpu",kernelFunc:_t},zt=w(t.Acosh,(e=>Math.acosh(e))),Wt={kernelName:t.Acosh,backendName:"cpu",kernelFunc:zt};const Ct={kernelName:t.AddN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,s=n;r(n,"addN");const o=s.map((e=>a.data.get(e.dataId).values)),i=t.buffer(s[0].shape,s[0].dtype),l=i.values;for(let e=0;e<s.length;e++){const t=o[e];for(let e=0;e<l.length;e++)l[e]+=t[e]}return a.makeTensorInfo(i.shape,i.dtype,i.values)}};const Ht={kernelName:t.All,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,keepDims:l}=s;r(o,"all");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Ae({inputs:{x:o},backend:a,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("all",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=a.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n&&a}k[e]=n}null!=c&&a.disposeIntermediateTensorInfo(p);const b=a.makeTensorInfo(h,p.dtype,k);if(l){const e=Ft({inputs:{x:b},backend:a,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return a.disposeIntermediateTensorInfo(b),e}return b}};const Pt={kernelName:t.Any,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,keepDims:l}=s;r(o,"any");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Ae({inputs:{x:o},backend:a,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("any",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=a.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];n=n||a}k[e]=n}null!=c&&a.disposeIntermediateTensorInfo(p);const b=a.makeTensorInfo(h,p.dtype,k);if(l){const e=Ft({inputs:{x:b},backend:a,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return a.disposeIntermediateTensorInfo(b),e}return b}};const Rt={kernelName:t.ArgMax,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i}=s;r(o,"argMax");let l=t.util.parseAxisParam(i,o.shape);const d=t.backend_util.getAxesPermutation(l,o.shape.length);let u=o;const c=[];null!=d&&(u=Ae({inputs:{x:o},backend:a,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMax",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),g=a.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s>n&&(n=s,a=e)}m[e]=a}return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(p,"int32",m)}};const Bt={kernelName:t.ArgMin,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i}=s;r(o,"argMin");let l=t.util.parseAxisParam(i,o.shape);const d=t.backend_util.getAxesPermutation(l,o.shape.length);let u=o;const c=[];null!=d&&(u=Ae({inputs:{x:o},backend:a,attrs:{perm:d}}),c.push(u),l=t.backend_util.getInnerMostAxes(l.length,u.shape.length)),l=[l[0]],t.backend_util.assertAxesAreInnerMostDims("argMin",l,u.shape.length);const[p,h]=t.backend_util.computeOutAndReduceShapes(u.shape,l),f=t.util.sizeFromShape(p),m=t.util.makeZerosTypedArray(f,"int32"),k=t.util.sizeFromShape(h),g=a.data.get(u.dataId).values;for(let e=0;e<m.length;++e){const t=e*k;let n=g[t],a=0;for(let e=0;e<k;++e){const s=g[t+e];s<n&&(n=s,a=e)}m[e]=a}return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.makeTensorInfo(p,"int32",m)}},Ot=w(t.Asin,(e=>Math.asin(e))),$t={kernelName:t.Asin,backendName:"cpu",kernelFunc:Ot},Gt=w(t.Asinh,(e=>Math.asinh(e))),Lt={kernelName:t.Asinh,backendName:"cpu",kernelFunc:Gt},Vt=w(t.Atan,(e=>Math.atan(e))),qt={kernelName:t.Atan,backendName:"cpu",kernelFunc:Vt},Ut=u(((e,t)=>Math.atan2(e,t))),Zt=y(t.Atan2,Ut),jt={kernelName:t.Atan2,backendName:"cpu",kernelFunc:Zt},Kt=w(t.Atanh,(e=>Math.atanh(e))),Yt={kernelName:t.Atanh,backendName:"cpu",kernelFunc:Kt};function Jt(e,n,a,s,r,o){const i=r.strideHeight,l=r.strideWidth,d=r.dilationHeight,u=r.dilationWidth,c=r.effectiveFilterHeight,p=r.effectiveFilterWidth,h=r.padInfo.top,f=r.padInfo.left,m="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,k=t.buffer(r.outShape,a),g=k.values,b=r.outShape[1]*r.outShape[2]*r.outShape[3],I=r.outShape[2]*r.outShape[3],y=r.outShape[3];for(let t=0;t<r.batchSize;++t){const n=t*b,a=t*s[0];for(let t=0;t<r.inChannels;++t)for(let k=0;k<r.outHeight;++k){const b=k*i-h,N=Math.max(0,b),x=Math.min(r.inHeight,c+b),S=n+k*I;for(let n=0;n<r.outWidth;++n){const i=n*l-f,c=Math.max(0,i),h=Math.min(r.inWidth,p+i);let k=m,b=0,I=0;for(let n=N;n<x;n+=d){const r=a+n*s[1];for(let n=c;n<h;n+=u){const a=e[r+n*s[2]+t];"max"===o&&a>k?k=a:"avg"===o&&(b+=a,I++)}if(isNaN(k))break}g[S+n*y+t]="avg"===o?b/I:k}}}return k}function Qt(e,n,a,s,r=!1,o=!1){const i=t.buffer(s.outShape,"int32"),l=s.strideHeight,d=s.strideWidth,u=s.dilationHeight,c=s.dilationWidth,p=s.effectiveFilterHeight,h=s.effectiveFilterWidth,f=s.padInfo.top,m=s.padInfo.left,k=t.buffer(n,a,e);for(let e=0;e<s.batchSize;++e)for(let t=0;t<s.inChannels;++t)for(let n=0;n<s.outHeight;++n){const a=n*l-f;let g=a;for(;g<0;)g+=u;const b=Math.min(s.inHeight,p+a);for(let l=0;l<s.outWidth;++l){const p=l*d-m;let f=p;for(;f<0;)f+=c;const I=Math.min(s.inWidth,h+p);let y=Number.NEGATIVE_INFINITY,N=-1;for(let n=g;n<b;n+=u){const i=n-a;for(let a=f;a<I;a+=c){const l=a-p,d=k.get(e,n,a,t);d>y&&(y=d,N=r?o?((e*s.inHeight+n)*s.inWidth+a)*s.inChannels+t:(n*s.inWidth+a)*s.inChannels+t:i*h+l)}}i.set(N,e,n,l,t)}}return i}function Xt(e,n,a,s,r,o){const i=r.strideDepth,l=r.strideHeight,d=r.strideWidth,u=r.dilationDepth,c=r.dilationHeight,p=r.dilationWidth,h=r.effectiveFilterDepth,f=r.effectiveFilterHeight,m=r.effectiveFilterWidth,k=r.padInfo.front,g=r.padInfo.top,b=r.padInfo.left,I="max"===o?Number.NEGATIVE_INFINITY:Number.POSITIVE_INFINITY,y=t.buffer(r.outShape,a),N=y.values,x=r.outShape[1]*r.outShape[2]*r.outShape[3]*r.outShape[4],S=r.outShape[2]*r.outShape[3]*r.outShape[4],T=r.outShape[3]*r.outShape[4],v=r.outShape[4];for(let t=0;t<r.batchSize;++t){const n=t*x,a=t*s[0];for(let t=0;t<r.inChannels;++t)for(let y=0;y<r.outDepth;++y){const x=y*i-k;let F=x;for(;F<0;)F+=u;const M=Math.min(r.inDepth,h+x),A=n+y*S;for(let n=0;n<r.outHeight;++n){const i=n*l-g;let h=i;for(;h<0;)h+=c;const k=Math.min(r.inHeight,f+i),y=A+n*T;for(let n=0;n<r.outWidth;++n){const i=n*d-b;let l=i;for(;l<0;)l+=p;const f=Math.min(r.inWidth,m+i),g=y+n*v;let x=I,S=0,T=0;for(let n=F;n<M;n+=u){const r=a+n*s[1];for(let n=h;n<k;n+=c){const a=r+n*s[2];for(let n=l;n<f;n+=p){const r=e[a+n*s[3]+t];if("max"===o&&r>x?x=r:"avg"===o&&(S+=r,T++),isNaN(x))break}if(isNaN(x))break}if(isNaN(x))break}N[g+t]="avg"===o?S/T:x}}}}return y}const en={kernelName:t.AvgPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n;r(o,"avgPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=s;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),(()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`));const c=t.backend_util.computePool2DInfo(o.shape,i,l,1,d,u);let p;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))p=f({inputs:{x:o},backend:a});else{const e=a.data.get(o.dataId).values,n=t.util.computeStrides(o.shape),s=Jt(e,o.shape,o.dtype,n,c,"avg");p=a.makeTensorInfo(c.outShape,o.dtype,s.values)}return p}};const tn={kernelName:t.AvgPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=s;r(o,"avgPool3d");const p=t.backend_util.computePool3DInfo(o.shape,i,l,1,d,u,c),h=Xt(a.data.get(o.dataId).values,o.shape,o.dtype,t.util.computeStrides(o.shape),p,"avg");return a.makeTensorInfo(h.shape,"float32",h.values)}};const nn={kernelName:t.AvgPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=s;r([o,i],"avgPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=p.strideDepth,f=p.strideHeight,m=p.strideWidth,k=p.filterDepth,g=p.filterHeight,b=p.filterWidth,I=p.dilationDepth,y=p.dilationHeight,N=p.dilationWidth,x=p.effectiveFilterDepth,S=p.effectiveFilterHeight,T=p.effectiveFilterWidth,v=x-1-p.padInfo.front,F=T-1-p.padInfo.left,M=S-1-p.padInfo.top,A=t.buffer(i.shape,"float32"),w=1/(k*g*b),D=a.bufferSync(o);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const r=n-v,o=a-M,i=s-F;let l=0;for(let n=0;n<x;n+=I){const a=(r+n)/h;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let n=0;n<S;n+=y){const s=(o+n)/f;if(!(s<0||s>=p.outHeight||Math.floor(s)!==s))for(let n=0;n<T;n+=N){const r=(i+n)/m;if(r<0||r>=p.outWidth||Math.floor(r)!==r)continue;l+=D.get(e,a,s,r,t)}}}A.set(l*w,e,n,a,s,t)}return a.makeTensorInfo(A.shape,A.dtype,A.values)}};const an={kernelName:t.AvgPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,input:i}=n,l=i;r([o,i],"avgPoolGrad");const{filterSize:d,strides:u,pad:c}=s,p=t.backend_util.computePool2DInfo(l.shape,d,u,1,c),h=p.strideHeight,f=p.strideWidth,m=p.filterHeight,k=p.filterWidth,g=p.dilationHeight,b=p.dilationWidth,I=p.effectiveFilterHeight,y=p.effectiveFilterWidth,N=y-1-p.padInfo.left,x=I-1-p.padInfo.top,S=t.buffer(l.shape,"float32"),T=1/(m*k),v=a.data.get(o.dataId).values,F=t.buffer(o.shape,"float32",v);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inHeight;++n)for(let a=0;a<p.inWidth;++a){const s=n-x,r=a-N;let o=0;for(let n=0;n<I;n+=g){const a=(s+n)/h;if(!(a<0||a>=p.outHeight||Math.floor(a)!==a))for(let n=0;n<y;n+=b){const s=(r+n)/f;if(s<0||s>=p.outWidth||Math.floor(s)!==s)continue;o+=F.get(e,a,s,t)}}S.set(o*T,e,n,a,t)}return a.makeTensorInfo(S.shape,S.dtype,S.values)}};const sn={kernelName:t.FusedBatchNorm,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,scale:i,offset:l,mean:d,variance:u}=n;t.util.assert(d.shape.length===u.shape.length,(()=>"Batch normalization gradient requires mean and variance to have equal ranks.")),t.util.assert(null==l||d.shape.length===l.shape.length,(()=>"Batch normalization gradient requires mean and offset to have equal ranks.")),t.util.assert(null==i||d.shape.length===i.shape.length,(()=>"Batch normalization gradient requires mean and scale to have equal ranks.")),r([o,d,u,i,l],"batchNorm");let{varianceEpsilon:c}=s;null==c&&(c=.001);const p=a.data.get(o.dataId).values,h=a.data.get(d.dataId).values,f=a.data.get(u.dataId).values,m=i?a.data.get(i.dataId).values:new Float32Array([1]),k=l?a.data.get(l.dataId).values:new Float32Array([0]),g=new Float32Array(p.length),b=k.length,I=m.length,y=f.length,N=h.length;let x=0,S=0,T=0,v=0;for(let e=0;e<p.length;++e)g[e]=k[x++]+(p[e]-h[S++])*m[T++]/Math.sqrt(f[v++]+c),x>=b&&(x=0),S>=N&&(S=0),T>=I&&(T=0),v>=y&&(v=0);return a.makeTensorInfo(o.shape,o.dtype,g)}};const rn={kernelName:t.BatchToSpaceND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{blockShape:i,crops:l}=s;r([o],"batchToSpaceND");const d=i.reduce(((e,t)=>e*t)),u=t.backend_util.getReshaped(o.shape,i,d),c=t.backend_util.getPermuted(u.length,i.length),p=t.backend_util.getReshapedPermuted(o.shape,i,d),h=t.backend_util.getSliceBeginCoords(l,i.length),f=t.backend_util.getSliceSize(p,l,i.length),m=Ft({inputs:{x:o},backend:a,attrs:{shape:u}}),k=Ae({inputs:{x:m},backend:a,attrs:{perm:c}}),g=Ft({inputs:{x:k},backend:a,attrs:{shape:p}}),b=$e({inputs:{x:g},backend:a,attrs:{begin:h,size:f}});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(g),b}};const on={kernelName:t.Bincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o}=a,i=F(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,i)}};const ln={kernelName:t.BroadcastArgs,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{s0:s,s1:r}=n,o=a.data.get(s.dataId).values,i=a.data.get(r.dataId).values,l=t.backend_util.assertAndGetBroadcastShape(Array.from(o),Array.from(i));return a.makeTensorInfo([l.length],"int32",Int32Array.from(l))}},dn=w(t.ClipByValue,((e,t)=>{const n=t;return e>n.clipValueMax?n.clipValueMax:e<n.clipValueMin?n.clipValueMin:e})),un={kernelName:t.ClipByValue,backendName:"cpu",kernelFunc:dn},cn={kernelName:t.ComplexAbs,backendName:"cpu",kernelFunc:e=>{const{x:n}=e.inputs,a=e.backend,s=new Float32Array(t.util.sizeFromShape(n.shape)),r=a.data.get(n.dataId),o=r.complexTensorInfos.real,i=r.complexTensorInfos.imag,l=a.data.get(o.dataId).values,d=a.data.get(i.dataId).values;for(let e=0;e<l.length;e++){const t=l[e],n=d[e];s[e]=Math.hypot(t,n)}return a.makeOutput(s,n.shape,"float32")}};function pn(e){const{inputs:t,backend:n}=e,{input:a}=t,s=n.data.get(a.dataId).complexTensorInfos.imag,r=n.data.get(s.dataId).values;return n.makeTensorInfo(s.shape,s.dtype,r)}const hn={kernelName:t.Imag,backendName:"cpu",kernelFunc:pn};function fn(e){const{inputs:n,backend:a,attrs:s}=e,{axis:r}=s,o=t.util.parseAxisParam(r,n[0].shape)[0];let i=t.backend_util.computeOutShape(n.map((e=>e.shape)),o);if(0===t.util.sizeFromShape(i))return a.makeTensorInfo(i,n[0].dtype,[]);const l=n.filter((e=>t.util.sizeFromShape(e.shape)>0));if(1===l.length)return f({inputs:{x:l[0]},backend:a});const d=l.map((e=>e.shape));if(t.backend_util.assertParamsConsistent(d,o),"complex64"===l[0].dtype){const e=l.map((e=>k({inputs:{input:e},backend:a}))),t=l.map((e=>pn({inputs:{input:e},backend:a}))),n=fn({inputs:e,backend:a,attrs:{axis:o}}),s=fn({inputs:t,backend:a,attrs:{axis:o}}),r=c({inputs:{real:n,imag:s},backend:a});return e.forEach((e=>a.disposeIntermediateTensorInfo(e))),t.forEach((e=>a.disposeIntermediateTensorInfo(e))),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(s),r}const u=l.map((e=>{const n=t.util.sizeFromShape(e.shape.slice(o));return Ft({inputs:{x:e},backend:a,attrs:{shape:[-1,n]}})})),p=u.map((e=>({vals:a.data.get(e.dataId).values,shape:e.shape})));i=t.backend_util.computeOutShape(u.map((e=>e.shape)),1);const h=1===u[0].shape[0],m=W(p,i,n[0].dtype,h),g=t.backend_util.computeOutShape(l.map((e=>e.shape)),o),b=a.makeTensorInfo(g,n[0].dtype,m);return u.forEach((e=>a.disposeIntermediateTensorInfo(e))),b}const mn={kernelName:t.Concat,backendName:"cpu",kernelFunc:fn};function kn(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,filter:i}=n,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}=s;r([o,i],"conv2d");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(o.shape,i.shape,l,c,d,p,!1,h),m=f.filterHeight,k=f.filterWidth,g=f.dilationHeight,b=f.dilationWidth,I=f.padInfo.left,y=f.padInfo.top,N="channelsLast"===f.dataFormat,x=new t.TensorBuffer(f.outShape,o.dtype),S=t.util.computeStrides(o.shape),T=t.util.computeStrides(i.shape),v=S[0],F=N?S[1]:S[2],M=N?S[2]:1,A=N?1:S[1],w=x.strides[0],D=N?x.strides[1]:x.strides[2],_=N?x.strides[2]:1,E=N?1:x.strides[1],z=a.data.get(o.dataId).values,W=a.data.get(i.dataId).values,C=x.values;for(let e=0;e<f.batchSize;++e){const t=e*v,n=e*w;for(let e=0;e<f.outHeight;++e){const a=n+e*D,s=e*f.strideHeight-y;for(let e=0;e<m;++e){const n=s+e*g;if(n<0||n>=f.inHeight)continue;const r=e*T[0],o=t+n*F;for(let e=0;e<f.outWidth;++e){const t=a+e*_,n=e*f.strideWidth-I;for(let e=0;e<k;++e){const a=n+e*b;if(a<0||a>=f.inWidth)continue;const s=o+a*M;let i=r+e*T[1];for(let e=0;e<f.inChannels;++e){const n=z[s+e*A];for(let e=0;e<f.outChannels;++e)C[t+e*E]+=n*W[i+e];i+=f.outChannels}}}}}}return a.makeTensorInfo(x.shape,x.dtype,C)}const gn={kernelName:t.Conv2D,backendName:"cpu",kernelFunc:kn};const bn={kernelName:t.Conv2DBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,dy:i}=n,{strides:l,pad:d,dataFormat:u,dimRoundingMode:c,filterShape:p}=s;r([o,i],"conv2dBackpropFilter");const h=t.backend_util.convertConv2DDataFormat(u),f=t.backend_util.computeConv2DInfo(o.shape,p,l,1,d,c,!1,h),{strideHeight:m,strideWidth:k,filterHeight:g,filterWidth:b}=f,I="channelsLast"===f.dataFormat,y=new t.TensorBuffer(f.filterShape,"float32"),N=f.padInfo.left,x=f.padInfo.top,S=a.data.get(o.dataId).values,T=a.data.get(i.dataId).values,v=new t.TensorBuffer(o.shape,o.dtype,S),F=new t.TensorBuffer(i.shape,i.dtype,T);for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((x-e)/m)),n=Math.min(f.outHeight,(f.inHeight+x-e)/m);for(let a=0;a<b;++a){const s=Math.max(0,Math.ceil((N-a)/k)),r=Math.min(f.outWidth,(f.inWidth+N-a)/k);for(let o=0;o<f.inChannels;++o)for(let i=0;i<f.outChannels;++i){let l=0;for(let d=0;d<f.batchSize;++d)for(let u=t;u<n;++u){const t=e+u*m-x;for(let e=s;e<r;++e){const n=a+e*k-N;l+=I?v.get(d,t,n,o)*F.get(d,u,e,i):v.get(d,o,t,n)*F.get(d,i,u,e)}}y.set(l,e,a,o,i)}}}return a.makeTensorInfo(y.shape,y.dtype,y.values)}};const In={kernelName:t.Conv2DBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,filter:i}=n,{inputShape:l,strides:d,pad:u,dataFormat:c,dimRoundingMode:p}=s;r([o,i],"conv2dBackpropInput");const h=t.util.computeStrides(i.shape),f=t.util.computeStrides(o.shape);let m=t.backend_util.convertConv2DDataFormat(c);const k=t.backend_util.computeConv2DInfo(l,i.shape,d,1,u,p,!1,m),g=new t.TensorBuffer(k.inShape,"float32"),b=g.values,I=a.data.get(o.dataId).values,y=a.data.get(i.dataId).values,[N,x,S]=h,{batchSize:T,filterHeight:v,filterWidth:F,inChannels:M,inHeight:A,inWidth:w,outChannels:D,outHeight:_,outWidth:E,strideHeight:z,strideWidth:W}=k;m=k.dataFormat;const C=v-1-k.padInfo.top,H=F-1-k.padInfo.left,P="channelsLast"===m,R=g.strides[0],B=P?g.strides[1]:g.strides[2],O=P?g.strides[2]:1,$=P?1:g.strides[1],G=f[0],L=P?f[1]:f[2],V=P?f[2]:1,q=P?1:f[1];for(let e=0;e<T;++e)for(let t=0;t<M;++t)for(let n=0;n<A;++n){const a=n-C,s=Math.max(0,Math.ceil(a/z)),r=Math.min(_,(v+a)/z);for(let o=0;o<w;++o){const i=o-H,l=Math.max(0,Math.ceil(i/W)),d=Math.min(E,(F+i)/W);let u=0;for(let n=s;n<r;++n){const s=n*z-a;for(let a=l;a<d;++a){const r=G*e+L*n+V*a,o=N*(v-1-s)+x*(F-1-(a*W-i))+S*t;for(let e=0;e<D;++e){u+=I[r+q*e]*y[o+e]}}}b[R*e+B*n+O*o+$*t]=u}}return a.makeTensorInfo(g.shape,g.dtype,g.values)}};const yn={kernelName:t.Conv3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,filter:i}=n,{strides:l,pad:d,dilations:u}=s;r([o,i],"conv3d");const c=t.backend_util.computeConv3DInfo(o.shape,i.shape,l,u,d),{filterDepth:p,filterHeight:h,filterWidth:f,dilationDepth:m,dilationHeight:k,dilationWidth:g,padInfo:b}=c,I=b.front,y=b.left,N=b.top,x=new t.TensorBuffer(c.outShape,o.dtype),S=a.data.get(o.dataId).values,T=a.data.get(i.dataId).values,v=x.values,F=t.util.computeStrides(o.shape),M=t.util.computeStrides(i.shape);for(let e=0;e<c.batchSize;++e){const t=e*F[0],n=e*x.strides[0];for(let e=0;e<c.outDepth;++e){const a=n+e*x.strides[1],s=e*c.strideDepth-I;for(let e=0;e<p;++e){const n=s+e*m;if(n<0||n>=c.inDepth)continue;const r=e*M[0],o=t+n*F[1];for(let e=0;e<c.outHeight;++e){const t=a+e*x.strides[2],n=e*c.strideHeight-N;for(let e=0;e<h;++e){const a=n+e*k;if(a<0||a>=c.inHeight)continue;const s=r+e*M[1],i=o+a*F[2];for(let e=0;e<c.outWidth;++e){const n=t+e*c.outChannels,a=e*c.strideWidth-y;for(let e=0;e<f;++e){const t=a+e*g;if(t<0||t>=c.inWidth)continue;const r=s+e*M[2],o=i+t*c.inChannels;let l=r;for(let e=0;e<c.inChannels;++e){const t=S[o+e];for(let e=0;e<c.outChannels;++e)v[n+e]+=t*T[l+e];l+=c.outChannels}}}}}}}}return a.makeTensorInfo(x.shape,x.dtype,x.values)}};const Nn={kernelName:t.Conv3DBackpropFilterV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,dy:i}=n,{strides:l,pad:d,filterShape:u}=s;r([o,i],"conv3dBackpropFilterV2");const c=t.util.computeStrides(o.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(o.shape,u,l,1,d),f=h.strideDepth,m=h.strideHeight,k=h.strideWidth,g=h.filterDepth,b=h.filterHeight,I=h.filterWidth,y=new t.TensorBuffer(h.filterShape,"float32"),N=y.values,[x,S,T,v]=y.strides,F=a.data.get(i.dataId).values,[M,A,w,D]=p,_=a.data.get(o.dataId).values,[E,z,W,C]=c,H=h.padInfo.front,P=h.padInfo.left,R=h.padInfo.top;for(let e=0;e<g;++e){const t=Math.max(0,Math.ceil((H-e)/f)),n=Math.min(h.outDepth,(h.inDepth+H-e)/f),a=e*x;for(let s=0;s<b;++s){const r=Math.max(0,Math.ceil((R-s)/m)),o=Math.min(h.outHeight,(h.inHeight+R-s)/m),i=s*S+a;for(let a=0;a<I;++a){const l=Math.max(0,Math.ceil((P-a)/k)),d=Math.min(h.outWidth,(h.inWidth+P-a)/k),u=a*T+i;for(let i=0;i<h.inChannels;++i){const c=i*v+u;for(let u=0;u<h.outChannels;++u){let p=0;for(let c=0;c<h.batchSize;++c){const h=c*E,g=c*M;for(let c=t;c<n;++c){const t=(e+c*f-H)*z+h,n=c*A+g;for(let e=r;e<o;++e){const r=(s+e*m-R)*W+t,o=e*w+n;for(let e=l;e<d;++e){const t=e*D+o;p+=_[(a+e*k-P)*C+r+i]*F[t+u]}}}}N[c+u]=p}}}}}return a.makeTensorInfo(y.shape,y.dtype,y.values)}};const xn={kernelName:t.Conv3DBackpropInputV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,filter:i}=n,{pad:l,strides:d,inputShape:u}=s;r([o],"conv3dBackpropInputV2");const c=t.util.computeStrides(o.shape),p=t.util.computeStrides(i.shape),h=t.backend_util.computeConv3DInfo(u,i.shape,d,1,l),f=new t.TensorBuffer(h.inShape,"float32"),m=f.values,[k,g,b,I]=f.strides,y=a.data.get(o.dataId).values,[N,x,S,T]=c,v=a.data.get(i.dataId).values,[F,M,A,w]=p,{batchSize:D,filterDepth:_,filterHeight:E,filterWidth:z,inChannels:W,inDepth:C,inHeight:H,inWidth:P,outChannels:R,outDepth:B,outHeight:O,outWidth:$,strideDepth:G,strideHeight:L,strideWidth:V}=h,q=_-1-h.padInfo.front,U=E-1-h.padInfo.top,Z=z-1-h.padInfo.left;for(let e=0;e<D;++e)for(let t=0;t<W;++t)for(let n=0;n<C;++n){const a=n-q,s=Math.max(0,Math.ceil(a/G)),r=Math.min(B,(_+a)/G);for(let o=0;o<H;++o){const i=o-U,l=Math.max(0,Math.ceil(i/L)),d=Math.min(O,(E+i)/L);for(let u=0;u<P;++u){const c=u-Z,p=Math.max(0,Math.ceil(c/V)),h=Math.min($,(z+c)/V);let f=0;for(let n=s;n<r;++n){const s=n*G-a;for(let a=l;a<d;++a){const r=a*L-i;for(let o=p;o<h;++o){const i=N*e+x*n+S*a+T*o,l=F*(_-1-s)+M*(E-1-r)+A*(z-1-(o*V-c))+w*t;for(let e=0;e<R;++e){f+=y[i+e]*v[l+e]}}}}m[k*e+g*n+b*o+I*u+t]=f}}}return a.makeTensorInfo(f.shape,f.dtype,f.values)}},Sn=w(t.Cos,(e=>Math.cos(e))),Tn={kernelName:t.Cos,backendName:"cpu",kernelFunc:Sn},vn=w(t.Cosh,(e=>Math.cosh(e))),Fn={kernelName:t.Cosh,backendName:"cpu",kernelFunc:vn};const Mn={kernelName:t.CropAndResize,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{image:r,boxes:o,boxInd:i}=n,{cropSize:l,method:d,extrapolationValue:u}=s,[c,p,h,f]=r.shape,m=o.shape[0],[k,g]=l,b=t.buffer([m,k,g,f],"float32"),I=a.data.get(o.dataId).values,y=a.data.get(i.dataId).values,N=a.data.get(r.dataId).values,x=t.util.computeStrides(r.shape),S=t.util.computeStrides(b.shape);for(let e=0;e<m;e++){const t=4*e,n=I[t],a=I[t+1],s=I[t+2],r=I[t+3],o=y[e];if(o>=c)continue;const i=k>1?(s-n)*(p-1)/(k-1):0,l=g>1?(r-a)*(h-1)/(g-1):0;for(let t=0;t<k;t++){const c=k>1?n*(p-1)+t*i:.5*(n+s)*(p-1);if(c<0||c>p-1)for(let n=0;n<g;n++)for(let a=0;a<f;a++){const s=a+n*S[2]+t*S[1]+e*S[0];b.values[s]=u}else if("bilinear"===d){const n=Math.floor(c),s=Math.ceil(c),i=c-n;for(let d=0;d<g;d++){const c=g>1?a*(h-1)+d*l:.5*(a+r)*(h-1);if(c<0||c>h-1){for(let n=0;n<f;n++){const a=n+d*S[2]+t*S[1]+e*S[0];b.values[a]=u}continue}const p=Math.floor(c),m=Math.ceil(c),k=c-p;for(let a=0;a<f;a++){let r=a+p*x[2]+n*x[1]+o*x[0];const l=N[r];r=a+m*x[2]+n*x[1]+o*x[0];const u=N[r];r=a+p*x[2]+s*x[1]+o*x[0];const c=N[r];r=a+m*x[2]+s*x[1]+o*x[0];const h=l+(u-l)*k,f=c+(N[r]-c)*k;r=a+d*S[2]+t*S[1]+e*S[0],b.values[r]=h+(f-h)*i}}}else for(let n=0;n<g;++n){const s=g>1?a*(h-1)+n*l:.5*(a+r)*(h-1);if(s<0||s>h-1){for(let a=0;a<f;a++){const s=a+n*S[2]+t*S[1]+e*S[0];b.values[s]=u}continue}const i=Math.round(s),d=Math.round(c);for(let a=0;a<f;a++){const s=a+i*x[2]+d*x[1]+o*x[0],r=a+n*S[2]+t*S[1]+e*S[0];b.values[r]=N[s]}}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const An={kernelName:t.Cumprod,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,exclusive:l,reverse:d}=s;r(o,"cumprod");const u=t.backend_util.getAxesPermutation([i],o.shape.length);let c=o;null!=u&&(c=Ae({inputs:{x:o},backend:a,attrs:{perm:u}}));const p=t.backend_util.getInnerMostAxes(1,o.shape.length)[0];if(p!==c.shape.length-1)throw new Error(`backend.cumprod in CPU expects an inner-most axis=${c.shape.length-1} but got axis=${p}`);const h=t.upcastType(c.dtype,"int32"),f=t.util.makeOnesTypedArray(t.util.sizeFromShape(c.shape),h),m=a.data.get(c.dataId).values,k=c.shape[c.shape.length-1],g=d?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=g(e,t);if(0===t)f[n]=l?1:m[n];else{const a=g(e,t-1);f[n]=l?m[a]*f[a]:m[n]*f[a]}}const b=a.makeTensorInfo(c.shape,h,f);if(null!=u){const e=Ae({inputs:{x:b},backend:a,attrs:{perm:t.backend_util.getUndoAxesPermutation(u)}});return a.disposeIntermediateTensorInfo(b),a.disposeIntermediateTensorInfo(c),e}return b}};const wn={kernelName:t.Cumsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,exclusive:l,reverse:d}=s;r(o,"cumsum");const u=t.backend_util.getAxesPermutation([i],o.shape.length);let c=o;null!=u&&(c=Ae({inputs:{x:o},backend:a,attrs:{perm:u}}));const p=t.backend_util.getInnerMostAxes(1,o.shape.length)[0];if(p!==c.shape.length-1)throw new Error(`backend.cumsum in CPU expects an inner-most axis=${c.shape.length-1} but got axis=${p}`);const h=t.upcastType(c.dtype,"int32"),f=t.util.makeZerosTypedArray(t.util.sizeFromShape(c.shape),h),m=a.data.get(c.dataId).values,k=c.shape[c.shape.length-1],g=d?(e,t)=>e+k-t-1:(e,t)=>e+t;for(let e=0;e<m.length;e+=k)for(let t=0;t<k;t++){const n=g(e,t);if(0===t)f[n]=l?0:m[n];else{const a=g(e,t-1);f[n]=l?m[a]+f[a]:m[n]+f[a]}}const b=a.makeTensorInfo(c.shape,h,f);if(null!=u){const e=Ae({inputs:{x:b},backend:a,attrs:{perm:t.backend_util.getUndoAxesPermutation(u)}});return a.disposeIntermediateTensorInfo(b),a.disposeIntermediateTensorInfo(c),e}return b}};const Dn={kernelName:t.DenseBincount,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,weights:r}=t,{size:o,binaryOutput:i}=a;if(1===s.shape.length){const e=F(n.data.get(s.dataId).values,n.data.get(r.dataId).values,r.dtype,r.shape,o);return n.makeTensorInfo([o],r.dtype,e)}if(2===s.shape.length){const e=M(n.bufferSync(s),n.bufferSync(r),o,i);return n.makeTensorInfo(e.shape,r.dtype,e.values)}throw new Error(`Error in denseBincount: input must be at most rank 2, but got rank${s.shape.length}.`)}};const _n={kernelName:t.DepthToSpace,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{blockSize:o,dataFormat:i}=s;t.util.assert("NHWC"===i,(()=>`Only NHWC dataFormat supported on CPU for depthToSpace. Got ${i}`));const l=r.shape[0],d=r.shape[1],u=r.shape[2],c=r.shape[3],p=d*o,h=u*o,f=c/(o*o),m=a.data.get(r.dataId).values,k=new Float32Array(l*p*h*f);let g=0;for(let e=0;e<l;++e)for(let t=0;t<p;++t){const n=Math.floor(t/o),a=t%o;for(let t=0;t<h;++t){const s=Math.floor(t/o),r=(a*o+t%o)*f;for(let t=0;t<f;++t){const a=t+r+c*(s+u*(n+d*e));k[g++]=m[a]}}}return a.makeTensorInfo([l,p,h,f],r.dtype,k)}};function En(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,filter:i}=n,{strides:l,pad:d,dilations:u,dimRoundingMode:c}=s;r([o,i],"depthwiseConv2DNative");const p=t.util.computeStrides(o.shape),h=t.util.computeStrides(i.shape);let f=u;null==f&&(f=[1,1]),t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,f),(()=>`Error in depthwiseConv2d: Either strides or dilations must be 1. Got strides ${l} and dilations '${f}'`));const m=t.backend_util.computeConv2DInfo(o.shape,i.shape,l,f,d,c,!0),{filterHeight:k,filterWidth:g,dilationHeight:b,dilationWidth:I,padInfo:y}=m,N=y.left,x=y.top,S=m.outChannels/m.inChannels,T=new t.TensorBuffer(m.outShape,o.dtype),v=a.data.get(o.dataId).values,F=a.data.get(i.dataId).values,M=T.values;for(let e=0;e<m.batchSize;++e){const t=e*p[0],n=e*T.strides[0];for(let e=0;e<m.outHeight;++e){const a=n+e*T.strides[1],s=e*m.strideHeight-x;for(let e=0;e<k;++e){const n=s+e*b;if(n<0||n>=m.inHeight)continue;const r=e*h[0],o=t+n*p[1];for(let e=0;e<m.outWidth;++e){const t=a+e*T.strides[2],n=e*m.strideWidth-N;for(let e=0;e<g;++e){const a=n+e*I;if(a<0||a>=m.inWidth)continue;const s=r+e*h[1],i=o+a*m.inChannels;let l=t,d=s;for(let e=0;e<m.inChannels;++e){const t=v[i+e];for(let e=0;e<S;++e)M[l+e]+=t*F[d+e];l+=S,d+=S}}}}}}return a.makeTensorInfo(T.shape,T.dtype,T.values)}const zn={kernelName:t.DepthwiseConv2dNative,backendName:"cpu",kernelFunc:En};const Wn={kernelName:t.DepthwiseConv2dNativeBackpropFilter,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,dy:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,filterShape:p}=s;r([o,i],"depthwiseConv2dNativeBackpropFilter");const h=t.backend_util.computeConv2DInfo(o.shape,p,l,d,u,c,!0),{strideHeight:f,strideWidth:m,filterHeight:k,filterWidth:g}=h,b=new t.TensorBuffer(h.filterShape,"float32"),I=h.padInfo.left,y=h.padInfo.top,N=h.outChannels/h.inChannels,x=a.data.get(o.dataId).values,S=new t.TensorBuffer(o.shape,o.dtype,x),T=a.data.get(i.dataId).values,v=new t.TensorBuffer(i.shape,i.dtype,T);for(let e=0;e<k;++e){const t=Math.max(0,Math.ceil((y-e)/f)),n=Math.min(h.outHeight,(h.inHeight+y-e)/f);for(let a=0;a<g;++a){const s=Math.max(0,Math.ceil((I-a)/m)),r=Math.min(h.outWidth,(h.inWidth+I-a)/m);for(let o=0;o<h.outChannels;++o){const i=Math.trunc(o/N),l=o%N;let d=0;for(let l=0;l<h.batchSize;++l)for(let u=t;u<n;++u){const t=e+u*f-y;for(let e=s;e<r;++e){const n=a+e*m-I;d+=S.get(l,t,n,i)*v.get(l,u,e,o)}}b.set(d,e,a,i,l)}}}return a.makeTensorInfo(b.shape,b.dtype,b.values)}};const Cn={kernelName:t.DepthwiseConv2dNativeBackpropInput,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,filter:i}=n,{strides:l,dilations:d,pad:u,dimRoundingMode:c,inputShape:p}=s;r([o,i],"depthwiseConv2DNativeBackpropInput");const h=t.util.computeStrides(o.shape),f=t.util.computeStrides(i.shape),m=t.backend_util.computeConv2DInfo(p,i.shape,l,d,u,c,!0),k=new t.TensorBuffer(m.inShape,"float32"),g=k.values,[b,I,y]=k.strides,N=a.data.get(o.dataId).values,[x,S,T]=h,v=a.data.get(i.dataId).values,[F,M,A]=f,{batchSize:w,filterHeight:D,filterWidth:_,inChannels:E,inHeight:z,inWidth:W,outChannels:C,outHeight:H,outWidth:P,strideHeight:R,strideWidth:B}=m,O=D-1-m.padInfo.top,$=_-1-m.padInfo.left,G=C/E;for(let e=0;e<w;++e)for(let t=0;t<E;++t)for(let n=0;n<z;++n){const a=n-O,s=Math.max(0,Math.ceil(a/R)),r=Math.min(H,(D+a)/R);for(let o=0;o<W;++o){const i=o-$,l=Math.max(0,Math.ceil(i/B)),d=Math.min(P,(_+i)/B);let u=0;for(let n=s;n<r;++n){const s=n*R-a;for(let a=l;a<d;++a){const r=x*e+S*n+T*a,o=F*(D-1-s)+M*(_-1-(a*B-i))+A*t;for(let e=0;e<G;++e){u+=N[r+(t*G+e)]*v[o+e]}}}g[b*e+I*n+y*o+t]=u}}return a.makeTensorInfo(k.shape,k.dtype,k.values)}};const Hn={kernelName:t.Diag,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{x:s}=n,r=t.util.sizeFromShape(s.shape),o=a.data.get(s.dataId).values,i=t.buffer([r,r],s.dtype),l=i.values;for(let e=0;e<o.length;e++)l[e*r+e]=o[e];const d=[...s.shape,...s.shape];return a.makeTensorInfo(d,i.dtype,i.values)}},Pn={kernelName:t.Dilation2D,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r}=e,{strides:o,pad:i,dilations:l}=a,d=n,u=d.data.get(s.dataId).values,c=s.shape.length,p=d.data.get(r.dataId).values,h=r.shape.length,{batchSize:f,inHeight:m,inWidth:k,inChannels:g,outHeight:b,outWidth:I,padInfo:y,strideHeight:N,strideWidth:x,filterHeight:S,filterWidth:T,dilationHeight:v,dilationWidth:F,outShape:M}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,o,i,"NHWC",l),A=t.util.sizeFromShape(M),w=M.length,D=t.util.getArrayFromDType(s.dtype,A);for(let e=0;e<f;++e)for(let n=0;n<b;++n){const a=n*N-y.top;for(let o=0;o<I;++o){const i=o*x-y.left;for(let l=0;l<g;++l){let d=Number.MIN_SAFE_INTEGER;for(let n=0;n<S;++n){const o=a+n*v;if(o>=0&&o<m)for(let a=0;a<T;++a){const f=i+a*F;if(f>=0&&f<k){const i=t.util.locToIndex([e,o,f,l],c,t.util.computeStrides(s.shape)),m=t.util.locToIndex([n,a,l],h,t.util.computeStrides(r.shape)),k=u[i]+p[m];k>d&&(d=k)}}}D[t.util.locToIndex([e,n,o,l],w,t.util.computeStrides(M))]=d}}}return{dataId:d.write(t.util.toTypedArray(D,s.dtype),M,s.dtype),shape:M,dtype:s.dtype}}},Rn={kernelName:t.Dilation2DBackpropFilter,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r,dy:o}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(r.shape,u.data.get(r.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:b,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:S,dilationHeight:T,dilationWidth:v,outShape:F}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,i,l,"NHWC",d);t.util.assert(o.rank===F.length,(()=>`Error in ${t.Dilation2DBackpropFilter}, dy must have the same rank as output ${F.length}, but got ${o.rank}`));const M=t.util.toNestedArray(F,u.data.get(o.dataId).values),A=t.util.makeZerosNestedTypedArray(r.shape,r.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const n=t*y-I.top;for(let a=0;a<b;++a){const s=a*N-I.left;for(let r=0;r<k;++r){let o=Number.MIN_SAFE_INTEGER,i=0,l=0;for(let t=0;t<x;++t){const a=n+t*T;if(a>=0&&a<f)for(let n=0;n<S;++n){const d=s+n*v;if(d>=0&&d<m){const s=c[e][a][d][r]+p[t][n][r];s>o&&(o=s,i=t,l=n)}}}A[i][l][r]+=M[e][t][a][r]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),r.shape,r.dtype),shape:r.shape,dtype:r.dtype}}},Bn={kernelName:t.Dilation2DBackpropInput,backendName:"cpu",kernelFunc:({inputs:e,backend:n,attrs:a})=>{const{x:s,filter:r,dy:o}=e,{strides:i,pad:l,dilations:d}=a,u=n,c=t.util.toNestedArray(s.shape,u.data.get(s.dataId).values),p=t.util.toNestedArray(r.shape,u.data.get(r.dataId).values),{batchSize:h,inHeight:f,inWidth:m,inChannels:k,outHeight:g,outWidth:b,padInfo:I,strideHeight:y,strideWidth:N,filterHeight:x,filterWidth:S,dilationHeight:T,dilationWidth:v,outShape:F}=t.backend_util.computeDilation2DInfo(s.shape,r.shape,i,l,"NHWC",d);t.util.assert(o.rank===F.length,(()=>`Error in ${t.Dilation2DBackpropInput}, dy must have the same rank as output ${F.length}, but got ${o.rank}`));const M=t.util.toNestedArray(F,u.data.get(o.dataId).values),A=t.util.makeZerosNestedTypedArray(s.shape,s.dtype);for(let e=0;e<h;++e)for(let t=0;t<g;++t){const n=t*y-I.top;for(let a=0;a<b;++a){const s=a*N-I.left;for(let r=0;r<k;++r){let o=Number.MIN_SAFE_INTEGER,i=n<0?0:n,l=s<0?0:s;for(let t=0;t<x;++t){const a=n+t*T;if(a>=0&&a<f)for(let n=0;n<S;++n){const d=s+n*v;if(d>=0&&d<m){const s=c[e][a][d][r]+p[t][n][r];s>o&&(o=s,i=a,l=d)}}}A[e][i][l][r]+=M[e][t][a][r]}}}return{dataId:u.write(t.util.toTypedArray(A,s.dtype),s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}};function On(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,keepDims:l}=s;let d;r(o,"sum"),d="bool"===o.dtype?b({inputs:{x:o},backend:a,attrs:{dtype:"int32"}}):f({inputs:{x:o},backend:a});const u=d.shape.length,c=t.util.parseAxisParam(i,d.shape),p=t.backend_util.getAxesPermutation(c,u);let m=c,k=d;null!=p&&(k=Ae({inputs:{x:d},backend:a,attrs:{perm:p}}),m=t.backend_util.getInnerMostAxes(m.length,u)),t.backend_util.assertAxesAreInnerMostDims("sum",m,k.shape.length);const[g,I]=t.backend_util.computeOutAndReduceShapes(k.shape,m);let y=h(a,g,t.backend_util.upcastType(k.dtype,"int32"));const N=t.util.sizeFromShape(I),x=a.data.get(y.dataId).values,S=a.data.get(k.dataId).values;for(let e=0;e<x.length;++e){const t=e*N;let n=0;for(let e=0;e<N;++e)n+=S[t+e];x[e]=n}if(l){const e=y;y=Ft({inputs:{x:y},backend:a,attrs:{shape:t.backend_util.expandShapeToKeepDim(y.shape,c)}}),a.disposeIntermediateTensorInfo(e)}return a.disposeIntermediateTensorInfo(d),null!=p&&a.disposeIntermediateTensorInfo(k),y}const $n={kernelName:t.Sum,backendName:"cpu",kernelFunc:On};const Gn={kernelName:t.Einsum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{equation:r}=s,o=n,{allDims:i,summedDims:l,idDims:d}=t.backend_util.decodeEinsumEquation(r,o.length);t.backend_util.checkEinsumDimSizes(i.length,d,o);const{path:u,steps:c}=t.backend_util.getEinsumComputePath(l,d),p=c.length;let h=null,f=i.length;const m=[];for(let e=0;e<p;++e){for(const n of c[e]){const{permutationIndices:e,expandDims:s}=t.backend_util.getEinsumPermutation(f,d[n]);let r;t.backend_util.isIdentityPermutation(e)?r=o[n]:(r=Ae({inputs:{x:o[n]},backend:a,attrs:{perm:e}}),m.push(r));const i=r.shape.slice();for(let e=0;e<s.length;++e)i.splice(s[e],0,1);t.util.arraysEqual(r.shape,i)||(r=Ft({inputs:{x:r},backend:a,attrs:{shape:i}}),m.push(r)),null===h?h=r:(h=ye({inputs:{a:r,b:h},backend:a}),m.push(h))}e<p-1&&(u[e]>=0&&(h=On({inputs:{x:h},backend:a,attrs:{axis:u[e]-(i.length-f),keepDims:!1}}),m.push(h)),f--)}for(const e of m)e!==h&&a.disposeIntermediateTensorInfo(e);return h}};const Ln={kernelName:t.EluGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{dy:s,y:o}=n;r([s,o],"eluGrad");const i=new Float32Array(t.util.sizeFromShape(o.shape)),l=a.data.get(o.dataId).values,d=a.data.get(s.dataId).values;for(let e=0;e<l.length;++e){const t=l[e];i[e]=t>=1?d[e]:d[e]*(t+1)}return a.makeTensorInfo(o.shape,"float32",i)}},Vn=t.backend_util.ERF_P,qn=t.backend_util.ERF_A1,Un=t.backend_util.ERF_A2,Zn=t.backend_util.ERF_A3,jn=t.backend_util.ERF_A4,Kn=t.backend_util.ERF_A5,Yn=w(t.Erf,(e=>{const t=Math.sign(e),n=Math.abs(e),a=1/(1+Vn*n);return t*(1-((((Kn*a+jn)*a+Zn)*a+Un)*a+qn)*a*Math.exp(-n*n))})),Jn={kernelName:t.Erf,backendName:"cpu",kernelFunc:Yn};function Qn(e){const{inputs:n,backend:a,attrs:s}=e,{input:r}=n,{dim:o}=s,i=r.shape.length,l=r.shape.slice();let d=o;return o<0&&(t.util.assert(-(i+1)<=o,(()=>`Axis must be in the interval [${-(i+1)}, ${i}]`)),d=i+o+1),l.splice(d,0,1),Ft({inputs:{x:r},backend:a,attrs:{shape:l}})}const Xn={kernelName:t.ExpandDims,backendName:"cpu",kernelFunc:Qn},ea=u(((e,t)=>e/t)),ta=y(t.RealDiv,ea),na={kernelName:t.RealDiv,backendName:"cpu",kernelFunc:ta};function aa(e,n,a){const s=e.shape,r=s[0],o=s[1],i=a.data.get(e.dataId),l=i.complexTensorInfos.real,d=i.complexTensorInfos.imag,u=[r,o],p=t.util.sizeFromShape(u),h=t.util.getTypedArrayFromDType("float32",p),f=t.util.getTypedArrayFromDType("float32",p);for(let e=0;e<r;e++){const s=$e({inputs:{x:l},backend:a,attrs:{begin:[e,0],size:[1,o]}}),r=$e({inputs:{x:d},backend:a,attrs:{begin:[e,0],size:[1,o]}}),i=c({inputs:{real:s,imag:r},backend:a}),{real:u,imag:p}=sa(i,n,a),m=t.backend_util.mergeRealAndImagArrays(u,p);for(let n=0;n<o;n++){const a=t.backend_util.getComplexWithIndex(m,n);h[e*o+n]=a.real,f[e*o+n]=a.imag}a.disposeIntermediateTensorInfo(s),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(i)}const m=a.makeTensorInfo(u,"float32",h),k=a.makeTensorInfo(u,"float32",f),g=c({inputs:{real:m,imag:k},backend:a});return a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}function sa(e,n,a){const s=t.util.sizeFromShape(e.shape),r=a.data.get(e.dataId),o=a.data.get(r.complexTensorInfos.real.dataId).values,i=a.data.get(r.complexTensorInfos.imag.dataId).values;if(0==((l=s)&l-1)){const r=ra(o,i,s,n,a),l=[e.shape[0],e.shape[1]];if(n){const e=a.makeTensorInfo(l,"float32",r.real),n=a.makeTensorInfo(l,"float32",r.imag),o=a.makeTensorInfo([],"float32",t.util.createScalarValue(s,"float32")),i=f({inputs:{x:o},backend:a}),d=na.kernelFunc({inputs:{a:e,b:o},backend:a}),u=na.kernelFunc({inputs:{a:n,b:i},backend:a}),c=a.data.get(d.dataId).values,p=a.data.get(u.dataId).values;return a.disposeIntermediateTensorInfo(e),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(o),a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(d),a.disposeIntermediateTensorInfo(u),{real:c,imag:p}}return r}{const e=function(e,n,a){const s=new Float32Array(2*n);for(let r=0;r<n;r++){let o=0,i=0;for(let s=0;s<n;s++){const l=t.backend_util.exponent(r*s,n,a),d=t.backend_util.getComplexWithIndex(e,s);o+=d.real*l.real-d.imag*l.imag,i+=d.real*l.imag+d.imag*l.real}a&&(o/=n,i/=n),t.backend_util.assignToTypedArray(s,o,i,r)}return s}(t.backend_util.mergeRealAndImagArrays(o,i),s,n);return t.backend_util.splitRealAndImagArrays(e)}var l}function ra(e,n,a,s,r){if(1===a)return{real:e,imag:n};const o=t.backend_util.mergeRealAndImagArrays(e,n),i=a/2,l=t.backend_util.complexWithEvenIndex(o),d=l.real,u=l.imag,p=[d.length],h=r.makeTensorInfo(p,"float32",d),f=r.makeTensorInfo(p,"float32",u),m=c({inputs:{real:h,imag:f},backend:r}),g=t.backend_util.complexWithOddIndex(o),b=g.real,I=g.imag,y=[b.length],N=r.makeTensorInfo(y,"float32",b),x=r.makeTensorInfo(y,"float32",I),S=c({inputs:{real:N,imag:x},backend:r}),v=ra(d,u,i,s,r),F=v.real,M=v.imag,A=[F.length],w=r.makeTensorInfo(A,"float32",F),D=r.makeTensorInfo(A,"float32",M),_=c({inputs:{real:w,imag:D},backend:r}),E=ra(b,I,i,s,r),z=E.real,W=E.imag,C=[z.length],H=r.makeTensorInfo(C,"float32",z),P=r.makeTensorInfo(C,"float32",W),R=c({inputs:{real:H,imag:P},backend:r}),B=t.backend_util.exponents(a,s),O=[B.real.length],$=r.makeTensorInfo(O,"float32",B.real),G=r.makeTensorInfo(O,"float32",B.imag),L=c({inputs:{real:$,imag:G},backend:r}),V=ye({inputs:{a:L,b:R},backend:r}),q=T({inputs:{a:_,b:V},backend:r}),U=ot({inputs:{a:_,b:V},backend:r}),Z=k({inputs:{input:q},backend:r}),j=k({inputs:{input:U},backend:r}),K=pn({inputs:{input:q},backend:r}),Y=pn({inputs:{input:U},backend:r}),J=fn({inputs:[Z,j],backend:r,attrs:{axis:0}}),Q=fn({inputs:[K,Y],backend:r,attrs:{axis:0}}),X=r.data.get(J.dataId).values,ee=r.data.get(Q.dataId).values;return r.disposeIntermediateTensorInfo(h),r.disposeIntermediateTensorInfo(f),r.disposeIntermediateTensorInfo(m),r.disposeIntermediateTensorInfo(N),r.disposeIntermediateTensorInfo(x),r.disposeIntermediateTensorInfo(S),r.disposeIntermediateTensorInfo(w),r.disposeIntermediateTensorInfo(D),r.disposeIntermediateTensorInfo(_),r.disposeIntermediateTensorInfo(H),r.disposeIntermediateTensorInfo(P),r.disposeIntermediateTensorInfo(R),r.disposeIntermediateTensorInfo($),r.disposeIntermediateTensorInfo(G),r.disposeIntermediateTensorInfo(L),r.disposeIntermediateTensorInfo(V),r.disposeIntermediateTensorInfo(q),r.disposeIntermediateTensorInfo(U),r.disposeIntermediateTensorInfo(Z),r.disposeIntermediateTensorInfo(K),r.disposeIntermediateTensorInfo(j),r.disposeIntermediateTensorInfo(Y),r.disposeIntermediateTensorInfo(J),r.disposeIntermediateTensorInfo(Q),{real:X,imag:ee}}const oa={kernelName:t.FFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,r=t.util.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=Ft({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),l=aa(i,!1,a),d=Ft({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}};function ia(e){const{backend:n,attrs:a}=e,{shape:s,value:r,dtype:o}=a,i=o||t.util.inferDtype(r),l=t.util.getArrayFromDType(i,t.util.sizeFromShape(s));return function(e,t,n){e.fill(t)}(l,r),n.makeTensorInfo(s,i,l)}const la={kernelName:t.Fill,backendName:"cpu",kernelFunc:ia};const da={kernelName:t.FlipLeftRight,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,r=a,o=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[i,l,d,u]=s.shape,c=r.data.get(s.dataId).values;for(let e=0;e<i;e++){const t=e*d*l*u;for(let e=0;e<l;e++){const n=e*(d*u);for(let e=0;e<d;e++){const a=e*u;for(let s=0;s<u;s++){const r=Math.round(d-e-1),i=t+n+a+s;let l=c[i];if(r>=0&&r<d){l=c[t+n+r*u+s]}o[i]=l}}}}return{dataId:r.write(o,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},ua=u(((e,t)=>Math.floor(e/t))),ca=y(t.FloorDiv,ua,null,"int32"),pa={kernelName:t.FloorDiv,backendName:"cpu",kernelFunc:ca};const ha={kernelName:t.FusedConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=kn({inputs:{x:s,filter:r},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(o){const e=m;if("NCHW"===u&&1===o.shape.length&&1!==o.shape[0]){const e=Ft({inputs:{x:o},backend:n,attrs:{shape:[o.shape[0],1,1]}});m=T({inputs:{a:m,b:e},backend:n}),n.disposeIntermediateTensorInfo(e)}else m=T({inputs:{a:m,b:o},backend:n});n.disposeIntermediateTensorInfo(e)}if(h){const e=m;if("NCHW"===u&&"prelu"===h&&1===i.shape.length&&1!==i.shape[0]){const e=Ft({inputs:{x:i},backend:n,attrs:{shape:[i.shape[0],1,1]}});m=vt(n,m,h,e,f),n.disposeIntermediateTensorInfo(e)}else m=vt(n,m,h,i,f);n.disposeIntermediateTensorInfo(e)}return m}};const fa={kernelName:t.FusedDepthwiseConv2D,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s,filter:r,bias:o,preluActivationWeights:i}=t,{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p,activation:h,leakyreluAlpha:f}=a;let m=En({inputs:{x:s,filter:r},backend:n,attrs:{strides:l,pad:d,dataFormat:u,dilations:c,dimRoundingMode:p}});if(o){const e=m;m=T({inputs:{a:m,b:o},backend:n}),n.disposeIntermediateTensorInfo(e)}if(h){const e=m;m=vt(n,m,h,i,f),n.disposeIntermediateTensorInfo(e)}return m}};const ma={kernelName:t.GatherNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{params:s,indices:r}=n,o=t.util.sizeFromShape(s.shape),i=r.shape,l=i[i.length-1],[d,u,c,p]=t.backend_util.prepareAndValidate(s,r);if(0===u)return a.makeTensorInfo(d,s.dtype,[]);const h=Z(a.data.get(r.dataId).values,a.bufferSync(s),s.dtype,u,l,c,p,s.shape,o);return a.makeTensorInfo(d,s.dtype,h.values)}};const ka={kernelName:t.GatherV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,indices:i}=n,{axis:l,batchDims:d}=s;r([o,i],"gatherV2");const u=t.util.parseAxisParam(l,o.shape)[0],c=a.data.get(i.dataId).values,p=o.shape[u];for(let e=0;e<c.length;++e){const n=c[e];t.util.assert(n<=p-1&&n>=0,(()=>`GatherV2: the index value ${n} is not in [0, ${p-1}]`))}let h=d;null==d&&(h=0);const f=t.util.sizeFromShape(i.shape),m=t.backend_util.segment_util.collectGatherOpShapeInfo(o,i,u,h),k=Ft({inputs:{x:o},backend:a,attrs:{shape:[m.batchSize,m.outerSize,m.dimSize,m.sliceSize]}}),g=Ft({inputs:{x:i},backend:a,attrs:{shape:[m.batchSize,f/m.batchSize]}}),b=[m.batchSize,m.outerSize,f/m.batchSize,m.sliceSize],I=a.bufferSync(g),y=j(a.bufferSync(k),I,b);return a.disposeIntermediateTensorInfo(k),a.disposeIntermediateTensorInfo(g),a.makeTensorInfo(m.outputShape,y.dtype,y.values)}};const ga={kernelName:t.IFFT,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{input:s}=n,r=t.util.sizeFromShape(s.shape),o=s.shape[s.shape.length-1],i=Ft({inputs:{x:s},backend:a,attrs:{shape:[r/o,o]}}),l=aa(i,!0,a),d=Ft({inputs:{x:l},backend:a,attrs:{shape:s.shape}});return a.disposeIntermediateTensorInfo(i),a.disposeIntermediateTensorInfo(l),d}},ba=w(t.IsFinite,(e=>Number.isFinite(e)?1:0),"bool"),Ia={kernelName:t.IsFinite,backendName:"cpu",kernelFunc:ba},ya=w(t.IsInf,(e=>Math.abs(e)===1/0?1:0),"bool"),Na={kernelName:t.IsInf,backendName:"cpu",kernelFunc:ya},xa=w(t.IsNan,(e=>Number.isNaN(e)?1:0),"bool"),Sa={kernelName:t.IsNan,backendName:"cpu",kernelFunc:xa};const Ta={kernelName:t.LinSpace,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,num:r}=n,o=ie(a,s,r);return t.makeTensorInfo([o.length],"float32",o)}},va=w(t.Log1p,(e=>Math.log1p(e))),Fa={kernelName:t.Log1p,backendName:"cpu",kernelFunc:va},Ma=u(((e,t)=>e&&t)),Aa=y(t.LogicalAnd,Ma,null,"bool"),wa={kernelName:t.LogicalAnd,backendName:"cpu",kernelFunc:Aa},Da=w(t.LogicalNot,(e=>e?0:1),"bool"),_a={kernelName:t.LogicalNot,backendName:"cpu",kernelFunc:Da},Ea=u(((e,t)=>e||t)),za=y(t.LogicalOr,Ea,null,"bool"),Wa={kernelName:t.LogicalOr,backendName:"cpu",kernelFunc:za};const Ca={kernelName:t.LRN,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{depthRadius:i,bias:l,alpha:d,beta:u}=s;r(o,"LRN");const c=o.shape[3],p=c-1,h=a.data.get(o.dataId).values,f=t.util.sizeFromShape(o.shape),m=new Float32Array(f);function k(e){const t=e%c;let n=e-t+Math.max(0,t-i);const a=e-t+Math.min(t+i,p);let s=0;for(;n<=a;n++){const e=h[n];s+=e*e}return s}for(let e=0;e<f;e++){const t=k(e),n=h[e]*Math.pow(l+d*t,-u);m[e]=n}return a.makeTensorInfo(o.shape,o.dtype,m)}};const Ha={kernelName:t.LRNGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,y:i,dy:l}=n,{depthRadius:d,bias:u,alpha:c,beta:p}=s;r(l,"LRNGrad");const h=t.util.sizeFromShape(l.shape),f=l.shape[3],m=a.data.get(l.dataId).values,k=a.data.get(o.dataId).values,g=a.data.get(i.dataId).values,b=new Float32Array(h),I=h;for(let e=0;e<I;e++){const t=e%f,n=e-t+Math.max(0,t-d),a=e-t+Math.min(f,t+d+1);let s=0;for(let e=n;e<a;e++)s+=Math.pow(k[e],2);s=c*s+u;for(let t=n;t<a;t++){let n=-2*c*p*k[t]*g[e]/s;e===t&&(n+=Math.pow(s,-p)),n*=m[e],b[t]+=n}}return a.makeTensorInfo(l.shape,o.dtype,b)}};function Pa(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{reductionIndices:i,keepDims:l}=s,d=a;let u=o.shape;const c=u.length,p=t.util.parseAxisParam(i,u);let h=p;const f=t.backend_util.getAxesPermutation(h,c);let m=d.data.get(o.dataId).values;if(null!=f){const e=new Array(c);for(let t=0;t<e.length;t++)e[t]=u[f[t]];m=Me(m,u,o.dtype,f,e),h=t.backend_util.getInnerMostAxes(h.length,c),u=e}r(o,"max"),t.backend_util.assertAxesAreInnerMostDims("max",h,c);const[k,g]=t.backend_util.computeOutAndReduceShapes(u,h),b=ce(m,t.util.sizeFromShape(g),k,o.dtype),I=d.write(b,k,o.dtype);let y=k;if(l){y=t.backend_util.expandShapeToKeepDim(k,p)}return{dataId:I,shape:y,dtype:o.dtype}}const Ra={kernelName:t.Max,backendName:"cpu",kernelFunc:Pa};const Ba={kernelName:t.MaxPool,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n;r(o,"maxPool");const{filterSize:i,strides:l,pad:d,dimRoundingMode:u}=s;t.util.assert(t.backend_util.eitherStridesOrDilationsAreOne(l,1),(()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${l} and dilations '1'`));const c=t.backend_util.computePool2DInfo(o.shape,i,l,1,d,u);let p;if(1===c.filterWidth&&1===c.filterHeight&&t.util.arraysEqual(c.inShape,c.outShape))p=f({inputs:{x:o},backend:a});else{const e=a.data.get(o.dataId).values,n=t.util.computeStrides(o.shape),s=Jt(e,o.shape,o.dtype,n,c,"max");p=a.makeTensorInfo(c.outShape,o.dtype,s.values)}return p}};const Oa={kernelName:t.MaxPool3D,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{filterSize:i,strides:l,pad:d,dimRoundingMode:u,dataFormat:c}=s;r(o,"maxPool3d");const p=t.backend_util.computePool3DInfo(o.shape,i,l,1,d,u,c),h=Xt(a.data.get(o.dataId).values,o.shape,o.dtype,t.util.computeStrides(o.shape),p,"max");return a.makeTensorInfo(h.shape,"float32",h.values)}};const $a={kernelName:t.MaxPool3DGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,input:i}=n,{filterSize:l,strides:d,pad:u,dimRoundingMode:c}=s;r([o,i],"maxPool3DGrad");const p=t.backend_util.computePool3DInfo(i.shape,l,d,1,u,c),h=function(e,n){const a=t.buffer(n.outShape,"int32"),s=n.strideDepth,r=n.strideHeight,o=n.strideWidth,i=n.dilationDepth,l=n.dilationHeight,d=n.dilationWidth,u=n.effectiveFilterDepth,c=n.effectiveFilterHeight,p=n.effectiveFilterWidth,h=n.padInfo.front,f=n.padInfo.top,m=n.padInfo.left;for(let t=0;t<n.batchSize;++t)for(let k=0;k<n.inChannels;++k)for(let g=0;g<n.outDepth;++g){const b=g*s-h;let I=b;for(;I<0;)I+=i;const y=Math.min(n.inDepth,u+b);for(let s=0;s<n.outHeight;++s){const u=s*r-f;let h=u;for(;h<0;)h+=l;const N=Math.min(n.inHeight,c+u);for(let r=0;r<n.outWidth;++r){const f=r*o-m;let x=f;for(;x<0;)x+=d;const S=Math.min(n.inWidth,p+f);let T=Number.NEGATIVE_INFINITY,v=-1;for(let n=I;n<y;n+=i){const a=n-b;for(let s=h;s<N;s+=l){const r=s-u;for(let o=x;o<S;o+=d){const i=o-f,l=e.get(t,n,s,o,k);l>=T&&(T=l,v=a*c*p+r*c+i)}}}a.set(v,t,g,s,r,k)}}}return a}(a.bufferSync(i),p),f=p.strideDepth,m=p.strideHeight,k=p.strideWidth,g=p.dilationDepth,b=p.dilationHeight,I=p.dilationWidth,y=p.effectiveFilterDepth,N=p.effectiveFilterHeight,x=p.effectiveFilterWidth,S=y-1-p.padInfo.front,T=x-1-p.padInfo.left,v=N-1-p.padInfo.top,F=t.buffer(i.shape,"float32"),M=a.bufferSync(o);for(let e=0;e<p.batchSize;++e)for(let t=0;t<p.inChannels;++t)for(let n=0;n<p.inDepth;++n)for(let a=0;a<p.inHeight;++a)for(let s=0;s<p.inWidth;++s){const r=n-S,o=a-v,i=s-T;let l=0;for(let n=0;n<y;n+=g){const a=(r+n)/f;if(!(a<0||a>=p.outDepth||Math.floor(a)!==a))for(let s=0;s<N;s+=b){const r=(o+s)/m;if(!(r<0||r>=p.outHeight||Math.floor(r)!==r))for(let o=0;o<x;o+=I){const d=(i+o)/k;if(d<0||d>=p.outWidth||Math.floor(d)!==d)continue;const u=y*N*x-1-h.get(e,a,r,d,t)===n*N*x+s*x+o?1:0;if(0===u)continue;l+=M.get(e,a,r,d,t)*u}}}F.set(l,e,n,a,s,t)}return a.makeTensorInfo(F.shape,F.dtype,F.values)}};const Ga={kernelName:t.MaxPoolGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{dy:o,input:i,output:l}=n,d=i;r([i,l],"maxPoolGrad");const{filterSize:u,strides:c,pad:p,dimRoundingMode:h}=s,f=t.backend_util.computePool2DInfo(d.shape,u,c,1,p,h),m=a.data.get(d.dataId).values,k=t.buffer(f.outShape,d.dtype,Qt(m,d.shape,d.dtype,f).values),g=f.strideHeight,b=f.strideWidth,I=f.dilationHeight,y=f.dilationWidth,N=f.effectiveFilterHeight,x=f.effectiveFilterWidth,S=x-1-f.padInfo.left,T=N-1-f.padInfo.top,v=t.buffer(d.shape,"float32"),F=a.data.get(o.dataId).values,M=t.buffer(o.shape,"float32",F);for(let e=0;e<f.batchSize;++e)for(let t=0;t<f.inChannels;++t)for(let n=0;n<f.inHeight;++n)for(let a=0;a<f.inWidth;++a){const s=n-T,r=a-S;let o=0;for(let n=0;n<N;n+=I){const a=(s+n)/g;if(!(a<0||a>=f.outHeight||Math.floor(a)!==a))for(let s=0;s<x;s+=y){const i=(r+s)/b;if(i<0||i>=f.outWidth||Math.floor(i)!==i)continue;const l=N*x-1-k.get(e,a,i,t)===n*x+s?1:0;if(0===l)continue;o+=M.get(e,a,i,t)*l}}v.set(o,e,n,a,t)}return a.makeTensorInfo(v.shape,v.dtype,v.values)}};const La={kernelName:t.MaxPoolWithArgmax,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{x:s}=e,{filterSize:o,strides:i,pad:l,includeBatchInIndex:d}=n,u=a;r(s,"MaxPoolWithArgmax");const c=u.data.get(s.dataId).values,p=t.backend_util.computePool2DInfo(s.shape,o,i,[1,1],l),[h,f]=function(e,n,a,s,r){const o=Jt(e,0,a,t.util.computeStrides(n),r,"max"),i=Qt(e,n,a,r,!0,s);return[o.values,i.values]}(c,s.shape,s.dtype,d,p),m=u.write(h,p.outShape,s.dtype),k=u.write(f,p.outShape,s.dtype);return[{dataId:m,shape:p.outShape,dtype:s.dtype},{dataId:k,shape:p.outShape,dtype:"int32"}]}};const Va={kernelName:t.Mean,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{axis:o,keepDims:i}=s,l=t.util.parseAxisParam(o,r.shape),d=t.backend_util.computeOutAndReduceShapes(r.shape,l)[1],u=t.util.sizeFromShape(d),c=[],p=a.makeTensorInfo([],"float32",new Float32Array([u]));c.push(p);const h=b({inputs:{x:r},backend:a,attrs:{dtype:"float32"}});c.push(h);const f=ta({inputs:{a:h,b:p},backend:a});c.push(f);const m=On({inputs:{x:f},backend:a,attrs:{axis:o,keepDims:i}});return c.forEach((e=>a.disposeIntermediateTensorInfo(e))),m}};const qa={kernelName:t.Min,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{axis:i,keepDims:l}=s;r(o,"min");const d=t.util.parseAxisParam(i,o.shape);let u=d;const c=t.backend_util.getAxesPermutation(u,o.shape.length);let p=o;null!=c&&(p=Ae({inputs:{x:o},backend:a,attrs:{perm:c}}),u=t.backend_util.getInnerMostAxes(u.length,o.shape.length)),t.backend_util.assertAxesAreInnerMostDims("min",u,p.shape.length);const[h,f]=t.backend_util.computeOutAndReduceShapes(p.shape,u),m=t.util.sizeFromShape(f),k=t.util.makeZerosTypedArray(t.util.sizeFromShape(h),p.dtype),g=a.data.get(p.dataId).values;for(let e=0;e<k.length;++e){const t=e*m;let n=g[t];for(let e=0;e<m;++e){const a=g[t+e];(Number.isNaN(a)||a<n)&&(n=a)}k[e]=n}null!=c&&a.disposeIntermediateTensorInfo(p);const b=a.makeTensorInfo(h,p.dtype,k);if(l){const e=Ft({inputs:{x:b},backend:a,attrs:{shape:t.backend_util.expandShapeToKeepDim(h,d)}});return a.disposeIntermediateTensorInfo(b),e}return b}};const Ua={kernelName:t.MirrorPad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{paddings:i,mode:l}=s;r(o,"mirrorPad");const d=i.map(((e,t)=>e[0]+o.shape[t]+e[1])),u=i.map((e=>e[0])),c=i.map(((e,t)=>e[0]+o.shape[t])),p="reflect"===l?0:1,h=a.data.get(o.dataId).values,f=o.shape.length,m=t.util.computeStrides(o.shape),k=t.util.sizeFromShape(d),g=d.length,b=t.util.computeStrides(d),I=t.util.getTypedArrayFromDType(o.dtype,k);for(let e=0;e<k;e++){let n=t.util.indexToLoc(e,g,b);for(let e=0;e<g;e++)n[e]<u[e]?n[e]=2*u[e]-n[e]-p:n[e]>=c[e]&&(n[e]=2*(c[e]-1)-n[e]+p);n=n.map(((e,t)=>e-u[t]));const a=t.util.locToIndex(n,f,m);I[e]=h[a]}return{dataId:a.write(I,d,o.dtype),shape:d,dtype:o.dtype}}},Za=u(((e,t)=>{const n=e%t;return e<0&&t<0||e>=0&&t>=0?n:(n+t)%t})),ja=y(t.Mod,Za),Ka={kernelName:t.Mod,backendName:"cpu",kernelFunc:ja};function Ya(e){const{inputs:n,backend:a,attrs:s}=e,{logits:r}=n,{dim:o}=s,i=r.shape.length;let l=o;if(-1===l&&(l=i-1),l!==i-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${i} and dim was ${l}`);const d=t.util.parseAxisParam([l],r.shape),u=Pa({inputs:{x:r},backend:a,attrs:{reductionIndices:d,keepDims:!1}}),c=t.backend_util.expandShapeToKeepDim(u.shape,d),p=Ft({inputs:{x:u},backend:a,attrs:{shape:c}}),h=ot({inputs:{a:r,b:p},backend:a}),f=B({inputs:{x:h},backend:a}),m=On({inputs:{x:f},backend:a,attrs:{axis:d,keepDims:!1}}),k=Ft({inputs:{x:m},backend:a,attrs:{shape:c}}),g=ta({inputs:{a:f,b:k},backend:a});return a.disposeIntermediateTensorInfo(u),a.disposeIntermediateTensorInfo(p),a.disposeIntermediateTensorInfo(h),a.disposeIntermediateTensorInfo(f),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}const Ja={kernelName:t.Softmax,backendName:"cpu",kernelFunc:Ya};const Qa={kernelName:t.Multinomial,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:o}=e,{logits:i}=n,{numSamples:l,seed:d,normalized:u}=o;r(i,"multinomial");const c=u?i:Ya({inputs:{logits:i},backend:a,attrs:{dim:-1}}),p=c.shape[0],h=c.shape[1],f=a.data.get(c.dataId).values,m=[p,l],k=t.util.makeZerosTypedArray(t.util.sizeFromShape(m),"int32");for(let e=0;e<p;++e){const t=e*h,n=new Float32Array(h-1);n[0]=f[t];for(let e=1;e<n.length;++e)n[e]=n[e-1]+f[t+e];const a=s.alea(d.toString()),r=e*l;for(let e=0;e<l;++e){const t=a();k[r+e]=n.length;for(let a=0;a<n.length;a++)if(t<n[a]){k[r+e]=a;break}}}return u||a.disposeIntermediateTensorInfo(c),a.makeTensorInfo(m,"int32",k)}},Xa=t.kernel_impls.nonMaxSuppressionV3Impl;const es={kernelName:t.NonMaxSuppressionV3,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d}=a;r(s,"NonMaxSuppression");const u=n.data.get(s.dataId).values,c=n.data.get(o.dataId).values,{selectedIndices:p}=Xa(u,c,i,l,d);return n.makeTensorInfo([p.length],"int32",new Int32Array(p))}},ts=t.kernel_impls.nonMaxSuppressionV4Impl;const ns={kernelName:t.NonMaxSuppressionV4,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,padToMaxOutputSize:u}=a;r(s,"NonMaxSuppressionPadded");const c=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,{selectedIndices:h,validOutputs:f}=ts(c,p,i,l,d,u);return[n.makeTensorInfo([h.length],"int32",new Int32Array(h)),n.makeTensorInfo([],"int32",new Int32Array([f]))]}},as=t.kernel_impls.nonMaxSuppressionV5Impl;const ss={kernelName:t.NonMaxSuppressionV5,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{boxes:s,scores:o}=t,{maxOutputSize:i,iouThreshold:l,scoreThreshold:d,softNmsSigma:u}=a;r(s,"NonMaxSuppressionWithScore");const c=n.data.get(s.dataId).values,p=n.data.get(o.dataId).values,h=i,f=l,m=d,k=u,{selectedIndices:g,selectedScores:b}=as(c,p,h,f,m,k);return[n.makeTensorInfo([g.length],"int32",new Int32Array(g)),n.makeTensorInfo([b.length],"float32",new Float32Array(b))]}};const rs={kernelName:t.OneHot,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{indices:o}=n,{depth:i,onValue:l,offValue:d}=s;r(o,"oneHot");const u=t.util.sizeFromShape(o.shape),c=new Float32Array(u*i);c.fill(d);const p=a.data.get(o.dataId).values;for(let e=0;e<u;++e)p[e]>=0&&p[e]<i&&(c[e*i+p[e]]=l);return a.makeTensorInfo([...o.shape,i],"int32",c)}};function os(e){const{inputs:t,backend:n}=e,{x:a}=t;if("string"===a.dtype)throw new Error("zerosLike is not supported for string tensors");if("complex64"===a.dtype){const e=k({inputs:{input:a},backend:n}),t=os({inputs:{x:e},backend:n}),s=pn({inputs:{input:a},backend:n}),r=os({inputs:{x:s},backend:n}),o=c({inputs:{real:t,imag:r},backend:n});return n.disposeIntermediateTensorInfo(e),n.disposeIntermediateTensorInfo(t),n.disposeIntermediateTensorInfo(s),n.disposeIntermediateTensorInfo(r),o}return ia({backend:n,attrs:{shape:a.shape,value:0,dtype:a.dtype}})}const is={kernelName:t.ZerosLike,backendName:"cpu",kernelFunc:os};const ls={kernelName:t.OnesLike,backendName:"cpu",kernelFunc:function e(t){const{inputs:n,backend:a}=t,{x:s}=n;if("string"===s.dtype)throw new Error("onesLike is not supported for string tensors");if("complex64"===s.dtype){const t=k({inputs:{input:s},backend:a}),n=e({inputs:{x:t},backend:a}),r=pn({inputs:{input:s},backend:a}),o=os({inputs:{x:r},backend:a}),i=c({inputs:{real:n,imag:o},backend:a});return a.disposeIntermediateTensorInfo(t),a.disposeIntermediateTensorInfo(n),a.disposeIntermediateTensorInfo(r),a.disposeIntermediateTensorInfo(o),i}return ia({backend:a,attrs:{shape:s.shape,value:1,dtype:s.dtype}})}};function ds(e){const{inputs:n,backend:a,attrs:s}=e,{axis:r}=s;if(1===n.length)return Qn({inputs:{input:n[0]},backend:a,attrs:{dim:r}});const o=n[0].shape,i=n[0].dtype;n.forEach((e=>{t.util.assertShapesMatch(o,e.shape,"All tensors passed to stack must have matching shapes"),t.util.assert(i===e.dtype,(()=>"All tensors passed to stack must have matching dtypes"))}));const l=[],d=fn({inputs:n.map((e=>{const t=Qn({inputs:{input:e},backend:a,attrs:{dim:r}});return l.push(t),t})),backend:a,attrs:{axis:r}});return l.forEach((e=>a.disposeIntermediateTensorInfo(e))),d}const us={kernelName:t.Pack,backendName:"cpu",kernelFunc:ds};const cs={kernelName:t.PadV2,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{paddings:i,constantValue:l}=s;r(o,"pad");const d=i.map(((e,t)=>e[0]+o.shape[t]+e[1])),u=i.map((e=>e[0])),c=a.data.get(o.dataId).values,p=t.util.sizeFromShape(o.shape),h=o.shape.length,f=t.util.computeStrides(o.shape),m=t.util.sizeFromShape(d),k=d.length,g=t.util.computeStrides(d),b=t.util.getTypedArrayFromDType(o.dtype,m);0!==l&&b.fill(l);for(let e=0;e<p;e++){const n=t.util.indexToLoc(e,h,f).map(((e,t)=>e+u[t]));b[t.util.locToIndex(n,k,g)]=c[e]}return{dataId:a.write(b,d,o.dtype),shape:d,dtype:o.dtype}}},ps=u(((e,t)=>Math.pow(e,t))),hs=y(t.Pow,ps),fs={kernelName:t.Pow,backendName:"cpu",kernelFunc:hs};const ms={kernelName:t.Range,backendName:"cpu",kernelFunc:function(e){const{backend:t,attrs:n}=e,{start:a,stop:s,dtype:r,step:o}=n,i=Ee(a,s,o,r);return t.makeTensorInfo([i.length],r,i)}},ks=w(t.Reciprocal,(e=>1/e)),gs={kernelName:t.Reciprocal,backendName:"cpu",kernelFunc:ks};const bs={kernelName:t.ResizeBilinear,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{images:o}=n,{alignCorners:i,halfPixelCenters:l,size:d}=s;r(o,"resizeBilinear");const u=t.util.computeStrides(o.shape),[c,p]=d,[h,f,m,k]=o.shape,g=a.data.get(o.dataId).values,b=new Float32Array(t.util.sizeFromShape([h,c,p,k])),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p];let N=0;const x=I[0]/y[0],S=I[1]/y[1];for(let e=0;e<h;e++)for(let t=0;t<c;t++){let n;n=l?x*(t+.5)-.5:x*t;const a=Math.max(0,Math.floor(n)),s=n-a,r=Math.min(f-1,Math.ceil(n)),o=e*u[0]+a*u[1],i=e*u[0]+r*u[1];for(let e=0;e<p;e++){let t;t=l?S*(e+.5)-.5:S*e;const n=Math.max(0,Math.floor(t)),a=t-n,r=Math.min(m-1,Math.ceil(t)),d=o+n*u[2],c=i+n*u[2],p=o+r*u[2],h=i+r*u[2];for(let e=0;e<k;e++){const t=g[d+e],n=g[c+e],r=t+(g[p+e]-t)*a,o=r+(n+(g[h+e]-n)*a-r)*s;b[N++]=o}}}return a.makeTensorInfo([h,c,p,k],"float32",b)}};const Is={kernelName:t.ResizeBilinearGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{images:o,dy:i}=n,{alignCorners:l}=s;r([i,o],"resizeBilinearGrad");const d=t.util.computeStrides(o.shape),[u,c,p,h]=o.shape,[,f,m]=i.shape,k=new Float32Array(u*c*p*h),g=[l&&f>1?c-1:c,l&&m>1?p-1:p],b=[l&&f>1?f-1:f,l&&m>1?m-1:m],I=g[0]/b[0],y=g[1]/b[1],N=a.data.get(i.dataId).values;let x=0;for(let e=0;e<u;e++){const t=e*d[0];for(let e=0;e<f;e++){const n=e*I,a=Math.floor(n),s=Math.min(Math.ceil(n),c-1),r=t+a*d[1],o=t+s*d[1],i=n-a,l=1-i;for(let e=0;e<m;e++){const t=e*y,n=Math.floor(t),a=Math.min(Math.ceil(t),p-1),s=t-n,u=1-s,c=r+n*d[2],f=r+a*d[2],m=o+n*d[2],g=o+a*d[2],b=l*u,I=l*s,S=i*u,T=i*s;for(let e=0;e<h;e++){const t=N[x++];k[c+e]+=t*b,k[f+e]+=t*I,k[m+e]+=t*S,k[g+e]+=t*T}}}}return a.makeTensorInfo([u,p,c,h],"float32",k)}};const ys={kernelName:t.ResizeNearestNeighbor,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{images:o}=n,{alignCorners:i,halfPixelCenters:l,size:d}=s;r(o,"resizeNearestNeighbor");const u=t.util.computeStrides(o.shape),[c,p]=d,[h,f,m,k]=o.shape,g=a.data.get(o.dataId).values,b=new Float32Array(h*c*p*k),I=[i&&c>1?f-1:f,i&&p>1?m-1:m],y=[i&&c>1?c-1:c,i&&p>1?p-1:p],N=I[0]/y[0],x=I[1]/y[1];let S=0;for(let e=0;e<h;e++){const t=e*u[0];for(let e=0;e<c;e++){const n=l?N*(e+.5):N*e;let a=Math.min(f-1,i?Math.round(n):Math.floor(n));l&&(a=Math.max(0,a));const s=t+a*u[1];for(let e=0;e<p;e++){const t=l?x*(e+.5):x*e;let n=Math.min(m-1,i?Math.round(t):Math.floor(t));l&&(n=Math.max(0,n));const a=s+n*u[2];for(let e=0;e<k;e++){const t=g[a+e];b[S++]=t}}}}return a.makeTensorInfo([h,c,p,k],o.dtype,b)}};const Ns={kernelName:t.ResizeNearestNeighborGrad,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{images:o,dy:i}=n,{alignCorners:l}=s;r([i,o],"resizeNearestNeighborGrad");const d=t.util.computeStrides(o.shape),u=t.util.computeStrides(i.shape),[c,p,h,f]=o.shape,[,m,k]=i.shape,g=new Float32Array(c*p*h*f),b=a.data.get(i.dataId).values,I=[l&&m>1?p-1:p,l&&k>1?h-1:h],y=[l&&m>1?m-1:m,l&&k>1?k-1:k],N=I[0]/y[0],x=I[1]/y[1],S=1/N,T=1/x,v=2*Math.ceil(S)+2,F=2*Math.ceil(T)+2;for(let e=0;e<c;e++){const t=e*d[0];for(let e=0;e<p;e++){const n=t+e*d[1],a=Math.floor(e*S),s=Math.floor(a-v/2);for(let a=0;a<h;a++){const r=n+a*d[2],o=Math.floor(a*T),i=Math.floor(o-F/2);for(let n=0;n<f;n++){let o=0;for(let r=0;r<v;r++){const d=r+s;if(d<0||d>=m)continue;const c=t+d*u[1],f=d*N;if(e===Math.min(p-1,l?Math.round(f):Math.floor(f)))for(let e=0;e<F;e++){const t=e+i;if(t<0||t>=k)continue;const s=c+t*u[2],r=t*x;a===Math.min(h-1,l?Math.round(r):Math.floor(r))&&(o+=b[s+n])}}g[r+n]=o}}}}return a.makeTensorInfo(o.shape,o.dtype,g)}};const xs={kernelName:t.Reverse,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{dims:i}=s;r(o,"reverse");const l=o.shape.length,d=t.util.parseAxisParam(i,o.shape);if(0===l)return f({inputs:{x:o},backend:a});const u=new t.TensorBuffer(o.shape,o.dtype),c=a.bufferSync(o);for(let e=0;e<u.size;e++){const t=u.indexToLoc(e),n=t.slice();d.forEach((e=>n[e]=o.shape[e]-1-n[e])),u.set(c.get(...n),...t)}return a.makeTensorInfo(u.shape,u.dtype,u.values)}},Ss={kernelName:t.RotateWithOffset,backendName:"cpu",kernelFunc:({inputs:e,attrs:n,backend:a})=>{const{image:s}=e,{radians:r,fillValue:o,center:i}=n,l=a,d=t.util.getTypedArrayFromDType(s.dtype,t.util.sizeFromShape(s.shape)),[u,c,p,h]=s.shape,[f,m]=t.backend_util.getImageCenter(i,c,p),k=Math.sin(r),g=Math.cos(r),b=l.data.get(s.dataId).values;for(let e=0;e<u;e++){const t=e*p*c*h;for(let e=0;e<c;e++){const n=e*(p*h);for(let a=0;a<p;a++){const s=a*h;for(let r=0;r<h;r++){const i=[u,e,a,r],l=i[2],I=i[1];let y=(l-f)*g-(I-m)*k,N=(l-f)*k+(I-m)*g;y=Math.round(y+f),N=Math.round(N+m);let x=o;if("number"!=typeof o&&(x=3===r?255:o[r]),y>=0&&y<p&&N>=0&&N<c){x=b[t+N*(p*h)+y*h+r]}d[t+n+s+r]=x}}}}return{dataId:l.write(d,s.shape,s.dtype),shape:s.shape,dtype:s.dtype}}},Ts=w(t.Round,(e=>{const t=Math.floor(e);return e-t<.5?Math.floor(e):e-t>.5?Math.ceil(e):t%2==0?t:t+1})),vs={kernelName:t.Round,backendName:"cpu",kernelFunc:Ts};const Fs={kernelName:t.ScatterNd,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{indices:r,updates:o}=n,{shape:i}=s,{sliceRank:l,numUpdates:d,sliceSize:u,strides:c,outputSize:p}=t.backend_util.calculateShapes(o,r,i),h=He(a.bufferSync(r),a.bufferSync(o),i,p,u,d,l,c,0,!0);return a.makeTensorInfo(i,h.dtype,h.values)}};function Ms(e,t){let n=0,a=e.length,s=0;for(;n<a;)s=Math.floor((n+a)/2),e[s]<t?n=s+1:a=s;return a}function As(e,t){let n=0,a=e.length,s=0;for(;n<a;)s=Math.floor((n+a)/2),e[s]<=t?n=s+1:a=s;return a}const ws={kernelName:t.SearchSorted,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{sortedSequence:r,values:o}=n,{side:i}=s,l=function(e,n,a,s,r,o){const i=t.util.getArrayFromDType("int32",a*r);for(let t=0;t<a;++t){const a=e.slice(t*s,(t+1)*s),l=t*r;for(let e=0;e<r;++e)i[l+e]="left"===o?Ms(a,n[e+l]):As(a,n[e+l])}return i}(a.data.get(r.dataId).values,a.data.get(o.dataId).values,r.shape[0],r.shape[1],o.shape[1],i);return a.makeTensorInfo(o.shape,"int32",l)}};const Ds={kernelName:t.Select,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a}=e,{condition:s,t:o,e:i}=n;r([s,o,i],"select");const l=s.shape.length,d=a.data.get(s.dataId).values,u=a.data.get(o.dataId).values,c=a.data.get(i.dataId).values,p=t.upcastType(o.dtype,i.dtype),h=t.util.makeZerosTypedArray(t.util.sizeFromShape(o.shape),p);let f=0;const m=0===l||l>1||1===o.shape.length?1:t.util.sizeFromShape(o.shape.slice(1));for(let e=0;e<d.length;e++)for(let t=0;t<m;t++)1===d[e]?h[f++]=u[e]:h[f++]=c[e];return a.makeTensorInfo(o.shape,p,h)}},_s=t.backend_util.SELU_SCALEALPHA,Es=t.backend_util.SELU_SCALE,zs=w(t.Selu,(e=>e>=0?Es*e:_s*(Math.exp(e)-1))),Ws={kernelName:t.Selu,backendName:"cpu",kernelFunc:zs},Cs=w(t.Sign,(e=>e<0?-1:e>0?1:0)),Hs={kernelName:t.Sign,backendName:"cpu",kernelFunc:Cs},Ps=w(t.Sin,(e=>Math.sin(e))),Rs={kernelName:t.Sin,backendName:"cpu",kernelFunc:Ps},Bs=w(t.Sinh,(e=>Math.sinh(e))),Os={kernelName:t.Sinh,backendName:"cpu",kernelFunc:Bs},$s=Math.log(1.1920928955078125e-7)+2,Gs=w(t.Softplus,(e=>{const t=e>-$s,n=e<$s,a=Math.exp(e);let s;return s=n?a:t?e:Math.log(1+a),s})),Ls={kernelName:t.Softplus,backendName:"cpu",kernelFunc:Gs};const Vs={kernelName:t.SpaceToBatchND,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{blockShape:i,paddings:l}=s;r([o],"spaceToBatchND");const d=t.util.sizeFromShape(i),u=[[0,0]];u.push(...l);for(let e=1+i.length;e<o.shape.length;++e)u.push([0,0]);const c=cs.kernelFunc({inputs:{x:o},backend:a,attrs:{paddings:u,constantValue:0}}),p=t.backend_util.getReshaped(c.shape,i,d,!1),h=t.backend_util.getPermuted(p.length,i.length,!1),f=t.backend_util.getReshapedPermuted(c.shape,i,d,!1),m=Ft({inputs:{x:c},backend:a,attrs:{shape:p}}),k=Ae({inputs:{x:m},backend:a,attrs:{perm:h}}),g=Ft({inputs:{x:k},backend:a,attrs:{shape:f}});return a.disposeIntermediateTensorInfo(c),a.disposeIntermediateTensorInfo(m),a.disposeIntermediateTensorInfo(k),g}};const qs={kernelName:t.SparseFillEmptyRows,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{indices:a,values:s,denseShape:r,defaultValue:o}=t;if(1!==r.shape.length)throw new Error(`Dense shape must be a vector, saw:\n        ${r.shape}`);if(2!==a.shape.length)throw new Error(`Indices must be a matrix, saw:\n        ${a.shape}`);if(1!==s.shape.length)throw new Error(`Values must be a vector, saw:\n        ${s.shape}`);if(0!==o.shape.length)throw new Error(`Default value must be a scalar, saw:\n        ${o.shape}`);const i=n.data.get(a.dataId).values,l=n.data.get(s.dataId).values,d=n.data.get(r.dataId).values,u=n.data.get(o.dataId).values[0],[c,p,h,f,m]=Le(i,a.shape,a.dtype,l,s.dtype,d,u);return[n.makeTensorInfo(p,a.dtype,c),n.makeTensorInfo([p[0]],s.dtype,h),n.makeTensorInfo([f.length],"bool",new Uint8Array(f.map((e=>Number(e))))),n.makeTensorInfo([m.length],a.dtype,new Int32Array(m))]}};const Us={kernelName:t.SparseReshape,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{inputIndices:a,inputShape:s,newShape:r}=t;if(2!==a.shape.length)throw new Error(`Input indices should be a matrix but received shape\n        ${a.shape}`);if(1!==s.shape.length)throw new Error(`Input shape should be a vector but received shape\n        ${s.shape}`);if(1!==r.shape.length)throw new Error(`Target shape should be a vector but received shape ${r.shape}`);const o=Array.from(n.data.get(s.dataId).values),i=n.data.get(a.dataId).values,l=Array.from(n.data.get(r.dataId).values),[d,u,c]=Ve(i,a.shape,a.dtype,o,l);return[n.makeTensorInfo(u,a.dtype,d),n.makeTensorInfo([c.length],r.dtype,new Int32Array(c))]}};const Zs={kernelName:t.SparseSegmentMean,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error(`Indices should be a vector but received shape\n          ${s.shape}`);if(1!==r.shape.length)throw new Error(`Segment ids should be a vector but received shape\n          ${r.shape}`);if(s.shape[0]!==r.shape[0])throw new Error("segmentIds and indices should have same size.");const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,[d,u]=qe(o,a.shape,a.dtype,i,l,!0);return n.makeTensorInfo(u,a.dtype,d)}};const js={kernelName:t.SparseSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n}=e,{data:a,indices:s,segmentIds:r}=t;if(a.shape.length<1)throw new Error("Data should be at least 1 dimensional but received scalar");if(1!==s.shape.length)throw new Error(`Indices should be a vector but received shape\n         ${s.shape}`);if(1!==r.shape.length)throw new Error(`Segment ids should be a vector but received shape\n         ${r.shape}`);if(s.shape[0]!==r.shape[0])throw new Error("segmentIds and indices should have same size.");const o=n.data.get(a.dataId).values,i=n.data.get(s.dataId).values,l=n.data.get(r.dataId).values,[d,u]=qe(o,a.shape,a.dtype,i,l);return n.makeTensorInfo(u,a.dtype,d)}};const Ks={kernelName:t.SparseToDense,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{sparseIndices:r,sparseValues:o,defaultValue:i}=n,{outputShape:l}=s,{sliceRank:d,numUpdates:u,sliceSize:c,strides:p,outputSize:h}=t.backend_util.calculateShapes(o,r,l),f=!1,m=a.bufferSync(r);let k;switch(o.dtype){case"bool":k=He(m,a.bufferSync(o),l,h,c,u,d,p,Boolean(a.data.get(i.dataId).values[0]),f);break;case"float32":k=He(m,a.bufferSync(o),l,h,c,u,d,p,a.data.get(i.dataId).values[0],f);break;case"int32":k=He(m,a.bufferSync(o),l,h,c,u,d,p,a.data.get(i.dataId).values[0],f);break;case"string":k=He(m,a.bufferSync(o),l,h,c,u,d,p,t.util.decodeString(a.data.get(i.dataId).values[0]),f);break;default:throw new Error(`Unsupported type ${o.dtype}`)}return a.makeTensorInfo(l,k.dtype,k.values)}};const Ys={kernelName:t.SplitV,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:r}=n,{numOrSizeSplits:o,axis:i}=s,l=t.util.parseAxisParam(i,r.shape)[0],d=t.backend_util.prepareSplitSize(r,o,l),u=new Array(r.shape.length).fill(0),c=r.shape.slice();return d.map((e=>{const t=[...c];t[l]=e;const n=$e({inputs:{x:r},backend:a,attrs:{begin:u,size:t}});return u[l]+=e,n}))}},Js={kernelName:t.Square,backendName:"cpu",kernelFunc:({inputs:e,backend:t})=>{const{x:n}=e,a=t;r(n,"square");const s=a.data.get(n.dataId).values,o=new Float32Array(s.length);for(let e=0;e<s.length;++e){const t=s[e];o[e]=t*t}return{dataId:a.write(o,n.shape,n.dtype),shape:n.shape,dtype:n.dtype}}},Qs=w(t.Step,((e,t)=>{const n=t;return isNaN(e)?NaN:e>0?1:n.alpha})),Xs={kernelName:t.Step,backendName:"cpu",kernelFunc:Qs};const er={kernelName:t.StridedSlice,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o}=n,{begin:i,end:l,strides:d,beginMask:u,endMask:c,ellipsisMask:p,newAxisMask:h,shrinkAxisMask:f}=s;r(o,"stridedSlice");const{finalShapeSparse:m,finalShape:k,isIdentity:g,sliceDim0:b,isSimpleSlice:I,begin:y,end:N,strides:x}=t.slice_util.sliceInfo(o.shape,i,l,d,u,c,p,h,f);let S;if(g)S=Ft({inputs:{x:o},backend:a,attrs:{shape:k}});else if(b||I){t.util.assert(o.shape.length>=1,(()=>`Input must have rank at least 1, got: ${o.shape.length}`));const e=t.slice_util.computeOutShape(y,N,x),n=$e({inputs:{x:o},backend:a,attrs:{begin:y,size:e}});S=Ft({inputs:{x:n},backend:a,attrs:{shape:k}}),a.disposeIntermediateTensorInfo(n)}else{const e=Qe(m,a.bufferSync(o),x,y);S=a.makeTensorInfo(k,e.dtype,e.values)}return S}};const tr={kernelName:t.StringNGrams,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{separator:s,nGramWidths:r,leftPad:o,rightPad:i,padWidth:l,preserveShortSequences:d}=a,{data:u,dataSplits:c}=t,p=n.data.get(u.dataId).values,h=n.data.get(c.dataId).values,[f,m]=et(p,h,s,r,o,i,l,d);return[n.makeTensorInfo([f.length],"string",f),n.makeTensorInfo(c.shape,"int32",m)]}};const nr={kernelName:t.StringSplit,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{skipEmpty:s}=a,{input:r,delimiter:o}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(1!==r.shape.length)throw new Error(`Input must be a vector, got shape: ${r.shape}`);if(0!==o.shape.length)throw new Error(`Delimiter must be a scalar, got shape: ${o.shape}`);const i=n.data.get(r.dataId).values,l=n.data.get(o.dataId).values[0],[d,u,c]=nt(i,l,s),p=u.length;return[n.makeTensorInfo([p,2],"int32",d),n.makeTensorInfo([p],"string",u),n.makeTensorInfo([2],"int32",new Int32Array(c))]}};const ar={kernelName:t.StringToHashBucketFast,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{numBuckets:s}=a,{input:r}=t;if("string"!==r.dtype)throw new Error("Input must be of datatype string");if(s<=0)throw new Error("Number of buckets must be at least 1");const o=at(n.data.get(r.dataId).values,s);return n.makeTensorInfo(r.shape,"int32",o)}},sr=w(t.Tan,(e=>Math.tan(e))),rr={kernelName:t.Tan,backendName:"cpu",kernelFunc:sr},or=w(t.Tanh,(e=>Math.tanh(e))),ir={kernelName:t.Tanh,backendName:"cpu",kernelFunc:or};const lr={kernelName:t.Tile,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{reps:o}=a;r(s,"tile");const i=lt(n.bufferSync(s),o);return n.makeTensorInfo(i.shape,i.dtype,i.values)}};const dr={kernelName:t.TopK,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{x:s}=t,{k:o,sorted:i}=a;r(s,"topk");const l=n.data.get(s.dataId).values,[d,u]=ct(l,s.shape,s.dtype,o,i);return[n.makeTensorInfo(d.shape,d.dtype,d.values),n.makeTensorInfo(u.shape,u.dtype,u.values)]}};const ur={kernelName:t.Transform,backendName:"cpu",kernelFunc:function(e){const{inputs:n,attrs:a,backend:s}=e,{image:r,transforms:o}=n,{interpolation:i,fillMode:l,fillValue:d,outputShape:u}=a,[c,p,h,f]=r.shape,[m,k]=null!=u?u:[p,h],g=[c,m,k,f],b=t.util.computeStrides(r.shape),I=b[0],y=b[1],N=b[2],x=t.util.getTypedArrayFromDType(r.dtype,t.util.sizeFromShape(g));x.fill(d);const S=s.data.get(r.dataId).values,T=s.data.get(o.dataId).values;for(let e=0;e<c;++e){const t=1===o.shape[0]?T:T.subarray(8*e,8*e+8);for(let n=0;n<m;++n)for(let a=0;a<k;++a)for(let s=0;s<f;++s){let r;const o=t[6]*a+t[7]*n+1;if(0===o)continue;const u=(t[0]*a+t[1]*n+t[2])/o,c=(t[3]*a+t[4]*n+t[5])/o,f=cr(u,h,l),m=cr(c,p,l);switch(i){case"nearest":r=hr(S,p,h,I,y,N,e,m,f,s,d);break;case"bilinear":r=fr(S,p,h,I,y,N,e,m,f,s,d);break;default:throw new Error(`Error in Transform: Expect 'nearest' or 'bilinear', but got ${i}`)}x[e*I+n*y+a*N+s]=r}return s.makeTensorInfo(g,r.dtype,x)}return{dataId:s.write(x,g,r.dtype),shape:r.shape,dtype:r.dtype}}};function cr(e,n,a){switch(a){case"reflect":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=2*n;a<e&&(a=e*Math.trunc(-a/e)+a),a=a<-n?a+e:-a-1}else if(a>n-1)if(n<=1)a=0;else{const e=2*n;a-=e*Math.trunc(a/e),a>=n&&(a=e-a-1)}return t.util.clamp(0,a,n-1)}(e,n);case"wrap":return function(e,n){let a=e;if(a<0)if(n<=1)a=0;else{const e=n-1;a+=n*(Math.trunc(-a/e)+1)}else if(a>n-1)if(n<=1)a=0;else{const e=n-1;a-=n*Math.trunc(a/e)}return t.util.clamp(0,a,n-1)}(e,n);case"nearest":return function(e,n){return t.util.clamp(0,e,n-1)}(e,n);default:return function(e,t){return e}(e)}}function pr(e,t,n,a,s,r,o,i,l,d,u){return 0<=i&&i<t&&0<=l&&l<n?e[o*a+i*s+l*r+d]:u}function hr(e,t,n,a,s,r,o,i,l,d,u){return pr(e,t,n,a,s,r,o,Math.round(i),Math.round(l),d,u)}function fr(e,t,n,a,s,r,o,i,l,d,u){const c=Math.floor(i),p=Math.floor(l),h=c+1,f=p+1;return(h-i)*((f-l)*pr(e,t,n,a,s,r,o,c,p,d,u)+(l-p)*pr(e,t,n,a,s,r,o,c,f,d,u))+(i-c)*((f-l)*pr(e,t,n,a,s,r,o,h,p,d,u)+(l-p)*pr(e,t,n,a,s,r,o,h,f,d,u))}const mr={kernelName:t.Unique,backendName:"cpu",kernelFunc:function(e){const{inputs:t,attrs:n,backend:a}=e,{axis:s}=n,{x:o}=t;r(o,"unique");const i=a.data.get(o.dataId).values,{outputValues:l,outputShape:d,indices:u}=pt(i,s,o.shape,o.dtype);return[a.makeTensorInfo(d,o.dtype,l),a.makeTensorInfo([u.length],"int32",u)]}};const kr={kernelName:t.Unpack,backendName:"cpu",kernelFunc:function(e){const{inputs:t,backend:n,attrs:a}=e,{value:s}=t;let{axis:r}=a;r<0&&(r+=s.shape.length);const o=s.shape.length,i=s.shape[r],l=new Array(o-1);let d=0;for(let e=0;e<o;e++)e!==r&&(l[d++]=s.shape[e]);const u=new Array(o).fill(0),c=s.shape.slice();c[r]=1;const p=new Array(i);for(let e=0;e<p.length;e++){u[r]=e;const t=$e({inputs:{x:s},backend:n,attrs:{begin:u,size:c}});p[e]=Ft({inputs:{x:t},backend:n,attrs:{shape:l}}),n.disposeIntermediateTensorInfo(t)}return p}};const gr={kernelName:t.UnsortedSegmentSum,backendName:"cpu",kernelFunc:function(e){const{inputs:n,backend:a,attrs:s}=e,{x:o,segmentIds:i}=n,{numSegments:l}=s;r(o,"unsortedSegmentSum");const d=[],u=[],c=o.shape.length-i.shape.length;let p=i;for(let e=0;e<c;++e){const t=Qn({inputs:{input:p},backend:a,attrs:{dim:e+1}});p=t,u.push(t)}for(let e=0;e<l;++e){const n=t.util.createScalarValue(e,"int32"),s=a.makeTensorInfo([],"int32",n),r=H({inputs:{a:s,b:p},backend:a}),i=b({inputs:{x:r},backend:a,attrs:{dtype:"float32"}}),l=ye({inputs:{a:i,b:o},backend:a}),c=On({inputs:{x:l},backend:a,attrs:{axis:0,keepDims:!1}});d.push(c),u.push(s),u.push(r),u.push(i),u.push(l),u.push(c)}const h=ds({inputs:d,backend:a,attrs:{axis:0}});return u.forEach((e=>a.disposeIntermediateTensorInfo(e))),h}},br=[Dt,d,Et,Wt,v,Ct,Ht,Pt,Rt,Bt,$t,Lt,qt,jt,Yt,en,tn,nn,an,wt,sn,rn,on,ln,I,z,un,p,cn,mn,gn,bn,In,yn,Nn,xn,Tn,Fn,Mn,An,wn,Dn,_n,zn,Wn,Cn,Hn,Pn,Rn,Bn,Gn,mt,Ln,P,Jn,O,Xn,L,oa,la,da,U,pa,ha,fa,ma,ka,J,ee,m,ga,hn,Ia,Na,Sa,gt,ae,oe,Ta,ue,Fa,wa,_a,Wa,Ca,Ha,Ra,fe,Ba,Oa,$a,Ga,La,Va,qa,ge,Ua,Ka,Qa,Ne,Se,es,ns,ss,Fe,rs,ls,us,cs,fs,yt,_e,ms,g,na,gs,xt,Tt,Mt,bs,Is,ys,Ns,xs,Ss,vs,Ce,Fs,ws,Ds,Ws,Be,Hs,Rs,Os,Ge,Ja,Ls,Vs,qs,Us,Zs,js,Ks,Ys,je,Js,Je,Xs,er,tr,nr,ar,it,$n,rr,ir,lr,dr,ur,we,mr,kr,gr,is];for(const e of br)t.registerKernel(e);e.MathBackendCPU=i,e.shared=ht,e.version_cpu="3.19.0",Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-backend-cpu.es2017.min.js.map
