"use strict";
/**
 * @license
 * Copyright 2019 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
var nodejs_kernel_backend_1 = require("../nodejs_kernel_backend");
// TODO(nsthorat, dsmilkov): Remove dependency on tensors, use dataId.
exports.nonMaxSuppressionV4Config = {
    kernelName: tfjs_1.NonMaxSuppressionV4,
    backendName: 'tensorflow',
    kernelFunc: function (_a) {
        var inputs = _a.inputs, backend = _a.backend, attrs = _a.attrs;
        var _b = inputs, boxes = _b.boxes, scores = _b.scores;
        var _c = attrs, maxOutputSize = _c.maxOutputSize, iouThreshold = _c.iouThreshold, scoreThreshold = _c.scoreThreshold, padToMaxOutputSize = _c.padToMaxOutputSize;
        var maxOutputSizeTensor = tfjs_1.scalar(maxOutputSize, 'int32');
        var iouThresholdTensor = tfjs_1.scalar(iouThreshold, 'float32');
        var scoreThresholdTensor = tfjs_1.scalar(scoreThreshold, 'float32');
        var nodeBackend = backend;
        var opAttrs = [
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T', boxes.dtype),
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T_threshold', 'float32'), {
                name: 'pad_to_max_output_size',
                type: nodeBackend.binding.TF_ATTR_BOOL,
                value: padToMaxOutputSize
            }
        ];
        var _d = nodeBackend.executeMultipleOutputs('NonMaxSuppressionV4', opAttrs, [
            boxes, scores, maxOutputSizeTensor,
            iouThresholdTensor, scoreThresholdTensor
        ], 2), selectedIndices = _d[0], validOutputs = _d[1];
        maxOutputSizeTensor.dispose();
        iouThresholdTensor.dispose();
        scoreThresholdTensor.dispose();
        return [selectedIndices, validOutputs];
    }
};
