"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
exports.meanConfig = {
    kernelName: tfjs_1.Mean,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var x = args.inputs.x;
        var backend = args.backend;
        var _a = args.attrs, axis = _a.axis, keepDims = _a.keepDims;
        var axes = tfjs_1.util.parseAxisParam(axis, x.shape);
        var axesTensor = tfjs_1.tensor1d(axes, 'int32');
        // Cast to float32 to match existing tfjs implementation/tests.
        var asFloat32 = tfjs_1.cast(x, 'float32');
        var res = backend.executeSingleOutput(tfjs_1.Mean, backend.createReductionOpAttrs(x, keepDims), [asFloat32, axesTensor]);
        asFloat32.dispose();
        axesTensor.dispose();
        return res;
    }
};
