"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
var nodejs_kernel_backend_1 = require("../nodejs_kernel_backend");
// tslint:disable-next-line: variable-name
exports.LRNGradConfig = {
    kernelName: tfjs_1.LRNGrad,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var _a = args.inputs, x = _a.x, y = _a.y, dy = _a.dy;
        var backend = args.backend;
        var _b = args.attrs, depthRadius = _b.depthRadius, bias = _b.bias, alpha = _b.alpha, beta = _b.beta;
        var opAttrs = [
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T', dy.dtype),
            {
                name: 'depth_radius',
                type: backend.binding.TF_ATTR_INT,
                value: depthRadius
            },
            { name: 'bias', type: backend.binding.TF_ATTR_FLOAT, value: bias },
            { name: 'alpha', type: backend.binding.TF_ATTR_FLOAT, value: alpha },
            { name: 'beta', type: backend.binding.TF_ATTR_FLOAT, value: beta },
        ];
        return backend.executeSingleOutput(tfjs_1.LRNGrad, opAttrs, [dy, x, y]);
    }
};
