"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
var nodejs_kernel_backend_1 = require("../nodejs_kernel_backend");
exports.concatConfig = {
    kernelName: tfjs_1.Concat,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var tensors = args.inputs;
        var backend = args.backend;
        var axis = args.attrs.axis;
        var opAttrs = [
            { name: 'N', type: backend.binding.TF_ATTR_INT, value: tensors.length }, {
                name: 'Tidx',
                type: backend.binding.TF_ATTR_TYPE,
                value: backend.binding.TF_INT32
            },
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T', tensors)
        ];
        var inputs = Array.from(tensors);
        var axisTensor = tfjs_1.scalar(axis, 'int32');
        inputs.push(axisTensor);
        var res = backend.executeSingleOutput('ConcatV2', opAttrs, inputs);
        axisTensor.dispose();
        return res;
    }
};
