"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
exports.clipByValueConfig = {
    kernelName: tfjs_1.ClipByValue,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var x = args.inputs.x;
        var _a = args.attrs, clipValueMin = _a.clipValueMin, clipValueMax = _a.clipValueMax;
        return tfjs_1.tidy(function () {
            var xMin = tfjs_1.minimum(x, tfjs_1.scalar(clipValueMax, x.dtype));
            return tfjs_1.maximum(xMin, tfjs_1.scalar(clipValueMin, x.dtype));
        });
    }
};
