"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
var nodejs_kernel_backend_1 = require("../nodejs_kernel_backend");
exports.batchToSpaceNDConfig = {
    kernelName: tfjs_1.BatchToSpaceND,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var x = args.inputs.x;
        var backend = args.backend;
        var _a = args.attrs, blockShape = _a.blockShape, crops = _a.crops;
        var blockShapeTensor = tfjs_1.tensor1d(blockShape, 'int32');
        var cropsTensor = tfjs_1.tensor2d(crops, [crops.length, crops[0].length], 'int32');
        var opAttrs = [
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T', x.dtype),
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('Tblock_shape', 'int32'),
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('Tcrops', cropsTensor.dtype)
        ];
        var res = backend.executeSingleOutput(tfjs_1.BatchToSpaceND, opAttrs, [x, blockShapeTensor, cropsTensor]);
        cropsTensor.dispose();
        blockShapeTensor.dispose();
        return res;
    }
};
