"use strict";
/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
Object.defineProperty(exports, "__esModule", { value: true });
var tfjs_1 = require("@tensorflow/tfjs");
var nodejs_kernel_backend_1 = require("../nodejs_kernel_backend");
exports.batchMatMulConfig = {
    kernelName: tfjs_1.BatchMatMul,
    backendName: 'tensorflow',
    kernelFunc: function (args) {
        var _a = args.inputs, a = _a.a, b = _a.b;
        var backend = args.backend;
        var _b = args.attrs, transposeA = _b.transposeA, transposeB = _b.transposeB;
        var opAttrs = [
            nodejs_kernel_backend_1.createTensorsTypeOpAttr('T', a.dtype),
            { name: 'adj_x', type: backend.binding.TF_ATTR_BOOL, value: transposeA },
            { name: 'adj_y', type: backend.binding.TF_ATTR_BOOL, value: transposeB }
        ];
        // libtensorflow's BatchMatMulV2 op performs the same behavior as other tfjs
        // backends' BatchMatMul (supports broadcasting), so a string literal is
        // used here to point to libtensorflow's BatchMatMulV2 op, instead of using
        // const `BatchMatMul` ('BatchMatMul') to resolve node-backend's special
        // mapping.
        return backend.executeSingleOutput('BatchMatMulV2', opAttrs, [a, b]);
    }
};
