/**
 * @license
 * Copyright 2018 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
/// <reference types="node" />
import * as tf from '@tensorflow/tfjs';
/**
 * Convert an ArrayBuffer to a Buffer.
 */
export declare function toBuffer(ab: ArrayBuffer): Buffer;
/**
 * Convert a Buffer or an Array of Buffers to an ArrayBuffer.
 *
 * If the input is an Array of Buffers, they will be concatenated in the
 * specified order to form the output ArrayBuffer.
 */
export declare function toArrayBuffer(buf: Buffer | Buffer[]): ArrayBuffer;
/**
 * Populate ModelArtifactsInfo fields for a model with JSON topology.
 * @param modelArtifacts
 * @returns A ModelArtifactsInfo object.
 */
export declare function getModelArtifactsInfoForJSON(modelArtifacts: tf.io.ModelArtifacts): {
    dateSaved: Date;
    modelTopologyType: string;
    modelTopologyBytes: number;
    weightSpecsBytes: number;
    weightDataBytes: number;
};
