/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("@tensorflow/tfjs-core")):"function"==typeof define&&define.amd?define(["exports","@tensorflow/tfjs-core"],e):e((t=t||self).tf=t.tf||{},t.tf)}(this,(function(t,e){"use strict";let s;function i(){return null==s&&(s=e.backend().epsilon()),s}class n extends Error{constructor(t){super(t),Object.setPrototypeOf(this,n.prototype)}}class r extends Error{constructor(t){super(t),Object.setPrototypeOf(this,r.prototype)}}class a extends Error{constructor(t){super(t),Object.setPrototypeOf(this,a.prototype)}}class o extends Error{constructor(t){super(t),Object.setPrototypeOf(this,o.prototype)}}class l extends Error{constructor(t){super(t),Object.setPrototypeOf(this,l.prototype)}}function u(t,e){if(Array.isArray(t)){let s=[];for(let i=0;i<e;i++)s=s.concat(t);return s}{const s=new Array(e);return s.fill(t),s}}function h(t,e){if(!t)throw new l(e)}function c(t,e){let s=0;for(const i of t)i===e&&s++;return s}function p(t){return 1===t.length?t[0]:t}function d(t){return Array.isArray(t)?t:[t]}function g(t){const e=t.replace(/(.)([A-Z][a-z0-9]+)/g,"$1_$2").replace(/([a-z])([A-Z])/g,"$1_$2").toLowerCase();return"_"!==e[0]?e:"private"+e}function f(t){return t.length<=1||-1===t.indexOf("_")?t:t.replace(/[_]+(\w|$)/g,(t,e)=>e.toUpperCase())}let m={};function y(t){if(null==t)return null;const e={};return e.className=t.getClassName(),e.config=t.getConfig(),e}function b(t,e={},s={},i="object",n=!1){if("string"==typeof t){const n=t;let r;if(n in s)r=s[n];else if(n in m)r=m[n];else if(r=e[n],null==r)throw new a(`Unknown ${i}: ${t}. This may be due to one of the following reasons:\n1. The ${i} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${i} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);return r}{const r=t;if(null==r.className||null==r.config)throw new a(i+": Improper config format: "+JSON.stringify(r)+".\n'className' and 'config' must set.");const o=r.className;let l,u;if(o in s?[l,u]=s[o]:o in m?[l,u]=m.className:o in e&&([l,u]=e[o]),null==l)throw new a(`Unknown ${i}: ${o}. This may be due to one of the following reasons:\n1. The ${i} is defined in Python, in which case it needs to be ported to TensorFlow.js or your JavaScript code.\n2. The custom ${i} is defined in JavaScript, but is not registered properly with tf.serialization.registerClass().`);if(null!=u){const t={};for(const e of Object.keys(m))t[e]=m[e];for(const e of Object.keys(s))t[e]=s[e];r.config.customObjects=t;const e=Object.assign({},m);for(const t of Object.keys(s))m[t]=s[t];!function t(e){if(null!=e&&"object"==typeof e)if(Array.isArray(e))e.forEach(e=>t(e));else{const s=Object.keys(e);for(const i of s){const s=e[i];null!=s&&"object"==typeof s&&(Array.isArray(s)||"ndarray"!==s.type||"number"!=typeof s.value?t(s):e[i]=s.value)}}}(r.config);const i=u(l,r.config,s,n);return m=Object.assign({},e),i}{const t=Object.assign({},m);for(const t of Object.keys(s))m[t]=s[t];const e=new l(r.config);return m=Object.assign({},t),e}}}function w(t,e){return-1*function(t,e){return t<e?-1:t>e?1:0}(t,e)}function z(t){if(null==t)return t;const e=[];for(const s of t)-1===e.indexOf(s)&&e.push(s);return e}function k(t){if(null==t)throw new a("Invalid value in obj: "+JSON.stringify(t));for(const e in t)if(t.hasOwnProperty(e))return!1;return!0}function S(t,e,s){if(null!=s&&t.indexOf(s)<0)throw new a(`${s} is not a valid ${e}.  Valid values are ${t} or null/undefined.`)}function v(t,e,s=0,i=1/0){return h(s>=0),h(i>=s),Array.isArray(t)&&t.length>=s&&t.length<=i&&t.every(t=>typeof t===e)}function N(t,s){Array.isArray(t)?(e.util.assert(t.length>0,()=>s+" is unexpectedly an empty array."),t.forEach((t,e)=>N(t,`element ${e+1} of ${s}`))):e.util.assert(Number.isInteger(t)&&t>0,()=>`Expected ${s} to be a positive integer, but got `+function t(e){return null===e?"null":Array.isArray(e)?"["+e.map(e=>t(e)).join(",")+"]":"string"==typeof e?`"${e}"`:""+e}(t)+".")}function A(t){return"relu"===t?"relu":"linear"===t?"linear":"elu"===t?"elu":null}function C(t,s){return e.tidy(()=>e.sqrt(e.sum(e.mul(t,t),s,!0)))}class x extends e.serialization.Serializable{getConfig(){return{}}}class I extends x{constructor(t){super(),this.defaultMaxValue=2,this.defaultAxis=0,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy(()=>{const s=C(t,this.axis),n=e.clipByValue(s,0,this.maxValue);return e.mul(t,e.div(n,e.add(i(),s)))})}getConfig(){return{maxValue:this.maxValue,axis:this.axis}}}I.className="MaxNorm",e.serialization.registerClass(I);class L extends x{constructor(t){super(),this.defaultAxis=0,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy(()=>e.div(t,e.add(i(),C(t,this.axis))))}getConfig(){return{axis:this.axis}}}L.className="UnitNorm",e.serialization.registerClass(L);class T extends x{apply(t){return e.relu(t)}}T.className="NonNeg",e.serialization.registerClass(T);class E extends x{constructor(t){super(),this.defaultMinValue=0,this.defaultMaxValue=1,this.defaultRate=1,this.defaultAxis=0,this.minValue=null!=t.minValue?t.minValue:this.defaultMinValue,this.maxValue=null!=t.maxValue?t.maxValue:this.defaultMaxValue,this.rate=null!=t.rate?t.rate:this.defaultRate,this.axis=null!=t.axis?t.axis:this.defaultAxis}apply(t){return e.tidy(()=>{const s=C(t,this.axis),n=e.add(e.mul(this.rate,e.clipByValue(s,this.minValue,this.maxValue)),e.mul(1-this.rate,s));return e.mul(t,e.div(n,e.add(i(),s)))})}getConfig(){return{minValue:this.minValue,maxValue:this.maxValue,rate:this.rate,axis:this.axis}}}E.className="MinMaxNorm",e.serialization.registerClass(E);const D={maxNorm:"MaxNorm",minMaxNorm:"MinMaxNorm",nonNeg:"NonNeg",unitNorm:"UnitNorm"};function O(t){return y(t)}function R(t,s={}){return b(t,e.serialization.SerializationMap.getMap().classNameMap,s,"constraint")}function F(t){if(null==t)return null;if("string"==typeof t){return R({className:t in D?D[t]:t,config:{}})}return t instanceof x?t:R(t)}var _=Object.freeze({__proto__:null,maxNorm:function(t){return new I(t)},unitNorm:function(t){return new L(t)},nonNeg:function(){return new T},minMaxNorm:function(t){return new E(t)}});const M=["channelsFirst","channelsLast"],$=["nearest","bilinear"],B=["valid","same","causal"],W=["max","avg"],U=["sum","mul","concat","ave"],P=new Map;function j(t){S(M,"DataFormat",t)}function V(t){S(B,"PaddingMode",t)}function q(t){S(W,"PoolMode",t)}const J=[];function H(t,e){J.push(t);try{const t=e();return J.pop(),t}catch(t){throw J.pop(),t}}function Z(t){if(!Y(t))throw new Error("Not a valid tensor name: '"+t+"'");return(0===J.length?"":J.join("/")+"/")+t}function K(t){if(!Y(t))throw new Error("Not a valid tensor name: '"+t+"'");P.has(t)||P.set(t,0);const e=P.get(t);if(P.set(t,P.get(t)+1),e>0){const s=`${t}_${e}`;return P.set(s,1),s}return t}const G=new RegExp(/^[A-Za-z0-9][-A-Za-z0-9\._\/]*$/);function Y(t){return!!t.match(G)}function X(t,e,s){null==e&&(e=0),null==s&&(s=t.length);let i=1;for(let n=e;n<s;++n)i*=t[n];return i}function Q(t){return t=Array.isArray(t)?new Float32Array(t):t,e.tensor1d(t)}function tt(t){return e.min(Q(t)).dataSync()[0]}function et(t){return e.max(Q(t)).dataSync()[0]}function st(t,e){if(e<t)throw new a(`end (${e}) < begin (${t}) is forbidden.`);const s=[];for(let i=t;i<e;++i)s.push(i);return s}function it(t,e){return t.asType(e)}function nt(t,e=-1){const s=t.shape.slice();return e<0&&(e=s.length+e+1),s.splice(e,0,1),t.reshape(s)}function rt(t,s,i){return e.tidy(()=>{switch(t.rank){case 1:return e.slice1d(t,s,i);case 2:return e.slice2d(t,[s,0],[i,t.shape[1]]);case 3:return e.slice3d(t,[s,0,0],[i,t.shape[1],t.shape[2]]);case 4:return e.slice4d(t,[s,0,0,0],[i,t.shape[1],t.shape[2],t.shape[3]]);case 5:return e.slice(t,[s,0,0,0,0],[i,t.shape[1],t.shape[2],t.shape[3],t.shape[4]]);case 6:return e.slice(t,[s,0,0,0,0,0],[i,t.shape[1],t.shape[2],t.shape[3],t.shape[4],t.shape[5]]);default:throw new a("sliceAlongFirstAxis() received an unsupported tensor rank: "+t.rank)}})}function at(t,s,i){return e.tidy(()=>{switch(t.rank){case 1:return e.slice1d(t,s,i);case 2:return e.slice2d(t,[0,s],[t.shape[0],i]);case 3:return e.slice3d(t,[0,0,s],[t.shape[0],t.shape[1],i]);case 4:return e.slice4d(t,[0,0,0,s],[t.shape[0],t.shape[1],t.shape[2],i]);default:throw new a("sliceAlongLastAxis() received an unsupported tensor rank: "+t.rank)}})}function ot(t,s,i,n){return e.tidy(()=>{switch(t.rank){case 1:return e.slice1d(t,s,i);case 2:switch(n){case 1:return rt(t,s,i);case 2:return at(t,s,i);default:throw new a("The axis is not within the rank of the tensor "+n)}case 3:switch(n){case 1:return rt(t,s,i);case 2:return e.slice3d(t,[0,s,0],[t.shape[0],i,t.shape[2]]);case 3:return at(t,s,i);default:throw new a("The axis is not within the rank of the tensor "+n)}case 4:switch(n){case 1:return rt(t,s,i);case 2:return e.slice4d(t,[0,s,0,0],[t.shape[0],i,t.shape[2],t.shape[3]]);case 3:return e.slice4d(t,[0,0,s,0],[t.shape[0],t.shape[1],i,t.shape[3]]);case 4:return at(t,s,i);default:throw new a("The axis is not within the rank of the tensor "+n)}default:throw new a("sliceAlongLastAxis() received an unsupported tensor rank: "+t.rank)}})}function lt(t,s=-1){let i;return s<0&&(i=t[0].rank,s=0!==i?i:0),s===t[0].rank&&(s=-1),e.concat(t,s)}function ut(t,s){switch(t.rank){case 1:return e.concat1d([t,s]);case 2:return e.concat2d([t,s],0);case 3:return e.concat3d([t,s],0);case 4:return e.concat4d([t,s],0);default:throw new a("concatAlongFirstAxis() received an unsupported tensor rank: "+t.rank)}}function ht(t,s){if(Array.isArray(s)||(s=[s]),t.rank!==s.length)throw new a(`The length of input n (${s.length}) does not match the number of dimensions in input x (${t.rank})`);return e.tile(t,s)}function ct(t,s=0,i=1,n,r){return e.randomNormal(t,s,i,n,r)}function pt(t,s,i,n){if(t.rank<2||s.rank<2)throw new o(`dot requires both inputs to be rank >= 2 but got x shape = ${t.shape} and y shape = ${s.shape}`);if(s.rank>=3){if(t.shape.slice(-1)[0]!==s.shape.slice(-2)[0])throw new o(`If rank y >= 3, then the second last dim of y must equal the last dim of x but got x shape = ${t.shape} and  y shape = `+s.shape)}if(2===t.rank&&2===s.rank){const r=!1,a=!1;return e.fused.matMul({a:t,b:s,transposeA:r,transposeB:a,bias:n?ft(t.rank,n,"channelsLast"):null,activation:i})}{const r=t.shape.slice(),a=r.pop();t=t.reshape([-1,a]);const o=s.shape.slice(),l=o.pop(),u=o.pop(),h=[...o,l],c=Array.from({length:s.rank},(t,e)=>0===e?s.rank-2:e<=s.rank-2?e-1:e);s=s.transpose(c).reshape([u,-1]);const p=[...r,...h],d=!1,g=!1;return e.fused.matMul({a:t,b:s,transposeA:d,transposeB:g,bias:n?ft(t.rank,n,"channelsLast"):null,activation:i}).reshape(p)}}function dt(t,s,i){return e.tidy(()=>(s=Array.isArray(s)?e.tensor1d(s,"int32"):s.toInt(),e.gather(t,s,i)))}function gt(t){return e.mul(t,t)}function ft(t,e,s){const i=e.shape;if(1!==e.rank&&e.rank!==t)throw new a("Unexpected bias dimensions: "+e.rank+"; expected it to be 1 or "+t);if(5===t){if("channelsFirst"===s)return 1===i.length?e.reshape([1,i[0],1,1,1]):e.reshape([1,i[3],i[0],i[1],i[2]]);if("channelsLast"===s)return 1===i.length?e.reshape([1,1,1,1,i[0]]):e.reshape([1].concat(i))}else if(4===t){if("channelsFirst"===s)return 1===i.length?e.reshape([1,i[0],1,1]):e.reshape([1,i[2],i[0],i[1]]);if("channelsLast"===s)return 1===i.length?e.reshape([1,1,1,i[0]]):e.reshape([1].concat(i))}else if(3===t){if("channelsFirst"===s)return 1===i.length?e.reshape([1,i[0],1]):e.reshape([1,i[1],i[0]]);if("channelsLast"===s)return 1===i.length?e.reshape([1,1,i[0]]):e.reshape([1].concat(i))}else if(t<3)return e;throw new a("Unsupported input rank by biasAdd: "+e.rank)}function mt(t,s,i){return e.tidy(()=>(null==i&&(i="channelsLast"),j(i),t.add(ft(t.rank,s,i))))}function yt(t,s,i,n){return e.tidy(()=>e.dropout(t,s,i,n))}function bt(t,e,s=!1){return s?t():e()}const wt=["fanIn","fanOut","fanAvg"],zt=["normal","uniform","truncatedNormal"];class kt extends e.serialization.Serializable{fromConfigUsesCustomObjects(){return!1}getConfig(){return{}}}class St extends kt{apply(t,s){return e.zeros(t,s)}}St.className="Zeros",e.serialization.registerClass(St);class vt extends kt{apply(t,s){return e.ones(t,s)}}vt.className="Ones",e.serialization.registerClass(vt);class Nt extends kt{constructor(t){if(super(),"object"!=typeof t)throw new a("Expected argument of type ConstantConfig but got "+t);if(void 0===t.value)throw new a("config must have value set but got "+t);this.value=t.value}apply(t,s){return e.tidy(()=>e.mul(e.scalar(this.value),e.ones(t,s)))}getConfig(){return{value:this.value}}}Nt.className="Constant",e.serialization.registerClass(Nt);class At extends kt{constructor(t){super(),this.DEFAULT_MINVAL=-.05,this.DEFAULT_MAXVAL=.05,this.minval=t.minval||this.DEFAULT_MINVAL,this.maxval=t.maxval||this.DEFAULT_MAXVAL,this.seed=t.seed}apply(t,s){return e.randomUniform(t,this.minval,this.maxval,s)}getConfig(){return{minval:this.minval,maxval:this.maxval,seed:this.seed}}}At.className="RandomUniform",e.serialization.registerClass(At);class Ct extends kt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,e){if("float32"!==(e=e||"float32")&&"int32"!==e)throw new o(`randomNormal does not support dType ${e}.`);return ct(t,this.mean,this.stddev,e,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}Ct.className="RandomNormal",e.serialization.registerClass(Ct);class xt extends kt{constructor(t){super(),this.DEFAULT_MEAN=0,this.DEFAULT_STDDEV=.05,this.mean=t.mean||this.DEFAULT_MEAN,this.stddev=t.stddev||this.DEFAULT_STDDEV,this.seed=t.seed}apply(t,s){if("float32"!==(s=s||"float32")&&"int32"!==s)throw new o(`truncatedNormal does not support dType ${s}.`);return e.truncatedNormal(t,this.mean,this.stddev,s,this.seed)}getConfig(){return{mean:this.mean,stddev:this.stddev,seed:this.seed}}}xt.className="TruncatedNormal",e.serialization.registerClass(xt);class It extends kt{constructor(t){super(),this.gain=null!=t.gain?t.gain:1}apply(t,s){return e.tidy(()=>{if(2!==t.length||t[0]!==t[1])throw new a("Identity matrix initializer can only be used for 2D square matrices.");return e.mul(this.gain,e.eye(t[0]))})}getConfig(){return{gain:this.gain}}}It.className="Identity",e.serialization.registerClass(It);class Lt extends kt{constructor(t){if(super(),t.scale<0)throw new a("scale must be a positive float. Got: "+t.scale);var e;this.scale=null==t.scale?1:t.scale,this.mode=null==t.mode?"fanIn":t.mode,e=this.mode,S(wt,"FanMode",e),this.distribution=null==t.distribution?"normal":t.distribution,function(t){S(zt,"Distribution",t)}(this.distribution),this.seed=t.seed}apply(t,s){const i=function(t,e="channelsLast"){let s,i;if(j(e),2===t.length)s=t[0],i=t[1];else if(-1!==[3,4,5].indexOf(t.length)){if("channelsFirst"===e){const e=X(t,2);s=t[1]*e,i=t[0]*e}else if("channelsLast"===e){const e=X(t,0,t.length-2);s=t[t.length-2]*e,i=t[t.length-1]*e}}else{const e=X(t);s=Math.sqrt(e),i=Math.sqrt(e)}return[s,i]}(t),n=i[0],r=i[1];let a=this.scale;if("fanIn"===this.mode?a/=Math.max(1,n):"fanOut"===this.mode?a/=Math.max(1,r):a/=Math.max(1,(n+r)/2),"normal"===this.distribution){const i=Math.sqrt(a);if("float32"!==(s=s||"float32")&&"int32"!==s)throw new o(`${this.getClassName()} does not support dType ${s}.`);return e.truncatedNormal(t,0,i,s,this.seed)}{const i=Math.sqrt(3*a);return e.randomUniform(t,-i,i,s)}}getConfig(){return{scale:this.scale,mode:this.mode,distribution:this.distribution,seed:this.seed}}}Lt.className="VarianceScaling",e.serialization.registerClass(Lt);class Tt extends Lt{constructor(t){super({scale:1,mode:"fanAvg",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Tt.className="GlorotUniform",e.serialization.registerClass(Tt);class Et extends Lt{constructor(t){super({scale:1,mode:"fanAvg",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Et.className="GlorotNormal",e.serialization.registerClass(Et);class Dt extends Lt{constructor(t){super({scale:2,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Dt.className="HeNormal",e.serialization.registerClass(Dt);class Ot extends Lt{constructor(t){super({scale:2,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Ot.className="HeUniform",e.serialization.registerClass(Ot);class Rt extends Lt{constructor(t){super({scale:1,mode:"fanIn",distribution:"normal",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Rt.className="LeCunNormal",e.serialization.registerClass(Rt);class Ft extends Lt{constructor(t){super({scale:1,mode:"fanIn",distribution:"uniform",seed:null==t?null:t.seed})}getClassName(){return Lt.className}}Ft.className="LeCunNormal",e.serialization.registerClass(Ft);class _t extends kt{constructor(t){if(super(),this.DEFAULT_GAIN=1,this.gain=null==t.gain?this.DEFAULT_GAIN:t.gain,this.seed=t.seed,null!=this.seed)throw new o("Random seed is not implemented for Orthogonal Initializer yet.")}apply(t,s){return e.tidy(()=>{if(t.length<2)throw new o("Shape must be at least 2D.");t[0]*t[1]>2e3&&console.warn(`Orthogonal initializer is being called on a matrix with more than 2000 (${t[0]*t[1]}) elements: Slowness may result.`);const s=ct(t[0]>t[1]?[t[1],t[0]]:t,0,1,"float32");let i=e.linalg.gramSchmidt(s);return t[0]>t[1]&&(i=i.transpose()),e.mul(this.gain,i)})}getConfig(){return{gain:this.gain,seed:this.seed}}}_t.className="Orthogonal",e.serialization.registerClass(_t);const Mt={constant:"Constant",glorotNormal:"GlorotNormal",glorotUniform:"GlorotUniform",heNormal:"HeNormal",heUniform:"HeUniform",identity:"Identity",leCunNormal:"LeCunNormal",leCunUniform:"LeCunUniform",ones:"Ones",orthogonal:"Orthogonal",randomNormal:"RandomNormal",randomUniform:"RandomUniform",truncatedNormal:"TruncatedNormal",varianceScaling:"VarianceScaling",zeros:"Zeros"};function $t(t,s={}){return b(t,e.serialization.SerializationMap.getMap().classNameMap,s,"initializer")}function Bt(t){return y(t)}function Wt(t){if("string"==typeof t){const e=t in Mt?Mt[t]:t;if("GlorotNormal"===e)return new Et;if("GlorotUniform"===e)return new Tt;if("HeNormal"===e)return new Dt;if("HeUniform"===e)return new Ot;if("LeCunNormal"===e)return new Rt;if("LeCunUniform"===e)return new Ft;{const t={};return t.className=e,t.config={},$t(t)}}return t instanceof kt?t:$t(t)}var Ut=Object.freeze({__proto__:null,zeros:function(){return new St},ones:function(){return new vt},constant:function(t){return new Nt(t)},randomUniform:function(t){return new At(t)},randomNormal:function(t){return new Ct(t)},truncatedNormal:function(t){return new xt(t)},identity:function(t){return new It(t)},varianceScaling:function(t){return new Lt(t)},glorotUniform:function(t){return new Tt(t)},glorotNormal:function(t){return new Et(t)},heNormal:function(t){return new Dt(t)},heUniform:function(t){return new Ot(t)},leCunNormal:function(t){return new Rt(t)},leCunUniform:function(t){return new Ft(t)},orthogonal:function(t){return new _t(t)}});let Pt=0;function jt(){return Pt++}const Vt={};function qt(t=""){return t in Vt||(Vt[t]=0),Vt[t]+=1,t+Vt[t].toString()}function Jt(t){return Array.isArray(t)&&Array.isArray(t[0])}function Ht(t){return 0===t.length?[]:Array.isArray(t[0])?t:[t]}function Zt(t){let e;if(Array.isArray(t)){if(1!==t.length)throw new a("Expected Tensor length to be 1; got "+t.length);e=t[0]}else e=t;return e}function Kt(t){if(Array.isArray(t)&&Array.isArray(t[0])){if(1===t.length)return(t=t)[0];throw new a("Expected exactly 1 Shape; got "+t.length)}return t}function Gt(t){let e=0;for(const s of t)0===s.shape.length?e+=1:e+=s.shape.reduce((t,e)=>t*e);return e}class Yt{constructor(t,s="float32",i="Variable",n=!0,r=null){this.dtype=null==s?"float32":s,this.shape=t.shape,this.id=jt(),i=null==i?"Variable":i,this.originalName=Z(i),this.name=K(this.originalName),this.trainable_=n,this.constraint=r,this.val=e.variable(t,this.trainable_,this.name,this.dtype)}read(){return this.assertNotDisposed(),this.val}write(t){return this.assertNotDisposed(),function(t,e){if(t.shape.toString()!==e.shape.toString())throw new Error("Shape mismatch: "+JSON.stringify(t.shape)+" vs. "+JSON.stringify(e.shape))}(this.val,t),this.val.id!==t.id&&(this.val.assign(t),null!=this.constraint&&this.val.assign(this.constraint.apply(this.val))),this}dispose(){this.assertNotDisposed(),this.val.dispose()}assertNotDisposed(){if(this.val.isDisposed)throw new Error(`LayersVariable ${this.name} is already disposed.`)}get trainable(){return this.trainable_}set trainable(t){this.trainable_=t,this.val.trainable=t}}function Xt(t){return t.map(t=>t.read())}function Qt(t){t.forEach(t=>{t[0].write(t[1])})}class te{constructor(t){this.dtype=t.dtype,this.shape=t.shape,null!=t.shape?this.ndim=t.shape.length:this.ndim=t.ndim,this.maxNDim=t.maxNDim,this.minNDim=t.minNDim,this.axes=t.axes||{}}}class ee{constructor(t,e,s,i,n,r,a){this.dtype=t,this.shape=e,this.sourceLayer=s,this.inputs=i,this.callArgs=n,this.outputTensorIndex=a,this.id=jt(),null!=r&&(this.originalName=Z(r),this.name=K(this.originalName)),this.rank=e.length}}let se=0;class ie{constructor(t,e){this.callArgs=e,this.id=se++,this.outboundLayer=t.outboundLayer,this.inboundLayers=t.inboundLayers,this.nodeIndices=t.nodeIndices,this.tensorIndices=t.tensorIndices,this.inputTensors=t.inputTensors,this.outputTensors=t.outputTensors,this.inputMasks=t.inputMasks,this.outputMasks=t.outputMasks,this.inputShapes=t.inputShapes,this.outputShapes=t.outputShapes;for(const e of t.inboundLayers)null!=e&&e.outboundNodes.push(this);t.outboundLayer.inboundNodes.push(this)}getConfig(){const t=[];for(const e of this.inboundLayers)null!=e?t.push(e.name):t.push(null);return{outboundLayer:this.outboundLayer?this.outboundLayer.name:null,inboundLayers:t,nodeIndices:this.nodeIndices,tensorIndices:this.tensorIndices}}}let ne=0;class re extends e.serialization.Serializable{constructor(t={}){super(),this._callHook=null,this._addedWeightNames=[],this._stateful=!1,this.id=ne++,this.activityRegularizer=null,this.inputSpec=null,this.supportsMasking=!1,this._trainableWeights=[],this._nonTrainableWeights=[],this._losses=[],this._updates=[],this._built=!1,this.inboundNodes=[],this.outboundNodes=[];let e=t.name;if(!e){const t=this.getClassName();e=g(t)+"_"+qt(t)}if(this.name=e,this.trainable_=null==t.trainable||t.trainable,null!=t.inputShape||null!=t.batchInputShape){let e;if(null!=t.batchInputShape)e=t.batchInputShape;else if(null!=t.inputShape){let s=null;null!=t.batchSize&&(s=t.batchSize),e=[s].concat(t.inputShape)}this.batchInputShape=e;let s=t.dtype;null==s&&(s=t.inputDType),null==s&&(s="float32"),this.dtype=s}null!=t.weights?this.initialWeights=t.weights:this.initialWeights=null,this._refCount=null,this.fastWeightInitDuringBuild=!1}static nodeKey(t,e){return t.name+"_ib-"+e.toString()}getNodeAtIndex(t,e){if(0===this.inboundNodes.length)throw new r(`The layer has never been called and thus has no defined ${e}.`);if(this.inboundNodes.length<=t)throw new a(`Asked to get ${e} at node ${t}, but the layer has only ${this.inboundNodes.length} inbound nodes.`);return this.inboundNodes[t]}getInputAt(t){return p(this.getNodeAtIndex(t,"input").inputTensors)}getOutputAt(t){return p(this.getNodeAtIndex(t,"output").outputTensors)}get input(){if(this.inboundNodes.length>1)throw new n("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer input" is ill-defined. Use `getInputAt(nodeIndex)` instead.');if(0===this.inboundNodes.length)throw new n("Layer "+this.name+" is not connected, no input to return.");return p(this.getNodeAtIndex(0,"input").inputTensors)}get output(){if(0===this.inboundNodes.length)throw new n("Layer "+this.name+" has no inbound nodes.");if(this.inboundNodes.length>1)throw new n("Layer "+this.name+' has multiple inbound nodes, hence the notion of "layer output" is ill-defined. Use `getOutputAt(nodeIndex)` instead.');return p(this.getNodeAtIndex(0,"output").outputTensors)}get losses(){return this._losses}calculateLosses(){return this.losses.map(t=>t())}get updates(){return this._updates}get built(){return this._built}set built(t){this._built=t}get trainable(){return this.trainable_}set trainable(t){this._trainableWeights.forEach(e=>e.trainable=t),this.trainable_=t}get trainableWeights(){return this.trainable_?this._trainableWeights.filter(t=>t.trainable):[]}set trainableWeights(t){this._trainableWeights=t}get nonTrainableWeights(){return this.trainable?this._trainableWeights.filter(t=>!t.trainable).concat(this._nonTrainableWeights):this._trainableWeights.concat(this._nonTrainableWeights)}set nonTrainableWeights(t){this._nonTrainableWeights=t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}get stateful(){return this._stateful}resetStates(){if(!this.stateful)throw new Error("Cannot call the resetStates() method of a non-stateful Layer object.")}assertInputCompatibility(t){if(t=d(t),null==this.inputSpec||0===this.inputSpec.length)return;const e=d(this.inputSpec);if(t.length!==e.length)throw new a(`Layer ${this.name} expects ${e.length} inputs, but it received ${t.length} input tensors. Input received: `+t);for(let s=0;s<t.length;s++){const i=t[s],n=e[s];if(null==n)continue;const r=i.rank;if(null!=n.ndim&&r!==n.ndim)throw new a(`Input ${s} is incompatible with layer ${this.name}: expected ndim=${n.ndim}, found ndim=${r}`);if(null!=n.maxNDim&&r>n.maxNDim)throw new a(`Input ${s} is incompatible with layer ${this.name}: expected max_ndim=${n.maxNDim}, found ndim=${r}`);if(null!=n.minNDim&&r<n.minNDim)throw new a(`Input ${s} is incompatible with layer ${this.name}: expected min_ndim=${n.minNDim}, found ndim=${r}.`);if(null!=n.dtype&&i.dtype!==n.dtype)throw new a(`Input ${s} is incompatible with layer ${this.name} : expected dtype=${n.dtype}, found dtype=${i.dtype}.`);if(n.axes){const t=i.shape;for(const e in n.axes){const i=Number(e),r=n.axes[e],o=i>=0?t[i]:t[t.length+i];if(null!=r&&-1===[r,null].indexOf(o))throw new a(`Input ${s} is incompatible with layer ${this.name}: expected axis ${i} of input shape to have value ${r} but got shape ${t}.`)}}if(null!=n.shape)for(let t=0;t<n.shape.length;++t){const e=n.shape[t],r=i.shape[t];if(null!=e&&null!=r&&e!==r)throw new a(`Input ${s} is incompatible with layer ${this.name}: expected shape=${n.shape}, found shape=${i.shape}.`)}}}call(t,e){return t}invokeCallHook(t,e){null!=this._callHook&&this._callHook(t,e)}setCallHook(t){this._callHook=t}clearCallHook(){this._callHook=null}apply(t,e){e=e||{},this.assertNotDisposed();const s=d(t);let i=!0;for(const t of s)if(!(t instanceof ee)){i=!1;break}let n=!0;for(const t of s)if(t instanceof ee){n=!1;break}if(i===n)throw new a("Arguments to apply() must be all SymbolicTensors or all Tensors");return H(this.name,()=>{if(!this.built){this.assertInputCompatibility(t);const e=[];for(const s of d(t))e.push(s.shape);this.build(p(e)),this.built=!0,this.initialWeights&&this.setWeights(this.initialWeights),null===this._refCount&&n&&(this._refCount=1)}if(this.assertInputCompatibility(t),n){let i=this.call(t,e);const n=d(i),r=[];for(let t of n)-1!==s.indexOf(t)&&(t=t.clone()),r.push(t);if(i=p(r),null!=this.activityRegularizer)throw new o("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return i}{const s=function(t){t=d(t);const e=[];for(const s of t)e.push(s.shape);return p(e)}(t),i=this.computeOutputShape(s);let n;const r="float32";if(this.warnOnIncompatibleInputShape(Array.isArray(t)?s[0]:s),n=null!=i&&i.length>0&&Array.isArray(i[0])?i.map((s,i)=>new ee(r,s,this,d(t),e,this.name,i)):new ee(r,i,this,d(t),e,this.name),this.addInboundNode(t,n,null,null,s,i,e),this._refCount++,null!=this.activityRegularizer)throw new o("Layer invocation in the presence of activity regularizer(s) is not supported yet.");return n}})}warnOnIncompatibleInputShape(t){if(null!=this.batchInputShape)if(t.length!==this.batchInputShape.length)console.warn("The rank of the input tensor provided (shape: "+JSON.stringify(t)+") does not match that of the "+`batchInputShape (${JSON.stringify(this.batchInputShape)}) of the layer `+this.name);else{let e=!1;this.batchInputShape.forEach((s,i)=>{null!=s&&null!=t[i]&&t[i]!==s&&(e=!0)}),e&&console.warn(`The shape of the input tensor (${JSON.stringify(t)}) does not match the expectation of layer ${this.name}: `+JSON.stringify(this.batchInputShape))}}get outputShape(){if(null==this.inboundNodes||0===this.inboundNodes.length)throw new n(`The layer ${this.name} has never been called and thus has no defined output shape.`);const t=[];for(const e of this.inboundNodes){const s=JSON.stringify(e.outputShapes);-1===t.indexOf(s)&&t.push(s)}if(1===t.length){const t=this.inboundNodes[0].outputShapes;return Array.isArray(t)&&Array.isArray(t[0])&&1===t.length?t[0]:t}throw new n(`The layer ${this.name} has multiple inbound nodes with different output shapes. Hence the notion of "output shape" is ill-defined for the layer.`)}countParams(){if(!this.built)throw new r(`You tried to call countParams() on ${this.name}, but the layer is not built yet. Build it first by calling build(batchInputShape).`);return Gt(this.weights)}build(t){this.built=!0}getWeights(t=!1){return Xt(t?this.trainableWeights:this.weights)}setWeights(t){e.tidy(()=>{const s=this.weights;if(s.length!==t.length)throw new a(`You called setWeights(weights) on layer "${this.name}" with a weight list of length ${t.length}, but the layer was expecting ${s.length} weights. Provided weights: ${t}...`);if(0===s.length)return;const i=[],n=Xt(s);for(let r=0;r<n.length;++r){const o=n[r],l=s[r],u=t[r];if(!e.util.arraysEqual(o.shape,u.shape))throw new a(`Layer weight shape ${o.shape} not compatible with provided weight shape `+u.shape);i.push([l,u])}Qt(i)})}addWeight(t,e,s,i,n,r,o){if(-1!==this._addedWeightNames.indexOf(t))throw new a(`Duplicate weight name ${t} for layer ${this.name}`);this._addedWeightNames.push(t),null==s&&(s="float32"),this.fastWeightInitDuringBuild&&(i=Wt("zeros"));const l=i.apply(e,s),u=new Yt(l,s,t,r,o);return l.dispose(),null!=n&&this.addLoss(()=>n.apply(u.read())),null==r&&(r=!0),r?this._trainableWeights.push(u):this._nonTrainableWeights.push(u),u}setFastWeightInitDuringBuild(t){this.fastWeightInitDuringBuild=t}addLoss(t){null==t||Array.isArray(t)&&0===t.length||(t=d(t),void 0!==this._losses&&null!==this._losses&&this.losses.push(...t))}computeOutputShape(t){return t}computeMask(t,e){if(!this.supportsMasking){if(null!=e){if(!Array.isArray(e))throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`);e.forEach(t=>{if(null!=t)throw new TypeError(`Layer ${this.name} does not support masking, but was passed an inputMask.`)})}return null}return e}addInboundNode(t,e,s,i,n,r,a=null){const o=d(t);e=d(e),s=d(s),i=d(i),n=Ht(n),r=Ht(r);const l=[],u=[],h=[];for(const t of o)l.push(t.sourceLayer),u.push(t.nodeIndex),h.push(t.tensorIndex);new ie({outboundLayer:this,inboundLayers:l,nodeIndices:u,tensorIndices:h,inputTensors:o,outputTensors:e,inputMasks:s,outputMasks:i,inputShapes:n,outputShapes:r},a);for(let t=0;t<e.length;t++)e[t].sourceLayer=this,e[t].nodeIndex=this.inboundNodes.length-1,e[t].tensorIndex=t}getConfig(){const t={name:this.name,trainable:this.trainable};return null!=this.batchInputShape&&(t.batchInputShape=this.batchInputShape),null!=this.dtype&&(t.dtype=this.dtype),t}disposeWeights(){return this.weights.forEach(t=>t.dispose()),this.weights.length}assertNotDisposed(){if(0===this._refCount)throw new Error(`Layer '${this.name}' is already disposed.`)}dispose(){if(!this.built)throw new Error(`Cannot dispose Layer ${this.name} because it has not been built yet.`);if(null===this._refCount)throw new Error(`Cannot dispose Layer ${this.name} because it has not been used yet.`);this.assertNotDisposed();let t=0;return 0==--this._refCount&&(t=this.disposeWeights()),{refCountAfterDispose:this._refCount,numDisposedVariables:t}}}class ae extends re{constructor(t){if(super({dtype:t.dtype,name:null!=t.name?t.name:qt("input").toString()}),null==t.batchSize&&(t.batchSize=null),null==t.sparse&&(t.sparse=!1),this.trainable=!1,this.built=!0,this.sparse=t.sparse,null!=t.inputShape&&null!=t.batchInputShape)throw new a("Only provide the inputShape OR batchInputShape argument to inputLayer, not both at the same time.");let e=t.batchInputShape;if(null==e){if(null==t.inputShape)throw new a("An InputLayer should be passed either a `batchInputShape` or an `inputShape`.");e=[t.batchSize].concat(t.inputShape)}else if(null!=t.batchSize)throw new a("Cannot specify batchSize if batchInputShape is specified when creating an InputLayer.");const s=t.dtype||"float32";this.batchInputShape=e,this.dtype=s,this.inputSpec=[{shape:e}];const i=new ee(this.dtype,this.batchInputShape,this,[],{},this.name);i.nodeIndex=0,i.tensorIndex=0,new ie({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:[i],outputTensors:[i],inputMasks:[null],outputMasks:[null],inputShapes:[e],outputShapes:[e]})}apply(t,e){throw new a("Cannot pass any input to an InputLayer's apply() method. InputLayer name: "+this.name)}dispose(){return{refCountAfterDispose:this._refCount,numDisposedVariables:0}}getConfig(){return{batchInputShape:this.batchInputShape,dtype:this.dtype,sparse:this.sparse,name:this.name}}}function oe(t){if(null==t.batchShape&&null==t.shape)throw new Error("Please provide to Input either a `shape` or a `batchShape` argument. Note that `shape` does not include the batch dimension.");if(null!=t.batchShape&&null!=t.shape)throw new a("Please provide either a `shape` or `batchShape` argument to Input, but not both.");let e=t.batchShape;null!=t.shape&&null==e&&(e=[null].concat(t.shape));let s=t.dtype;null==s&&(s="float32");return new ae({batchInputShape:e,name:t.name,dtype:s,sparse:t.sparse}).inboundNodes[0].outputTensors[0]}async function le(t){if(null==t)return;const s=[],i=[],n=[];for(const e in t){const r=t[e];if("number"!=typeof r){const t=r;s.push(t.data()),i.push(e),n.push(t)}}if(s.length>0){const r=await Promise.all(s);for(let e=0;e<r.length;++e)t[i[e]]=r[e][0];e.dispose(n)}}function ue(t){if(null!=t)for(const e in t){const s=t[e];"number"!=typeof s&&s.dispose()}}var he;ae.className="InputLayer",e.serialization.registerClass(ae),function(t){t[t.SILENT=0]="SILENT",t[t.VERBOSE=1]="VERBOSE"}(he||(he={}));class ce{constructor(){this.validationData=null}setParams(t){this.params=t}async onEpochBegin(t,e){}async onEpochEnd(t,e){}async onBatchBegin(t,e){}async onBatchEnd(t,e){}async onTrainBegin(t){}async onTrainEnd(t){}setModel(t){}}class pe{constructor(t,e=10){null==t&&(t=[]),this.callbacks=t,this.queueLength=e}append(t){this.callbacks.push(t)}setParams(t){for(const e of this.callbacks)e.setParams(t)}setModel(t){for(const e of this.callbacks)e.setModel(t)}async onEpochBegin(t,e){null==e&&(e={});for(const s of this.callbacks)await s.onEpochBegin(t,e)}async onEpochEnd(t,e){null==e&&(e={});for(const s of this.callbacks)await s.onEpochEnd(t,e)}async onBatchBegin(t,e){null==e&&(e={});for(const s of this.callbacks)await s.onBatchBegin(t,e)}async onBatchEnd(t,e){null==e&&(e={});for(const s of this.callbacks)await s.onBatchEnd(t,e)}async onTrainBegin(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainBegin(t)}async onTrainEnd(t){null==t&&(t={});for(const e of this.callbacks)await e.onTrainEnd(t)}}class de extends ce{constructor(){super()}async onEpochBegin(t){this.seen=0,this.totals={}}async onBatchEnd(t,s){null==s&&(s={});const i=null==s.size?0:s.size;this.seen+=i;for(const t in s){const n=s[t];if("number"==typeof n)this.totals.hasOwnProperty(t)||(this.totals[t]=0),this.totals[t]=this.totals[t]+n*i;else{let s;t in this.totals?s=this.totals[t]:this.totals[t]=0;const r=e.tidy(()=>e.add(this.totals[t],e.mul(n,i)));this.totals[t]=r,null!=s&&s.dispose()}}}async onEpochEnd(t,s){if(null!=s)for(const t of this.params.metrics)null!=this.totals[t]&&("number"==typeof this.totals[t]?s[t]=this.totals[t]/this.seen:e.tidy(()=>{const i=e.mul(e.div(1,this.seen),this.totals[t]);s[t]=i,this.totals[t].dispose(),e.keep(s[t])}))}}class ge extends ce{async onTrainBegin(t){this.epoch=[],this.history={}}async onEpochEnd(t,e){null==e&&(e={}),this.epoch.push(t);for(const t in e)null==this.history[t]&&(this.history[t]=[]),this.history[t].push(e[t])}async syncData(){const t=[],e=[],s=[];for(const i in this.history){const n=this.history[i];for(let r=0;r<n.length;++r)if("number"!=typeof n[r]){const a=n[r];t.push(a.data()),e.push(i),s.push(r)}}const i=await Promise.all(t);for(let t=0;t<i.length;++t){this.history[e[t]][s[t]].dispose(),this.history[e[t]][s[t]]=i[t][0]}}}class fe extends ce{constructor(t,s){if(super(),this.currentEpoch=0,this.yieldEvery=s||"auto","auto"===this.yieldEvery&&(this.yieldEvery=125),"never"===this.yieldEvery&&null!=t.onYield)throw new Error("yieldEvery is `never` but you provided an `onYield` callback. Either change `yieldEvery` or remove the callback");e.util.isNumber(this.yieldEvery)&&(this.maybeWait=function(t,s){let i,n=e.util.now();return(...r)=>{const a=e.util.now();return a-n<s||(n=a,i=t(...r)),i}}(this.maybeWait.bind(this),this.yieldEvery)),this.trainBegin=t.onTrainBegin,this.trainEnd=t.onTrainEnd,this.epochBegin=t.onEpochBegin,this.epochEnd=t.onEpochEnd,this.batchBegin=t.onBatchBegin,this.batchEnd=t.onBatchEnd,this.yield=t.onYield}async maybeWait(t,s,i){const n=[];null!=this.yield&&(await le(i),n.push(this.yield(t,s,i))),n.push(e.nextFrame()),await Promise.all(n)}async onEpochBegin(t,e){this.currentEpoch=t,null!=this.epochBegin&&(await le(e),await this.epochBegin(t,e))}async onEpochEnd(t,s){const i=[];null!=this.epochEnd&&(await le(s),i.push(this.epochEnd(t,s))),"epoch"===this.yieldEvery&&i.push(e.nextFrame()),await Promise.all(i)}async onBatchBegin(t,e){null!=this.batchBegin&&(await le(e),await this.batchBegin(t,e))}async onBatchEnd(t,s){const i=[];null!=this.batchEnd&&(await le(s),i.push(this.batchEnd(t,s))),"batch"===this.yieldEvery?i.push(e.nextFrame()):e.util.isNumber(this.yieldEvery)&&i.push(this.maybeWait(this.currentEpoch,t,s)),await Promise.all(i)}async onTrainBegin(t){null!=this.trainBegin&&(await le(t),await this.trainBegin(t))}async onTrainEnd(t){null!=this.trainEnd&&(await le(t),await this.trainEnd(t))}}function me(t,e){if(null==t&&(t={}),t instanceof ce)return[t];if(Array.isArray(t)&&t[0]instanceof ce)return t;return d(t).map(t=>new fe(t,e))}class ye{constructor(){}static registerCallbackConstructor(t,s){e.util.assert(t>=0&&Number.isInteger(t),()=>"Verbosity level is expected to be an integer >= 0, but got "+t),ye.checkForDuplicate(s),null==ye.constructors[t]&&(ye.constructors[t]=[]),ye.constructors[t].push(s)}static checkForDuplicate(t){for(const e in ye.constructors){ye.constructors[+e].forEach(e=>{if(e===t)throw new a("Duplicate callback constructor.")})}}static clear(){ye.constructors={}}static createCallbacks(t){const e=[];for(const s in ye.constructors){const i=+s;t>=i&&e.push(...ye.constructors[i])}return e.map(t=>new t)}}function be(t,e,s,i,n,r,a,o,l){const u=new ge,h=[new de,...ye.createCallbacks(e)];null!=t&&h.push(...t),h.push(u);const c=new pe(h);return c.setParams({epochs:s,initialEpoch:i,samples:n,steps:r,batchSize:a,verbose:e,doValidation:o,metrics:l}),{callbackList:c,history:u}}function we(t,s={},i=!1){return b(t,e.serialization.SerializationMap.getMap().classNameMap,s,"layer",i)}function ze(t,s){return e.tidy(()=>{"float32"!==t.dtype&&(t=t.asType("float32"));const n=e.sum(gt(t),s,!0),r=e.fill(n.shape,i()),a=e.sqrt(e.maximum(n,r));return e.div(t,a)})}function ke(t,s){return e.tidy(()=>e.mean(gt(e.sub(s,t)),-1))}function Se(t,s){return e.tidy(()=>e.mean(e.abs(e.sub(s,t)),-1))}function ve(t,s){return e.tidy(()=>{const n=e.sub(t,s),r=e.clipByValue(e.abs(t),i(),Number.MAX_VALUE),a=e.abs(e.div(n,r));return e.mul(100,e.mean(a,-1))})}function Ne(t,s,n=!1){return e.tidy(()=>{if(n)s=e.softmax(s);else{const t=e.sum(s,s.shape.length-1,!0);s=e.div(s,t)}return s=e.clipByValue(s,i(),1-i()),e.neg(e.sum(e.mul(t.toFloat(),e.log(s)),s.shape.length-1))})}function Ae(t,s,n=!1){return e.tidy(()=>{const r=e.floor(function(t){const e=[X(t.shape)];return t.reshape(e)}(t)).toInt(),a=(s=e.clipByValue(s,i(),1-i())).shape;return Ne(e.oneHot(r,a[a.length-1]).reshape(a),s,n)})}function Ce(t,s){return e.tidy(()=>{let n;return n=e.clipByValue(s,i(),1-i()),n=e.log(e.div(n,e.sub(1,n))),e.mean(function(t,s){if(!e.util.arraysEqual(t.shape,s.shape))throw new a(`logits and labels must have the same shape, but got shapes ${JSON.stringify(t.shape)} and ${JSON.stringify(s.shape)}`);return e.tidy(()=>{const e=s.relu(),i=s.abs().neg();return e.sub(s.mul(t)).add(i.exp().log1p())})}(t,n),-1)})}function xe(t,s){return e.tidy(()=>{const i=ze(t,-1),n=ze(s,-1),r=e.mul(i,n);return e.neg(e.sum(r,-1))})}ye.constructors={};const Ie={meanSquaredError:ke,meanAbsoluteError:Se,meanAbsolutePercentageError:ve,meanSquaredLogarithmicError:function(t,s){return e.tidy(()=>{const n=e.clipByValue(s,i(),Number.MAX_VALUE),r=e.log(e.add(1,n)),a=e.clipByValue(t,i(),Number.MAX_VALUE),o=e.log(e.add(1,a));return e.mean(gt(e.sub(r,o)),-1)})},squaredHinge:function(t,s){return e.tidy(()=>{const i=e.maximum(0,e.sub(1,e.mul(t,s)));return e.mean(gt(i),-1)})},hinge:function(t,s){return e.tidy(()=>{const i=e.maximum(0,e.sub(1,e.mul(t,s)));return e.mean(i,-1)})},categoricalHinge:function(t,s){return e.tidy(()=>{const i=e.sum(e.mul(t,s),-1),n=e.max(e.mul(e.sub(1,t),s),-1);return e.maximum(0,e.add(1,e.sub(n,i)))})},logcosh:function(t,s){return e.tidy(()=>{const i=Math.log(2),n=e.sub(s,t),r=e.sub(e.add(n,e.softplus(e.mul(-2,n))),i);return e.mean(r,-1)})},categoricalCrossentropy:Ne,sparseCategoricalCrossentropy:Ae,binaryCrossentropy:Ce,kullbackLeiblerDivergence:function(t,s){return e.tidy(()=>{const n=e.clipByValue(t,i(),1),r=e.clipByValue(s,i(),1);return e.sum(e.mul(t,e.log(e.div(n,r))),-1)})},poisson:function(t,s){return e.tidy(()=>{const n=e.log(e.add(i(),s));return e.mean(e.sub(s,e.mul(t,n)),-1)})},cosineProximity:xe};function Le(t){if("string"==typeof t){if(t in Ie)return Ie[t];let e="Unknown loss "+t;throw t.toLowerCase().includes("softmaxcrossentropy")&&(e=`Unknown loss ${t}. Use "categoricalCrossentropy" as the string name for tf.losses.softmaxCrossEntropy`),new a(e)}return t}function Te(t,s){return e.tidy(()=>{const i=e.mul(.5,e.onesLike(s)),n=it(e.greater(s,i),t.dtype);return e.mean(e.equal(t,n),-1)})}function Ee(t,s){return e.tidy(()=>it(e.equal(e.argMax(t,-1),e.argMax(s,-1)),"float32"))}function De(t,s){return e.tidy(()=>e.logicalAnd(t.equal(1),s.equal(1)).sum().cast("float32"))}function Oe(t,s){return e.tidy(()=>{const i=De(t,s),n=function(t,s){return e.tidy(()=>e.logicalAnd(t.equal(0),s.equal(1)).sum().cast("float32"))}(t,s),r=i.add(n);return e.where(e.greater(r,0),i.div(r),0).cast("float32")})}function Re(t,s){return e.tidy(()=>{const i=De(t,s),n=function(t,s){return e.tidy(()=>e.logicalAnd(t.equal(1),s.equal(0)).sum().cast("float32"))}(t,s),r=i.add(n);return e.where(e.greater(r,0),i.div(r),0).cast("float32")})}function Fe(t,e){return Ce(t,e)}function _e(t,s){return t.rank===s.rank&&(t=t.squeeze([t.rank-1])),(s=s.argMax(-1)).dtype!==t.dtype&&(s=s.asType(t.dtype)),e.equal(t,s).asType("float32")}const Me=Ne,$e=Ae,Be={binaryAccuracy:Te,categoricalAccuracy:Ee,precision:Oe,categoricalCrossentropy:Me,sparseCategoricalCrossentropy:$e,mse:ke,MSE:ke,mae:Se,MAE:Se,mape:ve,MAPE:ve,cosine:xe};function We(t){if("string"==typeof t&&t in Be)return Be[t];if("string"!=typeof t&&null!=t)return t;throw new a("Unknown metric "+t)}function Ue(t){if(h(null!==t,"Unknown LossOrMetricFn "+t),"string"==typeof t)return t;{let e;for(const s of Object.keys(Ie))if(Ie[s]===t){e=s;break}if(void 0!==e)return e;for(const s of Object.keys(Be))if(Be[s]===t){e=s;break}return void 0!==e?e:t.name}}function Pe(t,e,s=!1){if(null==t||"object"!=typeof t||Object.getPrototypeOf(t)!==Object.prototype||!function t(e){if(null===e)return!0;if("object"==typeof e){if(Object.getPrototypeOf(e)===Object.prototype){const s=Object.keys(e);for(const i of s){if("string"!=typeof i)return!1;if(!t(e[i]))return!1}return!0}if(Array.isArray(e)){for(const s of e)if(!t(s))return!1;return!0}return!1}{const t=typeof e;return"string"===t||"number"===t||"boolean"===t}}(t))throw new Error("User-defined metadata is expected to be a JSON object, but is not.");if(s){const s=JSON.stringify(t);s.length>1048576&&console.warn(`User-defined metadata of model "${e}" is too large in size (length=${s.length} when serialized). It is not recommended to store such large objects in user-defined metadata. Please make sure its serialized length is <= 1048576.`)}}function je(t,e,s,i=console.log){const n=function(t){let e=!0;const s=[],i=[];for(const e in t.nodesByDepth)s.push(t.nodesByDepth[e]);for(const t of s){if(t.length>1||1===t.length&&t[0].inboundLayers.length>1){e=!1;break}i.push(...t)}if(e)for(const s of t.layers){let t=!1;for(const n of s.inboundNodes)if(-1!==i.indexOf(n)){if(t){e=!1;break}t=!0}if(!e)break}return e}(t),r=["Layer (type)","Output shape","Param #"];let a;if(n?(e=e||65,s=s||[.45,.85,1]):(e=e||98,s=s||[.33,.55,.67,1]),s[s.length-1]<=1&&(s=s.map(t=>Math.floor(e*t))),!n){r.push("Receives inputs"),a=[];for(const e in t.nodesByDepth)a.push(...t.nodesByDepth[e])}i("_".repeat(e)),Ve(r,s,i),i("=".repeat(e));const o=t.layers;for(let t=0;t<o.length;++t)n?qe(o[t],s,i):Je(o[t],s,a,i),i((t===o.length-1?"=":"_").repeat(e));t.checkTrainableWeightsConsistency();const l=function(t){let e;e=null!=t.collectedTrainableWeights?Gt(t.collectedTrainableWeights):Gt(t.trainableWeights);return e}(t),u=Gt(t.nonTrainableWeights);i("Total params: "+(l+u)),i("Trainable params: "+l),i("Non-trainable params: "+u),i("_".repeat(e))}function Ve(t,e,s=console.log){let i="";for(let s=0;s<t.length;++s)s>0&&(i=i.slice(0,i.length-1)+" "),i+=t[s],i=i.slice(0,e[s]),i+=" ".repeat(e[s]-i.length);s(i)}function qe(t,e,s){let i;try{i=JSON.stringify(t.outputShape)}catch(t){i="multiple"}Ve([`${t.name} (${t.getClassName()})`,i,t.countParams().toString()],e,s)}function Je(t,e,s,i){let n;try{n=JSON.stringify(t.outputShape)}catch(t){n="multiple"}const r=[];for(const e of t.inboundNodes)if(!(null!=s&&s.length>0&&-1===s.indexOf(e)))for(let t=0;t<e.inboundLayers.length;++t){const s=e.inboundLayers[t].name,i=e.nodeIndices[t],n=e.tensorIndices[t];r.push(`${s}[${i}][${n}]`)}const a=t.name,o=t.getClassName(),l=0===r.length?"":r[0];Ve([`${a} (${o})`,n,t.countParams().toString(),l],e,i);for(let t=1;t<r.length;++t)Ve(["","","",r[t]],e,i)}function He(t,e,s){return("inboundNodes"===t||"outputLayers"===t||"inputLayers"===t)&&0===e&&"string"==typeof s}function Ze(t,e){if(null===t)return null;if("string"==typeof t)return f(t);if("number"==typeof t||"boolean"==typeof t)return t;if(t instanceof Array){const s=[],i=t.length;for(let n=0;n<i;++n){const i=t[n];He(e,n,i)?s.push(i):s.push(Ze(i,e))}return s}{const e={};for(const s of Object.keys(t)){const i=t[s];if("name"===s&&"string"==typeof i)e[s]=i;else{const t=f(s);e[t]=Ze(i,t)}}return e}}class Ke{constructor(t){if(this.id2Value={},this.id2Mask={},this.name2Id={},t instanceof Ke)for(const e in t.id2Value)this.id2Value[e]=t.id2Value[e],e in t.id2Mask&&(this.id2Mask[e]=t.id2Mask[e]);else{if(null==t)return;for(const e of t)this.add(e.key,e.value)}}add(t,s,i){if(null!=this.id2Value[t.id])throw new a(`Duplicate key: name=${t.name}, id=${t.id}`);return this.id2Value[t.id]=function(t,s){if(null==t.dtype||t.dtype===s.dtype)return s;try{return e.cast(s,t.dtype)}catch(e){throw new a(`The dtype of the feed (${s.dtype}) can not be cast to the dtype of the key '${t.name}' (${t.dtype}).`)}}(t,s),this.name2Id[t.name]=t.id,null!=i&&(this.id2Mask[t.id]=i),this}addFeed(t){this.add(t.key,t.value)}hasKey(t){return null!=this.id2Value[t.id]}names(){return Object.keys(this.name2Id)}getValue(t){if(t instanceof ee){if(null==this.id2Value[t.id])throw new a("Nonexistent key: "+t.name);return this.id2Value[t.id]}{const e=this.name2Id[t];if(null==e)throw new a("Feed dict has no SymbolicTensor name: "+t);return this.id2Value[e]}}getMask(t){if(t instanceof ee){if(null==this.id2Value[t.id])throw new a("Nonexistent key: "+t.name);return this.id2Mask[t.id]}{const e=this.name2Id[t];if(null==e)throw new a("Feed dict has no SymbolicTensor name: "+t);return this.id2Mask[e]}}disposeMasks(){null!=this.id2Mask&&e.dispose(this.id2Mask)}}const Ge={},Ye={};function Xe(t,s,i,n){const r=null!=i&&i.training,a=Array.isArray(t),o=a?t:[t],l=o.map(t=>t.name),u=[],h=s.names();for(const t of l)-1!==h.indexOf(t)?u.push(s.getValue(t)):u.push(null);null!=n&&(n.maxNumTensors=-1/0,n.minNumTensors=1/0);const c=l.join(",")+"|"+s.names().join(",");let p,g;if(null==Ge[c]){const t=function(t,s){e.util.assert(null!=t&&t.length>0,()=>"Expected at least one fetch, got none");let i=[],n={};if(1===t.length){const e=ts(t[0],s);i=e.sorted,n=e.recipientMap}else{const e=new Set;for(const r of t){const{sorted:t,recipientMap:a}=ts(r,s);for(const s of t)e.has(s.name)||(i.push(s),e.add(s.name));for(const t in a)null==n[t]&&(n[t]=new Set),a[t].forEach(e=>n[t].add(e))}}return{sorted:i,recipientCounts:Qe(n)}}(o,s);p=t.sorted,g=t.recipientCounts,Ge[c]=p,Ye[c]=g}p=Ge[c],g={},r||Object.assign(g,Ye[c]);const f=new Ke(s);for(let t=0;t<p.length;++t){if(null!=n){const t=e.memory().numTensors;t>n.maxNumTensors&&(n.maxNumTensors=t),t<n.minNumTensors&&(n.minNumTensors=t)}const a=p[t],o=a.sourceLayer;if(o instanceof ae)continue;const h=[],c=[],m=[];let y=!1;for(const t of a.inputs){const e=f.getValue(t),i=f.getMask(t);h.push(e),c.push(i),null!=i&&(y=!0),r||(g[t.name]--,0!==g[t.name]||s.hasKey(t)||-1!==l.indexOf(t.name)||e.isDisposed||!0===t.sourceLayer.stateful||m.push(e))}y&&((i=i||{}).mask=c[0]);const b=d(o.apply(h,i));let w=null;o.supportsMasking&&(w=o.computeMask(h,c));const z=es(a),k=Array.isArray(z)?z:[z];for(let t=0;t<k.length;++t){f.hasKey(k[t])||f.add(k[t],b[t],Array.isArray(w)?w[0]:w);const e=l.indexOf(k[t].name);-1!==e&&(u[e]=b[t])}r||e.dispose(m)}return f.disposeMasks(),a?u:u[0]}function Qe(t){const e={};for(const s in t)e[s]=t[s].size;return e}function ts(t,e){const s=new Set,i=[],n={};for(const t of e.names())s.add(t);const r=[],a=[];for(r.push(t);r.length>0;){const t=r[r.length-1];if(s.has(t.name)){r.pop();continue}const e=a[a.length-1]===r.length-1;if(0===t.inputs.length||e)r.pop(),i.push(t),s.add(t.name),e&&a.pop();else{a.push(r.length-1);for(const e of t.inputs)null==n[e.name]&&(n[e.name]=new Set),n[e.name].add(t.name),s.has(e.name)||r.push(e)}}return{sorted:i,recipientMap:n}}function es(t){let e;if(1===t.sourceLayer.inboundNodes.length)e=t.sourceLayer.output;else{let s=null;for(let e=0;e<t.sourceLayer.inboundNodes.length;++e)for(const i of t.sourceLayer.inboundNodes[e].outputTensors)if(i.id===t.id){s=e;break}e=t.sourceLayer.getOutputAt(s)}return e}class ss extends re{constructor(t){if(super({}),this.containerNodes=new Set,this.name=t.name,null==this.name){const t=this.getClassName().toLowerCase();this.name=qt(t)}if(this.supportsMasking=!1,this.trainable_=!0,Array.isArray(t.inputs)?this.inputs=t.inputs.slice():this.inputs=[t.inputs],Array.isArray(t.outputs)?this.outputs=t.outputs.slice():this.outputs=[t.outputs],z(this.inputs).length!==this.inputs.length)throw new a("The list of inputs passed to the model is redundant. All inputs should only appear once. Found: "+this.inputs.map(t=>t.name));z(this.outputs).length!==this.outputs.length&&console.warn("The list of outputs passed to the model is redundant. All outputs should only appear once. Found: "+this.outputs.map(t=>t.name)),this.inputLayers=[],this.inputLayersNodeIndices=[],this.inputLayersTensorIndices=[],this.outputLayers=[],this.outputLayersNodeIndices=[],this.outputLayersTensorIndices=[],this.layers=[],this.internalContainerRefs=[];for(const t of this.outputs){const e=t.sourceLayer,s=t.nodeIndex,i=t.tensorIndex;this.outputLayers.push(e),this.outputLayersNodeIndices.push(s),this.outputLayersTensorIndices.push(i)}for(const t of this.inputs){const e=t.sourceLayer,s=t.nodeIndex,i=t.tensorIndex;h(0===s,"input layer has >1 nodes"),h(0===i,"input layer has >1 tensors"),this.inputLayers.push(e),this.inputLayersNodeIndices.push(s),this.inputLayersTensorIndices.push(i)}this.inputNames=[],this.outputNames=[],this.feedInputShapes=[],this.feedInputNames=[],this.feedOutputNames=[];for(let e=0;e<this.inputLayers.length;e++){const s=this.inputLayers[e];if(!(s instanceof ae))throw new TypeError(`Input layers to a LayersModel must be InputLayer objects. Received inputs: ${t.inputs}. Input ${e} (0-based) originates from layer type ${s.getClassName()}.`);this.inputNames.push(s.name),this.feedInputShapes.push(s.batchInputShape),this.feedInputNames.push(s.name)}for(const t of this.outputLayers)this.outputNames.push(t.name);this.internalInputShapes=this.inputs.map(t=>t.shape),this.internalOutputShapes=this.outputs.map(t=>t.shape);const e={},s={},i={},n={},o={},l=[],u=(t,e,s,i,n,a)=>{null!=i&&null!=n&&null!=a||(i=t.sourceLayer,n=t.nodeIndex,a=t.tensorIndex);const h=i.inboundNodes[n];if(-1!==s.indexOf(h))throw new r(`The tensor ${t.name} at layer "${i.name}" is part of a cycle.`);if(-1!==e.indexOf(h))return;this.containerNodes.add(ss.nodeKey(i,n)),i.id in o||(o[i.id]=Object.keys(o).length),-1===s.indexOf(h)&&s.push(h);const c=h.inboundLayers.length;for(let t=0;t<c;t++){const i=h.inputTensors[t],n=h.inboundLayers[t],r=h.nodeIndices[t],a=h.tensorIndices[t];u(i,e,s,n,r,a)}for(e.push(h);s.indexOf(h)>=0;)s.splice(s.indexOf(h),1);l.push(h)},c=[],p=[];for(const t of this.outputs)u(t,c,p);const d=l.slice().reverse();for(const t of d){s[t.id]=t,t.id in e||(e[t.id]=0);let r=e[t.id];const a=null==i[t.outboundLayer.id]?0:i[t.outboundLayer.id];r=Math.max(r,a),i[t.outboundLayer.id]=r,n[t.outboundLayer.id]=t.outboundLayer,e[t.id]=r;for(let i=0;i<t.inboundLayers.length;i++){const n=t.inboundLayers[i],a=t.nodeIndices[i],o=n.inboundNodes[a],l=null==e[o.id]?0:e[o.id];e[o.id]=Math.max(r+1,l),s[o.id]=o}}const g={};for(const t in e){const i=e[t];i in g||(g[i]=[]),g[i].push(s[t])}const f={};for(const t in i){const e=i[t];e in f||(f[e]=[]),f[e].push(n[t])}let m=Object.keys(f).map(t=>parseInt(t,10)).sort(w);this.layers=[];for(const t of m){const e=f[t];e.sort((t,e)=>{const s=o[t.id],i=o[e.id];return s<i?-1:s>i?1:0});for(const t of e)t instanceof ss&&this.internalContainerRefs.push(t),this.layers.push(t)}this.layersByDepth=f,m=Object.keys(g).map(t=>parseInt(t,10)).sort(w);const y=this.inputs.slice(),b=[];for(const t of m)for(const e of g[t]){const t=e.outboundLayer;if(null!=t){for(const s of e.inputTensors)if(-1===y.indexOf(s))throw new r("Graph disconnected: cannot obtain value for tensor "+s+` at layer "${t.name}". The following previous layers were accessed without issue: `+b);for(const t of e.outputTensors)y.push(t);b.push(t.name)}}this.nodesByDepth=g;const k=this.layers.map(t=>t.name);for(const t of k){const e=k.filter(e=>e===t).length;if(1!==e)throw new r(`The name "${t}" is used ${e} times in the model. All layer names should be unique. Layer names: `+JSON.stringify(k))}this.outboundNodes=[],this.inboundNodes=[],new ie({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:this.inputs.map(t=>null),outputMasks:this.outputs.map(t=>null),inputShapes:this.inputs.map(t=>t.shape),outputShapes:this.outputs.map(t=>t.shape)}),this.built=!0,this._refCount=1}assertNotDisposed(){if(0===this._refCount)throw new Error(`Container '${this.name}' is already disposed.`)}dispose(){this.assertNotDisposed();const t={refCountAfterDispose:null,numDisposedVariables:0};if(0==--this._refCount){for(const e of this.layers)t.numDisposedVariables+=e.dispose().numDisposedVariables;for(const e of this.internalContainerRefs)t.numDisposedVariables+=e.dispose().numDisposedVariables}return t.refCountAfterDispose=this._refCount,t}get trainable(){return this.trainable_}set trainable(t){this.layers.forEach(e=>{e._trainableWeights.forEach(e=>e.trainable=t)}),this.trainable_=t}get trainableWeights(){if(this._trainableWeights.length>0)throw new a("Container instance unexpectedly contains _trainableWeights.The trainable weights of a Container are a union of the trainable weights of its consituent Layers. Its own _trainableWeights must remain an empty Array.");if(!this.trainable)return[];let t=[];for(const e of this.layers)t=t.concat(e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.layers)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.layers)e.push(...t.trainableWeights);return e.concat(t)}return t}get weights(){return this.trainableWeights.concat(this.nonTrainableWeights)}loadWeights(t,e=!0){const s={};let i=0;for(const t of this.layers)for(const e of t.weights){if(null!=s[e.originalName])throw new a("Duplicate weight name: "+e.originalName);s[e.originalName]=e,i++}const n=[];for(const i in t){let r=i;if(null==s[i]){const t=i.split("/");r=t.slice(0,-2).concat([t[t.length-1]]).join("/")}if(null!=s[r])n.push([s[r],t[i]]);else if(e)throw new a("Provided weight data has no target variable: "+i);delete s[r]}if(e){const t=[];for(const e in s)t.push(e);if(t.length>0)throw new a(`${t.length} of ${i} weights are not set: `+t)}Qt(n)}updatedConfig(){const t=this.getConfig(),e={};return e.className=this.getClassName(),e.config=t,e.kerasVersion="tfjs-layers 2.8.6",e.backend="TensorFlow.js",e}toJSON(t,e=!0){const s=function t(e,s){if(null==e)return null;if("string"==typeof e)return g(e);if("number"==typeof e||"boolean"==typeof e)return e;if(e instanceof Array){const i=[],n=e.length;for(let r=0;r<n;++r){const n=e[r];He(s,r,n)?i.push(n):i.push(t(n,s))}return i}{const s={};for(const i of Object.keys(e)){const n=e[i],r=g(i);s[r]="name"!==i&&"className"!==i||"string"!=typeof n?t(n,i):n}return s}}(this.updatedConfig());return e?JSON.stringify(s):s}call(t,s){return e.tidy(()=>{t=d(t);const e=new Ke;for(let s=0;s<this.inputs.length;++s)e.add(this.inputs[s],t[s]);return Xe(this.outputs,e,s)})}computeMask(t,s){return e.tidy(()=>{let e;return t=d(t),e=null==s?u(null,t.length):d(s),this.runInternalGraph(t,e)[1]})}computeOutputShape(t){const e=Ht(t);if(e.length!==this.inputLayers.length)throw new a(`Invalid inputShape argument ${t}: model has ${this.inputLayers.length} tensor inputs.`);const s={};for(let t=0;t<e.length;t++){const i=this.inputLayers[t],n=e[t];s[i.name+"_0_0"]=n}const i=Object.keys(this.nodesByDepth).map(t=>parseInt(t,10)).sort(w);if(i.length>1)for(const t of i){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer;if(-1!==this.inputLayers.map(t=>t.id).indexOf(e.id))continue;const i=[];for(let e=0;e<t.inboundLayers.length;e++){const n=t.inboundLayers[e],r=t.nodeIndices[e],a=t.tensorIndices[e],o=s[`${n.name}_${r}_${a}`];i.push(o)}const n=Ht(e.computeOutputShape(p(i))),r=e.inboundNodes.indexOf(t);for(let t=0;t<n.length;t++){s[`${e.name}_${r}_${t}`]=n[t]}}}const n=[],r=[];for(let t=0;t<this.outputLayers.length;t++){const e=this.outputLayers[t],s=this.outputLayersNodeIndices[t],i=this.outputLayersTensorIndices[t],n=`${e.name}_${s}_${i}`;r.push(n)}for(let t=0;t<r.length;t++){const e=r[t];h(e in s),n.push(s[e])}return p(n)}runInternalGraph(t,e){null==e&&(e=u(null,t.length));const s={};for(let i=0;i<this.inputs.length;++i){const n=this.inputs[i],r=t[i],a=e[i];s[n.id]=[r,a]}const i=Object.keys(this.nodesByDepth).map(t=>parseInt(t,10)).sort(w);for(const t of i){const e=this.nodesByDepth[t];for(const t of e){const e=t.outboundLayer,i=t.inputTensors,n=t.outputTensors,r=new Array;for(const t of i)t.id in s&&r.push(s[t.id]);if(r.length===i.length){let i,a,l,u,h={};if(null!=t.callArgs&&(h=t.callArgs),1===r.length){const[t,s]=r[0];null==h.mask&&(h.mask=s),l=d(e.call(t,h)),u=d(e.computeMask(t,s)),i=[t],a=[s]}else i=r.map(t=>t[0]),a=r.map(t=>t[1]),null==h.mask&&(h.mask=a),l=d(e.call(i,h)),u=d(e.computeMask(i,a));if(e.activityRegularizer)throw new o("LayersModel invocation with concrete Tensor value(s) in the presence of activity regularizer(s) is not supported yet.");for(let t=0;t<n.length;++t){const e=n[t],i=l[t],r=u[t];s[e.id]=[i,r]}}}}const n=[],r=[],a=[];for(const t of this.outputs){h(t.id in s,`Could not compute output ${t.name} : ${t.id}`);const[e,i]=s[t.id];a.push(e.shape),n.push(e),r.push(i)}return[n,r,a]}buildNodeConversionMap(t){const e={};let s;for(const t of this.layers){s=t instanceof ss?1:0;for(let i=0;i<t.inboundNodes.length;i++){const n=ss.nodeKey(t,i);this.containerNodes.has(n)&&(e[n]=s,s+=1)}}return e}getLayer(t,e){if(null!=e){if(this.layers.length<=e)throw new a(`Was asked to retrieve layer at index ${e}, but model only has ${this.layers.length} layer(s).`);return this.layers[e]}if(null==t)throw new a("Provide either a layer name or layer index");for(const e of this.layers)if(e.name===t)return e;throw new a("No such layer: "+t)}calculateLosses(){return e.tidy(()=>{const t=[];for(const e of this.layers)for(let s=0;s<e.inboundNodes.length;++s){const i=ss.nodeKey(e,s);this.containerNodes.has(i)&&t.push(...e.calculateLosses())}return t})}getConfig(){const t={name:this.name},e=this.buildNodeConversionMap(this.layers),s=[];for(const t of this.layers){const i=t.getClassName(),n=t.getConfig(),r=[];for(let s=0;s<t.inboundNodes.length;s++){const i=t.inboundNodes[s],n=ss.nodeKey(t,s);let a={};if(this.containerNodes.has(n)){if(i.callArgs)try{JSON.stringify(i.callArgs),a=i.callArgs}catch(e){console.warn(`Layer ${t.name} was passed non-serializable keyword arguments: `+i.callArgs+". They will not be included in the serialized model (and thus will be missing at deserialization time)."),a={}}if(i.inboundLayers.length>0){const t=[];for(let s=0;s<i.inboundLayers.length;s++){const n=i.inboundLayers[s],r=i.nodeIndices[s],o=i.tensorIndices[s];let l=e[ss.nodeKey(n,r)];null==l&&(l=0),t.push([n.name,l,o,a])}r.push(t)}}}const a={};a.name=t.name,a.className=i,a.config=n,a.inboundNodes=r,s.push(a)}t.layers=s;const i=[];for(let t=0;t<this.inputLayers.length;t++){const s=this.inputLayers[t],n=this.inputLayersNodeIndices[t],r=ss.nodeKey(s,n);if(!this.containerNodes.has(r))continue;let a=e[r];null==a&&(a=0);const o=this.inputLayersTensorIndices[t];i.push([s.name,a,o])}t.inputLayers=i;const n=[];for(let t=0;t<this.outputLayers.length;t++){const s=this.outputLayers[t],i=this.outputLayersNodeIndices[t],r=ss.nodeKey(s,i);if(!this.containerNodes.has(r))continue;let a=e[r];null==a&&(a=0);const o=this.outputLayersTensorIndices[t];n.push([s.name,a,o])}return t.outputLayers=n,t}static fromConfig(t,e,s={},i=!1){const n={},r={};function o(t,e){t.name in r?r[t.name].push(e):r[t.name]=[e]}function l(t,e){const s=[];let i;for(const r of e){const a=r[0],l=r[1],u=r[2];if(i=null==r[3]?{}:r[3],!(a in n))return void o(t,e);const h=n[a];if(h.inboundNodes.length<=l)return void o(t,e);const c=h.inboundNodes[l];s.push(c.outputTensors[u])}s.length>0&&t.apply(p(s),i)}function u(t){const s=t.name,r=we(t,null!=e.customObjects?e.customObjects:{});r.setFastWeightInitDuringBuild(i),n[s]=r;t.inboundNodes.forEach(t=>{if(!(t instanceof Array))throw new a("Corrupted configuration, expected array for nodeData: "+t);o(r,t)})}const c=e.name,d=e.layers;for(const t of d)u(t);for(;!k(r);)for(const t of d){const e=n[t.name];if(e.name in r){const t=r[e.name];delete r[e.name];for(const s of t)l(e,s)}}const g=[],f=[],m=e.inputLayers;for(const t of m){const e=t[0],s=t[1],i=t[2];h(e in n);const r=n[e].inboundNodes[s].outputTensors;g.push(r[i])}const y=e.outputLayers;for(const t of y){const e=t[0],s=t[1],i=t[2];h(e in n);const r=n[e].inboundNodes[s].outputTensors;f.push(r[i])}return new t({inputs:g,outputs:f,name:c})}get stateful(){if(this._stateful)throw new a("Container instance unexpectedly has _stateful = true. The statefulness of a Container is determined by the Layers it contains. Its _stateful property must remain the default false.");for(const t of this.layers)if(t.stateful)return!0;return!1}resetStates(){e.tidy(()=>{this.layers.forEach(t=>{t.stateful&&t.resetStates()})})}}function is(t,e){return function(t,e,s){const i=e.length;if(null==t||Array.isArray(t)&&0===t.length)return e.map(t=>null);if(1===i)return Array.isArray(t)&&1===t.length?t:"object"==typeof t&&e[0]in t?[t[e[0]]]:[t];if(Array.isArray(t)){if(t.length!==i)throw new Error(`Provided ${s} is an array of ${t.length} element(s), but the model has ${i} outputs. Make sure a set of weights is provided for each model output.`);return t}if("object"==typeof t&&Object.keys(t).length>0&&"object"==typeof t[Object.keys(t)[0]]){const s=[];return e.forEach(e=>{e in t?s.push(t[e]):s.push(null)}),s}throw new Error(`The model has multiple (${i}) outputs, so ${s} must be either an array with ${i} elements or an object with ${e} keys. Provided ${s} not understood: ${JSON.stringify(t)}`)}(t,e,"classWeight")}async function ns(t,s,i,n){if(null!=s||null!=n)throw new Error("Support sampleWeight is not implemented yet");if(null!=i){const s=e.tidy(()=>{if(1===t.shape.length)return t.clone();if(2===t.shape.length){if(t.shape[1]>1){const e=1;return t.argMax(e)}if(1===t.shape[1])return t.reshape([t.shape[0]]);throw new Error(`Encountered unexpected last-dimension size (${t.shape[1]}) during handling of class weights. The size is expected to be >= 1.`)}throw new Error(`Unexpected rank of target (y) tensor (${t.rank}) during handling of class weights. The rank is expected to be 1 or 2.`)}),n=Array.from(await s.data());e.dispose(s);const r=[];return n.forEach(t=>{if(null==i[t])throw new Error(`classWeight must contain all classes in the training data. The class ${t} exists in the data but not in classWeight`);r.push(i[t])}),e.tensor1d(r,"float32")}return null}function rs(t,s){return e.mul(t,s)}function as(t,s){let i,n;const r=s;i=r.xs,n=r.ys,e.util.assert(null!=i&&null!=n,()=>"A Dataset iterator for fitDataset() is expected to generate objects of the form `{xs: xVal, ys: yVal}`, where the two values may be `tf.Tensor`, an array of Tensors, or a map of string to Tensor.  The provided Dataset instead generates "+s);const a=os("input",t.inputNames,i),o=os("output",t.outputNames,n),l=a[0].shape[0];e.util.assert(a.length===t.inputs.length,()=>`LayersModel has ${t.inputs.length} inputs, but the dataset provides ${a.length} inputs.  (Expected input keys: `+JSON.stringify(t.inputNames)+")"),e.util.assert(o.length===t.outputs.length,()=>`LayersModel has ${t.outputs.length} outputs, but the dataset provides ${o.length} outputs.  (Expected output keys: `+JSON.stringify(t.outputNames)+")");for(let s=0;s<a.length;s++)e.util.assert(a[s].shape[0]===l,()=>`Batch size mismatch: input ${t.inputNames[s]} has ${a[s].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`);for(let s=0;s<o.length;s++)e.util.assert(o[s].shape[0]===l,()=>`Batch size mismatch: output ${t.outputNames[s]} has ${o[s].shape[0]}; expected  ${l} based on input ${t.inputNames[0]}.`);return{xs:a,ys:o}}function os(t,s,i){if(i instanceof e.Tensor)return[i];if(Array.isArray(i))return e.util.assert(i.length===s.length,()=>`Received an array of ${i.length} Tensors, but expected ${s.length} to match the ${t} keys ${s}.`),i;{const e=[];for(const n of s){if(null==i[n])throw new a(`The feature data generated by the dataset lacks the required ${t} key '${n}'.`);e.push(i[n])}return e}}async function ls(t,s,i){const n=null!=i.batchesPerEpoch;if(e.util.assert(null!=t.optimizer,()=>"You must compile a model before training/testing. Use LayersModel.compile(modelCompileConfig)."),e.util.assert(null!=i,()=>"For fitDataset(), the 2nd argument (config) is required, but it is not provided in this call."),e.util.assert(null!=i.epochs&&i.epochs>0&&Number.isInteger(i.epochs),()=>"For fitDataset(), config.epochs is expected to be a positive integer, but got "+i.epochs),e.util.assert(!n||i.batchesPerEpoch>0&&Number.isInteger(i.batchesPerEpoch),()=>"For fitDataset(), config.batchesPerEpoch is expected to be a positive integer if specified, but got "+i.batchesPerEpoch),e.util.assert(null==i.validationSplit,()=>"`validationSplit` is not supported by `fitDataset()`. Use validationData instead."),t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");t.isTraining=!0;try{const r=null!=i.validationData;let a,l;if(r)if(us(i.validationData))e.util.assert(null==i.validationBatches||i.validationBatches>0&&Number.isInteger(i.validationBatches),()=>"For fitDataset() with dataset-based validation, config.validationBatches is expected not to be provided, or to be a positive integer, but got "+i.validationBatches);else{const t=function(t){if(3===t.length)throw new o("Validation with sample weights is not implemented yet.");return{xs:t[0],ys:t[1]}}(i.validationData);a=t.xs,l=t.ys}const u=t.makeTrainFunction(),h=t.getDedupedMetricsNames();let c;c=r?h.slice().concat(h.map(t=>"val_"+t)):h.slice();const p=me(i.callbacks,i.yieldEvery),g=null==i.verbose?1:i.verbose,{callbackList:f,history:m}=be(p,g,i.epochs,null,null,function(t,e){let s=null;null!=e.batchesPerEpoch?s=e.batchesPerEpoch:Number.isFinite(t.size)&&(s=t.size);return s}(s,i),null,r,c);f.setModel(t),t.history=m,await f.onTrainBegin(),t.stopTraining_=!1;let y=null==i.initialEpoch?0:i.initialEpoch,b=await s.iterator();for(;y<i.epochs;){const o={};await f.onEpochBegin(y);let c=0,p=0;for(n||(b=await s.iterator());!n||c<i.batchesPerEpoch;){const s=await b.next();if(n&&s.done){console.warn("You provided `batchesPerEpoch` as "+i.batchesPerEpoch+", but your dataset iterator ran out of data after "+c+" batches; interrupting training. Make sure that your dataset can generate at least `batchesPerEpoch * epochs` batches (in this case, "+i.batchesPerEpoch*i.epochs+" batches). You may need to use the repeat() function when building your dataset.");break}if(null!=s.value){const{xs:n,ys:r}=as(t,s.value),a={};a.batch=p,a.size=n[0].shape[0],await f.onBatchBegin(p,a);const o=[];if(null!=i.classWeight){const e=is(i.classWeight,t.outputNames);for(let t=0;t<e.length;++t)o.push(await ns(r[t],null,e[t]))}const l=n.concat(r).concat(o),d=u(l);e.dispose(l);for(let t=0;t<h.length;++t){const s=h[t],i=d[t];a[s]=i,e.keep(i)}await f.onBatchEnd(p,a),ue(a),p++,c++}if(n?c>=i.batchesPerEpoch:s.done){if(r){let e;e=us(i.validationData)?d(await t.evaluateDataset(i.validationData,{batches:i.validationBatches})):d(t.evaluate(a,l,{batchSize:null==i.validationBatchSize?32:i.validationBatchSize,verbose:0}));for(let s=0;s<t.metricsNames.length;++s)o["val_"+t.metricsNames[s]]=e[s]}break}if(t.stopTraining_)break}if(await f.onEpochEnd(y,o),y++,t.stopTraining_)break}return await f.onTrainEnd(),await t.history.syncData(),t.history}finally{t.isTraining=!1}}function us(t){return"function"==typeof t.iterator}function hs(t){e.util.assert(t>0&&Number.isInteger(t),()=>"batchSize is required to be a positive integer, but got "+t)}function cs(t,e,s){return null==t?[null]:Array.isArray(t)?t.map(t=>rt(t,e,s-e)):rt(t,e,s-e)}function ps(t,s){return e.tidy(()=>null==t?null:Array.isArray(t)?t.map(t=>ps(t,s)):dt(t,"int32"===s.dtype?s:s.toInt()))}function ds(t,e){const s=[];let i=0,n=null;for(;i<t;)n=i+e,n>=t&&(n=t),s.push([i,n]),i=n;return s}async function gs(t,s,i,n={}){if(t.isTraining)throw new Error("Cannot start training because another fit() call is ongoing.");let r,l,u,h,c,p,d;t.isTraining=!0;try{const g=null==n.batchSize?32:n.batchSize;hs(g);const f=!1,m=await t.standardizeUserData(s,i,n.sampleWeight,n.classWeight,f,g);r=m[0],l=m[1],d=m[2];let y,b=!1;if(null!=n.validationData&&n.validationData.length>0){if(b=!0,2!==n.validationData.length)throw 3===n.validationData.length?new o("validationData including sample weights is not supported yet."):new a("When passing validation data, it must contain 2 (valX, valY) or 3 (valX, valY, valSampleWeight) items; "+n.validationData+" is invalid.");u=n.validationData[0],h=n.validationData[1];const e=!0,s=await t.standardizeUserData(u,h,null,null,e,g);c=s[0],p=s[1],y=c.concat(p)}else if(null!=n.validationSplit&&n.validationSplit>0&&n.validationSplit<1){b=!0;const t=Math.floor(r[0].shape[0]*(1-n.validationSplit)),e=r[0].shape[0];c=cs(r,t,e),r=cs(r,0,t),p=cs(l,t,e),l=cs(l,0,t),y=c.concat(p)}else null!=n.validationSteps&&(b=!0);const w=r.concat(l).concat(d);t.checkTrainableWeightsConsistency();const z=t.makeTrainFunction(),k=t.getDedupedMetricsNames();let S,v;b?(t.makeTestFunction(),S=t.testFunction,v=k.slice().concat(k.map(t=>"val_"+t))):(S=null,y=[],v=k.slice());const N=me(n.callbacks,n.yieldEvery);return await async function(t,s,i,n,r,l,u,h,c,p,d,g,f,m,y){null==r&&(r=32),null==l&&(l=1),null==d&&(d=!0),null==f&&(f=0);let b=!1;if(null!=c&&null!=p&&(b=!0),null!=y&&(b=!0,null==m))throw new a("Can only use `validationSteps` when doing step-wise training, i.e., `stepsPerEpoch` must be set.");const w=t.checkNumSamples(i,r,m,"steps_per_epoch");let z;null!=w&&(z=st(0,w)),null==u&&(u=1);const{callbackList:k,history:S}=be(h,u,l,f,w,m,r,b,g);k.setModel(t),t.history=S,await k.onTrainBegin(),t.stopTraining_=!1;for(let a=f;a<l;++a){await k.onEpochBegin(a);const l={};if(null!=m)throw new o("stepsPerEpoch mode is not implemented yet.");{if("batch"===d)throw new o("batch shuffling is not implemneted yet");d&&e.util.shuffle(z);const a=e.tensor1d(z),u=ds(w,r);for(let o=0;o<u.length;++o){const h={};if(await k.onBatchBegin(o,h),e.tidy(()=>{const d=u[o][0],g=u[o][1],f=rt(a,d,g-d);h.batch=o,h.size=g-d;const m=ps(i,f),y=s(m);for(let t=0;t<n.length;++t){const s=n[t],i=y[t];h[s]=i,e.keep(i)}if(o===u.length-1&&b){const s=t.testLoop(c,p,r);for(let t=0;t<n.length;++t){const i=n[t],r=s[t];e.keep(r),l["val_"+i]=r}}}),await k.onBatchEnd(o,h),ue(h),t.stopTraining_)break}a.dispose()}if(await k.onEpochEnd(a,l),t.stopTraining_)break}return await k.onTrainEnd(),await t.history.syncData(),t.history}(t,z,w,k,g,n.epochs,n.verbose,N,S,y,n.shuffle,v,n.initialEpoch,null,null)}finally{t.isTraining=!1,ms(r,s),ms(l,i),ms(c,u),ms(p,h),null!=d&&e.dispose(d)}}function fs(t){const s=[];t instanceof e.Tensor&&(t=[t]);for(let e=0;e<t.length;++e){const i=t[e];if(1===i.rank)s.push(nt(i,1));else{if(0===i.rank)throw new Error("Expected tensor to be at least 1D, but received a 0D tensor (scalar).");s.push(i)}}return s}function ms(t,s){if(null==t)return;const i=[];if(s instanceof e.Tensor)i.push(s.id);else if(Array.isArray(s))s.forEach(t=>i.push(t.id));else if(null!=s)for(const t in s){const e=s[t];i.push(e.id)}const n=[];if(t instanceof e.Tensor)-1===i.indexOf(t.id)&&n.push(t);else if(Array.isArray(t))t.forEach(t=>{-1===i.indexOf(t.id)&&n.push(t)});else if(null!=t)for(const e in t){const s=t[e];-1===i.indexOf(s.id)&&n.push(s)}n.forEach(t=>{t.isDisposed||t.dispose()})}function ys(t){return Array.isArray(t)}function bs(t){return!function(t){return t instanceof e.Tensor}(t)&&!ys(t)}function ws(t,e,s,i=!0,n=""){if(null==e||0===e.length){if(null!=t){let e=!1;if(ys(t)&&t.length>0)e=!0;else if(bs(t)){for(const s in t)if(t.hasOwnProperty(s)){e=!0;break}}else e=!0;if(e)throw new a(`Error when checking model ${n} expected no data, but got `+t)}return[]}if(null==t)return e.map(t=>null);let r;if(bs(t)){t=t,r=[];for(const s of e){if(null==t[s])throw new a(`No data provided for "${s}". Need data for each key in: `+e);r.push(t[s])}}else if(ys(t)){if((t=t).length!==e.length)throw new a(`Error when checking model ${n}: the Array of Tensors that you are passing to your model is not the size the model expected. Expected to see ${e.length} Tensor(s), but instead got the following list of Tensor(s): `+t);r=t}else{if(t=t,e.length>1)throw new a(`The model ${n} expects ${e.length} Tensor(s), but only received one Tensor. Found: Tensor with shape `+t.shape);r=[t]}if(r=fs(r),null!=s)for(let t=0;t<e.length;++t){if(null==s[t])continue;const o=r[t];if(o.shape.length!==s[t].length)throw new a(`Error when checking ${n}: expected ${e[t]} to have ${s[t].length} dimension(s). but got array with shape `+o.shape);for(let r=0;r<s[t].length;++r){if(0===r&&!i)continue;const l=o.shape[r],u=s[t][r];if(null!=u&&u>=0&&l!==u)throw new a(`Error when checking ${n}: expected ${e[t]} to have shape [${s[t]}], but got array with shape [${o.shape}].`)}}return r}function zs(t,e,s,i=!0,n=""){let r;if(Array.isArray(t)){if(t.length!==e.length)throw new a(`Error when checking model ${n}: the Array of Tensors that you are passing to your model is not the size the the model expected. Expected to see ${e.length} Tensor(s), but instead got ${t.length} Tensors(s).`);r=t}else{if(e.length>1)throw new a(`The model expects ${e.length} ${n} Tensors, but only received one Tensor. Found: array with shape `+JSON.stringify(t.shape)+".");r=[t]}if(null!=s)for(let t=0;t<e.length;++t){if(null==s[t])continue;const o=r[t];if(o.shape.length!==s[t].length)throw new a(`Error when checking ${n}: expected ${e[t]} to have ${s[t].length} dimension(s), but got array with shape `+JSON.stringify(o.shape));for(let r=0;r<s[t].length;++r){if(0===r&&!i)continue;const l=o.shape[r],u=s[t][r];if(null!=u&&u!==l)throw new a(`Error when checking ${n}: expected ${e[t]} to have shape ${JSON.stringify(s[t])} but got array with shape ${JSON.stringify(o.shape)}.`)}}}class ks extends ss{constructor(t){super(t),this.isTraining=!1}summary(t,e,s=console.log){if(!this.built)throw new a("This model has never been called, thus its weights have not been created yet. So no summary can be displayed. Build the model first (e.g., by calling it on some test data).");je(this,t,e,s)}compile(t){if(null==t.loss&&(t.loss=[]),this.loss=t.loss,"string"==typeof t.optimizer)this.optimizer_=function(t){const s={Adagrad:()=>e.train.adagrad(.01),Adadelta:()=>e.train.adadelta(1,.95,i()),Adam:()=>e.train.adam(.001,.9,.999,i()),Adamax:()=>e.train.adamax(.002,.9,.999,i(),0),RMSProp:()=>e.train.rmsprop(.001,.9,0,i()),SGD:()=>e.train.sgd(.01)};if(s.adagrad=s.Adagrad,s.adadelta=s.Adadelta,s.adam=s.Adam,s.adamax=s.Adamax,s.rmsprop=s.RMSProp,s.sgd=s.SGD,t in s)return s[t]();throw new a("Unknown Optimizer "+t)}(t.optimizer),this.isOptimizerOwned=!0;else{if(!(t.optimizer instanceof e.Optimizer))throw new a("User-defined optimizer must be an instance of tf.Optimizer.");this.optimizer_=t.optimizer,this.isOptimizerOwned=!1}let s=[];if(Array.isArray(t.loss)||"string"==typeof t.loss||"function"==typeof t.loss)if(Array.isArray(t.loss)){if(t.loss.length!==this.outputs.length)throw new a(`When passing an Array as loss, it should have one entry per model output. The model has ${this.outputs.length} output(s), but you passed loss=${t.loss}.`);const e=t.loss;s=e.map(t=>Le(t))}else{const e=Le(t.loss);this.outputs.forEach(t=>{s.push(e)})}else{t.loss=t.loss;for(const e in t.loss)if(-1===this.outputNames.indexOf(e))throw new a(`Unknown entry in loss dictionary: "${e}". Only expected the following keys: `+this.outputNames);for(const e of this.outputNames)null==t.loss[e]&&console.warn(`Output "${e}" is missing from loss dictionary. We assume this was done on purpose, and we will not be expecting data to be passed to ${e} during training`),s.push(Le(t.loss[e]))}this.lossFunctions=s,this.feedOutputNames=[],this.feedOutputShapes=[],this.feedLossFns=[];for(let t=0;t<this.outputs.length;++t){const e=this.internalOutputShapes[t],s=this.outputNames[t];this.feedOutputNames.push(s),this.feedOutputShapes.push(e),this.feedLossFns.push(this.lossFunctions[t])}const n=[];this.metrics=t.metrics,this.metricsNames=["loss"],this.metricsTensors=[],H("loss",()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;const e=this.lossFunctions[t];this.outputs.length>1&&(this.metricsTensors.push([e,t]),this.metricsNames.push(this.outputNames[t]+"_loss"))}});const r=function(t,e){if(null==t||Array.isArray(t)&&0===t.length)return e.map(t=>[]);let s;if("string"==typeof t||"function"==typeof t)s=[t];else{if(!Array.isArray(t)&&"object"!=typeof t)throw new TypeError("Type of metrics argument not understood. Expected an string,function, Array, or Object, found: "+t);s=t}if(Array.isArray(s))return e.map(t=>s);{const t=[];for(const i of e){let e=s.hasOwnProperty(i)?s[i]:[];Array.isArray(e)||(e=[e]),t.push(e)}return t}}(t.metrics,this.outputNames),o=(t,e,s)=>{this.outputNames.length>1&&(e=this.outputNames[t]+"_"+e),this.metricsNames.push(e),this.metricsTensors.push([s,t])};H("metric",()=>{for(let t=0;t<this.outputs.length;++t){if(-1!==n.indexOf(t))continue;(e=>{let s,i,n;for(const r of e){if("string"==typeof r&&-1!==["accuracy","acc","crossentropy","ce"].indexOf(r)){const e=this.internalOutputShapes[t];let a;1===e[e.length-1]||this.lossFunctions[t]===Ce?-1!==["accuracy","acc"].indexOf(r)?i=Te:-1!==["crossentropy","ce"].indexOf(r)&&(i=Fe):this.lossFunctions[t]===Ae?-1!==["accuracy","acc"].indexOf(r)?i=_e:-1!==["crossentropy","ce"].indexOf(r)&&(i=$e):-1!==["accuracy","acc"].indexOf(r)?i=Ee:-1!==["crossentropy","ce"].indexOf(r)&&(i=Me),-1!==["accuracy","acc"].indexOf(r)?a="acc":-1!==["crossentropy","ce"].indexOf(r)&&(a="ce"),n=i,s=""+a}else{const t=We(r);n=t,s=""+Ue(r)}let e;H(s,()=>{e=n}),o(t,s,e)}})(r[t])}}),this.collectedTrainableWeights=this.trainableWeights}checkTrainableWeightsConsistency(){null!=this.collectedTrainableWeights&&this.trainableWeights.length!==this.collectedTrainableWeights.length&&console.warn("Discrepancy between trainableweights and collected trainable weights. Did you set `model.trainable` without calling `model.compile()` afterwards?")}evaluate(t,e,s={}){const i=null==s.batchSize?32:s.batchSize;hs(i);const n=this.standardizeUserDataXY(t,e,!0,i);try{const r=n[0].concat(n[1]);this.makeTestFunction();const a=this.testFunction;return p(this.testLoop(a,r,i,s.verbose,s.steps))}finally{ms(n[0],t),ms(n[1],e)}}async evaluateDataset(t,s){return this.makeTestFunction(),async function(t,s,i){const n=null!=(i=i||{}).batches,r=t.testFunction;let a=[];if(i.verbose>0)throw new o("Verbose mode is not implemented yet.");e.util.assert(!n||i.batches>0&&Number.isInteger(i.batches),()=>"Test loop expects `batches` to be a positive integer, but received "+JSON.stringify(i.batches));const l="function"==typeof s.next?s:await s.iterator();let u=0,h=0;for(;!n||h<i.batches;){const s=await l.next();if(a=e.tidy(()=>{if(s.value){const{xs:i,ys:n}=as(t,s.value),o=i.concat(n),l=e.tidy(()=>r(o));if(e.dispose(o),0===h)for(let t=0;t<l.length;++t)a.push(e.scalar(0));const c=o[0].shape[0];for(let t=0;t<l.length;++t){const s=l[t],i=a[t];a[t]=e.tidy(()=>e.add(a[t],e.mul(c,s))),h>0&&e.dispose(i)}e.dispose(l),u+=c,++h}return a}),s.done){n&&console.warn(`Your dataset iterator ran out of data during evaluateDataset(). Interrupting evalution. Make sure that your dataset can generate at least \`batches\` batches (in this case, ${i.batches} batches). You may need to use the repeat() function when building your dataset.`);break}}for(let t=0;t<a.length;++t){const s=a[t];a[t]=e.div(a[t],u),e.dispose(s)}return p(a)}(this,t,s)}checkNumSamples(t,e,s,i="steps"){let n;if(null!=s){if(n=null,null!=e)throw new a(`If ${i} is set, batchSize must be null or undefined.Got batchSize = `+e)}else{if(null==t)throw new a("Either the input data should have a defined shape, or "+i+" shoud be specified.");n=Array.isArray(t)?t[0].shape[0]:t.shape[0]}return n}execute(t,s){if(Array.isArray(s)&&0===s.length)throw new a("`outputs` is an empty Array, which is not allowed.");const i=Array.isArray(s),n=i?s:[s],r=this.retrieveSymbolicTensors(n),o=new Ke;if(t instanceof e.Tensor&&(t=[t]),Array.isArray(t)){if(t.length!==this.inputs.length)throw new a(`The number of inputs provided (${t.length}) does not match the number of inputs of this model (${this.inputs.length}).`);for(let e=0;e<this.inputs.length;++e)o.add(this.inputs[e],t[e])}else for(const e of this.inputs){const s=t[e.name];if(null==s)throw new a("No value is provided for the model's input "+e.name);o.add(e,s)}const l=Xe(r,o);return i?l:l[0]}retrieveSymbolicTensors(t){const e=u(null,t.length);let s=t.length;for(const i of this.layers){const n=Array.isArray(i.output)?i.output:[i.output],r=n.map(t=>t.name);for(let i=0;i<t.length;++i){const a=r.indexOf(t[i]);if(-1!==a&&(e[i]=n[a],s--),0===s)break}if(0===s)break}if(s>0){const s=[];throw e.forEach((e,i)=>{null==e&&s.push(t[i])}),new a("Cannot find SymbolicTensors for output name(s): "+JSON.stringify(s))}return e}predictLoop(t,s=32,i=!1){return e.tidy(()=>{const n=this.checkNumSamples(t);if(i)throw new o("Verbose predictLoop() is not implemented yet.");const r=ds(n,s),a=this.outputs.map(t=>[]);for(let s=0;s<r.length;++s){e.tidy(()=>{const e=r[s][0],i=r[s][1],n=cs(t,e,i),a=[];if(Array.isArray(n))for(let t=0;t<n.length;++t)a.push({key:this.inputs[t],value:n[t]});else a.push({key:this.inputs[0],value:n});const o=new Ke(a);return Xe(this.outputs,o)}).forEach((t,e)=>a[e].push(t))}return p(a.map(t=>e.concat(t,0)))})}predict(t,e={}){const s=fs(t);zs(s,this.inputNames,this.feedInputShapes,!1);try{const i=null==e.batchSize?32:e.batchSize;return hs(i),this.predictLoop(s,i)}finally{ms(s,t)}}predictOnBatch(t){zs(t,this.inputNames,this.feedInputShapes,!0);const e=(Array.isArray(t)?t[0]:t).shape[0];return this.predictLoop(t,e)}standardizeUserDataXY(t,s,i=!0,n){if(null==this.optimizer_)throw new r("You must compile a model before training/testing. Use LayersModel.compile(modelCompileArgs).");const o=[];for(let t=0;t<this.feedOutputShapes.length;++t){const e=this.feedOutputShapes[t];this.feedLossFns[t]===Ae?o.push(e.slice(0,e.length-1).concat([1])):o.push(e)}if(function(t,s,i){const n=z(t.map(t=>t.shape[0]));n.sort();const r=z(s.map(t=>t.shape[0]));if(r.sort(),n.length>1)throw new a("All input Tensors (x) should have the same number of samples. Got array shapes: "+JSON.stringify(t.map(t=>t.shape)));if(r.length>1)throw new a("All target Tensors (y) should have the same number of samples. Got array shapes: "+JSON.stringify(s.map(t=>t.shape)));if(n.length>0&&r.length>0&&!e.util.arraysEqual(n,r))throw new a(`Input Tensors should have the same number of samples as target Tensors. Found ${n[0]} input sample(s) and ${r[0]} target sample(s).`)}(t=ws(t,this.feedInputNames,this.feedInputShapes,!1,"input"),s=ws(s,this.feedOutputNames,o,!1,"target")),function(t,e,s){const i=[ke,Ce,Ne];for(let n=0;n<t.length;++n){const r=t[n],o=e[n],l=s[n];if(null!=o){if(o===Ne&&1===r.shape[r.shape.length-1])throw new a(`You are passing a target array of shape ${r.shape} while using a loss 'categorical_crossentropy'. 'categorical_crossentropy'expects targets to be binary matrices (1s and 0s) of shape [samples, classes].`);if(-1!==i.indexOf(o)){const t=r.shape.slice(1),e=l.slice(1);for(let s=0;s<t.length;++s){const i=t[s],n=e[s];if(null!=n&&i!==n)throw new a(`A target Tensor with shape ${r.shape} was passed for an output of shape ${l}, while using a loss function that expects targets to have the same shape as the output.`)}}}}}(s,this.feedLossFns,this.feedOutputShapes),this.stateful&&null!=n&&n>0&&t[0].shape[0]%n!=0)throw new a(`In a stateful network, you should only pass inputs with a number of samples that is divisible by the batch size ${n}. Found: ${t[0].shape[0]} sample(s).`);return[t,s]}async standardizeUserData(t,e,s,i,n=!0,r){const[a,o]=this.standardizeUserDataXY(t,e,n,r);if(null!=s)throw new Error("sample weight is not supported yet.");let l=null;if(null!=i){const t=is(i,this.outputNames);l=[];for(let e=0;e<t.length;++e)l.push(await ns(o[e],null,t[e]))}return[a,o,l]}testLoop(t,s,i,n=0,r){return e.tidy(()=>{const a=this.checkNumSamples(s,i,r,"steps"),l=[];if(n>0)throw new o("Verbose mode is not implemented yet.");if(null!=r)throw new o("steps mode in testLoop() is not implemented yet");{const n=ds(a,i),r=e.tensor1d(st(0,a));for(let i=0;i<n.length;++i){const a=n[i][0],o=n[i][1],u=rt(r,a,o-a),h=ps(s,u),c=t(h);if(0===i)for(let t=0;t<c.length;++t)l.push(e.scalar(0));for(let t=0;t<c.length;++t){const s=c[t];l[t]=e.add(l[t],e.mul(o-a,s))}}for(let t=0;t<l.length;++t)l[t]=e.div(l[t],a)}return l})}getDedupedMetricsNames(){const t=this.metricsNames,e=[];for(let s=0;s<t.length;++s){const i=t[s];let n=i;if(c(t,i)>1){n+="_"+c(t.slice(0,s),i)}e.push(n)}return e}makeTrainFunction(){return t=>{const s=[],i=t.slice(0,this.inputs.length),n=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),r=t.slice(this.inputs.length+this.outputs.length,this.inputs.length+2*this.outputs.length),a=[],o=this.collectedTrainableWeights.map(t=>t.read());return[this.optimizer_.minimize(()=>{const t=[];for(let e=0;e<this.inputs.length;++e)t.push({key:this.inputs[e],value:i[e]});const o=new Ke(t),l=Xe(this.outputs,o,{training:!0});let u;for(let t=0;t<this.lossFunctions.length;++t){let i=(0,this.lossFunctions[t])(n[t],l[t]);null!=r[t]&&(i=rs(i,r[t]));const a=e.mean(i);s.push(a),u=0===t?i:e.add(u,i)}for(let t=0;t<this.metricsTensors.length;++t){let i;if(this.outputs.length>1&&t<this.outputs.length)i=s[t];else{const s=this.metricsTensors[t][0],r=this.metricsTensors[t][1];i=e.mean(s(n[r],l[r]))}e.keep(i),a.push(i)}return u=e.mean(u),this.calculateLosses().forEach(t=>{u=e.add(u,t)}),u},!0,o)].concat(a)}}makeTestFunction(){this.testFunction=t=>e.tidy(()=>{const s=[];let i;const n=t.slice(0,this.inputs.length),r=t.slice(this.inputs.length,this.inputs.length+this.outputs.length),a=[];for(let t=0;t<this.inputs.length;++t)a.push({key:this.inputs[t],value:n[t]});const o=new Ke(a),l=Xe(this.outputs,o);for(let t=0;t<this.lossFunctions.length;++t){const n=this.lossFunctions[t],a=e.mean(n(r[t],l[t]));i=0===t?a:e.add(i,a),s.push(i)}for(let t=0;t<this.metricsTensors.length;++t){const i=this.metricsTensors[t][0],n=this.metricsTensors[t][1],a=e.mean(i(r[n],l[n]));s.push(a)}return s})}async fit(t,e,s={}){return gs(this,t,e,s)}async fitDataset(t,e){return ls(this,t,e)}async trainOnBatch(t,s){const i=await this.standardizeUserData(t,s),n=i[0],r=i[1],a=this.makeTrainFunction()(n.concat(r)),o=[];for(const t of a){const e=await t.data();o.push(e[0])}return e.dispose(a),p(o)}getNamedWeights(t){const e=[],s=null!=t&&t.trainableOnly,i=s?this.trainableWeights:this.weights,n=this.getWeights(s);for(let t=0;t<i.length;++t)s&&!i[t].trainable||e.push({name:i[t].originalName,tensor:n[t]});return e}set stopTraining(t){this.stopTraining_=t}get stopTraining(){return this.stopTraining_}get optimizer(){return this.optimizer_}set optimizer(t){this.optimizer_!==t&&(this.optimizer_=t,this.isOptimizerOwned=!1)}dispose(){const t=super.dispose();if(0===t.refCountAfterDispose&&null!=this.optimizer&&this.isOptimizerOwned){const s=e.memory().numTensors;this.optimizer_.dispose(),t.numDisposedVariables+=s-e.memory().numTensors}return t}getLossIdentifiers(){let t;if("string"==typeof this.loss)t=g(this.loss);else if(Array.isArray(this.loss)){for(const t of this.loss)if("string"!=typeof t)throw new Error("Serialization of non-string loss is not supported.");t=this.loss.map(t=>g(t))}else{const e=Object.keys(this.loss);t={};const s=this.loss;for(const i of e){if("string"!=typeof s[i])throw new Error("Serialization of non-string loss is not supported.");t[i]=g(s[i])}}return t}getMetricIdentifiers(){if("string"==typeof this.metrics||"function"==typeof this.metrics)return[g(Ue(this.metrics))];if(Array.isArray(this.metrics))return this.metrics.map(t=>g(Ue(t)));{const t={};for(const e in this.metrics)t[e]=g(Ue(this.metrics[e]));return t}}getTrainingConfig(){return{loss:this.getLossIdentifiers(),metrics:this.getMetricIdentifiers(),optimizer_config:{class_name:this.optimizer.getClassName(),config:this.optimizer.getConfig()}}}loadTrainingConfig(t){if(null!=t.weighted_metrics)throw new Error("Loading weight_metrics is not supported yet.");if(null!=t.loss_weights)throw new Error("Loading loss_weights is not supported yet.");if(null!=t.sample_weight_mode)throw new Error("Loading sample_weight_mode is not supported yet.");const e=we(Ze(t.optimizer_config));let s,i;if("string"==typeof t.loss)s=f(t.loss);else if(Array.isArray(t.loss))s=t.loss.map(t=>f(t));else if(null!=t.loss){s={};for(const e in t.loss)s[e]=f(t.loss[e])}if(Array.isArray(t.metrics))i=t.metrics.map(t=>f(t));else if(null!=t.metrics){i={};for(const e in t.metrics)i[e]=f(t.metrics[e])}this.compile({loss:s,metrics:i,optimizer:e})}async save(t,s){if("string"==typeof t){const s=e.io.getSaveHandlers(t);if(0===s.length)throw new a(`Cannot find any save handlers for URL '${t}'`);if(s.length>1)throw new a(`Found more than one (${s.length}) save handlers for URL '${t}'`);t=s[0]}if(null==t.save)throw new a("LayersModel.save() cannot proceed because the IOHandler provided does not have the `save` attribute defined.");const i=await e.io.encodeWeights(this.getNamedWeights(s)),n={modelTopology:this.toJSON(null,!1),format:"layers-model",generatedBy:"TensorFlow.js tfjs-layers v2.8.6",convertedBy:null};if(null!=s&&s.includeOptimizer&&null!=this.optimizer){n.trainingConfig=this.getTrainingConfig();const t="optimizer",{data:s,specs:r}=await e.io.encodeWeights(await this.optimizer.getWeights(),t);i.specs.push(...r),i.data=e.io.concatenateArrayBuffers([i.data,s])}if(null!=this.userDefinedMetadata){const t=!0;Pe(this.userDefinedMetadata,this.name,t),n.userDefinedMetadata=this.userDefinedMetadata}return n.weightData=i.data,n.weightSpecs=i.specs,t.save(n)}setUserDefinedMetadata(t){Pe(t,this.name),this.userDefinedMetadata=t}getUserDefinedMetadata(){return this.userDefinedMetadata}}ks.className="Model",e.serialization.registerClass(ks);class Ss extends ks{}async function vs(t,s){if(null==s&&(s={}),"string"==typeof t){const i=e.io.getLoadHandlers(t,s);if(0===i.length)i.push(e.io.browserHTTPRequest(t,s));else if(i.length>1)throw new a(`Found more than one (${i.length}) load handlers for URL '${t}'`);t=i[0]}return async function(t,s,i){null==i&&(i={});if(null==t.load)throw new a("Cannot proceed with model loading because the IOHandler provided does not have the `load` method implemented.");const n=await t.load();let r=n.modelTopology;null!=r.model_config&&(r=r.model_config);const o=null==i.strict||i.strict,l=null!=n.weightData&&null!=n.weightSpecs&&o,u=we(Ze(r),s,l),h=n.trainingConfig;null!=h&&u.loadTrainingConfig(h);null!=n.userDefinedMetadata&&u.setUserDefinedMetadata(n.userDefinedMetadata);if(null!=n.weightData){if(null==n.weightSpecs)throw new a("LayersModel artifacts contains weight data, but not weight specs. Therefore loading of weights cannot proceed.");const{modelWeights:t,optimizerWeights:s}=function(t,s){const i=e.io.decodeWeights(t,s),n={},r=[];return s.forEach(t=>{"optimizer"===t.group?r.push({name:t.name,tensor:i[t.name]}):n[t.name]=i[t.name]}),{modelWeights:n,optimizerWeights:r}}(n.weightData,n.weightSpecs);u.loadWeights(t,o),null!=u.optimizer&&s.length>0&&await u.optimizer.setWeights(s),e.dispose(t),e.dispose(s.map(t=>t.tensor))}return u}(t,void 0,s)}Ss.className="Functional",e.serialization.registerClass(Ss);class Ns extends ks{constructor(t){if(super({inputs:[],outputs:[]}),t=t||{},this.trainable=!0,this.built=!1,this.name=null!=t.name?t.name:qt("sequential_"),null!=t.layers)for(const e of t.layers)this.add(e)}checkShape(t){if(t.inboundNodes[0].outputTensors[0].shape.some(t=>t<0))throw new a("Negative dimension size caused by adding layer "+t.name+" with input shape ["+t.inboundNodes[0].inputTensors[0].shape+"]")}add(t){const e=t instanceof Ns||t instanceof ks;let s;if(e){if(s=t,1!==s.outputs.length)throw new a("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");if(1!==s.inputs.length)throw new a("All layers in a Sequential model should have a single input tensor. For multi-input layers, use the functional API.")}if(0===this.outputs.length){if(0===t.inboundNodes.length){if(null==t.batchInputShape)throw new a("The first layer in a Sequential model must get an `inputShape` or `batchInputShape` argument.");const e=oe({batchShape:t.batchInputShape,dtype:t.dtype,name:t.name+"_input"});t.apply(e)}if(e)this.outputs=s.outputs,this.inputs=s.inputs;else{if(1!==t.inboundNodes.length)throw new a(`A layer added to a Sequential model must not already be connected somewhere else. LayersModel received layer ${t.name} which has ${t.inboundNodes.length} pre-existing inbound connections.`);if(1!==t.inboundNodes[0].outputTensors.length)throw new a("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[t.inboundNodes[0].outputTensors[0]],this.inputs=function t(e,s,i){if((null==s||null!=i&&i>0)&&(s=e.sourceLayer,i=e.nodeIndex),0===s.inboundNodes.length)return[e];{const e=s.inboundNodes[i];if(0===e.inboundLayers.length)return e.inputTensors;{const s=[];for(let i=0;i<e.inboundLayers.length;i++){const n=t(e.inputTensors[i],e.inboundLayers[i],e.nodeIndices[i]);for(const t of n)-1===s.indexOf(t)&&s.push(t)}return s}}}(this.outputs[0])}this.inboundNodes=[],new ie({outboundLayer:this,inboundLayers:[],nodeIndices:[],tensorIndices:[],inputTensors:this.inputs,outputTensors:this.outputs,inputMasks:u(null,this.inputs.length),outputMasks:[null],inputShapes:this.inputs.map(t=>t.shape),outputShapes:this.outputs[0].shape})}else{const e=t.apply(this.outputs[0]);if(Array.isArray(e))throw new TypeError("All layers in a Sequential model should have a single output tensor. For multi-output layers, use the functional API.");this.checkShape(t),this.outputs=[e],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}this.layers.push(t),this.built=!1}pop(){if(0===this.layers.length)throw new TypeError("There are no layers in the model.");if(this.layers.pop(),0===this.layers.length)this.outputs=[],this.inboundNodes=[],this.outboundNodes=[];else{const t=this.layers.length-1;this.layers[t].outboundNodes=[],this.outputs=[this.layers[t].output],this.inboundNodes[0].outputTensors=this.outputs,this.inboundNodes[0].outputShapes=[this.outputs[0].shape]}}call(t,e){return null==this.model&&this.build(),this.model.call(t,e)}build(t){if(Kt(t),0===this.inputs.length||0===this.outputs.length)throw new TypeError("Sequential model cannot be built: model is empty. Add some layers first.");this.model=new ks({inputs:this.inputs,outputs:this.outputs[0],name:this.name+"_model"}),this.model.trainable=this.trainable,this.supportsMasking=this.model.supportsMasking,this.inputLayers=this.model.inputLayers,this.inputLayersNodeIndices=this.model.inputLayersNodeIndices,this.inputLayersTensorIndices=this.model.inputLayersTensorIndices,this.outputLayers=this.model.outputLayers,this.outputLayersNodeIndices=this.model.outputLayersNodeIndices,this.outputLayersTensorIndices=this.model.outputLayersTensorIndices,this.nodesByDepth=this.model.nodesByDepth,this.containerNodes=this.model.containerNodes,this.outputNames=this.model.outputNames,this.inputNames=this.model.inputNames,this.built=!0}countParams(){return this.built||this.build(),super.countParams()}summary(t,e,s=console.log){this.built||this.build(),super.summary(t,e,s)}setWeights(t){null==this.model&&this.build(),this.model.setWeights(t)}evaluate(t,e,s={}){if(!this.built)throw new r("The model needs to be compiled before being used.");return this.model.evaluate(t,e,s)}async evaluateDataset(t,e){if(!this.built)throw new r("The model needs to be compiled before being used.");return this.model.evaluateDataset(t,e)}predict(t,e={}){return null==this.model&&this.build(),this.model.predict(t,e)}predictOnBatch(t){return null==this.model&&this.build(),this.model.predictOnBatch(t)}compile(t){this.build(),this.model.compile(t),this.optimizer_=this.model.optimizer,this.isOptimizerOwned=this.model.isOptimizerOwned,this.loss=this.model.loss,this.metrics=this.model.metrics,this.metricsTensors=this.model.metricsTensors,this.metricsNames=this.model.metricsNames}get optimizer(){return null==this.model?void 0:this.model.optimizer}set optimizer(t){this.model.optimizer=t}async fit(t,e,s={}){if(!this.built)throw new r("The model needs to be compiled before being used.");return this.model.fit(t,e,s)}async fitDataset(t,e){if(!this.built)throw new r("The model needs to be compiled before being used.");return this.model.fitDataset(t,e)}async trainOnBatch(t,e){return this.model.trainOnBatch(t,e)}static fromConfig(t,s,i={},n=!1){let r,l={};if(s instanceof Array){if(null==s[0].className||"Merge"===s[0].className)throw new a("Legacy serialization format not supported yet.");r=s}else e.util.assert(null!=s.layers,()=>"When the config data for a Sequential model is not an Array, it must be an Object that contains the 'layers' field."),r=s.layers,delete s.layers,l=s;const u=new t(l);if(!(u instanceof Ns))throw new o("Sequential.fromConfig called on non-Sequential input: "+u);for(const t of r){const e=we(t,void 0,n);n&&e.setFastWeightInitDuringBuild(!0),u.add(e)}return u}set stopTraining(t){if(null==this.model)throw new a("Cannot set the stopTraining property of a sequential model before it is compiled.");this.model.stopTraining=t}get stopTraining(){if(null==this.model)throw new a("Cannot get the stopTraining property of a sequential model before it is compiled.");return this.model.stopTraining}getConfig(){const t=[];for(const e of this.layers){const s={};s.className=e.getClassName(),s.config=e.getConfig(),t.push(s)}return{name:this.name,layers:t}}}function As(t){return oe(t)}Ns.className="Sequential",e.serialization.registerClass(Ns);class Cs extends e.serialization.Serializable{getConfig(){return{}}}class xs extends Cs{apply(t,s=1){return function(t,s=1){if(1!==s)throw new o(`Support for alpha values other than 1 (${s}) is not implemented yet.`);return e.elu(t)}(t,s)}}xs.className="elu",e.serialization.registerClass(xs);class Is extends Cs{apply(t){return e.selu(t)}}Is.className="selu",e.serialization.registerClass(Is);class Ls extends Cs{apply(t){return e.relu(t)}}Ls.className="relu",e.serialization.registerClass(Ls);class Ts extends Cs{apply(t){return e.tidy(()=>e.minimum(6,e.relu(t)))}}Ts.className="relu6",e.serialization.registerClass(Ts);class Es extends Cs{apply(t){return t}}Es.className="linear",e.serialization.registerClass(Es);class Ds extends Cs{apply(t){return e.sigmoid(t)}}Ds.className="sigmoid",e.serialization.registerClass(Ds);class Os extends Cs{apply(t){return function(t){return e.tidy(()=>{const s=e.add(.5,e.mul(.2,t));return e.clipByValue(s,0,1)})}(t)}}Os.className="hardSigmoid",e.serialization.registerClass(Os);class Rs extends Cs{apply(t){return e.softplus(t)}}Rs.className="softplus",e.serialization.registerClass(Rs);class Fs extends Cs{apply(t){return function(t){return e.tidy(()=>e.div(t,e.abs(t).add(1)))}(t)}}Fs.className="softsign",e.serialization.registerClass(Fs);class _s extends Cs{apply(t){return e.tanh(t)}}_s.className="tanh",e.serialization.registerClass(_s);class Ms extends Cs{apply(t,s=-1){return e.softmax(t,s)}}Ms.className="softmax",e.serialization.registerClass(Ms);class $s extends Cs{apply(t,s=-1){return e.logSoftmax(t,s)}}$s.className="logSoftmax",e.serialization.registerClass($s);class Bs extends Cs{apply(t,s=1){return e.tidy(()=>e.sigmoid(t.mul(s)).mul(t))}}function Ws(t){return t.getClassName()}function Us(t,s={}){return b(t,e.serialization.SerializationMap.getMap().classNameMap,s,"activation")}function Ps(t){if(null==t){const t={className:"linear",config:{}};return Us(t)}if("string"==typeof t){const e={};return e.className=t,e.config={},Us(e)}return t instanceof Cs?t:Us(t)}function js(t){if(null!=t&&"object"!=typeof t)throw new Error("Argument to L1L2 regularizer's constructor is expected to be an object, but received: "+t)}Bs.className="swish",e.serialization.registerClass(Bs);class Vs extends e.serialization.Serializable{}class qs extends Vs{constructor(t){super(),js(t),this.l1=null==t||null==t.l1?.01:t.l1,this.l2=null==t||null==t.l2?.01:t.l2,this.hasL1=0!==this.l1,this.hasL2=0!==this.l2}apply(t){return e.tidy(()=>{let s=e.zeros([1]);return this.hasL1&&(s=e.add(s,e.sum(e.mul(this.l1,e.abs(t))))),this.hasL2&&(s=e.add(s,e.sum(e.mul(this.l2,gt(t))))),s.asScalar()})}getConfig(){return{l1:this.l1,l2:this.l2}}static fromConfig(t,e){return new t({l1:e.l1,l2:e.l2})}}qs.className="L1L2",e.serialization.registerClass(qs);const Js={l1l2:"L1L2"};function Hs(t){return y(t)}function Zs(t,s={}){return b(t,e.serialization.SerializationMap.getMap().classNameMap,s,"regularizer")}function Ks(t){if(null==t)return null;if("string"==typeof t){return Zs({className:t in Js?Js[t]:t,config:{}})}return t instanceof Vs?t:Zs(t)}class Gs extends re{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,null!=t&&(this.maxValue=t.maxValue)}call(t,s){t=Zt(t);let i=e.relu(t);return null!=this.maxValue&&(i=e.clipByValue(i,0,this.maxValue)),i}computeOutputShape(t){return t}getConfig(){const t={maxValue:this.maxValue},e=super.getConfig();return Object.assign(t,e),t}}Gs.className="ReLU",e.serialization.registerClass(Gs);class Ys extends re{constructor(t){super(null==t?{}:t),this.DEFAULT_ALPHA=.3,null==t&&(t={}),this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,s){const i=Zt(t);return e.leakyRelu(i,this.alpha)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Ys.className="LeakyReLU",e.serialization.registerClass(Ys);class Xs extends re{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA_INITIALIZER="zeros",null==t&&(t={}),this.supportsMasking=!0,this.alphaInitializer=Wt(t.alphaInitializer||this.DEFAULT_ALPHA_INITIALIZER),this.alphaRegularizer=Ks(t.alphaRegularizer),this.alphaConstraint=F(t.alphaConstraint),null==t.sharedAxes)this.sharedAxes=null;else if(Array.isArray(t.sharedAxes))this.sharedAxes=t.sharedAxes;else{if("number"!=typeof t.sharedAxes)throw new a("Expected sharedAxes to be a number or an array of numbers, but got "+t.sharedAxes);this.sharedAxes=[t.sharedAxes]}}build(t){const e=(t=Kt(t)).slice(1);if(null!=this.sharedAxes)for(const t of this.sharedAxes)e[t-1]=1;this.alpha=this.addWeight("alpha",e,"float32",this.alphaInitializer,this.alphaRegularizer,!0,this.alphaConstraint);const s={};if(null!=this.sharedAxes)for(let e=1;e<t.length;++e)s[e]=t[e];this.inputSpec=[new te({ndim:t.length,axes:s})],this.built=!0}call(t,s){return t=Zt(t),e.prelu(t,this.alpha.read())}getConfig(){const t={alphaInitializer:Bt(this.alphaInitializer),alphaRegularizer:Hs(this.alphaRegularizer),alphaConstraint:O(this.alphaConstraint),sharedAxes:this.sharedAxes},e=super.getConfig();return Object.assign(t,e),t}}Xs.className="PReLU",e.serialization.registerClass(Xs);class Qs extends re{constructor(t){if(super(null==t?{}:t),this.DEFAULT_ALPHA=1,null==t&&(t={}),null!=t.alpha&&t.alpha!==this.DEFAULT_ALPHA)throw new o(`Non-default alpha value (${t.alpha}) is not supported by the ELU layer yet.`);this.alpha=null==t.alpha?this.DEFAULT_ALPHA:t.alpha}call(t,s){const i=Zt(t);return e.elu(i)}computeOutputShape(t){return t}getConfig(){const t={alpha:this.alpha},e=super.getConfig();return Object.assign(t,e),t}}Qs.className="ELU",e.serialization.registerClass(Qs);class ti extends re{constructor(t){super(null==t?{}:t),this.DEFAULT_THETA=1,null==t&&(t={}),this.theta=null==t.theta?this.DEFAULT_THETA:t.theta}call(t,e){const s=Zt(t);return s.mul(it(s.greater(this.theta),"float32"))}computeOutputShape(t){return t}getConfig(){const t={theta:this.theta},e=super.getConfig();return Object.assign(t,e),t}}ti.className="ThresholdedReLU",e.serialization.registerClass(ti);class ei extends re{constructor(t){super(null==t?{}:t),this.DEFAULT_AXIS=1,null==t&&(t={}),this.softmax=(new Ms).apply,this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis}call(t,e){const s=Zt(t);return this.softmax(s,this.axis)}computeOutputShape(t){return t}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function si(t,e,s){if("number"==typeof t)return u(t,e);if(t.length!==e)throw new a(`The ${s} argument must be an integer or tuple of ${e} integers. Received: ${t.length} elements.`);for(let n=0;n<e;++n){const r=t[n];if((i=r)!==parseInt(i.toString(),10))throw new a(`The ${s} argument must be an integer or tuple of ${e} integers. Received: ${JSON.stringify(t)} including a non-integer number `+r)}return t;var i}function ii(t,e,s,i,n=1){if(null==t)return t;let r;return r="same"===s?t:t-(e+(e-1)*(n-1))+1,Math.floor((r+i-1)/i)}function ni(t,e,s,i){if(null==t)return null;if("valid"===i)t=t*e+et([s-e,0]);else{if("same"!==i)throw new a(`Unsupport padding mode: ${i}.`);t*=e}return t}function ri(t,s){return e.tidy(()=>(j(s),"channelsFirst"===s?e.transpose(t,[0,2,3,1]):t))}function ai(t,s){return e.tidy(()=>(j(s),"channelsFirst"===s?e.transpose(t,[0,2,3,4,1]):t))}function oi(t,s,i,n=[1,1],r="valid",l,u,h=null){return e.tidy(()=>{if(null==l&&(l="channelsLast"),j(l),3!==t.rank&&4!==t.rank)throw new a(`conv2dWithBiasActivation expects input to be of rank 3 or 4, but received ${t.rank}.`);if(3!==s.rank&&4!==s.rank)throw new a(`conv2dWithBiasActivation expects kernel to be of rank 3 or 4, but received ${t.rank}.`);let c=ri(t,l);if("causal"===r)throw new o("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");return c=e.fused.conv2d({x:c,filter:s,strides:n,pad:"same"===r?"same":"valid",dilations:u,dataFormat:"NHWC",bias:i,activation:h}),"channelsFirst"===l&&(c=e.transpose(c,[0,3,1,2])),c})}ei.className="Softmax",e.serialization.registerClass(ei);class li extends re{constructor(t,e){if(super(e),this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",li.verifyArgs(e),this.rank=t,N(this.rank,"rank"),1!==this.rank&&2!==this.rank&&3!==this.rank)throw new o(`Convolution layer for rank other than 1, 2, or 3 (${this.rank}) is not implemented yet.`);if(this.kernelSize=si(e.kernelSize,t,"kernelSize"),this.strides=si(null==e.strides?1:e.strides,t,"strides"),this.padding=null==e.padding?"valid":e.padding,V(this.padding),this.dataFormat=null==e.dataFormat?"channelsLast":e.dataFormat,j(this.dataFormat),this.activation=Ps(e.activation),this.useBias=null==e.useBias||e.useBias,this.biasInitializer=Wt(e.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.biasConstraint=F(e.biasConstraint),this.biasRegularizer=Ks(e.biasRegularizer),this.activityRegularizer=Ks(e.activityRegularizer),this.dilationRate=si(null==e.dilationRate?1:e.dilationRate,t,"dilationRate"),1===this.rank&&Array.isArray(this.dilationRate)&&1!==this.dilationRate.length)throw new a("dilationRate must be a number or an array of a single number for 1D convolution, but received "+JSON.stringify(this.dilationRate));if(2===this.rank){if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate];else if(2!==this.dilationRate.length)throw new a("dilationRate must be a number or array of two numbers for 2D convolution, but received "+JSON.stringify(this.dilationRate))}else if(3===this.rank)if("number"==typeof this.dilationRate)this.dilationRate=[this.dilationRate,this.dilationRate,this.dilationRate];else if(3!==this.dilationRate.length)throw new a("dilationRate must be a number or array of three numbers for 3D convolution, but received "+JSON.stringify(this.dilationRate))}static verifyArgs(t){if(h("kernelSize"in t,"required key 'kernelSize' not in config"),"number"!=typeof t.kernelSize&&!v(t.kernelSize,"number",1,3))throw new a(`BaseConv expects config.kernelSize to be number or number[] with length 1, 2, or 3, but received ${JSON.stringify(t.kernelSize)}.`)}getConfig(){const t={kernelSize:this.kernelSize,strides:this.strides,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,activation:Ws(this.activation),useBias:this.useBias,biasInitializer:Bt(this.biasInitializer),biasRegularizer:Hs(this.biasRegularizer),activityRegularizer:Hs(this.activityRegularizer),biasConstraint:O(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}class ui extends li{constructor(t,e){super(t,e),this.kernel=null,ui.verifyArgs(e),this.filters=e.filters,N(this.filters,"filters"),this.kernelInitializer=Wt(e.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.kernelConstraint=F(e.kernelConstraint),this.kernelRegularizer=Ks(e.kernelRegularizer)}build(t){t=Kt(t);const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new a("The channel dimension of the input should be defined. Found "+t[e]);const s=t[e],i=this.kernelSize.concat([s,this.filters]);this.kernel=this.addWeight("kernel",i,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[{ndim:this.rank+2,axes:{[e]:s}}],this.built=!0}call(t,s){return e.tidy(()=>{let s;t=Zt(t);const i=null==this.bias?null:this.bias.read(),n=A(this.activation.getClassName());if(null!=n&&2===this.rank)s=oi(t,this.kernel.read(),i,this.strides,this.padding,this.dataFormat,this.dilationRate,n);else{if(1===this.rank)s=function(t,s,i,n=1,r="valid",l,u=1){return e.tidy(()=>{if(null==l&&(l="channelsLast"),j(l),3!==t.shape.length)throw new a("The input of a conv1dWithBias operation should be 3, but is "+t.shape.length+" instead.");if(3!==s.shape.length)throw new a("The kernel for a conv1dWithBias operation should be 3, but is "+s.shape.length+" instead");if(null!=i&&1!==i.shape.length)throw new a("The bias for a conv1dWithBias operation should be 1, but is "+s.shape.length+" instead");if("channelsFirst"===l&&(t=e.transpose(t,[0,2,1])),"causal"===r)throw new o("The support for CAUSAL padding mode in conv1dWithBias is not implemented yet.");let h=e.conv1d(t,s,n,"same"===r?"same":"valid","NWC",u);return null!=i&&(h=mt(h,i)),h})}(t,this.kernel.read(),i,this.strides[0],this.padding,this.dataFormat,this.dilationRate[0]);else if(2===this.rank)s=oi(t,this.kernel.read(),i,this.strides,this.padding,this.dataFormat,this.dilationRate);else{if(3!==this.rank)throw new o("convolutions greater than 3D are not implemented yet.");s=function(t,s,i,n=[1,1,1],r="valid",l,u){return e.tidy(()=>{if(null==l&&(l="channelsLast"),j(l),4!==t.rank&&5!==t.rank)throw new a("conv3dWithBias expects input to be of rank 4 or 5, but received "+t.rank+".");if(4!==s.rank&&5!==s.rank)throw new a("conv3dWithBias expects kernel to be of rank 4 or 5, but received "+t.rank+".");let h=ai(t,l);if("causal"===r)throw new o("The support for CAUSAL padding mode in conv3dWithBias is not implemented yet.");return h=e.conv3d(h,s,n,"same"===r?"same":"valid","NDHWC",u),null!=i&&(h=mt(h,i)),"channelsFirst"===l&&(h=e.transpose(h,[0,4,1,2,3])),h})}(t,this.kernel.read(),i,this.strides,this.padding,this.dataFormat,this.dilationRate)}null!=this.activation&&(s=this.activation.apply(s))}return s})}computeOutputShape(t){t=Kt(t);const e=[],s="channelsLast"===this.dataFormat?t.slice(1,t.length-1):t.slice(2);for(let t=0;t<s.length;++t){const i=ii(s[t],this.kernelSize[t],this.padding,this.strides[t],"number"==typeof this.dilationRate?this.dilationRate:this.dilationRate[t]);e.push(i)}let i=[t[0]];return"channelsLast"===this.dataFormat?(i=i.concat(e),i.push(this.filters)):(i.push(this.filters),i=i.concat(e)),i}getConfig(){const t={filters:this.filters,kernelInitializer:Bt(this.kernelInitializer),kernelRegularizer:Hs(this.kernelRegularizer),kernelConstraint:O(this.kernelConstraint)},e=super.getConfig();return Object.assign(t,e),t}static verifyArgs(t){if(!("filters"in t)||"number"!=typeof t.filters||t.filters<1)throw new a("Convolution layer expected config.filters to be a 'number' > 0 but got "+JSON.stringify(t.filters))}}class hi extends ui{constructor(t){super(2,t),hi.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!v(t.kernelSize,"number",1,2))throw new a(`Conv2D expects config.kernelSize to be number or number[] with length 1 or 2, but received ${JSON.stringify(t.kernelSize)}.`)}}hi.className="Conv2D",e.serialization.registerClass(hi);class ci extends ui{constructor(t){super(3,t),ci.verifyArgs(t)}getConfig(){const t=super.getConfig();return delete t.rank,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&(!Array.isArray(t.kernelSize)||1!==t.kernelSize.length&&3!==t.kernelSize.length))throw new a(`Conv3D expects config.kernelSize to be number or [number, number, number], but received ${JSON.stringify(t.kernelSize)}.`)}}ci.className="Conv3D",e.serialization.registerClass(ci);class pi extends hi{constructor(t){if(super(t),this.inputSpec=[new te({ndim:4})],"same"!==this.padding&&"valid"!==this.padding)throw new a("Conv2DTranspose currently supports only padding modes 'same' and 'valid', but received padding mode "+this.padding)}build(t){if(4!==(t=Kt(t)).length)throw new a("Input should have rank 4; Received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e])throw new a("The channel dimension of the inputs should be defined. Found `None`.");const s=t[e],i=this.kernelSize.concat([this.filters,s]);this.kernel=this.addWeight("kernel",i,"float32",this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint)),this.inputSpec=[new te({ndim:4,axes:{[e]:s}})],this.built=!0}call(t,s){return e.tidy(()=>{let s=Zt(t);if(4!==s.shape.length)throw new a("Conv2DTranspose.call() expects input tensor to be rank-4, but received a tensor of rank-"+s.shape.length);const i=s.shape,n=i[0];let r,o;"channelsFirst"===this.dataFormat?(r=2,o=3):(r=1,o=2);const l=i[r],u=i[o],h=this.kernelSize[0],c=this.kernelSize[1],p=this.strides[0],d=this.strides[1],g=[n,ni(l,p,h,this.padding),ni(u,d,c,this.padding),this.filters];"channelsLast"!==this.dataFormat&&(s=e.transpose(s,[0,2,3,1]));let f=e.conv2dTranspose(s,this.kernel.read(),g,this.strides,this.padding);return"channelsLast"!==this.dataFormat&&(f=e.transpose(f,[0,3,1,2])),null!=this.bias&&(f=mt(f,this.bias.read(),this.dataFormat)),null!=this.activation&&(f=this.activation.apply(f)),f})}computeOutputShape(t){const e=(t=Kt(t)).slice();let s,i,n;"channelsFirst"===this.dataFormat?(s=1,i=2,n=3):(s=3,i=1,n=2);const r=this.kernelSize[0],a=this.kernelSize[1],o=this.strides[0],l=this.strides[1];return e[s]=this.filters,e[i]=ni(e[i],o,r,this.padding),e[n]=ni(e[n],l,a,this.padding),e}getConfig(){const t=super.getConfig();return delete t.dilationRate,t}}pi.className="Conv2DTranspose",e.serialization.registerClass(pi);class di extends ui{constructor(t,e){if(super(t,e),this.DEFAULT_DEPTHWISE_INITIALIZER="glorotUniform",this.DEFAULT_POINTWISE_INITIALIZER="glorotUniform",this.depthwiseKernel=null,this.pointwiseKernel=null,null==e.filters)throw new a("The `filters` configuration field is required by SeparableConv, but is unspecified.");if(null!=e.kernelInitializer||null!=e.kernelRegularizer||null!=e.kernelConstraint)throw new a("Fields kernelInitializer, kernelRegularizer and kernelConstraint are invalid for SeparableConv2D. Use depthwiseInitializer, depthwiseRegularizer, depthwiseConstraint, pointwiseInitializer, pointwiseRegularizer and pointwiseConstraint instead.");if(null!=e.padding&&"same"!==e.padding&&"valid"!==e.padding)throw new a(`SeparableConv${this.rank}D supports only padding modes: 'same' and 'valid', but received `+JSON.stringify(e.padding));this.depthMultiplier=null==e.depthMultiplier?1:e.depthMultiplier,this.depthwiseInitializer=Wt(e.depthwiseInitializer||this.DEFAULT_DEPTHWISE_INITIALIZER),this.depthwiseRegularizer=Ks(e.depthwiseRegularizer),this.depthwiseConstraint=F(e.depthwiseConstraint),this.pointwiseInitializer=Wt(e.depthwiseInitializer||this.DEFAULT_POINTWISE_INITIALIZER),this.pointwiseRegularizer=Ks(e.pointwiseRegularizer),this.pointwiseConstraint=F(e.pointwiseConstraint)}build(t){if((t=Kt(t)).length<this.rank+2)throw new a(`Inputs to SeparableConv${this.rank}D should have rank `+(this.rank+2)+", but received input shape: "+JSON.stringify(t));const e="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[e]||t[e]<0)throw new a("The channel dimension of the inputs should be defined, but found "+JSON.stringify(t[e]));const s=t[e],i=this.kernelSize.concat([s,this.depthMultiplier]),n=[];for(let t=0;t<this.rank;++t)n.push(1);n.push(s*this.depthMultiplier,this.filters);this.depthwiseKernel=this.addWeight("depthwise_kernel",i,"float32",this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.pointwiseKernel=this.addWeight("pointwise_kernel",n,"float32",this.pointwiseInitializer,this.pointwiseRegularizer,!0,this.pointwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[this.filters],"float32",this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.inputSpec=[new te({ndim:this.rank+2,axes:{[e]:s}})],this.built=!0}call(t,s){return e.tidy(()=>{let s;if(t=Zt(t),1===this.rank)throw new o("1D separable convolution is not implemented yet.");return 2===this.rank&&("channelsFirst"===this.dataFormat&&(t=e.transpose(t,[0,2,3,1])),s=e.separableConv2d(t,this.depthwiseKernel.read(),this.pointwiseKernel.read(),this.strides,this.padding,this.dilationRate,"NHWC")),this.useBias&&(s=mt(s,this.bias.read(),this.dataFormat)),null!=this.activation&&(s=this.activation.apply(s)),"channelsFirst"===this.dataFormat&&(s=e.transpose(s,[0,3,1,2])),s})}getConfig(){const t=super.getConfig();return delete t.rank,delete t.kernelInitializer,delete t.kernelRegularizer,delete t.kernelConstraint,t.depthwiseInitializer=Bt(this.depthwiseInitializer),t.pointwiseInitializer=Bt(this.pointwiseInitializer),t.depthwiseRegularizer=Hs(this.depthwiseRegularizer),t.pointwiseRegularizer=Hs(this.pointwiseRegularizer),t.depthwiseConstraint=O(this.depthwiseConstraint),t.pointwiseConstraint=O(this.pointwiseConstraint),t}}di.className="SeparableConv";class gi extends di{constructor(t){super(2,t)}}gi.className="SeparableConv2D",e.serialization.registerClass(gi);class fi extends ui{constructor(t){super(1,t),fi.verifyArgs(t),this.inputSpec=[{ndim:3}]}getConfig(){const t=super.getConfig();return delete t.rank,delete t.dataFormat,t}static verifyArgs(t){if("number"!=typeof t.kernelSize&&!v(t.kernelSize,"number",1,1))throw new a(`Conv1D expects config.kernelSize to be number or number[] with length 1, but received ${JSON.stringify(t.kernelSize)}.`)}}fi.className="Conv1D",e.serialization.registerClass(fi);class mi extends re{constructor(t){super(t),"number"==typeof t.cropping?this.cropping=[[t.cropping,t.cropping],[t.cropping,t.cropping]]:"number"==typeof t.cropping[0]?this.cropping=[[t.cropping[0],t.cropping[0]],[t.cropping[1],t.cropping[1]]]:this.cropping=t.cropping,this.dataFormat=void 0===t.dataFormat?"channelsLast":t.dataFormat,this.inputSpec=[{ndim:4}]}computeOutputShape(t){return"channelsFirst"===this.dataFormat?[t[0],t[1],t[2]-this.cropping[0][0]-this.cropping[0][1],t[3]-this.cropping[1][0]-this.cropping[1][1]]:[t[0],t[1]-this.cropping[0][0]-this.cropping[0][1],t[2]-this.cropping[1][0]-this.cropping[1][1],t[3]]}call(t,s){return e.tidy(()=>{if(t=Zt(t),"channelsLast"===this.dataFormat){const e=ot(t,this.cropping[0][0],t.shape[1]-this.cropping[0][0]-this.cropping[0][1],2);return ot(e,this.cropping[1][0],t.shape[2]-this.cropping[1][1]-this.cropping[1][0],3)}{const e=ot(t,this.cropping[0][0],t.shape[2]-this.cropping[0][0]-this.cropping[0][1],3);return ot(e,this.cropping[1][0],t.shape[3]-this.cropping[1][1]-this.cropping[1][0],4)}})}getConfig(){const t={cropping:this.cropping,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}mi.className="Cropping2D",e.serialization.registerClass(mi);class yi extends re{constructor(t){var e;super(t),this.DEFAULT_SIZE=[2,2],this.inputSpec=[{ndim:4}],this.size=null==t.size?this.DEFAULT_SIZE:t.size,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,j(this.dataFormat),this.interpolation=null==t.interpolation?"nearest":t.interpolation,e=this.interpolation,S($,"InterpolationFormat",e)}computeOutputShape(t){if("channelsFirst"===this.dataFormat){const e=null==t[2]?null:this.size[0]*t[2],s=null==t[3]?null:this.size[1]*t[3];return[t[0],t[1],e,s]}{const e=null==t[1]?null:this.size[0]*t[1],s=null==t[2]?null:this.size[1]*t[2];return[t[0],e,s,t[3]]}}call(t,s){return e.tidy(()=>{let s=Zt(t);const i=s.shape;if("channelsFirst"===this.dataFormat){s=e.transpose(s,[0,2,3,1]);const t=this.size[0]*i[2],n=this.size[1]*i[3],r="nearest"===this.interpolation?s.resizeNearestNeighbor([t,n]):s.resizeBilinear([t,n]);return e.transpose(r,[0,3,1,2])}{const t=this.size[0]*i[1],e=this.size[1]*i[2];return"nearest"===this.interpolation?s.resizeNearestNeighbor([t,e]):s.resizeBilinear([t,e])}})}getConfig(){const t={size:this.size,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}yi.className="UpSampling2D",e.serialization.registerClass(yi);class bi extends li{constructor(t){super(2,t),this.depthwiseKernel=null,this.depthMultiplier=null==t.depthMultiplier?1:t.depthMultiplier,this.depthwiseInitializer=Wt(t.depthwiseInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.depthwiseConstraint=F(t.depthwiseConstraint),this.depthwiseRegularizer=Ks(t.depthwiseRegularizer)}build(t){if((t=Kt(t)).length<4)throw new a(`Inputs to DepthwiseConv2D should have rank 4. Received input shape: ${JSON.stringify(t)}.`);const e="channelsFirst"===this.dataFormat?1:3;if(null==t[e]||t[e]<0)throw new a(`The channel dimension of the inputs to DepthwiseConv2D should be defined, but is not (${t[e]}).`);const s=t[e],i=[this.kernelSize[0],this.kernelSize[1],s,this.depthMultiplier];this.depthwiseKernel=this.addWeight("depthwise_kernel",i,null,this.depthwiseInitializer,this.depthwiseRegularizer,!0,this.depthwiseConstraint),this.useBias?this.bias=this.addWeight("bias",[s*this.depthMultiplier],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,s){return e.tidy(()=>{let s=function(t,s,i=[1,1],n="valid",r,o){return e.tidy(()=>{null==r&&(r="channelsLast"),j(r);let l=ri(t,r);if(4!==t.rank)throw new a("Input for depthwiseConv2d is required to be 4-D, but is instead "+t.rank+"-D");if(4!==s.rank)throw new a("depthwiseKernel is required to be 4-D, but is instead "+s.rank+"-D");return l=e.depthwiseConv2d(l,s,i,"same"===n?"same":"valid","NHWC",o),"channelsFirst"===r&&(l=e.transpose(l,[0,3,1,2])),l})}(t=Zt(t),this.depthwiseKernel.read(),this.strides,this.padding,this.dataFormat,null);return this.useBias&&(s=mt(s,this.bias.read(),this.dataFormat)),null!=this.activation&&(s=this.activation.apply(s)),s})}computeOutputShape(t){t=Kt(t);const e="channelsFirst"===this.dataFormat?t[2]:t[1],s="channelsFirst"===this.dataFormat?t[3]:t[2],i="channelsFirst"===this.dataFormat?t[1]*this.depthMultiplier:t[3]*this.depthMultiplier,n=ii(e,this.kernelSize[0],this.padding,this.strides[0]),r=ii(s,this.kernelSize[1],this.padding,this.strides[1]);return"channelsFirst"===this.dataFormat?[t[0],i,n,r]:[t[0],n,r,i]}getConfig(){const t=super.getConfig();return t.depthMultiplier=this.depthMultiplier,t.depthwiseInitializer=Bt(this.depthwiseInitializer),t.depthwiseRegularizer=Hs(this.depthwiseRegularizer),t.depthwiseConstraint=O(this.depthwiseRegularizer),t}}function wi(t,e,s,i){if(Array.isArray(t)){if(null!=e||null!=s)throw new a("When inputs is an array, neither initialState or constants should be provided");null!=i&&(s=t.slice(t.length-i,t.length),t=t.slice(0,t.length-i)),t.length>1&&(e=t.slice(1,t.length)),t=t[0]}function n(t){return null==t||Array.isArray(t)?t:[t]}return{inputs:t,initialState:e=n(e),constants:s=n(s)}}function zi(t,s,i,n=!1,r,l,u=!1,h=!1){return e.tidy(()=>{const c=s.shape.length;if(c<3)throw new a(`Input should be at least 3D, but is ${c}D.`);const p=[1,0].concat(st(2,c));if(s=e.transpose(s,p),null!=l)throw new o("The rnn() functoin of the deeplearn.js backend does not support constants yet.");u&&console.warn("Backend rnn(): the unroll = true option is not applicable to the imperative deeplearn.js backend."),null!=r&&((r=r.asType("bool").asType("float32")).rank===c-1&&(r=e.expandDims(r,-1)),r=e.transpose(r,p)),n&&(s=e.reverse(s,0),null!=r&&(r=e.reverse(r,0)));const d=[];let g,f=i;const m=s.shape[0],y=e.unstack(s);let b,w;null!=r&&(b=e.unstack(r));for(let s=0;s<m;++s){const i=y[s],n=e.tidy(()=>t(i,f));if(null==r)g=n[0],f=n[1];else{const t=e.tidy(()=>{const t=b[s],i=e.onesLike(t).sub(t);return{output:n[0].mul(t).add(f[0].mul(i)),newStates:f.map((e,s)=>n[1][s].mul(t).add(e.mul(i)))}});g=t.output,f=t.newStates}h&&d.push(g)}if(h){const t=1;w=e.stack(d,t)}return[g,w,f]})}bi.className="DepthwiseConv2D",e.serialization.registerClass(bi);class ki extends re{constructor(t){let e;if(super(t),null==t.cell)throw new a("cell property is missing for the constructor of RNN.");if(e=Array.isArray(t.cell)?new Li({cells:t.cell}):t.cell,null==e.stateSize)throw new a("The RNN cell should have an attribute `stateSize` (tuple of integers, one integer per RNN state).");this.cell=e,this.returnSequences=null!=t.returnSequences&&t.returnSequences,this.returnState=null!=t.returnState&&t.returnState,this.goBackwards=null!=t.goBackwards&&t.goBackwards,this._stateful=null!=t.stateful&&t.stateful,this.unroll=null!=t.unroll&&t.unroll,this.supportsMasking=!0,this.inputSpec=[new te({ndim:3})],this.stateSpec=null,this.states_=null,this.numConstants=null,this.keptStates=[]}getStates(){if(null==this.states_){return st(0,Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1).map(t=>null)}return this.states_}setStates(t){this.states_=t}computeOutputShape(t){Jt(t)&&(t=t[0]),t=t;let e=this.cell.stateSize;Array.isArray(e)||(e=[e]);const s=e[0];let i;if(i=this.returnSequences?[t[0],t[1],s]:[t[0],s],this.returnState){const s=[];for(const i of e)s.push([t[0],i]);return[i].concat(s)}return i}computeMask(t,s){return e.tidy(()=>{Array.isArray(s)&&(s=s[0]);const t=this.returnSequences?s:null;if(this.returnState){const e=this.states.map(t=>null);return[t].concat(e)}return t})}get states(){if(null==this.states_){const t=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1,e=[];for(let s=0;s<t;++s)e.push(null);return e}return this.states_}set states(t){this.states_=t}build(t){if(null!=this.numConstants)throw new o("Constants support is not implemented in RNN yet.");Jt(t)&&(t=t[0]),t=t;const s=this.stateful?t[0]:null,i=t.slice(2);this.inputSpec[0]=new te({shape:[s,null,...i]});const n=[t[0]].concat(t.slice(2));let r;if(this.cell.build(n),r=Array.isArray(this.cell.stateSize)?this.cell.stateSize:[this.cell.stateSize],null!=this.stateSpec){if(!e.util.arraysEqual(this.stateSpec.map(t=>t.shape[t.shape.length-1]),r))throw new a(`An initialState was passed that is not compatible with cell.stateSize. Received stateSpec=${this.stateSpec}; However cell.stateSize is `+this.cell.stateSize)}else this.stateSpec=r.map(t=>new te({shape:[null,t]}));this.stateful&&this.resetStates()}resetStates(t,s=!1){e.tidy(()=>{if(!this.stateful)throw new n("Cannot call resetStates() on an RNN Layer that is not stateful.");const i=this.inputSpec[0].shape[0];if(null==i)throw new a("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.states_)Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(t=>e.zeros([i,t])):this.states_=[e.zeros([i,this.cell.stateSize])];else if(null==t)e.dispose(this.states_),null!=this.keptStates&&(e.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(t=>e.zeros([i,t])):this.states_[0]=e.zeros([i,this.cell.stateSize]);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new a(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: `+t);!0===s?this.keptStates.push(this.states_.slice()):e.dispose(this.states_);for(let s=0;s<this.states_.length;++s){const n=t[s],r=Array.isArray(this.cell.stateSize)?this.cell.stateSize[s]:this.cell.stateSize,o=[i,r];if(!e.util.arraysEqual(n.shape,o))throw new a(`State ${s} is incompatible with layer ${this.name}: expected shape=${o}, received shape=${n.shape}`);this.states_[s]=n}}this.states_=this.states_.map(t=>e.keep(t.clone()))})}apply(t,e){let s=null==e?null:e.initialState,i=null==e?null:e.constants;null==e&&(e={});const n=wi(t,s,i,this.numConstants);t=n.inputs,s=n.initialState,i=n.constants;let r=[],a=[];if(null!=s){e.initialState=s,r=r.concat(s),this.stateSpec=[];for(const t of s)this.stateSpec.push(new te({shape:t.shape}));a=a.concat(this.stateSpec)}null!=i&&(e.constants=i,r=r.concat(i),this.numConstants=i.length);if(r[0]instanceof ee){const s=[t].concat(r),i=this.inputSpec.concat(a),n=this.inputSpec;this.inputSpec=i;const o=super.apply(s,e);return this.inputSpec=n,o}return super.apply(t,e)}call(t,s){return e.tidy(()=>{const e=null==s?null:s.mask,i=null==s?null:s.training;let n=null==s?null:s.initialState;t=Zt(t),null==n&&(n=this.stateful?this.states_:this.getInitialState(t));const r=Array.isArray(this.cell.stateSize)?this.cell.stateSize.length:1;if(n.length!==r)throw new a(`RNN Layer has ${r} state(s) but was passed `+n.length+" initial state(s).");this.unroll&&console.warn("Ignoring unroll = true for RNN layer, due to imperative backend.");const o={training:i},l=zi((t,e)=>{const s=this.cell.call([t].concat(e),o);return[s[0],s.slice(1)]},t,n,this.goBackwards,e,null,this.unroll,this.returnSequences),u=l[0],h=l[1],c=l[2];this.stateful&&this.resetStates(c,i);const p=this.returnSequences?h:u;return this.returnState?[p].concat(c):p})}getInitialState(t){return e.tidy(()=>{let s=e.zeros(t.shape);return s=e.sum(s,[1,2]),s=nt(s),Array.isArray(this.cell.stateSize)?this.cell.stateSize.map(t=>t>1?ht(s,[1,t]):s):this.cell.stateSize>1?[ht(s,[1,this.cell.stateSize])]:[s]})}get trainableWeights(){return this.trainable?this.cell.trainableWeights:[]}get nonTrainableWeights(){return this.trainable?this.cell.nonTrainableWeights:this.cell.weights}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.cell&&this.cell.setFastWeightInitDuringBuild(t)}getConfig(){const t=super.getConfig(),e={returnSequences:this.returnSequences,returnState:this.returnState,goBackwards:this.goBackwards,stateful:this.stateful,unroll:this.unroll};null!=this.numConstants&&(e.numConstants=this.numConstants);const s=this.cell.getConfig();return this.getClassName()===ki.className&&(e.cell={className:this.cell.getClassName(),config:s}),Object.assign({},s,t,e)}static fromConfig(t,e,s={}){const i=we(e.cell,s);return new t(Object.assign(e,{cell:i}))}}ki.className="RNN",e.serialization.registerClass(ki);class Si extends re{}class vi extends Si{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,N(this.units,"units"),this.activation=Ps(null==t.activation?this.DEFAULT_ACTIVATION:t.activation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Wt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Wt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Wt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ks(t.kernelRegularizer),this.recurrentRegularizer=Ks(t.recurrentRegularizer),this.biasRegularizer=Ks(t.biasRegularizer),this.kernelConstraint=F(t.kernelConstraint),this.recurrentConstraint=F(t.recurrentConstraint),this.biasConstraint=F(t.biasConstraint),this.dropout=tt([1,et([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=tt([1,et([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){t=Kt(t),this.kernel=this.addWeight("kernel",[t[t.length-1],this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,s){return e.tidy(()=>{if(2!==(t=t).length)throw new a(`SimpleRNNCell expects 2 input Tensors, got ${t.length}.`);let i=t[1];t=t[0];const n=null!=s.training&&s.training;let r;0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Ti({ones:()=>e.onesLike(t),rate:this.dropout,training:n})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Ti({ones:()=>e.onesLike(i),rate:this.recurrentDropout,training:n}));const o=this.dropoutMask,l=this.recurrentDropoutMask;r=pt(null!=o?e.mul(t,o):t,this.kernel.read()),null!=this.bias&&(r=mt(r,this.bias.read())),null!=l&&(i=e.mul(i,l));let u=e.add(r,pt(i,this.recurrentKernel.read()));return null!=this.activation&&(u=this.activation.apply(u)),[u,u]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Ws(this.activation),useBias:this.useBias,kernelInitializer:Bt(this.kernelInitializer),recurrentInitializer:Bt(this.recurrentInitializer),biasInitializer:Bt(this.biasInitializer),kernelRegularizer:Hs(this.kernelRegularizer),recurrentRegularizer:Hs(this.recurrentRegularizer),biasRegularizer:Hs(this.biasRegularizer),activityRegularizer:Hs(this.activityRegularizer),kernelConstraint:O(this.kernelConstraint),recurrentConstraint:O(this.recurrentConstraint),biasConstraint:O(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout};return Object.assign({},t,e)}}vi.className="SimpleRNNCell",e.serialization.registerClass(vi);class Ni extends ki{constructor(t){t.cell=new vi(t),super(t)}call(t,s){return e.tidy(()=>{null!=this.cell.dropoutMask&&(e.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(e.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const i=null==s?null:s.mask,n=null==s?null:s.training,r=null==s?null:s.initialState;return super.call(t,{mask:i,training:n,initialState:r})})}static fromConfig(t,e){return new t(e)}}Ni.className="SimpleRNN",e.serialization.registerClass(Ni);class Ai extends Si{constructor(t){if(super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",t.resetAfter)throw new a("GRUCell does not support reset_after parameter set to true.");this.units=t.units,N(this.units,"units"),this.activation=Ps(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=Ps(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Wt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Wt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Wt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelRegularizer=Ks(t.kernelRegularizer),this.recurrentRegularizer=Ks(t.recurrentRegularizer),this.biasRegularizer=Ks(t.biasRegularizer),this.kernelConstraint=F(t.kernelConstraint),this.recurrentConstraint=F(t.recurrentConstraint),this.biasConstraint=F(t.biasConstraint),this.dropout=tt([1,et([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=tt([1,et([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.implementation=t.implementation,this.stateSize=this.units,this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){const e=(t=Kt(t))[t.length-1];this.kernel=this.addWeight("kernel",[e,3*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,3*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias?this.bias=this.addWeight("bias",[3*this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint):this.bias=null,this.built=!0}call(t,s){return e.tidy(()=>{if(2!==(t=t).length)throw new a("GRUCell expects 2 input Tensors (inputs, h, c), got "+t.length+".");const i=null!=s.training&&s.training;let n=t[1];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Ti({ones:()=>e.onesLike(t),rate:this.dropout,training:i,count:3})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Ti({ones:()=>e.onesLike(n),rate:this.recurrentDropout,training:i,count:3}));const r=this.dropoutMask,o=this.recurrentDropoutMask;let l,u,h;0<this.dropout&&this.dropout<1&&(t=e.mul(t,r[0]));let c=pt(t,this.kernel.read());this.useBias&&(c=mt(c,this.bias.read())),0<this.recurrentDropout&&this.recurrentDropout<1&&(n=e.mul(n,o[0]));const p=this.recurrentKernel.read(),[d,g]=e.split(p,[2*this.units,this.units],p.rank-1),f=pt(n,d),[m,y,b]=e.split(c,3,c.rank-1),[w,z]=e.split(f,2,f.rank-1);l=this.recurrentActivation.apply(e.add(m,w)),u=this.recurrentActivation.apply(e.add(y,z));const k=pt(e.mul(u,n),g);h=this.activation.apply(e.add(b,k));const S=e.add(e.mul(l,n),e.mul(e.add(1,e.neg(l)),h));return[S,S]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Ws(this.activation),recurrentActivation:Ws(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Bt(this.kernelInitializer),recurrentInitializer:Bt(this.recurrentInitializer),biasInitializer:Bt(this.biasInitializer),kernelRegularizer:Hs(this.kernelRegularizer),recurrentRegularizer:Hs(this.recurrentRegularizer),biasRegularizer:Hs(this.biasRegularizer),activityRegularizer:Hs(this.activityRegularizer),kernelConstraint:O(this.kernelConstraint),recurrentConstraint:O(this.recurrentConstraint),biasConstraint:O(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation,resetAfter:!1};return Object.assign({},t,e)}}Ai.className="GRUCell",e.serialization.registerClass(Ai);class Ci extends ki{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new Ai(t),super(t)}call(t,s){return e.tidy(()=>{null!=this.cell.dropoutMask&&(e.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(e.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const i=null==s?null:s.mask,n=null==s?null:s.training,r=null==s?null:s.initialState;return super.call(t,{mask:i,training:n,initialState:r})})}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}Ci.className="GRU",e.serialization.registerClass(Ci);class xi extends Si{constructor(t){super(t),this.DEFAULT_ACTIVATION="tanh",this.DEFAULT_RECURRENT_ACTIVATION="hardSigmoid",this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_RECURRENT_INITIALIZER="orthogonal",this.DEFAULT_BIAS_INITIALIZER="zeros",this.units=t.units,N(this.units,"units"),this.activation=Ps(void 0===t.activation?this.DEFAULT_ACTIVATION:t.activation),this.recurrentActivation=Ps(void 0===t.recurrentActivation?this.DEFAULT_RECURRENT_ACTIVATION:t.recurrentActivation),this.useBias=null==t.useBias||t.useBias,this.kernelInitializer=Wt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.recurrentInitializer=Wt(t.recurrentInitializer||this.DEFAULT_RECURRENT_INITIALIZER),this.biasInitializer=Wt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.unitForgetBias=t.unitForgetBias,this.kernelRegularizer=Ks(t.kernelRegularizer),this.recurrentRegularizer=Ks(t.recurrentRegularizer),this.biasRegularizer=Ks(t.biasRegularizer),this.kernelConstraint=F(t.kernelConstraint),this.recurrentConstraint=F(t.recurrentConstraint),this.biasConstraint=F(t.biasConstraint),this.dropout=tt([1,et([0,null==t.dropout?0:t.dropout])]),this.recurrentDropout=tt([1,et([0,null==t.recurrentDropout?0:t.recurrentDropout])]),this.implementation=t.implementation,this.stateSize=[this.units,this.units],this.dropoutMask=null,this.recurrentDropoutMask=null}build(t){var e;const s=(t=Kt(t))[t.length-1];let i;if(this.kernel=this.addWeight("kernel",[s,4*this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.recurrentKernel=this.addWeight("recurrent_kernel",[this.units,4*this.units],null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){if(this.unitForgetBias){const t=this.biasInitializer,s=this.units;i=new((e=class extends kt{apply(e,i){const n=t.apply([s]),r=(new vt).apply([s]),a=t.apply([2*s]);return ut(ut(n,r),a)}}).className="CustomInit",e)}else i=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.units],null,i,this.biasRegularizer,!0,this.biasConstraint)}else this.bias=null;this.built=!0}call(t,s){return e.tidy(()=>{const i=null!=s.training&&s.training;if(3!==(t=t).length)throw new a("LSTMCell expects 3 input Tensors (inputs, h, c), got "+t.length+".");let n=t[1];const r=t[2];t=t[0],0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Ti({ones:()=>e.onesLike(t),rate:this.dropout,training:i,count:4})),0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Ti({ones:()=>e.onesLike(n),rate:this.recurrentDropout,training:i,count:4}));const o=this.dropoutMask,l=this.recurrentDropoutMask;let u,h,c,p;0<this.dropout&&this.dropout<1&&(t=e.mul(t,o[0]));let d=pt(t,this.kernel.read());0<this.recurrentDropout&&this.recurrentDropout<1&&(n=e.mul(n,l[0])),d=e.add(d,pt(n,this.recurrentKernel.read())),this.useBias&&(d=mt(d,this.bias.read()));const[g,f,m,y]=e.split(d,4,d.rank-1);u=this.recurrentActivation.apply(g),h=this.recurrentActivation.apply(f),c=e.add(e.mul(h,r),e.mul(u,this.activation.apply(m))),p=this.recurrentActivation.apply(y);const b=e.mul(p,this.activation.apply(c));return[b,b,c]})}getConfig(){const t=super.getConfig(),e={units:this.units,activation:Ws(this.activation),recurrentActivation:Ws(this.recurrentActivation),useBias:this.useBias,kernelInitializer:Bt(this.kernelInitializer),recurrentInitializer:Bt(this.recurrentInitializer),biasInitializer:Bt(this.biasInitializer),unitForgetBias:this.unitForgetBias,kernelRegularizer:Hs(this.kernelRegularizer),recurrentRegularizer:Hs(this.recurrentRegularizer),biasRegularizer:Hs(this.biasRegularizer),activityRegularizer:Hs(this.activityRegularizer),kernelConstraint:O(this.kernelConstraint),recurrentConstraint:O(this.recurrentConstraint),biasConstraint:O(this.biasConstraint),dropout:this.dropout,recurrentDropout:this.recurrentDropout,implementation:this.implementation};return Object.assign({},t,e)}}xi.className="LSTMCell",e.serialization.registerClass(xi);class Ii extends ki{constructor(t){0===t.implementation&&console.warn("`implementation=0` has been deprecated, and now defaults to `implementation=1`. Please update your layer call."),t.cell=new xi(t),super(t)}call(t,s){return e.tidy(()=>{null!=this.cell.dropoutMask&&(e.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(e.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null);const i=null==s?null:s.mask,n=null==s?null:s.training,r=null==s?null:s.initialState;return super.call(t,{mask:i,training:n,initialState:r})})}static fromConfig(t,e){return 0===e.implmentation&&(e.implementation=1),new t(e)}}Ii.className="LSTM",e.serialization.registerClass(Ii);class Li extends Si{constructor(t){super(t),this.cells=t.cells}get stateSize(){const t=[];for(const e of this.cells.slice().reverse())Array.isArray(e.stateSize)?t.push(...e.stateSize):t.push(e.stateSize);return t}call(t,s){return e.tidy(()=>{let e=(t=t).slice(1);const i=[];for(const t of this.cells.slice().reverse())Array.isArray(t.stateSize)?i.push(e.splice(0,t.stateSize.length)):i.push(e.splice(0,1));i.reverse();const n=[];let r;for(let a=0;a<this.cells.length;++a){const o=this.cells[a];e=i[a],r=0===a?[t[0]].concat(e):[r[0]].concat(e),r=o.call(r,s),n.push(r.slice(1))}e=[];for(const t of n.slice().reverse())e.push(...t);return[r[0]].concat(e)})}build(t){let e;Jt(t)&&(t=t[0]),t=t,this.cells.forEach((s,i)=>{H("RNNCell_"+i,()=>{s.build(t),e=Array.isArray(s.stateSize)?s.stateSize[0]:s.stateSize,t=[t[0],e]})}),this.built=!0}getConfig(){const t=super.getConfig(),e={cells:this.cells.map(t=>({className:t.getClassName(),config:t.getConfig()}))};return Object.assign({},t,e)}static fromConfig(t,e,s={}){const i=[];for(const t of e.cells)i.push(we(t,s));return new t({cells:i})}get trainableWeights(){if(!this.trainable)return[];const t=[];for(const e of this.cells)t.push(...e.trainableWeights);return t}get nonTrainableWeights(){const t=[];for(const e of this.cells)t.push(...e.nonTrainableWeights);if(!this.trainable){const e=[];for(const t of this.cells)e.push(...t.trainableWeights);return e.concat(t)}return t}getWeights(){const t=[];for(const e of this.cells)t.push(...e.weights);return Xt(t)}setWeights(t){const e=[];for(const s of this.cells){const i=s.weights.length,n=t.splice(i);for(let t=0;t<s.weights.length;++t)e.push([s.weights[t],n[t]])}Qt(e)}}function Ti(t){const{ones:s,rate:i,training:n=!1,count:r=1}=t,a=()=>yt(s(),i),o=()=>bt(a,s,n);if(!r||r<=1)return e.keep(o().clone());return Array(r).fill(void 0).map(o).map(t=>e.keep(t.clone()))}Li.className="StackedRNNCells",e.serialization.registerClass(Li);class Ei extends ki{constructor(t){if(t.unroll)throw new o("Unrolling is not possible with convolutional RNNs.");if(Array.isArray(t.cell))throw new o("It is not possible at the moment to stack convolutional cells.");super(t),this.inputSpec=[new te({ndim:5})]}call(t,s){return e.tidy(()=>{if(null!=this.cell.dropoutMask&&(e.dispose(this.cell.dropoutMask),this.cell.dropoutMask=null),null!=this.cell.recurrentDropoutMask&&(e.dispose(this.cell.recurrentDropoutMask),this.cell.recurrentDropoutMask=null),s&&s.constants)throw new a("ConvRNN2D cell does not support constants");const i=null==s?null:s.mask,n=null==s?null:s.training,r=null==s?null:s.initialState;return super.call(t,{mask:i,training:n,initialState:r})})}computeOutputShape(t){let e=this.computeSingleOutputShape(t);return this.returnSequences||(e=[e[0],...e.slice(2)]),this.returnState&&(e=[e,...Array(2).fill([t[0],...e.slice(-3)])]),e}getInitialState(t){return e.tidy(()=>{const{stateSize:s}=this.cell,i=t.shape,n=this.computeSingleOutputShape(i),r=[n[0],...n.slice(2)],a=e.zeros(r);return Array.isArray(s)?Array(s.length).fill(a):[a]})}resetStates(t,s=!1){e.tidy(()=>{if(!this.stateful)throw new n("Cannot call resetStates() on an RNN Layer that is not stateful.");const i=this.inputSpec[0].shape,r=this.computeSingleOutputShape(i),o=[r[0],...r.slice(2)];if(null==i[0])throw new a("If an RNN is stateful, it needs to know its batch size. Specify the batch size of your input tensors: \n- If using a Sequential model, specify the batch size by passing a `batchInputShape` option to your first layer.\n- If using the functional API, specify the batch size by passing a `batchShape` option to your Input layer.");if(null==this.getStates())Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>e.zeros(o)):this.states_=[e.zeros(o)];else if(null==t)e.dispose(this.states_),null!=this.keptStates&&(e.dispose(this.keptStates),this.keptStates=[]),Array.isArray(this.cell.stateSize)?this.states_=this.cell.stateSize.map(()=>e.zeros(o)):this.states_[0]=e.zeros(o);else{if(Array.isArray(t)||(t=[t]),t.length!==this.states_.length)throw new a(`Layer ${this.name} expects ${this.states_.length} state(s), but it received ${t.length} state value(s). Input received: `+t);s?this.keptStates.push(this.states_.slice()):e.dispose(this.states_);for(let s=0;s<this.states_.length;++s){const i=t[s],n=o;if(!e.util.arraysEqual(i.shape,n))throw new a(`State ${s} is incompatible with layer ${this.name}: expected shape=${n}, received shape=${i.shape}`);this.states_[s]=i}}this.states_=this.states_.map(t=>e.keep(t.clone()))})}computeSingleOutputShape(t){const{dataFormat:e,filters:s,kernelSize:i,padding:n,strides:r,dilationRate:a}=this.cell,o="channelsFirst"===e,l=t[o?3:2],u=t[o?4:3],h=ii(l,i[0],n,r[0],a[0]),c=ii(u,i[1],n,r[1],a[1]);return[...t.slice(0,2),...o?[s,h,c]:[h,c,s]]}}Ei.className="ConvRNN2D";class Di extends xi{constructor(t){const{filters:e,kernelSize:s,strides:i,padding:n,dataFormat:r,dilationRate:a}=t;super(Object.assign({},t,{units:e})),this.filters=e,N(this.filters,"filters"),this.kernelSize=si(s,2,"kernelSize"),this.kernelSize.forEach(t=>N(t,"kernelSize")),this.strides=si(i||1,2,"strides"),this.strides.forEach(t=>N(t,"strides")),this.padding=n||"valid",V(this.padding),this.dataFormat=r||"channelsLast",j(this.dataFormat),this.dilationRate=si(a||1,2,"dilationRate"),this.dilationRate.forEach(t=>N(t,"dilationRate"))}build(t){var s;t=Kt(t);const i="channelsFirst"===this.dataFormat?1:t.length-1;if(null==t[i])throw new a("The channel dimension of the input should be defined. Found "+t[i]);const n=t[i],r=this.kernelSize.concat([n,4*this.filters]);this.kernel=this.addWeight("kernel",r,null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint);const o=this.kernelSize.concat([this.filters,4*this.filters]);if(this.recurrentKernel=this.addWeight("recurrent_kernel",o,null,this.recurrentInitializer,this.recurrentRegularizer,!0,this.recurrentConstraint),this.useBias){let t;if(this.unitForgetBias){const i=this.biasInitializer,n=this.filters;t=new((s=class extends kt{apply(t,s){return lt([i.apply([n]),e.ones([n]),i.apply([2*n])])}}).className="CustomInit",s)}else t=this.biasInitializer;this.bias=this.addWeight("bias",[4*this.filters],null,t,this.biasRegularizer,!0,this.biasConstraint)}this.built=!0}call(t,s){return e.tidy(()=>{if(3!==t.length)throw new a("ConvLSTM2DCell expects 3 input Tensors (inputs, h, c), got "+t.length+".");const i=s.training||!1,n=t[0],r=t[1],o=t[2];0<this.dropout&&this.dropout<1&&null==this.dropoutMask&&(this.dropoutMask=Ti({ones:()=>e.onesLike(n),rate:this.dropout,training:i,count:4}));const l=this.dropoutMask,u=(t,s,i)=>s&&s[i]?e.mul(s[i],t):t;let h=u(n,l,0),c=u(n,l,1),p=u(n,l,2),d=u(n,l,3);0<this.recurrentDropout&&this.recurrentDropout<1&&null==this.recurrentDropoutMask&&(this.recurrentDropoutMask=Ti({ones:()=>e.onesLike(r),rate:this.recurrentDropout,training:i,count:4}));const g=this.recurrentDropoutMask;let f=u(r,g,0),m=u(r,g,1),y=u(r,g,2),b=u(r,g,3);const[w,z,k,S]=e.split(this.kernel.read(),4,3),[v,N,A,C]=this.useBias?e.split(this.bias.read(),4):[null,null,null,null];h=this.inputConv(h,w,v,this.padding),c=this.inputConv(c,z,N,this.padding),p=this.inputConv(p,k,A,this.padding),d=this.inputConv(d,S,C,this.padding);const[x,I,L,T]=e.split(this.recurrentKernel.read(),4,3);f=this.recurrentConv(f,x),m=this.recurrentConv(m,I),y=this.recurrentConv(y,L),b=this.recurrentConv(b,T);const E=this.recurrentActivation.apply(e.add(h,f)),D=this.recurrentActivation.apply(e.add(c,m)),O=e.add(e.mul(D,o),e.mul(E,this.activation.apply(e.add(p,y)))),R=e.mul(this.recurrentActivation.apply(e.add(d,b)),this.activation.apply(O));return[R,R,O]})}getConfig(){const t=function(t,e){var s={};for(var i in t)Object.prototype.hasOwnProperty.call(t,i)&&e.indexOf(i)<0&&(s[i]=t[i]);if(null!=t&&"function"==typeof Object.getOwnPropertySymbols){var n=0;for(i=Object.getOwnPropertySymbols(t);n<i.length;n++)e.indexOf(i[n])<0&&Object.prototype.propertyIsEnumerable.call(t,i[n])&&(s[i[n]]=t[i[n]])}return s}(super.getConfig(),["units"]),e={filters:this.filters,kernelSize:this.kernelSize,padding:this.padding,dataFormat:this.dataFormat,dilationRate:this.dilationRate,strides:this.strides};return Object.assign({},t,e)}inputConv(t,s,i,n){const r=e.conv2d(t,s,this.strides,n||"valid","channelsFirst"===this.dataFormat?"NCHW":"NHWC",this.dilationRate);return i?mt(r,i,this.dataFormat):r}recurrentConv(t,s){return e.conv2d(t,s,1,"same","channelsFirst"===this.dataFormat?"NCHW":"NHWC")}}Di.className="ConvLSTM2DCell",e.serialization.registerClass(Di);class Oi extends Ei{constructor(t){const e=new Di(t);super(Object.assign({},t,{cell:e}))}static fromConfig(t,e){return new t(e)}}Oi.className="ConvLSTM2D",e.serialization.registerClass(Oi);class Ri extends re{constructor(t){super(t),this.rate=Math.max(Math.min(t.rate,1),0),this.noiseShape=t.noiseShape,this.seed=t.seed,this.supportsMasking=!0}getNoiseShape(t){if(null==this.noiseShape)return this.noiseShape;const e=t.shape,s=[];for(let t=0;t<this.noiseShape.length;++t)s.push(null==this.noiseShape[t]?e[t]:this.noiseShape[t]);return s}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t);if(0<this.rate&&this.rate<1){const t=null!=s.training&&s.training,i=this.getNoiseShape(e);return bt(()=>yt(e,this.rate,i,this.seed),()=>e,t)}return t})}getConfig(){const t={rate:this.rate,noiseShape:this.noiseShape,seed:this.seed},e=super.getConfig();return Object.assign(t,e),t}dispose(){return super.dispose()}}Ri.className="Dropout",e.serialization.registerClass(Ri);class Fi extends Ri{constructor(t){super(t),this.inputSpec=[{ndim:3}]}getNoiseShape(t){const e=t.shape;return[e[0],1,e[2]]}}Fi.className="SpatialDropout1D",e.serialization.registerClass(Fi);class _i extends re{constructor(t){if(super(t),this.activation=null,this.useBias=!0,this.kernel=null,this.bias=null,this.DEFAULT_KERNEL_INITIALIZER="glorotNormal",this.DEFAULT_BIAS_INITIALIZER="zeros",null==t.batchInputShape&&null==t.inputShape&&null!=t.inputDim){let e=null;null!=t.batchSize&&(e=t.batchSize),this.batchInputShape=[e,t.inputDim]}this.units=t.units,N(this.units,"units"),this.activation=Ps(t.activation),null!=t.useBias&&(this.useBias=t.useBias),this.kernelInitializer=Wt(t.kernelInitializer||this.DEFAULT_KERNEL_INITIALIZER),this.biasInitializer=Wt(t.biasInitializer||this.DEFAULT_BIAS_INITIALIZER),this.kernelConstraint=F(t.kernelConstraint),this.biasConstraint=F(t.biasConstraint),this.kernelRegularizer=Ks(t.kernelRegularizer),this.biasRegularizer=Ks(t.biasRegularizer),this.activityRegularizer=Ks(t.activityRegularizer),this.supportsMasking=!0,this.inputSpec=[{minNDim:2}]}build(t){const e=(t=Kt(t))[t.length-1];null==this.kernel&&(this.kernel=this.addWeight("kernel",[e,this.units],null,this.kernelInitializer,this.kernelRegularizer,!0,this.kernelConstraint),this.useBias&&(this.bias=this.addWeight("bias",[this.units],null,this.biasInitializer,this.biasRegularizer,!0,this.biasConstraint))),this.inputSpec=[{minNDim:2,axes:{[-1]:e}}],this.built=!0}computeOutputShape(t){const e=(t=Kt(t)).slice();return e[e.length-1]=this.units,e}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t),i=A(this.activation.getClassName());let n;return null!=i?n=pt(e,this.kernel.read(),i,this.bias?this.bias.read():null):(n=pt(e,this.kernel.read()),null!=this.bias&&(n=mt(n,this.bias.read())),null!=this.activation&&(n=this.activation.apply(n))),n})}getConfig(){const t={units:this.units,activation:Ws(this.activation),useBias:this.useBias,kernelInitializer:Bt(this.kernelInitializer),biasInitializer:Bt(this.biasInitializer),kernelRegularizer:Hs(this.kernelRegularizer),biasRegularizer:Hs(this.biasRegularizer),activityRegularizer:Hs(this.activityRegularizer),kernelConstraint:O(this.kernelConstraint),biasConstraint:O(this.biasConstraint)},e=super.getConfig();return Object.assign(t,e),t}}_i.className="Dense",e.serialization.registerClass(_i);class Mi extends re{constructor(t){super(t=t||{}),this.inputSpec=[{minNDim:3}],this.dataFormat=t.dataFormat}computeOutputShape(t){t=Kt(t);for(const e of t.slice(1))if(null==e)throw new a(`The shape of the input to "Flatten" is not fully defined (got ${t.slice(1)}). Make sure to pass a complete "input_shape" or "batch_input_shape" argument to the first layer in your model.`);return[t[0],X(t,1)]}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);let e=Zt(t);if("channelsFirst"===this.dataFormat&&e.rank>1){const t=[0];for(let s=2;s<e.rank;++s)t.push(s);t.push(1),e=e.transpose(t)}return function(t){if(t.rank<=1)throw new a(`batchFlatten requires a minimum rank of 2. Got rank: ${t.rank}.`);const e=[t.shape[0],X(t.shape,1)];return t.reshape(e)}(e)})}getConfig(){const t={};null!=this.dataFormat&&(t.dataFormat=this.dataFormat);const e=super.getConfig();return Object.assign(t,e),t}}Mi.className="Flatten",e.serialization.registerClass(Mi);class $i extends re{constructor(t){super(t),this.supportsMasking=!0,this.activation=Ps(t.activation)}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t);return this.activation.apply(e)})}getConfig(){const t={activation:Ws(this.activation)},e=super.getConfig();return Object.assign(t,e),t}}$i.className="Activation",e.serialization.registerClass($i);class Bi extends re{constructor(t){super(t),this.n=t.n,this.inputSpec=[{ndim:2}]}computeOutputShape(t){return[t[0],this.n,t[1]]}call(t,s){return e.tidy(()=>{return t=Zt(t),s=t,i=this.n,e.tidy(()=>{if(2!==s.shape.length)throw new a(`repeat() expects a rank-2 tensor, but received a rank-${s.shape.length} tensor.`);return ht(nt(s,1),[1,i,1])});var s,i})}getConfig(){const t={n:this.n},e=super.getConfig();return Object.assign(t,e),t}}Bi.className="RepeatVector",e.serialization.registerClass(Bi);class Wi extends re{constructor(t){super(t),this.targetShape=t.targetShape;for(let t=0;t<this.targetShape.length;++t)this.isUnknown(this.targetShape[t])&&(this.targetShape[t]=null)}isUnknown(t){return t<0||null==t}fixUnknownDimension(t,e){const s="Total size of new array must be unchanged.",i=e.slice();let n=1,r=null;for(let t=0;t<i.length;++t){const e=i[t];if(this.isUnknown(e)){if(null!==r)throw new a("Can only specifiy one unknown dimension.");r=t}else n*=e}const o=X(t);if(null!==r){if(0===n||o%n!=0)throw new a(s);i[r]=o/n}else if(o!==n)throw new a(s);return i}computeOutputShape(t){let e=!1;for(let s=0;s<t.length;++s)if(this.isUnknown(t[s])){e=!0;break}return e?t.slice(0,1).concat(this.targetShape):t.slice(0,1).concat(this.fixUnknownDimension(t.slice(1),this.targetShape))}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t),i=e.shape,n=i.slice(0,1).concat(this.fixUnknownDimension(i.slice(1),this.targetShape));return e.reshape(n)})}getConfig(){const t={targetShape:this.targetShape},e=super.getConfig();return Object.assign(t,e),t}}Wi.className="Reshape",e.serialization.registerClass(Wi);class Ui extends re{constructor(t){if(super(t),null==t.dims)throw new Error("Required configuration field `dims` is missing during Permute constructor call.");if(!Array.isArray(t.dims))throw new Error("Permute constructor requires `dims` to be an Array, but received "+t.dims+" instead.");const s=st(1,t.dims.length+1);if(!e.util.arraysEqual(t.dims.slice().sort(),s))throw new Error("Invalid permutation `dims`: "+JSON.stringify(t.dims)+" `dims` must contain consecutive integers starting from 1.");this.dims=t.dims,this.dimsIncludingBatch=[0].concat(this.dims),this.inputSpec=[new te({ndim:this.dims.length+1})]}computeOutputShape(t){const e=(t=Kt(t)).slice();return this.dims.forEach((s,i)=>{e[i+1]=t[s]}),e}call(t,s){return e.transpose(Zt(t),this.dimsIncludingBatch)}getConfig(){const t={dims:this.dims},e=super.getConfig();return Object.assign(t,e),t}}Ui.className="Permute",e.serialization.registerClass(Ui);class Pi extends re{constructor(t){super(null==t?{}:t),this.supportsMasking=!0,this.maskValue=null!=t?null==t.maskValue?0:t.maskValue:0}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={maskValue:this.maskValue};return Object.assign(e,t),e}computeMask(t,s){const i=Zt(t);return e.any(e.notEqual(i,this.maskValue),-1)}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const i=Zt(t),n=e.any(e.notEqual(i,this.maskValue),-1,!0);return i.mul(n.asType(i.dtype))})}}Pi.className="Masking",e.serialization.registerClass(Pi);class ji extends re{constructor(t){if(super(t),this.embeddings=null,this.DEFAULT_EMBEDDINGS_INITIALIZER="randomUniform",null==t.batchInputShape&&null==t.inputShape){let e=null;null!=t.batchSize&&(e=t.batchSize),null==t.inputLength?this.batchInputShape=[e,null]:this.batchInputShape=[e].concat(d(t.inputLength))}this.inputDim=t.inputDim,N(this.inputDim,"inputDim"),this.outputDim=t.outputDim,N(this.outputDim,"outputDim"),this.embeddingsInitializer=Wt(t.embeddingsInitializer||this.DEFAULT_EMBEDDINGS_INITIALIZER),this.embeddingsRegularizer=Ks(t.embeddingsRegularizer),this.activityRegularizer=Ks(t.activityRegularizer),this.embeddingsConstraint=F(t.embeddingsConstraint),this.maskZero=t.maskZero,this.supportsMasking=t.maskZero,this.inputLength=t.inputLength}build(t){this.embeddings=this.addWeight("embeddings",[this.inputDim,this.outputDim],this.dtype,this.embeddingsInitializer,this.embeddingsRegularizer,!0,this.embeddingsConstraint),this.built=!0}warnOnIncompatibleInputShape(t){}computeMask(t,s){return e.tidy(()=>this.maskZero?(t=Zt(t),e.notEqual(t,e.zerosLike(t))):null)}computeOutputShape(t){if(t=Kt(t),null==this.inputLength)return[...t,this.outputDim];const e=d(this.inputLength);if(e.length!==t.length-1)throw new a(`"inputLength" is ${this.inputLength}, but received input shape has shape `+t);{let s=0;for(let i=0;i<e.length;++i){const n=e[i],r=t[i+1];if(null!=n&&null!=r&&n!==r)throw new a(`"inputLength" is ${this.inputLength}, but received input shape has shape `+t);null==n&&(e[s]=r),s++}}return[t[0],...e,this.outputDim]}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);let e=Zt(t);"int32"!==e.dtype&&(e=it(e,"int32"));return dt(this.embeddings.read(),e.as1D()).reshape(Kt(this.computeOutputShape(e.shape)))})}getConfig(){const t={inputDim:this.inputDim,outputDim:this.outputDim,embeddingsInitializer:Bt(this.embeddingsInitializer),embeddingsRegularizer:Hs(this.embeddingsRegularizer),activityRegularizer:Hs(this.activityRegularizer),embeddingsConstraint:O(this.embeddingsConstraint),maskZero:this.maskZero,inputLength:this.inputLength},e=super.getConfig();return Object.assign(t,e),t}}ji.className="Embedding",e.serialization.registerClass(ji);class Vi extends re{constructor(t){super(t||{}),this.supportsMasking=!0}mergeFunction(t){throw new o}computeElementwiseOpOutputShape(t,e){if(null==t||null==e)return null;if(t.length<e.length)return this.computeElementwiseOpOutputShape(e,t);if(0===e.length)return t;const s=t.slice(0,t.length-e.length);for(let i=0;i<e.length;++i){const n=t[t.length-e.length+i],r=e[i];if(null==n||null==r||n<0||r<0)s.push(null);else if(1===n)s.push(r);else if(1===r)s.push(n);else{if(n!==r)throw new a("Operands could not be broadcast together with shapes "+JSON.stringify(t)+" "+JSON.stringify(e));s.push(n)}}return s}build(t){if(Array.isArray(t)&&!Array.isArray(t[0])&&(t=[Kt(t)]),(t=t).length<2)throw new a(`A merge layer should be called on an Array of at least 2 inputs. Got ${t.length} input(s).`);let e=[];for(const s of t)null!=s&&null!==s[0]&&e.push(s[0]);if(e=z(e),e.length>1)throw new a(`Can not merge tensors with different batch sizes. Got tensors with shapes: ${JSON.stringify(t)}.`);let s=null==t[0]?null:t[0].slice(1);for(let e=1;e<t.length;++e){const i=null==t[e]?null:t[e].slice(1);s=this.computeElementwiseOpOutputShape(s,i)}const i=t.map(t=>t.length);-1===t.indexOf(null)&&1===z(i).length?this.reshapeRequired=!1:this.reshapeRequired=!0}call(t,s){return e.tidy(()=>{if(t=t,this.reshapeRequired){const s=[],i=t.map(t=>t.rank);if(-1===i.indexOf(null)){const e=et(i);for(let i of t){const t=i.rank;for(let s=0;s<e-t;++s)i=nt(i,1);s.push(i)}return this.mergeFunction(s)}{let i=!1;for(const n of t){const t=n.rank;if(null==t){const t=n.shape,r=t[0],a=t.slice(1).concat([r]);let o=n.reshape([r].concat(X(t.slice(1))));o=e.transpose(o,[1,0]),o=o.reshape(a),s.push(o),i=!0}else if(t>1){const r=st(1,t).concat([0]);s.push(e.transpose(n,r)),i=!0}else s.push(n)}let n=this.mergeFunction(s);const r=n.rank;if(i)if(null==r){const t=n.shape,s=t[t.length-1],i=[s].concat(t.slice(0,t.length-1));n=e.transpose(n.reshape([-1,s]),[1,0]).reshape(i)}else if(r>1){const t=[r-1].concat(st(0,r-1));n=e.transpose(n,t)}return n}}return this.mergeFunction(t)})}computeOutputShape(t){let e;e=null==(t=t)[0]?null:t[0].slice(1);for(let s=1;s<t.length;++s){const i=null==t[s]?null:t[s].slice(1);e=this.computeElementwiseOpOutputShape(e,i)}let s=[];for(const e of t)null!=e&&null!==e[0]&&s.push(e[0]);return s=z(s),e=1===s.length?s.concat(e):[null].concat(e),e}computeMask(t,s){return e.tidy(()=>{if(null==s)return null;if(!Array.isArray(s))throw new a("`mask` should be an Array");if(!Array.isArray(t))throw new a("`inputs` should be an Array");if(s.length!==t.length)throw new a(`The Array 'inputs' and 'mask' are expected to have the same length, but have different lengths (${t.length} vs ${s.length})`);if(s.every(t=>null==t))return null;let i=(s=s.map(t=>null==t?t:e.expandDims(t,0)))[0];for(let t=1;t<s.length-1;++t)i=e.logicalAnd(i,s[t]);return i})}}class qi extends Vi{constructor(t){super(t)}mergeFunction(t){return e.tidy(()=>{let s=t[0].clone();for(let i=1;i<t.length;++i)s=e.add(s,t[i]);return s})}}qi.className="Add",e.serialization.registerClass(qi);class Ji extends Vi{constructor(t){super(t)}mergeFunction(t){return e.tidy(()=>{let s=t[0].clone();for(let i=1;i<t.length;++i)s=e.mul(s,t[i]);return s})}}Ji.className="Multiply",e.serialization.registerClass(Ji);class Hi extends Vi{constructor(t){super(t)}mergeFunction(t){return e.tidy(()=>{let s=t[0].clone();for(let i=1;i<t.length;++i)s=e.add(s,t[i]);return e.mul(1/t.length,s)})}}Hi.className="Average",e.serialization.registerClass(Hi);class Zi extends Vi{constructor(t){super(t)}mergeFunction(t){return e.tidy(()=>{let s=t[0];for(let i=1;i<t.length;++i)s=e.maximum(s,t[i]);return s})}}Zi.className="Maximum",e.serialization.registerClass(Zi);class Ki extends Vi{constructor(t){super(t)}mergeFunction(t){return e.tidy(()=>{let s=t[0];for(let i=1;i<t.length;++i)s=e.minimum(s,t[i]);return s})}}Ki.className="Minimum",e.serialization.registerClass(Ki);class Gi extends Vi{constructor(t){super(t),this.DEFAULT_AXIS=-1,null==t&&(t={}),this.axis=null==t.axis?this.DEFAULT_AXIS:t.axis,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){if(!Array.isArray(t)||!Array.isArray(t[0])||1===t.length)throw new a("A `Concatenate` layer should be called on a list of at least 2 inputs");t=t;let s=!0;for(const e of t)if(null!=e){s=!1;break}if(s)return;const i=[];for(let s=0;s<t.length;++s){const n=t[s].slice();n.splice(this.axis,1);let r=!1;for(const t of i)if(e.util.arraysEqual(t,n)){r=!0;break}r||i.push(n)}if(i.length>1)throw new a("A `Concatenate` layer requires inputs with matching shapes except for the concat axis. Got input shapes: "+JSON.stringify(t))}mergeFunction(t){return e.tidy(()=>lt(t,this.axis))}computeOutputShape(t){if(!Array.isArray(t)||!Array.isArray(t[0]))throw new a("A `Concatenate` layer should be called on a list of inputs.");const e=t,s=e[0].slice(),i=this.axis<0?s.length+this.axis:this.axis;for(const t of e.slice(1)){if(null==s[i]||null==t[i]){s[i]=null;break}s[i]+=t[i]}return s}computeMask(t,s){if(null==s)return null;if(!Array.isArray(s))throw new a("`mask` should be an array for Concatenate");if(!Array.isArray(t))throw new a("`inputs` should be an array for Concatenate");if(s.length!==t.length)throw new a(`Mismatch in the length of mask (${s.length}) and the legnth of inputs (${t.length})`);return e.tidy(()=>{let i=!0;if(s.forEach(t=>{null==t||(i=!1)}),i)return null;const n=[];for(let i=0;i<t.length;++i)null==s[i]?n.push(e.onesLike(t[i]).asType("bool")):s[i].rank<t[i].rank?n.push(e.expandDims(s[i],-1)):n.push(s[i]);const r=e.concat(n,this.axis);return e.all(r,-1,!1)})}getConfig(){const t={axis:this.axis},e=super.getConfig();return Object.assign(t,e),t}}function Yi(t,e){for(;t<0;)t+=e;return t}Gi.className="Concatenate",e.serialization.registerClass(Gi);class Xi extends Vi{constructor(t){super(t),this.axes=t.axes,this.normalize=null!=t.normalize&&t.normalize,this.supportsMasking=!0,this.reshapeRequired=!1}build(t){e.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const s=t[0],i=t[1];if(s.length>3||i.length>3)throw new o("Dot layer does not support tensors of 4D or higher rank yet.");const n=this.interpretAxes(s,i);if(s[n[0]]!==i[n[1]])throw new a(`Dimension incompatibility: ${s[n[0]]} !== ${i[n[1]]}`)}mergeFunction(t){if(2!==t.length)throw new a(`A \`Dot\` layer must be called on exactly 2 inputs, but received ${t.length} input(s).`);let s,i=t[0],n=t[1];return s=Array.isArray(this.axes)?this.axes.map((e,s)=>Yi(e,t[s].shape.length)):[Yi(this.axes,i.shape.length),Yi(this.axes,n.shape.length)],this.normalize&&(i=ze(i,s[0]),n=ze(n,s[1])),function(t,s,i){if(t.shape.length>3||s.shape.length>3)throw new o("batchDot is not implemented for tensors of 4D or higher rank yet");if(e.util.assert(t.shape.length>=2,()=>"batchDot requires the rank of x to be >= 2, but got "+t.shape.length),e.util.assert(t.shape.length>=2,()=>"batchDot requires the rank of y to be >= 2, but got "+s.shape.length),"number"==typeof i&&(i=[i,i]),"complex64"===t.dtype||"complex64"===s.dtype)throw new o("batchDot is not implemented for complex64-type Tensors yet.");const n=t.shape.length,r=s.shape.length;null==i&&(i=[n-1,r-2]);const a=i;return e.tidy(()=>{let e,i;if(n>r){e=n-r;const t=[];for(let s=0;s<e;++s)t.push(1);s=s.reshape(s.shape.concat(t))}else if(r>n){e=r-n;const s=[];for(let t=0;t<e;++t)s.push(1);t=t.reshape(t.shape.concat(s))}else e=0;if(2===t.shape.length&&2===s.shape.length)i=a[0]===a[1]?t.mul(s).sum(a[0]):t.transpose([1,0]).mul(s).sum(a[1]);else{const e=a[0]!==t.shape.length-1,n=a[1]===s.shape.length-1;i=t.matMul(s,e,n)}if(e>0){let t;t=n>r?n+r-3:n-1;const s=[];for(let i=t;i<t+e;++i)s.push(i);i=i.squeeze(s)}return 1===i.shape.length&&(i=i.expandDims(1)),i})}(i,n,s)}interpretAxes(t,e){let s;return s=Array.isArray(this.axes)?this.axes:[Yi(this.axes,t.length),Yi(this.axes,e.length)],s}computeOutputShape(t){e.util.assert(Array.isArray(t)&&2===t.length&&Array.isArray(t[0])&&Array.isArray(t[1]),()=>"A `Dot` layer should be called on a list of exactly 2 inputs.");const s=t[0].slice(),i=t[1].slice();if(s.length>3||i.length>3)throw new o("Dot layer does not support tensors of 4D or higher rank yet.");const n=this.interpretAxes(s,i);s.splice(n[0],1),i.splice(n[1],1),i.splice(0,1);const r=s.concat(i);return 1===r.length&&r.push(1),r}computeMask(t,e){return null}getConfig(){const t={axes:this.axes,normalize:this.normalize},e=super.getConfig();return Object.assign(t,e),t}}Xi.className="Dot",e.serialization.registerClass(Xi);class Qi extends re{constructor(t){super(t),this.supportsMasking=!0,this.stddev=t.stddev}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={stddev:this.stddev};return Object.assign(e,t),e}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t);return bt(()=>ct(e.shape,0,this.stddev).add(e),()=>e,s.training||!1)})}}Qi.className="GaussianNoise",e.serialization.registerClass(Qi);class tn extends re{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s);const e=Zt(t);if(this.rate>0&&this.rate<1){return bt(()=>{const t=Math.sqrt(this.rate/(1-this.rate));return e.mul(ct(e.shape,1,t))},()=>e,s.training||!1)}return e})}}tn.className="GaussianDropout",e.serialization.registerClass(tn);class en extends re{constructor(t){super(t),this.supportsMasking=!0,this.rate=t.rate,this.noiseShape=t.noiseShape}_getNoiseShape(t){return this.noiseShape||Zt(t).shape}computeOutputShape(t){return t}getConfig(){const t=super.getConfig(),e={rate:this.rate};return Object.assign(e,t),e}call(t,s){return e.tidy(()=>{if(this.rate<1&&this.rate>0){const i=this._getNoiseShape(t);return bt(()=>{const s=Zt(t),n=-1.7580993408473766;let r=e.greaterEqual(e.randomUniform(i),this.rate);r=it(r,"float32");const a=((1-this.rate)*(1+this.rate*n**2))**-.5,o=-a*n*this.rate;return s.mul(r).add(r.add(-1).mul(n)).mul(a).add(o)},()=>Zt(t),s.training||!1)}return t})}}function sn(t,s,i,n,r,a=.001){let l;if(2===t.rank)l=e.batchNorm2d(t,s,i,n,r,a);else if(3===t.rank)l=e.batchNorm3d(t,s,i,n,r,a);else{if(4!==t.rank)throw new o(`batchNormalization is not implemented for array of rank ${t.rank} yet`);l=e.batchNorm4d(t,s,i,n,r,a)}return l}function nn(t,s,i,n,r=.001){return e.util.arraysEqual(n.slice().sort(),st(0,t.rank-1))?function(t,s,i,n,r=.001){return e.tidy(()=>{const a=e.moments(t,n),o=a.mean,l=a.variance;return[sn(t,o,l,i,s,r),o,l]})}(t,s,i,n,r):function(t,s,i,n,r=.001){return e.tidy(()=>{const a=e.moments(t,n),o=a.mean,l=a.variance,u=[];for(const e of st(0,t.rank))-1!==n.indexOf(e)?u.push(1):u.push(t.shape[e]);const h=o.reshape(u),c=l.reshape(u),p=null==s?null:s.reshape(u),d=null==i?null:i.reshape(u);return[sn(t,h,c,d,p,r),o,l]})}(t,s,i,n,r)}en.className="AlphaDropout",e.serialization.registerClass(en);class rn extends re{constructor(t){null==t&&(t={}),super(t),this.supportsMasking=!0,this.axis=null==t.axis?-1:t.axis,this.momentum=null==t.momentum?.99:t.momentum,this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Wt(t.betaInitializer||"zeros"),this.gammaInitializer=Wt(t.gammaInitializer||"ones"),this.movingMeanInitializer=Wt(t.movingMeanInitializer||"zeros"),this.movingVarianceInitializer=Wt(t.movingVarianceInitializer||"ones"),this.betaConstraint=F(t.betaConstraint),this.gammaConstraint=F(t.gammaConstraint),this.betaRegularizer=Ks(t.betaRegularizer),this.gammaRegularizer=Ks(t.gammaRegularizer)}build(t){t=Kt(t);const e=this.axis>=0?this.axis:this.axis+t.length,s=t[e];if(null==s)throw new a(`Axis ${e} of input tensor should have a defined dimension but the layer received an input with shape `+JSON.stringify(t)+".");this.inputSpec=[new te({ndim:t.length,axes:{[e]:s}})];const i=[s];this.scale&&(this.gamma=this.addWeight("gamma",i,null,this.gammaInitializer,this.gammaRegularizer,!0,this.gammaConstraint)),this.center&&(this.beta=this.addWeight("beta",i,null,this.betaInitializer,this.betaRegularizer,!0,this.betaConstraint)),this.movingMean=this.addWeight("moving_mean",i,null,this.movingMeanInitializer,null,!1),this.movingVariance=this.addWeight("moving_variance",i,null,this.movingVarianceInitializer,null,!1),this.built=!0}call(t,s){return e.tidy(()=>{const i=null!=s.training&&s.training,n=Zt(t),r=n.shape,a=r.length,o=st(0,a),l=this.axis>=0?this.axis:this.axis+a;o.splice(l,1);const h=u(1,a);h[l]=r[l];const c=o.slice();c.sort();const p=!e.util.arraysEqual(c,st(0,a).slice(0,a-1));if(!i)return(()=>{if(p){const t=this.movingMean.read().reshape(h),e=this.movingVariance.read().reshape(h),s=this.center?this.beta.read().reshape(h):null,i=this.scale?this.gamma.read().reshape(h):null;return sn(n,t,e,s,i,this.epsilon)}return sn(n,this.movingMean.read(),this.movingVariance.read(),null==this.beta?null:this.beta.read(),null==this.gamma?null:this.gamma.read(),this.epsilon)})();const[d,g,f]=nn(n,this.gamma.read(),this.beta.read(),o,this.epsilon),m=(t,s,i)=>{e.tidy(()=>{const e=1-i,n=t.read(),r=n.sub(s).mul(e);t.write(n.sub(r))})};return(()=>{m(this.movingMean,g,this.momentum),m(this.movingVariance,f,this.momentum)})(),d})}getConfig(){const t={axis:this.axis,momentum:this.momentum,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Bt(this.betaInitializer),gammaInitializer:Bt(this.gammaInitializer),movingMeanInitializer:Bt(this.movingMeanInitializer),movingVarianceInitializer:Bt(this.movingVarianceInitializer),betaRegularizer:Hs(this.betaRegularizer),gammaRegularizer:Hs(this.gammaRegularizer),betaConstraint:O(this.betaConstraint),gammaConstraint:O(this.gammaConstraint)},e=super.getConfig();return Object.assign(t,e),t}}rn.className="BatchNormalization",e.serialization.registerClass(rn);class an extends re{constructor(t){if(null==t&&(t={}),super(t),this.axis=null==t.axis?-1:t.axis,"number"==typeof this.axis){if(!Number.isInteger(this.axis))throw new Error("Expected axis to be an integer, but received "+this.axis)}else{if(!Array.isArray(this.axis))throw new Error("Expected axis to be an integer or an array of integers, but received "+JSON.stringify(this.axis));for(const t of this.axis)if(!Number.isInteger(t))throw new Error("Expected axis to be an array of integers, but received "+JSON.stringify(this.axis))}this.epsilon=null==t.epsilon?.001:t.epsilon,this.center=null==t.center||t.center,this.scale=null==t.scale||t.scale,this.betaInitializer=Wt(t.betaInitializer||"zeros"),this.gammaInitializer=Wt(t.gammaInitializer||"ones"),this.betaRegularizer=Ks(t.betaRegularizer),this.gammaRegularizer=Ks(t.gammaRegularizer),this.supportsMasking=!0}build(t){const e=(t=Kt(t)).length;"number"==typeof this.axis&&(this.axis=[this.axis]);for(let t=0;t<this.axis.length;++t)this.axis[t]<0&&(this.axis[t]+=e);for(const t of this.axis)if(t<0||t>=e)throw new Error("Invalid axis: "+t);if(this.axis.length!==z(this.axis).length)throw new Error("Found duplicate axes in: "+this.axis);const s=this.axis.map(e=>t[e]);this.scale?this.gamma=this.addWeight("gamma",s,"float32",this.gammaInitializer,this.gammaRegularizer,!0):this.gamma=null,this.center?this.beta=this.addWeight("beta",s,"float32",this.betaInitializer,this.betaRegularizer,!0):this.beta=null,this.built=!0}call(t,s){const i=Zt(t),n=i.shape,r=n.length;return e.tidy(()=>{let{mean:t,variance:s}=e.moments(i,this.axis,!0);const a=u(1,r);for(const t of this.axis)a[t]=n[t];const o=t=>null!=t&&t.shape.length!==r&&this.axis!==[r-1]?t.reshape(a):t;let l=o(this.gamma.read()),h=o(this.beta.read());const c=[],p=[];for(let t=0;t<r;++t)-1!==this.axis.indexOf(t)?(c.push(n[t]),p.push(1)):(c.push(1),p.push(n[t]));return t=t.tile(c),s=s.tile(c),l=l.tile(p),h=h.tile(p),sn(i,t,s,h,l,this.epsilon)})}getConfig(){const t={axis:this.axis,epsilon:this.epsilon,center:this.center,scale:this.scale,betaInitializer:Bt(this.betaInitializer),gammaInitializer:Bt(this.gammaInitializer),betaRegularizer:Hs(this.betaRegularizer),gammaRegularizer:Hs(this.gammaRegularizer)},e=super.getConfig();return Object.assign(t,e),t}}an.className="LayerNormalization",e.serialization.registerClass(an);class on extends re{constructor(t){if(null==t&&(t={}),super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,null==t.padding)this.padding=[[1,1],[1,1]];else if("number"==typeof t.padding)this.padding=[[t.padding,t.padding],[t.padding,t.padding]];else{if(t.padding=t.padding,2!==t.padding.length)throw new a(`ZeroPadding2D expects padding to be a length-2 array, but received a length-${t.padding.length} array.`);let e,s;if("number"==typeof t.padding[0])e=[t.padding[0],t.padding[0]],s=[t.padding[1],t.padding[1]];else{if(t.padding=t.padding,2!==t.padding[0].length)throw new a(`ZeroPadding2D expects height padding to be a length-2 array, but received a length-${t.padding[0].length} array.`);if(e=t.padding[0],2!==t.padding[1].length)throw new a(`ZeroPadding2D expects width padding to be a length-2 array, but received a length-${t.padding[1].length} array.`);s=t.padding[1]}this.padding=[e,s]}this.inputSpec=[new te({ndim:4})]}computeOutputShape(t){let e,s;return t=Kt(t),"channelsFirst"===this.dataFormat?(e=null!=t[2]&&t[2]>=0?t[2]+this.padding[0][0]+this.padding[0][1]:null,s=null!=t[3]&&t[3]>=0?t[3]+this.padding[1][0]+this.padding[1][1]:null,[t[0],t[1],e,s]):(e=null!=t[1]&&t[1]>=0?t[1]+this.padding[0][0]+this.padding[0][1]:null,s=null!=t[2]&&t[2]>=0?t[2]+this.padding[1][0]+this.padding[1][1]:null,[t[0],e,s,t[3]])}call(t,s){return e.tidy(()=>{return s=Zt(t),i=this.padding,n=this.dataFormat,e.tidy(()=>{if(4!==s.rank)throw new a("temporalPadding expects input tensor to be 4-D, but received a "+s.rank+"-D tensor.");if(null==i&&(i=[[1,1],[1,1]]),2!==i.length||2!==i[0].length||2!==i[1].length)throw new a("spatial2dPadding expects `padding` to be an Array of two Arrays, each of which is an Array of two integers.");if(null==n&&(n="channelsLast"),"channelsLast"!==n&&"channelsFirst"!==n)throw new a(`Unknown data format: ${n}. Supported data formats are 'channelsLast' and 'channelsFirst.`);let t;return t="channelsFirst"===n?[[0,0],[0,0],i[0],i[1]]:[[0,0],i[0],i[1],[0,0]],e.pad(s,t)});var s,i,n})}getConfig(){const t={padding:this.padding,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}function ln(t,s,i,n,r,a){return e.tidy(()=>{let o;j(r),q(a),V(n),null==i&&(i=[1,1]),null==n&&(n="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),t=ri(t,r);const l="same"===n?"same":"valid";return o="max"===a?e.maxPool(t,s,i,l):e.avgPool(t,s,i,l),"channelsFirst"===r&&(o=e.transpose(o,[0,3,1,2])),o})}function un(t,s,i,n,r,a){return e.tidy(()=>{let o;j(r),q(a),V(n),null==i&&(i=[1,1,1]),null==n&&(n="valid"),null==r&&(r="channelsLast"),null==a&&(a="max"),t=ai(t,r);const l="same"===n?"same":"valid";return o="max"===a?e.maxPool3d(t,s,i,l):e.avgPool3d(t,s,i,l),"channelsFirst"===r&&(o=e.transpose(o,[0,4,1,2,3])),o})}on.className="ZeroPadding2D",e.serialization.registerClass(on);class hn extends re{constructor(t){if(null==t.poolSize&&(t.poolSize=2),super(t),"number"==typeof t.poolSize)this.poolSize=[t.poolSize];else{if(!Array.isArray(t.poolSize)||1!==t.poolSize.length||"number"!=typeof t.poolSize[0])throw new a("poolSize for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(t.poolSize));this.poolSize=t.poolSize}if(N(this.poolSize,"poolSize"),null==t.strides)this.strides=this.poolSize;else if("number"==typeof t.strides)this.strides=[t.strides];else{if(!Array.isArray(t.strides)||1!==t.strides.length||"number"!=typeof t.strides[0])throw new a("strides for 1D convolutional layer must be a number or an Array of a single number, but received "+JSON.stringify(t.strides));this.strides=t.strides}N(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,V(this.padding),this.inputSpec=[new te({ndim:3})]}computeOutputShape(t){const e=ii((t=Kt(t))[1],this.poolSize[0],this.padding,this.strides[0]);return[t[0],e,t[2]]}call(t,s){return e.tidy(()=>{this.invokeCallHook(t,s),t=nt(Zt(t),2);const i=this.poolingFunction(Zt(t),[this.poolSize[0],1],[this.strides[0],1],this.padding,"channelsLast");return e.squeeze(i,[2])})}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides},e=super.getConfig();return Object.assign(t,e),t}}class cn extends hn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),ln(t,e,s,i,n,"max")}}cn.className="MaxPooling1D",e.serialization.registerClass(cn);class pn extends hn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),ln(t,e,s,i,n,"avg")}}pn.className="AveragePooling1D",e.serialization.registerClass(pn);class dn extends re{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(2!==t.strides.length)throw new a("If the strides property of a 2D pooling layer is an Array, it is expected to have a length of 2, but received length "+t.strides.length+".");this.strides=t.strides}else this.strides=[t.strides,t.strides];N(this.poolSize,"poolSize"),N(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,j(this.dataFormat),V(this.padding),this.inputSpec=[new te({ndim:4})]}computeOutputShape(t){t=Kt(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],s="channelsFirst"===this.dataFormat?t[3]:t[2];return e=ii(e,this.poolSize[0],this.padding,this.strides[0]),s=ii(s,this.poolSize[1],this.padding,this.strides[1]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,s]:[t[0],e,s,t[3]]}call(t,s){return e.tidy(()=>(this.invokeCallHook(t,s),this.poolingFunction(Zt(t),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class gn extends dn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),ln(t,e,s,i,n,"max")}}gn.className="MaxPooling2D",e.serialization.registerClass(gn);class fn extends dn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),ln(t,e,s,i,n,"avg")}}fn.className="AveragePooling2D",e.serialization.registerClass(fn);class mn extends re{constructor(t){if(null==t.poolSize&&(t.poolSize=[2,2,2]),super(t),this.poolSize=Array.isArray(t.poolSize)?t.poolSize:[t.poolSize,t.poolSize,t.poolSize],null==t.strides)this.strides=this.poolSize;else if(Array.isArray(t.strides)){if(3!==t.strides.length)throw new a("If the strides property of a 3D pooling layer is an Array, it is expected to have a length of 3, but received length "+t.strides.length+".");this.strides=t.strides}else this.strides=[t.strides,t.strides,t.strides];N(this.poolSize,"poolSize"),N(this.strides,"strides"),this.padding=null==t.padding?"valid":t.padding,this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,j(this.dataFormat),V(this.padding),this.inputSpec=[new te({ndim:5})]}computeOutputShape(t){t=Kt(t);let e="channelsFirst"===this.dataFormat?t[2]:t[1],s="channelsFirst"===this.dataFormat?t[3]:t[2],i="channelsFirst"===this.dataFormat?t[4]:t[3];return e=ii(e,this.poolSize[0],this.padding,this.strides[0]),s=ii(s,this.poolSize[1],this.padding,this.strides[1]),i=ii(i,this.poolSize[2],this.padding,this.strides[2]),"channelsFirst"===this.dataFormat?[t[0],t[1],e,s,i]:[t[0],e,s,i,t[4]]}call(t,s){return e.tidy(()=>(this.invokeCallHook(t,s),this.poolingFunction(Zt(t),this.poolSize,this.strides,this.padding,this.dataFormat)))}getConfig(){const t={poolSize:this.poolSize,padding:this.padding,strides:this.strides,dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class yn extends mn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),un(t,e,s,i,n,"max")}}yn.className="MaxPooling3D",e.serialization.registerClass(yn);class bn extends mn{constructor(t){super(t)}poolingFunction(t,e,s,i,n){return j(n),V(i),un(t,e,s,i,n,"avg")}}bn.className="AveragePooling3D",e.serialization.registerClass(bn);class wn extends re{constructor(t){super(t),this.inputSpec=[new te({ndim:3})]}computeOutputShape(t){return[t[0],t[2]]}call(t,e){throw new o}}class zn extends wn{constructor(t){super(t||{})}call(t,s){return e.tidy(()=>{const s=Zt(t);return e.mean(s,1)})}}zn.className="GlobalAveragePooling1D",e.serialization.registerClass(zn);class kn extends wn{constructor(t){super(t||{})}call(t,s){return e.tidy(()=>{const s=Zt(t);return e.max(s,1)})}}kn.className="GlobalMaxPooling1D",e.serialization.registerClass(kn);class Sn extends re{constructor(t){super(t),this.dataFormat=null==t.dataFormat?"channelsLast":t.dataFormat,j(this.dataFormat),this.inputSpec=[new te({ndim:4})]}computeOutputShape(t){return t=t,"channelsLast"===this.dataFormat?[t[0],t[3]]:[t[0],t[1]]}call(t,e){throw new o}getConfig(){const t={dataFormat:this.dataFormat},e=super.getConfig();return Object.assign(t,e),t}}class vn extends Sn{call(t,s){return e.tidy(()=>{const s=Zt(t);return"channelsLast"===this.dataFormat?e.mean(s,[1,2]):e.mean(s,[2,3])})}}vn.className="GlobalAveragePooling2D",e.serialization.registerClass(vn);class Nn extends Sn{call(t,s){return e.tidy(()=>{const s=Zt(t);return"channelsLast"===this.dataFormat?e.max(s,[1,2]):e.max(s,[2,3])})}}Nn.className="GlobalMaxPooling2D",e.serialization.registerClass(Nn);class An extends re{constructor(t){super(t),this.layer=t.layer}build(t){this.built=!0}get trainable(){return null!=this.layer&&this.layer.trainable}set trainable(t){null!=this.layer&&(this.layer.trainable=t)}get trainableWeights(){return this.layer.trainableWeights}get nonTrainableWeights(){return this.layer.nonTrainableWeights}get updates(){return this.layer._updates}get losses(){return this.layer.losses}getWeights(){return this.layer.getWeights()}setWeights(t){this.layer.setWeights(t)}getConfig(){const t={layer:{className:this.layer.getClassName(),config:this.layer.getConfig()}},e=super.getConfig();return Object.assign(t,e),t}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.layer&&this.layer.setFastWeightInitDuringBuild(t)}static fromConfig(t,e,s={}){const i=we(e.layer,s);delete e.layer;const n={layer:i};return Object.assign(n,e),new t(n)}}class Cn extends An{constructor(t){super(t),this.supportsMasking=!0}build(t){if((t=Kt(t)).length<3)throw new a("TimeDistributed layer expects an input shape >= 3D, but received input shape "+JSON.stringify(t));this.inputSpec=[{shape:t}];const e=[t[0]].concat(t.slice(2));this.layer.built||(this.layer.build(e),this.layer.built=!0),super.build(t)}computeOutputShape(t){const e=[(t=Kt(t))[0]].concat(t.slice(2)),s=this.layer.computeOutputShape(e),i=t[1];return[s[0],i].concat(s.slice(1))}call(t,s){return e.tidy(()=>zi((t,e)=>[Zt(this.layer.call(t,s)),[]],t=Zt(t),[],!1,null,null,!1,!0)[1])}}Cn.className="TimeDistributed",e.serialization.registerClass(Cn);class xn extends An{constructor(t){super(t);const e=t.layer.getConfig(),s={};s.className=t.layer.getClassName(),s.config=e,this.forwardLayer=we(s),e.goBackwards=!0!==e.goBackwards;const i={};var n;if(i.className=t.layer.getClassName(),i.config=e,this.backwardLayer=we(i),this.forwardLayer.name="forward_"+this.forwardLayer.name,this.backwardLayer.name="backward_"+this.backwardLayer.name,this.mergeMode=void 0===t.mergeMode?"concat":t.mergeMode,n=this.mergeMode,S(U,"BidirectionalMergeMode",n),t.weights)throw new o("weights support is not implemented for Bidirectional layer yet.");this._stateful=t.layer.stateful,this.returnSequences=t.layer.returnSequences,this.returnState=t.layer.returnState,this.supportsMasking=!0,this._trainable=!0,this.inputSpec=t.layer.inputSpec,this.numConstants=null}get trainable(){return this._trainable}set trainable(t){this._trainable=t,null!=this.forwardLayer&&(this.forwardLayer.trainable=t),null!=this.backwardLayer&&(this.backwardLayer.trainable=t)}getWeights(){return this.forwardLayer.getWeights().concat(this.backwardLayer.getWeights())}setWeights(t){const e=t.length,s=Math.floor(e/2);this.forwardLayer.setWeights(t.slice(0,s)),this.backwardLayer.setWeights(t.slice(s))}computeOutputShape(t){let e,s,i,n=this.forwardLayer.computeOutputShape(t);return Array.isArray(n)&&Array.isArray(n[0])||(n=[n]),n=n,this.returnState?(i=n.slice(1),e=n[0]):e=n[0],e=e,"concat"===this.mergeMode?(e[e.length-1]*=2,s=[e]):s=null==this.mergeMode?[e,e.slice()]:[e],this.returnState?null==this.mergeMode?s.concat(i).concat(i.slice()):[e].concat(i).concat(i.slice()):p(s)}apply(t,e){let s=null==e?null:e.initialState,i=null==e?null:e.constants;null==e&&(e={});const n=wi(t,s,i,this.numConstants);if(t=n.inputs,s=n.initialState,i=n.constants,Array.isArray(t)&&(s=t.slice(1),t=t[0]),(null==s||0===s.length)&&null==i)return super.apply(t,e);const r=[],l=[];if(null!=s){const t=s.length;if(t%2>0)throw new a("When passing `initialState` to a Bidrectional RNN, the state should be an Array containing the states of the underlying RNNs.");e.initialState=s,r.push(...s);const i=s.map(t=>new te({shape:t.shape}));this.forwardLayer.stateSpec=i.slice(0,t/2),this.backwardLayer.stateSpec=i.slice(t/2),l.push(...i)}if(null!=i)throw new o("Support for constants in Bidirectional layers is not implemented yet.");const u=r[0]instanceof ee;for(const t of r)if(t instanceof ee!==u)throw new a("The initial state of a Bidirectional layer cannot be specified as a mix of symbolic and non-symbolic tensors");if(u){const s=[t].concat(r),i=this.inputSpec.concat(l),n=this.inputSpec;this.inputSpec=i;const a=super.apply(s,e);return this.inputSpec=n,a}return super.apply(t,e)}call(t,s){return e.tidy(()=>{const i=s.initialState;let n,r,a,o;if(null==i)n=this.forwardLayer.call(t,s),r=this.backwardLayer.call(t,s);else{const e=i.slice(0,i.length/2),a=i.slice(i.length/2);n=this.forwardLayer.call(t,Object.assign(s,{initialState:e})),r=this.backwardLayer.call(t,Object.assign(s,{initialState:a}))}return this.returnState&&(Array.isArray(n)&&(a=n.slice(1).concat(r.slice(1))),n=n[0],r=r[0]),this.returnSequences&&(r=e.reverse(r,1)),"concat"===this.mergeMode?o=lt([n,r]):"sum"===this.mergeMode?o=e.add(n,r):"ave"===this.mergeMode?o=e.mul(.5,e.add(n,r)):"mul"===this.mergeMode?o=e.mul(n,r):null==this.mergeMode&&(o=[n,r]),this.returnState?null==this.mergeMode?o.concat(a):[o].concat(a):o})}resetStates(t){this.forwardLayer.resetStates(),this.backwardLayer.resetStates()}build(t){H(this.forwardLayer.name,()=>{this.forwardLayer.build(t)}),H(this.backwardLayer.name,()=>{this.backwardLayer.build(t)}),this.built=!0}computeMask(t,e){let s;if(Array.isArray(e)&&(e=e[0]),s=this.returnSequences?null==this.mergeMode?[e,e]:e:null==this.mergeMode?[null,null]:null,this.returnState){const t=this.forwardLayer.states.map(t=>null);return Array.isArray(s)?s.concat(t).concat(t):[s].concat(t).concat(t)}return s}get trainableWeights(){return this.forwardLayer.trainableWeights.concat(this.backwardLayer.trainableWeights)}get nonTrainableWeights(){return this.forwardLayer.nonTrainableWeights.concat(this.backwardLayer.nonTrainableWeights)}setFastWeightInitDuringBuild(t){super.setFastWeightInitDuringBuild(t),null!=this.forwardLayer&&this.forwardLayer.setFastWeightInitDuringBuild(t),null!=this.backwardLayer&&this.backwardLayer.setFastWeightInitDuringBuild(t)}getConfig(){const t={mergeMode:this.mergeMode},e=super.getConfig();return Object.assign(t,e),t}static fromConfig(t,e){const s=we(e.layer);if(delete e.layer,null!=e.numConstants)throw new o("Deserialization of a Bidirectional layer with numConstants present is not supported yet.");const i=e;return i.layer=s,new t(i)}}function In(t){return new pn(t)}function Ln(t){return new fn(t)}function Tn(t){return new bn(t)}function En(t){return new kn(t)}function Dn(t){return new Nn(t)}function On(t){return new cn(t)}function Rn(t){return new gn(t)}xn.className="Bidirectional",e.serialization.registerClass(xn);const Fn=En,_n=Dn,Mn=On,$n=Rn;var Bn=Object.freeze({__proto__:null,inputLayer:function(t){return new ae(t)},elu:function(t){return new Qs(t)},reLU:function(t){return new Gs(t)},leakyReLU:function(t){return new Ys(t)},prelu:function(t){return new Xs(t)},softmax:function(t){return new ei(t)},thresholdedReLU:function(t){return new ti(t)},conv1d:function(t){return new fi(t)},conv2d:function(t){return new hi(t)},conv2dTranspose:function(t){return new pi(t)},conv3d:function(t){return new ci(t)},separableConv2d:function(t){return new gi(t)},cropping2D:function(t){return new mi(t)},upSampling2d:function(t){return new yi(t)},depthwiseConv2d:function(t){return new bi(t)},activation:function(t){return new $i(t)},dense:function(t){return new _i(t)},dropout:function(t){return new Ri(t)},spatialDropout1d:function(t){return new Fi(t)},flatten:function(t){return new Mi(t)},repeatVector:function(t){return new Bi(t)},reshape:function(t){return new Wi(t)},permute:function(t){return new Ui(t)},embedding:function(t){return new ji(t)},add:function(t){return new qi(t)},average:function(t){return new Hi(t)},concatenate:function(t){return new Gi(t)},maximum:function(t){return new Zi(t)},minimum:function(t){return new Ki(t)},multiply:function(t){return new Ji(t)},dot:function(t){return new Xi(t)},batchNormalization:function(t){return new rn(t)},layerNormalization:function(t){return new an(t)},zeroPadding2d:function(t){return new on(t)},averagePooling1d:In,avgPool1d:function(t){return In(t)},avgPooling1d:function(t){return In(t)},averagePooling2d:Ln,avgPool2d:function(t){return Ln(t)},avgPooling2d:function(t){return Ln(t)},averagePooling3d:Tn,avgPool3d:function(t){return Tn(t)},avgPooling3d:function(t){return Tn(t)},globalAveragePooling1d:function(t){return new zn(t)},globalAveragePooling2d:function(t){return new vn(t)},globalMaxPooling1d:En,globalMaxPooling2d:Dn,maxPooling1d:On,maxPooling2d:Rn,maxPooling3d:function(t){return new yn(t)},gru:function(t){return new Ci(t)},gruCell:function(t){return new Ai(t)},lstm:function(t){return new Ii(t)},lstmCell:function(t){return new xi(t)},simpleRNN:function(t){return new Ni(t)},simpleRNNCell:function(t){return new vi(t)},convLstm2d:function(t){return new Oi(t)},convLstm2dCell:function(t){return new Di(t)},rnn:function(t){return new ki(t)},stackedRNNCells:function(t){return new Li(t)},bidirectional:function(t){return new xn(t)},timeDistributed:function(t){return new Cn(t)},globalMaxPool1d:Fn,globalMaxPool2d:_n,maxPool1d:Mn,maxPool2d:$n,Layer:re,RNN:ki,RNNCell:Si,input:As,gaussianNoise:function(t){return new Qi(t)},gaussianDropout:function(t){return new tn(t)},alphaDropout:function(t){return new en(t)},masking:function(t){return new Pi(t)}});var Wn=Object.freeze({__proto__:null,binaryAccuracy:function(t,e){return Te(t,e)},binaryCrossentropy:function(t,e){return Fe(t,e)},sparseCategoricalAccuracy:function(t,e){return _e(t,e)},categoricalAccuracy:function(t,e){return Ee(t,e)},categoricalCrossentropy:function(t,e){return Me(t,e)},precision:function(t,e){return Oe(t,e)},recall:function(t,e){return Re(t,e)},cosineProximity:function(t,e){return xe(t,e)},meanAbsoluteError:function(t,e){return Se(t,e)},meanAbsolutePercentageError:function(t,e){return ve(t,e)},MAPE:function(t,e){return ve(t,e)},mape:function(t,e){return ve(t,e)},meanSquaredError:function(t,e){return ke(t,e)},MSE:function(t,e){return ke(t,e)},mse:function(t,e){return ke(t,e)}}),Un=Object.freeze({__proto__:null,modelFromJSON:async function(t,s){"modelTopology"in t||(t={modelTopology:t});let i=(t=t).modelTopology;null!=i.model_config&&(i=i.model_config);const n=we(Ze(i),s);if(null!=t.weightsManifest){const s=await e.io.loadWeights(t.weightsManifest,t.pathPrefix,n.weights.map(t=>t.originalName)),i={};for(const t of n.weights)i[t.originalName]=s[t.originalName];n.loadWeights(i),e.dispose(s)}return n}});var Pn=Object.freeze({__proto__:null,l1l2:function(t){return new qs(t)},l1:function(t){return js(e=t),new qs({l1:null!=e?e.l1:null,l2:0});var e},l2:function(t){return js(e=t),new qs({l2:null!=e?e.l2:null,l1:0});var e}});class jn extends ce{constructor(){super(...arguments),this.model=null}setModel(t){if(!(t instanceof ks))throw new Error("model must be a LayersModel, not some other Container");this.model=t}}function Vn(t,e){return t<e}function qn(t,e){return t>e}class Jn extends jn{constructor(t){if(super(),null==t&&(t={}),t.restoreBestWeights)throw new o("restoreBestWeights = True is not implemented in EarlyStopping yet.");this.monitor=t.monitor||"val_loss",this.minDelta=Math.abs(t.minDelta||0),this.patience=t.patience||0,this.verbose=t.verbose||0,this.mode=t.mode||"auto",this.baseline=t.baseline,-1===["auto","min","max"].indexOf(this.mode)&&(console.warn(`EarlyStopping mode '${this.mode}' is invalid. Falling back to mode 'auto'.`),this.mode="auto"),"min"===this.mode?this.monitorFunc=Vn:"max"===this.mode||-1!==this.monitor.indexOf("acc")?this.monitorFunc=qn:this.monitorFunc=Vn,this.monitorFunc===Vn&&(this.minDelta*=-1)}async onTrainBegin(t){this.wait=0,this.stoppedEpoch=0,null!=this.baseline?this.best=this.baseline:this.best=this.monitorFunc===Vn?1/0:-1/0}async onEpochEnd(t,e){await le(e);const s=this.getMonitorValue(e);null!=s&&(this.monitorFunc(s-this.minDelta,this.best)?(this.best=s,this.wait=0):(this.wait++,this.wait>=this.patience&&(this.stoppedEpoch=t,this.model.stopTraining=!0)))}async onTrainEnd(t){this.stoppedEpoch>0&&this.verbose&&console.log(`Epoch ${this.stoppedEpoch}: early stopping.`)}getMonitorValue(t){null==t&&(t={});const e=t[this.monitor];return null==e&&console.warn(`Metric for EarlyStopping ${this.monitor} is not available. Available metrics are: `+Object.keys(t)),e}}const Hn={earlyStopping:function(t){return new Jn(t)}};t.Callback=jn,t.CallbackList=pe,t.CustomCallback=fe,t.EarlyStopping=Jn,t.History=ge,t.InputSpec=te,t.LayerVariable=Yt,t.LayersModel=ks,t.RNN=ki,t.Sequential=Ns,t.SymbolicTensor=ee,t.callbacks=Hn,t.constraints=_,t.initializers=Ut,t.input=As,t.layers=Bn,t.loadLayersModel=function(t,e){return null==e&&(e={}),vs(t,e)},t.metrics=Wn,t.model=function(t){return new ks(t)},t.models=Un,t.registerCallbackConstructor=function(t,e){ye.registerCallbackConstructor(t,e)},t.regularizers=Pn,t.sequential=function(t){return new Ns(t)},t.version_layers="2.8.6",Object.defineProperty(t,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-layers.es2017.min.js.map
