/**
 * @license
 * Copyright 2021 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
!function(e,t){"object"==typeof exports&&"undefined"!=typeof module?t(exports):"function"==typeof define&&define.amd?define(["exports"],t):t((e=e||self).tf=e.tf||{})}(this,(function(e){"use strict";class t{decComplexRef(e){}time(e){return n("time")}read(e){return n("read")}readSync(e){return n("readSync")}numDataIds(){return n("numDataIds")}disposeData(e){return n("disposeData")}write(e,t,r){return n("write")}move(e,t,r,o){return n("move")}memory(){return n("memory")}floatPrecision(){return n("floatPrecision")}epsilon(){return 32===this.floatPrecision()?1e-7:1e-4}batchMatMul(e,t,r,o){return n("batchMatMul")}fusedBatchMatMul({a:e,b:t,transposeA:r,transposeB:o,bias:s,activation:a,preluActivationWeights:i}){return n("fusedBatchMatMul")}slice(e,t,r){return n("slice")}stridedSlice(e,t,r,o){return n("stridedSlice")}unstack(e,t){return n("unstack")}reverse(e,t){return n("reverse")}concat(e,t){return n("concat")}neg(e){return n("neg")}add(e,t){return n("add")}addN(e){return n("addN")}subtract(e,t){return n("subtract")}multiply(e,t){return n("multiply")}realDivide(e,t){return n("realDivide")}floorDiv(e,t){return n("floorDiv")}sum(e,t){return n("sum")}prod(e,t){return n("prod")}unsortedSegmentSum(e,t,r){return n("unsortedSegmentSum")}argMin(e,t){return n("argMin")}argMax(e,t){return n("argMax")}equal(e,t){return n("equal")}notEqual(e,t){return n("notEqual")}less(e,t){return n("less")}lessEqual(e,t){return n("lessEqual")}greater(e,t){return n("greater")}greaterEqual(e,t){return n("greaterEqual")}logicalNot(e){return n("logicalNot")}logicalAnd(e,t){return n("logicalAnd")}logicalOr(e,t){return n("logicalOr")}where(e){return n("where")}select(e,t,r){return n("select")}topk(e,t,r){return n("topk")}min(e,t){return n("min")}minimum(e,t){return n("minimum")}mod(e,t){return n("mod")}max(e,t){return n("max")}maximum(e,t){return n("maximum")}all(e,t){return n("all")}any(e,t){return n("any")}squaredDifference(e,t){return n("squaredDifference")}ceil(e){return n("ceil")}floor(e){return n("floor")}round(e){return n("round")}sign(e){return n("sign")}isNaN(e){return n("isNaN")}isInf(e){return n("isInf")}isFinite(e){return n("isFinite")}pow(e,t){return n("pow")}exp(e){return n("exp")}expm1(e){return n("expm1")}softmax(e,t){return n("softmax")}log(e){return n("log")}log1p(e){return n("log1p")}sqrt(e){return n("sqrt")}rsqrt(e){return n("rsqrt")}square(e){return n("square")}reciprocal(e){return n("reciprocal")}relu(e){return n("relu")}relu6(e){return n("relu6")}prelu(e,t){return n("prelu")}elu(e){return n("elu")}eluDer(e,t){return n("eluDer")}selu(e){return n("selu")}int(e){return n("int")}clip(e,t,r){return n("clip")}abs(e){return n("abs")}complexAbs(e){return n("complexAbs")}sigmoid(e){return n("sigmoid")}softplus(e){return n("softplus")}sin(e){return n("sin")}cos(e){return n("cos")}tan(e){return n("tan")}asin(e){return n("asin")}acos(e){return n("acos")}atan(e){return n("atan")}atan2(e,t){return n("atan2")}sinh(e){return n("sinh")}cosh(e){return n("cosh")}tanh(e){return n("tanh")}asinh(e){return n("asinh")}acosh(e){return n("acosh")}atanh(e){return n("atanh")}erf(e){return n("erf")}step(e,t){return n("step")}fusedConv2d({input:e,filter:t,convInfo:r,bias:o,activation:s,preluActivationWeights:a}){return n("fusedConv2d")}conv2d(e,t,r){return n("conv2d")}conv2dDerInput(e,t,r){return n("conv2dDerInput")}conv2dDerFilter(e,t,r){return n("conv2dDerFilter")}fusedDepthwiseConv2D({input:e,filter:t,convInfo:r,bias:o,activation:s,preluActivationWeights:a}){return n("fusedDepthwiseConv2D")}depthwiseConv2D(e,t,r){return n("depthwiseConv2D")}depthwiseConv2DDerInput(e,t,r){return n("depthwiseConv2DDerInput")}depthwiseConv2DDerFilter(e,t,r){return n("depthwiseConv2DDerFilter")}conv3d(e,t,r){return n("conv3d")}conv3dDerInput(e,t,r){return n("conv3dDerInput")}conv3dDerFilter(e,t,r){return n("conv3dDerFilter")}maxPool(e,t){return n("maxPool")}maxPoolBackprop(e,t,r,o){return n("maxPoolBackprop")}avgPool(e,t){return n("avgPool")}avgPoolBackprop(e,t,r){return n("avgPoolBackprop")}avgPool3d(e,t){return n("avgPool3d")}avgPool3dBackprop(e,t,r){return n("avgPool3dBackprop")}maxPool3d(e,t){return n("maxPool3d")}maxPool3dBackprop(e,t,r,o){return n("maxPool3dBackprop")}reshape(e,t){return n("reshape")}cast(e,t){return n("cast")}tile(e,t){return n("tile")}pad(e,t,r){return n("pad")}transpose(e,t){return n("transpose")}gather(e,t,r,o=0){return n("gather")}gatherND(e,t){return n("gatherND")}scatterND(e,t,r){return n("scatterND")}batchToSpaceND(e,t,r){return n("batchToSpaceND")}spaceToBatchND(e,t,r){return n("spaceToBatchND")}resizeBilinear(e,t,r,o,s){return n("resizeBilinear")}resizeBilinearBackprop(e,t,r){return n("resizeBilinearBackprop")}resizeNearestNeighbor(e,t,r,o,s){return n("resizeNearestNeighbor")}resizeNearestNeighborBackprop(e,t,r){return n("resizeNearestNeighborBackprop")}batchNorm(e,t,r,o,s,a){return n("batchNorm")}localResponseNormalization4D(e,t,r,o,s){return n("localResponseNormalization4D")}LRNGrad(e,t,r,o,s,a,i){return n("LRNGrad")}multinomial(e,t,r,o){return n("multinomial")}oneHot(e,t,r,o){return n("oneHot")}cumsum(e,t,r,o){return n("cumsum")}nonMaxSuppression(e,t,r,o,s){return n("nonMaxSuppression")}fft(e){return n("fft")}ifft(e){return n("ifft")}complex(e,t){return n("complex")}real(e){return n("real")}imag(e){return n("imag")}cropAndResize(e,t,r,o,s,a){return n("cropAndResize")}depthToSpace(e,t,r){return n("depthToSpace")}split(e,t,r){return n("split")}sparseToDense(e,t,r,o){return n("sparseToDense")}diag(e){return n("diag")}fill(e,t,r){return n("fill")}onesLike(e){return n("onesLike")}zerosLike(e){return n("zerosLike")}linspace(e,t,r){return n("linspace")}dispose(){return n("dispose")}}function n(e){throw new Error(`'${e}' not yet implemented or not found in the registry. This kernel may not be supported by the tfjs backend you have chosen`)}function r(e){let t=e.length,n=0,r=0;for(;t>0;)r=Math.random()*t|0,t--,n=e[t],e[t]=e[r],e[r]=n}function o(e,t,n){return Math.max(e,Math.min(t,n))}function s(e,t){if(!e)throw new Error("string"==typeof t?t:t())}function a(e,t,n=""){s(c(e,t),()=>n+` Shapes ${e} and ${t} must match`)}function i(e){s(null!=e,()=>"The input to the tensor constructor must be a non-null value.")}function u(e,t=[],n=!1){if(null==t&&(t=[]),Array.isArray(e)||k(e)&&!n)for(let r=0;r<e.length;++r)u(e[r],t,n);else t.push(e);return t}function l(e){if(0===e.length)return 1;let t=e[0];for(let n=1;n<e.length;n++)t*=e[n];return t}function c(e,t){if(e===t)return!0;if(null==e||null==t)return!1;if(e.length!==t.length)return!1;for(let n=0;n<e.length;n++)if(e[n]!==t[n])return!1;return!0}function h(e){return e%1==0}function d(e,t){return t<=e.length?e:e+" ".repeat(t-e.length)}function p(e,t){const n=t.length;return s((e=null==e?t.map((e,t)=>t):[].concat(e)).every(e=>e>=-n&&e<n),()=>`All values in axis param must be in range [-${n}, ${n}) but got axis `+e),s(e.every(e=>h(e)),()=>"All values in axis param must be integers but got axis "+e),e.map(e=>e<0?n+e:e)}function f(e,t){const n=[],r=[],o=null!=t&&Array.isArray(t)&&0===t.length,s=null==t||o?null:p(t,e).sort();let a=0;for(let t=0;t<e.length;++t){if(null!=s){if(s[a]===t&&1!==e[t])throw new Error(`Can't squeeze axis ${t} since its dim '${e[t]}' is not 1`);(null==s[a]||s[a]>t)&&1===e[t]&&(n.push(e[t]),r.push(t)),s[a]<=t&&a++}1!==e[t]&&(n.push(e[t]),r.push(t))}return{newShape:n,keptDims:r}}function m(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else{if("bool"!==e)throw new Error("Unknown data type "+e);n=new Uint8Array(t)}return n}function g(e,t){let n=null;if(null==e||"float32"===e)n=new Float32Array(t);else if("int32"===e)n=new Int32Array(t);else if("bool"===e)n=new Uint8Array(t);else{if("string"!==e)throw new Error("Unknown data type "+e);n=new Array(t)}return n}function b(e,t){for(let n=0;n<e.length;n++){const r=e[n];if(isNaN(r)||!isFinite(r))throw Error(`A tensor of type ${t} being uploaded contains ${r}.`)}}function y(e){return"bool"===e||"complex64"===e||"float32"===e||"int32"===e||"string"===e}function w(e,t){return"complex64"!==t&&(("float32"!==t||"complex64"===e)&&(("int32"!==t||"float32"===e||"complex64"===e)&&("bool"!==t||"bool"!==e)))}function k(e){return e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array}function v(e){if("float32"===e||"int32"===e)return 4;if("complex64"===e)return 8;if("bool"===e)return 1;throw new Error("Unknown dtype "+e)}function x(e){if(null==e)return 0;let t=0;return e.forEach(e=>t+=e.length),t}function S(e){return"string"==typeof e||e instanceof String}function E(e){return"boolean"==typeof e}function D(e){return"number"==typeof e}function I(e){return Array.isArray(e)?I(e[0]):e instanceof Float32Array?"float32":e instanceof Int32Array||e instanceof Uint8Array?"int32":D(e)?"float32":S(e)?"string":E(e)?"bool":"float32"}function N(e){return!!(e&&e.constructor&&e.call&&e.apply)}function A(e,t){for(let n=t;n<e;++n)if(e%n==0)return n;return e}function M(e){const t=e.length;if(t<2)return[];const n=new Array(t-1);n[t-2]=e[t-1];for(let r=t-3;r>=0;--r)n[r]=n[r+1]*e[r+1];return n}function T(e,t){if(0===e.length)return t[0];const n=e.reduce((e,t)=>e*t);if(0===n)return[];if(n!==t.length)throw new Error(`[${e}] does not match the input size ${t.length}.`);return function e(t,n,r){const o=new Array;if(1===n.length){const e=n[0];for(let n=0;n<e;n++)o[n]=r[t+n]}else{const s=n[0],a=n.slice(1),i=a.reduce((e,t)=>e*t);for(let n=0;n<s;n++)o[n]=e(t+n*i,a,r)}return o}(0,e,t)}function $(e,t){const n=_(e,t);for(let e=0;e<n.length;e++)n[e]=1;return n}function _(e,t){if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t)return new Uint8Array(e);throw new Error("Unknown data type "+t)}function F(e){e.forEach(t=>{s(Number.isInteger(t)&&t>=0,()=>`Tensor must have a shape comprised of positive integers but got shape [${e}].`)})}function R(e){return e&&e.then&&"function"==typeof e.then}class C{constructor(e){this.global=e,this.flags={},this.flagRegistry={},this.urlFlags={},this.populateURLFlags()}setPlatform(e,t){null!=this.platform&&console.warn(`Platform ${this.platformName} has already been set. Overwriting the platform with ${t}.`),this.platformName=e,this.platform=t}registerFlag(e,t,n){if(this.flagRegistry[e]={evaluationFn:t,setHook:n},null!=this.urlFlags[e]){const t=this.urlFlags[e];console.warn(`Setting feature override from URL ${e}: ${t}.`),this.set(e,t)}}async getAsync(e){return e in this.flags||(this.flags[e]=await this.evaluateFlag(e)),this.flags[e]}get(e){if(e in this.flags)return this.flags[e];const t=this.evaluateFlag(e);if(R(t))throw new Error(`Flag ${e} cannot be synchronously evaluated. Please use getAsync() instead.`);return this.flags[e]=t,this.flags[e]}getNumber(e){return this.get(e)}getBool(e){return this.get(e)}getFlags(){return this.flags}get features(){return this.flags}set(e,t){if(null==this.flagRegistry[e])throw new Error(`Cannot set flag ${e} as it has not been registered.`);this.flags[e]=t,null!=this.flagRegistry[e].setHook&&this.flagRegistry[e].setHook(t)}evaluateFlag(e){if(null==this.flagRegistry[e])throw new Error(`Cannot evaluate flag '${e}': no evaluation function found.`);return this.flagRegistry[e].evaluationFn()}setFlags(e){this.flags=Object.assign({},e)}reset(){this.flags={},this.urlFlags={},this.populateURLFlags()}populateURLFlags(){if(void 0===this.global||void 0===this.global.location||void 0===this.global.location.search)return;const e=function(e){const t={};return e.replace(/[?&]([^=?&]+)(?:=([^&]*))?/g,(e,...n)=>(function(e,t,n){e[decodeURIComponent(t)]=decodeURIComponent(n||"")}(t,n[0],n[1]),n.join("="))),t}(this.global.location.search);if("tfjsflags"in e){e.tfjsflags.split(",").forEach(e=>{const[t,n]=e.split(":");this.urlFlags[t]=function(e,t){if("true"===(t=t.toLowerCase())||"false"===t)return"true"===t;if(""+ +t===t)return+t;throw new Error(`Could not parse value flag value ${t} for flag ${e}.`)}(t,n)})}}}function B(){return e.ENV}let P;function z(){if(null==P){let e;if("undefined"!=typeof window)e=window;else if("undefined"!=typeof global)e=global;else if("undefined"!=typeof process)e=process;else{if("undefined"==typeof self)throw new Error("Could not find a global object");e=self}P=e}return P}function L(e,t){const n=function(){const e=z();return null==e._tfGlobals&&(e._tfGlobals=new Map),e._tfGlobals}();if(n.has(e))return n.get(e);{const r=t();return n.set(e,r),n.get(e)}}e.ENV=null;const q=L("kernelRegistry",()=>new Map),O=L("gradRegistry",()=>new Map);function G(e,t){const n=H(e,t);return q.get(n)}function K(e){return O.get(e)}function W(e){const t=q.entries(),n=[];for(;;){const{done:r,value:o}=t.next();if(r)break;const[s,a]=o,[i]=s.split("_");i===e&&n.push(a)}return n}function U(e){const{kernelName:t,backendName:n}=e,r=H(t,n);q.has(r)&&console.warn(`The kernel '${t}' for backend '${n}' is already registered`),q.set(r,e)}function V(e){const{kernelName:t}=e;O.has(t)&&B().getBool("DEBUG")&&console.warn(`Overriding the gradient for '${t}'`),O.set(t,e)}function H(e,t){return`${t}_${e}`}function j(e,t){if("string"===t)throw new Error("Cannot convert a string[] to a TypedArray");if(Array.isArray(e)&&(e=u(e)),B().getBool("DEBUG")&&b(e,t),function(e,t){return e instanceof Float32Array&&"float32"===t||e instanceof Int32Array&&"int32"===t||e instanceof Uint8Array&&"bool"===t}(e,t))return e;if(null==t||"float32"===t||"complex64"===t)return new Float32Array(e);if("int32"===t)return new Int32Array(e);if("bool"===t){const t=new Uint8Array(e.length);for(let n=0;n<t.length;++n)0!==Math.round(e[n])&&(t[n]=1);return t}throw new Error("Unknown data type "+t)}function J(){return B().platform.now()}function Y(e,t="utf-8"){return t=t||"utf-8",B().platform.encode(e,t)}function Z(e,t="utf-8"){return t=t||"utf-8",B().platform.decode(e,t)}var X=Object.freeze({__proto__:null,createScalarValue:function(e,t){return"string"===t?Y(e):j([e],t)},toTypedArray:j,now:J,fetch:function(e,t){return B().platform.fetch(e,t)},encodeString:Y,decodeString:Z,shuffle:r,clamp:o,nearestLargerEven:function(e){return e%2==0?e:e+1},sum:function(e){let t=0;for(let n=0;n<e.length;n++)t+=e[n];return t},randUniform:function(e,t){const n=Math.random();return t*n+(1-n)*e},distSquared:function(e,t){let n=0;for(let r=0;r<e.length;r++){const o=Number(e[r])-Number(t[r]);n+=o*o}return n},assert:s,assertShapesMatch:a,assertNonNull:i,flatten:u,sizeFromShape:l,isScalarShape:function(e){return 0===e.length},arraysEqual:c,isInt:h,tanh:function(e){if(null!=Math.tanh)return Math.tanh(e);if(e===1/0)return 1;if(e===-1/0)return-1;{const t=Math.exp(2*e);return(t-1)/(t+1)}},sizeToSquarishShape:function(e){const t=Math.ceil(Math.sqrt(e));return[t,Math.ceil(e/t)]},createShuffledIndices:function(e){const t=new Uint32Array(e);for(let n=0;n<e;++n)t[n]=n;return r(t),t},rightPad:d,repeatedTry:function(e,t=(e=>0),n){return new Promise((r,o)=>{let s=0;const a=()=>{if(e())return void r();s++;const i=t(s);null!=n&&s>=n?o():setTimeout(a,i)};a()})},inferFromImplicitShape:function(e,t){let n=1,r=-1;for(let t=0;t<e.length;++t)if(e[t]>=0)n*=e[t];else if(-1===e[t]){if(-1!==r)throw Error(`Shapes can only have 1 implicit size. Found -1 at dim ${r} and dim ${t}`);r=t}else if(e[t]<0)throw Error(`Shapes can not be < 0. Found ${e[t]} at dim ${t}`);if(-1===r){if(t>0&&t!==n)throw Error(`Size(${t}) must match the product of shape ${e}`);return e}if(0===n)throw Error(`Cannot infer the missing size in [${e}] when there are 0 elements`);if(t%n!=0)throw Error(`The implicit shape can't be a fractional number. Got ${t} / ${n}`);const o=e.slice();return o[r]=t/n,o},parseAxisParam:p,squeezeShape:f,getTypedArrayFromDType:m,getArrayFromDType:g,checkConversionForErrors:b,isValidDtype:y,hasEncodingLoss:w,isTypedArray:k,bytesPerElement:v,bytesFromStringArray:x,isString:S,isBoolean:E,isNumber:D,inferDtype:I,isFunction:N,nearestDivisor:A,computeStrides:M,toNestedArray:T,makeOnesTypedArray:$,makeZerosTypedArray:_,makeZerosNestedTypedArray:function(e,t){const n=e.reduce((e,t)=>e*t,1);if(null==t||"float32"===t)return T(e,new Float32Array(n));if("int32"===t)return T(e,new Int32Array(n));if("bool"===t)return T(e,new Uint8Array(n));throw new Error("Unknown data type "+t)},assertNonNegativeIntegerDimensions:F,locToIndex:function(e,t,n){if(0===t)return 0;if(1===t)return e[0];let r=e[e.length-1];for(let t=0;t<e.length-1;++t)r+=n[t]*e[t];return r},indexToLoc:function(e,t,n){if(0===t)return[];if(1===t)return[e];const r=new Array(t);for(let t=0;t<r.length-1;++t)r[t]=Math.floor(e/n[t]),e-=r[t]*n[t];return r[r.length-1]=e,r},isPromise:R});class Q{constructor(e,t){this.backendTimer=e,this.logger=t,null==t&&(this.logger=new te)}profileKernel(e,t,n){let r;const o=this.backendTimer.time(()=>{r=n()});if(B().getBool("CHECK_COMPUTATION_FOR_ERRORS"))for(let t=0;t<r.length;t++){const n=r[t];n.data().then(t=>{ee(t,n.dtype,e)})}return{kernelName:e,outputs:r,inputs:t,timeMs:o.then(e=>e.kernelMs),extraInfo:o.then(e=>null!=e.getExtraProfileInfo?e.getExtraProfileInfo():"")}}logKernelProfile(e){const{kernelName:t,outputs:n,timeMs:r,inputs:o,extraInfo:s}=e;n.forEach(e=>{Promise.all([e.data(),r,s]).then(n=>{this.logger.logKernelProfile(t,e,n[0],n[1],o,n[2])})})}}function ee(e,t,n){if("float32"!==t)return!1;for(let t=0;t<e.length;t++){const r=e[t];if(isNaN(r)||!isFinite(r))return console.warn(`Found ${r} in the result of '${n}'`),!0}return!1}class te{logKernelProfile(e,t,n,r,o,s){const a="number"==typeof r?d(r+"ms",9):r.error,i=d(e,25),u=t.rank,l=t.size,c=d(t.shape.toString(),14);let h="";for(const e in o){const n=o[e];if(null!=n){const r=n.shape||t.shape,o=r.length;h+=`${e}: ${o}D ${o>0?r:""} `}}console.log(`%c${i}\t%c${a}\t%c${u}D ${c}\t%c${l}\t%c${h}\t%c${s}`,"font-weight:bold","color:red","color:blue","color: orange","color: green","color: steelblue")}}function ne(e,t,n,r){const o=M(t),s=function(e,t,n,r){const o=l(t),s=r[r.length-1],a=new Array(s).fill(0),i=t.length,u="complex64"===n?se(e):e;if(i>1)for(let e=0;e<o/s;e++){const t=e*s;for(let e=0;e<s;e++)a[e]=Math.max(a[e],re(u[t+e],0,n).length)}return a}(e,t,n,o),a=t.length,i=function e(t,n,r,o,s,a=!0){const i="complex64"===r?2:1,u=n[0],l=n.length;if(0===l){if("complex64"===r){return[re(se(t)[0],0,r)]}return"bool"===r?[oe(t[0])]:[t[0].toString()]}if(1===l){if(u>20){const e=3*i;let n=Array.from(t.slice(0,e)),o=Array.from(t.slice((u-3)*i,u*i));return"complex64"===r&&(n=se(n),o=se(o)),["["+n.map((e,t)=>re(e,s[t],r)).join(", ")+", ..., "+o.map((e,t)=>re(e,s[u-3+t],r)).join(", ")+"]"]}return["["+("complex64"===r?se(t):Array.from(t)).map((e,t)=>re(e,s[t],r)).join(", ")+"]"]}const c=n.slice(1),h=o.slice(1),d=o[0]*i,p=[];if(u>20){for(let n=0;n<3;n++){const o=n*d,a=o+d;p.push(...e(t.slice(o,a),c,r,h,s,!1))}p.push("...");for(let n=u-3;n<u;n++){const o=n*d,a=o+d;p.push(...e(t.slice(o,a),c,r,h,s,n===u-1))}}else for(let n=0;n<u;n++){const o=n*d,a=o+d;p.push(...e(t.slice(o,a),c,r,h,s,n===u-1))}const f=2===l?",":"";p[0]="["+p[0]+f;for(let e=1;e<p.length-1;e++)p[e]=" "+p[e]+f;let m=",\n";for(let e=2;e<l;e++)m+="\n";return p[p.length-1]=" "+p[p.length-1]+"]"+(a?"":m),p}(e,t,n,o,s),u=["Tensor"];return r&&(u.push("  dtype: "+n),u.push("  rank: "+a),u.push(`  shape: [${t}]`),u.push("  values:")),u.push(i.map(e=>"    "+e).join("\n")),u.join("\n")}function re(e,t,n){let r;return r=Array.isArray(e)?parseFloat(e[0].toFixed(7))+" + "+parseFloat(e[1].toFixed(7))+"j":S(e)?`'${e}'`:"bool"===n?oe(e):parseFloat(e.toFixed(7)).toString(),d(r,t)}function oe(e){return 0===e?"false":"true"}function se(e){const t=[];for(let n=0;n<e.length;n+=2)t.push([e[n],e[n+1]]);return t}class ae{constructor(e,t,n){if(this.dtype=t,this.shape=e.slice(),this.size=l(e),null!=n){const e=n.length;s(e===this.size,()=>`Length of values '${e}' does not match the size inferred by the shape '${this.size}'.`)}if("complex64"===t)throw new Error("complex64 dtype TensorBuffers are not supported. Please create a TensorBuffer for the real and imaginary parts separately and call tf.complex(real, imag).");this.values=n||g(t,this.size),this.strides=M(e)}set(e,...t){0===t.length&&(t=[0]),s(t.length===this.rank,()=>`The number of provided coordinates (${t.length}) must match the rank (${this.rank})`);const n=this.locToIndex(t);this.values[n]=e}get(...e){0===e.length&&(e=[0]);let t=0;for(const n of e){if(n<0||n>=this.shape[t]){const t=`Requested out of range element at ${e}.   Buffer shape=`+this.shape;throw new Error(t)}t++}let n=e[e.length-1];for(let t=0;t<e.length-1;++t)n+=this.strides[t]*e[t];return this.values[n]}locToIndex(e){if(0===this.rank)return 0;if(1===this.rank)return e[0];let t=e[e.length-1];for(let n=0;n<e.length-1;++n)t+=this.strides[n]*e[n];return t}indexToLoc(e){if(0===this.rank)return[];if(1===this.rank)return[e];const t=new Array(this.shape.length);for(let n=0;n<t.length-1;++n)t[n]=Math.floor(e/this.strides[n]),e-=t[n]*this.strides[n];return t[t.length-1]=e,t}get rank(){return this.shape.length}toTensor(){return ie().makeTensor(this.values,this.shape,this.dtype)}}let ie=null,ue=null;class le{constructor(e,t,n,r){this.kept=!1,this.isDisposedInternal=!1,this.shape=e.slice(),this.dtype=t||"float32",this.size=l(e),this.strides=M(e),this.dataId=n,this.id=r,this.rankType=this.rank<5?this.rank.toString():"higher"}get rank(){return this.shape.length}async buffer(){const e=await this.data();return ue.buffer(this.shape,this.dtype,e)}bufferSync(){return ue.buffer(this.shape,this.dtype,this.dataSync())}async array(){const e=await this.data();return T(this.shape,e)}arraySync(){return T(this.shape,this.dataSync())}async data(){this.throwIfDisposed();const e=ie().read(this.dataId);if("string"===this.dtype){const t=await e;try{return t.map(e=>Z(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}}return e}dataSync(){this.throwIfDisposed();const e=ie().readSync(this.dataId);if("string"===this.dtype)try{return e.map(e=>Z(e))}catch(e){throw new Error("Failed to decode the string bytes into utf-8. To get the original bytes, call tensor.bytes().")}return e}async bytes(){this.throwIfDisposed();const e=await ie().read(this.dataId);return"string"===this.dtype?e:new Uint8Array(e.buffer)}dispose(){this.isDisposed||(ie().disposeTensor(this),this.isDisposedInternal=!0)}get isDisposed(){return this.isDisposedInternal}throwIfDisposed(){if(this.isDisposed)throw new Error("Tensor is disposed.")}print(e=!1){return ue.print(this,e)}clone(){return this.throwIfDisposed(),ue.clone(this)}toString(e=!1){return ne(this.dataSync(),this.shape,this.dtype,e)}cast(e){return this.throwIfDisposed(),ue.cast(this,e)}variable(e=!0,t,n){return this.throwIfDisposed(),ie().makeVariable(this,e,t,n)}}Object.defineProperty(le,Symbol.hasInstance,{value:e=>!!e&&null!=e.data&&null!=e.dataSync&&null!=e.throwIfDisposed});class ce extends le{constructor(e,t,n,r){super(e.shape,e.dtype,e.dataId,r),this.trainable=t,this.name=n}assign(e){if(e.dtype!==this.dtype)throw new Error(`dtype of the new value (${e.dtype}) and previous value (${this.dtype}) must match`);if(!c(e.shape,this.shape))throw new Error(`shape of the new value (${e.shape}) and previous value (${this.shape}) must match`);ie().disposeTensor(this),this.dataId=e.dataId,ie().incRef(this,null)}dispose(){ie().disposeVariable(this),this.isDisposedInternal=!0}}var he,de,pe,fe,me;Object.defineProperty(ce,Symbol.hasInstance,{value:e=>e instanceof le&&null!=e.assign&&e.assign instanceof Function}),(he=e.Rank||(e.Rank={})).R0="R0",he.R1="R1",he.R2="R2",he.R3="R3",he.R4="R4",he.R5="R5",he.R6="R6",function(e){e.float32="float32",e.int32="int32",e.bool="int32",e.complex64="complex64"}(de||(de={})),function(e){e.float32="float32",e.int32="int32",e.bool="bool",e.complex64="complex64"}(pe||(pe={})),function(e){e.float32="float32",e.int32="float32",e.bool="float32",e.complex64="complex64"}(fe||(fe={})),function(e){e.float32="complex64",e.int32="complex64",e.bool="complex64",e.complex64="complex64"}(me||(me={}));const ge={float32:fe,int32:de,bool:pe,complex64:me};function be(e,t){if("string"===e||"string"===t){if("string"===e&&"string"===t)return"string";throw new Error(`Can not upcast ${e} with ${t}`)}return ge[e][t]}function ye(e,t){if(e.dtype===t.dtype)return[e,t];const n=be(e.dtype,t.dtype);return[e.cast(n),t.cast(n)]}function we(e,t){s(e.dtype===t.dtype,()=>`The dtypes of the first(${e.dtype}) and second(${t.dtype}) input must match`)}function ke(e){const t=[];return function e(t,n,r){if(null==t)return;if(t instanceof le)return void n.push(t);if(o=t,!Array.isArray(o)&&"object"!=typeof o)return;var o;const s=t;for(const t in s){const o=s[t];r.has(o)||(r.add(o),e(o,n,r))}}(e,t,new Set),t}var ve=Object.freeze({__proto__:null,makeTypesMatch:ye,assertTypesMatch:we,isTensorInList:function(e,t){return t.some(t=>t.id===e.id)},getTensorsInContainer:ke});class xe{constructor(){this.registeredVariables={},this.nextTapeNodeId=0,this.numBytes=0,this.numTensors=0,this.numStringTensors=0,this.numDataBuffers=0,this.gradientDepth=0,this.kernelDepth=0,this.scopeStack=[],this.numDataMovesStack=[],this.nextScopeId=0,this.tensorInfo=new WeakMap,this.profiling=!1,this.activeProfile={newBytes:0,newTensors:0,peakBytes:0,kernels:[],result:null,get kernelNames(){return Array.from(new Set(this.kernels.map(e=>e.name)))}}}dispose(){for(const e in this.registeredVariables)this.registeredVariables[e].dispose()}}class Se{constructor(e){this.ENV=e,this.registry={},this.registryFactory={},this.pendingBackendInitId=0,this.state=new xe}async ready(){if(null!=this.pendingBackendInit)return this.pendingBackendInit.then(()=>{});if(null!=this.backendInstance)return;const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t];if(await this.initializeBackend(n).success)return void await this.setBackend(n)}throw new Error("Could not initialize any backends, all backend initializations failed.")}get backend(){if(null!=this.pendingBackendInit)throw new Error(`Backend '${this.backendName}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);if(null==this.backendInstance){const{name:e,asyncInit:t}=this.initializeBackendsAndReturnBest();if(t)throw new Error(`The highest priority backend '${e}' has not yet been initialized. Make sure to await tf.ready() or await tf.setBackend() before calling other methods`);this.setBackend(e)}return this.backendInstance}backendNames(){return Object.keys(this.registryFactory)}findBackend(e){if(!(e in this.registry)){if(!(e in this.registryFactory))return null;{const{asyncInit:t}=this.initializeBackend(e);if(t)return null}}return this.registry[e]}findBackendFactory(e){return e in this.registryFactory?this.registryFactory[e].factory:null}registerBackend(e,t,n=1){return e in this.registryFactory?(console.warn(e+" backend was already registered. Reusing existing backend factory."),!1):(this.registryFactory[e]={factory:t,priority:n},!0)}async setBackend(e){if(null==this.registryFactory[e])throw new Error(`Backend name '${e}' not found in registry`);if(this.backendName=e,null==this.registry[e]){this.backendInstance=null;const{success:t,asyncInit:n}=this.initializeBackend(e);if(!(n?await t:t))return!1}return this.backendInstance=this.registry[e],this.setupRegisteredKernels(),this.profiler=new Q(this.backendInstance),!0}setupRegisteredKernels(){W(this.backendName).forEach(e=>{null!=e.setupFunc&&e.setupFunc(this.backendInstance)})}disposeRegisteredKernels(e){W(e).forEach(t=>{null!=t.disposeFunc&&t.disposeFunc(this.registry[e])})}initializeBackend(e){const n=this.registryFactory[e];if(null==n)throw new Error(`Cannot initialize backend ${e}, no registration found.`);try{const r=n.factory();if(!r||r instanceof t||"function"!=typeof r.then)return this.registry[e]=r,{success:!0,asyncInit:!1};{const t=++this.pendingBackendInitId,n=r.then(n=>!(t<this.pendingBackendInitId)&&(this.registry[e]=n,this.pendingBackendInit=null,!0)).catch(n=>(t<this.pendingBackendInitId||(this.pendingBackendInit=null,console.warn(`Initialization of backend ${e} failed`),console.warn(n.stack||n.message)),!1));return this.pendingBackendInit=n,{success:n,asyncInit:!0}}}catch(t){return console.warn(`Initialization of backend ${e} failed`),console.warn(t.stack||t.message),{success:!1,asyncInit:!1}}}removeBackend(e){if(!(e in this.registryFactory))throw new Error(e+" backend not found in registry");this.backendName===e&&null!=this.pendingBackendInit&&this.pendingBackendInitId++,e in this.registry&&(this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e]),delete this.registryFactory[e],this.backendName===e&&(this.pendingBackendInit=null,this.backendName=null,this.backendInstance=null)}getSortedBackends(){if(0===Object.keys(this.registryFactory).length)throw new Error("No backend found in registry.");return Object.keys(this.registryFactory).sort((e,t)=>this.registryFactory[t].priority-this.registryFactory[e].priority)}initializeBackendsAndReturnBest(){const e=this.getSortedBackends();for(let t=0;t<e.length;t++){const n=e[t],{success:r,asyncInit:o}=this.initializeBackend(n);if(o||r)return{name:n,asyncInit:o}}throw new Error("Could not initialize any backends, all backend initializations failed.")}moveData(e,t){const n=this.state.tensorInfo.get(t),r=n.backend,o=this.readSync(t);r.disposeData(t),n.backend=e,e.move(t,o,n.shape,n.dtype),this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack[this.state.numDataMovesStack.length-1]++}tidy(e,t){let n,r=null;if(null==t){if("function"!=typeof e)throw new Error("Please provide a function to tidy()");t=e}else{if("string"!=typeof e&&!(e instanceof String))throw new Error("When calling with two arguments, the first argument to tidy() must be a string");if("function"!=typeof t)throw new Error("When calling with two arguments, the 2nd argument to tidy() must be a function");r=e}return this.scopedRun(()=>this.startScope(r),()=>this.endScope(n),()=>(n=t(),n instanceof Promise&&console.error("Cannot return a Promise inside of tidy."),n))}scopedRun(e,t,n){e();try{const e=n();return t(),e}catch(e){throw t(),e}}nextTensorId(){return Se.nextTensorId++}nextVariableId(){return Se.nextVariableId++}clone(e){const t=this.makeTensorFromDataId(e.dataId,e.shape,e.dtype),n={x:e};return this.addTapeNode(this.state.activeScope.name,n,[t],e=>({x:()=>{const t={x:e},n={dtype:"float32"};return De.runKernelFunc(t=>t.cast(e,"float32"),t,null,"Cast",n)}}),[],{}),t}runKernel(e,t,n,r,o){return this.runKernelFunc(null,t,null,e,n,r,o)}shouldCheckForMemLeaks(){return this.ENV.getBool("IS_TEST")}checkKernelForMemLeak(e,t,n){const r=this.backend.numDataIds();let o=0;n.forEach(e=>{o+="complex64"===e.dtype?3:1});const s=this.state.numDataMovesStack[this.state.numDataMovesStack.length-1],a=r-t-o-s;if(a>0)throw new Error(`Backend '${this.backendName}' has an internal memory leak (${a} data ids) after running '${e}'`)}runKernelFunc(e,t,n,r,o,s,a){let i,u=[];const l=this.isTapeOn();null==r&&(r=null!=this.state.activeScope?this.state.activeScope.name:"");const c=this.state.numBytes,h=this.state.numTensors;let d;this.shouldCheckForMemLeaks()&&this.state.numDataMovesStack.push(0),null==this.backendName&&this.backend;const p=G(r,this.backendName);let f,m;if(null!=p)d=()=>{const e=this.backend.numDataIds();f=p.kernelFunc({inputs:t,attrs:o,backend:this.backend});const n=Array.isArray(f)?f:[f];this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(r,e,n);const i=n.map(e=>{if(null!=e.rank)return e;const{dataId:t,shape:n,dtype:r}=e;return this.makeTensorFromDataId(t,n,r)});if(l){let e=this.getTensorsForGradient(r,t,i);if(null==e){null==a&&(a=[]);const t=i.filter((e,t)=>a[t]);e=(s||[]).slice().concat(t)}u=this.saveTensorsForBackwardMode(e)}return i};else{if(null==e)throw new Error(`Error running ${r}: Neither modular kernel nor forward func passed`);const t=e=>{l&&(u=e.map(e=>this.keep(this.clone(e))))};d=()=>{const n=this.backend.numDataIds();f=this.tidy(()=>e(this.backend,t));const o=Array.isArray(f)?f:[f];return this.shouldCheckForMemLeaks()&&this.checkKernelForMemLeak(r,n,o),o}}return this.scopedRun(()=>this.state.kernelDepth++,()=>this.state.kernelDepth--,()=>{this.ENV.getBool("DEBUG")||this.state.profiling?(m=this.profiler.profileKernel(r,t,()=>d()),this.ENV.getBool("DEBUG")&&this.profiler.logKernelProfile(m),i=m.outputs):i=d()}),l&&this.addTapeNode(r,t,i,n,u,o),this.state.profiling&&this.state.activeProfile.kernels.push({name:r,bytesAdded:this.state.numBytes-c,totalBytesSnapshot:this.state.numBytes,tensorsAdded:this.state.numTensors-h,totalTensorsSnapshot:this.state.numTensors,inputShapes:Object.keys(t).map(e=>null!=t[e]?t[e].shape:null),outputShapes:i.map(e=>e.shape),kernelTimeMs:m.timeMs,extraInfo:m.extraInfo}),Array.isArray(f)?i:i[0]}saveTensorsForBackwardMode(e){return e.map(e=>this.keep(this.clone(e)))}getTensorsForGradient(e,t,n){const r=K(e);if(null!=r){const e=r.inputsToSave||[],o=r.outputsToSave||[];let a;r.saveAllInputs?(s(Array.isArray(t),()=>"saveAllInputs is true, expected inputs to be an array."),a=Object.keys(t).map(e=>t[e])):a=e.map(e=>t[e]);const i=n.filter((e,t)=>o[t]);return a.concat(i)}return null}makeTensor(e,t,n,r){if(null==e)throw new Error("Values passed to engine.makeTensor() are null");n=n||"float32",r=r||this.backend;let o=e;"string"===n&&S(e[0])&&(o=e.map(e=>Y(e)));const s=r.write(o,t,n),a=new le(t,n,s,this.nextTensorId());if(this.incRef(a,r),"string"===n){const e=this.state.tensorInfo.get(s),t=x(o);this.state.numBytes+=t-e.bytes,e.bytes=t}return a}makeTensorFromDataId(e,t,n,r){const o=new le(t,n=n||"float32",e,this.nextTensorId());return this.incRef(o,r),o}makeVariable(e,t=!0,n,r){n=n||this.nextVariableId().toString(),null!=r&&r!==e.dtype&&(e=e.cast(r));const o=new ce(e,t,n,this.nextTensorId());if(null!=this.state.registeredVariables[o.name])throw new Error(`Variable with name ${o.name} was already registered`);return this.state.registeredVariables[o.name]=o,this.incRef(o,this.backend),o}incRef(e,t){const n=this.state.tensorInfo.has(e.dataId)?this.state.tensorInfo.get(e.dataId).refCount:0;if(this.state.numTensors++,"string"===e.dtype&&this.state.numStringTensors++,0===n){this.state.numDataBuffers++;let n=0;"complex64"!==e.dtype&&"string"!==e.dtype&&(n=e.size*v(e.dtype)),this.state.tensorInfo.set(e.dataId,{backend:t||this.backend,dtype:e.dtype,shape:e.shape,bytes:n,refCount:0}),this.state.numBytes+=n}this.state.tensorInfo.get(e.dataId).refCount++,e instanceof ce||this.track(e)}disposeTensor(e){if(!this.state.tensorInfo.has(e.dataId))return;this.state.numTensors--,"string"===e.dtype&&this.state.numStringTensors--;const t=this.state.tensorInfo.get(e.dataId);t.refCount<=1?("complex64"!==e.dtype&&(this.state.numBytes-=t.bytes),this.state.numDataBuffers--,t.backend.disposeData(e.dataId),this.state.tensorInfo.delete(e.dataId)):(t.backend.decComplexRef(e.dataId),this.state.tensorInfo.get(e.dataId).refCount--)}disposeVariables(){for(const e in this.state.registeredVariables){const t=this.state.registeredVariables[e];this.disposeVariable(t)}}disposeVariable(e){this.disposeTensor(e),null!=this.state.registeredVariables[e.name]&&delete this.state.registeredVariables[e.name]}memory(){const e=this.backend.memory();return e.numTensors=this.state.numTensors,e.numDataBuffers=this.state.numDataBuffers,e.numBytes=this.state.numBytes,this.state.numStringTensors>0&&(e.unreliable=!0,null==e.reasons&&(e.reasons=[]),e.reasons.push("Memory usage by string tensors is approximate (2 bytes per character)")),e}async profile(e){this.state.profiling=!0;const t=this.state.numBytes,n=this.state.numTensors;this.state.activeProfile.kernels=[],this.state.activeProfile.result=await e(),this.state.profiling=!1,this.state.activeProfile.peakBytes=Math.max(...this.state.activeProfile.kernels.map(e=>e.totalBytesSnapshot)),this.state.activeProfile.newBytes=this.state.numBytes-t,this.state.activeProfile.newTensors=this.state.numTensors-n;for(const e of this.state.activeProfile.kernels)e.kernelTimeMs=await e.kernelTimeMs,e.extraInfo=await e.extraInfo;return this.state.activeProfile}isTapeOn(){return this.state.gradientDepth>0&&0===this.state.kernelDepth}addTapeNode(e,t,n,r,o,s){const a={id:this.state.nextTapeNodeId++,kernelName:e,inputs:t,outputs:n,saved:o},i=K(e);null!=i&&(r=i.gradFunc),null!=r&&(a.gradient=e=>(e=e.map((e,t)=>{if(null==e){const e=n[t],r=_(e.size,e.dtype);return this.makeTensor(r,e.shape,e.dtype)}return e}),r(e.length>1?e:e[0],o,s))),this.state.activeTape.push(a)}keep(e){return e.kept=!0,e}startTape(){0===this.state.gradientDepth&&(this.state.activeTape=[]),this.state.gradientDepth++}endTape(){this.state.gradientDepth--}startScope(e){const t={track:[],name:"unnamed scope",id:this.state.nextScopeId++};e&&(t.name=e),this.state.scopeStack.push(t),this.state.activeScope=t}endScope(e){const t=ke(e),n=new Set(t.map(e=>e.id));for(let e=0;e<this.state.activeScope.track.length;e++){const t=this.state.activeScope.track[e];t.kept||n.has(t.id)||t.dispose()}const r=this.state.scopeStack.pop();this.state.activeScope=0===this.state.scopeStack.length?null:this.state.scopeStack[this.state.scopeStack.length-1],t.forEach(e=>{e.kept||e.scopeId!==r.id||this.track(e)})}gradients(e,t,n,r=!1){if(s(t.length>0,()=>"gradients() received an empty list of xs."),null!=n&&"float32"!==n.dtype)throw new Error(`dy must have 'float32' dtype, but has '${n.dtype}'`);const o=this.scopedRun(()=>this.startTape(),()=>this.endTape(),()=>this.tidy("forward",e));s(o instanceof le,()=>"The result y returned by f() must be a tensor.");const a=function(e,t,n){const r={},o={};for(let e=0;e<t.length;e++)r[t[e].id]=!0;for(let n=0;n<e.length;n++){const s=e[n],a=s.inputs;for(const e in a){const n=a[e];let i=!1;for(let e=0;e<t.length;e++)if(r[n.id]){s.outputs.forEach(e=>r[e.id]=!0),i=!0,o[s.id]=!0;break}if(i)break}}const s={};s[n.id]=!0;const a={};for(let t=e.length-1;t>=0;t--){const n=e[t],r=n.inputs;for(let e=0;e<n.outputs.length;e++)if(s[n.outputs[e].id]){for(const e in r)s[r[e].id]=!0,a[n.id]=!0;break}}const i=[];for(let t=0;t<e.length;t++){const n=e[t];if(o[n.id]&&a[n.id]){const e={};for(const t in n.inputs){const o=n.inputs[t];r[o.id]&&(e[t]=o)}const t=Object.assign({},n);t.inputs=e,t.outputs=n.outputs,i.push(t)}}return i}(this.state.activeTape,t,o);if(!r&&0===a.length&&t.length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that the f you passed encloses all operations that lead from x to y.");return this.tidy("backward",()=>{const e={};e[o.id]=null==n?function(e){const t=$(l(e),"float32");return De.makeTensor(t,e,"float32")}(o.shape):n,function(e,t,n,r){for(let o=t.length-1;o>=0;o--){const s=t[o],a=[];if(s.outputs.forEach(t=>{const n=e[t.id];null!=n?a.push(n):a.push(null)}),null==s.gradient)throw new Error(`Cannot compute gradient: gradient function not found for ${s.kernelName}.`);const i=s.gradient(a);for(const t in s.inputs){if(!(t in i))throw new Error(`Cannot backprop through input ${t}. Available gradients found: ${Object.keys(i)}.`);const o=n(()=>i[t]());if("float32"!==o.dtype)throw new Error(`Error in gradient for op ${s.kernelName}. The gradient of input ${t} must have 'float32' dtype, but has '${o.dtype}'`);const a=s.inputs[t];if(!c(o.shape,a.shape))throw new Error(`Error in gradient for op ${s.kernelName}. The gradient of input '${t}' has shape '${o.shape}', which does not match the shape of the input '${a.shape}'`);if(null==e[a.id])e[a.id]=o;else{const t=e[a.id];e[a.id]=r(t,o),t.dispose()}}}}(e,a,e=>this.tidy(e),Ie);const r=t.map(t=>e[t.id]);return 0===this.state.gradientDepth&&(this.state.activeTape.forEach(e=>{for(const t of e.saved)t.dispose()}),this.state.activeTape=null),{value:o,grads:r}})}customGrad(e){return s(N(e),()=>"The f passed in customGrad(f) must be a function."),(...t)=>{let n;s(t.every(e=>e instanceof le),()=>"The args passed in customGrad(f)(x1, x2,...) must all be tensors");const r={};return t.forEach((e,t)=>{r[t]=e}),this.runKernelFunc((r,o)=>(n=e(...t,o),s(n.value instanceof le,()=>"The function f passed in customGrad(f) must return an object where `obj.value` is a tensor"),s(N(n.gradFunc),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function."),n.value),r,(e,r)=>{const o=n.gradFunc(e,r),a=Array.isArray(o)?o:[o];s(a.length===t.length,()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns the same number of tensors as inputs passed to f(...)."),s(a.every(e=>e instanceof le),()=>"The function f passed in customGrad(f) must return an object where `obj.gradFunc` is a function that returns a list of only tensors.");const i={};return a.forEach((e,t)=>{i[t]=()=>e}),i})}}readSync(e){return this.state.tensorInfo.get(e).backend.readSync(e)}read(e){return this.state.tensorInfo.get(e).backend.read(e)}async time(e){const t=J(),n=await this.backend.time(e);return n.wallMs=J()-t,n}track(e){return null!=this.state.activeScope&&(e.scopeId=this.state.activeScope.id,this.state.activeScope.track.push(e)),e}get registeredVariables(){return this.state.registeredVariables}reset(){this.pendingBackendInitId++,this.state.dispose(),this.ENV.reset(),this.state=new xe;for(const e in this.registry)this.disposeRegisteredKernels(e),this.registry[e].dispose(),delete this.registry[e];this.backendName=null,this.backendInstance=null,this.pendingBackendInit=null}}function Ee(){const t=z();if(null==t._tfengine){const e=new C(t);t._tfengine=new Se(e)}var n;return n=t._tfengine.ENV,e.ENV=n,ie=()=>t._tfengine,t._tfengine}Se.nextTensorId=0,Se.nextVariableId=0;const De=Ee();function Ie(e,t){const n={a:e,b:t};return De.runKernel("Add",n)}function Ne(){return"undefined"!=typeof window&&null!=window.document||"undefined"!=typeof WorkerGlobalScope}var Ae=Object.freeze({__proto__:null,isMobile:function(){if("undefined"!=typeof navigator&&null!=navigator){const e=navigator.userAgent||navigator.vendor||window.opera;return/(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(e)||/1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(e.substr(0,4))}return!1},isBrowser:Ne});const Me=B();function Te(e,t){let n=e;if(k(e))return"string"===t?[]:[e.length];if(!Array.isArray(e))return[];const r=[];for(;Array.isArray(n)||k(n)&&"string"!==t;)r.push(n.length),n=n[0];return Array.isArray(e)&&B().getBool("TENSORLIKE_CHECK_SHAPE_CONSISTENCY")&&function e(t,n,r){if(r=r||[],!Array.isArray(t)&&!k(t))return void s(0===n.length,()=>`Element arr[${r.join("][")}] is a primitive, but should be an array/TypedArray of ${n[0]} elements`);s(n.length>0,()=>`Element arr[${r.join("][")}] should be a primitive, but is an array of ${t.length} elements`),s(t.length===n[0],()=>`Element arr[${r.join("][")}] should have ${n[0]} elements, but has ${t.length} elements`);const o=n.slice(1);for(let n=0;n<t.length;++n)e(t[n],o,r.concat(n))}(e,r,[]),r}function $e(e,t,n,r){if("string_or_numeric"!==e){if(null==e)throw new Error("Expected dtype cannot be null.");if("numeric"!==e&&e!==t||"numeric"===e&&"string"===t)throw new Error(`Argument '${n}' passed to '${r}' must be ${e} tensor, but got ${t} tensor`)}}function _e(e,t,n,r="numeric"){if(e instanceof le)return $e(r,e.dtype,t,n),e;let o=I(e);if("string"!==o&&["bool","int32","float32"].indexOf(r)>=0&&(o=r),$e(r,o,t,n),null==e||!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e){const r=null==e?"null":e.constructor.name;throw new Error(`Argument '${t}' passed to '${n}' must be a Tensor or TensorLike, but got '${r}'`)}const s=Te(e,o);k(e)||Array.isArray(e)||(e=[e]);const a="string"!==o?j(e,o):u(e,[],!0);return De.makeTensor(a,s,o)}function Fe(e,t,n,r="numeric"){if(!Array.isArray(e))throw new Error(`Argument ${t} passed to ${n} must be a \`Tensor[]\` or \`TensorLike[]\``);return e.map((e,o)=>_e(e,`${t}[${o}]`,n,r))}Me.registerFlag("DEBUG",()=>!1,e=>{e&&console.warn("Debugging mode is ON. The output of every math call will be downloaded to CPU and checked for NaNs. This significantly impacts performance.")}),Me.registerFlag("IS_BROWSER",()=>Ne()),Me.registerFlag("IS_NODE",()=>"undefined"!=typeof process&&void 0!==process.versions&&void 0!==process.versions.node),Me.registerFlag("IS_CHROME",()=>"undefined"!=typeof navigator&&null!=navigator&&null!=navigator.userAgent&&/Chrome/.test(navigator.userAgent)&&/Google Inc/.test(navigator.vendor)),Me.registerFlag("PROD",()=>!1),Me.registerFlag("TENSORLIKE_CHECK_SHAPE_CONSISTENCY",()=>Me.getBool("DEBUG")),Me.registerFlag("DEPRECATION_WARNINGS_ENABLED",()=>!0),Me.registerFlag("IS_TEST",()=>!1),Me.registerFlag("CHECK_COMPUTATION_FOR_ERRORS",()=>!0);function Re(e){const t=Object.keys(e);if(1!==t.length)throw new Error("Please provide an object with a single key (operation name) mapping to a function. Got an object with "+t.length+" keys.");let n=t[0];const r=e[n];n.endsWith("_")&&(n=n.substring(0,n.length-1)),n+="__op";const o=(...e)=>{De.startScope(n);try{const t=r(...e);return R(t)&&console.error("Cannot return a Promise inside of tidy."),De.endScope(t),t}catch(e){throw De.endScope(null),e}};return Object.defineProperty(o,"name",{value:n,configurable:!0}),o}const Ce=Re({complex_:function(e,t){const n=_e(e,"real","complex"),r=_e(t,"imag","complex");a(n.shape,r.shape,`real and imag shapes, ${n.shape} and ${r.shape}, must match in call to tf.complex().`);const o={real:n,imag:r};return De.runKernel("Complex",o)}});function Be(e,t,n,r){if(null==r&&(r=I(e)),"complex64"===r)throw new Error("Cannot construct a complex64 tensor directly. Please use tf.complex(real, imag).");if(!k(e)&&!Array.isArray(e)&&"number"!=typeof e&&"boolean"!=typeof e&&"string"!=typeof e)throw new Error("values passed to tensor(values) must be a number/boolean/string or an array of numbers/booleans/strings, or a TypedArray");if(null!=t){F(t);const e=l(t),r=l(n);s(e===r,()=>`Based on the provided shape, [${t}], the tensor should have ${e} values but has ${r}`);for(let e=0;e<n.length;++e){const r=n[e],o=e!==n.length-1||r!==l(t.slice(e));s(n[e]===t[e]||!o,()=>`Error creating a new Tensor. Inferred shape (${n}) does not match the provided shape (${t}). `)}}return k(e)||Array.isArray(e)||(e=[e]),t=t||n,e="string"!==r?j(e,r):u(e,[],!0),De.makeTensor(e,t,r)}function Pe(e,t,n){return Be(e,t,Te(e,n),n)}const ze={float32:4,float16:2,int32:4,uint16:2,uint8:1,bool:1,complex64:8};function Le(e,t){const n={};let r,o=0;for(const s of t){const t=s.name,a=s.dtype,i=s.shape,u=l(i);let c;if("quantization"in s){const n=s.quantization;if("uint8"===n.dtype||"uint16"===n.dtype){if(!("min"in n)||!("scale"in n))throw new Error(`Weight ${s.name} with quantization ${n.dtype} doesn't have corresponding metadata min and scale.`)}else{if("float16"!==n.dtype)throw new Error(`Weight ${s.name} has unknown quantization dtype ${n.dtype}. Supported quantization dtypes are: 'uint8', 'uint16', and 'float16'.`);if("float32"!==a)throw new Error(`Weight ${s.name} is quantized with ${n.dtype} which only supports weights of type float32 not ${a}.`)}const i=ze[n.dtype],l=e.slice(o,o+u*i),h="uint8"===n.dtype?new Uint8Array(l):new Uint16Array(l);if("float32"===a)if("uint8"===n.dtype||"uint16"===n.dtype){c=new Float32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];c[e]=t*n.scale+n.min}}else{if("float16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type float32.`);void 0===r&&(r=Ve()),c=r(h)}else{if("int32"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);if("uint8"!==n.dtype&&"uint16"!==n.dtype)throw new Error(`Unsupported quantization type ${n.dtype} for weight type int32.`);c=new Int32Array(h.length);for(let e=0;e<h.length;e++){const t=h[e];c[e]=Math.round(t*n.scale+n.min)}}o+=u*i}else if("string"===a){const t=l(s.shape);c=[];for(let n=0;n<t;n++){const t=new Uint32Array(e.slice(o,o+4))[0];o+=4;const n=new Uint8Array(e.slice(o,o+t));c.push(n),o+=t}}else{const r=ze[a],s=e.slice(o,o+u*r);if("float32"===a)c=new Float32Array(s);else if("int32"===a)c=new Int32Array(s);else if("bool"===a)c=new Uint8Array(s);else{if("complex64"!==a)throw new Error(`Unsupported dtype in weight '${t}': ${a}`);{c=new Float32Array(s);const e=new Float32Array(c.length/2),r=new Float32Array(c.length/2);for(let t=0;t<e.length;t++)e[t]=c[2*t],r[t]=c[2*t+1];const o=Pe(e,i,"float32"),a=Pe(r,i,"float32");n[t]=Ce(o,a),o.dispose(),a.dispose()}}o+=u*r}"complex64"!==a&&(n[t]=Pe(c,i,a))}return n}function qe(e){if(null===e)throw new Error("Invalid input value: "+JSON.stringify(e));let t=0;const n=[];e.forEach(e=>{if(t+=e.byteLength,n.push(e.byteLength===e.buffer.byteLength?e:new e.constructor(e)),!(e instanceof Float32Array||e instanceof Int32Array||e instanceof Uint8Array))throw new Error("Unsupported TypedArray subtype: "+e.constructor.name)});const r=new Uint8Array(t);let o=0;return n.forEach(e=>{r.set(new Uint8Array(e.buffer),o),o+=e.byteLength}),r.buffer}const Oe="undefined"!=typeof Buffer&&("undefined"==typeof Blob||"undefined"==typeof atob||"undefined"==typeof btoa);function Ge(e){return Oe?Buffer.byteLength(e):new Blob([e]).size}function Ke(e){if(1===e.length)return e[0];let t=0;e.forEach(e=>{t+=e.byteLength});const n=new Uint8Array(t);let r=0;return e.forEach(e=>{n.set(new Uint8Array(e),r),r+=e.byteLength}),n.buffer}function We(e){for(e=e.trim();e.endsWith("/");)e=e.slice(0,e.length-1);const t=e.split("/");return t[t.length-1]}function Ue(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("Expected JSON model topology, received ArrayBuffer.");return{dateSaved:new Date,modelTopologyType:"JSON",modelTopologyBytes:null==e.modelTopology?0:Ge(JSON.stringify(e.modelTopology)),weightSpecsBytes:null==e.weightSpecs?0:Ge(JSON.stringify(e.weightSpecs)),weightDataBytes:null==e.weightData?0:e.weightData.byteLength}}function Ve(){const e=function(){const e=e=>{let t=e<<13,n=0;for(;0==(8388608&t);)n-=8388608,t<<=1;return t&=-8388609,n+=947912704,t|n},t=new Uint32Array(2048);t[0]=0;for(let n=1;n<1024;n++)t[n]=e(n);for(let e=1024;e<2048;e++)t[e]=939524096+(e-1024<<13);return t}(),t=function(){const e=new Uint32Array(64);e[0]=0,e[31]=1199570944,e[32]=2147483648,e[63]=3347054592;for(let t=1;t<31;t++)e[t]=t<<23;for(let t=33;t<63;t++)e[t]=2147483648+(t-32<<23);return e}(),n=function(){const e=new Uint32Array(64);for(let t=0;t<64;t++)e[t]=1024;return e[0]=e[32]=0,e}();return r=>{const o=new ArrayBuffer(4*r.length),s=new Uint32Array(o);for(let o=0;o<r.length;o++){const a=r[o],i=e[n[a>>10]+(1023&a)]+t[a>>10];s[o]=i}return new Float32Array(o)}}class He{constructor(){this.saveRouters=[],this.loadRouters=[]}static getInstance(){return null==He.instance&&(He.instance=new He),He.instance}static registerSaveRouter(e){He.getInstance().saveRouters.push(e)}static registerLoadRouter(e){He.getInstance().loadRouters.push(e)}static getSaveHandlers(e){return He.getHandlers(e,"save")}static getLoadHandlers(e,t){return He.getHandlers(e,"load",t)}static getHandlers(e,t,n){const r=[];return("load"===t?He.getInstance().loadRouters:He.getInstance().saveRouters).forEach(t=>{const o=t(e,n);null!==o&&r.push(o)}),r}}function je(){if(!B().getBool("IS_BROWSER"))throw new Error("Failed to obtain IndexedDB factory because the current environmentis not a web browser.");const e="undefined"==typeof window?self:window,t=e.indexedDB||e.mozIndexedDB||e.webkitIndexedDB||e.msIndexedDB||e.shimIndexedDB;if(null==t)throw new Error("The current browser does not appear to support IndexedDB.");return t}function Je(e){const t=e.result;t.createObjectStore("models_store",{keyPath:"modelPath"}),t.createObjectStore("model_info_store",{keyPath:"modelPath"})}class Ye{constructor(e){if(this.indexedDB=je(),null==e||!e)throw new Error("For IndexedDB, modelPath must not be null, undefined or empty.");this.modelPath=e}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");return this.databaseAction(this.modelPath,e)}async load(){return this.databaseAction(this.modelPath)}databaseAction(e,t){return new Promise((e,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>Je(r),r.onsuccess=()=>{const o=r.result;if(null==t){const t=o.transaction("models_store","readonly"),r=t.objectStore("models_store").get(this.modelPath);r.onsuccess=()=>{if(null==r.result)return o.close(),n(new Error(`Cannot find model with path '${this.modelPath}' in IndexedDB.`));e(r.result.modelArtifacts)},r.onerror=e=>(o.close(),n(r.error)),t.oncomplete=()=>o.close()}else{const r=Ue(t),s=o.transaction("model_info_store","readwrite");let a=s.objectStore("model_info_store");const i=a.put({modelPath:this.modelPath,modelArtifactsInfo:r});let u;i.onsuccess=()=>{u=o.transaction("models_store","readwrite");const i=u.objectStore("models_store").put({modelPath:this.modelPath,modelArtifacts:t,modelArtifactsInfo:r});i.onsuccess=()=>e({modelArtifactsInfo:r}),i.onerror=e=>{a=s.objectStore("model_info_store");const t=a.delete(this.modelPath);t.onsuccess=()=>(o.close(),n(i.error)),t.onerror=e=>(o.close(),n(i.error))}},i.onerror=e=>(o.close(),n(i.error)),s.oncomplete=()=>{null==u?o.close():u.oncomplete=()=>o.close()}}},r.onerror=e=>n(r.error)})}}Ye.URL_SCHEME="indexeddb://";const Ze=e=>{return B().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(Ye.URL_SCHEME)?(t=e.slice(Ye.URL_SCHEME.length),new Ye(t)):null;var t};He.registerSaveRouter(Ze),He.registerLoadRouter(Ze);class Xe{constructor(){this.indexedDB=je()}async listModels(){return new Promise((e,t)=>{const n=this.indexedDB.open("tensorflowjs",1);n.onupgradeneeded=()=>Je(n),n.onsuccess=()=>{const r=n.result,o=r.transaction("model_info_store","readonly"),s=o.objectStore("model_info_store").getAll();s.onsuccess=()=>{const t={};for(const e of s.result)t[e.modelPath]=e.modelArtifactsInfo;e(t)},s.onerror=e=>(r.close(),t(s.error)),o.oncomplete=()=>r.close()},n.onerror=e=>t(n.error)})}async removeModel(e){var t;return e=(t=e).startsWith(Ye.URL_SCHEME)?t.slice(Ye.URL_SCHEME.length):t,new Promise((t,n)=>{const r=this.indexedDB.open("tensorflowjs",1);r.onupgradeneeded=()=>Je(r),r.onsuccess=()=>{const o=r.result,s=o.transaction("model_info_store","readwrite"),a=s.objectStore("model_info_store"),i=a.get(e);let u;i.onsuccess=()=>{if(null==i.result)return o.close(),n(new Error(`Cannot find model with path '${e}' in IndexedDB.`));{const r=a.delete(e),s=()=>{u=o.transaction("models_store","readwrite");const r=u.objectStore("models_store").delete(e);r.onsuccess=()=>t(i.result.modelArtifactsInfo),r.onerror=e=>n(i.error)};r.onsuccess=s,r.onerror=e=>(s(),o.close(),n(i.error))}},i.onerror=e=>(o.close(),n(i.error)),s.oncomplete=()=>{null==u?o.close():u.oncomplete=()=>o.close()}},r.onerror=e=>n(r.error)})}}const Qe="tensorflowjs_models",et="info",tt="model_topology",nt="weight_specs",rt="weight_data",ot="model_metadata";function st(e){return{info:[Qe,e,et].join("/"),topology:[Qe,e,tt].join("/"),weightSpecs:[Qe,e,nt].join("/"),weightData:[Qe,e,rt].join("/"),modelMetadata:[Qe,e,ot].join("/")}}function at(e){const t=e.split("/");if(t.length<3)throw new Error("Invalid key format: "+e);return t.slice(1,t.length-1).join("/")}class it{constructor(e){if(!B().getBool("IS_BROWSER")||"undefined"==typeof window||void 0===window.localStorage)throw new Error("The current environment does not support local storage.");if(this.LS=window.localStorage,null==e||!e)throw new Error("For local storage, modelPath must not be null, undefined or empty.");this.modelPath=e,this.keys=st(this.modelPath)}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserLocalStorage.save() does not support saving model topology in binary formats yet.");{const t=JSON.stringify(e.modelTopology),n=JSON.stringify(e.weightSpecs),r=Ue(e);try{this.LS.setItem(this.keys.info,JSON.stringify(r)),this.LS.setItem(this.keys.topology,t),this.LS.setItem(this.keys.weightSpecs,n),this.LS.setItem(this.keys.weightData,function(e){if(Oe)return Buffer.from(e).toString("base64");const t=new Uint8Array(e);let n="";for(let e=0,r=t.length;e<r;e++)n+=String.fromCharCode(t[e]);return btoa(n)}(e.weightData));const o={format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy};return null!=e.signature&&(o.signature=e.signature),null!=e.userDefinedMetadata&&(o.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(o.modelInitializer=e.modelInitializer),this.LS.setItem(this.keys.modelMetadata,JSON.stringify(o)),{modelArtifactsInfo:r}}catch(e){throw this.LS.removeItem(this.keys.info),this.LS.removeItem(this.keys.topology),this.LS.removeItem(this.keys.weightSpecs),this.LS.removeItem(this.keys.weightData),this.LS.removeItem(this.keys.modelMetadata),new Error(`Failed to save model '${this.modelPath}' to local storage: size quota being exceeded is a possible cause of this failure: modelTopologyBytes=${r.modelTopologyBytes}, weightSpecsBytes=${r.weightSpecsBytes}, weightDataBytes=${r.weightDataBytes}.`)}}}async load(){const e=JSON.parse(this.LS.getItem(this.keys.info));if(null==e)throw new Error(`In local storage, there is no model with name '${this.modelPath}'`);if("JSON"!==e.modelTopologyType)throw new Error("BrowserLocalStorage does not support loading non-JSON model topology yet.");const t={},n=JSON.parse(this.LS.getItem(this.keys.topology));if(null==n)throw new Error(`In local storage, the topology of model '${this.modelPath}' is missing.`);t.modelTopology=n;const r=JSON.parse(this.LS.getItem(this.keys.weightSpecs));if(null==r)throw new Error(`In local storage, the weight specs of model '${this.modelPath}' are missing.`);t.weightSpecs=r;const o=this.LS.getItem(this.keys.modelMetadata);if(null!=o){const e=JSON.parse(o);t.format=e.format,t.generatedBy=e.generatedBy,t.convertedBy=e.convertedBy,null!=e.signature&&(t.signature=e.signature),null!=e.userDefinedMetadata&&(t.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(t.modelInitializer=e.modelInitializer)}const s=this.LS.getItem(this.keys.weightData);if(null==s)throw new Error(`In local storage, the binary weight values of model '${this.modelPath}' are missing.`);return t.weightData=function(e){if(Oe){const t=Buffer.from(e,"base64");return t.buffer.slice(t.byteOffset,t.byteOffset+t.byteLength)}const t=atob(e),n=new Uint8Array(t.length);for(let e=0;e<t.length;++e)n.set([t.charCodeAt(e)],e);return n.buffer}(s),t}}it.URL_SCHEME="localstorage://";const ut=e=>{return B().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(it.URL_SCHEME)?(t=e.slice(it.URL_SCHEME.length),new it(t)):null;var t};He.registerSaveRouter(ut),He.registerLoadRouter(ut);class lt{constructor(){s(B().getBool("IS_BROWSER"),()=>"Current environment is not a web browser"),s("undefined"==typeof window||void 0!==window.localStorage,()=>"Current browser does not appear to support localStorage"),this.LS=window.localStorage}async listModels(){const e={},t=Qe+"/",n="/"+et;for(let r=0;r<this.LS.length;++r){const o=this.LS.key(r);if(o.startsWith(t)&&o.endsWith(n)){e[at(o)]=JSON.parse(this.LS.getItem(o))}}return e}async removeModel(e){var t;const n=st(e=(t=e).startsWith(it.URL_SCHEME)?t.slice(it.URL_SCHEME.length):t);if(null==this.LS.getItem(n.info))throw new Error(`Cannot find model at path '${e}'`);const r=JSON.parse(this.LS.getItem(n.info));return this.LS.removeItem(n.info),this.LS.removeItem(n.topology),this.LS.removeItem(n.weightSpecs),this.LS.removeItem(n.weightData),r}}class ct{constructor(){this.managers={}}static getInstance(){return null==ct.instance&&(ct.instance=new ct),ct.instance}static registerManager(e,t){s(null!=e,()=>"scheme must not be undefined or null."),e.endsWith("://")&&(e=e.slice(0,e.indexOf("://"))),s(e.length>0,()=>"scheme must not be an empty string.");const n=ct.getInstance();s(null==n.managers[e],()=>`A model store manager is already registered for scheme '${e}'.`),n.managers[e]=t}static getManager(e){const t=this.getInstance().managers[e];if(null==t)throw new Error(`Cannot find model manager for scheme '${e}'`);return t}static getSchemes(){return Object.keys(this.getInstance().managers)}}function ht(e){if(-1===e.indexOf("://"))throw new Error("The url string provided does not contain a scheme. Supported schemes are: "+ct.getSchemes().join(","));return{scheme:e.split("://")[0],path:e.split("://")[1]}}async function dt(e,t,n=!1){s(e!==t,()=>`Old path and new path are the same: '${e}'`);const r=He.getLoadHandlers(e);s(r.length>0,()=>`Copying failed because no load handler is found for source URL ${e}.`),s(r.length<2,()=>`Copying failed because more than one (${r.length}) load handlers for source URL ${e}.`);const o=r[0],a=He.getSaveHandlers(t);s(a.length>0,()=>`Copying failed because no save handler is found for destination URL ${t}.`),s(a.length<2,()=>`Copying failed because more than one (${r.length}) save handlers for destination URL ${t}.`);const i=a[0],u=ht(e).scheme,l=ht(e).path,c=u===ht(e).scheme,h=await o.load();n&&c&&await ct.getManager(u).removeModel(l);const d=await i.save(h);return n&&!c&&await ct.getManager(u).removeModel(l),d.modelArtifactsInfo}class pt{fetch(e,t){return fetch(e,t)}now(){return performance.now()}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Browser's encoder only supports utf-8, but got "+t);return null==this.textEncoder&&(this.textEncoder=new TextEncoder),this.textEncoder.encode(e)}decode(e,t){return new TextDecoder(t).decode(e)}}if(B().get("IS_BROWSER")){B().setPlatform("browser",new pt);try{ct.registerManager(it.URL_SCHEME,new lt)}catch(e){}try{ct.registerManager(Ye.URL_SCHEME,new Xe)}catch(e){}}const ft=()=>require("node-fetch");let mt;class gt{constructor(){this.util=require("util"),this.textEncoder=new this.util.TextEncoder}fetch(e,t){return null!=B().global.fetch?B().global.fetch(e,t):(null==mt&&(mt=ft()),mt(e,t))}now(){const e=process.hrtime();return 1e3*e[0]+e[1]/1e6}encode(e,t){if("utf-8"!==t&&"utf8"!==t)throw new Error("Node built-in encoder only supports utf-8, but got "+t);return this.textEncoder.encode(e)}decode(e,t){return 0===e.length?"":new this.util.TextDecoder(t).decode(e)}}function bt(e,t="float32",n){return t=t||"float32",F(e),new ae(e,t,n)}B().get("IS_NODE")&&B().setPlatform("node",new gt);const yt=Re({cast_:function(e,t){const n=_e(e,"x","cast");if(!y(t))throw new Error("Failed to cast to unknown dtype "+t);if("string"===t&&"string"!==n.dtype||"string"!==t&&"string"===n.dtype)throw new Error("Only strings can be casted to strings");const r={x:n},o={dtype:t};return De.runKernel("Cast",r,o)}});const wt=Re({clone_:function(e){const t={x:_e(e,"x","clone","string_or_numeric")};return De.runKernel("Identity",t)}});function kt(e,t=!1){console.log(e.toString(t))}Ee(),ue={buffer:bt,cast:yt,clone:wt,print:kt};function vt(e){return new Promise(e=>setTimeout(e)).then(e)}class xt{constructor(e){if(!B().getBool("IS_BROWSER"))throw new Error("browserDownloads() cannot proceed because the current environment is not a browser.");e.startsWith(xt.URL_SCHEME)&&(e=e.slice(xt.URL_SCHEME.length)),null!=e&&0!==e.length||(e="model"),this.modelTopologyFileName=e+".json",this.weightDataFileName=e+".weights.bin"}async save(e){if("undefined"==typeof document)throw new Error("Browser downloads are not supported in this environment since `document` is not present");const t=window.URL.createObjectURL(new Blob([e.weightData],{type:"application/octet-stream"}));if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserDownloads.save() does not support saving model topology in binary formats yet.");{const n=[{paths:["./"+this.weightDataFileName],weights:e.weightSpecs}],r={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(r.signature=e.signature),null!=e.userDefinedMetadata&&(r.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(r.modelInitializer=e.modelInitializer);const o=window.URL.createObjectURL(new Blob([JSON.stringify(r)],{type:"application/json"})),s=null==this.jsonAnchor?document.createElement("a"):this.jsonAnchor;if(s.download=this.modelTopologyFileName,s.href=o,await vt(()=>s.dispatchEvent(new MouseEvent("click"))),null!=e.weightData){const e=null==this.weightDataAnchor?document.createElement("a"):this.weightDataAnchor;e.download=this.weightDataFileName,e.href=t,await vt(()=>e.dispatchEvent(new MouseEvent("click")))}return{modelArtifactsInfo:Ue(e)}}}}xt.URL_SCHEME="downloads://";class St{constructor(e){if(null==e||e.length<1)throw new Error("When calling browserFiles, at least 1 file is required, but received "+e);this.files=e}async load(){const e=this.files[0],t=this.files.slice(1);return new Promise((n,r)=>{const o=new FileReader;o.onload=o=>{const s=JSON.parse(o.target.result),a=s.modelTopology;if(null==a)return void r(new Error("modelTopology field is missing from file "+e.name));0===t.length&&n({modelTopology:a});const i=s.weightsManifest;if(null==i)return void r(new Error("weightManifest field is missing from file "+e.name));let u;try{u=this.checkManifestAndWeightFiles(i,t)}catch(e){return void r(e)}const l=[],c=[],h=[];i.forEach(e=>{e.paths.forEach(e=>{c.push(e),h.push(null)}),l.push(...e.weights)}),i.forEach(e=>{e.paths.forEach(e=>{const t=new FileReader;t.onload=t=>{const r=t.target.result,o=c.indexOf(e);if(h[o]=r,-1===h.indexOf(null)){const e={modelTopology:a,weightSpecs:l,weightData:Ke(h),format:s.format,generatedBy:s.generatedBy,convertedBy:s.convertedBy};null!=s.signature&&(e.signature=s.signature),null!=s.userDefinedMetadata&&(e.userDefinedMetadata=s.userDefinedMetadata),null!=s.modelInitializer&&(e.modelInitializer=s.modelInitializer),n(e)}},t.onerror=t=>r(`Failed to weights data from file of path '${e}'.`),t.readAsArrayBuffer(u[e])})})},o.onerror=t=>r(`Failed to read model topology and weights manifest JSON from file '${e.name}'. BrowserFiles supports loading Keras-style tf.Model artifacts only.`),o.readAsText(e)})}checkManifestAndWeightFiles(e,t){const n=[],r=t.map(e=>We(e.name)),o={};for(const s of e)s.paths.forEach(e=>{const s=We(e);if(-1!==n.indexOf(s))throw new Error(`Duplicate file basename found in weights manifest: '${s}'`);if(n.push(s),-1===r.indexOf(s))throw new Error(`Weight file with basename '${s}' is not provided.`);o[e]=t[r.indexOf(s)]});if(n.length!==t.length)throw new Error(`Mismatch in the number of files in weights manifest (${n.length}) and the number of weight files provided (${t.length}).`);return o}}function Et(e,t,n,r){!function(e){s(null!=e&&Array.isArray(e)&&e.length>0,()=>"promises must be a none empty array")}(e),function(e,t){s(e>=0&&e<=1,()=>"Progress fraction must be in range [0, 1], but got startFraction "+e),s(t>=0&&t<=1,()=>"Progress fraction must be in range [0, 1], but got endFraction "+t),s(t>=e,()=>`startFraction must be no more than endFraction, but got startFraction ${e} and endFraction `+t)}(n=null==n?0:n,r=null==r?1:r);let o=0;return Promise.all(e.map(s=>(s.then(s=>{const a=n+ ++o/e.length*(r-n);return t(a),s}),s)))}async function Dt(e,t){null==t&&(t={});const n=null==t.fetchFunc?B().platform.fetch:t.fetchFunc,r=e.map(e=>n(e,t.requestInit,{isBinary:!0})),o=(null==t.onProgress?await Promise.all(r):await Et(r,t.onProgress,0,.5)).map(e=>e.arrayBuffer());return null==t.onProgress?await Promise.all(o):await Et(o,t.onProgress,.5,1)}function It(e){return async(t,n="",r)=>{const o=t.map(()=>!1),s={},a=null!=r?r.map(()=>!1):[],i=[];if(t.forEach((e,t)=>{let n=0;e.weights.forEach(e=>{const u="quantization"in e?e.quantization.dtype:e.dtype,c=ze[u]*l(e.shape),h=()=>{o[t]=!0,null==s[t]&&(s[t]=[]),s[t].push({manifestEntry:e,groupOffset:n,sizeBytes:c})};null!=r?r.forEach((t,n)=>{t===e.name&&(h(),a[n]=!0)}):h(),i.push(e.name),n+=c})}),!a.every(e=>e)){const e=r.filter((e,t)=>!a[t]);throw new Error("Could not find weights in manifest with names: "+e.join(", ")+". \nManifest JSON has weights with names: "+i.join(", ")+".")}const u=o.reduce((e,t,n)=>(t&&e.push(n),e),[]),c=[];u.forEach(e=>{t[e].paths.forEach(e=>{const t=n+(n.endsWith("/")?"":"/")+e;c.push(t)})});const h=await e(c),d={};let p=0;return u.forEach(e=>{const n=t[e].paths.length;let r=0;for(let e=0;e<n;e++)r+=h[p+e].byteLength;const o=new ArrayBuffer(r),a=new Uint8Array(o);let i=0;for(let e=0;e<n;e++){const t=new Uint8Array(h[p+e]);a.set(t,i),i+=t.byteLength}s[e].forEach(e=>{const t=Le(o.slice(e.groupOffset,e.groupOffset+e.sizeBytes),[e.manifestEntry]);for(const e in t)d[e]=t[e]}),p+=n}),d}}He.registerSaveRouter(e=>B().getBool("IS_BROWSER")&&!Array.isArray(e)&&e.startsWith(xt.URL_SCHEME)?function(e="model"){return new xt(e)}(e.slice(xt.URL_SCHEME.length)):null);class Nt{constructor(e,t){if(this.DEFAULT_METHOD="POST",null==t&&(t={}),this.weightPathPrefix=t.weightPathPrefix,this.onProgress=t.onProgress,this.weightUrlConverter=t.weightUrlConverter,null!=t.fetchFunc?(s("function"==typeof t.fetchFunc,()=>"Must pass a function that matches the signature of `fetch` (see https://developer.mozilla.org/en-US/docs/Web/API/Fetch_API)"),this.fetch=t.fetchFunc):this.fetch=B().platform.fetch,s(null!=e&&e.length>0,()=>"URL path for http must not be null, undefined or empty."),Array.isArray(e)&&s(2===e.length,()=>`URL paths for http must have a length of 2, (actual length is ${e.length}).`),this.path=e,null!=t.requestInit&&null!=t.requestInit.body)throw new Error("requestInit is expected to have no pre-existing body, but has one.");this.requestInit=t.requestInit||{}}async save(e){if(e.modelTopology instanceof ArrayBuffer)throw new Error("BrowserHTTPRequest.save() does not support saving model topology in binary formats yet.");const t=Object.assign({method:this.DEFAULT_METHOD},this.requestInit);t.body=new FormData;const n=[{paths:["./model.weights.bin"],weights:e.weightSpecs}],r={modelTopology:e.modelTopology,format:e.format,generatedBy:e.generatedBy,convertedBy:e.convertedBy,weightsManifest:n};null!=e.signature&&(r.signature=e.signature),null!=e.userDefinedMetadata&&(r.userDefinedMetadata=e.userDefinedMetadata),null!=e.modelInitializer&&(r.modelInitializer=e.modelInitializer),t.body.append("model.json",new Blob([JSON.stringify(r)],{type:"application/json"}),"model.json"),null!=e.weightData&&t.body.append("model.weights.bin",new Blob([e.weightData],{type:"application/octet-stream"}),"model.weights.bin");const o=await this.fetch(this.path,t);if(o.ok)return{modelArtifactsInfo:Ue(e),responses:[o]};throw new Error("BrowserHTTPRequest.save() failed due to HTTP response status "+o.status+".")}async load(){const e=await this.fetch(this.path,this.requestInit);if(!e.ok)throw new Error(`Request to ${this.path} failed with status code `+e.status+". Please verify this URL points to the model JSON of the model to load.");let t;try{t=await e.json()}catch(e){let t=`Failed to parse model JSON of response from ${this.path}.`;throw this.path.endsWith(".pb")?t+=" Your path contains a .pb file extension. Support for .pb models have been removed in TensorFlow.js 1.0 in favor of .json models. You can re-convert your Python TensorFlow model using the TensorFlow.js 1.0 conversion scripts or you can convert your.pb models with the 'pb2json'NPM script in the tensorflow/tfjs-converter repository.":t+=" Please make sure the server is serving valid JSON for this request.",new Error(t)}const n=t.modelTopology,r=t.weightsManifest,o=t.generatedBy,s=t.convertedBy,a=t.format,i=t.signature,u=t.userDefinedMetadata;if(null==n&&null==r)throw new Error(`The JSON from HTTP path ${this.path} contains neither model topology or manifest for weights.`);let l,c;if(null!=r){const e=await this.loadWeights(r);[l,c]=e}const h={modelTopology:n,weightSpecs:l,weightData:c,generatedBy:o,convertedBy:s,format:a};null!=i&&(h.signature=i),null!=u&&(h.userDefinedMetadata=u);const d=t.modelInitializer;return d&&(h.modelInitializer=d),h}async loadWeights(e){const t=Array.isArray(this.path)?this.path[1]:this.path,[n,r]=function(e){const t=e.lastIndexOf("/"),n=e.lastIndexOf("?"),r=e.substring(0,t),o=n>t?e.substring(n):"";return[r+"/",o]}(t),o=this.weightPathPrefix||n,s=[];for(const t of e)s.push(...t.weights);const a=[],i=[];for(const t of e)for(const e of t.paths)null!=this.weightUrlConverter?i.push(this.weightUrlConverter(e)):a.push(o+e+r);return this.weightUrlConverter&&a.push(...await Promise.all(i)),[s,Ke(await Dt(a,{requestInit:this.requestInit,fetchFunc:this.fetch,onProgress:this.onProgress}))]}}function At(e){return null!=e.match(Nt.URL_SCHEME_REGEX)}Nt.URL_SCHEME_REGEX=/^https?:\/\//;const Mt=(e,t)=>{if("undefined"==typeof fetch&&(null==t||null==t.fetchFunc))return null;{let n=!0;if(n=Array.isArray(e)?e.every(e=>At(e)):At(e),n)return Tt(e,t)}return null};function Tt(e,t){return new Nt(e,t)}He.registerSaveRouter(Mt),He.registerLoadRouter(Mt);class $t{constructor(e){this.modelArtifacts=e}async load(){return this.modelArtifacts}}class _t{constructor(e){this.saveHandler=e}async save(e){return this.saveHandler(e)}}var Ft=Object.freeze({__proto__:null,browserFiles:function(e){return new St(e)},browserHTTPRequest:function(e,t){return Tt(e,t)},concatenateArrayBuffers:Ke,decodeWeights:Le,encodeWeights:async function(e,t){const n=[],r=[],o=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);for(let s=0;s<o.length;++s){const a=o[s],i=Array.isArray(e)?e[s].tensor:e[a];if("float32"!==i.dtype&&"int32"!==i.dtype&&"bool"!==i.dtype&&"string"!==i.dtype&&"complex64"!==i.dtype)throw new Error(`Unsupported dtype in weight '${a}': ${i.dtype}`);const u={name:a,shape:i.shape,dtype:i.dtype};if("string"===i.dtype){const e=new Promise(async e=>{const t=await i.bytes(),n=t.reduce((e,t)=>e+t.length,0)+4*t.length,r=new Uint8Array(n);let o=0;for(let e=0;e<t.length;e++){const n=t[e],s=new Uint8Array(new Uint32Array([n.length]).buffer);r.set(s,o),o+=4,r.set(n,o),o+=n.length}e(r)});r.push(e)}else r.push(i.data());null!=t&&(u.group=t),n.push(u)}return{data:qe(await Promise.all(r)),specs:n}},fromMemory:function(e,t,n,r){if(1===arguments.length){return null!=e.modelTopology||null!=e.weightSpecs?new $t(e):(console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new $t({modelTopology:e}))}return console.warn("Please call tf.io.fromMemory() with only one argument. The argument should be of type ModelArtifacts. The multi-argument signature of tf.io.fromMemory() has been deprecated and will be removed in a future release."),new $t({modelTopology:e,weightSpecs:t,weightData:n,trainingConfig:r})},getLoadHandlers:(e,t)=>He.getLoadHandlers(e,t),getModelArtifactsInfoForJSON:Ue,getSaveHandlers:e=>He.getSaveHandlers(e),http:Tt,isHTTPScheme:At,loadWeights:async function(e,t="",n,r){return It(e=>Dt(e,{requestInit:r}))(e,t,n)},registerLoadRouter:e=>He.registerLoadRouter(e),registerSaveRouter:e=>He.registerSaveRouter(e),weightsLoaderFactory:It,withSaveHandler:function(e){return new _t(e)},copyModel:async function(e,t){return dt(e,t,!1)},listModels:async function(){const e=ct.getSchemes(),t={};for(const n of e){const e=await ct.getManager(n).listModels();for(const r in e){t[n+"://"+r]=e[r]}}return t},moveModel:async function(e,t){return dt(e,t,!0)},removeModel:async function(e){const t=ht(e);return ct.getManager(t.scheme).removeModel(t.path)}});const Rt=Re({matMul_:function(e,t,n=!1,r=!1){let o=_e(e,"a","matMul"),s=_e(t,"b","matMul");[o,s]=ye(o,s);const a={a:o,b:s},i={transposeA:n,transposeB:r};return De.runKernel("BatchMatMul",a,i)}});const Ct=Re({oneHot_:function(e,t,n=1,r=0){if(t<2)throw new Error("Error in oneHot: depth must be >=2, but it is "+t);const o={indices:_e(e,"indices","oneHot","int32")},s={depth:t,onValue:n,offValue:r};return De.runKernel("OneHot",o,s)}});const Bt=Re({transpose_:function(e,t){const n=_e(e,"x","transpose");if(null==t&&(t=n.shape.map((e,t)=>t).reverse()),s(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of perm ${t}.`),t.forEach(e=>{s(e>=0&&e<n.rank,()=>"All entries in 'perm' must be between 0 and "+(n.rank-1)+" but got "+t)}),n.rank<=1)return n.clone();const r={x:n},o={perm:t};return De.runKernel("Transpose",r,o)}});const Pt=Re({confusionMatrix_:function(e,t,n){const r=_e(e,"labels","confusionMatrix"),o=_e(t,"predictions","confusionMatrix");s(null==n||n>0&&Number.isInteger(n),()=>"If provided, numClasses must be a positive integer, but got "+n),s(1===r.rank,()=>"Expected the rank of labels to be 1, but got "+r.rank),s(1===o.rank,()=>"Expected the rank of predictions to be 1, but got "+o.rank),s(r.shape[0]===o.shape[0],()=>`Mismatch in the number of examples: ${r.shape[0]} vs. ${o.shape[0]}. Labels and predictions should have the same number of elements.`),s(n>0&&Number.isInteger(n),()=>"numClasses is required to be a positive integer, but got "+n);const a=Ct(yt(r,"int32"),n),i=Ct(yt(o,"int32"),n),u=Bt(a),l=Rt(u,i);return yt(l,"int32")}});var zt=Object.freeze({__proto__:null,confusionMatrix:Pt});function Lt(e,t,n){if(i(e),null!=t&&3!==t.length)throw new Error("tensor3d() requires shape to have three numbers");const r=Te(e,n);if(3!==r.length&&1!==r.length)throw new Error("tensor3d() requires values to be number[][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor3d() requires shape to be provided when `values` are a flat array");return Be(e,t,r,n)}let qt;const Ot=Re({fromPixels_:function(e,t=3){if(t>4)throw new Error("Cannot construct Tensor with more than 4 channels from pixels.");if(null==e)throw new Error("pixels passed to tf.browser.fromPixels() can not be null");let n=!1,r=!1,o=!1,s=!1,a=!1,i=!1;if(e.data instanceof Uint8Array)n=!0;else if("undefined"!=typeof ImageData&&e instanceof ImageData)r=!0;else if("undefined"!=typeof HTMLVideoElement&&e instanceof HTMLVideoElement)o=!0;else if("undefined"!=typeof HTMLImageElement&&e instanceof HTMLImageElement)s=!0;else if(null!=e.getContext)a=!0;else{if(!("undefined"!=typeof ImageBitmap&&e instanceof ImageBitmap))throw new Error("pixels passed to tf.browser.fromPixels() must be either an HTMLVideoElement, HTMLImageElement, HTMLCanvasElement, ImageData in browser, or OffscreenCanvas, ImageData in webworker or {data: Uint32Array, width: number, height: number}, but was "+e.constructor.name);i=!0}if(o){const t=2;if(o&&e.readyState<t)throw new Error("The video element has not loaded data yet. Please wait for `loadeddata` event on the <video> element.")}if(null!=G("FromPixels",De.backendName)){const n={pixels:e},r={numChannels:t};return De.runKernel("FromPixels",n,r)}const[u,l]=o?[e.videoWidth,e.videoHeight]:[e.width,e.height];let c,h;if(a?c=e.getContext("2d").getImageData(0,0,u,l).data:r||n?c=e.data:(s||o||i)&&(null==qt&&(qt=document.createElement("canvas").getContext("2d")),qt.canvas.width=u,qt.canvas.height=l,qt.drawImage(e,0,0,u,l),c=qt.getImageData(0,0,u,l).data),4===t)h=new Int32Array(c);else{const e=u*l;h=new Int32Array(e*t);for(let n=0;n<e;n++)for(let e=0;e<t;++e)h[n*t+e]=c[4*n+e]}return Lt(h,[l,u,t],"int32")}});var Gt=Object.freeze({__proto__:null,toPixels:async function(e,t){let n=_e(e,"img","toPixels");if(!(e instanceof le)){const e=n;n=yt(e,"int32"),e.dispose()}if(2!==n.rank&&3!==n.rank)throw new Error(`toPixels only supports rank 2 or 3 tensors, got rank ${n.rank}.`);const[r,o]=n.shape.slice(0,2),s=2===n.rank?1:n.shape[2];if(s>4||2===s)throw new Error("toPixels only supports depth of size 1, 3 or 4 but got "+s);if("float32"!==n.dtype&&"int32"!==n.dtype)throw new Error(`Unsupported type for toPixels: ${n.dtype}. Please use float32 or int32 tensors.`);const a=await n.data(),i="float32"===n.dtype?255:1,u=new Uint8ClampedArray(o*r*4);for(let e=0;e<r*o;++e){const t=[0,0,0,255];for(let r=0;r<s;r++){const o=a[e*s+r];if("float32"===n.dtype){if(o<0||o>1)throw new Error(`Tensor values for a float32 Tensor must be in the range [0 - 1] but encountered ${o}.`)}else if("int32"===n.dtype&&(o<0||o>255))throw new Error(`Tensor values for a int32 Tensor must be in the range [0 - 255] but encountered ${o}.`);1===s?(t[0]=o*i,t[1]=o*i,t[2]=o*i):t[r]=o*i}const r=4*e;u[r+0]=Math.round(t[0]),u[r+1]=Math.round(t[1]),u[r+2]=Math.round(t[2]),u[r+3]=Math.round(t[3])}if(null!=t){t.width=o,t.height=r;const e=t.getContext("2d"),n=new ImageData(u,o,r);e.putImageData(n,0,0)}return n!==e&&n.dispose(),u},fromPixels:Ot});function Kt(e,t){const n=e.shape.length,r=t.shape.length;if(n<1)throw new Error(`tf.gatherND() expects the input to be rank 1 or higher, but the rank was ${n}.`);if(r<1)throw new Error(`tf.gatherND() expects the indices to be rank 1 or higher, but the rank was ${r}.`);if("int32"!==t.dtype)throw new Error(`tf.gatherND() expects the indices to be int32 type, but the dtype was ${t.dtype}.`);if(t.shape[r-1]>n)throw new Error(`index innermost dimension length must be <= tensor rank; saw: ${t.shape[r-1]} vs. ${n}`);if(0===l(e.shape))throw new Error(`Requested more than 0 entries, but input is empty. Input shape: ${e.shape}.`);const o=t.shape,s=o[o.length-1];let a=1;for(let e=0;e<o.length-1;++e)a*=o[e];const i=e.shape,u=o.slice();u.pop();let c=1;for(let e=s;e<n;++e)c*=i[e],u.push(i[e]);const h=[...M(e.shape).map(e=>e/c),1].slice(0,s);return[u,a,c,h]}var Wt=Object.freeze({__proto__:null,prepareAndValidate:Kt});function Ut(e,t,n){const r=t.rank>1?t.shape[t.rank-1]:1,o=t.rank>1?t.rank-1:1,s="Must have updates.shape = indices.shape[:batchDim] + shape[sliceDim:], got updates.shape: "+n.shape+`, indices.shape: ${t.shape}, shape: ${e}`+`, sliceDim: ${r}, and batchDim: ${o}.`;if(n.rank<o)throw new Error(s+` update.rank < ${o}. `);if(e.length<r+(n.rank-o))throw new Error(s+" Output shape length < "+(r+(n.rank-o)));if(n.rank!==o+e.length-r)throw new Error(s+" update.rank != "+(o+e.length-r));for(let e=0;e<o;++e)if(n.shape[e]!==t.shape[e])throw new Error(s+` updates.shape[${e}] (${n.shape[e]}) != indices.shape[${e}] (${t.shape[e]}).`);for(let t=0;t<n.rank-o;++t)if(n.shape[t+o]!==e[t+r])throw new Error(s+` updates.shape[${t+o}] (${n.shape[t+o]}) != shape[${t+o}] (${e[t+o]})`)}function Vt(e,t,n){if(t.rank<1)throw new Error(`tf.scatterND() expects the indices to be rank 1 or higher, but the rank was ${t.rank}.`);if(e.rank<1)throw new Error(`tf.scatterND() expects the updates to be rank 1 or higher, but the rank was ${e.rank}.`);if("int32"!==t.dtype)throw new Error("The dtype of 'indices' should be int32, but got dtype: "+t.dtype);if(n.length<1)throw new Error("Output rank must be greater or equal to 1, but got shape: "+n);if(0===n.length){if(0===t.size)throw new Error("Indices specified for empty output. indices shape: "+t.shape);if(0===e.size)throw new Error("Updates specified for empty output. updates shape: "+e.shape)}Ut(n,t,e)}function Ht(e,t,n){const r=t.shape.length,o=r>1?t.shape[r-1]:1,s=n.length;let a=1;for(let e=o;e<s;++e)a*=n[e];const i=o<1?1:o;return{sliceRank:o,numUpdates:l(t.shape)/i,sliceSize:a,strides:[...M(n.slice(0,o)),1],outputSize:l(n)}}var jt=Object.freeze({__proto__:null,validateUpdateShape:Ut,validateInput:Vt,calculateShapes:Ht});function Jt(e){const t=[];let n=0;for(;e>0;)1&e&&t.push(n),e/=2,n++;return t}function Yt(e,t,n){const r=[];for(let o=0;o<e.length;o++)r[o]=Math.ceil((t[o]-e[o])/n[o]);return r}function Zt(e,t,n,r){const o=[...e];for(let e=o.length;e<r.length;e++)o.push(1);for(let e=0;e<n;e++)0===e?o[t]=1:(o.splice(t,0,1),o.pop());return o}function Xt(e,t,n){return n<=e?n:n-(t-1)}function Qt(e,t){const n=[];for(let r=0;r<e;r++)n.push(t+r);return n}function en(e,t,n,r,o,s,a,i,u){const l=e.length;let c=new Array(l),h=new Array(l),d=new Array(l);if(t.length&&n>0){const u=t[0],l=n+1;c=tn(a,u,l,r,e),h=nn(i,u,l,o,e),d=Zt(s,u,l,e)}else for(let t=0;t<l;t++)c[t]=on(a,r,s,e,t,u),h[t]=sn(i,o,s,e,t,u),d[t]=rn(s,t,u);return{begin:c,end:h,strides:d}}function tn(e,t,n,r,o){const s=[...o],a=Qt(n,t);for(let o=0;o<s.length;o++)if(a.indexOf(o)>-1)s[o]=0;else{const a=Xt(t,n,o);let i=r[a];e&1<<a&&(i=0),s[o]=i}return s}function nn(e,t,n,r,s){const a=[...s],i=Qt(n,t);for(let o=0;o<a.length;o++)if(i.indexOf(o)>-1)a[o]=Number.MAX_SAFE_INTEGER;else{const s=Xt(t,n,o);let i=r[s];e&1<<s&&(i=Number.MAX_SAFE_INTEGER),a[o]=i}for(let e=0;e<a.length;e++){const t=s[e];a[e]<0&&(a[e]+=t),a[e]=o(0,a[e],s[e])}return a}function rn(e,t,n){let r=e[t];return(n&1<<t||null==r)&&(r=1),r}function on(e,t,n,r,s,a){let i=t[s];const u=n[s]||1;(e&1<<s||a&1<<s||null==i)&&(i=u>0?Number.MIN_SAFE_INTEGER:Number.MAX_SAFE_INTEGER);const l=r[s];return i<0&&(i+=l),i=o(0,i,l-1),i}function sn(e,t,n,r,s,a){let i=t[s];const u=n[s]||1;(e&1<<s||a&1<<s||null==i)&&(i=u>0?Number.MAX_SAFE_INTEGER:Number.MIN_SAFE_INTEGER);const l=r[s];return i<0&&(i+=l),i=u>0?o(0,i,l):o(-1,i,l-1),i}function an(e,t,n){let r;const o=e.shape.length;let a;return r="number"==typeof t?[t,...new Array(o-1).fill(0)]:t.length<o?t.concat(new Array(o-t.length).fill(0)):t.slice(),r.forEach(e=>{s(-1!==e,()=>"slice() does not support negative begin indexing.")}),a=null==n?new Array(o).fill(-1):"number"==typeof n?[n,...new Array(o-1).fill(-1)]:n.length<o?n.concat(new Array(o-n.length).fill(-1)):n,a=a.map((t,n)=>t>=0?t:(s(-1===t,()=>`Negative size values should be exactly -1 but got ${t} for the slice() size at index ${n}.`),e.shape[n]-r[n])),[r,a]}var un=Object.freeze({__proto__:null,assertParamsValid:function(e,t,n){const r=e.shape.length;s(r===t.length,()=>`Error in slice${r}D: Length of begin ${t} must match the rank of the array (${r}).`),s(r===n.length,()=>`Error in slice${r}D: Length of size ${n} must match the rank of the array (${r}).`);for(let o=0;o<r;++o)s(t[o]+n[o]<=e.shape[o],()=>`Error in slice${r}D: begin[${o}] + size[${o}] (${t[o]+n[o]}) would overflow input.shape[${o}] (${e.shape[o]})`)},maskToAxes:Jt,computeOutShape:Yt,stridesWithElidedDims:Zt,getNormalizedAxes:en,startIndicesWithElidedDims:tn,stopIndicesWithElidedDims:nn,stridesForAxis:rn,startForAxis:on,stopForAxis:sn,isSliceContinous:function(e,t,n){let r=n.length;for(let e=0;e<n.length;e++)if(n[e]>1){r=e;break}for(let o=r+1;o<n.length;o++)if(t[o]>0||n[o]!==e[o])return!1;return!0},computeFlatOffset:function(e,t){let n=e.length>0?e[e.length-1]:1;for(let r=0;r<e.length-1;r++)n+=e[r]*t[r];return n},parseSliceParams:an,sliceInfo:function(e,t,n,r,o,s,a,i,u){let l=t.slice(),c=n.slice(),h=r;null==r&&(h=new Array(l.length));const d=Jt(a);if(d.length>1)throw new Error("Multiple ellipses in slice is not allowed.");if(0!==a&&0!==i)throw new Error("Using both ellipsisMask and newAxisMask is not yet supported.");if(0!==a&&0!==u)throw new Error("Using both ellipsisMask and shrinkAxisMask is not yet supported.");const p=e.length-l.length,f=Jt(i),m=e.slice();f.forEach(e=>{l[e]=0,c[e]=1,m.splice(e,0,1)});const{begin:g,end:b,strides:y}=en(m,d,p,l,c,h,o,s,a);l=g,c=b,h=y;const w=Jt(u);w.forEach(e=>{c[e]=l[e]+1,h[e]=1});const k=Yt(l,c,h),v=k.filter((e,t)=>-1===w.indexOf(t));return{nonStrided:h.every(e=>1===e),$begin:l,$end:c,$strides:h,size:k,newShape:m,outShape:v}}});class ln{getClassName(){return this.constructor.className}static fromConfig(e,t){return new e(t)}}class cn{constructor(){this.classNameMap={}}static getMap(){return null==cn.instance&&(cn.instance=new cn),cn.instance}static register(e){cn.getMap().classNameMap[e.className]=[e,e.fromConfig]}}function hn(e){s(null!=e.className,()=>"Class being registered does not have the static className property defined."),s("string"==typeof e.className,()=>"className is required to be a string, but got type "+typeof e.className),s(e.className.length>0,()=>"Class being registered has an empty-string as its className, which is disallowed."),cn.register(e)}var dn=Object.freeze({__proto__:null,Serializable:ln,SerializationMap:cn,registerClass:hn});function pn(){return 32===De.backend.floatPrecision()?.001:.1}function fn(e,t,n){let r=!0;if((k(e)||k(t))&&(r=!1),k(e)&&k(t)&&(r=!0),r){const n=e.constructor.name,r=t.constructor.name;if(n!==r)throw new Error(`Arrays are of different type. Actual: ${n}. Expected: `+r)}if(Array.isArray(e)&&Array.isArray(t)){const n=Te(e),r=Te(t);if(!c(n,r))throw new Error(`Arrays have different shapes. Actual: [${n}]. Expected: [${r}]`)}const o=k(e)?e:u(e),s=k(t)?t:u(t);if(o.length!==s.length)throw new Error(`Arrays have different lengths actual: ${o.length} vs expected: ${s.length}.\nActual:   ${o}.\nExpected: ${s}.`);for(let e=0;e<s.length;++e){const t=o[e],r=s[e];if(!n(t,r))throw new Error(`Arrays differ: actual[${e}] = ${t}, expected[${e}] = ${r}.\nActual:   ${o}.\nExpected: ${s}.`)}}function mn(e,t,n){return!isFinite(e)&&!isFinite(t)||!(isNaN(e)||isNaN(t)||Math.abs(e-t)>n)}var gn=Object.freeze({__proto__:null,TEST_EPSILON_FLOAT16:.1,expectArraysClose:function(e,t,n){return null==n&&(n=pn()),fn(e,t,(e,t)=>mn(e,t,n))},testEpsilon:pn,expectPromiseToFail:function(e,t){e().then(()=>t.fail(),()=>t())},expectArraysEqual:function(e,t){const n="string"==typeof t||"number"==typeof t||"boolean"==typeof t?[t]:t;return S(e)||S(e[0])||S(t)||S(t[0])?fn(e,n,(e,t)=>e==t):fn(e,t,(e,t)=>mn(e,t,0))},expectNumbersClose:function(e,t,n){if(null==n&&(n=pn()),!mn(e,t,n))throw new Error(`Numbers differ: actual === ${e}, expected === ${t}`)},expectValuesInRange:function(e,t,n){for(let r=0;r<e.length;r++)if(e[r]<t||e[r]>n)throw new Error(`Value out of range:${e[r]} low: ${t}, high: ${n}`)},expectArrayBuffersEqual:function(e,t){expect(new Float32Array(e)).toEqual(new Float32Array(t))},encodeStrings:function e(t){for(let n=0;n<t.length;n++){const r=t[n];Array.isArray(r)?e(r):t[n]=Y(r)}return t}});function bn(e){B().getBool("DEPRECATION_WARNINGS_ENABLED")&&console.warn(e+" You can disable deprecation warnings with tf.disableDeprecationWarnings().")}function yn(e,t){return De.tidy(e,t)}function wn(e){ke(e).forEach(e=>e.dispose())}function kn(e){return De.keep(e)}const vn=Re({add_:function(e,t){let n=_e(e,"a","add"),r=_e(t,"b","add");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Add",o)}});const xn=Re({floorDiv_:function(e,t){let n=_e(e,"a","floorDiv"),r=_e(t,"b","floorDiv");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("FloorDiv",o)}});const Sn=Re({div_:function(e,t){let n=_e(e,"a","div"),r=_e(t,"b","div");if([n,r]=ye(n,r),"int32"===n.dtype&&"int32"===r.dtype)return xn(n,r);const o={a:n,b:r};return De.runKernel("RealDiv",o,{})}});const En=Re({mul_:function(e,t){let n=_e(e,"a","mul"),r=_e(t,"b","mul");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Multiply",o)}});const Dn=Re({abs_:function(e){const t=_e(e,"x","abs");if("complex64"===t.dtype){const e={x:t};return De.runKernel("ComplexAbs",e)}{const e={x:t};return De.runKernel("Abs",e)}}});const In=Re({acos_:function(e){const t={x:_e(e,"x","acos")};return De.runKernel("Acos",t)}});const Nn=Re({acosh_:function(e){const t={x:_e(e,"x","acosh")};return De.runKernel("Acosh",t)}});const An=Re({addN_:function(e){s(Array.isArray(e),()=>"The argument passed to tf.addN() must be a list of tensors"),s(e.length>=1,()=>"Must pass at least one tensor to tf.addN(), but got "+e.length);const t=e.map((e,t)=>_e(e,"tensors"+t,"addN")),n=t[0];t.forEach(e=>{if(e.dtype!==n.dtype)throw new Error("All tensors passed to tf.addN() must have the same dtype")}),t.forEach(e=>{if(!c(e.shape,n.shape))throw new Error("All tensors passed to tf.addN() must have the same shape")});const r=t;return De.runKernel("AddN",r)}});const Mn=Re({all_:function(e,t=null,n=!1){const r={x:_e(e,"x","all","bool")},o={axis:t,keepDims:n};return De.runKernel("All",r,o)}});const Tn=Re({any_:function(e,t=null,n=!1){const r={x:_e(e,"x","any","bool")},o={axis:t,keepDims:n};return De.runKernel("Any",r,o)}});const $n=Re({argMax_:function(e,t=0){const n={x:_e(e,"x","argMax")},r={axis:t};return De.runKernel("ArgMax",n,r)}});const _n=Re({argMin_:function(e,t=0){const n={x:_e(e,"x","argMin")},r={axis:t};return De.runKernel("ArgMin",n,r)}});const Fn=Re({asin_:function(e){const t={x:_e(e,"x","asin")};return De.runKernel("Asin",t)}});const Rn=Re({asinh_:function(e){const t={x:_e(e,"x","asinh")};return De.runKernel("Asinh",t)}});const Cn=Re({atan_:function(e){const t={x:_e(e,"x","atan")};return De.runKernel("Atan",t)}});const Bn=Re({atan2_:function(e,t){let n=_e(e,"a","atan2"),r=_e(t,"b","atan2");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Atan2",o)}});const Pn=Re({atanh_:function(e){const t={x:_e(e,"x","atanh")};return De.runKernel("Atanh",t)}});function zn(e,t,n,r,o,s,a="channelsLast"){const[i,u]=Gn(t);let l;if("channelsLast"===a)l=[i,u,e[3],e[3]];else{if("channelsFirst"!==a)throw new Error("Unknown dataFormat "+a);l=[i,u,e[1],e[1]]}return Ln(e,l,n,r,o,s,!1,a)}function Ln(e,t,n,r,o,s,a=!1,i="channelsLast"){let[u,l,c,h]=[-1,-1,-1,-1];if("channelsLast"===i)[u,l,c,h]=e;else{if("channelsFirst"!==i)throw new Error("Unknown dataFormat "+i);[u,h,l,c]=e}const[d,p,,f]=t,[m,g]=Gn(n),[b,y]=Gn(r),w=Wn(d,b),k=Wn(p,y),{padInfo:v,outHeight:x,outWidth:S}=function(e,t,n,r,o,s,a,i,u){let l,c,h;if("number"==typeof e){l={top:e,bottom:e,left:e,right:e,type:0===e?"VALID":"NUMBER"};const o=function(e,t,n,r,o){null==r&&(r=On(e,t,n));const s=e[0],a=e[1],i=Un((s-t+2*r)/n+1,o),u=Un((a-t+2*r)/n+1,o);return[i,u]}([t,n],s,r,e,i);c=o[0],h=o[1]}else if("same"===e){c=Math.ceil(t/r),h=Math.ceil(n/o);const e=Math.max(0,(c-1)*r+s-t),i=Math.max(0,(h-1)*o+a-n),u=Math.floor(e/2),d=e-u,p=Math.floor(i/2);l={top:u,bottom:d,left:p,right:i-p,type:"SAME"}}else if("valid"===e)l={top:0,bottom:0,left:0,right:0,type:"VALID"},c=Math.ceil((t-s+1)/r),h=Math.ceil((n-a+1)/o);else{if("object"!=typeof e)throw Error("Unknown padding parameter: "+e);{const d="channelsLast"===u?e[1][0]:e[2][0],p="channelsLast"===u?e[1][1]:e[2][1],f="channelsLast"===u?e[2][0]:e[3][0],m="channelsLast"===u?e[2][1]:e[3][1];l={top:d,bottom:p,left:f,right:m,type:0===d&&0===p&&0===f&&0===m?"VALID":"EXPLICIT"},c=Un((t-s+d+p)/r+1,i),h=Un((n-a+f+m)/o+1,i)}}return{padInfo:l,outHeight:c,outWidth:h}}(o,l,c,m,g,w,k,s,i),E=a?f*h:f;let D;return"channelsFirst"===i?D=[u,E,x,S]:"channelsLast"===i&&(D=[u,x,S,E]),{batchSize:u,dataFormat:i,inHeight:l,inWidth:c,inChannels:h,outHeight:x,outWidth:S,outChannels:E,padInfo:v,strideHeight:m,strideWidth:g,filterHeight:d,filterWidth:p,effectiveFilterHeight:w,effectiveFilterWidth:k,dilationHeight:b,dilationWidth:y,inShape:e,outShape:D,filterShape:t}}function qn(e,t,n,r,o,s=!1,a="channelsLast",i){let[u,l,c,h,d]=[-1,-1,-1,-1,-1];if("channelsLast"===a)[u,l,c,h,d]=e;else{if("channelsFirst"!==a)throw new Error("Unknown dataFormat "+a);[u,d,l,c,h]=e}const[p,f,m,,g]=t,[b,y,w]=Kn(n),[k,v,x]=Kn(r),S=Wn(p,k),E=Wn(f,v),D=Wn(m,x),{padInfo:I,outDepth:N,outHeight:A,outWidth:M}=function(e,t,n,r,o,s,a,i,u,l,c){let h,d,p,f;if("number"==typeof e){h={top:e,bottom:e,left:e,right:e,front:e,back:e,type:0===e?"VALID":"NUMBER"};const s=function(e,t,n,r,o,s){null==o&&(o=On(e,t,r));const a=e[0],i=e[1],u=e[2],l=Un((a-t+2*o)/r+1,s),c=Un((i-t+2*o)/r+1,s),h=Un((u-t+2*o)/r+1,s);return[l,c,h,n]}([t,n,r,1],i,1,o,e,c);d=s[0],p=s[1],f=s[2]}else if("same"===e){d=Math.ceil(t/o),p=Math.ceil(n/s),f=Math.ceil(r/a);const e=(d-1)*o+i-t,c=(p-1)*s+u-n,m=(f-1)*a+l-r,g=Math.floor(e/2),b=e-g,y=Math.floor(c/2),w=c-y,k=Math.floor(m/2);h={top:y,bottom:w,left:k,right:m-k,front:g,back:b,type:"SAME"}}else{if("valid"!==e)throw Error("Unknown padding parameter: "+e);h={top:0,bottom:0,left:0,right:0,front:0,back:0,type:"VALID"},d=Math.ceil((t-i+1)/o),p=Math.ceil((n-u+1)/s),f=Math.ceil((r-l+1)/a)}return{padInfo:h,outDepth:d,outHeight:p,outWidth:f}}(o,l,c,h,b,y,w,S,E,D,i),T=s?g*d:g;let $;return"channelsFirst"===a?$=[u,T,N,A,M]:"channelsLast"===a&&($=[u,N,A,M,T]),{batchSize:u,dataFormat:a,inDepth:l,inHeight:c,inWidth:h,inChannels:d,outDepth:N,outHeight:A,outWidth:M,outChannels:T,padInfo:I,strideDepth:b,strideHeight:y,strideWidth:w,filterDepth:p,filterHeight:f,filterWidth:m,effectiveFilterDepth:S,effectiveFilterHeight:E,effectiveFilterWidth:D,dilationDepth:k,dilationHeight:v,dilationWidth:x,inShape:e,outShape:$,filterShape:t}}function On(e,t,n,r=1){const o=Wn(t,r);return Math.floor((e[0]*(n-1)-n+o)/2)}function Gn(e){return"number"==typeof e?[e,e,e]:2===e.length?[e[0],e[1],1]:e}function Kn(e){return"number"==typeof e?[e,e,e]:e}function Wn(e,t){return t<=1?e:e+(e-1)*(t-1)}function Un(e,t){if(!t)return Math.trunc(e);switch(t){case"round":return Math.round(e);case"ceil":return Math.ceil(e);case"floor":return Math.floor(e);default:throw new Error("Unknown roundingMode "+t)}}function Vn(e){const[t,n,r]=Gn(e);return 1===t&&1===n&&1===r}function Hn(e,t){return Vn(e)||Vn(t)}function jn(e){if("NHWC"===e)return"channelsLast";if("NCHW"===e)return"channelsFirst";throw new Error("Unknown dataFormat "+e)}const Jn=Re({reshape_:function(e,t){const n={x:_e(e,"x","reshape","string_or_numeric")},r={shape:t};return De.runKernel("Reshape",n,r)}});const Yn=Re({avgPool_:function(e,t,n,r,o){const a=_e(e,"x","avgPool","float32");s(Hn(n,1),()=>`Error in avgPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`);let i=a,u=!1;3===a.rank&&(u=!0,i=Jn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),s(4===i.rank,()=>`Error in avgPool: x must be rank 4 but got rank ${i.rank}.`),null!=o&&s(h(r),()=>`Error in avgPool: pad must be an integer when using, dimRoundingMode ${o} but got pad ${r}.`);const l={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:o};let d=De.runKernel("AvgPool",l,c);return d=yt(d,a.dtype),u?Jn(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});const Zn=Re({avgPool3d_:function(e,t,n,r,o,a="NDHWC",i){null==i?i=[1,1,1]:bn("dilations is deprecated, this field will be gone in v3.0.0.");const u=_e(e,"x","avgPool3d","float32");let l=u,c=!1;4===u.rank&&(c=!0,l=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),s(5===l.rank,()=>`Error in avgPool3d: x must be rank 5 but got rank ${l.rank}.`),s("NDHWC"===a,()=>"Error in avgPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),s(Hn(n,i),()=>`Error in avgPool3d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`),null!=o&&s(h(r),()=>`Error in avgPool3d: pad must be an integer when using, dimRoundingMode ${o} but got pad ${r}.`);const d={x:l},p={filterSize:t,strides:n,pad:r,dimRoundingMode:o,dataFormat:a,dilations:i};let f=De.runKernel("AvgPool3D",d,p);return f=yt(f,l.dtype),c?Jn(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const Xn=Re({concat_:function(e,t=0){s(e.length>=1,()=>"Pass at least one tensor to concat");const n=Fe(e,"tensors","concat","string_or_numeric");if("complex64"===n[0].dtype&&n.forEach(e=>{if("complex64"!==e.dtype)throw new Error(`Cannot concatenate complex64 tensors with a tensor\n          with dtype ${e.dtype}. `)}),1===n.length)return wt(n[0]);const r=n,o={axis:t};return De.runKernel("Concat",r,o)}});const Qn=Re({sigmoid_:function(e){const t={x:_e(e,"x","sigmoid")};return De.runKernel("Sigmoid",t)}});const er=Re({slice_:function(e,t,n){const r=_e(e,"x","slice","string_or_numeric");if(0===r.rank)throw new Error("Slicing scalar is not possible");const o={x:r},s={begin:t,size:n};return De.runKernel("Slice",o,s)}});const tr=Re({tanh_:function(e){const t={x:_e(e,"x","tanh")};return De.runKernel("Tanh",t)}});const nr=Re({basicLSTMCell_:function(e,t,n,r,o,s){const a=_e(e,"forgetBias","basicLSTMCell"),i=_e(t,"lstmKernel","basicLSTMCell"),u=_e(n,"lstmBias","basicLSTMCell"),l=_e(r,"data","basicLSTMCell"),c=_e(o,"c","basicLSTMCell"),h=_e(s,"h","basicLSTMCell"),d=Xn([l,h],1),p=Rt(d,i),f=vn(p,u),m=f.shape[0],g=f.shape[1]/4,b=[m,g],y=er(f,[0,0],b),w=er(f,[0,g],b),k=er(f,[0,2*g],b),v=er(f,[0,3*g],b),x=vn(En(Qn(y),tr(w)),En(c,Qn(vn(a,k))));return[x,En(tr(x),Qn(v))]}});const rr=Re({batchToSpaceND_:function(e,t,n){const r=_e(e,"x","batchToSpaceND"),o=t.reduce((e,t)=>e*t);s(r.rank>=1+t.length,()=>`input rank is ${r.rank} but should be > than blockShape.length ${t.length}`),s(n.length===t.length,()=>`crops.length is ${n.length} but should be equal to blockShape.length  ${t.length}`),s(r.shape[0]%o==0,()=>`input tensor batch is ${r.shape[0]} but is not divisible by the product of the elements of blockShape ${t.join(" * ")} === ${o}`);const a={x:r},i={blockShape:t,crops:n};return De.runKernel("BatchToSpaceND",a,i)}});const or=Re({batchNorm_:function(e,t,n,r,o,a){null==a&&(a=.001);const i=_e(e,"x","batchNorm"),u=_e(t,"mean","batchNorm"),l=_e(n,"variance","batchNorm");let c,h;null!=o&&(c=_e(o,"scale","batchNorm")),null!=r&&(h=_e(r,"offset","batchNorm")),s(u.rank===l.rank,()=>"Batch normalization gradient requires mean and variance to have equal ranks."),s(null==h||u.rank===h.rank,()=>"Batch normalization gradient requires mean and offset to have equal ranks."),s(null==c||u.rank===c.rank,()=>"Batch normalization gradient requires mean and scale to have equal ranks.");const d={x:function(e){let t;return t=0===e.rank||1===e.rank?Jn(e,[1,1,1,e.size]):2===e.rank?Jn(e,[1,1,e.shape[0],e.shape[1]]):3===e.rank?Jn(e,[1,e.shape[0],e.shape[1],e.shape[2]]):e,t}(i),scale:c,offset:h,mean:u,variance:l},p={varianceEpsilon:a},f=De.runKernel("FusedBatchNorm",d,p);return Jn(f,i.shape)}});const sr=Re({batchNorm2d_:function(e,t,n,r,o,a){const i=_e(e,"x","batchNorm"),u=_e(t,"mean","batchNorm"),l=_e(n,"variance","batchNorm");let c,h;return null!=o&&(c=_e(o,"scale","batchNorm")),null!=r&&(h=_e(r,"offset","batchNorm")),s(2===i.rank,()=>"Error in batchNorm2D: x must be rank 2 but got rank "+i.rank+"."),s(2===u.rank||1===u.rank,()=>`Error in batchNorm2D: mean must be rank 2 or rank 1 but got rank ${u.rank}.`),s(2===l.rank||1===l.rank,()=>`Error in batchNorm2D: variance must be rank 2 or rank 1 but got rank ${l.rank}.`),null!=c&&s(2===c.rank||1===c.rank,()=>`Error in batchNorm2D: scale must be rank 2 or rank 1 but got rank ${c.rank}.`),null!=h&&s(2===h.rank||1===h.rank,()=>`Error in batchNorm2D: offset must be rank 2 or rank 1 but got rank ${h.rank}.`),or(i,u,l,h,c,a)}});const ar=Re({batchNorm3d_:function(e,t,n,r,o,a){const i=_e(e,"x","batchNorm"),u=_e(t,"mean","batchNorm"),l=_e(n,"variance","batchNorm");let c,h;return null!=o&&(c=_e(o,"scale","batchNorm")),null!=r&&(h=_e(r,"offset","batchNorm")),s(3===i.rank,()=>"Error in batchNorm3D: x must be rank 3 but got rank "+i.rank+"."),s(3===u.rank||1===u.rank,()=>`Error in batchNorm3D: mean must be rank 3 or rank 1 but got rank ${u.rank}.`),s(3===l.rank||1===l.rank,()=>`Error in batchNorm3D: variance must be rank 3 or rank 1 but got rank ${l.rank}.`),null!=c&&s(3===c.rank||1===c.rank,()=>`Error in batchNorm3D: scale must be rank 3 or rank 1 but got rank ${c.rank}.`),null!=h&&s(3===h.rank||1===h.rank,()=>`Error in batchNorm3D: offset must be rank 3 or rank 1 but got rank ${h.rank}.`),or(i,u,l,h,c,a)}});const ir=Re({batchNorm4d_:function(e,t,n,r,o,a){const i=_e(e,"x","batchNorm"),u=_e(t,"mean","batchNorm"),l=_e(n,"variance","batchNorm");let c,h;return null!=o&&(c=_e(o,"scale","batchNorm")),null!=r&&(h=_e(r,"offset","batchNorm")),s(4===i.rank,()=>"Error in batchNorm4D: x must be rank 4 but got rank "+i.rank+"."),s(4===u.rank||1===u.rank,()=>`Error in batchNorm4D: mean must be rank 4 or rank 1 but got rank ${u.rank}.`),s(4===l.rank||1===l.rank,()=>`Error in batchNorm4D: variance must be rank 4 or rank 1 but got rank ${l.rank}.`),null!=c&&s(4===c.rank||1===c.rank,()=>`Error in batchNorm4D: scale must be rank 4 or rank 1 but got rank ${c.rank}.`),null!=h&&s(4===h.rank||1===h.rank,()=>`Error in batchNorm4D: offset must be rank 4 or rank 1 but got rank ${h.rank}.`),or(i,u,l,h,c,a)}});const ur=Re({bincount_:function(e,t,n){const r=_e(e,"x","bincount"),o=_e(t,"weights","bincount");s("int32"===r.dtype,()=>"Error in bincount: input dtype must be int32, but got "+r.dtype),s(n>=0,()=>`size must be non-negative, but got ${n}.`),s(o.size===r.size||0===o.size,()=>`Error in bincount: weights must have the same size as input or0-length, but got input shape: ${r.shape}, weights shape: `+o.shape+".");const a={x:r,weights:o},i={size:n};return De.runKernel("Bincount",a,i)}});const lr=Re({broadcastTo_:function(e,t){let n=_e(e,"broadcastTo","x");const r=n.shape;if(t.some(e=>!(e>0)||e%1!=0))throw new Error(`broadcastTo(): Invalid broadcast shape [${t}].`);if(t.length<n.rank)throw new Error(`broadcastTo(): shape.length=${t.length} < input.rank=${n.rank}.`);if(t.length>n.rank){const e=n.shape.slice();for(;e.length<t.length;)e.unshift(1);n=Jn(n,e)}const o=n.shape,s=Array.from(t);for(let e=t.length-1;e>=0;e--)if(o[e]===t[e])s[e]=1;else if(1!==n.shape[e])throw new Error(`broadcastTo(): [${r}] cannot be broadcast to [${t}].`);if(0===s.map((e,t)=>e>1?t:-1).filter(e=>e>=0).length)return wt(n);const a={x:n},i={reps:s};return De.runKernel("Tile",a,i)}});const cr=Re({ceil_:function(e){const t={x:_e(e,"x","ceil")};return De.runKernel("Ceil",t)}});const hr=Re({clipByValue_:function(e,t,n){const r=_e(e,"x","clipByValue");s(t<=n,()=>`Error in clip: min (${t}) must be less than or equal to max (${n}).`);const o={x:r},a={clipValueMin:t,clipValueMax:n};return De.runKernel("ClipByValue",o,a)}});const dr=Re({concat1d_:function(e){return Xn(e,0)}});const pr=Re({concat2d_:function(e,t){return Xn(e,t)}});const fr=Re({concat3d_:function(e,t){return Xn(e,t)}});const mr=Re({concat4d_:function(e,t){return Xn(e,t)}});const gr=Re({conv2d_:function(e,t,n,r,o="NHWC",a=[1,1],i){const u=_e(e,"x","conv2d"),l=_e(t,"filter","conv2d");let c=u,d=!1;3===u.rank&&(d=!0,c=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2]])),s(4===c.rank,()=>`Error in conv2d: input must be rank 4, but got rank ${c.rank}.`),s(4===l.rank,()=>"Error in conv2d: filter must be rank 4, but got rank "+l.rank+"."),null!=i&&s(h(r),()=>`Error in conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const p="NHWC"===o?c.shape[3]:c.shape[1];s(p===l.shape[2],()=>`Error in conv2d: depth of input (${p}) must match input depth for filter ${l.shape[2]}.`),s(Hn(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`);const f={x:c,filter:l},m={strides:n,pad:r,dataFormat:o,dilations:a,dimRoundingMode:i},g=De.runKernel("Conv2D",f,m);return d?Jn(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const br=Re({conv1d_:function(e,t,n,r,o="NWC",a=1,i){const u=_e(e,"x","conv1d"),l=_e(t,"filter","conv1d");let c=u,d=!1;2===u.rank&&(d=!0,c=Jn(u,[1,u.shape[0],u.shape[1]])),s(3===c.rank,()=>`Error in conv1d: input must be rank 3, but got rank ${c.rank}.`),s(3===l.rank,()=>"Error in conv1d: filter must be rank 3, but got rank "+l.rank+"."),null!=i&&s(h(r),()=>`Error in conv1d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`),s(c.shape[2]===l.shape[1],()=>`Error in conv1d: depth of input (${c.shape[2]}) must match input depth for filter ${l.shape[1]}.`),s(Hn(n,a),()=>`Error in conv1D: Either stride or dilation must be 1. Got stride ${n} and dilation '${a}'`),s("NWC"===o,()=>`Error in conv1d: got dataFormat of ${o} but only NWC is currently supported.`);const p=Jn(l,[1,l.shape[0],l.shape[1],l.shape[2]]),f=Jn(c,[c.shape[0],1,c.shape[1],c.shape[2]]),m=gr(f,p,[1,n],r,"NHWC",[1,a],i);return Jn(m,d?[m.shape[2],m.shape[3]]:[m.shape[0],m.shape[2],m.shape[3]])}});const yr=Re({conv2DBackpropInput_:function(e,t,n,r,o,a="NHWC",i){s(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let u=e,l=t,c=!1;3===t.rank&&(c=!0,l=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2]]),u=[1,e[0],e[1],e[2]]),s(4===u.length,()=>"Error in conv2dDerInput: inShape must be length 4, but got length "+u.length+"."),s(4===l.rank,()=>"Error in conv2dDerInput: dy must be rank 4, but got rank "+l.rank),s(4===n.rank,()=>"Error in conv2dDerInput: filter must be rank 4, but got rank "+n.rank);const d="NHWC"===a?u[3]:u[1],p="NHWC"===a?l.shape[3]:l.shape[1];s(d===n.shape[2],()=>`Error in conv2dDerInput: depth of input (${d}) must match input depth for filter ${n.shape[2]}.`),s(p===n.shape[3],()=>`Error in conv2dDerInput: depth of output (${p}) must match output depth for filter ${n.shape[3]}.`),null!=i&&s(h(o),()=>`Error in conv2dDerInput: pad must be an integer when using, dimRoundingMode ${i} but got pad ${o}.`);const f={dy:l,filter:n},m={strides:r,pad:o,dataFormat:a,dimRoundingMode:i,inputShape:u},g=De.runKernel("Conv2DBackpropInput",f,m);return c?Jn(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const wr=Re({conv2dTranspose_:function(e,t,n,r,o,s){const a=_e(e,"x","conv2dTranspose"),i=_e(t,"filter","conv2dTranspose");return yr(n,a,i,r,o,"NHWC",s)}});const kr=Re({conv3d_:function(e,t,n,r,o="NDHWC",a=[1,1,1]){const i=_e(e,"x","conv3d"),u=_e(t,"filter","conv3d");let l=i,c=!1;4===i.rank&&(c=!0,l=Jn(i,[1,i.shape[0],i.shape[1],i.shape[2],i.shape[3]])),s(5===l.rank,()=>`Error in conv3d: input must be rank 5, but got rank ${l.rank}.`),s(5===u.rank,()=>"Error in conv3d: filter must be rank 5, but got rank "+u.rank+"."),s(l.shape[4]===u.shape[3],()=>`Error in conv3d: depth of input (${l.shape[4]}) must match input depth for filter ${u.shape[3]}.`),s(Hn(n,a),()=>`Error in conv3D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),s("NDHWC"===o,()=>`Error in conv3d: got dataFormat of ${o} but only NDHWC is currently supported.`);const h={x:l,filter:u},d={strides:n,pad:r,dataFormat:o,dilations:a},p=De.runKernel("Conv3D",h,d);return c?Jn(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const vr=Re({conv3DBackpropInput_:function(e,t,n,r,o){s(e.length===t.rank,()=>`Length of inShape (${e.length}) and rank of dy (${t.rank}) must match`);let a=e,i=t,u=!1;4===t.rank&&(u=!0,i=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]]),a=[1,e[0],e[1],e[2],e[3]]);const l=a[4],c=i.shape[4];s(5===a.length,()=>"Error in conv3dDerInput: inShape must be length 5, but got length "+a.length+"."),s(5===i.rank,()=>"Error in conv3dDerInput: dy must be rank 5, but got rank "+i.rank),s(5===n.rank,()=>"Error in conv3dDerInput: filter must be rank 5, but got rank "+n.rank),s(l===n.shape[3],()=>`Error in conv3dDerInput: depth of input (${l}) must match input depth for filter ${n.shape[3]}.`),s(c===n.shape[4],()=>`Error in conv3dDerInput: depth of output (${c}) must match output depth for filter ${n.shape[4]}.`);const h={dy:i,filter:n},d={pad:o,strides:r,inputShape:a},p=De.runKernel("Conv3DBackpropInputV2",h,d);return u?Jn(p,[p.shape[1],p.shape[2],p.shape[3],p.shape[4]]):p}});const xr=Re({conv3dTranspose_:function(e,t,n,r,o){const s=_e(e,"x","conv3dTranspose"),a=_e(t,"filter","conv3dTranspose");return vr(n,s,a,r,o)}});const Sr=Re({cos_:function(e){const t={x:_e(e,"x","cos")};return De.runKernel("Cos",t)}});const Er=Re({cosh_:function(e){const t={x:_e(e,"x","cosh")};return De.runKernel("Cosh",t)}});const Dr=Re({cumsum_:function(e,t=0,n=!1,r=!1){const o={x:_e(e,"x","cumsum")},s={axis:t,exclusive:n,reverse:r};return De.runKernel("Cumsum",o,s)}});const Ir=Re({denseBincount_:function(e,t,n,r=!1){const o=_e(e,"x","denseBincount"),a=_e(t,"weights","denseBincount");s("int32"===o.dtype,()=>"Error in denseBincount: input dtype must be int32, but got "+o.dtype),s(o.rank<=2,()=>`Error in denseBincount: input must be at most rank 2, but got rank ${o.rank}.`),s(n>=0,()=>`size must be non-negative, but got ${n}.`),s(a.size===o.size||0===a.size,()=>`Error in denseBincount: weights must have the same shape as x or 0-length, but got x shape: ${o.shape}, weights shape: `+a.shape+".");const i={x:o,weights:a},u={size:n,binaryOutput:r};return De.runKernel("DenseBincount",i,u)}});const Nr=Re({depthToSpace_:function(e,t,n="NHWC"){const r=_e(e,"x","depthToSpace"),o="NHWC"===n?r.shape[1]:r.shape[2],a="NHWC"===n?r.shape[2]:r.shape[3],i="NHWC"===n?r.shape[3]:r.shape[1];s(o*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${o} and ${t}  for depthToSpace with input shape\n    ${r.shape}`),s(a*t>=0,()=>`Negative dimension size caused by overflow when multiplying\n    ${a} and ${t} for depthToSpace with input shape\n        ${r.shape}`),s(i%(t*t)==0,()=>`Dimension size must be evenly divisible by ${t*t} but is ${i} for depthToSpace with input shape ${r.shape}`);const u={x:r},l={blockSize:t,dataFormat:n};return De.runKernel("DepthToSpace",u,l)}});const Ar=Re({depthwiseConv2d_:function(e,t,n,r,o="NHWC",a=[1,1],i){const u=_e(e,"x","depthwiseConv2d"),l=_e(t,"filter","depthwiseConv2d");let c=u,d=!1;3===u.rank&&(d=!0,c=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2]])),s(4===c.rank,()=>`Error in depthwiseConv2d: input must be rank 4, but got rank ${c.rank}.`),s(4===l.rank,()=>"Error in depthwiseConv2d: filter must be rank 4, but got rank "+l.rank+"."),s(c.shape[3]===l.shape[2],()=>`Error in depthwiseConv2d: number of input channels (${c.shape[3]}) must match the inChannels dimension in filter ${l.shape[2]}.`),null!=i&&s(h(r),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`);const p={x:c,filter:l},f={strides:n,pad:r,dataFormat:o,dilations:a,dimRoundingMode:i},m=De.runKernel("DepthwiseConv2dNative",p,f);return d?Jn(m,[m.shape[1],m.shape[2],m.shape[3]]):m}});const Mr=Re({diag_:function(e){const t={x:_e(e,"x","diag")};return De.runKernel("Diag",t)}});const Tr=Re({dilation2d_:function(e,t,n,r,o=[1,1],a="NHWC"){const i=_e(e,"x","dilation2d"),u=_e(t,"filter","dilation2d");s(3===i.rank||4===i.rank,()=>"Error in dilation2d: input must be rank 3 or 4, but got rank "+i.rank+"."),s(3===u.rank,()=>"Error in dilation2d: filter must be rank 3, but got rank "+u.rank+"."),s("NHWC"===a,()=>"Error in dilation2d: Only NHWC is currently supported, but got dataFormat of "+a);let l=i,c=!1;3===i.rank&&(l=Jn(i,[1,i.shape[0],i.shape[1],i.shape[2]]),c=!0);const h={x:l,filter:u},d={strides:n,pad:r,dilations:o},p=De.runKernel("Dilation2D",h,d);return c?Jn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}});function $r(e,t){const n=[];for(let r=0;r<t.length;r++){const o=e[e.length-r-1],s=t.length-r-1,a=t[s];(null==o||1===o&&a>1)&&n.unshift(s)}return n}function _r(e,t){const n=[],r=Math.max(e.length,t.length);for(let o=0;o<r;o++){let r=e[e.length-o-1];null==r&&(r=1);let s=t[t.length-o-1];if(null==s&&(s=1),1===r)n.unshift(s);else if(1===s)n.unshift(r);else{if(r!==s){throw Error(`Operands could not be broadcast together with shapes ${e} and ${t}.`)}n.unshift(r)}}return n}const Fr=Re({equal_:function(e,t){let n=_e(e,"a","equal"),r=_e(t,"b","equal");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("Equal",o)}});const Rr=Re({where_:function(e,t,n){const r=_e(t,"a","where"),o=_e(n,"b","where"),i=_e(e,"condition","where","bool"),u=_r(r.shape,o.shape),l=lr(r,u),c=lr(o,u);1===i.rank&&s(i.shape[0]===r.shape[0],()=>"The first dimension of `a` must match the size of `condition`."),1!==i.rank&&a(i.shape,c.shape,"Error in where: ");const h={condition:i,t:l,e:c};return De.runKernel("Select",h)}});const Cr=Re({zerosLike_:function(e){const t={x:_e(e,"x","zerosLike")};return De.runKernel("ZerosLike",t)}});const Br=Re({divNoNan_:function(e,t){let n=_e(e,"a","div"),r=_e(t,"b","div");[n,r]=ye(n,r);const o=Sn(n,r),s=Cr(o),a=Fr(r,s);return Rr(a,s,o)}});const Pr=Re({dot_:function(e,t){const n=_e(e,"t1","dot"),r=_e(t,"t2","dot");s(!(1!==n.rank&&2!==n.rank||1!==r.rank&&2!==r.rank),()=>`Error in dot: inputs must all be rank 1 or 2, but got ranks ${n.rank} and ${r.rank}.`);const o=1===n.rank?n.size:n.shape[1],a=1===r.rank?r.size:r.shape[0];if(s(o===a,()=>`Error in dot: inner dimensions of inputs must match, but got ${o} and ${a}.`),1===n.rank&&1===r.rank){const e=Jn(n,[1,-1]),t=Jn(r,[-1,1]),o=Rt(e,t);return Jn(o,[])}if(1===n.rank&&2===r.rank){const e=Jn(n,[1,-1]),t=Jn(r,[r.shape[0],r.shape[1]]),o=Rt(e,t);return Jn(o,[o.size])}if(2===n.rank&&1===r.rank){const e=Jn(r,[-1,1]),t=Rt(n,e);return Jn(t,[t.size])}{const e=Jn(r,[r.shape[0],r.shape[1]]);return Rt(n,e)}}});const zr=Re({elu_:function(e){const t={x:_e(e,"x","elu")};return De.runKernel("Elu",t)}});const Lr=Re({erf_:function(e){let t=_e(e,"x","erf");s("int32"===t.dtype||"float32"===t.dtype,()=>"Input dtype must be `int32` or `float32`."),"int32"===t.dtype&&(t=yt(t,"float32"));const n={x:t};return De.runKernel("Erf",n)}});const qr=Re({exp_:function(e){const t={x:_e(e,"x","exp")};return De.runKernel("Exp",t)}});const Or=Re({expandDims_:function(e,t=0){const n=_e(e,"x","expandDims","string_or_numeric");s(t<=n.rank,()=>"Axis must be <= rank of the tensor");const r={input:n},o={dim:t};return De.runKernel("ExpandDims",r,o)}});const Gr=Re({expm1_:function(e){const t={x:_e(e,"x","expm1")};return De.runKernel("Expm1",t)}});const Kr=Re({tile_:function(e,t){const n=_e(e,"x","tile","string_or_numeric");s(n.rank===t.length,()=>`Error in transpose: rank of input ${n.rank} must match length of reps ${t}.`);const r={x:n},o={reps:t};return De.runKernel("Tile",r,o)}});const Wr=Re({eye_:function(e,t,n,r="float32"){null==t&&(t=e);const o=bt([e,t],r),s=e<=t?e:t;for(let e=0;e<s;++e)o.set(1,e,e);const a=Jn(o.toTensor(),[e,t]);if(null==n)return a;if(1===n.length)return Kr(Or(a,0),[n[0],1,1]);if(2===n.length)return Kr(Or(Or(a,0),0),[n[0],n[1],1,1]);if(3===n.length)return Kr(Or(Or(Or(a,0),0),0),[n[0],n[1],n[2],1,1]);throw new Error(`eye() currently supports only 1D and 2D batchShapes, but received ${n.length}D.`)}});function Ur(e,t,n){const r={shape:e,value:t,dtype:n};return De.runKernel("Fill",{},r)}const Vr=Re({floor_:function(e){const t={x:_e(e,"x","floor")};return De.runKernel("Floor",t)}});const Hr=Re({gather_:function(e,t,n=0,r=0){const o={x:_e(e,"x","gather"),indices:_e(t,"indices","gather","int32")},s={axis:n,batchDims:r};return De.runKernel("GatherV2",o,s)}});const jr=Re({greater_:function(e,t){let n=_e(e,"a","greater"),r=_e(t,"b","greater");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("Greater",o)}});const Jr=Re({greaterEqual_:function(e,t){let n=_e(e,"a","greaterEqual"),r=_e(t,"b","greaterEqual");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("GreaterEqual",o)}});const Yr=Re({imag_:function(e){const t={input:_e(e,"input","imag")};return De.runKernel("Imag",t)}});const Zr=Re({isFinite_:function(e){const t={x:_e(e,"x","isFinite")};return De.runKernel("IsFinite",t)}});const Xr=Re({isInf_:function(e){const t={x:_e(e,"x","isInf")};return De.runKernel("IsInf",t)}});const Qr=Re({isNaN_:function(e){const t={x:_e(e,"x","isNaN")};return De.runKernel("IsNan",t)}});const eo=Re({leakyRelu_:function(e,t=.2){const n={x:_e(e,"x","leakyRelu")},r={alpha:t};return De.runKernel("LeakyRelu",n,r)}});const to=Re({less_:function(e,t){let n=_e(e,"a","less"),r=_e(t,"b","less");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("Less",o)}});const no=Re({lessEqual_:function(e,t){let n=_e(e,"a","lessEqual"),r=_e(t,"b","lessEqual");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("LessEqual",o)}});const ro=Re({localResponseNormalization_:function(e,t=5,n=1,r=1,o=.5){const a=_e(e,"x","localResponseNormalization");s(4===a.rank||3===a.rank,()=>`Error in localResponseNormalization: x must be rank 3 or 4 but got\n               rank ${a.rank}.`),s(h(t),()=>`Error in localResponseNormalization: depthRadius must be an integer but got depthRadius ${t}.`);let i=a,u=!1;3===a.rank&&(u=!0,i=Jn(a,[1,a.shape[0],a.shape[1],a.shape[2]]));const l={x:i},c={depthRadius:t,bias:n,alpha:r,beta:o},d=De.runKernel("LRN",l,c);return u?Jn(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});const oo=Re({log_:function(e){const t={x:_e(e,"x","log")};return De.runKernel("Log",t)}});const so=Re({log1p_:function(e){const t={x:_e(e,"x","log1p")};return De.runKernel("Log1p",t)}});function ao(e,t){s(N(e),()=>"The f passed in variableGrads(f) must be a function"),s(null==t||Array.isArray(t)&&t.every(e=>e instanceof ce),()=>"The varList passed in variableGrads(f, varList) must be an array of variables");const n=null!=t;if(!n){t=[];for(const e in De.registeredVariables)t.push(De.registeredVariables[e])}const r=n?t.filter(e=>!e.trainable):null,o=t.length;s((t=t.filter(e=>e.trainable)).length>0,()=>`variableGrads() expects at least one of the input variables to be trainable, but none of the ${o} variables is trainable.`);const{value:a,grads:i}=De.gradients(e,t,null,!0);s(i.some(e=>null!=e),()=>"Cannot find a connection between any variable and the result of the loss function y=f(x). Please make sure the operations that use variables are inside the function f passed to minimize()."),s(0===a.rank,()=>`The f passed in variableGrads(f) must return a scalar, but it returned a rank-${a.rank} tensor`);const u={};return t.forEach((e,t)=>{null!=i[t]&&(u[e.name]=i[t])}),null!=r&&r.forEach(e=>u[e.name]=null),{value:a,grads:u}}function io(e){return De.customGrad(e)}function uo(e){if(e.filter(e=>null==e).length>0)throw new Error("Cannot compute gradient of y=f(x) with respect to x. Make sure that\n    the f you passed encloses all operations that lead from x to y.")}const lo=Re({neg_:function(e){const t={x:_e(e,"x","neg")};return De.runKernel("Neg",t)}});const co=Re({softplus_:function(e){const t={x:_e(e,"x","softplus")};return De.runKernel("Softplus",t)}});const ho=Re({logSigmoid_:function(e){const t=_e(e,"x","logSigmoid");return io(e=>({value:lo(co(lo(e))),gradFunc:t=>En(t,Qn(lo(e)))}))(t)}});const po=Re({max_:function(e,t=null,n=!1){const r={x:_e(e,"x","max")},o={reductionIndices:t,keepDims:n};return De.runKernel("Max",r,o)}});const fo=Re({sub_:function(e,t){let n=_e(e,"a","sub"),r=_e(t,"b","sub");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Sub",o)}});const mo=Re({sum_:function(e,t=null,n=!1){let r=_e(e,"x","sum");"bool"===r.dtype&&(r=yt(r,"int32"));const o={x:r},s={axis:t,keepDims:n};return De.runKernel("Sum",o,s)}});const go=Re({logSoftmax_:function(e,t=-1){const n=_e(e,"logits","logSoftmax");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Log Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and axis was ${t}`);return io((e,n)=>{const r=po(e,t,!0),o=fo(e,r),s=fo(yt(o,"float32"),oo(mo(qr(o),t,!0)));n([s]);return{value:s,gradFunc:(e,n)=>{const[r]=n,o=qr(r);return fo(e,En(mo(e,t,!0),o))}}})(n)}});function bo(e,t){for(let n=0;n<e.length;++n)if(e[e.length-n-1]!==t-1-n)return!1;return!0}function yo(e,t,n){const r=e.length+t.length,o=[];let s=0,a=0;for(let i=0;i<r;i++)-1===n.indexOf(i)?o.push(e[s++]):o.push(t[a++]);return o}function wo(e,t){const n=[],r=e.length;for(let o=0;o<r;o++)-1===t.indexOf(o)&&n.push(e[o]);return[n,t.map(t=>e[t])]}function ko(e,t){return yo(e,t.map(e=>1),t)}function vo(e,t){if(bo(e,t))return null;const n=[];for(let r=0;r<t;++r)-1===e.indexOf(r)&&n.push(r);return e.forEach(e=>n.push(e)),n}function xo(e){return e.map((e,t)=>[t,e]).sort((e,t)=>e[1]-t[1]).map(e=>e[0])}const So=Re({logSumExp_:function(e,t=null,n=!1){const r=_e(e,"x","logSumExp"),o=p(t,r.shape),s=po(r,o,!0),a=fo(r,s),i=qr(a),u=mo(i,o),l=oo(u),c=vn(Jn(s,l.shape),l);if(n){const e=ko(c.shape,o);return Jn(c,e)}return c}});const Eo=Re({logicalAnd_:function(e,t){const n=_e(e,"a","logicalAnd","bool"),r=_e(t,"b","logicalAnd","bool");_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("LogicalAnd",o)}});const Do=Re({logicalNot_:function(e){const t={x:_e(e,"x","logicalNot","bool")};return De.runKernel("LogicalNot",t)}});const Io=Re({logicalOr_:function(e,t){const n=_e(e,"a","logicalOr","bool"),r=_e(t,"b","logicalOr","bool");_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("LogicalOr",o)}});const No=Re({logicalXor_:function(e,t){const n=_e(e,"a","logicalXor","bool"),r=_e(t,"b","logicalXor","bool");return _r(n.shape,r.shape),Eo(Io(e,t),Do(Eo(e,t)))}});const Ao=Re({maxPool_:function(e,t,n,r,o){const a=_e(e,"x","maxPool");let i=a,u=!1;3===a.rank&&(u=!0,i=Jn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),s(4===i.rank,()=>`Error in maxPool: input must be rank 4 but got rank ${i.rank}.`),s(Hn(n,1),()=>`Error in maxPool: Either strides or dilations must be 1. Got strides ${n} and dilations '1'`),null!=o&&s(h(r),()=>`Error in maxPool: pad must be an integer when using, dimRoundingMode ${o} but got pad ${r}.`);const l={x:i},c={filterSize:t,strides:n,pad:r,dimRoundingMode:o},d=De.runKernel("MaxPool",l,c);return u?Jn(d,[d.shape[1],d.shape[2],d.shape[3]]):d}});const Mo=Re({maxPool3d_:function(e,t=[1,1,1],n,r,o,a="NDHWC",i){null==i?i=[1,1,1]:bn("dilations is deprecated, this field will be gone in v3.0.0.");const u=_e(e,"x","maxPool3d");let l=u,c=!1;4===u.rank&&(c=!0,l=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]])),s(5===l.rank,()=>`Error in maxPool3d: x must be rank 5 but got rank ${l.rank}.`),s("NDHWC"===a,()=>"Error in maxPool3d: Only NDHWC is currently supported, but got dataFormat of "+a),s(Hn(n,i),()=>`Error in maxPool3d: Either strides or dilations must be 1. Got strides ${n} and dilations '${i}'`),null!=o&&s(h(r),()=>`Error in maxPool3d: pad must be an integer when using, dimRoundingMode ${o} but got pad ${r}.`);const d={x:l},p={filterSize:t,strides:n,pad:r,dimRoundingMode:o,dataFormat:a,dilations:i},f=De.runKernel("MaxPool3D",d,p);return c?Jn(f,[f.shape[1],f.shape[2],f.shape[3],f.shape[4]]):f}});const To=Re({maxPoolWithArgmax_:function(e,t,n,r,o=!1){const s={x:_e(e,"x","maxPoolWithArgmax")},a={filterSize:t,strides:n,pad:r,includeBatchInIndex:o},i=De.runKernel("MaxPoolWithArgmax",s,a);return{result:i[0],indexes:i[1]}}});const $o=Re({maximum_:function(e,t){let n=_e(e,"a","maximum"),r=_e(t,"b","maximum");[n,r]=ye(n,r),"bool"===n.dtype&&(n=yt(n,"int32"),r=yt(r,"int32")),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("Maximum",o)}});const _o=Re({mean_:function(e,t=null,n=!1){const r={x:_e(e,"x","mean")},o={axis:t,keepDims:n};return De.runKernel("Mean",r,o)}});const Fo=Re({min_:function(e,t=null,n=!1){const r={x:_e(e,"x","min")},o={axis:t,keepDims:n};return De.runKernel("Min",r,o)}});const Ro=Re({minimum_:function(e,t){let n=_e(e,"a","minimum"),r=_e(t,"b","minimum");[n,r]=ye(n,r),"bool"===n.dtype&&(n=yt(n,"int32"),r=yt(r,"int32")),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("Minimum",o)}});const Co=Re({mirrorPad_:function(e,t,n){s("reflect"===n||"symmetric"===n,()=>`Invalid mode. Mode must be either reflect or symmetric. Got ${n}.`);const r=_e(e,"x","mirrorPad");if(0===r.rank)throw new Error("mirrorPad(scalar) is not defined. Pass non-scalar to mirrorPad");s(t.length===r.rank,()=>`Padding doesn't match input. Must be ${r.rank}. Got ${t.length}.`);const o="reflect"===n?1:0;for(let e=0;e<r.rank;e++)s(2===t[e].length,()=>"Invalid number of paddings. Must be length of 2 each."),s(t[e][0]>=0&&t[e][0]<=r.shape[e]-o&&t[e][1]>=0&&t[e][1]<=r.shape[e]-o,()=>`Padding in dimension ${e} cannot be greater than or equal to ${r.shape[e]-o} or less than 0 for input of shape `+r.shape);const a={paddings:t,mode:n},i={x:r};return De.runKernel("MirrorPad",i,a)}});const Bo=Re({mod_:function(e,t){let n=_e(e,"a","mod"),r=_e(t,"b","mod");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Mod",o)}});const Po=Re({square_:function(e){const t=_e(e,"x","square");return De.runKernel("Square",{x:t},{})}});const zo=Re({moments_:function(e,t=null,n=!1){const r=p(t,(e=_e(e,"x","moments")).shape),o=_o(e,r,n);let s=o.shape;n||(s=ko(o.shape,r));const a=Po(fo(yt(e,"float32"),Jn(o,s)));return{mean:o,variance:_o(a,r,n)}}});const Lo=Re({multiRNNCell_:function(e,t,n,r){const o=_e(t,"data","multiRNNCell"),s=Fe(n,"c","multiRNNCell"),a=Fe(r,"h","multiRNNCell");let i=o;const u=[];for(let t=0;t<e.length;t++){const n=e[t](i,s[t],a[t]);u.push(n[0]),u.push(n[1]),i=n[1]}const l=[],c=[];for(let e=0;e<u.length;e+=2)l.push(u[e]),c.push(u[e+1]);return[l,c]}});const qo=Re({multinomial_:function(e,t,n,r=!1){const o=_e(e,"logits","multinomial"),s=o.size,a=o.rank;if(s<2)throw new Error("Error in multinomial: you need at least 2 outcomes, but got "+s+".");if(a>2)throw new Error("Rank of probabilities must be 1 or 2, but is "+a);n=n||Math.random();const i={logits:1===a?Jn(o,[1,-1]):o},u={numSamples:t,seed:n,normalized:r},l=De.runKernel("Multinomial",i,u);return 1===a?Jn(l,[l.size]):l}});const Oo=Re({notEqual_:function(e,t){let n=_e(e,"a","notEqual"),r=_e(t,"b","notEqual");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("NotEqual",o)}});function Go(e,t="float32"){if("complex64"===t){const t=Go(e,"float32"),n=Go(e,"float32");return Ce(t,n)}const n=_(l(e),t);return De.makeTensor(n,e,t)}function Ko(e,t="float32"){if("complex64"===t){const t=Ko(e,"float32"),n=Go(e,"float32");return Ce(t,n)}const n=$(l(e),t);return De.makeTensor(n,e,t)}const Wo=Re({onesLike_:function(e){const t={x:_e(e,"x","onesLike")};return De.runKernel("OnesLike",t)}});const Uo=Re({outerProduct_:function(e,t){const n=_e(e,"v1","outerProduct"),r=_e(t,"v2","outerProduct");s(1===n.rank&&1===r.rank,()=>`Error in outerProduct: inputs must be rank 1, but got ranks ${n.rank} and ${r.rank}.`);const o=Jn(n,[-1,1]),a=Jn(r,[1,-1]);return Rt(o,a)}});const Vo=Re({pad_:function(e,t,n=0){const r=_e(e,"x","pad");if(0===r.rank)throw new Error("pad(scalar) is not defined. Pass non-scalar to pad");const o={paddings:t,constantValue:n},s={x:r};return De.runKernel("PadV2",s,o)}});const Ho=Re({pad1d_:function(e,t,n=0){return s(2===t.length,()=>"Invalid number of paddings. Must be length of 2."),Vo(e,[t],n)}});const jo=Re({pad2d_:function(e,t,n=0){return s(2===t.length&&2===t[0].length&&2===t[1].length,()=>"Invalid number of paddings. Must be length of 2 each."),Vo(e,t,n)}});const Jo=Re({pad3d_:function(e,t,n=0){return s(3===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length,()=>"Invalid number of paddings. Must be length of 2 each."),Vo(e,t,n)}});const Yo=Re({pad4d_:function(e,t,n=0){return s(4===t.length&&2===t[0].length&&2===t[1].length&&2===t[2].length&&2===t[3].length,()=>"Invalid number of paddings. Must be length of 2 each."),Vo(e,t,n)}});const Zo=Re({spaceToBatchND_:function(e,t,n){const r=_e(e,"x","spaceToBatchND");s(r.rank>=1+t.length,()=>`input rank ${r.rank} should be > than [blockShape] ${t.length}`),s(n.length===t.length,()=>`paddings.shape[0] ${n.length} must be equal to [blockShape] ${t.length}`),s(r.shape.reduce((e,r,o)=>o>0&&o<=t.length?e&&(r+n[o-1][0]+n[o-1][1])%t[o-1]==0:e,!0),()=>`input spatial dimensions ${r.shape.slice(1)} with paddings ${n.toString()} must be divisible by blockShapes ${t.toString()}`);const o={x:r},a={blockShape:t,paddings:n};return De.runKernel("SpaceToBatchND",o,a)}});const Xo=Re({pool_:function(e,t,n,r,o,a){null==o&&(o=[1,1]),null==a&&(a=1),0===r&&(r="valid");const i=_e(e,"x","maxPool");let u=i,l=!1;3===i.rank&&(l=!0,u=Jn(i,[1,i.shape[0],i.shape[1],i.shape[2]])),s(Hn(a,o),()=>`Error in pool: Either strides or dilations must be 1. Got strides ${a} and dilations '${o}'`);const c=zn(u.shape,t,a,o,r),h=[c.dilationHeight,c.dilationWidth];let d;d="same"===r?function(e,t){const n=e.map((e,n)=>e+(e-1)*(t[n]-1)).map(e=>e-1),r=n.map(e=>Math.floor(e/2)),o=n.map((e,t)=>e-r[t]);return n.map((e,t)=>[r[t],o[t]])}([c.filterHeight,c.filterWidth],h):[[0,0],[0,0]];const p=1===h[0]&&1===h[1],[f,m]=function(e,t,n){const r=n.map(e=>e[0]),o=n.map(e=>e[1]),s=e.concat(r,o),a=t.map((e,t)=>(e-s[t]%e)%e),i=o.map((e,t)=>e+a[t]),u=t.map((e,t)=>[r[t],i[t]]),l=t.map((e,t)=>[0,a[t]]);return[u,l]}([c.inHeight,c.inWidth],h,d),g=p?r:"valid",b=p?u:Zo(u,h,f),y=("avg"===n?()=>Yn(b,t,a,g):()=>Ao(b,t,a,g))(),w=p?y:rr(y,h,m);return l?Jn(w,[w.shape[1],w.shape[2],w.shape[3]]):w}});const Qo=Re({pow_:function(e,t){let n=_e(e,"base","pow"),r=_e(t,"exp","pow");[n,r]=ye(n,r);const o={a:n,b:r};return De.runKernel("Pow",o)}});const es=Re({prelu_:function(e,t){const n={x:_e(e,"x","prelu"),alpha:_e(t,"alpha","prelu")};return De.runKernel("Prelu",n)}});const ts=Re({prod_:function(e,t=null,n=!1){let r=_e(e,"x","prod");"bool"===r.dtype&&(r=yt(r,"int32"));const o={x:r},s={axis:t,keepDims:n};return De.runKernel("Prod",o,s)}});const ns=Re({rand_:function(e,t,n){const r=l(e);let o=null;if(null==n||"float32"===n)o=new Float32Array(r);else if("int32"===n)o=new Int32Array(r);else{if("bool"!==n)throw new Error("Unknown data type "+n);o=new Uint8Array(r)}for(let e=0;e<r;e++)o[e]=t();return De.makeTensor(o,e,n)}});"undefined"!=typeof globalThis?globalThis:"undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self&&self;function rs(e,t){return e(t={exports:{}},t.exports),t.exports}var os=rs((function(e){!function(e,t,n){function r(e){var t,n=this,r=(t=4022871197,function(e){e=e.toString();for(var n=0;n<e.length;n++){var r=.02519603282416938*(t+=e.charCodeAt(n));r-=t=r>>>0,t=(r*=t)>>>0,t+=4294967296*(r-=t)}return 2.3283064365386963e-10*(t>>>0)});n.next=function(){var e=2091639*n.s0+2.3283064365386963e-10*n.c;return n.s0=n.s1,n.s1=n.s2,n.s2=e-(n.c=0|e)},n.c=1,n.s0=r(" "),n.s1=r(" "),n.s2=r(" "),n.s0-=r(e),n.s0<0&&(n.s0+=1),n.s1-=r(e),n.s1<0&&(n.s1+=1),n.s2-=r(e),n.s2<0&&(n.s2+=1),r=null}function o(e,t){return t.c=e.c,t.s0=e.s0,t.s1=e.s1,t.s2=e.s2,t}function s(e,t){var n=new r(e),s=t&&t.state,a=n.next;return a.int32=function(){return 4294967296*n.next()|0},a.double=function(){return a()+11102230246251565e-32*(2097152*a()|0)},a.quick=a,s&&("object"==typeof s&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.alea=s}(0,e,!1)})),ss=rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.x=0,t.y=0,t.z=0,t.w=0,t.next=function(){var e=t.x^t.x<<11;return t.x=t.y,t.y=t.z,t.z=t.w,t.w^=t.w>>>19^e^e>>>8},e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),t.next()}function o(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t}function s(e,t){var n=new r(e),s=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,s&&("object"==typeof s&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.xor128=s}(0,e,!1)})),as=rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.x^t.x>>>2;return t.x=t.y,t.y=t.z,t.z=t.w,t.w=t.v,(t.d=t.d+362437|0)+(t.v=t.v^t.v<<4^e^e<<1)|0},t.x=0,t.y=0,t.z=0,t.w=0,t.v=0,e===(0|e)?t.x=e:n+=e;for(var r=0;r<n.length+64;r++)t.x^=0|n.charCodeAt(r),r==n.length&&(t.d=t.x<<10^t.x>>>4),t.next()}function o(e,t){return t.x=e.x,t.y=e.y,t.z=e.z,t.w=e.w,t.v=e.v,t.d=e.d,t}function s(e,t){var n=new r(e),s=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,s&&("object"==typeof s&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.xorwow=s}(0,e,!1)})),is=rs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.x,o=t.i;return e=r[o],n=(e^=e>>>7)^e<<24,n^=(e=r[o+1&7])^e>>>10,n^=(e=r[o+3&7])^e>>>3,n^=(e=r[o+4&7])^e<<7,e=r[o+7&7],n^=(e^=e<<13)^e<<9,r[o]=n,t.i=o+1&7,n},function(e,t){var n,r=[];if(t===(0|t))r[0]=t;else for(t=""+t,n=0;n<t.length;++n)r[7&n]=r[7&n]<<15^t.charCodeAt(n)+r[n+1&7]<<13;for(;r.length<8;)r.push(0);for(n=0;n<8&&0===r[n];++n);for(8==n?r[7]=-1:r[n],e.x=r,e.i=0,n=256;n>0;--n)e.next()}(t,e)}function o(e,t){return t.x=e.x.slice(),t.i=e.i,t}function s(e,t){null==e&&(e=+new Date);var n=new r(e),s=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,s&&(s.x&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.xorshift7=s}(0,e,!1)})),us=rs((function(e){!function(e,t,n){function r(e){var t=this;t.next=function(){var e,n,r=t.w,o=t.X,s=t.i;return t.w=r=r+1640531527|0,n=o[s+34&127],e=o[s=s+1&127],n^=n<<13,e^=e<<17,n^=n>>>15,e^=e>>>12,n=o[s]=n^e,t.i=s,n+(r^r>>>16)|0},function(e,t){var n,r,o,s,a,i=[],u=128;for(t===(0|t)?(r=t,t=null):(t+="\0",r=0,u=Math.max(u,t.length)),o=0,s=-32;s<u;++s)t&&(r^=t.charCodeAt((s+32)%t.length)),0===s&&(a=r),r^=r<<10,r^=r>>>15,r^=r<<4,r^=r>>>13,s>=0&&(a=a+1640531527|0,o=0==(n=i[127&s]^=r+a)?o+1:0);for(o>=128&&(i[127&(t&&t.length||0)]=-1),o=127,s=512;s>0;--s)r=i[o+34&127],n=i[o=o+1&127],r^=r<<13,n^=n<<17,r^=r>>>15,n^=n>>>12,i[o]=r^n;e.w=a,e.X=i,e.i=o}(t,e)}function o(e,t){return t.i=e.i,t.w=e.w,t.X=e.X.slice(),t}function s(e,t){null==e&&(e=+new Date);var n=new r(e),s=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,s&&(s.X&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.xor4096=s}(0,e,!1)})),ls=rs((function(e){!function(e,t,n){function r(e){var t=this,n="";t.next=function(){var e=t.b,n=t.c,r=t.d,o=t.a;return e=e<<25^e>>>7^n,n=n-r|0,r=r<<24^r>>>8^o,o=o-e|0,t.b=e=e<<20^e>>>12^n,t.c=n=n-r|0,t.d=r<<16^n>>>16^o,t.a=o-e|0},t.a=0,t.b=0,t.c=-1640531527,t.d=1367130551,e===Math.floor(e)?(t.a=e/4294967296|0,t.b=0|e):n+=e;for(var r=0;r<n.length+20;r++)t.b^=0|n.charCodeAt(r),t.next()}function o(e,t){return t.a=e.a,t.b=e.b,t.c=e.c,t.d=e.d,t}function s(e,t){var n=new r(e),s=t&&t.state,a=function(){return(n.next()>>>0)/4294967296};return a.double=function(){do{var e=((n.next()>>>11)+(n.next()>>>0)/4294967296)/(1<<21)}while(0===e);return e},a.int32=n.next,a.quick=a,s&&("object"==typeof s&&o(s,n),a.state=function(){return o(n,{})}),a}t&&t.exports?t.exports=s:n&&n.amd?n((function(){return s})):this.tychei=s}(0,e,!1)})),cs=rs((function(e){!function(t,n){var r,o=this,s=n.pow(256,6),a=n.pow(2,52),i=2*a;function u(e,u,p){var f=[],m=h(function e(t,n){var r,o=[],s=typeof t;if(n&&"object"==s)for(r in t)try{o.push(e(t[r],n-1))}catch(e){}return o.length?o:"string"==s?t:t+"\0"}((u=1==u?{entropy:!0}:u||{}).entropy?[e,d(t)]:null==e?function(){try{var e;return r&&(e=r.randomBytes)?e=e(256):(e=new Uint8Array(256),(o.crypto||o.msCrypto).getRandomValues(e)),d(e)}catch(e){var n=o.navigator,s=n&&n.plugins;return[+new Date,o,s,o.screen,d(t)]}}():e,3),f),g=new l(f),b=function(){for(var e=g.g(6),t=s,n=0;e<a;)e=256*(e+n),t*=256,n=g.g(1);for(;e>=i;)e/=2,t/=2,n>>>=1;return(e+n)/t};return b.int32=function(){return 0|g.g(4)},b.quick=function(){return g.g(4)/4294967296},b.double=b,h(d(g.S),t),(u.pass||p||function(e,t,r,o){return o&&(o.S&&c(o,g),e.state=function(){return c(g,{})}),r?(n.random=e,t):e})(b,m,"global"in u?u.global:this==n,u.state)}function l(e){var t,n=e.length,r=this,o=0,s=r.i=r.j=0,a=r.S=[];for(n||(e=[n++]);o<256;)a[o]=o++;for(o=0;o<256;o++)a[o]=a[s=255&s+e[o%n]+(t=a[o])],a[s]=t;(r.g=function(e){for(var t,n=0,o=r.i,s=r.j,a=r.S;e--;)t=a[o=255&o+1],n=256*n+a[255&(a[o]=a[s=255&s+t])+(a[s]=t)];return r.i=o,r.j=s,n})(256)}function c(e,t){return t.i=e.i,t.j=e.j,t.S=e.S.slice(),t}function h(e,t){for(var n,r=e+"",o=0;o<r.length;)t[255&o]=255&(n^=19*t[255&o])+r.charCodeAt(o++);return d(t)}function d(e){return String.fromCharCode.apply(0,e)}if(n.seedrandom=u,h(n.random(),t),e.exports){e.exports=u;try{r=require("crypto")}catch(e){}}}([],Math)}));cs.alea=os,cs.xor128=ss,cs.xorwow=as,cs.xorshift7=is,cs.xor4096=us,cs.tychei=ls;var hs=cs.alea;class ds{constructor(e,t,n,r,o){this.mean=e,this.stdDev=t,this.dtype=n,this.nextVal=NaN,this.truncated=r,this.truncated&&(this.upper=this.mean+2*this.stdDev,this.lower=this.mean-2*this.stdDev);const s=o||Math.random();this.random=hs(s.toString())}nextValue(){if(!isNaN(this.nextVal)){const e=this.nextVal;return this.nextVal=NaN,e}let e,t,n=!1;for(;!n;){let r,o,s;do{r=2*this.random()-1,o=2*this.random()-1,s=r*r+o*o}while(s>=1||0===s);const a=Math.sqrt(-2*Math.log(s)/s);e=this.mean+this.stdDev*r*a,t=this.mean+this.stdDev*o*a,this.truncated&&!this.isValidTruncated(e)||(n=!0)}return this.truncated&&!this.isValidTruncated(t)||(this.nextVal=this.convertValue(t)),this.convertValue(e)}convertValue(e){return null==this.dtype||"float32"===this.dtype?e:Math.round(e)}isValidTruncated(e){return e<=this.upper&&e>=this.lower}}class ps{constructor(e,t,n,r){this.alpha=e,this.beta=1/t,this.dtype=n;const o=r||Math.random();this.randu=hs(o.toString()),this.randn=new ds(0,1,n,!1,this.randu()),this.d=e<1?e+2/3:e-1/3,this.c=1/Math.sqrt(9*this.d)}nextValue(){let e,t,n,r,o,s;for(;;){do{r=this.randn.nextValue(),s=1+this.c*r}while(s<=0);if(s*=s*s,e=r*r,t=1-.331*e*e,n=.5*e+this.d*(1-s+Math.log(s)),o=this.randu(),o<t||Math.log(o)<n)break}return s=1/this.beta*this.d*s,this.alpha<1&&(s*=Math.pow(this.randu(),1/this.alpha)),this.convertValue(s)}convertValue(e){return"float32"===this.dtype?e:Math.round(e)}}class fs{constructor(e=0,t=1,n,r){if(this.canReturnFloat=()=>null==this.dtype||"float32"===this.dtype,this.min=e,this.range=t-e,this.dtype=n,null==r&&(r=Math.random()),"number"==typeof r&&(r=r.toString()),!this.canReturnFloat()&&this.range<=1)throw new Error(`The difference between ${e} - ${t} <= 1 and dtype is not float`);this.random=hs(r)}convertValue(e){return this.canReturnFloat()?e:Math.round(e)}nextValue(){return this.convertValue(this.min+this.range*this.random())}}const ms=Re({randomGamma_:function(e,t,n=1,r="float32",o){if(null==n&&(n=1),null==r&&(r="float32"),"float32"!==r&&"int32"!==r)throw new Error("Unsupported data type "+r);const s=new ps(t,n,r,o),a=bt(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=s.nextValue();return a.toTensor()}});const gs=Re({randomNormal_:function(e,t=0,n=1,r,o){if(null!=r&&"bool"===r)throw new Error("Unsupported data type "+r);const s=new ds(t,n,r,!1,o),a=bt(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=s.nextValue();return a.toTensor()}});const bs=Re({randomUniform_:function(e,t=0,n=1,r="float32",o){const s=bt(e,r),a=new fs(t,n,null,o);for(let e=0;e<s.values.length;e++)s.values[e]=a.nextValue();return s.toTensor()}});function ys(e,t,n=1,r="float32"){if(0===n)throw new Error("Cannot have a step of zero");const o={start:e,stop:t,step:n,dtype:r};return De.runKernel("Range",{},o)}const ws=Re({real_:function(e){const t={input:_e(e,"input","real")};return De.runKernel("Real",t)}});const ks=Re({reciprocal_:function(e){const t={x:_e(e,"x","reciprocal")};return De.runKernel("Reciprocal",t)}});const vs=Re({relu_:function(e){const t={x:_e(e,"x","relu")};return De.runKernel("Relu",t)}});const xs=Re({relu6_:function(e){const t={x:_e(e,"x","relu6")};return De.runKernel("Relu6",t)}});const Ss=Re({reverse_:function(e,t){const n={x:_e(e,"x","reverse")},r={dims:t};return De.runKernel("Reverse",n,r)}});const Es=Re({reverse1d_:function(e){const t=_e(e,"x","reverse");return s(1===t.rank,()=>`Error in reverse1D: x must be rank 1 but got rank ${t.rank}.`),Ss(t,0)}});const Ds=Re({reverse2d_:function(e,t){const n=_e(e,"x","reverse");return s(2===n.rank,()=>`Error in reverse2D: x must be rank 2 but got rank ${n.rank}.`),Ss(n,t)}});const Is=Re({reverse3d_:function(e,t){const n=_e(e,"x","reverse");return s(3===n.rank,()=>`Error in reverse3D: x must be rank 3 but got rank ${n.rank}.`),Ss(n,t)}});const Ns=Re({reverse4d_:function(e,t){const n=_e(e,"x","reverse");return s(4===n.rank,()=>`Error in reverse4D: x must be rank 4 but got rank ${n.rank}.`),Ss(n,t)}});const As=Re({round_:function(e){const t={x:_e(e,"x","round")};return De.runKernel("Round",t)}});const Ms=Re({rsqrt_:function(e){const t={x:_e(e,"x","rsqrt")};return De.runKernel("Rsqrt",t)}});function Ts(e,t){if((k(e)&&"string"!==t||Array.isArray(e))&&"complex64"!==t)throw new Error("Error creating a new Scalar: value must be a primitive (number|boolean|string)");if("string"===t&&k(e)&&!(e instanceof Uint8Array))throw new Error("When making a scalar from encoded string, the value must be `Uint8Array`.");return Be(e,[],[],t)}const $s=Re({selu_:function(e){const t={x:_e(e,"x","selu")};return De.runKernel("Selu",t)}});const _s=Re({separableConv2d_:function(e,t,n,r,o,a=[1,1],i="NHWC"){const u=_e(e,"x","separableConv2d"),l=_e(t,"depthwiseFilter","separableConv2d"),c=_e(n,"pointwiseFilter","separableConv2d");let h=u,d=!1;if(3===u.rank&&(d=!0,h=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2]])),"NCHW"===i)throw new Error("separableConv2d currently does not support dataFormat NCHW; only NHWC is supported");s(4===h.rank,()=>`Error in separableConv2d: input must be rank 4, but got rank ${h.rank}.`),s(4===l.rank,()=>`Error in separableConv2d: depthwise filter must be rank 4, but got rank ${l.rank}.`),s(4===c.rank,()=>`Error in separableConv2d: pointwise filter must be rank 4, but got rank ${l.rank}.`),s(1===c.shape[0],()=>`Error in separableConv2d: the first dimension of pointwise filter  must be 1, but got ${c.shape[0]}.`),s(1===c.shape[1],()=>`Error in separableConv2d: the second dimension of pointwise filter must be 1, but got ${c.shape[1]}.`);const p=l.shape[2],f=l.shape[3];s(c.shape[2]===p*f,()=>`Error in separableConv2d: the third dimension of pointwise filter must be ${p*f}, but got ${c.shape[2]}.`);const m=Ar(h,l,r,o,i,a),g=gr(m,c,1,"valid",i);return d?Jn(g,[g.shape[1],g.shape[2],g.shape[3]]):g}});const Fs=async function(e,t){const n=_e(e,"x","setdiff1d"),r=_e(t,"y","setdiff1d");s(n.dtype===r.dtype,()=>`x and y should have the same dtype, but got x (${n.dtype}) and y (${r.dtype}).`),s(1===n.rank,()=>`x should be 1D tensor, but got x (${n.shape}).`),s(1===r.rank,()=>`y should be 1D tensor, but got y (${r.shape}).`);const o=await n.data(),a=await r.data(),i=new Set(a);let u=0;for(let e=0;e<o.length;e++)i.has(o[e])||u++;const l=new ae([u],n.dtype),c=new ae([u],"int32");for(let e=0,t=0;e<o.length;e++)i.has(o[e])||(l.values[t]=o[e],c.values[t]=e,t++);return[l.toTensor(),c.toTensor()]};const Rs=Re({sign_:function(e){const t={x:_e(e,"x","sign")};return De.runKernel("Sign",t)}});const Cs=Re({sin_:function(e){const t={x:_e(e,"x","sin")};return De.runKernel("Sin",t)}});const Bs=Re({sinh_:function(e){const t={x:_e(e,"x","sinh")};return De.runKernel("Sinh",t)}});const Ps=Re({slice1d_:function(e,t,n){const r=_e(e,"x","slice1d");return s(1===r.rank,()=>`slice1d expects a rank-1 tensor, but got a rank-${r.rank} tensor`),er(r,[t],[n])}});const zs=Re({slice2d_:function(e,t,n){const r=_e(e,"x","slice2d");return s(2===r.rank,()=>`slice2d expects a rank-2 tensor, but got a rank-${r.rank} tensor`),er(r,t,n)}});const Ls=Re({slice3d_:function(e,t,n){const r=_e(e,"x","slice3d");return s(3===r.rank,()=>`slice3d expects a rank-3 tensor, but got a rank-${r.rank} tensor`),er(r,t,n)}});const qs=Re({slice4d_:function(e,t,n){const r=_e(e,"x","slice4d");return s(4===r.rank,()=>`slice4d expects a rank-4 tensor, but got a rank-${r.rank} tensor`),er(r,t,n)}});const Os=Re({softmax_:function(e,t=-1){const n=_e(e,"logits","softmax","float32");if(-1===t&&(t=n.rank-1),t!==n.rank-1)throw Error(`Softmax along a non-last dimension is not yet supported. Logits was rank ${n.rank} and dim was ${t}`);const r={logits:n},o={dim:t};return De.runKernel("Softmax",r,o)}});const Gs=Re({fft_:function(e){s("complex64"===e.dtype,()=>`The dtype for tf.spectral.fft() must be complex64 but got ${e.dtype}.`);const t={input:e};return De.runKernel("FFT",t)}});const Ks=Re({ifft_:function(e){s("complex64"===e.dtype,()=>`The dtype for tf.spectral.ifft() must be complex64 but got ${e.dtype}.`);const t={input:e};return De.runKernel("IFFT",t)}});const Ws=Re({irfft_:function(e){const t=e.shape[e.shape.length-1],n=e.size/t;let r;if(t<=2){const o=Jn(e,[n,t]);r=Ks(o)}else{const o=[n,2*(t-1)],s=Jn(ws(e),[n,t]),a=Jn(Yr(e),[n,t]),i=Ss(er(s,[0,1],[n,t-2]),1),u=En(Ss(er(a,[0,1],[n,t-2]),1),Ts(-1)),l=Xn([s,i],1),c=Xn([a,u],1),h=Jn(Ce(l,c),[o[0],o[1]]);r=Ks(h)}if(r=ws(r),3===e.rank&&0!==e.shape[0]){const t=r,n=e.shape[0];r=Jn(r,[n,r.shape[0]/n,r.shape[1]]),t.dispose()}return r}});const Us=Re({split_:function(e,t,n=0){const r={x:_e(e,"x","split")},o={numOrSizeSplits:t,axis:n};return De.runKernel("SplitV",r,o)}});const Vs=Re({rfft_:function(e,t){s("float32"===e.dtype,()=>"The dtype for rfft() must be real value but got "+e.dtype);let n=e.shape[e.shape.length-1];const r=e.size/n;let o;if(null!=t&&t<n){const r=e.shape.map(e=>0),s=e.shape.map(e=>e);s[e.shape.length-1]=t,o=er(e,r,s),n=t}else if(null!=t&&t>n){const r=e.shape.map(e=>e);r[e.shape.length-1]=t-n,o=Xn([e,Go(r)],e.shape.length-1),n=t}else o=e;const a=Cr(o),i=Jn(Ce(o,a),[r,n]),u=Gs(i),l=Math.floor(n/2)+1,c=ws(u),h=Yr(u),d=Us(c,[l,n-l],c.shape.length-1),p=Us(h,[l,n-l],h.shape.length-1),f=o.shape.slice();return f[o.shape.length-1]=l,Jn(Ce(d[0],p[0]),f)}});const Hs=Re({sqrt_:function(e){const t={x:_e(e,"x","sqrt")};return De.runKernel("Sqrt",t)}});const js=Re({squaredDifference_:function(e,t){let n=_e(e,"a","squaredDifference"),r=_e(t,"b","squaredDifference");[n,r]=ye(n,r),_r(n.shape,r.shape);const o={a:n,b:r};return De.runKernel("SquaredDifference",o,{})}});const Js=Re({squeeze_:function(e,t){const n=_e(e,"x","squeeze");return Jn(n,f(n.shape,t).newShape)}});const Ys=Re({stack_:function(e,t=0){const n=Fe(e,"tensors","stack","string_or_numeric");s(n.length>=1,()=>"Pass at least one tensor to tf.stack"),n.length>0&&s(t<=n[0].rank,()=>"Axis must be <= rank of the tensor");const r=n,o={axis:t};return De.runKernel("Pack",r,o)}});const Zs=Re({step_:function(e,t=0){const n={x:_e(e,"x","step")},r={alpha:t};return De.runKernel("Step",n,r)}});const Xs=Re({stridedSlice_:function(e,t,n,r,o=0,s=0,a=0,i=0,u=0){const l={x:_e(e,"x","stridedSlice")},c={begin:t,end:n,strides:r,beginMask:o,endMask:s,ellipsisMask:a,newAxisMask:i,shrinkAxisMask:u};return De.runKernel("StridedSlice",l,c)}});const Qs=Re({tan_:function(e){const t={x:_e(e,"x","tan")};return De.runKernel("Tan",t)}});function ea(e,t){i(e);const n=Te(e,t);if(1!==n.length)throw new Error("tensor1d() requires values to be a flat/TypedArray");return Be(e,null,n,t)}function ta(e,t,n){if(i(e),null!=t&&2!==t.length)throw new Error("tensor2d() requires shape to have two numbers");const r=Te(e,n);if(2!==r.length&&1!==r.length)throw new Error("tensor2d() requires values to be number[][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor2d() requires shape to be provided when `values` are a flat/TypedArray");return Be(e,t,r,n)}const na=Re({topk_:function(e,t=1,n=!0){const r=_e(e,"x","topk");if(0===r.rank)throw new Error("topk() expects the input to be of rank 1 or higher");const o=r.shape[r.shape.length-1];if(t>o)throw new Error(`'k' passed to topk() must be <= the last dimension (${o}) but got `+t);const s={x:r},a={k:t,sorted:n},[i,u]=De.runKernel("TopK",s,a);return{values:i,indices:u}}});const ra=Re({truncatedNormal_:function(e,t=0,n=1,r,o){if(null!=r&&"bool"===r)throw new Error("Unsupported data type $ { dtype }");const s=new ds(t,n,r,!0,o),a=bt(e,r);for(let e=0;e<a.values.length;e++)a.values[e]=s.nextValue();return a.toTensor()}});const oa=Re({unique_:function(e,t=0){const n=_e(e,"x","unique","string_or_numeric");s(n.rank>0,()=>"The input tensor must be at least 1D");const r={x:n},o={axis:t},[a,i]=De.runKernel("Unique",r,o);return{values:a,indices:i}}});const sa=Re({unsortedSegmentSum_:function(e,t,n){const r=_e(e,"x","unsortedSegmentSum"),o=_e(t,"segmentIds","unsortedSegmentSum","int32");s(h(n),()=>"numSegments must be of dtype int");const a={x:r,segmentIds:o},i={numSegments:n};return De.runKernel("UnsortedSegmentSum",a,i)}});const aa=Re({unstack_:function(e,t=0){const n=_e(e,"x","unstack","string_or_numeric");s(t>=-n.shape.length&&t<n.shape.length,()=>`Axis = ${t} is not in [-${n.shape.length}, ${n.shape.length})`);const r={value:n},o={axis:t};return De.runKernel("Unpack",r,o)}});function ia(e,t){const n=[];for(let e=0;e<t.length;e++)t[e]&&n.push(e);const r=bt(e,"int32"),o=bt([n.length,e.length],"int32");for(let t=0;t<n.length;t++){const s=r.indexToLoc(n[t]),a=t*e.length;o.values.set(s,a)}return o.toTensor()}const ua=async function(e){const t=_e(e,"condition","whereAsync","bool"),n=await t.data(),r=ia(t.shape,n);return e!==t&&t.dispose(),r};const la=async function(e,t,n){const r=_e(e,"tensor","boolMask"),o=_e(t,"mask","boolMask","bool"),i=null==n?0:n,u=o.rank,l=r.shape;s(u>0,()=>"mask cannot be scalar"),a(l.slice(i,i+u),o.shape,"mask's shape must match the first K dimensions of tensor's shape,");let c=1;for(let e=i;e<i+u;e++)c*=l[e];const h=l.slice(0,i).concat([c],l.slice(i+u)),d=Jn(r,h),p=Jn(o,[-1]),f=await ua(p),m=Js(f,[1]),g=Hr(d,m,i);return e!==r&&r.dispose(),t!==o&&o.dispose(),m.dispose(),d.dispose(),p.dispose(),f.dispose(),g};const ca=Re({equalStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","equalStrict"),r=_e(t,"b","equalStrict");return a(n.shape,r.shape,"Error in equalStrict: "),Fr(n,r)}}),ha=Re({greaterEqualStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","greaterEqualStrict"),r=_e(t,"b","greaterEqualStrict");return a(n.shape,r.shape,"Error in greaterEqualStrict: "),Jr(n,r)}}),da=Re({greaterStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","greaterStrict"),r=_e(t,"b","greaterStrict");return a(n.shape,r.shape,"Error in greaterStrict: "),jr(n,r)}}),pa=Re({lessEqualStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","lessEqualStrict"),r=_e(t,"b","lessEqualStrict");return a(n.shape,r.shape,"Error in lessEqualStrict: "),no(n,r)}}),fa=Re({lessStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","lessStrict"),r=_e(t,"b","lessStrict");return a(n.shape,r.shape,"Error in lessStrict: "),to(n,r)}}),ma=Re({notEqualStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","notEqualStrict"),r=_e(t,"b","notEqualStrict");return a(n.shape,r.shape,"Error in notEqualStrict: "),Oo(n,r)}});const ga=Re({addStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","addStrict"),r=_e(t,"b","addStrict");return a(n.shape,r.shape,"Error in addStrict: "),vn(n,r)}}),ba=Re({divStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","div"),r=_e(t,"b","div");return a(n.shape,r.shape,"Error in divideStrict: "),Sn(n,r)}}),ya=Re({maximumStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","maximumStrict"),r=_e(t,"b","maximumStrict");return a(n.shape,r.shape,"Error in maximumStrict: "),$o(n,r)}}),wa=Re({minimumStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","minimumStrict"),r=_e(t,"b","minimumStrict");return a(n.shape,r.shape,"Error in minimumStrict: "),Ro(n,r)}}),ka=Re({modStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","modStrict"),r=_e(t,"b","modStrict");return a(n.shape,r.shape,"Error in modStrict: "),Bo(n,r)}}),va=Re({mulStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","mul"),r=_e(t,"b","mul");return a(n.shape,r.shape,"Error in multiplyStrict: "),En(n,r)}}),xa=Re({powStrict_:function(e,t){return bn("strict variants of ops have been deprecated and will be removed in future"),a(e.shape,t.shape,"Error in powStrict: "),Qo(e,t)}}),Sa=Re({squaredDifferenceStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","squaredDifferenceStrict"),r=_e(t,"b","squaredDifferenceStrict");return a(n.shape,r.shape,"Error in squaredDifferenceStrict: "),js(n,r)}}),Ea=Re({subStrict_:function(e,t){bn("strict variants of ops have been deprecated and will be removed in future");const n=_e(e,"a","subStrict"),r=_e(t,"b","subStrict");return a(n.shape,r.shape,"Error in subStrict: "),fo(n,r)}});const Da=Re({norm_:function(e,t="euclidean",n=null,r=!1){const o=function e(t,n,r=null){if(0===t.rank)return Dn(t);if(1!==t.rank&&null===r)return e(Jn(t,[-1]),n,r);if(1===t.rank||"number"==typeof r||Array.isArray(r)&&1===r.length){if(1===n)return mo(Dn(t),r);if(n===1/0)return po(Dn(t),r);if(n===-1/0)return Fo(Dn(t),r);if("euclidean"===n||2===n)return Hs(mo(Qo(Dn(t),Ts(2,"int32")),r));throw new Error("Error in norm: invalid ord value: "+n)}if(Array.isArray(r)&&2===r.length){if(1===n)return po(mo(Dn(t),r[0]),r[1]-1);if(n===1/0)return po(mo(Dn(t),r[1]),r[0]);if(n===-1/0)return Fo(mo(Dn(t),r[1]),r[0]);if("fro"===n||"euclidean"===n)return Hs(mo(Po(t),r));throw new Error("Error in norm: invalid ord value: "+n)}throw new Error("Error in norm: invalid axis: "+r)}(e=_e(e,"x","norm"),t,n);let s=o.shape;if(r){const t=p(n,e.shape);s=ko(o.shape,t)}return Jn(o,s)}});const Ia=Re({movingAverage_:function(e,t,n,r,o=!0){const a=_e(e,"v","movingAverage"),i=_e(t,"x","movingAverage"),u=_e(n,"decay","movingAverage");we(a,i),s(c(a.shape,i.shape),()=>"Shape mismatch in v and x");const l=Ts(1),h=fo(l,u);let d=En(fo(i,a),h);if(o){s(null!=r,()=>"When using zeroDebias: true, step is required.");const e=_e(r,"step","movingAverage");d=Sn(d,fo(l,Qo(u,e)))}return vn(a,d)}});const Na=Re({scatterND_:function(e,t,n){const r=_e(e,"indices","scatterND","int32"),o=_e(t,"updates","scatterND");Vt(o,r,n);const s={indices:r,updates:o},a={shape:n};return De.runKernel("ScatterNd",s,a)}});const Aa=Re({sparseToDense_:function(e,t,n,r=0){const o=_e(e,"sparseIndices","sparseToDense","int32"),s=_e(t,"sparseValues","sparseToDense"),a=_e(r,"defaultValue","sparseToDense",s.dtype);!function(e,t,n,r){if("int32"!==e.dtype)throw new Error(`tf.sparseToDense() expects the indices to be int32 type, but the dtype was ${e.dtype}.`);if(e.rank>2)throw new Error(`sparseIndices should be a scalar, vector, or matrix, but got shape ${e.shape}.`);const o=e.rank>0?e.shape[0]:1,s=e.rank>1?e.shape[1]:1;if(n.length!==s)throw new Error(`outputShape has incorrect number of elements:, ${n.length}, should be: ${s}.`);const a=t.size;if(0!==t.rank&&(1!==t.rank||a!==o))throw new Error(`sparseValues has incorrect shape ${t.shape}, should be [] or [${o}]`);if(t.dtype!==r.dtype)throw new Error("sparseValues.dtype must match defaultValues.dtype")}(o,s,n,a);const i={sparseIndices:o,sparseValues:s,defaultValue:a},u={outputShape:n};return De.runKernel("SparseToDense",i,u)}});const Ma=Re({gatherND_:function(e,t){const n=_e(t,"indices","gatherND","int32"),r={params:_e(e,"x","gatherND"),indices:n};return De.runKernel("GatherNd",r)}});const Ta=Re({dropout_:function(e,t,n,r){const o=_e(e,"x","dropout");if(s("float32"===o.dtype,()=>`x has to be a floating point tensor since it's going to be scaled, but got a ${o.dtype} tensor instead.`),s(t>=0&&t<1,()=>`rate must be a float in the range [0, 1), but got ${t}.`),0===t)return e instanceof le?o.clone():o;const a=function(e,t){if(null==t)return e.shape.slice();if(c(e.shape,t))return t;if(e.shape.length===t.length){const n=[];for(let r=0;r<e.shape.length;r++)null==t[r]&&null!=e.shape[r]?n.push(e.shape[r]):n.push(t[r]);return n}return t}(o,n),i=1-t,u=Sn(Vr(vn(bs(a,0,1,"float32",r),i)),i);return En(o,u)}});function $a(e){return Math.floor(Math.pow(2,Math.ceil(Math.log(e)/Math.log(2))))}function _a(e,t,n){const r=1-e%2,o=new Float32Array(e);for(let s=0;s<e;++s){const a=2*Math.PI*s/(e+r-1);o[s]=t-n*Math.cos(a)}return ea(o,"float32")}const Fa=async function(e,t,n=1){const r=_e(e,"predictions","inTopK"),o=_e(t,"targets","inTopK");s(r.rank>1,()=>"inTopK() expects the predictions to be of rank 2 or higher, but got "+r.rank),s(r.rank-1===o.rank,()=>`predictions rank should be 1 larger than targets rank, but got predictions rank ${r.rank} and targets rank ${o.rank}`),a(r.shape.slice(0,r.shape.length-1),o.shape,"predictions's shape should be align with the targets' shape, except the last dimension.");const i=r.shape[r.shape.length-1];s(n>0&&n<=i,()=>`'k' passed to inTopK() must be > 0 && <= the predictions last dimension (${i}), but got ${n}`);const u=await r.data(),l=await o.data(),[c,h]=[u.length/i,i],d=m("bool",c);for(let e=0;e<c;e++){const t=e*h,r=u.subarray(t,t+h),o=[];for(let e=0;e<r.length;e++)o.push({value:r[e],index:e});o.sort((e,t)=>t.value-e.value),d[e]=0;for(let t=0;t<n;t++)if(o[t].index===l[e]){d[e]=1;break}}return e!==r&&r.dispose(),t!==o&&o.dispose(),Pe(d,o.shape,"bool")};const Ra=Re({conv2DBackpropFilter_:function(e,t,n,r,o,a="NHWC",i){let u=e;3===e.rank&&(u=Jn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let l=t;3===l.rank&&(l=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2]])),s(4===u.rank,()=>"Error in conv2dDerFilter: input must be rank 4, but got shape "+u.shape+"."),s(4===l.rank,()=>"Error in conv2dDerFilter: dy must be rank 4, but got shape "+l.shape+"."),s(4===n.length,()=>"Error in conv2dDerFilter: filterShape must be length 4, but got "+n+".");const c="NHWC"===a?u.shape[3]:u.shape[1],d="NHWC"===a?l.shape[3]:l.shape[1];s(c===n[2],()=>`Error in conv2dDerFilter: depth of input ${c}) must match input depth in filter (${n[2]}.`),s(d===n[3],()=>`Error in conv2dDerFilter: depth of dy (${d}) must match output depth for filter (${n[3]}).`),null!=i&&s(h(o),()=>`Error in conv2dDerFilter: pad must be an integer when using, dimRoundingMode ${i} but got pad ${o}.`);const p={x:u,dy:l},f={strides:r,pad:o,dataFormat:a,dimRoundingMode:i,filterShape:n};return De.runKernel("Conv2DBackpropFilter",p,f)}});function Ca(e,t,n){if(null==n||"linear"===n)return e;if("relu"===n)return En(e,Zs(t));throw new Error(`Cannot compute gradient for fused activation ${n}.`)}function Ba(e,t){let n=t;const r=$r(e.shape,t.shape);return r.length>0&&(n=mo(n,r)),Jn(n,e.shape)}function Pa(e,t,n,r){if("linear"===t)return e;if("relu"===t)return vs(e);if("elu"===t)return zr(e);if("relu6"===t)return xs(e);if("prelu"===t)return es(e,n);if("leakyrelu"===t)return eo(e,r);throw new Error(`Unknown fused activation ${t}.`)}const za=(e,t)=>!(e>0)||"linear"===t;const La=Re({fusedConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:o="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:u,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:d}){if(l=l||"linear",!1===za(De.state.gradientDepth,l)){let s=gr(e,t,n,r,o,a,i);return null!=u&&(s=vn(s,u)),Pa(s,l,c,d)}const p=_e(e,"x","conv2d"),f=_e(t,"filter","conv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Jn(p,[1,p.shape[0],p.shape[1],p.shape[2]])),s(4===m.rank,()=>"Error in fused conv2d: input must be rank 4, but got rank "+m.rank+"."),s(4===f.rank,()=>"Error in fused conv2d: filter must be rank 4, but got rank "+f.rank+"."),null!=i&&s(h(r),()=>`Error in fused conv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${r}.`),s(m.shape[3]===f.shape[2],()=>`Error in conv2d: depth of input (${m.shape[3]}) must match input depth for filter ${f.shape[2]}.`),s(Hn(n,a),()=>`Error in conv2D: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),s("NHWC"===o,()=>`Error in conv2d: got dataFormat of ${o} but only NHWC is currently supported.`);const b=Ln(m.shape,f.shape,n,a,r,i);let y,w;null!=u&&(y=_e(u,"bias","fused conv2d"),[y]=ye(y,p),_r(b.outShape,y.shape)),null!=c&&(w=_e(c,"prelu weights","fused conv2d"));const k=(e,t)=>{const[o,i,u,c]=t,h=Ca(e,u,l);s(Vn(a),()=>`Error in gradient of fused conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`);const d=[yr(i.shape,h,o,n,r),Ra(i,h,o.shape,n,r)];if(null!=c){const e=Ba(c,h);d.push(e)}return d},v={x:m,filter:f,bias:y,preluActivationWeights:w},x={strides:n,pad:r,dataFormat:o,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:d};if(null==u){return io((e,t,n)=>{let r=De.runKernel("FusedConv2D",v,x);return n([t,e,r]),g&&(r=Jn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:k}})(m,f)}return io((e,t,n,r)=>{let o=De.runKernel("FusedConv2D",v,x);return r([t,e,o,n]),g&&(o=Jn(o,[o.shape[1],o.shape[2],o.shape[3]])),{value:o,gradFunc:k}})(m,f,y)}});const qa=Re({depthwiseConv2dNativeBackpropFilter_:function(e,t,n,r,o,s=[1,1],a){let i=e;3===e.rank&&(i=Jn(e,[1,e.shape[0],e.shape[1],e.shape[2]]));let u=t;3===u.rank&&(u=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const l={x:i,dy:u},c={strides:r,pad:o,dimRoundingMode:a,dilations:s,filterShape:n};return De.runKernel("DepthwiseConv2dNativeBackpropFilter",l,c)}});const Oa=Re({depthwiseConv2dNativeBackpropInput_:function(e,t,n,r,o,s=[1,1],a){let i=t,u=!1;3===t.rank&&(u=!0,i=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2]]));const l={dy:i,filter:n},c={strides:r,pad:o,dimRoundingMode:a,dilations:s,inputShape:e},h=De.runKernel("DepthwiseConv2dNativeBackpropInput",l,c);return u?Jn(h,[h.shape[1],h.shape[2],h.shape[3]]):h}});const Ga=Re({fusedDepthwiseConv2d_:function({x:e,filter:t,strides:n,pad:r,dataFormat:o="NHWC",dilations:a=[1,1],dimRoundingMode:i,bias:u,activation:l="linear",preluActivationWeights:c,leakyreluAlpha:d}){if(!1===za(De.state.gradientDepth,l)){let s=Ar(e,t,n,r,o,a,i);return null!=u&&(s=vn(s,u)),Pa(s,l,c,d)}const p=_e(e,"x","depthwiseConv2d"),f=_e(t,"filter","depthwiseConv2d");let m=p,g=!1;3===p.rank&&(g=!0,m=Jn(p,[1,p.shape[0],p.shape[1],p.shape[2]])),s(4===m.rank,()=>`Error in fused depthwiseConv2d: input must be rank 4, but got rank ${m.rank}.`),s(4===f.rank,()=>`Error in fused depthwiseConv2d: filter must be rank 4, but got rank ${f.rank}.`),s(m.shape[3]===f.shape[2],()=>`Error in fused depthwiseConv2d: number of input channels (${m.shape[3]}) must match the inChannels dimension in filter ${f.shape[2]}.`),null==a&&(a=[1,1]),s(Hn(n,a),()=>`Error in fused depthwiseConv2d: Either strides or dilations must be 1. Got strides ${n} and dilations '${a}'`),null!=i&&s(h(r),()=>`Error in fused depthwiseConv2d: pad must be an integer when using dimRoundingMode ${i} but got pad ${r}.`);const b=Ln(m.shape,f.shape,n,a,r,i,!0);let y,w;null!=u&&(y=_e(u,"bias","fused conv2d"),[y]=ye(y,p),_r(b.outShape,y.shape)),null!=c&&(w=_e(c,"prelu weights","fused depthwiseConv2d"));const k=(e,t)=>{s(Vn(a),()=>`Error in gradient of fused depthwiseConv2d: dilation rates greater than 1 are not yet supported. Got dilations '${a}'`);const[o,u,c,h]=t,d=Ca(e,c,l),p=Oa(u.shape,d,o,n,r,a,i),f=qa(u,d,o.shape,n,r,a,i);if(null!=h){return[p,f,Ba(y,d)]}return[p,f]},v={x:m,filter:f,bias:y,preluActivationWeights:w},x={strides:n,pad:r,dataFormat:o,dilations:a,dimRoundingMode:i,activation:l,leakyreluAlpha:d};if(null==u){return io((e,t,n)=>{let r=De.runKernel("FusedDepthwiseConv2D",v,x);return n([t,e,r]),g&&(r=Jn(r,[r.shape[1],r.shape[2],r.shape[3]])),{value:r,gradFunc:k}})(m,f)}return io((e,t,n,r)=>{let o=De.runKernel("FusedDepthwiseConv2D",v,x);return r([t,e,o,n]),g&&(o=Jn(o,[o.shape[1],o.shape[2],o.shape[3]])),{value:o,gradFunc:k}})(m,f,y)}});const Ka=Re({fusedMatMul_:function({a:e,b:t,transposeA:n=!1,transposeB:r=!1,bias:o,activation:a="linear",preluActivationWeights:i,leakyreluAlpha:u}){if(!1===za(De.state.gradientDepth,a)){let s=Rt(e,t,n,r);return null!=o&&(s=vn(s,o)),Pa(s,a,i,u)}let h=_e(e,"a","fused matMul"),d=_e(t,"b","fused matMul");[h,d]=ye(h,d);const p=n?h.shape[h.rank-2]:h.shape[h.rank-1],f=r?d.shape[d.rank-1]:d.shape[d.rank-2],m=n?h.shape[h.rank-1]:h.shape[h.rank-2],g=r?d.shape[d.rank-2]:d.shape[d.rank-1],b=h.shape.slice(0,-2),y=d.shape.slice(0,-2),w=l(b),k=l(y);s(h.rank>=2&&d.rank>=2&&h.rank===d.rank,()=>`Error in fused matMul: inputs must have the same rank of at least 2, got ranks ${h.rank} and ${d.rank}.`),s(c(b,y),()=>`Error in fused matMul: outer dimensions (${b}) and (${y}) of Tensors with shapes ${h.shape} and `+d.shape+" must match."),s(p===f,()=>`Error in fused matMul: inner shapes (${p}) and (${f}) of Tensors with shapes ${h.shape} and ${d.shape} and transposeA=${n} and transposeB=${r} must match.`);const v=h.shape.slice(0,-2).concat([m,g]),x=Jn(h,n?[w,p,m]:[w,m,p]),S=Jn(d,r?[k,g,f]:[k,f,g]);let E,D;null!=o&&(E=_e(o,"bias","fused matMul"),[E]=ye(E,h),_r(v,E.shape)),null!=i&&(D=_e(i,"prelu weights","fused matMul"));const I=(e,t)=>{const[s,i,u,l]=t,c=Ca(Jn(e,u.shape),u,a);let h,d;if(n||r?!n&&r?(h=Rt(c,i,!1,!1),d=Rt(c,s,!0,!1)):n&&!r?(h=Rt(i,c,!1,!0),d=Rt(s,c,!1,!1)):(h=Rt(i,c,!0,!0),d=Rt(c,s,!0,!0)):(h=Rt(c,i,!1,!0),d=Rt(s,c,!0,!1)),null!=o){return[h,d,Ba(l,c)]}return[h,d]},N={a:x,b:S,bias:E,preluActivationWeights:D},A={transposeA:n,transposeB:r,activation:a,leakyreluAlpha:u};if(null==o){return io((e,t,n)=>{const r=De.runKernel("_FusedMatMul",N,A);return n([e,t,r]),{value:Jn(r,v),gradFunc:I}})(x,S)}return io((e,t,n,r)=>{const o=De.runKernel("_FusedMatMul",N,A);return r([e,t,o,n]),{value:Jn(o,v),gradFunc:I}})(x,S,E)}});var Wa=Object.freeze({__proto__:null,conv2d:La,depthwiseConv2d:Ga,matMul:Ka});const Ua=Re({hammingWindow_:function(e){return _a(e,.54,.46)}});const Va=Re({hannWindow_:function(e){return _a(e,.5,.5)}});const Ha=Re({frame_:function(e,t,n,r=!1,o=0){let s=0;const a=[];for(;s+t<=e.size;)a.push(er(e,s,t)),s+=n;if(r)for(;s<e.size;){const r=s+t-e.size,i=Xn([er(e,s,t-r),Ur([r],o)]);a.push(i),s+=n}return 0===a.length?ta([],[0,t]):Jn(Xn(a),[a.length,t])}});const ja=Re({stft_:function(e,t,n,r,o=Va){null==r&&(r=$a(t));const s=Ha(e,t,n),a=En(s,o(t)),i=[];for(let e=0;e<s.shape[0];e++)i.push(Vs(er(a,[e,0],[1,t]),r));return Xn(i)}});const Ja=Re({cropAndResize_:function(e,t,n,r,o="bilinear",a=0){const i=_e(e,"image","cropAndResize"),u=_e(t,"boxes","cropAndResize","float32"),l=_e(n,"boxInd","cropAndResize","int32"),c=u.shape[0];s(4===i.rank,()=>`Error in cropAndResize: image must be rank 4,but got rank ${i.rank}.`),s(2===u.rank&&4===u.shape[1],()=>`Error in cropAndResize: boxes must be have size [${c},4] but had shape ${u.shape}.`),s(1===l.rank&&l.shape[0]===c,()=>`Error in cropAndResize: boxInd must be have size [${c}] but had shape ${u.shape}.`),s(2===r.length,()=>`Error in cropAndResize: cropSize must be of length 2, but got length ${r.length}.`),s(r[0]>=1&&r[1]>=1,()=>"cropSize must be atleast [1,1], but was "+r),s("bilinear"===o||"nearest"===o,()=>"method must be bilinear or nearest, but was "+o);const h={image:i,boxes:u,boxInd:l},d={method:o,extrapolationValue:a,cropSize:r};return De.runKernel("CropAndResize",h,d)}});const Ya=Re({flipLeftRight_:function(e){const t=_e(e,"image","flipLeftRight","float32");s(4===t.rank,()=>`Error in flipLeftRight: image must be rank 4,but got rank ${t.rank}.`);const n={image:t};return De.runKernel("FlipLeftRight",n,{})}});const Za=Re({rotateWithOffset_:function(e,t,n=0,r=.5){const o=_e(e,"image","rotateWithOffset","float32");s(4===o.rank,()=>`Error in rotateWithOffset: image must be rank 4,but got rank ${o.rank}.`);const a={image:o},i={radians:t,fillValue:n,center:r};return De.runKernel("RotateWithOffset",a,i)}});function Xa(e,t,n,r,o,a){null==r&&(r=.5),null==o&&(o=Number.NEGATIVE_INFINITY),null==a&&(a=0);const i=e.shape[0];return n=Math.min(n,i),s(0<=r&&r<=1,()=>`iouThreshold must be in [0, 1], but was '${r}'`),s(2===e.rank,()=>`boxes must be a 2D tensor, but was of rank '${e.rank}'`),s(4===e.shape[1],()=>"boxes must have 4 columns, but 2nd dimension was "+e.shape[1]),s(1===t.rank,()=>"scores must be a 1D tensor"),s(t.shape[0]===i,()=>`scores has incompatible shape with boxes. Expected ${i}, but was `+t.shape[0]),s(0<=a&&a<=1,()=>`softNmsSigma must be in [0, 1], but was '${a}'`),{maxOutputSize:n,iouThreshold:r,scoreThreshold:o,softNmsSigma:a}}const Qa=Re({nonMaxSuppression_:function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY){const s=_e(e,"boxes","nonMaxSuppression"),a=_e(t,"scores","nonMaxSuppression"),i=Xa(s,a,n,r,o),u={maxOutputSize:n=i.maxOutputSize,iouThreshold:r=i.iouThreshold,scoreThreshold:o=i.scoreThreshold};return De.runKernel("NonMaxSuppressionV3",{boxes:s,scores:a},u)}});function ei(e,t,n){const r=function(e,t,n){return function(e,t,n){let r=0,o=e.length,s=0,a=!1;for(;r<o;){s=r+(o-r>>>1);const i=n(t,e[s]);i>0?r=s+1:(o=s,a=!i)}return a?r:-r-1}(e,t,n||ti)}(e,t,n),o=r<0?-(r+1):r;e.splice(o,0,t)}function ti(e,t){return e>t?1:e<t?-1:0}function ni(e,t,n,r,o){return si(e,t,n,r,o,0)}function ri(e,t,n,r,o,s){return si(e,t,n,r,o,0,!1,s,!0)}function oi(e,t,n,r,o,s){return si(e,t,n,r,o,s,!0)}function si(e,t,n,r,o,s,a=!1,i=!1,u=!1){const l=[];for(let e=0;e<t.length;e++)t[e]>o&&l.push({score:t[e],boxIndex:e,suppressBeginIndex:0});l.sort(ui);const c=s>0?-.5/s:0,h=[],d=[];for(;h.length<n&&l.length>0;){const t=l.pop(),{score:n,boxIndex:s,suppressBeginIndex:a}=t;if(n<o)break;let i=!1;for(let n=h.length-1;n>=a;--n){const a=ai(e,s,h[n]);if(a>=r){i=!0;break}if(t.score=t.score*ii(r,c,a),t.score<=o)break}t.suppressBeginIndex=h.length,i||(t.score===n?(h.push(s),d.push(t.score)):t.score>o&&ei(l,t,ui))}const p=h.length,f=n-p;i&&f>0&&(h.push(...new Array(f).fill(0)),d.push(...new Array(f).fill(0)));const m={selectedIndices:h};return a&&(m.selectedScores=d),u&&(m.validOutputs=p),m}function ai(e,t,n){const r=e.subarray(4*t,4*t+4),o=e.subarray(4*n,4*n+4),s=Math.min(r[0],r[2]),a=Math.min(r[1],r[3]),i=Math.max(r[0],r[2]),u=Math.max(r[1],r[3]),l=Math.min(o[0],o[2]),c=Math.min(o[1],o[3]),h=Math.max(o[0],o[2]),d=Math.max(o[1],o[3]),p=(i-s)*(u-a),f=(h-l)*(d-c);if(p<=0||f<=0)return 0;const m=Math.max(s,l),g=Math.max(a,c),b=Math.min(i,h),y=Math.min(u,d),w=Math.max(b-m,0)*Math.max(y-g,0);return w/(p+f-w)}function ii(e,t,n){const r=Math.exp(t*n*n);return n<=e?r:0}function ui(e,t){return e.score-t.score||e.score===t.score&&t.boxIndex-e.boxIndex}const li=async function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY){const s=_e(e,"boxes","nonMaxSuppressionAsync"),a=_e(t,"scores","nonMaxSuppressionAsync"),i=Xa(s,a,n,r,o);n=i.maxOutputSize,r=i.iouThreshold,o=i.scoreThreshold;const u=await Promise.all([s.data(),a.data()]),l=u[0],c=u[1],{selectedIndices:h}=ni(l,c,n,r,o);return s!==e&&s.dispose(),a!==t&&a.dispose(),ea(h,"int32")};const ci=Re({nonMaxSuppressionWithScore_:function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY,s=0){const a=_e(e,"boxes","nonMaxSuppression"),i=_e(t,"scores","nonMaxSuppression"),u=Xa(a,i,n,r,o,s),l={boxes:a,scores:i},c={maxOutputSize:n=u.maxOutputSize,iouThreshold:r=u.iouThreshold,scoreThreshold:o=u.scoreThreshold,softNmsSigma:s=u.softNmsSigma},h=De.runKernel("NonMaxSuppressionV5",l,c);return{selectedIndices:h[0],selectedScores:h[1]}}});const hi=async function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY,s=0){const a=_e(e,"boxes","nonMaxSuppressionAsync"),i=_e(t,"scores","nonMaxSuppressionAsync"),u=Xa(a,i,n,r,o,s);n=u.maxOutputSize,r=u.iouThreshold,o=u.scoreThreshold,s=u.softNmsSigma;const l=await Promise.all([a.data(),i.data()]),c=l[0],h=l[1],{selectedIndices:d,selectedScores:p}=oi(c,h,n,r,o,s);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:ea(d,"int32"),selectedScores:ea(p)}};const di=Re({nonMaxSuppressionPadded_:function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY,s=!1){const a=_e(e,"boxes","nonMaxSuppression"),i=_e(t,"scores","nonMaxSuppression"),u=Xa(a,i,n,r,o,null),l={boxes:a,scores:i},c={maxOutputSize:u.maxOutputSize,iouThreshold:u.iouThreshold,scoreThreshold:u.scoreThreshold,padToMaxOutputSize:s},h=De.runKernel("NonMaxSuppressionV4",l,c);return{selectedIndices:h[0],validOutputs:h[1]}}});const pi=async function(e,t,n,r=.5,o=Number.NEGATIVE_INFINITY,s=!1){const a=_e(e,"boxes","nonMaxSuppressionAsync"),i=_e(t,"scores","nonMaxSuppressionAsync"),u=Xa(a,i,n,r,o,null),l=u.maxOutputSize,c=u.iouThreshold,h=u.scoreThreshold,[d,p]=await Promise.all([a.data(),i.data()]),{selectedIndices:f,validOutputs:m}=ri(d,p,l,c,h,s);return a!==e&&a.dispose(),i!==t&&i.dispose(),{selectedIndices:ea(f,"int32"),validOutputs:Ts(m,"int32")}};const fi=Re({resizeBilinear_:function(e,t,n=!1,r=!1){const o=_e(e,"images","resizeBilinear");s(3===o.rank||4===o.rank,()=>`Error in resizeBilinear: x must be rank 3 or 4, but got rank ${o.rank}.`),s(2===t.length,()=>"Error in resizeBilinear: new shape must 2D, but got shape "+t+"."),s(!1===r||!1===n,()=>"Error in resizeBilinear: If halfPixelCenters is true, alignCorners must be false.");let a=o,i=!1;3===o.rank&&(i=!0,a=Jn(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const u={images:a},l={alignCorners:n,halfPixelCenters:r,size:t},c=De.runKernel("ResizeBilinear",u,l);return i?Jn(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const mi=Re({resizeNearestNeighbor_:function(e,t,n=!1,r=!1){const o=_e(e,"images","resizeNearestNeighbor");s(3===o.rank||4===o.rank,()=>`Error in resizeNearestNeighbor: x must be rank 3 or 4, but got rank ${o.rank}.`),s(2===t.length,()=>"Error in resizeNearestNeighbor: new shape must 2D, but got shape "+t+"."),s("float32"===o.dtype||"int32"===o.dtype,()=>"`images` must have `int32` or `float32` as dtype"),s(!1===r||!1===n,()=>"Error in resizeNearestNeighbor: If halfPixelCenters is true, alignCorners must be false.");let a=o,i=!1;3===o.rank&&(i=!0,a=Jn(o,[1,o.shape[0],o.shape[1],o.shape[2]]));const u={images:a},l={alignCorners:n,halfPixelCenters:r,size:t},c=De.runKernel("ResizeNearestNeighbor",u,l);return i?Jn(c,[c.shape[1],c.shape[2],c.shape[3]]):c}});const gi=Re({bandPart_:function(e,t,n){s(t%1==0,()=>`bandPart(): numLower must be an integer, got ${t}.`),s(n%1==0,()=>`bandPart(): numUpper must be an integer, got ${n}.`);const r=_e(e,"a","bandPart");s(r.rank>=2,()=>`bandPart(): Rank must be at least 2, got ${r.rank}.`);const o=r.shape,[a,i]=r.shape.slice(-2);if(!(t<=a))throw new Error(`bandPart(): numLower (${t}) must not be greater than the number of rows (${a}).`);if(!(n<=i))throw new Error(`bandPart(): numUpper (${n}) must not be greater than the number of columns (${i}).`);t<0&&(t=a),n<0&&(n=i);const u=Jn(ys(0,a,1,"int32"),[-1,1]),l=ys(0,i,1,"int32"),c=fo(u,l),h=Eo(no(c,Ts(+t,"int32")),Jr(c,Ts(-n,"int32"))),d=Go([a,i],r.dtype);return Jn(Ys(aa(Jn(r,[-1,a,i])).map(e=>Rr(h,e,d))),o)}});const bi=Re({gramSchmidt_:function(e){let t;if(Array.isArray(e)){t=!1,s(null!=e&&e.length>0,()=>"Gram-Schmidt process: input must not be null, undefined, or empty");const n=e[0].shape[0];for(let t=1;t<e.length;++t)s(e[t].shape[0]===n,()=>`Gram-Schmidt: Non-unique lengths found in the input vectors: (${e[t].shape[0]} vs. ${n})`)}else t=!0,e=Us(e,e.shape[0],0).map(e=>Js(e,[0]));s(e.length<=e[0].shape[0],()=>`Gram-Schmidt: Number of vectors (${e.length}) exceeds number of dimensions (${e[0].shape[0]}).`);const n=[],r=e;for(let t=0;t<e.length;++t)n.push(De.tidy(()=>{let e=r[t];if(t>0)for(let r=0;r<t;++r){const t=En(mo(En(n[r],e)),n[r]);e=fo(e,t)}return Sn(e,Da(e,"euclidean"))}));return t?Ys(n,0):n}});function yi(e,t=!1){return De.tidy(()=>{s(2===e.shape.length,()=>`qr2d() requires a 2D Tensor, but got a ${e.shape.length}D Tensor.`);const n=e.shape[0],r=e.shape[1];let o=Wr(n),a=wt(e);const i=ta([[1]],[1,1]);let u=wt(i);const l=n>=r?r:n;for(let e=0;e<l;++e){const t=a,s=u,l=o;[u,a,o]=De.tidy(()=>{const t=er(a,[e,e],[n-e,1]),s=Da(t),l=er(a,[e,e],[1,1]),c=Rr(jr(l,0),ta([[-1]]),ta([[1]])),h=fo(l,En(c,s)),d=Sn(t,h);u=1===d.shape[0]?wt(i):Xn([i,er(d,[1,0],[d.shape[0]-1,d.shape[1]])],0);const p=lo(Sn(Rt(c,h),s)),f=er(a,[e,0],[n-e,r]),m=En(p,u),g=Bt(u);if(0===e)a=fo(f,Rt(m,Rt(g,f)));else{const t=fo(f,Rt(m,Rt(g,f)));a=Xn([er(a,[0,0],[e,r]),t],0)}const b=Bt(m),y=er(o,[0,e],[n,o.shape[1]-e]);if(0===e)o=fo(y,Rt(Rt(y,u),b));else{const t=fo(y,Rt(Rt(y,u),b));o=Xn([er(o,[0,0],[n,e]),t],1)}return[u,a,o]}),wn([t,s,l])}return!t&&n>r&&(o=er(o,[0,0],[n,r]),a=er(a,[0,0],[r,r])),[o,a]})}const wi=Re({qr_:function(e,t=!1){if(s(e.rank>=2,()=>"qr() requires input tensor to have a rank >= 2, but got rank "+e.rank),2===e.rank)return yi(e,t);{const n=e.shape.slice(0,e.shape.length-2).reduce((e,t)=>e*t),r=aa(Jn(e,[n,e.shape[e.shape.length-2],e.shape[e.shape.length-1]]),0),o=[],s=[];return r.forEach(e=>{const[n,r]=yi(e,t);o.push(n),s.push(r)}),[Jn(Ys(o,0),e.shape),Jn(Ys(s,0),e.shape)]}}});var ki;(ki=e.Reduction||(e.Reduction={}))[ki.NONE=0]="NONE",ki[ki.MEAN=1]="MEAN",ki[ki.SUM=2]="SUM",ki[ki.SUM_BY_NONZERO_WEIGHTS=3]="SUM_BY_NONZERO_WEIGHTS";const vi=Re({computeWeightedLoss_:function(t,n,r=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const o=_e(t,"losses","computeWeightedLoss");let s=null;null!=n&&(s=_e(n,"weights","computeWeightedLoss"));const a=null==s?o:En(o,s);if(r===e.Reduction.NONE)return a;if(r===e.Reduction.SUM)return mo(a);if(r===e.Reduction.MEAN){if(null==s)return _o(a);{const e=o.size/s.size,t=Sn(mo(a),mo(s));return e>1?Sn(t,Ts(e)):t}}if(r===e.Reduction.SUM_BY_NONZERO_WEIGHTS){if(null==s)return Sn(mo(a),Ts(o.size));{const e=En(s,Ko(o.shape)),t=yt(mo(Oo(e,Ts(0))),"float32");return Sn(mo(a),t)}}throw Error("Unknown reduction: "+r)}});const xi=Re({absoluteDifference_:function(t,n,r,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const s=_e(t,"labels","absoluteDifference"),i=_e(n,"predictions","absoluteDifference");let u=null;null!=r&&(u=_e(r,"weights","absoluteDifference")),a(s.shape,i.shape,"Error in absoluteDifference: ");const l=Dn(fo(s,i));return vi(l,u,o)}});const Si=Re({cosineDistance_:function(t,n,r,o,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=_e(t,"labels","cosineDistance"),u=_e(n,"predictions","cosineDistance");let l=null;null!=o&&(l=_e(o,"weights","cosineDistance")),a(i.shape,u.shape,"Error in cosineDistance: ");const c=Ts(1),h=fo(c,mo(En(i,u),r,!0));return vi(h,l,s)}});const Ei=Re({hingeLoss_:function(t,n,r,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let s=_e(t,"labels","hingeLoss");const i=_e(n,"predictions","hingeLoss");let u=null;null!=r&&(u=_e(r,"weights","hingeLoss")),a(s.shape,i.shape,"Error in hingeLoss: ");const l=Ts(1);s=fo(En(Ts(2),s),l);const c=vs(fo(l,En(s,i)));return vi(c,u,o)}});const Di=Re({huberLoss_:function(t,n,r,o=1,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=_e(t,"labels","huberLoss"),u=_e(n,"predictions","huberLoss");let l=null;null!=r&&(l=_e(r,"weights","huberLoss")),a(i.shape,u.shape,"Error in huberLoss: ");const c=Ts(o),h=Dn(fo(u,i)),d=Ro(h,c),p=fo(h,d),f=vn(En(Ts(.5),Po(d)),En(c,p));return vi(f,l,s)}});const Ii=Re({logLoss_:function(t,n,r,o=1e-7,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const i=_e(t,"labels","logLoss"),u=_e(n,"predictions","logLoss");let l=null;null!=r&&(l=_e(r,"weights","logLoss")),a(i.shape,u.shape,"Error in logLoss: ");const c=Ts(1),h=Ts(o),d=lo(En(i,oo(vn(u,h)))),p=En(fo(c,i),oo(vn(fo(c,u),h))),f=fo(d,p);return vi(f,l,s)}});const Ni=Re({meanSquaredError_:function(t,n,r,o=e.Reduction.SUM_BY_NONZERO_WEIGHTS){const s=_e(t,"labels","meanSquaredError"),i=_e(n,"predictions","meanSquaredError");let u=null;null!=r&&(u=_e(r,"weights","meanSquaredError")),a(s.shape,i.shape,"Error in meanSquaredError: ");const l=js(s,i);return vi(l,u,o)}});const Ai=Re({sigmoidCrossEntropy_:function(t,n,r,o=0,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=_e(t,"multiClassLabels","sigmoidCrossEntropy");const u=_e(n,"logits","sigmoidCrossEntropy");let l=null;if(null!=r&&(l=_e(r,"weights","sigmoidCrossEntropy")),a(i.shape,u.shape,"Error in sigmoidCrossEntropy: "),o>0){const e=Ts(o),t=Ts(1),n=Ts(.5);i=vn(En(i,fo(t,e)),En(n,e))}const c=function(e,t){const n=_e(e,"labels","sigmoidCrossEntropyWithLogits"),r=_e(t,"logits","sigmoidCrossEntropyWithLogits");a(n.shape,r.shape,"Error in sigmoidCrossEntropyWithLogits: ");const o=vs(r),s=En(r,n),i=so(qr(lo(Dn(r))));return vn(fo(o,s),i)}(i,u);return vi(c,l,s)}});const Mi=Re({softmaxCrossEntropy_:function(t,n,r,o=0,s=e.Reduction.SUM_BY_NONZERO_WEIGHTS){let i=_e(t,"onehotLabels","softmaxCrossEntropy");const u=_e(n,"logits","softmaxCrossEntropy");let l=null;if(null!=r&&(l=_e(r,"weights","softmaxCrossEntropy")),a(i.shape,u.shape,"Error in softmaxCrossEntropy: "),o>0){const e=Ts(o),t=Ts(1),n=Ts(i.shape[1]);i=vn(En(i,fo(t,e)),Sn(e,n))}const c=function(e,t,n=-1){if(-1===n&&(n=t.rank-1),n!==t.rank-1)throw Error(`Softmax cross entropy along a non-last dimension is not yet supported. Labels / logits was rank ${t.rank} and dim was `+n);return io((e,t,r)=>{const o=So(t,[n],!0),s=fo(yt(t,"float32"),o);r([e,s]);const a=lo(En(s,e));return{value:mo(a,[n]),gradFunc:(e,t)=>{const[r,o]=t,s=ko(e.shape,[n]);return[En(Jn(e,s),fo(yt(r,"float32"),qr(o))),En(Jn(e,s),fo(qr(o),yt(r,"float32")))]}}})(e,t)}(i,u);return vi(c,l,s)}}),Ti={fft:Gs,ifft:Ks,rfft:Vs,irfft:Ws},$i={hammingWindow:Ua,hannWindow:Va,frame:Ha,stft:ja},_i={flipLeftRight:Ya,resizeNearestNeighbor:mi,resizeBilinear:fi,rotateWithOffset:Za,cropAndResize:Ja,nonMaxSuppression:Qa,nonMaxSuppressionAsync:li,nonMaxSuppressionWithScore:ci,nonMaxSuppressionWithScoreAsync:hi,nonMaxSuppressionPadded:di,nonMaxSuppressionPaddedAsync:pi},Fi={bandPart:gi,gramSchmidt:bi,qr:wi},Ri={absoluteDifference:xi,computeWeightedLoss:vi,cosineDistance:Si,hingeLoss:Ei,huberLoss:Di,logLoss:Ii,meanSquaredError:Ni,sigmoidCrossEntropy:Ai,softmaxCrossEntropy:Mi};class Ci extends ln{minimize(e,t=!1,n){const{value:r,grads:o}=this.computeGradients(e,n);if(null!=n){const e=n.map(e=>({name:e.name,tensor:o[e.name]}));this.applyGradients(e)}else this.applyGradients(o);return wn(o),t?r:(r.dispose(),null)}get iterations(){return null==this.iterations_&&(this.iterations_=0),this.iterations_}incrementIterations(){this.iterations_=this.iterations+1}computeGradients(e,t){return ao(e,t)}dispose(){null!=this.iterations_&&wn(this.iterations_)}async saveIterations(){return null==this.iterations_&&(this.iterations_=0),{name:"iter",tensor:Ts(this.iterations_,"int32")}}async getWeights(){throw new Error("getWeights() is not implemented for this optimizer yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for this optimizer class "+this.getClassName())}async extractIterations(e){return this.iterations_=(await e[0].tensor.data())[0],e.slice(1)}}Object.defineProperty(Ci,Symbol.hasInstance,{value:e=>null!=e.minimize&&null!=e.computeGradients&&null!=e.applyGradients});class Bi extends Ci{constructor(e,t,n=null){super(),this.learningRate=e,this.rho=t,this.epsilon=n,this.accumulatedGrads=[],this.accumulatedUpdates=[],null==n&&(this.epsilon=De.backend.epsilon())}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const r=De.registeredVariables[t];null==this.accumulatedGrads[n]&&(this.accumulatedGrads[n]={originalName:t+"/accum_grad",variable:yn(()=>Cr(r).variable(!1))}),null==this.accumulatedUpdates[n]&&(this.accumulatedUpdates[n]={originalName:t+"/accum_var",variable:yn(()=>Cr(r).variable(!1))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const s=this.accumulatedGrads[n].variable,a=this.accumulatedUpdates[n].variable;yn(()=>{const e=vn(En(s,this.rho),En(Po(o),1-this.rho)),t=En(Sn(Hs(vn(a,this.epsilon)),Hs(vn(s,this.epsilon))),o),n=vn(En(a,this.rho),En(Po(t),1-this.rho));s.assign(e),a.assign(n);const i=vn(En(t,-this.learningRate),r);r.assign(i)})}),this.incrementIterations()}dispose(){null!=this.accumulatedUpdates&&(wn(this.accumulatedGrads.map(e=>e.variable)),wn(this.accumulatedUpdates.map(e=>e.variable)))}async getWeights(){const e=[...this.accumulatedGrads,...this.accumulatedUpdates];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){const t=(e=await this.extractIterations(e)).length/2;this.accumulatedGrads=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedUpdates=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,rho:this.rho,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.rho,t.epsilon)}}Bi.className="Adadelta",hn(Bi);class Pi extends Ci{constructor(e,t=.1){super(),this.learningRate=e,this.initialAccumulatorValue=t,this.accumulatedGrads=[]}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const r=De.registeredVariables[t];if(null==this.accumulatedGrads[n]){const e=!1;this.accumulatedGrads[n]={originalName:t+"/accumulator",variable:yn(()=>Ur(r.shape,this.initialAccumulatorValue).variable(e))}}const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const s=this.accumulatedGrads[n].variable;yn(()=>{const e=vn(s,Po(o));s.assign(e);const t=vn(En(Sn(o,Hs(vn(e,De.backend.epsilon()))),-this.learningRate),r);r.assign(t)})}),this.incrementIterations()}dispose(){null!=this.accumulatedGrads&&wn(this.accumulatedGrads.map(e=>e.variable))}async getWeights(){return[await this.saveIterations()].concat(this.accumulatedGrads.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulatedGrads=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,initialAccumulatorValue:this.initialAccumulatorValue}}static fromConfig(e,t){return new e(t.learningRate,t.initialAccumulatorValue)}}Pi.className="Adagrad",hn(Pi);class zi extends Ci{constructor(e,t,n,r=null){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.accumulatedFirstMoment=[],this.accumulatedSecondMoment=[],yn(()=>{this.accBeta1=Ts(t).variable(),this.accBeta2=Ts(n).variable()}),null==r&&(this.epsilon=De.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);yn(()=>{const n=fo(1,this.accBeta1),r=fo(1,this.accBeta2);t.forEach((t,o)=>{const s=De.registeredVariables[t];null==this.accumulatedFirstMoment[o]&&(this.accumulatedFirstMoment[o]={originalName:t+"/m",variable:yn(()=>Cr(s).variable(!1))}),null==this.accumulatedSecondMoment[o]&&(this.accumulatedSecondMoment[o]={originalName:t+"/v",variable:yn(()=>Cr(s).variable(!1))});const a=Array.isArray(e)?e[o].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[o].variable,u=this.accumulatedSecondMoment[o].variable,l=vn(En(i,this.beta1),En(a,1-this.beta1)),c=vn(En(u,this.beta2),En(Po(a),1-this.beta2)),h=Sn(l,n),d=Sn(c,r);i.assign(l),u.assign(c);const p=vn(En(Sn(h,vn(Hs(d),this.epsilon)),-this.learningRate),s);s.assign(p)}),this.accBeta1.assign(En(this.accBeta1,this.beta1)),this.accBeta2.assign(En(this.accBeta2,this.beta2))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.accBeta2.dispose(),null!=this.accumulatedFirstMoment&&wn(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedSecondMoment&&wn(this.accumulatedSecondMoment.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedFirstMoment,...this.accumulatedSecondMoment];return[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e),yn(()=>{this.accBeta1.assign(Qo(this.beta1,this.iterations_+1)),this.accBeta2.assign(Qo(this.beta2,this.iterations_+1))});const t=e.length/2;this.accumulatedFirstMoment=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedSecondMoment=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon)}}zi.className="Adam",hn(zi);class Li extends Ci{constructor(e,t,n,r=null,o=0){super(),this.learningRate=e,this.beta1=t,this.beta2=n,this.epsilon=r,this.decay=o,this.accumulatedFirstMoment=[],this.accumulatedWeightedInfNorm=[],yn(()=>{this.iteration=Ts(0).variable(),this.accBeta1=Ts(t).variable()}),null==r&&(this.epsilon=De.backend.epsilon())}applyGradients(e){const t=Array.isArray(e)?e.map(e=>e.name):Object.keys(e);yn(()=>{const n=fo(1,this.accBeta1),r=Sn(-this.learningRate,vn(En(this.iteration,this.decay),1));t.forEach((t,o)=>{const s=De.registeredVariables[t];null==this.accumulatedFirstMoment[o]&&(this.accumulatedFirstMoment[o]={originalName:t+"/m",variable:Cr(s).variable(!1)}),null==this.accumulatedWeightedInfNorm[o]&&(this.accumulatedWeightedInfNorm[o]={originalName:t+"/v",variable:Cr(s).variable(!1)});const a=Array.isArray(e)?e[o].tensor:e[t];if(null==a)return;const i=this.accumulatedFirstMoment[o].variable,u=this.accumulatedWeightedInfNorm[o].variable,l=vn(En(i,this.beta1),En(a,1-this.beta1)),c=En(u,this.beta2),h=Dn(a),d=$o(c,h);i.assign(l),u.assign(d);const p=vn(En(Sn(r,n),Sn(l,vn(d,this.epsilon))),s);s.assign(p)}),this.iteration.assign(vn(this.iteration,1)),this.accBeta1.assign(En(this.accBeta1,this.beta1))}),this.incrementIterations()}dispose(){this.accBeta1.dispose(),this.iteration.dispose(),null!=this.accumulatedFirstMoment&&wn(this.accumulatedFirstMoment.map(e=>e.variable)),null!=this.accumulatedWeightedInfNorm&&wn(this.accumulatedWeightedInfNorm.map(e=>e.variable))}async getWeights(){throw new Error("getWeights() is not implemented for Adamax yet.")}async setWeights(e){throw new Error("setWeights() is not implemented for Adamax yet.")}getConfig(){return{learningRate:this.learningRate,beta1:this.beta1,beta2:this.beta2,epsilon:this.epsilon,decay:this.decay}}static fromConfig(e,t){return new e(t.learningRate,t.beta1,t.beta2,t.epsilon,t.decay)}}Li.className="Adamax",hn(Li);class qi extends Ci{constructor(e){super(),this.learningRate=e,this.setLearningRate(e)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const r=Array.isArray(e)?e[n].tensor:e[t];if(null==r)return;const o=De.registeredVariables[t];yn(()=>{const e=vn(En(this.c,r),o);o.assign(e)})}),this.incrementIterations()}setLearningRate(e){this.learningRate=e,null!=this.c&&this.c.dispose(),this.c=kn(Ts(-e))}dispose(){this.c.dispose()}async getWeights(){return[await this.saveIterations()]}async setWeights(e){if(0!==(e=await this.extractIterations(e)).length)throw new Error("SGD optimizer does not have settable weights.")}getConfig(){return{learningRate:this.learningRate}}static fromConfig(e,t){return new e(t.learningRate)}}qi.className="SGD",hn(qi);class Oi extends qi{constructor(e,t,n=!1){super(e),this.learningRate=e,this.momentum=t,this.useNesterov=n,this.accumulations=[],this.m=Ts(this.momentum)}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const r=De.registeredVariables[t];if(null==this.accumulations[n]){const e=!1;this.accumulations[n]={originalName:t+"/momentum",variable:yn(()=>Cr(r).variable(e))}}const o=this.accumulations[n].variable,s=Array.isArray(e)?e[n].tensor:e[t];null!=s&&yn(()=>{let e;const t=vn(En(this.m,o),s);e=this.useNesterov?vn(En(this.c,vn(s,En(t,this.m))),r):vn(En(this.c,t),r),o.assign(t),r.assign(e)})}),this.incrementIterations()}dispose(){this.m.dispose(),null!=this.accumulations&&wn(this.accumulations.map(e=>e.variable))}setMomentum(e){this.momentum=e}async getWeights(){return[await this.saveIterations()].concat(this.accumulations.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);this.accumulations=e.map(e=>({originalName:e.name,variable:e.tensor.variable(!1)}))}getConfig(){return{learningRate:this.learningRate,momentum:this.momentum,useNesterov:this.useNesterov}}static fromConfig(e,t){return new e(t.learningRate,t.momentum,t.useNesterov)}}Oi.className="Momentum",hn(Oi);class Gi extends Ci{constructor(e,t=.9,n=0,r=null,o=!1){if(super(),this.learningRate=e,this.decay=t,this.momentum=n,this.epsilon=r,this.accumulatedMeanSquares=[],this.accumulatedMoments=[],this.accumulatedMeanGrads=[],this.centered=o,null==r&&(this.epsilon=De.backend.epsilon()),null==e)throw new Error("learningRate for RMSPropOptimizer must be defined.")}applyGradients(e){(Array.isArray(e)?e.map(e=>e.name):Object.keys(e)).forEach((t,n)=>{const r=De.registeredVariables[t];null==this.accumulatedMeanSquares[n]&&(this.accumulatedMeanSquares[n]={originalName:t+"/rms",variable:yn(()=>Cr(r).variable(!1))}),null==this.accumulatedMoments[n]&&(this.accumulatedMoments[n]={originalName:t+"/momentum",variable:yn(()=>Cr(r).variable(!1))}),null==this.accumulatedMeanGrads[n]&&this.centered&&(this.accumulatedMeanGrads[n]={originalName:t+"/mg",variable:yn(()=>Cr(r).variable(!1))});const o=Array.isArray(e)?e[n].tensor:e[t];if(null==o)return;const s=this.accumulatedMeanSquares[n].variable,a=this.accumulatedMoments[n].variable;yn(()=>{const e=vn(En(s,this.decay),En(Po(o),1-this.decay));if(this.centered){const t=this.accumulatedMeanGrads[n].variable,i=vn(En(t,this.decay),En(o,1-this.decay)),u=Sn(En(o,this.learningRate),Hs(fo(e,vn(Po(i),this.epsilon)))),l=vn(En(a,this.momentum),u);s.assign(e),t.assign(i),a.assign(l);const c=fo(r,l);r.assign(c)}else{const e=vn(En(s,this.decay),En(Po(o),1-this.decay)),t=vn(En(a,this.momentum),Sn(En(o,this.learningRate),Hs(vn(e,this.epsilon))));s.assign(e),a.assign(t);const n=fo(r,t);r.assign(n)}})}),this.incrementIterations()}dispose(){null!=this.accumulatedMeanSquares&&wn(this.accumulatedMeanSquares.map(e=>e.variable)),null!=this.accumulatedMeanGrads&&this.centered&&wn(this.accumulatedMeanGrads.map(e=>e.variable)),null!=this.accumulatedMoments&&wn(this.accumulatedMoments.map(e=>e.variable))}async getWeights(){const e=[...this.accumulatedMeanSquares,...this.accumulatedMoments];return this.centered&&e.push(...this.accumulatedMeanGrads),[await this.saveIterations()].concat(e.map(e=>({name:e.originalName,tensor:e.variable})))}async setWeights(e){e=await this.extractIterations(e);const t=this.centered?e.length/3:e.length/2;this.accumulatedMeanSquares=e.slice(0,t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.accumulatedMoments=e.slice(t,2*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})),this.centered&&(this.accumulatedMeanGrads=e.slice(2*t,3*t).map(e=>({originalName:e.name,variable:e.tensor.variable(!1)})))}getConfig(){return{learningRate:this.learningRate,decay:this.decay,momentum:this.momentum,epsilon:this.epsilon,centered:this.centered}}static fromConfig(e,t){return new e(t.learningRate,t.decay,t.momentum,t.epsilon,t.centered)}}Gi.className="RMSProp",hn(Gi);class Ki{static sgd(e){return new qi(e)}static momentum(e,t,n=!1){return new Oi(e,t,n)}static rmsprop(e,t=.9,n=0,r=null,o=!1){return new Gi(e,t,n,r,o)}static adam(e=.001,t=.9,n=.999,r=null){return new zi(e,t,n,r)}static adadelta(e=.001,t=.95,n=null){return new Bi(e,t,n)}static adamax(e=.002,t=.9,n=.999,r=null,o=0){return new Li(e,t,n,r,o)}static adagrad(e,t=.1){return new Pi(e,t)}}const Wi={sgd:Ki.sgd,momentum:Ki.momentum,adadelta:Ki.adadelta,adagrad:Ki.adagrad,rmsprop:Ki.rmsprop,adamax:Ki.adamax,adam:Ki.adam},Ui="undefined"!=typeof requestAnimationFrame?requestAnimationFrame:"undefined"!=typeof setImmediate?setImmediate:e=>e();var Vi=Object.freeze({__proto__:null,segOpComputeOptimalWindowSize:function(e,t){let n,r=!1;for(e<=30?(n=e,r=!0):n=A(e,Math.floor(Math.sqrt(e)));!r;)n>t||n===e?r=!0:n=A(e,n+1);return n},computeOutShape:function(e,t,n){const r=[],o=e.length;for(let s=0;s<o;s++)s!==t?r.push(e[s]):r.push(n);return r},collectGatherOpShapeInfo:function(e,t,n,r){const o=t.shape.length,s=e.shape.length;if(0!==r&&(r<-o||r>o))throw new Error(`Expect batchDims in the range of [-${o}, ${o}], but got ${r}`);if(r<0&&(r+=o),r>s)throw new Error(`batchDims (${r}) must be less than rank(x) (\n    ${s}).`);if(n<r)throw new Error(`batchDims (${r}) must be less than or equal to axis (${n}).`);for(let n=0;n<r;++n)if(e.shape[n]!==t.shape[n])throw new Error(`x.shape[${n}]: ${e.shape[n]} should be equal to indices.shape[${n}]: ${t.shape[n]}.`);const a=e.shape[n],i=[];let u=1,l=1,c=1;for(let t=0;t<r;++t)i.push(e.shape[t]),u*=e.shape[t];for(let t=r;t<n;t++)i.push(e.shape[t]),l*=e.shape[t];for(let e=r;e<o;e++)i.push(t.shape[e]);for(let t=n+1;t<s;t++)i.push(e.shape[t]),c*=e.shape[t];return{batchSize:u,sliceSize:c,outerSize:l,dimSize:a,outputShape:i}}});var Hi=Object.freeze({__proto__:null,slice_util:un,segment_util:Vi,castTensor:function(e,t,n){if("complex64"===t){if("complex64"===e.dtype)return e.clone();const t=Go(e.shape),r=yt(e,"float32"),o=n.complex(r,t);return t.dispose(),r.dispose(),o}if(!w(e.dtype,t))return De.makeTensorFromDataId(e.dataId,e.shape,t);if("complex64"===e.dtype){const r=n.real(e),o=yt(r,t);return r.dispose(),o}if("int32"===t)return n.int(e);if("bool"===t){const t=Ts(0,e.dtype),r=n.notEqual(e,t);return t.dispose(),r}throw new Error(`Error in Cast: failed to cast ${e.dtype} to ${t}`)},reshapeTensor:function(e,t){return De.makeTensorFromDataId(e.dataId,t,e.dtype)},fromUint8ToStringArray:function(e){try{return e.map(e=>Z(e))}catch(e){throw new Error("Failed to decode encoded string bytes into utf-8, error: "+e)}},fromStringArrayToUint8:function(e){return e.map(e=>Y(e))},upcastType:be,axesAreInnerMostDims:bo,combineLocations:yo,computeOutAndReduceShapes:wo,expandShapeToKeepDim:ko,assertAxesAreInnerMostDims:function(e,t,n){s(bo(t,n),()=>e+" supports only inner-most axes for now. "+`Got axes ${t} and rank-${n} input.`)},getAxesPermutation:vo,getUndoAxesPermutation:xo,getInnerMostAxes:function(e,t){const n=[];for(let r=t-e;r<t;++r)n.push(r);return n},getBroadcastDims:function(e,t){const n=e.length,r=[];for(let o=0;o<n;o++){const s=n-1-o,a=e[s]||1;(t[t.length-1-o]||1)>1&&1===a&&r.unshift(s)}return r},getReductionAxes:$r,assertAndGetBroadcastShape:_r,assertParamsConsistent:function(e,t){const n=e[0].length;e.forEach((e,t)=>{s(e.length===n,()=>`Error in concat${n}D: rank of tensors[${t}] must be the same as the rank of the rest (${n})`)}),s(t>=0&&t<n,()=>`Error in concat${n}D: axis must be between 0 and ${n-1}.`);const r=e[0];e.forEach((e,o)=>{for(let a=0;a<n;a++)s(a===t||e[a]===r[a],()=>`Error in concat${n}D: Shape of tensors[${o}] (${e}) does not match the shape of the rest (${r}) along the non-concatenated axis ${o}.`)})},computeOutShape:function(e,t){const n=e[0].slice();for(let r=1;r<e.length;r++)n[t]+=e[r][t];return n},computeDilation2DInfo:function(e,t,n,r,o="NHWC",s){return Ln(e,[...t,e[3]],n,s,r,null,null,jn(o))},computePool2DInfo:zn,computePool3DInfo:function(e,t,n,r,o,s,a="NDHWC"){const[i,u,l]=Kn(t);let c,h;if("NDHWC"===a)h="channelsLast",c=[i,u,l,e[4],e[4]];else{if("NCDHW"!==a)throw new Error("Unknown dataFormat "+a);h="channelsFirst",c=[i,u,l,e[1],e[1]]}return qn(e,c,n,r,o,!1,h,s)},computeConv2DInfo:Ln,computeConv3DInfo:qn,computeDefaultPad:On,tupleValuesAreOne:Vn,eitherStridesOrDilationsAreOne:Hn,convertConv2DDataFormat:jn,getFusedDyActivation:Ca,getFusedBiasGradient:Ba,applyActivation:Pa,shouldFuse:za,PARALLELIZE_THRESHOLD:30,computeOptimalWindowSize:function(e){return e<=30?e:A(e,Math.floor(Math.sqrt(e)))},getImageCenter:function(e,t,n){return[n*("number"==typeof e?e:e[0]),t*("number"==typeof e?e:e[1])]},getReshaped:function(e,t,n,r=!0){let o=[];if(r)o=o.concat(t.slice(0)),o.push(e[0]/n),o=o.concat(e.slice(1));else{o=o.concat(e[0]);const n=t.length;for(let r=0;r<n;++r)o=o.concat([e[r+1]/t[r],t[r]]);o=o.concat(e.slice(n+1))}return o},getPermuted:function(e,t,n=!0){const r=[];if(n){r.push(t);for(let n=t+1;n<e;++n)n<=2*t?(r.push(n),r.push(n-(t+1))):r.push(n)}else{const n=[],o=[];for(let r=1;r<e;++r)r>=2*t+1||r%2==1?o.push(r):n.push(r);r.push(...n),r.push(0),r.push(...o)}return r},getReshapedPermuted:function(e,t,n,r=!0){const o=[];r?o.push(e[0]/n):o.push(e[0]*n);for(let n=1;n<e.length;++n)n<=t.length?r?o.push(t[n-1]*e[n]):o.push(e[n]/t[n-1]):o.push(e[n]);return o},getSliceBeginCoords:function(e,t){const n=[0];for(let r=0;r<t;++r)n.push(e[r][0]);return n},getSliceSize:function(e,t,n){const r=e.slice(0,1);for(let o=0;o<n;++o)r.push(e[o+1]-t[o][0]-t[o][1]);return r},prepareAndValidate:Kt,validateUpdateShape:Ut,validateInput:Vt,calculateShapes:Ht,SELU_SCALEALPHA:1.7580993408473768,SELU_SCALE:1.0507009873554805,ERF_P:.3275911,ERF_A1:.254829592,ERF_A2:-.284496736,ERF_A3:1.421413741,ERF_A4:-1.453152027,ERF_A5:1.061405429,warn:function(...e){B().getBool("IS_TEST")||console.warn(...e)},log:function(...e){B().getBool("IS_TEST")||console.log(...e)},mergeRealAndImagArrays:function(e,t){if(e.length!==t.length)throw new Error(`Cannot merge real and imag arrays of different lengths. real:${e.length}, imag: ${t.length}.`);const n=new Float32Array(2*e.length);for(let r=0;r<n.length;r+=2)n[r]=e[r/2],n[r+1]=t[r/2];return n},splitRealAndImagArrays:function(e){const t=new Float32Array(e.length/2),n=new Float32Array(e.length/2);for(let r=0;r<e.length;r+=2)t[r/2]=e[r],n[r/2]=e[r+1];return{real:t,imag:n}},complexWithEvenIndex:function(e){const t=Math.ceil(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=0;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},complexWithOddIndex:function(e){const t=Math.floor(e.length/4),n=new Float32Array(t),r=new Float32Array(t);for(let t=2;t<e.length;t+=4)n[Math.floor(t/4)]=e[t],r[Math.floor(t/4)]=e[t+1];return{real:n,imag:r}},getComplexWithIndex:function(e,t){return{real:e[2*t],imag:e[2*t+1]}},assignToTypedArray:function(e,t,n,r){e[2*r]=t,e[2*r+1]=n},exponents:function(e,t){const n=new Float32Array(e/2),r=new Float32Array(e/2);for(let o=0;o<Math.ceil(e/2);o++){const s=(t?2:-2)*Math.PI*(o/e);n[o]=Math.cos(s),r[o]=Math.sin(s)}return{real:n,imag:r}},exponent:function(e,t,n){const r=(n?2:-2)*Math.PI*(e/t);return{real:Math.cos(r),imag:Math.sin(r)}},prepareSplitSize:function(e,t,n=0){let r=[];if("number"==typeof t)s(e.shape[n]%t==0,()=>"Number of splits must evenly divide the axis."),r=new Array(t).fill(e.shape[n]/t);else{s(t.reduce((e,t)=>(-1===t&&(e+=1),e),0)<=1,()=>"There should be only one negative value in split array.");const o=t.indexOf(-1);if(-1!==o){const r=t.reduce((e,t)=>t>0?e+t:e);t[o]=e.shape[n]-r}s(e.shape[n]===t.reduce((e,t)=>e+t),()=>"The sum of sizes must match the size of the axis dimension."),r=t}return r}}),ji=Object.freeze({__proto__:null,nonMaxSuppressionV3Impl:ni,nonMaxSuppressionV4Impl:ri,nonMaxSuppressionV5Impl:oi,whereImpl:ia});const Ji={kernelName:"Abs",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,Zs(yt(n,"float32"),-1))}}},Yi={kernelName:"Acos",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Po(yt(n,"float32")),r=Hs(fo(Ts(1),t));return lo(Sn(e,r))}}}},Zi={kernelName:"Acosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Hs(fo(Po(yt(n,"float32")),1));return Sn(e,t)}}}},Xi={kernelName:"Add",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{let t=e;const r=$r(n.shape,o);return r.length>0&&(t=mo(t,r)),Jn(t,n.shape)},b:()=>{let t=e;const n=$r(r.shape,o);return n.length>0&&(t=mo(t,n)),Jn(t,r.shape)}}}},Qi={kernelName:"AddN",saveAllInputs:!0,gradFunc:(e,t)=>{const n={};return t.forEach((t,r)=>{n[r]=()=>e.clone()}),n}},eu={kernelName:"ArgMax",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Cr(n)}}},tu={kernelName:"ArgMin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Cr(n)}}},nu={kernelName:"Asin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,Hs(fo(Ts(1),Po(yt(n,"float32")))))}}},ru={kernelName:"Asinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=Hs(vn(Ts(1),Po(yt(n,"float32"))));return Sn(e,t)}}}},ou={kernelName:"Atan2",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{const t=vn(Po(n),Po(r));let s=En(e,Sn(r,t));const a=$r(n.shape,o);return a.length>0&&(s=mo(s,a)),Jn(s,n.shape)},b:()=>{const t=vn(Po(n),Po(r));let s=lo(En(e,Sn(n,t)));const a=$r(r.shape,o);return a.length>0&&(s=mo(s,a)),Jn(s,r.shape)}}}},su={kernelName:"Atan",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,vn(Po(yt(n,"float32")),1))}}},au={kernelName:"Atanh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,fo(Ts(1),Po(yt(n,"float32"))))}}};const iu=Re({avgPool3dGrad_:function(e,t,n,r,o=[1,1,1],a,i){const u=_e(e,"dy","avgPool3dGrad"),l=_e(t,"input","avgPool3dGrad");let c=u,d=l,p=!1;4===l.rank&&(p=!0,c=Jn(u,[1,u.shape[0],u.shape[1],u.shape[2],u.shape[3]]),d=Jn(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]])),s(5===c.rank,()=>"Error in avgPool3dGrad: dy must be rank 5 but got rank "+c.rank+"."),s(5===d.rank,()=>"Error in avgPool3dGrad: input must be rank 5 but got rank "+d.rank+"."),s(Hn(r,o),()=>`Error in avgPool3dGrad: Either strides or dilations must be 1. Got strides ${r} and dilations '${o}'`),null!=i&&s(h(a),()=>`Error in avgPool3dGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const f={dy:c,input:d},m={filterSize:n,strides:r,dilations:o,pad:a,dimRoundingMode:i},g=De.runKernel("AvgPool3DGrad",f,m);return p?Jn(g,[g.shape[1],g.shape[2],g.shape[3],g.shape[4]]):g}}),uu={kernelName:"AvgPool3D",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{filterSize:o,strides:s,dilations:a,pad:i,dimRoundingMode:u}=n,l=null==a?[1,1,1]:a;return{x:()=>iu(e,r,o,s,l,i,u)}}};const lu=Re({avgPoolGrad_:function(e,t,n,r,o){const a=_e(e,"dy","avgPoolGrad"),i=_e(t,"input","avgPoolGrad");s(i.rank===a.rank,()=>`Rank of input (${i.rank}) does not match rank of dy (${a.rank})`);let u=i,l=a,c=!1;3===i.rank&&(c=!0,u=Jn(i,[1,i.shape[0],i.shape[1],i.shape[2]]),l=Jn(a,[1,a.shape[0],a.shape[1],a.shape[2]])),s(4===l.rank,()=>"Error in avgPoolGrad: dy must be rank 4 but got rank "+l.rank+"."),s(4===u.rank,()=>"Error in avgPoolGrad: input must be rank 4 but got rank "+u.rank+".");const h={dy:l,input:u},d={filterSize:n,strides:r,pad:o},p=De.runKernel("AvgPoolGrad",h,d);return c?Jn(p,[p.shape[1],p.shape[2],p.shape[3]]):p}}),cu={kernelName:"AvgPool",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{filterSize:o,strides:s,pad:a}=n;return{x:()=>lu(e,r,o,s,a)}}},hu={kernelName:"BatchMatMul",inputsToSave:["a","b"],gradFunc:(e,t,n)=>{const[r,o]=t,{transposeA:s,transposeB:a}=n;return s||a?!s&&a?{a:()=>Rt(e,o,!1,!1),b:()=>Rt(e,r,!0,!1)}:s&&!a?{a:()=>Rt(o,e,!1,!0),b:()=>Rt(r,e,!1,!1)}:{a:()=>Rt(o,e,!0,!0),b:()=>Rt(e,r,!0,!0)}:{a:()=>Rt(e,o,!1,!0),b:()=>Rt(r,e,!0,!1)}}},du={kernelName:"BatchToSpaceND",gradFunc:(e,t,n)=>{const{blockShape:r,crops:o}=n;return{x:()=>Zo(e,r,o)}}},pu={kernelName:"BroadcastTo",gradFunc:(e,t,n)=>{const r=n,o=r.inputShape,s=r.shape,a=Array.from(s);for(let e=o.length-1;e>=0;e--)if(o[e]===s[e])a[e]=1;else if(1!==o[e])throw new Error(`broadcastTo(): [${o}] cannot be broadcast to [${s}].`);const i=[];for(let e=0;e<a.length;e++)a[e]>1&&i.push(e);return{x:()=>mo(e,i,!0)}}},fu={kernelName:"Cast",gradFunc:e=>({x:()=>e.clone()})},mu={kernelName:"Ceil",gradFunc:e=>({x:()=>Cr(e)})},gu={kernelName:"ClipByValue",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{clipValueMin:o,clipValueMax:s}=n;return{x:()=>Rr(Eo(Jr(r,o),no(r,s)),e,Cr(e))}}},bu={kernelName:"ComplexAbs",inputsToSave:["x"],gradFunc:Ji.gradFunc},yu={kernelName:"Concat",saveAllInputs:!0,gradFunc:(e,t,n)=>{const r=t.map(e=>e.shape),{axis:o}=n,s=p(o,t[0].shape)[0],a=r.map(e=>e[s]);return Us(e,a,s).map(e=>()=>e)}},wu={kernelName:"Conv2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[r,o]=t,{dilations:a,strides:i,pad:u,dataFormat:l}=n;return s(Vn(a),()=>`Error in gradient of conv2D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${a}'`),{x:()=>yr(r.shape,e,o,i,u,l),filter:()=>Ra(r,e,o.shape,i,u,l)}}},ku={kernelName:"Conv2DBackpropInput",inputsToSave:["dy","filter"],gradFunc:(e,t,n)=>{const[r,o]=t,{strides:s,pad:a,dataFormat:i,dimRoundingMode:u}=n;return{dy:()=>gr(e,o,s,a,i,1,u),filter:()=>Ra(e,r,o.shape,s,a,i,u)}}};const vu=Re({conv3DBackpropFilter_:function(e,t,n,r,o){let a=e;4===e.rank&&(a=Jn(e,[1,e.shape[0],e.shape[1],e.shape[2],e.shape[3]]));let i=t;4===i.rank&&(i=Jn(t,[1,t.shape[0],t.shape[1],t.shape[2],t.shape[3]])),s(5===a.rank,()=>"Error in conv3dDerFilter: input must be rank 5, but got shape "+a.shape+"."),s(5===i.rank,()=>"Error in conv3dDerFilter: dy must be rank 5, but got shape "+i.shape+"."),s(5===n.length,()=>"Error in conv3dDerFilter: filterShape must be length 5, but got "+n+"."),s(a.shape[4]===n[3],()=>`Error in conv3dDerFilter: depth of input ${a.shape[4]}) must match input depth in filter (${n[3]}.`),s(i.shape[4]===n[4],()=>`Error in conv3dDerFilter: depth of dy (${i.shape[4]}) must match output depth for filter (${n[4]}).`);const u={x:a,dy:i},l={strides:r,pad:o,filterShape:n};return De.runKernel("Conv3DBackpropFilterV2",u,l)}}),xu={kernelName:"Conv3D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:r,strides:o,pad:a}=n;s(Vn(r),()=>`Error in gradient of conv3D: dilation rates greater than 1 are not yet supported in gradients. Got dilations '${r}'`);const[i,u]=t;return{x:()=>vr(i.shape,e,u,o,a),filter:()=>vu(i,e,u.shape,o,a)}}},Su={kernelName:"Cos",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(lo(Cs(yt(n,"float32"))),e)}}},Eu={kernelName:"Cosh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(Bs(yt(n,"float32")),e)}}},Du={kernelName:"Cumsum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{axis:o,exclusive:s,reverse:a}=n;return{x:()=>{const t=vo([o],r.rank);let n=Dr(e,o,s,!a);return null!=t&&(n=Bt(n,t)),n}}}},Iu={kernelName:"DepthwiseConv2dNative",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const{dilations:r,strides:o,pad:a,dimRoundingMode:i}=n,u=null==r?[1,1]:r;s(Vn(u),()=>`Error in gradient of depthwiseConv2dNative: dilation rates greater than 1 are not yet supported. Got dilations '${u}'`);const[l,c]=t;return s(4===l.rank,()=>`Error in gradient of depthwiseConv2dNative: input must be rank 4, but got rank ${l.rank}.`),s(4===c.rank,()=>`Error in gradient of depthwiseConv2dNative: filter must be rank 4, but got rank ${c.rank}.`),s(l.shape[3]===c.shape[2],()=>`Error in gradient of depthwiseConv2d: number of input channels (${l.shape[3]}) must match the inChannels dimension in filter ${c.shape[2]}.`),s(Hn(o,u),()=>`Error in gradient of depthwiseConv2d: Either strides or dilations must be  1. Got strides ${o} and dilations '${u}'.`),null!=i&&s(h(a),()=>`Error in depthwiseConv2d: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`),{x:()=>Oa(l.shape,e,c,o,a,r,i),filter:()=>qa(l,e,c.shape,o,a,r,i)}}},Nu={kernelName:"Dilation2D",inputsToSave:["x","filter"],gradFunc:(e,t,n)=>{const[r,o]=t,s={x:r,filter:o,dy:e},a={x:r,filter:o,dy:e};return{x:()=>De.runKernel("Dilation2DBackpropInput",s,n),filter:()=>De.runKernel("Dilation2DBackpropFilter",a,n)}}},Au={kernelName:"Elu",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t,r={dy:e,y:n};return{x:()=>De.runKernel("EluGrad",r)}}},Mu={kernelName:"Erf",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,r=En(qr(lo(Po(n))),2/Math.sqrt(Math.PI));return{x:()=>En(e,r)}}},Tu={kernelName:"Exp",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,n)}}},$u={kernelName:"ExpandDims",inputsToSave:["input"],gradFunc:(e,t)=>{const[n]=t;return{input:()=>Jn(e,n.shape)}}},_u={kernelName:"Expm1",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,qr(n))}}},Fu={kernelName:"Floor",gradFunc:e=>({x:()=>Cr(e)})},Ru={kernelName:"FloorDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{const t=Sn(e,yt(r,"float32")),s=$r(n.shape,o);return s.length>0?Jn(mo(t,s),n.shape):t},b:()=>{let t=En(e,yt(n,"float32"));const s=$r(r.shape,o);s.length>0&&(t=Jn(mo(t,s),r.shape));const a=Po(r);return lo(Sn(t,yt(a,"float32")))}}}},Cu={kernelName:"FusedBatchNorm",inputsToSave:["x","mean","variance","scale"],gradFunc:(e,t,n)=>{const{varianceEpsilon:r}=n,[o,s,a,i]=t,u=null==i?Ts(1):i,l=$r(s.shape,o.shape),c=[];if(1===s.rank){for(let e=0;e<o.shape.length-1;++e)c.push(o.shape[e]);c.push(1)}const h=fo(o,s),d=En(e,u),p=Ms(vn(a,Ts(r))),f=En(En(En(p,p),p),Ts(-.5));return{x:()=>1===s.rank?Jn(En(En(e,Kr(Jn(p,[1,1,1,s.shape[0]]),c)),u),o.shape):Jn(En(En(e,p),u),o.shape),mean:()=>{let e=En(En(p,Ts(-1)),d);return 1===s.rank&&(e=mo(e,l)),Jn(e,s.shape)},variance:()=>{let e=En(En(f,h),d);return 1===s.rank&&(e=mo(e,l)),Jn(e,s.shape)},scale:()=>{const t=En(h,p);let n=En(e,t);return 1===s.rank&&(n=mo(n,l)),Jn(n,s.shape)},offset:()=>{let t=e;return 1===s.rank&&(t=mo(t,l)),Jn(t,s.shape)}}}},Bu={kernelName:"GatherV2",inputsToSave:["x","indices"],gradFunc:(e,t,n)=>{const[r,o]=t,{axis:s}=n,a=p(s,r.shape)[0];return{x:()=>{const t=r.shape,n=o.size,i=t.slice(0,a),u=i.length,l=t.slice(s,t.length).slice(1),c=l.length,h=Pu(0,u),d=Pu(u+1,u+1+c),p=zu([i,[n],l]),f=Jn(e,p),m=Jn(o,[n]),g=zu([[u],h,d]),b=Bt(f,g);let y=sa(b,m,r.shape[a]);const w=xo(g);return y=Bt(y,w),y},indices:()=>o}}};function Pu(e,t){const n=[];for(let r=e;r<t;++r)n.push(r);return n}function zu(e){const t=[];for(let n=0;n<e.length;++n)for(let r=0;r<e[n].length;++r)t.push(e[n][r]);return t}const Lu={kernelName:"GreaterEqual",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t;return{a:()=>Cr(n),b:()=>Cr(r)}}},qu={kernelName:"Identity",gradFunc:e=>({x:()=>yt(e,"float32")})},Ou={kernelName:"IsFinite",gradFunc:e=>({x:()=>Cr(e)})},Gu={kernelName:"IsInf",gradFunc:e=>({x:()=>Cr(e)})},Ku={kernelName:"IsNan",gradFunc:e=>({x:()=>Cr(e)})},Wu={kernelName:"LeakyRelu",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{alpha:o}=n,s=jr(r,0);return{x:()=>Rr(s,e,En(e,o))}}},Uu={kernelName:"Log1p",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,vn(n,1))}}},Vu={kernelName:"Log",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,yt(n,"float32"))}}},Hu={kernelName:"LogSoftmax",inputsToSave:[],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[r]=t,{axis:o}=n;return{logits:()=>{const t=qr(r);return fo(e,En(mo(e,o,!0),t))}}}};const ju=Re({localResponseNormalizationBackprop_:function(e,t,n,r=5,o=1,s=1,a=.5){const i={x:e,y:t,dy:n},u={depthRadius:r,bias:o,alpha:s,beta:a};return De.runKernel("LRNGrad",i,u)}}),Ju={kernelName:"LRN",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[r,o]=t,{depthRadius:s,bias:a,alpha:i,beta:u}=n;return{x:()=>ju(r,o,e,s,a,i,u)}}};function Yu(e,t,n,r){return t.rank<n.rank&&(t=Jn(t,ko(t.shape,r))),e.rank<n.rank&&(e=Jn(e,ko(e.shape,r))),{x:()=>En(e,yt(Fr(n,t),e.dtype))}}const Zu={kernelName:"Max",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const r=n,{reductionIndices:o}=r,s=t[0],a=Yu(e,t[1],s,p(o,s.shape));return{x:()=>a.x()}}},Xu={kernelName:"Maximum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t;return{a:()=>En(e,yt(Jr(n,r),"float32")),b:()=>En(e,yt(to(n,r),"float32"))}}};const Qu=Re({maxPool3dGrad_:function(e,t,n,r,o,a=[1,1,1],i,u){const l=_e(e,"dy","maxPool3dGrad"),c=_e(t,"input","maxPool3dGrad"),d=_e(n,"output","maxPool3dGrad");let p=l,f=c,m=d,g=!1;4===c.rank&&(g=!0,p=Jn(l,[1,l.shape[0],l.shape[1],l.shape[2],l.shape[3]]),f=Jn(c,[1,c.shape[0],c.shape[1],c.shape[2],c.shape[3]]),m=Jn(d,[1,d.shape[0],d.shape[1],d.shape[2],d.shape[3]])),s(5===p.rank,()=>"Error in maxPool3dGrad: dy must be rank 5 but got rank "+p.rank+"."),s(5===f.rank,()=>"Error in maxPool3dGrad: input must be rank 5 but got rank "+f.rank+"."),s(5===m.rank,()=>"Error in maxPool3dGrad: output must be rank 5 but got rank "+m.rank+"."),s(Hn(o,a),()=>`Error in maxPool3dGrad: Either strides or dilations must be 1. Got strides ${o} and dilations '${a}'`),null!=u&&s(h(i),()=>`Error in maxPool3dGrad: pad must be an integer when using, dimRoundingMode ${u} but got pad ${i}.`);const b={dy:p,input:f,output:m},y={filterSize:r,strides:o,dilations:a,pad:i,dimRoundingMode:u},w=De.runKernel("MaxPool3DGrad",b,y);return g?Jn(w,[w.shape[1],w.shape[2],w.shape[3],w.shape[4]]):w}}),el={kernelName:"MaxPool3D",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[r,o]=t,{filterSize:s,strides:a,dilations:i,pad:u,dimRoundingMode:l}=n,c=null==i?[1,1,1]:i;return{x:()=>Qu(e,r,o,s,a,c,u,l)}}};const tl=Re({maxPoolGrad_:function(e,t,n,r,o,a,i){const u=_e(e,"dy","maxPoolGrad"),l=_e(t,"input","maxPoolGrad"),c=_e(n,"output","maxPoolGrad");s(l.rank===u.rank,()=>`Rank of input (${l.rank}) does not match rank of dy (${u.rank})`),s(4===u.rank,()=>"Error in maxPoolGrad: dy must be rank 4 but got rank "+u.rank+"."),s(4===l.rank,()=>"Error in maxPoolGrad: input must be rank 4 but got rank "+l.rank+"."),null!=i&&s(h(a),()=>`Error in maxPoolGrad: pad must be an integer when using, dimRoundingMode ${i} but got pad ${a}.`);const d={dy:u,input:l,output:c},p={filterSize:r,strides:o,pad:a,dimRoundingMode:i};return De.runKernel("MaxPoolGrad",d,p)}}),nl={kernelName:"PadV2",inputsToSave:["x"],gradFunc:(e,t,n)=>{const r=t[0],{paddings:o}=n,s=o.map(e=>e[0]);return{x:()=>er(e,s,r.shape)}}},rl={kernelName:"SpaceToBatchND",gradFunc:(e,t,n)=>{const{blockShape:r,paddings:o}=n;return{x:()=>rr(e,r,o)}}},ol={kernelName:"SplitV",gradFunc:(e,t,n)=>{const{axis:r}=n;return{x:()=>Xn(e,r)}}};const sl=[Ji,Yi,Zi,Xi,Qi,eu,tu,nu,ru,ou,su,au,uu,cu,hu,du,pu,fu,mu,gu,bu,yu,ku,wu,xu,Su,Eu,Du,Iu,Nu,{kernelName:"RealDiv",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{const t=Sn(e,yt(r,"float32")),s=$r(n.shape,o);return s.length>0?Jn(mo(t,s),n.shape):t},b:()=>{let t=En(e,yt(n,"float32"));const s=$r(r.shape,o);s.length>0&&(t=Jn(mo(t,s),r.shape));const a=Po(r);return lo(Sn(t,yt(a,"float32")))}}}},Au,Mu,Tu,$u,_u,Ru,Fu,Cu,Bu,Lu,qu,Ou,Gu,Ku,Wu,Uu,Vu,Hu,Ju,Zu,Zu,Xu,el,{kernelName:"MaxPool",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const[r,o]=t,{filterSize:s,strides:a,pad:i}=n;return{x:()=>tl(e,r,o,s,a,i)}}},{kernelName:"Mean",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{axis:o}=n,s=p(o,r.shape),a=l(wo(r.shape,s)[1]);return{x:()=>{const t=r.shape.slice();s.forEach(e=>{t[e]=1});const n=Jn(e,t);return Sn(En(n,Ko(r.shape,"float32")),a)}}}},{kernelName:"Min",inputsToSave:["x"],outputsToSave:[!0],gradFunc:(e,t,n)=>{const r=n,{axis:o}=r,[s,a]=t,i=Yu(e,a,s,p(o,s.shape));return{x:()=>i.x()}}},{kernelName:"Minimum",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t;return{a:()=>En(e,yt(no(n,r),"float32")),b:()=>En(e,yt(jr(n,r),"float32"))}}},{kernelName:"MirrorPad",inputsToSave:["x"],gradFunc:(e,t,n)=>{const r=t[0],{paddings:o}=n,s=o.map(e=>e[0]);return{x:()=>er(e,s,r.shape)}}},{kernelName:"Mod",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{const t=$r(n.shape,o);return t.length>0?Jn(mo(e,t),n.shape):e},b:()=>{const t=En(e,lo(Vr(Sn(n,r)))),s=$r(r.shape,o);return s.length>0?Jn(mo(t,s),r.shape):t}}}},{kernelName:"Multiply",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{const t=En(e,yt(r,"float32")),s=$r(n.shape,o);return s.length>0?Jn(mo(t,s),n.shape):t},b:()=>{const t=En(e,yt(n,"float32")),s=$r(r.shape,o);return s.length>0?Jn(mo(t,s),r.shape):t}}}},{kernelName:"Neg",gradFunc:e=>({x:()=>lo(e)})},{kernelName:"OneHot",inputsToSave:["indices"],gradFunc:(e,t)=>{const n=t[0];return{indices:()=>Go(n.shape,"float32")}}},{kernelName:"OnesLike",gradFunc:e=>({x:()=>Cr(e)})},{kernelName:"Pack",saveAllInputs:!0,gradFunc:(e,t,n)=>{const{axis:r}=n;return aa(e,r).map(e=>()=>e)}},nl,nl,{kernelName:"Pow",inputsToSave:["a","b"],outputsToSave:[!0],gradFunc:(e,t)=>{const[n,r,o]=t,s=n,a=r,i=_r(s.shape,a.shape);return{a:()=>{const t=yt(a,"float32");let n=En(e,En(t,Qo(s,fo(t,Ts(1)))));const r=$r(s.shape,i);return r.length>0&&(n=mo(n,r)),Jn(n,s.shape)},b:()=>{const t=jr(s,0),n=Rr(t,oo(s),Cr(s));let r=En(e,En(o,n));const u=$r(a.shape,i);return u.length>0&&(r=mo(r,u)),Jn(r,a.shape)}}}},{kernelName:"Prelu",inputsToSave:["x","alpha"],gradFunc:(e,t)=>{const[n,r]=t,o=jr(n,0);return{x:()=>Rr(o,e,En(e,r)),alpha:()=>{let t=Rr(o,Cr(e),En(e,n));const s=$r(r.shape,e.shape);return s.length>0&&(t=mo(t,s)),Jn(t,r.shape)}}}},{kernelName:"Reciprocal",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,lo(Po(n)))}}},{kernelName:"Relu6",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t,r=En(no(n,6),Zs(n));return{x:()=>En(e,yt(r,"float32"))}}},{kernelName:"Relu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,yt(Zs(n),"float32"))}}},{kernelName:"Reshape",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Jn(e,n.shape)}}},{kernelName:"ResizeBilinear",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[r]=t,o={dy:e,images:r};return{images:()=>De.runKernel("ResizeBilinearGrad",o,n)}}},{kernelName:"ResizeNearestNeighbor",inputsToSave:["images"],gradFunc:(e,t,n)=>{const[r]=t,o={dy:e,images:r};return{images:()=>De.runKernel("ResizeNearestNeighborGrad",o,n)}}},{kernelName:"Reverse",gradFunc:(e,t,n)=>{const{dims:r}=n,o=p(r,e.shape);return{x:()=>Ss(e,o)}}},{kernelName:"Round",gradFunc:e=>({x:()=>Cr(e)})},{kernelName:"Rsqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>lo(Sn(e,En(Qo(n,1.5),2)))}}},{kernelName:"Select",inputsToSave:["condition"],gradFunc:(e,t)=>{const[n]=t;return{condition:()=>yt(Cr(n),"float32"),t:()=>En(e,yt(n,e.dtype)),e:()=>En(e,yt(Do(n),e.dtype))}}},{kernelName:"Selu",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>{const t=jr(n,Ts(0)),r=Ts(1.7580993408473768),o=Ts(1.0507009873554805),s=En(e,o),a=En(En(e,r),qr(yt(n,"float32")));return Rr(t,s,a)}}}},{kernelName:"Sigmoid",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,En(n,fo(Ts(1),n)))}}},{kernelName:"Sign",gradFunc:e=>({x:()=>Cr(e)})},{kernelName:"Sin",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(Sr(yt(n,"float32")),e)}}},{kernelName:"Sinh",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(Er(yt(n,"float32")),e)}}},{kernelName:"Slice",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{begin:o,size:s}=n,a=r.shape,[i,u]=an(r,o,s),l=[];for(let t=0;t<e.rank;t++)l.push([i[t],a[t]-i[t]-u[t]]);return{x:()=>Vo(e,l)}}},{kernelName:"Softmax",outputsToSave:[!0],gradFunc:(e,t,n)=>{const[r]=t,{dim:o}=n,s=En(e,r);return{logits:()=>fo(s,En(mo(s,[o],!0),r))}}},{kernelName:"Softplus",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,Qn(n))}}},rl,rl,ol,ol,{kernelName:"Sqrt",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,En(Hs(yt(n,"float32")),2))}}},{kernelName:"SquaredDifference",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=Ts(2);return{a:()=>En(e,En(o,fo(n,r))),b:()=>En(e,En(o,fo(r,n)))}}},{kernelName:"Square",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(e,En(yt(n,"float32"),2))}}},{kernelName:"Step",gradFunc:e=>({x:()=>Cr(e)})},{kernelName:"Sub",inputsToSave:["a","b"],gradFunc:(e,t)=>{const[n,r]=t,o=_r(n.shape,r.shape);return{a:()=>{let t=e;const r=$r(n.shape,o);return r.length>0&&(t=mo(t,r)),Jn(t,n.shape)},b:()=>{let t=e;const n=$r(r.shape,o);return n.length>0&&(t=mo(t,n)),Jn(lo(t),r.shape)}}}},{kernelName:"Sum",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,o=r.shape.slice(),{axis:s}=n;p(s,r.shape).forEach(e=>{o[e]=1});const a=Jn(e,o),i=En(a,Ko(r.shape,"float32"));return{x:()=>i}}},{kernelName:"Tan",inputsToSave:["x"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>Sn(e,Po(Sr(n)))}}},{kernelName:"Tanh",outputsToSave:[!0],gradFunc:(e,t)=>{const[n]=t;return{x:()=>En(fo(Ts(1),Po(n)),e)}}},{kernelName:"Tile",inputsToSave:["x"],gradFunc:(e,t,n)=>{const[r]=t,{reps:o}=n;return{x:()=>{let t=Cr(r);if(1===r.rank)for(let n=0;n<o[0];++n)t=vn(t,er(e,[n*r.shape[0]],[r.shape[0]]));else if(2===r.rank)for(let n=0;n<o[0];++n)for(let s=0;s<o[1];++s)t=vn(t,er(e,[n*r.shape[0],s*r.shape[1]],[r.shape[0],r.shape[1]]));else if(3===r.rank)for(let n=0;n<o[0];++n)for(let s=0;s<o[1];++s)for(let a=0;a<o[2];++a)t=vn(t,er(e,[n*r.shape[0],s*r.shape[1],a*r.shape[2]],[r.shape[0],r.shape[1],r.shape[2]]));else{if(4!==r.rank)throw new Error("Gradient for tile operation is not implemented for rank-"+r.rank+" tensors yet.");for(let n=0;n<o[0];++n)for(let s=0;s<o[1];++s)for(let a=0;a<o[2];++a)for(let i=0;i<o[3];++i)t=vn(t,er(e,[n*r.shape[0],s*r.shape[1],a*r.shape[2],i*r.shape[3]],[r.shape[0],r.shape[1],r.shape[2],r.shape[3]]))}return t}}}},{kernelName:"Transpose",gradFunc:(e,t,n)=>{const r=n,{perm:o}=r,s=xo(o);return{x:()=>Bt(e,s)}}},{kernelName:"Unpack",gradFunc:(e,t,n)=>{const r=n,{axis:o}=r;return{value:()=>Ys(e,o)}}},{kernelName:"UnsortedSegmentSum",inputsToSave:["segmentIds"],gradFunc:(e,t)=>{const[n]=t;return{x:()=>function(e,t){const n=$o(t,Cr(t)),r=Hr(e,n);let o=Jr(t,Ts(0,"int32"));const s=r.rank-o.rank;for(let e=0;e<s;++e)o=Or(o,e+1);o=Eo(o,Ko(r.shape,"bool"));const a=Cr(r);return Rr(o,r,a)}(e,n)}}},{kernelName:"ZerosLike",gradFunc:e=>({x:()=>Cr(e)})}];for(const e of sl)V(e);le.prototype.abs=function(){return this.throwIfDisposed(),Dn(this)},le.prototype.acos=function(){return this.throwIfDisposed(),In(this)},le.prototype.acosh=function(){return this.throwIfDisposed(),Nn(this)},le.prototype.addStrict=function(e){return this.throwIfDisposed(),ga(this,e)},le.prototype.add=function(e){return this.throwIfDisposed(),vn(this,e)},le.prototype.all=function(e,t){return this.throwIfDisposed(),Mn(this,e,t)},le.prototype.any=function(e,t){return this.throwIfDisposed(),Tn(this,e,t)},le.prototype.argMax=function(e){return this.throwIfDisposed(),$n(this,e)},le.prototype.argMin=function(e){return this.throwIfDisposed(),_n(this,e)},le.prototype.asScalar=function(){return this.throwIfDisposed(),s(1===this.size,()=>"The array must have only 1 element."),Jn(this,[])},le.prototype.asType=function(e){return this.throwIfDisposed(),yt(this,e)},le.prototype.as1D=function(){return this.throwIfDisposed(),Jn(this,[this.size])},le.prototype.as2D=function(e,t){return this.throwIfDisposed(),Jn(this,[e,t])},le.prototype.as3D=function(e,t,n){return this.throwIfDisposed(),Jn(this,[e,t,n])},le.prototype.as4D=function(e,t,n,r){return this.throwIfDisposed(),Jn(this,[e,t,n,r])},le.prototype.as5D=function(e,t,n,r,o){return this.throwIfDisposed(),Jn(this,[e,t,n,r,o])},le.prototype.asin=function(){return this.throwIfDisposed(),Fn(this)},le.prototype.asinh=function(){return this.throwIfDisposed(),Rn(this)},le.prototype.atan=function(){return this.throwIfDisposed(),Cn(this)},le.prototype.atan2=function(e){return this.throwIfDisposed(),Bn(this,e)},le.prototype.atanh=function(){return this.throwIfDisposed(),Pn(this)},le.prototype.avgPool=function(e,t,n,r){return this.throwIfDisposed(),Yn(this,e,t,n,r)},le.prototype.batchToSpaceND=function(e,t){return this.throwIfDisposed(),rr(this,e,t)},le.prototype.batchNorm=function(e,t,n,r,o){return this.throwIfDisposed(),or(this,e,t,n,r,o)},le.prototype.broadcastTo=function(e){return this.throwIfDisposed(),lr(this,e)},le.prototype.cast=function(e){return this.throwIfDisposed(),yt(this,e)},le.prototype.ceil=function(){return this.throwIfDisposed(),cr(this)},le.prototype.clipByValue=function(e,t){return this.throwIfDisposed(),hr(this,e,t)},le.prototype.concat=function(e,t){return this.throwIfDisposed(),e instanceof le&&(e=[e]),Xn([this,...e],t)},le.prototype.conv1d=function(e,t,n,r,o,s){return this.throwIfDisposed(),br(this,e,t,n,r,o,s)},le.prototype.conv2dTranspose=function(e,t,n,r,o){return this.throwIfDisposed(),wr(this,e,t,n,r,o)},le.prototype.conv2d=function(e,t,n,r,o,s){return this.throwIfDisposed(),gr(this,e,t,n,r,o,s)},le.prototype.cos=function(){return this.throwIfDisposed(),Sr(this)},le.prototype.cosh=function(){return this.throwIfDisposed(),Er(this)},le.prototype.cumsum=function(e,t,n){return this.throwIfDisposed(),Dr(this,e,t,n)},le.prototype.depthToSpace=function(e,t){return this.throwIfDisposed(),Nr(this,e,t)},le.prototype.depthwiseConv2D=function(e,t,n,r,o,s){return bn("depthwiseConv2D is deprecated, use depthwiseConv2d instead"),this.throwIfDisposed(),Ar(this,e,t,n,r,o,s)},le.prototype.depthwiseConv2d=function(e,t,n,r,o,s){return this.throwIfDisposed(),Ar(this,e,t,n,r,o,s)},le.prototype.dilation2d=function(e,t,n,r,o){return this.throwIfDisposed(),Tr(this,e,t,n,r,o)},le.prototype.divNoNan=function(e){return this.throwIfDisposed(),Br(this,e)},le.prototype.divStrict=function(e){return this.throwIfDisposed(),ba(this,e)},le.prototype.div=function(e){return this.throwIfDisposed(),Sn(this,e)},le.prototype.dot=function(e){return this.throwIfDisposed(),Pr(this,e)},le.prototype.elu=function(){return this.throwIfDisposed(),zr(this)},le.prototype.equalStrict=function(e){return this.throwIfDisposed(),ca(this,e)},le.prototype.equal=function(e){return this.throwIfDisposed(),Fr(this,e)},le.prototype.erf=function(){return this.throwIfDisposed(),Lr(this)},le.prototype.exp=function(){return this.throwIfDisposed(),qr(this)},le.prototype.expandDims=function(e){return this.throwIfDisposed(),Or(this,e)},le.prototype.expm1=function(){return this.throwIfDisposed(),Gr(this)},le.prototype.fft=function(){return this.throwIfDisposed(),Gs(this)},le.prototype.flatten=function(){return this.throwIfDisposed(),Jn(this,[this.size])},le.prototype.floor=function(){return this.throwIfDisposed(),Vr(this)},le.prototype.floorDiv=function(e){return this.throwIfDisposed(),xn(this,e)},le.prototype.gather=function(e,t){return this.throwIfDisposed(),Hr(this,e,t)},le.prototype.greaterEqualStrict=function(e){return this.throwIfDisposed(),ha(this,e)},le.prototype.greaterEqual=function(e){return this.throwIfDisposed(),Jr(this,e)},le.prototype.greaterStrict=function(e){return this.throwIfDisposed(),da(this,e)},le.prototype.greater=function(e){return this.throwIfDisposed(),jr(this,e)},le.prototype.ifft=function(){return this.throwIfDisposed(),Ks(this)},le.prototype.irfft=function(){return this.throwIfDisposed(),Ws(this)},le.prototype.isFinite=function(){return this.throwIfDisposed(),Zr(this)},le.prototype.isInf=function(){return this.throwIfDisposed(),Xr(this)},le.prototype.isNaN=function(){return this.throwIfDisposed(),Qr(this)},le.prototype.leakyRelu=function(e){return this.throwIfDisposed(),eo(this,e)},le.prototype.lessEqualStrict=function(e){return this.throwIfDisposed(),pa(this,e)},le.prototype.lessEqual=function(e){return this.throwIfDisposed(),no(this,e)},le.prototype.lessStrict=function(e){return this.throwIfDisposed(),fa(this,e)},le.prototype.less=function(e){return this.throwIfDisposed(),to(this,e)},le.prototype.localResponseNormalization=function(e,t,n,r){return this.throwIfDisposed(),ro(this,e,t,n,r)},le.prototype.logSigmoid=function(){return this.throwIfDisposed(),ho(this)},le.prototype.logSoftmax=function(e){return this.throwIfDisposed(),go(this,e)},le.prototype.logSumExp=function(e,t){return this.throwIfDisposed(),So(this,e,t)},le.prototype.log=function(){return this.throwIfDisposed(),oo(this)},le.prototype.log1p=function(){return this.throwIfDisposed(),so(this)},le.prototype.logicalAnd=function(e){return this.throwIfDisposed(),Eo(this,e)},le.prototype.logicalNot=function(){return this.throwIfDisposed(),Do(this)},le.prototype.logicalOr=function(e){return this.throwIfDisposed(),Io(this,e)},le.prototype.logicalXor=function(e){return this.throwIfDisposed(),No(this,e)},le.prototype.matMul=function(e,t,n){return this.throwIfDisposed(),Rt(this,e,t,n)},le.prototype.maxPool=function(e,t,n,r){return this.throwIfDisposed(),Ao(this,e,t,n,r)},le.prototype.max=function(e,t){return this.throwIfDisposed(),po(this,e,t)},le.prototype.maximumStrict=function(e){return this.throwIfDisposed(),ya(this,e)},le.prototype.maximum=function(e){return this.throwIfDisposed(),$o(this,e)},le.prototype.mean=function(e,t){return this.throwIfDisposed(),_o(this,e,t)},le.prototype.min=function(e,t){return this.throwIfDisposed(),Fo(this,e,t)},le.prototype.minimumStrict=function(e){return this.throwIfDisposed(),wa(this,e)},le.prototype.minimum=function(e){return this.throwIfDisposed(),Ro(this,e)},le.prototype.mirrorPad=function(e,t){return this.throwIfDisposed(),Co(this,e,t)},le.prototype.modStrict=function(e){return this.throwIfDisposed(),ka(this,e)},le.prototype.mod=function(e){return this.throwIfDisposed(),Bo(this,e)},le.prototype.mulStrict=function(e){return this.throwIfDisposed(),va(this,e)},le.prototype.mul=function(e){return this.throwIfDisposed(),En(this,e)},le.prototype.neg=function(){return this.throwIfDisposed(),lo(this)},le.prototype.norm=function(e,t,n){return this.throwIfDisposed(),Da(this,e,t,n)},le.prototype.notEqualStrict=function(e){return this.throwIfDisposed(),ma(this,e)},le.prototype.notEqual=function(e){return this.throwIfDisposed(),Oo(this,e)},le.prototype.oneHot=function(e,t=1,n=0){return this.throwIfDisposed(),Ct(this,e,t,n)},le.prototype.onesLike=function(){return this.throwIfDisposed(),Wo(this)},le.prototype.pad=function(e,t){return this.throwIfDisposed(),Vo(this,e,t)},le.prototype.pool=function(e,t,n,r,o){return this.throwIfDisposed(),Xo(this,e,t,n,r,o)},le.prototype.powStrict=function(e){return this.throwIfDisposed(),xa(this,e)},le.prototype.pow=function(e){return this.throwIfDisposed(),Qo(this,e)},le.prototype.prelu=function(e){return this.throwIfDisposed(),es(this,e)},le.prototype.prod=function(e,t){return this.throwIfDisposed(),ts(this,e,t)},le.prototype.reciprocal=function(){return this.throwIfDisposed(),ks(this)},le.prototype.relu=function(){return this.throwIfDisposed(),vs(this)},le.prototype.relu6=function(){return this.throwIfDisposed(),xs(this)},le.prototype.reshapeAs=function(e){return this.throwIfDisposed(),Jn(this,e.shape)},le.prototype.reshape=function(e){return this.throwIfDisposed(),Jn(this,e)},le.prototype.resizeBilinear=function(e,t,n){return this.throwIfDisposed(),fi(this,e,t,n)},le.prototype.resizeNearestNeighbor=function(e,t,n){return this.throwIfDisposed(),mi(this,e,t,n)},le.prototype.reverse=function(e){return this.throwIfDisposed(),Ss(this,e)},le.prototype.rfft=function(){return this.throwIfDisposed(),Vs(this)},le.prototype.round=function(){return this.throwIfDisposed(),As(this)},le.prototype.rsqrt=function(){return this.throwIfDisposed(),Ms(this)},le.prototype.selu=function(){return this.throwIfDisposed(),$s(this)},le.prototype.separableConv2d=function(e,t,n,r,o,s){return this.throwIfDisposed(),_s(this,e,t,n,r,o,s)},le.prototype.sigmoid=function(){return this.throwIfDisposed(),Qn(this)},le.prototype.sign=function(){return this.throwIfDisposed(),Rs(this)},le.prototype.sin=function(){return this.throwIfDisposed(),Cs(this)},le.prototype.sinh=function(){return this.throwIfDisposed(),Bs(this)},le.prototype.slice=function(e,t){return this.throwIfDisposed(),er(this,e,t)},le.prototype.softmax=function(e){return this.throwIfDisposed(),Os(this,e)},le.prototype.softplus=function(){return this.throwIfDisposed(),co(this)},le.prototype.spaceToBatchND=function(e,t){return this.throwIfDisposed(),Zo(this,e,t)},le.prototype.split=function(e,t){return this.throwIfDisposed(),Us(this,e,t)},le.prototype.sqrt=function(){return this.throwIfDisposed(),Hs(this)},le.prototype.square=function(){return this.throwIfDisposed(),Po(this)},le.prototype.squaredDifference=function(e){return this.throwIfDisposed(),js(this,e)},le.prototype.squaredDifferenceStrict=function(e){return this.throwIfDisposed(),Sa(this,e)},le.prototype.squeeze=function(e){return this.throwIfDisposed(),Js(this,e)},le.prototype.stack=function(e,t){this.throwIfDisposed();const n=e instanceof le?[this,e]:[this,...e];return Ys(n,t)},le.prototype.step=function(e){return this.throwIfDisposed(),Zs(this,e)},le.prototype.stridedSlice=function(e,t,n,r,o,s,a,i){return this.throwIfDisposed(),Xs(this,e,t,n,r,o,s,a,i)},le.prototype.subStrict=function(e){return this.throwIfDisposed(),Ea(this,e)},le.prototype.sub=function(e){return this.throwIfDisposed(),fo(this,e)},le.prototype.sum=function(e,t){return this.throwIfDisposed(),mo(this,e,t)},le.prototype.tan=function(){return this.throwIfDisposed(),Qs(this)},le.prototype.tanh=function(){return this.throwIfDisposed(),tr(this)},le.prototype.tile=function(e){return this.throwIfDisposed(),Kr(this,e)},le.prototype.toBool=function(){return this.throwIfDisposed(),yt(this,"bool")},le.prototype.toFloat=function(){return this.throwIfDisposed(),yt(this,"float32")},le.prototype.toInt=function(){return this.throwIfDisposed(),yt(this,"int32")},le.prototype.topk=function(e,t){return this.throwIfDisposed(),na(this,e,t)},le.prototype.transpose=function(e){return this.throwIfDisposed(),Bt(this,e)},le.prototype.unique=function(e){return this.throwIfDisposed(),oa(this,e)},le.prototype.unsortedSegmentSum=function(e,t){return this.throwIfDisposed(),sa(this,e,t)},le.prototype.unstack=function(e){return this.throwIfDisposed(),aa(this,e)},le.prototype.where=function(e,t){return this.throwIfDisposed(),Rr(e,this,t)},le.prototype.zerosLike=function(){return this.throwIfDisposed(),Cr(this)},e.Abs="Abs",e.Acos="Acos",e.Acosh="Acosh",e.AdadeltaOptimizer=Bi,e.AdagradOptimizer=Pi,e.AdamOptimizer=zi,e.AdamaxOptimizer=Li,e.Add="Add",e.AddN="AddN",e.All="All",e.Any="Any",e.ArgMax="ArgMax",e.ArgMin="ArgMin",e.Asin="Asin",e.Asinh="Asinh",e.Atan="Atan",e.Atan2="Atan2",e.Atanh="Atanh",e.AvgPool="AvgPool",e.AvgPool3D="AvgPool3D",e.AvgPool3DGrad="AvgPool3DGrad",e.AvgPoolGrad="AvgPoolGrad",e.BatchMatMul="BatchMatMul",e.BatchToSpaceND="BatchToSpaceND",e.Bincount="Bincount",e.BroadcastTo="BroadcastTo",e.Cast="Cast",e.Ceil="Ceil",e.ClipByValue="ClipByValue",e.Complex="Complex",e.ComplexAbs="ComplexAbs",e.Concat="Concat",e.Conv2D="Conv2D",e.Conv2DBackpropFilter="Conv2DBackpropFilter",e.Conv2DBackpropInput="Conv2DBackpropInput",e.Conv3D="Conv3D",e.Conv3DBackpropFilterV2="Conv3DBackpropFilterV2",e.Conv3DBackpropInputV2="Conv3DBackpropInputV2",e.Cos="Cos",e.Cosh="Cosh",e.CropAndResize="CropAndResize",e.Cumsum="Cumsum",e.DataStorage=class{constructor(e,t){this.backend=e,this.dataMover=t,this.data=new WeakMap,this.dataIdsCount=0}get(e){return this.data.has(e)||this.dataMover.moveData(this.backend,e),this.data.get(e)}set(e,t){this.dataIdsCount++,this.data.set(e,t)}has(e){return this.data.has(e)}delete(e){return this.dataIdsCount--,this.data.delete(e)}numDataIds(){return this.dataIdsCount}},e.DenseBincount="DenseBincount",e.DepthToSpace="DepthToSpace",e.DepthwiseConv2dNative="DepthwiseConv2dNative",e.DepthwiseConv2dNativeBackpropFilter="DepthwiseConv2dNativeBackpropFilter",e.DepthwiseConv2dNativeBackpropInput="DepthwiseConv2dNativeBackpropInput",e.Diag="Diag",e.Dilation2D="Dilation2D",e.Dilation2DBackpropFilter="Dilation2DBackpropFilter",e.Dilation2DBackpropInput="Dilation2DBackpropInput",e.Elu="Elu",e.EluGrad="EluGrad",e.Environment=C,e.Equal="Equal",e.Erf="Erf",e.Exp="Exp",e.ExpandDims="ExpandDims",e.Expm1="Expm1",e.FFT="FFT",e.Fill="Fill",e.FlipLeftRight="FlipLeftRight",e.Floor="Floor",e.FloorDiv="FloorDiv",e.FromPixels="FromPixels",e.FusedBatchNorm="FusedBatchNorm",e.FusedConv2D="FusedConv2D",e.FusedDepthwiseConv2D="FusedDepthwiseConv2D",e.GatherNd="GatherNd",e.GatherV2="GatherV2",e.Greater="Greater",e.GreaterEqual="GreaterEqual",e.IFFT="IFFT",e.Identity="Identity",e.Imag="Imag",e.IsFinite="IsFinite",e.IsInf="IsInf",e.IsNan="IsNan",e.KernelBackend=t,e.LRN="LRN",e.LRNGrad="LRNGrad",e.LeakyRelu="LeakyRelu",e.Less="Less",e.LessEqual="LessEqual",e.LinSpace="LinSpace",e.Log="Log",e.Log1p="Log1p",e.LogSoftmax="LogSoftmax",e.LogicalAnd="LogicalAnd",e.LogicalNot="LogicalNot",e.LogicalOr="LogicalOr",e.Max="Max",e.MaxPool="MaxPool",e.MaxPool3D="MaxPool3D",e.MaxPool3DGrad="MaxPool3DGrad",e.MaxPoolGrad="MaxPoolGrad",e.MaxPoolWithArgmax="MaxPoolWithArgmax",e.Maximum="Maximum",e.Mean="Mean",e.Min="Min",e.Minimum="Minimum",e.MirrorPad="MirrorPad",e.Mod="Mod",e.MomentumOptimizer=Oi,e.Multinomial="Multinomial",e.Multiply="Multiply",e.Neg="Neg",e.NonMaxSuppressionV3="NonMaxSuppressionV3",e.NonMaxSuppressionV4="NonMaxSuppressionV4",e.NonMaxSuppressionV5="NonMaxSuppressionV5",e.NotEqual="NotEqual",e.OP_SCOPE_SUFFIX="__op",e.OneHot="OneHot",e.OnesLike="OnesLike",e.Optimizer=Ci,e.Pack="Pack",e.PadV2="PadV2",e.Pool="Pool",e.Pow="Pow",e.Prelu="Prelu",e.Prod="Prod",e.RMSPropOptimizer=Gi,e.Range="Range",e.Real="Real",e.RealDiv="RealDiv",e.Reciprocal="Reciprocal",e.Relu="Relu",e.Relu6="Relu6",e.Reshape="Reshape",e.ResizeBilinear="ResizeBilinear",e.ResizeBilinearGrad="ResizeBilinearGrad",e.ResizeNearestNeighbor="ResizeNearestNeighbor",e.ResizeNearestNeighborGrad="ResizeNearestNeighborGrad",e.Reverse="Reverse",e.RotateWithOffset="RotateWithOffset",e.Round="Round",e.Rsqrt="Rsqrt",e.SGDOptimizer=qi,e.ScatterNd="ScatterNd",e.Select="Select",e.Selu="Selu",e.Sigmoid="Sigmoid",e.Sign="Sign",e.Sin="Sin",e.Sinh="Sinh",e.Slice="Slice",e.Softmax="Softmax",e.Softplus="Softplus",e.SpaceToBatchND="SpaceToBatchND",e.SparseToDense="SparseToDense",e.SplitV="SplitV",e.Sqrt="Sqrt",e.Square="Square",e.SquaredDifference="SquaredDifference",e.Step="Step",e.StridedSlice="StridedSlice",e.Sub="Sub",e.Sum="Sum",e.Tan="Tan",e.Tanh="Tanh",e.Tensor=le,e.TensorBuffer=ae,e.Tile="Tile",e.TopK="TopK",e.Transpose="Transpose",e.Unique="Unique",e.Unpack="Unpack",e.UnsortedSegmentSum="UnsortedSegmentSum",e.Variable=ce,e.ZerosLike="ZerosLike",e._FusedMatMul="_FusedMatMul",e.abs=Dn,e.acos=In,e.acosh=Nn,e.add=vn,e.addN=An,e.addStrict=ga,e.all=Mn,e.any=Tn,e.argMax=$n,e.argMin=_n,e.asin=Fn,e.asinh=Rn,e.atan=Cn,e.atan2=Bn,e.atanh=Pn,e.avgPool=Yn,e.avgPool3d=Zn,e.backend=function(){return De.backend},e.backend_util=Hi,e.basicLSTMCell=nr,e.batchNorm=or,e.batchNorm2d=sr,e.batchNorm3d=ar,e.batchNorm4d=ir,e.batchToSpaceND=rr,e.bincount=ur,e.booleanMaskAsync=la,e.broadcastTo=lr,e.browser=Gt,e.buffer=bt,e.cast=yt,e.ceil=cr,e.clipByValue=hr,e.clone=wt,e.complex=Ce,e.concat=Xn,e.concat1d=dr,e.concat2d=pr,e.concat3d=fr,e.concat4d=mr,e.conv1d=br,e.conv2d=gr,e.conv2dTranspose=wr,e.conv3d=kr,e.conv3dTranspose=xr,e.copyRegisteredKernels=function(e,t){W(e).forEach(e=>{U(Object.assign({},e,{backendName:t}))})},e.cos=Sr,e.cosh=Er,e.cosineWindow=_a,e.cumsum=Dr,e.customGrad=io,e.denseBincount=Ir,e.deprecationWarn=bn,e.depthToSpace=Nr,e.depthwiseConv2d=Ar,e.device_util=Ae,e.diag=Mr,e.dilation2d=Tr,e.disableDeprecationWarnings=function(){B().set("DEPRECATION_WARNINGS_ENABLED",!1),console.warn("TensorFlow.js deprecation warnings have been disabled.")},e.dispose=wn,e.disposeVariables=function(){De.disposeVariables()},e.div=Sn,e.divNoNan=Br,e.divStrict=ba,e.dot=Pr,e.dropout=Ta,e.elu=zr,e.enableDebugMode=function(){B().set("DEBUG",!0)},e.enableProdMode=function(){B().set("PROD",!0)},e.enclosingPowerOfTwo=$a,e.engine=function(){return De},e.env=B,e.equal=Fr,e.equalStrict=ca,e.erf=Lr,e.exp=qr,e.expandDims=Or,e.expm1=Gr,e.eye=Wr,e.fft=Gs,e.fill=Ur,e.findBackend=function(e){return De.findBackend(e)},e.findBackendFactory=function(e){return De.findBackendFactory(e)},e.floor=Vr,e.floorDiv=xn,e.fused=Wa,e.gather=Hr,e.gatherND=Ma,e.gather_util=Wt,e.getBackend=function(){return De.backendName},e.getGradient=K,e.getKernel=G,e.getKernelsForBackend=W,e.grad=function(e){return s(N(e),()=>"The f passed in grad(f) must be a function"),(t,n)=>{const r=_e(t,"x","tf.grad","string_or_numeric"),o=null!=n?_e(n,"dy","tf.grad"):null;return De.tidy(()=>{const{value:t,grads:n}=De.gradients(()=>e(r),[r],o);return null!=o&&a(t.shape,o.shape,"The shape of dy passed in grad(f)(x, dy) must match the shape returned by f(x)"),uo(n),n[0]})}},e.grads=function(e){return s(N(e),()=>"The f passed in grads(f) must be a function"),(t,n)=>{s(Array.isArray(t),()=>"The args passed in grads(f)(args) must be an array of `Tensor`s or `TensorLike`s");const r=Fe(t,"args","tf.grads","string_or_numeric"),o=null!=n?_e(n,"dy","tf.grads"):null;return De.tidy(()=>{const{value:t,grads:n}=De.gradients(()=>e(...r),r,o);return null!=o&&a(t.shape,o.shape,"The shape of dy passed in grads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),uo(n),n})}},e.greater=jr,e.greaterEqual=Jr,e.greaterEqualStrict=ha,e.greaterStrict=da,e.ifft=Ks,e.imag=Yr,e.image=_i,e.inTopKAsync=Fa,e.io=Ft,e.irfft=Ws,e.isFinite=Zr,e.isInf=Xr,e.isNaN=Qr,e.keep=kn,e.kernel_impls=ji,e.leakyRelu=eo,e.less=to,e.lessEqual=no,e.lessEqualStrict=pa,e.lessStrict=fa,e.linalg=Fi,e.linspace=function(e,t,n){if(n<=0)throw new Error("The number of values should be positive.");const r={start:e,stop:t,num:n};return De.runKernel("LinSpace",{},r)},e.localResponseNormalization=ro,e.log=oo,e.log1p=so,e.logSigmoid=ho,e.logSoftmax=go,e.logSumExp=So,e.logicalAnd=Eo,e.logicalNot=Do,e.logicalOr=Io,e.logicalXor=No,e.losses=Ri,e.matMul=Rt,e.math=zt,e.max=po,e.maxPool=Ao,e.maxPool3d=Mo,e.maxPoolWithArgmax=To,e.maximum=$o,e.maximumStrict=ya,e.mean=_o,e.memory=function(){return De.memory()},e.min=Fo,e.minimum=Ro,e.minimumStrict=wa,e.mirrorPad=Co,e.mod=Bo,e.modStrict=ka,e.moments=zo,e.movingAverage=Ia,e.mul=En,e.mulStrict=va,e.multiRNNCell=Lo,e.multinomial=qo,e.neg=lo,e.nextFrame=function(){return new Promise(e=>Ui(()=>e()))},e.norm=Da,e.notEqual=Oo,e.notEqualStrict=ma,e.oneHot=Ct,e.ones=Ko,e.onesLike=Wo,e.op=Re,e.outerProduct=Uo,e.pad=Vo,e.pad1d=Ho,e.pad2d=jo,e.pad3d=Jo,e.pad4d=Yo,e.pool=Xo,e.pow=Qo,e.powStrict=xa,e.prelu=es,e.print=kt,e.prod=ts,e.profile=function(e){return De.profile(e)},e.rand=ns,e.randomGamma=ms,e.randomNormal=gs,e.randomUniform=bs,e.range=ys,e.ready=function(){return De.ready()},e.real=ws,e.reciprocal=ks,e.registerBackend=function(e,t,n=1){return De.registerBackend(e,t,n)},e.registerGradient=V,e.registerKernel=U,e.relu=vs,e.relu6=xs,e.removeBackend=function(e){De.removeBackend(e)},e.reshape=Jn,e.reverse=Ss,e.reverse1d=Es,e.reverse2d=Ds,e.reverse3d=Is,e.reverse4d=Ns,e.rfft=Vs,e.round=As,e.rsqrt=Ms,e.scalar=Ts,e.scatterND=Na,e.scatter_util=jt,e.selu=$s,e.separableConv2d=_s,e.serialization=dn,e.setBackend=function(e){return De.setBackend(e)},e.setPlatform=function(e,t){B().setPlatform(e,t)},e.setdiff1dAsync=Fs,e.sigmoid=Qn,e.sign=Rs,e.signal=$i,e.sin=Cs,e.sinh=Bs,e.slice=er,e.slice1d=Ps,e.slice2d=zs,e.slice3d=Ls,e.slice4d=qs,e.slice_util=un,e.softmax=Os,e.softplus=co,e.spaceToBatchND=Zo,e.sparseToDense=Aa,e.spectral=Ti,e.split=Us,e.sqrt=Hs,e.square=Po,e.squaredDifference=js,e.squaredDifferenceStrict=Sa,e.squeeze=Js,e.stack=Ys,e.step=Zs,e.stridedSlice=Xs,e.sub=fo,e.subStrict=Ea,e.sum=mo,e.sumOutType=function(e){return be(e,"int32")},e.tan=Qs,e.tanh=tr,e.tensor=Pe,e.tensor1d=ea,e.tensor2d=ta,e.tensor3d=Lt,e.tensor4d=function(e,t,n){if(i(e),null!=t&&4!==t.length)throw new Error("tensor4d() requires shape to have four numbers");const r=Te(e,n);if(4!==r.length&&1!==r.length)throw new Error("tensor4d() requires values to be number[][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor4d() requires shape to be provided when `values` are a flat array");return Be(e,t,r,n)},e.tensor5d=function(e,t,n){if(i(e),null!=t&&5!==t.length)throw new Error("tensor5d() requires shape to have five numbers");const r=Te(e,n);if(5!==r.length&&1!==r.length)throw new Error("tensor5d() requires values to be number[][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor5d() requires shape to be provided when `values` are a flat array");return Be(e,t,r,n)},e.tensor6d=function(e,t,n){if(i(e),null!=t&&6!==t.length)throw new Error("tensor6d() requires shape to have six numbers");const r=Te(e,n);if(6!==r.length&&1!==r.length)throw new Error("tensor6d() requires values to be number[][][][][][] or flat/TypedArray");if(1===r.length&&null==t)throw new Error("tensor6d() requires shape to be provided when `values` are a flat array");return Be(e,t=t||r,r,n)},e.tensor_util=ve,e.test_util=gn,e.tidy=yn,e.tile=Kr,e.time=function(e){return De.time(e)},e.topk=na,e.train=Wi,e.transpose=Bt,e.truncatedNormal=ra,e.unique=oa,e.unregisterGradient=function(e){if(!O.has(e))throw new Error(`The gradient '${e}' for backend is not registered`);O.delete(e)},e.unregisterKernel=function(e,t){const n=H(e,t);if(!q.has(n))throw new Error(`The kernel '${e}' for backend '${t}' is not registered`);q.delete(n)},e.unsortedSegmentSum=sa,e.unstack=aa,e.upcastType=be,e.util=X,e.valueAndGrad=function(e){return s(N(e),()=>"The f passed in valueAndGrad(f) must be a function"),(t,n)=>{s(t instanceof le,()=>"The x passed in valueAndGrad(f)(x) must be a tensor"),s(null==n||n instanceof le,()=>"The dy passed in valueAndGrad(f)(x, dy) must be a tensor");const{grads:r,value:o}=De.gradients(()=>e(t),[t],n);return uo(r),{grad:r[0],value:o}}},e.valueAndGrads=function(e){return s(N(e),()=>"The f passed in valueAndGrads(f) must be a function"),(t,n)=>{s(Array.isArray(t)&&t.every(e=>e instanceof le),()=>"The args passed in valueAndGrads(f)(args) must be array of tensors"),s(null==n||n instanceof le,()=>"The dy passed in valueAndGrads(f)(args, dy) must be a tensor");const r=De.gradients(()=>e(...t),t,n);return null!=n&&a(r.value.shape,n.shape,"The shape of dy passed in valueAndGrads(f)([x1,...], dy) must match the shape returned by f([x1,...])"),uo(r.grads),r}},e.variable=function(e,t=!0,n,r){return De.makeVariable(e,t,n,r)},e.variableGrads=ao,e.version_core="2.8.6",e.where=Rr,e.whereAsync=ua,e.zeros=Go,e.zerosLike=Cr,Object.defineProperty(e,"__esModule",{value:!0})}));
//# sourceMappingURL=tf-core.es2017.min.js.map
