/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { reshape } from '../../ops/reshape';
import { Tensor } from '../../tensor';
import { assert } from '../../util';
/** Converts a size-1 `tf.Tensor` to a `tf.Scalar`.
 * @doc {heading: 'Tensors', subheading: 'Classes'}
 */
Tensor.prototype.asScalar = function () {
    this.throwIfDisposed();
    assert(this.size === 1, () => 'The array must have only 1 element.');
    return reshape(this, []);
};
//# sourceMappingURL=as_scalar.js.map