/**
 * @license
 * Copyright 2020 Google LLC. All Rights Reserved.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * =============================================================================
 */
import { Cosh } from '../kernel_names';
import { cast } from '../ops/cast';
import { mul } from '../ops/mul';
import { sinh } from '../ops/sinh';
export const coshGradConfig = {
    kernelName: Cosh,
    inputsToSave: ['x'],
    gradFunc: (dy, saved) => {
        const [x] = saved;
        return { x: () => mul(sinh(cast(x, 'float32')), dy) };
    }
};
//# sourceMappingURL=Cosh_grad.js.map