import { Tensor } from '../tensor';
import { Rank } from '../types';
import { DataType, ShapeMap } from '../types';
import { KernelBackend } from './backend';
export * from '../ops/axis_util';
export * from '../ops/broadcast_util';
export * from '../ops/concat_util';
export * from '../ops/conv_util';
export * from '../ops/fused_util';
export * from '../ops/fused_types';
export * from '../ops/reduce_util';
import * as slice_util from '../ops/slice_util';
export { slice_util };
export { BackendValues, TypedArray, upcastType, PixelData } from '../types';
export { MemoryInfo, TimingInfo } from '../engine';
export * from '../ops/rotate_util';
export * from '../ops/array_ops_util';
export * from '../ops/gather_nd_util';
export * from '../ops/scatter_nd_util';
export * from '../ops/selu_util';
export * from '../ops/fused_util';
export * from '../ops/erf_util';
export * from '../log';
export * from '../backends/complex_util';
export * from '../ops/split_util';
import * as segment_util from '../ops/segment_util';
export { segment_util };
export declare function castTensor<T extends Tensor>(x: T, dtype: DataType, backend: KernelBackend): T;
export declare function reshapeTensor<T extends Tensor, R extends Rank>(x: T, shape: ShapeMap[R]): Tensor<R>;
export declare function fromUint8ToStringArray(vals: Uint8Array[]): string[];
export declare function fromStringArrayToUint8(strings: string[]): Uint8Array[];
