<?php
session_start();
require_once("../config/database.php");
require_once("lti.php");
require_once("lib.php");

$lti = new LTI();

$user_id = $_GET['user_id'];
$contentdtl_id = $_GET['id'];
$offering_id = $_GET['oid'];
$foruserid = "";
if (isset($_GET['foruserid'])) {
    $foruserid = $_GET['foruserid'];
}
$comp_id = $_GET['cid'];

$type = new \stdClass();
$content_details = new stdClass();
$lti_class = new stdClass();
$grade_items = new stdClass();
$config = array();
try {
    //Fetch Content details
    $content_details_record = $lti->get_content_details($contentdtl_id);
    if ($result = $content_details_record->fetch(PDO::FETCH_ASSOC)) {
        $content_details->contentdtl_id = $result['contentdtl_id'];
        $content_details->course_id = $result['course_id'];
        $content_details->content_name = $result['content_name'];
        $content_details->content_desc = $result['content_desc'];
    }
    //Fetch LTI
    $lti_class_record = $lti->get_lti($contentdtl_id);
    if ($result = $lti_class_record->fetch(PDO::FETCH_ASSOC)) {
        $lti_class->lti_id = $result['lti_id'];
        $lti_class->name = $result['name'];
        $lti_class->lti_types_id = $result['lti_types_id'];
        $lti_class->tool_url = $result['tool_url'];
        $lti_class->text = $result['text'];
        $lti_class->launch_container = $result['launch_container'];
        $lti_class->custom_id = $result['custom_id'];
        $lti_class->grade_max = $result['grade_max'];
    }
    //Fetch Grade Items
    $grade_items_record = $lti->get_grade_items($contentdtl_id, $lti_class->lti_id);
    if ($result = $grade_items_record->fetch(PDO::FETCH_ASSOC)) {
        $grade_items->name = $result['name'];
        $grade_items->lti_id = $result['lti_id'];
        $grade_items->grade_type = $result['grade_type'];
        $grade_items->grade_max = $result['grade_max'];
        $grade_items->grade_min = $result['grade_min'];
        $grade_items->grade_pass = $result['grade_pass'];
    }
    //Fetch LTI Types
    $lti_types_record = $lti->get_lti_types($lti_class->lti_types_id);
    if ($result = $lti_types_record->fetch(PDO::FETCH_ASSOC)) {
        $type->lti_typename = $result['tool_name'];
        $type->typeid = $result['lti_types_id'];
        $type->lti_toolurl = $result['tool_url'];
        $type->lti_ltiversion = $result['lti_version'];
        $type->lti_clientid = $result['client_id'];
        $type->toolproxyid = $result['tool_proxy_id'];
        $type->lti_parameters = $result['parameter'];
    }
    //Fetch LTI Types Config
    $stmt = $lti->get_lti_types_config($type->typeid);
    // fetch values
    while ($result = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $config[$result['name']] = $result['value'];
    }
    if (isset($config['publickeyset'])) {
        $type->lti_publickeyset = $config['publickeyset'];
    }
    if (isset($config['keytype'])) {
        $type->lti_keytype = $config['keytype'];
    }
    if (isset($config['initiatelogin'])) {
        $type->lti_initiatelogin = $config['initiatelogin'];
    }
    if (isset($config['sendname'])) {
        $type->lti_sendname = $config['sendname'];
    }
    if (isset($config['send_email_id'])) {
        $type->lti_sendemailaddr = $config['send_email_id'];
    }
    if (isset($config['accept_grades'])) {
        $type->lti_acceptgrades = $config['accept_grades'];
    }
    if (isset($config['customparameters'])) {
        $type->lti_customparameters = $config['customparameters'];
    }
    if (isset($config['launchcontainer'])) {
        $type->lti_launchcontainer = $config['launchcontainer'];
    }
    if (isset($config['content_item_selection_request'])) {
        $type->lti_toolurl_ContentItemSelectionRequest = $config['content_item_selection_request'];
    }
    // Get the parameters from the LTI services.
    foreach ($config as $name => $value) {
        if (strpos($name, 'ltiservice_') === 0) {
            $type->{$name} = $config[$name];
        }
    }
} catch (PDOException $e) {
    error_log("Caught $e");
}

if ($type->lti_ltiversion === LTI_VERSION_1P3) {
    /* if (!isset($SESSION->lti_initiatelogin_status)) {*/
    $msgtype = 'basic-lti-launch-request';
    //Tip: for admin if grade report called
    if ($action === 'gradeReport') {
        $msgtype = 'LtiSubmissionReviewRequest';
    }
    echo lti_initiate_login(
        $user_id,
        $content_details->course_id,
        $comp_id,
        $contentdtl_id,
        $offering_id,
        $lti_class,
        $type,
        $msgtype,
        '',
        '',
        $foruserid
    );
    exit;
    /* } else {
         unset($SESSION->lti_initiatelogin_status);
     }*/
}

//Tip: Check in next version
// $course = $DB->get_record('course', array('id' => $cm->course), '*', MUST_EXIST);
// $context = context_module::instance($cm->id);
// require_login($course, true, $cm);
// require_capability('mod/lti:view', $context);
// // Completion and trigger events.
// if ($triggerview) {
//     lti_view($lti, $course, $cm, $context);
// }
// $lti->cmid = $cm->id;
// lti_launch_tool($lti, $foruserid);
