<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}



function isAjaxRequest() {
    return !empty($_SERVER['HTTP_X_REQUESTED_WITH']) &&
           strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) === 'xmlhttprequest';
}

if (!isset($_SESSION['uid'])) {
    if (isAjaxRequest()) {
   
        echo "SESSION_EXPIRED"; // AJAX will detect this
    } else {
        header("Location:". LOGOUT_URL);

    }
    exit;
}

if (isset($_SESSION['LAST_ACTIVITY']) && (time() - $_SESSION['LAST_ACTIVITY']) > SESSION_TIMEOUT) {
    session_unset();
    session_destroy();

    if (isAjaxRequest()) {
        echo "SESSION_EXPIRED"; // For AJAX detection
    } else {
       header("Location:". LOGOUT_URL);
    }
    exit;
}

// Update last activity
$_SESSION['LAST_ACTIVITY'] = time();

?>