<?php


if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
include '../config/database.php';
require_once 'csrf.php';
// Manually check session still valid
if (!isset($_SESSION['uid'])) {
    echo "SESSION_EXPIRED";
    http_response_code(403);
    exit;
}



// Only regenerate if expired
if (isset($_SESSION['csrf_token']) && isset($_SESSION['csrf_token_time'])) {
    $age = time() - $_SESSION['csrf_token_time'];
    if ($age < CSRF_EXPIRY_SECONDS) {
    //     error_log("Token still valid: $age seconds old");
        echo $_SESSION['csrf_token']; // Still valid
        exit;
    }
    else {
      //   error_log("Token expired: $age seconds old — regenerating...");
         // Token expired — clean it up
        unset($_SESSION['csrf_token']);
        unset($_SESSION['csrf_token_time']);

        echo generate_csrf_token();
    }
}






