<?php

/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */

/**
 * Description of company
 *
 * @author Lenovo
 */
class Company {

    private $conn;
    private $company_profile = "compnay_profile";

    // constructor
    public function __construct() {
        $this->conn = DBConnection();
    }

    public function getCompanyDetail() {
        try {
            $query = "SELECT * FROM company_profile";
            // prepare query statement
            $stmt = $this->conn->prepare($query);
            // execute query
            $stmt->execute();
            // return values
            return $stmt;
        } catch (PDOException $e) {
            error_log("Caught $e");
        }
    }
    
       public function getCustCompanyDetail($user_id) {
        $query = "SELECT cc.* FROM company as cc, user_account as ua where ua.user_id=:user_id AND ua.company_id=cc.company_id";
        // prepare query statement
        $stmt = $this->conn->prepare($query);
        $stmt->bindParam("user_id", $user_id, PDO::PARAM_STR);
        // execute query
        $stmt->execute();
        // return values
        return $stmt;
    }
        /*
     * get User Company Details
     *
     * @param $user_id
     * @return $mixed
     * */

    public function UserCompanyDetails($user_id) {
        try {
            $query = $this->conn->prepare("SELECT cc.logo_path,cc.name,ua.email_id FROM user_account as ua,company as cc "
                    . "WHERE ua.user_id=:user_id AND ua.company_id=cc.company_id");
            $query->bindParam("user_id", $user_id, PDO::PARAM_STR);
            $query->execute();
            return $query;
        } catch (PDOException $e) {
            exit($e->getMessage());
        }
    }


}
