<?php

class MCrypt {

    private $iv = 'fedcba9876543210'; #Same as in JAVA
    private $key = '0123456789abcdef'; #Same as in JAVA

    const SESS_CIPHER = 'aes-128-cbc';

    /**
     * Encrypts the session ID and returns it as a base 64 encoded string.
     *
     * @param $session_id
     * @return string
     */
    public function encrypt($session_id) {
        // Get the MD5 hash salt as a key.
        $key = $this->_getSalt();
        // For an easy iv, MD5 the salt again.
        $iv = $this->_getIv();
        // Encrypt the session ID.
        $ciphertext = openssl_encrypt($session_id, self::SESS_CIPHER, $key, $options = OPENSSL_RAW_DATA, $iv);
        // Base 64 encode the encrypted session ID.
        // $encryptedSessionId = base64_encode($ciphertext);
        $encryptedSessionId = bin2hex($ciphertext);
        // Return it.
        return $encryptedSessionId;
    }

    /**
     * Decrypts a base 64 encoded encrypted session ID back to its original form.
     *
     * @param $encryptedSessionId
     * @return string
     */
    public function decrypt($encryptedSessionId) {
        // Get the Drupal hash salt as a key.
        $key = $this->_getSalt();
        // Get the iv.
        $iv = $this->_getIv();
        // Decode the encrypted session ID from base 64.
        // $decoded1 = base64_decode($encryptedSessionId, TRUE);
        $decoded = $this->hex2bin($encryptedSessionId);
        // Decrypt the string.
        $decryptedSessionId = openssl_decrypt($decoded, self::SESS_CIPHER, $key, $options = OPENSSL_RAW_DATA, $iv);
        // Trim the whitespace from the end.
        //$session_id = rtrim($decryptedSessionId, '\0');
        $session_id = rtrim($decryptedSessionId);
        // Return it.
        return $session_id;
    }

    public function _getIv() {
//    $ivlen = openssl_cipher_iv_length(self::SESS_CIPHER);
//    return substr(md5($this->_getSalt()), 0, $ivlen);
        return $this->iv;
    }

    public function _getSalt() {
        return $this->key;
    }

    protected function hex2bin($hexdata) {
        $bindata = '';
        for ($i = 0; $i < strlen($hexdata); $i += 2) {
            $bindata .= chr(hexdec(substr($hexdata, $i, 2)));
        }
        return $bindata;
    }

}
?>

