<?php
/// start session 
session_start();
include 'config/database.php';
include_once "security/session_config.php";
// connect to database
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/refmaterial.php";

// initialize objects
    $users = new ManageUsers();
    $referencematerial = new Referencematerial();


    // set page title
    $page_no = 5;
    $page_url = "references.php";
    $user_id = $_SESSION['uid'];

// for pagination purposes
    $page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
    $records_per_page = 10; // set records or rows of data per page
    $from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause
    ?>
    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("LB0104"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/referencematerial/style.css">
        </head>
        <body>
            <?php include "./menu_primary.php"; ?>

            <section class="page-header mt-0 masthead -type-2 pt-0 pb-0 justify-center">
                <div class="masthead__bg">
                    <div class="bg-image js-lazy loaded" data-ll-status="loaded"
                    <?php if ($cust_company_banner_image_path_reference == "") { ?>
                             style="background-image: url(assets/images/bg/reference.jpg)" 
                         <?php } else { ?>
                             style="background-image: url('<?php echo $cust_company_banner_image_path_reference; ?>');"
                         <?php } ?>
                         ></div>
                </div>
                <h1 class="masthead__title text-white text-center pt-60 pb-50 mt-0 mb-0">
                    <?php echo _("RM0101") ?>
                </h1>
            </section>
            <div class="container pb-90 rounded-16 mb-50">
                <?php
                $referencematerial->user_id = $_SESSION['uid'];
                $stmt = $referencematerial->getRefMaterials($from_record_num, $records_per_page);
                // count number of retrieved products
                $num = $stmt->rowCount();
                if ($num > 0) {
                    // needed for paging
                    $total_rows = $referencematerial->getRefMaterials_count();
                    echo '<ol class="c-stepper mt-10 px-0">';
                    ?>
                    <ol class="c-stepper mt-10 px-0">
                        <?php
                        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                            extract($row);
                            ?>
                            <li class="c-stepper__item">
                                <div class="c-stepper__content">
                                    <div class="px-20 py-10 border-light bg-white rounded-8 shadow-2">
                                        <h2 class="text-16 fw-500 lh-15 border-bottom-light pb-20"><?php echo htmlentities($reference_title) ?></h2>
                                        <div class="text-15 lh-15 py-10">
                                            <?php echo htmlentities($reference_desc) ?>
                                        </div>
                                        <a href="<?php echo "modules/refmaterial_download.php?path={$reference_material_id}/{$reference_filename}" ?>" class="download_rm rounded-16 bg-green-2 px-15 py-5 mt-10 mb-10">
                                            <img src="assets/images/icons/download.svg" alt="icon" class="size-20">
                                            <span class="text-13 text-blue-3"><?php echo $reference_filename ?></span>
                                        </a>
                                    </div>
                                </div>
                            </li>
                        <?php } ?>
                    </ol>
                    <?php
                    $_GET['total_rows'] = $total_rows;
                    $_GET['records_per_page'] = $records_per_page;
                    $_GET['page'] = $page;
                    $_GET['page_url'] = $page_url;
                    include('modules/paging.php');
                } else {
                    ?>
                    <div class="d-flex justify-center mt-25 py-60 text-30 fw-500">
        <?php echo _("RM0501"); ?>
                    </div>

                <?php }
                ?>
            </div>
    <?php include "./footer_primary.php" ?>
        </body>
    </html>
