<?php
include 'config/database.php';
// connect to database
include_once 'config/properties.php';
include_once "resources/assessment.php";
include_once "resources/EncryptDecrypt.php";
$assessment = new Assessment();
$assmt_path = $properties['jdbc.admin'] . $properties['jdbc.assessment_folder'];
$aid = $_GET['aid'];
$assessment->assessment_id = $aid;
$no_questions = $assessment->get_no_questions();
?>
<!DOCTYPE>
<html lang="en">
    <head>
        <?php include "./head.php" ?>
        <title>
           Quiz Preview
        </title>
        <link rel="stylesheet" href="assets/css/assessment/style.css">
    </head>
    <body>
        <!-- preloader start -->
        <div class="preloader js-preloader">
            <div class="preloader__bg" style="transform: scale(1, 0);"></div>
        </div>
        <!-- preloader end -->
<!--        <nav class="navbar navbar-default" id="navbar_top">
            <div class="container">
                <div class="navbar-header">
                    <a class="navbar-brand" href="#">
                        <img src="wp-content/assets/images/logo.png" alt="CompanyImage"/>
                    </a>
                </div>
            </div>
        </nav>-->
        <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50">
            <div class="row y-gap-30 mb-20">
                <div class="col-xl-9 col-lg-9 px-0">
                    <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                        <div class="d-flex items-center py-10 px-20 border-bottom-light">
                            <h2 class="text-17 lh-1 fw-500 mt-10 mb-5"><?php echo _("AS0132") ?> <span id="qn"></span> of <?php echo $no_questions ?></h2>
                        </div>
                        <div class="py-20 px-20">
                            <div class="ques_group">
                                <?php
                                $count = 1;
                                $stmt5 = $assessment->get_all_questions();
                                while ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                    extract($row5);
                                    ?>
                                    <div class="border-light-2 overflow-hidden rounded-8 question assmt_qs" id="<?php echo $question_id; ?>" name="<?php echo $sequence_id; ?>">
                                        <div class='countdown'>0:00:00</div>
                                        <div class="py-15 px-20 bg-light-3">
                                            <div class="d-flex justify-between">
                                                <h4 class="text-14 fw-500 text-black"><?php echo _("AS0132") ?> <span class="qn_in"><?php echo $sequence_id ?></span></h4>
                                            </div>
                                            <div class="text-18 lh-12 text-black mt-5 mb-10"><?php echo htmlentities($question_text) ?></div>
                                            <?php if ($question_image != "") { ?>
                                                <div class="relative assessment_image_div">
                                                    <a href="<?php echo "$assmt_path/$aid/$question_image" ?>" class="js-gallery"
                                                       data-gallery="gallery_qus_1">
                                                        <img class="" src="<?php echo "$assmt_path/$aid/$question_image" ?>" alt="image">
                                                        <div class="absolute-full-center d-flex justify-center items-center">
                                                        </div>
                                                    </a>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="px-20 py-20">
                                            <?php
                                            $assessment->question_id = $question_id;
                                            $number = $assessment->get_option_count();
                                            $match_val = 0;
                                            $stmt4 = $assessment->get_options();
                                            if ($question_type_id == "1") {
                                                echo "<div class='mb-20'>";
                                                echo _("AS0113");
                                                echo "</div>";
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    ?>
                                                    <div class="form-radio d-flex items-center mt-10 border-top-light">
                                                        <div class="radio">
                                                            <input type="radio" id="radio<?php echo $count1 ?>" name="<?php echo $question_id ?>" class="<?php echo $option_id ?>" value="<?php echo htmlentities($option_desc) ?>">
                                                            <div class="radio__mark">
                                                                <div class="radio__icon"></div>
                                                            </div>
                                                        </div>
                                                        <div class="text-16 fw-500 ml-12">
                                                            <?php
                                                            echo htmlentities($option_desc);
                                                            if ($option_image != "") {
                                                                ?>
                                                                <div class="relative assessment_image_div_option mt-5">
                                                                    <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                       class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                        <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                             alt="image">
                                                                        <div
                                                                            class="absolute-full-center d-flex justify-center items-center">
                                                                        </div>
                                                                    </a>
                                                                </div>
                                                            <?php } ?>
                                                        </div>

                                                    </div>
                                                    <?php
                                                }
                                            } else if ($question_type_id == "2") {
                                                echo "<div class='mb-20'>";
                                                echo _("AS0114");
                                                echo "</div>";
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    ?>

                                                    <div class="form-checkbox d-flex items-center mt-5  border-top-light">
                                                        <div class="checkbox">
                                                            <input type="checkbox" id="checkbox<?php echo $count1 ?>" name="<?php echo $question_id ?>" class="<?php echo $option_id ?>" value="<?php echo htmlentities($option_desc) ?>" >
                                                            <div class="form-checkbox__mark">
                                                                <div class="form-checkbox__icon icon-check"></div>
                                                            </div>
                                                        </div>
                                                        <div class="text-16 fw-500 ml-12">
                                                            <?php
                                                            echo htmlentities($option_desc);
                                                            if ($option_image != "") {
                                                                ?>
                                                                <div class="relative assessment_image_div_option mt-5">
                                                                    <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                       class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                        <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                             alt="image">
                                                                        <div
                                                                            class="absolute-full-center d-flex justify-center items-center">
                                                                        </div>
                                                                    </a>
                                                                </div>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }
                                            } else if ($question_type_id == "3") {
                                                ?>
                                                <div class="px-20 py-20">
                                                    <div class="table-responsive mt-20">
                                                        <table class="table_mf_ques w-1/1">
                                                            <colgroup>
                                                                <col style="width:40%">
                                                                <col style="width:40%">
                                                            </colgroup>
                                                            <thead>
                                                                <tr>
                                                                    <th>Section A</th>
                                                                    <th>Section B</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row4);
                                                                    $match_val1 = $match_val++;
                                                                    if ($number > $match_val1) {
                                                                        ?>
                                                                        <tr class="bg-white shadow-1 rounded-8 border-light">
                                                                            <td>
                                                                                <?php
                                                                                echo htmlentities($option_desc);
                                                                                if ($option_image != "") {
                                                                                    ?>
                                                                                    <div class="relative assessment_image_div_option">
                                                                                        <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                           class="js-gallery" data-gallery="gallery_opt_5_3">
                                                                                            <img class=""
                                                                                                 src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                                 alt="image"/>
                                                                                            <div
                                                                                                class="absolute-full-center d-flex justify-center items-center">
                                                                                            </div>
                                                                                        </a>
                                                                                    </div>
                                                                                <?php } ?>
                                                                            </td>
                                                                            <?php $stmt6 = $assessment->get_MF_options(); ?>
                                                                            <td>
                                                                                <select class="form-control text-16" name="option_MF<?php echo $match_val1; ?>-<?php echo $question_id; ?>" id="<?php echo $question_id; ?>">
                                                                                    <option value="">--Select Option--</option>
                                                                                    <?php
                                                                                    while ($row6 = $stmt6->fetch(PDO::FETCH_ASSOC)) {
                                                                                        extract($row6);
                                                                                        ?>
                                                                                        <option  value="<?php echo $option_id ?>"><?php echo htmlentities($option_desc); ?></option>
                                                                                    <?php } ?>
                                                                                </select>
                                                                            </td>
                                                                        </tr>
                                                                        <?php
                                                                    }
                                                                }
                                                                ?>
                                                            </tbody>
                                                        </table>
                                                    </div>
                                                </div>
                                                <?php
                                            } else if ($question_type_id == "4" || $question_type_id == "5") {
                                                $serial_no = 1;
                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row4);
                                                    $count1 = $count++;
                                                    ?>

                                                    <div class="px-20 py-20">
                                                        <form class="contact-form">
                                                            <div class="d-flex items-center">
                                                                <div class="col-lg-10 pl-0 y-gap-10">
                                                                    <div class="d-flex justify-start items-center">
                                                                        <div><?php echo $serial_no++ ?></div>
                                                                        <input id="text<?php echo $count1 ?>" type="text" placeholder="Text..." class="text-16 ml-10"
                                                                               autocomplete='off' name="FIB_<?php echo $question_id ?>" autocomplete='off'>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </form>
                                                    </div>
                                                    <?php
                                                }
                                            } else if ($question_type_id == "6" || $question_type_id == '7') {
                                                ?>
                                                <div class="px-20 py-20">
                                                    <form class="contact-form">
                                                        <div class="d-flex items-center">
                                                            <div class="col-lg-10 pl-0">
                                                                <textarea placeholder="Text..." class="text-16" rows='4' cols='80'
                                                                          autocomplete='off' name="SQ_<?php echo $question_id ?>"></textarea>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            <?php } ?>
                                        </div>
                                    </div>
                                    <?php
                                }
                                ?>
                            </div>
                            <div class="d-flex justify-start items-center mt-40 assmt_nav_button">
                                <button class="button -icon h-40 text-white disabled-btn" id="prev" disabled>
                                    <i class="fa fa-angle-double-left text-13 mr-5"></i>
                                    <?php echo _("AS0116") ?>
                                </button>
                                <button class="button -icon bg-color-primary h-40 text-white ml-10"
                                        id="next">
                                            <?php echo _("AS0118") ?>
                                    <i class="fa fa-angle-double-right text-13 ml-5"></i>
                                </button>
                                <button class="button -icon bg-orange-6 h-40 text-white ml-10"
                                        id="mark_as_review">
                                    <i class="fa fa-check text-13 mr-5"></i>
                                    <?php echo _("AS0119") ?>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-lg-3 pr-0 assmt_right">
                    <div class="row y-gap-30">


                        <div class="col-12 pt-0">
                            <div class="py-20 px-25 rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                <h5 class="text-17 fw-500 mb-10"><?php echo _("AS0163") ?></h5>

                                <div class="row x-gap-10 y-gap-10 number_question_display pl-8 text-white" id="pallette">
                                </div>
                            </div>
                        </div>

                        <div class="col-12 pt-0">
                            <div class="py-20 px-25 rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                <div class="d-flex items-center">
                                    <div class="size-12 bg-light-20 rounded-full"></div>
                                    <div class="fw-500 ml-12"> <?php echo _("AS0123") ?></div>
                                </div>
                                <div class="d-flex items-center mt-5">
                                    <div class="size-12 bg-green-5 rounded-full"></div>
                                    <div class="fw-500 ml-12"><?php echo _("AS0124") ?></div>
                                </div>
                                <div class="d-flex items-center mt-5">
                                    <div class="size-12 bg-red-1 rounded-full"></div>
                                    <div class="fw-500 ml-12"><?php echo _("AS0160") ?></div>
                                </div>
                                <div class="d-flex items-center mt-5">
                                    <div class="size-12 bg-orange-6 rounded-full"></div>
                                    <div class="fw-500 ml-12"><?php echo _("AS0161") ?></div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>

        <script src="assets/js/jquery-3.6.3.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/vendors.js"></script>
        <script src="assets/js/main.js"></script>
        <script>
            var value = $("input[type=radio]:checked").val();
            $('input[type=radio]').click(function () {
                if ($(this).val() === value) {
                    $(this).prop('checked', false);
                    value = "";
                } else {
                    value = $(this).val();
                }
                showStatus("");
            });
            var value = $("input[type=checkbox]:checked").val();
            $('input[type=checkbox]').click(function () {
                if ($(this).val() === value) {
                    $(this).prop('checked', false);
                    value = "";
                } else {
                    value = $(this).val();
                }
                showStatus("");
            });
            $('select').on('change', function (e) {
                showStatus("");
            });

            $(document).ready(function () {
                $('.ques_group div:first').css("display", "block");
                $('.ques_group div:first').addClass('current');
                Qn();
            });

            $("#next").click(function () {
                showStatus("");
                if ($(".current").next().length == 1) {
                    $(".current").removeClass("current").hide().next().addClass("current").show();

                }
                if ($(".current").next().length != 1) {
                    $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#next").attr('disabled', 'disabled');
                }
                $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                $("#prev").removeAttr("disabled");
                Qn();
            });
            $("#prev").click(function () {
                showStatus("");
                if ($(".current").prev().length == 1) {
                    $(".current").removeClass("current").hide().prev().addClass("current").show();

                }
                if ($(".current").prev().length != 1) {
                    $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#prev").attr('disabled', 'disabled');
                }
                $("#next").addClass("bg-color-primary").removeClass("disabled-btn");
                $("#next").removeAttr("disabled");
                Qn();
            });

            $("#mark_as_review").click(function () {
                showStatus("mark");
                if ($(".current").next().length == 1) {
                    $(".current").removeClass("current").hide().next().addClass("current").show();
                }
                if ($(".current").next().length != 1) {
                    $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#next").attr('disabled', 'disabled');
                }
                $("#prev").addClass("bg-color-primary").removeClass("disabled-btn");
                $("#prev").removeAttr("disabled");
                Qn();
            });
            window.onload = function () {
                //question_pallet
                $('#pallette').html('');
                $('.assmt_qs').each(function () {
                    // $('#pallette').append("<li id=" + $(this).attr('name') + "><a class='unvisited' style='margin-top:2px;cursor: pointer;' onclick='showQuestion(" + $(this).attr('id') + ")'><i>" + $(this).attr('name') + "</i></a></li>");
                    $('#pallette').append('<div class="col-auto" id="' + $(this).attr('name') + '"><a  class="button -single-icon -light-20 size-35 rounded-8" onclick="showQuestion(' + $(this).attr('id') + ')"><div class="text-15 lh-1 fw-500">' + $(this).attr('name') + '</div></a></div>');
                });
            }
            function showStatus(mark) {
                $('.ques_group>.current').each(function () {
                    //remove unvisited class
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-light-20');
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-red-1');
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-green-5');
                    if (mark == "") {
                        if ($('input[name="' + $(this).attr('id') + '"]').length > 0) {
                            if ($("input[name=" + $(this).attr('id') + "]:checked").length > 0) {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else if ($('input[name="FIB_' + $(this).attr('id') + '"]').length > 0) {
                            if ($('input[name="FIB_' + $(this).attr('id') + '"]').val() != "") {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').length > 0) {
                            if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').val() != "") {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else {
                            var flag = true;
                            $('select[id="' + $(this).attr('id') + '"]').each(function () {
                                if ($(this).val() == '') {
                                    flag = false;
                                    return;
                                }
                            });
                            if (flag) {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        }
                    } else {
                        $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-orange-6');
                    }
                });
            }

            function showQuestion(q_id) {
                showStatus("");
                $(".current").removeClass("current").hide();
                $("#" + q_id + "").addClass("current").show();
                if ($(".current").next().length != 1) {
                    $("#next").attr("disabled", true);
                } else {
                    $("#next").attr("disabled", false);
                }
                if ($(".current").prev().length != 1) {
                    $("#prev").attr("disabled", true);
                } else {
                    $("#prev").attr("disabled", false);
                }
                Qn();
            }

            function Qn() {
                var current_question_no = $('.current').find('.qn_in').text();
                $('#qn').text(current_question_no);
            }
        </script>
    </body>
</html>

