<?php
// start session 
session_start();
include 'config/database.php';
include_once 'security/session_config.php';
include_once 'security/csrf.php';
// connect to database

include_once 'config/properties.php';
include_once "resources/assessment.php";
include_once "resources/manageusers.php";
include_once "resources/EncryptDecrypt.php";
$csrf_token = $_POST['csrf_token'];
//validate_csrf_request($csrf_token,);


//$csrf_token = $_POST['csrf_token'] ?? '';
$session_token = $_SESSION['csrf_token'] ?? '';
$token_time = $_SESSION['csrf_token_time'] ?? 0;

$is_valid = ($csrf_token === $session_token) && (time() - $token_time <= CSRF_EXPIRY_SECONDS);
$csrf_token = get_csrf_token();
$assessment = new Assessment();
$users = new ManageUsers();

if (!isset($_POST['oid'])) {
    header('Location: 404.php');
}
if (!isset($_POST['aid'])) {
    header('Location: 404.php');
}


$assmt_path = $properties['jdbc.admin'] . $properties['jdbc.assessment_folder'];
$id = $_SESSION['uid'];
$oid = $_POST['oid'];
$aid = $_POST['aid'];
$duratn = null;
$no_questions = 0;
$current_attempt = 0;
$rt = "Fail";
$sr = "0";
$tsr = "0";

$assessment->offering_id = $oid;
$assessment->assessment_id = $aid;
$assessment->user_id = $id;
$stmt = $assessment->get_assessment_detail();
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    extract($row);
    $subjective_assessment = $row['subjective_assessment'];
    $duratn = $row['assmt_duration'];
    $no_questions = $assessment->get_no_questions();
    $check_attempt = $assessment->get_attempt_no();
    if ($check_attempt == NULL) {
        $current_attempt = $current_attempt + 1;
    } else {
        $current_attempt = $check_attempt + 1;
    }
}
?>
<!DOCTYPE>
<html lang="en">

<head>
    <meta name="csrf-token" content="<?= htmlspecialchars($csrf_token) ?>">
    <?php include "./head.php" ?>
    <title>
        <?php _("TB103") ?>
    </title>
    <?php include "./menu_secondary.php" ?>
    <link rel="stylesheet" href="assets/css/assessment/style.css">
</head>

<body>
        <input type="hidden" id="assmt_d" value="<?php echo $duratn; ?>" />
        <input type="hidden" id="assmt_id" value="<?php echo $aid ?>" />
        <input type="hidden" id="off_id" value="<?php echo $oid ?>" />
        <input type="hidden" id="screen_count" value="">

        <?php
        $assessment->assessment_id = $aid;
        $assessment->offering_id = $oid;
        $stmt1 = $assessment->assessment_details_fetch();
        if ($stmt1->rowCount() > 0) {
            if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                extract($row1);
                $passing_score = $row1['passing_score'];
                $weightage = "100";
                if ($row1['weightage'] != "") {
                    $weightage = $row1['weightage'];
                }
            }
        }

        $assessment->passing_score = $passing_score;
        $assessment->weightage = $weightage;
        $assessment->total_score = $tsr;
        $assessment->score = $sr;
        $assessment->attempt_no = $current_attempt;
        $assessment->last_updated_ts = $date_time;

        if ($assessment->quiz_score_initial_insert()) {
            require 'cal_result.php';
            ?>
            <div class="container py-10 x-gap-40 bg-light-9 rounded-8 mb-50">
                <div class="row y-gap-30 mb-20">

                    <div class="col-xl-9 col-lg-9 px-0">
                        <div class="rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                            <div class="d-flex items-center py-10 px-20 border-bottom-light">
                                <h2 class="text-17 lh-1 fw-500 mt-10 mb-5"><?php echo _("AS0132") ?> <span id="qn"></span> of
                                    <span id="total_qn"><?php echo $no_questions ?></span>
                                </h2>
                            </div>
                            <input type="hidden" id="attm" value="<?php echo $current_attempt; ?>" />
                            <div class="py-20 px-20">
                                <div class="ques_group">
                                    <?php
                                    $count = 1;
                                    $Qs = array();
                                    $stmt1 = $assessment->check_assessment_criteria();
                                    if ($stmt1->rowCount() > 0) {
                                        while ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row1);
                                            $tmp_qs = array();
                                            $randQs = array();
                                            $assessment->complexity_type_id = $complexity_type_id;
                                            $stmt2 = $assessment->get_questions_rand();
                                            while ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row2);
                                                array_push($tmp_qs, $question_id);
                                            }
                                            $randQs = array_rand($tmp_qs, $question_count);
                                            // if (sizeof($randQs) > 1) {
                                            if (is_array($randQs) && sizeof($randQs) > 1) {
                                                foreach ($randQs as $key) {
                                                    array_push($Qs, $tmp_qs[$key]);
                                                }
                                            } else {
                                                array_push($Qs, $tmp_qs[0]);
                                            }
                                        }
                                        shuffle($Qs);
                                        $m = 0;
                                        foreach ($Qs as $Q) {
                                            $assessment->question_id = $Q;
                                            $stmt3 = $assessment->get_question();
                                            if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                                extract($row3);
                                                $m = $m + 1;
                                                ?>
                                                <div class="border-light-2 overflow-hidden rounded-8 question assmt_qs"
                                                    id="<?php echo $question_id; ?>" name="<?php echo $m; ?>">
                                                    <div class='countdown'>0:00:00</div>
                                                    <input type="hidden" id="total_qn_cr" value="<?php echo sizeof($Qs) ?>" />
                                                    <div class="py-15 px-20 bg-light-3">
                                                        <div class="d-flex justify-between">
                                                            <h4 class="text-14 fw-500 text-black"><?php echo _("AS0132") ?> <span
                                                                    class="qn_in"><?php echo $m ?></span></h4>
                                                        </div>
                                                        <pre
                                                            class="text-18 lh-12 text-black mt-5 mb-10"><?php echo htmlentities($question_text) ?></pre>
                                                        <?php if ($question_image != "") { ?>
                                                            <div class="relative assessment_image_div">
                                                                <a href="<?php echo "$assmt_path/$aid/$question_image" ?>" class="js-gallery"
                                                                    data-gallery="gallery_qus_1">
                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$question_image" ?>"
                                                                        alt="image">
                                                                    <div class="absolute-full-center d-flex justify-center items-center">
                                                                    </div>
                                                                </a>
                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                    <div class="px-20 py-20">
                                                        <?php
                                                        $assessment->question_id = $question_id;
                                                        $number = $assessment->get_option_count();
                                                        $match_val = 0;
                                                        $stmt4 = $assessment->get_options();
                                                        if ($question_type_id == "1") {
                                                            echo "<div class='mb-20'>";
                                                            echo _("AS0113");
                                                            echo "</div>";
                                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row4);
                                                                $count1 = $count++;
                                                                $value_radio = "";
                                                                if ($option_desc != "") {
                                                                    $value_radio = htmlentities($option_desc);
                                                                } else {
                                                                    $value_radio = htmlentities($option_image);
                                                                }
                                                                ?>
                                                                <div class="form-radio d-flex items-center mt-10">
                                                                    <div class="radio">
                                                                        <input type="radio" id="radio<?php echo $count1 ?>"
                                                                            name="<?php echo $question_id ?>" class="<?php echo $option_id ?>"
                                                                            value="<?php echo $value_radio; ?>">
                                                                        <div class="radio__mark">
                                                                            <div class="radio__icon"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="text-16 fw-500 ml-12">
                                                                        <pre class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                        <?php
                                                                        if ($option_image != "") {
                                                                            ?>
                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                    class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                        alt="image">
                                                                                    <div
                                                                                        class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>
                                                                        <?php } ?>
                                                                    </div>

                                                                </div>
                                                                <?php
                                                            }
                                                        } else if ($question_type_id == "2") {
                                                            echo "<div class='mb-20'>";
                                                            echo _("AS0114");
                                                            echo "</div>";
                                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row4);
                                                                $count1 = $count++;
                                                                $value_checkbox = "";
                                                                if ($option_desc != "") {
                                                                    $value_checkbox = htmlentities($option_desc);
                                                                } else {
                                                                    $value_checkbox = htmlentities($option_image);
                                                                }
                                                                ?>

                                                                    <div class="form-checkbox d-flex items-center mt-5">
                                                                        <div class="checkbox">
                                                                            <input type="checkbox" id="checkbox<?php echo $count1 ?>"
                                                                                name="<?php echo $question_id ?>" class="<?php echo $option_id ?>"
                                                                                value="<?php echo $value_checkbox; ?>">
                                                                            <div class="form-checkbox__mark">
                                                                                <div class="form-checkbox__icon icon-check"></div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="text-16 fw-500 ml-12">
                                                                            <pre class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                            <?php
                                                                            if ($option_image != "") {
                                                                                ?>
                                                                                <div class="relative assessment_image_div_option mt-5">
                                                                                    <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                        class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                                        <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                            alt="image">
                                                                                        <div
                                                                                            class="absolute-full-center d-flex justify-center items-center">
                                                                                        </div>
                                                                                    </a>
                                                                                </div>
                                                                        <?php } ?>
                                                                        </div>
                                                                    </div>
                                                                <?php
                                                            }
                                                        } else if ($question_type_id == "3") {
                                                            ?>
                                                                    <div class="px-20 py-20">
                                                                        <div class="table-responsive mt-20">
                                                                            <table class="table_mf_ques w-1/1">
                                                                                <colgroup>
                                                                                    <col style="width:40%">
                                                                                    <col style="width:40%">
                                                                                </colgroup>
                                                                                <thead>
                                                                                    <tr>
                                                                                        <th>Section A</th>
                                                                                        <th>Section B</th>
                                                                                    </tr>
                                                                                </thead>
                                                                                <tbody>
                                                                                <?php
                                                                                while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                                    extract($row4);
                                                                                    $match_val1 = $match_val++;
                                                                                    if ($number > $match_val1) {
                                                                                        ?>
                                                                                            <tr class="bg-white shadow-1 rounded-8 border-light">
                                                                                                <td>
                                                                                                    <pre
                                                                                                        class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                                                <?php
                                                                                                if ($option_image != "") {
                                                                                                    ?>
                                                                                                        <div class="relative assessment_image_div_option">
                                                                                                            <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                                                class="js-gallery" data-gallery="gallery_opt_5_3">
                                                                                                                <img class=""
                                                                                                                    src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                                                    alt="image" />
                                                                                                                <div
                                                                                                                    class="absolute-full-center d-flex justify-center items-center">
                                                                                                                </div>
                                                                                                            </a>
                                                                                                        </div>
                                                                                            <?php } ?>

                                                                                                </td>
                                                                                        <?php $stmt6 = $assessment->get_MF_options(); ?>
                                                                                                <td>
                                                                                                    <select class="form-control text-16"
                                                                                                        name="option_MF<?php echo $match_val1; ?>-<?php echo $question_id; ?>"
                                                                                                        id="<?php echo $question_id; ?>">
                                                                                                        <option value="">--Select Option--</option>
                                                                                                    <?php
                                                                                                    while ($row6 = $stmt6->fetch(PDO::FETCH_ASSOC)) {
                                                                                                        extract($row6);
                                                                                                        ?>
                                                                                                            <option value="<?php echo $option_id ?>">
                                                                                                        <?php echo htmlentities($option_desc); ?>
                                                                                                            </option>
                                                                                                <?php } ?>
                                                                                                    </select>
                                                                                                </td>
                                                                                            </tr>
                                                                                    <?php
                                                                                    }
                                                                                }
                                                                                ?>
                                                                                </tbody>
                                                                            </table>
                                                                        </div>
                                                                    </div>
                                                            <?php
                                                        } else if ($question_type_id == "4" || $question_type_id == "5") {
                                                            $serial_no = 1;
                                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row4);
                                                                $count1 = $count++;
                                                                ?>

                                                                            <div class="px-20 py-20">
                                                                                <form class="contact-form">
                                                                                    <div class="d-flex items-center">
                                                                                        <div class="col-lg-10 pl-0 y-gap-10">
                                                                                            <div class="d-flex justify-start items-center">
                                                                                                <div><?php echo $serial_no++ ?></div>
                                                                                                <input id="text<?php echo $count1 ?>" type="text"
                                                                                                    placeholder="Text..." class="text-16 ml-10"
                                                                                                    autocomplete='off' name="FIB_<?php echo $question_id ?>"
                                                                                                    autocomplete='off'>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </form>
                                                                            </div>

                                                                <?php
                                                            }
                                                        } else if ($question_type_id == "6" || $question_type_id == '7') {
                                                            ?>
                                                                            <div class="px-20 py-20">
                                                                                <form class="contact-form">
                                                                                    <div class="d-flex items-center">
                                                                                        <div class="col-lg-10 pl-0">
                                                                                            <textarea placeholder="Text..." class="text-16" rows='4' cols='80'
                                                                                                autocomplete='off'
                                                                                                name="SQ_<?php echo $question_id ?>"></textarea>
                                                                                        </div>
                                                                                    </div>
                                                                                </form>
                                                                            </div>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                                <?php
                                            }
                                        }
                                    } else {
                                        ?>
                                        <?php
                                        $stmt5 = $assessment->get_all_questions();
                                        while ($row5 = $stmt5->fetch(PDO::FETCH_ASSOC)) {
                                            extract($row5);
                                            ?>
                                            <div class="border-light-2 overflow-hidden rounded-8 question assmt_qs"
                                                id="<?php echo $question_id; ?>" name="<?php echo $sequence_id; ?>">
                                                <div class='countdown'>0:00:00</div>
                                                <div class="py-15 px-20 bg-light-3">
                                                    <div class="d-flex justify-between">
                                                        <h4 class="text-14 fw-500 text-black"><?php echo _("AS0132") ?> <span
                                                                class="qn_in"><?php echo $sequence_id ?></span></h4>
                                                    </div>
                                                    <pre
                                                        class="text-18 lh-12 text-black mt-5 mb-10"><?php echo htmlentities($question_text) ?></pre>
                                                    <?php if ($question_image != "") { ?>
                                                        <div class="relative assessment_image_div">
                                                            <a href="<?php echo "$assmt_path/$aid/$question_image" ?>" class="js-gallery"
                                                                data-gallery="gallery_qus_1">
                                                                <img class="" src="<?php echo "$assmt_path/$aid/$question_image" ?>"
                                                                    alt="image">
                                                                <div class="absolute-full-center d-flex justify-center items-center">
                                                                </div>
                                                            </a>
                                                        </div>
                                                    <?php } ?>
                                                </div>
                                                <div class="px-20 py-20">
                                                    <?php
                                                    $assessment->question_id = $question_id;
                                                    $number = $assessment->get_option_count();
                                                    $match_val = 0;
                                                    $stmt4 = $assessment->get_options();
                                                    if ($question_type_id == "1") {
                                                        echo "<div class='mb-20'>";
                                                        echo _("AS0113");
                                                        echo "</div>";
                                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row4);
                                                            $count1 = $count++;
                                                            $value_radio = "";
                                                            if ($option_desc != "") {
                                                                $value_radio = htmlentities($option_desc);
                                                            } else {
                                                                $value_radio = htmlentities($option_image);
                                                            }
                                                            ?>
                                                            <div class="form-radio d-flex items-center mt-10">
                                                                <div class="radio">
                                                                    <input type="radio" id="radio<?php echo $count1 ?>"
                                                                        name="<?php echo $question_id ?>" class="<?php echo $option_id ?>"
                                                                        value="<?php echo $value_radio; ?>">
                                                                    <div class="radio__mark">
                                                                        <div class="radio__icon"></div>
                                                                    </div>
                                                                </div>
                                                                <div class="text-16 fw-500 ml-12">
                                                                    <pre class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                    <?php
                                                                    if ($option_image != "") {
                                                                        ?>
                                                                        <div class="relative assessment_image_div_option mt-5">
                                                                            <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                                <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                    alt="image">
                                                                                <div
                                                                                    class="absolute-full-center d-flex justify-center items-center">
                                                                                </div>
                                                                            </a>
                                                                        </div>
                                                                    <?php } ?>
                                                                </div>

                                                            </div>
                                                            <?php
                                                        }
                                                    } else if ($question_type_id == "2") {
                                                        echo "<div class='mb-20'>";
                                                        echo _("AS0114");
                                                        echo "</div>";
                                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row4);
                                                            $count1 = $count++;
                                                            $value_checkbox = "";
                                                            if ($option_desc != "") {
                                                                $value_checkbox = htmlentities($option_desc);
                                                            } else {
                                                                $value_checkbox = htmlentities($option_image);
                                                            }
                                                            ?>

                                                                <div class="form-checkbox d-flex items-center mt-5">
                                                                    <div class="checkbox">
                                                                        <input type="checkbox" id="checkbox<?php echo $count1 ?>"
                                                                            name="<?php echo $question_id ?>" class="<?php echo $option_id ?>"
                                                                            value="<?php echo $value_checkbox; ?>">
                                                                        <div class="form-checkbox__mark">
                                                                            <div class="form-checkbox__icon icon-check"></div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="text-16 fw-500 ml-12">
                                                                        <pre class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                        <?php
                                                                        if ($option_image != "") {
                                                                            ?>
                                                                            <div class="relative assessment_image_div_option mt-5">
                                                                                <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                    class="w-1/1 js-gallery" data-gallery="gallery_opt_2_4">
                                                                                    <img class="" src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                        alt="image">
                                                                                    <div
                                                                                        class="absolute-full-center d-flex justify-center items-center">
                                                                                    </div>
                                                                                </a>
                                                                            </div>
                                                                    <?php } ?>
                                                                    </div>
                                                                </div>
                                                            <?php
                                                        }
                                                    } else if ($question_type_id == "3") {
                                                        ?>
                                                                <div class="px-20 py-20">
                                                                    <div class="table-responsive mt-20">
                                                                        <table class="table_mf_ques w-1/1">
                                                                            <colgroup>
                                                                                <col style="width:40%">
                                                                                <col style="width:40%">
                                                                            </colgroup>
                                                                            <thead>
                                                                                <tr>
                                                                                    <th>Section A</th>
                                                                                    <th>Section B</th>
                                                                                </tr>
                                                                            </thead>
                                                                            <tbody>
                                                                            <?php
                                                                            while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                                                extract($row4);
                                                                                $match_val1 = $match_val++;
                                                                                if ($number > $match_val1) {
                                                                                    ?>
                                                                                        <tr class="bg-white shadow-1 rounded-8 border-light">
                                                                                            <td>
                                                                                                <pre
                                                                                                    class="text-16 fw-500"><?php echo htmlentities($option_desc); ?></pre>
                                                                                            <?php
                                                                                            if ($option_image != "") {
                                                                                                ?>
                                                                                                    <div class="relative assessment_image_div_option">
                                                                                                        <a href="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                                            class="js-gallery" data-gallery="gallery_opt_5_3">
                                                                                                            <img class=""
                                                                                                                src="<?php echo "$assmt_path/$aid/$option_image" ?>"
                                                                                                                alt="image" />
                                                                                                            <div
                                                                                                                class="absolute-full-center d-flex justify-center items-center">
                                                                                                            </div>
                                                                                                        </a>
                                                                                                    </div>
                                                                                        <?php } ?>
                                                                                            </td>
                                                                                    <?php $stmt6 = $assessment->get_MF_options(); ?>
                                                                                            <td>
                                                                                                <select class="form-control text-16"
                                                                                                    name="option_MF<?php echo $match_val1; ?>-<?php echo $question_id; ?>"
                                                                                                    id="<?php echo $question_id; ?>">
                                                                                                    <option value="">--Select Option--</option>
                                                                                                <?php
                                                                                                while ($row6 = $stmt6->fetch(PDO::FETCH_ASSOC)) {
                                                                                                    extract($row6);
                                                                                                    ?>
                                                                                                        <option value="<?php echo $option_id ?>">
                                                                                                    <?php echo htmlentities($option_desc); ?>
                                                                                                        </option>
                                                                                            <?php } ?>
                                                                                                </select>
                                                                                            </td>
                                                                                        </tr>
                                                                                <?php
                                                                                }
                                                                            }
                                                                            ?>
                                                                            </tbody>
                                                                        </table>
                                                                    </div>
                                                                </div>
                                                        <?php
                                                    } else if ($question_type_id == "4" || $question_type_id == "5") {
                                                        $serial_no = 1;
                                                        while ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row4);
                                                            $count1 = $count++;
                                                            ?>

                                                                        <div class="px-20 py-20">
                                                                            <form class="contact-form">
                                                                                <div class="d-flex items-center">
                                                                                    <div class="col-lg-10 pl-0 y-gap-10">
                                                                                        <div class="d-flex justify-start items-center">
                                                                                            <div><?php echo $serial_no++ ?></div>
                                                                                            <input id="text<?php echo $count1 ?>" type="text"
                                                                                                placeholder="Text..." class="text-16 ml-10"
                                                                                                autocomplete='off' name="FIB_<?php echo $question_id ?>"
                                                                                                autocomplete='off'>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                            <?php
                                                        }
                                                    } else if ($question_type_id == "6" || $question_type_id == '7') {
                                                        ?>
                                                                        <div class="px-20 py-20">
                                                                            <form class="contact-form">
                                                                                <div class="d-flex items-center">
                                                                                    <div class="col-lg-10 pl-0">
                                                                                        <textarea placeholder="Text..." class="text-16" rows='4' cols='80'
                                                                                            autocomplete='off'
                                                                                            name="SQ_<?php echo $question_id ?>"></textarea>
                                                                                    </div>
                                                                                </div>
                                                                            </form>
                                                                        </div>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="d-flex justify-start items-center mt-40 assmt_nav_button">
                                    <button class="button -icon h-40 text-white disabled-btn" id="prev" disabled>
                                        <i class="fa fa-angle-double-left text-13 mr-5"></i>
                                        <?php echo _("AS0116") ?>
                                    </button>
                                    <button class="button -icon bg-color-primary h-40 text-white ml-10" id="next">
                                        <?php echo _("AS0118") ?>
                                        <i class="fa fa-angle-double-right text-13 ml-5"></i>
                                    </button>
                                    <button class="button -icon bg-orange-6 h-40 text-white ml-10" id="mark_as_review">
                                        <i class="fa fa-check text-13 mr-5"></i>
                                        <?php echo _("AS0119") ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-3 col-lg-3 pr-0 assmt_right">
                        <div class="row y-gap-30">
                            <?php if ($duratn != "0") { ?>
                                <div class="col-12 pt-0">
                                    <div class="py-20 px-25 rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                        <h5 class="text-17 fw-500 mb-10"><?php echo _("AS0162") ?></h5>
                                        <div>
                                            <div id='app' class="mb-10"></div>
                                            <div id='showtime'></div>
                                        </div>
                                    </div>
                                </div>
                            <?php } ?>

                            <div class="col-12 pt-0">
                                <div class="py-20 px-25 rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                    <h5 class="text-17 fw-500 mb-10"><?php echo _("AS0163") ?></h5>

                                    <div class="row x-gap-10 y-gap-10 number_question_display pl-8 text-white" id="pallette">
                                    </div>
                                    <div class="d-flex justify-center items-center">
                                        <button class="button -md -green-8 text-white mt-30"
                                            id="submit"><?php echo _("AS0133") ?></button>
                                    </div>

                                    <!-- Modal -->
                                    <div class="modal fade" id="assessment_submit_modal" tabindex="-1" role="dialog">
                                        <div class="modal-dialog modal-lg" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <div class="d-flex justify-between items-center">
                                                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("AS0125"); ?>
                                                        </h2>
                                                        <button type="button" class="close" id="close_span" data-dismiss="modal"
                                                            aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                </div>
                                                <div class="modal-body  bg-primary-opacity-1">
                                                    <h2 class="text-16 lh-12"><?php echo _("AS0301") ?></h2>
                                                    <ul class="text-14 lh-12" id="assessment_modal_ul">
                                                        <li id="ans"></li>
                                                        <li id="unans"></li>
                                                        <li id="total"></li>
                                                    </ul>
                                                </div>
                                                <div class="modal-footer">
                                                    <div class="d-flex justify-center">
                                                        <button
                                                            class="text-16 button -icon px-50 py-0 bg-color-primary text-white"
                                                            onclick="proceed_assessment_submit();">
                                                            <?php echo _("AS0127"); ?>
                                                        </button>
                                                        &nbsp;
                                                        <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                                                            data-dismiss="modal"><?php echo _("AS0126"); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>

                            <div class="col-12 pt-0">
                                <div class="py-20 px-25 rounded-8 bg-white -dark-bg-dark-1 shadow-4">
                                    <div class="d-flex items-center">
                                        <div class="size-12 bg-light-20 rounded-full"></div>
                                        <div class="fw-500 ml-12"> <?php echo _("AS0123") ?></div>
                                    </div>
                                    <div class="d-flex items-center mt-5">
                                        <div class="size-12 bg-green-5 rounded-full"></div>
                                        <div class="fw-500 ml-12"><?php echo _("AS0124") ?></div>
                                    </div>
                                    <div class="d-flex items-center mt-5">
                                        <div class="size-12 bg-red-1 rounded-full"></div>
                                        <div class="fw-500 ml-12"><?php echo _("AS0160") ?></div>
                                    </div>
                                    <div class="d-flex items-center mt-5">
                                        <div class="size-12 bg-orange-6 rounded-full"></div>
                                        <div class="fw-500 ml-12"><?php echo _("AS0161") ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        <?php } ?>
        <?php include "./footer_secondary.php" ?>
        <script>
            // Credit: Mateusz Rybczonec
            <?php if ($duratn != "0") { ?>
                const FULL_DASH_ARRAY = 283;
                const WARNING_THRESHOLD = 10;
                const ALERT_THRESHOLD = 5;

                const COLOR_CODES = {
                    info: {
                        color: "green"
                    },
                    warning: {
                        color: "orange",
                        threshold: WARNING_THRESHOLD
                    },
                    alert: {
                        color: "red",
                        threshold: ALERT_THRESHOLD
                    }
                };
                assmt_d = $('#assmt_d').val();
                min = (assmt_d * 60) - 1;
                const TIME_LIMIT = min;
                let timePassed = 0;
                let timeLeft = TIME_LIMIT;
                let timerInterval = null;
                let remainingPathColor = COLOR_CODES.info.color;

                document.getElementById("app").innerHTML = `
                                                    <div class="base-timer">
                                                    <svg class="base-timer__svg" viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
                                                    <g class="base-timer__circle">
                                                      <circle class="base-timer__path-elapsed" cx="50" cy="50" r="45"></circle>
                                                      <path
                                                        id="base-timer-path-remaining"
                                                        stroke-dasharray="283"
                                                        class="base-timer__path-remaining ${remainingPathColor}"
                                                        d="
                                                          M 50, 50
                                                          m -45, 0
                                                          a 45,45 0 1,0 90,0
                                                          a 45,45 0 1,0 -90,0
                                                        "
                                                      ></path>
                                                    </g>
                                                    </svg>

                                                    <span id="base-timer-label" class="base-timer__label">${formatTime(timeLeft)}</span>
                                                    </div>                                                                                  `
                startTimer();

                function onTimesUp() {
                    clearInterval(timerInterval);
                    $("#submit").click();
                }

                function startTimer() {
                    timerInterval = setInterval(() => {
                        timePassed = timePassed += 1;
                        timeLeft = TIME_LIMIT - timePassed;
                        document.getElementById("base-timer-label").innerHTML = formatTime(
                            timeLeft
                        );
                        setCircleDasharray();
                        setRemainingPathColor(timeLeft);

                        if (timeLeft === 0) {
                            onTimesUp();
                        }
                    }, 1000);
                }

                function formatTime(time) {
                    const minutes = Math.floor(time / 60);
                    let seconds = time % 60;

                    if (seconds < 10) {
                        seconds = `0${seconds}`;
                    }

                    return `${minutes}:${seconds}`;
                }

                function setRemainingPathColor(timeLeft) {
                    const { alert, warning, info } = COLOR_CODES;
                    if (timeLeft <= alert.threshold) {
                        document
                            .getElementById("base-timer-path-remaining")
                            .classList.remove(warning.color);
                        document
                            .getElementById("base-timer-path-remaining")
                            .classList.add(alert.color);
                    } else if (timeLeft <= warning.threshold) {
                        document
                            .getElementById("base-timer-path-remaining")
                            .classList.remove(info.color);
                        document
                            .getElementById("base-timer-path-remaining")
                            .classList.add(warning.color);
                    }
                }

                function calculateTimeFraction() {
                    const rawTimeFraction = timeLeft / TIME_LIMIT;
                    return rawTimeFraction - (1 / TIME_LIMIT) * (1 - rawTimeFraction);
                }

                function setCircleDasharray() {
                    const circleDasharray = `${(
                calculateTimeFraction() * FULL_DASH_ARRAY
            ).toFixed(0)} 283`;
                    document
                        .getElementById("base-timer-path-remaining")
                        .setAttribute("stroke-dasharray", circleDasharray);
                }

            <?php } ?>
        </script>
        <script>
            var screen = 0;
            var submitted = false;
            var timer2 = "00:00:00";
            var value = $("input[type=radio]:checked").val();
            $('input[type=radio]').click(function () {
                if ($(this).val() === value) {
                    $(this).prop('checked', false);
                    value = "";
                } else {
                    value = $(this).val();
                }
                showStatus("");
            });
            var value = $("input[type=checkbox]:checked").val();
            $('input[type=checkbox]').click(function () {
                if ($(this).val() === value) {
                    $(this).prop('checked', false);
                    value = "";
                } else {
                    value = $(this).val();
                }
                showStatus("");
            });
            $('select').on('change', function (e) {
                showStatus("");
            });

            $(document).ready(function () {
                $('.ques_group div:first').css("display", "block");
                $('.ques_group div:first').addClass('current');

                var interval = setInterval(function () {
                    var timer = timer2.split(':');
                    var hours = parseInt(timer[0], 10);
                    var minutes = parseInt(timer[1], 10);
                    var seconds = parseInt(timer[2], 10);
                    ++seconds;
                    minutes = (seconds > 59) ? ++minutes : minutes;
                    hours = minutes > 59 ? ++hours : hours;
                    if (hours < 0) {
                        clearInterval(interval);
                        return;
                    }
                    seconds = (seconds > 59) ? 0 : seconds;
                    seconds = (seconds < 10) ? '0' + seconds : seconds;
                    minutes = (minutes > 59) ? 0 : minutes;
                    minutes = (minutes < 10) ? '0' + minutes : minutes;
                    timer2 = hours + ':' + minutes + ':' + seconds;
                    $('.current').find('.countdown').html(timer2);
                }, 1000);
                Qn();
                //since total display is different
                if ($('#total_qn_cr').length) {
                    $('#total_qn').text($('#total_qn_cr').val());
                }
            });

            $("#next").click(function () {
                $('.current').find('.countdown').html(timer2);
                showStatus("");
                if ($(".current").next().length == 1) {
                    $(".current").removeClass("current").hide().next().addClass("current").show();
                    timer2 = $('.current').find('.countdown').html();
                }
                if ($(".current").next().length != 1) {
                    $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#next").attr('disabled', 'disabled');
                }
                $("#prev").removeClass("disabled-btn").addClass("bg-color-primary");
                $("#prev").removeAttr("disabled");
                Qn();
            });
            $("#prev").click(function () {
                $('.current').find('.countdown').html(timer2);
                showStatus("");
                if ($(".current").prev().length == 1) {
                    $(".current").removeClass("current").hide().prev().addClass("current").show();
                    timer2 = $('.current').find('.countdown').html();
                }
                if ($(".current").prev().length != 1) {
                    $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#prev").attr('disabled', 'disabled');
                }
                $("#next").addClass("bg-color-primary").removeClass("disabled-btn");
                $("#next").removeAttr("disabled");
                Qn();
            });

            $("#mark_as_review").click(function () {
                $('.current').find('.countdown').html(timer2);
                showStatus("mark");
                if ($(".current").next().length == 1) {
                    $(".current").removeClass("current").hide().next().addClass("current").show();
                    timer2 = $('.current').find('.countdown').html();
                }
                if ($(".current").next().length != 1) {
                    $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#next").attr('disabled', 'disabled');
                }
                $("#prev").addClass("bg-color-primary").removeClass("disabled-btn");
                $("#prev").removeAttr("disabled");
                Qn();
            });

            var counter = 10;

            $("#submit").click(function () {
                var ans = 0;
                var unans = 0;
                var total = 0;
                $('.ques_group>div').each(function () {
                    if ($('input[name="' + $(this).attr('id') + '"]').length > 0) {
                        if ($("input[name=" + $(this).attr('id') + "]:checked").length > 0) {
                            ans = ans + 1;
                        } else {
                            unans = unans + 1;
                        }
                    } else if ($('input[name="FIB_' + $(this).attr('id') + '"]').length > 0) {
                        if ($('input[name="FIB_' + $(this).attr('id') + '"]').val() != '') {
                            ans = ans + 1;
                        } else {
                            unans = unans + 1;
                        }
                    } else if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').length > 0) {
                        if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').val() != '') {
                            ans = ans + 1;
                        } else {
                            unans = unans + 1;
                        }
                    } else {
                        var flag = true;
                        $('select[id="' + $(this).attr('id') + '"]').each(function () {
                            if ($(this).val() == '') {
                                flag = false;
                                return;
                            }
                        });
                        if (flag) {
                            ans = ans + 1;
                        } else {
                            unans = unans + 1;
                        }
                    }
                });
                total = ans + unans;
                $("#ans").html("<?php echo _("AS0124"); ?>: " + ans);
                $("#unans").html("<?php echo _("AS0157"); ?>: " + unans);
                $("#total").html("<?php echo _("AS0158"); ?>: " + total);
                jQuery('#assessment_submit_modal').modal("show");
            });
            function proceed_assessment_submit() {
                $("#close_span").hide();
                $("#modal-footer").hide();
                $("#modal-body").html("<?php echo _("AS0159"); ?>");
                submitquiz();
            }
            function submitquiz() {
                var ass_flag = "<?php echo "$subjective_assessment" ?>";
                //        alert(ass_flag);
                var aid = $('#assmt_id').val();
                var oid = $('#off_id').val();
                var attm = $('#attm').val();

                submitted = true;
                counter = counter % 360 - 1;
                var qids = [];
                var allanswers = [];
                var times = [];
                $('.ques_group>div').each(function () {
                    qids.push($(this).attr('id'));
                    times.push($(this).find('.countdown').html());
                });
                $.each(qids, function (index, value) {
                    var answers = value;
                    if ($('input[name="' + value + '"]').length > 0) {
                        if ($("input[name=" + value + "]:checked").length > 0) {
                            $('input[name="' + value + '"]:checked').each(function () {
                                var ans_op = $(this).attr("class");
                                answers = answers + "_" + ans_op;
                            });
                        }
                        allanswers.push(answers);
                    } else if ($('input[name="FIB_' + value + '"]').length > 0) {
                        $('input[name="FIB_' + value + '"]').each(function () {
                            var ans_op = $(this).val();
                            ans_op = ans_op.replace('_', '%underscore');
                            answers = answers + "_" + ans_op;
                        });
                        allanswers.push(answers);
                    } else if ($('textarea[name="SQ_' + value + '"]').length > 0) {
                        $('textarea[name="SQ_' + value + '"]').each(function () {
                            var ans_op = $(this).val();
                            ans_op = ans_op.replace('_', '%underscore');
                            answers = answers + "_" + ans_op;
                        });
                        allanswers.push(answers);
                    } else {
                        var answers_flag = null;
                        $('select[id="' + value + '"]').each(function () {
                            if ($(this).val() == '') {
                                return true;
                            } else {
                                answers_flag = "1";
                                answers = answers + "_" + $(this).val();
                            }
                        });
                        allanswers.push(answers);
                    }
                });

                var aid = $('#assmt_id').val();
                var oid = $('#off_id').val();
                var attm = $('#attm').val();
                var screen_count = $('#screen_count').val();
                const csrf_token = $('meta[name="csrf-token"]').attr('content');
                //                    alert(aid);
                //                    alert(oid);
                //                    alert(attm);
                //                    alert(screen_count);
                $.ajax({
                    url: 'assessment/quiz_calc_assessment.php',
                    data: { "assmt_id": aid, "allanswers": allanswers, "times": times, "attm": attm, "oid": oid, "screen": screen_count, "csrf_token": csrf_token },
                    dataType: "html",
                    type: 'POST',
                    success: function (data) {
                        if (data === "error") {
                            //                    setTimeout(function () {
                            //                        submitquiz(condition);
                            //                    }, 3000);
                            setTimeout(submitquiz, 3000);
                            if (counter === 0) {
                                var width = window.innerWidth;
                                var height = window.innerHeight;
                                window.close();
                                opener.location.href = 'quiz_error.php?oid=' + oid + '&aid=' + aid + '&attm=' + attm;
                            }
                            return false;
                        } else {
                            opener.CallParent();
                            jQuery('#assessment_submit_modal').modal("hide");
                            //if (condition !== "3") {
                            var form = document.createElement('form');
                            form.setAttribute('method', "post");
                            form.setAttribute('action', 'quiz_result.php');
                            var params = { 'oid': oid, 'aid': aid, 'attm': attm, 'sub_assmt_null': data };
                            for (var i in params) {
                                if (params.hasOwnProperty(i)) {
                                    var input = document.createElement('input');
                                    input.type = 'hidden';
                                    input.name = i;
                                    input.value = params[i];
                                    form.appendChild(input);
                                }
                            }
                            document.body.appendChild(form);
                            form.submit();
                            //}if (condition === "3") {
                            //    window.close();
                            //}
                        }
                    }
                });
            }

            //                RIGHT CLICK DISABLE
            //                $(document).on({
            //                    "contextmenu": function (e) {
            //                        e.preventDefault();
            //                    }
            //                });
            $(document).keydown(function (event) {
                //alert(event.keyCode);
                if (event.keyCode == 123) { // Prevent F12
                    return false;
                } else if (event.ctrlKey && event.shiftKey && event.keyCode == 73) { // Prevent Ctrl+Shift+I        
                    return false;
                } else if (event.keyCode == 116) { //Prevent F5
                    return false;
                } else if (event.ctrlKey && event.keyCode == 82) { // Prevent Ctrl+R 
                    return false;
                } else if (event.ctrlKey && event.keyCode == 65) { //ctrl+a copy
                    return false;
                } else if (event.ctrlKey && event.keyCode == 67) { // Ctrl+C 
                    return false;
                } else if (event.ctrlKey && event.keyCode == 86) { //ctrl+v copy
                    return false;
                }
            });



            window.onload = function () {
                //question_pallet
                $('#pallette').html('');
                $('.assmt_qs').each(function () {
                    // $('#pallette').append("<li id=" + $(this).attr('name') + "><a class='unvisited' style='margin-top:2px;cursor: pointer;' onclick='showQuestion(" + $(this).attr('id') + ")'><i>" + $(this).attr('name') + "</i></a></li>");
                    $('#pallette').append('<div class="col-auto" id="' + $(this).attr('name') + '"><a  class="button -single-icon -light-20 size-35 rounded-8" onclick="showQuestion(' + $(this).attr('id') + ')"><div class="text-15 lh-1 fw-500">' + $(this).attr('name') + '</div></a></div>');
                });
                f1();
                opener.CallParent();
            }

            $(window).on('beforeunload', function () {
                if (submitted == false) {
                    submitquiz("3");
                    return null;
                }
            });

            $(window).blur(function () {
                screen = screen + 1;
                $('#screen_count').val(screen);
            });


            function showStatus(mark) {
                $('.ques_group>.current').each(function () {
                    //remove unvisited class
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-light-20');
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-red-1');
                    $('#pallette > #' + $(this).attr('name') + '').find('a').removeClass('-green-5');
                    if (mark == "") {
                        if ($('input[name="' + $(this).attr('id') + '"]').length > 0) {
                            if ($("input[name=" + $(this).attr('id') + "]:checked").length > 0) {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else if ($('input[name="FIB_' + $(this).attr('id') + '"]').length > 0) {
                            if ($('input[name="FIB_' + $(this).attr('id') + '"]').val() != "") {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').length > 0) {
                            if ($('textarea[name="SQ_' + $(this).attr('id') + '"]').val() != "") {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        } else {
                            var flag = true;
                            $('select[id="' + $(this).attr('id') + '"]').each(function () {
                                if ($(this).val() == '') {
                                    flag = false;
                                    return;
                                }
                            });
                            if (flag) {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-green-5');
                            } else {
                                $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-red-1');
                            }
                        }
                    } else {
                        $('#pallette > #' + $(this).attr('name') + '').find('a').addClass('-orange-6');
                    }
                });
            }

            function showQuestion(q_id) {
                $('.current').find('.countdown').html(timer2);
                showStatus("");
                $(".current").removeClass("current").hide();
                $("#" + q_id + "").addClass("current").show();
                timer2 = $('.current').find('.countdown').html();
                if ($(".current").next().length != 1) {
                    $("#next").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#next").attr('disabled', 'disabled');
                } else {
                    $("#next").addClass("bg-color-primary").removeClass("disabled-btn");
                    $("#next").removeAttr("disabled");
                }
                if ($(".current").prev().length != 1) {
                    $("#prev").removeClass("bg-color-primary").addClass("disabled-btn");
                    $("#prev").attr('disabled', 'disabled');
                } else {
                    $("#prev").addClass("bg-color-primary").removeClass("disabled-btn");
                    $("#prev").removeAttr("disabled");
                }
                Qn();
            }
            var tim;
            var assmt_d;
            var bt = 0;
            var tsh;
            var blink_time = 0.10;
            var min;
            var sec = 00;
            var f = new Date();
            function f1() {
                assmt_d = $('#assmt_d').val();
                if (assmt_d != 0) {
                    tsh = (assmt_d * 10) / 100;
                    min = assmt_d;
                    $("#showtime").hide();
                    f2();
                } else {
                    $(".div_show_time").hide();
                    $("#app").hide();
                }
            }
            function f2() {
                var ms = makeMeTwoDigits(min) + "." + makeMeTwoDigits(sec);
                if (ms <= tsh) {
                    document.getElementById("app").style.color = "#f00";
                }
                if (bt == 0) {
                    if (ms <= blink_time) {
                        bt = 1;
                        blink("#app");
                    }
                }
                if (parseInt(sec) > 0) {
                    sec = parseInt(sec) - 1;
                    document.getElementById("showtime").innerHTML = "" + makeMeTwoDigits(min) + ":" + makeMeTwoDigits(sec) + "";
                    tim = setTimeout("f2()", 1000);
                } else {
                    if (parseInt(sec) == 0) {
                        if (parseInt(min) > 0) {
                            min = parseInt(min) - 1;
                            sec = 59;
                            document.getElementById("showtime").innerHTML = "" + makeMeTwoDigits(min) + ":" + makeMeTwoDigits(sec) + "";
                            tim = setTimeout("f2()", 1000);
                        } else {
                            clearTimeout(tim);
                            $("#close_span").hide();
                            $("#modal-footer").hide();
                            $("#modal-body").html("<?php echo _("AS0159") ?>");
                            jQuery('#assessment_submit_modal').modal("show");
                            submitquiz();
                        }
                    }
                }
            }
            function makeMeTwoDigits(n) {
                return (n < 10 ? "0" : "") + n;
            }
            function blink(selector) {
                $(selector).fadeTo('slow', 0.1, function () {
                    $(this).fadeTo('slow', 1, function () {
                        blink(this);
                    });
                });
            }

            function Qn() {
                var current_question_no = $('.current').find('.qn_in').text();
                $('#qn').text(current_question_no);
            }

        </script>
        <script>
                var is_valid = <?php echo $is_valid ?>;
                if (!is_valid) {
                    window.opener.location.href = "logout.php" ;
                    window.close();
                } 
        </script>
</body>

</html>