<?php

session_start();
include '../config/database.php';
include_once '../security/session_config.php';
// connect to database
include_once '../config/properties.php';
include_once "../resources/offering.php";

// initialize objects
$offering = new Offering();

$offering_val = $_GET['offering_id'];
$mode = $_GET['mode'];
$page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
$records_per_page = 5; // set records or rows of data per page
$from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause

$offering->offering_id = $offering_val;
$offering->user_id=$_SESSION['uid'];
$count_review = $from_record_num;

$html = '';
$total = 0;

$review_count = $offering->review_count();
$total = $review_count;

if ($mode == 'first') {
    $review_text= _("CRT6101");
    $html.= "<h2 class='text-20 fw-500 mt-10 pb-10 border-bottom-dark'>" . $review_count . " ".$review_text."</h2>";
}
if($review_count == 0){
     $no_review= _("CRT6111");
    $html.="<h3 class='py-40 text-center'>".$no_review."</h3>";
}
$stmt_review = $offering->review($from_record_num, $records_per_page);
while ($row_review = $stmt_review->fetch(PDO::FETCH_ASSOC)) {
    $count_review++;
    extract($row_review);
    $rating_star = 0;
    $rating_id = $row_review['rating_id'];
    $user_id = $row_review['user_id'];
    $rating_value = ceil($rating_value * 2) / 2;
    $last_updated_ts = date("M d, Y", strtotime($last_updated_ts));
    $html.= "<div class='md:direction-column border-bottom-dark mt-10 comment'>";
        $html.= "<div class='d-flex' id='li-comment-{$rating_id}'>";
            $html.= "<div class='size-60 mr-20 mt-5'>";
            $filepath =  ADMIN_HTTP_PATH . $properties['jdbc.user_image_folder'] . '/' . $user_image;
            if ($user_image == "") {
                $html.= "<img src='".DEFAULT_USER_IMAGE."' class='object-cover rounded-full' />";
            } else {
                $html.= "<img src='" . $filepath . "'  class='object-cover rounded-full' />";
            }
            $html.= "</div>";
    
            $html.= "<div class='comments__body md:mt-15'>";
                $html.= "<div class='comments__header'>";
                    $html.= "<h4 class='text-17 fw-500 lh-15'>{$first_name} {$last_name}</h4>";
                    $html.= "<div class='d-flex x-gap-5 items-center mt-15'>";
                            $rat=floor($rating_value);
                            $fr=$rating_value-$rat;
                            $rem=5-round($rating_value);
                            for ($i = 1; $i <= $rat; $i++) {
                            $html.=" <i class='fa fa-star text-11 text-yellow-1' ></i>";
                            }
                            if ($fr != null) {
                            $html.=" <i class='fa fa-star-half-o text-11 text-yellow-1'></i>";
                            $rating_value_float=null;
                            }
                            for ($i = 1; $i <=$rem; $i++) {
                            $html.= " <i class='fa fa-star-o text-11 text-yellow-1' ></i>";
                            }
                    $html.= "</div>";
                $html.= "</div>";
            
                    
                $html.= "<p class='text-12 mt-10'>"._("CRT6109") . $last_updated_ts ."</p>";

                $html.= "<div class='comments__text'><p>". htmlentities($comments) . "</p></div>";
                if (isset($_SESSION['uid']) && !empty($_SESSION['uid'])) {
                    $session_user_id = $_SESSION['uid'];
                    $check_spam = $offering->check_spam_review($rating_id, $session_user_id);
                    if ($check_spam->fetch(PDO::FETCH_ASSOC)) {
                       // $html.= "<button  title='Unabuse'  class='hover' style='padding: 0px 5px;' onclick='ReportReview(this,{$rating_id},{$offering_id})'><i class='fa fa-ban'></i><i class='fa fa-spinner fa-spin' id='loader_$rating_id' style='display:none;margin-left:5px;'></i></button>";
                        $html.="<div class='d-flex justify-start mb-15'>
                                                    <button title='Unabuse' class='text-blue-3 button_spam' onclick='ReportReview(this,{$rating_id},{$offering_id})'><i
                                                            class='fa fa-ban'></i> <i class='fa fa-spinner fa-spin' id='loader_$rating_id' style='display:none;margin-left:5px;'></i><span class='text_rate'>Unabuse</span></button>
                                                </div>";
                    } else {
                        if ($session_user_id != $user_id) {
                            //$html.= "<button  title='Report' class='hover' style='padding: 0px 5px;' onclick='ReportReview(this,{$rating_id},{$offering_id})'><i class='fa fa-exclamation'></i><i class='fa fa-spinner fa-spin' id='loader_$rating_id' style='display:none;margin-left:5px;'></i></button>";
                            $html.="<div class='d-flex justify-start mb-15'>
                                                    <button title='Report' class='text-blue-3 button_spam' onclick='ReportReview(this,{$rating_id},{$offering_id})'><i
                                                            class='fa fa-exclamation'></i> <i class='fa fa-spinner fa-spin' id='loader_$rating_id' style='display:none;margin-left:5px;'></i><span class='text_rate'>Report</span></button>
                                                </div>";
                        }
                    }
                }
            $html.= "</div>";
        $html.= "</div>";
    $html.= "</div>";
}
echo json_encode(array("html" => $html, "total" => $total));
?>