<?php
session_start();
include '../config/database.php';
include_once '../security/session_config.php';
include_once '../config/properties.php';
include_once "../resources/forum.php";
include_once "../resources/EncryptDecrypt.php";

// initialize objects
$forum = new Forum();


$session_user_id = $_SESSION['uid'];

$user_id = $_GET['user_id'];
$page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1
$records_per_page = 5; // set records or rows of data per page
$from_record_num = ($records_per_page * $page) - $records_per_page; // calculate for the query LIMIT clause

$forum->user_id = $user_id;

$count_qus = $from_record_num;
$topic_name = $_GET['topic_name'];

if (isset($_GET['s'])) {
    $construct = "";
    $srch = escapeJsonString($_GET['s']);
    $srch_exploded = explode(" ", $srch);
    foreach ($srch_exploded as $srch_each) {
        // $construct .= '[[:<:]]' . $srch_each . '[[:>:]]|';
        $construct .= '([[:blank:][:punct:]]|^)' . $srch_each . '([[:punct:][:blank:]]|$)|';
    }
    $construct = rtrim($construct, '|');
    $stmt_qus = $forum->get_questions_topic_search($topic_name, $from_record_num, $records_per_page, $construct);
} else {
    $stmt_qus = $forum->get_questions_topic($topic_name, $from_record_num, $records_per_page);
}
while ($row_qus = $stmt_qus->fetch(PDO::FETCH_ASSOC)) {
    $count_qus++;
    extract($row_qus);
    $topic_id = $row_qus['topic_id'];
    $user_id1 = $row_qus['user_id'];

    $last_updated_ts_topic = $created_ts;
    $time = date("d-M-Y h:i A", strtotime($last_updated_ts_topic));

    $filepath1 = ADMIN_HTTP_PATH . $properties['jdbc.user_image_folder'] . "/" . $user_image;
    echo "<div class='question-list'>";
    echo "<div class='question-list-question' data-purpose='question' onclick='loadReplies({$topic_id})' id='$topic_id'>";
    echo "<div>";
    if ($user_image == "" || $user_image == NULL) {
        echo "<img alt='{$first_name}' aria-label='{$first_name}' data-purpose='user-avatar' height='48' width='48' src='".DEFAULT_USER_IMAGE."' class='user-avatar user-avatar--image'>";
    } else {
        echo "<img alt='{$first_name}' aria-label='{$first_name}' data-purpose='user-avatar' height='48' width='48' src='" . $filepath1 . "' class='user-avatar user-avatar--image'>";
    }
    echo "</div>";
    echo "<div class='question-list-question-content'>";
    echo "<div class='question-list-question-title ques-title' id='1'>" . htmlspecialchars($topic_title) . "</div>";
    echo "<div class='question-list-question-body' style='color:#007791;'>{$first_name} {$last_name} <b>.</b> " . $time . "</div>";
    echo "<div class='question-list-question-body ques-desc'><pre>" . htmlspecialchars($topic_desc) . "</pre></div>";
    echo "</div>";
    echo "<div data-purpose='responses'>";
    $forum->topic_id = $topic_id;
    $stmt1 = $forum->discussion_forum_response_count();
    if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
        extract($row1);
        echo "<div class='question-list-question-num-answers'>{$response_count}</div>";
    }
    echo "<div>Responses</div>";

    echo "</div>";
    echo "</div>";
    ?>
    <div id="topic_buttons" style="float:right;margin: 0px 30px;">
        <?php
        $check_spam = $forum->check_spam_topic($topic_id, $session_user_id);
        if ($check_spam->fetch(PDO::FETCH_ASSOC)) {
            ?>
            
            <button class="small_buttons hover" onclick="topicRemoveSpam(this,<?php echo $topic_id ?>);" title="<?php echo _("FR0119") ?>"><i class="fa fa-ban"></i><i class="fa fa-spinner fa-spin" id="loader_tra<?php echo $topic_id ?>" style="display:none;margin-left:5px;"></i></button>
            <?php
        } else {
            if ($session_user_id != $user_id1) {
                ?>
                <button class="small_buttons hover" onclick="topicReportSpam(this,<?php echo $topic_id ?>);" title="<?php echo _("FR0118") ?>"><i class="fa fa-exclamation"></i><i class="fa fa-spinner fa-spin" id="loader_ta<?php echo $topic_id ?>" style="display:none;margin-left:5px;"></i></button>
                <?php
            }
        }
        if ($response_count == 0) {
            if ($session_user_id == $user_id1) {
                ?>   
                <button class="small_buttons" id="topic_edit" onclick="topicEdit(<?php echo $topic_id; ?>)" title="<?php echo _("FR0116") ?>"><i class="fa fa-edit"></i></button>
                <button class="small_buttons" id="topic_delete" onclick="topicDelete(<?php echo $topic_id; ?>)" title="<?php echo _("FR0117") ?>"><i class="fa fa-trash"></i></button>
            <?php
            }
        }
        ?>

    </div>
    <?php
    echo "</div>";
}

function escapeJsonString($value) { # list from www.json.org: (\b backspace, \f formfeed)
    // $escapers = array("\\", "/", "\"", "\n", "\r", "\t", "\x08", "\x0c", "'","(");
    //  $replacements = array("\\\\", "\\/", "\\\"", "\\n", "\\r", "\\t", "\\f", "\\b", "\'","[(]");
    $escapers = array("\\", "/", "\"", "'", "(", ".", ")", "|", "+");
    $replacements = array("[\\]", "[/]", "[\"]", "[\']", "[(]", "[.]", "[)]", "[|]", "[+]");
    $result = str_replace($escapers, $replacements, $value);
    return $result;
}
?>
<div id="topicEditModal" class="modal fade">  
    <div class="modal-dialog modal-lg">  
        <div class="modal-content">  
            <div class="modal-header">  
                <button type="button" class="close" data-dismiss="modal">&times;</button>  
                <h4 class="modal-title">Edit</h4>  
            </div>  
            <div>
                <div class="modal-body  bg-primary-opacity-1" id="topic_edit_body">  
                </div>  
            </div> 

        </div>  
    </div>  
</div> 