<?php
session_start();
include '../config/database.php';
include_once '../security/session_config.php';
include_once "../config/properties.php";
include_once "../resources/offering.php";

$offering = new Offering();

$response = array();
$offering_id = $_GET['id'];
$course_name = $_GET['coursename'];
$id = $_SESSION['uid'];
//echo $id;
$time = date("d M Y h:i A", strtotime($date_time));

$topper = array();
$score = 0;
$count = 0;

$offering->offering_id = $offering_id;
$offering->user_id = $id;

$stmt = $offering->getleaders();
if ($stmt->rowCount() > 0) {
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        if ($row['score_flag'] == "No") {
            if ($score != $row['score']) {
                $score = $row['score'];
                $count++;
                $topper["$count"]['leaders'][] = $row['first_name'] . " (" . htmlentities($row['login_id']) . ")";
                $topper["$count"]['image'][] = $row['user_image'];
            } else {
                $topper["$count"]['leaders'][] = $row['first_name'] . " (" . htmlentities($row['login_id']) . ")";
                $topper["$count"]['image'][] = $row['user_image'];
            }
        } else {
            if ($score != $row['score']) {
                $score = $row['score'];
                $count++;
                $topper["$count"]['marks'] = $score . '%';
                $topper["$count"]['leaders'][] = $row['first_name'] . " (" . htmlentities($row['login_id']) . ")";
                $topper["$count"]['image'][] = $row['user_image'];
            } else {
                $topper["$count"]['leaders'][] = $row['first_name'] . " (" . htmlentities($row['login_id']) . ")";
                $topper["$count"]['image'][] = $row['user_image'];
            }
        }
    }
    array_push($response, $topper);
    $data_encode = json_encode($response);

    $keys = array_keys($topper);
    $values = array_values($topper);
    ?>
    <h4 class="text-center mb-5"><?php echo htmlentities($course_name) ?></h4>
    <p class="text-center mb-15">as of <?php echo $time; ?></p>

    <?php
    $value = 0;
    foreach ($keys as $key => $val) {
        $value = count($values[$key]['leaders']);
        if ($val == 1) {
            echo "<div class='d-flex items-center rounded-16 py-10 px-15 bg-white shadow-4'>";
        } else {
            echo "<div class='d-flex items-center rounded-16 py-10 px-15 bg-white shadow-4 mt-10'>";
        }
        echo "<div class='col-md-1 border-right-dark-10 pl-0'>";
        echo "<div class='text-center rounded-8 px-10 py-10' style='";
        if ($val == 1) {
            echo "background-color: #fff7e0";
        } else if ($val == 2) {
            echo "background-color: #e2e2e2";
        } else if ($val == 3) {
            echo "background-color: #ffdbc1";
        }
        echo "'>";
        echo "<svg xmlns='http://www.w3.org/2000/svg' width='28' height='28' viewBox='0 0 38.941 41.203'>";
        echo "<defs>";
        echo "<linearGradient id='linear-gradient-$val' x1='0.5' x2='0.5' y2='1' gradientUnits='objectBoundingBox'>";
        if ($val == 1) {
            echo "<stop offset='0' stop-color='#fac931' />";
            echo "<stop offset='1' stop-color='#fac931' />";
        } else if ($val == 2) {
            echo "<stop offset='0' stop-color='#7c7e77' />";
            echo "<stop offset='1' stop-color='#7c7e77' />";
        } else if ($val == 3) {
            echo "<stop offset='0' stop-color='#a55923' />";
            echo "<stop offset='1' stop-color='#a55923' />";
        }
        echo "</linearGradient>";
        echo "</defs>";
        echo "<path id='cup'
                            d='M41.2,2.262a5.861,5.861,0,0,0-3.154.918V1.371A1.371,1.371,0,0,0,36.675,0h-18.1A1.371,1.371,0,0,0,17.2,1.371V3.181a5.895,5.895,0,1,0-3.153,10.874h2.262a.891.891,0,1,1,0,1.782,1.371,1.371,0,0,0,0,2.742,3.612,3.612,0,0,0,1.8-.481,12.27,12.27,0,0,0,2.054,3.66,9.988,9.988,0,0,0,3.789,2.866,12.988,12.988,0,0,1-.75,3.472c-.92,2.407-2.436,3.577-4.633,3.577H16.313a1.371,1.371,0,0,0-1.371,1.371v6.787A1.371,1.371,0,0,0,16.313,41.2H38.937a1.371,1.371,0,0,0,1.371-1.371V33.045a1.371,1.371,0,0,0-1.371-1.371H36.675c-2.2,0-3.713-1.17-4.633-3.577a12.983,12.983,0,0,1-.75-3.472,9.986,9.986,0,0,0,3.789-2.866,12.266,12.266,0,0,0,2.054-3.66,3.612,3.612,0,0,0,1.8.481,1.371,1.371,0,1,0,0-2.742.891.891,0,0,1,0-1.782H41.2a5.9,5.9,0,0,0,0-11.792Zm-24.886,9.05H14.051A3.154,3.154,0,1,1,17.2,8.158v3.264A3.636,3.636,0,0,0,16.313,11.312Zm21.253,23.1v4.045H17.685V34.416H37.566ZM29.452,29a9.831,9.831,0,0,0,1.475,2.672h-6.6A9.835,9.835,0,0,0,25.8,29a15.5,15.5,0,0,0,.85-3.687,9.2,9.2,0,0,0,1.954,0A15.5,15.5,0,0,0,29.452,29Zm-1.827-6.377c-4.449,0-7.678-4.181-7.678-9.941V2.742H35.3v9.941C35.3,18.443,32.074,22.624,27.625,22.624ZM41.2,11.312H38.937a3.631,3.631,0,0,0-.891.111V8.158A3.154,3.154,0,1,1,41.2,11.312Z'
                            transform='translate(-8.155)' fill='url(#linear-gradient-$val)' />";
        echo "</svg>";
        echo "</div>";
        echo "</div>";
        echo "<div class='col-md-1 rounded-full size-50 ml-10 mr-5' style='";
        if ($val == 1) {
            echo "background-color: #fac931";
        } else if ($val == 2) {
            echo "background-color: #7c7e77";
        } else if ($val == 3) {
            echo "background-color: #a55923";
        }
        echo "'>";
        echo "<h1 class='text-20 fw-500 mt-15 mb-0 text-white text-center'>$val</h1>";
        echo "</div>";
        if ($value == 1) {
            ?>
            <div class="col-md-9">
                <h1 class="text-18 fw-500 mt-10"><?php echo $values[$key]['leaders'][0]; ?></h1>
            </div> 
        <?php } else if ($value > 1) { ?>
            <div class="col-md-9">
                <a href="#" class="text-18 fw-500 mt-10 text-blue-3 multiple">Multiple</a>
                <table class="leaders">
                    <?php
                    $i = 0;
                    while ($i < $value) {
                        echo "<tr>";
                        echo "<td><i class='fa fa-user'></i></td>";
                        echo "<td>" . $values[$key]['leaders'][$i] . "</td>";
                        echo "</tr>";
                        $i++;
                    }
                    ?>
                </table>
            </div>
        <?php
        } else {
            echo 'None';
        }
        ?>
        <div class="col-md-1 text-right">
            <h1 class="text-18 fw-500 mt-10"><?php echo $values[$key]['marks']; ?></h1>
        </div>
        <?php
        echo "</div>";
    }
    if ($value == 0) {
        echo 'None';
    }
    ?>
    <?php
    $pass_count = 0;
    $total_count = 0;
    $stmt = $offering->getTotalCompletionCount();
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $total_count = $row['total_user'];
    }
    $stmt = $offering->getCompletionCount();
    if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $pass_count = $row['overall_result'];
    }
    ?>    
    <h4 class="text-center mt-25 mb-5"><?php echo _("HM0117"); ?></h4>
    <div class="d-flex justify-center">
        <div class="col-md-6 py-20">
            <div class="progress-bar-1">
                <div class="progress-bar__bg-1 bg-light-12"></div>
                <div class="progress-bar__bar-1 progress-bar-info" style="width:<?php echo Round(($pass_count * 100) / $total_count); ?>%">
                    <span class="text-12 fw-500"><?php echo Round(($pass_count * 100) / $total_count); ?>%</span>
                </div>
            </div>
        </div>
    </div>
    <?php
} else {
    echo "<h4 class='text-center'>";
    echo _("HM0502");
    echo "</h4>";
}
?>