<?php

session_start();
    include "../config/database.php";
    include_once '../security/session_config.php';
    include_once "../resources/offering.php";
    include_once '../config/properties.php';

    // initialize objects
    $offering = new Offering();
    $mode = $_GET['mode'];
    $offer = $_GET['offer'];
    $user = $_SESSION['uid'];
    $id = $_GET['id'];
    $offering->offering_id = $offer;
    $offering->user_id = $user;

    $next_allowed = "Yes";
    $html = "";

    if ($mode == "content") {

        $type = null;
        $path = null;
        $mobitute_content = ADMIN_PATH . $properties['jdbc.content_folder'] . "/";
        $mobitute_content1 = ADMIN_HTTP_PATH . $properties['jdbc.content_folder'] . "/";
        $offering->contentdtl_id = $id;
        $stmt = $offering->getContentPath();
        $grade_items = "N";
        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $lids = "";
            $course_id = $row['course_id'];
            $course_name = $row['course_name'];
            $lesson_id1 = $row['lesson_id'];
            $content_type_name = $row['content_type_name'];
            $content_path = $row['content_path'];
            $content_size = $row['content_size'];
            $lesson_name = $row['lesson_name'];
            $content_id = $row['content_id'];
            $contentdtl_id = $row['contentdtl_id'];
            $content_title = $row['content_title'];
            $end_date = $row['end_date'];
            $offering_count = $row['offering_count'];
            $lesson_dependency = $row['lesson_dependency'];
            $seq_no = $row['seq_no'];
            $total_time = $row['total_time'];
            $completed = $row['completed'];
            $online = $row['online'];
            $result = $row['result'];
            $status = $row['status'];
            $prev_status = $row['prev_status'];
            $time_diff = $row['time_diff'];
            $comp_id = $row['company_id'];

            $path_download = '' . $row['course_id'] . '/' . $row['lesson_id'] . '/' . $row['content_id'] . '/' . $content_path . '';

            if ($content_type_name == "Video" || $content_type_name == "Audio" || $content_type_name == "Image" || $content_type_name == "Document") {
                $FileTypeExt = pathinfo($content_path, PATHINFO_EXTENSION);
                $supported_image = array(
                    'gif', 'jpg', 'jpeg', 'png', 'bmp'
                );
                $supported_audio = array(
                    'mp3', 'wav', 'wave', 'm4a', 'm4p', 'm4r', 'ogg'
                );
                $supported_video = array(
                    'ogv', 'oga', 'ogx', 'ogm', 'spx', 'opus', 'webm', 'mp4', 'm4b', 'm4v', 'mov', 'qt', 'mkv'
                );
                $supported_document = array(
                    'doc', 'docx', 'xls', 'xlsx', 'pdf', 'ppt', 'pptx', 'txt', 'xml', 'xsl', 'rtf','csv'
                );
                $ext = strtolower(pathinfo($content_path, PATHINFO_EXTENSION)); // Using strtolower to overcome case sensitive
                if (in_array($ext, $supported_image)) {
                    $type = "image";
                    $path = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                } else if (in_array($ext, $supported_audio)) {
                    $type = "audio";
                    $path = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                } else if (in_array($ext, $supported_video)) {
                    $type = "video";
                    $path = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                } else if (in_array($ext, $supported_document)) {
                    $type = "document";
                    if ($ext == "pdf") {
                        $path = "ViewerJS/index.html#$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                    } else if($ext == "xls" || $ext == "xlsx"){
                        $path1 = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                        $path = "https://view.officeapps.live.com/op/embed.aspx?src=$path1";
                        //$path = "https://docs.google.com/viewer?url=$path1&embedded=true";
                    } else {
                        $path1 = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                        $path = "https://docs.google.com/viewer?url=$path1&embedded=true";
                    }
                    //$path1 = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                    //$path = "https://docs.google.com/viewer?url=$path1&embedded=true";
                } else {
                    if ($content_size >= 1099511627776) {
                        $content_size = number_format($content_size / 1099511627776, 2) . ' TB';
                    } elseif ($content_size >= 1073741824) {
                        $content_size = number_format($content_size / 1073741824, 2) . ' GB';
                    } elseif ($content_size >= 1048576) {
                        $content_size = number_format($content_size / 1048576, 2) . ' MB';
                    } elseif ($content_size >= 1024) {
                        $content_size = number_format($content_size / 1024) . ' KB';
                    } elseif ($content_size > 1) {
                        $content_size = $content_size . ' bytes';
                    } elseif ($content_size == 1) {
                        $content_size = $content_size . ' byte';
                    } else {
                        $content_size = '0 bytes';
                    }
                    $type = "other";
                    $path = "modules/track_content.php?path=$course_id/$lesson_id1/$content_id/$content_path&cid=$contentdtl_id&oid=$offer&uid=$user&mode=download";
                }
            } else if ($content_type_name == "HTML5") {
                $offering->contentdtl_id = $contentdtl_id;
                $stmt1 = $offering->getHTML();
                if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                    $foldername = pathinfo($content_path, PATHINFO_FILENAME);
                    $type = "HTML5";
                    $page = $row1['start_page'];
                    $path = "$mobitute_content1$course_id/$lesson_id1/$content_id/$foldername/$page";
                }
            } else if ($content_type_name == "SCORM") {
                $rslt = "N";
                $offering->contentdtl_id = $contentdtl_id;
                $stmt1 = $offering->getScorm();
                if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                    $foldername = pathinfo($content_path, PATHINFO_FILENAME);

                    $offering->scorm_id = $row1['scorm_id'];
                    $offering->offering_id = $offer;
                    $offering->user_id = $_SESSION['uid'];
                    if ($result == null || $result == 'awaited') {
                        $stmt_rslt = $offering->checkScormStatus();
                        if ($row1_rslt = $stmt_rslt->fetch(PDO::FETCH_ASSOC)) {
                            if ($row1_rslt['value'] == "passed" || $row1_rslt['value'] == "completed") {
                                $rslt = "Y";
                            }
                        }
                    } else {
                        $rslt = "Y";
                    }

                    $type = "Scorm";
                    $scorm_id = $row1['scorm_id'];
                    $path = "scorm/rte.php?scorm_id=$scorm_id&contentdtl_id=$contentdtl_id&oid=$offer&uid=$user&end_date=$end_date&rslt=$rslt&path=$course_id/$lesson_id1/$content_id/$foldername/";
                }
            } else if ($content_type_name == "Webcontent") {
                $offering->contentdtl_id = $contentdtl_id;
                $stmt1 = $offering->getWebContent();
                if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {

                    if ($row1['link_type'] == "YouTube") {
                        $type = "YouTube";
                        $path1 = $row1['web_link'];
                        $path = "https://www.youtube.com/embed/$path1?autoplay=1&rel=0&showinfo=0";
                    } else if ($row1['link_type'] == "SlideShare") {
                        $type = "SlideShare";
                        $path1 = $row1['web_link'];
                        $path = "//www.slideshare.net/slideshow/embed_code/key/$path1";
                    } else if ($row1['link_type'] == "Vimeo") {
                        $type = "Vimeo";
                        $path1 = $row1['web_link'];
                        $path = "https://player.vimeo.com/video/$path1?title=0&byline=0&portrait=0";
                    } else if ($row1['link_type'] == "Wikipedia") {
                        $type = "Wikipedia";
                        $path1 = $row1['web_link'];
                        $path = "https://en.wikipedia.org/w/index.php?printable=yes&title=$path1";
                    } else if ($row1['link_type'] == "Scribd") {
                        $type = "Scribd";
                        $path1 = $row1['web_link'];
                        $path = "https://www.scribd.com/embeds/$path1/content";
                    } else if ($row1['link_type'] == "Others") {
                        $type = "HTML";
                        $path = $row1['web_link'];
                    }
                }
            } else if ($content_type_name == "Live") {
                $type = "live";
                $date_time_ = date("Y-m-d H:i");
                $minutes_to_add = $row['content_duration'];
                $time = new DateTime($row['start_time']);
                $time->add(new DateInterval('PT' . $minutes_to_add . 'M'));
                $stamp = $time->format('Y-m-d H:i');
                if ($stamp < $date_time_) {
                    $path = $row['recording_url'];
                } else {
                    $path = $row['attendee_url'];
                }
            }else if ($content_type_name == "XAPI") {
                $rslt = "N";
                $offering->contentdtl_id = $contentdtl_id;
                $stmt1 = $offering->getxApi();
                if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                    $foldername = pathinfo($content_path, PATHINFO_FILENAME);

                    $offering->xapi_id = $row1['xapi_id'];
                    $offering->offering_id = $offer;
                    $offering->user_id = $_SESSION['uid'];
                    if ($result == null || $result == 'awaited') {
                        $stmt_rslt = $offering->checkxApiStatus();
                        if ($row1_rslt = $stmt_rslt->fetch(PDO::FETCH_ASSOC)) {
                            if ($row1_rslt['status'] == "passed" || $row1_rslt['status'] == "completed") {
                                $rslt = "Y";
                            }
                        }
                    } else {
                        $rslt = "Y";
                    }

                    $type = "xapi";
                    $xapi_id = $row1['xapi_id'];
                    $path = "xapi/data.php?xapi_id=$xapi_id&contentdtl_id=$contentdtl_id&oid=$offer&uid=$user&end_date=$end_date&rslt=$rslt&coid=$course_id&path=$course_id/$lesson_id1/$content_id/$foldername/";
                }
            } else if ($content_type_name == "LTI") {
                    $type = "lti";
                    $path = "tool/launch.php?user_id=$user&id=$contentdtl_id&oid=$offer&cid=$comp_id";
                    $stmt_lti = $offering->check_Gradeitem();
                    if ($stmt_lti->rowCount() > 0) {
                        $grade_items = "Y";
                    }
            }

            if ($offering_count == 0) {
            if ($content_type_name == 'SCORM' || $content_type_name == 'XAPI' || ($content_type_name == 'LTI' && $grade_items=='Y')) {
                    $button_value = 'Incomplete';
                } else {
                    $button_value = 'Mark as completed';
                }
            } else if ($offering_count != 0) {
                $button_value = 'Completed';
            }
            if ($lesson_dependency == "Y") {
                $html = div_content($offer, $seq_no, $user, $content_title);
                if ($html != "") {
                    $next_allowed = "No";
                }
            }
        }

        $total_seconds = 0;
        if ($total_time != null) {
            list($hours, $minutes, $seconds) = explode(':', $total_time, 3);
            $total_seconds = $seconds + $minutes * 60 + $hours * 3600;
        }
        if ($completed == null) {
            $completed = 'N';
        }

        echo json_encode(array(
            'type' => $type,
            'path' => $path,
            'course' => $course_name,
            'lesson' => $lesson_name,
            'content' => $content_title,
            'button_value' => $button_value,
            'lesson_id' => $lesson_id1,
            'end_date' => $end_date,
            'next_allowed' => $next_allowed,
            'total_time' => $total_seconds,
            'completed' => $completed,
            'online' => $online,
            'path_download' => $path_download,
            'html' => $html,
            'mode' => $mode,
            'result' => $result,
            'status' => $status,
            'prev_status' => $prev_status,
            'time_diff' => $time_diff
        ));
    } else if ($mode == "assessment") {
        $offering->assessment_id = $id;
        $stmt = $offering->getCYUdependency();
        if ($row1 = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $lesson_dependency = $row1['lesson_dependency'];
            $seq_no = $row1['seq_no'];
            $content_title = "Check Your Understanding";
            if ($lesson_dependency == "Y") {
                $html = div_content($offer, $seq_no, $user, $content_title);
                if ($html != "") {
                    $next_allowed = "No";
                }
            }
        }
        echo json_encode(array(
            'next_allowed' => $next_allowed,
            'html' => $html,
            'mode' => $mode
        ));
    }

function div_content($offer, $seq_no, $user, $content_title) {
    $offering = new Offering();
    $offering->offering_id = $offer;
    $offering->seq_no = $seq_no;
    $offering->user_id = $user;
    $html = "";
    $stmt_content_count = $offering->content_count_lesson();
    if ($row_content_count = $stmt_content_count->fetch(PDO::FETCH_ASSOC)) {
        extract($row_content_count);
    }
    if ($total_content != $viewed_content) {
        $offering->offering_id = $offer;
        $offering->user_id = $user;
        $stmt_lesson_content_details = $offering->lesson_content_dtls();
        $html = $html . "<br/><center><div id='lesson_content_pending_list'><table class='table table-bordered'>"
                . "<colgroup><col style='width:30%;'><col style='width:30%;'></colgroup>"
                . "<tr><td colspan='2' style='text-align:center;'><b>Click 'Mark As Completed' checkbox shown below each of these lessons' content pages, before opening-" . $content_title . "</b></td></tr>"
                . "<tr><th class='bold'>Lesson Name</th><th class='bold'>Content Name</th></tr>";
        while ($row_lesson_content_details = $stmt_lesson_content_details->fetch(PDO::FETCH_ASSOC)) {
            extract($row_lesson_content_details);
            $completed1 = $row_lesson_content_details['completed'];
            if ($completed1 != 'Y') {
                $lname = $row_lesson_content_details['lesson_name'];
                $cname = $row_lesson_content_details['content_title'];
                $html = $html . "<tr><td>$lname</td><td>$cname</td></tr>";
            }
        }
        $html = $html . "</table></div></center>";
    }
    return $html;
}

?>
