<?php
ob_start();
header('Content-Type: application/json');
error_reporting(1);
ini_set('display_errors', 1);
session_start();

require_once '../vendor/autoload.php';
require_once '../config/database.php';
//Include for Token (11 and 12,17 and 18)
include_once '../security/session_config.php';
include_once '../security/csrf.php';

require_once '../config/properties.php';
include_once "../resources/offering.php";

$csrf_token = $_POST['csrf_token'];
validate_csrf_request($csrf_token);

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Smalot\PdfParser\Parser;
use PhpOffice\PhpWord\IOFactory;

$offering = new Offering();
$mode = $_POST['mode'];
$offer = $_POST['offer'];
$user = $_SESSION['uid'];
$ids = $_POST['ids'] ?? [];

$offering->offering_id = $offer;
$offering->user_id = $user;

if (!is_array($ids)) {
    $ids = [$ids];
    var_dump($ids);
}
error_log('IDs: ' . print_r($ids, true));
$response = [];


// SET THIS: your actual OpenAI API key
// const OPENAI_API_KEY = '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';
   const OPENAI_API_KEY = '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';
const OCR_SPACE_KEY  = 'helloworld';

$allowedExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'bmp', 'gif', 'tif', 'tiff', 'webp'];

function isImage($mime)
{
    return in_array($mime, ['image/jpeg', 'image/png', 'image/jpg', 'image/webp', 'image/gif', 'image/bmp', 'image/tiff', 'image/x-tiff']);
}

function isAudio($mime)
{
    return in_array($mime, ['audio/mpeg', 'audio/wav', 'audio/mp3', 'audio/x-wav', 'audio/webm']);
}

function isVideo($mime)
{
    return in_array($mime, ['video/mp4', 'video/webm', 'video/ogg']);
}

function isText($mime)
{
    return $mime === 'text/plain';
}

function isDocOrDocx($mime)
{
    return in_array($mime, [
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
    ]);
}

function extractTextFromImage($imagePath)
{
    $client = new Client();
    $apiKey = OCR_SPACE_KEY;

    try {
        $response = $client->request('POST', 'https://api.ocr.space/parse/image', [
            'multipart' => [
                ['name' => 'apikey', 'contents' => $apiKey],
                ['name' => 'file', 'contents' => fopen($imagePath, 'r'), 'filename' => 'uploaded_image.jpg'],
                ['name' => 'language', 'contents' => 'eng']
            ]
        ]);

        $body = json_decode($response->getBody(), true);
        if (!empty($body['IsErroredOnProcessing'])) {
            return 'OCR error: ' . ($body['ErrorMessage'][0] ?? 'Unknown error.');
        }

        return $body['ParsedResults'][0]['ParsedText'] ?? 'No text extracted.';
    } catch (RequestException $e) {
        return 'OCR error: ' . $e->getMessage();
    }
}

function transcribeAudio($audioPath)
{
    $client = new Client();
    $apiKey = OPENAI_API_KEY;

    try {
        $response = $client->request('POST', 'https://api.openai.com/v1/audio/transcriptions', [
            'headers' => [
                'Authorization' => 'Bearer ' . $apiKey,
            ],
            'multipart' => [
                ['name' => 'file', 'contents' => fopen($audioPath, 'r')],
                ['name' => 'model', 'contents' => 'whisper-1'],
            ],
        ]);

        $body = json_decode($response->getBody(), true);
        return $body['text'] ?? 'No transcription result.';
    } catch (RequestException $e) {
        return 'Transcription error: ' . $e->getMessage();
    }
}

function extractTextFromDoc($filePath)
{
    try {
        $phpWord = IOFactory::load($filePath);
        $text = '';
        foreach ($phpWord->getSections() as $section) {
            foreach ($section->getElements() as $element) {
                if (method_exists($element, 'getText')) {
                    $text .= $element->getText() . "\n";
                }
            }
        }
        return $text ?: "No text extracted from .docx.";
    } catch (Exception $e) {
        return "Error reading Word document: " . $e->getMessage();
    }
}

function fetchCourseContent($content_ids, $properties, $offering)
{
    // $mobitute_content = ADMIN_PATH . $properties['jdbc.content_folder'] . "/";
    $mobitute_content1 = ADMIN_HTTP_PATH . $properties['jdbc.content_folder'] . "/";
    $urls = [];
    foreach ($content_ids as $id) {
        $offering->contentdtl_id = $id;
        $stmt = $offering->getContentPath();

        if ($stmt && $row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $course_id = $row['course_id'];
            $lesson_id1 = $row['lesson_id'];
            $content_id = $row['content_id'];
            $content_path = rawurlencode($row['content_path']);

            $ext = strtolower(pathinfo($content_path, PATHINFO_EXTENSION));
            $type = "other";
            $path = "";

            $supported_image = ['gif', 'jpg', 'jpeg', 'png', 'bmp'];
            $supported_audio = ['mp3', 'wav', 'wave', 'm4a', 'm4p', 'm4r', 'ogg'];
            $supported_video = ['ogv', 'oga', 'ogx', 'ogm', 'spx', 'opus', 'webm', 'mp4', 'm4b', 'm4v', 'mov', 'qt', 'mkv'];
            $supported_document = ['doc', 'docx', 'xls', 'xlsx', 'pdf', 'ppt', 'pptx', 'txt', 'xml', 'xsl', 'rtf', 'csv'];

            if (in_array($ext, $supported_image)) {
                $type = "image";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_audio)) {
                $type = "audio";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_video)) {
                $type = "video";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_document)) {
                $type = "document";
                if ($ext === "pdf") {
                    $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                } else {
                    $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                }
            }
        } else {
            $urls[] = "";
        }
    }
    error_log("Fetched URLs: " . print_r($urls, true));
    return $urls;
}

function extractTextFromUrl(string $url): string
{
    error_log("Extracting text from URL in function: $url");
    $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    $fileData = file_get_contents($url);
    if ($fileData === false) {
        return "Failed to download content from: $url";
    }
    // $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    error_log("File data: " . print_r($fileData, true));
    $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    error_log("File saved to: $tempFile");
    file_put_contents($tempFile, $fileData);

    $mimeType = mime_content_type($tempFile);
    $text = '';

    if (isImage($mimeType)) {
        $text = extractTextFromImage($tempFile);
    } elseif (isAudio($mimeType)) {
        // Try to extract extension from the URL
        $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION));

        // If extension is missing, try to guess from MIME type
        if (!$ext || strlen($ext) < 2) {
            // Map common MIME types to extensions
            $mimeMap = [
                'audio/mpeg' => 'mp3',
                'audio/mp3' => 'mp3',
                'audio/mp4' => 'mp4',
                'audio/mpeg' => 'mpeg',
                'audio/mpga' => 'mpga',
                'audio/x-m4a' => 'm4a',
                'audio/wav' => 'wav',
                'audio/webm' => 'webm',
            ];
            $ext = $mimeMap[$mimeType] ?? '';
        }

        $whisperSupported = ['mp3', 'mp4', 'mpeg', 'mpga', 'm4a', 'wav', 'webm'];

        if (in_array($ext, $whisperSupported)) {
            $tempFileWithExt = $tempFile . '.' . $ext;

            // Rename downloaded file to include extension
            if (rename($tempFile, $tempFileWithExt)) {
                $text = transcribeAudio($tempFileWithExt);
                unlink($tempFileWithExt);
            } else {
                $text = "Failed to prepare the audio file for transcription.";
            }
        } else {
            $text = "Unsupported or undetectable audio format: .$ext";
        }
    } elseif ($mimeType === 'application/pdf') {
        try {
            $parser = new Parser();
            $pdf = $parser->parseFile($tempFile);
            $text = $pdf->getText();
        } catch (Exception $e) {
            $text = "Error parsing PDF: " . $e->getMessage();
        }
    } elseif (isVideo($mimeType)) {
        // Try to extract extension from the URL
        $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION));

        // If no extension is found, fallback to known MIME type map
        if (!$ext || strlen($ext) < 2) {
            $mimeMap = [
                'video/mp4' => 'mp4',
                'video/webm' => 'webm',
                'video/mpeg' => 'mpeg',
                'audio/mpga' => 'mpga', // Some servers might mislabel audio as video
                'audio/m4a' => 'm4a',
                'audio/mp3' => 'mp3',
                'audio/wav' => 'wav',
            ];
            $ext = $mimeMap[$mimeType] ?? '';
        }

        // Whisper API supported formats
        $whisperSupported = ['mp4', 'webm', 'mpeg', 'mpga', 'm4a', 'mp3', 'wav'];

        if (in_array($ext, $whisperSupported)) {
            // Save with proper extension
            $tempFileWithExt = $tempFile . '.' . $ext;

            if (rename($tempFile, $tempFileWithExt)) {
                // Transcribe
                $text = transcribeAudio($tempFileWithExt);
                unlink($tempFileWithExt);
            } else {
                $text = "Failed to prepare the video/audio file for transcription.";
            }
        } else {
            $text = "Unsupported video/audio format: .$ext";
        }
    } elseif (isText($mimeType)) {
        $text = file_get_contents($tempFile);
    } elseif (isDocOrDocx($mimeType)) {
        $text = extractTextFromDoc($tempFile);
    } else {
        $text = "Unsupported file type: $mimeType";
    }

    unlink($tempFile);
    return $text;
}


// === Handle POST ===
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $mode = $_POST['mode'] ?? '';
    $user_input = trim($_POST['user_input'] ?? '');

    if (!$user_input) {
        echo json_encode(['status' => 'error', 'message' => 'Missing user input.']);
        exit;
    }

    $offering_id = $_POST['offer'] ?? '';
    $content_ids = $_POST['ids'] ?? [];

    if (!$offering_id || !$content_ids) {
        echo json_encode(['status' => 'error', 'message' => 'Missing course content info.']);
        exit;
    }
    error_log("Line 297");

    $urls = fetchCourseContent($content_ids, $properties, $offering);
    error_log("Fetched course content: " . print_r($urls, true));

    if (is_array($urls) && count($urls) > 0) {
        foreach ($urls as $url) {
            if (empty($url)) continue;

            error_log("Processing URL: $url");

            $fileData = @file_get_contents($url);
            if ($fileData === false) {
                error_log("Failed to download: $url");
                continue;
            }

            $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
            file_put_contents($tempFile, $fileData);

            error_log("Saved file to: $tempFile");
            error_log("File data: " . print_r($fileData, true));

            $text = extractTextFromUrl($tempFile);
            $extractedTexts[] = $text;

            error_log("Extracted text from $url: " . substr($text, 0, 300)); // just the first 300 chars

            $urls = implode("\n\n---\n\n", $extractedTexts);
            file_put_contents("log.txt", $urls);
            $_SESSION['extracted_text'] = $urls;
            file_put_contents("log.txt", $urls);
        }
    }
}
// === ChatGPT Call ===
try {
    $client = new Client();

    if (empty($urls)) {
        echo json_encode(['status' => 'error', 'message' => 'No content to reference.']);
        exit;
    }

    $systemMessage = "You are an educational assistant. Only answer based on the provided content. "
        . "Do not mention content IDs, file names, or URLs. Summarize or describe the material in a human-readable, friendly tone. "
        . "If a question is not related to the content, respond with \"I'm here to help with questions based on the course content. Could you ask something related to what we've covered?\"\n\n"
        . "Here is the content:\n$urls";

    $response = $client->post('https://api.openai.com/v1/chat/completions', [
        'headers' => [
            'Authorization' => 'Bearer ' . OPENAI_API_KEY,
            'Content-Type' => 'application/json',
        ],
        'json' => [
            'model' => 'gpt-3.5-turbo',
            'messages' => [
                ['role' => 'system', 'content' => $systemMessage],
                ['role' => 'user', 'content' => "Context:\n$urls\n\nQuestion:\n$user_input"]
            ],
            'temperature' => 0.7,
            'max_tokens' => 1024
        ],
        'verify' => false,
    ]);

    $responseData = json_decode($response->getBody(), true);
    $chatResponse = $responseData['choices'][0]['message']['content'] ?? 'No response from ChatGPT.';

    echo json_encode([
        'status' => 'success',
        'content' => $urls,
        'response' => $chatResponse
    ]);
} catch (RequestException $e) {
    echo json_encode([
        'status' => 'error',
        'message' => 'OpenAI API request failed.',
        'details' => $e->getMessage()
    ]);
    exit;
}
