<?php

ini_set('display_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../vendor/autoload.php';
require_once '../config/database.php';
require_once '../config/properties.php';
//Include for Token (11 and 12,16 and 17)
include_once '../security/session_config.php';
include_once '../security/csrf.php';

include_once "../resources/offering.php";

$csrf_token = $_POST['csrf_token'];
validate_csrf_request($csrf_token);

use GuzzleHttp\Client;
use GuzzleHttp\Exception\RequestException;
use Smalot\PdfParser\Parser;
use PhpOffice\PhpWord\IOFactory;

// const OPENAI_API_KEY = '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';
const OPENAI_API_KEY = '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';
const OCR_SPACE_KEY  = 'helloworld';

$offering = new Offering();
$mode = $_POST['mode'] ?? null;
$offeringId = $_POST['offer'] ?? null;
$user = $_SESSION['uid'] ?? null;
$offering->offering_id = $offeringId;
$offering->user_id = $user;
$response = [];

if (isset($mode) && $mode == "notes") {
    error_log("should come here first");
    $stmt = $offering->getContentPathByOffering();
    $rowCount = $stmt->rowCount();
    $courseContentMap = [];
    error_log("Row count: $rowCount");

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $courseId = $row['course_id'];
        $contentDtlId = $row['contentdtl_id'];
        $contentPath = $row['content_path'];
        error_log("Processing content: $contentPath");

        // Group contentdtl_ids by course
        if (!isset($courseContentMap[$courseId])) {
            $courseContentMap[$courseId] = [
                'offering_id' => $offeringId,
                'contentdtl_ids' => []
            ];
        }
        $courseContentMap[$courseId]['contentdtl_ids'][] = $contentDtlId;
    }

    // Clean duplicates
    foreach ($courseContentMap as &$entry) {
        $entry['contentdtl_ids'] = array_values(array_unique($entry['contentdtl_ids']));
    }

    // Call fetchCourseContent
    $allContentIds = [];
    foreach ($courseContentMap as $entry) {
        $allContentIds = array_merge($allContentIds, $entry['contentdtl_ids']);
    }

    // Use fetchCourseContent to get URLs
    $links = fetchCourseContent($allContentIds, $properties, $offering);
}


// Allowed extensions
$allowedExtensions = ['pdf', 'jpg', 'jpeg', 'png', 'bmp', 'gif', 'tif', 'tiff', 'webp'];

function isImage($mime)
{
    return in_array($mime, ['image/jpeg', 'image/png', 'image/jpg', 'image/webp', 'image/gif', 'image/bmp', 'image/tiff', 'image/x-tiff']);
}

function isAudio($mime)
{
    return in_array($mime, ['audio/mpeg', 'audio/wav', 'audio/mp3', 'audio/x-wav', 'audio/webm']);
}

function isVideo($mime)
{
    return in_array($mime, ['video/mp4', 'video/webm', 'video/ogg']);
}

function isText($mime)
{
    return $mime === 'text/plain';
}

function isDocOrDocx($mime)
{
    return in_array($mime, [
        'application/msword',
        'application/vnd.openxmlformats-officedocument.wordprocessingml.document'
    ]);
}

function extractTextFromImage($imagePath)
{
    $client = new Client();
    $apiKey = OCR_SPACE_KEY;

    try {
        $response = $client->request('POST', 'https://api.ocr.space/parse/image', [
            'multipart' => [
                ['name' => 'apikey', 'contents' => $apiKey],
                ['name' => 'file', 'contents' => fopen($imagePath, 'r'), 'filename' => 'uploaded_image.jpg'],
                ['name' => 'language', 'contents' => 'eng']
            ]
        ]);

        $body = json_decode($response->getBody(), true);
        if (!empty($body['IsErroredOnProcessing'])) {
            return 'OCR error: ' . ($body['ErrorMessage'][0] ?? 'Unknown error.');
        }

        return $body['ParsedResults'][0]['ParsedText'] ?? 'No text extracted.';
    } catch (RequestException $e) {
        return 'OCR error: ' . $e->getMessage();
    }
}

function transcribeAudio($audioPath)
{
    $client = new Client();
    $apiKey = OPENAI_API_KEY; // Replace with your OpenAI API key

    try {
        $response = $client->request('POST', 'https://api.openai.com/v1/audio/transcriptions', [
            'headers' => [
                'Authorization' => 'Bearer ' . $apiKey,
            ],
            'multipart' => [
                ['name' => 'file', 'contents' => fopen($audioPath, 'r')],
                ['name' => 'model', 'contents' => 'whisper-1'],
            ],
        ]);

        $body = json_decode($response->getBody(), true);
        return $body['text'] ?? 'No transcription result.';
    } catch (RequestException $e) {
        return 'Transcription error: ' . $e->getMessage();
    }
}

function extractTextFromDoc($filePath)
{
    try {
        $phpWord = IOFactory::load($filePath);
        $text = '';
        foreach ($phpWord->getSections() as $section) {
            foreach ($section->getElements() as $element) {
                if (method_exists($element, 'getText')) {
                    $text .= $element->getText() . "\n";
                }
            }
        }
        return $text ?: "No text extracted from .docx.";
    } catch (Exception $e) {
        return "Error reading Word document: " . $e->getMessage();
    }
}

function fetchCourseContent($content_ids, $properties, $offering)
{
    // $mobitute_content = ADMIN_PATH . $properties['jdbc.content_folder'] . "/";

    error_log("Its inside fetchCourseContent function");
    $mobitute_content1 = ADMIN_HTTP_PATH . $properties['jdbc.content_folder'] . "/";
    $urls = [];
    foreach ($content_ids as $id) {
        $offering->contentdtl_id = $id;
        $stmt = $offering->getContentPath();

        if ($stmt && $row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $course_id = $row['course_id'];
            $lesson_id1 = $row['lesson_id'];
            $content_id = $row['content_id'];
            $content_path = rawurlencode($row['content_path']);

            $ext = strtolower(pathinfo($content_path, PATHINFO_EXTENSION));
            $type = "other";
            $path = "";

            $supported_image = ['gif', 'jpg', 'jpeg', 'png', 'bmp'];
            $supported_audio = ['mp3', 'wav', 'wave', 'm4a', 'm4p', 'm4r', 'ogg'];
            $supported_video = ['ogv', 'oga', 'ogx', 'ogm', 'spx', 'opus', 'webm', 'mp4', 'm4b', 'm4v', 'mov', 'qt', 'mkv'];
            $supported_document = ['doc', 'docx', 'xls', 'xlsx', 'pdf', 'ppt', 'pptx', 'txt', 'xml', 'xsl', 'rtf', 'csv'];

            if (in_array($ext, $supported_image)) {
                $type = "image";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_audio)) {
                $type = "audio";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_video)) {
                $type = "video";
                $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
            } elseif (in_array($ext, $supported_document)) {
                $type = "document";
                if ($ext === "pdf") {
                    $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                } else {
                    $urls[] = "$mobitute_content1$course_id/$lesson_id1/$content_id/$content_path";
                }
            }
        } else {
            $urls[] = "";
        }
    }
    error_log("Fetched URLs: " . print_r($urls, true));
    return $urls;
}

function extractTextFromUrl(string $url): string
{
    error_log("Extracting text from URL in function: $url");
    $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    $fileData = file_get_contents($url);
    if ($fileData === false) {
        return "Failed to download content from: $url";
    }
    // $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    error_log("File data: " . print_r($fileData, true));
    $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
    error_log("File saved to: $tempFile");
    file_put_contents($tempFile, $fileData);

    $mimeType = mime_content_type($tempFile);
    $text = '';

    if (isImage($mimeType)) {
        $text = extractTextFromImage($tempFile);
    } elseif (isAudio($mimeType)) {
        // Try to extract extension from the URL
        $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION));

        // If extension is missing, try to guess from MIME type
        if (!$ext || strlen($ext) < 2) {
            // Map common MIME types to extensions
            $mimeMap = [
                'audio/mpeg' => 'mp3',
                'audio/mp3' => 'mp3',
                'audio/mp4' => 'mp4',
                'audio/mpeg' => 'mpeg',
                'audio/mpga' => 'mpga',
                'audio/x-m4a' => 'm4a',
                'audio/wav' => 'wav',
                'audio/webm' => 'webm',
            ];
            $ext = $mimeMap[$mimeType] ?? '';
        }

        $whisperSupported = ['mp3', 'mp4', 'mpeg', 'mpga', 'm4a', 'wav', 'webm'];

        if (in_array($ext, $whisperSupported)) {
            $tempFileWithExt = $tempFile . '.' . $ext;

            // Rename downloaded file to include extension
            if (rename($tempFile, $tempFileWithExt)) {
                $text = transcribeAudio($tempFileWithExt);
                // unlink($tempFileWithExt);
                if (file_exists($tempFileWithExt)) {
                    unlink($tempFileWithExt);
                }
            } else {
                $text = "Failed to prepare the audio file for transcription.";
            }
        } else {
            $text = "Unsupported or undetectable audio format: .$ext";
        }
    } elseif ($mimeType === 'application/pdf') {
        try {
            $parser = new Parser();
            $pdf = $parser->parseFile($tempFile);
            $text = $pdf->getText();
        } catch (Exception $e) {
            $text = "Error parsing PDF: " . $e->getMessage();
        }
    } elseif (isVideo($mimeType)) {
        // Try to extract extension from the URL
        $ext = strtolower(pathinfo(parse_url($url, PHP_URL_PATH), PATHINFO_EXTENSION));

        // If no extension is found, fallback to known MIME type map
        if (!$ext || strlen($ext) < 2) {
            $mimeMap = [
                'video/mp4' => 'mp4',
                'video/webm' => 'webm',
                'video/mpeg' => 'mpeg',
                'audio/mpga' => 'mpga', // Some servers might mislabel audio as video
                'audio/m4a' => 'm4a',
                'audio/mp3' => 'mp3',
                'audio/wav' => 'wav',
            ];
            $ext = $mimeMap[$mimeType] ?? '';
        }

        // Whisper API supported formats
        $whisperSupported = ['mp4', 'webm', 'mpeg', 'mpga', 'm4a', 'mp3', 'wav'];

        if (in_array($ext, $whisperSupported)) {
            // Save with proper extension
            $tempFileWithExt = $tempFile . '.' . $ext;

            if (rename($tempFile, $tempFileWithExt)) {
                // Transcribe
                $text = transcribeAudio($tempFileWithExt);
                unlink($tempFileWithExt);
            } else {
                $text = "Failed to prepare the video/audio file for transcription.";
            }
        } else {
            $text = "Unsupported video/audio format: .$ext";
        }
    } elseif (isText($mimeType)) {
        $text = file_get_contents($tempFile);
    } elseif (isDocOrDocx($mimeType)) {
        $text = extractTextFromDoc($tempFile);
    } else {
        $text = "Unsupported file type: $mimeType";
    }

    if (file_exists($tempFile)) {
        unlink($tempFile);
    }

    // unlink($tempFile);
    return $text;
}


try {

    $urls = fetchCourseContent($allContentIds, $properties, $offering);
    error_log("Fetched course content: " . print_r($urls, true));

    if (is_array($urls) && count($urls) > 0) {
        foreach ($urls as $url) {
            if (empty($url)) continue;

            error_log("Processing URL: $url");

            $fileData = @file_get_contents($url);
            if ($fileData === false) {
                error_log("Failed to download: $url");
                continue;
            }

            $tempFile = tempnam(sys_get_temp_dir(), 'remote_');
            file_put_contents($tempFile, $fileData);

            error_log("Saved file to: $tempFile");
            error_log("File data: " . print_r($fileData, true));

            $text = extractTextFromUrl($tempFile);
            $extractedTexts[] = $text;

            error_log("Extracted text from $url: " . substr($text, 0, 300)); // just the first 300 chars

            $urls = implode("\n\n---\n\n", $extractedTexts);
            file_put_contents("log.txt", $urls);
            $_SESSION['extracted_text'] = $urls;
            file_put_contents("log.txt", $urls);
        }
    }
    $client = new Client();

    if (empty($urls)) {
        echo json_encode(['status' => 'error', 'message' => 'No content to reference.']);
        exit;
    }


    $combinedText = implode("\n", $extractedTexts);

    $maxLength = 900;

    // $systemMessage = "You are an educational assistant. Only answer based on the provided content. "
    //     . "Do not mention content IDs, file names, or URLs. Summarize or describe the material in a human-readable, friendly tone. "
    //     . "If a question is not related to the content, respond with \"I'm here to help with questions based on the course content. Could you ask something related to what we've covered?\"\n\n"
    //     . "Here is the content:\n$urls";

    // $systemMessage = "You are an educational assistant. Only answer based on the provided content. Do not mention content IDs, file names, or URLs. Summarize or describe the material in a human-readable, friendly tone. The summary must be complete and must NOT be cut off mid-sentence. It must fit within $maxLength characters.";

    // $systemMessage = "You are an educational assistant. Summarize the following content in a clear, friendly, and human-readable tone. Do not exceed 950 characters. Ensure the summary is self-contained and does not cut off mid-sentence. Do not list content IDs, filenames, or URLs.";

    // $systemMessage = "You are an educational assistant. You will be given content. Write a short, self-contained summary that includes only the most important points. Do not list everything. The summary must be clear, coherent, and under 950 characters, and say '[END]' at the end. Never cut off mid-sentence or mid-topic.";

    // $systemMessage = "You are an educational assistant. Summarize the most important points from the content below in a friendly tone. " .
    //     "Focus only on the core ideas. The summary must be fully self-contained, under 950 characters, and must never cut off mid-sentence. " .
    //     "End your summary with the tag [END].";

    $systemMessage = "You are an educational assistant. You will be given multiple topics. Write a brief summary that mentions each topic in 1 or 2 short sentences. Do not skip any topic. The full summary must be under 950 characters. Never cut off mid-sentence. End the summary with [END].";


    $response = $client->post('https://api.openai.com/v1/chat/completions', [
        'headers' => [
            'Authorization' => 'Bearer ' . OPENAI_API_KEY,
            'Content-Type' => 'application/json',
        ],
        'json' => [
            'model' => 'gpt-4',
            // 'messages' => [
            //     // ['role' => 'system', 'content' => 'You are given some extracted content. Based on this content, provide key points or notes. Do not add unrelated information. Content: ' . $combinedText],
            //     // ['role' => 'user', 'content' => $userQuestion]

            //     // ['role' => 'system', 'content' => "You are an educational assistant. Only answer based on the provided content. Do not mention content IDs, file names, or URLs. Summarize or describe the material in a human-readable, friendly tone. If a question is not related to the content, respond with \"I'm here to help with questions based on the course content. Could you ask something related to what we've covered?\" Limit your response to approximately 900 characters and ensure the summary is complete and not cut off mid-sentence. Content: $combinedText"]

            // ],

            'messages' => [
                ['role' => 'system', 'content' => $systemMessage . "\n\nContent: " . $combinedText]
            ],

            'temperature' => 0.7,
            // 'max_tokens' => 1024
            'max_tokens' => 500, // Adjusted to allow for longer responses
        ],
        'verify' => false,
    ]);

    $result = json_decode($response->getBody(), true);
    // $chatResponse = $result['choices'][0]['message']['content'] ?? 'No response from AI.';

    // $rawResponse = $result['choices'][0]['message']['content'] ?? 'No response from AI.';

    // // Enforce varchar(1000) safe limit
    // function enforce_varchar_limit($text, $limit = 1000)
    // {
    //     if (strlen($text) <= $limit) return $text;
    //     $truncated = substr($text, 0, $limit - 3); // Reserve for "..."
    //     return preg_replace('/\s+?(\S+)?$/', '', $truncated) . '...';
    // }

    // $chatResponse = enforce_varchar_limit($rawResponse, 1000);

    $rawResponse = $result['choices'][0]['message']['content'] ?? 'No response from AI.';

    function enforce_varchar_limit($text, $limit = 1000)
    {
        if (strlen($text) <= $limit) return $text;
        $truncated = substr($text, 0, $limit - 3); // Reserve space for ...
        return preg_replace('/\s+?(\S+)?$/', '', $truncated) . '...';
    }

    $chatResponse = enforce_varchar_limit($rawResponse, 1000);

    error_log("AI response length: " . strlen($chatResponse));


    echo json_encode([
        'success' => true,
        'notes' => $chatResponse
    ]);
} catch (RequestException $e) {
    echo json_encode([
        'success' => false,
        'message' => 'OpenAI API request failed.',
        'details' => $e->getMessage()
    ]);
    exit;
}
