<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
session_start();
include_once "config/database.php";
include_once "security/session_config.php";
include_once "security/csrf.php";
// connect to database

include_once "config/properties.php";
include_once "resources/EncryptDecrypt.php";
include_once "resources/offering.php";
include_once "resources/manageusers.php";
include_once "resources/survey.php";
include_once "resources/company.php";
include_once "resources/notice.php";
// initialize objects
$offering = new Offering();
$notice = new Notice();
$company = new Company();
$survey = new Survey();
$users = new ManageUsers();

$csrf_token = get_csrf_token();
//    $manageuser= new ManageUsers();

$page = isset($_GET['page']) ? $_GET['page'] : 1; // page is the current page, if there's nothing set, default is page 1

$page_no = 1;
$page_url = "home.php";
$user_id = $_SESSION['uid'];
$website = "";
$stmt = $company->getCustCompanyDetail($_SESSION['uid']);
if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    if ($row['website_link'] != "") {
        $website = $row['website_link'];
    }
}
$offering->user_id = $user_id;
$offering->date = $date;
//     echo $total_rows;
?>
<!DOCTYPE>
<html lang="en">

<head>
    <meta name="csrf-token" content="<?= htmlspecialchars($csrf_token) ?>">
    <?php include "./head.php" ?>
    <title>
        <?php echo _("LB0101"); ?>
    </title>
    <link id="favicon" rel="shortcut icon" type="image/png" href="" />
    <link rel="stylesheet" href="assets/css/home/style.css">
    <style>
        /*//modal*/
        #assessment_modal_ul {
            margin-bottom: 0px !important;
        }

        #assessment_modal_ul li {
            list-style-type: disc;
            margin-left: 3%;
        }
    </style>
</head>

<body>
    <?php include "./menu_primary.php"; ?>
    <?php //include "assets/css/main.php"; ?>
    <?php
    $offering->user_id = $_SESSION['uid'];
    $points = $offering->Sum_completionPoints();
    ?>

    <div class="container pb-90 mb-50">

        <div class="col-md-9 pl-0 clearfix">

            <div class="row">
                <div class="col-md-9 pl-0 pr-0">
                    <div class="items-center px-10 bg-primary-opacity-1 shadow-4 rounded-8">
                        <div class="row justify-between">
                            <div class="col-md-3 col-xs-6">
                                <a href="courses.php?mode=active"
                                    class="infoCard -type-2 text-center -infoCard-hover primary home_card py-5 px-5">
                                    <div class="infoCard__image stoke_primary stoke_svg size-25">
                                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M22 16.7399V4.66994C22 3.46994 21.02 2.57994 19.83 2.67994H19.77C17.67 2.85994 14.48 3.92994 12.7 5.04994L12.53 5.15994C12.24 5.33994 11.76 5.33994 11.47 5.15994L11.22 5.00994C9.44 3.89994 6.26 2.83994 4.16 2.66994C2.97 2.56994 2 3.46994 2 4.65994V16.7399C2 17.6999 2.78 18.5999 3.74 18.7199L4.03 18.7599C6.2 19.0499 9.55 20.1499 11.47 21.1999L11.51 21.2199C11.78 21.3699 12.21 21.3699 12.47 21.2199C14.39 20.1599 17.75 19.0499 19.93 18.7599L20.26 18.7199C21.22 18.5999 22 17.6999 22 16.7399Z"
                                                stroke="#000000" stroke-width="1.5" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path d="M12 5.48999V20.49" stroke="#000000" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M7.75 8.48999H5.5" stroke="#000000" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M8.5 11.49H5.5" stroke="#000000" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    <h5 class="infoCard__title text-24 lh-1 mt-10 mb-0">
                                        <?php echo $offering->activecourses_count_forHome(); ?></h5>
                                    <p class="infoCard__text mt-0 mb-0"><?php echo _("HM0124"); ?></p>
                                </a>
                            </div>

                            <div class="col-md-3 col-xs-6">
                                <a href="courses.php?mode=complete"
                                    class="infoCard -type-2 text-center -infoCard-hover primary home_card py-5 px-5">
                                    <div class="infoCard__image stoke_primary fill_svg size-25">
                                        <svg fill="#000000" width="24" height="24" viewBox="0 0 1920 1920"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M960 1807.059c-467.125 0-847.059-379.934-847.059-847.059 0-467.125 379.934-847.059 847.059-847.059 467.125 0 847.059 379.934 847.059 847.059 0 467.125-379.934 847.059-847.059 847.059M960 0C430.645 0 0 430.645 0 960s430.645 960 960 960 960-430.645 960-960S1489.355 0 960 0M854.344 1157.975 583.059 886.69l-79.85 79.85 351.135 351.133L1454.4 717.617l-79.85-79.85-520.206 520.208Z"
                                                fill-rule="evenodd" />
                                        </svg>
                                    </div>
                                    <h5 class="infoCard__title text-24 lh-1 mt-10 mb-0">
                                        <?php echo $offering->completedcourses_count_forHome(); ?></h5>
                                    <p class="infoCard__text mt-0 mb-0"><?php echo _("HM0125"); ?></p>
                                </a>
                            </div>

                            <div class="col-md-3 col-xs-6">
                                <a href="courses.php?mode=incomplete"
                                    class="infoCard -type-2 text-center -infoCard-hover primary home_card py-5 px-5">
                                    <div class="infoCard__image stoke_primary fill_svg size-25">
                                        <svg width="24" height="24" viewBox="0 0 1024 1024" fill="#000000" class="icon"
                                            version="1.1" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M332 663.2c-9.6 9.6-9.6 25.6 0 35.2s25.6 9.6 35.2 0l349.6-356c9.6-9.6 9.6-25.6 0-35.2s-25.6-9.6-35.2 0L332 663.2z" />
                                            <path
                                                d="M681.6 698.4c9.6 9.6 25.6 9.6 35.2 0s9.6-25.6 0-35.2L367.2 307.2c-9.6-9.6-25.6-9.6-35.2 0s-9.6 25.6 0 35.2l349.6 356z" />
                                            <path
                                                d="M516.8 1014.4c-277.6 0-503.2-225.6-503.2-503.2S239.2 7.2 516.8 7.2s503.2 225.6 503.2 503.2-225.6 504-503.2 504z m0-959.2c-251.2 0-455.2 204.8-455.2 456s204 455.2 455.2 455.2 455.2-204 455.2-455.2-204-456-455.2-456z" />
                                        </svg>
                                    </div>
                                    <h5 class="infoCard__title text-24 lh-1 mt-10 mb-0">
                                        <?php echo $offering->incompletecourses_count_forHome(); ?></h5>
                                    <p class="infoCard__text mt-0 mb-0"><?php echo _("HM0126"); ?></p>
                                </a>
                            </div>

                            <div class="col-md-3 col-xs-6">
                                <a href='javascript:void(0)' onclick='showPoints()'
                                    class="infoCard -type-2 text-center -infoCard-hover primary home_card py-5 px-5">
                                    <div class="infoCard__image stoke_primary fill_svg size-25">
                                        <svg width="24" height="24" viewBox="0 0 1024 1024" fill="#000000" class="icon"
                                            version="1.1" xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M802.4 967.2c-7.2 0-15.2-1.6-21.6-4.8l-258.4-128.8-252.8 140c-18.4 10.4-41.6 5.6-56-9.6-8.8-9.6-12.8-23.2-11.2-36.8l43.2-285.6L33.6 444C20.8 432 16 414.4 21.6 397.6c4.8-16.8 18.4-28.8 36-31.2l285.6-48L464.8 56c7.2-15.2 22.4-25.6 39.2-26.4 17.6-0.8 33.6 8.8 41.6 24l133.6 256.8 287.2 35.2c17.6 2.4 31.2 13.6 36.8 30.4 5.6 16 1.6 34.4-10.4 46.4L790.4 629.6l55.2 284c2.4 12.8-0.8 26.4-8.8 36.8-8.8 10.4-21.6 16.8-34.4 16.8zM520.8 784.8c7.2 0 15.2 1.6 21.6 4.8l255.2 127.2-54.4-280c-3.2-14.4 1.6-29.6 12-40l200-203.2L672 358.4c-14.4-1.6-28-11.2-34.4-24L506.4 81.6 385.6 340c-6.4 13.6-19.2 23.2-33.6 25.6L70.4 412l208 194.4c11.2 10.4 16 24.8 13.6 40L249.6 928l249.6-137.6c7.2-3.2 14.4-4.8 21.6-5.6z" />
                                        </svg>
                                    </div>
                                    <?php
                                    if ($points == "") {
                                        $points = 0;
                                    }
                                    ?>
                                    <h5 class="infoCard__title text-24 lh-1 mt-10 mb-0"><?php echo round($points); ?>
                                    </h5>
                                    <p class="infoCard__text mt-0 mb-0"><?php echo _("HM0134"); ?></p>
                                </a>
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-3 pl-20 pr-0 clearfix home_achievement">
                    <div class="items-center py-0 px-10 bg-primary-opacity-1 shadow-4 rounded-8">
                        <div class="row justify-between">
                            <div class="col-auto">
                                <a href='javascript:void(0)' onclick='showAchievement()'
                                    class="infoCard -type-2 text-center -infoCard-hover primary home_card py-15">
                                    <div class="infoCard__image stoke_primary size-40">
                                        <svg width="40" height="40" viewBox="-0.5 0 25 25" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path
                                                d="M12.005 15.1854C14.4075 15.1854 16.355 13.1842 16.355 10.7154C16.355 8.24673 14.4075 6.24545 12.005 6.24545C9.6026 6.24545 7.65503 8.24673 7.65503 10.7154C7.65503 13.1842 9.6026 15.1854 12.005 15.1854Z"
                                                stroke="#000000" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M12.875 3.52545C13.385 2.59545 14.765 2.97545 14.745 4.04545C14.735 4.85545 15.585 5.35545 16.255 4.94545C17.145 4.39545 18.165 5.43545 17.625 6.35545C17.225 7.04545 17.715 7.92545 18.495 7.90545C19.535 7.88545 19.905 9.30545 18.995 9.82545C18.305 10.2154 18.305 11.2254 18.995 11.6154C19.905 12.1354 19.535 13.5555 18.495 13.5355C17.715 13.5255 17.215 14.3954 17.625 15.0854C18.155 16.0054 17.145 17.0455 16.255 16.4955C15.585 16.0855 14.725 16.5854 14.745 17.3954C14.765 18.4654 13.375 18.8455 12.875 17.9155C12.495 17.2155 11.505 17.2155 11.125 17.9155C10.615 18.8455 9.23499 18.4654 9.25499 17.3954C9.26499 16.5854 8.415 16.0855 7.745 16.4955C6.855 17.0455 5.83499 16.0054 6.37499 15.0854C6.77499 14.3954 6.28499 13.5155 5.50499 13.5355C4.46499 13.5555 4.09499 12.1354 5.00499 11.6154C5.69499 11.2254 5.69499 10.2154 5.00499 9.82545C4.09499 9.30545 4.46499 7.88545 5.50499 7.90545C6.28499 7.91545 6.78499 7.04545 6.37499 6.35545C5.84499 5.43545 6.855 4.39545 7.745 4.94545C8.415 5.35545 9.27499 4.85545 9.25499 4.04545C9.23499 2.97545 10.625 2.59545 11.125 3.52545C11.515 4.22545 12.495 4.22545 12.875 3.52545Z"
                                                stroke="#000000" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M5.86498 18.3254L5.33498 19.2755C5.07498 19.7355 5.57497 20.2455 6.04497 19.9855L7.75498 19.0355C8.10498 18.8555 8.52498 19.0955 8.53498 19.4955L8.57499 21.4855C8.60499 22.0255 9.30499 22.1955 9.57499 21.7355L10.285 20.4555"
                                                stroke="#000000" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                            <path
                                                d="M18.145 18.3354L18.675 19.2755C18.935 19.7355 18.435 20.2455 17.955 19.9855L16.255 19.0355C15.905 18.8555 15.485 19.0955 15.475 19.4955L15.435 21.4855C15.405 22.0255 14.705 22.1955 14.435 21.7355L13.735 20.4555"
                                                stroke="#000000" stroke-miterlimit="10" stroke-linecap="round"
                                                stroke-linejoin="round" />
                                        </svg>
                                    </div>
                                    <p class="infoCard__text mb-0"><?php echo _("HM0101"); ?></p>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row y-gap-30" id="courses"> </div>

            <div class="row justify-center pt-30" id="paging"> </div>
        </div>

        <div class="col-md-3 pl-0">
            <div class="d-flex items-center py-18 px-20 bg-primary-opacity-1 shadow-4 rounded-8">
                <div class="size-70">
                    <img class="object-cover rounded-full size-70" src="<?php echo $filepath ?>" alt="image">
                </div>
                <div class="pl-10">
                    <h5 class="text-17 lh-14 fw-500 mb-0 mt-5"><?php echo $first_name . " " . $ulname ?></h5>
                    <div class="d-flex x-gap-20 y-gap-10 flex-wrap items-center pt-4">
                        <div class="d-flex items-center text-light-1 mt-5">
                            <div class="fa fa-file text-13 mr-5"></div>
                            <a href="summary_report.php"
                                class="text-13 lh-1 underline text-blue-3"><?php echo _("HM0136"); ?></a>
                        </div>
                    </div>
                    <?php
                    //  $stmt = $offering->learning_certficate_display();
                    // $num = $stmt->rowCount();
                    // if ($num > 0) {
                    ?>
                    <div class="d-flex x-gap-20 y-gap-10 flex-wrap items-center pt-4">
                        <div class="d-flex items-center text-light-1 mt-5">
                            <div class="fa fa-certificate text-13 mr-5"></div>
                            <a href="javascript:void(0);" class="text-13 lh-1 underline text-blue-3"
                                onclick="viewCertificate();"><?php echo _("HM0137"); ?></a>
                        </div>
                    </div>
                    <?php //} ?>
                </div>
            </div>

            <div class="bg-white border-light shadow-4 mt-15 rounded-8">
                <?php
                $notice->user_id = $_SESSION['uid'];
                $notice->date = $date;
                $stmt = $notice->getNotices1();
                // count number of retrieved products
                $num = $stmt->rowCount();
                $unread_announcement = $notice->getNotices_unreadcount();
                ?>
                <div class="d-flex justify-between items-center py-0 px-20 bg-primary-opacity-1 py-5 rounded-8">
                    <h2 class="text-17 lh-1 fw-500"><?php echo _("HM0127"); ?></h2>
                    <?php if ($unread_announcement != 0) { ?>
                        <div class="relative size-40 d-flex justify-center items-center rounded-full bg-light-4">
                            <img src="assets/images/icons/announcement.svg" alt="icon" class="size-20">
                            <div class="side-badge">
                                <div
                                    class="size-25 d-flex justify-center items-center rounded-full bg-white -dark-bg-purple-1 border-light">
                                    <span class="text-11 text-black"><?php echo $unread_announcement; ?></span>
                                </div>
                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div class="py-20 px-10">
                    <div class="y-gap-20">
                        <?php
                        if ($num > 0) {
                            // needed for paging
                            $total_rows = $notice->getNotices_count();
                            $i = 0;
                            while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                $i = $i + 1;
                                extract($row);
                                $font_weight = $view_ts == NULL ? "fw-500" : "fw-300";
                                ?>
                                <div class="featureIcon -type-1 <?php if ($i != 1) { ?> border-top-dark <?php } ?>">
                                    <div class="featureIcon__icon bg-primary-opacity-1 size-50">
                                        <img src="assets/images/icons/announcement.svg" alt="icon" class="size-20">
                                    </div>

                                    <div class="featureIcon__content ml-10 md:ml-10">
                                        <a href='announcement.php?<?php echo $notice_board_id ?>'>
                                            <h4 class="text-15 lh-15 fw-500"><?php echo htmlentities($notice_subject); ?></h4>
                                        </a>
                                    </div>
                                </div>

                                <?php
                            }
                        } else {
                            echo "<center>";
                            echo _("AN0501");
                            echo "</center>";
                        }
                        ?>
                    </div>
                </div>
            </div>
            <!--survey-->
            <?php
            $survey->user_id = $_SESSION['uid'];
            $survey->date = $date;
            if ($stmt = $survey->isSurvey()) {
                ?>

                <div class="bg-white border-light shadow-4 mt-15 rounded-8">
                    <div
                        class="d-flex justify-between items-center py-0 px-20 border-bottom-light bg-primary-opacity-1 rounded-8">
                        <h2 class="text-17 lh-1 fw-500"><?php echo _("SY0101"); ?></h2>
                    </div>
                    <div class="py-20 px-10">
                        <div class="y-gap-20">
                            <?php
                            $stmt1 = $survey->getSurveyLat();
                            while ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                                extract($row1);

                                echo "<a href='javascript:void(0)' onclick='showSurvey($survey_publish_id)'>";
                                ?>
                                <div class="featureIcon -type-1">
                                    <div class="featureIcon__icon bg-primary-opacity-1 size-50">
                                        <img src="assets/images/icons/survey.svg" alt="icon" class="size-30">
                                    </div>

                                    <div class="featureIcon__content ml-10 md:ml-10">
                                        <h4 class="text-15 lh-15 fw-500"><?php echo htmlentities($survey_title); ?></h4>
                                    </div>
                                </div>

                                <?php
                                echo "</a>";
                            }
                            ?>


                            <div class="row">
                                <div class="col text-right">
                                    <a href="survey.php" class="text-13 underline text-blue-3 pr-10">More <i
                                            class="fa fa-angle-right"></i></a>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            <?php } ?>
            <div class="bg-white border-light shadow-4 mt-15 rounded-8">
                <div
                    class="d-flex justify-between items-center py-0 px-20 border-bottom-light bg-primary-opacity-1 rounded-8">
                    <h2 class="text-17 lh-1 fw-500"><?php echo _("LG0142"); ?></h2>
                </div>
                <div class="py-20 px-20">
                    <div class="y-gap-20">
                        <p class="mb-0 pb-0"><?php echo _("HM0105"); ?></p>

                        <div class="d-flex items-center">
                            <div class="shrink-0">
                                <img class="size-30" src="assets/images/icons/faq.svg" alt="image">
                            </div>
                            <div class="ml-12">
                                <h4 class="text-15 lh-1 fw-500"><?php echo _("HM0106"); ?> <a href="faq.php"
                                        class="text-blue-3 uppercase" target="_blank"><?php echo _("HM0107"); ?></a>.
                                </h4>
                            </div>
                        </div>

                        <div class="d-flex items-center border-top-dark">
                            <div class="shrink-0">
                                <img class="size-35" src="assets/images/icons/help.svg" alt="image">
                            </div>
                            <div class="ml-12">
                                <h4 class="text-15 lh-1 fw-500"><?php echo _("HM0108"); ?> <a href="forum.php"
                                        class="text-blue-3 uppercase" target="_blank"><?php echo _("HM0109"); ?></a>.
                                </h4>
                            </div>
                        </div>
                        <?php if ($website != null) { ?>
                            <div class="d-flex items-center border-top-dark">
                                <div class="shrink-0">
                                    <img class="size-40" src="assets/images/icons/web.svg" alt="image">
                                </div>
                                <div class="ml-12">
                                    <h4 class="text-15 lh-1 fw-500"><?php echo _("HM0123"); ?> <a
                                            href="<?php echo $website; ?>" class="text-blue-3 uppercase"
                                            target="_blank"><?php echo _("HM0111"); ?></a>.</h4>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>

        </div>

    </div>

    <!--Achievement modal-->
    <div class="modal fade" id="achievement_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex justify-between items-center">
                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("HM0101"); ?></h2>
                        <button class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body bg-primary-opacity-1" id="badge_detail">
                    <div class="clearfix"></div>
                </div>
                <div class="modal-footer">
                    <div class="d-flex justify-center">
                        <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                            data-dismiss="modal"><?php echo _("AS0156") ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Points-->
    <div class="modal fade" id="points_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex justify-between items-center">
                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("HM0129") ?></h2>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body bg-primary-opacity-1" id="points_details"> </div>
                <div class="modal-footer">
                    <div class="d-flex justify-center">
                        <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                            data-dismiss="modal"><?php echo _("AS0156"); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Top 3 Modal-->
    <div class="modal fade" id="top3_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex justify-between items-center">
                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("HM0116"); ?></h2>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body bg-primary-opacity-1" id="rank_detail"> </div>
                <div class="modal-footer">
                    <div class="d-flex justify-center">
                        <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                            data-dismiss="modal"><?php echo _("AS0156"); ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--Instructions for assessment-->
    <div class="modal fade" id="assessment_take_test_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex justify-between items-center">
                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("AS0140"); ?></h2>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body bg-primary-opacity-1 scrollermodal" id="assmt_in"> </div>
                <div class="modal-footer">
                    <div class="d-flex justify-center">
                        <button type="button" class="text-16 button -icon px-50 py-0 bg-color-primary text-white"
                            onclick="proceed();">
                            <?php echo _("CRT3107"); ?>
                        </button>
                        &nbsp;
                        <button type="button" class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                            data-dismiss="modal"><?php echo _("AS0156") ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--learning path certificate modal -->
    <div class="modal fade" id="certificate_modal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <div class="d-flex justify-between items-center">
                        <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("HM0137") ?></h2>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                </div>
                <div class="modal-body bg-primary-opacity-1" id="certificate_detail"
                    style="max-height: 450px; overflow-y: auto;">

                </div>
                <div class="modal-footer">
                    <div class="d-flex justify-center">
                        <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white"
                            data-dismiss="modal"><?php echo _("AS0156") ?></button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php include "./footer_primary.php"; ?>


    <script>
        $("#prev").attr("disabled", "disabled");
        $("#prev").removeClass("pagination__button").addClass("pagination__button-disabled");
        var page = '<?php echo $page; ?>';
        var user = <?php echo $_SESSION['uid']; ?>;
        var page_url = "<?php echo $page_url; ?>";
        //    var page = <?php echo isset($page) ? $page : 1; ?>; // Default to 1 if not set
        //    var user = '<?php echo isset($_SESSION['uid']) ? $_SESSION['uid'] : ''; ?>'; // Escape special characters
        //    var page_url = "<?php echo isset($page_url) ? $page_url : 'home.php'; ?>"; // Default to an empty string

        // window.addEventListener("message", function (event) {
        //     if (event.data === "SESSION_EXPIRED") {
        //         alert("Your session has expired. You will be logged out.");
        //         window.location.href = "logout.php"; // Or login.php
        //     }
        // }, false);


        $.ajax({
            url: 'modules/read_offering_home.php',
            data: { "page": page, "user_id": user },
            type: 'GET',
            cache: false,
            async: false,
            success: function (response) {
                var obj = JSON.parse(response);
                if (obj.html !== "") {
                    $("#courses ").empty();
                    $('#courses ').append(obj.html);
                    if (obj.rows !== 0) {
                        $.ajax({
                            url: 'modules/paging.php',
                            data: { "page": page, "user_id": user, "page_url": page_url, "total_rows": obj.rows, "records_per_page": 8 },
                            type: 'GET',
                            dataType: "html",
                            success: function (response) {
                                if (response !== "") {
                                    $("#paging ").empty();
                                    $('#paging ').append(response);
                                }
                            }
                        });
                    }
                }
            }
        });
    </script>
    <script>
        window.CallParent = function () {
        };
        function showPoints() {
            $.ajax({
                url: "modules/points.php",
                data: {},
                dataType: "html",
                type: 'GET',
                success: function (data) {
                    $('#points_details').html(data);
                    jQuery('#points_modal').modal("show");
                }
            });
        }

        function showAchievement() {
            $.ajax({
                url: "modules/achievements.php",
                data: {},
                dataType: "html",
                type: 'GET',
                success: function (data) {
                    //            alert(data);
                    $('#badge_detail').html(data);
                    jQuery('#achievement_modal').modal("show");
                }
            });
        }

        function showLeaders(id, coursename) {
            $.ajax({
                url: "modules/leader_board.php",
                data: { "id": id, "coursename": coursename },
                dataType: "html",
                type: 'GET',
                success: function (data) {
                    // alert(data);
                    $('#rank_detail').html(data);
                    jQuery('#top3_modal').modal("show");
                }
            });
        }

        function showSurvey(sur_id) {
           const csrf_token = $('meta[name="csrf-token"]').attr('content');
            //const csrf_token = $('meta[name="csrf-token"]').attr('content');
            //const csrf_token = window.csrfToken;
            var width = window.innerWidth;
            var height = window.innerHeight;
            //        window.open('../assessment/quiz_assessment.php?oid=' + oid + '&aid=' + aid, 'newwindow', 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2));
            var winName = 'MySurveyWindow';
            var winURL = 'quiz_survey.php';
            var windowoption = 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2);
            //var windowoption = 'width=' + window.width + ', height=' + window.height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,fullscreen=yes';
            var params = { 'sur_id': sur_id, 'c_pg': "home", 'csrf_token': csrf_token };
            var form = document.createElement("form");
            form.setAttribute("method", "post");
            form.setAttribute("action", winURL);
            form.setAttribute("target", winName);
            for (var i in params) {
                if (params.hasOwnProperty(i)) {
                    var input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = i;
                    input.value = params[i];
                    form.appendChild(input);
                }
            }
            document.body.appendChild(form);
            window.open('', winName, windowoption);
            //window.open('', winName, "fullscreen=yes,width=" + window.width + ",height=" + window.height)
            form.target = winName;
            form.submit();
            document.body.removeChild(form);
        }

        function takeTest(cAttempt, mAttempt, score, pScore, aid, oid, duration, pScore1) {
            if (~~pScore1 == 0) {
                pScore1 = pScore;
            }
            if (~~score >= ~~pScore1) {
                alert("<?php echo _("AS0107") ?>");
            } else if (~~cAttempt > ~~mAttempt) {
                alert("<?php echo _("AS0109") ?>");
            } else {
                var oid = oid;
                var aid = aid;
                $.ajax({
                    url: 'assessment/quiz_check.php',
                    data: { "aid": aid, "oid": oid },
                    dataType: "html",
                    type: 'GET',
                    success: function (data) {
                        var d = data;
                        if (d === 1) {
                            alert("Cannot take the assessment.\n\Either you have exhausted all attempts or passed the assessment.\n\Please go to active courses");
                            window.location = "home.php";
                        } else {
                            var ps = pScore;
                            var ca = cAttempt;
                            var tl = duration;
                            $.ajax({
                                url: "assessment/assmt_modal.php",
                                data: { "oid": oid, "aid": aid, "ps": ps, "ca": ca, "tl": tl },
                                dataType: "html",
                                type: 'GET',
                                success: function (data) {
                                    $('#assmt_in').html(data);
                                    jQuery('#assessment_take_test_modal').modal("show");
                                }
                            });
                        }
                    }
                });
            }
        }
        function proceed() {
            jQuery('#assessment_take_test_modal').modal("hide");
            var oid = $('#oid').val();
            var aid = $('#aid').val();
            //const csrf_token = $('meta[name="csrf-token"]').attr('content');
           const csrf_token = $('meta[name="csrf-token"]').attr('content');
            var width = window.innerWidth;
            var height = window.innerHeight;
            //        window.open('../assessment/quiz_assessment.php?oid=' + oid + '&aid=' + aid, 'newwindow', 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2));
            var winName = 'MyWindow';
            var winURL = 'quiz_assessment.php';
            var windowoption = 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2);
            //var windowoption = 'width=' + window.width + ', height=' + window.height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,fullscreen=yes';
            var params = { 'oid': oid, 'aid': aid, 'csrf_token': csrf_token };
            var form = document.createElement("form");
            form.setAttribute("method", "post");
            form.setAttribute("action", winURL);
            form.setAttribute("target", winName);
            for (var i in params) {
                if (params.hasOwnProperty(i)) {
                    var input = document.createElement('input');
                    input.type = 'hidden';
                    input.name = i;
                    input.value = params[i];
                    form.appendChild(input);
                }
            }
            document.body.appendChild(form);
            window.open('', winName, windowoption);
            //window.open('', winName, "fullscreen=yes,width=" + window.width + ",height=" + window.height)
            form.target = winName;
            form.submit();
            document.body.removeChild(form);
        }
        function viewCertificate() {
            $.ajax({
                url: "modules/certificate_modal.php",
                data: { "mode": "l" },
                dataType: "html",
                type: 'GET',
                success: function (data) {
                    $('#certificate_detail').html(data);
                    jQuery('#certificate_modal').modal("show");
                }
            });
        }
        $('.close, .click').on('click', function (event) {
            event.stopPropagation();
            $('#certificate_modal').modal('hide');
        });
        $('.close, .click').on('click', function (event) {
            event.stopPropagation();
            $('#achievement_modal').modal('hide');
        });

        $('.close, .click').on('click', function (event) {
            event.stopPropagation();
            $('#points_modal').modal('hide');
        });
        $('.close, .click').on('click', function (event) {
            event.stopPropagation();
            $('#assessment_take_test_modal').modal('hide');
        });

        $('.close, .click').on('click', function (event) {
            event.stopPropagation();
            $('#top3_modal').modal('hide');
        });
    </script>
</body>

</html>