<?php
session_start();
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); // Generate a random CSRF token
}
$csrfToken = $_SESSION['csrf_token'];

$nonce = base64_encode(random_bytes(16));
header("Content-Type: text/html; charset=utf-8");
header("Content-Security-Policy: default-src 'self'; style-src 'self' https://cdnjs.cloudflare.com/ https://fonts.googleapis.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; script-src 'self' https://apis.google.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; frame-src 'self' https://www.google.com/recaptcha/; font-src 'self' https://cdnjs.cloudflare.com/ https://fonts.gstatic.com; img-src 'self'; form-action 'self'; object-src 'none'; frame-ancestors 'none'; base-uri 'self';");
header("X-Frame-Options: SAMEORIGIN");

include_once "config/database.php";
?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width,initial-scale=1.0">
        <!-- Styles -->
        <link rel="stylesheet" href="assets/css/login/style.css">
        <link rel="stylesheet" href="assets/css/main.php">
        <link rel="stylesheet" href="assets/css/subs.css">
        <link rel="stylesheet" href="assets/css/bootstrap.min.css">
        <!-- Fonts -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
        <script src="https://www.google.com/recaptcha/api.js" async defer></script>
        <title><?php echo _("LG0131") ?> | K-nest LMS</title>
        <link rel="shortcut icon" href="assets/images/icon_header.png" />
        <style type="text/css" nonce="<?php echo $nonce; ?>">
            .preloader__bg{
                transform: scale(1, 0);
            }
            .masthead__bg{
                border-radius: 0px!important;
                left:0!important;
                right:0!important;
            }
            .bg-image{
                background-image: url(assets/images/bg/login.jpg);
            }
            #error3,#mobile_fun_error{
                display: none;
            }
            .masthead-form__group{
                position:relative!important;
            }
        </style>
    </head>

    <body>
        <!-- preloader start -->
        <div class="preloader js-preloader">
            <div class="preloader__bg"></div>
        </div>
        <section data-anim-wrap="" class="masthead -type-2 animated">
            <div class="masthead__bg">
                <div class="bg-image js-lazy loaded" data-ll-status="loaded"></div>
            </div>

            <div class="">
                <div class="row">
                    <div class="col-md-6 left_page">
                        <div class="masthead__content">
                            <h1 data-anim-child="slide-up delay-3" class="masthead__title text-white mt-10 is-in-view">
                                Transform the way you learn with our all-in-one solution.
                            </h1>
                            <div data-anim-child="slide-up delay-2"
                                 class="masthead__subtitle fw-500 text-color-secondary text-20 lh-15 is-in-view">
                                <i>A simple, yet eloquent learning platform built for you!</i>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 right_page">
                        <div data-anim-child="slide-up delay-6" class="masthead-form is-in-view">
                            <h4 class="masthead-form__title text-center text-20 lh-15 fw-500 mb-20 uppercase">
                                <?php echo _("LG0131") ?>
                            </h4>
                            <h6><?php echo _("LG0132") ?></h6>

                            <form method="post">
                                <div class="masthead-form__group mt-20">
                                    <label><?php echo _("LG0133") ?></label>
                                    <input type="text" placeholder="<?php echo _("LG0140") ?>" type="text" required id="mobile_fun">
                                    <span class="text-red-1" id="mobile_fun_error"><?php echo _("LG0509") ?></span>
                                </div>

                                <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $csrfToken; ?>">

                                <div class="masthead-form__group mt-20">
                                    <div class="g-recaptcha" data-sitekey="6LePCPoUAAAAAIXZz4Z1vKyuCxZ01mG1XhlMY4Ig"></div>
                                    <span class="text-red-1" id="error3"></span>
                                </div>

                                <div class="d-flex x-gap-20 items-center justify-between pt-20">
                                    <div>
                                        <button class="button -sm px-24 py-20 text-14 bg-color-primary text-white uppercase" type="button" name="submit" id="forgotun">
                                            <i class="fa fa-spinner fa-spin" id="small_loader4"></i><?php echo _("LG0147"); ?>
                                        </button>
                                    </div>
                                    <div class="text-16">
                                        Back to <a href="index.php" class="text-color-primary"><u><?php echo _("LG0126") ?></u></a>
                                    </div>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <div class="login_page_footer bg-color-secondary">
            <footer class="footer -type-5">
                <div class="container">
                    <div class="pt-30">
                        <div class="row justify-center text-center">
                            <div class="col-auto">
                                <div class="footer-footer__copyright text-center h-100 text-white">
                                    &#169; Copyright 2023. Powered by &nbsp;<a href="https://knestlms.com/" target="_blank" class="text-color-primary footer_company_link">K-nest LMS</a>. All Rights Reserved By
                                    &nbsp;<a href="https://4edgeit.com/" target="_blank" class="text-color-primary  footer_company_link"> 4Edge IT Solutions.</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </footer>
        </div>

        <script src="assets/js/jquery-3.6.3.min.js"></script>
        <script src="assets/js/bootstrap.min.js"></script>
        <script src="assets/js/vendors.js"></script>
        <script src="assets/js/main.js"></script>
        <script nonce="<?php echo $nonce; ?>">
            $('#small_loader4').hide();
            $(document).on('keydown', function (e) {
                if (e.keyCode === 13) {
                    e.preventDefault();
                    forgotun();
                }
            });
            $('#forgotun').click(function () {
                var mobile = $("#mobile_fun").val();
                mobile = mobile.trim();
                var csrf_token = $("#csrf_token").val();
                var error = false;
                $('#error3').css({"display": "none"});
                $('#error3').html("");

                if (mobile == "") {
                    error = true;
                    var error_msg = "";
                    $('#mobile_fun_error').css({"display": "block"});
                } else {
                    $('#mobile_fun_error').css({"display": "none"});
                }
                if (!error) {
                    $('#mobile_fun_error').hide();
                    $('#small_loader4').show();
                    $.post("modules/forgotpassword.php", {
                        mode: 'username',
                        mobile: mobile,
                        csrf_token: csrf_token,
                        captcha: grecaptcha.getResponse()
                    }, function (data, status) {
                        grecaptcha.reset();
                        $('#error3').hide();
                        $('#small_loader4').hide();
                        data = $.trim(data);
                        data = JSON.parse(data);
                        if (data.result1 === "failure") {
                            error_msg = data.result2;
                            $('#error3').css({"display": "block"});
                            $('#error3').html(error_msg);
                        } else if (data.result1 === "non_ecom") {
                            error_msg = data.result2;
                            $('#error3').css({"display": "block"});
                            $('#error3').html(error_msg);
                        }
                    });
                }
            });
        </script>
    </body>

</html>