<?php
session_start();

$nonce = base64_encode(random_bytes(16));
header("Content-Type: text/html; charset=utf-8");
header("content-security-policy: default-src 'self'; style-src 'self' https://cdnjs.cloudflare.com/ 'nonce-$nonce'; script-src 'self' 'nonce-$nonce'; frame-src 'self'; font-src 'self' https://cdnjs.cloudflare.com/; img-src 'self'; form-action 'self'; object-src 'none'; frame-ancestors 'none'; sandbox allow-forms allow-same-origin allow-scripts; base-uri 'self';");
header("X-Frame-Options: SAMEORIGIN");
include 'config/database.php';
include_once "security/session_config.php";
// connect to database

include_once 'config/properties.php';
include_once "resources/manageusers.php";
include_once "resources/EncryptDecrypt.php";

$users = new ManageUsers();

$page_no = 8;
?>
<!DOCTYPE>
<html lang="en">
    <head>
        <?php include "./head.php" ?>
        <title>
            <?php echo _("HP0101"); ?>
        </title>
        <link rel="stylesheet" href="assets/css/faq/style.css">
        <style type="text/css" nonce="<?php echo $nonce; ?>">
            .preloader__bg{
                transform: scale(1, 0);
            }
        </style>
    </head>
    <body>
        <?php if (isset($_SESSION['uid'])) { ?>
            <?php include "./menu_primary.php"; ?>
        <?php } else { ?>
        <!-- preloader start -->
        <div class="preloader js-preloader">
            <div class="preloader__bg"></div>
        </div>
        <?php } ?>
        <div class="container py-30 x-gap-50 mt-20 bg-primary-opacity-1 rounded-16 mb-50">
            <div class="row justify-center text-center">
                <div class="col-xl-11 col-lg-12 col-md-12">

                    <div class="sectionTitle ">
                        <h2 class="sectionTitle__title "><?php echo _("HP0101") ?></h2>
                        <p class="sectionTitle__text "><?php echo _("INF0103") ?></p>
                    </div>

                    <div class="row justify-center text-center">
                        <div class="col-xl-6 col-lg-8">
                            <div class="form-single-field -help">
                                <input type="text" id="myInput" placeholder="Enter a question, topic or keyword">
                            </div>
                        </div>
                    </div>

                    <div class="accordion -block text-left pt-30 lg:pt-20 js-accordion">
                        <?php if (isset($_SESSION['uid'])) { ?>
                            <div class="accordion__item bg-white is-active">
                                <div class="accordion__button">
                                    <div class="accordion__icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-plus icon">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-minus icon">
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                    </div>
                                    <span class="text-17 fw-500 text-dark-1">General LMS Related</span>
                                </div>


                                <div class="accordion__content">
                                    <div class="accordion__content__inner">
                                        <ul>
                                            <li class="bg-light-10 px-10 py-10 rounded-8">
                                                <h3 class="text-16 fw-500 mt-5">What does LMS mean?</h3>
                                                <p class="text-12 lh-15 mt-10">LMS is a learning platform. It is a LMS (Learning
                                                    Management
                                                    System) that works on desktop and browser supported devices like Android
                                                    phone, IPhone, etc. One can go through training courses, track progress,
                                                    take assessment, discuss subject matters among many other activities.</p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">How are the data shown on home page important to
                                                    me?</h3>
                                                <p class="text-12 lh-15 mt-10">The home page gives a summary of your activity on
                                                    LMS.It gives
                                                    count of active, completed and incomplete courses, grades you have achieved,
                                                    etc.You can know your progress in each of the assigned courses which are
                                                    currently running.It also contains the leader board showing top 3 performers
                                                    in each of the open courses,which will inspire one to achieve higher score
                                                    and improve overall learning effectiveness.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What is Discussion Forum?</h3>
                                                <p class="text-12 lh-15 mt-10">It is a forum to discuss question & answers on
                                                    various topics
                                                    available in the LMS. Anybody who has LMS access can put the question and
                                                    can answer any question. You can post your question in the Discussion Forum
                                                    by selecting appropriate topic in the list. Also, please make a note of
                                                    Discussion Forum Rules shown there.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">Can I put the message on Announcements?</h3>
                                                <p cclass="text-12 lh-15 mt-10">No. Only LMS administrators can put the message
                                                    on
                                                    announcements.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What is the purpose of reference material?</h3>
                                                <p class="text-12 lh-15 mt-10">Reference materials are for sharing documents
                                                    such as company
                                                    manuals, standards, guidelines, etc. This is set by the administrator for
                                                    all LMS users or specific groups within LMS for reference
                                                </p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                        <div class="accordion__item bg-white">
                            <div class="accordion__button">
                                <div class="accordion__icon">
                                    <svg width="24" height="24" viewBox="0 0 24 24"
                                         fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                         stroke-linejoin="round" class="feather feather-plus icon">
                                    <line x1="12" y1="5" x2="12" y2="19"></line>
                                    <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                    <svg width="24" height="24" viewBox="0 0 24 24"
                                         fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                         stroke-linejoin="round" class="feather feather-minus icon">
                                    <line x1="5" y1="12" x2="19" y2="12"></line>
                                    </svg>
                                </div>
                                <span class="text-17 fw-500 text-dark-1">Login Related</span>
                            </div>

                            <div class="accordion__content">
                                <div class="accordion__content__inner">
                                    <ul>
                                        <li class="bg-light-10 px-10 py-10 rounded-8">
                                            <h3 class="text-16 fw-500 mt-5">How do I get registered in LMS?</h3>
                                            <p class="mt-10">LMS administrator can register you to LMS and assign courses to
                                                you.
                                            </p>
                                        </li>
                                        <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                            <h3 class="text-16 fw-500 mt-5">How do I know if I am registered in LMS?</h3>
                                            <p class="mt-10">When you are registered in LMS, you will receive an email
                                                and/or SMS with your user id and OTP to login.
                                            </p>
                                        </li>
                                        <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                            <h3 class="text-16 fw-500 mt-5">Which mobile number will receive the OTP?</h3>
                                            <p class="mt-10">The mobile number entered by administrator while registering
                                                you to LMS will receive the OTP.
                                            </p>
                                        </li>
                                        <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                            <h3 class="text-16 fw-500 mt-5">How do I login if I forget my LMS password?</h3>
                                            <p class="mt-10">Select on ‘Forgot Password’ link on login screen. Follow the
                                                instructions given to reset your password and then you can login.
                                            </p>
                                        </li>
                                        <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                            <h3 class="text-16 fw-500 mt-5">I am not receiving OTP SMS. What should I do?
                                            </h3>
                                            <p class="mt-10">Firstly, make sure that your registered mobile number is same
                                                as the one where you are expecting the OTP. Contact LMS administrator for
                                                further assistance.
                                            </p>
                                        </li>
                                        <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                            <h3 class="text-16 fw-500 mt-5">Can I set/change my profile photo?</h3>
                                            <p class="mt-10">Yes, click on your user id on the top right-hand side of the
                                                LMS page and select Profile -> Photo Edit and select an appropriately sized
                                                image.
                                            </p>
                                        </li>
                                    </ul>

                                </div>
                            </div>
                        </div>
                        <?php if (isset($_SESSION['uid'])) { ?>
                            <div class="accordion__item bg-white">
                                <div class="accordion__button">
                                    <div class="accordion__icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-plus icon">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-minus icon">
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                    </div>
                                    <span class="text-17 fw-500 text-dark-1">Course Related</span>
                                </div>

                                <div class="accordion__content">
                                    <div class="accordion__content__inner">
                                        <ul>
                                            <li class="bg-light-10 px-10 py-10 rounded-8">
                                                <h3 class="text-16 fw-500 mt-5">How do I know when I am assigned to a Course?
                                                </h3>
                                                <p class="mt-10">You will receive notification via SMS and/or email.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">Where can I see the courses currently assigned
                                                    to me?</h3>
                                                <p class="mt-10">You can see list of all currently assigned courses on home page
                                                    and also on Courses -> Active Courses page.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">How do I start learning a course assigned to me?
                                                </h3>
                                                <p class="mt-10">Go to Home Screen -> Select your course. Or alternatively, go
                                                    to Courses Menu ->Active courses-> Select your course. When you select the
                                                    course, under the tab “Course Content” you will see the list of lesson(s)
                                                    and content(s) under each lesson. On clicking view/download for specific
                                                    content, content gets opened in LMS player. Optionally you can download
                                                    content from the LMS player.
                                                    You can either go through each of the contents one by one or you can
                                                    navigate through content by selecting first content.Note that SCORM or
                                                    embedded YouTube videos can only be viewed and download option will not be
                                                    available.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What is purpose of check box ‘Mark as complete’
                                                    for the content in content navigation page?</h3>
                                                <p class="mt-10">Once you have gone through the entire content, you can tick the
                                                    “Mark as complete”check box. This would indicate, you have gone through the
                                                    content completely. For scorm content, this will be read only and will be
                                                    ticked automatically, when you complete the scorm content.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">How does %ge progress is calculated for each of
                                                    the active courses?</h3>
                                                <p class="mt-10">It is cumulative %ge completion of all the individual contents
                                                    under the course
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What does “Completed Courses” contain?</h3>
                                                <p class="mt-10">It contains list of all courses where you have met the
                                                    completion criteria.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What does “Incomplete Courses” contain?</h3>
                                                <p class="mt-10">It contains list of all the courses where you have not met the
                                                    completion criteria.
                                                </p>
                                            </li>
                                        </ul>

                                    </div>
                                </div>
                            </div>

                            <div class="accordion__item bg-white">
                                <div class="accordion__button">
                                    <div class="accordion__icon">
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-plus icon">
                                        <line x1="12" y1="5" x2="12" y2="19"></line>
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                        <svg width="24" height="24" viewBox="0 0 24 24"
                                             fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round"
                                             stroke-linejoin="round" class="feather feather-minus icon">
                                        <line x1="5" y1="12" x2="19" y2="12"></line>
                                        </svg>
                                    </div>
                                    <span class="text-17 fw-500 text-dark-1">Assessment Related</span>
                                </div>

                                <div class="accordion__content">
                                    <div class="accordion__content__inner">
                                        <ul>
                                            <li class="bg-light-10 px-10 py-10 rounded-8">
                                                <h3 class="text-16 fw-500 mt-5">How do I know if there is an assessment attached
                                                    to a course?</h3>
                                                <p class="mt-10">If there is an assessment attached to a course, there will be
                                                    separate “Assessment” tab under course detail page. In assessment tab, you
                                                    can click on “TAKE TEST”, which will take you to the assessment.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">Can I take the assessment directly without going
                                                    through the course?</h3>
                                                <p class="mt-10">While it is technically possible, it is advised to go through
                                                    the course before taking the assessment. Assessment questions are based on
                                                    the course contents and admin would have set limited number of attempts.
                                                    Therefore, you will lose an attempt in case you do not achieveminimum
                                                    passing score set for that assessment.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What happens if I fail the assessment?</h3>
                                                <p class="mt-10">You can retake the assessment provided you have few attempts
                                                    remaining. Maximum number of attempts is set by the training administrator
                                                    and visible on the assessment tab.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What happens when assessment times out?</h3>
                                                <p class="mt-10">When an assessment times out, score will be calculated for the
                                                    questions already answered till then. When assessment is nearing time out,
                                                    timer on assessment screen will turn red and will start blinking.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">I have exhausted all the attempts and result
                                                    shows fail. What do I do next?</h3>
                                                <h3 class="text-16 fw-500 mt-5">Can I go through the completed or failed course
                                                    content again?</h3>
                                                <p class="mt-10">You may contact the training administrator or person in-charge
                                                    for training to offer the course to you again so that you can reattempt the
                                                    assessment. However, you can still go through the contents from that course
                                                    which will get listed under “incomplete courses”.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">I am unable to take the assessment. “TAKE TEST”
                                                    is disabled.</h3>
                                                <p class="mt-10">In this case, assessment has a dependency on contents. That
                                                    means, assessment gets enabled only after all the contents are gone through
                                                    and marked as completed. This is set by training administrator.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What is the benefit of coaching report under
                                                    competed courses page?</h3>
                                                <p class="mt-10">Coaching report shows the evaluation of the assessment. You
                                                    will know the questions you have answered correctly and also the correct
                                                    answers for the questions you answered wrongly.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">I have completed the course with result as
                                                    “Pass”. Will I get the certificate for the same?</h3>
                                                <p class="mt-10">You will see this option only if training administrator has set
                                                    a certificate for that course. Certificate can be viewed and downloaded by
                                                    clicking on “CERTIFICATE” under completed courses page for the particular
                                                    course.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">In the certificate my grade shows as “First
                                                    class”. How are such grades set?</h3>
                                                <p class="mt-10">Certificate grading is set by training administrator. Score cut
                                                    off for the grades are decided by the person(s) in charge of the course.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">What is Check Your Understanding (CYU)?</h3>
                                                <p class="mt-10">Purpose of “Check Your Understanding” is to validate your
                                                    understanding on the topics covered so far. There is no score associated
                                                    with it. You will see this as the last item inside a lesson with a set of
                                                    objective type of questions.
                                                </p>
                                            </li>
                                            <li class="bg-light-10 px-10 py-10 rounded-8 mt-5">
                                                <h3 class="text-16 fw-500 mt-5">On submission of assessment, it shows result as
                                                    Pass and no score is shown. Any reason for that?</h3>
                                                <p class="mt-10">LMS administrator has set the course with “show score at the
                                                    end of assessment” flag switched off for this course.
                                                </p>
                                            </li>
                                        </ul>

                                    </div>
                                </div>
                            </div>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
        <?php if (!isset($_SESSION['uid'])) { ?>
            <div class="d-flex justify-center pt-30 pb-60">
                <a href="index.php" id="login_page" class="text-blue-3 text-17 fw-500"><u>Back to Login</u></a></div>
                    <?php } ?>
                    <?php
                    if (isset($_SESSION['uid'])) {
                        include "./footer_primary.php";
                    } else {
                        include "./footer_secondary.php";
                    }
                    ?>
        <script type='text/javascript' src="assets/js/jquery.highlight.js"></script>
        <script nonce="<?php echo $nonce; ?>">
            document.addEventListener("DOMContentLoaded", function () {
                //Expand first tab open on page load
                var content = document.getElementsByClassName('accordion__content');
                content[0].style.maxHeight = content[0].scrollHeight + "px";
            });
            $(document).ready(function () {
                $('#myInput').keyup(function () {
                    var text = $(this).val();
                    $('.accordion__item').each(function () {
                        $(this).unhighlight();
                        $(this).highlight(text);
                    });
                });
                $.expr[":"].contains = $.expr.createPseudo(function (arg) {
                    return function (elem) {
                        return $(elem).text().toUpperCase().indexOf(arg.toUpperCase()) >= 0;
                    };
                });
               
            });

        </script>
    </body>
</html>


