<?php
session_start();
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32)); // Generate a random CSRF token
}
$csrfToken = $_SESSION['csrf_token'];

$nonce = base64_encode(random_bytes(16));
header("Content-Type: text/html; charset=utf-8");
header("Content-Security-Policy: default-src 'self'; style-src 'self' https://cdnjs.cloudflare.com/ https://fonts.googleapis.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; script-src 'self' https://apis.google.com https://www.google.com/recaptcha/ https://www.gstatic.com/recaptcha/ 'nonce-$nonce'; frame-src 'self' https://www.google.com/recaptcha/; font-src 'self' https://cdnjs.cloudflare.com/ https://fonts.gstatic.com; img-src 'self'; form-action 'self'; object-src 'none'; frame-ancestors 'none'; base-uri 'self';");
header("X-Frame-Options: SAMEORIGIN");

// include objects
include_once "config/database.php";
include_once "resources/EncryptDecrypt.php";
include_once 'config/properties.php';
include_once "resources/offering.php";

if (isset($_SESSION['uid'])) {
    echo '<script>window.location="home.php";</script>';
}

$sanitized_input = "";
$password = "";
if (isset($_GET['username'])) {
    $username = $_GET['username']; // Assume this contains untrusted user input
    if ($username == 'guest') {
        $password = "Guest123";
    } else if ($username == 'visitor') {
        $password = "Visitor123";
    }
    $sanitized_input = htmlspecialchars($username, ENT_QUOTES, 'UTF-8');
}
?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width,initial-scale=1.0">
    <!-- Styles -->
    <link rel="stylesheet" href="assets/deoc/style-deoc.css">
    <link rel="stylesheet" href="assets/css/main.php">
    <link rel="stylesheet" href="assets/css/subs.css">
    <link rel=" stylesheet" href="assets/css/bootstrap.min.css">
    <!-- Fonts -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
    <title>Login | K-nest LMS</title>
    <link rel="shortcut icon" href="assets/images/icon_header.png" />
    <style type="text/css" nonce="<?php echo $nonce; ?>">
        :root {
            --font-primary: Verdana !important;
        }

        body {
            font-family: Verdana !important;
        }

        .preloader__bg {
            transform: scale(1, 0);
        }

        .masthead__bg {
            border-radius: 0px !important;
            left: 0 !important;
            right: 0 !important;
        }

        .bg-image1 {
            background-size: contain;
            background-repeat: no-repeat;
            background-position: 10% 80%;
            width: 100%;
            height: 100%;
            background-image: url(assets/deoc/tree_img.png);
        }

        #username_error,
        #password_error {
            display: none;
        }

        .masthead-form__group {
            position: relative !important;
        }

        .login-form {
            height: 100vh;
            padding-top: 10px;
            padding-bottom: 10px;
        }

        .masthead.-type-2 .masthead__bg::after {
            background-color: transparent !important; 
        }

        #login {
            width: 100%;
        }

        .button.bg-color-primary:hover {
            background-color: var(--color-primary) !important;
            color: white !important;
        }

        .password_toggle {
            margin-top: 18px !important;
        }

        #img_logo {
            width: 65%;
        }

        @media (min-width:1800px) {
            #captcha {
                transform: scale(1.68);
                -webkit-transform: scale(1.68);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 80px;
            }
        }

        @media (min-width:1600px) and (max-width:1800px) {
            #captcha {
                transform: scale(1.54);
                -webkit-transform: scale(1.54);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 70px;
            }
        }

        @media (min-width:1400px) and (max-width:1600px) {
            #captcha {
                transform: scale(1.38);
                -webkit-transform: scale(1.38);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 60px;
            }
        }

        @media (min-width:1300px) and (max-width:1400px) {
            #captcha {
                transform: scale(1.23);
                -webkit-transform: scale(1.23);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 50px;
            }
        }

        @media (min-width:1200px) and (max-width:1300px) {
            #captcha {
                transform: scale(1.04);
                -webkit-transform: scale(1.04);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 40px;
            }
        }

        @media (max-width:1200px) {
            #captcha {
                transform: scale(1.04);
                -webkit-transform: scale(1.04);
                transform-origin: 0 0;
                -webkit-transform-origin: 0 0;
            }

            .ch_mtop {
                margin-top: 40px;
            }
        }

        input {
            height: 50px;
            font-size: 18px;
        }

        .main_text {
            line-height: 2;
        }
    </style>
</head>

<body>
    <div class="preloader js-preloader">
        <div class="preloader__bg"></div>
    </div>
    <section data-anim-wrap="" class="masthead -type-2 animated">
        <div class="masthead__bg">
            <div class="bg-image1 js-lazy loaded" data-ll-status="loaded"></div>
        </div>

        <div class="">
            <div class="row justify-center" id="row">
                <div class="col-md-8 left_page">
                    <div class="masthead__content">
                    </div>
                </div>

                <div class="col-md-4 login-form">
                    <div data-anim-child="slide-up delay-6" class="masthead-form is-in-view pt-0 px-15">
                        <div class="d-flex x-gap-20 items-center justify-center">
                            <img src="assets/deoc/logo.jpg" id="img_logo">
                        </div>
                        <form method="post">
                            <div class="masthead-form__group mt-10">
                                <input type="text" placeholder="Your Mobile No / Email Id / Username" id="username"
                                    value="<?php echo $sanitized_input; ?>" required>
                                <span class="text-red-1" id="username_error">
                                    <?php echo _("LG0501") ?>
                                </span>
                            </div>

                            <div class="masthead-form__group mt-30">
                                <input type="password" placeholder="Your Password" required id="password"
                                    autocomplete="on" value="<?php echo $password; ?>">
                                <i class="fa fa-eye password_toggle togglePassword" toggle="#password"></i>
                                <span class="text-red-1" id="password_error">
                                    <?php echo _("LG0502") ?>
                                </span>
                            </div>

                            <div class="masthead-form__group mt-30">
                                <div class="g-recaptcha" data-sitekey="6LePCPoUAAAAAIXZz4Z1vKyuCxZ01mG1XhlMY4Ig"
                                    id="captcha"></div>
                            </div>

                            <input type="hidden" name="csrf_token" id="csrf_token" value="<?php echo $csrfToken; ?>">
                            <div class="ch_mtop">
                                <span class="text-red-1 pb-10" id="error"></span>
                                <button type="button" id="login" name="submit"
                                    class="button -sm px-24 py-20 text-18 bg-black text-white uppercase">
                                    <b>
                                        <?php echo _("LG0126") ?>
                                    </b>&nbsp;
                                    <i class="fa fa-spinner fa-spin" id="small_loader"></i>
                                </button>
                            </div>
                            <p class="mt-30 px-5 py-5 text-white justify-between bg-black text-18 rounded-8 main_text" align="justify">
                                DEOC, established in 2007, provides Consulting, Research and Training services to
                                corporates, educational institutions, industry bodies, development organizations and the
                                Government in creating an inclusive environment.<br />
                            </p>
                            <div class="d-flex justify-between mt-25" id="bottom-button">
                                <button class="text-14 w-1/1 text-black border-dark-1-lg text-18 rounded-8 py-5" id="about_comp">Know More</button>
                                <button class="text-14 w-1/1 text-black border-dark-1-lg text-18 rounded-8 py-5 ml-5" id="contact_comp">Contact Us</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script src="assets/js/jquery-3.6.3.min.js"></script>
    <script src="assets/js/bootstrap.min.js"></script>
    <script src="assets/js/vendors.js"></script>
    <script src="assets/js/main.js"></script>
    <script nonce="<?php echo $nonce; ?>">
        $('#small_loader').hide();
        $(document).bind('keypress', function (e) {
            if (e.keyCode === 13) {
                login();
            }
        });
        $('#about_comp').click(function () {
            window.open('https://deoc.in/about-us/', '_blank');
        });
        $('#contact_comp').click(function () {
            window.open('https://deoc.in/contact-us/', '_blank');
        });
        $('#login').click(function () {
            var error_msg = "";
            $('#error').css({ "display": "none" });
            $('#error').html("");

            var username = $("#username").val();
            username = username.trim();
            var password = $("#password").val();
            var csrf_token = $("#csrf_token").val();
            var submit = true;
            if (username == "") {
                $('#username_error').css({ "display": "block" });
                submit = false;
            } else {
                $('#username_error').hide();
            }
            if (password == "") {
                $('#password_error').css({ "display": "block" });
                submit = false;
            } else {
                $('#password_error').hide();
            }
            if (submit) {
                $('#small_loader').show();
                $.post("modules/login.php", {
                    username: username,
                    password: password,
                    csrf_token: csrf_token,
                    captcha: grecaptcha.getResponse()
                },
                    function (data, status, json) {
                        grecaptcha.reset();
                        $('#small_loader').hide();
                        data = $.trim(data);
                        data = JSON.parse(data);
                        if (data.result1 === "error") {
                            error_msg = data.result2;
                            $('#error').css({ "display": "block" });
                            $('#error').html(error_msg);
                        } else {
                            $('#error').css({ "display": "none" });
                            $('#error').html("");
                            window.location.href = data.result1;
                        }
                    }
                );
            }
        });
        $('#username').keypress(function (e) {
            var key = e.which;
            if (key == 13) {
                login();
                return false;
            }
        });
        $('#password').keypress(function (e) {
            var key = e.which;
            if (key == 13) {
                login();
                return false;
            }
        });
        $(".togglePassword").unbind('click').bind('click', function (e) {
            $(this).toggleClass("fa-eye fa-eye-slash");
            var input = $($(this).attr("toggle"));
            if (input.attr("type") == "password") {
                input.attr("type", "text");
            } else {
                input.attr("type", "password");
            }
        });
    </script>
</body>

</html>