<?php
/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
// start session
    session_start();
    // connect to database
    include "config/database.php";
    include_once "security/session_config.php";
    include_once "security/csrf.php";
    
    include_once "config/properties.php";
    include_once "resources/offering.php";
    include_once "resources/EncryptDecrypt.php";
    include_once "resources/manageusers.php";
   
    $csrf_token=get_csrf_token();


    // initialize objects
    $offering = new Offering();
    $users = new ManageUsers();

    // set page title
    $page_no = 3;
    $user_id = $_SESSION['uid'];
    $offering_id = $_GET['offering'];
    $lesson_content_count = 0;
    $score_flag = "";
    $total_inst = 0;
    $launchContent = "";
    $launchAssessment = "";
    ?>
    <!DOCTYPE html>
    <html lang="en">
        <head>
            <meta name="csrf-token" content="<?= htmlspecialchars($csrf_token) ?>">
            <?php include "./head.php" ?>
            <title>
                <?php echo _("CRT0113"); ?>
            </title>
            <link id="favicon" rel="shortcut icon" type="image/png" href="" />
            <link rel="stylesheet" href="assets/css/course/view.css">
            <style>
                .page-header {
                    margin: 0px !important;
                }
                #hidden_div{
                    display: none;
                }
                @media screen {
                    #printSection {
                        display: none;
                    }
                }
                @media print {
                    body * {
                        visibility:hidden;
                    }
                    section {
                        display: none;
                    }
                    #printSection, #printSection * {
                        visibility:visible;
                    }
                    #printSection {
                        position:absolute;
                        left:0;
                        top:0;
                    }
                    #hidden_div {
                        display: block;
                    }
                    table {
                        border: solid #000 !important;
                        border-width: 1px 0 0 1px !important;
                    }
                    th, td {
                        border: solid #000 !important;
                        border-width: 0 1px 1px 0 !important;
                    }
                }
            </style>
        </head>
        <body>
            <main>
                <!-- Fixed navbar -->
                <?php include "./menu_primary.php"; ?>

                <div class="content-wrapper js-content-wrapper">
                    <?php
                    $offering->offering_id = $offering_id;
                    $offering->user_id = $_SESSION['uid'];

                    echo "<input type='hidden' id='user' value='" . $user_id . "'>";
                    echo "<input type='hidden' id='offer' value='" . $offering_id . "'>";

                    $stmt_course_assigned = $offering->checkCourseAssigned();
                    if ($stmt_course_assigned->rowCount() > 0) {
                        ?>
                        <section class="page-header -type-5 bg-color-primary">
                            <?php
                            $stmt = $offering->offering_display();
                            if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                extract($row);
                                $media_path1 = $media_path;
                                $score_flag = $score_flag;
                                echo "<input type='hidden' id='offering_type' value='" . $offering_type . "'>";
                                ?>
                                <div class="container px-0">
                                    <div class="page-header__content pt-0 pb-5">
                                        <div class="row y-gap-30 justify-between">
                                            <div class="col-md-6 col-xl-6 col-lg-6 pl-5">

                                                <div data-anim="slide-up delay-1" class="is-in-view">
                                                    <h2 class="text-24 lh-12 text-white mt-5 pr-60 lg:pr-0"><?php echo htmlentities($course_name); ?></h2>
                                                </div>

                                                <div class="mt-10">
                                                    <?php if ($offering_type == Null) { ?>
                                                        <!--duration-->
                                                        <div class="d-flex justify-between py-5 border-bottom-light-2">
                                                            <div class="d-flex items-center text-white">
                                                                <div class="icon-video-file"></div>
                                                                <div class="ml-10"><i class="fa fa-clock-o"></i> <?php echo _("CRT1104"); ?></div>
                                                            </div>
                                                            <div class="text-white"><?php echo $course_duration; ?> Hours</div>
                                                        </div>
                                                        <!--effort-->
                                                        <div class="d-flex justify-between py-5 border-bottom-light-2">
                                                            <div class="d-flex items-center text-white">
                                                                <div class="icon-puzzle"></div>
                                                                <div class="ml-10"><i class="fa fa-tachometer"></i> <?php echo _("CRT1105"); ?></div>
                                                            </div>
                                                            <div class="text-white"><?php echo $daily_study_hours; ?> Hours Per Day</div>
                                                        </div>
                                                    <?php } ?>
                                                    <!--date-->
                                                    <?php if ($display_start_date != NULL) { ?>
                                                        <div class="d-flex justify-between py-5 border-bottom-light-2">
                                                            <div class="d-flex items-center text-white">
                                                                <div class="icon-clock-2"></div>
                                                                <div class="ml-10"><i class="fa fa-calendar"></i> <?php echo _("CRT1107"); ?></div>
                                                            </div>
                                                            <div class="text-white"><?php echo date("d M Y", strtotime($display_start_date)); ?></div>
                                                        </div>
                                                    <?php }if ($display_end_date != NULL) { ?>
                                                        <div class="d-flex justify-between py-5 border-bottom-light-2">
                                                            <div class="d-flex items-center text-white">
                                                                <div class="icon-bar-chart-2"></div>
                                                                <div class="ml-10"><i class="fa fa-calendar"></i> <?php echo _("CRT1108"); ?></div>
                                                            </div>
                                                            <div class="text-white"><?php echo date("d M Y", strtotime($display_end_date)); ?></div>
                                                        </div>
                                                        <?php
                                                    }
                                                    $stmt_video = $offering->checkVideo();
                                                    if ($stmt_video->rowCount() > 0) {
                                                        if ($row_video = $stmt_video->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row_video);
                                                            echo "<div class='d-flex justify-between py-5 border-bottom-light-2'>";
                                                            echo "<div class='d-flex items-center text-white'>";
                                                            echo "<div class='icon-bar-chart-2'></div>";
                                                            echo "<div class='ml-10'><i class='fa fa-play-circle'></i> Preview Video</div>";
                                                            echo "</div>";
                                                            echo "<div class='text-white'><a target='_blank' href='" . ADMIN_HTTP_PATH . $properties['jdbc.offer_video'] . '/' . $media_path . "?iframe=true&width=800&height=450'><i class='fa fa-play-circle'></i> Play</a></div>";
                                                            echo "</div>";
                                                        }
                                                    }
                                                    ?>
                                                </div>

                                                <!--progress bar-->
                                                <div id="score_div">
                                                    <?php
                                                    $stmt_criteria = $offering->check_course_criteria();
                                                    if ($stmt_criteria->rowCount() > 0) {
                                                        if (($result === NULL) || ($result === "complete") || ($result === "incomplete") || ($result === "awaited")) {
                                                            if ($score_flag != 'Yes') {
                                                                if ($final_assmt_id == 0) {
                                                                    
                                                                } else {
                                                                    ?>
                                                                    <!--                                                    //result not shown-->
                                                                    <div class="d-flex y-gap-10 justify-between items-center mt-3">
                                                                        <div class="text-white"><?php echo _("CR0106"); ?></div>
                                                                    </div>
                                                                    <?php
                                                                }
                                                            } else {
                                                                if ($result === NULL || $result === 'awaited') {
                                                                    $score_progress = "progress-bar-info";
                                                                } else if ($result === "complete") {
                                                                    $score_progress = "progress-bar-success";
                                                                } else if ($result === "incomplete") {
                                                                    $score_progress = "progress-bar-danger";
                                                                }
                                                                ?>
                                                                <div class="progress mb-0 mt-20">
                                                                    <div class="progress-bar <?php echo $score_progress; ?>" role="progressbar" aria-valuenow="40"
                                                                         aria-valuemin="0" aria-valuemax="100" style="width:<?php echo $score; ?>%">
                                                                    </div>
                                                                </div>
                                                                <div class="d-flex y-gap-10 justify-between items-center mt-3">
                                                                    <div class="text-white"><?php echo $score; ?>% <?php echo _("CR0110"); ?></div>
                                                                </div>
                                                                <?php
                                                            }
                                                        }
                                                    }
                                                    ?>
                                                </div>
                                                <div class="d-flex justify-between items-end mt-5">
                                                    <?php
                                                    $rating_value = 0;
                                                    $comment = null;
                                                    $stmt = $offering->get_your_rating_value();
                                                    if ($stmt->rowCount() > 0) {
                                                        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            $rating_value = $row['rating_value'];
                                                            if ($row['comments'] != "") {
                                                                $comment = htmlentities($row['comments']);
                                                            }
                                                        }
                                                    }
                                                    $course_notes = "";
                                                    $stmt = $offering->get_your_note();
                                                    if ($stmt->rowCount() > 0) {
                                                        if ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
                                                            if ($row['course_notes'] != "") {
                                                                $course_notes = htmlentities($row['course_notes']);
                                                                $course_last_updated_ts = $row['last_updated_ts'];
                                                            }
                                                        }
                                                    }
                                                    if (($result === "complete") || ($result === "incomplete")) {
                                                        ?>
                                                        <div class="col-lg-6 px-0 compl_left py-15" id="show_rating">
                                                            <a href="javascript:void(0)"  id="rating_review_modal" class="rating">
                                                                <div class="d-flex items-center">
                                                                    <?php if ($rating_value != 0) { ?>
                                                                        <div class="text-16 lh-1 text-yellow-1 mr-10"><?php echo $rating_value ?></div>
                                                                    <?php } ?>
                                                                    <div class="d-flex x-gap-5 items-center">
                                                                        <?php
                                                                        $rat = floor($rating_value);
                                                                        $fr = $rating_value - $rat;
                                                                        $rem = 5 - round($rating_value);
                                                                        for ($i = 1; $i <= $rat; $i++) {
                                                                            echo "<div class='fa fa-star text-12 text-yellow-1 $rat $fr $rem'></div>";
                                                                        }
                                                                        if ($fr != null) {
                                                                            echo "<div class='fa fa-star-half-o text-12 text-yellow-1'></div>";
//                                                        $rating_value_float = null;
                                                                        }
                                                                        for ($i = 1; $i <= $rem; $i++) {
                                                                            echo "<div class='fa fa-star text-12 text-light-3' ></div>";
                                                                        }
                                                                        ?>
                                                                    </div>
                                                                </div>
                                                            </a>
                                                        </div>
                                                    <?php } ?>   

                                                    <div class="col-lg-auto px-0 compl_right">
                                                        <div class="d-flex items-center">
                                                            <!--points-->
                                                            <?php if ($result === "complete" && $completion_points !== NULL) { ?>
                                                                <div class="d-flex justify-between items-end text-dark-3 border-light rounded-200 py-10 px-20">
                                                                    <div class="fa fa-star-o text-14 text-white pb-3"></div>
                                                                    <div class="text-14 ml-5 text-white"><?php
                                                                        echo htmlentities($completion_points) . " ";
                                                                        echo _("HM0134");
                                                                        ?> </div>
                                                                </div>
                                                                &nbsp;&nbsp;
                                                            <?php } ?>
                                                            <!--trophy-->
                                                            <?php
                                                            if (($result === "complete") || ($result === "incomplete")) {
                                                                $stmt_check_cert = $offering->check_certificate_avail_course();
                                                                if ($row_check_cert = $stmt_check_cert->fetch(PDO::FETCH_ASSOC)) {
                                                                    if ($result === NULL) {
                                                                        ?>
                                                                        <a href="#" class="border-light rounded-200  -icon -secondary-1 text-white py-10 px-20">
                                                                            <i class="fa fa-trophy text-18 ml-10"></i>&nbsp;
                                                                            Certificate
                                                                        </a>
                                                                        <?php
                                                                    } else if ($result === "complete") {
                                                                        $mode = 'completed';
                                                                        echo "<a href='javascript:void(0)' onclick='viewCertificate(\"" . $offering_id . "\",\"" . $mode . "\")' id='view_certificate' class='border-light rounded-200  -icon -secondary-1 text-white py-10 px-20'>";
                                                                        ?>
                                                                        <i class="fa fa-trophy text-18 ml-10"></i>&nbsp;
                                                                        <?php echo _("CR0111"); ?>
                                                                        </a>
                                                                        <?php
                                                                    }
                                                                }
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>
                                                </div>
                                                <!--launch course -->
                                                <div class="d-flex items-center  mt-5">
                                                    <a href="javascript:void(0);" 
                                                       class="button -icon -secondary-1 text-color-secondary border-light rounded-200 py-0 px-20 text-color-white" id="launchcontent">
                                                        <div class="fa fa-play text-14 text-color-white"></div>
                                                        <div class="text-14 ml-5">Launch Course</div>
                                                    </a>
                                                </div>
                                                <!--                                                <div class="col-lg-6 px-0 compl_left py-15" id="">
                                                                                                    <a class="text-14 ml-5 text-white" id="launchcontent"><i class="fa fa-pencil"></i>&nbsp;<?php echo _("CRT6112"); ?></a>
                                                                                                </div>-->
                                            </div>


                                            <!--course image-->
                                            <div class="col-md-4 col-xl-4 col-lg-5">
                                                <div class="relative course_image_div">
                                                    <?php
                                                    $filepath = ADMIN_HTTP_PATH . $properties['jdbc.offer_image'] . "/" . $media_path1;

                                                    if ($media_path1 == "" || $media_path1 == NULL) {
                                                        echo "<img src='" . DEFAULT_COURSE_IMAGE . "' alt='" . htmlentities($course_name) . "' title='" . htmlentities($course_name) . "' class='w-1/1 rounded-16'>";
                                                    } else {
                                                        echo "<img src='" . $filepath . "' alt='" . htmlentities($course_name) . "' title='" . htmlentities($course_name) . "' class='w-1/1 rounded-16'>";
                                                    }
                                                    ?>
                                                    <div class="absolute-full-center d-flex justify-center items-center cursor">
                                                        <a href="javascript:void(0);"
                                                           class="d-flex justify-center items-center size-70 rounded-full bg-black" id="launchcontent1"
                                                           >
                                                            <div class="d-flex justify-center items-center size-60 rounded-full bg-white">
                                                                <div class="fa fa-play text-18"></div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </div>
        <?php } ?>
                        </section>

                        <section class="pt-10 layout-pb-md">
                            <div class="container px-0">
                                <div class="pt-25 pb-30 bg-white shadow-2 rounded-8 border-light">
                                    <div class="tabs -active-purple-2 js-tabs pt-0">
                                        <div class="tabs__controls d-flex js-tabs-controls mr-10">
        <?php if ($offering_type == Null) { ?>
                                                <button class="tabs__button js-tabs-button text-16 ml-30"
                                                        data-tab-target=".-tab-item-1" name="overview" type="button">
                                                <?php echo _("TB101"); ?>
                                                </button>
                                                <?php
                                                $stmt_less_cont = $offering->offer_display_course_lesson();
                                                if ($stmt_less_cont->rowCount() > 0) {
                                                    ?>
                                                    <button class="tabs__button js-tabs-button text-16 ml-30"
                                                            data-tab-target=".-tab-item-2" type="button" name="content">
                                                    <?php echo _("TB102"); ?>
                                                    </button>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <?php
                                            if ($result == "" || $result == "awaited") {
                                                if ($final_assmt_id != 0) {
                                                    ?>
                                                    <button class="tabs__button js-tabs-button text-16 ml-30"
                                                            data-tab-target=".-tab-item-3" type="button" name="assessment">
                                                    <?php echo _("TB103"); ?>
                                                    </button>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <?php
                                            $stmt_rc = $offering->check_result_criteria();
                                            if ($stmt_rc->rowCount() > 0) {
                                                ?> 
                                                <button class="tabs__button js-tabs-button text-16 ml-30"
                                                        data-tab-target=".-tab-item-4" type="button" name="score_card">
                                                <?php echo _("TB104"); ?>
                                                </button>
                                            <?php } ?>
                                            <?php
                                            if (($result === "complete") || ($result === "incomplete")) {
                                                if ($coaching_flag == "Yes") {
                                                    ?>
                                                    <button class="tabs__button js-tabs-button text-16 ml-30"
                                                            data-tab-target=".-tab-item-5" type="button" name="coaching_report">
                                                    <?php echo _("TB105"); ?>
                                                    </button>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <?php
                                            $total_inst = $offering->offering_count_instructor();
                                            if ($total_inst > 0) {
                                                ?>
                                                <button class="tabs__button js-tabs-button text-16 ml-30"
                                                        data-tab-target=".-tab-item-6" type="button" name="instructor">
                                                <?php echo _("IN0101"); ?>
                                                </button>
        <?php } ?>
                                            <button class="tabs__button js-tabs-button text-16 ml-30"
                                                    data-tab-target=".-tab-item-7" type="button" name="review">
        <?php echo _("TB106"); ?>
                                            </button>

                                            <button class="tabs__button js-tabs-button text-16 ml-30"
                                                    data-tab-target=".-tab-item-8" type="button" name="course_notes">
        <?php echo _("CRT6112"); ?>
                                            </button>
                                        </div>

                                        <div class="tabs__content pt-10 lg:pt-20 js-tabs-content pb-40 px-30">
                                            <!--Overview Tab-->
        <?php if ($offering_type == Null) { ?>
                                                <div class="tabs__pane -tab-item-1">
                                                    <h4 class="text-20"><?php echo _("CRT1106"); ?></h4>
                                                    <p class="col-xl-9 mt-10"><?php echo htmlentities($category_name); ?></p>

                                                    <div class="mt-40">
                                                        <h4 class="text-20"><?php echo _("CRT1101"); ?></h4>

                                                        <p class="col-xl-9 mt-10">
                                                            <?php
                                                            if ($course_description == "") {
                                                                echo _("CRT1102");
                                                            } else {
                                                                echo nl2br(htmlentities($course_description));
                                                            }
                                                            ?>
                                                        </p>
                                                    </div>

                                                    <div class="mt-40">
                                                        <h4 class="text-10"><?php echo _("CRT1103"); ?></h4>
                                                        <p class="col-xl-9 mt-10">
                                                            <?php
                                                            if ($course_objective == "") {
                                                                echo _("CRT1110");
                                                            } else {
                                                                echo nl2br(htmlentities($course_objective));
                                                            }
                                                            ?>
                                                        </p>
                                                    </div>

                                                    <div class="mt-40">
                                                        <h4 class="text-20"><?php echo _("CRT1111"); ?></h4>
                                                        <p class="col-xl-9 mt-10">
                                                            <?php
                                                            if ($course_prerequisites == "") {
                                                                echo _("CRT1112");
                                                            } else {
                                                                echo nl2br(htmlentities($course_prerequisites));
                                                            }
                                                            ?>
                                                        </p>
                                                    </div>
                                                </div>
                                                <!--Content Tab-->
                                                <div class="tabs__pane -tab-item-2">
                                                    <h2 class="text-20 fw-500 mt-10"><?php echo _("TB102"); ?></h2>

                                                    <div class="d-flex justify-between items-center mt-10">
                                                        <div class=""><?php echo $stmt_less_cont->rowCount(); ?> <?php echo _("CRT2112"); ?> • <a class="lesson_count"></a> <?php echo _("CRT2113"); ?></div>
                                                        <a href='javascript:void(0)' class="underline text-purple-1" onclick="expand_all()"><?php echo _("CRT2114"); ?></a>
                                                    </div>

                                                    <div class="mt-10">
                                                        <div class="accordion -block-2 text-left js-accordion">

                                                            <?php
                                                            if ($stmt_less_cont->rowCount() > 0) {
                                                                while ($row_less_cont = $stmt_less_cont->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_less_cont);
                                                                    $lesson_id1 = $row_less_cont['lesson_id'];
                                                                    $offering->user_id = $_SESSION['uid'];
                                                                    $offering->offering_id = $offering_id;
                                                                    $offering->lesson_id = $lesson_id1;

                                                                    $oc_count = "";
                                                                    $ct_count = "";
                                                                    ?>
                                                                    <div class="accordion__item" id="data_<?php echo $lesson_id1; ?>">
                                                                        <div class="accordion__button py-5 px-20 bg-primary-opacity-1">
                                                                            <div class="d-flex items-center">
                                                                                <div class="accordion__icon">
                                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                                         height="24" viewBox="0 0 24 24" fill="none"
                                                                                         stroke="currentColor" stroke-width="2"
                                                                                         stroke-linecap="round" stroke-linejoin="round"
                                                                                         class="feather feather-chevron-down icon">
                                                                                    <polyline points="6 9 12 15 18 9"></polyline>
                                                                                    </svg>
                                                                                    <svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                                         height="24" viewBox="0 0 24 24" fill="none"
                                                                                         stroke="currentColor" stroke-width="2"
                                                                                         stroke-linecap="round" stroke-linejoin="round"
                                                                                         class="feather feather-chevron-up icon">
                                                                                    <polyline points="18 15 12 9 6 15"></polyline>
                                                                                    </svg>
                                                                                </div>
                                                                                <span class="text-17 fw-500 text-dark-1"><?php
                                                                                    echo _("CRT2111");
                                                                                    echo " " . $seq_no;
                                                                                    ?> :
                                                                                    <?php
                                                                                    echo htmlentities($lesson_name);
                                                                                    if ($lesson_dependency == "Y") {
                                                                                        $offering->seq_no = $seq_no;

                                                                                        $stmt_content_count = $offering->content_count_lesson();
                                                                                        if ($row_content_count = $stmt_content_count->fetch(PDO::FETCH_ASSOC)) {
                                                                                            extract($row_content_count);
                                                                                        }
                                                                                        if ($total_content != $viewed_content) {
                                                                                            echo "&nbsp;<i class='fa fa-lock'></i>";
                                                                                        } else {
                                                                                            echo "&nbsp;<i class='fa fa-unlock'></i>";
                                                                                        }
                                                                                    }
                                                                                    ?>

                                                                                </span>
                                                                            </div>

                                                                            <div>
                                                                                <?php
                                                                                $stmt_lesson_bar = $offering->lesson_level_progress();
                                                                                if ($row_lesson_bar = $stmt_lesson_bar->fetch(PDO::FETCH_ASSOC)) {
                                                                                    extract($row_lesson_bar);
                                                                                }
                                                                                if ($oc_count_ind != 0) {
                                                                                    $val = round($content_progress / $oc_count_ind);
                                                                                }
                                                                                ?>
                                                                                <div class="progress mb-0 mt-20">
                                                                                    <div class="progress-bar progress-bar-info"
                                                                                         role="progressbar" aria-valuenow="60" aria-valuemin="0"
                                                                                         aria-valuemax="100" style="width:<?php echo $val; ?>%">
                                                                                    </div>
                                                                                </div>
                                                                                <div
                                                                                    class="d-flex y-gap-10 justify-between items-center mt-3 mb-5">
                                                                                    <div class="text-ark-1"><?php echo $val; ?>% <?php echo _("HM0125"); ?></div>
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="accordion__content">
                                                                            <div class="accordion__content__inner px-20 py-30">
                                                                                <div class="y-gap-20">
                                                                                    <?php if ($lesson_desc != "") { ?>
                                                                                        <p><b><?php echo _("CRT2110"); ?> </b><?php echo htmlentities($lesson_desc); ?></p>
                                                                                        <?php
                                                                                    }
                                                                                    $offering->offering_id = $offering_id;
                                                                                    $offering->lesson_id = $lesson_id1;
                                                                                    $stmt_cont = $offering->offer_display_course_content();
                                                                                    $lesson_content_count += $stmt_cont->rowcount();
                                                                                    while ($row_cont = $stmt_cont->fetch(PDO::FETCH_ASSOC)) {
                                                                                        extract($row_cont);
                                                                                        ?>
                                                                                        <div class="border-bottom-dark mb-5">
                                                                                            <div class="d-flex justify-between">
                                                                                                <div class="d-flex items-center">
                                                                                                    <div class="d-flex justify-center items-center size-30 rounded-full bg-purple-3 mr-10">
                                                                                                        <?php
                                                                                                        $bytes = $content_size;
                                                                                                        if ($bytes >= 1099511627776) {
                                                                                                            $bytes = number_format($bytes / 1099511627776, 2) . ' TB';
                                                                                                        } elseif ($bytes >= 1073741824) {
                                                                                                            $bytes = number_format($bytes / 1073741824, 2) . ' GB';
                                                                                                        } elseif ($bytes >= 1048576) {
                                                                                                            $bytes = number_format($bytes / 1048576, 2) . ' MB';
                                                                                                        } elseif ($bytes >= 1024) {
                                                                                                            $bytes = number_format($bytes / 1024) . ' KB';
                                                                                                        } elseif ($bytes > 1) {
                                                                                                            $bytes = $bytes . ' bytes';
                                                                                                        } elseif ($bytes == 1) {
                                                                                                            $bytes = $bytes . ' byte';
                                                                                                        } else {
                                                                                                            $bytes = '0 bytes';
                                                                                                        }

                                                                                                        $supported_image = array(
                                                                                                            'gif', 'jpg', 'jpeg', 'png', 'bmp'
                                                                                                        );
                                                                                                        $supported_audio = array(
                                                                                                            'mp3', 'wav', 'wave', 'm4a', 'm4p', 'm4r', 'ogg'
                                                                                                        );
                                                                                                        $supported_video = array(
                                                                                                            'ogv', 'oga', 'ogx', 'ogm', 'spx', 'opus', 'webm', 'mp4', 'm4b', 'm4v', 'mov', 'qt', 'mkv'
                                                                                                        );
                                                                                                        $supported_document = array(
                                                                                                            'doc', 'docx', 'xls', 'xlsx', 'pdf', 'ppt', 'pptx', 'txt', 'xml', 'xsl', 'rtf'
                                                                                                        );
                                                                                                        $ext = strtolower(pathinfo($content_path, PATHINFO_EXTENSION)); // Using strtolower to overcome case sensitive
                                                                                                        if (in_array($ext, $supported_image)) {
                                                                                                            echo "<div class='fa fa-picture-o text-9'></div>";
                                                                                                        } else if (in_array($ext, $supported_audio)) {
                                                                                                            echo "<div class='fa fa-file-audio-o text-9'></div>";
                                                                                                        } else if (in_array($ext, $supported_video)) {
                                                                                                            echo "<div class='fa fa-file-movie-o text-9'></div>";
                                                                                                        } else if (in_array($ext, $supported_document)) {
                                                                                                            echo "<div class='fa fa-file-text text-9'></div>";
                                                                                                        } else {
                                                                                                            echo "<div class='fa fa-file-o text-9'></div>";
                                                                                                        }
                                                                                                        ?>
                                                                                                    </div>
                                                                                                    <?php
                                                                                                    if ($start_date <= $date) {
                                                                                                        echo "<div><a href='contentview.php?offer={$offering_id}&type=content&value={$contentdtl_id}' class='text-purple-1'>{$content_title}</a></div>";
                                                                                                    } else {
                                                                                                        echo "<div><a class='text-purple-1'>{$content_title}</a></div>";
                                                                                                    }
                                                                                                    ?>
                                                                                                </div>
                                                                                                <?php
                                                                                                $offering->offering_id = $offering_id;
                                                                                                $offering->user_id = $_SESSION['uid'];
                                                                                                $offering->contentdtl_id = $contentdtl_id;
                                                                                                ?>
                                                                                                <div class="d-flex x-gap-20 items-center">
                                                                                                    <?php
                                                                                                    if ($content_type_id == 5) {
                                                                                                        $scorm_status = "";
                                                                                                        $offering->scorm_id = $scorm_id;
                                                                                                        $stmt_scorm_status = $offering->get_scorm_lesson_status_user();
                                                                                                        if ($row_scorm_status = $stmt_scorm_status->fetch(PDO::FETCH_ASSOC)) {
                                                                                                            if ($row_scorm_status['value'] != "") {
                                                                                                                $scorm_status = $row_scorm_status['value'];
                                                                                                            }
                                                                                                        }
                                                                                                        if ($scorm_status == "passed" || $scorm_status == "completed") {
                                                                                                            echo "<p class='text-14 lh-1 text-blue-5 mb-0'><a href='javascript:void(0)' class='bgnone' rel='tooltip' title='Since you have completed this module, score is not recorded for futher attempts.'><i class='fa fa-info-circle' ></i></a></p>";
                                                                                                        }
                                                                                                    }
                                                                                                    if ($content_type_id == 9) {
                                                                                                        $xapi_status = "";
                                                                                                        $offering->xapi_id = $xapi_id;
                                                                                                        $stmt_xapi_status = $offering->get_xapi_lesson_status_user();
                                                                                                        if ($row_xapi_status = $stmt_xapi_status->fetch(PDO::FETCH_ASSOC)) {
                                                                                                            if ($row_xapi_status['status'] != "") {
                                                                                                                $xapi_status = $row_xapi_status['status'];
                                                                                                            }
                                                                                                        }
                                                                                                        if ($xapi_status == "passed" || $xapi_status == "completed") {
                                                                                                            echo "<p class='text-14 lh-1 text-blue-5 mb-0'><a href='javascript:void(0)' class='bgnone' rel='tooltip' title='Since you have completed this module, score is not recorded for futher attempts.'><i class='fa fa-info-circle' ></i></a></p>";
                                                                                                        }
                                                                                                    }
                                                                                                    if ($start_date <= $date) {
                                                                                                        if ($content_type_id == "5" || $content_type_id == "6" || $content_type_id == "7" || $content_type_id == "9") {
                                                                                                            if ($launchContent == "") {
                                                                                                                $launchContent = "contentview.php?offer={$offering_id}&type=content&value={$contentdtl_id}";
                                                                                                            }
                                                                                                            echo "<a class='text-14 lh-1 text-purple-1' href='contentview.php?offer={$offering_id}&type=content&value={$contentdtl_id}'>";
                                                                                                            echo _("CRT2102");
                                                                                                            echo "</a> ";
                                                                                                        } else {
                                                                                                            if ($launchContent == "") {
                                                                                                                $launchContent = "contentview.php?offer={$offering_id}&type=content&value={$contentdtl_id}";
                                                                                                            }
                                                                                                            echo "<a class='text-14 lh-1 text-purple-1' href='contentview.php?offer={$offering_id}&type=content&value={$contentdtl_id}'>";
                                                                                                            echo _("CRT2102");
                                                                                                            if ($online == "N") {
                                                                                                                echo "/";
                                                                                                                echo _("CRT2103");
                                                                                                                echo "($bytes)";
                                                                                                                //echo "/<a href='modules/track_content.php?path=$course_id/$lesson_id1/$content_id/$content_path&cid=$contentdtl_id&oid=$offering_id&uid=" . $_SESSION['uid'] . "&mode=download' target='_blank'>Download ($bytes)</a>";
                                                                                                            }
                                                                                                            echo "</a>";
                                                                                                        }
                                                                                                    } else {
                                                                                                        echo "<a class='text-14 lh-1 text-purple-1'>Opens on " . date("d-m-Y", strtotime($start_date)) . "</a>";
                                                                                                    }
                                                                                                    if ($offering_count != 0) {
                                                                                                        echo "<p class='text-14 lh-1 text-green-5 mb-0'>";
                                                                                                        echo _("CT0107");
                                                                                                        echo "</p>";
                                                                                                    } else {
                                                                                                        echo "<p class='text-14 lh-1 text-green-5 mb-0'></p>";
                                                                                                    }
                                                                                                    ?>                                                                      

                                                                                                    <p class="text-14 lh-1 text-dark-1 mb-0">
                                                                                                        <?php
                                                                                                        if ($content_type_id == 1 || $content_type_id == 2 || $content_type_id == 3 || $content_type_id == 4) {
                                                                                                            echo _("CRT2104");
                                                                                                        } else if ($content_type_id == 6) {
                                                                                                            echo _("CRT2105");
                                                                                                        } else if ($content_type_id == 5 || $content_type_id == 9) {
                                                                                                            echo _("CRT2106");
                                                                                                        } else if ($content_type_id == 7) {
                                                                                                            echo _("CRT2107");
                                                                                                        } else if ($content_type_id == 10) {
                                                                                                            echo _("CRT2115");
                                                                                                        }
                                                                                                        ?>
                                                                                                    </p>
                                                                                                </div>
                                                                                            </div>
                                                                                            <?php
                                                                                            if ($content_desc != '') {
                                                                                                echo"<p class='pt-0 pl-40 mb-0' id='content_desc{$contentdtl_id}'><b>" . _("CRT2110") . " </b>";
                                                                                                echo htmlentities($content_desc);
                                                                                                echo"</p>";
                                                                                            }
                                                                                            ?>                                                               
                                                                                        </div>
                                                                                    <?php } ?>                                                    
                                                                                    <?php
                                                                                    $stmt_cyu = $offering->offer_cyu_lesson();
                                                                                    if ($row_cyu = $stmt_cyu->fetch(PDO::FETCH_ASSOC)) {
                                                                                        extract($row_cyu);
                                                                                        ?>
                                                                                        <div class="mb-5">
                                                                                            <div class="d-flex justify-between">
                                                                                                <div class="d-flex items-center">
                                                                                                    <div
                                                                                                        class="d-flex justify-center items-center size-30 rounded-full bg-purple-3 mr-10">
                                                                                                        <div class="fa fa-graduation-cap text-9">
                                                                                                        </div>
                                                                                                    </div>
                                                                                                    <div>
                                                                                                        <?php
                                                                                                        if ($start_date <= $date) {
                                                                                                            if ($launchContent == "") {
                                                                                                                $launchContent = "contentview.php?offer={$offering_id}&type=assessment&value={$assessment_id}";
                                                                                                            }
                                                                                                            echo "<a class='text-purple-1' href='contentview.php?offer={$offering_id}&type=assessment&value={$assessment_id}'>" . htmlentities($assessment_name) . " </a>";
                                                                                                        } else {
                                                                                                            echo "<a>" . htmlentities($assessment_name) . " </a>";
                                                                                                        }
                                                                                                        ?>                                                                  
                                                                                                    </div>
                                                                                                </div>

                                                                                                <div class="d-flex x-gap-20 items-center">

                                                                                                    <p class="text-14 lh-1 text-dark-1 mb-0"><?php echo _("CRT2109"); ?></p>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                    <?php } ?>

                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <?php
                                                                }
                                                            }
                                                            ?>
                                                        </div>
                                                    </div>

                                                </div>

                                            <?php } ?>
                                            <!--Assessment tab-->
                                            <?php
                                            if ($result == "" || $result == 'awaited') {
                                                if ($final_assmt_id != 0) {
                                                    $no_questions = null;
                                                    $current_attempt = 0;
                                                    $score = 0;
                                                    $passing_score_1 = 0;
                                                    echo "<div class='tabs__pane -tab-item-3' id='assessment'>";
                                                    echo "<div class='row justify-center text-center'>";
                                                    echo "<div class='col-md-6'>";
                                                    if ($start_date <= $date) {
                                                        if ($assmt_startdate != null && $assmt_enddate != null) {
                                                            if ($assmt_enddate < $date_time) {
                                                                echo "<div class='text-red-3'><b>";
                                                                echo _("CRT3114");
                                                                echo "</b></div><br/>";
                                                            } else {
                                                                $assmt_startdate1 = date('d/m/Y h:i:s a', strtotime($assmt_startdate));
                                                                $assmt_enddate1 = date('d/m/Y h:i:s a', strtotime($assmt_enddate));
                                                                echo "<div class='text-red-1'><b>";
                                                                echo _("CRT3111");
                                                                echo "&nbsp;&nbsp;";
                                                                echo $assmt_startdate1;
                                                                echo "&nbsp;&nbsp;";
                                                                echo _("CRT3112");
                                                                echo "&nbsp;&nbsp;";
                                                                echo $assmt_enddate1;
                                                                echo "&nbsp;&nbsp;";
                                                                echo _("CRT3113");
                                                                echo "</b></div><br/>";
                                                            }
                                                        }
                                                    }
                                                    echo "<div class='sectionTitle border-bottom-primary'><h2 class='sectionTitle__title'>";
                                                    echo _("TB103");
                                                    echo "</h2></div>";
                                                    $offering->offering_id = $offering_id;
                                                    $offering->user_id = $_SESSION['uid'];
                                                    $stmt1 = $offering->offering_display_assessment_randomization();
                                                    if ($stmt1->rowCount() > 0) {
                                                        if ($row1 = $stmt1->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row1);
                                                            if ($question_count == NULL) {
                                                                $stmt2 = $offering->offering_assessment_no_questions();
                                                                if ($row2 = $stmt2->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row2);
                                                                    $no_questions = $no_questions;
                                                                }
                                                            } else {
                                                                $no_questions = $question_count;
                                                            }
                                                        }
                                                    }
                                                    $stmt3 = $offering->offering_current_attempt();
                                                    if ($row3 = $stmt3->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row3);
                                                        if ($attempt_no == NULL) {
                                                            $current_attempt++;
                                                        } else {
                                                            $current_attempt = $attempt_no + 1;
                                                        }
                                                    }
                                                    $offering->assessment_id = $final_assmt_id;
                                                    $stmt4 = $offering->get_user_score();
                                                    if ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row4);
                                                        $score = $score;
                                                        $passing_score_1 = $pass_score;
                                                    }
                                                    echo "<div class='d-flex justify-between py-8 px-10'>";
                                                    echo "<div>";
                                                    echo _("CRT3101");
                                                    echo "</div>";
                                                    $stmt4 = $offering->get_assessment_name();
                                                    if ($row4 = $stmt4->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row4);
                                                        echo "<div>" . htmlentities($assessment_name) . "</div>";
                                                    }
                                                    echo "</div>";
                                                    echo "<div class='d-flex justify-between py-8 px-10 border-top-light'>";
                                                    echo "<div>";
                                                    echo _("CRT3102");
                                                    echo "</div>";
                                                    echo "<div>" . $passing_score . "</div>";
                                                    echo "</div>";
                                                    echo "<div class='d-flex justify-between py-8 px-10 border-top-light'>";
                                                    echo "<div>";
                                                    echo _("CRT3103");
                                                    echo "</div>";
                                                    echo "<div>" . $no_questions . "</div>";
                                                    echo "</div>";
                                                    if ($assmt_duration != 0) {
                                                        echo "<div class='d-flex justify-between py-8 px-10 border-top-light'>";
                                                        echo "<div>";
                                                        echo _("CRT3104");
                                                        echo "</div>";
                                                        echo "<div>" . $assmt_duration . " min(s)</div>";
                                                        echo "</div>";
                                                    }
                                                    echo "<div class='d-flex justify-between py-8 px-10 border-top-light'>";
                                                    echo "<div>";
                                                    echo _("CRT3105");
                                                    echo "</div>";
                                                    echo"<div>" . $max_attempts . "</div>";
                                                    echo "</div>";
                                                    echo "<div class='d-flex justify-between py-8 px-10 border-top-light'>";
                                                    echo "<div>";
                                                    echo _("CRT3106");
                                                    echo "</div>";
                                                    echo"<div>";
                                                    if ($current_attempt <= $max_attempts) {
                                                        echo $current_attempt;
                                                    } else {
                                                        echo _("CR0502");
                                                    }
                                                    echo"</div>";
                                                    echo "</div>";
                                                    //take test button
//                                                     <div class="d-flex justify-center pt-15 pb-15">
//                                                <a href="#"
//                                                    class="text-16 d-flex justify-center items-center button -icon -secondary-2 text-color-secondary px-50 py-0">
//                                                    Take Test
//                                                </a>
//                                            </div>
                                                    echo "<div class='d-flex justify-center pt-15 pb-15'>";
                                                    if ($result === NULL) {
                                                        //  echo "<button type='button' class='single_add_to_cart_button button alt' style='width:200px;height: 50px;' ";
                                                        if ($end_date >= $date) {
                                                            if ($assessment_dependency == "Y") {
                                                                $offering->offering_id = $offering_id;
                                                                $offering->user_id = $_SESSION['uid'];
                                                                $stmt_all_lesson_ccheck = $offering->all_lesson_completed_check();
                                                                if ($row_lesson_ccheck = $stmt_all_lesson_ccheck->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_lesson_ccheck);
                                                                    if ($oc_count_all != $ct_count_all) {
                                                                        echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3108") . "'><i class='fa fa-lock'></i>";
                                                                        echo _("CRT3107");
                                                                        echo "</a>";
                                                                        echo "</div>";
                                                                        echo "</div>";
                                                                        echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3108") . "</div>";
                                                                    } else {
                                                                        if ($start_date <= $date) {
                                                                            if ($assmt_startdate != null && $assmt_enddate != null) {
                                                                                if ($assmt_startdate <= $date_time && $assmt_enddate >= $date_time) {
                                                                                    if ($launchAssessment == "") {
                                                                                        $launchAssessment = "takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")";
                                                                                    }
                                                                                    echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' onclick='takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")'>";
                                                                                    echo _("CRT3107");
                                                                                    echo "</a>";
                                                                                    echo "</div>";
                                                                                    echo "</div>";
                                                                                } else {
                                                                                    echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3109") . "'><i class='fa fa-lock'></i>";
                                                                                    echo _("CRT3107");
                                                                                    echo "</a>";
                                                                                    echo "</div>";
                                                                                    echo "</div>";
                                                                                    echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3111") ." ". date("d M Y h:i A", strtotime($assmt_startdate)) ." ".  _("CRT3112") ." ". date("d M Y h:i A", strtotime($assmt_enddate)) . "</div>";
                                                                                }
                                                                            } else {
                                                                                if ($launchAssessment == "") {
                                                                                    $launchAssessment = "takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")";
                                                                                }
                                                                                echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' onclick='takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")'>";
                                                                                echo _("CRT3107");
                                                                                echo "</a>";
                                                                                echo "</div>";
                                                                                echo "</div>";
                                                                            }
                                                                        } else {
                                                                            echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3110") . "'><i class='fa fa-lock'></i>";
                                                                            echo _("CRT3107");
                                                                            echo "</a>";
                                                                            echo "</div>";
                                                                            echo "</div>";
                                                                            echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3109") . date("d M Y", strtotime($start_date)) . "</div>";
                                                                        }
                                                                    }
                                                                }
                                                            } else {
                                                                if ($start_date <= $date) {
                                                                    if ($assmt_startdate != null && $assmt_enddate != null) {
                                                                        if ($assmt_startdate <= $date_time && $assmt_enddate >= $date_time) {
                                                                            if ($launchAssessment == "") {
                                                                                $launchAssessment = "takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")";
                                                                            }
                                                                            echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' onclick='takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")'>";
                                                                            echo _("CRT3107");
                                                                            echo "</a>";
                                                                            echo "</div>";
                                                                            echo "</div>";
                                                                        } else {
                                                                            echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3109") . "'><i class='fa fa-lock'></i>";
                                                                            echo _("CRT3107");
                                                                            echo "</a>";
                                                                            echo "</div>";
                                                                            echo "</div>";
                                                                            echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3111") ." ". date("d M Y h:i A", strtotime($assmt_startdate)) ." ".  _("CRT3112") . date("d M Y h:i A", strtotime($assmt_enddate)) .  "</div>";
                                                                        }
                                                                    } else {
                                                                        if ($launchAssessment == "") {
                                                                            $launchAssessment = "takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")";
                                                                        }
                                                                        echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' onclick='takeTest(\"" . $current_attempt . "\", \"" . $max_attempts . "\", \"" . $score . "\", \"" . $passing_score . "\",\"" . $final_assmt_id . "\", \"" . $offering_id . "\", \"" . $assmt_duration . "\", \"" . $passing_score_1 . "\")'>";
                                                                        echo _("CRT3107");
                                                                        echo "</a>";
                                                                        echo "</div>";
                                                                        echo "</div>";
                                                                    }
                                                                } else {
                                                                    echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3110") . "'><i class='fa fa-lock'></i>";
                                                                    echo _("CRT3107");
                                                                    echo "</a>";
                                                                    echo "</div>";
                                                                    echo "</div>";
                                                                    echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3109") . date("d M Y", strtotime($start_date)). "</div>";
                                                                }
                                                            }
                                                        } else {
                                                            echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("CRT3110") . "'><i class='fa fa-lock'></i>";
                                                            echo _("CRT3107");
                                                            echo "</a>";
                                                            echo "</div>";
                                                            echo "</div>";
                                                            echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("CRT3110") . "</div>";
                                                        }
                                                    } else if ($result === 'awaited') {
                                                        echo "<a href='javascript:void(0)' id='assessment_dependency' class='text-16 d-flex justify-center items-center button -icon bg-color-primary text-white px-50 py-0' title='" . _("SU0103") . "'><i class='fa fa-lock'></i>";
                                                        echo _("CRT3107");
                                                        echo "</a>";
                                                        echo "</div>";
                                                        echo "</div>";
                                                        echo "<div class='text-red-1 text-17 py-10 fw-500'>" . _("SU0103") . "</div>";
                                                    }

                                                    echo "</div>";
                                                    echo "</div>";
                                                }
                                            }
                                            ?>
                                            <!--Score card-->
                                            <?php
                                            if ($stmt_rc->rowCount() > 0) {
                                                echo "<div class='tabs__pane -tab-item-4'>";
                                                echo "<h2 class='text-20 fw-500 mt-10 pb-10 border-bottom-dark'>" . _("TB104") . "</h2>";
                                                echo "<div id='read_scorecard'>";
                                                echo "<div class='d-flex items-center mt-10 justify-between'>";
                                                echo "<div>";
                                                echo "<div class='form-checkbox'>";
                                                if ($final_assmt_id != 0) {
                                                    echo "<input type='checkbox' id='show_all'> ";
                                                    echo "<div class='form-checkbox__mark'>";
                                                    echo "<div class='form-checkbox__icon fa fa-check'></div>";
                                                    echo "</div>";
                                                    echo "<div class='text-14 lh-12 text-dark-1 ml-10'>" . _("CRT4101") . "</div>";
                                                }
                                                echo "</div>";
                                                echo "</div>";
                                                if (($result === "complete") || ($result === "incomplete")) {
                                                    echo "<div>";
                                                    echo '<button type="button" class="button -sm text-14 bg-color-primary text-white" id="btnPrint" onclick="scorecardPrint(\'' . addslashes($course_name) . '\')"><i class="fa fa-print"></i></button>';
                                                    echo "</div>";
                                                    echo "</div>";
                                                    echo "<div id='printThis'>";
                                                } else {
                                                    echo "</div>";
                                                }
                                                echo "<div id='hidden_div'><center><br/>
                                            <img src='{$cust_company_image_path}' alt={$cust_company_name} width='300' height='300'/></center><br/>";
                                                $stmt_user = $users->UserDetails($_SESSION['uid']);
                                                if ($row_user = $stmt_user->fetch(PDO::FETCH_ASSOC)) {
                                                    echo " <h4>";
                                                    echo _("CRT4103");
                                                    echo " : " . $row_user["first_name"] . " " . $row_user["last_name"] . "</h4>";
                                                }
                                                echo "<h4>";
                                                if ($offering_type == 'A') {
                                                    echo _('CRT5101');
                                                } else {
                                                    echo _('HM0114');
                                                }
                                                echo ": {$course_name}</h4>";
                                                if($attended_date != Null){
                                                echo "<h4>" . _("CRT1109") . " : " . date("d-m-Y", strtotime($attended_date)) . "</h4>  
                                                  <center><h4 id='table_title'>" . _("TB104") . "</h4></center><br/></div>";
                                                }else{
                                                     echo "<h4>" . _("CRT1109") . " : </h4>  
                                                  <center><h4 id='table_title'>" . _("TB104") . "</h4></center><br/></div>";
                                                }
                                                //table
                                                echo "<div class='table-responsive mt-20'>";
                                                echo "<table class='table_scorecard w-1/1'>";
                                                echo "<colgroup>"
                                                . "<col style='width:20%'>"
                                                . "<col style='width:15%'>"
                                                . "<col style='width:10%'>"
                                                . "<col style='width:15%'>"
                                                . "<col style='width:10%'>"
                                                . "<col style='width:10%'>";
                                                if ($score_flag == 'Yes') {
                                                    echo "<col style='width:10%'>";
                                                }
                                                echo "<col style='width:10%'>"
                                                . "</colgroup>";
                                                echo "<thead>";
                                                echo "<tr>"
                                                . "<th>" . _("CRT4103") . "</th>"
                                                . "<th>" . _("CRT4102") . "</th>"
                                                . "<th>" . _("CRT4104") . "</th>"
                                                . "<th>" . _("CRT4105") . "(%)</th>"
                                                . "<th>" . _("CRT4106") . "(%)</th>"
                                                . "<th>" . _("CRT4107") . "</th>";
                                                if ($score_flag == 'Yes') {
                                                    echo "<th>" . _("CRT4108") . "(%)</th>";
                                                }
                                                echo "<th>" . _("CRT4109") . "</th>";
                                                echo "</tr>";
                                                echo "</thead>";
                                                echo "<tbody>";
                                                $score1 = "";
                                                $result1 = "";
                                                $attempt_no = "---";
                                                if (($result === "complete") || ($result === "incomplete")) {
                                                    $stmt_assemnt = $offering->get_assessment_score_card_complete_incomplete();
                                                } else {
                                                    $stmt_assemnt = $offering->get_assessment_score_card();
                                                }
                                                if ($row_assemnt = $stmt_assemnt->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row_assemnt);
                                                    $passing_score1 = $passing_score;
                                                    echo "<tr class='bg-white shadow-1 rounded-8 border-light assessment_row'>";
                                                    echo "<td>" . htmlentities($assessment_name) . "</td>";
                                                    echo "<td>"
                                                    . "<div class='about-content'>"
                                                    . "<div class='bg-green-2 about-content-list__icon'>"
                                                    . "<svg xmlns='http://www.w3.org/2000/svg' width='24'"
                                                    . " height='24' viewBox='0 0 24 24' fill='none'"
                                                    . "stroke='#000' stroke-width='2'"
                                                    . "stroke-linecap='round' stroke-linejoin='round'"
                                                    . "class='fa fa-check icon'>"
                                                    . "<polyline points='20 6 9 17 4 12'>"
                                                    . "</polyline>"
                                                    . "</svg>"
                                                    . "</div>"
                                                    . "</div></td>";
                                                    echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>" . _("TB103") . "</span></td>";
                                                    echo "<td>{$passing_score1}</td>";
                                                    echo "<td>{$weightage}</td>";
                                                    $stmt_assemnt_attempt = $offering->offering_current_attempt();
                                                    if ($row_assemnt_attempt = $stmt_assemnt_attempt->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_assemnt_attempt);
                                                        if ($attempt_no == "") {
                                                            $attempt_no = "Not attempted";
                                                        }
                                                    }
                                                    echo "<td>{$attempt_no}</td>";
                                                    $offering->offering_id = $offering_id;
                                                    $offering->user_id = $_SESSION['uid'];
                                                    $offering->assessment_id = $assessment_id;
                                                    $stmt_score = $offering->get_user_score();
                                                    if ($row_score = $stmt_score->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_score);
                                                        $score1 = $score;
                                                        $passing_score1 = $pass_score;
                                                        if ($result == "awaited") {
                                                            $result1 = 'Awaited';
                                                        } else {
                                                            if ($score1 >= $passing_score1) {
                                                                $result1 = 'complete';
                                                            } else {
                                                                $result1 = 'incomplete';
                                                            }
                                                        }
                                                    } else {
                                                        $score1 = 'Not attempted';
                                                        $result1 = 'Not attempted';
                                                    }
                                                    if ($score_flag == "Yes") {
                                                        echo "<td>{$score1}</td>";
                                                    }
                                                    $result_bg = $result1 == "complete" ? "bg-green-2" : "bg-red-2";
                                                    echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 {$result_bg} py-5 px-5'>{$result1}</span></td>";
                                                    echo "</tr>";
                                                }
                                                $stmt_scorm = $offering->get_scorm_score_card();
                                                if ($stmt_scorm->rowCount() > 0) {
                                                    while ($row_scorm = $stmt_scorm->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_scorm);
                                                        $consider_result_sc = 'No';
                                                        $consider_result_rc = 'No';
                                                        $consider_result = 'No';
                                                        $weightage1 = "";
                                                        $offering->scorm_id = $scorm_id;
                                                        echo "<tr class='bg-white shadow-2 rounded-8 border-light'>";
                                                        if (($result === "complete") || ($result === "incomplete")) {
                                                            $stmt_scorms1 = $offering->get_scorm_score_card_considered_active_inactive();
                                                            if ($stmt_scorms1->rowCount() > 0) {
                                                                $consider_result_sc = 'Yes';
                                                                while ($row_scorms1 = $stmt_scorms1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_scorms1);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                            $stmt_scorm1 = $offering->get_scorm_score_card_considered();
                                                            if ($stmt_scorm1->rowCount() > 0) {
                                                                $consider_result_rc = 'Yes';
                                                                while ($row_scorm1 = $stmt_scorm1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_scorm1);

                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                            if (($consider_result_sc === 'Yes') || ($consider_result_rc === 'Yes')) {
                                                                $consider_result = 'Yes';
                                                            }
                                                        } else {
                                                            $stmt_scorm1 = $offering->get_scorm_score_card_considered();
                                                            if ($stmt_scorm1->rowCount() > 0) {
                                                                $consider_result = 'Yes';
                                                                while ($row_scorm1 = $stmt_scorm1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_scorm1);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                        }
                                                        $con_bg = $consider_result == "Yes" ? "bg-green-2" : "bg-red-2";

                                                        echo "<td>" . htmlentities($content_title) . "</td>";
                                                        echo "<td>"
                                                        . "<div class='about-content'>"
                                                        . "<div class='{$con_bg} about-content-list__icon'>";
                                                        if ($consider_result == "Yes") {
                                                            echo "<svg xmlns='http://www.w3.org/2000/svg' width='24'"
                                                            . " height='24' viewBox='0 0 24 24' fill='none'"
                                                            . "stroke='#000' stroke-width='2'"
                                                            . "stroke-linecap='round' stroke-linejoin='round'"
                                                            . "class='fa fa-check icon'>"
                                                            . "<polyline points='20 6 9 17 4 12'>"
                                                            . "</polyline>"
                                                            . "</svg>";
                                                        } else {
                                                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="#000" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="fa fa-times icon">
                                                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                </svg>';
                                                        }
                                                        echo "</div>"
                                                        . "</div></td>";
                                                        echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>" . _("CRT2106") . "</span></td>";
                                                        echo "<td>$mastery_score</td>";
                                                        echo "<td>";
                                                        if ($weightage1 == "") {
                                                            echo '---';
                                                        } else {
                                                            echo $weightage1;
                                                        }
                                                        echo "</td>";
                                                        echo "<td>---</td>";
                                                        $value = "";
                                                        if ($score_flag == "Yes") {
                                                            echo "<td>";
                                                            $stmt_scorm2 = $offering->get_scorm_score_user();
                                                            if ($row_scorm2 = $stmt_scorm2->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row_scorm2);
                                                                if ($value != "") {
                                                                    echo $value;
                                                                } else {
                                                                    echo '---';
                                                                }
                                                            } else {
                                                                echo 'Not attempted';
                                                            }
                                                            echo "</td>";
                                                        }

                                                        $stmt_scorm2 = $offering->get_scorm_lesson_status_user();
                                                        if ($row_scorm2 = $stmt_scorm2->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row_scorm2);
                                                            $value_bg = $value == "passed" || $value == "completed" ? "bg-green-2" : "bg-red-2";
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 {$value_bg} py-5 px-5'>{$value}</span></td>";
                                                        } else {
                                                            $value = "Not attempted";
//                                                            $value_bg = $value == "passed" || $value == "completed" ? "bg-green-2" : "bg-red-2";
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-2 py-5 px-5'>{$value}</span></td>";
                                                        }
                                                        echo "</tr>";
                                                    }
                                                }
                                                $stmt_xapi = $offering->get_xapi_score_card();
                                                if ($stmt_xapi->rowCount() > 0) {
                                                    while ($row_xapi = $stmt_xapi->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_xapi);
                                                        $consider_result_sc = 'No';
                                                        $consider_result_rc = 'No';
                                                        $consider_result = 'No';
                                                        $weightage1 = "";
                                                        $offering->xapi_id = $xapi_id;
                                                        echo "<tr class='bg-white shadow-2 rounded-8 border-light'>";
                                                        if (($result === "complete") || ($result === "incomplete")) {
                                                            $stmt_xapi1 = $offering->get_xapi_score_card_considered_active_inactive();
                                                            if ($stmt_xapi1->rowCount() > 0) {
                                                                $consider_result_sc = 'Yes';
                                                                while ($row_xapi1 = $stmt_xapi1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_xapi1);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                            $stmt_xapi2 = $offering->get_xapi_score_card_considered();
                                                            if ($stmt_xapi2->rowCount() > 0) {
                                                                $consider_result_rc = 'Yes';
                                                                while ($row_xapi2 = $stmt_xapi2->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_xapi2);

                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                            if (($consider_result_sc === 'Yes') || ($consider_result_rc === 'Yes')) {
                                                                $consider_result = 'Yes';
                                                            }
                                                        } else {
                                                            $stmt_xapi1 = $offering->get_xapi_score_card_considered();
                                                            if ($stmt_xapi1->rowCount() > 0) {
                                                                $consider_result = 'Yes';
                                                                while ($row_xapi1 = $stmt_xapi1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_xapi1);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                        }
                                                        $con_bg = $consider_result == "Yes" ? "bg-green-2" : "bg-red-2";

                                                        echo "<td>" . htmlentities($content_title) . "</td>";
                                                        echo "<td>"
                                                        . "<div class='about-content'>"
                                                        . "<div class='{$con_bg} about-content-list__icon'>";
                                                        if ($consider_result == "Yes") {
                                                            echo "<svg xmlns='http://www.w3.org/2000/svg' width='24'"
                                                            . " height='24' viewBox='0 0 24 24' fill='none'"
                                                            . "stroke='#000' stroke-width='2'"
                                                            . "stroke-linecap='round' stroke-linejoin='round'"
                                                            . "class='fa fa-check icon'>"
                                                            . "<polyline points='20 6 9 17 4 12'>"
                                                            . "</polyline>"
                                                            . "</svg>";
                                                        } else {
                                                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="#000" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="fa fa-times icon">
                                                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                </svg>';
                                                        }
                                                        echo "</div>"
                                                        . "</div></td>";
                                                        echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>" . _("CRT2106") . "</span></td>";
                                                        echo "<td>" . _("HM0119") . "</td>";
                                                        echo "<td>";
                                                        if ($weightage1 == "") {
                                                            echo '---';
                                                        } else {
                                                            echo $weightage1;
                                                        }
                                                        echo "</td>";
                                                        echo "<td>---</td>";
                                                        $actual_score = "";
                                                        if ($score_flag == "Yes") {
                                                            echo "<td>";
                                                            $stmt_xapi2 = $offering->get_xapi_score_user();
                                                            if ($row_xapi2 = $stmt_xapi2->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row_xapi2);
                                                                if ($actual_score != 0) {
                                                                    if ($score_max != 0 && $score_max != 100) {
                                                                        $xs = ($actual_score * 100) / $score_max;
                                                                        echo $xs;
                                                                    } else {
                                                                        echo $actual_score;
                                                                    }
                                                                } else {
                                                                    echo '---';
                                                                }
                                                            } else {
                                                                echo 'Not attempted';
                                                            }
                                                            echo "</td>";
                                                        }

                                                        $stmt_xapi2 = $offering->get_xapi_lesson_status_user();
                                                        if ($row_xapi2 = $stmt_xapi2->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row_xapi2);
                                                            if ($xapi_batch == "W") {
                                                                echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>Awaited</span></td>";
                                                            } else if ($status == "failed" || $status == "incomplete") {
                                                                echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 bg-red-2 py-5 px-5'>{$status}</span></td>";
                                                            } else if ($status == "passed" || $status == "completed") {
                                                                echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 bg-green-2 py-5 px-5'>{$status}</span></td>";
                                                            } else {
                                                                echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>{$status}</span></td>";
                                                            }
                                                        } else {
                                                            $status = "Not attempted";
                                                            $value_bg = $status == "passed" || $status == "completed" ? "bg-green-2" : "bg-red-2";
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>{$status}</span></td>";
                                                        }
                                                        echo "</tr>";
                                                    }
                                                }
                                                //LTI start
                                                $stmt_lti = $offering->get_lti_score_card();
                                                if ($stmt_lti->rowCount() > 0) {
                                                    while ($row_lti = $stmt_lti->fetch(PDO::FETCH_ASSOC)) {
                                                        extract($row_lti);
							$consider_result_sc = 'No';
                                                    $consider_result_rc = 'No';
                                                    $consider_result = 'No';
                                                    $weightage1 = "";
                                                        $offering->lti_id = $lti_id;
                                                        $stmt_grade = $offering->get_gradeitem();
                                                        if ($stmt_grade->rowCount() > 0) {
                                                        echo "<tr class='bg-white shadow-2 rounded-8 border-light'>";
                                                        if (($result === "complete") || ($result === "incomplete")) {
                                                            $stmt_lti1 = $offering->get_lti_score_card_considered_active_inactive();
                                                            if ($stmt_lti1->rowCount() > 0) {
                                                                $consider_result_sc = 'Yes';
                                                                while ($row_lti1 = $stmt_lti1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_lti1);
                                                                    $weightage1 = $raw_grade_max;
                                                                }
                                                            }
                                                            $stmt_lti2 = $offering->get_lti_score_card_considered();
                                                            if ($stmt_lti2->rowCount() > 0) {
                                                                $consider_result_rc = 'Yes';
                                                                while ($row_lti2 = $stmt_lti2->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_lti2);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                            if (($consider_result_sc === 'Yes') || ($consider_result_rc === 'Yes')) {
                                                                $consider_result = 'Yes';
                                                            }
                                                        } else {
                                                            $stmt_lti1 = $offering->get_lti_score_card_considered();
                                                            if ($stmt_lti1->rowCount() > 0) {
                                                                $consider_result = 'Yes';
                                                                while ($row_lti1 = $stmt_lti1->fetch(PDO::FETCH_ASSOC)) {
                                                                    extract($row_lti1);
                                                                    $weightage1 = $weightage;
                                                                }
                                                            }
                                                        }
                                                    
                                                        $con_bg = $consider_result == "Yes" ? "bg-green-2" : "bg-red-2";

                                                        echo "<td>" . htmlentities($content_title) . "</td>";
                                                        echo "<td>"
                                                        . "<div class='about-content'>"
                                                        . "<div class='{$con_bg} about-content-list__icon'>";
                                                        if ($consider_result == "Yes") {
                                                            echo "<svg xmlns='http://www.w3.org/2000/svg' width='24'"
                                                            . " height='24' viewBox='0 0 24 24' fill='none'"
                                                            . "stroke='#000' stroke-width='2'"
                                                            . "stroke-linecap='round' stroke-linejoin='round'"
                                                            . "class='fa fa-check icon'>"
                                                            . "<polyline points='20 6 9 17 4 12'>"
                                                            . "</polyline>"
                                                            . "</svg>";
                                                        } else {
                                                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="24"
                                                                    height="24" viewBox="0 0 24 24" fill="none"
                                                                    stroke="#000" stroke-width="2"
                                                                    stroke-linecap="round" stroke-linejoin="round"
                                                                    class="fa fa-times icon">
                                                                    <line x1="18" y1="6" x2="6" y2="18"></line>
                                                                    <line x1="6" y1="6" x2="18" y2="18"></line>
                                                                </svg>';
                                                        }
                                                        echo "</div>"
                                                        . "</div></td>";
						 echo "<td><span class='text-11 rounded-16 lh-2 text-black bg-blue-6 py-5 px-5'>" . _("CRT2115") . "</span></td>";
                                                 $stmt_gt = $offering->get_gradeitem();
                                                  if ($row_gt = $stmt_gt->fetch(PDO::FETCH_ASSOC)) {
                                                    extract($row_gt);
                                                     echo "<td>" . $grade_pass ."</td>";
                                                  }else{
							echo "<td> --- </td>";
							} 
                                                   
                                                      //echo "<td>" . _("HM0119") . "</td>";                                                        
                                                        echo "<td>";
                                                        if ($weightage1 == "") {
                                                            echo '---';
                                                        } else {
                                                            echo $weightage1;
                                                        }
                                                        echo "</td>";
                                                        echo "<td>---</td>";
                                                        $raw_grade = "";
                                                        $lti_attempted = "N";
                                                        $stmt_track = $offering->check_content_track();
                                                        if ($stmt_track->rowCount() > 0) {
                                                            $lti_attempted = "Y";
                                                        }
                                                        if ($score_flag == "Yes") {
                                                            echo "<td>";
                                                            $stmt_lti2 = $offering->get_lti_score_user();
                                                            if ($row_lti2 = $stmt_lti2->fetch(PDO::FETCH_ASSOC)) {
                                                                extract($row_lti2);
                                                                if ($raw_grade != 0) {
//                                                                    if ($raw_grade_max != 0 && $raw_grade_max !=100) {
//                                                                        $xs=round((($raw_grade*100)/$raw_grade_max),2); 
//                                                                        echo $xs;
//                                                                    } else {
                                                                        echo $raw_grade;
//                                                                    }
                                                                } else {
                                                                    echo '---';
                                                                }
                                                            } else {
                                                                if($lti_attempted == 'Y'){
                                                                    echo 'Awaited';
                                                                }else{
                                                                    echo 'Not attempted';
                                                                }
                                                            }
                                                            echo "</td>";
                                                        }

                                                        $stmt_lti2 = $offering->get_lti_lesson_status_user();
                                                        if ($row_lti2 = $stmt_lti2->fetch(PDO::FETCH_ASSOC)) {
                                                            extract($row_lti2);
                                                            if($raw_grade >= $grade_pass ){
                                                               echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 bg-green-2 py-5 px-5'>Completed</span></td>";
                                                            }else{
                                                                echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 bg-red-2 py-5 px-5'>incomplete</span></td>";
                                                            }                                                        
							} else {
                                                            if($lti_attempted == 'Y'){
                                                                    $status = 'Awaited';
                                                                }else{
                                                                    $status ='Not attempted';
                                                                }
                                                            $value_bg = $status == "passed" || $status == "completed" ? "bg-green-2" : "bg-red-2";
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 {$value_bg} py-5 px-5'>{$status}</span></td>";
                                                        }
                                                        echo "</tr>";
                                                    }
                                                    }
                                                }
                                                //LTI end
                                                if ($result === "complete") {
                                                    $stmt8 = $offering->get_user_result();
                                                    if ($stmt8->rowCount() > 0) {
                                                        if ($row8 = $stmt8->fetch(PDO::FETCH_ASSOC)) {
                                                            $overall_score1 = $row8['score'];
                                                            $overall_result1 = $row8['result'];
                                                            $overall_result1_bg = $overall_result1 == "complete" ? "bg-green-2" : "bg-red-2";
                                                            echo "<tr class='bg-white shadow-2 rounded-8 border-light'>";
                                                            echo "<td colspan='6' class='text-right text-blue-3'>" . _("CRT4110") . "</td>";
                                                            if ($score_flag == "Yes") {
                                                                echo '<td class="text-blue-3">' . $overall_score1 . '</td>';
                                                            }
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 {$overall_result1_bg} py-5 px-5'>" . $overall_result1 . "</span></td>";
                                                            echo"</tr>";
                                                        }
                                                    }
                                                } else if ($result === "incomplete") {
                                                    $stmt8 = $offering->get_user_result();
                                                    if ($stmt8->rowCount() > 0) {
                                                        if ($row8 = $stmt8->fetch(PDO::FETCH_ASSOC)) {
                                                            $overall_score1 = $row8['score'];
                                                            $overall_result1 = $row8['result'];
                                                            $overall_result1_bg = $overall_result1 == "complete" ? "bg-green-2" : "bg-red-2";
                                                            echo '<tr class="bg-white shadow-2 rounded-8 border-light">
                                                                    <td colspan="6" class="score_incomplete" style="text-align:right;">Total</td>';
                                                            if ($score_flag == "Yes") {
                                                                echo '<td class="text-blue-3">' . $overall_score1 . '</td>';
                                                            }
                                                            echo "<td><span class='text-11 rounded-16 lh-2 text-blue-3 {$overall_result1_bg} py-5 px-5'>" . $overall_result1 . "</span></td>";
                                                            echo"</tr>";
                                                        }
                                                    }
                                                }
                                                echo "</tbody>";
                                                echo "</table>";
                                                echo "</div>";
                                                if (($result === "complete") || ($result === "incomplete")) {
                                                    echo "</div>";
                                                }
                                                echo "</div>";
                                                echo "</div>";
                                            }
                                            ?>
                                            <!--coaching report-->
                                            <?php
                                            if (($result === "complete") || ($result === "incomplete")) {
                                                if ($coaching_flag == "Yes") {
                                                    ?>
                                                    <div class="tabs__pane -tab-item-5">
                                                        <h2 class="text-20 fw-500 mt-10 pb-10 border-bottom-dark"><?php echo _("TB105"); ?>
                                                        </h2>

                                                        <div class="table-responsive mt-20">
                                                            <table class="table_report w-1/1">
                                                                <colgroup>
                                                                    <col style="width:25%">
                                                                    <col style="width:15%">
                                                                    <?php if ($score_flag == "Yes") { ?>
                                                                        <col style="width:15%">
                <?php } ?>
                                                                    <col style="width:20%">
                                                                    <col style="width:15%">
                                                                </colgroup>
                                                                <thead class="bg-color-primary">
                                                                    <tr>
                                                                        <?php
                                                                        echo "<th>" . _("CRT5101") . "</th>";
                                                                        echo "<th>" . _("CRT5105") . "</th>";
                                                                        if ($score_flag == "Yes") {
                                                                            echo "<th>" . _("CRT5102") . "(%)</th>";
                                                                        }
                                                                        echo "<th>" . _("CRT5103") . "</th>";
                                                                        echo "<th>" . _("CRT5104") . "</th>";
                                                                        ?>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    <?php
                                                                    $offering->offering_id = $offering_id;
                                                                    $offering->user_id = $_SESSION['uid'];
                                                                    $stmt_assmt_taken = $offering->total_assessment_taken();
                                                                    if ($stmt_assmt_taken->rowCount() > 0) {
                                                                        while ($row_assmt_taken = $stmt_assmt_taken->fetch(PDO::FETCH_ASSOC)) {
                                                                            echo "<tr class='bg-white shadow-1 rounded-8 border-light'>";
                                                                            echo "<td>" . $row_assmt_taken['assessment_name'] . "</td>";
                                                                            echo "<td>" . $row_assmt_taken['attempt_no'] . "</td>";
                                                                            if ($score_flag == "Yes") {
                                                                                echo "<td>";
                                                                                echo $row_assmt_taken['score'];
                                                                                echo "</td>";
                                                                            }
                                                                            echo "<td>";
                                                                            if ($row_assmt_taken['score'] >= $passing_score) {
                                                                                echo "<span class='text-11 rounded-16 text-blue-3 bg-green-2 py-5 px-5'>";
                                                                                echo _('CT0107');
                                                                            } else {
                                                                                echo "<span class='text-11 rounded-16 text-blue-3 bg-red-2 py-5 px-5'>";
                                                                                echo _('CRT5106');
                                                                            }
                                                                            echo "</span></td>";
                                                                            echo "<td><a href='coaching_report.php?oid=$offering_id&ano=" . $row_assmt_taken['attempt_no'] . "&aid=" . $row_assmt_taken['assessment_id'] . "' target='view_coaching_report' class='text-purple-1'>";
                                                                            echo _("CRT5104");
                                                                            echo "</a></td>";
                                                                            echo "</tr>";
                                                                        }
                                                                    } else {
                                                                        if ($score_flag == "Yes") {
                                                                            echo "<tr class='bg-white shadow-1 rounded-8 border-light'><td colspan='5'><center>";
                                                                            echo _("CR0502");
                                                                            echo "</center></td></tr>";
                                                                        } else {
                                                                            echo "<tr class='bg-white shadow-1 rounded-8 border-light'><td colspan='4'><center>";
                                                                            echo _("CR0502");
                                                                            echo "</center></td></tr>";
                                                                        }
                                                                    }
                                                                    ?>
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                    <?php
                                                }
                                            }
                                            ?>
                                            <!--Instructors-->
        <?php if ($total_inst > 0) { ?>
                                                <div class="tabs__pane -tab-item-6">
                                                    <h2 class="text-20 fw-500 mt-10 pb-10 border-bottom-dark">Instructor</h2>
                                                    <div id='instructor_list'>

                                                    </div>
                                                    <div class="d-flex justify-center pt-30 pb-10 load_more_instructor" >
                                                        <button class="text-purple-1 lh-12 underline fw-500" id="load_instructor"><?php echo _("IN0102") ?></button>
                                                    </div>
                                                </div>
        <?php } ?>

                                            <!--Review tab-->
        <?php $rating_count = 0; ?>
                                            <div class="tabs__pane -tab-item-7" >
                                                <div id='review_list'>

                                                </div>
                                                <div class="d-flex justify-center pt-30 pb-10 load_more_review" >
                                                    <button class="text-purple-1 lh-12 underline fw-500" id="load_review"><?php echo _("CRT6110") ?></button>
                                                </div>
                                            </div>
                                            <!--Course Notes tab-->
                                            <div class="tabs__pane -tab-item-8">
                                                <h2 class='text-20 fw-500 mt-10 pb-10 border-bottom-dark'> <?php echo _("CRT6112"); ?></h2>
                                                <div class="px-0" id="course_notes">
                                                    <a href="javascript:void(0);" class="text-14 ml-5"><i class="fa fa-pencil"></i>&nbsp;Edit</a>
                                                </div>
                                                <br/>
                                                <?php
                                                if ($course_notes != "") {
                                                    $dateTime = new DateTime($course_last_updated_ts, new DateTimeZone('Asia/Kolkata'));
                                                    $course_notes_time = $dateTime->format("M d,Y  h:i A");
                                                    ?>
                                                    <div><?php echo nl2br(htmlentities($course_notes)); ?></div>
                                                    <p class='text-12 mt-10'><?php echo _("CRT6109") . $course_notes_time ?></p>
                                                <?php } else { ?>
                                                    <div><?php echo _("CRT6115") ?></div>
        <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </section>

                        <!--Instructions for assessment-->
                        <div class="modal fade" id="assessment_take_test_modal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <div class="d-flex justify-between items-center">
                                            <h2 class="modal-title text-17 lh-1 fw-500">Instructions</h2>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="modal-body bg-primary-opacity-1 scrollermodal" id="assmt_in">

                                    </div>
                                    <div class="modal-footer">
                                        <div class="d-flex justify-center">
                                            <button type="button" class="text-16 button -icon px-50 py-0 bg-color-primary text-white" onclick="proceed();">
        <?php echo _("CRT3107"); ?>
                                            </button>
                                            &nbsp;
                                            <button type="button" class="text-16 button -icon px-50 py-0 -secondary-1 text-white" data-dismiss="modal"><?php echo _("AS0156") ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Certificate modal-->
                        <div class="modal fade" id="certifcate_modal" tabindex="-1" role="dialog">
                            <div class="modal-dialog modal-lg" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <div class="d-flex justify-between items-center">
                                            <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("CR0109") ?></h2>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="modal-body bg-primary-opacity-1" id="certificate_detail">

                                    </div>
                                    <div class="modal-footer">
                                        <div class="d-flex justify-center">
                                            <button class="text-16 button -icon px-50 py-0 -secondary-1 text-white" data-dismiss="modal"><?php echo _("AS0156") ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Rating modal-->
                        <div class="modal fade" id="rating_modal" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <div class="d-flex justify-between items-center">
                                            <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("CRT6104") ?></h2>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="modal-body">
                                        <div id="error_rating" class='text-red-1 ml-5 mb-5'><?php echo _("CRT6108"); ?></div>
                                        <div id="success_rating"><?php echo _("CRT6201"); ?></div>
                                        <div class="d-flex justify-center">
                                            <fieldset class="rate">
                                                <input type="radio" id="5star" name="rating" value="5" />
                                                <label for="5star" title="5 stars"></label>
                                                <input type="radio" id="4halfstar" name="rating" value="4.5" />
                                                <label class="half" for="4halfstar" title="4 1/2 stars"></label>
                                                <input type="radio" id="4star" name="rating" value="4" />
                                                <label for="4star" title="4 stars"></label>
                                                <input type="radio" id="3halfstar" name="rating" value="3.5" />
                                                <label class="half" for="3halfstar" title="3 1/2 stars"></label>
                                                <input type="radio" id="3star" name="rating" value="3" />
                                                <label for="3star" title="3 stars"></label>
                                                <input type="radio" id="2halfstar" name="rating" value="2.5" />
                                                <label class="half" for="2halfstar" title="2 1/2 stars"></label>
                                                <input type="radio" id="2star" name="rating" value="2" />
                                                <label for="2star" title="2 stars"></label>
                                                <input type="radio" id="1halfstar" name="rating" value="1.5" />
                                                <label class="half" for="1halfstar" title="1 1/2 stars"></label>
                                                <input type="radio" id="1star" name="rating" value="1" />
                                                <label for="1star" title="1 star"></label>
                                            </fieldset>
                                        </div>

                                        <div class='clearfix'></div>

                                        <p class='fw-500 text-16 mb-5 pl-5'><?php echo _("CRT6105"); ?></p>
                                        <form class='contact-form'>
                                            <textarea id='comment' name="comment" placehoder="Text.." cols='45' rows='8' class='text-16 px-10 py-10' aria-required='true' maxLength="1000" ><?php echo $comment; ?></textarea>
                                        </form>
                                    </div>
                                    <div class='modal-footer'>
                                        <div class='d-flex justify-center'>
                                            <button type="submit" id="submit" class='text-16 button -icon px-50 py-0 bg-color-primary text-white submit'>
        <?php echo _("CRT6106"); ?>
                                            </button>&nbsp;
                                            <button class='text-16 button -icon px-50 py-0 -secondary-1 text-white'
                                                    data-dismiss='modal'><?php echo _("CRT6107"); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--Course notes modal-->
                        <div class="modal fade" id="notes_modal" tabindex="-1" role="dialog">
                            <div class="modal-dialog" role="document">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <div class="d-flex justify-between items-center">
                                            <h2 class="modal-title text-17 lh-1 fw-500"><?php echo _("CRT6112"); ?></h2>
                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                <span aria-hidden="true">&times;</span>
                                            </button>
                                        </div>
                                    </div>
                                    <div class="modal-body">
                                        <div id="error_notes" class='text-red-1 ml-5 mb-5'><?php echo _("CRT6114"); ?></div>
                                        <div id="success_notes" class='text-green-5 ml-5 mb-5'><?php echo _("CRT6202"); ?></div>
                                        <p class='fw-500 text-16 mb-5 pl-5'><?php echo _("CRT6113"); ?></p>
                                        <form class='contact-form'>
                                            <textarea id='course_notes_des' placehoder="Text.." cols='45' rows='8' class='text-16 px-10 py-10' aria-required='true' maxLength="1000" ><?php echo $course_notes; ?></textarea>
                                        </form>
                                    </div>
                                    <div class='modal-footer'>
                                        <div class='d-flex justify-center'>
                                            <?php
                                        $users->user_id = $_SESSION['uid'];
                                        $ai = $users->getUserConfig('ai_enable_notes');
                                        // var_dump($ai);
                                        if ($ai == "Yes") {
                                        ?>
                                            <button type="button" id="generate_notes_from_ai" class='text-16 button -icon px-50 py-0 bg-color-primary text-white submit'>
                                               <?php echo _("CRT6116"); ?>
                                            </button>&nbsp;
                                        <?php } ?>
                                            <button type="button" id="submit_notes" class='text-16 button -icon px-50 py-0 bg-color-primary text-white submit'>
                                            <?php echo _("CRT6106"); ?>
                                            </button>&nbsp;
                                            <button class='text-16 button -icon px-50 py-0 -secondary-1 text-white'
                                                    data-dismiss='modal'><?php echo _("CRT6107"); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
    <?php } ?>
                </div>
            </main>
    <?php include "./footer_primary.php"; ?>
<script type="module">
            document.getElementById('generate_notes_from_ai').addEventListener('click', async function(event) {
                event.preventDefault();

                console.log("Generate notes button clicked.");
                const notesTextarea = document.querySelector('#course_notes_des');

                if (notesTextarea.value.trim() !== '') {
                    const proceed = confirm("If generated, previous notes will be lost. Do you want to continue?");
                    // If user cancels, ensure textarea is still editable if it was before.
                    // notesTextarea.removeAttribute("readonly");
                    // notesTextarea.removeAttribute("disabled");
                    // return;

                    if (!proceed) return;
                }

                notesTextarea.value = 'Generating notes... Please wait.';
                notesTextarea.removeAttribute("readonly");
                notesTextarea.removeAttribute("disabled");

                try {
                    var offer = "<?php echo $offering_id ?>";
                    var user = "<?php echo $user_id ?>";

                    const notes = await showContent(offer, user);
                    notesTextarea.value = notes;
                    notesTextarea.removeAttribute("readonly");
                    notesTextarea.removeAttribute("disabled");
                    notesTextarea.focus();


                } catch (error) {
                    console.error("Error in generating notes:", error);
                    alert("Something went wrong.");
                    notesTextarea.value = 'Failed to generate notes. Please try again.'; // Inform the user
                    notesTextarea.removeAttribute("readonly"); // Ensure it's still editable for manual input
                    notesTextarea.removeAttribute("disabled");
                }

                // document.getElementById('submit_notes').click();

            });

            function showContent(offerParam, userParam, idParam, mode = 'notes') {
                const csrf_token = $('meta[name="csrf-token"]').attr('content');
                return new Promise((resolve, reject) => {
                    $.ajax({
                        url: 'modules/ai_notes.php',
                        data: {
                            offer: offerParam,
                            uid: userParam,
                            mode: mode,
                            csrf_token: csrf_token
                        },
                        type: 'POST',
                        dataType: "json",
                        success: function(response) {
                            console.log("Success response from showContent (GET mode=notes):", response);
                            if (response.success && response.notes) {
                                resolve(response.notes);
                            } else {
                                const errorMessage = response.message || "Invalid response format or no notes found.";
                                alert("Error fetching content for notes: " + errorMessage);
                                reject(new Error("Server error fetching notes: " + errorMessage));
                            }

                        },
                        error: function(jqXHR, textStatus, errorThrown) {
                            reject(new Error(`AJAX error: ${textStatus} - ${errorThrown}`));
                        }
                    });
                });
            }
        </script>
          
            <script>
               
                var oid = "<?php echo $offering_id; ?>";
                var uid = "<?php echo $user_id; ?>";
                var totalinst = "<?php echo $total_inst; ?>";

                var page = 1;
                var page_review = 1;
                var total_review = 0;

                $(document).ready(function () {
                    $('.tabs__controls button:first').addClass('is-active-tab');
                    $('.tabs__content div:first').addClass('is-active-tab');
                    //display tab by url
                    var url = document.location.toString();
                    if (url.match('#')) {
                        var val = "";
                        if (url.match('data_')) {
                            val = "content";
                        } else {
                            val = url.split('#')[1];
                        }
                        $('.tabs__controls button').removeClass('is-active-tab');
                        $('.tabs__controls button[name="' + val + '"]').addClass('is-active-tab');
                        var target = ($('.tabs__controls button[name="' + val + '"]').attr('data-tab-target')).split(".")[1];
                        $('.tabs__content div').removeClass('is-active-tab');
                        $('.tabs__content div[class="tabs__pane ' + target + '"]').addClass('is-active-tab');
                    }

                    //display content count
                    $(".lesson_count").text("<?php echo $lesson_content_count; ?>");
                    //launch content

                    var launchCon = "<?php echo $launchContent; ?>";
                    var launchAss = '<?php echo $launchAssessment; ?>';
                    if (launchCon !== "") {
                        $("#launchcontent").attr("href", launchCon);
                        $("#launchcontent1").attr("href", launchCon);
                    } else {
                        if (launchAss !== "") {
                            $("#launchcontent").attr("onclick", launchAss);
                            $("#launchcontent1").attr("onclick", launchAss);
                        }
                    }

                    //Review
                    read_review('first');

                    //Instructor
                    if (~~totalinst > 0) {
                        read_instructor();
                        page++;
                    }
                });

             
                $('.tabs__controls > button[name="score_card"]').click(function () {
                   $("#read_scorecard").load(location.href + " #read_scorecard");
                });
   

                //expand all
                function expand_all() {
                    const targets = document.querySelectorAll(".js-accordion");
                    for (let i = 0; i < targets.length; i++) {
                        const items = targets[i].querySelectorAll('.accordion__item');
                        for (let l = 0; l < items.length; l++) {
                            const button = items[l].querySelector('.accordion__button');
                            const content = items[l].querySelector('.accordion__content');

                            items[l].classList.toggle('is-active');

                            if (content.style.maxHeight) {
                                content.style.maxHeight = null
                            } else {
                                content.style.maxHeight = content.scrollHeight + "px"
                            }
                        }
                    }
                }

                //read_score card
                $(document).on('click', '#show_all', function () {
                    if ($(this).prop("checked") == true) {
                        var offer = "<?php echo $offering_id; ?>";
                        var user = "<?php echo $user_id; ?>";
                        var score_flag = "<?php echo $score_flag ?>";
                        $.ajax({
                            url: 'modules/score_card_all_load.php',
                            data: {"offer": offer, "user": user, "score_flag": score_flag},
                            type: 'GET',
                            dataType: "html",
                            success: function (response) {
                                if (response !== "") {
                                    $('.assessment_row').replaceWith(response);
                                } else {
                                 $("#read_scorecard").load(location.href + " #read_scorecard");
                                }
                            },
                            error: function (data) {
                            }
                        });
                    } else {
                  $("#read_scorecard").load(location.href + " #read_scorecard");
                    }
                });

                //print        
                function scorecardPrint(name) {
                    printElement(document.getElementById("printThis"), name);
                }

                function printElement(elem, name) {
                    var domClone = elem.cloneNode(true);
                    var $printSection = document.getElementById("printSection");
                    if (!$printSection) {
                        var $printSection = document.createElement("div");
                        $printSection.id = "printSection";
                        document.body.appendChild($printSection);
                    }
                    $printSection.innerHTML = "";
                    $printSection.appendChild(domClone);
                    document.title = name;
                    window.print();
                }

                //view certificate
                function viewCertificate(id, mode) {
                    $.ajax({
                        url: "modules/certificate_modal.php",
                        data: {"id": id, "mode": mode},
                        dataType: "html",
                        type: 'GET',
                        success: function (data) {
                            $('#certificate_detail').html(data);
                            jQuery('#certifcate_modal').modal("show");
                        }
                    });
                }
                $('.close, .click').on('click', function (event) {
                        event.stopPropagation();
                        $('#certifcate_modal').modal('hide');
                });
                $('.close, .click').on('click', function (event) {
                    event.stopPropagation();
                        $('#assessment_take_test_modal').modal('hide');});

                //Assessment
                function takeTest(cAttempt, mAttempt, score, pScore, aid, oid, duration, pScore1) {
                    if (~~pScore1 == 0) {
                        pScore1 = pScore;
                    }
                    if (~~score >= ~~pScore1) {
                        alert("<?php echo _("AS0107") ?>");
                    } else if (~~cAttempt > ~~mAttempt) {
                        alert("<?php echo _("AS0109") ?>");
                    } else {
                        var oid = oid;
                        var aid = aid;
                        $.ajax({
                            url: 'assessment/quiz_check.php',
                            data: {"aid": aid, "oid": oid},
                            dataType: "html",
                            type: 'GET',
                            success: function (data) {
                                var d = data;
                                if (d === 1) {
                                    alert("Cannot take the assessment.\n\Either you have exhausted all attempts or passed the assessment.\n\Please go to active courses");
                                    window.location = "active.php";
                                } else {
                                    var ps = pScore;
                                    var ca = cAttempt;
                                    var tl = duration;
                                    $.ajax({
                                        url: "assessment/assmt_modal.php",
                                        data: {"oid": oid, "aid": aid, "ps": ps, "ca": ca, "tl": tl},
                                        dataType: "html",
                                        type: 'GET',
                                        success: function (data) {
                                            $('#assmt_in').html(data);
                                            jQuery('#assessment_take_test_modal').modal("show");
                                        }
                                    });
                                }
                            }
                        });
                    }
                }

                function proceed() {
                    jQuery('#assessment_take_test_modal').modal("hide");
                    var oid = $('#oid').val();
                    var aid = $('#aid').val();
                    //const csrf_token = $('meta[name="csrf-token"]').attr('content');
                   const csrf_token = $('meta[name="csrf-token"]').attr('content');
                    var width = window.innerWidth;
                    var height = window.innerHeight;
                    var winName = 'MyWindow';
                    var winURL = 'quiz_assessment.php';
                    var windowoption = 'width=' + width + ', height=' + height + ',scrollbars=yes,toolbar=no, location=0, directories=no, status=no, menubar=no, resizable=no, copyhistory=no,top=' + ((window.innerHeight - height) / 2) + ', left=' + ((window.innerWidth - width) / 2);
                    var params = {'oid': oid, 'aid': aid,'csrf_token': csrf_token};
                    var form = document.createElement("form");
                    form.setAttribute("method", "post");
                    form.setAttribute("action", winURL);
                    form.setAttribute("target", winName);
                    for (var i in params) {
                        if (params.hasOwnProperty(i)) {
                            var input = document.createElement('input');
                            input.type = 'hidden';
                            input.name = i;
                            input.value = params[i];
                            form.appendChild(input);
                        }
                    }
                    document.body.appendChild(form);
                    window.open('', winName, windowoption);
                    form.target = winName;
                    form.submit();
                    document.body.removeChild(form);
                }

                window.CallParent = function () {
                    $("#assessment").load(location.href + " #assessment>*", "");
                    $("#score_div").load(location.href + " #score_div>*", "");
                };

                // Review 
                function read_review(value) {
                    $.ajax({
                        url: 'modules/read_review.php',
                        data: {"offering_id": oid, "page": page_review, "mode": value},
                        dataType: "html",
                        async: false,
                        type: 'GET',
                        success: function (data) {
                            data = JSON.parse(data);
                            $('#review_list').append(data.html);
                            total_review = data.total;
                            var numItems = $('.comment').length;
                            if (~~numItems === 0) {
                                $('.load_more_review').removeClass('d-flex');
                                $('.load_more_review').hide();
                            } else {
                                $('.load_more_review').show();
                            }
                            if (~~numItems === ~~total_review) {
                                $('.load_more_review').removeClass('d-flex');
                                $('.load_more_review').hide();
                            } else {
                                $('.load_more_review').show();
                            }
                        }, error: function () {
                            alert("<?php echo _("GN0401"); ?>");
                        }
                    });
                }

                $('#load_review').click(function () {
                    read_review('load');
                    page_review++;
                });

                function read_instructor() {
                    $.ajax({
                        url: 'modules/read_instructor.php',
                        data: {"offering_id": oid, "page": page},
                        dataType: "html",
                        type: 'GET',
                        success: function (data) {
                            data = JSON.parse(data);
                            $('#instructor_list').append(data.html);
                            var numItems = $('.instructor').length;
                            if (~~numItems === 0) {
                                $('.load_more_instructor').removeClass('d-flex');
                                $('.load_more_instructor').hide();
                            } else {
                                $('.load_more_instructor').show();
                            }
                            if (~~numItems === ~~totalinst) {
                                $('.load_more_instructor').removeClass('d-flex');
                                $('.load_more_instructor').hide();
                            } else {
                                $('.load_more_instructor').show();
                            }
                        }, error: function () {
                            alert(_("GN0401"));
                        }
                    });
                }

                $('#load_instructor').click(function () {
                    read_instructor();
                    page++;
                });

                $('.submit').click(function () {
                    var radioValue = $("input[name='rating']:checked").val();
                    if (typeof radioValue != 'undefined') {
                        insert(radioValue);
                        $('#review_list').html('');
                        page_review = 1;
                        read_review('first');
                        page_review++;
                        $("#review_list").load(location.href + "#review_list>*", "");
                    } else {
                        $('#error_rating').fadeIn('slow', function () {
                            $('#error_rating').delay(5000).fadeOut();
                        });
                    }
                });

                $(document).on('click', '#rating_review_modal', function () {
                    $('#success_rating').hide();
                    $('#error_rating').hide();
                    var offering_id = "<?php echo $offering_id ?>";
                    var user_id = "<?php echo $user_id ?>";
                    const csrf_token = $('meta[name="csrf-token"]').attr('content');
                    $.ajax({
                        url: 'modules/rating_review_load.php',
                        type: 'post',
                        data: {"offering_id": offering_id, "user_id": user_id, "csrf_token": csrf_token},
                        success: function (data) {
                            var array = data.split('<br/>');
                            var rating = array[0];
                            var comment = array[1];
                            $('#comment').val(comment);
                            jQuery('input[name=rating][value="' + rating + '"]').attr('checked', true);
                            // Display Modal
                            jQuery('#rating_modal').modal({show: true});
                        }
                    });
                });
                $('.close, .click').on('click', function (event) {
                    event.stopPropagation();
                        $('#rating_modal').modal('hide');
                    });

                //insert rating
                function badWordCatch(comment) {
                    wordInput = comment.toLowerCase();
                    // split the words by spaces (" ")
                    var arr = wordInput.split(" ");
                    // bad words to look for, keep this array in lowercase
                    var badWords = ["legos", "cloud", "manifold"];
                    // .toLowerCase will do the case insensitive match!
                    var foundBadWords = arr.filter(el => badWords.includes(el));
                    if (foundBadWords.length == 0) {
                        return false;
                    } else {
                        alert("<?php echo _("RV0102") ?>");
                        return false;
                    }
                }

                function insert(rating) {
                    var user = $('#user').val();
                    var offer = $('#offer').val();
                    var comment = $.trim($('#comment').val());
                    const csrf_token = $('meta[name="csrf-token"]').attr('content');
                    badWordCatch(comment);
                    if (~comment.indexOf("http://") != 0 || ~comment.indexOf("https://") != 0) {
                        alert("<?php echo _("RV0101") ?>");
                        return false;
                    }
                    $.ajax({
                        url: 'modules/review.php',
                        data: {"user_id": user, "offering_id": offer, "rating": rating, "comment": comment, "csrf_token":csrf_token},
                        dataType: "html",
                        async: false,
                        type: 'POST',
                        success: function (data) {
                            data = $.trim(data);
                            if (~~data === 1) {
                                $('#success_rating').show();
                                $("#show_rating").load(location.href + " #show_rating");
                                jQuery.noConflict();
                                jQuery('#rating_modal').modal('hide');
                                location.reload(true);
                            } else if (~~data === 2) {
                                alert("<?php echo _("GN0401") ?>");
                            }

                        }, error: function () {
                            alert("<?php echo _("GN0401") ?>");
                        }
                    });
                }
                
                function ReportReview(Obj, rating_id) {
                    var title = Obj.title;
                    var msg = "";
                    if (title === "Unabuse") {
                        msg = "Are you sure want to unabusive this review?";
                    } else {
                        msg = "Are you sure want to report this review as abuse?";
                    }
                    var user = $('#user').val();
                    var offer = $('#offer').val();
                    const csrf_token = $('meta[name="csrf-token"]').attr('content');
                    if (confirm(msg) == true) {
                        $('#loader' + rating_id + '').show();
                        Obj.disabled = true;
                        $.ajax({
                            url: 'modules/review_spam.php',
                            data: {"user_id": user, "offering_id": offer, "rating": rating_id, "title": title, "csrf_token": csrf_token},
                            dataType: "html",
                            type: 'POST',
                            success: function (data) {
                                $(Obj).find('i').toggleClass('fa fa-ban fa fa-exclamation');
                                if (title == "Report") {
                                    $(Obj).prop('title', 'Unabuse');
                                    $(Obj).find('.text_rate').text('Unabuse');
                                    // $(Obj).text('Unabuse');
                                } else {
                                    $(Obj).prop('title', 'Report');
                                    $(Obj).find('.text_rate').text('Report ');
                                    //$(Obj).text('Report Abuse');
                                }
                                $('#loader' + rating_id + '').hide();
                                Obj.disabled = false;
                            }, error: function () {
                                alert("<?php echo _("GN0401") ?>");
                                $('#loader' + rating_id + '').hide();
                                Obj.disabled = false;
                            }
                        });
                    }
                }

                //enter key press 
                $(document).on('keydown', function (e) {
                    if (document.activeElement.nodeName != "TEXTAREA") {
                        if (e.which === 13) {
                            if ($('#s').val() == "") {
                                e.preventDefault();
                                if ($("#submit").length) {
                                    $('#submit').trigger('click');
                                }
                                if ($("#submit_notes").length) {
                                    $('#submit_notes').trigger('click');
                                }
                            } else {
                                window.location = "search.php?s=" + $('#s').val() + "";
                            }
                        }
                    }
                });

                $('button[data-tab-target=".-tab-item-3"]').click(function () {
                    $("#read_assessment").load(location.href + " #read_assessment");
                });

                //$('button[data-tab-target=".-tab-item-4"]').click(function () {
                //  $("#read_scorecard").load(location.href + " #read_scorecard");
                //});

                $(document).on('click', '#course_notes', function () {
                    $('#success_notes').hide();
                    $('#error_notes').hide();
                    var offering_id = "<?php echo $offering_id ?>";
                    var user_id = "<?php echo $user_id ?>";
                    const csrf_token = $('meta[name="csrf-token"]').attr('content');

                    $.ajax({
                        url: 'modules/notes_load.php',
                        type: 'post',
                        data: {"offering_id": offering_id, "user_id": user_id, "csrf_token": csrf_token},
                        success: function (data) {
                            $('#course_notes_des').val(data);
                            // Display Modal
                            jQuery('#notes_modal').modal({show: true});
                        }
                    });
                });
                $('.close, .click').on('click', function (event) {
                    event.stopPropagation();
                        $('#notes_modal').modal('hide');
                     });

                $(document).on('click', '#submit_notes', function () {
                    var offer = "<?php echo $offering_id ?>";
                    var user = "<?php echo $user_id ?>";
                    var course_notes = $.trim($('#course_notes_des').val());
                    const csrf_token = $('meta[name="csrf-token"]').attr('content');
                    if (course_notes === "") {
                        $('#error_notes').show();
                    } else {
                        $('#error_notes').hide();
                        $.ajax({
                            url: 'modules/notes.php',
                            data: {"user_id": user, "offering_id": offer, "course_notes": course_notes,"csrf_token":csrf_token},
                            dataType: "html",
                            async: false,
                            type: 'POST',
                            success: function (data) {
                                $('#success_notes').show();
                                $("#course_notes_show").load(location.href + " #course_notes_show");
                                jQuery('#notes_modal').modal('hide');
                                location.reload(true);
                            }, 
                            // error: function () {
                            //     alert("<?php echo _("GN0401") ?>");
                            // }
                            error: function(jqXHR, textStatus, errorThrown) {
                                console.error("Error saving notes:", textStatus, errorThrown, jqXHR.responseText);
                                alert("<?php echo _("GN0401") ?>: " + textStatus + " - " + errorThrown);
                                $('#error_notes').text("<?php echo _("GN0401") ?>").show();
                                $('#success_notes').hide();
                            }
                        });
                    }
                });

              
            </script>
        </body>
    </html>
<?php  ?>