<?php
/// start session 
session_start();
    include 'config/database.php';
    include_once "security/session_config.php";
    // connect to database
    
    include_once 'config/properties.php';
    include_once "resources/manageusers.php";
    include_once "resources/EncryptDecrypt.php";

    $users = new ManageUsers();

    // set page title
    $page_no = 7;
    $user_id = $_SESSION['uid'];
    $separator = ',';
    ?>
    <!DOCTYPE>
    <html lang="en">
        <head>
            <?php include "./head.php" ?>
            <title>
                <?php echo _("LB0107"); ?>
            </title>
            <link rel="stylesheet" href="assets/css/contact/style.css">
        </head>
        <body>
            <main class="main-content">
                <?php include "./menu_primary.php"; ?>
                <div class="content-wrapper js-content-wrapper">
                    <section class="section-bg pt-25 pb-10 mb-50">
                        <div class="section-bg__item -full -height-half bg-color-primary"></div>

                        <div class="container animated mb-50">
                            <div class="row justify-center text-center">
                                <div class="col-auto">
                                    <div class="sectionTitle ">
                                        <h2 class="sectionTitle__title text-white"><?php echo _("CU0107"); ?> </h2>
                                        <p class="sectionTitle__text text-white"><?php echo _("INF0104") ?></p>
                                    </div>
                                </div>
                            </div>

                            <div class="row y-gap-30 justify-between pt-20 lg:pt-10 pl-30 pr-30">

                                <div class="col-lg-3 col-md-6 is-in-view">
                                    <div class="coursesCard -type-5 text-center pt-50 pb-40 px-30 rounded-8 bg-white shadow-2 h-100">
                                        <div class="coursesCard__image">
                                            <img src="assets/images/icons/phone.svg" alt="image">
                                        </div>
                                        <div class="coursesCard__content mt-30">
                                            <h5 class="coursesCard__title text-18 lh-1 fw-500"><?php echo _("CU0102") ?></h5>
                                            <p class="coursesCard__text text-14 mt-10">
                                                <?php
                                                if ($row_company['phone_no'] != "") {
                                                    $vals = explode($separator, $row_company['phone_no']);
                                                    foreach ($vals as $val) {
                                                        echo trim($val);
                                                        ?>
                                                        <br />
                                                        <?php
                                                    }
                                                } else {
                                                    echo _("CU0103");
                                                }
                                                ?></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6 is-in-view">
                                    <div class="coursesCard -type-5 text-center pt-50 pb-40 px-30 rounded-8 bg-white shadow-2 h-100">
                                        <div class="coursesCard__image">
                                            <img src="assets/images/icons/location.svg" alt="image">
                                        </div>
                                        <div class="coursesCard__content mt-30">
                                            <h5 class="coursesCard__title text-18 lh-1 fw-500"><?php echo _("CU0101") ?></h5>
                                            <p class="coursesCard__text text-14 mt-10"><?php echo htmlentities($row_company['address_line1']); ?><br/>
                                                <?php
                                                if ($row_company['address_line2'] != "") {
                                                    echo htmlentities($row_company['address_line2']);
                                                    ?><br/>
                                                <?php } ?>
                                                <?php echo htmlentities($row_company['city']) . ' ' . htmlentities($row_company['state']); ?><br/>
                                                <?php echo htmlentities($row_company['country']) . ' - ' . htmlentities($row_company['pin_code']); ?></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6 is-in-view">
                                    <div class="coursesCard -type-5 text-center pt-50 pb-40 px-30 rounded-8 bg-white shadow-2 h-100">
                                        <div class="coursesCard__image">
                                            <img src="assets/images/icons/email.svg" alt="image">
                                        </div>
                                        <div class="coursesCard__content mt-30">
                                            <h5 class="coursesCard__title text-18 lh-1 fw-500"><?php echo _("CU0104") ?></h5>
                                            <p class="coursesCard__text text-14 mt-10">   <?php
                                                if ($row_company['email_id'] != "") {
                                                    $vals = explode($separator, htmlentities($row_company['email_id']));
                                                    foreach ($vals as $val) {
                                                        echo trim($val);
                                                        ?>
                                                        <br />
                                                        <?php
                                                    }
                                                } else {
                                                    echo _("CU0105");
                                                }
                                                ?></p>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-lg-3 col-md-6 is-in-view">
                                    <div class="coursesCard -type-5 text-center pt-50 pb-40 px-30 rounded-8 bg-white shadow-2 h-100">
                                        <div class="coursesCard__image">
                                            <img src="assets/images/icons/link.svg" alt="image">
                                        </div>
                                        <div class="coursesCard__content mt-30">
                                            <h5 class="coursesCard__title text-18 lh-1 fw-500"><?php echo _("CU0106") ?></h5>
                                             <p class="coursesCard__text text-14 mt-10"> <?php
                                                if ($row_company['website_link'] != "") {
                                                    echo "<a href=". $row_company['website_link'] . " class='text-blue-3' target='_blank'><i class='fa fa-globe fa-lg'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
                                                } if ($row_company['linkedin_link'] != "") {
                                                    echo "<a href=". $row_company['linkedin_link'] . " class='text-blue-3' target='_blank'><i class='fa fa-linkedin fa-lg'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
                                                }
                                                if ($row_company['facebook_link'] != "") {
                                                    echo "<a href=". $row_company['facebook_link'] . " class='text-blue-3' target='_blank'><i class='fa fa-facebook fa-lg'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
                                                }
                                                if ($row_company['youtube_link'] != "") {
                                                    echo "<a href=". $row_company['youtube_link'] . " class='text-blue-3' target='_blank'><i class='fa fa-youtube fa-lg'></i></a>&nbsp;&nbsp;&nbsp;&nbsp;";
                                                }
                                                if ($row_company['twitter_link'] != "") {
                                                    echo "<a href=". $row_company['twitter_link'] . " class='text-blue-3' target='_blank'><i class='fa fa-twitter fa-lg'></i></a>";
                                                }
                                                ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </section>

                    <?php include "./footer_primary.php" ?>
                </div>
            </main>
        </body>
    </html>

